--TEST--
round() with different rounding modes
--FILE--
<?php
$modes = [
    "PHP_ROUND_HALF_UP" => PHP_ROUND_HALF_UP,
    "PHP_ROUND_HALF_DOWN" => PHP_ROUND_HALF_DOWN,
    "PHP_ROUND_HALF_EVEN" => PHP_ROUND_HALF_EVEN,
    "PHP_ROUND_HALF_ODD" => PHP_ROUND_HALF_ODD,
];

$numbers = [
    2.5,
    -2.5,
    3.5,
    -3.5,
    7,
    -7,
    0.61,
    0.69,
    0,
    1.9999,
    -1.9999,
    0.0001,
    -0.0001,
];
$precisions = [0, 1, 2, 10];

foreach ($modes as $modeKey => $mode) {
    echo "mode: $modeKey\n";
    foreach ($precisions as $precision) {
        echo "\tprecision: $precision\n";
        foreach ($numbers as $number) {
            $result = round($number, $precision, $mode);
            echo "\t\t" .
                str_pad($number, 7, " ", STR_PAD_LEFT) .
                " => $result\n";
        }
        echo "\n";
    }
}

?>
--EXPECT--
mode: PHP_ROUND_HALF_UP
	precision: 0
		    2.5 => 3
		   -2.5 => -3
		    3.5 => 4
		   -3.5 => -4
		      7 => 7
		     -7 => -7
		   0.61 => 1
		   0.69 => 1
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 1
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.6
		   0.69 => 0.7
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 2
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 10
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 1.9999
		-1.9999 => -1.9999
		 0.0001 => 0.0001
		-0.0001 => -0.0001

mode: PHP_ROUND_HALF_DOWN
	precision: 0
		    2.5 => 2
		   -2.5 => -2
		    3.5 => 3
		   -3.5 => -3
		      7 => 7
		     -7 => -7
		   0.61 => 1
		   0.69 => 1
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 1
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.6
		   0.69 => 0.7
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 2
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 10
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 1.9999
		-1.9999 => -1.9999
		 0.0001 => 0.0001
		-0.0001 => -0.0001

mode: PHP_ROUND_HALF_EVEN
	precision: 0
		    2.5 => 2
		   -2.5 => -2
		    3.5 => 4
		   -3.5 => -4
		      7 => 7
		     -7 => -7
		   0.61 => 1
		   0.69 => 1
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 1
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.6
		   0.69 => 0.7
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 2
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 10
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 1.9999
		-1.9999 => -1.9999
		 0.0001 => 0.0001
		-0.0001 => -0.0001

mode: PHP_ROUND_HALF_ODD
	precision: 0
		    2.5 => 3
		   -2.5 => -3
		    3.5 => 3
		   -3.5 => -3
		      7 => 7
		     -7 => -7
		   0.61 => 1
		   0.69 => 1
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 1
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.6
		   0.69 => 0.7
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 2
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 2
		-1.9999 => -2
		 0.0001 => 0
		-0.0001 => -0

	precision: 10
		    2.5 => 2.5
		   -2.5 => -2.5
		    3.5 => 3.5
		   -3.5 => -3.5
		      7 => 7
		     -7 => -7
		   0.61 => 0.61
		   0.69 => 0.69
		      0 => 0
		 1.9999 => 1.9999
		-1.9999 => -1.9999
		 0.0001 => 0.0001
		-0.0001 => -0.0001
