/* Generated by re2c 2.0.3 on Mon Aug 31 12:21:15 2020 */
#line 1 "parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, int error_code, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, char *error, const char *sptr, const char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, char *error, const char *sptr, const char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(const char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(const char **ptr, int max_length, int *scanned_length)
{
	const char *begin, *end;
	char *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(const char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(const char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(const char **ptr, int max_length)
{
	const char *begin, *end;
	char *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(const char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(const char **ptr, int *behavior)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(const char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(const char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(const char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(const char **ptr)
{
	char *word;
	const char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(const char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(const char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	const char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(const char **ptr)
{
	const char *begin = *ptr, *end;
	timelib_long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			return sHOUR(strtol(begin, NULL, 10));
			break;
		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}
		case 5: /* HH:MM */
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;
	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(const char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	const char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(const char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str;
	const char *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1016 "parse_date.re"



#line 895 "<stdout>"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   4,  32,  20,  48,   0, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,   0, 
		  0, 192, 192, 192, 224, 192, 192, 192, 
		224, 192, 192, 192, 192, 192, 224, 192, 
		192, 192, 224, 224, 224, 192, 192, 192, 
		192, 192, 192,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy2;
	case '\t':
	case ' ':	goto yy6;
	case '(':	goto yy8;
	case '+':
	case '-':	goto yy9;
	case ',':
	case '.':	goto yy10;
	case '0':	goto yy11;
	case '1':	goto yy12;
	case '2':	goto yy13;
	case '3':	goto yy14;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy15;
	case '@':	goto yy16;
	case 'A':	goto yy17;
	case 'B':	goto yy19;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy20;
	case 'D':	goto yy21;
	case 'E':	goto yy22;
	case 'F':	goto yy23;
	case 'G':	goto yy24;
	case 'I':	goto yy25;
	case 'J':	goto yy26;
	case 'L':	goto yy27;
	case 'M':	goto yy28;
	case 'N':	goto yy29;
	case 'O':	goto yy30;
	case 'P':	goto yy31;
	case 'S':	goto yy32;
	case 'T':	goto yy33;
	case 'V':	goto yy34;
	case 'W':	goto yy35;
	case 'X':	goto yy36;
	case 'Y':	goto yy37;
	case 'a':	goto yy38;
	case 'b':	goto yy39;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy40;
	case 'd':	goto yy41;
	case 'e':	goto yy42;
	case 'f':	goto yy43;
	case 'j':	goto yy44;
	case 'l':	goto yy45;
	case 'm':	goto yy46;
	case 'n':	goto yy47;
	case 'o':	goto yy48;
	case 'p':	goto yy49;
	case 's':	goto yy50;
	case 't':	goto yy51;
	case 'w':	goto yy52;
	case 'y':	goto yy53;
	default:	goto yy4;
	}
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(3, *YYCURSOR);
#line 1830 "parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 1020 "<stdout>"
yy4:
	YYDEBUG(4, *YYCURSOR);
	++YYCURSOR;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1836 "parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1031 "<stdout>"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= '/') goto yy7;
	if (yych <= '9') goto yy57;
yy7:
	YYDEBUG(7, *YYCURSOR);
#line 1825 "parse_date.re"
	{
		goto std;
	}
#line 1047 "<stdout>"
yy8:
	YYDEBUG(8, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy5;
	if (yych <= 'Z') goto yy40;
	if (yych <= '`') goto yy5;
	if (yych <= 'z') goto yy40;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy58;
	case '0':
	case '1':	goto yy60;
	case '2':	goto yy61;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy62;
	default:	goto yy5;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	++YYCURSOR;
	goto yy7;
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy63;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy65;
					if (yych <= ',') goto yy5;
					goto yy66;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy67;
					if (yych <= '/') goto yy68;
					goto yy69;
				} else {
					if (yych <= '9') goto yy70;
					if (yych <= ':') goto yy71;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy65;
					if (yych <= 'C') goto yy5;
					goto yy65;
				} else {
					if (yych == 'F') goto yy65;
					goto yy5;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy65;
					if (yych <= 'L') goto yy5;
					goto yy65;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy65;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy65;
					if (yych <= 'c') goto yy5;
					goto yy65;
				} else {
					if (yych == 'f') goto yy65;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy65;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy65;
					goto yy89;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy65;
					if (yych <= 'q') goto yy5;
					goto yy90;
				} else {
					if (yych <= 's') goto yy91;
					if (yych <= 't') goto yy92;
					goto yy65;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy65;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy65;
					if (yych == 0xC2) goto yy65;
					goto yy5;
				}
			}
		}
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy94;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy96;
					if (yych <= ',') goto yy5;
					goto yy66;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy97;
					if (yych <= '/') goto yy68;
					goto yy70;
				} else {
					if (yych <= '9') goto yy98;
					if (yych <= ':') goto yy99;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy96;
					if (yych <= 'C') goto yy5;
					goto yy96;
				} else {
					if (yych == 'F') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy96;
					if (yych <= 'L') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy96;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy96;
					if (yych <= 'c') goto yy5;
					goto yy96;
				} else {
					if (yych == 'f') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy96;
					goto yy89;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy96;
					if (yych <= 'q') goto yy5;
					goto yy90;
				} else {
					if (yych <= 's') goto yy91;
					if (yych <= 't') goto yy92;
					goto yy96;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy96;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy96;
					if (yych == 0xC2) goto yy96;
					goto yy5;
				}
			}
		}
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy94;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy96;
					if (yych <= ',') goto yy5;
					goto yy66;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy97;
					if (yych <= '/') goto yy68;
					goto yy98;
				} else {
					if (yych <= '9') goto yy102;
					if (yych <= ':') goto yy99;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy96;
					if (yych <= 'C') goto yy5;
					goto yy96;
				} else {
					if (yych == 'F') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy96;
					if (yych <= 'L') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy96;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy96;
					if (yych <= 'c') goto yy5;
					goto yy96;
				} else {
					if (yych == 'f') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy96;
					goto yy89;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy96;
					if (yych <= 'q') goto yy5;
					goto yy90;
				} else {
					if (yych <= 's') goto yy91;
					if (yych <= 't') goto yy92;
					goto yy96;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy96;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy96;
					if (yych == 0xC2) goto yy96;
					goto yy5;
				}
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy94;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy96;
					if (yych <= ',') goto yy5;
					goto yy66;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy97;
					if (yych <= '/') goto yy68;
					goto yy102;
				} else {
					if (yych <= '9') goto yy103;
					if (yych <= ':') goto yy99;
					goto yy5;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy96;
					if (yych <= 'C') goto yy5;
					goto yy96;
				} else {
					if (yych == 'F') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy96;
					if (yych <= 'L') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'R') goto yy5;
					if (yych <= 'Y') goto yy96;
					goto yy5;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy96;
					if (yych <= 'c') goto yy5;
					goto yy96;
				} else {
					if (yych == 'f') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy5;
					goto yy96;
				} else {
					if (yych <= 'l') goto yy5;
					if (yych <= 'm') goto yy96;
					goto yy89;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy96;
					if (yych <= 'q') goto yy5;
					goto yy90;
				} else {
					if (yych <= 's') goto yy91;
					if (yych <= 't') goto yy92;
					goto yy96;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy96;
					goto yy5;
				} else {
					if (yych <= 'y') goto yy96;
					if (yych == 0xC2) goto yy96;
					goto yy5;
				}
			}
		}
	}
yy15:
	YYDEBUG(15, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy94;
					goto yy5;
				} else {
					if (yych <= ' ') goto yy96;
					if (yych <= ',') goto yy5;
					goto yy66;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy97;
					if (yych <= '/') goto yy68;
					goto yy103;
				} else {
					if (yych <= ':') goto yy99;
					if (yych <= '@') goto yy5;
					goto yy96;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy96;
					goto yy5;
				} else {
					if (yych == 'G') goto yy5;
					goto yy96;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy5;
					if (yych <= 'P') goto yy96;
					goto yy5;
				} else {
					if (yych <= 'Y') goto yy96;
					if (yych <= '`') goto yy5;
					goto yy96;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy96;
					goto yy5;
				} else {
					if (yych == 'g') goto yy5;
					goto yy96;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy96;
					goto yy5;
				} else {
					if (yych == 'n') goto yy89;
					goto yy96;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy5;
					if (yych <= 'r') goto yy90;
					goto yy91;
				} else {
					if (yych <= 't') goto yy92;
					if (yych <= 'u') goto yy96;
					goto yy5;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy5;
					goto yy96;
				} else {
					if (yych == 0xC2) goto yy96;
					goto yy5;
				}
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy105;
	}
	if (yych == '-') goto yy104;
	goto yy5;
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy108;
			if (yych >= 'A') goto yy109;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy110;
				goto yy109;
			} else {
				if (yych <= 'P') goto yy111;
				if (yych <= 'T') goto yy109;
				goto yy112;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
			} else {
				if (yych == 'g') goto yy114;
				goto yy113;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy115;
				goto yy113;
			} else {
				if (yych <= 'u') goto yy116;
				if (yych <= 'z') goto yy113;
			}
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
#line 1741 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1597 "<stdout>"
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy117;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy118;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy109;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy113;
		goto yy18;
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy119;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy113;
		} else {
			if (yych <= 'e') goto yy120;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'I') goto yy121;
			if (yych <= 'K') goto yy109;
			goto yy122;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy113;
			goto yy123;
		} else {
			if (yych == 'l') goto yy124;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy109;
				goto yy125;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy126;
				goto yy109;
			} else {
				if (yych <= 'O') goto yy127;
				if (yych <= 'Q') goto yy109;
				goto yy128;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy109;
				if (yych <= '`') goto yy18;
				goto yy113;
			} else {
				if (yych <= 'e') goto yy129;
				if (yych <= 'h') goto yy113;
				goto yy130;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy131;
				goto yy113;
			} else {
				if (yych <= 'r') goto yy132;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy109;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy133;
			goto yy109;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy18;
			} else {
				if (yych == '/') goto yy18;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy18;
				goto yy109;
			} else {
				if (yych <= 'I') goto yy139;
				if (yych <= 'U') goto yy109;
				goto yy140;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy140;
				goto yy109;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy141;
			if (yych <= 'T') goto yy109;
			goto yy142;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy143;
		} else {
			if (yych == 'u') goto yy144;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy145;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy146;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy147;
		} else {
			if (yych == 'I') goto yy148;
			if (yych <= 'N') goto yy109;
			goto yy149;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy150;
			goto yy113;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy151;
				goto yy113;
			} else {
				if (yych <= 'o') goto yy152;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy153;
				goto yy109;
			} else {
				if (yych <= 'I') goto yy154;
				if (yych <= 'N') goto yy109;
				goto yy155;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
				goto yy18;
			} else {
				if (yych == 'e') goto yy156;
				goto yy113;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy157;
				goto yy113;
			} else {
				if (yych <= 'o') goto yy158;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy109;
			goto yy159;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy113;
		} else {
			if (yych <= 'c') goto yy160;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy109;
			goto yy161;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy113;
		} else {
			if (yych <= 'r') goto yy162;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy163;
				goto yy109;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy164;
				goto yy109;
			} else {
				if (yych <= 'I') goto yy165;
				if (yych <= 'T') goto yy109;
				goto yy149;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy166;
				if (yych <= 'd') goto yy113;
				goto yy167;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy168;
				goto yy113;
			} else {
				if (yych <= 'u') goto yy152;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy108;
	case '0':
	case '1':	goto yy169;
	case '2':	goto yy170;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy171;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy109;
	case 'E':	goto yy154;
	case 'H':	goto yy172;
	case 'O':	goto yy173;
	case 'U':	goto yy174;
	case 'W':	goto yy175;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy113;
	case 'e':	goto yy157;
	case 'h':	goto yy176;
	case 'o':	goto yy177;
	case 'u':	goto yy178;
	case 'w':	goto yy179;
	default:	goto yy18;
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy18;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy135;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy180;
				goto yy109;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy181;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy113;
		} else {
			if (yych <= 'e') goto yy182;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy18;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy135;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy139;
				goto yy109;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy113;
				goto yy18;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy113;
		} else {
			if (yych <= 'e') goto yy184;
			if (yych <= 'z') goto yy113;
			goto yy18;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy110;
				goto yy109;
			} else {
				if (yych <= 'P') goto yy111;
				if (yych <= 'T') goto yy109;
				goto yy112;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
				goto yy18;
			} else {
				if (yych == 'g') goto yy110;
				goto yy109;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy111;
				goto yy109;
			} else {
				if (yych <= 'u') goto yy112;
				if (yych <= 'z') goto yy109;
				goto yy18;
			}
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy117;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy117;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy109;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy109;
		goto yy18;
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy119;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'e') goto yy119;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'I') goto yy121;
			if (yych <= 'K') goto yy109;
			goto yy122;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy109;
			goto yy121;
		} else {
			if (yych == 'l') goto yy122;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'D') goto yy109;
				goto yy125;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy126;
				goto yy109;
			} else {
				if (yych <= 'O') goto yy127;
				if (yych <= 'Q') goto yy109;
				goto yy128;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy109;
				if (yych <= '`') goto yy18;
				goto yy109;
			} else {
				if (yych <= 'e') goto yy125;
				if (yych <= 'h') goto yy109;
				goto yy126;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy127;
				goto yy109;
			} else {
				if (yych <= 'r') goto yy128;
				if (yych <= 'z') goto yy109;
				goto yy18;
			}
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych <= 'A') goto yy141;
			if (yych <= 'T') goto yy109;
			goto yy142;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy141;
		} else {
			if (yych == 'u') goto yy142;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy145;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy109;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy145;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy147;
		} else {
			if (yych == 'I') goto yy148;
			if (yych <= 'N') goto yy109;
			goto yy149;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy147;
			goto yy109;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy148;
				goto yy109;
			} else {
				if (yych <= 'o') goto yy149;
				if (yych <= 'z') goto yy109;
				goto yy18;
			}
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy153;
				goto yy109;
			} else {
				if (yych <= 'I') goto yy154;
				if (yych <= 'N') goto yy109;
				goto yy155;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
				goto yy18;
			} else {
				if (yych == 'e') goto yy153;
				goto yy109;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy154;
				goto yy109;
			} else {
				if (yych <= 'o') goto yy155;
				if (yych <= 'z') goto yy109;
				goto yy18;
			}
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy109;
			goto yy159;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'c') goto yy159;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy109;
			goto yy161;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'r') goto yy161;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'A') goto yy163;
				goto yy109;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy164;
				goto yy109;
			} else {
				if (yych <= 'I') goto yy165;
				if (yych <= 'T') goto yy109;
				goto yy149;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy109;
				goto yy18;
			} else {
				if (yych <= 'a') goto yy163;
				if (yych <= 'd') goto yy109;
				goto yy164;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy165;
				goto yy109;
			} else {
				if (yych <= 'u') goto yy149;
				if (yych <= 'z') goto yy109;
				goto yy18;
			}
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy108;
	case '0':
	case '1':	goto yy169;
	case '2':	goto yy170;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy171;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy109;
	case 'E':
	case 'e':	goto yy154;
	case 'H':
	case 'h':	goto yy172;
	case 'O':
	case 'o':	goto yy173;
	case 'U':
	case 'u':	goto yy174;
	case 'W':
	case 'w':	goto yy175;
	default:	goto yy18;
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy181;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'e') goto yy181;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy109;
			goto yy183;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy109;
			if (yych <= '`') goto yy18;
			goto yy109;
		} else {
			if (yych <= 'e') goto yy183;
			if (yych <= 'z') goto yy109;
			goto yy18;
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(55, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy57;
yy56:
	YYDEBUG(56, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy7;
						} else {
							goto yy5;
						}
					} else {
						goto yy18;
					}
				} else {
					if (yyaccept == 3) {
						goto yy77;
					} else {
						goto yy209;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy214;
					} else {
						goto yy250;
					}
				} else {
					if (yyaccept == 7) {
						goto yy281;
					} else {
						goto yy279;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy301;
					} else {
						goto yy311;
					}
				} else {
					if (yyaccept == 11) {
						goto yy337;
					} else {
						goto yy403;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy405;
					} else {
						goto yy507;
					}
				} else {
					if (yyaccept == 15) {
						goto yy548;
					} else {
						goto yy700;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 24) {
			if (yyaccept <= 20) {
				if (yyaccept <= 18) {
					if (yyaccept == 17) {
						goto yy716;
					} else {
						goto yy729;
					}
				} else {
					if (yyaccept == 19) {
						goto yy752;
					} else {
						goto yy820;
					}
				}
			} else {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy894;
					} else {
						goto yy581;
					}
				} else {
					if (yyaccept == 23) {
						goto yy910;
					} else {
						goto yy944;
					}
				}
			}
		} else {
			if (yyaccept <= 28) {
				if (yyaccept <= 26) {
					if (yyaccept == 25) {
						goto yy985;
					} else {
						goto yy1003;
					}
				} else {
					if (yyaccept == 27) {
						goto yy1008;
					} else {
						goto yy1062;
					}
				}
			} else {
				if (yyaccept <= 30) {
					if (yyaccept == 29) {
						goto yy1100;
					} else {
						goto yy1123;
					}
				} else {
					if (yyaccept == 31) {
						goto yy1126;
					} else {
						goto yy1256;
					}
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy187;
	goto yy186;
yy58:
	YYDEBUG(58, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 24) YYFILL(24);
	yych = *YYCURSOR;
	YYDEBUG(59, *YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy58;
		goto yy56;
	} else {
		if (yych <= '-') goto yy58;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy57;
		goto yy56;
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy192;
				} else {
					if (yych <= ':') goto yy193;
					if (yych <= 'C') goto yy18;
					goto yy186;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy18;
					goto yy186;
				} else {
					if (yych == 'H') goto yy186;
					goto yy18;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy18;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy18;
					goto yy186;
				} else {
					if (yych == ' ') goto yy186;
					goto yy18;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy192;
					goto yy194;
				} else {
					if (yych <= '9') goto yy195;
					if (yych <= ':') goto yy193;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy186;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy186;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych <= 'c') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy194;
				} else {
					if (yych <= '9') goto yy195;
					if (yych <= ':') goto yy193;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy186;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy186;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych <= 'c') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy65;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy65;
yy64:
	YYDEBUG(64, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy65:
	YYDEBUG(65, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy64;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy64;
					if (yych <= ',') goto yy56;
					goto yy196;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy72;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy73;
					if (yych == 'F') goto yy74;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy75;
					if (yych <= 'I') goto yy76;
					goto yy78;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy79;
					goto yy80;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy81;
					if (yych <= 'R') goto yy56;
					goto yy82;
				} else {
					if (yych <= 'T') goto yy83;
					if (yych <= 'U') goto yy84;
					if (yych <= 'V') goto yy85;
					goto yy86;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy87;
					if (yych <= 'Y') goto yy88;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy72;
					if (yych <= 'c') goto yy56;
					goto yy73;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy74;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy75;
					if (yych == 'j') goto yy78;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy79;
					if (yych <= 'n') goto yy80;
					goto yy81;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy82;
					if (yych <= 't') goto yy83;
					goto yy84;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy86;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy88;
					if (yych == 0xC2) goto yy93;
					goto yy56;
				}
			}
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy201;
	if (yych <= '1') goto yy202;
	if (yych <= '9') goto yy203;
	goto yy197;
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy197;
		if (yych <= '0') goto yy208;
		goto yy210;
	} else {
		if (yych <= '5') goto yy211;
		if (yych <= '9') goto yy212;
		goto yy197;
	}
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy213;
	case '3':	goto yy215;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy216;
	case 'A':
	case 'a':	goto yy217;
	case 'D':
	case 'd':	goto yy218;
	case 'F':
	case 'f':	goto yy219;
	case 'J':
	case 'j':	goto yy220;
	case 'M':
	case 'm':	goto yy221;
	case 'N':
	case 'n':	goto yy222;
	case 'O':
	case 'o':	goto yy223;
	case 'S':
	case 's':	goto yy224;
	default:	goto yy56;
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy63;
			if (yych <= ',') goto yy65;
			goto yy225;
		} else {
			if (yych <= '.') goto yy67;
			if (yych <= '/') goto yy68;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy71;
			if (yych == 'n') goto yy89;
			goto yy65;
		} else {
			if (yych <= 'r') goto yy90;
			if (yych <= 's') goto yy91;
			if (yych <= 't') goto yy92;
			goto yy65;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy94;
			if (yych <= ',') goto yy96;
			goto yy225;
		} else {
			if (yych <= '.') goto yy97;
			if (yych <= '/') goto yy68;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy99;
			if (yych == 'n') goto yy89;
			goto yy96;
		} else {
			if (yych <= 'r') goto yy90;
			if (yych <= 's') goto yy91;
			if (yych <= 't') goto yy92;
			goto yy96;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy228;
	if (yych <= '9') goto yy229;
	goto yy56;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy230;
		if (yych <= 'T') goto yy56;
		goto yy231;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy230;
		} else {
			if (yych == 'u') goto yy231;
			goto yy56;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy232;
		if (yych <= 'D') goto yy56;
		goto yy233;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy232;
		} else {
			if (yych == 'e') goto yy233;
			goto yy56;
		}
	}
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy234;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy235;
			if (yych <= 'Q') goto yy56;
			goto yy236;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy234;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy235;
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy237;
	if (yych == 'o') goto yy237;
	goto yy56;
yy76:
	YYDEBUG(76, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			if (yych <= '.') goto yy238;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy240;
			if (yych == 'I') goto yy242;
		} else {
			if (yych == 'W') goto yy77;
			if (yych <= 'X') goto yy243;
		}
	}
yy77:
	YYDEBUG(77, *YYCURSOR);
#line 1491 "parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3344 "<stdout>"
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy244;
		if (yych <= 'T') goto yy56;
		goto yy245;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy244;
		} else {
			if (yych == 'u') goto yy245;
			goto yy56;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy246;
			if (yych <= 'H') goto yy56;
			goto yy247;
		} else {
			if (yych == 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy246;
			if (yych <= 'h') goto yy56;
			goto yy247;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy248;
			} else {
				if (yych == 's') goto yy249;
				goto yy56;
			}
		}
	}
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy251;
	if (yych == 'o') goto yy251;
	goto yy56;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy252;
	if (yych == 'c') goto yy252;
	goto yy56;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy254;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy254;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy256;
		if (yych <= 'T') goto yy56;
		goto yy257;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy256;
		} else {
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy258;
	if (yych == 's') goto yy258;
	goto yy56;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy77;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy77;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy77;
			goto yy240;
		} else {
			if (yych == 'I') goto yy87;
			goto yy77;
		}
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy259;
	if (yych == 'e') goto yy259;
	goto yy56;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy77;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy77;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy77;
			goto yy240;
		} else {
			if (yych == 'I') goto yy242;
			goto yy77;
		}
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy260;
	if (yych == 'e') goto yy260;
	goto yy56;
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy251;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy261;
		if (yych == 'o') goto yy251;
		goto yy56;
	}
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy261;
	goto yy56;
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy254;
			if (yych == 'U') goto yy255;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy253;
			if (yych <= 'd') goto yy56;
			goto yy254;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy261;
			if (yych <= 'u') goto yy255;
			goto yy56;
		}
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy256;
		if (yych <= 'T') goto yy56;
		goto yy257;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy262;
		} else {
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy263;
	goto yy56;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy96;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy96;
yy95:
	YYDEBUG(95, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy96:
	YYDEBUG(96, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy95;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy95;
					if (yych <= ',') goto yy56;
					goto yy196;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy100;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy73;
					if (yych == 'F') goto yy74;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy75;
					if (yych <= 'I') goto yy76;
					goto yy78;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy79;
					if (yych <= 'N') goto yy80;
					goto yy81;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy101;
					if (yych <= 'R') goto yy56;
					goto yy82;
				} else {
					if (yych <= 'T') goto yy83;
					if (yych <= 'U') goto yy84;
					if (yych <= 'V') goto yy85;
					goto yy86;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy87;
					if (yych <= 'Y') goto yy88;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy100;
					if (yych == 'd') goto yy73;
					goto yy56;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy74;
					if (yych <= 'g') goto yy56;
					goto yy75;
				} else {
					if (yych == 'j') goto yy78;
					if (yych <= 'l') goto yy56;
					goto yy79;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy80;
					if (yych <= 'o') goto yy81;
					goto yy101;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy82;
					if (yych <= 't') goto yy83;
					goto yy84;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy86;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy88;
					if (yych == 0xC2) goto yy93;
					goto yy56;
				}
			}
		}
	}
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy197;
		if (yych <= '0') goto yy264;
		goto yy265;
	} else {
		if (yych <= '5') goto yy266;
		if (yych <= '9') goto yy267;
		goto yy197;
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy63;
			if (yych <= ',') goto yy65;
			goto yy225;
		} else {
			if (yych <= '.') goto yy67;
			if (yych <= '/') goto yy268;
			if (yych <= '5') goto yy226;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy71;
			if (yych == 'n') goto yy89;
			goto yy65;
		} else {
			if (yych <= 'r') goto yy90;
			if (yych <= 's') goto yy91;
			if (yych <= 't') goto yy92;
			goto yy65;
		}
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy269;
	if (yych <= '9') goto yy270;
	goto yy56;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy271;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy272;
			if (yych == 'P') goto yy230;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy231;
			if (yych == 'm') goto yy272;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy230;
			if (yych == 'u') goto yy231;
			goto yy56;
		}
	}
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy271;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy272;
		if (yych == 'm') goto yy272;
		goto yy56;
	}
yy102:
	YYDEBUG(102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy63;
			goto yy65;
		} else {
			if (yych <= '-') goto yy225;
			if (yych <= '.') goto yy273;
			if (yych <= '/') goto yy268;
			goto yy227;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy89;
			goto yy65;
		} else {
			if (yych <= 'r') goto yy90;
			if (yych <= 's') goto yy91;
			if (yych <= 't') goto yy92;
			goto yy65;
		}
	}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy274;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy227;
	goto yy186;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy105;
	}
	goto yy56;
yy105:
	YYDEBUG(105, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	YYDEBUG(106, *YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy105;
	}
	if (yych == '.') goto yy275;
	YYDEBUG(107, *YYCURSOR);
#line 1076 "parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr(&ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3823 "<stdout>"
yy108:
	YYDEBUG(108, *YYCURSOR);
	++YYCURSOR;
	goto yy18;
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy277;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy277;
		goto yy18;
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy277;
			goto yy278;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'o') goto yy278;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy277;
			goto yy280;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'r') goto yy280;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy277;
			goto yy282;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'g') goto yy282;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy277;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy284;
			goto yy18;
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy278;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'o') goto yy285;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy280;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'r') goto yy286;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy282;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'g') goto yy287;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy277;
			goto yy288;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'c') goto yy288;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy288;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'c') goto yy289;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'B') goto yy277;
			goto yy290;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'c') goto yy290;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy290;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'c') goto yy291;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy277;
			goto yy292;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'g') goto yy292;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy277;
			goto yy293;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'e') goto yy293;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy292;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'g') goto yy294;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy293;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'e') goto yy295;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy277;
			goto yy296;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'b') goto yy296;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'F') goto yy297;
			if (yych <= 'Q') goto yy277;
			goto yy298;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'e') goto yy277;
			goto yy297;
		} else {
			if (yych == 'r') goto yy298;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy277;
			goto yy299;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'u') goto yy299;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'I') goto yy300;
			if (yych <= 'N') goto yy277;
			goto yy302;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy277;
			goto yy300;
		} else {
			if (yych == 'o') goto yy302;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy296;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'b') goto yy303;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'F') goto yy297;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy298;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy304;
				goto yy284;
			} else {
				if (yych <= 'r') goto yy305;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy299;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'u') goto yy306;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'I') goto yy300;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy302;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy307;
				goto yy284;
			} else {
				if (yych <= 'o') goto yy308;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy277;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy309;
			goto yy277;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy135:
	YYDEBUG(135, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy134;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy136;
	if (yych <= '3') goto yy137;
	if (yych <= '9') goto yy138;
	goto yy56;
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy314;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy314;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy318;
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy318;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy18;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy135;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy319;
				goto yy277;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy277;
				goto yy18;
			}
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy135;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy277;
			goto yy320;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'n') goto yy320;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'L') goto yy321;
			if (yych <= 'M') goto yy277;
			goto yy322;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'k') goto yy277;
			goto yy321;
		} else {
			if (yych == 'n') goto yy322;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy320;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'n') goto yy323;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'L') goto yy321;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy322;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy324;
				goto yy284;
			} else {
				if (yych <= 'n') goto yy325;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy277;
			goto yy326;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 's') goto yy326;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy326;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 's') goto yy327;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'R') goto yy328;
			if (yych <= 'X') goto yy277;
			goto yy329;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'q') goto yy277;
			goto yy328;
		} else {
			if (yych == 'y') goto yy329;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy277;
			goto yy330;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'd') goto yy330;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy277;
			goto yy300;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'n') goto yy300;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'R') goto yy328;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy329;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy331;
				goto yy284;
			} else {
				if (yych <= 'y') goto yy332;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy330;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'd') goto yy333;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy300;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'n') goto yy307;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy277;
			goto yy334;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'x') goto yy334;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy277;
			goto yy297;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'n') goto yy297;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'O') goto yy335;
			if (yych <= 'U') goto yy277;
			if (yych <= 'V') goto yy290;
			goto yy336;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'n') goto yy277;
			goto yy335;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy277;
				goto yy290;
			} else {
				if (yych <= 'w') goto yy336;
				if (yych <= 'z') goto yy277;
				goto yy18;
			}
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy334;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'x') goto yy338;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy297;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'n') goto yy304;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy283;
				if (yych <= '@') goto yy18;
				goto yy277;
			} else {
				if (yych <= 'O') goto yy335;
				if (yych <= 'U') goto yy277;
				goto yy290;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy336;
				if (yych <= 'Z') goto yy277;
				goto yy18;
			} else {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy18;
				goto yy284;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy339;
				if (yych <= 'u') goto yy284;
				goto yy291;
			} else {
				if (yych <= 'w') goto yy340;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy277;
			goto yy341;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 't') goto yy341;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy341;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 't') goto yy342;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy277;
			goto yy343;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'e') goto yy343;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy343;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'e') goto yy344;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy277;
			goto yy345;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 't') goto yy345;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy346;
				goto yy277;
			} else {
				if (yych <= 'P') goto yy347;
				if (yych <= 'U') goto yy277;
				goto yy348;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy277;
				goto yy18;
			} else {
				if (yych == 'c') goto yy346;
				goto yy277;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy347;
				goto yy277;
			} else {
				if (yych <= 'v') goto yy348;
				if (yych <= 'z') goto yy277;
				goto yy18;
			}
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'W') goto yy277;
			goto yy297;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'x') goto yy297;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy345;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 't') goto yy349;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy108;
				goto yy18;
			} else {
				if (yych == '.') goto yy18;
				goto yy283;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy18;
				if (yych <= 'B') goto yy277;
				goto yy346;
			} else {
				if (yych == 'P') goto yy347;
				goto yy277;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy348;
				if (yych <= 'Z') goto yy277;
				goto yy18;
			} else {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy18;
				goto yy284;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy350;
				if (yych <= 'o') goto yy284;
				goto yy351;
			} else {
				if (yych == 'v') goto yy352;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy297;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'x') goto yy304;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy71;
		goto yy56;
	} else {
		if (yych <= '9') goto yy353;
		if (yych <= ':') goto yy71;
		goto yy56;
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy71;
		goto yy56;
	} else {
		if (yych <= '4') goto yy353;
		if (yych == ':') goto yy71;
		goto yy56;
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy71;
	if (yych == ':') goto yy71;
	goto yy56;
yy172:
	YYDEBUG(172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'I') goto yy354;
			if (yych <= 'T') goto yy277;
			goto yy355;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'h') goto yy277;
			goto yy354;
		} else {
			if (yych == 'u') goto yy355;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == 'D') goto yy356;
			if (yych <= 'L') goto yy277;
			goto yy357;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			if (yych <= 'c') goto yy277;
			goto yy356;
		} else {
			if (yych == 'm') goto yy357;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy277;
			goto yy358;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'e') goto yy358;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy277;
			goto yy359;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'e') goto yy359;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'I') goto yy354;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy355;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy360;
				goto yy284;
			} else {
				if (yych <= 'u') goto yy361;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy18;
				goto yy108;
			} else {
				if (yych == '-') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy283;
				goto yy18;
			} else {
				if (yych == 'D') goto yy356;
				goto yy277;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy357;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy362;
				goto yy284;
			} else {
				if (yych <= 'm') goto yy363;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy358;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'e') goto yy364;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy359;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 'e') goto yy365;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy18;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy135;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy366;
				goto yy277;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy277;
				goto yy18;
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych <= 'C') goto yy277;
			if (yych <= 'D') goto yy367;
			goto yy368;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 'd') goto yy367;
			if (yych <= 'e') goto yy368;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy18;
				goto yy283;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'C') goto yy277;
				goto yy367;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy368;
				goto yy277;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy284;
				goto yy369;
			} else {
				if (yych <= 'e') goto yy370;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy277;
			goto yy371;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy277;
			if (yych <= '`') goto yy18;
			goto yy277;
		} else {
			if (yych <= 's') goto yy371;
			if (yych <= 'z') goto yy277;
			goto yy18;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy277;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy371;
			if (yych <= 'Z') goto yy277;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy284;
			} else {
				if (yych <= 's') goto yy372;
				if (yych <= 'z') goto yy284;
				goto yy18;
			}
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy186:
	YYDEBUG(186, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy185;
				if (yych <= 0x1F) goto yy56;
				goto yy185;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy188;
				} else {
					if (yych == 'F') goto yy189;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy75;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy190;
					if (yych <= 'R') goto yy56;
					goto yy191;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy83;
					goto yy84;
				} else {
					if (yych == 'W') goto yy86;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy88;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy188;
					if (yych <= 'e') goto yy56;
					goto yy189;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy75;
				} else {
					if (yych == 'm') goto yy190;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy191;
					goto yy83;
				} else {
					if (yych <= 'u') goto yy84;
					if (yych <= 'v') goto yy56;
					goto yy86;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy88;
				} else {
					if (yych == 0xC2) goto yy93;
					goto yy56;
				}
			}
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy373;
	goto yy186;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy232;
	if (yych == 'a') goto yy232;
	goto yy56;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy235;
		if (yych <= 'Q') goto yy56;
		goto yy236;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy235;
		} else {
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy247;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy247;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy248;
			if (yych == 's') goto yy249;
			goto yy56;
		}
	}
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy374;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy374;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy18;
					goto yy375;
				} else {
					if (yych <= '9') goto yy376;
					if (yych >= ';') goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy186;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy186;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych <= 'c') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy377;
	if (yych <= '9') goto yy108;
	goto yy18;
yy194:
	YYDEBUG(194, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy376;
				} else {
					if (yych == 'D') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy186;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy18;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy195:
	YYDEBUG(195, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy378;
				} else {
					if (yych == 'D') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy186;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy18;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy197:
	YYDEBUG(197, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy196;
	case 'A':
	case 'a':	goto yy72;
	case 'D':
	case 'd':	goto yy204;
	case 'F':
	case 'f':	goto yy205;
	case 'I':	goto yy76;
	case 'J':
	case 'j':	goto yy78;
	case 'M':
	case 'm':	goto yy206;
	case 'N':
	case 'n':	goto yy80;
	case 'O':
	case 'o':	goto yy81;
	case 'S':
	case 's':	goto yy207;
	case 'V':	goto yy85;
	case 'X':	goto yy87;
	default:	goto yy56;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy380;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy200;
		goto yy56;
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy379;
		goto yy380;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy379;
	if (yych <= '.') goto yy380;
	goto yy56;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy381;
		goto yy379;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy203;
		goto yy56;
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy381;
		goto yy379;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy381;
	if (yych <= '.') goto yy379;
	goto yy56;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy233;
	if (yych == 'e') goto yy233;
	goto yy56;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy234;
	if (yych == 'e') goto yy234;
	goto yy56;
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy246;
	if (yych == 'a') goto yy246;
	goto yy56;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy382;
	if (yych == 'e') goto yy382;
	goto yy56;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy383;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy212;
		if (yych <= ':') goto yy384;
	}
yy209:
	YYDEBUG(209, *YYCURSOR);
#line 1234 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 6489 "<stdout>"
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		if (yych <= '.') goto yy383;
		goto yy209;
	} else {
		if (yych <= '2') goto yy212;
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy384;
		goto yy209;
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy383;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy384;
		goto yy209;
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy383;
	} else {
		if (yych == ':') goto yy384;
		goto yy209;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy385;
		} else {
			if (yych <= '9') goto yy216;
			if (yych >= 'n') goto yy386;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy386;
		} else {
			if (yych <= 's') goto yy387;
			if (yych <= 't') goto yy388;
		}
	}
yy214:
	YYDEBUG(214, *YYCURSOR);
#line 1326 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 6567 "<stdout>"
yy215:
	YYDEBUG(215, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy214;
			goto yy385;
		} else {
			if (yych <= '1') goto yy216;
			if (yych <= 'm') goto yy214;
			goto yy386;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy214;
			goto yy386;
		} else {
			if (yych <= 's') goto yy387;
			if (yych <= 't') goto yy388;
			goto yy214;
		}
	}
yy216:
	YYDEBUG(216, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy385;
		if (yych <= 'm') goto yy214;
		goto yy386;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy214;
			goto yy386;
		} else {
			if (yych <= 's') goto yy387;
			if (yych <= 't') goto yy388;
			goto yy214;
		}
	}
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy389;
		if (yych <= 'T') goto yy56;
		goto yy390;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy389;
		} else {
			if (yych == 'u') goto yy390;
			goto yy56;
		}
	}
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy391;
	if (yych == 'e') goto yy391;
	goto yy56;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy392;
	if (yych == 'e') goto yy392;
	goto yy56;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy393;
		if (yych <= 'T') goto yy56;
		goto yy394;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy393;
		} else {
			if (yych == 'u') goto yy394;
			goto yy56;
		}
	}
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy395;
	if (yych == 'a') goto yy395;
	goto yy56;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy396;
	if (yych == 'o') goto yy396;
	goto yy56;
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy397;
	if (yych == 'c') goto yy397;
	goto yy56;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy398;
	if (yych == 'e') goto yy398;
	goto yy56;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy399;
	if (yych <= '1') goto yy400;
	if (yych <= '9') goto yy203;
	goto yy197;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy401;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy402;
	goto yy186;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy401;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy404;
	goto yy186;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy384;
		goto yy209;
	} else {
		if (yych <= '9') goto yy229;
		if (yych <= ':') goto yy384;
		goto yy209;
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy384;
	if (yych == ':') goto yy384;
	goto yy209;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy406;
	if (yych == 'r') goto yy406;
	goto yy56;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy407;
	if (yych == 'g') goto yy407;
	goto yy56;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy408;
	if (yych == 'y') goto yy408;
	goto yy56;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy409;
	if (yych == 'c') goto yy409;
	goto yy56;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy410;
	if (yych == 'b') goto yy410;
	goto yy56;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy411;
	if (yych == 'r') goto yy411;
	goto yy56;
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy412;
	if (yych == 'i') goto yy412;
	goto yy56;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy413;
	if (yych == 'u') goto yy413;
	goto yy56;
yy238:
	YYDEBUG(238, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	YYDEBUG(239, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy238;
		if (yych <= 0x1F) goto yy56;
		goto yy238;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy238;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy414;
yy241:
	YYDEBUG(241, *YYCURSOR);
#line 1408 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		timelib_skip_day_suffix(&ptr);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 6806 "<stdout>"
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy77;
			goto yy238;
		} else {
			if (yych == ' ') goto yy238;
			goto yy77;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy238;
			if (yych <= '/') goto yy77;
			goto yy240;
		} else {
			if (yych != 'I') goto yy77;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy238;
		if (yych <= 0x1F) goto yy77;
		goto yy238;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy77;
			goto yy238;
		} else {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		}
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy415;
	if (yych == 'n') goto yy415;
	goto yy56;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy416;
		if (yych <= 'M') goto yy56;
		goto yy417;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy416;
		} else {
			if (yych == 'n') goto yy417;
			goto yy56;
		}
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy418;
		if (yych <= 'X') goto yy56;
		goto yy243;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy418;
		} else {
			if (yych == 'y') goto yy243;
			goto yy56;
		}
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy419;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy420;
			if (yych <= 'M') goto yy56;
			goto yy421;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy419;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy420;
			if (yych == 'n') goto yy421;
			goto yy56;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy422;
	if (yych == 'n') goto yy422;
	goto yy56;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy423;
	if (yych == 'e') goto yy423;
yy250:
	YYDEBUG(250, *YYCURSOR);
#line 1809 "parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr(&ptr, 24);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 6935 "<stdout>"
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy409;
	if (yych == 'v') goto yy409;
	goto yy56;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy424;
	if (yych == 't') goto yy424;
	goto yy56;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy425;
	if (yych == 't') goto yy425;
	goto yy56;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy426;
		if (yych <= 'O') goto yy56;
		goto yy427;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy426;
		} else {
			if (yych == 'p') goto yy427;
			goto yy56;
		}
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy412;
	if (yych == 'n') goto yy412;
	goto yy56;
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy428;
	if (yych == 'u') goto yy428;
	goto yy56;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy429;
	if (yych == 'e') goto yy429;
	goto yy56;
yy258:
	YYDEBUG(258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy423;
	if (yych == 'e') goto yy423;
	goto yy56;
yy259:
	YYDEBUG(259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy430;
		goto yy431;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy430;
		if (yych <= 'e') goto yy431;
		goto yy56;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy413;
	if (yych == 'a') goto yy413;
	goto yy56;
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy273;
		goto yy197;
	} else {
		if (yych <= '-') goto yy432;
		if (yych <= '.') goto yy273;
		if (yych <= '/') goto yy268;
		goto yy197;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy197;
			goto yy273;
		} else {
			if (yych <= ',') goto yy197;
			if (yych <= '-') goto yy432;
			goto yy273;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy268;
			if (yych <= 'T') goto yy197;
			goto yy428;
		} else {
			if (yych == 'u') goto yy428;
			goto yy197;
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy249;
	if (yych == 's') goto yy249;
	goto yy56;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy433;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy434;
		if (yych <= ':') goto yy435;
		goto yy209;
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		if (yych <= '.') goto yy433;
		goto yy209;
	} else {
		if (yych <= '2') goto yy434;
		if (yych <= '9') goto yy436;
		if (yych <= ':') goto yy435;
		goto yy209;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy433;
	} else {
		if (yych <= '/') goto yy209;
		if (yych <= '9') goto yy436;
		if (yych <= ':') goto yy435;
		goto yy209;
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy209;
		if (yych <= '-') goto yy379;
		goto yy433;
	} else {
		if (yych == ':') goto yy435;
		goto yy209;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy217;
	case 'D':
	case 'd':	goto yy218;
	case 'F':
	case 'f':	goto yy219;
	case 'J':
	case 'j':	goto yy220;
	case 'M':
	case 'm':	goto yy221;
	case 'N':
	case 'n':	goto yy222;
	case 'O':
	case 'o':	goto yy223;
	case 'S':
	case 's':	goto yy224;
	default:	goto yy56;
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy435;
		goto yy209;
	} else {
		if (yych <= '9') goto yy437;
		if (yych <= ':') goto yy435;
		goto yy209;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy435;
	if (yych == ':') goto yy435;
	goto yy209;
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy272;
	if (yych != 'm') goto yy56;
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy438;
		if (yych == '\t') goto yy438;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy438;
		if (yych == '.') goto yy440;
		goto yy56;
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy198;
	if (yych <= '1') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy197;
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy441;
	case '1':	goto yy442;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case 'A':
	case 'a':	goto yy444;
	case 'D':
	case 'd':	goto yy445;
	case 'F':
	case 'f':	goto yy446;
	case 'J':
	case 'j':	goto yy447;
	case 'M':
	case 'm':	goto yy448;
	case 'N':
	case 'n':	goto yy449;
	case 'O':
	case 'o':	goto yy450;
	case 'S':
	case 's':	goto yy451;
	default:	goto yy56;
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy452;
yy276:
	YYDEBUG(276, *YYCURSOR);
#line 1102 "parse_date.re"
	{
		timelib_ull i, us;
		const char *ptr_before;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr(&ptr, 24);

		ptr_before = ptr;
		us = timelib_get_unsigned_nr(&ptr, 6);
		us = us * pow(10, 7 - (ptr - ptr_before));

		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7245 "<stdout>"
yy277:
	YYDEBUG(277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy453;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy453;
		goto yy18;
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
	} else {
		if (yych <= 'Z') goto yy453;
		if (yych <= '`') goto yy279;
		if (yych <= 'z') goto yy453;
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
#line 1651 "parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7290 "<stdout>"
yy280:
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy135;
			} else {
				if (yych == ' ') goto yy135;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
			} else {
				if (yych == 'I') goto yy455;
				goto yy453;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy453;
			} else {
				if (yych <= 'i') goto yy455;
				if (yych <= 'z') goto yy453;
			}
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
#line 1731 "parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month(&ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7338 "<stdout>"
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'U') goto yy456;
				goto yy453;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'u') goto yy456;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy457;
	}
	goto yy56;
yy284:
	YYDEBUG(284, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy453;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy459;
			goto yy18;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy279;
		} else {
			if (yych == '.') goto yy279;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy279;
			if (yych <= 'Z') goto yy453;
			goto yy279;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy279;
			if (yych <= 'z') goto yy459;
			goto yy279;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'I') goto yy455;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'i') goto yy461;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'U') goto yy456;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'u') goto yy462;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy453;
			goto yy463;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'k') goto yy463;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy463;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'k') goto yy464;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'E') goto yy465;
				goto yy453;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'e') goto yy465;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'E') goto yy465;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'e') goto yy466;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy453;
			goto yy467;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'h') goto yy467;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy453;
			goto yy468;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'v') goto yy468;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy467;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'h') goto yy469;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy468;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'v') goto yy470;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'R') goto yy471;
				goto yy453;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'r') goto yy471;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy453;
			goto yy472;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 't') goto yy472;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy453;
			goto yy473;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 's') goto yy473;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy453;
			goto yy474;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'r') goto yy474;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy108;
		} else {
			if (yych <= '@') goto yy301;
			if (yych <= 'C') goto yy453;
			goto yy475;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy453;
			if (yych >= 'a') goto yy453;
		} else {
			if (yych <= 'd') goto yy475;
			if (yych <= 'z') goto yy453;
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
#line 1672 "parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit(&ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7930 "<stdout>"
yy302:
	YYDEBUG(302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy453;
			goto yy476;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'n') goto yy476;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'R') goto yy471;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'r') goto yy477;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy472;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 't') goto yy478;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy473;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 's') goto yy479;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy474;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'r') goto yy480;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy301;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy301;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy475;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy301;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy301;
				goto yy459;
			} else {
				if (yych <= 'd') goto yy481;
				if (yych <= 'z') goto yy459;
				goto yy301;
			}
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy476;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'n') goto yy482;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych == '+') goto yy483;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy483;
			if (yych <= '@') goto yy18;
			goto yy453;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych >= '0') goto yy484;
		} else {
			if (yych <= '1') goto yy485;
			if (yych <= '2') goto yy486;
			goto yy487;
		}
	} else {
		if (yych <= 'T') {
			if (yych >= 'T') goto yy488;
		} else {
			if (yych == 't') goto yy488;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
#line 1477 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 8211 "<stdout>"
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 10;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy313:
	YYDEBUG(313, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy312;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy311;
		if (yych <= '0') goto yy489;
		if (yych <= '1') goto yy490;
		goto yy491;
	} else {
		if (yych <= '9') goto yy492;
		if (yych == 'T') goto yy488;
		goto yy311;
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy493;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy494;
	goto yy313;
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy494;
	goto yy313;
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy494;
	goto yy313;
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy493;
	goto yy56;
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy135;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'U') goto yy495;
				goto yy453;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'u') goto yy495;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'Y') goto yy496;
				goto yy453;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'y') goto yy496;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'E') goto yy496;
				goto yy453;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'e') goto yy496;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'U') goto yy495;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'u') goto yy497;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'Y') goto yy496;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'y') goto yy498;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'E') goto yy496;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'e') goto yy498;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy453;
			goto yy499;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 't') goto yy499;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy499;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 't') goto yy500;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'C') goto yy501;
				goto yy453;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'c') goto yy501;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy281;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy281;
			goto yy454;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy281;
			if (yych <= '9') goto yy135;
			goto yy281;
		} else {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy281;
			if (yych <= 'z') goto yy453;
			goto yy281;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy453;
			goto yy502;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'n') goto yy502;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'C') goto yy501;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'c') goto yy503;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy281;
			goto yy135;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy281;
				goto yy108;
			} else {
				if (yych <= ',') goto yy281;
				if (yych <= '-') goto yy460;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy283;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy281;
			goto yy453;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy281;
				goto yy283;
			} else {
				if (yych <= '`') goto yy281;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy502;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'n') goto yy504;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy453;
			goto yy505;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 't') goto yy505;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy453;
			goto yy506;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'n') goto yy506;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
	} else {
		if (yych <= 'Z') goto yy453;
		if (yych <= '`') goto yy337;
		if (yych <= 'z') goto yy453;
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
#line 1033 "parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8913 "<stdout>"
yy338:
	YYDEBUG(338, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy505;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 't') goto yy508;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy506;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'n') goto yy509;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy337;
		} else {
			if (yych == '.') goto yy337;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy337;
			if (yych <= 'Z') goto yy453;
			goto yy337;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy337;
			if (yych <= 'z') goto yy459;
			goto yy337;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'O') goto yy510;
				goto yy453;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'o') goto yy510;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'O') goto yy510;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 'o') goto yy511;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'U') goto yy453;
			goto yy512;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'v') goto yy512;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy512;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'v') goto yy513;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy301;
			goto yy108;
		} else {
			if (yych <= '@') goto yy301;
			if (yych <= 'T') goto yy453;
			goto yy514;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy301;
			goto yy453;
		} else {
			if (yych <= 'u') goto yy514;
			if (yych <= 'z') goto yy453;
			goto yy301;
		}
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy453;
			goto yy515;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'o') goto yy515;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'T') goto yy516;
				goto yy453;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy281;
				goto yy453;
			} else {
				if (yych <= 't') goto yy516;
				if (yych <= 'z') goto yy453;
				goto yy281;
			}
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy453;
			goto yy517;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'e') goto yy517;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy301;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy301;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy514;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy301;
			goto yy283;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy301;
				goto yy459;
			} else {
				if (yych <= 'u') goto yy518;
				if (yych <= 'z') goto yy459;
				goto yy301;
			}
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy515;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'o') goto yy519;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy281;
				goto yy453;
			} else {
				if (yych <= 'T') goto yy516;
				if (yych <= 'Z') goto yy453;
				goto yy281;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy459;
			} else {
				if (yych <= 't') goto yy520;
				if (yych <= 'z') goto yy459;
				goto yy281;
			}
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy517;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'e') goto yy521;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy71;
		goto yy56;
	} else {
		if (yych <= '5') goto yy522;
		if (yych == ':') goto yy71;
		goto yy56;
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych <= 'Q') goto yy453;
			if (yych <= 'R') goto yy523;
			goto yy505;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'r') goto yy523;
			if (yych <= 's') goto yy505;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy301;
			goto yy108;
		} else {
			if (yych <= '@') goto yy301;
			if (yych <= 'Q') goto yy453;
			goto yy524;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy301;
			goto yy453;
		} else {
			if (yych <= 'r') goto yy524;
			if (yych <= 'z') goto yy453;
			goto yy301;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy525;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy453;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy525;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy453;
			goto yy526;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'o') goto yy526;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy301;
			goto yy108;
		} else {
			if (yych <= '@') goto yy301;
			if (yych <= 'R') goto yy453;
			goto yy527;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy301;
			goto yy453;
		} else {
			if (yych <= 's') goto yy527;
			if (yych <= 'z') goto yy453;
			goto yy301;
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy453;
			goto yy528;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'l') goto yy528;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy18;
				goto yy283;
			} else {
				if (yych <= '@') goto yy18;
				if (yych <= 'Q') goto yy453;
				goto yy523;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy505;
				goto yy453;
			} else {
				if (yych == '_') goto yy283;
				goto yy18;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy459;
				goto yy529;
			} else {
				if (yych <= 's') goto yy508;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy301;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy301;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy524;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy301;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy301;
				goto yy459;
			} else {
				if (yych <= 'r') goto yy530;
				if (yych <= 'z') goto yy459;
				goto yy301;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy525;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy531;
			if (yych <= 'z') goto yy459;
			goto yy18;
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy526;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'o') goto yy532;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy301;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy301;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy527;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy301;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy301;
				goto yy459;
			} else {
				if (yych <= 's') goto yy533;
				if (yych <= 'z') goto yy459;
				goto yy301;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy528;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'l') goto yy534;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy18;
			goto yy135;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy135;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy18;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy535;
				goto yy453;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy453;
				goto yy18;
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy301;
			goto yy108;
		} else {
			if (yych <= '@') goto yy301;
			if (yych <= 'M') goto yy453;
			goto yy536;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy301;
			goto yy453;
		} else {
			if (yych <= 'n') goto yy536;
			if (yych <= 'z') goto yy453;
			goto yy301;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'J') goto yy453;
			goto yy537;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 'k') goto yy537;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy301;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy301;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy536;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy301;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy301;
				goto yy459;
			} else {
				if (yych <= 'n') goto yy538;
				if (yych <= 'z') goto yy459;
				goto yy301;
			}
		}
	}
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy537;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 'k') goto yy539;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy453;
			goto yy540;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy453;
			if (yych <= '`') goto yy18;
			goto yy453;
		} else {
			if (yych <= 't') goto yy540;
			if (yych <= 'z') goto yy453;
			goto yy18;
		}
	}
yy372:
	YYDEBUG(372, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy453;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy540;
			if (yych <= 'Z') goto yy453;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy459;
			} else {
				if (yych <= 't') goto yy541;
				if (yych <= 'z') goto yy459;
				goto yy18;
			}
		}
	}
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy542;
	goto yy186;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy426;
	if (yych == 'c') goto yy426;
	goto yy56;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy543;
				} else {
					if (yych == 'D') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy186;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy18;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy18;
					goto yy544;
				} else {
					if (yych == 'D') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy18;
				if (yych <= 'H') goto yy186;
				goto yy18;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy18;
				} else {
					if (yych == 'V') goto yy18;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy18;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy108;
	goto yy18;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy544;
	goto yy186;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy545;
	goto yy56;
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy546;
	goto yy56;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy547;
	if (yych <= '3') goto yy549;
	if (yych <= '9') goto yy550;
	goto yy56;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy427;
	if (yych == 'p') goto yy427;
	goto yy56;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy551;
	if (yych <= '6') goto yy552;
	if (yych <= '9') goto yy553;
	goto yy56;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy554;
	if (yych <= '6') goto yy555;
	if (yych <= '9') goto yy556;
	goto yy56;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy557;
	goto yy56;
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy558;
	goto yy56;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy558;
	goto yy56;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy558;
	goto yy56;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy559;
	if (yych == 'r') goto yy559;
	goto yy56;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy559;
	if (yych == 'g') goto yy559;
	goto yy56;
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy559;
	if (yych == 'c') goto yy559;
	goto yy56;
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy559;
	if (yych == 'b') goto yy559;
	goto yy56;
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy559;
	if (yych == 'n') goto yy559;
	goto yy56;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy559;
		if (yych <= 'M') goto yy56;
		goto yy559;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy559;
		} else {
			if (yych == 'n') goto yy559;
			goto yy56;
		}
	}
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy559;
		if (yych <= 'X') goto yy56;
		goto yy559;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy559;
		} else {
			if (yych == 'y') goto yy559;
			goto yy56;
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy559;
	if (yych == 'v') goto yy559;
	goto yy56;
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy559;
	if (yych == 't') goto yy559;
	goto yy56;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy560;
	if (yych == 'p') goto yy560;
	goto yy56;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy381;
		goto yy379;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy561;
		goto yy56;
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy381;
		goto yy379;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '2') goto yy561;
		goto yy56;
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy562;
	case '1':	goto yy563;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy443;
	case 'A':
	case 'a':	goto yy444;
	case 'D':
	case 'd':	goto yy445;
	case 'F':
	case 'f':	goto yy446;
	case 'J':
	case 'j':	goto yy447;
	case 'M':
	case 'm':	goto yy448;
	case 'N':
	case 'n':	goto yy449;
	case 'O':
	case 'o':	goto yy450;
	case 'S':
	case 's':	goto yy451;
	default:	goto yy56;
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy565;
				} else {
					if (yych <= ' ') goto yy565;
					if (yych >= '-') goto yy566;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy567;
					if (yych <= '/') goto yy568;
					goto yy569;
				} else {
					if (yych <= '1') goto yy570;
					if (yych <= '2') goto yy571;
					goto yy572;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy573;
					if (yych <= '6') goto yy574;
					goto yy575;
				} else {
					if (yych <= ':') goto yy576;
					if (yych >= 'A') goto yy565;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy565;
				} else {
					if (yych == 'G') goto yy403;
					if (yych <= 'J') goto yy565;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy565;
					if (yych >= 'S') goto yy565;
				} else {
					if (yych <= 'W') goto yy588;
					if (yych <= 'Y') goto yy565;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy565;
					if (yych >= 'd') goto yy565;
				} else {
					if (yych == 'f') goto yy565;
					if (yych >= 'h') goto yy565;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy565;
				} else {
					if (yych <= 'o') goto yy565;
					if (yych >= 's') goto yy565;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy565;
				} else {
					if (yych <= 'y') goto yy565;
					if (yych == 0xC2) goto yy565;
				}
			}
		}
	}
yy403:
	YYDEBUG(403, *YYCURSOR);
#line 1260 "parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr(&ptr, 2);
				s->time->i = timelib_get_nr(&ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr(&ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 10383 "<stdout>"
yy404:
	YYDEBUG(404, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy565;
				} else {
					if (yych <= ' ') goto yy565;
					if (yych >= '-') goto yy566;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy567;
					if (yych <= '/') goto yy568;
					goto yy590;
				} else {
					if (yych <= '1') goto yy591;
					if (yych <= '2') goto yy592;
					goto yy593;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy575;
					if (yych <= ':') goto yy576;
				} else {
					if (yych <= 'A') goto yy565;
					if (yych >= 'D') goto yy565;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy565;
				} else {
					if (yych <= 'J') goto yy565;
					if (yych >= 'M') goto yy565;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy405;
					if (yych <= 'V') goto yy565;
					goto yy588;
				} else {
					if (yych <= 'Y') goto yy565;
					if (yych >= 'a') goto yy565;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy565;
				} else {
					if (yych != 'g') goto yy565;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy565;
				} else {
					if (yych <= 'o') goto yy565;
					if (yych >= 's') goto yy565;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy565;
				} else {
					if (yych <= 'y') goto yy565;
					if (yych == 0xC2) goto yy565;
				}
			}
		}
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
#line 1642 "parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 10472 "<stdout>"
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'I') goto yy594;
			if (yych == 'i') goto yy594;
			goto yy77;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'U') goto yy595;
			if (yych == 'u') goto yy595;
			goto yy77;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy596;
	if (yych == 's') goto yy596;
	goto yy250;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'E') goto yy597;
			if (yych == 'e') goto yy597;
			goto yy77;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'R') goto yy598;
			if (yych == 'r') goto yy598;
			goto yy77;
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy599;
	if (yych == 't') goto yy599;
	goto yy56;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy600;
	if (yych == 'd') goto yy600;
	goto yy250;
yy413:
	YYDEBUG(413, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy408;
	if (yych == 'r') goto yy408;
	goto yy56;
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy601;
	goto yy241;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'U') goto yy602;
			if (yych == 'u') goto yy602;
			goto yy77;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'Y') goto yy243;
			if (yych == 'y') goto yy243;
			goto yy77;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'E') goto yy243;
			if (yych == 'e') goto yy243;
			goto yy77;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'C') goto yy603;
			if (yych == 'c') goto yy603;
			goto yy77;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy604;
	if (yych == 'r') goto yy604;
	goto yy56;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy605;
	if (yych == 'l') goto yy605;
	goto yy56;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy596;
		if (yych <= 'T') goto yy250;
		goto yy606;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy250;
			goto yy596;
		} else {
			if (yych == 'u') goto yy606;
			goto yy250;
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy600;
		if (yych <= 'S') goto yy250;
		goto yy607;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy250;
			goto yy600;
		} else {
			if (yych == 't') goto yy607;
			goto yy250;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy408;
	if (yych == 'c') goto yy408;
	goto yy56;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'O') goto yy608;
			if (yych == 'o') goto yy608;
			goto yy77;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy609;
	if (yych == 'u') goto yy609;
	goto yy250;
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy610;
		if (yych <= 'R') goto yy250;
		goto yy596;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy250;
			goto yy610;
		} else {
			if (yych == 's') goto yy596;
			goto yy250;
		}
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy238;
			goto yy77;
		} else {
			if (yych <= ' ') goto yy238;
			if (yych <= ',') goto yy77;
			goto yy238;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy240;
			goto yy77;
		} else {
			if (yych <= 'T') goto yy409;
			if (yych == 't') goto yy409;
			goto yy77;
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy611;
	if (yych == 'r') goto yy611;
	goto yy250;
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy612;
	if (yych == 's') goto yy612;
	goto yy250;
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy613;
	if (yych == 'n') goto yy613;
	goto yy250;
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy614;
	if (yych == 'k') goto yy614;
	goto yy56;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy197;
	if (yych <= '0') goto yy615;
	if (yych <= '1') goto yy616;
	if (yych <= '9') goto yy617;
	goto yy197;
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy618;
	if (yych <= '6') goto yy619;
	if (yych <= '9') goto yy553;
	goto yy56;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy620;
			if (yych <= 0x1F) goto yy209;
			goto yy620;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy209;
				goto yy379;
			} else {
				if (yych <= '.') goto yy433;
				if (yych <= '9') goto yy209;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy101;
			if (yych <= 'O') goto yy209;
			goto yy101;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy101;
			} else {
				if (yych == 'p') goto yy101;
				goto yy209;
			}
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy622;
	if (yych <= '6') goto yy623;
	if (yych <= '9') goto yy556;
	goto yy56;
yy436:
	YYDEBUG(436, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy620;
			if (yych <= 0x1F) goto yy209;
			goto yy620;
		} else {
			if (yych == '.') goto yy435;
			if (yych <= '9') goto yy209;
			goto yy435;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy101;
			if (yych <= 'O') goto yy209;
			goto yy101;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy101;
			} else {
				if (yych == 'p') goto yy101;
				goto yy209;
			}
		}
	}
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy620;
			if (yych <= 0x1F) goto yy209;
			goto yy620;
		} else {
			if (yych == '.') goto yy435;
			if (yych <= '9') goto yy209;
			goto yy624;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy101;
			if (yych <= 'O') goto yy209;
			goto yy101;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy101;
			} else {
				if (yych == 'p') goto yy101;
				goto yy209;
			}
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(439, *YYCURSOR);
#line 1197 "parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr(&ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr(&ptr, 2);
			}
		}
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 10982 "<stdout>"
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy438;
		if (yych <= 0x08) goto yy56;
		goto yy438;
	} else {
		if (yych == ' ') goto yy438;
		goto yy56;
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy625;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy626;
	goto yy56;
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy625;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy626;
	goto yy56;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy625;
	goto yy56;
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy627;
		if (yych <= 'T') goto yy56;
		goto yy628;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy627;
		} else {
			if (yych == 'u') goto yy628;
			goto yy56;
		}
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy629;
	if (yych == 'e') goto yy629;
	goto yy56;
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy630;
	if (yych == 'e') goto yy630;
	goto yy56;
yy447:
	YYDEBUG(447, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy631;
		if (yych <= 'T') goto yy56;
		goto yy632;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy631;
		} else {
			if (yych == 'u') goto yy632;
			goto yy56;
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy633;
	if (yych == 'a') goto yy633;
	goto yy56;
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy634;
	if (yych == 'o') goto yy634;
	goto yy56;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy635;
	if (yych == 'c') goto yy635;
	goto yy56;
yy451:
	YYDEBUG(451, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy636;
	if (yych == 'e') goto yy636;
	goto yy56;
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy637;
	goto yy276;
yy453:
	YYDEBUG(453, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy638;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy638;
		goto yy18;
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy135;
	if (yych <= '2') goto yy639;
	if (yych <= '3') goto yy640;
	goto yy135;
yy455:
	YYDEBUG(455, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'K') goto yy638;
			goto yy641;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'l') goto yy641;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy638;
			goto yy642;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 's') goto yy642;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(458, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy457;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy18;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy18;
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy638;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy643;
			goto yy18;
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy457;
	}
	if (yych <= '/') goto yy135;
	if (yych <= '2') goto yy639;
	if (yych <= '3') goto yy640;
	goto yy135;
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy641;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'l') goto yy644;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy642;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 's') goto yy645;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy646;
		if (yych <= '(') goto yy18;
		goto yy108;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			goto yy638;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy646;
			goto yy18;
		} else {
			if (yych <= ')') goto yy108;
			if (yych == '-') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy283;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy638;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy643;
			goto yy18;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy638;
			goto yy647;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'm') goto yy647;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy647;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'm') goto yy648;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy638;
			goto yy649;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 't') goto yy649;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy638;
			goto yy650;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'e') goto yy650;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy649;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 't') goto yy651;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy650;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'e') goto yy652;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'T') goto yy638;
			goto yy653;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'u') goto yy653;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy638;
			goto yy654;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'h') goto yy654;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy638;
			goto yy655;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 't') goto yy655;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy638;
			goto yy656;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 't') goto yy656;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy657;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy638;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy657;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy638;
			goto yy658;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 't') goto yy658;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy653;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'u') goto yy659;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy654;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'h') goto yy660;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy655;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 't') goto yy661;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy656;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 't') goto yy662;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy657;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy663;
			if (yych <= 'z') goto yy643;
			goto yy18;
		}
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy658;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 't') goto yy664;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy483:
	YYDEBUG(483, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy665;
	if (yych <= '2') goto yy666;
	if (yych <= '9') goto yy667;
	goto yy56;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy668;
		goto yy56;
	} else {
		if (yych <= '0') goto yy669;
		if (yych <= '9') goto yy487;
		if (yych <= ':') goto yy668;
		goto yy56;
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy56;
	} else {
		if (yych <= '2') goto yy487;
		if (yych <= '9') goto yy669;
		if (yych <= ':') goto yy670;
		goto yy56;
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy56;
	} else {
		if (yych <= '4') goto yy669;
		if (yych == ':') goto yy670;
		goto yy56;
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy670;
	if (yych == ':') goto yy670;
	goto yy56;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy671;
	if (yych <= '2') goto yy672;
	if (yych <= '9') goto yy669;
	goto yy56;
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy668;
		goto yy311;
	} else {
		if (yych <= '0') goto yy673;
		if (yych <= '9') goto yy674;
		if (yych <= ':') goto yy668;
		goto yy311;
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy311;
	} else {
		if (yych <= '2') goto yy674;
		if (yych <= '9') goto yy673;
		if (yych <= ':') goto yy670;
		goto yy311;
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy311;
	} else {
		if (yych <= '4') goto yy673;
		if (yych <= '9') goto yy675;
		if (yych <= ':') goto yy670;
		goto yy311;
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy311;
	} else {
		if (yych <= '9') goto yy675;
		if (yych <= ':') goto yy670;
		goto yy311;
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy676;
	goto yy56;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy310;
	goto yy313;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy678;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy638;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy678;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy281;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy281;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy281;
			if (yych <= '9') goto yy135;
			goto yy281;
		} else {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy281;
			if (yych <= 'z') goto yy638;
			goto yy281;
		}
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy678;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy679;
			if (yych <= 'z') goto yy643;
			goto yy18;
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy281;
			goto yy135;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy281;
				goto yy108;
			} else {
				if (yych <= ',') goto yy281;
				if (yych <= '-') goto yy680;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy283;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy281;
			goto yy638;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy281;
				goto yy283;
			} else {
				if (yych <= '`') goto yy281;
				if (yych <= 'z') goto yy643;
				goto yy281;
			}
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy681;
		} else {
			if (yych == ' ') goto yy683;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy638;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy681;
			if (yych <= 0x1F) goto yy18;
			goto yy683;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy283;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy638;
			goto yy641;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'h') goto yy641;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy638;
			goto yy684;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'i') goto yy684;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy641;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'h') goto yy644;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy684;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'i') goto yy685;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy681;
		} else {
			if (yych == ' ') goto yy681;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy638;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
	} else {
		if (yych <= 'Z') goto yy638;
		if (yych <= '`') goto yy507;
		if (yych <= 'z') goto yy638;
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
#line 1042 "parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12216 "<stdout>"
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy681;
			if (yych <= 0x1F) goto yy18;
			goto yy681;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy283;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy507;
		} else {
			if (yych == '.') goto yy507;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy507;
			if (yych <= 'Z') goto yy638;
			goto yy507;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy507;
			if (yych <= 'z') goto yy643;
			goto yy507;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy638;
			goto yy686;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'b') goto yy686;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy686;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'b') goto yy687;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'H') goto yy638;
			goto yy688;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'i') goto yy688;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy688;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'i') goto yy689;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy638;
			goto yy690;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'r') goto yy690;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy638;
			goto yy691;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'n') goto yy691;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy281;
			} else {
				if (yych <= '-') goto yy454;
				if (yych <= '.') goto yy135;
				goto yy281;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy135;
				goto yy281;
			} else {
				if (yych == 'E') goto yy692;
				goto yy638;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy281;
				goto yy638;
			} else {
				if (yych <= 'e') goto yy692;
				if (yych <= 'z') goto yy638;
				goto yy281;
			}
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy638;
			goto yy693;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'n') goto yy693;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy690;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'r') goto yy694;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy691;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'n') goto yy695;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy281;
				goto yy135;
			} else {
				if (yych == ' ') goto yy135;
				goto yy281;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy108;
				if (yych <= ',') goto yy281;
				goto yy460;
			} else {
				if (yych == '/') goto yy283;
				goto yy135;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy281;
				goto yy638;
			} else {
				if (yych <= 'E') goto yy692;
				if (yych <= 'Z') goto yy638;
				goto yy281;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy281;
				goto yy643;
			} else {
				if (yych <= 'e') goto yy696;
				if (yych <= 'z') goto yy643;
				goto yy281;
			}
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy693;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'n') goto yy697;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy698;
	goto yy56;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy638;
			goto yy654;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'd') goto yy654;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy638;
			goto yy690;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 's') goto yy690;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy638;
			goto yy699;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'y') goto yy699;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy638;
			goto yy701;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'r') goto yy701;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy638;
			goto yy702;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'd') goto yy702;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'E') goto yy638;
			goto yy693;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'f') goto yy693;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy654;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'd') goto yy660;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy690;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 's') goto yy694;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy699;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'y') goto yy703;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy701;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'r') goto yy704;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy533:
	YYDEBUG(533, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy702;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'd') goto yy705;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy534:
	YYDEBUG(534, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy693;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'f') goto yy697;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy18;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy18;
			if (yych <= '9') goto yy135;
			goto yy18;
		} else {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy638;
			goto yy706;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'e') goto yy706;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy638;
			goto yy707;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'd') goto yy707;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy706;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'e') goto yy708;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy707;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'd') goto yy709;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy638;
			goto yy710;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy638;
			if (yych <= '`') goto yy18;
			goto yy638;
		} else {
			if (yych <= 'e') goto yy710;
			if (yych <= 'z') goto yy638;
			goto yy18;
		}
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy638;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy710;
			if (yych <= 'Z') goto yy638;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy643;
			} else {
				if (yych <= 'e') goto yy711;
				if (yych <= 'z') goto yy643;
				goto yy18;
			}
		}
	}
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy575;
	goto yy186;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy18;
				goto yy186;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy18;
					goto yy712;
				} else {
					if (yych <= '/') goto yy18;
					if (yych <= '9') goto yy713;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
					goto yy18;
				} else {
					if (yych == 'G') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy18;
					goto yy186;
				} else {
					if (yych <= 'R') goto yy18;
					if (yych <= 'U') goto yy186;
					goto yy18;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
					goto yy18;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych <= 'c') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy18;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy18;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy18;
				} else {
					if (yych == 'v') goto yy18;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy18;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy18;
				}
			}
		}
	}
yy544:
	YYDEBUG(544, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy712;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy713;
	goto yy186;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy714;
	goto yy56;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy715;
	goto yy56;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy717;
		if (yych >= 'n') goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
		}
	}
yy548:
	YYDEBUG(548, *YYCURSOR);
#line 1394 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 13282 "<stdout>"
yy549:
	YYDEBUG(549, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy548;
			goto yy717;
		} else {
			if (yych <= '9') goto yy714;
			if (yych <= 'm') goto yy548;
			goto yy718;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy550:
	YYDEBUG(550, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy714;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy551:
	YYDEBUG(551, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy722;
	goto yy209;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy721;
		goto yy209;
	} else {
		if (yych <= '0') goto yy722;
		if (yych <= '9') goto yy715;
		goto yy209;
	}
yy553:
	YYDEBUG(553, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy715;
	goto yy209;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy556;
	goto yy209;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych != '0') goto yy209;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	goto yy209;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy723;
	goto yy214;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy385;
	goto yy214;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy724;
	goto yy56;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy724;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy559;
		if (yych == 't') goto yy559;
		goto yy56;
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy725;
	if (yych <= '.') goto yy379;
	goto yy56;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy625;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy443;
	goto yy56;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy625;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy443;
	goto yy56;
yy564:
	YYDEBUG(564, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy565:
	YYDEBUG(565, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy564;
					goto yy56;
				} else {
					if (yych <= ' ') goto yy564;
					if (yych <= ',') goto yy56;
					goto yy726;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy577;
					goto yy56;
				} else {
					if (yych <= 'D') goto yy578;
					if (yych == 'F') goto yy579;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy75;
					if (yych <= 'I') goto yy580;
					goto yy582;
				} else {
					if (yych <= 'L') goto yy56;
					if (yych <= 'M') goto yy583;
					goto yy584;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy585;
					if (yych <= 'R') goto yy56;
					goto yy586;
				} else {
					if (yych <= 'T') goto yy83;
					if (yych <= 'U') goto yy84;
					if (yych <= 'V') goto yy587;
					goto yy86;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy589;
					if (yych <= 'Y') goto yy88;
					goto yy56;
				} else {
					if (yych <= 'a') goto yy577;
					if (yych <= 'c') goto yy56;
					goto yy578;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy579;
					goto yy56;
				} else {
					if (yych <= 'h') goto yy75;
					if (yych == 'j') goto yy582;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy583;
					if (yych <= 'n') goto yy584;
					goto yy585;
				} else {
					if (yych <= 'r') goto yy56;
					if (yych <= 's') goto yy586;
					if (yych <= 't') goto yy83;
					goto yy84;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy86;
					goto yy56;
				} else {
					if (yych <= 'y') goto yy88;
					if (yych == 0xC2) goto yy93;
					goto yy56;
				}
			}
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy728;
	case '1':	goto yy730;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy731;
	case 'A':
	case 'a':	goto yy732;
	case 'D':
	case 'd':	goto yy733;
	case 'F':
	case 'f':	goto yy734;
	case 'J':
	case 'j':	goto yy735;
	case 'M':
	case 'm':	goto yy736;
	case 'N':
	case 'n':	goto yy737;
	case 'O':
	case 'o':	goto yy738;
	case 'S':
	case 's':	goto yy739;
	case 'W':	goto yy740;
	default:	goto yy727;
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy727;
	if (yych <= '0') goto yy741;
	if (yych <= '2') goto yy742;
	if (yych <= '3') goto yy743;
	goto yy727;
yy568:
	YYDEBUG(568, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy748;
	if (yych <= '1') goto yy749;
	if (yych <= '9') goto yy750;
	goto yy56;
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '0') goto yy751;
	if (yych <= '9') goto yy753;
	goto yy186;
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '2') goto yy753;
	if (yych <= '9') goto yy754;
	goto yy186;
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy754;
	goto yy186;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '5') goto yy754;
	if (yych <= '6') goto yy755;
	if (yych <= '9') goto yy756;
	goto yy186;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy756;
	goto yy186;
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '0') goto yy756;
	if (yych <= '9') goto yy757;
	goto yy186;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy757;
	goto yy186;
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy758;
	if (yych <= '1') goto yy759;
	goto yy56;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy760;
		if (yych <= 'T') goto yy56;
		goto yy761;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy760;
		} else {
			if (yych == 'u') goto yy761;
			goto yy56;
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy232;
		if (yych <= 'D') goto yy56;
		goto yy762;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy232;
		} else {
			if (yych == 'e') goto yy762;
			goto yy56;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy763;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy235;
			if (yych <= 'Q') goto yy56;
			goto yy236;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy763;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy235;
			if (yych == 'r') goto yy236;
			goto yy56;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy764;
	} else {
		if (yych == 'W') goto yy581;
		if (yych <= 'X') goto yy765;
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
#line 1463 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 13701 "<stdout>"
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy766;
		if (yych <= 'T') goto yy56;
		goto yy767;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy766;
		} else {
			if (yych == 'u') goto yy767;
			goto yy56;
		}
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy768;
			if (yych <= 'H') goto yy56;
			goto yy247;
		} else {
			if (yych == 'O') goto yy248;
			if (yych <= 'R') goto yy56;
			goto yy249;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy768;
			if (yych <= 'h') goto yy56;
			goto yy247;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy56;
				goto yy248;
			} else {
				if (yych == 's') goto yy249;
				goto yy56;
			}
		}
	}
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy769;
	if (yych == 'o') goto yy769;
	goto yy56;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy770;
	if (yych == 'c') goto yy770;
	goto yy56;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy771;
			if (yych <= 'T') goto yy56;
			goto yy255;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy253;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy771;
			if (yych == 'u') goto yy255;
			goto yy56;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy589;
	goto yy581;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy772;
		if (yych <= '4') goto yy773;
		goto yy774;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy259;
		} else {
			if (yych == 'e') goto yy259;
			goto yy56;
		}
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy764;
	goto yy581;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '0') goto yy775;
	if (yych <= '9') goto yy776;
	goto yy186;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '2') goto yy776;
	if (yych <= '9') goto yy777;
	goto yy186;
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy777;
	goto yy186;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '5') goto yy777;
	if (yych <= '6') goto yy778;
	if (yych <= '9') goto yy757;
	goto yy186;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy243;
	if (yych == 'l') goto yy243;
	goto yy56;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy779;
	if (yych == 's') goto yy779;
	goto yy56;
yy596:
	YYDEBUG(596, *YYCURSOR);
	++YYCURSOR;
	goto yy250;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy608;
	if (yych == 'm') goto yy608;
	goto yy56;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy602;
	if (yych == 'u') goto yy602;
	goto yy56;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy780;
		if (yych <= 'M') goto yy56;
		goto yy781;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy780;
		} else {
			if (yych == 'n') goto yy781;
			goto yy56;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy782;
	if (yych == 'a') goto yy782;
	goto yy56;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy241;
	if (yych <= '9') goto yy783;
	goto yy241;
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy784;
	if (yych == 'a') goto yy784;
	goto yy56;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy243;
	if (yych == 'h') goto yy243;
	goto yy56;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy785;
	if (yych == 'o') goto yy785;
	goto yy56;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy785;
	if (yych == 'i') goto yy785;
	goto yy56;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy786;
	if (yych == 't') goto yy786;
	goto yy56;
yy607:
	YYDEBUG(607, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy408;
	if (yych == 'h') goto yy408;
	goto yy56;
yy608:
	YYDEBUG(608, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy787;
	if (yych == 'b') goto yy787;
	goto yy56;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy612;
	if (yych == 'r') goto yy612;
	goto yy56;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy788;
	if (yych == 'n') goto yy788;
	goto yy56;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy612;
	if (yych != 's') goto yy56;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy600;
	if (yych == 'd') goto yy600;
	goto yy56;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy611;
	if (yych == 'e') goto yy611;
	goto yy56;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy188;
		if (yych <= 'R') goto yy250;
		goto yy596;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy250;
			goto yy188;
		} else {
			if (yych == 's') goto yy596;
			goto yy250;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy379;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy617;
	goto yy56;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy379;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy379;
	goto yy56;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy789;
	goto yy209;
yy619:
	YYDEBUG(619, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy721;
		goto yy209;
	} else {
		if (yych <= '0') goto yy789;
		if (yych <= '9') goto yy715;
		goto yy209;
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(621, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy620;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy620;
			if (yych <= '@') goto yy56;
			goto yy101;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy101;
			goto yy56;
		} else {
			if (yych <= 'a') goto yy101;
			if (yych == 'p') goto yy101;
			goto yy56;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy790;
	goto yy209;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych == '0') goto yy790;
	goto yy209;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy791;
	if (yych <= '6') goto yy792;
	if (yych <= '9') goto yy556;
	goto yy56;
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy793;
	if (yych <= '3') goto yy794;
	if (yych <= '9') goto yy795;
	goto yy56;
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy796;
	goto yy56;
yy627:
	YYDEBUG(627, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy797;
	if (yych == 'r') goto yy797;
	goto yy56;
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy797;
	if (yych == 'g') goto yy797;
	goto yy56;
yy629:
	YYDEBUG(629, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy797;
	if (yych == 'c') goto yy797;
	goto yy56;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy797;
	if (yych == 'b') goto yy797;
	goto yy56;
yy631:
	YYDEBUG(631, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy797;
	if (yych == 'n') goto yy797;
	goto yy56;
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy797;
		if (yych <= 'M') goto yy56;
		goto yy797;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy797;
		} else {
			if (yych == 'n') goto yy797;
			goto yy56;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy797;
		if (yych <= 'X') goto yy56;
		goto yy797;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy797;
		} else {
			if (yych == 'y') goto yy797;
			goto yy56;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy797;
	if (yych == 'v') goto yy797;
	goto yy56;
yy635:
	YYDEBUG(635, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy797;
	if (yych == 't') goto yy797;
	goto yy56;
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy798;
	if (yych == 'p') goto yy798;
	goto yy56;
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy799;
	goto yy276;
yy638:
	YYDEBUG(638, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Z') goto yy800;
		if (yych <= '`') goto yy18;
		if (yych <= 'z') goto yy800;
		goto yy18;
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy801;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy312;
				goto yy56;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy801;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy318;
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy281;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy281;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy281;
			if (yych <= '9') goto yy135;
			goto yy281;
		} else {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy281;
			if (yych <= 'z') goto yy800;
			goto yy281;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy800;
			goto yy802;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 't') goto yy802;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy803;
			goto yy18;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy135;
			if (yych <= 0x1F) goto yy281;
			goto yy135;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy281;
				goto yy108;
			} else {
				if (yych <= ',') goto yy281;
				if (yych <= '-') goto yy680;
				goto yy135;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy283;
			if (yych <= '9') goto yy135;
			if (yych <= '@') goto yy281;
			goto yy800;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy281;
				goto yy283;
			} else {
				if (yych <= '`') goto yy281;
				if (yych <= 'z') goto yy803;
				goto yy281;
			}
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy802;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 't') goto yy804;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy805;
	if (yych == 'o') goto yy805;
	goto yy56;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'A') goto yy800;
			goto yy806;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'b') goto yy806;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy806;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'b') goto yy807;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy808;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy808;
			if (yych == ')') goto yy108;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy810;
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych == 'h') goto yy810;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'M') goto yy800;
			goto yy811;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'n') goto yy811;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy18;
				goto yy808;
			} else {
				if (yych == ' ') goto yy808;
				goto yy18;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy108;
				goto yy18;
			} else {
				if (yych == '.') goto yy18;
				goto yy283;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy18;
				goto yy800;
			} else {
				if (yych <= 'H') goto yy810;
				if (yych <= 'Z') goto yy800;
				goto yy18;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy283;
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'h') goto yy812;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy811;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'n') goto yy813;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy814;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy814;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy654:
	YYDEBUG(654, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy808;
		} else {
			if (yych == ' ') goto yy808;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy800;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy655:
	YYDEBUG(655, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy18;
			goto yy808;
		} else {
			if (yych == ' ') goto yy815;
			goto yy18;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy108;
			if (yych <= '@') goto yy18;
			goto yy800;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'G') goto yy800;
			goto yy810;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'h') goto yy810;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'X') goto yy800;
			goto yy816;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'y') goto yy816;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy646;
		if (yych <= '(') goto yy18;
		goto yy108;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy18;
			goto yy800;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy814;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy817;
			if (yych <= 'z') goto yy803;
			goto yy18;
		}
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy808;
			if (yych <= 0x1F) goto yy18;
			goto yy808;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy283;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy808;
			if (yych <= 0x1F) goto yy18;
			goto yy815;
		} else {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy18;
				goto yy283;
			} else {
				if (yych <= '`') goto yy18;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy662:
	YYDEBUG(662, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy810;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'h') goto yy812;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy663:
	YYDEBUG(663, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy816;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'y') goto yy818;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy646;
			goto yy18;
		} else {
			if (yych <= ')') goto yy108;
			if (yych == '-') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy283;
			if (yych <= '@') goto yy18;
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy18;
			if (yych <= 'z') goto yy803;
			goto yy18;
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '9') goto yy667;
	if (yych <= ':') goto yy193;
	goto yy18;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy18;
		if (yych >= '5') goto yy377;
	} else {
		if (yych <= '9') goto yy108;
		if (yych <= ':') goto yy193;
		goto yy18;
	}
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy18;
	if (yych <= '5') goto yy377;
	if (yych <= '9') goto yy108;
	if (yych <= ':') goto yy193;
	goto yy18;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy819;
	if (yych <= '9') goto yy821;
	goto yy56;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy668;
	if (yych == ':') goto yy668;
	goto yy56;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy822;
	if (yych <= '9') goto yy823;
	goto yy56;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy668;
		goto yy56;
	} else {
		if (yych <= '9') goto yy669;
		if (yych <= ':') goto yy668;
		goto yy56;
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy668;
		goto yy56;
	} else {
		if (yych <= '4') goto yy669;
		if (yych == ':') goto yy668;
		goto yy56;
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy668;
		goto yy311;
	} else {
		if (yych <= '9') goto yy824;
		if (yych <= ':') goto yy668;
		goto yy311;
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy670;
		goto yy311;
	} else {
		if (yych <= '9') goto yy824;
		if (yych <= ':') goto yy670;
		goto yy311;
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy311;
	if (yych <= '9') goto yy824;
	goto yy311;
yy676:
	YYDEBUG(676, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(677, *YYCURSOR);
#line 1449 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15005 "<stdout>"
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy800;
			goto yy825;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'r') goto yy825;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy825;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'r') goto yy826;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy457;
	}
	goto yy135;
yy681:
	YYDEBUG(681, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy682:
	YYDEBUG(682, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy681;
				if (yych <= 0x1F) goto yy56;
				goto yy681;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy827;
				} else {
					if (yych == 'F') goto yy828;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy829;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy830;
					if (yych <= 'R') goto yy56;
					goto yy831;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy832;
					goto yy833;
				} else {
					if (yych == 'W') goto yy834;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy835;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy827;
					if (yych <= 'e') goto yy56;
					goto yy828;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy829;
				} else {
					if (yych == 'm') goto yy830;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy831;
					goto yy832;
				} else {
					if (yych <= 'u') goto yy833;
					if (yych <= 'v') goto yy56;
					goto yy834;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy835;
				} else {
					if (yych == 0xC2) goto yy836;
					goto yy56;
				}
			}
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy837;
	if (yych == 'd') goto yy837;
	goto yy682;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'F') goto yy800;
			goto yy838;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'g') goto yy838;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy838;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'g') goto yy839;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'D') goto yy800;
			goto yy840;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'e') goto yy840;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy840;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'e') goto yy841;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'N') goto yy800;
			goto yy842;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'o') goto yy842;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy842;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'o') goto yy843;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy800;
			goto yy844;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'd') goto yy844;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'C') goto yy800;
			goto yy810;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'd') goto yy810;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'L') goto yy800;
			goto yy845;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'm') goto yy845;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'S') goto yy800;
			goto yy846;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 't') goto yy846;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy844;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'd') goto yy847;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy810;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'd') goto yy812;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy845;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'm') goto yy848;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy846;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 't') goto yy849;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy403;
	if (yych <= '5') goto yy850;
	if (yych <= '6') goto yy851;
	goto yy403;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy108;
	} else {
		if (yych <= 'Z') goto yy800;
		if (yych <= '`') goto yy700;
		if (yych <= 'z') goto yy800;
	}
yy700:
	YYDEBUG(700, *YYCURSOR);
#line 1054 "parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 15563 "<stdout>"
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy800;
			goto yy852;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'r') goto yy852;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy853;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy853;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy700;
		} else {
			if (yych == '.') goto yy700;
			goto yy283;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy700;
			if (yych <= 'Z') goto yy800;
			goto yy700;
		} else {
			if (yych <= '_') goto yy283;
			if (yych <= '`') goto yy700;
			if (yych <= 'z') goto yy803;
			goto yy700;
		}
	}
yy704:
	YYDEBUG(704, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy852;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'r') goto yy854;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy705:
	YYDEBUG(705, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy853;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy855;
			if (yych <= 'z') goto yy803;
			goto yy18;
		}
	}
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'R') goto yy800;
			goto yy856;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 's') goto yy856;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		if (yych <= '@') goto yy18;
		goto yy857;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy800;
			goto yy18;
		} else {
			if (yych <= 'a') goto yy857;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy708:
	YYDEBUG(708, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy856;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 's') goto yy858;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy709:
	YYDEBUG(709, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy857;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy859;
			if (yych <= 'z') goto yy803;
			goto yy18;
		}
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy18;
			goto yy108;
		} else {
			if (yych <= '@') goto yy18;
			if (yych <= 'Q') goto yy800;
			goto yy860;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy800;
			if (yych <= '`') goto yy18;
			goto yy800;
		} else {
			if (yych <= 'r') goto yy860;
			if (yych <= 'z') goto yy800;
			goto yy18;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy108;
			if (yych <= ',') goto yy18;
			goto yy283;
		} else {
			if (yych == '/') goto yy283;
			if (yych <= '@') goto yy18;
			goto yy800;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy860;
			if (yych <= 'Z') goto yy800;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy18;
				goto yy803;
			} else {
				if (yych <= 'r') goto yy861;
				if (yych <= 'z') goto yy803;
				goto yy18;
			}
		}
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy862;
	if (yych <= '1') goto yy863;
	goto yy56;
yy713:
	YYDEBUG(713, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy865;
	goto yy186;
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy866;
	goto yy56;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy716;
	if (yych <= '9') goto yy866;
yy716:
	YYDEBUG(716, *YYCURSOR);
#line 1435 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 15877 "<stdout>"
yy717:
	YYDEBUG(717, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy866;
		if (yych <= 'm') goto yy548;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy867;
	goto yy56;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy867;
	goto yy56;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy867;
	goto yy56;
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy868;
	goto yy56;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy866;
	goto yy209;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy870;
	goto yy214;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy871;
	goto yy56;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy872;
	if (yych <= '3') goto yy873;
	if (yych <= '9') goto yy550;
	goto yy56;
yy726:
	YYDEBUG(726, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy727:
	YYDEBUG(727, *YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy726;
	case 'A':
	case 'a':	goto yy577;
	case 'D':
	case 'd':	goto yy744;
	case 'F':
	case 'f':	goto yy745;
	case 'I':	goto yy580;
	case 'J':
	case 'j':	goto yy582;
	case 'M':
	case 'm':	goto yy746;
	case 'N':
	case 'n':	goto yy584;
	case 'O':
	case 'o':	goto yy585;
	case 'S':
	case 's':	goto yy747;
	case 'V':	goto yy587;
	case 'X':	goto yy589;
	default:	goto yy56;
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy874;
	if (yych <= '/') goto yy729;
	if (yych <= '9') goto yy875;
yy729:
	YYDEBUG(729, *YYCURSOR);
#line 1380 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 15999 "<stdout>"
yy730:
	YYDEBUG(730, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy874;
	if (yych <= '/') goto yy729;
	if (yych <= '2') goto yy875;
	goto yy729;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy874;
	goto yy729;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy876;
		if (yych <= 'T') goto yy56;
		goto yy877;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy876;
		} else {
			if (yych == 'u') goto yy877;
			goto yy56;
		}
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy878;
	if (yych == 'e') goto yy878;
	goto yy56;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy879;
	if (yych == 'e') goto yy879;
	goto yy56;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy880;
		if (yych <= 'T') goto yy56;
		goto yy881;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy880;
		} else {
			if (yych == 'u') goto yy881;
			goto yy56;
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy882;
	if (yych == 'a') goto yy882;
	goto yy56;
yy737:
	YYDEBUG(737, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy883;
	if (yych == 'o') goto yy883;
	goto yy56;
yy738:
	YYDEBUG(738, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy884;
	if (yych == 'c') goto yy884;
	goto yy56;
yy739:
	YYDEBUG(739, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy885;
	if (yych == 'e') goto yy885;
	goto yy56;
yy740:
	YYDEBUG(740, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy772;
	if (yych <= '4') goto yy773;
	if (yych <= '5') goto yy774;
	goto yy56;
yy741:
	YYDEBUG(741, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy886;
	if (yych <= '9') goto yy887;
	goto yy56;
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy887;
	goto yy56;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy887;
	if (yych <= '6') goto yy888;
	goto yy56;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy762;
	if (yych == 'e') goto yy762;
	goto yy56;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy763;
	if (yych == 'e') goto yy763;
	goto yy56;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy768;
	if (yych == 'a') goto yy768;
	goto yy56;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy889;
	if (yych == 'e') goto yy889;
	goto yy56;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy890;
	if (yych <= '9') goto yy891;
	goto yy56;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy890;
	if (yych <= '2') goto yy891;
	goto yy56;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy890;
	goto yy56;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy186;
				} else {
					if (yych == ' ') goto yy186;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy892;
					goto yy893;
				} else {
					if (yych <= '3') goto yy895;
					if (yych <= '9') goto yy896;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
				} else {
					if (yych != 'G') goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy186;
				} else {
					if (yych <= 'R') goto yy752;
					if (yych <= 'U') goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych >= 'd') goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy186;
				} else {
					if (yych == 'h') goto yy186;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
				} else {
					if (yych != 'v') goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
				}
			}
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
#line 1306 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 16243 "<stdout>"
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy752;
				goto yy186;
			} else {
				if (yych <= '2') {
					if (yych <= '/') goto yy752;
					goto yy893;
				} else {
					if (yych <= '3') goto yy895;
					if (yych <= '9') goto yy896;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy186;
					goto yy752;
				} else {
					if (yych == 'G') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy752;
					goto yy186;
				} else {
					if (yych <= 'R') goto yy752;
					if (yych <= 'U') goto yy186;
					goto yy752;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy186;
					goto yy752;
				} else {
					if (yych <= 'Y') goto yy186;
					if (yych <= 'c') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy752;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy752;
				} else {
					if (yych == 'v') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy752;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy752;
				}
			}
		}
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy752;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy752;
					goto yy896;
				} else {
					if (yych == 'D') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy752;
				if (yych <= 'H') goto yy186;
				goto yy752;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy752;
				} else {
					if (yych == 'V') goto yy752;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy752;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy752;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy752;
				} else {
					if (yych == 'v') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy752;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy752;
				}
			}
		}
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy752;
				goto yy186;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy752;
					goto yy896;
				} else {
					if (yych <= '9') goto yy897;
					if (yych <= 'C') goto yy752;
					goto yy186;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy752;
					goto yy186;
				} else {
					if (yych == 'H') goto yy186;
					goto yy752;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy752;
				} else {
					if (yych == 'V') goto yy752;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy752;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy752;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy752;
				} else {
					if (yych == 'v') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy752;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy752;
				}
			}
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy752;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy752;
					goto yy897;
				} else {
					if (yych == 'D') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy752;
				if (yych <= 'H') goto yy186;
				goto yy752;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy752;
				} else {
					if (yych == 'V') goto yy752;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy752;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy752;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy752;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy752;
				} else {
					if (yych == 'v') goto yy752;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy752;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy752;
				}
			}
		}
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy897;
	goto yy186;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy898;
	goto yy56;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy898;
	goto yy56;
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy899;
	if (yych == 'r') goto yy899;
	goto yy56;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy900;
	if (yych == 'g') goto yy900;
	goto yy56;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy901;
	if (yych == 'c') goto yy901;
	goto yy56;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy902;
	if (yych == 'b') goto yy902;
	goto yy56;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy581;
yy765:
	YYDEBUG(765, *YYCURSOR);
	++YYCURSOR;
	goto yy581;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy903;
	if (yych == 'n') goto yy903;
	goto yy56;
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy904;
		if (yych <= 'M') goto yy56;
		goto yy905;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy904;
		} else {
			if (yych == 'n') goto yy905;
			goto yy56;
		}
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy906;
		if (yych <= 'X') goto yy56;
		goto yy765;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy906;
		} else {
			if (yych == 'y') goto yy765;
			goto yy56;
		}
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy901;
	if (yych == 'v') goto yy901;
	goto yy56;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy907;
	if (yych == 't') goto yy907;
	goto yy56;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy426;
		if (yych <= 'O') goto yy56;
		goto yy908;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy426;
		} else {
			if (yych == 'p') goto yy908;
			goto yy56;
		}
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy909;
	goto yy56;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy909;
	goto yy56;
yy774:
	YYDEBUG(774, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '3') goto yy909;
	goto yy56;
yy775:
	YYDEBUG(775, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy186;
		if (yych <= '0') goto yy892;
		goto yy893;
	} else {
		if (yych <= '3') goto yy895;
		if (yych <= '9') goto yy896;
		goto yy186;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '2') goto yy893;
	if (yych <= '3') goto yy895;
	if (yych <= '9') goto yy896;
	goto yy186;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy896;
	goto yy186;
yy778:
	YYDEBUG(778, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '6') goto yy896;
	if (yych <= '9') goto yy897;
	goto yy186;
yy779:
	YYDEBUG(779, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy243;
	if (yych == 't') goto yy243;
	goto yy56;
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy781;
	if (yych != 'n') goto yy56;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy911;
	if (yych == 'i') goto yy911;
	goto yy56;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy596;
	if (yych == 'y') goto yy596;
	goto yy56;
yy783:
	YYDEBUG(783, *YYCURSOR);
	++YYCURSOR;
	goto yy241;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy912;
	if (yych == 'r') goto yy912;
	goto yy56;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy913;
	if (yych == 's') goto yy913;
	goto yy56;
yy786:
	YYDEBUG(786, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy408;
	if (yych == 'e') goto yy408;
	goto yy56;
yy787:
	YYDEBUG(787, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy914;
	if (yych == 'e') goto yy914;
	goto yy56;
yy788:
	YYDEBUG(788, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy408;
	if (yych == 'd') goto yy408;
	goto yy56;
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy620;
			if (yych <= 0x1F) goto yy209;
			goto yy620;
		} else {
			if (yych == '.') goto yy721;
			if (yych <= '/') goto yy209;
			goto yy866;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy101;
			if (yych <= 'O') goto yy209;
			goto yy101;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy101;
			} else {
				if (yych == 'p') goto yy101;
				goto yy209;
			}
		}
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy620;
			goto yy209;
		} else {
			if (yych <= ' ') goto yy620;
			if (yych == '.') goto yy721;
			goto yy209;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy101;
			if (yych == 'P') goto yy101;
			goto yy209;
		} else {
			if (yych <= 'a') goto yy101;
			if (yych == 'p') goto yy101;
			goto yy209;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy915;
	goto yy209;
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy721;
	if (yych == '0') goto yy915;
	goto yy209;
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy795;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '1') goto yy795;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy718;
		goto yy548;
	} else {
		if (yych <= 'r') goto yy718;
		if (yych <= 's') goto yy719;
		if (yych <= 't') goto yy720;
		goto yy548;
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy916;
	if (yych <= '3') goto yy917;
	if (yych <= '9') goto yy795;
	goto yy56;
yy797:
	YYDEBUG(797, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy918;
	goto yy56;
yy798:
	YYDEBUG(798, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy918;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy797;
		if (yych == 't') goto yy797;
		goto yy56;
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy919;
	goto yy276;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy108;
	goto yy18;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy310;
				goto yy56;
			} else {
				if (yych <= '\t') goto yy312;
				if (yych <= 0x1F) goto yy56;
				goto yy312;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy56;
				if (yych <= ',') goto yy312;
				goto yy920;
			} else {
				if (yych <= '.') goto yy312;
				if (yych <= '/') goto yy56;
				goto yy493;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy56;
				goto yy312;
			} else {
				if (yych == 'h') goto yy312;
				goto yy56;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy315;
				if (yych <= 'q') goto yy56;
				goto yy315;
			} else {
				if (yych <= 's') goto yy316;
				if (yych <= 't') goto yy317;
				goto yy56;
			}
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy281;
			goto yy135;
		} else {
			if (yych == ' ') goto yy135;
			goto yy281;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy108;
			if (yych <= ',') goto yy281;
			goto yy135;
		} else {
			if (yych <= '/') goto yy281;
			if (yych <= '9') goto yy135;
			goto yy281;
		}
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy108;
		if (yych <= ',') goto yy18;
		goto yy283;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy18;
			goto yy283;
		} else {
			if (yych == '_') goto yy283;
			goto yy18;
		}
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy281;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych == ')') goto yy108;
			goto yy281;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy680;
			if (yych <= '.') goto yy135;
			goto yy283;
		} else {
			if (yych <= '9') goto yy135;
			if (yych == '_') goto yy283;
			goto yy281;
		}
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy923;
	if (yych == 'f') goto yy923;
	goto yy56;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'E') goto yy924;
		if (yych == 'e') goto yy924;
		goto yy18;
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy924;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'e') goto yy925;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy809:
	YYDEBUG(809, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy808;
				if (yych <= 0x1F) goto yy56;
				goto yy808;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy56;
					goto yy827;
				} else {
					if (yych == 'F') goto yy828;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy829;
					goto yy56;
				} else {
					if (yych <= 'M') goto yy830;
					if (yych <= 'R') goto yy56;
					goto yy831;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy832;
					goto yy833;
				} else {
					if (yych == 'W') goto yy926;
					goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy835;
					goto yy56;
				} else {
					if (yych <= 'd') goto yy827;
					if (yych <= 'e') goto yy56;
					goto yy828;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy56;
					goto yy829;
				} else {
					if (yych == 'm') goto yy830;
					goto yy56;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy831;
					goto yy832;
				} else {
					if (yych <= 'u') goto yy833;
					if (yych <= 'v') goto yy56;
					goto yy926;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy56;
					goto yy835;
				} else {
					if (yych == 0xC2) goto yy836;
					goto yy56;
				}
			}
		}
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy808;
		goto yy18;
	} else {
		if (yych <= ' ') goto yy808;
		if (yych == ')') goto yy108;
		goto yy18;
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'T') goto yy927;
		if (yych == 't') goto yy927;
		goto yy18;
	}
yy812:
	YYDEBUG(812, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy808;
			goto yy18;
		} else {
			if (yych <= ' ') goto yy808;
			if (yych <= '(') goto yy18;
			goto yy108;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy283;
			goto yy18;
		} else {
			if (yych <= '/') goto yy283;
			if (yych == '_') goto yy283;
			goto yy18;
		}
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy927;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 't') goto yy928;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy814:
	YYDEBUG(814, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy929;
		if (yych == 'r') goto yy929;
		goto yy18;
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy837;
	if (yych == 'd') goto yy837;
	goto yy809;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy108;
	goto yy301;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy929;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'r') goto yy930;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy818:
	YYDEBUG(818, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy108;
		if (yych <= ',') goto yy301;
		goto yy283;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy301;
			goto yy283;
		} else {
			if (yych == '_') goto yy283;
			goto yy301;
		}
	}
yy819:
	YYDEBUG(819, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy931;
	} else {
		if (yych <= '9') goto yy821;
		if (yych <= ':') goto yy931;
	}
yy820:
	YYDEBUG(820, *YYCURSOR);
#line 1779 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 17336 "<stdout>"
yy821:
	YYDEBUG(821, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy931;
	if (yych == ':') goto yy931;
	goto yy820;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy932;
		goto yy820;
	} else {
		if (yych <= '9') goto yy933;
		if (yych <= ':') goto yy932;
		goto yy820;
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy932;
	if (yych == ':') goto yy932;
	goto yy820;
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy311;
	if (yych <= '9') goto yy934;
	goto yy311;
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy935;
		if (yych == 'y') goto yy935;
		goto yy18;
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy935;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'y') goto yy936;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy937;
	if (yych == 'a') goto yy937;
	goto yy56;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy938;
		if (yych <= 'Q') goto yy56;
		goto yy939;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy938;
		} else {
			if (yych == 'r') goto yy939;
			goto yy56;
		}
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy940;
	if (yych == 'o') goto yy940;
	goto yy56;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy941;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy942;
			if (yych <= 'R') goto yy56;
			goto yy943;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy941;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy942;
			if (yych == 's') goto yy943;
			goto yy56;
		}
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy945;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy946;
			if (yych <= 'T') goto yy56;
			goto yy947;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy945;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy946;
			if (yych == 'u') goto yy947;
			goto yy56;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy948;
		if (yych <= 'T') goto yy56;
		goto yy949;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy948;
		} else {
			if (yych == 'u') goto yy949;
			goto yy56;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy950;
	if (yych == 's') goto yy950;
	goto yy56;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy951;
	if (yych == 'e') goto yy951;
	goto yy56;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy952;
	if (yych == 'e') goto yy952;
	goto yy56;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy953;
	goto yy56;
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy954;
	if (yych == 'a') goto yy954;
	goto yy56;
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy955;
		if (yych == 'h') goto yy955;
		goto yy18;
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy955;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'h') goto yy956;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'R') goto yy935;
		if (yych == 'r') goto yy935;
		goto yy18;
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy935;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'r') goto yy936;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'U') goto yy957;
		if (yych == 'u') goto yy957;
		goto yy18;
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy957;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'u') goto yy958;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'A') goto yy959;
		if (yych == 'a') goto yy959;
		goto yy18;
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'B') goto yy960;
		if (yych == 'b') goto yy960;
		goto yy18;
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'H') goto yy961;
		if (yych == 'h') goto yy961;
		goto yy18;
	}
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy959;
			if (yych <= '^') goto yy18;
			goto yy283;
		} else {
			if (yych <= '`') goto yy18;
			if (yych <= 'a') goto yy962;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy848:
	YYDEBUG(848, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy960;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'b') goto yy963;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy849:
	YYDEBUG(849, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy961;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'h') goto yy964;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy965;
	goto yy56;
yy851:
	YYDEBUG(851, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy965;
	goto yy56;
yy852:
	YYDEBUG(852, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'O') goto yy966;
		if (yych == 'o') goto yy966;
		goto yy18;
	}
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy967;
		if (yych == 'y') goto yy967;
		goto yy18;
	}
yy854:
	YYDEBUG(854, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy966;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'o') goto yy968;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy967;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'y') goto yy969;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy970;
		if (yych == 'd') goto yy970;
		goto yy18;
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'Y') goto yy971;
		if (yych == 'y') goto yy971;
		goto yy18;
	}
yy858:
	YYDEBUG(858, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy970;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'd') goto yy972;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy859:
	YYDEBUG(859, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy971;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'y') goto yy973;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy860:
	YYDEBUG(860, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy108;
		goto yy18;
	} else {
		if (yych <= 'D') goto yy974;
		if (yych == 'd') goto yy974;
		goto yy18;
	}
yy861:
	YYDEBUG(861, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy108;
			goto yy18;
		} else {
			if (yych == '.') goto yy18;
			if (yych <= '/') goto yy283;
			goto yy18;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy974;
			if (yych == '_') goto yy283;
			goto yy18;
		} else {
			if (yych == 'd') goto yy975;
			if (yych <= 'z') goto yy921;
			goto yy18;
		}
	}
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy976;
	goto yy56;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy976;
	goto yy56;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy977;
	if (yych <= '1') goto yy978;
	goto yy56;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy979;
	goto yy186;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy980;
	goto yy56;
yy867:
	YYDEBUG(867, *YYCURSOR);
	++YYCURSOR;
	goto yy548;
yy868:
	YYDEBUG(868, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(869, *YYCURSOR);
	if (yych <= '/') goto yy209;
	if (yych <= '9') goto yy868;
	goto yy209;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy214;
	if (yych <= '9') goto yy982;
	goto yy214;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy983;
	goto yy56;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy984;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy548;
			goto yy984;
		} else {
			if (yych <= '9') goto yy714;
			if (yych <= 'm') goto yy548;
			goto yy718;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy986;
	if (yych <= '3') goto yy987;
	if (yych <= '9') goto yy988;
	goto yy56;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy989;
	goto yy729;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy990;
	if (yych == 'r') goto yy990;
	goto yy56;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy991;
	if (yych == 'g') goto yy991;
	goto yy56;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy992;
	if (yych == 'c') goto yy992;
	goto yy56;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy993;
	if (yych == 'b') goto yy993;
	goto yy56;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy994;
	if (yych == 'n') goto yy994;
	goto yy56;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy995;
		if (yych <= 'M') goto yy56;
		goto yy996;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy995;
		} else {
			if (yych == 'n') goto yy996;
			goto yy56;
		}
	}
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy997;
		if (yych <= 'X') goto yy56;
		goto yy998;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy997;
		} else {
			if (yych == 'y') goto yy998;
			goto yy56;
		}
	}
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy992;
	if (yych == 'v') goto yy992;
	goto yy56;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy999;
	if (yych == 't') goto yy999;
	goto yy56;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1000;
	if (yych == 'p') goto yy1000;
	goto yy56;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy1001;
	goto yy56;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1001;
	goto yy56;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy1001;
	goto yy56;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy908;
	if (yych == 'p') goto yy908;
	goto yy56;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1002;
	if (yych <= '3') goto yy1004;
	if (yych <= '9') goto yy1005;
	goto yy56;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy1006;
	goto yy56;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1007;
	goto yy186;
yy893:
	YYDEBUG(893, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych >= ' ') goto yy186;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy1007;
				} else {
					if (yych == 'D') goto yy186;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy894;
				if (yych <= 'H') goto yy186;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
				} else {
					if (yych != 'V') goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych >= 'd') goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy186;
				} else {
					if (yych == 'h') goto yy186;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
				} else {
					if (yych != 'v') goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
				}
			}
		}
	}
yy894:
	YYDEBUG(894, *YYCURSOR);
#line 1541 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->d = timelib_get_nr(&ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 18233 "<stdout>"
yy895:
	YYDEBUG(895, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy894;
				goto yy186;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy894;
					goto yy1007;
				} else {
					if (yych <= '9') goto yy1009;
					if (yych <= 'C') goto yy894;
					goto yy186;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy894;
					goto yy186;
				} else {
					if (yych == 'H') goto yy186;
					goto yy894;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy894;
				} else {
					if (yych == 'V') goto yy894;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy894;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy894;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy894;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy894;
				} else {
					if (yych == 'v') goto yy894;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy894;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy894;
				}
			}
		}
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy186;
				if (yych <= 0x1F) goto yy894;
				goto yy186;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy894;
					goto yy1009;
				} else {
					if (yych == 'D') goto yy186;
					goto yy894;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy894;
				if (yych <= 'H') goto yy186;
				goto yy894;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy186;
					goto yy894;
				} else {
					if (yych == 'V') goto yy894;
					goto yy186;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy186;
				if (yych <= 'c') goto yy894;
				goto yy186;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy894;
					goto yy186;
				} else {
					if (yych == 'h') goto yy186;
					goto yy894;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy186;
					goto yy894;
				} else {
					if (yych == 'v') goto yy894;
					goto yy186;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy894;
					goto yy186;
				} else {
					if (yych == 0xC2) goto yy186;
					goto yy894;
				}
			}
		}
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1009;
	goto yy186;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1010;
	goto yy56;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy1011;
	if (yych == 'i') goto yy1011;
	goto yy581;
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1012;
	if (yych == 'u') goto yy1012;
	goto yy581;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1013;
	if (yych == 'e') goto yy1013;
	goto yy581;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy1014;
	if (yych == 'r') goto yy1014;
	goto yy581;
yy903:
	YYDEBUG(903, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy1015;
	if (yych == 'u') goto yy1015;
	goto yy581;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy765;
	if (yych == 'y') goto yy765;
	goto yy581;
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy765;
	if (yych == 'e') goto yy765;
	goto yy581;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy1016;
	if (yych == 'c') goto yy1016;
	goto yy581;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy1017;
	if (yych == 'o') goto yy1017;
	goto yy581;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy901;
	if (yych == 't') goto yy901;
	goto yy581;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1018;
	if (yych <= '/') goto yy910;
	if (yych <= '7') goto yy1019;
yy910:
	YYDEBUG(910, *YYCURSOR);
#line 1574 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 18482 "<stdout>"
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1021;
	if (yych == 'g') goto yy1021;
	goto yy56;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy243;
	if (yych == 'y') goto yy243;
	goto yy56;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1022;
	if (yych == 'e') goto yy1022;
	goto yy56;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy243;
	if (yych == 'r') goto yy243;
	goto yy56;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy620;
			if (yych <= 0x1F) goto yy209;
			goto yy620;
		} else {
			if (yych == '.') goto yy1023;
			if (yych <= '9') goto yy209;
			goto yy1024;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy101;
			if (yych <= 'O') goto yy209;
			goto yy101;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy209;
				goto yy101;
			} else {
				if (yych == 'p') goto yy101;
				goto yy209;
			}
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '9') goto yy1025;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy548;
		if (yych <= '1') goto yy1025;
		if (yych <= 'm') goto yy548;
		goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
			goto yy548;
		}
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1026;
	if (yych <= '3') goto yy1027;
	goto yy56;
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy1028;
	goto yy276;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1029;
	goto yy56;
yy921:
	YYDEBUG(921, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy922:
	YYDEBUG(922, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy56;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy56;
	}
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1031;
	goto yy56;
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy935;
	if (yych == 'r') goto yy935;
	goto yy56;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy935;
	if (yych == 'r') goto yy936;
	goto yy922;
yy926:
	YYDEBUG(926, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1032;
	if (yych == 'e') goto yy1032;
	goto yy56;
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy961;
	if (yych == 'h') goto yy961;
	goto yy56;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy961;
	if (yych == 'h') goto yy964;
	goto yy922;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy935;
	if (yych == 'y') goto yy935;
	goto yy56;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy935;
	if (yych == 'y') goto yy936;
	goto yy922;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1033;
	if (yych <= '6') goto yy1034;
	if (yych <= '9') goto yy1035;
	goto yy56;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1036;
	if (yych <= '6') goto yy1037;
	if (yych <= '9') goto yy1035;
	goto yy56;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1038;
			if (yych <= 0x1F) goto yy820;
			goto yy1038;
		} else {
			if (yych == '.') goto yy932;
			if (yych <= '9') goto yy820;
			goto yy932;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy1040;
			if (yych <= 'O') goto yy820;
			goto yy1040;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy820;
				goto yy1040;
			} else {
				if (yych == 'p') goto yy1040;
				goto yy820;
			}
		}
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	++YYCURSOR;
	goto yy311;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy135;
		if (yych <= 0x1F) goto yy281;
		goto yy135;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy281;
			goto yy135;
		} else {
			if (yych <= '/') goto yy281;
			if (yych <= '9') goto yy135;
			goto yy281;
		}
	}
yy936:
	YYDEBUG(936, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy135;
			goto yy281;
		} else {
			if (yych <= ' ') goto yy135;
			if (yych <= ',') goto yy281;
			goto yy680;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy283;
			goto yy135;
		} else {
			if (yych == '_') goto yy283;
			goto yy281;
		}
	}
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1041;
	if (yych == 'y') goto yy1041;
	goto yy56;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1042;
	if (yych == 'r') goto yy1042;
	goto yy56;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1043;
	if (yych == 'i') goto yy1043;
	goto yy56;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1044;
	if (yych == 'u') goto yy1044;
	goto yy56;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1045;
			goto yy56;
		} else {
			if (yych <= 'L') goto yy1046;
			if (yych <= 'M') goto yy56;
			goto yy1047;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1045;
			goto yy56;
		} else {
			if (yych <= 'l') goto yy1046;
			if (yych == 'n') goto yy1047;
			goto yy56;
		}
	}
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1048;
	if (yych == 'n') goto yy1048;
	goto yy56;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1049;
	if (yych == 'e') goto yy1049;
yy944:
	YYDEBUG(944, *YYCURSOR);
#line 1714 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18826 "<stdout>"
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1050;
	if (yych == 't') goto yy1050;
	goto yy56;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1051;
	if (yych == 'c') goto yy1051;
	goto yy56;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1043;
	if (yych == 'n') goto yy1043;
	goto yy56;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1052;
	if (yych == 'u') goto yy1052;
	goto yy56;
yy949:
	YYDEBUG(949, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1053;
	if (yych == 'e') goto yy1053;
	goto yy56;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1049;
	if (yych == 'e') goto yy1049;
	goto yy56;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1054;
		goto yy1055;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1054;
		if (yych <= 'e') goto yy1055;
		goto yy56;
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1044;
	if (yych == 'a') goto yy1044;
	goto yy56;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy943;
	if (yych == 's') goto yy943;
	goto yy56;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1056;
	if (yych == 'y') goto yy1056;
	goto yy56;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1057;
	if (yych == 't') goto yy1057;
	goto yy56;
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1057;
	if (yych == 't') goto yy1058;
	goto yy922;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1059;
	if (yych == 's') goto yy1059;
	goto yy56;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1059;
	if (yych == 's') goto yy1060;
	goto yy922;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy967;
	if (yych == 'y') goto yy967;
	goto yy56;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy924;
	if (yych == 'e') goto yy924;
	goto yy56;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy808;
	if (yych == ' ') goto yy808;
	goto yy56;
yy962:
	YYDEBUG(962, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy967;
	if (yych == 'y') goto yy969;
	goto yy922;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy924;
	if (yych == 'e') goto yy925;
	goto yy922;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy808;
	if (yych == ' ') goto yy808;
	goto yy922;
yy965:
	YYDEBUG(965, *YYCURSOR);
	++YYCURSOR;
	goto yy752;
yy966:
	YYDEBUG(966, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1061;
	if (yych == 'w') goto yy1061;
	goto yy56;
yy967:
	YYDEBUG(967, *YYCURSOR);
	++YYCURSOR;
	goto yy301;
yy968:
	YYDEBUG(968, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1061;
	if (yych == 'w') goto yy1063;
	goto yy922;
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy301;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy301;
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy959;
	if (yych == 'a') goto yy959;
	goto yy56;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy967;
	if (yych == 's') goto yy967;
	goto yy301;
yy972:
	YYDEBUG(972, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy959;
	if (yych == 'a') goto yy962;
	goto yy922;
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy283;
			goto yy301;
		} else {
			if (yych <= '/') goto yy283;
			if (yych <= 'R') goto yy301;
			goto yy967;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy283;
			goto yy301;
		} else {
			if (yych == 's') goto yy969;
			if (yych <= 'z') goto yy921;
			goto yy301;
		}
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1064;
	if (yych == 'a') goto yy1064;
	goto yy56;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1064;
	if (yych == 'a') goto yy1065;
	goto yy922;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1066;
	goto yy56;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1067;
	goto yy56;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1067;
	goto yy56;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1068;
	goto yy186;
yy980:
	YYDEBUG(980, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(981, *YYCURSOR);
#line 1423 "parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr(&ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 19081 "<stdout>"
yy982:
	YYDEBUG(982, *YYCURSOR);
	++YYCURSOR;
	goto yy214;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1069;
	goto yy56;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy985;
		if (yych <= '9') goto yy866;
		if (yych >= 'n') goto yy718;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy718;
		} else {
			if (yych <= 's') goto yy719;
			if (yych <= 't') goto yy720;
		}
	}
yy985:
	YYDEBUG(985, *YYCURSOR);
#line 1354 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19123 "<stdout>"
yy986:
	YYDEBUG(986, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy548;
			goto yy988;
		} else {
			if (yych == 'T') goto yy1070;
			goto yy548;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1071;
			if (yych <= 'q') goto yy548;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy548;
		}
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy548;
		} else {
			if (yych == 'T') goto yy1070;
			goto yy548;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1071;
			if (yych <= 'q') goto yy548;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy548;
		}
	}
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1070;
		if (yych <= 'm') goto yy548;
		goto yy1071;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy548;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy548;
		}
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1074;
	if (yych <= '3') goto yy1075;
	if (yych <= '9') goto yy988;
	goto yy56;
yy990:
	YYDEBUG(990, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'I') goto yy1011;
		if (yych == 'i') goto yy1011;
		goto yy581;
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'U') goto yy1012;
		if (yych == 'u') goto yy1012;
		goto yy581;
	}
yy992:
	YYDEBUG(992, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'E') goto yy1013;
		if (yych == 'e') goto yy1013;
		goto yy581;
	}
yy993:
	YYDEBUG(993, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'R') goto yy1014;
		if (yych == 'r') goto yy1014;
		goto yy581;
	}
yy994:
	YYDEBUG(994, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'U') goto yy1015;
		if (yych == 'u') goto yy1015;
		goto yy581;
	}
yy995:
	YYDEBUG(995, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'Y') goto yy765;
		if (yych == 'y') goto yy765;
		goto yy581;
	}
yy996:
	YYDEBUG(996, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'E') goto yy765;
		if (yych == 'e') goto yy765;
		goto yy581;
	}
yy997:
	YYDEBUG(997, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'C') goto yy1016;
		if (yych == 'c') goto yy1016;
		goto yy581;
	}
yy998:
	YYDEBUG(998, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy918;
	goto yy581;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'O') goto yy1017;
		if (yych == 'o') goto yy1017;
		goto yy581;
	}
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy918;
		goto yy581;
	} else {
		if (yych <= 'T') goto yy992;
		if (yych == 't') goto yy992;
		goto yy581;
	}
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	++YYCURSOR;
	goto yy894;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1003;
		if (yych <= '9') goto yy1005;
		if (yych >= 'n') goto yy1076;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1076;
		} else {
			if (yych <= 's') goto yy1077;
			if (yych <= 't') goto yy1078;
		}
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
#line 1342 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19354 "<stdout>"
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1003;
		if (yych <= '1') goto yy1005;
		if (yych <= 'm') goto yy1003;
		goto yy1076;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1003;
			goto yy1076;
		} else {
			if (yych <= 's') goto yy1077;
			if (yych <= 't') goto yy1078;
			goto yy1003;
		}
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1076;
		goto yy1003;
	} else {
		if (yych <= 'r') goto yy1076;
		if (yych <= 's') goto yy1077;
		if (yych <= 't') goto yy1078;
		goto yy1003;
	}
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1079;
	if (yych <= '3') goto yy1080;
	if (yych <= '9') goto yy1005;
	goto yy56;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy185;
				} else {
					if (yych == ' ') goto yy185;
				}
			} else {
				if (yych <= 'C') {
					if (yych <= '9') goto yy1081;
				} else {
					if (yych <= 'D') goto yy188;
					if (yych >= 'F') goto yy189;
				}
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'H') {
					if (yych >= 'H') goto yy75;
				} else {
					if (yych == 'M') goto yy190;
				}
			} else {
				if (yych <= 'T') {
					if (yych <= 'S') goto yy191;
					goto yy1082;
				} else {
					if (yych <= 'U') goto yy84;
					if (yych >= 'W') goto yy86;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') {
					if (yych >= 'Y') goto yy88;
				} else {
					if (yych == 'd') goto yy188;
				}
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy189;
				} else {
					if (yych <= 'h') goto yy75;
					if (yych >= 'm') goto yy190;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych >= 's') goto yy191;
				} else {
					if (yych <= 't') goto yy1083;
					if (yych <= 'u') goto yy84;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'w') goto yy86;
					if (yych >= 'y') goto yy88;
				} else {
					if (yych == 0xC2) goto yy93;
				}
			}
		}
	}
yy1008:
	YYDEBUG(1008, *YYCURSOR);
#line 1503 "parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 19479 "<stdout>"
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1081;
	goto yy186;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1084;
	if (yych <= '3') goto yy1085;
	goto yy56;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy765;
	if (yych == 'l') goto yy765;
	goto yy56;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1086;
	if (yych == 's') goto yy1086;
	goto yy56;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1017;
	if (yych == 'm') goto yy1017;
	goto yy56;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1015;
	if (yych != 'u') goto yy56;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1087;
	if (yych == 'a') goto yy1087;
	goto yy56;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy765;
	if (yych == 'h') goto yy765;
	goto yy56;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1088;
	if (yych == 'b') goto yy1088;
	goto yy56;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1020, *YYCURSOR);
#line 1555 "parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr(&ptr, 4);
		w = timelib_get_nr(&ptr, 2);
		d = timelib_get_nr(&ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19561 "<stdout>"
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1089;
	if (yych == 'h') goto yy1089;
	goto yy56;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1090;
	if (yych == 'c') goto yy1090;
	goto yy56;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1091;
	goto yy56;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1093;
	goto yy56;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy718;
		goto yy985;
	} else {
		if (yych <= 'r') goto yy718;
		if (yych <= 's') goto yy719;
		if (yych <= 't') goto yy720;
		goto yy985;
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1095;
	goto yy56;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1095;
	goto yy56;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy276;
	if (yych <= '9') goto yy1097;
	goto yy276;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1030;
	if (yych <= '9') goto yy1098;
yy1030:
	YYDEBUG(1030, *YYCURSOR);
#line 1593 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 19637 "<stdout>"
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1099;
	if (yych <= '2') goto yy1101;
	if (yych <= '9') goto yy1102;
	goto yy56;
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1054;
		goto yy1103;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1054;
		if (yych <= 'e') goto yy1103;
		goto yy56;
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '9') goto yy1104;
	goto yy820;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1104;
	goto yy820;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	++YYCURSOR;
	goto yy820;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '9') goto yy1105;
	goto yy820;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1105;
	goto yy820;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1039, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1038;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1038;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1040;
			if (yych != 'p') goto yy56;
		}
	}
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1106;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1107;
		if (yych == 'm') goto yy1107;
		goto yy56;
	}
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1108;
	if (yych == 's') goto yy1108;
	goto yy944;
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1109;
	if (yych == 't') goto yy1109;
	goto yy56;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy944;
		goto yy1110;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy944;
			goto yy1112;
		} else {
			if (yych == 'd') goto yy1112;
			goto yy944;
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1041;
	if (yych == 'r') goto yy1041;
	goto yy56;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1113;
	if (yych == 'r') goto yy1113;
	goto yy56;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1114;
	if (yych == 'l') goto yy1114;
	goto yy56;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1108;
		if (yych <= 'T') goto yy944;
		goto yy1115;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy944;
			goto yy1108;
		} else {
			if (yych == 'u') goto yy1115;
			goto yy944;
		}
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1110;
			goto yy944;
		} else {
			if (yych <= ' ') goto yy1110;
			if (yych <= 'C') goto yy944;
			goto yy1112;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1116;
			goto yy944;
		} else {
			if (yych <= 'd') goto yy1112;
			if (yych == 't') goto yy1116;
			goto yy944;
		}
	}
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1041;
	if (yych == 'c') goto yy1041;
	goto yy56;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy944;
		goto yy1110;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy944;
			goto yy1117;
		} else {
			if (yych == 'u') goto yy1117;
			goto yy944;
		}
	}
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1118;
		if (yych <= 'R') goto yy944;
		goto yy1108;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy944;
			goto yy1118;
		} else {
			if (yych == 's') goto yy1108;
			goto yy944;
		}
	}
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy944;
		goto yy1110;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy944;
			goto yy1119;
		} else {
			if (yych == 'r') goto yy1119;
			goto yy944;
		}
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy944;
		goto yy1110;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy944;
			goto yy1120;
		} else {
			if (yych == 's') goto yy1120;
			goto yy944;
		}
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy944;
		goto yy1110;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy944;
			goto yy1121;
		} else {
			if (yych == 'n') goto yy1121;
			goto yy944;
		}
	}
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1122;
	if (yych == 'k') goto yy1122;
	goto yy56;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1124;
		goto yy944;
	} else {
		if (yych <= 'S') goto yy1108;
		if (yych == 's') goto yy1108;
		goto yy944;
	}
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	++YYCURSOR;
	goto yy700;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy700;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy700;
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy681;
	if (yych == ' ') goto yy681;
	goto yy56;
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy681;
	if (yych == ' ') goto yy681;
	goto yy922;
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	++YYCURSOR;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
#line 1064 "parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19961 "<stdout>"
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy1062;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy1062;
	}
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1125;
	if (yych == 'y') goto yy1125;
	goto yy56;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1125;
	if (yych == 'y') goto yy1127;
	goto yy922;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1128;
	if (yych <= '3') goto yy1129;
	goto yy56;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1130;
	goto yy56;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1131;
	goto yy186;
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1132;
	goto yy56;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1133;
	if (yych <= '2') goto yy1134;
	if (yych <= '9') goto yy1135;
	goto yy56;
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1136;
	goto yy56;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1136;
	goto yy56;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1136;
	goto yy56;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy548;
			goto yy1137;
		} else {
			if (yych == 'T') goto yy1070;
			goto yy548;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1071;
			if (yych <= 'q') goto yy548;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy548;
		}
	}
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy548;
			goto yy1137;
		} else {
			if (yych == 'T') goto yy1070;
			goto yy548;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1071;
			if (yych <= 'q') goto yy548;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy548;
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1138;
	goto yy56;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1138;
	goto yy56;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1138;
	goto yy56;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1003;
		if (yych <= '9') goto yy1139;
		if (yych <= 'm') goto yy1003;
		goto yy1076;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1003;
			goto yy1076;
		} else {
			if (yych <= 's') goto yy1077;
			if (yych <= 't') goto yy1078;
			goto yy1003;
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy1003;
		if (yych <= '1') goto yy1139;
		if (yych <= 'm') goto yy1003;
		goto yy1076;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1003;
			goto yy1076;
		} else {
			if (yych <= 's') goto yy1077;
			if (yych <= 't') goto yy1078;
			goto yy1003;
		}
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1140;
	goto yy186;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy1141;
			goto yy1142;
		} else {
			if (yych <= '9') goto yy1143;
			if (yych <= 'G') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy257;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy256;
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy1144;
			goto yy1145;
		} else {
			if (yych <= '9') goto yy1146;
			if (yych <= 'G') goto yy56;
			goto yy256;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy257;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy256;
			if (yych == 'u') goto yy257;
			goto yy56;
		}
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1147;
	goto yy56;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1147;
	goto yy56;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy765;
	if (yych == 't') goto yy765;
	goto yy56;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych == 'r') goto yy1148;
	goto yy56;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1149;
	if (yych == 'e') goto yy1149;
	goto yy56;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy408;
	if (yych == 't') goto yy408;
	goto yy56;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy610;
	if (yych == 'o') goto yy610;
	goto yy56;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1092, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy209;
			goto yy1091;
		} else {
			if (yych == 'A') goto yy1150;
			goto yy209;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1150;
			if (yych <= '`') goto yy209;
			goto yy1150;
		} else {
			if (yych == 'p') goto yy1150;
			goto yy209;
		}
	}
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1094, *YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy1093;
		} else {
			if (yych == 'A') goto yy1150;
			goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1150;
			if (yych <= '`') goto yy56;
			goto yy1150;
		} else {
			if (yych == 'p') goto yy1150;
			goto yy56;
		}
	}
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1096, *YYCURSOR);
#line 1607 "parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex(&ptr, 4, &length);
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 20296 "<stdout>"
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	++YYCURSOR;
	goto yy276;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1030;
	if (yych <= '9') goto yy1151;
	goto yy1030;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1152;
		} else {
			if (yych <= ' ') goto yy1152;
			if (yych <= '/') goto yy1100;
			if (yych <= '9') goto yy1102;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1154;
			if (yych == 'P') goto yy1154;
		} else {
			if (yych <= 'a') goto yy1154;
			if (yych == 'p') goto yy1154;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
#line 1152 "parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr(&ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr(&ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces(&ptr);
			s->time->h += timelib_meridian(&ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 20352 "<stdout>"
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1152;
			goto yy1100;
		} else {
			if (yych <= ' ') goto yy1152;
			if (yych <= '/') goto yy1100;
			if (yych >= '5') goto yy1100;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1154;
			if (yych == 'P') goto yy1154;
			goto yy1100;
		} else {
			if (yych <= 'a') goto yy1154;
			if (yych == 'p') goto yy1154;
			goto yy1100;
		}
	}
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1152;
			goto yy1100;
		} else {
			if (yych <= ' ') goto yy1152;
			if (yych <= '@') goto yy1100;
			goto yy1154;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1154;
			goto yy1100;
		} else {
			if (yych <= 'a') goto yy1154;
			if (yych == 'p') goto yy1154;
			goto yy1100;
		}
	}
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1155;
	if (yych == 'k') goto yy1155;
	goto yy56;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1157;
			goto yy820;
		} else {
			if (yych <= ' ') goto yy1157;
			if (yych == '(') goto yy1157;
			goto yy820;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy820;
			if (yych <= '-') goto yy1157;
			goto yy820;
		} else {
			if (yych <= 'Z') goto yy1157;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1157;
			goto yy820;
		}
	}
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1164;
			goto yy820;
		} else {
			if (yych <= ' ') goto yy1164;
			if (yych == '(') goto yy1164;
			goto yy820;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy820;
			if (yych <= '-') goto yy1164;
			goto yy820;
		} else {
			if (yych <= 'Z') goto yy1164;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1164;
			goto yy820;
		}
	}
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1107;
	if (yych != 'm') goto yy56;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1167;
		if (yych == '\t') goto yy1167;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1167;
		if (yych == '.') goto yy1169;
		goto yy56;
	}
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	++YYCURSOR;
	goto yy944;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1170;
		if (yych <= 'M') goto yy56;
		goto yy1171;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1170;
		} else {
			if (yych == 'n') goto yy1171;
			goto yy56;
		}
	}
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	YYDEBUG(1111, *YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1110;
		if (yych <= 0x1F) goto yy56;
		goto yy1110;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1172;
		} else {
			if (yych == 'o') goto yy1172;
			goto yy56;
		}
	}
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1173;
	if (yych == 'a') goto yy1173;
	goto yy56;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1174;
	if (yych == 'o') goto yy1174;
	goto yy56;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1174;
	if (yych == 'i') goto yy1174;
	goto yy56;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1175;
	if (yych == 't') goto yy1175;
	goto yy56;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1041;
	if (yych == 'h') goto yy1041;
	goto yy56;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1120;
	if (yych == 'r') goto yy1120;
	goto yy56;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1176;
	if (yych == 'n') goto yy1176;
	goto yy56;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1120;
	if (yych != 's') goto yy56;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1112;
	if (yych == 'd') goto yy1112;
	goto yy56;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1119;
	if (yych == 'e') goto yy1119;
	goto yy56;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy827;
		if (yych >= 'S') goto yy1108;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy827;
		} else {
			if (yych == 's') goto yy1108;
		}
	}
yy1123:
	YYDEBUG(1123, *YYCURSOR);
#line 1690 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text(&ptr, &behavior);
			timelib_eat_spaces(&ptr);
			timelib_set_relative(&ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20610 "<stdout>"
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1177;
	if (yych == 'o') goto yy1177;
	goto yy56;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	++YYCURSOR;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
#line 1021 "parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20633 "<stdout>"
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy921;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy283;
		goto yy1126;
	} else {
		if (yych <= '/') goto yy283;
		if (yych == '_') goto yy283;
		goto yy1126;
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1138;
	goto yy56;
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1138;
	goto yy56;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy1178;
	if (yych <= '3') goto yy1179;
	goto yy56;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1180;
	goto yy186;
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1181;
	goto yy56;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1135;
	if (yych <= ':') goto yy1182;
	goto yy56;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1135;
	if (yych == ':') goto yy1182;
	goto yy56;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1182;
	goto yy56;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1070;
	goto yy548;
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1183;
		if (yych <= 'm') goto yy1003;
		goto yy1071;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1003;
			goto yy1071;
		} else {
			if (yych <= 's') goto yy1072;
			if (yych <= 't') goto yy1073;
			goto yy1003;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	++YYCURSOR;
	goto yy1003;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1138;
		if (yych <= 'm') goto yy1003;
		goto yy1076;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy1003;
			goto yy1076;
		} else {
			if (yych <= 's') goto yy1077;
			if (yych <= 't') goto yy1078;
			goto yy1003;
		}
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1184;
	goto yy186;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1185;
	if (yych <= '9') goto yy1143;
	if (yych <= ':') goto yy1186;
	goto yy56;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy1185;
		goto yy1187;
	} else {
		if (yych == ':') goto yy1186;
		goto yy56;
	}
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1187;
	if (yych == ':') goto yy1186;
	goto yy56;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1188;
	if (yych <= '9') goto yy1146;
	goto yy56;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1188;
	if (yych <= '5') goto yy1187;
	goto yy56;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1187;
	goto yy56;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1189;
	goto yy56;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy765;
	if (yych == 'y') goto yy765;
	goto yy56;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy765;
	if (yych == 'r') goto yy765;
	goto yy56;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1190;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1191;
		if (yych == 'm') goto yy1191;
		goto yy56;
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1030;
	if (yych <= '9') goto yy1192;
	goto yy1030;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	YYDEBUG(1153, *YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1152;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy1152;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy1154;
			if (yych != 'p') goto yy56;
		}
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1193;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy1194;
		if (yych == 'm') goto yy1194;
		goto yy56;
	}
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy827;
		if (yych <= 'R') goto yy56;
		goto yy1108;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy827;
		} else {
			if (yych == 's') goto yy1108;
			goto yy56;
		}
	}
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1156;
			if (yych <= 0x1F) goto yy56;
			goto yy1156;
		} else {
			if (yych == '(') goto yy1158;
			if (yych <= '*') goto yy56;
			goto yy1159;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1159;
			if (yych <= '@') goto yy56;
			goto yy1160;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1161;
				goto yy1160;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy1162;
				goto yy56;
			}
		}
	}
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy1162;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy1162;
	goto yy56;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1195;
	if (yych <= '2') goto yy1196;
	if (yych <= '9') goto yy1197;
	goto yy56;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1198;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1199;
		goto yy820;
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy1035;
		if (yych <= '@') goto yy820;
		goto yy1198;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1200;
			goto yy1198;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1199;
			goto yy820;
		}
	}
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1198;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1198;
		goto yy820;
	}
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy1163;
			} else {
				if (yych == ' ') goto yy1163;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1158;
				if (yych <= '*') goto yy56;
				goto yy1159;
			} else {
				if (yych == '-') goto yy1159;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1165;
				if (yych <= 'F') goto yy1160;
				goto yy1161;
			} else {
				if (yych != 'P') goto yy1160;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy1166;
				goto yy1162;
			} else {
				if (yych <= 'p') goto yy1166;
				if (yych <= 'z') goto yy1162;
				goto yy56;
			}
		}
	}
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych <= '.') goto yy1106;
			if (yych <= '@') goto yy820;
			goto yy1198;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1201;
			if (yych <= 'Z') goto yy1198;
			goto yy820;
		} else {
			if (yych == 'm') goto yy1202;
			if (yych <= 'z') goto yy1199;
			goto yy820;
		}
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych <= '.') goto yy1106;
			if (yych <= '@') goto yy820;
			goto yy1198;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1201;
			if (yych <= 'Z') goto yy1198;
			goto yy820;
		} else {
			if (yych == 'm') goto yy1201;
			if (yych <= 'z') goto yy1198;
			goto yy820;
		}
	}
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1168, *YYCURSOR);
#line 1755 "parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month(&ptr);
		s->time->d = timelib_get_nr(&ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr, 8);
			}
		}

		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 21092 "<stdout>"
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1167;
		if (yych <= 0x08) goto yy56;
		goto yy1167;
	} else {
		if (yych == ' ') goto yy1167;
		goto yy56;
	}
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1171;
	if (yych != 'n') goto yy56;
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1203;
	if (yych == 'i') goto yy1203;
	goto yy56;
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1204;
	if (yych == 'f') goto yy1204;
	goto yy56;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1206;
	if (yych == 'y') goto yy1206;
	goto yy56;
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1207;
	if (yych == 's') goto yy1207;
	goto yy56;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1041;
	if (yych == 'e') goto yy1041;
	goto yy56;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1041;
	if (yych == 'd') goto yy1041;
	goto yy56;
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1208;
	if (yych == 'f') goto yy1208;
	goto yy56;
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1210;
	goto yy56;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1210;
	goto yy56;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1212;
	goto yy186;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1213;
	if (yych <= '2') goto yy1214;
	goto yy56;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1215;
	if (yych <= '9') goto yy1216;
	goto yy56;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1217;
	if (yych <= '2') goto yy1218;
	if (yych <= '9') goto yy1135;
	goto yy56;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1219;
	goto yy186;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1220;
	if (yych <= '9') goto yy1221;
	if (yych >= ';') goto yy56;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1222;
	goto yy56;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1221;
	goto yy56;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1220;
	if (yych <= '9') goto yy1221;
	goto yy56;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1223;
	if (yych <= '2') goto yy1224;
	goto yy56;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1191;
	if (yych != 'm') goto yy56;
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1225;
		if (yych == '\t') goto yy1225;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1225;
		if (yych == '.') goto yy1227;
		goto yy56;
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	++YYCURSOR;
	goto yy1030;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1194;
	if (yych != 'm') goto yy56;
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1228;
		if (yych == '\t') goto yy1228;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1228;
		if (yych == '.') goto yy1229;
		goto yy56;
	}
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '9') goto yy1197;
	if (yych <= ':') goto yy1230;
	goto yy820;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy820;
		if (yych >= '5') goto yy1231;
	} else {
		if (yych <= '9') goto yy1035;
		if (yych <= ':') goto yy1230;
		goto yy820;
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '5') goto yy1231;
	if (yych <= '9') goto yy1035;
	if (yych <= ':') goto yy1230;
	goto yy820;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1232;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1232;
		goto yy820;
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych == '.') goto yy820;
			goto yy1233;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy820;
			if (yych <= 'Z') goto yy1232;
			goto yy820;
		} else {
			if (yych <= '_') goto yy1233;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1234;
			goto yy820;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy1035;
		if (yych <= '@') goto yy820;
		goto yy1232;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1235;
			goto yy1232;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1232;
			goto yy820;
		}
	}
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1167;
			if (yych <= 0x08) goto yy820;
			goto yy1167;
		} else {
			if (yych == ' ') goto yy1167;
			if (yych <= '(') goto yy820;
			goto yy1035;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1169;
			goto yy820;
		} else {
			if (yych <= 'Z') goto yy1232;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1232;
			goto yy820;
		}
	}
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1167;
			if (yych == '\t') goto yy1167;
			goto yy820;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy1167;
				goto yy820;
			} else {
				if (yych <= ')') goto yy1035;
				if (yych <= ',') goto yy820;
				goto yy1233;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1169;
			if (yych <= '/') goto yy1233;
			if (yych <= '@') goto yy820;
			goto yy1232;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy820;
				goto yy1233;
			} else {
				if (yych <= '`') goto yy820;
				if (yych <= 'z') goto yy1234;
				goto yy820;
			}
		}
	}
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1236;
	if (yych == 'g') goto yy1236;
	goto yy56;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1205, *YYCURSOR);
#line 1175 "parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text(&ptr, &behavior);
		timelib_eat_spaces(&ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative(&ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 21440 "<stdout>"
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1110;
	if (yych == ' ') goto yy1110;
	goto yy944;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1237;
	if (yych == 'e') goto yy1237;
	goto yy56;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1209, *YYCURSOR);
#line 1135 "parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 21474 "<stdout>"
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1211, *YYCURSOR);
#line 1368 "parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr(&ptr, 19);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21490 "<stdout>"
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1238;
	goto yy186;
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1239;
	goto yy56;
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1239;
	goto yy56;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1216;
	if (yych <= ':') goto yy1240;
	goto yy56;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1240;
	goto yy56;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1241;
	if (yych <= ':') goto yy1182;
	goto yy56;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1241;
	if (yych == ':') goto yy1182;
	goto yy56;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy185;
	goto yy186;
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1240;
	if (yych <= '6') goto yy1242;
	if (yych >= ':') goto yy56;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1243;
	if (yych <= '6') goto yy1244;
	goto yy56;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1245;
	goto yy56;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1246;
	goto yy56;
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1246;
	goto yy56;
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(1226, *YYCURSOR);
#line 1214 "parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr(&ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr(&ptr, 8);
			}
		}
		timelib_eat_spaces(&ptr);
		s->time->h += timelib_meridian(&ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 21597 "<stdout>"
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1225;
		if (yych <= 0x08) goto yy56;
		goto yy1225;
	} else {
		if (yych == ' ') goto yy1225;
		goto yy56;
	}
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	++YYCURSOR;
	goto yy1100;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1228;
		if (yych <= 0x08) goto yy56;
		goto yy1228;
	} else {
		if (yych == ' ') goto yy1228;
		goto yy56;
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '5') goto yy1231;
	if (yych <= '9') goto yy1035;
	goto yy820;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy820;
	if (yych <= '9') goto yy1035;
	goto yy820;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1247;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1247;
		goto yy820;
	}
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy1248;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy1248;
	goto yy56;
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych == '.') goto yy820;
			goto yy1233;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy820;
			if (yych <= 'Z') goto yy1247;
			goto yy820;
		} else {
			if (yych <= '_') goto yy1233;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1250;
			goto yy820;
		}
	}
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy820;
			goto yy1035;
		} else {
			if (yych == '+') goto yy1159;
			goto yy820;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1159;
			if (yych <= '@') goto yy820;
			goto yy1247;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1247;
			goto yy820;
		}
	}
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1251;
	if (yych == 'h') goto yy1251;
	goto yy56;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1252;
	if (yych == 'c') goto yy1252;
	goto yy56;
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1253;
	goto yy186;
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1254;
	goto yy56;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1255;
	if (yych <= '6') goto yy1257;
	if (yych <= '9') goto yy1258;
	goto yy56;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1259;
	goto yy56;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy1255;
	if (yych <= '5') goto yy1243;
	if (yych <= '6') goto yy1244;
	goto yy56;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1258;
	goto yy56;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1258;
	goto yy56;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1221;
	goto yy56;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1186;
	goto yy56;
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1260;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1260;
		goto yy820;
	}
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yyaccept = 20;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1249, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy820;
			goto yy1233;
		} else {
			if (yych == '/') goto yy1233;
			goto yy820;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1248;
			if (yych <= '^') goto yy820;
			goto yy1233;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1248;
			goto yy820;
		}
	}
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych == '.') goto yy820;
			goto yy1233;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy820;
			if (yych <= 'Z') goto yy1260;
			goto yy820;
		} else {
			if (yych <= '_') goto yy1233;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1261;
			goto yy820;
		}
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1041;
	if (yych == 't') goto yy1041;
	goto yy56;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1118;
	if (yych == 'o') goto yy1118;
	goto yy56;
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy186;
	if (yych <= '9') goto yy1262;
	goto yy186;
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1263;
	goto yy56;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1256;
	if (yych <= '9') goto yy1258;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
#line 1515 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->m = timelib_get_nr(&ptr, 2);
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr(&ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 21891 "<stdout>"
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1256;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	++YYCURSOR;
	goto yy1256;
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1264;
	if (yych <= '9') goto yy1216;
	goto yy56;
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1035;
		goto yy820;
	} else {
		if (yych <= 'Z') goto yy1265;
		if (yych <= '`') goto yy820;
		if (yych <= 'z') goto yy1265;
		goto yy820;
	}
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1035;
			goto yy820;
		} else {
			if (yych == '.') goto yy820;
			goto yy1233;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy820;
			if (yych <= 'Z') goto yy1265;
			goto yy820;
		} else {
			if (yych <= '_') goto yy1233;
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1266;
			goto yy820;
		}
	}
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1267;
	goto yy56;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1268;
	goto yy56;
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1269;
	if (yych <= ':') goto yy1240;
	goto yy56;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy1035;
	goto yy820;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy820;
			goto yy1035;
		} else {
			if (yych == '-') goto yy1233;
			goto yy820;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy1233;
			if (yych <= '^') goto yy820;
			goto yy1233;
		} else {
			if (yych <= '`') goto yy820;
			if (yych <= 'z') goto yy1270;
			goto yy820;
		}
	}
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1272;
	goto yy56;
yy1268:
	YYDEBUG(1268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1273;
	goto yy56;
yy1269:
	YYDEBUG(1269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1274;
	goto yy56;
yy1270:
	YYDEBUG(1270, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(1271, *YYCURSOR);
	if (yych <= '/') {
		if (yych == '-') goto yy1233;
		if (yych <= '.') goto yy56;
		goto yy1233;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy1233;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy1270;
			goto yy56;
		}
	}
yy1272:
	YYDEBUG(1272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1275;
	goto yy56;
yy1273:
	YYDEBUG(1273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1276;
	if (yych <= '6') goto yy1277;
	goto yy56;
yy1274:
	YYDEBUG(1274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1278;
	if (yych <= '6') goto yy1279;
	if (yych <= '9') goto yy1258;
	goto yy56;
yy1275:
	YYDEBUG(1275, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1280;
	goto yy56;
yy1276:
	YYDEBUG(1276, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1281;
	goto yy56;
yy1277:
	YYDEBUG(1277, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1281;
	goto yy56;
yy1278:
	YYDEBUG(1278, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1256;
	if (yych <= '9') goto yy1282;
	goto yy1256;
yy1279:
	YYDEBUG(1279, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1282;
	goto yy1256;
yy1280:
	YYDEBUG(1280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1283;
	goto yy56;
yy1281:
	YYDEBUG(1281, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1284;
	if (yych == ' ') goto yy1284;
	goto yy56;
yy1282:
	YYDEBUG(1282, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1286;
	goto yy1256;
yy1283:
	YYDEBUG(1283, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy864;
	goto yy56;
yy1284:
	YYDEBUG(1284, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1285, *YYCURSOR);
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1284;
		} else {
			if (yych == ' ') goto yy1284;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy1287;
		} else {
			if (yych == 'G') goto yy1288;
			goto yy56;
		}
	}
yy1286:
	YYDEBUG(1286, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1289;
	goto yy56;
yy1287:
	YYDEBUG(1287, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1291;
	if (yych <= '2') goto yy1293;
	if (yych <= '9') goto yy1294;
	goto yy56;
yy1288:
	YYDEBUG(1288, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1295;
	goto yy56;
yy1289:
	YYDEBUG(1289, *YYCURSOR);
	yyaccept = 32;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	YYDEBUG(1290, *YYCURSOR);
	if (yych <= '-') {
		if (yych == '+') goto yy1296;
		if (yych <= ',') goto yy1256;
		goto yy1296;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1256;
			goto yy1289;
		} else {
			if (yych == 'G') goto yy1297;
			goto yy1256;
		}
	}
yy1291:
	YYDEBUG(1291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1292;
	if (yych <= '9') goto yy1294;
	if (yych <= ':') goto yy1298;
yy1292:
	YYDEBUG(1292, *YYCURSOR);
#line 1621 "parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr(&ptr, 2);
		s->time->m = timelib_get_month(&ptr);
		s->time->y = timelib_get_nr(&ptr, 4);
		s->time->h = timelib_get_nr(&ptr, 2);
		s->time->i = timelib_get_nr(&ptr, 2);
		s->time->s = timelib_get_nr(&ptr, 2);
		s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 22193 "<stdout>"
yy1293:
	YYDEBUG(1293, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1292;
		if (yych >= '5') goto yy1299;
	} else {
		if (yych <= '9') goto yy1300;
		if (yych <= ':') goto yy1298;
		goto yy1292;
	}
yy1294:
	YYDEBUG(1294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1292;
	if (yych <= '5') goto yy1299;
	if (yych <= '9') goto yy1300;
	if (yych <= ':') goto yy1298;
	goto yy1292;
yy1295:
	YYDEBUG(1295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1301;
	goto yy56;
yy1296:
	YYDEBUG(1296, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1302;
	if (yych <= '2') goto yy1303;
	if (yych <= '9') goto yy1304;
	goto yy56;
yy1297:
	YYDEBUG(1297, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1305;
	goto yy56;
yy1298:
	YYDEBUG(1298, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1292;
	if (yych <= '5') goto yy1299;
	if (yych <= '9') goto yy1300;
	goto yy1292;
yy1299:
	YYDEBUG(1299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1292;
	if (yych >= ':') goto yy1292;
yy1300:
	YYDEBUG(1300, *YYCURSOR);
	++YYCURSOR;
	goto yy1292;
yy1301:
	YYDEBUG(1301, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1287;
	if (yych == '-') goto yy1287;
	goto yy56;
yy1302:
	YYDEBUG(1302, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1256;
	if (yych <= '9') goto yy1304;
	if (yych <= ':') goto yy1306;
	goto yy1256;
yy1303:
	YYDEBUG(1303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1256;
		if (yych >= '5') goto yy1255;
	} else {
		if (yych <= '9') goto yy1258;
		if (yych <= ':') goto yy1306;
		goto yy1256;
	}
yy1304:
	YYDEBUG(1304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1256;
	if (yych <= '5') goto yy1255;
	if (yych <= '9') goto yy1258;
	if (yych <= ':') goto yy1306;
	goto yy1256;
yy1305:
	YYDEBUG(1305, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1307;
	goto yy56;
yy1306:
	YYDEBUG(1306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1256;
	if (yych <= '5') goto yy1255;
	if (yych <= '9') goto yy1258;
	goto yy1256;
yy1307:
	YYDEBUG(1307, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1296;
	if (yych == '-') goto yy1296;
	goto yy56;
}
#line 1840 "parse_date.re"

}

#define YYMAXFILL 33


timelib_time *timelib_strtotime(const char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	const char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'p', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(const char *format, const char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	const char  *fptr = format;
	const char  *ptr = string;
	const char  *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit(&ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix(&ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				s->time->m = 1;
				s->time->d = tmp + 1;
				timelib_do_normalize(s->time);
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
					break;
				}
				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month(&ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				s->time->m = tmp;
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex(&ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
						break;
					}
					
					s->time->have_date = 1;
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour can not be higher than 12", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
					break;
				}
				if ((tmp = timelib_meridian_with_check(&ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
					break;
				}

				s->time->have_time = 1;
				s->time->h += tmp;
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex(&ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->i = min;
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex(&ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
						break;
					}

					s->time->have_time = 1;
					s->time->s = sec;
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
						break;
					}

					s->time->us = (f * pow(10, 6 - (ptr - tptr)));
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					const char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr(&ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
						break;
					}
					
					s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces(&ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_unsigned_nr(&ptr, 24);
				s->time->have_zone = 1;
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) != TIMELIB_FORMAT_SEPARATOR) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
					break;
				}
				
				++ptr;
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if (!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr != *fptr) {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
					break;
				}

				++ptr;
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator(&ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr(&ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr(&ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
					break;
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr(&ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
					break;
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
					break;
				}

				s->time->have_date = 1;
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone(&ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
						break;
					}

					s->time->have_zone = 1;
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes(&ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
					break;
				}

				s->time->have_zone = 1;
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Data missing", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
