static const int mb_tbl_code2uni_docomo1_min = 0x28c2;
static const int mb_tbl_code2uni_docomo1_max = 0x29db;

static const unsigned short mb_tbl_code2uni_docomo1[] = { // 0x28c2 - 0x29db
	0x2600,	0x2601,	0x2614,	0x26c4,
	0x26a1,	0xf300,	0xf301,	0xf302,
	0x2648,	0x2649,	0x264a,	0x264b,
	0x264c,	0x264d,	0x264e,	0x264f,
	0x2650,	0x2651,	0x2652,	0x2653,
	0xf3bd,	0x26be,	0x26f3,	0xf3be,
	0x26bd,	0xf3bf,	0xf3c0,	0xf3c1,
	0xf4df,	0xf683,	0x24c2,	0xf684,
	0xf697,	0xf699,	0xf68c,	0xf6a2,
	0x2708,	0xf3e0,	0xf3e2,	0xf3e3,
	0xf3e5,	0xf3e6,	0xf3e7,	0xf3e8,
	0xf3ea,	0x26fd,	0xf17f,	0xf6a5,
	0xf6bb,	0xf374,	0x2615,	0xf378,
	0xf37a,	0xf354,	0xf460,	0x2702,
	0xf3a4,	0xf3a5,	0x2197,	0xf3a0,
	0xf3a7,	0xf3a8,	0xf3a9,	0xf3aa,
	0xf3ab,	0xf6ac,	0xf6ad,	0xf4f7,
	0xf45c,	0xf4d6,	0xf380,	0xf381,
	0xf382,	0x260e,	0xf4f1,	0xf4dd,
	0xf4fa,	0xf3ae,	0xf4bf,	0x2665,
	0x2660,	0x2666,	0x2663,	0xf440,
	0xf442,	0x270a,	0x270c,	0x270b,
	0x2198,	0x2196,	0xf463,	0xf45f,
	0xf453,	0x267f,	0xf311,	0xf314,
	0xf313,	0xf319,	0xf315,	0xf436,
	0xf431,	0x26f5,	0xf384,	0x2199,
	0xEE16,	0xEE17,	0xEE18,	0xEE19,
	0xEE1A,	0xEE1B,	0xf3ac,	0xf45d,
	0x2712,	0xEE1C,	0xEE1D,	0xf464,
	0xf4ba,	0xf303,	0xEE1E,	0xEE1F,
	0xEE20,	0xf51c,	0xf51b,	0xf51a,
	0x23f0,	0xEE21,	0xEE22,	0xEE23,
	0xEE24,	0xEE25,	0xEE26,	0xEE27,
	0xEE28,	0xEE29,	0xEE2A,	0xEE2B,
	0xEE2C,	0xEE2D,	0xEE2E,	0xEE2F,
	0xEE30,	0xEE31,	0xEE32,	0xEE33,
	0xf4f2,	0xf4e9,	0xf4e0,	0xEE10,
	0xEE11,	0x2709,	0xEE12,	0xEE13,
	0xf4b4,	0xf193,	0xf194,	0xf511,
	0x21a9,	0xf191,	0xf50d,	0xf195,
	0xf6a9,	0x27bf,	0x0023,	0xE82D,
	0x0031,	0x0032,	0x0033,	0x0034,
	0x0035,	0x0036,	0x0037,	0x0038,
	0x0039,	0x0030,	0x2764,	0xf493,
	0xf494,	0xf495,	0xf603,	0xf620,
	0xf61e,	0xf616,	0xf635,	0x2934,
	0xf3b5,	0x2668,	0xf4a0,	0xf48b,
	0x2728,	0xf4a1,	0xf4a2,	0xf44a,
	0xf4a3,	0xf3b6,	0x2935,	0xf4a4,
	0x2757,	0x2049,	0x203c,	0xf4a5,
	0xf4a6,	0xf4a7,	0xf4a8,	0x3030,
	0x27b0,	0xf197,	0xEE14,	0xEE15,
	0xf455,	0xf45b,	0xf484,	0xf456,
	0xf3c2,	0xf514,	0xf6aa,	0xf4b0,
	0xf4bb,	0xf48c,	0xf527,	0x270f,
	0xf451,	0xf48d,	0x23f3,	0xf6b2,
	0xf375,	0x231a,	0xf614,	0xf60c,
	0xf605,	0xf613,	0xf621,	0xf612,
	0xf60d,	0xf44d,	0xf61c,	0xf609,
	0xf606,	0xf623,	0xf60f,	0xf62d,
	0xf622,	0xf196,	0xf4ce,	0x00a9,
	0x2122,	0xf3c3,	0x3299,	0x267b,
	0x00ae,	0x26a0,	0xf232,	0xf233,
	0xf234,	0xf235,	0x2194,	0x2195,
	0xf3eb,	0xf30a,	0xf5fb,	0xf340,
	0xf352,	0xf337,	0xf34c,	0xf34e,
	0xf331,	0xf341,	0xf338,	0xf359,
	0xf370,	0xf376,	0xf35c,	0xf35e,
	0xf40c,	0xf424,	0xf427,	0xf41f,
	0xf60b,	0xf601,	0xf434,	0xf437,
	0xf377,	0xf631,	};
static const int mb_tbl_code2uni_kddi1_min = 0x24b8;
static const int mb_tbl_code2uni_kddi1_max = 0x25c6;

static const unsigned short mb_tbl_code2uni_kddi1[] = { // 0x24b8 - 0x25c6
	0xf342,	0xf4bc,	0x26f2,	0x26fa,
	0xf004,	0xf19a,	0xf3c6,	0xf422,
	0xf1ea,	0xf1f7,	0xf6a7,	0xf6c0,
	0xf38c,	0xf306,	0xf423,	0xf4b9,
	0xf46e,	0xf3e3,	0xf3e5,	0xf3eb,
	0xf3e8,	0xf6a2,	0xf51e,	0xf4f6,
	0xf192,	0xf239,	0xf202,	0xf194,
	0xf235,	0xf233,	0xf22f,	0xf23a,
	0xf446,	0xf447,	0xf52e,	0xf4f3,
	0xf4f4,	0xf4dd,	0xf454,	0xf33a,
	0xf490,	0xf335,	0xf376,	0xf37b,
	0x3297,	0xf48a,	0xf388,	0xf389,
	0xEE42,	0xf452,	0xf462,	0xf485,
	0xf487,	0xf488,	0xf458,	0xf459,
	0x2665,	0xf496,	0xf499,	0xf49a,
	0xf49b,	0xf49c,	0x2728,	0xf3bf,
	0x2b55,	0xf375,	0xf35e,	0xf366,
	0xf35f,	0xf361,	0xf358,	0xf35a,
	0xf35d,	0xf35b,	0xf362,	0xf363,
	0xf34e,	0xf34a,	0xf345,	0xf346,
	0xf371,	0xf372,	0xf60f,	0xf614,
	0xf624,	0xf623,	0xf616,	0xf62a,
	0xf60c,	0xf628,	0xf637,	0xf633,
	0xf612,	0xf632,	0xf630,	0xf3bc,
	0xf60a,	0xf61a,	0xf618,	0xf443,
	0xf444,	0xf64f,	0xf44f,	0xf44c,
	0xf44e,	0xf44b,	0xf645,	0xf646,
	0xf647,	0xf491,	0xf46f,	0xf3ba,
	0xf3b1,	0xf3ca,	0xf692,	0xf691,
	0xf693,	0xf3a2,	0xf38d,	0xf38e,
	0xf393,	0xf392,	0xf38f,	0xf302,
	0xf470,	0xf367,	0xf387,	0xf41a,
	0xf390,	0xf383,	0xf391,	0xf385,
	0xf303,	0xf308,	0xf3e9,	0xf305,
	0xf3a9,	0xf3ec,	0xf3ef,	0xf3f0,
	0xf3ed,	0xf1eb,	0xf1e9,	0xf1ee,
	0xf1ec,	0xf1e8,	0xf1f0,	0xf471,
	0xf472,	0xf473,	0xf474,	0xf475,
	0xf476,	0xf477,	0xf478,	0xf42c,
	0xf483,	0xf420,	0xf41b,	0xf418,
	0xf428,	0xf42e,	0xf40d,	0xf414,
	0xf417,	0xf42b,	0xf170,	0xf171,
	0xf17e,	0xf18e,	0xf463,	0xf45f,
	0xf6a9,	0x2934,	0x2935,	0x2049,
	0x203c,	0x27b0,	0xf348,	0xf34d,
	0xf347,	0xf34c,	0xf33d,	0xf344,
	0xf330,	0xf351,	0xf360,	0xf355,
	0xf357,	0xf38b,	0xf379,	0xf432,
	0xf3b9,	0xf3c4,	0xf3a3,	0xf3b3,
	0xf479,	0xf47a,	0xf43c,	0xf445,
	0xf43d,	0xf33c,	0xf368,	0xf369,
	0xf36a,	0xf36b,	0xf36c,	0xf36d,
	0xf648,	0xf64a,	0xf649,	0xf30b,
	0xf49d,	0xf524,	0xf36e,	0xf41d,
	0xf41e,	0xf36f,	0xf34f,	0xf4b8,
	0xf4ab,	0xf621,	0xf63e,	0xf30c,
	0xf63d,	0xf63a,	0xf4e9,	0xf639,
	0xf602,	0xf63b,	0xf640,	0xf629,
	0xf63f,	0xf622,	0xf63c,	0xf457,
	0xf5ff,	0xf689,	0xf3b4,	0xf0cf,
	0xf364,	0xf4e7,	0xf6b6,	0xf6a8,
	0xEE43,	0xf493,	0xf425,	0xf456,
	0xf48c,	0x267b,	0x2194,	0x2195,
	0xf30a,	0xf331,	0xf40c,	0xf638,
	0xf601,	0xEE44,	0xf33f,	0x270a,
	0x0023,	0xf64b,	0xf64c,	0xf64d,
	0xf64e,	0xEE45, 0xEE46, 0xEE47,
	0xEE48, 0xEE49, 0xEE4A};
static const int mb_tbl_code2uni_kddi2_min = 0x26ec;
static const int mb_tbl_code2uni_kddi2_max = 0x2863;

static const unsigned short mb_tbl_code2uni_kddi2[] = { // 0x26ec - 0x2863
	0xf320,	0xf300,	0xf6a5,	0xf3c3,
	0x2747,	0xf3a1,	0xf3b0,	0xf38a,
	0xf433,	0xf603,	0xf620,	0xf62d,
	0xf62b,	0xf4a4,	0xf4a1,	0xf494,
	0xf495,	0x2734,	0xf4a3,	0xf525,
	0x23f3,	0xf6ac,	0xf6ad,	0x267f,
	0xf530,	0x26a0,	0x2757,	0x2753,
	0x26d4,	0x26c4,	0xf319,	0x26a1,
	0x2600,	0xf31b,	0x2744,	0x2b50,
	0x2614,	0x2601,	0x26c5,	0x2648,
	0x2649,	0x264a,	0x264b,	0x264c,
	0x264d,	0x264e,	0x264f,	0x2650,
	0x2651,	0x2652,	0x2653,	0x26ce,
	0xf45c,	0xf4d4,	0xf3ab,	0xf4d6,
	0xf4ce,	0x270f,	0xf4d0,	0xf3e7,
	0xf3ea,	0xf6bb,	0xf17f,	0xf68f,
	0xf4e1,	0x2693,	0xf3e6,	0xf3e0,
	0xf374,	0xf3e2,	0xf6b2,	0xf68c,
	0xf685,	0xf697,	0xf69a,	0x2708,
	0x26f5,	0xf683,	0x26bd,	0xf3be,
	0xf3c2,	0xf3c1,	0x26be,	0xf3c8,
	0x2668,	0xf3ee,	0xf3ac,	0xf309,
	0xf5fc,	0xf377,	0xf378,	0xf37a,
	0xf356,	0xf3af,	0xf3ae,	0xf4b0,
	0xf3b2,	0xf384,	0xf338,	0xf47b,
	0xf1ef,	0xf349,	0xf341,	0xf381,
	0xf370,	0xf373,	0xf352,	0xf421,
	0xf353,	0xf359,	0xf354,	0xf430,
	0xf434,	0xf435,	0xf438,	0xf431,
	0xf427,	0xf41c,	0xf437,	0xf429,
	0xf424,	0xf436,	0xf334,	0xf33b,
	0xf337,	0xf4a2,	0xf4a7,	0xf61c,
	0xf198,	0xf4aa,	0xf498,	0xf48b,
	0xf47e,	0xf365,	0xf43e,	0xf47f,
	0xf4ae,	0x3299,	0xf4af,	0xf44a,
	0xf4a8,	0xf4a9,	0x261d,	0xf250,
	0xf480,	0xf44d,	0xf469,	0x263a,
	0xf468,	0xf4ac,	0xf453,	0xf448,
	0xf449,	0xf46a,	0xf4fa,	0xf3a4,
	0xf45b,	0xf3b6,	0xf3b8,	0xf3bb,
	0xf3a7,	0xf484,	0xf52b,	0xf486,
	0xf4bf,	0xf45a,	0xf47d,	0xf199,
	0xf489,	0xf50a,	0xf514,	0xf340,
	0xf48d,	0xf4f7,	0x2702,	0xf3a5,
	0xf50d,	0xf511,	0xf460,	0xf4ea,
	0xf512,	0xf4db,	0xf4de,	0xf4e6,
	0xf4e0,	0x2709,	0x0031,	0x0032,
	0x0033,	0x0034,	0x0035,	0x0036,
	0x0037,	0x0038,	0x0039,	0xf51f,
	0xE82D,	0x25c0,	0x25b6,	0x23ea,
	0x23e9,	0x25ab,	0x25aa,	0x2139,
	0x25fd,	0x25fe,	0xf538,	0xf539,
	0x25fb,	0x25fc,	0x26aa,	0x26ab,
	0x2795,	0x2796,	0x2733,	0x2b06,
	0x2b07,	0xf6ab,	0xf53d,	0xf53c,
	0x23ec,	0x23eb,	0xf536,	0xf537,
	0x2b1c,	0x2b1b,	0xf534,	0xf535,
	0x2196,	0x2198,	0x2122,	0x2716,
	0x274c,	0x274e,	0x27a1,	0x2b05,
	0x2797,	0x2197,	0x2199,	0x2714,
	0x00a9,	0x00ae,	0xf53a,	0xf53b,
	0x21aa,	0x21a9,	0x2705,	0xf4dc,
	0xf4cd,	0xf4c3,	0xf4be,	0xf4c5,
	0xf4cb,	0xf4d7,	0xf4d8,	0xf4d9,
	0xf4d5,	0xf4c4,	0xf4c6,	0xf4d3,
	0xf4c7,	0xf4cc,	0xf4d2,	0xf4da,
	0xf4cf,	0x26fd,	0xf5fe,	0xf1fa,
	0xf4ca,	0xf4c8,	0xf4c9,	0xEE40,
	0xf193,	0xf4b2,	0x231a,	0x231b,
	0xf4b3,	0xf4b4,	0xf4f9,	0xf52a,
	0xf4fc,	0xf529,	0xf4bd,	0xf526,
	0xf50b,	0xf4b5,	0xE83C,	0xf527,
	0xf4f1,	0xf50c,	0xf517,	0xf4f0,
	0x2003,	0x2002,	0x2005,	0xf4c1,
	0xf4c2,	0xf4e8,	0xf4e4,	0xf4e5,
	0x23f0,	0x2764,	0x260e,	0x2615,
	0xf301,	0x26f3,	0xf3c0,	0xf4df,
	0xf3a8,	0xf3ad,	0xf3aa,	0xf380,
	0xf382,	0x2660,	0x2666,	0x2663,
	0xf440,	0xf442,	0x270c,	0x270b,
	0xf311,	0xf314,	0xf313,	0xf191,
	0x0030,	0xf197,	0xf635,	0xf49e,
	0xf4a5,	0xf4a6,	0xEE41,	0xf30f,
	0xf35c,	0xEB89,	0xf510,	0xf520,
	0xf521,	0xf522,	0xf523,	0xf251,
	0x2611,	0x2712,	0xf518,	0xf50e,
	0xf519,	0xf516,	0xf4f2,	0xf3e1,
	0xf4eb,	0xf4d1,	0xf50f,	0xf503,
	0xf195,	0xf455,	0xf45e,	0xf4bb,
	0xf4fb,	0xf339,	0x26ea,	0xf687,
	0xf5fb,	0xf3b5,	0xf47c,	0xf42f,
	0xf43b,	0xf42d,	0xf609,	0xf60d,
	0xf631,	0xf613,	0xf419,	0xf680,
	0xf451,	0xf48f,	0xf528,	0xf386,
	};
static const int mb_tbl_code2uni_sb1_min = 0x27a9;
static const int mb_tbl_code2uni_sb1_max = 0x2861;

static const unsigned short mb_tbl_code2uni_sb1[] = { // 0x27a9 - 0x2861
	0xf4eb,	0xf4ee,	0xf4e9,	0xf4f2,
	0xf61c,	0xf60d,	0xf631,	0xf613,
	0xf435,	0xf419,	0xf437,	0xf47d,
	0xf680,	0xf451,	0xf4a1,	0xf340,
	0xf48f,	0xf381,	0xf52b,	0xf50d,
	0xf3c3,	0xf528,	0xf386,	0xf341,
	0xf342,	0xf47f,	0xf47b,	0xf480,
	0xf525,	0xf4bc,	0xf4ba,	0xf354,
	0x26f2,	0x26fa,	0x2668,	0xf3a1,
	0xf3ab,	0xf4bf,	0xf4c0,	0xf4fb,
	0xf4fc,	0xf4fa,	0xf47e,	0x303d,
	0xf004,	0xf19a,	0xf4b0,	0xf3af,
	0xf3c6,	0xf3c1,	0xf3b0,	0xf40e,
	0xf6a4,	0xf6b2,	0xf6a7,	0xf6b9,
	0xf6ba,	0xf6bc,	0xf489,	0xf4a4,
	0x26a1,	0xf460,	0xf6c0,	0xf6bd,
	0xf50a,	0xf4e2,	0xf38c,	0xf512,
	0xf513,	0xf306,	0xf373,	0xf4d6,
	0xf4b1,	0xf4b9,	0xf4e1,	0xf4aa,
	0xf3e6,	0xf6a5,	0xf17f,	0xf68f,
	0xf6bb,	0xf46e,	0xf3e3,	0xf3e7,
	0xf3e5,	0xf3ea,	0xf3eb,	0xf3e8,
	0xf68c,	0xf695,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0xf6b6,
	0xf6a2,	0xf201,	0xf49f,	0x2734,
	0x2733,	0xf51e,	0xf6ad,	0xf530,
	0x267f,	0xf4f6,	0x2665,	0x2666,
	0x2660,	0x2663,	0x0023,	0x27bf,
	0xf195,	0xf199,	0xf192,	0xf236,
	0xf21a,	0xf237,	0xf238,	0xf534,
	0xf532,	0xf533,	0x0031,	0x0032,
	0x0033,	0x0034,	0x0035,	0x0036,
	0x0037,	0x0038,	0x0039,	0x0030,
	0xf250,	0xf239,	0xf202,	0xf194,
	0xf235,	0xf233,	0xf22f,	0xf23a,
	0xf446,	0xf447,	0xf448,	0xf449,
	0x2b06,	0x2b07,	0x27a1,	0x2b05,
	0x2197,	0x2196,	0x2198,	0x2199,
	0x25b6,	0x25c0,	0x23e9,	0x23ea,
	0xf52f,	0x2648,	0x2649,	0x264a,
	0x264b,	0x264c,	0x264d,	0x264e,
	0x264f,	0x2650,	0x2651,	0x2652,
	0x2653,	0x26ce,	0xf51d,	0xf197,
	0x00a9,	0x00ae,	0xf4f3,	0xf4f4,
	0x26a0,	0xf481,	0xEE77, 0xEE78,
	0xEE79, 0xEE7A, 0xEE7B, 0xEE7C,
	0xEE7D};

static const int mb_tbl_code2uni_sb2_min = 0x2921;
static const int mb_tbl_code2uni_sb2_max = 0x29cc;

static const unsigned short mb_tbl_code2uni_sb2[] = { // 0x2921 - 0x29cc
	0xf466,	0xf467,	0xf48b,	0xf468,
	0xf469,	0xf455,	0xf45f,	0xf4f7,
	0x260e,	0xf4f1,	0xf4e0,	0xf4bb,
	0xf44a,	0xf44d,	0x261d,	0x270a,
	0x270c,	0x270b,	0xf3bf,	0x26f3,
	0xf3be,	0x26be,	0xf3c4,	0x26bd,
	0xf41f,	0xf434,	0xf697,	0x26f5,
	0x2708,	0xf683,	0xf685,	0x2753,
	0x2757,	0x2764,	0xf494,	0xf550,
	0xf551,	0xf552,	0xf553,	0xf554,
	0xf555,	0xf556,	0xf557,	0xf558,
	0xf559,	0xf55a,	0xf55b,	0xf338,
	0xf531,	0xf339,	0xf384,	0xf48d,
	0xf48e,	0xf3e0,	0x26ea,	0xf3e2,
	0xf689,	0x26fd,	0xf5fb,	0xf3a4,
	0xf3a5,	0xf3b5,	0xf511,	0xf3b7,
	0xf3b8,	0xf3ba,	0xf374,	0xf378,
	0x2615,	0xf370,	0xf37a,	0x26c4,
	0x2601,	0x2600,	0x2614,	0xf319,
	0xf304,	0xf47c,	0xf431,	0xf42f,
	0xf43b,	0xf436,	0xf42d,	0xf433,
	0xf427,	0xf60a,	0xf603,	0xf61e,
	0xf620,	0xf4a9,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0xf4dd,
	0xf454,	0xf33a,	0xf337,	0xf33b,
	0xf490,	0xf334,	0xf335,	0xf6be,
	0xf3a7,	0xf376,	0xf37b,	0x3297,
	0xf6ac,	0xf48a,	0xf388,	0xf4a3,
	0xf389,	0x2702,	0xf380,	0x3299,
	0xf4bd,	0xf4e3,	0xf452,	0xf457,
	0xf461,	0xf462,	0xf484,	0xf485,
	0xf486,	0xf487,	0xf488,	0xf458,
	0xf459,	0xf45c,	0xf3ac,	0xf514,
	0xf3b6,	0xf493,	0xf497,	0xf498,
	0xf499,	0xf49a,	0xf49b,	0xf49c,
	0x2728,	0x2b50,	0xf4a8,	0xf4a6,
	0x2b55,	0x274c,	0xf4a2,	0xf31f,
	0x2754,	0x2755,	0xf375,	0xf35e,
	0xf366,	0xf35f,	0xf361,	0xf358,
	0xf35a,	0xf35d,	0xf35c,	0xf35b,
	0xf359,	0xf362,	0xf363,	0xf34e,
	0xf34a,	0xf353,	0xf349,	0xf345,
	0xf346,	0xf382,	0xf371,	0xf372,
	};
static const int mb_tbl_code2uni_sb3_min = 0x2a99;
static const int mb_tbl_code2uni_sb3_max = 0x2b35;

static const unsigned short mb_tbl_code2uni_sb3[] = { // 0x2a99 - 0x2b35
	0xf625,	0xf60f,	0xf614,	0xf601,
	0xf609,	0xf623,	0xf616,	0xf62a,
	0xf61d,	0xf60c,	0xf628,	0xf637,
	0xf633,	0xf612,	0xf630,	0xf632,
	0xf62d,	0xf602,	0xf622,	0x263a,
	0xf604,	0xf621,	0xf61a,	0xf618,
	0xf440,	0xf443,	0xf442,	0xf444,
	0xf64f,	0xf44b,	0xf44f,	0xf44c,
	0xf44e,	0xf450,	0xf645,	0xf646,
	0xf491,	0xf647,	0xf64c,	0xf46b,
	0xf46f,	0xf3c0,	0xf3c8,	0xf3b1,
	0xf3ca,	0xf699,	0xf69a,	0xf692,
	0xf691,	0xf693,	0xf3a2,	0xf687,
	0xf684,	0xf38d,	0xf49d,	0xf38e,
	0xf393,	0xf392,	0xf38f,	0xf302,
	0xf492,	0xf30a,	0xf367,	0xf387,
	0xf41a,	0xf390,	0xf300,	0xf33e,
	0xf383,	0xf391,	0xf343,	0xf385,
	0xf305,	0xf307,	0xf303,	0xf308,
	0x0000,	0x0000,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0x0000,
	0x0000,	0x0000,	0x0000,	0xf3e9,
	0xf3a8,	0xf3a9,	0xf3ec,	0xf3ef,
	0xf3f0,	0xf3a6,	0xf3ed,	0xf5fc,
	0xE4C5,	0xf1ef,	0xf1fa,	0xf1eb,
	0xf1e9,	0xf1ee,	0xf1ec,	0xf1ea,
	0xf1f7,	0xf1e8,	0xf1f0,	0xf471,
	0xf472,	0xf473,	0xf474,	0xf475,
	0xf476,	0xf477,	0xf478,	0xf5fd,
	0xf482,	0xf483,	0xf42c,	0xf426,
	0xf420,	0xf424,	0xf439,	0xf41b,
	0xf418,	0xf428,	0xf412,	0xf411,
	0xf43a,	0xf42e,	0xf430,	0xf40d,
	0xf414,	0xf417,	0xf42b,	0xf438,
	0xf170,	0xf171,	0xf18e,	0xf17e,
	0xf463,	0x2122,	0xEE70, 0xEE71,
	0xEE72, 0xEE73, 0xEE74, 0xEE75,
	0xEE76};



static const int mb_tbl_uni_docomo2code1_min = 0x0023;
static const int mb_tbl_uni_docomo2code1_max = 0x00ae;

static const unsigned short mb_tbl_uni_docomo2code1_key[] = { // 0x0023 - 0x00ae
	0x0023,	0x0030,	0x0031,	0x0032,
	0x0033,	0x0034,	0x0035,	0x0036,
	0x0037,	0x0038,	0x0039,	0x00a9,
	0x00ae,	};

static const unsigned short mb_tbl_uni_docomo2code1_value[] = { // 0x0023 - 0x00ae
	0x2964,	0x296f,	0x2966,	0x2967,
	0x2968,	0x2969,	0x296a,	0x296b,
	0x296c,	0x296d,	0x296e,	0x29b5,
	0x29ba,	};

static const int mb_tbl_uni_docomo2code1_len = sizeof(mb_tbl_uni_docomo2code1_key)/sizeof(unsigned short);

static const int mb_tbl_uni_docomo2code2_min = 0x203c;
static const int mb_tbl_uni_docomo2code2_max = 0x3299;

static const unsigned short mb_tbl_uni_docomo2code2_key[] = { // 0x203c - 0x3299
	0x203c,	0x2049,	0x2122,	0x2194,
	0x2195,	0x2196,	0x2197,	0x2198,
	0x2199,	0x21a9,	0x231a,	0x23f0,
	0x23f3,	0x24c2,	0x2600,	0x2601,
	0x260e,	0x2614,	0x2615,	0x2648,
	0x2649,	0x264a,	0x264b,	0x264c,
	0x264d,	0x264e,	0x264f,	0x2650,
	0x2651,	0x2652,	0x2653,	0x2660,
	0x2663,	0x2665,	0x2666,	0x2668,
	0x267b,	0x267f,	0x26a0,	0x26a1,
	0x26bd,	0x26be,	0x26c4,	0x26f3,
	0x26f5,	0x26fd,	0x2702,	0x2708,
	0x2709,	0x270a,	0x270b,	0x270c,
	0x270f,	0x2712,	0x2728,	0x2757,
	0x2764,	0x27b0,	0x27bf, 0x2934,
	0x2935,	0x3030,	0x3299,	};

static const unsigned short mb_tbl_uni_docomo2code2_value[] = { // 0x203c - 0x3299
	0x2988,	0x2987,	0x29b6,	0x29c0,
	0x29c1,	0x291b,	0x28fc,	0x291a,
	0x2929,	0x295e,	0x29a3,	0x293e,
	0x29a0,	0x28e0,	0x28c2,	0x28c3,
	0x290b,	0x28c4,	0x28f4,	0x28ca,
	0x28cb,	0x28cc,	0x28cd,	0x28ce,
	0x28cf,	0x28d0,	0x28d1,	0x28d2,
	0x28d3,	0x28d4,	0x28d5,	0x2912,
	0x2914,	0x2911,	0x2913,	0x297b,
	0x29b9,	0x291f,	0x29bb,	0x28c6,
	0x28da,	0x28d7,	0x28c5,	0x28d8,
	0x2927,	0x28ef,	0x28f9,	0x28e6,
	0x2957,	0x2917,	0x2919,	0x2918,
	0x299d,	0x2932,	0x297e,	0x2986,
	0x2970,	0x298e,	0x2963, 0x2979,
	0x2984,	0x298d,	0x29b8,	};

static const int mb_tbl_uni_docomo2code2_len = sizeof(mb_tbl_uni_docomo2code2_key)/sizeof(unsigned short);

static const int mb_tbl_uni_docomo2code3_min = 0x1f17f;
static const int mb_tbl_uni_docomo2code3_max = 0x1f6bb;

static const unsigned short mb_tbl_uni_docomo2code3_key[] = { // 0x1f17f - 0x1f6bb
	0xf17f,	0xf191,	0xf193,	0xf194,
	0xf195,	0xf196,	0xf197,	0xf232,
	0xf233,	0xf234,	0xf235,	0xf300,
	0xf301,	0xf302,	0xf303,	0xf30a,
	0xf311,	0xf313,	0xf314,	0xf315,
	0xf319,	0xf331,	0xf337,	0xf338,
	0xf340,	0xf341,	0xf34c,	0xf34e,
	0xf352,	0xf354,	0xf359,	0xf35c,
	0xf35e,	0xf370,	0xf374,	0xf375,
	0xf376,	0xf377,	0xf378,	0xf37a,
	0xf380,	0xf381,	0xf382,	0xf384,
	0xf3a0,	0xf3a4,	0xf3a5,	0xf3a7,
	0xf3a8,	0xf3a9,	0xf3aa,	0xf3ab,
	0xf3ac,	0xf3ae,	0xf3b5,	0xf3b6,
	0xf3bd,	0xf3be,	0xf3bf,	0xf3c0,
	0xf3c1,	0xf3c2,	0xf3c3,	0xf3e0,
	0xf3e2,	0xf3e3,	0xf3e5,	0xf3e6,
	0xf3e7,	0xf3e8,	0xf3ea,	0xf3eb,
	0xf40c,	0xf41f,	0xf424,	0xf427,
	0xf431,	0xf434,	0xf436,	0xf437,
	0xf440,	0xf442,	0xf44a,	0xf44d,
	0xf451,	0xf453,	0xf455,	0xf456,
	0xf45b,	0xf45c,	0xf45d,	0xf45f,
	0xf460,	0xf463,	0xf464,	0xf484,
	0xf48b,	0xf48c,	0xf48d,	0xf493,
	0xf494,	0xf495,	0xf4a0,	0xf4a1,
	0xf4a2,	0xf4a3,	0xf4a4,	0xf4a5,
	0xf4a6,	0xf4a7,	0xf4a8,	0xf4b0,
	0xf4b4,	0xf4ba,	0xf4bb,	0xf4bf,
	0xf4ce,	0xf4d6,	0xf4dd,	0xf4df,
	0xf4e0,	0xf4e9,	0xf4f1,	0xf4f2,
	0xf4f7,	0xf4fa,	0xf50d,	0xf511,
	0xf514,	0xf51a,	0xf51b,	0xf51c,
	0xf527,	0xf5fb,	0xf601,	0xf603,
	0xf605,	0xf606,	0xf609,	0xf60b,
	0xf60c,	0xf60d,	0xf60f,	0xf612,
	0xf613,	0xf614,	0xf616,	0xf61c,
	0xf61e,	0xf620,	0xf621,	0xf622,
	0xf623,	0xf62d,	0xf631,	0xf635,
	0xf683,	0xf684,	0xf68c,	0xf697,
	0xf699,	0xf6a2,	0xf6a5,	0xf6a9,
	0xf6aa,	0xf6ac,	0xf6ad,	0xf6b2,
	0xf6bb,	};

static const unsigned short mb_tbl_uni_docomo2code3_value[] = { // 0x1f17f - 0x1f6bb
	0x28f0,	0x295f,	0x295b,	0x295c,
	0x2961,	0x29b3,	0x298f,	0x29bc,
	0x29bd,	0x29be,	0x29bf,	0x28c7,
	0x28c8,	0x28c9,	0x2937,	0x29c3,
	0x2920,	0x2922,	0x2921,	0x2924,
	0x2923,	0x29ca,	0x29c7,	0x29cc,
	0x29c5,	0x29cb,	0x29c8,	0x29c9,
	0x29c6,	0x28f7,	0x29cd,	0x29d0,
	0x29d1,	0x29ce,	0x28f3,	0x29a2,
	0x29cf,	0x29da,	0x28f5,	0x28f6,
	0x2908,	0x2909,	0x290a,	0x2928,
	0x28fd,	0x28fa,	0x28fb,	0x28fe,
	0x28ff,	0x2900,	0x2901,	0x2902,
	0x2930,	0x290f,	0x297a,	0x2983,
	0x28d6,	0x28d9,	0x28db,	0x28dc,
	0x28dd,	0x2996,	0x29b7,	0x28e7,
	0x28e8,	0x28e9,	0x28ea,	0x28eb,
	0x28ec,	0x28ed,	0x28ee,	0x29c2,
	0x29d2,	0x29d5,	0x29d3,	0x29d4,
	0x2926,	0x29d8,	0x2925,	0x29d9,
	0x2915,	0x2916,	0x2981,	0x29ab,
	0x299e,	0x291e,	0x2992,	0x2995,
	0x2993,	0x2906,	0x2931,	0x291d,
	0x28f8,	0x291c,	0x2935,	0x2994,
	0x297d,	0x299b,	0x299f,	0x2971,
	0x2972,	0x2973,	0x297c,	0x297f,
	0x2980,	0x2982,	0x2985,	0x2989,
	0x298a,	0x298b,	0x298c,	0x2999,
	0x295a,	0x2936,	0x299a,	0x2910,
	0x29b4,	0x2907,	0x290d,	0x28de,
	0x2954,	0x2953,	0x290c,	0x2952,
	0x2905,	0x290e,	0x2960,	0x295d,
	0x2997,	0x293d,	0x293c,	0x293b,
	0x299c,	0x29c4,	0x29d7,	0x2974,
	0x29a6,	0x29ae,	0x29ad,	0x29d6,
	0x29a5,	0x29aa,	0x29b0,	0x29a9,
	0x29a7,	0x29a4,	0x2977,	0x29ac,
	0x2976,	0x2975,	0x29a8,	0x29b2,
	0x29af,	0x29b1,	0x29db,	0x2978,
	0x28df,	0x28e1,	0x28e4,	0x28e2,
	0x28e3,	0x28e5,	0x28f1,	0x2962,
	0x2998,	0x2903,	0x2904,	0x29a1,
	0x28f2,	};

static const int mb_tbl_uni_docomo2code3_len = sizeof(mb_tbl_uni_docomo2code3_key)/sizeof(unsigned short);

static const int mb_tbl_uni_kddi2code1_min = 0x0023;
static const int mb_tbl_uni_kddi2code1_max = 0x00ae;

static const unsigned short mb_tbl_uni_kddi2code1_key[] = { // 0x0023 - 0x00ae
	0x0023,	0x0030,	0x0031,	0x0032,
	0x0033,	0x0034,	0x0035,	0x0036,
	0x0037,	0x0038,	0x0039,	0x00a9,
	0x00ae,	};

static const unsigned short mb_tbl_uni_kddi2code1_value[] = { // 0x0023 - 0x00ae
	0x25bc,	0x2830,	0x27a6,	0x27a7,
	0x27a8,	0x27a9,	0x27aa,	0x27ab,
	0x27ac,	0x27ad,	0x27ae,	0x27dc,
	0x27dd,	};

static const int mb_tbl_uni_kddi2code1_len = sizeof(mb_tbl_uni_kddi2code1_key)/sizeof(unsigned short);

static const int mb_tbl_uni_kddi2code2_min = 0x2002;
static const int mb_tbl_uni_kddi2code2_max = 0x3299;

static const unsigned short mb_tbl_uni_kddi2code2_key[] = { // 0x2002 - 0x3299
	0x2002,	0x2003,	0x2005,	0x203c,
	0x2049,	0x2122,	0x2139,	0x2194,
	0x2195,	0x2196,	0x2197,	0x2198,
	0x2199,	0x21a9,	0x21aa,	0x231a,
	0x231b,	0x23e9,	0x23ea,	0x23eb,
	0x23ec,	0x23f0,	0x23f3,	0x25aa,
	0x25ab,	0x25b6,	0x25c0,	0x25fb,
	0x25fc,	0x25fd,	0x25fe,	0x2600,
	0x2601,	0x260e,	0x2611,	0x2614,
	0x2615,	0x261d,	0x263a,	0x2648,
	0x2649,	0x264a,	0x264b,	0x264c,
	0x264d,	0x264e,	0x264f,	0x2650,
	0x2651,	0x2652,	0x2653,	0x2660,
	0x2663,	0x2665,	0x2666,	0x2668,
	0x267b,	0x267f,	0x2693,	0x26a0,
	0x26a1,	0x26aa,	0x26ab,	0x26bd,
	0x26be,	0x26c4,	0x26c5,	0x26ce,
	0x26d4,	0x26ea,	0x26f2,	0x26f3,
	0x26f5,	0x26fa,	0x26fd,	0x2702,
	0x2705,	0x2708,	0x2709,	0x270a,
	0x270b,	0x270c,	0x270f,	0x2712,
	0x2714,	0x2716,	0x2728,	0x2733,
	0x2734,	0x2744,	0x2747,	0x274c,
	0x274e,	0x2753,	0x2757,	0x2764,
	0x2795,	0x2796,	0x2797,	0x27a1,
	0x27b0,	0x2934,	0x2935,	0x2b05,
	0x2b06,	0x2b07,	0x2b1b,	0x2b1c,
	0x2b50,	0x2b55,	0x3297,	0x3299,
	};

static const unsigned short mb_tbl_uni_kddi2code2_value[] = { // 0x2002 - 0x3299
	0x2811,	0x2810,	0x2812,	0x2568,
	0x2567,	0x27d2,	0x27b7,	0x25b2,
	0x25b3,	0x27d0,	0x27d9,	0x27d1,
	0x27da,	0x27e1,	0x27e0,	0x27fe,
	0x27ff,	0x27b4,	0x27b3,	0x27c9,
	0x27c8,	0x2818,	0x2700,	0x27b6,
	0x27b5,	0x27b2,	0x27b1,	0x27bc,
	0x27bd,	0x27b8,	0x27b9,	0x270c,
	0x2711,	0x281a,	0x2840,	0x2710,
	0x281b,	0x277a,	0x277f,	0x2713,
	0x2714,	0x2715,	0x2716,	0x2717,
	0x2718,	0x2719,	0x271a,	0x271b,
	0x271c,	0x271d,	0x271e,	0x2825,
	0x2827,	0x24f0,	0x2826,	0x2740,
	0x25b1,	0x2703,	0x272d,	0x2705,
	0x270b,	0x27be,	0x27bf,	0x273a,
	0x273e,	0x2709,	0x2712,	0x271f,
	0x2708,	0x2852,	0x24ba,	0x281d,
	0x2738,	0x24bb,	0x27f5,	0x279a,
	0x27e2,	0x2737,	0x27a5,	0x25bb,
	0x282b,	0x282a,	0x2725,	0x2841,
	0x27db,	0x27d3,	0x24f6,	0x27c2,
	0x26fd,	0x270e,	0x26f0,	0x27d4,
	0x27d5,	0x2707,	0x2706,	0x2819,
	0x27c0,	0x27c1,	0x27d8,	0x27d6,
	0x2569,	0x2565,	0x2566,	0x27d7,
	0x27c3,	0x27c4,	0x27cd,	0x27cc,
	0x270f,	0x24f8,	0x24e4,	0x2775,
	};

static const int mb_tbl_uni_kddi2code2_len = sizeof(mb_tbl_uni_kddi2code2_key)/sizeof(unsigned short);

static const int mb_tbl_uni_kddi2code3_min = 0x1f004;
static const int mb_tbl_uni_kddi2code3_max = 0x1f6c0;

static const unsigned short mb_tbl_uni_kddi2code3_key[] = { // 0x1f004 - 0x1f6c0
	0xf004,	0xf0cf,	0xf170,	0xf171,
	0xf17e,	0xf17f,	0xf18e,	0xf191,
	0xf192,	0xf193,	0xf194,	0xf195,
	0xf197,	0xf198,	0xf199,	0xf19a,
	0xf1e8,	0xf1e9,	0xf1ea,	0xf1eb,
	0xf1ec,	0xf1ee,	0xf1ef,	0xf1f0,
	0xf1f7,	0xf1fa,	0xf202,	0xf22f,
	0xf233,	0xf235,	0xf239,	0xf23a,
	0xf250,	0xf251,	0xf300,	0xf301,
	0xf302,	0xf303,	0xf305,	0xf306,
	0xf308,	0xf309,	0xf30a,	0xf30b,
	0xf30c,	0xf30f,	0xf311,	0xf313,
	0xf314,	0xf319,	0xf31b,	0xf320,
	0xf330,	0xf331,	0xf334,	0xf335,
	0xf337,	0xf338,	0xf339,	0xf33a,
	0xf33b,	0xf33c,	0xf33d,	0xf33f,
	0xf340,	0xf341,	0xf342,	0xf344,
	0xf345,	0xf346,	0xf347,	0xf348,
	0xf349,	0xf34a,	0xf34c,	0xf34d,
	0xf34e,	0xf34f,	0xf351,	0xf352,
	0xf353,	0xf354,	0xf355,	0xf356,
	0xf357,	0xf358,	0xf359,	0xf35a,
	0xf35b,	0xf35c,	0xf35d,	0xf35e,
	0xf35f,	0xf360,	0xf361,	0xf362,
	0xf363,	0xf364,	0xf365,	0xf366,
	0xf367,	0xf368,	0xf369,	0xf36a,
	0xf36b,	0xf36c,	0xf36d,	0xf36e,
	0xf36f,	0xf370,	0xf371,	0xf372,
	0xf373,	0xf374,	0xf375,	0xf376,
	0xf377,	0xf378,	0xf379,	0xf37a,
	0xf37b,	0xf380,	0xf381,	0xf382,
	0xf383,	0xf384,	0xf385,	0xf386,
	0xf387,	0xf388,	0xf389,	0xf38a,
	0xf38b,	0xf38c,	0xf38d,	0xf38e,
	0xf38f,	0xf390,	0xf391,	0xf392,
	0xf393,	0xf3a1,	0xf3a2,	0xf3a3,
	0xf3a4,	0xf3a5,	0xf3a7,	0xf3a8,
	0xf3a9,	0xf3aa,	0xf3ab,	0xf3ac,
	0xf3ad,	0xf3ae,	0xf3af,	0xf3b0,
	0xf3b1,	0xf3b2,	0xf3b3,	0xf3b4,
	0xf3b5,	0xf3b6,	0xf3b8,	0xf3b9,
	0xf3ba,	0xf3bb,	0xf3bc,	0xf3be,
	0xf3bf,	0xf3c0,	0xf3c1,	0xf3c2,
	0xf3c3,	0xf3c4,	0xf3c6,	0xf3c8,
	0xf3ca,	0xf3e0,	0xf3e1,	0xf3e2,
	0xf3e3,	0xf3e5,	0xf3e6,	0xf3e7,
	0xf3e8,	0xf3e9,	0xf3ea,	0xf3eb,
	0xf3ec,	0xf3ed,	0xf3ee,	0xf3ef,
	0xf3f0,	0xf40c,	0xf40d,	0xf414,
	0xf417,	0xf418,	0xf419,	0xf41a,
	0xf41b,	0xf41c,	0xf41d,	0xf41e,
	0xf420,	0xf421,	0xf422,	0xf423,
	0xf424,	0xf425,	0xf427,	0xf428,
	0xf429,	0xf42b,	0xf42c,	0xf42d,
	0xf42e,	0xf42f,	0xf430,	0xf431,
	0xf432,	0xf433,	0xf434,	0xf435,
	0xf436,	0xf437,	0xf438,	0xf43b,
	0xf43c,	0xf43d,	0xf43e,	0xf440,
	0xf442,	0xf443,	0xf444,	0xf445,
	0xf446,	0xf447,	0xf448,	0xf449,
	0xf44a,	0xf44b,	0xf44c,	0xf44d,
	0xf44e,	0xf44f,	0xf451,	0xf452,
	0xf453,	0xf454,	0xf455,	0xf456,
	0xf457,	0xf458,	0xf459,	0xf45a,
	0xf45b,	0xf45c,	0xf45e,	0xf45f,
	0xf460,	0xf462,	0xf463,	0xf468,
	0xf469,	0xf46a,	0xf46e,	0xf46f,
	0xf470,	0xf471,	0xf472,	0xf473,
	0xf474,	0xf475,	0xf476,	0xf477,
	0xf478,	0xf479,	0xf47a,	0xf47b,
	0xf47c,	0xf47d,	0xf47e,	0xf47f,
	0xf480,	0xf483,	0xf484,	0xf485,
	0xf486,	0xf487,	0xf488,	0xf489,
	0xf48a,	0xf48b,	0xf48c,	0xf48d,
	0xf48f,	0xf490,	0xf491,	0xf493,
	0xf494,	0xf495,	0xf496,	0xf498,
	0xf499,	0xf49a,	0xf49b,	0xf49c,
	0xf49d,	0xf49e,	0xf4a1,	0xf4a2,
	0xf4a3,	0xf4a4,	0xf4a5,	0xf4a6,
	0xf4a7,	0xf4a8,	0xf4a9,	0xf4aa,
	0xf4ab,	0xf4ac,	0xf4ae,	0xf4af,
	0xf4b0,	0xf4b2,	0xf4b3,	0xf4b4,
	0xf4b5,	0xf4b8,	0xf4b9,	0xf4bb,
	0xf4bc,	0xf4bd,	0xf4be,	0xf4bf,
	0xf4c1,	0xf4c2,	0xf4c3,	0xf4c4,
	0xf4c5,	0xf4c6,	0xf4c7,	0xf4c8,
	0xf4c9,	0xf4ca,	0xf4cb,	0xf4cc,
	0xf4cd,	0xf4ce,	0xf4cf,	0xf4d0,
	0xf4d1,	0xf4d2,	0xf4d3,	0xf4d4,
	0xf4d5,	0xf4d6,	0xf4d7,	0xf4d8,
	0xf4d9,	0xf4da,	0xf4db,	0xf4dc,
	0xf4dd,	0xf4de,	0xf4df,	0xf4e0,
	0xf4e1,	0xf4e4,	0xf4e5,	0xf4e6,
	0xf4e7,	0xf4e8,	0xf4e9,	0xf4ea,
	0xf4eb,	0xf4f0,	0xf4f1,	0xf4f2,
	0xf4f3,	0xf4f4,	0xf4f6,	0xf4f7,
	0xf4f9,	0xf4fa,	0xf4fb,	0xf4fc,
	0xf503,	0xf50a,	0xf50b,	0xf50c,
	0xf50d,	0xf50e,	0xf50f,	0xf510,
	0xf511,	0xf512,	0xf514,	0xf516,
	0xf517,	0xf518,	0xf519,	0xf51e,
	0xf51f,	0xf520,	0xf521,	0xf522,
	0xf523,	0xf524,	0xf525,	0xf526,
	0xf527,	0xf528,	0xf529,	0xf52a,
	0xf52b,	0xf52e,	0xf530,	0xf534,
	0xf535,	0xf536,	0xf537,	0xf538,
	0xf539,	0xf53a,	0xf53b,	0xf53c,
	0xf53d,	0xf5fb,	0xf5fc,	0xf5fe,
	0xf5ff,	0xf601,	0xf602,	0xf603,
	0xf609,	0xf60a,	0xf60c,	0xf60d,
	0xf60f,	0xf612,	0xf613,	0xf614,
	0xf616,	0xf618,	0xf61a,	0xf61c,
	0xf620,	0xf621,	0xf622,	0xf623,
	0xf624,	0xf628,	0xf629,	0xf62a,
	0xf62b,	0xf62d,	0xf630,	0xf631,
	0xf632,	0xf633,	0xf635,	0xf637,
	0xf638,	0xf639,	0xf63a,	0xf63b,
	0xf63c,	0xf63d,	0xf63e,	0xf63f,
	0xf640,	0xf645,	0xf646,	0xf647,
	0xf648,	0xf649,	0xf64a,	0xf64b,
	0xf64c,	0xf64d,	0xf64e,	0xf64f,
	0xf680,	0xf683,	0xf685,	0xf687,
	0xf689,	0xf68c,	0xf68f,	0xf691,
	0xf692,	0xf693,	0xf697,	0xf69a,
	0xf6a2,	0xf6a5,	0xf6a7,	0xf6a8,
	0xf6a9,	0xf6ab,	0xf6ac,	0xf6ad,
	0xf6b2,	0xf6b6,	0xf6bb,	0xf6c0,
	};

static const unsigned short mb_tbl_uni_kddi2code3_value[] = { // 0x1f004 - 0x1f6c0
	0x24bc,	0x25a7,	0x255e,	0x255f,
	0x2560,	0x272a,	0x2561,	0x282f,
	0x24d0,	0x27fc,	0x24d3,	0x284c,
	0x2831,	0x276c,	0x2793,	0x24bd,
	0x2549,	0x2546,	0x24c0,	0x2545,
	0x2548,	0x2547,	0x2750,	0x254a,
	0x24c1,	0x27f7,	0x24d2,	0x24d6,
	0x24d5,	0x24d4,	0x24d1,	0x24d7,
	0x277b,	0x283f,	0x26ed,	0x281c,
	0x2533,	0x253c,	0x253f,	0x24c5,
	0x253d,	0x2743,	0x25b4,	0x258b,
	0x2597,	0x2837,	0x282c,	0x282e,
	0x282d,	0x270a,	0x270d,	0x26ec,
	0x2570,	0x25b5,	0x2766,	0x24e1,
	0x2768,	0x274e,	0x2851,	0x24df,
	0x2767,	0x2581,	0x256e,	0x25ba,
	0x2797,	0x2752,	0x24b8,	0x256f,
	0x2506,	0x2507,	0x256c,	0x256a,
	0x2751,	0x2505,	0x256d,	0x256b,
	0x2504,	0x2592,	0x2571,	0x2756,
	0x2758,	0x275a,	0x2573,	0x2748,
	0x2574,	0x24fe,	0x2759,	0x24ff,
	0x2501,	0x2838,	0x2500,	0x24fa,
	0x24fc,	0x2572,	0x24fd,	0x2502,
	0x2503,	0x25a8,	0x2771,	0x24fb,
	0x2535,	0x2582,	0x2583,	0x2584,
	0x2585,	0x2586,	0x2587,	0x258e,
	0x2591,	0x2754,	0x2508,	0x2509,
	0x2755,	0x2730,	0x24f9,	0x24e2,
	0x2745,	0x2746,	0x2576,	0x2747,
	0x24e3,	0x2823,	0x2753,	0x2824,
	0x2539,	0x274d,	0x253b,	0x2863,
	0x2536,	0x24e6,	0x24e7,	0x26f3,
	0x2575,	0x24c4,	0x252e,	0x252f,
	0x2532,	0x2538,	0x253a,	0x2531,
	0x2530,	0x26f1,	0x252d,	0x257a,
	0x2787,	0x279b,	0x278c,	0x2820,
	0x2540,	0x2822,	0x2722,	0x2742,
	0x2821,	0x274a,	0x2749,	0x26f2,
	0x2528,	0x274c,	0x257b,	0x25a6,
	0x2855,	0x2789,	0x278a,	0x2578,
	0x2527,	0x278b,	0x2517,	0x273b,
	0x24f7,	0x281e,	0x273d,	0x273c,
	0x26ef,	0x2579,	0x24be,	0x273f,
	0x2529,	0x272f,	0x2847,	0x2731,
	0x24c9,	0x24ca,	0x272e,	0x2727,
	0x24cc,	0x253e,	0x2728,	0x24cb,
	0x2541,	0x2544,	0x2741,	0x2542,
	0x2543,	0x25b6,	0x255a,	0x255b,
	0x255c,	0x2557,	0x285e,	0x2537,
	0x2556,	0x2761,	0x258f,	0x2590,
	0x2555,	0x2757,	0x24bf,	0x24c6,
	0x2764,	0x25ae,	0x2760,	0x2558,
	0x2763,	0x255d,	0x2553,	0x2859,
	0x2559,	0x2857,	0x275b,	0x275f,
	0x2577,	0x26f4,	0x275c,	0x275d,
	0x2765,	0x2762,	0x275e,	0x2858,
	0x257e,	0x2580,	0x2772,	0x2828,
	0x2829,	0x251b,	0x251c,	0x257f,
	0x24d8,	0x24d9,	0x2783,	0x2784,
	0x2777,	0x2521,	0x251f,	0x277d,
	0x2520,	0x251e,	0x2860,	0x24e9,
	0x2782,	0x24de,	0x284d,	0x25af,
	0x25a3,	0x24ee,	0x24ef,	0x2791,
	0x2788,	0x2720,	0x284e,	0x2563,
	0x279e,	0x24ea,	0x2562,	0x2780,
	0x277e,	0x2785,	0x24c8,	0x2526,
	0x2534,	0x254b,	0x254c,	0x254d,
	0x254e,	0x254f,	0x2550,	0x2551,
	0x2552,	0x257c,	0x257d,	0x274f,
	0x2856,	0x2792,	0x2770,	0x2773,
	0x277c,	0x2554,	0x278d,	0x24eb,
	0x278f,	0x24ec,	0x24ed,	0x2794,
	0x24e5,	0x276f,	0x25b0,	0x2798,
	0x2861,	0x24e0,	0x2525,	0x25ad,
	0x26fb,	0x26fc,	0x24f1,	0x276e,
	0x24f2,	0x24f3,	0x24f4,	0x24f5,
	0x258c,	0x2833,	0x26fa,	0x2769,
	0x26fe,	0x26f9,	0x2834,	0x2835,
	0x276a,	0x2778,	0x2779,	0x276d,
	0x2594,	0x2781,	0x2774,	0x2776,
	0x274b,	0x27fd,	0x2800,	0x2801,
	0x2809,	0x2593,	0x24c7,	0x284f,
	0x24b9,	0x2806,	0x27e6,	0x2790,
	0x2813,	0x2814,	0x27e5,	0x27ed,
	0x27e7,	0x27ee,	0x27f0,	0x27f9,
	0x27fa,	0x27f8,	0x27e8,	0x27f1,
	0x27e4,	0x2724,	0x27f4,	0x2726,
	0x2849,	0x27f2,	0x27ef,	0x2721,
	0x27ec,	0x2723,	0x27e9,	0x27ea,
	0x27eb,	0x27f3,	0x27a1,	0x27e3,
	0x24dd,	0x27a2,	0x281f,	0x27a4,
	0x272c,	0x2816,	0x2817,	0x27a3,
	0x25a9,	0x2815,	0x259a,	0x279f,
	0x2848,	0x280f,	0x280c,	0x2846,
	0x24db,	0x24dc,	0x24cf,	0x2799,
	0x2802,	0x2786,	0x2850,	0x2804,
	0x284b,	0x2795,	0x2808,	0x280d,
	0x279c,	0x2843,	0x284a,	0x283a,
	0x279d,	0x27a0,	0x2796,	0x2845,
	0x280e,	0x2842,	0x2844,	0x24ce,
	0x27af,	0x283b,	0x283c,	0x283d,
	0x283e,	0x258d,	0x26ff,	0x2807,
	0x280b,	0x2862,	0x2805,	0x2803,
	0x278e,	0x24da,	0x2704,	0x27ce,
	0x27cf,	0x27ca,	0x27cb,	0x27ba,
	0x27bb,	0x27de,	0x27df,	0x27c7,
	0x27c6,	0x2854,	0x2744,	0x27f6,
	0x25a4,	0x25b8,	0x259c,	0x26f5,
	0x285a,	0x2518,	0x2510,	0x285b,
	0x250a,	0x2514,	0x285d,	0x250b,
	0x250e,	0x251a,	0x2519,	0x276b,
	0x26f6,	0x2595,	0x25a1,	0x250d,
	0x250c,	0x2511,	0x259f,	0x250f,
	0x26f8,	0x26f7,	0x2516,	0x285c,
	0x2515,	0x2513,	0x2832,	0x2512,
	0x25b7,	0x259b,	0x2599,	0x259d,
	0x25a2,	0x2598,	0x2596,	0x25a0,
	0x259e,	0x2522,	0x2523,	0x2524,
	0x2588,	0x258a,	0x2589,	0x25bd,
	0x25be,	0x25bf,	0x25c0,	0x251d,
	0x285f,	0x2739,	0x2734,	0x2853,
	0x25a5,	0x2733,	0x272b,	0x252b,
	0x252a,	0x252c,	0x2735,	0x2736,
	0x24cd,	0x26ee,	0x24c2,	0x25ab,
	0x2564,	0x27c5,	0x2701,	0x2702,
	0x2732,	0x25aa,	0x2729,	0x24c3,
	};

static const int mb_tbl_uni_kddi2code3_len = sizeof(mb_tbl_uni_kddi2code3_key)/sizeof(unsigned short);

static const int mb_tbl_uni_sb2code1_min = 0x0023;
static const int mb_tbl_uni_sb2code1_max = 0x00ae;

static const unsigned short mb_tbl_uni_sb2code1_key[] = { // 0x0023 - 0x00ae
	0x0023,	0x0030,	0x0031,	0x0032,
	0x0033,	0x0034,	0x0035,	0x0036,
	0x0037,	0x0038,	0x0039,	0x00a9,
	0x00ae,	};

static const unsigned short mb_tbl_uni_sb2code1_value[] = { // 0x0023 - 0x00ae
	0x2817,	0x282c,	0x2823,	0x2824,
	0x2825,	0x2826,	0x2827,	0x2828,
	0x2829,	0x282a,	0x282b,	0x2855,
	0x2856,	};

static const int mb_tbl_uni_sb2code1_len = sizeof(mb_tbl_uni_sb2code1_key)/sizeof(unsigned short);

static const int mb_tbl_uni_sb2code2_min = 0x2122;
static const int mb_tbl_uni_sb2code2_max = 0x3299;

static const unsigned short mb_tbl_uni_sb2code2_key[] = { // 0x2122 - 0x3299
	0x2122,	0x2196,	0x2197,	0x2198,
	0x2199,	0x23e9,	0x23ea,	0x25b6,
	0x25c0,	0x2600,	0x2601,	0x260e,
	0x2614,	0x2615,	0x261d,	0x263a,
	0x2648,	0x2649,	0x264a,	0x264b,
	0x264c,	0x264d,	0x264e,	0x264f,
	0x2650,	0x2651,	0x2652,	0x2653,
	0x2660,	0x2663,	0x2665,	0x2666,
	0x2668,	0x267f,	0x26a0,	0x26a1,
	0x26bd,	0x26be,	0x26c4,	0x26ce,
	0x26ea,	0x26f2,	0x26f3,	0x26f5,
	0x26fa,	0x26fd,	0x2702,	0x2708,
	0x270a,	0x270b,	0x270c,	0x2728,
	0x2733,	0x2734,	0x274c,	0x2753,
	0x2754,	0x2755,	0x2757,	0x2764,
	0x27a1,	0x27bf,	0x2b05,	0x2b06,
	0x2b07,	0x2b50,	0x2b55,	0x303d,
	0x3297,	0x3299,	};

static const unsigned short mb_tbl_uni_sb2code2_value[] = { // 0x2122 - 0x3299
	0x2b2e,	0x283e,	0x283d,	0x283f,
	0x2840,	0x2843,	0x2844,	0x2841,
	0x2842,	0x296a,	0x2969,	0x2929,
	0x296b,	0x2965,	0x292f,	0x2aac,
	0x2846,	0x2847,	0x2848,	0x2849,
	0x284a,	0x284b,	0x284c,	0x284d,
	0x284e,	0x284f,	0x2850,	0x2851,
	0x2815,	0x2816,	0x2813,	0x2814,
	0x27cb,	0x2811,	0x2859,	0x27e5,
	0x2938,	0x2936,	0x2968,	0x2852,
	0x2957,	0x27c9,	0x2934,	0x293c,
	0x27ca,	0x295a,	0x2992,	0x293d,
	0x2930,	0x2932,	0x2931,	0x29ad,
	0x280d,	0x280c,	0x29b2,	0x2940,
	0x29b5,	0x29b6,	0x2941,	0x2942,
	0x283b,	0x2818,	0x283c,	0x2839,
	0x283a,	0x29ae,	0x29b1,	0x27d4,
	0x298c,	0x2994,	};

static const int mb_tbl_uni_sb2code2_len = sizeof(mb_tbl_uni_sb2code2_key)/sizeof(unsigned short);

static const int mb_tbl_uni_sb2code3_min = 0x1f004;
static const int mb_tbl_uni_sb2code3_max = 0x1f6c0;

static const unsigned short mb_tbl_uni_sb2code3_key[] = { // 0x1f004 - 0x1f6c0
	0xf004,	0xf170,	0xf171,	0xf17e,
	0xf17f,	0xf18e,	0xf192,	0xf194,
	0xf195,	0xf197,	0xf199,	0xf19a,
	0xf1e8,	0xf1e9,	0xf1ea,	0xf1eb,
	0xf1ec,	0xf1ee,	0xf1ef,	0xf1f0,
	0xf1f7,	0xf1fa,	0xf201,	0xf202,
	0xf21a,	0xf22f,	0xf233,	0xf235,
	0xf236,	0xf237,	0xf238,	0xf239,
	0xf23a,	0xf250,	0xf300,	0xf302,
	0xf303,	0xf304,	0xf305,	0xf306,
	0xf307,	0xf308,	0xf30a,	0xf319,
	0xf31f,	0xf334,	0xf335,	0xf337,
	0xf338,	0xf339,	0xf33a,	0xf33b,
	0xf33e,	0xf340,	0xf341,	0xf342,
	0xf343,	0xf345,	0xf346,	0xf349,
	0xf34a,	0xf34e,	0xf353,	0xf354,
	0xf358,	0xf359,	0xf35a,	0xf35b,
	0xf35c,	0xf35d,	0xf35e,	0xf35f,
	0xf361,	0xf362,	0xf363,	0xf366,
	0xf367,	0xf370,	0xf371,	0xf372,
	0xf373,	0xf374,	0xf375,	0xf376,
	0xf378,	0xf37a,	0xf37b,	0xf380,
	0xf381,	0xf382,	0xf383,	0xf384,
	0xf385,	0xf386,	0xf387,	0xf388,
	0xf389,	0xf38c,	0xf38d,	0xf38e,
	0xf38f,	0xf390,	0xf391,	0xf392,
	0xf393,	0xf3a1,	0xf3a2,	0xf3a4,
	0xf3a5,	0xf3a6,	0xf3a7,	0xf3a8,
	0xf3a9,	0xf3ab,	0xf3ac,	0xf3af,
	0xf3b0,	0xf3b1,	0xf3b5,	0xf3b6,
	0xf3b7,	0xf3b8,	0xf3ba,	0xf3be,
	0xf3bf,	0xf3c0,	0xf3c1,	0xf3c3,
	0xf3c4,	0xf3c6,	0xf3c8,	0xf3ca,
	0xf3e0,	0xf3e2,	0xf3e3,	0xf3e5,
	0xf3e6,	0xf3e7,	0xf3e8,	0xf3e9,
	0xf3ea,	0xf3eb,	0xf3ec,	0xf3ed,
	0xf3ef,	0xf3f0,	0xf40d,	0xf40e,
	0xf411,	0xf412,	0xf414,	0xf417,
	0xf418,	0xf419,	0xf41a,	0xf41b,
	0xf41f,	0xf420,	0xf424,	0xf426,
	0xf427,	0xf428,	0xf42b,	0xf42c,
	0xf42d,	0xf42e,	0xf42f,	0xf430,
	0xf431,	0xf433,	0xf434,	0xf435,
	0xf436,	0xf437,	0xf438,	0xf439,
	0xf43a,	0xf43b,	0xf440,	0xf442,
	0xf443,	0xf444,	0xf446,	0xf447,
	0xf448,	0xf449,	0xf44a,	0xf44b,
	0xf44c,	0xf44d,	0xf44e,	0xf44f,
	0xf450,	0xf451,	0xf452,	0xf454,
	0xf455,	0xf457,	0xf458,	0xf459,
	0xf45c,	0xf45f,	0xf460,	0xf461,
	0xf462,	0xf463,	0xf466,	0xf467,
	0xf468,	0xf469,	0xf46b,	0xf46e,
	0xf46f,	0xf471,	0xf472,	0xf473,
	0xf474,	0xf475,	0xf476,	0xf477,
	0xf478,	0xf47b,	0xf47c,	0xf47d,
	0xf47e,	0xf47f,	0xf480,	0xf481,
	0xf482,	0xf483,	0xf484,	0xf485,
	0xf486,	0xf487,	0xf488,	0xf489,
	0xf48a,	0xf48b,	0xf48d,	0xf48e,
	0xf48f,	0xf490,	0xf491,	0xf492,
	0xf493,	0xf494,	0xf497,	0xf498,
	0xf499,	0xf49a,	0xf49b,	0xf49c,
	0xf49d,	0xf49f,	0xf4a1,	0xf4a2,
	0xf4a3,	0xf4a4,	0xf4a6,	0xf4a8,
	0xf4a9,	0xf4aa,	0xf4b0,	0xf4b1,
	0xf4b9,	0xf4ba,	0xf4bb,	0xf4bc,
	0xf4bd,	0xf4bf,	0xf4c0,	0xf4d6,
	0xf4dd,	0xf4e0,	0xf4e1,	0xf4e2,
	0xf4e3,	0xf4e9,	0xf4eb,	0xf4ee,
	0xf4f1,	0xf4f2,	0xf4f3,	0xf4f4,
	0xf4f6,	0xf4f7,	0xf4fa,	0xf4fb,
	0xf4fc,	0xf50a,	0xf50d,	0xf511,
	0xf512,	0xf513,	0xf514,	0xf51d,
	0xf51e,	0xf525,	0xf528,	0xf52b,
	0xf52f,	0xf530,	0xf531,	0xf532,
	0xf533,	0xf534,	0xf550,	0xf551,
	0xf552,	0xf553,	0xf554,	0xf555,
	0xf556,	0xf557,	0xf558,	0xf559,
	0xf55a,	0xf55b,	0xf5fb,	0xf5fc,
	0xf5fd,	0xf601,	0xf602,	0xf603,
	0xf604,	0xf609,	0xf60a,	0xf60c,
	0xf60d,	0xf60f,	0xf612,	0xf613,
	0xf614,	0xf616,	0xf618,	0xf61a,
	0xf61c,	0xf61d,	0xf61e,	0xf620,
	0xf621,	0xf622,	0xf623,	0xf625,
	0xf628,	0xf62a,	0xf62d,	0xf630,
	0xf631,	0xf632,	0xf633,	0xf637,
	0xf645,	0xf646,	0xf647,	0xf64c,
	0xf64f,	0xf680,	0xf683,	0xf684,
	0xf685,	0xf687,	0xf689,	0xf68c,
	0xf68f,	0xf691,	0xf692,	0xf693,
	0xf695,	0xf697,	0xf699,	0xf69a,
	0xf6a2,	0xf6a4,	0xf6a5,	0xf6a7,
	0xf6ac,	0xf6ad,	0xf6b2,	0xf6b6,
	0xf6b9,	0xf6ba,	0xf6bb,	0xf6bc,
	0xf6bd,	0xf6be,	0xf6c0,	};

static const unsigned short mb_tbl_uni_sb2code3_value[] = { // 0x1f004 - 0x1f6c0
	0x27d5,	0x2b29,	0x2b2a,	0x2b2c,
	0x27f7,	0x2b2b,	0x281b,	0x2830,
	0x2819,	0x2854,	0x281a,	0x27d6,
	0x2b0a,	0x2b05,	0x2b08,	0x2b04,
	0x2b07,	0x2b06,	0x2b02,	0x2b0b,
	0x2b09,	0x2b03,	0x280a,	0x282f,
	0x281d,	0x2833,	0x2832,	0x2831,
	0x281c,	0x281e,	0x281f,	0x282e,
	0x2834,	0x282d,	0x2adb,	0x2ad4,
	0x2ae3,	0x296d,	0x2ae1,	0x27ee,
	0x2ae2,	0x2ae4,	0x2ad6,	0x296c,
	0x29b4,	0x2986,	0x2987,	0x2983,
	0x2950,	0x2952,	0x2982,	0x2984,
	0x2adc,	0x27b8,	0x27c0,	0x27c1,
	0x2adf,	0x29c8,	0x29c9,	0x29c7,
	0x29c5,	0x29c4,	0x29c6,	0x27c8,
	0x29bc,	0x29c1,	0x29bd,	0x29c0,
	0x29bf,	0x29be,	0x29b8,	0x29ba,
	0x29bb,	0x29c2,	0x29c3,	0x29b9,
	0x2ad7,	0x2966,	0x29cb,	0x29cc,
	0x27ef,	0x2963,	0x29b7,	0x298a,
	0x2964,	0x2967,	0x298b,	0x2993,
	0x27ba,	0x29ca,	0x2add,	0x2953,
	0x2ae0,	0x27bf,	0x2ad8,	0x298f,
	0x2991,	0x27eb,	0x2ace,	0x2ad0,
	0x2ad3,	0x2ada,	0x2ade,	0x2ad2,
	0x2ad1,	0x27cc,	0x2acb,	0x295c,
	0x295d,	0x2afe,	0x2989,	0x2af9,
	0x2afa,	0x27cd,	0x29a3,	0x27d8,
	0x27db,	0x2ac4,	0x295e,	0x29a5,
	0x2960,	0x2961,	0x2962,	0x2935,
	0x2933,	0x2ac2,	0x27da,	0x27bd,
	0x2937,	0x27d9,	0x2ac3,	0x2ac5,
	0x2956,	0x2958,	0x27fb,	0x27fd,
	0x27f5,	0x27fc,	0x2800,	0x2af8,
	0x27fe,	0x27ff,	0x2afb,	0x2aff,
	0x2afc,	0x2afd,	0x2b24,	0x27dc,
	0x2b20,	0x2b1f,	0x2b25,	0x2b26,
	0x2b1d,	0x27b2,	0x2ad9,	0x2b1c,
	0x2939,	0x2b19,	0x2b1a,	0x2b18,
	0x2975,	0x2b1e,	0x2b27,	0x2b17,
	0x2973,	0x2b22,	0x2970,	0x2b23,
	0x296f,	0x2974,	0x293a,	0x27b1,
	0x2972,	0x27b3,	0x2b28,	0x2b1b,
	0x2b21,	0x2971,	0x2ab1,	0x2ab3,
	0x2ab2,	0x2ab4,	0x2835,	0x2836,
	0x2837,	0x2838,	0x292d,	0x2ab6,
	0x2ab8,	0x292e,	0x2ab9,	0x2ab7,
	0x2aba,	0x27b6,	0x2997,	0x2981,
	0x2926,	0x2998,	0x29a0,	0x29a1,
	0x29a2,	0x2927,	0x27e6,	0x2999,
	0x299a,	0x2b2d,	0x2921,	0x2922,
	0x2924,	0x2925,	0x2ac0,	0x27fa,
	0x2ac1,	0x2b0c,	0x2b0d,	0x2b0e,
	0x2b0f,	0x2b10,	0x2b11,	0x2b12,
	0x2b13,	0x27c3,	0x296e,	0x27b4,
	0x27d3,	0x27c2,	0x27c4,	0x285a,
	0x2b15,	0x2b16,	0x299b,	0x299c,
	0x299d,	0x299e,	0x299f,	0x27e3,
	0x298e,	0x2923,	0x2954,	0x2955,
	0x27b9,	0x2985,	0x2abd,	0x2ad5,
	0x29a6,	0x2943,	0x29a7,	0x29a8,
	0x29a9,	0x29aa,	0x29ab,	0x29ac,
	0x2acf,	0x280b,	0x27b7,	0x29b3,
	0x2990,	0x27e4,	0x29b0,	0x29af,
	0x297a,	0x27f4,	0x27d7,	0x27f1,
	0x27f2,	0x27c7,	0x292c,	0x27c6,
	0x2995,	0x27ce,	0x27cf,	0x27f0,
	0x2980,	0x292b,	0x27f3,	0x27ea,
	0x2996,	0x27ab,	0x27a9,	0x27aa,
	0x292a,	0x27ac,	0x2857,	0x2858,
	0x2812,	0x2928,	0x27d2,	0x27d0,
	0x27d1,	0x27e9,	0x27bc,	0x295f,
	0x27ec,	0x27ed,	0x29a4,	0x2853,
	0x280e,	0x27c5,	0x27be,	0x27bb,
	0x2845,	0x2810,	0x2951,	0x2821,
	0x2822,	0x2820,	0x2944,	0x2945,
	0x2946,	0x2947,	0x2948,	0x2949,
	0x294a,	0x294b,	0x294c,	0x294d,
	0x294e,	0x294f,	0x295b,	0x2b00,
	0x2b14,	0x2a9c,	0x2aaa,	0x2977,
	0x2aad,	0x2a9d,	0x2976,	0x2aa2,
	0x27ae,	0x2a9a,	0x2aa6,	0x27b0,
	0x2a9b,	0x2a9f,	0x2ab0,	0x2aaf,
	0x27ad,	0x2aa1,	0x2978,	0x2979,
	0x2aae,	0x2aab,	0x2a9e,	0x2a99,
	0x2aa3,	0x2aa0,	0x2aa9,	0x2aa7,
	0x27af,	0x2aa8,	0x2aa5,	0x2aa4,
	0x2abb,	0x2abc,	0x2abe,	0x2abf,
	0x2ab5,	0x27b5,	0x293e,	0x2acd,
	0x293f,	0x2acc,	0x2959,	0x2801,
	0x27f8,	0x2ac9,	0x2ac8,	0x2aca,
	0x2802,	0x293b,	0x2ac6,	0x2ac7,
	0x2809,	0x27dd,	0x27f6,	0x27df,
	0x298d,	0x280f,	0x27de,	0x2808,
	0x27e0,	0x27e1,	0x27f9,	0x27e2,
	0x27e8,	0x2988,	0x27e7,	};

static const int mb_tbl_uni_sb2code3_len = sizeof(mb_tbl_uni_sb2code3_key)/sizeof(unsigned short);

/* unsupported in Unicode 6.0 */

static const int mb_tbl_uni_docomo2code5_min = 0xfe82d;
static const int mb_tbl_uni_docomo2code5_max = 0xfee33;

static const unsigned short mb_tbl_uni_docomo2code5_key[] = { // 0xfe82d - 0xfee33
	0xE82D,	0xEE10,	0xEE11,	0xEE12,
	0xEE13,	0xEE14,	0xEE15,	0xEE16,
	0xEE17,	0xEE18,	0xEE19,	0xEE1A,
	0xEE1B,	0xEE1C,	0xEE1D,	0xEE1E,
	0xEE1F,	0xEE20,	0xEE21,	0xEE22,
	0xEE23,	0xEE24,	0xEE25,	0xEE26,
	0xEE27,	0xEE28,	0xEE29,	0xEE2A,
	0xEE2B,	0xEE2C,	0xEE2D,	0xEE2E,
	0xEE2F,	0xEE30,	0xEE31,	0xEE32,
	0xEE33,	};

static const unsigned short mb_tbl_uni_docomo2code5_val[] = { // 0xfe82d - 0xfee33
	0x2965,	0x2955,	0x2956,	0x2958,
	0x2959,	0x2990,	0x2991,	0x292A,
	0x292B,	0x292C,	0x292D,	0x292E,
	0x292F,	0x2933,	0x2934,	0x2938,
	0x2939,	0x293A,	0x293F,	0x2940,
	0x2941,	0x2942,	0x2943,	0x2944,
	0x2945,	0x2946,	0x2947,	0x2948,
	0x2949,	0x294A,	0x294B,	0x294C,
	0x294D,	0x294E,	0x294F,	0x2950,
	0x2951,	};

static const unsigned short mb_tbl_uni_docomo2code5_len = sizeof(mb_tbl_uni_docomo2code5_key)/sizeof(unsigned short);


static const int mb_tbl_uni_kddi2code5_min = 0xfe82d;
static const int mb_tbl_uni_kddi2code5_max = 0xfee4a;

static const unsigned short mb_tbl_uni_kddi2code5_key[] = { // 0xfe82d - 0xfee4a
	0xE82D,	0xE83C,	0xEB89,	0xEE40,
	0xEE41,	0xEE42,	0xEE43,	0xEE44,
	0xEE45,	0xEE46,	0xEE47,	0xEE48,
	0xEE49,	0xEE4A,	};

static const unsigned short mb_tbl_uni_kddi2code5_val[] = { // 0xfe82d - 0xfee4a
	0x27B0,	0x280A,	0x2839,	0x27FB,
	0x2836,	0x24E8,	0x25AC,	0x25B9,
	0x25C1,	0x25C2,	0x25C3,	0x25C4,
	0x25C5,	0x25C6,	};

static const unsigned short mb_tbl_uni_kddi2code5_len = sizeof(mb_tbl_uni_kddi2code5_key)/sizeof(unsigned short);


static const int mb_tbl_uni_sb2code5_min = 0xfe4c5;
static const int mb_tbl_uni_sb2code5_max = 0xfee7d;

static const unsigned short mb_tbl_uni_sb2code5_key[] = { // 0xfe4c5 - 0xfee7d
	0xE4C5,	0xEE70,	0xEE71,	0xEE72,
	0xEE73,	0xEE74,	0xEE75,	0xEE76,
	0xEE77,	0xEE78,	0xEE79,	0xEE7A,
	0xEE7B,	0xEE7C,	0xEE7D,	};

static const unsigned short mb_tbl_uni_sb2code5_val[] = { // 0xfe4c5 - 0xfee7d
	0x2B01,	0x2B2F,	0x2B30,	0x2B31,
	0x2B32,	0x2B33,	0x2B34,	0x2B35,
	0x285B,	0x285C,	0x285D,	0x285E,
	0x285F,	0x2860,	0x2861,	};

static const unsigned short mb_tbl_uni_sb2code5_len = sizeof(mb_tbl_uni_sb2code5_key)/sizeof(unsigned short);
