--TEST--
Thai cp874 basic test
--SKIPIF--
<?php
include dirname(__FILE__) . DIRECTORY_SEPARATOR . "util.inc";

skip_if_not_win();
if (getenv("SKIP_SLOW_TESTS")) die("skip slow test");
skip_if_no_required_exts();
skip_if_wrong_cp(874, "oem");

?>
--INI--
default_charset=cp874
--FILE--
<?php
/*
#vim: set fileencoding=cp874
#vim: set encoding=cp874
*/

include dirname(__FILE__) . DIRECTORY_SEPARATOR . "util.inc";

$names = array( /* cp874 */
	"跴ͺ1",
	"跴ͺ2",
	"跴ͺ3",
	"跴ͺ4",
	"跴ͺ5",
	"跴ͺ6",
	"跴ͺ7",
	"跴ͺ8",
	"跴ͺ8 10",
);

$i = 0;
foreach ($names as $name) {
	$path = dirname(__FILE__) . DIRECTORY_SEPARATOR . $name . ".txt";

	file_put_contents($path, "hello" . $i++);

	get_basename_with_cp($path, 874);
	var_dump(file_get_contents($path));

	unlink($path);
}

?>
===DONE===
--EXPECTF--
Active code page: %d
getting basename of %s跴ͺ1.txt
string(%d) "跴ͺ1.txt"
bool(true)
string(%d) "%s跴ͺ1.txt"
Active code page: %d
string(6) "hello0"
Active code page: %d
getting basename of %s跴ͺ2.txt
string(%d) "跴ͺ2.txt"
bool(true)
string(%d) "%s跴ͺ2.txt"
Active code page: %d
string(6) "hello1"
Active code page: %d
getting basename of %s跴ͺ3.txt
string(%d) "跴ͺ3.txt"
bool(true)
string(%d) "%s跴ͺ3.txt"
Active code page: %d
string(6) "hello2"
Active code page: %d
getting basename of %s跴ͺ4.txt
string(%d) "跴ͺ4.txt"
bool(true)
string(%d) "%s跴ͺ4.txt"
Active code page: %d
string(6) "hello3"
Active code page: %d
getting basename of %s跴ͺ5.txt
string(%d) "跴ͺ5.txt"
bool(true)
string(%d) "%s跴ͺ5.txt"
Active code page: %d
string(6) "hello4"
Active code page: %d
getting basename of %s跴ͺ6.txt
string(%d) "跴ͺ6.txt"
bool(true)
string(%d) "%s跴ͺ6.txt"
Active code page: %d
string(6) "hello5"
Active code page: %d
getting basename of %s跴ͺ7.txt
string(%d) "跴ͺ7.txt"
bool(true)
string(%d) "%s跴ͺ7.txt"
Active code page: %d
string(6) "hello6"
Active code page: %d
getting basename of %s跴ͺ8.txt
string(%d) "跴ͺ8.txt"
bool(true)
string(%d) "%s跴ͺ8.txt"
Active code page: %d
string(6) "hello7"
Active code page: %d
getting basename of %s跴ͺ8 10.txt
string(%d) "跴ͺ8 10.txt"
bool(true)
string(%d) "%s跴ͺ8 10.txt"
Active code page: %d
string(6) "hello8"
===DONE===
