

static const unsigned short sjis_mac2wchar1[] = { // 0x03ac - 0x03c9
0x339c,	0x339f,	0x339d,	0x33a0,
0x33a4,	0xff4d,	0x33a1,	0x33a5,
0x339e,	0x33a2,	0x338e,	0xff47,
0x338f,	0x33c4,	0x3396,	0x3397,
0x2113,	0x3398,	0x33b3,	0x33b2,
0x33b1,	0x33b0,	0x2109,	0x33d4,
0x33cb,	0x3390,	0x3385,	0x3386,
0x3387,	0xf860,	};
static const unsigned short sjis_mac2wchar2[] = { // 0x0406 - 0x0420
0x2116,	0x33cd,
0x2121,	0xf861,	0x2664,	0x2667,
0x2661,	0x2662,	0x2660,	0x2663,
0x2665,	0x2666,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x3020,	0x260e,
0x3004,	};
static const unsigned short sjis_mac2wchar3[] = { // 0x0432 - 0x0441
0x261e,	0x261c,
0x261d,	0x261f,	0x21c6,	0x21c4,
0x21c5,	0xf860,	0x21e8,	0x21e6,
0x21e7,	0x21e9,	0x21e8,	0x21e6,
0x21e7,	0x21e9,	};
static const unsigned short sjis_mac2wchar4[] = { // 0x0468 - 0x0480
0x3230,	0x322a,	0x322b,	0x322c,
0x322d,	0x322e,	0x322f,	0x3240,
0x3237,	0x3242,	0x3243,	0x3239,
0x323a,	0x3231,	0x323e,	0x3234,
0x3232,	0x323b,	0x3236,	0x3233,
0x3235,	0x323c,	0x323d,	0x323f,
0x3238,	};
static const unsigned short sjis_mac2wchar5[] = { // 0x04b8 - 0x04e8
0x5927,	0x5c0f,	0x32a4,	0x32a5,
0x32a6,	0x32a7,	0x32a8,	0x32a9,
0x3296,	0x329d,	0x3298,	0x329e,
0x63a7,	0x3299,	0x3349,	0x3322,
0x334d,	0x3314,	0x3316,	0x3305,
0x3333,	0x334e,	0x3303,	0x3336,
0x3318,	0x3315,	0x3327,	0x3351,
0x334a,	0x3339,	0x3357,	0x330d,
0x3342,	0x3323,	0x3326,	0x333b,
0x332b,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x3300,	0x331e,	0x332a,	0x3331,
0x3347,	};
static const unsigned short sjis_mac2wchar6[] = { // 0x050c - 0x0551
0x337e,	0x337d,	0x337c,	0x337b,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x337f,	0xf862,	0xf862,
0x222e,	0x221f,	0x22bf,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x301d,	0x301f,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x3094,	0x0000,	0x30f7,	0x30f8,
0x30f9,	0x30fa,	};
static const unsigned short sjis_mac2wchar7[] = { // 0x1ed9 - 0x1f18
0x3001,	0x3002,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0xffe3,	0xfe33,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x30fc,
0xfe31,	0x2010,	0x0000,	0x0000,
0x301c,	0x2016,	0xff5c,	0x2026,
0xfe30,	0x0000,	0x0000,	0x0000,
0x0000,	0xfe35,	0xfe36,	0xfe39,
0xfe3a,	0xff3b,	0xff3d,	0xfe37,
0xfe38,	0xfe3f,	0xfe40,	0xfe3d,
0xfe3e,	0xfe41,	0xfe42,	0xfe43,
0xfe44,	0xfe3b,	0xfe3c,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0xff1d,	};
static const unsigned short sjis_mac2wchar8[] = { // 0x1ff2 - 0x20a5
0x3041,	0x0000,
0x3043,	0x0000,	0x3045,	0x0000,
0x3047,	0x0000,	0x3049,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x3063,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x3083,	0x0000,	0x3085,	0x0000,
0x3087,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x308e,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x30a1,	0x0000,	0x30a3,	0x0000,
0x30a5,	0x0000,	0x30a7,	0x0000,
0x30a9,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x30c3,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x30e3,	0x0000,
0x30e5,	0x0000,	0x30e7,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x30ee,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x30f5,	0x30f6,	};

static const unsigned short wchar2sjis_mac4[] = { // 0x2660 - 0x2667
0x040e,	0x040c,	0x040d,	0x040f,
0x040a,	0x0410,	0x0411,	0x040b,
};

static const unsigned short wchar2sjis_mac7[] = { // 0x322a - 0x3243
0x0469, 0x046a,
0x046b, 0x046c, 0x046d, 0x046e,
0x0468, 0x0475, 0x0478, 0x047b,
0x0477, 0x047c, 0x047a, 0x0470,
0x0480, 0x0473, 0x0474, 0x0479,
0x047d, 0x047e, 0x0476, 0x047f,
0x046f, 0x0000, 0x0471, 0x0472,
};

static const unsigned short wchar2sjis_mac8[] = { // 0x3296 - 0x329e
0x04c0, 0x0000,
0x04c2, 0x04c5, 0x0000, 0x0000,
0x0000, 0x04c1, 0x04c3, };

static const unsigned short wchar2sjis_mac9[] = { // 0x3300 - 0x33d4
0x04e4,	0x0000,	0x0000,	0x04ce,
0x0000,	0x04cb,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x04d7,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x04c9,	0x04d1,	0x04ca,	0x0000,
0x04d0,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x04e5,	0x0000,
0x0000,	0x0000,	0x04c7,	0x04d9,
0x0000,	0x0000,	0x04da,	0x04d2,
0x0000,	0x0000,	0x04e6,	0x04dc,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x04e7,	0x0000,	0x04cc,
0x0000,	0x0000,	0x04cf,	0x0000,
0x0000,	0x04d5,	0x0000,	0x04db,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x04d8,	0x0000,
0x0000,	0x0000,	0x0000,	0x04e8,
0x0000,	0x04c6,	0x04d4,	0x0000,
0x0000,	0x04c8,	0x04cd,	0x0000,
0x0000,	0x04d3,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x04d6,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x050f,
0x050e,	0x050d,	0x050c,	0x0521,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x03c6,	0x03c7,	0x03c8,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x03b6,	0x03b8,
0x03c5,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x03ba,	0x03bb,
0x03bd,	0x0000,	0x0000,	0x0000,
0x03ac,	0x03ae,	0x03b4,	0x03ad,
0x03af,	0x03b2,	0x03b5,	0x0000,
0x03b0,	0x03b3,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x03c1,	0x03c0,	0x03bf,	0x03be,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x03b9,	0x0000,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x03c4,
0x0000,	0x0407,	0x0000,	0x0000,
0x0000,	0x0000,	0x0000,	0x0000,
0x03c3,	};

static const unsigned short wchar2sjis_mac10[] = { // 0xfe30 - 0xfe44
0x1efc,	0x1ef4,	0x0000,	0x1ee9,
0x0000,	0x1f01,	0x1f02,	0x1f07,
0x1f08,	0x1f03,	0x1f04,	0x1f11,
0x1f12,	0x1f0b,	0x1f0c,	0x1f09,
0x1f0a,	0x1f0d,	0x1f0e,	0x1f0f,
0x1f10,	};

static const unsigned short code_tbl[][3] = {
	{0x02f0, 0x0303, 0x2460},
	{0x030e, 0x0321, 0x2474},
	{0x032c, 0x0334, 0x2776},
	{0x0341, 0x0349, 0x2488},
	{0x034e, 0x0359, 0x2160},
	{0x0362, 0x036d, 0x2170},
	{0x038a, 0x03a3, 0x249c},
};

static const unsigned short code_ofst_tbl[] [2]= {
	{0x03ac, 0x03c9},
	{0x0406, 0x0420},
	{0x0432, 0x0441},
	{0x0468, 0x0480},
	{0x04b8, 0x04e8},
	{0x050c, 0x0551},
	{0x1ed9, 0x1f18},
	{0x1ff2, 0x20a5},
};

static const unsigned short *code_map[] = {
	sjis_mac2wchar1, sjis_mac2wchar2, sjis_mac2wchar3, sjis_mac2wchar4,
	sjis_mac2wchar5, sjis_mac2wchar6, sjis_mac2wchar7, sjis_mac2wchar8};

static const unsigned short code_tbl_m[][6] = {
	{0x0340, 0xf860, 0x0030, 0x002e, 0x0000, 0x0000},
	{0x03c9, 0xf860, 0x0054, 0x0042, 0x0000, 0x0000},
	{0x035c, 0xf860, 0x0058, 0x0056, 0x0000, 0x0000},
	{0x0370, 0xf860, 0x0078, 0x0076, 0x0000, 0x0000},
	{0x0439, 0xf860, 0x2193, 0x2191, 0x0000, 0x0000},
	{0x0409, 0xf861, 0x0046, 0x0041, 0x0058, 0x0000},
	{0x035b, 0xf861, 0x0058, 0x0049, 0x0056, 0x0000},
	{0x036f, 0xf861, 0x0078, 0x0069, 0x0076, 0x0000},
	{0x035a, 0xf862, 0x0058, 0x0049, 0x0049, 0x0049},
	{0x036e, 0xf862, 0x0078, 0x0069, 0x0069, 0x0069},
	{0x0522, 0xf862, 0x6709, 0x9650, 0x4f1a, 0x793e},
	{0x0523, 0xf862, 0x8ca1, 0x56e3, 0x6cd5, 0x4eba},
};

static  int code_tbl_m_len = sizeof(code_tbl_m)/(sizeof(unsigned short)*6);

static const unsigned short s_form_tbl[] = {
	0x2010,0x2016,0x2026,
	0x3001,0x3002,0x301c,0x3041,0x3043,0x3045,0x3047,0x3049,
	0x3063,0x3083,0x3085,0x3087,0x308e,0x30a1,0x30a3,0x30a5,
	0x30a7,0x30a9,0x30c3,0x30e3,0x30e5,0x30e7,0x30ee,0x30f5,
	0x30f6,0x30fc,0xff1d,0xff3b,0xff3d,0xff5c,0xffe3, // vertical f87e (34)
	0x2026,0xff47,0xff4d, // halfwidth f87f (3)
	0x5927,0x5c0f,0x63a7, // enclosing circle 20dd (3)
	0x21e6,0x21e7,0x21e8,0x21e9, // black arrow f87a (4)
};

static int s_form_tbl_len = sizeof(s_form_tbl)/sizeof(unsigned short);

static const unsigned short s_form_sjis_tbl[] = {
	0xeb5d,0xeb61,0xeb63,
	0xeb41,0xeb42,0xeb60,0xec9f,0xeca1,0xeca3,0xeca5,0xeca7,
	0xecc1,0xece1,0xece3,0xece5,0xecec,0xed40,0xed42,0xed44,
	0xed46,0xed48,0xed62,0xed83,0xed85,0xed87,0xed8e,0xed95,
	0xed96,0xeb5b,0xeb81,0xeb6d,0xeb6e,0xeb62,0xeb50, // vertical
	0x00ff,0x864b,0x8645, // halfwidth
	0x8791,0x8792,0x879d, // enclosing circle
	0x86d4,0x86d5,0x86d3,0x86d6, // black arrow
};

static const unsigned short s_form_sjis_fallback_tbl[] = {
	0x815d,0x8161,0x8163,
	0x8141,0x8142,0x8160,0x829f,0x82a1,0x82a3,0x82a5,0x82a7,
	0x82c1,0x82e1,0x82e3,0x82e5,0x82ec,0x8340,0x8342,0x8344,
	0x8346,0x8348,0x8362,0x8383,0x8385,0x8387,0x838e,0x8395,
	0x8396,0x815b,0x8181,0x816d,0x816e,0x8162,0x8150, // vertical
	0x815d,0x8287,0x828d, // halfwidth
	0x91e5,0x8fac,0x8d54, // enclosing circle
	0x86d0,0x86d1,0x86cf,0x86d2, // arrow
};

static const unsigned short wchar2sjis_mac_r_tbl[][3] = {
	{0x2160, 0x216b, 0x034e},
	{0x2170, 0x217b, 0x0362},
	{0x2460, 0x2473, 0x02f0},
	{0x2474, 0x2487, 0x030e},
	{0x2488, 0x2490, 0x0341},
	{0x249c, 0x24b5, 0x038a},
	{0x2776, 0x277e, 0x032c},
	{0x30f7, 0x30fa, 0x054e},
	{0x32a4, 0x32a9, 0x04ba},
};

static int wchar2sjis_mac_r_tbl_len = sizeof(wchar2sjis_mac_r_tbl)/(3*sizeof(unsigned short));

static const unsigned short wchar2sjis_mac_r_map[][2] = {
	{0x2660, 0x2667},
	{0x322a, 0x3243},
	{0x3296, 0x329e},
	{0x3300, 0x33d4},
	{0xfe30, 0xfe44},
};

static int wchar2sjis_mac_r_map_len = sizeof(wchar2sjis_mac_r_map)/(2*sizeof(unsigned short));

static const unsigned short *wchar2sjis_mac_code_map[] = {
	wchar2sjis_mac4, wchar2sjis_mac7, wchar2sjis_mac8, wchar2sjis_mac9, wchar2sjis_mac10};

static const unsigned short wchar2sjis_mac_wchar_tbl[][2] = {
	{0x2109, 0x03c2},
	{0x2113, 0x03bc},
	{0x2116, 0x0406},
	{0x2121, 0x0408},
	{0x21c4, 0x0437},
	{0x21c5, 0x0438},
	{0x21c6, 0x0436},
	{0x21e6, 0x043b},
	{0x21e7, 0x043c},
	{0x21e8, 0x043a},
	{0x21e9, 0x043d},
	{0x221f, 0x0525},
	{0x222e, 0x0524},
	{0x22bf, 0x0526},
	{0x260e, 0x041f},
	{0x261c, 0x0433},
	{0x261d, 0x0434},
	{0x261e, 0x0432},
	{0x261f, 0x0435},
	{0x3004, 0x0420},
	{0x301d, 0x0538},
	{0x301f, 0x0539},
	{0x3020, 0x041e},
	{0x3094, 0x054c},
};

static int wchar2sjis_mac_wchar_tbl_len = sizeof(wchar2sjis_mac_wchar_tbl)/(2*sizeof(unsigned short));
