/* Generated by re2c 0.13.5 on Wed Jul 20 17:56:59 2016 */
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015 Derick Rethans
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/* $Id$ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <assert.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_UNSET   -99999

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7
#define TIMELIB_SPECIAL 8

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, "Double timezone specification") : add_warning(s, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
const static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

const static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	if (str[0] == ':') {
		str[0] = '.';
	}
	tmp_nr = strtod(str, NULL);
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
           **ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

const static timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 60) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			if ((res = tz_wrapper(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;



{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 100,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		100,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0, 128,  64, 160,  96,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   0,   0,   0,   0,   0,   0, 
		  0,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   8,   8,   8,   8,   8, 
		  8,   8,   8,   0,   0,   0,   0,   0, 
		  0,  24,  24,  24,  88,  24,  24,  24, 
		 88,  24,  24,  24,  24,  24,  88,  24, 
		 24,  24,  88,  88,  88,  24,  24,  24, 
		 24,  24,  24,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};

	if ((YYLIMIT - YYCURSOR) < 31) YYFILL(31);
	yych = *YYCURSOR;
	switch (yych) {
	case 0x00:
	case '\n':	goto yy51;
	case '\t':
	case ' ':	goto yy48;
	case '(':	goto yy45;
	case '+':
	case '-':	goto yy30;
	case ',':
	case '.':	goto yy50;
	case '0':	goto yy25;
	case '1':	goto yy26;
	case '2':	goto yy27;
	case '3':	goto yy28;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy29;
	case '@':	goto yy11;
	case 'A':	goto yy36;
	case 'B':	goto yy17;
	case 'C':
	case 'H':
	case 'K':
	case 'Q':
	case 'R':
	case 'U':
	case 'Z':	goto yy46;
	case 'D':	goto yy40;
	case 'E':	goto yy21;
	case 'F':	goto yy13;
	case 'G':	goto yy44;
	case 'I':	goto yy31;
	case 'J':	goto yy34;
	case 'L':	goto yy15;
	case 'M':	goto yy7;
	case 'N':	goto yy5;
	case 'O':	goto yy38;
	case 'P':	goto yy23;
	case 'S':	goto yy19;
	case 'T':	goto yy9;
	case 'V':	goto yy32;
	case 'W':	goto yy42;
	case 'X':	goto yy33;
	case 'Y':	goto yy2;
	case 'a':	goto yy37;
	case 'b':	goto yy18;
	case 'c':
	case 'g':
	case 'h':
	case 'i':
	case 'k':
	case 'q':
	case 'r':
	case 'u':
	case 'v':
	case 'x':
	case 'z':	goto yy47;
	case 'd':	goto yy41;
	case 'e':	goto yy22;
	case 'f':	goto yy14;
	case 'j':	goto yy35;
	case 'l':	goto yy16;
	case 'm':	goto yy8;
	case 'n':	goto yy6;
	case 'o':	goto yy39;
	case 'p':	goto yy24;
	case 's':	goto yy20;
	case 't':	goto yy10;
	case 'w':	goto yy43;
	case 'y':	goto yy4;
	default:	goto yy53;
	}
yy2:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'E') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych >= 'a') goto yy145;
		} else {
			if (yych <= 'e') goto yy1532;
			if (yych <= 'z') goto yy145;
		}
	}
yy3:
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
yy4:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy1523;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy1523;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy5:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy140;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1510;
				goto yy145;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1511;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1509;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy6:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1494;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1495;
				if (yych <= 'N') goto yy140;
				goto yy1493;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'e') goto yy1494;
				goto yy140;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1495;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1493;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy7:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1478;
			goto yy145;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1479;
				goto yy145;
			} else {
				if (yych <= 'o') goto yy1480;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy8:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy1463;
		} else {
			if (yych == 'I') goto yy1464;
			if (yych <= 'N') goto yy140;
			goto yy1465;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1463;
			goto yy140;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy1464;
				goto yy140;
			} else {
				if (yych <= 'o') goto yy1465;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy9:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':	goto yy140;
	case 'E':	goto yy1388;
	case 'H':	goto yy1389;
	case 'O':	goto yy1390;
	case 'U':	goto yy1391;
	case 'W':	goto yy1392;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy145;
	case 'e':	goto yy1431;
	case 'h':	goto yy1432;
	case 'o':	goto yy1433;
	case 'u':	goto yy1434;
	case 'w':	goto yy1435;
	default:	goto yy3;
	}
yy10:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case ')':	goto yy139;
	case '0':
	case '1':	goto yy1393;
	case '2':	goto yy1394;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1395;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'F':
	case 'G':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'f':
	case 'g':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'x':
	case 'y':
	case 'z':	goto yy140;
	case 'E':
	case 'e':	goto yy1388;
	case 'H':
	case 'h':	goto yy1389;
	case 'O':
	case 'o':	goto yy1390;
	case 'U':
	case 'u':	goto yy1391;
	case 'W':
	case 'w':	goto yy1392;
	default:	goto yy3;
	}
yy11:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy1384;
	if (yych <= '/') goto yy12;
	if (yych <= '9') goto yy1385;
yy12:
	{
		add_error(s, "Unexpected character");
		goto std;
	}
yy13:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy140;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy145;
			} else {
				if (yych <= 'e') goto yy1361;
				if (yych <= 'h') goto yy145;
				goto yy1362;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1363;
				goto yy145;
			} else {
				if (yych <= 'r') goto yy1364;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy14:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'D') goto yy140;
				goto yy1320;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy1321;
				goto yy140;
			} else {
				if (yych <= 'O') goto yy1322;
				if (yych <= 'Q') goto yy140;
				goto yy1323;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy140;
				if (yych <= '`') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'e') goto yy1320;
				if (yych <= 'h') goto yy140;
				goto yy1321;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy1322;
				goto yy140;
			} else {
				if (yych <= 'r') goto yy1323;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy15:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1306;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1317;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy16:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1306;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1306;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy17:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1303;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy18:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1286;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy140;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1286;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy19:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy140;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1258;
				if (yych <= 'd') goto yy145;
				goto yy1257;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1259;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy1260;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy20:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'A') goto yy1229;
				goto yy140;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy1228;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy1230;
				if (yych <= 'T') goto yy140;
				goto yy1231;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych <= 'a') goto yy1229;
				if (yych <= 'd') goto yy140;
				goto yy1228;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1230;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy1231;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy21:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy140;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy145;
			goto yy1216;
		} else {
			if (yych == 'l') goto yy1217;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy22:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1198;
			if (yych <= 'K') goto yy140;
			goto yy1199;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy140;
			goto yy1198;
		} else {
			if (yych == 'l') goto yy1199;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy23:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1097;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'r') goto yy1191;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy24:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy140;
			goto yy1097;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'r') goto yy1097;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy25:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy1051;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'w':
	case 'y':	goto yy1053;
	case '-':	goto yy472;
	case '.':	goto yy1063;
	case '/':	goto yy471;
	case '0':	goto yy1096;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1095;
	case ':':	goto yy1064;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy26:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':	goto yy1095;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1062;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy27:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':	goto yy1062;
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy1049;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':	goto yy1049;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy468;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy29:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':	goto yy459;
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'S':
	case 'T':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'o':
	case 'p':
	case 'w':
	case 'y':	goto yy461;
	case '-':	goto yy472;
	case '.':	goto yy473;
	case '/':	goto yy471;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy468;
	case ':':	goto yy482;
	case 'n':	goto yy469;
	case 'r':	goto yy470;
	case 's':	goto yy463;
	case 't':	goto yy467;
	default:	goto yy12;
	}
yy30:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	switch (yych) {
	case '+':
	case '-':	goto yy439;
	case '0':
	case '1':	goto yy436;
	case '2':	goto yy437;
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy438;
	default:	goto yy12;
	}
yy31:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '/') goto yy3;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy3;
				goto yy140;
			} else {
				if (yych <= 'I') goto yy435;
				if (yych <= 'U') goto yy140;
				goto yy434;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy434;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy32:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy431;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy33:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy429;
				goto yy140;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy34:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy412;
			if (yych <= 'T') goto yy140;
			goto yy411;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy421;
		} else {
			if (yych == 'u') goto yy420;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy35:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'A') goto yy412;
			if (yych <= 'T') goto yy140;
			goto yy411;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy412;
		} else {
			if (yych == 'u') goto yy411;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy36:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy390;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy389;
				if (yych <= 'T') goto yy140;
				goto yy388;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy402;
				goto yy145;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy401;
				goto yy145;
			} else {
				if (yych <= 'u') goto yy400;
				if (yych <= 'z') goto yy145;
				goto yy3;
			}
		}
	}
yy37:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy390;
				goto yy140;
			} else {
				if (yych <= 'P') goto yy389;
				if (yych <= 'T') goto yy140;
				goto yy388;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy140;
				goto yy3;
			} else {
				if (yych == 'g') goto yy390;
				goto yy140;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy389;
				goto yy140;
			} else {
				if (yych <= 'u') goto yy388;
				if (yych <= 'z') goto yy140;
				goto yy3;
			}
		}
	}
yy38:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy378;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'c') goto yy383;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy39:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy140;
			goto yy378;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'c') goto yy378;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy40:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy369;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy41:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy191;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy191;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy42:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy145;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy43:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy140;
			goto yy164;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy140;
			if (yych <= '`') goto yy3;
			goto yy140;
		} else {
			if (yych <= 'e') goto yy164;
			if (yych <= 'z') goto yy140;
			goto yy3;
		}
	}
yy44:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy140;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy156;
			goto yy140;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy145;
			goto yy3;
		}
	}
yy45:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy12;
	if (yych <= 'Z') goto yy155;
	if (yych <= '`') goto yy12;
	if (yych <= 'z') goto yy155;
	goto yy12;
yy46:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy145;
		goto yy3;
	}
yy47:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy48:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy49;
	if (yych <= '9') goto yy54;
yy49:
	{
		goto std;
	}
yy50:
	yych = *++YYCURSOR;
	goto yy49;
yy51:
	++YYCURSOR;
	{
		s->pos = cursor; s->line++;
		goto std;
	}
yy53:
	yych = *++YYCURSOR;
	goto yy12;
yy54:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy61;
				goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy56:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept <= 0) {
							goto yy3;
						} else {
							goto yy12;
						}
					} else {
						goto yy49;
					}
				} else {
					if (yyaccept <= 3) {
						goto yy72;
					} else {
						goto yy166;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept <= 5) {
						goto yy193;
					} else {
						goto yy198;
					}
				} else {
					if (yyaccept <= 7) {
						goto yy222;
					} else {
						goto yy294;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept <= 9) {
						goto yy392;
					} else {
						goto yy475;
					}
				} else {
					if (yyaccept <= 11) {
						goto yy490;
					} else {
						goto yy611;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept <= 13) {
						goto yy656;
					} else {
						goto yy666;
					}
				} else {
					if (yyaccept <= 15) {
						goto yy763;
					} else {
						goto yy783;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept <= 17) {
							goto yy814;
						} else {
							goto yy821;
						}
					} else {
						goto yy848;
					}
				} else {
					if (yyaccept <= 20) {
						goto yy793;
					} else {
						goto yy454;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept <= 22) {
						goto yy973;
					} else {
						goto yy842;
					}
				} else {
					if (yyaccept <= 24) {
						goto yy1067;
					} else {
						goto yy1075;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept <= 26) {
						goto yy1117;
					} else {
						goto yy1141;
					}
				} else {
					if (yyaccept <= 28) {
						goto yy1294;
					} else {
						goto yy1417;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept <= 30) {
						goto yy1420;
					} else {
						goto yy1500;
					}
				} else {
					if (yyaccept <= 32) {
						goto yy1508;
					} else {
						goto yy1531;
					}
				}
			}
		}
	}
yy57:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy54;
	goto yy56;
yy59:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy60:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych <= 0x1F) goto yy56;
				goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych <= 'E') goto yy56;
				goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych <= 'L') goto yy56;
				goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy68;
					if (yych <= 'V') goto yy56;
					goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych <= 'c') goto yy56;
				goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy65;
				} else {
					if (yych == 'h') goto yy63;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy68;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy67;
				} else {
					if (yych == 'y') goto yy66;
					goto yy56;
				}
			}
		}
	}
yy61:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy127;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy127;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy62:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy117;
		if (yych <= 'N') goto yy56;
		goto yy116;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy117;
		} else {
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy63:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy114;
	if (yych == 'o') goto yy114;
	goto yy56;
yy64:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy113;
	if (yych == 'a') goto yy113;
	goto yy56;
yy65:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy98;
		if (yych <= 'Q') goto yy56;
		goto yy97;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy98;
		} else {
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy66:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy94;
	if (yych == 'e') goto yy94;
	goto yy56;
yy67:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy82;
	if (yych == 'e') goto yy82;
	goto yy56;
yy68:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy69:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy77;
	if (yych == 'u') goto yy77;
	goto yy56;
yy70:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy71;
	if (yych != 'e') goto yy56;
yy71:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy73;
	if (yych == 's') goto yy73;
yy72:
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy73:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy74;
	if (yych != 'd') goto yy56;
yy74:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy75;
	if (yych != 'a') goto yy56;
yy75:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych != 'y') goto yy56;
yy76:
	yych = *++YYCURSOR;
	goto yy72;
yy77:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy78;
	if (yych != 'r') goto yy72;
yy78:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy79;
	if (yych != 's') goto yy56;
yy79:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy80;
	if (yych != 'd') goto yy56;
yy80:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy81;
	if (yych != 'a') goto yy56;
yy81:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy82:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy84;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy84;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy90;
	if (yych == 'k') goto yy90;
	goto yy56;
yy84:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy85;
	if (yych != 'n') goto yy72;
yy85:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy86;
	if (yych != 'e') goto yy56;
yy86:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy87;
	if (yych != 's') goto yy56;
yy87:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy88;
	if (yych != 'd') goto yy56;
yy88:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy89;
	if (yych != 'a') goto yy56;
yy89:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy90:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy91;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy91:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy92;
	if (yych != 'a') goto yy56;
yy92:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy93;
	if (yych != 'y') goto yy56;
yy93:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy94:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy95;
	if (yych != 'a') goto yy56;
yy95:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych != 'r') goto yy56;
yy96:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy76;
	if (yych == 's') goto yy76;
	goto yy72;
yy97:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy110;
	if (yych == 'i') goto yy110;
	goto yy56;
yy98:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy99;
	if (yych != 'r') goto yy56;
yy99:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy100;
	if (yych != 't') goto yy56;
yy100:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy102;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy102;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy107;
	if (yych == 'i') goto yy107;
	goto yy56;
yy102:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy103;
	if (yych != 'n') goto yy56;
yy103:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy104;
	if (yych != 'i') goto yy56;
yy104:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy105;
	if (yych != 'g') goto yy56;
yy105:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy106;
	if (yych != 'h') goto yy56;
yy106:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy107:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy108;
	if (yych != 'g') goto yy56;
yy108:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy109;
	if (yych != 'h') goto yy56;
yy109:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy96;
	if (yych == 't') goto yy96;
	goto yy56;
yy110:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy111;
	if (yych != 'd') goto yy72;
yy111:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy112;
	if (yych != 'a') goto yy56;
yy112:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy113:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy96;
	if (yych == 'y') goto yy96;
	goto yy56;
yy114:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy115;
	if (yych != 'u') goto yy56;
yy115:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy96;
	if (yych == 'r') goto yy96;
	goto yy56;
yy116:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy121;
	if (yych == 'n') goto yy121;
	goto yy56;
yy117:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy118;
	if (yych != 'n') goto yy56;
yy118:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy76;
		if (yych <= 'T') goto yy72;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy72;
			goto yy76;
		} else {
			if (yych != 'u') goto yy72;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy120;
	if (yych != 't') goto yy56;
yy120:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy96;
	if (yych == 'e') goto yy96;
	goto yy56;
yy121:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy122;
		if (yych <= 'S') goto yy72;
		goto yy123;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy72;
		} else {
			if (yych == 't') goto yy123;
			goto yy72;
		}
	}
yy122:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy124;
	if (yych == 'a') goto yy124;
	goto yy56;
yy123:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy96;
	if (yych == 'h') goto yy96;
	goto yy56;
yy124:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy125:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy136;
	if (yych == 'n') goto yy136;
	goto yy56;
yy126:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy131;
	if (yych == 't') goto yy131;
	goto yy56;
yy127:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy128;
	if (yych != 'c') goto yy56;
yy128:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy129;
		if (yych <= 'R') goto yy72;
		goto yy76;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy72;
		} else {
			if (yych == 's') goto yy76;
			goto yy72;
		}
	}
yy129:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy130;
	if (yych != 'n') goto yy56;
yy130:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy96;
	if (yych == 'd') goto yy96;
	goto yy56;
yy131:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy132;
	if (yych != 'u') goto yy72;
yy132:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy133;
	if (yych != 'r') goto yy56;
yy133:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy134;
	if (yych != 'd') goto yy56;
yy134:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy135;
	if (yych != 'a') goto yy56;
yy135:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy136:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy137;
	if (yych != 'd') goto yy72;
yy137:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy138;
	if (yych != 'a') goto yy56;
yy138:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy76;
	if (yych == 'y') goto yy76;
	goto yy56;
yy139:
	yych = *++YYCURSOR;
	goto yy3;
yy140:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy141;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy141:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy142:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy143:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy3;
		if (yych >= '{') goto yy3;
	}
yy144:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy3;
yy145:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy141;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy146:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy147:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy56;
yy148:
	yyaccept = 0;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy3;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy3;
	}
yy150:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy151:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych >= '{') goto yy3;
		}
	}
yy152:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy3;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy3;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy153:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy154:
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy56;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy56;
	}
yy155:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Z') goto yy140;
		if (yych <= '`') goto yy3;
		if (yych <= 'z') goto yy140;
		goto yy3;
	}
yy156:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy141;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy141;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych != '+') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy158;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy158:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy159;
	if (yych <= '2') goto yy160;
	if (yych <= '9') goto yy161;
	goto yy56;
yy159:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy161;
	if (yych <= ':') goto yy162;
	goto yy3;
yy160:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy3;
		if (yych >= '5') goto yy163;
	} else {
		if (yych <= '9') goto yy139;
		if (yych <= ':') goto yy162;
		goto yy3;
	}
yy161:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	if (yych >= ';') goto yy3;
yy162:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '5') goto yy163;
	if (yych <= '9') goto yy139;
	goto yy3;
yy163:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy139;
	goto yy3;
yy164:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'C') goto yy141;
			if (yych >= 'E') goto yy167;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy165;
			if (yych <= 'e') goto yy167;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy165:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'N') {
		if (yych <= ')') {
			if (yych >= ')') goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'M') goto yy142;
			goto yy173;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych >= 'a') goto yy142;
		} else {
			if (yych <= 'n') goto yy173;
			if (yych <= 'z') goto yy142;
		}
	}
yy166:
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
yy167:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy168;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy168:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy169;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy169:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy170;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy170:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy171;
		if (yych != 'y') goto yy3;
	}
yy171:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy172;
	if (yych != 's') goto yy166;
yy172:
	yych = *++YYCURSOR;
	goto yy166;
yy173:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy174;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy174:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy144;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 's') goto yy175;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy175:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy176;
		if (yych != 'd') goto yy3;
	}
yy176:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy56;
yy177:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy178:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'C') goto yy141;
				goto yy165;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy167;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy146;
			} else {
				if (yych <= 'e') goto yy180;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy173;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy186;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy180:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy168;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy181;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy181:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy169;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy182;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy182:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy170;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy183;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy183:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy171;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy184;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy184:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy166;
		} else {
			if (yych <= '/') goto yy147;
			if (yych <= 'R') goto yy166;
			goto yy172;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy147;
			goto yy166;
		} else {
			if (yych == 's') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy166;
		}
	}
yy185:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy166;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy166;
	}
yy186:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy174;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy187;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy187:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy175;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 's') goto yy188;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy188:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy176;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy189;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy189:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy177;
	if (yych != 'a') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy191:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy192;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy192:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy195;
			} else {
				if (yych == ' ') goto yy195;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
			} else {
				if (yych == 'E') goto yy201;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych >= 'a') goto yy142;
			} else {
				if (yych <= 'e') goto yy201;
				if (yych <= 'z') goto yy142;
			}
		}
	}
yy193:
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy194:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 21) YYFILL(21);
	yych = *YYCURSOR;
yy195:
	if (yybm[0+yych] & 32) {
		goto yy194;
	}
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy197;
	if (yych <= '3') goto yy199;
	if (yych <= '9') goto yy200;
	goto yy56;
yy196:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy356;
	if (yych <= '2') goto yy357;
	if (yych <= '3') goto yy358;
	goto yy195;
yy197:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy297;
			goto yy298;
		} else {
			if (yych <= '2') goto yy354;
			if (yych <= '9') goto yy355;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy198:
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy199:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy297;
			goto yy298;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy200:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy206;
			goto yy207;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy201:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy202;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy202:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy203;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy203:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy204;
		if (yych != 'e') goto yy3;
	}
yy204:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych != 'r') goto yy56;
yy205:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy195;
		if (yych <= 0x1F) goto yy193;
		goto yy195;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy206:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '0') goto yy295;
		if (yych <= '9') goto yy296;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy207:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '2') goto yy296;
		if (yych <= '9') goto yy295;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy208:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '4') goto yy295;
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy209:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '9') goto yy292;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy210:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy211:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy212:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy213:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	goto yy215;
yy214:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy215:
	if (yybm[0+yych] & 64) {
		goto yy214;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy198;
		if (yych <= '0') goto yy258;
		if (yych <= '1') goto yy259;
		goto yy260;
	} else {
		if (yych <= '9') goto yy261;
		if (yych != 'T') goto yy198;
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy217;
	if (yych <= '2') goto yy218;
	if (yych <= '9') goto yy219;
	goto yy56;
yy217:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '9') goto yy219;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy218:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '4') goto yy219;
		if (yych == ':') goto yy220;
		goto yy56;
	}
yy219:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy220;
	if (yych != ':') goto yy56;
yy220:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy221;
	if (yych <= '9') goto yy223;
	goto yy56;
yy221:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
	} else {
		if (yych <= '9') goto yy223;
		if (yych <= ':') goto yy224;
	}
yy222:
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy223:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy224;
	if (yych != ':') goto yy222;
yy224:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy225;
	if (yych <= '6') goto yy226;
	if (yych <= '9') goto yy227;
	goto yy56;
yy225:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy228;
	goto yy222;
yy226:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy228;
	goto yy222;
yy227:
	yych = *++YYCURSOR;
	goto yy222;
yy228:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy230;
			goto yy222;
		} else {
			if (yych <= ' ') goto yy230;
			if (yych == '(') goto yy230;
			goto yy222;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy222;
			if (yych <= '-') goto yy230;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy230;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy230;
			goto yy222;
		}
	}
yy229:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy230:
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy229;
			if (yych <= 0x1F) goto yy56;
			goto yy229;
		} else {
			if (yych == '(') goto yy233;
			if (yych <= '*') goto yy56;
			goto yy232;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy232;
			if (yych <= '@') goto yy56;
			goto yy234;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'H') goto yy234;
			} else {
				if (yych <= '`') goto yy56;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy231:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy227;
		if (yych <= '@') goto yy222;
		goto yy236;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy256;
			goto yy236;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy232:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy251;
	if (yych <= '2') goto yy252;
	if (yych <= '9') goto yy253;
	goto yy56;
yy233:
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy235;
	if (yych <= '`') goto yy56;
	if (yych <= 'z') goto yy235;
	goto yy56;
yy234:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy236;
		if (yych <= '`') goto yy222;
		if (yych <= 'z') goto yy241;
		goto yy222;
	}
yy235:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy236;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy236:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy237;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy237:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy238;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy238:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy239;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy239:
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy227;
		goto yy222;
	} else {
		if (yych <= 'Z') goto yy240;
		if (yych <= '`') goto yy222;
		if (yych >= '{') goto yy222;
	}
yy240:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy227;
	goto yy222;
yy241:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy237;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
yy242:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy238;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy246;
			goto yy222;
		}
	}
yy243:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy56;
	if (yych <= 'Z') goto yy244;
	if (yych <= '`') goto yy56;
	if (yych >= '{') goto yy56;
yy244:
	yyaccept = 7;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy222;
			goto yy243;
		} else {
			if (yych == '/') goto yy243;
			goto yy222;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy244;
			if (yych <= '^') goto yy222;
			goto yy243;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy244;
			goto yy222;
		}
	}
yy246:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy239;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych == '.') goto yy222;
			goto yy243;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy222;
			if (yych <= 'Z') goto yy240;
			goto yy222;
		} else {
			if (yych <= '_') goto yy243;
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy222;
			goto yy227;
		} else {
			if (yych == '-') goto yy243;
			goto yy222;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy243;
			if (yych <= '^') goto yy222;
			goto yy243;
		} else {
			if (yych <= '`') goto yy222;
			if (yych >= '{') goto yy222;
		}
	}
yy249:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy243;
		if (yych <= '.') goto yy56;
		goto yy243;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy56;
			goto yy243;
		} else {
			if (yych <= '`') goto yy56;
			if (yych <= 'z') goto yy249;
			goto yy56;
		}
	}
yy251:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy253;
	if (yych <= ':') goto yy254;
	goto yy222;
yy252:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy222;
		if (yych >= '5') goto yy255;
	} else {
		if (yych <= '9') goto yy227;
		if (yych <= ':') goto yy254;
		goto yy222;
	}
yy253:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '5') goto yy255;
	if (yych <= '9') goto yy227;
	if (yych >= ';') goto yy222;
yy254:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '5') goto yy255;
	if (yych <= '9') goto yy227;
	goto yy222;
yy255:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy227;
	goto yy222;
yy256:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy227;
		if (yych <= '@') goto yy222;
		goto yy237;
	} else {
		if (yych <= 'Z') {
			if (yych >= 'U') goto yy237;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy222;
			goto yy227;
		} else {
			if (yych == '+') goto yy232;
			goto yy222;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy232;
			if (yych <= '@') goto yy222;
			goto yy238;
		} else {
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy238;
			goto yy222;
		}
	}
yy258:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy198;
	} else {
		if (yych <= '0') goto yy290;
		if (yych <= '9') goto yy291;
		if (yych <= ':') goto yy220;
		goto yy198;
	}
yy259:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '2') goto yy291;
		if (yych <= '9') goto yy290;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy260:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '4') goto yy290;
		if (yych <= '9') goto yy262;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy261:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy262:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy198;
	if (yych <= '9') goto yy288;
	goto yy198;
yy263:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy264;
	if (yych <= '9') goto yy265;
	goto yy56;
yy264:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy281;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy265:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy266;
	if (yych != ':') goto yy222;
yy266:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy267;
	if (yych <= '6') goto yy268;
	if (yych <= '9') goto yy227;
	goto yy56;
yy267:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy222;
	if (yych <= '9') goto yy269;
	goto yy222;
yy268:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy222;
yy269:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy271;
			goto yy222;
		} else {
			if (yych <= ' ') goto yy271;
			if (yych == '(') goto yy271;
			goto yy222;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy222;
			if (yych <= '-') goto yy271;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy271;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy271;
			goto yy222;
		}
	}
yy270:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy271:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy270;
			} else {
				if (yych == ' ') goto yy270;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy272;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy273;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy273;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy272:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy274;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy275;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy280;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy273:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy274;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy275;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy275;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy274:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy279;
	if (yych == 'm') goto yy279;
	goto yy56;
yy275:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych != '.') goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy276:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy277:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
yy279:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych == '.') goto yy276;
		goto yy56;
	}
yy280:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy276;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy281:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy222;
		} else {
			if (yych == '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy222;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy222;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy222;
			}
		}
	}
yy282:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy282;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy282;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy284;
			if (yych != 'p') goto yy56;
		}
	}
yy284:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy286;
		if (yych == 'm') goto yy286;
		goto yy56;
	}
yy285:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy286;
	if (yych != 'm') goto yy56;
yy286:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych != '.') goto yy56;
	}
yy287:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
		goto yy277;
	} else {
		if (yych == ' ') goto yy277;
		goto yy56;
	}
yy288:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy198;
	if (yych >= ':') goto yy198;
	yych = *++YYCURSOR;
	goto yy198;
yy290:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy220;
		goto yy198;
	}
yy291:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy263;
		goto yy198;
	}
yy292:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy293:
	++YYCURSOR;
yy294:
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy295:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy296:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy297:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy330;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy220;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy298:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych != '.') goto yy215;
		} else {
			if (yych <= '0') goto yy300;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy299:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy215;
		if (yych <= '0') goto yy305;
		goto yy306;
	} else {
		if (yych <= '2') goto yy307;
		if (yych <= '5') goto yy308;
		if (yych <= '9') goto yy309;
		goto yy215;
	}
yy300:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '0') goto yy303;
		if (yych <= '9') goto yy304;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy301:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '2') goto yy304;
		if (yych <= '9') goto yy303;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy302:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy263;
		goto yy56;
	} else {
		if (yych <= '4') goto yy303;
		if (yych <= '9') goto yy293;
		if (yych <= ':') goto yy263;
		goto yy56;
	}
yy303:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy220;
	if (yych == ':') goto yy220;
	goto yy294;
yy304:
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy263;
	if (yych == ':') goto yy263;
	goto yy294;
yy305:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy325;
		goto yy198;
	} else {
		if (yych <= '0') goto yy324;
		if (yych <= '9') goto yy329;
		if (yych <= ':') goto yy325;
		goto yy198;
	}
yy306:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '2') goto yy329;
		if (yych <= '9') goto yy324;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy307:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '4') goto yy324;
		if (yych <= '9') goto yy323;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy308:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy310;
		goto yy198;
	} else {
		if (yych <= '9') goto yy323;
		if (yych <= ':') goto yy310;
		goto yy198;
	}
yy309:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych >= ';') goto yy198;
	}
yy310:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy311;
	if (yych <= '6') goto yy312;
	if (yych <= '9') goto yy265;
	goto yy56;
yy311:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy313;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy312:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '0') goto yy269;
		if (yych == ':') goto yy266;
		goto yy222;
	}
yy313:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy315;
			if (yych <= 0x1F) goto yy222;
			goto yy315;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy315;
			} else {
				if (yych == '+') goto yy315;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy315;
			if (yych <= '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy315;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy315;
				goto yy222;
			}
		}
	}
yy314:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy315:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy314;
			} else {
				if (yych == ' ') goto yy314;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy316;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy317;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy317;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy316:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy319;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy318;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy322;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy317:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy319;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy318;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy318;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy318:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy321;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy319:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy320;
	if (yych != 'm') goto yy56;
yy320:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy277;
		if (yych == '\t') goto yy277;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy277;
		if (yych != '.') goto yy56;
	}
yy321:
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy277;
		if (yych <= 0x08) goto yy56;
		goto yy277;
	} else {
		if (yych == ' ') goto yy277;
		goto yy56;
	}
yy322:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy321;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy323:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
				goto yy266;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
				goto yy266;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy324:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy325:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy326;
	if (yych <= '6') goto yy327;
	if (yych <= '9') goto yy223;
	goto yy56;
yy326:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '9') goto yy328;
		if (yych <= ':') goto yy224;
		goto yy222;
	}
yy327:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '0') goto yy269;
		if (yych == ':') goto yy224;
		goto yy222;
	}
yy328:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy271;
			if (yych <= 0x1F) goto yy222;
			goto yy271;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy271;
			} else {
				if (yych == '+') goto yy271;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy271;
			if (yych <= '.') goto yy224;
			if (yych <= '9') goto yy222;
			goto yy224;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy271;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy271;
				goto yy222;
			}
		}
	}
yy329:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy282;
			if (yych <= 0x1F) goto yy198;
			goto yy282;
		} else {
			if (yych <= '.') {
				if (yych <= '-') goto yy198;
				goto yy310;
			} else {
				if (yych <= '/') goto yy198;
				if (yych <= '9') goto yy288;
				goto yy310;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy284;
			if (yych <= 'O') goto yy198;
			goto yy284;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy198;
				goto yy284;
			} else {
				if (yych == 'p') goto yy284;
				goto yy198;
			}
		}
	}
yy330:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych <= '/') goto yy215;
		if (yych <= '0') goto yy332;
		goto yy333;
	} else {
		if (yych <= '2') goto yy334;
		if (yych <= '5') goto yy335;
		if (yych <= '9') goto yy336;
		goto yy215;
	}
yy331:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy220;
		goto yy56;
	} else {
		if (yych <= '0') goto yy303;
		if (yych <= '9') goto yy304;
		if (yych <= ':') goto yy220;
		goto yy56;
	}
yy332:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy349;
		goto yy198;
	} else {
		if (yych <= '0') goto yy348;
		if (yych <= '9') goto yy353;
		if (yych <= ':') goto yy349;
		goto yy198;
	}
yy333:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '2') goto yy353;
		if (yych <= '9') goto yy348;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy334:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '4') goto yy348;
		if (yych <= '9') goto yy347;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy335:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '9') goto yy347;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy336:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy262;
		if (yych >= ';') goto yy198;
	}
yy337:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy338;
	if (yych <= '6') goto yy339;
	if (yych <= '9') goto yy265;
	goto yy56;
yy338:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '9') goto yy340;
		if (yych <= ':') goto yy266;
		goto yy222;
	}
yy339:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy266;
		goto yy222;
	} else {
		if (yych <= '0') goto yy228;
		if (yych == ':') goto yy266;
		goto yy222;
	}
yy340:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy342;
			if (yych <= 0x1F) goto yy222;
			goto yy342;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy342;
			} else {
				if (yych == '+') goto yy342;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy342;
			if (yych <= '.') goto yy266;
			if (yych <= '9') goto yy222;
			goto yy266;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy342;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy342;
				goto yy222;
			}
		}
	}
yy341:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy342:
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy56;
				goto yy341;
			} else {
				if (yych == ' ') goto yy341;
				goto yy56;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy233;
				if (yych <= '*') goto yy56;
				goto yy232;
			} else {
				if (yych == '-') goto yy232;
				goto yy56;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy343;
				if (yych <= 'F') goto yy234;
				goto yy231;
			} else {
				if (yych != 'P') goto yy234;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy56;
				if (yych <= 'a') goto yy344;
				goto yy235;
			} else {
				if (yych <= 'p') goto yy344;
				if (yych <= 'z') goto yy235;
				goto yy56;
			}
		}
	}
yy343:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy285;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy345;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy346;
			if (yych <= 'z') goto yy241;
			goto yy222;
		}
	}
yy344:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy227;
			goto yy222;
		} else {
			if (yych <= '.') goto yy285;
			if (yych <= '@') goto yy222;
			goto yy236;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy345;
			if (yych <= 'Z') goto yy236;
			goto yy222;
		} else {
			if (yych == 'm') goto yy345;
			if (yych <= 'z') goto yy236;
			goto yy222;
		}
	}
yy345:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy277;
			if (yych <= 0x08) goto yy222;
			goto yy277;
		} else {
			if (yych == ' ') goto yy277;
			if (yych <= '(') goto yy222;
			goto yy227;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy287;
			goto yy222;
		} else {
			if (yych <= 'Z') goto yy237;
			if (yych <= '`') goto yy222;
			if (yych <= 'z') goto yy237;
			goto yy222;
		}
	}
yy346:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy277;
			if (yych == '\t') goto yy277;
			goto yy222;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy277;
				goto yy222;
			} else {
				if (yych <= ')') goto yy227;
				if (yych <= ',') goto yy222;
				goto yy243;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy287;
			if (yych <= '/') goto yy243;
			if (yych <= '@') goto yy222;
			goto yy237;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy222;
				goto yy243;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy242;
				goto yy222;
			}
		}
	}
yy347:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy224;
		goto yy198;
	}
yy348:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych >= ';') goto yy198;
	}
yy349:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy350;
	if (yych <= '6') goto yy351;
	if (yych <= '9') goto yy223;
	goto yy56;
yy350:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '9') goto yy352;
		if (yych <= ':') goto yy224;
		goto yy222;
	}
yy351:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy224;
		goto yy222;
	} else {
		if (yych <= '0') goto yy228;
		if (yych == ':') goto yy224;
		goto yy222;
	}
yy352:
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy230;
			if (yych <= 0x1F) goto yy222;
			goto yy230;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy222;
				goto yy230;
			} else {
				if (yych == '+') goto yy230;
				goto yy222;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy230;
			if (yych <= '.') goto yy224;
			if (yych <= '9') goto yy222;
			goto yy224;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy222;
				goto yy230;
			} else {
				if (yych <= '`') goto yy222;
				if (yych <= 'z') goto yy230;
				goto yy222;
			}
		}
	}
yy353:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy337;
		goto yy198;
	} else {
		if (yych <= '9') goto yy288;
		if (yych <= ':') goto yy337;
		goto yy198;
	}
yy354:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy355:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych == '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy356:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy359;
			goto yy360;
		} else {
			if (yych <= '2') goto yy367;
			if (yych <= '9') goto yy368;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy357:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych <= '0') goto yy359;
			goto yy360;
		} else {
			if (yych <= '2') goto yy367;
			if (yych <= '9') goto yy368;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy358:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy215;
			if (yych >= '1') goto yy360;
		} else {
			if (yych <= '2') goto yy208;
			if (yych <= '9') goto yy209;
			goto yy215;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy211;
			if (yych <= 'q') goto yy215;
			goto yy212;
		} else {
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy359:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy330;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy220;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy360:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy300;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy361:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy363;
	if (yych <= '9') goto yy364;
yy363:
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy364:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy363;
	if (yych >= ':') goto yy363;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy363;
	if (yych >= ':') goto yy363;
	yych = *++YYCURSOR;
	goto yy363;
yy367:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy368:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '/') {
			if (yych <= ',') goto yy215;
			if (yych <= '-') goto yy361;
			if (yych <= '.') goto yy299;
			goto yy215;
		} else {
			if (yych <= '0') goto yy331;
			if (yych <= '1') goto yy301;
			if (yych <= '2') goto yy302;
			goto yy296;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy263;
			if (yych == 'n') goto yy211;
			goto yy215;
		} else {
			if (yych <= 'r') goto yy212;
			if (yych <= 's') goto yy210;
			if (yych <= 't') goto yy213;
			goto yy215;
		}
	}
yy369:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy192;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy370;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy370:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy201;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy372;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy371:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	if (yych <= '/') goto yy195;
	if (yych <= '0') goto yy356;
	if (yych <= '2') goto yy357;
	if (yych <= '3') goto yy358;
	goto yy195;
yy372:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy202;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy373;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy374;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy375;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy375:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych != 'r') goto yy154;
yy376:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych <= ',') goto yy193;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy147;
			goto yy195;
		} else {
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy377:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy148;
	}
	goto yy195;
yy378:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy379;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy379:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'O') goto yy142;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'o') goto yy380;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy380:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy143;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'b') goto yy381;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy381:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy144;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'e') goto yy382;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy382:
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy205;
		if (yych == 'r') goto yy205;
		goto yy3;
	}
yy383:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy379;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy384;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy384:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'O') goto yy380;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy385;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy385:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy381;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'b') goto yy386;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy386:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy382;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'e') goto yy387;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy387:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy376;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy388:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy396;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy396;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy389:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy141;
			goto yy393;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'r') goto yy393;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy390:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'o') goto yy391;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy391:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy392;
		if (yych <= 'z') goto yy142;
	}
yy392:
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
yy393:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'I') goto yy142;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'i') goto yy394;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy394:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy143;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'l') goto yy395;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy395:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy144;
			goto yy193;
		}
	}
yy396:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy397;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy397:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy398;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy398:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy399;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy399:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy193;
			goto yy195;
		} else {
			if (yych == ' ') goto yy195;
			goto yy193;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy195;
		} else {
			if (yych <= '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		}
	}
yy400:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy396;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy407;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy401:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy393;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy404;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy402:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy391;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy403;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy403:
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy392;
		} else {
			if (yych == '.') goto yy392;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy392;
			if (yych <= 'Z') goto yy142;
			goto yy392;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy392;
			if (yych <= 'z') goto yy150;
			goto yy392;
		}
	}
yy404:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'I') goto yy394;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'i') goto yy405;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy405:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy395;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'l') goto yy406;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy406:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy377;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy152;
				goto yy193;
			}
		}
	}
yy407:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy397;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy408;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy408:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy398;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy409;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy409:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy399;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy410;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy410:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy377;
			if (yych <= '.') goto yy195;
			goto yy147;
		} else {
			if (yych <= '9') goto yy195;
			if (yych == '_') goto yy147;
			goto yy193;
		}
	}
yy411:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'L') goto yy418;
			if (yych <= 'M') goto yy141;
			goto yy417;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'k') goto yy141;
			goto yy418;
		} else {
			if (yych == 'n') goto yy417;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy412:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy413;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy413:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'U') goto yy142;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'u') goto yy414;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy414:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy415;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy415:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy416;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy416:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy205;
		if (yych == 'y') goto yy205;
		goto yy3;
	}
yy417:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'E') goto yy419;
				goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy419;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy418:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'Y') goto yy142;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'y') goto yy419;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy419:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy193;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy193;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy143;
			goto yy193;
		}
	}
yy420:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'L') goto yy418;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy417;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy427;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy426;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy421:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy413;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy422;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy422:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'U') goto yy414;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy423;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy423:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy415;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy424;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy424:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy416;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy425;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy376;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy426:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy419;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy428;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy427:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'Y') goto yy419;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'y') goto yy428;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy428:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy377;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy429:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy430:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'Z') {
				if (yych >= 'J') goto yy142;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy142;
				goto yy3;
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy195;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy195;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy3;
			if (yych <= '9') goto yy195;
			goto yy3;
		} else {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy435:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy3;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy195;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy3;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy430;
				goto yy141;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy436:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy3;
					goto yy456;
				} else {
					if (yych <= ':') goto yy162;
					if (yych <= 'C') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy437:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '4') {
					if (yych <= '/') goto yy3;
					goto yy456;
				} else {
					if (yych <= '5') goto yy441;
					if (yych <= '9') goto yy442;
					goto yy162;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy3;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy3;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy438:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
					goto yy441;
				} else {
					if (yych <= '9') goto yy442;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy439:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy57;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy439;
		goto yy56;
	} else {
		if (yych <= '-') goto yy439;
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy54;
		goto yy56;
	}
yy441:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy455;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy442:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy443;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy443:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
yy444:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych != '-') goto yy60;
yy445:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy446;
	if (yych <= '1') goto yy447;
	goto yy56;
yy446:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy448;
	goto yy56;
yy447:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy448:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy450;
	if (yych <= '2') goto yy451;
	if (yych <= '3') goto yy452;
	goto yy56;
yy450:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy453;
	goto yy56;
yy451:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy453;
	goto yy56;
yy452:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy453:
	++YYCURSOR;
yy454:
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy455:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy444;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy3;
				} else {
					if (yych <= '9') goto yy455;
					if (yych <= ':') goto yy162;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy3;
				if (yych <= 'F') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy3;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy3;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy3;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy3;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy3;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych <= '/') goto yy3;
				if (yych <= '9') goto yy458;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy458:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy3;
				goto yy60;
			} else {
				if (yych == '-') goto yy445;
				if (yych <= 'C') goto yy3;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy3;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'T') goto yy60;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy3;
				if (yych <= 'Y') goto yy60;
				goto yy3;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy3;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy3;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy3;
				}
			}
		}
	}
yy459:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy461;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy461;
yy460:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy461:
	switch (yych) {
	case '\t':
	case ' ':	goto yy460;
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy479;
	case 'D':
	case 'd':	goto yy465;
	case 'F':
	case 'f':	goto yy466;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy464;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'P':
	case 'p':	goto yy483;
	case 'S':
	case 's':	goto yy462;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy476;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy477;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy462:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1048;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1048;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy463:
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1048;
			if (yych == 'U') goto yy125;
			goto yy56;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy126;
			if (yych <= 'd') goto yy56;
			goto yy1048;
		} else {
			if (yych <= 's') goto yy56;
			if (yych <= 't') goto yy728;
			if (yych <= 'u') goto yy125;
			goto yy56;
		}
	}
yy464:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy591;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy591;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy465:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy578;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy578;
			goto yy56;
		}
	}
yy466:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy594;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy594;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy467:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy69;
		if (yych <= 'T') goto yy56;
		goto yy70;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1047;
		} else {
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy468:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy741;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy740;
	goto yy60;
yy469:
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy529;
		goto yy56;
	} else {
		if (yych <= 'd') goto yy728;
		if (yych == 'o') goto yy529;
		goto yy56;
	}
yy470:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy728;
	goto yy56;
yy471:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':
	case '1':
	case '2':	goto yy665;
	case '3':	goto yy667;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy668;
	case 'A':
	case 'a':	goto yy672;
	case 'D':
	case 'd':	goto yy676;
	case 'F':
	case 'f':	goto yy670;
	case 'J':
	case 'j':	goto yy669;
	case 'M':
	case 'm':	goto yy671;
	case 'N':
	case 'n':	goto yy675;
	case 'O':
	case 'o':	goto yy674;
	case 'S':
	case 's':	goto yy673;
	default:	goto yy56;
	}
yy472:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy615;
	case '1':	goto yy616;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy617;
	case 'A':
	case 'a':	goto yy621;
	case 'D':
	case 'd':	goto yy625;
	case 'F':
	case 'f':	goto yy619;
	case 'J':
	case 'j':	goto yy618;
	case 'M':
	case 'm':	goto yy620;
	case 'N':
	case 'n':	goto yy624;
	case 'O':
	case 'o':	goto yy623;
	case 'S':
	case 's':	goto yy622;
	default:	goto yy577;
	}
yy473:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy577;
		if (yych <= '0') goto yy567;
		goto yy568;
	} else {
		if (yych <= '5') goto yy569;
		if (yych <= '9') goto yy570;
		goto yy577;
	}
yy474:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '.') goto yy531;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy533;
			if (yych == 'I') goto yy566;
		} else {
			if (yych == 'W') goto yy475;
			if (yych <= 'X') goto yy539;
		}
	}
yy475:
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
yy476:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy564;
			goto yy475;
		}
	}
yy477:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy563;
			goto yy475;
		}
	}
yy478:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy556;
		if (yych <= 'T') goto yy56;
		goto yy555;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy556;
		} else {
			if (yych == 'u') goto yy555;
			goto yy56;
		}
	}
yy479:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy484;
			goto yy56;
		} else {
			if (yych <= 'M') goto yy485;
			if (yych == 'P') goto yy549;
			goto yy56;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy548;
			if (yych == 'm') goto yy485;
			goto yy56;
		} else {
			if (yych <= 'p') goto yy549;
			if (yych == 'u') goto yy548;
			goto yy56;
		}
	}
yy480:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy543;
	if (yych == 'c') goto yy543;
	goto yy56;
yy481:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy529;
	if (yych == 'o') goto yy529;
	goto yy56;
yy482:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy489;
	if (yych <= '9') goto yy491;
	goto yy56;
yy483:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy485;
		if (yych == 'm') goto yy485;
		goto yy56;
	}
yy484:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy485;
	if (yych != 'm') goto yy56;
yy485:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy487:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
yy489:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy492;
	} else {
		if (yych <= '9') goto yy506;
		if (yych <= ':') goto yy492;
	}
yy490:
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy491:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy492;
	if (yych != ':') goto yy490;
yy492:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy493;
	if (yych <= '6') goto yy494;
	if (yych <= '9') goto yy495;
	goto yy56;
yy493:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy499;
	goto yy490;
yy494:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych == '0') goto yy499;
	goto yy490;
yy495:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy490;
yy496:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy497:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy497;
	goto yy490;
yy499:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy490;
		} else {
			if (yych <= ' ') goto yy500;
			if (yych == '.') goto yy496;
			goto yy490;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy502;
			if (yych == 'P') goto yy502;
			goto yy490;
		} else {
			if (yych <= 'a') goto yy502;
			if (yych == 'p') goto yy502;
			goto yy490;
		}
	}
yy500:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy500;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy500;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy502;
			if (yych != 'p') goto yy56;
		}
	}
yy502:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy504;
		if (yych == 'm') goto yy504;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy504;
	if (yych != 'm') goto yy56;
yy504:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
		goto yy487;
	} else {
		if (yych == ' ') goto yy487;
		goto yy56;
	}
yy506:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
		} else {
			if (yych == '.') goto yy492;
			if (yych <= '9') goto yy490;
			goto yy510;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy507:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy507;
			goto yy56;
		} else {
			if (yych <= ' ') goto yy507;
			if (yych <= '@') goto yy56;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy56;
		} else {
			if (yych <= 'a') goto yy509;
			if (yych != 'p') goto yy56;
		}
	}
yy509:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy526;
		goto yy56;
	} else {
		if (yych <= 'M') goto yy527;
		if (yych == 'm') goto yy527;
		goto yy56;
	}
yy510:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy511;
	if (yych <= '6') goto yy512;
	if (yych <= '9') goto yy495;
	goto yy56;
yy511:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy513;
	goto yy490;
yy512:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych != '0') goto yy490;
yy513:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy500;
			if (yych <= 0x1F) goto yy490;
			goto yy500;
		} else {
			if (yych == '.') goto yy514;
			if (yych <= '9') goto yy490;
			goto yy515;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy502;
			if (yych <= 'O') goto yy490;
			goto yy502;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy502;
			} else {
				if (yych == 'p') goto yy502;
				goto yy490;
			}
		}
	}
yy514:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy524;
	goto yy56;
yy515:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy516:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy56;
			goto yy516;
		} else {
			if (yych != 'A') goto yy56;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy518;
			if (yych <= '`') goto yy56;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy518:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy520;
		if (yych == 'm') goto yy520;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy520;
	if (yych != 'm') goto yy56;
yy520:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy522;
		if (yych == '\t') goto yy522;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy522;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy522;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy522:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
yy524:
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy490;
			goto yy524;
		} else {
			if (yych == 'A') goto yy518;
			goto yy490;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy518;
			if (yych <= '`') goto yy490;
			goto yy518;
		} else {
			if (yych == 'p') goto yy518;
			goto yy490;
		}
	}
yy526:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy527;
	if (yych != 'm') goto yy56;
yy527:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy487;
		if (yych == '\t') goto yy487;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy487;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy487;
		if (yych <= 0x08) goto yy56;
		goto yy487;
	} else {
		if (yych == ' ') goto yy487;
		goto yy56;
	}
yy529:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy530;
	if (yych != 'v') goto yy56;
yy530:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych != '\t') goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy535;
			if (yych == 'e') goto yy535;
			goto yy475;
		}
	}
yy531:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
yy532:
	if (yych <= ' ') {
		if (yych == '\t') goto yy531;
		if (yych <= 0x1F) goto yy56;
		goto yy531;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy56;
			goto yy531;
		} else {
			if (yych <= '/') goto yy56;
			if (yych >= ':') goto yy56;
		}
	}
yy533:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy534;
	if (yych <= '9') goto yy540;
yy534:
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
yy535:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy536;
	if (yych != 'm') goto yy56;
yy536:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy537;
	if (yych != 'b') goto yy56;
yy537:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy538;
	if (yych != 'e') goto yy56;
yy538:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych != 'r') goto yy56;
yy539:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy531;
		if (yych <= 0x1F) goto yy475;
		goto yy531;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy475;
			goto yy531;
		} else {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		}
	}
yy540:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych >= ':') goto yy534;
yy541:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych >= ':') goto yy534;
	yych = *++YYCURSOR;
	goto yy534;
yy543:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy544;
	if (yych != 't') goto yy56;
yy544:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'O') goto yy545;
			if (yych != 'o') goto yy475;
		}
	}
yy545:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy546;
	if (yych != 'b') goto yy56;
yy546:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy547;
	if (yych != 'e') goto yy56;
yy547:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy548:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy552;
	if (yych == 'g') goto yy552;
	goto yy56;
yy549:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy550;
	if (yych != 'r') goto yy56;
yy550:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'I') goto yy551;
			if (yych != 'i') goto yy475;
		}
	}
yy551:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy539;
	if (yych == 'l') goto yy539;
	goto yy56;
yy552:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy553;
			if (yych != 'u') goto yy475;
		}
	}
yy553:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy554;
	if (yych != 's') goto yy56;
yy554:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy539;
	if (yych == 't') goto yy539;
	goto yy56;
yy555:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy562;
		if (yych <= 'M') goto yy56;
		goto yy561;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy562;
		} else {
			if (yych == 'n') goto yy561;
			goto yy56;
		}
	}
yy556:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy557;
	if (yych != 'n') goto yy56;
yy557:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy558;
			if (yych != 'u') goto yy475;
		}
	}
yy558:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy559;
	if (yych != 'a') goto yy56;
yy559:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy560;
	if (yych != 'r') goto yy56;
yy560:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy539;
	if (yych == 'y') goto yy539;
	goto yy56;
yy561:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy539;
			if (yych == 'e') goto yy539;
			goto yy475;
		}
	}
yy562:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'Y') goto yy539;
			if (yych == 'y') goto yy539;
			goto yy475;
		}
	}
yy563:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy564:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych != 'I') goto yy475;
		}
	}
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy566:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy531;
			if (yych <= '/') goto yy475;
			goto yy533;
		} else {
			if (yych == 'I') goto yy539;
			goto yy475;
		}
	}
yy567:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy614;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy568:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		if (yych <= '.') goto yy600;
		goto yy490;
	} else {
		if (yych <= '2') goto yy614;
		if (yych <= '9') goto yy613;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy569:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy613;
		if (yych <= ':') goto yy492;
		goto yy490;
	}
yy570:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy600;
	} else {
		if (yych == ':') goto yy492;
		goto yy490;
	}
yy571:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy594;
	if (yych == 'e') goto yy594;
	goto yy56;
yy572:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy591;
	if (yych == 'a') goto yy591;
	goto yy56;
yy573:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy549;
		if (yych <= 'T') goto yy56;
		goto yy548;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy549;
		} else {
			if (yych == 'u') goto yy548;
			goto yy56;
		}
	}
yy574:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy584;
	if (yych == 'e') goto yy584;
	goto yy56;
yy575:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy578;
	if (yych == 'e') goto yy578;
	goto yy56;
yy576:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy577:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy573;
	case 'D':
	case 'd':	goto yy575;
	case 'F':
	case 'f':	goto yy571;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy572;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'S':
	case 's':	goto yy574;
	case 'V':	goto yy476;
	case 'X':	goto yy477;
	default:	goto yy56;
	}
yy578:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy579;
	if (yych != 'c') goto yy56;
yy579:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy580;
			if (yych != 'e') goto yy475;
		}
	}
yy580:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy581;
	if (yych != 'm') goto yy56;
yy581:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy582;
	if (yych != 'b') goto yy56;
yy582:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy583;
	if (yych != 'e') goto yy56;
yy583:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy584:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy585;
	if (yych != 'p') goto yy56;
yy585:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'T') goto yy586;
			if (yych != 't') goto yy475;
		}
	}
yy586:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy587;
			if (yych != 'e') goto yy475;
		}
	}
yy587:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy588;
	if (yych != 'm') goto yy56;
yy588:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy589;
	if (yych != 'b') goto yy56;
yy589:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy590;
	if (yych != 'e') goto yy56;
yy590:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy539;
	if (yych == 'r') goto yy539;
	goto yy56;
yy591:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy592;
		if (yych <= 'X') goto yy56;
		goto yy539;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy539;
			goto yy56;
		}
	}
yy592:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'C') goto yy593;
			if (yych != 'c') goto yy475;
		}
	}
yy593:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy539;
	if (yych == 'h') goto yy539;
	goto yy56;
yy594:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy595;
	if (yych != 'b') goto yy56;
yy595:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			goto yy531;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'R') goto yy596;
			if (yych != 'r') goto yy475;
		}
	}
yy596:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy597;
	if (yych != 'u') goto yy56;
yy597:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy598;
	if (yych != 'a') goto yy56;
yy598:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy599;
	if (yych != 'r') goto yy56;
yy599:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy539;
	if (yych == 'y') goto yy539;
	goto yy56;
yy600:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy607;
	if (yych <= '6') goto yy608;
	if (yych <= '9') goto yy609;
	goto yy56;
yy601:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy603:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy604:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	++YYCURSOR;
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy607:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy612;
	goto yy490;
yy608:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy496;
		goto yy490;
	} else {
		if (yych <= '0') goto yy612;
		if (yych <= '9') goto yy610;
		goto yy490;
	}
yy609:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych >= ':') goto yy490;
yy610:
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy611;
	if (yych <= '9') goto yy604;
yy611:
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
yy612:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy500;
			if (yych <= 0x1F) goto yy490;
			goto yy500;
		} else {
			if (yych == '.') goto yy496;
			if (yych <= '/') goto yy490;
			goto yy604;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy502;
			if (yych <= 'O') goto yy490;
			goto yy502;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy502;
			} else {
				if (yych == 'p') goto yy502;
				goto yy490;
			}
		}
	}
yy613:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
			goto yy507;
		} else {
			if (yych == '.') goto yy492;
			if (yych <= '9') goto yy490;
			goto yy492;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy614:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy507;
			if (yych <= 0x1F) goto yy490;
			goto yy507;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy490;
				goto yy601;
			} else {
				if (yych <= '.') goto yy600;
				if (yych <= '9') goto yy490;
				goto yy492;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy509;
			if (yych <= 'O') goto yy490;
			goto yy509;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy490;
				goto yy509;
			} else {
				if (yych == 'p') goto yy509;
				goto yy490;
			}
		}
	}
yy615:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy617;
		goto yy56;
	}
yy616:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy617:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy654;
	if (yych <= '.') goto yy601;
	goto yy56;
yy618:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy650;
		if (yych <= 'T') goto yy56;
		goto yy649;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy650;
		} else {
			if (yych == 'u') goto yy649;
			goto yy56;
		}
	}
yy619:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy647;
	if (yych == 'e') goto yy647;
	goto yy56;
yy620:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy644;
	if (yych == 'a') goto yy644;
	goto yy56;
yy621:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy641;
		if (yych <= 'T') goto yy56;
		goto yy640;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy641;
		} else {
			if (yych == 'u') goto yy640;
			goto yy56;
		}
	}
yy622:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy637;
	if (yych == 'e') goto yy637;
	goto yy56;
yy623:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy635;
	if (yych == 'c') goto yy635;
	goto yy56;
yy624:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy633;
	if (yych == 'o') goto yy633;
	goto yy56;
yy625:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy626;
	if (yych != 'e') goto yy56;
yy626:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy627;
	if (yych != 'c') goto yy56;
yy627:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych >= '.') goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy580;
			if (yych == 'e') goto yy580;
			goto yy475;
		}
	}
yy628:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy532;
	if (yych <= '0') goto yy629;
	if (yych <= '2') goto yy630;
	if (yych <= '3') goto yy631;
	goto yy532;
yy629:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy632;
	goto yy534;
yy630:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy632;
	goto yy534;
yy631:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '1') goto yy632;
	if (yych <= '9') goto yy540;
	goto yy534;
yy632:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy534;
	if (yych <= '9') goto yy541;
	goto yy534;
yy633:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy634;
	if (yych != 'v') goto yy56;
yy634:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy535;
			if (yych == 'e') goto yy535;
			goto yy475;
		}
	}
yy635:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy636;
	if (yych != 't') goto yy56;
yy636:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'O') goto yy545;
			if (yych == 'o') goto yy545;
			goto yy475;
		}
	}
yy637:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy638;
	if (yych != 'p') goto yy56;
yy638:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'T') goto yy639;
			if (yych != 't') goto yy475;
		}
	}
yy639:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy587;
			if (yych == 'e') goto yy587;
			goto yy475;
		}
	}
yy640:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy643;
	if (yych == 'g') goto yy643;
	goto yy56;
yy641:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy642;
	if (yych != 'r') goto yy56;
yy642:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'I') goto yy551;
			if (yych == 'i') goto yy551;
			goto yy475;
		}
	}
yy643:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy553;
			if (yych == 'u') goto yy553;
			goto yy475;
		}
	}
yy644:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy645;
		if (yych <= 'X') goto yy56;
		goto yy646;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy646;
			goto yy56;
		}
	}
yy645:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'C') goto yy593;
			if (yych == 'c') goto yy593;
			goto yy475;
		}
	}
yy646:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy475;
			goto yy531;
		} else {
			if (yych == ' ') goto yy531;
			goto yy475;
		}
	} else {
		if (yych <= '.') {
			if (yych <= '-') goto yy628;
			goto yy531;
		} else {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		}
	}
yy647:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy648;
	if (yych != 'b') goto yy56;
yy648:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'R') goto yy596;
			if (yych == 'r') goto yy596;
			goto yy475;
		}
	}
yy649:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy653;
		if (yych <= 'M') goto yy56;
		goto yy652;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy653;
		} else {
			if (yych == 'n') goto yy652;
			goto yy56;
		}
	}
yy650:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy651;
	if (yych != 'n') goto yy56;
yy651:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'U') goto yy558;
			if (yych == 'u') goto yy558;
			goto yy475;
		}
	}
yy652:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'E') goto yy539;
			if (yych == 'e') goto yy539;
			goto yy475;
		}
	}
yy653:
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy531;
			goto yy475;
		} else {
			if (yych <= ' ') goto yy531;
			if (yych <= ',') goto yy475;
			if (yych <= '-') goto yy628;
			goto yy531;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy475;
			if (yych <= '9') goto yy533;
			goto yy475;
		} else {
			if (yych <= 'Y') goto yy539;
			if (yych == 'y') goto yy539;
			goto yy475;
		}
	}
yy654:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy655;
	if (yych <= '3') goto yy657;
	if (yych <= '9') goto yy658;
	goto yy56;
yy655:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy664;
		if (yych >= 'n') goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
		}
	}
yy656:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy657:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
			goto yy664;
		} else {
			if (yych <= '9') goto yy603;
			if (yych <= 'm') goto yy656;
			goto yy660;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy658:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy603;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy659:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy663;
	goto yy56;
yy660:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy663;
	goto yy56;
yy661:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy663;
	goto yy56;
yy662:
	yych = *++YYCURSOR;
	if (yych != 'h') goto yy56;
yy663:
	yych = *++YYCURSOR;
	goto yy656;
yy664:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy604;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy665:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy722;
		} else {
			if (yych <= '9') goto yy668;
			if (yych >= 'n') goto yy719;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
		}
	}
yy666:
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
yy667:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy666;
			goto yy722;
		} else {
			if (yych <= '1') goto yy668;
			if (yych <= 'm') goto yy666;
			goto yy719;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy666;
			goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
			goto yy666;
		}
	}
yy668:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy722;
		if (yych <= 'm') goto yy666;
		goto yy719;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy666;
			goto yy720;
		} else {
			if (yych <= 's') goto yy718;
			if (yych <= 't') goto yy721;
			goto yy666;
		}
	}
yy669:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy717;
		if (yych <= 'T') goto yy56;
		goto yy716;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy717;
		} else {
			if (yych == 'u') goto yy716;
			goto yy56;
		}
	}
yy670:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy715;
	if (yych == 'e') goto yy715;
	goto yy56;
yy671:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy714;
	if (yych == 'a') goto yy714;
	goto yy56;
yy672:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy713;
		if (yych <= 'T') goto yy56;
		goto yy712;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy713;
		} else {
			if (yych == 'u') goto yy712;
			goto yy56;
		}
	}
yy673:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy710;
	if (yych == 'e') goto yy710;
	goto yy56;
yy674:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy709;
	if (yych == 'c') goto yy709;
	goto yy56;
yy675:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy708;
	if (yych == 'o') goto yy708;
	goto yy56;
yy676:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy677;
	if (yych != 'e') goto yy56;
yy677:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy678;
	if (yych != 'c') goto yy56;
yy678:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy679:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy685;
	if (yych <= '2') goto yy686;
	goto yy56;
yy685:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy687;
	goto yy56;
yy686:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy687:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy692;
	if (yych <= '6') goto yy693;
	goto yy56;
yy692:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy694;
	goto yy56;
yy693:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy694:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy695;
	if (yych != ' ') goto yy56;
yy695:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy695;
		} else {
			if (yych == ' ') goto yy695;
			goto yy56;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy56;
			goto yy698;
		} else {
			if (yych != 'G') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy706;
	goto yy56;
yy698:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy699;
	if (yych <= '2') goto yy701;
	if (yych <= '9') goto yy702;
	goto yy56;
yy699:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '/') goto yy700;
	if (yych <= '9') goto yy702;
	if (yych <= ':') goto yy703;
yy700:
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy701:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy700;
		if (yych >= '5') goto yy704;
	} else {
		if (yych <= '9') goto yy705;
		if (yych <= ':') goto yy703;
		goto yy700;
	}
yy702:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych <= '5') goto yy704;
	if (yych <= '9') goto yy705;
	if (yych >= ';') goto yy700;
yy703:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych <= '5') goto yy704;
	if (yych <= '9') goto yy705;
	goto yy700;
yy704:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy700;
	if (yych >= ':') goto yy700;
yy705:
	yych = *++YYCURSOR;
	goto yy700;
yy706:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy698;
	if (yych == '-') goto yy698;
	goto yy56;
yy708:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy678;
	if (yych == 'v') goto yy678;
	goto yy56;
yy709:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy678;
	if (yych == 't') goto yy678;
	goto yy56;
yy710:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy711;
	if (yych != 'p') goto yy56;
yy711:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy679;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy678;
		if (yych == 't') goto yy678;
		goto yy56;
	}
yy712:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy678;
	if (yych == 'g') goto yy678;
	goto yy56;
yy713:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy678;
	if (yych == 'r') goto yy678;
	goto yy56;
yy714:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy678;
		if (yych <= 'X') goto yy56;
		goto yy678;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy678;
		} else {
			if (yych == 'y') goto yy678;
			goto yy56;
		}
	}
yy715:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy678;
	if (yych == 'b') goto yy678;
	goto yy56;
yy716:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy678;
		if (yych <= 'M') goto yy56;
		goto yy678;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy678;
		} else {
			if (yych == 'n') goto yy678;
			goto yy56;
		}
	}
yy717:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy678;
	if (yych == 'n') goto yy678;
	goto yy56;
yy718:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy727;
	goto yy56;
yy719:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy727;
	goto yy56;
yy720:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy727;
	goto yy56;
yy721:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy727;
	goto yy56;
yy722:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy666;
	if (yych >= ':') goto yy666;
	yych = *++YYCURSOR;
	goto yy666;
yy727:
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy722;
	goto yy666;
yy728:
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy730;
		goto yy577;
	} else {
		if (yych <= '-') goto yy731;
		if (yych <= '.') goto yy730;
		if (yych >= '0') goto yy577;
	}
yy729:
	yych = *++YYCURSOR;
	switch (yych) {
	case 'A':
	case 'a':	goto yy672;
	case 'D':
	case 'd':	goto yy676;
	case 'F':
	case 'f':	goto yy670;
	case 'J':
	case 'j':	goto yy669;
	case 'M':
	case 'm':	goto yy671;
	case 'N':
	case 'n':	goto yy675;
	case 'O':
	case 'o':	goto yy674;
	case 'S':
	case 's':	goto yy673;
	default:	goto yy56;
	}
yy730:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy577;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy577;
yy731:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy577;
	if (yych <= '0') goto yy732;
	if (yych <= '1') goto yy733;
	if (yych <= '9') goto yy734;
	goto yy577;
yy732:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy734;
	goto yy56;
yy733:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy734:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '.') goto yy601;
	goto yy56;
yy735:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy601;
		goto yy738;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy737;
		goto yy56;
	}
yy736:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy601;
		goto yy738;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy737:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy601;
	if (yych >= '/') goto yy56;
yy738:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy610;
	goto yy56;
yy740:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy784;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy782;
	goto yy60;
yy741:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy750;
	case '1':	goto yy751;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy752;
	case 'A':
	case 'a':	goto yy745;
	case 'D':
	case 'd':	goto yy749;
	case 'F':
	case 'f':	goto yy743;
	case 'J':
	case 'j':	goto yy742;
	case 'M':
	case 'm':	goto yy744;
	case 'N':
	case 'n':	goto yy748;
	case 'O':
	case 'o':	goto yy747;
	case 'S':
	case 's':	goto yy746;
	default:	goto yy56;
	}
yy742:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy781;
		if (yych <= 'T') goto yy56;
		goto yy780;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy781;
		} else {
			if (yych == 'u') goto yy780;
			goto yy56;
		}
	}
yy743:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy779;
	if (yych == 'e') goto yy779;
	goto yy56;
yy744:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy778;
	if (yych == 'a') goto yy778;
	goto yy56;
yy745:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy777;
		if (yych <= 'T') goto yy56;
		goto yy776;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy777;
		} else {
			if (yych == 'u') goto yy776;
			goto yy56;
		}
	}
yy746:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy774;
	if (yych == 'e') goto yy774;
	goto yy56;
yy747:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy773;
	if (yych == 'c') goto yy773;
	goto yy56;
yy748:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy772;
	if (yych == 'o') goto yy772;
	goto yy56;
yy749:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy764;
	if (yych == 'e') goto yy764;
	goto yy56;
yy750:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy757;
	goto yy56;
yy751:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy757;
	goto yy56;
yy752:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy753:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy754;
	if (yych <= '3') goto yy755;
	if (yych <= '9') goto yy756;
	goto yy56;
yy754:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy756;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy755:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '1') goto yy756;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy756:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy660;
		goto yy656;
	} else {
		if (yych <= 'r') goto yy661;
		if (yych <= 's') goto yy659;
		if (yych <= 't') goto yy662;
		goto yy656;
	}
yy757:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy760;
	} else {
		if (yych <= '3') goto yy761;
		if (yych <= '9') goto yy756;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy760:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy761:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '1') goto yy762;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy762:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy660;
	} else {
		if (yych <= 'r') goto yy661;
		if (yych <= 's') goto yy659;
		if (yych <= 't') goto yy662;
	}
yy763:
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy764:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy765;
	if (yych != 'c') goto yy56;
yy765:
	yych = *++YYCURSOR;
	if (yych != '-') goto yy56;
yy766:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy767;
	if (yych <= '2') goto yy768;
	if (yych <= '3') goto yy769;
	goto yy56;
yy767:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy768:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy770;
	goto yy56;
yy769:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy770:
	++YYCURSOR;
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
yy772:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy765;
	if (yych == 'v') goto yy765;
	goto yy56;
yy773:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy765;
	if (yych == 't') goto yy765;
	goto yy56;
yy774:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy775;
	if (yych != 'p') goto yy56;
yy775:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy766;
		goto yy56;
	} else {
		if (yych <= 'T') goto yy765;
		if (yych == 't') goto yy765;
		goto yy56;
	}
yy776:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy765;
	if (yych == 'g') goto yy765;
	goto yy56;
yy777:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy765;
	if (yych == 'r') goto yy765;
	goto yy56;
yy778:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy765;
		if (yych <= 'X') goto yy56;
		goto yy765;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
			goto yy765;
		} else {
			if (yych == 'y') goto yy765;
			goto yy56;
		}
	}
yy779:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy765;
	if (yych == 'b') goto yy765;
	goto yy56;
yy780:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy765;
		if (yych <= 'M') goto yy56;
		goto yy765;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy765;
		} else {
			if (yych == 'n') goto yy765;
			goto yy56;
		}
	}
yy781:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy765;
	if (yych == 'n') goto yy765;
	goto yy56;
yy782:
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy790;
	case '-':	goto yy787;
	case '.':	goto yy791;
	case '/':	goto yy788;
	case '0':	goto yy804;
	case '1':	goto yy805;
	case '2':	goto yy807;
	case '3':	goto yy808;
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy806;
	case 'W':	goto yy809;
	default:	goto yy783;
	}
yy783:
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
yy784:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy785;
	case '1':	goto yy786;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy752;
	case 'A':
	case 'a':	goto yy745;
	case 'D':
	case 'd':	goto yy749;
	case 'F':
	case 'f':	goto yy743;
	case 'J':
	case 'j':	goto yy742;
	case 'M':
	case 'm':	goto yy744;
	case 'N':
	case 'n':	goto yy748;
	case 'O':
	case 'o':	goto yy747;
	case 'S':
	case 's':	goto yy746;
	default:	goto yy56;
	}
yy785:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy752;
	goto yy56;
yy786:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy753;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy752;
	goto yy56;
yy787:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy972;
	case '1':	goto yy974;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy975;
	case 'A':
	case 'a':	goto yy966;
	case 'D':
	case 'd':	goto yy970;
	case 'F':
	case 'f':	goto yy964;
	case 'J':
	case 'j':	goto yy963;
	case 'M':
	case 'm':	goto yy965;
	case 'N':
	case 'n':	goto yy969;
	case 'O':
	case 'o':	goto yy968;
	case 'S':
	case 's':	goto yy967;
	case 'W':	goto yy971;
	default:	goto yy938;
	}
yy788:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy946;
	if (yych <= '1') goto yy947;
	if (yych <= '9') goto yy948;
	goto yy56;
yy789:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy790:
	switch (yych) {
	case '\t':
	case ' ':	goto yy789;
	case '-':
	case '.':	goto yy937;
	case 'A':
	case 'a':	goto yy799;
	case 'D':
	case 'd':	goto yy803;
	case 'F':
	case 'f':	goto yy797;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy792;
	case 'J':
	case 'j':	goto yy796;
	case 'M':
	case 'm':	goto yy798;
	case 'N':
	case 'n':	goto yy802;
	case 'O':
	case 'o':	goto yy801;
	case 'S':
	case 's':	goto yy800;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy794;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy795;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy791:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy938;
	if (yych <= '0') goto yy930;
	if (yych <= '2') goto yy931;
	if (yych <= '3') goto yy932;
	goto yy938;
yy792:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= 'U') {
		if (yych == 'I') goto yy929;
	} else {
		if (yych == 'W') goto yy793;
		if (yych <= 'X') goto yy883;
	}
yy793:
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
yy794:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy927;
	goto yy793;
yy795:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy926;
	goto yy793;
yy796:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy919;
		if (yych <= 'T') goto yy56;
		goto yy918;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy919;
		} else {
			if (yych == 'u') goto yy918;
			goto yy56;
		}
	}
yy797:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy912;
			goto yy56;
		} else {
			if (yych <= 'O') goto yy98;
			if (yych <= 'Q') goto yy56;
			goto yy97;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy912;
			goto yy56;
		} else {
			if (yych <= 'o') goto yy98;
			if (yych == 'r') goto yy97;
			goto yy56;
		}
	}
yy798:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy909;
			goto yy56;
		} else {
			if (yych <= 'I') goto yy117;
			if (yych <= 'N') goto yy56;
			goto yy116;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy909;
			goto yy56;
		} else {
			if (yych <= 'i') goto yy117;
			if (yych == 'o') goto yy116;
			goto yy56;
		}
	}
yy799:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy903;
		if (yych <= 'T') goto yy56;
		goto yy902;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy903;
		} else {
			if (yych == 'u') goto yy902;
			goto yy56;
		}
	}
yy800:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy895;
			if (yych <= 'T') goto yy56;
			goto yy125;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy126;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy895;
			if (yych == 'u') goto yy125;
			goto yy56;
		}
	}
yy801:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy890;
	if (yych == 'c') goto yy890;
	goto yy56;
yy802:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy884;
	if (yych == 'o') goto yy884;
	goto yy56;
yy803:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy113;
		if (yych <= 'D') goto yy56;
		goto yy877;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy113;
		} else {
			if (yych == 'e') goto yy877;
			goto yy56;
		}
	}
yy804:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy874;
	if (yych <= '9') goto yy875;
	goto yy60;
yy805:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy843;
	if (yych <= '9') goto yy822;
	goto yy60;
yy806:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy823;
	if (yych <= '1') goto yy824;
	goto yy56;
yy807:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy822;
	goto yy60;
yy808:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy818;
	if (yych <= '6') goto yy819;
	if (yych <= '9') goto yy54;
	goto yy60;
yy809:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '0') goto yy810;
		if (yych <= '4') goto yy811;
		goto yy812;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy56;
			goto yy82;
		} else {
			if (yych == 'e') goto yy82;
			goto yy56;
		}
	}
yy810:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy813;
	goto yy56;
yy811:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy813;
	goto yy56;
yy812:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '4') goto yy56;
yy813:
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy815;
	if (yych <= '/') goto yy814;
	if (yych <= '7') goto yy816;
yy814:
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy815:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '8') goto yy56;
yy816:
	++YYCURSOR;
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
yy818:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy820;
	goto yy60;
yy819:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '6') goto yy820;
	if (yych <= '9') goto yy54;
	goto yy60;
yy820:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy821;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy821:
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
yy822:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy820;
	goto yy60;
yy823:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy825;
	goto yy56;
yy824:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '3') goto yy56;
yy825:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy827;
	if (yych <= '2') goto yy828;
	if (yych <= '3') goto yy829;
	goto yy56;
yy827:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy830;
	goto yy56;
yy828:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy830;
	goto yy56;
yy829:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '2') goto yy56;
yy830:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy832;
	if (yych <= '2') goto yy833;
	goto yy56;
yy832:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy834;
	goto yy56;
yy833:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '5') goto yy56;
yy834:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy839;
	if (yych <= '6') goto yy840;
	goto yy56;
yy839:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy840:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy841:
	++YYCURSOR;
yy842:
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
yy843:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych >= '1') goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy844:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '/') goto yy821;
				if (yych <= '9') goto yy847;
				if (yych <= 'C') goto yy821;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy845:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '/') goto yy821;
				if (yych <= '9') goto yy847;
				if (yych <= 'C') goto yy821;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy846:
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy821;
				goto yy60;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy821;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy821;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy821;
					if (yych <= 'T') goto yy60;
					goto yy821;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy821;
				if (yych <= 'Y') goto yy60;
				goto yy821;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy821;
				} else {
					if (yych == 'g') goto yy821;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy821;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy821;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy821;
				}
			}
		}
	}
yy847:
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy59;
				if (yych >= ' ') goto yy59;
			} else {
				if (yych == 'D') goto yy64;
				if (yych >= 'F') goto yy65;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy63;
				if (yych >= 'M') goto yy62;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy61;
				} else {
					if (yych <= 'T') goto yy849;
					if (yych >= 'W') goto yy67;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy66;
				if (yych >= 'd') goto yy64;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy65;
				} else {
					if (yych == 'h') goto yy63;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy62;
				if (yych <= 'r') goto yy848;
				if (yych <= 's') goto yy61;
				goto yy850;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy67;
				} else {
					if (yych == 'y') goto yy66;
				}
			}
		}
	}
yy848:
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
yy849:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych <= '1') goto yy864;
			goto yy865;
		} else {
			if (yych <= '9') goto yy866;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
yy850:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy56;
			if (yych >= '2') goto yy852;
		} else {
			if (yych <= '9') goto yy853;
			if (yych <= 'G') goto yy56;
			goto yy69;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy70;
			goto yy56;
		} else {
			if (yych <= 'h') goto yy69;
			if (yych == 'u') goto yy70;
			goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy858;
	if (yych <= '9') goto yy853;
	goto yy56;
yy852:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy858;
	if (yych <= '5') goto yy854;
	goto yy56;
yy853:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
yy854:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy855:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy856;
	if (yych <= '6') goto yy857;
	goto yy56;
yy856:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy857:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy56;
yy858:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy859;
	if (yych <= '9') goto yy855;
	goto yy56;
yy859:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy860;
	if (yych <= '6') goto yy861;
	if (yych <= '9') goto yy855;
	goto yy56;
yy860:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy862;
	if (yych <= '6') goto yy863;
	if (yych <= '9') goto yy841;
	goto yy56;
yy861:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy862;
	if (yych <= '5') goto yy856;
	if (yych <= '6') goto yy857;
	goto yy56;
yy862:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy863:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy842;
yy864:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy873;
	if (yych <= '9') goto yy866;
	if (yych <= ':') goto yy867;
	goto yy56;
yy865:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy56;
		if (yych <= '4') goto yy873;
		goto yy854;
	} else {
		if (yych == ':') goto yy867;
		goto yy56;
	}
yy866:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy854;
	if (yych != ':') goto yy56;
yy867:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= '6') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy871;
	if (yych <= '6') goto yy872;
	goto yy56;
yy871:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy841;
	goto yy56;
yy872:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy56;
yy873:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy859;
	if (yych <= '9') goto yy855;
	if (yych <= ':') goto yy867;
	goto yy56;
yy874:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy876;
		goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy875:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy60;
		if (yych <= '0') goto yy844;
		goto yy845;
	} else {
		if (yych <= '3') goto yy846;
		if (yych <= '9') goto yy820;
		goto yy60;
	}
yy876:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy847;
	goto yy60;
yy877:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy878;
	if (yych != 'c') goto yy56;
yy878:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy879;
	if (yych != 'e') goto yy793;
yy879:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy880;
	if (yych != 'm') goto yy56;
yy880:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy881;
	if (yych != 'b') goto yy56;
yy881:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy882;
	if (yych != 'e') goto yy56;
yy882:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych != 'r') goto yy56;
yy883:
	yych = *++YYCURSOR;
	goto yy793;
yy884:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy885;
	if (yych != 'v') goto yy56;
yy885:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy886;
	if (yych != 'e') goto yy793;
yy886:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy887;
	if (yych != 'm') goto yy56;
yy887:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy888;
	if (yych != 'b') goto yy56;
yy888:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy889;
	if (yych != 'e') goto yy56;
yy889:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy890:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy891;
	if (yych != 't') goto yy56;
yy891:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy892;
	if (yych != 'o') goto yy793;
yy892:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy893;
	if (yych != 'b') goto yy56;
yy893:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy894;
	if (yych != 'e') goto yy56;
yy894:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy895:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych != 'p') goto yy56;
		}
	}
yy896:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy897;
	if (yych != 't') goto yy793;
yy897:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy898;
	if (yych != 'e') goto yy793;
yy898:
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy899;
	if (yych != 'm') goto yy56;
yy899:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy900;
	if (yych != 'b') goto yy56;
yy900:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy901;
	if (yych != 'e') goto yy56;
yy901:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy883;
	if (yych == 'r') goto yy883;
	goto yy56;
yy902:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy906;
	if (yych == 'g') goto yy906;
	goto yy56;
yy903:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy904;
	if (yych != 'r') goto yy56;
yy904:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy905;
	if (yych != 'i') goto yy793;
yy905:
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy883;
	if (yych == 'l') goto yy883;
	goto yy56;
yy906:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy907;
	if (yych != 'u') goto yy793;
yy907:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy908;
	if (yych != 's') goto yy56;
yy908:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy883;
	if (yych == 't') goto yy883;
	goto yy56;
yy909:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy910;
		if (yych <= 'X') goto yy56;
		goto yy883;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy883;
			goto yy56;
		}
	}
yy910:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy911;
	if (yych != 'c') goto yy793;
yy911:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy883;
	if (yych == 'h') goto yy883;
	goto yy56;
yy912:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy913;
	if (yych != 'b') goto yy56;
yy913:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy914;
	if (yych != 'r') goto yy793;
yy914:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy915;
	if (yych != 'u') goto yy56;
yy915:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy916;
	if (yych != 'a') goto yy56;
yy916:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych != 'r') goto yy56;
yy917:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy56;
yy918:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy925;
		if (yych <= 'M') goto yy56;
		goto yy924;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy925;
		} else {
			if (yych == 'n') goto yy924;
			goto yy56;
		}
	}
yy919:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy920;
	if (yych != 'n') goto yy56;
yy920:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy921;
	if (yych != 'u') goto yy793;
yy921:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy922;
	if (yych != 'a') goto yy56;
yy922:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy923;
	if (yych != 'r') goto yy56;
yy923:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy56;
yy924:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy883;
	if (yych == 'e') goto yy883;
	goto yy793;
yy925:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy883;
	if (yych == 'y') goto yy883;
	goto yy793;
yy926:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy927:
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy793;
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy929:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy883;
	goto yy793;
yy930:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy945;
	if (yych <= '9') goto yy944;
	goto yy56;
yy931:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy943;
	goto yy56;
yy932:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy941;
	if (yych <= '6') goto yy940;
	goto yy56;
yy933:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy912;
	if (yych == 'e') goto yy912;
	goto yy56;
yy934:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy909;
	if (yych == 'a') goto yy909;
	goto yy56;
yy935:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy939;
	if (yych == 'e') goto yy939;
	goto yy56;
yy936:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy877;
	if (yych == 'e') goto yy877;
	goto yy56;
yy937:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy938:
	switch (yych) {
	case '\t':
	case ' ':
	case '-':
	case '.':	goto yy937;
	case 'A':
	case 'a':	goto yy799;
	case 'D':
	case 'd':	goto yy936;
	case 'F':
	case 'f':	goto yy933;
	case 'I':	goto yy792;
	case 'J':
	case 'j':	goto yy796;
	case 'M':
	case 'm':	goto yy934;
	case 'N':
	case 'n':	goto yy802;
	case 'O':
	case 'o':	goto yy801;
	case 'S':
	case 's':	goto yy935;
	case 'V':	goto yy794;
	case 'X':	goto yy795;
	default:	goto yy56;
	}
yy939:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy896;
	if (yych == 'p') goto yy896;
	goto yy56;
yy940:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '6') goto yy942;
	goto yy56;
yy941:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy942:
	yych = *++YYCURSOR;
	goto yy821;
yy943:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy944:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy945:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy56;
	if (yych <= '9') goto yy942;
	goto yy56;
yy946:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy949;
	if (yych <= '9') goto yy957;
	goto yy56;
yy947:
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy56;
	if (yych <= '/') goto yy949;
	if (yych <= '2') goto yy957;
	goto yy56;
yy948:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
yy949:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy950;
	if (yych <= '3') goto yy951;
	if (yych <= '9') goto yy952;
	goto yy56;
yy950:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy952;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy951:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '1') goto yy952;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy952:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy954;
		goto yy454;
	} else {
		if (yych <= 'r') goto yy955;
		if (yych <= 's') goto yy953;
		if (yych <= 't') goto yy956;
		goto yy454;
	}
yy953:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy453;
	goto yy56;
yy954:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy453;
	goto yy56;
yy955:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy453;
	goto yy56;
yy956:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy453;
	goto yy56;
yy957:
	yych = *++YYCURSOR;
	if (yych != '/') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy960;
	} else {
		if (yych <= '3') goto yy961;
		if (yych <= '9') goto yy952;
		goto yy56;
	}
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy960:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '9') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy961:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy454;
		if (yych <= '1') goto yy962;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy962:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy453;
		if (yych <= 'm') goto yy454;
		goto yy954;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy955;
		} else {
			if (yych <= 's') goto yy953;
			if (yych <= 't') goto yy956;
			goto yy454;
		}
	}
yy963:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy1043;
		if (yych <= 'T') goto yy56;
		goto yy1042;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy56;
			goto yy1043;
		} else {
			if (yych == 'u') goto yy1042;
			goto yy56;
		}
	}
yy964:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1040;
	if (yych == 'e') goto yy1040;
	goto yy56;
yy965:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1037;
	if (yych == 'a') goto yy1037;
	goto yy56;
yy966:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy1034;
		if (yych <= 'T') goto yy56;
		goto yy1033;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy56;
			goto yy1034;
		} else {
			if (yych == 'u') goto yy1033;
			goto yy56;
		}
	}
yy967:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1030;
	if (yych == 'e') goto yy1030;
	goto yy56;
yy968:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1028;
	if (yych == 'c') goto yy1028;
	goto yy56;
yy969:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1026;
	if (yych == 'o') goto yy1026;
	goto yy56;
yy970:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1024;
	if (yych == 'e') goto yy1024;
	goto yy56;
yy971:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '0') goto yy810;
	if (yych <= '4') goto yy811;
	if (yych <= '5') goto yy812;
	goto yy56;
yy972:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy976;
	if (yych <= '/') goto yy973;
	if (yych <= '9') goto yy995;
yy973:
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
yy974:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy976;
	if (yych <= '/') goto yy973;
	if (yych <= '2') goto yy995;
	goto yy973;
yy975:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy973;
yy976:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '2') goto yy977;
	if (yych <= '3') goto yy978;
	if (yych <= '9') goto yy979;
	goto yy56;
yy977:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy979;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy978:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy979:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy984;
		if (yych <= 'm') goto yy656;
		goto yy981;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy980:
	yych = *++YYCURSOR;
	if (yych == 't') goto yy994;
	goto yy56;
yy981:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy994;
	goto yy56;
yy982:
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy994;
	goto yy56;
yy983:
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy994;
	goto yy56;
yy984:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy985;
	if (yych <= '2') goto yy986;
	if (yych <= '9') goto yy987;
	goto yy56;
yy985:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy987;
	if (yych <= ':') goto yy988;
	goto yy56;
yy986:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy987;
	if (yych == ':') goto yy988;
	goto yy56;
yy987:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy988:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy989;
	if (yych <= '9') goto yy990;
	goto yy56;
yy989:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy990;
	if (yych <= ':') goto yy991;
	goto yy56;
yy990:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
yy991:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy992;
	if (yych <= '6') goto yy993;
	if (yych <= '9') goto yy841;
	goto yy56;
yy992:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy993:
	yych = *++YYCURSOR;
	if (yych == '0') goto yy841;
	goto yy842;
yy994:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy984;
	goto yy656;
yy995:
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '-') goto yy973;
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy998;
	} else {
		if (yych <= '3') goto yy999;
		if (yych <= '9') goto yy979;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy1000;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy998:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy656;
			goto yy1000;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy999:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych == 'T') goto yy984;
			goto yy656;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy981;
			if (yych <= 'q') goto yy656;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy656;
		}
	}
yy1000:
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1001;
		if (yych <= 'm') goto yy454;
		goto yy981;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy454;
			goto yy982;
		} else {
			if (yych <= 's') goto yy980;
			if (yych <= 't') goto yy983;
			goto yy454;
		}
	}
yy1001:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1002;
	if (yych <= '2') goto yy1003;
	if (yych <= '9') goto yy987;
	goto yy56;
yy1002:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1004;
	if (yych <= ':') goto yy988;
	goto yy56;
yy1003:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '4') goto yy1004;
	if (yych == ':') goto yy988;
	goto yy56;
yy1004:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1006;
	if (yych <= '9') goto yy990;
	goto yy56;
yy1006:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1007;
	if (yych <= ':') goto yy991;
	goto yy56;
yy1007:
	yych = *++YYCURSOR;
	if (yych != ':') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1009;
	if (yych <= '6') goto yy1010;
	if (yych <= '9') goto yy841;
	goto yy56;
yy1009:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy1011;
	goto yy842;
yy1010:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy842;
yy1011:
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '.') goto yy842;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1013:
	yyaccept = 23;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1016;
		if (yych <= ',') goto yy842;
		goto yy1016;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy842;
			goto yy1013;
		} else {
			if (yych != 'G') goto yy842;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1022;
	goto yy56;
yy1016:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1017;
	if (yych <= '2') goto yy1018;
	if (yych <= '9') goto yy1019;
	goto yy56;
yy1017:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy1019;
	if (yych <= ':') goto yy1020;
	goto yy842;
yy1018:
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy842;
		if (yych >= '5') goto yy1021;
	} else {
		if (yych <= '9') goto yy841;
		if (yych <= ':') goto yy1020;
		goto yy842;
	}
yy1019:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '5') goto yy1021;
	if (yych <= '9') goto yy841;
	if (yych >= ';') goto yy842;
yy1020:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '5') goto yy1021;
	if (yych <= '9') goto yy841;
	goto yy842;
yy1021:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy842;
	if (yych <= '9') goto yy841;
	goto yy842;
yy1022:
	yych = *++YYCURSOR;
	if (yych != 'T') goto yy56;
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1016;
	if (yych == '-') goto yy1016;
	goto yy56;
yy1024:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1025;
	if (yych != 'c') goto yy56;
yy1025:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy879;
		if (yych == 'e') goto yy879;
		goto yy793;
	}
yy1026:
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy1027;
	if (yych != 'v') goto yy56;
yy1027:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy886;
		if (yych == 'e') goto yy886;
		goto yy793;
	}
yy1028:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1029;
	if (yych != 't') goto yy56;
yy1029:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'O') goto yy892;
		if (yych == 'o') goto yy892;
		goto yy793;
	}
yy1030:
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy1031;
	if (yych != 'p') goto yy56;
yy1031:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'T') goto yy1032;
		if (yych != 't') goto yy793;
	}
yy1032:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy898;
		if (yych == 'e') goto yy898;
		goto yy793;
	}
yy1033:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1036;
	if (yych == 'g') goto yy1036;
	goto yy56;
yy1034:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1035;
	if (yych != 'r') goto yy56;
yy1035:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'I') goto yy905;
		if (yych == 'i') goto yy905;
		goto yy793;
	}
yy1036:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'U') goto yy907;
		if (yych == 'u') goto yy907;
		goto yy793;
	}
yy1037:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy1038;
		if (yych <= 'X') goto yy56;
		goto yy1039;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy56;
		} else {
			if (yych == 'y') goto yy1039;
			goto yy56;
		}
	}
yy1038:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'C') goto yy911;
		if (yych == 'c') goto yy911;
		goto yy793;
	}
yy1039:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy766;
	goto yy793;
yy1040:
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1041;
	if (yych != 'b') goto yy56;
yy1041:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'R') goto yy914;
		if (yych == 'r') goto yy914;
		goto yy793;
	}
yy1042:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy1046;
		if (yych <= 'M') goto yy56;
		goto yy1045;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy56;
			goto yy1046;
		} else {
			if (yych == 'n') goto yy1045;
			goto yy56;
		}
	}
yy1043:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1044;
	if (yych != 'n') goto yy56;
yy1044:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'U') goto yy921;
		if (yych == 'u') goto yy921;
		goto yy793;
	}
yy1045:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'E') goto yy883;
		if (yych == 'e') goto yy883;
		goto yy793;
	}
yy1046:
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy766;
		goto yy793;
	} else {
		if (yych <= 'Y') goto yy883;
		if (yych == 'y') goto yy883;
		goto yy793;
	}
yy1047:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy577;
			goto yy730;
		} else {
			if (yych <= ',') goto yy577;
			if (yych <= '-') goto yy731;
			goto yy730;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy729;
			if (yych <= 'T') goto yy577;
			goto yy77;
		} else {
			if (yych == 'u') goto yy77;
			goto yy577;
		}
	}
yy1048:
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy128;
		if (yych <= 'O') goto yy56;
		goto yy585;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy56;
			goto yy128;
		} else {
			if (yych == 'p') goto yy585;
			goto yy56;
		}
	}
yy1049:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy1051;
			goto yy1053;
		} else {
			if (yych <= '-') goto yy1050;
			if (yych <= '.') goto yy730;
			if (yych <= '/') goto yy729;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1050:
	yych = *++YYCURSOR;
	switch (yych) {
	case '0':	goto yy1054;
	case '1':	goto yy1055;
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy617;
	case 'A':
	case 'a':	goto yy621;
	case 'D':
	case 'd':	goto yy625;
	case 'F':
	case 'f':	goto yy619;
	case 'J':
	case 'j':	goto yy618;
	case 'M':
	case 'm':	goto yy620;
	case 'N':
	case 'n':	goto yy624;
	case 'O':
	case 'o':	goto yy623;
	case 'S':
	case 's':	goto yy622;
	default:	goto yy577;
	}
yy1051:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1053;
	if (yych <= '0') goto yy735;
	if (yych <= '1') goto yy736;
	if (yych <= '9') goto yy737;
	goto yy1053;
yy1052:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy1053:
	switch (yych) {
	case '\t':
	case ' ':	goto yy1052;
	case '-':
	case '.':	goto yy576;
	case 'A':
	case 'a':	goto yy573;
	case 'D':
	case 'd':	goto yy465;
	case 'F':
	case 'f':	goto yy466;
	case 'H':
	case 'h':	goto yy63;
	case 'I':	goto yy474;
	case 'J':
	case 'j':	goto yy478;
	case 'M':
	case 'm':	goto yy464;
	case 'N':
	case 'n':	goto yy481;
	case 'O':
	case 'o':	goto yy480;
	case 'S':
	case 's':	goto yy462;
	case 'T':
	case 't':	goto yy68;
	case 'V':	goto yy476;
	case 'W':
	case 'w':	goto yy67;
	case 'X':	goto yy477;
	case 'Y':
	case 'y':	goto yy66;
	default:	goto yy56;
	}
yy1054:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych <= '9') goto yy1056;
		goto yy56;
	}
yy1055:
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy56;
		if (yych <= '-') goto yy654;
		goto yy601;
	} else {
		if (yych <= '/') goto yy56;
		if (yych >= '3') goto yy56;
	}
yy1056:
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy56;
	if (yych <= '-') goto yy1057;
	if (yych <= '.') goto yy601;
	goto yy56;
yy1057:
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy56;
		if (yych >= '1') goto yy1059;
	} else {
		if (yych <= '3') goto yy1060;
		if (yych <= '9') goto yy658;
		goto yy56;
	}
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy1061;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1059:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy656;
		if (yych <= '9') goto yy1061;
		if (yych <= 'm') goto yy656;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1060:
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy656;
		} else {
			if (yych <= '9') goto yy603;
			if (yych <= 'm') goto yy656;
			goto yy660;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy656;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy656;
		}
	}
yy1061:
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy763;
		if (yych <= '9') goto yy604;
		if (yych <= 'm') goto yy763;
		goto yy660;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy763;
			goto yy661;
		} else {
			if (yych <= 's') goto yy659;
			if (yych <= 't') goto yy662;
			goto yy763;
		}
	}
yy1062:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1051;
			if (yych <= ',') goto yy1053;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy1063;
			if (yych <= '/') goto yy729;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1064;
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1063:
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy577;
		if (yych <= '0') goto yy1087;
		goto yy1088;
	} else {
		if (yych <= '5') goto yy1089;
		if (yych <= '9') goto yy1090;
		goto yy577;
	}
yy1064:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1082;
	if (yych <= '9') goto yy1083;
	goto yy56;
yy1065:
	yych = *++YYCURSOR;
	if (yych == '-') goto yy784;
	if (yych <= '/') goto yy60;
	if (yych >= ':') goto yy60;
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
	case '\t':
	case ' ':
	case 'A':
	case 'D':
	case 'F':
	case 'H':
	case 'I':
	case 'J':
	case 'M':
	case 'N':
	case 'O':
	case 'S':
	case 'T':
	case 'V':
	case 'X':
	case 'Y':
	case 'a':
	case 'd':
	case 'f':
	case 'h':
	case 'j':
	case 'm':
	case 'n':
	case 'o':
	case 's':
	case 't':
	case 'w':
	case 'y':	goto yy790;
	case '-':	goto yy787;
	case '.':	goto yy791;
	case '/':	goto yy788;
	case '0':	goto yy1068;
	case '1':	goto yy1069;
	case '2':	goto yy1070;
	case '3':	goto yy1071;
	case '4':
	case '5':	goto yy1072;
	case '6':	goto yy1073;
	case '7':
	case '8':
	case '9':	goto yy54;
	case ':':	goto yy806;
	case 'W':	goto yy809;
	default:	goto yy1067;
	}
yy1067:
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
yy1068:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1080;
	if (yych <= '9') goto yy1081;
	goto yy60;
yy1069:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '2') goto yy1079;
	if (yych <= '9') goto yy1078;
	goto yy60;
yy1070:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1078;
	goto yy60;
yy1071:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '5') goto yy1076;
	if (yych <= '6') goto yy1077;
	if (yych <= '9') goto yy1074;
	goto yy60;
yy1072:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '9') goto yy1074;
	goto yy60;
yy1073:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy60;
	if (yych <= '0') goto yy1074;
	if (yych <= '9') goto yy54;
	goto yy60;
yy1074:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy54;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych >= ' ') goto yy60;
			} else {
				if (yych == 'D') goto yy60;
				if (yych >= 'F') goto yy60;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy60;
				if (yych >= 'M') goto yy60;
			} else {
				if (yych <= 'R') goto yy1075;
				if (yych <= 'T') goto yy60;
				if (yych >= 'W') goto yy60;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy60;
				if (yych >= 'd') goto yy60;
			} else {
				if (yych == 'f') goto yy60;
				if (yych >= 'h') goto yy60;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych >= 's') goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy60;
				} else {
					if (yych == 'y') goto yy60;
				}
			}
		}
	}
yy1075:
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
yy1076:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1075;
				if (yych <= '9') goto yy820;
				if (yych <= 'C') goto yy1075;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1077:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy1075;
					goto yy820;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1078:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '/') goto yy1075;
				if (yych <= '9') goto yy820;
				if (yych <= 'C') goto yy1075;
				goto yy60;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy60;
				if (yych <= 'G') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy1075;
					goto yy60;
				} else {
					if (yych <= 'R') goto yy1075;
					if (yych <= 'T') goto yy60;
					goto yy1075;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy1075;
				if (yych <= 'Y') goto yy60;
				goto yy1075;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy60;
					goto yy1075;
				} else {
					if (yych == 'g') goto yy1075;
					goto yy60;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy60;
				if (yych <= 'r') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1079:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy844;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1080:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy876;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1081:
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy60;
				if (yych <= 0x1F) goto yy1075;
				goto yy60;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy1075;
					goto yy844;
				} else {
					if (yych <= '2') goto yy845;
					if (yych <= '3') goto yy846;
					goto yy820;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'F') goto yy60;
					goto yy1075;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'M') goto yy60;
					if (yych <= 'R') goto yy1075;
					goto yy60;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy60;
				if (yych <= 'X') goto yy1075;
				goto yy60;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'f') goto yy60;
					goto yy1075;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy60;
					goto yy1075;
				} else {
					if (yych <= 'm') goto yy60;
					if (yych <= 'r') goto yy1075;
					goto yy60;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy1075;
					goto yy60;
				} else {
					if (yych == 'y') goto yy60;
					goto yy1075;
				}
			}
		}
	}
yy1082:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy1084;
		goto yy490;
	} else {
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1083:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1084;
	if (yych != ':') goto yy490;
yy1084:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1085;
	if (yych <= '6') goto yy1086;
	if (yych <= '9') goto yy495;
	goto yy56;
yy1085:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy495;
	goto yy490;
yy1086:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych == '0') goto yy495;
	goto yy490;
yy1087:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy1091;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy1090;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1088:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		if (yych <= '.') goto yy1091;
		goto yy490;
	} else {
		if (yych <= '2') goto yy1090;
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1089:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
		goto yy1091;
	} else {
		if (yych <= '/') goto yy490;
		if (yych <= '9') goto yy1083;
		if (yych <= ':') goto yy1084;
		goto yy490;
	}
yy1090:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy490;
		if (yych <= '-') goto yy601;
	} else {
		if (yych == ':') goto yy1084;
		goto yy490;
	}
yy1091:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '5') goto yy1092;
	if (yych <= '6') goto yy1093;
	if (yych <= '9') goto yy609;
	goto yy56;
yy1092:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy1094;
	goto yy490;
yy1093:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy496;
		goto yy490;
	} else {
		if (yych <= '0') goto yy1094;
		if (yych <= '9') goto yy610;
		goto yy490;
	}
yy1094:
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy496;
	if (yych <= '/') goto yy490;
	if (yych <= '9') goto yy604;
	goto yy490;
yy1095:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy459;
			if (yych <= ',') goto yy461;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy473;
			if (yych <= '/') goto yy471;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy482;
			if (yych == 'n') goto yy469;
			goto yy461;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy461;
		}
	}
yy1096:
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy1051;
			if (yych <= ',') goto yy1053;
			goto yy1050;
		} else {
			if (yych <= '.') goto yy1063;
			if (yych <= '/') goto yy471;
			if (yych <= '5') goto yy1065;
			goto yy740;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy1064;
			if (yych == 'n') goto yy469;
			goto yy1053;
		} else {
			if (yych <= 'r') goto yy470;
			if (yych <= 's') goto yy463;
			if (yych <= 't') goto yy467;
			goto yy1053;
		}
	}
yy1097:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1098;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1098:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1099;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1099:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1100;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1100:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy144;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'o') goto yy1101;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1101:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'U') goto yy1102;
		if (yych != 'u') goto yy3;
	}
yy1102:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1103;
	if (yych != 's') goto yy56;
yy1103:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1104;
	if (yych != ' ') goto yy56;
yy1104:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1105:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1104;
				if (yych <= 0x1F) goto yy56;
				goto yy1104;
			} else {
				if (yych == 'D') goto yy1109;
				if (yych <= 'E') goto yy56;
				goto yy1110;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1108;
				if (yych <= 'L') goto yy56;
				goto yy1107;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
				} else {
					if (yych <= 'T') goto yy1113;
					if (yych <= 'V') goto yy56;
					goto yy1112;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1111;
				if (yych <= 'c') goto yy56;
				goto yy1109;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1110;
				} else {
					if (yych == 'h') goto yy1108;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1107;
				if (yych <= 'r') goto yy56;
				if (yych >= 't') goto yy1113;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
					goto yy1112;
				} else {
					if (yych == 'y') goto yy1111;
					goto yy56;
				}
			}
		}
	}
yy1106:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy1178;
			goto yy56;
		} else {
			if (yych <= 'E') goto yy1179;
			if (yych <= 'T') goto yy56;
			goto yy1177;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy1178;
			goto yy56;
		} else {
			if (yych <= 'e') goto yy1179;
			if (yych == 'u') goto yy1177;
			goto yy56;
		}
	}
yy1107:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy1169;
		if (yych <= 'N') goto yy56;
		goto yy1168;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy56;
			goto yy1169;
		} else {
			if (yych == 'o') goto yy1168;
			goto yy56;
		}
	}
yy1108:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1166;
	if (yych == 'o') goto yy1166;
	goto yy56;
yy1109:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1165;
	if (yych == 'a') goto yy1165;
	goto yy56;
yy1110:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy1150;
		if (yych <= 'Q') goto yy56;
		goto yy1149;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy56;
			goto yy1150;
		} else {
			if (yych == 'r') goto yy1149;
			goto yy56;
		}
	}
yy1111:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1146;
	if (yych == 'e') goto yy1146;
	goto yy56;
yy1112:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1132;
	if (yych == 'e') goto yy1132;
	goto yy56;
yy1113:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy1114;
		if (yych <= 'T') goto yy56;
		goto yy1115;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
		} else {
			if (yych == 'u') goto yy1115;
			goto yy56;
		}
	}
yy1114:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1127;
	if (yych == 'u') goto yy1127;
	goto yy56;
yy1115:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1116;
	if (yych != 'e') goto yy56;
yy1116:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych >= ' ') goto yy1118;
	} else {
		if (yych <= 'S') {
			if (yych >= 'S') goto yy1120;
		} else {
			if (yych == 's') goto yy1120;
		}
	}
yy1117:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1118:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy56;
		goto yy1118;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy56;
			goto yy1124;
		} else {
			if (yych == 'o') goto yy1124;
			goto yy56;
		}
	}
yy1120:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1121;
	if (yych != 'd') goto yy56;
yy1121:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1122;
	if (yych != 'a') goto yy56;
yy1122:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych != 'y') goto yy56;
yy1123:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1118;
	if (yych == ' ') goto yy1118;
	goto yy1117;
yy1124:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1125;
	if (yych != 'f') goto yy56;
yy1125:
	++YYCURSOR;
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
yy1127:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy1117;
		} else {
			if (yych != 'r') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1129;
	if (yych != 's') goto yy56;
yy1129:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1130;
	if (yych != 'd') goto yy56;
yy1130:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1131;
	if (yych != 'a') goto yy56;
yy1131:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1132:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1134;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1134;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1140;
	if (yych == 'k') goto yy1140;
	goto yy56;
yy1134:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy1117;
		} else {
			if (yych != 'n') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1136;
	if (yych != 'e') goto yy56;
yy1136:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1137;
	if (yych != 's') goto yy56;
yy1137:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1138;
	if (yych != 'd') goto yy56;
yy1138:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1139;
	if (yych != 'a') goto yy56;
yy1139:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1140:
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy1143;
		if (yych >= 'S') goto yy1142;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy1143;
		} else {
			if (yych == 's') goto yy1142;
		}
	}
yy1141:
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1142:
	yych = *++YYCURSOR;
	goto yy1117;
yy1143:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1144;
	if (yych != 'a') goto yy56;
yy1144:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1145;
	if (yych != 'y') goto yy56;
yy1145:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1142;
	if (yych == 's') goto yy1142;
	goto yy1117;
yy1146:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1147;
	if (yych != 'a') goto yy56;
yy1147:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych != 'r') goto yy56;
yy1148:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1142;
	if (yych == 's') goto yy1142;
	goto yy1117;
yy1149:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1162;
	if (yych == 'i') goto yy1162;
	goto yy56;
yy1150:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1151;
	if (yych != 'r') goto yy56;
yy1151:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1152;
	if (yych != 't') goto yy56;
yy1152:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1154;
		if (yych <= 'M') goto yy56;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy56;
			goto yy1154;
		} else {
			if (yych != 'n') goto yy56;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1159;
	if (yych == 'i') goto yy1159;
	goto yy56;
yy1154:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1155;
	if (yych != 'n') goto yy56;
yy1155:
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1156;
	if (yych != 'i') goto yy56;
yy1156:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1157;
	if (yych != 'g') goto yy56;
yy1157:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1158;
	if (yych != 'h') goto yy56;
yy1158:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1148;
	if (yych == 't') goto yy1148;
	goto yy56;
yy1159:
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1160;
	if (yych != 'g') goto yy56;
yy1160:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1161;
	if (yych != 'h') goto yy56;
yy1161:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1148;
	if (yych == 't') goto yy1148;
	goto yy56;
yy1162:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1117;
		} else {
			if (yych != 'd') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1164;
	if (yych != 'a') goto yy56;
yy1164:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1165:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1148;
	if (yych == 'y') goto yy1148;
	goto yy56;
yy1166:
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1167;
	if (yych != 'u') goto yy56;
yy1167:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1148;
	if (yych == 'r') goto yy1148;
	goto yy56;
yy1168:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1173;
	if (yych == 'n') goto yy1173;
	goto yy56;
yy1169:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1170;
	if (yych != 'n') goto yy56;
yy1170:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1142;
		if (yych <= 'T') goto yy1117;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy1117;
			goto yy1142;
		} else {
			if (yych != 'u') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1172;
	if (yych != 't') goto yy56;
yy1172:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1148;
	if (yych == 'e') goto yy1148;
	goto yy56;
yy1173:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1118;
			goto yy1117;
		} else {
			if (yych <= ' ') goto yy1118;
			if (yych <= 'C') goto yy1117;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1175;
			goto yy1117;
		} else {
			if (yych <= 'd') goto yy1174;
			if (yych == 't') goto yy1175;
			goto yy1117;
		}
	}
yy1174:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1176;
	if (yych == 'a') goto yy1176;
	goto yy56;
yy1175:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1148;
	if (yych == 'h') goto yy1148;
	goto yy56;
yy1176:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1177:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1188;
	if (yych == 'n') goto yy1188;
	goto yy56;
yy1178:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1183;
	if (yych == 't') goto yy1183;
	goto yy56;
yy1179:
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1180;
	if (yych != 'c') goto yy56;
yy1180:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1181;
		if (yych <= 'R') goto yy1117;
		goto yy1142;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1117;
		} else {
			if (yych == 's') goto yy1142;
			goto yy1117;
		}
	}
yy1181:
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1182;
	if (yych != 'n') goto yy56;
yy1182:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1148;
	if (yych == 'd') goto yy1148;
	goto yy56;
yy1183:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy1117;
		} else {
			if (yych != 'u') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1185;
	if (yych != 'r') goto yy56;
yy1185:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1186;
	if (yych != 'd') goto yy56;
yy1186:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1187;
	if (yych != 'a') goto yy56;
yy1187:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1188:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1118;
		if (yych <= 0x1F) goto yy1117;
		goto yy1118;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy1117;
		} else {
			if (yych != 'd') goto yy1117;
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1190;
	if (yych != 'a') goto yy56;
yy1190:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1123;
	if (yych == 'y') goto yy1123;
	goto yy56;
yy1191:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1098;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1192;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1192:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1099;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1193;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1193:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1100;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1194;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1194:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1101;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'o') goto yy1195;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1195:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy1102;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'u') goto yy1196;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1196:
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1103;
	if (yych != 's') goto yy154;
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1104;
		} else {
			if (yych == ' ') goto yy1104;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1198:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy141;
			goto yy1212;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'g') goto yy1212;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1199:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1200;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1200:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'U') goto yy142;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'v') goto yy1201;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1201:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1202;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1202:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy144;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'n') goto yy1203;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1203:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy1204;
		if (yych != 't') goto yy3;
	}
yy1204:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy56;
yy1205:
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1206;
	if (yych != ' ') goto yy56;
yy1206:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy1207:
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy1206;
				if (yych <= 0x1F) goto yy56;
				goto yy1206;
			} else {
				if (yych == 'D') goto yy1109;
				if (yych <= 'E') goto yy56;
				goto yy1110;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy1108;
				if (yych <= 'L') goto yy56;
				goto yy1107;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy56;
					goto yy1106;
				} else {
					if (yych <= 'T') goto yy1113;
					if (yych <= 'V') goto yy56;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy1111;
				if (yych <= 'c') goto yy56;
				goto yy1109;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy56;
					goto yy1110;
				} else {
					if (yych == 'h') goto yy1108;
					goto yy56;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy1107;
				if (yych <= 'r') goto yy56;
				if (yych <= 's') goto yy1106;
				goto yy1113;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy56;
				} else {
					if (yych == 'y') goto yy1111;
					goto yy56;
				}
			}
		}
	}
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1209;
	if (yych != 'e') goto yy56;
yy1209:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy56;
		if (yych <= 'D') goto yy1134;
	} else {
		if (yych <= 'c') goto yy56;
		if (yych <= 'd') goto yy1134;
		if (yych >= 'f') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1211;
	if (yych != 'k') goto yy56;
yy1211:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy1143;
		if (yych <= 'R') goto yy56;
		goto yy1142;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy56;
			goto yy1143;
		} else {
			if (yych == 's') goto yy1142;
			goto yy56;
		}
	}
yy1212:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy142;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'h') goto yy1213;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1213:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1214;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1214:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych == ')') goto yy139;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy1215;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1215:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy1206;
		goto yy3;
	} else {
		if (yych <= ' ') goto yy1206;
		if (yych == ')') goto yy139;
		goto yy3;
	}
yy1216:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1212;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'g') goto yy1224;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1217:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1200;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1218;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1218:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy1201;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'v') goto yy1219;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1219:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1202;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1220;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1220:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1203;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'n') goto yy1221;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1221:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy1204;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 't') goto yy1222;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1222:
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1205;
	if (yych != 'h') goto yy154;
yy1223:
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy56;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy56;
		}
	} else {
		if (yych <= '/') {
			if (yych == '.') goto yy56;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy56;
		}
	}
yy1224:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1213;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'h') goto yy1225;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1225:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1214;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1226;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1226:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy3;
				goto yy1206;
			} else {
				if (yych == ' ') goto yy1206;
				goto yy3;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy3;
				goto yy144;
			} else {
				if (yych <= 'H') goto yy1215;
				if (yych <= 'Z') goto yy144;
				goto yy3;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1227:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1206;
			goto yy3;
		} else {
			if (yych <= ' ') goto yy1206;
			if (yych <= '(') goto yy3;
			goto yy139;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy147;
			goto yy3;
		} else {
			if (yych <= '/') goto yy147;
			if (yych == '_') goto yy147;
			goto yy3;
		}
	}
yy1228:
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy1244;
				goto yy141;
			} else {
				if (yych <= 'P') goto yy1246;
				if (yych <= 'U') goto yy141;
				goto yy1245;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych == 'c') goto yy1244;
				goto yy141;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy1246;
				goto yy141;
			} else {
				if (yych <= 'v') goto yy1245;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1229:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy141;
			goto yy1239;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 't') goto yy1239;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1230:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1236;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1236;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1231:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1232;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1232:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1233;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1233:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1234;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1234:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1235:
	yych = *++YYCURSOR;
	if (yych == ')') goto yy139;
	goto yy166;
yy1236:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1237;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1237:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1238:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych == ' ') goto yy1206;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1239:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'T') goto yy142;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'u') goto yy1240;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1240:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1241;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1241:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1242;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1242:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1243;
		if (yych != 'a') goto yy3;
	}
yy1243:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1244:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
			goto yy1255;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1255;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1245:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy142;
			goto yy1252;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'e') goto yy1252;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1246:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'T') goto yy142;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 't') goto yy1247;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1247:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy143;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'e') goto yy1248;
				if (yych <= 'z') goto yy143;
				goto yy193;
			}
		}
	}
yy1248:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy144;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'm') goto yy1249;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1249:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'B') goto yy1250;
		if (yych != 'b') goto yy3;
	}
yy1250:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy56;
yy1251:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy205;
	goto yy56;
yy1252:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1253;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1253:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1254;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1254:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1255:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy143;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'n') goto yy1256;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1256:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
			goto yy1215;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1257:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy139;
				goto yy3;
			} else {
				if (yych == '.') goto yy3;
				goto yy147;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy3;
				if (yych <= 'B') goto yy141;
				goto yy1244;
			} else {
				if (yych == 'P') goto yy1246;
				goto yy141;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy1245;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy1273;
				if (yych <= 'o') goto yy146;
				goto yy1275;
			} else {
				if (yych == 'v') goto yy1274;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1258:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1239;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 't') goto yy1268;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1259:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1236;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1265;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1260:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1232;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1261;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1261:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1233;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1262;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1262:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1234;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1263;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1263:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1264:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy139;
		if (yych <= ',') goto yy166;
		goto yy147;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy166;
			goto yy147;
		} else {
			if (yych == '_') goto yy147;
			goto yy166;
		}
	}
yy1265:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1237;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1266;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1266:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1267:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1206;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1268:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1240;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'u') goto yy1269;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1269:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1241;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1270;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1270:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1242;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1271;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1271:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1243;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1272;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1272:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1273:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1255;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1284;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1274:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1252;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1281;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1275:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'T') goto yy1247;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1276;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1276:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy143;
			} else {
				if (yych <= 'E') goto yy1248;
				if (yych <= 'Z') goto yy143;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1277;
				if (yych <= 'z') goto yy151;
				goto yy193;
			}
		}
	}
yy1277:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1249;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'm') goto yy1278;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1278:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy1250;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'b') goto yy1279;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1279:
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1251;
	if (yych != 'e') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy376;
	goto yy154;
yy1281:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1253;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1282;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1282:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1254;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1283;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1283:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1284:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1256;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'n') goto yy1285;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1285:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1215;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1286:
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'B') goto yy141;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'c') goto yy1287;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1287:
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'J') goto yy142;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'k') goto yy1288;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1288:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1289;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1289:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1290;
	if (yych != 'o') goto yy56;
yy1290:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1291;
	if (yych != 'f') goto yy56;
yy1291:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1293;
	if (yych <= '2') goto yy1295;
	if (yych <= '9') goto yy1296;
	goto yy56;
yy1293:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1297;
	if (yych <= '9') goto yy1296;
	goto yy1297;
yy1294:
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1295:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1297;
	if (yych >= '5') goto yy1297;
yy1296:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1297:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1296;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1296;
			if (yych <= '@') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1294;
		} else {
			if (yych <= 'a') goto yy1298;
			if (yych != 'p') goto yy1294;
		}
	}
yy1298:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1300;
		if (yych == 'm') goto yy1300;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1300;
	if (yych != 'm') goto yy56;
yy1300:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1302;
		if (yych == '\t') goto yy1302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1302;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1302;
		if (yych <= 0x08) goto yy56;
	} else {
		if (yych != ' ') goto yy56;
	}
yy1302:
	yych = *++YYCURSOR;
	goto yy1294;
yy1303:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy1287;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'c') goto yy1304;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1304:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy1288;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'k') goto yy1305;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1305:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1289;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1306:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1307;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1307:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1308;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1308:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1104;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1309:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1310;
	if (yych != 'd') goto yy1105;
yy1310:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1311;
	if (yych != 'a') goto yy56;
yy1311:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1312;
	if (yych != 'y') goto yy56;
yy1312:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1117;
	} else {
		if (yych <= 'S') goto yy1142;
		if (yych == 's') goto yy1142;
		goto yy1117;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1314;
	if (yych != 'o') goto yy56;
yy1314:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1315;
	if (yych != 'f') goto yy56;
yy1315:
	++YYCURSOR;
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
yy1317:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1307;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1318;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1318:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1308;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1319;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1319:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1104;
			if (yych <= 0x1F) goto yy3;
			goto yy1309;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1320:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy141;
			goto yy1356;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'b') goto yy1356;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1321:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'F') goto yy1346;
			if (yych <= 'Q') goto yy141;
			goto yy1345;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'e') goto yy141;
			goto yy1346;
		} else {
			if (yych == 'r') goto yy1345;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1322:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy141;
			goto yy1342;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'u') goto yy1342;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1323:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1325;
			if (yych <= 'N') goto yy141;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1325;
		} else {
			if (yych == 'o') goto yy1324;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1324:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1328;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1328;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1325:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1326;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1326:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1327;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1327:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1328:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1329;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1329:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy1330;
		if (yych <= '(') goto yy3;
		goto yy139;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1330:
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1331;
	if (yych != 'o') goto yy56;
yy1331:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1332;
	if (yych != 'f') goto yy56;
yy1332:
	yych = *++YYCURSOR;
	if (yych != ' ') goto yy56;
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '1') goto yy1334;
	if (yych <= '2') goto yy1335;
	if (yych <= '9') goto yy1336;
	goto yy56;
yy1334:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych <= '9') goto yy1336;
	goto yy1337;
yy1335:
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1337;
	if (yych >= '5') goto yy1337;
yy1336:
	yyaccept = 28;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
yy1337:
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1336;
			goto yy1294;
		} else {
			if (yych <= ' ') goto yy1336;
			if (yych <= '@') goto yy1294;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy1294;
		} else {
			if (yych <= 'a') goto yy1338;
			if (yych != 'p') goto yy1294;
		}
	}
yy1338:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych != '.') goto yy56;
	} else {
		if (yych <= 'M') goto yy1340;
		if (yych == 'm') goto yy1340;
		goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1340;
	if (yych != 'm') goto yy56;
yy1340:
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1302;
		if (yych == '\t') goto yy1302;
		goto yy56;
	} else {
		if (yych <= ' ') goto yy1302;
		if (yych != '.') goto yy56;
	}
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1302;
		if (yych <= 0x08) goto yy56;
		goto yy1302;
	} else {
		if (yych == ' ') goto yy1302;
		goto yy56;
	}
yy1342:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1343;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1343:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1344;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1344:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy144;
			goto yy1215;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'h') goto yy1215;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1345:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy142;
			goto yy1348;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1348;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1346:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1347;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1347:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1348:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy143;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 't') goto yy1349;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1349:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1206;
		} else {
			if (yych != ' ') goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1350:
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1351;
	if (yych != 'd') goto yy1207;
yy1351:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1352;
	if (yych != 'a') goto yy56;
yy1352:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1353;
	if (yych != 'y') goto yy56;
yy1353:
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych != ' ') goto yy1117;
	} else {
		if (yych <= 'S') goto yy1142;
		if (yych == 's') goto yy1142;
		goto yy1117;
	}
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1355;
	if (yych != 'o') goto yy56;
yy1355:
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1315;
	if (yych == 'f') goto yy1315;
	goto yy56;
yy1356:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'R') goto yy142;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'r') goto yy1357;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1357:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'T') goto yy143;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'u') goto yy1358;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1358:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1359;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1359:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'R') goto yy1360;
		if (yych != 'r') goto yy3;
	}
yy1360:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy205;
	if (yych == 'y') goto yy205;
	goto yy56;
yy1361:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1356;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'b') goto yy1379;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1362:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'F') goto yy1346;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy1345;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy1375;
				goto yy146;
			} else {
				if (yych <= 'r') goto yy1374;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1363:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1342;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1371;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1364:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1325;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy1324;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy1366;
				goto yy146;
			} else {
				if (yych <= 'o') goto yy1365;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1365:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1328;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1369;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1366:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1326;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1367;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1367:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1327;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1368;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1368:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1369:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1329;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1370;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1370:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy1330;
			goto yy3;
		} else {
			if (yych <= ')') goto yy139;
			if (yych == '-') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy147;
			if (yych <= '@') goto yy3;
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1371:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1343;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1372;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1372:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1344;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1373;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1373:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1215;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'h') goto yy1227;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1374:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1348;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1377;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1375:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1347;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1376;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1376:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1377:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1349;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 't') goto yy1378;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1378:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1206;
			if (yych <= 0x1F) goto yy3;
			goto yy1350;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1379:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'R') goto yy1357;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1380;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1380:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy1358;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'u') goto yy1381;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1381:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1359;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1382;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1382:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy1360;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'r') goto yy1383;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1383:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy205;
	if (yych == 'y') goto yy376;
	goto yy154;
yy1384:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
yy1385:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy1387;
	if (yych <= '9') goto yy1385;
yy1387:
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1388:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
			goto yy1429;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1429;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1389:
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'I') goto yy1421;
			if (yych <= 'T') goto yy141;
			goto yy1422;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'h') goto yy141;
			goto yy1421;
		} else {
			if (yych == 'u') goto yy1422;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1390:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'D') goto yy1410;
			if (yych <= 'L') goto yy141;
			goto yy1411;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'c') goto yy141;
			goto yy1410;
		} else {
			if (yych == 'm') goto yy1411;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1391:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1406;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1406;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1392:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy141;
			goto yy1402;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'e') goto yy1402;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1393:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '9') goto yy1396;
		if (yych <= ':') goto yy1064;
		goto yy56;
	}
yy1394:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '4') goto yy1396;
		if (yych == ':') goto yy1064;
		goto yy56;
	}
yy1395:
	yych = *++YYCURSOR;
	if (yych == '.') goto yy1064;
	if (yych == ':') goto yy1064;
	goto yy56;
yy1396:
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy1064;
		goto yy56;
	} else {
		if (yych <= '5') goto yy1397;
		if (yych == ':') goto yy1064;
		goto yy56;
	}
yy1397:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych >= ':') goto yy56;
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy1067;
	if (yych <= '5') goto yy1399;
	if (yych <= '6') goto yy1400;
	goto yy1067;
yy1399:
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy56;
	if (yych <= '9') goto yy1401;
	goto yy56;
yy1400:
	yych = *++YYCURSOR;
	if (yych != '0') goto yy56;
yy1401:
	yych = *++YYCURSOR;
	goto yy1075;
yy1402:
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'K') goto yy142;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'l') goto yy1403;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1403:
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'E') goto yy143;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'f') goto yy1404;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1404:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy144;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 't') goto yy1405;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1405:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1205;
		if (yych == 'h') goto yy1205;
		goto yy3;
	}
yy1406:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'R') goto yy142;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 's') goto yy1407;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1407:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1408;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1408:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy144;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1409;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1409:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'Y') goto yy172;
		if (yych == 'y') goto yy172;
		goto yy3;
	}
yy1410:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
		goto yy1418;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy142;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1418;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1411:
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'N') goto yy142;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'o') goto yy1412;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1412:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy143;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'r') goto yy1413;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1413:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1414;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1414:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'O') goto yy1415;
		if (yych != 'o') goto yy3;
	}
yy1415:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy56;
yy1416:
	++YYCURSOR;
yy1417:
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1418:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy143;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'y') goto yy1419;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1419:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy144;
		if (yych <= '`') goto yy1420;
		if (yych <= 'z') goto yy144;
	}
yy1420:
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1421:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych <= 'Q') goto yy142;
			if (yych <= 'R') goto yy1427;
			goto yy1428;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1427;
			if (yych <= 's') goto yy1428;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1422:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'Q') goto yy142;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'r') goto yy1423;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1423:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy143;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 's') goto yy1424;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1424:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy144;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'd') goto yy1425;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1425:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'A') goto yy1426;
		if (yych != 'a') goto yy3;
	}
yy1426:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy172;
	goto yy56;
yy1427:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'd') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1428:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy3;
			goto yy1104;
		} else {
			if (yych == ' ') goto yy1104;
			goto yy3;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1429:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1430;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1430:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1431:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1429;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1461;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1432:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'I') goto yy1421;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy1422;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy1453;
				goto yy146;
			} else {
				if (yych <= 'u') goto yy1454;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1433:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'D') goto yy1410;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy1411;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy1444;
				goto yy146;
			} else {
				if (yych <= 'm') goto yy1445;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1434:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1406;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1440;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1435:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1402;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'e') goto yy1436;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1436:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy1403;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'l') goto yy1437;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1437:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy1404;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'f') goto yy1438;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1438:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1405;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 't') goto yy1439;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1439:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1205;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1223;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1440:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1407;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 's') goto yy1441;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1441:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1408;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1442;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1442:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1409;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1443;
			if (yych <= 'z') goto yy152;
			goto yy3;
		}
	}
yy1443:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy172;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'y') goto yy185;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1444:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1418;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1451;
			if (yych <= 'z') goto yy150;
			goto yy3;
		}
	}
yy1445:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy1412;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'o') goto yy1446;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1446:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1413;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'r') goto yy1447;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1447:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1414;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1448;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1448:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy1415;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'o') goto yy1449;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1449:
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1416;
	if (yych != 'w') goto yy154;
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1417;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1417;
	}
yy1451:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1419;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'y') goto yy1452;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1452:
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1420;
		} else {
			if (yych == '.') goto yy1420;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1420;
			if (yych <= 'Z') goto yy144;
			goto yy1420;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1420;
			if (yych <= 'z') goto yy152;
			goto yy1420;
		}
	}
yy1453:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy3;
				goto yy147;
			} else {
				if (yych <= '@') goto yy3;
				if (yych <= 'Q') goto yy142;
				goto yy1427;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy1428;
				goto yy142;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy150;
				goto yy1459;
			} else {
				if (yych <= 's') goto yy1460;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1454:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1423;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'r') goto yy1455;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1455:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1424;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 's') goto yy1456;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1456:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1425;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'd') goto yy1457;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1457:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1426;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1458;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1458:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy172;
	if (yych == 'y') goto yy185;
	goto yy154;
yy1459:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'd') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1460:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1104;
			if (yych <= 0x1F) goto yy3;
			goto yy1104;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy3;
				goto yy147;
			} else {
				if (yych <= '`') goto yy3;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1461:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1430;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1462;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1462:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1463:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == 'R') goto yy1475;
			if (yych <= 'X') goto yy141;
			goto yy1476;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'q') goto yy141;
			goto yy1475;
		} else {
			if (yych == 'y') goto yy1476;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1464:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'C') goto yy141;
			goto yy1469;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'd') goto yy1469;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1465:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1466;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1466:
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy166;
			goto yy139;
		} else {
			if (yych <= '@') goto yy166;
			if (yych <= 'C') goto yy142;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy166;
			goto yy142;
		} else {
			if (yych <= 'd') goto yy1467;
			if (yych <= 'z') goto yy142;
			goto yy166;
		}
	}
yy1467:
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy139;
		if (yych <= '@') goto yy3;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy143;
			goto yy3;
		} else {
			if (yych <= 'a') goto yy1468;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1468:
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'X') goto yy144;
			goto yy1235;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'y') goto yy1235;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1469:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1470;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1470:
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'H') goto yy143;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'i') goto yy1471;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1471:
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'F') goto yy144;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'g') goto yy1472;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1472:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'H') goto yy1473;
		if (yych != 'h') goto yy3;
	}
yy1473:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy56;
yy1474:
	yych = *++YYCURSOR;
	goto yy1420;
yy1475:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych == 'C') goto yy1477;
				goto yy142;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'c') goto yy1477;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1476:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy193;
			goto yy196;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy193;
			if (yych <= '9') goto yy195;
			goto yy193;
		} else {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy193;
			if (yych <= 'z') goto yy142;
			goto yy193;
		}
	}
yy1477:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy395;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy395;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1478:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy147;
				goto yy3;
			} else {
				if (yych == 'R') goto yy1475;
				goto yy141;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy1476;
				goto yy141;
			} else {
				if (yych == '_') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy1490;
				goto yy146;
			} else {
				if (yych <= 'y') goto yy1491;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1479:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1469;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'd') goto yy1484;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1480:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1466;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1481;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1481:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy166;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy166;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy1467;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy166;
			goto yy147;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy166;
				goto yy150;
			} else {
				if (yych <= 'd') goto yy1482;
				if (yych <= 'z') goto yy150;
				goto yy166;
			}
		}
	}
yy1482:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy1468;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= '`') goto yy3;
			if (yych <= 'a') goto yy1483;
			if (yych <= 'z') goto yy151;
			goto yy3;
		}
	}
yy1483:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy1235;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'y') goto yy1264;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1484:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1470;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1485;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1485:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy1471;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'i') goto yy1486;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1486:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy1472;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'g') goto yy1487;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1487:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy1473;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'h') goto yy1488;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1488:
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1474;
	if (yych != 't') goto yy154;
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1420;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1420;
	}
yy1490:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'C') goto yy1477;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'c') goto yy1492;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1491:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy195;
			if (yych <= 0x1F) goto yy193;
			goto yy195;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy193;
				goto yy139;
			} else {
				if (yych <= ',') goto yy193;
				if (yych <= '-') goto yy371;
				goto yy195;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy147;
			if (yych <= '9') goto yy195;
			if (yych <= '@') goto yy193;
			goto yy142;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy193;
				goto yy147;
			} else {
				if (yych <= '`') goto yy193;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1492:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy395;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy406;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1493:
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy139;
			if (yych <= '@') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'O') goto yy1501;
			if (yych <= 'U') goto yy141;
			if (yych <= 'V') goto yy1502;
			goto yy1499;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			if (yych <= 'n') goto yy141;
			goto yy1501;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy141;
				goto yy1502;
			} else {
				if (yych <= 'w') goto yy1499;
				if (yych <= 'z') goto yy141;
				goto yy3;
			}
		}
	}
yy1494:
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'W') goto yy141;
			goto yy1498;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'x') goto yy1498;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1495:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy141;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 'n') goto yy1496;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1496:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1497;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1497:
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'G') goto yy143;
			goto yy1238;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'h') goto yy1238;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1498:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
			goto yy1428;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1428;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1499:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy142;
		if (yych <= '`') goto yy1500;
		if (yych <= 'z') goto yy142;
	}
yy1500:
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1501:
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'M') goto yy142;
			goto yy1507;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 'n') goto yy1507;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1502:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy139;
				goto yy193;
			} else {
				if (yych <= '-') goto yy196;
				if (yych <= '.') goto yy195;
				goto yy193;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy195;
				goto yy193;
			} else {
				if (yych != 'E') goto yy142;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'e') goto yy1503;
				if (yych <= 'z') goto yy142;
				goto yy193;
			}
		}
	}
yy1503:
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'L') goto yy143;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'm') goto yy1504;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1504:
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'A') goto yy144;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'b') goto yy1505;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1505:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'E') goto yy1506;
		if (yych != 'e') goto yy3;
	}
yy1506:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy205;
	goto yy56;
yy1507:
	++YYCURSOR;
	if ((yych = *YYCURSOR) <= '@') {
		if (yych == ')') goto yy139;
	} else {
		if (yych <= 'Z') goto yy143;
		if (yych <= '`') goto yy1508;
		if (yych <= 'z') goto yy143;
	}
yy1508:
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1509:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy3;
				goto yy139;
			} else {
				if (yych == '-') goto yy147;
				goto yy3;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy147;
				if (yych <= '@') goto yy3;
				goto yy141;
			} else {
				if (yych <= 'O') goto yy1501;
				if (yych <= 'U') goto yy141;
				goto yy1502;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy1499;
				if (yych <= 'Z') goto yy141;
				goto yy3;
			} else {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy3;
				goto yy146;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy1516;
				if (yych <= 'u') goto yy146;
				goto yy1517;
			} else {
				if (yych <= 'w') goto yy1515;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1510:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy1498;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'x') goto yy1514;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1511:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1496;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 'n') goto yy1512;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1512:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1497;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1513;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1513:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy1238;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'h') goto yy1267;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1514:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1428;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1460;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1515:
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1500;
		} else {
			if (yych == '.') goto yy1500;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1500;
			if (yych <= 'Z') goto yy142;
			goto yy1500;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1500;
			if (yych <= 'z') goto yy150;
			goto yy1500;
		}
	}
yy1516:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy1507;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 'n') goto yy1522;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1517:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy193;
				goto yy195;
			} else {
				if (yych == ' ') goto yy195;
				goto yy193;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy139;
				if (yych <= ',') goto yy193;
				goto yy371;
			} else {
				if (yych == '/') goto yy147;
				goto yy195;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy193;
				goto yy142;
			} else {
				if (yych <= 'E') goto yy1503;
				if (yych <= 'Z') goto yy142;
				goto yy193;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy147;
				if (yych <= '`') goto yy193;
				goto yy150;
			} else {
				if (yych <= 'e') goto yy1518;
				if (yych <= 'z') goto yy150;
				goto yy193;
			}
		}
	}
yy1518:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy1504;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'm') goto yy1519;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1519:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy1505;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'b') goto yy1520;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1520:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy1506;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'e') goto yy1521;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1521:
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy205;
	if (yych == 'r') goto yy376;
	goto yy154;
yy1522:
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy1508;
		} else {
			if (yych == '.') goto yy1508;
			goto yy147;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy1508;
			if (yych <= 'Z') goto yy143;
			goto yy1508;
		} else {
			if (yych <= '_') goto yy147;
			if (yych <= '`') goto yy1508;
			if (yych <= 'z') goto yy151;
			goto yy1508;
		}
	}
yy1523:
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'R') goto yy141;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy141;
			if (yych <= '`') goto yy3;
			goto yy141;
		} else {
			if (yych <= 's') goto yy1524;
			if (yych <= 'z') goto yy141;
			goto yy3;
		}
	}
yy1524:
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'S') goto yy142;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy142;
			if (yych <= '`') goto yy3;
			goto yy142;
		} else {
			if (yych <= 't') goto yy1525;
			if (yych <= 'z') goto yy142;
			goto yy3;
		}
	}
yy1525:
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'D') goto yy143;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy143;
			if (yych <= '`') goto yy3;
			goto yy143;
		} else {
			if (yych <= 'e') goto yy1526;
			if (yych <= 'z') goto yy143;
			goto yy3;
		}
	}
yy1526:
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy3;
			goto yy139;
		} else {
			if (yych <= '@') goto yy3;
			if (yych <= 'Q') goto yy144;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy144;
			if (yych <= '`') goto yy3;
			goto yy144;
		} else {
			if (yych <= 'r') goto yy1527;
			if (yych <= 'z') goto yy144;
			goto yy3;
		}
	}
yy1527:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy139;
		goto yy3;
	} else {
		if (yych <= 'D') goto yy1528;
		if (yych != 'd') goto yy3;
	}
yy1528:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy56;
yy1529:
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy56;
yy1530:
	++YYCURSOR;
yy1531:
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
yy1532:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy141;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy1524;
			if (yych <= 'Z') goto yy141;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy3;
				goto yy146;
			} else {
				if (yych <= 's') goto yy1533;
				if (yych <= 'z') goto yy146;
				goto yy3;
			}
		}
	}
yy1533:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy142;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy1525;
			if (yych <= 'Z') goto yy142;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy3;
				goto yy150;
			} else {
				if (yych <= 't') goto yy1534;
				if (yych <= 'z') goto yy150;
				goto yy3;
			}
		}
	}
yy1534:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy143;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy1526;
			if (yych <= 'Z') goto yy143;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy3;
				goto yy151;
			} else {
				if (yych <= 'e') goto yy1535;
				if (yych <= 'z') goto yy151;
				goto yy3;
			}
		}
	}
yy1535:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy139;
			if (yych <= ',') goto yy3;
			goto yy147;
		} else {
			if (yych == '/') goto yy147;
			if (yych <= '@') goto yy3;
			goto yy144;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy1527;
			if (yych <= 'Z') goto yy144;
			if (yych <= '^') goto yy3;
			goto yy147;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy3;
				goto yy152;
			} else {
				if (yych <= 'r') goto yy1536;
				if (yych <= 'z') goto yy152;
				goto yy3;
			}
		}
	}
yy1536:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy139;
			goto yy3;
		} else {
			if (yych == '.') goto yy3;
			if (yych <= '/') goto yy147;
			goto yy3;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy1528;
			if (yych == '_') goto yy147;
			goto yy3;
		} else {
			if (yych == 'd') goto yy1537;
			if (yych <= 'z') goto yy153;
			goto yy3;
		}
	}
yy1537:
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1529;
	if (yych != 'a') goto yy154;
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1530;
	if (yych != 'y') goto yy154;
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy153;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy147;
		goto yy1531;
	} else {
		if (yych <= '/') goto yy147;
		if (yych == '_') goto yy147;
		goto yy1531;
	}
}

}

#define YYMAXFILL 31

timelib_time* timelib_strtotime(char *s, size_t len, struct timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->f = 0.0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->f == TIMELIB_UNSET ) time->f = 0.0;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	char       *fptr = format;
	char       *ptr = string;
	char       *begin;
	timelib_sll tmp;
	Scanner in;
	Scanner *s = &in;
	int allow_extra = 0;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->f = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;
		switch (*fptr) {
			case 'D': /* three letter day */
			case 'l': /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case 'd': /* two digit day, with leading zero */
			case 'j': /* two digit day, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit day could not be found", string, begin);
				}
				break;
			case 'S': /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case 'z': /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case 'm': /* two digit month, with leading zero */
			case 'n': /* two digit month, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit month could not be found", string, begin);
				}
				break;
			case 'M': /* three letter month */
			case 'F': /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case 'y': /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case 'Y': /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A four digit year could not be found", string, begin);
				}
				break;
			case 'g': /* two digit hour, with leading zero */
			case 'h': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, "Hour can not be higher than 12", string, begin);
				}
				break;
			case 'G': /* two digit hour, with leading zero */
			case 'H': /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A two digit hour could not be found", string, begin);
				}
				break;
			case 'a': /* am/pm/a.m./p.m. */
			case 'A': /* AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case 'i': /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case 's': /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case 'u': /* up to six digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, "A six digit millisecond could not be found", string, begin);
					} else {
						s->time->f = (f / pow(10, (ptr - tptr)));
					}
				}
				break;
			case ' ': /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case 'U': /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				TIMELIB_HAVE_RELATIVE();
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->y = 1970;
				s->time->m = 1;
				s->time->d = 1;
				s->time->h = s->time->i = s->time->s = 0;
				s->time->f = 0.0;
				s->time->relative.s += tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				break;

			case 'e': /* timezone */
			case 'P': /* timezone */
			case 'T': /* timezone */
			case 'O': /* timezone */
				{
					int tz_not_found;
					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, "The timezone could not be found in the database", string, begin);
					}
				}
				break;

			case '#': /* separation symbol */
				if (*ptr == ';' || *ptr == ':' || *ptr == '/' || *ptr == '.' || *ptr == ',' || *ptr == '-' || *ptr == '(' || *ptr == ')') {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case ';':
			case ':':
			case '/':
			case '.':
			case ',':
			case '-':
			case '(':
			case ')':
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The separation symbol could not be found", string, begin);
				}
				break;

			case '!': /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case '|': /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case '?': /* random char */
				++ptr;
				break;

			case '\\': /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, "The escaped character could not be found", string, begin);
				}
				break;

			case '*': /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case '+': /* allow extra chars in the format */
				allow_extra = 1;
				break;

			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, "Trailing data", string, ptr);
		}
	}
	/* ignore trailing +'s */
	while (*fptr == '+') {
		fptr++;
	}
	if (*fptr) {
		/* Trailing | and ! specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (*fptr++) {
				case '!': /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case '|': /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;

				default:
					add_pbf_error(s, "Data missing", string, ptr);
					done = 1;
			}
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->f == TIMELIB_UNSET) parsed->f = now->f != TIMELIB_UNSET ? now->f : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
