require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_TIPC_CONFIG_H_)) {
    eval 'sub _LINUX_TIPC_CONFIG_H_ () {1;}' unless defined(&_LINUX_TIPC_CONFIG_H_);
    require 'linux/types.ph';
    require 'linux/string.ph';
    require 'linux/tipc.ph';
    require 'asm/byteorder.ph';
    require 'arpa/inet.ph';
    eval 'sub TIPC_CMD_NOOP () {0x;}' unless defined(&TIPC_CMD_NOOP);
    eval 'sub TIPC_CMD_GET_NODES () {0x1;}' unless defined(&TIPC_CMD_GET_NODES);
    eval 'sub TIPC_CMD_GET_MEDIA_NAMES () {0x2;}' unless defined(&TIPC_CMD_GET_MEDIA_NAMES);
    eval 'sub TIPC_CMD_GET_BEARER_NAMES () {0x3;}' unless defined(&TIPC_CMD_GET_BEARER_NAMES);
    eval 'sub TIPC_CMD_GET_LINKS () {0x4;}' unless defined(&TIPC_CMD_GET_LINKS);
    eval 'sub TIPC_CMD_SHOW_NAME_TABLE () {0x5;}' unless defined(&TIPC_CMD_SHOW_NAME_TABLE);
    eval 'sub TIPC_CMD_SHOW_PORTS () {0x6;}' unless defined(&TIPC_CMD_SHOW_PORTS);
    eval 'sub TIPC_CMD_SHOW_LINK_STATS () {0xb;}' unless defined(&TIPC_CMD_SHOW_LINK_STATS);
    eval 'sub TIPC_CMD_SHOW_STATS () {0xf;}' unless defined(&TIPC_CMD_SHOW_STATS);
    eval 'sub TIPC_CMD_GET_REMOTE_MNG () {0x4003;}' unless defined(&TIPC_CMD_GET_REMOTE_MNG);
    eval 'sub TIPC_CMD_GET_MAX_PORTS () {0x4004;}' unless defined(&TIPC_CMD_GET_MAX_PORTS);
    eval 'sub TIPC_CMD_GET_MAX_PUBL () {0x4005;}' unless defined(&TIPC_CMD_GET_MAX_PUBL);
    eval 'sub TIPC_CMD_GET_MAX_SUBSCR () {0x4006;}' unless defined(&TIPC_CMD_GET_MAX_SUBSCR);
    eval 'sub TIPC_CMD_GET_MAX_ZONES () {0x4007;}' unless defined(&TIPC_CMD_GET_MAX_ZONES);
    eval 'sub TIPC_CMD_GET_MAX_CLUSTERS () {0x4008;}' unless defined(&TIPC_CMD_GET_MAX_CLUSTERS);
    eval 'sub TIPC_CMD_GET_MAX_NODES () {0x4009;}' unless defined(&TIPC_CMD_GET_MAX_NODES);
    eval 'sub TIPC_CMD_GET_MAX_SLAVES () {0x400a;}' unless defined(&TIPC_CMD_GET_MAX_SLAVES);
    eval 'sub TIPC_CMD_GET_NETID () {0x400b;}' unless defined(&TIPC_CMD_GET_NETID);
    eval 'sub TIPC_CMD_ENABLE_BEARER () {0x4101;}' unless defined(&TIPC_CMD_ENABLE_BEARER);
    eval 'sub TIPC_CMD_DISABLE_BEARER () {0x4102;}' unless defined(&TIPC_CMD_DISABLE_BEARER);
    eval 'sub TIPC_CMD_SET_LINK_TOL () {0x4107;}' unless defined(&TIPC_CMD_SET_LINK_TOL);
    eval 'sub TIPC_CMD_SET_LINK_PRI () {0x4108;}' unless defined(&TIPC_CMD_SET_LINK_PRI);
    eval 'sub TIPC_CMD_SET_LINK_WINDOW () {0x4109;}' unless defined(&TIPC_CMD_SET_LINK_WINDOW);
    eval 'sub TIPC_CMD_SET_LOG_SIZE () {0x410a;}' unless defined(&TIPC_CMD_SET_LOG_SIZE);
    eval 'sub TIPC_CMD_DUMP_LOG () {0x410b;}' unless defined(&TIPC_CMD_DUMP_LOG);
    eval 'sub TIPC_CMD_RESET_LINK_STATS () {0x410c;}' unless defined(&TIPC_CMD_RESET_LINK_STATS);
    eval 'sub TIPC_CMD_SET_NODE_ADDR () {0x8001;}' unless defined(&TIPC_CMD_SET_NODE_ADDR);
    eval 'sub TIPC_CMD_SET_REMOTE_MNG () {0x8003;}' unless defined(&TIPC_CMD_SET_REMOTE_MNG);
    eval 'sub TIPC_CMD_SET_MAX_PORTS () {0x8004;}' unless defined(&TIPC_CMD_SET_MAX_PORTS);
    eval 'sub TIPC_CMD_SET_MAX_PUBL () {0x8005;}' unless defined(&TIPC_CMD_SET_MAX_PUBL);
    eval 'sub TIPC_CMD_SET_MAX_SUBSCR () {0x8006;}' unless defined(&TIPC_CMD_SET_MAX_SUBSCR);
    eval 'sub TIPC_CMD_SET_MAX_ZONES () {0x8007;}' unless defined(&TIPC_CMD_SET_MAX_ZONES);
    eval 'sub TIPC_CMD_SET_MAX_CLUSTERS () {0x8008;}' unless defined(&TIPC_CMD_SET_MAX_CLUSTERS);
    eval 'sub TIPC_CMD_SET_MAX_NODES () {0x8009;}' unless defined(&TIPC_CMD_SET_MAX_NODES);
    eval 'sub TIPC_CMD_SET_MAX_SLAVES () {0x800a;}' unless defined(&TIPC_CMD_SET_MAX_SLAVES);
    eval 'sub TIPC_CMD_SET_NETID () {0x800b;}' unless defined(&TIPC_CMD_SET_NETID);
    eval 'sub TIPC_CMD_NOT_NET_ADMIN () {0xc001;}' unless defined(&TIPC_CMD_NOT_NET_ADMIN);
    eval 'sub TIPC_TLV_NONE () {0;}' unless defined(&TIPC_TLV_NONE);
    eval 'sub TIPC_TLV_VOID () {1;}' unless defined(&TIPC_TLV_VOID);
    eval 'sub TIPC_TLV_UNSIGNED () {2;}' unless defined(&TIPC_TLV_UNSIGNED);
    eval 'sub TIPC_TLV_STRING () {3;}' unless defined(&TIPC_TLV_STRING);
    eval 'sub TIPC_TLV_LARGE_STRING () {4;}' unless defined(&TIPC_TLV_LARGE_STRING);
    eval 'sub TIPC_TLV_ULTRA_STRING () {5;}' unless defined(&TIPC_TLV_ULTRA_STRING);
    eval 'sub TIPC_TLV_ERROR_STRING () {16;}' unless defined(&TIPC_TLV_ERROR_STRING);
    eval 'sub TIPC_TLV_NET_ADDR () {17;}' unless defined(&TIPC_TLV_NET_ADDR);
    eval 'sub TIPC_TLV_MEDIA_NAME () {18;}' unless defined(&TIPC_TLV_MEDIA_NAME);
    eval 'sub TIPC_TLV_BEARER_NAME () {19;}' unless defined(&TIPC_TLV_BEARER_NAME);
    eval 'sub TIPC_TLV_LINK_NAME () {20;}' unless defined(&TIPC_TLV_LINK_NAME);
    eval 'sub TIPC_TLV_NODE_INFO () {21;}' unless defined(&TIPC_TLV_NODE_INFO);
    eval 'sub TIPC_TLV_LINK_INFO () {22;}' unless defined(&TIPC_TLV_LINK_INFO);
    eval 'sub TIPC_TLV_BEARER_CONFIG () {23;}' unless defined(&TIPC_TLV_BEARER_CONFIG);
    eval 'sub TIPC_TLV_LINK_CONFIG () {24;}' unless defined(&TIPC_TLV_LINK_CONFIG);
    eval 'sub TIPC_TLV_NAME_TBL_QUERY () {25;}' unless defined(&TIPC_TLV_NAME_TBL_QUERY);
    eval 'sub TIPC_TLV_PORT_REF () {26;}' unless defined(&TIPC_TLV_PORT_REF);
    eval 'sub TIPC_MIN_LINK_PRI () {0;}' unless defined(&TIPC_MIN_LINK_PRI);
    eval 'sub TIPC_DEF_LINK_PRI () {10;}' unless defined(&TIPC_DEF_LINK_PRI);
    eval 'sub TIPC_MAX_LINK_PRI () {31;}' unless defined(&TIPC_MAX_LINK_PRI);
    eval 'sub TIPC_MEDIA_LINK_PRI () {( &TIPC_MAX_LINK_PRI + 1);}' unless defined(&TIPC_MEDIA_LINK_PRI);
    eval 'sub TIPC_MIN_LINK_TOL () {50;}' unless defined(&TIPC_MIN_LINK_TOL);
    eval 'sub TIPC_DEF_LINK_TOL () {1500;}' unless defined(&TIPC_DEF_LINK_TOL);
    eval 'sub TIPC_MAX_LINK_TOL () {30000;}' unless defined(&TIPC_MAX_LINK_TOL);
    if(((defined(&TIPC_MIN_LINK_TOL) ? &TIPC_MIN_LINK_TOL : undef) < 16)) {
	die("TIPC_MIN_LINK_TOL is too small (abort limit may be NaN)");
    }
    eval 'sub TIPC_MIN_LINK_WIN () {16;}' unless defined(&TIPC_MIN_LINK_WIN);
    eval 'sub TIPC_DEF_LINK_WIN () {50;}' unless defined(&TIPC_DEF_LINK_WIN);
    eval 'sub TIPC_MAX_LINK_WIN () {150;}' unless defined(&TIPC_MAX_LINK_WIN);
    eval 'sub TIPC_NTQ_ALLTYPES () {0x80000000;}' unless defined(&TIPC_NTQ_ALLTYPES);
    eval 'sub TIPC_CFG_TLV_ERROR () {"\\x80";}' unless defined(&TIPC_CFG_TLV_ERROR);
    eval 'sub TIPC_CFG_NOT_NET_ADMIN () {"\\x81";}' unless defined(&TIPC_CFG_NOT_NET_ADMIN);
    eval 'sub TIPC_CFG_NOT_ZONE_MSTR () {"\\x82";}' unless defined(&TIPC_CFG_NOT_ZONE_MSTR);
    eval 'sub TIPC_CFG_NO_REMOTE () {"\\x83";}' unless defined(&TIPC_CFG_NO_REMOTE);
    eval 'sub TIPC_CFG_NOT_SUPPORTED () {"\\x84";}' unless defined(&TIPC_CFG_NOT_SUPPORTED);
    eval 'sub TIPC_CFG_INVALID_VALUE () {"\\x85";}' unless defined(&TIPC_CFG_INVALID_VALUE);
    eval 'sub TLV_ALIGNTO () {4;}' unless defined(&TLV_ALIGNTO);
    eval 'sub TLV_ALIGN {
        my($datalen) = @_;
	    eval q(((($datalen)+( &TLV_ALIGNTO-1)) & ~( &TLV_ALIGNTO-1)));
    }' unless defined(&TLV_ALIGN);
    eval 'sub TLV_LENGTH {
        my($datalen) = @_;
	    eval q(($sizeof{\'struct tlv_desc\'} + ($datalen)));
    }' unless defined(&TLV_LENGTH);
    eval 'sub TLV_SPACE {
        my($datalen) = @_;
	    eval q(( &TLV_ALIGN( &TLV_LENGTH($datalen))));
    }' unless defined(&TLV_SPACE);
    eval 'sub TLV_DATA {
        my($tlv) = @_;
	    eval q((( &void *)(($tlv) +  &TLV_LENGTH(0))));
    }' unless defined(&TLV_DATA);
    eval 'sub TLV_OK {
        my($tlv,$space) = @_;
	    eval q({ ($space >=  &TLV_SPACE(0))  && ( &ntohs(($tlv)-> &tlv_len) <= $space); });
    }' unless defined(&TLV_OK);
    eval 'sub TLV_CHECK {
        my($tlv,$space,$exp_type) = @_;
	    eval q({  &TLV_OK($tlv, $space)  && ( &ntohs(($tlv)-> &tlv_type) == $exp_type); });
    }' unless defined(&TLV_CHECK);
    eval 'sub TLV_SET {
        my($tlv,$type,$data,$len) = @_;
	    eval q({ \'struct tlv_desc\' * &tlv_ptr; \'int\'  &tlv_len;  &tlv_len =  &TLV_LENGTH($len);  &tlv_ptr = $tlv;  ($tlv_ptr->{tlv_type}) =  &htons($type);  ($tlv_ptr->{tlv_len})  =  &htons( &tlv_len);  &if ($len  && $data)  &memcpy( &TLV_DATA( &tlv_ptr), $data,  &tlv_len);  &TLV_SPACE($len); });
    }' unless defined(&TLV_SET);
    eval 'sub TLV_LIST_INIT {
        my($list,$data,$space) = @_;
	    eval q({  ($list->{tlv_ptr}) = $data;  ($list->{tlv_space}) = $space; });
    }' unless defined(&TLV_LIST_INIT);
    eval 'sub TLV_LIST_EMPTY {
        my($list) = @_;
	    eval q({ ( ($list->{tlv_space}) == 0); });
    }' unless defined(&TLV_LIST_EMPTY);
    eval 'sub TLV_LIST_CHECK {
        my($list,$exp_type) = @_;
	    eval q({  &TLV_CHECK( ($list->{tlv_ptr}),  ($list->{tlv_space}), $exp_type); });
    }' unless defined(&TLV_LIST_CHECK);
    eval 'sub void () {
        eval q(* &TLV_LIST_DATA(\'struct tlv_list_desc\' * &list) {  &TLV_DATA( ($list->{tlv_ptr})); });
    }' unless defined(&void);
    eval 'sub TLV_LIST_STEP {
        my($list) = @_;
	    eval q({  &__u16  &tlv_space =  &TLV_ALIGN( &ntohs( ($list->{tlv_ptr}->{tlv_len})));  ($list->{tlv_ptr}) = ( ($list->{tlv_ptr}) +  &tlv_space);  ($list->{tlv_space}) -=  &tlv_space; });
    }' unless defined(&TLV_LIST_STEP);
    eval 'sub TIPC_GENL_NAME () {"TIPC";}' unless defined(&TIPC_GENL_NAME);
    eval 'sub TIPC_GENL_VERSION () {0x1;}' unless defined(&TIPC_GENL_VERSION);
    eval 'sub TIPC_GENL_CMD () {0x1;}' unless defined(&TIPC_GENL_CMD);
    eval 'sub TIPC_GENL_HDRLEN () { &NLMSG_ALIGN($sizeof{\'struct tipc_genlmsghdr\'});}' unless defined(&TIPC_GENL_HDRLEN);
    eval 'sub TCM_F_REQUEST () {0x1;}' unless defined(&TCM_F_REQUEST);
    eval 'sub TCM_F_MORE () {0x2;}' unless defined(&TCM_F_MORE);
    eval 'sub TCM_ALIGN {
        my($datalen) = @_;
	    eval q(((($datalen)+3) & ~3));
    }' unless defined(&TCM_ALIGN);
    eval 'sub TCM_LENGTH {
        my($datalen) = @_;
	    eval q(($sizeof{\'struct tipc_cfg_msg_hdr\'} + $datalen));
    }' unless defined(&TCM_LENGTH);
    eval 'sub TCM_SPACE {
        my($datalen) = @_;
	    eval q(( &TCM_ALIGN( &TCM_LENGTH($datalen))));
    }' unless defined(&TCM_SPACE);
    eval 'sub TCM_DATA {
        my($tcm_hdr) = @_;
	    eval q((( &void *)(($tcm_hdr) +  &TCM_LENGTH(0))));
    }' unless defined(&TCM_DATA);
    eval 'sub TCM_SET {
        my($msg,$cmd,$flags,$data,$data_len) = @_;
	    eval q({ \'struct tipc_cfg_msg_hdr\' * &tcm_hdr; \'int\'  &msg_len;  &msg_len =  &TCM_LENGTH($data_len);  &tcm_hdr = $msg;  ($tcm_hdr->{tcm_len})  =  &htonl( &msg_len);  ($tcm_hdr->{tcm_type})  =  &htons($cmd);  ($tcm_hdr->{tcm_flags}) =  &htons($flags);  &if ($data_len  && $data)  &memcpy( &TCM_DATA($msg), $data, $data_len);  &TCM_SPACE($data_len); });
    }' unless defined(&TCM_SET);
}
1;
