# NOTE: Derived from blib/lib/NetAddr/IP.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package NetAddr::IP;

#line 736 "blib/lib/NetAddr/IP.pm (autosplit into blib/lib/auto/NetAddr/IP/compactref.al)"
sub compactref($) {
  my @r = sort @{$_[0]}
	or return [];
  return [] unless @r;
  foreach(0..$#r) {
    $r[$_]->{addr} = $r[$_]->network->{addr};
  }
  my $changed;
  do {
	$changed = 0;
	for(my $i=0; $i <= $#r -1;$i++) {
	  if ($r[$i]->contains($r[$i +1])) {
	    splice(@r,$i +1,1);
	    ++$changed;
	    --$i;
	  }
	  elsif ((notcontiguous($r[$i]->{mask}))[1] == (notcontiguous($r[$i +1]->{mask}))[1]) {		# masks the same
	    if (hasbits($r[$i]->network->{addr} ^ $r[$i +1]->network->{addr})) {	# if not the same netblock
	      my $upnet = $r[$i]->copy;
	      $upnet->{mask} = shiftleft($upnet->{mask},1);
	      if ($upnet->contains($r[$i +1])) {					# adjacent nets in next net up
		$r[$i] = $upnet;
		splice(@r,$i +1,1);
		++$changed;
		--$i;
	      }
	    } else {									# identical nets
	      splice(@r,$i +1,1);
	      ++$changed;
	      --$i;
	    }
	  }
	}
  } while $changed;
  return \@r;
}

# end of NetAddr::IP::compactref
1;
