require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_MEMORY_HOTPLUG_H)) {
    eval 'sub __LINUX_MEMORY_HOTPLUG_H () {1;}' unless defined(&__LINUX_MEMORY_HOTPLUG_H);
    require 'linux/mmzone.ph';
    require 'linux/spinlock.ph';
    require 'linux/mmzone.ph';
    require 'linux/notifier.ph';
    if(defined(&CONFIG_MEMORY_HOTPLUG)) {
	eval 'sub zone_span_seqretry {
	    my($zone,$iv) = @_;
    	    eval q({  &read_seqretry( ($zone->{span_seqlock}), $iv); });
	}' unless defined(&zone_span_seqretry);
	eval 'sub zone_span_writelock {
	    my($zone) = @_;
    	    eval q({  &write_seqlock( ($zone->{span_seqlock})); });
	}' unless defined(&zone_span_writelock);
	eval 'sub zone_span_writeunlock {
	    my($zone) = @_;
    	    eval q({  &write_sequnlock( ($zone->{span_seqlock})); });
	}' unless defined(&zone_span_writeunlock);
	eval 'sub zone_seqlock_init {
	    my($zone) = @_;
    	    eval q({  &seqlock_init( ($zone->{span_seqlock})); });
	}' unless defined(&zone_seqlock_init);
	if(defined(&CONFIG_NUMA)) {
	} else {
	    eval 'sub memory_add_physaddr_to_nid {
	        my($start) = @_;
    		eval q({ 0; });
	    }' unless defined(&memory_add_physaddr_to_nid);
	}
	if(defined(&CONFIG_HAVE_ARCH_NODEDATA_EXTENSION)) {
	} else {
	    eval 'sub arch_alloc_nodedata {
	        my($nid) = @_;
    		eval q( &generic_alloc_nodedata($nid));
	    }' unless defined(&arch_alloc_nodedata);
	    eval 'sub arch_free_nodedata {
	        my($pgdat) = @_;
    		eval q( &generic_free_nodedata($pgdat));
	    }' unless defined(&arch_free_nodedata);
	    if(defined(&CONFIG_NUMA)) {
		eval 'sub generic_alloc_nodedata {
		    my($nid) = @_;
    		    eval q(({  &kzalloc($sizeof{ &pg_data_t},  &GFP_KERNEL); }));
		}' unless defined(&generic_alloc_nodedata);
		eval 'sub generic_free_nodedata {
		    my($pgdat) = @_;
    		    eval q( &kfree($pgdat));
		}' unless defined(&generic_free_nodedata);
		eval 'sub arch_refresh_nodedata {
		    my($nid,$pgdat) = @_;
    		    eval q({  $node_data[$nid] = $pgdat; });
		}' unless defined(&arch_refresh_nodedata);
	    } else {
		eval 'sub generic_free_nodedata {
		    my($pgdat) = @_;
    		    eval q({ });
		}' unless defined(&generic_free_nodedata);
		eval 'sub arch_refresh_nodedata {
		    my($nid,$pgdat) = @_;
    		    eval q({ });
		}' unless defined(&arch_refresh_nodedata);
	    }
	}
    } else {
	eval 'sub zone_span_seqbegin {
	    my($zone) = @_;
    	    eval q({ 0; });
	}' unless defined(&zone_span_seqbegin);
	eval 'sub zone_span_seqretry {
	    my($zone,$iv) = @_;
    	    eval q({ 0; });
	}' unless defined(&zone_span_seqretry);
	eval 'sub mhp_notimplemented {
	    my($func) = @_;
    	    eval q({  &printk( &KERN_WARNING \\"%s() called, with CONFIG_MEMORY_HOTPLUG disabled\\\\n\\", $func);  &dump_stack(); - &ENOSYS; });
	}' unless defined(&mhp_notimplemented);
    }
    eval 'sub __remove_pages {
        my($zone,$start_pfn,$nr_pages) = @_;
	    eval q({  &printk( &KERN_WARNING \\"%s() called, not yet supported\\\\n\\",  &__FUNCTION__);  &dump_stack(); - &ENOSYS; });
    }' unless defined(&__remove_pages);
}
1;
