/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.util;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.InstanceInfo;

public final class EurekaUtils {
    public static String getPrivateIp(InstanceInfo instanceInfo) {
        String defaultPrivateIp = null;
        if (instanceInfo.getDataCenterInfo() instanceof AmazonInfo) {
            defaultPrivateIp = ((AmazonInfo)instanceInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.localIpv4);
        }
        if (EurekaUtils.isNullOrEmpty(defaultPrivateIp)) {
            defaultPrivateIp = instanceInfo.getIPAddr();
        }
        return defaultPrivateIp;
    }

    public static boolean isInEc2(InstanceInfo instanceInfo) {
        String instanceId;
        return instanceInfo.getDataCenterInfo() instanceof AmazonInfo && (instanceId = ((AmazonInfo)instanceInfo.getDataCenterInfo()).getId()) != null && instanceId.startsWith("i-");
    }

    public static boolean isInVpc(InstanceInfo instanceInfo) {
        if (instanceInfo.getDataCenterInfo() instanceof AmazonInfo) {
            AmazonInfo info = (AmazonInfo)instanceInfo.getDataCenterInfo();
            String vpcId = info.get(AmazonInfo.MetaDataKey.vpcId);
            return !EurekaUtils.isNullOrEmpty(vpcId);
        }
        return false;
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

