/*
 * Copyright (C) 2006 Philippe Gerum <rpm@xenomai.org>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */

#include <vrtx/vrtx.h>

extern int __vrtx_muxid;

int sc_fcreate(int *errp)
{
	int fid = -1;

	*errp = XENOMAI_SKINCALL1(__vrtx_muxid, __vrtx_fcreate, &fid);
	return fid;
}

void sc_fdelete(int fid, int opt, int *errp)
{
	*errp = XENOMAI_SKINCALL2(__vrtx_muxid, __vrtx_fdelete, fid, opt);
}

void sc_fpost(int fid, int mask, int *errp)
{
	*errp = XENOMAI_SKINCALL2(__vrtx_muxid, __vrtx_fpost, fid, mask);
}

int sc_fpend(int fid, long timeout, int mask, int opt, int *errp)
{
	int mask_r = 0;

	*errp = XENOMAI_SKINCALL5(__vrtx_muxid,
				  __vrtx_fpend,
				  fid, timeout, mask, opt, &mask_r);
	return mask_r;
}

int sc_fclear(int fid, int mask, int *errp)
{
	int mask_r = 0;

	*errp = XENOMAI_SKINCALL3(__vrtx_muxid,
				  __vrtx_fclear, fid, mask, &mask_r);
	return mask_r;
}

int sc_finquiry(int fid, int *errp)
{
	int mask_r = 0;

	*errp = XENOMAI_SKINCALL2(__vrtx_muxid, __vrtx_finquiry, fid, &mask_r);
	return mask_r;
}
