/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.DoActionListener;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.UserFunctionObject;

class FunctionEditDialog
extends ObjectEditDialog {
    TextField Var;
    TextField EY;
    TextField X;
    TextField Y;
    IconBar IC;
    ZirkelCanvas ZC;
    Checkbox Fixed;

    public FunctionEditDialog(ZirkelCanvas zirkelCanvas, UserFunctionObject userFunctionObject) {
        super(zirkelCanvas.getFrame(), Zirkel.name("edit.function.title"), userFunctionObject, "function");
        this.ZC = zirkelCanvas;
    }

    public void addFirst(Panel panel) {
        UserFunctionObject userFunctionObject = (UserFunctionObject)this.O;
        this.Var = new TextFieldAction(this, "var", "" + userFunctionObject.getVar(), 30);
        panel.add(new MyLabel(Zirkel.name("function.vars")));
        panel.add(this.Var);
        this.EY = new TextFieldAction(this, "ey", "" + userFunctionObject.getEY(), 30);
        panel.add(new MyLabel(Zirkel.name("function.f")));
        panel.add(this.EY);
        this.X = new TextFieldAction((DoActionListener)this, "X", "" + userFunctionObject.round(userFunctionObject.getX()));
        panel.add(new MyLabel(Zirkel.name("edit.point.x")));
        panel.add(this.X);
        this.Y = new TextFieldAction((DoActionListener)this, "Y", "" + userFunctionObject.round(userFunctionObject.getY()));
        panel.add(new MyLabel(Zirkel.name("edit.point.y")));
        panel.add(this.Y);
        this.Fixed = new Checkbox("");
        this.Fixed.setState(userFunctionObject.fixed());
        panel.add(new MyLabel(Zirkel.name("edit.fixed")));
        panel.add(this.Fixed);
        if (userFunctionObject.fixed()) {
            this.X.setText(userFunctionObject.getEXpos());
            this.Y.setText(userFunctionObject.getEYpos());
        }
    }

    public void setAction() {
        double d2;
        double d3;
        UserFunctionObject userFunctionObject = (UserFunctionObject)this.O;
        userFunctionObject.setExpressions(this.Var.getText(), this.EY.getText());
        try {
            d3 = new Double(this.X.getText());
            d2 = new Double(this.Y.getText());
            userFunctionObject.move(d3, d2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.Fixed.getState()) {
            userFunctionObject.setFixed(this.X.getText(), this.Y.getText());
        } else {
            try {
                d3 = new Expression(this.X.getText(), userFunctionObject.getConstruction(), userFunctionObject).getValue();
                d2 = new Expression(this.Y.getText(), userFunctionObject.getConstruction(), userFunctionObject).getValue();
                userFunctionObject.move(d3, d2);
                userFunctionObject.setFixed(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.Var.requestFocus();
    }
}

