/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.awt;

import edu.hws.jcm.awt.Computable;
import edu.hws.jcm.awt.JCMError;
import edu.hws.jcm.data.NumUtils;
import edu.hws.jcm.data.Value;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Label;

public class DisplayLabel
extends Label
implements Computable {
    protected String text;
    protected int numSize;
    protected Value[] values;

    public DisplayLabel() {
        this(null, (Value[])null);
    }

    public DisplayLabel(String string, Value value) {
        Value[] valueArray;
        if (value == null) {
            valueArray = null;
        } else {
            Value[] valueArray2 = new Value[1];
            valueArray = valueArray2;
            valueArray2[0] = value;
        }
        this(string, valueArray);
    }

    public DisplayLabel(String string, Value[] valueArray) {
        this.numSize = 10;
        this.text = string == null ? "#" : string;
        this.setValues(valueArray);
    }

    public void compute() {
        super.setText(this.getSubstitutedText());
    }

    public Value[] getValues() {
        return this.values;
    }

    public void setValue(Value value) {
        this.values = value == null ? null : new Value[]{value};
        super.setText(this.getSubstitutedText());
    }

    public void setValues(Value[] valueArray) {
        if (valueArray == null) {
            this.values = null;
        } else {
            this.values = new Value[valueArray.length];
            System.arraycopy(valueArray, 0, this.values, 0, valueArray.length);
        }
        super.setText(this.getSubstitutedText());
    }

    public void setNumSize(int n) {
        this.numSize = Math.min(Math.max(n, 2), 25);
    }

    public int getNumSize() {
        return this.numSize;
    }

    public String getBaseText() {
        return this.text;
    }

    private String getSubstitutedText() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            if (this.text.charAt(i) == '#') {
                if (i != this.text.length() - 1 && this.text.charAt(i + 1) == '#') {
                    stringBuffer.append('#');
                    ++i;
                    continue;
                }
                if (this.values == null || n >= this.values.length) {
                    stringBuffer.append("undefined");
                    continue;
                }
                try {
                    stringBuffer.append(NumUtils.realToString(this.values[n].getVal(), this.numSize));
                }
                catch (JCMError jCMError) {
                    stringBuffer.append("undefined");
                }
                ++n;
                continue;
            }
            stringBuffer.append(this.text.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void setText(String string) {
        this.text = string;
        super.setText(this.getSubstitutedText());
    }

    public Dimension getPreferredSize() {
        int n;
        Dimension dimension = super.getPreferredSize();
        int n2 = 0;
        if (this.text == null || this.text.length() == 0) {
            n2 = 1;
        } else {
            for (int i = 0; i < this.text.length(); ++i) {
                n = this.text.charAt(i);
                if (n != 35) continue;
                if (i < this.text.length() - 1 && this.text.charAt(i + 1) == '#') {
                    ++i;
                    continue;
                }
                ++n2;
            }
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        n = fontMetrics.charWidth('0');
        int n3 = 10 + (n * Math.max(8, this.numSize) * n2 + fontMetrics.stringWidth(this.text));
        return new Dimension(n3, dimension.height);
    }
}

