/**
*
* Witchcraft Compiler Collection
*
* Author: Jonathan Brossard - endrazine@gmail.com
*
*******************************************************************************
* The MIT License (MIT)
* Copyright (c) 2016 Jonathan Brossard
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in 
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
*******************************************************************************
*
*/


#ifndef WCC_DEFAULT_FUNCS

#define WCC_DEFAULT_FUNCS 1

char *default_options[] = {
"0x",
// Shell commands
"help",
"quit",
"exit",
"shell",
"exec",
"clear",
// Core WCC functions
"help",
"info",
"memory",
"memory:addr",
"memory:hex",
"memory:read",
"memory:strlen",
"memory:tostring",
"memory:usage",
"memory:write",
"man",
"bfmap",
"teletype",
"appear",
"autoscan",
"bsspolute",
"dumptable",
"dt",
"symbols",
"functions",
"utrace",
"unutrace",
"systrace",
"rtrace",
"unsystrace",
"unrtrace",
"sstrace",
"unsstrace",
"btrace",
"unbtrace",
"vtrace",
"unvtrace",
"unappear",
"unhide",
"objects",
"hex",
"hexdump",
"hex_dump",
"verbose",
"hide",
"hollywood",
"libs",
"libcall",
"loadbin",
"breakpoint",
"bp",
"headers",
"search",
"searchobj",
"map",
"phdrs",
"shdrs",
"entrypoints",
"rescan",
"procmap",
"prototypes",
"testlib",
"testfunc",
"grep",
"grepptr",
"enableaslr",
"disableaslr",
"balloc",
"bset",
"bget",
"rdstr",
"memcpy",
"ralloc",
"strcpy",
"strcat",
"xalloc",
"xfree",
"script",
"enablecore",
"disablecore",
"gencore"
};

// All lua 5.3 Functions and global variables
char *lua_default_functions[] = {
"_G",
"_VERSION",
"assert",
"collectgarbage",
"dofile",
"error",
"getmetatable",
"ipairs",
"load",
"loadfile",
"next",
"pairs",
"pcall",
"print",
"rawequal",
"rawget",
"rawlen",
"rawset",
"require",
"select",
"setmetatable",
"tonumber",
"tostring",
"type",
"xpcall",
"coroutine",
"coroutine.create",
"coroutine.isyieldable",
"coroutine.resume",
"coroutine.running",
"coroutine.status",
"coroutine.wrap",
"coroutine.yield",
"debug",
"debug.debug",
"debug.gethook",
"debug.getinfo",
"debug.getlocal",
"debug.getmetatable",
"debug.getregistry",
"debug.getupvalue",
"debug.getuservalue",
"debug.sethook",
"debug.setlocal",
"debug.setmetatable",
"debug.setupvalue",
"debug.setuservalue",
"debug.traceback",
"debug.upvalueid",
"debug.upvaluejoin",
"io",
"io.close",
"io.flush",
"io.input",
"io.lines",
"io.open",
"io.output",
"io.popen",
"io.read",
"io.stderr",
"io.stdin",
"io.stdout",
"io.tmpfile",
"io.type",
"io.write",
"file:close",
"file:flush",
"file:lines",
"file:read",
"file:seek",
"file:setvbuf",
"file:write",
"math",
"math.abs",
"math.acos",
"math.asin",
"math.atan",
"math.ceil",
"math.cos",
"math.deg",
"math.exp",
"math.floor",
"math.fmod",
"math.huge",
"math.log",
"math.max",
"math.maxinteger",
"math.min",
"math.mininteger",
"math.modf",
"math.pi",
"math.rad",
"math.random",
"math.randomseed",
"math.sin",
"math.sqrt",
"math.tan",
"math.tointeger",
"math.type",
"math.ult",
"os",
"os.clock",
"os.date",
"os.difftime",
"os.execute",
"os.exit",
"os.getenv",
"os.remove",
"os.rename",
"os.setlocale",
"os.time",
"os.tmpname",
"package",
"package.config",
"package.cpath",
"package.loaded",
"package.loadlib",
"package.path",
"package.preload",
"package.searchers",
"package.searchpath",
"string",
"string.byte",
"string.char",
"string.dump",
"string.find",
"string.format",
"string.gmatch",
"string.gsub",
"string.len",
"string.lower",
"string.match",
"string.pack",
"string.packsize",
"string.rep",
"string.reverse",
"string.sub",
"string.unpack",
"string.upper",
"table",
"table.concat",
"table.insert",
"table.move",
"table.pack",
"table.remove",
"table.sort",
"table.unpack",
"utf8",
"utf8.char",
"utf8.charpattern",
"utf8.codepoint",
"utf8.codes",
"utf8.len",
"utf8.offset",
"LUA_CPATH",
"LUA_CPATH_5_3",
"LUA_INIT",
"LUA_INIT_5_3",
"LUA_PATH",
"LUA_PATH_5_3"
};

// Function names blacklisted in lua
char *lua_blacklist[] = {
"and",
"break",
"do",
"else",
"elseif",
"end",
"false",
"for",
"function",
"if",
"in",
"local",
"nil",
"not",
"or",
"repeat",
"return",
"then",
"true",
"until",
"while"
};

tuple_t exposed[] = {
{libcall, "libcall"},
{map, "map"},
{ltrace,"ltrace"},
{procmap_lua,"procmap"},
{rescan,"rescan"},
{grep,"grep"},
{grepptr,"grepptr"},
{hexdump,"lhexdump"},
{bfmap,"bfmap"},
{teletype, "teletype"},
{phdrs,"phdrs"},
{shdrs,"shdrs"},
{entrypoints, "entrypoints"},
{alloccharbuf,"balloc"},
{setcharbuf,"bset"},
{getcharbuf,"bget"},
{execlib,"lexeclib"},
{help,"help"},
{headers,"headers"},
{info,"info"},
{man,"man"},
{disable_aslr,"disableaslr"},
{enable_aslr,"enableaslr"},
{breakpoint,"breakpoint"},
{breakpoint,"bp"},
{verbose,"verbose"},
{hollywood,"hollywood"},
{print_symbols,"symbols"},
{print_functions,"functions"},
{print_objects,"objects"},
{print_libs,"libs"},
{loadbin,"loadbin"},
{ralloc,"ralloc"},
{xalloc,"xalloc"},
{xfree,"xfree"},
{prototypes,"prototypes"},
{traceunaligned,"utrace"},
{untraceunaligned,"unutrace"},
{singlestep,"sstrace"},
{systrace,"systrace"},
{rtrace,"rtrace"},
{unsystrace,"unsystrace"},
{unrtrace,"unrtrace"},
{unsinglestep,"unsstrace"},
{singlebranch,"btrace"},
{unsinglebranch,"unbtrace"},
{verbosetrace,"vtrace"},
{unverbosetrace,"unvtrace"},
{bsspolute,"bsspolute"},
{priv_memcpy,"memcpy"},
{priv_strcpy,"strcpy"},
{priv_strcat,"strcat"},
{rdstr,"rdstr"},
{rdnum,"rdnum"},
{run_script,"lscript"},
{enable_core,"enablecore"},
{disable_core,"disablecore"},
{rawmemread, "rawmemread"},
{rawmemwrite, "rawmemwrite"},
{rawmemstr, "rawmemstr"},
{rawmemusage, "rawmemusage"},
{rawmemaddr, "rawmemaddr"},
{rawmemstrlen, "rawmemstrlen"},
{gencore,"gencore"},
{wsh_appear, "appear"},
{wsh_hide, "hide"},
{wsh_appear, "unhide"},
{wsh_hide, "unappear"}
};

range_t ranges[] = {
	{0x00000000, 0x100000000},
#ifdef __amd64__
	{0x7f0000000000, 0x800000000000},
	{0xffffffffff600000, 0xffffffffff610000},
	{0x000000000000, 0x000000000000}
#endif
};

unsigned int global_xalloc = 0;

#endif /* WCC_DEFAULT_FUNCS */

