/**
//@HEADER
// ************************************************************************
//
//                   Trios: Trilinos I/O Support
//                 Copyright 2011 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//Questions? Contact Ron A. Oldfield (raoldfi@sandia.gov)
//
// *************************************************************************
//@HEADER
 */
/**
 * TRIOS does not have any internal threading, but it should run in a
 * multithreaded environment.  The nthread library provides a single API
 * for locks and atomic counters.
 */

#ifndef _TRIOS_THREADS_H_
#define _TRIOS_THREADS_H_

#include "Trios_config.h"

#include "Trios_logger.h"
#include "Trios_threads_types.h"


#ifdef __cplusplus
extern "C" {
#endif

extern log_level thread_debug_level;



int nthread_lock_init(
        nthread_lock_t *lock);
int nthread_lock(
        nthread_lock_t *lock);
int nthread_unlock(
        nthread_lock_t *lock);
int nthread_lock_fini(
        nthread_lock_t *lock);

int nthread_cond_init(
        nthread_cond_t *condvar);
int nthread_wait(
        nthread_cond_t *condvar,
        nthread_lock_t *lock);
int nthread_timedwait(
        nthread_cond_t *condvar,
        nthread_lock_t *lock,
        uint64_t        timeout);
int nthread_signal(
        nthread_cond_t *condvar);
int nthread_broadcast(
        nthread_cond_t *condvar);
int nthread_cond_fini(
        nthread_cond_t *condvar);

int     nthread_counter_init(
        nthread_counter_t *c);
int64_t nthread_counter_increment(
        nthread_counter_t *c);
int64_t nthread_counter_decrement(
        nthread_counter_t *c);
int64_t nthread_counter_read(
        nthread_counter_t *c);
int64_t nthread_counter_set(
        nthread_counter_t *c,
        int64_t            new_value);
int     nthread_counter_fini(
        nthread_counter_t *c);

#ifdef __cplusplus
}
#endif

#endif /* _TRIOS_THREADS_H_ */
