[comment {-*- tcl -*- doctools manpage}]
[manpage_begin widget_listentry n 0.1]
[moddesc   {widget::listentry widget}]
[titledesc {widget::listentry widget}]
[require Tcl 8.5]
[require Tk 8.5]
[require widget::listentry [opt 0.1]]
[require widget::validator [opt 0.1]]
[require widget::scrolledwindow]
[require snit]
[require tooltip]
[require img::png]
[require msgcat]
[keywords {list entry panel} {data entry lists} widget]
[keywords {set entry panel} {data entry unordered list}]
[keywords {data entry ordered list}]
[keywords {data entry set of strings}]
[description]

This package provides a megawidget for the interactive entry of
ordered and unordered lists.

For a simpler and more restricted megawidget please see the
package [package widget::listsimple].

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Class API}]

The widget class supports a single command, for the creation of widgets.

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widget::listentry] [arg pathname] [opt options]]

This command creates and configures new instances of the widget.

[para] For details on the available options please see section
[sectref {Widget Options}].

[para] The result of the command is the pathname of the new widget.

[list_end]


[comment {= = == === ===== ======== ============= =====================}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Instance API}]

All widget instances supported the following methods.

[list_begin definitions]
[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method destroy]]

This method destroys the widget.
Any further access to the widget will generate errors.

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure]]

This method comes in three variants. This variant here returns a list
containing the current configuration of the widget, i.e. the values
for all options.

[para] For details on the available options please see section
[sectref {Widget Options}].

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure] [arg option] [arg value] ...]

This method comes in three variants. This variant here reconfigures
the widget, setting the specified options to the given values.

[para] [emph Note] that it is not possible to change the
construction-time only options.

[para] For details on the available options please see section
[sectref {Widget General Options}].

[para] The result of the command is the empty string.

[comment {= = == === ===== ======== ============= =====================}]
[call [cmd widgetCmd] [method configure] [arg option]]

This method comes in three variants. This variant here is an alias
for the method [method cget] below and identical to it.

[call [cmd widgetCmd] [method cget] [arg option]]

This method returns the current value of the specified [arg option].

[para] For details on the available options please see section
[sectref {Widget Options}].

[list_end]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section {Widget Options}]

This section explains all the options available to instances of
[class widget::listentry]. Please note that a few of the options
can be set only at instance construction time. The majority of the
options can however be set both during construction- and runtime.

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[subsection {Widget Construction-Time Only Options}]

[list_begin options][comment {--- options -----------------------------}]


[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -ordered boolean]

This options tells the new widget instance whether the list it manages
is ordered or not. If it is ordered the widget will show buttons with
which the selected entries can be moved around, editing the order.

[para] The default is [const false], indicating an unordered list.

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -allow-duplicates boolean]

This options tells the new widget instance whether we are allowed to
add a string to the list multiple times, or not.

[para] The default is [const false], indicating that duplicates are not
allowed.

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -values cmdprefix]

This option specifies a callback for the management of a predefined
list of strings a user may enter.

[para] If specified the widget will use a combobox instead of a plain
entry field and fill its list during widget construction using the data
delivered by this callback.

The callback will be further invoked whenever a new value is entered
into the main list, to save the extended list of predefined values.

[para] The signature of this callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [method get]]

In this form the callback is expected to return a list of strings.
The strings are loaded into the list of the internal combobox for
quick access by the user.

[para] It will be invoked once, during widget construction, to load the
list of predefined strings a user may enter.

[call [arg {{*}cmdprefix}] [method set] [arg values]]

In this form the callback is given a list of new strings and
expected to save them somewhere for future use.

[para] The return value of the callback is ignored.

[para] This form is invoked whenever the user entered a new string
into the main list. The order of strings in [arg values] represents
the order used to show them in the combobox's list.

[list_end]

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -validate cmdprefix]

This option specifies a callback which is invoked after every change of
the contents of the internal entry field. The signature of this callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [arg text] [arg errvar]]

where [arg text] is the string to validate, and [arg errvar] the name of
a variable the callback can store an error message into when it detects
invalid data.

[para] The widget expects that the callback returns a boolean value, where
[const true] indicates that [arg text] is valid.

[list_end]

The default validation, when no callback was specified, will treat the
empty string as invalid, and everything else as valid.

[para] [emph {Please note}] that the widget will prevent the entry of
duplicate values into the main list, regardless of the validity of the
input otherwise. This is in keeping with that this widget is meant for
the entry of unordered lists, essentially a set of strings.

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -transform cmdprefix]

This option specifies a callback which is invoked whenever a newly
entered element is moved from the entry field to the main list, or the
entry field is validated, as part of a check for duplicates, if such are
not allowed. The callback is given the text in the entry field and has
to return the text which is actually added to, or checked against the list.

[para] The use case for this callback is essentially
[term {input normalization}]. The most simple case of such would be, for
example the use of [example {string tolower}] to impose a standard letter
case on the data. More complex example can be thought of, like rewriting
of multiple syntaxes of input to a canonical form.

The signature of this callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [arg text]]

where [arg text] is the string to transform.

[para] The widget expects that the callback returns the transformed string.

[list_end]

[para] The default is to not transform the entered strings.


[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -browse cmdprefix]

If this option is specified the widget will display a "Search" button
and invoke the callback provided by the option whenever the user clicks
on that button.

The signature of the callback is

[list_begin definitions]
[call [arg {{*}cmdprefix}] [arg cookievar]]

where the cookie variable provides access to context information the
callback may wish to preserve between invokations. The initial value
stored in the variable is the empty string. After that it is whatever
the callback wishes to store.

[para] The widget expects that the callback returns a list of strings,
which are then added to the list, modulo validity and duplicate checks.

[list_end]

[para] By default there is no browse callback and no button shown.

[list_end][comment {--- options ---------------------------------------}]

[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[subsection {Widget General Options}]

[list_begin options]

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -listvariable varname]

This option specifies the variable holding the list to be manipulated by
the widget. Any changes to the list outside of the widget are automatically
imported into the widget. Similarly, all changes made to the list by the
widget are automatically exported to this variable.

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -state normal|disabled]

This option specifies the status of the widget, [const normal] (= active),
or [const disabled]. A disabled widget can not be edited.

[para] The default is [const normal].

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -height integer]

This option specifies the height of the internal listbox, in lines.

[para] The default is [const 20].

[comment {_ _ __ ___ _____ ________ _____________ _____________________}]
[opt_def -skin-add string]
[opt_def -skin-remove string]
[opt_def -skin-up string]
[opt_def -skin-down string]
[opt_def -skin-browse string]
[opt_def -skin-tip-add string]
[opt_def -skin-tip-remove string]
[opt_def -skin-tip-up string]
[opt_def -skin-tip-down string]
[opt_def -skin-tip-browse string]
[opt_def -skin-tip-main string]
[opt_def -skin-tip-entry string]
[opt_def -skin-tip-list string]
[opt_def -skin-tip-empty string]
[opt_def -skin-tip-duplicate string]
[opt_def -skin-tip-add-none string]
[opt_def -skin-tip-remove-none string]
[opt_def -skin-img-add image]
[opt_def -skin-img-remove image]
[opt_def -skin-img-up string]
[opt_def -skin-img-down string]
[opt_def -skin-img-browse string]
[opt_def -skin-invalid-color color]

These options all modify the appearance of the widget, i.e. its skin.

[para] All options taking a string argument influence the various labels
shown, with the [option -skin-tip-*] options influencing the tooltips
shown on hovering the over various parts in particular.

[para] All the strings are run through [package msgcat] first, enabling
text localization through message catalogs. The default values are keys
into the message catalogs which are part of the package itself.

[para] The options taking images modify the images shown on the buttons
for adding and removing elements of the list. They default to the PNG
images distributed with the package itself.

[para] The single option taking a color value modifies the color used to
highlight invalid data entered into the internal entry field of the
widget. This option defaults to [const yellow].

[list_end]


[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[comment {% % %% %%% %%%%% %%%%%%%% %%%%%%%%%%%%% %%%%%%%%%%%%%%%%%%%%%}]
[section Example]
[example {}]
[manpage_end]
