[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil::magic::cgen n 1.0]
[see_also file(1)]
[see_also fileutil]
[see_also magic(5)]
[keywords {file recognition}]
[keywords {file type}]
[keywords {file utilities}]
[keywords mime]
[keywords type]
[moddesc   {file utilities}]
[titledesc {Generator core for compiler of magic(5) files}]
[category  {Programming tools}]
[require Tcl 8.4]
[require fileutil::magic::cgen [opt 1.0]]
[require fileutil::magic::rt [opt 1.0]]

[require struct::tree]
[require struct::list]
[description]
[para]

This package provides the generator backend for a compiler of magic(5)
files into recognizers based on the [package fileutil::magic::rt]
recognizer runtime package. For the compiler frontend using this
generator see the package [package fileutil::magic::cfront].

[section COMMANDS]

[list_begin definitions]

[call [cmd ::fileutil::magic::cgen::2tree] [arg script]]

This command converts the recognizer specified by the [arg script]
into a tree and returns the object command of that tree as its
result. It uses the package [package struct::tree] for the tree.

[para]

The [arg script] is in the format specified by magic(5).

[call [cmd ::fileutil::magic::cgen::treedump] [arg tree]]

This command takes a [arg tree] as generated by
[cmd ::fileutil::magic::cgen::2tree] and returns a string encoding the
tree for human consumption, to aid in debugging.

[call [cmd ::fileutil::magic::cgen::treegen] [arg tree] [arg node]]

This command takes a [arg tree] as generated by
[cmd ::fileutil::magic::cgen::2tree] and returns a Tcl script, the
recognizer for the file types represented by the sub-tree rooted at
the [arg node].

The generated script makes extensive use of the commands provided by
the recognizer runtime package [package fileutil::magic::rt] to
perform its duties.

[list_end]

[vset CATEGORY {fileutil :: magic}]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
