Description: Update to GIT sources
 This patch updates the 1.0 release to the latest GIT source contents.
Author: Javier Fernández-Sanguino Peña <jfs@debian.org>


Origin: upstream
Last-Update: 2017-07-30

--- storymaps-1.0+dfsg.orig/README.markdown
+++ storymaps-1.0+dfsg/README.markdown
@@ -5,14 +5,15 @@ the [Story Maps website](http://seanh.gi
 Compiling and Running from the Command Line
 ===========================================
 
-To compile run:
+Tested on Ubuntu 17.04. To compile run:
 
-    javac -d build/classes/ -classpath lib/piccolo.jar:lib/piccolox.jar:lib/freemarker.jar:src/ src/storymaps/Application.java
+    sudo apt install libgoogle-gson-java
+    javac -d build/classes/ -classpath /usr/share/java/gson.jar:lib/piccolo.jar:lib/piccolox.jar:lib/freemarker.jar:src/ src/storymaps/Application.java
 
 from inside this directory. Then to run the application directly from the class
 files do:
 
-    java -classpath lib/piccolo.jar:lib/piccolox.jar:lib/freemarker.jar:src:build/classes/ storymaps.Application
+    java -classpath /usr/share/java/gson.jar:lib/piccolo.jar:lib/piccolox.jar:lib/freemarker.jar:src:build/classes/ storymaps.Application
 
 To pack the application up into an executable JAR file do:
 
--- storymaps-1.0+dfsg.orig/src/storymaps/Function.java
+++ storymaps-1.0+dfsg/src/storymaps/Function.java
@@ -20,14 +20,12 @@
 */
 package storymaps;
 
-import org.json.JSONArray;
+import com.google.gson.*;
 
 import java.awt.Image;
 import java.io.IOException;
 import java.util.ArrayList;
 import java.util.List;
-import org.json.JSONException;
-import org.json.JSONObject;
 import java.util.logging.Logger;
 
 /**
@@ -88,22 +86,33 @@ final class Function implements Comparab
         if (functions == null) {
             try {
                 String jsonString = Util.readTextFileFromClassPath("/data/functions/functions.json");
-                JSONArray jsonArray = new JSONArray(jsonString);
+                // Use to debug the functions.json script when running in the source code:
+                // String jsonString = Util.readTextFileFromSystem("src/data/functions/functions.json");
+                JsonParser parser = new JsonParser();
+                JsonElement element = parser.parse(jsonString);
+                JsonArray jsonArray = element.getAsJsonArray();
+
                 functions = new ArrayList<Function>();
-                for (int i = 0; i < jsonArray.length(); i++) {
-                    JSONObject jsonObject = jsonArray.getJSONObject(i);
-                    int number = jsonObject.getInt("number");
-                    String name = jsonObject.getString("name");
-                    String description = jsonObject.getString("description");
-                    String instructions = jsonObject.getString("instructions");
-                    Function function = new Function(number,name,description,instructions);
-                    functions.add(function);
+                for (int i = 0; i < jsonArray.size(); i++) {
+                    if ( ! jsonArray.get(i).isJsonNull() ) {
+                        try {
+                            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
+                            int number = jsonObject.get("number").getAsInt();
+                            String name = jsonObject.get("name").toString();
+                            String description = jsonObject.get("description").toString();
+                            String instructions = jsonObject.get("instructions").toString();
+                            Function function = new Function(number,name,description,instructions);
+                            functions.add(function);
+                        } catch (IllegalStateException e) {
+                            throw new RuntimeException("Exception when reading function #"+i+" in functions file.",e);
+                        }
+                    }
                 }
             } catch (IOException e) {
                 // If we can't read the functions file then the application
                 // can't work.
                 throw new RuntimeException("Could not read functions.json file.",e);
-            } catch (JSONException e) {
+            } catch (JsonParseException e) {
                 throw new RuntimeException("Exception when reading functions file.",e);
             }
         }
@@ -224,4 +233,5 @@ final class Function implements Comparab
         return new Function(f.getNumber(),f.getName(),f.getDescription(),
                 f.getInstructions());
     }
-}
\ No newline at end of file
+}
+
