/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.List;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.UnitExpr;

class UnitVal {
    static final char CHAR_DECA = '\u0001';
    public int i;
    public double f;
    public double l10f;
    public String s;
    public OneUnit u;
    public List<OneUnit> uList;
    public UnitExpr uExpr;
    Type type;

    public UnitVal() {
        this.type = Type.EMPTY;
    }

    public UnitVal(int n) {
        this.type = Type.INTEGER;
        this.i = n;
    }

    public UnitVal(String string) {
        this.type = Type.STRING;
        this.s = string;
    }

    public UnitVal(OneUnit oneUnit) {
        this.type = Type.UNIT;
        this.u = oneUnit;
    }

    public UnitVal(double d) {
        this.type = Type.DOUBLE;
        this.f = d;
    }

    public UnitVal(double d, boolean bl) {
        if (bl) {
            this.type = Type.LOGDOUBLE;
            this.l10f = d;
        } else {
            this.type = Type.DOUBLE;
            this.f = d;
        }
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        String string = null;
        switch (this.type) {
            case EMPTY: {
                string = "";
                break;
            }
            case INTEGER: {
                string = Integer.toString(this.i);
                break;
            }
            case STRING: {
                string = this.s;
                break;
            }
            case UNIT: {
                string = this.u.toString();
                break;
            }
            case DOUBLE: {
                string = Double.toString(this.f);
                break;
            }
            case LOGDOUBLE: {
                string = Double.toString(Math.pow(10.0, this.l10f));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (string != null);
        return string;
    }

    public static enum Type {
        EMPTY,
        INTEGER,
        STRING,
        UNIT,
        DOUBLE,
        LOGDOUBLE;

    }
}

