# Code for the progress bar in RoutePlanner/RouteEdit
#
# Copyright (C) 1996-2004 Chris Lawrence
# This file may be freely distributed under the terms of the RoutePlanner
# license.  A copy should appear as 'LICENSE' in the archive that this
# file was included in.
#
# $Id: rpprogress.py,v 1.6 2004/06/20 09:35:55 lordsutch Exp $

from __future__ import division
import gtk

def render():
    while gtk.events_pending():
        gtk.main_iteration(False)

class ProgressWin:
    def __init__(self, title='', parent=None):
        self.current, self.max = 0, 1
        self.window = gtk.Window()
        if parent:
            self.window.set_transient_for(parent)
        self.window.set_title(title)
        self.bartitle = gtk.Frame()
        self.bar = gtk.ProgressBar()
        self.bartitle.add(self.bar)
        self.window.set_title(title)
        self.window.connect("delete_event", self.close_clicked)
        self.window.add(self.bartitle)
        self.window.set_default_size(200, -1)
        self.window.set_modal(True)
        self.bar.show()
        self.bartitle.show()

    def set_label(self, label):
        self.bartitle.set_label(label)
        render()

    def set_max(self, maxval):
        self.max = maxval
        self.bar.set_fraction(self.current/self.max)
        render()

    def set_current(self, current):
        self.current = current
        if self.max:
            self.bar.set_fraction(current/self.max)
        else:
            self.bar.set_fraction(0.0)
        render()

    def close_clicked(self, *args):
        self.hide()
        render()
        return True

    def hide(self):
        render()
        self.window.hide()

    def destroy(self):
        self.window.destroy()

    def show(self):
        self.window.show()
        render()
