// Copyright (c) 2017-2021 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Source: https://github.com/MersenneTwister-Lab/MTGP/blob/master/cuda-sample/mtgp32dc-param-11213.c

/*
 * Copyright (c) 2009, 2010 Mutsuo Saito, Makoto Matsumoto and Hiroshima
 * University.  All rights reserved.
 * Copyright (c) 2011 Mutsuo Saito, Makoto Matsumoto, Hiroshima
 * University and University of Tokyo.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of the Hiroshima University nor the names of
 *       its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ROCRAND_MTGP32_11213_H_
#define ROCRAND_MTGP32_11213_H_

#include <stdint.h>
#include "rocrand/rocrand_mtgp32.h"

static rocrand_device::mtgp32_fast_params mtgp32dc_params_fast_11213[]
 = {
    {
        /* No.0 delta:1924 weight:1595 */
        11213,
        19,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4f909277),
         UINT32_C(0xd506358c),
         UINT32_C(0x9a96a7fb),
         UINT32_C(0xecc00000),
         UINT32_C(0xa3509277),
         UINT32_C(0x39c6358c),
         UINT32_C(0x7656a7fb),
         UINT32_C(0x00009fd9),
         UINT32_C(0x4f900dae),
         UINT32_C(0xd506aa55),
         UINT32_C(0x9a963822),
         UINT32_C(0xecc09fd9),
         UINT32_C(0xa3500dae),
         UINT32_C(0x39c6aa55),
         UINT32_C(0x76563822)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007c4132),
         UINT32_C(0x2b4020ed),
         UINT32_C(0x2b3c61df),
         UINT32_C(0x000240a5),
         UINT32_C(0x007e0197),
         UINT32_C(0x2b426048),
         UINT32_C(0x2b3e217a),
         UINT32_C(0x00414015),
         UINT32_C(0x003d0127),
         UINT32_C(0x2b0160f8),
         UINT32_C(0x2b7d21ca),
         UINT32_C(0x004300b0),
         UINT32_C(0x003f4182),
         UINT32_C(0x2b03205d),
         UINT32_C(0x2b7f616f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e20),
         UINT32_C(0x3f95a010),
         UINT32_C(0x3f959e30),
         UINT32_C(0x3f800120),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f95a130),
         UINT32_C(0x3f959f10),
         UINT32_C(0x3f8020a0),
         UINT32_C(0x3f801e80),
         UINT32_C(0x3f9580b0),
         UINT32_C(0x3f95be90),
         UINT32_C(0x3f802180),
         UINT32_C(0x3f801fa0),
         UINT32_C(0x3f958190),
         UINT32_C(0x3f95bfb0)},
        UINT32_C(0xfff80000),
        {0x43,0x93,0x2a,0x2d,0x4c,0xab,0x4c,0xd3,0x8f,0xfb,
         0x1e,0xdd,0x5e,0x1a,0xbb,0x08,0x92,0x84,0x17,0x63,0x00}
    },
    {
        /* No.1 delta:2138 weight:1245 */
        11213,
        36,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x04e7bdd9),
         UINT32_C(0xbd4135d8),
         UINT32_C(0xb9a68801),
         UINT32_C(0xf0c00015),
         UINT32_C(0xf427bdcc),
         UINT32_C(0x4d8135cd),
         UINT32_C(0x49668814),
         UINT32_C(0x0000e79e),
         UINT32_C(0x04e75a47),
         UINT32_C(0xbd41d246),
         UINT32_C(0xb9a66f9f),
         UINT32_C(0xf0c0e78b),
         UINT32_C(0xf4275a52),
         UINT32_C(0x4d81d253),
         UINT32_C(0x49666f8a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007802fe),
         UINT32_C(0x0084013b),
         UINT32_C(0x00fc03c5),
         UINT32_C(0x00060156),
         UINT32_C(0x007e03a8),
         UINT32_C(0x0082006d),
         UINT32_C(0x00fa0293),
         UINT32_C(0x0004001a),
         UINT32_C(0x007c02e4),
         UINT32_C(0x00800121),
         UINT32_C(0x00f803df),
         UINT32_C(0x0002014c),
         UINT32_C(0x007a03b2),
         UINT32_C(0x00860077),
         UINT32_C(0x00fe0289)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803c01),
         UINT32_C(0x3f804200),
         UINT32_C(0x3f807e01),
         UINT32_C(0x3f800300),
         UINT32_C(0x3f803f01),
         UINT32_C(0x3f804100),
         UINT32_C(0x3f807d01),
         UINT32_C(0x3f800200),
         UINT32_C(0x3f803e01),
         UINT32_C(0x3f804000),
         UINT32_C(0x3f807c01),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f803d01),
         UINT32_C(0x3f804300),
         UINT32_C(0x3f807f01)},
        UINT32_C(0xfff80000),
        {0xda,0xdf,0x57,0xe8,0xbe,0xba,0x9b,0x01,0x23,0xe2,
         0x5d,0x4b,0x41,0xf7,0xb2,0x6b,0x77,0x6f,0x03,0xd0,0x00}
    },
    {
        /* No.2 delta:3099 weight:651 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7f1f322e),
         UINT32_C(0xd937af30),
         UINT32_C(0xa6289d1e),
         UINT32_C(0x0940002c),
         UINT32_C(0x765f3202),
         UINT32_C(0xd077af1c),
         UINT32_C(0xaf689d32),
         UINT32_C(0x00001134),
         UINT32_C(0x7f1f231a),
         UINT32_C(0xd937be04),
         UINT32_C(0xa6288c2a),
         UINT32_C(0x09401118),
         UINT32_C(0x765f2336),
         UINT32_C(0xd077be28),
         UINT32_C(0xaf688c06)},
        {UINT32_C(0x00000000),
         UINT32_C(0x824a98bb),
         UINT32_C(0x24000749),
         UINT32_C(0xa64a9ff2),
         UINT32_C(0x49208c71),
         UINT32_C(0xcb6a14ca),
         UINT32_C(0x6d208b38),
         UINT32_C(0xef6a1383),
         UINT32_C(0x0cd00f55),
         UINT32_C(0x8e9a97ee),
         UINT32_C(0x28d0081c),
         UINT32_C(0xaa9a90a7),
         UINT32_C(0x45f08324),
         UINT32_C(0xc7ba1b9f),
         UINT32_C(0x61f0846d),
         UINT32_C(0xe3ba1cd6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc1254c),
         UINT32_C(0x3f920003),
         UINT32_C(0x3fd3254f),
         UINT32_C(0x3fa49046),
         UINT32_C(0x3fe5b50a),
         UINT32_C(0x3fb69045),
         UINT32_C(0x3ff7b509),
         UINT32_C(0x3f866807),
         UINT32_C(0x3fc74d4b),
         UINT32_C(0x3f946804),
         UINT32_C(0x3fd54d48),
         UINT32_C(0x3fa2f841),
         UINT32_C(0x3fe3dd0d),
         UINT32_C(0x3fb0f842),
         UINT32_C(0x3ff1dd0e)},
        UINT32_C(0xfff80000),
        {0x6f,0xaa,0x42,0x5f,0x0c,0xc0,0x2d,0x43,0xf7,0xd3,
         0x08,0xe8,0xa4,0xf5,0x90,0xf9,0x21,0x33,0x77,0x99,0x00}
    },
    {
        /* No.3 delta:1149 weight:1465 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x62e3424e),
         UINT32_C(0xefb75beb),
         UINT32_C(0x8d5419a5),
         UINT32_C(0x40100039),
         UINT32_C(0x22f34277),
         UINT32_C(0xafa75bd2),
         UINT32_C(0xcd44199c),
         UINT32_C(0x000028cd),
         UINT32_C(0x62e36a83),
         UINT32_C(0xefb77326),
         UINT32_C(0x8d543168),
         UINT32_C(0x401028f4),
         UINT32_C(0x22f36aba),
         UINT32_C(0xafa7731f),
         UINT32_C(0xcd443151)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2047d296),
         UINT32_C(0x600c0c1f),
         UINT32_C(0x404bde89),
         UINT32_C(0x3022e17a),
         UINT32_C(0x106533ec),
         UINT32_C(0x502eed65),
         UINT32_C(0x70693ff3),
         UINT32_C(0x0003c01d),
         UINT32_C(0x2044128b),
         UINT32_C(0x600fcc02),
         UINT32_C(0x40481e94),
         UINT32_C(0x30212167),
         UINT32_C(0x1066f3f1),
         UINT32_C(0x502d2d78),
         UINT32_C(0x706affee)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9023e9),
         UINT32_C(0x3fb00606),
         UINT32_C(0x3fa025ef),
         UINT32_C(0x3f981170),
         UINT32_C(0x3f883299),
         UINT32_C(0x3fa81776),
         UINT32_C(0x3fb8349f),
         UINT32_C(0x3f8001e0),
         UINT32_C(0x3f902209),
         UINT32_C(0x3fb007e6),
         UINT32_C(0x3fa0240f),
         UINT32_C(0x3f981090),
         UINT32_C(0x3f883379),
         UINT32_C(0x3fa81696),
         UINT32_C(0x3fb8357f)},
        UINT32_C(0xfff80000),
        {0xfb,0x19,0xb8,0xaa,0x2c,0x32,0xc9,0x9e,0x0d,0xae,
         0xf2,0x6e,0x0e,0xe4,0x9b,0x81,0x41,0xe7,0xa0,0xb4,0x00}
    },
    {
        /* No.4 delta:1024 weight:1407 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x477707e5),
         UINT32_C(0x4312f2cf),
         UINT32_C(0x0465f52a),
         UINT32_C(0x7c10004e),
         UINT32_C(0x3b6707ab),
         UINT32_C(0x3f02f281),
         UINT32_C(0x7875f564),
         UINT32_C(0x0000fcc0),
         UINT32_C(0x4777fb25),
         UINT32_C(0x43120e0f),
         UINT32_C(0x046509ea),
         UINT32_C(0x7c10fc8e),
         UINT32_C(0x3b67fb6b),
         UINT32_C(0x3f020e41),
         UINT32_C(0x787509a4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x600c0cde),
         UINT32_C(0x000c9193),
         UINT32_C(0x60009d4d),
         UINT32_C(0x4000d35f),
         UINT32_C(0x200cdf81),
         UINT32_C(0x400c42cc),
         UINT32_C(0x20004e12),
         UINT32_C(0x10408219),
         UINT32_C(0x704c8ec7),
         UINT32_C(0x104c138a),
         UINT32_C(0x70401f54),
         UINT32_C(0x50405146),
         UINT32_C(0x304c5d98),
         UINT32_C(0x504cc0d5),
         UINT32_C(0x3040cc0b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb00606),
         UINT32_C(0x3f800648),
         UINT32_C(0x3fb0004e),
         UINT32_C(0x3fa00069),
         UINT32_C(0x3f90066f),
         UINT32_C(0x3fa00621),
         UINT32_C(0x3f900027),
         UINT32_C(0x3f882041),
         UINT32_C(0x3fb82647),
         UINT32_C(0x3f882609),
         UINT32_C(0x3fb8200f),
         UINT32_C(0x3fa82028),
         UINT32_C(0x3f98262e),
         UINT32_C(0x3fa82660),
         UINT32_C(0x3f982066)},
        UINT32_C(0xfff80000),
        {0xaa,0x61,0xae,0x97,0xb0,0xc9,0x61,0x3b,0x8c,0x50,
         0xd3,0xba,0xe7,0x18,0xe0,0xe4,0xd0,0xfb,0x02,0xc8,0x00}
    },
    {
        /* No.5 delta:935 weight:1239 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x16f2897a),
         UINT32_C(0x078f68af),
         UINT32_C(0x117de1d5),
         UINT32_C(0xe1100050),
         UINT32_C(0xf7e2892a),
         UINT32_C(0xe69f68ff),
         UINT32_C(0xf06de185),
         UINT32_C(0x00005520),
         UINT32_C(0x16f2dc5a),
         UINT32_C(0x078f3d8f),
         UINT32_C(0x117db4f5),
         UINT32_C(0xe1105570),
         UINT32_C(0xf7e2dc0a),
         UINT32_C(0xe69f3ddf),
         UINT32_C(0xf06db4a5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6006f596),
         UINT32_C(0x00a6008a),
         UINT32_C(0x60a0f51c),
         UINT32_C(0x2002a409),
         UINT32_C(0x4004519f),
         UINT32_C(0x20a4a483),
         UINT32_C(0x40a25115),
         UINT32_C(0x2001e8ee),
         UINT32_C(0x40071d78),
         UINT32_C(0x20a7e864),
         UINT32_C(0x40a11df2),
         UINT32_C(0x00034ce7),
         UINT32_C(0x6005b971),
         UINT32_C(0x00a54c6d),
         UINT32_C(0x60a3b9fb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb0037a),
         UINT32_C(0x3f805300),
         UINT32_C(0x3fb0507a),
         UINT32_C(0x3f900152),
         UINT32_C(0x3fa00228),
         UINT32_C(0x3f905252),
         UINT32_C(0x3fa05128),
         UINT32_C(0x3f9000f4),
         UINT32_C(0x3fa0038e),
         UINT32_C(0x3f9053f4),
         UINT32_C(0x3fa0508e),
         UINT32_C(0x3f8001a6),
         UINT32_C(0x3fb002dc),
         UINT32_C(0x3f8052a6),
         UINT32_C(0x3fb051dc)},
        UINT32_C(0xfff80000),
        {0x75,0xae,0x88,0x03,0x75,0xde,0x93,0x7e,0xa0,0x4e,
         0xfd,0xb2,0x06,0x47,0x4c,0x5a,0x7f,0xa6,0x68,0xf0,0x00}
    },
    {
        /* No.6 delta:2636 weight:1479 */
        11213,
        92,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa236b2f7),
         UINT32_C(0x673cd97c),
         UINT32_C(0xc50a6b8b),
         UINT32_C(0x0740006f),
         UINT32_C(0xa576b298),
         UINT32_C(0x607cd913),
         UINT32_C(0xc24a6be4),
         UINT32_C(0x0000a23f),
         UINT32_C(0xa23610c8),
         UINT32_C(0x673c7b43),
         UINT32_C(0xc50ac9b4),
         UINT32_C(0x0740a250),
         UINT32_C(0xa57610a7),
         UINT32_C(0x607c7b2c),
         UINT32_C(0xc24ac9db)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0003441a),
         UINT32_C(0x1002681f),
         UINT32_C(0x10012c05),
         UINT32_C(0x2000b20d),
         UINT32_C(0x2003f617),
         UINT32_C(0x3002da12),
         UINT32_C(0x30019e08),
         UINT32_C(0x2000001b),
         UINT32_C(0x20034401),
         UINT32_C(0x30026804),
         UINT32_C(0x30012c1e),
         UINT32_C(0x0000b216),
         UINT32_C(0x0003f60c),
         UINT32_C(0x1002da09),
         UINT32_C(0x10019e13)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8001a2),
         UINT32_C(0x3f880134),
         UINT32_C(0x3f880096),
         UINT32_C(0x3f900059),
         UINT32_C(0x3f9001fb),
         UINT32_C(0x3f98016d),
         UINT32_C(0x3f9800cf),
         UINT32_C(0x3f900000),
         UINT32_C(0x3f9001a2),
         UINT32_C(0x3f980134),
         UINT32_C(0x3f980096),
         UINT32_C(0x3f800059),
         UINT32_C(0x3f8001fb),
         UINT32_C(0x3f88016d),
         UINT32_C(0x3f8800cf)},
        UINT32_C(0xfff80000),
        {0xff,0xdb,0x7b,0xc1,0xcb,0xf5,0x52,0x32,0x4d,0x74,
         0xd0,0xbb,0x88,0x29,0x89,0x26,0xba,0x41,0x92,0xe3,0x00}
    },
    {
        /* No.7 delta:1036 weight:1615 */
        11213,
        47,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x13dc0d56),
         UINT32_C(0xfcc23381),
         UINT32_C(0xef1e3ed7),
         UINT32_C(0x65e00072),
         UINT32_C(0x763c0d24),
         UINT32_C(0x992233f3),
         UINT32_C(0x8afe3ea5),
         UINT32_C(0x00003944),
         UINT32_C(0x13dc3412),
         UINT32_C(0xfcc20ac5),
         UINT32_C(0xef1e0793),
         UINT32_C(0x65e03936),
         UINT32_C(0x763c3460),
         UINT32_C(0x99220ab7),
         UINT32_C(0x8afe07e1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x304c1192),
         UINT32_C(0x0002c01d),
         UINT32_C(0x304ed18f),
         UINT32_C(0x60482c07),
         UINT32_C(0x50043d95),
         UINT32_C(0x604aec1a),
         UINT32_C(0x5006fd88),
         UINT32_C(0x600001c4),
         UINT32_C(0x504c1056),
         UINT32_C(0x6002c1d9),
         UINT32_C(0x504ed04b),
         UINT32_C(0x00482dc3),
         UINT32_C(0x30043c51),
         UINT32_C(0x004aedde),
         UINT32_C(0x3006fc4c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f982608),
         UINT32_C(0x3f800160),
         UINT32_C(0x3f982768),
         UINT32_C(0x3fb02416),
         UINT32_C(0x3fa8021e),
         UINT32_C(0x3fb02576),
         UINT32_C(0x3fa8037e),
         UINT32_C(0x3fb00000),
         UINT32_C(0x3fa82608),
         UINT32_C(0x3fb00160),
         UINT32_C(0x3fa82768),
         UINT32_C(0x3f802416),
         UINT32_C(0x3f98021e),
         UINT32_C(0x3f802576),
         UINT32_C(0x3f98037e)},
        UINT32_C(0xfff80000),
        {0xf5,0x20,0xa8,0x18,0xff,0xcc,0xac,0xc9,0x44,0xd4,
         0x78,0x19,0x0a,0x78,0x20,0x63,0xe8,0x72,0x36,0x71,0x00}
    },
    {
        /* No.8 delta:1185 weight:1437 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8ffabd15),
         UINT32_C(0x251190b0),
         UINT32_C(0xaaeb2da5),
         UINT32_C(0x6180008a),
         UINT32_C(0xee7abd9f),
         UINT32_C(0x4491903a),
         UINT32_C(0xcb6b2d2f),
         UINT32_C(0x00003391),
         UINT32_C(0x8ffa8e84),
         UINT32_C(0x2511a321),
         UINT32_C(0xaaeb1e34),
         UINT32_C(0x6180331b),
         UINT32_C(0xee7a8e0e),
         UINT32_C(0x4491a3ab),
         UINT32_C(0xcb6b1ebe)},
        {UINT32_C(0x00000000),
         UINT32_C(0x087422da),
         UINT32_C(0x0002d1fd),
         UINT32_C(0x0876f327),
         UINT32_C(0x9010009e),
         UINT32_C(0x98642244),
         UINT32_C(0x9012d163),
         UINT32_C(0x9866f3b9),
         UINT32_C(0x506880d6),
         UINT32_C(0x581ca20c),
         UINT32_C(0x506a512b),
         UINT32_C(0x581e73f1),
         UINT32_C(0xc0788048),
         UINT32_C(0xc80ca292),
         UINT32_C(0xc07a51b5),
         UINT32_C(0xc80e736f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f843a11),
         UINT32_C(0x3f800168),
         UINT32_C(0x3f843b79),
         UINT32_C(0x3fc80800),
         UINT32_C(0x3fcc3211),
         UINT32_C(0x3fc80968),
         UINT32_C(0x3fcc3379),
         UINT32_C(0x3fa83440),
         UINT32_C(0x3fac0e51),
         UINT32_C(0x3fa83528),
         UINT32_C(0x3fac0f39),
         UINT32_C(0x3fe03c40),
         UINT32_C(0x3fe40651),
         UINT32_C(0x3fe03d28),
         UINT32_C(0x3fe40739)},
        UINT32_C(0xfff80000),
        {0xe8,0x7d,0x49,0xd8,0x59,0xcb,0xa2,0xaa,0xce,0xb9,
         0xd8,0xd9,0x4e,0x89,0xff,0x1e,0xc6,0x5c,0x9c,0x62,0x00}
    },
    {
        /* No.9 delta:940 weight:1557 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x75b471ab),
         UINT32_C(0xa13c72ac),
         UINT32_C(0xd4880307),
         UINT32_C(0x64d00099),
         UINT32_C(0x11647132),
         UINT32_C(0xc5ec7235),
         UINT32_C(0xb058039e),
         UINT32_C(0x00007a74),
         UINT32_C(0x75b40bdf),
         UINT32_C(0xa13c08d8),
         UINT32_C(0xd4887973),
         UINT32_C(0x64d07aed),
         UINT32_C(0x11640b46),
         UINT32_C(0xc5ec0841),
         UINT32_C(0xb05879ea)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0001f4d5),
         UINT32_C(0x104e140e),
         UINT32_C(0x104fe0db),
         UINT32_C(0x20022818),
         UINT32_C(0x2003dccd),
         UINT32_C(0x304c3c16),
         UINT32_C(0x304dc8c3),
         UINT32_C(0x2000278c),
         UINT32_C(0x2001d359),
         UINT32_C(0x304e3382),
         UINT32_C(0x304fc757),
         UINT32_C(0x00020f94),
         UINT32_C(0x0003fb41),
         UINT32_C(0x104c1b9a),
         UINT32_C(0x104def4f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8000fa),
         UINT32_C(0x3f88270a),
         UINT32_C(0x3f8827f0),
         UINT32_C(0x3f900114),
         UINT32_C(0x3f9001ee),
         UINT32_C(0x3f98261e),
         UINT32_C(0x3f9826e4),
         UINT32_C(0x3f900013),
         UINT32_C(0x3f9000e9),
         UINT32_C(0x3f982719),
         UINT32_C(0x3f9827e3),
         UINT32_C(0x3f800107),
         UINT32_C(0x3f8001fd),
         UINT32_C(0x3f88260d),
         UINT32_C(0x3f8826f7)},
        UINT32_C(0xfff80000),
        {0xf3,0x2e,0xad,0xf6,0x6f,0x50,0x04,0xb1,0x67,0x86,
         0x75,0x45,0x70,0x60,0x5d,0x63,0xaf,0x93,0x7f,0xa0,0x00}
    },
    {
        /* No.10 delta:2070 weight:1315 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xaff041eb),
         UINT32_C(0x194d1f47),
         UINT32_C(0xb6bd5eac),
         UINT32_C(0x58a000a5),
         UINT32_C(0xf750414e),
         UINT32_C(0x41ed1fe2),
         UINT32_C(0xee1d5e09),
         UINT32_C(0x0000bcbf),
         UINT32_C(0xaff0fd54),
         UINT32_C(0x194da3f8),
         UINT32_C(0xb6bde213),
         UINT32_C(0x58a0bc1a),
         UINT32_C(0xf750fdf1),
         UINT32_C(0x41eda35d),
         UINT32_C(0xee1de2b6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1082801b),
         UINT32_C(0x0800e183),
         UINT32_C(0x18826198),
         UINT32_C(0x009c291f),
         UINT32_C(0x101ea904),
         UINT32_C(0x089cc89c),
         UINT32_C(0x181e4887),
         UINT32_C(0x60002519),
         UINT32_C(0x7082a502),
         UINT32_C(0x6800c49a),
         UINT32_C(0x78824481),
         UINT32_C(0x609c0c06),
         UINT32_C(0x701e8c1d),
         UINT32_C(0x689ced85),
         UINT32_C(0x781e6d9e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f884140),
         UINT32_C(0x3f840070),
         UINT32_C(0x3f8c4130),
         UINT32_C(0x3f804e14),
         UINT32_C(0x3f880f54),
         UINT32_C(0x3f844e64),
         UINT32_C(0x3f8c0f24),
         UINT32_C(0x3fb00012),
         UINT32_C(0x3fb84152),
         UINT32_C(0x3fb40062),
         UINT32_C(0x3fbc4122),
         UINT32_C(0x3fb04e06),
         UINT32_C(0x3fb80f46),
         UINT32_C(0x3fb44e76),
         UINT32_C(0x3fbc0f36)},
        UINT32_C(0xfff80000),
        {0x5d,0x09,0x8c,0x60,0x3e,0xd8,0x24,0xaf,0x49,0xc9,
         0xa3,0x2e,0xab,0x4f,0xb4,0xe6,0x15,0x68,0xd1,0x47,0x00}
    },
    {
        /* No.11 delta:1515 weight:1659 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x98993010),
         UINT32_C(0xd2526ec9),
         UINT32_C(0x4acb5ed9),
         UINT32_C(0x148000b8),
         UINT32_C(0x8c1930a8),
         UINT32_C(0xc6d26e71),
         UINT32_C(0x5e4b5e61),
         UINT32_C(0x00004381),
         UINT32_C(0x98997391),
         UINT32_C(0xd2522d48),
         UINT32_C(0x4acb1d58),
         UINT32_C(0x14804339),
         UINT32_C(0x8c197329),
         UINT32_C(0xc6d22df0),
         UINT32_C(0x5e4b1de0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1f8f2033),
         UINT32_C(0x2051c174),
         UINT32_C(0x3fdee147),
         UINT32_C(0x2121601a),
         UINT32_C(0x3eae4029),
         UINT32_C(0x0170a16e),
         UINT32_C(0x1eff815d),
         UINT32_C(0x00412412),
         UINT32_C(0x1fce0421),
         UINT32_C(0x2010e566),
         UINT32_C(0x3f9fc555),
         UINT32_C(0x21604408),
         UINT32_C(0x3eef643b),
         UINT32_C(0x0131857c),
         UINT32_C(0x1ebea54f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8fc790),
         UINT32_C(0x3f9028e0),
         UINT32_C(0x3f9fef70),
         UINT32_C(0x3f9090b0),
         UINT32_C(0x3f9f5720),
         UINT32_C(0x3f80b850),
         UINT32_C(0x3f8f7fc0),
         UINT32_C(0x3f802092),
         UINT32_C(0x3f8fe702),
         UINT32_C(0x3f900872),
         UINT32_C(0x3f9fcfe2),
         UINT32_C(0x3f90b022),
         UINT32_C(0x3f9f77b2),
         UINT32_C(0x3f8098c2),
         UINT32_C(0x3f8f5f52)},
        UINT32_C(0xfff80000),
        {0xbe,0x72,0x05,0x26,0xcb,0xaa,0x6d,0x25,0xac,0xaf,
         0x9c,0x2f,0xe1,0xe7,0x35,0x3c,0x6e,0x4e,0x4b,0x24,0x00}
    },
    {
        /* No.12 delta:820 weight:1581 */
        11213,
        73,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xddfffc66),
         UINT32_C(0x11479e19),
         UINT32_C(0xccb8627f),
         UINT32_C(0x8d1000c6),
         UINT32_C(0x50effca0),
         UINT32_C(0x9c579edf),
         UINT32_C(0x41a862b9),
         UINT32_C(0x00004882),
         UINT32_C(0xddffb4e4),
         UINT32_C(0x1147d69b),
         UINT32_C(0xccb82afd),
         UINT32_C(0x8d104844),
         UINT32_C(0x50efb422),
         UINT32_C(0x9c57d65d),
         UINT32_C(0x41a82a3b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000d341f),
         UINT32_C(0x7001d194),
         UINT32_C(0x700ce58b),
         UINT32_C(0x0122201d),
         UINT32_C(0x012f1402),
         UINT32_C(0x7123f189),
         UINT32_C(0x712ec596),
         UINT32_C(0x040d80b7),
         UINT32_C(0x0400b4a8),
         UINT32_C(0x740c5123),
         UINT32_C(0x7401653c),
         UINT32_C(0x052fa0aa),
         UINT32_C(0x052294b5),
         UINT32_C(0x752e713e),
         UINT32_C(0x75234521)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80069a),
         UINT32_C(0x3fb800e8),
         UINT32_C(0x3fb80672),
         UINT32_C(0x3f809110),
         UINT32_C(0x3f80978a),
         UINT32_C(0x3fb891f8),
         UINT32_C(0x3fb89762),
         UINT32_C(0x3f8206c0),
         UINT32_C(0x3f82005a),
         UINT32_C(0x3fba0628),
         UINT32_C(0x3fba00b2),
         UINT32_C(0x3f8297d0),
         UINT32_C(0x3f82914a),
         UINT32_C(0x3fba9738),
         UINT32_C(0x3fba91a2)},
        UINT32_C(0xfff80000),
        {0x6e,0xf5,0x55,0xa0,0x30,0x84,0x66,0xdc,0xa6,0x4a,
         0x52,0xe1,0xd8,0x99,0x66,0x12,0xd7,0x4b,0x83,0x2c,0x00}
    },
    {
        /* No.13 delta:707 weight:1529 */
        11213,
        73,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9b47b275),
         UINT32_C(0x3b5e5ca5),
         UINT32_C(0xa019eed0),
         UINT32_C(0x72c000d6),
         UINT32_C(0xe987b2a3),
         UINT32_C(0x499e5c73),
         UINT32_C(0xd2d9ee06),
         UINT32_C(0x000090c6),
         UINT32_C(0x9b4722b3),
         UINT32_C(0x3b5ecc63),
         UINT32_C(0xa0197e16),
         UINT32_C(0x72c09010),
         UINT32_C(0xe9872265),
         UINT32_C(0x499eccb5),
         UINT32_C(0xd2d97ec0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2068289d),
         UINT32_C(0x10121266),
         UINT32_C(0x307a3afb),
         UINT32_C(0x201641bf),
         UINT32_C(0x007e6922),
         UINT32_C(0x300453d9),
         UINT32_C(0x106c7b44),
         UINT32_C(0x00120017),
         UINT32_C(0x207a288a),
         UINT32_C(0x10001271),
         UINT32_C(0x30683aec),
         UINT32_C(0x200441a8),
         UINT32_C(0x006c6935),
         UINT32_C(0x301653ce),
         UINT32_C(0x107e7b53)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f903414),
         UINT32_C(0x3f880909),
         UINT32_C(0x3f983d1d),
         UINT32_C(0x3f900b20),
         UINT32_C(0x3f803f34),
         UINT32_C(0x3f980229),
         UINT32_C(0x3f88363d),
         UINT32_C(0x3f800900),
         UINT32_C(0x3f903d14),
         UINT32_C(0x3f880009),
         UINT32_C(0x3f98341d),
         UINT32_C(0x3f900220),
         UINT32_C(0x3f803634),
         UINT32_C(0x3f980b29),
         UINT32_C(0x3f883f3d)},
        UINT32_C(0xfff80000),
        {0x24,0xca,0x5b,0xd7,0x52,0x91,0x29,0xca,0xa8,0x9b,
         0x1b,0x5e,0xb6,0x1d,0x1e,0x72,0x3d,0x9d,0xdb,0x31,0x00}
    },
    {
        /* No.14 delta:740 weight:1357 */
        11213,
        79,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa4ded64e),
         UINT32_C(0xeb88426b),
         UINT32_C(0x4f569425),
         UINT32_C(0x56d000e9),
         UINT32_C(0xf20ed6a7),
         UINT32_C(0xbd584282),
         UINT32_C(0x198694cc),
         UINT32_C(0x0000e140),
         UINT32_C(0xa4de370e),
         UINT32_C(0xeb88a32b),
         UINT32_C(0x4f567565),
         UINT32_C(0x56d0e1a9),
         UINT32_C(0xf20e37e7),
         UINT32_C(0xbd58a3c2),
         UINT32_C(0x1986758c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00031972),
         UINT32_C(0x20046011),
         UINT32_C(0x20077963),
         UINT32_C(0x40081018),
         UINT32_C(0x400b096a),
         UINT32_C(0x600c7009),
         UINT32_C(0x600f697b),
         UINT32_C(0x4140013c),
         UINT32_C(0x4143184e),
         UINT32_C(0x6144612d),
         UINT32_C(0x6147785f),
         UINT32_C(0x01481124),
         UINT32_C(0x014b0856),
         UINT32_C(0x214c7135),
         UINT32_C(0x214f6847)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80018c),
         UINT32_C(0x3f900230),
         UINT32_C(0x3f9003bc),
         UINT32_C(0x3fa00408),
         UINT32_C(0x3fa00584),
         UINT32_C(0x3fb00638),
         UINT32_C(0x3fb007b4),
         UINT32_C(0x3fa0a000),
         UINT32_C(0x3fa0a18c),
         UINT32_C(0x3fb0a230),
         UINT32_C(0x3fb0a3bc),
         UINT32_C(0x3f80a408),
         UINT32_C(0x3f80a584),
         UINT32_C(0x3f90a638),
         UINT32_C(0x3f90a7b4)},
        UINT32_C(0xfff80000),
        {0xc3,0x74,0x1c,0x60,0x3b,0xf4,0xad,0x34,0x2e,0x3d,
         0xf9,0xde,0x63,0x53,0xf9,0xe5,0xcf,0x78,0x9a,0x9d,0x00}
    },
    {
        /* No.15 delta:1412 weight:1175 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd5f40b06),
         UINT32_C(0x9e909b5e),
         UINT32_C(0x4b649058),
         UINT32_C(0xd5b000f1),
         UINT32_C(0x00440bf7),
         UINT32_C(0x4b209baf),
         UINT32_C(0x9ed490a9),
         UINT32_C(0x00006d10),
         UINT32_C(0xd5f46616),
         UINT32_C(0x9e90f64e),
         UINT32_C(0x4b64fd48),
         UINT32_C(0xd5b06de1),
         UINT32_C(0x004466e7),
         UINT32_C(0x4b20f6bf),
         UINT32_C(0x9ed4fdb9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0035813a),
         UINT32_C(0x104ac0ec),
         UINT32_C(0x107f41d6),
         UINT32_C(0x00024054),
         UINT32_C(0x0037c16e),
         UINT32_C(0x104880b8),
         UINT32_C(0x107d0182),
         UINT32_C(0x100040a4),
         UINT32_C(0x1035c19e),
         UINT32_C(0x004a8048),
         UINT32_C(0x007f0172),
         UINT32_C(0x100200f0),
         UINT32_C(0x103781ca),
         UINT32_C(0x0048c01c),
         UINT32_C(0x007d4126)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801ac0),
         UINT32_C(0x3f882560),
         UINT32_C(0x3f883fa0),
         UINT32_C(0x3f800120),
         UINT32_C(0x3f801be0),
         UINT32_C(0x3f882440),
         UINT32_C(0x3f883e80),
         UINT32_C(0x3f880020),
         UINT32_C(0x3f881ae0),
         UINT32_C(0x3f802540),
         UINT32_C(0x3f803f80),
         UINT32_C(0x3f880100),
         UINT32_C(0x3f881bc0),
         UINT32_C(0x3f802460),
         UINT32_C(0x3f803ea0)},
        UINT32_C(0xfff80000),
        {0x1c,0xc5,0xf3,0xcc,0xc0,0xa1,0xf5,0x12,0xe1,0x21,
         0x45,0x6c,0x8c,0xe8,0x81,0x31,0xc4,0x16,0xc8,0x01,0x00}
    },
    {
        /* No.16 delta:829 weight:1511 */
        11213,
        82,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6a4ed196),
         UINT32_C(0x75986580),
         UINT32_C(0x1fd6b416),
         UINT32_C(0xb6f00102),
         UINT32_C(0xdcbed094),
         UINT32_C(0xc3686482),
         UINT32_C(0xa926b514),
         UINT32_C(0x0000ff65),
         UINT32_C(0x6a4e2ef3),
         UINT32_C(0x75989ae5),
         UINT32_C(0x1fd64b73),
         UINT32_C(0xb6f0fe67),
         UINT32_C(0xdcbe2ff1),
         UINT32_C(0xc3689be7),
         UINT32_C(0xa9264a71)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4024d5d3),
         UINT32_C(0x4060c1ff),
         UINT32_C(0x0044142c),
         UINT32_C(0x003141b5),
         UINT32_C(0x40159466),
         UINT32_C(0x4051804a),
         UINT32_C(0x00755599),
         UINT32_C(0x000241de),
         UINT32_C(0x4026940d),
         UINT32_C(0x40628021),
         UINT32_C(0x004655f2),
         UINT32_C(0x0033006b),
         UINT32_C(0x4017d5b8),
         UINT32_C(0x4053c194),
         UINT32_C(0x00771447)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0126a),
         UINT32_C(0x3fa03060),
         UINT32_C(0x3f80220a),
         UINT32_C(0x3f8018a0),
         UINT32_C(0x3fa00aca),
         UINT32_C(0x3fa028c0),
         UINT32_C(0x3f803aaa),
         UINT32_C(0x3f800120),
         UINT32_C(0x3fa0134a),
         UINT32_C(0x3fa03140),
         UINT32_C(0x3f80232a),
         UINT32_C(0x3f801980),
         UINT32_C(0x3fa00bea),
         UINT32_C(0x3fa029e0),
         UINT32_C(0x3f803b8a)},
        UINT32_C(0xfff80000),
        {0x90,0xef,0xab,0xea,0x9a,0x3e,0x54,0x08,0xd7,0x59,
         0x31,0x77,0x70,0x41,0x3a,0x49,0x1d,0x02,0xc8,0x4d,0x00}
    },
    {
        /* No.17 delta:939 weight:1249 */
        11213,
        50,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9b6dd2da),
         UINT32_C(0x7a47766d),
         UINT32_C(0xe12aa4b7),
         UINT32_C(0x28b00115),
         UINT32_C(0xb3ddd3cf),
         UINT32_C(0x52f77778),
         UINT32_C(0xc99aa5a2),
         UINT32_C(0x0000ac7e),
         UINT32_C(0x9b6d7ea4),
         UINT32_C(0x7a47da13),
         UINT32_C(0xe12a08c9),
         UINT32_C(0x28b0ad6b),
         UINT32_C(0xb3dd7fb1),
         UINT32_C(0x52f7db06),
         UINT32_C(0xc99a09dc)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0074455a),
         UINT32_C(0x10038197),
         UINT32_C(0x1077c4cd),
         UINT32_C(0x00027014),
         UINT32_C(0x0076354e),
         UINT32_C(0x1001f183),
         UINT32_C(0x1075b4d9),
         UINT32_C(0x100a0011),
         UINT32_C(0x107e454b),
         UINT32_C(0x00098186),
         UINT32_C(0x007dc4dc),
         UINT32_C(0x10087005),
         UINT32_C(0x107c355f),
         UINT32_C(0x000bf192),
         UINT32_C(0x007fb4c8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a22),
         UINT32_C(0x3f8801c0),
         UINT32_C(0x3f883be2),
         UINT32_C(0x3f800138),
         UINT32_C(0x3f803b1a),
         UINT32_C(0x3f8800f8),
         UINT32_C(0x3f883ada),
         UINT32_C(0x3f880500),
         UINT32_C(0x3f883f22),
         UINT32_C(0x3f8004c0),
         UINT32_C(0x3f803ee2),
         UINT32_C(0x3f880438),
         UINT32_C(0x3f883e1a),
         UINT32_C(0x3f8005f8),
         UINT32_C(0x3f803fda)},
        UINT32_C(0xfff80000),
        {0x1d,0x4d,0xd6,0x26,0x63,0x10,0x49,0x3c,0xd2,0x16,
         0xf9,0xb1,0xc2,0x24,0x34,0xcf,0x7d,0x43,0x28,0xcb,0x00}
    },
    {
        /* No.18 delta:1038 weight:1423 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb32bc1dd),
         UINT32_C(0x940d95ad),
         UINT32_C(0x27265470),
         UINT32_C(0x4bb0012e),
         UINT32_C(0xf89bc0f3),
         UINT32_C(0xdfbd9483),
         UINT32_C(0x6c96555e),
         UINT32_C(0x0000d383),
         UINT32_C(0xb32b125e),
         UINT32_C(0x940d462e),
         UINT32_C(0x272687f3),
         UINT32_C(0x4bb0d2ad),
         UINT32_C(0xf89b1370),
         UINT32_C(0xdfbd4700),
         UINT32_C(0x6c9686dd)},
        {UINT32_C(0x00000000),
         UINT32_C(0x100c2016),
         UINT32_C(0x0003a04f),
         UINT32_C(0x100f8059),
         UINT32_C(0x2040861d),
         UINT32_C(0x304ca60b),
         UINT32_C(0x20432652),
         UINT32_C(0x304f0644),
         UINT32_C(0x0050ea1f),
         UINT32_C(0x105cca09),
         UINT32_C(0x00534a50),
         UINT32_C(0x105f6a46),
         UINT32_C(0x20106c02),
         UINT32_C(0x301c4c14),
         UINT32_C(0x2013cc4d),
         UINT32_C(0x301fec5b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880610),
         UINT32_C(0x3f8001d0),
         UINT32_C(0x3f8807c0),
         UINT32_C(0x3f902043),
         UINT32_C(0x3f982653),
         UINT32_C(0x3f902193),
         UINT32_C(0x3f982783),
         UINT32_C(0x3f802875),
         UINT32_C(0x3f882e65),
         UINT32_C(0x3f8029a5),
         UINT32_C(0x3f882fb5),
         UINT32_C(0x3f900836),
         UINT32_C(0x3f980e26),
         UINT32_C(0x3f9009e6),
         UINT32_C(0x3f980ff6)},
        UINT32_C(0xfff80000),
        {0x64,0x79,0xc7,0x6f,0xcc,0x48,0x7c,0x0a,0x43,0xe9,
         0x95,0xcd,0x1c,0x2d,0xa0,0xc0,0x7e,0x12,0xc2,0xf7,0x00}
    },
    {
        /* No.19 delta:2427 weight:765 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbd514c94),
         UINT32_C(0xd2534abd),
         UINT32_C(0x6f020629),
         UINT32_C(0xbf20013d),
         UINT32_C(0x02714da9),
         UINT32_C(0x6d734b80),
         UINT32_C(0xd0220714),
         UINT32_C(0x00002d73),
         UINT32_C(0xbd5161e7),
         UINT32_C(0xd25367ce),
         UINT32_C(0x6f022b5a),
         UINT32_C(0xbf202c4e),
         UINT32_C(0x027160da),
         UINT32_C(0x6d7366f3),
         UINT32_C(0xd0222a67)},
        {UINT32_C(0x00000000),
         UINT32_C(0x19a54197),
         UINT32_C(0x106021ca),
         UINT32_C(0x09c5605d),
         UINT32_C(0x101000ff),
         UINT32_C(0x09b54168),
         UINT32_C(0x00702135),
         UINT32_C(0x19d560a2),
         UINT32_C(0x004800b0),
         UINT32_C(0x19ed4127),
         UINT32_C(0x1028217a),
         UINT32_C(0x098d60ed),
         UINT32_C(0x1058004f),
         UINT32_C(0x09fd41d8),
         UINT32_C(0x00382185),
         UINT32_C(0x199d6012)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8cd2a0),
         UINT32_C(0x3f883010),
         UINT32_C(0x3f84e2b0),
         UINT32_C(0x3f880800),
         UINT32_C(0x3f84daa0),
         UINT32_C(0x3f803810),
         UINT32_C(0x3f8ceab0),
         UINT32_C(0x3f802400),
         UINT32_C(0x3f8cf6a0),
         UINT32_C(0x3f881410),
         UINT32_C(0x3f84c6b0),
         UINT32_C(0x3f882c00),
         UINT32_C(0x3f84fea0),
         UINT32_C(0x3f801c10),
         UINT32_C(0x3f8cceb0)},
        UINT32_C(0xfff80000),
        {0x7d,0x7c,0x61,0x34,0xcc,0xaf,0xb1,0x1c,0xa1,0xe8,
         0x1d,0xb4,0xa9,0x8f,0x15,0x98,0xd1,0xba,0x42,0x9b,0x00}
    },
    {
        /* No.20 delta:1784 weight:1485 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfeb307f4),
         UINT32_C(0x3c1e7eea),
         UINT32_C(0xc2ad791e),
         UINT32_C(0x33d00140),
         UINT32_C(0xcd6306b4),
         UINT32_C(0x0fce7faa),
         UINT32_C(0xf17d785e),
         UINT32_C(0x00007ab3),
         UINT32_C(0xfeb37d47),
         UINT32_C(0x3c1e0459),
         UINT32_C(0xc2ad03ad),
         UINT32_C(0x33d07bf3),
         UINT32_C(0xcd637c07),
         UINT32_C(0x0fce0519),
         UINT32_C(0xf17d02ed)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0ae69956),
         UINT32_C(0x54269098),
         UINT32_C(0x5ec009ce),
         UINT32_C(0x304007d5),
         UINT32_C(0x3aa69e83),
         UINT32_C(0x6466974d),
         UINT32_C(0x6e800e1b),
         UINT32_C(0x0059801d),
         UINT32_C(0x0abf194b),
         UINT32_C(0x547f1085),
         UINT32_C(0x5e9989d3),
         UINT32_C(0x301987c8),
         UINT32_C(0x3aff1e9e),
         UINT32_C(0x643f1750),
         UINT32_C(0x6ed98e06)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f85734c),
         UINT32_C(0x3faa1348),
         UINT32_C(0x3faf6004),
         UINT32_C(0x3f982003),
         UINT32_C(0x3f9d534f),
         UINT32_C(0x3fb2334b),
         UINT32_C(0x3fb74007),
         UINT32_C(0x3f802cc0),
         UINT32_C(0x3f855f8c),
         UINT32_C(0x3faa3f88),
         UINT32_C(0x3faf4cc4),
         UINT32_C(0x3f980cc3),
         UINT32_C(0x3f9d7f8f),
         UINT32_C(0x3fb21f8b),
         UINT32_C(0x3fb76cc7)},
        UINT32_C(0xfff80000),
        {0x3f,0xcf,0x58,0xca,0x42,0x13,0xe5,0xd0,0x0f,0x09,
         0x0b,0x67,0x5b,0xb8,0x8c,0x3d,0x2c,0xd8,0xef,0x68,0x00}
    },
    {
        /* No.21 delta:974 weight:1601 */
        11213,
        56,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2554da2a),
         UINT32_C(0xc20d8e4e),
         UINT32_C(0xe7595464),
         UINT32_C(0xd500015a),
         UINT32_C(0xf054db70),
         UINT32_C(0x170d8f14),
         UINT32_C(0x3259553e),
         UINT32_C(0x0000b8c9),
         UINT32_C(0x255462e3),
         UINT32_C(0xc20d3687),
         UINT32_C(0xe759ecad),
         UINT32_C(0xd500b993),
         UINT32_C(0xf05463b9),
         UINT32_C(0x170d37dd),
         UINT32_C(0x3259edf7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000264d6),
         UINT32_C(0x00010c23),
         UINT32_C(0x000368f5),
         UINT32_C(0x102ca1fb),
         UINT32_C(0x102ec52d),
         UINT32_C(0x102dadd8),
         UINT32_C(0x102fc90e),
         UINT32_C(0xf01c200a),
         UINT32_C(0xf01e44dc),
         UINT32_C(0xf01d2c29),
         UINT32_C(0xf01f48ff),
         UINT32_C(0xe03081f1),
         UINT32_C(0xe032e527),
         UINT32_C(0xe0318dd2),
         UINT32_C(0xe033e904)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800132),
         UINT32_C(0x3f800086),
         UINT32_C(0x3f8001b4),
         UINT32_C(0x3f881650),
         UINT32_C(0x3f881762),
         UINT32_C(0x3f8816d6),
         UINT32_C(0x3f8817e4),
         UINT32_C(0x3ff80e10),
         UINT32_C(0x3ff80f22),
         UINT32_C(0x3ff80e96),
         UINT32_C(0x3ff80fa4),
         UINT32_C(0x3ff01840),
         UINT32_C(0x3ff01972),
         UINT32_C(0x3ff018c6),
         UINT32_C(0x3ff019f4)},
        UINT32_C(0xfff80000),
        {0x49,0xb2,0x44,0x10,0x53,0x58,0xa0,0x92,0xcc,0x3a,
         0xbc,0x4f,0x77,0x55,0xeb,0x20,0xc6,0xbf,0x94,0x54,0x00}
    },
    {
        /* No.22 delta:3113 weight:577 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1c0fe41b),
         UINT32_C(0x17e3e180),
         UINT32_C(0x0bec059b),
         UINT32_C(0x3210016f),
         UINT32_C(0x2e1fe574),
         UINT32_C(0x25f3e0ef),
         UINT32_C(0x39fc04f4),
         UINT32_C(0x0000f40c),
         UINT32_C(0x1c0f1017),
         UINT32_C(0x17e3158c),
         UINT32_C(0x0becf197),
         UINT32_C(0x3210f563),
         UINT32_C(0x2e1f1178),
         UINT32_C(0x25f314e3),
         UINT32_C(0x39fcf0f8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8800a03e),
         UINT32_C(0x4c6061c3),
         UINT32_C(0xc460c1fd),
         UINT32_C(0x0e210048),
         UINT32_C(0x8621a076),
         UINT32_C(0x4241618b),
         UINT32_C(0xca41c1b5),
         UINT32_C(0x84304150),
         UINT32_C(0x0c30e16e),
         UINT32_C(0xc8502093),
         UINT32_C(0x405080ad),
         UINT32_C(0x8a114118),
         UINT32_C(0x0211e126),
         UINT32_C(0xc67120db),
         UINT32_C(0x4e7180e5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc40050),
         UINT32_C(0x3fa63030),
         UINT32_C(0x3fe23060),
         UINT32_C(0x3f871080),
         UINT32_C(0x3fc310d0),
         UINT32_C(0x3fa120b0),
         UINT32_C(0x3fe520e0),
         UINT32_C(0x3fc21820),
         UINT32_C(0x3f861870),
         UINT32_C(0x3fe42810),
         UINT32_C(0x3fa02840),
         UINT32_C(0x3fc508a0),
         UINT32_C(0x3f8108f0),
         UINT32_C(0x3fe33890),
         UINT32_C(0x3fa738c0)},
        UINT32_C(0xfff80000),
        {0xd3,0x3b,0x23,0x49,0xd1,0x4b,0xe8,0xf0,0x12,0xf9,
         0x95,0xf9,0x30,0x1c,0xa0,0xc1,0xa7,0xc7,0xb2,0xb2,0x00}
    },
    {
        /* No.23 delta:2078 weight:1299 */
        11213,
        72,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x81f19cc8),
         UINT32_C(0x40d67766),
         UINT32_C(0xc127ebae),
         UINT32_C(0xbbb0017f),
         UINT32_C(0x3a419db7),
         UINT32_C(0xfb667619),
         UINT32_C(0x7a97ead1),
         UINT32_C(0x00003964),
         UINT32_C(0x81f1a5ac),
         UINT32_C(0x40d64e02),
         UINT32_C(0xc127d2ca),
         UINT32_C(0xbbb0381b),
         UINT32_C(0x3a41a4d3),
         UINT32_C(0xfb664f7d),
         UINT32_C(0x7a97d3b5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0106027a),
         UINT32_C(0x0024013f),
         UINT32_C(0x01220345),
         UINT32_C(0x0070002b),
         UINT32_C(0x01760251),
         UINT32_C(0x00540114),
         UINT32_C(0x0152036e),
         UINT32_C(0x004c00bd),
         UINT32_C(0x014a02c7),
         UINT32_C(0x00680182),
         UINT32_C(0x016e03f8),
         UINT32_C(0x003c0096),
         UINT32_C(0x013a02ec),
         UINT32_C(0x001801a9),
         UINT32_C(0x011e03d3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f808301),
         UINT32_C(0x3f801200),
         UINT32_C(0x3f809101),
         UINT32_C(0x3f803800),
         UINT32_C(0x3f80bb01),
         UINT32_C(0x3f802a00),
         UINT32_C(0x3f80a901),
         UINT32_C(0x3f802600),
         UINT32_C(0x3f80a501),
         UINT32_C(0x3f803400),
         UINT32_C(0x3f80b701),
         UINT32_C(0x3f801e00),
         UINT32_C(0x3f809d01),
         UINT32_C(0x3f800c00),
         UINT32_C(0x3f808f01)},
        UINT32_C(0xfff80000),
        {0x75,0x55,0x0b,0x56,0x9a,0x7d,0xe4,0xa5,0x47,0x15,
         0x33,0xb5,0x32,0x55,0x1d,0xbd,0x42,0x5c,0x06,0xb4,0x00}
    },
    {
        /* No.24 delta:765 weight:721 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa44b9eb8),
         UINT32_C(0xb66d2770),
         UINT32_C(0x1226b9c8),
         UINT32_C(0xa7400180),
         UINT32_C(0x030b9f38),
         UINT32_C(0x112d26f0),
         UINT32_C(0xb566b848),
         UINT32_C(0x000093e2),
         UINT32_C(0xa44b0d5a),
         UINT32_C(0xb66db492),
         UINT32_C(0x12262a2a),
         UINT32_C(0xa7409262),
         UINT32_C(0x030b0cda),
         UINT32_C(0x112db512),
         UINT32_C(0xb5662baa)},
        {UINT32_C(0x00000000),
         UINT32_C(0x206c4d57),
         UINT32_C(0x40044405),
         UINT32_C(0x60680952),
         UINT32_C(0x7042401b),
         UINT32_C(0x502e0d4c),
         UINT32_C(0x3046041e),
         UINT32_C(0x102a4949),
         UINT32_C(0x70200204),
         UINT32_C(0x504c4f53),
         UINT32_C(0x30244601),
         UINT32_C(0x10480b56),
         UINT32_C(0x0062421f),
         UINT32_C(0x200e0f48),
         UINT32_C(0x4066061a),
         UINT32_C(0x600a4b4d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f903626),
         UINT32_C(0x3fa00222),
         UINT32_C(0x3fb03404),
         UINT32_C(0x3fb82120),
         UINT32_C(0x3fa81706),
         UINT32_C(0x3f982302),
         UINT32_C(0x3f881524),
         UINT32_C(0x3fb81001),
         UINT32_C(0x3fa82627),
         UINT32_C(0x3f981223),
         UINT32_C(0x3f882405),
         UINT32_C(0x3f803121),
         UINT32_C(0x3f900707),
         UINT32_C(0x3fa03303),
         UINT32_C(0x3fb00525)},
        UINT32_C(0xfff80000),
        {0x7f,0xad,0x7b,0xd7,0x2d,0x36,0xd7,0x2e,0xea,0xde,
         0x5a,0x26,0xe0,0x66,0x33,0x76,0x48,0x3d,0x70,0x76,0x00}
    },
    {
        /* No.25 delta:1491 weight:1691 */
        11213,
        16,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa197c538),
         UINT32_C(0x2189e50a),
         UINT32_C(0x801e2032),
         UINT32_C(0xbe900193),
         UINT32_C(0x1f07c4ab),
         UINT32_C(0x9f19e499),
         UINT32_C(0x3e8e21a1),
         UINT32_C(0x000019a2),
         UINT32_C(0xa197dc9a),
         UINT32_C(0x2189fca8),
         UINT32_C(0x801e3990),
         UINT32_C(0xbe901831),
         UINT32_C(0x1f07dd09),
         UINT32_C(0x9f19fd3b),
         UINT32_C(0x3e8e3803)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0cb682dc),
         UINT32_C(0x21840a6e),
         UINT32_C(0x2d3288b2),
         UINT32_C(0x0050d01d),
         UINT32_C(0x0ce652c1),
         UINT32_C(0x21d4da73),
         UINT32_C(0x2d6258af),
         UINT32_C(0x00201614),
         UINT32_C(0x0c9694c8),
         UINT32_C(0x21a41c7a),
         UINT32_C(0x2d129ea6),
         UINT32_C(0x0070c609),
         UINT32_C(0x0cc644d5),
         UINT32_C(0x21f4cc67),
         UINT32_C(0x2d424ebb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f865b41),
         UINT32_C(0x3f90c205),
         UINT32_C(0x3f969944),
         UINT32_C(0x3f802868),
         UINT32_C(0x3f867329),
         UINT32_C(0x3f90ea6d),
         UINT32_C(0x3f96b12c),
         UINT32_C(0x3f80100b),
         UINT32_C(0x3f864b4a),
         UINT32_C(0x3f90d20e),
         UINT32_C(0x3f96894f),
         UINT32_C(0x3f803863),
         UINT32_C(0x3f866322),
         UINT32_C(0x3f90fa66),
         UINT32_C(0x3f96a127)},
        UINT32_C(0xfff80000),
        {0x23,0x39,0x98,0xe2,0x20,0xce,0x7e,0x4a,0xf3,0x5f,
         0x8a,0xa2,0x7c,0xaf,0x4c,0x20,0x4b,0x3c,0x2a,0x3e,0x00}
    },
    {
        /* No.26 delta:1271 weight:1733 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd060775e),
         UINT32_C(0xa2b1b9c5),
         UINT32_C(0x72d1ce9b),
         UINT32_C(0x97f001a8),
         UINT32_C(0x479076f6),
         UINT32_C(0x3541b86d),
         UINT32_C(0xe521cf33),
         UINT32_C(0x0000a701),
         UINT32_C(0xd060d05f),
         UINT32_C(0xa2b11ec4),
         UINT32_C(0x72d1699a),
         UINT32_C(0x97f0a6a9),
         UINT32_C(0x4790d1f7),
         UINT32_C(0x35411f6c),
         UINT32_C(0xe5216832)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1c6bc8f4),
         UINT32_C(0x006c38db),
         UINT32_C(0x1c07f02f),
         UINT32_C(0x00501012),
         UINT32_C(0x1c3bd8e6),
         UINT32_C(0x003c28c9),
         UINT32_C(0x1c57e03d),
         UINT32_C(0x000f2417),
         UINT32_C(0x1c64ece3),
         UINT32_C(0x00631ccc),
         UINT32_C(0x1c08d438),
         UINT32_C(0x005f3405),
         UINT32_C(0x1c34fcf1),
         UINT32_C(0x00330cde),
         UINT32_C(0x1c58c42a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8e35e4),
         UINT32_C(0x3f80361c),
         UINT32_C(0x3f8e03f8),
         UINT32_C(0x3f802808),
         UINT32_C(0x3f8e1dec),
         UINT32_C(0x3f801e14),
         UINT32_C(0x3f8e2bf0),
         UINT32_C(0x3f800792),
         UINT32_C(0x3f8e3276),
         UINT32_C(0x3f80318e),
         UINT32_C(0x3f8e046a),
         UINT32_C(0x3f802f9a),
         UINT32_C(0x3f8e1a7e),
         UINT32_C(0x3f801986),
         UINT32_C(0x3f8e2c62)},
        UINT32_C(0xfff80000),
        {0x2b,0x91,0x85,0xa8,0xca,0xa6,0x3a,0xf1,0x2d,0xea,
         0x12,0x7d,0x47,0xb4,0x80,0x80,0x0e,0x7b,0x4f,0x67,0x00}
    },
    {
        /* No.27 delta:1231 weight:1525 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7afaa5cb),
         UINT32_C(0xf61d93c3),
         UINT32_C(0x8ce73608),
         UINT32_C(0xca1001bc),
         UINT32_C(0xb0eaa477),
         UINT32_C(0x3c0d927f),
         UINT32_C(0x46f737b4),
         UINT32_C(0x0000830c),
         UINT32_C(0x7afa26c7),
         UINT32_C(0xf61d10cf),
         UINT32_C(0x8ce7b504),
         UINT32_C(0xca1082b0),
         UINT32_C(0xb0ea277b),
         UINT32_C(0x3c0d1173),
         UINT32_C(0x46f7b4b8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x09255812),
         UINT32_C(0x004cc81c),
         UINT32_C(0x0969900e),
         UINT32_C(0x10a0480d),
         UINT32_C(0x1985101f),
         UINT32_C(0x10ec8011),
         UINT32_C(0x19c9d803),
         UINT32_C(0x00209a18),
         UINT32_C(0x0905c20a),
         UINT32_C(0x006c5204),
         UINT32_C(0x09490a16),
         UINT32_C(0x1080d215),
         UINT32_C(0x19a58a07),
         UINT32_C(0x10cc1a09),
         UINT32_C(0x19e9421b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8492ac),
         UINT32_C(0x3f802664),
         UINT32_C(0x3f84b4c8),
         UINT32_C(0x3f885024),
         UINT32_C(0x3f8cc288),
         UINT32_C(0x3f887640),
         UINT32_C(0x3f8ce4ec),
         UINT32_C(0x3f80104d),
         UINT32_C(0x3f8482e1),
         UINT32_C(0x3f803629),
         UINT32_C(0x3f84a485),
         UINT32_C(0x3f884069),
         UINT32_C(0x3f8cd2c5),
         UINT32_C(0x3f88660d),
         UINT32_C(0x3f8cf4a1)},
        UINT32_C(0xfff80000),
        {0x3a,0x40,0x03,0x20,0xef,0x18,0x5a,0xe5,0x2a,0x38,
         0xb1,0xf0,0x41,0xf4,0x32,0x78,0xa2,0x41,0xdc,0x93,0x00}
    },
    {
        /* No.28 delta:1090 weight:1601 */
        11213,
        41,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x37b07ae5),
         UINT32_C(0x1e34ad30),
         UINT32_C(0x2984d7d5),
         UINT32_C(0xa54001cc),
         UINT32_C(0x92f07b29),
         UINT32_C(0xbb74acfc),
         UINT32_C(0x8cc4d619),
         UINT32_C(0x00009771),
         UINT32_C(0x37b0ed94),
         UINT32_C(0x1e343a41),
         UINT32_C(0x298440a4),
         UINT32_C(0xa54096bd),
         UINT32_C(0x92f0ec58),
         UINT32_C(0xbb743b8d),
         UINT32_C(0x8cc44168)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80503416),
         UINT32_C(0x007c0c1a),
         UINT32_C(0x802c380c),
         UINT32_C(0x0003646b),
         UINT32_C(0x8053507d),
         UINT32_C(0x007f6871),
         UINT32_C(0x802f5c67),
         UINT32_C(0x00002c05),
         UINT32_C(0x80501813),
         UINT32_C(0x007c201f),
         UINT32_C(0x802c1409),
         UINT32_C(0x0003486e),
         UINT32_C(0x80537c78),
         UINT32_C(0x007f4474),
         UINT32_C(0x802f7062)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc0281a),
         UINT32_C(0x3f803e06),
         UINT32_C(0x3fc0161c),
         UINT32_C(0x3f8001b2),
         UINT32_C(0x3fc029a8),
         UINT32_C(0x3f803fb4),
         UINT32_C(0x3fc017ae),
         UINT32_C(0x3f800016),
         UINT32_C(0x3fc0280c),
         UINT32_C(0x3f803e10),
         UINT32_C(0x3fc0160a),
         UINT32_C(0x3f8001a4),
         UINT32_C(0x3fc029be),
         UINT32_C(0x3f803fa2),
         UINT32_C(0x3fc017b8)},
        UINT32_C(0xfff80000),
        {0x2e,0x51,0xa2,0xb0,0x84,0xe2,0x9b,0x71,0x83,0xc5,
         0x6d,0xe2,0x0e,0xb2,0x3e,0xe3,0x35,0x5e,0x59,0x0b,0x00}
    },
    {
        /* No.29 delta:1026 weight:985 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x098de739),
         UINT32_C(0x1e064906),
         UINT32_C(0x178bae3f),
         UINT32_C(0x0fb001de),
         UINT32_C(0x063de6e7),
         UINT32_C(0x11b648d8),
         UINT32_C(0x183bafe1),
         UINT32_C(0x000062cb),
         UINT32_C(0x098d85f2),
         UINT32_C(0x1e062bcd),
         UINT32_C(0x178bccf4),
         UINT32_C(0x0fb06315),
         UINT32_C(0x063d842c),
         UINT32_C(0x11b62a13),
         UINT32_C(0x183bcd2a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x206d117f),
         UINT32_C(0x201209fe),
         UINT32_C(0x007f1881),
         UINT32_C(0x000180fc),
         UINT32_C(0x206c9183),
         UINT32_C(0x20138902),
         UINT32_C(0x007e987d),
         UINT32_C(0x2010c016),
         UINT32_C(0x007dd169),
         UINT32_C(0x0002c9e8),
         UINT32_C(0x206fd897),
         UINT32_C(0x201140ea),
         UINT32_C(0x007c5195),
         UINT32_C(0x00034914),
         UINT32_C(0x206e586b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f903688),
         UINT32_C(0x3f900904),
         UINT32_C(0x3f803f8c),
         UINT32_C(0x3f8000c0),
         UINT32_C(0x3f903648),
         UINT32_C(0x3f9009c4),
         UINT32_C(0x3f803f4c),
         UINT32_C(0x3f900860),
         UINT32_C(0x3f803ee8),
         UINT32_C(0x3f800164),
         UINT32_C(0x3f9037ec),
         UINT32_C(0x3f9008a0),
         UINT32_C(0x3f803e28),
         UINT32_C(0x3f8001a4),
         UINT32_C(0x3f90372c)},
        UINT32_C(0xfff80000),
        {0x06,0x77,0xd1,0x7e,0xdc,0xf3,0x70,0x1c,0x50,0xd7,
         0x02,0x4b,0x90,0x4c,0x30,0xef,0x1a,0xfc,0x80,0xf2,0x00}
    },
    {
        /* No.30 delta:1006 weight:1433 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe98943f8),
         UINT32_C(0x1d8008b8),
         UINT32_C(0xf4094b40),
         UINT32_C(0x897001e6),
         UINT32_C(0x60f9421e),
         UINT32_C(0x94f0095e),
         UINT32_C(0x7d794aa6),
         UINT32_C(0x00000d37),
         UINT32_C(0xe9894ecf),
         UINT32_C(0x1d80058f),
         UINT32_C(0xf4094677),
         UINT32_C(0x89700cd1),
         UINT32_C(0x60f94f29),
         UINT32_C(0x94f00469),
         UINT32_C(0x7d794791)},
        {UINT32_C(0x00000000),
         UINT32_C(0x60006e16),
         UINT32_C(0x802610db),
         UINT32_C(0xe0267ecd),
         UINT32_C(0x00035407),
         UINT32_C(0x60033a11),
         UINT32_C(0x802544dc),
         UINT32_C(0xe0252aca),
         UINT32_C(0x4068e812),
         UINT32_C(0x20688604),
         UINT32_C(0xc04ef8c9),
         UINT32_C(0xa04e96df),
         UINT32_C(0x406bbc15),
         UINT32_C(0x206bd203),
         UINT32_C(0xc04dacce),
         UINT32_C(0xa04dc2d8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb00037),
         UINT32_C(0x3fc01308),
         UINT32_C(0x3ff0133f),
         UINT32_C(0x3f8001aa),
         UINT32_C(0x3fb0019d),
         UINT32_C(0x3fc012a2),
         UINT32_C(0x3ff01295),
         UINT32_C(0x3fa03474),
         UINT32_C(0x3f903443),
         UINT32_C(0x3fe0277c),
         UINT32_C(0x3fd0274b),
         UINT32_C(0x3fa035de),
         UINT32_C(0x3f9035e9),
         UINT32_C(0x3fe026d6),
         UINT32_C(0x3fd026e1)},
        UINT32_C(0xfff80000),
        {0x6c,0x35,0x43,0x19,0x5c,0x54,0xcc,0x5d,0x7f,0x18,
         0xa9,0xf1,0xa9,0x02,0x57,0x08,0x33,0x68,0x15,0x6f,0x00}
    },
    {
        /* No.31 delta:2643 weight:851 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9a117ca4),
         UINT32_C(0x10aad759),
         UINT32_C(0x8abbabfd),
         UINT32_C(0x344001fe),
         UINT32_C(0xae517d5a),
         UINT32_C(0x24ead6a7),
         UINT32_C(0xbefbaa03),
         UINT32_C(0x00005300),
         UINT32_C(0x9a112fa4),
         UINT32_C(0x10aa8459),
         UINT32_C(0x8abbf8fd),
         UINT32_C(0x344052fe),
         UINT32_C(0xae512e5a),
         UINT32_C(0x24ea85a7),
         UINT32_C(0xbefbf903)},
        {UINT32_C(0x00000000),
         UINT32_C(0x13fd6396),
         UINT32_C(0xc008012f),
         UINT32_C(0xd3f562b9),
         UINT32_C(0x2c0a0612),
         UINT32_C(0x3ff76584),
         UINT32_C(0xec02073d),
         UINT32_C(0xffff64ab),
         UINT32_C(0x0e50429c),
         UINT32_C(0x1dad210a),
         UINT32_C(0xce5843b3),
         UINT32_C(0xdda52025),
         UINT32_C(0x225a448e),
         UINT32_C(0x31a72718),
         UINT32_C(0xe25245a1),
         UINT32_C(0xf1af2637)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f89feb1),
         UINT32_C(0x3fe00400),
         UINT32_C(0x3fe9fab1),
         UINT32_C(0x3f960503),
         UINT32_C(0x3f9ffbb2),
         UINT32_C(0x3ff60103),
         UINT32_C(0x3fffffb2),
         UINT32_C(0x3f872821),
         UINT32_C(0x3f8ed690),
         UINT32_C(0x3fe72c21),
         UINT32_C(0x3feed290),
         UINT32_C(0x3f912d22),
         UINT32_C(0x3f98d393),
         UINT32_C(0x3ff12922),
         UINT32_C(0x3ff8d793)},
        UINT32_C(0xfff80000),
        {0xbe,0xdb,0xc1,0x19,0xc3,0x76,0x96,0x70,0x64,0x79,
         0xf9,0x78,0x33,0x36,0x98,0xc5,0x84,0x29,0x62,0x9b,0x00}
    },
    {
        /* No.32 delta:931 weight:1201 */
        11213,
        39,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5c03fe6b),
         UINT32_C(0xf980c4cd),
         UINT32_C(0xa5833aa6),
         UINT32_C(0xd1800200),
         UINT32_C(0x8d83fc6b),
         UINT32_C(0x2800c6cd),
         UINT32_C(0x740338a6),
         UINT32_C(0x00005e80),
         UINT32_C(0x5c03a0eb),
         UINT32_C(0xf9809a4d),
         UINT32_C(0xa5836426),
         UINT32_C(0xd1805c80),
         UINT32_C(0x8d83a2eb),
         UINT32_C(0x2800984d),
         UINT32_C(0x74036626)},
        {UINT32_C(0x00000000),
         UINT32_C(0x440311b6),
         UINT32_C(0x50014125),
         UINT32_C(0x14025093),
         UINT32_C(0x30806002),
         UINT32_C(0x748371b4),
         UINT32_C(0x60812127),
         UINT32_C(0x24823091),
         UINT32_C(0x2001518f),
         UINT32_C(0x64024039),
         UINT32_C(0x700010aa),
         UINT32_C(0x3403011c),
         UINT32_C(0x1081318d),
         UINT32_C(0x5482203b),
         UINT32_C(0x408070a8),
         UINT32_C(0x0483611e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa20188),
         UINT32_C(0x3fa800a0),
         UINT32_C(0x3f8a0128),
         UINT32_C(0x3f984030),
         UINT32_C(0x3fba41b8),
         UINT32_C(0x3fb04090),
         UINT32_C(0x3f924118),
         UINT32_C(0x3f9000a8),
         UINT32_C(0x3fb20120),
         UINT32_C(0x3fb80008),
         UINT32_C(0x3f9a0180),
         UINT32_C(0x3f884098),
         UINT32_C(0x3faa4110),
         UINT32_C(0x3fa04038),
         UINT32_C(0x3f8241b0)},
        UINT32_C(0xfff80000),
        {0x88,0x0a,0xba,0xc7,0x94,0x4a,0x94,0xdb,0x00,0x44,
         0xcd,0xb3,0xf7,0x4b,0x3f,0x58,0xf1,0xe2,0x5d,0xa8,0x00}
    },
    {
        /* No.33 delta:2638 weight:897 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4799d6f6),
         UINT32_C(0xa319c120),
         UINT32_C(0xe48017d6),
         UINT32_C(0x5ac00217),
         UINT32_C(0x1d59d4e1),
         UINT32_C(0xf9d9c337),
         UINT32_C(0xbe4015c1),
         UINT32_C(0x00004ab0),
         UINT32_C(0x47999c46),
         UINT32_C(0xa3198b90),
         UINT32_C(0xe4805d66),
         UINT32_C(0x5ac048a7),
         UINT32_C(0x1d599e51),
         UINT32_C(0xf9d98987),
         UINT32_C(0xbe405f71)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9080001d),
         UINT32_C(0xb90703ee),
         UINT32_C(0x298703f3),
         UINT32_C(0x4820e8c7),
         UINT32_C(0xd8a0e8da),
         UINT32_C(0xf127eb29),
         UINT32_C(0x61a7eb34),
         UINT32_C(0x82f810ab),
         UINT32_C(0x127810b6),
         UINT32_C(0x3bff1345),
         UINT32_C(0xab7f1358),
         UINT32_C(0xcad8f86c),
         UINT32_C(0x5a58f871),
         UINT32_C(0x73dffb82),
         UINT32_C(0xe35ffb9f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc84000),
         UINT32_C(0x3fdc8381),
         UINT32_C(0x3f94c381),
         UINT32_C(0x3fa41074),
         UINT32_C(0x3fec5074),
         UINT32_C(0x3ff893f5),
         UINT32_C(0x3fb0d3f5),
         UINT32_C(0x3fc17c08),
         UINT32_C(0x3f893c08),
         UINT32_C(0x3f9dff89),
         UINT32_C(0x3fd5bf89),
         UINT32_C(0x3fe56c7c),
         UINT32_C(0x3fad2c7c),
         UINT32_C(0x3fb9effd),
         UINT32_C(0x3ff1affd)},
        UINT32_C(0xfff80000),
        {0xa1,0xd1,0x5b,0x36,0xed,0x69,0x7c,0xd5,0x59,0x6f,
         0x3d,0xb6,0xeb,0xc7,0x5a,0xa6,0x25,0xb1,0xde,0x82,0x00}
    },
    {
        /* No.34 delta:2636 weight:929 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3c08004a),
         UINT32_C(0x7d62e150),
         UINT32_C(0x416ae11a),
         UINT32_C(0xa1c00225),
         UINT32_C(0x9dc8026f),
         UINT32_C(0xdca2e375),
         UINT32_C(0xe0aae33f),
         UINT32_C(0x000090a6),
         UINT32_C(0x3c0890ec),
         UINT32_C(0x7d6271f6),
         UINT32_C(0x416a71bc),
         UINT32_C(0xa1c09283),
         UINT32_C(0x9dc892c9),
         UINT32_C(0xdca273d3),
         UINT32_C(0xe0aa7399)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa470699a),
         UINT32_C(0x1202409c),
         UINT32_C(0xb6722906),
         UINT32_C(0xe1d34561),
         UINT32_C(0x45a32cfb),
         UINT32_C(0xf3d105fd),
         UINT32_C(0x57a16c67),
         UINT32_C(0x5f304155),
         UINT32_C(0xfb4028cf),
         UINT32_C(0x4d3201c9),
         UINT32_C(0xe9426853),
         UINT32_C(0xbee30434),
         UINT32_C(0x1a936dae),
         UINT32_C(0xace144a8),
         UINT32_C(0x08912d32)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd23834),
         UINT32_C(0x3f890120),
         UINT32_C(0x3fdb3914),
         UINT32_C(0x3ff0e9a2),
         UINT32_C(0x3fa2d196),
         UINT32_C(0x3ff9e882),
         UINT32_C(0x3fabd0b6),
         UINT32_C(0x3faf9820),
         UINT32_C(0x3ffda014),
         UINT32_C(0x3fa69900),
         UINT32_C(0x3ff4a134),
         UINT32_C(0x3fdf7182),
         UINT32_C(0x3f8d49b6),
         UINT32_C(0x3fd670a2),
         UINT32_C(0x3f844896)},
        UINT32_C(0xfff80000),
        {0x19,0x24,0xa9,0x32,0x47,0xfb,0xc5,0x02,0xd0,0x5a,
         0xd6,0x29,0xb7,0x28,0xc1,0x1d,0x3f,0x73,0x88,0xe1,0x00}
    },
    {
        /* No.35 delta:1232 weight:1687 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3edd78fb),
         UINT32_C(0x2bc6abe4),
         UINT32_C(0x151bd31f),
         UINT32_C(0x3f400231),
         UINT32_C(0x019d7aca),
         UINT32_C(0x1486a9d5),
         UINT32_C(0x2a5bd12e),
         UINT32_C(0x00002ae9),
         UINT32_C(0x3edd5212),
         UINT32_C(0x2bc6810d),
         UINT32_C(0x151bf9f6),
         UINT32_C(0x3f4028d8),
         UINT32_C(0x019d5023),
         UINT32_C(0x1486833c),
         UINT32_C(0x2a5bfbc7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0824a87e),
         UINT32_C(0x4048c809),
         UINT32_C(0x486c6077),
         UINT32_C(0x5039801d),
         UINT32_C(0x581d2863),
         UINT32_C(0x10714814),
         UINT32_C(0x1855e06a),
         UINT32_C(0x000e7145),
         UINT32_C(0x082ad93b),
         UINT32_C(0x4046b94c),
         UINT32_C(0x48621132),
         UINT32_C(0x5037f158),
         UINT32_C(0x58135926),
         UINT32_C(0x107f3951),
         UINT32_C(0x185b912f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841254),
         UINT32_C(0x3fa02464),
         UINT32_C(0x3fa43630),
         UINT32_C(0x3fa81cc0),
         UINT32_C(0x3fac0e94),
         UINT32_C(0x3f8838a4),
         UINT32_C(0x3f8c2af0),
         UINT32_C(0x3f800738),
         UINT32_C(0x3f84156c),
         UINT32_C(0x3fa0235c),
         UINT32_C(0x3fa43108),
         UINT32_C(0x3fa81bf8),
         UINT32_C(0x3fac09ac),
         UINT32_C(0x3f883f9c),
         UINT32_C(0x3f8c2dc8)},
        UINT32_C(0xfff80000),
        {0xa9,0x98,0x5d,0xcc,0x59,0xa5,0x1a,0x00,0xc7,0x87,
         0x68,0x82,0xf4,0x04,0x8b,0xc3,0xa3,0x0c,0x1e,0x53,0x00}
    },
    {
        /* No.36 delta:786 weight:1663 */
        11213,
        49,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x94ee5ba3),
         UINT32_C(0x071342e5),
         UINT32_C(0x93fd1946),
         UINT32_C(0x7cd00242),
         UINT32_C(0xe83e59e1),
         UINT32_C(0x7bc340a7),
         UINT32_C(0xef2d1b04),
         UINT32_C(0x0000e533),
         UINT32_C(0x94eebe90),
         UINT32_C(0x0713a7d6),
         UINT32_C(0x93fdfc75),
         UINT32_C(0x7cd0e771),
         UINT32_C(0xe83ebcd2),
         UINT32_C(0x7bc3a594),
         UINT32_C(0xef2dfe37)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1001c81e),
         UINT32_C(0x8005654f),
         UINT32_C(0x9004ad51),
         UINT32_C(0x00023019),
         UINT32_C(0x1003f807),
         UINT32_C(0x80075556),
         UINT32_C(0x90069d48),
         UINT32_C(0x40008195),
         UINT32_C(0x5001498b),
         UINT32_C(0xc005e4da),
         UINT32_C(0xd0042cc4),
         UINT32_C(0x4002b18c),
         UINT32_C(0x50037992),
         UINT32_C(0xc007d4c3),
         UINT32_C(0xd0061cdd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8800e4),
         UINT32_C(0x3fc002b2),
         UINT32_C(0x3fc80256),
         UINT32_C(0x3f800118),
         UINT32_C(0x3f8801fc),
         UINT32_C(0x3fc003aa),
         UINT32_C(0x3fc8034e),
         UINT32_C(0x3fa00040),
         UINT32_C(0x3fa800a4),
         UINT32_C(0x3fe002f2),
         UINT32_C(0x3fe80216),
         UINT32_C(0x3fa00158),
         UINT32_C(0x3fa801bc),
         UINT32_C(0x3fe003ea),
         UINT32_C(0x3fe8030e)},
        UINT32_C(0xfff80000),
        {0xbc,0xac,0x40,0xe1,0xa4,0xcf,0x68,0x57,0x92,0x5d,
         0xc9,0xb3,0x6f,0xd5,0x5b,0x1b,0xac,0x54,0xa1,0x77,0x00}
    },
    {
        /* No.37 delta:2265 weight:1225 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xcd0f688b),
         UINT32_C(0xf8f41039),
         UINT32_C(0x35fb78b2),
         UINT32_C(0x5f400250),
         UINT32_C(0x924f6adb),
         UINT32_C(0xa7b41269),
         UINT32_C(0x6abb7ae2),
         UINT32_C(0x0000f07f),
         UINT32_C(0xcd0f98f4),
         UINT32_C(0xf8f4e046),
         UINT32_C(0x35fb88cd),
         UINT32_C(0x5f40f22f),
         UINT32_C(0x924f9aa4),
         UINT32_C(0xa7b4e216),
         UINT32_C(0x6abb8a9d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x09832156),
         UINT32_C(0x0c00c8d3),
         UINT32_C(0x0583e985),
         UINT32_C(0x0e88499a),
         UINT32_C(0x070b68cc),
         UINT32_C(0x02888149),
         UINT32_C(0x0b0ba01f),
         UINT32_C(0x1680886e),
         UINT32_C(0x1f03a938),
         UINT32_C(0x1a8040bd),
         UINT32_C(0x130361eb),
         UINT32_C(0x1808c1f4),
         UINT32_C(0x118be0a2),
         UINT32_C(0x14080927),
         UINT32_C(0x1d8b2871)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84c190),
         UINT32_C(0x3f860064),
         UINT32_C(0x3f82c1f4),
         UINT32_C(0x3f874424),
         UINT32_C(0x3f8385b4),
         UINT32_C(0x3f814440),
         UINT32_C(0x3f8585d0),
         UINT32_C(0x3f8b4044),
         UINT32_C(0x3f8f81d4),
         UINT32_C(0x3f8d4020),
         UINT32_C(0x3f8981b0),
         UINT32_C(0x3f8c0460),
         UINT32_C(0x3f88c5f0),
         UINT32_C(0x3f8a0404),
         UINT32_C(0x3f8ec594)},
        UINT32_C(0xfff80000),
        {0x61,0xcc,0x16,0xa5,0xdd,0xbe,0xe2,0x88,0x85,0x5d,
         0x84,0x1d,0xae,0x86,0x9e,0x5a,0x80,0xf1,0x6b,0x64,0x00}
    },
    {
        /* No.38 delta:2677 weight:905 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x42e3bb47),
         UINT32_C(0x9e764ebc),
         UINT32_C(0xdc95f5fb),
         UINT32_C(0x4de0026f),
         UINT32_C(0x0f03b928),
         UINT32_C(0xd3964cd3),
         UINT32_C(0x9175f794),
         UINT32_C(0x00006bb7),
         UINT32_C(0x42e3d0f0),
         UINT32_C(0x9e76250b),
         UINT32_C(0xdc959e4c),
         UINT32_C(0x4de069d8),
         UINT32_C(0x0f03d29f),
         UINT32_C(0xd3962764),
         UINT32_C(0x91759c23)},
        {UINT32_C(0x00000000),
         UINT32_C(0x224f1092),
         UINT32_C(0xa0508803),
         UINT32_C(0x821f9891),
         UINT32_C(0xa028403a),
         UINT32_C(0x826750a8),
         UINT32_C(0x0078c839),
         UINT32_C(0x2237d8ab),
         UINT32_C(0x4220e01e),
         UINT32_C(0x606ff08c),
         UINT32_C(0xe270681d),
         UINT32_C(0xc03f788f),
         UINT32_C(0xe208a024),
         UINT32_C(0xc047b0b6),
         UINT32_C(0x42582827),
         UINT32_C(0x601738b5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f912788),
         UINT32_C(0x3fd02844),
         UINT32_C(0x3fc10fcc),
         UINT32_C(0x3fd01420),
         UINT32_C(0x3fc133a8),
         UINT32_C(0x3f803c64),
         UINT32_C(0x3f911bec),
         UINT32_C(0x3fa11070),
         UINT32_C(0x3fb037f8),
         UINT32_C(0x3ff13834),
         UINT32_C(0x3fe01fbc),
         UINT32_C(0x3ff10450),
         UINT32_C(0x3fe023d8),
         UINT32_C(0x3fa12c14),
         UINT32_C(0x3fb00b9c)},
        UINT32_C(0xfff80000),
        {0x84,0x26,0x0e,0x3e,0x1b,0xc1,0xf1,0x19,0xe5,0x93,
         0xf4,0x85,0x7e,0x2f,0x17,0x2e,0x58,0xd9,0x6f,0x9a,0x00}
    },
    {
        /* No.39 delta:786 weight:667 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x676d51d0),
         UINT32_C(0xf68c5350),
         UINT32_C(0x91e10280),
         UINT32_C(0x0650027f),
         UINT32_C(0x613d53af),
         UINT32_C(0xf0dc512f),
         UINT32_C(0x97b100ff),
         UINT32_C(0x000019cd),
         UINT32_C(0x676d481d),
         UINT32_C(0xf68c4a9d),
         UINT32_C(0x91e11b4d),
         UINT32_C(0x06501bb2),
         UINT32_C(0x613d4a62),
         UINT32_C(0xf0dc48e2),
         UINT32_C(0x97b11932)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5167c43f),
         UINT32_C(0x000671a9),
         UINT32_C(0x5161b596),
         UINT32_C(0x004105ed),
         UINT32_C(0x5126c1d2),
         UINT32_C(0x00477444),
         UINT32_C(0x5120b07b),
         UINT32_C(0x43820068),
         UINT32_C(0x12e5c457),
         UINT32_C(0x438471c1),
         UINT32_C(0x12e3b5fe),
         UINT32_C(0x43c30585),
         UINT32_C(0x12a4c1ba),
         UINT32_C(0x43c5742c),
         UINT32_C(0x12a2b013)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa8b3e2),
         UINT32_C(0x3f800338),
         UINT32_C(0x3fa8b0da),
         UINT32_C(0x3f802082),
         UINT32_C(0x3fa89360),
         UINT32_C(0x3f8023ba),
         UINT32_C(0x3fa89058),
         UINT32_C(0x3fa1c100),
         UINT32_C(0x3f8972e2),
         UINT32_C(0x3fa1c238),
         UINT32_C(0x3f8971da),
         UINT32_C(0x3fa1e182),
         UINT32_C(0x3f895260),
         UINT32_C(0x3fa1e2ba),
         UINT32_C(0x3f895158)},
        UINT32_C(0xfff80000),
        {0xe3,0xa3,0x8f,0xb6,0xe8,0xba,0x04,0x11,0xbf,0x43,
         0xc9,0x1f,0x8d,0x61,0xe8,0x61,0xb3,0x99,0xfe,0xaf,0x00}
    },
    {
        /* No.40 delta:745 weight:1705 */
        11213,
        56,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6f7fb8fe),
         UINT32_C(0x4386db54),
         UINT32_C(0x2cf963aa),
         UINT32_C(0xef600289),
         UINT32_C(0x801fba77),
         UINT32_C(0xace6d9dd),
         UINT32_C(0xc3996123),
         UINT32_C(0x0000b944),
         UINT32_C(0x6f7f01ba),
         UINT32_C(0x43866210),
         UINT32_C(0x2cf9daee),
         UINT32_C(0xef60bbcd),
         UINT32_C(0x801f0333),
         UINT32_C(0xace66099),
         UINT32_C(0xc399d867)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1000e41e),
         UINT32_C(0x3021c209),
         UINT32_C(0x20212617),
         UINT32_C(0x50001606),
         UINT32_C(0x4000f218),
         UINT32_C(0x6021d40f),
         UINT32_C(0x70213011),
         UINT32_C(0x30000113),
         UINT32_C(0x2000e50d),
         UINT32_C(0x0021c31a),
         UINT32_C(0x10212704),
         UINT32_C(0x60001715),
         UINT32_C(0x7000f30b),
         UINT32_C(0x5021d51c),
         UINT32_C(0x40213102)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880072),
         UINT32_C(0x3f9810e1),
         UINT32_C(0x3f901093),
         UINT32_C(0x3fa8000b),
         UINT32_C(0x3fa00079),
         UINT32_C(0x3fb010ea),
         UINT32_C(0x3fb81098),
         UINT32_C(0x3f980000),
         UINT32_C(0x3f900072),
         UINT32_C(0x3f8010e1),
         UINT32_C(0x3f881093),
         UINT32_C(0x3fb0000b),
         UINT32_C(0x3fb80079),
         UINT32_C(0x3fa810ea),
         UINT32_C(0x3fa01098)},
        UINT32_C(0xfff80000),
        {0xc0,0x16,0xdd,0x23,0x9e,0xdf,0x73,0x5b,0x4c,0xc1,
         0x3b,0xb8,0x4e,0xf9,0x1a,0x07,0xc5,0x25,0x31,0x02,0x00}
    },
    {
        /* No.41 delta:1262 weight:1689 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9f1bdb6d),
         UINT32_C(0x8180e703),
         UINT32_C(0x1e9b3c6e),
         UINT32_C(0x1ac00292),
         UINT32_C(0x85dbd9ff),
         UINT32_C(0x9b40e591),
         UINT32_C(0x045b3efc),
         UINT32_C(0x00007a0d),
         UINT32_C(0x9f1ba160),
         UINT32_C(0x81809d0e),
         UINT32_C(0x1e9b4663),
         UINT32_C(0x1ac0789f),
         UINT32_C(0x85dba3f2),
         UINT32_C(0x9b409f9c),
         UINT32_C(0x045b44f1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007e003a),
         UINT32_C(0x00628151),
         UINT32_C(0x001c816b),
         UINT32_C(0x38a801e5),
         UINT32_C(0x38d601df),
         UINT32_C(0x38ca80b4),
         UINT32_C(0x38b4808e),
         UINT32_C(0x0002a118),
         UINT32_C(0x007ca122),
         UINT32_C(0x00602049),
         UINT32_C(0x001e2073),
         UINT32_C(0x38aaa0fd),
         UINT32_C(0x38d4a0c7),
         UINT32_C(0x38c821ac),
         UINT32_C(0x38b62196)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f803140),
         UINT32_C(0x3f800e40),
         UINT32_C(0x3f9c5400),
         UINT32_C(0x3f9c6b00),
         UINT32_C(0x3f9c6540),
         UINT32_C(0x3f9c5a40),
         UINT32_C(0x3f800150),
         UINT32_C(0x3f803e50),
         UINT32_C(0x3f803010),
         UINT32_C(0x3f800f10),
         UINT32_C(0x3f9c5550),
         UINT32_C(0x3f9c6a50),
         UINT32_C(0x3f9c6410),
         UINT32_C(0x3f9c5b10)},
        UINT32_C(0xfff80000),
        {0xe6,0x9b,0xca,0x13,0x53,0x35,0xe1,0xcd,0x81,0x66,
         0x78,0xbe,0xc1,0x5c,0x46,0x67,0xa5,0xbe,0xf3,0x4c,0x00}
    },
    {
        /* No.42 delta:2137 weight:1311 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x610b70db),
         UINT32_C(0x55576aea),
         UINT32_C(0x345c1a31),
         UINT32_C(0xf8a002aa),
         UINT32_C(0x99ab7271),
         UINT32_C(0xadf76840),
         UINT32_C(0xccfc189b),
         UINT32_C(0x0000dbb3),
         UINT32_C(0x610bab68),
         UINT32_C(0x5557b159),
         UINT32_C(0x345cc182),
         UINT32_C(0xf8a0d919),
         UINT32_C(0x99aba9c2),
         UINT32_C(0xadf7b3f3),
         UINT32_C(0xccfcc328)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2c80f07a),
         UINT32_C(0x0d71214d),
         UINT32_C(0x21f1d137),
         UINT32_C(0x67010013),
         UINT32_C(0x4b81f069),
         UINT32_C(0x6a70215e),
         UINT32_C(0x46f0d124),
         UINT32_C(0x03c0e921),
         UINT32_C(0x2f40195b),
         UINT32_C(0x0eb1c86c),
         UINT32_C(0x22313816),
         UINT32_C(0x64c1e932),
         UINT32_C(0x48411948),
         UINT32_C(0x69b0c87f),
         UINT32_C(0x45303805)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f964078),
         UINT32_C(0x3f86b890),
         UINT32_C(0x3f90f8e8),
         UINT32_C(0x3fb38080),
         UINT32_C(0x3fa5c0f8),
         UINT32_C(0x3fb53810),
         UINT32_C(0x3fa37868),
         UINT32_C(0x3f81e074),
         UINT32_C(0x3f97a00c),
         UINT32_C(0x3f8758e4),
         UINT32_C(0x3f91189c),
         UINT32_C(0x3fb260f4),
         UINT32_C(0x3fa4208c),
         UINT32_C(0x3fb4d864),
         UINT32_C(0x3fa2981c)},
        UINT32_C(0xfff80000),
        {0xce,0x58,0x3a,0xdd,0xda,0x30,0x1a,0x13,0xf0,0x74,
         0xa1,0xfc,0x0d,0x09,0x89,0xba,0x95,0x5b,0xbc,0x05,0x00}
    },
    {
        /* No.43 delta:3542 weight:1399 */
        11213,
        79,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x903af7e2),
         UINT32_C(0xbc53f76e),
         UINT32_C(0x2c69008c),
         UINT32_C(0x47d002b6),
         UINT32_C(0xd7eaf554),
         UINT32_C(0xfb83f5d8),
         UINT32_C(0x6bb9023a),
         UINT32_C(0x00002113),
         UINT32_C(0x903ad6f1),
         UINT32_C(0xbc53d67d),
         UINT32_C(0x2c69219f),
         UINT32_C(0x47d023a5),
         UINT32_C(0xd7ead447),
         UINT32_C(0xfb83d4cb),
         UINT32_C(0x6bb92329)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0102809a),
         UINT32_C(0x000001b3),
         UINT32_C(0x01028129),
         UINT32_C(0x0000016d),
         UINT32_C(0x010281f7),
         UINT32_C(0x000000de),
         UINT32_C(0x01028044),
         UINT32_C(0x0000801d),
         UINT32_C(0x01020087),
         UINT32_C(0x000081ae),
         UINT32_C(0x01020134),
         UINT32_C(0x00008170),
         UINT32_C(0x010201ea),
         UINT32_C(0x000080c3),
         UINT32_C(0x01020059)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f808140),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f808140),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f808140),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f808140),
         UINT32_C(0x3f800040),
         UINT32_C(0x3f808100),
         UINT32_C(0x3f800040),
         UINT32_C(0x3f808100),
         UINT32_C(0x3f800040),
         UINT32_C(0x3f808100),
         UINT32_C(0x3f800040),
         UINT32_C(0x3f808100)},
        UINT32_C(0xfff80000),
        {0x7e,0x35,0x4c,0x0a,0x5d,0x28,0x1a,0xea,0x31,0xd8,
         0x9a,0xab,0xbe,0xfd,0xb4,0x88,0x86,0xdd,0xf1,0x63,0x00}
    },
    {
        /* No.44 delta:1029 weight:1639 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x067fc6ad),
         UINT32_C(0x97c590e7),
         UINT32_C(0x91ba564a),
         UINT32_C(0x9d0002c0),
         UINT32_C(0x9b7fc46d),
         UINT32_C(0x0ac59227),
         UINT32_C(0x0cba548a),
         UINT32_C(0x00002c42),
         UINT32_C(0x067feaef),
         UINT32_C(0x97c5bca5),
         UINT32_C(0x91ba7a08),
         UINT32_C(0x9d002e82),
         UINT32_C(0x9b7fe82f),
         UINT32_C(0x0ac5be65),
         UINT32_C(0x0cba78c8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1073e352),
         UINT32_C(0x000301a9),
         UINT32_C(0x1070e2fb),
         UINT32_C(0x403d181e),
         UINT32_C(0x504efb4c),
         UINT32_C(0x403e19b7),
         UINT32_C(0x504dfae5),
         UINT32_C(0x01042383),
         UINT32_C(0x1177c0d1),
         UINT32_C(0x0107222a),
         UINT32_C(0x1174c178),
         UINT32_C(0x41393b9d),
         UINT32_C(0x514ad8cf),
         UINT32_C(0x413a3a34),
         UINT32_C(0x5149d966)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8839f1),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f883871),
         UINT32_C(0x3fa01e8c),
         UINT32_C(0x3fa8277d),
         UINT32_C(0x3fa01f0c),
         UINT32_C(0x3fa826fd),
         UINT32_C(0x3f808211),
         UINT32_C(0x3f88bbe0),
         UINT32_C(0x3f808391),
         UINT32_C(0x3f88ba60),
         UINT32_C(0x3fa09c9d),
         UINT32_C(0x3fa8a56c),
         UINT32_C(0x3fa09d1d),
         UINT32_C(0x3fa8a4ec)},
        UINT32_C(0xfff80000),
        {0xf0,0x72,0x85,0x59,0x14,0x29,0xb0,0x54,0x97,0xb5,
         0x08,0x91,0x41,0x02,0x93,0xa3,0xd1,0x61,0xf7,0x56,0x00}
    },
    {
        /* No.45 delta:758 weight:1579 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x293a9a50),
         UINT32_C(0x911e56b5),
         UINT32_C(0xb824cce5),
         UINT32_C(0xed8002df),
         UINT32_C(0xc4ba988f),
         UINT32_C(0x7c9e546a),
         UINT32_C(0x55a4ce3a),
         UINT32_C(0x0000fe7c),
         UINT32_C(0x293a642c),
         UINT32_C(0x911ea8c9),
         UINT32_C(0xb8243299),
         UINT32_C(0xed80fca3),
         UINT32_C(0xc4ba66f3),
         UINT32_C(0x7c9eaa16),
         UINT32_C(0x55a43046)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2006607a),
         UINT32_C(0x00001259),
         UINT32_C(0x20067223),
         UINT32_C(0x10224205),
         UINT32_C(0x3024227f),
         UINT32_C(0x1022505c),
         UINT32_C(0x30243026),
         UINT32_C(0x1102f9ab),
         UINT32_C(0x310499d1),
         UINT32_C(0x1102ebf2),
         UINT32_C(0x31048b88),
         UINT32_C(0x0120bbae),
         UINT32_C(0x2126dbd4),
         UINT32_C(0x0120a9f7),
         UINT32_C(0x2126c98d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900330),
         UINT32_C(0x3f800009),
         UINT32_C(0x3f900339),
         UINT32_C(0x3f881121),
         UINT32_C(0x3f981211),
         UINT32_C(0x3f881128),
         UINT32_C(0x3f981218),
         UINT32_C(0x3f88817c),
         UINT32_C(0x3f98824c),
         UINT32_C(0x3f888175),
         UINT32_C(0x3f988245),
         UINT32_C(0x3f80905d),
         UINT32_C(0x3f90936d),
         UINT32_C(0x3f809054),
         UINT32_C(0x3f909364)},
        UINT32_C(0xfff80000),
        {0x45,0xa1,0x36,0xfd,0x29,0xae,0x9d,0x89,0x66,0xc1,
         0x52,0x23,0xab,0x49,0x91,0x54,0x97,0x2d,0xe8,0xab,0x00}
    },
    {
        /* No.46 delta:740 weight:1653 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc2bfb3ee),
         UINT32_C(0x1e17102e),
         UINT32_C(0xdca8a3c0),
         UINT32_C(0x56a002e6),
         UINT32_C(0x941fb108),
         UINT32_C(0x48b712c8),
         UINT32_C(0x8a08a126),
         UINT32_C(0x000030c2),
         UINT32_C(0xc2bf832c),
         UINT32_C(0x1e1720ec),
         UINT32_C(0xdca89302),
         UINT32_C(0x56a03224),
         UINT32_C(0x941f81ca),
         UINT32_C(0x48b7220a),
         UINT32_C(0x8a0891e4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10238477),
         UINT32_C(0x0000c015),
         UINT32_C(0x10234462),
         UINT32_C(0x026089fd),
         UINT32_C(0x12430d8a),
         UINT32_C(0x026049e8),
         UINT32_C(0x1243cd9f),
         UINT32_C(0xc044320b),
         UINT32_C(0xd067b67c),
         UINT32_C(0xc044f21e),
         UINT32_C(0xd0677669),
         UINT32_C(0xc224bbf6),
         UINT32_C(0xd2073f81),
         UINT32_C(0xc2247be3),
         UINT32_C(0xd207ff94)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8811c2),
         UINT32_C(0x3f800060),
         UINT32_C(0x3f8811a2),
         UINT32_C(0x3f813044),
         UINT32_C(0x3f892186),
         UINT32_C(0x3f813024),
         UINT32_C(0x3f8921e6),
         UINT32_C(0x3fe02219),
         UINT32_C(0x3fe833db),
         UINT32_C(0x3fe02279),
         UINT32_C(0x3fe833bb),
         UINT32_C(0x3fe1125d),
         UINT32_C(0x3fe9039f),
         UINT32_C(0x3fe1123d),
         UINT32_C(0x3fe903ff)},
        UINT32_C(0xfff80000),
        {0xbc,0x35,0xb5,0xf4,0x1c,0x83,0xb1,0x43,0x2f,0xbc,
         0x98,0xc0,0x2d,0x75,0x1c,0xf7,0xa7,0x58,0x91,0xef,0x00}
    },
    {
        /* No.47 delta:1023 weight:1339 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x103bbf40),
         UINT32_C(0x47cf4a25),
         UINT32_C(0x57f4f565),
         UINT32_C(0xa17002f9),
         UINT32_C(0xb14bbdb9),
         UINT32_C(0xe6bf48dc),
         UINT32_C(0xf684f79c),
         UINT32_C(0x000043a1),
         UINT32_C(0x103bfce1),
         UINT32_C(0x47cf0984),
         UINT32_C(0x57f4b6c4),
         UINT32_C(0xa1704158),
         UINT32_C(0xb14bfe18),
         UINT32_C(0xe6bf0b7d),
         UINT32_C(0xf684b43d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400061b6),
         UINT32_C(0x601e2a1a),
         UINT32_C(0x201e4bac),
         UINT32_C(0x40090073),
         UINT32_C(0x000961c5),
         UINT32_C(0x20172a69),
         UINT32_C(0x60174bdf),
         UINT32_C(0x10002118),
         UINT32_C(0x500040ae),
         UINT32_C(0x701e0b02),
         UINT32_C(0x301e6ab4),
         UINT32_C(0x5009216b),
         UINT32_C(0x100940dd),
         UINT32_C(0x30170b71),
         UINT32_C(0x70176ac7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00030),
         UINT32_C(0x3fb00f15),
         UINT32_C(0x3f900f25),
         UINT32_C(0x3fa00480),
         UINT32_C(0x3f8004b0),
         UINT32_C(0x3f900b95),
         UINT32_C(0x3fb00ba5),
         UINT32_C(0x3f880010),
         UINT32_C(0x3fa80020),
         UINT32_C(0x3fb80f05),
         UINT32_C(0x3f980f35),
         UINT32_C(0x3fa80490),
         UINT32_C(0x3f8804a0),
         UINT32_C(0x3f980b85),
         UINT32_C(0x3fb80bb5)},
        UINT32_C(0xfff80000),
        {0x35,0xfc,0x27,0xb0,0x9a,0x8d,0x46,0x03,0xc5,0x29,
         0xf2,0x0e,0x1d,0x9f,0xa6,0xc1,0xfb,0x8b,0x60,0x83,0x00}
    },
    {
        /* No.48 delta:914 weight:1427 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x881827c4),
         UINT32_C(0xf677e94d),
         UINT32_C(0x7e6fce89),
         UINT32_C(0x27900300),
         UINT32_C(0xaf8824c4),
         UINT32_C(0xd1e7ea4d),
         UINT32_C(0x59ffcd89),
         UINT32_C(0x0000042e),
         UINT32_C(0x881823ea),
         UINT32_C(0xf677ed63),
         UINT32_C(0x7e6fcaa7),
         UINT32_C(0x2790072e),
         UINT32_C(0xaf8820ea),
         UINT32_C(0xd1e7ee63),
         UINT32_C(0x59ffc9a7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2807115b),
         UINT32_C(0x208271f5),
         UINT32_C(0x088560ae),
         UINT32_C(0x00819c78),
         UINT32_C(0x28868d23),
         UINT32_C(0x2003ed8d),
         UINT32_C(0x0804fcd6),
         UINT32_C(0x0040c0cc),
         UINT32_C(0x2847d197),
         UINT32_C(0x20c2b139),
         UINT32_C(0x08c5a062),
         UINT32_C(0x00c15cb4),
         UINT32_C(0x28c64def),
         UINT32_C(0x20432d41),
         UINT32_C(0x08443c1a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f940388),
         UINT32_C(0x3f904138),
         UINT32_C(0x3f8442b0),
         UINT32_C(0x3f8040ce),
         UINT32_C(0x3f944346),
         UINT32_C(0x3f9001f6),
         UINT32_C(0x3f84027e),
         UINT32_C(0x3f802060),
         UINT32_C(0x3f9423e8),
         UINT32_C(0x3f906158),
         UINT32_C(0x3f8462d0),
         UINT32_C(0x3f8060ae),
         UINT32_C(0x3f946326),
         UINT32_C(0x3f902196),
         UINT32_C(0x3f84221e)},
        UINT32_C(0xfff80000),
        {0xb1,0xcb,0x4d,0x0a,0x50,0x26,0x0e,0x75,0xee,0xf1,
         0x61,0xbe,0x7a,0x0c,0xff,0xfa,0x59,0x3f,0xbb,0xbb,0x00}
    },
    {
        /* No.49 delta:1496 weight:1687 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x97d0a142),
         UINT32_C(0x5c5a83fc),
         UINT32_C(0xcb8a22be),
         UINT32_C(0x83f0031d),
         UINT32_C(0x1420a25f),
         UINT32_C(0xdfaa80e1),
         UINT32_C(0x487a21a3),
         UINT32_C(0x00005114),
         UINT32_C(0x97d0f056),
         UINT32_C(0x5c5ad2e8),
         UINT32_C(0xcb8a73aa),
         UINT32_C(0x83f05209),
         UINT32_C(0x1420f34b),
         UINT32_C(0xdfaad1f5),
         UINT32_C(0x487a70b7)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc94004fa),
         UINT32_C(0x202c881d),
         UINT32_C(0xe96c8ce7),
         UINT32_C(0x00712561),
         UINT32_C(0xc931219b),
         UINT32_C(0x205dad7c),
         UINT32_C(0xe91da986),
         UINT32_C(0x109e1016),
         UINT32_C(0xd9de14ec),
         UINT32_C(0x30b2980b),
         UINT32_C(0xf9f29cf1),
         UINT32_C(0x10ef3577),
         UINT32_C(0xd9af318d),
         UINT32_C(0x30c3bd6a),
         UINT32_C(0xf983b990)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe4a002),
         UINT32_C(0x3f901644),
         UINT32_C(0x3ff4b646),
         UINT32_C(0x3f803892),
         UINT32_C(0x3fe49890),
         UINT32_C(0x3f902ed6),
         UINT32_C(0x3ff48ed4),
         UINT32_C(0x3f884f08),
         UINT32_C(0x3fecef0a),
         UINT32_C(0x3f98594c),
         UINT32_C(0x3ffcf94e),
         UINT32_C(0x3f88779a),
         UINT32_C(0x3fecd798),
         UINT32_C(0x3f9861de),
         UINT32_C(0x3ffcc1dc)},
        UINT32_C(0xfff80000),
        {0xc7,0x1f,0xb6,0x33,0x7b,0xc0,0xe2,0x07,0x61,0x31,
         0xf3,0x6b,0xc4,0x02,0xee,0xb8,0xf5,0xde,0x86,0xfb,0x00}
    },
    {
        /* No.50 delta:1017 weight:1379 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8a72e209),
         UINT32_C(0x80064108),
         UINT32_C(0x0a74a301),
         UINT32_C(0x2a700329),
         UINT32_C(0xa002e120),
         UINT32_C(0xaa764221),
         UINT32_C(0x2004a028),
         UINT32_C(0x0000276e),
         UINT32_C(0x8a72c567),
         UINT32_C(0x80066666),
         UINT32_C(0x0a74846f),
         UINT32_C(0x2a702447),
         UINT32_C(0xa002c64e),
         UINT32_C(0xaa76654f),
         UINT32_C(0x20048746)},
        {UINT32_C(0x00000000),
         UINT32_C(0x60030972),
         UINT32_C(0x281ea939),
         UINT32_C(0x481da04b),
         UINT32_C(0x5000de16),
         UINT32_C(0x3003d764),
         UINT32_C(0x781e772f),
         UINT32_C(0x181d7e5d),
         UINT32_C(0x1000841e),
         UINT32_C(0x70038d6c),
         UINT32_C(0x381e2d27),
         UINT32_C(0x581d2455),
         UINT32_C(0x40005a08),
         UINT32_C(0x2003537a),
         UINT32_C(0x681ef331),
         UINT32_C(0x081dfa43)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb00184),
         UINT32_C(0x3f940f54),
         UINT32_C(0x3fa40ed0),
         UINT32_C(0x3fa8006f),
         UINT32_C(0x3f9801eb),
         UINT32_C(0x3fbc0f3b),
         UINT32_C(0x3f8c0ebf),
         UINT32_C(0x3f880042),
         UINT32_C(0x3fb801c6),
         UINT32_C(0x3f9c0f16),
         UINT32_C(0x3fac0e92),
         UINT32_C(0x3fa0002d),
         UINT32_C(0x3f9001a9),
         UINT32_C(0x3fb40f79),
         UINT32_C(0x3f840efd)},
        UINT32_C(0xfff80000),
        {0xcf,0xe0,0xdd,0xe5,0xc6,0xd8,0x52,0x00,0x6d,0xb3,
         0x72,0xaa,0xa6,0x9d,0xce,0x2e,0xa2,0x63,0x0b,0x0d,0x00}
    },
    {
        /* No.51 delta:2045 weight:1309 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7ba353c2),
         UINT32_C(0x72444e05),
         UINT32_C(0x09e71dc7),
         UINT32_C(0xe8e0033b),
         UINT32_C(0x934350f9),
         UINT32_C(0x9aa44d3e),
         UINT32_C(0xe1071efc),
         UINT32_C(0x0000fa95),
         UINT32_C(0x7ba3a957),
         UINT32_C(0x7244b490),
         UINT32_C(0x09e7e752),
         UINT32_C(0xe8e0f9ae),
         UINT32_C(0x9343aa6c),
         UINT32_C(0x9aa4b7ab),
         UINT32_C(0xe107e469)},
        {UINT32_C(0x00000000),
         UINT32_C(0x24188114),
         UINT32_C(0x2314009a),
         UINT32_C(0x070c818e),
         UINT32_C(0x9618202c),
         UINT32_C(0xb200a138),
         UINT32_C(0xb50c20b6),
         UINT32_C(0x9114a1a2),
         UINT32_C(0x0c2438e1),
         UINT32_C(0x283cb9f5),
         UINT32_C(0x2f30387b),
         UINT32_C(0x0b28b96f),
         UINT32_C(0x9a3c18cd),
         UINT32_C(0xbe2499d9),
         UINT32_C(0xb9281857),
         UINT32_C(0x9d309943)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f920c40),
         UINT32_C(0x3f918a00),
         UINT32_C(0x3f838640),
         UINT32_C(0x3fcb0c10),
         UINT32_C(0x3fd90050),
         UINT32_C(0x3fda8610),
         UINT32_C(0x3fc88a50),
         UINT32_C(0x3f86121c),
         UINT32_C(0x3f941e5c),
         UINT32_C(0x3f97981c),
         UINT32_C(0x3f85945c),
         UINT32_C(0x3fcd1e0c),
         UINT32_C(0x3fdf124c),
         UINT32_C(0x3fdc940c),
         UINT32_C(0x3fce984c)},
        UINT32_C(0xfff80000),
        {0x70,0xc6,0x77,0xbf,0xe4,0x1a,0x82,0x0a,0x8a,0x5b,
         0x2a,0x93,0x4f,0x09,0xb7,0x9f,0x7f,0x0f,0x33,0xc9,0x00}
    },
    {
        /* No.52 delta:839 weight:1583 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x674726ea),
         UINT32_C(0x27a13070),
         UINT32_C(0x40e6169a),
         UINT32_C(0x1bc0034a),
         UINT32_C(0x7c8725a0),
         UINT32_C(0x3c61333a),
         UINT32_C(0x5b2615d0),
         UINT32_C(0x00006a2b),
         UINT32_C(0x67474cc1),
         UINT32_C(0x27a15a5b),
         UINT32_C(0x40e67cb1),
         UINT32_C(0x1bc06961),
         UINT32_C(0x7c874f8b),
         UINT32_C(0x3c615911),
         UINT32_C(0x5b267ffb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x41028416),
         UINT32_C(0x4000140f),
         UINT32_C(0x01029019),
         UINT32_C(0x1000121b),
         UINT32_C(0x5102960d),
         UINT32_C(0x50000614),
         UINT32_C(0x11028202),
         UINT32_C(0x90401c03),
         UINT32_C(0xd1429815),
         UINT32_C(0xd040080c),
         UINT32_C(0x91428c1a),
         UINT32_C(0x80400e18),
         UINT32_C(0xc1428a0e),
         UINT32_C(0xc0401a17),
         UINT32_C(0x81429e01)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa08142),
         UINT32_C(0x3fa0000a),
         UINT32_C(0x3f808148),
         UINT32_C(0x3f880009),
         UINT32_C(0x3fa8814b),
         UINT32_C(0x3fa80003),
         UINT32_C(0x3f888141),
         UINT32_C(0x3fc8200e),
         UINT32_C(0x3fe8a14c),
         UINT32_C(0x3fe82004),
         UINT32_C(0x3fc8a146),
         UINT32_C(0x3fc02007),
         UINT32_C(0x3fe0a145),
         UINT32_C(0x3fe0200d),
         UINT32_C(0x3fc0a14f)},
        UINT32_C(0xfff80000),
        {0x14,0x30,0xd7,0x1b,0xa4,0xa0,0x00,0x4f,0x40,0x49,
         0xc4,0x4f,0x7f,0x8b,0x76,0x18,0xd7,0x6a,0xfd,0x81,0x00}
    },
    {
        /* No.53 delta:769 weight:1553 */
        11213,
        73,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd85e8608),
         UINT32_C(0xa7b19d3c),
         UINT32_C(0x7fef1b34),
         UINT32_C(0x81a00358),
         UINT32_C(0x59fe8550),
         UINT32_C(0x26119e64),
         UINT32_C(0xfe4f186c),
         UINT32_C(0x000048bb),
         UINT32_C(0xd85eceb3),
         UINT32_C(0xa7b1d587),
         UINT32_C(0x7fef538f),
         UINT32_C(0x81a04be3),
         UINT32_C(0x59fecdeb),
         UINT32_C(0x2611d6df),
         UINT32_C(0xfe4f50d7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x402c0417),
         UINT32_C(0x40019731),
         UINT32_C(0x002d9326),
         UINT32_C(0x0068848c),
         UINT32_C(0x4044809b),
         UINT32_C(0x406913bd),
         UINT32_C(0x004517aa),
         UINT32_C(0x3008e615),
         UINT32_C(0x7024e202),
         UINT32_C(0x70097124),
         UINT32_C(0x30257533),
         UINT32_C(0x30606299),
         UINT32_C(0x704c668e),
         UINT32_C(0x7061f5a8),
         UINT32_C(0x304df1bf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa01602),
         UINT32_C(0x3fa000cb),
         UINT32_C(0x3f8016c9),
         UINT32_C(0x3f803442),
         UINT32_C(0x3fa02240),
         UINT32_C(0x3fa03489),
         UINT32_C(0x3f80228b),
         UINT32_C(0x3f980473),
         UINT32_C(0x3fb81271),
         UINT32_C(0x3fb804b8),
         UINT32_C(0x3f9812ba),
         UINT32_C(0x3f983031),
         UINT32_C(0x3fb82633),
         UINT32_C(0x3fb830fa),
         UINT32_C(0x3f9826f8)},
        UINT32_C(0xfff80000),
        {0xd6,0x8f,0x13,0x03,0x40,0x7a,0xe8,0x41,0xe3,0x27,
         0x5b,0x23,0x49,0x63,0x1b,0x16,0x6a,0xa2,0x14,0x04,0x00}
    },
    {
        /* No.54 delta:951 weight:1563 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf09fc6c7),
         UINT32_C(0xf0b7937f),
         UINT32_C(0x002855b8),
         UINT32_C(0x29700360),
         UINT32_C(0xd9efc5a7),
         UINT32_C(0xd9c7901f),
         UINT32_C(0x295856d8),
         UINT32_C(0x00002334),
         UINT32_C(0xf09fe5f3),
         UINT32_C(0xf0b7b04b),
         UINT32_C(0x0028768c),
         UINT32_C(0x29702054),
         UINT32_C(0xd9efe693),
         UINT32_C(0xd9c7b32b),
         UINT32_C(0x295875ec)},
        {UINT32_C(0x00000000),
         UINT32_C(0x900c71be),
         UINT32_C(0x204dbc0a),
         UINT32_C(0xb041cdb4),
         UINT32_C(0x0020a5f7),
         UINT32_C(0x902cd449),
         UINT32_C(0x206d19fd),
         UINT32_C(0xb0616843),
         UINT32_C(0x2000300f),
         UINT32_C(0xb00c41b1),
         UINT32_C(0x004d8c05),
         UINT32_C(0x9041fdbb),
         UINT32_C(0x202095f8),
         UINT32_C(0xb02ce446),
         UINT32_C(0x006d29f2),
         UINT32_C(0x9061584c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc80638),
         UINT32_C(0x3f9026de),
         UINT32_C(0x3fd820e6),
         UINT32_C(0x3f801052),
         UINT32_C(0x3fc8166a),
         UINT32_C(0x3f90368c),
         UINT32_C(0x3fd830b4),
         UINT32_C(0x3f900018),
         UINT32_C(0x3fd80620),
         UINT32_C(0x3f8026c6),
         UINT32_C(0x3fc820fe),
         UINT32_C(0x3f90104a),
         UINT32_C(0x3fd81672),
         UINT32_C(0x3f803694),
         UINT32_C(0x3fc830ac)},
        UINT32_C(0xfff80000),
        {0xf8,0xc0,0x25,0xb4,0xda,0x06,0xca,0xc7,0x17,0x31,
         0xd6,0x67,0x69,0x44,0xeb,0x40,0x1f,0x0d,0xb7,0xc8,0x00}
    },
    {
        /* No.55 delta:820 weight:651 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x57316eba),
         UINT32_C(0x26094031),
         UINT32_C(0x71382e8b),
         UINT32_C(0xe8700378),
         UINT32_C(0xbf416dc2),
         UINT32_C(0xce794349),
         UINT32_C(0x99482df3),
         UINT32_C(0x000012ad),
         UINT32_C(0x57317c17),
         UINT32_C(0x2609529c),
         UINT32_C(0x71383c26),
         UINT32_C(0xe87011d5),
         UINT32_C(0xbf417f6f),
         UINT32_C(0xce7951e4),
         UINT32_C(0x99483f5e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x48301d92),
         UINT32_C(0x2c04420b),
         UINT32_C(0x64345f99),
         UINT32_C(0x0228401d),
         UINT32_C(0x4a185d8f),
         UINT32_C(0x2e2c0216),
         UINT32_C(0x661c1f84),
         UINT32_C(0x21510062),
         UINT32_C(0x69611df0),
         UINT32_C(0x0d554269),
         UINT32_C(0x45655ffb),
         UINT32_C(0x2379407f),
         UINT32_C(0x6b495ded),
         UINT32_C(0x0f7d0274),
         UINT32_C(0x474d1fe6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa4180e),
         UINT32_C(0x3f960221),
         UINT32_C(0x3fb21a2f),
         UINT32_C(0x3f811420),
         UINT32_C(0x3fa50c2e),
         UINT32_C(0x3f971601),
         UINT32_C(0x3fb30e0f),
         UINT32_C(0x3f90a880),
         UINT32_C(0x3fb4b08e),
         UINT32_C(0x3f86aaa1),
         UINT32_C(0x3fa2b2af),
         UINT32_C(0x3f91bca0),
         UINT32_C(0x3fb5a4ae),
         UINT32_C(0x3f87be81),
         UINT32_C(0x3fa3a68f)},
        UINT32_C(0xfff80000),
        {0x7e,0x9c,0x5e,0x32,0xc0,0x16,0x45,0xbd,0x76,0x10,
         0xe1,0xbf,0x45,0x88,0x55,0xbd,0x7d,0x2a,0x9a,0x13,0x00}
    },
    {
        /* No.56 delta:985 weight:1247 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd8c9f7ef),
         UINT32_C(0x678c6234),
         UINT32_C(0xbf4595db),
         UINT32_C(0xedc00381),
         UINT32_C(0x3509f46e),
         UINT32_C(0x8a4c61b5),
         UINT32_C(0x5285965a),
         UINT32_C(0x000064df),
         UINT32_C(0xd8c99330),
         UINT32_C(0x678c06eb),
         UINT32_C(0xbf45f104),
         UINT32_C(0xedc0675e),
         UINT32_C(0x350990b1),
         UINT32_C(0x8a4c056a),
         UINT32_C(0x5285f285)},
        {UINT32_C(0x00000000),
         UINT32_C(0x404d099a),
         UINT32_C(0x10636cac),
         UINT32_C(0x502e6536),
         UINT32_C(0x01078014),
         UINT32_C(0x414a898e),
         UINT32_C(0x1164ecb8),
         UINT32_C(0x5129e522),
         UINT32_C(0x000220ad),
         UINT32_C(0x404f2937),
         UINT32_C(0x10614c01),
         UINT32_C(0x502c459b),
         UINT32_C(0x0105a0b9),
         UINT32_C(0x4148a923),
         UINT32_C(0x1166cc15),
         UINT32_C(0x512bc58f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02684),
         UINT32_C(0x3f8831b6),
         UINT32_C(0x3fa81732),
         UINT32_C(0x3f8083c0),
         UINT32_C(0x3fa0a544),
         UINT32_C(0x3f88b276),
         UINT32_C(0x3fa894f2),
         UINT32_C(0x3f800110),
         UINT32_C(0x3fa02794),
         UINT32_C(0x3f8830a6),
         UINT32_C(0x3fa81622),
         UINT32_C(0x3f8082d0),
         UINT32_C(0x3fa0a454),
         UINT32_C(0x3f88b366),
         UINT32_C(0x3fa895e2)},
        UINT32_C(0xfff80000),
        {0x47,0x79,0x4f,0x24,0x4f,0x28,0x51,0x55,0xe6,0x00,
         0xb2,0x92,0x43,0x2e,0xef,0x24,0x53,0x4b,0x89,0xae,0x00}
    },
    {
        /* No.57 delta:2159 weight:1381 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7a54ffc0),
         UINT32_C(0x46d69d10),
         UINT32_C(0x3c8262d0),
         UINT32_C(0xae80039c),
         UINT32_C(0xd4d4fc5c),
         UINT32_C(0xe8569e8c),
         UINT32_C(0x9202614c),
         UINT32_C(0x00006126),
         UINT32_C(0x7a549ee6),
         UINT32_C(0x46d6fc36),
         UINT32_C(0x3c8203f6),
         UINT32_C(0xae8062ba),
         UINT32_C(0xd4d49d7a),
         UINT32_C(0xe856ffaa),
         UINT32_C(0x9202006a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x648d905b),
         UINT32_C(0x1720008f),
         UINT32_C(0x73ad90d4),
         UINT32_C(0x08090109),
         UINT32_C(0x6c849152),
         UINT32_C(0x1f290186),
         UINT32_C(0x7ba491dd),
         UINT32_C(0x4884300c),
         UINT32_C(0x2c09a057),
         UINT32_C(0x5fa43083),
         UINT32_C(0x3b29a0d8),
         UINT32_C(0x408d3105),
         UINT32_C(0x2400a15e),
         UINT32_C(0x57ad318a),
         UINT32_C(0x3320a1d1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb246c8),
         UINT32_C(0x3f8b9000),
         UINT32_C(0x3fb9d6c8),
         UINT32_C(0x3f840480),
         UINT32_C(0x3fb64248),
         UINT32_C(0x3f8f9480),
         UINT32_C(0x3fbdd248),
         UINT32_C(0x3fa44218),
         UINT32_C(0x3f9604d0),
         UINT32_C(0x3fafd218),
         UINT32_C(0x3f9d94d0),
         UINT32_C(0x3fa04698),
         UINT32_C(0x3f920050),
         UINT32_C(0x3fabd698),
         UINT32_C(0x3f999050)},
        UINT32_C(0xfff80000),
        {0x65,0x7d,0x27,0xa8,0x7d,0x8d,0x8f,0x40,0xf6,0x00,
         0x92,0x6e,0xb9,0x2c,0x8f,0x1f,0xf7,0xcd,0xf8,0xf8,0x00}
    },
    {
        /* No.58 delta:960 weight:1657 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x39030bf4),
         UINT32_C(0xdc4c74cc),
         UINT32_C(0xe54f7f38),
         UINT32_C(0x384003a5),
         UINT32_C(0x01430851),
         UINT32_C(0xe40c7769),
         UINT32_C(0xdd0f7c9d),
         UINT32_C(0x0000d6eb),
         UINT32_C(0x3903dd1f),
         UINT32_C(0xdc4ca227),
         UINT32_C(0xe54fa9d3),
         UINT32_C(0x3840d54e),
         UINT32_C(0x0143deba),
         UINT32_C(0xe40ca182),
         UINT32_C(0xdd0faa76)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4036ac1a),
         UINT32_C(0x506559cc),
         UINT32_C(0x1053f5d6),
         UINT32_C(0x0002501b),
         UINT32_C(0x4034fc01),
         UINT32_C(0x506709d7),
         UINT32_C(0x1051a5cd),
         UINT32_C(0x30280592),
         UINT32_C(0x701ea988),
         UINT32_C(0x604d5c5e),
         UINT32_C(0x207bf044),
         UINT32_C(0x302a5589),
         UINT32_C(0x701cf993),
         UINT32_C(0x604f0c45),
         UINT32_C(0x2079a05f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa01b56),
         UINT32_C(0x3fa832ac),
         UINT32_C(0x3f8829fa),
         UINT32_C(0x3f800128),
         UINT32_C(0x3fa01a7e),
         UINT32_C(0x3fa83384),
         UINT32_C(0x3f8828d2),
         UINT32_C(0x3f981402),
         UINT32_C(0x3fb80f54),
         UINT32_C(0x3fb026ae),
         UINT32_C(0x3f903df8),
         UINT32_C(0x3f98152a),
         UINT32_C(0x3fb80e7c),
         UINT32_C(0x3fb02786),
         UINT32_C(0x3f903cd0)},
        UINT32_C(0xfff80000),
        {0x22,0xa6,0x3d,0x5c,0x9c,0x64,0xc4,0x1a,0x87,0xbc,
         0x5a,0x8b,0x20,0xf8,0x21,0x9e,0x1f,0xf6,0xcd,0xcc,0x00}
    },
    {
        /* No.59 delta:756 weight:1633 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe9579f78),
         UINT32_C(0xecb6987d),
         UINT32_C(0x05e10705),
         UINT32_C(0xdd5003bf),
         UINT32_C(0x34079cc7),
         UINT32_C(0x31e69bc2),
         UINT32_C(0xd8b104ba),
         UINT32_C(0x00008eff),
         UINT32_C(0xe9571187),
         UINT32_C(0xecb61682),
         UINT32_C(0x05e189fa),
         UINT32_C(0xdd508d40),
         UINT32_C(0x34071238),
         UINT32_C(0x31e6153d),
         UINT32_C(0xd8b18a45)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8004081d),
         UINT32_C(0x300b8a16),
         UINT32_C(0xb00f820b),
         UINT32_C(0x20025234),
         UINT32_C(0xa0065a29),
         UINT32_C(0x1009d822),
         UINT32_C(0x900dd03f),
         UINT32_C(0x3000f0b8),
         UINT32_C(0xb004f8a5),
         UINT32_C(0x000b7aae),
         UINT32_C(0x800f72b3),
         UINT32_C(0x1002a28c),
         UINT32_C(0x9006aa91),
         UINT32_C(0x2009289a),
         UINT32_C(0xa00d2087)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00204),
         UINT32_C(0x3f9805c5),
         UINT32_C(0x3fd807c1),
         UINT32_C(0x3f900129),
         UINT32_C(0x3fd0032d),
         UINT32_C(0x3f8804ec),
         UINT32_C(0x3fc806e8),
         UINT32_C(0x3f980078),
         UINT32_C(0x3fd8027c),
         UINT32_C(0x3f8005bd),
         UINT32_C(0x3fc007b9),
         UINT32_C(0x3f880151),
         UINT32_C(0x3fc80355),
         UINT32_C(0x3f900494),
         UINT32_C(0x3fd00690)},
        UINT32_C(0xfff80000),
        {0x85,0x15,0x62,0xa4,0x84,0x38,0x47,0xdf,0x75,0x59,
         0xe1,0x04,0xe4,0xca,0xb9,0x9c,0x18,0x22,0x13,0xe3,0x00}
    },
    {
        /* No.60 delta:884 weight:1491 */
        11213,
        86,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2b4ddbaa),
         UINT32_C(0x62581d43),
         UINT32_C(0x4915c6e9),
         UINT32_C(0xb02003cc),
         UINT32_C(0x9b6dd866),
         UINT32_C(0xd2781e8f),
         UINT32_C(0xf935c525),
         UINT32_C(0x0000065e),
         UINT32_C(0x2b4dddf4),
         UINT32_C(0x62581b1d),
         UINT32_C(0x4915c0b7),
         UINT32_C(0xb0200592),
         UINT32_C(0x9b6dde38),
         UINT32_C(0xd27818d1),
         UINT32_C(0xf935c37b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4857d1f3),
         UINT32_C(0x006c189c),
         UINT32_C(0x483bc96f),
         UINT32_C(0x00109016),
         UINT32_C(0x484741e5),
         UINT32_C(0x007c888a),
         UINT32_C(0x482b5979),
         UINT32_C(0x0042e11e),
         UINT32_C(0x481530ed),
         UINT32_C(0x002ef982),
         UINT32_C(0x48792871),
         UINT32_C(0x00527108),
         UINT32_C(0x4805a0fb),
         UINT32_C(0x003e6994),
         UINT32_C(0x4869b867)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa42be8),
         UINT32_C(0x3f80360c),
         UINT32_C(0x3fa41de4),
         UINT32_C(0x3f800848),
         UINT32_C(0x3fa423a0),
         UINT32_C(0x3f803e44),
         UINT32_C(0x3fa415ac),
         UINT32_C(0x3f802170),
         UINT32_C(0x3fa40a98),
         UINT32_C(0x3f80177c),
         UINT32_C(0x3fa43c94),
         UINT32_C(0x3f802938),
         UINT32_C(0x3fa402d0),
         UINT32_C(0x3f801f34),
         UINT32_C(0x3fa434dc)},
        UINT32_C(0xfff80000),
        {0x39,0x31,0x69,0x5e,0x7e,0x10,0xb8,0xaa,0x3a,0x98,
         0x1c,0x5b,0xff,0x82,0x62,0x56,0xa4,0x6d,0x74,0xcb,0x00}
    },
    {
        /* No.61 delta:906 weight:1689 */
        11213,
        68,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x91a3a21f),
         UINT32_C(0x5fe47590),
         UINT32_C(0xce47d78f),
         UINT32_C(0x4ae003d2),
         UINT32_C(0xdb43a1cd),
         UINT32_C(0x15047642),
         UINT32_C(0x84a7d45d),
         UINT32_C(0x0000207b),
         UINT32_C(0x91a38264),
         UINT32_C(0x5fe455eb),
         UINT32_C(0xce47f7f4),
         UINT32_C(0x4ae023a9),
         UINT32_C(0xdb4381b6),
         UINT32_C(0x15045639),
         UINT32_C(0x84a7f426)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0003183a),
         UINT32_C(0x685560d6),
         UINT32_C(0x685678ec),
         UINT32_C(0x00080811),
         UINT32_C(0x000b102b),
         UINT32_C(0x685d68c7),
         UINT32_C(0x685e70fd),
         UINT32_C(0x10414608),
         UINT32_C(0x10425e32),
         UINT32_C(0x781426de),
         UINT32_C(0x78173ee4),
         UINT32_C(0x10494e19),
         UINT32_C(0x104a5623),
         UINT32_C(0x781c2ecf),
         UINT32_C(0x781f36f5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80018c),
         UINT32_C(0x3fb42ab0),
         UINT32_C(0x3fb42b3c),
         UINT32_C(0x3f800404),
         UINT32_C(0x3f800588),
         UINT32_C(0x3fb42eb4),
         UINT32_C(0x3fb42f38),
         UINT32_C(0x3f8820a3),
         UINT32_C(0x3f88212f),
         UINT32_C(0x3fbc0a13),
         UINT32_C(0x3fbc0b9f),
         UINT32_C(0x3f8824a7),
         UINT32_C(0x3f88252b),
         UINT32_C(0x3fbc0e17),
         UINT32_C(0x3fbc0f9b)},
        UINT32_C(0xfff80000),
        {0x57,0x3c,0x84,0xe5,0x98,0xdb,0x39,0x4a,0xeb,0xa4,
         0x81,0x6b,0x09,0x0d,0xc0,0xe8,0xe9,0x35,0x36,0xb6,0x00}
    },
    {
        /* No.62 delta:1119 weight:1595 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7c95ddbe),
         UINT32_C(0xbc1eaeaf),
         UINT32_C(0xc08b7311),
         UINT32_C(0xc13003e8),
         UINT32_C(0xbda5de56),
         UINT32_C(0x7d2ead47),
         UINT32_C(0x01bb70f9),
         UINT32_C(0x00001cd3),
         UINT32_C(0x7c95c16d),
         UINT32_C(0xbc1eb27c),
         UINT32_C(0xc08b6fc2),
         UINT32_C(0xc1301f3b),
         UINT32_C(0xbda5c285),
         UINT32_C(0x7d2eb194),
         UINT32_C(0x01bb6c2a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20449212),
         UINT32_C(0x2026c1f4),
         UINT32_C(0x006253e6),
         UINT32_C(0x1008101b),
         UINT32_C(0x304c8209),
         UINT32_C(0x302ed1ef),
         UINT32_C(0x106a43fd),
         UINT32_C(0x00035008),
         UINT32_C(0x2047c21a),
         UINT32_C(0x202591fc),
         UINT32_C(0x006103ee),
         UINT32_C(0x100b4013),
         UINT32_C(0x304fd201),
         UINT32_C(0x302d81e7),
         UINT32_C(0x106913f5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902249),
         UINT32_C(0x3f901360),
         UINT32_C(0x3f803129),
         UINT32_C(0x3f880408),
         UINT32_C(0x3f982641),
         UINT32_C(0x3f981768),
         UINT32_C(0x3f883521),
         UINT32_C(0x3f8001a8),
         UINT32_C(0x3f9023e1),
         UINT32_C(0x3f9012c8),
         UINT32_C(0x3f803081),
         UINT32_C(0x3f8805a0),
         UINT32_C(0x3f9827e9),
         UINT32_C(0x3f9816c0),
         UINT32_C(0x3f883489)},
        UINT32_C(0xfff80000),
        {0x15,0x36,0x2b,0xe9,0xbe,0xfc,0x35,0x7f,0x43,0x78,
         0xb2,0xe9,0x1b,0x6f,0xe1,0x9a,0x31,0x7e,0xa7,0xa5,0x00}
    },
    {
        /* No.63 delta:1018 weight:1315 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf4c75a08),
         UINT32_C(0x33451618),
         UINT32_C(0xc7824c10),
         UINT32_C(0x1a2003fc),
         UINT32_C(0xeee759f4),
         UINT32_C(0x296515e4),
         UINT32_C(0xdda24fec),
         UINT32_C(0x0000bc07),
         UINT32_C(0xf4c7e60f),
         UINT32_C(0x3345aa1f),
         UINT32_C(0xc782f017),
         UINT32_C(0x1a20bffb),
         UINT32_C(0xeee7e5f3),
         UINT32_C(0x2965a9e3),
         UINT32_C(0xdda2f3eb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0154993e),
         UINT32_C(0x102e04dc),
         UINT32_C(0x117a9de2),
         UINT32_C(0x00562016),
         UINT32_C(0x0102b928),
         UINT32_C(0x107824ca),
         UINT32_C(0x112cbdf4),
         UINT32_C(0x00028084),
         UINT32_C(0x015619ba),
         UINT32_C(0x102c8458),
         UINT32_C(0x11781d66),
         UINT32_C(0x0054a092),
         UINT32_C(0x010039ac),
         UINT32_C(0x107aa44e),
         UINT32_C(0x112e3d70)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80aa4c),
         UINT32_C(0x3f881702),
         UINT32_C(0x3f88bd4e),
         UINT32_C(0x3f802b10),
         UINT32_C(0x3f80815c),
         UINT32_C(0x3f883c12),
         UINT32_C(0x3f88965e),
         UINT32_C(0x3f800140),
         UINT32_C(0x3f80ab0c),
         UINT32_C(0x3f881642),
         UINT32_C(0x3f88bc0e),
         UINT32_C(0x3f802a50),
         UINT32_C(0x3f80801c),
         UINT32_C(0x3f883d52),
         UINT32_C(0x3f88971e)},
        UINT32_C(0xfff80000),
        {0x0b,0x34,0x5c,0x8b,0x80,0x6e,0x98,0xde,0x54,0x2d,
         0xbc,0xd0,0x18,0x38,0x01,0x6b,0x27,0x70,0x53,0x67,0x00}
    },
    {
        /* No.64 delta:1089 weight:1641 */
        11213,
        27,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x320f354d),
         UINT32_C(0x4b52ac78),
         UINT32_C(0x795d9935),
         UINT32_C(0x1be00405),
         UINT32_C(0x29ef3148),
         UINT32_C(0x50b2a87d),
         UINT32_C(0x62bd9d30),
         UINT32_C(0x0000f8ea),
         UINT32_C(0x320fcda7),
         UINT32_C(0x4b525492),
         UINT32_C(0x795d61df),
         UINT32_C(0x1be0fcef),
         UINT32_C(0x29efc9a2),
         UINT32_C(0x50b25097),
         UINT32_C(0x62bd65da)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00441014),
         UINT32_C(0x0168282f),
         UINT32_C(0x012c383b),
         UINT32_C(0x205018c9),
         UINT32_C(0x201408dd),
         UINT32_C(0x213830e6),
         UINT32_C(0x217c20f2),
         UINT32_C(0x0060788e),
         UINT32_C(0x0024689a),
         UINT32_C(0x010850a1),
         UINT32_C(0x014c40b5),
         UINT32_C(0x20306047),
         UINT32_C(0x20747053),
         UINT32_C(0x21584868),
         UINT32_C(0x211c587c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802208),
         UINT32_C(0x3f80b414),
         UINT32_C(0x3f80961c),
         UINT32_C(0x3f90280c),
         UINT32_C(0x3f900a04),
         UINT32_C(0x3f909c18),
         UINT32_C(0x3f90be10),
         UINT32_C(0x3f80303c),
         UINT32_C(0x3f801234),
         UINT32_C(0x3f808428),
         UINT32_C(0x3f80a620),
         UINT32_C(0x3f901830),
         UINT32_C(0x3f903a38),
         UINT32_C(0x3f90ac24),
         UINT32_C(0x3f908e2c)},
        UINT32_C(0xfff80000),
        {0x0b,0x75,0x3a,0x0f,0x25,0x1b,0x1e,0x62,0x79,0xde,
         0x49,0xe4,0x67,0xde,0x19,0x1c,0x07,0x87,0xb7,0x03,0x00}
    },
    {
        /* No.65 delta:714 weight:1595 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc4cfa437),
         UINT32_C(0xb22d512f),
         UINT32_C(0x76e2f518),
         UINT32_C(0x1fb00411),
         UINT32_C(0xdb7fa026),
         UINT32_C(0xad9d553e),
         UINT32_C(0x6952f109),
         UINT32_C(0x0000b641),
         UINT32_C(0xc4cf1276),
         UINT32_C(0xb22de76e),
         UINT32_C(0x76e24359),
         UINT32_C(0x1fb0b250),
         UINT32_C(0xdb7f1667),
         UINT32_C(0xad9de37f),
         UINT32_C(0x69524748)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0003499a),
         UINT32_C(0x904c1025),
         UINT32_C(0x904f59bf),
         UINT32_C(0x60086118),
         UINT32_C(0x600b2882),
         UINT32_C(0xf044713d),
         UINT32_C(0xf04738a7),
         UINT32_C(0x00009815),
         UINT32_C(0x0003d18f),
         UINT32_C(0x904c8830),
         UINT32_C(0x904fc1aa),
         UINT32_C(0x6008f90d),
         UINT32_C(0x600bb097),
         UINT32_C(0xf044e928),
         UINT32_C(0xf047a0b2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8001a4),
         UINT32_C(0x3fc82608),
         UINT32_C(0x3fc827ac),
         UINT32_C(0x3fb00430),
         UINT32_C(0x3fb00594),
         UINT32_C(0x3ff82238),
         UINT32_C(0x3ff8239c),
         UINT32_C(0x3f80004c),
         UINT32_C(0x3f8001e8),
         UINT32_C(0x3fc82644),
         UINT32_C(0x3fc827e0),
         UINT32_C(0x3fb0047c),
         UINT32_C(0x3fb005d8),
         UINT32_C(0x3ff82274),
         UINT32_C(0x3ff823d0)},
        UINT32_C(0xfff80000),
        {0xc2,0xcd,0xc7,0x28,0xfa,0x9f,0xe4,0x82,0x5d,0x7c,
         0x58,0x33,0x83,0xa7,0x2d,0xd5,0x6e,0x00,0xce,0x8b,0x00}
    },
    {
        /* No.66 delta:1489 weight:1775 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x27ac5b8e),
         UINT32_C(0x7da1bc19),
         UINT32_C(0x5a0de797),
         UINT32_C(0xc1d00429),
         UINT32_C(0xe67c5fa7),
         UINT32_C(0xbc71b830),
         UINT32_C(0x9bdde3be),
         UINT32_C(0x0000f5b6),
         UINT32_C(0x27acae38),
         UINT32_C(0x7da149af),
         UINT32_C(0x5a0d1221),
         UINT32_C(0xc1d0f19f),
         UINT32_C(0xe67caa11),
         UINT32_C(0xbc714d86),
         UINT32_C(0x9bdd1608)},
        {UINT32_C(0x00000000),
         UINT32_C(0x486c4874),
         UINT32_C(0x0249557f),
         UINT32_C(0x4a251d0b),
         UINT32_C(0x107c8402),
         UINT32_C(0x5810cc76),
         UINT32_C(0x1235d17d),
         UINT32_C(0x5a599909),
         UINT32_C(0x1003f025),
         UINT32_C(0x586fb851),
         UINT32_C(0x124aa55a),
         UINT32_C(0x5a26ed2e),
         UINT32_C(0x007f7427),
         UINT32_C(0x48133c53),
         UINT32_C(0x02362158),
         UINT32_C(0x4a5a692c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa43624),
         UINT32_C(0x3f8124aa),
         UINT32_C(0x3fa5128e),
         UINT32_C(0x3f883e42),
         UINT32_C(0x3fac0866),
         UINT32_C(0x3f891ae8),
         UINT32_C(0x3fad2ccc),
         UINT32_C(0x3f8801f8),
         UINT32_C(0x3fac37dc),
         UINT32_C(0x3f892552),
         UINT32_C(0x3fad1376),
         UINT32_C(0x3f803fba),
         UINT32_C(0x3fa4099e),
         UINT32_C(0x3f811b10),
         UINT32_C(0x3fa52d34)},
        UINT32_C(0xfff80000),
        {0x96,0xb5,0xb1,0x05,0x1a,0xe3,0x5f,0x00,0x61,0x64,
         0xea,0x66,0xa3,0x2b,0xe1,0x35,0xb4,0x7d,0x59,0xd2,0x00}
    },
    {
        /* No.67 delta:723 weight:1463 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfc1f1f2f),
         UINT32_C(0xc4d2cb0e),
         UINT32_C(0x38cdd421),
         UINT32_C(0xc2b00437),
         UINT32_C(0x3eaf1b18),
         UINT32_C(0x0662cf39),
         UINT32_C(0xfa7dd016),
         UINT32_C(0x0000a8c0),
         UINT32_C(0xfc1fb7ef),
         UINT32_C(0xc4d263ce),
         UINT32_C(0x38cd7ce1),
         UINT32_C(0xc2b0acf7),
         UINT32_C(0x3eafb3d8),
         UINT32_C(0x066267f9),
         UINT32_C(0xfa7d78d6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00641c81),
         UINT32_C(0x340b711d),
         UINT32_C(0x346f6d9c),
         UINT32_C(0x1015e41f),
         UINT32_C(0x1071f89e),
         UINT32_C(0x241e9502),
         UINT32_C(0x247a8983),
         UINT32_C(0x00028e08),
         UINT32_C(0x00669289),
         UINT32_C(0x3409ff15),
         UINT32_C(0x346de394),
         UINT32_C(0x10176a17),
         UINT32_C(0x10737696),
         UINT32_C(0x241c1b0a),
         UINT32_C(0x2478078b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80320e),
         UINT32_C(0x3f9a05b8),
         UINT32_C(0x3f9a37b6),
         UINT32_C(0x3f880af2),
         UINT32_C(0x3f8838fc),
         UINT32_C(0x3f920f4a),
         UINT32_C(0x3f923d44),
         UINT32_C(0x3f800147),
         UINT32_C(0x3f803349),
         UINT32_C(0x3f9a04ff),
         UINT32_C(0x3f9a36f1),
         UINT32_C(0x3f880bb5),
         UINT32_C(0x3f8839bb),
         UINT32_C(0x3f920e0d),
         UINT32_C(0x3f923c03)},
        UINT32_C(0xfff80000),
        {0xf4,0x2a,0x3e,0xd7,0x86,0x3d,0xa0,0x67,0x25,0xa6,
         0xa8,0x85,0x72,0xca,0x5c,0x60,0xcc,0xc8,0x6f,0x35,0x00}
    },
    {
        /* No.68 delta:1693 weight:1443 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x13299b1c),
         UINT32_C(0x63241401),
         UINT32_C(0x700d8f1d),
         UINT32_C(0x42600440),
         UINT32_C(0x51499f5c),
         UINT32_C(0x21441041),
         UINT32_C(0x326d8b5d),
         UINT32_C(0x00001370),
         UINT32_C(0x1329886c),
         UINT32_C(0x63240771),
         UINT32_C(0x700d9c6d),
         UINT32_C(0x42601730),
         UINT32_C(0x51498c2c),
         UINT32_C(0x21440331),
         UINT32_C(0x326d982d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x21a4819e),
         UINT32_C(0x153ae095),
         UINT32_C(0x349e610b),
         UINT32_C(0x40056146),
         UINT32_C(0x61a1e0d8),
         UINT32_C(0x553f81d3),
         UINT32_C(0x749b004d),
         UINT32_C(0x180164bc),
         UINT32_C(0x39a5e522),
         UINT32_C(0x0d3b8429),
         UINT32_C(0x2c9f05b7),
         UINT32_C(0x580405fa),
         UINT32_C(0x79a08464),
         UINT32_C(0x4d3ee56f),
         UINT32_C(0x6c9a64f1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90d240),
         UINT32_C(0x3f8a9d70),
         UINT32_C(0x3f9a4f30),
         UINT32_C(0x3fa002b0),
         UINT32_C(0x3fb0d0f0),
         UINT32_C(0x3faa9fc0),
         UINT32_C(0x3fba4d80),
         UINT32_C(0x3f8c00b2),
         UINT32_C(0x3f9cd2f2),
         UINT32_C(0x3f869dc2),
         UINT32_C(0x3f964f82),
         UINT32_C(0x3fac0202),
         UINT32_C(0x3fbcd042),
         UINT32_C(0x3fa69f72),
         UINT32_C(0x3fb64d32)},
        UINT32_C(0xfff80000),
        {0xd1,0x71,0x93,0x13,0xcd,0x52,0x65,0x76,0x85,0x6a,
         0x2e,0xb7,0xf3,0x0b,0x49,0x99,0x86,0x3d,0x92,0x0d,0x00}
    },
    {
        /* No.69 delta:1307 weight:1479 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x07c30918),
         UINT32_C(0x94343ae4),
         UINT32_C(0x93f733fc),
         UINT32_C(0x6db00450),
         UINT32_C(0x6a730d48),
         UINT32_C(0xf9843eb4),
         UINT32_C(0xfe4737ac),
         UINT32_C(0x00007d59),
         UINT32_C(0x07c37441),
         UINT32_C(0x943447bd),
         UINT32_C(0x93f74ea5),
         UINT32_C(0x6db07909),
         UINT32_C(0x6a737011),
         UINT32_C(0xf98443ed),
         UINT32_C(0xfe474af5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4075907e),
         UINT32_C(0x004c410c),
         UINT32_C(0x4039d172),
         UINT32_C(0x002f09cd),
         UINT32_C(0x405a99b3),
         UINT32_C(0x006348c1),
         UINT32_C(0x4016d8bf),
         UINT32_C(0x4008b006),
         UINT32_C(0x007d2078),
         UINT32_C(0x4044f10a),
         UINT32_C(0x00316174),
         UINT32_C(0x4027b9cb),
         UINT32_C(0x005229b5),
         UINT32_C(0x406bf8c7),
         UINT32_C(0x001e68b9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03ac8),
         UINT32_C(0x3f802620),
         UINT32_C(0x3fa01ce8),
         UINT32_C(0x3f801784),
         UINT32_C(0x3fa02d4c),
         UINT32_C(0x3f8031a4),
         UINT32_C(0x3fa00b6c),
         UINT32_C(0x3fa00458),
         UINT32_C(0x3f803e90),
         UINT32_C(0x3fa02278),
         UINT32_C(0x3f8018b0),
         UINT32_C(0x3fa013dc),
         UINT32_C(0x3f802914),
         UINT32_C(0x3fa035fc),
         UINT32_C(0x3f800f34)},
        UINT32_C(0xfff80000),
        {0xf5,0x02,0x42,0xbf,0xf1,0xcd,0x2a,0xe7,0xcc,0x16,
         0x29,0xd9,0xdf,0x4c,0x1b,0x8a,0xd2,0xe3,0x42,0x87,0x00}
    },
    {
        /* No.70 delta:2277 weight:1275 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7556a31c),
         UINT32_C(0xe17eb988),
         UINT32_C(0x94281a94),
         UINT32_C(0x85000461),
         UINT32_C(0xf056a77d),
         UINT32_C(0x647ebde9),
         UINT32_C(0x11281ef5),
         UINT32_C(0x0000a401),
         UINT32_C(0x7556071d),
         UINT32_C(0xe17e1d89),
         UINT32_C(0x9428be95),
         UINT32_C(0x8500a060),
         UINT32_C(0xf056037c),
         UINT32_C(0x647e19e8),
         UINT32_C(0x1128baf4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4a8384f2),
         UINT32_C(0x14b0012d),
         UINT32_C(0x5e3385df),
         UINT32_C(0x18488015),
         UINT32_C(0x52cb04e7),
         UINT32_C(0x0cf88138),
         UINT32_C(0x467b05ca),
         UINT32_C(0x4800403a),
         UINT32_C(0x0283c4c8),
         UINT32_C(0x5cb04117),
         UINT32_C(0x1633c5e5),
         UINT32_C(0x5048c02f),
         UINT32_C(0x1acb44dd),
         UINT32_C(0x44f8c102),
         UINT32_C(0x0e7b45f0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa541c2),
         UINT32_C(0x3f8a5800),
         UINT32_C(0x3faf19c2),
         UINT32_C(0x3f8c2440),
         UINT32_C(0x3fa96582),
         UINT32_C(0x3f867c40),
         UINT32_C(0x3fa33d82),
         UINT32_C(0x3fa40020),
         UINT32_C(0x3f8141e2),
         UINT32_C(0x3fae5820),
         UINT32_C(0x3f8b19e2),
         UINT32_C(0x3fa82460),
         UINT32_C(0x3f8d65a2),
         UINT32_C(0x3fa27c60),
         UINT32_C(0x3f873da2)},
        UINT32_C(0xfff80000),
        {0x1e,0x51,0xac,0x8a,0x9d,0x34,0x89,0x83,0x73,0xe5,
         0x49,0x94,0x37,0x11,0x32,0x2d,0x8a,0xb6,0xcd,0x96,0x00}
    },
    {
        /* No.71 delta:1215 weight:1591 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc94d3c2c),
         UINT32_C(0x2e401a94),
         UINT32_C(0xe70d26b8),
         UINT32_C(0x50100470),
         UINT32_C(0x995d385c),
         UINT32_C(0x7e501ee4),
         UINT32_C(0xb71d22c8),
         UINT32_C(0x00006b09),
         UINT32_C(0xc94d5725),
         UINT32_C(0x2e40719d),
         UINT32_C(0xe70d4db1),
         UINT32_C(0x50106f79),
         UINT32_C(0x995d5355),
         UINT32_C(0x7e5075ed),
         UINT32_C(0xb71d49c1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0826883a),
         UINT32_C(0x005840e9),
         UINT32_C(0x087ec8d3),
         UINT32_C(0x205c05d1),
         UINT32_C(0x287a8deb),
         UINT32_C(0x20044538),
         UINT32_C(0x2822cd02),
         UINT32_C(0x11089817),
         UINT32_C(0x192e102d),
         UINT32_C(0x1150d8fe),
         UINT32_C(0x197650c4),
         UINT32_C(0x31549dc6),
         UINT32_C(0x397215fc),
         UINT32_C(0x310cdd2f),
         UINT32_C(0x392a5515)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841344),
         UINT32_C(0x3f802c20),
         UINT32_C(0x3f843f64),
         UINT32_C(0x3f902e02),
         UINT32_C(0x3f943d46),
         UINT32_C(0x3f900222),
         UINT32_C(0x3f941166),
         UINT32_C(0x3f88844c),
         UINT32_C(0x3f8c9708),
         UINT32_C(0x3f88a86c),
         UINT32_C(0x3f8cbb28),
         UINT32_C(0x3f98aa4e),
         UINT32_C(0x3f9cb90a),
         UINT32_C(0x3f98866e),
         UINT32_C(0x3f9c952a)},
        UINT32_C(0xfff80000),
        {0x4f,0x05,0x82,0x20,0xf4,0x8d,0x2d,0xe9,0x1c,0xd5,
         0x73,0x15,0xb0,0xaa,0xf2,0x4f,0x30,0x04,0x96,0xb4,0x00}
    },
    {
        /* No.72 delta:652 weight:1403 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x291f4139),
         UINT32_C(0xe6434801),
         UINT32_C(0xcf5c0938),
         UINT32_C(0xe4b0048a),
         UINT32_C(0xcdaf45b3),
         UINT32_C(0x02f34c8b),
         UINT32_C(0x2bec0db2),
         UINT32_C(0x00008ad9),
         UINT32_C(0x291fcbe0),
         UINT32_C(0xe643c2d8),
         UINT32_C(0xcf5c83e1),
         UINT32_C(0xe4b08e53),
         UINT32_C(0xcdafcf6a),
         UINT32_C(0x02f3c652),
         UINT32_C(0x2bec876b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0063c957),
         UINT32_C(0x802cb41b),
         UINT32_C(0x804f7d4c),
         UINT32_C(0x0431412d),
         UINT32_C(0x0452887a),
         UINT32_C(0x841df536),
         UINT32_C(0x847e3c61),
         UINT32_C(0x000231d1),
         UINT32_C(0x0061f886),
         UINT32_C(0x802e85ca),
         UINT32_C(0x804d4c9d),
         UINT32_C(0x043370fc),
         UINT32_C(0x0450b9ab),
         UINT32_C(0x841fc4e7),
         UINT32_C(0x847c0db0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8031e4),
         UINT32_C(0x3fc0165a),
         UINT32_C(0x3fc027be),
         UINT32_C(0x3f8218a0),
         UINT32_C(0x3f822944),
         UINT32_C(0x3fc20efa),
         UINT32_C(0x3fc23f1e),
         UINT32_C(0x3f800118),
         UINT32_C(0x3f8030fc),
         UINT32_C(0x3fc01742),
         UINT32_C(0x3fc026a6),
         UINT32_C(0x3f8219b8),
         UINT32_C(0x3f82285c),
         UINT32_C(0x3fc20fe2),
         UINT32_C(0x3fc23e06)},
        UINT32_C(0xfff80000),
        {0x6f,0x2d,0x27,0x79,0xae,0xd3,0x36,0x85,0x65,0x0d,
         0x5d,0xb5,0xac,0x24,0x89,0xe2,0x2e,0xbe,0x97,0xb4,0x00}
    },
    {
        /* No.73 delta:1101 weight:1763 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x560d2adb),
         UINT32_C(0xb2127f1a),
         UINT32_C(0xe41f55c1),
         UINT32_C(0x51300499),
         UINT32_C(0x073d2e42),
         UINT32_C(0xe3227b83),
         UINT32_C(0xb52f5158),
         UINT32_C(0x0000abdc),
         UINT32_C(0x560d8107),
         UINT32_C(0xb212d4c6),
         UINT32_C(0xe41ffe1d),
         UINT32_C(0x5130af45),
         UINT32_C(0x073d859e),
         UINT32_C(0xe322d05f),
         UINT32_C(0xb52ffa84)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0050e576),
         UINT32_C(0x600041bb),
         UINT32_C(0x6050a4cd),
         UINT32_C(0xb00138e7),
         UINT32_C(0xb051dd91),
         UINT32_C(0xd001795c),
         UINT32_C(0xd0519c2a),
         UINT32_C(0x30181083),
         UINT32_C(0x3048f5f5),
         UINT32_C(0x50185138),
         UINT32_C(0x5048b44e),
         UINT32_C(0x80192864),
         UINT32_C(0x8049cd12),
         UINT32_C(0xe01969df),
         UINT32_C(0xe0498ca9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802872),
         UINT32_C(0x3fb00020),
         UINT32_C(0x3fb02852),
         UINT32_C(0x3fd8009c),
         UINT32_C(0x3fd828ee),
         UINT32_C(0x3fe800bc),
         UINT32_C(0x3fe828ce),
         UINT32_C(0x3f980c08),
         UINT32_C(0x3f98247a),
         UINT32_C(0x3fa80c28),
         UINT32_C(0x3fa8245a),
         UINT32_C(0x3fc00c94),
         UINT32_C(0x3fc024e6),
         UINT32_C(0x3ff00cb4),
         UINT32_C(0x3ff024c6)},
        UINT32_C(0xfff80000),
        {0x24,0xa9,0xfe,0xbb,0x8f,0x2a,0x81,0xe7,0x73,0x37,
         0xb9,0x39,0x98,0x66,0x5c,0x81,0x55,0xb9,0x0e,0x19,0x00}
    },
    {
        /* No.74 delta:876 weight:905 */
        11213,
        59,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5af2542e),
         UINT32_C(0x5bb7bc50),
         UINT32_C(0x0145e87e),
         UINT32_C(0x331004a3),
         UINT32_C(0x69e2508d),
         UINT32_C(0x68a7b8f3),
         UINT32_C(0x3255ecdd),
         UINT32_C(0x0000f93b),
         UINT32_C(0x5af2ad15),
         UINT32_C(0x5bb7456b),
         UINT32_C(0x01451145),
         UINT32_C(0x3310fd98),
         UINT32_C(0x69e2a9b6),
         UINT32_C(0x68a741c8),
         UINT32_C(0x325515e6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x404c409a),
         UINT32_C(0x0040115f),
         UINT32_C(0x400c51c5),
         UINT32_C(0x00676079),
         UINT32_C(0x402b20e3),
         UINT32_C(0x00277126),
         UINT32_C(0x406b31bc),
         UINT32_C(0x000eb018),
         UINT32_C(0x4042f082),
         UINT32_C(0x004ea147),
         UINT32_C(0x4002e1dd),
         UINT32_C(0x0069d061),
         UINT32_C(0x402590fb),
         UINT32_C(0x0029c13e),
         UINT32_C(0x406581a4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02620),
         UINT32_C(0x3f802008),
         UINT32_C(0x3fa00628),
         UINT32_C(0x3f8033b0),
         UINT32_C(0x3fa01590),
         UINT32_C(0x3f8013b8),
         UINT32_C(0x3fa03598),
         UINT32_C(0x3f800758),
         UINT32_C(0x3fa02178),
         UINT32_C(0x3f802750),
         UINT32_C(0x3fa00170),
         UINT32_C(0x3f8034e8),
         UINT32_C(0x3fa012c8),
         UINT32_C(0x3f8014e0),
         UINT32_C(0x3fa032c0)},
        UINT32_C(0xfff80000),
        {0x6c,0xbd,0x29,0xe3,0x65,0xd4,0x88,0x90,0x6f,0x21,
         0x6e,0xed,0x6d,0x9a,0xf6,0xfe,0x97,0xbe,0x58,0x4b,0x00}
    },
    {
        /* No.75 delta:885 weight:1253 */
        11213,
        78,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5e39eadc),
         UINT32_C(0xa9b23c93),
         UINT32_C(0xf78bd64f),
         UINT32_C(0xe1e004b7),
         UINT32_C(0xbfd9ee6b),
         UINT32_C(0x48523824),
         UINT32_C(0x166bd2f8),
         UINT32_C(0x00008ac0),
         UINT32_C(0x5e39601c),
         UINT32_C(0xa9b2b653),
         UINT32_C(0xf78b5c8f),
         UINT32_C(0xe1e08e77),
         UINT32_C(0xbfd964ab),
         UINT32_C(0x4852b2e4),
         UINT32_C(0x166b5838)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400301de),
         UINT32_C(0xd000c86d),
         UINT32_C(0x9003c9b3),
         UINT32_C(0x40106097),
         UINT32_C(0x00136149),
         UINT32_C(0x9010a8fa),
         UINT32_C(0xd013a924),
         UINT32_C(0xc0008019),
         UINT32_C(0x800381c7),
         UINT32_C(0x10004874),
         UINT32_C(0x500349aa),
         UINT32_C(0x8010e08e),
         UINT32_C(0xc013e150),
         UINT32_C(0x501028e3),
         UINT32_C(0x1013293d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00180),
         UINT32_C(0x3fe80064),
         UINT32_C(0x3fc801e4),
         UINT32_C(0x3fa00830),
         UINT32_C(0x3f8009b0),
         UINT32_C(0x3fc80854),
         UINT32_C(0x3fe809d4),
         UINT32_C(0x3fe00040),
         UINT32_C(0x3fc001c0),
         UINT32_C(0x3f880024),
         UINT32_C(0x3fa801a4),
         UINT32_C(0x3fc00870),
         UINT32_C(0x3fe009f0),
         UINT32_C(0x3fa80814),
         UINT32_C(0x3f880994)},
        UINT32_C(0xfff80000),
        {0x60,0xba,0x71,0x72,0x3a,0x97,0x88,0x75,0x5e,0x45,
         0xcf,0xe5,0x59,0xa2,0x0c,0xd8,0xdf,0x65,0x87,0x19,0x00}
    },
    {
        /* No.76 delta:2153 weight:1269 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3206c523),
         UINT32_C(0x1c0d4583),
         UINT32_C(0x2e0b80a0),
         UINT32_C(0xec9004cd),
         UINT32_C(0xde96c1ee),
         UINT32_C(0xf09d414e),
         UINT32_C(0xc29b846d),
         UINT32_C(0x0000d57e),
         UINT32_C(0x3206105d),
         UINT32_C(0x1c0d90fd),
         UINT32_C(0x2e0b55de),
         UINT32_C(0xec90d1b3),
         UINT32_C(0xde961490),
         UINT32_C(0xf09d9430),
         UINT32_C(0xc29b5113)},
        {UINT32_C(0x00000000),
         UINT32_C(0x034309f2),
         UINT32_C(0x10040b87),
         UINT32_C(0x13470275),
         UINT32_C(0x0800401e),
         UINT32_C(0x0b4349ec),
         UINT32_C(0x18044b99),
         UINT32_C(0x1b47426b),
         UINT32_C(0x272120ed),
         UINT32_C(0x2462291f),
         UINT32_C(0x37252b6a),
         UINT32_C(0x34662298),
         UINT32_C(0x2f2160f3),
         UINT32_C(0x2c626901),
         UINT32_C(0x3f256b74),
         UINT32_C(0x3c666286)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f81a184),
         UINT32_C(0x3f880205),
         UINT32_C(0x3f89a381),
         UINT32_C(0x3f840020),
         UINT32_C(0x3f85a1a4),
         UINT32_C(0x3f8c0225),
         UINT32_C(0x3f8da3a1),
         UINT32_C(0x3f939090),
         UINT32_C(0x3f923114),
         UINT32_C(0x3f9b9295),
         UINT32_C(0x3f9a3311),
         UINT32_C(0x3f9790b0),
         UINT32_C(0x3f963134),
         UINT32_C(0x3f9f92b5),
         UINT32_C(0x3f9e3331)},
        UINT32_C(0xfff80000),
        {0x77,0xa5,0x9d,0xbd,0xae,0xa2,0xaa,0x67,0xc1,0x01,
         0xdd,0x6f,0x89,0x9b,0xb6,0x7a,0xfd,0x3d,0x4a,0xb0,0x00}
    },
    {
        /* No.77 delta:1132 weight:1669 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x35724a27),
         UINT32_C(0x53a7ed07),
         UINT32_C(0x66d5a720),
         UINT32_C(0xff8004de),
         UINT32_C(0xcaf24ef9),
         UINT32_C(0xac27e9d9),
         UINT32_C(0x9955a3fe),
         UINT32_C(0x0000e9f3),
         UINT32_C(0x3572a3d4),
         UINT32_C(0x53a704f4),
         UINT32_C(0x66d54ed3),
         UINT32_C(0xff80ed2d),
         UINT32_C(0xcaf2a70a),
         UINT32_C(0xac27002a),
         UINT32_C(0x99554a0d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x18371172),
         UINT32_C(0x4000108e),
         UINT32_C(0x583701fc),
         UINT32_C(0x0048f0fa),
         UINT32_C(0x187fe188),
         UINT32_C(0x4048e074),
         UINT32_C(0x587ff106),
         UINT32_C(0x007a08dd),
         UINT32_C(0x184d19af),
         UINT32_C(0x407a1853),
         UINT32_C(0x584d0921),
         UINT32_C(0x0032f827),
         UINT32_C(0x1805e955),
         UINT32_C(0x4032e8a9),
         UINT32_C(0x5805f9db)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8c1b88),
         UINT32_C(0x3fa00008),
         UINT32_C(0x3fac1b80),
         UINT32_C(0x3f802478),
         UINT32_C(0x3f8c3ff0),
         UINT32_C(0x3fa02470),
         UINT32_C(0x3fac3ff8),
         UINT32_C(0x3f803d04),
         UINT32_C(0x3f8c268c),
         UINT32_C(0x3fa03d0c),
         UINT32_C(0x3fac2684),
         UINT32_C(0x3f80197c),
         UINT32_C(0x3f8c02f4),
         UINT32_C(0x3fa01974),
         UINT32_C(0x3fac02fc)},
        UINT32_C(0xfff80000),
        {0x85,0xdd,0xb3,0x21,0x23,0x3b,0x83,0xad,0x64,0x33,
         0x12,0x30,0x80,0xf8,0x38,0xfc,0x83,0x12,0x88,0x20,0x00}
    },
    {
        /* No.78 delta:1199 weight:1651 */
        11213,
        22,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd89eace9),
         UINT32_C(0x2735054e),
         UINT32_C(0xffaba9a7),
         UINT32_C(0xbdd004ea),
         UINT32_C(0x654ea803),
         UINT32_C(0x9ae501a4),
         UINT32_C(0x427bad4d),
         UINT32_C(0x0000497f),
         UINT32_C(0xd89ee596),
         UINT32_C(0x27354c31),
         UINT32_C(0xffabe0d8),
         UINT32_C(0xbdd04d95),
         UINT32_C(0x654ee17c),
         UINT32_C(0x9ae548db),
         UINT32_C(0x427be432)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00390194),
         UINT32_C(0x0078e00b),
         UINT32_C(0x0041e19f),
         UINT32_C(0xd010193a),
         UINT32_C(0xd02918ae),
         UINT32_C(0xd068f931),
         UINT32_C(0xd051f8a5),
         UINT32_C(0x10090419),
         UINT32_C(0x1030058d),
         UINT32_C(0x1071e412),
         UINT32_C(0x1048e586),
         UINT32_C(0xc0191d23),
         UINT32_C(0xc0201cb7),
         UINT32_C(0xc061fd28),
         UINT32_C(0xc058fcbc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801c80),
         UINT32_C(0x3f803c70),
         UINT32_C(0x3f8020f0),
         UINT32_C(0x3fe8080c),
         UINT32_C(0x3fe8148c),
         UINT32_C(0x3fe8347c),
         UINT32_C(0x3fe828fc),
         UINT32_C(0x3f880482),
         UINT32_C(0x3f881802),
         UINT32_C(0x3f8838f2),
         UINT32_C(0x3f882472),
         UINT32_C(0x3fe00c8e),
         UINT32_C(0x3fe0100e),
         UINT32_C(0x3fe030fe),
         UINT32_C(0x3fe02c7e)},
        UINT32_C(0xfff80000),
        {0x08,0xa7,0x35,0x7c,0xcf,0x56,0x3b,0xc3,0x85,0x5b,
         0xc7,0xc0,0x5d,0x90,0x74,0xe6,0xcc,0xb0,0xb1,0xfd,0x00}
    },
    {
        /* No.79 delta:892 weight:1675 */
        11213,
        92,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0434b892),
         UINT32_C(0x79823e0d),
         UINT32_C(0x7db6869f),
         UINT32_C(0xa4e004f5),
         UINT32_C(0xa0d4bc67),
         UINT32_C(0xdd623af8),
         UINT32_C(0xd956826a),
         UINT32_C(0x000060f0),
         UINT32_C(0x0434d862),
         UINT32_C(0x79825efd),
         UINT32_C(0x7db6e66f),
         UINT32_C(0xa4e06405),
         UINT32_C(0xa0d4dc97),
         UINT32_C(0xdd625a08),
         UINT32_C(0xd956e29a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000b801a),
         UINT32_C(0x18405819),
         UINT32_C(0x184bd803),
         UINT32_C(0x00022c07),
         UINT32_C(0x0009ac1d),
         UINT32_C(0x1842741e),
         UINT32_C(0x1849f404),
         UINT32_C(0x400315d5),
         UINT32_C(0x400895cf),
         UINT32_C(0x58434dcc),
         UINT32_C(0x5848cdd6),
         UINT32_C(0x400139d2),
         UINT32_C(0x400ab9c8),
         UINT32_C(0x584161cb),
         UINT32_C(0x584ae1d1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8005c0),
         UINT32_C(0x3f8c202c),
         UINT32_C(0x3f8c25ec),
         UINT32_C(0x3f800116),
         UINT32_C(0x3f8004d6),
         UINT32_C(0x3f8c213a),
         UINT32_C(0x3f8c24fa),
         UINT32_C(0x3fa0018a),
         UINT32_C(0x3fa0044a),
         UINT32_C(0x3fac21a6),
         UINT32_C(0x3fac2466),
         UINT32_C(0x3fa0009c),
         UINT32_C(0x3fa0055c),
         UINT32_C(0x3fac20b0),
         UINT32_C(0x3fac2570)},
        UINT32_C(0xfff80000),
        {0xf2,0x33,0x90,0x14,0xd2,0xa7,0x36,0xf6,0x35,0x60,
         0x0e,0xf6,0x5a,0xdf,0x90,0x11,0xaf,0x95,0x8a,0x3b,0x00}
    },
    {
        /* No.80 delta:1111 weight:1547 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7cf58980),
         UINT32_C(0x9082a4b0),
         UINT32_C(0xec772d30),
         UINT32_C(0x52d0050d),
         UINT32_C(0x2e258c8d),
         UINT32_C(0xc252a1bd),
         UINT32_C(0xbea7283d),
         UINT32_C(0x000017b4),
         UINT32_C(0x7cf59e34),
         UINT32_C(0x9082b304),
         UINT32_C(0xec773a84),
         UINT32_C(0x52d012b9),
         UINT32_C(0x2e259b39),
         UINT32_C(0xc252b609),
         UINT32_C(0xbea73f89)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006810fa),
         UINT32_C(0x00049929),
         UINT32_C(0x006c89d3),
         UINT32_C(0x4002109c),
         UINT32_C(0x406a0066),
         UINT32_C(0x400689b5),
         UINT32_C(0x406e994f),
         UINT32_C(0x40018936),
         UINT32_C(0x406999cc),
         UINT32_C(0x4005101f),
         UINT32_C(0x406d00e5),
         UINT32_C(0x000399aa),
         UINT32_C(0x006b8950),
         UINT32_C(0x00070083),
         UINT32_C(0x006f1079)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803408),
         UINT32_C(0x3f80024c),
         UINT32_C(0x3f803644),
         UINT32_C(0x3fa00108),
         UINT32_C(0x3fa03500),
         UINT32_C(0x3fa00344),
         UINT32_C(0x3fa0374c),
         UINT32_C(0x3fa000c4),
         UINT32_C(0x3fa034cc),
         UINT32_C(0x3fa00288),
         UINT32_C(0x3fa03680),
         UINT32_C(0x3f8001cc),
         UINT32_C(0x3f8035c4),
         UINT32_C(0x3f800380),
         UINT32_C(0x3f803788)},
        UINT32_C(0xfff80000),
        {0x04,0xb7,0x35,0x5a,0x80,0x90,0x46,0x94,0x03,0x85,
         0xfe,0x64,0x9d,0xcc,0x88,0x0d,0xfa,0xef,0xbb,0x76,0x00}
    },
    {
        /* No.81 delta:1067 weight:1455 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6079553d),
         UINT32_C(0xde15d819),
         UINT32_C(0xbe6c8d24),
         UINT32_C(0xe7b0051a),
         UINT32_C(0x87c95027),
         UINT32_C(0x39a5dd03),
         UINT32_C(0x59dc883e),
         UINT32_C(0x0000cde0),
         UINT32_C(0x607998dd),
         UINT32_C(0xde1515f9),
         UINT32_C(0xbe6c40c4),
         UINT32_C(0xe7b0c8fa),
         UINT32_C(0x87c99dc7),
         UINT32_C(0x39a510e3),
         UINT32_C(0x59dc45de)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0014109a),
         UINT32_C(0x60246415),
         UINT32_C(0x6030748f),
         UINT32_C(0x1052207c),
         UINT32_C(0x104630e6),
         UINT32_C(0x70764469),
         UINT32_C(0x706254f3),
         UINT32_C(0x00412001),
         UINT32_C(0x0055309b),
         UINT32_C(0x60654414),
         UINT32_C(0x6071548e),
         UINT32_C(0x1013007d),
         UINT32_C(0x100710e7),
         UINT32_C(0x70376468),
         UINT32_C(0x702374f2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800a08),
         UINT32_C(0x3fb01232),
         UINT32_C(0x3fb0183a),
         UINT32_C(0x3f882910),
         UINT32_C(0x3f882318),
         UINT32_C(0x3fb83b22),
         UINT32_C(0x3fb8312a),
         UINT32_C(0x3f802090),
         UINT32_C(0x3f802a98),
         UINT32_C(0x3fb032a2),
         UINT32_C(0x3fb038aa),
         UINT32_C(0x3f880980),
         UINT32_C(0x3f880388),
         UINT32_C(0x3fb81bb2),
         UINT32_C(0x3fb811ba)},
        UINT32_C(0xfff80000),
        {0xd4,0x7c,0x86,0xf0,0x36,0x3f,0x03,0x44,0x41,0x4f,
         0xa2,0x9f,0x4b,0x03,0x50,0xcc,0xba,0x69,0x39,0x97,0x00}
    },
    {
        /* No.82 delta:811 weight:1339 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xcce813fe),
         UINT32_C(0x2dbec8f0),
         UINT32_C(0xe156db0e),
         UINT32_C(0xc7000522),
         UINT32_C(0x0be816dc),
         UINT32_C(0xeabecdd2),
         UINT32_C(0x2656de2c),
         UINT32_C(0x0000eb42),
         UINT32_C(0xcce8f8bc),
         UINT32_C(0x2dbe23b2),
         UINT32_C(0xe156304c),
         UINT32_C(0xc700ee60),
         UINT32_C(0x0be8fd9e),
         UINT32_C(0xeabe2690),
         UINT32_C(0x2656356e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x07621833),
         UINT32_C(0x0a02c005),
         UINT32_C(0x0d60d836),
         UINT32_C(0x00f080d4),
         UINT32_C(0x079298e7),
         UINT32_C(0x0af240d1),
         UINT32_C(0x0d9058e2),
         UINT32_C(0x0003007b),
         UINT32_C(0x07611848),
         UINT32_C(0x0a01c07e),
         UINT32_C(0x0d63d84d),
         UINT32_C(0x00f380af),
         UINT32_C(0x0791989c),
         UINT32_C(0x0af140aa),
         UINT32_C(0x0d935899)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f83b10c),
         UINT32_C(0x3f850160),
         UINT32_C(0x3f86b06c),
         UINT32_C(0x3f807840),
         UINT32_C(0x3f83c94c),
         UINT32_C(0x3f857920),
         UINT32_C(0x3f86c82c),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f83b08c),
         UINT32_C(0x3f8500e0),
         UINT32_C(0x3f86b1ec),
         UINT32_C(0x3f8079c0),
         UINT32_C(0x3f83c8cc),
         UINT32_C(0x3f8578a0),
         UINT32_C(0x3f86c9ac)},
        UINT32_C(0xfff80000),
        {0x6f,0x0a,0xa8,0x49,0xe5,0x73,0xb3,0x24,0x00,0xaa,
         0xd2,0xbe,0x44,0x6a,0x7b,0x67,0x2f,0xbe,0x5f,0x02,0x00}
    },
    {
        /* No.83 delta:882 weight:1645 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0433906c),
         UINT32_C(0xa3bc9f1a),
         UINT32_C(0xa78f0f76),
         UINT32_C(0x2420053a),
         UINT32_C(0x20139556),
         UINT32_C(0x879c9a20),
         UINT32_C(0x83af0a4c),
         UINT32_C(0x00008edc),
         UINT32_C(0x04331eb0),
         UINT32_C(0xa3bc11c6),
         UINT32_C(0xa78f81aa),
         UINT32_C(0x24208be6),
         UINT32_C(0x20131b8a),
         UINT32_C(0x879c14fc),
         UINT32_C(0x83af8490)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0440301b),
         UINT32_C(0x10000895),
         UINT32_C(0x1440388e),
         UINT32_C(0x84024037),
         UINT32_C(0x8042702c),
         UINT32_C(0x940248a2),
         UINT32_C(0x904278b9),
         UINT32_C(0x4020201a),
         UINT32_C(0x44601001),
         UINT32_C(0x5020288f),
         UINT32_C(0x54601894),
         UINT32_C(0xc422602d),
         UINT32_C(0xc0625036),
         UINT32_C(0xd42268b8),
         UINT32_C(0xd06258a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f822018),
         UINT32_C(0x3f880004),
         UINT32_C(0x3f8a201c),
         UINT32_C(0x3fc20120),
         UINT32_C(0x3fc02138),
         UINT32_C(0x3fca0124),
         UINT32_C(0x3fc8213c),
         UINT32_C(0x3fa01010),
         UINT32_C(0x3fa23008),
         UINT32_C(0x3fa81014),
         UINT32_C(0x3faa300c),
         UINT32_C(0x3fe21130),
         UINT32_C(0x3fe03128),
         UINT32_C(0x3fea1134),
         UINT32_C(0x3fe8312c)},
        UINT32_C(0xfff80000),
        {0x8b,0x04,0x62,0xcc,0x60,0xe5,0x43,0xbf,0x8b,0x19,
         0x87,0x92,0x22,0x34,0x6c,0xb0,0x7b,0x42,0x5f,0x43,0x00}
    },
    {
        /* No.84 delta:830 weight:1133 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbe99f4e9),
         UINT32_C(0xfd60a36e),
         UINT32_C(0x43f95787),
         UINT32_C(0x43e00547),
         UINT32_C(0xfd79f1ae),
         UINT32_C(0xbe80a629),
         UINT32_C(0x001952c0),
         UINT32_C(0x000095ae),
         UINT32_C(0xbe996147),
         UINT32_C(0xfd6036c0),
         UINT32_C(0x43f9c229),
         UINT32_C(0x43e090e9),
         UINT32_C(0xfd796400),
         UINT32_C(0xbe803387),
         UINT32_C(0x0019c76e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x107c111b),
         UINT32_C(0x0041587f),
         UINT32_C(0x103d4964),
         UINT32_C(0x6042c325),
         UINT32_C(0x703ed23e),
         UINT32_C(0x60039b5a),
         UINT32_C(0x707f8a41),
         UINT32_C(0x006029e8),
         UINT32_C(0x101c38f3),
         UINT32_C(0x00217197),
         UINT32_C(0x105d608c),
         UINT32_C(0x6022eacd),
         UINT32_C(0x705efbd6),
         UINT32_C(0x6063b2b2),
         UINT32_C(0x701fa3a9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f883e08),
         UINT32_C(0x3f8020ac),
         UINT32_C(0x3f881ea4),
         UINT32_C(0x3fb02161),
         UINT32_C(0x3fb81f69),
         UINT32_C(0x3fb001cd),
         UINT32_C(0x3fb83fc5),
         UINT32_C(0x3f803014),
         UINT32_C(0x3f880e1c),
         UINT32_C(0x3f8010b8),
         UINT32_C(0x3f882eb0),
         UINT32_C(0x3fb01175),
         UINT32_C(0x3fb82f7d),
         UINT32_C(0x3fb031d9),
         UINT32_C(0x3fb80fd1)},
        UINT32_C(0xfff80000),
        {0x2d,0xfa,0x77,0x28,0x17,0x09,0x3a,0x65,0x8d,0xf8,
         0x6b,0x36,0xcd,0xc2,0xd0,0xbc,0x4b,0xb4,0xd7,0x62,0x00}
    },
    {
        /* No.85 delta:1093 weight:1403 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc523f0a7),
         UINT32_C(0xa559b351),
         UINT32_C(0x607a43f6),
         UINT32_C(0x80c00550),
         UINT32_C(0x45e3f5f7),
         UINT32_C(0x2599b601),
         UINT32_C(0xe0ba46a6),
         UINT32_C(0x0000cfc3),
         UINT32_C(0xc5233f64),
         UINT32_C(0xa5597c92),
         UINT32_C(0x607a8c35),
         UINT32_C(0x80c0ca93),
         UINT32_C(0x45e33a34),
         UINT32_C(0x259979c2),
         UINT32_C(0xe0ba8965)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa040113e),
         UINT32_C(0x006639a3),
         UINT32_C(0xa026289d),
         UINT32_C(0x10440018),
         UINT32_C(0xb0041126),
         UINT32_C(0x102239bb),
         UINT32_C(0xb0622885),
         UINT32_C(0x004014b4),
         UINT32_C(0xa000058a),
         UINT32_C(0x00262d17),
         UINT32_C(0xa0663c29),
         UINT32_C(0x100414ac),
         UINT32_C(0xb0440592),
         UINT32_C(0x10622d0f),
         UINT32_C(0xb0223c31)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd02008),
         UINT32_C(0x3f80331c),
         UINT32_C(0x3fd01314),
         UINT32_C(0x3f882200),
         UINT32_C(0x3fd80208),
         UINT32_C(0x3f88111c),
         UINT32_C(0x3fd83114),
         UINT32_C(0x3f80200a),
         UINT32_C(0x3fd00002),
         UINT32_C(0x3f801316),
         UINT32_C(0x3fd0331e),
         UINT32_C(0x3f88020a),
         UINT32_C(0x3fd82202),
         UINT32_C(0x3f883116),
         UINT32_C(0x3fd8111e)},
        UINT32_C(0xfff80000),
        {0xf8,0x53,0xb6,0xd8,0xc2,0x2e,0xe8,0x92,0x09,0xc8,
         0xe5,0xc2,0x2f,0xaa,0x91,0x62,0x04,0x6f,0xb5,0xb3,0x00}
    },
    {
        /* No.86 delta:828 weight:1503 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf1a04143),
         UINT32_C(0xe2f3966d),
         UINT32_C(0x1353d72e),
         UINT32_C(0xcea0056c),
         UINT32_C(0x3f00442f),
         UINT32_C(0x2c539301),
         UINT32_C(0xddf3d242),
         UINT32_C(0x0000a274),
         UINT32_C(0xf1a0e337),
         UINT32_C(0xe2f33419),
         UINT32_C(0x1353755a),
         UINT32_C(0xcea0a718),
         UINT32_C(0x3f00e65b),
         UINT32_C(0x2c533175),
         UINT32_C(0xddf37036)},
        {UINT32_C(0x00000000),
         UINT32_C(0x30214876),
         UINT32_C(0x00001c0b),
         UINT32_C(0x3021547d),
         UINT32_C(0x200c31d8),
         UINT32_C(0x102d79ae),
         UINT32_C(0x200c2dd3),
         UINT32_C(0x102d65a5),
         UINT32_C(0x100201ff),
         UINT32_C(0x20234989),
         UINT32_C(0x10021df4),
         UINT32_C(0x20235582),
         UINT32_C(0x300e3027),
         UINT32_C(0x002f7851),
         UINT32_C(0x300e2c2c),
         UINT32_C(0x002f645a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9810a4),
         UINT32_C(0x3f80000e),
         UINT32_C(0x3f9810aa),
         UINT32_C(0x3f900618),
         UINT32_C(0x3f8816bc),
         UINT32_C(0x3f900616),
         UINT32_C(0x3f8816b2),
         UINT32_C(0x3f880100),
         UINT32_C(0x3f9011a4),
         UINT32_C(0x3f88010e),
         UINT32_C(0x3f9011aa),
         UINT32_C(0x3f980718),
         UINT32_C(0x3f8017bc),
         UINT32_C(0x3f980716),
         UINT32_C(0x3f8017b2)},
        UINT32_C(0xfff80000),
        {0xc6,0xaf,0x7a,0x2f,0x8a,0x20,0x8f,0x4a,0x23,0x5e,
         0x76,0xae,0x77,0xae,0x14,0xe3,0xda,0x07,0x11,0xc7,0x00}
    },
    {
        /* No.87 delta:607 weight:1543 */
        11213,
        85,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa4b76d7c),
         UINT32_C(0x45c400c4),
         UINT32_C(0xe1736db8),
         UINT32_C(0x0d300578),
         UINT32_C(0xa9876804),
         UINT32_C(0x48f405bc),
         UINT32_C(0xec4368c0),
         UINT32_C(0x0000422b),
         UINT32_C(0xa4b72f57),
         UINT32_C(0x45c442ef),
         UINT32_C(0xe1732f93),
         UINT32_C(0x0d304753),
         UINT32_C(0xa9872a2f),
         UINT32_C(0x48f44797),
         UINT32_C(0xec432aeb)},
        {UINT32_C(0x00000000),
         UINT32_C(0xb8015572),
         UINT32_C(0x5000389b),
         UINT32_C(0xe8016de9),
         UINT32_C(0x00401611),
         UINT32_C(0xb8414363),
         UINT32_C(0x50402e8a),
         UINT32_C(0xe8417bf8),
         UINT32_C(0x30002424),
         UINT32_C(0x88017156),
         UINT32_C(0x60001cbf),
         UINT32_C(0xd80149cd),
         UINT32_C(0x30403235),
         UINT32_C(0x88416747),
         UINT32_C(0x60400aae),
         UINT32_C(0xd8415fdc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fdc00aa),
         UINT32_C(0x3fa8001c),
         UINT32_C(0x3ff400b6),
         UINT32_C(0x3f80200b),
         UINT32_C(0x3fdc20a1),
         UINT32_C(0x3fa82017),
         UINT32_C(0x3ff420bd),
         UINT32_C(0x3f980012),
         UINT32_C(0x3fc400b8),
         UINT32_C(0x3fb0000e),
         UINT32_C(0x3fec00a4),
         UINT32_C(0x3f982019),
         UINT32_C(0x3fc420b3),
         UINT32_C(0x3fb02005),
         UINT32_C(0x3fec20af)},
        UINT32_C(0xfff80000),
        {0x64,0xe3,0xa5,0xfc,0xf9,0x14,0x87,0xba,0xca,0xba,
         0xcd,0xfe,0xb0,0xc6,0x7c,0xfa,0xc2,0xf1,0xfc,0xff,0x00}
    },
    {
        /* No.88 delta:1382 weight:1193 */
        11213,
        50,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd20be97d),
         UINT32_C(0xb3aca4a3),
         UINT32_C(0x61a74dde),
         UINT32_C(0xa690058e),
         UINT32_C(0x749becf3),
         UINT32_C(0x153ca12d),
         UINT32_C(0xc7374850),
         UINT32_C(0x0000b111),
         UINT32_C(0xd20b586c),
         UINT32_C(0xb3ac15b2),
         UINT32_C(0x61a7fccf),
         UINT32_C(0xa690b49f),
         UINT32_C(0x749b5de2),
         UINT32_C(0x153c103c),
         UINT32_C(0xc737f941)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10024a1d),
         UINT32_C(0x30000417),
         UINT32_C(0x20024e0a),
         UINT32_C(0x0040001b),
         UINT32_C(0x10424a06),
         UINT32_C(0x3040040c),
         UINT32_C(0x20424e11),
         UINT32_C(0x2000080f),
         UINT32_C(0x30024212),
         UINT32_C(0x10000c18),
         UINT32_C(0x00024605),
         UINT32_C(0x20400814),
         UINT32_C(0x30424209),
         UINT32_C(0x10400c03),
         UINT32_C(0x0042461e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880125),
         UINT32_C(0x3f980002),
         UINT32_C(0x3f900127),
         UINT32_C(0x3f802000),
         UINT32_C(0x3f882125),
         UINT32_C(0x3f982002),
         UINT32_C(0x3f902127),
         UINT32_C(0x3f900004),
         UINT32_C(0x3f980121),
         UINT32_C(0x3f880006),
         UINT32_C(0x3f800123),
         UINT32_C(0x3f902004),
         UINT32_C(0x3f982121),
         UINT32_C(0x3f882006),
         UINT32_C(0x3f802123)},
        UINT32_C(0xfff80000),
        {0xed,0xf6,0x52,0x4a,0x5a,0x45,0xb6,0xb6,0xfa,0xcf,
         0x99,0x71,0xde,0x31,0xe2,0x46,0xc7,0x6b,0x19,0x13,0x00}
    },
    {
        /* No.89 delta:1180 weight:1491 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2de6b803),
         UINT32_C(0x8b7e4ab5),
         UINT32_C(0xa698f2b6),
         UINT32_C(0x2ff00595),
         UINT32_C(0x0216bd96),
         UINT32_C(0xa48e4f20),
         UINT32_C(0x8968f723),
         UINT32_C(0x00004dc6),
         UINT32_C(0x2de6f5c5),
         UINT32_C(0x8b7e0773),
         UINT32_C(0xa698bf70),
         UINT32_C(0x2ff04853),
         UINT32_C(0x0216f050),
         UINT32_C(0xa48e02e6),
         UINT32_C(0x8968bae5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0016287a),
         UINT32_C(0x005e21b9),
         UINT32_C(0x004809c3),
         UINT32_C(0x10390011),
         UINT32_C(0x102f286b),
         UINT32_C(0x106721a8),
         UINT32_C(0x107109d2),
         UINT32_C(0x4020fa8f),
         UINT32_C(0x4036d2f5),
         UINT32_C(0x407edb36),
         UINT32_C(0x4068f34c),
         UINT32_C(0x5019fa9e),
         UINT32_C(0x500fd2e4),
         UINT32_C(0x5047db27),
         UINT32_C(0x5051f35d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800b14),
         UINT32_C(0x3f802f10),
         UINT32_C(0x3f802404),
         UINT32_C(0x3f881c80),
         UINT32_C(0x3f881794),
         UINT32_C(0x3f883390),
         UINT32_C(0x3f883884),
         UINT32_C(0x3fa0107d),
         UINT32_C(0x3fa01b69),
         UINT32_C(0x3fa03f6d),
         UINT32_C(0x3fa03479),
         UINT32_C(0x3fa80cfd),
         UINT32_C(0x3fa807e9),
         UINT32_C(0x3fa823ed),
         UINT32_C(0x3fa828f9)},
        UINT32_C(0xfff80000),
        {0x26,0xf5,0x2a,0xf0,0x1f,0x39,0x50,0x05,0xe0,0x65,
         0xe0,0xb7,0xc1,0x91,0xba,0xbe,0x20,0x11,0x69,0x66,0x00}
    },
    {
        /* No.90 delta:895 weight:1613 */
        11213,
        47,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbbe1a4c8),
         UINT32_C(0x719d09e5),
         UINT32_C(0xca7cad2d),
         UINT32_C(0x189005a8),
         UINT32_C(0xa371a160),
         UINT32_C(0x690d0c4d),
         UINT32_C(0xd2eca885),
         UINT32_C(0x00007129),
         UINT32_C(0xbbe1d5e1),
         UINT32_C(0x719d78cc),
         UINT32_C(0xca7cdc04),
         UINT32_C(0x18907481),
         UINT32_C(0xa371d049),
         UINT32_C(0x690d7d64),
         UINT32_C(0xd2ecd9ac)},
        {UINT32_C(0x00000000),
         UINT32_C(0x403ac91e),
         UINT32_C(0x501d2402),
         UINT32_C(0x1027ed1c),
         UINT32_C(0x0003f418),
         UINT32_C(0x40393d06),
         UINT32_C(0x501ed01a),
         UINT32_C(0x10241904),
         UINT32_C(0x0021118e),
         UINT32_C(0x401bd890),
         UINT32_C(0x503c358c),
         UINT32_C(0x1006fc92),
         UINT32_C(0x0022e596),
         UINT32_C(0x40182c88),
         UINT32_C(0x503fc194),
         UINT32_C(0x1005088a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa01d64),
         UINT32_C(0x3fa80e92),
         UINT32_C(0x3f8813f6),
         UINT32_C(0x3f8001fa),
         UINT32_C(0x3fa01c9e),
         UINT32_C(0x3fa80f68),
         UINT32_C(0x3f88120c),
         UINT32_C(0x3f801088),
         UINT32_C(0x3fa00dec),
         UINT32_C(0x3fa81e1a),
         UINT32_C(0x3f88037e),
         UINT32_C(0x3f801172),
         UINT32_C(0x3fa00c16),
         UINT32_C(0x3fa81fe0),
         UINT32_C(0x3f880284)},
        UINT32_C(0xfff80000),
        {0x52,0x4a,0x20,0x7e,0x06,0x76,0xc3,0x1a,0x7c,0x32,
         0x80,0x84,0x2a,0xe2,0x61,0xa1,0x40,0x18,0xf9,0xdf,0x00}
    },
    {
        /* No.91 delta:780 weight:1635 */
        11213,
        63,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x03cba17f),
         UINT32_C(0x54ce7bbd),
         UINT32_C(0x5705dac2),
         UINT32_C(0xb42005b7),
         UINT32_C(0xb7eba4c8),
         UINT32_C(0xe0ee7e0a),
         UINT32_C(0xe325df75),
         UINT32_C(0x0000327f),
         UINT32_C(0x03cb9300),
         UINT32_C(0x54ce49c2),
         UINT32_C(0x5705e8bd),
         UINT32_C(0xb42037c8),
         UINT32_C(0xb7eb96b7),
         UINT32_C(0xe0ee4c75),
         UINT32_C(0xe325ed0a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3403405a),
         UINT32_C(0x1000c111),
         UINT32_C(0x2403814b),
         UINT32_C(0x0000d014),
         UINT32_C(0x3403904e),
         UINT32_C(0x10001105),
         UINT32_C(0x2403515f),
         UINT32_C(0x04000408),
         UINT32_C(0x30034452),
         UINT32_C(0x1400c519),
         UINT32_C(0x20038543),
         UINT32_C(0x0400d41c),
         UINT32_C(0x30039446),
         UINT32_C(0x1400150d),
         UINT32_C(0x20035557)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9a01a0),
         UINT32_C(0x3f880060),
         UINT32_C(0x3f9201c0),
         UINT32_C(0x3f800068),
         UINT32_C(0x3f9a01c8),
         UINT32_C(0x3f880008),
         UINT32_C(0x3f9201a8),
         UINT32_C(0x3f820002),
         UINT32_C(0x3f9801a2),
         UINT32_C(0x3f8a0062),
         UINT32_C(0x3f9001c2),
         UINT32_C(0x3f82006a),
         UINT32_C(0x3f9801ca),
         UINT32_C(0x3f8a000a),
         UINT32_C(0x3f9001aa)},
        UINT32_C(0xfff80000),
        {0xed,0x70,0xe5,0x8e,0x42,0xde,0x26,0x57,0xe7,0x69,
         0xad,0xce,0x2b,0xdb,0x32,0x6d,0xe3,0x81,0xa5,0xcb,0x00}
    },
    {
        /* No.92 delta:723 weight:1653 */
        11213,
        66,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8e16d78b),
         UINT32_C(0x6475cd40),
         UINT32_C(0xea631acb),
         UINT32_C(0xef6005c1),
         UINT32_C(0x6176d24a),
         UINT32_C(0x8b15c881),
         UINT32_C(0x05031f0a),
         UINT32_C(0x0000c64c),
         UINT32_C(0x8e1611c7),
         UINT32_C(0x64750b0c),
         UINT32_C(0xea63dc87),
         UINT32_C(0xef60c38d),
         UINT32_C(0x61761406),
         UINT32_C(0x8b150ecd),
         UINT32_C(0x0503d946)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0006157d),
         UINT32_C(0x3008494f),
         UINT32_C(0x300e5c32),
         UINT32_C(0x000281c6),
         UINT32_C(0x000494bb),
         UINT32_C(0x300ac889),
         UINT32_C(0x300cddf4),
         UINT32_C(0x40008459),
         UINT32_C(0x40069124),
         UINT32_C(0x7008cd16),
         UINT32_C(0x700ed86b),
         UINT32_C(0x4002059f),
         UINT32_C(0x400410e2),
         UINT32_C(0x700a4cd0),
         UINT32_C(0x700c59ad)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80030a),
         UINT32_C(0x3f980424),
         UINT32_C(0x3f98072e),
         UINT32_C(0x3f800140),
         UINT32_C(0x3f80024a),
         UINT32_C(0x3f980564),
         UINT32_C(0x3f98066e),
         UINT32_C(0x3fa00042),
         UINT32_C(0x3fa00348),
         UINT32_C(0x3fb80466),
         UINT32_C(0x3fb8076c),
         UINT32_C(0x3fa00102),
         UINT32_C(0x3fa00208),
         UINT32_C(0x3fb80526),
         UINT32_C(0x3fb8062c)},
        UINT32_C(0xfff80000),
        {0xc2,0x1f,0xf1,0xdf,0x5c,0xfe,0x71,0xcc,0x49,0x9f,
         0x31,0x60,0x70,0x60,0xf6,0x07,0xfe,0xac,0xe8,0x47,0x00}
    },
    {
        /* No.93 delta:575 weight:1639 */
        11213,
        80,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3d168a5a),
         UINT32_C(0xef7b6b30),
         UINT32_C(0xd26de16a),
         UINT32_C(0xeda005d7),
         UINT32_C(0xd0b68f8d),
         UINT32_C(0x02db6ee7),
         UINT32_C(0x3fcde4bd),
         UINT32_C(0x00005226),
         UINT32_C(0x3d16d87c),
         UINT32_C(0xef7b3916),
         UINT32_C(0xd26db34c),
         UINT32_C(0xeda057f1),
         UINT32_C(0xd0b6ddab),
         UINT32_C(0x02db3cc1),
         UINT32_C(0x3fcdb69b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4003c13a),
         UINT32_C(0x10004815),
         UINT32_C(0x5003892f),
         UINT32_C(0x4020101c),
         UINT32_C(0x0023d126),
         UINT32_C(0x50205809),
         UINT32_C(0x10239933),
         UINT32_C(0x60002c17),
         UINT32_C(0x2003ed2d),
         UINT32_C(0x70006402),
         UINT32_C(0x3003a538),
         UINT32_C(0x20203c0b),
         UINT32_C(0x6023fd31),
         UINT32_C(0x3020741e),
         UINT32_C(0x7023b524)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa001e0),
         UINT32_C(0x3f880024),
         UINT32_C(0x3fa801c4),
         UINT32_C(0x3fa01008),
         UINT32_C(0x3f8011e8),
         UINT32_C(0x3fa8102c),
         UINT32_C(0x3f8811cc),
         UINT32_C(0x3fb00016),
         UINT32_C(0x3f9001f6),
         UINT32_C(0x3fb80032),
         UINT32_C(0x3f9801d2),
         UINT32_C(0x3f90101e),
         UINT32_C(0x3fb011fe),
         UINT32_C(0x3f98103a),
         UINT32_C(0x3fb811da)},
        UINT32_C(0xfff80000),
        {0x0f,0xe1,0x48,0x51,0x21,0xf0,0x2d,0xc4,0x7c,0xec,
         0x9f,0x73,0x68,0x9d,0x0b,0xdf,0x77,0x24,0xcb,0x77,0x00}
    },
    {
        /* No.94 delta:1168 weight:1445 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x100553e0),
         UINT32_C(0x60a5e657),
         UINT32_C(0x70a0b5b7),
         UINT32_C(0x188005ee),
         UINT32_C(0x0885560e),
         UINT32_C(0x7825e3b9),
         UINT32_C(0x6820b059),
         UINT32_C(0x000077ef),
         UINT32_C(0x1005240f),
         UINT32_C(0x60a591b8),
         UINT32_C(0x70a0c258),
         UINT32_C(0x18807201),
         UINT32_C(0x088521e1),
         UINT32_C(0x78259456),
         UINT32_C(0x6820c7b6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20040036),
         UINT32_C(0x00428925),
         UINT32_C(0x20468913),
         UINT32_C(0x2043401f),
         UINT32_C(0x00474029),
         UINT32_C(0x2001c93a),
         UINT32_C(0x0005c90c),
         UINT32_C(0x604848e4),
         UINT32_C(0x404c48d2),
         UINT32_C(0x600ac1c1),
         UINT32_C(0x400ec1f7),
         UINT32_C(0x400b08fb),
         UINT32_C(0x600f08cd),
         UINT32_C(0x404981de),
         UINT32_C(0x604d81e8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900200),
         UINT32_C(0x3f802144),
         UINT32_C(0x3f902344),
         UINT32_C(0x3f9021a0),
         UINT32_C(0x3f8023a0),
         UINT32_C(0x3f9000e4),
         UINT32_C(0x3f8002e4),
         UINT32_C(0x3fb02424),
         UINT32_C(0x3fa02624),
         UINT32_C(0x3fb00560),
         UINT32_C(0x3fa00760),
         UINT32_C(0x3fa00584),
         UINT32_C(0x3fb00784),
         UINT32_C(0x3fa024c0),
         UINT32_C(0x3fb026c0)},
        UINT32_C(0xfff80000),
        {0xaa,0x81,0xeb,0x85,0xab,0x03,0xbb,0x80,0x2e,0x38,
         0x36,0x94,0xb2,0x7b,0xd5,0x39,0x3f,0x8f,0x44,0x22,0x00}
    },
    {
        /* No.95 delta:874 weight:1655 */
        11213,
        49,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa9f511af),
         UINT32_C(0xe424f2f4),
         UINT32_C(0x4dd1e35b),
         UINT32_C(0x17c005f3),
         UINT32_C(0xbe35145c),
         UINT32_C(0xf3e4f707),
         UINT32_C(0x5a11e6a8),
         UINT32_C(0x00000d8b),
         UINT32_C(0xa9f51c24),
         UINT32_C(0xe424ff7f),
         UINT32_C(0x4dd1eed0),
         UINT32_C(0x17c00878),
         UINT32_C(0xbe3519d7),
         UINT32_C(0xf3e4fa8c),
         UINT32_C(0x5a11eb23)},
        {UINT32_C(0x00000000),
         UINT32_C(0x908240ba),
         UINT32_C(0x00030d87),
         UINT32_C(0x90814d3d),
         UINT32_C(0x1080101f),
         UINT32_C(0x800250a5),
         UINT32_C(0x10831d98),
         UINT32_C(0x80015d22),
         UINT32_C(0x3012920e),
         UINT32_C(0xa090d2b4),
         UINT32_C(0x30119f89),
         UINT32_C(0xa093df33),
         UINT32_C(0x20928211),
         UINT32_C(0xb010c2ab),
         UINT32_C(0x20918f96),
         UINT32_C(0xb013cf2c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc84120),
         UINT32_C(0x3f800186),
         UINT32_C(0x3fc840a6),
         UINT32_C(0x3f884008),
         UINT32_C(0x3fc00128),
         UINT32_C(0x3f88418e),
         UINT32_C(0x3fc000ae),
         UINT32_C(0x3f980949),
         UINT32_C(0x3fd04869),
         UINT32_C(0x3f9808cf),
         UINT32_C(0x3fd049ef),
         UINT32_C(0x3f904941),
         UINT32_C(0x3fd80861),
         UINT32_C(0x3f9048c7),
         UINT32_C(0x3fd809e7)},
        UINT32_C(0xfff80000),
        {0xa0,0xed,0x8a,0xea,0x95,0xb5,0x41,0xea,0xbb,0xc9,
         0x2a,0x0a,0x89,0x15,0x5b,0x68,0x5b,0xb0,0x11,0x6d,0x00}
    },
    {
        /* No.96 delta:861 weight:1191 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x77c881e2),
         UINT32_C(0xe42dd114),
         UINT32_C(0x93e550f6),
         UINT32_C(0x8be00606),
         UINT32_C(0xfc2887e4),
         UINT32_C(0x6fcdd712),
         UINT32_C(0x180556f0),
         UINT32_C(0x00008be7),
         UINT32_C(0x77c80a05),
         UINT32_C(0xe42d5af3),
         UINT32_C(0x93e5db11),
         UINT32_C(0x8be08de1),
         UINT32_C(0xfc280c03),
         UINT32_C(0x6fcd5cf5),
         UINT32_C(0x1805dd17)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0077459e),
         UINT32_C(0x4008115b),
         UINT32_C(0x407f54c5),
         UINT32_C(0x500201cd),
         UINT32_C(0x50754453),
         UINT32_C(0x100a1096),
         UINT32_C(0x107d5508),
         UINT32_C(0x000a00c7),
         UINT32_C(0x007d4559),
         UINT32_C(0x4002119c),
         UINT32_C(0x40755402),
         UINT32_C(0x5008010a),
         UINT32_C(0x507f4494),
         UINT32_C(0x10001051),
         UINT32_C(0x107755cf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803ba2),
         UINT32_C(0x3fa00408),
         UINT32_C(0x3fa03faa),
         UINT32_C(0x3fa80100),
         UINT32_C(0x3fa83aa2),
         UINT32_C(0x3f880508),
         UINT32_C(0x3f883eaa),
         UINT32_C(0x3f800500),
         UINT32_C(0x3f803ea2),
         UINT32_C(0x3fa00108),
         UINT32_C(0x3fa03aaa),
         UINT32_C(0x3fa80400),
         UINT32_C(0x3fa83fa2),
         UINT32_C(0x3f880008),
         UINT32_C(0x3f883baa)},
        UINT32_C(0xfff80000),
        {0x33,0x7e,0x21,0x5c,0x53,0x94,0xc7,0x17,0x10,0x34,
         0x52,0x6f,0x67,0x0e,0x45,0x13,0xbf,0xca,0x19,0xe8,0x00}
    },
    {
        /* No.97 delta:2676 weight:853 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbd6a2668),
         UINT32_C(0xcc9d55b7),
         UINT32_C(0x71f773df),
         UINT32_C(0x3110061c),
         UINT32_C(0x8c7a2074),
         UINT32_C(0xfd8d53ab),
         UINT32_C(0x40e775c3),
         UINT32_C(0x00008fa3),
         UINT32_C(0xbd6aa9cb),
         UINT32_C(0xcc9dda14),
         UINT32_C(0x71f7fc7c),
         UINT32_C(0x311089bf),
         UINT32_C(0x8c7aafd7),
         UINT32_C(0xfd8ddc08),
         UINT32_C(0x40e7fa60)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8e8000fa),
         UINT32_C(0x4181077f),
         UINT32_C(0xcf010785),
         UINT32_C(0x0c81e018),
         UINT32_C(0x8201e0e2),
         UINT32_C(0x4d00e767),
         UINT32_C(0xc380e79d),
         UINT32_C(0x02806af4),
         UINT32_C(0x8c006a0e),
         UINT32_C(0x43016d8b),
         UINT32_C(0xcd816d71),
         UINT32_C(0x0e018aec),
         UINT32_C(0x80818a16),
         UINT32_C(0x4f808d93),
         UINT32_C(0xc1008d69)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc74000),
         UINT32_C(0x3fa0c083),
         UINT32_C(0x3fe78083),
         UINT32_C(0x3f8640f0),
         UINT32_C(0x3fc100f0),
         UINT32_C(0x3fa68073),
         UINT32_C(0x3fe1c073),
         UINT32_C(0x3f814035),
         UINT32_C(0x3fc60035),
         UINT32_C(0x3fa180b6),
         UINT32_C(0x3fe6c0b6),
         UINT32_C(0x3f8700c5),
         UINT32_C(0x3fc040c5),
         UINT32_C(0x3fa7c046),
         UINT32_C(0x3fe08046)},
        UINT32_C(0xfff80000),
        {0x38,0x47,0x11,0xb2,0x01,0x45,0xb4,0xc5,0x3c,0xee,
         0x80,0x03,0x22,0xf6,0xc5,0x68,0x67,0x28,0xe1,0xf0,0x00}
    },
    {
        /* No.98 delta:827 weight:1491 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0915d02d),
         UINT32_C(0x72064141),
         UINT32_C(0x7b13916c),
         UINT32_C(0x2840062e),
         UINT32_C(0x2155d603),
         UINT32_C(0x5a46476f),
         UINT32_C(0x53539742),
         UINT32_C(0x0000b9fc),
         UINT32_C(0x091569d1),
         UINT32_C(0x7206f8bd),
         UINT32_C(0x7b132890),
         UINT32_C(0x2840bfd2),
         UINT32_C(0x21556fff),
         UINT32_C(0x5a46fe93),
         UINT32_C(0x53532ebe)},
        {UINT32_C(0x00000000),
         UINT32_C(0x083d1115),
         UINT32_C(0x0002041c),
         UINT32_C(0x083f1509),
         UINT32_C(0x0001ae5b),
         UINT32_C(0x083cbf4e),
         UINT32_C(0x0003aa47),
         UINT32_C(0x083ebb52),
         UINT32_C(0x2004c174),
         UINT32_C(0x2839d061),
         UINT32_C(0x2006c568),
         UINT32_C(0x283bd47d),
         UINT32_C(0x20056f2f),
         UINT32_C(0x28387e3a),
         UINT32_C(0x20076b33),
         UINT32_C(0x283a7a26)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841e88),
         UINT32_C(0x3f800102),
         UINT32_C(0x3f841f8a),
         UINT32_C(0x3f8000d7),
         UINT32_C(0x3f841e5f),
         UINT32_C(0x3f8001d5),
         UINT32_C(0x3f841f5d),
         UINT32_C(0x3f900260),
         UINT32_C(0x3f941ce8),
         UINT32_C(0x3f900362),
         UINT32_C(0x3f941dea),
         UINT32_C(0x3f9002b7),
         UINT32_C(0x3f941c3f),
         UINT32_C(0x3f9003b5),
         UINT32_C(0x3f941d3d)},
        UINT32_C(0xfff80000),
        {0xca,0x80,0x3a,0x23,0x9d,0x6c,0x94,0x61,0x87,0xfb,
         0xb8,0xf2,0xda,0xec,0x64,0x91,0x28,0x87,0x26,0xd6,0x00}
    },
    {
        /* No.99 delta:708 weight:1311 */
        11213,
        64,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xce20c03e),
         UINT32_C(0x994236e0),
         UINT32_C(0x5762f6de),
         UINT32_C(0xc9300632),
         UINT32_C(0x0710c60c),
         UINT32_C(0x507230d2),
         UINT32_C(0x9e52f0ec),
         UINT32_C(0x0000a7af),
         UINT32_C(0xce206791),
         UINT32_C(0x9942914f),
         UINT32_C(0x57625171),
         UINT32_C(0xc930a19d),
         UINT32_C(0x071061a3),
         UINT32_C(0x5072977d),
         UINT32_C(0x9e525743)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4101741e),
         UINT32_C(0x8020818b),
         UINT32_C(0xc121f595),
         UINT32_C(0x40033011),
         UINT32_C(0x0102440f),
         UINT32_C(0xc023b19a),
         UINT32_C(0x8122c584),
         UINT32_C(0x000101fc),
         UINT32_C(0x410075e2),
         UINT32_C(0x80218077),
         UINT32_C(0xc120f469),
         UINT32_C(0x400231ed),
         UINT32_C(0x010345f3),
         UINT32_C(0xc022b066),
         UINT32_C(0x8123c478)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa080ba),
         UINT32_C(0x3fc01040),
         UINT32_C(0x3fe090fa),
         UINT32_C(0x3fa00198),
         UINT32_C(0x3f808122),
         UINT32_C(0x3fe011d8),
         UINT32_C(0x3fc09162),
         UINT32_C(0x3f800080),
         UINT32_C(0x3fa0803a),
         UINT32_C(0x3fc010c0),
         UINT32_C(0x3fe0907a),
         UINT32_C(0x3fa00118),
         UINT32_C(0x3f8081a2),
         UINT32_C(0x3fe01158),
         UINT32_C(0x3fc091e2)},
        UINT32_C(0xfff80000),
        {0xdf,0xbf,0x75,0x14,0x07,0x6a,0xc5,0x64,0x4f,0xc6,
         0xe3,0x60,0x4e,0x50,0xe0,0xa1,0x15,0x2e,0x91,0x98,0x00}
    },
    {
        /* No.100 delta:1786 weight:1467 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x981c6d4d),
         UINT32_C(0xc6e26a11),
         UINT32_C(0x5efe075c),
         UINT32_C(0xddc00649),
         UINT32_C(0x45dc6b04),
         UINT32_C(0x1b226c58),
         UINT32_C(0x833e0115),
         UINT32_C(0x0000ca50),
         UINT32_C(0x981ca71d),
         UINT32_C(0xc6e2a041),
         UINT32_C(0x5efecd0c),
         UINT32_C(0xddc0cc19),
         UINT32_C(0x45dca154),
         UINT32_C(0x1b22a608),
         UINT32_C(0x833ecb45)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20c503f2),
         UINT32_C(0x005801d7),
         UINT32_C(0x209d0225),
         UINT32_C(0x006c0011),
         UINT32_C(0x20a903e3),
         UINT32_C(0x003401c6),
         UINT32_C(0x20f10234),
         UINT32_C(0x000500a9),
         UINT32_C(0x20c0035b),
         UINT32_C(0x005d017e),
         UINT32_C(0x2098028c),
         UINT32_C(0x006900b8),
         UINT32_C(0x20ac034a),
         UINT32_C(0x0031016f),
         UINT32_C(0x20f4029d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f906281),
         UINT32_C(0x3f802c00),
         UINT32_C(0x3f904e81),
         UINT32_C(0x3f803600),
         UINT32_C(0x3f905481),
         UINT32_C(0x3f801a00),
         UINT32_C(0x3f907881),
         UINT32_C(0x3f800280),
         UINT32_C(0x3f906001),
         UINT32_C(0x3f802e80),
         UINT32_C(0x3f904c01),
         UINT32_C(0x3f803480),
         UINT32_C(0x3f905601),
         UINT32_C(0x3f801880),
         UINT32_C(0x3f907a01)},
        UINT32_C(0xfff80000),
        {0x6c,0x2a,0xd8,0xe1,0xb3,0x20,0xd0,0xd8,0xb2,0x06,
         0x11,0x6f,0xd5,0x68,0xed,0xd8,0xf6,0xd8,0x6a,0x7f,0x00}
    },
    {
        /* No.101 delta:615 weight:1671 */
        11213,
        84,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2fc3606f),
         UINT32_C(0x866cdf27),
         UINT32_C(0xa9afbf48),
         UINT32_C(0x5a500657),
         UINT32_C(0x75936638),
         UINT32_C(0xdc3cd970),
         UINT32_C(0xf3ffb91f),
         UINT32_C(0x000086e4),
         UINT32_C(0x2fc3e68b),
         UINT32_C(0x866c59c3),
         UINT32_C(0xa9af39ac),
         UINT32_C(0x5a5080b3),
         UINT32_C(0x7593e0dc),
         UINT32_C(0xdc3c5f94),
         UINT32_C(0xf3ff3ffb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0003c9f5),
         UINT32_C(0x503ca9b1),
         UINT32_C(0x503f6044),
         UINT32_C(0x0040501e),
         UINT32_C(0x004399eb),
         UINT32_C(0x507cf9af),
         UINT32_C(0x507f305a),
         UINT32_C(0x10101326),
         UINT32_C(0x1013dad3),
         UINT32_C(0x402cba97),
         UINT32_C(0x402f7362),
         UINT32_C(0x10504338),
         UINT32_C(0x10538acd),
         UINT32_C(0x406cea89),
         UINT32_C(0x406f237c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8001e4),
         UINT32_C(0x3fa81e54),
         UINT32_C(0x3fa81fb0),
         UINT32_C(0x3f802028),
         UINT32_C(0x3f8021cc),
         UINT32_C(0x3fa83e7c),
         UINT32_C(0x3fa83f98),
         UINT32_C(0x3f880809),
         UINT32_C(0x3f8809ed),
         UINT32_C(0x3fa0165d),
         UINT32_C(0x3fa017b9),
         UINT32_C(0x3f882821),
         UINT32_C(0x3f8829c5),
         UINT32_C(0x3fa03675),
         UINT32_C(0x3fa03791)},
        UINT32_C(0xfff80000),
        {0x09,0xb2,0xd9,0x88,0x39,0x98,0x64,0xbb,0x2b,0x23,
         0x3f,0x58,0xc9,0x59,0xb2,0x4f,0xbf,0xa5,0x49,0x32,0x00}
    },
    {
        /* No.102 delta:1133 weight:1553 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3b16c68a),
         UINT32_C(0x56b5b9f3),
         UINT32_C(0x6da37f79),
         UINT32_C(0xdde00663),
         UINT32_C(0xe6f6c0e9),
         UINT32_C(0x8b55bf90),
         UINT32_C(0xb043791a),
         UINT32_C(0x0000b22c),
         UINT32_C(0x3b1674a6),
         UINT32_C(0x56b50bdf),
         UINT32_C(0x6da3cd55),
         UINT32_C(0xdde0b44f),
         UINT32_C(0xe6f672c5),
         UINT32_C(0x8b550dbc),
         UINT32_C(0xb043cb36)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0050209e),
         UINT32_C(0x20042152),
         UINT32_C(0x205401cc),
         UINT32_C(0x512001e5),
         UINT32_C(0x5170217b),
         UINT32_C(0x712420b7),
         UINT32_C(0x71740029),
         UINT32_C(0x8008080f),
         UINT32_C(0x80582891),
         UINT32_C(0xa00c295d),
         UINT32_C(0xa05c09c3),
         UINT32_C(0xd12809ea),
         UINT32_C(0xd1782974),
         UINT32_C(0xf12c28b8),
         UINT32_C(0xf17c0826)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802810),
         UINT32_C(0x3f900210),
         UINT32_C(0x3f902a00),
         UINT32_C(0x3fa89000),
         UINT32_C(0x3fa8b810),
         UINT32_C(0x3fb89210),
         UINT32_C(0x3fb8ba00),
         UINT32_C(0x3fc00404),
         UINT32_C(0x3fc02c14),
         UINT32_C(0x3fd00614),
         UINT32_C(0x3fd02e04),
         UINT32_C(0x3fe89404),
         UINT32_C(0x3fe8bc14),
         UINT32_C(0x3ff89614),
         UINT32_C(0x3ff8be04)},
        UINT32_C(0xfff80000),
        {0x3b,0x5d,0x87,0x3e,0x94,0x58,0x84,0xcc,0x7e,0x4e,
         0xde,0xc6,0x0c,0x67,0x79,0xfc,0x9f,0x6d,0x46,0xbd,0x00}
    },
    {
        /* No.103 delta:811 weight:1325 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd5a39580),
         UINT32_C(0x4e8f650d),
         UINT32_C(0x9b2cf08d),
         UINT32_C(0x0970067f),
         UINT32_C(0xdcd393ff),
         UINT32_C(0x47ff6372),
         UINT32_C(0x925cf6f2),
         UINT32_C(0x0000763a),
         UINT32_C(0xd5a3e3ba),
         UINT32_C(0x4e8f1337),
         UINT32_C(0x9b2c86b7),
         UINT32_C(0x09707045),
         UINT32_C(0xdcd3e5c5),
         UINT32_C(0x47ff1548),
         UINT32_C(0x925c80c8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x45650a5f),
         UINT32_C(0x007910dc),
         UINT32_C(0x451c1a83),
         UINT32_C(0x00051015),
         UINT32_C(0x45601a4a),
         UINT32_C(0x007c00c9),
         UINT32_C(0x45190a96),
         UINT32_C(0x5a046011),
         UINT32_C(0x1f616a4e),
         UINT32_C(0x5a7d70cd),
         UINT32_C(0x1f187a92),
         UINT32_C(0x5a017004),
         UINT32_C(0x1f647a5b),
         UINT32_C(0x5a7860d8),
         UINT32_C(0x1f1d6a87)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa2b285),
         UINT32_C(0x3f803c88),
         UINT32_C(0x3fa28e0d),
         UINT32_C(0x3f800288),
         UINT32_C(0x3fa2b00d),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3fa28c85),
         UINT32_C(0x3fad0230),
         UINT32_C(0x3f8fb0b5),
         UINT32_C(0x3fad3eb8),
         UINT32_C(0x3f8f8c3d),
         UINT32_C(0x3fad00b8),
         UINT32_C(0x3f8fb23d),
         UINT32_C(0x3fad3c30),
         UINT32_C(0x3f8f8eb5)},
        UINT32_C(0xfff80000),
        {0x6f,0x58,0x8b,0x82,0xd5,0x56,0xd7,0xf2,0x15,0xea,
         0x59,0xc4,0x57,0xcc,0xfd,0x6c,0x15,0xb2,0xb8,0xe6,0x00}
    },
    {
        /* No.104 delta:909 weight:1351 */
        11213,
        60,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9e28fdaf),
         UINT32_C(0xa1b52cd6),
         UINT32_C(0x3f9dd179),
         UINT32_C(0xb720068d),
         UINT32_C(0x2908fb22),
         UINT32_C(0x16952a5b),
         UINT32_C(0x88bdd7f4),
         UINT32_C(0x0000f73d),
         UINT32_C(0x9e280a92),
         UINT32_C(0xa1b5dbeb),
         UINT32_C(0x3f9d2644),
         UINT32_C(0xb720f1b0),
         UINT32_C(0x29080c1f),
         UINT32_C(0x1695dd66),
         UINT32_C(0x88bd20c9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00a718d2),
         UINT32_C(0x40620151),
         UINT32_C(0x40c51983),
         UINT32_C(0x04400086),
         UINT32_C(0x04e71854),
         UINT32_C(0x442201d7),
         UINT32_C(0x44851905),
         UINT32_C(0x21098019),
         UINT32_C(0x21ae98cb),
         UINT32_C(0x616b8148),
         UINT32_C(0x61cc999a),
         UINT32_C(0x2549809f),
         UINT32_C(0x25ee984d),
         UINT32_C(0x652b81ce),
         UINT32_C(0x658c991c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80538c),
         UINT32_C(0x3fa03100),
         UINT32_C(0x3fa0628c),
         UINT32_C(0x3f822000),
         UINT32_C(0x3f82738c),
         UINT32_C(0x3fa21100),
         UINT32_C(0x3fa2428c),
         UINT32_C(0x3f9084c0),
         UINT32_C(0x3f90d74c),
         UINT32_C(0x3fb0b5c0),
         UINT32_C(0x3fb0e64c),
         UINT32_C(0x3f92a4c0),
         UINT32_C(0x3f92f74c),
         UINT32_C(0x3fb295c0),
         UINT32_C(0x3fb2c64c)},
        UINT32_C(0xfff80000),
        {0x15,0x66,0xae,0x57,0x60,0x6c,0xc6,0x24,0xbc,0x0d,
         0xc3,0xd2,0xf9,0x60,0xc8,0x33,0x56,0x5b,0x5c,0x9e,0x00}
    },
    {
        /* No.105 delta:1214 weight:1739 */
        11213,
        22,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1881a49b),
         UINT32_C(0x3034feaa),
         UINT32_C(0x28b55a31),
         UINT32_C(0x9ba00692),
         UINT32_C(0x8321a209),
         UINT32_C(0xab94f838),
         UINT32_C(0xb3155ca3),
         UINT32_C(0x00008b7d),
         UINT32_C(0x18812fe6),
         UINT32_C(0x303475d7),
         UINT32_C(0x28b5d14c),
         UINT32_C(0x9ba08def),
         UINT32_C(0x83212974),
         UINT32_C(0xab947345),
         UINT32_C(0xb315d7de)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa00c0172),
         UINT32_C(0x504021ff),
         UINT32_C(0xf04c208d),
         UINT32_C(0x6018048e),
         UINT32_C(0xc01405fc),
         UINT32_C(0x30582571),
         UINT32_C(0x90542403),
         UINT32_C(0x007840db),
         UINT32_C(0xa07441a9),
         UINT32_C(0x50386124),
         UINT32_C(0xf0346056),
         UINT32_C(0x60604455),
         UINT32_C(0xc06c4527),
         UINT32_C(0x302065aa),
         UINT32_C(0x902c64d8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd00600),
         UINT32_C(0x3fa82010),
         UINT32_C(0x3ff82610),
         UINT32_C(0x3fb00c02),
         UINT32_C(0x3fe00a02),
         UINT32_C(0x3f982c12),
         UINT32_C(0x3fc82a12),
         UINT32_C(0x3f803c20),
         UINT32_C(0x3fd03a20),
         UINT32_C(0x3fa81c30),
         UINT32_C(0x3ff81a30),
         UINT32_C(0x3fb03022),
         UINT32_C(0x3fe03622),
         UINT32_C(0x3f981032),
         UINT32_C(0x3fc81632)},
        UINT32_C(0xfff80000),
        {0x3d,0xee,0x4f,0xc8,0x97,0xc3,0x5d,0x81,0xe2,0xee,
         0xd8,0xfe,0x39,0x57,0x22,0xe1,0x6b,0x53,0xef,0x01,0x00}
    },
    {
        /* No.106 delta:1179 weight:1561 */
        11213,
        27,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x24c5846f),
         UINT32_C(0x36a1a146),
         UINT32_C(0x12642529),
         UINT32_C(0xf43006ab),
         UINT32_C(0xd0f582c4),
         UINT32_C(0xc291a7ed),
         UINT32_C(0xe6542382),
         UINT32_C(0x0000698b),
         UINT32_C(0x24c5ede4),
         UINT32_C(0x36a1c8cd),
         UINT32_C(0x12644ca2),
         UINT32_C(0xf4306f20),
         UINT32_C(0xd0f5eb4f),
         UINT32_C(0xc291ce66),
         UINT32_C(0xe6544a09)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0064ce12),
         UINT32_C(0x80389018),
         UINT32_C(0x805c5e0a),
         UINT32_C(0x10030803),
         UINT32_C(0x1067c611),
         UINT32_C(0x903b981b),
         UINT32_C(0x905f5609),
         UINT32_C(0x1000fc01),
         UINT32_C(0x10643213),
         UINT32_C(0x90386c19),
         UINT32_C(0x905ca20b),
         UINT32_C(0x0003f402),
         UINT32_C(0x00673a10),
         UINT32_C(0x803b641a),
         UINT32_C(0x805faa08)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803267),
         UINT32_C(0x3fc01c48),
         UINT32_C(0x3fc02e2f),
         UINT32_C(0x3f880184),
         UINT32_C(0x3f8833e3),
         UINT32_C(0x3fc81dcc),
         UINT32_C(0x3fc82fab),
         UINT32_C(0x3f88007e),
         UINT32_C(0x3f883219),
         UINT32_C(0x3fc81c36),
         UINT32_C(0x3fc82e51),
         UINT32_C(0x3f8001fa),
         UINT32_C(0x3f80339d),
         UINT32_C(0x3fc01db2),
         UINT32_C(0x3fc02fd5)},
        UINT32_C(0xfff80000),
        {0xb7,0xa8,0x13,0x1a,0x7b,0xa0,0xe7,0x3f,0x3d,0xd3,
         0x79,0x84,0x0c,0x9e,0xc3,0xc7,0xaf,0xe4,0xc5,0x89,0x00}
    },
    {
        /* No.107 delta:1739 weight:1481 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xee4529e6),
         UINT32_C(0x874b1cc0),
         UINT32_C(0x690e3526),
         UINT32_C(0x976006bc),
         UINT32_C(0x79252f5a),
         UINT32_C(0x102b1a7c),
         UINT32_C(0xfe6e339a),
         UINT32_C(0x0000ad84),
         UINT32_C(0xee458462),
         UINT32_C(0x874bb144),
         UINT32_C(0x690e98a2),
         UINT32_C(0x9760ab38),
         UINT32_C(0x792582de),
         UINT32_C(0x102bb7f8),
         UINT32_C(0xfe6e9e1e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4064011d),
         UINT32_C(0x007e01ab),
         UINT32_C(0x401a00b6),
         UINT32_C(0x000201f3),
         UINT32_C(0x406600ee),
         UINT32_C(0x007c0058),
         UINT32_C(0x40180145),
         UINT32_C(0x0000013c),
         UINT32_C(0x40640021),
         UINT32_C(0x007e0097),
         UINT32_C(0x401a018a),
         UINT32_C(0x000200cf),
         UINT32_C(0x406601d2),
         UINT32_C(0x007c0164),
         UINT32_C(0x40180079)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03200),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3fa00d00),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa03300),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3fa00c00),
         UINT32_C(0x3f800000),
         UINT32_C(0x3fa03200),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3fa00d00),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa03300),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3fa00c00)},
        UINT32_C(0xfff80000),
        {0x1d,0x5d,0x6c,0x4c,0xff,0xe9,0xda,0x62,0xb7,0x42,
         0xb0,0x5c,0x89,0x06,0x2f,0x9e,0xdd,0xbd,0x57,0xb4,0x00}
    },
    {
        /* No.108 delta:702 weight:1537 */
        11213,
        73,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa61eb29f),
         UINT32_C(0xe4028f27),
         UINT32_C(0x421c3db8),
         UINT32_C(0xe31006c9),
         UINT32_C(0x450eb456),
         UINT32_C(0x071289ee),
         UINT32_C(0xa10c3b71),
         UINT32_C(0x000034cf),
         UINT32_C(0xa61e8650),
         UINT32_C(0xe402bbe8),
         UINT32_C(0x421c0977),
         UINT32_C(0xe3103206),
         UINT32_C(0x450e8099),
         UINT32_C(0x0712bd21),
         UINT32_C(0xa10c0fbe)},
        {UINT32_C(0x00000000),
         UINT32_C(0x306c40f5),
         UINT32_C(0x0052410e),
         UINT32_C(0x303e01fb),
         UINT32_C(0x10920342),
         UINT32_C(0x20fe43b7),
         UINT32_C(0x10c0424c),
         UINT32_C(0x20ac02b9),
         UINT32_C(0x200800c3),
         UINT32_C(0x10644036),
         UINT32_C(0x205a41cd),
         UINT32_C(0x10360138),
         UINT32_C(0x309a0381),
         UINT32_C(0x00f64374),
         UINT32_C(0x30c8428f),
         UINT32_C(0x00a4027a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f983620),
         UINT32_C(0x3f802920),
         UINT32_C(0x3f981f00),
         UINT32_C(0x3f884901),
         UINT32_C(0x3f907f21),
         UINT32_C(0x3f886021),
         UINT32_C(0x3f905601),
         UINT32_C(0x3f900400),
         UINT32_C(0x3f883220),
         UINT32_C(0x3f902d20),
         UINT32_C(0x3f881b00),
         UINT32_C(0x3f984d01),
         UINT32_C(0x3f807b21),
         UINT32_C(0x3f986421),
         UINT32_C(0x3f805201)},
        UINT32_C(0xfff80000),
        {0x4c,0xe2,0x2a,0x1c,0x8e,0xad,0xc1,0x99,0x25,0xec,
         0x54,0xf7,0x2f,0x18,0x4f,0x98,0xaa,0xe2,0x63,0xaa,0x00}
    },
    {
        /* No.109 delta:1143 weight:1537 */
        11213,
        27,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4f009f44),
         UINT32_C(0xec9355d5),
         UINT32_C(0xa393ca91),
         UINT32_C(0xfc0006d8),
         UINT32_C(0xb300999c),
         UINT32_C(0x1093530d),
         UINT32_C(0x5f93cc49),
         UINT32_C(0x0000fd15),
         UINT32_C(0x4f006251),
         UINT32_C(0xec93a8c0),
         UINT32_C(0xa3933784),
         UINT32_C(0xfc00fbcd),
         UINT32_C(0xb3006489),
         UINT32_C(0x1093ae18),
         UINT32_C(0x5f93315c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400e1032),
         UINT32_C(0x00092919),
         UINT32_C(0x4007392b),
         UINT32_C(0x006c38a7),
         UINT32_C(0x40622895),
         UINT32_C(0x006511be),
         UINT32_C(0x406b018c),
         UINT32_C(0x4052e15f),
         UINT32_C(0x005cf16d),
         UINT32_C(0x405bc846),
         UINT32_C(0x0055d874),
         UINT32_C(0x403ed9f8),
         UINT32_C(0x0030c9ca),
         UINT32_C(0x4037f0e1),
         UINT32_C(0x0039e0d3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00708),
         UINT32_C(0x3f800494),
         UINT32_C(0x3fa0039c),
         UINT32_C(0x3f80361c),
         UINT32_C(0x3fa03114),
         UINT32_C(0x3f803288),
         UINT32_C(0x3fa03580),
         UINT32_C(0x3fa02970),
         UINT32_C(0x3f802e78),
         UINT32_C(0x3fa02de4),
         UINT32_C(0x3f802aec),
         UINT32_C(0x3fa01f6c),
         UINT32_C(0x3f801864),
         UINT32_C(0x3fa01bf8),
         UINT32_C(0x3f801cf0)},
        UINT32_C(0xfff80000),
        {0x15,0xc6,0x81,0xbd,0xc5,0x3a,0xd0,0xc7,0x24,0xad,
         0x87,0x5f,0x74,0xa5,0xb7,0xc1,0x6d,0xc6,0x85,0xdc,0x00}
    },
    {
        /* No.110 delta:910 weight:1209 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf914b93f),
         UINT32_C(0x23aeca7f),
         UINT32_C(0xdaba7340),
         UINT32_C(0x44e006e2),
         UINT32_C(0xbdf4bfdd),
         UINT32_C(0x674ecc9d),
         UINT32_C(0x9e5a75a2),
         UINT32_C(0x0000456f),
         UINT32_C(0xf914fc50),
         UINT32_C(0x23ae8f10),
         UINT32_C(0xdaba362f),
         UINT32_C(0x44e0438d),
         UINT32_C(0xbdf4fab2),
         UINT32_C(0x674e89f2),
         UINT32_C(0x9e5a30cd)},
        {UINT32_C(0x00000000),
         UINT32_C(0x406d91d2),
         UINT32_C(0x10023de6),
         UINT32_C(0x506fac34),
         UINT32_C(0x1000511a),
         UINT32_C(0x506dc0c8),
         UINT32_C(0x00026cfc),
         UINT32_C(0x406ffd2e),
         UINT32_C(0x40184c07),
         UINT32_C(0x0075ddd5),
         UINT32_C(0x501a71e1),
         UINT32_C(0x1077e033),
         UINT32_C(0x50181d1d),
         UINT32_C(0x10758ccf),
         UINT32_C(0x401a20fb),
         UINT32_C(0x0077b129)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa036c8),
         UINT32_C(0x3f88011e),
         UINT32_C(0x3fa837d6),
         UINT32_C(0x3f880028),
         UINT32_C(0x3fa836e0),
         UINT32_C(0x3f800136),
         UINT32_C(0x3fa037fe),
         UINT32_C(0x3fa00c26),
         UINT32_C(0x3f803aee),
         UINT32_C(0x3fa80d38),
         UINT32_C(0x3f883bf0),
         UINT32_C(0x3fa80c0e),
         UINT32_C(0x3f883ac6),
         UINT32_C(0x3fa00d10),
         UINT32_C(0x3f803bd8)},
        UINT32_C(0xfff80000),
        {0x83,0x91,0x1a,0xa2,0x3a,0x01,0xc4,0x60,0xfe,0xfc,
         0xd0,0x70,0x7b,0xef,0x38,0x48,0x8f,0x98,0xfa,0x44,0x00}
    },
    {
        /* No.111 delta:587 weight:1251 */
        11213,
        79,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xec78402c),
         UINT32_C(0xf8d2123a),
         UINT32_C(0x14aa5216),
         UINT32_C(0xb61006ff),
         UINT32_C(0x5a6846d3),
         UINT32_C(0x4ec214c5),
         UINT32_C(0xa2ba54e9),
         UINT32_C(0x0000e95f),
         UINT32_C(0xec78a973),
         UINT32_C(0xf8d2fb65),
         UINT32_C(0x14aabb49),
         UINT32_C(0xb610efa0),
         UINT32_C(0x5a68af8c),
         UINT32_C(0x4ec2fd9a),
         UINT32_C(0xa2babdb6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40028d76),
         UINT32_C(0x50044a0b),
         UINT32_C(0x1006c77d),
         UINT32_C(0x6001c20f),
         UINT32_C(0x20034f79),
         UINT32_C(0x30058804),
         UINT32_C(0x70070572),
         UINT32_C(0x200065e7),
         UINT32_C(0x6002e891),
         UINT32_C(0x70042fec),
         UINT32_C(0x3006a29a),
         UINT32_C(0x4001a7e8),
         UINT32_C(0x00032a9e),
         UINT32_C(0x1005ede3),
         UINT32_C(0x50076095)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00146),
         UINT32_C(0x3fa80225),
         UINT32_C(0x3f880363),
         UINT32_C(0x3fb000e1),
         UINT32_C(0x3f9001a7),
         UINT32_C(0x3f9802c4),
         UINT32_C(0x3fb80382),
         UINT32_C(0x3f900032),
         UINT32_C(0x3fb00174),
         UINT32_C(0x3fb80217),
         UINT32_C(0x3f980351),
         UINT32_C(0x3fa000d3),
         UINT32_C(0x3f800195),
         UINT32_C(0x3f8802f6),
         UINT32_C(0x3fa803b0)},
        UINT32_C(0xfff80000),
        {0x90,0xec,0x33,0x35,0xf4,0x57,0xba,0x69,0x2a,0xd4,
         0xb9,0x92,0x2f,0xb6,0x45,0x3c,0x1d,0x82,0xbc,0xcc,0x00}
    },
    {
        /* No.112 delta:733 weight:1123 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf03b5e04),
         UINT32_C(0xfbe77025),
         UINT32_C(0x0bdc2e21),
         UINT32_C(0xec900702),
         UINT32_C(0x1cab5906),
         UINT32_C(0x17777727),
         UINT32_C(0xe74c2923),
         UINT32_C(0x00008094),
         UINT32_C(0xf03bde90),
         UINT32_C(0xfbe7f0b1),
         UINT32_C(0x0bdcaeb5),
         UINT32_C(0xec908796),
         UINT32_C(0x1cabd992),
         UINT32_C(0x1777f7b3),
         UINT32_C(0xe74ca9b7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x406c0cf7),
         UINT32_C(0x50414e9a),
         UINT32_C(0x102d426d),
         UINT32_C(0x00401411),
         UINT32_C(0x402c18e6),
         UINT32_C(0x50015a8b),
         UINT32_C(0x106d567c),
         UINT32_C(0x60098402),
         UINT32_C(0x206588f5),
         UINT32_C(0x3048ca98),
         UINT32_C(0x7024c66f),
         UINT32_C(0x60499013),
         UINT32_C(0x20259ce4),
         UINT32_C(0x3008de89),
         UINT32_C(0x7064d27e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03606),
         UINT32_C(0x3fa820a7),
         UINT32_C(0x3f8816a1),
         UINT32_C(0x3f80200a),
         UINT32_C(0x3fa0160c),
         UINT32_C(0x3fa800ad),
         UINT32_C(0x3f8836ab),
         UINT32_C(0x3fb004c2),
         UINT32_C(0x3f9032c4),
         UINT32_C(0x3f982465),
         UINT32_C(0x3fb81263),
         UINT32_C(0x3fb024c8),
         UINT32_C(0x3f9012ce),
         UINT32_C(0x3f98046f),
         UINT32_C(0x3fb83269)},
        UINT32_C(0xfff80000),
        {0x21,0xcc,0x88,0xfe,0xbf,0x09,0xdb,0xf4,0xcc,0xac,
         0xb9,0x48,0xc6,0x11,0x42,0x45,0x08,0xcf,0x55,0xf8,0x00}
    },
    {
        /* No.113 delta:961 weight:1485 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf8e15148),
         UINT32_C(0xcf71a664),
         UINT32_C(0x3790f72c),
         UINT32_C(0x55a0071e),
         UINT32_C(0xad415656),
         UINT32_C(0x9ad1a17a),
         UINT32_C(0x6230f032),
         UINT32_C(0x00004daa),
         UINT32_C(0xf8e11ce2),
         UINT32_C(0xcf71ebce),
         UINT32_C(0x3790ba86),
         UINT32_C(0x55a04ab4),
         UINT32_C(0xad411bfc),
         UINT32_C(0x9ad1ecd0),
         UINT32_C(0x6230bd98)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20142173),
         UINT32_C(0x50001eed),
         UINT32_C(0x70143f9e),
         UINT32_C(0x007e01db),
         UINT32_C(0x206a20a8),
         UINT32_C(0x507e1f36),
         UINT32_C(0x706a3e45),
         UINT32_C(0x00029019),
         UINT32_C(0x2016b16a),
         UINT32_C(0x50028ef4),
         UINT32_C(0x7016af87),
         UINT32_C(0x007c91c2),
         UINT32_C(0x2068b0b1),
         UINT32_C(0x507c8f2f),
         UINT32_C(0x7068ae5c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900a10),
         UINT32_C(0x3fa8000f),
         UINT32_C(0x3fb80a1f),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f903510),
         UINT32_C(0x3fa83f0f),
         UINT32_C(0x3fb8351f),
         UINT32_C(0x3f800148),
         UINT32_C(0x3f900b58),
         UINT32_C(0x3fa80147),
         UINT32_C(0x3fb80b57),
         UINT32_C(0x3f803e48),
         UINT32_C(0x3f903458),
         UINT32_C(0x3fa83e47),
         UINT32_C(0x3fb83457)},
        UINT32_C(0xfff80000),
        {0x9f,0xa0,0xe0,0xda,0x23,0xbf,0xa1,0xb7,0xb0,0xeb,
         0x5d,0xf4,0x6e,0xcb,0xa1,0x43,0xf7,0x9b,0x0e,0x6c,0x00}
    },
    {
        /* No.114 delta:1259 weight:1687 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3f45045b),
         UINT32_C(0x4e9e0af7),
         UINT32_C(0x71db0eac),
         UINT32_C(0x6140072d),
         UINT32_C(0x5e050376),
         UINT32_C(0x2fde0dda),
         UINT32_C(0x109b0981),
         UINT32_C(0x0000e7b0),
         UINT32_C(0x3f45e3eb),
         UINT32_C(0x4e9eed47),
         UINT32_C(0x71dbe91c),
         UINT32_C(0x6140e09d),
         UINT32_C(0x5e05e4c6),
         UINT32_C(0x2fdeea6a),
         UINT32_C(0x109bee31)},
        {UINT32_C(0x00000000),
         UINT32_C(0x300c059a),
         UINT32_C(0x405e408f),
         UINT32_C(0x70524515),
         UINT32_C(0x20285cdc),
         UINT32_C(0x10245946),
         UINT32_C(0x60761c53),
         UINT32_C(0x507a19c9),
         UINT32_C(0x24482218),
         UINT32_C(0x14442782),
         UINT32_C(0x64166297),
         UINT32_C(0x541a670d),
         UINT32_C(0x04607ec4),
         UINT32_C(0x346c7b5e),
         UINT32_C(0x443e3e4b),
         UINT32_C(0x74323bd1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980602),
         UINT32_C(0x3fa02f20),
         UINT32_C(0x3fb82922),
         UINT32_C(0x3f90142e),
         UINT32_C(0x3f88122c),
         UINT32_C(0x3fb03b0e),
         UINT32_C(0x3fa83d0c),
         UINT32_C(0x3f922411),
         UINT32_C(0x3f8a2213),
         UINT32_C(0x3fb20b31),
         UINT32_C(0x3faa0d33),
         UINT32_C(0x3f82303f),
         UINT32_C(0x3f9a363d),
         UINT32_C(0x3fa21f1f),
         UINT32_C(0x3fba191d)},
        UINT32_C(0xfff80000),
        {0xf4,0x32,0x1b,0x7a,0xe6,0x66,0x05,0xfc,0x41,0xb9,
         0x19,0x2a,0x8f,0xba,0x14,0xbe,0x8d,0x4f,0xd4,0x55,0x00}
    },
    {
        /* No.115 delta:1749 weight:1509 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc9a19456),
         UINT32_C(0xd71166f0),
         UINT32_C(0x1eb0f2a6),
         UINT32_C(0xdd60073e),
         UINT32_C(0x14c19368),
         UINT32_C(0x0a7161ce),
         UINT32_C(0xc3d0f598),
         UINT32_C(0x00002adc),
         UINT32_C(0xc9a1be8a),
         UINT32_C(0xd7114c2c),
         UINT32_C(0x1eb0d87a),
         UINT32_C(0xdd602de2),
         UINT32_C(0x14c1b9b4),
         UINT32_C(0x0a714b12),
         UINT32_C(0xc3d0df44)},
        {UINT32_C(0x00000000),
         UINT32_C(0x42ac41fb),
         UINT32_C(0x1080a407),
         UINT32_C(0x522ce5fc),
         UINT32_C(0x08448816),
         UINT32_C(0x4ae8c9ed),
         UINT32_C(0x18c42c11),
         UINT32_C(0x5a686dea),
         UINT32_C(0x20600822),
         UINT32_C(0x62cc49d9),
         UINT32_C(0x30e0ac25),
         UINT32_C(0x724cedde),
         UINT32_C(0x28248034),
         UINT32_C(0x6a88c1cf),
         UINT32_C(0x38a42433),
         UINT32_C(0x7a0865c8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa15620),
         UINT32_C(0x3f884052),
         UINT32_C(0x3fa91672),
         UINT32_C(0x3f842244),
         UINT32_C(0x3fa57464),
         UINT32_C(0x3f8c6216),
         UINT32_C(0x3fad3436),
         UINT32_C(0x3f903004),
         UINT32_C(0x3fb16624),
         UINT32_C(0x3f987056),
         UINT32_C(0x3fb92676),
         UINT32_C(0x3f941240),
         UINT32_C(0x3fb54460),
         UINT32_C(0x3f9c5212),
         UINT32_C(0x3fbd0432)},
        UINT32_C(0xfff80000),
        {0x45,0xb5,0x72,0x39,0xb8,0xc6,0x3e,0xc7,0x26,0xde,
         0x33,0xeb,0xc0,0xc2,0x54,0xfa,0x37,0x18,0x9c,0xc9,0x00}
    },
    {
        /* No.116 delta:881 weight:973 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x43507563),
         UINT32_C(0x0a62d22e),
         UINT32_C(0x4932a74d),
         UINT32_C(0xc2b00743),
         UINT32_C(0x81e07220),
         UINT32_C(0xc8d2d56d),
         UINT32_C(0x8b82a00e),
         UINT32_C(0x0000b615),
         UINT32_C(0x4350c376),
         UINT32_C(0x0a62643b),
         UINT32_C(0x49321158),
         UINT32_C(0xc2b0b156),
         UINT32_C(0x81e0c435),
         UINT32_C(0xc8d26378),
         UINT32_C(0x8b82161b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4000989f),
         UINT32_C(0x0803e4ee),
         UINT32_C(0x48037c71),
         UINT32_C(0x0021cc48),
         UINT32_C(0x402154d7),
         UINT32_C(0x082228a6),
         UINT32_C(0x4822b039),
         UINT32_C(0x20023124),
         UINT32_C(0x6002a9bb),
         UINT32_C(0x2801d5ca),
         UINT32_C(0x68014d55),
         UINT32_C(0x2023fd6c),
         UINT32_C(0x602365f3),
         UINT32_C(0x28201982),
         UINT32_C(0x6820811d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0004c),
         UINT32_C(0x3f8401f2),
         UINT32_C(0x3fa401be),
         UINT32_C(0x3f8010e6),
         UINT32_C(0x3fa010aa),
         UINT32_C(0x3f841114),
         UINT32_C(0x3fa41158),
         UINT32_C(0x3f900118),
         UINT32_C(0x3fb00154),
         UINT32_C(0x3f9400ea),
         UINT32_C(0x3fb400a6),
         UINT32_C(0x3f9011fe),
         UINT32_C(0x3fb011b2),
         UINT32_C(0x3f94100c),
         UINT32_C(0x3fb41040)},
        UINT32_C(0xfff80000),
        {0x36,0x5e,0x9b,0x40,0x8b,0x86,0xee,0x44,0xd5,0x89,
         0xa1,0x27,0x1e,0xb0,0x35,0x38,0x90,0x44,0xf0,0x85,0x00}
    },
    {
        /* No.117 delta:1063 weight:1401 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf3e49888),
         UINT32_C(0x5ca452bc),
         UINT32_C(0xaf40ca34),
         UINT32_C(0xb9300752),
         UINT32_C(0x4ad49fda),
         UINT32_C(0xe59455ee),
         UINT32_C(0x1670cd66),
         UINT32_C(0x00008d1b),
         UINT32_C(0xf3e41593),
         UINT32_C(0x5ca4dfa7),
         UINT32_C(0xaf40472f),
         UINT32_C(0xb9308a49),
         UINT32_C(0x4ad412c1),
         UINT32_C(0xe594d8f5),
         UINT32_C(0x1670407d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x800249d4),
         UINT32_C(0x10814a9e),
         UINT32_C(0x9083034a),
         UINT32_C(0x10201192),
         UINT32_C(0x90225846),
         UINT32_C(0x00a15b0c),
         UINT32_C(0x80a312d8),
         UINT32_C(0x6001201d),
         UINT32_C(0xe00369c9),
         UINT32_C(0x70806a83),
         UINT32_C(0xf0822357),
         UINT32_C(0x7021318f),
         UINT32_C(0xf023785b),
         UINT32_C(0x60a07b11),
         UINT32_C(0xe0a232c5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00124),
         UINT32_C(0x3f8840a5),
         UINT32_C(0x3fc84181),
         UINT32_C(0x3f881008),
         UINT32_C(0x3fc8112c),
         UINT32_C(0x3f8050ad),
         UINT32_C(0x3fc05189),
         UINT32_C(0x3fb00090),
         UINT32_C(0x3ff001b4),
         UINT32_C(0x3fb84035),
         UINT32_C(0x3ff84111),
         UINT32_C(0x3fb81098),
         UINT32_C(0x3ff811bc),
         UINT32_C(0x3fb0503d),
         UINT32_C(0x3ff05119)},
        UINT32_C(0xfff80000),
        {0x60,0xed,0xc6,0xf3,0xc6,0x80,0xb1,0x3b,0xc1,0x64,
         0x78,0x4b,0x3f,0x63,0xbd,0x7b,0xc4,0x0c,0xd9,0x39,0x00}
    },
    {
        /* No.118 delta:1137 weight:1497 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x71930aea),
         UINT32_C(0x570aa1e5),
         UINT32_C(0x2699ab0f),
         UINT32_C(0xcc600761),
         UINT32_C(0xbdf30d8b),
         UINT32_C(0x9b6aa684),
         UINT32_C(0xeaf9ac6e),
         UINT32_C(0x00005787),
         UINT32_C(0x71935d6d),
         UINT32_C(0x570af662),
         UINT32_C(0x2699fc88),
         UINT32_C(0xcc6050e6),
         UINT32_C(0xbdf35a0c),
         UINT32_C(0x9b6af103),
         UINT32_C(0xeaf9fbe9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0045283e),
         UINT32_C(0x00010852),
         UINT32_C(0x0044206c),
         UINT32_C(0x102c0195),
         UINT32_C(0x106929ab),
         UINT32_C(0x102d09c7),
         UINT32_C(0x106821f9),
         UINT32_C(0x0000441f),
         UINT32_C(0x00456c21),
         UINT32_C(0x00014c4d),
         UINT32_C(0x00446473),
         UINT32_C(0x102c458a),
         UINT32_C(0x10696db4),
         UINT32_C(0x102d4dd8),
         UINT32_C(0x106865e6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802294),
         UINT32_C(0x3f800084),
         UINT32_C(0x3f802210),
         UINT32_C(0x3f881600),
         UINT32_C(0x3f883494),
         UINT32_C(0x3f881684),
         UINT32_C(0x3f883410),
         UINT32_C(0x3f800022),
         UINT32_C(0x3f8022b6),
         UINT32_C(0x3f8000a6),
         UINT32_C(0x3f802232),
         UINT32_C(0x3f881622),
         UINT32_C(0x3f8834b6),
         UINT32_C(0x3f8816a6),
         UINT32_C(0x3f883432)},
        UINT32_C(0xfff80000),
        {0x3f,0x85,0x79,0x0e,0x9f,0xcf,0x7a,0xf1,0x61,0x7a,
         0x2f,0x3e,0x53,0x2c,0xba,0x5f,0x95,0x72,0xb1,0xaf,0x00}
    },
    {
        /* No.119 delta:2081 weight:1319 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5de13e8c),
         UINT32_C(0xaf27000d),
         UINT32_C(0xf2c63e81),
         UINT32_C(0xe4c00772),
         UINT32_C(0xb92139fe),
         UINT32_C(0x4be7077f),
         UINT32_C(0x160639f3),
         UINT32_C(0x0000339b),
         UINT32_C(0x5de10d17),
         UINT32_C(0xaf273396),
         UINT32_C(0xf2c60d1a),
         UINT32_C(0xe4c034e9),
         UINT32_C(0xb9210a65),
         UINT32_C(0x4be734e4),
         UINT32_C(0x16060a68)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0cfc0054),
         UINT32_C(0x0a801c7b),
         UINT32_C(0x067c1c2f),
         UINT32_C(0x06b26091),
         UINT32_C(0x0a4e60c5),
         UINT32_C(0x0c327cea),
         UINT32_C(0x00ce7cbe),
         UINT32_C(0x06038017),
         UINT32_C(0x0aff8043),
         UINT32_C(0x0c839c6c),
         UINT32_C(0x007f9c38),
         UINT32_C(0x00b1e086),
         UINT32_C(0x0c4de0d2),
         UINT32_C(0x0a31fcfd),
         UINT32_C(0x06cdfca9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f867e00),
         UINT32_C(0x3f85400e),
         UINT32_C(0x3f833e0e),
         UINT32_C(0x3f835930),
         UINT32_C(0x3f852730),
         UINT32_C(0x3f86193e),
         UINT32_C(0x3f80673e),
         UINT32_C(0x3f8301c0),
         UINT32_C(0x3f857fc0),
         UINT32_C(0x3f8641ce),
         UINT32_C(0x3f803fce),
         UINT32_C(0x3f8058f0),
         UINT32_C(0x3f8626f0),
         UINT32_C(0x3f8518fe),
         UINT32_C(0x3f8366fe)},
        UINT32_C(0xfff80000),
        {0x0d,0x39,0xf3,0x78,0x89,0x68,0xeb,0xd5,0x15,0x9f,
         0x5c,0x20,0xc1,0x91,0x35,0xe8,0x14,0x9a,0x0a,0x34,0x00}
    },
    {
        /* No.120 delta:938 weight:1729 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5ad5c7fc),
         UINT32_C(0x50877aee),
         UINT32_C(0x0a52bd12),
         UINT32_C(0x0f400787),
         UINT32_C(0x5595c07b),
         UINT32_C(0x5fc77d69),
         UINT32_C(0x0512ba95),
         UINT32_C(0x0000b61e),
         UINT32_C(0x5ad571e2),
         UINT32_C(0x5087ccf0),
         UINT32_C(0x0a520b0c),
         UINT32_C(0x0f40b199),
         UINT32_C(0x55957665),
         UINT32_C(0x5fc7cb77),
         UINT32_C(0x05120c8b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00234632),
         UINT32_C(0x000208b7),
         UINT32_C(0x00214e85),
         UINT32_C(0x206c297e),
         UINT32_C(0x204f6f4c),
         UINT32_C(0x206e21c9),
         UINT32_C(0x204d67fb),
         UINT32_C(0x90145093),
         UINT32_C(0x903716a1),
         UINT32_C(0x90165824),
         UINT32_C(0x90351e16),
         UINT32_C(0xb07879ed),
         UINT32_C(0xb05b3fdf),
         UINT32_C(0xb07a715a),
         UINT32_C(0xb0593768)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8011a3),
         UINT32_C(0x3f800104),
         UINT32_C(0x3f8010a7),
         UINT32_C(0x3f903614),
         UINT32_C(0x3f9027b7),
         UINT32_C(0x3f903710),
         UINT32_C(0x3f9026b3),
         UINT32_C(0x3fc80a28),
         UINT32_C(0x3fc81b8b),
         UINT32_C(0x3fc80b2c),
         UINT32_C(0x3fc81a8f),
         UINT32_C(0x3fd83c3c),
         UINT32_C(0x3fd82d9f),
         UINT32_C(0x3fd83d38),
         UINT32_C(0x3fd82c9b)},
        UINT32_C(0xfff80000),
        {0x53,0x85,0x3f,0x41,0x21,0x4b,0x43,0x04,0x88,0x1d,
         0x85,0xcd,0x7c,0xf6,0x24,0x1b,0x9b,0x62,0xb7,0xbc,0x00}
    },
    {
        /* No.121 delta:1254 weight:1595 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf4721b6f),
         UINT32_C(0x38780238),
         UINT32_C(0xcc0a1957),
         UINT32_C(0x0a800791),
         UINT32_C(0xfef21cfe),
         UINT32_C(0x32f805a9),
         UINT32_C(0xc68a1ec6),
         UINT32_C(0x00008e00),
         UINT32_C(0xf472956f),
         UINT32_C(0x38788c38),
         UINT32_C(0xcc0a9757),
         UINT32_C(0x0a808991),
         UINT32_C(0xfef292fe),
         UINT32_C(0x32f88ba9),
         UINT32_C(0xc68a90c6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x105500de),
         UINT32_C(0x504089f2),
         UINT32_C(0x4015892c),
         UINT32_C(0x2010110b),
         UINT32_C(0x304511d5),
         UINT32_C(0x705098f9),
         UINT32_C(0x60059827),
         UINT32_C(0x00644410),
         UINT32_C(0x103144ce),
         UINT32_C(0x5024cde2),
         UINT32_C(0x4071cd3c),
         UINT32_C(0x2074551b),
         UINT32_C(0x302155c5),
         UINT32_C(0x7034dce9),
         UINT32_C(0x6061dc37)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f882a80),
         UINT32_C(0x3fa82044),
         UINT32_C(0x3fa00ac4),
         UINT32_C(0x3f900808),
         UINT32_C(0x3f982288),
         UINT32_C(0x3fb8284c),
         UINT32_C(0x3fb002cc),
         UINT32_C(0x3f803222),
         UINT32_C(0x3f8818a2),
         UINT32_C(0x3fa81266),
         UINT32_C(0x3fa038e6),
         UINT32_C(0x3f903a2a),
         UINT32_C(0x3f9810aa),
         UINT32_C(0x3fb81a6e),
         UINT32_C(0x3fb030ee)},
        UINT32_C(0xfff80000),
        {0x25,0xb4,0x83,0xd2,0x14,0x30,0xa0,0x57,0x76,0x91,
         0x93,0x5e,0x6b,0x3a,0x16,0x61,0x4b,0x33,0xd7,0x9d,0x00}
    },
    {
        /* No.122 delta:2273 weight:1235 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x687364d2),
         UINT32_C(0xba9856f7),
         UINT32_C(0xd2eb3225),
         UINT32_C(0x654007a9),
         UINT32_C(0x0d33637b),
         UINT32_C(0xdfd8515e),
         UINT32_C(0xb7ab358c),
         UINT32_C(0x00009222),
         UINT32_C(0x6873f6f0),
         UINT32_C(0xba98c4d5),
         UINT32_C(0xd2eba007),
         UINT32_C(0x6540958b),
         UINT32_C(0x0d33f159),
         UINT32_C(0xdfd8c37c),
         UINT32_C(0xb7aba7ae)},
        {UINT32_C(0x00000000),
         UINT32_C(0x247a41dc),
         UINT32_C(0x3b8c83a3),
         UINT32_C(0x1ff6c27f),
         UINT32_C(0x804ca051),
         UINT32_C(0xa436e18d),
         UINT32_C(0xbbc023f2),
         UINT32_C(0x9fba622e),
         UINT32_C(0x29340c18),
         UINT32_C(0x0d4e4dc4),
         UINT32_C(0x12b88fbb),
         UINT32_C(0x36c2ce67),
         UINT32_C(0xa978ac49),
         UINT32_C(0x8d02ed95),
         UINT32_C(0x92f42fea),
         UINT32_C(0xb68e6e36)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f923d20),
         UINT32_C(0x3f9dc641),
         UINT32_C(0x3f8ffb61),
         UINT32_C(0x3fc02650),
         UINT32_C(0x3fd21b70),
         UINT32_C(0x3fdde011),
         UINT32_C(0x3fcfdd31),
         UINT32_C(0x3f949a06),
         UINT32_C(0x3f86a726),
         UINT32_C(0x3f895c47),
         UINT32_C(0x3f9b6167),
         UINT32_C(0x3fd4bc56),
         UINT32_C(0x3fc68176),
         UINT32_C(0x3fc97a17),
         UINT32_C(0x3fdb4737)},
        UINT32_C(0xfff80000),
        {0x16,0xe5,0x70,0x73,0xbe,0x32,0xee,0x39,0x6b,0x15,
         0xd3,0x8f,0xfb,0xb6,0xa5,0x64,0xa6,0x28,0x10,0x42,0x00}
    },
    {
        /* No.123 delta:887 weight:1675 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9ffafe84),
         UINT32_C(0x081afe71),
         UINT32_C(0x97e000f5),
         UINT32_C(0xb02007bf),
         UINT32_C(0x2fdaf93b),
         UINT32_C(0xb83af9ce),
         UINT32_C(0x27c0074a),
         UINT32_C(0x000053a9),
         UINT32_C(0x9ffaad2d),
         UINT32_C(0x081aadd8),
         UINT32_C(0x97e0535c),
         UINT32_C(0xb0205416),
         UINT32_C(0x2fdaaa92),
         UINT32_C(0xb83aaa67),
         UINT32_C(0x27c054e3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5024f876),
         UINT32_C(0x4002e819),
         UINT32_C(0x1026106f),
         UINT32_C(0x00020174),
         UINT32_C(0x5026f902),
         UINT32_C(0x4000e96d),
         UINT32_C(0x1024111b),
         UINT32_C(0x008101f0),
         UINT32_C(0x50a5f986),
         UINT32_C(0x4083e9e9),
         UINT32_C(0x10a7119f),
         UINT32_C(0x00830084),
         UINT32_C(0x50a7f8f2),
         UINT32_C(0x4081e89d),
         UINT32_C(0x10a510eb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa8127c),
         UINT32_C(0x3fa00174),
         UINT32_C(0x3f881308),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa8137c),
         UINT32_C(0x3fa00074),
         UINT32_C(0x3f881208),
         UINT32_C(0x3f804080),
         UINT32_C(0x3fa852fc),
         UINT32_C(0x3fa041f4),
         UINT32_C(0x3f885388),
         UINT32_C(0x3f804180),
         UINT32_C(0x3fa853fc),
         UINT32_C(0x3fa040f4),
         UINT32_C(0x3f885288)},
        UINT32_C(0xfff80000),
        {0xf7,0xea,0x73,0x84,0x56,0x0b,0xb3,0x0b,0x8a,0x6d,
         0x5f,0xd0,0xca,0xd9,0x28,0x47,0x7c,0x3a,0x53,0xfa,0x00}
    },
    {
        /* No.124 delta:667 weight:1687 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbed9237e),
         UINT32_C(0xe52a7947),
         UINT32_C(0x5bf35a39),
         UINT32_C(0x730007cd),
         UINT32_C(0xcdd924b3),
         UINT32_C(0x962a7e8a),
         UINT32_C(0x28f35df4),
         UINT32_C(0x0000f310),
         UINT32_C(0xbed9d06e),
         UINT32_C(0xe52a8a57),
         UINT32_C(0x5bf3a929),
         UINT32_C(0x7300f4dd),
         UINT32_C(0xcdd9d7a3),
         UINT32_C(0x962a8d9a),
         UINT32_C(0x28f3aee4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00020dde),
         UINT32_C(0x2000c18a),
         UINT32_C(0x2002cc54),
         UINT32_C(0x5040601b),
         UINT32_C(0x50426dc5),
         UINT32_C(0x7040a191),
         UINT32_C(0x7042ac4f),
         UINT32_C(0x600c200d),
         UINT32_C(0x600e2dd3),
         UINT32_C(0x400ce187),
         UINT32_C(0x400eec59),
         UINT32_C(0x304c4016),
         UINT32_C(0x304e4dc8),
         UINT32_C(0x104c819c),
         UINT32_C(0x104e8c42)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800106),
         UINT32_C(0x3f900060),
         UINT32_C(0x3f900166),
         UINT32_C(0x3fa82030),
         UINT32_C(0x3fa82136),
         UINT32_C(0x3fb82050),
         UINT32_C(0x3fb82156),
         UINT32_C(0x3fb00610),
         UINT32_C(0x3fb00716),
         UINT32_C(0x3fa00670),
         UINT32_C(0x3fa00776),
         UINT32_C(0x3f982620),
         UINT32_C(0x3f982726),
         UINT32_C(0x3f882640),
         UINT32_C(0x3f882746)},
        UINT32_C(0xfff80000),
        {0x03,0x26,0x66,0x84,0x6a,0xdf,0x3c,0x27,0x3e,0xa5,
         0x4e,0x5a,0x89,0x62,0x3c,0x64,0xa4,0x63,0x62,0x6c,0x00}
    },
    {
        /* No.125 delta:3095 weight:631 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xaf97f659),
         UINT32_C(0xe63edaa4),
         UINT32_C(0x49a92cfd),
         UINT32_C(0x1cd007d8),
         UINT32_C(0xb347f181),
         UINT32_C(0xfaeedd7c),
         UINT32_C(0x55792b25),
         UINT32_C(0x0000f83b),
         UINT32_C(0xaf970e62),
         UINT32_C(0xe63e229f),
         UINT32_C(0x49a9d4c6),
         UINT32_C(0x1cd0ffe3),
         UINT32_C(0xb34709ba),
         UINT32_C(0xfaee2547),
         UINT32_C(0x5579d31e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80348027),
         UINT32_C(0x8830479e),
         UINT32_C(0x0804c7b9),
         UINT32_C(0xeb8801ec),
         UINT32_C(0x6bbc81cb),
         UINT32_C(0x63b84672),
         UINT32_C(0xe38cc655),
         UINT32_C(0x0fd8801a),
         UINT32_C(0x8fec003d),
         UINT32_C(0x87e8c784),
         UINT32_C(0x07dc47a3),
         UINT32_C(0xe45081f6),
         UINT32_C(0x646401d1),
         UINT32_C(0x6c60c668),
         UINT32_C(0xec54464f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc01a40),
         UINT32_C(0x3fc41823),
         UINT32_C(0x3f840263),
         UINT32_C(0x3ff5c400),
         UINT32_C(0x3fb5de40),
         UINT32_C(0x3fb1dc23),
         UINT32_C(0x3ff1c663),
         UINT32_C(0x3f87ec40),
         UINT32_C(0x3fc7f600),
         UINT32_C(0x3fc3f463),
         UINT32_C(0x3f83ee23),
         UINT32_C(0x3ff22840),
         UINT32_C(0x3fb23200),
         UINT32_C(0x3fb63063),
         UINT32_C(0x3ff62a23)},
        UINT32_C(0xfff80000),
        {0xb5,0xd4,0xc7,0xbc,0x65,0xb7,0x30,0x68,0x6a,0x83,
         0x03,0x7c,0x40,0x97,0x66,0x5c,0x4c,0x77,0xf7,0x13,0x00}
    },
    {
        /* No.126 delta:1826 weight:1491 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbb3fabf7),
         UINT32_C(0xc77376e1),
         UINT32_C(0x7c4cdd16),
         UINT32_C(0x220007e0),
         UINT32_C(0x993fac17),
         UINT32_C(0xe5737101),
         UINT32_C(0x5e4cdaf6),
         UINT32_C(0x0000b280),
         UINT32_C(0xbb3f1977),
         UINT32_C(0xc773c461),
         UINT32_C(0x7c4c6f96),
         UINT32_C(0x2200b560),
         UINT32_C(0x993f1e97),
         UINT32_C(0xe573c381),
         UINT32_C(0x5e4c6876)},
        {UINT32_C(0x00000000),
         UINT32_C(0x48e1e99a),
         UINT32_C(0x046541af),
         UINT32_C(0x4c84a835),
         UINT32_C(0x008f02c4),
         UINT32_C(0x486eeb5e),
         UINT32_C(0x04ea436b),
         UINT32_C(0x4c0baaf1),
         UINT32_C(0x40a23019),
         UINT32_C(0x0843d983),
         UINT32_C(0x44c771b6),
         UINT32_C(0x0c26982c),
         UINT32_C(0x402d32dd),
         UINT32_C(0x08ccdb47),
         UINT32_C(0x44487372),
         UINT32_C(0x0ca99ae8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa470f4),
         UINT32_C(0x3f8232a0),
         UINT32_C(0x3fa64254),
         UINT32_C(0x3f804781),
         UINT32_C(0x3fa43775),
         UINT32_C(0x3f827521),
         UINT32_C(0x3fa605d5),
         UINT32_C(0x3fa05118),
         UINT32_C(0x3f8421ec),
         UINT32_C(0x3fa263b8),
         UINT32_C(0x3f86134c),
         UINT32_C(0x3fa01699),
         UINT32_C(0x3f84666d),
         UINT32_C(0x3fa22439),
         UINT32_C(0x3f8654cd)},
        UINT32_C(0xfff80000),
        {0x84,0x07,0xf5,0x68,0xec,0x9b,0xa3,0xb0,0x2b,0x79,
         0x21,0x0e,0xc5,0x1e,0xa0,0xdf,0x36,0x4e,0x70,0xcf,0x00}
    },
    {
        /* No.127 delta:977 weight:1317 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x63f0c30e),
         UINT32_C(0x083a1093),
         UINT32_C(0x6bcad39d),
         UINT32_C(0x104007f8),
         UINT32_C(0x73b0c4f6),
         UINT32_C(0x187a176b),
         UINT32_C(0x7b8ad465),
         UINT32_C(0x0000dfbf),
         UINT32_C(0x63f01cb1),
         UINT32_C(0x083acf2c),
         UINT32_C(0x6bca0c22),
         UINT32_C(0x1040d847),
         UINT32_C(0x73b01b49),
         UINT32_C(0x187ac8d4),
         UINT32_C(0x7b8a0bda)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00463d7e),
         UINT32_C(0x4001620d),
         UINT32_C(0x40475f73),
         UINT32_C(0x34006019),
         UINT32_C(0x34465d67),
         UINT32_C(0x74010214),
         UINT32_C(0x74473f6a),
         UINT32_C(0x61002826),
         UINT32_C(0x61461558),
         UINT32_C(0x21014a2b),
         UINT32_C(0x21477755),
         UINT32_C(0x5500483f),
         UINT32_C(0x55467541),
         UINT32_C(0x15012a32),
         UINT32_C(0x1547174c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80231e),
         UINT32_C(0x3fa000b1),
         UINT32_C(0x3fa023af),
         UINT32_C(0x3f9a0030),
         UINT32_C(0x3f9a232e),
         UINT32_C(0x3fba0081),
         UINT32_C(0x3fba239f),
         UINT32_C(0x3fb08014),
         UINT32_C(0x3fb0a30a),
         UINT32_C(0x3f9080a5),
         UINT32_C(0x3f90a3bb),
         UINT32_C(0x3faa8024),
         UINT32_C(0x3faaa33a),
         UINT32_C(0x3f8a8095),
         UINT32_C(0x3f8aa38b)},
        UINT32_C(0xfff80000),
        {0x7b,0x49,0x48,0xac,0x0e,0x29,0x12,0xd6,0xb9,0x98,
         0xe4,0x38,0x8b,0x47,0x4f,0x4b,0x6d,0xa3,0x6b,0x2d,0x00}
    },
    {
        /* No.128 delta:691 weight:1641 */
        11213,
        62,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5473c0b0),
         UINT32_C(0x0f5cfd3e),
         UINT32_C(0x5b2f3d8e),
         UINT32_C(0x2c20080c),
         UINT32_C(0x7853c8bc),
         UINT32_C(0x237cf532),
         UINT32_C(0x770f3582),
         UINT32_C(0x0000cc52),
         UINT32_C(0x54730ce2),
         UINT32_C(0x0f5c316c),
         UINT32_C(0x5b2ff1dc),
         UINT32_C(0x2c20c45e),
         UINT32_C(0x785304ee),
         UINT32_C(0x237c3960),
         UINT32_C(0x770ff9d0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x404c8097),
         UINT32_C(0x00037003),
         UINT32_C(0x404ff094),
         UINT32_C(0x100805ca),
         UINT32_C(0x5044855d),
         UINT32_C(0x100b75c9),
         UINT32_C(0x5047f55e),
         UINT32_C(0x4000113c),
         UINT32_C(0x004c91ab),
         UINT32_C(0x4003613f),
         UINT32_C(0x004fe1a8),
         UINT32_C(0x500814f6),
         UINT32_C(0x10449461),
         UINT32_C(0x500b64f5),
         UINT32_C(0x1047e462)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02640),
         UINT32_C(0x3f8001b8),
         UINT32_C(0x3fa027f8),
         UINT32_C(0x3f880402),
         UINT32_C(0x3fa82242),
         UINT32_C(0x3f8805ba),
         UINT32_C(0x3fa823fa),
         UINT32_C(0x3fa00008),
         UINT32_C(0x3f802648),
         UINT32_C(0x3fa001b0),
         UINT32_C(0x3f8027f0),
         UINT32_C(0x3fa8040a),
         UINT32_C(0x3f88224a),
         UINT32_C(0x3fa805b2),
         UINT32_C(0x3f8823f2)},
        UINT32_C(0xfff80000),
        {0x0c,0x35,0x0e,0x67,0x61,0x0d,0xf3,0xdc,0xd8,0x29,
         0x50,0xe8,0xaf,0xff,0x6f,0x88,0xcf,0xa3,0x3e,0xfa,0x00}
    },
    {
        /* No.129 delta:1085 weight:1313 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xda085890),
         UINT32_C(0x01457dcf),
         UINT32_C(0xdb4d255f),
         UINT32_C(0x46f0081a),
         UINT32_C(0x9cf8508a),
         UINT32_C(0x47b575d5),
         UINT32_C(0x9dbd2d45),
         UINT32_C(0x00000630),
         UINT32_C(0xda085ea0),
         UINT32_C(0x01457bff),
         UINT32_C(0xdb4d236f),
         UINT32_C(0x46f00e2a),
         UINT32_C(0x9cf856ba),
         UINT32_C(0x47b573e5),
         UINT32_C(0x9dbd2b75)},
        {UINT32_C(0x00000000),
         UINT32_C(0x102499ba),
         UINT32_C(0x007c0406),
         UINT32_C(0x10589dbc),
         UINT32_C(0x00021107),
         UINT32_C(0x102688bd),
         UINT32_C(0x007e1501),
         UINT32_C(0x105a8cbb),
         UINT32_C(0xe08e4133),
         UINT32_C(0xf0aad889),
         UINT32_C(0xe0f24535),
         UINT32_C(0xf0d6dc8f),
         UINT32_C(0xe08c5034),
         UINT32_C(0xf0a8c98e),
         UINT32_C(0xe0f05432),
         UINT32_C(0xf0d4cd88)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f88124c),
         UINT32_C(0x3f803e02),
         UINT32_C(0x3f882c4e),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f881344),
         UINT32_C(0x3f803f0a),
         UINT32_C(0x3f882d46),
         UINT32_C(0x3ff04720),
         UINT32_C(0x3ff8556c),
         UINT32_C(0x3ff07922),
         UINT32_C(0x3ff86b6e),
         UINT32_C(0x3ff04628),
         UINT32_C(0x3ff85464),
         UINT32_C(0x3ff0782a),
         UINT32_C(0x3ff86a66)},
        UINT32_C(0xfff80000),
        {0xc2,0xbe,0xfc,0xa1,0xa9,0xa7,0xe1,0x8c,0x54,0x80,
         0x2f,0x61,0x16,0xca,0x97,0x26,0xb0,0x77,0xd4,0xcf,0x00}
    },
    {
        /* No.130 delta:1766 weight:1661 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7a7a5fa4),
         UINT32_C(0xa616acc6),
         UINT32_C(0xdc6cf362),
         UINT32_C(0xff400828),
         UINT32_C(0x853a578c),
         UINT32_C(0x5956a4ee),
         UINT32_C(0x232cfb4a),
         UINT32_C(0x000071f3),
         UINT32_C(0x7a7a2e57),
         UINT32_C(0xa616dd35),
         UINT32_C(0xdc6c8291),
         UINT32_C(0xff4079db),
         UINT32_C(0x853a267f),
         UINT32_C(0x5956d51d),
         UINT32_C(0x232c8ab9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x866528b2),
         UINT32_C(0x0c7020fd),
         UINT32_C(0x8a15084f),
         UINT32_C(0x004361a9),
         UINT32_C(0x8626491b),
         UINT32_C(0x0c334154),
         UINT32_C(0x8a5669e6),
         UINT32_C(0x02018121),
         UINT32_C(0x8464a993),
         UINT32_C(0x0e71a1dc),
         UINT32_C(0x8814896e),
         UINT32_C(0x0242e088),
         UINT32_C(0x8427c83a),
         UINT32_C(0x0e32c075),
         UINT32_C(0x8857e8c7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc33294),
         UINT32_C(0x3f863810),
         UINT32_C(0x3fc50a84),
         UINT32_C(0x3f8021b0),
         UINT32_C(0x3fc31324),
         UINT32_C(0x3f8619a0),
         UINT32_C(0x3fc52b34),
         UINT32_C(0x3f8100c0),
         UINT32_C(0x3fc23254),
         UINT32_C(0x3f8738d0),
         UINT32_C(0x3fc40a44),
         UINT32_C(0x3f812170),
         UINT32_C(0x3fc213e4),
         UINT32_C(0x3f871960),
         UINT32_C(0x3fc42bf4)},
        UINT32_C(0xfff80000),
        {0x24,0x7e,0x0d,0x64,0xeb,0x06,0x35,0x8c,0x85,0xd0,
         0xa6,0x24,0x9f,0xeb,0x93,0x0b,0xb5,0x7a,0x20,0xa7,0x00}
    },
    {
        /* No.131 delta:704 weight:1621 */
        11213,
        68,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3e922477),
         UINT32_C(0x359f388b),
         UINT32_C(0x0b0d1cfc),
         UINT32_C(0x17a00835),
         UINT32_C(0x29322c42),
         UINT32_C(0x223f30be),
         UINT32_C(0x1cad14c9),
         UINT32_C(0x00001efd),
         UINT32_C(0x3e923a8a),
         UINT32_C(0x359f2676),
         UINT32_C(0x0b0d0201),
         UINT32_C(0x17a016c8),
         UINT32_C(0x293232bf),
         UINT32_C(0x223f2e43),
         UINT32_C(0x1cad0a34)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4c650012),
         UINT32_C(0x022da0e3),
         UINT32_C(0x4e48a0f1),
         UINT32_C(0x0044102f),
         UINT32_C(0x4c21103d),
         UINT32_C(0x0269b0cc),
         UINT32_C(0x4e0cb0de),
         UINT32_C(0x0020fdb5),
         UINT32_C(0x4c45fda7),
         UINT32_C(0x020d5d56),
         UINT32_C(0x4e685d44),
         UINT32_C(0x0064ed9a),
         UINT32_C(0x4c01ed88),
         UINT32_C(0x02494d79),
         UINT32_C(0x4e2c4d6b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa63280),
         UINT32_C(0x3f8116d0),
         UINT32_C(0x3fa72450),
         UINT32_C(0x3f802208),
         UINT32_C(0x3fa61088),
         UINT32_C(0x3f8134d8),
         UINT32_C(0x3fa70658),
         UINT32_C(0x3f80107e),
         UINT32_C(0x3fa622fe),
         UINT32_C(0x3f8106ae),
         UINT32_C(0x3fa7342e),
         UINT32_C(0x3f803276),
         UINT32_C(0x3fa600f6),
         UINT32_C(0x3f8124a6),
         UINT32_C(0x3fa71626)},
        UINT32_C(0xfff80000),
        {0xc3,0x01,0xf9,0xeb,0xa0,0x0a,0xd9,0x04,0x35,0x26,
         0x4e,0xeb,0xe1,0xa6,0xf4,0x6b,0x3e,0xe2,0x63,0x5c,0x00}
    },
    {
        /* No.132 delta:945 weight:1681 */
        11213,
        38,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1b464ade),
         UINT32_C(0x87a5d98b),
         UINT32_C(0x9ce39355),
         UINT32_C(0xda700843),
         UINT32_C(0xc136429d),
         UINT32_C(0x5dd5d1c8),
         UINT32_C(0x46939b16),
         UINT32_C(0x00004dfa),
         UINT32_C(0x1b460724),
         UINT32_C(0x87a59471),
         UINT32_C(0x9ce3deaf),
         UINT32_C(0xda7045b9),
         UINT32_C(0xc1360f67),
         UINT32_C(0x5dd59c32),
         UINT32_C(0x4693d6ec)},
        {UINT32_C(0x00000000),
         UINT32_C(0x204d093a),
         UINT32_C(0x50022059),
         UINT32_C(0x704f2963),
         UINT32_C(0x303049ad),
         UINT32_C(0x107d4097),
         UINT32_C(0x603269f4),
         UINT32_C(0x407f60ce),
         UINT32_C(0x5001088b),
         UINT32_C(0x704c01b1),
         UINT32_C(0x000328d2),
         UINT32_C(0x204e21e8),
         UINT32_C(0x60314126),
         UINT32_C(0x407c481c),
         UINT32_C(0x3033617f),
         UINT32_C(0x107e6845)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902684),
         UINT32_C(0x3fa80110),
         UINT32_C(0x3fb82794),
         UINT32_C(0x3f981824),
         UINT32_C(0x3f883ea0),
         UINT32_C(0x3fb01934),
         UINT32_C(0x3fa03fb0),
         UINT32_C(0x3fa80084),
         UINT32_C(0x3fb82600),
         UINT32_C(0x3f800194),
         UINT32_C(0x3f902710),
         UINT32_C(0x3fb018a0),
         UINT32_C(0x3fa03e24),
         UINT32_C(0x3f9819b0),
         UINT32_C(0x3f883f34)},
        UINT32_C(0xfff80000),
        {0xb4,0x6d,0xa1,0xb3,0x8f,0xe5,0x1b,0xa2,0x02,0xc6,
         0xab,0xb1,0x90,0x5e,0x18,0x29,0x79,0x33,0xeb,0x3b,0x00}
    },
    {
        /* No.133 delta:1586 weight:1619 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe767c596),
         UINT32_C(0x5528e484),
         UINT32_C(0xb24f2112),
         UINT32_C(0x9a800850),
         UINT32_C(0x7de7cdc6),
         UINT32_C(0xcfa8ecd4),
         UINT32_C(0x28cf2942),
         UINT32_C(0x00007135),
         UINT32_C(0xe767b4a3),
         UINT32_C(0x552895b1),
         UINT32_C(0xb24f5027),
         UINT32_C(0x9a807965),
         UINT32_C(0x7de7bcf3),
         UINT32_C(0xcfa89de1),
         UINT32_C(0x28cf5877)},
        {UINT32_C(0x00000000),
         UINT32_C(0x099010de),
         UINT32_C(0x2784a18b),
         UINT32_C(0x2e14b155),
         UINT32_C(0x140a4876),
         UINT32_C(0x1d9a58a8),
         UINT32_C(0x338ee9fd),
         UINT32_C(0x3a1ef923),
         UINT32_C(0x006a207a),
         UINT32_C(0x09fa30a4),
         UINT32_C(0x27ee81f1),
         UINT32_C(0x2e7e912f),
         UINT32_C(0x1460680c),
         UINT32_C(0x1df078d2),
         UINT32_C(0x33e4c987),
         UINT32_C(0x3a74d959)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84c808),
         UINT32_C(0x3f93c250),
         UINT32_C(0x3f970a58),
         UINT32_C(0x3f8a0524),
         UINT32_C(0x3f8ecd2c),
         UINT32_C(0x3f99c774),
         UINT32_C(0x3f9d0f7c),
         UINT32_C(0x3f803510),
         UINT32_C(0x3f84fd18),
         UINT32_C(0x3f93f740),
         UINT32_C(0x3f973f48),
         UINT32_C(0x3f8a3034),
         UINT32_C(0x3f8ef83c),
         UINT32_C(0x3f99f264),
         UINT32_C(0x3f9d3a6c)},
        UINT32_C(0xfff80000),
        {0x88,0x24,0x80,0xd9,0xf7,0x5d,0x33,0x6e,0x29,0x40,
         0x2a,0xbe,0x1c,0x91,0x53,0x7d,0xcf,0x99,0xa8,0x74,0x00}
    },
    {
        /* No.134 delta:607 weight:1541 */
        11213,
        80,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb1f1c8f6),
         UINT32_C(0x117327cd),
         UINT32_C(0xa082ef3b),
         UINT32_C(0xd5c00860),
         UINT32_C(0x6431c096),
         UINT32_C(0xc4b32fad),
         UINT32_C(0x7542e75b),
         UINT32_C(0x00008802),
         UINT32_C(0xb1f140f4),
         UINT32_C(0x1173afcf),
         UINT32_C(0xa0826739),
         UINT32_C(0xd5c08062),
         UINT32_C(0x64314894),
         UINT32_C(0xc4b3a7af),
         UINT32_C(0x75426f59)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0020701f),
         UINT32_C(0x205cd976),
         UINT32_C(0x207ca969),
         UINT32_C(0x4000c018),
         UINT32_C(0x4020b007),
         UINT32_C(0x605c196e),
         UINT32_C(0x607c6971),
         UINT32_C(0x00401c1c),
         UINT32_C(0x00606c03),
         UINT32_C(0x201cc56a),
         UINT32_C(0x203cb575),
         UINT32_C(0x4040dc04),
         UINT32_C(0x4060ac1b),
         UINT32_C(0x601c0572),
         UINT32_C(0x603c756d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801038),
         UINT32_C(0x3f902e6c),
         UINT32_C(0x3f903e54),
         UINT32_C(0x3fa00060),
         UINT32_C(0x3fa01058),
         UINT32_C(0x3fb02e0c),
         UINT32_C(0x3fb03e34),
         UINT32_C(0x3f80200e),
         UINT32_C(0x3f803036),
         UINT32_C(0x3f900e62),
         UINT32_C(0x3f901e5a),
         UINT32_C(0x3fa0206e),
         UINT32_C(0x3fa03056),
         UINT32_C(0x3fb00e02),
         UINT32_C(0x3fb01e3a)},
        UINT32_C(0xfff80000),
        {0xff,0x78,0x00,0xdd,0xe1,0xe1,0xcb,0x7d,0xfb,0x5a,
         0xbf,0x61,0xcc,0x53,0xae,0xf9,0xbb,0x22,0x95,0x3d,0x00}
    },
    {
        /* No.135 delta:1216 weight:1481 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2efc7b65),
         UINT32_C(0xd5ed2bc8),
         UINT32_C(0xfb1150ad),
         UINT32_C(0xff90087c),
         UINT32_C(0xd16c7319),
         UINT32_C(0x2a7d23b4),
         UINT32_C(0x048158d1),
         UINT32_C(0x000011a9),
         UINT32_C(0x2efc6acc),
         UINT32_C(0xd5ed3a61),
         UINT32_C(0xfb114104),
         UINT32_C(0xff9019d5),
         UINT32_C(0xd16c62b0),
         UINT32_C(0x2a7d321d),
         UINT32_C(0x04814978)},
        {UINT32_C(0x00000000),
         UINT32_C(0x30022096),
         UINT32_C(0x10040ddf),
         UINT32_C(0x20062d49),
         UINT32_C(0x10008108),
         UINT32_C(0x2002a19e),
         UINT32_C(0x00048cd7),
         UINT32_C(0x3006ac41),
         UINT32_C(0x60184015),
         UINT32_C(0x501a6083),
         UINT32_C(0x701c4dca),
         UINT32_C(0x401e6d5c),
         UINT32_C(0x7018c11d),
         UINT32_C(0x401ae18b),
         UINT32_C(0x601cccc2),
         UINT32_C(0x501eec54)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980110),
         UINT32_C(0x3f880206),
         UINT32_C(0x3f900316),
         UINT32_C(0x3f880040),
         UINT32_C(0x3f900150),
         UINT32_C(0x3f800246),
         UINT32_C(0x3f980356),
         UINT32_C(0x3fb00c20),
         UINT32_C(0x3fa80d30),
         UINT32_C(0x3fb80e26),
         UINT32_C(0x3fa00f36),
         UINT32_C(0x3fb80c60),
         UINT32_C(0x3fa00d70),
         UINT32_C(0x3fb00e66),
         UINT32_C(0x3fa80f76)},
        UINT32_C(0xfff80000),
        {0x5b,0x58,0xff,0x3f,0x25,0x71,0x1b,0x41,0xf4,0xac,
         0xf6,0xd0,0x44,0xdd,0x3d,0x65,0xb9,0x91,0xb3,0x64,0x00}
    },
    {
        /* No.136 delta:915 weight:1245 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf6ee1897),
         UINT32_C(0x8bd48878),
         UINT32_C(0x7d3a90ef),
         UINT32_C(0x4e20088a),
         UINT32_C(0xb8ce101d),
         UINT32_C(0xc5f480f2),
         UINT32_C(0x331a9865),
         UINT32_C(0x0000ef87),
         UINT32_C(0xf6eef710),
         UINT32_C(0x8bd467ff),
         UINT32_C(0x7d3a7f68),
         UINT32_C(0x4e20e70d),
         UINT32_C(0xb8ceff9a),
         UINT32_C(0xc5f46f75),
         UINT32_C(0x331a77e2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00123032),
         UINT32_C(0x4004005e),
         UINT32_C(0x4016306c),
         UINT32_C(0x10012419),
         UINT32_C(0x1013142b),
         UINT32_C(0x50052447),
         UINT32_C(0x50171475),
         UINT32_C(0x2020f01c),
         UINT32_C(0x2032c02e),
         UINT32_C(0x6024f042),
         UINT32_C(0x6036c070),
         UINT32_C(0x3021d405),
         UINT32_C(0x3033e437),
         UINT32_C(0x7025d45b),
         UINT32_C(0x7037e469)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800918),
         UINT32_C(0x3fa00200),
         UINT32_C(0x3fa00b18),
         UINT32_C(0x3f880092),
         UINT32_C(0x3f88098a),
         UINT32_C(0x3fa80292),
         UINT32_C(0x3fa80b8a),
         UINT32_C(0x3f901078),
         UINT32_C(0x3f901960),
         UINT32_C(0x3fb01278),
         UINT32_C(0x3fb01b60),
         UINT32_C(0x3f9810ea),
         UINT32_C(0x3f9819f2),
         UINT32_C(0x3fb812ea),
         UINT32_C(0x3fb81bf2)},
        UINT32_C(0xfff80000),
        {0xd0,0x2f,0xaa,0xb2,0x0e,0xf8,0x08,0x6a,0x9a,0xa7,
         0xc7,0xdb,0xc7,0x2a,0x01,0x6d,0xba,0x24,0x6f,0xc6,0x00}
    },
    {
        /* No.137 delta:1408 weight:1561 */
        11213,
        17,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x58bdda30),
         UINT32_C(0x08dab14b),
         UINT32_C(0x50676b7b),
         UINT32_C(0xff20089e),
         UINT32_C(0xa79dd2ae),
         UINT32_C(0xf7fab9d5),
         UINT32_C(0xaf4763e5),
         UINT32_C(0x0000596d),
         UINT32_C(0x58bd835d),
         UINT32_C(0x08dae826),
         UINT32_C(0x50673216),
         UINT32_C(0xff2051f3),
         UINT32_C(0xa79d8bc3),
         UINT32_C(0xf7fae0b8),
         UINT32_C(0xaf473a88)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0054247e),
         UINT32_C(0x10139d12),
         UINT32_C(0x1047b96c),
         UINT32_C(0x60482015),
         UINT32_C(0x601c046b),
         UINT32_C(0x705bbd07),
         UINT32_C(0x700f9979),
         UINT32_C(0x201f890a),
         UINT32_C(0x204bad74),
         UINT32_C(0x300c1418),
         UINT32_C(0x30583066),
         UINT32_C(0x4057a91f),
         UINT32_C(0x40038d61),
         UINT32_C(0x5044340d),
         UINT32_C(0x50101073)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a12),
         UINT32_C(0x3f8809ce),
         UINT32_C(0x3f8823dc),
         UINT32_C(0x3fb02410),
         UINT32_C(0x3fb00e02),
         UINT32_C(0x3fb82dde),
         UINT32_C(0x3fb807cc),
         UINT32_C(0x3f900fc4),
         UINT32_C(0x3f9025d6),
         UINT32_C(0x3f98060a),
         UINT32_C(0x3f982c18),
         UINT32_C(0x3fa02bd4),
         UINT32_C(0x3fa001c6),
         UINT32_C(0x3fa8221a),
         UINT32_C(0x3fa80808)},
        UINT32_C(0xfff80000),
        {0xc2,0x03,0x9f,0xf3,0xff,0x15,0xdc,0x23,0x3b,0x01,
         0xbe,0x8f,0x1d,0x7a,0x00,0xfd,0xcd,0x06,0xea,0xd1,0x00}
    },
    {
        /* No.138 delta:1148 weight:1595 */
        11213,
        23,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd2c7bfa4),
         UINT32_C(0xbdd43421),
         UINT32_C(0x6f138b85),
         UINT32_C(0x169008a8),
         UINT32_C(0xc457b70c),
         UINT32_C(0xab443c89),
         UINT32_C(0x7983832d),
         UINT32_C(0x0000d08f),
         UINT32_C(0xd2c76f2b),
         UINT32_C(0xbdd4e4ae),
         UINT32_C(0x6f135b0a),
         UINT32_C(0x1690d827),
         UINT32_C(0xc4576783),
         UINT32_C(0xab44ec06),
         UINT32_C(0x798353a2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x101f7156),
         UINT32_C(0x00274394),
         UINT32_C(0x103832c2),
         UINT32_C(0x004ec0fc),
         UINT32_C(0x1051b1aa),
         UINT32_C(0x00698368),
         UINT32_C(0x1076f23e),
         UINT32_C(0x600c823d),
         UINT32_C(0x7013f36b),
         UINT32_C(0x602bc1a9),
         UINT32_C(0x7034b0ff),
         UINT32_C(0x604242c1),
         UINT32_C(0x705d3397),
         UINT32_C(0x60650155),
         UINT32_C(0x707a7003)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880fb8),
         UINT32_C(0x3f8013a1),
         UINT32_C(0x3f881c19),
         UINT32_C(0x3f802760),
         UINT32_C(0x3f8828d8),
         UINT32_C(0x3f8034c1),
         UINT32_C(0x3f883b79),
         UINT32_C(0x3fb00641),
         UINT32_C(0x3fb809f9),
         UINT32_C(0x3fb015e0),
         UINT32_C(0x3fb81a58),
         UINT32_C(0x3fb02121),
         UINT32_C(0x3fb82e99),
         UINT32_C(0x3fb03280),
         UINT32_C(0x3fb83d38)},
        UINT32_C(0xfff80000),
        {0x82,0xce,0x83,0x96,0x5a,0xc8,0xee,0x6a,0xea,0x48,
         0xc3,0x82,0x83,0xbb,0xa6,0x50,0x47,0x9a,0xb8,0x57,0x00}
    },
    {
        /* No.139 delta:806 weight:1289 */
        11213,
        78,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x167bdfc7),
         UINT32_C(0xd623904f),
         UINT32_C(0xc0584f88),
         UINT32_C(0xb8f008be),
         UINT32_C(0xae8bd779),
         UINT32_C(0x6ed398f1),
         UINT32_C(0x78a84736),
         UINT32_C(0x000012ed),
         UINT32_C(0x167bcd2a),
         UINT32_C(0xd62382a2),
         UINT32_C(0xc0585d65),
         UINT32_C(0xb8f01a53),
         UINT32_C(0xae8bc594),
         UINT32_C(0x6ed38a1c),
         UINT32_C(0x78a855db)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1070993d),
         UINT32_C(0x0002147e),
         UINT32_C(0x10728d43),
         UINT32_C(0x404085b8),
         UINT32_C(0x50301c85),
         UINT32_C(0x404291c6),
         UINT32_C(0x503208fb),
         UINT32_C(0x00010807),
         UINT32_C(0x1071913a),
         UINT32_C(0x00031c79),
         UINT32_C(0x10738544),
         UINT32_C(0x40418dbf),
         UINT32_C(0x50311482),
         UINT32_C(0x404399c1),
         UINT32_C(0x503300fc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f88384c),
         UINT32_C(0x3f80010a),
         UINT32_C(0x3f883946),
         UINT32_C(0x3fa02042),
         UINT32_C(0x3fa8180e),
         UINT32_C(0x3fa02148),
         UINT32_C(0x3fa81904),
         UINT32_C(0x3f800084),
         UINT32_C(0x3f8838c8),
         UINT32_C(0x3f80018e),
         UINT32_C(0x3f8839c2),
         UINT32_C(0x3fa020c6),
         UINT32_C(0x3fa8188a),
         UINT32_C(0x3fa021cc),
         UINT32_C(0x3fa81980)},
        UINT32_C(0xfff80000),
        {0x0b,0x53,0x7d,0x77,0x88,0xbe,0xf7,0xe0,0xab,0x5e,
         0x31,0x24,0xee,0x24,0xd6,0x65,0x85,0x33,0xf4,0xc6,0x00}
    },
    {
        /* No.140 delta:708 weight:1653 */
        11213,
        68,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa843165f),
         UINT32_C(0xfd791587),
         UINT32_C(0x553a03d8),
         UINT32_C(0xb6d008c3),
         UINT32_C(0x1e931e9c),
         UINT32_C(0x4ba91d44),
         UINT32_C(0xe3ea0b1b),
         UINT32_C(0x00007382),
         UINT32_C(0xa84365dd),
         UINT32_C(0xfd796605),
         UINT32_C(0x553a705a),
         UINT32_C(0xb6d07b41),
         UINT32_C(0x1e936d1e),
         UINT32_C(0x4ba96ec6),
         UINT32_C(0xe3ea7899)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00032c13),
         UINT32_C(0x4000a36f),
         UINT32_C(0x40038f7c),
         UINT32_C(0xf00000f7),
         UINT32_C(0xf0032ce4),
         UINT32_C(0xb000a398),
         UINT32_C(0xb0038f8b),
         UINT32_C(0x10006816),
         UINT32_C(0x10034405),
         UINT32_C(0x5000cb79),
         UINT32_C(0x5003e76a),
         UINT32_C(0xe00068e1),
         UINT32_C(0xe00344f2),
         UINT32_C(0xa000cb8e),
         UINT32_C(0xa003e79d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800196),
         UINT32_C(0x3fa00051),
         UINT32_C(0x3fa001c7),
         UINT32_C(0x3ff80000),
         UINT32_C(0x3ff80196),
         UINT32_C(0x3fd80051),
         UINT32_C(0x3fd801c7),
         UINT32_C(0x3f880034),
         UINT32_C(0x3f8801a2),
         UINT32_C(0x3fa80065),
         UINT32_C(0x3fa801f3),
         UINT32_C(0x3ff00034),
         UINT32_C(0x3ff001a2),
         UINT32_C(0x3fd00065),
         UINT32_C(0x3fd001f3)},
        UINT32_C(0xfff80000),
        {0x8a,0x61,0xc1,0x12,0xfb,0x34,0x22,0xe4,0xea,0xfd,
         0x6a,0x85,0x6e,0x31,0x31,0xe0,0x83,0x16,0x29,0x46,0x00}
    },
    {
        /* No.141 delta:999 weight:979 */
        11213,
        89,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x704436df),
         UINT32_C(0x3cf475e1),
         UINT32_C(0x4cb0433e),
         UINT32_C(0x82c008dc),
         UINT32_C(0xf2843e03),
         UINT32_C(0xbe347d3d),
         UINT32_C(0xce704be2),
         UINT32_C(0x0000a242),
         UINT32_C(0x7044949d),
         UINT32_C(0x3cf4d7a3),
         UINT32_C(0x4cb0e17c),
         UINT32_C(0x82c0aa9e),
         UINT32_C(0xf2849c41),
         UINT32_C(0xbe34df7f),
         UINT32_C(0xce70e9a0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0023d9b6),
         UINT32_C(0x0054015b),
         UINT32_C(0x0077d8ed),
         UINT32_C(0x27d021f1),
         UINT32_C(0x27f3f847),
         UINT32_C(0x278420aa),
         UINT32_C(0x27a7f91c),
         UINT32_C(0x0a0a2118),
         UINT32_C(0x0a29f8ae),
         UINT32_C(0x0a5e2043),
         UINT32_C(0x0a7df9f5),
         UINT32_C(0x2dda00e9),
         UINT32_C(0x2df9d95f),
         UINT32_C(0x2d8e01b2),
         UINT32_C(0x2dadd804)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8011ec),
         UINT32_C(0x3f802a00),
         UINT32_C(0x3f803bec),
         UINT32_C(0x3f93e810),
         UINT32_C(0x3f93f9fc),
         UINT32_C(0x3f93c210),
         UINT32_C(0x3f93d3fc),
         UINT32_C(0x3f850510),
         UINT32_C(0x3f8514fc),
         UINT32_C(0x3f852f10),
         UINT32_C(0x3f853efc),
         UINT32_C(0x3f96ed00),
         UINT32_C(0x3f96fcec),
         UINT32_C(0x3f96c700),
         UINT32_C(0x3f96d6ec)},
        UINT32_C(0xfff80000),
        {0x15,0x85,0xd9,0x08,0x97,0x45,0xfd,0x4a,0x34,0x36,
         0x05,0xdf,0xdc,0xe2,0x28,0x04,0x9b,0x16,0xc3,0x00,0x00}
    },
    {
        /* No.142 delta:602 weight:1747 */
        11213,
        75,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb6dda24b),
         UINT32_C(0x671fd84c),
         UINT32_C(0xd1c27a07),
         UINT32_C(0x66a008e9),
         UINT32_C(0xd07daaa2),
         UINT32_C(0x01bfd0a5),
         UINT32_C(0xb76272ee),
         UINT32_C(0x00006563),
         UINT32_C(0xb6ddc728),
         UINT32_C(0x671fbd2f),
         UINT32_C(0xd1c21f64),
         UINT32_C(0x66a06d8a),
         UINT32_C(0xd07dcfc1),
         UINT32_C(0x01bfb5c6),
         UINT32_C(0xb762178d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0801011f),
         UINT32_C(0x40040106),
         UINT32_C(0x48050019),
         UINT32_C(0x0020cfdd),
         UINT32_C(0x0821cec2),
         UINT32_C(0x4024cedb),
         UINT32_C(0x4825cfc4),
         UINT32_C(0x10001c18),
         UINT32_C(0x18011d07),
         UINT32_C(0x50041d1e),
         UINT32_C(0x58051c01),
         UINT32_C(0x1020d3c5),
         UINT32_C(0x1821d2da),
         UINT32_C(0x5024d2c3),
         UINT32_C(0x5825d3dc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f840080),
         UINT32_C(0x3fa00200),
         UINT32_C(0x3fa40280),
         UINT32_C(0x3f801067),
         UINT32_C(0x3f8410e7),
         UINT32_C(0x3fa01267),
         UINT32_C(0x3fa412e7),
         UINT32_C(0x3f88000e),
         UINT32_C(0x3f8c008e),
         UINT32_C(0x3fa8020e),
         UINT32_C(0x3fac028e),
         UINT32_C(0x3f881069),
         UINT32_C(0x3f8c10e9),
         UINT32_C(0x3fa81269),
         UINT32_C(0x3fac12e9)},
        UINT32_C(0xfff80000),
        {0xd2,0xa3,0xa9,0x60,0x33,0x46,0x34,0x7a,0xa5,0x3c,
         0x04,0x27,0x4d,0x40,0xa4,0xb7,0xc0,0x45,0xc2,0xf2,0x00}
    },
    {
        /* No.143 delta:1765 weight:1617 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x989cafc6),
         UINT32_C(0x80343f5b),
         UINT32_C(0x18a8909d),
         UINT32_C(0x3d4008f0),
         UINT32_C(0xa5dca736),
         UINT32_C(0xbd7437ab),
         UINT32_C(0x25e8986d),
         UINT32_C(0x0000873e),
         UINT32_C(0x989c28f8),
         UINT32_C(0x8034b865),
         UINT32_C(0x18a817a3),
         UINT32_C(0x3d408fce),
         UINT32_C(0xa5dc2008),
         UINT32_C(0xbd74b095),
         UINT32_C(0x25e81f53)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6b6020fa),
         UINT32_C(0x2218c043),
         UINT32_C(0x4978e0b9),
         UINT32_C(0x6003218c),
         UINT32_C(0x0b630176),
         UINT32_C(0x421be1cf),
         UINT32_C(0x297bc135),
         UINT32_C(0x4088a010),
         UINT32_C(0x2be880ea),
         UINT32_C(0x62906053),
         UINT32_C(0x09f040a9),
         UINT32_C(0x208b819c),
         UINT32_C(0x4beba166),
         UINT32_C(0x029341df),
         UINT32_C(0x69f36125)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb5b010),
         UINT32_C(0x3f910c60),
         UINT32_C(0x3fa4bc70),
         UINT32_C(0x3fb00190),
         UINT32_C(0x3f85b180),
         UINT32_C(0x3fa10df0),
         UINT32_C(0x3f94bde0),
         UINT32_C(0x3fa04450),
         UINT32_C(0x3f95f440),
         UINT32_C(0x3fb14830),
         UINT32_C(0x3f84f820),
         UINT32_C(0x3f9045c0),
         UINT32_C(0x3fa5f5d0),
         UINT32_C(0x3f8149a0),
         UINT32_C(0x3fb4f9b0)},
        UINT32_C(0xfff80000),
        {0x5d,0x7b,0x8e,0x78,0xae,0x8f,0x26,0xae,0x7a,0xb2,
         0x3d,0x45,0x25,0xfa,0x23,0x36,0x5c,0xd4,0x99,0x12,0x00}
    },
    {
        /* No.144 delta:884 weight:1707 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd9cdefd4),
         UINT32_C(0xf3e209ac),
         UINT32_C(0x2a2fe678),
         UINT32_C(0xa8900905),
         UINT32_C(0x715de6d1),
         UINT32_C(0x5b7200a9),
         UINT32_C(0x82bfef7d),
         UINT32_C(0x00004eeb),
         UINT32_C(0xd9cda13f),
         UINT32_C(0xf3e24747),
         UINT32_C(0x2a2fa893),
         UINT32_C(0xa89047ee),
         UINT32_C(0x715da83a),
         UINT32_C(0x5b724e42),
         UINT32_C(0x82bfa196)},
        {UINT32_C(0x00000000),
         UINT32_C(0x200fa85a),
         UINT32_C(0x0074809f),
         UINT32_C(0x207b28c5),
         UINT32_C(0x4043441c),
         UINT32_C(0x604cec46),
         UINT32_C(0x4037c483),
         UINT32_C(0x60386cd9),
         UINT32_C(0x00024017),
         UINT32_C(0x200de84d),
         UINT32_C(0x0076c088),
         UINT32_C(0x207968d2),
         UINT32_C(0x4041040b),
         UINT32_C(0x604eac51),
         UINT32_C(0x40358494),
         UINT32_C(0x603a2cce)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9007d4),
         UINT32_C(0x3f803a40),
         UINT32_C(0x3f903d94),
         UINT32_C(0x3fa021a2),
         UINT32_C(0x3fb02676),
         UINT32_C(0x3fa01be2),
         UINT32_C(0x3fb01c36),
         UINT32_C(0x3f800120),
         UINT32_C(0x3f9006f4),
         UINT32_C(0x3f803b60),
         UINT32_C(0x3f903cb4),
         UINT32_C(0x3fa02082),
         UINT32_C(0x3fb02756),
         UINT32_C(0x3fa01ac2),
         UINT32_C(0x3fb01d16)},
        UINT32_C(0xfff80000),
        {0x09,0xbe,0x73,0x0d,0x54,0x0c,0xac,0xda,0x00,0x3d,
         0xa5,0xe1,0x05,0xcd,0xd4,0x30,0xec,0x1e,0x1c,0x13,0x00}
    },
    {
        /* No.145 delta:894 weight:1007 */
        11213,
        89,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4a30df1a),
         UINT32_C(0x68613901),
         UINT32_C(0x2251e61b),
         UINT32_C(0x4f200919),
         UINT32_C(0x0510d603),
         UINT32_C(0x27413018),
         UINT32_C(0x6d71ef02),
         UINT32_C(0x0000747c),
         UINT32_C(0x4a30ab66),
         UINT32_C(0x68614d7d),
         UINT32_C(0x22519267),
         UINT32_C(0x4f207d65),
         UINT32_C(0x0510a27f),
         UINT32_C(0x27414464),
         UINT32_C(0x6d719b7e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006c19f2),
         UINT32_C(0x0e40882b),
         UINT32_C(0x0e2c91d9),
         UINT32_C(0x04c0040e),
         UINT32_C(0x04ac1dfc),
         UINT32_C(0x0a808c25),
         UINT32_C(0x0aec95d7),
         UINT32_C(0x0bc0405f),
         UINT32_C(0x0bac59ad),
         UINT32_C(0x0580c874),
         UINT32_C(0x05ecd186),
         UINT32_C(0x0f004451),
         UINT32_C(0x0f6c5da3),
         UINT32_C(0x0140cc7a),
         UINT32_C(0x012cd588)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80360c),
         UINT32_C(0x3f872044),
         UINT32_C(0x3f871648),
         UINT32_C(0x3f826002),
         UINT32_C(0x3f82560e),
         UINT32_C(0x3f854046),
         UINT32_C(0x3f85764a),
         UINT32_C(0x3f85e020),
         UINT32_C(0x3f85d62c),
         UINT32_C(0x3f82c064),
         UINT32_C(0x3f82f668),
         UINT32_C(0x3f878022),
         UINT32_C(0x3f87b62e),
         UINT32_C(0x3f80a066),
         UINT32_C(0x3f80966a)},
        UINT32_C(0xfff80000),
        {0xb4,0x19,0x71,0x8c,0x48,0x30,0x79,0xde,0x01,0x63,
         0xe1,0x7e,0x4c,0xce,0x2f,0x84,0xe5,0x58,0x95,0xd4,0x00}
    },
    {
        /* No.146 delta:604 weight:1733 */
        11213,
        85,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0039c62e),
         UINT32_C(0xcd8ee945),
         UINT32_C(0xcdb72f6b),
         UINT32_C(0xba000927),
         UINT32_C(0xba39cf09),
         UINT32_C(0x778ee062),
         UINT32_C(0x77b7264c),
         UINT32_C(0x0000b53e),
         UINT32_C(0x00397310),
         UINT32_C(0xcd8e5c7b),
         UINT32_C(0xcdb79a55),
         UINT32_C(0xba00bc19),
         UINT32_C(0xba397a37),
         UINT32_C(0x778e555c),
         UINT32_C(0x77b79372)},
        {UINT32_C(0x00000000),
         UINT32_C(0x11048bfa),
         UINT32_C(0x3013f01d),
         UINT32_C(0x21177be7),
         UINT32_C(0x50006411),
         UINT32_C(0x4104efeb),
         UINT32_C(0x6013940c),
         UINT32_C(0x71171ff6),
         UINT32_C(0x6001209f),
         UINT32_C(0x7105ab65),
         UINT32_C(0x5012d082),
         UINT32_C(0x41165b78),
         UINT32_C(0x3001448e),
         UINT32_C(0x2105cf74),
         UINT32_C(0x0012b493),
         UINT32_C(0x11163f69)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f888245),
         UINT32_C(0x3f9809f8),
         UINT32_C(0x3f908bbd),
         UINT32_C(0x3fa80032),
         UINT32_C(0x3fa08277),
         UINT32_C(0x3fb009ca),
         UINT32_C(0x3fb88b8f),
         UINT32_C(0x3fb00090),
         UINT32_C(0x3fb882d5),
         UINT32_C(0x3fa80968),
         UINT32_C(0x3fa08b2d),
         UINT32_C(0x3f9800a2),
         UINT32_C(0x3f9082e7),
         UINT32_C(0x3f80095a),
         UINT32_C(0x3f888b1f)},
        UINT32_C(0xfff80000),
        {0x6c,0x4c,0x5a,0xeb,0x13,0x2e,0xdb,0xc6,0x8d,0x7c,
         0x6b,0xa3,0x75,0x22,0xa4,0x2d,0x14,0xbc,0xde,0x56,0x00}
    },
    {
        /* No.147 delta:960 weight:1163 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x43b4ae5b),
         UINT32_C(0x76e80719),
         UINT32_C(0x355ca942),
         UINT32_C(0xdf100930),
         UINT32_C(0x9ca4a76b),
         UINT32_C(0xa9f80e29),
         UINT32_C(0xea4ca072),
         UINT32_C(0x0000673e),
         UINT32_C(0x43b4c965),
         UINT32_C(0x76e86027),
         UINT32_C(0x355cce7c),
         UINT32_C(0xdf106e0e),
         UINT32_C(0x9ca4c055),
         UINT32_C(0xa9f86917),
         UINT32_C(0xea4cc74c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0005f1de),
         UINT32_C(0x00021107),
         UINT32_C(0x0007e0d9),
         UINT32_C(0x547e5191),
         UINT32_C(0x547ba04f),
         UINT32_C(0x547c4096),
         UINT32_C(0x5479b148),
         UINT32_C(0x8022012c),
         UINT32_C(0x8027f0f2),
         UINT32_C(0x8020102b),
         UINT32_C(0x8025e1f5),
         UINT32_C(0xd45c50bd),
         UINT32_C(0xd459a163),
         UINT32_C(0xd45e41ba),
         UINT32_C(0xd45bb064)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8002f8),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f8003f0),
         UINT32_C(0x3faa3f28),
         UINT32_C(0x3faa3dd0),
         UINT32_C(0x3faa3e20),
         UINT32_C(0x3faa3cd8),
         UINT32_C(0x3fc01100),
         UINT32_C(0x3fc013f8),
         UINT32_C(0x3fc01008),
         UINT32_C(0x3fc012f0),
         UINT32_C(0x3fea2e28),
         UINT32_C(0x3fea2cd0),
         UINT32_C(0x3fea2f20),
         UINT32_C(0x3fea2dd8)},
        UINT32_C(0xfff80000),
        {0x8a,0x3e,0x0b,0xb1,0x58,0x61,0xa0,0x53,0xdf,0xf6,
         0x62,0x32,0xbe,0x8c,0x82,0x52,0x0d,0x83,0x86,0x83,0x00}
    },
    {
        /* No.148 delta:901 weight:1609 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfb134e5d),
         UINT32_C(0x92dacb87),
         UINT32_C(0x69c985da),
         UINT32_C(0x1a50094b),
         UINT32_C(0xe1434716),
         UINT32_C(0x888ac2cc),
         UINT32_C(0x73998c91),
         UINT32_C(0x00000bda),
         UINT32_C(0xfb134587),
         UINT32_C(0x92dac05d),
         UINT32_C(0x69c98e00),
         UINT32_C(0x1a500291),
         UINT32_C(0xe1434ccc),
         UINT32_C(0x888ac916),
         UINT32_C(0x7399874b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4003bff3),
         UINT32_C(0x500059bf),
         UINT32_C(0x1003e64c),
         UINT32_C(0x30020205),
         UINT32_C(0x7001bdf6),
         UINT32_C(0x60025bba),
         UINT32_C(0x2001e449),
         UINT32_C(0x00026032),
         UINT32_C(0x4001dfc1),
         UINT32_C(0x5002398d),
         UINT32_C(0x1001867e),
         UINT32_C(0x30006237),
         UINT32_C(0x7003ddc4),
         UINT32_C(0x60003b88),
         UINT32_C(0x2003847b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa001df),
         UINT32_C(0x3fa8002c),
         UINT32_C(0x3f8801f3),
         UINT32_C(0x3f980101),
         UINT32_C(0x3fb800de),
         UINT32_C(0x3fb0012d),
         UINT32_C(0x3f9000f2),
         UINT32_C(0x3f800130),
         UINT32_C(0x3fa000ef),
         UINT32_C(0x3fa8011c),
         UINT32_C(0x3f8800c3),
         UINT32_C(0x3f980031),
         UINT32_C(0x3fb801ee),
         UINT32_C(0x3fb0001d),
         UINT32_C(0x3f9001c2)},
        UINT32_C(0xfff80000),
        {0xed,0x19,0x5c,0x48,0x36,0x04,0xa5,0x0d,0x32,0x2c,
         0x92,0xd7,0xf6,0x35,0x06,0x7d,0xb8,0x72,0x6a,0x9e,0x00}
    },
    {
        /* No.149 delta:1073 weight:1557 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xdd6ff907),
         UINT32_C(0x1b8687a5),
         UINT32_C(0xc6e97ea2),
         UINT32_C(0xa6200958),
         UINT32_C(0x7b4ff05f),
         UINT32_C(0xbda68efd),
         UINT32_C(0x60c977fa),
         UINT32_C(0x000050b0),
         UINT32_C(0xdd6fa9b7),
         UINT32_C(0x1b86d715),
         UINT32_C(0xc6e92e12),
         UINT32_C(0xa62059e8),
         UINT32_C(0x7b4fa0ef),
         UINT32_C(0xbda6de4d),
         UINT32_C(0x60c9274a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4014141a),
         UINT32_C(0x107ca00b),
         UINT32_C(0x5068b411),
         UINT32_C(0x00028813),
         UINT32_C(0x40169c09),
         UINT32_C(0x107e2818),
         UINT32_C(0x506a3c02),
         UINT32_C(0x1000116d),
         UINT32_C(0x50140577),
         UINT32_C(0x007cb166),
         UINT32_C(0x4068a57c),
         UINT32_C(0x1002997e),
         UINT32_C(0x50168d64),
         UINT32_C(0x007e3975),
         UINT32_C(0x406a2d6f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00a0a),
         UINT32_C(0x3f883e50),
         UINT32_C(0x3fa8345a),
         UINT32_C(0x3f800144),
         UINT32_C(0x3fa00b4e),
         UINT32_C(0x3f883f14),
         UINT32_C(0x3fa8351e),
         UINT32_C(0x3f880008),
         UINT32_C(0x3fa80a02),
         UINT32_C(0x3f803e58),
         UINT32_C(0x3fa03452),
         UINT32_C(0x3f88014c),
         UINT32_C(0x3fa80b46),
         UINT32_C(0x3f803f1c),
         UINT32_C(0x3fa03516)},
        UINT32_C(0xfff80000),
        {0xb2,0xbf,0x1a,0x47,0x01,0x3a,0x6d,0xd8,0xca,0x8c,
         0x43,0x5e,0x9e,0x18,0x90,0xa5,0x15,0x8d,0x50,0x00,0x00}
    },
    {
        /* No.150 delta:626 weight:1459 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd8f56f8e),
         UINT32_C(0xa51a2f65),
         UINT32_C(0x7def40eb),
         UINT32_C(0x0e800961),
         UINT32_C(0xd67566ef),
         UINT32_C(0xab9a2604),
         UINT32_C(0x736f498a),
         UINT32_C(0x00005f13),
         UINT32_C(0xd8f5309d),
         UINT32_C(0xa51a7076),
         UINT32_C(0x7def1ff8),
         UINT32_C(0x0e805672),
         UINT32_C(0xd67539fc),
         UINT32_C(0xab9a7917),
         UINT32_C(0x736f1699)},
        {UINT32_C(0x00000000),
         UINT32_C(0x406dc45a),
         UINT32_C(0x5011893c),
         UINT32_C(0x107c4d66),
         UINT32_C(0x004384ad),
         UINT32_C(0x402e40f7),
         UINT32_C(0x50520d91),
         UINT32_C(0x103fc9cb),
         UINT32_C(0x006340c9),
         UINT32_C(0x400e8493),
         UINT32_C(0x5072c9f5),
         UINT32_C(0x101f0daf),
         UINT32_C(0x0020c464),
         UINT32_C(0x404d003e),
         UINT32_C(0x50314d58),
         UINT32_C(0x105c8902)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa036e2),
         UINT32_C(0x3fa808c4),
         UINT32_C(0x3f883e26),
         UINT32_C(0x3f8021c2),
         UINT32_C(0x3fa01720),
         UINT32_C(0x3fa82906),
         UINT32_C(0x3f881fe4),
         UINT32_C(0x3f8031a0),
         UINT32_C(0x3fa00742),
         UINT32_C(0x3fa83964),
         UINT32_C(0x3f880f86),
         UINT32_C(0x3f801062),
         UINT32_C(0x3fa02680),
         UINT32_C(0x3fa818a6),
         UINT32_C(0x3f882e44)},
        UINT32_C(0xfff80000),
        {0x81,0x66,0xc0,0x11,0xf2,0x1e,0x67,0x18,0x8d,0x9f,
         0x75,0x54,0x6b,0x1a,0x5f,0x67,0xf0,0xe9,0x1a,0xdc,0x00}
    },
    {
        /* No.151 delta:787 weight:1455 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc047ffe2),
         UINT32_C(0xbb464990),
         UINT32_C(0x7b01b672),
         UINT32_C(0xb5900979),
         UINT32_C(0x75d7f69b),
         UINT32_C(0x0ed640e9),
         UINT32_C(0xce91bf0b),
         UINT32_C(0x0000a703),
         UINT32_C(0xc04758e1),
         UINT32_C(0xbb46ee93),
         UINT32_C(0x7b011171),
         UINT32_C(0xb590ae7a),
         UINT32_C(0x75d75198),
         UINT32_C(0x0ed6e7ea),
         UINT32_C(0xce911808)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0002a1fe),
         UINT32_C(0x700cbbd2),
         UINT32_C(0x700e1a2c),
         UINT32_C(0x40440016),
         UINT32_C(0x4046a1e8),
         UINT32_C(0x3048bbc4),
         UINT32_C(0x304a1a3a),
         UINT32_C(0x2001701b),
         UINT32_C(0x2003d1e5),
         UINT32_C(0x500dcbc9),
         UINT32_C(0x500f6a37),
         UINT32_C(0x6045700d),
         UINT32_C(0x6047d1f3),
         UINT32_C(0x1049cbdf),
         UINT32_C(0x104b6a21)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800150),
         UINT32_C(0x3fb8065d),
         UINT32_C(0x3fb8070d),
         UINT32_C(0x3fa02200),
         UINT32_C(0x3fa02350),
         UINT32_C(0x3f98245d),
         UINT32_C(0x3f98250d),
         UINT32_C(0x3f9000b8),
         UINT32_C(0x3f9001e8),
         UINT32_C(0x3fa806e5),
         UINT32_C(0x3fa807b5),
         UINT32_C(0x3fb022b8),
         UINT32_C(0x3fb023e8),
         UINT32_C(0x3f8824e5),
         UINT32_C(0x3f8825b5)},
        UINT32_C(0xfff80000),
        {0x02,0x9f,0x13,0x9e,0x40,0x74,0xd9,0x43,0xb3,0x32,
         0xf0,0x44,0x3a,0x4a,0xee,0xd4,0x2e,0x2a,0x08,0x78,0x00}
    },
    {
        /* No.152 delta:2273 weight:1239 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd3754bf9),
         UINT32_C(0x602e9050),
         UINT32_C(0xb35bdba9),
         UINT32_C(0x78100988),
         UINT32_C(0xab654271),
         UINT32_C(0x183e99d8),
         UINT32_C(0xcb4bd221),
         UINT32_C(0x0000d221),
         UINT32_C(0xd37599d8),
         UINT32_C(0x602e4271),
         UINT32_C(0xb35b0988),
         UINT32_C(0x7810dba9),
         UINT32_C(0xab659050),
         UINT32_C(0x183e4bf9),
         UINT32_C(0xcb4b0000)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2c855e1a),
         UINT32_C(0x38182087),
         UINT32_C(0x149d7e9d),
         UINT32_C(0xb0000011),
         UINT32_C(0x9c855e0b),
         UINT32_C(0x88182096),
         UINT32_C(0xa49d7e8c),
         UINT32_C(0x0a898a1e),
         UINT32_C(0x260cd404),
         UINT32_C(0x3291aa99),
         UINT32_C(0x1e14f483),
         UINT32_C(0xba898a0f),
         UINT32_C(0x960cd415),
         UINT32_C(0x8291aa88),
         UINT32_C(0xae14f492)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9642af),
         UINT32_C(0x3f9c0c10),
         UINT32_C(0x3f8a4ebf),
         UINT32_C(0x3fd80000),
         UINT32_C(0x3fce42af),
         UINT32_C(0x3fc40c10),
         UINT32_C(0x3fd24ebf),
         UINT32_C(0x3f8544c5),
         UINT32_C(0x3f93066a),
         UINT32_C(0x3f9948d5),
         UINT32_C(0x3f8f0a7a),
         UINT32_C(0x3fdd44c5),
         UINT32_C(0x3fcb066a),
         UINT32_C(0x3fc148d5),
         UINT32_C(0x3fd70a7a)},
        UINT32_C(0xfff80000),
        {0x74,0xe0,0xac,0xfc,0x8c,0x6a,0xf9,0x80,0x8c,0x13,
         0xa4,0xb5,0x63,0x77,0xdc,0xb5,0x3d,0xab,0x49,0xd7,0x00}
    },
    {
        /* No.153 delta:871 weight:1143 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfedc74b0),
         UINT32_C(0xaee6d14b),
         UINT32_C(0x503aa5fb),
         UINT32_C(0xce20099e),
         UINT32_C(0x30fc7d2e),
         UINT32_C(0x60c6d8d5),
         UINT32_C(0x9e1aac65),
         UINT32_C(0x0000ae3e),
         UINT32_C(0xfedcda8e),
         UINT32_C(0xaee67f75),
         UINT32_C(0x503a0bc5),
         UINT32_C(0xce20a7a0),
         UINT32_C(0x30fcd310),
         UINT32_C(0x60c676eb),
         UINT32_C(0x9e1a025b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00545892),
         UINT32_C(0x0002459d),
         UINT32_C(0x00561d0f),
         UINT32_C(0x4200321a),
         UINT32_C(0x42546a88),
         UINT32_C(0x42027787),
         UINT32_C(0x42562f15),
         UINT32_C(0xa010630e),
         UINT32_C(0xa0443b9c),
         UINT32_C(0xa0122693),
         UINT32_C(0xa0467e01),
         UINT32_C(0xe2105114),
         UINT32_C(0xe2440986),
         UINT32_C(0xe2121489),
         UINT32_C(0xe2464c1b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a2c),
         UINT32_C(0x3f800122),
         UINT32_C(0x3f802b0e),
         UINT32_C(0x3fa10019),
         UINT32_C(0x3fa12a35),
         UINT32_C(0x3fa1013b),
         UINT32_C(0x3fa12b17),
         UINT32_C(0x3fd00831),
         UINT32_C(0x3fd0221d),
         UINT32_C(0x3fd00913),
         UINT32_C(0x3fd0233f),
         UINT32_C(0x3ff10828),
         UINT32_C(0x3ff12204),
         UINT32_C(0x3ff1090a),
         UINT32_C(0x3ff12326)},
        UINT32_C(0xfff80000),
        {0x78,0xb7,0xc4,0x5a,0x2d,0x30,0xeb,0xa8,0x00,0xa7,
         0xd4,0x75,0x85,0x8f,0x9c,0x97,0x0c,0x23,0x95,0xb0,0x00}
    },
    {
        /* No.154 delta:680 weight:1645 */
        11213,
        92,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf2f6c7de),
         UINT32_C(0xab19ce85),
         UINT32_C(0x59ef095b),
         UINT32_C(0xbc3009a5),
         UINT32_C(0x4ec6ce7b),
         UINT32_C(0x1729c720),
         UINT32_C(0xe5df00fe),
         UINT32_C(0x00004ae2),
         UINT32_C(0xf2f68d3c),
         UINT32_C(0xab198467),
         UINT32_C(0x59ef43b9),
         UINT32_C(0xbc304347),
         UINT32_C(0x4ec68499),
         UINT32_C(0x17298dc2),
         UINT32_C(0xe5df4a1c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6074301d),
         UINT32_C(0x0050108c),
         UINT32_C(0x60242091),
         UINT32_C(0x0024ac05),
         UINT32_C(0x60509c18),
         UINT32_C(0x0074bc89),
         UINT32_C(0x60008c94),
         UINT32_C(0x20092003),
         UINT32_C(0x407d101e),
         UINT32_C(0x2059308f),
         UINT32_C(0x402d0092),
         UINT32_C(0x202d8c06),
         UINT32_C(0x4059bc1b),
         UINT32_C(0x207d9c8a),
         UINT32_C(0x4009ac97)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb03a18),
         UINT32_C(0x3f802808),
         UINT32_C(0x3fb01210),
         UINT32_C(0x3f801256),
         UINT32_C(0x3fb0284e),
         UINT32_C(0x3f803a5e),
         UINT32_C(0x3fb00046),
         UINT32_C(0x3f900490),
         UINT32_C(0x3fa03e88),
         UINT32_C(0x3f902c98),
         UINT32_C(0x3fa01680),
         UINT32_C(0x3f9016c6),
         UINT32_C(0x3fa02cde),
         UINT32_C(0x3f903ece),
         UINT32_C(0x3fa004d6)},
        UINT32_C(0xfff80000),
        {0xec,0x69,0xee,0x1e,0xad,0x69,0x24,0x8c,0xc7,0x98,
         0x5a,0xd4,0x98,0xfd,0xb3,0xc1,0xe0,0xfa,0x9e,0xf3,0x00}
    },
    {
        /* No.155 delta:1483 weight:1731 */
        11213,
        16,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6773f0aa),
         UINT32_C(0xe4e35e87),
         UINT32_C(0x8390ae2d),
         UINT32_C(0xeb2009b3),
         UINT32_C(0x8c53f919),
         UINT32_C(0x0fc35734),
         UINT32_C(0x68b0a79e),
         UINT32_C(0x0000f41b),
         UINT32_C(0x677304b1),
         UINT32_C(0xe4e3aa9c),
         UINT32_C(0x83905a36),
         UINT32_C(0xeb20fda8),
         UINT32_C(0x8c530d02),
         UINT32_C(0x0fc3a32f),
         UINT32_C(0x68b05385)},
        {UINT32_C(0x00000000),
         UINT32_C(0x082689de),
         UINT32_C(0x40412a3b),
         UINT32_C(0x4867a3e5),
         UINT32_C(0x003b7a17),
         UINT32_C(0x081df3c9),
         UINT32_C(0x407a502c),
         UINT32_C(0x485cd9f2),
         UINT32_C(0x4006001d),
         UINT32_C(0x482089c3),
         UINT32_C(0x00472a26),
         UINT32_C(0x0861a3f8),
         UINT32_C(0x403d7a0a),
         UINT32_C(0x481bf3d4),
         UINT32_C(0x007c5031),
         UINT32_C(0x085ad9ef)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841344),
         UINT32_C(0x3fa02095),
         UINT32_C(0x3fa433d1),
         UINT32_C(0x3f801dbd),
         UINT32_C(0x3f840ef9),
         UINT32_C(0x3fa03d28),
         UINT32_C(0x3fa42e6c),
         UINT32_C(0x3fa00300),
         UINT32_C(0x3fa41044),
         UINT32_C(0x3f802395),
         UINT32_C(0x3f8430d1),
         UINT32_C(0x3fa01ebd),
         UINT32_C(0x3fa40df9),
         UINT32_C(0x3f803e28),
         UINT32_C(0x3f842d6c)},
        UINT32_C(0xfff80000),
        {0x91,0x6b,0x3e,0xd5,0xba,0xef,0xf4,0xa8,0xf8,0x4f,
         0x70,0xfd,0x6c,0x0f,0x76,0x88,0xd4,0x1d,0xcf,0x43,0x00}
    },
    {
        /* No.156 delta:733 weight:1193 */
        11213,
        60,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc46496aa),
         UINT32_C(0x6333d0ee),
         UINT32_C(0xa7574644),
         UINT32_C(0xd33009c1),
         UINT32_C(0x17549f6b),
         UINT32_C(0xb003d92f),
         UINT32_C(0x74674f85),
         UINT32_C(0x00005202),
         UINT32_C(0xc464c4a8),
         UINT32_C(0x633382ec),
         UINT32_C(0xa7571446),
         UINT32_C(0xd3305bc3),
         UINT32_C(0x1754cd69),
         UINT32_C(0xb0038b2d),
         UINT32_C(0x74671d87)},
        {UINT32_C(0x00000000),
         UINT32_C(0x106c1592),
         UINT32_C(0xc034481b),
         UINT32_C(0xd0585d89),
         UINT32_C(0x1110946a),
         UINT32_C(0x017c81f8),
         UINT32_C(0xd124dc71),
         UINT32_C(0xc148c9e3),
         UINT32_C(0x2062041e),
         UINT32_C(0x300e118c),
         UINT32_C(0xe0564c05),
         UINT32_C(0xf03a5997),
         UINT32_C(0x31729074),
         UINT32_C(0x211e85e6),
         UINT32_C(0xf146d86f),
         UINT32_C(0xe12acdfd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f88360a),
         UINT32_C(0x3fe01a24),
         UINT32_C(0x3fe82c2e),
         UINT32_C(0x3f88884a),
         UINT32_C(0x3f80be40),
         UINT32_C(0x3fe8926e),
         UINT32_C(0x3fe0a464),
         UINT32_C(0x3f903102),
         UINT32_C(0x3f980708),
         UINT32_C(0x3ff02b26),
         UINT32_C(0x3ff81d2c),
         UINT32_C(0x3f98b948),
         UINT32_C(0x3f908f42),
         UINT32_C(0x3ff8a36c),
         UINT32_C(0x3ff09566)},
        UINT32_C(0xfff80000),
        {0xfb,0x19,0xfa,0xea,0x83,0x92,0x82,0x21,0xbb,0x01,
         0xbd,0xb5,0xbd,0xca,0xb0,0xf6,0x77,0x93,0x35,0xe5,0x00}
    },
    {
        /* No.157 delta:880 weight:975 */
        11213,
        89,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb3f72ee5),
         UINT32_C(0x0d4a781f),
         UINT32_C(0xbebd56fa),
         UINT32_C(0x32e009d2),
         UINT32_C(0x81172737),
         UINT32_C(0x3faa71cd),
         UINT32_C(0x8c5d5f28),
         UINT32_C(0x00008f44),
         UINT32_C(0xb3f7a1a1),
         UINT32_C(0x0d4af75b),
         UINT32_C(0xbebdd9be),
         UINT32_C(0x32e08696),
         UINT32_C(0x8117a873),
         UINT32_C(0x3faafe89),
         UINT32_C(0x8c5dd06c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1160d07b),
         UINT32_C(0x3980408e),
         UINT32_C(0x28e090f5),
         UINT32_C(0x0e5100d7),
         UINT32_C(0x1f31d0ac),
         UINT32_C(0x37d14059),
         UINT32_C(0x26b19022),
         UINT32_C(0x43c8e012),
         UINT32_C(0x52a83069),
         UINT32_C(0x7a48a09c),
         UINT32_C(0x6b2870e7),
         UINT32_C(0x4d99e0c5),
         UINT32_C(0x5cf930be),
         UINT32_C(0x7419a04b),
         UINT32_C(0x65797030)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f88b068),
         UINT32_C(0x3f9cc020),
         UINT32_C(0x3f947048),
         UINT32_C(0x3f872880),
         UINT32_C(0x3f8f98e8),
         UINT32_C(0x3f9be8a0),
         UINT32_C(0x3f9358c8),
         UINT32_C(0x3fa1e470),
         UINT32_C(0x3fa95418),
         UINT32_C(0x3fbd2450),
         UINT32_C(0x3fb59438),
         UINT32_C(0x3fa6ccf0),
         UINT32_C(0x3fae7c98),
         UINT32_C(0x3fba0cd0),
         UINT32_C(0x3fb2bcb8)},
        UINT32_C(0xfff80000),
        {0xe8,0x4a,0xb3,0x87,0xe1,0x48,0xc9,0x8e,0xef,0x24,
         0x1e,0xda,0x9b,0x0f,0x74,0x19,0x5e,0x98,0x31,0xf0,0x00}
    },
    {
        /* No.158 delta:663 weight:1719 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x403d0e8e),
         UINT32_C(0x336bfa3e),
         UINT32_C(0x7356f4b0),
         UINT32_C(0xd48009e9),
         UINT32_C(0x94bd0767),
         UINT32_C(0xe7ebf3d7),
         UINT32_C(0xa7d6fd59),
         UINT32_C(0x00000ddd),
         UINT32_C(0x403d0353),
         UINT32_C(0x336bf7e3),
         UINT32_C(0x7356f96d),
         UINT32_C(0xd4800434),
         UINT32_C(0x94bd0aba),
         UINT32_C(0xe7ebfe0a),
         UINT32_C(0xa7d6f084)},
        {UINT32_C(0x00000000),
         UINT32_C(0x501a59b6),
         UINT32_C(0x7004582a),
         UINT32_C(0x201e019c),
         UINT32_C(0x000325ad),
         UINT32_C(0x50197c1b),
         UINT32_C(0x70077d87),
         UINT32_C(0x201d2431),
         UINT32_C(0x30544063),
         UINT32_C(0x604e19d5),
         UINT32_C(0x40501849),
         UINT32_C(0x104a41ff),
         UINT32_C(0x305765ce),
         UINT32_C(0x604d3c78),
         UINT32_C(0x40533de4),
         UINT32_C(0x10496452)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa80d2c),
         UINT32_C(0x3fb8022c),
         UINT32_C(0x3f900f00),
         UINT32_C(0x3f800192),
         UINT32_C(0x3fa80cbe),
         UINT32_C(0x3fb803be),
         UINT32_C(0x3f900e92),
         UINT32_C(0x3f982a20),
         UINT32_C(0x3fb0270c),
         UINT32_C(0x3fa0280c),
         UINT32_C(0x3f882520),
         UINT32_C(0x3f982bb2),
         UINT32_C(0x3fb0269e),
         UINT32_C(0x3fa0299e),
         UINT32_C(0x3f8824b2)},
        UINT32_C(0xfff80000),
        {0xed,0xea,0xb8,0x18,0xc8,0x76,0x78,0xc5,0x42,0x78,
         0x5e,0xb8,0xe7,0x06,0xb4,0xbf,0x24,0x82,0xa2,0x30,0x00}
    },
    {
        /* No.159 delta:1845 weight:1483 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4d99df0f),
         UINT32_C(0x05f964c0),
         UINT32_C(0x4860bbcf),
         UINT32_C(0xbee009fc),
         UINT32_C(0xf379d6f3),
         UINT32_C(0xbb196d3c),
         UINT32_C(0xf680b233),
         UINT32_C(0x00007b31),
         UINT32_C(0x4d99a43e),
         UINT32_C(0x05f91ff1),
         UINT32_C(0x4860c0fe),
         UINT32_C(0xbee072cd),
         UINT32_C(0xf379adc2),
         UINT32_C(0xbb19160d),
         UINT32_C(0xf680c902)},
        {UINT32_C(0x00000000),
         UINT32_C(0x58cc8356),
         UINT32_C(0x26780415),
         UINT32_C(0x7eb48743),
         UINT32_C(0x4200501f),
         UINT32_C(0x1accd349),
         UINT32_C(0x6478540a),
         UINT32_C(0x3cb4d75c),
         UINT32_C(0x081541f4),
         UINT32_C(0x50d9c2a2),
         UINT32_C(0x2e6d45e1),
         UINT32_C(0x76a1c6b7),
         UINT32_C(0x4a1511eb),
         UINT32_C(0x12d992bd),
         UINT32_C(0x6c6d15fe),
         UINT32_C(0x34a196a8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fac6641),
         UINT32_C(0x3f933c02),
         UINT32_C(0x3fbf5a43),
         UINT32_C(0x3fa10028),
         UINT32_C(0x3f8d6669),
         UINT32_C(0x3fb23c2a),
         UINT32_C(0x3f9e5a6b),
         UINT32_C(0x3f840aa0),
         UINT32_C(0x3fa86ce1),
         UINT32_C(0x3f9736a2),
         UINT32_C(0x3fbb50e3),
         UINT32_C(0x3fa50a88),
         UINT32_C(0x3f896cc9),
         UINT32_C(0x3fb6368a),
         UINT32_C(0x3f9a50cb)},
        UINT32_C(0xfff80000),
        {0xe0,0x6e,0xee,0x13,0x9c,0xda,0xb8,0x10,0x90,0x8b,
         0x5f,0x38,0x70,0xda,0x77,0xae,0x88,0x80,0xfa,0x25,0x00}
    },
    {
        /* No.160 delta:701 weight:1237 */
        11213,
        72,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x533b8e4b),
         UINT32_C(0x04e41c3b),
         UINT32_C(0x57df9270),
         UINT32_C(0x93200a0c),
         UINT32_C(0xc01b8447),
         UINT32_C(0x97c41637),
         UINT32_C(0xc4ff987c),
         UINT32_C(0x00001b54),
         UINT32_C(0x533b951f),
         UINT32_C(0x04e4076f),
         UINT32_C(0x57df8924),
         UINT32_C(0x93201158),
         UINT32_C(0xc01b9f13),
         UINT32_C(0x97c40d63),
         UINT32_C(0xc4ff8328)},
        {UINT32_C(0x00000000),
         UINT32_C(0x106fb1bd),
         UINT32_C(0x9040018f),
         UINT32_C(0x802fb032),
         UINT32_C(0x5032405b),
         UINT32_C(0x405df1e6),
         UINT32_C(0xc07241d4),
         UINT32_C(0xd01df069),
         UINT32_C(0x004a780e),
         UINT32_C(0x1025c9b3),
         UINT32_C(0x900a7981),
         UINT32_C(0x8065c83c),
         UINT32_C(0x50783855),
         UINT32_C(0x401789e8),
         UINT32_C(0xc03839da),
         UINT32_C(0xd0578867)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8837d8),
         UINT32_C(0x3fc82000),
         UINT32_C(0x3fc017d8),
         UINT32_C(0x3fa81920),
         UINT32_C(0x3fa02ef8),
         UINT32_C(0x3fe03920),
         UINT32_C(0x3fe80ef8),
         UINT32_C(0x3f80253c),
         UINT32_C(0x3f8812e4),
         UINT32_C(0x3fc8053c),
         UINT32_C(0x3fc032e4),
         UINT32_C(0x3fa83c1c),
         UINT32_C(0x3fa00bc4),
         UINT32_C(0x3fe01c1c),
         UINT32_C(0x3fe82bc4)},
        UINT32_C(0xfff80000),
        {0x7e,0x9c,0x0e,0x2e,0x61,0x72,0xa8,0x37,0x50,0x74,
         0xe3,0xa9,0x39,0xd8,0x5e,0x44,0xd8,0xaa,0x0a,0x3a,0x00}
    },
    {
        /* No.161 delta:1210 weight:1361 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xda18d8f3),
         UINT32_C(0x864b1d8a),
         UINT32_C(0x5c53c579),
         UINT32_C(0x8ff00a12),
         UINT32_C(0x55e8d2e1),
         UINT32_C(0x09bb1798),
         UINT32_C(0xd3a3cf6b),
         UINT32_C(0x00000ad1),
         UINT32_C(0xda18d222),
         UINT32_C(0x864b175b),
         UINT32_C(0x5c53cfa8),
         UINT32_C(0x8ff000c3),
         UINT32_C(0x55e8d830),
         UINT32_C(0x09bb1d49),
         UINT32_C(0xd3a3c5ba)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006d79f2),
         UINT32_C(0x0052d5c7),
         UINT32_C(0x003fac35),
         UINT32_C(0x0009b6eb),
         UINT32_C(0x0064cf19),
         UINT32_C(0x005b632c),
         UINT32_C(0x00361ade),
         UINT32_C(0x4201ac05),
         UINT32_C(0x426cd5f7),
         UINT32_C(0x425379c2),
         UINT32_C(0x423e0030),
         UINT32_C(0x42081aee),
         UINT32_C(0x4265631c),
         UINT32_C(0x425acf29),
         UINT32_C(0x4237b6db)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8036bc),
         UINT32_C(0x3f80296a),
         UINT32_C(0x3f801fd6),
         UINT32_C(0x3f8004db),
         UINT32_C(0x3f803267),
         UINT32_C(0x3f802db1),
         UINT32_C(0x3f801b0d),
         UINT32_C(0x3fa100d6),
         UINT32_C(0x3fa1366a),
         UINT32_C(0x3fa129bc),
         UINT32_C(0x3fa11f00),
         UINT32_C(0x3fa1040d),
         UINT32_C(0x3fa132b1),
         UINT32_C(0x3fa12d67),
         UINT32_C(0x3fa11bdb)},
        UINT32_C(0xfff80000),
        {0xca,0x08,0xd3,0xcf,0xb4,0x8a,0x29,0x9a,0x0c,0xbf,
         0xff,0x3b,0x35,0x66,0x50,0x68,0xc1,0x0b,0x60,0xef,0x00}
    },
    {
        /* No.162 delta:795 weight:1449 */
        11213,
        54,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbcdfb5d0),
         UINT32_C(0xc8fddc0c),
         UINT32_C(0x742269dc),
         UINT32_C(0xbca00a22),
         UINT32_C(0x007fbff2),
         UINT32_C(0x745dd62e),
         UINT32_C(0xc88263fe),
         UINT32_C(0x0000e6c3),
         UINT32_C(0xbcdf5313),
         UINT32_C(0xc8fd3acf),
         UINT32_C(0x74228f1f),
         UINT32_C(0xbca0ece1),
         UINT32_C(0x007f5931),
         UINT32_C(0x745d30ed),
         UINT32_C(0xc882853d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00124092),
         UINT32_C(0x200000f4),
         UINT32_C(0x20124066),
         UINT32_C(0x1001919b),
         UINT32_C(0x1013d109),
         UINT32_C(0x3001916f),
         UINT32_C(0x3013d1fd),
         UINT32_C(0x90006878),
         UINT32_C(0x901228ea),
         UINT32_C(0xb000688c),
         UINT32_C(0xb012281e),
         UINT32_C(0x8001f9e3),
         UINT32_C(0x8013b971),
         UINT32_C(0xa001f917),
         UINT32_C(0xa013b985)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800920),
         UINT32_C(0x3f900000),
         UINT32_C(0x3f900920),
         UINT32_C(0x3f8800c8),
         UINT32_C(0x3f8809e8),
         UINT32_C(0x3f9800c8),
         UINT32_C(0x3f9809e8),
         UINT32_C(0x3fc80034),
         UINT32_C(0x3fc80914),
         UINT32_C(0x3fd80034),
         UINT32_C(0x3fd80914),
         UINT32_C(0x3fc000fc),
         UINT32_C(0x3fc009dc),
         UINT32_C(0x3fd000fc),
         UINT32_C(0x3fd009dc)},
        UINT32_C(0xfff80000),
        {0x72,0xc8,0xed,0xae,0x2a,0x9b,0xef,0x90,0x98,0x10,
         0x0e,0xa2,0x98,0x6e,0xc4,0x9f,0x4e,0x30,0x0c,0x95,0x00}
    },
    {
        /* No.163 delta:2431 weight:1043 */
        11213,
        6,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x22ab4cf9),
         UINT32_C(0x4d93d360),
         UINT32_C(0x6f389f99),
         UINT32_C(0xe3e00a3f),
         UINT32_C(0xc14b46c6),
         UINT32_C(0xae73d95f),
         UINT32_C(0x8cd895a6),
         UINT32_C(0x0000213d),
         UINT32_C(0x22ab6dc4),
         UINT32_C(0x4d93f25d),
         UINT32_C(0x6f38bea4),
         UINT32_C(0xe3e02b02),
         UINT32_C(0xc14b67fb),
         UINT32_C(0xae73f862),
         UINT32_C(0x8cd8b49b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9eb058d6),
         UINT32_C(0xe1c02c0f),
         UINT32_C(0x7f7074d9),
         UINT32_C(0x70888d5e),
         UINT32_C(0xee38d588),
         UINT32_C(0x9148a151),
         UINT32_C(0x0ff8f987),
         UINT32_C(0x16084c1b),
         UINT32_C(0x88b814cd),
         UINT32_C(0xf7c86014),
         UINT32_C(0x697838c2),
         UINT32_C(0x6680c145),
         UINT32_C(0xf8309993),
         UINT32_C(0x8740ed4a),
         UINT32_C(0x19f0b59c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fcf582c),
         UINT32_C(0x3ff0e016),
         UINT32_C(0x3fbfb83a),
         UINT32_C(0x3fb84446),
         UINT32_C(0x3ff71c6a),
         UINT32_C(0x3fc8a450),
         UINT32_C(0x3f87fc7c),
         UINT32_C(0x3f8b0426),
         UINT32_C(0x3fc45c0a),
         UINT32_C(0x3ffbe430),
         UINT32_C(0x3fb4bc1c),
         UINT32_C(0x3fb34060),
         UINT32_C(0x3ffc184c),
         UINT32_C(0x3fc3a076),
         UINT32_C(0x3f8cf85a)},
        UINT32_C(0xfff80000),
        {0xd2,0x4a,0xaf,0xe3,0x55,0xc3,0xfa,0x9a,0x5e,0xb9,
         0xbc,0x94,0x33,0xf2,0x6c,0xa1,0xee,0xc7,0xa1,0x72,0x00}
    },
    {
        /* No.164 delta:2864 weight:779 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x930e07df),
         UINT32_C(0xe7b13610),
         UINT32_C(0x74bf31cf),
         UINT32_C(0x3b500a4f),
         UINT32_C(0xa85e0d90),
         UINT32_C(0xdce13c5f),
         UINT32_C(0x4fef3b80),
         UINT32_C(0x0000c7c0),
         UINT32_C(0x930ec01f),
         UINT32_C(0xe7b1f1d0),
         UINT32_C(0x74bff60f),
         UINT32_C(0x3b50cd8f),
         UINT32_C(0xa85eca50),
         UINT32_C(0xdce1fb9f),
         UINT32_C(0x4feffc40)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9e6701be),
         UINT32_C(0x3079c5f2),
         UINT32_C(0xae1ec44c),
         UINT32_C(0x1220219b),
         UINT32_C(0x8c472025),
         UINT32_C(0x2259e469),
         UINT32_C(0xbc3ee5d7),
         UINT32_C(0x08808d8e),
         UINT32_C(0x96e78c30),
         UINT32_C(0x38f9487c),
         UINT32_C(0xa69e49c2),
         UINT32_C(0x1aa0ac15),
         UINT32_C(0x84c7adab),
         UINT32_C(0x2ad969e7),
         UINT32_C(0xb4be6859)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fcf3380),
         UINT32_C(0x3f983ce2),
         UINT32_C(0x3fd70f62),
         UINT32_C(0x3f891010),
         UINT32_C(0x3fc62390),
         UINT32_C(0x3f912cf2),
         UINT32_C(0x3fde1f72),
         UINT32_C(0x3f844046),
         UINT32_C(0x3fcb73c6),
         UINT32_C(0x3f9c7ca4),
         UINT32_C(0x3fd34f24),
         UINT32_C(0x3f8d5056),
         UINT32_C(0x3fc263d6),
         UINT32_C(0x3f956cb4),
         UINT32_C(0x3fda5f34)},
        UINT32_C(0xfff80000),
        {0x6e,0x02,0x89,0x09,0x39,0xd5,0xf9,0x3d,0x6d,0x6b,
         0x67,0x1e,0x31,0x28,0x71,0xbd,0x6d,0xf7,0xbd,0x39,0x00}
    },
    {
        /* No.165 delta:1244 weight:1685 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x255f9767),
         UINT32_C(0xd34967dc),
         UINT32_C(0xf616f0bb),
         UINT32_C(0x64000a53),
         UINT32_C(0x415f9d34),
         UINT32_C(0xb7496d8f),
         UINT32_C(0x9216fae8),
         UINT32_C(0x0000db64),
         UINT32_C(0x255f4c03),
         UINT32_C(0xd349bcb8),
         UINT32_C(0xf6162bdf),
         UINT32_C(0x6400d137),
         UINT32_C(0x415f4650),
         UINT32_C(0xb749b6eb),
         UINT32_C(0x9216218c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40245894),
         UINT32_C(0xc0466d97),
         UINT32_C(0x80623503),
         UINT32_C(0x00450011),
         UINT32_C(0x40615885),
         UINT32_C(0xc0036d86),
         UINT32_C(0x80273512),
         UINT32_C(0x0002440b),
         UINT32_C(0x40261c9f),
         UINT32_C(0xc044299c),
         UINT32_C(0x80607108),
         UINT32_C(0x0047441a),
         UINT32_C(0x40631c8e),
         UINT32_C(0xc001298d),
         UINT32_C(0x80257119)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0122c),
         UINT32_C(0x3fe02336),
         UINT32_C(0x3fc0311a),
         UINT32_C(0x3f802280),
         UINT32_C(0x3fa030ac),
         UINT32_C(0x3fe001b6),
         UINT32_C(0x3fc0139a),
         UINT32_C(0x3f800122),
         UINT32_C(0x3fa0130e),
         UINT32_C(0x3fe02214),
         UINT32_C(0x3fc03038),
         UINT32_C(0x3f8023a2),
         UINT32_C(0x3fa0318e),
         UINT32_C(0x3fe00094),
         UINT32_C(0x3fc012b8)},
        UINT32_C(0xfff80000),
        {0x24,0x46,0xd1,0x9b,0xe1,0xfc,0x9e,0xe4,0xef,0xb2,
         0x97,0x74,0xdc,0x89,0x9d,0x7b,0xbc,0x51,0x66,0xeb,0x00}
    },
    {
        /* No.166 delta:975 weight:1321 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9eebf48a),
         UINT32_C(0xc2268cb3),
         UINT32_C(0x5ccd7839),
         UINT32_C(0xf3d00a66),
         UINT32_C(0x6d3bfeec),
         UINT32_C(0x31f686d5),
         UINT32_C(0xaf1d725f),
         UINT32_C(0x000006fd),
         UINT32_C(0x9eebf277),
         UINT32_C(0xc2268a4e),
         UINT32_C(0x5ccd7ec4),
         UINT32_C(0xf3d00c9b),
         UINT32_C(0x6d3bf811),
         UINT32_C(0x31f68028),
         UINT32_C(0xaf1d74a2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6041241e),
         UINT32_C(0x40030919),
         UINT32_C(0x20422d07),
         UINT32_C(0x203c71f4),
         UINT32_C(0x407d55ea),
         UINT32_C(0x603f78ed),
         UINT32_C(0x007e5cf3),
         UINT32_C(0x4020680b),
         UINT32_C(0x20614c15),
         UINT32_C(0x00236112),
         UINT32_C(0x6062450c),
         UINT32_C(0x601c19ff),
         UINT32_C(0x005d3de1),
         UINT32_C(0x201f10e6),
         UINT32_C(0x405e34f8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb02092),
         UINT32_C(0x3fa00184),
         UINT32_C(0x3f902116),
         UINT32_C(0x3f901e38),
         UINT32_C(0x3fa03eaa),
         UINT32_C(0x3fb01fbc),
         UINT32_C(0x3f803f2e),
         UINT32_C(0x3fa01034),
         UINT32_C(0x3f9030a6),
         UINT32_C(0x3f8011b0),
         UINT32_C(0x3fb03122),
         UINT32_C(0x3fb00e0c),
         UINT32_C(0x3f802e9e),
         UINT32_C(0x3f900f88),
         UINT32_C(0x3fa02f1a)},
        UINT32_C(0xfff80000),
        {0x66,0x41,0xa4,0xda,0xc7,0xc0,0x9a,0x46,0x41,0x04,
         0x63,0x70,0x97,0xc0,0x79,0xcd,0xc4,0xe3,0x25,0x6c,0x00}
    },
    {
        /* No.167 delta:822 weight:1569 */
        11213,
        61,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x82155f47),
         UINT32_C(0x6ecf1b68),
         UINT32_C(0xecda442f),
         UINT32_C(0x26b00a77),
         UINT32_C(0xa4a55530),
         UINT32_C(0x487f111f),
         UINT32_C(0xca6a4e58),
         UINT32_C(0x0000b1cf),
         UINT32_C(0x8215ee88),
         UINT32_C(0x6ecfaaa7),
         UINT32_C(0xecdaf5e0),
         UINT32_C(0x26b0bbb8),
         UINT32_C(0xa4a5e4ff),
         UINT32_C(0x487fa0d0),
         UINT32_C(0xca6aff97)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00741c12),
         UINT32_C(0x002010e6),
         UINT32_C(0x00540cf4),
         UINT32_C(0x10038215),
         UINT32_C(0x10779e07),
         UINT32_C(0x102392f3),
         UINT32_C(0x10578ee1),
         UINT32_C(0x2001820e),
         UINT32_C(0x20759e1c),
         UINT32_C(0x202192e8),
         UINT32_C(0x20558efa),
         UINT32_C(0x3002001b),
         UINT32_C(0x30761c09),
         UINT32_C(0x302210fd),
         UINT32_C(0x30560cef)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a0e),
         UINT32_C(0x3f801008),
         UINT32_C(0x3f802a06),
         UINT32_C(0x3f8801c1),
         UINT32_C(0x3f883bcf),
         UINT32_C(0x3f8811c9),
         UINT32_C(0x3f882bc7),
         UINT32_C(0x3f9000c1),
         UINT32_C(0x3f903acf),
         UINT32_C(0x3f9010c9),
         UINT32_C(0x3f902ac7),
         UINT32_C(0x3f980100),
         UINT32_C(0x3f983b0e),
         UINT32_C(0x3f981108),
         UINT32_C(0x3f982b06)},
        UINT32_C(0xfff80000),
        {0x0b,0x4f,0x62,0x95,0x75,0x0b,0x08,0x87,0xec,0x7c,
         0xff,0x1c,0xaa,0xf5,0x0c,0x88,0xa4,0xcf,0x35,0x71,0x00}
    },
    {
        /* No.168 delta:2479 weight:1075 */
        11213,
        6,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb2b1de9a),
         UINT32_C(0x3cd6fd93),
         UINT32_C(0x8e672309),
         UINT32_C(0x66a00a8a),
         UINT32_C(0xd411d410),
         UINT32_C(0x5a76f719),
         UINT32_C(0xe8c72983),
         UINT32_C(0x0000316f),
         UINT32_C(0xb2b1eff5),
         UINT32_C(0x3cd6ccfc),
         UINT32_C(0x8e671266),
         UINT32_C(0x66a03be5),
         UINT32_C(0xd411e57f),
         UINT32_C(0x5a76c676),
         UINT32_C(0xe8c718ec)},
        {UINT32_C(0x00000000),
         UINT32_C(0xf87321b4),
         UINT32_C(0x0215c11e),
         UINT32_C(0xfa66e0aa),
         UINT32_C(0x30c06818),
         UINT32_C(0xc8b349ac),
         UINT32_C(0x32d5a906),
         UINT32_C(0xcaa688b2),
         UINT32_C(0x30b60413),
         UINT32_C(0xc8c525a7),
         UINT32_C(0x32a3c50d),
         UINT32_C(0xcad0e4b9),
         UINT32_C(0x00766c0b),
         UINT32_C(0xf8054dbf),
         UINT32_C(0x0263ad15),
         UINT32_C(0xfa108ca1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ffc3990),
         UINT32_C(0x3f810ae0),
         UINT32_C(0x3ffd3370),
         UINT32_C(0x3f986034),
         UINT32_C(0x3fe459a4),
         UINT32_C(0x3f996ad4),
         UINT32_C(0x3fe55344),
         UINT32_C(0x3f985b02),
         UINT32_C(0x3fe46292),
         UINT32_C(0x3f9951e2),
         UINT32_C(0x3fe56872),
         UINT32_C(0x3f803b36),
         UINT32_C(0x3ffc02a6),
         UINT32_C(0x3f8131d6),
         UINT32_C(0x3ffd0846)},
        UINT32_C(0xfff80000),
        {0xe2,0xcf,0x0e,0x1e,0xa2,0xe7,0xf0,0xe2,0x9d,0x80,
         0x77,0xba,0xb6,0x20,0xa9,0x8a,0x3c,0xfe,0xda,0x1d,0x00}
    },
    {
        /* No.169 delta:1568 weight:1675 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xccc1bd43),
         UINT32_C(0x3fe6a0cd),
         UINT32_C(0xf3271d8e),
         UINT32_C(0x46b00a9e),
         UINT32_C(0x8a71b7dd),
         UINT32_C(0x7956aa53),
         UINT32_C(0xb5971710),
         UINT32_C(0x00006731),
         UINT32_C(0xccc1da72),
         UINT32_C(0x3fe6c7fc),
         UINT32_C(0xf3277abf),
         UINT32_C(0x46b06daf),
         UINT32_C(0x8a71d0ec),
         UINT32_C(0x7956cd62),
         UINT32_C(0xb5977021)},
        {UINT32_C(0x00000000),
         UINT32_C(0x08811f14),
         UINT32_C(0x011d01d1),
         UINT32_C(0x099c1ec5),
         UINT32_C(0x8006ce1f),
         UINT32_C(0x8887d10b),
         UINT32_C(0x811bcfce),
         UINT32_C(0x899ad0da),
         UINT32_C(0x048001fc),
         UINT32_C(0x0c011ee8),
         UINT32_C(0x059d002d),
         UINT32_C(0x0d1c1f39),
         UINT32_C(0x8486cfe3),
         UINT32_C(0x8c07d0f7),
         UINT32_C(0x859bce32),
         UINT32_C(0x8d1ad126)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84408f),
         UINT32_C(0x3f808e80),
         UINT32_C(0x3f84ce0f),
         UINT32_C(0x3fc00367),
         UINT32_C(0x3fc443e8),
         UINT32_C(0x3fc08de7),
         UINT32_C(0x3fc4cd68),
         UINT32_C(0x3f824000),
         UINT32_C(0x3f86008f),
         UINT32_C(0x3f82ce80),
         UINT32_C(0x3f868e0f),
         UINT32_C(0x3fc24367),
         UINT32_C(0x3fc603e8),
         UINT32_C(0x3fc2cde7),
         UINT32_C(0x3fc68d68)},
        UINT32_C(0xfff80000),
        {0x36,0x03,0x1e,0xd8,0xe1,0x52,0x01,0x67,0x0e,0x46,
         0xc9,0x8c,0x5b,0x72,0xf4,0x1b,0xd0,0xcc,0x90,0x66,0x00}
    },
    {
        /* No.170 delta:887 weight:1169 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x204cedf9),
         UINT32_C(0x665b37f8),
         UINT32_C(0x4617da01),
         UINT32_C(0x6cd00aa0),
         UINT32_C(0x4c9ce759),
         UINT32_C(0x0a8b3d58),
         UINT32_C(0x2ac7d0a1),
         UINT32_C(0x00003dab),
         UINT32_C(0x204cd052),
         UINT32_C(0x665b0a53),
         UINT32_C(0x4617e7aa),
         UINT32_C(0x6cd0370b),
         UINT32_C(0x4c9cdaf2),
         UINT32_C(0x0a8b00f3),
         UINT32_C(0x2ac7ed0a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x002e2b75),
         UINT32_C(0x700212a9),
         UINT32_C(0x702c39dc),
         UINT32_C(0x0002f80a),
         UINT32_C(0x002cd37f),
         UINT32_C(0x7000eaa3),
         UINT32_C(0x702ec1d6),
         UINT32_C(0x600c0412),
         UINT32_C(0x60222f67),
         UINT32_C(0x100e16bb),
         UINT32_C(0x10203dce),
         UINT32_C(0x600efc18),
         UINT32_C(0x6020d76d),
         UINT32_C(0x100ceeb1),
         UINT32_C(0x1022c5c4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801715),
         UINT32_C(0x3fb80109),
         UINT32_C(0x3fb8161c),
         UINT32_C(0x3f80017c),
         UINT32_C(0x3f801669),
         UINT32_C(0x3fb80075),
         UINT32_C(0x3fb81760),
         UINT32_C(0x3fb00602),
         UINT32_C(0x3fb01117),
         UINT32_C(0x3f88070b),
         UINT32_C(0x3f88101e),
         UINT32_C(0x3fb0077e),
         UINT32_C(0x3fb0106b),
         UINT32_C(0x3f880677),
         UINT32_C(0x3f881162)},
        UINT32_C(0xfff80000),
        {0x09,0x30,0x36,0x45,0x63,0x72,0x06,0x8f,0x3a,0xd2,
         0xc5,0x1a,0x3f,0x29,0x2a,0xf1,0x62,0x72,0xb4,0x65,0x00}
    },
    {
        /* No.171 delta:736 weight:1515 */
        11213,
        55,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x179d8c42),
         UINT32_C(0xa333f12e),
         UINT32_C(0xb4ae7d6c),
         UINT32_C(0x9cc00abf),
         UINT32_C(0x8b5d86fd),
         UINT32_C(0x3ff3fb91),
         UINT32_C(0x286e77d3),
         UINT32_C(0x0000f0c5),
         UINT32_C(0x179d7c87),
         UINT32_C(0xa33301eb),
         UINT32_C(0xb4ae8da9),
         UINT32_C(0x9cc0fa7a),
         UINT32_C(0x8b5d7638),
         UINT32_C(0x3ff30b54),
         UINT32_C(0x286e8716)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8002113f),
         UINT32_C(0x0082696e),
         UINT32_C(0x80807851),
         UINT32_C(0x4000394d),
         UINT32_C(0xc0022872),
         UINT32_C(0x40825023),
         UINT32_C(0xc080411c),
         UINT32_C(0x00481046),
         UINT32_C(0x804a0179),
         UINT32_C(0x00ca7928),
         UINT32_C(0x80c86817),
         UINT32_C(0x4048290b),
         UINT32_C(0xc04a3834),
         UINT32_C(0x40ca4065),
         UINT32_C(0xc0c8515a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00108),
         UINT32_C(0x3f804134),
         UINT32_C(0x3fc0403c),
         UINT32_C(0x3fa0001c),
         UINT32_C(0x3fe00114),
         UINT32_C(0x3fa04128),
         UINT32_C(0x3fe04020),
         UINT32_C(0x3f802408),
         UINT32_C(0x3fc02500),
         UINT32_C(0x3f80653c),
         UINT32_C(0x3fc06434),
         UINT32_C(0x3fa02414),
         UINT32_C(0x3fe0251c),
         UINT32_C(0x3fa06520),
         UINT32_C(0x3fe06428)},
        UINT32_C(0xfff80000),
        {0xb1,0xdc,0x86,0xb7,0x63,0x4f,0xd7,0xb9,0xfd,0x4e,
         0x0f,0x84,0x3f,0x56,0xd4,0xde,0xa1,0x15,0x74,0x63,0x00}
    },
    {
        /* No.172 delta:864 weight:1317 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf8a54642),
         UINT32_C(0x32b17565),
         UINT32_C(0xca143327),
         UINT32_C(0x31d00ac8),
         UINT32_C(0xc9754c8a),
         UINT32_C(0x03617fad),
         UINT32_C(0xfbc439ef),
         UINT32_C(0x00003df6),
         UINT32_C(0xf8a57bb4),
         UINT32_C(0x32b14893),
         UINT32_C(0xca140ed1),
         UINT32_C(0x31d0373e),
         UINT32_C(0xc975717c),
         UINT32_C(0x0361425b),
         UINT32_C(0xfbc40419)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0802d814),
         UINT32_C(0x4001806f),
         UINT32_C(0x4803587b),
         UINT32_C(0x1001f7b5),
         UINT32_C(0x18032fa1),
         UINT32_C(0x500077da),
         UINT32_C(0x5802afce),
         UINT32_C(0x20019189),
         UINT32_C(0x2803499d),
         UINT32_C(0x600011e6),
         UINT32_C(0x6802c9f2),
         UINT32_C(0x3000663c),
         UINT32_C(0x3802be28),
         UINT32_C(0x7001e653),
         UINT32_C(0x78033e47)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84016c),
         UINT32_C(0x3fa000c0),
         UINT32_C(0x3fa401ac),
         UINT32_C(0x3f8800fb),
         UINT32_C(0x3f8c0197),
         UINT32_C(0x3fa8003b),
         UINT32_C(0x3fac0157),
         UINT32_C(0x3f9000c8),
         UINT32_C(0x3f9401a4),
         UINT32_C(0x3fb00008),
         UINT32_C(0x3fb40164),
         UINT32_C(0x3f980033),
         UINT32_C(0x3f9c015f),
         UINT32_C(0x3fb800f3),
         UINT32_C(0x3fbc019f)},
        UINT32_C(0xfff80000),
        {0x4a,0x6e,0x2f,0x88,0x4c,0x33,0x7b,0xbb,0xe2,0x96,
         0xe6,0xf1,0xaf,0xba,0x1b,0xee,0x2a,0x1a,0xe1,0xa6,0x00}
    },
    {
        /* No.173 delta:722 weight:1525 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x07c60bc2),
         UINT32_C(0x5e3370e7),
         UINT32_C(0x59f57b25),
         UINT32_C(0xa9000adb),
         UINT32_C(0xaec60119),
         UINT32_C(0xf7337a3c),
         UINT32_C(0xf0f571fe),
         UINT32_C(0x00007779),
         UINT32_C(0x07c67cbb),
         UINT32_C(0x5e33079e),
         UINT32_C(0x59f50c5c),
         UINT32_C(0xa9007da2),
         UINT32_C(0xaec67660),
         UINT32_C(0xf7330d45),
         UINT32_C(0xf0f50687)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00641895),
         UINT32_C(0x1012440a),
         UINT32_C(0x10765c9f),
         UINT32_C(0x0003c213),
         UINT32_C(0x0067da86),
         UINT32_C(0x10118619),
         UINT32_C(0x10759e8c),
         UINT32_C(0x50000011),
         UINT32_C(0x50641884),
         UINT32_C(0x4012441b),
         UINT32_C(0x40765c8e),
         UINT32_C(0x5003c202),
         UINT32_C(0x5067da97),
         UINT32_C(0x40118608),
         UINT32_C(0x40759e9d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80320c),
         UINT32_C(0x3f880922),
         UINT32_C(0x3f883b2e),
         UINT32_C(0x3f8001e1),
         UINT32_C(0x3f8033ed),
         UINT32_C(0x3f8808c3),
         UINT32_C(0x3f883acf),
         UINT32_C(0x3fa80000),
         UINT32_C(0x3fa8320c),
         UINT32_C(0x3fa00922),
         UINT32_C(0x3fa03b2e),
         UINT32_C(0x3fa801e1),
         UINT32_C(0x3fa833ed),
         UINT32_C(0x3fa008c3),
         UINT32_C(0x3fa03acf)},
        UINT32_C(0xfff80000),
        {0x88,0x54,0x4e,0x54,0xfc,0x97,0x1d,0xee,0x8c,0x35,
         0x96,0x45,0x39,0x47,0x01,0x41,0x49,0xf9,0xcc,0x13,0x00}
    },
    {
        /* No.174 delta:2446 weight:1169 */
        11213,
        6,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7013cfde),
         UINT32_C(0xefc0532c),
         UINT32_C(0x9fd39cf2),
         UINT32_C(0x44000aed),
         UINT32_C(0x3413c533),
         UINT32_C(0xabc059c1),
         UINT32_C(0xdbd3961f),
         UINT32_C(0x0000c8ca),
         UINT32_C(0x70130714),
         UINT32_C(0xefc09be6),
         UINT32_C(0x9fd35438),
         UINT32_C(0x4400c227),
         UINT32_C(0x34130df9),
         UINT32_C(0xabc0910b),
         UINT32_C(0xdbd35ed5)},
        {UINT32_C(0x00000000),
         UINT32_C(0xf209a07a),
         UINT32_C(0x0ce0201c),
         UINT32_C(0xfee98066),
         UINT32_C(0x424e80c8),
         UINT32_C(0xb04720b2),
         UINT32_C(0x4eaea0d4),
         UINT32_C(0xbca700ae),
         UINT32_C(0x034ca48f),
         UINT32_C(0xf14504f5),
         UINT32_C(0x0fac8493),
         UINT32_C(0xfda524e9),
         UINT32_C(0x41022447),
         UINT32_C(0xb30b843d),
         UINT32_C(0x4de2045b),
         UINT32_C(0xbfeba421)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff904d0),
         UINT32_C(0x3f867010),
         UINT32_C(0x3fff74c0),
         UINT32_C(0x3fa12740),
         UINT32_C(0x3fd82390),
         UINT32_C(0x3fa75750),
         UINT32_C(0x3fde5380),
         UINT32_C(0x3f81a652),
         UINT32_C(0x3ff8a282),
         UINT32_C(0x3f87d642),
         UINT32_C(0x3ffed292),
         UINT32_C(0x3fa08112),
         UINT32_C(0x3fd985c2),
         UINT32_C(0x3fa6f102),
         UINT32_C(0x3fdff5d2)},
        UINT32_C(0xfff80000),
        {0x13,0x0d,0x73,0x24,0x2d,0xe1,0x34,0x35,0x61,0x80,
         0x9d,0x5b,0x96,0xec,0xac,0x0a,0x74,0x51,0x84,0xe0,0x00}
    },
    {
        /* No.175 delta:2035 weight:1341 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf5158300),
         UINT32_C(0xcf4b2e46),
         UINT32_C(0x3a5ead46),
         UINT32_C(0xcfe00afa),
         UINT32_C(0x3af589fa),
         UINT32_C(0x00ab24bc),
         UINT32_C(0xf5bea7bc),
         UINT32_C(0x00006481),
         UINT32_C(0xf515e781),
         UINT32_C(0xcf4b4ac7),
         UINT32_C(0x3a5ec9c7),
         UINT32_C(0xcfe06e7b),
         UINT32_C(0x3af5ed7b),
         UINT32_C(0x00ab403d),
         UINT32_C(0xf5bec33d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x066611dd),
         UINT32_C(0x4038015e),
         UINT32_C(0x465e1083),
         UINT32_C(0x40780137),
         UINT32_C(0x461e10ea),
         UINT32_C(0x00400069),
         UINT32_C(0x062611b4),
         UINT32_C(0x003000c5),
         UINT32_C(0x06561118),
         UINT32_C(0x4008019b),
         UINT32_C(0x466e1046),
         UINT32_C(0x404801f2),
         UINT32_C(0x462e102f),
         UINT32_C(0x007000ac),
         UINT32_C(0x06161171)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f833308),
         UINT32_C(0x3fa01c00),
         UINT32_C(0x3fa32f08),
         UINT32_C(0x3fa03c00),
         UINT32_C(0x3fa30f08),
         UINT32_C(0x3f802000),
         UINT32_C(0x3f831308),
         UINT32_C(0x3f801800),
         UINT32_C(0x3f832b08),
         UINT32_C(0x3fa00400),
         UINT32_C(0x3fa33708),
         UINT32_C(0x3fa02400),
         UINT32_C(0x3fa31708),
         UINT32_C(0x3f803800),
         UINT32_C(0x3f830b08)},
        UINT32_C(0xfff80000),
        {0x97,0xdb,0x01,0xc1,0xf7,0x06,0x48,0x6f,0x2d,0x16,
         0x52,0x4d,0x8d,0x90,0xea,0xbf,0x42,0x39,0xde,0xc6,0x00}
    },
    {
        /* No.176 delta:677 weight:1749 */
        11213,
        84,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2c5dfd73),
         UINT32_C(0x32ebbb4c),
         UINT32_C(0x1eb6463f),
         UINT32_C(0xaa100b0b),
         UINT32_C(0x864df678),
         UINT32_C(0x98fbb047),
         UINT32_C(0xb4a64d34),
         UINT32_C(0x0000c001),
         UINT32_C(0x2c5d3d72),
         UINT32_C(0x32eb7b4d),
         UINT32_C(0x1eb6863e),
         UINT32_C(0xaa10cb0a),
         UINT32_C(0x864d3679),
         UINT32_C(0x98fb7046),
         UINT32_C(0xb4a68d35)},
        {UINT32_C(0x00000000),
         UINT32_C(0x04033977),
         UINT32_C(0x010221e2),
         UINT32_C(0x05011895),
         UINT32_C(0x20020c11),
         UINT32_C(0x24013566),
         UINT32_C(0x21002df3),
         UINT32_C(0x25031484),
         UINT32_C(0xa101801e),
         UINT32_C(0xa502b969),
         UINT32_C(0xa003a1fc),
         UINT32_C(0xa400988b),
         UINT32_C(0x81038c0f),
         UINT32_C(0x8500b578),
         UINT32_C(0x8001aded),
         UINT32_C(0x8402949a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f82019c),
         UINT32_C(0x3f808110),
         UINT32_C(0x3f82808c),
         UINT32_C(0x3f900106),
         UINT32_C(0x3f92009a),
         UINT32_C(0x3f908016),
         UINT32_C(0x3f92818a),
         UINT32_C(0x3fd080c0),
         UINT32_C(0x3fd2815c),
         UINT32_C(0x3fd001d0),
         UINT32_C(0x3fd2004c),
         UINT32_C(0x3fc081c6),
         UINT32_C(0x3fc2805a),
         UINT32_C(0x3fc000d6),
         UINT32_C(0x3fc2014a)},
        UINT32_C(0xfff80000),
        {0x60,0x52,0xb4,0x25,0xa0,0xd9,0xbc,0x6c,0x91,0x27,
         0x2f,0x09,0x47,0x69,0xd1,0x4f,0x6d,0x77,0x92,0xa4,0x00}
    },
    {
        /* No.177 delta:916 weight:1259 */
        11213,
        72,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0edb5b50),
         UINT32_C(0x2243d5fb),
         UINT32_C(0x2c988eab),
         UINT32_C(0xe1a00b10),
         UINT32_C(0xef7b5040),
         UINT32_C(0xc3e3deeb),
         UINT32_C(0xcd3885bb),
         UINT32_C(0x0000692e),
         UINT32_C(0x0edb327e),
         UINT32_C(0x2243bcd5),
         UINT32_C(0x2c98e785),
         UINT32_C(0xe1a0623e),
         UINT32_C(0xef7b396e),
         UINT32_C(0xc3e3b7c5),
         UINT32_C(0xcd38ec95)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0063f81e),
         UINT32_C(0x50200803),
         UINT32_C(0x5043f01d),
         UINT32_C(0x40000014),
         UINT32_C(0x4063f80a),
         UINT32_C(0x10200817),
         UINT32_C(0x1043f009),
         UINT32_C(0x2040021c),
         UINT32_C(0x2023fa02),
         UINT32_C(0x70600a1f),
         UINT32_C(0x7003f201),
         UINT32_C(0x60400208),
         UINT32_C(0x6023fa16),
         UINT32_C(0x30600a0b),
         UINT32_C(0x3003f215)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8031fc),
         UINT32_C(0x3fa81004),
         UINT32_C(0x3fa821f8),
         UINT32_C(0x3fa00000),
         UINT32_C(0x3fa031fc),
         UINT32_C(0x3f881004),
         UINT32_C(0x3f8821f8),
         UINT32_C(0x3f902001),
         UINT32_C(0x3f9011fd),
         UINT32_C(0x3fb83005),
         UINT32_C(0x3fb801f9),
         UINT32_C(0x3fb02001),
         UINT32_C(0x3fb011fd),
         UINT32_C(0x3f983005),
         UINT32_C(0x3f9801f9)},
        UINT32_C(0xfff80000),
        {0x60,0x25,0x79,0xde,0xf6,0xe8,0x56,0x6f,0xaf,0xf7,
         0xdc,0x78,0x78,0xa5,0x6d,0xed,0x68,0x2f,0x7b,0x92,0x00}
    },
    {
        /* No.178 delta:650 weight:1481 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbb2934b3),
         UINT32_C(0x5d9e85db),
         UINT32_C(0xe6b7b168),
         UINT32_C(0x43600b20),
         UINT32_C(0xf8493f93),
         UINT32_C(0x1efe8efb),
         UINT32_C(0xa5d7ba48),
         UINT32_C(0x0000631f),
         UINT32_C(0xbb2957ac),
         UINT32_C(0x5d9ee6c4),
         UINT32_C(0xe6b7d277),
         UINT32_C(0x4360683f),
         UINT32_C(0xf8495c8c),
         UINT32_C(0x1efeede4),
         UINT32_C(0xa5d7d957)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00531dbe),
         UINT32_C(0x401011fc),
         UINT32_C(0x40430c42),
         UINT32_C(0x00508097),
         UINT32_C(0x00039d29),
         UINT32_C(0x4040916b),
         UINT32_C(0x40138cd5),
         UINT32_C(0x201c69ad),
         UINT32_C(0x204f7413),
         UINT32_C(0x600c7851),
         UINT32_C(0x605f65ef),
         UINT32_C(0x204ce93a),
         UINT32_C(0x201ff484),
         UINT32_C(0x605cf8c6),
         UINT32_C(0x600fe578)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80298e),
         UINT32_C(0x3fa00808),
         UINT32_C(0x3fa02186),
         UINT32_C(0x3f802840),
         UINT32_C(0x3f8001ce),
         UINT32_C(0x3fa02048),
         UINT32_C(0x3fa009c6),
         UINT32_C(0x3f900e34),
         UINT32_C(0x3f9027ba),
         UINT32_C(0x3fb0063c),
         UINT32_C(0x3fb02fb2),
         UINT32_C(0x3f902674),
         UINT32_C(0x3f900ffa),
         UINT32_C(0x3fb02e7c),
         UINT32_C(0x3fb007f2)},
        UINT32_C(0xfff80000),
        {0xc1,0x4b,0x2e,0x05,0xf5,0x1d,0x5c,0x01,0xb2,0xb4,
         0xf8,0xe8,0xe0,0xdc,0x65,0xee,0x85,0x3a,0x54,0x2a,0x00}
    },
    {
        /* No.179 delta:1090 weight:1633 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3208ef45),
         UINT32_C(0x55becd4e),
         UINT32_C(0x67b6220b),
         UINT32_C(0x01b00b3e),
         UINT32_C(0x33b8e47b),
         UINT32_C(0x540ec670),
         UINT32_C(0x66062935),
         UINT32_C(0x0000dec1),
         UINT32_C(0x32083184),
         UINT32_C(0x55be138f),
         UINT32_C(0x67b6fcca),
         UINT32_C(0x01b0d5ff),
         UINT32_C(0x33b83aba),
         UINT32_C(0x540e18b1),
         UINT32_C(0x6606f7f4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x161c41de),
         UINT32_C(0x001700a3),
         UINT32_C(0x160b417d),
         UINT32_C(0x000011af),
         UINT32_C(0x161c5071),
         UINT32_C(0x0017110c),
         UINT32_C(0x160b50d2),
         UINT32_C(0x004881fa),
         UINT32_C(0x1654c024),
         UINT32_C(0x005f8159),
         UINT32_C(0x1643c087),
         UINT32_C(0x00489055),
         UINT32_C(0x1654d18b),
         UINT32_C(0x005f90f6),
         UINT32_C(0x1643d128)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8b0e20),
         UINT32_C(0x3f800b80),
         UINT32_C(0x3f8b05a0),
         UINT32_C(0x3f800008),
         UINT32_C(0x3f8b0e28),
         UINT32_C(0x3f800b88),
         UINT32_C(0x3f8b05a8),
         UINT32_C(0x3f802440),
         UINT32_C(0x3f8b2a60),
         UINT32_C(0x3f802fc0),
         UINT32_C(0x3f8b21e0),
         UINT32_C(0x3f802448),
         UINT32_C(0x3f8b2a68),
         UINT32_C(0x3f802fc8),
         UINT32_C(0x3f8b21e8)},
        UINT32_C(0xfff80000),
        {0x74,0xa1,0xe2,0x05,0xf7,0x40,0x90,0xcb,0x54,0x07,
         0x93,0x7a,0xc0,0xc1,0x78,0x0e,0x6d,0x04,0xcc,0x35,0x00}
    },
    {
        /* No.180 delta:1121 weight:1579 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x505c5b53),
         UINT32_C(0xcdee4615),
         UINT32_C(0x9db21d46),
         UINT32_C(0xa8400b4c),
         UINT32_C(0xf81c501f),
         UINT32_C(0x65ae4d59),
         UINT32_C(0x35f2160a),
         UINT32_C(0x00007394),
         UINT32_C(0x505c28c7),
         UINT32_C(0xcdee3581),
         UINT32_C(0x9db26ed2),
         UINT32_C(0xa84078d8),
         UINT32_C(0xf81c238b),
         UINT32_C(0x65ae3ecd),
         UINT32_C(0x35f2659e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007e01b6),
         UINT32_C(0x0003c171),
         UINT32_C(0x007dc0c7),
         UINT32_C(0x2011c062),
         UINT32_C(0x206fc1d4),
         UINT32_C(0x20120113),
         UINT32_C(0x206c00a5),
         UINT32_C(0x00003018),
         UINT32_C(0x007e31ae),
         UINT32_C(0x0003f169),
         UINT32_C(0x007df0df),
         UINT32_C(0x2011f07a),
         UINT32_C(0x206ff1cc),
         UINT32_C(0x2012310b),
         UINT32_C(0x206c30bd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f8001e0),
         UINT32_C(0x3f803ee0),
         UINT32_C(0x3f9008e0),
         UINT32_C(0x3f9037e0),
         UINT32_C(0x3f900900),
         UINT32_C(0x3f903600),
         UINT32_C(0x3f800018),
         UINT32_C(0x3f803f18),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3f803ef8),
         UINT32_C(0x3f9008f8),
         UINT32_C(0x3f9037f8),
         UINT32_C(0x3f900918),
         UINT32_C(0x3f903618)},
        UINT32_C(0xfff80000),
        {0x20,0x14,0xed,0x53,0xf0,0xa3,0x58,0x5e,0x39,0x5c,
         0x10,0x47,0x72,0x36,0x5d,0x27,0xd4,0x0a,0x93,0x09,0x00}
    },
    {
        /* No.181 delta:1270 weight:1603 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x77d67f0d),
         UINT32_C(0x76f2a9b5),
         UINT32_C(0x0124d6b8),
         UINT32_C(0x83500b50),
         UINT32_C(0xf486745d),
         UINT32_C(0xf5a2a2e5),
         UINT32_C(0x8274dde8),
         UINT32_C(0x00005afa),
         UINT32_C(0x77d625f7),
         UINT32_C(0x76f2f34f),
         UINT32_C(0x01248c42),
         UINT32_C(0x835051aa),
         UINT32_C(0xf4862ea7),
         UINT32_C(0xf5a2f81f),
         UINT32_C(0x82748712)},
        {UINT32_C(0x00000000),
         UINT32_C(0x08261d9a),
         UINT32_C(0x2049a073),
         UINT32_C(0x286fbde9),
         UINT32_C(0x006e03e7),
         UINT32_C(0x08481e7d),
         UINT32_C(0x2027a394),
         UINT32_C(0x2801be0e),
         UINT32_C(0x3008601b),
         UINT32_C(0x382e7d81),
         UINT32_C(0x1041c068),
         UINT32_C(0x1867ddf2),
         UINT32_C(0x306663fc),
         UINT32_C(0x38407e66),
         UINT32_C(0x102fc38f),
         UINT32_C(0x1809de15)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84130e),
         UINT32_C(0x3f9024d0),
         UINT32_C(0x3f9437de),
         UINT32_C(0x3f803701),
         UINT32_C(0x3f84240f),
         UINT32_C(0x3f9013d1),
         UINT32_C(0x3f9400df),
         UINT32_C(0x3f980430),
         UINT32_C(0x3f9c173e),
         UINT32_C(0x3f8820e0),
         UINT32_C(0x3f8c33ee),
         UINT32_C(0x3f983331),
         UINT32_C(0x3f9c203f),
         UINT32_C(0x3f8817e1),
         UINT32_C(0x3f8c04ef)},
        UINT32_C(0xfff80000),
        {0xdc,0x4d,0x79,0x4b,0xba,0xd4,0x51,0x7b,0x82,0x70,
         0x29,0xec,0xaa,0x5c,0xe7,0x0b,0x6f,0xb9,0x88,0x84,0x00}
    },
    {
        /* No.182 delta:1434 weight:1199 */
        11213,
        50,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7c783189),
         UINT32_C(0xe762da2e),
         UINT32_C(0x9b1aeba7),
         UINT32_C(0x73c00b6d),
         UINT32_C(0x0fb83ae4),
         UINT32_C(0x94a2d143),
         UINT32_C(0xe8dae0ca),
         UINT32_C(0x0000f2df),
         UINT32_C(0x7c78c356),
         UINT32_C(0xe76228f1),
         UINT32_C(0x9b1a1978),
         UINT32_C(0x73c0f9b2),
         UINT32_C(0x0fb8c83b),
         UINT32_C(0x94a2239c),
         UINT32_C(0xe8da1215)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20020696),
         UINT32_C(0x016200f4),
         UINT32_C(0x21600662),
         UINT32_C(0x540020c7),
         UINT32_C(0x74022651),
         UINT32_C(0x55622033),
         UINT32_C(0x756026a5),
         UINT32_C(0x0400806b),
         UINT32_C(0x240286fd),
         UINT32_C(0x0562809f),
         UINT32_C(0x25608609),
         UINT32_C(0x5000a0ac),
         UINT32_C(0x7002a63a),
         UINT32_C(0x5162a058),
         UINT32_C(0x7160a6ce)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900103),
         UINT32_C(0x3f80b100),
         UINT32_C(0x3f90b003),
         UINT32_C(0x3faa0010),
         UINT32_C(0x3fba0113),
         UINT32_C(0x3faab110),
         UINT32_C(0x3fbab013),
         UINT32_C(0x3f820040),
         UINT32_C(0x3f920143),
         UINT32_C(0x3f82b140),
         UINT32_C(0x3f92b043),
         UINT32_C(0x3fa80050),
         UINT32_C(0x3fb80153),
         UINT32_C(0x3fa8b150),
         UINT32_C(0x3fb8b053)},
        UINT32_C(0xfff80000),
        {0xf6,0x60,0xc0,0x9d,0x81,0x56,0xe5,0x79,0x7c,0xcb,
         0xee,0x7a,0xd9,0x6a,0x60,0x34,0x7d,0x2f,0x65,0xe0,0x00}
    },
    {
        /* No.183 delta:1029 weight:1561 */
        11213,
        55,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfd44e4d2),
         UINT32_C(0xf1f56eb4),
         UINT32_C(0x0cb18a66),
         UINT32_C(0x2ba00b7e),
         UINT32_C(0xd6e4efac),
         UINT32_C(0xda5565ca),
         UINT32_C(0x27118118),
         UINT32_C(0x0000dc8f),
         UINT32_C(0xfd44385d),
         UINT32_C(0xf1f5b23b),
         UINT32_C(0x0cb156e9),
         UINT32_C(0x2ba0d7f1),
         UINT32_C(0xd6e43323),
         UINT32_C(0xda55b945),
         UINT32_C(0x27115d97)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007c21fe),
         UINT32_C(0x100400cc),
         UINT32_C(0x10782132),
         UINT32_C(0x000310e7),
         UINT32_C(0x007f3119),
         UINT32_C(0x1007102b),
         UINT32_C(0x107b31d5),
         UINT32_C(0x0000181a),
         UINT32_C(0x007c39e4),
         UINT32_C(0x100418d6),
         UINT32_C(0x10783928),
         UINT32_C(0x000308fd),
         UINT32_C(0x007f2903),
         UINT32_C(0x10070831),
         UINT32_C(0x107b29cf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e10),
         UINT32_C(0x3f880200),
         UINT32_C(0x3f883c10),
         UINT32_C(0x3f800188),
         UINT32_C(0x3f803f98),
         UINT32_C(0x3f880388),
         UINT32_C(0x3f883d98),
         UINT32_C(0x3f80000c),
         UINT32_C(0x3f803e1c),
         UINT32_C(0x3f88020c),
         UINT32_C(0x3f883c1c),
         UINT32_C(0x3f800184),
         UINT32_C(0x3f803f94),
         UINT32_C(0x3f880384),
         UINT32_C(0x3f883d94)},
        UINT32_C(0xfff80000),
        {0xe5,0x4f,0x1f,0x15,0xf6,0x89,0xa6,0xd9,0x04,0xe3,
         0xd0,0x6e,0x01,0x48,0x08,0x36,0x7f,0x71,0x9a,0x8d,0x00}
    },
    {
        /* No.184 delta:624 weight:1571 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xcfea1ce0),
         UINT32_C(0x16085e8e),
         UINT32_C(0xd9e2426e),
         UINT32_C(0x11500b80),
         UINT32_C(0xdeba1760),
         UINT32_C(0x0758550e),
         UINT32_C(0xc8b249ee),
         UINT32_C(0x000041d7),
         UINT32_C(0xcfea5d37),
         UINT32_C(0x16081f59),
         UINT32_C(0xd9e203b9),
         UINT32_C(0x11504a57),
         UINT32_C(0xdeba56b7),
         UINT32_C(0x075814d9),
         UINT32_C(0xc8b20839)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1079913a),
         UINT32_C(0x000328c7),
         UINT32_C(0x107ab9fd),
         UINT32_C(0x4062f00b),
         UINT32_C(0x501b6131),
         UINT32_C(0x4061d8cc),
         UINT32_C(0x501849f6),
         UINT32_C(0x90240809),
         UINT32_C(0x805d9933),
         UINT32_C(0x902720ce),
         UINT32_C(0x805eb1f4),
         UINT32_C(0xd046f802),
         UINT32_C(0xc03f6938),
         UINT32_C(0xd045d0c5),
         UINT32_C(0xc03c41ff)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f883cc8),
         UINT32_C(0x3f800194),
         UINT32_C(0x3f883d5c),
         UINT32_C(0x3fa03178),
         UINT32_C(0x3fa80db0),
         UINT32_C(0x3fa030ec),
         UINT32_C(0x3fa80c24),
         UINT32_C(0x3fc81204),
         UINT32_C(0x3fc02ecc),
         UINT32_C(0x3fc81390),
         UINT32_C(0x3fc02f58),
         UINT32_C(0x3fe8237c),
         UINT32_C(0x3fe01fb4),
         UINT32_C(0x3fe822e8),
         UINT32_C(0x3fe01e20)},
        UINT32_C(0xfff80000),
        {0x51,0x66,0xe5,0x17,0xfb,0x72,0x1d,0x3c,0xa5,0xf3,
         0x76,0x62,0x85,0x05,0xb1,0xaa,0x24,0xe7,0x36,0xc5,0x00}
    },
    {
        /* No.185 delta:1091 weight:1671 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x280b74b6),
         UINT32_C(0x7d7b3c94),
         UINT32_C(0x55704822),
         UINT32_C(0xece00b99),
         UINT32_C(0xc4eb7f2f),
         UINT32_C(0x919b370d),
         UINT32_C(0xb99043bb),
         UINT32_C(0x0000dbc1),
         UINT32_C(0x280baf77),
         UINT32_C(0x7d7be755),
         UINT32_C(0x557093e3),
         UINT32_C(0xece0d058),
         UINT32_C(0xc4eba4ee),
         UINT32_C(0x919beccc),
         UINT32_C(0xb990987a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x300c001a),
         UINT32_C(0x0042b911),
         UINT32_C(0x304eb90b),
         UINT32_C(0x00418416),
         UINT32_C(0x304d840c),
         UINT32_C(0x00033d07),
         UINT32_C(0x300f3d1d),
         UINT32_C(0x6000c7a3),
         UINT32_C(0x500cc7b9),
         UINT32_C(0x60427eb2),
         UINT32_C(0x504e7ea8),
         UINT32_C(0x604143b5),
         UINT32_C(0x504d43af),
         UINT32_C(0x6003faa4),
         UINT32_C(0x500ffabe)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980600),
         UINT32_C(0x3f80215c),
         UINT32_C(0x3f98275c),
         UINT32_C(0x3f8020c2),
         UINT32_C(0x3f9826c2),
         UINT32_C(0x3f80019e),
         UINT32_C(0x3f98079e),
         UINT32_C(0x3fb00063),
         UINT32_C(0x3fa80663),
         UINT32_C(0x3fb0213f),
         UINT32_C(0x3fa8273f),
         UINT32_C(0x3fb020a1),
         UINT32_C(0x3fa826a1),
         UINT32_C(0x3fb001fd),
         UINT32_C(0x3fa807fd)},
        UINT32_C(0xfff80000),
        {0xf2,0xd6,0x37,0x24,0x51,0x91,0xc6,0x90,0xa9,0xbc,
         0x8d,0x34,0x24,0xf7,0xee,0x28,0xd5,0xf8,0xe1,0xfe,0x00}
    },
    {
        /* No.186 delta:1106 weight:1387 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd113dd47),
         UINT32_C(0xed0d5ed0),
         UINT32_C(0x3c1e8397),
         UINT32_C(0xbd300bac),
         UINT32_C(0x6c23d6eb),
         UINT32_C(0x503d557c),
         UINT32_C(0x812e883b),
         UINT32_C(0x00000b0f),
         UINT32_C(0xd113d648),
         UINT32_C(0xed0d55df),
         UINT32_C(0x3c1e8898),
         UINT32_C(0xbd3000a3),
         UINT32_C(0x6c23dde4),
         UINT32_C(0x503d5e73),
         UINT32_C(0x812e8334)},
        {UINT32_C(0x00000000),
         UINT32_C(0x005ef41e),
         UINT32_C(0x70252012),
         UINT32_C(0x707bd40c),
         UINT32_C(0x00051809),
         UINT32_C(0x005bec17),
         UINT32_C(0x7020381b),
         UINT32_C(0x707ecc05),
         UINT32_C(0x1046212d),
         UINT32_C(0x1018d533),
         UINT32_C(0x6063013f),
         UINT32_C(0x603df521),
         UINT32_C(0x10433924),
         UINT32_C(0x101dcd3a),
         UINT32_C(0x60661936),
         UINT32_C(0x6038ed28)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802f7a),
         UINT32_C(0x3fb81290),
         UINT32_C(0x3fb83dea),
         UINT32_C(0x3f80028c),
         UINT32_C(0x3f802df6),
         UINT32_C(0x3fb8101c),
         UINT32_C(0x3fb83f66),
         UINT32_C(0x3f882310),
         UINT32_C(0x3f880c6a),
         UINT32_C(0x3fb03180),
         UINT32_C(0x3fb01efa),
         UINT32_C(0x3f88219c),
         UINT32_C(0x3f880ee6),
         UINT32_C(0x3fb0330c),
         UINT32_C(0x3fb01c76)},
        UINT32_C(0xfff80000),
        {0x89,0xd2,0x06,0x89,0xe4,0xb6,0x3e,0xc0,0x18,0xec,
         0x1d,0x2c,0x18,0xf9,0xa8,0x97,0x03,0x1e,0xe8,0x52,0x00}
    },
    {
        /* No.187 delta:1132 weight:1531 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8fdbb324),
         UINT32_C(0x981dfafd),
         UINT32_C(0x17c649d9),
         UINT32_C(0x40600bb8),
         UINT32_C(0xcfbbb89c),
         UINT32_C(0xd87df145),
         UINT32_C(0x57a64261),
         UINT32_C(0x00002fea),
         UINT32_C(0x8fdb9cce),
         UINT32_C(0x981dd517),
         UINT32_C(0x17c66633),
         UINT32_C(0x40602452),
         UINT32_C(0xcfbb9776),
         UINT32_C(0xd87ddeaf),
         UINT32_C(0x57a66d8b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0839de56),
         UINT32_C(0x107c681f),
         UINT32_C(0x1845b649),
         UINT32_C(0x0041500e),
         UINT32_C(0x08788e58),
         UINT32_C(0x103d3811),
         UINT32_C(0x1804e647),
         UINT32_C(0x00641053),
         UINT32_C(0x085dce05),
         UINT32_C(0x1018784c),
         UINT32_C(0x1821a61a),
         UINT32_C(0x0025405d),
         UINT32_C(0x081c9e0b),
         UINT32_C(0x10592842),
         UINT32_C(0x1860f614)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841cef),
         UINT32_C(0x3f883e34),
         UINT32_C(0x3f8c22db),
         UINT32_C(0x3f8020a8),
         UINT32_C(0x3f843c47),
         UINT32_C(0x3f881e9c),
         UINT32_C(0x3f8c0273),
         UINT32_C(0x3f803208),
         UINT32_C(0x3f842ee7),
         UINT32_C(0x3f880c3c),
         UINT32_C(0x3f8c10d3),
         UINT32_C(0x3f8012a0),
         UINT32_C(0x3f840e4f),
         UINT32_C(0x3f882c94),
         UINT32_C(0x3f8c307b)},
        UINT32_C(0xfff80000),
        {0x2a,0x5f,0x68,0xfa,0xbd,0xf8,0x19,0xd5,0x40,0xb1,
         0x39,0x22,0x43,0xa7,0xcc,0xd9,0x05,0x43,0x7c,0x15,0x00}
    },
    {
        /* No.188 delta:1040 weight:1601 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xad234f29),
         UINT32_C(0xa8c21258),
         UINT32_C(0x05e15d71),
         UINT32_C(0xe5c00bc2),
         UINT32_C(0x48e344eb),
         UINT32_C(0x4d02199a),
         UINT32_C(0xe02156b3),
         UINT32_C(0x000075a9),
         UINT32_C(0xad233a80),
         UINT32_C(0xa8c267f1),
         UINT32_C(0x05e128d8),
         UINT32_C(0xe5c07e6b),
         UINT32_C(0x48e33142),
         UINT32_C(0x4d026c33),
         UINT32_C(0xe021231a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x003d9c1e),
         UINT32_C(0x0002b01c),
         UINT32_C(0x003f2c02),
         UINT32_C(0x21008014),
         UINT32_C(0x213d1c0a),
         UINT32_C(0x21023008),
         UINT32_C(0x213fac16),
         UINT32_C(0x403c040f),
         UINT32_C(0x40019811),
         UINT32_C(0x403eb413),
         UINT32_C(0x4003280d),
         UINT32_C(0x613c841b),
         UINT32_C(0x61011805),
         UINT32_C(0x613e3407),
         UINT32_C(0x6103a819)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801ece),
         UINT32_C(0x3f800158),
         UINT32_C(0x3f801f96),
         UINT32_C(0x3f908040),
         UINT32_C(0x3f909e8e),
         UINT32_C(0x3f908118),
         UINT32_C(0x3f909fd6),
         UINT32_C(0x3fa01e02),
         UINT32_C(0x3fa000cc),
         UINT32_C(0x3fa01f5a),
         UINT32_C(0x3fa00194),
         UINT32_C(0x3fb09e42),
         UINT32_C(0x3fb0808c),
         UINT32_C(0x3fb09f1a),
         UINT32_C(0x3fb081d4)},
        UINT32_C(0xfff80000),
        {0x3e,0xa4,0x26,0xb3,0x94,0x22,0x87,0xf4,0x15,0x2e,
         0x07,0x74,0xc9,0xee,0xfe,0x50,0xc9,0x7a,0x8c,0x37,0x00}
    },
    {
        /* No.189 delta:733 weight:1605 */
        11213,
        80,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x11d23732),
         UINT32_C(0xb9ce7b60),
         UINT32_C(0xa81c4c52),
         UINT32_C(0x9ed00bde),
         UINT32_C(0x8f023cec),
         UINT32_C(0x271e70be),
         UINT32_C(0x36cc478c),
         UINT32_C(0x00007cb5),
         UINT32_C(0x11d24b87),
         UINT32_C(0xb9ce07d5),
         UINT32_C(0xa81c30e7),
         UINT32_C(0x9ed0776b),
         UINT32_C(0x8f024059),
         UINT32_C(0x271e0c0b),
         UINT32_C(0x36cc3b39)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2802001b),
         UINT32_C(0x500081d1),
         UINT32_C(0x780281ca),
         UINT32_C(0x00023165),
         UINT32_C(0x2800317e),
         UINT32_C(0x5002b0b4),
         UINT32_C(0x7800b0af),
         UINT32_C(0x20001618),
         UINT32_C(0x08021603),
         UINT32_C(0x700097c9),
         UINT32_C(0x580297d2),
         UINT32_C(0x2002277d),
         UINT32_C(0x08002766),
         UINT32_C(0x7002a6ac),
         UINT32_C(0x5800a6b7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f940100),
         UINT32_C(0x3fa80040),
         UINT32_C(0x3fbc0140),
         UINT32_C(0x3f800118),
         UINT32_C(0x3f940018),
         UINT32_C(0x3fa80158),
         UINT32_C(0x3fbc0058),
         UINT32_C(0x3f90000b),
         UINT32_C(0x3f84010b),
         UINT32_C(0x3fb8004b),
         UINT32_C(0x3fac014b),
         UINT32_C(0x3f900113),
         UINT32_C(0x3f840013),
         UINT32_C(0x3fb80153),
         UINT32_C(0x3fac0053)},
        UINT32_C(0xfff80000),
        {0x99,0x50,0x99,0xc6,0x2d,0x5d,0x37,0x23,0x1e,0xc8,
         0x4e,0x80,0xad,0xdc,0xfc,0x85,0x61,0x88,0x59,0x55,0x00}
    },
    {
        /* No.190 delta:841 weight:1165 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7f42d515),
         UINT32_C(0x73d3e490),
         UINT32_C(0x0c913185),
         UINT32_C(0x38e00be1),
         UINT32_C(0x47a2def4),
         UINT32_C(0x4b33ef71),
         UINT32_C(0x34713a64),
         UINT32_C(0x00001fa0),
         UINT32_C(0x7f42cab5),
         UINT32_C(0x73d3fb30),
         UINT32_C(0x0c912e25),
         UINT32_C(0x38e01441),
         UINT32_C(0x47a2c154),
         UINT32_C(0x4b33f0d1),
         UINT32_C(0x347125c4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x382491de),
         UINT32_C(0x704f89b9),
         UINT32_C(0x486b1867),
         UINT32_C(0x000206bf),
         UINT32_C(0x38269761),
         UINT32_C(0x704d8f06),
         UINT32_C(0x48691ed8),
         UINT32_C(0x1003c19d),
         UINT32_C(0x28275043),
         UINT32_C(0x604c4824),
         UINT32_C(0x5868d9fa),
         UINT32_C(0x1001c722),
         UINT32_C(0x282556fc),
         UINT32_C(0x604e4e9b),
         UINT32_C(0x586adf45)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9c1248),
         UINT32_C(0x3fb827c4),
         UINT32_C(0x3fa4358c),
         UINT32_C(0x3f800103),
         UINT32_C(0x3f9c134b),
         UINT32_C(0x3fb826c7),
         UINT32_C(0x3fa4348f),
         UINT32_C(0x3f8801e0),
         UINT32_C(0x3f9413a8),
         UINT32_C(0x3fb02624),
         UINT32_C(0x3fac346c),
         UINT32_C(0x3f8800e3),
         UINT32_C(0x3f9412ab),
         UINT32_C(0x3fb02727),
         UINT32_C(0x3fac356f)},
        UINT32_C(0xfff80000),
        {0x9c,0xba,0x5c,0x8d,0x1f,0x35,0x67,0xd1,0x3e,0xfd,
         0xeb,0xad,0x1a,0x7d,0xa1,0xdb,0x36,0x7a,0x53,0xdb,0x00}
    },
    {
        /* No.191 delta:684 weight:1773 */
        11213,
        84,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1a68bb25),
         UINT32_C(0x99cfab64),
         UINT32_C(0x83a71041),
         UINT32_C(0xf5400bf8),
         UINT32_C(0xef28b0dd),
         UINT32_C(0x6c8fa09c),
         UINT32_C(0x76e71bb9),
         UINT32_C(0x00000bdb),
         UINT32_C(0x1a68b0fe),
         UINT32_C(0x99cfa0bf),
         UINT32_C(0x83a71b9a),
         UINT32_C(0xf5400023),
         UINT32_C(0xef28bb06),
         UINT32_C(0x6c8fab47),
         UINT32_C(0x76e71062)},
        {UINT32_C(0x00000000),
         UINT32_C(0x680ca41d),
         UINT32_C(0x400338c9),
         UINT32_C(0x280f9cd4),
         UINT32_C(0x1003415e),
         UINT32_C(0x780fe543),
         UINT32_C(0x50007997),
         UINT32_C(0x380cdd8a),
         UINT32_C(0x000300b2),
         UINT32_C(0x680fa4af),
         UINT32_C(0x4000387b),
         UINT32_C(0x280c9c66),
         UINT32_C(0x100041ec),
         UINT32_C(0x780ce5f1),
         UINT32_C(0x50037925),
         UINT32_C(0x380fdd38)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb40652),
         UINT32_C(0x3fa0019c),
         UINT32_C(0x3f9407ce),
         UINT32_C(0x3f8801a0),
         UINT32_C(0x3fbc07f2),
         UINT32_C(0x3fa8003c),
         UINT32_C(0x3f9c066e),
         UINT32_C(0x3f800180),
         UINT32_C(0x3fb407d2),
         UINT32_C(0x3fa0001c),
         UINT32_C(0x3f94064e),
         UINT32_C(0x3f880020),
         UINT32_C(0x3fbc0672),
         UINT32_C(0x3fa801bc),
         UINT32_C(0x3f9c07ee)},
        UINT32_C(0xfff80000),
        {0x57,0xb1,0x39,0xad,0x77,0xf6,0x11,0xab,0x8e,0x87,
         0xbd,0x92,0xe6,0x1c,0x36,0x3f,0x11,0x36,0x4b,0x13,0x00}
    },
    {
        /* No.192 delta:760 weight:1213 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa615d0a5),
         UINT32_C(0x36265494),
         UINT32_C(0x90338431),
         UINT32_C(0x4cc00c07),
         UINT32_C(0xead5dca2),
         UINT32_C(0x7ae65893),
         UINT32_C(0xdcf38836),
         UINT32_C(0x0000b3d1),
         UINT32_C(0xa6156374),
         UINT32_C(0x3626e745),
         UINT32_C(0x903337e0),
         UINT32_C(0x4cc0bfd6),
         UINT32_C(0xead56f73),
         UINT32_C(0x7ae6eb42),
         UINT32_C(0xdcf33be7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x103e2c7e),
         UINT32_C(0x400109b1),
         UINT32_C(0x503f25cf),
         UINT32_C(0x00023c18),
         UINT32_C(0x103c1066),
         UINT32_C(0x400335a9),
         UINT32_C(0x503d19d7),
         UINT32_C(0x5040180c),
         UINT32_C(0x407e3472),
         UINT32_C(0x104111bd),
         UINT32_C(0x007f3dc3),
         UINT32_C(0x50422414),
         UINT32_C(0x407c086a),
         UINT32_C(0x10432da5),
         UINT32_C(0x007d01db)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881f16),
         UINT32_C(0x3fa00084),
         UINT32_C(0x3fa81f92),
         UINT32_C(0x3f80011e),
         UINT32_C(0x3f881e08),
         UINT32_C(0x3fa0019a),
         UINT32_C(0x3fa81e8c),
         UINT32_C(0x3fa8200c),
         UINT32_C(0x3fa03f1a),
         UINT32_C(0x3f882088),
         UINT32_C(0x3f803f9e),
         UINT32_C(0x3fa82112),
         UINT32_C(0x3fa03e04),
         UINT32_C(0x3f882196),
         UINT32_C(0x3f803e80)},
        UINT32_C(0xfff80000),
        {0xd8,0xc1,0x31,0x89,0x51,0xc4,0x64,0x36,0x0a,0x93,
         0x66,0x13,0xb2,0x95,0xaa,0xc1,0xc3,0xc0,0xb8,0x8b,0x00}
    },
    {
        /* No.193 delta:1152 weight:1405 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2a562cc2),
         UINT32_C(0x5301e69e),
         UINT32_C(0x7957ca5c),
         UINT32_C(0x56500c10),
         UINT32_C(0x7c0620d2),
         UINT32_C(0x0551ea8e),
         UINT32_C(0x2f07c64c),
         UINT32_C(0x00005e85),
         UINT32_C(0x2a567247),
         UINT32_C(0x5301b81b),
         UINT32_C(0x795794d9),
         UINT32_C(0x56505295),
         UINT32_C(0x7c067e57),
         UINT32_C(0x0551b40b),
         UINT32_C(0x2f0798c9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0074a472),
         UINT32_C(0x002b317b),
         UINT32_C(0x005f9509),
         UINT32_C(0x000845d7),
         UINT32_C(0x007ce1a5),
         UINT32_C(0x002374ac),
         UINT32_C(0x0057d0de),
         UINT32_C(0x188c149f),
         UINT32_C(0x18f8b0ed),
         UINT32_C(0x18a725e4),
         UINT32_C(0x18d38196),
         UINT32_C(0x18845148),
         UINT32_C(0x18f0f53a),
         UINT32_C(0x18af6033),
         UINT32_C(0x18dbc441)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a52),
         UINT32_C(0x3f801598),
         UINT32_C(0x3f802fca),
         UINT32_C(0x3f800422),
         UINT32_C(0x3f803e70),
         UINT32_C(0x3f8011ba),
         UINT32_C(0x3f802be8),
         UINT32_C(0x3f8c460a),
         UINT32_C(0x3f8c7c58),
         UINT32_C(0x3f8c5392),
         UINT32_C(0x3f8c69c0),
         UINT32_C(0x3f8c4228),
         UINT32_C(0x3f8c787a),
         UINT32_C(0x3f8c57b0),
         UINT32_C(0x3f8c6de2)},
        UINT32_C(0xfff80000),
        {0xd9,0x61,0xf1,0xb6,0x98,0x11,0x7c,0xe3,0x44,0x58,
         0xdf,0x98,0xd0,0xad,0x22,0x7d,0x82,0x7f,0x7d,0x68,0x00}
    },
    {
        /* No.194 delta:830 weight:741 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8cd9e453),
         UINT32_C(0xa9431e7a),
         UINT32_C(0x259afa29),
         UINT32_C(0xb3700c2d),
         UINT32_C(0x3fa9e87e),
         UINT32_C(0x1a331257),
         UINT32_C(0x96eaf604),
         UINT32_C(0x0000f7a7),
         UINT32_C(0x8cd913f4),
         UINT32_C(0xa943e9dd),
         UINT32_C(0x259a0d8e),
         UINT32_C(0xb370fb8a),
         UINT32_C(0x3fa91fd9),
         UINT32_C(0x1a33e5f0),
         UINT32_C(0x96ea01a3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x90a5295b),
         UINT32_C(0x204211b1),
         UINT32_C(0xb0e738ea),
         UINT32_C(0x40400013),
         UINT32_C(0xd0e52948),
         UINT32_C(0x600211a2),
         UINT32_C(0xf0a738f9),
         UINT32_C(0x20205854),
         UINT32_C(0xb085710f),
         UINT32_C(0x006249e5),
         UINT32_C(0x90c760be),
         UINT32_C(0x60605847),
         UINT32_C(0xf0c5711c),
         UINT32_C(0x402249f6),
         UINT32_C(0xd08760ad)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc85294),
         UINT32_C(0x3f902108),
         UINT32_C(0x3fd8739c),
         UINT32_C(0x3fa02000),
         UINT32_C(0x3fe87294),
         UINT32_C(0x3fb00108),
         UINT32_C(0x3ff8539c),
         UINT32_C(0x3f90102c),
         UINT32_C(0x3fd842b8),
         UINT32_C(0x3f803124),
         UINT32_C(0x3fc863b0),
         UINT32_C(0x3fb0302c),
         UINT32_C(0x3ff862b8),
         UINT32_C(0x3fa01124),
         UINT32_C(0x3fe843b0)},
        UINT32_C(0xfff80000),
        {0x48,0x4b,0x3d,0x12,0xa2,0x94,0xb1,0x8c,0xf5,0xfb,
         0xa5,0xaf,0x07,0xa0,0xdb,0xe9,0xfa,0x44,0xed,0xb7,0x00}
    },
    {
        /* No.195 delta:2879 weight:775 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xff682600),
         UINT32_C(0xf74c4baa),
         UINT32_C(0x08246daa),
         UINT32_C(0x24100c3b),
         UINT32_C(0xdb782a3b),
         UINT32_C(0xd35c4791),
         UINT32_C(0x2c346191),
         UINT32_C(0x0000ffe5),
         UINT32_C(0xff68d9e5),
         UINT32_C(0xf74cb44f),
         UINT32_C(0x0824924f),
         UINT32_C(0x2410f3de),
         UINT32_C(0xdb78d5de),
         UINT32_C(0xd35cb874),
         UINT32_C(0x2c349e74)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc030959e),
         UINT32_C(0x9050a099),
         UINT32_C(0x50603507),
         UINT32_C(0x802601ba),
         UINT32_C(0x40169424),
         UINT32_C(0x1076a123),
         UINT32_C(0xd04634bd),
         UINT32_C(0xf014ce13),
         UINT32_C(0x30245b8d),
         UINT32_C(0x60446e8a),
         UINT32_C(0xa074fb14),
         UINT32_C(0x7032cfa9),
         UINT32_C(0xb0025a37),
         UINT32_C(0xe0626f30),
         UINT32_C(0x2052faae)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe0184a),
         UINT32_C(0x3fc82850),
         UINT32_C(0x3fa8301a),
         UINT32_C(0x3fc01300),
         UINT32_C(0x3fa00b4a),
         UINT32_C(0x3f883b50),
         UINT32_C(0x3fe8231a),
         UINT32_C(0x3ff80a67),
         UINT32_C(0x3f98122d),
         UINT32_C(0x3fb02237),
         UINT32_C(0x3fd03a7d),
         UINT32_C(0x3fb81967),
         UINT32_C(0x3fd8012d),
         UINT32_C(0x3ff03137),
         UINT32_C(0x3f90297d)},
        UINT32_C(0xfff80000),
        {0x3d,0xf6,0x9a,0x6e,0x6b,0x65,0x93,0x08,0x5e,0x4b,
         0x6a,0x30,0xfd,0x5d,0x93,0x81,0x59,0xda,0xe1,0x46,0x00}
    },
    {
        /* No.196 delta:949 weight:1287 */
        11213,
        39,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7d54e010),
         UINT32_C(0x9f44b63a),
         UINT32_C(0xe210562a),
         UINT32_C(0xd9500c42),
         UINT32_C(0xa404ec52),
         UINT32_C(0x4614ba78),
         UINT32_C(0x3b405a68),
         UINT32_C(0x0000e124),
         UINT32_C(0x7d540134),
         UINT32_C(0x9f44571e),
         UINT32_C(0xe210b70e),
         UINT32_C(0xd950ed66),
         UINT32_C(0xa4040d76),
         UINT32_C(0x46145b5c),
         UINT32_C(0x3b40bb4c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x207e16bb),
         UINT32_C(0x1030a309),
         UINT32_C(0x304eb5b2),
         UINT32_C(0x0063c14f),
         UINT32_C(0x201dd7f4),
         UINT32_C(0x10536246),
         UINT32_C(0x302d74fd),
         UINT32_C(0x0002a401),
         UINT32_C(0x207cb2ba),
         UINT32_C(0x10320708),
         UINT32_C(0x304c11b3),
         UINT32_C(0x0061654e),
         UINT32_C(0x201f73f5),
         UINT32_C(0x1051c647),
         UINT32_C(0x302fd0fc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f903f0b),
         UINT32_C(0x3f881851),
         UINT32_C(0x3f98275a),
         UINT32_C(0x3f8031e0),
         UINT32_C(0x3f900eeb),
         UINT32_C(0x3f8829b1),
         UINT32_C(0x3f9816ba),
         UINT32_C(0x3f800152),
         UINT32_C(0x3f903e59),
         UINT32_C(0x3f881903),
         UINT32_C(0x3f982608),
         UINT32_C(0x3f8030b2),
         UINT32_C(0x3f900fb9),
         UINT32_C(0x3f8828e3),
         UINT32_C(0x3f9817e8)},
        UINT32_C(0xfff80000),
        {0xef,0x4e,0xef,0x76,0x36,0xad,0x27,0xbf,0xbe,0xf2,
         0xb6,0x37,0x72,0xee,0x0d,0xf6,0xc0,0x73,0x4e,0xcb,0x00}
    },
    {
        /* No.197 delta:1232 weight:1565 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x03ab6700),
         UINT32_C(0x3a6567b0),
         UINT32_C(0x39ce00b0),
         UINT32_C(0x81b00c5d),
         UINT32_C(0x821b6b5d),
         UINT32_C(0xbbd56bed),
         UINT32_C(0xb87e0ced),
         UINT32_C(0x0000770e),
         UINT32_C(0x03ab100e),
         UINT32_C(0x3a6510be),
         UINT32_C(0x39ce77be),
         UINT32_C(0x81b07b53),
         UINT32_C(0x821b1c53),
         UINT32_C(0xbbd51ce3),
         UINT32_C(0xb87e7be3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x202e803a),
         UINT32_C(0x0002114e),
         UINT32_C(0x202c9174),
         UINT32_C(0x80382018),
         UINT32_C(0xa016a022),
         UINT32_C(0x803a3156),
         UINT32_C(0xa014b16c),
         UINT32_C(0x406830c8),
         UINT32_C(0x6046b0f2),
         UINT32_C(0x406a2186),
         UINT32_C(0x6044a1bc),
         UINT32_C(0xc05010d0),
         UINT32_C(0xe07e90ea),
         UINT32_C(0xc052019e),
         UINT32_C(0xe07c81a4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f901740),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f901648),
         UINT32_C(0x3fc01c10),
         UINT32_C(0x3fd00b50),
         UINT32_C(0x3fc01d18),
         UINT32_C(0x3fd00a58),
         UINT32_C(0x3fa03418),
         UINT32_C(0x3fb02358),
         UINT32_C(0x3fa03510),
         UINT32_C(0x3fb02250),
         UINT32_C(0x3fe02808),
         UINT32_C(0x3ff03f48),
         UINT32_C(0x3fe02900),
         UINT32_C(0x3ff03e40)},
        UINT32_C(0xfff80000),
        {0x0f,0xde,0x34,0x7f,0xb2,0x37,0x9a,0xef,0x08,0x8e,
         0x0d,0x5d,0x68,0xdf,0xfd,0x51,0x8e,0xe6,0x31,0x13,0x00}
    },
    {
        /* No.198 delta:2483 weight:1073 */
        11213,
        6,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x61924bce),
         UINT32_C(0x6cc60700),
         UINT32_C(0x0d544cce),
         UINT32_C(0x93700c63),
         UINT32_C(0xf2e247ad),
         UINT32_C(0xffb60b63),
         UINT32_C(0x9e2440ad),
         UINT32_C(0x00001b81),
         UINT32_C(0x6192504f),
         UINT32_C(0x6cc61c81),
         UINT32_C(0x0d54574f),
         UINT32_C(0x937017e2),
         UINT32_C(0xf2e25c2c),
         UINT32_C(0xffb610e2),
         UINT32_C(0x9e245b2c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x83d01574),
         UINT32_C(0x1b0a01de),
         UINT32_C(0x98da14aa),
         UINT32_C(0x0e262003),
         UINT32_C(0x8df63577),
         UINT32_C(0x152c21dd),
         UINT32_C(0x96fc34a9),
         UINT32_C(0x1e181411),
         UINT32_C(0x9dc80165),
         UINT32_C(0x051215cf),
         UINT32_C(0x86c200bb),
         UINT32_C(0x103e3412),
         UINT32_C(0x93ee2166),
         UINT32_C(0x0b3435cc),
         UINT32_C(0x88e420b8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc1e80a),
         UINT32_C(0x3f8d8500),
         UINT32_C(0x3fcc6d0a),
         UINT32_C(0x3f871310),
         UINT32_C(0x3fc6fb1a),
         UINT32_C(0x3f8a9610),
         UINT32_C(0x3fcb7e1a),
         UINT32_C(0x3f8f0c0a),
         UINT32_C(0x3fcee400),
         UINT32_C(0x3f82890a),
         UINT32_C(0x3fc36100),
         UINT32_C(0x3f881f1a),
         UINT32_C(0x3fc9f710),
         UINT32_C(0x3f859a1a),
         UINT32_C(0x3fc47210)},
        UINT32_C(0xfff80000),
        {0xa6,0x78,0x00,0x0c,0x62,0x97,0x94,0x6c,0xb7,0xf6,
         0xbc,0x41,0xb1,0x29,0xe5,0x9c,0x5f,0x37,0xaa,0x79,0x00}
    },
    {
        /* No.199 delta:3090 weight:657 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4b70564e),
         UINT32_C(0x58ad48a7),
         UINT32_C(0x13dd1ee9),
         UINT32_C(0xbaa00c75),
         UINT32_C(0xf1d05a3b),
         UINT32_C(0xe20d44d2),
         UINT32_C(0xa97d129c),
         UINT32_C(0x0000d9bf),
         UINT32_C(0x4b708ff1),
         UINT32_C(0x58ad9118),
         UINT32_C(0x13ddc756),
         UINT32_C(0xbaa0d5ca),
         UINT32_C(0xf1d08384),
         UINT32_C(0xe20d9d6d),
         UINT32_C(0xa97dcb23)},
        {UINT32_C(0x00000000),
         UINT32_C(0xb0f01e5e),
         UINT32_C(0x08c04155),
         UINT32_C(0xb8305f0b),
         UINT32_C(0xc0085078),
         UINT32_C(0x70f84e26),
         UINT32_C(0xc8c8112d),
         UINT32_C(0x78380f73),
         UINT32_C(0x3618200f),
         UINT32_C(0x86e83e51),
         UINT32_C(0x3ed8615a),
         UINT32_C(0x8e287f04),
         UINT32_C(0xf6107077),
         UINT32_C(0x46e06e29),
         UINT32_C(0xfed03122),
         UINT32_C(0x4e202f7c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd8780f),
         UINT32_C(0x3f846020),
         UINT32_C(0x3fdc182f),
         UINT32_C(0x3fe00428),
         UINT32_C(0x3fb87c27),
         UINT32_C(0x3fe46408),
         UINT32_C(0x3fbc1c07),
         UINT32_C(0x3f9b0c10),
         UINT32_C(0x3fc3741f),
         UINT32_C(0x3f9f6c30),
         UINT32_C(0x3fc7143f),
         UINT32_C(0x3ffb0838),
         UINT32_C(0x3fa37037),
         UINT32_C(0x3fff6818),
         UINT32_C(0x3fa71017)},
        UINT32_C(0xfff80000),
        {0x77,0x27,0xbd,0xef,0xef,0x2a,0x66,0xc1,0xb7,0x5e,
         0x51,0x52,0x94,0xd0,0xf8,0x35,0xfa,0x0d,0x43,0x0a,0x00}
    },
    {
        /* No.200 delta:740 weight:741 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8f869099),
         UINT32_C(0x3346f936),
         UINT32_C(0xbcc069af),
         UINT32_C(0x55700c8a),
         UINT32_C(0xdaf69c13),
         UINT32_C(0x6636f5bc),
         UINT32_C(0xe9b06525),
         UINT32_C(0x000036a5),
         UINT32_C(0x8f86a63c),
         UINT32_C(0x3346cf93),
         UINT32_C(0xbcc05f0a),
         UINT32_C(0x55703a2f),
         UINT32_C(0xdaf6aab6),
         UINT32_C(0x6636c319),
         UINT32_C(0xe9b05380)},
        {UINT32_C(0x00000000),
         UINT32_C(0x704c0036),
         UINT32_C(0x20620511),
         UINT32_C(0x502e0527),
         UINT32_C(0x103101cb),
         UINT32_C(0x607d01fd),
         UINT32_C(0x305304da),
         UINT32_C(0x401f04ec),
         UINT32_C(0x6003a014),
         UINT32_C(0x104fa022),
         UINT32_C(0x4061a505),
         UINT32_C(0x302da533),
         UINT32_C(0x7032a1df),
         UINT32_C(0x007ea1e9),
         UINT32_C(0x5050a4ce),
         UINT32_C(0x201ca4f8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb82600),
         UINT32_C(0x3f903102),
         UINT32_C(0x3fa81702),
         UINT32_C(0x3f881880),
         UINT32_C(0x3fb03e80),
         UINT32_C(0x3f982982),
         UINT32_C(0x3fa00f82),
         UINT32_C(0x3fb001d0),
         UINT32_C(0x3f8827d0),
         UINT32_C(0x3fa030d2),
         UINT32_C(0x3f9816d2),
         UINT32_C(0x3fb81950),
         UINT32_C(0x3f803f50),
         UINT32_C(0x3fa82852),
         UINT32_C(0x3f900e52)},
        UINT32_C(0xfff80000),
        {0xf2,0xbb,0xb7,0x23,0x62,0xc4,0x51,0x55,0x4e,0xfd,
         0x6a,0xa0,0x00,0x9a,0x5f,0x5c,0xc9,0x8b,0xe1,0xad,0x00}
    },
    {
        /* No.201 delta:1425 weight:1547 */
        11213,
        17,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x135e711b),
         UINT32_C(0x4f1a6841),
         UINT32_C(0x5c44195a),
         UINT32_C(0x29b00c9f),
         UINT32_C(0x3aee7d84),
         UINT32_C(0x66aa64de),
         UINT32_C(0x75f415c5),
         UINT32_C(0x0000262f),
         UINT32_C(0x135e5734),
         UINT32_C(0x4f1a4e6e),
         UINT32_C(0x5c443f75),
         UINT32_C(0x29b02ab0),
         UINT32_C(0x3aee5bab),
         UINT32_C(0x66aa42f1),
         UINT32_C(0x75f433ea)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2ced025e),
         UINT32_C(0x33d864e2),
         UINT32_C(0x1f3566bc),
         UINT32_C(0x0052e20a),
         UINT32_C(0x2cbfe054),
         UINT32_C(0x338a86e8),
         UINT32_C(0x1f6784b6),
         UINT32_C(0x004c5c0d),
         UINT32_C(0x2ca15e53),
         UINT32_C(0x339438ef),
         UINT32_C(0x1f793ab1),
         UINT32_C(0x001ebe07),
         UINT32_C(0x2cf3bc59),
         UINT32_C(0x33c6dae5),
         UINT32_C(0x1f2bd8bb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f967681),
         UINT32_C(0x3f99ec32),
         UINT32_C(0x3f8f9ab3),
         UINT32_C(0x3f802971),
         UINT32_C(0x3f965ff0),
         UINT32_C(0x3f99c543),
         UINT32_C(0x3f8fb3c2),
         UINT32_C(0x3f80262e),
         UINT32_C(0x3f9650af),
         UINT32_C(0x3f99ca1c),
         UINT32_C(0x3f8fbc9d),
         UINT32_C(0x3f800f5f),
         UINT32_C(0x3f9679de),
         UINT32_C(0x3f99e36d),
         UINT32_C(0x3f8f95ec)},
        UINT32_C(0xfff80000),
        {0x2e,0x3f,0x27,0x5d,0xc5,0x8f,0xb5,0x58,0xd9,0x3d,
         0x14,0x9e,0x59,0x07,0x1b,0x89,0xab,0xd6,0x1b,0x36,0x00}
    },
    {
        /* No.202 delta:1120 weight:1567 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xac59e4f5),
         UINT32_C(0x4a749b39),
         UINT32_C(0xe62d7fcc),
         UINT32_C(0x14200cad),
         UINT32_C(0xb879e858),
         UINT32_C(0x5e549794),
         UINT32_C(0xf20d7361),
         UINT32_C(0x000000e9),
         UINT32_C(0xac59e41c),
         UINT32_C(0x4a749bd0),
         UINT32_C(0xe62d7f25),
         UINT32_C(0x14200c44),
         UINT32_C(0xb879e8b1),
         UINT32_C(0x5e54977d),
         UINT32_C(0xf20d7388)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007c19d6),
         UINT32_C(0x000240f9),
         UINT32_C(0x007e592f),
         UINT32_C(0x0023e00b),
         UINT32_C(0x005ff9dd),
         UINT32_C(0x0021a0f2),
         UINT32_C(0x005db924),
         UINT32_C(0x1041101f),
         UINT32_C(0x103d09c9),
         UINT32_C(0x104350e6),
         UINT32_C(0x103f4930),
         UINT32_C(0x1062f014),
         UINT32_C(0x101ee9c2),
         UINT32_C(0x1060b0ed),
         UINT32_C(0x101ca93b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e0c),
         UINT32_C(0x3f800120),
         UINT32_C(0x3f803f2c),
         UINT32_C(0x3f8011f0),
         UINT32_C(0x3f802ffc),
         UINT32_C(0x3f8010d0),
         UINT32_C(0x3f802edc),
         UINT32_C(0x3f882088),
         UINT32_C(0x3f881e84),
         UINT32_C(0x3f8821a8),
         UINT32_C(0x3f881fa4),
         UINT32_C(0x3f883178),
         UINT32_C(0x3f880f74),
         UINT32_C(0x3f883058),
         UINT32_C(0x3f880e54)},
        UINT32_C(0xfff80000),
        {0xea,0x36,0xa9,0xe3,0x3a,0x26,0xb0,0x23,0x4f,0xf2,
         0x04,0xc7,0x80,0x6f,0x26,0x1b,0xc0,0xd5,0x12,0x07,0x00}
    },
    {
        /* No.203 delta:753 weight:719 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1ff43116),
         UINT32_C(0x3ca75344),
         UINT32_C(0x23536252),
         UINT32_C(0xac600cb8),
         UINT32_C(0xb3943dae),
         UINT32_C(0x90c75ffc),
         UINT32_C(0x8f336eea),
         UINT32_C(0x0000ec4c),
         UINT32_C(0x1ff4dd5a),
         UINT32_C(0x3ca7bf08),
         UINT32_C(0x23538e1e),
         UINT32_C(0xac60e0f4),
         UINT32_C(0xb394d1e2),
         UINT32_C(0x90c7b3b0),
         UINT32_C(0x8f3382a6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4044a13d),
         UINT32_C(0x202280c3),
         UINT32_C(0x606621fe),
         UINT32_C(0x5013e1ba),
         UINT32_C(0x10574087),
         UINT32_C(0x70316179),
         UINT32_C(0x3075c044),
         UINT32_C(0x300809f5),
         UINT32_C(0x704ca8c8),
         UINT32_C(0x102a8936),
         UINT32_C(0x506e280b),
         UINT32_C(0x601be84f),
         UINT32_C(0x205f4972),
         UINT32_C(0x4039688c),
         UINT32_C(0x007dc9b1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02250),
         UINT32_C(0x3f901140),
         UINT32_C(0x3fb03310),
         UINT32_C(0x3fa809f0),
         UINT32_C(0x3f882ba0),
         UINT32_C(0x3fb818b0),
         UINT32_C(0x3f983ae0),
         UINT32_C(0x3f980404),
         UINT32_C(0x3fb82654),
         UINT32_C(0x3f881544),
         UINT32_C(0x3fa83714),
         UINT32_C(0x3fb00df4),
         UINT32_C(0x3f902fa4),
         UINT32_C(0x3fa01cb4),
         UINT32_C(0x3f803ee4)},
        UINT32_C(0xfff80000),
        {0x67,0xa5,0xb8,0x3b,0xd2,0xe3,0x32,0x76,0x7e,0x2c,
         0xc8,0x24,0x35,0x26,0x61,0x3e,0x98,0x93,0xaa,0x04,0x00}
    },
    {
        /* No.204 delta:2490 weight:1505 */
        11213,
        82,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5eafb656),
         UINT32_C(0xb33f8c5e),
         UINT32_C(0xed903a08),
         UINT32_C(0x1c600ccc),
         UINT32_C(0x42cfba9a),
         UINT32_C(0xaf5f8092),
         UINT32_C(0xf1f036c4),
         UINT32_C(0x000062ca),
         UINT32_C(0x5eafd49c),
         UINT32_C(0xb33fee94),
         UINT32_C(0xed9058c2),
         UINT32_C(0x1c606e06),
         UINT32_C(0x42cfd850),
         UINT32_C(0xaf5fe258),
         UINT32_C(0xf1f0540e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3002c1b3),
         UINT32_C(0x000251dd),
         UINT32_C(0x3000906e),
         UINT32_C(0x40008016),
         UINT32_C(0x700241a5),
         UINT32_C(0x4002d1cb),
         UINT32_C(0x70001078),
         UINT32_C(0x0001935a),
         UINT32_C(0x300352e9),
         UINT32_C(0x0003c287),
         UINT32_C(0x30010334),
         UINT32_C(0x4001134c),
         UINT32_C(0x7003d2ff),
         UINT32_C(0x40034291),
         UINT32_C(0x70018322)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980160),
         UINT32_C(0x3f800128),
         UINT32_C(0x3f980048),
         UINT32_C(0x3fa00040),
         UINT32_C(0x3fb80120),
         UINT32_C(0x3fa00168),
         UINT32_C(0x3fb80008),
         UINT32_C(0x3f8000c9),
         UINT32_C(0x3f9801a9),
         UINT32_C(0x3f8001e1),
         UINT32_C(0x3f980081),
         UINT32_C(0x3fa00089),
         UINT32_C(0x3fb801e9),
         UINT32_C(0x3fa001a1),
         UINT32_C(0x3fb800c1)},
        UINT32_C(0xfff80000),
        {0x1e,0x97,0x10,0x94,0x21,0xb5,0xf6,0x23,0xac,0xeb,
         0x87,0x1b,0xfe,0x7d,0x9a,0xb2,0xe0,0x55,0x2e,0x99,0x00}
    },
    {
        /* No.205 delta:1418 weight:1259 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb013d5ad),
         UINT32_C(0x92b7f4e1),
         UINT32_C(0x22a4214c),
         UINT32_C(0xee400cdd),
         UINT32_C(0x5e53d970),
         UINT32_C(0x7cf7f83c),
         UINT32_C(0xcce42d91),
         UINT32_C(0x00002e80),
         UINT32_C(0xb013fb2d),
         UINT32_C(0x92b7da61),
         UINT32_C(0x22a40fcc),
         UINT32_C(0xee40225d),
         UINT32_C(0x5e53f7f0),
         UINT32_C(0x7cf7d6bc),
         UINT32_C(0xcce40311)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004280f7),
         UINT32_C(0x200501c2),
         UINT32_C(0x20478135),
         UINT32_C(0x1000018b),
         UINT32_C(0x1042817c),
         UINT32_C(0x30050049),
         UINT32_C(0x304780be),
         UINT32_C(0x100301d1),
         UINT32_C(0x10418126),
         UINT32_C(0x30060013),
         UINT32_C(0x304480e4),
         UINT32_C(0x0003005a),
         UINT32_C(0x004180ad),
         UINT32_C(0x20060198),
         UINT32_C(0x2044816f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802140),
         UINT32_C(0x3f900280),
         UINT32_C(0x3f9023c0),
         UINT32_C(0x3f880000),
         UINT32_C(0x3f882140),
         UINT32_C(0x3f980280),
         UINT32_C(0x3f9823c0),
         UINT32_C(0x3f880180),
         UINT32_C(0x3f8820c0),
         UINT32_C(0x3f980300),
         UINT32_C(0x3f982240),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f8020c0),
         UINT32_C(0x3f900300),
         UINT32_C(0x3f902240)},
        UINT32_C(0xfff80000),
        {0x9c,0x84,0x7d,0x4e,0xc8,0xee,0xe3,0x0a,0x73,0x0a,
         0x36,0x27,0x06,0xf5,0x9b,0x70,0xdb,0x20,0xd2,0x7c,0x00}
    },
    {
        /* No.206 delta:835 weight:1117 */
        11213,
        50,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xabe51a17),
         UINT32_C(0x92f9658b),
         UINT32_C(0x391c7f9c),
         UINT32_C(0xf5300cec),
         UINT32_C(0x5ed516fb),
         UINT32_C(0x67c96967),
         UINT32_C(0xcc2c7370),
         UINT32_C(0x0000c823),
         UINT32_C(0xabe5d234),
         UINT32_C(0x92f9ada8),
         UINT32_C(0x391cb7bf),
         UINT32_C(0xf530c4cf),
         UINT32_C(0x5ed5ded8),
         UINT32_C(0x67c9a144),
         UINT32_C(0xcc2cbb53)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc000201f),
         UINT32_C(0x00020415),
         UINT32_C(0xc002240a),
         UINT32_C(0x1000820c),
         UINT32_C(0xd000a213),
         UINT32_C(0x10028619),
         UINT32_C(0xd002a606),
         UINT32_C(0x60004812),
         UINT32_C(0xa000680d),
         UINT32_C(0x60024c07),
         UINT32_C(0xa0026c18),
         UINT32_C(0x7000ca1e),
         UINT32_C(0xb000ea01),
         UINT32_C(0x7002ce0b),
         UINT32_C(0xb002ee14)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe00010),
         UINT32_C(0x3f800102),
         UINT32_C(0x3fe00112),
         UINT32_C(0x3f880041),
         UINT32_C(0x3fe80051),
         UINT32_C(0x3f880143),
         UINT32_C(0x3fe80153),
         UINT32_C(0x3fb00024),
         UINT32_C(0x3fd00034),
         UINT32_C(0x3fb00126),
         UINT32_C(0x3fd00136),
         UINT32_C(0x3fb80065),
         UINT32_C(0x3fd80075),
         UINT32_C(0x3fb80167),
         UINT32_C(0x3fd80177)},
        UINT32_C(0xfff80000),
        {0x69,0xf5,0xd3,0xed,0xb9,0x43,0x3a,0x4a,0x87,0xe0,
         0xc1,0x10,0x6c,0xb0,0x55,0x6c,0xd4,0x9e,0xe5,0x90,0x00}
    },
    {
        /* No.207 delta:670 weight:1477 */
        11213,
        82,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x00a0fbb0),
         UINT32_C(0xe2484b5d),
         UINT32_C(0xe2e8b0ed),
         UINT32_C(0x40d00cfc),
         UINT32_C(0x4070f74c),
         UINT32_C(0xa29847a1),
         UINT32_C(0xa238bc11),
         UINT32_C(0x0000f40d),
         UINT32_C(0x00a00fbd),
         UINT32_C(0xe248bf50),
         UINT32_C(0xe2e844e0),
         UINT32_C(0x40d0f8f1),
         UINT32_C(0x40700341),
         UINT32_C(0xa298b3ac),
         UINT32_C(0xa238481c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000253fe),
         UINT32_C(0x0048217a),
         UINT32_C(0x004a7284),
         UINT32_C(0x120408ad),
         UINT32_C(0x12065b53),
         UINT32_C(0x124c29d7),
         UINT32_C(0x124e7a29),
         UINT32_C(0x1040c1bc),
         UINT32_C(0x10429242),
         UINT32_C(0x1008e0c6),
         UINT32_C(0x100ab338),
         UINT32_C(0x0244c911),
         UINT32_C(0x02469aef),
         UINT32_C(0x020ce86b),
         UINT32_C(0x020ebb95)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800129),
         UINT32_C(0x3f802410),
         UINT32_C(0x3f802539),
         UINT32_C(0x3f890204),
         UINT32_C(0x3f89032d),
         UINT32_C(0x3f892614),
         UINT32_C(0x3f89273d),
         UINT32_C(0x3f882060),
         UINT32_C(0x3f882149),
         UINT32_C(0x3f880470),
         UINT32_C(0x3f880559),
         UINT32_C(0x3f812264),
         UINT32_C(0x3f81234d),
         UINT32_C(0x3f810674),
         UINT32_C(0x3f81075d)},
        UINT32_C(0xfff80000),
        {0x99,0x83,0x87,0x20,0xf2,0x97,0x99,0xd5,0xd2,0x77,
         0x6e,0xb7,0x02,0x7a,0xa4,0xd0,0xc9,0x3e,0xe7,0x8b,0x00}
    },
    {
        /* No.208 delta:827 weight:747 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6ab7503d),
         UINT32_C(0x78c35ee8),
         UINT32_C(0x12740ed5),
         UINT32_C(0x0a200d05),
         UINT32_C(0x60975d38),
         UINT32_C(0x72e353ed),
         UINT32_C(0x185403d0),
         UINT32_C(0x0000d2c7),
         UINT32_C(0x6ab782fa),
         UINT32_C(0x78c38c2f),
         UINT32_C(0x1274dc12),
         UINT32_C(0x0a20dfc2),
         UINT32_C(0x60978fff),
         UINT32_C(0x72e3812a),
         UINT32_C(0x1854d117)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0c9e017b),
         UINT32_C(0x01503585),
         UINT32_C(0x0dce34fe),
         UINT32_C(0x02020073),
         UINT32_C(0x0e9c0108),
         UINT32_C(0x035235f6),
         UINT32_C(0x0fcc348d),
         UINT32_C(0x0040893c),
         UINT32_C(0x0cde8847),
         UINT32_C(0x0110bcb9),
         UINT32_C(0x0d8ebdc2),
         UINT32_C(0x0242894f),
         UINT32_C(0x0edc8834),
         UINT32_C(0x0312bcca),
         UINT32_C(0x0f8cbdb1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f864f00),
         UINT32_C(0x3f80a81a),
         UINT32_C(0x3f86e71a),
         UINT32_C(0x3f810100),
         UINT32_C(0x3f874e00),
         UINT32_C(0x3f81a91a),
         UINT32_C(0x3f87e61a),
         UINT32_C(0x3f802044),
         UINT32_C(0x3f866f44),
         UINT32_C(0x3f80885e),
         UINT32_C(0x3f86c75e),
         UINT32_C(0x3f812144),
         UINT32_C(0x3f876e44),
         UINT32_C(0x3f81895e),
         UINT32_C(0x3f87c65e)},
        UINT32_C(0xfff80000),
        {0x8f,0x72,0x12,0x18,0x88,0x56,0x56,0x47,0xc7,0x52,
         0x17,0xcf,0x89,0x98,0x5f,0xc8,0x8b,0x6c,0x5f,0xe5,0x00}
    },
    {
        /* No.209 delta:755 weight:1449 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x71586746),
         UINT32_C(0xfa76fda6),
         UINT32_C(0x8b2e9ae0),
         UINT32_C(0xe0d00d16),
         UINT32_C(0x91886a50),
         UINT32_C(0x1aa6f0b0),
         UINT32_C(0x6bfe97f6),
         UINT32_C(0x00000411),
         UINT32_C(0x71586357),
         UINT32_C(0xfa76f9b7),
         UINT32_C(0x8b2e9ef1),
         UINT32_C(0xe0d00907),
         UINT32_C(0x91886e41),
         UINT32_C(0x1aa6f4a1),
         UINT32_C(0x6bfe93e7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10834dd3),
         UINT32_C(0x7001a5de),
         UINT32_C(0x6082e80d),
         UINT32_C(0x4021601b),
         UINT32_C(0x50a22dc8),
         UINT32_C(0x3020c5c5),
         UINT32_C(0x20a38816),
         UINT32_C(0x6001f121),
         UINT32_C(0x7082bcf2),
         UINT32_C(0x100054ff),
         UINT32_C(0x0083192c),
         UINT32_C(0x2020913a),
         UINT32_C(0x30a3dce9),
         UINT32_C(0x502134e4),
         UINT32_C(0x40a27937)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8841a6),
         UINT32_C(0x3fb800d2),
         UINT32_C(0x3fb04174),
         UINT32_C(0x3fa010b0),
         UINT32_C(0x3fa85116),
         UINT32_C(0x3f981062),
         UINT32_C(0x3f9051c4),
         UINT32_C(0x3fb000f8),
         UINT32_C(0x3fb8415e),
         UINT32_C(0x3f88002a),
         UINT32_C(0x3f80418c),
         UINT32_C(0x3f901048),
         UINT32_C(0x3f9851ee),
         UINT32_C(0x3fa8109a),
         UINT32_C(0x3fa0513c)},
        UINT32_C(0xfff80000),
        {0xd7,0xad,0x88,0x14,0x6e,0x50,0xe8,0xc2,0x45,0x39,
         0x5f,0x00,0xb8,0x4b,0xf8,0x7f,0xa4,0x5b,0xad,0xac,0x00}
    },
    {
        /* No.210 delta:586 weight:1381 */
        11213,
        79,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb126e2d0),
         UINT32_C(0xeb81c72e),
         UINT32_C(0x5aa725fe),
         UINT32_C(0x05000d23),
         UINT32_C(0xb426eff3),
         UINT32_C(0xee81ca0d),
         UINT32_C(0x5fa728dd),
         UINT32_C(0x0000b8f6),
         UINT32_C(0xb1265a26),
         UINT32_C(0xeb817fd8),
         UINT32_C(0x5aa79d08),
         UINT32_C(0x0500b5d5),
         UINT32_C(0xb4265705),
         UINT32_C(0xee8172fb),
         UINT32_C(0x5fa7902b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x21001656),
         UINT32_C(0x0002b01a),
         UINT32_C(0x2102a64c),
         UINT32_C(0x40000143),
         UINT32_C(0x61001715),
         UINT32_C(0x4002b159),
         UINT32_C(0x6102a70f),
         UINT32_C(0x900c082e),
         UINT32_C(0xb10c1e78),
         UINT32_C(0x900eb834),
         UINT32_C(0xb10eae62),
         UINT32_C(0xd00c096d),
         UINT32_C(0xf10c1f3b),
         UINT32_C(0xd00eb977),
         UINT32_C(0xf10eaf21)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90800b),
         UINT32_C(0x3f800158),
         UINT32_C(0x3f908153),
         UINT32_C(0x3fa00000),
         UINT32_C(0x3fb0800b),
         UINT32_C(0x3fa00158),
         UINT32_C(0x3fb08153),
         UINT32_C(0x3fc80604),
         UINT32_C(0x3fd8860f),
         UINT32_C(0x3fc8075c),
         UINT32_C(0x3fd88757),
         UINT32_C(0x3fe80604),
         UINT32_C(0x3ff8860f),
         UINT32_C(0x3fe8075c),
         UINT32_C(0x3ff88757)},
        UINT32_C(0xfff80000),
        {0x9f,0x18,0x29,0xdb,0xe3,0xe7,0x0c,0xf9,0xe8,0x52,
         0x7f,0xe7,0x53,0x58,0x10,0xfa,0x39,0x2b,0x01,0x90,0x00}
    },
    {
        /* No.211 delta:583 weight:1397 */
        11213,
        81,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x882e2760),
         UINT32_C(0x600360c7),
         UINT32_C(0xe82d47a7),
         UINT32_C(0x87b00d33),
         UINT32_C(0x0f9e2a53),
         UINT32_C(0xe7b36df4),
         UINT32_C(0x6f9d4a94),
         UINT32_C(0x00005355),
         UINT32_C(0x882e7435),
         UINT32_C(0x60033392),
         UINT32_C(0xe82d14f2),
         UINT32_C(0x87b05e66),
         UINT32_C(0x0f9e7906),
         UINT32_C(0xe7b33ea1),
         UINT32_C(0x6f9d19c1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x31648495),
         UINT32_C(0x0001981a),
         UINT32_C(0x31651c8f),
         UINT32_C(0x202c0199),
         UINT32_C(0x1148850c),
         UINT32_C(0x202d9983),
         UINT32_C(0x11491d16),
         UINT32_C(0x002220a7),
         UINT32_C(0x3146a432),
         UINT32_C(0x0023b8bd),
         UINT32_C(0x31473c28),
         UINT32_C(0x200e213e),
         UINT32_C(0x116aa5ab),
         UINT32_C(0x200fb924),
         UINT32_C(0x116b3db1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f98b242),
         UINT32_C(0x3f8000cc),
         UINT32_C(0x3f98b28e),
         UINT32_C(0x3f901600),
         UINT32_C(0x3f88a442),
         UINT32_C(0x3f9016cc),
         UINT32_C(0x3f88a48e),
         UINT32_C(0x3f801110),
         UINT32_C(0x3f98a352),
         UINT32_C(0x3f8011dc),
         UINT32_C(0x3f98a39e),
         UINT32_C(0x3f900710),
         UINT32_C(0x3f88b552),
         UINT32_C(0x3f9007dc),
         UINT32_C(0x3f88b59e)},
        UINT32_C(0xfff80000),
        {0x6b,0x2c,0xdf,0x43,0x83,0xbf,0xec,0x70,0x70,0x52,
         0x2c,0x4d,0x48,0x48,0xe3,0xfa,0x5a,0x93,0x0a,0x33,0x00}
    },
    {
        /* No.212 delta:1186 weight:1545 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8d36105b),
         UINT32_C(0xc4199cb9),
         UINT32_C(0x492f8ce2),
         UINT32_C(0xd2900d49),
         UINT32_C(0x5fa61d12),
         UINT32_C(0x168991f0),
         UINT32_C(0x9bbf81ab),
         UINT32_C(0x00002cf7),
         UINT32_C(0x8d363cac),
         UINT32_C(0xc419b04e),
         UINT32_C(0x492fa015),
         UINT32_C(0xd29021be),
         UINT32_C(0x5fa631e5),
         UINT32_C(0x1689bd07),
         UINT32_C(0x9bbfad5c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80002a1a),
         UINT32_C(0x02032619),
         UINT32_C(0x82030c03),
         UINT32_C(0x3002c187),
         UINT32_C(0xb002eb9d),
         UINT32_C(0x3201e79e),
         UINT32_C(0xb201cd84),
         UINT32_C(0x0003a6a5),
         UINT32_C(0x80038cbf),
         UINT32_C(0x020080bc),
         UINT32_C(0x8200aaa6),
         UINT32_C(0x30016722),
         UINT32_C(0xb0014d38),
         UINT32_C(0x3202413b),
         UINT32_C(0xb2026b21)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00015),
         UINT32_C(0x3f810193),
         UINT32_C(0x3fc10186),
         UINT32_C(0x3f980160),
         UINT32_C(0x3fd80175),
         UINT32_C(0x3f9900f3),
         UINT32_C(0x3fd900e6),
         UINT32_C(0x3f8001d3),
         UINT32_C(0x3fc001c6),
         UINT32_C(0x3f810040),
         UINT32_C(0x3fc10055),
         UINT32_C(0x3f9800b3),
         UINT32_C(0x3fd800a6),
         UINT32_C(0x3f990120),
         UINT32_C(0x3fd90135)},
        UINT32_C(0xfff80000),
        {0x6d,0x67,0xa8,0xbe,0xe2,0x5e,0xa1,0x6a,0xa9,0x0e,
         0x34,0x31,0x87,0xf7,0xac,0x44,0xfa,0x7e,0x41,0xa2,0x00}
    },
    {
        /* No.213 delta:825 weight:1579 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x01838606),
         UINT32_C(0x71d01ded),
         UINT32_C(0x70539beb),
         UINT32_C(0x96f00d57),
         UINT32_C(0x97738b51),
         UINT32_C(0xe72010ba),
         UINT32_C(0xe6a396bc),
         UINT32_C(0x0000ea71),
         UINT32_C(0x01836c77),
         UINT32_C(0x71d0f79c),
         UINT32_C(0x7053719a),
         UINT32_C(0x96f0e726),
         UINT32_C(0x97736120),
         UINT32_C(0xe720facb),
         UINT32_C(0xe6a37ccd)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10026332),
         UINT32_C(0x70001817),
         UINT32_C(0x60027b25),
         UINT32_C(0x100100bb),
         UINT32_C(0x00036389),
         UINT32_C(0x600118ac),
         UINT32_C(0x70037b9e),
         UINT32_C(0x40806053),
         UINT32_C(0x50820361),
         UINT32_C(0x30807844),
         UINT32_C(0x20821b76),
         UINT32_C(0x508160e8),
         UINT32_C(0x408303da),
         UINT32_C(0x208178ff),
         UINT32_C(0x30831bcd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880131),
         UINT32_C(0x3fb8000c),
         UINT32_C(0x3fb0013d),
         UINT32_C(0x3f880080),
         UINT32_C(0x3f8001b1),
         UINT32_C(0x3fb0008c),
         UINT32_C(0x3fb801bd),
         UINT32_C(0x3fa04030),
         UINT32_C(0x3fa84101),
         UINT32_C(0x3f98403c),
         UINT32_C(0x3f90410d),
         UINT32_C(0x3fa840b0),
         UINT32_C(0x3fa04181),
         UINT32_C(0x3f9040bc),
         UINT32_C(0x3f98418d)},
        UINT32_C(0xfff80000),
        {0x09,0x23,0x73,0x01,0xff,0x14,0x1c,0xa3,0xf0,0x4d,
         0xdc,0x38,0x05,0x50,0xb2,0x09,0x8b,0xad,0xa8,0x46,0x00}
    },
    {
        /* No.214 delta:948 weight:969 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0bf25cfd),
         UINT32_C(0x74c8e46d),
         UINT32_C(0x7f3ab890),
         UINT32_C(0x1f800d6e),
         UINT32_C(0x14725193),
         UINT32_C(0x6b48e903),
         UINT32_C(0x60bab5fe),
         UINT32_C(0x0000b8f9),
         UINT32_C(0x0bf2e404),
         UINT32_C(0x74c85c94),
         UINT32_C(0x7f3a0069),
         UINT32_C(0x1f80b597),
         UINT32_C(0x1472e96a),
         UINT32_C(0x6b4851fa),
         UINT32_C(0x60ba0d07)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa05040b6),
         UINT32_C(0x0003900c),
         UINT32_C(0xa053d0ba),
         UINT32_C(0x20501012),
         UINT32_C(0x800050a4),
         UINT32_C(0x2053801e),
         UINT32_C(0x8003c0a8),
         UINT32_C(0x20206419),
         UINT32_C(0x807024af),
         UINT32_C(0x2023f415),
         UINT32_C(0x8073b4a3),
         UINT32_C(0x0070740b),
         UINT32_C(0xa02034bd),
         UINT32_C(0x0073e407),
         UINT32_C(0xa023a4b1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd02820),
         UINT32_C(0x3f8001c8),
         UINT32_C(0x3fd029e8),
         UINT32_C(0x3f902808),
         UINT32_C(0x3fc00028),
         UINT32_C(0x3f9029c0),
         UINT32_C(0x3fc001e0),
         UINT32_C(0x3f901032),
         UINT32_C(0x3fc03812),
         UINT32_C(0x3f9011fa),
         UINT32_C(0x3fc039da),
         UINT32_C(0x3f80383a),
         UINT32_C(0x3fd0101a),
         UINT32_C(0x3f8039f2),
         UINT32_C(0x3fd011d2)},
        UINT32_C(0xfff80000),
        {0xe4,0xd6,0x8f,0x32,0xa8,0x42,0xef,0xb6,0x9d,0x5a,
         0xcf,0x60,0xfd,0x88,0x3d,0xce,0xef,0xfe,0x15,0x79,0x00}
    },
    {
        /* No.215 delta:1475 weight:1683 */
        11213,
        16,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd53ab74c),
         UINT32_C(0xc7105e0d),
         UINT32_C(0x122ae941),
         UINT32_C(0x45400d7a),
         UINT32_C(0x907aba36),
         UINT32_C(0x82505377),
         UINT32_C(0x576ae43b),
         UINT32_C(0x00000c2c),
         UINT32_C(0xd53abb60),
         UINT32_C(0xc7105221),
         UINT32_C(0x122ae56d),
         UINT32_C(0x45400156),
         UINT32_C(0x907ab61a),
         UINT32_C(0x82505f5b),
         UINT32_C(0x576ae817)},
        {UINT32_C(0x00000000),
         UINT32_C(0x08441ad6),
         UINT32_C(0x00446303),
         UINT32_C(0x080079d5),
         UINT32_C(0x205671b2),
         UINT32_C(0x28126b64),
         UINT32_C(0x201212b1),
         UINT32_C(0x28560867),
         UINT32_C(0x0031190f),
         UINT32_C(0x087503d9),
         UINT32_C(0x00757a0c),
         UINT32_C(0x083160da),
         UINT32_C(0x206768bd),
         UINT32_C(0x2823726b),
         UINT32_C(0x20230bbe),
         UINT32_C(0x28671168)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84220d),
         UINT32_C(0x3f802231),
         UINT32_C(0x3f84003c),
         UINT32_C(0x3f902b38),
         UINT32_C(0x3f940935),
         UINT32_C(0x3f900909),
         UINT32_C(0x3f942b04),
         UINT32_C(0x3f80188c),
         UINT32_C(0x3f843a81),
         UINT32_C(0x3f803abd),
         UINT32_C(0x3f8418b0),
         UINT32_C(0x3f9033b4),
         UINT32_C(0x3f9411b9),
         UINT32_C(0x3f901185),
         UINT32_C(0x3f943388)},
        UINT32_C(0xfff80000),
        {0xe7,0x59,0xda,0xc8,0x4b,0xb3,0x0f,0x1e,0xfa,0x17,
         0xe2,0x51,0x72,0xbe,0xed,0xc6,0x33,0x46,0x33,0xb0,0x00}
    },
    {
        /* No.216 delta:837 weight:1593 */
        11213,
        63,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb808e5ef),
         UINT32_C(0x7155b0d3),
         UINT32_C(0xc95d553c),
         UINT32_C(0x93700d87),
         UINT32_C(0x2b78e868),
         UINT32_C(0xe225bd54),
         UINT32_C(0x5a2d58bb),
         UINT32_C(0x0000e70d),
         UINT32_C(0xb80802e2),
         UINT32_C(0x715557de),
         UINT32_C(0xc95db231),
         UINT32_C(0x9370ea8a),
         UINT32_C(0x2b780f65),
         UINT32_C(0xe2255a59),
         UINT32_C(0x5a2dbfb6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0002041f),
         UINT32_C(0x0001e013),
         UINT32_C(0x0003e40c),
         UINT32_C(0x20040348),
         UINT32_C(0x20060757),
         UINT32_C(0x2005e35b),
         UINT32_C(0x2007e744),
         UINT32_C(0x706c09ea),
         UINT32_C(0x706e0df5),
         UINT32_C(0x706de9f9),
         UINT32_C(0x706fede6),
         UINT32_C(0x50680aa2),
         UINT32_C(0x506a0ebd),
         UINT32_C(0x5069eab1),
         UINT32_C(0x506beeae)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800102),
         UINT32_C(0x3f8000f0),
         UINT32_C(0x3f8001f2),
         UINT32_C(0x3f900201),
         UINT32_C(0x3f900303),
         UINT32_C(0x3f9002f1),
         UINT32_C(0x3f9003f3),
         UINT32_C(0x3fb83604),
         UINT32_C(0x3fb83706),
         UINT32_C(0x3fb836f4),
         UINT32_C(0x3fb837f6),
         UINT32_C(0x3fa83405),
         UINT32_C(0x3fa83507),
         UINT32_C(0x3fa834f5),
         UINT32_C(0x3fa835f7)},
        UINT32_C(0xfff80000),
        {0x3a,0x6e,0xf3,0x8e,0xf1,0x1f,0x2e,0xf7,0xc1,0x1b,
         0x4c,0x25,0xdd,0x03,0x57,0x41,0x04,0x3d,0x01,0xdd,0x00}
    },
    {
        /* No.217 delta:1108 weight:1531 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x38b9e580),
         UINT32_C(0x253c3d68),
         UINT32_C(0x1d85d8e8),
         UINT32_C(0xcbd00d91),
         UINT32_C(0xf369e811),
         UINT32_C(0xeeec30f9),
         UINT32_C(0xd655d579),
         UINT32_C(0x0000fd0b),
         UINT32_C(0x38b9188b),
         UINT32_C(0x253cc063),
         UINT32_C(0x1d8525e3),
         UINT32_C(0xcbd0f09a),
         UINT32_C(0xf369151a),
         UINT32_C(0xeeeccdf2),
         UINT32_C(0xd6552872)},
        {UINT32_C(0x00000000),
         UINT32_C(0x046d09b2),
         UINT32_C(0x407401d7),
         UINT32_C(0x44190865),
         UINT32_C(0x000911c9),
         UINT32_C(0x0464187b),
         UINT32_C(0x407d101e),
         UINT32_C(0x441019ac),
         UINT32_C(0x4000201c),
         UINT32_C(0x446d29ae),
         UINT32_C(0x007421cb),
         UINT32_C(0x04192879),
         UINT32_C(0x400931d5),
         UINT32_C(0x44643867),
         UINT32_C(0x007d3002),
         UINT32_C(0x041039b0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f823684),
         UINT32_C(0x3fa03a00),
         UINT32_C(0x3fa20c84),
         UINT32_C(0x3f800488),
         UINT32_C(0x3f82320c),
         UINT32_C(0x3fa03e88),
         UINT32_C(0x3fa2080c),
         UINT32_C(0x3fa00010),
         UINT32_C(0x3fa23694),
         UINT32_C(0x3f803a10),
         UINT32_C(0x3f820c94),
         UINT32_C(0x3fa00498),
         UINT32_C(0x3fa2321c),
         UINT32_C(0x3f803e98),
         UINT32_C(0x3f82081c)},
        UINT32_C(0xfff80000),
        {0xc8,0x6c,0x27,0x5f,0xec,0xc7,0xf5,0x3a,0xbf,0xb3,
         0x55,0xa1,0xa1,0x9f,0x60,0x19,0xac,0x5f,0x18,0x71,0x00}
    },
    {
        /* No.218 delta:894 weight:1525 */
        11213,
        49,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0b862a98),
         UINT32_C(0x1606e550),
         UINT32_C(0x1d80cfc8),
         UINT32_C(0x9d500da0),
         UINT32_C(0x96d62738),
         UINT32_C(0x8b56e8f0),
         UINT32_C(0x80d0c268),
         UINT32_C(0x00001599),
         UINT32_C(0x0b863f01),
         UINT32_C(0x1606f0c9),
         UINT32_C(0x1d80da51),
         UINT32_C(0x9d501839),
         UINT32_C(0x96d632a1),
         UINT32_C(0x8b56fd69),
         UINT32_C(0x80d0d7f1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x001941be),
         UINT32_C(0x5065607d),
         UINT32_C(0x507c21c3),
         UINT32_C(0x10030172),
         UINT32_C(0x101a40cc),
         UINT32_C(0x4066610f),
         UINT32_C(0x407f20b1),
         UINT32_C(0x000251b6),
         UINT32_C(0x001b1008),
         UINT32_C(0x506731cb),
         UINT32_C(0x507e7075),
         UINT32_C(0x100150c4),
         UINT32_C(0x1018117a),
         UINT32_C(0x406430b9),
         UINT32_C(0x407d7107)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800ca0),
         UINT32_C(0x3fa832b0),
         UINT32_C(0x3fa83e10),
         UINT32_C(0x3f880180),
         UINT32_C(0x3f880d20),
         UINT32_C(0x3fa03330),
         UINT32_C(0x3fa03f90),
         UINT32_C(0x3f800128),
         UINT32_C(0x3f800d88),
         UINT32_C(0x3fa83398),
         UINT32_C(0x3fa83f38),
         UINT32_C(0x3f8800a8),
         UINT32_C(0x3f880c08),
         UINT32_C(0x3fa03218),
         UINT32_C(0x3fa03eb8)},
        UINT32_C(0xfff80000),
        {0x1b,0x9b,0xe2,0x40,0x50,0x35,0x38,0x4a,0xd9,0x2f,
         0xe4,0x23,0x03,0xd4,0xb9,0xf8,0xa8,0xab,0x0f,0x6a,0x00}
    },
    {
        /* No.219 delta:891 weight:1533 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9f9392da),
         UINT32_C(0xcdd2dfef),
         UINT32_C(0x52414d35),
         UINT32_C(0x22900dbd),
         UINT32_C(0xbd039f67),
         UINT32_C(0xef42d252),
         UINT32_C(0x70d14088),
         UINT32_C(0x0000c2d2),
         UINT32_C(0x9f935008),
         UINT32_C(0xcdd21d3d),
         UINT32_C(0x52418fe7),
         UINT32_C(0x2290cf6f),
         UINT32_C(0xbd035db5),
         UINT32_C(0xef421080),
         UINT32_C(0x70d1825a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x600600b6),
         UINT32_C(0x0002491d),
         UINT32_C(0x600449ab),
         UINT32_C(0x00016079),
         UINT32_C(0x600760cf),
         UINT32_C(0x00032964),
         UINT32_C(0x600529d2),
         UINT32_C(0x1000501f),
         UINT32_C(0x700650a9),
         UINT32_C(0x10021902),
         UINT32_C(0x700419b4),
         UINT32_C(0x10013066),
         UINT32_C(0x700730d0),
         UINT32_C(0x1003797b),
         UINT32_C(0x700579cd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb00300),
         UINT32_C(0x3f800124),
         UINT32_C(0x3fb00224),
         UINT32_C(0x3f8000b0),
         UINT32_C(0x3fb003b0),
         UINT32_C(0x3f800194),
         UINT32_C(0x3fb00294),
         UINT32_C(0x3f880028),
         UINT32_C(0x3fb80328),
         UINT32_C(0x3f88010c),
         UINT32_C(0x3fb8020c),
         UINT32_C(0x3f880098),
         UINT32_C(0x3fb80398),
         UINT32_C(0x3f8801bc),
         UINT32_C(0x3fb802bc)},
        UINT32_C(0xfff80000),
        {0x82,0xfc,0xf1,0xdf,0xe8,0x96,0x44,0x45,0x91,0xae,
         0x27,0xda,0x06,0x1d,0x00,0xaf,0x72,0x2d,0xa6,0xa3,0x00}
    },
    {
        /* No.220 delta:978 weight:1467 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x236a1f70),
         UINT32_C(0x764e5295),
         UINT32_C(0x55244de5),
         UINT32_C(0xdbf00dc8),
         UINT32_C(0xf89a12b8),
         UINT32_C(0xadbe5f5d),
         UINT32_C(0x8ed4402d),
         UINT32_C(0x0000c9bc),
         UINT32_C(0x236ad6cc),
         UINT32_C(0x764e9b29),
         UINT32_C(0x55248459),
         UINT32_C(0xdbf0c474),
         UINT32_C(0xf89adb04),
         UINT32_C(0xadbe96e1),
         UINT32_C(0x8ed48991)},
        {UINT32_C(0x00000000),
         UINT32_C(0x022d91fa),
         UINT32_C(0x1002207c),
         UINT32_C(0x122fb186),
         UINT32_C(0x5031860e),
         UINT32_C(0x521c17f4),
         UINT32_C(0x4033a672),
         UINT32_C(0x421e3788),
         UINT32_C(0x00114401),
         UINT32_C(0x023cd5fb),
         UINT32_C(0x1013647d),
         UINT32_C(0x123ef587),
         UINT32_C(0x5020c20f),
         UINT32_C(0x520d53f5),
         UINT32_C(0x4022e273),
         UINT32_C(0x420f7389)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8116c8),
         UINT32_C(0x3f880110),
         UINT32_C(0x3f8917d8),
         UINT32_C(0x3fa818c3),
         UINT32_C(0x3fa90e0b),
         UINT32_C(0x3fa019d3),
         UINT32_C(0x3fa10f1b),
         UINT32_C(0x3f8008a2),
         UINT32_C(0x3f811e6a),
         UINT32_C(0x3f8809b2),
         UINT32_C(0x3f891f7a),
         UINT32_C(0x3fa81061),
         UINT32_C(0x3fa906a9),
         UINT32_C(0x3fa01171),
         UINT32_C(0x3fa107b9)},
        UINT32_C(0xfff80000),
        {0x33,0x7b,0x46,0xd2,0xbc,0xf8,0x2c,0x88,0xcc,0xf9,
         0x40,0x12,0x7d,0x61,0x89,0xb2,0xe7,0x15,0x55,0xb6,0x00}
    },
    {
        /* No.221 delta:602 weight:1579 */
        11213,
        77,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x395966ee),
         UINT32_C(0x6cbf26f7),
         UINT32_C(0x55e64019),
         UINT32_C(0xff500dd8),
         UINT32_C(0xc6096b36),
         UINT32_C(0x93ef2b2f),
         UINT32_C(0xaab64dc1),
         UINT32_C(0x00004fb5),
         UINT32_C(0x3959295b),
         UINT32_C(0x6cbf6942),
         UINT32_C(0x55e60fac),
         UINT32_C(0xff50426d),
         UINT32_C(0xc6092483),
         UINT32_C(0x93ef649a),
         UINT32_C(0xaab60274)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3002919e),
         UINT32_C(0x00025a59),
         UINT32_C(0x3000cbc7),
         UINT32_C(0x0401201c),
         UINT32_C(0x3403b182),
         UINT32_C(0x04037a45),
         UINT32_C(0x3401ebdb),
         UINT32_C(0x20000b12),
         UINT32_C(0x10029a8c),
         UINT32_C(0x2002514b),
         UINT32_C(0x1000c0d5),
         UINT32_C(0x24012b0e),
         UINT32_C(0x1403ba90),
         UINT32_C(0x24037157),
         UINT32_C(0x1401e0c9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980148),
         UINT32_C(0x3f80012d),
         UINT32_C(0x3f980065),
         UINT32_C(0x3f820090),
         UINT32_C(0x3f9a01d8),
         UINT32_C(0x3f8201bd),
         UINT32_C(0x3f9a00f5),
         UINT32_C(0x3f900005),
         UINT32_C(0x3f88014d),
         UINT32_C(0x3f900128),
         UINT32_C(0x3f880060),
         UINT32_C(0x3f920095),
         UINT32_C(0x3f8a01dd),
         UINT32_C(0x3f9201b8),
         UINT32_C(0x3f8a00f0)},
        UINT32_C(0xfff80000),
        {0xbf,0x26,0xe4,0x1e,0xa2,0x93,0x19,0x22,0x0d,0xa0,
         0x15,0x2f,0xc9,0x3c,0x83,0x07,0x28,0xf5,0x52,0x45,0x00}
    },
    {
        /* No.222 delta:1212 weight:1493 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x77f6a878),
         UINT32_C(0xb8df422f),
         UINT32_C(0xcf29ea57),
         UINT32_C(0xa9000deb),
         UINT32_C(0xdef6a593),
         UINT32_C(0x11df4fc4),
         UINT32_C(0x6629e7bc),
         UINT32_C(0x0000e4d2),
         UINT32_C(0x77f64caa),
         UINT32_C(0xb8dfa6fd),
         UINT32_C(0xcf290e85),
         UINT32_C(0xa900e939),
         UINT32_C(0xdef64141),
         UINT32_C(0x11dfab16),
         UINT32_C(0x6629036e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00255176),
         UINT32_C(0x001245c7),
         UINT32_C(0x003714b1),
         UINT32_C(0x4824480b),
         UINT32_C(0x4801197d),
         UINT32_C(0x48360dcc),
         UINT32_C(0x48135cba),
         UINT32_C(0x0042a01f),
         UINT32_C(0x0067f169),
         UINT32_C(0x0050e5d8),
         UINT32_C(0x0075b4ae),
         UINT32_C(0x4866e814),
         UINT32_C(0x4843b962),
         UINT32_C(0x4874add3),
         UINT32_C(0x4851fca5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8012a8),
         UINT32_C(0x3f800922),
         UINT32_C(0x3f801b8a),
         UINT32_C(0x3fa41224),
         UINT32_C(0x3fa4008c),
         UINT32_C(0x3fa41b06),
         UINT32_C(0x3fa409ae),
         UINT32_C(0x3f802150),
         UINT32_C(0x3f8033f8),
         UINT32_C(0x3f802872),
         UINT32_C(0x3f803ada),
         UINT32_C(0x3fa43374),
         UINT32_C(0x3fa421dc),
         UINT32_C(0x3fa43a56),
         UINT32_C(0x3fa428fe)},
        UINT32_C(0xfff80000),
        {0x73,0x81,0xfa,0xca,0x9b,0x8c,0x56,0x79,0xac,0xde,
         0xd7,0x97,0x4a,0x95,0x2d,0xac,0xaf,0x7a,0xd7,0xfd,0x00}
    },
    {
        /* No.223 delta:702 weight:1671 */
        11213,
        77,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4a8a3f8e),
         UINT32_C(0x8cb6604e),
         UINT32_C(0xc63c5fc0),
         UINT32_C(0x13c00df0),
         UINT32_C(0x594a327e),
         UINT32_C(0x9f766dbe),
         UINT32_C(0xd5fc5230),
         UINT32_C(0x00001edd),
         UINT32_C(0x4a8a2153),
         UINT32_C(0x8cb67e93),
         UINT32_C(0xc63c411d),
         UINT32_C(0x13c0132d),
         UINT32_C(0x594a2ca3),
         UINT32_C(0x9f767363),
         UINT32_C(0xd5fc4ced)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1006109e),
         UINT32_C(0x00401077),
         UINT32_C(0x104600e9),
         UINT32_C(0x0002280b),
         UINT32_C(0x10043895),
         UINT32_C(0x0042387c),
         UINT32_C(0x104428e2),
         UINT32_C(0x3000821f),
         UINT32_C(0x20069281),
         UINT32_C(0x30409268),
         UINT32_C(0x204682f6),
         UINT32_C(0x3002aa14),
         UINT32_C(0x2004ba8a),
         UINT32_C(0x3042ba63),
         UINT32_C(0x2044aafd)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880308),
         UINT32_C(0x3f802008),
         UINT32_C(0x3f882300),
         UINT32_C(0x3f800114),
         UINT32_C(0x3f88021c),
         UINT32_C(0x3f80211c),
         UINT32_C(0x3f882214),
         UINT32_C(0x3f980041),
         UINT32_C(0x3f900349),
         UINT32_C(0x3f982049),
         UINT32_C(0x3f902341),
         UINT32_C(0x3f980155),
         UINT32_C(0x3f90025d),
         UINT32_C(0x3f98215d),
         UINT32_C(0x3f902255)},
        UINT32_C(0xfff80000),
        {0x66,0x5a,0xdb,0xfa,0x2e,0xdd,0x15,0x6f,0x21,0xb3,
         0x08,0x1a,0x9f,0xf4,0xca,0x85,0x6e,0x6c,0xf1,0x8b,0x00}
    },
    {
        /* No.224 delta:1058 weight:1543 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x804482da),
         UINT32_C(0x202f737b),
         UINT32_C(0xa06bf1a1),
         UINT32_C(0x84a00e0c),
         UINT32_C(0x04e48cd6),
         UINT32_C(0xa48f7d77),
         UINT32_C(0x24cbffad),
         UINT32_C(0x00007fee),
         UINT32_C(0x8044fd34),
         UINT32_C(0x202f0c95),
         UINT32_C(0xa06b8e4f),
         UINT32_C(0x84a071e2),
         UINT32_C(0x04e4f338),
         UINT32_C(0xa48f0299),
         UINT32_C(0x24cb8043)},
        {UINT32_C(0x00000000),
         UINT32_C(0x005e00fa),
         UINT32_C(0x0c4c9193),
         UINT32_C(0x0c129169),
         UINT32_C(0x000a180d),
         UINT32_C(0x005418f7),
         UINT32_C(0x0c46899e),
         UINT32_C(0x0c188964),
         UINT32_C(0x00027011),
         UINT32_C(0x005c70eb),
         UINT32_C(0x0c4ee182),
         UINT32_C(0x0c10e178),
         UINT32_C(0x0008681c),
         UINT32_C(0x005668e6),
         UINT32_C(0x0c44f98f),
         UINT32_C(0x0c1af975)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802f00),
         UINT32_C(0x3f862648),
         UINT32_C(0x3f860948),
         UINT32_C(0x3f80050c),
         UINT32_C(0x3f802a0c),
         UINT32_C(0x3f862344),
         UINT32_C(0x3f860c44),
         UINT32_C(0x3f800138),
         UINT32_C(0x3f802e38),
         UINT32_C(0x3f862770),
         UINT32_C(0x3f860870),
         UINT32_C(0x3f800434),
         UINT32_C(0x3f802b34),
         UINT32_C(0x3f86227c),
         UINT32_C(0x3f860d7c)},
        UINT32_C(0xfff80000),
        {0xbe,0xa2,0x6b,0x7e,0xe7,0x1c,0x3a,0xcf,0xce,0xb8,
         0xc6,0x54,0x6e,0x94,0xb2,0x2e,0xe3,0x9c,0x91,0x68,0x00}
    },
    {
        /* No.225 delta:2138 weight:1359 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3e90494e),
         UINT32_C(0xbc17bf5f),
         UINT32_C(0x8287f611),
         UINT32_C(0x14400e13),
         UINT32_C(0x2ad0475d),
         UINT32_C(0xa857b14c),
         UINT32_C(0x96c7f802),
         UINT32_C(0x00007c06),
         UINT32_C(0x3e903548),
         UINT32_C(0xbc17c359),
         UINT32_C(0x82878a17),
         UINT32_C(0x14407215),
         UINT32_C(0x2ad03b5b),
         UINT32_C(0xa857cd4a),
         UINT32_C(0x96c78404)},
        {UINT32_C(0x00000000),
         UINT32_C(0x58041376),
         UINT32_C(0x14286614),
         UINT32_C(0x4c2c7562),
         UINT32_C(0x42004ea8),
         UINT32_C(0x1a045dde),
         UINT32_C(0x562828bc),
         UINT32_C(0x0e2c3bca),
         UINT32_C(0x6c00413f),
         UINT32_C(0x34045249),
         UINT32_C(0x7828272b),
         UINT32_C(0x202c345d),
         UINT32_C(0x2e000f97),
         UINT32_C(0x76041ce1),
         UINT32_C(0x3a286983),
         UINT32_C(0x622c7af5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fac0209),
         UINT32_C(0x3f8a1433),
         UINT32_C(0x3fa6163a),
         UINT32_C(0x3fa10027),
         UINT32_C(0x3f8d022e),
         UINT32_C(0x3fab1414),
         UINT32_C(0x3f87161d),
         UINT32_C(0x3fb60020),
         UINT32_C(0x3f9a0229),
         UINT32_C(0x3fbc1413),
         UINT32_C(0x3f90161a),
         UINT32_C(0x3f970007),
         UINT32_C(0x3fbb020e),
         UINT32_C(0x3f9d1434),
         UINT32_C(0x3fb1163d)},
        UINT32_C(0xfff80000),
        {0xd7,0x40,0x51,0x63,0x1e,0xeb,0x82,0x1f,0xe6,0xec,
         0xc3,0xcc,0x79,0x9d,0x0a,0x57,0xff,0x3c,0xb9,0xa8,0x00}
    },
    {
        /* No.226 delta:616 weight:1675 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfd1bd24f),
         UINT32_C(0xf3f9ff78),
         UINT32_C(0x0ee22d37),
         UINT32_C(0xedb00e2b),
         UINT32_C(0x10abdc64),
         UINT32_C(0x1e49f153),
         UINT32_C(0xe352231c),
         UINT32_C(0x00003a6a),
         UINT32_C(0xfd1be825),
         UINT32_C(0xf3f9c512),
         UINT32_C(0x0ee2175d),
         UINT32_C(0xedb03441),
         UINT32_C(0x10abe60e),
         UINT32_C(0x1e49cb39),
         UINT32_C(0xe3521976)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400110b6),
         UINT32_C(0x1010f815),
         UINT32_C(0x5011e8a3),
         UINT32_C(0x2024c20a),
         UINT32_C(0x6025d2bc),
         UINT32_C(0x30343a1f),
         UINT32_C(0x70352aa9),
         UINT32_C(0x4001c15e),
         UINT32_C(0x0000d1e8),
         UINT32_C(0x5011394b),
         UINT32_C(0x101029fd),
         UINT32_C(0x60250354),
         UINT32_C(0x202413e2),
         UINT32_C(0x7035fb41),
         UINT32_C(0x3034ebf7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00088),
         UINT32_C(0x3f88087c),
         UINT32_C(0x3fa808f4),
         UINT32_C(0x3f901261),
         UINT32_C(0x3fb012e9),
         UINT32_C(0x3f981a1d),
         UINT32_C(0x3fb81a95),
         UINT32_C(0x3fa000e0),
         UINT32_C(0x3f800068),
         UINT32_C(0x3fa8089c),
         UINT32_C(0x3f880814),
         UINT32_C(0x3fb01281),
         UINT32_C(0x3f901209),
         UINT32_C(0x3fb81afd),
         UINT32_C(0x3f981a75)},
        UINT32_C(0xfff80000),
        {0xe3,0x47,0xc7,0xb8,0xe5,0x9f,0x82,0x92,0xc8,0x0d,
         0x68,0x3b,0x78,0xd6,0x97,0x3d,0xe8,0x4e,0x01,0xa6,0x00}
    },
    {
        /* No.227 delta:692 weight:1731 */
        11213,
        77,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6da145eb),
         UINT32_C(0x9b35488c),
         UINT32_C(0xf6940d67),
         UINT32_C(0x39000e3d),
         UINT32_C(0x54a14bd6),
         UINT32_C(0xa23546b1),
         UINT32_C(0xcf94035a),
         UINT32_C(0x00001f6e),
         UINT32_C(0x6da15a85),
         UINT32_C(0x9b3557e2),
         UINT32_C(0xf6941209),
         UINT32_C(0x39001153),
         UINT32_C(0x54a154b8),
         UINT32_C(0xa23559df),
         UINT32_C(0xcf941c34)},
        {UINT32_C(0x00000000),
         UINT32_C(0x100311fb),
         UINT32_C(0x40023a07),
         UINT32_C(0x50012bfc),
         UINT32_C(0x40002412),
         UINT32_C(0x500335e9),
         UINT32_C(0x00021e15),
         UINT32_C(0x10010fee),
         UINT32_C(0x3000801d),
         UINT32_C(0x200391e6),
         UINT32_C(0x7002ba1a),
         UINT32_C(0x6001abe1),
         UINT32_C(0x7000a40f),
         UINT32_C(0x6003b5f4),
         UINT32_C(0x30029e08),
         UINT32_C(0x20018ff3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880188),
         UINT32_C(0x3fa0011d),
         UINT32_C(0x3fa80095),
         UINT32_C(0x3fa00012),
         UINT32_C(0x3fa8019a),
         UINT32_C(0x3f80010f),
         UINT32_C(0x3f880087),
         UINT32_C(0x3f980040),
         UINT32_C(0x3f9001c8),
         UINT32_C(0x3fb8015d),
         UINT32_C(0x3fb000d5),
         UINT32_C(0x3fb80052),
         UINT32_C(0x3fb001da),
         UINT32_C(0x3f98014f),
         UINT32_C(0x3f9000c7)},
        UINT32_C(0xfff80000),
        {0x44,0xcc,0x15,0x5b,0xe6,0x5e,0x83,0x55,0x84,0xf9,
         0xce,0xc8,0xa2,0x6f,0x0c,0xff,0x71,0xc1,0x9f,0x0b,0x00}
    },
    {
        /* No.228 delta:2153 weight:1377 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x51f9dadd),
         UINT32_C(0xa2f375d5),
         UINT32_C(0xf30aaf08),
         UINT32_C(0x0c100e49),
         UINT32_C(0x5de9d494),
         UINT32_C(0xaee37b9c),
         UINT32_C(0xff1aa141),
         UINT32_C(0x000074c6),
         UINT32_C(0x51f9ae1b),
         UINT32_C(0xa2f30113),
         UINT32_C(0xf30adbce),
         UINT32_C(0x0c107a8f),
         UINT32_C(0x5de9a052),
         UINT32_C(0xaee30f5a),
         UINT32_C(0xff1ad587)},
        {UINT32_C(0x00000000),
         UINT32_C(0x267510b2),
         UINT32_C(0x712609d7),
         UINT32_C(0x57531965),
         UINT32_C(0x1402001f),
         UINT32_C(0x327710ad),
         UINT32_C(0x652409c8),
         UINT32_C(0x4351197a),
         UINT32_C(0xad185203),
         UINT32_C(0x8b6d42b1),
         UINT32_C(0xdc3e5bd4),
         UINT32_C(0xfa4b4b66),
         UINT32_C(0xb91a521c),
         UINT32_C(0x9f6f42ae),
         UINT32_C(0xc83c5bcb),
         UINT32_C(0xee494b79)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f933a88),
         UINT32_C(0x3fb89304),
         UINT32_C(0x3faba98c),
         UINT32_C(0x3f8a0100),
         UINT32_C(0x3f993b88),
         UINT32_C(0x3fb29204),
         UINT32_C(0x3fa1a88c),
         UINT32_C(0x3fd68c29),
         UINT32_C(0x3fc5b6a1),
         UINT32_C(0x3fee1f2d),
         UINT32_C(0x3ffd25a5),
         UINT32_C(0x3fdc8d29),
         UINT32_C(0x3fcfb7a1),
         UINT32_C(0x3fe41e2d),
         UINT32_C(0x3ff724a5)},
        UINT32_C(0xfff80000),
        {0x12,0xbb,0xe9,0xb1,0xe2,0xeb,0x7f,0xee,0xab,0x7a,
         0xff,0x95,0x21,0x30,0xf0,0xe2,0x19,0x07,0x21,0x7c,0x00}
    },
    {
        /* No.229 delta:1599 weight:1619 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xde4e5727),
         UINT32_C(0x27620ea0),
         UINT32_C(0xf92c5987),
         UINT32_C(0xed300e53),
         UINT32_C(0x337e5974),
         UINT32_C(0xca5200f3),
         UINT32_C(0x141c57d4),
         UINT32_C(0x00001e91),
         UINT32_C(0xde4e49b6),
         UINT32_C(0x27621031),
         UINT32_C(0xf92c4716),
         UINT32_C(0xed3010c2),
         UINT32_C(0x337e47e5),
         UINT32_C(0xca521e62),
         UINT32_C(0x141c4945)},
        {UINT32_C(0x00000000),
         UINT32_C(0x08962914),
         UINT32_C(0x900110df),
         UINT32_C(0x989739cb),
         UINT32_C(0x0041601c),
         UINT32_C(0x08d74908),
         UINT32_C(0x904070c3),
         UINT32_C(0x98d659d7),
         UINT32_C(0x50014112),
         UINT32_C(0x58976806),
         UINT32_C(0xc00051cd),
         UINT32_C(0xc89678d9),
         UINT32_C(0x5040210e),
         UINT32_C(0x58d6081a),
         UINT32_C(0xc04131d1),
         UINT32_C(0xc8d718c5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f844b14),
         UINT32_C(0x3fc80088),
         UINT32_C(0x3fcc4b9c),
         UINT32_C(0x3f8020b0),
         UINT32_C(0x3f846ba4),
         UINT32_C(0x3fc82038),
         UINT32_C(0x3fcc6b2c),
         UINT32_C(0x3fa800a0),
         UINT32_C(0x3fac4bb4),
         UINT32_C(0x3fe00028),
         UINT32_C(0x3fe44b3c),
         UINT32_C(0x3fa82010),
         UINT32_C(0x3fac6b04),
         UINT32_C(0x3fe02098),
         UINT32_C(0x3fe46b8c)},
        UINT32_C(0xfff80000),
        {0x2a,0xa2,0x16,0xca,0x49,0x08,0xa1,0x51,0xd3,0xd5,
         0x61,0xe9,0x08,0xcb,0x4d,0x45,0x5e,0x1b,0xad,0x1c,0x00}
    },
    {
        /* No.230 delta:1191 weight:1545 */
        11213,
        27,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x194b78e6),
         UINT32_C(0x6f1d3bb7),
         UINT32_C(0x76564351),
         UINT32_C(0xabb00e6d),
         UINT32_C(0xb2fb768b),
         UINT32_C(0xc4ad35da),
         UINT32_C(0xdde64d3c),
         UINT32_C(0x00009530),
         UINT32_C(0x194bedd6),
         UINT32_C(0x6f1dae87),
         UINT32_C(0x7656d661),
         UINT32_C(0xabb09b5d),
         UINT32_C(0xb2fbe3bb),
         UINT32_C(0xc4ada0ea),
         UINT32_C(0xdde6d80c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x602667de),
         UINT32_C(0x0055807d),
         UINT32_C(0x6073e7a3),
         UINT32_C(0x100a1805),
         UINT32_C(0x702c7fdb),
         UINT32_C(0x105f9878),
         UINT32_C(0x7079ffa6),
         UINT32_C(0x0002458c),
         UINT32_C(0x60242252),
         UINT32_C(0x0057c5f1),
         UINT32_C(0x6071a22f),
         UINT32_C(0x10085d89),
         UINT32_C(0x702e3a57),
         UINT32_C(0x105dddf4),
         UINT32_C(0x707bba2a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb01333),
         UINT32_C(0x3f802ac0),
         UINT32_C(0x3fb039f3),
         UINT32_C(0x3f88050c),
         UINT32_C(0x3fb8163f),
         UINT32_C(0x3f882fcc),
         UINT32_C(0x3fb83cff),
         UINT32_C(0x3f800122),
         UINT32_C(0x3fb01211),
         UINT32_C(0x3f802be2),
         UINT32_C(0x3fb038d1),
         UINT32_C(0x3f88042e),
         UINT32_C(0x3fb8171d),
         UINT32_C(0x3f882eee),
         UINT32_C(0x3fb83ddd)},
        UINT32_C(0xfff80000),
        {0x62,0x34,0x3d,0x24,0x5d,0x6b,0xfd,0x1f,0xea,0x46,
         0xba,0x4e,0xb4,0x16,0xfd,0x63,0xf8,0x2d,0x94,0xfa,0x00}
    },
    {
        /* No.231 delta:1759 weight:1557 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa9aa6236),
         UINT32_C(0xb8d54cd0),
         UINT32_C(0x117f2ee6),
         UINT32_C(0x92100e78),
         UINT32_C(0x3bba6c4e),
         UINT32_C(0x2ac542a8),
         UINT32_C(0x836f209e),
         UINT32_C(0x00003edb),
         UINT32_C(0xa9aa5ced),
         UINT32_C(0xb8d5720b),
         UINT32_C(0x117f103d),
         UINT32_C(0x921030a3),
         UINT32_C(0x3bba5295),
         UINT32_C(0x2ac57c73),
         UINT32_C(0x836f1e45)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6c129416),
         UINT32_C(0x5880901b),
         UINT32_C(0x3492040d),
         UINT32_C(0xc11100f2),
         UINT32_C(0xad0394e4),
         UINT32_C(0x999190e9),
         UINT32_C(0xf58304ff),
         UINT32_C(0x08b04183),
         UINT32_C(0x64a2d595),
         UINT32_C(0x5030d198),
         UINT32_C(0x3c22458e),
         UINT32_C(0xc9a14171),
         UINT32_C(0xa5b3d567),
         UINT32_C(0x9121d16a),
         UINT32_C(0xfd33457c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb6094a),
         UINT32_C(0x3fac4048),
         UINT32_C(0x3f9a4902),
         UINT32_C(0x3fe08880),
         UINT32_C(0x3fd681ca),
         UINT32_C(0x3fccc8c8),
         UINT32_C(0x3ffac182),
         UINT32_C(0x3f845820),
         UINT32_C(0x3fb2516a),
         UINT32_C(0x3fa81868),
         UINT32_C(0x3f9e1122),
         UINT32_C(0x3fe4d0a0),
         UINT32_C(0x3fd2d9ea),
         UINT32_C(0x3fc890e8),
         UINT32_C(0x3ffe99a2)},
        UINT32_C(0xfff80000),
        {0xc5,0x66,0xfd,0xf5,0x39,0x9a,0x81,0xf8,0x17,0x8b,
         0x0c,0xd1,0x39,0xa7,0xb8,0x7f,0x48,0xb7,0x37,0x1d,0x00}
    },
    {
        /* No.232 delta:1474 weight:1163 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe68d94c3),
         UINT32_C(0xca52dfa6),
         UINT32_C(0x2cdf4b65),
         UINT32_C(0x94d00e81),
         UINT32_C(0x725d9a42),
         UINT32_C(0x5e82d127),
         UINT32_C(0xb80f45e4),
         UINT32_C(0x000055a0),
         UINT32_C(0xe68dc163),
         UINT32_C(0xca528a06),
         UINT32_C(0x2cdf1ec5),
         UINT32_C(0x94d05b21),
         UINT32_C(0x725dcfe2),
         UINT32_C(0x5e828487),
         UINT32_C(0xb80f1044)},
        {UINT32_C(0x00000000),
         UINT32_C(0x107d2196),
         UINT32_C(0x000301af),
         UINT32_C(0x107e2039),
         UINT32_C(0x20200014),
         UINT32_C(0x305d2182),
         UINT32_C(0x202301bb),
         UINT32_C(0x305e202d),
         UINT32_C(0x00408086),
         UINT32_C(0x103da110),
         UINT32_C(0x00438129),
         UINT32_C(0x103ea0bf),
         UINT32_C(0x20608092),
         UINT32_C(0x301da104),
         UINT32_C(0x2063813d),
         UINT32_C(0x301ea0ab)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f883e90),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f883f10),
         UINT32_C(0x3f901000),
         UINT32_C(0x3f982e90),
         UINT32_C(0x3f901180),
         UINT32_C(0x3f982f10),
         UINT32_C(0x3f802040),
         UINT32_C(0x3f881ed0),
         UINT32_C(0x3f8021c0),
         UINT32_C(0x3f881f50),
         UINT32_C(0x3f903040),
         UINT32_C(0x3f980ed0),
         UINT32_C(0x3f9031c0),
         UINT32_C(0x3f980f50)},
        UINT32_C(0xfff80000),
        {0x0d,0x8f,0xf6,0xb5,0x00,0x2c,0x82,0x15,0x41,0xd9,
         0x7e,0x26,0x8a,0xbf,0xde,0x9d,0xce,0x09,0xa6,0x52,0x00}
    },
    {
        /* No.233 delta:1710 weight:1477 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfaa4c149),
         UINT32_C(0x0a815e24),
         UINT32_C(0xf0259f6d),
         UINT32_C(0x48a00e96),
         UINT32_C(0xb204cfdf),
         UINT32_C(0x422150b2),
         UINT32_C(0xb88591fb),
         UINT32_C(0x000046a7),
         UINT32_C(0xfaa487ee),
         UINT32_C(0x0a811883),
         UINT32_C(0xf025d9ca),
         UINT32_C(0x48a04831),
         UINT32_C(0xb2048978),
         UINT32_C(0x42211615),
         UINT32_C(0xb885d75c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4687105e),
         UINT32_C(0x0d572a02),
         UINT32_C(0x4bd03a5c),
         UINT32_C(0x09024807),
         UINT32_C(0x4f855859),
         UINT32_C(0x04556205),
         UINT32_C(0x42d2725b),
         UINT32_C(0x0104001f),
         UINT32_C(0x47831041),
         UINT32_C(0x0c532a1d),
         UINT32_C(0x4ad43a43),
         UINT32_C(0x08064818),
         UINT32_C(0x4e815846),
         UINT32_C(0x0551621a),
         UINT32_C(0x43d67244)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa34388),
         UINT32_C(0x3f86ab95),
         UINT32_C(0x3fa5e81d),
         UINT32_C(0x3f848124),
         UINT32_C(0x3fa7c2ac),
         UINT32_C(0x3f822ab1),
         UINT32_C(0x3fa16939),
         UINT32_C(0x3f808200),
         UINT32_C(0x3fa3c188),
         UINT32_C(0x3f862995),
         UINT32_C(0x3fa56a1d),
         UINT32_C(0x3f840324),
         UINT32_C(0x3fa740ac),
         UINT32_C(0x3f82a8b1),
         UINT32_C(0x3fa1eb39)},
        UINT32_C(0xfff80000),
        {0xc1,0x62,0xd4,0xf4,0x4d,0x8c,0xb8,0x20,0x0e,0xb1,
         0x1e,0x69,0x92,0xcb,0xfa,0xaf,0x15,0x8d,0x27,0x1d,0x00}
    },
    {
        /* No.234 delta:1697 weight:1443 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x87b7826a),
         UINT32_C(0xc475bc43),
         UINT32_C(0x43c23e29),
         UINT32_C(0x24800eab),
         UINT32_C(0xa3378cc1),
         UINT32_C(0xe0f5b2e8),
         UINT32_C(0x67423082),
         UINT32_C(0x0000d36a),
         UINT32_C(0x87b75100),
         UINT32_C(0xc4756f29),
         UINT32_C(0x43c2ed43),
         UINT32_C(0x2480ddc1),
         UINT32_C(0xa3375fab),
         UINT32_C(0xe0f56182),
         UINT32_C(0x6742e3e8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0f09897a),
         UINT32_C(0x4155e01f),
         UINT32_C(0x4e5c6965),
         UINT32_C(0x0080392e),
         UINT32_C(0x0f89b054),
         UINT32_C(0x41d5d931),
         UINT32_C(0x4edc504b),
         UINT32_C(0x0048a403),
         UINT32_C(0x0f412d79),
         UINT32_C(0x411d441c),
         UINT32_C(0x4e14cd66),
         UINT32_C(0x00c89d2d),
         UINT32_C(0x0fc11457),
         UINT32_C(0x419d7d32),
         UINT32_C(0x4e94f448)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8784c4),
         UINT32_C(0x3fa0aaf0),
         UINT32_C(0x3fa72e34),
         UINT32_C(0x3f80401c),
         UINT32_C(0x3f87c4d8),
         UINT32_C(0x3fa0eaec),
         UINT32_C(0x3fa76e28),
         UINT32_C(0x3f802452),
         UINT32_C(0x3f87a096),
         UINT32_C(0x3fa08ea2),
         UINT32_C(0x3fa70a66),
         UINT32_C(0x3f80644e),
         UINT32_C(0x3f87e08a),
         UINT32_C(0x3fa0cebe),
         UINT32_C(0x3fa74a7a)},
        UINT32_C(0xfff80000),
        {0x84,0x56,0xa8,0xb2,0x6f,0x3d,0x04,0x3a,0x11,0x3c,
         0x50,0x4b,0xe0,0x99,0xa4,0x12,0xda,0x3f,0xfb,0x81,0x00}
    },
    {
        /* No.235 delta:796 weight:1591 */
        11213,
        67,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x99ea585a),
         UINT32_C(0x057b62ab),
         UINT32_C(0x9c913af1),
         UINT32_C(0x03900eb2),
         UINT32_C(0x9a7a56e8),
         UINT32_C(0x06eb6c19),
         UINT32_C(0x9f013443),
         UINT32_C(0x0000556f),
         UINT32_C(0x99ea0d35),
         UINT32_C(0x057b37c4),
         UINT32_C(0x9c916f9e),
         UINT32_C(0x03905bdd),
         UINT32_C(0x9a7a0387),
         UINT32_C(0x06eb3976),
         UINT32_C(0x9f01612c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2142a81a),
         UINT32_C(0x800225b6),
         UINT32_C(0xa1408dac),
         UINT32_C(0x00030965),
         UINT32_C(0x2141a17f),
         UINT32_C(0x80012cd3),
         UINT32_C(0xa14384c9),
         UINT32_C(0x0800300b),
         UINT32_C(0x29429811),
         UINT32_C(0x880215bd),
         UINT32_C(0xa940bda7),
         UINT32_C(0x0803396e),
         UINT32_C(0x29419174),
         UINT32_C(0x88011cd8),
         UINT32_C(0xa943b4c2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90a154),
         UINT32_C(0x3fc00112),
         UINT32_C(0x3fd0a046),
         UINT32_C(0x3f800184),
         UINT32_C(0x3f90a0d0),
         UINT32_C(0x3fc00096),
         UINT32_C(0x3fd0a1c2),
         UINT32_C(0x3f840018),
         UINT32_C(0x3f94a14c),
         UINT32_C(0x3fc4010a),
         UINT32_C(0x3fd4a05e),
         UINT32_C(0x3f84019c),
         UINT32_C(0x3f94a0c8),
         UINT32_C(0x3fc4008e),
         UINT32_C(0x3fd4a1da)},
        UINT32_C(0xfff80000),
        {0xd5,0x6f,0x5c,0x04,0x37,0x62,0xa3,0x86,0xe3,0x2e,
         0xd5,0x2a,0xf9,0x33,0xc6,0x05,0x8e,0x64,0x05,0xb7,0x00}
    },
    {
        /* No.236 delta:991 weight:1467 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xaf21b504),
         UINT32_C(0xa5813444),
         UINT32_C(0x0aa08140),
         UINT32_C(0xe0600ecd),
         UINT32_C(0x4f41bbc9),
         UINT32_C(0x45e13a89),
         UINT32_C(0xeac08f8d),
         UINT32_C(0x0000f230),
         UINT32_C(0xaf214734),
         UINT32_C(0xa581c674),
         UINT32_C(0x0aa07370),
         UINT32_C(0xe060fcfd),
         UINT32_C(0x4f4149f9),
         UINT32_C(0x45e1c8b9),
         UINT32_C(0xeac07dbd)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00430d1a),
         UINT32_C(0xb00140ef),
         UINT32_C(0xb0424df5),
         UINT32_C(0x400165f8),
         UINT32_C(0x404268e2),
         UINT32_C(0xf0002517),
         UINT32_C(0xf043280d),
         UINT32_C(0x20024432),
         UINT32_C(0x20414928),
         UINT32_C(0x900304dd),
         UINT32_C(0x904009c7),
         UINT32_C(0x600321ca),
         UINT32_C(0x60402cd0),
         UINT32_C(0xd0026125),
         UINT32_C(0xd0416c3f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802186),
         UINT32_C(0x3fd800a0),
         UINT32_C(0x3fd82126),
         UINT32_C(0x3fa000b2),
         UINT32_C(0x3fa02134),
         UINT32_C(0x3ff80012),
         UINT32_C(0x3ff82194),
         UINT32_C(0x3f900122),
         UINT32_C(0x3f9020a4),
         UINT32_C(0x3fc80182),
         UINT32_C(0x3fc82004),
         UINT32_C(0x3fb00190),
         UINT32_C(0x3fb02016),
         UINT32_C(0x3fe80130),
         UINT32_C(0x3fe820b6)},
        UINT32_C(0xfff80000),
        {0x08,0x23,0x32,0x65,0xad,0x77,0xc1,0xe9,0xfa,0x97,
         0xa8,0xe8,0xfa,0x5e,0xa7,0xfa,0x8c,0x95,0x7e,0x83,0x00}
    },
    {
        /* No.237 delta:735 weight:677 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4f2644c0),
         UINT32_C(0x34a648ac),
         UINT32_C(0x7b800c6c),
         UINT32_C(0x8dd00ed7),
         UINT32_C(0xc2f64a17),
         UINT32_C(0xb976467b),
         UINT32_C(0xf65002bb),
         UINT32_C(0x00004ef0),
         UINT32_C(0x4f260a30),
         UINT32_C(0x34a6065c),
         UINT32_C(0x7b80429c),
         UINT32_C(0x8dd04027),
         UINT32_C(0xc2f604e7),
         UINT32_C(0xb976088b),
         UINT32_C(0xf6504c4b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4cf610d5),
         UINT32_C(0x439d0047),
         UINT32_C(0x0f6b1092),
         UINT32_C(0x02d00d6d),
         UINT32_C(0x4e261db8),
         UINT32_C(0x414d0d2a),
         UINT32_C(0x0dbb1dff),
         UINT32_C(0x00798016),
         UINT32_C(0x4c8f90c3),
         UINT32_C(0x43e48051),
         UINT32_C(0x0f129084),
         UINT32_C(0x02a98d7b),
         UINT32_C(0x4e5f9dae),
         UINT32_C(0x41348d3c),
         UINT32_C(0x0dc29de9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa67b08),
         UINT32_C(0x3fa1ce80),
         UINT32_C(0x3f87b588),
         UINT32_C(0x3f816806),
         UINT32_C(0x3fa7130e),
         UINT32_C(0x3fa0a686),
         UINT32_C(0x3f86dd8e),
         UINT32_C(0x3f803cc0),
         UINT32_C(0x3fa647c8),
         UINT32_C(0x3fa1f240),
         UINT32_C(0x3f878948),
         UINT32_C(0x3f8154c6),
         UINT32_C(0x3fa72fce),
         UINT32_C(0x3fa09a46),
         UINT32_C(0x3f86e14e)},
        UINT32_C(0xfff80000),
        {0x85,0xf6,0x81,0x30,0x53,0x61,0x3f,0x78,0xaf,0xfb,
         0xcb,0x42,0x18,0xea,0x66,0xf7,0x00,0xb6,0x51,0x2a,0x00}
    },
    {
        /* No.238 delta:1646 weight:1631 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x28a1b51b),
         UINT32_C(0xbc17178b),
         UINT32_C(0x94b6a290),
         UINT32_C(0x0f500ee9),
         UINT32_C(0x27f1bbf2),
         UINT32_C(0xb3471962),
         UINT32_C(0x9be6ac79),
         UINT32_C(0x00005fbe),
         UINT32_C(0x28a1eaa5),
         UINT32_C(0xbc174835),
         UINT32_C(0x94b6fd2e),
         UINT32_C(0x0f505157),
         UINT32_C(0x27f1e44c),
         UINT32_C(0xb34746dc),
         UINT32_C(0x9be6f3c7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x080edc5a),
         UINT32_C(0x210608d4),
         UINT32_C(0x2908d48e),
         UINT32_C(0x000ad00c),
         UINT32_C(0x08040c56),
         UINT32_C(0x210cd8d8),
         UINT32_C(0x29020482),
         UINT32_C(0x60496c11),
         UINT32_C(0x6847b04b),
         UINT32_C(0x414f64c5),
         UINT32_C(0x4941b89f),
         UINT32_C(0x6043bc1d),
         UINT32_C(0x684d6047),
         UINT32_C(0x4145b4c9),
         UINT32_C(0x494b6893)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84076e),
         UINT32_C(0x3f908304),
         UINT32_C(0x3f94846a),
         UINT32_C(0x3f800568),
         UINT32_C(0x3f840206),
         UINT32_C(0x3f90866c),
         UINT32_C(0x3f948102),
         UINT32_C(0x3fb024b6),
         UINT32_C(0x3fb423d8),
         UINT32_C(0x3fa0a7b2),
         UINT32_C(0x3fa4a0dc),
         UINT32_C(0x3fb021de),
         UINT32_C(0x3fb426b0),
         UINT32_C(0x3fa0a2da),
         UINT32_C(0x3fa4a5b4)},
        UINT32_C(0xfff80000),
        {0x85,0x16,0x1a,0x04,0xc7,0x8c,0xaa,0xe7,0x0f,0x71,
         0x74,0x2d,0xcd,0xbf,0xec,0xeb,0x55,0x2d,0x65,0xad,0x00}
    },
    {
        /* No.239 delta:921 weight:1259 */
        11213,
        39,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc2571fd3),
         UINT32_C(0x43f1fa5c),
         UINT32_C(0x81a6e58f),
         UINT32_C(0x00d00ef5),
         UINT32_C(0xc2871126),
         UINT32_C(0x4321f4a9),
         UINT32_C(0x8176eb7a),
         UINT32_C(0x000065ce),
         UINT32_C(0xc2577a1d),
         UINT32_C(0x43f19f92),
         UINT32_C(0x81a68041),
         UINT32_C(0x00d06b3b),
         UINT32_C(0xc28774e8),
         UINT32_C(0x43219167),
         UINT32_C(0x81768eb4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004e991c),
         UINT32_C(0x00034177),
         UINT32_C(0x004dd86b),
         UINT32_C(0x40500103),
         UINT32_C(0x401e981f),
         UINT32_C(0x40534074),
         UINT32_C(0x401dd968),
         UINT32_C(0x2040e418),
         UINT32_C(0x200e7d04),
         UINT32_C(0x2043a56f),
         UINT32_C(0x200d3c73),
         UINT32_C(0x6010e51b),
         UINT32_C(0x605e7c07),
         UINT32_C(0x6013a46c),
         UINT32_C(0x605d3d70)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80274c),
         UINT32_C(0x3f8001a0),
         UINT32_C(0x3f8026ec),
         UINT32_C(0x3fa02800),
         UINT32_C(0x3fa00f4c),
         UINT32_C(0x3fa029a0),
         UINT32_C(0x3fa00eec),
         UINT32_C(0x3f902072),
         UINT32_C(0x3f90073e),
         UINT32_C(0x3f9021d2),
         UINT32_C(0x3f90069e),
         UINT32_C(0x3fb00872),
         UINT32_C(0x3fb02f3e),
         UINT32_C(0x3fb009d2),
         UINT32_C(0x3fb02e9e)},
        UINT32_C(0xfff80000),
        {0x08,0x7b,0xe5,0x96,0x58,0x63,0x7b,0xa7,0x0b,0xcf,
         0x64,0x7f,0xe5,0xf7,0xbc,0x0c,0x66,0x46,0x6a,0x7e,0x00}
    },
    {
        /* No.240 delta:777 weight:1607 */
        11213,
        67,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7afb4c42),
         UINT32_C(0xb4b78f4b),
         UINT32_C(0xce4cc309),
         UINT32_C(0x91a00f01),
         UINT32_C(0xeb5b4343),
         UINT32_C(0x2517804a),
         UINT32_C(0x5feccc08),
         UINT32_C(0x0000e97f),
         UINT32_C(0x7afba53d),
         UINT32_C(0xb4b76634),
         UINT32_C(0xce4c2a76),
         UINT32_C(0x91a0e67e),
         UINT32_C(0xeb5baa3c),
         UINT32_C(0x25176935),
         UINT32_C(0x5fec2577)},
        {UINT32_C(0x00000000),
         UINT32_C(0x504a0016),
         UINT32_C(0x80005ce4),
         UINT32_C(0xd04a5cf2),
         UINT32_C(0x0002040e),
         UINT32_C(0x50480418),
         UINT32_C(0x800258ea),
         UINT32_C(0xd04858fc),
         UINT32_C(0x40003a0b),
         UINT32_C(0x104a3a1d),
         UINT32_C(0xc00066ef),
         UINT32_C(0x904a66f9),
         UINT32_C(0x40023e05),
         UINT32_C(0x10483e13),
         UINT32_C(0xc00262e1),
         UINT32_C(0x904862f7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa82500),
         UINT32_C(0x3fc0002e),
         UINT32_C(0x3fe8252e),
         UINT32_C(0x3f800102),
         UINT32_C(0x3fa82402),
         UINT32_C(0x3fc0012c),
         UINT32_C(0x3fe8242c),
         UINT32_C(0x3fa0001d),
         UINT32_C(0x3f88251d),
         UINT32_C(0x3fe00033),
         UINT32_C(0x3fc82533),
         UINT32_C(0x3fa0011f),
         UINT32_C(0x3f88241f),
         UINT32_C(0x3fe00131),
         UINT32_C(0x3fc82431)},
        UINT32_C(0xfff80000),
        {0x7d,0xc6,0x75,0x54,0xc8,0xc1,0xba,0xe6,0x6d,0xc2,
         0x62,0xa9,0xad,0x80,0x06,0x6f,0x52,0x9f,0x84,0x48,0x00}
    },
    {
        /* No.241 delta:2880 weight:821 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbbc180f5),
         UINT32_C(0x82b154f4),
         UINT32_C(0x3970d401),
         UINT32_C(0xc7d00f1a),
         UINT32_C(0x7c118fef),
         UINT32_C(0x45615bee),
         UINT32_C(0xfea0db1b),
         UINT32_C(0x000098e9),
         UINT32_C(0xbbc1181c),
         UINT32_C(0x82b1cc1d),
         UINT32_C(0x39704ce8),
         UINT32_C(0xc7d097f3),
         UINT32_C(0x7c111706),
         UINT32_C(0x4561c307),
         UINT32_C(0xfea043f2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x886b015a),
         UINT32_C(0x0803c5ad),
         UINT32_C(0x8068c4f7),
         UINT32_C(0x4c0d802f),
         UINT32_C(0xc4668175),
         UINT32_C(0x440e4582),
         UINT32_C(0xcc6544d8),
         UINT32_C(0x422a0813),
         UINT32_C(0xca410949),
         UINT32_C(0x4a29cdbe),
         UINT32_C(0xc242cce4),
         UINT32_C(0x0e27883c),
         UINT32_C(0x864c8966),
         UINT32_C(0x06244d91),
         UINT32_C(0x8e4f4ccb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc43580),
         UINT32_C(0x3f8401e2),
         UINT32_C(0x3fc03462),
         UINT32_C(0x3fa606c0),
         UINT32_C(0x3fe23340),
         UINT32_C(0x3fa20722),
         UINT32_C(0x3fe632a2),
         UINT32_C(0x3fa11504),
         UINT32_C(0x3fe52084),
         UINT32_C(0x3fa514e6),
         UINT32_C(0x3fe12166),
         UINT32_C(0x3f8713c4),
         UINT32_C(0x3fc32644),
         UINT32_C(0x3f831226),
         UINT32_C(0x3fc727a6)},
        UINT32_C(0xfff80000),
        {0xd3,0x96,0x70,0x46,0x95,0xf4,0x96,0xb6,0xa1,0x5b,
         0xec,0x17,0xc7,0x4c,0xe6,0x33,0x1b,0x16,0x1d,0x79,0x00}
    },
    {
        /* No.242 delta:1388 weight:1649 */
        11213,
        18,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf70ad49c),
         UINT32_C(0x3721e624),
         UINT32_C(0xc02b32b8),
         UINT32_C(0xecb00f20),
         UINT32_C(0x1bbadbbc),
         UINT32_C(0xdb91e904),
         UINT32_C(0x2c9b3d98),
         UINT32_C(0x0000cf92),
         UINT32_C(0xf70a1b0e),
         UINT32_C(0x372129b6),
         UINT32_C(0xc02bfd2a),
         UINT32_C(0xecb0c0b2),
         UINT32_C(0x1bba142e),
         UINT32_C(0xdb912696),
         UINT32_C(0x2c9bf20a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4054e153),
         UINT32_C(0x207a0102),
         UINT32_C(0x602ee051),
         UINT32_C(0x4035641a),
         UINT32_C(0x00618549),
         UINT32_C(0x604f6518),
         UINT32_C(0x201b844b),
         UINT32_C(0x00501812),
         UINT32_C(0x4004f941),
         UINT32_C(0x202a1910),
         UINT32_C(0x607ef843),
         UINT32_C(0x40657c08),
         UINT32_C(0x00319d5b),
         UINT32_C(0x601f7d0a),
         UINT32_C(0x204b9c59)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02a70),
         UINT32_C(0x3f903d00),
         UINT32_C(0x3fb01770),
         UINT32_C(0x3fa01ab2),
         UINT32_C(0x3f8030c2),
         UINT32_C(0x3fb027b2),
         UINT32_C(0x3f900dc2),
         UINT32_C(0x3f80280c),
         UINT32_C(0x3fa0027c),
         UINT32_C(0x3f90150c),
         UINT32_C(0x3fb03f7c),
         UINT32_C(0x3fa032be),
         UINT32_C(0x3f8018ce),
         UINT32_C(0x3fb00fbe),
         UINT32_C(0x3f9025ce)},
        UINT32_C(0xfff80000),
        {0x21,0xa5,0x6f,0x7b,0xe2,0xe3,0x9a,0x38,0x8d,0x3b,
         0xad,0x35,0x7d,0x5b,0x6c,0xd5,0x14,0x7f,0x83,0x43,0x00}
    },
    {
        /* No.243 delta:822 weight:715 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5c622cc8),
         UINT32_C(0xd18006f0),
         UINT32_C(0x8de22a38),
         UINT32_C(0xb6c00f33),
         UINT32_C(0xeaa223fb),
         UINT32_C(0x674009c3),
         UINT32_C(0x3b22250b),
         UINT32_C(0x00006b6b),
         UINT32_C(0x5c6247a3),
         UINT32_C(0xd1806d9b),
         UINT32_C(0x8de24153),
         UINT32_C(0xb6c06458),
         UINT32_C(0xeaa24890),
         UINT32_C(0x674062a8),
         UINT32_C(0x3b224e60)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0043b215),
         UINT32_C(0x104205bf),
         UINT32_C(0x1001b7aa),
         UINT32_C(0x0de0001b),
         UINT32_C(0x0da3b20e),
         UINT32_C(0x1da205a4),
         UINT32_C(0x1de1b7b1),
         UINT32_C(0x20c10146),
         UINT32_C(0x2082b353),
         UINT32_C(0x308304f9),
         UINT32_C(0x30c0b6ec),
         UINT32_C(0x2d21015d),
         UINT32_C(0x2d62b348),
         UINT32_C(0x3d6304e2),
         UINT32_C(0x3d20b6f7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8021d9),
         UINT32_C(0x3f882102),
         UINT32_C(0x3f8800db),
         UINT32_C(0x3f86f000),
         UINT32_C(0x3f86d1d9),
         UINT32_C(0x3f8ed102),
         UINT32_C(0x3f8ef0db),
         UINT32_C(0x3f906080),
         UINT32_C(0x3f904159),
         UINT32_C(0x3f984182),
         UINT32_C(0x3f98605b),
         UINT32_C(0x3f969080),
         UINT32_C(0x3f96b159),
         UINT32_C(0x3f9eb182),
         UINT32_C(0x3f9e905b)},
        UINT32_C(0xfff80000),
        {0x53,0x4d,0x4a,0xc1,0x80,0xb0,0x11,0x78,0x0b,0xb8,
         0x0d,0xac,0xd2,0x38,0x5b,0x1c,0xc4,0x45,0xb9,0xd9,0x00}
    },
    {
        /* No.244 delta:1331 weight:1553 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb107a6a0),
         UINT32_C(0x6b935e95),
         UINT32_C(0xda94f835),
         UINT32_C(0xa6b00f4e),
         UINT32_C(0x17b7a9ee),
         UINT32_C(0xcd2351db),
         UINT32_C(0x7c24f77b),
         UINT32_C(0x000004d0),
         UINT32_C(0xb107a270),
         UINT32_C(0x6b935a45),
         UINT32_C(0xda94fce5),
         UINT32_C(0xa6b00b9e),
         UINT32_C(0x17b7ad3e),
         UINT32_C(0xcd23550b),
         UINT32_C(0x7c24f3ab)},
        {UINT32_C(0x00000000),
         UINT32_C(0x34509156),
         UINT32_C(0x104b48a5),
         UINT32_C(0x241bd9f3),
         UINT32_C(0x0023b194),
         UINT32_C(0x347320c2),
         UINT32_C(0x1068f931),
         UINT32_C(0x24386867),
         UINT32_C(0x0046240d),
         UINT32_C(0x3416b55b),
         UINT32_C(0x100d6ca8),
         UINT32_C(0x245dfdfe),
         UINT32_C(0x00659599),
         UINT32_C(0x343504cf),
         UINT32_C(0x102edd3c),
         UINT32_C(0x247e4c6a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9a2848),
         UINT32_C(0x3f8825a4),
         UINT32_C(0x3f920dec),
         UINT32_C(0x3f8011d8),
         UINT32_C(0x3f9a3990),
         UINT32_C(0x3f88347c),
         UINT32_C(0x3f921c34),
         UINT32_C(0x3f802312),
         UINT32_C(0x3f9a0b5a),
         UINT32_C(0x3f8806b6),
         UINT32_C(0x3f922efe),
         UINT32_C(0x3f8032ca),
         UINT32_C(0x3f9a1a82),
         UINT32_C(0x3f88176e),
         UINT32_C(0x3f923f26)},
        UINT32_C(0xfff80000),
        {0xc1,0x2c,0x81,0xd7,0x86,0x64,0xb1,0x2b,0x64,0x0d,
         0x03,0xf6,0x5c,0x83,0x00,0x2a,0xbc,0xea,0xdc,0x0f,0x00}
    },
    {
        /* No.245 delta:1052 weight:1575 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x897f1ecc),
         UINT32_C(0x20523dfa),
         UINT32_C(0xa92d2336),
         UINT32_C(0xcc300f52),
         UINT32_C(0x454f119e),
         UINT32_C(0xec6232a8),
         UINT32_C(0x651d2c64),
         UINT32_C(0x0000802c),
         UINT32_C(0x897f9ee0),
         UINT32_C(0x2052bdd6),
         UINT32_C(0xa92da31a),
         UINT32_C(0xcc308f7e),
         UINT32_C(0x454f91b2),
         UINT32_C(0xec62b284),
         UINT32_C(0x651dac48)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4049c135),
         UINT32_C(0x600005fa),
         UINT32_C(0x2049c4cf),
         UINT32_C(0x800080f6),
         UINT32_C(0xc04941c3),
         UINT32_C(0xe000850c),
         UINT32_C(0xa0494439),
         UINT32_C(0x00001090),
         UINT32_C(0x4049d1a5),
         UINT32_C(0x6000156a),
         UINT32_C(0x2049d45f),
         UINT32_C(0x80009066),
         UINT32_C(0xc0495153),
         UINT32_C(0xe000959c),
         UINT32_C(0xa04954a9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa024e0),
         UINT32_C(0x3fb00002),
         UINT32_C(0x3f9024e2),
         UINT32_C(0x3fc00040),
         UINT32_C(0x3fe024a0),
         UINT32_C(0x3ff00042),
         UINT32_C(0x3fd024a2),
         UINT32_C(0x3f800008),
         UINT32_C(0x3fa024e8),
         UINT32_C(0x3fb0000a),
         UINT32_C(0x3f9024ea),
         UINT32_C(0x3fc00048),
         UINT32_C(0x3fe024a8),
         UINT32_C(0x3ff0004a),
         UINT32_C(0x3fd024aa)},
        UINT32_C(0xfff80000),
        {0x34,0xf6,0x87,0x19,0x71,0x96,0xeb,0x10,0x2c,0x0c,
         0x30,0xf6,0x48,0x8c,0x49,0x9b,0x14,0x7f,0xfa,0x83,0x00}
    },
    {
        /* No.246 delta:866 weight:1437 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8bfba319),
         UINT32_C(0x05d4ddb9),
         UINT32_C(0x8e2f7ea0),
         UINT32_C(0x48900f6a),
         UINT32_C(0xc36bac73),
         UINT32_C(0x4d44d2d3),
         UINT32_C(0xc6bf71ca),
         UINT32_C(0x0000411a),
         UINT32_C(0x8bfbe203),
         UINT32_C(0x05d49ca3),
         UINT32_C(0x8e2f3fba),
         UINT32_C(0x48904e70),
         UINT32_C(0xc36bed69),
         UINT32_C(0x4d4493c9),
         UINT32_C(0xc6bf30d0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0318b3f6),
         UINT32_C(0x68390a3f),
         UINT32_C(0x6b21b9c9),
         UINT32_C(0x606462a2),
         UINT32_C(0x637cd154),
         UINT32_C(0x085d689d),
         UINT32_C(0x0b45db6b),
         UINT32_C(0x001181d2),
         UINT32_C(0x03093224),
         UINT32_C(0x68288bed),
         UINT32_C(0x6b30381b),
         UINT32_C(0x6075e370),
         UINT32_C(0x636d5086),
         UINT32_C(0x084ce94f),
         UINT32_C(0x0b545ab9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f818c59),
         UINT32_C(0x3fb41c85),
         UINT32_C(0x3fb590dc),
         UINT32_C(0x3fb03231),
         UINT32_C(0x3fb1be68),
         UINT32_C(0x3f842eb4),
         UINT32_C(0x3f85a2ed),
         UINT32_C(0x3f8008c0),
         UINT32_C(0x3f818499),
         UINT32_C(0x3fb41445),
         UINT32_C(0x3fb5981c),
         UINT32_C(0x3fb03af1),
         UINT32_C(0x3fb1b6a8),
         UINT32_C(0x3f842674),
         UINT32_C(0x3f85aa2d)},
        UINT32_C(0xfff80000),
        {0xd8,0xaa,0x8c,0x91,0xd1,0x94,0x8a,0x56,0x8b,0xf4,
         0xbf,0xff,0x90,0xb6,0x8c,0x6e,0x55,0xfc,0xf6,0x1e,0x00}
    },
    {
        /* No.247 delta:1081 weight:1351 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4038e490),
         UINT32_C(0x927decbe),
         UINT32_C(0xd245082e),
         UINT32_C(0xaf700f77),
         UINT32_C(0xef48ebe7),
         UINT32_C(0x3d0de3c9),
         UINT32_C(0x7d350759),
         UINT32_C(0x0000e3af),
         UINT32_C(0x4038073f),
         UINT32_C(0x927d0f11),
         UINT32_C(0xd245eb81),
         UINT32_C(0xaf70ecd8),
         UINT32_C(0xef480848),
         UINT32_C(0x3d0d0066),
         UINT32_C(0x7d35e4f6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00745192),
         UINT32_C(0x004a196d),
         UINT32_C(0x003e48ff),
         UINT32_C(0x00098019),
         UINT32_C(0x007dd18b),
         UINT32_C(0x00439974),
         UINT32_C(0x0037c8e6),
         UINT32_C(0x2080298c),
         UINT32_C(0x20f4781e),
         UINT32_C(0x20ca30e1),
         UINT32_C(0x20be6173),
         UINT32_C(0x2089a995),
         UINT32_C(0x20fdf807),
         UINT32_C(0x20c3b0f8),
         UINT32_C(0x20b7e16a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a28),
         UINT32_C(0x3f80250c),
         UINT32_C(0x3f801f24),
         UINT32_C(0x3f8004c0),
         UINT32_C(0x3f803ee8),
         UINT32_C(0x3f8021cc),
         UINT32_C(0x3f801be4),
         UINT32_C(0x3f904014),
         UINT32_C(0x3f907a3c),
         UINT32_C(0x3f906518),
         UINT32_C(0x3f905f30),
         UINT32_C(0x3f9044d4),
         UINT32_C(0x3f907efc),
         UINT32_C(0x3f9061d8),
         UINT32_C(0x3f905bf0)},
        UINT32_C(0xfff80000),
        {0x81,0x97,0x5b,0xe9,0x62,0x18,0xbd,0x08,0xff,0xc4,
         0x8f,0xf2,0xcc,0xba,0xb8,0x1c,0xe3,0xa5,0x8b,0x68,0x00}
    },
    {
        /* No.248 delta:917 weight:1245 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf6306c98),
         UINT32_C(0x83db0b6e),
         UINT32_C(0x75eb67f6),
         UINT32_C(0x1c800f86),
         UINT32_C(0xeab0631e),
         UINT32_C(0x9f5b04e8),
         UINT32_C(0x696b6870),
         UINT32_C(0x000099c0),
         UINT32_C(0xf630f558),
         UINT32_C(0x83db92ae),
         UINT32_C(0x75ebfe36),
         UINT32_C(0x1c809646),
         UINT32_C(0xeab0fade),
         UINT32_C(0x9f5b9d28),
         UINT32_C(0x696bf1b0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x204c216b),
         UINT32_C(0x400000bc),
         UINT32_C(0x604c21d7),
         UINT32_C(0x5030c811),
         UINT32_C(0x707ce97a),
         UINT32_C(0x1030c8ad),
         UINT32_C(0x307ce9c6),
         UINT32_C(0x40010804),
         UINT32_C(0x604d296f),
         UINT32_C(0x000108b8),
         UINT32_C(0x204d29d3),
         UINT32_C(0x1031c015),
         UINT32_C(0x307de17e),
         UINT32_C(0x5031c0a9),
         UINT32_C(0x707de1c2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902610),
         UINT32_C(0x3fa00000),
         UINT32_C(0x3fb02610),
         UINT32_C(0x3fa81864),
         UINT32_C(0x3fb83e74),
         UINT32_C(0x3f881864),
         UINT32_C(0x3f983e74),
         UINT32_C(0x3fa00084),
         UINT32_C(0x3fb02694),
         UINT32_C(0x3f800084),
         UINT32_C(0x3f902694),
         UINT32_C(0x3f8818e0),
         UINT32_C(0x3f983ef0),
         UINT32_C(0x3fa818e0),
         UINT32_C(0x3fb83ef0)},
        UINT32_C(0xfff80000),
        {0x49,0x62,0x20,0xf2,0xe9,0xcd,0x93,0x52,0xa3,0xfd,
         0x81,0x9b,0xf7,0xcb,0x48,0x7c,0x53,0xf4,0xd1,0x96,0x00}
    },
    {
        /* No.249 delta:3104 weight:611 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfe07e67a),
         UINT32_C(0x0d725357),
         UINT32_C(0xf375b52d),
         UINT32_C(0x7ea00f98),
         UINT32_C(0x80a7e9e2),
         UINT32_C(0x73d25ccf),
         UINT32_C(0x8dd5bab5),
         UINT32_C(0x0000a8bb),
         UINT32_C(0xfe074ec1),
         UINT32_C(0x0d72fbec),
         UINT32_C(0xf3751d96),
         UINT32_C(0x7ea0a723),
         UINT32_C(0x80a74159),
         UINT32_C(0x73d2f474),
         UINT32_C(0x8dd5120e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0200b4eb),
         UINT32_C(0x08d2409e),
         UINT32_C(0x0ad2f475),
         UINT32_C(0xb041120c),
         UINT32_C(0xb241a6e7),
         UINT32_C(0xb8935292),
         UINT32_C(0xba93e679),
         UINT32_C(0x28008013),
         UINT32_C(0x2a0034f8),
         UINT32_C(0x20d2c08d),
         UINT32_C(0x22d27466),
         UINT32_C(0x9841921f),
         UINT32_C(0x9a4126f4),
         UINT32_C(0x9093d281),
         UINT32_C(0x9293666a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f81005a),
         UINT32_C(0x3f846920),
         UINT32_C(0x3f85697a),
         UINT32_C(0x3fd82089),
         UINT32_C(0x3fd920d3),
         UINT32_C(0x3fdc49a9),
         UINT32_C(0x3fdd49f3),
         UINT32_C(0x3f940040),
         UINT32_C(0x3f95001a),
         UINT32_C(0x3f906960),
         UINT32_C(0x3f91693a),
         UINT32_C(0x3fcc20c9),
         UINT32_C(0x3fcd2093),
         UINT32_C(0x3fc849e9),
         UINT32_C(0x3fc949b3)},
        UINT32_C(0xfff80000),
        {0xc5,0xe0,0xf8,0xcc,0xa0,0x0e,0x7d,0x9b,0x3c,0xa5,
         0x41,0x95,0x21,0xf6,0x26,0x8e,0x33,0xf4,0x75,0x77,0x00}
    },
    {
        /* No.250 delta:869 weight:1669 */
        11213,
        41,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc43f1bd2),
         UINT32_C(0x06294d87),
         UINT32_C(0xc2165655),
         UINT32_C(0xffd00fa3),
         UINT32_C(0x3bef1471),
         UINT32_C(0xf9f94224),
         UINT32_C(0x3dc659f6),
         UINT32_C(0x00001d94),
         UINT32_C(0xc43f0646),
         UINT32_C(0x06295013),
         UINT32_C(0xc2164bc1),
         UINT32_C(0xffd01237),
         UINT32_C(0x3bef09e5),
         UINT32_C(0xf9f95fb0),
         UINT32_C(0x3dc64462)},
        {UINT32_C(0x00000000),
         UINT32_C(0x306c79d6),
         UINT32_C(0x0003428f),
         UINT32_C(0x306f3b59),
         UINT32_C(0x703813be),
         UINT32_C(0x40546a68),
         UINT32_C(0x703b5131),
         UINT32_C(0x405728e7),
         UINT32_C(0x1028401c),
         UINT32_C(0x204439ca),
         UINT32_C(0x102b0293),
         UINT32_C(0x20477b45),
         UINT32_C(0x601053a2),
         UINT32_C(0x507c2a74),
         UINT32_C(0x6013112d),
         UINT32_C(0x507f68fb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f98363c),
         UINT32_C(0x3f8001a1),
         UINT32_C(0x3f98379d),
         UINT32_C(0x3fb81c09),
         UINT32_C(0x3fa02a35),
         UINT32_C(0x3fb81da8),
         UINT32_C(0x3fa02b94),
         UINT32_C(0x3f881420),
         UINT32_C(0x3f90221c),
         UINT32_C(0x3f881581),
         UINT32_C(0x3f9023bd),
         UINT32_C(0x3fb00829),
         UINT32_C(0x3fa83e15),
         UINT32_C(0x3fb00988),
         UINT32_C(0x3fa83fb4)},
        UINT32_C(0xfff80000),
        {0x9d,0x68,0xef,0xad,0x03,0x83,0x62,0x0c,0x79,0x30,
         0xd2,0x34,0x90,0x4e,0xb3,0x38,0xdc,0x59,0x79,0xd2,0x00}
    },
    {
        /* No.251 delta:1162 weight:1717 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe894c623),
         UINT32_C(0x4d24d22d),
         UINT32_C(0xa5b0140e),
         UINT32_C(0x8ee00fbc),
         UINT32_C(0x6674c99f),
         UINT32_C(0xc3c4dd91),
         UINT32_C(0x2b501bb2),
         UINT32_C(0x00005afc),
         UINT32_C(0xe8949cdf),
         UINT32_C(0x4d2488d1),
         UINT32_C(0xa5b04ef2),
         UINT32_C(0x8ee05540),
         UINT32_C(0x66749363),
         UINT32_C(0xc3c4876d),
         UINT32_C(0x2b50414e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x110c053a),
         UINT32_C(0x404a21cf),
         UINT32_C(0x514624f5),
         UINT32_C(0x3040a0dc),
         UINT32_C(0x214ca5e6),
         UINT32_C(0x700a8113),
         UINT32_C(0x61068429),
         UINT32_C(0x00062071),
         UINT32_C(0x110a254b),
         UINT32_C(0x404c01be),
         UINT32_C(0x51400484),
         UINT32_C(0x304680ad),
         UINT32_C(0x214a8597),
         UINT32_C(0x700ca162),
         UINT32_C(0x6100a458)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f888602),
         UINT32_C(0x3fa02510),
         UINT32_C(0x3fa8a312),
         UINT32_C(0x3f982050),
         UINT32_C(0x3f90a652),
         UINT32_C(0x3fb80540),
         UINT32_C(0x3fb08342),
         UINT32_C(0x3f800310),
         UINT32_C(0x3f888512),
         UINT32_C(0x3fa02600),
         UINT32_C(0x3fa8a002),
         UINT32_C(0x3f982340),
         UINT32_C(0x3f90a542),
         UINT32_C(0x3fb80650),
         UINT32_C(0x3fb08052)},
        UINT32_C(0xfff80000),
        {0x79,0x69,0xf5,0xba,0x26,0x51,0xcd,0x20,0x6e,0x16,
         0x6f,0x8b,0xac,0x8d,0xf4,0xbe,0xaa,0xa1,0x19,0xb4,0x00}
    },
    {
        /* No.252 delta:1583 weight:1609 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8a792ec4),
         UINT32_C(0xfe8e1123),
         UINT32_C(0x74f73fe7),
         UINT32_C(0xab800fc3),
         UINT32_C(0x21f92107),
         UINT32_C(0x550e1ee0),
         UINT32_C(0xdf773024),
         UINT32_C(0x0000e184),
         UINT32_C(0x8a79cf40),
         UINT32_C(0xfe8ef0a7),
         UINT32_C(0x74f7de63),
         UINT32_C(0xab80ee47),
         UINT32_C(0x21f9c083),
         UINT32_C(0x550eff64),
         UINT32_C(0xdf77d1a0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x84a648b2),
         UINT32_C(0x005a030a),
         UINT32_C(0x84fc4bb8),
         UINT32_C(0x593d009c),
         UINT32_C(0xdd9b482e),
         UINT32_C(0x59670396),
         UINT32_C(0xddc14b24),
         UINT32_C(0x10008353),
         UINT32_C(0x94a6cbe1),
         UINT32_C(0x105a8059),
         UINT32_C(0x94fcc8eb),
         UINT32_C(0x493d83cf),
         UINT32_C(0xcd9bcb7d),
         UINT32_C(0x496780c5),
         UINT32_C(0xcdc1c877)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc25324),
         UINT32_C(0x3f802d01),
         UINT32_C(0x3fc27e25),
         UINT32_C(0x3fac9e80),
         UINT32_C(0x3feecda4),
         UINT32_C(0x3facb381),
         UINT32_C(0x3feee0a5),
         UINT32_C(0x3f880041),
         UINT32_C(0x3fca5365),
         UINT32_C(0x3f882d40),
         UINT32_C(0x3fca7e64),
         UINT32_C(0x3fa49ec1),
         UINT32_C(0x3fe6cde5),
         UINT32_C(0x3fa4b3c0),
         UINT32_C(0x3fe6e0e4)},
        UINT32_C(0xfff80000),
        {0xbb,0xd6,0x98,0x2a,0x1f,0x07,0x0d,0x35,0xa2,0x37,
         0x88,0xe4,0x31,0xe7,0xea,0x27,0xc8,0x07,0x91,0x6a,0x00}
    },
    {
        /* No.253 delta:721 weight:1577 */
        11213,
        66,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3e850aef),
         UINT32_C(0xd60ef703),
         UINT32_C(0xe88bfdec),
         UINT32_C(0x14400fd1),
         UINT32_C(0x2ac5053e),
         UINT32_C(0xc24ef8d2),
         UINT32_C(0xfccbf23d),
         UINT32_C(0x0000412b),
         UINT32_C(0x3e854bc4),
         UINT32_C(0xd60eb628),
         UINT32_C(0xe88bbcc7),
         UINT32_C(0x14404efa),
         UINT32_C(0x2ac54415),
         UINT32_C(0xc24eb9f9),
         UINT32_C(0xfccbb316)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000231ba),
         UINT32_C(0x2064c13f),
         UINT32_C(0x2066f085),
         UINT32_C(0x30080017),
         UINT32_C(0x300a31ad),
         UINT32_C(0x106cc128),
         UINT32_C(0x106ef092),
         UINT32_C(0x2000a80b),
         UINT32_C(0x200299b1),
         UINT32_C(0x00646934),
         UINT32_C(0x0066588e),
         UINT32_C(0x1008a81c),
         UINT32_C(0x100a99a6),
         UINT32_C(0x306c6923),
         UINT32_C(0x306e5899)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800118),
         UINT32_C(0x3f903260),
         UINT32_C(0x3f903378),
         UINT32_C(0x3f980400),
         UINT32_C(0x3f980518),
         UINT32_C(0x3f883660),
         UINT32_C(0x3f883778),
         UINT32_C(0x3f900054),
         UINT32_C(0x3f90014c),
         UINT32_C(0x3f803234),
         UINT32_C(0x3f80332c),
         UINT32_C(0x3f880454),
         UINT32_C(0x3f88054c),
         UINT32_C(0x3f983634),
         UINT32_C(0x3f98372c)},
        UINT32_C(0xfff80000),
        {0x0f,0x5c,0x5d,0x61,0x52,0x2d,0xf2,0x5f,0xa2,0x7e,
         0x9b,0xd4,0xa5,0x3a,0xc0,0xf5,0x0c,0x06,0x70,0xbd,0x00}
    },
    {
        /* No.254 delta:711 weight:1425 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb21db8e2),
         UINT32_C(0xd4e65389),
         UINT32_C(0x66fbeb6b),
         UINT32_C(0x61700fed),
         UINT32_C(0xd36db70f),
         UINT32_C(0xb5965c64),
         UINT32_C(0x078be486),
         UINT32_C(0x00007046),
         UINT32_C(0xb21dc8a4),
         UINT32_C(0xd4e623cf),
         UINT32_C(0x66fb9b2d),
         UINT32_C(0x61707fab),
         UINT32_C(0xd36dc749),
         UINT32_C(0xb5962c22),
         UINT32_C(0x078b94c0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80021f16),
         UINT32_C(0x1800041c),
         UINT32_C(0x98021b0a),
         UINT32_C(0x20100011),
         UINT32_C(0xa0121f07),
         UINT32_C(0x3810040d),
         UINT32_C(0xb8121b1b),
         UINT32_C(0xc000101a),
         UINT32_C(0x40020f0c),
         UINT32_C(0xd8001406),
         UINT32_C(0x58020b10),
         UINT32_C(0xe010100b),
         UINT32_C(0x60120f1d),
         UINT32_C(0xf8101417),
         UINT32_C(0x78120b01)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc0010f),
         UINT32_C(0x3f8c0002),
         UINT32_C(0x3fcc010d),
         UINT32_C(0x3f900800),
         UINT32_C(0x3fd0090f),
         UINT32_C(0x3f9c0802),
         UINT32_C(0x3fdc090d),
         UINT32_C(0x3fe00008),
         UINT32_C(0x3fa00107),
         UINT32_C(0x3fec000a),
         UINT32_C(0x3fac0105),
         UINT32_C(0x3ff00808),
         UINT32_C(0x3fb00907),
         UINT32_C(0x3ffc080a),
         UINT32_C(0x3fbc0905)},
        UINT32_C(0xfff80000),
        {0x86,0xc9,0x7c,0x93,0x6b,0x18,0xc2,0x59,0xcd,0x8e,
         0x32,0x73,0x35,0x8d,0x77,0x06,0xdf,0xbd,0xea,0x12,0x00}
    },
    {
        /* No.255 delta:933 weight:1313 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x349456a5),
         UINT32_C(0x5a59f264),
         UINT32_C(0x6ecda4c1),
         UINT32_C(0x6b000ffb),
         UINT32_C(0x5f94595e),
         UINT32_C(0x3159fd9f),
         UINT32_C(0x05cdab3a),
         UINT32_C(0x0000e642),
         UINT32_C(0x3494b0e7),
         UINT32_C(0x5a591426),
         UINT32_C(0x6ecd4283),
         UINT32_C(0x6b00e9b9),
         UINT32_C(0x5f94bf1c),
         UINT32_C(0x31591bdd),
         UINT32_C(0x05cd4d78)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa064199d),
         UINT32_C(0x00028c09),
         UINT32_C(0xa0669594),
         UINT32_C(0x0070160c),
         UINT32_C(0xa0140f91),
         UINT32_C(0x00729a05),
         UINT32_C(0xa0168398),
         UINT32_C(0x202d0013),
         UINT32_C(0x8049198e),
         UINT32_C(0x202f8c1a),
         UINT32_C(0x804b9587),
         UINT32_C(0x205d161f),
         UINT32_C(0x80390f82),
         UINT32_C(0x205f9a16),
         UINT32_C(0x803b838b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd0320c),
         UINT32_C(0x3f800146),
         UINT32_C(0x3fd0334a),
         UINT32_C(0x3f80380b),
         UINT32_C(0x3fd00a07),
         UINT32_C(0x3f80394d),
         UINT32_C(0x3fd00b41),
         UINT32_C(0x3f901680),
         UINT32_C(0x3fc0248c),
         UINT32_C(0x3f9017c6),
         UINT32_C(0x3fc025ca),
         UINT32_C(0x3f902e8b),
         UINT32_C(0x3fc01c87),
         UINT32_C(0x3f902fcd),
         UINT32_C(0x3fc01dc1)},
        UINT32_C(0xfff80000),
        {0x45,0x8b,0x9e,0x01,0x37,0x33,0x2f,0x18,0xc2,0x03,
         0x68,0x8a,0x70,0xc5,0x62,0xdb,0xcc,0xa0,0x2d,0x43,0x00}
    },
    {
        /* No.256 delta:605 weight:1801 */
        11213,
        85,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x342137e7),
         UINT32_C(0x86f5904e),
         UINT32_C(0xb2d4a7a9),
         UINT32_C(0x1f30100c),
         UINT32_C(0x2b1127eb),
         UINT32_C(0x99c58042),
         UINT32_C(0xade4b7a5),
         UINT32_C(0x0000f1e9),
         UINT32_C(0x3421c60e),
         UINT32_C(0x86f561a7),
         UINT32_C(0xb2d45640),
         UINT32_C(0x1f30e1e5),
         UINT32_C(0x2b11d602),
         UINT32_C(0x99c571ab),
         UINT32_C(0xade4464c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6054283e),
         UINT32_C(0x402c6d03),
         UINT32_C(0x2078453d),
         UINT32_C(0x00032984),
         UINT32_C(0x605701ba),
         UINT32_C(0x402f4487),
         UINT32_C(0x207b6cb9),
         UINT32_C(0x00441390),
         UINT32_C(0x60103bae),
         UINT32_C(0x40687e93),
         UINT32_C(0x203c56ad),
         UINT32_C(0x00473a14),
         UINT32_C(0x6013122a),
         UINT32_C(0x406b5717),
         UINT32_C(0x203f7f29)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb02a14),
         UINT32_C(0x3fa01636),
         UINT32_C(0x3f903c22),
         UINT32_C(0x3f800194),
         UINT32_C(0x3fb02b80),
         UINT32_C(0x3fa017a2),
         UINT32_C(0x3f903db6),
         UINT32_C(0x3f802209),
         UINT32_C(0x3fb0081d),
         UINT32_C(0x3fa0343f),
         UINT32_C(0x3f901e2b),
         UINT32_C(0x3f80239d),
         UINT32_C(0x3fb00989),
         UINT32_C(0x3fa035ab),
         UINT32_C(0x3f901fbf)},
        UINT32_C(0xfff80000),
        {0x6a,0x8c,0x53,0xa9,0x17,0xee,0xbd,0x72,0x95,0x5a,
         0xce,0xd3,0x11,0x5d,0xa2,0x36,0xea,0x74,0x99,0x2a,0x00}
    },
    {
        /* No.257 delta:863 weight:1373 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb7066e36),
         UINT32_C(0x2c98dbac),
         UINT32_C(0x9b9eb59a),
         UINT32_C(0x9b101010),
         UINT32_C(0x2c167e26),
         UINT32_C(0xb788cbbc),
         UINT32_C(0x008ea58a),
         UINT32_C(0x00006100),
         UINT32_C(0xb7060f36),
         UINT32_C(0x2c98baac),
         UINT32_C(0x9b9ed49a),
         UINT32_C(0x9b107110),
         UINT32_C(0x2c161f26),
         UINT32_C(0xb788aabc),
         UINT32_C(0x008ec48a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20401155),
         UINT32_C(0x101c1407),
         UINT32_C(0x305c0552),
         UINT32_C(0x1072a07c),
         UINT32_C(0x3032b129),
         UINT32_C(0x006eb47b),
         UINT32_C(0x202ea52e),
         UINT32_C(0x50204163),
         UINT32_C(0x70605036),
         UINT32_C(0x403c5564),
         UINT32_C(0x607c4431),
         UINT32_C(0x4052e11f),
         UINT32_C(0x6012f04a),
         UINT32_C(0x504ef518),
         UINT32_C(0x700ee44d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902008),
         UINT32_C(0x3f880e0a),
         UINT32_C(0x3f982e02),
         UINT32_C(0x3f883950),
         UINT32_C(0x3f981958),
         UINT32_C(0x3f80375a),
         UINT32_C(0x3f901752),
         UINT32_C(0x3fa81020),
         UINT32_C(0x3fb83028),
         UINT32_C(0x3fa01e2a),
         UINT32_C(0x3fb03e22),
         UINT32_C(0x3fa02970),
         UINT32_C(0x3fb00978),
         UINT32_C(0x3fa8277a),
         UINT32_C(0x3fb80772)},
        UINT32_C(0xfff80000),
        {0xc8,0xf8,0xe1,0x6d,0x99,0xea,0x62,0x89,0x5e,0xf6,
         0x2a,0x05,0x18,0x72,0x7f,0x94,0xd4,0xbc,0x43,0x2f,0x00}
    },
    {
        /* No.258 delta:844 weight:1611 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x360179e6),
         UINT32_C(0x7d8f574e),
         UINT32_C(0x4b8e2ea8),
         UINT32_C(0xe3e01029),
         UINT32_C(0xd5e169cf),
         UINT32_C(0x9e6f4767),
         UINT32_C(0xa86e3e81),
         UINT32_C(0x0000388d),
         UINT32_C(0x3601416b),
         UINT32_C(0x7d8f6fc3),
         UINT32_C(0x4b8e1625),
         UINT32_C(0xe3e028a4),
         UINT32_C(0xd5e15142),
         UINT32_C(0x9e6f7fea),
         UINT32_C(0xa86e060c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0002359a),
         UINT32_C(0x38042137),
         UINT32_C(0x380614ad),
         UINT32_C(0x2001a0a4),
         UINT32_C(0x2003953e),
         UINT32_C(0x18058193),
         UINT32_C(0x1807b409),
         UINT32_C(0x10408054),
         UINT32_C(0x1042b5ce),
         UINT32_C(0x2844a163),
         UINT32_C(0x284694f9),
         UINT32_C(0x304120f0),
         UINT32_C(0x3043156a),
         UINT32_C(0x084501c7),
         UINT32_C(0x0847345d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80011a),
         UINT32_C(0x3f9c0210),
         UINT32_C(0x3f9c030a),
         UINT32_C(0x3f9000d0),
         UINT32_C(0x3f9001ca),
         UINT32_C(0x3f8c02c0),
         UINT32_C(0x3f8c03da),
         UINT32_C(0x3f882040),
         UINT32_C(0x3f88215a),
         UINT32_C(0x3f942250),
         UINT32_C(0x3f94234a),
         UINT32_C(0x3f982090),
         UINT32_C(0x3f98218a),
         UINT32_C(0x3f842280),
         UINT32_C(0x3f84239a)},
        UINT32_C(0xfff80000),
        {0xfb,0xdc,0xb0,0x3d,0x31,0x8e,0x11,0xf1,0x4a,0x02,
         0xb2,0x55,0xda,0xae,0x59,0x8f,0x1a,0x96,0x73,0x1d,0x00}
    },
    {
        /* No.259 delta:992 weight:1607 */
        11213,
        67,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd8eeb2ae),
         UINT32_C(0xbb27aba5),
         UINT32_C(0x63c9190b),
         UINT32_C(0x0a701030),
         UINT32_C(0xd29ea29e),
         UINT32_C(0xb157bb95),
         UINT32_C(0x69b9093b),
         UINT32_C(0x0000f6ce),
         UINT32_C(0xd8ee4460),
         UINT32_C(0xbb275d6b),
         UINT32_C(0x63c9efc5),
         UINT32_C(0x0a70e6fe),
         UINT32_C(0xd29e5450),
         UINT32_C(0xb1574d5b),
         UINT32_C(0x69b9fff5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x406b805a),
         UINT32_C(0x105c4107),
         UINT32_C(0x5037c15d),
         UINT32_C(0x00020011),
         UINT32_C(0x4069804b),
         UINT32_C(0x105e4116),
         UINT32_C(0x5035c14c),
         UINT32_C(0x000360ee),
         UINT32_C(0x4068e0b4),
         UINT32_C(0x105f21e9),
         UINT32_C(0x5034a1b3),
         UINT32_C(0x000160ff),
         UINT32_C(0x406ae0a5),
         UINT32_C(0x105d21f8),
         UINT32_C(0x5036a1a2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa035c0),
         UINT32_C(0x3f882e20),
         UINT32_C(0x3fa81be0),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa034c0),
         UINT32_C(0x3f882f20),
         UINT32_C(0x3fa81ae0),
         UINT32_C(0x3f8001b0),
         UINT32_C(0x3fa03470),
         UINT32_C(0x3f882f90),
         UINT32_C(0x3fa81a50),
         UINT32_C(0x3f8000b0),
         UINT32_C(0x3fa03570),
         UINT32_C(0x3f882e90),
         UINT32_C(0x3fa81b50)},
        UINT32_C(0xfff80000),
        {0xf3,0xf4,0xf3,0x13,0xb4,0xd8,0xeb,0xf3,0xc0,0xd5,
         0xea,0x82,0xf4,0x00,0xb5,0x10,0xcf,0xe7,0x19,0x71,0x00}
    },
    {
        /* No.260 delta:1024 weight:1663 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd7afe2a0),
         UINT32_C(0xd521d695),
         UINT32_C(0x028e3435),
         UINT32_C(0xdfb0104f),
         UINT32_C(0x081ff2ef),
         UINT32_C(0x0a91c6da),
         UINT32_C(0xdd3e247a),
         UINT32_C(0x00007d7d),
         UINT32_C(0xd7af9fdd),
         UINT32_C(0xd521abe8),
         UINT32_C(0x028e4948),
         UINT32_C(0xdfb06d32),
         UINT32_C(0x081f8f92),
         UINT32_C(0x0a91bba7),
         UINT32_C(0xdd3e5907)},
        {UINT32_C(0x00000000),
         UINT32_C(0x346a0796),
         UINT32_C(0x005c830f),
         UINT32_C(0x34368499),
         UINT32_C(0x00720015),
         UINT32_C(0x34180783),
         UINT32_C(0x002e831a),
         UINT32_C(0x3444848c),
         UINT32_C(0x00030169),
         UINT32_C(0x346906ff),
         UINT32_C(0x005f8266),
         UINT32_C(0x343585f0),
         UINT32_C(0x0071017c),
         UINT32_C(0x341b06ea),
         UINT32_C(0x002d8273),
         UINT32_C(0x344785e5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9a3503),
         UINT32_C(0x3f802e41),
         UINT32_C(0x3f9a1b42),
         UINT32_C(0x3f803900),
         UINT32_C(0x3f9a0c03),
         UINT32_C(0x3f801741),
         UINT32_C(0x3f9a2242),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f9a3483),
         UINT32_C(0x3f802fc1),
         UINT32_C(0x3f9a1ac2),
         UINT32_C(0x3f803880),
         UINT32_C(0x3f9a0d83),
         UINT32_C(0x3f8016c1),
         UINT32_C(0x3f9a23c2)},
        UINT32_C(0xfff80000),
        {0xa1,0x73,0x91,0x1d,0x3a,0x48,0xba,0xbe,0x46,0x5c,
         0xa1,0x3d,0x32,0x83,0x48,0xcb,0xb5,0x5e,0x31,0xec,0x00}
    },
    {
        /* No.261 delta:1296 weight:1559 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb4eadce0),
         UINT32_C(0xf6b33791),
         UINT32_C(0x4259eb71),
         UINT32_C(0x5370105f),
         UINT32_C(0xe79accbf),
         UINT32_C(0xa5c327ce),
         UINT32_C(0x1129fb2e),
         UINT32_C(0x00005bbe),
         UINT32_C(0xb4ea875e),
         UINT32_C(0xf6b36c2f),
         UINT32_C(0x4259b0cf),
         UINT32_C(0x53704be1),
         UINT32_C(0xe79a9701),
         UINT32_C(0xa5c37c70),
         UINT32_C(0x1129a090)},
        {UINT32_C(0x00000000),
         UINT32_C(0x003c00f2),
         UINT32_C(0x00526c15),
         UINT32_C(0x006e6ce7),
         UINT32_C(0x444121d8),
         UINT32_C(0x447d212a),
         UINT32_C(0x44134dcd),
         UINT32_C(0x442f4d3f),
         UINT32_C(0x5040517b),
         UINT32_C(0x507c5189),
         UINT32_C(0x50123d6e),
         UINT32_C(0x502e3d9c),
         UINT32_C(0x140170a3),
         UINT32_C(0x143d7051),
         UINT32_C(0x14531cb6),
         UINT32_C(0x146f1c44)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801e00),
         UINT32_C(0x3f802936),
         UINT32_C(0x3f803736),
         UINT32_C(0x3fa22090),
         UINT32_C(0x3fa23e90),
         UINT32_C(0x3fa209a6),
         UINT32_C(0x3fa217a6),
         UINT32_C(0x3fa82028),
         UINT32_C(0x3fa83e28),
         UINT32_C(0x3fa8091e),
         UINT32_C(0x3fa8171e),
         UINT32_C(0x3f8a00b8),
         UINT32_C(0x3f8a1eb8),
         UINT32_C(0x3f8a298e),
         UINT32_C(0x3f8a378e)},
        UINT32_C(0xfff80000),
        {0x39,0xec,0xa1,0x9c,0xfe,0x15,0x24,0x8f,0x79,0x2a,
         0xe2,0x1b,0x4b,0x1f,0x3b,0x93,0xc2,0xf8,0xfe,0x28,0x00}
    },
    {
        /* No.262 delta:1036 weight:1361 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2b06a8a3),
         UINT32_C(0x088b8a7e),
         UINT32_C(0x238d22dd),
         UINT32_C(0x84a0106f),
         UINT32_C(0xafa6b8cc),
         UINT32_C(0x8c2b9a11),
         UINT32_C(0xa72d32b2),
         UINT32_C(0x00007f70),
         UINT32_C(0x2b06d7d3),
         UINT32_C(0x088bf50e),
         UINT32_C(0x238d5dad),
         UINT32_C(0x84a06f1f),
         UINT32_C(0xafa6c7bc),
         UINT32_C(0x8c2be561),
         UINT32_C(0xa72d4dc2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x104ea5f6),
         UINT32_C(0x0002781c),
         UINT32_C(0x104cddea),
         UINT32_C(0x2014148f),
         UINT32_C(0x305ab179),
         UINT32_C(0x20166c93),
         UINT32_C(0x3058c965),
         UINT32_C(0x4004020e),
         UINT32_C(0x504aa7f8),
         UINT32_C(0x40067a12),
         UINT32_C(0x5048dfe4),
         UINT32_C(0x60101681),
         UINT32_C(0x705eb377),
         UINT32_C(0x60126e9d),
         UINT32_C(0x705ccb6b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f882752),
         UINT32_C(0x3f80013c),
         UINT32_C(0x3f88266e),
         UINT32_C(0x3f900a0a),
         UINT32_C(0x3f982d58),
         UINT32_C(0x3f900b36),
         UINT32_C(0x3f982c64),
         UINT32_C(0x3fa00201),
         UINT32_C(0x3fa82553),
         UINT32_C(0x3fa0033d),
         UINT32_C(0x3fa8246f),
         UINT32_C(0x3fb0080b),
         UINT32_C(0x3fb82f59),
         UINT32_C(0x3fb00937),
         UINT32_C(0x3fb82e65)},
        UINT32_C(0xfff80000),
        {0x8c,0xc5,0x0c,0x35,0x11,0x9b,0x8d,0x08,0xef,0x18,
         0xf5,0x67,0x99,0x5d,0x0b,0x26,0x1e,0xca,0x92,0x53,0x00}
    },
    {
        /* No.263 delta:2453 weight:1089 */
        11213,
        6,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x458429b4),
         UINT32_C(0x7cef26c1),
         UINT32_C(0x396b0f75),
         UINT32_C(0x4320107b),
         UINT32_C(0x06a439cf),
         UINT32_C(0x3fcf36ba),
         UINT32_C(0x7a4b1f0e),
         UINT32_C(0x0000f056),
         UINT32_C(0x4584d9e2),
         UINT32_C(0x7cefd697),
         UINT32_C(0x396bff23),
         UINT32_C(0x4320e02d),
         UINT32_C(0x06a4c999),
         UINT32_C(0x3fcfc6ec),
         UINT32_C(0x7a4bef58)},
        {UINT32_C(0x00000000),
         UINT32_C(0xf34c009a),
         UINT32_C(0x2c8290eb),
         UINT32_C(0xdfce9071),
         UINT32_C(0x0c60dc1d),
         UINT32_C(0xff2cdc87),
         UINT32_C(0x20e24cf6),
         UINT32_C(0xd3ae4c6c),
         UINT32_C(0x8100a015),
         UINT32_C(0x724ca08f),
         UINT32_C(0xad8230fe),
         UINT32_C(0x5ece3064),
         UINT32_C(0x8d607c08),
         UINT32_C(0x7e2c7c92),
         UINT32_C(0xa1e2ece3),
         UINT32_C(0x52aeec79)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff9a600),
         UINT32_C(0x3f964148),
         UINT32_C(0x3fefe748),
         UINT32_C(0x3f86306e),
         UINT32_C(0x3fff966e),
         UINT32_C(0x3f907126),
         UINT32_C(0x3fe9d726),
         UINT32_C(0x3fc08050),
         UINT32_C(0x3fb92650),
         UINT32_C(0x3fd6c118),
         UINT32_C(0x3faf6718),
         UINT32_C(0x3fc6b03e),
         UINT32_C(0x3fbf163e),
         UINT32_C(0x3fd0f176),
         UINT32_C(0x3fa95776)},
        UINT32_C(0xfff80000),
        {0x94,0x05,0x08,0x43,0xc1,0xf2,0xec,0xc6,0x72,0xf9,
         0x7b,0x5f,0x0b,0xb7,0x20,0x90,0xa1,0x0c,0x05,0xc3,0x00}
    },
    {
        /* No.264 delta:2296 weight:1275 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6d36c21f),
         UINT32_C(0x2d55d337),
         UINT32_C(0x40631128),
         UINT32_C(0x40101082),
         UINT32_C(0x2d26d29d),
         UINT32_C(0x6d45c3b5),
         UINT32_C(0x007301aa),
         UINT32_C(0x0000fec9),
         UINT32_C(0x6d363cd6),
         UINT32_C(0x2d552dfe),
         UINT32_C(0x4063efe1),
         UINT32_C(0x4010ee4b),
         UINT32_C(0x2d262c54),
         UINT32_C(0x6d453d7c),
         UINT32_C(0x0073ff63)},
        {UINT32_C(0x00000000),
         UINT32_C(0x91d0823c),
         UINT32_C(0x01433183),
         UINT32_C(0x9093b3bf),
         UINT32_C(0x08238018),
         UINT32_C(0x99f30224),
         UINT32_C(0x0960b19b),
         UINT32_C(0x98b033a7),
         UINT32_C(0x284041e9),
         UINT32_C(0xb990c3d5),
         UINT32_C(0x2903706a),
         UINT32_C(0xb8d3f256),
         UINT32_C(0x2063c1f1),
         UINT32_C(0xb1b343cd),
         UINT32_C(0x2120f072),
         UINT32_C(0xb0f0724e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc8e841),
         UINT32_C(0x3f80a198),
         UINT32_C(0x3fc849d9),
         UINT32_C(0x3f8411c0),
         UINT32_C(0x3fccf981),
         UINT32_C(0x3f84b058),
         UINT32_C(0x3fcc5819),
         UINT32_C(0x3f942020),
         UINT32_C(0x3fdcc861),
         UINT32_C(0x3f9481b8),
         UINT32_C(0x3fdc69f9),
         UINT32_C(0x3f9031e0),
         UINT32_C(0x3fd8d9a1),
         UINT32_C(0x3f909078),
         UINT32_C(0x3fd87839)},
        UINT32_C(0xfff80000),
        {0xb5,0xe7,0x9a,0xf6,0x8c,0xb1,0x53,0x83,0xaa,0xdc,
         0x4f,0xd1,0x27,0xbd,0x92,0xce,0x9a,0x97,0xf6,0x5d,0x00}
    },
    {
        /* No.265 delta:1158 weight:1607 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc81c6b49),
         UINT32_C(0x43c14ad1),
         UINT32_C(0x8bdd2198),
         UINT32_C(0x4bf01098),
         UINT32_C(0x83ec7bd1),
         UINT32_C(0x08315a49),
         UINT32_C(0xc02d3100),
         UINT32_C(0x0000415a),
         UINT32_C(0xc81c2a13),
         UINT32_C(0x43c10b8b),
         UINT32_C(0x8bdd60c2),
         UINT32_C(0x4bf051c2),
         UINT32_C(0x83ec3a8b),
         UINT32_C(0x08311b13),
         UINT32_C(0xc02d705a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x407d1df6),
         UINT32_C(0x002288e3),
         UINT32_C(0x405f9515),
         UINT32_C(0x004109da),
         UINT32_C(0x403c142c),
         UINT32_C(0x00638139),
         UINT32_C(0x401e9ccf),
         UINT32_C(0x400090de),
         UINT32_C(0x007d8d28),
         UINT32_C(0x4022183d),
         UINT32_C(0x005f05cb),
         UINT32_C(0x40419904),
         UINT32_C(0x003c84f2),
         UINT32_C(0x406311e7),
         UINT32_C(0x001e0c11)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03e8e),
         UINT32_C(0x3f801144),
         UINT32_C(0x3fa02fca),
         UINT32_C(0x3f802084),
         UINT32_C(0x3fa01e0a),
         UINT32_C(0x3f8031c0),
         UINT32_C(0x3fa00f4e),
         UINT32_C(0x3fa00048),
         UINT32_C(0x3f803ec6),
         UINT32_C(0x3fa0110c),
         UINT32_C(0x3f802f82),
         UINT32_C(0x3fa020cc),
         UINT32_C(0x3f801e42),
         UINT32_C(0x3fa03188),
         UINT32_C(0x3f800f06)},
        UINT32_C(0xfff80000),
        {0x8d,0x79,0x23,0x39,0x76,0x1c,0x07,0xdc,0x6e,0x0b,
         0x77,0xe9,0xca,0xc2,0x1e,0xd5,0x38,0x40,0xdc,0x78,0x00}
    },
    {
        /* No.266 delta:846 weight:1549 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfafaddf3),
         UINT32_C(0x7291565f),
         UINT32_C(0x886b8bac),
         UINT32_C(0xcf0010ac),
         UINT32_C(0x35facd5f),
         UINT32_C(0xbd9146f3),
         UINT32_C(0x476b9b00),
         UINT32_C(0x0000950e),
         UINT32_C(0xfafa48fd),
         UINT32_C(0x7291c351),
         UINT32_C(0x886b1ea2),
         UINT32_C(0xcf0085a2),
         UINT32_C(0x35fa5851),
         UINT32_C(0xbd91d3fd),
         UINT32_C(0x476b0e0e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00412d7a),
         UINT32_C(0x20048415),
         UINT32_C(0x2045a96f),
         UINT32_C(0x402211bc),
         UINT32_C(0x40633cc6),
         UINT32_C(0x602695a9),
         UINT32_C(0x6067b8d3),
         UINT32_C(0x00020117),
         UINT32_C(0x00432c6d),
         UINT32_C(0x20068502),
         UINT32_C(0x2047a878),
         UINT32_C(0x402010ab),
         UINT32_C(0x40613dd1),
         UINT32_C(0x602494be),
         UINT32_C(0x6065b9c4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802096),
         UINT32_C(0x3f900242),
         UINT32_C(0x3f9022d4),
         UINT32_C(0x3fa01108),
         UINT32_C(0x3fa0319e),
         UINT32_C(0x3fb0134a),
         UINT32_C(0x3fb033dc),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f802196),
         UINT32_C(0x3f900342),
         UINT32_C(0x3f9023d4),
         UINT32_C(0x3fa01008),
         UINT32_C(0x3fa0309e),
         UINT32_C(0x3fb0124a),
         UINT32_C(0x3fb032dc)},
        UINT32_C(0xfff80000),
        {0x62,0xdc,0x6e,0x67,0x1c,0xbc,0xab,0x5f,0xd4,0x36,
         0x3c,0x45,0x2a,0xee,0x29,0xad,0xcd,0xf4,0x0e,0x8b,0x00}
    },
    {
        /* No.267 delta:913 weight:1567 */
        11213,
        54,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4f356cb4),
         UINT32_C(0x0cbf6d0c),
         UINT32_C(0x438a01b8),
         UINT32_C(0x18b010b3),
         UINT32_C(0x57857c07),
         UINT32_C(0x140f7dbf),
         UINT32_C(0x5b3a110b),
         UINT32_C(0x000019a5),
         UINT32_C(0x4f357511),
         UINT32_C(0x0cbf74a9),
         UINT32_C(0x438a181d),
         UINT32_C(0x18b00916),
         UINT32_C(0x578565a2),
         UINT32_C(0x140f641a),
         UINT32_C(0x5b3a08ae)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00048272),
         UINT32_C(0x02005f69),
         UINT32_C(0x0204dd1b),
         UINT32_C(0x0403b813),
         UINT32_C(0x04073a61),
         UINT32_C(0x0603e77a),
         UINT32_C(0x06076508),
         UINT32_C(0x20001016),
         UINT32_C(0x20049264),
         UINT32_C(0x22004f7f),
         UINT32_C(0x2204cd0d),
         UINT32_C(0x2403a805),
         UINT32_C(0x24072a77),
         UINT32_C(0x2603f76c),
         UINT32_C(0x2607751e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800241),
         UINT32_C(0x3f81002f),
         UINT32_C(0x3f81026e),
         UINT32_C(0x3f8201dc),
         UINT32_C(0x3f82039d),
         UINT32_C(0x3f8301f3),
         UINT32_C(0x3f8303b2),
         UINT32_C(0x3f900008),
         UINT32_C(0x3f900249),
         UINT32_C(0x3f910027),
         UINT32_C(0x3f910266),
         UINT32_C(0x3f9201d4),
         UINT32_C(0x3f920395),
         UINT32_C(0x3f9301fb),
         UINT32_C(0x3f9303ba)},
        UINT32_C(0xfff80000),
        {0x30,0x6f,0xbb,0x9a,0x32,0xf0,0x90,0xbb,0x63,0x06,
         0xf6,0x11,0x8c,0xd3,0xfc,0x59,0xbd,0x92,0xbe,0x9a,0x00}
    },
    {
        /* No.268 delta:1119 weight:1599 */
        11213,
        47,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9541706b),
         UINT32_C(0xd1114ada),
         UINT32_C(0x44503ab1),
         UINT32_C(0x1cc010c0),
         UINT32_C(0x898160ab),
         UINT32_C(0xcdd15a1a),
         UINT32_C(0x58902a71),
         UINT32_C(0x00006fc3),
         UINT32_C(0x95411fa8),
         UINT32_C(0xd1112519),
         UINT32_C(0x44505572),
         UINT32_C(0x1cc07f03),
         UINT32_C(0x89810f68),
         UINT32_C(0xcdd135d9),
         UINT32_C(0x589045b2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x122f889e),
         UINT32_C(0x0047c15c),
         UINT32_C(0x126849c2),
         UINT32_C(0x00016049),
         UINT32_C(0x122ee8d7),
         UINT32_C(0x0046a115),
         UINT32_C(0x1269298b),
         UINT32_C(0x00001003),
         UINT32_C(0x122f989d),
         UINT32_C(0x0047d15f),
         UINT32_C(0x126859c1),
         UINT32_C(0x0001704a),
         UINT32_C(0x122ef8d4),
         UINT32_C(0x0046b116),
         UINT32_C(0x12693988)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8917c4),
         UINT32_C(0x3f8023e0),
         UINT32_C(0x3f893424),
         UINT32_C(0x3f8000b0),
         UINT32_C(0x3f891774),
         UINT32_C(0x3f802350),
         UINT32_C(0x3f893494),
         UINT32_C(0x3f800008),
         UINT32_C(0x3f8917cc),
         UINT32_C(0x3f8023e8),
         UINT32_C(0x3f89342c),
         UINT32_C(0x3f8000b8),
         UINT32_C(0x3f89177c),
         UINT32_C(0x3f802358),
         UINT32_C(0x3f89349c)},
        UINT32_C(0xfff80000),
        {0xda,0x1c,0xfa,0x88,0x67,0x70,0x8b,0xf7,0x03,0x1b,
         0x66,0x13,0x62,0xdd,0x6d,0xeb,0xad,0xfa,0xf2,0x5b,0x00}
    },
    {
        /* No.269 delta:1697 weight:1573 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4d9d43f2),
         UINT32_C(0xaef042ac),
         UINT32_C(0xe36d015e),
         UINT32_C(0xed2010d6),
         UINT32_C(0xa0bd5324),
         UINT32_C(0x43d0527a),
         UINT32_C(0x0e4d1188),
         UINT32_C(0x0000ade0),
         UINT32_C(0x4d9dee12),
         UINT32_C(0xaef0ef4c),
         UINT32_C(0xe36dacbe),
         UINT32_C(0xed20bd36),
         UINT32_C(0xa0bdfec4),
         UINT32_C(0x43d0ff9a),
         UINT32_C(0x0e4dbc68)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4b91e1dd),
         UINT32_C(0x0d05a42b),
         UINT32_C(0x469445f6),
         UINT32_C(0x0100484c),
         UINT32_C(0x4a91a991),
         UINT32_C(0x0c05ec67),
         UINT32_C(0x47940dba),
         UINT32_C(0x0463801f),
         UINT32_C(0x4ff261c2),
         UINT32_C(0x09662434),
         UINT32_C(0x42f7c5e9),
         UINT32_C(0x0563c853),
         UINT32_C(0x4ef2298e),
         UINT32_C(0x08666c78),
         UINT32_C(0x43f78da5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa5c8f0),
         UINT32_C(0x3f8682d2),
         UINT32_C(0x3fa34a22),
         UINT32_C(0x3f808024),
         UINT32_C(0x3fa548d4),
         UINT32_C(0x3f8602f6),
         UINT32_C(0x3fa3ca06),
         UINT32_C(0x3f8231c0),
         UINT32_C(0x3fa7f930),
         UINT32_C(0x3f84b312),
         UINT32_C(0x3fa17be2),
         UINT32_C(0x3f82b1e4),
         UINT32_C(0x3fa77914),
         UINT32_C(0x3f843336),
         UINT32_C(0x3fa1fbc6)},
        UINT32_C(0xfff80000),
        {0x5c,0xd8,0x63,0xbe,0xba,0x24,0x1c,0x39,0x86,0xd4,
         0x6a,0xa6,0x66,0x0d,0x5c,0x89,0x96,0x7c,0x26,0x0d,0x00}
    },
    {
        /* No.270 delta:756 weight:1637 */
        11213,
        61,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xabb61e82),
         UINT32_C(0xc736718e),
         UINT32_C(0x6c806f0c),
         UINT32_C(0x094010e1),
         UINT32_C(0xa2f60e63),
         UINT32_C(0xce76616f),
         UINT32_C(0x65c07fed),
         UINT32_C(0x000015ec),
         UINT32_C(0xabb60b6e),
         UINT32_C(0xc7366462),
         UINT32_C(0x6c807ae0),
         UINT32_C(0x0940050d),
         UINT32_C(0xa2f61b8f),
         UINT32_C(0xce767483),
         UINT32_C(0x65c06a01)},
        {UINT32_C(0x00000000),
         UINT32_C(0x112e80f6),
         UINT32_C(0x0045b007),
         UINT32_C(0x116b30f1),
         UINT32_C(0x00020c18),
         UINT32_C(0x112c8cee),
         UINT32_C(0x0047bc1f),
         UINT32_C(0x11693ce9),
         UINT32_C(0x1000580c),
         UINT32_C(0x012ed8fa),
         UINT32_C(0x1045e80b),
         UINT32_C(0x016b68fd),
         UINT32_C(0x10025414),
         UINT32_C(0x012cd4e2),
         UINT32_C(0x1047e413),
         UINT32_C(0x016964e5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f889740),
         UINT32_C(0x3f8022d8),
         UINT32_C(0x3f88b598),
         UINT32_C(0x3f800106),
         UINT32_C(0x3f889646),
         UINT32_C(0x3f8023de),
         UINT32_C(0x3f88b49e),
         UINT32_C(0x3f88002c),
         UINT32_C(0x3f80976c),
         UINT32_C(0x3f8822f4),
         UINT32_C(0x3f80b5b4),
         UINT32_C(0x3f88012a),
         UINT32_C(0x3f80966a),
         UINT32_C(0x3f8823f2),
         UINT32_C(0x3f80b4b2)},
        UINT32_C(0xfff80000),
        {0xd0,0xe9,0x18,0x44,0xaf,0x9f,0x2f,0x8a,0xd3,0xb5,
         0x95,0x44,0xbb,0x80,0x3d,0x72,0xbd,0x1e,0x62,0xad,0x00}
    },
    {
        /* No.271 delta:1600 weight:1575 */
        11213,
        80,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x70c8924a),
         UINT32_C(0x9c076e90),
         UINT32_C(0xeccffcda),
         UINT32_C(0x5f0010fa),
         UINT32_C(0x2fc882b0),
         UINT32_C(0xc3077e6a),
         UINT32_C(0xb3cfec20),
         UINT32_C(0x00008d22),
         UINT32_C(0x70c81f68),
         UINT32_C(0x9c07e3b2),
         UINT32_C(0xeccf71f8),
         UINT32_C(0x5f009dd8),
         UINT32_C(0x2fc80f92),
         UINT32_C(0xc307f348),
         UINT32_C(0xb3cf6102)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007c00bd),
         UINT32_C(0x2004008e),
         UINT32_C(0x20780033),
         UINT32_C(0x00020017),
         UINT32_C(0x007e00aa),
         UINT32_C(0x20060099),
         UINT32_C(0x207a0024),
         UINT32_C(0x004001cc),
         UINT32_C(0x003c0171),
         UINT32_C(0x20440142),
         UINT32_C(0x203801ff),
         UINT32_C(0x004201db),
         UINT32_C(0x003e0166),
         UINT32_C(0x20460155),
         UINT32_C(0x203a01e8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f900200),
         UINT32_C(0x3f903c00),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f900300),
         UINT32_C(0x3f903d00),
         UINT32_C(0x3f802000),
         UINT32_C(0x3f801e00),
         UINT32_C(0x3f902200),
         UINT32_C(0x3f901c00),
         UINT32_C(0x3f802100),
         UINT32_C(0x3f801f00),
         UINT32_C(0x3f902300),
         UINT32_C(0x3f901d00)},
        UINT32_C(0xfff80000),
        {0xe4,0x54,0xe8,0xd1,0xa5,0xea,0x2d,0x86,0x55,0xac,
         0x70,0xd0,0x6d,0x7c,0x84,0xc1,0xdb,0xbe,0x53,0x9a,0x00}
    },
    {
        /* No.272 delta:728 weight:1065 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc21c2ebb),
         UINT32_C(0xf24cb725),
         UINT32_C(0x3050999e),
         UINT32_C(0xd1a0110a),
         UINT32_C(0x13bc3fb1),
         UINT32_C(0x23eca62f),
         UINT32_C(0xe1f08894),
         UINT32_C(0x00005f5d),
         UINT32_C(0xc21c71e6),
         UINT32_C(0xf24ce878),
         UINT32_C(0x3050c6c3),
         UINT32_C(0xd1a04e57),
         UINT32_C(0x13bc60ec),
         UINT32_C(0x23ecf972),
         UINT32_C(0xe1f0d7c9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x784401f7),
         UINT32_C(0x18008c1d),
         UINT32_C(0x60448dea),
         UINT32_C(0x10444818),
         UINT32_C(0x680049ef),
         UINT32_C(0x0844c405),
         UINT32_C(0x7000c5f2),
         UINT32_C(0x200ba06b),
         UINT32_C(0x584fa19c),
         UINT32_C(0x380b2c76),
         UINT32_C(0x404f2d81),
         UINT32_C(0x304fe873),
         UINT32_C(0x480be984),
         UINT32_C(0x284f646e),
         UINT32_C(0x500b6599)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fbc2200),
         UINT32_C(0x3f8c0046),
         UINT32_C(0x3fb02246),
         UINT32_C(0x3f882224),
         UINT32_C(0x3fb40024),
         UINT32_C(0x3f842262),
         UINT32_C(0x3fb80062),
         UINT32_C(0x3f9005d0),
         UINT32_C(0x3fac27d0),
         UINT32_C(0x3f9c0596),
         UINT32_C(0x3fa02796),
         UINT32_C(0x3f9827f4),
         UINT32_C(0x3fa405f4),
         UINT32_C(0x3f9427b2),
         UINT32_C(0x3fa805b2)},
        UINT32_C(0xfff80000),
        {0xdd,0x63,0xa5,0x3a,0x9a,0x9b,0x18,0xeb,0xf0,0x0c,
         0x73,0x50,0xb9,0x71,0x9e,0x6e,0x27,0x9e,0x31,0x4a,0x00}
    },
    {
        /* No.273 delta:1358 weight:1725 */
        11213,
        19,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xda0ac527),
         UINT32_C(0x6467f2c3),
         UINT32_C(0xbe6d37e4),
         UINT32_C(0xce701116),
         UINT32_C(0x147ad431),
         UINT32_C(0xaa17e3d5),
         UINT32_C(0x701d26f2),
         UINT32_C(0x0000b1f7),
         UINT32_C(0xda0a74d0),
         UINT32_C(0x64674334),
         UINT32_C(0xbe6d8613),
         UINT32_C(0xce70a0e1),
         UINT32_C(0x147a65c6),
         UINT32_C(0xaa175222),
         UINT32_C(0x701d9705)},
        {UINT32_C(0x00000000),
         UINT32_C(0x01746c56),
         UINT32_C(0x005ac03c),
         UINT32_C(0x012eac6a),
         UINT32_C(0x50580017),
         UINT32_C(0x512c6c41),
         UINT32_C(0x5002c02b),
         UINT32_C(0x5176ac7d),
         UINT32_C(0x002c8c18),
         UINT32_C(0x0158e04e),
         UINT32_C(0x00764c24),
         UINT32_C(0x01022072),
         UINT32_C(0x50748c0f),
         UINT32_C(0x5100e059),
         UINT32_C(0x502e4c33),
         UINT32_C(0x515a2065)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80ba36),
         UINT32_C(0x3f802d60),
         UINT32_C(0x3f809756),
         UINT32_C(0x3fa82c00),
         UINT32_C(0x3fa89636),
         UINT32_C(0x3fa80160),
         UINT32_C(0x3fa8bb56),
         UINT32_C(0x3f801646),
         UINT32_C(0x3f80ac70),
         UINT32_C(0x3f803b26),
         UINT32_C(0x3f808110),
         UINT32_C(0x3fa83a46),
         UINT32_C(0x3fa88070),
         UINT32_C(0x3fa81726),
         UINT32_C(0x3fa8ad10)},
        UINT32_C(0xfff80000),
        {0x44,0x41,0xba,0xab,0xdc,0xf8,0xf7,0xcd,0x33,0x44,
         0x35,0xe2,0x3b,0xc0,0x47,0x81,0x9e,0x05,0x22,0xd7,0x00}
    },
    {
        /* No.274 delta:1122 weight:787 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xce9bde90),
         UINT32_C(0x699bdce0),
         UINT32_C(0xa7000270),
         UINT32_C(0xa0801120),
         UINT32_C(0x6e1bcfb0),
         UINT32_C(0xc91bcdc0),
         UINT32_C(0x07801350),
         UINT32_C(0x00009101),
         UINT32_C(0xce9b4f91),
         UINT32_C(0x699b4de1),
         UINT32_C(0xa7009371),
         UINT32_C(0xa0808021),
         UINT32_C(0x6e1b5eb1),
         UINT32_C(0xc91b5cc1),
         UINT32_C(0x07808251)},
        {UINT32_C(0x00000000),
         UINT32_C(0x002ca953),
         UINT32_C(0x44104016),
         UINT32_C(0x443ce945),
         UINT32_C(0x0823099b),
         UINT32_C(0x080fa0c8),
         UINT32_C(0x4c33498d),
         UINT32_C(0x4c1fe0de),
         UINT32_C(0x0078806a),
         UINT32_C(0x00542939),
         UINT32_C(0x4468c07c),
         UINT32_C(0x4444692f),
         UINT32_C(0x085b89f1),
         UINT32_C(0x087720a2),
         UINT32_C(0x4c4bc9e7),
         UINT32_C(0x4c6760b4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801654),
         UINT32_C(0x3fa20820),
         UINT32_C(0x3fa21e74),
         UINT32_C(0x3f841184),
         UINT32_C(0x3f8407d0),
         UINT32_C(0x3fa619a4),
         UINT32_C(0x3fa60ff0),
         UINT32_C(0x3f803c40),
         UINT32_C(0x3f802a14),
         UINT32_C(0x3fa23460),
         UINT32_C(0x3fa22234),
         UINT32_C(0x3f842dc4),
         UINT32_C(0x3f843b90),
         UINT32_C(0x3fa625e4),
         UINT32_C(0x3fa633b0)},
        UINT32_C(0xfff80000),
        {0xf9,0x2c,0x8f,0xd2,0xf9,0x88,0x4d,0x07,0xb0,0xea,
         0x2d,0x5c,0xad,0xcb,0xb3,0x0d,0xd1,0x1e,0x5a,0x63,0x00}
    },
    {
        /* No.275 delta:950 weight:1249 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7e6d7d4f),
         UINT32_C(0x69588448),
         UINT32_C(0x1735f907),
         UINT32_C(0x2fd0113b),
         UINT32_C(0x51bd6c74),
         UINT32_C(0x46889573),
         UINT32_C(0x38e5e83c),
         UINT32_C(0x0000563b),
         UINT32_C(0x7e6d2b74),
         UINT32_C(0x6958d273),
         UINT32_C(0x1735af3c),
         UINT32_C(0x2fd04700),
         UINT32_C(0x51bd3a4f),
         UINT32_C(0x4688c348),
         UINT32_C(0x38e5be07)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000678d2),
         UINT32_C(0x000a29b5),
         UINT32_C(0x000c5167),
         UINT32_C(0x04011c18),
         UINT32_C(0x040764ca),
         UINT32_C(0x040b35ad),
         UINT32_C(0x040d4d7f),
         UINT32_C(0x6039981b),
         UINT32_C(0x603fe0c9),
         UINT32_C(0x6033b1ae),
         UINT32_C(0x6035c97c),
         UINT32_C(0x64388403),
         UINT32_C(0x643efcd1),
         UINT32_C(0x6432adb6),
         UINT32_C(0x6434d564)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80033c),
         UINT32_C(0x3f800514),
         UINT32_C(0x3f800628),
         UINT32_C(0x3f82008e),
         UINT32_C(0x3f8203b2),
         UINT32_C(0x3f82059a),
         UINT32_C(0x3f8206a6),
         UINT32_C(0x3fb01ccc),
         UINT32_C(0x3fb01ff0),
         UINT32_C(0x3fb019d8),
         UINT32_C(0x3fb01ae4),
         UINT32_C(0x3fb21c42),
         UINT32_C(0x3fb21f7e),
         UINT32_C(0x3fb21956),
         UINT32_C(0x3fb21a6a)},
        UINT32_C(0xfff80000),
        {0xb4,0x0a,0x68,0xbf,0x57,0xdf,0x2f,0x96,0xc5,0xfb,
         0xb2,0x72,0xaf,0x76,0x35,0xd9,0x37,0x35,0xff,0x40,0x00}
    },
    {
        /* No.276 delta:1838 weight:1567 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8b4d8ae9),
         UINT32_C(0x70653340),
         UINT32_C(0xfb28b9a9),
         UINT32_C(0x3e801148),
         UINT32_C(0xb5cd9ba1),
         UINT32_C(0x4ee52208),
         UINT32_C(0xc5a8a8e1),
         UINT32_C(0x00002645),
         UINT32_C(0x8b4dacac),
         UINT32_C(0x70651505),
         UINT32_C(0xfb289fec),
         UINT32_C(0x3e80370d),
         UINT32_C(0xb5cdbde4),
         UINT32_C(0x4ee5044d),
         UINT32_C(0xc5a88ea4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0a04137a),
         UINT32_C(0x20020411),
         UINT32_C(0x2a06176b),
         UINT32_C(0x05041cbe),
         UINT32_C(0x0f000fc4),
         UINT32_C(0x250618af),
         UINT32_C(0x2f020bd5),
         UINT32_C(0x40c60c06),
         UINT32_C(0x4ac21f7c),
         UINT32_C(0x60c40817),
         UINT32_C(0x6ac01b6d),
         UINT32_C(0x45c210b8),
         UINT32_C(0x4fc603c2),
         UINT32_C(0x65c014a9),
         UINT32_C(0x6fc407d3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f850209),
         UINT32_C(0x3f900102),
         UINT32_C(0x3f95030b),
         UINT32_C(0x3f82820e),
         UINT32_C(0x3f878007),
         UINT32_C(0x3f92830c),
         UINT32_C(0x3f978105),
         UINT32_C(0x3fa06306),
         UINT32_C(0x3fa5610f),
         UINT32_C(0x3fb06204),
         UINT32_C(0x3fb5600d),
         UINT32_C(0x3fa2e108),
         UINT32_C(0x3fa7e301),
         UINT32_C(0x3fb2e00a),
         UINT32_C(0x3fb7e203)},
        UINT32_C(0xfff80000),
        {0x94,0xe1,0x7d,0x1d,0x8d,0x35,0x00,0xf2,0x61,0x59,
         0x41,0x7c,0x87,0x05,0xa8,0xe8,0xb7,0x2b,0xfd,0x93,0x00}
    },
    {
        /* No.277 delta:1254 weight:1607 */
        11213,
        23,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd0891025),
         UINT32_C(0x727f3781),
         UINT32_C(0xa2f627a4),
         UINT32_C(0x46a0115d),
         UINT32_C(0x96290178),
         UINT32_C(0x34df26dc),
         UINT32_C(0xe45636f9),
         UINT32_C(0x00006a97),
         UINT32_C(0xd0897ab2),
         UINT32_C(0x727f5d16),
         UINT32_C(0xa2f64d33),
         UINT32_C(0x46a07bca),
         UINT32_C(0x96296bef),
         UINT32_C(0x34df4c4b),
         UINT32_C(0xe4565c6e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00456212),
         UINT32_C(0x103acf0c),
         UINT32_C(0x107fad1e),
         UINT32_C(0x000328af),
         UINT32_C(0x00464abd),
         UINT32_C(0x1039e7a3),
         UINT32_C(0x107c85b1),
         UINT32_C(0x6024c4c4),
         UINT32_C(0x6061a6d6),
         UINT32_C(0x701e0bc8),
         UINT32_C(0x705b69da),
         UINT32_C(0x6027ec6b),
         UINT32_C(0x60628e79),
         UINT32_C(0x701d2367),
         UINT32_C(0x70584175)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8022b1),
         UINT32_C(0x3f881d67),
         UINT32_C(0x3f883fd6),
         UINT32_C(0x3f800194),
         UINT32_C(0x3f802325),
         UINT32_C(0x3f881cf3),
         UINT32_C(0x3f883e42),
         UINT32_C(0x3fb01262),
         UINT32_C(0x3fb030d3),
         UINT32_C(0x3fb80f05),
         UINT32_C(0x3fb82db4),
         UINT32_C(0x3fb013f6),
         UINT32_C(0x3fb03147),
         UINT32_C(0x3fb80e91),
         UINT32_C(0x3fb82c20)},
        UINT32_C(0xfff80000),
        {0x5b,0x30,0x99,0x8d,0xb2,0x61,0xf4,0x48,0x1b,0x40,
         0x8e,0xa6,0x36,0x25,0xf0,0x06,0xce,0xc1,0x2f,0xfb,0x00}
    },
    {
        /* No.278 delta:782 weight:1549 */
        11213,
        84,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2309b04c),
         UINT32_C(0x25f485a4),
         UINT32_C(0x06fd35e8),
         UINT32_C(0xcc50116d),
         UINT32_C(0xef59a121),
         UINT32_C(0xe9a494c9),
         UINT32_C(0xcaad2485),
         UINT32_C(0x00003120),
         UINT32_C(0x2309816c),
         UINT32_C(0x25f4b484),
         UINT32_C(0x06fd04c8),
         UINT32_C(0xcc50204d),
         UINT32_C(0xef599001),
         UINT32_C(0xe9a4a5e9),
         UINT32_C(0xcaad15a5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4003f13a),
         UINT32_C(0x4006199d),
         UINT32_C(0x0005e8a7),
         UINT32_C(0x80104014),
         UINT32_C(0xc013b12e),
         UINT32_C(0xc0165989),
         UINT32_C(0x8015a8b3),
         UINT32_C(0x000280c2),
         UINT32_C(0x400171f8),
         UINT32_C(0x4004995f),
         UINT32_C(0x00076865),
         UINT32_C(0x8012c0d6),
         UINT32_C(0xc01131ec),
         UINT32_C(0xc014d94b),
         UINT32_C(0x80172871)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa001f8),
         UINT32_C(0x3fa0030c),
         UINT32_C(0x3f8002f4),
         UINT32_C(0x3fc00820),
         UINT32_C(0x3fe009d8),
         UINT32_C(0x3fe00b2c),
         UINT32_C(0x3fc00ad4),
         UINT32_C(0x3f800140),
         UINT32_C(0x3fa000b8),
         UINT32_C(0x3fa0024c),
         UINT32_C(0x3f8003b4),
         UINT32_C(0x3fc00960),
         UINT32_C(0x3fe00898),
         UINT32_C(0x3fe00a6c),
         UINT32_C(0x3fc00b94)},
        UINT32_C(0xfff80000),
        {0x98,0x6c,0x92,0x22,0xba,0x4a,0x8c,0x3f,0x27,0xbc,
         0x64,0x8e,0x0c,0x12,0xfc,0x5d,0x2e,0xb9,0x5d,0x2d,0x00}
    },
    {
        /* No.279 delta:964 weight:1583 */
        11213,
        63,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x64b5ae78),
         UINT32_C(0xddc790e6),
         UINT32_C(0xb9723e9e),
         UINT32_C(0xb280117a),
         UINT32_C(0xd635bf02),
         UINT32_C(0x6f47819c),
         UINT32_C(0x0bf22fe4),
         UINT32_C(0x0000343e),
         UINT32_C(0x64b59a46),
         UINT32_C(0xddc7a4d8),
         UINT32_C(0xb9720aa0),
         UINT32_C(0xb2802544),
         UINT32_C(0xd6358b3c),
         UINT32_C(0x6f47b5a2),
         UINT32_C(0x0bf21bda)},
        {UINT32_C(0x00000000),
         UINT32_C(0x202c40d5),
         UINT32_C(0x000214bf),
         UINT32_C(0x202e546a),
         UINT32_C(0x70182913),
         UINT32_C(0x503469c6),
         UINT32_C(0x701a3dac),
         UINT32_C(0x50367d79),
         UINT32_C(0x00002838),
         UINT32_C(0x202c68ed),
         UINT32_C(0x00023c87),
         UINT32_C(0x202e7c52),
         UINT32_C(0x7018012b),
         UINT32_C(0x503441fe),
         UINT32_C(0x701a1594),
         UINT32_C(0x50365541)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f901620),
         UINT32_C(0x3f80010a),
         UINT32_C(0x3f90172a),
         UINT32_C(0x3fb80c14),
         UINT32_C(0x3fa81a34),
         UINT32_C(0x3fb80d1e),
         UINT32_C(0x3fa81b3e),
         UINT32_C(0x3f800014),
         UINT32_C(0x3f901634),
         UINT32_C(0x3f80011e),
         UINT32_C(0x3f90173e),
         UINT32_C(0x3fb80c00),
         UINT32_C(0x3fa81a20),
         UINT32_C(0x3fb80d0a),
         UINT32_C(0x3fa81b2a)},
        UINT32_C(0xfff80000),
        {0x00,0x2b,0x78,0xb7,0x08,0x0d,0x4a,0xdd,0xda,0xb1,
         0x47,0xe7,0x4e,0xf9,0xfd,0x3f,0xcb,0xd1,0x68,0x60,0x00}
    },
    {
        /* No.280 delta:891 weight:1215 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x80f61612),
         UINT32_C(0xe0421e2f),
         UINT32_C(0x60b4083d),
         UINT32_C(0xff601181),
         UINT32_C(0x7f960793),
         UINT32_C(0x1f220fae),
         UINT32_C(0x9fd419bc),
         UINT32_C(0x0000cd04),
         UINT32_C(0x80f6db16),
         UINT32_C(0xe042d32b),
         UINT32_C(0x60b4c539),
         UINT32_C(0xff60dc85),
         UINT32_C(0x7f96ca97),
         UINT32_C(0x1f22c2aa),
         UINT32_C(0x9fd4d4b8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x200a8bfa),
         UINT32_C(0x00021119),
         UINT32_C(0x20089ae3),
         UINT32_C(0x88010051),
         UINT32_C(0xa80b8bab),
         UINT32_C(0x88031148),
         UINT32_C(0xa8099ab2),
         UINT32_C(0x0803801f),
         UINT32_C(0x28090be5),
         UINT32_C(0x08019106),
         UINT32_C(0x280b1afc),
         UINT32_C(0x8002804e),
         UINT32_C(0xa0080bb4),
         UINT32_C(0x80009157),
         UINT32_C(0xa00a1aad)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900545),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f90044d),
         UINT32_C(0x3fc40080),
         UINT32_C(0x3fd405c5),
         UINT32_C(0x3fc40188),
         UINT32_C(0x3fd404cd),
         UINT32_C(0x3f8401c0),
         UINT32_C(0x3f940485),
         UINT32_C(0x3f8400c8),
         UINT32_C(0x3f94058d),
         UINT32_C(0x3fc00140),
         UINT32_C(0x3fd00405),
         UINT32_C(0x3fc00048),
         UINT32_C(0x3fd0050d)},
        UINT32_C(0xfff80000),
        {0xe0,0x92,0x4f,0xbe,0x53,0xa9,0x47,0x7a,0x31,0x29,
         0xb2,0x7d,0xb5,0xd6,0x3c,0x0e,0x44,0x1c,0x2a,0x9f,0x00}
    },
    {
        /* No.281 delta:718 weight:1617 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd0eacbf9),
         UINT32_C(0x6f9819c7),
         UINT32_C(0xbf72d23e),
         UINT32_C(0x24301190),
         UINT32_C(0xf4dada69),
         UINT32_C(0x4ba80857),
         UINT32_C(0x9b42c3ae),
         UINT32_C(0x00003866),
         UINT32_C(0xd0eaf39f),
         UINT32_C(0x6f9821a1),
         UINT32_C(0xbf72ea58),
         UINT32_C(0x243029f6),
         UINT32_C(0xf4dae20f),
         UINT32_C(0x4ba83031),
         UINT32_C(0x9b42fbc8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x30441012),
         UINT32_C(0x2020d0e6),
         UINT32_C(0x1064c0f4),
         UINT32_C(0x0015400a),
         UINT32_C(0x30515018),
         UINT32_C(0x203590ec),
         UINT32_C(0x107180fe),
         UINT32_C(0x10063009),
         UINT32_C(0x2042201b),
         UINT32_C(0x3026e0ef),
         UINT32_C(0x0062f0fd),
         UINT32_C(0x10137003),
         UINT32_C(0x20576011),
         UINT32_C(0x3033a0e5),
         UINT32_C(0x0077b0f7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f982208),
         UINT32_C(0x3f901068),
         UINT32_C(0x3f883260),
         UINT32_C(0x3f800aa0),
         UINT32_C(0x3f9828a8),
         UINT32_C(0x3f901ac8),
         UINT32_C(0x3f8838c0),
         UINT32_C(0x3f880318),
         UINT32_C(0x3f902110),
         UINT32_C(0x3f981370),
         UINT32_C(0x3f803178),
         UINT32_C(0x3f8809b8),
         UINT32_C(0x3f902bb0),
         UINT32_C(0x3f9819d0),
         UINT32_C(0x3f803bd8)},
        UINT32_C(0xfff80000),
        {0x05,0x57,0xfa,0xe9,0xae,0x63,0x42,0x79,0x73,0x85,
         0x07,0xdd,0x6f,0xfc,0x41,0x80,0xac,0x70,0x23,0xbb,0x00}
    },
    {
        /* No.282 delta:753 weight:1359 */
        11213,
        76,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x224604fe),
         UINT32_C(0x681e2258),
         UINT32_C(0x4a5826a6),
         UINT32_C(0x148011a3),
         UINT32_C(0x36c6155d),
         UINT32_C(0x7c9e33fb),
         UINT32_C(0x5ed83705),
         UINT32_C(0x000032ce),
         UINT32_C(0x22463630),
         UINT32_C(0x681e1096),
         UINT32_C(0x4a581468),
         UINT32_C(0x1480236d),
         UINT32_C(0x36c62793),
         UINT32_C(0x7c9e0135),
         UINT32_C(0x5ed805cb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0005003e),
         UINT32_C(0x200081a5),
         UINT32_C(0x2005819b),
         UINT32_C(0x000200f4),
         UINT32_C(0x000700ca),
         UINT32_C(0x20028151),
         UINT32_C(0x2007816f),
         UINT32_C(0x3020281d),
         UINT32_C(0x30252823),
         UINT32_C(0x1020a9b8),
         UINT32_C(0x1025a986),
         UINT32_C(0x302228e9),
         UINT32_C(0x302728d7),
         UINT32_C(0x1022a94c),
         UINT32_C(0x1027a972)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800280),
         UINT32_C(0x3f900040),
         UINT32_C(0x3f9002c0),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f800380),
         UINT32_C(0x3f900140),
         UINT32_C(0x3f9003c0),
         UINT32_C(0x3f981014),
         UINT32_C(0x3f981294),
         UINT32_C(0x3f881054),
         UINT32_C(0x3f8812d4),
         UINT32_C(0x3f981114),
         UINT32_C(0x3f981394),
         UINT32_C(0x3f881154),
         UINT32_C(0x3f8813d4)},
        UINT32_C(0xfff80000),
        {0x3f,0xd5,0xce,0x0a,0x76,0x47,0x21,0x51,0xd3,0x4e,
         0xaa,0xe4,0x2a,0xed,0x46,0xa5,0x91,0xd8,0x9f,0x2f,0x00}
    },
    {
        /* No.283 delta:947 weight:1779 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xaec76b1f),
         UINT32_C(0x658b179b),
         UINT32_C(0xcb4c7c84),
         UINT32_C(0xe21011b0),
         UINT32_C(0x4cd77aaf),
         UINT32_C(0x879b062b),
         UINT32_C(0x295c6d34),
         UINT32_C(0x00006807),
         UINT32_C(0xaec70318),
         UINT32_C(0x658b7f9c),
         UINT32_C(0xcb4c1483),
         UINT32_C(0xe21079b7),
         UINT32_C(0x4cd712a8),
         UINT32_C(0x879b6e2c),
         UINT32_C(0x295c0533)},
        {UINT32_C(0x00000000),
         UINT32_C(0x003d799a),
         UINT32_C(0x4056040c),
         UINT32_C(0x406b7d96),
         UINT32_C(0x00021015),
         UINT32_C(0x003f698f),
         UINT32_C(0x40541419),
         UINT32_C(0x40696d83),
         UINT32_C(0x10503202),
         UINT32_C(0x106d4b98),
         UINT32_C(0x5006360e),
         UINT32_C(0x503b4f94),
         UINT32_C(0x10522217),
         UINT32_C(0x106f5b8d),
         UINT32_C(0x5004261b),
         UINT32_C(0x50395f81)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801ebc),
         UINT32_C(0x3fa02b02),
         UINT32_C(0x3fa035be),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f801fb4),
         UINT32_C(0x3fa02a0a),
         UINT32_C(0x3fa034b6),
         UINT32_C(0x3f882819),
         UINT32_C(0x3f8836a5),
         UINT32_C(0x3fa8031b),
         UINT32_C(0x3fa81da7),
         UINT32_C(0x3f882911),
         UINT32_C(0x3f8837ad),
         UINT32_C(0x3fa80213),
         UINT32_C(0x3fa81caf)},
        UINT32_C(0xfff80000),
        {0x2b,0x0f,0xe1,0xde,0xb8,0x2e,0x98,0xe4,0x72,0xda,
         0x9f,0xbe,0xd4,0x7e,0x12,0x72,0x2a,0xbf,0xc0,0xbd,0x00}
    },
    {
        /* No.284 delta:1490 weight:1675 */
        11213,
        16,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x619dbdb3),
         UINT32_C(0xf6a0f779),
         UINT32_C(0x973d4aca),
         UINT32_C(0x9f3011c2),
         UINT32_C(0xfeadac71),
         UINT32_C(0x6990e6bb),
         UINT32_C(0x080d5b08),
         UINT32_C(0x0000aa9b),
         UINT32_C(0x619d1728),
         UINT32_C(0xf6a05de2),
         UINT32_C(0x973de051),
         UINT32_C(0x9f30bb59),
         UINT32_C(0xfead06ea),
         UINT32_C(0x69904c20),
         UINT32_C(0x080df193)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0ec1421c),
         UINT32_C(0x1194a576),
         UINT32_C(0x1f55e76a),
         UINT32_C(0x005c0501),
         UINT32_C(0x0e9d471d),
         UINT32_C(0x11c8a077),
         UINT32_C(0x1f09e26b),
         UINT32_C(0x0106c1be),
         UINT32_C(0x0fc783a2),
         UINT32_C(0x109264c8),
         UINT32_C(0x1e5326d4),
         UINT32_C(0x015ac4bf),
         UINT32_C(0x0f9b86a3),
         UINT32_C(0x10ce61c9),
         UINT32_C(0x1e0f23d5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8760a1),
         UINT32_C(0x3f88ca52),
         UINT32_C(0x3f8faaf3),
         UINT32_C(0x3f802e02),
         UINT32_C(0x3f874ea3),
         UINT32_C(0x3f88e450),
         UINT32_C(0x3f8f84f1),
         UINT32_C(0x3f808360),
         UINT32_C(0x3f87e3c1),
         UINT32_C(0x3f884932),
         UINT32_C(0x3f8f2993),
         UINT32_C(0x3f80ad62),
         UINT32_C(0x3f87cdc3),
         UINT32_C(0x3f886730),
         UINT32_C(0x3f8f0791)},
        UINT32_C(0xfff80000),
        {0x6a,0x53,0xfa,0x26,0x33,0xa8,0x93,0x37,0xfc,0x50,
         0xa0,0xf2,0xff,0xaf,0x75,0x8f,0xcd,0x66,0xd2,0xb9,0x00}
    },
    {
        /* No.285 delta:3095 weight:661 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe7c9b0cb),
         UINT32_C(0xc5282bcc),
         UINT32_C(0x22e19b07),
         UINT32_C(0x3c1011dc),
         UINT32_C(0xdbd9a117),
         UINT32_C(0xf9383a10),
         UINT32_C(0x1ef18adb),
         UINT32_C(0x0000e809),
         UINT32_C(0xe7c958c2),
         UINT32_C(0xc528c3c5),
         UINT32_C(0x22e1730e),
         UINT32_C(0x3c10f9d5),
         UINT32_C(0xdbd9491e),
         UINT32_C(0xf938d219),
         UINT32_C(0x1ef162d2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8e5e0433),
         UINT32_C(0x24138167),
         UINT32_C(0xaa4d8554),
         UINT32_C(0xfa41240b),
         UINT32_C(0x741f2038),
         UINT32_C(0xde52a56c),
         UINT32_C(0x500ca15f),
         UINT32_C(0x4a20808e),
         UINT32_C(0xc47e84bd),
         UINT32_C(0x6e3301e9),
         UINT32_C(0xe06d05da),
         UINT32_C(0xb061a485),
         UINT32_C(0x3e3fa0b6),
         UINT32_C(0x947225e2),
         UINT32_C(0x1a2c21d1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc72f02),
         UINT32_C(0x3f9209c0),
         UINT32_C(0x3fd526c2),
         UINT32_C(0x3ffd2092),
         UINT32_C(0x3fba0f90),
         UINT32_C(0x3fef2952),
         UINT32_C(0x3fa80650),
         UINT32_C(0x3fa51040),
         UINT32_C(0x3fe23f42),
         UINT32_C(0x3fb71980),
         UINT32_C(0x3ff03682),
         UINT32_C(0x3fd830d2),
         UINT32_C(0x3f9f1fd0),
         UINT32_C(0x3fca3912),
         UINT32_C(0x3f8d1610)},
        UINT32_C(0xfff80000),
        {0x85,0x07,0x92,0x11,0xb5,0x99,0xaf,0xf3,0xd4,0x48,
         0xd2,0x4f,0xc5,0x5e,0x14,0xe7,0xbf,0x6a,0xdc,0x72,0x00}
    },
    {
        /* No.286 delta:583 weight:1681 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd114fb9b),
         UINT32_C(0x52af99ff),
         UINT32_C(0x83bb6264),
         UINT32_C(0x63d011ed),
         UINT32_C(0xb2c4ea76),
         UINT32_C(0x317f8812),
         UINT32_C(0xe06b7389),
         UINT32_C(0x0000aee3),
         UINT32_C(0xd1145578),
         UINT32_C(0x52af371c),
         UINT32_C(0x83bbcc87),
         UINT32_C(0x63d0bf0e),
         UINT32_C(0xb2c44495),
         UINT32_C(0x317f26f1),
         UINT32_C(0xe06bdd6a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400308d3),
         UINT32_C(0xa0016539),
         UINT32_C(0xe0026dea),
         UINT32_C(0x1000a99e),
         UINT32_C(0x5003a14d),
         UINT32_C(0xb001cca7),
         UINT32_C(0xf002c474),
         UINT32_C(0xc000201b),
         UINT32_C(0x800328c8),
         UINT32_C(0x60014522),
         UINT32_C(0x20024df1),
         UINT32_C(0xd0008985),
         UINT32_C(0x90038156),
         UINT32_C(0x7001ecbc),
         UINT32_C(0x3002e46f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00184),
         UINT32_C(0x3fd000b2),
         UINT32_C(0x3ff00136),
         UINT32_C(0x3f880054),
         UINT32_C(0x3fa801d0),
         UINT32_C(0x3fd800e6),
         UINT32_C(0x3ff80162),
         UINT32_C(0x3fe00010),
         UINT32_C(0x3fc00194),
         UINT32_C(0x3fb000a2),
         UINT32_C(0x3f900126),
         UINT32_C(0x3fe80044),
         UINT32_C(0x3fc801c0),
         UINT32_C(0x3fb800f6),
         UINT32_C(0x3f980172)},
        UINT32_C(0xfff80000),
        {0x59,0xc7,0x8f,0x55,0x07,0x75,0xd0,0xc9,0x26,0x6c,
         0x4f,0x0b,0xb9,0x98,0x3f,0xf3,0xa7,0x43,0x2b,0x28,0x00}
    },
    {
        /* No.287 delta:2333 weight:1651 */
        11213,
        63,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa6e6a28f),
         UINT32_C(0xcea8da4b),
         UINT32_C(0x684e78c4),
         UINT32_C(0x7e2011f5),
         UINT32_C(0xd8c6b37a),
         UINT32_C(0xb088cbbe),
         UINT32_C(0x166e6931),
         UINT32_C(0x0000594d),
         UINT32_C(0xa6e6fbc2),
         UINT32_C(0xcea88306),
         UINT32_C(0x684e2189),
         UINT32_C(0x7e2048b8),
         UINT32_C(0xd8c6ea37),
         UINT32_C(0xb08892f3),
         UINT32_C(0x166e307c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000d841a),
         UINT32_C(0x00000073),
         UINT32_C(0x000d8469),
         UINT32_C(0x01200016),
         UINT32_C(0x012d840c),
         UINT32_C(0x01200065),
         UINT32_C(0x012d847f),
         UINT32_C(0x100001a4),
         UINT32_C(0x100d85be),
         UINT32_C(0x100001d7),
         UINT32_C(0x100d85cd),
         UINT32_C(0x112001b2),
         UINT32_C(0x112d85a8),
         UINT32_C(0x112001c1),
         UINT32_C(0x112d85db)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8006c2),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f8006c2),
         UINT32_C(0x3f809000),
         UINT32_C(0x3f8096c2),
         UINT32_C(0x3f809000),
         UINT32_C(0x3f8096c2),
         UINT32_C(0x3f880000),
         UINT32_C(0x3f8806c2),
         UINT32_C(0x3f880000),
         UINT32_C(0x3f8806c2),
         UINT32_C(0x3f889000),
         UINT32_C(0x3f8896c2),
         UINT32_C(0x3f889000),
         UINT32_C(0x3f8896c2)},
        UINT32_C(0xfff80000),
        {0x95,0x93,0x90,0x58,0x58,0xc5,0xf4,0x07,0x73,0xc9,
         0x6e,0x56,0x93,0x99,0x69,0x69,0x63,0x32,0xfc,0xcd,0x00}
    },
    {
        /* No.288 delta:904 weight:1651 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9b7f9dd5),
         UINT32_C(0xb4d1a31b),
         UINT32_C(0x2fae3ece),
         UINT32_C(0x30001203),
         UINT32_C(0xab7f8fd6),
         UINT32_C(0x84d1b118),
         UINT32_C(0x1fae2ccd),
         UINT32_C(0x00005429),
         UINT32_C(0x9b7fc9fc),
         UINT32_C(0xb4d1f732),
         UINT32_C(0x2fae6ae7),
         UINT32_C(0x3000462a),
         UINT32_C(0xab7fdbff),
         UINT32_C(0x84d1e531),
         UINT32_C(0x1fae78e4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00543bfa),
         UINT32_C(0x200aa815),
         UINT32_C(0x205e93ef),
         UINT32_C(0xc0202419),
         UINT32_C(0xc0741fe3),
         UINT32_C(0xe02a8c0c),
         UINT32_C(0xe07eb7f6),
         UINT32_C(0x00036807),
         UINT32_C(0x005753fd),
         UINT32_C(0x2009c012),
         UINT32_C(0x205dfbe8),
         UINT32_C(0xc0234c1e),
         UINT32_C(0xc07777e4),
         UINT32_C(0xe029e40b),
         UINT32_C(0xe07ddff1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a1d),
         UINT32_C(0x3f900554),
         UINT32_C(0x3f902f49),
         UINT32_C(0x3fe01012),
         UINT32_C(0x3fe03a0f),
         UINT32_C(0x3ff01546),
         UINT32_C(0x3ff03f5b),
         UINT32_C(0x3f8001b4),
         UINT32_C(0x3f802ba9),
         UINT32_C(0x3f9004e0),
         UINT32_C(0x3f902efd),
         UINT32_C(0x3fe011a6),
         UINT32_C(0x3fe03bbb),
         UINT32_C(0x3ff014f2),
         UINT32_C(0x3ff03eef)},
        UINT32_C(0xfff80000),
        {0x4b,0x8d,0x51,0xbb,0x0f,0x66,0x85,0xe2,0xee,0x64,
         0xad,0xbc,0xe9,0xed,0x1c,0xf6,0xd4,0x8b,0xfc,0x06,0x00}
    },
    {
        /* No.289 delta:902 weight:1623 */
        11213,
        38,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf3d2ad48),
         UINT32_C(0x862006c8),
         UINT32_C(0x75f2ab80),
         UINT32_C(0x04e0121c),
         UINT32_C(0xf732bf54),
         UINT32_C(0x82c014d4),
         UINT32_C(0x7112b99c),
         UINT32_C(0x0000c395),
         UINT32_C(0xf3d26edd),
         UINT32_C(0x8620c55d),
         UINT32_C(0x75f26815),
         UINT32_C(0x04e0d189),
         UINT32_C(0xf7327cc1),
         UINT32_C(0x82c0d741),
         UINT32_C(0x71127a09)},
        {UINT32_C(0x00000000),
         UINT32_C(0xe80819be),
         UINT32_C(0x0046189b),
         UINT32_C(0xe84e0125),
         UINT32_C(0x0035f014),
         UINT32_C(0xe83de9aa),
         UINT32_C(0x0073e88f),
         UINT32_C(0xe87bf131),
         UINT32_C(0x00031910),
         UINT32_C(0xe80b00ae),
         UINT32_C(0x0045018b),
         UINT32_C(0xe84d1835),
         UINT32_C(0x0036e904),
         UINT32_C(0xe83ef0ba),
         UINT32_C(0x0070f19f),
         UINT32_C(0xe878e821)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff4040c),
         UINT32_C(0x3f80230c),
         UINT32_C(0x3ff42700),
         UINT32_C(0x3f801af8),
         UINT32_C(0x3ff41ef4),
         UINT32_C(0x3f8039f4),
         UINT32_C(0x3ff43df8),
         UINT32_C(0x3f80018c),
         UINT32_C(0x3ff40580),
         UINT32_C(0x3f802280),
         UINT32_C(0x3ff4268c),
         UINT32_C(0x3f801b74),
         UINT32_C(0x3ff41f78),
         UINT32_C(0x3f803878),
         UINT32_C(0x3ff43c74)},
        UINT32_C(0xfff80000),
        {0xae,0xf8,0x4a,0x6c,0xc4,0xdb,0x75,0x9f,0x35,0x59,
         0x15,0x31,0x28,0x48,0x4d,0x2a,0x4d,0x55,0xff,0x19,0x00}
    },
    {
        /* No.290 delta:944 weight:1727 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xfbcc3f05),
         UINT32_C(0x04249a13),
         UINT32_C(0xffe8a516),
         UINT32_C(0xfec0122c),
         UINT32_C(0x050c2d29),
         UINT32_C(0xfae4883f),
         UINT32_C(0x0128b73a),
         UINT32_C(0x00009b2a),
         UINT32_C(0xfbcca42f),
         UINT32_C(0x04240139),
         UINT32_C(0xffe83e3c),
         UINT32_C(0xfec08906),
         UINT32_C(0x050cb603),
         UINT32_C(0xfae41315),
         UINT32_C(0x01282c10)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0042281e),
         UINT32_C(0x20021065),
         UINT32_C(0x2040387b),
         UINT32_C(0x10001707),
         UINT32_C(0x10423f19),
         UINT32_C(0x30020762),
         UINT32_C(0x30402f7c),
         UINT32_C(0x80000156),
         UINT32_C(0x80422948),
         UINT32_C(0xa0021133),
         UINT32_C(0xa040392d),
         UINT32_C(0x90001651),
         UINT32_C(0x90423e4f),
         UINT32_C(0xb0020634),
         UINT32_C(0xb0402e2a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802114),
         UINT32_C(0x3f900108),
         UINT32_C(0x3f90201c),
         UINT32_C(0x3f88000b),
         UINT32_C(0x3f88211f),
         UINT32_C(0x3f980103),
         UINT32_C(0x3f982017),
         UINT32_C(0x3fc00000),
         UINT32_C(0x3fc02114),
         UINT32_C(0x3fd00108),
         UINT32_C(0x3fd0201c),
         UINT32_C(0x3fc8000b),
         UINT32_C(0x3fc8211f),
         UINT32_C(0x3fd80103),
         UINT32_C(0x3fd82017)},
        UINT32_C(0xfff80000),
        {0xd4,0xd6,0xb1,0x99,0x08,0xa8,0x90,0x00,0x71,0xcc,
         0xa0,0x44,0x61,0xd7,0x04,0x86,0xa4,0x9b,0xa2,0x7c,0x00}
    },
    {
        /* No.291 delta:1190 weight:1597 */
        11213,
        23,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf3b4ed24),
         UINT32_C(0xdef22bdc),
         UINT32_C(0x2d46c6f8),
         UINT32_C(0x28f01237),
         UINT32_C(0xdb44ff13),
         UINT32_C(0xf60239eb),
         UINT32_C(0x05b6d4cf),
         UINT32_C(0x00008792),
         UINT32_C(0xf3b46ab6),
         UINT32_C(0xdef2ac4e),
         UINT32_C(0x2d46416a),
         UINT32_C(0x28f095a5),
         UINT32_C(0xdb447881),
         UINT32_C(0xf602be79),
         UINT32_C(0x05b6535d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x344c0816),
         UINT32_C(0x00402d67),
         UINT32_C(0x340c2571),
         UINT32_C(0x106819d5),
         UINT32_C(0x242411c3),
         UINT32_C(0x102834b2),
         UINT32_C(0x24643ca4),
         UINT32_C(0x105d0014),
         UINT32_C(0x24110802),
         UINT32_C(0x101d2d73),
         UINT32_C(0x24512565),
         UINT32_C(0x003519c1),
         UINT32_C(0x347911d7),
         UINT32_C(0x007534a6),
         UINT32_C(0x34393cb0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9a2604),
         UINT32_C(0x3f802016),
         UINT32_C(0x3f9a0612),
         UINT32_C(0x3f88340c),
         UINT32_C(0x3f921208),
         UINT32_C(0x3f88141a),
         UINT32_C(0x3f92321e),
         UINT32_C(0x3f882e80),
         UINT32_C(0x3f920884),
         UINT32_C(0x3f880e96),
         UINT32_C(0x3f922892),
         UINT32_C(0x3f801a8c),
         UINT32_C(0x3f9a3c88),
         UINT32_C(0x3f803a9a),
         UINT32_C(0x3f9a1c9e)},
        UINT32_C(0xfff80000),
        {0x80,0x71,0x1d,0x30,0x3e,0x00,0x11,0x0a,0x22,0xba,
         0x95,0xe8,0xd9,0xde,0x23,0x06,0xd8,0x66,0x7b,0xf1,0x00}
    },
    {
        /* No.292 delta:2057 weight:1297 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x76d6388e),
         UINT32_C(0x0d4dedf7),
         UINT32_C(0x7b9bd579),
         UINT32_C(0x09d0124f),
         UINT32_C(0x7f062ac1),
         UINT32_C(0x049dffb8),
         UINT32_C(0x724bc736),
         UINT32_C(0x00004430),
         UINT32_C(0x76d67cbe),
         UINT32_C(0x0d4da9c7),
         UINT32_C(0x7b9b9149),
         UINT32_C(0x09d0567f),
         UINT32_C(0x7f066ef1),
         UINT32_C(0x049dbb88),
         UINT32_C(0x724b8306)},
        {UINT32_C(0x00000000),
         UINT32_C(0x30a50892),
         UINT32_C(0x0e304027),
         UINT32_C(0x3e9548b5),
         UINT32_C(0xf1907209),
         UINT32_C(0xc1357a9b),
         UINT32_C(0xffa0322e),
         UINT32_C(0xcf053abc),
         UINT32_C(0x402243cd),
         UINT32_C(0x70874b5f),
         UINT32_C(0x4e1203ea),
         UINT32_C(0x7eb70b78),
         UINT32_C(0xb1b231c4),
         UINT32_C(0x81173956),
         UINT32_C(0xbf8271e3),
         UINT32_C(0x8f277971)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f985284),
         UINT32_C(0x3f871820),
         UINT32_C(0x3f9f4aa4),
         UINT32_C(0x3ff8c839),
         UINT32_C(0x3fe09abd),
         UINT32_C(0x3fffd019),
         UINT32_C(0x3fe7829d),
         UINT32_C(0x3fa01121),
         UINT32_C(0x3fb843a5),
         UINT32_C(0x3fa70901),
         UINT32_C(0x3fbf5b85),
         UINT32_C(0x3fd8d918),
         UINT32_C(0x3fc08b9c),
         UINT32_C(0x3fdfc138),
         UINT32_C(0x3fc793bc)},
        UINT32_C(0xfff80000),
        {0xb8,0x0c,0x99,0x53,0x57,0x6e,0x5e,0xa5,0x36,0x91,
         0xa1,0xa1,0x4b,0xd9,0x7f,0xfc,0xb6,0x6e,0x0b,0xcd,0x00}
    },
    {
        /* No.293 delta:832 weight:693 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x14933608),
         UINT32_C(0x74422a10),
         UINT32_C(0x60d11c18),
         UINT32_C(0x5b701258),
         UINT32_C(0x4fe32450),
         UINT32_C(0x2f323848),
         UINT32_C(0x3ba10e40),
         UINT32_C(0x00008f9e),
         UINT32_C(0x1493b996),
         UINT32_C(0x7442a58e),
         UINT32_C(0x60d19386),
         UINT32_C(0x5b709dc6),
         UINT32_C(0x4fe3abce),
         UINT32_C(0x2f32b7d6),
         UINT32_C(0x3ba181de)},
        {UINT32_C(0x00000000),
         UINT32_C(0x024d06f3),
         UINT32_C(0x0042201c),
         UINT32_C(0x020f26ef),
         UINT32_C(0x6078100e),
         UINT32_C(0x623516fd),
         UINT32_C(0x603a3012),
         UINT32_C(0x627736e1),
         UINT32_C(0x201041f7),
         UINT32_C(0x225d4704),
         UINT32_C(0x205261eb),
         UINT32_C(0x221f6718),
         UINT32_C(0x406851f9),
         UINT32_C(0x4225570a),
         UINT32_C(0x402a71e5),
         UINT32_C(0x42677716)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f812683),
         UINT32_C(0x3f802110),
         UINT32_C(0x3f810793),
         UINT32_C(0x3fb03c08),
         UINT32_C(0x3fb11a8b),
         UINT32_C(0x3fb01d18),
         UINT32_C(0x3fb13b9b),
         UINT32_C(0x3f900820),
         UINT32_C(0x3f912ea3),
         UINT32_C(0x3f902930),
         UINT32_C(0x3f910fb3),
         UINT32_C(0x3fa03428),
         UINT32_C(0x3fa112ab),
         UINT32_C(0x3fa01538),
         UINT32_C(0x3fa133bb)},
        UINT32_C(0xfff80000),
        {0x59,0x1e,0x1b,0x5c,0xdd,0x6e,0x9b,0x3c,0x61,0xef,
         0x52,0x51,0x06,0x7d,0x37,0x69,0xbc,0x02,0x4e,0xae,0x00}
    },
    {
        /* No.294 delta:1075 weight:1641 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd240a087),
         UINT32_C(0x0d7c4b77),
         UINT32_C(0xdf3cebf0),
         UINT32_C(0x9200126c),
         UINT32_C(0x4040b2eb),
         UINT32_C(0x9f7c591b),
         UINT32_C(0x4d3cf99c),
         UINT32_C(0x0000e34c),
         UINT32_C(0xd24043cb),
         UINT32_C(0x0d7ca83b),
         UINT32_C(0xdf3c08bc),
         UINT32_C(0x9200f120),
         UINT32_C(0x404051a7),
         UINT32_C(0x9f7cba57),
         UINT32_C(0x4d3c1ad0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004054da),
         UINT32_C(0x4003013f),
         UINT32_C(0x404355e5),
         UINT32_C(0x0167684d),
         UINT32_C(0x01273c97),
         UINT32_C(0x41646972),
         UINT32_C(0x41243da8),
         UINT32_C(0x203cb990),
         UINT32_C(0x207ced4a),
         UINT32_C(0x603fb8af),
         UINT32_C(0x607fec75),
         UINT32_C(0x215bd1dd),
         UINT32_C(0x211b8507),
         UINT32_C(0x6158d0e2),
         UINT32_C(0x61188438)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80202a),
         UINT32_C(0x3fa00180),
         UINT32_C(0x3fa021aa),
         UINT32_C(0x3f80b3b4),
         UINT32_C(0x3f80939e),
         UINT32_C(0x3fa0b234),
         UINT32_C(0x3fa0921e),
         UINT32_C(0x3f901e5c),
         UINT32_C(0x3f903e76),
         UINT32_C(0x3fb01fdc),
         UINT32_C(0x3fb03ff6),
         UINT32_C(0x3f90ade8),
         UINT32_C(0x3f908dc2),
         UINT32_C(0x3fb0ac68),
         UINT32_C(0x3fb08c42)},
        UINT32_C(0xfff80000),
        {0xc0,0xfa,0x1f,0x55,0x3f,0xba,0x1f,0x2b,0xbe,0x72,
         0x99,0x33,0x7d,0x40,0xd0,0x51,0x33,0x34,0x9c,0xf4,0x00}
    },
    {
        /* No.295 delta:1186 weight:1657 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc7df60ac),
         UINT32_C(0x6a1ad971),
         UINT32_C(0xadc5b9dd),
         UINT32_C(0x76c01270),
         UINT32_C(0xb11f72dc),
         UINT32_C(0x1cdacb01),
         UINT32_C(0xdb05abad),
         UINT32_C(0x000085a7),
         UINT32_C(0xc7dfe50b),
         UINT32_C(0x6a1a5cd6),
         UINT32_C(0xadc53c7a),
         UINT32_C(0x76c097d7),
         UINT32_C(0xb11ff77b),
         UINT32_C(0x1cda4ea6),
         UINT32_C(0xdb052e0a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00055956),
         UINT32_C(0x00027175),
         UINT32_C(0x00072823),
         UINT32_C(0x3078c818),
         UINT32_C(0x307d914e),
         UINT32_C(0x307ab96d),
         UINT32_C(0x307fe03b),
         UINT32_C(0x0040001d),
         UINT32_C(0x0045594b),
         UINT32_C(0x00427168),
         UINT32_C(0x0047283e),
         UINT32_C(0x3038c805),
         UINT32_C(0x303d9153),
         UINT32_C(0x303ab970),
         UINT32_C(0x303fe026)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8002ac),
         UINT32_C(0x3f800138),
         UINT32_C(0x3f800394),
         UINT32_C(0x3f983c64),
         UINT32_C(0x3f983ec8),
         UINT32_C(0x3f983d5c),
         UINT32_C(0x3f983ff0),
         UINT32_C(0x3f802000),
         UINT32_C(0x3f8022ac),
         UINT32_C(0x3f802138),
         UINT32_C(0x3f802394),
         UINT32_C(0x3f981c64),
         UINT32_C(0x3f981ec8),
         UINT32_C(0x3f981d5c),
         UINT32_C(0x3f981ff0)},
        UINT32_C(0xfff80000),
        {0xd3,0xe7,0x86,0x9b,0xe3,0x0a,0x21,0x7d,0x7d,0x27,
         0x36,0x03,0x1d,0x93,0xef,0xe6,0x00,0x1e,0xd7,0xd0,0x00}
    },
    {
        /* No.296 delta:1412 weight:1597 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x23b04c56),
         UINT32_C(0x4d815b5f),
         UINT32_C(0x6e311709),
         UINT32_C(0x40f0128b),
         UINT32_C(0x63405edd),
         UINT32_C(0x0d7149d4),
         UINT32_C(0x2ec10582),
         UINT32_C(0x00002283),
         UINT32_C(0x23b06ed5),
         UINT32_C(0x4d8179dc),
         UINT32_C(0x6e31358a),
         UINT32_C(0x40f03008),
         UINT32_C(0x63407c5e),
         UINT32_C(0x0d716b57),
         UINT32_C(0x2ec12701)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5084d83e),
         UINT32_C(0x007c401c),
         UINT32_C(0x50f89822),
         UINT32_C(0x40030dba),
         UINT32_C(0x1087d584),
         UINT32_C(0x407f4da6),
         UINT32_C(0x10fb9598),
         UINT32_C(0x40004919),
         UINT32_C(0x10849127),
         UINT32_C(0x407c0905),
         UINT32_C(0x10f8d13b),
         UINT32_C(0x000344a3),
         UINT32_C(0x50879c9d),
         UINT32_C(0x007f04bf),
         UINT32_C(0x50fbdc81)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa8426c),
         UINT32_C(0x3f803e20),
         UINT32_C(0x3fa87c4c),
         UINT32_C(0x3fa00186),
         UINT32_C(0x3f8843ea),
         UINT32_C(0x3fa03fa6),
         UINT32_C(0x3f887dca),
         UINT32_C(0x3fa00024),
         UINT32_C(0x3f884248),
         UINT32_C(0x3fa03e04),
         UINT32_C(0x3f887c68),
         UINT32_C(0x3f8001a2),
         UINT32_C(0x3fa843ce),
         UINT32_C(0x3f803f82),
         UINT32_C(0x3fa87dee)},
        UINT32_C(0xfff80000),
        {0x92,0x7d,0x94,0x21,0x4b,0x3a,0x32,0x48,0xf6,0x7a,
         0x9a,0xec,0xd7,0xb6,0x56,0xfc,0xc9,0x34,0x67,0xb1,0x00}
    },
    {
        /* No.297 delta:763 weight:1457 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb7a54f1e),
         UINT32_C(0xa71f8dd6),
         UINT32_C(0x10bac2c8),
         UINT32_C(0x1ba01298),
         UINT32_C(0xac055d86),
         UINT32_C(0xbcbf9f4e),
         UINT32_C(0x0b1ad050),
         UINT32_C(0x0000142d),
         UINT32_C(0xb7a55b33),
         UINT32_C(0xa71f99fb),
         UINT32_C(0x10bad6e5),
         UINT32_C(0x1ba006b5),
         UINT32_C(0xac0549ab),
         UINT32_C(0xbcbf8b63),
         UINT32_C(0x0b1ac47d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x58680016),
         UINT32_C(0x20711899),
         UINT32_C(0x7819188f),
         UINT32_C(0x105cce7c),
         UINT32_C(0x4834ce6a),
         UINT32_C(0x302dd6e5),
         UINT32_C(0x6845d6f3),
         UINT32_C(0x006a187a),
         UINT32_C(0x5802186c),
         UINT32_C(0x201b00e3),
         UINT32_C(0x787300f5),
         UINT32_C(0x1036d606),
         UINT32_C(0x485ed610),
         UINT32_C(0x3047ce9f),
         UINT32_C(0x682fce89)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fac3400),
         UINT32_C(0x3f90388c),
         UINT32_C(0x3fbc0c8c),
         UINT32_C(0x3f882e67),
         UINT32_C(0x3fa41a67),
         UINT32_C(0x3f9816eb),
         UINT32_C(0x3fb422eb),
         UINT32_C(0x3f80350c),
         UINT32_C(0x3fac010c),
         UINT32_C(0x3f900d80),
         UINT32_C(0x3fbc3980),
         UINT32_C(0x3f881b6b),
         UINT32_C(0x3fa42f6b),
         UINT32_C(0x3f9823e7),
         UINT32_C(0x3fb417e7)},
        UINT32_C(0xfff80000),
        {0x93,0xe2,0xc7,0x95,0xfa,0x46,0xe7,0xb4,0x33,0x62,
         0xbc,0x1b,0xa4,0x2a,0x04,0x02,0x8b,0xdd,0x23,0x94,0x00}
    },
    {
        /* No.298 delta:967 weight:1527 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb982e373),
         UINT32_C(0xc724b811),
         UINT32_C(0x7ea65b62),
         UINT32_C(0x87c012ac),
         UINT32_C(0x3e42f1df),
         UINT32_C(0x40e4aabd),
         UINT32_C(0xf96649ce),
         UINT32_C(0x00003985),
         UINT32_C(0xb982daf6),
         UINT32_C(0xc7248194),
         UINT32_C(0x7ea662e7),
         UINT32_C(0x87c02b29),
         UINT32_C(0x3e42c85a),
         UINT32_C(0x40e49338),
         UINT32_C(0xf966704b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0842bb3a),
         UINT32_C(0x1002e6c3),
         UINT32_C(0x18405df9),
         UINT32_C(0x0000409e),
         UINT32_C(0x0842fba4),
         UINT32_C(0x1002a65d),
         UINT32_C(0x18401d67),
         UINT32_C(0x2001801b),
         UINT32_C(0x28433b21),
         UINT32_C(0x300366d8),
         UINT32_C(0x3841dde2),
         UINT32_C(0x2001c085),
         UINT32_C(0x28437bbf),
         UINT32_C(0x30032646),
         UINT32_C(0x38419d7c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f84215d),
         UINT32_C(0x3f880173),
         UINT32_C(0x3f8c202e),
         UINT32_C(0x3f800020),
         UINT32_C(0x3f84217d),
         UINT32_C(0x3f880153),
         UINT32_C(0x3f8c200e),
         UINT32_C(0x3f9000c0),
         UINT32_C(0x3f94219d),
         UINT32_C(0x3f9801b3),
         UINT32_C(0x3f9c20ee),
         UINT32_C(0x3f9000e0),
         UINT32_C(0x3f9421bd),
         UINT32_C(0x3f980193),
         UINT32_C(0x3f9c20ce)},
        UINT32_C(0xfff80000),
        {0x83,0x91,0x32,0xcf,0x3d,0x1d,0x50,0x21,0x0f,0x8f,
         0x38,0x19,0x7c,0x4a,0x0d,0xb5,0xfd,0x7d,0x82,0xf3,0x00}
    },
    {
        /* No.299 delta:962 weight:1567 */
        11213,
        38,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc27cca59),
         UINT32_C(0x4c189d3f),
         UINT32_C(0x8e645766),
         UINT32_C(0x150012be),
         UINT32_C(0xd77cd8e7),
         UINT32_C(0x59188f81),
         UINT32_C(0x9b6445d8),
         UINT32_C(0x0000c223),
         UINT32_C(0xc27c087a),
         UINT32_C(0x4c185f1c),
         UINT32_C(0x8e649545),
         UINT32_C(0x1500d09d),
         UINT32_C(0xd77c1ac4),
         UINT32_C(0x59184da2),
         UINT32_C(0x9b6487fb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x302f041e),
         UINT32_C(0x30402c73),
         UINT32_C(0x006f286d),
         UINT32_C(0x00020df6),
         UINT32_C(0x302d09e8),
         UINT32_C(0x30422185),
         UINT32_C(0x006d259b),
         UINT32_C(0x103d240c),
         UINT32_C(0x20122012),
         UINT32_C(0x207d087f),
         UINT32_C(0x10520c61),
         UINT32_C(0x103f29fa),
         UINT32_C(0x20102de4),
         UINT32_C(0x207f0589),
         UINT32_C(0x10500197)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f981782),
         UINT32_C(0x3f982016),
         UINT32_C(0x3f803794),
         UINT32_C(0x3f800106),
         UINT32_C(0x3f981684),
         UINT32_C(0x3f982110),
         UINT32_C(0x3f803692),
         UINT32_C(0x3f881e92),
         UINT32_C(0x3f900910),
         UINT32_C(0x3f903e84),
         UINT32_C(0x3f882906),
         UINT32_C(0x3f881f94),
         UINT32_C(0x3f900816),
         UINT32_C(0x3f903f82),
         UINT32_C(0x3f882800)},
        UINT32_C(0xfff80000),
        {0x47,0xce,0x43,0x26,0xfa,0xae,0x02,0x83,0x8f,0x1b,
         0x8f,0x36,0xea,0x52,0x53,0x47,0x2a,0x67,0xd8,0x6a,0x00}
    },
    {
        /* No.300 delta:1760 weight:1591 */
        11213,
        19,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3f026d07),
         UINT32_C(0x19579ecc),
         UINT32_C(0x2655f3cb),
         UINT32_C(0xacd012c9),
         UINT32_C(0x93d27fce),
         UINT32_C(0xb5878c05),
         UINT32_C(0x8a85e102),
         UINT32_C(0x0000ef47),
         UINT32_C(0x3f028240),
         UINT32_C(0x1957718b),
         UINT32_C(0x26551c8c),
         UINT32_C(0xacd0fd8e),
         UINT32_C(0x93d29089),
         UINT32_C(0xb5876342),
         UINT32_C(0x8a850e45)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2069c1ba),
         UINT32_C(0x401c61ee),
         UINT32_C(0x6075a054),
         UINT32_C(0x000a0195),
         UINT32_C(0x2063c02f),
         UINT32_C(0x4016607b),
         UINT32_C(0x607fa1c1),
         UINT32_C(0x60010186),
         UINT32_C(0x4068c03c),
         UINT32_C(0x201d6068),
         UINT32_C(0x0074a1d2),
         UINT32_C(0x600b0013),
         UINT32_C(0x4062c1a9),
         UINT32_C(0x201761fd),
         UINT32_C(0x007ea047)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9034e0),
         UINT32_C(0x3fa00e30),
         UINT32_C(0x3fb03ad0),
         UINT32_C(0x3f800500),
         UINT32_C(0x3f9031e0),
         UINT32_C(0x3fa00b30),
         UINT32_C(0x3fb03fd0),
         UINT32_C(0x3fb00080),
         UINT32_C(0x3fa03460),
         UINT32_C(0x3f900eb0),
         UINT32_C(0x3f803a50),
         UINT32_C(0x3fb00580),
         UINT32_C(0x3fa03160),
         UINT32_C(0x3f900bb0),
         UINT32_C(0x3f803f50)},
        UINT32_C(0xfff80000),
        {0x1d,0x00,0x02,0x17,0x1b,0x97,0xf7,0x0a,0xa3,0xe8,
         0x85,0x28,0x9a,0x23,0xda,0xb4,0x36,0x75,0x8e,0x11,0x00}
    },
    {
        /* No.301 delta:1047 weight:1545 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd43bf17f),
         UINT32_C(0xe7f5581a),
         UINT32_C(0x33cea965),
         UINT32_C(0x2c1012d5),
         UINT32_C(0xf82be3aa),
         UINT32_C(0xcbe54acf),
         UINT32_C(0x1fdebbb0),
         UINT32_C(0x00006475),
         UINT32_C(0xd43b950a),
         UINT32_C(0xe7f53c6f),
         UINT32_C(0x33cecd10),
         UINT32_C(0x2c1076a0),
         UINT32_C(0xf82b87df),
         UINT32_C(0xcbe52eba),
         UINT32_C(0x1fdedfc5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x457f8936),
         UINT32_C(0x04112862),
         UINT32_C(0x416ea154),
         UINT32_C(0x000241db),
         UINT32_C(0x457dc8ed),
         UINT32_C(0x041369b9),
         UINT32_C(0x416ce08f),
         UINT32_C(0x0003e112),
         UINT32_C(0x457c6824),
         UINT32_C(0x0412c970),
         UINT32_C(0x416d4046),
         UINT32_C(0x0001a0c9),
         UINT32_C(0x457e29ff),
         UINT32_C(0x041088ab),
         UINT32_C(0x416f019d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa2bfc4),
         UINT32_C(0x3f820894),
         UINT32_C(0x3fa0b750),
         UINT32_C(0x3f800120),
         UINT32_C(0x3fa2bee4),
         UINT32_C(0x3f8209b4),
         UINT32_C(0x3fa0b670),
         UINT32_C(0x3f8001f0),
         UINT32_C(0x3fa2be34),
         UINT32_C(0x3f820964),
         UINT32_C(0x3fa0b6a0),
         UINT32_C(0x3f8000d0),
         UINT32_C(0x3fa2bf14),
         UINT32_C(0x3f820844),
         UINT32_C(0x3fa0b780)},
        UINT32_C(0xfff80000),
        {0x75,0x8c,0xb1,0x8e,0x7c,0x9b,0xdd,0xca,0xc7,0x29,
         0xc4,0xe2,0x01,0x90,0x5c,0x6b,0xbf,0x62,0xa1,0xc0,0x00}
    },
    {
        /* No.302 delta:890 weight:1167 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x018e6586),
         UINT32_C(0x580ecd60),
         UINT32_C(0x5980a8e6),
         UINT32_C(0xc71012e8),
         UINT32_C(0xc69e776e),
         UINT32_C(0x9f1edf88),
         UINT32_C(0x9e90ba0e),
         UINT32_C(0x0000d017),
         UINT32_C(0x018eb591),
         UINT32_C(0x580e1d77),
         UINT32_C(0x598078f1),
         UINT32_C(0xc710c2ff),
         UINT32_C(0xc69ea779),
         UINT32_C(0x9f1e0f9f),
         UINT32_C(0x9e906a19)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004729d5),
         UINT32_C(0x00011011),
         UINT32_C(0x004639c4),
         UINT32_C(0x8202309a),
         UINT32_C(0x8245194f),
         UINT32_C(0x8203208b),
         UINT32_C(0x8244095e),
         UINT32_C(0x50020409),
         UINT32_C(0x50452ddc),
         UINT32_C(0x50031418),
         UINT32_C(0x50443dcd),
         UINT32_C(0xd2003493),
         UINT32_C(0xd2471d46),
         UINT32_C(0xd2012482),
         UINT32_C(0xd2460d57)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802394),
         UINT32_C(0x3f800088),
         UINT32_C(0x3f80231c),
         UINT32_C(0x3fc10118),
         UINT32_C(0x3fc1228c),
         UINT32_C(0x3fc10190),
         UINT32_C(0x3fc12204),
         UINT32_C(0x3fa80102),
         UINT32_C(0x3fa82296),
         UINT32_C(0x3fa8018a),
         UINT32_C(0x3fa8221e),
         UINT32_C(0x3fe9001a),
         UINT32_C(0x3fe9238e),
         UINT32_C(0x3fe90092),
         UINT32_C(0x3fe92306)},
        UINT32_C(0xfff80000),
        {0x0c,0x95,0xf2,0x1f,0x1c,0x57,0x62,0x5a,0xbe,0xa0,
         0x3b,0xf3,0xa3,0xd9,0xb9,0x39,0x25,0x5a,0x07,0x95,0x00}
    },
    {
        /* No.303 delta:1427 weight:1213 */
        11213,
        40,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1456d307),
         UINT32_C(0x08679ffe),
         UINT32_C(0x1c314cf9),
         UINT32_C(0xfe0012fd),
         UINT32_C(0xea56c1fa),
         UINT32_C(0xf6678d03),
         UINT32_C(0xe2315e04),
         UINT32_C(0x0000b8b5),
         UINT32_C(0x14566bb2),
         UINT32_C(0x0867274b),
         UINT32_C(0x1c31f44c),
         UINT32_C(0xfe00aa48),
         UINT32_C(0xea56794f),
         UINT32_C(0xf66735b6),
         UINT32_C(0xe231e6b1)},
        {UINT32_C(0x00000000),
         UINT32_C(0x204c0072),
         UINT32_C(0x203001b1),
         UINT32_C(0x007c01c3),
         UINT32_C(0x0003008d),
         UINT32_C(0x204f00ff),
         UINT32_C(0x2033013c),
         UINT32_C(0x007f014e),
         UINT32_C(0x00120018),
         UINT32_C(0x205e006a),
         UINT32_C(0x202201a9),
         UINT32_C(0x006e01db),
         UINT32_C(0x00110095),
         UINT32_C(0x205d00e7),
         UINT32_C(0x20210124),
         UINT32_C(0x006d0156)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902600),
         UINT32_C(0x3f901800),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f902780),
         UINT32_C(0x3f901980),
         UINT32_C(0x3f803f80),
         UINT32_C(0x3f800900),
         UINT32_C(0x3f902f00),
         UINT32_C(0x3f901100),
         UINT32_C(0x3f803700),
         UINT32_C(0x3f800880),
         UINT32_C(0x3f902e80),
         UINT32_C(0x3f901080),
         UINT32_C(0x3f803680)},
        UINT32_C(0xfff80000),
        {0x9c,0xbd,0x22,0x1a,0xd8,0x36,0xbc,0xc1,0x67,0x4b,
         0xed,0xae,0x29,0x91,0x71,0xed,0x8c,0xc3,0xf2,0x02,0x00}
    },
    {
        /* No.304 delta:1858 weight:1583 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2e925e9d),
         UINT32_C(0x11274489),
         UINT32_C(0x3fb51a14),
         UINT32_C(0x7250130c),
         UINT32_C(0x5cc24d91),
         UINT32_C(0x63775785),
         UINT32_C(0x4de50918),
         UINT32_C(0x00000a61),
         UINT32_C(0x2e9254fc),
         UINT32_C(0x11274ee8),
         UINT32_C(0x3fb51075),
         UINT32_C(0x7250196d),
         UINT32_C(0x5cc247f0),
         UINT32_C(0x63775de4),
         UINT32_C(0x4de50379)},
        {UINT32_C(0x00000000),
         UINT32_C(0x088d213e),
         UINT32_C(0x1642c1bd),
         UINT32_C(0x1ecfe083),
         UINT32_C(0x0441f115),
         UINT32_C(0x0cccd02b),
         UINT32_C(0x120330a8),
         UINT32_C(0x1a8e1196),
         UINT32_C(0x084aa014),
         UINT32_C(0x00c7812a),
         UINT32_C(0x1e0861a9),
         UINT32_C(0x16854097),
         UINT32_C(0x0c0b5101),
         UINT32_C(0x0486703f),
         UINT32_C(0x1a4990bc),
         UINT32_C(0x12c4b182)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f844690),
         UINT32_C(0x3f8b2160),
         UINT32_C(0x3f8f67f0),
         UINT32_C(0x3f8220f8),
         UINT32_C(0x3f866668),
         UINT32_C(0x3f890198),
         UINT32_C(0x3f8d4708),
         UINT32_C(0x3f842550),
         UINT32_C(0x3f8063c0),
         UINT32_C(0x3f8f0430),
         UINT32_C(0x3f8b42a0),
         UINT32_C(0x3f8605a8),
         UINT32_C(0x3f824338),
         UINT32_C(0x3f8d24c8),
         UINT32_C(0x3f896258)},
        UINT32_C(0xfff80000),
        {0xc8,0xb0,0x37,0xab,0x1e,0x72,0x05,0x42,0xc1,0xa1,
         0xea,0xa1,0x70,0x0c,0x00,0x43,0x64,0x93,0x35,0xbb,0x00}
    },
    {
        /* No.305 delta:802 weight:1487 */
        11213,
        47,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xcbc49a4f),
         UINT32_C(0xeb3fc8c9),
         UINT32_C(0x20fb5286),
         UINT32_C(0x89b0131b),
         UINT32_C(0x42748954),
         UINT32_C(0x628fdbd2),
         UINT32_C(0xa94b419d),
         UINT32_C(0x0000db70),
         UINT32_C(0xcbc4413f),
         UINT32_C(0xeb3f13b9),
         UINT32_C(0x20fb89f6),
         UINT32_C(0x89b0c86b),
         UINT32_C(0x42745224),
         UINT32_C(0x628f00a2),
         UINT32_C(0xa94b9aed)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4c3e591a),
         UINT32_C(0x4401a331),
         UINT32_C(0x083ffa2b),
         UINT32_C(0x10024e57),
         UINT32_C(0x5c3c174d),
         UINT32_C(0x5403ed66),
         UINT32_C(0x183db47c),
         UINT32_C(0x10011203),
         UINT32_C(0x5c3f4b19),
         UINT32_C(0x5400b132),
         UINT32_C(0x183ee828),
         UINT32_C(0x00035c54),
         UINT32_C(0x4c3d054e),
         UINT32_C(0x4402ff65),
         UINT32_C(0x083ca67f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa61f2c),
         UINT32_C(0x3fa200d1),
         UINT32_C(0x3f841ffd),
         UINT32_C(0x3f880127),
         UINT32_C(0x3fae1e0b),
         UINT32_C(0x3faa01f6),
         UINT32_C(0x3f8c1eda),
         UINT32_C(0x3f880089),
         UINT32_C(0x3fae1fa5),
         UINT32_C(0x3faa0058),
         UINT32_C(0x3f8c1f74),
         UINT32_C(0x3f8001ae),
         UINT32_C(0x3fa61e82),
         UINT32_C(0x3fa2017f),
         UINT32_C(0x3f841e53)},
        UINT32_C(0xfff80000),
        {0x8a,0xf2,0x95,0xa2,0x6a,0xf2,0xd1,0x1e,0x6e,0xce,
         0x7a,0x6c,0x06,0xd0,0x5a,0x97,0x8f,0xfc,0x55,0x9b,0x00}
    },
    {
        /* No.306 delta:2270 weight:1221 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0ffdf430),
         UINT32_C(0x9805d495),
         UINT32_C(0x97f820a5),
         UINT32_C(0x34d01329),
         UINT32_C(0x3b2de719),
         UINT32_C(0xacd5c7bc),
         UINT32_C(0xa328338c),
         UINT32_C(0x0000cf90),
         UINT32_C(0x0ffd3ba0),
         UINT32_C(0x98051b05),
         UINT32_C(0x97f8ef35),
         UINT32_C(0x34d0dcb9),
         UINT32_C(0x3b2d2889),
         UINT32_C(0xacd5082c),
         UINT32_C(0xa328fc1c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x38481ade),
         UINT32_C(0x0a0007ed),
         UINT32_C(0x32481d33),
         UINT32_C(0x10216f15),
         UINT32_C(0x286975cb),
         UINT32_C(0x1a2168f8),
         UINT32_C(0x22697226),
         UINT32_C(0x7048ac12),
         UINT32_C(0x4800b6cc),
         UINT32_C(0x7a48abff),
         UINT32_C(0x4200b121),
         UINT32_C(0x6069c307),
         UINT32_C(0x5821d9d9),
         UINT32_C(0x6a69c4ea),
         UINT32_C(0x5221de34)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9c240d),
         UINT32_C(0x3f850003),
         UINT32_C(0x3f99240e),
         UINT32_C(0x3f8810b7),
         UINT32_C(0x3f9434ba),
         UINT32_C(0x3f8d10b4),
         UINT32_C(0x3f9134b9),
         UINT32_C(0x3fb82456),
         UINT32_C(0x3fa4005b),
         UINT32_C(0x3fbd2455),
         UINT32_C(0x3fa10058),
         UINT32_C(0x3fb034e1),
         UINT32_C(0x3fac10ec),
         UINT32_C(0x3fb534e2),
         UINT32_C(0x3fa910ef)},
        UINT32_C(0xfff80000),
        {0xa3,0x6a,0xa6,0x01,0x38,0x7b,0xcc,0x4b,0xb3,0x80,
         0x46,0xcb,0x97,0x62,0xc4,0x0b,0x6d,0x5b,0x89,0x37,0x00}
    },
    {
        /* No.307 delta:795 weight:1601 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9c198fc0),
         UINT32_C(0x58693458),
         UINT32_C(0xc470bb98),
         UINT32_C(0x23d01337),
         UINT32_C(0xbfc99cf7),
         UINT32_C(0x7bb9276f),
         UINT32_C(0xe7a0a8af),
         UINT32_C(0x0000bc9d),
         UINT32_C(0x9c19335d),
         UINT32_C(0x586988c5),
         UINT32_C(0xc4700705),
         UINT32_C(0x23d0afaa),
         UINT32_C(0xbfc9206a),
         UINT32_C(0x7bb99bf2),
         UINT32_C(0xe7a01432)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0435a092),
         UINT32_C(0x80702809),
         UINT32_C(0x8445889b),
         UINT32_C(0x0020a816),
         UINT32_C(0x04150884),
         UINT32_C(0x8050801f),
         UINT32_C(0x8465208d),
         UINT32_C(0x0042900e),
         UINT32_C(0x0477309c),
         UINT32_C(0x8032b807),
         UINT32_C(0x84071895),
         UINT32_C(0x00623818),
         UINT32_C(0x0457988a),
         UINT32_C(0x80121011),
         UINT32_C(0x8427b083)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f821ad0),
         UINT32_C(0x3fc03814),
         UINT32_C(0x3fc222c4),
         UINT32_C(0x3f801054),
         UINT32_C(0x3f820a84),
         UINT32_C(0x3fc02840),
         UINT32_C(0x3fc23290),
         UINT32_C(0x3f802148),
         UINT32_C(0x3f823b98),
         UINT32_C(0x3fc0195c),
         UINT32_C(0x3fc2038c),
         UINT32_C(0x3f80311c),
         UINT32_C(0x3f822bcc),
         UINT32_C(0x3fc00908),
         UINT32_C(0x3fc213d8)},
        UINT32_C(0xfff80000),
        {0x19,0xa6,0x69,0x4d,0x2e,0x6e,0xce,0x8b,0xca,0x9f,
         0xd0,0x79,0xfd,0xc0,0xfd,0x13,0xdc,0xec,0xe8,0x20,0x00}
    },
    {
        /* No.308 delta:590 weight:1743 */
        11213,
        77,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8227645c),
         UINT32_C(0x754c4fdb),
         UINT32_C(0xf76b2b87),
         UINT32_C(0xf780134e),
         UINT32_C(0x75a77712),
         UINT32_C(0x82cc5c95),
         UINT32_C(0x00eb38c9),
         UINT32_C(0x00005db0),
         UINT32_C(0x822739ec),
         UINT32_C(0x754c126b),
         UINT32_C(0xf76b7637),
         UINT32_C(0xf7804efe),
         UINT32_C(0x75a72aa2),
         UINT32_C(0x82cc0125),
         UINT32_C(0x00eb6579)},
        {UINT32_C(0x00000000),
         UINT32_C(0x7002a21b),
         UINT32_C(0xa0000416),
         UINT32_C(0xd002a60d),
         UINT32_C(0x40018172),
         UINT32_C(0x30032369),
         UINT32_C(0xe0018564),
         UINT32_C(0x9003277f),
         UINT32_C(0x0002101a),
         UINT32_C(0x7000b201),
         UINT32_C(0xa002140c),
         UINT32_C(0xd000b617),
         UINT32_C(0x40039168),
         UINT32_C(0x30013373),
         UINT32_C(0xe003957e),
         UINT32_C(0x90013765)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb80151),
         UINT32_C(0x3fd00002),
         UINT32_C(0x3fe80153),
         UINT32_C(0x3fa000c0),
         UINT32_C(0x3f980191),
         UINT32_C(0x3ff000c2),
         UINT32_C(0x3fc80193),
         UINT32_C(0x3f800108),
         UINT32_C(0x3fb80059),
         UINT32_C(0x3fd0010a),
         UINT32_C(0x3fe8005b),
         UINT32_C(0x3fa001c8),
         UINT32_C(0x3f980099),
         UINT32_C(0x3ff001ca),
         UINT32_C(0x3fc8009b)},
        UINT32_C(0xfff80000),
        {0x24,0xbe,0xf6,0x8b,0xa2,0x9e,0xd6,0x87,0x4b,0xbe,
         0x7d,0xa5,0x0d,0xe7,0x79,0x1e,0x9a,0x6b,0xbf,0x73,0x00}
    },
    {
        /* No.309 delta:873 weight:1579 */
        11213,
        41,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8b01278d),
         UINT32_C(0x28979c3d),
         UINT32_C(0xa396bbb0),
         UINT32_C(0x4b50135d),
         UINT32_C(0xc05134d0),
         UINT32_C(0x63c78f60),
         UINT32_C(0xe8c6a8ed),
         UINT32_C(0x0000d66c),
         UINT32_C(0x8b01f1e1),
         UINT32_C(0x28974a51),
         UINT32_C(0xa3966ddc),
         UINT32_C(0x4b50c531),
         UINT32_C(0xc051e2bc),
         UINT32_C(0x63c7590c),
         UINT32_C(0xe8c67e81)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0143e0fa),
         UINT32_C(0xd0000415),
         UINT32_C(0xd143e4ef),
         UINT32_C(0xc000380b),
         UINT32_C(0xc143d8f1),
         UINT32_C(0x10003c1e),
         UINT32_C(0x1143dce4),
         UINT32_C(0x40000318),
         UINT32_C(0x4143e3e2),
         UINT32_C(0x9000070d),
         UINT32_C(0x9143e7f7),
         UINT32_C(0x80003b13),
         UINT32_C(0x8143dbe9),
         UINT32_C(0x50003f06),
         UINT32_C(0x5143dffc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80a1f0),
         UINT32_C(0x3fe80002),
         UINT32_C(0x3fe8a1f2),
         UINT32_C(0x3fe0001c),
         UINT32_C(0x3fe0a1ec),
         UINT32_C(0x3f88001e),
         UINT32_C(0x3f88a1ee),
         UINT32_C(0x3fa00001),
         UINT32_C(0x3fa0a1f1),
         UINT32_C(0x3fc80003),
         UINT32_C(0x3fc8a1f3),
         UINT32_C(0x3fc0001d),
         UINT32_C(0x3fc0a1ed),
         UINT32_C(0x3fa8001f),
         UINT32_C(0x3fa8a1ef)},
        UINT32_C(0xfff80000),
        {0x22,0x31,0x98,0x10,0x8a,0x36,0x12,0xd8,0x2b,0xf9,
         0xfb,0x86,0x15,0x7b,0x39,0xa3,0x4b,0x3a,0xd6,0x6e,0x00}
    },
    {
        /* No.310 delta:869 weight:999 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe34e1c12),
         UINT32_C(0x209c21dc),
         UINT32_C(0xc3d23dce),
         UINT32_C(0x2d101365),
         UINT32_C(0xce5e0f77),
         UINT32_C(0x0d8c32b9),
         UINT32_C(0xeec22eab),
         UINT32_C(0x00000660),
         UINT32_C(0xe34e1a72),
         UINT32_C(0x209c27bc),
         UINT32_C(0xc3d23bae),
         UINT32_C(0x2d101505),
         UINT32_C(0xce5e0917),
         UINT32_C(0x0d8c34d9),
         UINT32_C(0xeec228cb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3043083d),
         UINT32_C(0x2002a91a),
         UINT32_C(0x1041a127),
         UINT32_C(0x1002fc16),
         UINT32_C(0x2041f42b),
         UINT32_C(0x3000550c),
         UINT32_C(0x00435d31),
         UINT32_C(0x50002014),
         UINT32_C(0x60432829),
         UINT32_C(0x7002890e),
         UINT32_C(0x40418133),
         UINT32_C(0x4002dc02),
         UINT32_C(0x7041d43f),
         UINT32_C(0x60007518),
         UINT32_C(0x50437d25)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f982184),
         UINT32_C(0x3f900154),
         UINT32_C(0x3f8820d0),
         UINT32_C(0x3f88017e),
         UINT32_C(0x3f9020fa),
         UINT32_C(0x3f98002a),
         UINT32_C(0x3f8021ae),
         UINT32_C(0x3fa80010),
         UINT32_C(0x3fb02194),
         UINT32_C(0x3fb80144),
         UINT32_C(0x3fa020c0),
         UINT32_C(0x3fa0016e),
         UINT32_C(0x3fb820ea),
         UINT32_C(0x3fb0003a),
         UINT32_C(0x3fa821be)},
        UINT32_C(0xfff80000),
        {0x62,0x66,0x00,0x51,0x21,0xb0,0x79,0x50,0xd5,0x85,
         0x99,0x1a,0x20,0x58,0xb6,0xa2,0x13,0x7a,0x09,0x2a,0x00}
    },
    {
        /* No.311 delta:725 weight:1501 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x478a7f0d),
         UINT32_C(0x8ad13ad0),
         UINT32_C(0xcd5b45dd),
         UINT32_C(0xb810137b),
         UINT32_C(0xff9a6c76),
         UINT32_C(0x32c129ab),
         UINT32_C(0x754b56a6),
         UINT32_C(0x0000d27e),
         UINT32_C(0x478aad73),
         UINT32_C(0x8ad1e8ae),
         UINT32_C(0xcd5b97a3),
         UINT32_C(0xb810c105),
         UINT32_C(0xff9abe08),
         UINT32_C(0x32c1fbd5),
         UINT32_C(0x754b84d8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x380203d3),
         UINT32_C(0x100021fc),
         UINT32_C(0x2802222f),
         UINT32_C(0x82010d5b),
         UINT32_C(0xba030e88),
         UINT32_C(0x92012ca7),
         UINT32_C(0xaa032f74),
         UINT32_C(0x80002142),
         UINT32_C(0xb8022291),
         UINT32_C(0x900000be),
         UINT32_C(0xa802036d),
         UINT32_C(0x02012c19),
         UINT32_C(0x3a032fca),
         UINT32_C(0x12010de5),
         UINT32_C(0x2a030e36)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9c0101),
         UINT32_C(0x3f880010),
         UINT32_C(0x3f940111),
         UINT32_C(0x3fc10086),
         UINT32_C(0x3fdd0187),
         UINT32_C(0x3fc90096),
         UINT32_C(0x3fd50197),
         UINT32_C(0x3fc00010),
         UINT32_C(0x3fdc0111),
         UINT32_C(0x3fc80000),
         UINT32_C(0x3fd40101),
         UINT32_C(0x3f810096),
         UINT32_C(0x3f9d0197),
         UINT32_C(0x3f890086),
         UINT32_C(0x3f950187)},
        UINT32_C(0xfff80000),
        {0x98,0x56,0x66,0xc5,0x07,0xed,0x45,0x13,0x3f,0x85,
         0xa8,0x5e,0xd3,0x70,0xc4,0x18,0x48,0x6d,0x62,0x63,0x00}
    },
    {
        /* No.312 delta:1534 weight:1411 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x00b4ab14),
         UINT32_C(0xb562a900),
         UINT32_C(0xb5d60214),
         UINT32_C(0xa1301388),
         UINT32_C(0xa184b89c),
         UINT32_C(0x1452ba88),
         UINT32_C(0x14e6119c),
         UINT32_C(0x00008fd9),
         UINT32_C(0x00b424cd),
         UINT32_C(0xb56226d9),
         UINT32_C(0xb5d68dcd),
         UINT32_C(0xa1309c51),
         UINT32_C(0xa1843745),
         UINT32_C(0x14523551),
         UINT32_C(0x14e69e45)},
        {UINT32_C(0x00000000),
         UINT32_C(0x042b017a),
         UINT32_C(0x800a25e6),
         UINT32_C(0x8421249c),
         UINT32_C(0x106411fd),
         UINT32_C(0x144f1087),
         UINT32_C(0x906e341b),
         UINT32_C(0x94453561),
         UINT32_C(0x20026016),
         UINT32_C(0x2429616c),
         UINT32_C(0xa00845f0),
         UINT32_C(0xa423448a),
         UINT32_C(0x306671eb),
         UINT32_C(0x344d7091),
         UINT32_C(0xb06c540d),
         UINT32_C(0xb4475577)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f821580),
         UINT32_C(0x3fc00512),
         UINT32_C(0x3fc21092),
         UINT32_C(0x3f883208),
         UINT32_C(0x3f8a2788),
         UINT32_C(0x3fc8371a),
         UINT32_C(0x3fca229a),
         UINT32_C(0x3f900130),
         UINT32_C(0x3f9214b0),
         UINT32_C(0x3fd00422),
         UINT32_C(0x3fd211a2),
         UINT32_C(0x3f983338),
         UINT32_C(0x3f9a26b8),
         UINT32_C(0x3fd8362a),
         UINT32_C(0x3fda23aa)},
        UINT32_C(0xfff80000),
        {0x0e,0x08,0x24,0x45,0x72,0x8c,0xef,0x0b,0x3a,0xbe,
         0xef,0xf3,0x47,0x01,0x4b,0x04,0xd2,0x27,0x27,0x7e,0x00}
    },
    {
        /* No.313 delta:837 weight:1555 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6d665276),
         UINT32_C(0x652e079c),
         UINT32_C(0x084855ea),
         UINT32_C(0x16101395),
         UINT32_C(0x7b7641e3),
         UINT32_C(0x733e1409),
         UINT32_C(0x1e58467f),
         UINT32_C(0x0000074a),
         UINT32_C(0x6d66553c),
         UINT32_C(0x652e00d6),
         UINT32_C(0x084852a0),
         UINT32_C(0x161014df),
         UINT32_C(0x7b7646a9),
         UINT32_C(0x733e1343),
         UINT32_C(0x1e584135)},
        {UINT32_C(0x00000000),
         UINT32_C(0x100468b6),
         UINT32_C(0x20025c95),
         UINT32_C(0x30063423),
         UINT32_C(0x00019019),
         UINT32_C(0x1005f8af),
         UINT32_C(0x2003cc8c),
         UINT32_C(0x3007a43a),
         UINT32_C(0x6000240e),
         UINT32_C(0x70044cb8),
         UINT32_C(0x4002789b),
         UINT32_C(0x5006102d),
         UINT32_C(0x6001b417),
         UINT32_C(0x7005dca1),
         UINT32_C(0x4003e882),
         UINT32_C(0x50078034)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880234),
         UINT32_C(0x3f90012e),
         UINT32_C(0x3f98031a),
         UINT32_C(0x3f8000c8),
         UINT32_C(0x3f8802fc),
         UINT32_C(0x3f9001e6),
         UINT32_C(0x3f9803d2),
         UINT32_C(0x3fb00012),
         UINT32_C(0x3fb80226),
         UINT32_C(0x3fa0013c),
         UINT32_C(0x3fa80308),
         UINT32_C(0x3fb000da),
         UINT32_C(0x3fb802ee),
         UINT32_C(0x3fa001f4),
         UINT32_C(0x3fa803c0)},
        UINT32_C(0xfff80000),
        {0x05,0xb8,0xd1,0xe6,0xec,0x01,0xf4,0x0b,0x19,0x45,
         0xe7,0x27,0x9f,0xa7,0x63,0x05,0x6b,0xe9,0xe5,0x36,0x00}
    },
    {
        /* No.314 delta:897 weight:983 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x16dc0e50),
         UINT32_C(0xe4c764a4),
         UINT32_C(0xf21b6af4),
         UINT32_C(0x8a9013a9),
         UINT32_C(0x9c4c1df9),
         UINT32_C(0x6e57770d),
         UINT32_C(0x788b795d),
         UINT32_C(0x00006fcc),
         UINT32_C(0x16dc619c),
         UINT32_C(0xe4c70b68),
         UINT32_C(0xf21b0538),
         UINT32_C(0x8a907c65),
         UINT32_C(0x9c4c7235),
         UINT32_C(0x6e5718c1),
         UINT32_C(0x788b1691)},
        {UINT32_C(0x00000000),
         UINT32_C(0x50000057),
         UINT32_C(0x69110819),
         UINT32_C(0x3911084e),
         UINT32_C(0x4003b013),
         UINT32_C(0x1003b044),
         UINT32_C(0x2912b80a),
         UINT32_C(0x7912b85d),
         UINT32_C(0x400040f8),
         UINT32_C(0x100040af),
         UINT32_C(0x291148e1),
         UINT32_C(0x791148b6),
         UINT32_C(0x0003f0eb),
         UINT32_C(0x5003f0bc),
         UINT32_C(0x6912f8f2),
         UINT32_C(0x3912f8a5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa80000),
         UINT32_C(0x3fb48884),
         UINT32_C(0x3f9c8884),
         UINT32_C(0x3fa001d8),
         UINT32_C(0x3f8801d8),
         UINT32_C(0x3f94895c),
         UINT32_C(0x3fbc895c),
         UINT32_C(0x3fa00020),
         UINT32_C(0x3f880020),
         UINT32_C(0x3f9488a4),
         UINT32_C(0x3fbc88a4),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3fa801f8),
         UINT32_C(0x3fb4897c),
         UINT32_C(0x3f9c897c)},
        UINT32_C(0xfff80000),
        {0xd9,0x1b,0x73,0x16,0x98,0x53,0x60,0xca,0xdb,0x7d,
         0xfd,0x3e,0x0f,0x70,0x73,0x9f,0xa5,0x47,0x51,0x7b,0x00}
    },
    {
        /* No.315 delta:769 weight:1561 */
        11213,
        93,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4728414d),
         UINT32_C(0x255cb3ed),
         UINT32_C(0x6274f2a0),
         UINT32_C(0x23b013b0),
         UINT32_C(0x649852fd),
         UINT32_C(0x06eca05d),
         UINT32_C(0x41c4e110),
         UINT32_C(0x00008881),
         UINT32_C(0x4728c9cc),
         UINT32_C(0x255c3b6c),
         UINT32_C(0x62747a21),
         UINT32_C(0x23b09b31),
         UINT32_C(0x6498da7c),
         UINT32_C(0x06ec28dc),
         UINT32_C(0x41c46991)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00168d1f),
         UINT32_C(0x000aef0b),
         UINT32_C(0x001c6214),
         UINT32_C(0x400360f3),
         UINT32_C(0x4015edec),
         UINT32_C(0x40098ff8),
         UINT32_C(0x401f02e7),
         UINT32_C(0x20142006),
         UINT32_C(0x2002ad19),
         UINT32_C(0x201ecf0d),
         UINT32_C(0x20084212),
         UINT32_C(0x601740f5),
         UINT32_C(0x6001cdea),
         UINT32_C(0x601daffe),
         UINT32_C(0x600b22e1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800b46),
         UINT32_C(0x3f800577),
         UINT32_C(0x3f800e31),
         UINT32_C(0x3fa001b0),
         UINT32_C(0x3fa00af6),
         UINT32_C(0x3fa004c7),
         UINT32_C(0x3fa00f81),
         UINT32_C(0x3f900a10),
         UINT32_C(0x3f900156),
         UINT32_C(0x3f900f67),
         UINT32_C(0x3f900421),
         UINT32_C(0x3fb00ba0),
         UINT32_C(0x3fb000e6),
         UINT32_C(0x3fb00ed7),
         UINT32_C(0x3fb00591)},
        UINT32_C(0xfff80000),
        {0x71,0xed,0xd0,0xe5,0x86,0xff,0x04,0x4f,0x0d,0xc7,
         0x47,0x80,0xe7,0xed,0xfb,0x64,0x23,0xc3,0x09,0x9f,0x00}
    },
    {
        /* No.316 delta:1571 weight:1533 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x478766bf),
         UINT32_C(0x9d080954),
         UINT32_C(0xda8f6feb),
         UINT32_C(0xa0d013c8),
         UINT32_C(0xe7577577),
         UINT32_C(0x3dd81a9c),
         UINT32_C(0x7a5f7c23),
         UINT32_C(0x0000938f),
         UINT32_C(0x4787f530),
         UINT32_C(0x9d089adb),
         UINT32_C(0xda8ffc64),
         UINT32_C(0xa0d08047),
         UINT32_C(0xe757e6f8),
         UINT32_C(0x3dd88913),
         UINT32_C(0x7a5fefac)},
        {UINT32_C(0x00000000),
         UINT32_C(0x103992f2),
         UINT32_C(0x00530191),
         UINT32_C(0x106a9363),
         UINT32_C(0x41f84817),
         UINT32_C(0x51c1dae5),
         UINT32_C(0x41ab4986),
         UINT32_C(0x5192db74),
         UINT32_C(0xa0108208),
         UINT32_C(0xb02910fa),
         UINT32_C(0xa0438399),
         UINT32_C(0xb07a116b),
         UINT32_C(0xe1e8ca1f),
         UINT32_C(0xf1d158ed),
         UINT32_C(0xe1bbcb8e),
         UINT32_C(0xf182597c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881cc9),
         UINT32_C(0x3f802980),
         UINT32_C(0x3f883549),
         UINT32_C(0x3fa0fc24),
         UINT32_C(0x3fa8e0ed),
         UINT32_C(0x3fa0d5a4),
         UINT32_C(0x3fa8c96d),
         UINT32_C(0x3fd00841),
         UINT32_C(0x3fd81488),
         UINT32_C(0x3fd021c1),
         UINT32_C(0x3fd83d08),
         UINT32_C(0x3ff0f465),
         UINT32_C(0x3ff8e8ac),
         UINT32_C(0x3ff0dde5),
         UINT32_C(0x3ff8c12c)},
        UINT32_C(0xfff80000),
        {0x8e,0x5b,0x93,0xaa,0xef,0xef,0x2b,0x60,0x7f,0x6f,
         0xbb,0x32,0x2a,0xf3,0x5c,0x7a,0x85,0x28,0x14,0xb3,0x00}
    },
    {
        /* No.317 delta:797 weight:987 */
        11213,
        89,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf7e1c4a2),
         UINT32_C(0x1e587863),
         UINT32_C(0xe9b9bcc1),
         UINT32_C(0x563013df),
         UINT32_C(0xa1d1d77d),
         UINT32_C(0x48686bbc),
         UINT32_C(0xbf89af1e),
         UINT32_C(0x00001394),
         UINT32_C(0xf7e1d736),
         UINT32_C(0x1e586bf7),
         UINT32_C(0xe9b9af55),
         UINT32_C(0x5630004b),
         UINT32_C(0xa1d1c4e9),
         UINT32_C(0x48687828),
         UINT32_C(0xbf89bc8a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x07f01055),
         UINT32_C(0x4d0a1891),
         UINT32_C(0x4afa08c4),
         UINT32_C(0x0860c96c),
         UINT32_C(0x0f90d939),
         UINT32_C(0x456ad1fd),
         UINT32_C(0x429ac1a8),
         UINT32_C(0x90c0081f),
         UINT32_C(0x9730184a),
         UINT32_C(0xddca108e),
         UINT32_C(0xda3a00db),
         UINT32_C(0x98a0c173),
         UINT32_C(0x9f50d126),
         UINT32_C(0xd5aad9e2),
         UINT32_C(0xd25ac9b7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f83f808),
         UINT32_C(0x3fa6850c),
         UINT32_C(0x3fa57d04),
         UINT32_C(0x3f843064),
         UINT32_C(0x3f87c86c),
         UINT32_C(0x3fa2b568),
         UINT32_C(0x3fa14d60),
         UINT32_C(0x3fc86004),
         UINT32_C(0x3fcb980c),
         UINT32_C(0x3feee508),
         UINT32_C(0x3fed1d00),
         UINT32_C(0x3fcc5060),
         UINT32_C(0x3fcfa868),
         UINT32_C(0x3fead56c),
         UINT32_C(0x3fe92d64)},
        UINT32_C(0xfff80000),
        {0x1b,0x30,0x07,0x24,0x04,0xf5,0x67,0x3f,0x7e,0xd5,
         0x57,0x9b,0x73,0x1b,0xd8,0xc0,0x7a,0x2e,0xf6,0x14,0x00}
    },
    {
        /* No.318 delta:704 weight:1405 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9529c577),
         UINT32_C(0xc83c7399),
         UINT32_C(0x5d15b6ee),
         UINT32_C(0xefb013e0),
         UINT32_C(0x7a99d697),
         UINT32_C(0x278c6079),
         UINT32_C(0xb2a5a50e),
         UINT32_C(0x0000e239),
         UINT32_C(0x9529274e),
         UINT32_C(0xc83c91a0),
         UINT32_C(0x5d1554d7),
         UINT32_C(0xefb0f1d9),
         UINT32_C(0x7a9934ae),
         UINT32_C(0x278c8240),
         UINT32_C(0xb2a54737)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa40209b3),
         UINT32_C(0x51006095),
         UINT32_C(0xf5026926),
         UINT32_C(0x80740887),
         UINT32_C(0x24760134),
         UINT32_C(0xd1746812),
         UINT32_C(0x757661a1),
         UINT32_C(0x0042219f),
         UINT32_C(0xa440282c),
         UINT32_C(0x5142410a),
         UINT32_C(0xf54048b9),
         UINT32_C(0x80362918),
         UINT32_C(0x243420ab),
         UINT32_C(0xd136498d),
         UINT32_C(0x7534403e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd20104),
         UINT32_C(0x3fa88030),
         UINT32_C(0x3ffa8134),
         UINT32_C(0x3fc03a04),
         UINT32_C(0x3f923b00),
         UINT32_C(0x3fe8ba34),
         UINT32_C(0x3fbabb30),
         UINT32_C(0x3f802110),
         UINT32_C(0x3fd22014),
         UINT32_C(0x3fa8a120),
         UINT32_C(0x3ffaa024),
         UINT32_C(0x3fc01b14),
         UINT32_C(0x3f921a10),
         UINT32_C(0x3fe89b24),
         UINT32_C(0x3fba9a20)},
        UINT32_C(0xfff80000),
        {0xf1,0x57,0x29,0xfc,0x60,0x9e,0xd0,0x93,0x68,0x21,
         0x36,0x83,0xbf,0x33,0x33,0x45,0x83,0x30,0x85,0x00,0x00}
    },
    {
        /* No.319 delta:1947 weight:1519 */
        11213,
        10,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbad4c9df),
         UINT32_C(0xc6af05e7),
         UINT32_C(0x7c7bcc38),
         UINT32_C(0x680013f3),
         UINT32_C(0xd2d4da2c),
         UINT32_C(0xaeaf1614),
         UINT32_C(0x147bdfcb),
         UINT32_C(0x00004bee),
         UINT32_C(0xbad48231),
         UINT32_C(0xc6af4e09),
         UINT32_C(0x7c7b87d6),
         UINT32_C(0x6800581d),
         UINT32_C(0xd2d491c2),
         UINT32_C(0xaeaf5dfa),
         UINT32_C(0x147b9425)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0e4422ba),
         UINT32_C(0x40802d79),
         UINT32_C(0x4ec40fc3),
         UINT32_C(0x0184080e),
         UINT32_C(0x0fc02ab4),
         UINT32_C(0x41042577),
         UINT32_C(0x4f4007cd),
         UINT32_C(0x0941ea0b),
         UINT32_C(0x0705c8b1),
         UINT32_C(0x49c1c772),
         UINT32_C(0x4785e5c8),
         UINT32_C(0x08c5e205),
         UINT32_C(0x0681c0bf),
         UINT32_C(0x4845cf7c),
         UINT32_C(0x4601edc6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f872211),
         UINT32_C(0x3fa04016),
         UINT32_C(0x3fa76207),
         UINT32_C(0x3f80c204),
         UINT32_C(0x3f87e015),
         UINT32_C(0x3fa08212),
         UINT32_C(0x3fa7a003),
         UINT32_C(0x3f84a0f5),
         UINT32_C(0x3f8382e4),
         UINT32_C(0x3fa4e0e3),
         UINT32_C(0x3fa3c2f2),
         UINT32_C(0x3f8462f1),
         UINT32_C(0x3f8340e0),
         UINT32_C(0x3fa422e7),
         UINT32_C(0x3fa300f6)},
        UINT32_C(0xfff80000),
        {0x58,0xb2,0xf4,0xf5,0xd7,0x57,0x9e,0x1c,0x57,0x25,
         0xfa,0xee,0x3f,0x39,0x72,0x4c,0x05,0x26,0x40,0x8e,0x00}
    },
    {
        /* No.320 delta:1343 weight:1707 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x95687d9e),
         UINT32_C(0xe12eee39),
         UINT32_C(0x744693a7),
         UINT32_C(0x00f01403),
         UINT32_C(0x9598699d),
         UINT32_C(0xe1defa3a),
         UINT32_C(0x74b687a4),
         UINT32_C(0x00004df2),
         UINT32_C(0x9568306c),
         UINT32_C(0xe12ea3cb),
         UINT32_C(0x7446de55),
         UINT32_C(0x00f059f1),
         UINT32_C(0x9598246f),
         UINT32_C(0xe1deb7c8),
         UINT32_C(0x74b6ca56)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00304112),
         UINT32_C(0x000c8057),
         UINT32_C(0x003cc145),
         UINT32_C(0x0002018b),
         UINT32_C(0x00324099),
         UINT32_C(0x000e81dc),
         UINT32_C(0x003ec0ce),
         UINT32_C(0x0071015f),
         UINT32_C(0x0041404d),
         UINT32_C(0x007d8108),
         UINT32_C(0x004dc01a),
         UINT32_C(0x007300d4),
         UINT32_C(0x004341c6),
         UINT32_C(0x007f8083),
         UINT32_C(0x004fc191)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801820),
         UINT32_C(0x3f800640),
         UINT32_C(0x3f801e60),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f801920),
         UINT32_C(0x3f800740),
         UINT32_C(0x3f801f60),
         UINT32_C(0x3f803880),
         UINT32_C(0x3f8020a0),
         UINT32_C(0x3f803ec0),
         UINT32_C(0x3f8026e0),
         UINT32_C(0x3f803980),
         UINT32_C(0x3f8021a0),
         UINT32_C(0x3f803fc0),
         UINT32_C(0x3f8027e0)},
        UINT32_C(0xfff80000),
        {0x3d,0x98,0x7f,0xba,0x4c,0x07,0x45,0x40,0x8d,0x87,
         0x77,0xdc,0x7b,0xd4,0xba,0x42,0x41,0xfd,0x7a,0xf3,0x00}
    },
    {
        /* No.321 delta:763 weight:1119 */
        11213,
        87,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9aa13a36),
         UINT32_C(0x3e3a4f1f),
         UINT32_C(0xa49b7529),
         UINT32_C(0x0b401415),
         UINT32_C(0x91e12e23),
         UINT32_C(0x357a5b0a),
         UINT32_C(0xafdb613c),
         UINT32_C(0x000016d1),
         UINT32_C(0x9aa12ce7),
         UINT32_C(0x3e3a59ce),
         UINT32_C(0xa49b63f8),
         UINT32_C(0x0b4002c4),
         UINT32_C(0x91e138f2),
         UINT32_C(0x357a4ddb),
         UINT32_C(0xafdb77ed)},
        {UINT32_C(0x00000000),
         UINT32_C(0x103a1d72),
         UINT32_C(0x10460014),
         UINT32_C(0x007c1d66),
         UINT32_C(0x0041080f),
         UINT32_C(0x107b157d),
         UINT32_C(0x1007081b),
         UINT32_C(0x003d1569),
         UINT32_C(0x0062700a),
         UINT32_C(0x10586d78),
         UINT32_C(0x1024701e),
         UINT32_C(0x001e6d6c),
         UINT32_C(0x00237805),
         UINT32_C(0x10196577),
         UINT32_C(0x10657811),
         UINT32_C(0x005f6563)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881d0e),
         UINT32_C(0x3f882300),
         UINT32_C(0x3f803e0e),
         UINT32_C(0x3f802084),
         UINT32_C(0x3f883d8a),
         UINT32_C(0x3f880384),
         UINT32_C(0x3f801e8a),
         UINT32_C(0x3f803138),
         UINT32_C(0x3f882c36),
         UINT32_C(0x3f881238),
         UINT32_C(0x3f800f36),
         UINT32_C(0x3f8011bc),
         UINT32_C(0x3f880cb2),
         UINT32_C(0x3f8832bc),
         UINT32_C(0x3f802fb2)},
        UINT32_C(0xfff80000),
        {0x3f,0x7f,0x60,0xab,0x7f,0x82,0x81,0x09,0xd4,0xa6,
         0x94,0x58,0x17,0xb3,0xc7,0x2a,0x79,0xaa,0x29,0x1e,0x00}
    },
    {
        /* No.322 delta:2883 weight:821 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe0fb1a8f),
         UINT32_C(0xa6843748),
         UINT32_C(0x467f2dc7),
         UINT32_C(0x4b20142c),
         UINT32_C(0xabdb0ea3),
         UINT32_C(0xeda42364),
         UINT32_C(0x0d5f39eb),
         UINT32_C(0x00002dcb),
         UINT32_C(0xe0fb3744),
         UINT32_C(0xa6841a83),
         UINT32_C(0x467f000c),
         UINT32_C(0x4b2039e7),
         UINT32_C(0xabdb2368),
         UINT32_C(0xeda40eaf),
         UINT32_C(0x0d5f1420)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1a03e997),
         UINT32_C(0x0e120811),
         UINT32_C(0x1411e186),
         UINT32_C(0x096200d5),
         UINT32_C(0x1361e942),
         UINT32_C(0x077008c4),
         UINT32_C(0x1d73e153),
         UINT32_C(0x80020c8f),
         UINT32_C(0x9a01e518),
         UINT32_C(0x8e10049e),
         UINT32_C(0x9413ed09),
         UINT32_C(0x89600c5a),
         UINT32_C(0x9363e5cd),
         UINT32_C(0x8772044b),
         UINT32_C(0x9d71eddc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8d01f4),
         UINT32_C(0x3f870904),
         UINT32_C(0x3f8a08f0),
         UINT32_C(0x3f84b100),
         UINT32_C(0x3f89b0f4),
         UINT32_C(0x3f83b804),
         UINT32_C(0x3f8eb9f0),
         UINT32_C(0x3fc00106),
         UINT32_C(0x3fcd00f2),
         UINT32_C(0x3fc70802),
         UINT32_C(0x3fca09f6),
         UINT32_C(0x3fc4b006),
         UINT32_C(0x3fc9b1f2),
         UINT32_C(0x3fc3b902),
         UINT32_C(0x3fceb8f6)},
        UINT32_C(0xfff80000),
        {0x07,0x40,0x26,0xee,0x41,0x3e,0x36,0x8f,0x2b,0x61,
         0xbe,0xa5,0xb4,0xc1,0xdb,0x90,0x7f,0x30,0x55,0x08,0x00}
    },
    {
        /* No.323 delta:787 weight:1255 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc201724a),
         UINT32_C(0xbd7f5d87),
         UINT32_C(0x7f7e2fcd),
         UINT32_C(0xc0b01432),
         UINT32_C(0x02b16678),
         UINT32_C(0x7dcf49b5),
         UINT32_C(0xbfce3bff),
         UINT32_C(0x0000d10c),
         UINT32_C(0xc201a346),
         UINT32_C(0xbd7f8c8b),
         UINT32_C(0x7f7efec1),
         UINT32_C(0xc0b0c53e),
         UINT32_C(0x02b1b774),
         UINT32_C(0x7dcf98b9),
         UINT32_C(0xbfceeaf3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2003097e),
         UINT32_C(0x2000e049),
         UINT32_C(0x0003e937),
         UINT32_C(0x100409ab),
         UINT32_C(0x300700d5),
         UINT32_C(0x3004e9e2),
         UINT32_C(0x1007e09c),
         UINT32_C(0x6004001a),
         UINT32_C(0x40070964),
         UINT32_C(0x4004e053),
         UINT32_C(0x6007e92d),
         UINT32_C(0x700009b1),
         UINT32_C(0x500300cf),
         UINT32_C(0x5000e9f8),
         UINT32_C(0x7003e086)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900184),
         UINT32_C(0x3f900070),
         UINT32_C(0x3f8001f4),
         UINT32_C(0x3f880204),
         UINT32_C(0x3f980380),
         UINT32_C(0x3f980274),
         UINT32_C(0x3f8803f0),
         UINT32_C(0x3fb00200),
         UINT32_C(0x3fa00384),
         UINT32_C(0x3fa00270),
         UINT32_C(0x3fb003f4),
         UINT32_C(0x3fb80004),
         UINT32_C(0x3fa80180),
         UINT32_C(0x3fa80074),
         UINT32_C(0x3fb801f0)},
        UINT32_C(0xfff80000),
        {0x3c,0x1d,0xc8,0x48,0xca,0x0e,0x2b,0x39,0x42,0x3d,
         0x4c,0xff,0x69,0xac,0xff,0xe8,0xf7,0xa9,0xe2,0x6c,0x00}
    },
    {
        /* No.324 delta:795 weight:1553 */
        11213,
        54,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3c65716d),
         UINT32_C(0x511a1b1b),
         UINT32_C(0x6d7f6a76),
         UINT32_C(0x6420144e),
         UINT32_C(0x58456523),
         UINT32_C(0x353a0f55),
         UINT32_C(0x095f7e38),
         UINT32_C(0x0000c620),
         UINT32_C(0x3c65b74d),
         UINT32_C(0x511add3b),
         UINT32_C(0x6d7fac56),
         UINT32_C(0x6420d26e),
         UINT32_C(0x5845a303),
         UINT32_C(0x353ac975),
         UINT32_C(0x095fb818)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0005193e),
         UINT32_C(0x0002b037),
         UINT32_C(0x0007a909),
         UINT32_C(0x0043901c),
         UINT32_C(0x00468922),
         UINT32_C(0x0041202b),
         UINT32_C(0x00443915),
         UINT32_C(0x282110a3),
         UINT32_C(0x2824099d),
         UINT32_C(0x2823a094),
         UINT32_C(0x2826b9aa),
         UINT32_C(0x286280bf),
         UINT32_C(0x28679981),
         UINT32_C(0x28603088),
         UINT32_C(0x286529b6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80028c),
         UINT32_C(0x3f800158),
         UINT32_C(0x3f8003d4),
         UINT32_C(0x3f8021c8),
         UINT32_C(0x3f802344),
         UINT32_C(0x3f802090),
         UINT32_C(0x3f80221c),
         UINT32_C(0x3f941088),
         UINT32_C(0x3f941204),
         UINT32_C(0x3f9411d0),
         UINT32_C(0x3f94135c),
         UINT32_C(0x3f943140),
         UINT32_C(0x3f9433cc),
         UINT32_C(0x3f943018),
         UINT32_C(0x3f943294)},
        UINT32_C(0xfff80000),
        {0x6b,0x7e,0x85,0x2e,0xce,0x11,0x4b,0xad,0xcd,0x12,
         0x16,0xd1,0xb1,0xeb,0x8a,0x25,0xa8,0xfa,0xe8,0x1e,0x00}
    },
    {
        /* No.325 delta:1620 weight:1585 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1c3439f2),
         UINT32_C(0x2cb4051e),
         UINT32_C(0x30803cec),
         UINT32_C(0x12901459),
         UINT32_C(0x0ea42dab),
         UINT32_C(0x3e241147),
         UINT32_C(0x221028b5),
         UINT32_C(0x00005f03),
         UINT32_C(0x1c3466f1),
         UINT32_C(0x2cb45a1d),
         UINT32_C(0x308063ef),
         UINT32_C(0x12904b5a),
         UINT32_C(0x0ea472a8),
         UINT32_C(0x3e244e44),
         UINT32_C(0x221077b6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00f80992),
         UINT32_C(0xc20402dc),
         UINT32_C(0xc2fc0b4e),
         UINT32_C(0x200c8011),
         UINT32_C(0x20f48983),
         UINT32_C(0xe20882cd),
         UINT32_C(0xe2f08b5f),
         UINT32_C(0x1000440b),
         UINT32_C(0x10f84d99),
         UINT32_C(0xd20446d7),
         UINT32_C(0xd2fc4f45),
         UINT32_C(0x300cc41a),
         UINT32_C(0x30f4cd88),
         UINT32_C(0xf208c6c6),
         UINT32_C(0xf2f0cf54)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f807c04),
         UINT32_C(0x3fe10201),
         UINT32_C(0x3fe17e05),
         UINT32_C(0x3f900640),
         UINT32_C(0x3f907a44),
         UINT32_C(0x3ff10441),
         UINT32_C(0x3ff17845),
         UINT32_C(0x3f880022),
         UINT32_C(0x3f887c26),
         UINT32_C(0x3fe90223),
         UINT32_C(0x3fe97e27),
         UINT32_C(0x3f980662),
         UINT32_C(0x3f987a66),
         UINT32_C(0x3ff90463),
         UINT32_C(0x3ff97867)},
        UINT32_C(0xfff80000),
        {0x14,0x85,0x7c,0xf8,0xd2,0x0e,0x6b,0x76,0x39,0x54,
         0x41,0x6f,0x01,0xf9,0x76,0x71,0x51,0xc6,0x4a,0x7a,0x00}
    },
    {
        /* No.326 delta:1192 weight:1299 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x96676930),
         UINT32_C(0x1ebf2087),
         UINT32_C(0x88d849b7),
         UINT32_C(0xe8001466),
         UINT32_C(0x7e677d56),
         UINT32_C(0xf6bf34e1),
         UINT32_C(0x60d85dd1),
         UINT32_C(0x00003950),
         UINT32_C(0x96675060),
         UINT32_C(0x1ebf19d7),
         UINT32_C(0x88d870e7),
         UINT32_C(0xe8002d36),
         UINT32_C(0x7e674406),
         UINT32_C(0xf6bf0db1),
         UINT32_C(0x60d86481)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0026ca1c),
         UINT32_C(0x004350b3),
         UINT32_C(0x00659aaf),
         UINT32_C(0x2108e059),
         UINT32_C(0x212e2a45),
         UINT32_C(0x214bb0ea),
         UINT32_C(0x216d7af6),
         UINT32_C(0x00024012),
         UINT32_C(0x00248a0e),
         UINT32_C(0x004110a1),
         UINT32_C(0x0067dabd),
         UINT32_C(0x210aa04b),
         UINT32_C(0x212c6a57),
         UINT32_C(0x2149f0f8),
         UINT32_C(0x216f3ae4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801365),
         UINT32_C(0x3f8021a8),
         UINT32_C(0x3f8032cd),
         UINT32_C(0x3f908470),
         UINT32_C(0x3f909715),
         UINT32_C(0x3f90a5d8),
         UINT32_C(0x3f90b6bd),
         UINT32_C(0x3f800120),
         UINT32_C(0x3f801245),
         UINT32_C(0x3f802088),
         UINT32_C(0x3f8033ed),
         UINT32_C(0x3f908550),
         UINT32_C(0x3f909635),
         UINT32_C(0x3f90a4f8),
         UINT32_C(0x3f90b79d)},
        UINT32_C(0xfff80000),
        {0x4f,0x3b,0x08,0x33,0xa8,0xee,0x2e,0x08,0xcf,0x9c,
         0x3b,0x52,0x0b,0xa7,0x35,0xfc,0xdb,0x1d,0xe8,0x24,0x00}
    },
    {
        /* No.327 delta:1536 weight:1647 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8bc3dfcb),
         UINT32_C(0x91944dcf),
         UINT32_C(0x1a579204),
         UINT32_C(0x4c101471),
         UINT32_C(0xc7d3cbba),
         UINT32_C(0xdd8459be),
         UINT32_C(0x56478675),
         UINT32_C(0x000012f3),
         UINT32_C(0x8bc3cd38),
         UINT32_C(0x91945f3c),
         UINT32_C(0x1a5780f7),
         UINT32_C(0x4c100682),
         UINT32_C(0xc7d3d949),
         UINT32_C(0xdd844b4d),
         UINT32_C(0x56479486)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0057a0dc),
         UINT32_C(0x0078411f),
         UINT32_C(0x002fe1c3),
         UINT32_C(0x100441ab),
         UINT32_C(0x1053e177),
         UINT32_C(0x107c00b4),
         UINT32_C(0x102ba068),
         UINT32_C(0x1000007e),
         UINT32_C(0x1057a0a2),
         UINT32_C(0x10784161),
         UINT32_C(0x102fe1bd),
         UINT32_C(0x000441d5),
         UINT32_C(0x0053e109),
         UINT32_C(0x007c00ca),
         UINT32_C(0x002ba016)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802bd0),
         UINT32_C(0x3f803c20),
         UINT32_C(0x3f8017f0),
         UINT32_C(0x3f880220),
         UINT32_C(0x3f8829f0),
         UINT32_C(0x3f883e00),
         UINT32_C(0x3f8815d0),
         UINT32_C(0x3f880000),
         UINT32_C(0x3f882bd0),
         UINT32_C(0x3f883c20),
         UINT32_C(0x3f8817f0),
         UINT32_C(0x3f800220),
         UINT32_C(0x3f8029f0),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f8015d0)},
        UINT32_C(0xfff80000),
        {0xf8,0x64,0x08,0xa2,0x57,0xd1,0x81,0xf2,0x8a,0x27,
         0xab,0x84,0x7d,0xb0,0x0b,0xe5,0x22,0x66,0x24,0x1d,0x00}
    },
    {
        /* No.328 delta:1074 weight:779 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x48a4e13a),
         UINT32_C(0x0f8b032c),
         UINT32_C(0x472fe216),
         UINT32_C(0xa9701488),
         UINT32_C(0xe1d4f5b2),
         UINT32_C(0xa6fb17a4),
         UINT32_C(0xee5ff69e),
         UINT32_C(0x000021ce),
         UINT32_C(0x48a4c0f4),
         UINT32_C(0x0f8b22e2),
         UINT32_C(0x472fc3d8),
         UINT32_C(0xa9703546),
         UINT32_C(0xe1d4d47c),
         UINT32_C(0xa6fb366a),
         UINT32_C(0xee5fd750)},
        {UINT32_C(0x00000000),
         UINT32_C(0x08658037),
         UINT32_C(0x00184019),
         UINT32_C(0x087dc02e),
         UINT32_C(0x0003016d),
         UINT32_C(0x0866815a),
         UINT32_C(0x001b4174),
         UINT32_C(0x087ec143),
         UINT32_C(0x40241ba8),
         UINT32_C(0x48419b9f),
         UINT32_C(0x403c5bb1),
         UINT32_C(0x4859db86),
         UINT32_C(0x40271ac5),
         UINT32_C(0x48429af2),
         UINT32_C(0x403f5adc),
         UINT32_C(0x485adaeb)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8432c0),
         UINT32_C(0x3f800c20),
         UINT32_C(0x3f843ee0),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f843340),
         UINT32_C(0x3f800da0),
         UINT32_C(0x3f843f60),
         UINT32_C(0x3fa0120d),
         UINT32_C(0x3fa420cd),
         UINT32_C(0x3fa01e2d),
         UINT32_C(0x3fa42ced),
         UINT32_C(0x3fa0138d),
         UINT32_C(0x3fa4214d),
         UINT32_C(0x3fa01fad),
         UINT32_C(0x3fa42d6d)},
        UINT32_C(0xfff80000),
        {0x5d,0xa9,0xf2,0x8d,0x87,0x47,0x78,0x7c,0x72,0xda,
         0x47,0x7c,0xfd,0xdc,0x62,0x66,0xcb,0x82,0x28,0x6b,0x00}
    },
    {
        /* No.329 delta:1431 weight:1593 */
        11213,
        17,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x52b71d7c),
         UINT32_C(0x4f1c5a83),
         UINT32_C(0x1dab47ff),
         UINT32_C(0x9630149b),
         UINT32_C(0xc48709e7),
         UINT32_C(0xd92c4e18),
         UINT32_C(0x8b9b5364),
         UINT32_C(0x00004833),
         UINT32_C(0x52b7554f),
         UINT32_C(0x4f1c12b0),
         UINT32_C(0x1dab0fcc),
         UINT32_C(0x96305ca8),
         UINT32_C(0xc48741d4),
         UINT32_C(0xd92c062b),
         UINT32_C(0x8b9b1b57)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007ae0b2),
         UINT32_C(0x10440c15),
         UINT32_C(0x103eeca7),
         UINT32_C(0xa084100e),
         UINT32_C(0xa0fef0bc),
         UINT32_C(0xb0c01c1b),
         UINT32_C(0xb0bafca9),
         UINT32_C(0x10310011),
         UINT32_C(0x104be0a3),
         UINT32_C(0x00750c04),
         UINT32_C(0x000fecb6),
         UINT32_C(0xb0b5101f),
         UINT32_C(0xb0cff0ad),
         UINT32_C(0xa0f11c0a),
         UINT32_C(0xa08bfcb8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803d70),
         UINT32_C(0x3f882206),
         UINT32_C(0x3f881f76),
         UINT32_C(0x3fd04208),
         UINT32_C(0x3fd07f78),
         UINT32_C(0x3fd8600e),
         UINT32_C(0x3fd85d7e),
         UINT32_C(0x3f881880),
         UINT32_C(0x3f8825f0),
         UINT32_C(0x3f803a86),
         UINT32_C(0x3f8007f6),
         UINT32_C(0x3fd85a88),
         UINT32_C(0x3fd867f8),
         UINT32_C(0x3fd0788e),
         UINT32_C(0x3fd045fe)},
        UINT32_C(0xfff80000),
        {0x4b,0x4c,0x4a,0x92,0x08,0x7a,0x0d,0x81,0xbe,0x69,
         0xe8,0x71,0xcb,0xdf,0x9c,0xad,0x46,0x94,0x0a,0x2f,0x00}
    },
    {
        /* No.330 delta:1014 weight:1347 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb9ac6e8d),
         UINT32_C(0x4ade8d84),
         UINT32_C(0xf372e309),
         UINT32_C(0xa47014a3),
         UINT32_C(0x1ddc7a2e),
         UINT32_C(0xeeae9927),
         UINT32_C(0x5702f7aa),
         UINT32_C(0x000051d7),
         UINT32_C(0xb9ac3f5a),
         UINT32_C(0x4adedc53),
         UINT32_C(0xf372b2de),
         UINT32_C(0xa4704574),
         UINT32_C(0x1ddc2bf9),
         UINT32_C(0xeeaec8f0),
         UINT32_C(0x5702a67d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x104c047a),
         UINT32_C(0x900a898b),
         UINT32_C(0x80468df1),
         UINT32_C(0x30022057),
         UINT32_C(0x204e242d),
         UINT32_C(0xa008a9dc),
         UINT32_C(0xb044ada6),
         UINT32_C(0x30018033),
         UINT32_C(0x204d8449),
         UINT32_C(0xa00b09b8),
         UINT32_C(0xb0470dc2),
         UINT32_C(0x0003a064),
         UINT32_C(0x104fa41e),
         UINT32_C(0x900929ef),
         UINT32_C(0x80452d95)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f882602),
         UINT32_C(0x3fc80544),
         UINT32_C(0x3fc02346),
         UINT32_C(0x3f980110),
         UINT32_C(0x3f902712),
         UINT32_C(0x3fd00454),
         UINT32_C(0x3fd82256),
         UINT32_C(0x3f9800c0),
         UINT32_C(0x3f9026c2),
         UINT32_C(0x3fd00584),
         UINT32_C(0x3fd82386),
         UINT32_C(0x3f8001d0),
         UINT32_C(0x3f8827d2),
         UINT32_C(0x3fc80494),
         UINT32_C(0x3fc02296)},
        UINT32_C(0xfff80000),
        {0xfb,0x45,0x9c,0x16,0xf7,0x4b,0x41,0x51,0x56,0x25,
         0x8d,0xac,0x08,0x7e,0xf6,0x74,0x59,0x43,0x10,0x3a,0x00}
    },
    {
        /* No.331 delta:942 weight:1487 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4f381880),
         UINT32_C(0x42fe1804),
         UINT32_C(0x0dc60084),
         UINT32_C(0x44a014b6),
         UINT32_C(0x0b980c36),
         UINT32_C(0x065e0cb2),
         UINT32_C(0x49661432),
         UINT32_C(0x0000f4e4),
         UINT32_C(0x4f38ec64),
         UINT32_C(0x42feece0),
         UINT32_C(0x0dc6f460),
         UINT32_C(0x44a0e052),
         UINT32_C(0x0b98f8d2),
         UINT32_C(0x065ef856),
         UINT32_C(0x4966e0d6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x102441bf),
         UINT32_C(0x2052801d),
         UINT32_C(0x3076c1a2),
         UINT32_C(0x00024c05),
         UINT32_C(0x10260dba),
         UINT32_C(0x2050cc18),
         UINT32_C(0x30748da7),
         UINT32_C(0x201c65cc),
         UINT32_C(0x30382473),
         UINT32_C(0x004ee5d1),
         UINT32_C(0x106aa46e),
         UINT32_C(0x201e29c9),
         UINT32_C(0x303a6876),
         UINT32_C(0x004ca9d4),
         UINT32_C(0x1068e86b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881220),
         UINT32_C(0x3f902940),
         UINT32_C(0x3f983b60),
         UINT32_C(0x3f800126),
         UINT32_C(0x3f881306),
         UINT32_C(0x3f902866),
         UINT32_C(0x3f983a46),
         UINT32_C(0x3f900e32),
         UINT32_C(0x3f981c12),
         UINT32_C(0x3f802772),
         UINT32_C(0x3f883552),
         UINT32_C(0x3f900f14),
         UINT32_C(0x3f981d34),
         UINT32_C(0x3f802654),
         UINT32_C(0x3f883474)},
        UINT32_C(0xfff80000),
        {0x9f,0x3c,0x4e,0x68,0xc4,0xf3,0xb7,0x86,0xdd,0xe6,
         0x06,0x02,0x74,0x0b,0x88,0xbb,0xa0,0x54,0x7d,0xc6,0x00}
    },
    {
        /* No.332 delta:1315 weight:1465 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd9ebe020),
         UINT32_C(0xbcf2d8aa),
         UINT32_C(0x6519388a),
         UINT32_C(0xa8e014c6),
         UINT32_C(0x710bf4e6),
         UINT32_C(0x1412cc6c),
         UINT32_C(0xcdf92c4c),
         UINT32_C(0x00001a2d),
         UINT32_C(0xd9ebfa0d),
         UINT32_C(0xbcf2c287),
         UINT32_C(0x651922a7),
         UINT32_C(0xa8e00eeb),
         UINT32_C(0x710beecb),
         UINT32_C(0x1412d641),
         UINT32_C(0xcdf93661)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0041d1f6),
         UINT32_C(0x003c282f),
         UINT32_C(0x007df9d9),
         UINT32_C(0x82728135),
         UINT32_C(0x823350c3),
         UINT32_C(0x824ea91a),
         UINT32_C(0x820f78ec),
         UINT32_C(0x0002219b),
         UINT32_C(0x0043f06d),
         UINT32_C(0x003e09b4),
         UINT32_C(0x007fd842),
         UINT32_C(0x8270a0ae),
         UINT32_C(0x82317158),
         UINT32_C(0x824c8881),
         UINT32_C(0x820d5977)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8020e8),
         UINT32_C(0x3f801e14),
         UINT32_C(0x3f803efc),
         UINT32_C(0x3fc13940),
         UINT32_C(0x3fc119a8),
         UINT32_C(0x3fc12754),
         UINT32_C(0x3fc107bc),
         UINT32_C(0x3f800110),
         UINT32_C(0x3f8021f8),
         UINT32_C(0x3f801f04),
         UINT32_C(0x3f803fec),
         UINT32_C(0x3fc13850),
         UINT32_C(0x3fc118b8),
         UINT32_C(0x3fc12644),
         UINT32_C(0x3fc106ac)},
        UINT32_C(0xfff80000),
        {0x07,0x6d,0xbc,0xfd,0x70,0x7b,0x0f,0x98,0xc9,0x68,
         0xda,0x90,0x90,0x27,0x32,0x15,0xf5,0x14,0x0c,0x29,0x00}
    },
    {
        /* No.333 delta:820 weight:1577 */
        11213,
        56,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe096b9be),
         UINT32_C(0xdcdb6ce8),
         UINT32_C(0x3c4dd556),
         UINT32_C(0xa7a014d6),
         UINT32_C(0x4736ad68),
         UINT32_C(0x7b7b783e),
         UINT32_C(0x9bedc180),
         UINT32_C(0x00000186),
         UINT32_C(0xe096b838),
         UINT32_C(0xdcdb6d6e),
         UINT32_C(0x3c4dd4d0),
         UINT32_C(0xa7a01550),
         UINT32_C(0x4736acee),
         UINT32_C(0x7b7b79b8),
         UINT32_C(0x9bedc006)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5000a013),
         UINT32_C(0x0002357a),
         UINT32_C(0x50029569),
         UINT32_C(0xa044041e),
         UINT32_C(0xf044a40d),
         UINT32_C(0xa0463164),
         UINT32_C(0xf0469177),
         UINT32_C(0x10012a15),
         UINT32_C(0x40018a06),
         UINT32_C(0x10031f6f),
         UINT32_C(0x4003bf7c),
         UINT32_C(0xb0452e0b),
         UINT32_C(0xe0458e18),
         UINT32_C(0xb0471b71),
         UINT32_C(0xe047bb62)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa80050),
         UINT32_C(0x3f80011a),
         UINT32_C(0x3fa8014a),
         UINT32_C(0x3fd02202),
         UINT32_C(0x3ff82252),
         UINT32_C(0x3fd02318),
         UINT32_C(0x3ff82348),
         UINT32_C(0x3f880095),
         UINT32_C(0x3fa000c5),
         UINT32_C(0x3f88018f),
         UINT32_C(0x3fa001df),
         UINT32_C(0x3fd82297),
         UINT32_C(0x3ff022c7),
         UINT32_C(0x3fd8238d),
         UINT32_C(0x3ff023dd)},
        UINT32_C(0xfff80000),
        {0xde,0x1b,0xa2,0x18,0xa3,0x83,0xee,0xf9,0x62,0xfc,
         0xdf,0x4e,0x92,0x5e,0x6a,0xed,0x9d,0xc5,0x62,0xb1,0x00}
    },
    {
        /* No.334 delta:1674 weight:1425 */
        11213,
        30,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0243c96b),
         UINT32_C(0x115a5aa7),
         UINT32_C(0x131993cc),
         UINT32_C(0xfe0014ea),
         UINT32_C(0xfc43dd81),
         UINT32_C(0xef5a4e4d),
         UINT32_C(0xed198726),
         UINT32_C(0x0000ad8a),
         UINT32_C(0x024364e1),
         UINT32_C(0x115af72d),
         UINT32_C(0x13193e46),
         UINT32_C(0xfe00b960),
         UINT32_C(0xfc43700b),
         UINT32_C(0xef5ae3c7),
         UINT32_C(0xed192aac)},
        {UINT32_C(0x00000000),
         UINT32_C(0x002c01ba),
         UINT32_C(0x004100df),
         UINT32_C(0x006d0165),
         UINT32_C(0x30080068),
         UINT32_C(0x302401d2),
         UINT32_C(0x304900b7),
         UINT32_C(0x3065010d),
         UINT32_C(0x20000018),
         UINT32_C(0x202c01a2),
         UINT32_C(0x204100c7),
         UINT32_C(0x206d017d),
         UINT32_C(0x10080070),
         UINT32_C(0x102401ca),
         UINT32_C(0x104900af),
         UINT32_C(0x10650115)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801600),
         UINT32_C(0x3f802080),
         UINT32_C(0x3f803680),
         UINT32_C(0x3f980400),
         UINT32_C(0x3f981200),
         UINT32_C(0x3f982480),
         UINT32_C(0x3f983280),
         UINT32_C(0x3f900000),
         UINT32_C(0x3f901600),
         UINT32_C(0x3f902080),
         UINT32_C(0x3f903680),
         UINT32_C(0x3f880400),
         UINT32_C(0x3f881200),
         UINT32_C(0x3f882480),
         UINT32_C(0x3f883280)},
        UINT32_C(0xfff80000),
        {0xb4,0xae,0xea,0x67,0xc4,0xae,0x5b,0x04,0x54,0xea,
         0x0d,0x15,0xe5,0x54,0x57,0x6f,0xe7,0xf7,0x7e,0x99,0x00}
    },
    {
        /* No.335 delta:1075 weight:1679 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x51638d87),
         UINT32_C(0xe085c9f6),
         UINT32_C(0xb1e64471),
         UINT32_C(0xb68014f8),
         UINT32_C(0xe7e3997f),
         UINT32_C(0x5605dd0e),
         UINT32_C(0x07665089),
         UINT32_C(0x00007b51),
         UINT32_C(0x5163f6d6),
         UINT32_C(0xe085b2a7),
         UINT32_C(0xb1e63f20),
         UINT32_C(0xb6806fa9),
         UINT32_C(0xe7e3e22e),
         UINT32_C(0x5605a65f),
         UINT32_C(0x07662bd8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40386133),
         UINT32_C(0x00640036),
         UINT32_C(0x405c6105),
         UINT32_C(0x0801600f),
         UINT32_C(0x4839013c),
         UINT32_C(0x08656039),
         UINT32_C(0x485d010a),
         UINT32_C(0x0003015b),
         UINT32_C(0x403b6068),
         UINT32_C(0x0067016d),
         UINT32_C(0x405f605e),
         UINT32_C(0x08026154),
         UINT32_C(0x483a0067),
         UINT32_C(0x08666162),
         UINT32_C(0x485e0051)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa01c30),
         UINT32_C(0x3f803200),
         UINT32_C(0x3fa02e30),
         UINT32_C(0x3f8400b0),
         UINT32_C(0x3fa41c80),
         UINT32_C(0x3f8432b0),
         UINT32_C(0x3fa42e80),
         UINT32_C(0x3f800180),
         UINT32_C(0x3fa01db0),
         UINT32_C(0x3f803380),
         UINT32_C(0x3fa02fb0),
         UINT32_C(0x3f840130),
         UINT32_C(0x3fa41d00),
         UINT32_C(0x3f843330),
         UINT32_C(0x3fa42f00)},
        UINT32_C(0xfff80000),
        {0x0b,0x36,0x2f,0x64,0x4c,0x2c,0xf2,0x85,0xc3,0x18,
         0x3a,0x0b,0x27,0x8e,0x6b,0xff,0x2a,0xaf,0xb1,0xa1,0x00}
    },
    {
        /* No.336 delta:1464 weight:1505 */
        11213,
        20,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd4f52a80),
         UINT32_C(0xca4a05ad),
         UINT32_C(0x1ebf2f2d),
         UINT32_C(0x12b0150f),
         UINT32_C(0xc6453f8f),
         UINT32_C(0xd8fa10a2),
         UINT32_C(0x0c0f3a22),
         UINT32_C(0x00003ef1),
         UINT32_C(0xd4f51471),
         UINT32_C(0xca4a3b5c),
         UINT32_C(0x1ebf11dc),
         UINT32_C(0x12b02bfe),
         UINT32_C(0xc645017e),
         UINT32_C(0xd8fa2e53),
         UINT32_C(0x0c0f04d3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0067293e),
         UINT32_C(0x503b404a),
         UINT32_C(0x505c6974),
         UINT32_C(0x001e11b7),
         UINT32_C(0x00793889),
         UINT32_C(0x502551fd),
         UINT32_C(0x504278c3),
         UINT32_C(0x0005001b),
         UINT32_C(0x00622925),
         UINT32_C(0x503e4051),
         UINT32_C(0x5059696f),
         UINT32_C(0x001b11ac),
         UINT32_C(0x007c3892),
         UINT32_C(0x502051e6),
         UINT32_C(0x504778d8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803394),
         UINT32_C(0x3fa81da0),
         UINT32_C(0x3fa82e34),
         UINT32_C(0x3f800f08),
         UINT32_C(0x3f803c9c),
         UINT32_C(0x3fa812a8),
         UINT32_C(0x3fa8213c),
         UINT32_C(0x3f800280),
         UINT32_C(0x3f803114),
         UINT32_C(0x3fa81f20),
         UINT32_C(0x3fa82cb4),
         UINT32_C(0x3f800d88),
         UINT32_C(0x3f803e1c),
         UINT32_C(0x3fa81028),
         UINT32_C(0x3fa823bc)},
        UINT32_C(0xfff80000),
        {0xad,0x6a,0xc9,0xf1,0xb0,0xb0,0xaf,0x19,0x40,0x96,
         0x82,0xbd,0x6b,0x7f,0xd6,0x80,0x4f,0xc9,0xe2,0xb4,0x00}
    },
    {
        /* No.337 delta:1298 weight:1167 */
        11213,
        36,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb6de49a0),
         UINT32_C(0x3acc1f09),
         UINT32_C(0x8c1256a9),
         UINT32_C(0xf690151b),
         UINT32_C(0x404e5cbb),
         UINT32_C(0xcc5c0a12),
         UINT32_C(0x7a8243b2),
         UINT32_C(0x00004270),
         UINT32_C(0xb6de0bd0),
         UINT32_C(0x3acc5d79),
         UINT32_C(0x8c1214d9),
         UINT32_C(0xf690576b),
         UINT32_C(0x404e1ecb),
         UINT32_C(0xcc5c4862),
         UINT32_C(0x7a8201c2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007e419e),
         UINT32_C(0x000200d5),
         UINT32_C(0x007c414b),
         UINT32_C(0x100101ba),
         UINT32_C(0x107f4024),
         UINT32_C(0x1003016f),
         UINT32_C(0x107d40f1),
         UINT32_C(0x0001e019),
         UINT32_C(0x007fa187),
         UINT32_C(0x0003e0cc),
         UINT32_C(0x007da152),
         UINT32_C(0x1000e1a3),
         UINT32_C(0x107ea03d),
         UINT32_C(0x1002e176),
         UINT32_C(0x107ca0e8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803f20),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f803e20),
         UINT32_C(0x3f880080),
         UINT32_C(0x3f883fa0),
         UINT32_C(0x3f880180),
         UINT32_C(0x3f883ea0),
         UINT32_C(0x3f8000f0),
         UINT32_C(0x3f803fd0),
         UINT32_C(0x3f8001f0),
         UINT32_C(0x3f803ed0),
         UINT32_C(0x3f880070),
         UINT32_C(0x3f883f50),
         UINT32_C(0x3f880170),
         UINT32_C(0x3f883e50)},
        UINT32_C(0xfff80000),
        {0x78,0xa4,0xac,0x37,0xf1,0x2d,0xc7,0xe4,0x78,0x4d,
         0x40,0xea,0x5f,0xb5,0x65,0x8c,0xb3,0xfe,0x6e,0x11,0x00}
    },
    {
        /* No.338 delta:1869 weight:1493 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x557ccf79),
         UINT32_C(0x92c336a6),
         UINT32_C(0xc7bff9df),
         UINT32_C(0xceb01526),
         UINT32_C(0x9bccda5f),
         UINT32_C(0x5c732380),
         UINT32_C(0x090fecf9),
         UINT32_C(0x000054db),
         UINT32_C(0x557c9ba2),
         UINT32_C(0x92c3627d),
         UINT32_C(0xc7bfad04),
         UINT32_C(0xceb041fd),
         UINT32_C(0x9bcc8e84),
         UINT32_C(0x5c73775b),
         UINT32_C(0x090fb822)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9907821a),
         UINT32_C(0x2113e1ad),
         UINT32_C(0xb81463b7),
         UINT32_C(0x28806039),
         UINT32_C(0xb187e223),
         UINT32_C(0x09938194),
         UINT32_C(0x9094038e),
         UINT32_C(0x7064d35e),
         UINT32_C(0xe9635144),
         UINT32_C(0x517732f3),
         UINT32_C(0xc870b0e9),
         UINT32_C(0x58e4b367),
         UINT32_C(0xc1e3317d),
         UINT32_C(0x79f752ca),
         UINT32_C(0xe0f0d0d0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fcc83c1),
         UINT32_C(0x3f9089f0),
         UINT32_C(0x3fdc0a31),
         UINT32_C(0x3f944030),
         UINT32_C(0x3fd8c3f1),
         UINT32_C(0x3f84c9c0),
         UINT32_C(0x3fc84a01),
         UINT32_C(0x3fb83269),
         UINT32_C(0x3ff4b1a8),
         UINT32_C(0x3fa8bb99),
         UINT32_C(0x3fe43858),
         UINT32_C(0x3fac7259),
         UINT32_C(0x3fe0f198),
         UINT32_C(0x3fbcfba9),
         UINT32_C(0x3ff07868)},
        UINT32_C(0xfff80000),
        {0xce,0x65,0xce,0xc4,0x70,0xc0,0x87,0xff,0x4d,0x30,
         0x57,0xe1,0x4e,0x54,0x2a,0x2e,0x65,0x2d,0x07,0xd9,0x00}
    },
    {
        /* No.339 delta:802 weight:1691 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe347fae3),
         UINT32_C(0xaa93278b),
         UINT32_C(0x49d4dd68),
         UINT32_C(0xbcb01531),
         UINT32_C(0x5ff7efd2),
         UINT32_C(0x162332ba),
         UINT32_C(0xf564c859),
         UINT32_C(0x000084b0),
         UINT32_C(0xe3477e53),
         UINT32_C(0xaa93a33b),
         UINT32_C(0x49d459d8),
         UINT32_C(0xbcb09181),
         UINT32_C(0x5ff76b62),
         UINT32_C(0x1623b60a),
         UINT32_C(0xf5644ce9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x01401c77),
         UINT32_C(0x10000206),
         UINT32_C(0x11401e71),
         UINT32_C(0x9000019b),
         UINT32_C(0x91401dec),
         UINT32_C(0x8000039d),
         UINT32_C(0x81401fea),
         UINT32_C(0x3101a0f2),
         UINT32_C(0x3041bc85),
         UINT32_C(0x2101a2f4),
         UINT32_C(0x2041be83),
         UINT32_C(0xa101a169),
         UINT32_C(0xa041bd1e),
         UINT32_C(0xb101a36f),
         UINT32_C(0xb041bf18)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80a00e),
         UINT32_C(0x3f880001),
         UINT32_C(0x3f88a00f),
         UINT32_C(0x3fc80000),
         UINT32_C(0x3fc8a00e),
         UINT32_C(0x3fc00001),
         UINT32_C(0x3fc0a00f),
         UINT32_C(0x3f9880d0),
         UINT32_C(0x3f9820de),
         UINT32_C(0x3f9080d1),
         UINT32_C(0x3f9020df),
         UINT32_C(0x3fd080d0),
         UINT32_C(0x3fd020de),
         UINT32_C(0x3fd880d1),
         UINT32_C(0x3fd820df)},
        UINT32_C(0xfff80000),
        {0xc1,0x7e,0xb1,0x45,0xa6,0x8c,0x0c,0xa0,0xc5,0x7f,
         0x0f,0xc0,0x8a,0x9e,0xb3,0x56,0x33,0x68,0x3b,0x18,0x00}
    },
    {
        /* No.340 delta:2189 weight:1223 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc7331da0),
         UINT32_C(0x6241ad6d),
         UINT32_C(0xa572b0cd),
         UINT32_C(0x11b0154f),
         UINT32_C(0xd68308ef),
         UINT32_C(0x73f1b822),
         UINT32_C(0xb4c2a582),
         UINT32_C(0x00007d34),
         UINT32_C(0xc7336094),
         UINT32_C(0x6241d059),
         UINT32_C(0xa572cdf9),
         UINT32_C(0x11b0687b),
         UINT32_C(0xd68375db),
         UINT32_C(0x73f1c516),
         UINT32_C(0xb4c2d8b6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0d02153a),
         UINT32_C(0x0a004409),
         UINT32_C(0x07025133),
         UINT32_C(0x038372be),
         UINT32_C(0x0e816784),
         UINT32_C(0x098336b7),
         UINT32_C(0x0481238d),
         UINT32_C(0x01001a1c),
         UINT32_C(0x0c020f26),
         UINT32_C(0x0b005e15),
         UINT32_C(0x06024b2f),
         UINT32_C(0x028368a2),
         UINT32_C(0x0f817d98),
         UINT32_C(0x08832cab),
         UINT32_C(0x05813991)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f86810a),
         UINT32_C(0x3f850022),
         UINT32_C(0x3f838128),
         UINT32_C(0x3f81c1b9),
         UINT32_C(0x3f8740b3),
         UINT32_C(0x3f84c19b),
         UINT32_C(0x3f824091),
         UINT32_C(0x3f80800d),
         UINT32_C(0x3f860107),
         UINT32_C(0x3f85802f),
         UINT32_C(0x3f830125),
         UINT32_C(0x3f8141b4),
         UINT32_C(0x3f87c0be),
         UINT32_C(0x3f844196),
         UINT32_C(0x3f82c09c)},
        UINT32_C(0xfff80000),
        {0xd7,0x99,0xdc,0x3d,0xe6,0x75,0xb5,0x4d,0xc6,0x0a,
         0x51,0x47,0xac,0x0f,0x03,0x6f,0xec,0x35,0x6b,0x7a,0x00}
    },
    {
        /* No.341 delta:1415 weight:1677 */
        11213,
        93,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe5a8fe2d),
         UINT32_C(0x99e7dc90),
         UINT32_C(0x7c4f22bd),
         UINT32_C(0x7d101555),
         UINT32_C(0x98b8eb78),
         UINT32_C(0xe4f7c9c5),
         UINT32_C(0x015f37e8),
         UINT32_C(0x00008141),
         UINT32_C(0xe5a87f6c),
         UINT32_C(0x99e75dd1),
         UINT32_C(0x7c4fa3fc),
         UINT32_C(0x7d109414),
         UINT32_C(0x98b86a39),
         UINT32_C(0xe4f74884),
         UINT32_C(0x015fb6a9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006c4197),
         UINT32_C(0x001001f2),
         UINT32_C(0x007c4065),
         UINT32_C(0x000200aa),
         UINT32_C(0x006e413d),
         UINT32_C(0x00120158),
         UINT32_C(0x007e40cf),
         UINT32_C(0x1043801c),
         UINT32_C(0x102fc18b),
         UINT32_C(0x105381ee),
         UINT32_C(0x103fc079),
         UINT32_C(0x104180b6),
         UINT32_C(0x102dc121),
         UINT32_C(0x10518144),
         UINT32_C(0x103dc0d3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803620),
         UINT32_C(0x3f800800),
         UINT32_C(0x3f803e20),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f803720),
         UINT32_C(0x3f800900),
         UINT32_C(0x3f803f20),
         UINT32_C(0x3f8821c0),
         UINT32_C(0x3f8817e0),
         UINT32_C(0x3f8829c0),
         UINT32_C(0x3f881fe0),
         UINT32_C(0x3f8820c0),
         UINT32_C(0x3f8816e0),
         UINT32_C(0x3f8828c0),
         UINT32_C(0x3f881ee0)},
        UINT32_C(0xfff80000),
        {0x61,0x5c,0xdd,0x3f,0xcb,0x58,0xda,0xf6,0x62,0xe9,
         0x0d,0xb8,0x14,0xbd,0x63,0x5b,0x3e,0xb3,0x37,0xce,0x00}
    },
    {
        /* No.342 delta:706 weight:1683 */
        11213,
        68,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x72c9c252),
         UINT32_C(0xa7c90593),
         UINT32_C(0xd500c7c1),
         UINT32_C(0x6f701562),
         UINT32_C(0x1db9d730),
         UINT32_C(0xc8b910f1),
         UINT32_C(0xba70d2a3),
         UINT32_C(0x0000a0f4),
         UINT32_C(0x72c962a6),
         UINT32_C(0xa7c9a567),
         UINT32_C(0xd5006735),
         UINT32_C(0x6f70b596),
         UINT32_C(0x1db977c4),
         UINT32_C(0xc8b9b005),
         UINT32_C(0xba707257)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4002049e),
         UINT32_C(0x4410ce1d),
         UINT32_C(0x0412ca83),
         UINT32_C(0x1009e50a),
         UINT32_C(0x500be194),
         UINT32_C(0x54192b17),
         UINT32_C(0x141b2f89),
         UINT32_C(0x4001ac65),
         UINT32_C(0x0003a8fb),
         UINT32_C(0x04116278),
         UINT32_C(0x441366e6),
         UINT32_C(0x5008496f),
         UINT32_C(0x100a4df1),
         UINT32_C(0x14188772),
         UINT32_C(0x541a83ec)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00102),
         UINT32_C(0x3fa20867),
         UINT32_C(0x3f820965),
         UINT32_C(0x3f8804f2),
         UINT32_C(0x3fa805f0),
         UINT32_C(0x3faa0c95),
         UINT32_C(0x3f8a0d97),
         UINT32_C(0x3fa000d6),
         UINT32_C(0x3f8001d4),
         UINT32_C(0x3f8208b1),
         UINT32_C(0x3fa209b3),
         UINT32_C(0x3fa80424),
         UINT32_C(0x3f880526),
         UINT32_C(0x3f8a0c43),
         UINT32_C(0x3faa0d41)},
        UINT32_C(0xfff80000),
        {0xac,0x26,0x73,0x72,0xdc,0x6b,0xa4,0x2c,0xdb,0x49,
         0x64,0xd3,0x82,0x95,0x07,0x34,0xee,0x5c,0xc9,0x8b,0x00}
    },
    {
        /* No.343 delta:1208 weight:1535 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x469f7107),
         UINT32_C(0x71bce1ea),
         UINT32_C(0x372390ed),
         UINT32_C(0x05c01570),
         UINT32_C(0x435f6477),
         UINT32_C(0x747cf49a),
         UINT32_C(0x32e3859d),
         UINT32_C(0x00000429),
         UINT32_C(0x469f752e),
         UINT32_C(0x71bce5c3),
         UINT32_C(0x372394c4),
         UINT32_C(0x05c01159),
         UINT32_C(0x435f605e),
         UINT32_C(0x747cf0b3),
         UINT32_C(0x32e381b4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0051133a),
         UINT32_C(0xa0000017),
         UINT32_C(0xa051132d),
         UINT32_C(0x30188495),
         UINT32_C(0x304997af),
         UINT32_C(0x90188482),
         UINT32_C(0x904997b8),
         UINT32_C(0x00899c11),
         UINT32_C(0x00d88f2b),
         UINT32_C(0xa0899c06),
         UINT32_C(0xa0d88f3c),
         UINT32_C(0x30911884),
         UINT32_C(0x30c00bbe),
         UINT32_C(0x90911893),
         UINT32_C(0x90c00ba9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802889),
         UINT32_C(0x3fd00000),
         UINT32_C(0x3fd02889),
         UINT32_C(0x3f980c42),
         UINT32_C(0x3f9824cb),
         UINT32_C(0x3fc80c42),
         UINT32_C(0x3fc824cb),
         UINT32_C(0x3f8044ce),
         UINT32_C(0x3f806c47),
         UINT32_C(0x3fd044ce),
         UINT32_C(0x3fd06c47),
         UINT32_C(0x3f98488c),
         UINT32_C(0x3f986005),
         UINT32_C(0x3fc8488c),
         UINT32_C(0x3fc86005)},
        UINT32_C(0xfff80000),
        {0x6b,0x61,0x0b,0x45,0x93,0xc7,0x5b,0x8e,0xaf,0x89,
         0x6d,0x89,0xff,0xb6,0x38,0x9e,0x2e,0xee,0x76,0x8f,0x00}
    },
    {
        /* No.344 delta:1500 weight:1641 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8bc3dfcb),
         UINT32_C(0x91944dcf),
         UINT32_C(0x1a579204),
         UINT32_C(0x4c101581),
         UINT32_C(0xc7d3ca4a),
         UINT32_C(0xdd84584e),
         UINT32_C(0x56478785),
         UINT32_C(0x000012f3),
         UINT32_C(0x8bc3cd38),
         UINT32_C(0x91945f3c),
         UINT32_C(0x1a5780f7),
         UINT32_C(0x4c100772),
         UINT32_C(0xc7d3d8b9),
         UINT32_C(0xdd844abd),
         UINT32_C(0x56479576)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004c809c),
         UINT32_C(0x0038c1a2),
         UINT32_C(0x0074413e),
         UINT32_C(0x00084076),
         UINT32_C(0x0044c0ea),
         UINT32_C(0x003081d4),
         UINT32_C(0x007c0148),
         UINT32_C(0x22100010),
         UINT32_C(0x225c808c),
         UINT32_C(0x2228c1b2),
         UINT32_C(0x2264412e),
         UINT32_C(0x22184066),
         UINT32_C(0x2254c0fa),
         UINT32_C(0x222081c4),
         UINT32_C(0x226c0158)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802640),
         UINT32_C(0x3f801c60),
         UINT32_C(0x3f803a20),
         UINT32_C(0x3f800420),
         UINT32_C(0x3f802260),
         UINT32_C(0x3f801840),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f910800),
         UINT32_C(0x3f912e40),
         UINT32_C(0x3f911460),
         UINT32_C(0x3f913220),
         UINT32_C(0x3f910c20),
         UINT32_C(0x3f912a60),
         UINT32_C(0x3f911040),
         UINT32_C(0x3f913600)},
        UINT32_C(0xfff80000),
        {0x8b,0x8d,0x88,0xed,0x19,0xc2,0x91,0xc6,0xd2,0x10,
         0x21,0xea,0xf5,0x4b,0x24,0x19,0x15,0x85,0x9c,0x0d,0x00}
    },
    {
        /* No.345 delta:874 weight:1661 */
        11213,
        75,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa6151454),
         UINT32_C(0xff23562b),
         UINT32_C(0x5936427f),
         UINT32_C(0xf260159a),
         UINT32_C(0x547501ce),
         UINT32_C(0x0d4343b1),
         UINT32_C(0xab5657e5),
         UINT32_C(0x00005ee0),
         UINT32_C(0xa6154ab4),
         UINT32_C(0xff2308cb),
         UINT32_C(0x59361c9f),
         UINT32_C(0xf2604b7a),
         UINT32_C(0x54755f2e),
         UINT32_C(0x0d431d51),
         UINT32_C(0xab560905)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9010c13b),
         UINT32_C(0x20020407),
         UINT32_C(0xb012c53c),
         UINT32_C(0x400032d6),
         UINT32_C(0xd010f3ed),
         UINT32_C(0x600236d1),
         UINT32_C(0xf012f7ea),
         UINT32_C(0x0001981e),
         UINT32_C(0x90115925),
         UINT32_C(0x20039c19),
         UINT32_C(0xb0135d22),
         UINT32_C(0x4001aac8),
         UINT32_C(0xd0116bf3),
         UINT32_C(0x6003aecf),
         UINT32_C(0xf0136ff4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc80860),
         UINT32_C(0x3f900102),
         UINT32_C(0x3fd80962),
         UINT32_C(0x3fa00019),
         UINT32_C(0x3fe80879),
         UINT32_C(0x3fb0011b),
         UINT32_C(0x3ff8097b),
         UINT32_C(0x3f8000cc),
         UINT32_C(0x3fc808ac),
         UINT32_C(0x3f9001ce),
         UINT32_C(0x3fd809ae),
         UINT32_C(0x3fa000d5),
         UINT32_C(0x3fe808b5),
         UINT32_C(0x3fb001d7),
         UINT32_C(0x3ff809b7)},
        UINT32_C(0xfff80000),
        {0xe5,0xb9,0xf4,0xf6,0xd6,0x20,0x83,0x08,0x4b,0xfe,
         0x22,0xa5,0x3e,0xe1,0xfa,0xc1,0x74,0x64,0xc1,0xd4,0x00}
    },
    {
        /* No.346 delta:668 weight:1631 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6cdca230),
         UINT32_C(0x1e5aef28),
         UINT32_C(0x72864d18),
         UINT32_C(0xff5015aa),
         UINT32_C(0x938cb79a),
         UINT32_C(0xe10afa82),
         UINT32_C(0x8dd658b2),
         UINT32_C(0x0000a0f4),
         UINT32_C(0x6cdc02c4),
         UINT32_C(0x1e5a4fdc),
         UINT32_C(0x7286edec),
         UINT32_C(0xff50b55e),
         UINT32_C(0x938c176e),
         UINT32_C(0xe10a5a76),
         UINT32_C(0x8dd6f846)},
        {UINT32_C(0x00000000),
         UINT32_C(0x50031033),
         UINT32_C(0x4000e967),
         UINT32_C(0x1003f954),
         UINT32_C(0x0016840e),
         UINT32_C(0x5015943d),
         UINT32_C(0x40166d69),
         UINT32_C(0x10157d5a),
         UINT32_C(0x00021c02),
         UINT32_C(0x50010c31),
         UINT32_C(0x4002f565),
         UINT32_C(0x1001e556),
         UINT32_C(0x0014980c),
         UINT32_C(0x5017883f),
         UINT32_C(0x4014716b),
         UINT32_C(0x10176158)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa80188),
         UINT32_C(0x3fa00074),
         UINT32_C(0x3f8801fc),
         UINT32_C(0x3f800b42),
         UINT32_C(0x3fa80aca),
         UINT32_C(0x3fa00b36),
         UINT32_C(0x3f880abe),
         UINT32_C(0x3f80010e),
         UINT32_C(0x3fa80086),
         UINT32_C(0x3fa0017a),
         UINT32_C(0x3f8800f2),
         UINT32_C(0x3f800a4c),
         UINT32_C(0x3fa80bc4),
         UINT32_C(0x3fa00a38),
         UINT32_C(0x3f880bb0)},
        UINT32_C(0xfff80000),
        {0x16,0xc9,0xc2,0xe3,0xc9,0x45,0xe3,0x66,0x08,0x01,
         0xb7,0x05,0xc4,0x33,0xde,0xa4,0x72,0x32,0x0c,0x60,0x00}
    },
    {
        /* No.347 delta:672 weight:1377 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x64f6ccf6),
         UINT32_C(0xa5446450),
         UINT32_C(0xc1b2a8a6),
         UINT32_C(0xc7e015bb),
         UINT32_C(0xa316d94d),
         UINT32_C(0x62a471eb),
         UINT32_C(0x0652bd1d),
         UINT32_C(0x0000ba59),
         UINT32_C(0x64f676af),
         UINT32_C(0xa544de09),
         UINT32_C(0xc1b212ff),
         UINT32_C(0xc7e0afe2),
         UINT32_C(0xa3166314),
         UINT32_C(0x62a4cbb2),
         UINT32_C(0x06520744)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1038517d),
         UINT32_C(0x9062008e),
         UINT32_C(0x805a51f3),
         UINT32_C(0x004064af),
         UINT32_C(0x107835d2),
         UINT32_C(0x90226421),
         UINT32_C(0x801a355c),
         UINT32_C(0x20208015),
         UINT32_C(0x3018d168),
         UINT32_C(0xb042809b),
         UINT32_C(0xa07ad1e6),
         UINT32_C(0x2060e4ba),
         UINT32_C(0x3058b5c7),
         UINT32_C(0xb002e434),
         UINT32_C(0xa03ab549)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881c28),
         UINT32_C(0x3fc83100),
         UINT32_C(0x3fc02d28),
         UINT32_C(0x3f802032),
         UINT32_C(0x3f883c1a),
         UINT32_C(0x3fc81132),
         UINT32_C(0x3fc00d1a),
         UINT32_C(0x3f901040),
         UINT32_C(0x3f980c68),
         UINT32_C(0x3fd82140),
         UINT32_C(0x3fd03d68),
         UINT32_C(0x3f903072),
         UINT32_C(0x3f982c5a),
         UINT32_C(0x3fd80172),
         UINT32_C(0x3fd01d5a)},
        UINT32_C(0xfff80000),
        {0x85,0xa9,0x7e,0x54,0xab,0x3e,0x90,0xf7,0xf7,0x23,
         0x6e,0xa4,0xc4,0x27,0x65,0xe3,0xda,0x9b,0x92,0xdf,0x00}
    },
    {
        /* No.348 delta:580 weight:1491 */
        11213,
        81,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6280169c),
         UINT32_C(0x54214e05),
         UINT32_C(0x36a15899),
         UINT32_C(0x513015c8),
         UINT32_C(0x33b00354),
         UINT32_C(0x05115bcd),
         UINT32_C(0x67914d51),
         UINT32_C(0x0000a747),
         UINT32_C(0x6280b1db),
         UINT32_C(0x5421e942),
         UINT32_C(0x36a1ffde),
         UINT32_C(0x5130b28f),
         UINT32_C(0x33b0a413),
         UINT32_C(0x0511fc8a),
         UINT32_C(0x6791ea16)},
        {UINT32_C(0x00000000),
         UINT32_C(0x204441be),
         UINT32_C(0x500204e2),
         UINT32_C(0x7046455c),
         UINT32_C(0x180101d8),
         UINT32_C(0x38454066),
         UINT32_C(0x4803053a),
         UINT32_C(0x68474484),
         UINT32_C(0x0002126c),
         UINT32_C(0x204653d2),
         UINT32_C(0x5000168e),
         UINT32_C(0x70445730),
         UINT32_C(0x180313b4),
         UINT32_C(0x3847520a),
         UINT32_C(0x48011756),
         UINT32_C(0x684556e8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902220),
         UINT32_C(0x3fa80102),
         UINT32_C(0x3fb82322),
         UINT32_C(0x3f8c0080),
         UINT32_C(0x3f9c22a0),
         UINT32_C(0x3fa40182),
         UINT32_C(0x3fb423a2),
         UINT32_C(0x3f800109),
         UINT32_C(0x3f902329),
         UINT32_C(0x3fa8000b),
         UINT32_C(0x3fb8222b),
         UINT32_C(0x3f8c0189),
         UINT32_C(0x3f9c23a9),
         UINT32_C(0x3fa4008b),
         UINT32_C(0x3fb422ab)},
        UINT32_C(0xfff80000),
        {0x72,0xe8,0x94,0x01,0x7c,0xd8,0x51,0xed,0xa5,0xfb,
         0xb8,0x7b,0x35,0xc5,0xa7,0xaa,0x1f,0x3b,0xb8,0x2b,0x00}
    },
    {
        /* No.349 delta:846 weight:1637 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe7441d0e),
         UINT32_C(0x0fc4362c),
         UINT32_C(0xe8802b22),
         UINT32_C(0xc44015df),
         UINT32_C(0x230408d1),
         UINT32_C(0xcb8423f3),
         UINT32_C(0x2cc03efd),
         UINT32_C(0x000008b0),
         UINT32_C(0xe74415be),
         UINT32_C(0x0fc43e9c),
         UINT32_C(0xe8802392),
         UINT32_C(0xc4401d6f),
         UINT32_C(0x23040061),
         UINT32_C(0xcb842b43),
         UINT32_C(0x2cc0364d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x100330b2),
         UINT32_C(0x8001a194),
         UINT32_C(0x90029126),
         UINT32_C(0x5000dc15),
         UINT32_C(0x4003eca7),
         UINT32_C(0xd0017d81),
         UINT32_C(0xc0024d33),
         UINT32_C(0x4000140f),
         UINT32_C(0x500324bd),
         UINT32_C(0xc001b59b),
         UINT32_C(0xd0028529),
         UINT32_C(0x1000c81a),
         UINT32_C(0x0003f8a8),
         UINT32_C(0x9001698e),
         UINT32_C(0x8002593c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880198),
         UINT32_C(0x3fc000d0),
         UINT32_C(0x3fc80148),
         UINT32_C(0x3fa8006e),
         UINT32_C(0x3fa001f6),
         UINT32_C(0x3fe800be),
         UINT32_C(0x3fe00126),
         UINT32_C(0x3fa0000a),
         UINT32_C(0x3fa80192),
         UINT32_C(0x3fe000da),
         UINT32_C(0x3fe80142),
         UINT32_C(0x3f880064),
         UINT32_C(0x3f8001fc),
         UINT32_C(0x3fc800b4),
         UINT32_C(0x3fc0012c)},
        UINT32_C(0xfff80000),
        {0x5c,0xa1,0x5f,0x80,0x8d,0x97,0x0a,0xef,0x81,0xeb,
         0x8f,0x27,0x82,0xff,0x97,0x46,0xab,0xd8,0xa0,0xb6,0x00}
    },
    {
        /* No.350 delta:2671 weight:847 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x697b76cd),
         UINT32_C(0xbc944c5f),
         UINT32_C(0xd5ef3a92),
         UINT32_C(0xa4b015e2),
         UINT32_C(0xcdcb632f),
         UINT32_C(0x182459bd),
         UINT32_C(0x715f2f70),
         UINT32_C(0x0000113d),
         UINT32_C(0x697b67f0),
         UINT32_C(0xbc945d62),
         UINT32_C(0xd5ef2baf),
         UINT32_C(0xa4b004df),
         UINT32_C(0xcdcb7212),
         UINT32_C(0x18244880),
         UINT32_C(0x715f3e4d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x9604f13a),
         UINT32_C(0x0c4aa42b),
         UINT32_C(0x9a4e5511),
         UINT32_C(0x0b2c0417),
         UINT32_C(0x9d28f52d),
         UINT32_C(0x0766a03c),
         UINT32_C(0x91625106),
         UINT32_C(0x07142084),
         UINT32_C(0x9110d1be),
         UINT32_C(0x0b5e84af),
         UINT32_C(0x9d5a7595),
         UINT32_C(0x0c382493),
         UINT32_C(0x9a3cd5a9),
         UINT32_C(0x007280b8),
         UINT32_C(0x96767182)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fcb0278),
         UINT32_C(0x3f862552),
         UINT32_C(0x3fcd272a),
         UINT32_C(0x3f859602),
         UINT32_C(0x3fce947a),
         UINT32_C(0x3f83b350),
         UINT32_C(0x3fc8b128),
         UINT32_C(0x3f838a10),
         UINT32_C(0x3fc88868),
         UINT32_C(0x3f85af42),
         UINT32_C(0x3fcead3a),
         UINT32_C(0x3f861c12),
         UINT32_C(0x3fcd1e6a),
         UINT32_C(0x3f803940),
         UINT32_C(0x3fcb3b38)},
        UINT32_C(0xfff80000),
        {0xf9,0xc5,0x41,0xba,0xb9,0x62,0xc3,0x80,0x73,0xc1,
         0xf6,0xc6,0x28,0x01,0x75,0x10,0x4a,0x59,0xaa,0x76,0x00}
    },
    {
        /* No.351 delta:884 weight:1701 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd5645896),
         UINT32_C(0x731c013c),
         UINT32_C(0xa67859aa),
         UINT32_C(0x162015f1),
         UINT32_C(0xc3444d67),
         UINT32_C(0x653c14cd),
         UINT32_C(0xb0584c5b),
         UINT32_C(0x00004a2c),
         UINT32_C(0xd56412ba),
         UINT32_C(0x731c4b10),
         UINT32_C(0xa6781386),
         UINT32_C(0x16205fdd),
         UINT32_C(0xc344074b),
         UINT32_C(0x653c5ee1),
         UINT32_C(0xb0580677)},
        {UINT32_C(0x00000000),
         UINT32_C(0x41424556),
         UINT32_C(0x70002053),
         UINT32_C(0x31426505),
         UINT32_C(0x3002c01e),
         UINT32_C(0x71408548),
         UINT32_C(0x4002e04d),
         UINT32_C(0x0140a51b),
         UINT32_C(0x20007219),
         UINT32_C(0x6142374f),
         UINT32_C(0x5000524a),
         UINT32_C(0x1142171c),
         UINT32_C(0x1002b207),
         UINT32_C(0x5140f751),
         UINT32_C(0x60029254),
         UINT32_C(0x2140d702)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0a122),
         UINT32_C(0x3fb80010),
         UINT32_C(0x3f98a132),
         UINT32_C(0x3f980160),
         UINT32_C(0x3fb8a042),
         UINT32_C(0x3fa00170),
         UINT32_C(0x3f80a052),
         UINT32_C(0x3f900039),
         UINT32_C(0x3fb0a11b),
         UINT32_C(0x3fa80029),
         UINT32_C(0x3f88a10b),
         UINT32_C(0x3f880159),
         UINT32_C(0x3fa8a07b),
         UINT32_C(0x3fb00149),
         UINT32_C(0x3f90a06b)},
        UINT32_C(0xfff80000),
        {0x6e,0x2b,0xde,0x14,0x2d,0xc6,0x7c,0x00,0x5d,0x85,
         0xf5,0xbd,0x5a,0xb3,0x43,0x8c,0x46,0xf2,0x80,0xa2,0x00}
    },
    {
        /* No.352 delta:1012 weight:1759 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8d0371f4),
         UINT32_C(0x25227130),
         UINT32_C(0xa82100c4),
         UINT32_C(0xb8e0160d),
         UINT32_C(0x35e367f9),
         UINT32_C(0x9dc2673d),
         UINT32_C(0x10c116c9),
         UINT32_C(0x00003be5),
         UINT32_C(0x8d034a11),
         UINT32_C(0x25224ad5),
         UINT32_C(0xa8213b21),
         UINT32_C(0xb8e02de8),
         UINT32_C(0x35e35c1c),
         UINT32_C(0x9dc25cd8),
         UINT32_C(0x10c12d2c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x102761be),
         UINT32_C(0x007611f1),
         UINT32_C(0x1051704f),
         UINT32_C(0x00484bfb),
         UINT32_C(0x106f2a45),
         UINT32_C(0x003e5a0a),
         UINT32_C(0x10193bb4),
         UINT32_C(0x48001806),
         UINT32_C(0x582779b8),
         UINT32_C(0x487609f7),
         UINT32_C(0x58516849),
         UINT32_C(0x484853fd),
         UINT32_C(0x586f3243),
         UINT32_C(0x483e420c),
         UINT32_C(0x581923b2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8813b0),
         UINT32_C(0x3f803b08),
         UINT32_C(0x3f8828b8),
         UINT32_C(0x3f802425),
         UINT32_C(0x3f883795),
         UINT32_C(0x3f801f2d),
         UINT32_C(0x3f880c9d),
         UINT32_C(0x3fa4000c),
         UINT32_C(0x3fac13bc),
         UINT32_C(0x3fa43b04),
         UINT32_C(0x3fac28b4),
         UINT32_C(0x3fa42429),
         UINT32_C(0x3fac3799),
         UINT32_C(0x3fa41f21),
         UINT32_C(0x3fac0c91)},
        UINT32_C(0xfff80000),
        {0x14,0x60,0xb3,0x50,0x2c,0x67,0xc9,0xec,0x2a,0x2b,
         0xcf,0xc2,0x36,0xbf,0xe3,0xbc,0xe8,0xa7,0x8b,0x14,0x00}
    },
    {
        /* No.353 delta:865 weight:1537 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf28f5762),
         UINT32_C(0x10a3e4bb),
         UINT32_C(0xe22cb3d9),
         UINT32_C(0xa1b01610),
         UINT32_C(0x533f4172),
         UINT32_C(0xb113f2ab),
         UINT32_C(0x439ca5c9),
         UINT32_C(0x0000b547),
         UINT32_C(0xf28fe225),
         UINT32_C(0x10a351fc),
         UINT32_C(0xe22c069e),
         UINT32_C(0xa1b0a357),
         UINT32_C(0x533ff435),
         UINT32_C(0xb11347ec),
         UINT32_C(0x439c108e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x502c0937),
         UINT32_C(0x1401c011),
         UINT32_C(0x442dc926),
         UINT32_C(0x00035008),
         UINT32_C(0x502f593f),
         UINT32_C(0x14029019),
         UINT32_C(0x442e992e),
         UINT32_C(0x5000020c),
         UINT32_C(0x002c0b3b),
         UINT32_C(0x4401c21d),
         UINT32_C(0x142dcb2a),
         UINT32_C(0x50035204),
         UINT32_C(0x002f5b33),
         UINT32_C(0x44029215),
         UINT32_C(0x142e9b22)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa81604),
         UINT32_C(0x3f8a00e0),
         UINT32_C(0x3fa216e4),
         UINT32_C(0x3f8001a8),
         UINT32_C(0x3fa817ac),
         UINT32_C(0x3f8a0148),
         UINT32_C(0x3fa2174c),
         UINT32_C(0x3fa80001),
         UINT32_C(0x3f801605),
         UINT32_C(0x3fa200e1),
         UINT32_C(0x3f8a16e5),
         UINT32_C(0x3fa801a9),
         UINT32_C(0x3f8017ad),
         UINT32_C(0x3fa20149),
         UINT32_C(0x3f8a174d)},
        UINT32_C(0xfff80000),
        {0x8b,0x2a,0x0c,0xdc,0x72,0xbd,0x5b,0xbd,0xce,0x57,
         0x2b,0x56,0xfe,0x29,0x1c,0x90,0xe2,0x89,0x78,0x37,0x00}
    },
    {
        /* No.354 delta:1086 weight:1395 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2a73898b),
         UINT32_C(0x2bc778a1),
         UINT32_C(0x01b4f12a),
         UINT32_C(0xc0101625),
         UINT32_C(0xea639fae),
         UINT32_C(0xebd76e84),
         UINT32_C(0xc1a4e70f),
         UINT32_C(0x00005fa6),
         UINT32_C(0x2a73d62d),
         UINT32_C(0x2bc72707),
         UINT32_C(0x01b4ae8c),
         UINT32_C(0xc0104983),
         UINT32_C(0xea63c008),
         UINT32_C(0xebd73122),
         UINT32_C(0xc1a4b8a9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00548076),
         UINT32_C(0x6158a151),
         UINT32_C(0x610c2127),
         UINT32_C(0x0023f032),
         UINT32_C(0x00777044),
         UINT32_C(0x617b5163),
         UINT32_C(0x612fd115),
         UINT32_C(0x0003141c),
         UINT32_C(0x0057946a),
         UINT32_C(0x615bb54d),
         UINT32_C(0x610f353b),
         UINT32_C(0x0020e42e),
         UINT32_C(0x00746458),
         UINT32_C(0x6178457f),
         UINT32_C(0x612cc509)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a40),
         UINT32_C(0x3fb0ac50),
         UINT32_C(0x3fb08610),
         UINT32_C(0x3f8011f8),
         UINT32_C(0x3f803bb8),
         UINT32_C(0x3fb0bda8),
         UINT32_C(0x3fb097e8),
         UINT32_C(0x3f80018a),
         UINT32_C(0x3f802bca),
         UINT32_C(0x3fb0adda),
         UINT32_C(0x3fb0879a),
         UINT32_C(0x3f801072),
         UINT32_C(0x3f803a32),
         UINT32_C(0x3fb0bc22),
         UINT32_C(0x3fb09662)},
        UINT32_C(0xfff80000),
        {0xc1,0x4f,0x6a,0x0d,0x5d,0xd0,0x28,0xff,0x27,0x0d,
         0x1c,0xa0,0xd3,0x5d,0xe6,0x18,0x2c,0x28,0x48,0x32,0x00}
    },
    {
        /* No.355 delta:860 weight:1565 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb757ab7c),
         UINT32_C(0x584f0020),
         UINT32_C(0xef18ab5c),
         UINT32_C(0x27201630),
         UINT32_C(0x9077bd4c),
         UINT32_C(0x7f6f1610),
         UINT32_C(0xc838bd6c),
         UINT32_C(0x0000df99),
         UINT32_C(0xb75774e5),
         UINT32_C(0x584fdfb9),
         UINT32_C(0xef1874c5),
         UINT32_C(0x2720c9a9),
         UINT32_C(0x907762d5),
         UINT32_C(0x7f6fc989),
         UINT32_C(0xc83862f5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1020605a),
         UINT32_C(0x700105ec),
         UINT32_C(0x602165b6),
         UINT32_C(0xe0001003),
         UINT32_C(0xf0207059),
         UINT32_C(0x900115ef),
         UINT32_C(0x802175b5),
         UINT32_C(0x6000001e),
         UINT32_C(0x70206044),
         UINT32_C(0x100105f2),
         UINT32_C(0x002165a8),
         UINT32_C(0x8000101d),
         UINT32_C(0x90207047),
         UINT32_C(0xf00115f1),
         UINT32_C(0xe02175ab)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881030),
         UINT32_C(0x3fb80082),
         UINT32_C(0x3fb010b2),
         UINT32_C(0x3ff00008),
         UINT32_C(0x3ff81038),
         UINT32_C(0x3fc8008a),
         UINT32_C(0x3fc010ba),
         UINT32_C(0x3fb00000),
         UINT32_C(0x3fb81030),
         UINT32_C(0x3f880082),
         UINT32_C(0x3f8010b2),
         UINT32_C(0x3fc00008),
         UINT32_C(0x3fc81038),
         UINT32_C(0x3ff8008a),
         UINT32_C(0x3ff010ba)},
        UINT32_C(0xfff80000),
        {0x34,0x86,0x19,0x26,0xaa,0xfd,0xd4,0xd7,0xa8,0xb6,
         0x9e,0xb2,0xcc,0xd0,0x06,0xe7,0xbf,0x58,0x55,0x64,0x00}
    },
    {
        /* No.356 delta:1005 weight:1725 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe2ad09a9),
         UINT32_C(0x031bb3d5),
         UINT32_C(0xe1b6ba7c),
         UINT32_C(0xed301640),
         UINT32_C(0x0f9d1fe9),
         UINT32_C(0xee2ba595),
         UINT32_C(0x0c86ac3c),
         UINT32_C(0x00007c4a),
         UINT32_C(0xe2ad75e3),
         UINT32_C(0x031bcf9f),
         UINT32_C(0xe1b6c636),
         UINT32_C(0xed306a0a),
         UINT32_C(0x0f9d63a3),
         UINT32_C(0xee2bd9df),
         UINT32_C(0x0c86d076)},
        {UINT32_C(0x00000000),
         UINT32_C(0x507c185e),
         UINT32_C(0x300a0519),
         UINT32_C(0x60761d47),
         UINT32_C(0x100217eb),
         UINT32_C(0x407e0fb5),
         UINT32_C(0x200812f2),
         UINT32_C(0x70740aac),
         UINT32_C(0x1001021d),
         UINT32_C(0x407d1a43),
         UINT32_C(0x200b0704),
         UINT32_C(0x70771f5a),
         UINT32_C(0x000315f6),
         UINT32_C(0x507f0da8),
         UINT32_C(0x300910ef),
         UINT32_C(0x607508b1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa83e0c),
         UINT32_C(0x3f980502),
         UINT32_C(0x3fb03b0e),
         UINT32_C(0x3f88010b),
         UINT32_C(0x3fa03f07),
         UINT32_C(0x3f900409),
         UINT32_C(0x3fb83a05),
         UINT32_C(0x3f880081),
         UINT32_C(0x3fa03e8d),
         UINT32_C(0x3f900583),
         UINT32_C(0x3fb83b8f),
         UINT32_C(0x3f80018a),
         UINT32_C(0x3fa83f86),
         UINT32_C(0x3f980488),
         UINT32_C(0x3fb03a84)},
        UINT32_C(0xfff80000),
        {0xe0,0x2a,0xe4,0x2c,0xf9,0xbe,0x0e,0xec,0x9d,0x4a,
         0x95,0x02,0x1e,0x7d,0x34,0x1d,0x1f,0xc5,0xe7,0x34,0x00}
    },
    {
        /* No.357 delta:1742 weight:1501 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa0a72c62),
         UINT32_C(0x05e61d1e),
         UINT32_C(0xa541317c),
         UINT32_C(0x67d01659),
         UINT32_C(0xc7773a3b),
         UINT32_C(0x62360b47),
         UINT32_C(0xc2912725),
         UINT32_C(0x0000957f),
         UINT32_C(0xa0a7b91d),
         UINT32_C(0x05e68861),
         UINT32_C(0xa541a403),
         UINT32_C(0x67d08326),
         UINT32_C(0xc777af44),
         UINT32_C(0x62369e38),
         UINT32_C(0xc291b25a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x281150de),
         UINT32_C(0x404c418a),
         UINT32_C(0x685d1154),
         UINT32_C(0x080d040b),
         UINT32_C(0x201c54d5),
         UINT32_C(0x48414581),
         UINT32_C(0x6050155f),
         UINT32_C(0x90e041c6),
         UINT32_C(0xb8f11118),
         UINT32_C(0xd0ac004c),
         UINT32_C(0xf8bd5092),
         UINT32_C(0x98ed45cd),
         UINT32_C(0xb0fc1513),
         UINT32_C(0xd8a10447),
         UINT32_C(0xf0b05499)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9408a8),
         UINT32_C(0x3fa02620),
         UINT32_C(0x3fb42e88),
         UINT32_C(0x3f840682),
         UINT32_C(0x3f900e2a),
         UINT32_C(0x3fa420a2),
         UINT32_C(0x3fb0280a),
         UINT32_C(0x3fc87020),
         UINT32_C(0x3fdc7888),
         UINT32_C(0x3fe85600),
         UINT32_C(0x3ffc5ea8),
         UINT32_C(0x3fcc76a2),
         UINT32_C(0x3fd87e0a),
         UINT32_C(0x3fec5082),
         UINT32_C(0x3ff8582a)},
        UINT32_C(0xfff80000),
        {0x85,0xbb,0xe2,0x15,0x0a,0xf7,0x0d,0xd8,0x7b,0x9c,
         0x37,0x41,0x74,0x35,0x37,0xb4,0xf8,0x43,0x55,0xb0,0x00}
    },
    {
        /* No.358 delta:917 weight:1591 */
        11213,
        41,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf655e780),
         UINT32_C(0xce108c27),
         UINT32_C(0x38456ba7),
         UINT32_C(0xf8a0166d),
         UINT32_C(0x0ef5f1ed),
         UINT32_C(0x36b09a4a),
         UINT32_C(0xc0e57dca),
         UINT32_C(0x00009a4a),
         UINT32_C(0xf6557dca),
         UINT32_C(0xce10166d),
         UINT32_C(0x3845f1ed),
         UINT32_C(0xf8a08c27),
         UINT32_C(0x0ef56ba7),
         UINT32_C(0x36b00000),
         UINT32_C(0xc0e5e780)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007413fa),
         UINT32_C(0x000a0c19),
         UINT32_C(0x007e1fe3),
         UINT32_C(0x0011081f),
         UINT32_C(0x00651be5),
         UINT32_C(0x001b0406),
         UINT32_C(0x006f17fc),
         UINT32_C(0x4030a0f2),
         UINT32_C(0x4044b308),
         UINT32_C(0x403aaceb),
         UINT32_C(0x404ebf11),
         UINT32_C(0x4021a8ed),
         UINT32_C(0x4055bb17),
         UINT32_C(0x402ba4f4),
         UINT32_C(0x405fb70e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a09),
         UINT32_C(0x3f800506),
         UINT32_C(0x3f803f0f),
         UINT32_C(0x3f800884),
         UINT32_C(0x3f80328d),
         UINT32_C(0x3f800d82),
         UINT32_C(0x3f80378b),
         UINT32_C(0x3fa01850),
         UINT32_C(0x3fa02259),
         UINT32_C(0x3fa01d56),
         UINT32_C(0x3fa0275f),
         UINT32_C(0x3fa010d4),
         UINT32_C(0x3fa02add),
         UINT32_C(0x3fa015d2),
         UINT32_C(0x3fa02fdb)},
        UINT32_C(0xfff80000),
        {0x4a,0x7e,0x0d,0x83,0xdc,0xd9,0x45,0xd7,0xd7,0xea,
         0xfa,0x38,0xae,0xc1,0xed,0x09,0x5d,0xf8,0x6e,0x1c,0x00}
    },
    {
        /* No.359 delta:988 weight:1719 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x39ff8e1e),
         UINT32_C(0x052720a1),
         UINT32_C(0x3cd8aebf),
         UINT32_C(0xca501672),
         UINT32_C(0xf3af986c),
         UINT32_C(0xcf7736d3),
         UINT32_C(0xf688b8cd),
         UINT32_C(0x00001f50),
         UINT32_C(0x39ff914e),
         UINT32_C(0x05273ff1),
         UINT32_C(0x3cd8b1ef),
         UINT32_C(0xca500922),
         UINT32_C(0xf3af873c),
         UINT32_C(0xcf772983),
         UINT32_C(0xf688a79d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x602c709a),
         UINT32_C(0x101a202f),
         UINT32_C(0x703650b5),
         UINT32_C(0x0064c159),
         UINT32_C(0x6048b1c3),
         UINT32_C(0x107ee176),
         UINT32_C(0x705291ec),
         UINT32_C(0x0003c801),
         UINT32_C(0x602fb89b),
         UINT32_C(0x1019e82e),
         UINT32_C(0x703598b4),
         UINT32_C(0x00670958),
         UINT32_C(0x604b79c2),
         UINT32_C(0x107d2977),
         UINT32_C(0x705159ed)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb01638),
         UINT32_C(0x3f880d10),
         UINT32_C(0x3fb81b28),
         UINT32_C(0x3f803260),
         UINT32_C(0x3fb02458),
         UINT32_C(0x3f883f70),
         UINT32_C(0x3fb82948),
         UINT32_C(0x3f8001e4),
         UINT32_C(0x3fb017dc),
         UINT32_C(0x3f880cf4),
         UINT32_C(0x3fb81acc),
         UINT32_C(0x3f803384),
         UINT32_C(0x3fb025bc),
         UINT32_C(0x3f883e94),
         UINT32_C(0x3fb828ac)},
        UINT32_C(0xfff80000),
        {0x6f,0x5b,0x81,0x0e,0x88,0xf9,0x5d,0x76,0x87,0x44,
         0xb2,0x5a,0xd9,0x1e,0x0c,0x85,0x4a,0xa6,0xa6,0x50,0x00}
    },
    {
        /* No.360 delta:1132 weight:1663 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xde530426),
         UINT32_C(0x95ff5ef7),
         UINT32_C(0x4bac5ad1),
         UINT32_C(0xd1f01682),
         UINT32_C(0x0fa312a4),
         UINT32_C(0x440f4875),
         UINT32_C(0x9a5c4c53),
         UINT32_C(0x0000dea0),
         UINT32_C(0xde53da86),
         UINT32_C(0x95ff8057),
         UINT32_C(0x4bac8471),
         UINT32_C(0xd1f0c822),
         UINT32_C(0x0fa3cc04),
         UINT32_C(0x440f96d5),
         UINT32_C(0x9a5c92f3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0044015c),
         UINT32_C(0x00330035),
         UINT32_C(0x00770169),
         UINT32_C(0x21b9c1a2),
         UINT32_C(0x21fdc0fe),
         UINT32_C(0x218ac197),
         UINT32_C(0x21cec0cb),
         UINT32_C(0x0020301d),
         UINT32_C(0x00643141),
         UINT32_C(0x00133028),
         UINT32_C(0x00573174),
         UINT32_C(0x2199f1bf),
         UINT32_C(0x21ddf0e3),
         UINT32_C(0x21aaf18a),
         UINT32_C(0x21eef0d6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802200),
         UINT32_C(0x3f801980),
         UINT32_C(0x3f803b80),
         UINT32_C(0x3f90dce0),
         UINT32_C(0x3f90fee0),
         UINT32_C(0x3f90c560),
         UINT32_C(0x3f90e760),
         UINT32_C(0x3f801018),
         UINT32_C(0x3f803218),
         UINT32_C(0x3f800998),
         UINT32_C(0x3f802b98),
         UINT32_C(0x3f90ccf8),
         UINT32_C(0x3f90eef8),
         UINT32_C(0x3f90d578),
         UINT32_C(0x3f90f778)},
        UINT32_C(0xfff80000),
        {0xe4,0xa2,0x91,0x75,0x75,0x5f,0x6f,0xcc,0x85,0x64,
         0x78,0xdd,0x14,0x7e,0xcc,0x18,0xf4,0x0c,0x08,0xe3,0x00}
    },
    {
        /* No.361 delta:769 weight:1621 */
        11213,
        66,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x78161af6),
         UINT32_C(0x17c5d7ee),
         UINT32_C(0x6fd3cd18),
         UINT32_C(0x78f0169b),
         UINT32_C(0x00e60c6d),
         UINT32_C(0x6f35c175),
         UINT32_C(0x1723db83),
         UINT32_C(0x00000185),
         UINT32_C(0x78161b73),
         UINT32_C(0x17c5d66b),
         UINT32_C(0x6fd3cc9d),
         UINT32_C(0x78f0171e),
         UINT32_C(0x00e60de8),
         UINT32_C(0x6f35c0f0),
         UINT32_C(0x1723da06)},
        {UINT32_C(0x00000000),
         UINT32_C(0x300d07b6),
         UINT32_C(0x0021ca1a),
         UINT32_C(0x302ccdac),
         UINT32_C(0x70001f45),
         UINT32_C(0x400d18f3),
         UINT32_C(0x7021d55f),
         UINT32_C(0x402cd2e9),
         UINT32_C(0x20001194),
         UINT32_C(0x100d1622),
         UINT32_C(0x2021db8e),
         UINT32_C(0x102cdc38),
         UINT32_C(0x50000ed1),
         UINT32_C(0x600d0967),
         UINT32_C(0x5021c4cb),
         UINT32_C(0x602cc37d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f980683),
         UINT32_C(0x3f8010e5),
         UINT32_C(0x3f981666),
         UINT32_C(0x3fb8000f),
         UINT32_C(0x3fa0068c),
         UINT32_C(0x3fb810ea),
         UINT32_C(0x3fa01669),
         UINT32_C(0x3f900008),
         UINT32_C(0x3f88068b),
         UINT32_C(0x3f9010ed),
         UINT32_C(0x3f88166e),
         UINT32_C(0x3fa80007),
         UINT32_C(0x3fb00684),
         UINT32_C(0x3fa810e2),
         UINT32_C(0x3fb01661)},
        UINT32_C(0xfff80000),
        {0x10,0x6d,0x31,0xe8,0x2c,0xfe,0x25,0xff,0xd4,0xc5,
         0x51,0x0b,0x5a,0xb8,0x88,0xb6,0x5f,0x91,0xe3,0xa1,0x00}
    },
    {
        /* No.362 delta:721 weight:1605 */
        11213,
        91,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4a126c87),
         UINT32_C(0x2c51b2ae),
         UINT32_C(0x6643de29),
         UINT32_C(0xe29016af),
         UINT32_C(0xa8827a28),
         UINT32_C(0xcec1a401),
         UINT32_C(0x84d3c886),
         UINT32_C(0x0000d2fd),
         UINT32_C(0x4a12be7a),
         UINT32_C(0x2c516053),
         UINT32_C(0x66430cd4),
         UINT32_C(0xe290c452),
         UINT32_C(0xa882a8d5),
         UINT32_C(0xcec176fc),
         UINT32_C(0x84d31a7b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0874707f),
         UINT32_C(0x0063cc03),
         UINT32_C(0x0817bc7c),
         UINT32_C(0x101820da),
         UINT32_C(0x186c50a5),
         UINT32_C(0x107becd9),
         UINT32_C(0x180f9ca6),
         UINT32_C(0x00110011),
         UINT32_C(0x0865706e),
         UINT32_C(0x0072cc12),
         UINT32_C(0x0806bc6d),
         UINT32_C(0x100920cb),
         UINT32_C(0x187d50b4),
         UINT32_C(0x106aecc8),
         UINT32_C(0x181e9cb7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f843a38),
         UINT32_C(0x3f8031e6),
         UINT32_C(0x3f840bde),
         UINT32_C(0x3f880c10),
         UINT32_C(0x3f8c3628),
         UINT32_C(0x3f883df6),
         UINT32_C(0x3f8c07ce),
         UINT32_C(0x3f800880),
         UINT32_C(0x3f8432b8),
         UINT32_C(0x3f803966),
         UINT32_C(0x3f84035e),
         UINT32_C(0x3f880490),
         UINT32_C(0x3f8c3ea8),
         UINT32_C(0x3f883576),
         UINT32_C(0x3f8c0f4e)},
        UINT32_C(0xfff80000),
        {0xc6,0x3f,0x57,0xc9,0x84,0x7a,0xfe,0x04,0xa0,0x91,
         0xba,0xea,0xb4,0xec,0x03,0x62,0x0a,0x8b,0xb5,0x90,0x00}
    },
    {
        /* No.363 delta:909 weight:957 */
        11213,
        51,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x03661a42),
         UINT32_C(0x87294fa0),
         UINT32_C(0x844f55e2),
         UINT32_C(0x87b016b1),
         UINT32_C(0x84d60cf3),
         UINT32_C(0x00995911),
         UINT32_C(0x03ff4353),
         UINT32_C(0x00006897),
         UINT32_C(0x036672d5),
         UINT32_C(0x87292737),
         UINT32_C(0x844f3d75),
         UINT32_C(0x87b07e26),
         UINT32_C(0x84d66464),
         UINT32_C(0x00993186),
         UINT32_C(0x03ff2bc4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x101602db),
         UINT32_C(0x0201841c),
         UINT32_C(0x121786c7),
         UINT32_C(0x00405013),
         UINT32_C(0x105652c8),
         UINT32_C(0x0241d40f),
         UINT32_C(0x1257d6d4),
         UINT32_C(0x10020016),
         UINT32_C(0x001402cd),
         UINT32_C(0x1203840a),
         UINT32_C(0x021586d1),
         UINT32_C(0x10425005),
         UINT32_C(0x005452de),
         UINT32_C(0x1243d419),
         UINT32_C(0x0255d6c2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880b01),
         UINT32_C(0x3f8100c2),
         UINT32_C(0x3f890bc3),
         UINT32_C(0x3f802028),
         UINT32_C(0x3f882b29),
         UINT32_C(0x3f8120ea),
         UINT32_C(0x3f892beb),
         UINT32_C(0x3f880100),
         UINT32_C(0x3f800a01),
         UINT32_C(0x3f8901c2),
         UINT32_C(0x3f810ac3),
         UINT32_C(0x3f882128),
         UINT32_C(0x3f802a29),
         UINT32_C(0x3f8921ea),
         UINT32_C(0x3f812aeb)},
        UINT32_C(0xfff80000),
        {0x7a,0x5d,0xdd,0x4b,0xea,0x67,0x23,0x48,0xe6,0xf0,
         0x1d,0x7d,0x70,0xc2,0xb6,0x1a,0x1f,0x0b,0x6e,0x1c,0x00}
    },
    {
        /* No.364 delta:1121 weight:1379 */
        11213,
        30,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf75fa322),
         UINT32_C(0x25af2d0a),
         UINT32_C(0xd2f08e28),
         UINT32_C(0x9b1016c8),
         UINT32_C(0x6c4fb5ea),
         UINT32_C(0xbebf3bc2),
         UINT32_C(0x49e098e0),
         UINT32_C(0x00002571),
         UINT32_C(0xf75f8653),
         UINT32_C(0x25af087b),
         UINT32_C(0xd2f0ab59),
         UINT32_C(0x9b1033b9),
         UINT32_C(0x6c4f909b),
         UINT32_C(0xbebf1eb3),
         UINT32_C(0x49e0bd91)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4846b97e),
         UINT32_C(0x600400f4),
         UINT32_C(0x2842b98a),
         UINT32_C(0x0040a16b),
         UINT32_C(0x48061815),
         UINT32_C(0x6044a19f),
         UINT32_C(0x280218e1),
         UINT32_C(0x00036218),
         UINT32_C(0x4845db66),
         UINT32_C(0x600762ec),
         UINT32_C(0x2841db92),
         UINT32_C(0x0043c373),
         UINT32_C(0x48057a0d),
         UINT32_C(0x6047c387),
         UINT32_C(0x28017af9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa4235c),
         UINT32_C(0x3fb00200),
         UINT32_C(0x3f94215c),
         UINT32_C(0x3f802050),
         UINT32_C(0x3fa4030c),
         UINT32_C(0x3fb02250),
         UINT32_C(0x3f94010c),
         UINT32_C(0x3f8001b1),
         UINT32_C(0x3fa422ed),
         UINT32_C(0x3fb003b1),
         UINT32_C(0x3f9420ed),
         UINT32_C(0x3f8021e1),
         UINT32_C(0x3fa402bd),
         UINT32_C(0x3fb023e1),
         UINT32_C(0x3f9400bd)},
        UINT32_C(0xfff80000),
        {0x1d,0x8e,0x0a,0xda,0xaf,0x74,0xe0,0xed,0x73,0xff,
         0xd0,0x1e,0x9c,0x74,0x10,0xfa,0x70,0x03,0x50,0x44,0x00}
    },
    {
        /* No.365 delta:746 weight:1697 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe80f1cc0),
         UINT32_C(0xd0da24f8),
         UINT32_C(0x38d53838),
         UINT32_C(0xffc016dd),
         UINT32_C(0x17cf0a1d),
         UINT32_C(0x2f1a3225),
         UINT32_C(0xc7152ee5),
         UINT32_C(0x00002907),
         UINT32_C(0xe80f35c7),
         UINT32_C(0xd0da0dff),
         UINT32_C(0x38d5113f),
         UINT32_C(0xffc03fda),
         UINT32_C(0x17cf231a),
         UINT32_C(0x2f1a1b22),
         UINT32_C(0xc71507e2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006e5c92),
         UINT32_C(0x00021394),
         UINT32_C(0x006c4f06),
         UINT32_C(0x20b0b138),
         UINT32_C(0x20deedaa),
         UINT32_C(0x20b2a2ac),
         UINT32_C(0x20dcfe3e),
         UINT32_C(0x00102091),
         UINT32_C(0x007e7c03),
         UINT32_C(0x00123305),
         UINT32_C(0x007c6f97),
         UINT32_C(0x20a091a9),
         UINT32_C(0x20cecd3b),
         UINT32_C(0x20a2823d),
         UINT32_C(0x20ccdeaf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80372e),
         UINT32_C(0x3f800109),
         UINT32_C(0x3f803627),
         UINT32_C(0x3f905858),
         UINT32_C(0x3f906f76),
         UINT32_C(0x3f905951),
         UINT32_C(0x3f906e7f),
         UINT32_C(0x3f800810),
         UINT32_C(0x3f803f3e),
         UINT32_C(0x3f800919),
         UINT32_C(0x3f803e37),
         UINT32_C(0x3f905048),
         UINT32_C(0x3f906766),
         UINT32_C(0x3f905141),
         UINT32_C(0x3f90666f)},
        UINT32_C(0xfff80000),
        {0xb9,0xf4,0x84,0x25,0xe9,0xaf,0xca,0xa9,0x05,0x9e,
         0x09,0xdf,0xc1,0xc2,0xff,0x5d,0x9c,0xec,0x16,0xec,0x00}
    },
    {
        /* No.366 delta:1013 weight:1599 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x240769b0),
         UINT32_C(0xadd4325d),
         UINT32_C(0x89d35bed),
         UINT32_C(0xe4b016e0),
         UINT32_C(0xc0b77f50),
         UINT32_C(0x496424bd),
         UINT32_C(0x6d634d0d),
         UINT32_C(0x000021ea),
         UINT32_C(0x2407485a),
         UINT32_C(0xadd413b7),
         UINT32_C(0x89d37a07),
         UINT32_C(0xe4b0370a),
         UINT32_C(0xc0b75eba),
         UINT32_C(0x49640557),
         UINT32_C(0x6d636ce7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004ca13c),
         UINT32_C(0x2918de15),
         UINT32_C(0x29547f29),
         UINT32_C(0x00353076),
         UINT32_C(0x0079914a),
         UINT32_C(0x292dee63),
         UINT32_C(0x29614f5f),
         UINT32_C(0x0004f0de),
         UINT32_C(0x004851e2),
         UINT32_C(0x291c2ecb),
         UINT32_C(0x29508ff7),
         UINT32_C(0x0031c0a8),
         UINT32_C(0x007d6194),
         UINT32_C(0x29291ebd),
         UINT32_C(0x2965bf81)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802650),
         UINT32_C(0x3f948c6f),
         UINT32_C(0x3f94aa3f),
         UINT32_C(0x3f801a98),
         UINT32_C(0x3f803cc8),
         UINT32_C(0x3f9496f7),
         UINT32_C(0x3f94b0a7),
         UINT32_C(0x3f800278),
         UINT32_C(0x3f802428),
         UINT32_C(0x3f948e17),
         UINT32_C(0x3f94a847),
         UINT32_C(0x3f8018e0),
         UINT32_C(0x3f803eb0),
         UINT32_C(0x3f94948f),
         UINT32_C(0x3f94b2df)},
        UINT32_C(0xfff80000),
        {0xb8,0x5b,0x3b,0x53,0xa9,0x4b,0x2d,0x9b,0x80,0x3f,
         0x17,0x1b,0x48,0xc0,0xcd,0x5a,0xb6,0x7d,0x93,0x54,0x00}
    },
    {
        /* No.367 delta:1230 weight:1517 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x570b7517),
         UINT32_C(0x07ae9069),
         UINT32_C(0x50a5e57e),
         UINT32_C(0x143016fc),
         UINT32_C(0x433b63eb),
         UINT32_C(0x139e8695),
         UINT32_C(0x4495f382),
         UINT32_C(0x0000f479),
         UINT32_C(0x570b816e),
         UINT32_C(0x07ae6410),
         UINT32_C(0x50a51107),
         UINT32_C(0x1430e285),
         UINT32_C(0x433b9792),
         UINT32_C(0x139e72ec),
         UINT32_C(0x449507fb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x005409be),
         UINT32_C(0x201a613c),
         UINT32_C(0x204e6882),
         UINT32_C(0x200b22a4),
         UINT32_C(0x205f2b1a),
         UINT32_C(0x00114398),
         UINT32_C(0x00454a26),
         UINT32_C(0x40000011),
         UINT32_C(0x405409af),
         UINT32_C(0x601a612d),
         UINT32_C(0x604e6893),
         UINT32_C(0x600b22b5),
         UINT32_C(0x605f2b0b),
         UINT32_C(0x40114389),
         UINT32_C(0x40454a37)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a04),
         UINT32_C(0x3f900d30),
         UINT32_C(0x3f902734),
         UINT32_C(0x3f900591),
         UINT32_C(0x3f902f95),
         UINT32_C(0x3f8008a1),
         UINT32_C(0x3f8022a5),
         UINT32_C(0x3fa00000),
         UINT32_C(0x3fa02a04),
         UINT32_C(0x3fb00d30),
         UINT32_C(0x3fb02734),
         UINT32_C(0x3fb00591),
         UINT32_C(0x3fb02f95),
         UINT32_C(0x3fa008a1),
         UINT32_C(0x3fa022a5)},
        UINT32_C(0xfff80000),
        {0x51,0x56,0x7a,0x39,0xc7,0xe7,0x00,0xdd,0x43,0x09,
         0xc8,0xa3,0x0a,0x02,0x38,0xfb,0x23,0x3a,0xe0,0xea,0x00}
    },
    {
        /* No.368 delta:1742 weight:1575 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbbb1bd4d),
         UINT32_C(0x22f590fd),
         UINT32_C(0x99442db0),
         UINT32_C(0xe220170e),
         UINT32_C(0x5991aa43),
         UINT32_C(0xc0d587f3),
         UINT32_C(0x7b643abe),
         UINT32_C(0x00005856),
         UINT32_C(0xbbb1e51b),
         UINT32_C(0x22f5c8ab),
         UINT32_C(0x994475e6),
         UINT32_C(0xe2204f58),
         UINT32_C(0x5991f215),
         UINT32_C(0xc0d5dfa5),
         UINT32_C(0x7b6462e8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x16287a36),
         UINT32_C(0x10744419),
         UINT32_C(0x065c3e2f),
         UINT32_C(0x0a02201d),
         UINT32_C(0x1c2a5a2b),
         UINT32_C(0x1a766404),
         UINT32_C(0x0c5e1e32),
         UINT32_C(0x020c0307),
         UINT32_C(0x14247931),
         UINT32_C(0x1278471e),
         UINT32_C(0x04503d28),
         UINT32_C(0x080e231a),
         UINT32_C(0x1e26592c),
         UINT32_C(0x187a6703),
         UINT32_C(0x0e521d35)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8b143d),
         UINT32_C(0x3f883a22),
         UINT32_C(0x3f832e1f),
         UINT32_C(0x3f850110),
         UINT32_C(0x3f8e152d),
         UINT32_C(0x3f8d3b32),
         UINT32_C(0x3f862f0f),
         UINT32_C(0x3f810601),
         UINT32_C(0x3f8a123c),
         UINT32_C(0x3f893c23),
         UINT32_C(0x3f82281e),
         UINT32_C(0x3f840711),
         UINT32_C(0x3f8f132c),
         UINT32_C(0x3f8c3d33),
         UINT32_C(0x3f87290e)},
        UINT32_C(0xfff80000),
        {0xa1,0x4d,0xf4,0x27,0x3c,0x05,0x11,0x88,0x1e,0x46,
         0xa9,0x99,0x67,0xbc,0x85,0xbf,0x28,0x84,0x2e,0x5c,0x00}
    },
    {
        /* No.369 delta:726 weight:1493 */
        11213,
        66,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc95e3084),
         UINT32_C(0xc197c8f4),
         UINT32_C(0x08c9f870),
         UINT32_C(0x1ba01716),
         UINT32_C(0xd2fe2792),
         UINT32_C(0xda37dfe2),
         UINT32_C(0x1369ef66),
         UINT32_C(0x000044e4),
         UINT32_C(0xc95e7460),
         UINT32_C(0xc1978c10),
         UINT32_C(0x08c9bc94),
         UINT32_C(0x1ba053f2),
         UINT32_C(0xd2fe6376),
         UINT32_C(0xda379b06),
         UINT32_C(0x1369ab82)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10220dfd),
         UINT32_C(0x2041f206),
         UINT32_C(0x3063fffb),
         UINT32_C(0x00028011),
         UINT32_C(0x10208dec),
         UINT32_C(0x20437217),
         UINT32_C(0x30617fea),
         UINT32_C(0x20080e74),
         UINT32_C(0x302a0389),
         UINT32_C(0x0049fc72),
         UINT32_C(0x106bf18f),
         UINT32_C(0x200a8e65),
         UINT32_C(0x30288398),
         UINT32_C(0x004b7c63),
         UINT32_C(0x1069719e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881106),
         UINT32_C(0x3f9020f9),
         UINT32_C(0x3f9831ff),
         UINT32_C(0x3f800140),
         UINT32_C(0x3f881046),
         UINT32_C(0x3f9021b9),
         UINT32_C(0x3f9830bf),
         UINT32_C(0x3f900407),
         UINT32_C(0x3f981501),
         UINT32_C(0x3f8024fe),
         UINT32_C(0x3f8835f8),
         UINT32_C(0x3f900547),
         UINT32_C(0x3f981441),
         UINT32_C(0x3f8025be),
         UINT32_C(0x3f8834b8)},
        UINT32_C(0xfff80000),
        {0xab,0xeb,0x3a,0x5e,0x71,0xac,0x42,0xdc,0x1f,0x31,
         0x75,0xad,0xa3,0x48,0x3e,0x93,0xe1,0xac,0xf7,0x8e,0x00}
    },
    {
        /* No.370 delta:1803 weight:1429 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xce97c038),
         UINT32_C(0xe6b97d49),
         UINT32_C(0x282ebd71),
         UINT32_C(0x82901720),
         UINT32_C(0x4c07d718),
         UINT32_C(0x64296a69),
         UINT32_C(0xaabeaa51),
         UINT32_C(0x0000a04b),
         UINT32_C(0xce976073),
         UINT32_C(0xe6b9dd02),
         UINT32_C(0x282e1d3a),
         UINT32_C(0x8290b76b),
         UINT32_C(0x4c077753),
         UINT32_C(0x6429ca22),
         UINT32_C(0xaabe0a1a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0d698b3e),
         UINT32_C(0x02424bf5),
         UINT32_C(0x0f2bc0cb),
         UINT32_C(0x00c013b9),
         UINT32_C(0x0da99887),
         UINT32_C(0x0282584c),
         UINT32_C(0x0febd372),
         UINT32_C(0x00520378),
         UINT32_C(0x0d3b8846),
         UINT32_C(0x0210488d),
         UINT32_C(0x0f79c3b3),
         UINT32_C(0x009210c1),
         UINT32_C(0x0dfb9bff),
         UINT32_C(0x02d05b34),
         UINT32_C(0x0fb9d00a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f86b4c5),
         UINT32_C(0x3f812125),
         UINT32_C(0x3f8795e0),
         UINT32_C(0x3f806009),
         UINT32_C(0x3f86d4cc),
         UINT32_C(0x3f81412c),
         UINT32_C(0x3f87f5e9),
         UINT32_C(0x3f802901),
         UINT32_C(0x3f869dc4),
         UINT32_C(0x3f810824),
         UINT32_C(0x3f87bce1),
         UINT32_C(0x3f804908),
         UINT32_C(0x3f86fdcd),
         UINT32_C(0x3f81682d),
         UINT32_C(0x3f87dce8)},
        UINT32_C(0xfff80000),
        {0x62,0x9e,0x2a,0xf0,0xed,0xa4,0x3b,0x1b,0x80,0xbf,
         0xea,0x22,0x10,0x9b,0xb1,0xae,0x96,0xc1,0xb4,0x25,0x00}
    },
    {
        /* No.371 delta:909 weight:1601 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x92531619),
         UINT32_C(0x1b699f68),
         UINT32_C(0x893a8971),
         UINT32_C(0xef301737),
         UINT32_C(0x7d63012e),
         UINT32_C(0xf459885f),
         UINT32_C(0x660a9e46),
         UINT32_C(0x000088cc),
         UINT32_C(0x92539ed5),
         UINT32_C(0x1b6917a4),
         UINT32_C(0x893a01bd),
         UINT32_C(0xef309ffb),
         UINT32_C(0x7d6389e2),
         UINT32_C(0xf4590093),
         UINT32_C(0x660a168a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40556436),
         UINT32_C(0x604e63cf),
         UINT32_C(0x201b07f9),
         UINT32_C(0x1002001d),
         UINT32_C(0x5057642b),
         UINT32_C(0x704c63d2),
         UINT32_C(0x301907e4),
         UINT32_C(0x0003841a),
         UINT32_C(0x4056e02c),
         UINT32_C(0x604de7d5),
         UINT32_C(0x201883e3),
         UINT32_C(0x10018407),
         UINT32_C(0x5054e031),
         UINT32_C(0x704fe7c8),
         UINT32_C(0x301a83fe)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02ab2),
         UINT32_C(0x3fb02731),
         UINT32_C(0x3f900d83),
         UINT32_C(0x3f880100),
         UINT32_C(0x3fa82bb2),
         UINT32_C(0x3fb82631),
         UINT32_C(0x3f980c83),
         UINT32_C(0x3f8001c2),
         UINT32_C(0x3fa02b70),
         UINT32_C(0x3fb026f3),
         UINT32_C(0x3f900c41),
         UINT32_C(0x3f8800c2),
         UINT32_C(0x3fa82a70),
         UINT32_C(0x3fb827f3),
         UINT32_C(0x3f980d41)},
        UINT32_C(0xfff80000),
        {0xab,0xcb,0x82,0x30,0xa8,0xd3,0x6a,0xa1,0x5b,0xdf,
         0x89,0xb8,0x21,0xa0,0xba,0x8f,0xe8,0xd6,0xd2,0x8d,0x00}
    },
    {
        /* No.372 delta:1110 weight:1457 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9ea2eb89),
         UINT32_C(0x9a5249dc),
         UINT32_C(0x04f0a255),
         UINT32_C(0x84c0174f),
         UINT32_C(0x1a62fcc6),
         UINT32_C(0x1e925e93),
         UINT32_C(0x8030b51a),
         UINT32_C(0x00000697),
         UINT32_C(0x9ea2ed1e),
         UINT32_C(0x9a524f4b),
         UINT32_C(0x04f0a4c2),
         UINT32_C(0x84c011d8),
         UINT32_C(0x1a62fa51),
         UINT32_C(0x1e925804),
         UINT32_C(0x8030b38d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x107d1296),
         UINT32_C(0x010344fa),
         UINT32_C(0x117e566c),
         UINT32_C(0x0002b9f3),
         UINT32_C(0x107fab65),
         UINT32_C(0x0101fd09),
         UINT32_C(0x117cef9f),
         UINT32_C(0x50032807),
         UINT32_C(0x407e3a91),
         UINT32_C(0x51006cfd),
         UINT32_C(0x417d7e6b),
         UINT32_C(0x500191f4),
         UINT32_C(0x407c8362),
         UINT32_C(0x5102d50e),
         UINT32_C(0x417fc798)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f883e89),
         UINT32_C(0x3f8081a2),
         UINT32_C(0x3f88bf2b),
         UINT32_C(0x3f80015c),
         UINT32_C(0x3f883fd5),
         UINT32_C(0x3f8080fe),
         UINT32_C(0x3f88be77),
         UINT32_C(0x3fa80194),
         UINT32_C(0x3fa03f1d),
         UINT32_C(0x3fa88036),
         UINT32_C(0x3fa0bebf),
         UINT32_C(0x3fa800c8),
         UINT32_C(0x3fa03e41),
         UINT32_C(0x3fa8816a),
         UINT32_C(0x3fa0bfe3)},
        UINT32_C(0xfff80000),
        {0x15,0x2e,0x1b,0x3e,0x9b,0xda,0x1c,0xff,0x98,0x29,
         0xb1,0x7e,0xf5,0x47,0x1c,0xbc,0x67,0x3b,0xd0,0x4a,0x00}
    },
    {
        /* No.373 delta:890 weight:725 */
        11213,
        71,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf453124c),
         UINT32_C(0x9133123d),
         UINT32_C(0x65600071),
         UINT32_C(0x6d601757),
         UINT32_C(0x9933051b),
         UINT32_C(0xfc53056a),
         UINT32_C(0x08001726),
         UINT32_C(0x00000732),
         UINT32_C(0xf453157e),
         UINT32_C(0x9133150f),
         UINT32_C(0x65600743),
         UINT32_C(0x6d601065),
         UINT32_C(0x99330229),
         UINT32_C(0xfc530258),
         UINT32_C(0x08001014)},
        {UINT32_C(0x00000000),
         UINT32_C(0x002f04d5),
         UINT32_C(0x440d9817),
         UINT32_C(0x44229cc2),
         UINT32_C(0x0049b01f),
         UINT32_C(0x0066b4ca),
         UINT32_C(0x44442808),
         UINT32_C(0x446b2cdd),
         UINT32_C(0x200c8013),
         UINT32_C(0x202384c6),
         UINT32_C(0x64011804),
         UINT32_C(0x642e1cd1),
         UINT32_C(0x2045300c),
         UINT32_C(0x206a34d9),
         UINT32_C(0x6448a81b),
         UINT32_C(0x6467acce)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801782),
         UINT32_C(0x3fa206cc),
         UINT32_C(0x3fa2114e),
         UINT32_C(0x3f8024d8),
         UINT32_C(0x3f80335a),
         UINT32_C(0x3fa22214),
         UINT32_C(0x3fa23596),
         UINT32_C(0x3f900640),
         UINT32_C(0x3f9011c2),
         UINT32_C(0x3fb2008c),
         UINT32_C(0x3fb2170e),
         UINT32_C(0x3f902298),
         UINT32_C(0x3f90351a),
         UINT32_C(0x3fb22454),
         UINT32_C(0x3fb233d6)},
        UINT32_C(0xfff80000),
        {0x23,0x25,0x32,0x61,0x6d,0x7c,0xe0,0x06,0x40,0x4b,
         0x1c,0x66,0x52,0x30,0x1f,0xee,0xa1,0x54,0xc1,0xab,0x00}
    },
    {
        /* No.374 delta:919 weight:915 */
        11213,
        59,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9e5812ea),
         UINT32_C(0xe62fe6ba),
         UINT32_C(0x7877f450),
         UINT32_C(0x30c0176d),
         UINT32_C(0xae980587),
         UINT32_C(0xd6eff1d7),
         UINT32_C(0x48b7e33d),
         UINT32_C(0x00002e3e),
         UINT32_C(0x9e583cd4),
         UINT32_C(0xe62fc884),
         UINT32_C(0x7877da6e),
         UINT32_C(0x30c03953),
         UINT32_C(0xae982bb9),
         UINT32_C(0xd6efdfe9),
         UINT32_C(0x48b7cd03)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0077909a),
         UINT32_C(0x400a8817),
         UINT32_C(0x407d188d),
         UINT32_C(0x4000e41f),
         UINT32_C(0x40777485),
         UINT32_C(0x000a6c08),
         UINT32_C(0x007dfc92),
         UINT32_C(0x404311c6),
         UINT32_C(0x4034815c),
         UINT32_C(0x004999d1),
         UINT32_C(0x003e094b),
         UINT32_C(0x0043f5d9),
         UINT32_C(0x00346543),
         UINT32_C(0x40497dce),
         UINT32_C(0x403eed54)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803bc8),
         UINT32_C(0x3fa00544),
         UINT32_C(0x3fa03e8c),
         UINT32_C(0x3fa00072),
         UINT32_C(0x3fa03bba),
         UINT32_C(0x3f800536),
         UINT32_C(0x3f803efe),
         UINT32_C(0x3fa02188),
         UINT32_C(0x3fa01a40),
         UINT32_C(0x3f8024cc),
         UINT32_C(0x3f801f04),
         UINT32_C(0x3f8021fa),
         UINT32_C(0x3f801a32),
         UINT32_C(0x3fa024be),
         UINT32_C(0x3fa01f76)},
        UINT32_C(0xfff80000),
        {0x6f,0x7d,0xf0,0x37,0xf9,0x32,0xc2,0x38,0x87,0x2f,
         0xac,0xd8,0xea,0x5e,0xcc,0x2a,0x14,0xb2,0x55,0xcc,0x00}
    },
    {
        /* No.375 delta:1049 weight:1571 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x04209f4c),
         UINT32_C(0x6f150bce),
         UINT32_C(0x6b359482),
         UINT32_C(0xdb501770),
         UINT32_C(0xdf70883c),
         UINT32_C(0xb4451cbe),
         UINT32_C(0xb06583f2),
         UINT32_C(0x000010de),
         UINT32_C(0x04208f92),
         UINT32_C(0x6f151b10),
         UINT32_C(0x6b35845c),
         UINT32_C(0xdb5007ae),
         UINT32_C(0xdf7098e2),
         UINT32_C(0xb4450c60),
         UINT32_C(0xb065932c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6065e433),
         UINT32_C(0x0002881a),
         UINT32_C(0x60676c29),
         UINT32_C(0x70e108e2),
         UINT32_C(0x1084ecd1),
         UINT32_C(0x70e380f8),
         UINT32_C(0x108664cb),
         UINT32_C(0x0109621b),
         UINT32_C(0x616c8628),
         UINT32_C(0x010bea01),
         UINT32_C(0x616e0e32),
         UINT32_C(0x71e86af9),
         UINT32_C(0x118d8eca),
         UINT32_C(0x71eae2e3),
         UINT32_C(0x118f06d0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb032f2),
         UINT32_C(0x3f800144),
         UINT32_C(0x3fb033b6),
         UINT32_C(0x3fb87084),
         UINT32_C(0x3f884276),
         UINT32_C(0x3fb871c0),
         UINT32_C(0x3f884332),
         UINT32_C(0x3f8084b1),
         UINT32_C(0x3fb0b643),
         UINT32_C(0x3f8085f5),
         UINT32_C(0x3fb0b707),
         UINT32_C(0x3fb8f435),
         UINT32_C(0x3f88c6c7),
         UINT32_C(0x3fb8f571),
         UINT32_C(0x3f88c783)},
        UINT32_C(0xfff80000),
        {0x35,0x60,0x49,0xb8,0x2a,0x1d,0x72,0x07,0x1f,0xe0,
         0x0d,0x14,0xc1,0xb7,0x9d,0x98,0x9e,0x0d,0x5b,0xd0,0x00}
    },
    {
        /* No.376 delta:944 weight:1451 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbc72f163),
         UINT32_C(0x2dfbf47d),
         UINT32_C(0x9189051e),
         UINT32_C(0xb1b0178e),
         UINT32_C(0x0dc2e6ed),
         UINT32_C(0x9c4be3f3),
         UINT32_C(0x20391290),
         UINT32_C(0x0000b3b4),
         UINT32_C(0xbc7242d7),
         UINT32_C(0x2dfb47c9),
         UINT32_C(0x9189b6aa),
         UINT32_C(0xb1b0a43a),
         UINT32_C(0x0dc25559),
         UINT32_C(0x9c4b5047),
         UINT32_C(0x2039a124)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10560972),
         UINT32_C(0x04086049),
         UINT32_C(0x145e693b),
         UINT32_C(0x30042016),
         UINT32_C(0x20522964),
         UINT32_C(0x340c405f),
         UINT32_C(0x245a492d),
         UINT32_C(0x0002140c),
         UINT32_C(0x10541d7e),
         UINT32_C(0x040a7445),
         UINT32_C(0x145c7d37),
         UINT32_C(0x3006341a),
         UINT32_C(0x20503d68),
         UINT32_C(0x340e5453),
         UINT32_C(0x24585d21)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f882b04),
         UINT32_C(0x3f820430),
         UINT32_C(0x3f8a2f34),
         UINT32_C(0x3f980210),
         UINT32_C(0x3f902914),
         UINT32_C(0x3f9a0620),
         UINT32_C(0x3f922d24),
         UINT32_C(0x3f80010a),
         UINT32_C(0x3f882a0e),
         UINT32_C(0x3f82053a),
         UINT32_C(0x3f8a2e3e),
         UINT32_C(0x3f98031a),
         UINT32_C(0x3f90281e),
         UINT32_C(0x3f9a072a),
         UINT32_C(0x3f922c2e)},
        UINT32_C(0xfff80000),
        {0xd0,0xf5,0x67,0x95,0x9d,0x13,0xd7,0x1d,0xe7,0xaa,
         0xf3,0xf9,0xa9,0x7f,0x6d,0x0a,0x13,0xc4,0xc6,0x41,0x00}
    },
    {
        /* No.377 delta:1088 weight:1285 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5cc92a03),
         UINT32_C(0x05adcc7e),
         UINT32_C(0x5964e67d),
         UINT32_C(0x84f0179f),
         UINT32_C(0xd8393d9c),
         UINT32_C(0x815ddbe1),
         UINT32_C(0xdd94f1e2),
         UINT32_C(0x000074d7),
         UINT32_C(0x5cc95ed4),
         UINT32_C(0x05adb8a9),
         UINT32_C(0x596492aa),
         UINT32_C(0x84f06348),
         UINT32_C(0xd839494b),
         UINT32_C(0x815daf36),
         UINT32_C(0xdd948535)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007d1db6),
         UINT32_C(0x80603213),
         UINT32_C(0x801d2fa5),
         UINT32_C(0x00021409),
         UINT32_C(0x007f09bf),
         UINT32_C(0x8062261a),
         UINT32_C(0x801f3bac),
         UINT32_C(0x00034808),
         UINT32_C(0x007e55be),
         UINT32_C(0x80637a1b),
         UINT32_C(0x801e67ad),
         UINT32_C(0x00015c01),
         UINT32_C(0x007c41b7),
         UINT32_C(0x80616e12),
         UINT32_C(0x801c73a4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e8e),
         UINT32_C(0x3fc03019),
         UINT32_C(0x3fc00e97),
         UINT32_C(0x3f80010a),
         UINT32_C(0x3f803f84),
         UINT32_C(0x3fc03113),
         UINT32_C(0x3fc00f9d),
         UINT32_C(0x3f8001a4),
         UINT32_C(0x3f803f2a),
         UINT32_C(0x3fc031bd),
         UINT32_C(0x3fc00f33),
         UINT32_C(0x3f8000ae),
         UINT32_C(0x3f803e20),
         UINT32_C(0x3fc030b7),
         UINT32_C(0x3fc00e39)},
        UINT32_C(0xfff80000),
        {0x31,0xac,0x55,0xef,0xb3,0x54,0x1b,0x51,0xe0,0x64,
         0xc0,0xcc,0x09,0x1f,0x95,0xb6,0x75,0x9e,0x9f,0x3a,0x00}
    },
    {
        /* No.378 delta:824 weight:729 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf4f93c6a),
         UINT32_C(0x8692c625),
         UINT32_C(0x726bfa4f),
         UINT32_C(0x29e017a1),
         UINT32_C(0xdd192bcb),
         UINT32_C(0xaf72d184),
         UINT32_C(0x5b8bedee),
         UINT32_C(0x0000a26b),
         UINT32_C(0xf4f99e01),
         UINT32_C(0x8692644e),
         UINT32_C(0x726b5824),
         UINT32_C(0x29e0b5ca),
         UINT32_C(0xdd1989a0),
         UINT32_C(0xaf7273ef),
         UINT32_C(0x5b8b4f85)},
        {UINT32_C(0x00000000),
         UINT32_C(0x503005de),
         UINT32_C(0x087d481c),
         UINT32_C(0x584d4dc2),
         UINT32_C(0x0068340b),
         UINT32_C(0x505831d5),
         UINT32_C(0x08157c17),
         UINT32_C(0x582579c9),
         UINT32_C(0x48000013),
         UINT32_C(0x183005cd),
         UINT32_C(0x407d480f),
         UINT32_C(0x104d4dd1),
         UINT32_C(0x48683418),
         UINT32_C(0x185831c6),
         UINT32_C(0x40157c04),
         UINT32_C(0x102579da)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa81802),
         UINT32_C(0x3f843ea4),
         UINT32_C(0x3fac26a6),
         UINT32_C(0x3f80341a),
         UINT32_C(0x3fa82c18),
         UINT32_C(0x3f840abe),
         UINT32_C(0x3fac12bc),
         UINT32_C(0x3fa40000),
         UINT32_C(0x3f8c1802),
         UINT32_C(0x3fa03ea4),
         UINT32_C(0x3f8826a6),
         UINT32_C(0x3fa4341a),
         UINT32_C(0x3f8c2c18),
         UINT32_C(0x3fa00abe),
         UINT32_C(0x3f8812bc)},
        UINT32_C(0xfff80000),
        {0x31,0x0d,0x9b,0x5d,0xb9,0xe2,0xc6,0x14,0xa1,0x82,
         0x69,0x5e,0xb0,0xd0,0x2a,0xf8,0x03,0x22,0x85,0xff,0x00}
    },
    {
        /* No.379 delta:2050 weight:1585 */
        11213,
        19,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9952c50d),
         UINT32_C(0xedce1744),
         UINT32_C(0x749cd249),
         UINT32_C(0x08c017b5),
         UINT32_C(0x9192d2b8),
         UINT32_C(0xe50e00f1),
         UINT32_C(0x7c5cc5fc),
         UINT32_C(0x00003690),
         UINT32_C(0x9952f39d),
         UINT32_C(0xedce21d4),
         UINT32_C(0x749ce4d9),
         UINT32_C(0x08c02125),
         UINT32_C(0x9192e428),
         UINT32_C(0xe50e3661),
         UINT32_C(0x7c5cf36c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x405ce3d3),
         UINT32_C(0x00520074),
         UINT32_C(0x400ee3a7),
         UINT32_C(0x00280196),
         UINT32_C(0x4074e245),
         UINT32_C(0x007a01e2),
         UINT32_C(0x4026e231),
         UINT32_C(0x741001bd),
         UINT32_C(0x344ce26e),
         UINT32_C(0x744201c9),
         UINT32_C(0x341ee21a),
         UINT32_C(0x7438002b),
         UINT32_C(0x3464e3f8),
         UINT32_C(0x746a005f),
         UINT32_C(0x3436e38c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa02e71),
         UINT32_C(0x3f802900),
         UINT32_C(0x3fa00771),
         UINT32_C(0x3f801400),
         UINT32_C(0x3fa03a71),
         UINT32_C(0x3f803d00),
         UINT32_C(0x3fa01371),
         UINT32_C(0x3fba0800),
         UINT32_C(0x3f9a2671),
         UINT32_C(0x3fba2100),
         UINT32_C(0x3f9a0f71),
         UINT32_C(0x3fba1c00),
         UINT32_C(0x3f9a3271),
         UINT32_C(0x3fba3500),
         UINT32_C(0x3f9a1b71)},
        UINT32_C(0xfff80000),
        {0xcb,0x23,0x2d,0xee,0x59,0x7d,0xc7,0x51,0x3a,0x51,
         0x5c,0xa9,0xa0,0x85,0xac,0xc6,0x53,0xf4,0xd9,0x8f,0x00}
    },
    {
        /* No.380 delta:734 weight:755 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3a4dd5b2),
         UINT32_C(0x9f753afe),
         UINT32_C(0xa538ef4c),
         UINT32_C(0x6d4017c6),
         UINT32_C(0x570dc274),
         UINT32_C(0xf2352d38),
         UINT32_C(0xc878f88a),
         UINT32_C(0x00003f8f),
         UINT32_C(0x3a4dea3d),
         UINT32_C(0x9f750571),
         UINT32_C(0xa538d0c3),
         UINT32_C(0x6d402849),
         UINT32_C(0x570dfdfb),
         UINT32_C(0xf23512b7),
         UINT32_C(0xc878c705)},
        {UINT32_C(0x00000000),
         UINT32_C(0x41e8019a),
         UINT32_C(0x51420043),
         UINT32_C(0x10aa01d9),
         UINT32_C(0x0c11a13c),
         UINT32_C(0x4df9a0a6),
         UINT32_C(0x5d53a17f),
         UINT32_C(0x1cbba0e5),
         UINT32_C(0x0144a217),
         UINT32_C(0x40aca38d),
         UINT32_C(0x5006a254),
         UINT32_C(0x11eea3ce),
         UINT32_C(0x0d55032b),
         UINT32_C(0x4cbd02b1),
         UINT32_C(0x5c170368),
         UINT32_C(0x1dff02f2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0f400),
         UINT32_C(0x3fa8a100),
         UINT32_C(0x3f885500),
         UINT32_C(0x3f8608d0),
         UINT32_C(0x3fa6fcd0),
         UINT32_C(0x3faea9d0),
         UINT32_C(0x3f8e5dd0),
         UINT32_C(0x3f80a251),
         UINT32_C(0x3fa05651),
         UINT32_C(0x3fa80351),
         UINT32_C(0x3f88f751),
         UINT32_C(0x3f86aa81),
         UINT32_C(0x3fa65e81),
         UINT32_C(0x3fae0b81),
         UINT32_C(0x3f8eff81)},
        UINT32_C(0xfff80000),
        {0x02,0x93,0x13,0xd2,0x2d,0xc3,0xcf,0xcb,0x72,0x8d,
         0xed,0x7d,0x79,0x71,0x4c,0x5d,0xf2,0x35,0x52,0xc4,0x00}
    },
    {
        /* No.381 delta:695 weight:1327 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4a2d336a),
         UINT32_C(0xcbcd0b4d),
         UINT32_C(0x81e03827),
         UINT32_C(0x3c4017d2),
         UINT32_C(0x766d24b8),
         UINT32_C(0xf78d1c9f),
         UINT32_C(0xbda02ff5),
         UINT32_C(0x00003940),
         UINT32_C(0x4a2d0a2a),
         UINT32_C(0xcbcd320d),
         UINT32_C(0x81e00167),
         UINT32_C(0x3c402e92),
         UINT32_C(0x766d1df8),
         UINT32_C(0xf78d25df),
         UINT32_C(0xbda016b5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x406c491f),
         UINT32_C(0x0018165c),
         UINT32_C(0x40745f43),
         UINT32_C(0x5a8c40bd),
         UINT32_C(0x1ae009a2),
         UINT32_C(0x5a9456e1),
         UINT32_C(0x1af81ffe),
         UINT32_C(0x40080196),
         UINT32_C(0x00644889),
         UINT32_C(0x401017ca),
         UINT32_C(0x007c5ed5),
         UINT32_C(0x1a84412b),
         UINT32_C(0x5ae80834),
         UINT32_C(0x1a9c5777),
         UINT32_C(0x5af01e68)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03624),
         UINT32_C(0x3f800c0b),
         UINT32_C(0x3fa03a2f),
         UINT32_C(0x3fad4620),
         UINT32_C(0x3f8d7004),
         UINT32_C(0x3fad4a2b),
         UINT32_C(0x3f8d7c0f),
         UINT32_C(0x3fa00400),
         UINT32_C(0x3f803224),
         UINT32_C(0x3fa0080b),
         UINT32_C(0x3f803e2f),
         UINT32_C(0x3f8d4220),
         UINT32_C(0x3fad7404),
         UINT32_C(0x3f8d4e2b),
         UINT32_C(0x3fad780f)},
        UINT32_C(0xfff80000),
        {0x68,0xc4,0x49,0x1c,0x51,0x0b,0xd4,0xe5,0xf4,0xe0,
         0x12,0xf8,0xfa,0xd2,0x93,0x37,0x42,0x7a,0x25,0x28,0x00}
    },
    {
        /* No.382 delta:1075 weight:1435 */
        11213,
        55,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb1b67f06),
         UINT32_C(0x407a2626),
         UINT32_C(0xf1cc5920),
         UINT32_C(0xf21017e8),
         UINT32_C(0x43a668ee),
         UINT32_C(0xb26a31ce),
         UINT32_C(0x03dc4ec8),
         UINT32_C(0x00004cda),
         UINT32_C(0xb1b633dc),
         UINT32_C(0x407a6afc),
         UINT32_C(0xf1cc15fa),
         UINT32_C(0xf2105b32),
         UINT32_C(0x43a62434),
         UINT32_C(0xb26a7d14),
         UINT32_C(0x03dc0212)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004611bb),
         UINT32_C(0x2002c02d),
         UINT32_C(0x2044d196),
         UINT32_C(0x20032074),
         UINT32_C(0x204531cf),
         UINT32_C(0x0001e059),
         UINT32_C(0x0047f1e2),
         UINT32_C(0x0002109e),
         UINT32_C(0x00440125),
         UINT32_C(0x2000d0b3),
         UINT32_C(0x2046c108),
         UINT32_C(0x200130ea),
         UINT32_C(0x20472151),
         UINT32_C(0x0003f0c7),
         UINT32_C(0x0045e17c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802308),
         UINT32_C(0x3f900160),
         UINT32_C(0x3f902268),
         UINT32_C(0x3f900190),
         UINT32_C(0x3f902298),
         UINT32_C(0x3f8000f0),
         UINT32_C(0x3f8023f8),
         UINT32_C(0x3f800108),
         UINT32_C(0x3f802200),
         UINT32_C(0x3f900068),
         UINT32_C(0x3f902360),
         UINT32_C(0x3f900098),
         UINT32_C(0x3f902390),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3f8022f0)},
        UINT32_C(0xfff80000),
        {0x19,0xfc,0x70,0xab,0x75,0x6b,0x2f,0xe6,0x9d,0xe6,
         0xda,0xd0,0xf4,0x08,0xd7,0xb2,0xc5,0xfa,0xbc,0xe7,0x00}
    },
    {
        /* No.383 delta:1078 weight:1421 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9ea2eb89),
         UINT32_C(0x9a5249dc),
         UINT32_C(0x04f0a255),
         UINT32_C(0x84c017ff),
         UINT32_C(0x1a62fc76),
         UINT32_C(0x1e925e23),
         UINT32_C(0x8030b5aa),
         UINT32_C(0x00000697),
         UINT32_C(0x9ea2ed1e),
         UINT32_C(0x9a524f4b),
         UINT32_C(0x04f0a4c2),
         UINT32_C(0x84c01168),
         UINT32_C(0x1a62fae1),
         UINT32_C(0x1e9258b4),
         UINT32_C(0x8030b33d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x800d0816),
         UINT32_C(0x40274a07),
         UINT32_C(0xc02a4211),
         UINT32_C(0x4002e9e2),
         UINT32_C(0xc00fe1f4),
         UINT32_C(0x0025a3e5),
         UINT32_C(0x8028abf3),
         UINT32_C(0x4001d089),
         UINT32_C(0xc00cd89f),
         UINT32_C(0x00269a8e),
         UINT32_C(0x802b9298),
         UINT32_C(0x0003396b),
         UINT32_C(0x800e317d),
         UINT32_C(0x4024736c),
         UINT32_C(0xc0297b7a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00684),
         UINT32_C(0x3fa013a5),
         UINT32_C(0x3fe01521),
         UINT32_C(0x3fa00174),
         UINT32_C(0x3fe007f0),
         UINT32_C(0x3f8012d1),
         UINT32_C(0x3fc01455),
         UINT32_C(0x3fa000e8),
         UINT32_C(0x3fe0066c),
         UINT32_C(0x3f80134d),
         UINT32_C(0x3fc015c9),
         UINT32_C(0x3f80019c),
         UINT32_C(0x3fc00718),
         UINT32_C(0x3fa01239),
         UINT32_C(0x3fe014bd)},
        UINT32_C(0xfff80000),
        {0x47,0xdd,0x7a,0x23,0xe4,0x00,0xb0,0x59,0xae,0xb2,
         0xdf,0xfd,0x21,0x35,0xb9,0xdd,0xe9,0x91,0x8e,0xd1,0x00}
    },
    {
        /* No.384 delta:614 weight:1663 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x789bd9b9),
         UINT32_C(0xe1471eb4),
         UINT32_C(0x99dcc70d),
         UINT32_C(0x92401808),
         UINT32_C(0xeadbc1b1),
         UINT32_C(0x730706bc),
         UINT32_C(0x0b9cdf05),
         UINT32_C(0x0000cbdb),
         UINT32_C(0x789b1262),
         UINT32_C(0xe147d56f),
         UINT32_C(0x99dc0cd6),
         UINT32_C(0x9240d3d3),
         UINT32_C(0xeadb0a6a),
         UINT32_C(0x7307cd67),
         UINT32_C(0x0b9c14de)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00421735),
         UINT32_C(0x5130081e),
         UINT32_C(0x51721f2b),
         UINT32_C(0x00037267),
         UINT32_C(0x00416552),
         UINT32_C(0x51337a79),
         UINT32_C(0x51716d4c),
         UINT32_C(0x201c080f),
         UINT32_C(0x205e1f3a),
         UINT32_C(0x712c0011),
         UINT32_C(0x716e1724),
         UINT32_C(0x201f7a68),
         UINT32_C(0x205d6d5d),
         UINT32_C(0x712f7276),
         UINT32_C(0x716d6543)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80210b),
         UINT32_C(0x3fa89804),
         UINT32_C(0x3fa8b90f),
         UINT32_C(0x3f8001b9),
         UINT32_C(0x3f8020b2),
         UINT32_C(0x3fa899bd),
         UINT32_C(0x3fa8b8b6),
         UINT32_C(0x3f900e04),
         UINT32_C(0x3f902f0f),
         UINT32_C(0x3fb89600),
         UINT32_C(0x3fb8b70b),
         UINT32_C(0x3f900fbd),
         UINT32_C(0x3f902eb6),
         UINT32_C(0x3fb897b9),
         UINT32_C(0x3fb8b6b2)},
        UINT32_C(0xfff80000),
        {0xf5,0x82,0x42,0x91,0xec,0xcf,0x55,0x4c,0x99,0x8d,
         0x85,0xa5,0xbe,0x5b,0xd2,0xc7,0xe7,0x67,0x93,0x4d,0x00}
    },
    {
        /* No.385 delta:1194 weight:1183 */
        11213,
        36,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x42c7329a),
         UINT32_C(0x61c85650),
         UINT32_C(0x230f64ca),
         UINT32_C(0xc3e01810),
         UINT32_C(0x81272a8a),
         UINT32_C(0xa2284e40),
         UINT32_C(0xe0ef7cda),
         UINT32_C(0x00005450),
         UINT32_C(0x42c766ca),
         UINT32_C(0x61c80200),
         UINT32_C(0x230f309a),
         UINT32_C(0xc3e04c40),
         UINT32_C(0x81277eda),
         UINT32_C(0xa2281a10),
         UINT32_C(0xe0ef288a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006e85ff),
         UINT32_C(0x2013c012),
         UINT32_C(0x207d45ed),
         UINT32_C(0x0003af3c),
         UINT32_C(0x006d2ac3),
         UINT32_C(0x20106f2e),
         UINT32_C(0x207eead1),
         UINT32_C(0x00004017),
         UINT32_C(0x006ec5e8),
         UINT32_C(0x20138005),
         UINT32_C(0x207d05fa),
         UINT32_C(0x0003ef2b),
         UINT32_C(0x006d6ad4),
         UINT32_C(0x20102f39),
         UINT32_C(0x207eaac6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803742),
         UINT32_C(0x3f9009e0),
         UINT32_C(0x3f903ea2),
         UINT32_C(0x3f8001d7),
         UINT32_C(0x3f803695),
         UINT32_C(0x3f900837),
         UINT32_C(0x3f903f75),
         UINT32_C(0x3f800020),
         UINT32_C(0x3f803762),
         UINT32_C(0x3f9009c0),
         UINT32_C(0x3f903e82),
         UINT32_C(0x3f8001f7),
         UINT32_C(0x3f8036b5),
         UINT32_C(0x3f900817),
         UINT32_C(0x3f903f55)},
        UINT32_C(0xfff80000),
        {0x73,0x10,0xc3,0x30,0xe6,0xff,0xe1,0x72,0x2d,0x2f,
         0xd3,0xcc,0xf0,0x3f,0xc6,0xa4,0x5d,0x80,0x4a,0x2e,0x00}
    },
    {
        /* No.386 delta:1854 weight:1525 */
        11213,
        11,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x07bb317a),
         UINT32_C(0x40213aa8),
         UINT32_C(0x479a0bd2),
         UINT32_C(0xa250182b),
         UINT32_C(0xa5eb2951),
         UINT32_C(0xe2712283),
         UINT32_C(0xe5ca13f9),
         UINT32_C(0x000070c0),
         UINT32_C(0x07bb41ba),
         UINT32_C(0x40214a68),
         UINT32_C(0x479a7b12),
         UINT32_C(0xa25068eb),
         UINT32_C(0xa5eb5991),
         UINT32_C(0xe2715243),
         UINT32_C(0xe5ca6339)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0d0e8dfe),
         UINT32_C(0x0883c857),
         UINT32_C(0x058d45a9),
         UINT32_C(0x0e904963),
         UINT32_C(0x039ec49d),
         UINT32_C(0x06138134),
         UINT32_C(0x0b1d0cca),
         UINT32_C(0x21ad841a),
         UINT32_C(0x2ca309e4),
         UINT32_C(0x292e4c4d),
         UINT32_C(0x2420c1b3),
         UINT32_C(0x2f3dcd79),
         UINT32_C(0x22334087),
         UINT32_C(0x27be052e),
         UINT32_C(0x2ab088d0)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f868746),
         UINT32_C(0x3f8441e4),
         UINT32_C(0x3f82c6a2),
         UINT32_C(0x3f874824),
         UINT32_C(0x3f81cf62),
         UINT32_C(0x3f8309c0),
         UINT32_C(0x3f858e86),
         UINT32_C(0x3f90d6c2),
         UINT32_C(0x3f965184),
         UINT32_C(0x3f949726),
         UINT32_C(0x3f921060),
         UINT32_C(0x3f979ee6),
         UINT32_C(0x3f9119a0),
         UINT32_C(0x3f93df02),
         UINT32_C(0x3f955844)},
        UINT32_C(0xfff80000),
        {0x98,0x61,0xd2,0x1b,0xb5,0x8e,0x0a,0x6e,0xcd,0xb3,
         0x70,0xf9,0x2e,0x52,0x5d,0x61,0xfb,0xd9,0x99,0xc0,0x00}
    },
    {
        /* No.387 delta:761 weight:1663 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x51346d03),
         UINT32_C(0x2b2d40e1),
         UINT32_C(0x7a192de2),
         UINT32_C(0x50001831),
         UINT32_C(0x01347532),
         UINT32_C(0x7b2d58d0),
         UINT32_C(0x2a1935d3),
         UINT32_C(0x00009492),
         UINT32_C(0x5134f991),
         UINT32_C(0x2b2dd473),
         UINT32_C(0x7a19b970),
         UINT32_C(0x50008ca3),
         UINT32_C(0x0134e1a0),
         UINT32_C(0x7b2dcc42),
         UINT32_C(0x2a19a141)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00663497),
         UINT32_C(0x60000dbb),
         UINT32_C(0x6066392c),
         UINT32_C(0x20002572),
         UINT32_C(0x206611e5),
         UINT32_C(0x400028c9),
         UINT32_C(0x40661c5e),
         UINT32_C(0x50023c0d),
         UINT32_C(0x5064089a),
         UINT32_C(0x300231b6),
         UINT32_C(0x30640521),
         UINT32_C(0x7002197f),
         UINT32_C(0x70642de8),
         UINT32_C(0x100214c4),
         UINT32_C(0x10642053)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80331a),
         UINT32_C(0x3fb00006),
         UINT32_C(0x3fb0331c),
         UINT32_C(0x3f900012),
         UINT32_C(0x3f903308),
         UINT32_C(0x3fa00014),
         UINT32_C(0x3fa0330e),
         UINT32_C(0x3fa8011e),
         UINT32_C(0x3fa83204),
         UINT32_C(0x3f980118),
         UINT32_C(0x3f983202),
         UINT32_C(0x3fb8010c),
         UINT32_C(0x3fb83216),
         UINT32_C(0x3f88010a),
         UINT32_C(0x3f883210)},
        UINT32_C(0xfff80000),
        {0xec,0xef,0xbe,0x73,0xaa,0x5e,0x52,0xe9,0xe7,0x75,
         0x1d,0x4b,0x52,0xcc,0x2b,0xa9,0x97,0x9b,0x11,0x9c,0x00}
    },
    {
        /* No.388 delta:1533 weight:1351 */
        11213,
        72,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe8a1238a),
         UINT32_C(0x12bbf47c),
         UINT32_C(0xfa1ad7f6),
         UINT32_C(0x73b0184c),
         UINT32_C(0x9b113bc6),
         UINT32_C(0x610bec30),
         UINT32_C(0x89aacfba),
         UINT32_C(0x00005821),
         UINT32_C(0xe8a17bab),
         UINT32_C(0x12bbac5d),
         UINT32_C(0xfa1a8fd7),
         UINT32_C(0x73b0406d),
         UINT32_C(0x9b1163e7),
         UINT32_C(0x610bb411),
         UINT32_C(0x89aa979b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0839217d),
         UINT32_C(0x006c81d2),
         UINT32_C(0x0855a0af),
         UINT32_C(0x00122003),
         UINT32_C(0x082b017e),
         UINT32_C(0x007ea1d1),
         UINT32_C(0x084780ac),
         UINT32_C(0x00022018),
         UINT32_C(0x083b0165),
         UINT32_C(0x006ea1ca),
         UINT32_C(0x085780b7),
         UINT32_C(0x0010001b),
         UINT32_C(0x08292166),
         UINT32_C(0x007c81c9),
         UINT32_C(0x0845a0b4)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841c90),
         UINT32_C(0x3f803640),
         UINT32_C(0x3f842ad0),
         UINT32_C(0x3f800910),
         UINT32_C(0x3f841580),
         UINT32_C(0x3f803f50),
         UINT32_C(0x3f8423c0),
         UINT32_C(0x3f800110),
         UINT32_C(0x3f841d80),
         UINT32_C(0x3f803750),
         UINT32_C(0x3f842bc0),
         UINT32_C(0x3f800800),
         UINT32_C(0x3f841490),
         UINT32_C(0x3f803e40),
         UINT32_C(0x3f8422d0)},
        UINT32_C(0xfff80000),
        {0x92,0x60,0x0d,0x80,0xe9,0x33,0x2d,0x46,0x2b,0xf2,
         0xb4,0x32,0x74,0x9b,0xf8,0x99,0xf8,0xc3,0x2e,0x86,0x00}
    },
    {
        /* No.389 delta:873 weight:1257 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9fbb556e),
         UINT32_C(0xb88be20a),
         UINT32_C(0x2730b764),
         UINT32_C(0x35c01850),
         UINT32_C(0xaa7b4d3e),
         UINT32_C(0x8d4bfa5a),
         UINT32_C(0x12f0af34),
         UINT32_C(0x0000bc4d),
         UINT32_C(0x9fbbe923),
         UINT32_C(0xb88b5e47),
         UINT32_C(0x27300b29),
         UINT32_C(0x35c0a41d),
         UINT32_C(0xaa7bf173),
         UINT32_C(0x8d4b4617),
         UINT32_C(0x12f01379)},
        {UINT32_C(0x00000000),
         UINT32_C(0x71341c1e),
         UINT32_C(0x104378c2),
         UINT32_C(0x617764dc),
         UINT32_C(0x0001e91b),
         UINT32_C(0x7135f505),
         UINT32_C(0x104291d9),
         UINT32_C(0x61768dc7),
         UINT32_C(0x102424ce),
         UINT32_C(0x611038d0),
         UINT32_C(0x00675c0c),
         UINT32_C(0x71534012),
         UINT32_C(0x1025cdd5),
         UINT32_C(0x6111d1cb),
         UINT32_C(0x0066b517),
         UINT32_C(0x7152a909)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb89a0e),
         UINT32_C(0x3f8821bc),
         UINT32_C(0x3fb0bbb2),
         UINT32_C(0x3f8000f4),
         UINT32_C(0x3fb89afa),
         UINT32_C(0x3f882148),
         UINT32_C(0x3fb0bb46),
         UINT32_C(0x3f881212),
         UINT32_C(0x3fb0881c),
         UINT32_C(0x3f8033ae),
         UINT32_C(0x3fb8a9a0),
         UINT32_C(0x3f8812e6),
         UINT32_C(0x3fb088e8),
         UINT32_C(0x3f80335a),
         UINT32_C(0x3fb8a954)},
        UINT32_C(0xfff80000),
        {0x0d,0x4f,0x87,0x46,0x77,0xdc,0xa2,0xd6,0x85,0x1a,
         0x61,0xa3,0x3e,0x03,0x0f,0xe7,0xc8,0xb9,0x0a,0x8d,0x00}
    },
    {
        /* No.390 delta:2038 weight:1291 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5164b2ef),
         UINT32_C(0x2c1644e0),
         UINT32_C(0x7d72f60f),
         UINT32_C(0xd410186b),
         UINT32_C(0x8574aa84),
         UINT32_C(0xf8065c8b),
         UINT32_C(0xa962ee64),
         UINT32_C(0x0000382d),
         UINT32_C(0x51648ac2),
         UINT32_C(0x2c167ccd),
         UINT32_C(0x7d72ce22),
         UINT32_C(0xd4102046),
         UINT32_C(0x857492a9),
         UINT32_C(0xf80664a6),
         UINT32_C(0xa962d649)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1228803c),
         UINT32_C(0x0b08d5cb),
         UINT32_C(0x192055f7),
         UINT32_C(0x0f64c15f),
         UINT32_C(0x1d4c4163),
         UINT32_C(0x046c1494),
         UINT32_C(0x164494a8),
         UINT32_C(0x32604199),
         UINT32_C(0x2048c1a5),
         UINT32_C(0x39689452),
         UINT32_C(0x2b40146e),
         UINT32_C(0x3d0480c6),
         UINT32_C(0x2f2c00fa),
         UINT32_C(0x360c550d),
         UINT32_C(0x2424d531)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f891440),
         UINT32_C(0x3f85846a),
         UINT32_C(0x3f8c902a),
         UINT32_C(0x3f87b260),
         UINT32_C(0x3f8ea620),
         UINT32_C(0x3f82360a),
         UINT32_C(0x3f8b224a),
         UINT32_C(0x3f993020),
         UINT32_C(0x3f902460),
         UINT32_C(0x3f9cb44a),
         UINT32_C(0x3f95a00a),
         UINT32_C(0x3f9e8240),
         UINT32_C(0x3f979600),
         UINT32_C(0x3f9b062a),
         UINT32_C(0x3f92126a)},
        UINT32_C(0xfff80000),
        {0x32,0x79,0x3b,0xa6,0x82,0x51,0x24,0x1e,0xe8,0x3c,
         0xb9,0x62,0x18,0x8d,0x76,0x6e,0x20,0xc4,0x51,0xf8,0x00}
    },
    {
        /* No.391 delta:1140 weight:1415 */
        11213,
        30,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc9aa39b4),
         UINT32_C(0xc7d85494),
         UINT32_C(0x0e726d20),
         UINT32_C(0x2cc0187a),
         UINT32_C(0xe56a21ce),
         UINT32_C(0xeb184cee),
         UINT32_C(0x22b2755a),
         UINT32_C(0x00005a62),
         UINT32_C(0xc9aa63d6),
         UINT32_C(0xc7d80ef6),
         UINT32_C(0x0e723742),
         UINT32_C(0x2cc04218),
         UINT32_C(0xe56a7bac),
         UINT32_C(0xeb18168c),
         UINT32_C(0x22b22f38)},
        {UINT32_C(0x00000000),
         UINT32_C(0x60029c1d),
         UINT32_C(0xb00da012),
         UINT32_C(0xd00f3c0f),
         UINT32_C(0x0002010e),
         UINT32_C(0x60009d13),
         UINT32_C(0xb00fa11c),
         UINT32_C(0xd00d3d01),
         UINT32_C(0x00501135),
         UINT32_C(0x60528d28),
         UINT32_C(0xb05db127),
         UINT32_C(0xd05f2d3a),
         UINT32_C(0x0052103b),
         UINT32_C(0x60508c26),
         UINT32_C(0xb05fb029),
         UINT32_C(0xd05d2c34)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb0014e),
         UINT32_C(0x3fd806d0),
         UINT32_C(0x3fe8079e),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fb0004e),
         UINT32_C(0x3fd807d0),
         UINT32_C(0x3fe8069e),
         UINT32_C(0x3f802808),
         UINT32_C(0x3fb02946),
         UINT32_C(0x3fd82ed8),
         UINT32_C(0x3fe82f96),
         UINT32_C(0x3f802908),
         UINT32_C(0x3fb02846),
         UINT32_C(0x3fd82fd8),
         UINT32_C(0x3fe82e96)},
        UINT32_C(0xfff80000),
        {0x69,0x24,0xff,0x79,0xe9,0x53,0xd5,0x66,0xbd,0x7a,
         0x4d,0x67,0xd3,0x60,0x34,0x64,0x08,0x18,0x9f,0x93,0x00}
    },
    {
        /* No.392 delta:2336 weight:1173 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x14bfc97b),
         UINT32_C(0x293ec8a0),
         UINT32_C(0x3d8101db),
         UINT32_C(0x39d0188f),
         UINT32_C(0x2d6fd1f4),
         UINT32_C(0x10eed02f),
         UINT32_C(0x04511954),
         UINT32_C(0x00008d1e),
         UINT32_C(0x14bf4465),
         UINT32_C(0x293e45be),
         UINT32_C(0x3d818cc5),
         UINT32_C(0x39d09591),
         UINT32_C(0x2d6f5cea),
         UINT32_C(0x10ee5d31),
         UINT32_C(0x0451944a)},
        {UINT32_C(0x00000000),
         UINT32_C(0xe0c6035e),
         UINT32_C(0x1c3a4547),
         UINT32_C(0xfcfc4619),
         UINT32_C(0x021307e3),
         UINT32_C(0xe2d504bd),
         UINT32_C(0x1e2942a4),
         UINT32_C(0xfeef41fa),
         UINT32_C(0x0041c16b),
         UINT32_C(0xe087c235),
         UINT32_C(0x1c7b842c),
         UINT32_C(0xfcbd8772),
         UINT32_C(0x0252c688),
         UINT32_C(0xe294c5d6),
         UINT32_C(0x1e6883cf),
         UINT32_C(0xfeae8091)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff06301),
         UINT32_C(0x3f8e1d22),
         UINT32_C(0x3ffe7e23),
         UINT32_C(0x3f810983),
         UINT32_C(0x3ff16a82),
         UINT32_C(0x3f8f14a1),
         UINT32_C(0x3fff77a0),
         UINT32_C(0x3f8020e0),
         UINT32_C(0x3ff043e1),
         UINT32_C(0x3f8e3dc2),
         UINT32_C(0x3ffe5ec3),
         UINT32_C(0x3f812963),
         UINT32_C(0x3ff14a62),
         UINT32_C(0x3f8f3441),
         UINT32_C(0x3fff5740)},
        UINT32_C(0xfff80000),
        {0xa1,0xc3,0xef,0xa2,0xbd,0xe7,0xcf,0xfc,0xfd,0x80,
         0x13,0x97,0xa4,0x66,0x96,0x1e,0xdd,0x51,0xed,0xf0,0x00}
    },
    {
        /* No.393 delta:871 weight:1573 */
        11213,
        65,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xda1efd75),
         UINT32_C(0x44ba0c25),
         UINT32_C(0x9ea4f150),
         UINT32_C(0x9970189f),
         UINT32_C(0x436ee5ea),
         UINT32_C(0xddca14ba),
         UINT32_C(0x07d4e9cf),
         UINT32_C(0x00008611),
         UINT32_C(0xda1e7b64),
         UINT32_C(0x44ba8a34),
         UINT32_C(0x9ea47741),
         UINT32_C(0x99709e8e),
         UINT32_C(0x436e63fb),
         UINT32_C(0xddca92ab),
         UINT32_C(0x07d46fde)},
        {UINT32_C(0x00000000),
         UINT32_C(0x000301ff),
         UINT32_C(0xa000c1bd),
         UINT32_C(0xa003c042),
         UINT32_C(0x00006817),
         UINT32_C(0x000369e8),
         UINT32_C(0xa000a9aa),
         UINT32_C(0xa003a855),
         UINT32_C(0x2054861a),
         UINT32_C(0x205787e5),
         UINT32_C(0x805447a7),
         UINT32_C(0x80574658),
         UINT32_C(0x2054ee0d),
         UINT32_C(0x2057eff2),
         UINT32_C(0x80542fb0),
         UINT32_C(0x80572e4f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800180),
         UINT32_C(0x3fd00060),
         UINT32_C(0x3fd001e0),
         UINT32_C(0x3f800034),
         UINT32_C(0x3f8001b4),
         UINT32_C(0x3fd00054),
         UINT32_C(0x3fd001d4),
         UINT32_C(0x3f902a43),
         UINT32_C(0x3f902bc3),
         UINT32_C(0x3fc02a23),
         UINT32_C(0x3fc02ba3),
         UINT32_C(0x3f902a77),
         UINT32_C(0x3f902bf7),
         UINT32_C(0x3fc02a17),
         UINT32_C(0x3fc02b97)},
        UINT32_C(0xfff80000),
        {0xc1,0xf0,0x4a,0x60,0x21,0xed,0xe8,0x38,0xd1,0xac,
         0x26,0xbf,0xde,0xc7,0xed,0xa3,0xc7,0xe6,0x06,0x38,0x00}
    },
    {
        /* No.394 delta:1517 weight:1705 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x786dc002),
         UINT32_C(0x7926fdb6),
         UINT32_C(0x014b3db4),
         UINT32_C(0xaf2018aa),
         UINT32_C(0xd74dd8a8),
         UINT32_C(0xd606e51c),
         UINT32_C(0xae6b251e),
         UINT32_C(0x0000c70a),
         UINT32_C(0x786d0708),
         UINT32_C(0x79263abc),
         UINT32_C(0x014bfabe),
         UINT32_C(0xaf20dfa0),
         UINT32_C(0xd74d1fa2),
         UINT32_C(0xd6062216),
         UINT32_C(0xae6be214)},
        {UINT32_C(0x00000000),
         UINT32_C(0x484b915b),
         UINT32_C(0x0047f8d8),
         UINT32_C(0x480c6983),
         UINT32_C(0x440a809d),
         UINT32_C(0x0c4111c6),
         UINT32_C(0x444d7845),
         UINT32_C(0x0c06e91e),
         UINT32_C(0x02282116),
         UINT32_C(0x4a63b04d),
         UINT32_C(0x026fd9ce),
         UINT32_C(0x4a244895),
         UINT32_C(0x4622a18b),
         UINT32_C(0x0e6930d0),
         UINT32_C(0x46655953),
         UINT32_C(0x0e2ec808)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa425c8),
         UINT32_C(0x3f8023fc),
         UINT32_C(0x3fa40634),
         UINT32_C(0x3fa20540),
         UINT32_C(0x3f862088),
         UINT32_C(0x3fa226bc),
         UINT32_C(0x3f860374),
         UINT32_C(0x3f811410),
         UINT32_C(0x3fa531d8),
         UINT32_C(0x3f8137ec),
         UINT32_C(0x3fa51224),
         UINT32_C(0x3fa31150),
         UINT32_C(0x3f873498),
         UINT32_C(0x3fa332ac),
         UINT32_C(0x3f871764)},
        UINT32_C(0xfff80000),
        {0xbc,0xf2,0xae,0x6c,0x1a,0x34,0x9b,0x5d,0x7c,0x65,
         0x7b,0x77,0x57,0x31,0xaa,0x37,0x42,0xe0,0x3f,0x31,0x00}
    },
    {
        /* No.395 delta:1035 weight:1367 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x143d8e44),
         UINT32_C(0x3d637843),
         UINT32_C(0x295ef607),
         UINT32_C(0x8a3018bd),
         UINT32_C(0x9e0d96f9),
         UINT32_C(0xb75360fe),
         UINT32_C(0xa36eeeba),
         UINT32_C(0x00009dc3),
         UINT32_C(0x143d1387),
         UINT32_C(0x3d63e580),
         UINT32_C(0x295e6bc4),
         UINT32_C(0x8a30857e),
         UINT32_C(0x9e0d0b3a),
         UINT32_C(0xb753fd3d),
         UINT32_C(0xa36e7379)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00037416),
         UINT32_C(0x20440409),
         UINT32_C(0x2047701f),
         UINT32_C(0x1010121b),
         UINT32_C(0x1013660d),
         UINT32_C(0x30541612),
         UINT32_C(0x30576204),
         UINT32_C(0x4066b1ce),
         UINT32_C(0x4065c5d8),
         UINT32_C(0x6022b5c7),
         UINT32_C(0x6021c1d1),
         UINT32_C(0x5076a3d5),
         UINT32_C(0x5075d7c3),
         UINT32_C(0x7032a7dc),
         UINT32_C(0x7031d3ca)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8001ba),
         UINT32_C(0x3f902202),
         UINT32_C(0x3f9023b8),
         UINT32_C(0x3f880809),
         UINT32_C(0x3f8809b3),
         UINT32_C(0x3f982a0b),
         UINT32_C(0x3f982bb1),
         UINT32_C(0x3fa03358),
         UINT32_C(0x3fa032e2),
         UINT32_C(0x3fb0115a),
         UINT32_C(0x3fb010e0),
         UINT32_C(0x3fa83b51),
         UINT32_C(0x3fa83aeb),
         UINT32_C(0x3fb81953),
         UINT32_C(0x3fb818e9)},
        UINT32_C(0xfff80000),
        {0x15,0x55,0xb5,0x38,0xbd,0x13,0xe4,0xa7,0xd1,0x20,
         0x66,0x03,0x26,0x71,0x19,0xfa,0x2c,0x03,0xeb,0xcb,0x00}
    },
    {
        /* No.396 delta:722 weight:1445 */
        11213,
        69,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6552a43b),
         UINT32_C(0x4a6b1404),
         UINT32_C(0x2f39b03f),
         UINT32_C(0x9a7018c3),
         UINT32_C(0xff22bcf8),
         UINT32_C(0xd01b0cc7),
         UINT32_C(0xb549a8fc),
         UINT32_C(0x0000fe80),
         UINT32_C(0x65525abb),
         UINT32_C(0x4a6bea84),
         UINT32_C(0x2f394ebf),
         UINT32_C(0x9a70e643),
         UINT32_C(0xff224278),
         UINT32_C(0xd01bf247),
         UINT32_C(0xb549567c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x103e11be),
         UINT32_C(0x0003044b),
         UINT32_C(0x103d15f5),
         UINT32_C(0x503b3654),
         UINT32_C(0x400527ea),
         UINT32_C(0x5038321f),
         UINT32_C(0x400623a1),
         UINT32_C(0x0002bc06),
         UINT32_C(0x103cadb8),
         UINT32_C(0x0001b84d),
         UINT32_C(0x103fa9f3),
         UINT32_C(0x50398a52),
         UINT32_C(0x40079bec),
         UINT32_C(0x503a8e19),
         UINT32_C(0x40049fa7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881f08),
         UINT32_C(0x3f800182),
         UINT32_C(0x3f881e8a),
         UINT32_C(0x3fa81d9b),
         UINT32_C(0x3fa00293),
         UINT32_C(0x3fa81c19),
         UINT32_C(0x3fa00311),
         UINT32_C(0x3f80015e),
         UINT32_C(0x3f881e56),
         UINT32_C(0x3f8000dc),
         UINT32_C(0x3f881fd4),
         UINT32_C(0x3fa81cc5),
         UINT32_C(0x3fa003cd),
         UINT32_C(0x3fa81d47),
         UINT32_C(0x3fa0024f)},
        UINT32_C(0xfff80000),
        {0xad,0x8a,0xfd,0x27,0xb8,0x3e,0x15,0x8a,0x49,0x48,
         0xd9,0xd7,0x59,0x94,0xb0,0x87,0xfc,0x57,0x26,0xf4,0x00}
    },
    {
        /* No.397 delta:840 weight:1603 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x669d918e),
         UINT32_C(0xdcb4eaab),
         UINT32_C(0xba297b25),
         UINT32_C(0x581018d3),
         UINT32_C(0x3e8d895d),
         UINT32_C(0x84a4f278),
         UINT32_C(0xe23963f6),
         UINT32_C(0x00000e05),
         UINT32_C(0x669d9f8b),
         UINT32_C(0xdcb4e4ae),
         UINT32_C(0xba297520),
         UINT32_C(0x581016d6),
         UINT32_C(0x3e8d8758),
         UINT32_C(0x84a4fc7d),
         UINT32_C(0xe2396df3)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa0215816),
         UINT32_C(0x2001aab4),
         UINT32_C(0x8020f2a2),
         UINT32_C(0x002258ee),
         UINT32_C(0xa00300f8),
         UINT32_C(0x2023f25a),
         UINT32_C(0x8002aa4c),
         UINT32_C(0x4000621e),
         UINT32_C(0xe0213a08),
         UINT32_C(0x6001c8aa),
         UINT32_C(0xc02090bc),
         UINT32_C(0x40223af0),
         UINT32_C(0xe00362e6),
         UINT32_C(0x60239044),
         UINT32_C(0xc002c852)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd010ac),
         UINT32_C(0x3f9000d5),
         UINT32_C(0x3fc01079),
         UINT32_C(0x3f80112c),
         UINT32_C(0x3fd00180),
         UINT32_C(0x3f9011f9),
         UINT32_C(0x3fc00155),
         UINT32_C(0x3fa00031),
         UINT32_C(0x3ff0109d),
         UINT32_C(0x3fb000e4),
         UINT32_C(0x3fe01048),
         UINT32_C(0x3fa0111d),
         UINT32_C(0x3ff001b1),
         UINT32_C(0x3fb011c8),
         UINT32_C(0x3fe00164)},
        UINT32_C(0xfff80000),
        {0x75,0x9a,0x24,0xfc,0x18,0x38,0x61,0xb9,0xb3,0x13,
         0xb4,0xcb,0xd5,0xae,0xfa,0x52,0x8f,0x60,0x2a,0x4f,0x00}
    },
    {
        /* No.398 delta:1725 weight:1293 */
        11213,
        78,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x46ab68d5),
         UINT32_C(0x5c04de2b),
         UINT32_C(0x1aafb6fe),
         UINT32_C(0xe52018ec),
         UINT32_C(0xa38b7039),
         UINT32_C(0xb924c6c7),
         UINT32_C(0xff8fae12),
         UINT32_C(0x00009d52),
         UINT32_C(0x46abf587),
         UINT32_C(0x5c044379),
         UINT32_C(0x1aaf2bac),
         UINT32_C(0xe52085be),
         UINT32_C(0xa38bed6b),
         UINT32_C(0xb9245b95),
         UINT32_C(0xff8f3340)},
        {UINT32_C(0x00000000),
         UINT32_C(0x007c01d6),
         UINT32_C(0x004400f5),
         UINT32_C(0x00380123),
         UINT32_C(0x0000015f),
         UINT32_C(0x007c0089),
         UINT32_C(0x004401aa),
         UINT32_C(0x0038007c),
         UINT32_C(0x0041001e),
         UINT32_C(0x003d01c8),
         UINT32_C(0x000500eb),
         UINT32_C(0x0079013d),
         UINT32_C(0x00410141),
         UINT32_C(0x003d0097),
         UINT32_C(0x000501b4),
         UINT32_C(0x00790062)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f802200),
         UINT32_C(0x3f801c00),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f803e00),
         UINT32_C(0x3f802200),
         UINT32_C(0x3f801c00),
         UINT32_C(0x3f802080),
         UINT32_C(0x3f801e80),
         UINT32_C(0x3f800280),
         UINT32_C(0x3f803c80),
         UINT32_C(0x3f802080),
         UINT32_C(0x3f801e80),
         UINT32_C(0x3f800280),
         UINT32_C(0x3f803c80)},
        UINT32_C(0xfff80000),
        {0xdb,0x63,0x57,0xb1,0xff,0x25,0x5b,0x3f,0xb8,0x43,
         0xa0,0x6d,0x1c,0x80,0x82,0x9d,0x33,0x74,0x52,0xf1,0x00}
    },
    {
        /* No.399 delta:780 weight:1553 */
        11213,
        56,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1807b5d7),
         UINT32_C(0x79b56b4c),
         UINT32_C(0x61b2de9b),
         UINT32_C(0x334018f9),
         UINT32_C(0x2b47ad2e),
         UINT32_C(0x4af573b5),
         UINT32_C(0x52f2c662),
         UINT32_C(0x0000df01),
         UINT32_C(0x18076ad6),
         UINT32_C(0x79b5b44d),
         UINT32_C(0x61b2019a),
         UINT32_C(0x3340c7f8),
         UINT32_C(0x2b47722f),
         UINT32_C(0x4af5acb4),
         UINT32_C(0x52f21963)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00040952),
         UINT32_C(0x60212011),
         UINT32_C(0x60252943),
         UINT32_C(0x10001526),
         UINT32_C(0x10041c74),
         UINT32_C(0x70213537),
         UINT32_C(0x70253c65),
         UINT32_C(0x40000a1a),
         UINT32_C(0x40040348),
         UINT32_C(0x20212a0b),
         UINT32_C(0x20252359),
         UINT32_C(0x50001f3c),
         UINT32_C(0x5004166e),
         UINT32_C(0x30213f2d),
         UINT32_C(0x3025367f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800204),
         UINT32_C(0x3fb01090),
         UINT32_C(0x3fb01294),
         UINT32_C(0x3f88000a),
         UINT32_C(0x3f88020e),
         UINT32_C(0x3fb8109a),
         UINT32_C(0x3fb8129e),
         UINT32_C(0x3fa00005),
         UINT32_C(0x3fa00201),
         UINT32_C(0x3f901095),
         UINT32_C(0x3f901291),
         UINT32_C(0x3fa8000f),
         UINT32_C(0x3fa8020b),
         UINT32_C(0x3f98109f),
         UINT32_C(0x3f98129b)},
        UINT32_C(0xfff80000),
        {0x3d,0xe1,0x0e,0xa7,0x85,0xab,0xc6,0xe8,0x6f,0x4b,
         0xcd,0xbb,0xd5,0xa4,0x09,0xa9,0x26,0x43,0xbc,0xfe,0x00}
    },
    {
        /* No.400 delta:2266 weight:1249 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe2dbfe7d),
         UINT32_C(0xd0e935c8),
         UINT32_C(0x3232cbb5),
         UINT32_C(0xff001901),
         UINT32_C(0x1ddbe77c),
         UINT32_C(0x2fe92cc9),
         UINT32_C(0xcd32d2b4),
         UINT32_C(0x0000f8d9),
         UINT32_C(0xe2db06a4),
         UINT32_C(0xd0e9cd11),
         UINT32_C(0x3232336c),
         UINT32_C(0xff00e1d8),
         UINT32_C(0x1ddb1fa5),
         UINT32_C(0x2fe9d410),
         UINT32_C(0xcd322a6d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0a4380b6),
         UINT32_C(0x120148e9),
         UINT32_C(0x1842c85f),
         UINT32_C(0x2140981d),
         UINT32_C(0x2b0318ab),
         UINT32_C(0x3341d0f4),
         UINT32_C(0x39025042),
         UINT32_C(0x700000a7),
         UINT32_C(0x7a438011),
         UINT32_C(0x6201484e),
         UINT32_C(0x6842c8f8),
         UINT32_C(0x514098ba),
         UINT32_C(0x5b03180c),
         UINT32_C(0x4341d053),
         UINT32_C(0x490250e5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8521c0),
         UINT32_C(0x3f8900a4),
         UINT32_C(0x3f8c2164),
         UINT32_C(0x3f90a04c),
         UINT32_C(0x3f95818c),
         UINT32_C(0x3f99a0e8),
         UINT32_C(0x3f9c8128),
         UINT32_C(0x3fb80000),
         UINT32_C(0x3fbd21c0),
         UINT32_C(0x3fb100a4),
         UINT32_C(0x3fb42164),
         UINT32_C(0x3fa8a04c),
         UINT32_C(0x3fad818c),
         UINT32_C(0x3fa1a0e8),
         UINT32_C(0x3fa48128)},
        UINT32_C(0xfff80000),
        {0x36,0x58,0x6f,0x1a,0x58,0x7f,0x55,0xac,0x11,0x3e,
         0x26,0x32,0x97,0xb7,0x1a,0x18,0x6a,0x72,0x2a,0xbe,0x00}
    },
    {
        /* No.401 delta:2650 weight:873 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe1aed356),
         UINT32_C(0x5e9f273a),
         UINT32_C(0xbf31f46c),
         UINT32_C(0xa2e01919),
         UINT32_C(0x434eca4f),
         UINT32_C(0xfc7f3e23),
         UINT32_C(0x1dd1ed75),
         UINT32_C(0x000081de),
         UINT32_C(0xe1ae5288),
         UINT32_C(0x5e9fa6e4),
         UINT32_C(0xbf3175b2),
         UINT32_C(0xa2e098c7),
         UINT32_C(0x434e4b91),
         UINT32_C(0xfc7fbffd),
         UINT32_C(0x1dd16cab)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc0706532),
         UINT32_C(0x280209b8),
         UINT32_C(0xe8726c8a),
         UINT32_C(0xd6906019),
         UINT32_C(0x16e0052b),
         UINT32_C(0xfe9269a1),
         UINT32_C(0x3ee20c93),
         UINT32_C(0x22991407),
         UINT32_C(0xe2e97135),
         UINT32_C(0x0a9b1dbf),
         UINT32_C(0xcaeb788d),
         UINT32_C(0xf409741e),
         UINT32_C(0x3479112c),
         UINT32_C(0xdc0b7da6),
         UINT32_C(0x1c7b1894)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe03832),
         UINT32_C(0x3f940104),
         UINT32_C(0x3ff43936),
         UINT32_C(0x3feb4830),
         UINT32_C(0x3f8b7002),
         UINT32_C(0x3fff4934),
         UINT32_C(0x3f9f7106),
         UINT32_C(0x3f914c8a),
         UINT32_C(0x3ff174b8),
         UINT32_C(0x3f854d8e),
         UINT32_C(0x3fe575bc),
         UINT32_C(0x3ffa04ba),
         UINT32_C(0x3f9a3c88),
         UINT32_C(0x3fee05be),
         UINT32_C(0x3f8e3d8c)},
        UINT32_C(0xfff80000),
        {0x33,0x8e,0xa6,0x98,0x68,0xf0,0x3f,0x0f,0xc5,0xf7,
         0x8e,0x62,0x24,0xf2,0x8f,0x37,0x53,0xf4,0x2d,0x6b,0x00}
    },
    {
        /* No.402 delta:983 weight:1731 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x94aa7ca2),
         UINT32_C(0x2140e274),
         UINT32_C(0xb5ea9ed6),
         UINT32_C(0x6c201925),
         UINT32_C(0xf88a6587),
         UINT32_C(0x4d60fb51),
         UINT32_C(0xd9ca87f3),
         UINT32_C(0x0000da27),
         UINT32_C(0x94aaa685),
         UINT32_C(0x21403853),
         UINT32_C(0xb5ea44f1),
         UINT32_C(0x6c20c302),
         UINT32_C(0xf88abfa0),
         UINT32_C(0x4d602176),
         UINT32_C(0xd9ca5dd4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x602ba1b2),
         UINT32_C(0x00026179),
         UINT32_C(0x6029c0cb),
         UINT32_C(0x810800a4),
         UINT32_C(0xe123a116),
         UINT32_C(0x810a61dd),
         UINT32_C(0xe121c06f),
         UINT32_C(0x8080401e),
         UINT32_C(0xe0abe1ac),
         UINT32_C(0x80822167),
         UINT32_C(0xe0a980d5),
         UINT32_C(0x018840ba),
         UINT32_C(0x61a3e108),
         UINT32_C(0x018a21c3),
         UINT32_C(0x61a18071)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb015d0),
         UINT32_C(0x3f800130),
         UINT32_C(0x3fb014e0),
         UINT32_C(0x3fc08400),
         UINT32_C(0x3ff091d0),
         UINT32_C(0x3fc08530),
         UINT32_C(0x3ff090e0),
         UINT32_C(0x3fc04020),
         UINT32_C(0x3ff055f0),
         UINT32_C(0x3fc04110),
         UINT32_C(0x3ff054c0),
         UINT32_C(0x3f80c420),
         UINT32_C(0x3fb0d1f0),
         UINT32_C(0x3f80c510),
         UINT32_C(0x3fb0d0c0)},
        UINT32_C(0xfff80000),
        {0xbc,0x77,0xad,0x3a,0x86,0x5e,0x7c,0xff,0xfe,0x2c,
         0x07,0x2b,0xa9,0xfb,0xb0,0xae,0x84,0x09,0xe6,0xa8,0x00}
    },
    {
        /* No.403 delta:688 weight:1461 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb1e47e54),
         UINT32_C(0x0bb002f8),
         UINT32_C(0xba547cac),
         UINT32_C(0x3fa0193d),
         UINT32_C(0x8e446769),
         UINT32_C(0x34101bc5),
         UINT32_C(0x85f46591),
         UINT32_C(0x0000b2a5),
         UINT32_C(0xb1e4ccf1),
         UINT32_C(0x0bb0b05d),
         UINT32_C(0xba54ce09),
         UINT32_C(0x3fa0ab98),
         UINT32_C(0x8e44d5cc),
         UINT32_C(0x3410a960),
         UINT32_C(0x85f4d734)},
        {UINT32_C(0x00000000),
         UINT32_C(0xdc142153),
         UINT32_C(0x2262019a),
         UINT32_C(0xfe7620c9),
         UINT32_C(0x0068e026),
         UINT32_C(0xdc7cc175),
         UINT32_C(0x220ae1bc),
         UINT32_C(0xfe1ec0ef),
         UINT32_C(0x0012381d),
         UINT32_C(0xdc06194e),
         UINT32_C(0x22703987),
         UINT32_C(0xfe6418d4),
         UINT32_C(0x007ad83b),
         UINT32_C(0xdc6ef968),
         UINT32_C(0x2218d9a1),
         UINT32_C(0xfe0cf8f2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fee0a10),
         UINT32_C(0x3f913100),
         UINT32_C(0x3fff3b10),
         UINT32_C(0x3f803470),
         UINT32_C(0x3fee3e60),
         UINT32_C(0x3f910570),
         UINT32_C(0x3fff0f60),
         UINT32_C(0x3f80091c),
         UINT32_C(0x3fee030c),
         UINT32_C(0x3f91381c),
         UINT32_C(0x3fff320c),
         UINT32_C(0x3f803d6c),
         UINT32_C(0x3fee377c),
         UINT32_C(0x3f910c6c),
         UINT32_C(0x3fff067c)},
        UINT32_C(0xfff80000),
        {0xf3,0x99,0xfd,0x47,0xca,0x52,0x7b,0x4e,0xc2,0x1a,
         0x72,0x95,0xdb,0x1a,0xe5,0x0f,0x58,0x17,0xb9,0x96,0x00}
    },
    {
        /* No.404 delta:2158 weight:1325 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf3fd55b8),
         UINT32_C(0xf999547e),
         UINT32_C(0x0a6401c6),
         UINT32_C(0x27401949),
         UINT32_C(0xd4bd4cf1),
         UINT32_C(0xded94d37),
         UINT32_C(0x2d24188f),
         UINT32_C(0x0000b353),
         UINT32_C(0xf3fde6eb),
         UINT32_C(0xf999e72d),
         UINT32_C(0x0a64b295),
         UINT32_C(0x2740aa1a),
         UINT32_C(0xd4bdffa2),
         UINT32_C(0xded9fe64),
         UINT32_C(0x2d24abdc)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0c526f12),
         UINT32_C(0x1500841c),
         UINT32_C(0x1952eb0e),
         UINT32_C(0x0b180c01),
         UINT32_C(0x074a6313),
         UINT32_C(0x1e18881d),
         UINT32_C(0x124ae70f),
         UINT32_C(0x24487005),
         UINT32_C(0x281a1f17),
         UINT32_C(0x3148f419),
         UINT32_C(0x3d1a9b0b),
         UINT32_C(0x2f507c04),
         UINT32_C(0x23021316),
         UINT32_C(0x3a50f818),
         UINT32_C(0x3602970a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f862937),
         UINT32_C(0x3f8a8042),
         UINT32_C(0x3f8ca975),
         UINT32_C(0x3f858c06),
         UINT32_C(0x3f83a531),
         UINT32_C(0x3f8f0c44),
         UINT32_C(0x3f892573),
         UINT32_C(0x3f922438),
         UINT32_C(0x3f940d0f),
         UINT32_C(0x3f98a47a),
         UINT32_C(0x3f9e8d4d),
         UINT32_C(0x3f97a83e),
         UINT32_C(0x3f918109),
         UINT32_C(0x3f9d287c),
         UINT32_C(0x3f9b014b)},
        UINT32_C(0xfff80000),
        {0xc3,0x74,0x74,0x92,0x5b,0x70,0x8c,0x5d,0xe8,0x35,
         0xf4,0xb0,0xa9,0x24,0xe6,0x54,0xba,0x40,0xcf,0x0f,0x00}
    },
    {
        /* No.405 delta:938 weight:1185 */
        11213,
        39,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x52862043),
         UINT32_C(0xd780840d),
         UINT32_C(0x8506a44e),
         UINT32_C(0xe4d01955),
         UINT32_C(0xb6563916),
         UINT32_C(0x33509d58),
         UINT32_C(0x61d6bd1b),
         UINT32_C(0x0000efed),
         UINT32_C(0x5286cfae),
         UINT32_C(0xd7806be0),
         UINT32_C(0x85064ba3),
         UINT32_C(0xe4d0f6b8),
         UINT32_C(0xb656d6fb),
         UINT32_C(0x335072b5),
         UINT32_C(0x61d652f6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x404f4096),
         UINT32_C(0x00024c9d),
         UINT32_C(0x404d0c0b),
         UINT32_C(0x206cb002),
         UINT32_C(0x6023f094),
         UINT32_C(0x206efc9f),
         UINT32_C(0x6021bc09),
         UINT32_C(0x400bc211),
         UINT32_C(0x00448287),
         UINT32_C(0x40098e8c),
         UINT32_C(0x0046ce1a),
         UINT32_C(0x60677213),
         UINT32_C(0x20283285),
         UINT32_C(0x60653e8e),
         UINT32_C(0x202a7e18)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa027a0),
         UINT32_C(0x3f800126),
         UINT32_C(0x3fa02686),
         UINT32_C(0x3f903658),
         UINT32_C(0x3fb011f8),
         UINT32_C(0x3f90377e),
         UINT32_C(0x3fb010de),
         UINT32_C(0x3fa005e1),
         UINT32_C(0x3f802241),
         UINT32_C(0x3fa004c7),
         UINT32_C(0x3f802367),
         UINT32_C(0x3fb033b9),
         UINT32_C(0x3f901419),
         UINT32_C(0x3fb0329f),
         UINT32_C(0x3f90153f)},
        UINT32_C(0xfff80000),
        {0x7f,0xf9,0x6d,0x9a,0xea,0xa3,0xf9,0xf2,0xbb,0x37,
         0x32,0x5e,0x26,0x79,0xd2,0x7a,0x4b,0xd5,0x7f,0xe8,0x00}
    },
    {
        /* No.406 delta:1252 weight:1757 */
        11213,
        22,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe880a2a5),
         UINT32_C(0x895e81f7),
         UINT32_C(0x61de2352),
         UINT32_C(0x13e01963),
         UINT32_C(0xfb60bbc6),
         UINT32_C(0x9abe9894),
         UINT32_C(0x723e3a31),
         UINT32_C(0x00009436),
         UINT32_C(0xe8803693),
         UINT32_C(0x895e15c1),
         UINT32_C(0x61deb764),
         UINT32_C(0x13e08d55),
         UINT32_C(0xfb602ff0),
         UINT32_C(0x9abe0ca2),
         UINT32_C(0x723eae07)},
        {UINT32_C(0x00000000),
         UINT32_C(0x206478da),
         UINT32_C(0x004f0046),
         UINT32_C(0x202b789c),
         UINT32_C(0x400c4404),
         UINT32_C(0x60683cde),
         UINT32_C(0x40434442),
         UINT32_C(0x60273c98),
         UINT32_C(0x00301137),
         UINT32_C(0x205469ed),
         UINT32_C(0x007f1171),
         UINT32_C(0x201b69ab),
         UINT32_C(0x403c5533),
         UINT32_C(0x60582de9),
         UINT32_C(0x40735575),
         UINT32_C(0x60172daf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90323c),
         UINT32_C(0x3f802780),
         UINT32_C(0x3f9015bc),
         UINT32_C(0x3fa00622),
         UINT32_C(0x3fb0341e),
         UINT32_C(0x3fa021a2),
         UINT32_C(0x3fb0139e),
         UINT32_C(0x3f801808),
         UINT32_C(0x3f902a34),
         UINT32_C(0x3f803f88),
         UINT32_C(0x3f900db4),
         UINT32_C(0x3fa01e2a),
         UINT32_C(0x3fb02c16),
         UINT32_C(0x3fa039aa),
         UINT32_C(0x3fb00b96)},
        UINT32_C(0xfff80000),
        {0x97,0xea,0xc7,0x0e,0x13,0x4a,0x4a,0xde,0xa5,0x17,
         0x77,0x45,0xc4,0xc5,0x87,0x34,0x14,0x87,0x57,0x42,0x00}
    },
    {
        /* No.407 delta:783 weight:1331 */
        11213,
        79,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd707084f),
         UINT32_C(0x9ed93c29),
         UINT32_C(0x49de3466),
         UINT32_C(0x96f01970),
         UINT32_C(0x41f7113f),
         UINT32_C(0x08292559),
         UINT32_C(0xdf2e2d16),
         UINT32_C(0x000051e5),
         UINT32_C(0xd70759aa),
         UINT32_C(0x9ed96dcc),
         UINT32_C(0x49de6583),
         UINT32_C(0x96f04895),
         UINT32_C(0x41f740da),
         UINT32_C(0x082974bc),
         UINT32_C(0xdf2e7cf3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0054c37a),
         UINT32_C(0xa07a1991),
         UINT32_C(0xa02edaeb),
         UINT32_C(0x00030014),
         UINT32_C(0x0057c36e),
         UINT32_C(0xa0791985),
         UINT32_C(0xa02ddaff),
         UINT32_C(0x00009017),
         UINT32_C(0x0054536d),
         UINT32_C(0xa07a8986),
         UINT32_C(0xa02e4afc),
         UINT32_C(0x00039003),
         UINT32_C(0x00575379),
         UINT32_C(0xa0798992),
         UINT32_C(0xa02d4ae8)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802a61),
         UINT32_C(0x3fd03d0c),
         UINT32_C(0x3fd0176d),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f802be1),
         UINT32_C(0x3fd03c8c),
         UINT32_C(0x3fd016ed),
         UINT32_C(0x3f800048),
         UINT32_C(0x3f802a29),
         UINT32_C(0x3fd03d44),
         UINT32_C(0x3fd01725),
         UINT32_C(0x3f8001c8),
         UINT32_C(0x3f802ba9),
         UINT32_C(0x3fd03cc4),
         UINT32_C(0x3fd016a5)},
        UINT32_C(0xfff80000),
        {0x35,0xaa,0x33,0x13,0x1e,0x49,0x0f,0x90,0x67,0x81,
         0x1c,0x7d,0x0f,0xbb,0xe4,0x70,0x38,0x4a,0x04,0x5f,0x00}
    },
    {
        /* No.408 delta:1682 weight:1569 */
        11213,
        61,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa312a06e),
         UINT32_C(0x7f135ca4),
         UINT32_C(0xdc01fcca),
         UINT32_C(0x01a0198e),
         UINT32_C(0xa2b2b9e0),
         UINT32_C(0x7eb3452a),
         UINT32_C(0xdda1e544),
         UINT32_C(0x000036a9),
         UINT32_C(0xa31296c7),
         UINT32_C(0x7f136a0d),
         UINT32_C(0xdc01ca63),
         UINT32_C(0x01a02f27),
         UINT32_C(0xa2b28f49),
         UINT32_C(0x7eb37383),
         UINT32_C(0xdda1d3ed)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004c01d3),
         UINT32_C(0x4020013f),
         UINT32_C(0x406c00ec),
         UINT32_C(0x2021002d),
         UINT32_C(0x206d01fe),
         UINT32_C(0x60010112),
         UINT32_C(0x604d00c1),
         UINT32_C(0x00000077),
         UINT32_C(0x004c01a4),
         UINT32_C(0x40200148),
         UINT32_C(0x406c009b),
         UINT32_C(0x2021005a),
         UINT32_C(0x206d0189),
         UINT32_C(0x60010165),
         UINT32_C(0x604d00b6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802600),
         UINT32_C(0x3fa01000),
         UINT32_C(0x3fa03600),
         UINT32_C(0x3f901080),
         UINT32_C(0x3f903680),
         UINT32_C(0x3fb00080),
         UINT32_C(0x3fb02680),
         UINT32_C(0x3f800000),
         UINT32_C(0x3f802600),
         UINT32_C(0x3fa01000),
         UINT32_C(0x3fa03600),
         UINT32_C(0x3f901080),
         UINT32_C(0x3f903680),
         UINT32_C(0x3fb00080),
         UINT32_C(0x3fb02680)},
        UINT32_C(0xfff80000),
        {0xa8,0xbf,0x78,0xce,0x3e,0xe9,0x50,0xd4,0x3a,0x88,
         0x2f,0xbe,0x47,0x8e,0x68,0xc1,0x47,0x4f,0x76,0x96,0x00}
    },
    {
        /* No.409 delta:1013 weight:1173 */
        11213,
        39,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x247e8d9b),
         UINT32_C(0xac3b09dc),
         UINT32_C(0x88458447),
         UINT32_C(0xd0701993),
         UINT32_C(0xf40e9408),
         UINT32_C(0x7c4b104f),
         UINT32_C(0x58359dd4),
         UINT32_C(0x000001f0),
         UINT32_C(0x247e8c6b),
         UINT32_C(0xac3b082c),
         UINT32_C(0x884585b7),
         UINT32_C(0xd0701863),
         UINT32_C(0xf40e95f8),
         UINT32_C(0x7c4b11bf),
         UINT32_C(0x58359c24)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3041455a),
         UINT32_C(0x8002664e),
         UINT32_C(0xb0432314),
         UINT32_C(0x5001b076),
         UINT32_C(0x6040f52c),
         UINT32_C(0xd003d638),
         UINT32_C(0xe0429362),
         UINT32_C(0x04005419),
         UINT32_C(0x34411143),
         UINT32_C(0x84023257),
         UINT32_C(0xb443770d),
         UINT32_C(0x5401e46f),
         UINT32_C(0x6440a135),
         UINT32_C(0xd4038221),
         UINT32_C(0xe442c77b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9820a2),
         UINT32_C(0x3fc00133),
         UINT32_C(0x3fd82191),
         UINT32_C(0x3fa800d8),
         UINT32_C(0x3fb0207a),
         UINT32_C(0x3fe801eb),
         UINT32_C(0x3ff02149),
         UINT32_C(0x3f82002a),
         UINT32_C(0x3f9a2088),
         UINT32_C(0x3fc20119),
         UINT32_C(0x3fda21bb),
         UINT32_C(0x3faa00f2),
         UINT32_C(0x3fb22050),
         UINT32_C(0x3fea01c1),
         UINT32_C(0x3ff22163)},
        UINT32_C(0xfff80000),
        {0xf0,0xc1,0x7d,0x8b,0xe2,0x9e,0x59,0x35,0x96,0x48,
         0xd0,0x14,0x5e,0x8f,0x0b,0x36,0x00,0xce,0xf1,0x71,0x00}
    },
    {
        /* No.410 delta:1115 weight:1363 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8192a8cc),
         UINT32_C(0xa56576fc),
         UINT32_C(0x24f7de30),
         UINT32_C(0xbca019ad),
         UINT32_C(0x3d32b161),
         UINT32_C(0x19c56f51),
         UINT32_C(0x9857c79d),
         UINT32_C(0x00009b4e),
         UINT32_C(0x81923382),
         UINT32_C(0xa565edb2),
         UINT32_C(0x24f7457e),
         UINT32_C(0xbca082e3),
         UINT32_C(0x3d322a2f),
         UINT32_C(0x19c5f41f),
         UINT32_C(0x98575cd3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10349155),
         UINT32_C(0x406750ae),
         UINT32_C(0x5053c1fb),
         UINT32_C(0x4002640c),
         UINT32_C(0x5036f559),
         UINT32_C(0x006534a2),
         UINT32_C(0x1051a5f7),
         UINT32_C(0x40012418),
         UINT32_C(0x5035b54d),
         UINT32_C(0x006674b6),
         UINT32_C(0x1052e5e3),
         UINT32_C(0x00034014),
         UINT32_C(0x1037d141),
         UINT32_C(0x406410ba),
         UINT32_C(0x505081ef)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f881a48),
         UINT32_C(0x3fa033a8),
         UINT32_C(0x3fa829e0),
         UINT32_C(0x3fa00132),
         UINT32_C(0x3fa81b7a),
         UINT32_C(0x3f80329a),
         UINT32_C(0x3f8828d2),
         UINT32_C(0x3fa00092),
         UINT32_C(0x3fa81ada),
         UINT32_C(0x3f80333a),
         UINT32_C(0x3f882972),
         UINT32_C(0x3f8001a0),
         UINT32_C(0x3f881be8),
         UINT32_C(0x3fa03208),
         UINT32_C(0x3fa82840)},
        UINT32_C(0xfff80000),
        {0x15,0x0b,0x2c,0xe6,0xe0,0x4c,0x62,0xc1,0x40,0x7a,
         0x71,0x13,0xea,0xbd,0x9d,0x38,0xd7,0x7f,0xa8,0xac,0x00}
    },
    {
        /* No.411 delta:1393 weight:1675 */
        11213,
        17,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa0095e24),
         UINT32_C(0xfab39763),
         UINT32_C(0x5abac947),
         UINT32_C(0xb28019b8),
         UINT32_C(0x1289479c),
         UINT32_C(0x48338edb),
         UINT32_C(0xe83ad0ff),
         UINT32_C(0x00009b6b),
         UINT32_C(0xa009c54f),
         UINT32_C(0xfab30c08),
         UINT32_C(0x5aba522c),
         UINT32_C(0xb28082d3),
         UINT32_C(0x1289dcf7),
         UINT32_C(0x483315b0),
         UINT32_C(0xe83a4b94)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4a5decba),
         UINT32_C(0x00562411),
         UINT32_C(0x4a0bc8ab),
         UINT32_C(0x4406e13e),
         UINT32_C(0x0e5b0d84),
         UINT32_C(0x4450c52f),
         UINT32_C(0x0e0d2995),
         UINT32_C(0x007880b8),
         UINT32_C(0x4a256c02),
         UINT32_C(0x002ea4a9),
         UINT32_C(0x4a734813),
         UINT32_C(0x447e6186),
         UINT32_C(0x0e238d3c),
         UINT32_C(0x44284597),
         UINT32_C(0x0e75a92d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa52ef6),
         UINT32_C(0x3f802b12),
         UINT32_C(0x3fa505e4),
         UINT32_C(0x3fa20370),
         UINT32_C(0x3f872d86),
         UINT32_C(0x3fa22862),
         UINT32_C(0x3f870694),
         UINT32_C(0x3f803c40),
         UINT32_C(0x3fa512b6),
         UINT32_C(0x3f801752),
         UINT32_C(0x3fa539a4),
         UINT32_C(0x3fa23f30),
         UINT32_C(0x3f8711c6),
         UINT32_C(0x3fa21422),
         UINT32_C(0x3f873ad4)},
        UINT32_C(0xfff80000),
        {0xdb,0x9e,0xc8,0xb1,0xe3,0x0b,0x69,0x0d,0xf1,0x8a,
         0x58,0x17,0xc1,0xe2,0xaa,0xad,0x52,0x36,0x28,0x41,0x00}
    },
    {
        /* No.412 delta:911 weight:1285 */
        11213,
        45,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa1135c19),
         UINT32_C(0xa2371c1f),
         UINT32_C(0x03244006),
         UINT32_C(0x8bc019c2),
         UINT32_C(0x2ad345db),
         UINT32_C(0x29f705dd),
         UINT32_C(0x88e459c4),
         UINT32_C(0x0000e704),
         UINT32_C(0xa113bb1d),
         UINT32_C(0xa237fb1b),
         UINT32_C(0x0324a702),
         UINT32_C(0x8bc0fec6),
         UINT32_C(0x2ad3a2df),
         UINT32_C(0x29f7e2d9),
         UINT32_C(0x88e4bec0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x1003ab1e),
         UINT32_C(0x1000e015),
         UINT32_C(0x00034b0b),
         UINT32_C(0x4068580c),
         UINT32_C(0x506bf312),
         UINT32_C(0x5068b819),
         UINT32_C(0x406b1307),
         UINT32_C(0x7074100e),
         UINT32_C(0x6077bb10),
         UINT32_C(0x6074f01b),
         UINT32_C(0x70775b05),
         UINT32_C(0x301c4802),
         UINT32_C(0x201fe31c),
         UINT32_C(0x201ca817),
         UINT32_C(0x301f0309)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8801d5),
         UINT32_C(0x3f880070),
         UINT32_C(0x3f8001a5),
         UINT32_C(0x3fa0342c),
         UINT32_C(0x3fa835f9),
         UINT32_C(0x3fa8345c),
         UINT32_C(0x3fa03589),
         UINT32_C(0x3fb83a08),
         UINT32_C(0x3fb03bdd),
         UINT32_C(0x3fb03a78),
         UINT32_C(0x3fb83bad),
         UINT32_C(0x3f980e24),
         UINT32_C(0x3f900ff1),
         UINT32_C(0x3f900e54),
         UINT32_C(0x3f980f81)},
        UINT32_C(0xfff80000),
        {0xe2,0xff,0x51,0x6a,0x3c,0x06,0xde,0x51,0x5b,0x4f,
         0x25,0xc4,0x5a,0x0a,0x5d,0x3f,0xa9,0x40,0x0f,0xf0,0x00}
    },
    {
        /* No.413 delta:1113 weight:1727 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3c2bcd99),
         UINT32_C(0x2b6fe7c4),
         UINT32_C(0x17442a5d),
         UINT32_C(0x496019d0),
         UINT32_C(0x754bd449),
         UINT32_C(0x620ffe14),
         UINT32_C(0x5e24338d),
         UINT32_C(0x00007a55),
         UINT32_C(0x3c2bb7cc),
         UINT32_C(0x2b6f9d91),
         UINT32_C(0x17445008),
         UINT32_C(0x49606385),
         UINT32_C(0x754bae1c),
         UINT32_C(0x620f8441),
         UINT32_C(0x5e2449d8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x105c81be),
         UINT32_C(0x00228dab),
         UINT32_C(0x107e0c15),
         UINT32_C(0x10023017),
         UINT32_C(0x005eb1a9),
         UINT32_C(0x1020bdbc),
         UINT32_C(0x007c3c02),
         UINT32_C(0x20020014),
         UINT32_C(0x305e81aa),
         UINT32_C(0x20208dbf),
         UINT32_C(0x307c0c01),
         UINT32_C(0x30003003),
         UINT32_C(0x205cb1bd),
         UINT32_C(0x3022bda8),
         UINT32_C(0x207e3c16)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f882e40),
         UINT32_C(0x3f801146),
         UINT32_C(0x3f883f06),
         UINT32_C(0x3f880118),
         UINT32_C(0x3f802f58),
         UINT32_C(0x3f88105e),
         UINT32_C(0x3f803e1e),
         UINT32_C(0x3f900100),
         UINT32_C(0x3f982f40),
         UINT32_C(0x3f901046),
         UINT32_C(0x3f983e06),
         UINT32_C(0x3f980018),
         UINT32_C(0x3f902e58),
         UINT32_C(0x3f98115e),
         UINT32_C(0x3f903f1e)},
        UINT32_C(0xfff80000),
        {0xa2,0xe7,0x43,0xe5,0x82,0x36,0xdc,0xe3,0x6e,0xe2,
         0x55,0xd8,0xfe,0x7c,0x4c,0x56,0xc4,0x20,0x1b,0xe2,0x00}
    },
    {
        /* No.414 delta:1720 weight:1681 */
        11213,
        29,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x61318219),
         UINT32_C(0x38a5e2e3),
         UINT32_C(0x599460fa),
         UINT32_C(0x2a0019e9),
         UINT32_C(0x4b319bf0),
         UINT32_C(0x12a5fb0a),
         UINT32_C(0x73947913),
         UINT32_C(0x00003497),
         UINT32_C(0x6131b68e),
         UINT32_C(0x38a5d674),
         UINT32_C(0x5994546d),
         UINT32_C(0x2a002d7e),
         UINT32_C(0x4b31af67),
         UINT32_C(0x12a5cf9d),
         UINT32_C(0x73944d84)},
        {UINT32_C(0x00000000),
         UINT32_C(0x003c01ba),
         UINT32_C(0x6022c1eb),
         UINT32_C(0x601ec051),
         UINT32_C(0x106141d6),
         UINT32_C(0x105d406c),
         UINT32_C(0x7043803d),
         UINT32_C(0x707f8187),
         UINT32_C(0x000260b7),
         UINT32_C(0x003e610d),
         UINT32_C(0x6020a15c),
         UINT32_C(0x601ca0e6),
         UINT32_C(0x10632161),
         UINT32_C(0x105f20db),
         UINT32_C(0x7041e08a),
         UINT32_C(0x707de130)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801e00),
         UINT32_C(0x3fb01160),
         UINT32_C(0x3fb00f60),
         UINT32_C(0x3f8830a0),
         UINT32_C(0x3f882ea0),
         UINT32_C(0x3fb821c0),
         UINT32_C(0x3fb83fc0),
         UINT32_C(0x3f800130),
         UINT32_C(0x3f801f30),
         UINT32_C(0x3fb01050),
         UINT32_C(0x3fb00e50),
         UINT32_C(0x3f883190),
         UINT32_C(0x3f882f90),
         UINT32_C(0x3fb820f0),
         UINT32_C(0x3fb83ef0)},
        UINT32_C(0xfff80000),
        {0x0e,0x4f,0x4e,0x4b,0x3f,0xba,0x64,0x69,0x9d,0xf0,
         0x3a,0x12,0x3d,0xd1,0xe8,0x04,0x82,0x7a,0x67,0xe8,0x00}
    },
    {
        /* No.415 delta:776 weight:1311 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf9a60b27),
         UINT32_C(0xa0ea6250),
         UINT32_C(0x594c6977),
         UINT32_C(0xdee019f9),
         UINT32_C(0x274612de),
         UINT32_C(0x7e0a7ba9),
         UINT32_C(0x87ac708e),
         UINT32_C(0x00003ca0),
         UINT32_C(0xf9a63787),
         UINT32_C(0xa0ea5ef0),
         UINT32_C(0x594c55d7),
         UINT32_C(0xdee02559),
         UINT32_C(0x27462e7e),
         UINT32_C(0x7e0a4709),
         UINT32_C(0x87ac4c2e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x606091b3),
         UINT32_C(0x40302129),
         UINT32_C(0x2050b09a),
         UINT32_C(0x10440165),
         UINT32_C(0x702490d6),
         UINT32_C(0x5074204c),
         UINT32_C(0x3014b1ff),
         UINT32_C(0x5008405c),
         UINT32_C(0x3068d1ef),
         UINT32_C(0x10386175),
         UINT32_C(0x7058f0c6),
         UINT32_C(0x404c4139),
         UINT32_C(0x202cd08a),
         UINT32_C(0x007c6010),
         UINT32_C(0x601cf1a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb03048),
         UINT32_C(0x3fa01810),
         UINT32_C(0x3f902858),
         UINT32_C(0x3f882200),
         UINT32_C(0x3fb81248),
         UINT32_C(0x3fa83a10),
         UINT32_C(0x3f980a58),
         UINT32_C(0x3fa80420),
         UINT32_C(0x3f983468),
         UINT32_C(0x3f881c30),
         UINT32_C(0x3fb82c78),
         UINT32_C(0x3fa02620),
         UINT32_C(0x3f901668),
         UINT32_C(0x3f803e30),
         UINT32_C(0x3fb00e78)},
        UINT32_C(0xfff80000),
        {0xa1,0x33,0x08,0x47,0xcc,0x62,0xe4,0x95,0xe2,0x64,
         0xa2,0x48,0xf9,0x1a,0x10,0xd3,0xd1,0xe8,0xd9,0xc2,0x00}
    },
    {
        /* No.416 delta:1715 weight:1591 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x004285ba),
         UINT32_C(0xc559b40b),
         UINT32_C(0xc51b31b1),
         UINT32_C(0xbb901a0c),
         UINT32_C(0xbbd29fb6),
         UINT32_C(0x7ec9ae07),
         UINT32_C(0x7e8b2bbd),
         UINT32_C(0x00004bd6),
         UINT32_C(0x0042ce6c),
         UINT32_C(0xc559ffdd),
         UINT32_C(0xc51b7a67),
         UINT32_C(0xbb9051da),
         UINT32_C(0xbbd2d460),
         UINT32_C(0x7ec9e5d1),
         UINT32_C(0x7e8b606b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0174813a),
         UINT32_C(0x680800d3),
         UINT32_C(0x697c81e9),
         UINT32_C(0x005a01dc),
         UINT32_C(0x012e80e6),
         UINT32_C(0x6852010f),
         UINT32_C(0x69268035),
         UINT32_C(0x0024001f),
         UINT32_C(0x01508125),
         UINT32_C(0x682c00cc),
         UINT32_C(0x695881f6),
         UINT32_C(0x007e01c3),
         UINT32_C(0x010a80f9),
         UINT32_C(0x68760110),
         UINT32_C(0x6902802a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80ba40),
         UINT32_C(0x3fb40400),
         UINT32_C(0x3fb4be40),
         UINT32_C(0x3f802d00),
         UINT32_C(0x3f809740),
         UINT32_C(0x3fb42900),
         UINT32_C(0x3fb49340),
         UINT32_C(0x3f801200),
         UINT32_C(0x3f80a840),
         UINT32_C(0x3fb41600),
         UINT32_C(0x3fb4ac40),
         UINT32_C(0x3f803f00),
         UINT32_C(0x3f808540),
         UINT32_C(0x3fb43b00),
         UINT32_C(0x3fb48140)},
        UINT32_C(0xfff80000),
        {0x78,0xc2,0x13,0xe8,0x63,0xa1,0x0a,0x39,0x4f,0x07,
         0x47,0x49,0x07,0xd9,0xa7,0x1e,0x0d,0x3f,0x92,0x15,0x00}
    },
    {
        /* No.417 delta:1194 weight:1671 */
        11213,
        22,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x198b5884),
         UINT32_C(0x2bad330c),
         UINT32_C(0x32266b88),
         UINT32_C(0x1db01a18),
         UINT32_C(0x043b429c),
         UINT32_C(0x361d2914),
         UINT32_C(0x2f967190),
         UINT32_C(0x0000fa5b),
         UINT32_C(0x198ba2df),
         UINT32_C(0x2badc957),
         UINT32_C(0x322691d3),
         UINT32_C(0x1db0e043),
         UINT32_C(0x043bb8c7),
         UINT32_C(0x361dd34f),
         UINT32_C(0x2f968bcb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x287ca0b6),
         UINT32_C(0x24d2010d),
         UINT32_C(0x0caea1bb),
         UINT32_C(0x005a4014),
         UINT32_C(0x2826e0a2),
         UINT32_C(0x24884119),
         UINT32_C(0x0cf4e1af),
         UINT32_C(0x3048d47e),
         UINT32_C(0x183474c8),
         UINT32_C(0x149ad573),
         UINT32_C(0x3ce675c5),
         UINT32_C(0x3012946a),
         UINT32_C(0x186e34dc),
         UINT32_C(0x14c09567),
         UINT32_C(0x3cbc35d1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f943e50),
         UINT32_C(0x3f926900),
         UINT32_C(0x3f865750),
         UINT32_C(0x3f802d20),
         UINT32_C(0x3f941370),
         UINT32_C(0x3f924420),
         UINT32_C(0x3f867a70),
         UINT32_C(0x3f98246a),
         UINT32_C(0x3f8c1a3a),
         UINT32_C(0x3f8a4d6a),
         UINT32_C(0x3f9e733a),
         UINT32_C(0x3f98094a),
         UINT32_C(0x3f8c371a),
         UINT32_C(0x3f8a604a),
         UINT32_C(0x3f9e5e1a)},
        UINT32_C(0xfff80000),
        {0x98,0xd1,0xda,0x5a,0x80,0x18,0xbd,0xae,0x24,0x02,
         0x8c,0x67,0x6d,0xbc,0x97,0xd5,0x50,0x94,0x3f,0xc1,0x00}
    },
    {
        /* No.418 delta:867 weight:1673 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd090b11f),
         UINT32_C(0x8d9806df),
         UINT32_C(0x5d08b7c0),
         UINT32_C(0x6f201a25),
         UINT32_C(0xbfb0ab3a),
         UINT32_C(0xe2b81cfa),
         UINT32_C(0x3228ade5),
         UINT32_C(0x0000721c),
         UINT32_C(0xd090c303),
         UINT32_C(0x8d9874c3),
         UINT32_C(0x5d08c5dc),
         UINT32_C(0x6f206839),
         UINT32_C(0xbfb0d926),
         UINT32_C(0xe2b86ee6),
         UINT32_C(0x3228dff9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x30610032),
         UINT32_C(0x8044460e),
         UINT32_C(0xb025463c),
         UINT32_C(0x0002e295),
         UINT32_C(0x3063e2a7),
         UINT32_C(0x8046a49b),
         UINT32_C(0xb027a4a9),
         UINT32_C(0x00018de8),
         UINT32_C(0x30608dda),
         UINT32_C(0x8045cbe6),
         UINT32_C(0xb024cbd4),
         UINT32_C(0x00036f7d),
         UINT32_C(0x30626f4f),
         UINT32_C(0x80472973),
         UINT32_C(0xb0262941)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f983080),
         UINT32_C(0x3fc02223),
         UINT32_C(0x3fd812a3),
         UINT32_C(0x3f800171),
         UINT32_C(0x3f9831f1),
         UINT32_C(0x3fc02352),
         UINT32_C(0x3fd813d2),
         UINT32_C(0x3f8000c6),
         UINT32_C(0x3f983046),
         UINT32_C(0x3fc022e5),
         UINT32_C(0x3fd81265),
         UINT32_C(0x3f8001b7),
         UINT32_C(0x3f983137),
         UINT32_C(0x3fc02394),
         UINT32_C(0x3fd81314)},
        UINT32_C(0xfff80000),
        {0xb5,0x6e,0x06,0xe7,0xf1,0xb2,0xef,0x9e,0x92,0xaf,
         0xbc,0xad,0x80,0xc6,0x58,0x7e,0xd2,0x18,0xa5,0x7b,0x00}
    },
    {
        /* No.419 delta:1693 weight:1439 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xea68a7ff),
         UINT32_C(0x03799b91),
         UINT32_C(0xe9113c6e),
         UINT32_C(0x92f01a33),
         UINT32_C(0x7898bdcc),
         UINT32_C(0x918981a2),
         UINT32_C(0x7be1265d),
         UINT32_C(0x0000e0b0),
         UINT32_C(0xea68474f),
         UINT32_C(0x03797b21),
         UINT32_C(0xe911dcde),
         UINT32_C(0x92f0fa83),
         UINT32_C(0x78985d7c),
         UINT32_C(0x91896112),
         UINT32_C(0x7be1c6ed)},
        {UINT32_C(0x00000000),
         UINT32_C(0x283e821a),
         UINT32_C(0x00520054),
         UINT32_C(0x286c824e),
         UINT32_C(0x00020036),
         UINT32_C(0x283c822c),
         UINT32_C(0x00500062),
         UINT32_C(0x286e8278),
         UINT32_C(0x401000a7),
         UINT32_C(0x682e82bd),
         UINT32_C(0x404200f3),
         UINT32_C(0x687c82e9),
         UINT32_C(0x40120091),
         UINT32_C(0x682c828b),
         UINT32_C(0x404000c5),
         UINT32_C(0x687e82df)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f941f41),
         UINT32_C(0x3f802900),
         UINT32_C(0x3f943641),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f941e41),
         UINT32_C(0x3f802800),
         UINT32_C(0x3f943741),
         UINT32_C(0x3fa00800),
         UINT32_C(0x3fb41741),
         UINT32_C(0x3fa02100),
         UINT32_C(0x3fb43e41),
         UINT32_C(0x3fa00900),
         UINT32_C(0x3fb41641),
         UINT32_C(0x3fa02000),
         UINT32_C(0x3fb43f41)},
        UINT32_C(0xfff80000),
        {0x3d,0x08,0x4c,0x67,0xfc,0x9c,0x48,0xe9,0x46,0x4b,
         0x9a,0xc0,0x56,0xd4,0x48,0xbf,0x57,0x04,0x85,0x7b,0x00}
    },
    {
        /* No.420 delta:795 weight:1591 */
        11213,
        54,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x255d4f5c),
         UINT32_C(0x5cd2db7e),
         UINT32_C(0x798f9422),
         UINT32_C(0xa9201a4f),
         UINT32_C(0x8c7d5513),
         UINT32_C(0xf5f2c131),
         UINT32_C(0xd0af8e6d),
         UINT32_C(0x0000cb40),
         UINT32_C(0x255d841c),
         UINT32_C(0x5cd2103e),
         UINT32_C(0x798f5f62),
         UINT32_C(0xa920d10f),
         UINT32_C(0x8c7d9e53),
         UINT32_C(0xf5f20a71),
         UINT32_C(0xd0af452d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5021117e),
         UINT32_C(0x084011f9),
         UINT32_C(0x58610087),
         UINT32_C(0x9000001a),
         UINT32_C(0xc0211164),
         UINT32_C(0x984011e3),
         UINT32_C(0xc861009d),
         UINT32_C(0x40020cb7),
         UINT32_C(0x10231dc9),
         UINT32_C(0x48421d4e),
         UINT32_C(0x18630c30),
         UINT32_C(0xd0020cad),
         UINT32_C(0x80231dd3),
         UINT32_C(0xd8421d54),
         UINT32_C(0x88630c2a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa81088),
         UINT32_C(0x3f842008),
         UINT32_C(0x3fac3080),
         UINT32_C(0x3fc80000),
         UINT32_C(0x3fe01088),
         UINT32_C(0x3fcc2008),
         UINT32_C(0x3fe43080),
         UINT32_C(0x3fa00106),
         UINT32_C(0x3f88118e),
         UINT32_C(0x3fa4210e),
         UINT32_C(0x3f8c3186),
         UINT32_C(0x3fe80106),
         UINT32_C(0x3fc0118e),
         UINT32_C(0x3fec210e),
         UINT32_C(0x3fc43186)},
        UINT32_C(0xfff80000),
        {0x74,0x32,0x9a,0x95,0xe8,0xe5,0x81,0x16,0x6f,0x6f,
         0x8c,0x54,0xef,0xc7,0x6d,0x3c,0xe4,0x6d,0xb0,0x78,0x00}
    },
    {
        /* No.421 delta:1100 weight:1723 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x37fb03b4),
         UINT32_C(0xdf064fab),
         UINT32_C(0xe8fd4c1f),
         UINT32_C(0xdf801a56),
         UINT32_C(0xe87b19e2),
         UINT32_C(0x008655fd),
         UINT32_C(0x377d5649),
         UINT32_C(0x000089fe),
         UINT32_C(0x37fb8a4a),
         UINT32_C(0xdf06c655),
         UINT32_C(0xe8fdc5e1),
         UINT32_C(0xdf8093a8),
         UINT32_C(0xe87b901c),
         UINT32_C(0x0086dc03),
         UINT32_C(0x377ddfb7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00448097),
         UINT32_C(0x1002018c),
         UINT32_C(0x1046811b),
         UINT32_C(0x000260ef),
         UINT32_C(0x0046e078),
         UINT32_C(0x10006163),
         UINT32_C(0x1044e1f4),
         UINT32_C(0x0003e1bc),
         UINT32_C(0x0047612b),
         UINT32_C(0x1001e030),
         UINT32_C(0x104560a7),
         UINT32_C(0x00018153),
         UINT32_C(0x004501c4),
         UINT32_C(0x100380df),
         UINT32_C(0x10470048)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802240),
         UINT32_C(0x3f880100),
         UINT32_C(0x3f882340),
         UINT32_C(0x3f800130),
         UINT32_C(0x3f802370),
         UINT32_C(0x3f880030),
         UINT32_C(0x3f882270),
         UINT32_C(0x3f8001f0),
         UINT32_C(0x3f8023b0),
         UINT32_C(0x3f8800f0),
         UINT32_C(0x3f8822b0),
         UINT32_C(0x3f8000c0),
         UINT32_C(0x3f802280),
         UINT32_C(0x3f8801c0),
         UINT32_C(0x3f882380)},
        UINT32_C(0xfff80000),
        {0xce,0xc9,0x70,0x4d,0x28,0x45,0xcd,0x59,0x03,0x6b,
         0x34,0x1c,0xc7,0x4b,0xe8,0x03,0x11,0x1a,0x99,0xd3,0x00}
    },
    {
        /* No.422 delta:814 weight:1609 */
        11213,
        81,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3863afab),
         UINT32_C(0x2366d254),
         UINT32_C(0x1b057dff),
         UINT32_C(0xc9301a6b),
         UINT32_C(0xf153b5c0),
         UINT32_C(0xea56c83f),
         UINT32_C(0xd2356794),
         UINT32_C(0x0000630c),
         UINT32_C(0x3863cca7),
         UINT32_C(0x2366b158),
         UINT32_C(0x1b051ef3),
         UINT32_C(0xc9307967),
         UINT32_C(0xf153d6cc),
         UINT32_C(0xea56ab33),
         UINT32_C(0xd2350498)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80005053),
         UINT32_C(0x402000ba),
         UINT32_C(0xc02050e9),
         UINT32_C(0x4003e077),
         UINT32_C(0xc003b024),
         UINT32_C(0x0023e0cd),
         UINT32_C(0x8023b09e),
         UINT32_C(0x50000118),
         UINT32_C(0xd000514b),
         UINT32_C(0x102001a2),
         UINT32_C(0x902051f1),
         UINT32_C(0x1003e16f),
         UINT32_C(0x9003b13c),
         UINT32_C(0x5023e1d5),
         UINT32_C(0xd023b186)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00028),
         UINT32_C(0x3fa01000),
         UINT32_C(0x3fe01028),
         UINT32_C(0x3fa001f0),
         UINT32_C(0x3fe001d8),
         UINT32_C(0x3f8011f0),
         UINT32_C(0x3fc011d8),
         UINT32_C(0x3fa80000),
         UINT32_C(0x3fe80028),
         UINT32_C(0x3f881000),
         UINT32_C(0x3fc81028),
         UINT32_C(0x3f8801f0),
         UINT32_C(0x3fc801d8),
         UINT32_C(0x3fa811f0),
         UINT32_C(0x3fe811d8)},
        UINT32_C(0xfff80000),
        {0xe1,0x6e,0xa6,0x29,0xce,0xac,0x56,0x2c,0x51,0xf5,
         0xed,0x2b,0x0c,0xa5,0x65,0xf4,0xb5,0xae,0x43,0x81,0x00}
    },
    {
        /* No.423 delta:804 weight:1751 */
        11213,
        53,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x37fb03b4),
         UINT32_C(0xdf064fab),
         UINT32_C(0xe8fd4c1f),
         UINT32_C(0xdf801a76),
         UINT32_C(0xe87b19c2),
         UINT32_C(0x008655dd),
         UINT32_C(0x377d5669),
         UINT32_C(0x000089fe),
         UINT32_C(0x37fb8a4a),
         UINT32_C(0xdf06c655),
         UINT32_C(0xe8fdc5e1),
         UINT32_C(0xdf809388),
         UINT32_C(0xe87b903c),
         UINT32_C(0x0086dc23),
         UINT32_C(0x377ddf97)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20016137),
         UINT32_C(0x1002543b),
         UINT32_C(0x3003350c),
         UINT32_C(0x50008425),
         UINT32_C(0x7001e512),
         UINT32_C(0x4002d01e),
         UINT32_C(0x6003b129),
         UINT32_C(0x4400a80f),
         UINT32_C(0x6401c938),
         UINT32_C(0x5402fc34),
         UINT32_C(0x74039d03),
         UINT32_C(0x14002c2a),
         UINT32_C(0x34014d1d),
         UINT32_C(0x04027811),
         UINT32_C(0x24031926)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9000b0),
         UINT32_C(0x3f88012a),
         UINT32_C(0x3f98019a),
         UINT32_C(0x3fa80042),
         UINT32_C(0x3fb800f2),
         UINT32_C(0x3fa00168),
         UINT32_C(0x3fb001d8),
         UINT32_C(0x3fa20054),
         UINT32_C(0x3fb200e4),
         UINT32_C(0x3faa017e),
         UINT32_C(0x3fba01ce),
         UINT32_C(0x3f8a0016),
         UINT32_C(0x3f9a00a6),
         UINT32_C(0x3f82013c),
         UINT32_C(0x3f92018c)},
        UINT32_C(0xfff80000),
        {0x3c,0x2c,0x9b,0xc9,0xdb,0x8e,0x3d,0x36,0x5d,0xdf,
         0xa0,0xeb,0x2c,0x11,0x71,0xa9,0xc5,0xb3,0x48,0x7e,0x00}
    },
    {
        /* No.424 delta:3104 weight:631 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd90825a7),
         UINT32_C(0x47df8dbf),
         UINT32_C(0x9ed7a818),
         UINT32_C(0x45701a8e),
         UINT32_C(0x9c783f29),
         UINT32_C(0x02af9731),
         UINT32_C(0xdba7b296),
         UINT32_C(0x00002d8c),
         UINT32_C(0xd908082b),
         UINT32_C(0x47dfa033),
         UINT32_C(0x9ed78594),
         UINT32_C(0x45703702),
         UINT32_C(0x9c7812a5),
         UINT32_C(0x02afbabd),
         UINT32_C(0xdba79f1a)},
        {UINT32_C(0x00000000),
         UINT32_C(0xfd6002c1),
         UINT32_C(0x10b500c3),
         UINT32_C(0xedd50202),
         UINT32_C(0x4049100d),
         UINT32_C(0xbd2912cc),
         UINT32_C(0x50fc10ce),
         UINT32_C(0xad9c120f),
         UINT32_C(0xd000e011),
         UINT32_C(0x2d60e2d0),
         UINT32_C(0xc0b5e0d2),
         UINT32_C(0x3dd5e213),
         UINT32_C(0x9049f01c),
         UINT32_C(0x6d29f2dd),
         UINT32_C(0x80fcf0df),
         UINT32_C(0x7d9cf21e)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ffeb001),
         UINT32_C(0x3f885a80),
         UINT32_C(0x3ff6ea81),
         UINT32_C(0x3fa02488),
         UINT32_C(0x3fde9489),
         UINT32_C(0x3fa87e08),
         UINT32_C(0x3fd6ce09),
         UINT32_C(0x3fe80070),
         UINT32_C(0x3f96b071),
         UINT32_C(0x3fe05af0),
         UINT32_C(0x3f9eeaf1),
         UINT32_C(0x3fc824f8),
         UINT32_C(0x3fb694f9),
         UINT32_C(0x3fc07e78),
         UINT32_C(0x3fbece79)},
        UINT32_C(0xfff80000),
        {0x15,0x8e,0x88,0xbb,0xf9,0x37,0x89,0xe6,0xd7,0x5b,
         0xc9,0xfd,0x54,0x36,0x12,0x84,0x7d,0x9a,0x74,0x37,0x00}
    },
    {
        /* No.425 delta:1053 weight:1527 */
        11213,
        73,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6b29794b),
         UINT32_C(0x0da3033f),
         UINT32_C(0x668a7a74),
         UINT32_C(0xc3101a90),
         UINT32_C(0xa83963db),
         UINT32_C(0xceb319af),
         UINT32_C(0xa59a60e4),
         UINT32_C(0x00002517),
         UINT32_C(0x6b295c5c),
         UINT32_C(0x0da32628),
         UINT32_C(0x668a5f63),
         UINT32_C(0xc3103f87),
         UINT32_C(0xa83946cc),
         UINT32_C(0xceb33cb8),
         UINT32_C(0xa59a45f3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x804180de),
         UINT32_C(0x40440539),
         UINT32_C(0xc00585e7),
         UINT32_C(0x20404108),
         UINT32_C(0xa001c1d6),
         UINT32_C(0x60044431),
         UINT32_C(0xe045c4ef),
         UINT32_C(0x20702015),
         UINT32_C(0xa031a0cb),
         UINT32_C(0x6034252c),
         UINT32_C(0xe075a5f2),
         UINT32_C(0x0030611d),
         UINT32_C(0x8071e1c3),
         UINT32_C(0x40746424),
         UINT32_C(0xc035e4fa)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc020c0),
         UINT32_C(0x3fa02202),
         UINT32_C(0x3fe002c2),
         UINT32_C(0x3f902020),
         UINT32_C(0x3fd000e0),
         UINT32_C(0x3fb00222),
         UINT32_C(0x3ff022e2),
         UINT32_C(0x3f903810),
         UINT32_C(0x3fd018d0),
         UINT32_C(0x3fb01a12),
         UINT32_C(0x3ff03ad2),
         UINT32_C(0x3f801830),
         UINT32_C(0x3fc038f0),
         UINT32_C(0x3fa03a32),
         UINT32_C(0x3fe01af2)},
        UINT32_C(0xfff80000),
        {0xe9,0x03,0xeb,0x9e,0x61,0xab,0xc2,0x9b,0x13,0x95,
         0xb0,0x67,0x7d,0x21,0x0a,0xc5,0x77,0xe9,0xe1,0x5b,0x00}
    },
    {
        /* No.426 delta:894 weight:1671 */
        11213,
        48,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7516d380),
         UINT32_C(0x0bb65d81),
         UINT32_C(0x7ea08e01),
         UINT32_C(0x3b101aa3),
         UINT32_C(0x4e06c923),
         UINT32_C(0x30a64722),
         UINT32_C(0x45b094a2),
         UINT32_C(0x000040e3),
         UINT32_C(0x75169363),
         UINT32_C(0x0bb61d62),
         UINT32_C(0x7ea0cee2),
         UINT32_C(0x3b105a40),
         UINT32_C(0x4e0689c0),
         UINT32_C(0x30a607c1),
         UINT32_C(0x45b0d441)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4016c0d6),
         UINT32_C(0x0041403c),
         UINT32_C(0x405780ea),
         UINT32_C(0x0002460f),
         UINT32_C(0x401486d9),
         UINT32_C(0x00430633),
         UINT32_C(0x4055c6e5),
         UINT32_C(0x1005041b),
         UINT32_C(0x5013c4cd),
         UINT32_C(0x10444427),
         UINT32_C(0x505284f1),
         UINT32_C(0x10074214),
         UINT32_C(0x501182c2),
         UINT32_C(0x10460228),
         UINT32_C(0x5050c2fe)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00b60),
         UINT32_C(0x3f8020a0),
         UINT32_C(0x3fa02bc0),
         UINT32_C(0x3f800123),
         UINT32_C(0x3fa00a43),
         UINT32_C(0x3f802183),
         UINT32_C(0x3fa02ae3),
         UINT32_C(0x3f880282),
         UINT32_C(0x3fa809e2),
         UINT32_C(0x3f882222),
         UINT32_C(0x3fa82942),
         UINT32_C(0x3f8803a1),
         UINT32_C(0x3fa808c1),
         UINT32_C(0x3f882301),
         UINT32_C(0x3fa82861)},
        UINT32_C(0xfff80000),
        {0xdc,0x93,0x3f,0x7f,0x9a,0x0e,0xc2,0xb9,0x81,0x8d,
         0x3e,0x41,0x06,0x30,0xdf,0x25,0xa2,0xec,0x32,0x10,0x00}
    },
    {
        /* No.427 delta:1635 weight:1469 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x0e897e65),
         UINT32_C(0x138eb418),
         UINT32_C(0x1d07ca7d),
         UINT32_C(0x8f201abf),
         UINT32_C(0x81a964da),
         UINT32_C(0x9caeaea7),
         UINT32_C(0x9227d0c2),
         UINT32_C(0x00008a40),
         UINT32_C(0x0e89f425),
         UINT32_C(0x138e3e58),
         UINT32_C(0x1d07403d),
         UINT32_C(0x8f2090ff),
         UINT32_C(0x81a9ee9a),
         UINT32_C(0x9cae24e7),
         UINT32_C(0x92275a82)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6e5c1116),
         UINT32_C(0x00052033),
         UINT32_C(0x6e593125),
         UINT32_C(0x1901809d),
         UINT32_C(0x775d918b),
         UINT32_C(0x1904a0ae),
         UINT32_C(0x7758b1b8),
         UINT32_C(0x1163c81a),
         UINT32_C(0x7f3fd90c),
         UINT32_C(0x1166e829),
         UINT32_C(0x7f3af93f),
         UINT32_C(0x08624887),
         UINT32_C(0x663e5991),
         UINT32_C(0x086768b4),
         UINT32_C(0x663b79a2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb72e08),
         UINT32_C(0x3f800290),
         UINT32_C(0x3fb72c98),
         UINT32_C(0x3f8c80c0),
         UINT32_C(0x3fbbaec8),
         UINT32_C(0x3f8c8250),
         UINT32_C(0x3fbbac58),
         UINT32_C(0x3f88b1e4),
         UINT32_C(0x3fbf9fec),
         UINT32_C(0x3f88b374),
         UINT32_C(0x3fbf9d7c),
         UINT32_C(0x3f843124),
         UINT32_C(0x3fb31f2c),
         UINT32_C(0x3f8433b4),
         UINT32_C(0x3fb31dbc)},
        UINT32_C(0xfff80000),
        {0xe4,0xfa,0x76,0x5f,0xbf,0x62,0x4a,0x27,0x8a,0xbe,
         0xbd,0x36,0xae,0xef,0x0a,0x51,0x71,0xbd,0xbb,0x53,0x00}
    },
    {
        /* No.428 delta:2647 weight:869 */
        11213,
        5,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x43527f08),
         UINT32_C(0x9d9bc601),
         UINT32_C(0xdec9b909),
         UINT32_C(0x62d01ac0),
         UINT32_C(0x218265c8),
         UINT32_C(0xff4bdcc1),
         UINT32_C(0xbc19a3c9),
         UINT32_C(0x000031e0),
         UINT32_C(0x43524ee8),
         UINT32_C(0x9d9bf7e1),
         UINT32_C(0xdec988e9),
         UINT32_C(0x62d02b20),
         UINT32_C(0x21825428),
         UINT32_C(0xff4bed21),
         UINT32_C(0xbc199229)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc0650c7a),
         UINT32_C(0x3860005f),
         UINT32_C(0xf8050c25),
         UINT32_C(0x0c18851c),
         UINT32_C(0xcc7d8966),
         UINT32_C(0x34788543),
         UINT32_C(0xf41d8939),
         UINT32_C(0x18204149),
         UINT32_C(0xd8454d33),
         UINT32_C(0x20404116),
         UINT32_C(0xe0254d6c),
         UINT32_C(0x1438c455),
         UINT32_C(0xd45dc82f),
         UINT32_C(0x2c58c40a),
         UINT32_C(0xec3dc870)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe03286),
         UINT32_C(0x3f9c3000),
         UINT32_C(0x3ffc0286),
         UINT32_C(0x3f860c42),
         UINT32_C(0x3fe63ec4),
         UINT32_C(0x3f9a3c42),
         UINT32_C(0x3ffa0ec4),
         UINT32_C(0x3f8c1020),
         UINT32_C(0x3fec22a6),
         UINT32_C(0x3f902020),
         UINT32_C(0x3ff012a6),
         UINT32_C(0x3f8a1c62),
         UINT32_C(0x3fea2ee4),
         UINT32_C(0x3f962c62),
         UINT32_C(0x3ff61ee4)},
        UINT32_C(0xfff80000),
        {0x93,0x26,0x3d,0x15,0xb2,0xad,0xa9,0x17,0x31,0xc4,
         0x4b,0x19,0xf2,0xcd,0x2a,0x53,0xf7,0x46,0x04,0x86,0x00}
    },
    {
        /* No.429 delta:574 weight:1741 */
        11213,
        93,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x78bfa3bb),
         UINT32_C(0xb26daf1b),
         UINT32_C(0xcad20ca0),
         UINT32_C(0x8c901ad9),
         UINT32_C(0xf42fb962),
         UINT32_C(0x3efdb5c2),
         UINT32_C(0x46421679),
         UINT32_C(0x000057cd),
         UINT32_C(0x78bff476),
         UINT32_C(0xb26df8d6),
         UINT32_C(0xcad25b6d),
         UINT32_C(0x8c904d14),
         UINT32_C(0xf42feeaf),
         UINT32_C(0x3efde20f),
         UINT32_C(0x464241b4)},
        {UINT32_C(0x00000000),
         UINT32_C(0x407ec892),
         UINT32_C(0x0003b8cb),
         UINT32_C(0x407d7059),
         UINT32_C(0x00205005),
         UINT32_C(0x405e9897),
         UINT32_C(0x0023e8ce),
         UINT32_C(0x405d205c),
         UINT32_C(0x60100204),
         UINT32_C(0x206eca96),
         UINT32_C(0x6013bacf),
         UINT32_C(0x206d725d),
         UINT32_C(0x60305201),
         UINT32_C(0x204e9a93),
         UINT32_C(0x6033eaca),
         UINT32_C(0x204d2258)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa03f64),
         UINT32_C(0x3f8001dc),
         UINT32_C(0x3fa03eb8),
         UINT32_C(0x3f801028),
         UINT32_C(0x3fa02f4c),
         UINT32_C(0x3f8011f4),
         UINT32_C(0x3fa02e90),
         UINT32_C(0x3fb00801),
         UINT32_C(0x3f903765),
         UINT32_C(0x3fb009dd),
         UINT32_C(0x3f9036b9),
         UINT32_C(0x3fb01829),
         UINT32_C(0x3f90274d),
         UINT32_C(0x3fb019f5),
         UINT32_C(0x3f902691)},
        UINT32_C(0xfff80000),
        {0xf6,0xa3,0x4d,0x6c,0xcc,0x76,0xeb,0x15,0x04,0xa7,
         0xd2,0x15,0xe5,0x85,0xa1,0x29,0xed,0x3a,0xd8,0x51,0x00}
    },
    {
        /* No.430 delta:1044 weight:1679 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7f3e4b3c),
         UINT32_C(0x3db50e58),
         UINT32_C(0x428b4564),
         UINT32_C(0xe4101aea),
         UINT32_C(0x9b2e51d6),
         UINT32_C(0xd9a514b2),
         UINT32_C(0xa69b5f8e),
         UINT32_C(0x0000d877),
         UINT32_C(0x7f3e934b),
         UINT32_C(0x3db5d62f),
         UINT32_C(0x428b9d13),
         UINT32_C(0xe410c29d),
         UINT32_C(0x9b2e89a1),
         UINT32_C(0xd9a5ccc5),
         UINT32_C(0xa69b87f9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x101e1117),
         UINT32_C(0x41021eed),
         UINT32_C(0x511c0ffa),
         UINT32_C(0x0000106e),
         UINT32_C(0x101e0179),
         UINT32_C(0x41020e83),
         UINT32_C(0x511c1f94),
         UINT32_C(0x30230012),
         UINT32_C(0x203d1105),
         UINT32_C(0x71211eff),
         UINT32_C(0x613f0fe8),
         UINT32_C(0x3023107c),
         UINT32_C(0x203d016b),
         UINT32_C(0x71210e91),
         UINT32_C(0x613f1f86)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880f08),
         UINT32_C(0x3fa0810f),
         UINT32_C(0x3fa88e07),
         UINT32_C(0x3f800008),
         UINT32_C(0x3f880f00),
         UINT32_C(0x3fa08107),
         UINT32_C(0x3fa88e0f),
         UINT32_C(0x3f981180),
         UINT32_C(0x3f901e88),
         UINT32_C(0x3fb8908f),
         UINT32_C(0x3fb09f87),
         UINT32_C(0x3f981188),
         UINT32_C(0x3f901e80),
         UINT32_C(0x3fb89087),
         UINT32_C(0x3fb09f8f)},
        UINT32_C(0xfff80000),
        {0x31,0x88,0xd4,0xfd,0x08,0xd5,0x86,0x97,0xb7,0xc8,
         0xf4,0xee,0x84,0x1e,0x7a,0x4d,0x9c,0x4b,0xb3,0xb0,0x00}
    },
    {
        /* No.431 delta:987 weight:967 */
        11213,
        59,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2c1a5d06),
         UINT32_C(0x76bc8d6b),
         UINT32_C(0x5aa6d06d),
         UINT32_C(0x34c01af1),
         UINT32_C(0x18da47f7),
         UINT32_C(0x427c979a),
         UINT32_C(0x6e66ca9c),
         UINT32_C(0x0000659c),
         UINT32_C(0x2c1a389a),
         UINT32_C(0x76bce8f7),
         UINT32_C(0x5aa6b5f1),
         UINT32_C(0x34c07f6d),
         UINT32_C(0x18da226b),
         UINT32_C(0x427cf206),
         UINT32_C(0x6e66af00)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006c313e),
         UINT32_C(0x00038909),
         UINT32_C(0x006fb837),
         UINT32_C(0x0401012c),
         UINT32_C(0x046d3012),
         UINT32_C(0x04028825),
         UINT32_C(0x046eb91b),
         UINT32_C(0x2032214d),
         UINT32_C(0x205e1073),
         UINT32_C(0x2031a844),
         UINT32_C(0x205d997a),
         UINT32_C(0x24332061),
         UINT32_C(0x245f115f),
         UINT32_C(0x2430a968),
         UINT32_C(0x245c9856)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803618),
         UINT32_C(0x3f8001c4),
         UINT32_C(0x3f8037dc),
         UINT32_C(0x3f820080),
         UINT32_C(0x3f823698),
         UINT32_C(0x3f820144),
         UINT32_C(0x3f82375c),
         UINT32_C(0x3f901910),
         UINT32_C(0x3f902f08),
         UINT32_C(0x3f9018d4),
         UINT32_C(0x3f902ecc),
         UINT32_C(0x3f921990),
         UINT32_C(0x3f922f88),
         UINT32_C(0x3f921854),
         UINT32_C(0x3f922e4c)},
        UINT32_C(0xfff80000),
        {0xa8,0x3a,0x69,0x50,0x5c,0x5c,0xa1,0xaf,0x0b,0x54,
         0xee,0xb0,0x76,0x02,0xae,0x8b,0x6e,0x77,0xe7,0x55,0x00}
    },
    {
        /* No.432 delta:1531 weight:1641 */
        11213,
        25,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1adf62b5),
         UINT32_C(0x18570b8b),
         UINT32_C(0x0288693e),
         UINT32_C(0x89001b01),
         UINT32_C(0x93df79b4),
         UINT32_C(0x9157108a),
         UINT32_C(0x8b88723f),
         UINT32_C(0x000025aa),
         UINT32_C(0x1adf471f),
         UINT32_C(0x18572e21),
         UINT32_C(0x02884c94),
         UINT32_C(0x89003eab),
         UINT32_C(0x93df5c1e),
         UINT32_C(0x91573520),
         UINT32_C(0x8b885795)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0e9e017a),
         UINT32_C(0x00610113),
         UINT32_C(0x0eff0069),
         UINT32_C(0x00580148),
         UINT32_C(0x0ec60032),
         UINT32_C(0x0039005b),
         UINT32_C(0x0ea70121),
         UINT32_C(0x0004e182),
         UINT32_C(0x0e9ae0f8),
         UINT32_C(0x0065e091),
         UINT32_C(0x0efbe1eb),
         UINT32_C(0x005ce0ca),
         UINT32_C(0x0ec2e1b0),
         UINT32_C(0x003de1d9),
         UINT32_C(0x0ea3e0a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f874f00),
         UINT32_C(0x3f803080),
         UINT32_C(0x3f877f80),
         UINT32_C(0x3f802c00),
         UINT32_C(0x3f876300),
         UINT32_C(0x3f801c80),
         UINT32_C(0x3f875380),
         UINT32_C(0x3f800270),
         UINT32_C(0x3f874d70),
         UINT32_C(0x3f8032f0),
         UINT32_C(0x3f877df0),
         UINT32_C(0x3f802e70),
         UINT32_C(0x3f876170),
         UINT32_C(0x3f801ef0),
         UINT32_C(0x3f8751f0)},
        UINT32_C(0xfff80000),
        {0x8d,0xe9,0x17,0xb7,0x70,0xfc,0xcc,0x88,0xdc,0x5e,
         0x6c,0x4d,0x30,0xdc,0x8e,0xf8,0x2b,0x2f,0xf6,0xb6,0x00}
    },
    {
        /* No.433 delta:839 weight:1293 */
        11213,
        60,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3bd71db2),
         UINT32_C(0x48ca34cb),
         UINT32_C(0x731d2979),
         UINT32_C(0x27101b15),
         UINT32_C(0x1cc706a7),
         UINT32_C(0x6fda2fde),
         UINT32_C(0x540d326c),
         UINT32_C(0x0000081e),
         UINT32_C(0x3bd715ac),
         UINT32_C(0x48ca3cd5),
         UINT32_C(0x731d2167),
         UINT32_C(0x2710130b),
         UINT32_C(0x1cc70eb9),
         UINT32_C(0x6fda27c0),
         UINT32_C(0x540d3a72)},
        {UINT32_C(0x00000000),
         UINT32_C(0x90630612),
         UINT32_C(0x004c00fb),
         UINT32_C(0x902f06e9),
         UINT32_C(0x0027c1aa),
         UINT32_C(0x9044c7b8),
         UINT32_C(0x006bc151),
         UINT32_C(0x9008c743),
         UINT32_C(0x1820532e),
         UINT32_C(0x8843553c),
         UINT32_C(0x186c53d5),
         UINT32_C(0x880f55c7),
         UINT32_C(0x18079284),
         UINT32_C(0x88649496),
         UINT32_C(0x184b927f),
         UINT32_C(0x8828946d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc83183),
         UINT32_C(0x3f802600),
         UINT32_C(0x3fc81783),
         UINT32_C(0x3f8013e0),
         UINT32_C(0x3fc82263),
         UINT32_C(0x3f8035e0),
         UINT32_C(0x3fc80463),
         UINT32_C(0x3f8c1029),
         UINT32_C(0x3fc421aa),
         UINT32_C(0x3f8c3629),
         UINT32_C(0x3fc407aa),
         UINT32_C(0x3f8c03c9),
         UINT32_C(0x3fc4324a),
         UINT32_C(0x3f8c25c9),
         UINT32_C(0x3fc4144a)},
        UINT32_C(0xfff80000),
        {0xab,0x47,0x41,0x3a,0x1f,0x1f,0x5c,0x24,0x61,0x69,
         0x71,0xa7,0x97,0xdd,0xb6,0xe9,0x5e,0x9f,0xf3,0x45,0x00}
    },
    {
        /* No.434 delta:1393 weight:1441 */
        11213,
        18,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd67e23e4),
         UINT32_C(0x16517cf4),
         UINT32_C(0xc02f5f10),
         UINT32_C(0x02f01b25),
         UINT32_C(0xd48e38c1),
         UINT32_C(0x14a167d1),
         UINT32_C(0xc2df4435),
         UINT32_C(0x00000830),
         UINT32_C(0xd67e2bd4),
         UINT32_C(0x165174c4),
         UINT32_C(0xc02f5720),
         UINT32_C(0x02f01315),
         UINT32_C(0xd48e30f1),
         UINT32_C(0x14a16fe1),
         UINT32_C(0xc2df4c05)},
        {UINT32_C(0x00000000),
         UINT32_C(0x205e48da),
         UINT32_C(0x402a61b7),
         UINT32_C(0x6074296d),
         UINT32_C(0x60288538),
         UINT32_C(0x4076cde2),
         UINT32_C(0x2002e48f),
         UINT32_C(0x005cac55),
         UINT32_C(0x404ab18b),
         UINT32_C(0x6014f951),
         UINT32_C(0x0060d03c),
         UINT32_C(0x203e98e6),
         UINT32_C(0x206234b3),
         UINT32_C(0x003c7c69),
         UINT32_C(0x60485504),
         UINT32_C(0x40161dde)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902f24),
         UINT32_C(0x3fa01530),
         UINT32_C(0x3fb03a14),
         UINT32_C(0x3fb01442),
         UINT32_C(0x3fa03b66),
         UINT32_C(0x3f900172),
         UINT32_C(0x3f802e56),
         UINT32_C(0x3fa02558),
         UINT32_C(0x3fb00a7c),
         UINT32_C(0x3f803068),
         UINT32_C(0x3f901f4c),
         UINT32_C(0x3f90311a),
         UINT32_C(0x3f801e3e),
         UINT32_C(0x3fb0242a),
         UINT32_C(0x3fa00b0e)},
        UINT32_C(0xfff80000),
        {0x31,0xc3,0x14,0x4a,0xc5,0xa4,0x7d,0x37,0x3e,0x1b,
         0xe0,0x5a,0x1c,0x8e,0x39,0xf2,0x4a,0x5f,0xe5,0x18,0x00}
    },
    {
        /* No.435 delta:1506 weight:1529 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe8f6d4d6),
         UINT32_C(0x1f9921a7),
         UINT32_C(0xf76ff571),
         UINT32_C(0xafa01b37),
         UINT32_C(0x4756cfe1),
         UINT32_C(0xb0393a90),
         UINT32_C(0x58cfee46),
         UINT32_C(0x0000e946),
         UINT32_C(0xe8f63d90),
         UINT32_C(0x1f99c8e1),
         UINT32_C(0xf76f1c37),
         UINT32_C(0xafa0f271),
         UINT32_C(0x475626a7),
         UINT32_C(0xb039d3d6),
         UINT32_C(0x58cf0700)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2865415a),
         UINT32_C(0x4002c982),
         UINT32_C(0x686788d8),
         UINT32_C(0x3070e1d3),
         UINT32_C(0x1815a089),
         UINT32_C(0x70722851),
         UINT32_C(0x5817690b),
         UINT32_C(0x00687156),
         UINT32_C(0x280d300c),
         UINT32_C(0x406ab8d4),
         UINT32_C(0x680ff98e),
         UINT32_C(0x30189085),
         UINT32_C(0x187dd1df),
         UINT32_C(0x701a5907),
         UINT32_C(0x587f185d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9432a0),
         UINT32_C(0x3fa00164),
         UINT32_C(0x3fb433c4),
         UINT32_C(0x3f983870),
         UINT32_C(0x3f8c0ad0),
         UINT32_C(0x3fb83914),
         UINT32_C(0x3fac0bb4),
         UINT32_C(0x3f803438),
         UINT32_C(0x3f940698),
         UINT32_C(0x3fa0355c),
         UINT32_C(0x3fb407fc),
         UINT32_C(0x3f980c48),
         UINT32_C(0x3f8c3ee8),
         UINT32_C(0x3fb80d2c),
         UINT32_C(0x3fac3f8c)},
        UINT32_C(0xfff80000),
        {0x30,0xa9,0xe2,0x5b,0xe5,0xa1,0x47,0xfd,0x4b,0x6c,
         0x8a,0x14,0x23,0xe0,0x8f,0xef,0xcb,0xe8,0x90,0x2f,0x00}
    },
    {
        /* No.436 delta:1226 weight:1523 */
        11213,
        24,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x557fb620),
         UINT32_C(0x6c5a80b0),
         UINT32_C(0x39253690),
         UINT32_C(0x42801b40),
         UINT32_C(0x17ffad60),
         UINT32_C(0x2eda9bf0),
         UINT32_C(0x7ba52dd0),
         UINT32_C(0x00005ec4),
         UINT32_C(0x557fe8e4),
         UINT32_C(0x6c5ade74),
         UINT32_C(0x39256854),
         UINT32_C(0x42804584),
         UINT32_C(0x17fff3a4),
         UINT32_C(0x2edac534),
         UINT32_C(0x7ba57314)},
        {UINT32_C(0x00000000),
         UINT32_C(0x006da17b),
         UINT32_C(0x400a6152),
         UINT32_C(0x4067c029),
         UINT32_C(0x0402009c),
         UINT32_C(0x046fa1e7),
         UINT32_C(0x440861ce),
         UINT32_C(0x4465c0b5),
         UINT32_C(0xd0106016),
         UINT32_C(0xd07dc16d),
         UINT32_C(0x901a0144),
         UINT32_C(0x9077a03f),
         UINT32_C(0xd412608a),
         UINT32_C(0xd47fc1f1),
         UINT32_C(0x941801d8),
         UINT32_C(0x9475a0a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8036d0),
         UINT32_C(0x3fa00530),
         UINT32_C(0x3fa033e0),
         UINT32_C(0x3f820100),
         UINT32_C(0x3f8237d0),
         UINT32_C(0x3fa20430),
         UINT32_C(0x3fa232e0),
         UINT32_C(0x3fe80830),
         UINT32_C(0x3fe83ee0),
         UINT32_C(0x3fc80d00),
         UINT32_C(0x3fc83bd0),
         UINT32_C(0x3fea0930),
         UINT32_C(0x3fea3fe0),
         UINT32_C(0x3fca0c00),
         UINT32_C(0x3fca3ad0)},
        UINT32_C(0xfff80000),
        {0x08,0x12,0xb6,0xd0,0x24,0x49,0xa5,0x85,0x4b,0xb2,
         0xf1,0x9b,0x2c,0x64,0xbf,0xb1,0x6f,0xd1,0xeb,0xda,0x00}
    },
    {
        /* No.437 delta:650 weight:1717 */
        11213,
        68,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x36d515bc),
         UINT32_C(0x557945ab),
         UINT32_C(0x63ac5017),
         UINT32_C(0xb4701b5b),
         UINT32_C(0x82a50ee7),
         UINT32_C(0xe1095ef0),
         UINT32_C(0xd7dc4b4c),
         UINT32_C(0x0000845f),
         UINT32_C(0x36d591e3),
         UINT32_C(0x5579c1f4),
         UINT32_C(0x63acd448),
         UINT32_C(0xb4709f04),
         UINT32_C(0x82a58ab8),
         UINT32_C(0xe109daaf),
         UINT32_C(0xd7dccf13)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2002b91b),
         UINT32_C(0x80006411),
         UINT32_C(0xa002dd0a),
         UINT32_C(0x400011d6),
         UINT32_C(0x6002a8cd),
         UINT32_C(0xc00075c7),
         UINT32_C(0xe002ccdc),
         UINT32_C(0x20011812),
         UINT32_C(0x0003a109),
         UINT32_C(0xa0017c03),
         UINT32_C(0x8003c518),
         UINT32_C(0x600109c4),
         UINT32_C(0x4003b0df),
         UINT32_C(0xe0016dd5),
         UINT32_C(0xc003d4ce)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90015c),
         UINT32_C(0x3fc00032),
         UINT32_C(0x3fd0016e),
         UINT32_C(0x3fa00008),
         UINT32_C(0x3fb00154),
         UINT32_C(0x3fe0003a),
         UINT32_C(0x3ff00166),
         UINT32_C(0x3f90008c),
         UINT32_C(0x3f8001d0),
         UINT32_C(0x3fd000be),
         UINT32_C(0x3fc001e2),
         UINT32_C(0x3fb00084),
         UINT32_C(0x3fa001d8),
         UINT32_C(0x3ff000b6),
         UINT32_C(0x3fe001ea)},
        UINT32_C(0xfff80000),
        {0x1e,0x01,0x6d,0x92,0x46,0x9d,0x77,0x5f,0x99,0x39,
         0x34,0x1e,0x83,0xd4,0x50,0x06,0xba,0xf4,0x06,0xc5,0x00}
    },
    {
        /* No.438 delta:768 weight:1315 */
        11213,
        58,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc4e1fbbb),
         UINT32_C(0x1f16f6c1),
         UINT32_C(0xdbf70d7a),
         UINT32_C(0xce201b6c),
         UINT32_C(0x0ac1e0d7),
         UINT32_C(0xd136edad),
         UINT32_C(0x15d71616),
         UINT32_C(0x00007f3f),
         UINT32_C(0xc4e18484),
         UINT32_C(0x1f1689fe),
         UINT32_C(0xdbf77245),
         UINT32_C(0xce206453),
         UINT32_C(0x0ac19fe8),
         UINT32_C(0xd1369292),
         UINT32_C(0x15d76929)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40041072),
         UINT32_C(0x2029710b),
         UINT32_C(0x602d6179),
         UINT32_C(0x280400ed),
         UINT32_C(0x6800109f),
         UINT32_C(0x082d71e6),
         UINT32_C(0x48296194),
         UINT32_C(0x000081f0),
         UINT32_C(0x40049182),
         UINT32_C(0x2029f0fb),
         UINT32_C(0x602de089),
         UINT32_C(0x2804811d),
         UINT32_C(0x6800916f),
         UINT32_C(0x082df016),
         UINT32_C(0x4829e064)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00208),
         UINT32_C(0x3f9014b8),
         UINT32_C(0x3fb016b0),
         UINT32_C(0x3f940200),
         UINT32_C(0x3fb40008),
         UINT32_C(0x3f8416b8),
         UINT32_C(0x3fa414b0),
         UINT32_C(0x3f800040),
         UINT32_C(0x3fa00248),
         UINT32_C(0x3f9014f8),
         UINT32_C(0x3fb016f0),
         UINT32_C(0x3f940240),
         UINT32_C(0x3fb40048),
         UINT32_C(0x3f8416f8),
         UINT32_C(0x3fa414f0)},
        UINT32_C(0xfff80000),
        {0xb5,0x2e,0xf9,0xc4,0x1f,0x96,0x80,0x45,0xea,0x23,
         0x83,0x02,0x10,0x9c,0x4e,0x87,0xf1,0x13,0xd8,0xc5,0x00}
    },
    {
        /* No.439 delta:1209 weight:1595 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd0453d45),
         UINT32_C(0xa2f377d4),
         UINT32_C(0x72b64a91),
         UINT32_C(0x4ed01b75),
         UINT32_C(0x9e952630),
         UINT32_C(0xec236ca1),
         UINT32_C(0x3c6651e4),
         UINT32_C(0x00006db6),
         UINT32_C(0xd04550f3),
         UINT32_C(0xa2f31a62),
         UINT32_C(0x72b62727),
         UINT32_C(0x4ed076c3),
         UINT32_C(0x9e954b86),
         UINT32_C(0xec230117),
         UINT32_C(0x3c663c52)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc00de97a),
         UINT32_C(0x020145e3),
         UINT32_C(0xc20cac99),
         UINT32_C(0x405ce122),
         UINT32_C(0x80510858),
         UINT32_C(0x425da4c1),
         UINT32_C(0x82504dbb),
         UINT32_C(0x00609dfe),
         UINT32_C(0xc06d7484),
         UINT32_C(0x0261d81d),
         UINT32_C(0xc26c3167),
         UINT32_C(0x403c7cdc),
         UINT32_C(0x803195a6),
         UINT32_C(0x423d393f),
         UINT32_C(0x8230d045)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe006f4),
         UINT32_C(0x3f8100a2),
         UINT32_C(0x3fe10656),
         UINT32_C(0x3fa02e70),
         UINT32_C(0x3fc02884),
         UINT32_C(0x3fa12ed2),
         UINT32_C(0x3fc12826),
         UINT32_C(0x3f80304e),
         UINT32_C(0x3fe036ba),
         UINT32_C(0x3f8130ec),
         UINT32_C(0x3fe13618),
         UINT32_C(0x3fa01e3e),
         UINT32_C(0x3fc018ca),
         UINT32_C(0x3fa11e9c),
         UINT32_C(0x3fc11868)},
        UINT32_C(0xfff80000),
        {0x16,0xcc,0xdf,0x96,0x0d,0x0c,0x8d,0x9d,0x4c,0xe0,
         0xb7,0x30,0xd3,0xe2,0xba,0xde,0x4f,0xd2,0x13,0xb1,0x00}
    },
    {
        /* No.440 delta:661 weight:1719 */
        11213,
        93,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xecde6bb9),
         UINT32_C(0x18155470),
         UINT32_C(0xf4cb3fc9),
         UINT32_C(0x03e01b89),
         UINT32_C(0xef3e7030),
         UINT32_C(0x1bf54ff9),
         UINT32_C(0xf72b2440),
         UINT32_C(0x0000d089),
         UINT32_C(0xecdebb30),
         UINT32_C(0x181584f9),
         UINT32_C(0xf4cbef40),
         UINT32_C(0x03e0cb00),
         UINT32_C(0xef3ea0b9),
         UINT32_C(0x1bf59f70),
         UINT32_C(0xf72bf4c9)},
        {UINT32_C(0x00000000),
         UINT32_C(0xb0078c1a),
         UINT32_C(0x2022e34f),
         UINT32_C(0x90256f55),
         UINT32_C(0x00020012),
         UINT32_C(0xb0058c08),
         UINT32_C(0x2020e35d),
         UINT32_C(0x90276f47),
         UINT32_C(0x10601010),
         UINT32_C(0xa0679c0a),
         UINT32_C(0x3042f35f),
         UINT32_C(0x80457f45),
         UINT32_C(0x10621002),
         UINT32_C(0xa0659c18),
         UINT32_C(0x3040f34d),
         UINT32_C(0x80477f57)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd803c6),
         UINT32_C(0x3f901171),
         UINT32_C(0x3fc812b7),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fd802c6),
         UINT32_C(0x3f901071),
         UINT32_C(0x3fc813b7),
         UINT32_C(0x3f883008),
         UINT32_C(0x3fd033ce),
         UINT32_C(0x3f982179),
         UINT32_C(0x3fc022bf),
         UINT32_C(0x3f883108),
         UINT32_C(0x3fd032ce),
         UINT32_C(0x3f982079),
         UINT32_C(0x3fc023bf)},
        UINT32_C(0xfff80000),
        {0x02,0x84,0xb3,0x29,0xd9,0x66,0x77,0xde,0xd3,0xde,
         0x2c,0x98,0xba,0x8d,0xd0,0x9f,0xa3,0xa5,0xa6,0x62,0x00}
    },
    {
        /* No.441 delta:896 weight:1197 */
        11213,
        44,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x74b73a0a),
         UINT32_C(0x02330f4f),
         UINT32_C(0x76843545),
         UINT32_C(0x6ff01b95),
         UINT32_C(0x1b47219f),
         UINT32_C(0x6dc314da),
         UINT32_C(0x19742ed0),
         UINT32_C(0x000064da),
         UINT32_C(0x74b75ed0),
         UINT32_C(0x02336b95),
         UINT32_C(0x7684519f),
         UINT32_C(0x6ff07f4f),
         UINT32_C(0x1b474545),
         UINT32_C(0x6dc37000),
         UINT32_C(0x19744a0a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x100f7056),
         UINT32_C(0x40229c0d),
         UINT32_C(0x502dec5b),
         UINT32_C(0x106a00f9),
         UINT32_C(0x006570af),
         UINT32_C(0x50489cf4),
         UINT32_C(0x4047eca2),
         UINT32_C(0x000283c1),
         UINT32_C(0x100df397),
         UINT32_C(0x40201fcc),
         UINT32_C(0x502f6f9a),
         UINT32_C(0x10688338),
         UINT32_C(0x0067f36e),
         UINT32_C(0x504a1f35),
         UINT32_C(0x40456f63)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8807b8),
         UINT32_C(0x3fa0114e),
         UINT32_C(0x3fa816f6),
         UINT32_C(0x3f883500),
         UINT32_C(0x3f8032b8),
         UINT32_C(0x3fa8244e),
         UINT32_C(0x3fa023f6),
         UINT32_C(0x3f800141),
         UINT32_C(0x3f8806f9),
         UINT32_C(0x3fa0100f),
         UINT32_C(0x3fa817b7),
         UINT32_C(0x3f883441),
         UINT32_C(0x3f8033f9),
         UINT32_C(0x3fa8250f),
         UINT32_C(0x3fa022b7)},
        UINT32_C(0xfff80000),
        {0x8f,0x1e,0x77,0x99,0xde,0x44,0x8e,0x66,0xcc,0x6e,
         0x8e,0xfa,0xe2,0xdf,0x89,0x94,0x86,0xbd,0x7f,0xfb,0x00}
    },
    {
        /* No.442 delta:1044 weight:1603 */
        11213,
        31,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf2acd20d),
         UINT32_C(0x2e78f6ac),
         UINT32_C(0xdcd424a1),
         UINT32_C(0x11c01ba2),
         UINT32_C(0xe36cc9af),
         UINT32_C(0x3fb8ed0e),
         UINT32_C(0xcd143f03),
         UINT32_C(0x00003333),
         UINT32_C(0xf2ace13e),
         UINT32_C(0x2e78c59f),
         UINT32_C(0xdcd41792),
         UINT32_C(0x11c02891),
         UINT32_C(0xe36cfa9c),
         UINT32_C(0x3fb8de3d),
         UINT32_C(0xcd140c30)},
        {UINT32_C(0x00000000),
         UINT32_C(0x600423fa),
         UINT32_C(0x300230fc),
         UINT32_C(0x50061306),
         UINT32_C(0x3001c0a3),
         UINT32_C(0x5005e359),
         UINT32_C(0x0003f05f),
         UINT32_C(0x6007d3a5),
         UINT32_C(0x1403b116),
         UINT32_C(0x740792ec),
         UINT32_C(0x240181ea),
         UINT32_C(0x4405a210),
         UINT32_C(0x240271b5),
         UINT32_C(0x4406524f),
         UINT32_C(0x14004149),
         UINT32_C(0x740462b3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb00211),
         UINT32_C(0x3f980118),
         UINT32_C(0x3fa80309),
         UINT32_C(0x3f9800e0),
         UINT32_C(0x3fa802f1),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3fb003e9),
         UINT32_C(0x3f8a01d8),
         UINT32_C(0x3fba03c9),
         UINT32_C(0x3f9200c0),
         UINT32_C(0x3fa202d1),
         UINT32_C(0x3f920138),
         UINT32_C(0x3fa20329),
         UINT32_C(0x3f8a0020),
         UINT32_C(0x3fba0231)},
        UINT32_C(0xfff80000),
        {0x61,0x3f,0x9c,0x01,0xef,0xb0,0xd2,0x20,0x2e,0x27,
         0xf6,0xbd,0x73,0xbc,0x66,0x3a,0x0b,0xac,0x78,0xe5,0x00}
    },
    {
        /* No.443 delta:1046 weight:1629 */
        11213,
        41,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x142cd4e2),
         UINT32_C(0x5c38fde5),
         UINT32_C(0x48142907),
         UINT32_C(0x7a401bb1),
         UINT32_C(0x6e6ccf53),
         UINT32_C(0x2678e654),
         UINT32_C(0x325432b6),
         UINT32_C(0x0000fb50),
         UINT32_C(0x142c2fb2),
         UINT32_C(0x5c3806b5),
         UINT32_C(0x4814d257),
         UINT32_C(0x7a40e0e1),
         UINT32_C(0x6e6c3403),
         UINT32_C(0x26781d04),
         UINT32_C(0x3254c9e6)},
        {UINT32_C(0x00000000),
         UINT32_C(0x004de1de),
         UINT32_C(0x800ec185),
         UINT32_C(0x8043205b),
         UINT32_C(0x000200b4),
         UINT32_C(0x004fe16a),
         UINT32_C(0x800cc131),
         UINT32_C(0x804120ef),
         UINT32_C(0x240c001d),
         UINT32_C(0x2441e1c3),
         UINT32_C(0xa402c198),
         UINT32_C(0xa44f2046),
         UINT32_C(0x240e00a9),
         UINT32_C(0x2443e177),
         UINT32_C(0xa400c12c),
         UINT32_C(0xa44d20f2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8026f0),
         UINT32_C(0x3fc00760),
         UINT32_C(0x3fc02190),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f8027f0),
         UINT32_C(0x3fc00660),
         UINT32_C(0x3fc02090),
         UINT32_C(0x3f920600),
         UINT32_C(0x3f9220f0),
         UINT32_C(0x3fd20160),
         UINT32_C(0x3fd22790),
         UINT32_C(0x3f920700),
         UINT32_C(0x3f9221f0),
         UINT32_C(0x3fd20060),
         UINT32_C(0x3fd22690)},
        UINT32_C(0xfff80000),
        {0x65,0x13,0x59,0x24,0xc4,0xfb,0xe5,0xe6,0xe1,0x9a,
         0x95,0x21,0xdb,0x47,0x93,0x4d,0xd3,0xb3,0x91,0xcc,0x00}
    },
    {
        /* No.444 delta:669 weight:1447 */
        11213,
        81,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x053e5913),
         UINT32_C(0xae3d13ce),
         UINT32_C(0xab034add),
         UINT32_C(0x5ae01bc7),
         UINT32_C(0x5fde42d4),
         UINT32_C(0xf4dd0809),
         UINT32_C(0xf1e3511a),
         UINT32_C(0x0000b142),
         UINT32_C(0x053ee851),
         UINT32_C(0xae3da28c),
         UINT32_C(0xab03fb9f),
         UINT32_C(0x5ae0aa85),
         UINT32_C(0x5fdef396),
         UINT32_C(0xf4ddb94b),
         UINT32_C(0xf1e3e058)},
        {UINT32_C(0x00000000),
         UINT32_C(0x3001c83d),
         UINT32_C(0x20032cc9),
         UINT32_C(0x1002e4f4),
         UINT32_C(0x0002349a),
         UINT32_C(0x3003fca7),
         UINT32_C(0x20011853),
         UINT32_C(0x1000d06e),
         UINT32_C(0x6000001c),
         UINT32_C(0x5001c821),
         UINT32_C(0x40032cd5),
         UINT32_C(0x7002e4e8),
         UINT32_C(0x60023486),
         UINT32_C(0x5003fcbb),
         UINT32_C(0x4001184f),
         UINT32_C(0x7000d072)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9800e4),
         UINT32_C(0x3f900196),
         UINT32_C(0x3f880172),
         UINT32_C(0x3f80011a),
         UINT32_C(0x3f9801fe),
         UINT32_C(0x3f90008c),
         UINT32_C(0x3f880068),
         UINT32_C(0x3fb00000),
         UINT32_C(0x3fa800e4),
         UINT32_C(0x3fa00196),
         UINT32_C(0x3fb80172),
         UINT32_C(0x3fb0011a),
         UINT32_C(0x3fa801fe),
         UINT32_C(0x3fa0008c),
         UINT32_C(0x3fb80068)},
        UINT32_C(0xfff80000),
        {0x2b,0x33,0x3a,0xe8,0xf0,0x8a,0xb9,0xc8,0x97,0xec,
         0xc2,0xca,0x81,0x45,0x89,0x05,0xd4,0x8b,0x2e,0xa9,0x00}
    },
    {
        /* No.445 delta:1946 weight:1335 */
        11213,
        10,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1c4b156c),
         UINT32_C(0x39a6b0f0),
         UINT32_C(0x25eda59c),
         UINT32_C(0x91b01bd0),
         UINT32_C(0x8dfb0ebc),
         UINT32_C(0xa816ab20),
         UINT32_C(0xb45dbe4c),
         UINT32_C(0x00004b50),
         UINT32_C(0x1c4b5e3c),
         UINT32_C(0x39a6fba0),
         UINT32_C(0x25edeecc),
         UINT32_C(0x91b05080),
         UINT32_C(0x8dfb45ec),
         UINT32_C(0xa816e070),
         UINT32_C(0xb45df51c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0a958997),
         UINT32_C(0x0f02a212),
         UINT32_C(0x05972b85),
         UINT32_C(0x00801026),
         UINT32_C(0x0a1599b1),
         UINT32_C(0x0f82b234),
         UINT32_C(0x05173ba3),
         UINT32_C(0x44180c15),
         UINT32_C(0x4e8d8582),
         UINT32_C(0x4b1aae07),
         UINT32_C(0x418f2790),
         UINT32_C(0x44981c33),
         UINT32_C(0x4e0d95a4),
         UINT32_C(0x4b9abe21),
         UINT32_C(0x410f37b6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f854ac4),
         UINT32_C(0x3f878151),
         UINT32_C(0x3f82cb95),
         UINT32_C(0x3f804008),
         UINT32_C(0x3f850acc),
         UINT32_C(0x3f87c159),
         UINT32_C(0x3f828b9d),
         UINT32_C(0x3fa20c06),
         UINT32_C(0x3fa746c2),
         UINT32_C(0x3fa58d57),
         UINT32_C(0x3fa0c793),
         UINT32_C(0x3fa24c0e),
         UINT32_C(0x3fa706ca),
         UINT32_C(0x3fa5cd5f),
         UINT32_C(0x3fa0879b)},
        UINT32_C(0xfff80000),
        {0x16,0x8a,0x65,0x8e,0x09,0x67,0xbe,0x3b,0xba,0x27,
         0xec,0xf7,0xa1,0x87,0x82,0x1b,0x4e,0xea,0x8d,0x1f,0x00}
    },
    {
        /* No.446 delta:2283 weight:1213 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x196d7152),
         UINT32_C(0x70b7638d),
         UINT32_C(0x69da12df),
         UINT32_C(0x0f501be1),
         UINT32_C(0x163d6ab3),
         UINT32_C(0x7fe7786c),
         UINT32_C(0x668a093e),
         UINT32_C(0x00005fc3),
         UINT32_C(0x196d2e91),
         UINT32_C(0x70b73c4e),
         UINT32_C(0x69da4d1c),
         UINT32_C(0x0f504422),
         UINT32_C(0x163d3570),
         UINT32_C(0x7fe727af),
         UINT32_C(0x668a56fd)},
        {UINT32_C(0x00000000),
         UINT32_C(0x241580d6),
         UINT32_C(0x22100542),
         UINT32_C(0x06058594),
         UINT32_C(0x19c021dc),
         UINT32_C(0x3dd5a10a),
         UINT32_C(0x3bd0249e),
         UINT32_C(0x1fc5a448),
         UINT32_C(0x0c160027),
         UINT32_C(0x280380f1),
         UINT32_C(0x2e060565),
         UINT32_C(0x0a1385b3),
         UINT32_C(0x15d621fb),
         UINT32_C(0x31c3a12d),
         UINT32_C(0x37c624b9),
         UINT32_C(0x13d3a46f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f920ac0),
         UINT32_C(0x3f910802),
         UINT32_C(0x3f8302c2),
         UINT32_C(0x3f8ce010),
         UINT32_C(0x3f9eead0),
         UINT32_C(0x3f9de812),
         UINT32_C(0x3f8fe2d2),
         UINT32_C(0x3f860b00),
         UINT32_C(0x3f9401c0),
         UINT32_C(0x3f970302),
         UINT32_C(0x3f8509c2),
         UINT32_C(0x3f8aeb10),
         UINT32_C(0x3f98e1d0),
         UINT32_C(0x3f9be312),
         UINT32_C(0x3f89e9d2)},
        UINT32_C(0xfff80000),
        {0xe0,0x34,0x97,0x6e,0x7b,0xab,0x93,0x95,0xb6,0x3c,
         0x37,0x45,0x72,0xbf,0xbd,0x20,0xa9,0x0e,0x06,0x5b,0x00}
    },
    {
        /* No.447 delta:940 weight:1651 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x378ab458),
         UINT32_C(0x999d98e1),
         UINT32_C(0xae172cb9),
         UINT32_C(0x17b01bfc),
         UINT32_C(0x203aafa4),
         UINT32_C(0x8e2d831d),
         UINT32_C(0xb9a73745),
         UINT32_C(0x000086af),
         UINT32_C(0x378a32f7),
         UINT32_C(0x999d1e4e),
         UINT32_C(0xae17aa16),
         UINT32_C(0x17b09d53),
         UINT32_C(0x203a290b),
         UINT32_C(0x8e2d05b2),
         UINT32_C(0xb9a7b1ea)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80009816),
         UINT32_C(0x400c0eac),
         UINT32_C(0xc00c96ba),
         UINT32_C(0x00139604),
         UINT32_C(0x80130e12),
         UINT32_C(0x401f98a8),
         UINT32_C(0xc01f00be),
         UINT32_C(0x00031418),
         UINT32_C(0x80038c0e),
         UINT32_C(0x400f1ab4),
         UINT32_C(0xc00f82a2),
         UINT32_C(0x0010821c),
         UINT32_C(0x80101a0a),
         UINT32_C(0x401c8cb0),
         UINT32_C(0xc01c14a6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc0004c),
         UINT32_C(0x3fa00607),
         UINT32_C(0x3fe0064b),
         UINT32_C(0x3f8009cb),
         UINT32_C(0x3fc00987),
         UINT32_C(0x3fa00fcc),
         UINT32_C(0x3fe00f80),
         UINT32_C(0x3f80018a),
         UINT32_C(0x3fc001c6),
         UINT32_C(0x3fa0078d),
         UINT32_C(0x3fe007c1),
         UINT32_C(0x3f800841),
         UINT32_C(0x3fc0080d),
         UINT32_C(0x3fa00e46),
         UINT32_C(0x3fe00e0a)},
        UINT32_C(0xfff80000),
        {0xe7,0x7e,0x5f,0x3f,0x63,0x46,0xb4,0x5e,0x55,0xe4,
         0xbe,0x63,0x84,0x07,0x66,0x97,0x54,0x8d,0x57,0xc8,0x00}
    },
    {
        /* No.448 delta:773 weight:1505 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x887f6254),
         UINT32_C(0x5c60053c),
         UINT32_C(0xd41f6768),
         UINT32_C(0x5c701c0b),
         UINT32_C(0xd40f7e5f),
         UINT32_C(0x00101937),
         UINT32_C(0x886f7b63),
         UINT32_C(0x000077da),
         UINT32_C(0x887f158e),
         UINT32_C(0x5c6072e6),
         UINT32_C(0xd41f10b2),
         UINT32_C(0x5c706bd1),
         UINT32_C(0xd40f0985),
         UINT32_C(0x00106eed),
         UINT32_C(0x886f0cb9)},
        {UINT32_C(0x00000000),
         UINT32_C(0xc102113a),
         UINT32_C(0x2081016d),
         UINT32_C(0xe1831057),
         UINT32_C(0xa00031de),
         UINT32_C(0x610220e4),
         UINT32_C(0x808130b3),
         UINT32_C(0x41832189),
         UINT32_C(0x4000601d),
         UINT32_C(0x81027127),
         UINT32_C(0x60816170),
         UINT32_C(0xa183704a),
         UINT32_C(0xe00051c3),
         UINT32_C(0x210240f9),
         UINT32_C(0xc08150ae),
         UINT32_C(0x01834194)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fe08108),
         UINT32_C(0x3f904080),
         UINT32_C(0x3ff0c188),
         UINT32_C(0x3fd00018),
         UINT32_C(0x3fb08110),
         UINT32_C(0x3fc04098),
         UINT32_C(0x3fa0c190),
         UINT32_C(0x3fa00030),
         UINT32_C(0x3fc08138),
         UINT32_C(0x3fb040b0),
         UINT32_C(0x3fd0c1b8),
         UINT32_C(0x3ff00028),
         UINT32_C(0x3f908120),
         UINT32_C(0x3fe040a8),
         UINT32_C(0x3f80c1a0)},
        UINT32_C(0xfff80000),
        {0x52,0x3b,0xa8,0xb8,0xa4,0x44,0xdb,0x43,0xd2,0xa1,
         0xd3,0xd4,0x80,0x7e,0x9e,0xeb,0x10,0x02,0xa7,0x3d,0x00}
    },
    {
        /* No.449 delta:1695 weight:1347 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5e96a7dd),
         UINT32_C(0xd58d224d),
         UINT32_C(0x8b1b8590),
         UINT32_C(0xd4801c15),
         UINT32_C(0x8a16bbc8),
         UINT32_C(0x010d3e58),
         UINT32_C(0x5f9b9985),
         UINT32_C(0x000052a0),
         UINT32_C(0x5e96f57d),
         UINT32_C(0xd58d70ed),
         UINT32_C(0x8b1bd730),
         UINT32_C(0xd4804eb5),
         UINT32_C(0x8a16e968),
         UINT32_C(0x010d6cf8),
         UINT32_C(0x5f9bcb25)},
        {UINT32_C(0x00000000),
         UINT32_C(0x8045a132),
         UINT32_C(0x004e104c),
         UINT32_C(0x800bb17e),
         UINT32_C(0x530821a9),
         UINT32_C(0xd34d809b),
         UINT32_C(0x534631e5),
         UINT32_C(0xd30390d7),
         UINT32_C(0x0d207078),
         UINT32_C(0x8d65d14a),
         UINT32_C(0x0d6e6034),
         UINT32_C(0x8d2bc106),
         UINT32_C(0x5e2851d1),
         UINT32_C(0xde6df0e3),
         UINT32_C(0x5e66419d),
         UINT32_C(0xde23e0af)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc022d0),
         UINT32_C(0x3f802708),
         UINT32_C(0x3fc005d8),
         UINT32_C(0x3fa98410),
         UINT32_C(0x3fe9a6c0),
         UINT32_C(0x3fa9a318),
         UINT32_C(0x3fe981c8),
         UINT32_C(0x3f869038),
         UINT32_C(0x3fc6b2e8),
         UINT32_C(0x3f86b730),
         UINT32_C(0x3fc695e0),
         UINT32_C(0x3faf1428),
         UINT32_C(0x3fef36f8),
         UINT32_C(0x3faf3320),
         UINT32_C(0x3fef11f0)},
        UINT32_C(0xfff80000),
        {0xc3,0xbf,0x9f,0xb6,0xc5,0x31,0x9b,0x86,0x9a,0x6d,
         0x96,0x67,0x5b,0xec,0x24,0xb7,0x3e,0xd3,0xe0,0x07,0x00}
    },
    {
        /* No.450 delta:1302 weight:1591 */
        11213,
        21,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x91534dd5),
         UINT32_C(0x8670ccfb),
         UINT32_C(0x1723812e),
         UINT32_C(0xdab01c26),
         UINT32_C(0x4be351f3),
         UINT32_C(0x5cc0d0dd),
         UINT32_C(0xcd939d08),
         UINT32_C(0x0000308b),
         UINT32_C(0x91537d5e),
         UINT32_C(0x8670fc70),
         UINT32_C(0x1723b1a5),
         UINT32_C(0xdab02cad),
         UINT32_C(0x4be36178),
         UINT32_C(0x5cc0e056),
         UINT32_C(0xcd93ad83)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0065417c),
         UINT32_C(0x240e846e),
         UINT32_C(0x246bc512),
         UINT32_C(0x00222089),
         UINT32_C(0x004761f5),
         UINT32_C(0x242ca4e7),
         UINT32_C(0x2449e59b),
         UINT32_C(0x2010003d),
         UINT32_C(0x20754141),
         UINT32_C(0x041e8453),
         UINT32_C(0x047bc52f),
         UINT32_C(0x203220b4),
         UINT32_C(0x205761c8),
         UINT32_C(0x043ca4da),
         UINT32_C(0x0459e5a6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8032a0),
         UINT32_C(0x3f920742),
         UINT32_C(0x3f9235e2),
         UINT32_C(0x3f801110),
         UINT32_C(0x3f8023b0),
         UINT32_C(0x3f921652),
         UINT32_C(0x3f9224f2),
         UINT32_C(0x3f900800),
         UINT32_C(0x3f903aa0),
         UINT32_C(0x3f820f42),
         UINT32_C(0x3f823de2),
         UINT32_C(0x3f901910),
         UINT32_C(0x3f902bb0),
         UINT32_C(0x3f821e52),
         UINT32_C(0x3f822cf2)},
        UINT32_C(0xfff80000),
        {0x67,0x48,0x0f,0xce,0x04,0x1c,0x7a,0x4a,0xb8,0xdb,
         0xa3,0x1f,0x34,0x33,0xac,0x96,0x18,0x13,0xb5,0x20,0x00}
    },
    {
        /* No.451 delta:774 weight:1351 */
        11213,
        90,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8dfdec88),
         UINT32_C(0x42759c86),
         UINT32_C(0xcf88700e),
         UINT32_C(0xd7801c3e),
         UINT32_C(0x5a7df0b6),
         UINT32_C(0x95f580b8),
         UINT32_C(0x18086c30),
         UINT32_C(0x0000426d),
         UINT32_C(0x8dfdaee5),
         UINT32_C(0x4275deeb),
         UINT32_C(0xcf883263),
         UINT32_C(0xd7805e53),
         UINT32_C(0x5a7db2db),
         UINT32_C(0x95f5c2d5),
         UINT32_C(0x18082e5d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0f951152),
         UINT32_C(0x004a4883),
         UINT32_C(0x0fdf59d1),
         UINT32_C(0x00321c17),
         UINT32_C(0x0fa70d45),
         UINT32_C(0x00785494),
         UINT32_C(0x0fed45c6),
         UINT32_C(0x5618001a),
         UINT32_C(0x598d1148),
         UINT32_C(0x56524899),
         UINT32_C(0x59c759cb),
         UINT32_C(0x562a1c0d),
         UINT32_C(0x59bf0d5f),
         UINT32_C(0x5660548e),
         UINT32_C(0x59f545dc)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f87ca88),
         UINT32_C(0x3f802524),
         UINT32_C(0x3f87efac),
         UINT32_C(0x3f80190e),
         UINT32_C(0x3f87d386),
         UINT32_C(0x3f803c2a),
         UINT32_C(0x3f87f6a2),
         UINT32_C(0x3fab0c00),
         UINT32_C(0x3facc688),
         UINT32_C(0x3fab2924),
         UINT32_C(0x3face3ac),
         UINT32_C(0x3fab150e),
         UINT32_C(0x3facdf86),
         UINT32_C(0x3fab302a),
         UINT32_C(0x3facfaa2)},
        UINT32_C(0xfff80000),
        {0xad,0x39,0x35,0x49,0x70,0xc4,0xa9,0x33,0x85,0xa8,
         0x0b,0x37,0x54,0x33,0xbb,0x71,0x02,0xa4,0x96,0xea,0x00}
    },
    {
        /* No.452 delta:726 weight:1365 */
        11213,
        64,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9be3fbc9),
         UINT32_C(0x04688a47),
         UINT32_C(0x9f8b718e),
         UINT32_C(0x47d01c47),
         UINT32_C(0xdc33e78e),
         UINT32_C(0x43b89600),
         UINT32_C(0xd85b6dc9),
         UINT32_C(0x00008529),
         UINT32_C(0x9be37ee0),
         UINT32_C(0x04680f6e),
         UINT32_C(0x9f8bf4a7),
         UINT32_C(0x47d0996e),
         UINT32_C(0xdc3362a7),
         UINT32_C(0x43b81329),
         UINT32_C(0xd85be8e0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6101697a),
         UINT32_C(0x24001fbe),
         UINT32_C(0x450176c4),
         UINT32_C(0x0002101d),
         UINT32_C(0x61037967),
         UINT32_C(0x24020fa3),
         UINT32_C(0x450366d9),
         UINT32_C(0x3005cccf),
         UINT32_C(0x5104a5b5),
         UINT32_C(0x1405d371),
         UINT32_C(0x7504ba0b),
         UINT32_C(0x3007dcd2),
         UINT32_C(0x5106b5a8),
         UINT32_C(0x1407c36c),
         UINT32_C(0x7506aa16)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb080b4),
         UINT32_C(0x3f92000f),
         UINT32_C(0x3fa280bb),
         UINT32_C(0x3f800108),
         UINT32_C(0x3fb081bc),
         UINT32_C(0x3f920107),
         UINT32_C(0x3fa281b3),
         UINT32_C(0x3f9802e6),
         UINT32_C(0x3fa88252),
         UINT32_C(0x3f8a02e9),
         UINT32_C(0x3fba825d),
         UINT32_C(0x3f9803ee),
         UINT32_C(0x3fa8835a),
         UINT32_C(0x3f8a03e1),
         UINT32_C(0x3fba8355)},
        UINT32_C(0xfff80000),
        {0xd1,0xa0,0x4f,0x52,0xcc,0x74,0xcd,0x0d,0xf0,0x50,
         0xda,0x06,0xe6,0x16,0xb3,0x08,0x75,0x4e,0xa7,0xe1,0x00}
    },
    {
        /* No.453 delta:977 weight:1675 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3202f4e6),
         UINT32_C(0xbba89e7a),
         UINT32_C(0x89aa6a9c),
         UINT32_C(0x26a01c5e),
         UINT32_C(0x14a2e8b8),
         UINT32_C(0x9d088224),
         UINT32_C(0xaf0a76c2),
         UINT32_C(0x0000ce49),
         UINT32_C(0x32023aaf),
         UINT32_C(0xbba85033),
         UINT32_C(0x89aaa4d5),
         UINT32_C(0x26a0d217),
         UINT32_C(0x14a226f1),
         UINT32_C(0x9d084c6d),
         UINT32_C(0xaf0ab88b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x6872097f),
         UINT32_C(0x000320e5),
         UINT32_C(0x6871299a),
         UINT32_C(0x00710056),
         UINT32_C(0x68030929),
         UINT32_C(0x007220b3),
         UINT32_C(0x680029cc),
         UINT32_C(0xa001881b),
         UINT32_C(0xc8738164),
         UINT32_C(0xa002a8fe),
         UINT32_C(0xc870a181),
         UINT32_C(0xa070884d),
         UINT32_C(0xc8028132),
         UINT32_C(0xa073a8a8),
         UINT32_C(0xc801a1d7)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb43904),
         UINT32_C(0x3f800190),
         UINT32_C(0x3fb43894),
         UINT32_C(0x3f803880),
         UINT32_C(0x3fb40184),
         UINT32_C(0x3f803910),
         UINT32_C(0x3fb40014),
         UINT32_C(0x3fd000c4),
         UINT32_C(0x3fe439c0),
         UINT32_C(0x3fd00154),
         UINT32_C(0x3fe43850),
         UINT32_C(0x3fd03844),
         UINT32_C(0x3fe40140),
         UINT32_C(0x3fd039d4),
         UINT32_C(0x3fe400d0)},
        UINT32_C(0xfff80000),
        {0x9a,0x39,0x76,0xe0,0x00,0xe4,0xad,0x40,0x6d,0xbc,
         0x26,0x84,0xc1,0x11,0x26,0x3e,0x39,0x81,0x75,0x5e,0x00}
    },
    {
        /* No.454 delta:2877 weight:859 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb26c64aa),
         UINT32_C(0x948e3b5e),
         UINT32_C(0x26e25ff4),
         UINT32_C(0x66a01c69),
         UINT32_C(0xd4cc78c3),
         UINT32_C(0xf22e2737),
         UINT32_C(0x4042439d),
         UINT32_C(0x0000d341),
         UINT32_C(0xb26cb7eb),
         UINT32_C(0x948ee81f),
         UINT32_C(0x26e28cb5),
         UINT32_C(0x66a0cf28),
         UINT32_C(0xd4ccab82),
         UINT32_C(0xf22ef476),
         UINT32_C(0x404290dc)},
        {UINT32_C(0x00000000),
         UINT32_C(0xe5365b96),
         UINT32_C(0x0d2c001c),
         UINT32_C(0xe81a5b8a),
         UINT32_C(0x0fd203f1),
         UINT32_C(0xeae45867),
         UINT32_C(0x02fe03ed),
         UINT32_C(0xe7c8587b),
         UINT32_C(0x8004461e),
         UINT32_C(0x65321d88),
         UINT32_C(0x8d284602),
         UINT32_C(0x681e1d94),
         UINT32_C(0x8fd645ef),
         UINT32_C(0x6ae01e79),
         UINT32_C(0x82fa45f3),
         UINT32_C(0x67cc1e65)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff29b2d),
         UINT32_C(0x3f869600),
         UINT32_C(0x3ff40d2d),
         UINT32_C(0x3f87e901),
         UINT32_C(0x3ff5722c),
         UINT32_C(0x3f817f01),
         UINT32_C(0x3ff3e42c),
         UINT32_C(0x3fc00223),
         UINT32_C(0x3fb2990e),
         UINT32_C(0x3fc69423),
         UINT32_C(0x3fb40f0e),
         UINT32_C(0x3fc7eb22),
         UINT32_C(0x3fb5700f),
         UINT32_C(0x3fc17d22),
         UINT32_C(0x3fb3e60f)},
        UINT32_C(0xfff80000),
        {0xc1,0x8a,0x93,0xc3,0x26,0x42,0x3a,0xdc,0x79,0xb1,
         0x2a,0x11,0xd4,0xac,0xc3,0xf9,0xfa,0x71,0x61,0x9a,0x00}
    },
    {
        /* No.455 delta:681 weight:1617 */
        11213,
        74,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe9a7fd5d),
         UINT32_C(0x7e4e5765),
         UINT32_C(0x97e9aa38),
         UINT32_C(0x28701c79),
         UINT32_C(0xc1d7e124),
         UINT32_C(0x563e4b1c),
         UINT32_C(0xbf99b641),
         UINT32_C(0x000080d7),
         UINT32_C(0xe9a77d8a),
         UINT32_C(0x7e4ed7b2),
         UINT32_C(0x97e92aef),
         UINT32_C(0x28709cae),
         UINT32_C(0xc1d761f3),
         UINT32_C(0x563ecbcb),
         UINT32_C(0xbf993696)},
        {UINT32_C(0x00000000),
         UINT32_C(0x300363d7),
         UINT32_C(0x1000cc03),
         UINT32_C(0x2003afd4),
         UINT32_C(0x40000a0e),
         UINT32_C(0x700369d9),
         UINT32_C(0x5000c60d),
         UINT32_C(0x6003a5da),
         UINT32_C(0xa000080b),
         UINT32_C(0x90036bdc),
         UINT32_C(0xb000c408),
         UINT32_C(0x8003a7df),
         UINT32_C(0xe0000205),
         UINT32_C(0xd00361d2),
         UINT32_C(0xf000ce06),
         UINT32_C(0xc003add1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9801b1),
         UINT32_C(0x3f880066),
         UINT32_C(0x3f9001d7),
         UINT32_C(0x3fa00005),
         UINT32_C(0x3fb801b4),
         UINT32_C(0x3fa80063),
         UINT32_C(0x3fb001d2),
         UINT32_C(0x3fd00004),
         UINT32_C(0x3fc801b5),
         UINT32_C(0x3fd80062),
         UINT32_C(0x3fc001d3),
         UINT32_C(0x3ff00001),
         UINT32_C(0x3fe801b0),
         UINT32_C(0x3ff80067),
         UINT32_C(0x3fe001d6)},
        UINT32_C(0xfff80000),
        {0xd5,0x14,0x04,0xa9,0x05,0x77,0x56,0x00,0x9b,0x45,
         0x3c,0xb7,0x4c,0x3f,0x61,0x70,0x89,0x78,0x8d,0x54,0x00}
    },
    {
        /* No.456 delta:1708 weight:1567 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb252a23e),
         UINT32_C(0x1bc3b15c),
         UINT32_C(0xa9911362),
         UINT32_C(0x1bb01c87),
         UINT32_C(0xa9e2beb9),
         UINT32_C(0x0073addb),
         UINT32_C(0xb2210fe5),
         UINT32_C(0x0000202e),
         UINT32_C(0xb2528210),
         UINT32_C(0x1bc39172),
         UINT32_C(0xa991334c),
         UINT32_C(0x1bb03ca9),
         UINT32_C(0xa9e29e97),
         UINT32_C(0x00738df5),
         UINT32_C(0xb2212fcb)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2c1b011a),
         UINT32_C(0x80058011),
         UINT32_C(0xac1e810b),
         UINT32_C(0x0d102512),
         UINT32_C(0x210b2408),
         UINT32_C(0x8d15a503),
         UINT32_C(0xa10ea419),
         UINT32_C(0x020085bc),
         UINT32_C(0x2e1b84a6),
         UINT32_C(0x820505ad),
         UINT32_C(0xae1e04b7),
         UINT32_C(0x0f10a0ae),
         UINT32_C(0x230ba1b4),
         UINT32_C(0x8f1520bf),
         UINT32_C(0xa30e21a5)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f960d80),
         UINT32_C(0x3fc002c0),
         UINT32_C(0x3fd60f40),
         UINT32_C(0x3f868812),
         UINT32_C(0x3f908592),
         UINT32_C(0x3fc68ad2),
         UINT32_C(0x3fd08752),
         UINT32_C(0x3f810042),
         UINT32_C(0x3f970dc2),
         UINT32_C(0x3fc10282),
         UINT32_C(0x3fd70f02),
         UINT32_C(0x3f878850),
         UINT32_C(0x3f9185d0),
         UINT32_C(0x3fc78a90),
         UINT32_C(0x3fd18710)},
        UINT32_C(0xfff80000),
        {0xfe,0xf5,0x65,0x22,0x34,0x59,0xa4,0x03,0x8f,0x5c,
         0x1f,0xda,0xfe,0xda,0xb8,0x69,0xf8,0x0a,0xde,0xe6,0x00}
    },
    {
        /* No.457 delta:860 weight:1561 */
        11213,
        55,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xad2d4d15),
         UINT32_C(0x64c8b75e),
         UINT32_C(0xc9e5fa4b),
         UINT32_C(0xcad01c96),
         UINT32_C(0x67fd5183),
         UINT32_C(0xae18abc8),
         UINT32_C(0x0335e6dd),
         UINT32_C(0x00001b43),
         UINT32_C(0xad2d5656),
         UINT32_C(0x64c8ac1d),
         UINT32_C(0xc9e5e108),
         UINT32_C(0xcad007d5),
         UINT32_C(0x67fd4ac0),
         UINT32_C(0xae18b08b),
         UINT32_C(0x0335fd9e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0002afba),
         UINT32_C(0xc048c115),
         UINT32_C(0xc04a6eaf),
         UINT32_C(0x400431e3),
         UINT32_C(0x40069e59),
         UINT32_C(0x804cf0f6),
         UINT32_C(0x804e5f4c),
         UINT32_C(0x00016145),
         UINT32_C(0x0003ceff),
         UINT32_C(0xc049a050),
         UINT32_C(0xc04b0fea),
         UINT32_C(0x400550a6),
         UINT32_C(0x4007ff1c),
         UINT32_C(0x804d91b3),
         UINT32_C(0x804f3e09)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800157),
         UINT32_C(0x3fe02460),
         UINT32_C(0x3fe02537),
         UINT32_C(0x3fa00218),
         UINT32_C(0x3fa0034f),
         UINT32_C(0x3fc02678),
         UINT32_C(0x3fc0272f),
         UINT32_C(0x3f8000b0),
         UINT32_C(0x3f8001e7),
         UINT32_C(0x3fe024d0),
         UINT32_C(0x3fe02587),
         UINT32_C(0x3fa002a8),
         UINT32_C(0x3fa003ff),
         UINT32_C(0x3fc026c8),
         UINT32_C(0x3fc0279f)},
        UINT32_C(0xfff80000),
        {0x8c,0x2e,0x2b,0x31,0x16,0x38,0xd4,0x83,0x1c,0x8a,
         0xfc,0x4f,0xa3,0xe7,0x93,0xbc,0xc8,0x5f,0xa8,0x52,0x00}
    },
    {
        /* No.458 delta:1676 weight:1533 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x79fa442f),
         UINT32_C(0xf4897b00),
         UINT32_C(0x8d733f2f),
         UINT32_C(0x2e401cac),
         UINT32_C(0x57ba5883),
         UINT32_C(0xdac967ac),
         UINT32_C(0xa3332383),
         UINT32_C(0x00005efb),
         UINT32_C(0x79fa1ad4),
         UINT32_C(0xf48925fb),
         UINT32_C(0x8d7361d4),
         UINT32_C(0x2e404257),
         UINT32_C(0x57ba0678),
         UINT32_C(0xdac93957),
         UINT32_C(0xa3337d78)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0c6178b6),
         UINT32_C(0x7034c021),
         UINT32_C(0x7c55b897),
         UINT32_C(0x010aa18b),
         UINT32_C(0x0d6bd93d),
         UINT32_C(0x713e61aa),
         UINT32_C(0x7d5f191c),
         UINT32_C(0x0c1c0404),
         UINT32_C(0x007d7cb2),
         UINT32_C(0x7c28c425),
         UINT32_C(0x7049bc93),
         UINT32_C(0x0d16a58f),
         UINT32_C(0x0177dd39),
         UINT32_C(0x7d2265ae),
         UINT32_C(0x71431d18)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8630bc),
         UINT32_C(0x3fb81a60),
         UINT32_C(0x3fbe2adc),
         UINT32_C(0x3f808550),
         UINT32_C(0x3f86b5ec),
         UINT32_C(0x3fb89f30),
         UINT32_C(0x3fbeaf8c),
         UINT32_C(0x3f860e02),
         UINT32_C(0x3f803ebe),
         UINT32_C(0x3fbe1462),
         UINT32_C(0x3fb824de),
         UINT32_C(0x3f868b52),
         UINT32_C(0x3f80bbee),
         UINT32_C(0x3fbe9132),
         UINT32_C(0x3fb8a18e)},
        UINT32_C(0xfff80000),
        {0xaf,0xfd,0x1f,0x6b,0xc7,0x3c,0xbf,0xbe,0x3f,0xb9,
         0xf5,0x1b,0x89,0xa6,0xc1,0xc5,0xc0,0x6f,0x8d,0x88,0x00}
    },
    {
        /* No.459 delta:2859 weight:827 */
        11213,
        4,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x966cdd4d),
         UINT32_C(0x2dcf6a78),
         UINT32_C(0xbba3b735),
         UINT32_C(0x50c01cba),
         UINT32_C(0xc6acc1f7),
         UINT32_C(0x7d0f76c2),
         UINT32_C(0xeb63ab8f),
         UINT32_C(0x00007e6d),
         UINT32_C(0x966ca320),
         UINT32_C(0x2dcf1415),
         UINT32_C(0xbba3c958),
         UINT32_C(0x50c062d7),
         UINT32_C(0xc6acbf9a),
         UINT32_C(0x7d0f08af),
         UINT32_C(0xeb63d5e2)},
        {UINT32_C(0x00000000),
         UINT32_C(0x90c2e156),
         UINT32_C(0x398a8087),
         UINT32_C(0xa94861d1),
         UINT32_C(0x34102fed),
         UINT32_C(0xa4d2cebb),
         UINT32_C(0x0d9aaf6a),
         UINT32_C(0x9d584e3c),
         UINT32_C(0x8c00e21e),
         UINT32_C(0x1cc20348),
         UINT32_C(0xb58a6299),
         UINT32_C(0x254883cf),
         UINT32_C(0xb810cdf3),
         UINT32_C(0x28d22ca5),
         UINT32_C(0x819a4d74),
         UINT32_C(0x1158ac22)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc86170),
         UINT32_C(0x3f9cc540),
         UINT32_C(0x3fd4a430),
         UINT32_C(0x3f9a0817),
         UINT32_C(0x3fd26967),
         UINT32_C(0x3f86cd57),
         UINT32_C(0x3fceac27),
         UINT32_C(0x3fc60071),
         UINT32_C(0x3f8e6101),
         UINT32_C(0x3fdac531),
         UINT32_C(0x3f92a441),
         UINT32_C(0x3fdc0866),
         UINT32_C(0x3f946916),
         UINT32_C(0x3fc0cd26),
         UINT32_C(0x3f88ac56)},
        UINT32_C(0xfff80000),
        {0xa1,0x48,0x6f,0xb4,0x98,0x4a,0xc0,0x55,0x79,0xdf,
         0x91,0x6f,0x8d,0xfb,0xf8,0x83,0x2a,0x8c,0x08,0xe3,0x00}
    },
    {
        /* No.460 delta:3091 weight:655 */
        11213,
        3,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf7f86c95),
         UINT32_C(0x6bcc71ce),
         UINT32_C(0x9c341d5b),
         UINT32_C(0x5d901cc1),
         UINT32_C(0xaa687054),
         UINT32_C(0x365c6d0f),
         UINT32_C(0xc1a4019a),
         UINT32_C(0x00004c13),
         UINT32_C(0xf7f82086),
         UINT32_C(0x6bcc3ddd),
         UINT32_C(0x9c345148),
         UINT32_C(0x5d9050d2),
         UINT32_C(0xaa683c47),
         UINT32_C(0x365c211c),
         UINT32_C(0xc1a44d89)},
        {UINT32_C(0x00000000),
         UINT32_C(0xef0005af),
         UINT32_C(0x1362b07d),
         UINT32_C(0xfc62b5d2),
         UINT32_C(0x50614171),
         UINT32_C(0xbf6144de),
         UINT32_C(0x4303f10c),
         UINT32_C(0xac03f4a3),
         UINT32_C(0x09822615),
         UINT32_C(0xe68223ba),
         UINT32_C(0x1ae09668),
         UINT32_C(0xf5e093c7),
         UINT32_C(0x59e36764),
         UINT32_C(0xb6e362cb),
         UINT32_C(0x4a81d719),
         UINT32_C(0xa581d2b6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3ff78002),
         UINT32_C(0x3f89b158),
         UINT32_C(0x3ffe315a),
         UINT32_C(0x3fa830a0),
         UINT32_C(0x3fdfb0a2),
         UINT32_C(0x3fa181f8),
         UINT32_C(0x3fd601fa),
         UINT32_C(0x3f84c113),
         UINT32_C(0x3ff34111),
         UINT32_C(0x3f8d704b),
         UINT32_C(0x3ffaf049),
         UINT32_C(0x3facf1b3),
         UINT32_C(0x3fdb71b1),
         UINT32_C(0x3fa540eb),
         UINT32_C(0x3fd2c0e9)},
        UINT32_C(0xfff80000),
        {0xd8,0x49,0xac,0x16,0x01,0x46,0x55,0xa8,0x4b,0xb8,
         0x6e,0x39,0x40,0x02,0x2d,0x70,0x6d,0x36,0x2d,0x52,0x00}
    },
    {
        /* No.461 delta:1147 weight:1403 */
        11213,
        30,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xdbd3783d),
         UINT32_C(0xbe49cbc8),
         UINT32_C(0x659ab3f5),
         UINT32_C(0xed501cdd),
         UINT32_C(0x368364e0),
         UINT32_C(0x5319d715),
         UINT32_C(0x88caaf28),
         UINT32_C(0x00005530),
         UINT32_C(0xdbd32d0d),
         UINT32_C(0xbe499ef8),
         UINT32_C(0x659ae6c5),
         UINT32_C(0xed5049ed),
         UINT32_C(0x368331d0),
         UINT32_C(0x53198225),
         UINT32_C(0x88cafa18)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa3396c7e),
         UINT32_C(0x005264ec),
         UINT32_C(0xa36b0892),
         UINT32_C(0x00028606),
         UINT32_C(0xa33bea78),
         UINT32_C(0x0050e2ea),
         UINT32_C(0xa3698e94),
         UINT32_C(0x0034801d),
         UINT32_C(0xa30dec63),
         UINT32_C(0x0066e4f1),
         UINT32_C(0xa35f888f),
         UINT32_C(0x0036061b),
         UINT32_C(0xa30f6a65),
         UINT32_C(0x006462f7),
         UINT32_C(0xa35d0e89)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd19cb6),
         UINT32_C(0x3f802932),
         UINT32_C(0x3fd1b584),
         UINT32_C(0x3f800143),
         UINT32_C(0x3fd19df5),
         UINT32_C(0x3f802871),
         UINT32_C(0x3fd1b4c7),
         UINT32_C(0x3f801a40),
         UINT32_C(0x3fd186f6),
         UINT32_C(0x3f803372),
         UINT32_C(0x3fd1afc4),
         UINT32_C(0x3f801b03),
         UINT32_C(0x3fd187b5),
         UINT32_C(0x3f803231),
         UINT32_C(0x3fd1ae87)},
        UINT32_C(0xfff80000),
        {0xa0,0x0c,0xaf,0xc1,0x62,0x6d,0x77,0x93,0x39,0x49,
         0x43,0xa1,0x6f,0xcd,0xd2,0xe0,0x82,0x21,0x82,0x00,0x00}
    },
    {
        /* No.462 delta:1650 weight:1547 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xde2dcf6b),
         UINT32_C(0x3af4f8e1),
         UINT32_C(0xe4d9378a),
         UINT32_C(0xbe901ce6),
         UINT32_C(0x60bdd38d),
         UINT32_C(0x8464e407),
         UINT32_C(0x5a492b6c),
         UINT32_C(0x0000829f),
         UINT32_C(0xde2d4df4),
         UINT32_C(0x3af47a7e),
         UINT32_C(0xe4d9b515),
         UINT32_C(0xbe909e79),
         UINT32_C(0x60bd5112),
         UINT32_C(0x84646698),
         UINT32_C(0x5a49a9f3)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0901583c),
         UINT32_C(0x05ad222d),
         UINT32_C(0x0cac7a11),
         UINT32_C(0x018240de),
         UINT32_C(0x088318e2),
         UINT32_C(0x042f62f3),
         UINT32_C(0x0d2e3acf),
         UINT32_C(0x40124219),
         UINT32_C(0x49131a25),
         UINT32_C(0x45bf6034),
         UINT32_C(0x4cbe3808),
         UINT32_C(0x419002c7),
         UINT32_C(0x48915afb),
         UINT32_C(0x443d20ea),
         UINT32_C(0x4d3c78d6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8480ac),
         UINT32_C(0x3f82d691),
         UINT32_C(0x3f86563d),
         UINT32_C(0x3f80c120),
         UINT32_C(0x3f84418c),
         UINT32_C(0x3f8217b1),
         UINT32_C(0x3f86971d),
         UINT32_C(0x3fa00921),
         UINT32_C(0x3fa4898d),
         UINT32_C(0x3fa2dfb0),
         UINT32_C(0x3fa65f1c),
         UINT32_C(0x3fa0c801),
         UINT32_C(0x3fa448ad),
         UINT32_C(0x3fa21e90),
         UINT32_C(0x3fa69e3c)},
        UINT32_C(0xfff80000),
        {0x8e,0x3a,0x8d,0x78,0x09,0x9d,0xe5,0x21,0x70,0xc8,
         0x56,0xf3,0x4a,0xd3,0xf0,0x79,0x72,0xea,0x34,0x2b,0x00}
    },
    {
        /* No.463 delta:1698 weight:1635 */
        11213,
        37,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3ea32c98),
         UINT32_C(0xa2768504),
         UINT32_C(0x9cd5a99c),
         UINT32_C(0xb3701cf6),
         UINT32_C(0x8dd3306e),
         UINT32_C(0x110699f2),
         UINT32_C(0x2fa5b56a),
         UINT32_C(0x00001c59),
         UINT32_C(0x3ea330c1),
         UINT32_C(0xa276995d),
         UINT32_C(0x9cd5b5c5),
         UINT32_C(0xb37000af),
         UINT32_C(0x8dd32c37),
         UINT32_C(0x110685ab),
         UINT32_C(0x2fa5a933)},
        {UINT32_C(0x00000000),
         UINT32_C(0x005e605a),
         UINT32_C(0x403001ef),
         UINT32_C(0x406e61b5),
         UINT32_C(0x00620071),
         UINT32_C(0x003c602b),
         UINT32_C(0x4052019e),
         UINT32_C(0x400c61c4),
         UINT32_C(0x00020048),
         UINT32_C(0x005c6012),
         UINT32_C(0x403201a7),
         UINT32_C(0x406c61fd),
         UINT32_C(0x00600039),
         UINT32_C(0x003e6063),
         UINT32_C(0x405001d6),
         UINT32_C(0x400e618c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802f30),
         UINT32_C(0x3fa01800),
         UINT32_C(0x3fa03730),
         UINT32_C(0x3f803100),
         UINT32_C(0x3f801e30),
         UINT32_C(0x3fa02900),
         UINT32_C(0x3fa00630),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f802e30),
         UINT32_C(0x3fa01900),
         UINT32_C(0x3fa03630),
         UINT32_C(0x3f803000),
         UINT32_C(0x3f801f30),
         UINT32_C(0x3fa02800),
         UINT32_C(0x3fa00730)},
        UINT32_C(0xfff80000),
        {0xa4,0xe1,0x31,0xab,0xca,0x6a,0x42,0x05,0x4d,0x09,
         0xc5,0x2d,0x81,0xcc,0x0d,0x32,0x77,0x2e,0x23,0x6d,0x00}
    },
    {
        /* No.464 delta:994 weight:1683 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x6ab86193),
         UINT32_C(0x33d2fced),
         UINT32_C(0x596a9d7e),
         UINT32_C(0x3bd01d03),
         UINT32_C(0x51687c90),
         UINT32_C(0x0802e1ee),
         UINT32_C(0x62ba807d),
         UINT32_C(0x0000cbf6),
         UINT32_C(0x6ab8aa65),
         UINT32_C(0x33d2371b),
         UINT32_C(0x596a5688),
         UINT32_C(0x3bd0d6f5),
         UINT32_C(0x5168b766),
         UINT32_C(0x08022a18),
         UINT32_C(0x62ba4b8b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x101fc3ba),
         UINT32_C(0x000200d7),
         UINT32_C(0x101dc36d),
         UINT32_C(0xc040c084),
         UINT32_C(0xd05f033e),
         UINT32_C(0xc042c053),
         UINT32_C(0xd05d03e9),
         UINT32_C(0x3818003b),
         UINT32_C(0x2807c381),
         UINT32_C(0x381a00ec),
         UINT32_C(0x2805c356),
         UINT32_C(0xf858c0bf),
         UINT32_C(0xe8470305),
         UINT32_C(0xf85ac068),
         UINT32_C(0xe84503d2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880fe1),
         UINT32_C(0x3f800100),
         UINT32_C(0x3f880ee1),
         UINT32_C(0x3fe02060),
         UINT32_C(0x3fe82f81),
         UINT32_C(0x3fe02160),
         UINT32_C(0x3fe82e81),
         UINT32_C(0x3f9c0c00),
         UINT32_C(0x3f9403e1),
         UINT32_C(0x3f9c0d00),
         UINT32_C(0x3f9402e1),
         UINT32_C(0x3ffc2c60),
         UINT32_C(0x3ff42381),
         UINT32_C(0x3ffc2d60),
         UINT32_C(0x3ff42281)},
        UINT32_C(0xfff80000),
        {0x65,0x41,0x75,0x17,0xf0,0x67,0x8d,0x81,0x45,0x3f,
         0xae,0xf9,0xc4,0x4a,0xda,0x19,0x1a,0x50,0x12,0xff,0x00}
    },
    {
        /* No.465 delta:1002 weight:1417 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7e8c4d8d),
         UINT32_C(0x0204aa47),
         UINT32_C(0x7c88e7ca),
         UINT32_C(0x8f401d1f),
         UINT32_C(0xf1cc5092),
         UINT32_C(0x8d44b758),
         UINT32_C(0xf3c8fad5),
         UINT32_C(0x0000df1b),
         UINT32_C(0x7e8c9296),
         UINT32_C(0x0204755c),
         UINT32_C(0x7c8838d1),
         UINT32_C(0x8f40c204),
         UINT32_C(0xf1cc8f89),
         UINT32_C(0x8d446843),
         UINT32_C(0xf3c825ce)},
        {UINT32_C(0x00000000),
         UINT32_C(0x10002832),
         UINT32_C(0x4800201d),
         UINT32_C(0x5800082f),
         UINT32_C(0xa1001229),
         UINT32_C(0xb1003a1b),
         UINT32_C(0xe9003234),
         UINT32_C(0xf9001a06),
         UINT32_C(0xe0000401),
         UINT32_C(0xf0002c33),
         UINT32_C(0xa800241c),
         UINT32_C(0xb8000c2e),
         UINT32_C(0x41001628),
         UINT32_C(0x51003e1a),
         UINT32_C(0x09003635),
         UINT32_C(0x19001e07)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f880014),
         UINT32_C(0x3fa40010),
         UINT32_C(0x3fac0004),
         UINT32_C(0x3fd08009),
         UINT32_C(0x3fd8801d),
         UINT32_C(0x3ff48019),
         UINT32_C(0x3ffc800d),
         UINT32_C(0x3ff00002),
         UINT32_C(0x3ff80016),
         UINT32_C(0x3fd40012),
         UINT32_C(0x3fdc0006),
         UINT32_C(0x3fa0800b),
         UINT32_C(0x3fa8801f),
         UINT32_C(0x3f84801b),
         UINT32_C(0x3f8c800f)},
        UINT32_C(0xfff80000),
        {0xcb,0xd2,0x42,0x56,0xac,0xd3,0xc2,0x53,0x5c,0xf0,
         0x3f,0xae,0x10,0x6e,0x1a,0x1a,0x95,0x0d,0xc4,0xfe,0x00}
    },
    {
        /* No.466 delta:1116 weight:1429 */
        11213,
        32,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe8a2def6),
         UINT32_C(0x6697b821),
         UINT32_C(0x8e3566d7),
         UINT32_C(0x98701d28),
         UINT32_C(0x70d2c3de),
         UINT32_C(0xfee7a509),
         UINT32_C(0x16457bff),
         UINT32_C(0x0000b64a),
         UINT32_C(0xe8a268bc),
         UINT32_C(0x66970e6b),
         UINT32_C(0x8e35d09d),
         UINT32_C(0x9870ab62),
         UINT32_C(0x70d27594),
         UINT32_C(0xfee71343),
         UINT32_C(0x1645cdb5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x581c021a),
         UINT32_C(0x200281ff),
         UINT32_C(0x781e83e5),
         UINT32_C(0x0003550e),
         UINT32_C(0x581f5714),
         UINT32_C(0x2001d4f1),
         UINT32_C(0x781dd6eb),
         UINT32_C(0x02240015),
         UINT32_C(0x5a38020f),
         UINT32_C(0x222681ea),
         UINT32_C(0x7a3a83f0),
         UINT32_C(0x0227551b),
         UINT32_C(0x5a3b5701),
         UINT32_C(0x2225d4e4),
         UINT32_C(0x7a39d6fe)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fac0e01),
         UINT32_C(0x3f900140),
         UINT32_C(0x3fbc0f41),
         UINT32_C(0x3f8001aa),
         UINT32_C(0x3fac0fab),
         UINT32_C(0x3f9000ea),
         UINT32_C(0x3fbc0eeb),
         UINT32_C(0x3f811200),
         UINT32_C(0x3fad1c01),
         UINT32_C(0x3f911340),
         UINT32_C(0x3fbd1d41),
         UINT32_C(0x3f8113aa),
         UINT32_C(0x3fad1dab),
         UINT32_C(0x3f9112ea),
         UINT32_C(0x3fbd1ceb)},
        UINT32_C(0xfff80000),
        {0x8d,0x16,0x92,0xc4,0xde,0xb4,0x29,0xc1,0x8e,0xea,
         0x8e,0xe6,0x47,0xa0,0x78,0x42,0x18,0x3d,0x05,0x7d,0x00}
    },
    {
        /* No.467 delta:762 weight:1591 */
        11213,
        93,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x30431de8),
         UINT32_C(0xf4246d55),
         UINT32_C(0xc46770bd),
         UINT32_C(0xcca01d38),
         UINT32_C(0xfce300d0),
         UINT32_C(0x3884706d),
         UINT32_C(0x08c76d85),
         UINT32_C(0x00000155),
         UINT32_C(0x30431cbd),
         UINT32_C(0xf4246c00),
         UINT32_C(0xc46771e8),
         UINT32_C(0xcca01c6d),
         UINT32_C(0xfce30185),
         UINT32_C(0x38847138),
         UINT32_C(0x08c76cd0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x005c993b),
         UINT32_C(0x0003588e),
         UINT32_C(0x005fc1b5),
         UINT32_C(0x0002a01c),
         UINT32_C(0x005e3927),
         UINT32_C(0x0001f892),
         UINT32_C(0x005d61a9),
         UINT32_C(0x20103008),
         UINT32_C(0x204ca933),
         UINT32_C(0x20136886),
         UINT32_C(0x204ff1bd),
         UINT32_C(0x20129014),
         UINT32_C(0x204e092f),
         UINT32_C(0x2011c89a),
         UINT32_C(0x204d51a1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802e4c),
         UINT32_C(0x3f8001ac),
         UINT32_C(0x3f802fe0),
         UINT32_C(0x3f800150),
         UINT32_C(0x3f802f1c),
         UINT32_C(0x3f8000fc),
         UINT32_C(0x3f802eb0),
         UINT32_C(0x3f900818),
         UINT32_C(0x3f902654),
         UINT32_C(0x3f9009b4),
         UINT32_C(0x3f9027f8),
         UINT32_C(0x3f900948),
         UINT32_C(0x3f902704),
         UINT32_C(0x3f9008e4),
         UINT32_C(0x3f9026a8)},
        UINT32_C(0xfff80000),
        {0xc3,0x53,0xa2,0x6c,0x7b,0x6b,0x11,0xcb,0x82,0x73,
         0x97,0x3a,0x25,0x79,0x35,0x90,0x85,0x92,0x32,0xa3,0x00}
    },
    {
        /* No.468 delta:1074 weight:1391 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1836f48e),
         UINT32_C(0x1958a0d1),
         UINT32_C(0x016e545f),
         UINT32_C(0x8e001d40),
         UINT32_C(0x9636e9ce),
         UINT32_C(0x9758bd91),
         UINT32_C(0x8f6e491f),
         UINT32_C(0x00006285),
         UINT32_C(0x1836960b),
         UINT32_C(0x1958c254),
         UINT32_C(0x016e36da),
         UINT32_C(0x8e007fc5),
         UINT32_C(0x96368b4b),
         UINT32_C(0x9758df14),
         UINT32_C(0x8f6e2b9a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x400da476),
         UINT32_C(0x304444d5),
         UINT32_C(0x7049e0a3),
         UINT32_C(0x10132148),
         UINT32_C(0x501e853e),
         UINT32_C(0x2057659d),
         UINT32_C(0x605ac1eb),
         UINT32_C(0x0023a17f),
         UINT32_C(0x402e0509),
         UINT32_C(0x3067e5aa),
         UINT32_C(0x706a41dc),
         UINT32_C(0x10308037),
         UINT32_C(0x503d2441),
         UINT32_C(0x2074c4e2),
         UINT32_C(0x60796094)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa006d2),
         UINT32_C(0x3f982222),
         UINT32_C(0x3fb824f0),
         UINT32_C(0x3f880990),
         UINT32_C(0x3fa80f42),
         UINT32_C(0x3f902bb2),
         UINT32_C(0x3fb02d60),
         UINT32_C(0x3f8011d0),
         UINT32_C(0x3fa01702),
         UINT32_C(0x3f9833f2),
         UINT32_C(0x3fb83520),
         UINT32_C(0x3f881840),
         UINT32_C(0x3fa81e92),
         UINT32_C(0x3f903a62),
         UINT32_C(0x3fb03cb0)},
        UINT32_C(0xfff80000),
        {0xa6,0xe2,0x37,0x6d,0xb3,0xb4,0xf8,0x37,0x2e,0x27,
         0xa3,0xd0,0x12,0xa1,0x16,0x1d,0x94,0x5b,0x07,0xb1,0x00}
    },
    {
        /* No.469 delta:982 weight:1581 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x965ae253),
         UINT32_C(0xe70f4509),
         UINT32_C(0x7155a75a),
         UINT32_C(0x64a01d5b),
         UINT32_C(0xf2faff08),
         UINT32_C(0x83af5852),
         UINT32_C(0x15f5ba01),
         UINT32_C(0x0000bf56),
         UINT32_C(0x965a5d05),
         UINT32_C(0xe70ffa5f),
         UINT32_C(0x7155180c),
         UINT32_C(0x64a0a20d),
         UINT32_C(0xf2fa405e),
         UINT32_C(0x83afe704),
         UINT32_C(0x15f50557)},
        {UINT32_C(0x00000000),
         UINT32_C(0x200240f2),
         UINT32_C(0x240051d7),
         UINT32_C(0x04021125),
         UINT32_C(0x1406d09c),
         UINT32_C(0x3404906e),
         UINT32_C(0x3006814b),
         UINT32_C(0x1004c1b9),
         UINT32_C(0x1013e01a),
         UINT32_C(0x3011a0e8),
         UINT32_C(0x3413b1cd),
         UINT32_C(0x1411f13f),
         UINT32_C(0x04153086),
         UINT32_C(0x24177074),
         UINT32_C(0x20156151),
         UINT32_C(0x001721a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f900120),
         UINT32_C(0x3f920028),
         UINT32_C(0x3f820108),
         UINT32_C(0x3f8a0368),
         UINT32_C(0x3f9a0248),
         UINT32_C(0x3f980340),
         UINT32_C(0x3f880260),
         UINT32_C(0x3f8809f0),
         UINT32_C(0x3f9808d0),
         UINT32_C(0x3f9a09d8),
         UINT32_C(0x3f8a08f8),
         UINT32_C(0x3f820a98),
         UINT32_C(0x3f920bb8),
         UINT32_C(0x3f900ab0),
         UINT32_C(0x3f800b90)},
        UINT32_C(0xfff80000),
        {0x08,0xc2,0xc2,0xbf,0xba,0x73,0xe8,0x04,0x76,0xa9,
         0x5b,0x1a,0xad,0xea,0x5d,0x5a,0x98,0xb9,0xba,0x85,0x00}
    },
    {
        /* No.470 delta:997 weight:1427 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x57991792),
         UINT32_C(0xd2b792b3),
         UINT32_C(0x852e8521),
         UINT32_C(0x02e01d68),
         UINT32_C(0x55790afa),
         UINT32_C(0xd0578fdb),
         UINT32_C(0x87ce9849),
         UINT32_C(0x000085ae),
         UINT32_C(0x5799923c),
         UINT32_C(0xd2b7171d),
         UINT32_C(0x852e008f),
         UINT32_C(0x02e098c6),
         UINT32_C(0x55798f54),
         UINT32_C(0xd0570a75),
         UINT32_C(0x87ce1de7)},
        {UINT32_C(0x00000000),
         UINT32_C(0x402d0552),
         UINT32_C(0x0002c915),
         UINT32_C(0x402fcc47),
         UINT32_C(0x40467019),
         UINT32_C(0x006b754b),
         UINT32_C(0x4044b90c),
         UINT32_C(0x0069bc5e),
         UINT32_C(0x10b30c1a),
         UINT32_C(0x509e0948),
         UINT32_C(0x10b1c50f),
         UINT32_C(0x509cc05d),
         UINT32_C(0x50f57c03),
         UINT32_C(0x10d87951),
         UINT32_C(0x50f7b516),
         UINT32_C(0x10dab044)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa01682),
         UINT32_C(0x3f800164),
         UINT32_C(0x3fa017e6),
         UINT32_C(0x3fa02338),
         UINT32_C(0x3f8035ba),
         UINT32_C(0x3fa0225c),
         UINT32_C(0x3f8034de),
         UINT32_C(0x3f885986),
         UINT32_C(0x3fa84f04),
         UINT32_C(0x3f8858e2),
         UINT32_C(0x3fa84e60),
         UINT32_C(0x3fa87abe),
         UINT32_C(0x3f886c3c),
         UINT32_C(0x3fa87bda),
         UINT32_C(0x3f886d58)},
        UINT32_C(0xfff80000),
        {0xb6,0xab,0xb8,0x8e,0x22,0xc6,0xc1,0xf1,0xd8,0x58,
         0x6d,0x23,0x10,0x08,0x4b,0x05,0x84,0x5d,0xba,0xc4,0x00}
    },
    {
        /* No.471 delta:1497 weight:1575 */
        11213,
        16,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4ab0bf22),
         UINT32_C(0x834b4b03),
         UINT32_C(0xc9fbf421),
         UINT32_C(0xfd201d7c),
         UINT32_C(0xb790a25e),
         UINT32_C(0x7e6b567f),
         UINT32_C(0x34dbe95d),
         UINT32_C(0x00005885),
         UINT32_C(0x4ab0e7a7),
         UINT32_C(0x834b1386),
         UINT32_C(0xc9fbaca4),
         UINT32_C(0xfd2045f9),
         UINT32_C(0xb790fadb),
         UINT32_C(0x7e6b0efa),
         UINT32_C(0x34dbb1d8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0c14987e),
         UINT32_C(0x52f8e4ea),
         UINT32_C(0x5eec7c94),
         UINT32_C(0x004008d6),
         UINT32_C(0x0c5490a8),
         UINT32_C(0x52b8ec3c),
         UINT32_C(0x5eac7442),
         UINT32_C(0x0063e01f),
         UINT32_C(0x0c777861),
         UINT32_C(0x529b04f5),
         UINT32_C(0x5e8f9c8b),
         UINT32_C(0x0023e8c9),
         UINT32_C(0x0c3770b7),
         UINT32_C(0x52db0c23),
         UINT32_C(0x5ecf945d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f860a4c),
         UINT32_C(0x3fa97c72),
         UINT32_C(0x3faf763e),
         UINT32_C(0x3f802004),
         UINT32_C(0x3f862a48),
         UINT32_C(0x3fa95c76),
         UINT32_C(0x3faf563a),
         UINT32_C(0x3f8031f0),
         UINT32_C(0x3f863bbc),
         UINT32_C(0x3fa94d82),
         UINT32_C(0x3faf47ce),
         UINT32_C(0x3f8011f4),
         UINT32_C(0x3f861bb8),
         UINT32_C(0x3fa96d86),
         UINT32_C(0x3faf67ca)},
        UINT32_C(0xfff80000),
        {0x3f,0x76,0x21,0x59,0xf5,0x5e,0x78,0x7a,0xc1,0x86,
         0x48,0x8d,0x51,0x11,0x8a,0x29,0xa0,0x2f,0x4f,0x52,0x00}
    },
    {
        /* No.472 delta:1546 weight:1671 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3c6f0fba),
         UINT32_C(0x5b32d4c5),
         UINT32_C(0x675ddb7f),
         UINT32_C(0x20801d89),
         UINT32_C(0x1cef1233),
         UINT32_C(0x7bb2c94c),
         UINT32_C(0x47ddc6f6),
         UINT32_C(0x00006cad),
         UINT32_C(0x3c6f6317),
         UINT32_C(0x5b32b868),
         UINT32_C(0x675db7d2),
         UINT32_C(0x20807124),
         UINT32_C(0x1cef7e9e),
         UINT32_C(0x7bb2a5e1),
         UINT32_C(0x47ddaa5b)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa0d64076),
         UINT32_C(0x2054202f),
         UINT32_C(0x80826059),
         UINT32_C(0x003c098a),
         UINT32_C(0xa0ea49fc),
         UINT32_C(0x206829a5),
         UINT32_C(0x80be69d3),
         UINT32_C(0x20340012),
         UINT32_C(0x80e24064),
         UINT32_C(0x0060203d),
         UINT32_C(0xa0b6604b),
         UINT32_C(0x20080998),
         UINT32_C(0x80de49ee),
         UINT32_C(0x005c29b7),
         UINT32_C(0xa08a69c1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd06b20),
         UINT32_C(0x3f902a10),
         UINT32_C(0x3fc04130),
         UINT32_C(0x3f801e04),
         UINT32_C(0x3fd07524),
         UINT32_C(0x3f903414),
         UINT32_C(0x3fc05f34),
         UINT32_C(0x3f901a00),
         UINT32_C(0x3fc07120),
         UINT32_C(0x3f803010),
         UINT32_C(0x3fd05b30),
         UINT32_C(0x3f900404),
         UINT32_C(0x3fc06f24),
         UINT32_C(0x3f802e14),
         UINT32_C(0x3fd04534)},
        UINT32_C(0xfff80000),
        {0x4b,0x84,0x52,0xf4,0xd4,0x3a,0xf0,0x78,0xc5,0xe1,
         0xa3,0xd3,0xdd,0x9c,0x43,0x2f,0xbf,0xe2,0x0b,0xbb,0x00}
    },
    {
        /* No.473 delta:592 weight:1593 */
        11213,
        92,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x06b61206),
         UINT32_C(0x99dff500),
         UINT32_C(0x9f69e706),
         UINT32_C(0x29701d90),
         UINT32_C(0x2fc60f96),
         UINT32_C(0xb0afe890),
         UINT32_C(0xb619fa96),
         UINT32_C(0x000061d0),
         UINT32_C(0x06b673d6),
         UINT32_C(0x99df94d0),
         UINT32_C(0x9f6986d6),
         UINT32_C(0x29707c40),
         UINT32_C(0x2fc66e46),
         UINT32_C(0xb0af8940),
         UINT32_C(0xb6199b46)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20426f15),
         UINT32_C(0x40101c0f),
         UINT32_C(0x6052731a),
         UINT32_C(0x0002860b),
         UINT32_C(0x2040e91e),
         UINT32_C(0x40129a04),
         UINT32_C(0x6050f511),
         UINT32_C(0xc0015601),
         UINT32_C(0xe0433914),
         UINT32_C(0x80114a0e),
         UINT32_C(0xa053251b),
         UINT32_C(0xc003d00a),
         UINT32_C(0xe041bf1f),
         UINT32_C(0x8013cc05),
         UINT32_C(0xa051a310)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f902137),
         UINT32_C(0x3fa0080e),
         UINT32_C(0x3fb02939),
         UINT32_C(0x3f800143),
         UINT32_C(0x3f902074),
         UINT32_C(0x3fa0094d),
         UINT32_C(0x3fb0287a),
         UINT32_C(0x3fe000ab),
         UINT32_C(0x3ff0219c),
         UINT32_C(0x3fc008a5),
         UINT32_C(0x3fd02992),
         UINT32_C(0x3fe001e8),
         UINT32_C(0x3ff020df),
         UINT32_C(0x3fc009e6),
         UINT32_C(0x3fd028d1)},
        UINT32_C(0xfff80000),
        {0xec,0x8a,0x48,0x6b,0x4d,0xf5,0xc2,0x21,0x1b,0x26,
         0xab,0x20,0xda,0x44,0xaf,0x66,0x0f,0xc7,0x91,0x68,0x00}
    },
    {
        /* No.474 delta:1484 weight:1665 */
        11213,
        46,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4a404019),
         UINT32_C(0x6200ed9f),
         UINT32_C(0x2840ad86),
         UINT32_C(0x5f701da0),
         UINT32_C(0x15305db9),
         UINT32_C(0x3d70f03f),
         UINT32_C(0x7730b026),
         UINT32_C(0x000080de),
         UINT32_C(0x4a40c0c7),
         UINT32_C(0x62006d41),
         UINT32_C(0x28402d58),
         UINT32_C(0x5f709d7e),
         UINT32_C(0x1530dd67),
         UINT32_C(0x3d7070e1),
         UINT32_C(0x773030f8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0604021a),
         UINT32_C(0x000151d3),
         UINT32_C(0x060553c9),
         UINT32_C(0x00605025),
         UINT32_C(0x0664523f),
         UINT32_C(0x006101f6),
         UINT32_C(0x066503ec),
         UINT32_C(0x00401801),
         UINT32_C(0x06441a1b),
         UINT32_C(0x004149d2),
         UINT32_C(0x06454bc8),
         UINT32_C(0x00204824),
         UINT32_C(0x06244a3e),
         UINT32_C(0x002119f7),
         UINT32_C(0x06251bed)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f830201),
         UINT32_C(0x3f8000a8),
         UINT32_C(0x3f8302a9),
         UINT32_C(0x3f803028),
         UINT32_C(0x3f833229),
         UINT32_C(0x3f803080),
         UINT32_C(0x3f833281),
         UINT32_C(0x3f80200c),
         UINT32_C(0x3f83220d),
         UINT32_C(0x3f8020a4),
         UINT32_C(0x3f8322a5),
         UINT32_C(0x3f801024),
         UINT32_C(0x3f831225),
         UINT32_C(0x3f80108c),
         UINT32_C(0x3f83128d)},
        UINT32_C(0xfff80000),
        {0xd5,0x07,0x86,0x6a,0xf3,0xf9,0xb4,0xfd,0x66,0x09,
         0x32,0xf8,0x34,0x16,0x71,0x7b,0x8c,0x00,0x39,0xec,0x00}
    },
    {
        /* No.475 delta:830 weight:1563 */
        11213,
        52,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4d5a359d),
         UINT32_C(0x74795c1b),
         UINT32_C(0x39236986),
         UINT32_C(0xdd501dbb),
         UINT32_C(0x900a2826),
         UINT32_C(0xa92941a0),
         UINT32_C(0xe473743d),
         UINT32_C(0x0000d2bf),
         UINT32_C(0x4d5ae722),
         UINT32_C(0x74798ea4),
         UINT32_C(0x3923bb39),
         UINT32_C(0xdd50cf04),
         UINT32_C(0x900afa99),
         UINT32_C(0xa929931f),
         UINT32_C(0xe473a682)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4001e5f5),
         UINT32_C(0x200281fe),
         UINT32_C(0x6003640b),
         UINT32_C(0x3003c5b1),
         UINT32_C(0x70022044),
         UINT32_C(0x1001444f),
         UINT32_C(0x5000a1ba),
         UINT32_C(0x0003045c),
         UINT32_C(0x4002e1a9),
         UINT32_C(0x200185a2),
         UINT32_C(0x60006057),
         UINT32_C(0x3000c1ed),
         UINT32_C(0x70012418),
         UINT32_C(0x10024013),
         UINT32_C(0x5003a5e6)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa000f2),
         UINT32_C(0x3f900140),
         UINT32_C(0x3fb001b2),
         UINT32_C(0x3f9801e2),
         UINT32_C(0x3fb80110),
         UINT32_C(0x3f8800a2),
         UINT32_C(0x3fa80050),
         UINT32_C(0x3f800182),
         UINT32_C(0x3fa00170),
         UINT32_C(0x3f9000c2),
         UINT32_C(0x3fb00030),
         UINT32_C(0x3f980060),
         UINT32_C(0x3fb80092),
         UINT32_C(0x3f880120),
         UINT32_C(0x3fa801d2)},
        UINT32_C(0xfff80000),
        {0xe9,0x4d,0x06,0xe7,0xbe,0x86,0x9c,0xcb,0x53,0xa2,
         0x6c,0x00,0xb5,0x04,0xa1,0x88,0xe1,0x00,0x63,0x02,0x00}
    },
    {
        /* No.476 delta:1031 weight:1603 */
        11213,
        34,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xc2e33ade),
         UINT32_C(0xed885798),
         UINT32_C(0x2f6b6d46),
         UINT32_C(0x44c01dc8),
         UINT32_C(0x86232716),
         UINT32_C(0xa9484a50),
         UINT32_C(0x6bab708e),
         UINT32_C(0x0000f315),
         UINT32_C(0xc2e3c9cb),
         UINT32_C(0xed88a48d),
         UINT32_C(0x2f6b9e53),
         UINT32_C(0x44c0eedd),
         UINT32_C(0x8623d403),
         UINT32_C(0xa948b945),
         UINT32_C(0x6bab839b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x800d0e3e),
         UINT32_C(0x00252155),
         UINT32_C(0x80282f6b),
         UINT32_C(0x10472307),
         UINT32_C(0x904a2d39),
         UINT32_C(0x10620252),
         UINT32_C(0x906f0c6c),
         UINT32_C(0x00031017),
         UINT32_C(0x800e1e29),
         UINT32_C(0x00263142),
         UINT32_C(0x802b3f7c),
         UINT32_C(0x10443310),
         UINT32_C(0x90493d2e),
         UINT32_C(0x10611245),
         UINT32_C(0x906c1c7b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00687),
         UINT32_C(0x3f801290),
         UINT32_C(0x3fc01417),
         UINT32_C(0x3f882391),
         UINT32_C(0x3fc82516),
         UINT32_C(0x3f883101),
         UINT32_C(0x3fc83786),
         UINT32_C(0x3f800188),
         UINT32_C(0x3fc0070f),
         UINT32_C(0x3f801318),
         UINT32_C(0x3fc0159f),
         UINT32_C(0x3f882219),
         UINT32_C(0x3fc8249e),
         UINT32_C(0x3f883089),
         UINT32_C(0x3fc8360e)},
        UINT32_C(0xfff80000),
        {0x4a,0x30,0x35,0x89,0xd9,0x2e,0xb6,0xe1,0xe4,0xbc,
         0x08,0x82,0x8f,0x3c,0x33,0x86,0x05,0x31,0xf8,0x50,0x00}
    },
    {
        /* No.477 delta:1735 weight:1445 */
        11213,
        12,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x55099ce0),
         UINT32_C(0x7b86d53c),
         UINT32_C(0x2e8f49dc),
         UINT32_C(0xcca01dde),
         UINT32_C(0x99a9813e),
         UINT32_C(0xb726c8e2),
         UINT32_C(0xe22f5402),
         UINT32_C(0x00008290),
         UINT32_C(0x55091e70),
         UINT32_C(0x7b8657ac),
         UINT32_C(0x2e8fcb4c),
         UINT32_C(0xcca09f4e),
         UINT32_C(0x99a903ae),
         UINT32_C(0xb7264a72),
         UINT32_C(0xe22fd692)},
        {UINT32_C(0x00000000),
         UINT32_C(0x06052037),
         UINT32_C(0x10423c74),
         UINT32_C(0x16471c43),
         UINT32_C(0x016c608c),
         UINT32_C(0x076940bb),
         UINT32_C(0x112e5cf8),
         UINT32_C(0x172b7ccf),
         UINT32_C(0x0a20801d),
         UINT32_C(0x0c25a02a),
         UINT32_C(0x1a62bc69),
         UINT32_C(0x1c679c5e),
         UINT32_C(0x0b4ce091),
         UINT32_C(0x0d49c0a6),
         UINT32_C(0x1b0edce5),
         UINT32_C(0x1d0bfcd2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f830290),
         UINT32_C(0x3f88211e),
         UINT32_C(0x3f8b238e),
         UINT32_C(0x3f80b630),
         UINT32_C(0x3f83b4a0),
         UINT32_C(0x3f88972e),
         UINT32_C(0x3f8b95be),
         UINT32_C(0x3f851040),
         UINT32_C(0x3f8612d0),
         UINT32_C(0x3f8d315e),
         UINT32_C(0x3f8e33ce),
         UINT32_C(0x3f85a670),
         UINT32_C(0x3f86a4e0),
         UINT32_C(0x3f8d876e),
         UINT32_C(0x3f8e85fe)},
        UINT32_C(0xfff80000),
        {0x56,0x92,0xc7,0x71,0xc4,0xe9,0x4d,0x92,0xdc,0xbb,
         0x7f,0xca,0x0d,0xc7,0xe1,0x44,0xde,0x50,0xe1,0xd1,0x00}
    },
    {
        /* No.478 delta:2293 weight:1169 */
        11213,
        7,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x03773cb0),
         UINT32_C(0x5ab6d4e0),
         UINT32_C(0x59c1e850),
         UINT32_C(0x1b401de9),
         UINT32_C(0x18372159),
         UINT32_C(0x41f6c909),
         UINT32_C(0x4281f5b9),
         UINT32_C(0x000004f2),
         UINT32_C(0x03773842),
         UINT32_C(0x5ab6d012),
         UINT32_C(0x59c1eca2),
         UINT32_C(0x1b40191b),
         UINT32_C(0x183725ab),
         UINT32_C(0x41f6cdfb),
         UINT32_C(0x4281f14b)},
        {UINT32_C(0x00000000),
         UINT32_C(0xa75012d6),
         UINT32_C(0x2c5c1073),
         UINT32_C(0x8b0c02a5),
         UINT32_C(0x02da413c),
         UINT32_C(0xa58a53ea),
         UINT32_C(0x2e86514f),
         UINT32_C(0x89d64399),
         UINT32_C(0x22bc6018),
         UINT32_C(0x85ec72ce),
         UINT32_C(0x0ee0706b),
         UINT32_C(0xa9b062bd),
         UINT32_C(0x20662124),
         UINT32_C(0x873633f2),
         UINT32_C(0x0c3a3157),
         UINT32_C(0xab6a2381)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd3a809),
         UINT32_C(0x3f962e08),
         UINT32_C(0x3fc58601),
         UINT32_C(0x3f816d20),
         UINT32_C(0x3fd2c529),
         UINT32_C(0x3f974328),
         UINT32_C(0x3fc4eb21),
         UINT32_C(0x3f915e30),
         UINT32_C(0x3fc2f639),
         UINT32_C(0x3f877038),
         UINT32_C(0x3fd4d831),
         UINT32_C(0x3f903310),
         UINT32_C(0x3fc39b19),
         UINT32_C(0x3f861d18),
         UINT32_C(0x3fd5b511)},
        UINT32_C(0xfff80000),
        {0x2b,0x0a,0x30,0xdf,0x64,0x4e,0xf5,0x76,0xac,0x6c,
         0x8c,0xbc,0x7f,0x19,0x7e,0x4f,0x81,0x59,0x5d,0xa6,0x00}
    },
    {
        /* No.479 delta:791 weight:1715 */
        11213,
        85,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x539b6779),
         UINT32_C(0xda60077c),
         UINT32_C(0x89fb6005),
         UINT32_C(0x2ea01dfd),
         UINT32_C(0x7d3b7a84),
         UINT32_C(0xf4c01a81),
         UINT32_C(0xa75b7df8),
         UINT32_C(0x00008ebd),
         UINT32_C(0x539be9c4),
         UINT32_C(0xda6089c1),
         UINT32_C(0x89fbeeb8),
         UINT32_C(0x2ea09340),
         UINT32_C(0x7d3bf439),
         UINT32_C(0xf4c0943c),
         UINT32_C(0xa75bf345)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0074511a),
         UINT32_C(0x14901889),
         UINT32_C(0x14e44993),
         UINT32_C(0x000a11cb),
         UINT32_C(0x007e40d1),
         UINT32_C(0x149a0942),
         UINT32_C(0x14ee5858),
         UINT32_C(0x0003001c),
         UINT32_C(0x00775106),
         UINT32_C(0x14931895),
         UINT32_C(0x14e7498f),
         UINT32_C(0x000911d7),
         UINT32_C(0x007d40cd),
         UINT32_C(0x1499095e),
         UINT32_C(0x14ed5844)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803a28),
         UINT32_C(0x3f8a480c),
         UINT32_C(0x3f8a7224),
         UINT32_C(0x3f800508),
         UINT32_C(0x3f803f20),
         UINT32_C(0x3f8a4d04),
         UINT32_C(0x3f8a772c),
         UINT32_C(0x3f800180),
         UINT32_C(0x3f803ba8),
         UINT32_C(0x3f8a498c),
         UINT32_C(0x3f8a73a4),
         UINT32_C(0x3f800488),
         UINT32_C(0x3f803ea0),
         UINT32_C(0x3f8a4c84),
         UINT32_C(0x3f8a76ac)},
        UINT32_C(0xfff80000),
        {0x0d,0x78,0xe7,0xaa,0x59,0xa3,0x84,0x11,0xef,0x4d,
         0x42,0x34,0xd3,0x52,0x22,0x2f,0x7c,0xce,0xac,0x83,0x00}
    },
    {
        /* No.480 delta:1595 weight:1647 */
        11213,
        15,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xbd2c5e77),
         UINT32_C(0xb22dc09c),
         UINT32_C(0x0f019eeb),
         UINT32_C(0x3bb01e08),
         UINT32_C(0x869c407f),
         UINT32_C(0x899dde94),
         UINT32_C(0x34b180e3),
         UINT32_C(0x0000c58d),
         UINT32_C(0xbd2c9bfa),
         UINT32_C(0xb22d0511),
         UINT32_C(0x0f015b66),
         UINT32_C(0x3bb0db85),
         UINT32_C(0x869c85f2),
         UINT32_C(0x899d1b19),
         UINT32_C(0x34b1456e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x086d0b5a),
         UINT32_C(0x0812c0b7),
         UINT32_C(0x007fcbed),
         UINT32_C(0x3073801e),
         UINT32_C(0x381e8b44),
         UINT32_C(0x386140a9),
         UINT32_C(0x300c4bf3),
         UINT32_C(0x4072c0e6),
         UINT32_C(0x481fcbbc),
         UINT32_C(0x48600051),
         UINT32_C(0x400d0b0b),
         UINT32_C(0x700140f8),
         UINT32_C(0x786c4ba2),
         UINT32_C(0x7813804f),
         UINT32_C(0x707e8b15)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f843685),
         UINT32_C(0x3f840960),
         UINT32_C(0x3f803fe5),
         UINT32_C(0x3f9839c0),
         UINT32_C(0x3f9c0f45),
         UINT32_C(0x3f9c30a0),
         UINT32_C(0x3f980625),
         UINT32_C(0x3fa03960),
         UINT32_C(0x3fa40fe5),
         UINT32_C(0x3fa43000),
         UINT32_C(0x3fa00685),
         UINT32_C(0x3fb800a0),
         UINT32_C(0x3fbc3625),
         UINT32_C(0x3fbc09c0),
         UINT32_C(0x3fb83f45)},
        UINT32_C(0xfff80000),
        {0xa5,0xd7,0xca,0x72,0xf2,0x58,0xa0,0x42,0x12,0xcf,
         0x8c,0x91,0xdf,0xbb,0x30,0x7d,0x2e,0xcd,0xf7,0x31,0x00}
    },
    {
        /* No.481 delta:661 weight:1585 */
        11213,
        82,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x8706d6f8),
         UINT32_C(0x9a56f601),
         UINT32_C(0x1d5020f9),
         UINT32_C(0xa3201e10),
         UINT32_C(0x2426c8e8),
         UINT32_C(0x3976e811),
         UINT32_C(0xbe703ee9),
         UINT32_C(0x0000aace),
         UINT32_C(0x87067c36),
         UINT32_C(0x9a565ccf),
         UINT32_C(0x1d508a37),
         UINT32_C(0xa320b4de),
         UINT32_C(0x24266226),
         UINT32_C(0x397642df),
         UINT32_C(0xbe709427)},
        {UINT32_C(0x00000000),
         UINT32_C(0x003ad475),
         UINT32_C(0x1003c1d2),
         UINT32_C(0x103915a7),
         UINT32_C(0x1000300a),
         UINT32_C(0x103ae47f),
         UINT32_C(0x0003f1d8),
         UINT32_C(0x003925ad),
         UINT32_C(0xb00486da),
         UINT32_C(0xb03e52af),
         UINT32_C(0xa0074708),
         UINT32_C(0xa03d937d),
         UINT32_C(0xa004b6d0),
         UINT32_C(0xa03e62a5),
         UINT32_C(0xb0077702),
         UINT32_C(0xb03da377)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f801d6a),
         UINT32_C(0x3f8801e0),
         UINT32_C(0x3f881c8a),
         UINT32_C(0x3f880018),
         UINT32_C(0x3f881d72),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3f801c92),
         UINT32_C(0x3fd80243),
         UINT32_C(0x3fd81f29),
         UINT32_C(0x3fd003a3),
         UINT32_C(0x3fd01ec9),
         UINT32_C(0x3fd0025b),
         UINT32_C(0x3fd01f31),
         UINT32_C(0x3fd803bb),
         UINT32_C(0x3fd81ed1)},
        UINT32_C(0xfff80000),
        {0x8b,0x7f,0x7e,0x4f,0xc3,0x10,0x72,0x81,0x14,0xfe,
         0xb0,0x5b,0x7e,0x02,0x7d,0x2c,0x67,0x07,0x22,0x64,0x00}
    },
    {
        /* No.482 delta:1427 weight:1483 */
        11213,
        28,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe4a1391a),
         UINT32_C(0x8e203bc0),
         UINT32_C(0x6a8102da),
         UINT32_C(0x9ed01e29),
         UINT32_C(0x7a712733),
         UINT32_C(0x10f025e9),
         UINT32_C(0xf4511cf3),
         UINT32_C(0x0000aa49),
         UINT32_C(0xe4a19353),
         UINT32_C(0x8e209189),
         UINT32_C(0x6a81a893),
         UINT32_C(0x9ed0b460),
         UINT32_C(0x7a718d7a),
         UINT32_C(0x10f08fa0),
         UINT32_C(0xf451b6ba)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0055a05a),
         UINT32_C(0x002d21dc),
         UINT32_C(0x00788186),
         UINT32_C(0x0024e04d),
         UINT32_C(0x00714017),
         UINT32_C(0x0009c191),
         UINT32_C(0x005c61cb),
         UINT32_C(0x26012068),
         UINT32_C(0x26548032),
         UINT32_C(0x262c01b4),
         UINT32_C(0x2679a1ee),
         UINT32_C(0x2625c025),
         UINT32_C(0x2670607f),
         UINT32_C(0x2608e1f9),
         UINT32_C(0x265d41a3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802ad0),
         UINT32_C(0x3f801690),
         UINT32_C(0x3f803c40),
         UINT32_C(0x3f801270),
         UINT32_C(0x3f8038a0),
         UINT32_C(0x3f8004e0),
         UINT32_C(0x3f802e30),
         UINT32_C(0x3f930090),
         UINT32_C(0x3f932a40),
         UINT32_C(0x3f931600),
         UINT32_C(0x3f933cd0),
         UINT32_C(0x3f9312e0),
         UINT32_C(0x3f933830),
         UINT32_C(0x3f930470),
         UINT32_C(0x3f932ea0)},
        UINT32_C(0xfff80000),
        {0xf3,0x09,0x00,0xdd,0x80,0x3f,0x75,0x9a,0xc3,0x5c,
         0x4f,0x26,0x48,0x9d,0xf9,0x76,0x59,0xa1,0xf3,0xbd,0x00}
    },
    {
        /* No.483 delta:895 weight:1643 */
        11213,
        47,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4cfacd5b),
         UINT32_C(0x27cd4160),
         UINT32_C(0x6b378c3b),
         UINT32_C(0xa8b01e31),
         UINT32_C(0xe44ad36a),
         UINT32_C(0x8f7d5f51),
         UINT32_C(0xc387920a),
         UINT32_C(0x000098a4),
         UINT32_C(0x4cfa55ff),
         UINT32_C(0x27cdd9c4),
         UINT32_C(0x6b37149f),
         UINT32_C(0xa8b08695),
         UINT32_C(0xe44a4bce),
         UINT32_C(0x8f7dc7f5),
         UINT32_C(0xc3870aae)},
        {UINT32_C(0x00000000),
         UINT32_C(0x014440bf),
         UINT32_C(0x2002818d),
         UINT32_C(0x2146c132),
         UINT32_C(0x00031944),
         UINT32_C(0x014759fb),
         UINT32_C(0x200198c9),
         UINT32_C(0x2145d876),
         UINT32_C(0x1000c0a8),
         UINT32_C(0x11448017),
         UINT32_C(0x30024125),
         UINT32_C(0x3146019a),
         UINT32_C(0x1003d9ec),
         UINT32_C(0x11479953),
         UINT32_C(0x30015861),
         UINT32_C(0x314518de)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f80a220),
         UINT32_C(0x3f900140),
         UINT32_C(0x3f90a360),
         UINT32_C(0x3f80018c),
         UINT32_C(0x3f80a3ac),
         UINT32_C(0x3f9000cc),
         UINT32_C(0x3f90a2ec),
         UINT32_C(0x3f880060),
         UINT32_C(0x3f88a240),
         UINT32_C(0x3f980120),
         UINT32_C(0x3f98a300),
         UINT32_C(0x3f8801ec),
         UINT32_C(0x3f88a3cc),
         UINT32_C(0x3f9800ac),
         UINT32_C(0x3f98a28c)},
        UINT32_C(0xfff80000),
        {0x89,0x3f,0x9f,0xbf,0x6d,0xff,0x9f,0x6c,0xfd,0x8e,
         0xef,0x64,0x30,0xad,0xc5,0x03,0x35,0xe5,0xe9,0xe4,0x00}
    },
    {
        /* No.484 delta:1190 weight:1435 */
        11213,
        26,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xf2958c1f),
         UINT32_C(0xcd7d7078),
         UINT32_C(0x3fe8fc67),
         UINT32_C(0x8e601e49),
         UINT32_C(0x7cf59256),
         UINT32_C(0x431d6e31),
         UINT32_C(0xb188e22e),
         UINT32_C(0x0000eabe),
         UINT32_C(0xf29566a1),
         UINT32_C(0xcd7d9ac6),
         UINT32_C(0x3fe816d9),
         UINT32_C(0x8e60f4f7),
         UINT32_C(0x7cf578e8),
         UINT32_C(0x431d848f),
         UINT32_C(0xb1880890)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4815193e),
         UINT32_C(0x00495842),
         UINT32_C(0x485c417c),
         UINT32_C(0x00383075),
         UINT32_C(0x482d294b),
         UINT32_C(0x00716837),
         UINT32_C(0x48647109),
         UINT32_C(0x000d0013),
         UINT32_C(0x4818192d),
         UINT32_C(0x00445851),
         UINT32_C(0x4851416f),
         UINT32_C(0x00353066),
         UINT32_C(0x48202958),
         UINT32_C(0x007c6824),
         UINT32_C(0x4869711a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa40a8c),
         UINT32_C(0x3f8024ac),
         UINT32_C(0x3fa42e20),
         UINT32_C(0x3f801c18),
         UINT32_C(0x3fa41694),
         UINT32_C(0x3f8038b4),
         UINT32_C(0x3fa43238),
         UINT32_C(0x3f800680),
         UINT32_C(0x3fa40c0c),
         UINT32_C(0x3f80222c),
         UINT32_C(0x3fa428a0),
         UINT32_C(0x3f801a98),
         UINT32_C(0x3fa41014),
         UINT32_C(0x3f803e34),
         UINT32_C(0x3fa434b8)},
        UINT32_C(0xfff80000),
        {0x54,0xe9,0x22,0x78,0x5d,0xe4,0xa7,0xbc,0x18,0x76,
         0xac,0x5b,0x66,0x30,0xbb,0x80,0xb4,0xa7,0xc2,0x63,0x00}
    },
    {
        /* No.485 delta:1384 weight:1657 */
        11213,
        18,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x5a57ad1b),
         UINT32_C(0x036a3d74),
         UINT32_C(0x593d906f),
         UINT32_C(0x6e801e5f),
         UINT32_C(0x34d7b344),
         UINT32_C(0x6dea232b),
         UINT32_C(0x37bd8e30),
         UINT32_C(0x0000d457),
         UINT32_C(0x5a57794c),
         UINT32_C(0x036ae923),
         UINT32_C(0x593d4438),
         UINT32_C(0x6e80ca08),
         UINT32_C(0x34d76713),
         UINT32_C(0x6deaf77c),
         UINT32_C(0x37bd5a67)},
        {UINT32_C(0x00000000),
         UINT32_C(0x40245dbe),
         UINT32_C(0x107e60d7),
         UINT32_C(0x505a3d69),
         UINT32_C(0x1020141c),
         UINT32_C(0x500449a2),
         UINT32_C(0x005e74cb),
         UINT32_C(0x407a2975),
         UINT32_C(0x0040581f),
         UINT32_C(0x406405a1),
         UINT32_C(0x103e38c8),
         UINT32_C(0x501a6576),
         UINT32_C(0x10604c03),
         UINT32_C(0x504411bd),
         UINT32_C(0x001e2cd4),
         UINT32_C(0x403a716a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa0122e),
         UINT32_C(0x3f883f30),
         UINT32_C(0x3fa82d1e),
         UINT32_C(0x3f88100a),
         UINT32_C(0x3fa80224),
         UINT32_C(0x3f802f3a),
         UINT32_C(0x3fa03d14),
         UINT32_C(0x3f80202c),
         UINT32_C(0x3fa03202),
         UINT32_C(0x3f881f1c),
         UINT32_C(0x3fa80d32),
         UINT32_C(0x3f883026),
         UINT32_C(0x3fa82208),
         UINT32_C(0x3f800f16),
         UINT32_C(0x3fa01d38)},
        UINT32_C(0xfff80000),
        {0x86,0x73,0xee,0xd6,0x35,0x0a,0x6e,0x88,0x98,0x23,
         0x58,0x03,0xcd,0x66,0x13,0xda,0x6f,0xf4,0xa8,0x9c,0x00}
    },
    {
        /* No.486 delta:789 weight:981 */
        11213,
        59,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xb85eea7e),
         UINT32_C(0xcc10c616),
         UINT32_C(0x744e2c68),
         UINT32_C(0x21901e68),
         UINT32_C(0x99cef416),
         UINT32_C(0xed80d87e),
         UINT32_C(0x55de3200),
         UINT32_C(0x00004652),
         UINT32_C(0xb85eac2c),
         UINT32_C(0xcc108044),
         UINT32_C(0x744e6a3a),
         UINT32_C(0x2190583a),
         UINT32_C(0x99ceb244),
         UINT32_C(0xed809e2c),
         UINT32_C(0x55de7452)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0046c133),
         UINT32_C(0x2003020f),
         UINT32_C(0x2045c33c),
         UINT32_C(0xa0141115),
         UINT32_C(0xa052d026),
         UINT32_C(0x8017131a),
         UINT32_C(0x8051d229),
         UINT32_C(0x5000881b),
         UINT32_C(0x50464928),
         UINT32_C(0x70038a14),
         UINT32_C(0x70454b27),
         UINT32_C(0xf014990e),
         UINT32_C(0xf052583d),
         UINT32_C(0xd0179b01),
         UINT32_C(0xd0515a32)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f802360),
         UINT32_C(0x3f900181),
         UINT32_C(0x3f9022e1),
         UINT32_C(0x3fd00a08),
         UINT32_C(0x3fd02968),
         UINT32_C(0x3fc00b89),
         UINT32_C(0x3fc028e9),
         UINT32_C(0x3fa80044),
         UINT32_C(0x3fa82324),
         UINT32_C(0x3fb801c5),
         UINT32_C(0x3fb822a5),
         UINT32_C(0x3ff80a4c),
         UINT32_C(0x3ff8292c),
         UINT32_C(0x3fe80bcd),
         UINT32_C(0x3fe828ad)},
        UINT32_C(0xfff80000),
        {0x39,0xa7,0x43,0x82,0x10,0xf1,0x92,0xf4,0x2f,0x72,
         0x84,0x17,0x0b,0xc0,0xf2,0x11,0x07,0x37,0x0a,0x5f,0x00}
    },
    {
        /* No.487 delta:809 weight:1233 */
        11213,
        78,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9d9a9223),
         UINT32_C(0x96c66987),
         UINT32_C(0x0b5cfba4),
         UINT32_C(0x5e301e79),
         UINT32_C(0xc3aa8c5a),
         UINT32_C(0xc8f677fe),
         UINT32_C(0x556ce5dd),
         UINT32_C(0x00005333),
         UINT32_C(0x9d9ac110),
         UINT32_C(0x96c63ab4),
         UINT32_C(0x0b5ca897),
         UINT32_C(0x5e304d4a),
         UINT32_C(0xc3aadf69),
         UINT32_C(0xc8f624cd),
         UINT32_C(0x556cb6ee)},
        {UINT32_C(0x00000000),
         UINT32_C(0x80022115),
         UINT32_C(0x100280ff),
         UINT32_C(0x9000a1ea),
         UINT32_C(0x00022151),
         UINT32_C(0x80000044),
         UINT32_C(0x1000a1ae),
         UINT32_C(0x900280bb),
         UINT32_C(0x2002d816),
         UINT32_C(0xa000f903),
         UINT32_C(0x300058e9),
         UINT32_C(0xb00279fc),
         UINT32_C(0x2000f947),
         UINT32_C(0xa002d852),
         UINT32_C(0x300279b8),
         UINT32_C(0xb00058ad)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc00110),
         UINT32_C(0x3f880140),
         UINT32_C(0x3fc80050),
         UINT32_C(0x3f800110),
         UINT32_C(0x3fc00000),
         UINT32_C(0x3f880050),
         UINT32_C(0x3fc80140),
         UINT32_C(0x3f90016c),
         UINT32_C(0x3fd0007c),
         UINT32_C(0x3f98002c),
         UINT32_C(0x3fd8013c),
         UINT32_C(0x3f90007c),
         UINT32_C(0x3fd0016c),
         UINT32_C(0x3f98013c),
         UINT32_C(0x3fd8002c)},
        UINT32_C(0xfff80000),
        {0x7e,0xb6,0xab,0x08,0x94,0x26,0x29,0x6d,0x64,0x90,
         0x30,0x0b,0xf2,0x59,0x96,0x33,0x0c,0x56,0x49,0x6e,0x00}
    },
    {
        /* No.488 delta:767 weight:1605 */
        11213,
        85,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x83dbce25),
         UINT32_C(0x0f7c1229),
         UINT32_C(0x8ca7dc0c),
         UINT32_C(0xf4401e86),
         UINT32_C(0x779bd0a3),
         UINT32_C(0xfb3c0caf),
         UINT32_C(0x78e7c28a),
         UINT32_C(0x00008620),
         UINT32_C(0x83db4805),
         UINT32_C(0x0f7c9409),
         UINT32_C(0x8ca75a2c),
         UINT32_C(0xf44098a6),
         UINT32_C(0x779b5683),
         UINT32_C(0xfb3c8a8f),
         UINT32_C(0x78e744aa)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0068101e),
         UINT32_C(0x00020509),
         UINT32_C(0x006a1517),
         UINT32_C(0x8029900b),
         UINT32_C(0x80418015),
         UINT32_C(0x802b9502),
         UINT32_C(0x8043851c),
         UINT32_C(0x10014807),
         UINT32_C(0x10695819),
         UINT32_C(0x10034d0e),
         UINT32_C(0x106b5d10),
         UINT32_C(0x9028d80c),
         UINT32_C(0x9040c812),
         UINT32_C(0x902add05),
         UINT32_C(0x9042cd1b)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f803408),
         UINT32_C(0x3f800102),
         UINT32_C(0x3f80350a),
         UINT32_C(0x3fc014c8),
         UINT32_C(0x3fc020c0),
         UINT32_C(0x3fc015ca),
         UINT32_C(0x3fc021c2),
         UINT32_C(0x3f8800a4),
         UINT32_C(0x3f8834ac),
         UINT32_C(0x3f8801a6),
         UINT32_C(0x3f8835ae),
         UINT32_C(0x3fc8146c),
         UINT32_C(0x3fc82064),
         UINT32_C(0x3fc8156e),
         UINT32_C(0x3fc82166)},
        UINT32_C(0xfff80000),
        {0x8d,0xa5,0x7f,0x9e,0x3f,0x68,0x4c,0xbb,0xb0,0x3c,
         0xf5,0x1f,0x8a,0xe6,0xaf,0x78,0xbc,0x05,0x6b,0x83,0x00}
    },
    {
        /* No.489 delta:659 weight:1469 */
        11213,
        82,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x965af929),
         UINT32_C(0x55575ec4),
         UINT32_C(0xc30da7ed),
         UINT32_C(0x1b301e90),
         UINT32_C(0x8d6ae7b9),
         UINT32_C(0x4e674054),
         UINT32_C(0xd83db97d),
         UINT32_C(0x0000d995),
         UINT32_C(0x965a20bc),
         UINT32_C(0x55578751),
         UINT32_C(0xc30d7e78),
         UINT32_C(0x1b30c705),
         UINT32_C(0x8d6a3e2c),
         UINT32_C(0x4e6799c1),
         UINT32_C(0xd83d60e8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4003ec1e),
         UINT32_C(0x10031935),
         UINT32_C(0x5000f52b),
         UINT32_C(0x001029b2),
         UINT32_C(0x4013c5ac),
         UINT32_C(0x10133087),
         UINT32_C(0x5010dc99),
         UINT32_C(0x80001213),
         UINT32_C(0xc003fe0d),
         UINT32_C(0x90030b26),
         UINT32_C(0xd000e738),
         UINT32_C(0x80103ba1),
         UINT32_C(0xc013d7bf),
         UINT32_C(0x90132294),
         UINT32_C(0xd010ce8a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa001f6),
         UINT32_C(0x3f88018c),
         UINT32_C(0x3fa8007a),
         UINT32_C(0x3f800814),
         UINT32_C(0x3fa009e2),
         UINT32_C(0x3f880998),
         UINT32_C(0x3fa8086e),
         UINT32_C(0x3fc00009),
         UINT32_C(0x3fe001ff),
         UINT32_C(0x3fc80185),
         UINT32_C(0x3fe80073),
         UINT32_C(0x3fc0081d),
         UINT32_C(0x3fe009eb),
         UINT32_C(0x3fc80991),
         UINT32_C(0x3fe80867)},
        UINT32_C(0xfff80000),
        {0x86,0x7f,0xad,0xde,0xa5,0x0a,0x4a,0x94,0x67,0xe3,
         0xcf,0x91,0xe1,0xc5,0x2e,0x2e,0x81,0x54,0xf4,0x76,0x00}
    },
    {
        /* No.490 delta:2006 weight:1357 */
        11213,
        9,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2c3a57a8),
         UINT32_C(0x7d913669),
         UINT32_C(0x51ab61c1),
         UINT32_C(0x8bc01ea9),
         UINT32_C(0xa7fa4901),
         UINT32_C(0xf65128c0),
         UINT32_C(0xda6b7f68),
         UINT32_C(0x0000fb64),
         UINT32_C(0x2c3aaccc),
         UINT32_C(0x7d91cd0d),
         UINT32_C(0x51ab9aa5),
         UINT32_C(0x8bc0e5cd),
         UINT32_C(0xa7fab265),
         UINT32_C(0xf651d3a4),
         UINT32_C(0xda6b840c)},
        {UINT32_C(0x00000000),
         UINT32_C(0x21a4a05e),
         UINT32_C(0x0a8105db),
         UINT32_C(0x2b25a585),
         UINT32_C(0x0494814a),
         UINT32_C(0x25302114),
         UINT32_C(0x0e158491),
         UINT32_C(0x2fb124cf),
         UINT32_C(0x6090251d),
         UINT32_C(0x41348543),
         UINT32_C(0x6a1120c6),
         UINT32_C(0x4bb58098),
         UINT32_C(0x6404a457),
         UINT32_C(0x45a00409),
         UINT32_C(0x6e85a18c),
         UINT32_C(0x4f2101d2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f90d250),
         UINT32_C(0x3f854082),
         UINT32_C(0x3f9592d2),
         UINT32_C(0x3f824a40),
         UINT32_C(0x3f929810),
         UINT32_C(0x3f870ac2),
         UINT32_C(0x3f97d892),
         UINT32_C(0x3fb04812),
         UINT32_C(0x3fa09a42),
         UINT32_C(0x3fb50890),
         UINT32_C(0x3fa5dac0),
         UINT32_C(0x3fb20252),
         UINT32_C(0x3fa2d002),
         UINT32_C(0x3fb742d0),
         UINT32_C(0x3fa79080)},
        UINT32_C(0xfff80000),
        {0xf4,0x0f,0xf1,0x1f,0xed,0xdf,0xba,0x86,0xea,0x9b,
         0xa8,0x8b,0x2f,0x20,0x30,0x95,0xb0,0x77,0x5c,0xdf,0x00}
    },
    {
        /* No.491 delta:1573 weight:1665 */
        11213,
        14,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x4eff2c33),
         UINT32_C(0xed467d5f),
         UINT32_C(0xa3b9516c),
         UINT32_C(0x71701eba),
         UINT32_C(0x3f8f3289),
         UINT32_C(0x9c3663e5),
         UINT32_C(0xd2c94fd6),
         UINT32_C(0x00008ae3),
         UINT32_C(0x4effa6d0),
         UINT32_C(0xed46f7bc),
         UINT32_C(0xa3b9db8f),
         UINT32_C(0x71709459),
         UINT32_C(0x3f8fb86a),
         UINT32_C(0x9c36e906),
         UINT32_C(0xd2c9c535)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0838791a),
         UINT32_C(0x80101447),
         UINT32_C(0x88286d5d),
         UINT32_C(0xaae4a1e4),
         UINT32_C(0xa2dcd8fe),
         UINT32_C(0x2af4b5a3),
         UINT32_C(0x22ccccb9),
         UINT32_C(0x00714116),
         UINT32_C(0x0849380c),
         UINT32_C(0x80615551),
         UINT32_C(0x88592c4b),
         UINT32_C(0xaa95e0f2),
         UINT32_C(0xa2ad99e8),
         UINT32_C(0x2a85f4b5),
         UINT32_C(0x22bd8daf)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f841c3c),
         UINT32_C(0x3fc0080a),
         UINT32_C(0x3fc41436),
         UINT32_C(0x3fd57250),
         UINT32_C(0x3fd16e6c),
         UINT32_C(0x3f957a5a),
         UINT32_C(0x3f916666),
         UINT32_C(0x3f8038a0),
         UINT32_C(0x3f84249c),
         UINT32_C(0x3fc030aa),
         UINT32_C(0x3fc42c96),
         UINT32_C(0x3fd54af0),
         UINT32_C(0x3fd156cc),
         UINT32_C(0x3f9542fa),
         UINT32_C(0x3f915ec6)},
        UINT32_C(0xfff80000),
        {0x43,0x78,0xfc,0x4c,0xe1,0x28,0x2a,0x91,0x6f,0x5d,
         0x7e,0x43,0x67,0x9f,0x17,0x74,0xb9,0xdb,0xa8,0x88,0x00}
    },
    {
        /* No.492 delta:1070 weight:1409 */
        11213,
        64,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe9cd57ea),
         UINT32_C(0x44cf19b4),
         UINT32_C(0xad024e5e),
         UINT32_C(0x56201ec3),
         UINT32_C(0xbfed4929),
         UINT32_C(0x12ef0777),
         UINT32_C(0xfb22509d),
         UINT32_C(0x0000116d),
         UINT32_C(0xe9cd4687),
         UINT32_C(0x44cf08d9),
         UINT32_C(0xad025f33),
         UINT32_C(0x56200fae),
         UINT32_C(0xbfed5844),
         UINT32_C(0x12ef161a),
         UINT32_C(0xfb2241f0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x5002c79a),
         UINT32_C(0x00032c0d),
         UINT32_C(0x5001eb97),
         UINT32_C(0x304c83cc),
         UINT32_C(0x604e4456),
         UINT32_C(0x304fafc1),
         UINT32_C(0x604d685b),
         UINT32_C(0x5003880f),
         UINT32_C(0x00014f95),
         UINT32_C(0x5000a402),
         UINT32_C(0x00026398),
         UINT32_C(0x604f0bc3),
         UINT32_C(0x304dcc59),
         UINT32_C(0x604c27ce),
         UINT32_C(0x304ee054)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa80163),
         UINT32_C(0x3f800196),
         UINT32_C(0x3fa800f5),
         UINT32_C(0x3f982641),
         UINT32_C(0x3fb02722),
         UINT32_C(0x3f9827d7),
         UINT32_C(0x3fb026b4),
         UINT32_C(0x3fa801c4),
         UINT32_C(0x3f8000a7),
         UINT32_C(0x3fa80052),
         UINT32_C(0x3f800131),
         UINT32_C(0x3fb02785),
         UINT32_C(0x3f9826e6),
         UINT32_C(0x3fb02613),
         UINT32_C(0x3f982770)},
        UINT32_C(0xfff80000),
        {0x24,0x8c,0x8b,0x31,0xdd,0x5d,0xe3,0xe4,0x00,0x26,
         0x0e,0x6c,0x42,0xd3,0x46,0xe7,0xbd,0xe8,0x67,0x1a,0x00}
    },
    {
        /* No.493 delta:1753 weight:1735 */
        11213,
        62,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x02767588),
         UINT32_C(0xd0730661),
         UINT32_C(0xd20573e9),
         UINT32_C(0xea701edc),
         UINT32_C(0xe8066b54),
         UINT32_C(0x3a0318bd),
         UINT32_C(0x38756d35),
         UINT32_C(0x0000b317),
         UINT32_C(0x0276c69f),
         UINT32_C(0xd073b576),
         UINT32_C(0xd205c0fe),
         UINT32_C(0xea70adcb),
         UINT32_C(0xe806d843),
         UINT32_C(0x3a03abaa),
         UINT32_C(0x3875de22)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4006005e),
         UINT32_C(0x00020072),
         UINT32_C(0x4004002c),
         UINT32_C(0x00000114),
         UINT32_C(0x4006014a),
         UINT32_C(0x00020166),
         UINT32_C(0x40040138),
         UINT32_C(0x10200041),
         UINT32_C(0x5026001f),
         UINT32_C(0x10220033),
         UINT32_C(0x5024006d),
         UINT32_C(0x10200155),
         UINT32_C(0x5026010b),
         UINT32_C(0x10220127),
         UINT32_C(0x50240179)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa00300),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa00200),
         UINT32_C(0x3f800000),
         UINT32_C(0x3fa00300),
         UINT32_C(0x3f800100),
         UINT32_C(0x3fa00200),
         UINT32_C(0x3f881000),
         UINT32_C(0x3fa81300),
         UINT32_C(0x3f881100),
         UINT32_C(0x3fa81200),
         UINT32_C(0x3f881000),
         UINT32_C(0x3fa81300),
         UINT32_C(0x3f881100),
         UINT32_C(0x3fa81200)},
        UINT32_C(0xfff80000),
        {0xfb,0x9b,0x0c,0xbf,0x75,0x1e,0xf4,0x4d,0xef,0xcf,
         0x64,0x01,0xe6,0x8d,0x4a,0x9d,0x74,0x82,0xa5,0xda,0x00}
    },
    {
        /* No.494 delta:709 weight:1577 */
        11213,
        61,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xd24d494b),
         UINT32_C(0x90952c70),
         UINT32_C(0x42d8653b),
         UINT32_C(0xf1f01ee5),
         UINT32_C(0x23bd57ae),
         UINT32_C(0x61653295),
         UINT32_C(0xb3287bde),
         UINT32_C(0x00009a06),
         UINT32_C(0xd24dd34d),
         UINT32_C(0x9095b676),
         UINT32_C(0x42d8ff3d),
         UINT32_C(0xf1f084e3),
         UINT32_C(0x23bdcda8),
         UINT32_C(0x6165a893),
         UINT32_C(0xb328e1d8)},
        {UINT32_C(0x00000000),
         UINT32_C(0x701e4a16),
         UINT32_C(0x0044181b),
         UINT32_C(0x705a520d),
         UINT32_C(0x20020581),
         UINT32_C(0x501c4f97),
         UINT32_C(0x20461d9a),
         UINT32_C(0x5058578c),
         UINT32_C(0x0003f013),
         UINT32_C(0x701dba05),
         UINT32_C(0x0047e808),
         UINT32_C(0x7059a21e),
         UINT32_C(0x2001f592),
         UINT32_C(0x501fbf84),
         UINT32_C(0x2045ed89),
         UINT32_C(0x505ba79f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fb80f25),
         UINT32_C(0x3f80220c),
         UINT32_C(0x3fb82d29),
         UINT32_C(0x3f900102),
         UINT32_C(0x3fa80e27),
         UINT32_C(0x3f90230e),
         UINT32_C(0x3fa82c2b),
         UINT32_C(0x3f8001f8),
         UINT32_C(0x3fb80edd),
         UINT32_C(0x3f8023f4),
         UINT32_C(0x3fb82cd1),
         UINT32_C(0x3f9000fa),
         UINT32_C(0x3fa80fdf),
         UINT32_C(0x3f9022f6),
         UINT32_C(0x3fa82dd3)},
        UINT32_C(0xfff80000),
        {0xb7,0xb7,0x54,0x7d,0x9e,0x50,0x47,0x13,0xf5,0x7c,
         0x05,0x29,0xdd,0x89,0x3b,0x34,0xd7,0x53,0x65,0x79,0x00}
    },
    {
        /* No.495 delta:1028 weight:1515 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x2fb43edf),
         UINT32_C(0x2e937a41),
         UINT32_C(0x0127449e),
         UINT32_C(0x2a201efc),
         UINT32_C(0x05942023),
         UINT32_C(0x04b364bd),
         UINT32_C(0x2b075a62),
         UINT32_C(0x0000280c),
         UINT32_C(0x2fb416d3),
         UINT32_C(0x2e93524d),
         UINT32_C(0x01276c92),
         UINT32_C(0x2a2036f0),
         UINT32_C(0x0594082f),
         UINT32_C(0x04b34cb1),
         UINT32_C(0x2b07726e)},
        {UINT32_C(0x00000000),
         UINT32_C(0x001401b6),
         UINT32_C(0x20021c51),
         UINT32_C(0x20161de7),
         UINT32_C(0x204180b2),
         UINT32_C(0x20558104),
         UINT32_C(0x00439ce3),
         UINT32_C(0x00579d55),
         UINT32_C(0x00138018),
         UINT32_C(0x000781ae),
         UINT32_C(0x20119c49),
         UINT32_C(0x20059dff),
         UINT32_C(0x205200aa),
         UINT32_C(0x2046011c),
         UINT32_C(0x00501cfb),
         UINT32_C(0x00441d4d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800a00),
         UINT32_C(0x3f90010e),
         UINT32_C(0x3f900b0e),
         UINT32_C(0x3f9020c0),
         UINT32_C(0x3f902ac0),
         UINT32_C(0x3f8021ce),
         UINT32_C(0x3f802bce),
         UINT32_C(0x3f8009c0),
         UINT32_C(0x3f8003c0),
         UINT32_C(0x3f9008ce),
         UINT32_C(0x3f9002ce),
         UINT32_C(0x3f902900),
         UINT32_C(0x3f902300),
         UINT32_C(0x3f80280e),
         UINT32_C(0x3f80220e)},
        UINT32_C(0xfff80000),
        {0x4a,0x8b,0x2b,0xb5,0xdb,0x72,0x65,0xb0,0x8e,0xe3,
         0x03,0x95,0x6a,0xe2,0x5b,0x6c,0xe7,0xa9,0xbe,0xab,0x00}
    },
    {
        /* No.496 delta:752 weight:939 */
        11213,
        70,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xa4c1cbc4),
         UINT32_C(0x361ad6d9),
         UINT32_C(0x92db1d1d),
         UINT32_C(0xcfa01f0b),
         UINT32_C(0x6b61d4cf),
         UINT32_C(0xf9bac9d2),
         UINT32_C(0x5d7b0216),
         UINT32_C(0x00007250),
         UINT32_C(0xa4c1b994),
         UINT32_C(0x361aa489),
         UINT32_C(0x92db6f4d),
         UINT32_C(0xcfa06d5b),
         UINT32_C(0x6b61a69f),
         UINT32_C(0xf9babb82),
         UINT32_C(0x5d7b7046)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0002515e),
         UINT32_C(0x004b220a),
         UINT32_C(0x00497354),
         UINT32_C(0x400522b9),
         UINT32_C(0x400773e7),
         UINT32_C(0x404e00b3),
         UINT32_C(0x404c51ed),
         UINT32_C(0x30059904),
         UINT32_C(0x3007c85a),
         UINT32_C(0x304ebb0e),
         UINT32_C(0x304cea50),
         UINT32_C(0x7000bbbd),
         UINT32_C(0x7002eae3),
         UINT32_C(0x704b99b7),
         UINT32_C(0x7049c8e9)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800128),
         UINT32_C(0x3f802591),
         UINT32_C(0x3f8024b9),
         UINT32_C(0x3fa00291),
         UINT32_C(0x3fa003b9),
         UINT32_C(0x3fa02700),
         UINT32_C(0x3fa02628),
         UINT32_C(0x3f9802cc),
         UINT32_C(0x3f9803e4),
         UINT32_C(0x3f98275d),
         UINT32_C(0x3f982675),
         UINT32_C(0x3fb8005d),
         UINT32_C(0x3fb80175),
         UINT32_C(0x3fb825cc),
         UINT32_C(0x3fb824e4)},
        UINT32_C(0xfff80000),
        {0xa1,0x8c,0x80,0x23,0xeb,0xa3,0xb8,0x86,0xd7,0xc0,
         0x2b,0xe6,0xf1,0x09,0x7d,0x9c,0xef,0xeb,0xee,0xae,0x00}
    },
    {
        /* No.497 delta:1099 weight:1519 */
        11213,
        33,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x271f9562),
         UINT32_C(0xbbf030da),
         UINT32_C(0x9cefa5b8),
         UINT32_C(0xb7701f10),
         UINT32_C(0x906f8a72),
         UINT32_C(0x0c802fca),
         UINT32_C(0x2b9fbaa8),
         UINT32_C(0x0000198d),
         UINT32_C(0x271f8cef),
         UINT32_C(0xbbf02957),
         UINT32_C(0x9cefbc35),
         UINT32_C(0xb770069d),
         UINT32_C(0x906f93ff),
         UINT32_C(0x0c803647),
         UINT32_C(0x2b9fa325)},
        {UINT32_C(0x00000000),
         UINT32_C(0x800ba41e),
         UINT32_C(0xf010fd4d),
         UINT32_C(0x701b5953),
         UINT32_C(0x0003c6b9),
         UINT32_C(0x800862a7),
         UINT32_C(0xf0133bf4),
         UINT32_C(0x70189fea),
         UINT32_C(0x20081606),
         UINT32_C(0xa003b218),
         UINT32_C(0xd018eb4b),
         UINT32_C(0x50134f55),
         UINT32_C(0x200bd0bf),
         UINT32_C(0xa00074a1),
         UINT32_C(0xd01b2df2),
         UINT32_C(0x501089ec)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fc005d2),
         UINT32_C(0x3ff8087e),
         UINT32_C(0x3fb80dac),
         UINT32_C(0x3f8001e3),
         UINT32_C(0x3fc00431),
         UINT32_C(0x3ff8099d),
         UINT32_C(0x3fb80c4f),
         UINT32_C(0x3f90040b),
         UINT32_C(0x3fd001d9),
         UINT32_C(0x3fe80c75),
         UINT32_C(0x3fa809a7),
         UINT32_C(0x3f9005e8),
         UINT32_C(0x3fd0003a),
         UINT32_C(0x3fe80d96),
         UINT32_C(0x3fa80844)},
        UINT32_C(0xfff80000),
        {0x27,0xc2,0x53,0x1a,0x1b,0xd5,0xc1,0x6f,0xd2,0xbb,
         0xb2,0xc3,0x27,0xd1,0xb9,0x8f,0xcd,0x32,0x22,0x81,0x00}
    },
    {
        /* No.498 delta:1303 weight:1655 */
        11213,
        22,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1733fa30),
         UINT32_C(0xe70844d6),
         UINT32_C(0xf03bbee6),
         UINT32_C(0x35701f23),
         UINT32_C(0x2243e513),
         UINT32_C(0xd2785bf5),
         UINT32_C(0xc54ba1c5),
         UINT32_C(0x00005582),
         UINT32_C(0x1733afb2),
         UINT32_C(0xe7081154),
         UINT32_C(0xf03beb64),
         UINT32_C(0x35704aa1),
         UINT32_C(0x2243b091),
         UINT32_C(0xd2780e77),
         UINT32_C(0xc54bf447)},
        {UINT32_C(0x00000000),
         UINT32_C(0x184428f6),
         UINT32_C(0x007b940e),
         UINT32_C(0x183fbcf8),
         UINT32_C(0x0006500d),
         UINT32_C(0x184278fb),
         UINT32_C(0x007dc403),
         UINT32_C(0x1839ecf5),
         UINT32_C(0x30085014),
         UINT32_C(0x284c78e2),
         UINT32_C(0x3073c41a),
         UINT32_C(0x2837ecec),
         UINT32_C(0x300e0019),
         UINT32_C(0x284a28ef),
         UINT32_C(0x30759417),
         UINT32_C(0x2831bce1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8c2214),
         UINT32_C(0x3f803dca),
         UINT32_C(0x3f8c1fde),
         UINT32_C(0x3f800328),
         UINT32_C(0x3f8c213c),
         UINT32_C(0x3f803ee2),
         UINT32_C(0x3f8c1cf6),
         UINT32_C(0x3f980428),
         UINT32_C(0x3f94263c),
         UINT32_C(0x3f9839e2),
         UINT32_C(0x3f941bf6),
         UINT32_C(0x3f980700),
         UINT32_C(0x3f942514),
         UINT32_C(0x3f983aca),
         UINT32_C(0x3f9418de)},
        UINT32_C(0xfff80000),
        {0x03,0x29,0x0f,0x56,0xb2,0x78,0x76,0x1a,0x98,0x00,
         0x16,0xe4,0x87,0x2b,0xd0,0xea,0x7e,0x3d,0x1a,0x34,0x00}
    },
    {
        /* No.499 delta:975 weight:939 */
        11213,
        89,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x31621f00),
         UINT32_C(0x006813a0),
         UINT32_C(0x310a0ca0),
         UINT32_C(0xed401f38),
         UINT32_C(0xdc220038),
         UINT32_C(0xed280c98),
         UINT32_C(0xdc4a1398),
         UINT32_C(0x00004b3d),
         UINT32_C(0x3162543d),
         UINT32_C(0x0068589d),
         UINT32_C(0x310a479d),
         UINT32_C(0xed405405),
         UINT32_C(0xdc224b05),
         UINT32_C(0xed2847a5),
         UINT32_C(0xdc4a58a5)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2d009196),
         UINT32_C(0x00984bdf),
         UINT32_C(0x2d98da49),
         UINT32_C(0x080ea1d9),
         UINT32_C(0x250e304f),
         UINT32_C(0x0896ea06),
         UINT32_C(0x25967b90),
         UINT32_C(0x2074060a),
         UINT32_C(0x0d74979c),
         UINT32_C(0x20ec4dd5),
         UINT32_C(0x0decdc43),
         UINT32_C(0x287aa7d3),
         UINT32_C(0x057a3645),
         UINT32_C(0x28e2ec0c),
         UINT32_C(0x05e27d9a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f968048),
         UINT32_C(0x3f804c25),
         UINT32_C(0x3f96cc6d),
         UINT32_C(0x3f840750),
         UINT32_C(0x3f928718),
         UINT32_C(0x3f844b75),
         UINT32_C(0x3f92cb3d),
         UINT32_C(0x3f903a03),
         UINT32_C(0x3f86ba4b),
         UINT32_C(0x3f907626),
         UINT32_C(0x3f86f66e),
         UINT32_C(0x3f943d53),
         UINT32_C(0x3f82bd1b),
         UINT32_C(0x3f947176),
         UINT32_C(0x3f82f13e)},
        UINT32_C(0xfff80000),
        {0x62,0x1f,0x93,0x6c,0xc5,0x17,0x97,0x43,0x43,0x22,
         0x46,0x0f,0xe9,0x69,0xff,0x1c,0x86,0xe4,0xca,0x55,0x00}
    },
    {
        /* No.500 delta:842 weight:1647 */
        11213,
        42,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xdefa9e3b),
         UINT32_C(0xb4c11010),
         UINT32_C(0x6a3b8e2b),
         UINT32_C(0xe5a01f43),
         UINT32_C(0x3b5a8178),
         UINT32_C(0x51610f53),
         UINT32_C(0x8f9b9168),
         UINT32_C(0x0000857c),
         UINT32_C(0xdefa1b47),
         UINT32_C(0xb4c1956c),
         UINT32_C(0x6a3b0b57),
         UINT32_C(0xe5a09a3f),
         UINT32_C(0x3b5a0404),
         UINT32_C(0x51618a2f),
         UINT32_C(0x8f9b1414)},
        {UINT32_C(0x00000000),
         UINT32_C(0x29800f9a),
         UINT32_C(0x80038465),
         UINT32_C(0xa9838bff),
         UINT32_C(0x4040381c),
         UINT32_C(0x69c03786),
         UINT32_C(0xc043bc79),
         UINT32_C(0xe9c3b3e3),
         UINT32_C(0x40000411),
         UINT32_C(0x69800b8b),
         UINT32_C(0xc0038074),
         UINT32_C(0xe9838fee),
         UINT32_C(0x00403c0d),
         UINT32_C(0x29c03397),
         UINT32_C(0x8043b868),
         UINT32_C(0xa9c3b7f2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f94c007),
         UINT32_C(0x3fc001c2),
         UINT32_C(0x3fd4c1c5),
         UINT32_C(0x3fa0201c),
         UINT32_C(0x3fb4e01b),
         UINT32_C(0x3fe021de),
         UINT32_C(0x3ff4e1d9),
         UINT32_C(0x3fa00002),
         UINT32_C(0x3fb4c005),
         UINT32_C(0x3fe001c0),
         UINT32_C(0x3ff4c1c7),
         UINT32_C(0x3f80201e),
         UINT32_C(0x3f94e019),
         UINT32_C(0x3fc021dc),
         UINT32_C(0x3fd4e1db)},
        UINT32_C(0xfff80000),
        {0x37,0x79,0xef,0x11,0xfa,0xbb,0xd1,0x60,0x6a,0x27,
         0x2d,0x86,0x86,0xe6,0xc0,0x06,0x38,0x2a,0x2f,0xd9,0x00}
    },
    {
        /* No.501 delta:1691 weight:1569 */
        11213,
        13,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x1d0833ab),
         UINT32_C(0x1a2e9cbe),
         UINT32_C(0x0726af15),
         UINT32_C(0xed401f5d),
         UINT32_C(0xf0482cf6),
         UINT32_C(0xf76e83e3),
         UINT32_C(0xea66b048),
         UINT32_C(0x00000923),
         UINT32_C(0x1d083a88),
         UINT32_C(0x1a2e959d),
         UINT32_C(0x0726a636),
         UINT32_C(0xed40167e),
         UINT32_C(0xf04825d5),
         UINT32_C(0xf76e8ac0),
         UINT32_C(0xea66b96b)},
        {UINT32_C(0x00000000),
         UINT32_C(0x0b4a0674),
         UINT32_C(0x172a7607),
         UINT32_C(0x1c607073),
         UINT32_C(0x120c01cb),
         UINT32_C(0x194607bf),
         UINT32_C(0x052677cc),
         UINT32_C(0x0e6c71b8),
         UINT32_C(0x01089009),
         UINT32_C(0x0a42967d),
         UINT32_C(0x1622e60e),
         UINT32_C(0x1d68e07a),
         UINT32_C(0x130491c2),
         UINT32_C(0x184e97b6),
         UINT32_C(0x042ee7c5),
         UINT32_C(0x0f64e1b1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f85a503),
         UINT32_C(0x3f8b953b),
         UINT32_C(0x3f8e3038),
         UINT32_C(0x3f890600),
         UINT32_C(0x3f8ca303),
         UINT32_C(0x3f82933b),
         UINT32_C(0x3f873638),
         UINT32_C(0x3f808448),
         UINT32_C(0x3f85214b),
         UINT32_C(0x3f8b1173),
         UINT32_C(0x3f8eb470),
         UINT32_C(0x3f898248),
         UINT32_C(0x3f8c274b),
         UINT32_C(0x3f821773),
         UINT32_C(0x3f87b270)},
        UINT32_C(0xfff80000),
        {0x84,0xae,0x26,0x5d,0x95,0x7a,0xf4,0x77,0x7d,0x0d,
         0xaa,0x7b,0x7d,0x47,0xc2,0xf8,0xbe,0x0a,0x1b,0x73,0x00}
    },
    {
        /* No.502 delta:738 weight:1295 */
        11213,
        60,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x94c874ca),
         UINT32_C(0x9fe20cc4),
         UINT32_C(0x0b2a780e),
         UINT32_C(0xa5b01f6e),
         UINT32_C(0x31786ba4),
         UINT32_C(0x3a5213aa),
         UINT32_C(0xae9a6760),
         UINT32_C(0x0000862d),
         UINT32_C(0x94c8f2e7),
         UINT32_C(0x9fe28ae9),
         UINT32_C(0x0b2afe23),
         UINT32_C(0xa5b09943),
         UINT32_C(0x3178ed89),
         UINT32_C(0x3a529587),
         UINT32_C(0xae9ae14d)},
        {UINT32_C(0x00000000),
         UINT32_C(0xb0524a12),
         UINT32_C(0x420c81f1),
         UINT32_C(0xf25ecbe3),
         UINT32_C(0x00201169),
         UINT32_C(0xb0725b7b),
         UINT32_C(0x422c9098),
         UINT32_C(0xf27eda8a),
         UINT32_C(0x0049718c),
         UINT32_C(0xb01b3b9e),
         UINT32_C(0x4245f07d),
         UINT32_C(0xf217ba6f),
         UINT32_C(0x006960e5),
         UINT32_C(0xb03b2af7),
         UINT32_C(0x4265e114),
         UINT32_C(0xf237ab06)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fd82925),
         UINT32_C(0x3fa10640),
         UINT32_C(0x3ff92f65),
         UINT32_C(0x3f801008),
         UINT32_C(0x3fd8392d),
         UINT32_C(0x3fa11648),
         UINT32_C(0x3ff93f6d),
         UINT32_C(0x3f8024b8),
         UINT32_C(0x3fd80d9d),
         UINT32_C(0x3fa122f8),
         UINT32_C(0x3ff90bdd),
         UINT32_C(0x3f8034b0),
         UINT32_C(0x3fd81d95),
         UINT32_C(0x3fa132f0),
         UINT32_C(0x3ff91bd5)},
        UINT32_C(0xfff80000),
        {0xf4,0xff,0x04,0x85,0x9a,0x6f,0x4a,0x9a,0x26,0x75,
         0xb2,0x6c,0xd6,0x26,0x47,0xc0,0x62,0x9b,0xe7,0x2e,0x00}
    },
    {
        /* No.503 delta:2181 weight:1281 */
        11213,
        8,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x259c0784),
         UINT32_C(0xe28c721e),
         UINT32_C(0xc710759a),
         UINT32_C(0x25401f7f),
         UINT32_C(0x00dc18fb),
         UINT32_C(0xc7cc6d61),
         UINT32_C(0xe2506ae5),
         UINT32_C(0x00004b77),
         UINT32_C(0x259c4cf3),
         UINT32_C(0xe28c3969),
         UINT32_C(0xc7103eed),
         UINT32_C(0x25405408),
         UINT32_C(0x00dc538c),
         UINT32_C(0xc7cc2616),
         UINT32_C(0xe2502192)},
        {UINT32_C(0x00000000),
         UINT32_C(0x090deb3e),
         UINT32_C(0x87b08223),
         UINT32_C(0x8ebd691d),
         UINT32_C(0x210a9879),
         UINT32_C(0x28077347),
         UINT32_C(0xa6ba1a5a),
         UINT32_C(0xafb7f164),
         UINT32_C(0x40316418),
         UINT32_C(0x493c8f26),
         UINT32_C(0xc781e63b),
         UINT32_C(0xce8c0d05),
         UINT32_C(0x613bfc61),
         UINT32_C(0x6836175f),
         UINT32_C(0xe68b7e42),
         UINT32_C(0xef86957c)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f8486f5),
         UINT32_C(0x3fc3d841),
         UINT32_C(0x3fc75eb4),
         UINT32_C(0x3f90854c),
         UINT32_C(0x3f9403b9),
         UINT32_C(0x3fd35d0d),
         UINT32_C(0x3fd7dbf8),
         UINT32_C(0x3fa018b2),
         UINT32_C(0x3fa49e47),
         UINT32_C(0x3fe3c0f3),
         UINT32_C(0x3fe74606),
         UINT32_C(0x3fb09dfe),
         UINT32_C(0x3fb41b0b),
         UINT32_C(0x3ff345bf),
         UINT32_C(0x3ff7c34a)},
        UINT32_C(0xfff80000),
        {0xc7,0xf7,0x07,0xf3,0x63,0x0c,0x7c,0x71,0xf2,0x55,
         0x74,0x61,0xbf,0x57,0xb6,0xdf,0x32,0x37,0x21,0x96,0x00}
    },
    {
        /* No.504 delta:766 weight:1267 */
        11213,
        72,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x9f43d775),
         UINT32_C(0x7b36ec44),
         UINT32_C(0xe4753b31),
         UINT32_C(0x74d01f8c),
         UINT32_C(0xeb93c8f9),
         UINT32_C(0x0fe6f3c8),
         UINT32_C(0x90a524bd),
         UINT32_C(0x00005f7d),
         UINT32_C(0x9f438808),
         UINT32_C(0x7b36b339),
         UINT32_C(0xe475644c),
         UINT32_C(0x74d040f1),
         UINT32_C(0xeb939784),
         UINT32_C(0x0fe6acb5),
         UINT32_C(0x90a57bc0)},
        {UINT32_C(0x00000000),
         UINT32_C(0x2060b0f7),
         UINT32_C(0x10022a24),
         UINT32_C(0x30629ad3),
         UINT32_C(0x014d20fb),
         UINT32_C(0x212d900c),
         UINT32_C(0x114f0adf),
         UINT32_C(0x312fba28),
         UINT32_C(0x00648019),
         UINT32_C(0x200430ee),
         UINT32_C(0x1066aa3d),
         UINT32_C(0x30061aca),
         UINT32_C(0x0129a0e2),
         UINT32_C(0x21491015),
         UINT32_C(0x112b8ac6),
         UINT32_C(0x314b3a31)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f903058),
         UINT32_C(0x3f880115),
         UINT32_C(0x3f98314d),
         UINT32_C(0x3f80a690),
         UINT32_C(0x3f9096c8),
         UINT32_C(0x3f88a785),
         UINT32_C(0x3f9897dd),
         UINT32_C(0x3f803240),
         UINT32_C(0x3f900218),
         UINT32_C(0x3f883355),
         UINT32_C(0x3f98030d),
         UINT32_C(0x3f8094d0),
         UINT32_C(0x3f90a488),
         UINT32_C(0x3f8895c5),
         UINT32_C(0x3f98a59d)},
        UINT32_C(0xfff80000),
        {0x06,0x85,0x1b,0xdf,0x27,0xea,0x66,0x92,0x13,0x05,
         0x26,0x34,0xeb,0x54,0x5d,0x3e,0xfb,0xbb,0xf7,0x9b,0x00}
    },
    {
        /* No.505 delta:979 weight:1611 */
        11213,
        43,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x55df1c42),
         UINT32_C(0x8ec3866e),
         UINT32_C(0xdb1c9a2c),
         UINT32_C(0x1b901f95),
         UINT32_C(0x4e4f03d7),
         UINT32_C(0x955399fb),
         UINT32_C(0xc08c85b9),
         UINT32_C(0x00009220),
         UINT32_C(0x55df8e62),
         UINT32_C(0x8ec3144e),
         UINT32_C(0xdb1c080c),
         UINT32_C(0x1b908db5),
         UINT32_C(0x4e4f91f7),
         UINT32_C(0x95530bdb),
         UINT32_C(0xc08c1799)},
        {UINT32_C(0x00000000),
         UINT32_C(0x380c955a),
         UINT32_C(0x020248b3),
         UINT32_C(0x3a0edde9),
         UINT32_C(0x20025374),
         UINT32_C(0x180ec62e),
         UINT32_C(0x22001bc7),
         UINT32_C(0x1a0c8e9d),
         UINT32_C(0x0003d32f),
         UINT32_C(0x380f4675),
         UINT32_C(0x02019b9c),
         UINT32_C(0x3a0d0ec6),
         UINT32_C(0x2001805b),
         UINT32_C(0x180d1501),
         UINT32_C(0x2203c8e8),
         UINT32_C(0x1a0f5db2)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9c064a),
         UINT32_C(0x3f810124),
         UINT32_C(0x3f9d076e),
         UINT32_C(0x3f900129),
         UINT32_C(0x3f8c0763),
         UINT32_C(0x3f91000d),
         UINT32_C(0x3f8d0647),
         UINT32_C(0x3f8001e9),
         UINT32_C(0x3f9c07a3),
         UINT32_C(0x3f8100cd),
         UINT32_C(0x3f9d0687),
         UINT32_C(0x3f9000c0),
         UINT32_C(0x3f8c068a),
         UINT32_C(0x3f9101e4),
         UINT32_C(0x3f8d07ae)},
        UINT32_C(0xfff80000),
        {0x23,0x3c,0x47,0x37,0x48,0xb7,0x8d,0x06,0xe7,0xe9,
         0x33,0x18,0xc6,0xd8,0xf4,0x2b,0x78,0x66,0x85,0xa7,0x00}
    },
    {
        /* No.506 delta:855 weight:1625 */
        11213,
        83,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x170efc48),
         UINT32_C(0x3770a1e3),
         UINT32_C(0x207e5dab),
         UINT32_C(0x24701fa9),
         UINT32_C(0x337ee3e1),
         UINT32_C(0x1300be4a),
         UINT32_C(0x040e4202),
         UINT32_C(0x00002a96),
         UINT32_C(0x170ed6de),
         UINT32_C(0x37708b75),
         UINT32_C(0x207e773d),
         UINT32_C(0x2470353f),
         UINT32_C(0x337ec977),
         UINT32_C(0x130094dc),
         UINT32_C(0x040e6894)},
        {UINT32_C(0x00000000),
         UINT32_C(0x00060af6),
         UINT32_C(0x0482020d),
         UINT32_C(0x048408fb),
         UINT32_C(0x0002d201),
         UINT32_C(0x0004d8f7),
         UINT32_C(0x0480d00c),
         UINT32_C(0x0486dafa),
         UINT32_C(0x10409885),
         UINT32_C(0x10469273),
         UINT32_C(0x14c29a88),
         UINT32_C(0x14c4907e),
         UINT32_C(0x10424a84),
         UINT32_C(0x10444072),
         UINT32_C(0x14c04889),
         UINT32_C(0x14c6427f)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f800305),
         UINT32_C(0x3f824101),
         UINT32_C(0x3f824204),
         UINT32_C(0x3f800169),
         UINT32_C(0x3f80026c),
         UINT32_C(0x3f824068),
         UINT32_C(0x3f82436d),
         UINT32_C(0x3f88204c),
         UINT32_C(0x3f882349),
         UINT32_C(0x3f8a614d),
         UINT32_C(0x3f8a6248),
         UINT32_C(0x3f882125),
         UINT32_C(0x3f882220),
         UINT32_C(0x3f8a6024),
         UINT32_C(0x3f8a6321)},
        UINT32_C(0xfff80000),
        {0x64,0x5b,0x4e,0x08,0x23,0x49,0x7e,0x85,0x00,0x16,
         0x27,0x0a,0x54,0x38,0xfc,0x4a,0x36,0xe2,0xe3,0xbe,0x00}
    },
    {
        /* No.507 delta:1930 weight:1461 */
        11213,
        10,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3a0ab12a),
         UINT32_C(0x860dc6e0),
         UINT32_C(0xbc0777ca),
         UINT32_C(0xa5001fbe),
         UINT32_C(0x9f0aae94),
         UINT32_C(0x230dd95e),
         UINT32_C(0x19076874),
         UINT32_C(0x0000b52e),
         UINT32_C(0x3a0a0404),
         UINT32_C(0x860d73ce),
         UINT32_C(0xbc07c2e4),
         UINT32_C(0xa500aa90),
         UINT32_C(0x9f0a1bba),
         UINT32_C(0x230d6c70),
         UINT32_C(0x1907dd5a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x34803133),
         UINT32_C(0x0840201a),
         UINT32_C(0x3cc01129),
         UINT32_C(0x400180a8),
         UINT32_C(0x7481b19b),
         UINT32_C(0x4841a0b2),
         UINT32_C(0x7cc19181),
         UINT32_C(0x228c2dac),
         UINT32_C(0x160c1c9f),
         UINT32_C(0x2acc0db6),
         UINT32_C(0x1e4c3c85),
         UINT32_C(0x628dad04),
         UINT32_C(0x560d9c37),
         UINT32_C(0x6acd8d1e),
         UINT32_C(0x5e4dbc2d)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9a4018),
         UINT32_C(0x3f842010),
         UINT32_C(0x3f9e6008),
         UINT32_C(0x3fa000c0),
         UINT32_C(0x3fba40d8),
         UINT32_C(0x3fa420d0),
         UINT32_C(0x3fbe60c8),
         UINT32_C(0x3f914616),
         UINT32_C(0x3f8b060e),
         UINT32_C(0x3f956606),
         UINT32_C(0x3f8f261e),
         UINT32_C(0x3fb146d6),
         UINT32_C(0x3fab06ce),
         UINT32_C(0x3fb566c6),
         UINT32_C(0x3faf26de)},
        UINT32_C(0xfff80000),
        {0xca,0x23,0xf1,0x6b,0x02,0x95,0x73,0x85,0xc6,0xbc,
         0xb6,0xc0,0xb7,0xc8,0xe9,0xab,0x24,0xe5,0x9c,0xbc,0x00}
    },
    {
        /* No.508 delta:1148 weight:1473 */
        11213,
        35,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x3e476448),
         UINT32_C(0x2d19b410),
         UINT32_C(0x135ed058),
         UINT32_C(0x77701fc7),
         UINT32_C(0x49377b8f),
         UINT32_C(0x5a69abd7),
         UINT32_C(0x642ecf9f),
         UINT32_C(0x000014ac),
         UINT32_C(0x3e4770e4),
         UINT32_C(0x2d19a0bc),
         UINT32_C(0x135ec4f4),
         UINT32_C(0x77700b6b),
         UINT32_C(0x49376f23),
         UINT32_C(0x5a69bf7b),
         UINT32_C(0x642edb33)},
        {UINT32_C(0x00000000),
         UINT32_C(0x054cc11e),
         UINT32_C(0x003a7ab1),
         UINT32_C(0x0576bbaf),
         UINT32_C(0x00dc8b87),
         UINT32_C(0x05904a99),
         UINT32_C(0x00e6f136),
         UINT32_C(0x05aa3028),
         UINT32_C(0x00034012),
         UINT32_C(0x054f810c),
         UINT32_C(0x00393aa3),
         UINT32_C(0x0575fbbd),
         UINT32_C(0x00dfcb95),
         UINT32_C(0x05930a8b),
         UINT32_C(0x00e5b124),
         UINT32_C(0x05a9703a)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f82a660),
         UINT32_C(0x3f801d3d),
         UINT32_C(0x3f82bb5d),
         UINT32_C(0x3f806e45),
         UINT32_C(0x3f82c825),
         UINT32_C(0x3f807378),
         UINT32_C(0x3f82d518),
         UINT32_C(0x3f8001a0),
         UINT32_C(0x3f82a7c0),
         UINT32_C(0x3f801c9d),
         UINT32_C(0x3f82bafd),
         UINT32_C(0x3f806fe5),
         UINT32_C(0x3f82c985),
         UINT32_C(0x3f8072d8),
         UINT32_C(0x3f82d4b8)},
        UINT32_C(0xfff80000),
        {0x2e,0xa7,0xb8,0x82,0x69,0xd0,0xd3,0x6f,0x5a,0x01,
         0xd6,0x28,0xdc,0x82,0xed,0x83,0xc8,0x07,0x5a,0x0b,0x00}
    },
    {
        /* No.509 delta:925 weight:1687 */
        11213,
        56,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x7b4a4f00),
         UINT32_C(0xbacb592f),
         UINT32_C(0xc181162f),
         UINT32_C(0x9ca01fd3),
         UINT32_C(0xe7ea50d3),
         UINT32_C(0x266b46fc),
         UINT32_C(0x5d2109fc),
         UINT32_C(0x00000c91),
         UINT32_C(0x7b4a4391),
         UINT32_C(0xbacb55be),
         UINT32_C(0xc1811abe),
         UINT32_C(0x9ca01342),
         UINT32_C(0xe7ea5c42),
         UINT32_C(0x266b4a6d),
         UINT32_C(0x5d21056d)},
        {UINT32_C(0x00000000),
         UINT32_C(0x4003bc12),
         UINT32_C(0x80244a47),
         UINT32_C(0xc027f655),
         UINT32_C(0x0000580a),
         UINT32_C(0x4003e418),
         UINT32_C(0x8024124d),
         UINT32_C(0xc027ae5f),
         UINT32_C(0x4000058e),
         UINT32_C(0x0003b99c),
         UINT32_C(0xc0244fc9),
         UINT32_C(0x8027f3db),
         UINT32_C(0x40005d84),
         UINT32_C(0x0003e196),
         UINT32_C(0xc02417c3),
         UINT32_C(0x8027abd1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3fa001de),
         UINT32_C(0x3fc01225),
         UINT32_C(0x3fe013fb),
         UINT32_C(0x3f80002c),
         UINT32_C(0x3fa001f2),
         UINT32_C(0x3fc01209),
         UINT32_C(0x3fe013d7),
         UINT32_C(0x3fa00002),
         UINT32_C(0x3f8001dc),
         UINT32_C(0x3fe01227),
         UINT32_C(0x3fc013f9),
         UINT32_C(0x3fa0002e),
         UINT32_C(0x3f8001f0),
         UINT32_C(0x3fe0120b),
         UINT32_C(0x3fc013d5)},
        UINT32_C(0xfff80000),
        {0xce,0x41,0xdf,0xa3,0xed,0x34,0x9e,0x0d,0xcd,0xe8,
         0x7a,0xaa,0x8c,0xf2,0x32,0xd8,0xa7,0x47,0x5f,0xdc,0x00}
    },
    {
        /* No.510 delta:871 weight:1739 */
        11213,
        49,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0xe9b1101c),
         UINT32_C(0xaa673461),
         UINT32_C(0x43d6247d),
         UINT32_C(0x2c101fe6),
         UINT32_C(0xc5a10ffa),
         UINT32_C(0x86772b87),
         UINT32_C(0x6fc63b9b),
         UINT32_C(0x0000fe72),
         UINT32_C(0xe9b1ee6e),
         UINT32_C(0xaa67ca13),
         UINT32_C(0x43d6da0f),
         UINT32_C(0x2c10e194),
         UINT32_C(0xc5a1f188),
         UINT32_C(0x8677d5f5),
         UINT32_C(0x6fc6c5e9)},
        {UINT32_C(0x00000000),
         UINT32_C(0x20256a3e),
         UINT32_C(0x20000c51),
         UINT32_C(0x0025666f),
         UINT32_C(0x200230f6),
         UINT32_C(0x00275ac8),
         UINT32_C(0x00023ca7),
         UINT32_C(0x20275699),
         UINT32_C(0x1000215a),
         UINT32_C(0x30254b64),
         UINT32_C(0x30002d0b),
         UINT32_C(0x10254735),
         UINT32_C(0x300211ac),
         UINT32_C(0x10277b92),
         UINT32_C(0x10021dfd),
         UINT32_C(0x302777c3)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9012b5),
         UINT32_C(0x3f900006),
         UINT32_C(0x3f8012b3),
         UINT32_C(0x3f900118),
         UINT32_C(0x3f8013ad),
         UINT32_C(0x3f80011e),
         UINT32_C(0x3f9013ab),
         UINT32_C(0x3f880010),
         UINT32_C(0x3f9812a5),
         UINT32_C(0x3f980016),
         UINT32_C(0x3f8812a3),
         UINT32_C(0x3f980108),
         UINT32_C(0x3f8813bd),
         UINT32_C(0x3f88010e),
         UINT32_C(0x3f9813bb)},
        UINT32_C(0xfff80000),
        {0xc6,0x00,0x8d,0x5d,0x6f,0xe5,0x56,0x01,0xd3,0xc9,
         0xee,0xa0,0x9d,0xf4,0xa3,0x87,0x70,0xf3,0x36,0x88,0x00}
    },
    {
        /* No.511 delta:824 weight:741 */
        11213,
        88,
        13,
        4,
        {UINT32_C(0x00000000),
         UINT32_C(0x26a409c0),
         UINT32_C(0xbfab6fe5),
         UINT32_C(0x990f6625),
         UINT32_C(0xc0801ffd),
         UINT32_C(0xe624163d),
         UINT32_C(0x7f2b7018),
         UINT32_C(0x598f79d8),
         UINT32_C(0x000072a2),
         UINT32_C(0x26a47b62),
         UINT32_C(0xbfab1d47),
         UINT32_C(0x990f1487),
         UINT32_C(0xc0806d5f),
         UINT32_C(0xe624649f),
         UINT32_C(0x7f2b02ba),
         UINT32_C(0x598f0b7a)},
        {UINT32_C(0x00000000),
         UINT32_C(0x38c204d7),
         UINT32_C(0x204b8134),
         UINT32_C(0x188985e3),
         UINT32_C(0x0270160f),
         UINT32_C(0x3ab212d8),
         UINT32_C(0x223b973b),
         UINT32_C(0x1af993ec),
         UINT32_C(0x004a021d),
         UINT32_C(0x388806ca),
         UINT32_C(0x20018329),
         UINT32_C(0x18c387fe),
         UINT32_C(0x023a1412),
         UINT32_C(0x3af810c5),
         UINT32_C(0x22719526),
         UINT32_C(0x1ab391f1)},
        {UINT32_C(0x3f800000),
         UINT32_C(0x3f9c6102),
         UINT32_C(0x3f9025c0),
         UINT32_C(0x3f8c44c2),
         UINT32_C(0x3f81380b),
         UINT32_C(0x3f9d5909),
         UINT32_C(0x3f911dcb),
         UINT32_C(0x3f8d7cc9),
         UINT32_C(0x3f802501),
         UINT32_C(0x3f9c4403),
         UINT32_C(0x3f9000c1),
         UINT32_C(0x3f8c61c3),
         UINT32_C(0x3f811d0a),
         UINT32_C(0x3f9d7c08),
         UINT32_C(0x3f9138ca),
         UINT32_C(0x3f8d59c8)},
        UINT32_C(0xfff80000),
        {0xdb,0xf1,0x57,0xcc,0xf3,0xd1,0xab,0x93,0xd9,0xfd,
         0xd6,0xc0,0x7b,0x7e,0x6c,0x10,0x59,0x56,0x7c,0x00,0x00}
    }
};

#define mtgpdc_params_11213_num 512

#endif // ROCRAND_MTGP32_11213_H_
