% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords-translate.R
\name{coords_point_translate_wkt}
\alias{coords_point_translate_wkt}
\alias{coords_point_translate_wkb}
\alias{coords_linestring_translate_wkt}
\alias{coords_linestring_translate_wkb}
\alias{coords_polygon_translate_wkt}
\alias{coords_polygon_translate_wkb}
\title{Parse coordinates into well-known formats}
\usage{
coords_point_translate_wkt(x, y, z = NA, m = NA, precision = 16, trim = TRUE)

coords_point_translate_wkb(
  x,
  y,
  z = NA,
  m = NA,
  endian = wk::wk_platform_endian(),
  buffer_size = 2048
)

coords_linestring_translate_wkt(
  x,
  y,
  z = NA,
  m = NA,
  feature_id = 1L,
  precision = 16,
  trim = TRUE
)

coords_linestring_translate_wkb(
  x,
  y,
  z = NA,
  m = NA,
  feature_id = 1L,
  endian = wk::wk_platform_endian(),
  buffer_size = 2048
)

coords_polygon_translate_wkt(
  x,
  y,
  z = NA,
  m = NA,
  feature_id = 1L,
  ring_id = 1L,
  precision = 16,
  trim = TRUE
)

coords_polygon_translate_wkb(
  x,
  y,
  z = NA,
  m = NA,
  feature_id = 1L,
  ring_id = 1L,
  endian = wk::wk_platform_endian(),
  buffer_size = 2048
)
}
\arguments{
\item{x, y, z, m}{Vectors of coordinate values}

\item{precision}{The rounding precision to use when writing
(number of decimal places).}

\item{trim}{Trim unnecessary zeroes in the output?}

\item{endian}{Force the endian of the resulting WKB.}

\item{buffer_size}{The buffer size to use when converting to WKB.}

\item{feature_id, ring_id}{Vectors for which a change in
sequential values indicates a new feature or ring. Use \code{\link[=factor]{factor()}}
to convert from a character vector.}
}
\value{
\verb{*_translate_wkt()} returns a character vector of
well-known text; \verb{*_translate_wkb()} returns a list
of raw vectors.
}
\description{
These functions provide the reverse function of \code{\link[=wkt_coords]{wkt_coords()}}
and company: they parse vectors of coordinate values into well-known
formats. Polygon rings are automatically closed, as
closed rings are assumed or required by many parsers.
}
\examples{
coords_point_translate_wkt(1:3, 2:4)
coords_linestring_translate_wkt(1:5, 2:6, feature_id = c(1, 1, 1, 2, 2))
coords_polygon_translate_wkt(c(0, 10, 0), c(0, 0, 10))

}
