% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WDI.R
\name{WDI}
\alias{WDI}
\title{WDI: World Development Indicators (World Bank)}
\usage{
WDI(country = "all", indicator = "NY.GNS.ICTR.GN.ZS", start = NULL,
  end = NULL, extra = FALSE, cache = NULL)
}
\arguments{
\item{country}{Vector of countries (ISO-2 character codes, e.g. "BR", "US",
"CA") for which the data is needed. Using the string "all" instead of
individual iso codes pulls data for every available country.}

\item{indicator}{Character vector of indicators codes. See the WDIsearch()
function. If you supply a named vector, the indicators will be automatically
renamed: `c('women_private_sector' = 'BI.PWK.PRVS.FE.ZS')`}

\item{start}{First year of data. If NULL, the start year is set to 1950.}

\item{end}{Last year of data. If NULL, the end year is set to the current year.}

\item{extra}{TRUE returns extra variables such as region, iso3c code, and
incomeLevel}

\item{cache}{NULL (optional) a list created by WDIcache() to be used with the
extra=TRUE argument}
}
\value{
Data frame with country-year observations. You can extract a
data.frame with indicator names and descriptive labels by inspecting the
`label` attribute of the resulting data.frame: `attr(dat, 'label')`
}
\description{
Downloads the requested data by using the World Bank's API, parses the
resulting XML file, and formats it in long country-year format.
}
\examples{

WDI(country="all", indicator=c("AG.AGR.TRAC.NO","TM.TAX.TCOM.BC.ZS"),
    start=1990, end=2000)
WDI(country=c("US","BR"), indicator="NY.GNS.ICTR.GN.ZS", start=1999, end=2000,
    extra=TRUE, cache=NULL)

# Rename indicators on the fly
WDI(country = 'CA', indicator = c('women_private_sector' = 'BI.PWK.PRVS.FE.ZS',
                                  'women_public_sector' = 'BI.PWK.PUBS.FE.ZS'))
}
\author{
Vincent Arel-Bundock \email{vincent.arel-bundock@umontreal.ca}
}
