% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{unwhich}
\alias{unwhich}
\title{Construct a logical vector with \code{TRUE} in specified positions.}
\usage{
unwhich(which, n)
}
\arguments{
\item{which}{a numeric vector of indices to set to \code{TRUE}.}

\item{n}{total length of the output vector.}
}
\value{
A logical vector of length \code{n} whose elements listed in
\code{which} are set to \code{TRUE}, and whose other elements are set to
\code{FALSE}.
}
\description{
This function is basically an inverse of \code{\link{which}}.
}
\examples{

x <- as.logical(rbinom(10,1,0.5))
stopifnot(all(x == unwhich(which(x), 10)))
}
