% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtools-versions.R
\name{rtools_versions}
\alias{rtools_versions}
\title{List Rtools versions}
\usage{
rtools_versions(arch = NULL)
}
\arguments{
\item{arch}{Architecture. Possible values are:
\itemize{
\item \code{x86_64}: x86_64 Windows,
\item \code{aarch64} or \code{arm64}: aarch64 Windows.
Defaults tp the current architecture on Windows, and to \code{x86_64} on
other systems.
}}
}
\value{
A data frame with columns
\itemize{
\item \code{version}: The Rtools version, e.g. \code{45}.
\item \code{url}: Download URL of the Rtools installer.
\item \code{first}: First R version supported by this Rtools version.
\item \code{last}: Last R version supported by this Rtools version.
}
}
\description{
List Rtools versions
}
\examples{
\dontshow{if (rversions:::is_online()) withAutoprint(\{ # examplesIf}
rtools_versions()
rtools_versions("aarch64")
\dontshow{\}) # examplesIf}
}
