% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxPenalty.R
\name{mxPenaltyElasticNet}
\alias{mxPenaltyElasticNet}
\title{mxPenaltyElasticNet}
\usage{
mxPenaltyElasticNet(
  what,
  name,
  alpha = 0,
  alpha.step = 0.1,
  alpha.max = 1,
  lambda = 0,
  lambda.step = 0.1,
  lambda.max = 0.4,
  alpha.min = NA,
  lambda.min = NA,
  epsilon = 1e-05,
  scale = 1,
  ...,
  hyperparams = c("alpha", "lambda")
)
}
\arguments{
\item{what}{A character vector of parameters to regularize}

\item{name}{Name of the regularizer object}

\item{alpha}{strength of the mixing parameter to be applied at start (default 0.5).  Note that 0 indicates a ridge regression with penalty \deqn{\frac{lambda}{2}}{lambda / 2}, and 1 indicates a LASSO regression with penalty lambda.}

\item{alpha.step}{alpha step during penalty search (default 0.1)}

\item{alpha.max}{when to end the alpha search (default 1)}

\item{lambda}{strength of the penalty to be applied at starting values (default 0)}

\item{lambda.step}{step function for lambda step (default .01)}

\item{lambda.max}{end of lambda range (default .4)}

\item{alpha.min}{beginning of the alpha range (default 0)}

\item{lambda.min}{beginning of the lambda range (default lambda)}

\item{epsilon}{how close to zero is zero?}

\item{scale}{a given parameter is divided by \code{scale} before comparison with \code{epsilon}}

\item{...}{Not used.  Forces remaining arguments to be specified by name}

\item{hyperparams}{a character vector of hyperparameter names}
}
\description{
Elastic net regularization
}
\details{
Applies elastic net regularization.  Elastic net is a weighted combination of ridge and LASSO penalties.
}
