% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-coef2.R
\name{coef2}
\alias{coef2}
\alias{coef2.lvmfit}
\title{Model Coefficients With Small Sample Correction}
\usage{
coef2(object, as.lava, ...)

\method{coef2}{lvmfit}(object, as.lava = TRUE, ssc = lava.options()$ssc, ...)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{as.lava}{[logical] if \code{TRUE}, uses the same names as when using \code{stats::coef}.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (\code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}
}
\value{
A numeric vector named with the names of the coefficients.
}
\description{
Extract the coefficients from a latent variable model.
Similar to \code{lava::compare} but with small sample correction.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the model coefficients.
}
\examples{
#### simulate data ####
set.seed(10)
dW <- sampleRepeated(10, format = "wide")
set.seed(10)
dL <- sampleRepeated(10, format = "long")
dL$time2 <- paste0("visit",dL$time)

#### latent variable models ####
e.lvm <- estimate(lvm(c(Y1,Y2,Y3) ~ 1*eta + X1, eta ~ Z1), data = dW)
coef(e.lvm)
coef2(e.lvm)
coef2(e.lvm, as.lava = FALSE)
}
\seealso{
\code{\link{estimate2}} to obtain \code{lvmfit2} objects.
}
\concept{extractor}
\keyword{smallSampleCorrection}
