% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{component_wise}
\alias{component_wise}
\title{Component-wise layout}
\usage{
component_wise(merge_method = "dla")
}
\arguments{
\item{merge_method}{Merging algorithm, the \code{method}
argument of \code{\link[=merge_coords]{merge_coords()}}.}
}
\description{
This is a layout modifier function, and it can be used
to calculate the layout separately for each component
of the graph.
}
\examples{
g <- make_ring(10) + make_ring(10)
g \%>\%
  add_layout_(in_circle(), component_wise()) \%>\%
  plot()
}
\seealso{
\code{\link[=merge_coords]{merge_coords()}}, \code{\link[=layout_]{layout_()}}.

Other layout modifiers: 
\code{\link{normalize}()}

Other graph layouts: 
\code{\link{add_layout_}()},
\code{\link{layout_as_bipartite}()},
\code{\link{layout_as_star}()},
\code{\link{layout_as_tree}()},
\code{\link{layout_in_circle}()},
\code{\link{layout_nicely}()},
\code{\link{layout_on_grid}()},
\code{\link{layout_on_sphere}()},
\code{\link{layout_randomly}()},
\code{\link{layout_with_dh}()},
\code{\link{layout_with_fr}()},
\code{\link{layout_with_gem}()},
\code{\link{layout_with_graphopt}()},
\code{\link{layout_with_kk}()},
\code{\link{layout_with_lgl}()},
\code{\link{layout_with_mds}()},
\code{\link{layout_with_sugiyama}()},
\code{\link{layout_}()},
\code{\link{merge_coords}()},
\code{\link{norm_coords}()},
\code{\link{normalize}()}
}
\concept{graph layouts}
\concept{layout modifiers}
