#include <gsl/gsl_sf_fermi_dirac.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_fermi_dirac_m1_e  goes to fermi_dirac_m1. */

void fermi_dirac_m1(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_m1_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_0(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_0_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_1(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_1_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
void fermi_dirac_2(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_2_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_int(int *j, double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_int_e(j[i], x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_mhalf(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_mhalf_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
void fermi_dirac_half(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_half_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_3half(double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_3half_e(x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void fermi_dirac_inc_0(double *x, double *b, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
	
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_fermi_dirac_inc_0_e(x[i], b[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  
