% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOHeat.R
\name{GOHeat}
\alias{GOHeat}
\title{Displays heatmap of the relationship between genes and terms.}
\usage{
GOHeat(data, nlfc, fill.col)
}
\arguments{
\item{data}{The matrix represents the binary relation (1= is related to, 0= 
is not related to) between a set of genes (rows) and processes (columns)}

\item{nlfc}{Defines the number of logFC columns (default = 0)}

\item{fill.col}{Defines the color scale break points}
}
\description{
The GOHeat function generates a heatmap of the relationship 
  between genes and terms. Biological processes are displayed in rows and
  genes in columns. In addition genes are clustered to highlight groups of
  genes with similar annotated functions. The input can be generated with the
  \code{\link{chord_dat}} function.
}
\details{
The heatmap has in general two modes which depend on the \code{nlfc}
  argument. If \code{nlfc = 0}, so no logFC values are available, the 
  coloring encodes for the overall number of processes the respective gene is
  assigned to. In case of \code{nlfc = 1} the color corresponds to the logFC 
  of the gene.
}
\examples{
\dontrun{
# Load the included dataset
data(EC)

# Generate the circ object
circ <- circle_dat(EC$david, EC$genelist)

# Generate the chord object
chord <- chord_dat(circ, EC$genes, EC$process)

# Create the plot with user-defined colors
GOHeat(chord, nlfc = 1, fill.col = c('red', 'yellow', 'green'))
}
}

