% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_modify.R
\name{future_modify}
\alias{future_modify}
\alias{future_modify_at}
\alias{future_modify_if}
\title{Modify elements selectively via futures}
\usage{
future_modify(.x, .f, ..., .progress = FALSE, .options = future_options())

future_modify_at(.x, .at, .f, ..., .progress = FALSE,
  .options = future_options())

future_modify_if(.x, .p, .f, ..., .progress = FALSE,
  .options = future_options())
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.progress}{A logical, for whether or not to print a progress bar for
multiprocess, multisession, and multicore plans.}

\item{.options}{The \code{future} specific options to use with the workers. This must
be the result from a call to \code{\link[=future_options]{future_options()}}.}

\item{.at}{A character vector of names or a numeric vector of
positions. Only those elements corresponding to \code{.at} will be
modified.}

\item{.p}{A single predicate function, a formula describing such a
predicate function, or a logical vector of the same length as \code{.x}.
Alternatively, if the elements of \code{.x} are themselves lists of
objects, a string indicating the name of a logical element in the
inner lists. Only those elements where \code{.p} evaluates to
\code{TRUE} will be modified.}
}
\value{
An object the same class as .x
}
\description{
These functions work exactly the same as \code{\link[purrr:modify]{purrr::modify()}} functions, but allow
you to modify in parallel.
}
\details{
From \code{purrr}) Since the transformation can alter the structure of the input;
it's your responsibility to ensure that the transformation produces a valid
output. For example, if you're modifying a data frame, \code{.f} must preserve the
length of the input.
}
\examples{

library(furrr)
library(dplyr) # for the pipe

\donttest{
plan(multiprocess)
}

# Convert each col to character, in parallel
future_modify(mtcars, as.character)

iris \%>\%
 future_modify_if(is.factor, as.character) \%>\%
 str()

mtcars \%>\% future_modify_at(c(1, 4, 5), as.character) \%>\% str()

}
