% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsize-package.R
\docType{package}
\name{effectsize-package}
\alias{effectsize-package}
\title{effectsize: Indices of Effect Size}
\description{
In both theoretical and applied research, it is often of interest to assess
the strength of an observed association. This is typically done to allow the
judgment of the magnitude of an effect, especially when units of measurement
are not meaningful. Though some indices of effect size, such as the
correlation coefficient (itself a standardized covariance coefficient) are
readily available, other measures are often harder to obtain.

\strong{effectsize} fills this important gap, providing utilities for easily
estimating a wide variety of standardized effect sizes (i.e., effect sizes
that are not tied to the units of measurement of the variables of interest)
and their confidence intervals (CIs), from a variety of statistical models
and hypothesis tests, such as \code{\link[=cohens_d]{cohens_d()}}, \code{\link[=phi]{phi()}}, \code{\link[=eta_squared]{eta_squared()}}, and
many more.

See \href{https://easystats.github.io/effectsize/articles/effectsize.html}{\code{vignette("effectsize", package = "effectsize")}}
for more details, or \href{https://easystats.github.io/effectsize/articles/}{\code{vignette(package = "effectsize")}}
for a full list of vignettes.

References: Ben-Shachar et al. (2020) \doi{10.21105/joss.02815}.
}
\details{
\code{effectsize}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://easystats.github.io/effectsize/}
  \item Report bugs at \url{https://github.com/easystats/effectsize/issues/}
}

}
\author{
\strong{Maintainer}: Mattan S. Ben-Shachar \email{mattansb@msbstats.info} (\href{https://orcid.org/0000-0002-4287-4801}{ORCID})

Authors:
\itemize{
  \item Dominique Makowski \email{dom.makowski@gmail.com} (\href{https://orcid.org/0000-0001-5375-9967}{ORCID})
  \item Daniel Lüdecke \email{d.luedecke@uke.de} (\href{https://orcid.org/0000-0002-8895-3206}{ORCID})
  \item Indrajeet Patil \email{patilindrajeet.science@gmail.com} (\href{https://orcid.org/0000-0003-1995-6531}{ORCID})
  \item Brenton M. Wiernik \email{brenton@wiernik.org} (\href{https://orcid.org/0000-0001-9560-6336}{ORCID})
  \item Rémi Thériault \email{remi.theriault@mail.mcgill.ca} (\href{https://orcid.org/0000-0003-4315-6788}{ORCID})
  \item Philip Waggoner \email{philip.waggoner@gmail.com} (\href{https://orcid.org/0000-0002-7825-7573}{ORCID}) [contributor]
}

Other contributors:
\itemize{
  \item Ken Kelley [contributor]
  \item David Stanley [contributor]
  \item Aaron Caldwell \email{arcaldwell49@gmail.com} (\href{https://orcid.org/0000-0002-4541-6283}{ORCID}) [contributor]
  \item Jessica Burnett \email{jburnett@usgs.gov} (\href{https://orcid.org/0000-0002-0896-5099}{ORCID}) [reviewer]
  \item Johannes Karreth \email{jkarreth@ursinus.edu} (\href{https://orcid.org/0000-0003-4586-7153}{ORCID}) [reviewer]
}

}
\keyword{internal}
