% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar_leap_year}
\alias{calendar_leap_year}
\title{Is the calendar year a leap year?}
\usage{
calendar_leap_year(x)
}
\arguments{
\item{x}{\verb{[calendar]}

A calendar type to detect leap years in.}
}
\value{
A logical vector the same size as \code{x}. Returns \code{TRUE} if in a leap
year, \code{FALSE} if not in a leap year, and \code{NA} if \code{x} is \code{NA}.
}
\description{
\code{calendar_leap_year()} detects if the calendar year is a leap year - i.e.
does it contain one or more extra components than other years?

A particular year is a leap year if:
\itemize{
\item \code{\link[=year_month_day]{year_month_day()}}: February has 29 days.
\item \code{\link[=year_month_weekday]{year_month_weekday()}}: February has a weekday that occurs 5 times.
\item \code{\link[=year_week_day]{year_week_day()}}: There are 53 weeks in the year, resulting in 371
days in the year.
\item \code{\link[=iso_year_week_day]{iso_year_week_day()}}: There are 53 weeks in the year, resulting in 371
days in the year.
\item \code{\link[=year_quarter_day]{year_quarter_day()}}: One of the quarters has 1 more day than normal (the
quarter with an extra day depends on the \code{start} used, but will always be
the same for a particular \code{start}). This aligns with Gregorian leap years
for all \code{start}s except February, in which case the leap year is always 1
year after the Gregorian leap year.
\item \code{\link[=year_day]{year_day()}}: There are 366 days in the year.
}
}
\examples{
x <- year_month_day(c(2019:2024, NA))
calendar_leap_year(x)

# For year-quarter-day, the leap year typically aligns with the Gregorian
# leap year, unless the `start` is February, in which case the leap year is
# always 1 year after the Gregorian leap year
x <- year_quarter_day(2020:2021, start = clock_months$january)
calendar_leap_year(x)

x <- year_quarter_day(2020:2021, start = clock_months$february)
calendar_leap_year(x)

# With a January start, 2020 has the extra day
get_day(year_quarter_day(2020, 1:4, "last", start = clock_months$january))
get_day(year_quarter_day(2021, 1:4, "last", start = clock_months$january))
get_day(year_quarter_day(2022, 1:4, "last", start = clock_months$january))

# With a February start, 2021 has the extra day
get_day(year_quarter_day(2020, 1:4, "last", start = clock_months$february))
get_day(year_quarter_day(2021, 1:4, "last", start = clock_months$february))
get_day(year_quarter_day(2022, 1:4, "last", start = clock_months$february))
}
