% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stancode.R
\name{stancode.brmsfit}
\alias{stancode.brmsfit}
\title{Extract Stan code from \code{brmsfit} objects}
\usage{
\method{stancode}{brmsfit}(
  object,
  version = TRUE,
  regenerate = NULL,
  threads = NULL,
  backend = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{version}{Logical; indicates if the first line containing the \pkg{brms}
version number should be included. Defaults to \code{TRUE}.}

\item{regenerate}{Logical; indicates if the Stan code should be regenerated
with the current \pkg{brms} version. By default, \code{regenerate} will be
\code{FALSE} unless required to be \code{TRUE} by other arguments.}

\item{threads}{Controls whether the Stan code should be threaded. See
\code{\link{threading}} for details.}

\item{backend}{Controls the Stan backend. See \code{\link{brm}} for details.}

\item{...}{Further arguments passed to
\code{\link[brms:stancode.default]{stancode}} if the Stan code is
regenerated.}
}
\value{
Stan code for further processing.
}
\description{
Extract Stan code from a fitted \pkg{brms} model.
}
