% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions-scalar.R
\name{scalar}
\alias{is.scalar}
\alias{is.string}
\alias{is.number}
\alias{is.flag}
\alias{is.count}
\title{Assert input is a scalar.}
\usage{
is.scalar(x)

is.string(x)

is.number(x)

is.flag(x)

is.count(x)
}
\arguments{
\item{x}{object to test}
}
\description{
\code{is.scalar} provides a generic method for checking input is a scalar.
\code{is.string}, \code{is.flag}, \code{is.number} and \code{is.count}
provide tests for specific types.
}
\examples{
# Generic check for scalars
see_if(is.scalar("a"))
see_if(is.scalar(1:10))

# string = scalar character vector
see_if(is.string(1:3))
see_if(is.string(c("a", "b")))
see_if(is.string("x"))

# number = scalar numeric/integer vector
see_if(is.number(1:3))
see_if(is.number(1.5))

# flag = scalar logical vector
see_if(is.flag(1:3))
see_if(is.flag("a"))
see_if(is.flag(c(FALSE, FALSE, TRUE)))
see_if(is.flag(FALSE))

# count = scalar positive integer
see_if(is.count("a"))
see_if(is.count(-1))
see_if(is.count(1:5))
see_if(is.count(1.5))
see_if(is.count(1))

}
\seealso{
Other assertions: \code{\link{are_equal}},
  \code{\link{is.error}}, \code{\link{noNA}},
  \code{\link{not_empty}}
}
