% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makefreq.R
\docType{methods}
\name{makefreq}
\alias{makefreq}
\alias{makefreq,genind-method}
\alias{makefreq,genind-methods}
\alias{makefreq.genind}
\alias{makefreq,genpop-method}
\alias{makefreq,genpop-methods}
\alias{makefreq.genpop}
\title{Compute allelic frequencies}
\usage{
makefreq(x, ...)

\S4method{makefreq}{genind}(x, quiet = FALSE, missing = NA, truenames = TRUE, ...)

\S4method{makefreq}{genpop}(x, quiet = FALSE, missing = NA, truenames = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{genind} or \linkS4class{genpop} object.}

\item{...}{further arguments (curently unused)}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}

\item{missing}{treatment for missing values. Can be NA, 0 or "mean" (see
details)}

\item{truenames}{deprecated; there for backward compatibility}
}
\value{
Returns a list with the following components: \item{tab}{matrix of
allelic frequencies (rows: populations; columns: alleles).}
\item{nobs}{number of observations (i.e. alleles) for each population x
locus combinaison.} \item{call}{the matched call}
}
\description{
The function \code{makefreq} is a generic to compute allele frequencies.
These can be derived for \linkS4class{genind} or \linkS4class{genpop} objects.
In the case of \linkS4class{genind} objects, data are kept at the individual level, but standardised so that allele frequencies sum up to 1.
}
\details{
There are 3 treatments for missing values: \cr - NA: kept as NA.\cr - 0:
missing values are considered as zero. Recommended for a PCA on
compositionnal data.\cr - "mean": missing values are given the mean
frequency of the corresponding allele. Recommended for a centred PCA.

Note that this function is now a simple wrapper for the accessor \code{\link{tab}}.
}
\examples{

\dontrun{
data(microbov)
obj1 <- microbov
obj2 <- genind2genpop(obj1)

# perform a correspondance analysis on counts data
Xcount <- tab(obj2, NA.method="zero")
ca1 <- dudi.coa(Xcount,scannf=FALSE)
s.label(ca1$li,sub="Correspondance Analysis",csub=1.2)
add.scatter.eig(ca1$eig,nf=2,xax=1,yax=2,posi="topleft")

# perform a principal component analysis on frequency data
Xfreq <- makefreq(obj2, missing="mean")
Xfreq <- tab(obj2, NA.method="mean") # equivalent to line above
pca1 <- dudi.pca(Xfreq,scale=FALSE,scannf=FALSE)
s.label(pca1$li,sub="Principal Component Analysis",csub=1.2)
add.scatter.eig(pca1$eig,nf=2,xax=1,yax=2,posi="top")
}

}
\seealso{
\code{\link{genpop}}
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\keyword{manip}
\keyword{multivariate}
