/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakecamerafocuscontrol.h"
#include "fakecameraservice.h"

FakeCameraFocusControl::FakeCameraFocusControl(FakeCameraService *service, QObject *parent)
    : QCameraFocusControl(parent),
      m_service(service),
      m_focusMode(QCameraFocus::AutoFocus),
      m_pointMode(QCameraFocus::FocusPointCenter),
      m_focusPoint(200,300)
{
}

QPointF FakeCameraFocusControl::customFocusPoint() const
{
    return m_focusPoint;
}

QCameraFocus::FocusModes FakeCameraFocusControl::focusMode() const
{
    return m_focusMode;
}

QCameraFocus::FocusPointMode FakeCameraFocusControl::focusPointMode() const
{
    return m_pointMode;
}

QCameraFocusZoneList FakeCameraFocusControl::focusZones() const
{
    return QCameraFocusZoneList();
}

bool FakeCameraFocusControl::isFocusModeSupported(QCameraFocus::FocusModes mode) const
{
    Q_UNUSED(mode);
    return true;
}

bool FakeCameraFocusControl::isFocusPointModeSupported(QCameraFocus::FocusPointMode mode) const
{
    Q_UNUSED(mode);
    return true;
}

void FakeCameraFocusControl::setCustomFocusPoint(const QPointF &point)
{
    if (point == m_focusPoint)
        return;

    m_focusPoint = m_focusPoint;
    Q_EMIT(customFocusPointChanged(m_focusPoint));
}

void FakeCameraFocusControl::setFocusMode(QCameraFocus::FocusModes mode)
{
    if (mode == m_focusMode)
        return;

    m_focusMode = mode;
    Q_EMIT(focusModeChanged(m_focusMode));
}

void FakeCameraFocusControl::setFocusPointMode(QCameraFocus::FocusPointMode mode)
{
    if (mode == m_pointMode)
        return;

    m_pointMode = mode;
    Q_EMIT(focusPointModeChanged(m_pointMode));
}
