#ifndef DRW_CPTABLE949_H
#define DRW_CPTABLE949_H

//Korean Extended Wansung

//first entry in this table are 0x80
#define CPOFFSET949 0x80
#define CPLENGHT949 17048
#define NOTFOUND949 0x003F

//Table 949 one byte
static const int DRW_Table949[1] =
{
};

//Table 949 lead byte
//pairs of start/end in DRW_DoubleTable949
static const int DRW_LeadTable949[] =
{
  0, //1#DBCS LEAD BYTE 0x81
  178, //2#DBCS LEAD BYTE 0x82
  356, //3#DBCS LEAD BYTE 0x83
  564, //4#DBCS LEAD BYTE 0x84
  712, //5#DBCS LEAD BYTE 0x85
  890, //6#DBCS LEAD BYTE 0x86
  1068, //7#DBCS LEAD BYTE 0x87
  1246, //8#DBCS LEAD BYTE 0x88
  1424, //9#DBCS LEAD BYTE 0x89
  1602, //10#DBCS LEAD BYTE 0x8A
  1780, //11#DBCS LEAD BYTE 0x8B
  1958, //12#DBCS LEAD BYTE 0x8C
  2136, //13#DBCS LEAD BYTE 0x8D
  2314, //14#DBCS LEAD BYTE 0x8E
  2492, //15#DBCS LEAD BYTE 0x8F
  2670, //16#DBCS LEAD BYTE 0x90
  2848, //17#DBCS LEAD BYTE 0x91
  3026, //18#DBCS LEAD BYTE 0x92
  3204, //19#DBCS LEAD BYTE 0x93
  3382, //20#DBCS LEAD BYTE 0x94
  3560, //21#DBCS LEAD BYTE 0x95
  3738, //22#DBCS LEAD BYTE 0x96
  3916, //23#DBCS LEAD BYTE 0x97
  4094, //24#DBCS LEAD BYTE 0x98
  4272, //25#DBCS LEAD BYTE 0x99
  4450, //26#DBCS LEAD BYTE 0x9A
  4628, //27#DBCS LEAD BYTE 0x9B
  4806, //28#DBCS LEAD BYTE 0x9C
  4984, //29#DBCS LEAD BYTE 0x9D
  5162, //30#DBCS LEAD BYTE 0x9E
  5340, //31#DBCS LEAD BYTE 0x9F
  5518, //32#DBCS LEAD BYTE 0xA0
  5696, //33#DBCS LEAD BYTE 0xA1
  5874, //34#DBCS LEAD BYTE 0xA2
  6029, //35#DBCS LEAD BYTE 0xA3
  6207, //36#DBCS LEAD BYTE 0xA4
  6385, //37#DBCS LEAD BYTE 0xA5
  6537, //38#DBCS LEAD BYTE 0xA6
  6689, //39#DBCS LEAD BYTE 0xA7
  6852, //40#DBCS LEAD BYTE 0xA8
  7027, //41#DBCS LEAD BYTE 0xA9
  7205, //42#DBCS LEAD BYTE 0xAA
  7372, //43#DBCS LEAD BYTE 0xAB
  7542, //44#DBCS LEAD BYTE 0xAC
  7692, //45#DBCS LEAD BYTE 0xAD
  7776, //46#DBCS LEAD BYTE 0xAE
  7860, //47#DBCS LEAD BYTE 0xAF
  7944, //48#DBCS LEAD BYTE 0xB0
  8122, //49#DBCS LEAD BYTE 0xB1
  8300, //50#DBCS LEAD BYTE 0xB2
  8478, //51#DBCS LEAD BYTE 0xB3
  8656, //52#DBCS LEAD BYTE 0xB4
  8834, //53#DBCS LEAD BYTE 0xB5
  9012, //54#DBCS LEAD BYTE 0xB6
  9190, //55#DBCS LEAD BYTE 0xB7
  9368, //56#DBCS LEAD BYTE 0xB8
  9546, //57#DBCS LEAD BYTE 0xB9
  9724, //58#DBCS LEAD BYTE 0xBA
  9902, //59#DBCS LEAD BYTE 0xBB
  10080, //60#DBCS LEAD BYTE 0xBC
  10258, //61#DBCS LEAD BYTE 0xBD
  10436, //62#DBCS LEAD BYTE 0xBE
  10614, //63#DBCS LEAD BYTE 0xBF
  10792, //64#DBCS LEAD BYTE 0xC0
  10970, //65#DBCS LEAD BYTE 0xC1
  11148, //66#DBCS LEAD BYTE 0xC2
  11326, //67#DBCS LEAD BYTE 0xC3
  11504, //68#DBCS LEAD BYTE 0xC4
  11682, //69#DBCS LEAD BYTE 0xC5
  11860, //70#DBCS LEAD BYTE 0xC6
  11972, //71#DBCS LEAD BYTE 0xC7
  12066, //72#DBCS LEAD BYTE 0xC8
  12160, //73#DBCS LEAD BYTE 0xC9, empty
  12160, //74#DBCS LEAD BYTE 0xCA
  12254, //75#DBCS LEAD BYTE 0xCB
  12348, //76#DBCS LEAD BYTE 0xCC
  12442, //77#DBCS LEAD BYTE 0xCD
  12536, //78#DBCS LEAD BYTE 0xCE
  12630, //79#DBCS LEAD BYTE 0xCF
  12724, //80#DBCS LEAD BYTE 0xD0
  12818, //81#DBCS LEAD BYTE 0xD1
  12912, //82#DBCS LEAD BYTE 0xD2
  13006, //83#DBCS LEAD BYTE 0xD3
  13100, //84#DBCS LEAD BYTE 0xD4
  13194, //85#DBCS LEAD BYTE 0xD5
  13288, //86#DBCS LEAD BYTE 0xD6
  13382, //87#DBCS LEAD BYTE 0xD7
  13476, //88#DBCS LEAD BYTE 0xD8
  13570, //89#DBCS LEAD BYTE 0xD9
  13664, //90#DBCS LEAD BYTE 0xDA
  13758, //91#DBCS LEAD BYTE 0xDB
  13852, //92#DBCS LEAD BYTE 0xDC
  13946, //93#DBCS LEAD BYTE 0xDD
  14040, //94#DBCS LEAD BYTE 0xDE
  14134, //95#DBCS LEAD BYTE 0xDF
  14228, //96#DBCS LEAD BYTE 0xE0
  14322, //97#DBCS LEAD BYTE 0xE1
  14416, //98#DBCS LEAD BYTE 0xE2
  14510, //99#DBCS LEAD BYTE 0xE3
  14604, //100#DBCS LEAD BYTE 0xE4
  14698, //101#DBCS LEAD BYTE 0xE5
  14792, //102#DBCS LEAD BYTE 0xE6
  14886, //103#DBCS LEAD BYTE 0xE7
  14980, //104#DBCS LEAD BYTE 0xE8
  15074, //105#DBCS LEAD BYTE 0xE9
  15168, //106#DBCS LEAD BYTE 0xEA
  15262, //107#DBCS LEAD BYTE 0xEB
  15356, //108#DBCS LEAD BYTE 0xEC
  15450, //109#DBCS LEAD BYTE 0xED
  15544, //110#DBCS LEAD BYTE 0xEE
  15638, //111#DBCS LEAD BYTE 0xEF
  15732, //112#DBCS LEAD BYTE 0xF0
  15826, //113#DBCS LEAD BYTE 0xF1
  15920, //114#DBCS LEAD BYTE 0xF2
  16014, //115#DBCS LEAD BYTE 0xF3
  16108, //116#DBCS LEAD BYTE 0xF4
  16202, //117#DBCS LEAD BYTE 0xF5
  16296, //118#DBCS LEAD BYTE 0xF6
  16390, //119#DBCS LEAD BYTE 0xF7
  16484, //120#DBCS LEAD BYTE 0xF8
  16578, //121#DBCS LEAD BYTE 0xF9
  16672, //122#DBCS LEAD BYTE 0xFA
  16766, //123#DBCS LEAD BYTE 0xFB
  16860, //124#DBCS LEAD BYTE 0xFC
  16954, //125#DBCS LEAD BYTE 0xFD
  17047, //126#DBCS LEAD BYTE 0xFE, empty
  17047, //127#UNDEFINED 0xFF, END OF TABLE
};

//Table 949 tail byte
static const int DRW_DoubleTable949[][2] =
{
  {0x8141, 0xAC02}, //1 #HANGUL SYLLABLE KIYEOK A SSANGKIYEOK
  {0x8142, 0xAC03}, //2 #HANGUL SYLLABLE KIYEOK A KIYEOKSIOS
  {0x8143, 0xAC05}, //3 #HANGUL SYLLABLE KIYEOK A NIEUNCIEUC
  {0x8144, 0xAC06}, //4 #HANGUL SYLLABLE KIYEOK A NIEUNHIEUH
  {0x8145, 0xAC0B}, //5 #HANGUL SYLLABLE KIYEOK A RIEULPIEUP
  {0x8146, 0xAC0C}, //6 #HANGUL SYLLABLE KIYEOK A RIEULSIOS
  {0x8147, 0xAC0D}, //7 #HANGUL SYLLABLE KIYEOK A RIEULTHIEUTH
  {0x8148, 0xAC0E}, //8 #HANGUL SYLLABLE KIYEOK A RIEULPHIEUPH
  {0x8149, 0xAC0F}, //9 #HANGUL SYLLABLE KIYEOK A RIEULHIEUH
  {0x814A, 0xAC18}, //10 #HANGUL SYLLABLE KIYEOK A KHIEUKH
  {0x814B, 0xAC1E}, //11 #HANGUL SYLLABLE KIYEOK AE SSANGKIYEOK
  {0x814C, 0xAC1F}, //12 #HANGUL SYLLABLE KIYEOK AE KIYEOKSIOS
  {0x814D, 0xAC21}, //13 #HANGUL SYLLABLE KIYEOK AE NIEUNCIEUC
  {0x814E, 0xAC22}, //14 #HANGUL SYLLABLE KIYEOK AE NIEUNHIEUH
  {0x814F, 0xAC23}, //15 #HANGUL SYLLABLE KIYEOK AE TIKEUT
  {0x8150, 0xAC25}, //16 #HANGUL SYLLABLE KIYEOK AE RIEULKIYEOK
  {0x8151, 0xAC26}, //17 #HANGUL SYLLABLE KIYEOK AE RIEULMIEUM
  {0x8152, 0xAC27}, //18 #HANGUL SYLLABLE KIYEOK AE RIEULPIEUP
  {0x8153, 0xAC28}, //19 #HANGUL SYLLABLE KIYEOK AE RIEULSIOS
  {0x8154, 0xAC29}, //20 #HANGUL SYLLABLE KIYEOK AE RIEULTHIEUTH
  {0x8155, 0xAC2A}, //21 #HANGUL SYLLABLE KIYEOK AE RIEULPHIEUPH
  {0x8156, 0xAC2B}, //22 #HANGUL SYLLABLE KIYEOK AE RIEULHIEUH
  {0x8157, 0xAC2E}, //23 #HANGUL SYLLABLE KIYEOK AE PIEUPSIOS
  {0x8158, 0xAC32}, //24 #HANGUL SYLLABLE KIYEOK AE CIEUC
  {0x8159, 0xAC33}, //25 #HANGUL SYLLABLE KIYEOK AE CHIEUCH
  {0x815A, 0xAC34}, //26 #HANGUL SYLLABLE KIYEOK AE KHIEUKH
  {0x8161, 0xAC35}, //27 #HANGUL SYLLABLE KIYEOK AE THIEUTH
  {0x8162, 0xAC36}, //28 #HANGUL SYLLABLE KIYEOK AE PHIEUPH
  {0x8163, 0xAC37}, //29 #HANGUL SYLLABLE KIYEOK AE HIEUH
  {0x8164, 0xAC3A}, //30 #HANGUL SYLLABLE KIYEOK YA SSANGKIYEOK
  {0x8165, 0xAC3B}, //31 #HANGUL SYLLABLE KIYEOK YA KIYEOKSIOS
  {0x8166, 0xAC3D}, //32 #HANGUL SYLLABLE KIYEOK YA NIEUNCIEUC
  {0x8167, 0xAC3E}, //33 #HANGUL SYLLABLE KIYEOK YA NIEUNHIEUH
  {0x8168, 0xAC3F}, //34 #HANGUL SYLLABLE KIYEOK YA TIKEUT
  {0x8169, 0xAC41}, //35 #HANGUL SYLLABLE KIYEOK YA RIEULKIYEOK
  {0x816A, 0xAC42}, //36 #HANGUL SYLLABLE KIYEOK YA RIEULMIEUM
  {0x816B, 0xAC43}, //37 #HANGUL SYLLABLE KIYEOK YA RIEULPIEUP
  {0x816C, 0xAC44}, //38 #HANGUL SYLLABLE KIYEOK YA RIEULSIOS
  {0x816D, 0xAC45}, //39 #HANGUL SYLLABLE KIYEOK YA RIEULTHIEUTH
  {0x816E, 0xAC46}, //40 #HANGUL SYLLABLE KIYEOK YA RIEULPHIEUPH
  {0x816F, 0xAC47}, //41 #HANGUL SYLLABLE KIYEOK YA RIEULHIEUH
  {0x8170, 0xAC48}, //42 #HANGUL SYLLABLE KIYEOK YA MIEUM
  {0x8171, 0xAC49}, //43 #HANGUL SYLLABLE KIYEOK YA PIEUP
  {0x8172, 0xAC4A}, //44 #HANGUL SYLLABLE KIYEOK YA PIEUPSIOS
  {0x8173, 0xAC4C}, //45 #HANGUL SYLLABLE KIYEOK YA SSANGSIOS
  {0x8174, 0xAC4E}, //46 #HANGUL SYLLABLE KIYEOK YA CIEUC
  {0x8175, 0xAC4F}, //47 #HANGUL SYLLABLE KIYEOK YA CHIEUCH
  {0x8176, 0xAC50}, //48 #HANGUL SYLLABLE KIYEOK YA KHIEUKH
  {0x8177, 0xAC51}, //49 #HANGUL SYLLABLE KIYEOK YA THIEUTH
  {0x8178, 0xAC52}, //50 #HANGUL SYLLABLE KIYEOK YA PHIEUPH
  {0x8179, 0xAC53}, //51 #HANGUL SYLLABLE KIYEOK YA HIEUH
  {0x817A, 0xAC55}, //52 #HANGUL SYLLABLE KIYEOK YAE KIYEOK
  {0x8181, 0xAC56}, //53 #HANGUL SYLLABLE KIYEOK YAE SSANGKIYEOK
  {0x8182, 0xAC57}, //54 #HANGUL SYLLABLE KIYEOK YAE KIYEOKSIOS
  {0x8183, 0xAC59}, //55 #HANGUL SYLLABLE KIYEOK YAE NIEUNCIEUC
  {0x8184, 0xAC5A}, //56 #HANGUL SYLLABLE KIYEOK YAE NIEUNHIEUH
  {0x8185, 0xAC5B}, //57 #HANGUL SYLLABLE KIYEOK YAE TIKEUT
  {0x8186, 0xAC5D}, //58 #HANGUL SYLLABLE KIYEOK YAE RIEULKIYEOK
  {0x8187, 0xAC5E}, //59 #HANGUL SYLLABLE KIYEOK YAE RIEULMIEUM
  {0x8188, 0xAC5F}, //60 #HANGUL SYLLABLE KIYEOK YAE RIEULPIEUP
  {0x8189, 0xAC60}, //61 #HANGUL SYLLABLE KIYEOK YAE RIEULSIOS
  {0x818A, 0xAC61}, //62 #HANGUL SYLLABLE KIYEOK YAE RIEULTHIEUTH
  {0x818B, 0xAC62}, //63 #HANGUL SYLLABLE KIYEOK YAE RIEULPHIEUPH
  {0x818C, 0xAC63}, //64 #HANGUL SYLLABLE KIYEOK YAE RIEULHIEUH
  {0x818D, 0xAC64}, //65 #HANGUL SYLLABLE KIYEOK YAE MIEUM
  {0x818E, 0xAC65}, //66 #HANGUL SYLLABLE KIYEOK YAE PIEUP
  {0x818F, 0xAC66}, //67 #HANGUL SYLLABLE KIYEOK YAE PIEUPSIOS
  {0x8190, 0xAC67}, //68 #HANGUL SYLLABLE KIYEOK YAE SIOS
  {0x8191, 0xAC68}, //69 #HANGUL SYLLABLE KIYEOK YAE SSANGSIOS
  {0x8192, 0xAC69}, //70 #HANGUL SYLLABLE KIYEOK YAE IEUNG
  {0x8193, 0xAC6A}, //71 #HANGUL SYLLABLE KIYEOK YAE CIEUC
  {0x8194, 0xAC6B}, //72 #HANGUL SYLLABLE KIYEOK YAE CHIEUCH
  {0x8195, 0xAC6C}, //73 #HANGUL SYLLABLE KIYEOK YAE KHIEUKH
  {0x8196, 0xAC6D}, //74 #HANGUL SYLLABLE KIYEOK YAE THIEUTH
  {0x8197, 0xAC6E}, //75 #HANGUL SYLLABLE KIYEOK YAE PHIEUPH
  {0x8198, 0xAC6F}, //76 #HANGUL SYLLABLE KIYEOK YAE HIEUH
  {0x8199, 0xAC72}, //77 #HANGUL SYLLABLE KIYEOK EO SSANGKIYEOK
  {0x819A, 0xAC73}, //78 #HANGUL SYLLABLE KIYEOK EO KIYEOKSIOS
  {0x819B, 0xAC75}, //79 #HANGUL SYLLABLE KIYEOK EO NIEUNCIEUC
  {0x819C, 0xAC76}, //80 #HANGUL SYLLABLE KIYEOK EO NIEUNHIEUH
  {0x819D, 0xAC79}, //81 #HANGUL SYLLABLE KIYEOK EO RIEULKIYEOK
  {0x819E, 0xAC7B}, //82 #HANGUL SYLLABLE KIYEOK EO RIEULPIEUP
  {0x819F, 0xAC7C}, //83 #HANGUL SYLLABLE KIYEOK EO RIEULSIOS
  {0x81A0, 0xAC7D}, //84 #HANGUL SYLLABLE KIYEOK EO RIEULTHIEUTH
  {0x81A1, 0xAC7E}, //85 #HANGUL SYLLABLE KIYEOK EO RIEULPHIEUPH
  {0x81A2, 0xAC7F}, //86 #HANGUL SYLLABLE KIYEOK EO RIEULHIEUH
  {0x81A3, 0xAC82}, //87 #HANGUL SYLLABLE KIYEOK EO PIEUPSIOS
  {0x81A4, 0xAC87}, //88 #HANGUL SYLLABLE KIYEOK EO CHIEUCH
  {0x81A5, 0xAC88}, //89 #HANGUL SYLLABLE KIYEOK EO KHIEUKH
  {0x81A6, 0xAC8D}, //90 #HANGUL SYLLABLE KIYEOK E KIYEOK
  {0x81A7, 0xAC8E}, //91 #HANGUL SYLLABLE KIYEOK E SSANGKIYEOK
  {0x81A8, 0xAC8F}, //92 #HANGUL SYLLABLE KIYEOK E KIYEOKSIOS
  {0x81A9, 0xAC91}, //93 #HANGUL SYLLABLE KIYEOK E NIEUNCIEUC
  {0x81AA, 0xAC92}, //94 #HANGUL SYLLABLE KIYEOK E NIEUNHIEUH
  {0x81AB, 0xAC93}, //95 #HANGUL SYLLABLE KIYEOK E TIKEUT
  {0x81AC, 0xAC95}, //96 #HANGUL SYLLABLE KIYEOK E RIEULKIYEOK
  {0x81AD, 0xAC96}, //97 #HANGUL SYLLABLE KIYEOK E RIEULMIEUM
  {0x81AE, 0xAC97}, //98 #HANGUL SYLLABLE KIYEOK E RIEULPIEUP
  {0x81AF, 0xAC98}, //99 #HANGUL SYLLABLE KIYEOK E RIEULSIOS
  {0x81B0, 0xAC99}, //100 #HANGUL SYLLABLE KIYEOK E RIEULTHIEUTH
  {0x81B1, 0xAC9A}, //101 #HANGUL SYLLABLE KIYEOK E RIEULPHIEUPH
  {0x81B2, 0xAC9B}, //102 #HANGUL SYLLABLE KIYEOK E RIEULHIEUH
  {0x81B3, 0xAC9E}, //103 #HANGUL SYLLABLE KIYEOK E PIEUPSIOS
  {0x81B4, 0xACA2}, //104 #HANGUL SYLLABLE KIYEOK E CIEUC
  {0x81B5, 0xACA3}, //105 #HANGUL SYLLABLE KIYEOK E CHIEUCH
  {0x81B6, 0xACA4}, //106 #HANGUL SYLLABLE KIYEOK E KHIEUKH
  {0x81B7, 0xACA5}, //107 #HANGUL SYLLABLE KIYEOK E THIEUTH
  {0x81B8, 0xACA6}, //108 #HANGUL SYLLABLE KIYEOK E PHIEUPH
  {0x81B9, 0xACA7}, //109 #HANGUL SYLLABLE KIYEOK E HIEUH
  {0x81BA, 0xACAB}, //110 #HANGUL SYLLABLE KIYEOK YEO KIYEOKSIOS
  {0x81BB, 0xACAD}, //111 #HANGUL SYLLABLE KIYEOK YEO NIEUNCIEUC
  {0x81BC, 0xACAE}, //112 #HANGUL SYLLABLE KIYEOK YEO NIEUNHIEUH
  {0x81BD, 0xACB1}, //113 #HANGUL SYLLABLE KIYEOK YEO RIEULKIYEOK
  {0x81BE, 0xACB2}, //114 #HANGUL SYLLABLE KIYEOK YEO RIEULMIEUM
  {0x81BF, 0xACB3}, //115 #HANGUL SYLLABLE KIYEOK YEO RIEULPIEUP
  {0x81C0, 0xACB4}, //116 #HANGUL SYLLABLE KIYEOK YEO RIEULSIOS
  {0x81C1, 0xACB5}, //117 #HANGUL SYLLABLE KIYEOK YEO RIEULTHIEUTH
  {0x81C2, 0xACB6}, //118 #HANGUL SYLLABLE KIYEOK YEO RIEULPHIEUPH
  {0x81C3, 0xACB7}, //119 #HANGUL SYLLABLE KIYEOK YEO RIEULHIEUH
  {0x81C4, 0xACBA}, //120 #HANGUL SYLLABLE KIYEOK YEO PIEUPSIOS
  {0x81C5, 0xACBE}, //121 #HANGUL SYLLABLE KIYEOK YEO CIEUC
  {0x81C6, 0xACBF}, //122 #HANGUL SYLLABLE KIYEOK YEO CHIEUCH
  {0x81C7, 0xACC0}, //123 #HANGUL SYLLABLE KIYEOK YEO KHIEUKH
  {0x81C8, 0xACC2}, //124 #HANGUL SYLLABLE KIYEOK YEO PHIEUPH
  {0x81C9, 0xACC3}, //125 #HANGUL SYLLABLE KIYEOK YEO HIEUH
  {0x81CA, 0xACC5}, //126 #HANGUL SYLLABLE KIYEOK YE KIYEOK
  {0x81CB, 0xACC6}, //127 #HANGUL SYLLABLE KIYEOK YE SSANGKIYEOK
  {0x81CC, 0xACC7}, //128 #HANGUL SYLLABLE KIYEOK YE KIYEOKSIOS
  {0x81CD, 0xACC9}, //129 #HANGUL SYLLABLE KIYEOK YE NIEUNCIEUC
  {0x81CE, 0xACCA}, //130 #HANGUL SYLLABLE KIYEOK YE NIEUNHIEUH
  {0x81CF, 0xACCB}, //131 #HANGUL SYLLABLE KIYEOK YE TIKEUT
  {0x81D0, 0xACCD}, //132 #HANGUL SYLLABLE KIYEOK YE RIEULKIYEOK
  {0x81D1, 0xACCE}, //133 #HANGUL SYLLABLE KIYEOK YE RIEULMIEUM
  {0x81D2, 0xACCF}, //134 #HANGUL SYLLABLE KIYEOK YE RIEULPIEUP
  {0x81D3, 0xACD0}, //135 #HANGUL SYLLABLE KIYEOK YE RIEULSIOS
  {0x81D4, 0xACD1}, //136 #HANGUL SYLLABLE KIYEOK YE RIEULTHIEUTH
  {0x81D5, 0xACD2}, //137 #HANGUL SYLLABLE KIYEOK YE RIEULPHIEUPH
  {0x81D6, 0xACD3}, //138 #HANGUL SYLLABLE KIYEOK YE RIEULHIEUH
  {0x81D7, 0xACD4}, //139 #HANGUL SYLLABLE KIYEOK YE MIEUM
  {0x81D8, 0xACD6}, //140 #HANGUL SYLLABLE KIYEOK YE PIEUPSIOS
  {0x81D9, 0xACD8}, //141 #HANGUL SYLLABLE KIYEOK YE SSANGSIOS
  {0x81DA, 0xACD9}, //142 #HANGUL SYLLABLE KIYEOK YE IEUNG
  {0x81DB, 0xACDA}, //143 #HANGUL SYLLABLE KIYEOK YE CIEUC
  {0x81DC, 0xACDB}, //144 #HANGUL SYLLABLE KIYEOK YE CHIEUCH
  {0x81DD, 0xACDC}, //145 #HANGUL SYLLABLE KIYEOK YE KHIEUKH
  {0x81DE, 0xACDD}, //146 #HANGUL SYLLABLE KIYEOK YE THIEUTH
  {0x81DF, 0xACDE}, //147 #HANGUL SYLLABLE KIYEOK YE PHIEUPH
  {0x81E0, 0xACDF}, //148 #HANGUL SYLLABLE KIYEOK YE HIEUH
  {0x81E1, 0xACE2}, //149 #HANGUL SYLLABLE KIYEOK O SSANGKIYEOK
  {0x81E2, 0xACE3}, //150 #HANGUL SYLLABLE KIYEOK O KIYEOKSIOS
  {0x81E3, 0xACE5}, //151 #HANGUL SYLLABLE KIYEOK O NIEUNCIEUC
  {0x81E4, 0xACE6}, //152 #HANGUL SYLLABLE KIYEOK O NIEUNHIEUH
  {0x81E5, 0xACE9}, //153 #HANGUL SYLLABLE KIYEOK O RIEULKIYEOK
  {0x81E6, 0xACEB}, //154 #HANGUL SYLLABLE KIYEOK O RIEULPIEUP
  {0x81E7, 0xACED}, //155 #HANGUL SYLLABLE KIYEOK O RIEULTHIEUTH
  {0x81E8, 0xACEE}, //156 #HANGUL SYLLABLE KIYEOK O RIEULPHIEUPH
  {0x81E9, 0xACF2}, //157 #HANGUL SYLLABLE KIYEOK O PIEUPSIOS
  {0x81EA, 0xACF4}, //158 #HANGUL SYLLABLE KIYEOK O SSANGSIOS
  {0x81EB, 0xACF7}, //159 #HANGUL SYLLABLE KIYEOK O CHIEUCH
  {0x81EC, 0xACF8}, //160 #HANGUL SYLLABLE KIYEOK O KHIEUKH
  {0x81ED, 0xACF9}, //161 #HANGUL SYLLABLE KIYEOK O THIEUTH
  {0x81EE, 0xACFA}, //162 #HANGUL SYLLABLE KIYEOK O PHIEUPH
  {0x81EF, 0xACFB}, //163 #HANGUL SYLLABLE KIYEOK O HIEUH
  {0x81F0, 0xACFE}, //164 #HANGUL SYLLABLE KIYEOK WA SSANGKIYEOK
  {0x81F1, 0xACFF}, //165 #HANGUL SYLLABLE KIYEOK WA KIYEOKSIOS
  {0x81F2, 0xAD01}, //166 #HANGUL SYLLABLE KIYEOK WA NIEUNCIEUC
  {0x81F3, 0xAD02}, //167 #HANGUL SYLLABLE KIYEOK WA NIEUNHIEUH
  {0x81F4, 0xAD03}, //168 #HANGUL SYLLABLE KIYEOK WA TIKEUT
  {0x81F5, 0xAD05}, //169 #HANGUL SYLLABLE KIYEOK WA RIEULKIYEOK
  {0x81F6, 0xAD07}, //170 #HANGUL SYLLABLE KIYEOK WA RIEULPIEUP
  {0x81F7, 0xAD08}, //171 #HANGUL SYLLABLE KIYEOK WA RIEULSIOS
  {0x81F8, 0xAD09}, //172 #HANGUL SYLLABLE KIYEOK WA RIEULTHIEUTH
  {0x81F9, 0xAD0A}, //173 #HANGUL SYLLABLE KIYEOK WA RIEULPHIEUPH
  {0x81FA, 0xAD0B}, //174 #HANGUL SYLLABLE KIYEOK WA RIEULHIEUH
  {0x81FB, 0xAD0E}, //175 #HANGUL SYLLABLE KIYEOK WA PIEUPSIOS
  {0x81FC, 0xAD10}, //176 #HANGUL SYLLABLE KIYEOK WA SSANGSIOS
  {0x81FD, 0xAD12}, //177 #HANGUL SYLLABLE KIYEOK WA CIEUC
  {0x81FE, 0xAD13}, //178 #HANGUL SYLLABLE KIYEOK WA CHIEUCH
  {0x8241, 0xAD14}, //179 #HANGUL SYLLABLE KIYEOK WA KHIEUKH
  {0x8242, 0xAD15}, //180 #HANGUL SYLLABLE KIYEOK WA THIEUTH
  {0x8243, 0xAD16}, //181 #HANGUL SYLLABLE KIYEOK WA PHIEUPH
  {0x8244, 0xAD17}, //182 #HANGUL SYLLABLE KIYEOK WA HIEUH
  {0x8245, 0xAD19}, //183 #HANGUL SYLLABLE KIYEOK WAE KIYEOK
  {0x8246, 0xAD1A}, //184 #HANGUL SYLLABLE KIYEOK WAE SSANGKIYEOK
  {0x8247, 0xAD1B}, //185 #HANGUL SYLLABLE KIYEOK WAE KIYEOKSIOS
  {0x8248, 0xAD1D}, //186 #HANGUL SYLLABLE KIYEOK WAE NIEUNCIEUC
  {0x8249, 0xAD1E}, //187 #HANGUL SYLLABLE KIYEOK WAE NIEUNHIEUH
  {0x824A, 0xAD1F}, //188 #HANGUL SYLLABLE KIYEOK WAE TIKEUT
  {0x824B, 0xAD21}, //189 #HANGUL SYLLABLE KIYEOK WAE RIEULKIYEOK
  {0x824C, 0xAD22}, //190 #HANGUL SYLLABLE KIYEOK WAE RIEULMIEUM
  {0x824D, 0xAD23}, //191 #HANGUL SYLLABLE KIYEOK WAE RIEULPIEUP
  {0x824E, 0xAD24}, //192 #HANGUL SYLLABLE KIYEOK WAE RIEULSIOS
  {0x824F, 0xAD25}, //193 #HANGUL SYLLABLE KIYEOK WAE RIEULTHIEUTH
  {0x8250, 0xAD26}, //194 #HANGUL SYLLABLE KIYEOK WAE RIEULPHIEUPH
  {0x8251, 0xAD27}, //195 #HANGUL SYLLABLE KIYEOK WAE RIEULHIEUH
  {0x8252, 0xAD28}, //196 #HANGUL SYLLABLE KIYEOK WAE MIEUM
  {0x8253, 0xAD2A}, //197 #HANGUL SYLLABLE KIYEOK WAE PIEUPSIOS
  {0x8254, 0xAD2B}, //198 #HANGUL SYLLABLE KIYEOK WAE SIOS
  {0x8255, 0xAD2E}, //199 #HANGUL SYLLABLE KIYEOK WAE CIEUC
  {0x8256, 0xAD2F}, //200 #HANGUL SYLLABLE KIYEOK WAE CHIEUCH
  {0x8257, 0xAD30}, //201 #HANGUL SYLLABLE KIYEOK WAE KHIEUKH
  {0x8258, 0xAD31}, //202 #HANGUL SYLLABLE KIYEOK WAE THIEUTH
  {0x8259, 0xAD32}, //203 #HANGUL SYLLABLE KIYEOK WAE PHIEUPH
  {0x825A, 0xAD33}, //204 #HANGUL SYLLABLE KIYEOK WAE HIEUH
  {0x8261, 0xAD36}, //205 #HANGUL SYLLABLE KIYEOK OE SSANGKIYEOK
  {0x8262, 0xAD37}, //206 #HANGUL SYLLABLE KIYEOK OE KIYEOKSIOS
  {0x8263, 0xAD39}, //207 #HANGUL SYLLABLE KIYEOK OE NIEUNCIEUC
  {0x8264, 0xAD3A}, //208 #HANGUL SYLLABLE KIYEOK OE NIEUNHIEUH
  {0x8265, 0xAD3B}, //209 #HANGUL SYLLABLE KIYEOK OE TIKEUT
  {0x8266, 0xAD3D}, //210 #HANGUL SYLLABLE KIYEOK OE RIEULKIYEOK
  {0x8267, 0xAD3E}, //211 #HANGUL SYLLABLE KIYEOK OE RIEULMIEUM
  {0x8268, 0xAD3F}, //212 #HANGUL SYLLABLE KIYEOK OE RIEULPIEUP
  {0x8269, 0xAD40}, //213 #HANGUL SYLLABLE KIYEOK OE RIEULSIOS
  {0x826A, 0xAD41}, //214 #HANGUL SYLLABLE KIYEOK OE RIEULTHIEUTH
  {0x826B, 0xAD42}, //215 #HANGUL SYLLABLE KIYEOK OE RIEULPHIEUPH
  {0x826C, 0xAD43}, //216 #HANGUL SYLLABLE KIYEOK OE RIEULHIEUH
  {0x826D, 0xAD46}, //217 #HANGUL SYLLABLE KIYEOK OE PIEUPSIOS
  {0x826E, 0xAD48}, //218 #HANGUL SYLLABLE KIYEOK OE SSANGSIOS
  {0x826F, 0xAD4A}, //219 #HANGUL SYLLABLE KIYEOK OE CIEUC
  {0x8270, 0xAD4B}, //220 #HANGUL SYLLABLE KIYEOK OE CHIEUCH
  {0x8271, 0xAD4C}, //221 #HANGUL SYLLABLE KIYEOK OE KHIEUKH
  {0x8272, 0xAD4D}, //222 #HANGUL SYLLABLE KIYEOK OE THIEUTH
  {0x8273, 0xAD4E}, //223 #HANGUL SYLLABLE KIYEOK OE PHIEUPH
  {0x8274, 0xAD4F}, //224 #HANGUL SYLLABLE KIYEOK OE HIEUH
  {0x8275, 0xAD51}, //225 #HANGUL SYLLABLE KIYEOK YO KIYEOK
  {0x8276, 0xAD52}, //226 #HANGUL SYLLABLE KIYEOK YO SSANGKIYEOK
  {0x8277, 0xAD53}, //227 #HANGUL SYLLABLE KIYEOK YO KIYEOKSIOS
  {0x8278, 0xAD55}, //228 #HANGUL SYLLABLE KIYEOK YO NIEUNCIEUC
  {0x8279, 0xAD56}, //229 #HANGUL SYLLABLE KIYEOK YO NIEUNHIEUH
  {0x827A, 0xAD57}, //230 #HANGUL SYLLABLE KIYEOK YO TIKEUT
  {0x8281, 0xAD59}, //231 #HANGUL SYLLABLE KIYEOK YO RIEULKIYEOK
  {0x8282, 0xAD5A}, //232 #HANGUL SYLLABLE KIYEOK YO RIEULMIEUM
  {0x8283, 0xAD5B}, //233 #HANGUL SYLLABLE KIYEOK YO RIEULPIEUP
  {0x8284, 0xAD5C}, //234 #HANGUL SYLLABLE KIYEOK YO RIEULSIOS
  {0x8285, 0xAD5D}, //235 #HANGUL SYLLABLE KIYEOK YO RIEULTHIEUTH
  {0x8286, 0xAD5E}, //236 #HANGUL SYLLABLE KIYEOK YO RIEULPHIEUPH
  {0x8287, 0xAD5F}, //237 #HANGUL SYLLABLE KIYEOK YO RIEULHIEUH
  {0x8288, 0xAD60}, //238 #HANGUL SYLLABLE KIYEOK YO MIEUM
  {0x8289, 0xAD62}, //239 #HANGUL SYLLABLE KIYEOK YO PIEUPSIOS
  {0x828A, 0xAD64}, //240 #HANGUL SYLLABLE KIYEOK YO SSANGSIOS
  {0x828B, 0xAD65}, //241 #HANGUL SYLLABLE KIYEOK YO IEUNG
  {0x828C, 0xAD66}, //242 #HANGUL SYLLABLE KIYEOK YO CIEUC
  {0x828D, 0xAD67}, //243 #HANGUL SYLLABLE KIYEOK YO CHIEUCH
  {0x828E, 0xAD68}, //244 #HANGUL SYLLABLE KIYEOK YO KHIEUKH
  {0x828F, 0xAD69}, //245 #HANGUL SYLLABLE KIYEOK YO THIEUTH
  {0x8290, 0xAD6A}, //246 #HANGUL SYLLABLE KIYEOK YO PHIEUPH
  {0x8291, 0xAD6B}, //247 #HANGUL SYLLABLE KIYEOK YO HIEUH
  {0x8292, 0xAD6E}, //248 #HANGUL SYLLABLE KIYEOK U SSANGKIYEOK
  {0x8293, 0xAD6F}, //249 #HANGUL SYLLABLE KIYEOK U KIYEOKSIOS
  {0x8294, 0xAD71}, //250 #HANGUL SYLLABLE KIYEOK U NIEUNCIEUC
  {0x8295, 0xAD72}, //251 #HANGUL SYLLABLE KIYEOK U NIEUNHIEUH
  {0x8296, 0xAD77}, //252 #HANGUL SYLLABLE KIYEOK U RIEULPIEUP
  {0x8297, 0xAD78}, //253 #HANGUL SYLLABLE KIYEOK U RIEULSIOS
  {0x8298, 0xAD79}, //254 #HANGUL SYLLABLE KIYEOK U RIEULTHIEUTH
  {0x8299, 0xAD7A}, //255 #HANGUL SYLLABLE KIYEOK U RIEULPHIEUPH
  {0x829A, 0xAD7E}, //256 #HANGUL SYLLABLE KIYEOK U PIEUPSIOS
  {0x829B, 0xAD80}, //257 #HANGUL SYLLABLE KIYEOK U SSANGSIOS
  {0x829C, 0xAD83}, //258 #HANGUL SYLLABLE KIYEOK U CHIEUCH
  {0x829D, 0xAD84}, //259 #HANGUL SYLLABLE KIYEOK U KHIEUKH
  {0x829E, 0xAD85}, //260 #HANGUL SYLLABLE KIYEOK U THIEUTH
  {0x829F, 0xAD86}, //261 #HANGUL SYLLABLE KIYEOK U PHIEUPH
  {0x82A0, 0xAD87}, //262 #HANGUL SYLLABLE KIYEOK U HIEUH
  {0x82A1, 0xAD8A}, //263 #HANGUL SYLLABLE KIYEOK WEO SSANGKIYEOK
  {0x82A2, 0xAD8B}, //264 #HANGUL SYLLABLE KIYEOK WEO KIYEOKSIOS
  {0x82A3, 0xAD8D}, //265 #HANGUL SYLLABLE KIYEOK WEO NIEUNCIEUC
  {0x82A4, 0xAD8E}, //266 #HANGUL SYLLABLE KIYEOK WEO NIEUNHIEUH
  {0x82A5, 0xAD8F}, //267 #HANGUL SYLLABLE KIYEOK WEO TIKEUT
  {0x82A6, 0xAD91}, //268 #HANGUL SYLLABLE KIYEOK WEO RIEULKIYEOK
  {0x82A7, 0xAD92}, //269 #HANGUL SYLLABLE KIYEOK WEO RIEULMIEUM
  {0x82A8, 0xAD93}, //270 #HANGUL SYLLABLE KIYEOK WEO RIEULPIEUP
  {0x82A9, 0xAD94}, //271 #HANGUL SYLLABLE KIYEOK WEO RIEULSIOS
  {0x82AA, 0xAD95}, //272 #HANGUL SYLLABLE KIYEOK WEO RIEULTHIEUTH
  {0x82AB, 0xAD96}, //273 #HANGUL SYLLABLE KIYEOK WEO RIEULPHIEUPH
  {0x82AC, 0xAD97}, //274 #HANGUL SYLLABLE KIYEOK WEO RIEULHIEUH
  {0x82AD, 0xAD98}, //275 #HANGUL SYLLABLE KIYEOK WEO MIEUM
  {0x82AE, 0xAD99}, //276 #HANGUL SYLLABLE KIYEOK WEO PIEUP
  {0x82AF, 0xAD9A}, //277 #HANGUL SYLLABLE KIYEOK WEO PIEUPSIOS
  {0x82B0, 0xAD9B}, //278 #HANGUL SYLLABLE KIYEOK WEO SIOS
  {0x82B1, 0xAD9E}, //279 #HANGUL SYLLABLE KIYEOK WEO CIEUC
  {0x82B2, 0xAD9F}, //280 #HANGUL SYLLABLE KIYEOK WEO CHIEUCH
  {0x82B3, 0xADA0}, //281 #HANGUL SYLLABLE KIYEOK WEO KHIEUKH
  {0x82B4, 0xADA1}, //282 #HANGUL SYLLABLE KIYEOK WEO THIEUTH
  {0x82B5, 0xADA2}, //283 #HANGUL SYLLABLE KIYEOK WEO PHIEUPH
  {0x82B6, 0xADA3}, //284 #HANGUL SYLLABLE KIYEOK WEO HIEUH
  {0x82B7, 0xADA5}, //285 #HANGUL SYLLABLE KIYEOK WE KIYEOK
  {0x82B8, 0xADA6}, //286 #HANGUL SYLLABLE KIYEOK WE SSANGKIYEOK
  {0x82B9, 0xADA7}, //287 #HANGUL SYLLABLE KIYEOK WE KIYEOKSIOS
  {0x82BA, 0xADA8}, //288 #HANGUL SYLLABLE KIYEOK WE NIEUN
  {0x82BB, 0xADA9}, //289 #HANGUL SYLLABLE KIYEOK WE NIEUNCIEUC
  {0x82BC, 0xADAA}, //290 #HANGUL SYLLABLE KIYEOK WE NIEUNHIEUH
  {0x82BD, 0xADAB}, //291 #HANGUL SYLLABLE KIYEOK WE TIKEUT
  {0x82BE, 0xADAC}, //292 #HANGUL SYLLABLE KIYEOK WE RIEUL
  {0x82BF, 0xADAD}, //293 #HANGUL SYLLABLE KIYEOK WE RIEULKIYEOK
  {0x82C0, 0xADAE}, //294 #HANGUL SYLLABLE KIYEOK WE RIEULMIEUM
  {0x82C1, 0xADAF}, //295 #HANGUL SYLLABLE KIYEOK WE RIEULPIEUP
  {0x82C2, 0xADB0}, //296 #HANGUL SYLLABLE KIYEOK WE RIEULSIOS
  {0x82C3, 0xADB1}, //297 #HANGUL SYLLABLE KIYEOK WE RIEULTHIEUTH
  {0x82C4, 0xADB2}, //298 #HANGUL SYLLABLE KIYEOK WE RIEULPHIEUPH
  {0x82C5, 0xADB3}, //299 #HANGUL SYLLABLE KIYEOK WE RIEULHIEUH
  {0x82C6, 0xADB4}, //300 #HANGUL SYLLABLE KIYEOK WE MIEUM
  {0x82C7, 0xADB5}, //301 #HANGUL SYLLABLE KIYEOK WE PIEUP
  {0x82C8, 0xADB6}, //302 #HANGUL SYLLABLE KIYEOK WE PIEUPSIOS
  {0x82C9, 0xADB8}, //303 #HANGUL SYLLABLE KIYEOK WE SSANGSIOS
  {0x82CA, 0xADB9}, //304 #HANGUL SYLLABLE KIYEOK WE IEUNG
  {0x82CB, 0xADBA}, //305 #HANGUL SYLLABLE KIYEOK WE CIEUC
  {0x82CC, 0xADBB}, //306 #HANGUL SYLLABLE KIYEOK WE CHIEUCH
  {0x82CD, 0xADBC}, //307 #HANGUL SYLLABLE KIYEOK WE KHIEUKH
  {0x82CE, 0xADBD}, //308 #HANGUL SYLLABLE KIYEOK WE THIEUTH
  {0x82CF, 0xADBE}, //309 #HANGUL SYLLABLE KIYEOK WE PHIEUPH
  {0x82D0, 0xADBF}, //310 #HANGUL SYLLABLE KIYEOK WE HIEUH
  {0x82D1, 0xADC2}, //311 #HANGUL SYLLABLE KIYEOK WI SSANGKIYEOK
  {0x82D2, 0xADC3}, //312 #HANGUL SYLLABLE KIYEOK WI KIYEOKSIOS
  {0x82D3, 0xADC5}, //313 #HANGUL SYLLABLE KIYEOK WI NIEUNCIEUC
  {0x82D4, 0xADC6}, //314 #HANGUL SYLLABLE KIYEOK WI NIEUNHIEUH
  {0x82D5, 0xADC7}, //315 #HANGUL SYLLABLE KIYEOK WI TIKEUT
  {0x82D6, 0xADC9}, //316 #HANGUL SYLLABLE KIYEOK WI RIEULKIYEOK
  {0x82D7, 0xADCA}, //317 #HANGUL SYLLABLE KIYEOK WI RIEULMIEUM
  {0x82D8, 0xADCB}, //318 #HANGUL SYLLABLE KIYEOK WI RIEULPIEUP
  {0x82D9, 0xADCC}, //319 #HANGUL SYLLABLE KIYEOK WI RIEULSIOS
  {0x82DA, 0xADCD}, //320 #HANGUL SYLLABLE KIYEOK WI RIEULTHIEUTH
  {0x82DB, 0xADCE}, //321 #HANGUL SYLLABLE KIYEOK WI RIEULPHIEUPH
  {0x82DC, 0xADCF}, //322 #HANGUL SYLLABLE KIYEOK WI RIEULHIEUH
  {0x82DD, 0xADD2}, //323 #HANGUL SYLLABLE KIYEOK WI PIEUPSIOS
  {0x82DE, 0xADD4}, //324 #HANGUL SYLLABLE KIYEOK WI SSANGSIOS
  {0x82DF, 0xADD5}, //325 #HANGUL SYLLABLE KIYEOK WI IEUNG
  {0x82E0, 0xADD6}, //326 #HANGUL SYLLABLE KIYEOK WI CIEUC
  {0x82E1, 0xADD7}, //327 #HANGUL SYLLABLE KIYEOK WI CHIEUCH
  {0x82E2, 0xADD8}, //328 #HANGUL SYLLABLE KIYEOK WI KHIEUKH
  {0x82E3, 0xADD9}, //329 #HANGUL SYLLABLE KIYEOK WI THIEUTH
  {0x82E4, 0xADDA}, //330 #HANGUL SYLLABLE KIYEOK WI PHIEUPH
  {0x82E5, 0xADDB}, //331 #HANGUL SYLLABLE KIYEOK WI HIEUH
  {0x82E6, 0xADDD}, //332 #HANGUL SYLLABLE KIYEOK YU KIYEOK
  {0x82E7, 0xADDE}, //333 #HANGUL SYLLABLE KIYEOK YU SSANGKIYEOK
  {0x82E8, 0xADDF}, //334 #HANGUL SYLLABLE KIYEOK YU KIYEOKSIOS
  {0x82E9, 0xADE1}, //335 #HANGUL SYLLABLE KIYEOK YU NIEUNCIEUC
  {0x82EA, 0xADE2}, //336 #HANGUL SYLLABLE KIYEOK YU NIEUNHIEUH
  {0x82EB, 0xADE3}, //337 #HANGUL SYLLABLE KIYEOK YU TIKEUT
  {0x82EC, 0xADE5}, //338 #HANGUL SYLLABLE KIYEOK YU RIEULKIYEOK
  {0x82ED, 0xADE6}, //339 #HANGUL SYLLABLE KIYEOK YU RIEULMIEUM
  {0x82EE, 0xADE7}, //340 #HANGUL SYLLABLE KIYEOK YU RIEULPIEUP
  {0x82EF, 0xADE8}, //341 #HANGUL SYLLABLE KIYEOK YU RIEULSIOS
  {0x82F0, 0xADE9}, //342 #HANGUL SYLLABLE KIYEOK YU RIEULTHIEUTH
  {0x82F1, 0xADEA}, //343 #HANGUL SYLLABLE KIYEOK YU RIEULPHIEUPH
  {0x82F2, 0xADEB}, //344 #HANGUL SYLLABLE KIYEOK YU RIEULHIEUH
  {0x82F3, 0xADEC}, //345 #HANGUL SYLLABLE KIYEOK YU MIEUM
  {0x82F4, 0xADED}, //346 #HANGUL SYLLABLE KIYEOK YU PIEUP
  {0x82F5, 0xADEE}, //347 #HANGUL SYLLABLE KIYEOK YU PIEUPSIOS
  {0x82F6, 0xADEF}, //348 #HANGUL SYLLABLE KIYEOK YU SIOS
  {0x82F7, 0xADF0}, //349 #HANGUL SYLLABLE KIYEOK YU SSANGSIOS
  {0x82F8, 0xADF1}, //350 #HANGUL SYLLABLE KIYEOK YU IEUNG
  {0x82F9, 0xADF2}, //351 #HANGUL SYLLABLE KIYEOK YU CIEUC
  {0x82FA, 0xADF3}, //352 #HANGUL SYLLABLE KIYEOK YU CHIEUCH
  {0x82FB, 0xADF4}, //353 #HANGUL SYLLABLE KIYEOK YU KHIEUKH
  {0x82FC, 0xADF5}, //354 #HANGUL SYLLABLE KIYEOK YU THIEUTH
  {0x82FD, 0xADF6}, //355 #HANGUL SYLLABLE KIYEOK YU PHIEUPH
  {0x82FE, 0xADF7}, //356 #HANGUL SYLLABLE KIYEOK YU HIEUH
  {0x8341, 0xADFA}, //357 #HANGUL SYLLABLE KIYEOK EU SSANGKIYEOK
  {0x8342, 0xADFB}, //358 #HANGUL SYLLABLE KIYEOK EU KIYEOKSIOS
  {0x8343, 0xADFD}, //359 #HANGUL SYLLABLE KIYEOK EU NIEUNCIEUC
  {0x8344, 0xADFE}, //360 #HANGUL SYLLABLE KIYEOK EU NIEUNHIEUH
  {0x8345, 0xAE02}, //361 #HANGUL SYLLABLE KIYEOK EU RIEULMIEUM
  {0x8346, 0xAE03}, //362 #HANGUL SYLLABLE KIYEOK EU RIEULPIEUP
  {0x8347, 0xAE04}, //363 #HANGUL SYLLABLE KIYEOK EU RIEULSIOS
  {0x8348, 0xAE05}, //364 #HANGUL SYLLABLE KIYEOK EU RIEULTHIEUTH
  {0x8349, 0xAE06}, //365 #HANGUL SYLLABLE KIYEOK EU RIEULPHIEUPH
  {0x834A, 0xAE07}, //366 #HANGUL SYLLABLE KIYEOK EU RIEULHIEUH
  {0x834B, 0xAE0A}, //367 #HANGUL SYLLABLE KIYEOK EU PIEUPSIOS
  {0x834C, 0xAE0C}, //368 #HANGUL SYLLABLE KIYEOK EU SSANGSIOS
  {0x834D, 0xAE0E}, //369 #HANGUL SYLLABLE KIYEOK EU CIEUC
  {0x834E, 0xAE0F}, //370 #HANGUL SYLLABLE KIYEOK EU CHIEUCH
  {0x834F, 0xAE10}, //371 #HANGUL SYLLABLE KIYEOK EU KHIEUKH
  {0x8350, 0xAE11}, //372 #HANGUL SYLLABLE KIYEOK EU THIEUTH
  {0x8351, 0xAE12}, //373 #HANGUL SYLLABLE KIYEOK EU PHIEUPH
  {0x8352, 0xAE13}, //374 #HANGUL SYLLABLE KIYEOK EU HIEUH
  {0x8353, 0xAE15}, //375 #HANGUL SYLLABLE KIYEOK YI KIYEOK
  {0x8354, 0xAE16}, //376 #HANGUL SYLLABLE KIYEOK YI SSANGKIYEOK
  {0x8355, 0xAE17}, //377 #HANGUL SYLLABLE KIYEOK YI KIYEOKSIOS
  {0x8356, 0xAE18}, //378 #HANGUL SYLLABLE KIYEOK YI NIEUN
  {0x8357, 0xAE19}, //379 #HANGUL SYLLABLE KIYEOK YI NIEUNCIEUC
  {0x8358, 0xAE1A}, //380 #HANGUL SYLLABLE KIYEOK YI NIEUNHIEUH
  {0x8359, 0xAE1B}, //381 #HANGUL SYLLABLE KIYEOK YI TIKEUT
  {0x835A, 0xAE1C}, //382 #HANGUL SYLLABLE KIYEOK YI RIEUL
  {0x8361, 0xAE1D}, //383 #HANGUL SYLLABLE KIYEOK YI RIEULKIYEOK
  {0x8362, 0xAE1E}, //384 #HANGUL SYLLABLE KIYEOK YI RIEULMIEUM
  {0x8363, 0xAE1F}, //385 #HANGUL SYLLABLE KIYEOK YI RIEULPIEUP
  {0x8364, 0xAE20}, //386 #HANGUL SYLLABLE KIYEOK YI RIEULSIOS
  {0x8365, 0xAE21}, //387 #HANGUL SYLLABLE KIYEOK YI RIEULTHIEUTH
  {0x8366, 0xAE22}, //388 #HANGUL SYLLABLE KIYEOK YI RIEULPHIEUPH
  {0x8367, 0xAE23}, //389 #HANGUL SYLLABLE KIYEOK YI RIEULHIEUH
  {0x8368, 0xAE24}, //390 #HANGUL SYLLABLE KIYEOK YI MIEUM
  {0x8369, 0xAE25}, //391 #HANGUL SYLLABLE KIYEOK YI PIEUP
  {0x836A, 0xAE26}, //392 #HANGUL SYLLABLE KIYEOK YI PIEUPSIOS
  {0x836B, 0xAE27}, //393 #HANGUL SYLLABLE KIYEOK YI SIOS
  {0x836C, 0xAE28}, //394 #HANGUL SYLLABLE KIYEOK YI SSANGSIOS
  {0x836D, 0xAE29}, //395 #HANGUL SYLLABLE KIYEOK YI IEUNG
  {0x836E, 0xAE2A}, //396 #HANGUL SYLLABLE KIYEOK YI CIEUC
  {0x836F, 0xAE2B}, //397 #HANGUL SYLLABLE KIYEOK YI CHIEUCH
  {0x8370, 0xAE2C}, //398 #HANGUL SYLLABLE KIYEOK YI KHIEUKH
  {0x8371, 0xAE2D}, //399 #HANGUL SYLLABLE KIYEOK YI THIEUTH
  {0x8372, 0xAE2E}, //400 #HANGUL SYLLABLE KIYEOK YI PHIEUPH
  {0x8373, 0xAE2F}, //401 #HANGUL SYLLABLE KIYEOK YI HIEUH
  {0x8374, 0xAE32}, //402 #HANGUL SYLLABLE KIYEOK I SSANGKIYEOK
  {0x8375, 0xAE33}, //403 #HANGUL SYLLABLE KIYEOK I KIYEOKSIOS
  {0x8376, 0xAE35}, //404 #HANGUL SYLLABLE KIYEOK I NIEUNCIEUC
  {0x8377, 0xAE36}, //405 #HANGUL SYLLABLE KIYEOK I NIEUNHIEUH
  {0x8378, 0xAE39}, //406 #HANGUL SYLLABLE KIYEOK I RIEULKIYEOK
  {0x8379, 0xAE3B}, //407 #HANGUL SYLLABLE KIYEOK I RIEULPIEUP
  {0x837A, 0xAE3C}, //408 #HANGUL SYLLABLE KIYEOK I RIEULSIOS
  {0x8381, 0xAE3D}, //409 #HANGUL SYLLABLE KIYEOK I RIEULTHIEUTH
  {0x8382, 0xAE3E}, //410 #HANGUL SYLLABLE KIYEOK I RIEULPHIEUPH
  {0x8383, 0xAE3F}, //411 #HANGUL SYLLABLE KIYEOK I RIEULHIEUH
  {0x8384, 0xAE42}, //412 #HANGUL SYLLABLE KIYEOK I PIEUPSIOS
  {0x8385, 0xAE44}, //413 #HANGUL SYLLABLE KIYEOK I SSANGSIOS
  {0x8386, 0xAE47}, //414 #HANGUL SYLLABLE KIYEOK I CHIEUCH
  {0x8387, 0xAE48}, //415 #HANGUL SYLLABLE KIYEOK I KHIEUKH
  {0x8388, 0xAE49}, //416 #HANGUL SYLLABLE KIYEOK I THIEUTH
  {0x8389, 0xAE4B}, //417 #HANGUL SYLLABLE KIYEOK I HIEUH
  {0x838A, 0xAE4F}, //418 #HANGUL SYLLABLE SSANGKIYEOK A KIYEOKSIOS
  {0x838B, 0xAE51}, //419 #HANGUL SYLLABLE SSANGKIYEOK A NIEUNCIEUC
  {0x838C, 0xAE52}, //420 #HANGUL SYLLABLE SSANGKIYEOK A NIEUNHIEUH
  {0x838D, 0xAE53}, //421 #HANGUL SYLLABLE SSANGKIYEOK A TIKEUT
  {0x838E, 0xAE55}, //422 #HANGUL SYLLABLE SSANGKIYEOK A RIEULKIYEOK
  {0x838F, 0xAE57}, //423 #HANGUL SYLLABLE SSANGKIYEOK A RIEULPIEUP
  {0x8390, 0xAE58}, //424 #HANGUL SYLLABLE SSANGKIYEOK A RIEULSIOS
  {0x8391, 0xAE59}, //425 #HANGUL SYLLABLE SSANGKIYEOK A RIEULTHIEUTH
  {0x8392, 0xAE5A}, //426 #HANGUL SYLLABLE SSANGKIYEOK A RIEULPHIEUPH
  {0x8393, 0xAE5B}, //427 #HANGUL SYLLABLE SSANGKIYEOK A RIEULHIEUH
  {0x8394, 0xAE5E}, //428 #HANGUL SYLLABLE SSANGKIYEOK A PIEUPSIOS
  {0x8395, 0xAE62}, //429 #HANGUL SYLLABLE SSANGKIYEOK A CIEUC
  {0x8396, 0xAE63}, //430 #HANGUL SYLLABLE SSANGKIYEOK A CHIEUCH
  {0x8397, 0xAE64}, //431 #HANGUL SYLLABLE SSANGKIYEOK A KHIEUKH
  {0x8398, 0xAE66}, //432 #HANGUL SYLLABLE SSANGKIYEOK A PHIEUPH
  {0x8399, 0xAE67}, //433 #HANGUL SYLLABLE SSANGKIYEOK A HIEUH
  {0x839A, 0xAE6A}, //434 #HANGUL SYLLABLE SSANGKIYEOK AE SSANGKIYEOK
  {0x839B, 0xAE6B}, //435 #HANGUL SYLLABLE SSANGKIYEOK AE KIYEOKSIOS
  {0x839C, 0xAE6D}, //436 #HANGUL SYLLABLE SSANGKIYEOK AE NIEUNCIEUC
  {0x839D, 0xAE6E}, //437 #HANGUL SYLLABLE SSANGKIYEOK AE NIEUNHIEUH
  {0x839E, 0xAE6F}, //438 #HANGUL SYLLABLE SSANGKIYEOK AE TIKEUT
  {0x839F, 0xAE71}, //439 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULKIYEOK
  {0x83A0, 0xAE72}, //440 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULMIEUM
  {0x83A1, 0xAE73}, //441 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULPIEUP
  {0x83A2, 0xAE74}, //442 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULSIOS
  {0x83A3, 0xAE75}, //443 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULTHIEUTH
  {0x83A4, 0xAE76}, //444 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULPHIEUPH
  {0x83A5, 0xAE77}, //445 #HANGUL SYLLABLE SSANGKIYEOK AE RIEULHIEUH
  {0x83A6, 0xAE7A}, //446 #HANGUL SYLLABLE SSANGKIYEOK AE PIEUPSIOS
  {0x83A7, 0xAE7E}, //447 #HANGUL SYLLABLE SSANGKIYEOK AE CIEUC
  {0x83A8, 0xAE7F}, //448 #HANGUL SYLLABLE SSANGKIYEOK AE CHIEUCH
  {0x83A9, 0xAE80}, //449 #HANGUL SYLLABLE SSANGKIYEOK AE KHIEUKH
  {0x83AA, 0xAE81}, //450 #HANGUL SYLLABLE SSANGKIYEOK AE THIEUTH
  {0x83AB, 0xAE82}, //451 #HANGUL SYLLABLE SSANGKIYEOK AE PHIEUPH
  {0x83AC, 0xAE83}, //452 #HANGUL SYLLABLE SSANGKIYEOK AE HIEUH
  {0x83AD, 0xAE86}, //453 #HANGUL SYLLABLE SSANGKIYEOK YA SSANGKIYEOK
  {0x83AE, 0xAE87}, //454 #HANGUL SYLLABLE SSANGKIYEOK YA KIYEOKSIOS
  {0x83AF, 0xAE88}, //455 #HANGUL SYLLABLE SSANGKIYEOK YA NIEUN
  {0x83B0, 0xAE89}, //456 #HANGUL SYLLABLE SSANGKIYEOK YA NIEUNCIEUC
  {0x83B1, 0xAE8A}, //457 #HANGUL SYLLABLE SSANGKIYEOK YA NIEUNHIEUH
  {0x83B2, 0xAE8B}, //458 #HANGUL SYLLABLE SSANGKIYEOK YA TIKEUT
  {0x83B3, 0xAE8D}, //459 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULKIYEOK
  {0x83B4, 0xAE8E}, //460 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULMIEUM
  {0x83B5, 0xAE8F}, //461 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULPIEUP
  {0x83B6, 0xAE90}, //462 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULSIOS
  {0x83B7, 0xAE91}, //463 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULTHIEUTH
  {0x83B8, 0xAE92}, //464 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULPHIEUPH
  {0x83B9, 0xAE93}, //465 #HANGUL SYLLABLE SSANGKIYEOK YA RIEULHIEUH
  {0x83BA, 0xAE94}, //466 #HANGUL SYLLABLE SSANGKIYEOK YA MIEUM
  {0x83BB, 0xAE95}, //467 #HANGUL SYLLABLE SSANGKIYEOK YA PIEUP
  {0x83BC, 0xAE96}, //468 #HANGUL SYLLABLE SSANGKIYEOK YA PIEUPSIOS
  {0x83BD, 0xAE97}, //469 #HANGUL SYLLABLE SSANGKIYEOK YA SIOS
  {0x83BE, 0xAE98}, //470 #HANGUL SYLLABLE SSANGKIYEOK YA SSANGSIOS
  {0x83BF, 0xAE99}, //471 #HANGUL SYLLABLE SSANGKIYEOK YA IEUNG
  {0x83C0, 0xAE9A}, //472 #HANGUL SYLLABLE SSANGKIYEOK YA CIEUC
  {0x83C1, 0xAE9B}, //473 #HANGUL SYLLABLE SSANGKIYEOK YA CHIEUCH
  {0x83C2, 0xAE9C}, //474 #HANGUL SYLLABLE SSANGKIYEOK YA KHIEUKH
  {0x83C3, 0xAE9D}, //475 #HANGUL SYLLABLE SSANGKIYEOK YA THIEUTH
  {0x83C4, 0xAE9E}, //476 #HANGUL SYLLABLE SSANGKIYEOK YA PHIEUPH
  {0x83C5, 0xAE9F}, //477 #HANGUL SYLLABLE SSANGKIYEOK YA HIEUH
  {0x83C6, 0xAEA0}, //478 #HANGUL SYLLABLE SSANGKIYEOK YAE
  {0x83C7, 0xAEA1}, //479 #HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOK
  {0x83C8, 0xAEA2}, //480 #HANGUL SYLLABLE SSANGKIYEOK YAE SSANGKIYEOK
  {0x83C9, 0xAEA3}, //481 #HANGUL SYLLABLE SSANGKIYEOK YAE KIYEOKSIOS
  {0x83CA, 0xAEA4}, //482 #HANGUL SYLLABLE SSANGKIYEOK YAE NIEUN
  {0x83CB, 0xAEA5}, //483 #HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNCIEUC
  {0x83CC, 0xAEA6}, //484 #HANGUL SYLLABLE SSANGKIYEOK YAE NIEUNHIEUH
  {0x83CD, 0xAEA7}, //485 #HANGUL SYLLABLE SSANGKIYEOK YAE TIKEUT
  {0x83CE, 0xAEA8}, //486 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEUL
  {0x83CF, 0xAEA9}, //487 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULKIYEOK
  {0x83D0, 0xAEAA}, //488 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULMIEUM
  {0x83D1, 0xAEAB}, //489 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPIEUP
  {0x83D2, 0xAEAC}, //490 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULSIOS
  {0x83D3, 0xAEAD}, //491 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULTHIEUTH
  {0x83D4, 0xAEAE}, //492 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULPHIEUPH
  {0x83D5, 0xAEAF}, //493 #HANGUL SYLLABLE SSANGKIYEOK YAE RIEULHIEUH
  {0x83D6, 0xAEB0}, //494 #HANGUL SYLLABLE SSANGKIYEOK YAE MIEUM
  {0x83D7, 0xAEB1}, //495 #HANGUL SYLLABLE SSANGKIYEOK YAE PIEUP
  {0x83D8, 0xAEB2}, //496 #HANGUL SYLLABLE SSANGKIYEOK YAE PIEUPSIOS
  {0x83D9, 0xAEB3}, //497 #HANGUL SYLLABLE SSANGKIYEOK YAE SIOS
  {0x83DA, 0xAEB4}, //498 #HANGUL SYLLABLE SSANGKIYEOK YAE SSANGSIOS
  {0x83DB, 0xAEB5}, //499 #HANGUL SYLLABLE SSANGKIYEOK YAE IEUNG
  {0x83DC, 0xAEB6}, //500 #HANGUL SYLLABLE SSANGKIYEOK YAE CIEUC
  {0x83DD, 0xAEB7}, //501 #HANGUL SYLLABLE SSANGKIYEOK YAE CHIEUCH
  {0x83DE, 0xAEB8}, //502 #HANGUL SYLLABLE SSANGKIYEOK YAE KHIEUKH
  {0x83DF, 0xAEB9}, //503 #HANGUL SYLLABLE SSANGKIYEOK YAE THIEUTH
  {0x83E0, 0xAEBA}, //504 #HANGUL SYLLABLE SSANGKIYEOK YAE PHIEUPH
  {0x83E1, 0xAEBB}, //505 #HANGUL SYLLABLE SSANGKIYEOK YAE HIEUH
  {0x83E2, 0xAEBF}, //506 #HANGUL SYLLABLE SSANGKIYEOK EO KIYEOKSIOS
  {0x83E3, 0xAEC1}, //507 #HANGUL SYLLABLE SSANGKIYEOK EO NIEUNCIEUC
  {0x83E4, 0xAEC2}, //508 #HANGUL SYLLABLE SSANGKIYEOK EO NIEUNHIEUH
  {0x83E5, 0xAEC3}, //509 #HANGUL SYLLABLE SSANGKIYEOK EO TIKEUT
  {0x83E6, 0xAEC5}, //510 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULKIYEOK
  {0x83E7, 0xAEC6}, //511 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULMIEUM
  {0x83E8, 0xAEC7}, //512 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULPIEUP
  {0x83E9, 0xAEC8}, //513 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULSIOS
  {0x83EA, 0xAEC9}, //514 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULTHIEUTH
  {0x83EB, 0xAECA}, //515 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULPHIEUPH
  {0x83EC, 0xAECB}, //516 #HANGUL SYLLABLE SSANGKIYEOK EO RIEULHIEUH
  {0x83ED, 0xAECE}, //517 #HANGUL SYLLABLE SSANGKIYEOK EO PIEUPSIOS
  {0x83EE, 0xAED2}, //518 #HANGUL SYLLABLE SSANGKIYEOK EO CIEUC
  {0x83EF, 0xAED3}, //519 #HANGUL SYLLABLE SSANGKIYEOK EO CHIEUCH
  {0x83F0, 0xAED4}, //520 #HANGUL SYLLABLE SSANGKIYEOK EO KHIEUKH
  {0x83F1, 0xAED5}, //521 #HANGUL SYLLABLE SSANGKIYEOK EO THIEUTH
  {0x83F2, 0xAED6}, //522 #HANGUL SYLLABLE SSANGKIYEOK EO PHIEUPH
  {0x83F3, 0xAED7}, //523 #HANGUL SYLLABLE SSANGKIYEOK EO HIEUH
  {0x83F4, 0xAEDA}, //524 #HANGUL SYLLABLE SSANGKIYEOK E SSANGKIYEOK
  {0x83F5, 0xAEDB}, //525 #HANGUL SYLLABLE SSANGKIYEOK E KIYEOKSIOS
  {0x83F6, 0xAEDD}, //526 #HANGUL SYLLABLE SSANGKIYEOK E NIEUNCIEUC
  {0x83F7, 0xAEDE}, //527 #HANGUL SYLLABLE SSANGKIYEOK E NIEUNHIEUH
  {0x83F8, 0xAEDF}, //528 #HANGUL SYLLABLE SSANGKIYEOK E TIKEUT
  {0x83F9, 0xAEE0}, //529 #HANGUL SYLLABLE SSANGKIYEOK E RIEUL
  {0x83FA, 0xAEE1}, //530 #HANGUL SYLLABLE SSANGKIYEOK E RIEULKIYEOK
  {0x83FB, 0xAEE2}, //531 #HANGUL SYLLABLE SSANGKIYEOK E RIEULMIEUM
  {0x83FC, 0xAEE3}, //532 #HANGUL SYLLABLE SSANGKIYEOK E RIEULPIEUP
  {0x83FD, 0xAEE4}, //533 #HANGUL SYLLABLE SSANGKIYEOK E RIEULSIOS
  {0x83FE, 0xAEE5}, //534 #HANGUL SYLLABLE SSANGKIYEOK E RIEULTHIEUTH
  {0x8441, 0xAEE6}, //535 #HANGUL SYLLABLE SSANGKIYEOK E RIEULPHIEUPH
  {0x8442, 0xAEE7}, //536 #HANGUL SYLLABLE SSANGKIYEOK E RIEULHIEUH
  {0x8443, 0xAEE9}, //537 #HANGUL SYLLABLE SSANGKIYEOK E PIEUP
  {0x8444, 0xAEEA}, //538 #HANGUL SYLLABLE SSANGKIYEOK E PIEUPSIOS
  {0x8445, 0xAEEC}, //539 #HANGUL SYLLABLE SSANGKIYEOK E SSANGSIOS
  {0x8446, 0xAEEE}, //540 #HANGUL SYLLABLE SSANGKIYEOK E CIEUC
  {0x8447, 0xAEEF}, //541 #HANGUL SYLLABLE SSANGKIYEOK E CHIEUCH
  {0x8448, 0xAEF0}, //542 #HANGUL SYLLABLE SSANGKIYEOK E KHIEUKH
  {0x8449, 0xAEF1}, //543 #HANGUL SYLLABLE SSANGKIYEOK E THIEUTH
  {0x844A, 0xAEF2}, //544 #HANGUL SYLLABLE SSANGKIYEOK E PHIEUPH
  {0x844B, 0xAEF3}, //545 #HANGUL SYLLABLE SSANGKIYEOK E HIEUH
  {0x844C, 0xAEF5}, //546 #HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOK
  {0x844D, 0xAEF6}, //547 #HANGUL SYLLABLE SSANGKIYEOK YEO SSANGKIYEOK
  {0x844E, 0xAEF7}, //548 #HANGUL SYLLABLE SSANGKIYEOK YEO KIYEOKSIOS
  {0x844F, 0xAEF9}, //549 #HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNCIEUC
  {0x8450, 0xAEFA}, //550 #HANGUL SYLLABLE SSANGKIYEOK YEO NIEUNHIEUH
  {0x8451, 0xAEFB}, //551 #HANGUL SYLLABLE SSANGKIYEOK YEO TIKEUT
  {0x8452, 0xAEFD}, //552 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULKIYEOK
  {0x8453, 0xAEFE}, //553 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULMIEUM
  {0x8454, 0xAEFF}, //554 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPIEUP
  {0x8455, 0xAF00}, //555 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULSIOS
  {0x8456, 0xAF01}, //556 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULTHIEUTH
  {0x8457, 0xAF02}, //557 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULPHIEUPH
  {0x8458, 0xAF03}, //558 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEULHIEUH
  {0x8459, 0xAF04}, //559 #HANGUL SYLLABLE SSANGKIYEOK YEO MIEUM
  {0x845A, 0xAF05}, //560 #HANGUL SYLLABLE SSANGKIYEOK YEO PIEUP
  {0x8461, 0xAF06}, //561 #HANGUL SYLLABLE SSANGKIYEOK YEO PIEUPSIOS
  {0x8462, 0xAF09}, //562 #HANGUL SYLLABLE SSANGKIYEOK YEO IEUNG
  {0x8463, 0xAF0A}, //563 #HANGUL SYLLABLE SSANGKIYEOK YEO CIEUC
  {0x8464, 0xAF0B}, //564 #HANGUL SYLLABLE SSANGKIYEOK YEO CHIEUCH
  {0x8465, 0xAF0C}, //565 #HANGUL SYLLABLE SSANGKIYEOK YEO KHIEUKH
  {0x8466, 0xAF0E}, //566 #HANGUL SYLLABLE SSANGKIYEOK YEO PHIEUPH
  {0x8467, 0xAF0F}, //567 #HANGUL SYLLABLE SSANGKIYEOK YEO HIEUH
  {0x8468, 0xAF11}, //568 #HANGUL SYLLABLE SSANGKIYEOK YE KIYEOK
  {0x8469, 0xAF12}, //569 #HANGUL SYLLABLE SSANGKIYEOK YE SSANGKIYEOK
  {0x846A, 0xAF13}, //570 #HANGUL SYLLABLE SSANGKIYEOK YE KIYEOKSIOS
  {0x846B, 0xAF14}, //571 #HANGUL SYLLABLE SSANGKIYEOK YE NIEUN
  {0x846C, 0xAF15}, //572 #HANGUL SYLLABLE SSANGKIYEOK YE NIEUNCIEUC
  {0x846D, 0xAF16}, //573 #HANGUL SYLLABLE SSANGKIYEOK YE NIEUNHIEUH
  {0x846E, 0xAF17}, //574 #HANGUL SYLLABLE SSANGKIYEOK YE TIKEUT
  {0x846F, 0xAF18}, //575 #HANGUL SYLLABLE SSANGKIYEOK YE RIEUL
  {0x8470, 0xAF19}, //576 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULKIYEOK
  {0x8471, 0xAF1A}, //577 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULMIEUM
  {0x8472, 0xAF1B}, //578 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULPIEUP
  {0x8473, 0xAF1C}, //579 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULSIOS
  {0x8474, 0xAF1D}, //580 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULTHIEUTH
  {0x8475, 0xAF1E}, //581 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULPHIEUPH
  {0x8476, 0xAF1F}, //582 #HANGUL SYLLABLE SSANGKIYEOK YE RIEULHIEUH
  {0x8477, 0xAF20}, //583 #HANGUL SYLLABLE SSANGKIYEOK YE MIEUM
  {0x8478, 0xAF21}, //584 #HANGUL SYLLABLE SSANGKIYEOK YE PIEUP
  {0x8479, 0xAF22}, //585 #HANGUL SYLLABLE SSANGKIYEOK YE PIEUPSIOS
  {0x847A, 0xAF23}, //586 #HANGUL SYLLABLE SSANGKIYEOK YE SIOS
  {0x8481, 0xAF24}, //587 #HANGUL SYLLABLE SSANGKIYEOK YE SSANGSIOS
  {0x8482, 0xAF25}, //588 #HANGUL SYLLABLE SSANGKIYEOK YE IEUNG
  {0x8483, 0xAF26}, //589 #HANGUL SYLLABLE SSANGKIYEOK YE CIEUC
  {0x8484, 0xAF27}, //590 #HANGUL SYLLABLE SSANGKIYEOK YE CHIEUCH
  {0x8485, 0xAF28}, //591 #HANGUL SYLLABLE SSANGKIYEOK YE KHIEUKH
  {0x8486, 0xAF29}, //592 #HANGUL SYLLABLE SSANGKIYEOK YE THIEUTH
  {0x8487, 0xAF2A}, //593 #HANGUL SYLLABLE SSANGKIYEOK YE PHIEUPH
  {0x8488, 0xAF2B}, //594 #HANGUL SYLLABLE SSANGKIYEOK YE HIEUH
  {0x8489, 0xAF2E}, //595 #HANGUL SYLLABLE SSANGKIYEOK O SSANGKIYEOK
  {0x848A, 0xAF2F}, //596 #HANGUL SYLLABLE SSANGKIYEOK O KIYEOKSIOS
  {0x848B, 0xAF31}, //597 #HANGUL SYLLABLE SSANGKIYEOK O NIEUNCIEUC
  {0x848C, 0xAF33}, //598 #HANGUL SYLLABLE SSANGKIYEOK O TIKEUT
  {0x848D, 0xAF35}, //599 #HANGUL SYLLABLE SSANGKIYEOK O RIEULKIYEOK
  {0x848E, 0xAF36}, //600 #HANGUL SYLLABLE SSANGKIYEOK O RIEULMIEUM
  {0x848F, 0xAF37}, //601 #HANGUL SYLLABLE SSANGKIYEOK O RIEULPIEUP
  {0x8490, 0xAF38}, //602 #HANGUL SYLLABLE SSANGKIYEOK O RIEULSIOS
  {0x8491, 0xAF39}, //603 #HANGUL SYLLABLE SSANGKIYEOK O RIEULTHIEUTH
  {0x8492, 0xAF3A}, //604 #HANGUL SYLLABLE SSANGKIYEOK O RIEULPHIEUPH
  {0x8493, 0xAF3B}, //605 #HANGUL SYLLABLE SSANGKIYEOK O RIEULHIEUH
  {0x8494, 0xAF3E}, //606 #HANGUL SYLLABLE SSANGKIYEOK O PIEUPSIOS
  {0x8495, 0xAF40}, //607 #HANGUL SYLLABLE SSANGKIYEOK O SSANGSIOS
  {0x8496, 0xAF44}, //608 #HANGUL SYLLABLE SSANGKIYEOK O KHIEUKH
  {0x8497, 0xAF45}, //609 #HANGUL SYLLABLE SSANGKIYEOK O THIEUTH
  {0x8498, 0xAF46}, //610 #HANGUL SYLLABLE SSANGKIYEOK O PHIEUPH
  {0x8499, 0xAF47}, //611 #HANGUL SYLLABLE SSANGKIYEOK O HIEUH
  {0x849A, 0xAF4A}, //612 #HANGUL SYLLABLE SSANGKIYEOK WA SSANGKIYEOK
  {0x849B, 0xAF4B}, //613 #HANGUL SYLLABLE SSANGKIYEOK WA KIYEOKSIOS
  {0x849C, 0xAF4C}, //614 #HANGUL SYLLABLE SSANGKIYEOK WA NIEUN
  {0x849D, 0xAF4D}, //615 #HANGUL SYLLABLE SSANGKIYEOK WA NIEUNCIEUC
  {0x849E, 0xAF4E}, //616 #HANGUL SYLLABLE SSANGKIYEOK WA NIEUNHIEUH
  {0x849F, 0xAF4F}, //617 #HANGUL SYLLABLE SSANGKIYEOK WA TIKEUT
  {0x84A0, 0xAF51}, //618 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULKIYEOK
  {0x84A1, 0xAF52}, //619 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULMIEUM
  {0x84A2, 0xAF53}, //620 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULPIEUP
  {0x84A3, 0xAF54}, //621 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULSIOS
  {0x84A4, 0xAF55}, //622 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULTHIEUTH
  {0x84A5, 0xAF56}, //623 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULPHIEUPH
  {0x84A6, 0xAF57}, //624 #HANGUL SYLLABLE SSANGKIYEOK WA RIEULHIEUH
  {0x84A7, 0xAF58}, //625 #HANGUL SYLLABLE SSANGKIYEOK WA MIEUM
  {0x84A8, 0xAF59}, //626 #HANGUL SYLLABLE SSANGKIYEOK WA PIEUP
  {0x84A9, 0xAF5A}, //627 #HANGUL SYLLABLE SSANGKIYEOK WA PIEUPSIOS
  {0x84AA, 0xAF5B}, //628 #HANGUL SYLLABLE SSANGKIYEOK WA SIOS
  {0x84AB, 0xAF5E}, //629 #HANGUL SYLLABLE SSANGKIYEOK WA CIEUC
  {0x84AC, 0xAF5F}, //630 #HANGUL SYLLABLE SSANGKIYEOK WA CHIEUCH
  {0x84AD, 0xAF60}, //631 #HANGUL SYLLABLE SSANGKIYEOK WA KHIEUKH
  {0x84AE, 0xAF61}, //632 #HANGUL SYLLABLE SSANGKIYEOK WA THIEUTH
  {0x84AF, 0xAF62}, //633 #HANGUL SYLLABLE SSANGKIYEOK WA PHIEUPH
  {0x84B0, 0xAF63}, //634 #HANGUL SYLLABLE SSANGKIYEOK WA HIEUH
  {0x84B1, 0xAF66}, //635 #HANGUL SYLLABLE SSANGKIYEOK WAE SSANGKIYEOK
  {0x84B2, 0xAF67}, //636 #HANGUL SYLLABLE SSANGKIYEOK WAE KIYEOKSIOS
  {0x84B3, 0xAF68}, //637 #HANGUL SYLLABLE SSANGKIYEOK WAE NIEUN
  {0x84B4, 0xAF69}, //638 #HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNCIEUC
  {0x84B5, 0xAF6A}, //639 #HANGUL SYLLABLE SSANGKIYEOK WAE NIEUNHIEUH
  {0x84B6, 0xAF6B}, //640 #HANGUL SYLLABLE SSANGKIYEOK WAE TIKEUT
  {0x84B7, 0xAF6C}, //641 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEUL
  {0x84B8, 0xAF6D}, //642 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULKIYEOK
  {0x84B9, 0xAF6E}, //643 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULMIEUM
  {0x84BA, 0xAF6F}, //644 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPIEUP
  {0x84BB, 0xAF70}, //645 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULSIOS
  {0x84BC, 0xAF71}, //646 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULTHIEUTH
  {0x84BD, 0xAF72}, //647 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULPHIEUPH
  {0x84BE, 0xAF73}, //648 #HANGUL SYLLABLE SSANGKIYEOK WAE RIEULHIEUH
  {0x84BF, 0xAF74}, //649 #HANGUL SYLLABLE SSANGKIYEOK WAE MIEUM
  {0x84C0, 0xAF75}, //650 #HANGUL SYLLABLE SSANGKIYEOK WAE PIEUP
  {0x84C1, 0xAF76}, //651 #HANGUL SYLLABLE SSANGKIYEOK WAE PIEUPSIOS
  {0x84C2, 0xAF77}, //652 #HANGUL SYLLABLE SSANGKIYEOK WAE SIOS
  {0x84C3, 0xAF78}, //653 #HANGUL SYLLABLE SSANGKIYEOK WAE SSANGSIOS
  {0x84C4, 0xAF7A}, //654 #HANGUL SYLLABLE SSANGKIYEOK WAE CIEUC
  {0x84C5, 0xAF7B}, //655 #HANGUL SYLLABLE SSANGKIYEOK WAE CHIEUCH
  {0x84C6, 0xAF7C}, //656 #HANGUL SYLLABLE SSANGKIYEOK WAE KHIEUKH
  {0x84C7, 0xAF7D}, //657 #HANGUL SYLLABLE SSANGKIYEOK WAE THIEUTH
  {0x84C8, 0xAF7E}, //658 #HANGUL SYLLABLE SSANGKIYEOK WAE PHIEUPH
  {0x84C9, 0xAF7F}, //659 #HANGUL SYLLABLE SSANGKIYEOK WAE HIEUH
  {0x84CA, 0xAF81}, //660 #HANGUL SYLLABLE SSANGKIYEOK OE KIYEOK
  {0x84CB, 0xAF82}, //661 #HANGUL SYLLABLE SSANGKIYEOK OE SSANGKIYEOK
  {0x84CC, 0xAF83}, //662 #HANGUL SYLLABLE SSANGKIYEOK OE KIYEOKSIOS
  {0x84CD, 0xAF85}, //663 #HANGUL SYLLABLE SSANGKIYEOK OE NIEUNCIEUC
  {0x84CE, 0xAF86}, //664 #HANGUL SYLLABLE SSANGKIYEOK OE NIEUNHIEUH
  {0x84CF, 0xAF87}, //665 #HANGUL SYLLABLE SSANGKIYEOK OE TIKEUT
  {0x84D0, 0xAF89}, //666 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULKIYEOK
  {0x84D1, 0xAF8A}, //667 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULMIEUM
  {0x84D2, 0xAF8B}, //668 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULPIEUP
  {0x84D3, 0xAF8C}, //669 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULSIOS
  {0x84D4, 0xAF8D}, //670 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULTHIEUTH
  {0x84D5, 0xAF8E}, //671 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULPHIEUPH
  {0x84D6, 0xAF8F}, //672 #HANGUL SYLLABLE SSANGKIYEOK OE RIEULHIEUH
  {0x84D7, 0xAF92}, //673 #HANGUL SYLLABLE SSANGKIYEOK OE PIEUPSIOS
  {0x84D8, 0xAF93}, //674 #HANGUL SYLLABLE SSANGKIYEOK OE SIOS
  {0x84D9, 0xAF94}, //675 #HANGUL SYLLABLE SSANGKIYEOK OE SSANGSIOS
  {0x84DA, 0xAF96}, //676 #HANGUL SYLLABLE SSANGKIYEOK OE CIEUC
  {0x84DB, 0xAF97}, //677 #HANGUL SYLLABLE SSANGKIYEOK OE CHIEUCH
  {0x84DC, 0xAF98}, //678 #HANGUL SYLLABLE SSANGKIYEOK OE KHIEUKH
  {0x84DD, 0xAF99}, //679 #HANGUL SYLLABLE SSANGKIYEOK OE THIEUTH
  {0x84DE, 0xAF9A}, //680 #HANGUL SYLLABLE SSANGKIYEOK OE PHIEUPH
  {0x84DF, 0xAF9B}, //681 #HANGUL SYLLABLE SSANGKIYEOK OE HIEUH
  {0x84E0, 0xAF9D}, //682 #HANGUL SYLLABLE SSANGKIYEOK YO KIYEOK
  {0x84E1, 0xAF9E}, //683 #HANGUL SYLLABLE SSANGKIYEOK YO SSANGKIYEOK
  {0x84E2, 0xAF9F}, //684 #HANGUL SYLLABLE SSANGKIYEOK YO KIYEOKSIOS
  {0x84E3, 0xAFA0}, //685 #HANGUL SYLLABLE SSANGKIYEOK YO NIEUN
  {0x84E4, 0xAFA1}, //686 #HANGUL SYLLABLE SSANGKIYEOK YO NIEUNCIEUC
  {0x84E5, 0xAFA2}, //687 #HANGUL SYLLABLE SSANGKIYEOK YO NIEUNHIEUH
  {0x84E6, 0xAFA3}, //688 #HANGUL SYLLABLE SSANGKIYEOK YO TIKEUT
  {0x84E7, 0xAFA4}, //689 #HANGUL SYLLABLE SSANGKIYEOK YO RIEUL
  {0x84E8, 0xAFA5}, //690 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULKIYEOK
  {0x84E9, 0xAFA6}, //691 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULMIEUM
  {0x84EA, 0xAFA7}, //692 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULPIEUP
  {0x84EB, 0xAFA8}, //693 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULSIOS
  {0x84EC, 0xAFA9}, //694 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULTHIEUTH
  {0x84ED, 0xAFAA}, //695 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULPHIEUPH
  {0x84EE, 0xAFAB}, //696 #HANGUL SYLLABLE SSANGKIYEOK YO RIEULHIEUH
  {0x84EF, 0xAFAC}, //697 #HANGUL SYLLABLE SSANGKIYEOK YO MIEUM
  {0x84F0, 0xAFAD}, //698 #HANGUL SYLLABLE SSANGKIYEOK YO PIEUP
  {0x84F1, 0xAFAE}, //699 #HANGUL SYLLABLE SSANGKIYEOK YO PIEUPSIOS
  {0x84F2, 0xAFAF}, //700 #HANGUL SYLLABLE SSANGKIYEOK YO SIOS
  {0x84F3, 0xAFB0}, //701 #HANGUL SYLLABLE SSANGKIYEOK YO SSANGSIOS
  {0x84F4, 0xAFB1}, //702 #HANGUL SYLLABLE SSANGKIYEOK YO IEUNG
  {0x84F5, 0xAFB2}, //703 #HANGUL SYLLABLE SSANGKIYEOK YO CIEUC
  {0x84F6, 0xAFB3}, //704 #HANGUL SYLLABLE SSANGKIYEOK YO CHIEUCH
  {0x84F7, 0xAFB4}, //705 #HANGUL SYLLABLE SSANGKIYEOK YO KHIEUKH
  {0x84F8, 0xAFB5}, //706 #HANGUL SYLLABLE SSANGKIYEOK YO THIEUTH
  {0x84F9, 0xAFB6}, //707 #HANGUL SYLLABLE SSANGKIYEOK YO PHIEUPH
  {0x84FA, 0xAFB7}, //708 #HANGUL SYLLABLE SSANGKIYEOK YO HIEUH
  {0x84FB, 0xAFBA}, //709 #HANGUL SYLLABLE SSANGKIYEOK U SSANGKIYEOK
  {0x84FC, 0xAFBB}, //710 #HANGUL SYLLABLE SSANGKIYEOK U KIYEOKSIOS
  {0x84FD, 0xAFBD}, //711 #HANGUL SYLLABLE SSANGKIYEOK U NIEUNCIEUC
  {0x84FE, 0xAFBE}, //712 #HANGUL SYLLABLE SSANGKIYEOK U NIEUNHIEUH
  {0x8541, 0xAFBF}, //713 #HANGUL SYLLABLE SSANGKIYEOK U TIKEUT
  {0x8542, 0xAFC1}, //714 #HANGUL SYLLABLE SSANGKIYEOK U RIEULKIYEOK
  {0x8543, 0xAFC2}, //715 #HANGUL SYLLABLE SSANGKIYEOK U RIEULMIEUM
  {0x8544, 0xAFC3}, //716 #HANGUL SYLLABLE SSANGKIYEOK U RIEULPIEUP
  {0x8545, 0xAFC4}, //717 #HANGUL SYLLABLE SSANGKIYEOK U RIEULSIOS
  {0x8546, 0xAFC5}, //718 #HANGUL SYLLABLE SSANGKIYEOK U RIEULTHIEUTH
  {0x8547, 0xAFC6}, //719 #HANGUL SYLLABLE SSANGKIYEOK U RIEULPHIEUPH
  {0x8548, 0xAFCA}, //720 #HANGUL SYLLABLE SSANGKIYEOK U PIEUPSIOS
  {0x8549, 0xAFCC}, //721 #HANGUL SYLLABLE SSANGKIYEOK U SSANGSIOS
  {0x854A, 0xAFCF}, //722 #HANGUL SYLLABLE SSANGKIYEOK U CHIEUCH
  {0x854B, 0xAFD0}, //723 #HANGUL SYLLABLE SSANGKIYEOK U KHIEUKH
  {0x854C, 0xAFD1}, //724 #HANGUL SYLLABLE SSANGKIYEOK U THIEUTH
  {0x854D, 0xAFD2}, //725 #HANGUL SYLLABLE SSANGKIYEOK U PHIEUPH
  {0x854E, 0xAFD3}, //726 #HANGUL SYLLABLE SSANGKIYEOK U HIEUH
  {0x854F, 0xAFD5}, //727 #HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOK
  {0x8550, 0xAFD6}, //728 #HANGUL SYLLABLE SSANGKIYEOK WEO SSANGKIYEOK
  {0x8551, 0xAFD7}, //729 #HANGUL SYLLABLE SSANGKIYEOK WEO KIYEOKSIOS
  {0x8552, 0xAFD8}, //730 #HANGUL SYLLABLE SSANGKIYEOK WEO NIEUN
  {0x8553, 0xAFD9}, //731 #HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNCIEUC
  {0x8554, 0xAFDA}, //732 #HANGUL SYLLABLE SSANGKIYEOK WEO NIEUNHIEUH
  {0x8555, 0xAFDB}, //733 #HANGUL SYLLABLE SSANGKIYEOK WEO TIKEUT
  {0x8556, 0xAFDD}, //734 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULKIYEOK
  {0x8557, 0xAFDE}, //735 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULMIEUM
  {0x8558, 0xAFDF}, //736 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPIEUP
  {0x8559, 0xAFE0}, //737 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULSIOS
  {0x855A, 0xAFE1}, //738 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULTHIEUTH
  {0x8561, 0xAFE2}, //739 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULPHIEUPH
  {0x8562, 0xAFE3}, //740 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEULHIEUH
  {0x8563, 0xAFE4}, //741 #HANGUL SYLLABLE SSANGKIYEOK WEO MIEUM
  {0x8564, 0xAFE5}, //742 #HANGUL SYLLABLE SSANGKIYEOK WEO PIEUP
  {0x8565, 0xAFE6}, //743 #HANGUL SYLLABLE SSANGKIYEOK WEO PIEUPSIOS
  {0x8566, 0xAFE7}, //744 #HANGUL SYLLABLE SSANGKIYEOK WEO SIOS
  {0x8567, 0xAFEA}, //745 #HANGUL SYLLABLE SSANGKIYEOK WEO CIEUC
  {0x8568, 0xAFEB}, //746 #HANGUL SYLLABLE SSANGKIYEOK WEO CHIEUCH
  {0x8569, 0xAFEC}, //747 #HANGUL SYLLABLE SSANGKIYEOK WEO KHIEUKH
  {0x856A, 0xAFED}, //748 #HANGUL SYLLABLE SSANGKIYEOK WEO THIEUTH
  {0x856B, 0xAFEE}, //749 #HANGUL SYLLABLE SSANGKIYEOK WEO PHIEUPH
  {0x856C, 0xAFEF}, //750 #HANGUL SYLLABLE SSANGKIYEOK WEO HIEUH
  {0x856D, 0xAFF2}, //751 #HANGUL SYLLABLE SSANGKIYEOK WE SSANGKIYEOK
  {0x856E, 0xAFF3}, //752 #HANGUL SYLLABLE SSANGKIYEOK WE KIYEOKSIOS
  {0x856F, 0xAFF5}, //753 #HANGUL SYLLABLE SSANGKIYEOK WE NIEUNCIEUC
  {0x8570, 0xAFF6}, //754 #HANGUL SYLLABLE SSANGKIYEOK WE NIEUNHIEUH
  {0x8571, 0xAFF7}, //755 #HANGUL SYLLABLE SSANGKIYEOK WE TIKEUT
  {0x8572, 0xAFF9}, //756 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULKIYEOK
  {0x8573, 0xAFFA}, //757 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULMIEUM
  {0x8574, 0xAFFB}, //758 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULPIEUP
  {0x8575, 0xAFFC}, //759 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULSIOS
  {0x8576, 0xAFFD}, //760 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULTHIEUTH
  {0x8577, 0xAFFE}, //761 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULPHIEUPH
  {0x8578, 0xAFFF}, //762 #HANGUL SYLLABLE SSANGKIYEOK WE RIEULHIEUH
  {0x8579, 0xB002}, //763 #HANGUL SYLLABLE SSANGKIYEOK WE PIEUPSIOS
  {0x857A, 0xB003}, //764 #HANGUL SYLLABLE SSANGKIYEOK WE SIOS
  {0x8581, 0xB005}, //765 #HANGUL SYLLABLE SSANGKIYEOK WE IEUNG
  {0x8582, 0xB006}, //766 #HANGUL SYLLABLE SSANGKIYEOK WE CIEUC
  {0x8583, 0xB007}, //767 #HANGUL SYLLABLE SSANGKIYEOK WE CHIEUCH
  {0x8584, 0xB008}, //768 #HANGUL SYLLABLE SSANGKIYEOK WE KHIEUKH
  {0x8585, 0xB009}, //769 #HANGUL SYLLABLE SSANGKIYEOK WE THIEUTH
  {0x8586, 0xB00A}, //770 #HANGUL SYLLABLE SSANGKIYEOK WE PHIEUPH
  {0x8587, 0xB00B}, //771 #HANGUL SYLLABLE SSANGKIYEOK WE HIEUH
  {0x8588, 0xB00D}, //772 #HANGUL SYLLABLE SSANGKIYEOK WI KIYEOK
  {0x8589, 0xB00E}, //773 #HANGUL SYLLABLE SSANGKIYEOK WI SSANGKIYEOK
  {0x858A, 0xB00F}, //774 #HANGUL SYLLABLE SSANGKIYEOK WI KIYEOKSIOS
  {0x858B, 0xB011}, //775 #HANGUL SYLLABLE SSANGKIYEOK WI NIEUNCIEUC
  {0x858C, 0xB012}, //776 #HANGUL SYLLABLE SSANGKIYEOK WI NIEUNHIEUH
  {0x858D, 0xB013}, //777 #HANGUL SYLLABLE SSANGKIYEOK WI TIKEUT
  {0x858E, 0xB015}, //778 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULKIYEOK
  {0x858F, 0xB016}, //779 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULMIEUM
  {0x8590, 0xB017}, //780 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULPIEUP
  {0x8591, 0xB018}, //781 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULSIOS
  {0x8592, 0xB019}, //782 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULTHIEUTH
  {0x8593, 0xB01A}, //783 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULPHIEUPH
  {0x8594, 0xB01B}, //784 #HANGUL SYLLABLE SSANGKIYEOK WI RIEULHIEUH
  {0x8595, 0xB01E}, //785 #HANGUL SYLLABLE SSANGKIYEOK WI PIEUPSIOS
  {0x8596, 0xB01F}, //786 #HANGUL SYLLABLE SSANGKIYEOK WI SIOS
  {0x8597, 0xB020}, //787 #HANGUL SYLLABLE SSANGKIYEOK WI SSANGSIOS
  {0x8598, 0xB021}, //788 #HANGUL SYLLABLE SSANGKIYEOK WI IEUNG
  {0x8599, 0xB022}, //789 #HANGUL SYLLABLE SSANGKIYEOK WI CIEUC
  {0x859A, 0xB023}, //790 #HANGUL SYLLABLE SSANGKIYEOK WI CHIEUCH
  {0x859B, 0xB024}, //791 #HANGUL SYLLABLE SSANGKIYEOK WI KHIEUKH
  {0x859C, 0xB025}, //792 #HANGUL SYLLABLE SSANGKIYEOK WI THIEUTH
  {0x859D, 0xB026}, //793 #HANGUL SYLLABLE SSANGKIYEOK WI PHIEUPH
  {0x859E, 0xB027}, //794 #HANGUL SYLLABLE SSANGKIYEOK WI HIEUH
  {0x859F, 0xB029}, //795 #HANGUL SYLLABLE SSANGKIYEOK YU KIYEOK
  {0x85A0, 0xB02A}, //796 #HANGUL SYLLABLE SSANGKIYEOK YU SSANGKIYEOK
  {0x85A1, 0xB02B}, //797 #HANGUL SYLLABLE SSANGKIYEOK YU KIYEOKSIOS
  {0x85A2, 0xB02C}, //798 #HANGUL SYLLABLE SSANGKIYEOK YU NIEUN
  {0x85A3, 0xB02D}, //799 #HANGUL SYLLABLE SSANGKIYEOK YU NIEUNCIEUC
  {0x85A4, 0xB02E}, //800 #HANGUL SYLLABLE SSANGKIYEOK YU NIEUNHIEUH
  {0x85A5, 0xB02F}, //801 #HANGUL SYLLABLE SSANGKIYEOK YU TIKEUT
  {0x85A6, 0xB030}, //802 #HANGUL SYLLABLE SSANGKIYEOK YU RIEUL
  {0x85A7, 0xB031}, //803 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULKIYEOK
  {0x85A8, 0xB032}, //804 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULMIEUM
  {0x85A9, 0xB033}, //805 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULPIEUP
  {0x85AA, 0xB034}, //806 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULSIOS
  {0x85AB, 0xB035}, //807 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULTHIEUTH
  {0x85AC, 0xB036}, //808 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULPHIEUPH
  {0x85AD, 0xB037}, //809 #HANGUL SYLLABLE SSANGKIYEOK YU RIEULHIEUH
  {0x85AE, 0xB038}, //810 #HANGUL SYLLABLE SSANGKIYEOK YU MIEUM
  {0x85AF, 0xB039}, //811 #HANGUL SYLLABLE SSANGKIYEOK YU PIEUP
  {0x85B0, 0xB03A}, //812 #HANGUL SYLLABLE SSANGKIYEOK YU PIEUPSIOS
  {0x85B1, 0xB03B}, //813 #HANGUL SYLLABLE SSANGKIYEOK YU SIOS
  {0x85B2, 0xB03C}, //814 #HANGUL SYLLABLE SSANGKIYEOK YU SSANGSIOS
  {0x85B3, 0xB03D}, //815 #HANGUL SYLLABLE SSANGKIYEOK YU IEUNG
  {0x85B4, 0xB03E}, //816 #HANGUL SYLLABLE SSANGKIYEOK YU CIEUC
  {0x85B5, 0xB03F}, //817 #HANGUL SYLLABLE SSANGKIYEOK YU CHIEUCH
  {0x85B6, 0xB040}, //818 #HANGUL SYLLABLE SSANGKIYEOK YU KHIEUKH
  {0x85B7, 0xB041}, //819 #HANGUL SYLLABLE SSANGKIYEOK YU THIEUTH
  {0x85B8, 0xB042}, //820 #HANGUL SYLLABLE SSANGKIYEOK YU PHIEUPH
  {0x85B9, 0xB043}, //821 #HANGUL SYLLABLE SSANGKIYEOK YU HIEUH
  {0x85BA, 0xB046}, //822 #HANGUL SYLLABLE SSANGKIYEOK EU SSANGKIYEOK
  {0x85BB, 0xB047}, //823 #HANGUL SYLLABLE SSANGKIYEOK EU KIYEOKSIOS
  {0x85BC, 0xB049}, //824 #HANGUL SYLLABLE SSANGKIYEOK EU NIEUNCIEUC
  {0x85BD, 0xB04B}, //825 #HANGUL SYLLABLE SSANGKIYEOK EU TIKEUT
  {0x85BE, 0xB04D}, //826 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULKIYEOK
  {0x85BF, 0xB04F}, //827 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULPIEUP
  {0x85C0, 0xB050}, //828 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULSIOS
  {0x85C1, 0xB051}, //829 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULTHIEUTH
  {0x85C2, 0xB052}, //830 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULPHIEUPH
  {0x85C3, 0xB056}, //831 #HANGUL SYLLABLE SSANGKIYEOK EU PIEUPSIOS
  {0x85C4, 0xB058}, //832 #HANGUL SYLLABLE SSANGKIYEOK EU SSANGSIOS
  {0x85C5, 0xB05A}, //833 #HANGUL SYLLABLE SSANGKIYEOK EU CIEUC
  {0x85C6, 0xB05B}, //834 #HANGUL SYLLABLE SSANGKIYEOK EU CHIEUCH
  {0x85C7, 0xB05C}, //835 #HANGUL SYLLABLE SSANGKIYEOK EU KHIEUKH
  {0x85C8, 0xB05E}, //836 #HANGUL SYLLABLE SSANGKIYEOK EU PHIEUPH
  {0x85C9, 0xB05F}, //837 #HANGUL SYLLABLE SSANGKIYEOK EU HIEUH
  {0x85CA, 0xB060}, //838 #HANGUL SYLLABLE SSANGKIYEOK YI
  {0x85CB, 0xB061}, //839 #HANGUL SYLLABLE SSANGKIYEOK YI KIYEOK
  {0x85CC, 0xB062}, //840 #HANGUL SYLLABLE SSANGKIYEOK YI SSANGKIYEOK
  {0x85CD, 0xB063}, //841 #HANGUL SYLLABLE SSANGKIYEOK YI KIYEOKSIOS
  {0x85CE, 0xB064}, //842 #HANGUL SYLLABLE SSANGKIYEOK YI NIEUN
  {0x85CF, 0xB065}, //843 #HANGUL SYLLABLE SSANGKIYEOK YI NIEUNCIEUC
  {0x85D0, 0xB066}, //844 #HANGUL SYLLABLE SSANGKIYEOK YI NIEUNHIEUH
  {0x85D1, 0xB067}, //845 #HANGUL SYLLABLE SSANGKIYEOK YI TIKEUT
  {0x85D2, 0xB068}, //846 #HANGUL SYLLABLE SSANGKIYEOK YI RIEUL
  {0x85D3, 0xB069}, //847 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULKIYEOK
  {0x85D4, 0xB06A}, //848 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULMIEUM
  {0x85D5, 0xB06B}, //849 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULPIEUP
  {0x85D6, 0xB06C}, //850 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULSIOS
  {0x85D7, 0xB06D}, //851 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULTHIEUTH
  {0x85D8, 0xB06E}, //852 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULPHIEUPH
  {0x85D9, 0xB06F}, //853 #HANGUL SYLLABLE SSANGKIYEOK YI RIEULHIEUH
  {0x85DA, 0xB070}, //854 #HANGUL SYLLABLE SSANGKIYEOK YI MIEUM
  {0x85DB, 0xB071}, //855 #HANGUL SYLLABLE SSANGKIYEOK YI PIEUP
  {0x85DC, 0xB072}, //856 #HANGUL SYLLABLE SSANGKIYEOK YI PIEUPSIOS
  {0x85DD, 0xB073}, //857 #HANGUL SYLLABLE SSANGKIYEOK YI SIOS
  {0x85DE, 0xB074}, //858 #HANGUL SYLLABLE SSANGKIYEOK YI SSANGSIOS
  {0x85DF, 0xB075}, //859 #HANGUL SYLLABLE SSANGKIYEOK YI IEUNG
  {0x85E0, 0xB076}, //860 #HANGUL SYLLABLE SSANGKIYEOK YI CIEUC
  {0x85E1, 0xB077}, //861 #HANGUL SYLLABLE SSANGKIYEOK YI CHIEUCH
  {0x85E2, 0xB078}, //862 #HANGUL SYLLABLE SSANGKIYEOK YI KHIEUKH
  {0x85E3, 0xB079}, //863 #HANGUL SYLLABLE SSANGKIYEOK YI THIEUTH
  {0x85E4, 0xB07A}, //864 #HANGUL SYLLABLE SSANGKIYEOK YI PHIEUPH
  {0x85E5, 0xB07B}, //865 #HANGUL SYLLABLE SSANGKIYEOK YI HIEUH
  {0x85E6, 0xB07E}, //866 #HANGUL SYLLABLE SSANGKIYEOK I SSANGKIYEOK
  {0x85E7, 0xB07F}, //867 #HANGUL SYLLABLE SSANGKIYEOK I KIYEOKSIOS
  {0x85E8, 0xB081}, //868 #HANGUL SYLLABLE SSANGKIYEOK I NIEUNCIEUC
  {0x85E9, 0xB082}, //869 #HANGUL SYLLABLE SSANGKIYEOK I NIEUNHIEUH
  {0x85EA, 0xB083}, //870 #HANGUL SYLLABLE SSANGKIYEOK I TIKEUT
  {0x85EB, 0xB085}, //871 #HANGUL SYLLABLE SSANGKIYEOK I RIEULKIYEOK
  {0x85EC, 0xB086}, //872 #HANGUL SYLLABLE SSANGKIYEOK I RIEULMIEUM
  {0x85ED, 0xB087}, //873 #HANGUL SYLLABLE SSANGKIYEOK I RIEULPIEUP
  {0x85EE, 0xB088}, //874 #HANGUL SYLLABLE SSANGKIYEOK I RIEULSIOS
  {0x85EF, 0xB089}, //875 #HANGUL SYLLABLE SSANGKIYEOK I RIEULTHIEUTH
  {0x85F0, 0xB08A}, //876 #HANGUL SYLLABLE SSANGKIYEOK I RIEULPHIEUPH
  {0x85F1, 0xB08B}, //877 #HANGUL SYLLABLE SSANGKIYEOK I RIEULHIEUH
  {0x85F2, 0xB08E}, //878 #HANGUL SYLLABLE SSANGKIYEOK I PIEUPSIOS
  {0x85F3, 0xB090}, //879 #HANGUL SYLLABLE SSANGKIYEOK I SSANGSIOS
  {0x85F4, 0xB092}, //880 #HANGUL SYLLABLE SSANGKIYEOK I CIEUC
  {0x85F5, 0xB093}, //881 #HANGUL SYLLABLE SSANGKIYEOK I CHIEUCH
  {0x85F6, 0xB094}, //882 #HANGUL SYLLABLE SSANGKIYEOK I KHIEUKH
  {0x85F7, 0xB095}, //883 #HANGUL SYLLABLE SSANGKIYEOK I THIEUTH
  {0x85F8, 0xB096}, //884 #HANGUL SYLLABLE SSANGKIYEOK I PHIEUPH
  {0x85F9, 0xB097}, //885 #HANGUL SYLLABLE SSANGKIYEOK I HIEUH
  {0x85FA, 0xB09B}, //886 #HANGUL SYLLABLE NIEUN A KIYEOKSIOS
  {0x85FB, 0xB09D}, //887 #HANGUL SYLLABLE NIEUN A NIEUNCIEUC
  {0x85FC, 0xB09E}, //888 #HANGUL SYLLABLE NIEUN A NIEUNHIEUH
  {0x85FD, 0xB0A3}, //889 #HANGUL SYLLABLE NIEUN A RIEULPIEUP
  {0x85FE, 0xB0A4}, //890 #HANGUL SYLLABLE NIEUN A RIEULSIOS
  {0x8641, 0xB0A5}, //891 #HANGUL SYLLABLE NIEUN A RIEULTHIEUTH
  {0x8642, 0xB0A6}, //892 #HANGUL SYLLABLE NIEUN A RIEULPHIEUPH
  {0x8643, 0xB0A7}, //893 #HANGUL SYLLABLE NIEUN A RIEULHIEUH
  {0x8644, 0xB0AA}, //894 #HANGUL SYLLABLE NIEUN A PIEUPSIOS
  {0x8645, 0xB0B0}, //895 #HANGUL SYLLABLE NIEUN A KHIEUKH
  {0x8646, 0xB0B2}, //896 #HANGUL SYLLABLE NIEUN A PHIEUPH
  {0x8647, 0xB0B6}, //897 #HANGUL SYLLABLE NIEUN AE SSANGKIYEOK
  {0x8648, 0xB0B7}, //898 #HANGUL SYLLABLE NIEUN AE KIYEOKSIOS
  {0x8649, 0xB0B9}, //899 #HANGUL SYLLABLE NIEUN AE NIEUNCIEUC
  {0x864A, 0xB0BA}, //900 #HANGUL SYLLABLE NIEUN AE NIEUNHIEUH
  {0x864B, 0xB0BB}, //901 #HANGUL SYLLABLE NIEUN AE TIKEUT
  {0x864C, 0xB0BD}, //902 #HANGUL SYLLABLE NIEUN AE RIEULKIYEOK
  {0x864D, 0xB0BE}, //903 #HANGUL SYLLABLE NIEUN AE RIEULMIEUM
  {0x864E, 0xB0BF}, //904 #HANGUL SYLLABLE NIEUN AE RIEULPIEUP
  {0x864F, 0xB0C0}, //905 #HANGUL SYLLABLE NIEUN AE RIEULSIOS
  {0x8650, 0xB0C1}, //906 #HANGUL SYLLABLE NIEUN AE RIEULTHIEUTH
  {0x8651, 0xB0C2}, //907 #HANGUL SYLLABLE NIEUN AE RIEULPHIEUPH
  {0x8652, 0xB0C3}, //908 #HANGUL SYLLABLE NIEUN AE RIEULHIEUH
  {0x8653, 0xB0C6}, //909 #HANGUL SYLLABLE NIEUN AE PIEUPSIOS
  {0x8654, 0xB0CA}, //910 #HANGUL SYLLABLE NIEUN AE CIEUC
  {0x8655, 0xB0CB}, //911 #HANGUL SYLLABLE NIEUN AE CHIEUCH
  {0x8656, 0xB0CC}, //912 #HANGUL SYLLABLE NIEUN AE KHIEUKH
  {0x8657, 0xB0CD}, //913 #HANGUL SYLLABLE NIEUN AE THIEUTH
  {0x8658, 0xB0CE}, //914 #HANGUL SYLLABLE NIEUN AE PHIEUPH
  {0x8659, 0xB0CF}, //915 #HANGUL SYLLABLE NIEUN AE HIEUH
  {0x865A, 0xB0D2}, //916 #HANGUL SYLLABLE NIEUN YA SSANGKIYEOK
  {0x8661, 0xB0D3}, //917 #HANGUL SYLLABLE NIEUN YA KIYEOKSIOS
  {0x8662, 0xB0D5}, //918 #HANGUL SYLLABLE NIEUN YA NIEUNCIEUC
  {0x8663, 0xB0D6}, //919 #HANGUL SYLLABLE NIEUN YA NIEUNHIEUH
  {0x8664, 0xB0D7}, //920 #HANGUL SYLLABLE NIEUN YA TIKEUT
  {0x8665, 0xB0D9}, //921 #HANGUL SYLLABLE NIEUN YA RIEULKIYEOK
  {0x8666, 0xB0DA}, //922 #HANGUL SYLLABLE NIEUN YA RIEULMIEUM
  {0x8667, 0xB0DB}, //923 #HANGUL SYLLABLE NIEUN YA RIEULPIEUP
  {0x8668, 0xB0DC}, //924 #HANGUL SYLLABLE NIEUN YA RIEULSIOS
  {0x8669, 0xB0DD}, //925 #HANGUL SYLLABLE NIEUN YA RIEULTHIEUTH
  {0x866A, 0xB0DE}, //926 #HANGUL SYLLABLE NIEUN YA RIEULPHIEUPH
  {0x866B, 0xB0DF}, //927 #HANGUL SYLLABLE NIEUN YA RIEULHIEUH
  {0x866C, 0xB0E1}, //928 #HANGUL SYLLABLE NIEUN YA PIEUP
  {0x866D, 0xB0E2}, //929 #HANGUL SYLLABLE NIEUN YA PIEUPSIOS
  {0x866E, 0xB0E3}, //930 #HANGUL SYLLABLE NIEUN YA SIOS
  {0x866F, 0xB0E4}, //931 #HANGUL SYLLABLE NIEUN YA SSANGSIOS
  {0x8670, 0xB0E6}, //932 #HANGUL SYLLABLE NIEUN YA CIEUC
  {0x8671, 0xB0E7}, //933 #HANGUL SYLLABLE NIEUN YA CHIEUCH
  {0x8672, 0xB0E8}, //934 #HANGUL SYLLABLE NIEUN YA KHIEUKH
  {0x8673, 0xB0E9}, //935 #HANGUL SYLLABLE NIEUN YA THIEUTH
  {0x8674, 0xB0EA}, //936 #HANGUL SYLLABLE NIEUN YA PHIEUPH
  {0x8675, 0xB0EB}, //937 #HANGUL SYLLABLE NIEUN YA HIEUH
  {0x8676, 0xB0EC}, //938 #HANGUL SYLLABLE NIEUN YAE
  {0x8677, 0xB0ED}, //939 #HANGUL SYLLABLE NIEUN YAE KIYEOK
  {0x8678, 0xB0EE}, //940 #HANGUL SYLLABLE NIEUN YAE SSANGKIYEOK
  {0x8679, 0xB0EF}, //941 #HANGUL SYLLABLE NIEUN YAE KIYEOKSIOS
  {0x867A, 0xB0F0}, //942 #HANGUL SYLLABLE NIEUN YAE NIEUN
  {0x8681, 0xB0F1}, //943 #HANGUL SYLLABLE NIEUN YAE NIEUNCIEUC
  {0x8682, 0xB0F2}, //944 #HANGUL SYLLABLE NIEUN YAE NIEUNHIEUH
  {0x8683, 0xB0F3}, //945 #HANGUL SYLLABLE NIEUN YAE TIKEUT
  {0x8684, 0xB0F4}, //946 #HANGUL SYLLABLE NIEUN YAE RIEUL
  {0x8685, 0xB0F5}, //947 #HANGUL SYLLABLE NIEUN YAE RIEULKIYEOK
  {0x8686, 0xB0F6}, //948 #HANGUL SYLLABLE NIEUN YAE RIEULMIEUM
  {0x8687, 0xB0F7}, //949 #HANGUL SYLLABLE NIEUN YAE RIEULPIEUP
  {0x8688, 0xB0F8}, //950 #HANGUL SYLLABLE NIEUN YAE RIEULSIOS
  {0x8689, 0xB0F9}, //951 #HANGUL SYLLABLE NIEUN YAE RIEULTHIEUTH
  {0x868A, 0xB0FA}, //952 #HANGUL SYLLABLE NIEUN YAE RIEULPHIEUPH
  {0x868B, 0xB0FB}, //953 #HANGUL SYLLABLE NIEUN YAE RIEULHIEUH
  {0x868C, 0xB0FC}, //954 #HANGUL SYLLABLE NIEUN YAE MIEUM
  {0x868D, 0xB0FD}, //955 #HANGUL SYLLABLE NIEUN YAE PIEUP
  {0x868E, 0xB0FE}, //956 #HANGUL SYLLABLE NIEUN YAE PIEUPSIOS
  {0x868F, 0xB0FF}, //957 #HANGUL SYLLABLE NIEUN YAE SIOS
  {0x8690, 0xB100}, //958 #HANGUL SYLLABLE NIEUN YAE SSANGSIOS
  {0x8691, 0xB101}, //959 #HANGUL SYLLABLE NIEUN YAE IEUNG
  {0x8692, 0xB102}, //960 #HANGUL SYLLABLE NIEUN YAE CIEUC
  {0x8693, 0xB103}, //961 #HANGUL SYLLABLE NIEUN YAE CHIEUCH
  {0x8694, 0xB104}, //962 #HANGUL SYLLABLE NIEUN YAE KHIEUKH
  {0x8695, 0xB105}, //963 #HANGUL SYLLABLE NIEUN YAE THIEUTH
  {0x8696, 0xB106}, //964 #HANGUL SYLLABLE NIEUN YAE PHIEUPH
  {0x8697, 0xB107}, //965 #HANGUL SYLLABLE NIEUN YAE HIEUH
  {0x8698, 0xB10A}, //966 #HANGUL SYLLABLE NIEUN EO SSANGKIYEOK
  {0x8699, 0xB10D}, //967 #HANGUL SYLLABLE NIEUN EO NIEUNCIEUC
  {0x869A, 0xB10E}, //968 #HANGUL SYLLABLE NIEUN EO NIEUNHIEUH
  {0x869B, 0xB10F}, //969 #HANGUL SYLLABLE NIEUN EO TIKEUT
  {0x869C, 0xB111}, //970 #HANGUL SYLLABLE NIEUN EO RIEULKIYEOK
  {0x869D, 0xB114}, //971 #HANGUL SYLLABLE NIEUN EO RIEULSIOS
  {0x869E, 0xB115}, //972 #HANGUL SYLLABLE NIEUN EO RIEULTHIEUTH
  {0x869F, 0xB116}, //973 #HANGUL SYLLABLE NIEUN EO RIEULPHIEUPH
  {0x86A0, 0xB117}, //974 #HANGUL SYLLABLE NIEUN EO RIEULHIEUH
  {0x86A1, 0xB11A}, //975 #HANGUL SYLLABLE NIEUN EO PIEUPSIOS
  {0x86A2, 0xB11E}, //976 #HANGUL SYLLABLE NIEUN EO CIEUC
  {0x86A3, 0xB11F}, //977 #HANGUL SYLLABLE NIEUN EO CHIEUCH
  {0x86A4, 0xB120}, //978 #HANGUL SYLLABLE NIEUN EO KHIEUKH
  {0x86A5, 0xB121}, //979 #HANGUL SYLLABLE NIEUN EO THIEUTH
  {0x86A6, 0xB122}, //980 #HANGUL SYLLABLE NIEUN EO PHIEUPH
  {0x86A7, 0xB126}, //981 #HANGUL SYLLABLE NIEUN E SSANGKIYEOK
  {0x86A8, 0xB127}, //982 #HANGUL SYLLABLE NIEUN E KIYEOKSIOS
  {0x86A9, 0xB129}, //983 #HANGUL SYLLABLE NIEUN E NIEUNCIEUC
  {0x86AA, 0xB12A}, //984 #HANGUL SYLLABLE NIEUN E NIEUNHIEUH
  {0x86AB, 0xB12B}, //985 #HANGUL SYLLABLE NIEUN E TIKEUT
  {0x86AC, 0xB12D}, //986 #HANGUL SYLLABLE NIEUN E RIEULKIYEOK
  {0x86AD, 0xB12E}, //987 #HANGUL SYLLABLE NIEUN E RIEULMIEUM
  {0x86AE, 0xB12F}, //988 #HANGUL SYLLABLE NIEUN E RIEULPIEUP
  {0x86AF, 0xB130}, //989 #HANGUL SYLLABLE NIEUN E RIEULSIOS
  {0x86B0, 0xB131}, //990 #HANGUL SYLLABLE NIEUN E RIEULTHIEUTH
  {0x86B1, 0xB132}, //991 #HANGUL SYLLABLE NIEUN E RIEULPHIEUPH
  {0x86B2, 0xB133}, //992 #HANGUL SYLLABLE NIEUN E RIEULHIEUH
  {0x86B3, 0xB136}, //993 #HANGUL SYLLABLE NIEUN E PIEUPSIOS
  {0x86B4, 0xB13A}, //994 #HANGUL SYLLABLE NIEUN E CIEUC
  {0x86B5, 0xB13B}, //995 #HANGUL SYLLABLE NIEUN E CHIEUCH
  {0x86B6, 0xB13C}, //996 #HANGUL SYLLABLE NIEUN E KHIEUKH
  {0x86B7, 0xB13D}, //997 #HANGUL SYLLABLE NIEUN E THIEUTH
  {0x86B8, 0xB13E}, //998 #HANGUL SYLLABLE NIEUN E PHIEUPH
  {0x86B9, 0xB13F}, //999 #HANGUL SYLLABLE NIEUN E HIEUH
  {0x86BA, 0xB142}, //1000 #HANGUL SYLLABLE NIEUN YEO SSANGKIYEOK
  {0x86BB, 0xB143}, //1001 #HANGUL SYLLABLE NIEUN YEO KIYEOKSIOS
  {0x86BC, 0xB145}, //1002 #HANGUL SYLLABLE NIEUN YEO NIEUNCIEUC
  {0x86BD, 0xB146}, //1003 #HANGUL SYLLABLE NIEUN YEO NIEUNHIEUH
  {0x86BE, 0xB147}, //1004 #HANGUL SYLLABLE NIEUN YEO TIKEUT
  {0x86BF, 0xB149}, //1005 #HANGUL SYLLABLE NIEUN YEO RIEULKIYEOK
  {0x86C0, 0xB14A}, //1006 #HANGUL SYLLABLE NIEUN YEO RIEULMIEUM
  {0x86C1, 0xB14B}, //1007 #HANGUL SYLLABLE NIEUN YEO RIEULPIEUP
  {0x86C2, 0xB14C}, //1008 #HANGUL SYLLABLE NIEUN YEO RIEULSIOS
  {0x86C3, 0xB14D}, //1009 #HANGUL SYLLABLE NIEUN YEO RIEULTHIEUTH
  {0x86C4, 0xB14E}, //1010 #HANGUL SYLLABLE NIEUN YEO RIEULPHIEUPH
  {0x86C5, 0xB14F}, //1011 #HANGUL SYLLABLE NIEUN YEO RIEULHIEUH
  {0x86C6, 0xB152}, //1012 #HANGUL SYLLABLE NIEUN YEO PIEUPSIOS
  {0x86C7, 0xB153}, //1013 #HANGUL SYLLABLE NIEUN YEO SIOS
  {0x86C8, 0xB156}, //1014 #HANGUL SYLLABLE NIEUN YEO CIEUC
  {0x86C9, 0xB157}, //1015 #HANGUL SYLLABLE NIEUN YEO CHIEUCH
  {0x86CA, 0xB159}, //1016 #HANGUL SYLLABLE NIEUN YEO THIEUTH
  {0x86CB, 0xB15A}, //1017 #HANGUL SYLLABLE NIEUN YEO PHIEUPH
  {0x86CC, 0xB15B}, //1018 #HANGUL SYLLABLE NIEUN YEO HIEUH
  {0x86CD, 0xB15D}, //1019 #HANGUL SYLLABLE NIEUN YE KIYEOK
  {0x86CE, 0xB15E}, //1020 #HANGUL SYLLABLE NIEUN YE SSANGKIYEOK
  {0x86CF, 0xB15F}, //1021 #HANGUL SYLLABLE NIEUN YE KIYEOKSIOS
  {0x86D0, 0xB161}, //1022 #HANGUL SYLLABLE NIEUN YE NIEUNCIEUC
  {0x86D1, 0xB162}, //1023 #HANGUL SYLLABLE NIEUN YE NIEUNHIEUH
  {0x86D2, 0xB163}, //1024 #HANGUL SYLLABLE NIEUN YE TIKEUT
  {0x86D3, 0xB164}, //1025 #HANGUL SYLLABLE NIEUN YE RIEUL
  {0x86D4, 0xB165}, //1026 #HANGUL SYLLABLE NIEUN YE RIEULKIYEOK
  {0x86D5, 0xB166}, //1027 #HANGUL SYLLABLE NIEUN YE RIEULMIEUM
  {0x86D6, 0xB167}, //1028 #HANGUL SYLLABLE NIEUN YE RIEULPIEUP
  {0x86D7, 0xB168}, //1029 #HANGUL SYLLABLE NIEUN YE RIEULSIOS
  {0x86D8, 0xB169}, //1030 #HANGUL SYLLABLE NIEUN YE RIEULTHIEUTH
  {0x86D9, 0xB16A}, //1031 #HANGUL SYLLABLE NIEUN YE RIEULPHIEUPH
  {0x86DA, 0xB16B}, //1032 #HANGUL SYLLABLE NIEUN YE RIEULHIEUH
  {0x86DB, 0xB16C}, //1033 #HANGUL SYLLABLE NIEUN YE MIEUM
  {0x86DC, 0xB16D}, //1034 #HANGUL SYLLABLE NIEUN YE PIEUP
  {0x86DD, 0xB16E}, //1035 #HANGUL SYLLABLE NIEUN YE PIEUPSIOS
  {0x86DE, 0xB16F}, //1036 #HANGUL SYLLABLE NIEUN YE SIOS
  {0x86DF, 0xB170}, //1037 #HANGUL SYLLABLE NIEUN YE SSANGSIOS
  {0x86E0, 0xB171}, //1038 #HANGUL SYLLABLE NIEUN YE IEUNG
  {0x86E1, 0xB172}, //1039 #HANGUL SYLLABLE NIEUN YE CIEUC
  {0x86E2, 0xB173}, //1040 #HANGUL SYLLABLE NIEUN YE CHIEUCH
  {0x86E3, 0xB174}, //1041 #HANGUL SYLLABLE NIEUN YE KHIEUKH
  {0x86E4, 0xB175}, //1042 #HANGUL SYLLABLE NIEUN YE THIEUTH
  {0x86E5, 0xB176}, //1043 #HANGUL SYLLABLE NIEUN YE PHIEUPH
  {0x86E6, 0xB177}, //1044 #HANGUL SYLLABLE NIEUN YE HIEUH
  {0x86E7, 0xB17A}, //1045 #HANGUL SYLLABLE NIEUN O SSANGKIYEOK
  {0x86E8, 0xB17B}, //1046 #HANGUL SYLLABLE NIEUN O KIYEOKSIOS
  {0x86E9, 0xB17D}, //1047 #HANGUL SYLLABLE NIEUN O NIEUNCIEUC
  {0x86EA, 0xB17E}, //1048 #HANGUL SYLLABLE NIEUN O NIEUNHIEUH
  {0x86EB, 0xB17F}, //1049 #HANGUL SYLLABLE NIEUN O TIKEUT
  {0x86EC, 0xB181}, //1050 #HANGUL SYLLABLE NIEUN O RIEULKIYEOK
  {0x86ED, 0xB183}, //1051 #HANGUL SYLLABLE NIEUN O RIEULPIEUP
  {0x86EE, 0xB184}, //1052 #HANGUL SYLLABLE NIEUN O RIEULSIOS
  {0x86EF, 0xB185}, //1053 #HANGUL SYLLABLE NIEUN O RIEULTHIEUTH
  {0x86F0, 0xB186}, //1054 #HANGUL SYLLABLE NIEUN O RIEULPHIEUPH
  {0x86F1, 0xB187}, //1055 #HANGUL SYLLABLE NIEUN O RIEULHIEUH
  {0x86F2, 0xB18A}, //1056 #HANGUL SYLLABLE NIEUN O PIEUPSIOS
  {0x86F3, 0xB18C}, //1057 #HANGUL SYLLABLE NIEUN O SSANGSIOS
  {0x86F4, 0xB18E}, //1058 #HANGUL SYLLABLE NIEUN O CIEUC
  {0x86F5, 0xB18F}, //1059 #HANGUL SYLLABLE NIEUN O CHIEUCH
  {0x86F6, 0xB190}, //1060 #HANGUL SYLLABLE NIEUN O KHIEUKH
  {0x86F7, 0xB191}, //1061 #HANGUL SYLLABLE NIEUN O THIEUTH
  {0x86F8, 0xB195}, //1062 #HANGUL SYLLABLE NIEUN WA KIYEOK
  {0x86F9, 0xB196}, //1063 #HANGUL SYLLABLE NIEUN WA SSANGKIYEOK
  {0x86FA, 0xB197}, //1064 #HANGUL SYLLABLE NIEUN WA KIYEOKSIOS
  {0x86FB, 0xB199}, //1065 #HANGUL SYLLABLE NIEUN WA NIEUNCIEUC
  {0x86FC, 0xB19A}, //1066 #HANGUL SYLLABLE NIEUN WA NIEUNHIEUH
  {0x86FD, 0xB19B}, //1067 #HANGUL SYLLABLE NIEUN WA TIKEUT
  {0x86FE, 0xB19D}, //1068 #HANGUL SYLLABLE NIEUN WA RIEULKIYEOK
  {0x8741, 0xB19E}, //1069 #HANGUL SYLLABLE NIEUN WA RIEULMIEUM
  {0x8742, 0xB19F}, //1070 #HANGUL SYLLABLE NIEUN WA RIEULPIEUP
  {0x8743, 0xB1A0}, //1071 #HANGUL SYLLABLE NIEUN WA RIEULSIOS
  {0x8744, 0xB1A1}, //1072 #HANGUL SYLLABLE NIEUN WA RIEULTHIEUTH
  {0x8745, 0xB1A2}, //1073 #HANGUL SYLLABLE NIEUN WA RIEULPHIEUPH
  {0x8746, 0xB1A3}, //1074 #HANGUL SYLLABLE NIEUN WA RIEULHIEUH
  {0x8747, 0xB1A4}, //1075 #HANGUL SYLLABLE NIEUN WA MIEUM
  {0x8748, 0xB1A5}, //1076 #HANGUL SYLLABLE NIEUN WA PIEUP
  {0x8749, 0xB1A6}, //1077 #HANGUL SYLLABLE NIEUN WA PIEUPSIOS
  {0x874A, 0xB1A7}, //1078 #HANGUL SYLLABLE NIEUN WA SIOS
  {0x874B, 0xB1A9}, //1079 #HANGUL SYLLABLE NIEUN WA IEUNG
  {0x874C, 0xB1AA}, //1080 #HANGUL SYLLABLE NIEUN WA CIEUC
  {0x874D, 0xB1AB}, //1081 #HANGUL SYLLABLE NIEUN WA CHIEUCH
  {0x874E, 0xB1AC}, //1082 #HANGUL SYLLABLE NIEUN WA KHIEUKH
  {0x874F, 0xB1AD}, //1083 #HANGUL SYLLABLE NIEUN WA THIEUTH
  {0x8750, 0xB1AE}, //1084 #HANGUL SYLLABLE NIEUN WA PHIEUPH
  {0x8751, 0xB1AF}, //1085 #HANGUL SYLLABLE NIEUN WA HIEUH
  {0x8752, 0xB1B0}, //1086 #HANGUL SYLLABLE NIEUN WAE
  {0x8753, 0xB1B1}, //1087 #HANGUL SYLLABLE NIEUN WAE KIYEOK
  {0x8754, 0xB1B2}, //1088 #HANGUL SYLLABLE NIEUN WAE SSANGKIYEOK
  {0x8755, 0xB1B3}, //1089 #HANGUL SYLLABLE NIEUN WAE KIYEOKSIOS
  {0x8756, 0xB1B4}, //1090 #HANGUL SYLLABLE NIEUN WAE NIEUN
  {0x8757, 0xB1B5}, //1091 #HANGUL SYLLABLE NIEUN WAE NIEUNCIEUC
  {0x8758, 0xB1B6}, //1092 #HANGUL SYLLABLE NIEUN WAE NIEUNHIEUH
  {0x8759, 0xB1B7}, //1093 #HANGUL SYLLABLE NIEUN WAE TIKEUT
  {0x875A, 0xB1B8}, //1094 #HANGUL SYLLABLE NIEUN WAE RIEUL
  {0x8761, 0xB1B9}, //1095 #HANGUL SYLLABLE NIEUN WAE RIEULKIYEOK
  {0x8762, 0xB1BA}, //1096 #HANGUL SYLLABLE NIEUN WAE RIEULMIEUM
  {0x8763, 0xB1BB}, //1097 #HANGUL SYLLABLE NIEUN WAE RIEULPIEUP
  {0x8764, 0xB1BC}, //1098 #HANGUL SYLLABLE NIEUN WAE RIEULSIOS
  {0x8765, 0xB1BD}, //1099 #HANGUL SYLLABLE NIEUN WAE RIEULTHIEUTH
  {0x8766, 0xB1BE}, //1100 #HANGUL SYLLABLE NIEUN WAE RIEULPHIEUPH
  {0x8767, 0xB1BF}, //1101 #HANGUL SYLLABLE NIEUN WAE RIEULHIEUH
  {0x8768, 0xB1C0}, //1102 #HANGUL SYLLABLE NIEUN WAE MIEUM
  {0x8769, 0xB1C1}, //1103 #HANGUL SYLLABLE NIEUN WAE PIEUP
  {0x876A, 0xB1C2}, //1104 #HANGUL SYLLABLE NIEUN WAE PIEUPSIOS
  {0x876B, 0xB1C3}, //1105 #HANGUL SYLLABLE NIEUN WAE SIOS
  {0x876C, 0xB1C4}, //1106 #HANGUL SYLLABLE NIEUN WAE SSANGSIOS
  {0x876D, 0xB1C5}, //1107 #HANGUL SYLLABLE NIEUN WAE IEUNG
  {0x876E, 0xB1C6}, //1108 #HANGUL SYLLABLE NIEUN WAE CIEUC
  {0x876F, 0xB1C7}, //1109 #HANGUL SYLLABLE NIEUN WAE CHIEUCH
  {0x8770, 0xB1C8}, //1110 #HANGUL SYLLABLE NIEUN WAE KHIEUKH
  {0x8771, 0xB1C9}, //1111 #HANGUL SYLLABLE NIEUN WAE THIEUTH
  {0x8772, 0xB1CA}, //1112 #HANGUL SYLLABLE NIEUN WAE PHIEUPH
  {0x8773, 0xB1CB}, //1113 #HANGUL SYLLABLE NIEUN WAE HIEUH
  {0x8774, 0xB1CD}, //1114 #HANGUL SYLLABLE NIEUN OE KIYEOK
  {0x8775, 0xB1CE}, //1115 #HANGUL SYLLABLE NIEUN OE SSANGKIYEOK
  {0x8776, 0xB1CF}, //1116 #HANGUL SYLLABLE NIEUN OE KIYEOKSIOS
  {0x8777, 0xB1D1}, //1117 #HANGUL SYLLABLE NIEUN OE NIEUNCIEUC
  {0x8778, 0xB1D2}, //1118 #HANGUL SYLLABLE NIEUN OE NIEUNHIEUH
  {0x8779, 0xB1D3}, //1119 #HANGUL SYLLABLE NIEUN OE TIKEUT
  {0x877A, 0xB1D5}, //1120 #HANGUL SYLLABLE NIEUN OE RIEULKIYEOK
  {0x8781, 0xB1D6}, //1121 #HANGUL SYLLABLE NIEUN OE RIEULMIEUM
  {0x8782, 0xB1D7}, //1122 #HANGUL SYLLABLE NIEUN OE RIEULPIEUP
  {0x8783, 0xB1D8}, //1123 #HANGUL SYLLABLE NIEUN OE RIEULSIOS
  {0x8784, 0xB1D9}, //1124 #HANGUL SYLLABLE NIEUN OE RIEULTHIEUTH
  {0x8785, 0xB1DA}, //1125 #HANGUL SYLLABLE NIEUN OE RIEULPHIEUPH
  {0x8786, 0xB1DB}, //1126 #HANGUL SYLLABLE NIEUN OE RIEULHIEUH
  {0x8787, 0xB1DE}, //1127 #HANGUL SYLLABLE NIEUN OE PIEUPSIOS
  {0x8788, 0xB1E0}, //1128 #HANGUL SYLLABLE NIEUN OE SSANGSIOS
  {0x8789, 0xB1E1}, //1129 #HANGUL SYLLABLE NIEUN OE IEUNG
  {0x878A, 0xB1E2}, //1130 #HANGUL SYLLABLE NIEUN OE CIEUC
  {0x878B, 0xB1E3}, //1131 #HANGUL SYLLABLE NIEUN OE CHIEUCH
  {0x878C, 0xB1E4}, //1132 #HANGUL SYLLABLE NIEUN OE KHIEUKH
  {0x878D, 0xB1E5}, //1133 #HANGUL SYLLABLE NIEUN OE THIEUTH
  {0x878E, 0xB1E6}, //1134 #HANGUL SYLLABLE NIEUN OE PHIEUPH
  {0x878F, 0xB1E7}, //1135 #HANGUL SYLLABLE NIEUN OE HIEUH
  {0x8790, 0xB1EA}, //1136 #HANGUL SYLLABLE NIEUN YO SSANGKIYEOK
  {0x8791, 0xB1EB}, //1137 #HANGUL SYLLABLE NIEUN YO KIYEOKSIOS
  {0x8792, 0xB1ED}, //1138 #HANGUL SYLLABLE NIEUN YO NIEUNCIEUC
  {0x8793, 0xB1EE}, //1139 #HANGUL SYLLABLE NIEUN YO NIEUNHIEUH
  {0x8794, 0xB1EF}, //1140 #HANGUL SYLLABLE NIEUN YO TIKEUT
  {0x8795, 0xB1F1}, //1141 #HANGUL SYLLABLE NIEUN YO RIEULKIYEOK
  {0x8796, 0xB1F2}, //1142 #HANGUL SYLLABLE NIEUN YO RIEULMIEUM
  {0x8797, 0xB1F3}, //1143 #HANGUL SYLLABLE NIEUN YO RIEULPIEUP
  {0x8798, 0xB1F4}, //1144 #HANGUL SYLLABLE NIEUN YO RIEULSIOS
  {0x8799, 0xB1F5}, //1145 #HANGUL SYLLABLE NIEUN YO RIEULTHIEUTH
  {0x879A, 0xB1F6}, //1146 #HANGUL SYLLABLE NIEUN YO RIEULPHIEUPH
  {0x879B, 0xB1F7}, //1147 #HANGUL SYLLABLE NIEUN YO RIEULHIEUH
  {0x879C, 0xB1F8}, //1148 #HANGUL SYLLABLE NIEUN YO MIEUM
  {0x879D, 0xB1FA}, //1149 #HANGUL SYLLABLE NIEUN YO PIEUPSIOS
  {0x879E, 0xB1FC}, //1150 #HANGUL SYLLABLE NIEUN YO SSANGSIOS
  {0x879F, 0xB1FE}, //1151 #HANGUL SYLLABLE NIEUN YO CIEUC
  {0x87A0, 0xB1FF}, //1152 #HANGUL SYLLABLE NIEUN YO CHIEUCH
  {0x87A1, 0xB200}, //1153 #HANGUL SYLLABLE NIEUN YO KHIEUKH
  {0x87A2, 0xB201}, //1154 #HANGUL SYLLABLE NIEUN YO THIEUTH
  {0x87A3, 0xB202}, //1155 #HANGUL SYLLABLE NIEUN YO PHIEUPH
  {0x87A4, 0xB203}, //1156 #HANGUL SYLLABLE NIEUN YO HIEUH
  {0x87A5, 0xB206}, //1157 #HANGUL SYLLABLE NIEUN U SSANGKIYEOK
  {0x87A6, 0xB207}, //1158 #HANGUL SYLLABLE NIEUN U KIYEOKSIOS
  {0x87A7, 0xB209}, //1159 #HANGUL SYLLABLE NIEUN U NIEUNCIEUC
  {0x87A8, 0xB20A}, //1160 #HANGUL SYLLABLE NIEUN U NIEUNHIEUH
  {0x87A9, 0xB20D}, //1161 #HANGUL SYLLABLE NIEUN U RIEULKIYEOK
  {0x87AA, 0xB20E}, //1162 #HANGUL SYLLABLE NIEUN U RIEULMIEUM
  {0x87AB, 0xB20F}, //1163 #HANGUL SYLLABLE NIEUN U RIEULPIEUP
  {0x87AC, 0xB210}, //1164 #HANGUL SYLLABLE NIEUN U RIEULSIOS
  {0x87AD, 0xB211}, //1165 #HANGUL SYLLABLE NIEUN U RIEULTHIEUTH
  {0x87AE, 0xB212}, //1166 #HANGUL SYLLABLE NIEUN U RIEULPHIEUPH
  {0x87AF, 0xB213}, //1167 #HANGUL SYLLABLE NIEUN U RIEULHIEUH
  {0x87B0, 0xB216}, //1168 #HANGUL SYLLABLE NIEUN U PIEUPSIOS
  {0x87B1, 0xB218}, //1169 #HANGUL SYLLABLE NIEUN U SSANGSIOS
  {0x87B2, 0xB21A}, //1170 #HANGUL SYLLABLE NIEUN U CIEUC
  {0x87B3, 0xB21B}, //1171 #HANGUL SYLLABLE NIEUN U CHIEUCH
  {0x87B4, 0xB21C}, //1172 #HANGUL SYLLABLE NIEUN U KHIEUKH
  {0x87B5, 0xB21D}, //1173 #HANGUL SYLLABLE NIEUN U THIEUTH
  {0x87B6, 0xB21E}, //1174 #HANGUL SYLLABLE NIEUN U PHIEUPH
  {0x87B7, 0xB21F}, //1175 #HANGUL SYLLABLE NIEUN U HIEUH
  {0x87B8, 0xB221}, //1176 #HANGUL SYLLABLE NIEUN WEO KIYEOK
  {0x87B9, 0xB222}, //1177 #HANGUL SYLLABLE NIEUN WEO SSANGKIYEOK
  {0x87BA, 0xB223}, //1178 #HANGUL SYLLABLE NIEUN WEO KIYEOKSIOS
  {0x87BB, 0xB224}, //1179 #HANGUL SYLLABLE NIEUN WEO NIEUN
  {0x87BC, 0xB225}, //1180 #HANGUL SYLLABLE NIEUN WEO NIEUNCIEUC
  {0x87BD, 0xB226}, //1181 #HANGUL SYLLABLE NIEUN WEO NIEUNHIEUH
  {0x87BE, 0xB227}, //1182 #HANGUL SYLLABLE NIEUN WEO TIKEUT
  {0x87BF, 0xB228}, //1183 #HANGUL SYLLABLE NIEUN WEO RIEUL
  {0x87C0, 0xB229}, //1184 #HANGUL SYLLABLE NIEUN WEO RIEULKIYEOK
  {0x87C1, 0xB22A}, //1185 #HANGUL SYLLABLE NIEUN WEO RIEULMIEUM
  {0x87C2, 0xB22B}, //1186 #HANGUL SYLLABLE NIEUN WEO RIEULPIEUP
  {0x87C3, 0xB22C}, //1187 #HANGUL SYLLABLE NIEUN WEO RIEULSIOS
  {0x87C4, 0xB22D}, //1188 #HANGUL SYLLABLE NIEUN WEO RIEULTHIEUTH
  {0x87C5, 0xB22E}, //1189 #HANGUL SYLLABLE NIEUN WEO RIEULPHIEUPH
  {0x87C6, 0xB22F}, //1190 #HANGUL SYLLABLE NIEUN WEO RIEULHIEUH
  {0x87C7, 0xB230}, //1191 #HANGUL SYLLABLE NIEUN WEO MIEUM
  {0x87C8, 0xB231}, //1192 #HANGUL SYLLABLE NIEUN WEO PIEUP
  {0x87C9, 0xB232}, //1193 #HANGUL SYLLABLE NIEUN WEO PIEUPSIOS
  {0x87CA, 0xB233}, //1194 #HANGUL SYLLABLE NIEUN WEO SIOS
  {0x87CB, 0xB235}, //1195 #HANGUL SYLLABLE NIEUN WEO IEUNG
  {0x87CC, 0xB236}, //1196 #HANGUL SYLLABLE NIEUN WEO CIEUC
  {0x87CD, 0xB237}, //1197 #HANGUL SYLLABLE NIEUN WEO CHIEUCH
  {0x87CE, 0xB238}, //1198 #HANGUL SYLLABLE NIEUN WEO KHIEUKH
  {0x87CF, 0xB239}, //1199 #HANGUL SYLLABLE NIEUN WEO THIEUTH
  {0x87D0, 0xB23A}, //1200 #HANGUL SYLLABLE NIEUN WEO PHIEUPH
  {0x87D1, 0xB23B}, //1201 #HANGUL SYLLABLE NIEUN WEO HIEUH
  {0x87D2, 0xB23D}, //1202 #HANGUL SYLLABLE NIEUN WE KIYEOK
  {0x87D3, 0xB23E}, //1203 #HANGUL SYLLABLE NIEUN WE SSANGKIYEOK
  {0x87D4, 0xB23F}, //1204 #HANGUL SYLLABLE NIEUN WE KIYEOKSIOS
  {0x87D5, 0xB240}, //1205 #HANGUL SYLLABLE NIEUN WE NIEUN
  {0x87D6, 0xB241}, //1206 #HANGUL SYLLABLE NIEUN WE NIEUNCIEUC
  {0x87D7, 0xB242}, //1207 #HANGUL SYLLABLE NIEUN WE NIEUNHIEUH
  {0x87D8, 0xB243}, //1208 #HANGUL SYLLABLE NIEUN WE TIKEUT
  {0x87D9, 0xB244}, //1209 #HANGUL SYLLABLE NIEUN WE RIEUL
  {0x87DA, 0xB245}, //1210 #HANGUL SYLLABLE NIEUN WE RIEULKIYEOK
  {0x87DB, 0xB246}, //1211 #HANGUL SYLLABLE NIEUN WE RIEULMIEUM
  {0x87DC, 0xB247}, //1212 #HANGUL SYLLABLE NIEUN WE RIEULPIEUP
  {0x87DD, 0xB248}, //1213 #HANGUL SYLLABLE NIEUN WE RIEULSIOS
  {0x87DE, 0xB249}, //1214 #HANGUL SYLLABLE NIEUN WE RIEULTHIEUTH
  {0x87DF, 0xB24A}, //1215 #HANGUL SYLLABLE NIEUN WE RIEULPHIEUPH
  {0x87E0, 0xB24B}, //1216 #HANGUL SYLLABLE NIEUN WE RIEULHIEUH
  {0x87E1, 0xB24C}, //1217 #HANGUL SYLLABLE NIEUN WE MIEUM
  {0x87E2, 0xB24D}, //1218 #HANGUL SYLLABLE NIEUN WE PIEUP
  {0x87E3, 0xB24E}, //1219 #HANGUL SYLLABLE NIEUN WE PIEUPSIOS
  {0x87E4, 0xB24F}, //1220 #HANGUL SYLLABLE NIEUN WE SIOS
  {0x87E5, 0xB250}, //1221 #HANGUL SYLLABLE NIEUN WE SSANGSIOS
  {0x87E6, 0xB251}, //1222 #HANGUL SYLLABLE NIEUN WE IEUNG
  {0x87E7, 0xB252}, //1223 #HANGUL SYLLABLE NIEUN WE CIEUC
  {0x87E8, 0xB253}, //1224 #HANGUL SYLLABLE NIEUN WE CHIEUCH
  {0x87E9, 0xB254}, //1225 #HANGUL SYLLABLE NIEUN WE KHIEUKH
  {0x87EA, 0xB255}, //1226 #HANGUL SYLLABLE NIEUN WE THIEUTH
  {0x87EB, 0xB256}, //1227 #HANGUL SYLLABLE NIEUN WE PHIEUPH
  {0x87EC, 0xB257}, //1228 #HANGUL SYLLABLE NIEUN WE HIEUH
  {0x87ED, 0xB259}, //1229 #HANGUL SYLLABLE NIEUN WI KIYEOK
  {0x87EE, 0xB25A}, //1230 #HANGUL SYLLABLE NIEUN WI SSANGKIYEOK
  {0x87EF, 0xB25B}, //1231 #HANGUL SYLLABLE NIEUN WI KIYEOKSIOS
  {0x87F0, 0xB25D}, //1232 #HANGUL SYLLABLE NIEUN WI NIEUNCIEUC
  {0x87F1, 0xB25E}, //1233 #HANGUL SYLLABLE NIEUN WI NIEUNHIEUH
  {0x87F2, 0xB25F}, //1234 #HANGUL SYLLABLE NIEUN WI TIKEUT
  {0x87F3, 0xB261}, //1235 #HANGUL SYLLABLE NIEUN WI RIEULKIYEOK
  {0x87F4, 0xB262}, //1236 #HANGUL SYLLABLE NIEUN WI RIEULMIEUM
  {0x87F5, 0xB263}, //1237 #HANGUL SYLLABLE NIEUN WI RIEULPIEUP
  {0x87F6, 0xB264}, //1238 #HANGUL SYLLABLE NIEUN WI RIEULSIOS
  {0x87F7, 0xB265}, //1239 #HANGUL SYLLABLE NIEUN WI RIEULTHIEUTH
  {0x87F8, 0xB266}, //1240 #HANGUL SYLLABLE NIEUN WI RIEULPHIEUPH
  {0x87F9, 0xB267}, //1241 #HANGUL SYLLABLE NIEUN WI RIEULHIEUH
  {0x87FA, 0xB26A}, //1242 #HANGUL SYLLABLE NIEUN WI PIEUPSIOS
  {0x87FB, 0xB26B}, //1243 #HANGUL SYLLABLE NIEUN WI SIOS
  {0x87FC, 0xB26C}, //1244 #HANGUL SYLLABLE NIEUN WI SSANGSIOS
  {0x87FD, 0xB26D}, //1245 #HANGUL SYLLABLE NIEUN WI IEUNG
  {0x87FE, 0xB26E}, //1246 #HANGUL SYLLABLE NIEUN WI CIEUC
  {0x8841, 0xB26F}, //1247 #HANGUL SYLLABLE NIEUN WI CHIEUCH
  {0x8842, 0xB270}, //1248 #HANGUL SYLLABLE NIEUN WI KHIEUKH
  {0x8843, 0xB271}, //1249 #HANGUL SYLLABLE NIEUN WI THIEUTH
  {0x8844, 0xB272}, //1250 #HANGUL SYLLABLE NIEUN WI PHIEUPH
  {0x8845, 0xB273}, //1251 #HANGUL SYLLABLE NIEUN WI HIEUH
  {0x8846, 0xB276}, //1252 #HANGUL SYLLABLE NIEUN YU SSANGKIYEOK
  {0x8847, 0xB277}, //1253 #HANGUL SYLLABLE NIEUN YU KIYEOKSIOS
  {0x8848, 0xB278}, //1254 #HANGUL SYLLABLE NIEUN YU NIEUN
  {0x8849, 0xB279}, //1255 #HANGUL SYLLABLE NIEUN YU NIEUNCIEUC
  {0x884A, 0xB27A}, //1256 #HANGUL SYLLABLE NIEUN YU NIEUNHIEUH
  {0x884B, 0xB27B}, //1257 #HANGUL SYLLABLE NIEUN YU TIKEUT
  {0x884C, 0xB27D}, //1258 #HANGUL SYLLABLE NIEUN YU RIEULKIYEOK
  {0x884D, 0xB27E}, //1259 #HANGUL SYLLABLE NIEUN YU RIEULMIEUM
  {0x884E, 0xB27F}, //1260 #HANGUL SYLLABLE NIEUN YU RIEULPIEUP
  {0x884F, 0xB280}, //1261 #HANGUL SYLLABLE NIEUN YU RIEULSIOS
  {0x8850, 0xB281}, //1262 #HANGUL SYLLABLE NIEUN YU RIEULTHIEUTH
  {0x8851, 0xB282}, //1263 #HANGUL SYLLABLE NIEUN YU RIEULPHIEUPH
  {0x8852, 0xB283}, //1264 #HANGUL SYLLABLE NIEUN YU RIEULHIEUH
  {0x8853, 0xB286}, //1265 #HANGUL SYLLABLE NIEUN YU PIEUPSIOS
  {0x8854, 0xB287}, //1266 #HANGUL SYLLABLE NIEUN YU SIOS
  {0x8855, 0xB288}, //1267 #HANGUL SYLLABLE NIEUN YU SSANGSIOS
  {0x8856, 0xB28A}, //1268 #HANGUL SYLLABLE NIEUN YU CIEUC
  {0x8857, 0xB28B}, //1269 #HANGUL SYLLABLE NIEUN YU CHIEUCH
  {0x8858, 0xB28C}, //1270 #HANGUL SYLLABLE NIEUN YU KHIEUKH
  {0x8859, 0xB28D}, //1271 #HANGUL SYLLABLE NIEUN YU THIEUTH
  {0x885A, 0xB28E}, //1272 #HANGUL SYLLABLE NIEUN YU PHIEUPH
  {0x8861, 0xB28F}, //1273 #HANGUL SYLLABLE NIEUN YU HIEUH
  {0x8862, 0xB292}, //1274 #HANGUL SYLLABLE NIEUN EU SSANGKIYEOK
  {0x8863, 0xB293}, //1275 #HANGUL SYLLABLE NIEUN EU KIYEOKSIOS
  {0x8864, 0xB295}, //1276 #HANGUL SYLLABLE NIEUN EU NIEUNCIEUC
  {0x8865, 0xB296}, //1277 #HANGUL SYLLABLE NIEUN EU NIEUNHIEUH
  {0x8866, 0xB297}, //1278 #HANGUL SYLLABLE NIEUN EU TIKEUT
  {0x8867, 0xB29B}, //1279 #HANGUL SYLLABLE NIEUN EU RIEULPIEUP
  {0x8868, 0xB29C}, //1280 #HANGUL SYLLABLE NIEUN EU RIEULSIOS
  {0x8869, 0xB29D}, //1281 #HANGUL SYLLABLE NIEUN EU RIEULTHIEUTH
  {0x886A, 0xB29E}, //1282 #HANGUL SYLLABLE NIEUN EU RIEULPHIEUPH
  {0x886B, 0xB29F}, //1283 #HANGUL SYLLABLE NIEUN EU RIEULHIEUH
  {0x886C, 0xB2A2}, //1284 #HANGUL SYLLABLE NIEUN EU PIEUPSIOS
  {0x886D, 0xB2A4}, //1285 #HANGUL SYLLABLE NIEUN EU SSANGSIOS
  {0x886E, 0xB2A7}, //1286 #HANGUL SYLLABLE NIEUN EU CHIEUCH
  {0x886F, 0xB2A8}, //1287 #HANGUL SYLLABLE NIEUN EU KHIEUKH
  {0x8870, 0xB2A9}, //1288 #HANGUL SYLLABLE NIEUN EU THIEUTH
  {0x8871, 0xB2AB}, //1289 #HANGUL SYLLABLE NIEUN EU HIEUH
  {0x8872, 0xB2AD}, //1290 #HANGUL SYLLABLE NIEUN YI KIYEOK
  {0x8873, 0xB2AE}, //1291 #HANGUL SYLLABLE NIEUN YI SSANGKIYEOK
  {0x8874, 0xB2AF}, //1292 #HANGUL SYLLABLE NIEUN YI KIYEOKSIOS
  {0x8875, 0xB2B1}, //1293 #HANGUL SYLLABLE NIEUN YI NIEUNCIEUC
  {0x8876, 0xB2B2}, //1294 #HANGUL SYLLABLE NIEUN YI NIEUNHIEUH
  {0x8877, 0xB2B3}, //1295 #HANGUL SYLLABLE NIEUN YI TIKEUT
  {0x8878, 0xB2B5}, //1296 #HANGUL SYLLABLE NIEUN YI RIEULKIYEOK
  {0x8879, 0xB2B6}, //1297 #HANGUL SYLLABLE NIEUN YI RIEULMIEUM
  {0x887A, 0xB2B7}, //1298 #HANGUL SYLLABLE NIEUN YI RIEULPIEUP
  {0x8881, 0xB2B8}, //1299 #HANGUL SYLLABLE NIEUN YI RIEULSIOS
  {0x8882, 0xB2B9}, //1300 #HANGUL SYLLABLE NIEUN YI RIEULTHIEUTH
  {0x8883, 0xB2BA}, //1301 #HANGUL SYLLABLE NIEUN YI RIEULPHIEUPH
  {0x8884, 0xB2BB}, //1302 #HANGUL SYLLABLE NIEUN YI RIEULHIEUH
  {0x8885, 0xB2BC}, //1303 #HANGUL SYLLABLE NIEUN YI MIEUM
  {0x8886, 0xB2BD}, //1304 #HANGUL SYLLABLE NIEUN YI PIEUP
  {0x8887, 0xB2BE}, //1305 #HANGUL SYLLABLE NIEUN YI PIEUPSIOS
  {0x8888, 0xB2BF}, //1306 #HANGUL SYLLABLE NIEUN YI SIOS
  {0x8889, 0xB2C0}, //1307 #HANGUL SYLLABLE NIEUN YI SSANGSIOS
  {0x888A, 0xB2C1}, //1308 #HANGUL SYLLABLE NIEUN YI IEUNG
  {0x888B, 0xB2C2}, //1309 #HANGUL SYLLABLE NIEUN YI CIEUC
  {0x888C, 0xB2C3}, //1310 #HANGUL SYLLABLE NIEUN YI CHIEUCH
  {0x888D, 0xB2C4}, //1311 #HANGUL SYLLABLE NIEUN YI KHIEUKH
  {0x888E, 0xB2C5}, //1312 #HANGUL SYLLABLE NIEUN YI THIEUTH
  {0x888F, 0xB2C6}, //1313 #HANGUL SYLLABLE NIEUN YI PHIEUPH
  {0x8890, 0xB2C7}, //1314 #HANGUL SYLLABLE NIEUN YI HIEUH
  {0x8891, 0xB2CA}, //1315 #HANGUL SYLLABLE NIEUN I SSANGKIYEOK
  {0x8892, 0xB2CB}, //1316 #HANGUL SYLLABLE NIEUN I KIYEOKSIOS
  {0x8893, 0xB2CD}, //1317 #HANGUL SYLLABLE NIEUN I NIEUNCIEUC
  {0x8894, 0xB2CE}, //1318 #HANGUL SYLLABLE NIEUN I NIEUNHIEUH
  {0x8895, 0xB2CF}, //1319 #HANGUL SYLLABLE NIEUN I TIKEUT
  {0x8896, 0xB2D1}, //1320 #HANGUL SYLLABLE NIEUN I RIEULKIYEOK
  {0x8897, 0xB2D3}, //1321 #HANGUL SYLLABLE NIEUN I RIEULPIEUP
  {0x8898, 0xB2D4}, //1322 #HANGUL SYLLABLE NIEUN I RIEULSIOS
  {0x8899, 0xB2D5}, //1323 #HANGUL SYLLABLE NIEUN I RIEULTHIEUTH
  {0x889A, 0xB2D6}, //1324 #HANGUL SYLLABLE NIEUN I RIEULPHIEUPH
  {0x889B, 0xB2D7}, //1325 #HANGUL SYLLABLE NIEUN I RIEULHIEUH
  {0x889C, 0xB2DA}, //1326 #HANGUL SYLLABLE NIEUN I PIEUPSIOS
  {0x889D, 0xB2DC}, //1327 #HANGUL SYLLABLE NIEUN I SSANGSIOS
  {0x889E, 0xB2DE}, //1328 #HANGUL SYLLABLE NIEUN I CIEUC
  {0x889F, 0xB2DF}, //1329 #HANGUL SYLLABLE NIEUN I CHIEUCH
  {0x88A0, 0xB2E0}, //1330 #HANGUL SYLLABLE NIEUN I KHIEUKH
  {0x88A1, 0xB2E1}, //1331 #HANGUL SYLLABLE NIEUN I THIEUTH
  {0x88A2, 0xB2E3}, //1332 #HANGUL SYLLABLE NIEUN I HIEUH
  {0x88A3, 0xB2E7}, //1333 #HANGUL SYLLABLE TIKEUT A KIYEOKSIOS
  {0x88A4, 0xB2E9}, //1334 #HANGUL SYLLABLE TIKEUT A NIEUNCIEUC
  {0x88A5, 0xB2EA}, //1335 #HANGUL SYLLABLE TIKEUT A NIEUNHIEUH
  {0x88A6, 0xB2F0}, //1336 #HANGUL SYLLABLE TIKEUT A RIEULSIOS
  {0x88A7, 0xB2F1}, //1337 #HANGUL SYLLABLE TIKEUT A RIEULTHIEUTH
  {0x88A8, 0xB2F2}, //1338 #HANGUL SYLLABLE TIKEUT A RIEULPHIEUPH
  {0x88A9, 0xB2F6}, //1339 #HANGUL SYLLABLE TIKEUT A PIEUPSIOS
  {0x88AA, 0xB2FC}, //1340 #HANGUL SYLLABLE TIKEUT A KHIEUKH
  {0x88AB, 0xB2FD}, //1341 #HANGUL SYLLABLE TIKEUT A THIEUTH
  {0x88AC, 0xB2FE}, //1342 #HANGUL SYLLABLE TIKEUT A PHIEUPH
  {0x88AD, 0xB302}, //1343 #HANGUL SYLLABLE TIKEUT AE SSANGKIYEOK
  {0x88AE, 0xB303}, //1344 #HANGUL SYLLABLE TIKEUT AE KIYEOKSIOS
  {0x88AF, 0xB305}, //1345 #HANGUL SYLLABLE TIKEUT AE NIEUNCIEUC
  {0x88B0, 0xB306}, //1346 #HANGUL SYLLABLE TIKEUT AE NIEUNHIEUH
  {0x88B1, 0xB307}, //1347 #HANGUL SYLLABLE TIKEUT AE TIKEUT
  {0x88B2, 0xB309}, //1348 #HANGUL SYLLABLE TIKEUT AE RIEULKIYEOK
  {0x88B3, 0xB30A}, //1349 #HANGUL SYLLABLE TIKEUT AE RIEULMIEUM
  {0x88B4, 0xB30B}, //1350 #HANGUL SYLLABLE TIKEUT AE RIEULPIEUP
  {0x88B5, 0xB30C}, //1351 #HANGUL SYLLABLE TIKEUT AE RIEULSIOS
  {0x88B6, 0xB30D}, //1352 #HANGUL SYLLABLE TIKEUT AE RIEULTHIEUTH
  {0x88B7, 0xB30E}, //1353 #HANGUL SYLLABLE TIKEUT AE RIEULPHIEUPH
  {0x88B8, 0xB30F}, //1354 #HANGUL SYLLABLE TIKEUT AE RIEULHIEUH
  {0x88B9, 0xB312}, //1355 #HANGUL SYLLABLE TIKEUT AE PIEUPSIOS
  {0x88BA, 0xB316}, //1356 #HANGUL SYLLABLE TIKEUT AE CIEUC
  {0x88BB, 0xB317}, //1357 #HANGUL SYLLABLE TIKEUT AE CHIEUCH
  {0x88BC, 0xB318}, //1358 #HANGUL SYLLABLE TIKEUT AE KHIEUKH
  {0x88BD, 0xB319}, //1359 #HANGUL SYLLABLE TIKEUT AE THIEUTH
  {0x88BE, 0xB31A}, //1360 #HANGUL SYLLABLE TIKEUT AE PHIEUPH
  {0x88BF, 0xB31B}, //1361 #HANGUL SYLLABLE TIKEUT AE HIEUH
  {0x88C0, 0xB31D}, //1362 #HANGUL SYLLABLE TIKEUT YA KIYEOK
  {0x88C1, 0xB31E}, //1363 #HANGUL SYLLABLE TIKEUT YA SSANGKIYEOK
  {0x88C2, 0xB31F}, //1364 #HANGUL SYLLABLE TIKEUT YA KIYEOKSIOS
  {0x88C3, 0xB320}, //1365 #HANGUL SYLLABLE TIKEUT YA NIEUN
  {0x88C4, 0xB321}, //1366 #HANGUL SYLLABLE TIKEUT YA NIEUNCIEUC
  {0x88C5, 0xB322}, //1367 #HANGUL SYLLABLE TIKEUT YA NIEUNHIEUH
  {0x88C6, 0xB323}, //1368 #HANGUL SYLLABLE TIKEUT YA TIKEUT
  {0x88C7, 0xB324}, //1369 #HANGUL SYLLABLE TIKEUT YA RIEUL
  {0x88C8, 0xB325}, //1370 #HANGUL SYLLABLE TIKEUT YA RIEULKIYEOK
  {0x88C9, 0xB326}, //1371 #HANGUL SYLLABLE TIKEUT YA RIEULMIEUM
  {0x88CA, 0xB327}, //1372 #HANGUL SYLLABLE TIKEUT YA RIEULPIEUP
  {0x88CB, 0xB328}, //1373 #HANGUL SYLLABLE TIKEUT YA RIEULSIOS
  {0x88CC, 0xB329}, //1374 #HANGUL SYLLABLE TIKEUT YA RIEULTHIEUTH
  {0x88CD, 0xB32A}, //1375 #HANGUL SYLLABLE TIKEUT YA RIEULPHIEUPH
  {0x88CE, 0xB32B}, //1376 #HANGUL SYLLABLE TIKEUT YA RIEULHIEUH
  {0x88CF, 0xB32C}, //1377 #HANGUL SYLLABLE TIKEUT YA MIEUM
  {0x88D0, 0xB32D}, //1378 #HANGUL SYLLABLE TIKEUT YA PIEUP
  {0x88D1, 0xB32E}, //1379 #HANGUL SYLLABLE TIKEUT YA PIEUPSIOS
  {0x88D2, 0xB32F}, //1380 #HANGUL SYLLABLE TIKEUT YA SIOS
  {0x88D3, 0xB330}, //1381 #HANGUL SYLLABLE TIKEUT YA SSANGSIOS
  {0x88D4, 0xB331}, //1382 #HANGUL SYLLABLE TIKEUT YA IEUNG
  {0x88D5, 0xB332}, //1383 #HANGUL SYLLABLE TIKEUT YA CIEUC
  {0x88D6, 0xB333}, //1384 #HANGUL SYLLABLE TIKEUT YA CHIEUCH
  {0x88D7, 0xB334}, //1385 #HANGUL SYLLABLE TIKEUT YA KHIEUKH
  {0x88D8, 0xB335}, //1386 #HANGUL SYLLABLE TIKEUT YA THIEUTH
  {0x88D9, 0xB336}, //1387 #HANGUL SYLLABLE TIKEUT YA PHIEUPH
  {0x88DA, 0xB337}, //1388 #HANGUL SYLLABLE TIKEUT YA HIEUH
  {0x88DB, 0xB338}, //1389 #HANGUL SYLLABLE TIKEUT YAE
  {0x88DC, 0xB339}, //1390 #HANGUL SYLLABLE TIKEUT YAE KIYEOK
  {0x88DD, 0xB33A}, //1391 #HANGUL SYLLABLE TIKEUT YAE SSANGKIYEOK
  {0x88DE, 0xB33B}, //1392 #HANGUL SYLLABLE TIKEUT YAE KIYEOKSIOS
  {0x88DF, 0xB33C}, //1393 #HANGUL SYLLABLE TIKEUT YAE NIEUN
  {0x88E0, 0xB33D}, //1394 #HANGUL SYLLABLE TIKEUT YAE NIEUNCIEUC
  {0x88E1, 0xB33E}, //1395 #HANGUL SYLLABLE TIKEUT YAE NIEUNHIEUH
  {0x88E2, 0xB33F}, //1396 #HANGUL SYLLABLE TIKEUT YAE TIKEUT
  {0x88E3, 0xB340}, //1397 #HANGUL SYLLABLE TIKEUT YAE RIEUL
  {0x88E4, 0xB341}, //1398 #HANGUL SYLLABLE TIKEUT YAE RIEULKIYEOK
  {0x88E5, 0xB342}, //1399 #HANGUL SYLLABLE TIKEUT YAE RIEULMIEUM
  {0x88E6, 0xB343}, //1400 #HANGUL SYLLABLE TIKEUT YAE RIEULPIEUP
  {0x88E7, 0xB344}, //1401 #HANGUL SYLLABLE TIKEUT YAE RIEULSIOS
  {0x88E8, 0xB345}, //1402 #HANGUL SYLLABLE TIKEUT YAE RIEULTHIEUTH
  {0x88E9, 0xB346}, //1403 #HANGUL SYLLABLE TIKEUT YAE RIEULPHIEUPH
  {0x88EA, 0xB347}, //1404 #HANGUL SYLLABLE TIKEUT YAE RIEULHIEUH
  {0x88EB, 0xB348}, //1405 #HANGUL SYLLABLE TIKEUT YAE MIEUM
  {0x88EC, 0xB349}, //1406 #HANGUL SYLLABLE TIKEUT YAE PIEUP
  {0x88ED, 0xB34A}, //1407 #HANGUL SYLLABLE TIKEUT YAE PIEUPSIOS
  {0x88EE, 0xB34B}, //1408 #HANGUL SYLLABLE TIKEUT YAE SIOS
  {0x88EF, 0xB34C}, //1409 #HANGUL SYLLABLE TIKEUT YAE SSANGSIOS
  {0x88F0, 0xB34D}, //1410 #HANGUL SYLLABLE TIKEUT YAE IEUNG
  {0x88F1, 0xB34E}, //1411 #HANGUL SYLLABLE TIKEUT YAE CIEUC
  {0x88F2, 0xB34F}, //1412 #HANGUL SYLLABLE TIKEUT YAE CHIEUCH
  {0x88F3, 0xB350}, //1413 #HANGUL SYLLABLE TIKEUT YAE KHIEUKH
  {0x88F4, 0xB351}, //1414 #HANGUL SYLLABLE TIKEUT YAE THIEUTH
  {0x88F5, 0xB352}, //1415 #HANGUL SYLLABLE TIKEUT YAE PHIEUPH
  {0x88F6, 0xB353}, //1416 #HANGUL SYLLABLE TIKEUT YAE HIEUH
  {0x88F7, 0xB357}, //1417 #HANGUL SYLLABLE TIKEUT EO KIYEOKSIOS
  {0x88F8, 0xB359}, //1418 #HANGUL SYLLABLE TIKEUT EO NIEUNCIEUC
  {0x88F9, 0xB35A}, //1419 #HANGUL SYLLABLE TIKEUT EO NIEUNHIEUH
  {0x88FA, 0xB35D}, //1420 #HANGUL SYLLABLE TIKEUT EO RIEULKIYEOK
  {0x88FB, 0xB360}, //1421 #HANGUL SYLLABLE TIKEUT EO RIEULSIOS
  {0x88FC, 0xB361}, //1422 #HANGUL SYLLABLE TIKEUT EO RIEULTHIEUTH
  {0x88FD, 0xB362}, //1423 #HANGUL SYLLABLE TIKEUT EO RIEULPHIEUPH
  {0x88FE, 0xB363}, //1424 #HANGUL SYLLABLE TIKEUT EO RIEULHIEUH
  {0x8941, 0xB366}, //1425 #HANGUL SYLLABLE TIKEUT EO PIEUPSIOS
  {0x8942, 0xB368}, //1426 #HANGUL SYLLABLE TIKEUT EO SSANGSIOS
  {0x8943, 0xB36A}, //1427 #HANGUL SYLLABLE TIKEUT EO CIEUC
  {0x8944, 0xB36C}, //1428 #HANGUL SYLLABLE TIKEUT EO KHIEUKH
  {0x8945, 0xB36D}, //1429 #HANGUL SYLLABLE TIKEUT EO THIEUTH
  {0x8946, 0xB36F}, //1430 #HANGUL SYLLABLE TIKEUT EO HIEUH
  {0x8947, 0xB372}, //1431 #HANGUL SYLLABLE TIKEUT E SSANGKIYEOK
  {0x8948, 0xB373}, //1432 #HANGUL SYLLABLE TIKEUT E KIYEOKSIOS
  {0x8949, 0xB375}, //1433 #HANGUL SYLLABLE TIKEUT E NIEUNCIEUC
  {0x894A, 0xB376}, //1434 #HANGUL SYLLABLE TIKEUT E NIEUNHIEUH
  {0x894B, 0xB377}, //1435 #HANGUL SYLLABLE TIKEUT E TIKEUT
  {0x894C, 0xB379}, //1436 #HANGUL SYLLABLE TIKEUT E RIEULKIYEOK
  {0x894D, 0xB37A}, //1437 #HANGUL SYLLABLE TIKEUT E RIEULMIEUM
  {0x894E, 0xB37B}, //1438 #HANGUL SYLLABLE TIKEUT E RIEULPIEUP
  {0x894F, 0xB37C}, //1439 #HANGUL SYLLABLE TIKEUT E RIEULSIOS
  {0x8950, 0xB37D}, //1440 #HANGUL SYLLABLE TIKEUT E RIEULTHIEUTH
  {0x8951, 0xB37E}, //1441 #HANGUL SYLLABLE TIKEUT E RIEULPHIEUPH
  {0x8952, 0xB37F}, //1442 #HANGUL SYLLABLE TIKEUT E RIEULHIEUH
  {0x8953, 0xB382}, //1443 #HANGUL SYLLABLE TIKEUT E PIEUPSIOS
  {0x8954, 0xB386}, //1444 #HANGUL SYLLABLE TIKEUT E CIEUC
  {0x8955, 0xB387}, //1445 #HANGUL SYLLABLE TIKEUT E CHIEUCH
  {0x8956, 0xB388}, //1446 #HANGUL SYLLABLE TIKEUT E KHIEUKH
  {0x8957, 0xB389}, //1447 #HANGUL SYLLABLE TIKEUT E THIEUTH
  {0x8958, 0xB38A}, //1448 #HANGUL SYLLABLE TIKEUT E PHIEUPH
  {0x8959, 0xB38B}, //1449 #HANGUL SYLLABLE TIKEUT E HIEUH
  {0x895A, 0xB38D}, //1450 #HANGUL SYLLABLE TIKEUT YEO KIYEOK
  {0x8961, 0xB38E}, //1451 #HANGUL SYLLABLE TIKEUT YEO SSANGKIYEOK
  {0x8962, 0xB38F}, //1452 #HANGUL SYLLABLE TIKEUT YEO KIYEOKSIOS
  {0x8963, 0xB391}, //1453 #HANGUL SYLLABLE TIKEUT YEO NIEUNCIEUC
  {0x8964, 0xB392}, //1454 #HANGUL SYLLABLE TIKEUT YEO NIEUNHIEUH
  {0x8965, 0xB393}, //1455 #HANGUL SYLLABLE TIKEUT YEO TIKEUT
  {0x8966, 0xB395}, //1456 #HANGUL SYLLABLE TIKEUT YEO RIEULKIYEOK
  {0x8967, 0xB396}, //1457 #HANGUL SYLLABLE TIKEUT YEO RIEULMIEUM
  {0x8968, 0xB397}, //1458 #HANGUL SYLLABLE TIKEUT YEO RIEULPIEUP
  {0x8969, 0xB398}, //1459 #HANGUL SYLLABLE TIKEUT YEO RIEULSIOS
  {0x896A, 0xB399}, //1460 #HANGUL SYLLABLE TIKEUT YEO RIEULTHIEUTH
  {0x896B, 0xB39A}, //1461 #HANGUL SYLLABLE TIKEUT YEO RIEULPHIEUPH
  {0x896C, 0xB39B}, //1462 #HANGUL SYLLABLE TIKEUT YEO RIEULHIEUH
  {0x896D, 0xB39C}, //1463 #HANGUL SYLLABLE TIKEUT YEO MIEUM
  {0x896E, 0xB39D}, //1464 #HANGUL SYLLABLE TIKEUT YEO PIEUP
  {0x896F, 0xB39E}, //1465 #HANGUL SYLLABLE TIKEUT YEO PIEUPSIOS
  {0x8970, 0xB39F}, //1466 #HANGUL SYLLABLE TIKEUT YEO SIOS
  {0x8971, 0xB3A2}, //1467 #HANGUL SYLLABLE TIKEUT YEO CIEUC
  {0x8972, 0xB3A3}, //1468 #HANGUL SYLLABLE TIKEUT YEO CHIEUCH
  {0x8973, 0xB3A4}, //1469 #HANGUL SYLLABLE TIKEUT YEO KHIEUKH
  {0x8974, 0xB3A5}, //1470 #HANGUL SYLLABLE TIKEUT YEO THIEUTH
  {0x8975, 0xB3A6}, //1471 #HANGUL SYLLABLE TIKEUT YEO PHIEUPH
  {0x8976, 0xB3A7}, //1472 #HANGUL SYLLABLE TIKEUT YEO HIEUH
  {0x8977, 0xB3A9}, //1473 #HANGUL SYLLABLE TIKEUT YE KIYEOK
  {0x8978, 0xB3AA}, //1474 #HANGUL SYLLABLE TIKEUT YE SSANGKIYEOK
  {0x8979, 0xB3AB}, //1475 #HANGUL SYLLABLE TIKEUT YE KIYEOKSIOS
  {0x897A, 0xB3AD}, //1476 #HANGUL SYLLABLE TIKEUT YE NIEUNCIEUC
  {0x8981, 0xB3AE}, //1477 #HANGUL SYLLABLE TIKEUT YE NIEUNHIEUH
  {0x8982, 0xB3AF}, //1478 #HANGUL SYLLABLE TIKEUT YE TIKEUT
  {0x8983, 0xB3B0}, //1479 #HANGUL SYLLABLE TIKEUT YE RIEUL
  {0x8984, 0xB3B1}, //1480 #HANGUL SYLLABLE TIKEUT YE RIEULKIYEOK
  {0x8985, 0xB3B2}, //1481 #HANGUL SYLLABLE TIKEUT YE RIEULMIEUM
  {0x8986, 0xB3B3}, //1482 #HANGUL SYLLABLE TIKEUT YE RIEULPIEUP
  {0x8987, 0xB3B4}, //1483 #HANGUL SYLLABLE TIKEUT YE RIEULSIOS
  {0x8988, 0xB3B5}, //1484 #HANGUL SYLLABLE TIKEUT YE RIEULTHIEUTH
  {0x8989, 0xB3B6}, //1485 #HANGUL SYLLABLE TIKEUT YE RIEULPHIEUPH
  {0x898A, 0xB3B7}, //1486 #HANGUL SYLLABLE TIKEUT YE RIEULHIEUH
  {0x898B, 0xB3B8}, //1487 #HANGUL SYLLABLE TIKEUT YE MIEUM
  {0x898C, 0xB3B9}, //1488 #HANGUL SYLLABLE TIKEUT YE PIEUP
  {0x898D, 0xB3BA}, //1489 #HANGUL SYLLABLE TIKEUT YE PIEUPSIOS
  {0x898E, 0xB3BB}, //1490 #HANGUL SYLLABLE TIKEUT YE SIOS
  {0x898F, 0xB3BC}, //1491 #HANGUL SYLLABLE TIKEUT YE SSANGSIOS
  {0x8990, 0xB3BD}, //1492 #HANGUL SYLLABLE TIKEUT YE IEUNG
  {0x8991, 0xB3BE}, //1493 #HANGUL SYLLABLE TIKEUT YE CIEUC
  {0x8992, 0xB3BF}, //1494 #HANGUL SYLLABLE TIKEUT YE CHIEUCH
  {0x8993, 0xB3C0}, //1495 #HANGUL SYLLABLE TIKEUT YE KHIEUKH
  {0x8994, 0xB3C1}, //1496 #HANGUL SYLLABLE TIKEUT YE THIEUTH
  {0x8995, 0xB3C2}, //1497 #HANGUL SYLLABLE TIKEUT YE PHIEUPH
  {0x8996, 0xB3C3}, //1498 #HANGUL SYLLABLE TIKEUT YE HIEUH
  {0x8997, 0xB3C6}, //1499 #HANGUL SYLLABLE TIKEUT O SSANGKIYEOK
  {0x8998, 0xB3C7}, //1500 #HANGUL SYLLABLE TIKEUT O KIYEOKSIOS
  {0x8999, 0xB3C9}, //1501 #HANGUL SYLLABLE TIKEUT O NIEUNCIEUC
  {0x899A, 0xB3CA}, //1502 #HANGUL SYLLABLE TIKEUT O NIEUNHIEUH
  {0x899B, 0xB3CD}, //1503 #HANGUL SYLLABLE TIKEUT O RIEULKIYEOK
  {0x899C, 0xB3CF}, //1504 #HANGUL SYLLABLE TIKEUT O RIEULPIEUP
  {0x899D, 0xB3D1}, //1505 #HANGUL SYLLABLE TIKEUT O RIEULTHIEUTH
  {0x899E, 0xB3D2}, //1506 #HANGUL SYLLABLE TIKEUT O RIEULPHIEUPH
  {0x899F, 0xB3D3}, //1507 #HANGUL SYLLABLE TIKEUT O RIEULHIEUH
  {0x89A0, 0xB3D6}, //1508 #HANGUL SYLLABLE TIKEUT O PIEUPSIOS
  {0x89A1, 0xB3D8}, //1509 #HANGUL SYLLABLE TIKEUT O SSANGSIOS
  {0x89A2, 0xB3DA}, //1510 #HANGUL SYLLABLE TIKEUT O CIEUC
  {0x89A3, 0xB3DC}, //1511 #HANGUL SYLLABLE TIKEUT O KHIEUKH
  {0x89A4, 0xB3DE}, //1512 #HANGUL SYLLABLE TIKEUT O PHIEUPH
  {0x89A5, 0xB3DF}, //1513 #HANGUL SYLLABLE TIKEUT O HIEUH
  {0x89A6, 0xB3E1}, //1514 #HANGUL SYLLABLE TIKEUT WA KIYEOK
  {0x89A7, 0xB3E2}, //1515 #HANGUL SYLLABLE TIKEUT WA SSANGKIYEOK
  {0x89A8, 0xB3E3}, //1516 #HANGUL SYLLABLE TIKEUT WA KIYEOKSIOS
  {0x89A9, 0xB3E5}, //1517 #HANGUL SYLLABLE TIKEUT WA NIEUNCIEUC
  {0x89AA, 0xB3E6}, //1518 #HANGUL SYLLABLE TIKEUT WA NIEUNHIEUH
  {0x89AB, 0xB3E7}, //1519 #HANGUL SYLLABLE TIKEUT WA TIKEUT
  {0x89AC, 0xB3E9}, //1520 #HANGUL SYLLABLE TIKEUT WA RIEULKIYEOK
  {0x89AD, 0xB3EA}, //1521 #HANGUL SYLLABLE TIKEUT WA RIEULMIEUM
  {0x89AE, 0xB3EB}, //1522 #HANGUL SYLLABLE TIKEUT WA RIEULPIEUP
  {0x89AF, 0xB3EC}, //1523 #HANGUL SYLLABLE TIKEUT WA RIEULSIOS
  {0x89B0, 0xB3ED}, //1524 #HANGUL SYLLABLE TIKEUT WA RIEULTHIEUTH
  {0x89B1, 0xB3EE}, //1525 #HANGUL SYLLABLE TIKEUT WA RIEULPHIEUPH
  {0x89B2, 0xB3EF}, //1526 #HANGUL SYLLABLE TIKEUT WA RIEULHIEUH
  {0x89B3, 0xB3F0}, //1527 #HANGUL SYLLABLE TIKEUT WA MIEUM
  {0x89B4, 0xB3F1}, //1528 #HANGUL SYLLABLE TIKEUT WA PIEUP
  {0x89B5, 0xB3F2}, //1529 #HANGUL SYLLABLE TIKEUT WA PIEUPSIOS
  {0x89B6, 0xB3F3}, //1530 #HANGUL SYLLABLE TIKEUT WA SIOS
  {0x89B7, 0xB3F4}, //1531 #HANGUL SYLLABLE TIKEUT WA SSANGSIOS
  {0x89B8, 0xB3F5}, //1532 #HANGUL SYLLABLE TIKEUT WA IEUNG
  {0x89B9, 0xB3F6}, //1533 #HANGUL SYLLABLE TIKEUT WA CIEUC
  {0x89BA, 0xB3F7}, //1534 #HANGUL SYLLABLE TIKEUT WA CHIEUCH
  {0x89BB, 0xB3F8}, //1535 #HANGUL SYLLABLE TIKEUT WA KHIEUKH
  {0x89BC, 0xB3F9}, //1536 #HANGUL SYLLABLE TIKEUT WA THIEUTH
  {0x89BD, 0xB3FA}, //1537 #HANGUL SYLLABLE TIKEUT WA PHIEUPH
  {0x89BE, 0xB3FB}, //1538 #HANGUL SYLLABLE TIKEUT WA HIEUH
  {0x89BF, 0xB3FD}, //1539 #HANGUL SYLLABLE TIKEUT WAE KIYEOK
  {0x89C0, 0xB3FE}, //1540 #HANGUL SYLLABLE TIKEUT WAE SSANGKIYEOK
  {0x89C1, 0xB3FF}, //1541 #HANGUL SYLLABLE TIKEUT WAE KIYEOKSIOS
  {0x89C2, 0xB400}, //1542 #HANGUL SYLLABLE TIKEUT WAE NIEUN
  {0x89C3, 0xB401}, //1543 #HANGUL SYLLABLE TIKEUT WAE NIEUNCIEUC
  {0x89C4, 0xB402}, //1544 #HANGUL SYLLABLE TIKEUT WAE NIEUNHIEUH
  {0x89C5, 0xB403}, //1545 #HANGUL SYLLABLE TIKEUT WAE TIKEUT
  {0x89C6, 0xB404}, //1546 #HANGUL SYLLABLE TIKEUT WAE RIEUL
  {0x89C7, 0xB405}, //1547 #HANGUL SYLLABLE TIKEUT WAE RIEULKIYEOK
  {0x89C8, 0xB406}, //1548 #HANGUL SYLLABLE TIKEUT WAE RIEULMIEUM
  {0x89C9, 0xB407}, //1549 #HANGUL SYLLABLE TIKEUT WAE RIEULPIEUP
  {0x89CA, 0xB408}, //1550 #HANGUL SYLLABLE TIKEUT WAE RIEULSIOS
  {0x89CB, 0xB409}, //1551 #HANGUL SYLLABLE TIKEUT WAE RIEULTHIEUTH
  {0x89CC, 0xB40A}, //1552 #HANGUL SYLLABLE TIKEUT WAE RIEULPHIEUPH
  {0x89CD, 0xB40B}, //1553 #HANGUL SYLLABLE TIKEUT WAE RIEULHIEUH
  {0x89CE, 0xB40C}, //1554 #HANGUL SYLLABLE TIKEUT WAE MIEUM
  {0x89CF, 0xB40D}, //1555 #HANGUL SYLLABLE TIKEUT WAE PIEUP
  {0x89D0, 0xB40E}, //1556 #HANGUL SYLLABLE TIKEUT WAE PIEUPSIOS
  {0x89D1, 0xB40F}, //1557 #HANGUL SYLLABLE TIKEUT WAE SIOS
  {0x89D2, 0xB411}, //1558 #HANGUL SYLLABLE TIKEUT WAE IEUNG
  {0x89D3, 0xB412}, //1559 #HANGUL SYLLABLE TIKEUT WAE CIEUC
  {0x89D4, 0xB413}, //1560 #HANGUL SYLLABLE TIKEUT WAE CHIEUCH
  {0x89D5, 0xB414}, //1561 #HANGUL SYLLABLE TIKEUT WAE KHIEUKH
  {0x89D6, 0xB415}, //1562 #HANGUL SYLLABLE TIKEUT WAE THIEUTH
  {0x89D7, 0xB416}, //1563 #HANGUL SYLLABLE TIKEUT WAE PHIEUPH
  {0x89D8, 0xB417}, //1564 #HANGUL SYLLABLE TIKEUT WAE HIEUH
  {0x89D9, 0xB419}, //1565 #HANGUL SYLLABLE TIKEUT OE KIYEOK
  {0x89DA, 0xB41A}, //1566 #HANGUL SYLLABLE TIKEUT OE SSANGKIYEOK
  {0x89DB, 0xB41B}, //1567 #HANGUL SYLLABLE TIKEUT OE KIYEOKSIOS
  {0x89DC, 0xB41D}, //1568 #HANGUL SYLLABLE TIKEUT OE NIEUNCIEUC
  {0x89DD, 0xB41E}, //1569 #HANGUL SYLLABLE TIKEUT OE NIEUNHIEUH
  {0x89DE, 0xB41F}, //1570 #HANGUL SYLLABLE TIKEUT OE TIKEUT
  {0x89DF, 0xB421}, //1571 #HANGUL SYLLABLE TIKEUT OE RIEULKIYEOK
  {0x89E0, 0xB422}, //1572 #HANGUL SYLLABLE TIKEUT OE RIEULMIEUM
  {0x89E1, 0xB423}, //1573 #HANGUL SYLLABLE TIKEUT OE RIEULPIEUP
  {0x89E2, 0xB424}, //1574 #HANGUL SYLLABLE TIKEUT OE RIEULSIOS
  {0x89E3, 0xB425}, //1575 #HANGUL SYLLABLE TIKEUT OE RIEULTHIEUTH
  {0x89E4, 0xB426}, //1576 #HANGUL SYLLABLE TIKEUT OE RIEULPHIEUPH
  {0x89E5, 0xB427}, //1577 #HANGUL SYLLABLE TIKEUT OE RIEULHIEUH
  {0x89E6, 0xB42A}, //1578 #HANGUL SYLLABLE TIKEUT OE PIEUPSIOS
  {0x89E7, 0xB42C}, //1579 #HANGUL SYLLABLE TIKEUT OE SSANGSIOS
  {0x89E8, 0xB42D}, //1580 #HANGUL SYLLABLE TIKEUT OE IEUNG
  {0x89E9, 0xB42E}, //1581 #HANGUL SYLLABLE TIKEUT OE CIEUC
  {0x89EA, 0xB42F}, //1582 #HANGUL SYLLABLE TIKEUT OE CHIEUCH
  {0x89EB, 0xB430}, //1583 #HANGUL SYLLABLE TIKEUT OE KHIEUKH
  {0x89EC, 0xB431}, //1584 #HANGUL SYLLABLE TIKEUT OE THIEUTH
  {0x89ED, 0xB432}, //1585 #HANGUL SYLLABLE TIKEUT OE PHIEUPH
  {0x89EE, 0xB433}, //1586 #HANGUL SYLLABLE TIKEUT OE HIEUH
  {0x89EF, 0xB435}, //1587 #HANGUL SYLLABLE TIKEUT YO KIYEOK
  {0x89F0, 0xB436}, //1588 #HANGUL SYLLABLE TIKEUT YO SSANGKIYEOK
  {0x89F1, 0xB437}, //1589 #HANGUL SYLLABLE TIKEUT YO KIYEOKSIOS
  {0x89F2, 0xB438}, //1590 #HANGUL SYLLABLE TIKEUT YO NIEUN
  {0x89F3, 0xB439}, //1591 #HANGUL SYLLABLE TIKEUT YO NIEUNCIEUC
  {0x89F4, 0xB43A}, //1592 #HANGUL SYLLABLE TIKEUT YO NIEUNHIEUH
  {0x89F5, 0xB43B}, //1593 #HANGUL SYLLABLE TIKEUT YO TIKEUT
  {0x89F6, 0xB43C}, //1594 #HANGUL SYLLABLE TIKEUT YO RIEUL
  {0x89F7, 0xB43D}, //1595 #HANGUL SYLLABLE TIKEUT YO RIEULKIYEOK
  {0x89F8, 0xB43E}, //1596 #HANGUL SYLLABLE TIKEUT YO RIEULMIEUM
  {0x89F9, 0xB43F}, //1597 #HANGUL SYLLABLE TIKEUT YO RIEULPIEUP
  {0x89FA, 0xB440}, //1598 #HANGUL SYLLABLE TIKEUT YO RIEULSIOS
  {0x89FB, 0xB441}, //1599 #HANGUL SYLLABLE TIKEUT YO RIEULTHIEUTH
  {0x89FC, 0xB442}, //1600 #HANGUL SYLLABLE TIKEUT YO RIEULPHIEUPH
  {0x89FD, 0xB443}, //1601 #HANGUL SYLLABLE TIKEUT YO RIEULHIEUH
  {0x89FE, 0xB444}, //1602 #HANGUL SYLLABLE TIKEUT YO MIEUM
  {0x8A41, 0xB445}, //1603 #HANGUL SYLLABLE TIKEUT YO PIEUP
  {0x8A42, 0xB446}, //1604 #HANGUL SYLLABLE TIKEUT YO PIEUPSIOS
  {0x8A43, 0xB447}, //1605 #HANGUL SYLLABLE TIKEUT YO SIOS
  {0x8A44, 0xB448}, //1606 #HANGUL SYLLABLE TIKEUT YO SSANGSIOS
  {0x8A45, 0xB449}, //1607 #HANGUL SYLLABLE TIKEUT YO IEUNG
  {0x8A46, 0xB44A}, //1608 #HANGUL SYLLABLE TIKEUT YO CIEUC
  {0x8A47, 0xB44B}, //1609 #HANGUL SYLLABLE TIKEUT YO CHIEUCH
  {0x8A48, 0xB44C}, //1610 #HANGUL SYLLABLE TIKEUT YO KHIEUKH
  {0x8A49, 0xB44D}, //1611 #HANGUL SYLLABLE TIKEUT YO THIEUTH
  {0x8A4A, 0xB44E}, //1612 #HANGUL SYLLABLE TIKEUT YO PHIEUPH
  {0x8A4B, 0xB44F}, //1613 #HANGUL SYLLABLE TIKEUT YO HIEUH
  {0x8A4C, 0xB452}, //1614 #HANGUL SYLLABLE TIKEUT U SSANGKIYEOK
  {0x8A4D, 0xB453}, //1615 #HANGUL SYLLABLE TIKEUT U KIYEOKSIOS
  {0x8A4E, 0xB455}, //1616 #HANGUL SYLLABLE TIKEUT U NIEUNCIEUC
  {0x8A4F, 0xB456}, //1617 #HANGUL SYLLABLE TIKEUT U NIEUNHIEUH
  {0x8A50, 0xB457}, //1618 #HANGUL SYLLABLE TIKEUT U TIKEUT
  {0x8A51, 0xB459}, //1619 #HANGUL SYLLABLE TIKEUT U RIEULKIYEOK
  {0x8A52, 0xB45A}, //1620 #HANGUL SYLLABLE TIKEUT U RIEULMIEUM
  {0x8A53, 0xB45B}, //1621 #HANGUL SYLLABLE TIKEUT U RIEULPIEUP
  {0x8A54, 0xB45C}, //1622 #HANGUL SYLLABLE TIKEUT U RIEULSIOS
  {0x8A55, 0xB45D}, //1623 #HANGUL SYLLABLE TIKEUT U RIEULTHIEUTH
  {0x8A56, 0xB45E}, //1624 #HANGUL SYLLABLE TIKEUT U RIEULPHIEUPH
  {0x8A57, 0xB45F}, //1625 #HANGUL SYLLABLE TIKEUT U RIEULHIEUH
  {0x8A58, 0xB462}, //1626 #HANGUL SYLLABLE TIKEUT U PIEUPSIOS
  {0x8A59, 0xB464}, //1627 #HANGUL SYLLABLE TIKEUT U SSANGSIOS
  {0x8A5A, 0xB466}, //1628 #HANGUL SYLLABLE TIKEUT U CIEUC
  {0x8A61, 0xB467}, //1629 #HANGUL SYLLABLE TIKEUT U CHIEUCH
  {0x8A62, 0xB468}, //1630 #HANGUL SYLLABLE TIKEUT U KHIEUKH
  {0x8A63, 0xB469}, //1631 #HANGUL SYLLABLE TIKEUT U THIEUTH
  {0x8A64, 0xB46A}, //1632 #HANGUL SYLLABLE TIKEUT U PHIEUPH
  {0x8A65, 0xB46B}, //1633 #HANGUL SYLLABLE TIKEUT U HIEUH
  {0x8A66, 0xB46D}, //1634 #HANGUL SYLLABLE TIKEUT WEO KIYEOK
  {0x8A67, 0xB46E}, //1635 #HANGUL SYLLABLE TIKEUT WEO SSANGKIYEOK
  {0x8A68, 0xB46F}, //1636 #HANGUL SYLLABLE TIKEUT WEO KIYEOKSIOS
  {0x8A69, 0xB470}, //1637 #HANGUL SYLLABLE TIKEUT WEO NIEUN
  {0x8A6A, 0xB471}, //1638 #HANGUL SYLLABLE TIKEUT WEO NIEUNCIEUC
  {0x8A6B, 0xB472}, //1639 #HANGUL SYLLABLE TIKEUT WEO NIEUNHIEUH
  {0x8A6C, 0xB473}, //1640 #HANGUL SYLLABLE TIKEUT WEO TIKEUT
  {0x8A6D, 0xB474}, //1641 #HANGUL SYLLABLE TIKEUT WEO RIEUL
  {0x8A6E, 0xB475}, //1642 #HANGUL SYLLABLE TIKEUT WEO RIEULKIYEOK
  {0x8A6F, 0xB476}, //1643 #HANGUL SYLLABLE TIKEUT WEO RIEULMIEUM
  {0x8A70, 0xB477}, //1644 #HANGUL SYLLABLE TIKEUT WEO RIEULPIEUP
  {0x8A71, 0xB478}, //1645 #HANGUL SYLLABLE TIKEUT WEO RIEULSIOS
  {0x8A72, 0xB479}, //1646 #HANGUL SYLLABLE TIKEUT WEO RIEULTHIEUTH
  {0x8A73, 0xB47A}, //1647 #HANGUL SYLLABLE TIKEUT WEO RIEULPHIEUPH
  {0x8A74, 0xB47B}, //1648 #HANGUL SYLLABLE TIKEUT WEO RIEULHIEUH
  {0x8A75, 0xB47C}, //1649 #HANGUL SYLLABLE TIKEUT WEO MIEUM
  {0x8A76, 0xB47D}, //1650 #HANGUL SYLLABLE TIKEUT WEO PIEUP
  {0x8A77, 0xB47E}, //1651 #HANGUL SYLLABLE TIKEUT WEO PIEUPSIOS
  {0x8A78, 0xB47F}, //1652 #HANGUL SYLLABLE TIKEUT WEO SIOS
  {0x8A79, 0xB481}, //1653 #HANGUL SYLLABLE TIKEUT WEO IEUNG
  {0x8A7A, 0xB482}, //1654 #HANGUL SYLLABLE TIKEUT WEO CIEUC
  {0x8A81, 0xB483}, //1655 #HANGUL SYLLABLE TIKEUT WEO CHIEUCH
  {0x8A82, 0xB484}, //1656 #HANGUL SYLLABLE TIKEUT WEO KHIEUKH
  {0x8A83, 0xB485}, //1657 #HANGUL SYLLABLE TIKEUT WEO THIEUTH
  {0x8A84, 0xB486}, //1658 #HANGUL SYLLABLE TIKEUT WEO PHIEUPH
  {0x8A85, 0xB487}, //1659 #HANGUL SYLLABLE TIKEUT WEO HIEUH
  {0x8A86, 0xB489}, //1660 #HANGUL SYLLABLE TIKEUT WE KIYEOK
  {0x8A87, 0xB48A}, //1661 #HANGUL SYLLABLE TIKEUT WE SSANGKIYEOK
  {0x8A88, 0xB48B}, //1662 #HANGUL SYLLABLE TIKEUT WE KIYEOKSIOS
  {0x8A89, 0xB48C}, //1663 #HANGUL SYLLABLE TIKEUT WE NIEUN
  {0x8A8A, 0xB48D}, //1664 #HANGUL SYLLABLE TIKEUT WE NIEUNCIEUC
  {0x8A8B, 0xB48E}, //1665 #HANGUL SYLLABLE TIKEUT WE NIEUNHIEUH
  {0x8A8C, 0xB48F}, //1666 #HANGUL SYLLABLE TIKEUT WE TIKEUT
  {0x8A8D, 0xB490}, //1667 #HANGUL SYLLABLE TIKEUT WE RIEUL
  {0x8A8E, 0xB491}, //1668 #HANGUL SYLLABLE TIKEUT WE RIEULKIYEOK
  {0x8A8F, 0xB492}, //1669 #HANGUL SYLLABLE TIKEUT WE RIEULMIEUM
  {0x8A90, 0xB493}, //1670 #HANGUL SYLLABLE TIKEUT WE RIEULPIEUP
  {0x8A91, 0xB494}, //1671 #HANGUL SYLLABLE TIKEUT WE RIEULSIOS
  {0x8A92, 0xB495}, //1672 #HANGUL SYLLABLE TIKEUT WE RIEULTHIEUTH
  {0x8A93, 0xB496}, //1673 #HANGUL SYLLABLE TIKEUT WE RIEULPHIEUPH
  {0x8A94, 0xB497}, //1674 #HANGUL SYLLABLE TIKEUT WE RIEULHIEUH
  {0x8A95, 0xB498}, //1675 #HANGUL SYLLABLE TIKEUT WE MIEUM
  {0x8A96, 0xB499}, //1676 #HANGUL SYLLABLE TIKEUT WE PIEUP
  {0x8A97, 0xB49A}, //1677 #HANGUL SYLLABLE TIKEUT WE PIEUPSIOS
  {0x8A98, 0xB49B}, //1678 #HANGUL SYLLABLE TIKEUT WE SIOS
  {0x8A99, 0xB49C}, //1679 #HANGUL SYLLABLE TIKEUT WE SSANGSIOS
  {0x8A9A, 0xB49E}, //1680 #HANGUL SYLLABLE TIKEUT WE CIEUC
  {0x8A9B, 0xB49F}, //1681 #HANGUL SYLLABLE TIKEUT WE CHIEUCH
  {0x8A9C, 0xB4A0}, //1682 #HANGUL SYLLABLE TIKEUT WE KHIEUKH
  {0x8A9D, 0xB4A1}, //1683 #HANGUL SYLLABLE TIKEUT WE THIEUTH
  {0x8A9E, 0xB4A2}, //1684 #HANGUL SYLLABLE TIKEUT WE PHIEUPH
  {0x8A9F, 0xB4A3}, //1685 #HANGUL SYLLABLE TIKEUT WE HIEUH
  {0x8AA0, 0xB4A5}, //1686 #HANGUL SYLLABLE TIKEUT WI KIYEOK
  {0x8AA1, 0xB4A6}, //1687 #HANGUL SYLLABLE TIKEUT WI SSANGKIYEOK
  {0x8AA2, 0xB4A7}, //1688 #HANGUL SYLLABLE TIKEUT WI KIYEOKSIOS
  {0x8AA3, 0xB4A9}, //1689 #HANGUL SYLLABLE TIKEUT WI NIEUNCIEUC
  {0x8AA4, 0xB4AA}, //1690 #HANGUL SYLLABLE TIKEUT WI NIEUNHIEUH
  {0x8AA5, 0xB4AB}, //1691 #HANGUL SYLLABLE TIKEUT WI TIKEUT
  {0x8AA6, 0xB4AD}, //1692 #HANGUL SYLLABLE TIKEUT WI RIEULKIYEOK
  {0x8AA7, 0xB4AE}, //1693 #HANGUL SYLLABLE TIKEUT WI RIEULMIEUM
  {0x8AA8, 0xB4AF}, //1694 #HANGUL SYLLABLE TIKEUT WI RIEULPIEUP
  {0x8AA9, 0xB4B0}, //1695 #HANGUL SYLLABLE TIKEUT WI RIEULSIOS
  {0x8AAA, 0xB4B1}, //1696 #HANGUL SYLLABLE TIKEUT WI RIEULTHIEUTH
  {0x8AAB, 0xB4B2}, //1697 #HANGUL SYLLABLE TIKEUT WI RIEULPHIEUPH
  {0x8AAC, 0xB4B3}, //1698 #HANGUL SYLLABLE TIKEUT WI RIEULHIEUH
  {0x8AAD, 0xB4B4}, //1699 #HANGUL SYLLABLE TIKEUT WI MIEUM
  {0x8AAE, 0xB4B6}, //1700 #HANGUL SYLLABLE TIKEUT WI PIEUPSIOS
  {0x8AAF, 0xB4B8}, //1701 #HANGUL SYLLABLE TIKEUT WI SSANGSIOS
  {0x8AB0, 0xB4BA}, //1702 #HANGUL SYLLABLE TIKEUT WI CIEUC
  {0x8AB1, 0xB4BB}, //1703 #HANGUL SYLLABLE TIKEUT WI CHIEUCH
  {0x8AB2, 0xB4BC}, //1704 #HANGUL SYLLABLE TIKEUT WI KHIEUKH
  {0x8AB3, 0xB4BD}, //1705 #HANGUL SYLLABLE TIKEUT WI THIEUTH
  {0x8AB4, 0xB4BE}, //1706 #HANGUL SYLLABLE TIKEUT WI PHIEUPH
  {0x8AB5, 0xB4BF}, //1707 #HANGUL SYLLABLE TIKEUT WI HIEUH
  {0x8AB6, 0xB4C1}, //1708 #HANGUL SYLLABLE TIKEUT YU KIYEOK
  {0x8AB7, 0xB4C2}, //1709 #HANGUL SYLLABLE TIKEUT YU SSANGKIYEOK
  {0x8AB8, 0xB4C3}, //1710 #HANGUL SYLLABLE TIKEUT YU KIYEOKSIOS
  {0x8AB9, 0xB4C5}, //1711 #HANGUL SYLLABLE TIKEUT YU NIEUNCIEUC
  {0x8ABA, 0xB4C6}, //1712 #HANGUL SYLLABLE TIKEUT YU NIEUNHIEUH
  {0x8ABB, 0xB4C7}, //1713 #HANGUL SYLLABLE TIKEUT YU TIKEUT
  {0x8ABC, 0xB4C9}, //1714 #HANGUL SYLLABLE TIKEUT YU RIEULKIYEOK
  {0x8ABD, 0xB4CA}, //1715 #HANGUL SYLLABLE TIKEUT YU RIEULMIEUM
  {0x8ABE, 0xB4CB}, //1716 #HANGUL SYLLABLE TIKEUT YU RIEULPIEUP
  {0x8ABF, 0xB4CC}, //1717 #HANGUL SYLLABLE TIKEUT YU RIEULSIOS
  {0x8AC0, 0xB4CD}, //1718 #HANGUL SYLLABLE TIKEUT YU RIEULTHIEUTH
  {0x8AC1, 0xB4CE}, //1719 #HANGUL SYLLABLE TIKEUT YU RIEULPHIEUPH
  {0x8AC2, 0xB4CF}, //1720 #HANGUL SYLLABLE TIKEUT YU RIEULHIEUH
  {0x8AC3, 0xB4D1}, //1721 #HANGUL SYLLABLE TIKEUT YU PIEUP
  {0x8AC4, 0xB4D2}, //1722 #HANGUL SYLLABLE TIKEUT YU PIEUPSIOS
  {0x8AC5, 0xB4D3}, //1723 #HANGUL SYLLABLE TIKEUT YU SIOS
  {0x8AC6, 0xB4D4}, //1724 #HANGUL SYLLABLE TIKEUT YU SSANGSIOS
  {0x8AC7, 0xB4D6}, //1725 #HANGUL SYLLABLE TIKEUT YU CIEUC
  {0x8AC8, 0xB4D7}, //1726 #HANGUL SYLLABLE TIKEUT YU CHIEUCH
  {0x8AC9, 0xB4D8}, //1727 #HANGUL SYLLABLE TIKEUT YU KHIEUKH
  {0x8ACA, 0xB4D9}, //1728 #HANGUL SYLLABLE TIKEUT YU THIEUTH
  {0x8ACB, 0xB4DA}, //1729 #HANGUL SYLLABLE TIKEUT YU PHIEUPH
  {0x8ACC, 0xB4DB}, //1730 #HANGUL SYLLABLE TIKEUT YU HIEUH
  {0x8ACD, 0xB4DE}, //1731 #HANGUL SYLLABLE TIKEUT EU SSANGKIYEOK
  {0x8ACE, 0xB4DF}, //1732 #HANGUL SYLLABLE TIKEUT EU KIYEOKSIOS
  {0x8ACF, 0xB4E1}, //1733 #HANGUL SYLLABLE TIKEUT EU NIEUNCIEUC
  {0x8AD0, 0xB4E2}, //1734 #HANGUL SYLLABLE TIKEUT EU NIEUNHIEUH
  {0x8AD1, 0xB4E5}, //1735 #HANGUL SYLLABLE TIKEUT EU RIEULKIYEOK
  {0x8AD2, 0xB4E7}, //1736 #HANGUL SYLLABLE TIKEUT EU RIEULPIEUP
  {0x8AD3, 0xB4E8}, //1737 #HANGUL SYLLABLE TIKEUT EU RIEULSIOS
  {0x8AD4, 0xB4E9}, //1738 #HANGUL SYLLABLE TIKEUT EU RIEULTHIEUTH
  {0x8AD5, 0xB4EA}, //1739 #HANGUL SYLLABLE TIKEUT EU RIEULPHIEUPH
  {0x8AD6, 0xB4EB}, //1740 #HANGUL SYLLABLE TIKEUT EU RIEULHIEUH
  {0x8AD7, 0xB4EE}, //1741 #HANGUL SYLLABLE TIKEUT EU PIEUPSIOS
  {0x8AD8, 0xB4F0}, //1742 #HANGUL SYLLABLE TIKEUT EU SSANGSIOS
  {0x8AD9, 0xB4F2}, //1743 #HANGUL SYLLABLE TIKEUT EU CIEUC
  {0x8ADA, 0xB4F3}, //1744 #HANGUL SYLLABLE TIKEUT EU CHIEUCH
  {0x8ADB, 0xB4F4}, //1745 #HANGUL SYLLABLE TIKEUT EU KHIEUKH
  {0x8ADC, 0xB4F5}, //1746 #HANGUL SYLLABLE TIKEUT EU THIEUTH
  {0x8ADD, 0xB4F6}, //1747 #HANGUL SYLLABLE TIKEUT EU PHIEUPH
  {0x8ADE, 0xB4F7}, //1748 #HANGUL SYLLABLE TIKEUT EU HIEUH
  {0x8ADF, 0xB4F9}, //1749 #HANGUL SYLLABLE TIKEUT YI KIYEOK
  {0x8AE0, 0xB4FA}, //1750 #HANGUL SYLLABLE TIKEUT YI SSANGKIYEOK
  {0x8AE1, 0xB4FB}, //1751 #HANGUL SYLLABLE TIKEUT YI KIYEOKSIOS
  {0x8AE2, 0xB4FC}, //1752 #HANGUL SYLLABLE TIKEUT YI NIEUN
  {0x8AE3, 0xB4FD}, //1753 #HANGUL SYLLABLE TIKEUT YI NIEUNCIEUC
  {0x8AE4, 0xB4FE}, //1754 #HANGUL SYLLABLE TIKEUT YI NIEUNHIEUH
  {0x8AE5, 0xB4FF}, //1755 #HANGUL SYLLABLE TIKEUT YI TIKEUT
  {0x8AE6, 0xB500}, //1756 #HANGUL SYLLABLE TIKEUT YI RIEUL
  {0x8AE7, 0xB501}, //1757 #HANGUL SYLLABLE TIKEUT YI RIEULKIYEOK
  {0x8AE8, 0xB502}, //1758 #HANGUL SYLLABLE TIKEUT YI RIEULMIEUM
  {0x8AE9, 0xB503}, //1759 #HANGUL SYLLABLE TIKEUT YI RIEULPIEUP
  {0x8AEA, 0xB504}, //1760 #HANGUL SYLLABLE TIKEUT YI RIEULSIOS
  {0x8AEB, 0xB505}, //1761 #HANGUL SYLLABLE TIKEUT YI RIEULTHIEUTH
  {0x8AEC, 0xB506}, //1762 #HANGUL SYLLABLE TIKEUT YI RIEULPHIEUPH
  {0x8AED, 0xB507}, //1763 #HANGUL SYLLABLE TIKEUT YI RIEULHIEUH
  {0x8AEE, 0xB508}, //1764 #HANGUL SYLLABLE TIKEUT YI MIEUM
  {0x8AEF, 0xB509}, //1765 #HANGUL SYLLABLE TIKEUT YI PIEUP
  {0x8AF0, 0xB50A}, //1766 #HANGUL SYLLABLE TIKEUT YI PIEUPSIOS
  {0x8AF1, 0xB50B}, //1767 #HANGUL SYLLABLE TIKEUT YI SIOS
  {0x8AF2, 0xB50C}, //1768 #HANGUL SYLLABLE TIKEUT YI SSANGSIOS
  {0x8AF3, 0xB50D}, //1769 #HANGUL SYLLABLE TIKEUT YI IEUNG
  {0x8AF4, 0xB50E}, //1770 #HANGUL SYLLABLE TIKEUT YI CIEUC
  {0x8AF5, 0xB50F}, //1771 #HANGUL SYLLABLE TIKEUT YI CHIEUCH
  {0x8AF6, 0xB510}, //1772 #HANGUL SYLLABLE TIKEUT YI KHIEUKH
  {0x8AF7, 0xB511}, //1773 #HANGUL SYLLABLE TIKEUT YI THIEUTH
  {0x8AF8, 0xB512}, //1774 #HANGUL SYLLABLE TIKEUT YI PHIEUPH
  {0x8AF9, 0xB513}, //1775 #HANGUL SYLLABLE TIKEUT YI HIEUH
  {0x8AFA, 0xB516}, //1776 #HANGUL SYLLABLE TIKEUT I SSANGKIYEOK
  {0x8AFB, 0xB517}, //1777 #HANGUL SYLLABLE TIKEUT I KIYEOKSIOS
  {0x8AFC, 0xB519}, //1778 #HANGUL SYLLABLE TIKEUT I NIEUNCIEUC
  {0x8AFD, 0xB51A}, //1779 #HANGUL SYLLABLE TIKEUT I NIEUNHIEUH
  {0x8AFE, 0xB51D}, //1780 #HANGUL SYLLABLE TIKEUT I RIEULKIYEOK
  {0x8B41, 0xB51E}, //1781 #HANGUL SYLLABLE TIKEUT I RIEULMIEUM
  {0x8B42, 0xB51F}, //1782 #HANGUL SYLLABLE TIKEUT I RIEULPIEUP
  {0x8B43, 0xB520}, //1783 #HANGUL SYLLABLE TIKEUT I RIEULSIOS
  {0x8B44, 0xB521}, //1784 #HANGUL SYLLABLE TIKEUT I RIEULTHIEUTH
  {0x8B45, 0xB522}, //1785 #HANGUL SYLLABLE TIKEUT I RIEULPHIEUPH
  {0x8B46, 0xB523}, //1786 #HANGUL SYLLABLE TIKEUT I RIEULHIEUH
  {0x8B47, 0xB526}, //1787 #HANGUL SYLLABLE TIKEUT I PIEUPSIOS
  {0x8B48, 0xB52B}, //1788 #HANGUL SYLLABLE TIKEUT I CHIEUCH
  {0x8B49, 0xB52C}, //1789 #HANGUL SYLLABLE TIKEUT I KHIEUKH
  {0x8B4A, 0xB52D}, //1790 #HANGUL SYLLABLE TIKEUT I THIEUTH
  {0x8B4B, 0xB52E}, //1791 #HANGUL SYLLABLE TIKEUT I PHIEUPH
  {0x8B4C, 0xB52F}, //1792 #HANGUL SYLLABLE TIKEUT I HIEUH
  {0x8B4D, 0xB532}, //1793 #HANGUL SYLLABLE SSANGTIKEUT A SSANGKIYEOK
  {0x8B4E, 0xB533}, //1794 #HANGUL SYLLABLE SSANGTIKEUT A KIYEOKSIOS
  {0x8B4F, 0xB535}, //1795 #HANGUL SYLLABLE SSANGTIKEUT A NIEUNCIEUC
  {0x8B50, 0xB536}, //1796 #HANGUL SYLLABLE SSANGTIKEUT A NIEUNHIEUH
  {0x8B51, 0xB537}, //1797 #HANGUL SYLLABLE SSANGTIKEUT A TIKEUT
  {0x8B52, 0xB539}, //1798 #HANGUL SYLLABLE SSANGTIKEUT A RIEULKIYEOK
  {0x8B53, 0xB53A}, //1799 #HANGUL SYLLABLE SSANGTIKEUT A RIEULMIEUM
  {0x8B54, 0xB53B}, //1800 #HANGUL SYLLABLE SSANGTIKEUT A RIEULPIEUP
  {0x8B55, 0xB53C}, //1801 #HANGUL SYLLABLE SSANGTIKEUT A RIEULSIOS
  {0x8B56, 0xB53D}, //1802 #HANGUL SYLLABLE SSANGTIKEUT A RIEULTHIEUTH
  {0x8B57, 0xB53E}, //1803 #HANGUL SYLLABLE SSANGTIKEUT A RIEULPHIEUPH
  {0x8B58, 0xB53F}, //1804 #HANGUL SYLLABLE SSANGTIKEUT A RIEULHIEUH
  {0x8B59, 0xB542}, //1805 #HANGUL SYLLABLE SSANGTIKEUT A PIEUPSIOS
  {0x8B5A, 0xB546}, //1806 #HANGUL SYLLABLE SSANGTIKEUT A CIEUC
  {0x8B61, 0xB547}, //1807 #HANGUL SYLLABLE SSANGTIKEUT A CHIEUCH
  {0x8B62, 0xB548}, //1808 #HANGUL SYLLABLE SSANGTIKEUT A KHIEUKH
  {0x8B63, 0xB549}, //1809 #HANGUL SYLLABLE SSANGTIKEUT A THIEUTH
  {0x8B64, 0xB54A}, //1810 #HANGUL SYLLABLE SSANGTIKEUT A PHIEUPH
  {0x8B65, 0xB54E}, //1811 #HANGUL SYLLABLE SSANGTIKEUT AE SSANGKIYEOK
  {0x8B66, 0xB54F}, //1812 #HANGUL SYLLABLE SSANGTIKEUT AE KIYEOKSIOS
  {0x8B67, 0xB551}, //1813 #HANGUL SYLLABLE SSANGTIKEUT AE NIEUNCIEUC
  {0x8B68, 0xB552}, //1814 #HANGUL SYLLABLE SSANGTIKEUT AE NIEUNHIEUH
  {0x8B69, 0xB553}, //1815 #HANGUL SYLLABLE SSANGTIKEUT AE TIKEUT
  {0x8B6A, 0xB555}, //1816 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULKIYEOK
  {0x8B6B, 0xB556}, //1817 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULMIEUM
  {0x8B6C, 0xB557}, //1818 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULPIEUP
  {0x8B6D, 0xB558}, //1819 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULSIOS
  {0x8B6E, 0xB559}, //1820 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULTHIEUTH
  {0x8B6F, 0xB55A}, //1821 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULPHIEUPH
  {0x8B70, 0xB55B}, //1822 #HANGUL SYLLABLE SSANGTIKEUT AE RIEULHIEUH
  {0x8B71, 0xB55E}, //1823 #HANGUL SYLLABLE SSANGTIKEUT AE PIEUPSIOS
  {0x8B72, 0xB562}, //1824 #HANGUL SYLLABLE SSANGTIKEUT AE CIEUC
  {0x8B73, 0xB563}, //1825 #HANGUL SYLLABLE SSANGTIKEUT AE CHIEUCH
  {0x8B74, 0xB564}, //1826 #HANGUL SYLLABLE SSANGTIKEUT AE KHIEUKH
  {0x8B75, 0xB565}, //1827 #HANGUL SYLLABLE SSANGTIKEUT AE THIEUTH
  {0x8B76, 0xB566}, //1828 #HANGUL SYLLABLE SSANGTIKEUT AE PHIEUPH
  {0x8B77, 0xB567}, //1829 #HANGUL SYLLABLE SSANGTIKEUT AE HIEUH
  {0x8B78, 0xB568}, //1830 #HANGUL SYLLABLE SSANGTIKEUT YA
  {0x8B79, 0xB569}, //1831 #HANGUL SYLLABLE SSANGTIKEUT YA KIYEOK
  {0x8B7A, 0xB56A}, //1832 #HANGUL SYLLABLE SSANGTIKEUT YA SSANGKIYEOK
  {0x8B81, 0xB56B}, //1833 #HANGUL SYLLABLE SSANGTIKEUT YA KIYEOKSIOS
  {0x8B82, 0xB56C}, //1834 #HANGUL SYLLABLE SSANGTIKEUT YA NIEUN
  {0x8B83, 0xB56D}, //1835 #HANGUL SYLLABLE SSANGTIKEUT YA NIEUNCIEUC
  {0x8B84, 0xB56E}, //1836 #HANGUL SYLLABLE SSANGTIKEUT YA NIEUNHIEUH
  {0x8B85, 0xB56F}, //1837 #HANGUL SYLLABLE SSANGTIKEUT YA TIKEUT
  {0x8B86, 0xB570}, //1838 #HANGUL SYLLABLE SSANGTIKEUT YA RIEUL
  {0x8B87, 0xB571}, //1839 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULKIYEOK
  {0x8B88, 0xB572}, //1840 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULMIEUM
  {0x8B89, 0xB573}, //1841 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULPIEUP
  {0x8B8A, 0xB574}, //1842 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULSIOS
  {0x8B8B, 0xB575}, //1843 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULTHIEUTH
  {0x8B8C, 0xB576}, //1844 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULPHIEUPH
  {0x8B8D, 0xB577}, //1845 #HANGUL SYLLABLE SSANGTIKEUT YA RIEULHIEUH
  {0x8B8E, 0xB578}, //1846 #HANGUL SYLLABLE SSANGTIKEUT YA MIEUM
  {0x8B8F, 0xB579}, //1847 #HANGUL SYLLABLE SSANGTIKEUT YA PIEUP
  {0x8B90, 0xB57A}, //1848 #HANGUL SYLLABLE SSANGTIKEUT YA PIEUPSIOS
  {0x8B91, 0xB57B}, //1849 #HANGUL SYLLABLE SSANGTIKEUT YA SIOS
  {0x8B92, 0xB57C}, //1850 #HANGUL SYLLABLE SSANGTIKEUT YA SSANGSIOS
  {0x8B93, 0xB57D}, //1851 #HANGUL SYLLABLE SSANGTIKEUT YA IEUNG
  {0x8B94, 0xB57E}, //1852 #HANGUL SYLLABLE SSANGTIKEUT YA CIEUC
  {0x8B95, 0xB57F}, //1853 #HANGUL SYLLABLE SSANGTIKEUT YA CHIEUCH
  {0x8B96, 0xB580}, //1854 #HANGUL SYLLABLE SSANGTIKEUT YA KHIEUKH
  {0x8B97, 0xB581}, //1855 #HANGUL SYLLABLE SSANGTIKEUT YA THIEUTH
  {0x8B98, 0xB582}, //1856 #HANGUL SYLLABLE SSANGTIKEUT YA PHIEUPH
  {0x8B99, 0xB583}, //1857 #HANGUL SYLLABLE SSANGTIKEUT YA HIEUH
  {0x8B9A, 0xB584}, //1858 #HANGUL SYLLABLE SSANGTIKEUT YAE
  {0x8B9B, 0xB585}, //1859 #HANGUL SYLLABLE SSANGTIKEUT YAE KIYEOK
  {0x8B9C, 0xB586}, //1860 #HANGUL SYLLABLE SSANGTIKEUT YAE SSANGKIYEOK
  {0x8B9D, 0xB587}, //1861 #HANGUL SYLLABLE SSANGTIKEUT YAE KIYEOKSIOS
  {0x8B9E, 0xB588}, //1862 #HANGUL SYLLABLE SSANGTIKEUT YAE NIEUN
  {0x8B9F, 0xB589}, //1863 #HANGUL SYLLABLE SSANGTIKEUT YAE NIEUNCIEUC
  {0x8BA0, 0xB58A}, //1864 #HANGUL SYLLABLE SSANGTIKEUT YAE NIEUNHIEUH
  {0x8BA1, 0xB58B}, //1865 #HANGUL SYLLABLE SSANGTIKEUT YAE TIKEUT
  {0x8BA2, 0xB58C}, //1866 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEUL
  {0x8BA3, 0xB58D}, //1867 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULKIYEOK
  {0x8BA4, 0xB58E}, //1868 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULMIEUM
  {0x8BA5, 0xB58F}, //1869 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULPIEUP
  {0x8BA6, 0xB590}, //1870 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULSIOS
  {0x8BA7, 0xB591}, //1871 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULTHIEUTH
  {0x8BA8, 0xB592}, //1872 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULPHIEUPH
  {0x8BA9, 0xB593}, //1873 #HANGUL SYLLABLE SSANGTIKEUT YAE RIEULHIEUH
  {0x8BAA, 0xB594}, //1874 #HANGUL SYLLABLE SSANGTIKEUT YAE MIEUM
  {0x8BAB, 0xB595}, //1875 #HANGUL SYLLABLE SSANGTIKEUT YAE PIEUP
  {0x8BAC, 0xB596}, //1876 #HANGUL SYLLABLE SSANGTIKEUT YAE PIEUPSIOS
  {0x8BAD, 0xB597}, //1877 #HANGUL SYLLABLE SSANGTIKEUT YAE SIOS
  {0x8BAE, 0xB598}, //1878 #HANGUL SYLLABLE SSANGTIKEUT YAE SSANGSIOS
  {0x8BAF, 0xB599}, //1879 #HANGUL SYLLABLE SSANGTIKEUT YAE IEUNG
  {0x8BB0, 0xB59A}, //1880 #HANGUL SYLLABLE SSANGTIKEUT YAE CIEUC
  {0x8BB1, 0xB59B}, //1881 #HANGUL SYLLABLE SSANGTIKEUT YAE CHIEUCH
  {0x8BB2, 0xB59C}, //1882 #HANGUL SYLLABLE SSANGTIKEUT YAE KHIEUKH
  {0x8BB3, 0xB59D}, //1883 #HANGUL SYLLABLE SSANGTIKEUT YAE THIEUTH
  {0x8BB4, 0xB59E}, //1884 #HANGUL SYLLABLE SSANGTIKEUT YAE PHIEUPH
  {0x8BB5, 0xB59F}, //1885 #HANGUL SYLLABLE SSANGTIKEUT YAE HIEUH
  {0x8BB6, 0xB5A2}, //1886 #HANGUL SYLLABLE SSANGTIKEUT EO SSANGKIYEOK
  {0x8BB7, 0xB5A3}, //1887 #HANGUL SYLLABLE SSANGTIKEUT EO KIYEOKSIOS
  {0x8BB8, 0xB5A5}, //1888 #HANGUL SYLLABLE SSANGTIKEUT EO NIEUNCIEUC
  {0x8BB9, 0xB5A6}, //1889 #HANGUL SYLLABLE SSANGTIKEUT EO NIEUNHIEUH
  {0x8BBA, 0xB5A7}, //1890 #HANGUL SYLLABLE SSANGTIKEUT EO TIKEUT
  {0x8BBB, 0xB5A9}, //1891 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULKIYEOK
  {0x8BBC, 0xB5AC}, //1892 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULSIOS
  {0x8BBD, 0xB5AD}, //1893 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULTHIEUTH
  {0x8BBE, 0xB5AE}, //1894 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULPHIEUPH
  {0x8BBF, 0xB5AF}, //1895 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULHIEUH
  {0x8BC0, 0xB5B2}, //1896 #HANGUL SYLLABLE SSANGTIKEUT EO PIEUPSIOS
  {0x8BC1, 0xB5B6}, //1897 #HANGUL SYLLABLE SSANGTIKEUT EO CIEUC
  {0x8BC2, 0xB5B7}, //1898 #HANGUL SYLLABLE SSANGTIKEUT EO CHIEUCH
  {0x8BC3, 0xB5B8}, //1899 #HANGUL SYLLABLE SSANGTIKEUT EO KHIEUKH
  {0x8BC4, 0xB5B9}, //1900 #HANGUL SYLLABLE SSANGTIKEUT EO THIEUTH
  {0x8BC5, 0xB5BA}, //1901 #HANGUL SYLLABLE SSANGTIKEUT EO PHIEUPH
  {0x8BC6, 0xB5BE}, //1902 #HANGUL SYLLABLE SSANGTIKEUT E SSANGKIYEOK
  {0x8BC7, 0xB5BF}, //1903 #HANGUL SYLLABLE SSANGTIKEUT E KIYEOKSIOS
  {0x8BC8, 0xB5C1}, //1904 #HANGUL SYLLABLE SSANGTIKEUT E NIEUNCIEUC
  {0x8BC9, 0xB5C2}, //1905 #HANGUL SYLLABLE SSANGTIKEUT E NIEUNHIEUH
  {0x8BCA, 0xB5C3}, //1906 #HANGUL SYLLABLE SSANGTIKEUT E TIKEUT
  {0x8BCB, 0xB5C5}, //1907 #HANGUL SYLLABLE SSANGTIKEUT E RIEULKIYEOK
  {0x8BCC, 0xB5C6}, //1908 #HANGUL SYLLABLE SSANGTIKEUT E RIEULMIEUM
  {0x8BCD, 0xB5C7}, //1909 #HANGUL SYLLABLE SSANGTIKEUT E RIEULPIEUP
  {0x8BCE, 0xB5C8}, //1910 #HANGUL SYLLABLE SSANGTIKEUT E RIEULSIOS
  {0x8BCF, 0xB5C9}, //1911 #HANGUL SYLLABLE SSANGTIKEUT E RIEULTHIEUTH
  {0x8BD0, 0xB5CA}, //1912 #HANGUL SYLLABLE SSANGTIKEUT E RIEULPHIEUPH
  {0x8BD1, 0xB5CB}, //1913 #HANGUL SYLLABLE SSANGTIKEUT E RIEULHIEUH
  {0x8BD2, 0xB5CE}, //1914 #HANGUL SYLLABLE SSANGTIKEUT E PIEUPSIOS
  {0x8BD3, 0xB5D2}, //1915 #HANGUL SYLLABLE SSANGTIKEUT E CIEUC
  {0x8BD4, 0xB5D3}, //1916 #HANGUL SYLLABLE SSANGTIKEUT E CHIEUCH
  {0x8BD5, 0xB5D4}, //1917 #HANGUL SYLLABLE SSANGTIKEUT E KHIEUKH
  {0x8BD6, 0xB5D5}, //1918 #HANGUL SYLLABLE SSANGTIKEUT E THIEUTH
  {0x8BD7, 0xB5D6}, //1919 #HANGUL SYLLABLE SSANGTIKEUT E PHIEUPH
  {0x8BD8, 0xB5D7}, //1920 #HANGUL SYLLABLE SSANGTIKEUT E HIEUH
  {0x8BD9, 0xB5D9}, //1921 #HANGUL SYLLABLE SSANGTIKEUT YEO KIYEOK
  {0x8BDA, 0xB5DA}, //1922 #HANGUL SYLLABLE SSANGTIKEUT YEO SSANGKIYEOK
  {0x8BDB, 0xB5DB}, //1923 #HANGUL SYLLABLE SSANGTIKEUT YEO KIYEOKSIOS
  {0x8BDC, 0xB5DC}, //1924 #HANGUL SYLLABLE SSANGTIKEUT YEO NIEUN
  {0x8BDD, 0xB5DD}, //1925 #HANGUL SYLLABLE SSANGTIKEUT YEO NIEUNCIEUC
  {0x8BDE, 0xB5DE}, //1926 #HANGUL SYLLABLE SSANGTIKEUT YEO NIEUNHIEUH
  {0x8BDF, 0xB5DF}, //1927 #HANGUL SYLLABLE SSANGTIKEUT YEO TIKEUT
  {0x8BE0, 0xB5E0}, //1928 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEUL
  {0x8BE1, 0xB5E1}, //1929 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULKIYEOK
  {0x8BE2, 0xB5E2}, //1930 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULMIEUM
  {0x8BE3, 0xB5E3}, //1931 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULPIEUP
  {0x8BE4, 0xB5E4}, //1932 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULSIOS
  {0x8BE5, 0xB5E5}, //1933 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULTHIEUTH
  {0x8BE6, 0xB5E6}, //1934 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULPHIEUPH
  {0x8BE7, 0xB5E7}, //1935 #HANGUL SYLLABLE SSANGTIKEUT YEO RIEULHIEUH
  {0x8BE8, 0xB5E8}, //1936 #HANGUL SYLLABLE SSANGTIKEUT YEO MIEUM
  {0x8BE9, 0xB5E9}, //1937 #HANGUL SYLLABLE SSANGTIKEUT YEO PIEUP
  {0x8BEA, 0xB5EA}, //1938 #HANGUL SYLLABLE SSANGTIKEUT YEO PIEUPSIOS
  {0x8BEB, 0xB5EB}, //1939 #HANGUL SYLLABLE SSANGTIKEUT YEO SIOS
  {0x8BEC, 0xB5ED}, //1940 #HANGUL SYLLABLE SSANGTIKEUT YEO IEUNG
  {0x8BED, 0xB5EE}, //1941 #HANGUL SYLLABLE SSANGTIKEUT YEO CIEUC
  {0x8BEE, 0xB5EF}, //1942 #HANGUL SYLLABLE SSANGTIKEUT YEO CHIEUCH
  {0x8BEF, 0xB5F0}, //1943 #HANGUL SYLLABLE SSANGTIKEUT YEO KHIEUKH
  {0x8BF0, 0xB5F1}, //1944 #HANGUL SYLLABLE SSANGTIKEUT YEO THIEUTH
  {0x8BF1, 0xB5F2}, //1945 #HANGUL SYLLABLE SSANGTIKEUT YEO PHIEUPH
  {0x8BF2, 0xB5F3}, //1946 #HANGUL SYLLABLE SSANGTIKEUT YEO HIEUH
  {0x8BF3, 0xB5F4}, //1947 #HANGUL SYLLABLE SSANGTIKEUT YE
  {0x8BF4, 0xB5F5}, //1948 #HANGUL SYLLABLE SSANGTIKEUT YE KIYEOK
  {0x8BF5, 0xB5F6}, //1949 #HANGUL SYLLABLE SSANGTIKEUT YE SSANGKIYEOK
  {0x8BF6, 0xB5F7}, //1950 #HANGUL SYLLABLE SSANGTIKEUT YE KIYEOKSIOS
  {0x8BF7, 0xB5F8}, //1951 #HANGUL SYLLABLE SSANGTIKEUT YE NIEUN
  {0x8BF8, 0xB5F9}, //1952 #HANGUL SYLLABLE SSANGTIKEUT YE NIEUNCIEUC
  {0x8BF9, 0xB5FA}, //1953 #HANGUL SYLLABLE SSANGTIKEUT YE NIEUNHIEUH
  {0x8BFA, 0xB5FB}, //1954 #HANGUL SYLLABLE SSANGTIKEUT YE TIKEUT
  {0x8BFB, 0xB5FC}, //1955 #HANGUL SYLLABLE SSANGTIKEUT YE RIEUL
  {0x8BFC, 0xB5FD}, //1956 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULKIYEOK
  {0x8BFD, 0xB5FE}, //1957 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULMIEUM
  {0x8BFE, 0xB5FF}, //1958 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULPIEUP
  {0x8C41, 0xB600}, //1959 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULSIOS
  {0x8C42, 0xB601}, //1960 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULTHIEUTH
  {0x8C43, 0xB602}, //1961 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULPHIEUPH
  {0x8C44, 0xB603}, //1962 #HANGUL SYLLABLE SSANGTIKEUT YE RIEULHIEUH
  {0x8C45, 0xB604}, //1963 #HANGUL SYLLABLE SSANGTIKEUT YE MIEUM
  {0x8C46, 0xB605}, //1964 #HANGUL SYLLABLE SSANGTIKEUT YE PIEUP
  {0x8C47, 0xB606}, //1965 #HANGUL SYLLABLE SSANGTIKEUT YE PIEUPSIOS
  {0x8C48, 0xB607}, //1966 #HANGUL SYLLABLE SSANGTIKEUT YE SIOS
  {0x8C49, 0xB608}, //1967 #HANGUL SYLLABLE SSANGTIKEUT YE SSANGSIOS
  {0x8C4A, 0xB609}, //1968 #HANGUL SYLLABLE SSANGTIKEUT YE IEUNG
  {0x8C4B, 0xB60A}, //1969 #HANGUL SYLLABLE SSANGTIKEUT YE CIEUC
  {0x8C4C, 0xB60B}, //1970 #HANGUL SYLLABLE SSANGTIKEUT YE CHIEUCH
  {0x8C4D, 0xB60C}, //1971 #HANGUL SYLLABLE SSANGTIKEUT YE KHIEUKH
  {0x8C4E, 0xB60D}, //1972 #HANGUL SYLLABLE SSANGTIKEUT YE THIEUTH
  {0x8C4F, 0xB60E}, //1973 #HANGUL SYLLABLE SSANGTIKEUT YE PHIEUPH
  {0x8C50, 0xB60F}, //1974 #HANGUL SYLLABLE SSANGTIKEUT YE HIEUH
  {0x8C51, 0xB612}, //1975 #HANGUL SYLLABLE SSANGTIKEUT O SSANGKIYEOK
  {0x8C52, 0xB613}, //1976 #HANGUL SYLLABLE SSANGTIKEUT O KIYEOKSIOS
  {0x8C53, 0xB615}, //1977 #HANGUL SYLLABLE SSANGTIKEUT O NIEUNCIEUC
  {0x8C54, 0xB616}, //1978 #HANGUL SYLLABLE SSANGTIKEUT O NIEUNHIEUH
  {0x8C55, 0xB617}, //1979 #HANGUL SYLLABLE SSANGTIKEUT O TIKEUT
  {0x8C56, 0xB619}, //1980 #HANGUL SYLLABLE SSANGTIKEUT O RIEULKIYEOK
  {0x8C57, 0xB61A}, //1981 #HANGUL SYLLABLE SSANGTIKEUT O RIEULMIEUM
  {0x8C58, 0xB61B}, //1982 #HANGUL SYLLABLE SSANGTIKEUT O RIEULPIEUP
  {0x8C59, 0xB61C}, //1983 #HANGUL SYLLABLE SSANGTIKEUT O RIEULSIOS
  {0x8C5A, 0xB61D}, //1984 #HANGUL SYLLABLE SSANGTIKEUT O RIEULTHIEUTH
  {0x8C61, 0xB61E}, //1985 #HANGUL SYLLABLE SSANGTIKEUT O RIEULPHIEUPH
  {0x8C62, 0xB61F}, //1986 #HANGUL SYLLABLE SSANGTIKEUT O RIEULHIEUH
  {0x8C63, 0xB620}, //1987 #HANGUL SYLLABLE SSANGTIKEUT O MIEUM
  {0x8C64, 0xB621}, //1988 #HANGUL SYLLABLE SSANGTIKEUT O PIEUP
  {0x8C65, 0xB622}, //1989 #HANGUL SYLLABLE SSANGTIKEUT O PIEUPSIOS
  {0x8C66, 0xB623}, //1990 #HANGUL SYLLABLE SSANGTIKEUT O SIOS
  {0x8C67, 0xB624}, //1991 #HANGUL SYLLABLE SSANGTIKEUT O SSANGSIOS
  {0x8C68, 0xB626}, //1992 #HANGUL SYLLABLE SSANGTIKEUT O CIEUC
  {0x8C69, 0xB627}, //1993 #HANGUL SYLLABLE SSANGTIKEUT O CHIEUCH
  {0x8C6A, 0xB628}, //1994 #HANGUL SYLLABLE SSANGTIKEUT O KHIEUKH
  {0x8C6B, 0xB629}, //1995 #HANGUL SYLLABLE SSANGTIKEUT O THIEUTH
  {0x8C6C, 0xB62A}, //1996 #HANGUL SYLLABLE SSANGTIKEUT O PHIEUPH
  {0x8C6D, 0xB62B}, //1997 #HANGUL SYLLABLE SSANGTIKEUT O HIEUH
  {0x8C6E, 0xB62D}, //1998 #HANGUL SYLLABLE SSANGTIKEUT WA KIYEOK
  {0x8C6F, 0xB62E}, //1999 #HANGUL SYLLABLE SSANGTIKEUT WA SSANGKIYEOK
  {0x8C70, 0xB62F}, //2000 #HANGUL SYLLABLE SSANGTIKEUT WA KIYEOKSIOS
  {0x8C71, 0xB630}, //2001 #HANGUL SYLLABLE SSANGTIKEUT WA NIEUN
  {0x8C72, 0xB631}, //2002 #HANGUL SYLLABLE SSANGTIKEUT WA NIEUNCIEUC
  {0x8C73, 0xB632}, //2003 #HANGUL SYLLABLE SSANGTIKEUT WA NIEUNHIEUH
  {0x8C74, 0xB633}, //2004 #HANGUL SYLLABLE SSANGTIKEUT WA TIKEUT
  {0x8C75, 0xB635}, //2005 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULKIYEOK
  {0x8C76, 0xB636}, //2006 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULMIEUM
  {0x8C77, 0xB637}, //2007 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULPIEUP
  {0x8C78, 0xB638}, //2008 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULSIOS
  {0x8C79, 0xB639}, //2009 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULTHIEUTH
  {0x8C7A, 0xB63A}, //2010 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULPHIEUPH
  {0x8C81, 0xB63B}, //2011 #HANGUL SYLLABLE SSANGTIKEUT WA RIEULHIEUH
  {0x8C82, 0xB63C}, //2012 #HANGUL SYLLABLE SSANGTIKEUT WA MIEUM
  {0x8C83, 0xB63D}, //2013 #HANGUL SYLLABLE SSANGTIKEUT WA PIEUP
  {0x8C84, 0xB63E}, //2014 #HANGUL SYLLABLE SSANGTIKEUT WA PIEUPSIOS
  {0x8C85, 0xB63F}, //2015 #HANGUL SYLLABLE SSANGTIKEUT WA SIOS
  {0x8C86, 0xB640}, //2016 #HANGUL SYLLABLE SSANGTIKEUT WA SSANGSIOS
  {0x8C87, 0xB641}, //2017 #HANGUL SYLLABLE SSANGTIKEUT WA IEUNG
  {0x8C88, 0xB642}, //2018 #HANGUL SYLLABLE SSANGTIKEUT WA CIEUC
  {0x8C89, 0xB643}, //2019 #HANGUL SYLLABLE SSANGTIKEUT WA CHIEUCH
  {0x8C8A, 0xB644}, //2020 #HANGUL SYLLABLE SSANGTIKEUT WA KHIEUKH
  {0x8C8B, 0xB645}, //2021 #HANGUL SYLLABLE SSANGTIKEUT WA THIEUTH
  {0x8C8C, 0xB646}, //2022 #HANGUL SYLLABLE SSANGTIKEUT WA PHIEUPH
  {0x8C8D, 0xB647}, //2023 #HANGUL SYLLABLE SSANGTIKEUT WA HIEUH
  {0x8C8E, 0xB649}, //2024 #HANGUL SYLLABLE SSANGTIKEUT WAE KIYEOK
  {0x8C8F, 0xB64A}, //2025 #HANGUL SYLLABLE SSANGTIKEUT WAE SSANGKIYEOK
  {0x8C90, 0xB64B}, //2026 #HANGUL SYLLABLE SSANGTIKEUT WAE KIYEOKSIOS
  {0x8C91, 0xB64C}, //2027 #HANGUL SYLLABLE SSANGTIKEUT WAE NIEUN
  {0x8C92, 0xB64D}, //2028 #HANGUL SYLLABLE SSANGTIKEUT WAE NIEUNCIEUC
  {0x8C93, 0xB64E}, //2029 #HANGUL SYLLABLE SSANGTIKEUT WAE NIEUNHIEUH
  {0x8C94, 0xB64F}, //2030 #HANGUL SYLLABLE SSANGTIKEUT WAE TIKEUT
  {0x8C95, 0xB650}, //2031 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEUL
  {0x8C96, 0xB651}, //2032 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULKIYEOK
  {0x8C97, 0xB652}, //2033 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULMIEUM
  {0x8C98, 0xB653}, //2034 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULPIEUP
  {0x8C99, 0xB654}, //2035 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULSIOS
  {0x8C9A, 0xB655}, //2036 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULTHIEUTH
  {0x8C9B, 0xB656}, //2037 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULPHIEUPH
  {0x8C9C, 0xB657}, //2038 #HANGUL SYLLABLE SSANGTIKEUT WAE RIEULHIEUH
  {0x8C9D, 0xB658}, //2039 #HANGUL SYLLABLE SSANGTIKEUT WAE MIEUM
  {0x8C9E, 0xB659}, //2040 #HANGUL SYLLABLE SSANGTIKEUT WAE PIEUP
  {0x8C9F, 0xB65A}, //2041 #HANGUL SYLLABLE SSANGTIKEUT WAE PIEUPSIOS
  {0x8CA0, 0xB65B}, //2042 #HANGUL SYLLABLE SSANGTIKEUT WAE SIOS
  {0x8CA1, 0xB65C}, //2043 #HANGUL SYLLABLE SSANGTIKEUT WAE SSANGSIOS
  {0x8CA2, 0xB65D}, //2044 #HANGUL SYLLABLE SSANGTIKEUT WAE IEUNG
  {0x8CA3, 0xB65E}, //2045 #HANGUL SYLLABLE SSANGTIKEUT WAE CIEUC
  {0x8CA4, 0xB65F}, //2046 #HANGUL SYLLABLE SSANGTIKEUT WAE CHIEUCH
  {0x8CA5, 0xB660}, //2047 #HANGUL SYLLABLE SSANGTIKEUT WAE KHIEUKH
  {0x8CA6, 0xB661}, //2048 #HANGUL SYLLABLE SSANGTIKEUT WAE THIEUTH
  {0x8CA7, 0xB662}, //2049 #HANGUL SYLLABLE SSANGTIKEUT WAE PHIEUPH
  {0x8CA8, 0xB663}, //2050 #HANGUL SYLLABLE SSANGTIKEUT WAE HIEUH
  {0x8CA9, 0xB665}, //2051 #HANGUL SYLLABLE SSANGTIKEUT OE KIYEOK
  {0x8CAA, 0xB666}, //2052 #HANGUL SYLLABLE SSANGTIKEUT OE SSANGKIYEOK
  {0x8CAB, 0xB667}, //2053 #HANGUL SYLLABLE SSANGTIKEUT OE KIYEOKSIOS
  {0x8CAC, 0xB669}, //2054 #HANGUL SYLLABLE SSANGTIKEUT OE NIEUNCIEUC
  {0x8CAD, 0xB66A}, //2055 #HANGUL SYLLABLE SSANGTIKEUT OE NIEUNHIEUH
  {0x8CAE, 0xB66B}, //2056 #HANGUL SYLLABLE SSANGTIKEUT OE TIKEUT
  {0x8CAF, 0xB66C}, //2057 #HANGUL SYLLABLE SSANGTIKEUT OE RIEUL
  {0x8CB0, 0xB66D}, //2058 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULKIYEOK
  {0x8CB1, 0xB66E}, //2059 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULMIEUM
  {0x8CB2, 0xB66F}, //2060 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULPIEUP
  {0x8CB3, 0xB670}, //2061 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULSIOS
  {0x8CB4, 0xB671}, //2062 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULTHIEUTH
  {0x8CB5, 0xB672}, //2063 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULPHIEUPH
  {0x8CB6, 0xB673}, //2064 #HANGUL SYLLABLE SSANGTIKEUT OE RIEULHIEUH
  {0x8CB7, 0xB674}, //2065 #HANGUL SYLLABLE SSANGTIKEUT OE MIEUM
  {0x8CB8, 0xB675}, //2066 #HANGUL SYLLABLE SSANGTIKEUT OE PIEUP
  {0x8CB9, 0xB676}, //2067 #HANGUL SYLLABLE SSANGTIKEUT OE PIEUPSIOS
  {0x8CBA, 0xB677}, //2068 #HANGUL SYLLABLE SSANGTIKEUT OE SIOS
  {0x8CBB, 0xB678}, //2069 #HANGUL SYLLABLE SSANGTIKEUT OE SSANGSIOS
  {0x8CBC, 0xB679}, //2070 #HANGUL SYLLABLE SSANGTIKEUT OE IEUNG
  {0x8CBD, 0xB67A}, //2071 #HANGUL SYLLABLE SSANGTIKEUT OE CIEUC
  {0x8CBE, 0xB67B}, //2072 #HANGUL SYLLABLE SSANGTIKEUT OE CHIEUCH
  {0x8CBF, 0xB67C}, //2073 #HANGUL SYLLABLE SSANGTIKEUT OE KHIEUKH
  {0x8CC0, 0xB67D}, //2074 #HANGUL SYLLABLE SSANGTIKEUT OE THIEUTH
  {0x8CC1, 0xB67E}, //2075 #HANGUL SYLLABLE SSANGTIKEUT OE PHIEUPH
  {0x8CC2, 0xB67F}, //2076 #HANGUL SYLLABLE SSANGTIKEUT OE HIEUH
  {0x8CC3, 0xB680}, //2077 #HANGUL SYLLABLE SSANGTIKEUT YO
  {0x8CC4, 0xB681}, //2078 #HANGUL SYLLABLE SSANGTIKEUT YO KIYEOK
  {0x8CC5, 0xB682}, //2079 #HANGUL SYLLABLE SSANGTIKEUT YO SSANGKIYEOK
  {0x8CC6, 0xB683}, //2080 #HANGUL SYLLABLE SSANGTIKEUT YO KIYEOKSIOS
  {0x8CC7, 0xB684}, //2081 #HANGUL SYLLABLE SSANGTIKEUT YO NIEUN
  {0x8CC8, 0xB685}, //2082 #HANGUL SYLLABLE SSANGTIKEUT YO NIEUNCIEUC
  {0x8CC9, 0xB686}, //2083 #HANGUL SYLLABLE SSANGTIKEUT YO NIEUNHIEUH
  {0x8CCA, 0xB687}, //2084 #HANGUL SYLLABLE SSANGTIKEUT YO TIKEUT
  {0x8CCB, 0xB688}, //2085 #HANGUL SYLLABLE SSANGTIKEUT YO RIEUL
  {0x8CCC, 0xB689}, //2086 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULKIYEOK
  {0x8CCD, 0xB68A}, //2087 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULMIEUM
  {0x8CCE, 0xB68B}, //2088 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULPIEUP
  {0x8CCF, 0xB68C}, //2089 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULSIOS
  {0x8CD0, 0xB68D}, //2090 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULTHIEUTH
  {0x8CD1, 0xB68E}, //2091 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULPHIEUPH
  {0x8CD2, 0xB68F}, //2092 #HANGUL SYLLABLE SSANGTIKEUT YO RIEULHIEUH
  {0x8CD3, 0xB690}, //2093 #HANGUL SYLLABLE SSANGTIKEUT YO MIEUM
  {0x8CD4, 0xB691}, //2094 #HANGUL SYLLABLE SSANGTIKEUT YO PIEUP
  {0x8CD5, 0xB692}, //2095 #HANGUL SYLLABLE SSANGTIKEUT YO PIEUPSIOS
  {0x8CD6, 0xB693}, //2096 #HANGUL SYLLABLE SSANGTIKEUT YO SIOS
  {0x8CD7, 0xB694}, //2097 #HANGUL SYLLABLE SSANGTIKEUT YO SSANGSIOS
  {0x8CD8, 0xB695}, //2098 #HANGUL SYLLABLE SSANGTIKEUT YO IEUNG
  {0x8CD9, 0xB696}, //2099 #HANGUL SYLLABLE SSANGTIKEUT YO CIEUC
  {0x8CDA, 0xB697}, //2100 #HANGUL SYLLABLE SSANGTIKEUT YO CHIEUCH
  {0x8CDB, 0xB698}, //2101 #HANGUL SYLLABLE SSANGTIKEUT YO KHIEUKH
  {0x8CDC, 0xB699}, //2102 #HANGUL SYLLABLE SSANGTIKEUT YO THIEUTH
  {0x8CDD, 0xB69A}, //2103 #HANGUL SYLLABLE SSANGTIKEUT YO PHIEUPH
  {0x8CDE, 0xB69B}, //2104 #HANGUL SYLLABLE SSANGTIKEUT YO HIEUH
  {0x8CDF, 0xB69E}, //2105 #HANGUL SYLLABLE SSANGTIKEUT U SSANGKIYEOK
  {0x8CE0, 0xB69F}, //2106 #HANGUL SYLLABLE SSANGTIKEUT U KIYEOKSIOS
  {0x8CE1, 0xB6A1}, //2107 #HANGUL SYLLABLE SSANGTIKEUT U NIEUNCIEUC
  {0x8CE2, 0xB6A2}, //2108 #HANGUL SYLLABLE SSANGTIKEUT U NIEUNHIEUH
  {0x8CE3, 0xB6A3}, //2109 #HANGUL SYLLABLE SSANGTIKEUT U TIKEUT
  {0x8CE4, 0xB6A5}, //2110 #HANGUL SYLLABLE SSANGTIKEUT U RIEULKIYEOK
  {0x8CE5, 0xB6A6}, //2111 #HANGUL SYLLABLE SSANGTIKEUT U RIEULMIEUM
  {0x8CE6, 0xB6A7}, //2112 #HANGUL SYLLABLE SSANGTIKEUT U RIEULPIEUP
  {0x8CE7, 0xB6A8}, //2113 #HANGUL SYLLABLE SSANGTIKEUT U RIEULSIOS
  {0x8CE8, 0xB6A9}, //2114 #HANGUL SYLLABLE SSANGTIKEUT U RIEULTHIEUTH
  {0x8CE9, 0xB6AA}, //2115 #HANGUL SYLLABLE SSANGTIKEUT U RIEULPHIEUPH
  {0x8CEA, 0xB6AD}, //2116 #HANGUL SYLLABLE SSANGTIKEUT U PIEUP
  {0x8CEB, 0xB6AE}, //2117 #HANGUL SYLLABLE SSANGTIKEUT U PIEUPSIOS
  {0x8CEC, 0xB6AF}, //2118 #HANGUL SYLLABLE SSANGTIKEUT U SIOS
  {0x8CED, 0xB6B0}, //2119 #HANGUL SYLLABLE SSANGTIKEUT U SSANGSIOS
  {0x8CEE, 0xB6B2}, //2120 #HANGUL SYLLABLE SSANGTIKEUT U CIEUC
  {0x8CEF, 0xB6B3}, //2121 #HANGUL SYLLABLE SSANGTIKEUT U CHIEUCH
  {0x8CF0, 0xB6B4}, //2122 #HANGUL SYLLABLE SSANGTIKEUT U KHIEUKH
  {0x8CF1, 0xB6B5}, //2123 #HANGUL SYLLABLE SSANGTIKEUT U THIEUTH
  {0x8CF2, 0xB6B6}, //2124 #HANGUL SYLLABLE SSANGTIKEUT U PHIEUPH
  {0x8CF3, 0xB6B7}, //2125 #HANGUL SYLLABLE SSANGTIKEUT U HIEUH
  {0x8CF4, 0xB6B8}, //2126 #HANGUL SYLLABLE SSANGTIKEUT WEO
  {0x8CF5, 0xB6B9}, //2127 #HANGUL SYLLABLE SSANGTIKEUT WEO KIYEOK
  {0x8CF6, 0xB6BA}, //2128 #HANGUL SYLLABLE SSANGTIKEUT WEO SSANGKIYEOK
  {0x8CF7, 0xB6BB}, //2129 #HANGUL SYLLABLE SSANGTIKEUT WEO KIYEOKSIOS
  {0x8CF8, 0xB6BC}, //2130 #HANGUL SYLLABLE SSANGTIKEUT WEO NIEUN
  {0x8CF9, 0xB6BD}, //2131 #HANGUL SYLLABLE SSANGTIKEUT WEO NIEUNCIEUC
  {0x8CFA, 0xB6BE}, //2132 #HANGUL SYLLABLE SSANGTIKEUT WEO NIEUNHIEUH
  {0x8CFB, 0xB6BF}, //2133 #HANGUL SYLLABLE SSANGTIKEUT WEO TIKEUT
  {0x8CFC, 0xB6C0}, //2134 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEUL
  {0x8CFD, 0xB6C1}, //2135 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULKIYEOK
  {0x8CFE, 0xB6C2}, //2136 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULMIEUM
  {0x8D41, 0xB6C3}, //2137 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULPIEUP
  {0x8D42, 0xB6C4}, //2138 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULSIOS
  {0x8D43, 0xB6C5}, //2139 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULTHIEUTH
  {0x8D44, 0xB6C6}, //2140 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULPHIEUPH
  {0x8D45, 0xB6C7}, //2141 #HANGUL SYLLABLE SSANGTIKEUT WEO RIEULHIEUH
  {0x8D46, 0xB6C8}, //2142 #HANGUL SYLLABLE SSANGTIKEUT WEO MIEUM
  {0x8D47, 0xB6C9}, //2143 #HANGUL SYLLABLE SSANGTIKEUT WEO PIEUP
  {0x8D48, 0xB6CA}, //2144 #HANGUL SYLLABLE SSANGTIKEUT WEO PIEUPSIOS
  {0x8D49, 0xB6CB}, //2145 #HANGUL SYLLABLE SSANGTIKEUT WEO SIOS
  {0x8D4A, 0xB6CC}, //2146 #HANGUL SYLLABLE SSANGTIKEUT WEO SSANGSIOS
  {0x8D4B, 0xB6CD}, //2147 #HANGUL SYLLABLE SSANGTIKEUT WEO IEUNG
  {0x8D4C, 0xB6CE}, //2148 #HANGUL SYLLABLE SSANGTIKEUT WEO CIEUC
  {0x8D4D, 0xB6CF}, //2149 #HANGUL SYLLABLE SSANGTIKEUT WEO CHIEUCH
  {0x8D4E, 0xB6D0}, //2150 #HANGUL SYLLABLE SSANGTIKEUT WEO KHIEUKH
  {0x8D4F, 0xB6D1}, //2151 #HANGUL SYLLABLE SSANGTIKEUT WEO THIEUTH
  {0x8D50, 0xB6D2}, //2152 #HANGUL SYLLABLE SSANGTIKEUT WEO PHIEUPH
  {0x8D51, 0xB6D3}, //2153 #HANGUL SYLLABLE SSANGTIKEUT WEO HIEUH
  {0x8D52, 0xB6D5}, //2154 #HANGUL SYLLABLE SSANGTIKEUT WE KIYEOK
  {0x8D53, 0xB6D6}, //2155 #HANGUL SYLLABLE SSANGTIKEUT WE SSANGKIYEOK
  {0x8D54, 0xB6D7}, //2156 #HANGUL SYLLABLE SSANGTIKEUT WE KIYEOKSIOS
  {0x8D55, 0xB6D8}, //2157 #HANGUL SYLLABLE SSANGTIKEUT WE NIEUN
  {0x8D56, 0xB6D9}, //2158 #HANGUL SYLLABLE SSANGTIKEUT WE NIEUNCIEUC
  {0x8D57, 0xB6DA}, //2159 #HANGUL SYLLABLE SSANGTIKEUT WE NIEUNHIEUH
  {0x8D58, 0xB6DB}, //2160 #HANGUL SYLLABLE SSANGTIKEUT WE TIKEUT
  {0x8D59, 0xB6DC}, //2161 #HANGUL SYLLABLE SSANGTIKEUT WE RIEUL
  {0x8D5A, 0xB6DD}, //2162 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULKIYEOK
  {0x8D61, 0xB6DE}, //2163 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULMIEUM
  {0x8D62, 0xB6DF}, //2164 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULPIEUP
  {0x8D63, 0xB6E0}, //2165 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULSIOS
  {0x8D64, 0xB6E1}, //2166 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULTHIEUTH
  {0x8D65, 0xB6E2}, //2167 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULPHIEUPH
  {0x8D66, 0xB6E3}, //2168 #HANGUL SYLLABLE SSANGTIKEUT WE RIEULHIEUH
  {0x8D67, 0xB6E4}, //2169 #HANGUL SYLLABLE SSANGTIKEUT WE MIEUM
  {0x8D68, 0xB6E5}, //2170 #HANGUL SYLLABLE SSANGTIKEUT WE PIEUP
  {0x8D69, 0xB6E6}, //2171 #HANGUL SYLLABLE SSANGTIKEUT WE PIEUPSIOS
  {0x8D6A, 0xB6E7}, //2172 #HANGUL SYLLABLE SSANGTIKEUT WE SIOS
  {0x8D6B, 0xB6E8}, //2173 #HANGUL SYLLABLE SSANGTIKEUT WE SSANGSIOS
  {0x8D6C, 0xB6E9}, //2174 #HANGUL SYLLABLE SSANGTIKEUT WE IEUNG
  {0x8D6D, 0xB6EA}, //2175 #HANGUL SYLLABLE SSANGTIKEUT WE CIEUC
  {0x8D6E, 0xB6EB}, //2176 #HANGUL SYLLABLE SSANGTIKEUT WE CHIEUCH
  {0x8D6F, 0xB6EC}, //2177 #HANGUL SYLLABLE SSANGTIKEUT WE KHIEUKH
  {0x8D70, 0xB6ED}, //2178 #HANGUL SYLLABLE SSANGTIKEUT WE THIEUTH
  {0x8D71, 0xB6EE}, //2179 #HANGUL SYLLABLE SSANGTIKEUT WE PHIEUPH
  {0x8D72, 0xB6EF}, //2180 #HANGUL SYLLABLE SSANGTIKEUT WE HIEUH
  {0x8D73, 0xB6F1}, //2181 #HANGUL SYLLABLE SSANGTIKEUT WI KIYEOK
  {0x8D74, 0xB6F2}, //2182 #HANGUL SYLLABLE SSANGTIKEUT WI SSANGKIYEOK
  {0x8D75, 0xB6F3}, //2183 #HANGUL SYLLABLE SSANGTIKEUT WI KIYEOKSIOS
  {0x8D76, 0xB6F5}, //2184 #HANGUL SYLLABLE SSANGTIKEUT WI NIEUNCIEUC
  {0x8D77, 0xB6F6}, //2185 #HANGUL SYLLABLE SSANGTIKEUT WI NIEUNHIEUH
  {0x8D78, 0xB6F7}, //2186 #HANGUL SYLLABLE SSANGTIKEUT WI TIKEUT
  {0x8D79, 0xB6F9}, //2187 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULKIYEOK
  {0x8D7A, 0xB6FA}, //2188 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULMIEUM
  {0x8D81, 0xB6FB}, //2189 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULPIEUP
  {0x8D82, 0xB6FC}, //2190 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULSIOS
  {0x8D83, 0xB6FD}, //2191 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULTHIEUTH
  {0x8D84, 0xB6FE}, //2192 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULPHIEUPH
  {0x8D85, 0xB6FF}, //2193 #HANGUL SYLLABLE SSANGTIKEUT WI RIEULHIEUH
  {0x8D86, 0xB702}, //2194 #HANGUL SYLLABLE SSANGTIKEUT WI PIEUPSIOS
  {0x8D87, 0xB703}, //2195 #HANGUL SYLLABLE SSANGTIKEUT WI SIOS
  {0x8D88, 0xB704}, //2196 #HANGUL SYLLABLE SSANGTIKEUT WI SSANGSIOS
  {0x8D89, 0xB706}, //2197 #HANGUL SYLLABLE SSANGTIKEUT WI CIEUC
  {0x8D8A, 0xB707}, //2198 #HANGUL SYLLABLE SSANGTIKEUT WI CHIEUCH
  {0x8D8B, 0xB708}, //2199 #HANGUL SYLLABLE SSANGTIKEUT WI KHIEUKH
  {0x8D8C, 0xB709}, //2200 #HANGUL SYLLABLE SSANGTIKEUT WI THIEUTH
  {0x8D8D, 0xB70A}, //2201 #HANGUL SYLLABLE SSANGTIKEUT WI PHIEUPH
  {0x8D8E, 0xB70B}, //2202 #HANGUL SYLLABLE SSANGTIKEUT WI HIEUH
  {0x8D8F, 0xB70C}, //2203 #HANGUL SYLLABLE SSANGTIKEUT YU
  {0x8D90, 0xB70D}, //2204 #HANGUL SYLLABLE SSANGTIKEUT YU KIYEOK
  {0x8D91, 0xB70E}, //2205 #HANGUL SYLLABLE SSANGTIKEUT YU SSANGKIYEOK
  {0x8D92, 0xB70F}, //2206 #HANGUL SYLLABLE SSANGTIKEUT YU KIYEOKSIOS
  {0x8D93, 0xB710}, //2207 #HANGUL SYLLABLE SSANGTIKEUT YU NIEUN
  {0x8D94, 0xB711}, //2208 #HANGUL SYLLABLE SSANGTIKEUT YU NIEUNCIEUC
  {0x8D95, 0xB712}, //2209 #HANGUL SYLLABLE SSANGTIKEUT YU NIEUNHIEUH
  {0x8D96, 0xB713}, //2210 #HANGUL SYLLABLE SSANGTIKEUT YU TIKEUT
  {0x8D97, 0xB714}, //2211 #HANGUL SYLLABLE SSANGTIKEUT YU RIEUL
  {0x8D98, 0xB715}, //2212 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULKIYEOK
  {0x8D99, 0xB716}, //2213 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULMIEUM
  {0x8D9A, 0xB717}, //2214 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULPIEUP
  {0x8D9B, 0xB718}, //2215 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULSIOS
  {0x8D9C, 0xB719}, //2216 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULTHIEUTH
  {0x8D9D, 0xB71A}, //2217 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULPHIEUPH
  {0x8D9E, 0xB71B}, //2218 #HANGUL SYLLABLE SSANGTIKEUT YU RIEULHIEUH
  {0x8D9F, 0xB71C}, //2219 #HANGUL SYLLABLE SSANGTIKEUT YU MIEUM
  {0x8DA0, 0xB71D}, //2220 #HANGUL SYLLABLE SSANGTIKEUT YU PIEUP
  {0x8DA1, 0xB71E}, //2221 #HANGUL SYLLABLE SSANGTIKEUT YU PIEUPSIOS
  {0x8DA2, 0xB71F}, //2222 #HANGUL SYLLABLE SSANGTIKEUT YU SIOS
  {0x8DA3, 0xB720}, //2223 #HANGUL SYLLABLE SSANGTIKEUT YU SSANGSIOS
  {0x8DA4, 0xB721}, //2224 #HANGUL SYLLABLE SSANGTIKEUT YU IEUNG
  {0x8DA5, 0xB722}, //2225 #HANGUL SYLLABLE SSANGTIKEUT YU CIEUC
  {0x8DA6, 0xB723}, //2226 #HANGUL SYLLABLE SSANGTIKEUT YU CHIEUCH
  {0x8DA7, 0xB724}, //2227 #HANGUL SYLLABLE SSANGTIKEUT YU KHIEUKH
  {0x8DA8, 0xB725}, //2228 #HANGUL SYLLABLE SSANGTIKEUT YU THIEUTH
  {0x8DA9, 0xB726}, //2229 #HANGUL SYLLABLE SSANGTIKEUT YU PHIEUPH
  {0x8DAA, 0xB727}, //2230 #HANGUL SYLLABLE SSANGTIKEUT YU HIEUH
  {0x8DAB, 0xB72A}, //2231 #HANGUL SYLLABLE SSANGTIKEUT EU SSANGKIYEOK
  {0x8DAC, 0xB72B}, //2232 #HANGUL SYLLABLE SSANGTIKEUT EU KIYEOKSIOS
  {0x8DAD, 0xB72D}, //2233 #HANGUL SYLLABLE SSANGTIKEUT EU NIEUNCIEUC
  {0x8DAE, 0xB72E}, //2234 #HANGUL SYLLABLE SSANGTIKEUT EU NIEUNHIEUH
  {0x8DAF, 0xB731}, //2235 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULKIYEOK
  {0x8DB0, 0xB732}, //2236 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULMIEUM
  {0x8DB1, 0xB733}, //2237 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULPIEUP
  {0x8DB2, 0xB734}, //2238 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULSIOS
  {0x8DB3, 0xB735}, //2239 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULTHIEUTH
  {0x8DB4, 0xB736}, //2240 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULPHIEUPH
  {0x8DB5, 0xB737}, //2241 #HANGUL SYLLABLE SSANGTIKEUT EU RIEULHIEUH
  {0x8DB6, 0xB73A}, //2242 #HANGUL SYLLABLE SSANGTIKEUT EU PIEUPSIOS
  {0x8DB7, 0xB73C}, //2243 #HANGUL SYLLABLE SSANGTIKEUT EU SSANGSIOS
  {0x8DB8, 0xB73D}, //2244 #HANGUL SYLLABLE SSANGTIKEUT EU IEUNG
  {0x8DB9, 0xB73E}, //2245 #HANGUL SYLLABLE SSANGTIKEUT EU CIEUC
  {0x8DBA, 0xB73F}, //2246 #HANGUL SYLLABLE SSANGTIKEUT EU CHIEUCH
  {0x8DBB, 0xB740}, //2247 #HANGUL SYLLABLE SSANGTIKEUT EU KHIEUKH
  {0x8DBC, 0xB741}, //2248 #HANGUL SYLLABLE SSANGTIKEUT EU THIEUTH
  {0x8DBD, 0xB742}, //2249 #HANGUL SYLLABLE SSANGTIKEUT EU PHIEUPH
  {0x8DBE, 0xB743}, //2250 #HANGUL SYLLABLE SSANGTIKEUT EU HIEUH
  {0x8DBF, 0xB745}, //2251 #HANGUL SYLLABLE SSANGTIKEUT YI KIYEOK
  {0x8DC0, 0xB746}, //2252 #HANGUL SYLLABLE SSANGTIKEUT YI SSANGKIYEOK
  {0x8DC1, 0xB747}, //2253 #HANGUL SYLLABLE SSANGTIKEUT YI KIYEOKSIOS
  {0x8DC2, 0xB749}, //2254 #HANGUL SYLLABLE SSANGTIKEUT YI NIEUNCIEUC
  {0x8DC3, 0xB74A}, //2255 #HANGUL SYLLABLE SSANGTIKEUT YI NIEUNHIEUH
  {0x8DC4, 0xB74B}, //2256 #HANGUL SYLLABLE SSANGTIKEUT YI TIKEUT
  {0x8DC5, 0xB74D}, //2257 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULKIYEOK
  {0x8DC6, 0xB74E}, //2258 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULMIEUM
  {0x8DC7, 0xB74F}, //2259 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULPIEUP
  {0x8DC8, 0xB750}, //2260 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULSIOS
  {0x8DC9, 0xB751}, //2261 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULTHIEUTH
  {0x8DCA, 0xB752}, //2262 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULPHIEUPH
  {0x8DCB, 0xB753}, //2263 #HANGUL SYLLABLE SSANGTIKEUT YI RIEULHIEUH
  {0x8DCC, 0xB756}, //2264 #HANGUL SYLLABLE SSANGTIKEUT YI PIEUPSIOS
  {0x8DCD, 0xB757}, //2265 #HANGUL SYLLABLE SSANGTIKEUT YI SIOS
  {0x8DCE, 0xB758}, //2266 #HANGUL SYLLABLE SSANGTIKEUT YI SSANGSIOS
  {0x8DCF, 0xB759}, //2267 #HANGUL SYLLABLE SSANGTIKEUT YI IEUNG
  {0x8DD0, 0xB75A}, //2268 #HANGUL SYLLABLE SSANGTIKEUT YI CIEUC
  {0x8DD1, 0xB75B}, //2269 #HANGUL SYLLABLE SSANGTIKEUT YI CHIEUCH
  {0x8DD2, 0xB75C}, //2270 #HANGUL SYLLABLE SSANGTIKEUT YI KHIEUKH
  {0x8DD3, 0xB75D}, //2271 #HANGUL SYLLABLE SSANGTIKEUT YI THIEUTH
  {0x8DD4, 0xB75E}, //2272 #HANGUL SYLLABLE SSANGTIKEUT YI PHIEUPH
  {0x8DD5, 0xB75F}, //2273 #HANGUL SYLLABLE SSANGTIKEUT YI HIEUH
  {0x8DD6, 0xB761}, //2274 #HANGUL SYLLABLE SSANGTIKEUT I KIYEOK
  {0x8DD7, 0xB762}, //2275 #HANGUL SYLLABLE SSANGTIKEUT I SSANGKIYEOK
  {0x8DD8, 0xB763}, //2276 #HANGUL SYLLABLE SSANGTIKEUT I KIYEOKSIOS
  {0x8DD9, 0xB765}, //2277 #HANGUL SYLLABLE SSANGTIKEUT I NIEUNCIEUC
  {0x8DDA, 0xB766}, //2278 #HANGUL SYLLABLE SSANGTIKEUT I NIEUNHIEUH
  {0x8DDB, 0xB767}, //2279 #HANGUL SYLLABLE SSANGTIKEUT I TIKEUT
  {0x8DDC, 0xB769}, //2280 #HANGUL SYLLABLE SSANGTIKEUT I RIEULKIYEOK
  {0x8DDD, 0xB76A}, //2281 #HANGUL SYLLABLE SSANGTIKEUT I RIEULMIEUM
  {0x8DDE, 0xB76B}, //2282 #HANGUL SYLLABLE SSANGTIKEUT I RIEULPIEUP
  {0x8DDF, 0xB76C}, //2283 #HANGUL SYLLABLE SSANGTIKEUT I RIEULSIOS
  {0x8DE0, 0xB76D}, //2284 #HANGUL SYLLABLE SSANGTIKEUT I RIEULTHIEUTH
  {0x8DE1, 0xB76E}, //2285 #HANGUL SYLLABLE SSANGTIKEUT I RIEULPHIEUPH
  {0x8DE2, 0xB76F}, //2286 #HANGUL SYLLABLE SSANGTIKEUT I RIEULHIEUH
  {0x8DE3, 0xB772}, //2287 #HANGUL SYLLABLE SSANGTIKEUT I PIEUPSIOS
  {0x8DE4, 0xB774}, //2288 #HANGUL SYLLABLE SSANGTIKEUT I SSANGSIOS
  {0x8DE5, 0xB776}, //2289 #HANGUL SYLLABLE SSANGTIKEUT I CIEUC
  {0x8DE6, 0xB777}, //2290 #HANGUL SYLLABLE SSANGTIKEUT I CHIEUCH
  {0x8DE7, 0xB778}, //2291 #HANGUL SYLLABLE SSANGTIKEUT I KHIEUKH
  {0x8DE8, 0xB779}, //2292 #HANGUL SYLLABLE SSANGTIKEUT I THIEUTH
  {0x8DE9, 0xB77A}, //2293 #HANGUL SYLLABLE SSANGTIKEUT I PHIEUPH
  {0x8DEA, 0xB77B}, //2294 #HANGUL SYLLABLE SSANGTIKEUT I HIEUH
  {0x8DEB, 0xB77E}, //2295 #HANGUL SYLLABLE RIEUL A SSANGKIYEOK
  {0x8DEC, 0xB77F}, //2296 #HANGUL SYLLABLE RIEUL A KIYEOKSIOS
  {0x8DED, 0xB781}, //2297 #HANGUL SYLLABLE RIEUL A NIEUNCIEUC
  {0x8DEE, 0xB782}, //2298 #HANGUL SYLLABLE RIEUL A NIEUNHIEUH
  {0x8DEF, 0xB783}, //2299 #HANGUL SYLLABLE RIEUL A TIKEUT
  {0x8DF0, 0xB785}, //2300 #HANGUL SYLLABLE RIEUL A RIEULKIYEOK
  {0x8DF1, 0xB786}, //2301 #HANGUL SYLLABLE RIEUL A RIEULMIEUM
  {0x8DF2, 0xB787}, //2302 #HANGUL SYLLABLE RIEUL A RIEULPIEUP
  {0x8DF3, 0xB788}, //2303 #HANGUL SYLLABLE RIEUL A RIEULSIOS
  {0x8DF4, 0xB789}, //2304 #HANGUL SYLLABLE RIEUL A RIEULTHIEUTH
  {0x8DF5, 0xB78A}, //2305 #HANGUL SYLLABLE RIEUL A RIEULPHIEUPH
  {0x8DF6, 0xB78B}, //2306 #HANGUL SYLLABLE RIEUL A RIEULHIEUH
  {0x8DF7, 0xB78E}, //2307 #HANGUL SYLLABLE RIEUL A PIEUPSIOS
  {0x8DF8, 0xB793}, //2308 #HANGUL SYLLABLE RIEUL A CHIEUCH
  {0x8DF9, 0xB794}, //2309 #HANGUL SYLLABLE RIEUL A KHIEUKH
  {0x8DFA, 0xB795}, //2310 #HANGUL SYLLABLE RIEUL A THIEUTH
  {0x8DFB, 0xB79A}, //2311 #HANGUL SYLLABLE RIEUL AE SSANGKIYEOK
  {0x8DFC, 0xB79B}, //2312 #HANGUL SYLLABLE RIEUL AE KIYEOKSIOS
  {0x8DFD, 0xB79D}, //2313 #HANGUL SYLLABLE RIEUL AE NIEUNCIEUC
  {0x8DFE, 0xB79E}, //2314 #HANGUL SYLLABLE RIEUL AE NIEUNHIEUH
  {0x8E41, 0xB79F}, //2315 #HANGUL SYLLABLE RIEUL AE TIKEUT
  {0x8E42, 0xB7A1}, //2316 #HANGUL SYLLABLE RIEUL AE RIEULKIYEOK
  {0x8E43, 0xB7A2}, //2317 #HANGUL SYLLABLE RIEUL AE RIEULMIEUM
  {0x8E44, 0xB7A3}, //2318 #HANGUL SYLLABLE RIEUL AE RIEULPIEUP
  {0x8E45, 0xB7A4}, //2319 #HANGUL SYLLABLE RIEUL AE RIEULSIOS
  {0x8E46, 0xB7A5}, //2320 #HANGUL SYLLABLE RIEUL AE RIEULTHIEUTH
  {0x8E47, 0xB7A6}, //2321 #HANGUL SYLLABLE RIEUL AE RIEULPHIEUPH
  {0x8E48, 0xB7A7}, //2322 #HANGUL SYLLABLE RIEUL AE RIEULHIEUH
  {0x8E49, 0xB7AA}, //2323 #HANGUL SYLLABLE RIEUL AE PIEUPSIOS
  {0x8E4A, 0xB7AE}, //2324 #HANGUL SYLLABLE RIEUL AE CIEUC
  {0x8E4B, 0xB7AF}, //2325 #HANGUL SYLLABLE RIEUL AE CHIEUCH
  {0x8E4C, 0xB7B0}, //2326 #HANGUL SYLLABLE RIEUL AE KHIEUKH
  {0x8E4D, 0xB7B1}, //2327 #HANGUL SYLLABLE RIEUL AE THIEUTH
  {0x8E4E, 0xB7B2}, //2328 #HANGUL SYLLABLE RIEUL AE PHIEUPH
  {0x8E4F, 0xB7B3}, //2329 #HANGUL SYLLABLE RIEUL AE HIEUH
  {0x8E50, 0xB7B6}, //2330 #HANGUL SYLLABLE RIEUL YA SSANGKIYEOK
  {0x8E51, 0xB7B7}, //2331 #HANGUL SYLLABLE RIEUL YA KIYEOKSIOS
  {0x8E52, 0xB7B9}, //2332 #HANGUL SYLLABLE RIEUL YA NIEUNCIEUC
  {0x8E53, 0xB7BA}, //2333 #HANGUL SYLLABLE RIEUL YA NIEUNHIEUH
  {0x8E54, 0xB7BB}, //2334 #HANGUL SYLLABLE RIEUL YA TIKEUT
  {0x8E55, 0xB7BC}, //2335 #HANGUL SYLLABLE RIEUL YA RIEUL
  {0x8E56, 0xB7BD}, //2336 #HANGUL SYLLABLE RIEUL YA RIEULKIYEOK
  {0x8E57, 0xB7BE}, //2337 #HANGUL SYLLABLE RIEUL YA RIEULMIEUM
  {0x8E58, 0xB7BF}, //2338 #HANGUL SYLLABLE RIEUL YA RIEULPIEUP
  {0x8E59, 0xB7C0}, //2339 #HANGUL SYLLABLE RIEUL YA RIEULSIOS
  {0x8E5A, 0xB7C1}, //2340 #HANGUL SYLLABLE RIEUL YA RIEULTHIEUTH
  {0x8E61, 0xB7C2}, //2341 #HANGUL SYLLABLE RIEUL YA RIEULPHIEUPH
  {0x8E62, 0xB7C3}, //2342 #HANGUL SYLLABLE RIEUL YA RIEULHIEUH
  {0x8E63, 0xB7C4}, //2343 #HANGUL SYLLABLE RIEUL YA MIEUM
  {0x8E64, 0xB7C5}, //2344 #HANGUL SYLLABLE RIEUL YA PIEUP
  {0x8E65, 0xB7C6}, //2345 #HANGUL SYLLABLE RIEUL YA PIEUPSIOS
  {0x8E66, 0xB7C8}, //2346 #HANGUL SYLLABLE RIEUL YA SSANGSIOS
  {0x8E67, 0xB7CA}, //2347 #HANGUL SYLLABLE RIEUL YA CIEUC
  {0x8E68, 0xB7CB}, //2348 #HANGUL SYLLABLE RIEUL YA CHIEUCH
  {0x8E69, 0xB7CC}, //2349 #HANGUL SYLLABLE RIEUL YA KHIEUKH
  {0x8E6A, 0xB7CD}, //2350 #HANGUL SYLLABLE RIEUL YA THIEUTH
  {0x8E6B, 0xB7CE}, //2351 #HANGUL SYLLABLE RIEUL YA PHIEUPH
  {0x8E6C, 0xB7CF}, //2352 #HANGUL SYLLABLE RIEUL YA HIEUH
  {0x8E6D, 0xB7D0}, //2353 #HANGUL SYLLABLE RIEUL YAE
  {0x8E6E, 0xB7D1}, //2354 #HANGUL SYLLABLE RIEUL YAE KIYEOK
  {0x8E6F, 0xB7D2}, //2355 #HANGUL SYLLABLE RIEUL YAE SSANGKIYEOK
  {0x8E70, 0xB7D3}, //2356 #HANGUL SYLLABLE RIEUL YAE KIYEOKSIOS
  {0x8E71, 0xB7D4}, //2357 #HANGUL SYLLABLE RIEUL YAE NIEUN
  {0x8E72, 0xB7D5}, //2358 #HANGUL SYLLABLE RIEUL YAE NIEUNCIEUC
  {0x8E73, 0xB7D6}, //2359 #HANGUL SYLLABLE RIEUL YAE NIEUNHIEUH
  {0x8E74, 0xB7D7}, //2360 #HANGUL SYLLABLE RIEUL YAE TIKEUT
  {0x8E75, 0xB7D8}, //2361 #HANGUL SYLLABLE RIEUL YAE RIEUL
  {0x8E76, 0xB7D9}, //2362 #HANGUL SYLLABLE RIEUL YAE RIEULKIYEOK
  {0x8E77, 0xB7DA}, //2363 #HANGUL SYLLABLE RIEUL YAE RIEULMIEUM
  {0x8E78, 0xB7DB}, //2364 #HANGUL SYLLABLE RIEUL YAE RIEULPIEUP
  {0x8E79, 0xB7DC}, //2365 #HANGUL SYLLABLE RIEUL YAE RIEULSIOS
  {0x8E7A, 0xB7DD}, //2366 #HANGUL SYLLABLE RIEUL YAE RIEULTHIEUTH
  {0x8E81, 0xB7DE}, //2367 #HANGUL SYLLABLE RIEUL YAE RIEULPHIEUPH
  {0x8E82, 0xB7DF}, //2368 #HANGUL SYLLABLE RIEUL YAE RIEULHIEUH
  {0x8E83, 0xB7E0}, //2369 #HANGUL SYLLABLE RIEUL YAE MIEUM
  {0x8E84, 0xB7E1}, //2370 #HANGUL SYLLABLE RIEUL YAE PIEUP
  {0x8E85, 0xB7E2}, //2371 #HANGUL SYLLABLE RIEUL YAE PIEUPSIOS
  {0x8E86, 0xB7E3}, //2372 #HANGUL SYLLABLE RIEUL YAE SIOS
  {0x8E87, 0xB7E4}, //2373 #HANGUL SYLLABLE RIEUL YAE SSANGSIOS
  {0x8E88, 0xB7E5}, //2374 #HANGUL SYLLABLE RIEUL YAE IEUNG
  {0x8E89, 0xB7E6}, //2375 #HANGUL SYLLABLE RIEUL YAE CIEUC
  {0x8E8A, 0xB7E7}, //2376 #HANGUL SYLLABLE RIEUL YAE CHIEUCH
  {0x8E8B, 0xB7E8}, //2377 #HANGUL SYLLABLE RIEUL YAE KHIEUKH
  {0x8E8C, 0xB7E9}, //2378 #HANGUL SYLLABLE RIEUL YAE THIEUTH
  {0x8E8D, 0xB7EA}, //2379 #HANGUL SYLLABLE RIEUL YAE PHIEUPH
  {0x8E8E, 0xB7EB}, //2380 #HANGUL SYLLABLE RIEUL YAE HIEUH
  {0x8E8F, 0xB7EE}, //2381 #HANGUL SYLLABLE RIEUL EO SSANGKIYEOK
  {0x8E90, 0xB7EF}, //2382 #HANGUL SYLLABLE RIEUL EO KIYEOKSIOS
  {0x8E91, 0xB7F1}, //2383 #HANGUL SYLLABLE RIEUL EO NIEUNCIEUC
  {0x8E92, 0xB7F2}, //2384 #HANGUL SYLLABLE RIEUL EO NIEUNHIEUH
  {0x8E93, 0xB7F3}, //2385 #HANGUL SYLLABLE RIEUL EO TIKEUT
  {0x8E94, 0xB7F5}, //2386 #HANGUL SYLLABLE RIEUL EO RIEULKIYEOK
  {0x8E95, 0xB7F6}, //2387 #HANGUL SYLLABLE RIEUL EO RIEULMIEUM
  {0x8E96, 0xB7F7}, //2388 #HANGUL SYLLABLE RIEUL EO RIEULPIEUP
  {0x8E97, 0xB7F8}, //2389 #HANGUL SYLLABLE RIEUL EO RIEULSIOS
  {0x8E98, 0xB7F9}, //2390 #HANGUL SYLLABLE RIEUL EO RIEULTHIEUTH
  {0x8E99, 0xB7FA}, //2391 #HANGUL SYLLABLE RIEUL EO RIEULPHIEUPH
  {0x8E9A, 0xB7FB}, //2392 #HANGUL SYLLABLE RIEUL EO RIEULHIEUH
  {0x8E9B, 0xB7FE}, //2393 #HANGUL SYLLABLE RIEUL EO PIEUPSIOS
  {0x8E9C, 0xB802}, //2394 #HANGUL SYLLABLE RIEUL EO CIEUC
  {0x8E9D, 0xB803}, //2395 #HANGUL SYLLABLE RIEUL EO CHIEUCH
  {0x8E9E, 0xB804}, //2396 #HANGUL SYLLABLE RIEUL EO KHIEUKH
  {0x8E9F, 0xB805}, //2397 #HANGUL SYLLABLE RIEUL EO THIEUTH
  {0x8EA0, 0xB806}, //2398 #HANGUL SYLLABLE RIEUL EO PHIEUPH
  {0x8EA1, 0xB80A}, //2399 #HANGUL SYLLABLE RIEUL E SSANGKIYEOK
  {0x8EA2, 0xB80B}, //2400 #HANGUL SYLLABLE RIEUL E KIYEOKSIOS
  {0x8EA3, 0xB80D}, //2401 #HANGUL SYLLABLE RIEUL E NIEUNCIEUC
  {0x8EA4, 0xB80E}, //2402 #HANGUL SYLLABLE RIEUL E NIEUNHIEUH
  {0x8EA5, 0xB80F}, //2403 #HANGUL SYLLABLE RIEUL E TIKEUT
  {0x8EA6, 0xB811}, //2404 #HANGUL SYLLABLE RIEUL E RIEULKIYEOK
  {0x8EA7, 0xB812}, //2405 #HANGUL SYLLABLE RIEUL E RIEULMIEUM
  {0x8EA8, 0xB813}, //2406 #HANGUL SYLLABLE RIEUL E RIEULPIEUP
  {0x8EA9, 0xB814}, //2407 #HANGUL SYLLABLE RIEUL E RIEULSIOS
  {0x8EAA, 0xB815}, //2408 #HANGUL SYLLABLE RIEUL E RIEULTHIEUTH
  {0x8EAB, 0xB816}, //2409 #HANGUL SYLLABLE RIEUL E RIEULPHIEUPH
  {0x8EAC, 0xB817}, //2410 #HANGUL SYLLABLE RIEUL E RIEULHIEUH
  {0x8EAD, 0xB81A}, //2411 #HANGUL SYLLABLE RIEUL E PIEUPSIOS
  {0x8EAE, 0xB81C}, //2412 #HANGUL SYLLABLE RIEUL E SSANGSIOS
  {0x8EAF, 0xB81E}, //2413 #HANGUL SYLLABLE RIEUL E CIEUC
  {0x8EB0, 0xB81F}, //2414 #HANGUL SYLLABLE RIEUL E CHIEUCH
  {0x8EB1, 0xB820}, //2415 #HANGUL SYLLABLE RIEUL E KHIEUKH
  {0x8EB2, 0xB821}, //2416 #HANGUL SYLLABLE RIEUL E THIEUTH
  {0x8EB3, 0xB822}, //2417 #HANGUL SYLLABLE RIEUL E PHIEUPH
  {0x8EB4, 0xB823}, //2418 #HANGUL SYLLABLE RIEUL E HIEUH
  {0x8EB5, 0xB826}, //2419 #HANGUL SYLLABLE RIEUL YEO SSANGKIYEOK
  {0x8EB6, 0xB827}, //2420 #HANGUL SYLLABLE RIEUL YEO KIYEOKSIOS
  {0x8EB7, 0xB829}, //2421 #HANGUL SYLLABLE RIEUL YEO NIEUNCIEUC
  {0x8EB8, 0xB82A}, //2422 #HANGUL SYLLABLE RIEUL YEO NIEUNHIEUH
  {0x8EB9, 0xB82B}, //2423 #HANGUL SYLLABLE RIEUL YEO TIKEUT
  {0x8EBA, 0xB82D}, //2424 #HANGUL SYLLABLE RIEUL YEO RIEULKIYEOK
  {0x8EBB, 0xB82E}, //2425 #HANGUL SYLLABLE RIEUL YEO RIEULMIEUM
  {0x8EBC, 0xB82F}, //2426 #HANGUL SYLLABLE RIEUL YEO RIEULPIEUP
  {0x8EBD, 0xB830}, //2427 #HANGUL SYLLABLE RIEUL YEO RIEULSIOS
  {0x8EBE, 0xB831}, //2428 #HANGUL SYLLABLE RIEUL YEO RIEULTHIEUTH
  {0x8EBF, 0xB832}, //2429 #HANGUL SYLLABLE RIEUL YEO RIEULPHIEUPH
  {0x8EC0, 0xB833}, //2430 #HANGUL SYLLABLE RIEUL YEO RIEULHIEUH
  {0x8EC1, 0xB836}, //2431 #HANGUL SYLLABLE RIEUL YEO PIEUPSIOS
  {0x8EC2, 0xB83A}, //2432 #HANGUL SYLLABLE RIEUL YEO CIEUC
  {0x8EC3, 0xB83B}, //2433 #HANGUL SYLLABLE RIEUL YEO CHIEUCH
  {0x8EC4, 0xB83C}, //2434 #HANGUL SYLLABLE RIEUL YEO KHIEUKH
  {0x8EC5, 0xB83D}, //2435 #HANGUL SYLLABLE RIEUL YEO THIEUTH
  {0x8EC6, 0xB83E}, //2436 #HANGUL SYLLABLE RIEUL YEO PHIEUPH
  {0x8EC7, 0xB83F}, //2437 #HANGUL SYLLABLE RIEUL YEO HIEUH
  {0x8EC8, 0xB841}, //2438 #HANGUL SYLLABLE RIEUL YE KIYEOK
  {0x8EC9, 0xB842}, //2439 #HANGUL SYLLABLE RIEUL YE SSANGKIYEOK
  {0x8ECA, 0xB843}, //2440 #HANGUL SYLLABLE RIEUL YE KIYEOKSIOS
  {0x8ECB, 0xB845}, //2441 #HANGUL SYLLABLE RIEUL YE NIEUNCIEUC
  {0x8ECC, 0xB846}, //2442 #HANGUL SYLLABLE RIEUL YE NIEUNHIEUH
  {0x8ECD, 0xB847}, //2443 #HANGUL SYLLABLE RIEUL YE TIKEUT
  {0x8ECE, 0xB848}, //2444 #HANGUL SYLLABLE RIEUL YE RIEUL
  {0x8ECF, 0xB849}, //2445 #HANGUL SYLLABLE RIEUL YE RIEULKIYEOK
  {0x8ED0, 0xB84A}, //2446 #HANGUL SYLLABLE RIEUL YE RIEULMIEUM
  {0x8ED1, 0xB84B}, //2447 #HANGUL SYLLABLE RIEUL YE RIEULPIEUP
  {0x8ED2, 0xB84C}, //2448 #HANGUL SYLLABLE RIEUL YE RIEULSIOS
  {0x8ED3, 0xB84D}, //2449 #HANGUL SYLLABLE RIEUL YE RIEULTHIEUTH
  {0x8ED4, 0xB84E}, //2450 #HANGUL SYLLABLE RIEUL YE RIEULPHIEUPH
  {0x8ED5, 0xB84F}, //2451 #HANGUL SYLLABLE RIEUL YE RIEULHIEUH
  {0x8ED6, 0xB850}, //2452 #HANGUL SYLLABLE RIEUL YE MIEUM
  {0x8ED7, 0xB852}, //2453 #HANGUL SYLLABLE RIEUL YE PIEUPSIOS
  {0x8ED8, 0xB854}, //2454 #HANGUL SYLLABLE RIEUL YE SSANGSIOS
  {0x8ED9, 0xB855}, //2455 #HANGUL SYLLABLE RIEUL YE IEUNG
  {0x8EDA, 0xB856}, //2456 #HANGUL SYLLABLE RIEUL YE CIEUC
  {0x8EDB, 0xB857}, //2457 #HANGUL SYLLABLE RIEUL YE CHIEUCH
  {0x8EDC, 0xB858}, //2458 #HANGUL SYLLABLE RIEUL YE KHIEUKH
  {0x8EDD, 0xB859}, //2459 #HANGUL SYLLABLE RIEUL YE THIEUTH
  {0x8EDE, 0xB85A}, //2460 #HANGUL SYLLABLE RIEUL YE PHIEUPH
  {0x8EDF, 0xB85B}, //2461 #HANGUL SYLLABLE RIEUL YE HIEUH
  {0x8EE0, 0xB85E}, //2462 #HANGUL SYLLABLE RIEUL O SSANGKIYEOK
  {0x8EE1, 0xB85F}, //2463 #HANGUL SYLLABLE RIEUL O KIYEOKSIOS
  {0x8EE2, 0xB861}, //2464 #HANGUL SYLLABLE RIEUL O NIEUNCIEUC
  {0x8EE3, 0xB862}, //2465 #HANGUL SYLLABLE RIEUL O NIEUNHIEUH
  {0x8EE4, 0xB863}, //2466 #HANGUL SYLLABLE RIEUL O TIKEUT
  {0x8EE5, 0xB865}, //2467 #HANGUL SYLLABLE RIEUL O RIEULKIYEOK
  {0x8EE6, 0xB866}, //2468 #HANGUL SYLLABLE RIEUL O RIEULMIEUM
  {0x8EE7, 0xB867}, //2469 #HANGUL SYLLABLE RIEUL O RIEULPIEUP
  {0x8EE8, 0xB868}, //2470 #HANGUL SYLLABLE RIEUL O RIEULSIOS
  {0x8EE9, 0xB869}, //2471 #HANGUL SYLLABLE RIEUL O RIEULTHIEUTH
  {0x8EEA, 0xB86A}, //2472 #HANGUL SYLLABLE RIEUL O RIEULPHIEUPH
  {0x8EEB, 0xB86B}, //2473 #HANGUL SYLLABLE RIEUL O RIEULHIEUH
  {0x8EEC, 0xB86E}, //2474 #HANGUL SYLLABLE RIEUL O PIEUPSIOS
  {0x8EED, 0xB870}, //2475 #HANGUL SYLLABLE RIEUL O SSANGSIOS
  {0x8EEE, 0xB872}, //2476 #HANGUL SYLLABLE RIEUL O CIEUC
  {0x8EEF, 0xB873}, //2477 #HANGUL SYLLABLE RIEUL O CHIEUCH
  {0x8EF0, 0xB874}, //2478 #HANGUL SYLLABLE RIEUL O KHIEUKH
  {0x8EF1, 0xB875}, //2479 #HANGUL SYLLABLE RIEUL O THIEUTH
  {0x8EF2, 0xB876}, //2480 #HANGUL SYLLABLE RIEUL O PHIEUPH
  {0x8EF3, 0xB877}, //2481 #HANGUL SYLLABLE RIEUL O HIEUH
  {0x8EF4, 0xB879}, //2482 #HANGUL SYLLABLE RIEUL WA KIYEOK
  {0x8EF5, 0xB87A}, //2483 #HANGUL SYLLABLE RIEUL WA SSANGKIYEOK
  {0x8EF6, 0xB87B}, //2484 #HANGUL SYLLABLE RIEUL WA KIYEOKSIOS
  {0x8EF7, 0xB87D}, //2485 #HANGUL SYLLABLE RIEUL WA NIEUNCIEUC
  {0x8EF8, 0xB87E}, //2486 #HANGUL SYLLABLE RIEUL WA NIEUNHIEUH
  {0x8EF9, 0xB87F}, //2487 #HANGUL SYLLABLE RIEUL WA TIKEUT
  {0x8EFA, 0xB880}, //2488 #HANGUL SYLLABLE RIEUL WA RIEUL
  {0x8EFB, 0xB881}, //2489 #HANGUL SYLLABLE RIEUL WA RIEULKIYEOK
  {0x8EFC, 0xB882}, //2490 #HANGUL SYLLABLE RIEUL WA RIEULMIEUM
  {0x8EFD, 0xB883}, //2491 #HANGUL SYLLABLE RIEUL WA RIEULPIEUP
  {0x8EFE, 0xB884}, //2492 #HANGUL SYLLABLE RIEUL WA RIEULSIOS
  {0x8F41, 0xB885}, //2493 #HANGUL SYLLABLE RIEUL WA RIEULTHIEUTH
  {0x8F42, 0xB886}, //2494 #HANGUL SYLLABLE RIEUL WA RIEULPHIEUPH
  {0x8F43, 0xB887}, //2495 #HANGUL SYLLABLE RIEUL WA RIEULHIEUH
  {0x8F44, 0xB888}, //2496 #HANGUL SYLLABLE RIEUL WA MIEUM
  {0x8F45, 0xB889}, //2497 #HANGUL SYLLABLE RIEUL WA PIEUP
  {0x8F46, 0xB88A}, //2498 #HANGUL SYLLABLE RIEUL WA PIEUPSIOS
  {0x8F47, 0xB88B}, //2499 #HANGUL SYLLABLE RIEUL WA SIOS
  {0x8F48, 0xB88C}, //2500 #HANGUL SYLLABLE RIEUL WA SSANGSIOS
  {0x8F49, 0xB88E}, //2501 #HANGUL SYLLABLE RIEUL WA CIEUC
  {0x8F4A, 0xB88F}, //2502 #HANGUL SYLLABLE RIEUL WA CHIEUCH
  {0x8F4B, 0xB890}, //2503 #HANGUL SYLLABLE RIEUL WA KHIEUKH
  {0x8F4C, 0xB891}, //2504 #HANGUL SYLLABLE RIEUL WA THIEUTH
  {0x8F4D, 0xB892}, //2505 #HANGUL SYLLABLE RIEUL WA PHIEUPH
  {0x8F4E, 0xB893}, //2506 #HANGUL SYLLABLE RIEUL WA HIEUH
  {0x8F4F, 0xB894}, //2507 #HANGUL SYLLABLE RIEUL WAE
  {0x8F50, 0xB895}, //2508 #HANGUL SYLLABLE RIEUL WAE KIYEOK
  {0x8F51, 0xB896}, //2509 #HANGUL SYLLABLE RIEUL WAE SSANGKIYEOK
  {0x8F52, 0xB897}, //2510 #HANGUL SYLLABLE RIEUL WAE KIYEOKSIOS
  {0x8F53, 0xB898}, //2511 #HANGUL SYLLABLE RIEUL WAE NIEUN
  {0x8F54, 0xB899}, //2512 #HANGUL SYLLABLE RIEUL WAE NIEUNCIEUC
  {0x8F55, 0xB89A}, //2513 #HANGUL SYLLABLE RIEUL WAE NIEUNHIEUH
  {0x8F56, 0xB89B}, //2514 #HANGUL SYLLABLE RIEUL WAE TIKEUT
  {0x8F57, 0xB89C}, //2515 #HANGUL SYLLABLE RIEUL WAE RIEUL
  {0x8F58, 0xB89D}, //2516 #HANGUL SYLLABLE RIEUL WAE RIEULKIYEOK
  {0x8F59, 0xB89E}, //2517 #HANGUL SYLLABLE RIEUL WAE RIEULMIEUM
  {0x8F5A, 0xB89F}, //2518 #HANGUL SYLLABLE RIEUL WAE RIEULPIEUP
  {0x8F61, 0xB8A0}, //2519 #HANGUL SYLLABLE RIEUL WAE RIEULSIOS
  {0x8F62, 0xB8A1}, //2520 #HANGUL SYLLABLE RIEUL WAE RIEULTHIEUTH
  {0x8F63, 0xB8A2}, //2521 #HANGUL SYLLABLE RIEUL WAE RIEULPHIEUPH
  {0x8F64, 0xB8A3}, //2522 #HANGUL SYLLABLE RIEUL WAE RIEULHIEUH
  {0x8F65, 0xB8A4}, //2523 #HANGUL SYLLABLE RIEUL WAE MIEUM
  {0x8F66, 0xB8A5}, //2524 #HANGUL SYLLABLE RIEUL WAE PIEUP
  {0x8F67, 0xB8A6}, //2525 #HANGUL SYLLABLE RIEUL WAE PIEUPSIOS
  {0x8F68, 0xB8A7}, //2526 #HANGUL SYLLABLE RIEUL WAE SIOS
  {0x8F69, 0xB8A9}, //2527 #HANGUL SYLLABLE RIEUL WAE IEUNG
  {0x8F6A, 0xB8AA}, //2528 #HANGUL SYLLABLE RIEUL WAE CIEUC
  {0x8F6B, 0xB8AB}, //2529 #HANGUL SYLLABLE RIEUL WAE CHIEUCH
  {0x8F6C, 0xB8AC}, //2530 #HANGUL SYLLABLE RIEUL WAE KHIEUKH
  {0x8F6D, 0xB8AD}, //2531 #HANGUL SYLLABLE RIEUL WAE THIEUTH
  {0x8F6E, 0xB8AE}, //2532 #HANGUL SYLLABLE RIEUL WAE PHIEUPH
  {0x8F6F, 0xB8AF}, //2533 #HANGUL SYLLABLE RIEUL WAE HIEUH
  {0x8F70, 0xB8B1}, //2534 #HANGUL SYLLABLE RIEUL OE KIYEOK
  {0x8F71, 0xB8B2}, //2535 #HANGUL SYLLABLE RIEUL OE SSANGKIYEOK
  {0x8F72, 0xB8B3}, //2536 #HANGUL SYLLABLE RIEUL OE KIYEOKSIOS
  {0x8F73, 0xB8B5}, //2537 #HANGUL SYLLABLE RIEUL OE NIEUNCIEUC
  {0x8F74, 0xB8B6}, //2538 #HANGUL SYLLABLE RIEUL OE NIEUNHIEUH
  {0x8F75, 0xB8B7}, //2539 #HANGUL SYLLABLE RIEUL OE TIKEUT
  {0x8F76, 0xB8B9}, //2540 #HANGUL SYLLABLE RIEUL OE RIEULKIYEOK
  {0x8F77, 0xB8BA}, //2541 #HANGUL SYLLABLE RIEUL OE RIEULMIEUM
  {0x8F78, 0xB8BB}, //2542 #HANGUL SYLLABLE RIEUL OE RIEULPIEUP
  {0x8F79, 0xB8BC}, //2543 #HANGUL SYLLABLE RIEUL OE RIEULSIOS
  {0x8F7A, 0xB8BD}, //2544 #HANGUL SYLLABLE RIEUL OE RIEULTHIEUTH
  {0x8F81, 0xB8BE}, //2545 #HANGUL SYLLABLE RIEUL OE RIEULPHIEUPH
  {0x8F82, 0xB8BF}, //2546 #HANGUL SYLLABLE RIEUL OE RIEULHIEUH
  {0x8F83, 0xB8C2}, //2547 #HANGUL SYLLABLE RIEUL OE PIEUPSIOS
  {0x8F84, 0xB8C4}, //2548 #HANGUL SYLLABLE RIEUL OE SSANGSIOS
  {0x8F85, 0xB8C6}, //2549 #HANGUL SYLLABLE RIEUL OE CIEUC
  {0x8F86, 0xB8C7}, //2550 #HANGUL SYLLABLE RIEUL OE CHIEUCH
  {0x8F87, 0xB8C8}, //2551 #HANGUL SYLLABLE RIEUL OE KHIEUKH
  {0x8F88, 0xB8C9}, //2552 #HANGUL SYLLABLE RIEUL OE THIEUTH
  {0x8F89, 0xB8CA}, //2553 #HANGUL SYLLABLE RIEUL OE PHIEUPH
  {0x8F8A, 0xB8CB}, //2554 #HANGUL SYLLABLE RIEUL OE HIEUH
  {0x8F8B, 0xB8CD}, //2555 #HANGUL SYLLABLE RIEUL YO KIYEOK
  {0x8F8C, 0xB8CE}, //2556 #HANGUL SYLLABLE RIEUL YO SSANGKIYEOK
  {0x8F8D, 0xB8CF}, //2557 #HANGUL SYLLABLE RIEUL YO KIYEOKSIOS
  {0x8F8E, 0xB8D1}, //2558 #HANGUL SYLLABLE RIEUL YO NIEUNCIEUC
  {0x8F8F, 0xB8D2}, //2559 #HANGUL SYLLABLE RIEUL YO NIEUNHIEUH
  {0x8F90, 0xB8D3}, //2560 #HANGUL SYLLABLE RIEUL YO TIKEUT
  {0x8F91, 0xB8D5}, //2561 #HANGUL SYLLABLE RIEUL YO RIEULKIYEOK
  {0x8F92, 0xB8D6}, //2562 #HANGUL SYLLABLE RIEUL YO RIEULMIEUM
  {0x8F93, 0xB8D7}, //2563 #HANGUL SYLLABLE RIEUL YO RIEULPIEUP
  {0x8F94, 0xB8D8}, //2564 #HANGUL SYLLABLE RIEUL YO RIEULSIOS
  {0x8F95, 0xB8D9}, //2565 #HANGUL SYLLABLE RIEUL YO RIEULTHIEUTH
  {0x8F96, 0xB8DA}, //2566 #HANGUL SYLLABLE RIEUL YO RIEULPHIEUPH
  {0x8F97, 0xB8DB}, //2567 #HANGUL SYLLABLE RIEUL YO RIEULHIEUH
  {0x8F98, 0xB8DC}, //2568 #HANGUL SYLLABLE RIEUL YO MIEUM
  {0x8F99, 0xB8DE}, //2569 #HANGUL SYLLABLE RIEUL YO PIEUPSIOS
  {0x8F9A, 0xB8E0}, //2570 #HANGUL SYLLABLE RIEUL YO SSANGSIOS
  {0x8F9B, 0xB8E2}, //2571 #HANGUL SYLLABLE RIEUL YO CIEUC
  {0x8F9C, 0xB8E3}, //2572 #HANGUL SYLLABLE RIEUL YO CHIEUCH
  {0x8F9D, 0xB8E4}, //2573 #HANGUL SYLLABLE RIEUL YO KHIEUKH
  {0x8F9E, 0xB8E5}, //2574 #HANGUL SYLLABLE RIEUL YO THIEUTH
  {0x8F9F, 0xB8E6}, //2575 #HANGUL SYLLABLE RIEUL YO PHIEUPH
  {0x8FA0, 0xB8E7}, //2576 #HANGUL SYLLABLE RIEUL YO HIEUH
  {0x8FA1, 0xB8EA}, //2577 #HANGUL SYLLABLE RIEUL U SSANGKIYEOK
  {0x8FA2, 0xB8EB}, //2578 #HANGUL SYLLABLE RIEUL U KIYEOKSIOS
  {0x8FA3, 0xB8ED}, //2579 #HANGUL SYLLABLE RIEUL U NIEUNCIEUC
  {0x8FA4, 0xB8EE}, //2580 #HANGUL SYLLABLE RIEUL U NIEUNHIEUH
  {0x8FA5, 0xB8EF}, //2581 #HANGUL SYLLABLE RIEUL U TIKEUT
  {0x8FA6, 0xB8F1}, //2582 #HANGUL SYLLABLE RIEUL U RIEULKIYEOK
  {0x8FA7, 0xB8F2}, //2583 #HANGUL SYLLABLE RIEUL U RIEULMIEUM
  {0x8FA8, 0xB8F3}, //2584 #HANGUL SYLLABLE RIEUL U RIEULPIEUP
  {0x8FA9, 0xB8F4}, //2585 #HANGUL SYLLABLE RIEUL U RIEULSIOS
  {0x8FAA, 0xB8F5}, //2586 #HANGUL SYLLABLE RIEUL U RIEULTHIEUTH
  {0x8FAB, 0xB8F6}, //2587 #HANGUL SYLLABLE RIEUL U RIEULPHIEUPH
  {0x8FAC, 0xB8F7}, //2588 #HANGUL SYLLABLE RIEUL U RIEULHIEUH
  {0x8FAD, 0xB8FA}, //2589 #HANGUL SYLLABLE RIEUL U PIEUPSIOS
  {0x8FAE, 0xB8FC}, //2590 #HANGUL SYLLABLE RIEUL U SSANGSIOS
  {0x8FAF, 0xB8FE}, //2591 #HANGUL SYLLABLE RIEUL U CIEUC
  {0x8FB0, 0xB8FF}, //2592 #HANGUL SYLLABLE RIEUL U CHIEUCH
  {0x8FB1, 0xB900}, //2593 #HANGUL SYLLABLE RIEUL U KHIEUKH
  {0x8FB2, 0xB901}, //2594 #HANGUL SYLLABLE RIEUL U THIEUTH
  {0x8FB3, 0xB902}, //2595 #HANGUL SYLLABLE RIEUL U PHIEUPH
  {0x8FB4, 0xB903}, //2596 #HANGUL SYLLABLE RIEUL U HIEUH
  {0x8FB5, 0xB905}, //2597 #HANGUL SYLLABLE RIEUL WEO KIYEOK
  {0x8FB6, 0xB906}, //2598 #HANGUL SYLLABLE RIEUL WEO SSANGKIYEOK
  {0x8FB7, 0xB907}, //2599 #HANGUL SYLLABLE RIEUL WEO KIYEOKSIOS
  {0x8FB8, 0xB908}, //2600 #HANGUL SYLLABLE RIEUL WEO NIEUN
  {0x8FB9, 0xB909}, //2601 #HANGUL SYLLABLE RIEUL WEO NIEUNCIEUC
  {0x8FBA, 0xB90A}, //2602 #HANGUL SYLLABLE RIEUL WEO NIEUNHIEUH
  {0x8FBB, 0xB90B}, //2603 #HANGUL SYLLABLE RIEUL WEO TIKEUT
  {0x8FBC, 0xB90C}, //2604 #HANGUL SYLLABLE RIEUL WEO RIEUL
  {0x8FBD, 0xB90D}, //2605 #HANGUL SYLLABLE RIEUL WEO RIEULKIYEOK
  {0x8FBE, 0xB90E}, //2606 #HANGUL SYLLABLE RIEUL WEO RIEULMIEUM
  {0x8FBF, 0xB90F}, //2607 #HANGUL SYLLABLE RIEUL WEO RIEULPIEUP
  {0x8FC0, 0xB910}, //2608 #HANGUL SYLLABLE RIEUL WEO RIEULSIOS
  {0x8FC1, 0xB911}, //2609 #HANGUL SYLLABLE RIEUL WEO RIEULTHIEUTH
  {0x8FC2, 0xB912}, //2610 #HANGUL SYLLABLE RIEUL WEO RIEULPHIEUPH
  {0x8FC3, 0xB913}, //2611 #HANGUL SYLLABLE RIEUL WEO RIEULHIEUH
  {0x8FC4, 0xB914}, //2612 #HANGUL SYLLABLE RIEUL WEO MIEUM
  {0x8FC5, 0xB915}, //2613 #HANGUL SYLLABLE RIEUL WEO PIEUP
  {0x8FC6, 0xB916}, //2614 #HANGUL SYLLABLE RIEUL WEO PIEUPSIOS
  {0x8FC7, 0xB917}, //2615 #HANGUL SYLLABLE RIEUL WEO SIOS
  {0x8FC8, 0xB919}, //2616 #HANGUL SYLLABLE RIEUL WEO IEUNG
  {0x8FC9, 0xB91A}, //2617 #HANGUL SYLLABLE RIEUL WEO CIEUC
  {0x8FCA, 0xB91B}, //2618 #HANGUL SYLLABLE RIEUL WEO CHIEUCH
  {0x8FCB, 0xB91C}, //2619 #HANGUL SYLLABLE RIEUL WEO KHIEUKH
  {0x8FCC, 0xB91D}, //2620 #HANGUL SYLLABLE RIEUL WEO THIEUTH
  {0x8FCD, 0xB91E}, //2621 #HANGUL SYLLABLE RIEUL WEO PHIEUPH
  {0x8FCE, 0xB91F}, //2622 #HANGUL SYLLABLE RIEUL WEO HIEUH
  {0x8FCF, 0xB921}, //2623 #HANGUL SYLLABLE RIEUL WE KIYEOK
  {0x8FD0, 0xB922}, //2624 #HANGUL SYLLABLE RIEUL WE SSANGKIYEOK
  {0x8FD1, 0xB923}, //2625 #HANGUL SYLLABLE RIEUL WE KIYEOKSIOS
  {0x8FD2, 0xB924}, //2626 #HANGUL SYLLABLE RIEUL WE NIEUN
  {0x8FD3, 0xB925}, //2627 #HANGUL SYLLABLE RIEUL WE NIEUNCIEUC
  {0x8FD4, 0xB926}, //2628 #HANGUL SYLLABLE RIEUL WE NIEUNHIEUH
  {0x8FD5, 0xB927}, //2629 #HANGUL SYLLABLE RIEUL WE TIKEUT
  {0x8FD6, 0xB928}, //2630 #HANGUL SYLLABLE RIEUL WE RIEUL
  {0x8FD7, 0xB929}, //2631 #HANGUL SYLLABLE RIEUL WE RIEULKIYEOK
  {0x8FD8, 0xB92A}, //2632 #HANGUL SYLLABLE RIEUL WE RIEULMIEUM
  {0x8FD9, 0xB92B}, //2633 #HANGUL SYLLABLE RIEUL WE RIEULPIEUP
  {0x8FDA, 0xB92C}, //2634 #HANGUL SYLLABLE RIEUL WE RIEULSIOS
  {0x8FDB, 0xB92D}, //2635 #HANGUL SYLLABLE RIEUL WE RIEULTHIEUTH
  {0x8FDC, 0xB92E}, //2636 #HANGUL SYLLABLE RIEUL WE RIEULPHIEUPH
  {0x8FDD, 0xB92F}, //2637 #HANGUL SYLLABLE RIEUL WE RIEULHIEUH
  {0x8FDE, 0xB930}, //2638 #HANGUL SYLLABLE RIEUL WE MIEUM
  {0x8FDF, 0xB931}, //2639 #HANGUL SYLLABLE RIEUL WE PIEUP
  {0x8FE0, 0xB932}, //2640 #HANGUL SYLLABLE RIEUL WE PIEUPSIOS
  {0x8FE1, 0xB933}, //2641 #HANGUL SYLLABLE RIEUL WE SIOS
  {0x8FE2, 0xB934}, //2642 #HANGUL SYLLABLE RIEUL WE SSANGSIOS
  {0x8FE3, 0xB935}, //2643 #HANGUL SYLLABLE RIEUL WE IEUNG
  {0x8FE4, 0xB936}, //2644 #HANGUL SYLLABLE RIEUL WE CIEUC
  {0x8FE5, 0xB937}, //2645 #HANGUL SYLLABLE RIEUL WE CHIEUCH
  {0x8FE6, 0xB938}, //2646 #HANGUL SYLLABLE RIEUL WE KHIEUKH
  {0x8FE7, 0xB939}, //2647 #HANGUL SYLLABLE RIEUL WE THIEUTH
  {0x8FE8, 0xB93A}, //2648 #HANGUL SYLLABLE RIEUL WE PHIEUPH
  {0x8FE9, 0xB93B}, //2649 #HANGUL SYLLABLE RIEUL WE HIEUH
  {0x8FEA, 0xB93E}, //2650 #HANGUL SYLLABLE RIEUL WI SSANGKIYEOK
  {0x8FEB, 0xB93F}, //2651 #HANGUL SYLLABLE RIEUL WI KIYEOKSIOS
  {0x8FEC, 0xB941}, //2652 #HANGUL SYLLABLE RIEUL WI NIEUNCIEUC
  {0x8FED, 0xB942}, //2653 #HANGUL SYLLABLE RIEUL WI NIEUNHIEUH
  {0x8FEE, 0xB943}, //2654 #HANGUL SYLLABLE RIEUL WI TIKEUT
  {0x8FEF, 0xB945}, //2655 #HANGUL SYLLABLE RIEUL WI RIEULKIYEOK
  {0x8FF0, 0xB946}, //2656 #HANGUL SYLLABLE RIEUL WI RIEULMIEUM
  {0x8FF1, 0xB947}, //2657 #HANGUL SYLLABLE RIEUL WI RIEULPIEUP
  {0x8FF2, 0xB948}, //2658 #HANGUL SYLLABLE RIEUL WI RIEULSIOS
  {0x8FF3, 0xB949}, //2659 #HANGUL SYLLABLE RIEUL WI RIEULTHIEUTH
  {0x8FF4, 0xB94A}, //2660 #HANGUL SYLLABLE RIEUL WI RIEULPHIEUPH
  {0x8FF5, 0xB94B}, //2661 #HANGUL SYLLABLE RIEUL WI RIEULHIEUH
  {0x8FF6, 0xB94D}, //2662 #HANGUL SYLLABLE RIEUL WI PIEUP
  {0x8FF7, 0xB94E}, //2663 #HANGUL SYLLABLE RIEUL WI PIEUPSIOS
  {0x8FF8, 0xB950}, //2664 #HANGUL SYLLABLE RIEUL WI SSANGSIOS
  {0x8FF9, 0xB952}, //2665 #HANGUL SYLLABLE RIEUL WI CIEUC
  {0x8FFA, 0xB953}, //2666 #HANGUL SYLLABLE RIEUL WI CHIEUCH
  {0x8FFB, 0xB954}, //2667 #HANGUL SYLLABLE RIEUL WI KHIEUKH
  {0x8FFC, 0xB955}, //2668 #HANGUL SYLLABLE RIEUL WI THIEUTH
  {0x8FFD, 0xB956}, //2669 #HANGUL SYLLABLE RIEUL WI PHIEUPH
  {0x8FFE, 0xB957}, //2670 #HANGUL SYLLABLE RIEUL WI HIEUH
  {0x9041, 0xB95A}, //2671 #HANGUL SYLLABLE RIEUL YU SSANGKIYEOK
  {0x9042, 0xB95B}, //2672 #HANGUL SYLLABLE RIEUL YU KIYEOKSIOS
  {0x9043, 0xB95D}, //2673 #HANGUL SYLLABLE RIEUL YU NIEUNCIEUC
  {0x9044, 0xB95E}, //2674 #HANGUL SYLLABLE RIEUL YU NIEUNHIEUH
  {0x9045, 0xB95F}, //2675 #HANGUL SYLLABLE RIEUL YU TIKEUT
  {0x9046, 0xB961}, //2676 #HANGUL SYLLABLE RIEUL YU RIEULKIYEOK
  {0x9047, 0xB962}, //2677 #HANGUL SYLLABLE RIEUL YU RIEULMIEUM
  {0x9048, 0xB963}, //2678 #HANGUL SYLLABLE RIEUL YU RIEULPIEUP
  {0x9049, 0xB964}, //2679 #HANGUL SYLLABLE RIEUL YU RIEULSIOS
  {0x904A, 0xB965}, //2680 #HANGUL SYLLABLE RIEUL YU RIEULTHIEUTH
  {0x904B, 0xB966}, //2681 #HANGUL SYLLABLE RIEUL YU RIEULPHIEUPH
  {0x904C, 0xB967}, //2682 #HANGUL SYLLABLE RIEUL YU RIEULHIEUH
  {0x904D, 0xB96A}, //2683 #HANGUL SYLLABLE RIEUL YU PIEUPSIOS
  {0x904E, 0xB96C}, //2684 #HANGUL SYLLABLE RIEUL YU SSANGSIOS
  {0x904F, 0xB96E}, //2685 #HANGUL SYLLABLE RIEUL YU CIEUC
  {0x9050, 0xB96F}, //2686 #HANGUL SYLLABLE RIEUL YU CHIEUCH
  {0x9051, 0xB970}, //2687 #HANGUL SYLLABLE RIEUL YU KHIEUKH
  {0x9052, 0xB971}, //2688 #HANGUL SYLLABLE RIEUL YU THIEUTH
  {0x9053, 0xB972}, //2689 #HANGUL SYLLABLE RIEUL YU PHIEUPH
  {0x9054, 0xB973}, //2690 #HANGUL SYLLABLE RIEUL YU HIEUH
  {0x9055, 0xB976}, //2691 #HANGUL SYLLABLE RIEUL EU SSANGKIYEOK
  {0x9056, 0xB977}, //2692 #HANGUL SYLLABLE RIEUL EU KIYEOKSIOS
  {0x9057, 0xB979}, //2693 #HANGUL SYLLABLE RIEUL EU NIEUNCIEUC
  {0x9058, 0xB97A}, //2694 #HANGUL SYLLABLE RIEUL EU NIEUNHIEUH
  {0x9059, 0xB97B}, //2695 #HANGUL SYLLABLE RIEUL EU TIKEUT
  {0x905A, 0xB97D}, //2696 #HANGUL SYLLABLE RIEUL EU RIEULKIYEOK
  {0x9061, 0xB97E}, //2697 #HANGUL SYLLABLE RIEUL EU RIEULMIEUM
  {0x9062, 0xB97F}, //2698 #HANGUL SYLLABLE RIEUL EU RIEULPIEUP
  {0x9063, 0xB980}, //2699 #HANGUL SYLLABLE RIEUL EU RIEULSIOS
  {0x9064, 0xB981}, //2700 #HANGUL SYLLABLE RIEUL EU RIEULTHIEUTH
  {0x9065, 0xB982}, //2701 #HANGUL SYLLABLE RIEUL EU RIEULPHIEUPH
  {0x9066, 0xB983}, //2702 #HANGUL SYLLABLE RIEUL EU RIEULHIEUH
  {0x9067, 0xB986}, //2703 #HANGUL SYLLABLE RIEUL EU PIEUPSIOS
  {0x9068, 0xB988}, //2704 #HANGUL SYLLABLE RIEUL EU SSANGSIOS
  {0x9069, 0xB98B}, //2705 #HANGUL SYLLABLE RIEUL EU CHIEUCH
  {0x906A, 0xB98C}, //2706 #HANGUL SYLLABLE RIEUL EU KHIEUKH
  {0x906B, 0xB98F}, //2707 #HANGUL SYLLABLE RIEUL EU HIEUH
  {0x906C, 0xB990}, //2708 #HANGUL SYLLABLE RIEUL YI
  {0x906D, 0xB991}, //2709 #HANGUL SYLLABLE RIEUL YI KIYEOK
  {0x906E, 0xB992}, //2710 #HANGUL SYLLABLE RIEUL YI SSANGKIYEOK
  {0x906F, 0xB993}, //2711 #HANGUL SYLLABLE RIEUL YI KIYEOKSIOS
  {0x9070, 0xB994}, //2712 #HANGUL SYLLABLE RIEUL YI NIEUN
  {0x9071, 0xB995}, //2713 #HANGUL SYLLABLE RIEUL YI NIEUNCIEUC
  {0x9072, 0xB996}, //2714 #HANGUL SYLLABLE RIEUL YI NIEUNHIEUH
  {0x9073, 0xB997}, //2715 #HANGUL SYLLABLE RIEUL YI TIKEUT
  {0x9074, 0xB998}, //2716 #HANGUL SYLLABLE RIEUL YI RIEUL
  {0x9075, 0xB999}, //2717 #HANGUL SYLLABLE RIEUL YI RIEULKIYEOK
  {0x9076, 0xB99A}, //2718 #HANGUL SYLLABLE RIEUL YI RIEULMIEUM
  {0x9077, 0xB99B}, //2719 #HANGUL SYLLABLE RIEUL YI RIEULPIEUP
  {0x9078, 0xB99C}, //2720 #HANGUL SYLLABLE RIEUL YI RIEULSIOS
  {0x9079, 0xB99D}, //2721 #HANGUL SYLLABLE RIEUL YI RIEULTHIEUTH
  {0x907A, 0xB99E}, //2722 #HANGUL SYLLABLE RIEUL YI RIEULPHIEUPH
  {0x9081, 0xB99F}, //2723 #HANGUL SYLLABLE RIEUL YI RIEULHIEUH
  {0x9082, 0xB9A0}, //2724 #HANGUL SYLLABLE RIEUL YI MIEUM
  {0x9083, 0xB9A1}, //2725 #HANGUL SYLLABLE RIEUL YI PIEUP
  {0x9084, 0xB9A2}, //2726 #HANGUL SYLLABLE RIEUL YI PIEUPSIOS
  {0x9085, 0xB9A3}, //2727 #HANGUL SYLLABLE RIEUL YI SIOS
  {0x9086, 0xB9A4}, //2728 #HANGUL SYLLABLE RIEUL YI SSANGSIOS
  {0x9087, 0xB9A5}, //2729 #HANGUL SYLLABLE RIEUL YI IEUNG
  {0x9088, 0xB9A6}, //2730 #HANGUL SYLLABLE RIEUL YI CIEUC
  {0x9089, 0xB9A7}, //2731 #HANGUL SYLLABLE RIEUL YI CHIEUCH
  {0x908A, 0xB9A8}, //2732 #HANGUL SYLLABLE RIEUL YI KHIEUKH
  {0x908B, 0xB9A9}, //2733 #HANGUL SYLLABLE RIEUL YI THIEUTH
  {0x908C, 0xB9AA}, //2734 #HANGUL SYLLABLE RIEUL YI PHIEUPH
  {0x908D, 0xB9AB}, //2735 #HANGUL SYLLABLE RIEUL YI HIEUH
  {0x908E, 0xB9AE}, //2736 #HANGUL SYLLABLE RIEUL I SSANGKIYEOK
  {0x908F, 0xB9AF}, //2737 #HANGUL SYLLABLE RIEUL I KIYEOKSIOS
  {0x9090, 0xB9B1}, //2738 #HANGUL SYLLABLE RIEUL I NIEUNCIEUC
  {0x9091, 0xB9B2}, //2739 #HANGUL SYLLABLE RIEUL I NIEUNHIEUH
  {0x9092, 0xB9B3}, //2740 #HANGUL SYLLABLE RIEUL I TIKEUT
  {0x9093, 0xB9B5}, //2741 #HANGUL SYLLABLE RIEUL I RIEULKIYEOK
  {0x9094, 0xB9B6}, //2742 #HANGUL SYLLABLE RIEUL I RIEULMIEUM
  {0x9095, 0xB9B7}, //2743 #HANGUL SYLLABLE RIEUL I RIEULPIEUP
  {0x9096, 0xB9B8}, //2744 #HANGUL SYLLABLE RIEUL I RIEULSIOS
  {0x9097, 0xB9B9}, //2745 #HANGUL SYLLABLE RIEUL I RIEULTHIEUTH
  {0x9098, 0xB9BA}, //2746 #HANGUL SYLLABLE RIEUL I RIEULPHIEUPH
  {0x9099, 0xB9BB}, //2747 #HANGUL SYLLABLE RIEUL I RIEULHIEUH
  {0x909A, 0xB9BE}, //2748 #HANGUL SYLLABLE RIEUL I PIEUPSIOS
  {0x909B, 0xB9C0}, //2749 #HANGUL SYLLABLE RIEUL I SSANGSIOS
  {0x909C, 0xB9C2}, //2750 #HANGUL SYLLABLE RIEUL I CIEUC
  {0x909D, 0xB9C3}, //2751 #HANGUL SYLLABLE RIEUL I CHIEUCH
  {0x909E, 0xB9C4}, //2752 #HANGUL SYLLABLE RIEUL I KHIEUKH
  {0x909F, 0xB9C5}, //2753 #HANGUL SYLLABLE RIEUL I THIEUTH
  {0x90A0, 0xB9C6}, //2754 #HANGUL SYLLABLE RIEUL I PHIEUPH
  {0x90A1, 0xB9C7}, //2755 #HANGUL SYLLABLE RIEUL I HIEUH
  {0x90A2, 0xB9CA}, //2756 #HANGUL SYLLABLE MIEUM A SSANGKIYEOK
  {0x90A3, 0xB9CB}, //2757 #HANGUL SYLLABLE MIEUM A KIYEOKSIOS
  {0x90A4, 0xB9CD}, //2758 #HANGUL SYLLABLE MIEUM A NIEUNCIEUC
  {0x90A5, 0xB9D3}, //2759 #HANGUL SYLLABLE MIEUM A RIEULPIEUP
  {0x90A6, 0xB9D4}, //2760 #HANGUL SYLLABLE MIEUM A RIEULSIOS
  {0x90A7, 0xB9D5}, //2761 #HANGUL SYLLABLE MIEUM A RIEULTHIEUTH
  {0x90A8, 0xB9D6}, //2762 #HANGUL SYLLABLE MIEUM A RIEULPHIEUPH
  {0x90A9, 0xB9D7}, //2763 #HANGUL SYLLABLE MIEUM A RIEULHIEUH
  {0x90AA, 0xB9DA}, //2764 #HANGUL SYLLABLE MIEUM A PIEUPSIOS
  {0x90AB, 0xB9DC}, //2765 #HANGUL SYLLABLE MIEUM A SSANGSIOS
  {0x90AC, 0xB9DF}, //2766 #HANGUL SYLLABLE MIEUM A CHIEUCH
  {0x90AD, 0xB9E0}, //2767 #HANGUL SYLLABLE MIEUM A KHIEUKH
  {0x90AE, 0xB9E2}, //2768 #HANGUL SYLLABLE MIEUM A PHIEUPH
  {0x90AF, 0xB9E6}, //2769 #HANGUL SYLLABLE MIEUM AE SSANGKIYEOK
  {0x90B0, 0xB9E7}, //2770 #HANGUL SYLLABLE MIEUM AE KIYEOKSIOS
  {0x90B1, 0xB9E9}, //2771 #HANGUL SYLLABLE MIEUM AE NIEUNCIEUC
  {0x90B2, 0xB9EA}, //2772 #HANGUL SYLLABLE MIEUM AE NIEUNHIEUH
  {0x90B3, 0xB9EB}, //2773 #HANGUL SYLLABLE MIEUM AE TIKEUT
  {0x90B4, 0xB9ED}, //2774 #HANGUL SYLLABLE MIEUM AE RIEULKIYEOK
  {0x90B5, 0xB9EE}, //2775 #HANGUL SYLLABLE MIEUM AE RIEULMIEUM
  {0x90B6, 0xB9EF}, //2776 #HANGUL SYLLABLE MIEUM AE RIEULPIEUP
  {0x90B7, 0xB9F0}, //2777 #HANGUL SYLLABLE MIEUM AE RIEULSIOS
  {0x90B8, 0xB9F1}, //2778 #HANGUL SYLLABLE MIEUM AE RIEULTHIEUTH
  {0x90B9, 0xB9F2}, //2779 #HANGUL SYLLABLE MIEUM AE RIEULPHIEUPH
  {0x90BA, 0xB9F3}, //2780 #HANGUL SYLLABLE MIEUM AE RIEULHIEUH
  {0x90BB, 0xB9F6}, //2781 #HANGUL SYLLABLE MIEUM AE PIEUPSIOS
  {0x90BC, 0xB9FB}, //2782 #HANGUL SYLLABLE MIEUM AE CHIEUCH
  {0x90BD, 0xB9FC}, //2783 #HANGUL SYLLABLE MIEUM AE KHIEUKH
  {0x90BE, 0xB9FD}, //2784 #HANGUL SYLLABLE MIEUM AE THIEUTH
  {0x90BF, 0xB9FE}, //2785 #HANGUL SYLLABLE MIEUM AE PHIEUPH
  {0x90C0, 0xB9FF}, //2786 #HANGUL SYLLABLE MIEUM AE HIEUH
  {0x90C1, 0xBA02}, //2787 #HANGUL SYLLABLE MIEUM YA SSANGKIYEOK
  {0x90C2, 0xBA03}, //2788 #HANGUL SYLLABLE MIEUM YA KIYEOKSIOS
  {0x90C3, 0xBA04}, //2789 #HANGUL SYLLABLE MIEUM YA NIEUN
  {0x90C4, 0xBA05}, //2790 #HANGUL SYLLABLE MIEUM YA NIEUNCIEUC
  {0x90C5, 0xBA06}, //2791 #HANGUL SYLLABLE MIEUM YA NIEUNHIEUH
  {0x90C6, 0xBA07}, //2792 #HANGUL SYLLABLE MIEUM YA TIKEUT
  {0x90C7, 0xBA09}, //2793 #HANGUL SYLLABLE MIEUM YA RIEULKIYEOK
  {0x90C8, 0xBA0A}, //2794 #HANGUL SYLLABLE MIEUM YA RIEULMIEUM
  {0x90C9, 0xBA0B}, //2795 #HANGUL SYLLABLE MIEUM YA RIEULPIEUP
  {0x90CA, 0xBA0C}, //2796 #HANGUL SYLLABLE MIEUM YA RIEULSIOS
  {0x90CB, 0xBA0D}, //2797 #HANGUL SYLLABLE MIEUM YA RIEULTHIEUTH
  {0x90CC, 0xBA0E}, //2798 #HANGUL SYLLABLE MIEUM YA RIEULPHIEUPH
  {0x90CD, 0xBA0F}, //2799 #HANGUL SYLLABLE MIEUM YA RIEULHIEUH
  {0x90CE, 0xBA10}, //2800 #HANGUL SYLLABLE MIEUM YA MIEUM
  {0x90CF, 0xBA11}, //2801 #HANGUL SYLLABLE MIEUM YA PIEUP
  {0x90D0, 0xBA12}, //2802 #HANGUL SYLLABLE MIEUM YA PIEUPSIOS
  {0x90D1, 0xBA13}, //2803 #HANGUL SYLLABLE MIEUM YA SIOS
  {0x90D2, 0xBA14}, //2804 #HANGUL SYLLABLE MIEUM YA SSANGSIOS
  {0x90D3, 0xBA16}, //2805 #HANGUL SYLLABLE MIEUM YA CIEUC
  {0x90D4, 0xBA17}, //2806 #HANGUL SYLLABLE MIEUM YA CHIEUCH
  {0x90D5, 0xBA18}, //2807 #HANGUL SYLLABLE MIEUM YA KHIEUKH
  {0x90D6, 0xBA19}, //2808 #HANGUL SYLLABLE MIEUM YA THIEUTH
  {0x90D7, 0xBA1A}, //2809 #HANGUL SYLLABLE MIEUM YA PHIEUPH
  {0x90D8, 0xBA1B}, //2810 #HANGUL SYLLABLE MIEUM YA HIEUH
  {0x90D9, 0xBA1C}, //2811 #HANGUL SYLLABLE MIEUM YAE
  {0x90DA, 0xBA1D}, //2812 #HANGUL SYLLABLE MIEUM YAE KIYEOK
  {0x90DB, 0xBA1E}, //2813 #HANGUL SYLLABLE MIEUM YAE SSANGKIYEOK
  {0x90DC, 0xBA1F}, //2814 #HANGUL SYLLABLE MIEUM YAE KIYEOKSIOS
  {0x90DD, 0xBA20}, //2815 #HANGUL SYLLABLE MIEUM YAE NIEUN
  {0x90DE, 0xBA21}, //2816 #HANGUL SYLLABLE MIEUM YAE NIEUNCIEUC
  {0x90DF, 0xBA22}, //2817 #HANGUL SYLLABLE MIEUM YAE NIEUNHIEUH
  {0x90E0, 0xBA23}, //2818 #HANGUL SYLLABLE MIEUM YAE TIKEUT
  {0x90E1, 0xBA24}, //2819 #HANGUL SYLLABLE MIEUM YAE RIEUL
  {0x90E2, 0xBA25}, //2820 #HANGUL SYLLABLE MIEUM YAE RIEULKIYEOK
  {0x90E3, 0xBA26}, //2821 #HANGUL SYLLABLE MIEUM YAE RIEULMIEUM
  {0x90E4, 0xBA27}, //2822 #HANGUL SYLLABLE MIEUM YAE RIEULPIEUP
  {0x90E5, 0xBA28}, //2823 #HANGUL SYLLABLE MIEUM YAE RIEULSIOS
  {0x90E6, 0xBA29}, //2824 #HANGUL SYLLABLE MIEUM YAE RIEULTHIEUTH
  {0x90E7, 0xBA2A}, //2825 #HANGUL SYLLABLE MIEUM YAE RIEULPHIEUPH
  {0x90E8, 0xBA2B}, //2826 #HANGUL SYLLABLE MIEUM YAE RIEULHIEUH
  {0x90E9, 0xBA2C}, //2827 #HANGUL SYLLABLE MIEUM YAE MIEUM
  {0x90EA, 0xBA2D}, //2828 #HANGUL SYLLABLE MIEUM YAE PIEUP
  {0x90EB, 0xBA2E}, //2829 #HANGUL SYLLABLE MIEUM YAE PIEUPSIOS
  {0x90EC, 0xBA2F}, //2830 #HANGUL SYLLABLE MIEUM YAE SIOS
  {0x90ED, 0xBA30}, //2831 #HANGUL SYLLABLE MIEUM YAE SSANGSIOS
  {0x90EE, 0xBA31}, //2832 #HANGUL SYLLABLE MIEUM YAE IEUNG
  {0x90EF, 0xBA32}, //2833 #HANGUL SYLLABLE MIEUM YAE CIEUC
  {0x90F0, 0xBA33}, //2834 #HANGUL SYLLABLE MIEUM YAE CHIEUCH
  {0x90F1, 0xBA34}, //2835 #HANGUL SYLLABLE MIEUM YAE KHIEUKH
  {0x90F2, 0xBA35}, //2836 #HANGUL SYLLABLE MIEUM YAE THIEUTH
  {0x90F3, 0xBA36}, //2837 #HANGUL SYLLABLE MIEUM YAE PHIEUPH
  {0x90F4, 0xBA37}, //2838 #HANGUL SYLLABLE MIEUM YAE HIEUH
  {0x90F5, 0xBA3A}, //2839 #HANGUL SYLLABLE MIEUM EO SSANGKIYEOK
  {0x90F6, 0xBA3B}, //2840 #HANGUL SYLLABLE MIEUM EO KIYEOKSIOS
  {0x90F7, 0xBA3D}, //2841 #HANGUL SYLLABLE MIEUM EO NIEUNCIEUC
  {0x90F8, 0xBA3E}, //2842 #HANGUL SYLLABLE MIEUM EO NIEUNHIEUH
  {0x90F9, 0xBA3F}, //2843 #HANGUL SYLLABLE MIEUM EO TIKEUT
  {0x90FA, 0xBA41}, //2844 #HANGUL SYLLABLE MIEUM EO RIEULKIYEOK
  {0x90FB, 0xBA43}, //2845 #HANGUL SYLLABLE MIEUM EO RIEULPIEUP
  {0x90FC, 0xBA44}, //2846 #HANGUL SYLLABLE MIEUM EO RIEULSIOS
  {0x90FD, 0xBA45}, //2847 #HANGUL SYLLABLE MIEUM EO RIEULTHIEUTH
  {0x90FE, 0xBA46}, //2848 #HANGUL SYLLABLE MIEUM EO RIEULPHIEUPH
  {0x9141, 0xBA47}, //2849 #HANGUL SYLLABLE MIEUM EO RIEULHIEUH
  {0x9142, 0xBA4A}, //2850 #HANGUL SYLLABLE MIEUM EO PIEUPSIOS
  {0x9143, 0xBA4C}, //2851 #HANGUL SYLLABLE MIEUM EO SSANGSIOS
  {0x9144, 0xBA4F}, //2852 #HANGUL SYLLABLE MIEUM EO CHIEUCH
  {0x9145, 0xBA50}, //2853 #HANGUL SYLLABLE MIEUM EO KHIEUKH
  {0x9146, 0xBA51}, //2854 #HANGUL SYLLABLE MIEUM EO THIEUTH
  {0x9147, 0xBA52}, //2855 #HANGUL SYLLABLE MIEUM EO PHIEUPH
  {0x9148, 0xBA56}, //2856 #HANGUL SYLLABLE MIEUM E SSANGKIYEOK
  {0x9149, 0xBA57}, //2857 #HANGUL SYLLABLE MIEUM E KIYEOKSIOS
  {0x914A, 0xBA59}, //2858 #HANGUL SYLLABLE MIEUM E NIEUNCIEUC
  {0x914B, 0xBA5A}, //2859 #HANGUL SYLLABLE MIEUM E NIEUNHIEUH
  {0x914C, 0xBA5B}, //2860 #HANGUL SYLLABLE MIEUM E TIKEUT
  {0x914D, 0xBA5D}, //2861 #HANGUL SYLLABLE MIEUM E RIEULKIYEOK
  {0x914E, 0xBA5E}, //2862 #HANGUL SYLLABLE MIEUM E RIEULMIEUM
  {0x914F, 0xBA5F}, //2863 #HANGUL SYLLABLE MIEUM E RIEULPIEUP
  {0x9150, 0xBA60}, //2864 #HANGUL SYLLABLE MIEUM E RIEULSIOS
  {0x9151, 0xBA61}, //2865 #HANGUL SYLLABLE MIEUM E RIEULTHIEUTH
  {0x9152, 0xBA62}, //2866 #HANGUL SYLLABLE MIEUM E RIEULPHIEUPH
  {0x9153, 0xBA63}, //2867 #HANGUL SYLLABLE MIEUM E RIEULHIEUH
  {0x9154, 0xBA66}, //2868 #HANGUL SYLLABLE MIEUM E PIEUPSIOS
  {0x9155, 0xBA6A}, //2869 #HANGUL SYLLABLE MIEUM E CIEUC
  {0x9156, 0xBA6B}, //2870 #HANGUL SYLLABLE MIEUM E CHIEUCH
  {0x9157, 0xBA6C}, //2871 #HANGUL SYLLABLE MIEUM E KHIEUKH
  {0x9158, 0xBA6D}, //2872 #HANGUL SYLLABLE MIEUM E THIEUTH
  {0x9159, 0xBA6E}, //2873 #HANGUL SYLLABLE MIEUM E PHIEUPH
  {0x915A, 0xBA6F}, //2874 #HANGUL SYLLABLE MIEUM E HIEUH
  {0x9161, 0xBA72}, //2875 #HANGUL SYLLABLE MIEUM YEO SSANGKIYEOK
  {0x9162, 0xBA73}, //2876 #HANGUL SYLLABLE MIEUM YEO KIYEOKSIOS
  {0x9163, 0xBA75}, //2877 #HANGUL SYLLABLE MIEUM YEO NIEUNCIEUC
  {0x9164, 0xBA76}, //2878 #HANGUL SYLLABLE MIEUM YEO NIEUNHIEUH
  {0x9165, 0xBA77}, //2879 #HANGUL SYLLABLE MIEUM YEO TIKEUT
  {0x9166, 0xBA79}, //2880 #HANGUL SYLLABLE MIEUM YEO RIEULKIYEOK
  {0x9167, 0xBA7A}, //2881 #HANGUL SYLLABLE MIEUM YEO RIEULMIEUM
  {0x9168, 0xBA7B}, //2882 #HANGUL SYLLABLE MIEUM YEO RIEULPIEUP
  {0x9169, 0xBA7C}, //2883 #HANGUL SYLLABLE MIEUM YEO RIEULSIOS
  {0x916A, 0xBA7D}, //2884 #HANGUL SYLLABLE MIEUM YEO RIEULTHIEUTH
  {0x916B, 0xBA7E}, //2885 #HANGUL SYLLABLE MIEUM YEO RIEULPHIEUPH
  {0x916C, 0xBA7F}, //2886 #HANGUL SYLLABLE MIEUM YEO RIEULHIEUH
  {0x916D, 0xBA80}, //2887 #HANGUL SYLLABLE MIEUM YEO MIEUM
  {0x916E, 0xBA81}, //2888 #HANGUL SYLLABLE MIEUM YEO PIEUP
  {0x916F, 0xBA82}, //2889 #HANGUL SYLLABLE MIEUM YEO PIEUPSIOS
  {0x9170, 0xBA86}, //2890 #HANGUL SYLLABLE MIEUM YEO CIEUC
  {0x9171, 0xBA88}, //2891 #HANGUL SYLLABLE MIEUM YEO KHIEUKH
  {0x9172, 0xBA89}, //2892 #HANGUL SYLLABLE MIEUM YEO THIEUTH
  {0x9173, 0xBA8A}, //2893 #HANGUL SYLLABLE MIEUM YEO PHIEUPH
  {0x9174, 0xBA8B}, //2894 #HANGUL SYLLABLE MIEUM YEO HIEUH
  {0x9175, 0xBA8D}, //2895 #HANGUL SYLLABLE MIEUM YE KIYEOK
  {0x9176, 0xBA8E}, //2896 #HANGUL SYLLABLE MIEUM YE SSANGKIYEOK
  {0x9177, 0xBA8F}, //2897 #HANGUL SYLLABLE MIEUM YE KIYEOKSIOS
  {0x9178, 0xBA90}, //2898 #HANGUL SYLLABLE MIEUM YE NIEUN
  {0x9179, 0xBA91}, //2899 #HANGUL SYLLABLE MIEUM YE NIEUNCIEUC
  {0x917A, 0xBA92}, //2900 #HANGUL SYLLABLE MIEUM YE NIEUNHIEUH
  {0x9181, 0xBA93}, //2901 #HANGUL SYLLABLE MIEUM YE TIKEUT
  {0x9182, 0xBA94}, //2902 #HANGUL SYLLABLE MIEUM YE RIEUL
  {0x9183, 0xBA95}, //2903 #HANGUL SYLLABLE MIEUM YE RIEULKIYEOK
  {0x9184, 0xBA96}, //2904 #HANGUL SYLLABLE MIEUM YE RIEULMIEUM
  {0x9185, 0xBA97}, //2905 #HANGUL SYLLABLE MIEUM YE RIEULPIEUP
  {0x9186, 0xBA98}, //2906 #HANGUL SYLLABLE MIEUM YE RIEULSIOS
  {0x9187, 0xBA99}, //2907 #HANGUL SYLLABLE MIEUM YE RIEULTHIEUTH
  {0x9188, 0xBA9A}, //2908 #HANGUL SYLLABLE MIEUM YE RIEULPHIEUPH
  {0x9189, 0xBA9B}, //2909 #HANGUL SYLLABLE MIEUM YE RIEULHIEUH
  {0x918A, 0xBA9C}, //2910 #HANGUL SYLLABLE MIEUM YE MIEUM
  {0x918B, 0xBA9D}, //2911 #HANGUL SYLLABLE MIEUM YE PIEUP
  {0x918C, 0xBA9E}, //2912 #HANGUL SYLLABLE MIEUM YE PIEUPSIOS
  {0x918D, 0xBA9F}, //2913 #HANGUL SYLLABLE MIEUM YE SIOS
  {0x918E, 0xBAA0}, //2914 #HANGUL SYLLABLE MIEUM YE SSANGSIOS
  {0x918F, 0xBAA1}, //2915 #HANGUL SYLLABLE MIEUM YE IEUNG
  {0x9190, 0xBAA2}, //2916 #HANGUL SYLLABLE MIEUM YE CIEUC
  {0x9191, 0xBAA3}, //2917 #HANGUL SYLLABLE MIEUM YE CHIEUCH
  {0x9192, 0xBAA4}, //2918 #HANGUL SYLLABLE MIEUM YE KHIEUKH
  {0x9193, 0xBAA5}, //2919 #HANGUL SYLLABLE MIEUM YE THIEUTH
  {0x9194, 0xBAA6}, //2920 #HANGUL SYLLABLE MIEUM YE PHIEUPH
  {0x9195, 0xBAA7}, //2921 #HANGUL SYLLABLE MIEUM YE HIEUH
  {0x9196, 0xBAAA}, //2922 #HANGUL SYLLABLE MIEUM O SSANGKIYEOK
  {0x9197, 0xBAAD}, //2923 #HANGUL SYLLABLE MIEUM O NIEUNCIEUC
  {0x9198, 0xBAAE}, //2924 #HANGUL SYLLABLE MIEUM O NIEUNHIEUH
  {0x9199, 0xBAAF}, //2925 #HANGUL SYLLABLE MIEUM O TIKEUT
  {0x919A, 0xBAB1}, //2926 #HANGUL SYLLABLE MIEUM O RIEULKIYEOK
  {0x919B, 0xBAB3}, //2927 #HANGUL SYLLABLE MIEUM O RIEULPIEUP
  {0x919C, 0xBAB4}, //2928 #HANGUL SYLLABLE MIEUM O RIEULSIOS
  {0x919D, 0xBAB5}, //2929 #HANGUL SYLLABLE MIEUM O RIEULTHIEUTH
  {0x919E, 0xBAB6}, //2930 #HANGUL SYLLABLE MIEUM O RIEULPHIEUPH
  {0x919F, 0xBAB7}, //2931 #HANGUL SYLLABLE MIEUM O RIEULHIEUH
  {0x91A0, 0xBABA}, //2932 #HANGUL SYLLABLE MIEUM O PIEUPSIOS
  {0x91A1, 0xBABC}, //2933 #HANGUL SYLLABLE MIEUM O SSANGSIOS
  {0x91A2, 0xBABE}, //2934 #HANGUL SYLLABLE MIEUM O CIEUC
  {0x91A3, 0xBABF}, //2935 #HANGUL SYLLABLE MIEUM O CHIEUCH
  {0x91A4, 0xBAC0}, //2936 #HANGUL SYLLABLE MIEUM O KHIEUKH
  {0x91A5, 0xBAC1}, //2937 #HANGUL SYLLABLE MIEUM O THIEUTH
  {0x91A6, 0xBAC2}, //2938 #HANGUL SYLLABLE MIEUM O PHIEUPH
  {0x91A7, 0xBAC3}, //2939 #HANGUL SYLLABLE MIEUM O HIEUH
  {0x91A8, 0xBAC5}, //2940 #HANGUL SYLLABLE MIEUM WA KIYEOK
  {0x91A9, 0xBAC6}, //2941 #HANGUL SYLLABLE MIEUM WA SSANGKIYEOK
  {0x91AA, 0xBAC7}, //2942 #HANGUL SYLLABLE MIEUM WA KIYEOKSIOS
  {0x91AB, 0xBAC9}, //2943 #HANGUL SYLLABLE MIEUM WA NIEUNCIEUC
  {0x91AC, 0xBACA}, //2944 #HANGUL SYLLABLE MIEUM WA NIEUNHIEUH
  {0x91AD, 0xBACB}, //2945 #HANGUL SYLLABLE MIEUM WA TIKEUT
  {0x91AE, 0xBACC}, //2946 #HANGUL SYLLABLE MIEUM WA RIEUL
  {0x91AF, 0xBACD}, //2947 #HANGUL SYLLABLE MIEUM WA RIEULKIYEOK
  {0x91B0, 0xBACE}, //2948 #HANGUL SYLLABLE MIEUM WA RIEULMIEUM
  {0x91B1, 0xBACF}, //2949 #HANGUL SYLLABLE MIEUM WA RIEULPIEUP
  {0x91B2, 0xBAD0}, //2950 #HANGUL SYLLABLE MIEUM WA RIEULSIOS
  {0x91B3, 0xBAD1}, //2951 #HANGUL SYLLABLE MIEUM WA RIEULTHIEUTH
  {0x91B4, 0xBAD2}, //2952 #HANGUL SYLLABLE MIEUM WA RIEULPHIEUPH
  {0x91B5, 0xBAD3}, //2953 #HANGUL SYLLABLE MIEUM WA RIEULHIEUH
  {0x91B6, 0xBAD4}, //2954 #HANGUL SYLLABLE MIEUM WA MIEUM
  {0x91B7, 0xBAD5}, //2955 #HANGUL SYLLABLE MIEUM WA PIEUP
  {0x91B8, 0xBAD6}, //2956 #HANGUL SYLLABLE MIEUM WA PIEUPSIOS
  {0x91B9, 0xBAD7}, //2957 #HANGUL SYLLABLE MIEUM WA SIOS
  {0x91BA, 0xBADA}, //2958 #HANGUL SYLLABLE MIEUM WA CIEUC
  {0x91BB, 0xBADB}, //2959 #HANGUL SYLLABLE MIEUM WA CHIEUCH
  {0x91BC, 0xBADC}, //2960 #HANGUL SYLLABLE MIEUM WA KHIEUKH
  {0x91BD, 0xBADD}, //2961 #HANGUL SYLLABLE MIEUM WA THIEUTH
  {0x91BE, 0xBADE}, //2962 #HANGUL SYLLABLE MIEUM WA PHIEUPH
  {0x91BF, 0xBADF}, //2963 #HANGUL SYLLABLE MIEUM WA HIEUH
  {0x91C0, 0xBAE0}, //2964 #HANGUL SYLLABLE MIEUM WAE
  {0x91C1, 0xBAE1}, //2965 #HANGUL SYLLABLE MIEUM WAE KIYEOK
  {0x91C2, 0xBAE2}, //2966 #HANGUL SYLLABLE MIEUM WAE SSANGKIYEOK
  {0x91C3, 0xBAE3}, //2967 #HANGUL SYLLABLE MIEUM WAE KIYEOKSIOS
  {0x91C4, 0xBAE4}, //2968 #HANGUL SYLLABLE MIEUM WAE NIEUN
  {0x91C5, 0xBAE5}, //2969 #HANGUL SYLLABLE MIEUM WAE NIEUNCIEUC
  {0x91C6, 0xBAE6}, //2970 #HANGUL SYLLABLE MIEUM WAE NIEUNHIEUH
  {0x91C7, 0xBAE7}, //2971 #HANGUL SYLLABLE MIEUM WAE TIKEUT
  {0x91C8, 0xBAE8}, //2972 #HANGUL SYLLABLE MIEUM WAE RIEUL
  {0x91C9, 0xBAE9}, //2973 #HANGUL SYLLABLE MIEUM WAE RIEULKIYEOK
  {0x91CA, 0xBAEA}, //2974 #HANGUL SYLLABLE MIEUM WAE RIEULMIEUM
  {0x91CB, 0xBAEB}, //2975 #HANGUL SYLLABLE MIEUM WAE RIEULPIEUP
  {0x91CC, 0xBAEC}, //2976 #HANGUL SYLLABLE MIEUM WAE RIEULSIOS
  {0x91CD, 0xBAED}, //2977 #HANGUL SYLLABLE MIEUM WAE RIEULTHIEUTH
  {0x91CE, 0xBAEE}, //2978 #HANGUL SYLLABLE MIEUM WAE RIEULPHIEUPH
  {0x91CF, 0xBAEF}, //2979 #HANGUL SYLLABLE MIEUM WAE RIEULHIEUH
  {0x91D0, 0xBAF0}, //2980 #HANGUL SYLLABLE MIEUM WAE MIEUM
  {0x91D1, 0xBAF1}, //2981 #HANGUL SYLLABLE MIEUM WAE PIEUP
  {0x91D2, 0xBAF2}, //2982 #HANGUL SYLLABLE MIEUM WAE PIEUPSIOS
  {0x91D3, 0xBAF3}, //2983 #HANGUL SYLLABLE MIEUM WAE SIOS
  {0x91D4, 0xBAF4}, //2984 #HANGUL SYLLABLE MIEUM WAE SSANGSIOS
  {0x91D5, 0xBAF5}, //2985 #HANGUL SYLLABLE MIEUM WAE IEUNG
  {0x91D6, 0xBAF6}, //2986 #HANGUL SYLLABLE MIEUM WAE CIEUC
  {0x91D7, 0xBAF7}, //2987 #HANGUL SYLLABLE MIEUM WAE CHIEUCH
  {0x91D8, 0xBAF8}, //2988 #HANGUL SYLLABLE MIEUM WAE KHIEUKH
  {0x91D9, 0xBAF9}, //2989 #HANGUL SYLLABLE MIEUM WAE THIEUTH
  {0x91DA, 0xBAFA}, //2990 #HANGUL SYLLABLE MIEUM WAE PHIEUPH
  {0x91DB, 0xBAFB}, //2991 #HANGUL SYLLABLE MIEUM WAE HIEUH
  {0x91DC, 0xBAFD}, //2992 #HANGUL SYLLABLE MIEUM OE KIYEOK
  {0x91DD, 0xBAFE}, //2993 #HANGUL SYLLABLE MIEUM OE SSANGKIYEOK
  {0x91DE, 0xBAFF}, //2994 #HANGUL SYLLABLE MIEUM OE KIYEOKSIOS
  {0x91DF, 0xBB01}, //2995 #HANGUL SYLLABLE MIEUM OE NIEUNCIEUC
  {0x91E0, 0xBB02}, //2996 #HANGUL SYLLABLE MIEUM OE NIEUNHIEUH
  {0x91E1, 0xBB03}, //2997 #HANGUL SYLLABLE MIEUM OE TIKEUT
  {0x91E2, 0xBB05}, //2998 #HANGUL SYLLABLE MIEUM OE RIEULKIYEOK
  {0x91E3, 0xBB06}, //2999 #HANGUL SYLLABLE MIEUM OE RIEULMIEUM
  {0x91E4, 0xBB07}, //3000 #HANGUL SYLLABLE MIEUM OE RIEULPIEUP
  {0x91E5, 0xBB08}, //3001 #HANGUL SYLLABLE MIEUM OE RIEULSIOS
  {0x91E6, 0xBB09}, //3002 #HANGUL SYLLABLE MIEUM OE RIEULTHIEUTH
  {0x91E7, 0xBB0A}, //3003 #HANGUL SYLLABLE MIEUM OE RIEULPHIEUPH
  {0x91E8, 0xBB0B}, //3004 #HANGUL SYLLABLE MIEUM OE RIEULHIEUH
  {0x91E9, 0xBB0C}, //3005 #HANGUL SYLLABLE MIEUM OE MIEUM
  {0x91EA, 0xBB0E}, //3006 #HANGUL SYLLABLE MIEUM OE PIEUPSIOS
  {0x91EB, 0xBB10}, //3007 #HANGUL SYLLABLE MIEUM OE SSANGSIOS
  {0x91EC, 0xBB12}, //3008 #HANGUL SYLLABLE MIEUM OE CIEUC
  {0x91ED, 0xBB13}, //3009 #HANGUL SYLLABLE MIEUM OE CHIEUCH
  {0x91EE, 0xBB14}, //3010 #HANGUL SYLLABLE MIEUM OE KHIEUKH
  {0x91EF, 0xBB15}, //3011 #HANGUL SYLLABLE MIEUM OE THIEUTH
  {0x91F0, 0xBB16}, //3012 #HANGUL SYLLABLE MIEUM OE PHIEUPH
  {0x91F1, 0xBB17}, //3013 #HANGUL SYLLABLE MIEUM OE HIEUH
  {0x91F2, 0xBB19}, //3014 #HANGUL SYLLABLE MIEUM YO KIYEOK
  {0x91F3, 0xBB1A}, //3015 #HANGUL SYLLABLE MIEUM YO SSANGKIYEOK
  {0x91F4, 0xBB1B}, //3016 #HANGUL SYLLABLE MIEUM YO KIYEOKSIOS
  {0x91F5, 0xBB1D}, //3017 #HANGUL SYLLABLE MIEUM YO NIEUNCIEUC
  {0x91F6, 0xBB1E}, //3018 #HANGUL SYLLABLE MIEUM YO NIEUNHIEUH
  {0x91F7, 0xBB1F}, //3019 #HANGUL SYLLABLE MIEUM YO TIKEUT
  {0x91F8, 0xBB21}, //3020 #HANGUL SYLLABLE MIEUM YO RIEULKIYEOK
  {0x91F9, 0xBB22}, //3021 #HANGUL SYLLABLE MIEUM YO RIEULMIEUM
  {0x91FA, 0xBB23}, //3022 #HANGUL SYLLABLE MIEUM YO RIEULPIEUP
  {0x91FB, 0xBB24}, //3023 #HANGUL SYLLABLE MIEUM YO RIEULSIOS
  {0x91FC, 0xBB25}, //3024 #HANGUL SYLLABLE MIEUM YO RIEULTHIEUTH
  {0x91FD, 0xBB26}, //3025 #HANGUL SYLLABLE MIEUM YO RIEULPHIEUPH
  {0x91FE, 0xBB27}, //3026 #HANGUL SYLLABLE MIEUM YO RIEULHIEUH
  {0x9241, 0xBB28}, //3027 #HANGUL SYLLABLE MIEUM YO MIEUM
  {0x9242, 0xBB2A}, //3028 #HANGUL SYLLABLE MIEUM YO PIEUPSIOS
  {0x9243, 0xBB2C}, //3029 #HANGUL SYLLABLE MIEUM YO SSANGSIOS
  {0x9244, 0xBB2D}, //3030 #HANGUL SYLLABLE MIEUM YO IEUNG
  {0x9245, 0xBB2E}, //3031 #HANGUL SYLLABLE MIEUM YO CIEUC
  {0x9246, 0xBB2F}, //3032 #HANGUL SYLLABLE MIEUM YO CHIEUCH
  {0x9247, 0xBB30}, //3033 #HANGUL SYLLABLE MIEUM YO KHIEUKH
  {0x9248, 0xBB31}, //3034 #HANGUL SYLLABLE MIEUM YO THIEUTH
  {0x9249, 0xBB32}, //3035 #HANGUL SYLLABLE MIEUM YO PHIEUPH
  {0x924A, 0xBB33}, //3036 #HANGUL SYLLABLE MIEUM YO HIEUH
  {0x924B, 0xBB37}, //3037 #HANGUL SYLLABLE MIEUM U KIYEOKSIOS
  {0x924C, 0xBB39}, //3038 #HANGUL SYLLABLE MIEUM U NIEUNCIEUC
  {0x924D, 0xBB3A}, //3039 #HANGUL SYLLABLE MIEUM U NIEUNHIEUH
  {0x924E, 0xBB3F}, //3040 #HANGUL SYLLABLE MIEUM U RIEULPIEUP
  {0x924F, 0xBB40}, //3041 #HANGUL SYLLABLE MIEUM U RIEULSIOS
  {0x9250, 0xBB41}, //3042 #HANGUL SYLLABLE MIEUM U RIEULTHIEUTH
  {0x9251, 0xBB42}, //3043 #HANGUL SYLLABLE MIEUM U RIEULPHIEUPH
  {0x9252, 0xBB43}, //3044 #HANGUL SYLLABLE MIEUM U RIEULHIEUH
  {0x9253, 0xBB46}, //3045 #HANGUL SYLLABLE MIEUM U PIEUPSIOS
  {0x9254, 0xBB48}, //3046 #HANGUL SYLLABLE MIEUM U SSANGSIOS
  {0x9255, 0xBB4A}, //3047 #HANGUL SYLLABLE MIEUM U CIEUC
  {0x9256, 0xBB4B}, //3048 #HANGUL SYLLABLE MIEUM U CHIEUCH
  {0x9257, 0xBB4C}, //3049 #HANGUL SYLLABLE MIEUM U KHIEUKH
  {0x9258, 0xBB4E}, //3050 #HANGUL SYLLABLE MIEUM U PHIEUPH
  {0x9259, 0xBB51}, //3051 #HANGUL SYLLABLE MIEUM WEO KIYEOK
  {0x925A, 0xBB52}, //3052 #HANGUL SYLLABLE MIEUM WEO SSANGKIYEOK
  {0x9261, 0xBB53}, //3053 #HANGUL SYLLABLE MIEUM WEO KIYEOKSIOS
  {0x9262, 0xBB55}, //3054 #HANGUL SYLLABLE MIEUM WEO NIEUNCIEUC
  {0x9263, 0xBB56}, //3055 #HANGUL SYLLABLE MIEUM WEO NIEUNHIEUH
  {0x9264, 0xBB57}, //3056 #HANGUL SYLLABLE MIEUM WEO TIKEUT
  {0x9265, 0xBB59}, //3057 #HANGUL SYLLABLE MIEUM WEO RIEULKIYEOK
  {0x9266, 0xBB5A}, //3058 #HANGUL SYLLABLE MIEUM WEO RIEULMIEUM
  {0x9267, 0xBB5B}, //3059 #HANGUL SYLLABLE MIEUM WEO RIEULPIEUP
  {0x9268, 0xBB5C}, //3060 #HANGUL SYLLABLE MIEUM WEO RIEULSIOS
  {0x9269, 0xBB5D}, //3061 #HANGUL SYLLABLE MIEUM WEO RIEULTHIEUTH
  {0x926A, 0xBB5E}, //3062 #HANGUL SYLLABLE MIEUM WEO RIEULPHIEUPH
  {0x926B, 0xBB5F}, //3063 #HANGUL SYLLABLE MIEUM WEO RIEULHIEUH
  {0x926C, 0xBB60}, //3064 #HANGUL SYLLABLE MIEUM WEO MIEUM
  {0x926D, 0xBB62}, //3065 #HANGUL SYLLABLE MIEUM WEO PIEUPSIOS
  {0x926E, 0xBB64}, //3066 #HANGUL SYLLABLE MIEUM WEO SSANGSIOS
  {0x926F, 0xBB65}, //3067 #HANGUL SYLLABLE MIEUM WEO IEUNG
  {0x9270, 0xBB66}, //3068 #HANGUL SYLLABLE MIEUM WEO CIEUC
  {0x9271, 0xBB67}, //3069 #HANGUL SYLLABLE MIEUM WEO CHIEUCH
  {0x9272, 0xBB68}, //3070 #HANGUL SYLLABLE MIEUM WEO KHIEUKH
  {0x9273, 0xBB69}, //3071 #HANGUL SYLLABLE MIEUM WEO THIEUTH
  {0x9274, 0xBB6A}, //3072 #HANGUL SYLLABLE MIEUM WEO PHIEUPH
  {0x9275, 0xBB6B}, //3073 #HANGUL SYLLABLE MIEUM WEO HIEUH
  {0x9276, 0xBB6D}, //3074 #HANGUL SYLLABLE MIEUM WE KIYEOK
  {0x9277, 0xBB6E}, //3075 #HANGUL SYLLABLE MIEUM WE SSANGKIYEOK
  {0x9278, 0xBB6F}, //3076 #HANGUL SYLLABLE MIEUM WE KIYEOKSIOS
  {0x9279, 0xBB70}, //3077 #HANGUL SYLLABLE MIEUM WE NIEUN
  {0x927A, 0xBB71}, //3078 #HANGUL SYLLABLE MIEUM WE NIEUNCIEUC
  {0x9281, 0xBB72}, //3079 #HANGUL SYLLABLE MIEUM WE NIEUNHIEUH
  {0x9282, 0xBB73}, //3080 #HANGUL SYLLABLE MIEUM WE TIKEUT
  {0x9283, 0xBB74}, //3081 #HANGUL SYLLABLE MIEUM WE RIEUL
  {0x9284, 0xBB75}, //3082 #HANGUL SYLLABLE MIEUM WE RIEULKIYEOK
  {0x9285, 0xBB76}, //3083 #HANGUL SYLLABLE MIEUM WE RIEULMIEUM
  {0x9286, 0xBB77}, //3084 #HANGUL SYLLABLE MIEUM WE RIEULPIEUP
  {0x9287, 0xBB78}, //3085 #HANGUL SYLLABLE MIEUM WE RIEULSIOS
  {0x9288, 0xBB79}, //3086 #HANGUL SYLLABLE MIEUM WE RIEULTHIEUTH
  {0x9289, 0xBB7A}, //3087 #HANGUL SYLLABLE MIEUM WE RIEULPHIEUPH
  {0x928A, 0xBB7B}, //3088 #HANGUL SYLLABLE MIEUM WE RIEULHIEUH
  {0x928B, 0xBB7C}, //3089 #HANGUL SYLLABLE MIEUM WE MIEUM
  {0x928C, 0xBB7D}, //3090 #HANGUL SYLLABLE MIEUM WE PIEUP
  {0x928D, 0xBB7E}, //3091 #HANGUL SYLLABLE MIEUM WE PIEUPSIOS
  {0x928E, 0xBB7F}, //3092 #HANGUL SYLLABLE MIEUM WE SIOS
  {0x928F, 0xBB80}, //3093 #HANGUL SYLLABLE MIEUM WE SSANGSIOS
  {0x9290, 0xBB81}, //3094 #HANGUL SYLLABLE MIEUM WE IEUNG
  {0x9291, 0xBB82}, //3095 #HANGUL SYLLABLE MIEUM WE CIEUC
  {0x9292, 0xBB83}, //3096 #HANGUL SYLLABLE MIEUM WE CHIEUCH
  {0x9293, 0xBB84}, //3097 #HANGUL SYLLABLE MIEUM WE KHIEUKH
  {0x9294, 0xBB85}, //3098 #HANGUL SYLLABLE MIEUM WE THIEUTH
  {0x9295, 0xBB86}, //3099 #HANGUL SYLLABLE MIEUM WE PHIEUPH
  {0x9296, 0xBB87}, //3100 #HANGUL SYLLABLE MIEUM WE HIEUH
  {0x9297, 0xBB89}, //3101 #HANGUL SYLLABLE MIEUM WI KIYEOK
  {0x9298, 0xBB8A}, //3102 #HANGUL SYLLABLE MIEUM WI SSANGKIYEOK
  {0x9299, 0xBB8B}, //3103 #HANGUL SYLLABLE MIEUM WI KIYEOKSIOS
  {0x929A, 0xBB8D}, //3104 #HANGUL SYLLABLE MIEUM WI NIEUNCIEUC
  {0x929B, 0xBB8E}, //3105 #HANGUL SYLLABLE MIEUM WI NIEUNHIEUH
  {0x929C, 0xBB8F}, //3106 #HANGUL SYLLABLE MIEUM WI TIKEUT
  {0x929D, 0xBB91}, //3107 #HANGUL SYLLABLE MIEUM WI RIEULKIYEOK
  {0x929E, 0xBB92}, //3108 #HANGUL SYLLABLE MIEUM WI RIEULMIEUM
  {0x929F, 0xBB93}, //3109 #HANGUL SYLLABLE MIEUM WI RIEULPIEUP
  {0x92A0, 0xBB94}, //3110 #HANGUL SYLLABLE MIEUM WI RIEULSIOS
  {0x92A1, 0xBB95}, //3111 #HANGUL SYLLABLE MIEUM WI RIEULTHIEUTH
  {0x92A2, 0xBB96}, //3112 #HANGUL SYLLABLE MIEUM WI RIEULPHIEUPH
  {0x92A3, 0xBB97}, //3113 #HANGUL SYLLABLE MIEUM WI RIEULHIEUH
  {0x92A4, 0xBB98}, //3114 #HANGUL SYLLABLE MIEUM WI MIEUM
  {0x92A5, 0xBB99}, //3115 #HANGUL SYLLABLE MIEUM WI PIEUP
  {0x92A6, 0xBB9A}, //3116 #HANGUL SYLLABLE MIEUM WI PIEUPSIOS
  {0x92A7, 0xBB9B}, //3117 #HANGUL SYLLABLE MIEUM WI SIOS
  {0x92A8, 0xBB9C}, //3118 #HANGUL SYLLABLE MIEUM WI SSANGSIOS
  {0x92A9, 0xBB9D}, //3119 #HANGUL SYLLABLE MIEUM WI IEUNG
  {0x92AA, 0xBB9E}, //3120 #HANGUL SYLLABLE MIEUM WI CIEUC
  {0x92AB, 0xBB9F}, //3121 #HANGUL SYLLABLE MIEUM WI CHIEUCH
  {0x92AC, 0xBBA0}, //3122 #HANGUL SYLLABLE MIEUM WI KHIEUKH
  {0x92AD, 0xBBA1}, //3123 #HANGUL SYLLABLE MIEUM WI THIEUTH
  {0x92AE, 0xBBA2}, //3124 #HANGUL SYLLABLE MIEUM WI PHIEUPH
  {0x92AF, 0xBBA3}, //3125 #HANGUL SYLLABLE MIEUM WI HIEUH
  {0x92B0, 0xBBA5}, //3126 #HANGUL SYLLABLE MIEUM YU KIYEOK
  {0x92B1, 0xBBA6}, //3127 #HANGUL SYLLABLE MIEUM YU SSANGKIYEOK
  {0x92B2, 0xBBA7}, //3128 #HANGUL SYLLABLE MIEUM YU KIYEOKSIOS
  {0x92B3, 0xBBA9}, //3129 #HANGUL SYLLABLE MIEUM YU NIEUNCIEUC
  {0x92B4, 0xBBAA}, //3130 #HANGUL SYLLABLE MIEUM YU NIEUNHIEUH
  {0x92B5, 0xBBAB}, //3131 #HANGUL SYLLABLE MIEUM YU TIKEUT
  {0x92B6, 0xBBAD}, //3132 #HANGUL SYLLABLE MIEUM YU RIEULKIYEOK
  {0x92B7, 0xBBAE}, //3133 #HANGUL SYLLABLE MIEUM YU RIEULMIEUM
  {0x92B8, 0xBBAF}, //3134 #HANGUL SYLLABLE MIEUM YU RIEULPIEUP
  {0x92B9, 0xBBB0}, //3135 #HANGUL SYLLABLE MIEUM YU RIEULSIOS
  {0x92BA, 0xBBB1}, //3136 #HANGUL SYLLABLE MIEUM YU RIEULTHIEUTH
  {0x92BB, 0xBBB2}, //3137 #HANGUL SYLLABLE MIEUM YU RIEULPHIEUPH
  {0x92BC, 0xBBB3}, //3138 #HANGUL SYLLABLE MIEUM YU RIEULHIEUH
  {0x92BD, 0xBBB5}, //3139 #HANGUL SYLLABLE MIEUM YU PIEUP
  {0x92BE, 0xBBB6}, //3140 #HANGUL SYLLABLE MIEUM YU PIEUPSIOS
  {0x92BF, 0xBBB8}, //3141 #HANGUL SYLLABLE MIEUM YU SSANGSIOS
  {0x92C0, 0xBBB9}, //3142 #HANGUL SYLLABLE MIEUM YU IEUNG
  {0x92C1, 0xBBBA}, //3143 #HANGUL SYLLABLE MIEUM YU CIEUC
  {0x92C2, 0xBBBB}, //3144 #HANGUL SYLLABLE MIEUM YU CHIEUCH
  {0x92C3, 0xBBBC}, //3145 #HANGUL SYLLABLE MIEUM YU KHIEUKH
  {0x92C4, 0xBBBD}, //3146 #HANGUL SYLLABLE MIEUM YU THIEUTH
  {0x92C5, 0xBBBE}, //3147 #HANGUL SYLLABLE MIEUM YU PHIEUPH
  {0x92C6, 0xBBBF}, //3148 #HANGUL SYLLABLE MIEUM YU HIEUH
  {0x92C7, 0xBBC1}, //3149 #HANGUL SYLLABLE MIEUM EU KIYEOK
  {0x92C8, 0xBBC2}, //3150 #HANGUL SYLLABLE MIEUM EU SSANGKIYEOK
  {0x92C9, 0xBBC3}, //3151 #HANGUL SYLLABLE MIEUM EU KIYEOKSIOS
  {0x92CA, 0xBBC5}, //3152 #HANGUL SYLLABLE MIEUM EU NIEUNCIEUC
  {0x92CB, 0xBBC6}, //3153 #HANGUL SYLLABLE MIEUM EU NIEUNHIEUH
  {0x92CC, 0xBBC7}, //3154 #HANGUL SYLLABLE MIEUM EU TIKEUT
  {0x92CD, 0xBBC9}, //3155 #HANGUL SYLLABLE MIEUM EU RIEULKIYEOK
  {0x92CE, 0xBBCA}, //3156 #HANGUL SYLLABLE MIEUM EU RIEULMIEUM
  {0x92CF, 0xBBCB}, //3157 #HANGUL SYLLABLE MIEUM EU RIEULPIEUP
  {0x92D0, 0xBBCC}, //3158 #HANGUL SYLLABLE MIEUM EU RIEULSIOS
  {0x92D1, 0xBBCD}, //3159 #HANGUL SYLLABLE MIEUM EU RIEULTHIEUTH
  {0x92D2, 0xBBCE}, //3160 #HANGUL SYLLABLE MIEUM EU RIEULPHIEUPH
  {0x92D3, 0xBBCF}, //3161 #HANGUL SYLLABLE MIEUM EU RIEULHIEUH
  {0x92D4, 0xBBD1}, //3162 #HANGUL SYLLABLE MIEUM EU PIEUP
  {0x92D5, 0xBBD2}, //3163 #HANGUL SYLLABLE MIEUM EU PIEUPSIOS
  {0x92D6, 0xBBD4}, //3164 #HANGUL SYLLABLE MIEUM EU SSANGSIOS
  {0x92D7, 0xBBD5}, //3165 #HANGUL SYLLABLE MIEUM EU IEUNG
  {0x92D8, 0xBBD6}, //3166 #HANGUL SYLLABLE MIEUM EU CIEUC
  {0x92D9, 0xBBD7}, //3167 #HANGUL SYLLABLE MIEUM EU CHIEUCH
  {0x92DA, 0xBBD8}, //3168 #HANGUL SYLLABLE MIEUM EU KHIEUKH
  {0x92DB, 0xBBD9}, //3169 #HANGUL SYLLABLE MIEUM EU THIEUTH
  {0x92DC, 0xBBDA}, //3170 #HANGUL SYLLABLE MIEUM EU PHIEUPH
  {0x92DD, 0xBBDB}, //3171 #HANGUL SYLLABLE MIEUM EU HIEUH
  {0x92DE, 0xBBDC}, //3172 #HANGUL SYLLABLE MIEUM YI
  {0x92DF, 0xBBDD}, //3173 #HANGUL SYLLABLE MIEUM YI KIYEOK
  {0x92E0, 0xBBDE}, //3174 #HANGUL SYLLABLE MIEUM YI SSANGKIYEOK
  {0x92E1, 0xBBDF}, //3175 #HANGUL SYLLABLE MIEUM YI KIYEOKSIOS
  {0x92E2, 0xBBE0}, //3176 #HANGUL SYLLABLE MIEUM YI NIEUN
  {0x92E3, 0xBBE1}, //3177 #HANGUL SYLLABLE MIEUM YI NIEUNCIEUC
  {0x92E4, 0xBBE2}, //3178 #HANGUL SYLLABLE MIEUM YI NIEUNHIEUH
  {0x92E5, 0xBBE3}, //3179 #HANGUL SYLLABLE MIEUM YI TIKEUT
  {0x92E6, 0xBBE4}, //3180 #HANGUL SYLLABLE MIEUM YI RIEUL
  {0x92E7, 0xBBE5}, //3181 #HANGUL SYLLABLE MIEUM YI RIEULKIYEOK
  {0x92E8, 0xBBE6}, //3182 #HANGUL SYLLABLE MIEUM YI RIEULMIEUM
  {0x92E9, 0xBBE7}, //3183 #HANGUL SYLLABLE MIEUM YI RIEULPIEUP
  {0x92EA, 0xBBE8}, //3184 #HANGUL SYLLABLE MIEUM YI RIEULSIOS
  {0x92EB, 0xBBE9}, //3185 #HANGUL SYLLABLE MIEUM YI RIEULTHIEUTH
  {0x92EC, 0xBBEA}, //3186 #HANGUL SYLLABLE MIEUM YI RIEULPHIEUPH
  {0x92ED, 0xBBEB}, //3187 #HANGUL SYLLABLE MIEUM YI RIEULHIEUH
  {0x92EE, 0xBBEC}, //3188 #HANGUL SYLLABLE MIEUM YI MIEUM
  {0x92EF, 0xBBED}, //3189 #HANGUL SYLLABLE MIEUM YI PIEUP
  {0x92F0, 0xBBEE}, //3190 #HANGUL SYLLABLE MIEUM YI PIEUPSIOS
  {0x92F1, 0xBBEF}, //3191 #HANGUL SYLLABLE MIEUM YI SIOS
  {0x92F2, 0xBBF0}, //3192 #HANGUL SYLLABLE MIEUM YI SSANGSIOS
  {0x92F3, 0xBBF1}, //3193 #HANGUL SYLLABLE MIEUM YI IEUNG
  {0x92F4, 0xBBF2}, //3194 #HANGUL SYLLABLE MIEUM YI CIEUC
  {0x92F5, 0xBBF3}, //3195 #HANGUL SYLLABLE MIEUM YI CHIEUCH
  {0x92F6, 0xBBF4}, //3196 #HANGUL SYLLABLE MIEUM YI KHIEUKH
  {0x92F7, 0xBBF5}, //3197 #HANGUL SYLLABLE MIEUM YI THIEUTH
  {0x92F8, 0xBBF6}, //3198 #HANGUL SYLLABLE MIEUM YI PHIEUPH
  {0x92F9, 0xBBF7}, //3199 #HANGUL SYLLABLE MIEUM YI HIEUH
  {0x92FA, 0xBBFA}, //3200 #HANGUL SYLLABLE MIEUM I SSANGKIYEOK
  {0x92FB, 0xBBFB}, //3201 #HANGUL SYLLABLE MIEUM I KIYEOKSIOS
  {0x92FC, 0xBBFD}, //3202 #HANGUL SYLLABLE MIEUM I NIEUNCIEUC
  {0x92FD, 0xBBFE}, //3203 #HANGUL SYLLABLE MIEUM I NIEUNHIEUH
  {0x92FE, 0xBC01}, //3204 #HANGUL SYLLABLE MIEUM I RIEULKIYEOK
  {0x9341, 0xBC03}, //3205 #HANGUL SYLLABLE MIEUM I RIEULPIEUP
  {0x9342, 0xBC04}, //3206 #HANGUL SYLLABLE MIEUM I RIEULSIOS
  {0x9343, 0xBC05}, //3207 #HANGUL SYLLABLE MIEUM I RIEULTHIEUTH
  {0x9344, 0xBC06}, //3208 #HANGUL SYLLABLE MIEUM I RIEULPHIEUPH
  {0x9345, 0xBC07}, //3209 #HANGUL SYLLABLE MIEUM I RIEULHIEUH
  {0x9346, 0xBC0A}, //3210 #HANGUL SYLLABLE MIEUM I PIEUPSIOS
  {0x9347, 0xBC0E}, //3211 #HANGUL SYLLABLE MIEUM I CIEUC
  {0x9348, 0xBC10}, //3212 #HANGUL SYLLABLE MIEUM I KHIEUKH
  {0x9349, 0xBC12}, //3213 #HANGUL SYLLABLE MIEUM I PHIEUPH
  {0x934A, 0xBC13}, //3214 #HANGUL SYLLABLE MIEUM I HIEUH
  {0x934B, 0xBC19}, //3215 #HANGUL SYLLABLE PIEUP A NIEUNCIEUC
  {0x934C, 0xBC1A}, //3216 #HANGUL SYLLABLE PIEUP A NIEUNHIEUH
  {0x934D, 0xBC20}, //3217 #HANGUL SYLLABLE PIEUP A RIEULSIOS
  {0x934E, 0xBC21}, //3218 #HANGUL SYLLABLE PIEUP A RIEULTHIEUTH
  {0x934F, 0xBC22}, //3219 #HANGUL SYLLABLE PIEUP A RIEULPHIEUPH
  {0x9350, 0xBC23}, //3220 #HANGUL SYLLABLE PIEUP A RIEULHIEUH
  {0x9351, 0xBC26}, //3221 #HANGUL SYLLABLE PIEUP A PIEUPSIOS
  {0x9352, 0xBC28}, //3222 #HANGUL SYLLABLE PIEUP A SSANGSIOS
  {0x9353, 0xBC2A}, //3223 #HANGUL SYLLABLE PIEUP A CIEUC
  {0x9354, 0xBC2B}, //3224 #HANGUL SYLLABLE PIEUP A CHIEUCH
  {0x9355, 0xBC2C}, //3225 #HANGUL SYLLABLE PIEUP A KHIEUKH
  {0x9356, 0xBC2E}, //3226 #HANGUL SYLLABLE PIEUP A PHIEUPH
  {0x9357, 0xBC2F}, //3227 #HANGUL SYLLABLE PIEUP A HIEUH
  {0x9358, 0xBC32}, //3228 #HANGUL SYLLABLE PIEUP AE SSANGKIYEOK
  {0x9359, 0xBC33}, //3229 #HANGUL SYLLABLE PIEUP AE KIYEOKSIOS
  {0x935A, 0xBC35}, //3230 #HANGUL SYLLABLE PIEUP AE NIEUNCIEUC
  {0x9361, 0xBC36}, //3231 #HANGUL SYLLABLE PIEUP AE NIEUNHIEUH
  {0x9362, 0xBC37}, //3232 #HANGUL SYLLABLE PIEUP AE TIKEUT
  {0x9363, 0xBC39}, //3233 #HANGUL SYLLABLE PIEUP AE RIEULKIYEOK
  {0x9364, 0xBC3A}, //3234 #HANGUL SYLLABLE PIEUP AE RIEULMIEUM
  {0x9365, 0xBC3B}, //3235 #HANGUL SYLLABLE PIEUP AE RIEULPIEUP
  {0x9366, 0xBC3C}, //3236 #HANGUL SYLLABLE PIEUP AE RIEULSIOS
  {0x9367, 0xBC3D}, //3237 #HANGUL SYLLABLE PIEUP AE RIEULTHIEUTH
  {0x9368, 0xBC3E}, //3238 #HANGUL SYLLABLE PIEUP AE RIEULPHIEUPH
  {0x9369, 0xBC3F}, //3239 #HANGUL SYLLABLE PIEUP AE RIEULHIEUH
  {0x936A, 0xBC42}, //3240 #HANGUL SYLLABLE PIEUP AE PIEUPSIOS
  {0x936B, 0xBC46}, //3241 #HANGUL SYLLABLE PIEUP AE CIEUC
  {0x936C, 0xBC47}, //3242 #HANGUL SYLLABLE PIEUP AE CHIEUCH
  {0x936D, 0xBC48}, //3243 #HANGUL SYLLABLE PIEUP AE KHIEUKH
  {0x936E, 0xBC4A}, //3244 #HANGUL SYLLABLE PIEUP AE PHIEUPH
  {0x936F, 0xBC4B}, //3245 #HANGUL SYLLABLE PIEUP AE HIEUH
  {0x9370, 0xBC4E}, //3246 #HANGUL SYLLABLE PIEUP YA SSANGKIYEOK
  {0x9371, 0xBC4F}, //3247 #HANGUL SYLLABLE PIEUP YA KIYEOKSIOS
  {0x9372, 0xBC51}, //3248 #HANGUL SYLLABLE PIEUP YA NIEUNCIEUC
  {0x9373, 0xBC52}, //3249 #HANGUL SYLLABLE PIEUP YA NIEUNHIEUH
  {0x9374, 0xBC53}, //3250 #HANGUL SYLLABLE PIEUP YA TIKEUT
  {0x9375, 0xBC54}, //3251 #HANGUL SYLLABLE PIEUP YA RIEUL
  {0x9376, 0xBC55}, //3252 #HANGUL SYLLABLE PIEUP YA RIEULKIYEOK
  {0x9377, 0xBC56}, //3253 #HANGUL SYLLABLE PIEUP YA RIEULMIEUM
  {0x9378, 0xBC57}, //3254 #HANGUL SYLLABLE PIEUP YA RIEULPIEUP
  {0x9379, 0xBC58}, //3255 #HANGUL SYLLABLE PIEUP YA RIEULSIOS
  {0x937A, 0xBC59}, //3256 #HANGUL SYLLABLE PIEUP YA RIEULTHIEUTH
  {0x9381, 0xBC5A}, //3257 #HANGUL SYLLABLE PIEUP YA RIEULPHIEUPH
  {0x9382, 0xBC5B}, //3258 #HANGUL SYLLABLE PIEUP YA RIEULHIEUH
  {0x9383, 0xBC5C}, //3259 #HANGUL SYLLABLE PIEUP YA MIEUM
  {0x9384, 0xBC5E}, //3260 #HANGUL SYLLABLE PIEUP YA PIEUPSIOS
  {0x9385, 0xBC5F}, //3261 #HANGUL SYLLABLE PIEUP YA SIOS
  {0x9386, 0xBC60}, //3262 #HANGUL SYLLABLE PIEUP YA SSANGSIOS
  {0x9387, 0xBC61}, //3263 #HANGUL SYLLABLE PIEUP YA IEUNG
  {0x9388, 0xBC62}, //3264 #HANGUL SYLLABLE PIEUP YA CIEUC
  {0x9389, 0xBC63}, //3265 #HANGUL SYLLABLE PIEUP YA CHIEUCH
  {0x938A, 0xBC64}, //3266 #HANGUL SYLLABLE PIEUP YA KHIEUKH
  {0x938B, 0xBC65}, //3267 #HANGUL SYLLABLE PIEUP YA THIEUTH
  {0x938C, 0xBC66}, //3268 #HANGUL SYLLABLE PIEUP YA PHIEUPH
  {0x938D, 0xBC67}, //3269 #HANGUL SYLLABLE PIEUP YA HIEUH
  {0x938E, 0xBC68}, //3270 #HANGUL SYLLABLE PIEUP YAE
  {0x938F, 0xBC69}, //3271 #HANGUL SYLLABLE PIEUP YAE KIYEOK
  {0x9390, 0xBC6A}, //3272 #HANGUL SYLLABLE PIEUP YAE SSANGKIYEOK
  {0x9391, 0xBC6B}, //3273 #HANGUL SYLLABLE PIEUP YAE KIYEOKSIOS
  {0x9392, 0xBC6C}, //3274 #HANGUL SYLLABLE PIEUP YAE NIEUN
  {0x9393, 0xBC6D}, //3275 #HANGUL SYLLABLE PIEUP YAE NIEUNCIEUC
  {0x9394, 0xBC6E}, //3276 #HANGUL SYLLABLE PIEUP YAE NIEUNHIEUH
  {0x9395, 0xBC6F}, //3277 #HANGUL SYLLABLE PIEUP YAE TIKEUT
  {0x9396, 0xBC70}, //3278 #HANGUL SYLLABLE PIEUP YAE RIEUL
  {0x9397, 0xBC71}, //3279 #HANGUL SYLLABLE PIEUP YAE RIEULKIYEOK
  {0x9398, 0xBC72}, //3280 #HANGUL SYLLABLE PIEUP YAE RIEULMIEUM
  {0x9399, 0xBC73}, //3281 #HANGUL SYLLABLE PIEUP YAE RIEULPIEUP
  {0x939A, 0xBC74}, //3282 #HANGUL SYLLABLE PIEUP YAE RIEULSIOS
  {0x939B, 0xBC75}, //3283 #HANGUL SYLLABLE PIEUP YAE RIEULTHIEUTH
  {0x939C, 0xBC76}, //3284 #HANGUL SYLLABLE PIEUP YAE RIEULPHIEUPH
  {0x939D, 0xBC77}, //3285 #HANGUL SYLLABLE PIEUP YAE RIEULHIEUH
  {0x939E, 0xBC78}, //3286 #HANGUL SYLLABLE PIEUP YAE MIEUM
  {0x939F, 0xBC79}, //3287 #HANGUL SYLLABLE PIEUP YAE PIEUP
  {0x93A0, 0xBC7A}, //3288 #HANGUL SYLLABLE PIEUP YAE PIEUPSIOS
  {0x93A1, 0xBC7B}, //3289 #HANGUL SYLLABLE PIEUP YAE SIOS
  {0x93A2, 0xBC7C}, //3290 #HANGUL SYLLABLE PIEUP YAE SSANGSIOS
  {0x93A3, 0xBC7D}, //3291 #HANGUL SYLLABLE PIEUP YAE IEUNG
  {0x93A4, 0xBC7E}, //3292 #HANGUL SYLLABLE PIEUP YAE CIEUC
  {0x93A5, 0xBC7F}, //3293 #HANGUL SYLLABLE PIEUP YAE CHIEUCH
  {0x93A6, 0xBC80}, //3294 #HANGUL SYLLABLE PIEUP YAE KHIEUKH
  {0x93A7, 0xBC81}, //3295 #HANGUL SYLLABLE PIEUP YAE THIEUTH
  {0x93A8, 0xBC82}, //3296 #HANGUL SYLLABLE PIEUP YAE PHIEUPH
  {0x93A9, 0xBC83}, //3297 #HANGUL SYLLABLE PIEUP YAE HIEUH
  {0x93AA, 0xBC86}, //3298 #HANGUL SYLLABLE PIEUP EO SSANGKIYEOK
  {0x93AB, 0xBC87}, //3299 #HANGUL SYLLABLE PIEUP EO KIYEOKSIOS
  {0x93AC, 0xBC89}, //3300 #HANGUL SYLLABLE PIEUP EO NIEUNCIEUC
  {0x93AD, 0xBC8A}, //3301 #HANGUL SYLLABLE PIEUP EO NIEUNHIEUH
  {0x93AE, 0xBC8D}, //3302 #HANGUL SYLLABLE PIEUP EO RIEULKIYEOK
  {0x93AF, 0xBC8F}, //3303 #HANGUL SYLLABLE PIEUP EO RIEULPIEUP
  {0x93B0, 0xBC90}, //3304 #HANGUL SYLLABLE PIEUP EO RIEULSIOS
  {0x93B1, 0xBC91}, //3305 #HANGUL SYLLABLE PIEUP EO RIEULTHIEUTH
  {0x93B2, 0xBC92}, //3306 #HANGUL SYLLABLE PIEUP EO RIEULPHIEUPH
  {0x93B3, 0xBC93}, //3307 #HANGUL SYLLABLE PIEUP EO RIEULHIEUH
  {0x93B4, 0xBC96}, //3308 #HANGUL SYLLABLE PIEUP EO PIEUPSIOS
  {0x93B5, 0xBC98}, //3309 #HANGUL SYLLABLE PIEUP EO SSANGSIOS
  {0x93B6, 0xBC9B}, //3310 #HANGUL SYLLABLE PIEUP EO CHIEUCH
  {0x93B7, 0xBC9C}, //3311 #HANGUL SYLLABLE PIEUP EO KHIEUKH
  {0x93B8, 0xBC9D}, //3312 #HANGUL SYLLABLE PIEUP EO THIEUTH
  {0x93B9, 0xBC9E}, //3313 #HANGUL SYLLABLE PIEUP EO PHIEUPH
  {0x93BA, 0xBC9F}, //3314 #HANGUL SYLLABLE PIEUP EO HIEUH
  {0x93BB, 0xBCA2}, //3315 #HANGUL SYLLABLE PIEUP E SSANGKIYEOK
  {0x93BC, 0xBCA3}, //3316 #HANGUL SYLLABLE PIEUP E KIYEOKSIOS
  {0x93BD, 0xBCA5}, //3317 #HANGUL SYLLABLE PIEUP E NIEUNCIEUC
  {0x93BE, 0xBCA6}, //3318 #HANGUL SYLLABLE PIEUP E NIEUNHIEUH
  {0x93BF, 0xBCA9}, //3319 #HANGUL SYLLABLE PIEUP E RIEULKIYEOK
  {0x93C0, 0xBCAA}, //3320 #HANGUL SYLLABLE PIEUP E RIEULMIEUM
  {0x93C1, 0xBCAB}, //3321 #HANGUL SYLLABLE PIEUP E RIEULPIEUP
  {0x93C2, 0xBCAC}, //3322 #HANGUL SYLLABLE PIEUP E RIEULSIOS
  {0x93C3, 0xBCAD}, //3323 #HANGUL SYLLABLE PIEUP E RIEULTHIEUTH
  {0x93C4, 0xBCAE}, //3324 #HANGUL SYLLABLE PIEUP E RIEULPHIEUPH
  {0x93C5, 0xBCAF}, //3325 #HANGUL SYLLABLE PIEUP E RIEULHIEUH
  {0x93C6, 0xBCB2}, //3326 #HANGUL SYLLABLE PIEUP E PIEUPSIOS
  {0x93C7, 0xBCB6}, //3327 #HANGUL SYLLABLE PIEUP E CIEUC
  {0x93C8, 0xBCB7}, //3328 #HANGUL SYLLABLE PIEUP E CHIEUCH
  {0x93C9, 0xBCB8}, //3329 #HANGUL SYLLABLE PIEUP E KHIEUKH
  {0x93CA, 0xBCB9}, //3330 #HANGUL SYLLABLE PIEUP E THIEUTH
  {0x93CB, 0xBCBA}, //3331 #HANGUL SYLLABLE PIEUP E PHIEUPH
  {0x93CC, 0xBCBB}, //3332 #HANGUL SYLLABLE PIEUP E HIEUH
  {0x93CD, 0xBCBE}, //3333 #HANGUL SYLLABLE PIEUP YEO SSANGKIYEOK
  {0x93CE, 0xBCBF}, //3334 #HANGUL SYLLABLE PIEUP YEO KIYEOKSIOS
  {0x93CF, 0xBCC1}, //3335 #HANGUL SYLLABLE PIEUP YEO NIEUNCIEUC
  {0x93D0, 0xBCC2}, //3336 #HANGUL SYLLABLE PIEUP YEO NIEUNHIEUH
  {0x93D1, 0xBCC3}, //3337 #HANGUL SYLLABLE PIEUP YEO TIKEUT
  {0x93D2, 0xBCC5}, //3338 #HANGUL SYLLABLE PIEUP YEO RIEULKIYEOK
  {0x93D3, 0xBCC6}, //3339 #HANGUL SYLLABLE PIEUP YEO RIEULMIEUM
  {0x93D4, 0xBCC7}, //3340 #HANGUL SYLLABLE PIEUP YEO RIEULPIEUP
  {0x93D5, 0xBCC8}, //3341 #HANGUL SYLLABLE PIEUP YEO RIEULSIOS
  {0x93D6, 0xBCC9}, //3342 #HANGUL SYLLABLE PIEUP YEO RIEULTHIEUTH
  {0x93D7, 0xBCCA}, //3343 #HANGUL SYLLABLE PIEUP YEO RIEULPHIEUPH
  {0x93D8, 0xBCCB}, //3344 #HANGUL SYLLABLE PIEUP YEO RIEULHIEUH
  {0x93D9, 0xBCCC}, //3345 #HANGUL SYLLABLE PIEUP YEO MIEUM
  {0x93DA, 0xBCCE}, //3346 #HANGUL SYLLABLE PIEUP YEO PIEUPSIOS
  {0x93DB, 0xBCD2}, //3347 #HANGUL SYLLABLE PIEUP YEO CIEUC
  {0x93DC, 0xBCD3}, //3348 #HANGUL SYLLABLE PIEUP YEO CHIEUCH
  {0x93DD, 0xBCD4}, //3349 #HANGUL SYLLABLE PIEUP YEO KHIEUKH
  {0x93DE, 0xBCD6}, //3350 #HANGUL SYLLABLE PIEUP YEO PHIEUPH
  {0x93DF, 0xBCD7}, //3351 #HANGUL SYLLABLE PIEUP YEO HIEUH
  {0x93E0, 0xBCD9}, //3352 #HANGUL SYLLABLE PIEUP YE KIYEOK
  {0x93E1, 0xBCDA}, //3353 #HANGUL SYLLABLE PIEUP YE SSANGKIYEOK
  {0x93E2, 0xBCDB}, //3354 #HANGUL SYLLABLE PIEUP YE KIYEOKSIOS
  {0x93E3, 0xBCDD}, //3355 #HANGUL SYLLABLE PIEUP YE NIEUNCIEUC
  {0x93E4, 0xBCDE}, //3356 #HANGUL SYLLABLE PIEUP YE NIEUNHIEUH
  {0x93E5, 0xBCDF}, //3357 #HANGUL SYLLABLE PIEUP YE TIKEUT
  {0x93E6, 0xBCE0}, //3358 #HANGUL SYLLABLE PIEUP YE RIEUL
  {0x93E7, 0xBCE1}, //3359 #HANGUL SYLLABLE PIEUP YE RIEULKIYEOK
  {0x93E8, 0xBCE2}, //3360 #HANGUL SYLLABLE PIEUP YE RIEULMIEUM
  {0x93E9, 0xBCE3}, //3361 #HANGUL SYLLABLE PIEUP YE RIEULPIEUP
  {0x93EA, 0xBCE4}, //3362 #HANGUL SYLLABLE PIEUP YE RIEULSIOS
  {0x93EB, 0xBCE5}, //3363 #HANGUL SYLLABLE PIEUP YE RIEULTHIEUTH
  {0x93EC, 0xBCE6}, //3364 #HANGUL SYLLABLE PIEUP YE RIEULPHIEUPH
  {0x93ED, 0xBCE7}, //3365 #HANGUL SYLLABLE PIEUP YE RIEULHIEUH
  {0x93EE, 0xBCE8}, //3366 #HANGUL SYLLABLE PIEUP YE MIEUM
  {0x93EF, 0xBCE9}, //3367 #HANGUL SYLLABLE PIEUP YE PIEUP
  {0x93F0, 0xBCEA}, //3368 #HANGUL SYLLABLE PIEUP YE PIEUPSIOS
  {0x93F1, 0xBCEB}, //3369 #HANGUL SYLLABLE PIEUP YE SIOS
  {0x93F2, 0xBCEC}, //3370 #HANGUL SYLLABLE PIEUP YE SSANGSIOS
  {0x93F3, 0xBCED}, //3371 #HANGUL SYLLABLE PIEUP YE IEUNG
  {0x93F4, 0xBCEE}, //3372 #HANGUL SYLLABLE PIEUP YE CIEUC
  {0x93F5, 0xBCEF}, //3373 #HANGUL SYLLABLE PIEUP YE CHIEUCH
  {0x93F6, 0xBCF0}, //3374 #HANGUL SYLLABLE PIEUP YE KHIEUKH
  {0x93F7, 0xBCF1}, //3375 #HANGUL SYLLABLE PIEUP YE THIEUTH
  {0x93F8, 0xBCF2}, //3376 #HANGUL SYLLABLE PIEUP YE PHIEUPH
  {0x93F9, 0xBCF3}, //3377 #HANGUL SYLLABLE PIEUP YE HIEUH
  {0x93FA, 0xBCF7}, //3378 #HANGUL SYLLABLE PIEUP O KIYEOKSIOS
  {0x93FB, 0xBCF9}, //3379 #HANGUL SYLLABLE PIEUP O NIEUNCIEUC
  {0x93FC, 0xBCFA}, //3380 #HANGUL SYLLABLE PIEUP O NIEUNHIEUH
  {0x93FD, 0xBCFB}, //3381 #HANGUL SYLLABLE PIEUP O TIKEUT
  {0x93FE, 0xBCFD}, //3382 #HANGUL SYLLABLE PIEUP O RIEULKIYEOK
  {0x9441, 0xBCFE}, //3383 #HANGUL SYLLABLE PIEUP O RIEULMIEUM
  {0x9442, 0xBCFF}, //3384 #HANGUL SYLLABLE PIEUP O RIEULPIEUP
  {0x9443, 0xBD00}, //3385 #HANGUL SYLLABLE PIEUP O RIEULSIOS
  {0x9444, 0xBD01}, //3386 #HANGUL SYLLABLE PIEUP O RIEULTHIEUTH
  {0x9445, 0xBD02}, //3387 #HANGUL SYLLABLE PIEUP O RIEULPHIEUPH
  {0x9446, 0xBD03}, //3388 #HANGUL SYLLABLE PIEUP O RIEULHIEUH
  {0x9447, 0xBD06}, //3389 #HANGUL SYLLABLE PIEUP O PIEUPSIOS
  {0x9448, 0xBD08}, //3390 #HANGUL SYLLABLE PIEUP O SSANGSIOS
  {0x9449, 0xBD0A}, //3391 #HANGUL SYLLABLE PIEUP O CIEUC
  {0x944A, 0xBD0B}, //3392 #HANGUL SYLLABLE PIEUP O CHIEUCH
  {0x944B, 0xBD0C}, //3393 #HANGUL SYLLABLE PIEUP O KHIEUKH
  {0x944C, 0xBD0D}, //3394 #HANGUL SYLLABLE PIEUP O THIEUTH
  {0x944D, 0xBD0E}, //3395 #HANGUL SYLLABLE PIEUP O PHIEUPH
  {0x944E, 0xBD0F}, //3396 #HANGUL SYLLABLE PIEUP O HIEUH
  {0x944F, 0xBD11}, //3397 #HANGUL SYLLABLE PIEUP WA KIYEOK
  {0x9450, 0xBD12}, //3398 #HANGUL SYLLABLE PIEUP WA SSANGKIYEOK
  {0x9451, 0xBD13}, //3399 #HANGUL SYLLABLE PIEUP WA KIYEOKSIOS
  {0x9452, 0xBD15}, //3400 #HANGUL SYLLABLE PIEUP WA NIEUNCIEUC
  {0x9453, 0xBD16}, //3401 #HANGUL SYLLABLE PIEUP WA NIEUNHIEUH
  {0x9454, 0xBD17}, //3402 #HANGUL SYLLABLE PIEUP WA TIKEUT
  {0x9455, 0xBD18}, //3403 #HANGUL SYLLABLE PIEUP WA RIEUL
  {0x9456, 0xBD19}, //3404 #HANGUL SYLLABLE PIEUP WA RIEULKIYEOK
  {0x9457, 0xBD1A}, //3405 #HANGUL SYLLABLE PIEUP WA RIEULMIEUM
  {0x9458, 0xBD1B}, //3406 #HANGUL SYLLABLE PIEUP WA RIEULPIEUP
  {0x9459, 0xBD1C}, //3407 #HANGUL SYLLABLE PIEUP WA RIEULSIOS
  {0x945A, 0xBD1D}, //3408 #HANGUL SYLLABLE PIEUP WA RIEULTHIEUTH
  {0x9461, 0xBD1E}, //3409 #HANGUL SYLLABLE PIEUP WA RIEULPHIEUPH
  {0x9462, 0xBD1F}, //3410 #HANGUL SYLLABLE PIEUP WA RIEULHIEUH
  {0x9463, 0xBD20}, //3411 #HANGUL SYLLABLE PIEUP WA MIEUM
  {0x9464, 0xBD21}, //3412 #HANGUL SYLLABLE PIEUP WA PIEUP
  {0x9465, 0xBD22}, //3413 #HANGUL SYLLABLE PIEUP WA PIEUPSIOS
  {0x9466, 0xBD23}, //3414 #HANGUL SYLLABLE PIEUP WA SIOS
  {0x9467, 0xBD25}, //3415 #HANGUL SYLLABLE PIEUP WA IEUNG
  {0x9468, 0xBD26}, //3416 #HANGUL SYLLABLE PIEUP WA CIEUC
  {0x9469, 0xBD27}, //3417 #HANGUL SYLLABLE PIEUP WA CHIEUCH
  {0x946A, 0xBD28}, //3418 #HANGUL SYLLABLE PIEUP WA KHIEUKH
  {0x946B, 0xBD29}, //3419 #HANGUL SYLLABLE PIEUP WA THIEUTH
  {0x946C, 0xBD2A}, //3420 #HANGUL SYLLABLE PIEUP WA PHIEUPH
  {0x946D, 0xBD2B}, //3421 #HANGUL SYLLABLE PIEUP WA HIEUH
  {0x946E, 0xBD2D}, //3422 #HANGUL SYLLABLE PIEUP WAE KIYEOK
  {0x946F, 0xBD2E}, //3423 #HANGUL SYLLABLE PIEUP WAE SSANGKIYEOK
  {0x9470, 0xBD2F}, //3424 #HANGUL SYLLABLE PIEUP WAE KIYEOKSIOS
  {0x9471, 0xBD30}, //3425 #HANGUL SYLLABLE PIEUP WAE NIEUN
  {0x9472, 0xBD31}, //3426 #HANGUL SYLLABLE PIEUP WAE NIEUNCIEUC
  {0x9473, 0xBD32}, //3427 #HANGUL SYLLABLE PIEUP WAE NIEUNHIEUH
  {0x9474, 0xBD33}, //3428 #HANGUL SYLLABLE PIEUP WAE TIKEUT
  {0x9475, 0xBD34}, //3429 #HANGUL SYLLABLE PIEUP WAE RIEUL
  {0x9476, 0xBD35}, //3430 #HANGUL SYLLABLE PIEUP WAE RIEULKIYEOK
  {0x9477, 0xBD36}, //3431 #HANGUL SYLLABLE PIEUP WAE RIEULMIEUM
  {0x9478, 0xBD37}, //3432 #HANGUL SYLLABLE PIEUP WAE RIEULPIEUP
  {0x9479, 0xBD38}, //3433 #HANGUL SYLLABLE PIEUP WAE RIEULSIOS
  {0x947A, 0xBD39}, //3434 #HANGUL SYLLABLE PIEUP WAE RIEULTHIEUTH
  {0x9481, 0xBD3A}, //3435 #HANGUL SYLLABLE PIEUP WAE RIEULPHIEUPH
  {0x9482, 0xBD3B}, //3436 #HANGUL SYLLABLE PIEUP WAE RIEULHIEUH
  {0x9483, 0xBD3C}, //3437 #HANGUL SYLLABLE PIEUP WAE MIEUM
  {0x9484, 0xBD3D}, //3438 #HANGUL SYLLABLE PIEUP WAE PIEUP
  {0x9485, 0xBD3E}, //3439 #HANGUL SYLLABLE PIEUP WAE PIEUPSIOS
  {0x9486, 0xBD3F}, //3440 #HANGUL SYLLABLE PIEUP WAE SIOS
  {0x9487, 0xBD41}, //3441 #HANGUL SYLLABLE PIEUP WAE IEUNG
  {0x9488, 0xBD42}, //3442 #HANGUL SYLLABLE PIEUP WAE CIEUC
  {0x9489, 0xBD43}, //3443 #HANGUL SYLLABLE PIEUP WAE CHIEUCH
  {0x948A, 0xBD44}, //3444 #HANGUL SYLLABLE PIEUP WAE KHIEUKH
  {0x948B, 0xBD45}, //3445 #HANGUL SYLLABLE PIEUP WAE THIEUTH
  {0x948C, 0xBD46}, //3446 #HANGUL SYLLABLE PIEUP WAE PHIEUPH
  {0x948D, 0xBD47}, //3447 #HANGUL SYLLABLE PIEUP WAE HIEUH
  {0x948E, 0xBD4A}, //3448 #HANGUL SYLLABLE PIEUP OE SSANGKIYEOK
  {0x948F, 0xBD4B}, //3449 #HANGUL SYLLABLE PIEUP OE KIYEOKSIOS
  {0x9490, 0xBD4D}, //3450 #HANGUL SYLLABLE PIEUP OE NIEUNCIEUC
  {0x9491, 0xBD4E}, //3451 #HANGUL SYLLABLE PIEUP OE NIEUNHIEUH
  {0x9492, 0xBD4F}, //3452 #HANGUL SYLLABLE PIEUP OE TIKEUT
  {0x9493, 0xBD51}, //3453 #HANGUL SYLLABLE PIEUP OE RIEULKIYEOK
  {0x9494, 0xBD52}, //3454 #HANGUL SYLLABLE PIEUP OE RIEULMIEUM
  {0x9495, 0xBD53}, //3455 #HANGUL SYLLABLE PIEUP OE RIEULPIEUP
  {0x9496, 0xBD54}, //3456 #HANGUL SYLLABLE PIEUP OE RIEULSIOS
  {0x9497, 0xBD55}, //3457 #HANGUL SYLLABLE PIEUP OE RIEULTHIEUTH
  {0x9498, 0xBD56}, //3458 #HANGUL SYLLABLE PIEUP OE RIEULPHIEUPH
  {0x9499, 0xBD57}, //3459 #HANGUL SYLLABLE PIEUP OE RIEULHIEUH
  {0x949A, 0xBD5A}, //3460 #HANGUL SYLLABLE PIEUP OE PIEUPSIOS
  {0x949B, 0xBD5B}, //3461 #HANGUL SYLLABLE PIEUP OE SIOS
  {0x949C, 0xBD5C}, //3462 #HANGUL SYLLABLE PIEUP OE SSANGSIOS
  {0x949D, 0xBD5D}, //3463 #HANGUL SYLLABLE PIEUP OE IEUNG
  {0x949E, 0xBD5E}, //3464 #HANGUL SYLLABLE PIEUP OE CIEUC
  {0x949F, 0xBD5F}, //3465 #HANGUL SYLLABLE PIEUP OE CHIEUCH
  {0x94A0, 0xBD60}, //3466 #HANGUL SYLLABLE PIEUP OE KHIEUKH
  {0x94A1, 0xBD61}, //3467 #HANGUL SYLLABLE PIEUP OE THIEUTH
  {0x94A2, 0xBD62}, //3468 #HANGUL SYLLABLE PIEUP OE PHIEUPH
  {0x94A3, 0xBD63}, //3469 #HANGUL SYLLABLE PIEUP OE HIEUH
  {0x94A4, 0xBD65}, //3470 #HANGUL SYLLABLE PIEUP YO KIYEOK
  {0x94A5, 0xBD66}, //3471 #HANGUL SYLLABLE PIEUP YO SSANGKIYEOK
  {0x94A6, 0xBD67}, //3472 #HANGUL SYLLABLE PIEUP YO KIYEOKSIOS
  {0x94A7, 0xBD69}, //3473 #HANGUL SYLLABLE PIEUP YO NIEUNCIEUC
  {0x94A8, 0xBD6A}, //3474 #HANGUL SYLLABLE PIEUP YO NIEUNHIEUH
  {0x94A9, 0xBD6B}, //3475 #HANGUL SYLLABLE PIEUP YO TIKEUT
  {0x94AA, 0xBD6C}, //3476 #HANGUL SYLLABLE PIEUP YO RIEUL
  {0x94AB, 0xBD6D}, //3477 #HANGUL SYLLABLE PIEUP YO RIEULKIYEOK
  {0x94AC, 0xBD6E}, //3478 #HANGUL SYLLABLE PIEUP YO RIEULMIEUM
  {0x94AD, 0xBD6F}, //3479 #HANGUL SYLLABLE PIEUP YO RIEULPIEUP
  {0x94AE, 0xBD70}, //3480 #HANGUL SYLLABLE PIEUP YO RIEULSIOS
  {0x94AF, 0xBD71}, //3481 #HANGUL SYLLABLE PIEUP YO RIEULTHIEUTH
  {0x94B0, 0xBD72}, //3482 #HANGUL SYLLABLE PIEUP YO RIEULPHIEUPH
  {0x94B1, 0xBD73}, //3483 #HANGUL SYLLABLE PIEUP YO RIEULHIEUH
  {0x94B2, 0xBD74}, //3484 #HANGUL SYLLABLE PIEUP YO MIEUM
  {0x94B3, 0xBD75}, //3485 #HANGUL SYLLABLE PIEUP YO PIEUP
  {0x94B4, 0xBD76}, //3486 #HANGUL SYLLABLE PIEUP YO PIEUPSIOS
  {0x94B5, 0xBD77}, //3487 #HANGUL SYLLABLE PIEUP YO SIOS
  {0x94B6, 0xBD78}, //3488 #HANGUL SYLLABLE PIEUP YO SSANGSIOS
  {0x94B7, 0xBD79}, //3489 #HANGUL SYLLABLE PIEUP YO IEUNG
  {0x94B8, 0xBD7A}, //3490 #HANGUL SYLLABLE PIEUP YO CIEUC
  {0x94B9, 0xBD7B}, //3491 #HANGUL SYLLABLE PIEUP YO CHIEUCH
  {0x94BA, 0xBD7C}, //3492 #HANGUL SYLLABLE PIEUP YO KHIEUKH
  {0x94BB, 0xBD7D}, //3493 #HANGUL SYLLABLE PIEUP YO THIEUTH
  {0x94BC, 0xBD7E}, //3494 #HANGUL SYLLABLE PIEUP YO PHIEUPH
  {0x94BD, 0xBD7F}, //3495 #HANGUL SYLLABLE PIEUP YO HIEUH
  {0x94BE, 0xBD82}, //3496 #HANGUL SYLLABLE PIEUP U SSANGKIYEOK
  {0x94BF, 0xBD83}, //3497 #HANGUL SYLLABLE PIEUP U KIYEOKSIOS
  {0x94C0, 0xBD85}, //3498 #HANGUL SYLLABLE PIEUP U NIEUNCIEUC
  {0x94C1, 0xBD86}, //3499 #HANGUL SYLLABLE PIEUP U NIEUNHIEUH
  {0x94C2, 0xBD8B}, //3500 #HANGUL SYLLABLE PIEUP U RIEULPIEUP
  {0x94C3, 0xBD8C}, //3501 #HANGUL SYLLABLE PIEUP U RIEULSIOS
  {0x94C4, 0xBD8D}, //3502 #HANGUL SYLLABLE PIEUP U RIEULTHIEUTH
  {0x94C5, 0xBD8E}, //3503 #HANGUL SYLLABLE PIEUP U RIEULPHIEUPH
  {0x94C6, 0xBD8F}, //3504 #HANGUL SYLLABLE PIEUP U RIEULHIEUH
  {0x94C7, 0xBD92}, //3505 #HANGUL SYLLABLE PIEUP U PIEUPSIOS
  {0x94C8, 0xBD94}, //3506 #HANGUL SYLLABLE PIEUP U SSANGSIOS
  {0x94C9, 0xBD96}, //3507 #HANGUL SYLLABLE PIEUP U CIEUC
  {0x94CA, 0xBD97}, //3508 #HANGUL SYLLABLE PIEUP U CHIEUCH
  {0x94CB, 0xBD98}, //3509 #HANGUL SYLLABLE PIEUP U KHIEUKH
  {0x94CC, 0xBD9B}, //3510 #HANGUL SYLLABLE PIEUP U HIEUH
  {0x94CD, 0xBD9D}, //3511 #HANGUL SYLLABLE PIEUP WEO KIYEOK
  {0x94CE, 0xBD9E}, //3512 #HANGUL SYLLABLE PIEUP WEO SSANGKIYEOK
  {0x94CF, 0xBD9F}, //3513 #HANGUL SYLLABLE PIEUP WEO KIYEOKSIOS
  {0x94D0, 0xBDA0}, //3514 #HANGUL SYLLABLE PIEUP WEO NIEUN
  {0x94D1, 0xBDA1}, //3515 #HANGUL SYLLABLE PIEUP WEO NIEUNCIEUC
  {0x94D2, 0xBDA2}, //3516 #HANGUL SYLLABLE PIEUP WEO NIEUNHIEUH
  {0x94D3, 0xBDA3}, //3517 #HANGUL SYLLABLE PIEUP WEO TIKEUT
  {0x94D4, 0xBDA5}, //3518 #HANGUL SYLLABLE PIEUP WEO RIEULKIYEOK
  {0x94D5, 0xBDA6}, //3519 #HANGUL SYLLABLE PIEUP WEO RIEULMIEUM
  {0x94D6, 0xBDA7}, //3520 #HANGUL SYLLABLE PIEUP WEO RIEULPIEUP
  {0x94D7, 0xBDA8}, //3521 #HANGUL SYLLABLE PIEUP WEO RIEULSIOS
  {0x94D8, 0xBDA9}, //3522 #HANGUL SYLLABLE PIEUP WEO RIEULTHIEUTH
  {0x94D9, 0xBDAA}, //3523 #HANGUL SYLLABLE PIEUP WEO RIEULPHIEUPH
  {0x94DA, 0xBDAB}, //3524 #HANGUL SYLLABLE PIEUP WEO RIEULHIEUH
  {0x94DB, 0xBDAC}, //3525 #HANGUL SYLLABLE PIEUP WEO MIEUM
  {0x94DC, 0xBDAD}, //3526 #HANGUL SYLLABLE PIEUP WEO PIEUP
  {0x94DD, 0xBDAE}, //3527 #HANGUL SYLLABLE PIEUP WEO PIEUPSIOS
  {0x94DE, 0xBDAF}, //3528 #HANGUL SYLLABLE PIEUP WEO SIOS
  {0x94DF, 0xBDB1}, //3529 #HANGUL SYLLABLE PIEUP WEO IEUNG
  {0x94E0, 0xBDB2}, //3530 #HANGUL SYLLABLE PIEUP WEO CIEUC
  {0x94E1, 0xBDB3}, //3531 #HANGUL SYLLABLE PIEUP WEO CHIEUCH
  {0x94E2, 0xBDB4}, //3532 #HANGUL SYLLABLE PIEUP WEO KHIEUKH
  {0x94E3, 0xBDB5}, //3533 #HANGUL SYLLABLE PIEUP WEO THIEUTH
  {0x94E4, 0xBDB6}, //3534 #HANGUL SYLLABLE PIEUP WEO PHIEUPH
  {0x94E5, 0xBDB7}, //3535 #HANGUL SYLLABLE PIEUP WEO HIEUH
  {0x94E6, 0xBDB9}, //3536 #HANGUL SYLLABLE PIEUP WE KIYEOK
  {0x94E7, 0xBDBA}, //3537 #HANGUL SYLLABLE PIEUP WE SSANGKIYEOK
  {0x94E8, 0xBDBB}, //3538 #HANGUL SYLLABLE PIEUP WE KIYEOKSIOS
  {0x94E9, 0xBDBC}, //3539 #HANGUL SYLLABLE PIEUP WE NIEUN
  {0x94EA, 0xBDBD}, //3540 #HANGUL SYLLABLE PIEUP WE NIEUNCIEUC
  {0x94EB, 0xBDBE}, //3541 #HANGUL SYLLABLE PIEUP WE NIEUNHIEUH
  {0x94EC, 0xBDBF}, //3542 #HANGUL SYLLABLE PIEUP WE TIKEUT
  {0x94ED, 0xBDC0}, //3543 #HANGUL SYLLABLE PIEUP WE RIEUL
  {0x94EE, 0xBDC1}, //3544 #HANGUL SYLLABLE PIEUP WE RIEULKIYEOK
  {0x94EF, 0xBDC2}, //3545 #HANGUL SYLLABLE PIEUP WE RIEULMIEUM
  {0x94F0, 0xBDC3}, //3546 #HANGUL SYLLABLE PIEUP WE RIEULPIEUP
  {0x94F1, 0xBDC4}, //3547 #HANGUL SYLLABLE PIEUP WE RIEULSIOS
  {0x94F2, 0xBDC5}, //3548 #HANGUL SYLLABLE PIEUP WE RIEULTHIEUTH
  {0x94F3, 0xBDC6}, //3549 #HANGUL SYLLABLE PIEUP WE RIEULPHIEUPH
  {0x94F4, 0xBDC7}, //3550 #HANGUL SYLLABLE PIEUP WE RIEULHIEUH
  {0x94F5, 0xBDC8}, //3551 #HANGUL SYLLABLE PIEUP WE MIEUM
  {0x94F6, 0xBDC9}, //3552 #HANGUL SYLLABLE PIEUP WE PIEUP
  {0x94F7, 0xBDCA}, //3553 #HANGUL SYLLABLE PIEUP WE PIEUPSIOS
  {0x94F8, 0xBDCB}, //3554 #HANGUL SYLLABLE PIEUP WE SIOS
  {0x94F9, 0xBDCC}, //3555 #HANGUL SYLLABLE PIEUP WE SSANGSIOS
  {0x94FA, 0xBDCD}, //3556 #HANGUL SYLLABLE PIEUP WE IEUNG
  {0x94FB, 0xBDCE}, //3557 #HANGUL SYLLABLE PIEUP WE CIEUC
  {0x94FC, 0xBDCF}, //3558 #HANGUL SYLLABLE PIEUP WE CHIEUCH
  {0x94FD, 0xBDD0}, //3559 #HANGUL SYLLABLE PIEUP WE KHIEUKH
  {0x94FE, 0xBDD1}, //3560 #HANGUL SYLLABLE PIEUP WE THIEUTH
  {0x9541, 0xBDD2}, //3561 #HANGUL SYLLABLE PIEUP WE PHIEUPH
  {0x9542, 0xBDD3}, //3562 #HANGUL SYLLABLE PIEUP WE HIEUH
  {0x9543, 0xBDD6}, //3563 #HANGUL SYLLABLE PIEUP WI SSANGKIYEOK
  {0x9544, 0xBDD7}, //3564 #HANGUL SYLLABLE PIEUP WI KIYEOKSIOS
  {0x9545, 0xBDD9}, //3565 #HANGUL SYLLABLE PIEUP WI NIEUNCIEUC
  {0x9546, 0xBDDA}, //3566 #HANGUL SYLLABLE PIEUP WI NIEUNHIEUH
  {0x9547, 0xBDDB}, //3567 #HANGUL SYLLABLE PIEUP WI TIKEUT
  {0x9548, 0xBDDD}, //3568 #HANGUL SYLLABLE PIEUP WI RIEULKIYEOK
  {0x9549, 0xBDDE}, //3569 #HANGUL SYLLABLE PIEUP WI RIEULMIEUM
  {0x954A, 0xBDDF}, //3570 #HANGUL SYLLABLE PIEUP WI RIEULPIEUP
  {0x954B, 0xBDE0}, //3571 #HANGUL SYLLABLE PIEUP WI RIEULSIOS
  {0x954C, 0xBDE1}, //3572 #HANGUL SYLLABLE PIEUP WI RIEULTHIEUTH
  {0x954D, 0xBDE2}, //3573 #HANGUL SYLLABLE PIEUP WI RIEULPHIEUPH
  {0x954E, 0xBDE3}, //3574 #HANGUL SYLLABLE PIEUP WI RIEULHIEUH
  {0x954F, 0xBDE4}, //3575 #HANGUL SYLLABLE PIEUP WI MIEUM
  {0x9550, 0xBDE5}, //3576 #HANGUL SYLLABLE PIEUP WI PIEUP
  {0x9551, 0xBDE6}, //3577 #HANGUL SYLLABLE PIEUP WI PIEUPSIOS
  {0x9552, 0xBDE7}, //3578 #HANGUL SYLLABLE PIEUP WI SIOS
  {0x9553, 0xBDE8}, //3579 #HANGUL SYLLABLE PIEUP WI SSANGSIOS
  {0x9554, 0xBDEA}, //3580 #HANGUL SYLLABLE PIEUP WI CIEUC
  {0x9555, 0xBDEB}, //3581 #HANGUL SYLLABLE PIEUP WI CHIEUCH
  {0x9556, 0xBDEC}, //3582 #HANGUL SYLLABLE PIEUP WI KHIEUKH
  {0x9557, 0xBDED}, //3583 #HANGUL SYLLABLE PIEUP WI THIEUTH
  {0x9558, 0xBDEE}, //3584 #HANGUL SYLLABLE PIEUP WI PHIEUPH
  {0x9559, 0xBDEF}, //3585 #HANGUL SYLLABLE PIEUP WI HIEUH
  {0x955A, 0xBDF1}, //3586 #HANGUL SYLLABLE PIEUP YU KIYEOK
  {0x9561, 0xBDF2}, //3587 #HANGUL SYLLABLE PIEUP YU SSANGKIYEOK
  {0x9562, 0xBDF3}, //3588 #HANGUL SYLLABLE PIEUP YU KIYEOKSIOS
  {0x9563, 0xBDF5}, //3589 #HANGUL SYLLABLE PIEUP YU NIEUNCIEUC
  {0x9564, 0xBDF6}, //3590 #HANGUL SYLLABLE PIEUP YU NIEUNHIEUH
  {0x9565, 0xBDF7}, //3591 #HANGUL SYLLABLE PIEUP YU TIKEUT
  {0x9566, 0xBDF9}, //3592 #HANGUL SYLLABLE PIEUP YU RIEULKIYEOK
  {0x9567, 0xBDFA}, //3593 #HANGUL SYLLABLE PIEUP YU RIEULMIEUM
  {0x9568, 0xBDFB}, //3594 #HANGUL SYLLABLE PIEUP YU RIEULPIEUP
  {0x9569, 0xBDFC}, //3595 #HANGUL SYLLABLE PIEUP YU RIEULSIOS
  {0x956A, 0xBDFD}, //3596 #HANGUL SYLLABLE PIEUP YU RIEULTHIEUTH
  {0x956B, 0xBDFE}, //3597 #HANGUL SYLLABLE PIEUP YU RIEULPHIEUPH
  {0x956C, 0xBDFF}, //3598 #HANGUL SYLLABLE PIEUP YU RIEULHIEUH
  {0x956D, 0xBE01}, //3599 #HANGUL SYLLABLE PIEUP YU PIEUP
  {0x956E, 0xBE02}, //3600 #HANGUL SYLLABLE PIEUP YU PIEUPSIOS
  {0x956F, 0xBE04}, //3601 #HANGUL SYLLABLE PIEUP YU SSANGSIOS
  {0x9570, 0xBE06}, //3602 #HANGUL SYLLABLE PIEUP YU CIEUC
  {0x9571, 0xBE07}, //3603 #HANGUL SYLLABLE PIEUP YU CHIEUCH
  {0x9572, 0xBE08}, //3604 #HANGUL SYLLABLE PIEUP YU KHIEUKH
  {0x9573, 0xBE09}, //3605 #HANGUL SYLLABLE PIEUP YU THIEUTH
  {0x9574, 0xBE0A}, //3606 #HANGUL SYLLABLE PIEUP YU PHIEUPH
  {0x9575, 0xBE0B}, //3607 #HANGUL SYLLABLE PIEUP YU HIEUH
  {0x9576, 0xBE0E}, //3608 #HANGUL SYLLABLE PIEUP EU SSANGKIYEOK
  {0x9577, 0xBE0F}, //3609 #HANGUL SYLLABLE PIEUP EU KIYEOKSIOS
  {0x9578, 0xBE11}, //3610 #HANGUL SYLLABLE PIEUP EU NIEUNCIEUC
  {0x9579, 0xBE12}, //3611 #HANGUL SYLLABLE PIEUP EU NIEUNHIEUH
  {0x957A, 0xBE13}, //3612 #HANGUL SYLLABLE PIEUP EU TIKEUT
  {0x9581, 0xBE15}, //3613 #HANGUL SYLLABLE PIEUP EU RIEULKIYEOK
  {0x9582, 0xBE16}, //3614 #HANGUL SYLLABLE PIEUP EU RIEULMIEUM
  {0x9583, 0xBE17}, //3615 #HANGUL SYLLABLE PIEUP EU RIEULPIEUP
  {0x9584, 0xBE18}, //3616 #HANGUL SYLLABLE PIEUP EU RIEULSIOS
  {0x9585, 0xBE19}, //3617 #HANGUL SYLLABLE PIEUP EU RIEULTHIEUTH
  {0x9586, 0xBE1A}, //3618 #HANGUL SYLLABLE PIEUP EU RIEULPHIEUPH
  {0x9587, 0xBE1B}, //3619 #HANGUL SYLLABLE PIEUP EU RIEULHIEUH
  {0x9588, 0xBE1E}, //3620 #HANGUL SYLLABLE PIEUP EU PIEUPSIOS
  {0x9589, 0xBE20}, //3621 #HANGUL SYLLABLE PIEUP EU SSANGSIOS
  {0x958A, 0xBE21}, //3622 #HANGUL SYLLABLE PIEUP EU IEUNG
  {0x958B, 0xBE22}, //3623 #HANGUL SYLLABLE PIEUP EU CIEUC
  {0x958C, 0xBE23}, //3624 #HANGUL SYLLABLE PIEUP EU CHIEUCH
  {0x958D, 0xBE24}, //3625 #HANGUL SYLLABLE PIEUP EU KHIEUKH
  {0x958E, 0xBE25}, //3626 #HANGUL SYLLABLE PIEUP EU THIEUTH
  {0x958F, 0xBE26}, //3627 #HANGUL SYLLABLE PIEUP EU PHIEUPH
  {0x9590, 0xBE27}, //3628 #HANGUL SYLLABLE PIEUP EU HIEUH
  {0x9591, 0xBE28}, //3629 #HANGUL SYLLABLE PIEUP YI
  {0x9592, 0xBE29}, //3630 #HANGUL SYLLABLE PIEUP YI KIYEOK
  {0x9593, 0xBE2A}, //3631 #HANGUL SYLLABLE PIEUP YI SSANGKIYEOK
  {0x9594, 0xBE2B}, //3632 #HANGUL SYLLABLE PIEUP YI KIYEOKSIOS
  {0x9595, 0xBE2C}, //3633 #HANGUL SYLLABLE PIEUP YI NIEUN
  {0x9596, 0xBE2D}, //3634 #HANGUL SYLLABLE PIEUP YI NIEUNCIEUC
  {0x9597, 0xBE2E}, //3635 #HANGUL SYLLABLE PIEUP YI NIEUNHIEUH
  {0x9598, 0xBE2F}, //3636 #HANGUL SYLLABLE PIEUP YI TIKEUT
  {0x9599, 0xBE30}, //3637 #HANGUL SYLLABLE PIEUP YI RIEUL
  {0x959A, 0xBE31}, //3638 #HANGUL SYLLABLE PIEUP YI RIEULKIYEOK
  {0x959B, 0xBE32}, //3639 #HANGUL SYLLABLE PIEUP YI RIEULMIEUM
  {0x959C, 0xBE33}, //3640 #HANGUL SYLLABLE PIEUP YI RIEULPIEUP
  {0x959D, 0xBE34}, //3641 #HANGUL SYLLABLE PIEUP YI RIEULSIOS
  {0x959E, 0xBE35}, //3642 #HANGUL SYLLABLE PIEUP YI RIEULTHIEUTH
  {0x959F, 0xBE36}, //3643 #HANGUL SYLLABLE PIEUP YI RIEULPHIEUPH
  {0x95A0, 0xBE37}, //3644 #HANGUL SYLLABLE PIEUP YI RIEULHIEUH
  {0x95A1, 0xBE38}, //3645 #HANGUL SYLLABLE PIEUP YI MIEUM
  {0x95A2, 0xBE39}, //3646 #HANGUL SYLLABLE PIEUP YI PIEUP
  {0x95A3, 0xBE3A}, //3647 #HANGUL SYLLABLE PIEUP YI PIEUPSIOS
  {0x95A4, 0xBE3B}, //3648 #HANGUL SYLLABLE PIEUP YI SIOS
  {0x95A5, 0xBE3C}, //3649 #HANGUL SYLLABLE PIEUP YI SSANGSIOS
  {0x95A6, 0xBE3D}, //3650 #HANGUL SYLLABLE PIEUP YI IEUNG
  {0x95A7, 0xBE3E}, //3651 #HANGUL SYLLABLE PIEUP YI CIEUC
  {0x95A8, 0xBE3F}, //3652 #HANGUL SYLLABLE PIEUP YI CHIEUCH
  {0x95A9, 0xBE40}, //3653 #HANGUL SYLLABLE PIEUP YI KHIEUKH
  {0x95AA, 0xBE41}, //3654 #HANGUL SYLLABLE PIEUP YI THIEUTH
  {0x95AB, 0xBE42}, //3655 #HANGUL SYLLABLE PIEUP YI PHIEUPH
  {0x95AC, 0xBE43}, //3656 #HANGUL SYLLABLE PIEUP YI HIEUH
  {0x95AD, 0xBE46}, //3657 #HANGUL SYLLABLE PIEUP I SSANGKIYEOK
  {0x95AE, 0xBE47}, //3658 #HANGUL SYLLABLE PIEUP I KIYEOKSIOS
  {0x95AF, 0xBE49}, //3659 #HANGUL SYLLABLE PIEUP I NIEUNCIEUC
  {0x95B0, 0xBE4A}, //3660 #HANGUL SYLLABLE PIEUP I NIEUNHIEUH
  {0x95B1, 0xBE4B}, //3661 #HANGUL SYLLABLE PIEUP I TIKEUT
  {0x95B2, 0xBE4D}, //3662 #HANGUL SYLLABLE PIEUP I RIEULKIYEOK
  {0x95B3, 0xBE4F}, //3663 #HANGUL SYLLABLE PIEUP I RIEULPIEUP
  {0x95B4, 0xBE50}, //3664 #HANGUL SYLLABLE PIEUP I RIEULSIOS
  {0x95B5, 0xBE51}, //3665 #HANGUL SYLLABLE PIEUP I RIEULTHIEUTH
  {0x95B6, 0xBE52}, //3666 #HANGUL SYLLABLE PIEUP I RIEULPHIEUPH
  {0x95B7, 0xBE53}, //3667 #HANGUL SYLLABLE PIEUP I RIEULHIEUH
  {0x95B8, 0xBE56}, //3668 #HANGUL SYLLABLE PIEUP I PIEUPSIOS
  {0x95B9, 0xBE58}, //3669 #HANGUL SYLLABLE PIEUP I SSANGSIOS
  {0x95BA, 0xBE5C}, //3670 #HANGUL SYLLABLE PIEUP I KHIEUKH
  {0x95BB, 0xBE5D}, //3671 #HANGUL SYLLABLE PIEUP I THIEUTH
  {0x95BC, 0xBE5E}, //3672 #HANGUL SYLLABLE PIEUP I PHIEUPH
  {0x95BD, 0xBE5F}, //3673 #HANGUL SYLLABLE PIEUP I HIEUH
  {0x95BE, 0xBE62}, //3674 #HANGUL SYLLABLE SSANGPIEUP A SSANGKIYEOK
  {0x95BF, 0xBE63}, //3675 #HANGUL SYLLABLE SSANGPIEUP A KIYEOKSIOS
  {0x95C0, 0xBE65}, //3676 #HANGUL SYLLABLE SSANGPIEUP A NIEUNCIEUC
  {0x95C1, 0xBE66}, //3677 #HANGUL SYLLABLE SSANGPIEUP A NIEUNHIEUH
  {0x95C2, 0xBE67}, //3678 #HANGUL SYLLABLE SSANGPIEUP A TIKEUT
  {0x95C3, 0xBE69}, //3679 #HANGUL SYLLABLE SSANGPIEUP A RIEULKIYEOK
  {0x95C4, 0xBE6B}, //3680 #HANGUL SYLLABLE SSANGPIEUP A RIEULPIEUP
  {0x95C5, 0xBE6C}, //3681 #HANGUL SYLLABLE SSANGPIEUP A RIEULSIOS
  {0x95C6, 0xBE6D}, //3682 #HANGUL SYLLABLE SSANGPIEUP A RIEULTHIEUTH
  {0x95C7, 0xBE6E}, //3683 #HANGUL SYLLABLE SSANGPIEUP A RIEULPHIEUPH
  {0x95C8, 0xBE6F}, //3684 #HANGUL SYLLABLE SSANGPIEUP A RIEULHIEUH
  {0x95C9, 0xBE72}, //3685 #HANGUL SYLLABLE SSANGPIEUP A PIEUPSIOS
  {0x95CA, 0xBE76}, //3686 #HANGUL SYLLABLE SSANGPIEUP A CIEUC
  {0x95CB, 0xBE77}, //3687 #HANGUL SYLLABLE SSANGPIEUP A CHIEUCH
  {0x95CC, 0xBE78}, //3688 #HANGUL SYLLABLE SSANGPIEUP A KHIEUKH
  {0x95CD, 0xBE79}, //3689 #HANGUL SYLLABLE SSANGPIEUP A THIEUTH
  {0x95CE, 0xBE7A}, //3690 #HANGUL SYLLABLE SSANGPIEUP A PHIEUPH
  {0x95CF, 0xBE7E}, //3691 #HANGUL SYLLABLE SSANGPIEUP AE SSANGKIYEOK
  {0x95D0, 0xBE7F}, //3692 #HANGUL SYLLABLE SSANGPIEUP AE KIYEOKSIOS
  {0x95D1, 0xBE81}, //3693 #HANGUL SYLLABLE SSANGPIEUP AE NIEUNCIEUC
  {0x95D2, 0xBE82}, //3694 #HANGUL SYLLABLE SSANGPIEUP AE NIEUNHIEUH
  {0x95D3, 0xBE83}, //3695 #HANGUL SYLLABLE SSANGPIEUP AE TIKEUT
  {0x95D4, 0xBE85}, //3696 #HANGUL SYLLABLE SSANGPIEUP AE RIEULKIYEOK
  {0x95D5, 0xBE86}, //3697 #HANGUL SYLLABLE SSANGPIEUP AE RIEULMIEUM
  {0x95D6, 0xBE87}, //3698 #HANGUL SYLLABLE SSANGPIEUP AE RIEULPIEUP
  {0x95D7, 0xBE88}, //3699 #HANGUL SYLLABLE SSANGPIEUP AE RIEULSIOS
  {0x95D8, 0xBE89}, //3700 #HANGUL SYLLABLE SSANGPIEUP AE RIEULTHIEUTH
  {0x95D9, 0xBE8A}, //3701 #HANGUL SYLLABLE SSANGPIEUP AE RIEULPHIEUPH
  {0x95DA, 0xBE8B}, //3702 #HANGUL SYLLABLE SSANGPIEUP AE RIEULHIEUH
  {0x95DB, 0xBE8E}, //3703 #HANGUL SYLLABLE SSANGPIEUP AE PIEUPSIOS
  {0x95DC, 0xBE92}, //3704 #HANGUL SYLLABLE SSANGPIEUP AE CIEUC
  {0x95DD, 0xBE93}, //3705 #HANGUL SYLLABLE SSANGPIEUP AE CHIEUCH
  {0x95DE, 0xBE94}, //3706 #HANGUL SYLLABLE SSANGPIEUP AE KHIEUKH
  {0x95DF, 0xBE95}, //3707 #HANGUL SYLLABLE SSANGPIEUP AE THIEUTH
  {0x95E0, 0xBE96}, //3708 #HANGUL SYLLABLE SSANGPIEUP AE PHIEUPH
  {0x95E1, 0xBE97}, //3709 #HANGUL SYLLABLE SSANGPIEUP AE HIEUH
  {0x95E2, 0xBE9A}, //3710 #HANGUL SYLLABLE SSANGPIEUP YA SSANGKIYEOK
  {0x95E3, 0xBE9B}, //3711 #HANGUL SYLLABLE SSANGPIEUP YA KIYEOKSIOS
  {0x95E4, 0xBE9C}, //3712 #HANGUL SYLLABLE SSANGPIEUP YA NIEUN
  {0x95E5, 0xBE9D}, //3713 #HANGUL SYLLABLE SSANGPIEUP YA NIEUNCIEUC
  {0x95E6, 0xBE9E}, //3714 #HANGUL SYLLABLE SSANGPIEUP YA NIEUNHIEUH
  {0x95E7, 0xBE9F}, //3715 #HANGUL SYLLABLE SSANGPIEUP YA TIKEUT
  {0x95E8, 0xBEA0}, //3716 #HANGUL SYLLABLE SSANGPIEUP YA RIEUL
  {0x95E9, 0xBEA1}, //3717 #HANGUL SYLLABLE SSANGPIEUP YA RIEULKIYEOK
  {0x95EA, 0xBEA2}, //3718 #HANGUL SYLLABLE SSANGPIEUP YA RIEULMIEUM
  {0x95EB, 0xBEA3}, //3719 #HANGUL SYLLABLE SSANGPIEUP YA RIEULPIEUP
  {0x95EC, 0xBEA4}, //3720 #HANGUL SYLLABLE SSANGPIEUP YA RIEULSIOS
  {0x95ED, 0xBEA5}, //3721 #HANGUL SYLLABLE SSANGPIEUP YA RIEULTHIEUTH
  {0x95EE, 0xBEA6}, //3722 #HANGUL SYLLABLE SSANGPIEUP YA RIEULPHIEUPH
  {0x95EF, 0xBEA7}, //3723 #HANGUL SYLLABLE SSANGPIEUP YA RIEULHIEUH
  {0x95F0, 0xBEA9}, //3724 #HANGUL SYLLABLE SSANGPIEUP YA PIEUP
  {0x95F1, 0xBEAA}, //3725 #HANGUL SYLLABLE SSANGPIEUP YA PIEUPSIOS
  {0x95F2, 0xBEAB}, //3726 #HANGUL SYLLABLE SSANGPIEUP YA SIOS
  {0x95F3, 0xBEAC}, //3727 #HANGUL SYLLABLE SSANGPIEUP YA SSANGSIOS
  {0x95F4, 0xBEAD}, //3728 #HANGUL SYLLABLE SSANGPIEUP YA IEUNG
  {0x95F5, 0xBEAE}, //3729 #HANGUL SYLLABLE SSANGPIEUP YA CIEUC
  {0x95F6, 0xBEAF}, //3730 #HANGUL SYLLABLE SSANGPIEUP YA CHIEUCH
  {0x95F7, 0xBEB0}, //3731 #HANGUL SYLLABLE SSANGPIEUP YA KHIEUKH
  {0x95F8, 0xBEB1}, //3732 #HANGUL SYLLABLE SSANGPIEUP YA THIEUTH
  {0x95F9, 0xBEB2}, //3733 #HANGUL SYLLABLE SSANGPIEUP YA PHIEUPH
  {0x95FA, 0xBEB3}, //3734 #HANGUL SYLLABLE SSANGPIEUP YA HIEUH
  {0x95FB, 0xBEB4}, //3735 #HANGUL SYLLABLE SSANGPIEUP YAE
  {0x95FC, 0xBEB5}, //3736 #HANGUL SYLLABLE SSANGPIEUP YAE KIYEOK
  {0x95FD, 0xBEB6}, //3737 #HANGUL SYLLABLE SSANGPIEUP YAE SSANGKIYEOK
  {0x95FE, 0xBEB7}, //3738 #HANGUL SYLLABLE SSANGPIEUP YAE KIYEOKSIOS
  {0x9641, 0xBEB8}, //3739 #HANGUL SYLLABLE SSANGPIEUP YAE NIEUN
  {0x9642, 0xBEB9}, //3740 #HANGUL SYLLABLE SSANGPIEUP YAE NIEUNCIEUC
  {0x9643, 0xBEBA}, //3741 #HANGUL SYLLABLE SSANGPIEUP YAE NIEUNHIEUH
  {0x9644, 0xBEBB}, //3742 #HANGUL SYLLABLE SSANGPIEUP YAE TIKEUT
  {0x9645, 0xBEBC}, //3743 #HANGUL SYLLABLE SSANGPIEUP YAE RIEUL
  {0x9646, 0xBEBD}, //3744 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULKIYEOK
  {0x9647, 0xBEBE}, //3745 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULMIEUM
  {0x9648, 0xBEBF}, //3746 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULPIEUP
  {0x9649, 0xBEC0}, //3747 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULSIOS
  {0x964A, 0xBEC1}, //3748 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULTHIEUTH
  {0x964B, 0xBEC2}, //3749 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULPHIEUPH
  {0x964C, 0xBEC3}, //3750 #HANGUL SYLLABLE SSANGPIEUP YAE RIEULHIEUH
  {0x964D, 0xBEC4}, //3751 #HANGUL SYLLABLE SSANGPIEUP YAE MIEUM
  {0x964E, 0xBEC5}, //3752 #HANGUL SYLLABLE SSANGPIEUP YAE PIEUP
  {0x964F, 0xBEC6}, //3753 #HANGUL SYLLABLE SSANGPIEUP YAE PIEUPSIOS
  {0x9650, 0xBEC7}, //3754 #HANGUL SYLLABLE SSANGPIEUP YAE SIOS
  {0x9651, 0xBEC8}, //3755 #HANGUL SYLLABLE SSANGPIEUP YAE SSANGSIOS
  {0x9652, 0xBEC9}, //3756 #HANGUL SYLLABLE SSANGPIEUP YAE IEUNG
  {0x9653, 0xBECA}, //3757 #HANGUL SYLLABLE SSANGPIEUP YAE CIEUC
  {0x9654, 0xBECB}, //3758 #HANGUL SYLLABLE SSANGPIEUP YAE CHIEUCH
  {0x9655, 0xBECC}, //3759 #HANGUL SYLLABLE SSANGPIEUP YAE KHIEUKH
  {0x9656, 0xBECD}, //3760 #HANGUL SYLLABLE SSANGPIEUP YAE THIEUTH
  {0x9657, 0xBECE}, //3761 #HANGUL SYLLABLE SSANGPIEUP YAE PHIEUPH
  {0x9658, 0xBECF}, //3762 #HANGUL SYLLABLE SSANGPIEUP YAE HIEUH
  {0x9659, 0xBED2}, //3763 #HANGUL SYLLABLE SSANGPIEUP EO SSANGKIYEOK
  {0x965A, 0xBED3}, //3764 #HANGUL SYLLABLE SSANGPIEUP EO KIYEOKSIOS
  {0x9661, 0xBED5}, //3765 #HANGUL SYLLABLE SSANGPIEUP EO NIEUNCIEUC
  {0x9662, 0xBED6}, //3766 #HANGUL SYLLABLE SSANGPIEUP EO NIEUNHIEUH
  {0x9663, 0xBED9}, //3767 #HANGUL SYLLABLE SSANGPIEUP EO RIEULKIYEOK
  {0x9664, 0xBEDA}, //3768 #HANGUL SYLLABLE SSANGPIEUP EO RIEULMIEUM
  {0x9665, 0xBEDB}, //3769 #HANGUL SYLLABLE SSANGPIEUP EO RIEULPIEUP
  {0x9666, 0xBEDC}, //3770 #HANGUL SYLLABLE SSANGPIEUP EO RIEULSIOS
  {0x9667, 0xBEDD}, //3771 #HANGUL SYLLABLE SSANGPIEUP EO RIEULTHIEUTH
  {0x9668, 0xBEDE}, //3772 #HANGUL SYLLABLE SSANGPIEUP EO RIEULPHIEUPH
  {0x9669, 0xBEDF}, //3773 #HANGUL SYLLABLE SSANGPIEUP EO RIEULHIEUH
  {0x966A, 0xBEE1}, //3774 #HANGUL SYLLABLE SSANGPIEUP EO PIEUP
  {0x966B, 0xBEE2}, //3775 #HANGUL SYLLABLE SSANGPIEUP EO PIEUPSIOS
  {0x966C, 0xBEE6}, //3776 #HANGUL SYLLABLE SSANGPIEUP EO CIEUC
  {0x966D, 0xBEE7}, //3777 #HANGUL SYLLABLE SSANGPIEUP EO CHIEUCH
  {0x966E, 0xBEE8}, //3778 #HANGUL SYLLABLE SSANGPIEUP EO KHIEUKH
  {0x966F, 0xBEE9}, //3779 #HANGUL SYLLABLE SSANGPIEUP EO THIEUTH
  {0x9670, 0xBEEA}, //3780 #HANGUL SYLLABLE SSANGPIEUP EO PHIEUPH
  {0x9671, 0xBEEB}, //3781 #HANGUL SYLLABLE SSANGPIEUP EO HIEUH
  {0x9672, 0xBEED}, //3782 #HANGUL SYLLABLE SSANGPIEUP E KIYEOK
  {0x9673, 0xBEEE}, //3783 #HANGUL SYLLABLE SSANGPIEUP E SSANGKIYEOK
  {0x9674, 0xBEEF}, //3784 #HANGUL SYLLABLE SSANGPIEUP E KIYEOKSIOS
  {0x9675, 0xBEF0}, //3785 #HANGUL SYLLABLE SSANGPIEUP E NIEUN
  {0x9676, 0xBEF1}, //3786 #HANGUL SYLLABLE SSANGPIEUP E NIEUNCIEUC
  {0x9677, 0xBEF2}, //3787 #HANGUL SYLLABLE SSANGPIEUP E NIEUNHIEUH
  {0x9678, 0xBEF3}, //3788 #HANGUL SYLLABLE SSANGPIEUP E TIKEUT
  {0x9679, 0xBEF4}, //3789 #HANGUL SYLLABLE SSANGPIEUP E RIEUL
  {0x967A, 0xBEF5}, //3790 #HANGUL SYLLABLE SSANGPIEUP E RIEULKIYEOK
  {0x9681, 0xBEF6}, //3791 #HANGUL SYLLABLE SSANGPIEUP E RIEULMIEUM
  {0x9682, 0xBEF7}, //3792 #HANGUL SYLLABLE SSANGPIEUP E RIEULPIEUP
  {0x9683, 0xBEF8}, //3793 #HANGUL SYLLABLE SSANGPIEUP E RIEULSIOS
  {0x9684, 0xBEF9}, //3794 #HANGUL SYLLABLE SSANGPIEUP E RIEULTHIEUTH
  {0x9685, 0xBEFA}, //3795 #HANGUL SYLLABLE SSANGPIEUP E RIEULPHIEUPH
  {0x9686, 0xBEFB}, //3796 #HANGUL SYLLABLE SSANGPIEUP E RIEULHIEUH
  {0x9687, 0xBEFC}, //3797 #HANGUL SYLLABLE SSANGPIEUP E MIEUM
  {0x9688, 0xBEFD}, //3798 #HANGUL SYLLABLE SSANGPIEUP E PIEUP
  {0x9689, 0xBEFE}, //3799 #HANGUL SYLLABLE SSANGPIEUP E PIEUPSIOS
  {0x968A, 0xBEFF}, //3800 #HANGUL SYLLABLE SSANGPIEUP E SIOS
  {0x968B, 0xBF00}, //3801 #HANGUL SYLLABLE SSANGPIEUP E SSANGSIOS
  {0x968C, 0xBF02}, //3802 #HANGUL SYLLABLE SSANGPIEUP E CIEUC
  {0x968D, 0xBF03}, //3803 #HANGUL SYLLABLE SSANGPIEUP E CHIEUCH
  {0x968E, 0xBF04}, //3804 #HANGUL SYLLABLE SSANGPIEUP E KHIEUKH
  {0x968F, 0xBF05}, //3805 #HANGUL SYLLABLE SSANGPIEUP E THIEUTH
  {0x9690, 0xBF06}, //3806 #HANGUL SYLLABLE SSANGPIEUP E PHIEUPH
  {0x9691, 0xBF07}, //3807 #HANGUL SYLLABLE SSANGPIEUP E HIEUH
  {0x9692, 0xBF0A}, //3808 #HANGUL SYLLABLE SSANGPIEUP YEO SSANGKIYEOK
  {0x9693, 0xBF0B}, //3809 #HANGUL SYLLABLE SSANGPIEUP YEO KIYEOKSIOS
  {0x9694, 0xBF0C}, //3810 #HANGUL SYLLABLE SSANGPIEUP YEO NIEUN
  {0x9695, 0xBF0D}, //3811 #HANGUL SYLLABLE SSANGPIEUP YEO NIEUNCIEUC
  {0x9696, 0xBF0E}, //3812 #HANGUL SYLLABLE SSANGPIEUP YEO NIEUNHIEUH
  {0x9697, 0xBF0F}, //3813 #HANGUL SYLLABLE SSANGPIEUP YEO TIKEUT
  {0x9698, 0xBF10}, //3814 #HANGUL SYLLABLE SSANGPIEUP YEO RIEUL
  {0x9699, 0xBF11}, //3815 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULKIYEOK
  {0x969A, 0xBF12}, //3816 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULMIEUM
  {0x969B, 0xBF13}, //3817 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULPIEUP
  {0x969C, 0xBF14}, //3818 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULSIOS
  {0x969D, 0xBF15}, //3819 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULTHIEUTH
  {0x969E, 0xBF16}, //3820 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULPHIEUPH
  {0x969F, 0xBF17}, //3821 #HANGUL SYLLABLE SSANGPIEUP YEO RIEULHIEUH
  {0x96A0, 0xBF1A}, //3822 #HANGUL SYLLABLE SSANGPIEUP YEO PIEUPSIOS
  {0x96A1, 0xBF1E}, //3823 #HANGUL SYLLABLE SSANGPIEUP YEO CIEUC
  {0x96A2, 0xBF1F}, //3824 #HANGUL SYLLABLE SSANGPIEUP YEO CHIEUCH
  {0x96A3, 0xBF20}, //3825 #HANGUL SYLLABLE SSANGPIEUP YEO KHIEUKH
  {0x96A4, 0xBF21}, //3826 #HANGUL SYLLABLE SSANGPIEUP YEO THIEUTH
  {0x96A5, 0xBF22}, //3827 #HANGUL SYLLABLE SSANGPIEUP YEO PHIEUPH
  {0x96A6, 0xBF23}, //3828 #HANGUL SYLLABLE SSANGPIEUP YEO HIEUH
  {0x96A7, 0xBF24}, //3829 #HANGUL SYLLABLE SSANGPIEUP YE
  {0x96A8, 0xBF25}, //3830 #HANGUL SYLLABLE SSANGPIEUP YE KIYEOK
  {0x96A9, 0xBF26}, //3831 #HANGUL SYLLABLE SSANGPIEUP YE SSANGKIYEOK
  {0x96AA, 0xBF27}, //3832 #HANGUL SYLLABLE SSANGPIEUP YE KIYEOKSIOS
  {0x96AB, 0xBF28}, //3833 #HANGUL SYLLABLE SSANGPIEUP YE NIEUN
  {0x96AC, 0xBF29}, //3834 #HANGUL SYLLABLE SSANGPIEUP YE NIEUNCIEUC
  {0x96AD, 0xBF2A}, //3835 #HANGUL SYLLABLE SSANGPIEUP YE NIEUNHIEUH
  {0x96AE, 0xBF2B}, //3836 #HANGUL SYLLABLE SSANGPIEUP YE TIKEUT
  {0x96AF, 0xBF2C}, //3837 #HANGUL SYLLABLE SSANGPIEUP YE RIEUL
  {0x96B0, 0xBF2D}, //3838 #HANGUL SYLLABLE SSANGPIEUP YE RIEULKIYEOK
  {0x96B1, 0xBF2E}, //3839 #HANGUL SYLLABLE SSANGPIEUP YE RIEULMIEUM
  {0x96B2, 0xBF2F}, //3840 #HANGUL SYLLABLE SSANGPIEUP YE RIEULPIEUP
  {0x96B3, 0xBF30}, //3841 #HANGUL SYLLABLE SSANGPIEUP YE RIEULSIOS
  {0x96B4, 0xBF31}, //3842 #HANGUL SYLLABLE SSANGPIEUP YE RIEULTHIEUTH
  {0x96B5, 0xBF32}, //3843 #HANGUL SYLLABLE SSANGPIEUP YE RIEULPHIEUPH
  {0x96B6, 0xBF33}, //3844 #HANGUL SYLLABLE SSANGPIEUP YE RIEULHIEUH
  {0x96B7, 0xBF34}, //3845 #HANGUL SYLLABLE SSANGPIEUP YE MIEUM
  {0x96B8, 0xBF35}, //3846 #HANGUL SYLLABLE SSANGPIEUP YE PIEUP
  {0x96B9, 0xBF36}, //3847 #HANGUL SYLLABLE SSANGPIEUP YE PIEUPSIOS
  {0x96BA, 0xBF37}, //3848 #HANGUL SYLLABLE SSANGPIEUP YE SIOS
  {0x96BB, 0xBF38}, //3849 #HANGUL SYLLABLE SSANGPIEUP YE SSANGSIOS
  {0x96BC, 0xBF39}, //3850 #HANGUL SYLLABLE SSANGPIEUP YE IEUNG
  {0x96BD, 0xBF3A}, //3851 #HANGUL SYLLABLE SSANGPIEUP YE CIEUC
  {0x96BE, 0xBF3B}, //3852 #HANGUL SYLLABLE SSANGPIEUP YE CHIEUCH
  {0x96BF, 0xBF3C}, //3853 #HANGUL SYLLABLE SSANGPIEUP YE KHIEUKH
  {0x96C0, 0xBF3D}, //3854 #HANGUL SYLLABLE SSANGPIEUP YE THIEUTH
  {0x96C1, 0xBF3E}, //3855 #HANGUL SYLLABLE SSANGPIEUP YE PHIEUPH
  {0x96C2, 0xBF3F}, //3856 #HANGUL SYLLABLE SSANGPIEUP YE HIEUH
  {0x96C3, 0xBF42}, //3857 #HANGUL SYLLABLE SSANGPIEUP O SSANGKIYEOK
  {0x96C4, 0xBF43}, //3858 #HANGUL SYLLABLE SSANGPIEUP O KIYEOKSIOS
  {0x96C5, 0xBF45}, //3859 #HANGUL SYLLABLE SSANGPIEUP O NIEUNCIEUC
  {0x96C6, 0xBF46}, //3860 #HANGUL SYLLABLE SSANGPIEUP O NIEUNHIEUH
  {0x96C7, 0xBF47}, //3861 #HANGUL SYLLABLE SSANGPIEUP O TIKEUT
  {0x96C8, 0xBF49}, //3862 #HANGUL SYLLABLE SSANGPIEUP O RIEULKIYEOK
  {0x96C9, 0xBF4A}, //3863 #HANGUL SYLLABLE SSANGPIEUP O RIEULMIEUM
  {0x96CA, 0xBF4B}, //3864 #HANGUL SYLLABLE SSANGPIEUP O RIEULPIEUP
  {0x96CB, 0xBF4C}, //3865 #HANGUL SYLLABLE SSANGPIEUP O RIEULSIOS
  {0x96CC, 0xBF4D}, //3866 #HANGUL SYLLABLE SSANGPIEUP O RIEULTHIEUTH
  {0x96CD, 0xBF4E}, //3867 #HANGUL SYLLABLE SSANGPIEUP O RIEULPHIEUPH
  {0x96CE, 0xBF4F}, //3868 #HANGUL SYLLABLE SSANGPIEUP O RIEULHIEUH
  {0x96CF, 0xBF52}, //3869 #HANGUL SYLLABLE SSANGPIEUP O PIEUPSIOS
  {0x96D0, 0xBF53}, //3870 #HANGUL SYLLABLE SSANGPIEUP O SIOS
  {0x96D1, 0xBF54}, //3871 #HANGUL SYLLABLE SSANGPIEUP O SSANGSIOS
  {0x96D2, 0xBF56}, //3872 #HANGUL SYLLABLE SSANGPIEUP O CIEUC
  {0x96D3, 0xBF57}, //3873 #HANGUL SYLLABLE SSANGPIEUP O CHIEUCH
  {0x96D4, 0xBF58}, //3874 #HANGUL SYLLABLE SSANGPIEUP O KHIEUKH
  {0x96D5, 0xBF59}, //3875 #HANGUL SYLLABLE SSANGPIEUP O THIEUTH
  {0x96D6, 0xBF5A}, //3876 #HANGUL SYLLABLE SSANGPIEUP O PHIEUPH
  {0x96D7, 0xBF5B}, //3877 #HANGUL SYLLABLE SSANGPIEUP O HIEUH
  {0x96D8, 0xBF5C}, //3878 #HANGUL SYLLABLE SSANGPIEUP WA
  {0x96D9, 0xBF5D}, //3879 #HANGUL SYLLABLE SSANGPIEUP WA KIYEOK
  {0x96DA, 0xBF5E}, //3880 #HANGUL SYLLABLE SSANGPIEUP WA SSANGKIYEOK
  {0x96DB, 0xBF5F}, //3881 #HANGUL SYLLABLE SSANGPIEUP WA KIYEOKSIOS
  {0x96DC, 0xBF60}, //3882 #HANGUL SYLLABLE SSANGPIEUP WA NIEUN
  {0x96DD, 0xBF61}, //3883 #HANGUL SYLLABLE SSANGPIEUP WA NIEUNCIEUC
  {0x96DE, 0xBF62}, //3884 #HANGUL SYLLABLE SSANGPIEUP WA NIEUNHIEUH
  {0x96DF, 0xBF63}, //3885 #HANGUL SYLLABLE SSANGPIEUP WA TIKEUT
  {0x96E0, 0xBF64}, //3886 #HANGUL SYLLABLE SSANGPIEUP WA RIEUL
  {0x96E1, 0xBF65}, //3887 #HANGUL SYLLABLE SSANGPIEUP WA RIEULKIYEOK
  {0x96E2, 0xBF66}, //3888 #HANGUL SYLLABLE SSANGPIEUP WA RIEULMIEUM
  {0x96E3, 0xBF67}, //3889 #HANGUL SYLLABLE SSANGPIEUP WA RIEULPIEUP
  {0x96E4, 0xBF68}, //3890 #HANGUL SYLLABLE SSANGPIEUP WA RIEULSIOS
  {0x96E5, 0xBF69}, //3891 #HANGUL SYLLABLE SSANGPIEUP WA RIEULTHIEUTH
  {0x96E6, 0xBF6A}, //3892 #HANGUL SYLLABLE SSANGPIEUP WA RIEULPHIEUPH
  {0x96E7, 0xBF6B}, //3893 #HANGUL SYLLABLE SSANGPIEUP WA RIEULHIEUH
  {0x96E8, 0xBF6C}, //3894 #HANGUL SYLLABLE SSANGPIEUP WA MIEUM
  {0x96E9, 0xBF6D}, //3895 #HANGUL SYLLABLE SSANGPIEUP WA PIEUP
  {0x96EA, 0xBF6E}, //3896 #HANGUL SYLLABLE SSANGPIEUP WA PIEUPSIOS
  {0x96EB, 0xBF6F}, //3897 #HANGUL SYLLABLE SSANGPIEUP WA SIOS
  {0x96EC, 0xBF70}, //3898 #HANGUL SYLLABLE SSANGPIEUP WA SSANGSIOS
  {0x96ED, 0xBF71}, //3899 #HANGUL SYLLABLE SSANGPIEUP WA IEUNG
  {0x96EE, 0xBF72}, //3900 #HANGUL SYLLABLE SSANGPIEUP WA CIEUC
  {0x96EF, 0xBF73}, //3901 #HANGUL SYLLABLE SSANGPIEUP WA CHIEUCH
  {0x96F0, 0xBF74}, //3902 #HANGUL SYLLABLE SSANGPIEUP WA KHIEUKH
  {0x96F1, 0xBF75}, //3903 #HANGUL SYLLABLE SSANGPIEUP WA THIEUTH
  {0x96F2, 0xBF76}, //3904 #HANGUL SYLLABLE SSANGPIEUP WA PHIEUPH
  {0x96F3, 0xBF77}, //3905 #HANGUL SYLLABLE SSANGPIEUP WA HIEUH
  {0x96F4, 0xBF78}, //3906 #HANGUL SYLLABLE SSANGPIEUP WAE
  {0x96F5, 0xBF79}, //3907 #HANGUL SYLLABLE SSANGPIEUP WAE KIYEOK
  {0x96F6, 0xBF7A}, //3908 #HANGUL SYLLABLE SSANGPIEUP WAE SSANGKIYEOK
  {0x96F7, 0xBF7B}, //3909 #HANGUL SYLLABLE SSANGPIEUP WAE KIYEOKSIOS
  {0x96F8, 0xBF7C}, //3910 #HANGUL SYLLABLE SSANGPIEUP WAE NIEUN
  {0x96F9, 0xBF7D}, //3911 #HANGUL SYLLABLE SSANGPIEUP WAE NIEUNCIEUC
  {0x96FA, 0xBF7E}, //3912 #HANGUL SYLLABLE SSANGPIEUP WAE NIEUNHIEUH
  {0x96FB, 0xBF7F}, //3913 #HANGUL SYLLABLE SSANGPIEUP WAE TIKEUT
  {0x96FC, 0xBF80}, //3914 #HANGUL SYLLABLE SSANGPIEUP WAE RIEUL
  {0x96FD, 0xBF81}, //3915 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULKIYEOK
  {0x96FE, 0xBF82}, //3916 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULMIEUM
  {0x9741, 0xBF83}, //3917 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULPIEUP
  {0x9742, 0xBF84}, //3918 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULSIOS
  {0x9743, 0xBF85}, //3919 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULTHIEUTH
  {0x9744, 0xBF86}, //3920 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULPHIEUPH
  {0x9745, 0xBF87}, //3921 #HANGUL SYLLABLE SSANGPIEUP WAE RIEULHIEUH
  {0x9746, 0xBF88}, //3922 #HANGUL SYLLABLE SSANGPIEUP WAE MIEUM
  {0x9747, 0xBF89}, //3923 #HANGUL SYLLABLE SSANGPIEUP WAE PIEUP
  {0x9748, 0xBF8A}, //3924 #HANGUL SYLLABLE SSANGPIEUP WAE PIEUPSIOS
  {0x9749, 0xBF8B}, //3925 #HANGUL SYLLABLE SSANGPIEUP WAE SIOS
  {0x974A, 0xBF8C}, //3926 #HANGUL SYLLABLE SSANGPIEUP WAE SSANGSIOS
  {0x974B, 0xBF8D}, //3927 #HANGUL SYLLABLE SSANGPIEUP WAE IEUNG
  {0x974C, 0xBF8E}, //3928 #HANGUL SYLLABLE SSANGPIEUP WAE CIEUC
  {0x974D, 0xBF8F}, //3929 #HANGUL SYLLABLE SSANGPIEUP WAE CHIEUCH
  {0x974E, 0xBF90}, //3930 #HANGUL SYLLABLE SSANGPIEUP WAE KHIEUKH
  {0x974F, 0xBF91}, //3931 #HANGUL SYLLABLE SSANGPIEUP WAE THIEUTH
  {0x9750, 0xBF92}, //3932 #HANGUL SYLLABLE SSANGPIEUP WAE PHIEUPH
  {0x9751, 0xBF93}, //3933 #HANGUL SYLLABLE SSANGPIEUP WAE HIEUH
  {0x9752, 0xBF95}, //3934 #HANGUL SYLLABLE SSANGPIEUP OE KIYEOK
  {0x9753, 0xBF96}, //3935 #HANGUL SYLLABLE SSANGPIEUP OE SSANGKIYEOK
  {0x9754, 0xBF97}, //3936 #HANGUL SYLLABLE SSANGPIEUP OE KIYEOKSIOS
  {0x9755, 0xBF98}, //3937 #HANGUL SYLLABLE SSANGPIEUP OE NIEUN
  {0x9756, 0xBF99}, //3938 #HANGUL SYLLABLE SSANGPIEUP OE NIEUNCIEUC
  {0x9757, 0xBF9A}, //3939 #HANGUL SYLLABLE SSANGPIEUP OE NIEUNHIEUH
  {0x9758, 0xBF9B}, //3940 #HANGUL SYLLABLE SSANGPIEUP OE TIKEUT
  {0x9759, 0xBF9C}, //3941 #HANGUL SYLLABLE SSANGPIEUP OE RIEUL
  {0x975A, 0xBF9D}, //3942 #HANGUL SYLLABLE SSANGPIEUP OE RIEULKIYEOK
  {0x9761, 0xBF9E}, //3943 #HANGUL SYLLABLE SSANGPIEUP OE RIEULMIEUM
  {0x9762, 0xBF9F}, //3944 #HANGUL SYLLABLE SSANGPIEUP OE RIEULPIEUP
  {0x9763, 0xBFA0}, //3945 #HANGUL SYLLABLE SSANGPIEUP OE RIEULSIOS
  {0x9764, 0xBFA1}, //3946 #HANGUL SYLLABLE SSANGPIEUP OE RIEULTHIEUTH
  {0x9765, 0xBFA2}, //3947 #HANGUL SYLLABLE SSANGPIEUP OE RIEULPHIEUPH
  {0x9766, 0xBFA3}, //3948 #HANGUL SYLLABLE SSANGPIEUP OE RIEULHIEUH
  {0x9767, 0xBFA4}, //3949 #HANGUL SYLLABLE SSANGPIEUP OE MIEUM
  {0x9768, 0xBFA5}, //3950 #HANGUL SYLLABLE SSANGPIEUP OE PIEUP
  {0x9769, 0xBFA6}, //3951 #HANGUL SYLLABLE SSANGPIEUP OE PIEUPSIOS
  {0x976A, 0xBFA7}, //3952 #HANGUL SYLLABLE SSANGPIEUP OE SIOS
  {0x976B, 0xBFA8}, //3953 #HANGUL SYLLABLE SSANGPIEUP OE SSANGSIOS
  {0x976C, 0xBFA9}, //3954 #HANGUL SYLLABLE SSANGPIEUP OE IEUNG
  {0x976D, 0xBFAA}, //3955 #HANGUL SYLLABLE SSANGPIEUP OE CIEUC
  {0x976E, 0xBFAB}, //3956 #HANGUL SYLLABLE SSANGPIEUP OE CHIEUCH
  {0x976F, 0xBFAC}, //3957 #HANGUL SYLLABLE SSANGPIEUP OE KHIEUKH
  {0x9770, 0xBFAD}, //3958 #HANGUL SYLLABLE SSANGPIEUP OE THIEUTH
  {0x9771, 0xBFAE}, //3959 #HANGUL SYLLABLE SSANGPIEUP OE PHIEUPH
  {0x9772, 0xBFAF}, //3960 #HANGUL SYLLABLE SSANGPIEUP OE HIEUH
  {0x9773, 0xBFB1}, //3961 #HANGUL SYLLABLE SSANGPIEUP YO KIYEOK
  {0x9774, 0xBFB2}, //3962 #HANGUL SYLLABLE SSANGPIEUP YO SSANGKIYEOK
  {0x9775, 0xBFB3}, //3963 #HANGUL SYLLABLE SSANGPIEUP YO KIYEOKSIOS
  {0x9776, 0xBFB4}, //3964 #HANGUL SYLLABLE SSANGPIEUP YO NIEUN
  {0x9777, 0xBFB5}, //3965 #HANGUL SYLLABLE SSANGPIEUP YO NIEUNCIEUC
  {0x9778, 0xBFB6}, //3966 #HANGUL SYLLABLE SSANGPIEUP YO NIEUNHIEUH
  {0x9779, 0xBFB7}, //3967 #HANGUL SYLLABLE SSANGPIEUP YO TIKEUT
  {0x977A, 0xBFB8}, //3968 #HANGUL SYLLABLE SSANGPIEUP YO RIEUL
  {0x9781, 0xBFB9}, //3969 #HANGUL SYLLABLE SSANGPIEUP YO RIEULKIYEOK
  {0x9782, 0xBFBA}, //3970 #HANGUL SYLLABLE SSANGPIEUP YO RIEULMIEUM
  {0x9783, 0xBFBB}, //3971 #HANGUL SYLLABLE SSANGPIEUP YO RIEULPIEUP
  {0x9784, 0xBFBC}, //3972 #HANGUL SYLLABLE SSANGPIEUP YO RIEULSIOS
  {0x9785, 0xBFBD}, //3973 #HANGUL SYLLABLE SSANGPIEUP YO RIEULTHIEUTH
  {0x9786, 0xBFBE}, //3974 #HANGUL SYLLABLE SSANGPIEUP YO RIEULPHIEUPH
  {0x9787, 0xBFBF}, //3975 #HANGUL SYLLABLE SSANGPIEUP YO RIEULHIEUH
  {0x9788, 0xBFC0}, //3976 #HANGUL SYLLABLE SSANGPIEUP YO MIEUM
  {0x9789, 0xBFC1}, //3977 #HANGUL SYLLABLE SSANGPIEUP YO PIEUP
  {0x978A, 0xBFC2}, //3978 #HANGUL SYLLABLE SSANGPIEUP YO PIEUPSIOS
  {0x978B, 0xBFC3}, //3979 #HANGUL SYLLABLE SSANGPIEUP YO SIOS
  {0x978C, 0xBFC4}, //3980 #HANGUL SYLLABLE SSANGPIEUP YO SSANGSIOS
  {0x978D, 0xBFC6}, //3981 #HANGUL SYLLABLE SSANGPIEUP YO CIEUC
  {0x978E, 0xBFC7}, //3982 #HANGUL SYLLABLE SSANGPIEUP YO CHIEUCH
  {0x978F, 0xBFC8}, //3983 #HANGUL SYLLABLE SSANGPIEUP YO KHIEUKH
  {0x9790, 0xBFC9}, //3984 #HANGUL SYLLABLE SSANGPIEUP YO THIEUTH
  {0x9791, 0xBFCA}, //3985 #HANGUL SYLLABLE SSANGPIEUP YO PHIEUPH
  {0x9792, 0xBFCB}, //3986 #HANGUL SYLLABLE SSANGPIEUP YO HIEUH
  {0x9793, 0xBFCE}, //3987 #HANGUL SYLLABLE SSANGPIEUP U SSANGKIYEOK
  {0x9794, 0xBFCF}, //3988 #HANGUL SYLLABLE SSANGPIEUP U KIYEOKSIOS
  {0x9795, 0xBFD1}, //3989 #HANGUL SYLLABLE SSANGPIEUP U NIEUNCIEUC
  {0x9796, 0xBFD2}, //3990 #HANGUL SYLLABLE SSANGPIEUP U NIEUNHIEUH
  {0x9797, 0xBFD3}, //3991 #HANGUL SYLLABLE SSANGPIEUP U TIKEUT
  {0x9798, 0xBFD5}, //3992 #HANGUL SYLLABLE SSANGPIEUP U RIEULKIYEOK
  {0x9799, 0xBFD6}, //3993 #HANGUL SYLLABLE SSANGPIEUP U RIEULMIEUM
  {0x979A, 0xBFD7}, //3994 #HANGUL SYLLABLE SSANGPIEUP U RIEULPIEUP
  {0x979B, 0xBFD8}, //3995 #HANGUL SYLLABLE SSANGPIEUP U RIEULSIOS
  {0x979C, 0xBFD9}, //3996 #HANGUL SYLLABLE SSANGPIEUP U RIEULTHIEUTH
  {0x979D, 0xBFDA}, //3997 #HANGUL SYLLABLE SSANGPIEUP U RIEULPHIEUPH
  {0x979E, 0xBFDB}, //3998 #HANGUL SYLLABLE SSANGPIEUP U RIEULHIEUH
  {0x979F, 0xBFDD}, //3999 #HANGUL SYLLABLE SSANGPIEUP U PIEUP
  {0x97A0, 0xBFDE}, //4000 #HANGUL SYLLABLE SSANGPIEUP U PIEUPSIOS
  {0x97A1, 0xBFE0}, //4001 #HANGUL SYLLABLE SSANGPIEUP U SSANGSIOS
  {0x97A2, 0xBFE2}, //4002 #HANGUL SYLLABLE SSANGPIEUP U CIEUC
  {0x97A3, 0xBFE3}, //4003 #HANGUL SYLLABLE SSANGPIEUP U CHIEUCH
  {0x97A4, 0xBFE4}, //4004 #HANGUL SYLLABLE SSANGPIEUP U KHIEUKH
  {0x97A5, 0xBFE5}, //4005 #HANGUL SYLLABLE SSANGPIEUP U THIEUTH
  {0x97A6, 0xBFE6}, //4006 #HANGUL SYLLABLE SSANGPIEUP U PHIEUPH
  {0x97A7, 0xBFE7}, //4007 #HANGUL SYLLABLE SSANGPIEUP U HIEUH
  {0x97A8, 0xBFE8}, //4008 #HANGUL SYLLABLE SSANGPIEUP WEO
  {0x97A9, 0xBFE9}, //4009 #HANGUL SYLLABLE SSANGPIEUP WEO KIYEOK
  {0x97AA, 0xBFEA}, //4010 #HANGUL SYLLABLE SSANGPIEUP WEO SSANGKIYEOK
  {0x97AB, 0xBFEB}, //4011 #HANGUL SYLLABLE SSANGPIEUP WEO KIYEOKSIOS
  {0x97AC, 0xBFEC}, //4012 #HANGUL SYLLABLE SSANGPIEUP WEO NIEUN
  {0x97AD, 0xBFED}, //4013 #HANGUL SYLLABLE SSANGPIEUP WEO NIEUNCIEUC
  {0x97AE, 0xBFEE}, //4014 #HANGUL SYLLABLE SSANGPIEUP WEO NIEUNHIEUH
  {0x97AF, 0xBFEF}, //4015 #HANGUL SYLLABLE SSANGPIEUP WEO TIKEUT
  {0x97B0, 0xBFF0}, //4016 #HANGUL SYLLABLE SSANGPIEUP WEO RIEUL
  {0x97B1, 0xBFF1}, //4017 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULKIYEOK
  {0x97B2, 0xBFF2}, //4018 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULMIEUM
  {0x97B3, 0xBFF3}, //4019 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULPIEUP
  {0x97B4, 0xBFF4}, //4020 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULSIOS
  {0x97B5, 0xBFF5}, //4021 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULTHIEUTH
  {0x97B6, 0xBFF6}, //4022 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULPHIEUPH
  {0x97B7, 0xBFF7}, //4023 #HANGUL SYLLABLE SSANGPIEUP WEO RIEULHIEUH
  {0x97B8, 0xBFF8}, //4024 #HANGUL SYLLABLE SSANGPIEUP WEO MIEUM
  {0x97B9, 0xBFF9}, //4025 #HANGUL SYLLABLE SSANGPIEUP WEO PIEUP
  {0x97BA, 0xBFFA}, //4026 #HANGUL SYLLABLE SSANGPIEUP WEO PIEUPSIOS
  {0x97BB, 0xBFFB}, //4027 #HANGUL SYLLABLE SSANGPIEUP WEO SIOS
  {0x97BC, 0xBFFC}, //4028 #HANGUL SYLLABLE SSANGPIEUP WEO SSANGSIOS
  {0x97BD, 0xBFFD}, //4029 #HANGUL SYLLABLE SSANGPIEUP WEO IEUNG
  {0x97BE, 0xBFFE}, //4030 #HANGUL SYLLABLE SSANGPIEUP WEO CIEUC
  {0x97BF, 0xBFFF}, //4031 #HANGUL SYLLABLE SSANGPIEUP WEO CHIEUCH
  {0x97C0, 0xC000}, //4032 #HANGUL SYLLABLE SSANGPIEUP WEO KHIEUKH
  {0x97C1, 0xC001}, //4033 #HANGUL SYLLABLE SSANGPIEUP WEO THIEUTH
  {0x97C2, 0xC002}, //4034 #HANGUL SYLLABLE SSANGPIEUP WEO PHIEUPH
  {0x97C3, 0xC003}, //4035 #HANGUL SYLLABLE SSANGPIEUP WEO HIEUH
  {0x97C4, 0xC004}, //4036 #HANGUL SYLLABLE SSANGPIEUP WE
  {0x97C5, 0xC005}, //4037 #HANGUL SYLLABLE SSANGPIEUP WE KIYEOK
  {0x97C6, 0xC006}, //4038 #HANGUL SYLLABLE SSANGPIEUP WE SSANGKIYEOK
  {0x97C7, 0xC007}, //4039 #HANGUL SYLLABLE SSANGPIEUP WE KIYEOKSIOS
  {0x97C8, 0xC008}, //4040 #HANGUL SYLLABLE SSANGPIEUP WE NIEUN
  {0x97C9, 0xC009}, //4041 #HANGUL SYLLABLE SSANGPIEUP WE NIEUNCIEUC
  {0x97CA, 0xC00A}, //4042 #HANGUL SYLLABLE SSANGPIEUP WE NIEUNHIEUH
  {0x97CB, 0xC00B}, //4043 #HANGUL SYLLABLE SSANGPIEUP WE TIKEUT
  {0x97CC, 0xC00C}, //4044 #HANGUL SYLLABLE SSANGPIEUP WE RIEUL
  {0x97CD, 0xC00D}, //4045 #HANGUL SYLLABLE SSANGPIEUP WE RIEULKIYEOK
  {0x97CE, 0xC00E}, //4046 #HANGUL SYLLABLE SSANGPIEUP WE RIEULMIEUM
  {0x97CF, 0xC00F}, //4047 #HANGUL SYLLABLE SSANGPIEUP WE RIEULPIEUP
  {0x97D0, 0xC010}, //4048 #HANGUL SYLLABLE SSANGPIEUP WE RIEULSIOS
  {0x97D1, 0xC011}, //4049 #HANGUL SYLLABLE SSANGPIEUP WE RIEULTHIEUTH
  {0x97D2, 0xC012}, //4050 #HANGUL SYLLABLE SSANGPIEUP WE RIEULPHIEUPH
  {0x97D3, 0xC013}, //4051 #HANGUL SYLLABLE SSANGPIEUP WE RIEULHIEUH
  {0x97D4, 0xC014}, //4052 #HANGUL SYLLABLE SSANGPIEUP WE MIEUM
  {0x97D5, 0xC015}, //4053 #HANGUL SYLLABLE SSANGPIEUP WE PIEUP
  {0x97D6, 0xC016}, //4054 #HANGUL SYLLABLE SSANGPIEUP WE PIEUPSIOS
  {0x97D7, 0xC017}, //4055 #HANGUL SYLLABLE SSANGPIEUP WE SIOS
  {0x97D8, 0xC018}, //4056 #HANGUL SYLLABLE SSANGPIEUP WE SSANGSIOS
  {0x97D9, 0xC019}, //4057 #HANGUL SYLLABLE SSANGPIEUP WE IEUNG
  {0x97DA, 0xC01A}, //4058 #HANGUL SYLLABLE SSANGPIEUP WE CIEUC
  {0x97DB, 0xC01B}, //4059 #HANGUL SYLLABLE SSANGPIEUP WE CHIEUCH
  {0x97DC, 0xC01C}, //4060 #HANGUL SYLLABLE SSANGPIEUP WE KHIEUKH
  {0x97DD, 0xC01D}, //4061 #HANGUL SYLLABLE SSANGPIEUP WE THIEUTH
  {0x97DE, 0xC01E}, //4062 #HANGUL SYLLABLE SSANGPIEUP WE PHIEUPH
  {0x97DF, 0xC01F}, //4063 #HANGUL SYLLABLE SSANGPIEUP WE HIEUH
  {0x97E0, 0xC020}, //4064 #HANGUL SYLLABLE SSANGPIEUP WI
  {0x97E1, 0xC021}, //4065 #HANGUL SYLLABLE SSANGPIEUP WI KIYEOK
  {0x97E2, 0xC022}, //4066 #HANGUL SYLLABLE SSANGPIEUP WI SSANGKIYEOK
  {0x97E3, 0xC023}, //4067 #HANGUL SYLLABLE SSANGPIEUP WI KIYEOKSIOS
  {0x97E4, 0xC024}, //4068 #HANGUL SYLLABLE SSANGPIEUP WI NIEUN
  {0x97E5, 0xC025}, //4069 #HANGUL SYLLABLE SSANGPIEUP WI NIEUNCIEUC
  {0x97E6, 0xC026}, //4070 #HANGUL SYLLABLE SSANGPIEUP WI NIEUNHIEUH
  {0x97E7, 0xC027}, //4071 #HANGUL SYLLABLE SSANGPIEUP WI TIKEUT
  {0x97E8, 0xC028}, //4072 #HANGUL SYLLABLE SSANGPIEUP WI RIEUL
  {0x97E9, 0xC029}, //4073 #HANGUL SYLLABLE SSANGPIEUP WI RIEULKIYEOK
  {0x97EA, 0xC02A}, //4074 #HANGUL SYLLABLE SSANGPIEUP WI RIEULMIEUM
  {0x97EB, 0xC02B}, //4075 #HANGUL SYLLABLE SSANGPIEUP WI RIEULPIEUP
  {0x97EC, 0xC02C}, //4076 #HANGUL SYLLABLE SSANGPIEUP WI RIEULSIOS
  {0x97ED, 0xC02D}, //4077 #HANGUL SYLLABLE SSANGPIEUP WI RIEULTHIEUTH
  {0x97EE, 0xC02E}, //4078 #HANGUL SYLLABLE SSANGPIEUP WI RIEULPHIEUPH
  {0x97EF, 0xC02F}, //4079 #HANGUL SYLLABLE SSANGPIEUP WI RIEULHIEUH
  {0x97F0, 0xC030}, //4080 #HANGUL SYLLABLE SSANGPIEUP WI MIEUM
  {0x97F1, 0xC031}, //4081 #HANGUL SYLLABLE SSANGPIEUP WI PIEUP
  {0x97F2, 0xC032}, //4082 #HANGUL SYLLABLE SSANGPIEUP WI PIEUPSIOS
  {0x97F3, 0xC033}, //4083 #HANGUL SYLLABLE SSANGPIEUP WI SIOS
  {0x97F4, 0xC034}, //4084 #HANGUL SYLLABLE SSANGPIEUP WI SSANGSIOS
  {0x97F5, 0xC035}, //4085 #HANGUL SYLLABLE SSANGPIEUP WI IEUNG
  {0x97F6, 0xC036}, //4086 #HANGUL SYLLABLE SSANGPIEUP WI CIEUC
  {0x97F7, 0xC037}, //4087 #HANGUL SYLLABLE SSANGPIEUP WI CHIEUCH
  {0x97F8, 0xC038}, //4088 #HANGUL SYLLABLE SSANGPIEUP WI KHIEUKH
  {0x97F9, 0xC039}, //4089 #HANGUL SYLLABLE SSANGPIEUP WI THIEUTH
  {0x97FA, 0xC03A}, //4090 #HANGUL SYLLABLE SSANGPIEUP WI PHIEUPH
  {0x97FB, 0xC03B}, //4091 #HANGUL SYLLABLE SSANGPIEUP WI HIEUH
  {0x97FC, 0xC03D}, //4092 #HANGUL SYLLABLE SSANGPIEUP YU KIYEOK
  {0x97FD, 0xC03E}, //4093 #HANGUL SYLLABLE SSANGPIEUP YU SSANGKIYEOK
  {0x97FE, 0xC03F}, //4094 #HANGUL SYLLABLE SSANGPIEUP YU KIYEOKSIOS
  {0x9841, 0xC040}, //4095 #HANGUL SYLLABLE SSANGPIEUP YU NIEUN
  {0x9842, 0xC041}, //4096 #HANGUL SYLLABLE SSANGPIEUP YU NIEUNCIEUC
  {0x9843, 0xC042}, //4097 #HANGUL SYLLABLE SSANGPIEUP YU NIEUNHIEUH
  {0x9844, 0xC043}, //4098 #HANGUL SYLLABLE SSANGPIEUP YU TIKEUT
  {0x9845, 0xC044}, //4099 #HANGUL SYLLABLE SSANGPIEUP YU RIEUL
  {0x9846, 0xC045}, //4100 #HANGUL SYLLABLE SSANGPIEUP YU RIEULKIYEOK
  {0x9847, 0xC046}, //4101 #HANGUL SYLLABLE SSANGPIEUP YU RIEULMIEUM
  {0x9848, 0xC047}, //4102 #HANGUL SYLLABLE SSANGPIEUP YU RIEULPIEUP
  {0x9849, 0xC048}, //4103 #HANGUL SYLLABLE SSANGPIEUP YU RIEULSIOS
  {0x984A, 0xC049}, //4104 #HANGUL SYLLABLE SSANGPIEUP YU RIEULTHIEUTH
  {0x984B, 0xC04A}, //4105 #HANGUL SYLLABLE SSANGPIEUP YU RIEULPHIEUPH
  {0x984C, 0xC04B}, //4106 #HANGUL SYLLABLE SSANGPIEUP YU RIEULHIEUH
  {0x984D, 0xC04C}, //4107 #HANGUL SYLLABLE SSANGPIEUP YU MIEUM
  {0x984E, 0xC04D}, //4108 #HANGUL SYLLABLE SSANGPIEUP YU PIEUP
  {0x984F, 0xC04E}, //4109 #HANGUL SYLLABLE SSANGPIEUP YU PIEUPSIOS
  {0x9850, 0xC04F}, //4110 #HANGUL SYLLABLE SSANGPIEUP YU SIOS
  {0x9851, 0xC050}, //4111 #HANGUL SYLLABLE SSANGPIEUP YU SSANGSIOS
  {0x9852, 0xC052}, //4112 #HANGUL SYLLABLE SSANGPIEUP YU CIEUC
  {0x9853, 0xC053}, //4113 #HANGUL SYLLABLE SSANGPIEUP YU CHIEUCH
  {0x9854, 0xC054}, //4114 #HANGUL SYLLABLE SSANGPIEUP YU KHIEUKH
  {0x9855, 0xC055}, //4115 #HANGUL SYLLABLE SSANGPIEUP YU THIEUTH
  {0x9856, 0xC056}, //4116 #HANGUL SYLLABLE SSANGPIEUP YU PHIEUPH
  {0x9857, 0xC057}, //4117 #HANGUL SYLLABLE SSANGPIEUP YU HIEUH
  {0x9858, 0xC059}, //4118 #HANGUL SYLLABLE SSANGPIEUP EU KIYEOK
  {0x9859, 0xC05A}, //4119 #HANGUL SYLLABLE SSANGPIEUP EU SSANGKIYEOK
  {0x985A, 0xC05B}, //4120 #HANGUL SYLLABLE SSANGPIEUP EU KIYEOKSIOS
  {0x9861, 0xC05D}, //4121 #HANGUL SYLLABLE SSANGPIEUP EU NIEUNCIEUC
  {0x9862, 0xC05E}, //4122 #HANGUL SYLLABLE SSANGPIEUP EU NIEUNHIEUH
  {0x9863, 0xC05F}, //4123 #HANGUL SYLLABLE SSANGPIEUP EU TIKEUT
  {0x9864, 0xC061}, //4124 #HANGUL SYLLABLE SSANGPIEUP EU RIEULKIYEOK
  {0x9865, 0xC062}, //4125 #HANGUL SYLLABLE SSANGPIEUP EU RIEULMIEUM
  {0x9866, 0xC063}, //4126 #HANGUL SYLLABLE SSANGPIEUP EU RIEULPIEUP
  {0x9867, 0xC064}, //4127 #HANGUL SYLLABLE SSANGPIEUP EU RIEULSIOS
  {0x9868, 0xC065}, //4128 #HANGUL SYLLABLE SSANGPIEUP EU RIEULTHIEUTH
  {0x9869, 0xC066}, //4129 #HANGUL SYLLABLE SSANGPIEUP EU RIEULPHIEUPH
  {0x986A, 0xC067}, //4130 #HANGUL SYLLABLE SSANGPIEUP EU RIEULHIEUH
  {0x986B, 0xC06A}, //4131 #HANGUL SYLLABLE SSANGPIEUP EU PIEUPSIOS
  {0x986C, 0xC06B}, //4132 #HANGUL SYLLABLE SSANGPIEUP EU SIOS
  {0x986D, 0xC06C}, //4133 #HANGUL SYLLABLE SSANGPIEUP EU SSANGSIOS
  {0x986E, 0xC06D}, //4134 #HANGUL SYLLABLE SSANGPIEUP EU IEUNG
  {0x986F, 0xC06E}, //4135 #HANGUL SYLLABLE SSANGPIEUP EU CIEUC
  {0x9870, 0xC06F}, //4136 #HANGUL SYLLABLE SSANGPIEUP EU CHIEUCH
  {0x9871, 0xC070}, //4137 #HANGUL SYLLABLE SSANGPIEUP EU KHIEUKH
  {0x9872, 0xC071}, //4138 #HANGUL SYLLABLE SSANGPIEUP EU THIEUTH
  {0x9873, 0xC072}, //4139 #HANGUL SYLLABLE SSANGPIEUP EU PHIEUPH
  {0x9874, 0xC073}, //4140 #HANGUL SYLLABLE SSANGPIEUP EU HIEUH
  {0x9875, 0xC074}, //4141 #HANGUL SYLLABLE SSANGPIEUP YI
  {0x9876, 0xC075}, //4142 #HANGUL SYLLABLE SSANGPIEUP YI KIYEOK
  {0x9877, 0xC076}, //4143 #HANGUL SYLLABLE SSANGPIEUP YI SSANGKIYEOK
  {0x9878, 0xC077}, //4144 #HANGUL SYLLABLE SSANGPIEUP YI KIYEOKSIOS
  {0x9879, 0xC078}, //4145 #HANGUL SYLLABLE SSANGPIEUP YI NIEUN
  {0x987A, 0xC079}, //4146 #HANGUL SYLLABLE SSANGPIEUP YI NIEUNCIEUC
  {0x9881, 0xC07A}, //4147 #HANGUL SYLLABLE SSANGPIEUP YI NIEUNHIEUH
  {0x9882, 0xC07B}, //4148 #HANGUL SYLLABLE SSANGPIEUP YI TIKEUT
  {0x9883, 0xC07C}, //4149 #HANGUL SYLLABLE SSANGPIEUP YI RIEUL
  {0x9884, 0xC07D}, //4150 #HANGUL SYLLABLE SSANGPIEUP YI RIEULKIYEOK
  {0x9885, 0xC07E}, //4151 #HANGUL SYLLABLE SSANGPIEUP YI RIEULMIEUM
  {0x9886, 0xC07F}, //4152 #HANGUL SYLLABLE SSANGPIEUP YI RIEULPIEUP
  {0x9887, 0xC080}, //4153 #HANGUL SYLLABLE SSANGPIEUP YI RIEULSIOS
  {0x9888, 0xC081}, //4154 #HANGUL SYLLABLE SSANGPIEUP YI RIEULTHIEUTH
  {0x9889, 0xC082}, //4155 #HANGUL SYLLABLE SSANGPIEUP YI RIEULPHIEUPH
  {0x988A, 0xC083}, //4156 #HANGUL SYLLABLE SSANGPIEUP YI RIEULHIEUH
  {0x988B, 0xC084}, //4157 #HANGUL SYLLABLE SSANGPIEUP YI MIEUM
  {0x988C, 0xC085}, //4158 #HANGUL SYLLABLE SSANGPIEUP YI PIEUP
  {0x988D, 0xC086}, //4159 #HANGUL SYLLABLE SSANGPIEUP YI PIEUPSIOS
  {0x988E, 0xC087}, //4160 #HANGUL SYLLABLE SSANGPIEUP YI SIOS
  {0x988F, 0xC088}, //4161 #HANGUL SYLLABLE SSANGPIEUP YI SSANGSIOS
  {0x9890, 0xC089}, //4162 #HANGUL SYLLABLE SSANGPIEUP YI IEUNG
  {0x9891, 0xC08A}, //4163 #HANGUL SYLLABLE SSANGPIEUP YI CIEUC
  {0x9892, 0xC08B}, //4164 #HANGUL SYLLABLE SSANGPIEUP YI CHIEUCH
  {0x9893, 0xC08C}, //4165 #HANGUL SYLLABLE SSANGPIEUP YI KHIEUKH
  {0x9894, 0xC08D}, //4166 #HANGUL SYLLABLE SSANGPIEUP YI THIEUTH
  {0x9895, 0xC08E}, //4167 #HANGUL SYLLABLE SSANGPIEUP YI PHIEUPH
  {0x9896, 0xC08F}, //4168 #HANGUL SYLLABLE SSANGPIEUP YI HIEUH
  {0x9897, 0xC092}, //4169 #HANGUL SYLLABLE SSANGPIEUP I SSANGKIYEOK
  {0x9898, 0xC093}, //4170 #HANGUL SYLLABLE SSANGPIEUP I KIYEOKSIOS
  {0x9899, 0xC095}, //4171 #HANGUL SYLLABLE SSANGPIEUP I NIEUNCIEUC
  {0x989A, 0xC096}, //4172 #HANGUL SYLLABLE SSANGPIEUP I NIEUNHIEUH
  {0x989B, 0xC097}, //4173 #HANGUL SYLLABLE SSANGPIEUP I TIKEUT
  {0x989C, 0xC099}, //4174 #HANGUL SYLLABLE SSANGPIEUP I RIEULKIYEOK
  {0x989D, 0xC09A}, //4175 #HANGUL SYLLABLE SSANGPIEUP I RIEULMIEUM
  {0x989E, 0xC09B}, //4176 #HANGUL SYLLABLE SSANGPIEUP I RIEULPIEUP
  {0x989F, 0xC09C}, //4177 #HANGUL SYLLABLE SSANGPIEUP I RIEULSIOS
  {0x98A0, 0xC09D}, //4178 #HANGUL SYLLABLE SSANGPIEUP I RIEULTHIEUTH
  {0x98A1, 0xC09E}, //4179 #HANGUL SYLLABLE SSANGPIEUP I RIEULPHIEUPH
  {0x98A2, 0xC09F}, //4180 #HANGUL SYLLABLE SSANGPIEUP I RIEULHIEUH
  {0x98A3, 0xC0A2}, //4181 #HANGUL SYLLABLE SSANGPIEUP I PIEUPSIOS
  {0x98A4, 0xC0A4}, //4182 #HANGUL SYLLABLE SSANGPIEUP I SSANGSIOS
  {0x98A5, 0xC0A6}, //4183 #HANGUL SYLLABLE SSANGPIEUP I CIEUC
  {0x98A6, 0xC0A7}, //4184 #HANGUL SYLLABLE SSANGPIEUP I CHIEUCH
  {0x98A7, 0xC0A8}, //4185 #HANGUL SYLLABLE SSANGPIEUP I KHIEUKH
  {0x98A8, 0xC0A9}, //4186 #HANGUL SYLLABLE SSANGPIEUP I THIEUTH
  {0x98A9, 0xC0AA}, //4187 #HANGUL SYLLABLE SSANGPIEUP I PHIEUPH
  {0x98AA, 0xC0AB}, //4188 #HANGUL SYLLABLE SSANGPIEUP I HIEUH
  {0x98AB, 0xC0AE}, //4189 #HANGUL SYLLABLE SIOS A SSANGKIYEOK
  {0x98AC, 0xC0B1}, //4190 #HANGUL SYLLABLE SIOS A NIEUNCIEUC
  {0x98AD, 0xC0B2}, //4191 #HANGUL SYLLABLE SIOS A NIEUNHIEUH
  {0x98AE, 0xC0B7}, //4192 #HANGUL SYLLABLE SIOS A RIEULPIEUP
  {0x98AF, 0xC0B8}, //4193 #HANGUL SYLLABLE SIOS A RIEULSIOS
  {0x98B0, 0xC0B9}, //4194 #HANGUL SYLLABLE SIOS A RIEULTHIEUTH
  {0x98B1, 0xC0BA}, //4195 #HANGUL SYLLABLE SIOS A RIEULPHIEUPH
  {0x98B2, 0xC0BB}, //4196 #HANGUL SYLLABLE SIOS A RIEULHIEUH
  {0x98B3, 0xC0BE}, //4197 #HANGUL SYLLABLE SIOS A PIEUPSIOS
  {0x98B4, 0xC0C2}, //4198 #HANGUL SYLLABLE SIOS A CIEUC
  {0x98B5, 0xC0C3}, //4199 #HANGUL SYLLABLE SIOS A CHIEUCH
  {0x98B6, 0xC0C4}, //4200 #HANGUL SYLLABLE SIOS A KHIEUKH
  {0x98B7, 0xC0C6}, //4201 #HANGUL SYLLABLE SIOS A PHIEUPH
  {0x98B8, 0xC0C7}, //4202 #HANGUL SYLLABLE SIOS A HIEUH
  {0x98B9, 0xC0CA}, //4203 #HANGUL SYLLABLE SIOS AE SSANGKIYEOK
  {0x98BA, 0xC0CB}, //4204 #HANGUL SYLLABLE SIOS AE KIYEOKSIOS
  {0x98BB, 0xC0CD}, //4205 #HANGUL SYLLABLE SIOS AE NIEUNCIEUC
  {0x98BC, 0xC0CE}, //4206 #HANGUL SYLLABLE SIOS AE NIEUNHIEUH
  {0x98BD, 0xC0CF}, //4207 #HANGUL SYLLABLE SIOS AE TIKEUT
  {0x98BE, 0xC0D1}, //4208 #HANGUL SYLLABLE SIOS AE RIEULKIYEOK
  {0x98BF, 0xC0D2}, //4209 #HANGUL SYLLABLE SIOS AE RIEULMIEUM
  {0x98C0, 0xC0D3}, //4210 #HANGUL SYLLABLE SIOS AE RIEULPIEUP
  {0x98C1, 0xC0D4}, //4211 #HANGUL SYLLABLE SIOS AE RIEULSIOS
  {0x98C2, 0xC0D5}, //4212 #HANGUL SYLLABLE SIOS AE RIEULTHIEUTH
  {0x98C3, 0xC0D6}, //4213 #HANGUL SYLLABLE SIOS AE RIEULPHIEUPH
  {0x98C4, 0xC0D7}, //4214 #HANGUL SYLLABLE SIOS AE RIEULHIEUH
  {0x98C5, 0xC0DA}, //4215 #HANGUL SYLLABLE SIOS AE PIEUPSIOS
  {0x98C6, 0xC0DE}, //4216 #HANGUL SYLLABLE SIOS AE CIEUC
  {0x98C7, 0xC0DF}, //4217 #HANGUL SYLLABLE SIOS AE CHIEUCH
  {0x98C8, 0xC0E0}, //4218 #HANGUL SYLLABLE SIOS AE KHIEUKH
  {0x98C9, 0xC0E1}, //4219 #HANGUL SYLLABLE SIOS AE THIEUTH
  {0x98CA, 0xC0E2}, //4220 #HANGUL SYLLABLE SIOS AE PHIEUPH
  {0x98CB, 0xC0E3}, //4221 #HANGUL SYLLABLE SIOS AE HIEUH
  {0x98CC, 0xC0E6}, //4222 #HANGUL SYLLABLE SIOS YA SSANGKIYEOK
  {0x98CD, 0xC0E7}, //4223 #HANGUL SYLLABLE SIOS YA KIYEOKSIOS
  {0x98CE, 0xC0E9}, //4224 #HANGUL SYLLABLE SIOS YA NIEUNCIEUC
  {0x98CF, 0xC0EA}, //4225 #HANGUL SYLLABLE SIOS YA NIEUNHIEUH
  {0x98D0, 0xC0EB}, //4226 #HANGUL SYLLABLE SIOS YA TIKEUT
  {0x98D1, 0xC0ED}, //4227 #HANGUL SYLLABLE SIOS YA RIEULKIYEOK
  {0x98D2, 0xC0EE}, //4228 #HANGUL SYLLABLE SIOS YA RIEULMIEUM
  {0x98D3, 0xC0EF}, //4229 #HANGUL SYLLABLE SIOS YA RIEULPIEUP
  {0x98D4, 0xC0F0}, //4230 #HANGUL SYLLABLE SIOS YA RIEULSIOS
  {0x98D5, 0xC0F1}, //4231 #HANGUL SYLLABLE SIOS YA RIEULTHIEUTH
  {0x98D6, 0xC0F2}, //4232 #HANGUL SYLLABLE SIOS YA RIEULPHIEUPH
  {0x98D7, 0xC0F3}, //4233 #HANGUL SYLLABLE SIOS YA RIEULHIEUH
  {0x98D8, 0xC0F6}, //4234 #HANGUL SYLLABLE SIOS YA PIEUPSIOS
  {0x98D9, 0xC0F8}, //4235 #HANGUL SYLLABLE SIOS YA SSANGSIOS
  {0x98DA, 0xC0FA}, //4236 #HANGUL SYLLABLE SIOS YA CIEUC
  {0x98DB, 0xC0FB}, //4237 #HANGUL SYLLABLE SIOS YA CHIEUCH
  {0x98DC, 0xC0FC}, //4238 #HANGUL SYLLABLE SIOS YA KHIEUKH
  {0x98DD, 0xC0FD}, //4239 #HANGUL SYLLABLE SIOS YA THIEUTH
  {0x98DE, 0xC0FE}, //4240 #HANGUL SYLLABLE SIOS YA PHIEUPH
  {0x98DF, 0xC0FF}, //4241 #HANGUL SYLLABLE SIOS YA HIEUH
  {0x98E0, 0xC101}, //4242 #HANGUL SYLLABLE SIOS YAE KIYEOK
  {0x98E1, 0xC102}, //4243 #HANGUL SYLLABLE SIOS YAE SSANGKIYEOK
  {0x98E2, 0xC103}, //4244 #HANGUL SYLLABLE SIOS YAE KIYEOKSIOS
  {0x98E3, 0xC105}, //4245 #HANGUL SYLLABLE SIOS YAE NIEUNCIEUC
  {0x98E4, 0xC106}, //4246 #HANGUL SYLLABLE SIOS YAE NIEUNHIEUH
  {0x98E5, 0xC107}, //4247 #HANGUL SYLLABLE SIOS YAE TIKEUT
  {0x98E6, 0xC109}, //4248 #HANGUL SYLLABLE SIOS YAE RIEULKIYEOK
  {0x98E7, 0xC10A}, //4249 #HANGUL SYLLABLE SIOS YAE RIEULMIEUM
  {0x98E8, 0xC10B}, //4250 #HANGUL SYLLABLE SIOS YAE RIEULPIEUP
  {0x98E9, 0xC10C}, //4251 #HANGUL SYLLABLE SIOS YAE RIEULSIOS
  {0x98EA, 0xC10D}, //4252 #HANGUL SYLLABLE SIOS YAE RIEULTHIEUTH
  {0x98EB, 0xC10E}, //4253 #HANGUL SYLLABLE SIOS YAE RIEULPHIEUPH
  {0x98EC, 0xC10F}, //4254 #HANGUL SYLLABLE SIOS YAE RIEULHIEUH
  {0x98ED, 0xC111}, //4255 #HANGUL SYLLABLE SIOS YAE PIEUP
  {0x98EE, 0xC112}, //4256 #HANGUL SYLLABLE SIOS YAE PIEUPSIOS
  {0x98EF, 0xC113}, //4257 #HANGUL SYLLABLE SIOS YAE SIOS
  {0x98F0, 0xC114}, //4258 #HANGUL SYLLABLE SIOS YAE SSANGSIOS
  {0x98F1, 0xC116}, //4259 #HANGUL SYLLABLE SIOS YAE CIEUC
  {0x98F2, 0xC117}, //4260 #HANGUL SYLLABLE SIOS YAE CHIEUCH
  {0x98F3, 0xC118}, //4261 #HANGUL SYLLABLE SIOS YAE KHIEUKH
  {0x98F4, 0xC119}, //4262 #HANGUL SYLLABLE SIOS YAE THIEUTH
  {0x98F5, 0xC11A}, //4263 #HANGUL SYLLABLE SIOS YAE PHIEUPH
  {0x98F6, 0xC11B}, //4264 #HANGUL SYLLABLE SIOS YAE HIEUH
  {0x98F7, 0xC121}, //4265 #HANGUL SYLLABLE SIOS EO NIEUNCIEUC
  {0x98F8, 0xC122}, //4266 #HANGUL SYLLABLE SIOS EO NIEUNHIEUH
  {0x98F9, 0xC125}, //4267 #HANGUL SYLLABLE SIOS EO RIEULKIYEOK
  {0x98FA, 0xC128}, //4268 #HANGUL SYLLABLE SIOS EO RIEULSIOS
  {0x98FB, 0xC129}, //4269 #HANGUL SYLLABLE SIOS EO RIEULTHIEUTH
  {0x98FC, 0xC12A}, //4270 #HANGUL SYLLABLE SIOS EO RIEULPHIEUPH
  {0x98FD, 0xC12B}, //4271 #HANGUL SYLLABLE SIOS EO RIEULHIEUH
  {0x98FE, 0xC12E}, //4272 #HANGUL SYLLABLE SIOS EO PIEUPSIOS
  {0x9941, 0xC132}, //4273 #HANGUL SYLLABLE SIOS EO CIEUC
  {0x9942, 0xC133}, //4274 #HANGUL SYLLABLE SIOS EO CHIEUCH
  {0x9943, 0xC134}, //4275 #HANGUL SYLLABLE SIOS EO KHIEUKH
  {0x9944, 0xC135}, //4276 #HANGUL SYLLABLE SIOS EO THIEUTH
  {0x9945, 0xC137}, //4277 #HANGUL SYLLABLE SIOS EO HIEUH
  {0x9946, 0xC13A}, //4278 #HANGUL SYLLABLE SIOS E SSANGKIYEOK
  {0x9947, 0xC13B}, //4279 #HANGUL SYLLABLE SIOS E KIYEOKSIOS
  {0x9948, 0xC13D}, //4280 #HANGUL SYLLABLE SIOS E NIEUNCIEUC
  {0x9949, 0xC13E}, //4281 #HANGUL SYLLABLE SIOS E NIEUNHIEUH
  {0x994A, 0xC13F}, //4282 #HANGUL SYLLABLE SIOS E TIKEUT
  {0x994B, 0xC141}, //4283 #HANGUL SYLLABLE SIOS E RIEULKIYEOK
  {0x994C, 0xC142}, //4284 #HANGUL SYLLABLE SIOS E RIEULMIEUM
  {0x994D, 0xC143}, //4285 #HANGUL SYLLABLE SIOS E RIEULPIEUP
  {0x994E, 0xC144}, //4286 #HANGUL SYLLABLE SIOS E RIEULSIOS
  {0x994F, 0xC145}, //4287 #HANGUL SYLLABLE SIOS E RIEULTHIEUTH
  {0x9950, 0xC146}, //4288 #HANGUL SYLLABLE SIOS E RIEULPHIEUPH
  {0x9951, 0xC147}, //4289 #HANGUL SYLLABLE SIOS E RIEULHIEUH
  {0x9952, 0xC14A}, //4290 #HANGUL SYLLABLE SIOS E PIEUPSIOS
  {0x9953, 0xC14E}, //4291 #HANGUL SYLLABLE SIOS E CIEUC
  {0x9954, 0xC14F}, //4292 #HANGUL SYLLABLE SIOS E CHIEUCH
  {0x9955, 0xC150}, //4293 #HANGUL SYLLABLE SIOS E KHIEUKH
  {0x9956, 0xC151}, //4294 #HANGUL SYLLABLE SIOS E THIEUTH
  {0x9957, 0xC152}, //4295 #HANGUL SYLLABLE SIOS E PHIEUPH
  {0x9958, 0xC153}, //4296 #HANGUL SYLLABLE SIOS E HIEUH
  {0x9959, 0xC156}, //4297 #HANGUL SYLLABLE SIOS YEO SSANGKIYEOK
  {0x995A, 0xC157}, //4298 #HANGUL SYLLABLE SIOS YEO KIYEOKSIOS
  {0x9961, 0xC159}, //4299 #HANGUL SYLLABLE SIOS YEO NIEUNCIEUC
  {0x9962, 0xC15A}, //4300 #HANGUL SYLLABLE SIOS YEO NIEUNHIEUH
  {0x9963, 0xC15B}, //4301 #HANGUL SYLLABLE SIOS YEO TIKEUT
  {0x9964, 0xC15D}, //4302 #HANGUL SYLLABLE SIOS YEO RIEULKIYEOK
  {0x9965, 0xC15E}, //4303 #HANGUL SYLLABLE SIOS YEO RIEULMIEUM
  {0x9966, 0xC15F}, //4304 #HANGUL SYLLABLE SIOS YEO RIEULPIEUP
  {0x9967, 0xC160}, //4305 #HANGUL SYLLABLE SIOS YEO RIEULSIOS
  {0x9968, 0xC161}, //4306 #HANGUL SYLLABLE SIOS YEO RIEULTHIEUTH
  {0x9969, 0xC162}, //4307 #HANGUL SYLLABLE SIOS YEO RIEULPHIEUPH
  {0x996A, 0xC163}, //4308 #HANGUL SYLLABLE SIOS YEO RIEULHIEUH
  {0x996B, 0xC166}, //4309 #HANGUL SYLLABLE SIOS YEO PIEUPSIOS
  {0x996C, 0xC16A}, //4310 #HANGUL SYLLABLE SIOS YEO CIEUC
  {0x996D, 0xC16B}, //4311 #HANGUL SYLLABLE SIOS YEO CHIEUCH
  {0x996E, 0xC16C}, //4312 #HANGUL SYLLABLE SIOS YEO KHIEUKH
  {0x996F, 0xC16D}, //4313 #HANGUL SYLLABLE SIOS YEO THIEUTH
  {0x9970, 0xC16E}, //4314 #HANGUL SYLLABLE SIOS YEO PHIEUPH
  {0x9971, 0xC16F}, //4315 #HANGUL SYLLABLE SIOS YEO HIEUH
  {0x9972, 0xC171}, //4316 #HANGUL SYLLABLE SIOS YE KIYEOK
  {0x9973, 0xC172}, //4317 #HANGUL SYLLABLE SIOS YE SSANGKIYEOK
  {0x9974, 0xC173}, //4318 #HANGUL SYLLABLE SIOS YE KIYEOKSIOS
  {0x9975, 0xC175}, //4319 #HANGUL SYLLABLE SIOS YE NIEUNCIEUC
  {0x9976, 0xC176}, //4320 #HANGUL SYLLABLE SIOS YE NIEUNHIEUH
  {0x9977, 0xC177}, //4321 #HANGUL SYLLABLE SIOS YE TIKEUT
  {0x9978, 0xC179}, //4322 #HANGUL SYLLABLE SIOS YE RIEULKIYEOK
  {0x9979, 0xC17A}, //4323 #HANGUL SYLLABLE SIOS YE RIEULMIEUM
  {0x997A, 0xC17B}, //4324 #HANGUL SYLLABLE SIOS YE RIEULPIEUP
  {0x9981, 0xC17C}, //4325 #HANGUL SYLLABLE SIOS YE RIEULSIOS
  {0x9982, 0xC17D}, //4326 #HANGUL SYLLABLE SIOS YE RIEULTHIEUTH
  {0x9983, 0xC17E}, //4327 #HANGUL SYLLABLE SIOS YE RIEULPHIEUPH
  {0x9984, 0xC17F}, //4328 #HANGUL SYLLABLE SIOS YE RIEULHIEUH
  {0x9985, 0xC180}, //4329 #HANGUL SYLLABLE SIOS YE MIEUM
  {0x9986, 0xC181}, //4330 #HANGUL SYLLABLE SIOS YE PIEUP
  {0x9987, 0xC182}, //4331 #HANGUL SYLLABLE SIOS YE PIEUPSIOS
  {0x9988, 0xC183}, //4332 #HANGUL SYLLABLE SIOS YE SIOS
  {0x9989, 0xC184}, //4333 #HANGUL SYLLABLE SIOS YE SSANGSIOS
  {0x998A, 0xC186}, //4334 #HANGUL SYLLABLE SIOS YE CIEUC
  {0x998B, 0xC187}, //4335 #HANGUL SYLLABLE SIOS YE CHIEUCH
  {0x998C, 0xC188}, //4336 #HANGUL SYLLABLE SIOS YE KHIEUKH
  {0x998D, 0xC189}, //4337 #HANGUL SYLLABLE SIOS YE THIEUTH
  {0x998E, 0xC18A}, //4338 #HANGUL SYLLABLE SIOS YE PHIEUPH
  {0x998F, 0xC18B}, //4339 #HANGUL SYLLABLE SIOS YE HIEUH
  {0x9990, 0xC18F}, //4340 #HANGUL SYLLABLE SIOS O KIYEOKSIOS
  {0x9991, 0xC191}, //4341 #HANGUL SYLLABLE SIOS O NIEUNCIEUC
  {0x9992, 0xC192}, //4342 #HANGUL SYLLABLE SIOS O NIEUNHIEUH
  {0x9993, 0xC193}, //4343 #HANGUL SYLLABLE SIOS O TIKEUT
  {0x9994, 0xC195}, //4344 #HANGUL SYLLABLE SIOS O RIEULKIYEOK
  {0x9995, 0xC197}, //4345 #HANGUL SYLLABLE SIOS O RIEULPIEUP
  {0x9996, 0xC198}, //4346 #HANGUL SYLLABLE SIOS O RIEULSIOS
  {0x9997, 0xC199}, //4347 #HANGUL SYLLABLE SIOS O RIEULTHIEUTH
  {0x9998, 0xC19A}, //4348 #HANGUL SYLLABLE SIOS O RIEULPHIEUPH
  {0x9999, 0xC19B}, //4349 #HANGUL SYLLABLE SIOS O RIEULHIEUH
  {0x999A, 0xC19E}, //4350 #HANGUL SYLLABLE SIOS O PIEUPSIOS
  {0x999B, 0xC1A0}, //4351 #HANGUL SYLLABLE SIOS O SSANGSIOS
  {0x999C, 0xC1A2}, //4352 #HANGUL SYLLABLE SIOS O CIEUC
  {0x999D, 0xC1A3}, //4353 #HANGUL SYLLABLE SIOS O CHIEUCH
  {0x999E, 0xC1A4}, //4354 #HANGUL SYLLABLE SIOS O KHIEUKH
  {0x999F, 0xC1A6}, //4355 #HANGUL SYLLABLE SIOS O PHIEUPH
  {0x99A0, 0xC1A7}, //4356 #HANGUL SYLLABLE SIOS O HIEUH
  {0x99A1, 0xC1AA}, //4357 #HANGUL SYLLABLE SIOS WA SSANGKIYEOK
  {0x99A2, 0xC1AB}, //4358 #HANGUL SYLLABLE SIOS WA KIYEOKSIOS
  {0x99A3, 0xC1AD}, //4359 #HANGUL SYLLABLE SIOS WA NIEUNCIEUC
  {0x99A4, 0xC1AE}, //4360 #HANGUL SYLLABLE SIOS WA NIEUNHIEUH
  {0x99A5, 0xC1AF}, //4361 #HANGUL SYLLABLE SIOS WA TIKEUT
  {0x99A6, 0xC1B1}, //4362 #HANGUL SYLLABLE SIOS WA RIEULKIYEOK
  {0x99A7, 0xC1B2}, //4363 #HANGUL SYLLABLE SIOS WA RIEULMIEUM
  {0x99A8, 0xC1B3}, //4364 #HANGUL SYLLABLE SIOS WA RIEULPIEUP
  {0x99A9, 0xC1B4}, //4365 #HANGUL SYLLABLE SIOS WA RIEULSIOS
  {0x99AA, 0xC1B5}, //4366 #HANGUL SYLLABLE SIOS WA RIEULTHIEUTH
  {0x99AB, 0xC1B6}, //4367 #HANGUL SYLLABLE SIOS WA RIEULPHIEUPH
  {0x99AC, 0xC1B7}, //4368 #HANGUL SYLLABLE SIOS WA RIEULHIEUH
  {0x99AD, 0xC1B8}, //4369 #HANGUL SYLLABLE SIOS WA MIEUM
  {0x99AE, 0xC1B9}, //4370 #HANGUL SYLLABLE SIOS WA PIEUP
  {0x99AF, 0xC1BA}, //4371 #HANGUL SYLLABLE SIOS WA PIEUPSIOS
  {0x99B0, 0xC1BB}, //4372 #HANGUL SYLLABLE SIOS WA SIOS
  {0x99B1, 0xC1BC}, //4373 #HANGUL SYLLABLE SIOS WA SSANGSIOS
  {0x99B2, 0xC1BE}, //4374 #HANGUL SYLLABLE SIOS WA CIEUC
  {0x99B3, 0xC1BF}, //4375 #HANGUL SYLLABLE SIOS WA CHIEUCH
  {0x99B4, 0xC1C0}, //4376 #HANGUL SYLLABLE SIOS WA KHIEUKH
  {0x99B5, 0xC1C1}, //4377 #HANGUL SYLLABLE SIOS WA THIEUTH
  {0x99B6, 0xC1C2}, //4378 #HANGUL SYLLABLE SIOS WA PHIEUPH
  {0x99B7, 0xC1C3}, //4379 #HANGUL SYLLABLE SIOS WA HIEUH
  {0x99B8, 0xC1C5}, //4380 #HANGUL SYLLABLE SIOS WAE KIYEOK
  {0x99B9, 0xC1C6}, //4381 #HANGUL SYLLABLE SIOS WAE SSANGKIYEOK
  {0x99BA, 0xC1C7}, //4382 #HANGUL SYLLABLE SIOS WAE KIYEOKSIOS
  {0x99BB, 0xC1C9}, //4383 #HANGUL SYLLABLE SIOS WAE NIEUNCIEUC
  {0x99BC, 0xC1CA}, //4384 #HANGUL SYLLABLE SIOS WAE NIEUNHIEUH
  {0x99BD, 0xC1CB}, //4385 #HANGUL SYLLABLE SIOS WAE TIKEUT
  {0x99BE, 0xC1CD}, //4386 #HANGUL SYLLABLE SIOS WAE RIEULKIYEOK
  {0x99BF, 0xC1CE}, //4387 #HANGUL SYLLABLE SIOS WAE RIEULMIEUM
  {0x99C0, 0xC1CF}, //4388 #HANGUL SYLLABLE SIOS WAE RIEULPIEUP
  {0x99C1, 0xC1D0}, //4389 #HANGUL SYLLABLE SIOS WAE RIEULSIOS
  {0x99C2, 0xC1D1}, //4390 #HANGUL SYLLABLE SIOS WAE RIEULTHIEUTH
  {0x99C3, 0xC1D2}, //4391 #HANGUL SYLLABLE SIOS WAE RIEULPHIEUPH
  {0x99C4, 0xC1D3}, //4392 #HANGUL SYLLABLE SIOS WAE RIEULHIEUH
  {0x99C5, 0xC1D5}, //4393 #HANGUL SYLLABLE SIOS WAE PIEUP
  {0x99C6, 0xC1D6}, //4394 #HANGUL SYLLABLE SIOS WAE PIEUPSIOS
  {0x99C7, 0xC1D9}, //4395 #HANGUL SYLLABLE SIOS WAE IEUNG
  {0x99C8, 0xC1DA}, //4396 #HANGUL SYLLABLE SIOS WAE CIEUC
  {0x99C9, 0xC1DB}, //4397 #HANGUL SYLLABLE SIOS WAE CHIEUCH
  {0x99CA, 0xC1DC}, //4398 #HANGUL SYLLABLE SIOS WAE KHIEUKH
  {0x99CB, 0xC1DD}, //4399 #HANGUL SYLLABLE SIOS WAE THIEUTH
  {0x99CC, 0xC1DE}, //4400 #HANGUL SYLLABLE SIOS WAE PHIEUPH
  {0x99CD, 0xC1DF}, //4401 #HANGUL SYLLABLE SIOS WAE HIEUH
  {0x99CE, 0xC1E1}, //4402 #HANGUL SYLLABLE SIOS OE KIYEOK
  {0x99CF, 0xC1E2}, //4403 #HANGUL SYLLABLE SIOS OE SSANGKIYEOK
  {0x99D0, 0xC1E3}, //4404 #HANGUL SYLLABLE SIOS OE KIYEOKSIOS
  {0x99D1, 0xC1E5}, //4405 #HANGUL SYLLABLE SIOS OE NIEUNCIEUC
  {0x99D2, 0xC1E6}, //4406 #HANGUL SYLLABLE SIOS OE NIEUNHIEUH
  {0x99D3, 0xC1E7}, //4407 #HANGUL SYLLABLE SIOS OE TIKEUT
  {0x99D4, 0xC1E9}, //4408 #HANGUL SYLLABLE SIOS OE RIEULKIYEOK
  {0x99D5, 0xC1EA}, //4409 #HANGUL SYLLABLE SIOS OE RIEULMIEUM
  {0x99D6, 0xC1EB}, //4410 #HANGUL SYLLABLE SIOS OE RIEULPIEUP
  {0x99D7, 0xC1EC}, //4411 #HANGUL SYLLABLE SIOS OE RIEULSIOS
  {0x99D8, 0xC1ED}, //4412 #HANGUL SYLLABLE SIOS OE RIEULTHIEUTH
  {0x99D9, 0xC1EE}, //4413 #HANGUL SYLLABLE SIOS OE RIEULPHIEUPH
  {0x99DA, 0xC1EF}, //4414 #HANGUL SYLLABLE SIOS OE RIEULHIEUH
  {0x99DB, 0xC1F2}, //4415 #HANGUL SYLLABLE SIOS OE PIEUPSIOS
  {0x99DC, 0xC1F4}, //4416 #HANGUL SYLLABLE SIOS OE SSANGSIOS
  {0x99DD, 0xC1F5}, //4417 #HANGUL SYLLABLE SIOS OE IEUNG
  {0x99DE, 0xC1F6}, //4418 #HANGUL SYLLABLE SIOS OE CIEUC
  {0x99DF, 0xC1F7}, //4419 #HANGUL SYLLABLE SIOS OE CHIEUCH
  {0x99E0, 0xC1F8}, //4420 #HANGUL SYLLABLE SIOS OE KHIEUKH
  {0x99E1, 0xC1F9}, //4421 #HANGUL SYLLABLE SIOS OE THIEUTH
  {0x99E2, 0xC1FA}, //4422 #HANGUL SYLLABLE SIOS OE PHIEUPH
  {0x99E3, 0xC1FB}, //4423 #HANGUL SYLLABLE SIOS OE HIEUH
  {0x99E4, 0xC1FE}, //4424 #HANGUL SYLLABLE SIOS YO SSANGKIYEOK
  {0x99E5, 0xC1FF}, //4425 #HANGUL SYLLABLE SIOS YO KIYEOKSIOS
  {0x99E6, 0xC201}, //4426 #HANGUL SYLLABLE SIOS YO NIEUNCIEUC
  {0x99E7, 0xC202}, //4427 #HANGUL SYLLABLE SIOS YO NIEUNHIEUH
  {0x99E8, 0xC203}, //4428 #HANGUL SYLLABLE SIOS YO TIKEUT
  {0x99E9, 0xC205}, //4429 #HANGUL SYLLABLE SIOS YO RIEULKIYEOK
  {0x99EA, 0xC206}, //4430 #HANGUL SYLLABLE SIOS YO RIEULMIEUM
  {0x99EB, 0xC207}, //4431 #HANGUL SYLLABLE SIOS YO RIEULPIEUP
  {0x99EC, 0xC208}, //4432 #HANGUL SYLLABLE SIOS YO RIEULSIOS
  {0x99ED, 0xC209}, //4433 #HANGUL SYLLABLE SIOS YO RIEULTHIEUTH
  {0x99EE, 0xC20A}, //4434 #HANGUL SYLLABLE SIOS YO RIEULPHIEUPH
  {0x99EF, 0xC20B}, //4435 #HANGUL SYLLABLE SIOS YO RIEULHIEUH
  {0x99F0, 0xC20E}, //4436 #HANGUL SYLLABLE SIOS YO PIEUPSIOS
  {0x99F1, 0xC210}, //4437 #HANGUL SYLLABLE SIOS YO SSANGSIOS
  {0x99F2, 0xC212}, //4438 #HANGUL SYLLABLE SIOS YO CIEUC
  {0x99F3, 0xC213}, //4439 #HANGUL SYLLABLE SIOS YO CHIEUCH
  {0x99F4, 0xC214}, //4440 #HANGUL SYLLABLE SIOS YO KHIEUKH
  {0x99F5, 0xC215}, //4441 #HANGUL SYLLABLE SIOS YO THIEUTH
  {0x99F6, 0xC216}, //4442 #HANGUL SYLLABLE SIOS YO PHIEUPH
  {0x99F7, 0xC217}, //4443 #HANGUL SYLLABLE SIOS YO HIEUH
  {0x99F8, 0xC21A}, //4444 #HANGUL SYLLABLE SIOS U SSANGKIYEOK
  {0x99F9, 0xC21B}, //4445 #HANGUL SYLLABLE SIOS U KIYEOKSIOS
  {0x99FA, 0xC21D}, //4446 #HANGUL SYLLABLE SIOS U NIEUNCIEUC
  {0x99FB, 0xC21E}, //4447 #HANGUL SYLLABLE SIOS U NIEUNHIEUH
  {0x99FC, 0xC221}, //4448 #HANGUL SYLLABLE SIOS U RIEULKIYEOK
  {0x99FD, 0xC222}, //4449 #HANGUL SYLLABLE SIOS U RIEULMIEUM
  {0x99FE, 0xC223}, //4450 #HANGUL SYLLABLE SIOS U RIEULPIEUP
  {0x9A41, 0xC224}, //4451 #HANGUL SYLLABLE SIOS U RIEULSIOS
  {0x9A42, 0xC225}, //4452 #HANGUL SYLLABLE SIOS U RIEULTHIEUTH
  {0x9A43, 0xC226}, //4453 #HANGUL SYLLABLE SIOS U RIEULPHIEUPH
  {0x9A44, 0xC227}, //4454 #HANGUL SYLLABLE SIOS U RIEULHIEUH
  {0x9A45, 0xC22A}, //4455 #HANGUL SYLLABLE SIOS U PIEUPSIOS
  {0x9A46, 0xC22C}, //4456 #HANGUL SYLLABLE SIOS U SSANGSIOS
  {0x9A47, 0xC22E}, //4457 #HANGUL SYLLABLE SIOS U CIEUC
  {0x9A48, 0xC230}, //4458 #HANGUL SYLLABLE SIOS U KHIEUKH
  {0x9A49, 0xC233}, //4459 #HANGUL SYLLABLE SIOS U HIEUH
  {0x9A4A, 0xC235}, //4460 #HANGUL SYLLABLE SIOS WEO KIYEOK
  {0x9A4B, 0xC236}, //4461 #HANGUL SYLLABLE SIOS WEO SSANGKIYEOK
  {0x9A4C, 0xC237}, //4462 #HANGUL SYLLABLE SIOS WEO KIYEOKSIOS
  {0x9A4D, 0xC238}, //4463 #HANGUL SYLLABLE SIOS WEO NIEUN
  {0x9A4E, 0xC239}, //4464 #HANGUL SYLLABLE SIOS WEO NIEUNCIEUC
  {0x9A4F, 0xC23A}, //4465 #HANGUL SYLLABLE SIOS WEO NIEUNHIEUH
  {0x9A50, 0xC23B}, //4466 #HANGUL SYLLABLE SIOS WEO TIKEUT
  {0x9A51, 0xC23C}, //4467 #HANGUL SYLLABLE SIOS WEO RIEUL
  {0x9A52, 0xC23D}, //4468 #HANGUL SYLLABLE SIOS WEO RIEULKIYEOK
  {0x9A53, 0xC23E}, //4469 #HANGUL SYLLABLE SIOS WEO RIEULMIEUM
  {0x9A54, 0xC23F}, //4470 #HANGUL SYLLABLE SIOS WEO RIEULPIEUP
  {0x9A55, 0xC240}, //4471 #HANGUL SYLLABLE SIOS WEO RIEULSIOS
  {0x9A56, 0xC241}, //4472 #HANGUL SYLLABLE SIOS WEO RIEULTHIEUTH
  {0x9A57, 0xC242}, //4473 #HANGUL SYLLABLE SIOS WEO RIEULPHIEUPH
  {0x9A58, 0xC243}, //4474 #HANGUL SYLLABLE SIOS WEO RIEULHIEUH
  {0x9A59, 0xC244}, //4475 #HANGUL SYLLABLE SIOS WEO MIEUM
  {0x9A5A, 0xC245}, //4476 #HANGUL SYLLABLE SIOS WEO PIEUP
  {0x9A61, 0xC246}, //4477 #HANGUL SYLLABLE SIOS WEO PIEUPSIOS
  {0x9A62, 0xC247}, //4478 #HANGUL SYLLABLE SIOS WEO SIOS
  {0x9A63, 0xC249}, //4479 #HANGUL SYLLABLE SIOS WEO IEUNG
  {0x9A64, 0xC24A}, //4480 #HANGUL SYLLABLE SIOS WEO CIEUC
  {0x9A65, 0xC24B}, //4481 #HANGUL SYLLABLE SIOS WEO CHIEUCH
  {0x9A66, 0xC24C}, //4482 #HANGUL SYLLABLE SIOS WEO KHIEUKH
  {0x9A67, 0xC24D}, //4483 #HANGUL SYLLABLE SIOS WEO THIEUTH
  {0x9A68, 0xC24E}, //4484 #HANGUL SYLLABLE SIOS WEO PHIEUPH
  {0x9A69, 0xC24F}, //4485 #HANGUL SYLLABLE SIOS WEO HIEUH
  {0x9A6A, 0xC252}, //4486 #HANGUL SYLLABLE SIOS WE SSANGKIYEOK
  {0x9A6B, 0xC253}, //4487 #HANGUL SYLLABLE SIOS WE KIYEOKSIOS
  {0x9A6C, 0xC255}, //4488 #HANGUL SYLLABLE SIOS WE NIEUNCIEUC
  {0x9A6D, 0xC256}, //4489 #HANGUL SYLLABLE SIOS WE NIEUNHIEUH
  {0x9A6E, 0xC257}, //4490 #HANGUL SYLLABLE SIOS WE TIKEUT
  {0x9A6F, 0xC259}, //4491 #HANGUL SYLLABLE SIOS WE RIEULKIYEOK
  {0x9A70, 0xC25A}, //4492 #HANGUL SYLLABLE SIOS WE RIEULMIEUM
  {0x9A71, 0xC25B}, //4493 #HANGUL SYLLABLE SIOS WE RIEULPIEUP
  {0x9A72, 0xC25C}, //4494 #HANGUL SYLLABLE SIOS WE RIEULSIOS
  {0x9A73, 0xC25D}, //4495 #HANGUL SYLLABLE SIOS WE RIEULTHIEUTH
  {0x9A74, 0xC25E}, //4496 #HANGUL SYLLABLE SIOS WE RIEULPHIEUPH
  {0x9A75, 0xC25F}, //4497 #HANGUL SYLLABLE SIOS WE RIEULHIEUH
  {0x9A76, 0xC261}, //4498 #HANGUL SYLLABLE SIOS WE PIEUP
  {0x9A77, 0xC262}, //4499 #HANGUL SYLLABLE SIOS WE PIEUPSIOS
  {0x9A78, 0xC263}, //4500 #HANGUL SYLLABLE SIOS WE SIOS
  {0x9A79, 0xC264}, //4501 #HANGUL SYLLABLE SIOS WE SSANGSIOS
  {0x9A7A, 0xC266}, //4502 #HANGUL SYLLABLE SIOS WE CIEUC
  {0x9A81, 0xC267}, //4503 #HANGUL SYLLABLE SIOS WE CHIEUCH
  {0x9A82, 0xC268}, //4504 #HANGUL SYLLABLE SIOS WE KHIEUKH
  {0x9A83, 0xC269}, //4505 #HANGUL SYLLABLE SIOS WE THIEUTH
  {0x9A84, 0xC26A}, //4506 #HANGUL SYLLABLE SIOS WE PHIEUPH
  {0x9A85, 0xC26B}, //4507 #HANGUL SYLLABLE SIOS WE HIEUH
  {0x9A86, 0xC26E}, //4508 #HANGUL SYLLABLE SIOS WI SSANGKIYEOK
  {0x9A87, 0xC26F}, //4509 #HANGUL SYLLABLE SIOS WI KIYEOKSIOS
  {0x9A88, 0xC271}, //4510 #HANGUL SYLLABLE SIOS WI NIEUNCIEUC
  {0x9A89, 0xC272}, //4511 #HANGUL SYLLABLE SIOS WI NIEUNHIEUH
  {0x9A8A, 0xC273}, //4512 #HANGUL SYLLABLE SIOS WI TIKEUT
  {0x9A8B, 0xC275}, //4513 #HANGUL SYLLABLE SIOS WI RIEULKIYEOK
  {0x9A8C, 0xC276}, //4514 #HANGUL SYLLABLE SIOS WI RIEULMIEUM
  {0x9A8D, 0xC277}, //4515 #HANGUL SYLLABLE SIOS WI RIEULPIEUP
  {0x9A8E, 0xC278}, //4516 #HANGUL SYLLABLE SIOS WI RIEULSIOS
  {0x9A8F, 0xC279}, //4517 #HANGUL SYLLABLE SIOS WI RIEULTHIEUTH
  {0x9A90, 0xC27A}, //4518 #HANGUL SYLLABLE SIOS WI RIEULPHIEUPH
  {0x9A91, 0xC27B}, //4519 #HANGUL SYLLABLE SIOS WI RIEULHIEUH
  {0x9A92, 0xC27E}, //4520 #HANGUL SYLLABLE SIOS WI PIEUPSIOS
  {0x9A93, 0xC280}, //4521 #HANGUL SYLLABLE SIOS WI SSANGSIOS
  {0x9A94, 0xC282}, //4522 #HANGUL SYLLABLE SIOS WI CIEUC
  {0x9A95, 0xC283}, //4523 #HANGUL SYLLABLE SIOS WI CHIEUCH
  {0x9A96, 0xC284}, //4524 #HANGUL SYLLABLE SIOS WI KHIEUKH
  {0x9A97, 0xC285}, //4525 #HANGUL SYLLABLE SIOS WI THIEUTH
  {0x9A98, 0xC286}, //4526 #HANGUL SYLLABLE SIOS WI PHIEUPH
  {0x9A99, 0xC287}, //4527 #HANGUL SYLLABLE SIOS WI HIEUH
  {0x9A9A, 0xC28A}, //4528 #HANGUL SYLLABLE SIOS YU SSANGKIYEOK
  {0x9A9B, 0xC28B}, //4529 #HANGUL SYLLABLE SIOS YU KIYEOKSIOS
  {0x9A9C, 0xC28C}, //4530 #HANGUL SYLLABLE SIOS YU NIEUN
  {0x9A9D, 0xC28D}, //4531 #HANGUL SYLLABLE SIOS YU NIEUNCIEUC
  {0x9A9E, 0xC28E}, //4532 #HANGUL SYLLABLE SIOS YU NIEUNHIEUH
  {0x9A9F, 0xC28F}, //4533 #HANGUL SYLLABLE SIOS YU TIKEUT
  {0x9AA0, 0xC291}, //4534 #HANGUL SYLLABLE SIOS YU RIEULKIYEOK
  {0x9AA1, 0xC292}, //4535 #HANGUL SYLLABLE SIOS YU RIEULMIEUM
  {0x9AA2, 0xC293}, //4536 #HANGUL SYLLABLE SIOS YU RIEULPIEUP
  {0x9AA3, 0xC294}, //4537 #HANGUL SYLLABLE SIOS YU RIEULSIOS
  {0x9AA4, 0xC295}, //4538 #HANGUL SYLLABLE SIOS YU RIEULTHIEUTH
  {0x9AA5, 0xC296}, //4539 #HANGUL SYLLABLE SIOS YU RIEULPHIEUPH
  {0x9AA6, 0xC297}, //4540 #HANGUL SYLLABLE SIOS YU RIEULHIEUH
  {0x9AA7, 0xC299}, //4541 #HANGUL SYLLABLE SIOS YU PIEUP
  {0x9AA8, 0xC29A}, //4542 #HANGUL SYLLABLE SIOS YU PIEUPSIOS
  {0x9AA9, 0xC29C}, //4543 #HANGUL SYLLABLE SIOS YU SSANGSIOS
  {0x9AAA, 0xC29E}, //4544 #HANGUL SYLLABLE SIOS YU CIEUC
  {0x9AAB, 0xC29F}, //4545 #HANGUL SYLLABLE SIOS YU CHIEUCH
  {0x9AAC, 0xC2A0}, //4546 #HANGUL SYLLABLE SIOS YU KHIEUKH
  {0x9AAD, 0xC2A1}, //4547 #HANGUL SYLLABLE SIOS YU THIEUTH
  {0x9AAE, 0xC2A2}, //4548 #HANGUL SYLLABLE SIOS YU PHIEUPH
  {0x9AAF, 0xC2A3}, //4549 #HANGUL SYLLABLE SIOS YU HIEUH
  {0x9AB0, 0xC2A6}, //4550 #HANGUL SYLLABLE SIOS EU SSANGKIYEOK
  {0x9AB1, 0xC2A7}, //4551 #HANGUL SYLLABLE SIOS EU KIYEOKSIOS
  {0x9AB2, 0xC2A9}, //4552 #HANGUL SYLLABLE SIOS EU NIEUNCIEUC
  {0x9AB3, 0xC2AA}, //4553 #HANGUL SYLLABLE SIOS EU NIEUNHIEUH
  {0x9AB4, 0xC2AB}, //4554 #HANGUL SYLLABLE SIOS EU TIKEUT
  {0x9AB5, 0xC2AE}, //4555 #HANGUL SYLLABLE SIOS EU RIEULMIEUM
  {0x9AB6, 0xC2AF}, //4556 #HANGUL SYLLABLE SIOS EU RIEULPIEUP
  {0x9AB7, 0xC2B0}, //4557 #HANGUL SYLLABLE SIOS EU RIEULSIOS
  {0x9AB8, 0xC2B1}, //4558 #HANGUL SYLLABLE SIOS EU RIEULTHIEUTH
  {0x9AB9, 0xC2B2}, //4559 #HANGUL SYLLABLE SIOS EU RIEULPHIEUPH
  {0x9ABA, 0xC2B3}, //4560 #HANGUL SYLLABLE SIOS EU RIEULHIEUH
  {0x9ABB, 0xC2B6}, //4561 #HANGUL SYLLABLE SIOS EU PIEUPSIOS
  {0x9ABC, 0xC2B8}, //4562 #HANGUL SYLLABLE SIOS EU SSANGSIOS
  {0x9ABD, 0xC2BA}, //4563 #HANGUL SYLLABLE SIOS EU CIEUC
  {0x9ABE, 0xC2BB}, //4564 #HANGUL SYLLABLE SIOS EU CHIEUCH
  {0x9ABF, 0xC2BC}, //4565 #HANGUL SYLLABLE SIOS EU KHIEUKH
  {0x9AC0, 0xC2BD}, //4566 #HANGUL SYLLABLE SIOS EU THIEUTH
  {0x9AC1, 0xC2BE}, //4567 #HANGUL SYLLABLE SIOS EU PHIEUPH
  {0x9AC2, 0xC2BF}, //4568 #HANGUL SYLLABLE SIOS EU HIEUH
  {0x9AC3, 0xC2C0}, //4569 #HANGUL SYLLABLE SIOS YI
  {0x9AC4, 0xC2C1}, //4570 #HANGUL SYLLABLE SIOS YI KIYEOK
  {0x9AC5, 0xC2C2}, //4571 #HANGUL SYLLABLE SIOS YI SSANGKIYEOK
  {0x9AC6, 0xC2C3}, //4572 #HANGUL SYLLABLE SIOS YI KIYEOKSIOS
  {0x9AC7, 0xC2C4}, //4573 #HANGUL SYLLABLE SIOS YI NIEUN
  {0x9AC8, 0xC2C5}, //4574 #HANGUL SYLLABLE SIOS YI NIEUNCIEUC
  {0x9AC9, 0xC2C6}, //4575 #HANGUL SYLLABLE SIOS YI NIEUNHIEUH
  {0x9ACA, 0xC2C7}, //4576 #HANGUL SYLLABLE SIOS YI TIKEUT
  {0x9ACB, 0xC2C8}, //4577 #HANGUL SYLLABLE SIOS YI RIEUL
  {0x9ACC, 0xC2C9}, //4578 #HANGUL SYLLABLE SIOS YI RIEULKIYEOK
  {0x9ACD, 0xC2CA}, //4579 #HANGUL SYLLABLE SIOS YI RIEULMIEUM
  {0x9ACE, 0xC2CB}, //4580 #HANGUL SYLLABLE SIOS YI RIEULPIEUP
  {0x9ACF, 0xC2CC}, //4581 #HANGUL SYLLABLE SIOS YI RIEULSIOS
  {0x9AD0, 0xC2CD}, //4582 #HANGUL SYLLABLE SIOS YI RIEULTHIEUTH
  {0x9AD1, 0xC2CE}, //4583 #HANGUL SYLLABLE SIOS YI RIEULPHIEUPH
  {0x9AD2, 0xC2CF}, //4584 #HANGUL SYLLABLE SIOS YI RIEULHIEUH
  {0x9AD3, 0xC2D0}, //4585 #HANGUL SYLLABLE SIOS YI MIEUM
  {0x9AD4, 0xC2D1}, //4586 #HANGUL SYLLABLE SIOS YI PIEUP
  {0x9AD5, 0xC2D2}, //4587 #HANGUL SYLLABLE SIOS YI PIEUPSIOS
  {0x9AD6, 0xC2D3}, //4588 #HANGUL SYLLABLE SIOS YI SIOS
  {0x9AD7, 0xC2D4}, //4589 #HANGUL SYLLABLE SIOS YI SSANGSIOS
  {0x9AD8, 0xC2D5}, //4590 #HANGUL SYLLABLE SIOS YI IEUNG
  {0x9AD9, 0xC2D6}, //4591 #HANGUL SYLLABLE SIOS YI CIEUC
  {0x9ADA, 0xC2D7}, //4592 #HANGUL SYLLABLE SIOS YI CHIEUCH
  {0x9ADB, 0xC2D8}, //4593 #HANGUL SYLLABLE SIOS YI KHIEUKH
  {0x9ADC, 0xC2D9}, //4594 #HANGUL SYLLABLE SIOS YI THIEUTH
  {0x9ADD, 0xC2DA}, //4595 #HANGUL SYLLABLE SIOS YI PHIEUPH
  {0x9ADE, 0xC2DB}, //4596 #HANGUL SYLLABLE SIOS YI HIEUH
  {0x9ADF, 0xC2DE}, //4597 #HANGUL SYLLABLE SIOS I SSANGKIYEOK
  {0x9AE0, 0xC2DF}, //4598 #HANGUL SYLLABLE SIOS I KIYEOKSIOS
  {0x9AE1, 0xC2E1}, //4599 #HANGUL SYLLABLE SIOS I NIEUNCIEUC
  {0x9AE2, 0xC2E2}, //4600 #HANGUL SYLLABLE SIOS I NIEUNHIEUH
  {0x9AE3, 0xC2E5}, //4601 #HANGUL SYLLABLE SIOS I RIEULKIYEOK
  {0x9AE4, 0xC2E6}, //4602 #HANGUL SYLLABLE SIOS I RIEULMIEUM
  {0x9AE5, 0xC2E7}, //4603 #HANGUL SYLLABLE SIOS I RIEULPIEUP
  {0x9AE6, 0xC2E8}, //4604 #HANGUL SYLLABLE SIOS I RIEULSIOS
  {0x9AE7, 0xC2E9}, //4605 #HANGUL SYLLABLE SIOS I RIEULTHIEUTH
  {0x9AE8, 0xC2EA}, //4606 #HANGUL SYLLABLE SIOS I RIEULPHIEUPH
  {0x9AE9, 0xC2EE}, //4607 #HANGUL SYLLABLE SIOS I PIEUPSIOS
  {0x9AEA, 0xC2F0}, //4608 #HANGUL SYLLABLE SIOS I SSANGSIOS
  {0x9AEB, 0xC2F2}, //4609 #HANGUL SYLLABLE SIOS I CIEUC
  {0x9AEC, 0xC2F3}, //4610 #HANGUL SYLLABLE SIOS I CHIEUCH
  {0x9AED, 0xC2F4}, //4611 #HANGUL SYLLABLE SIOS I KHIEUKH
  {0x9AEE, 0xC2F5}, //4612 #HANGUL SYLLABLE SIOS I THIEUTH
  {0x9AEF, 0xC2F7}, //4613 #HANGUL SYLLABLE SIOS I HIEUH
  {0x9AF0, 0xC2FA}, //4614 #HANGUL SYLLABLE SSANGSIOS A SSANGKIYEOK
  {0x9AF1, 0xC2FD}, //4615 #HANGUL SYLLABLE SSANGSIOS A NIEUNCIEUC
  {0x9AF2, 0xC2FE}, //4616 #HANGUL SYLLABLE SSANGSIOS A NIEUNHIEUH
  {0x9AF3, 0xC2FF}, //4617 #HANGUL SYLLABLE SSANGSIOS A TIKEUT
  {0x9AF4, 0xC301}, //4618 #HANGUL SYLLABLE SSANGSIOS A RIEULKIYEOK
  {0x9AF5, 0xC302}, //4619 #HANGUL SYLLABLE SSANGSIOS A RIEULMIEUM
  {0x9AF6, 0xC303}, //4620 #HANGUL SYLLABLE SSANGSIOS A RIEULPIEUP
  {0x9AF7, 0xC304}, //4621 #HANGUL SYLLABLE SSANGSIOS A RIEULSIOS
  {0x9AF8, 0xC305}, //4622 #HANGUL SYLLABLE SSANGSIOS A RIEULTHIEUTH
  {0x9AF9, 0xC306}, //4623 #HANGUL SYLLABLE SSANGSIOS A RIEULPHIEUPH
  {0x9AFA, 0xC307}, //4624 #HANGUL SYLLABLE SSANGSIOS A RIEULHIEUH
  {0x9AFB, 0xC30A}, //4625 #HANGUL SYLLABLE SSANGSIOS A PIEUPSIOS
  {0x9AFC, 0xC30B}, //4626 #HANGUL SYLLABLE SSANGSIOS A SIOS
  {0x9AFD, 0xC30E}, //4627 #HANGUL SYLLABLE SSANGSIOS A CIEUC
  {0x9AFE, 0xC30F}, //4628 #HANGUL SYLLABLE SSANGSIOS A CHIEUCH
  {0x9B41, 0xC310}, //4629 #HANGUL SYLLABLE SSANGSIOS A KHIEUKH
  {0x9B42, 0xC311}, //4630 #HANGUL SYLLABLE SSANGSIOS A THIEUTH
  {0x9B43, 0xC312}, //4631 #HANGUL SYLLABLE SSANGSIOS A PHIEUPH
  {0x9B44, 0xC316}, //4632 #HANGUL SYLLABLE SSANGSIOS AE SSANGKIYEOK
  {0x9B45, 0xC317}, //4633 #HANGUL SYLLABLE SSANGSIOS AE KIYEOKSIOS
  {0x9B46, 0xC319}, //4634 #HANGUL SYLLABLE SSANGSIOS AE NIEUNCIEUC
  {0x9B47, 0xC31A}, //4635 #HANGUL SYLLABLE SSANGSIOS AE NIEUNHIEUH
  {0x9B48, 0xC31B}, //4636 #HANGUL SYLLABLE SSANGSIOS AE TIKEUT
  {0x9B49, 0xC31D}, //4637 #HANGUL SYLLABLE SSANGSIOS AE RIEULKIYEOK
  {0x9B4A, 0xC31E}, //4638 #HANGUL SYLLABLE SSANGSIOS AE RIEULMIEUM
  {0x9B4B, 0xC31F}, //4639 #HANGUL SYLLABLE SSANGSIOS AE RIEULPIEUP
  {0x9B4C, 0xC320}, //4640 #HANGUL SYLLABLE SSANGSIOS AE RIEULSIOS
  {0x9B4D, 0xC321}, //4641 #HANGUL SYLLABLE SSANGSIOS AE RIEULTHIEUTH
  {0x9B4E, 0xC322}, //4642 #HANGUL SYLLABLE SSANGSIOS AE RIEULPHIEUPH
  {0x9B4F, 0xC323}, //4643 #HANGUL SYLLABLE SSANGSIOS AE RIEULHIEUH
  {0x9B50, 0xC326}, //4644 #HANGUL SYLLABLE SSANGSIOS AE PIEUPSIOS
  {0x9B51, 0xC327}, //4645 #HANGUL SYLLABLE SSANGSIOS AE SIOS
  {0x9B52, 0xC32A}, //4646 #HANGUL SYLLABLE SSANGSIOS AE CIEUC
  {0x9B53, 0xC32B}, //4647 #HANGUL SYLLABLE SSANGSIOS AE CHIEUCH
  {0x9B54, 0xC32C}, //4648 #HANGUL SYLLABLE SSANGSIOS AE KHIEUKH
  {0x9B55, 0xC32D}, //4649 #HANGUL SYLLABLE SSANGSIOS AE THIEUTH
  {0x9B56, 0xC32E}, //4650 #HANGUL SYLLABLE SSANGSIOS AE PHIEUPH
  {0x9B57, 0xC32F}, //4651 #HANGUL SYLLABLE SSANGSIOS AE HIEUH
  {0x9B58, 0xC330}, //4652 #HANGUL SYLLABLE SSANGSIOS YA
  {0x9B59, 0xC331}, //4653 #HANGUL SYLLABLE SSANGSIOS YA KIYEOK
  {0x9B5A, 0xC332}, //4654 #HANGUL SYLLABLE SSANGSIOS YA SSANGKIYEOK
  {0x9B61, 0xC333}, //4655 #HANGUL SYLLABLE SSANGSIOS YA KIYEOKSIOS
  {0x9B62, 0xC334}, //4656 #HANGUL SYLLABLE SSANGSIOS YA NIEUN
  {0x9B63, 0xC335}, //4657 #HANGUL SYLLABLE SSANGSIOS YA NIEUNCIEUC
  {0x9B64, 0xC336}, //4658 #HANGUL SYLLABLE SSANGSIOS YA NIEUNHIEUH
  {0x9B65, 0xC337}, //4659 #HANGUL SYLLABLE SSANGSIOS YA TIKEUT
  {0x9B66, 0xC338}, //4660 #HANGUL SYLLABLE SSANGSIOS YA RIEUL
  {0x9B67, 0xC339}, //4661 #HANGUL SYLLABLE SSANGSIOS YA RIEULKIYEOK
  {0x9B68, 0xC33A}, //4662 #HANGUL SYLLABLE SSANGSIOS YA RIEULMIEUM
  {0x9B69, 0xC33B}, //4663 #HANGUL SYLLABLE SSANGSIOS YA RIEULPIEUP
  {0x9B6A, 0xC33C}, //4664 #HANGUL SYLLABLE SSANGSIOS YA RIEULSIOS
  {0x9B6B, 0xC33D}, //4665 #HANGUL SYLLABLE SSANGSIOS YA RIEULTHIEUTH
  {0x9B6C, 0xC33E}, //4666 #HANGUL SYLLABLE SSANGSIOS YA RIEULPHIEUPH
  {0x9B6D, 0xC33F}, //4667 #HANGUL SYLLABLE SSANGSIOS YA RIEULHIEUH
  {0x9B6E, 0xC340}, //4668 #HANGUL SYLLABLE SSANGSIOS YA MIEUM
  {0x9B6F, 0xC341}, //4669 #HANGUL SYLLABLE SSANGSIOS YA PIEUP
  {0x9B70, 0xC342}, //4670 #HANGUL SYLLABLE SSANGSIOS YA PIEUPSIOS
  {0x9B71, 0xC343}, //4671 #HANGUL SYLLABLE SSANGSIOS YA SIOS
  {0x9B72, 0xC344}, //4672 #HANGUL SYLLABLE SSANGSIOS YA SSANGSIOS
  {0x9B73, 0xC346}, //4673 #HANGUL SYLLABLE SSANGSIOS YA CIEUC
  {0x9B74, 0xC347}, //4674 #HANGUL SYLLABLE SSANGSIOS YA CHIEUCH
  {0x9B75, 0xC348}, //4675 #HANGUL SYLLABLE SSANGSIOS YA KHIEUKH
  {0x9B76, 0xC349}, //4676 #HANGUL SYLLABLE SSANGSIOS YA THIEUTH
  {0x9B77, 0xC34A}, //4677 #HANGUL SYLLABLE SSANGSIOS YA PHIEUPH
  {0x9B78, 0xC34B}, //4678 #HANGUL SYLLABLE SSANGSIOS YA HIEUH
  {0x9B79, 0xC34C}, //4679 #HANGUL SYLLABLE SSANGSIOS YAE
  {0x9B7A, 0xC34D}, //4680 #HANGUL SYLLABLE SSANGSIOS YAE KIYEOK
  {0x9B81, 0xC34E}, //4681 #HANGUL SYLLABLE SSANGSIOS YAE SSANGKIYEOK
  {0x9B82, 0xC34F}, //4682 #HANGUL SYLLABLE SSANGSIOS YAE KIYEOKSIOS
  {0x9B83, 0xC350}, //4683 #HANGUL SYLLABLE SSANGSIOS YAE NIEUN
  {0x9B84, 0xC351}, //4684 #HANGUL SYLLABLE SSANGSIOS YAE NIEUNCIEUC
  {0x9B85, 0xC352}, //4685 #HANGUL SYLLABLE SSANGSIOS YAE NIEUNHIEUH
  {0x9B86, 0xC353}, //4686 #HANGUL SYLLABLE SSANGSIOS YAE TIKEUT
  {0x9B87, 0xC354}, //4687 #HANGUL SYLLABLE SSANGSIOS YAE RIEUL
  {0x9B88, 0xC355}, //4688 #HANGUL SYLLABLE SSANGSIOS YAE RIEULKIYEOK
  {0x9B89, 0xC356}, //4689 #HANGUL SYLLABLE SSANGSIOS YAE RIEULMIEUM
  {0x9B8A, 0xC357}, //4690 #HANGUL SYLLABLE SSANGSIOS YAE RIEULPIEUP
  {0x9B8B, 0xC358}, //4691 #HANGUL SYLLABLE SSANGSIOS YAE RIEULSIOS
  {0x9B8C, 0xC359}, //4692 #HANGUL SYLLABLE SSANGSIOS YAE RIEULTHIEUTH
  {0x9B8D, 0xC35A}, //4693 #HANGUL SYLLABLE SSANGSIOS YAE RIEULPHIEUPH
  {0x9B8E, 0xC35B}, //4694 #HANGUL SYLLABLE SSANGSIOS YAE RIEULHIEUH
  {0x9B8F, 0xC35C}, //4695 #HANGUL SYLLABLE SSANGSIOS YAE MIEUM
  {0x9B90, 0xC35D}, //4696 #HANGUL SYLLABLE SSANGSIOS YAE PIEUP
  {0x9B91, 0xC35E}, //4697 #HANGUL SYLLABLE SSANGSIOS YAE PIEUPSIOS
  {0x9B92, 0xC35F}, //4698 #HANGUL SYLLABLE SSANGSIOS YAE SIOS
  {0x9B93, 0xC360}, //4699 #HANGUL SYLLABLE SSANGSIOS YAE SSANGSIOS
  {0x9B94, 0xC361}, //4700 #HANGUL SYLLABLE SSANGSIOS YAE IEUNG
  {0x9B95, 0xC362}, //4701 #HANGUL SYLLABLE SSANGSIOS YAE CIEUC
  {0x9B96, 0xC363}, //4702 #HANGUL SYLLABLE SSANGSIOS YAE CHIEUCH
  {0x9B97, 0xC364}, //4703 #HANGUL SYLLABLE SSANGSIOS YAE KHIEUKH
  {0x9B98, 0xC365}, //4704 #HANGUL SYLLABLE SSANGSIOS YAE THIEUTH
  {0x9B99, 0xC366}, //4705 #HANGUL SYLLABLE SSANGSIOS YAE PHIEUPH
  {0x9B9A, 0xC367}, //4706 #HANGUL SYLLABLE SSANGSIOS YAE HIEUH
  {0x9B9B, 0xC36A}, //4707 #HANGUL SYLLABLE SSANGSIOS EO SSANGKIYEOK
  {0x9B9C, 0xC36B}, //4708 #HANGUL SYLLABLE SSANGSIOS EO KIYEOKSIOS
  {0x9B9D, 0xC36D}, //4709 #HANGUL SYLLABLE SSANGSIOS EO NIEUNCIEUC
  {0x9B9E, 0xC36E}, //4710 #HANGUL SYLLABLE SSANGSIOS EO NIEUNHIEUH
  {0x9B9F, 0xC36F}, //4711 #HANGUL SYLLABLE SSANGSIOS EO TIKEUT
  {0x9BA0, 0xC371}, //4712 #HANGUL SYLLABLE SSANGSIOS EO RIEULKIYEOK
  {0x9BA1, 0xC373}, //4713 #HANGUL SYLLABLE SSANGSIOS EO RIEULPIEUP
  {0x9BA2, 0xC374}, //4714 #HANGUL SYLLABLE SSANGSIOS EO RIEULSIOS
  {0x9BA3, 0xC375}, //4715 #HANGUL SYLLABLE SSANGSIOS EO RIEULTHIEUTH
  {0x9BA4, 0xC376}, //4716 #HANGUL SYLLABLE SSANGSIOS EO RIEULPHIEUPH
  {0x9BA5, 0xC377}, //4717 #HANGUL SYLLABLE SSANGSIOS EO RIEULHIEUH
  {0x9BA6, 0xC37A}, //4718 #HANGUL SYLLABLE SSANGSIOS EO PIEUPSIOS
  {0x9BA7, 0xC37B}, //4719 #HANGUL SYLLABLE SSANGSIOS EO SIOS
  {0x9BA8, 0xC37E}, //4720 #HANGUL SYLLABLE SSANGSIOS EO CIEUC
  {0x9BA9, 0xC37F}, //4721 #HANGUL SYLLABLE SSANGSIOS EO CHIEUCH
  {0x9BAA, 0xC380}, //4722 #HANGUL SYLLABLE SSANGSIOS EO KHIEUKH
  {0x9BAB, 0xC381}, //4723 #HANGUL SYLLABLE SSANGSIOS EO THIEUTH
  {0x9BAC, 0xC382}, //4724 #HANGUL SYLLABLE SSANGSIOS EO PHIEUPH
  {0x9BAD, 0xC383}, //4725 #HANGUL SYLLABLE SSANGSIOS EO HIEUH
  {0x9BAE, 0xC385}, //4726 #HANGUL SYLLABLE SSANGSIOS E KIYEOK
  {0x9BAF, 0xC386}, //4727 #HANGUL SYLLABLE SSANGSIOS E SSANGKIYEOK
  {0x9BB0, 0xC387}, //4728 #HANGUL SYLLABLE SSANGSIOS E KIYEOKSIOS
  {0x9BB1, 0xC389}, //4729 #HANGUL SYLLABLE SSANGSIOS E NIEUNCIEUC
  {0x9BB2, 0xC38A}, //4730 #HANGUL SYLLABLE SSANGSIOS E NIEUNHIEUH
  {0x9BB3, 0xC38B}, //4731 #HANGUL SYLLABLE SSANGSIOS E TIKEUT
  {0x9BB4, 0xC38D}, //4732 #HANGUL SYLLABLE SSANGSIOS E RIEULKIYEOK
  {0x9BB5, 0xC38E}, //4733 #HANGUL SYLLABLE SSANGSIOS E RIEULMIEUM
  {0x9BB6, 0xC38F}, //4734 #HANGUL SYLLABLE SSANGSIOS E RIEULPIEUP
  {0x9BB7, 0xC390}, //4735 #HANGUL SYLLABLE SSANGSIOS E RIEULSIOS
  {0x9BB8, 0xC391}, //4736 #HANGUL SYLLABLE SSANGSIOS E RIEULTHIEUTH
  {0x9BB9, 0xC392}, //4737 #HANGUL SYLLABLE SSANGSIOS E RIEULPHIEUPH
  {0x9BBA, 0xC393}, //4738 #HANGUL SYLLABLE SSANGSIOS E RIEULHIEUH
  {0x9BBB, 0xC394}, //4739 #HANGUL SYLLABLE SSANGSIOS E MIEUM
  {0x9BBC, 0xC395}, //4740 #HANGUL SYLLABLE SSANGSIOS E PIEUP
  {0x9BBD, 0xC396}, //4741 #HANGUL SYLLABLE SSANGSIOS E PIEUPSIOS
  {0x9BBE, 0xC397}, //4742 #HANGUL SYLLABLE SSANGSIOS E SIOS
  {0x9BBF, 0xC398}, //4743 #HANGUL SYLLABLE SSANGSIOS E SSANGSIOS
  {0x9BC0, 0xC399}, //4744 #HANGUL SYLLABLE SSANGSIOS E IEUNG
  {0x9BC1, 0xC39A}, //4745 #HANGUL SYLLABLE SSANGSIOS E CIEUC
  {0x9BC2, 0xC39B}, //4746 #HANGUL SYLLABLE SSANGSIOS E CHIEUCH
  {0x9BC3, 0xC39C}, //4747 #HANGUL SYLLABLE SSANGSIOS E KHIEUKH
  {0x9BC4, 0xC39D}, //4748 #HANGUL SYLLABLE SSANGSIOS E THIEUTH
  {0x9BC5, 0xC39E}, //4749 #HANGUL SYLLABLE SSANGSIOS E PHIEUPH
  {0x9BC6, 0xC39F}, //4750 #HANGUL SYLLABLE SSANGSIOS E HIEUH
  {0x9BC7, 0xC3A0}, //4751 #HANGUL SYLLABLE SSANGSIOS YEO
  {0x9BC8, 0xC3A1}, //4752 #HANGUL SYLLABLE SSANGSIOS YEO KIYEOK
  {0x9BC9, 0xC3A2}, //4753 #HANGUL SYLLABLE SSANGSIOS YEO SSANGKIYEOK
  {0x9BCA, 0xC3A3}, //4754 #HANGUL SYLLABLE SSANGSIOS YEO KIYEOKSIOS
  {0x9BCB, 0xC3A4}, //4755 #HANGUL SYLLABLE SSANGSIOS YEO NIEUN
  {0x9BCC, 0xC3A5}, //4756 #HANGUL SYLLABLE SSANGSIOS YEO NIEUNCIEUC
  {0x9BCD, 0xC3A6}, //4757 #HANGUL SYLLABLE SSANGSIOS YEO NIEUNHIEUH
  {0x9BCE, 0xC3A7}, //4758 #HANGUL SYLLABLE SSANGSIOS YEO TIKEUT
  {0x9BCF, 0xC3A8}, //4759 #HANGUL SYLLABLE SSANGSIOS YEO RIEUL
  {0x9BD0, 0xC3A9}, //4760 #HANGUL SYLLABLE SSANGSIOS YEO RIEULKIYEOK
  {0x9BD1, 0xC3AA}, //4761 #HANGUL SYLLABLE SSANGSIOS YEO RIEULMIEUM
  {0x9BD2, 0xC3AB}, //4762 #HANGUL SYLLABLE SSANGSIOS YEO RIEULPIEUP
  {0x9BD3, 0xC3AC}, //4763 #HANGUL SYLLABLE SSANGSIOS YEO RIEULSIOS
  {0x9BD4, 0xC3AD}, //4764 #HANGUL SYLLABLE SSANGSIOS YEO RIEULTHIEUTH
  {0x9BD5, 0xC3AE}, //4765 #HANGUL SYLLABLE SSANGSIOS YEO RIEULPHIEUPH
  {0x9BD6, 0xC3AF}, //4766 #HANGUL SYLLABLE SSANGSIOS YEO RIEULHIEUH
  {0x9BD7, 0xC3B0}, //4767 #HANGUL SYLLABLE SSANGSIOS YEO MIEUM
  {0x9BD8, 0xC3B1}, //4768 #HANGUL SYLLABLE SSANGSIOS YEO PIEUP
  {0x9BD9, 0xC3B2}, //4769 #HANGUL SYLLABLE SSANGSIOS YEO PIEUPSIOS
  {0x9BDA, 0xC3B3}, //4770 #HANGUL SYLLABLE SSANGSIOS YEO SIOS
  {0x9BDB, 0xC3B4}, //4771 #HANGUL SYLLABLE SSANGSIOS YEO SSANGSIOS
  {0x9BDC, 0xC3B5}, //4772 #HANGUL SYLLABLE SSANGSIOS YEO IEUNG
  {0x9BDD, 0xC3B6}, //4773 #HANGUL SYLLABLE SSANGSIOS YEO CIEUC
  {0x9BDE, 0xC3B7}, //4774 #HANGUL SYLLABLE SSANGSIOS YEO CHIEUCH
  {0x9BDF, 0xC3B8}, //4775 #HANGUL SYLLABLE SSANGSIOS YEO KHIEUKH
  {0x9BE0, 0xC3B9}, //4776 #HANGUL SYLLABLE SSANGSIOS YEO THIEUTH
  {0x9BE1, 0xC3BA}, //4777 #HANGUL SYLLABLE SSANGSIOS YEO PHIEUPH
  {0x9BE2, 0xC3BB}, //4778 #HANGUL SYLLABLE SSANGSIOS YEO HIEUH
  {0x9BE3, 0xC3BC}, //4779 #HANGUL SYLLABLE SSANGSIOS YE
  {0x9BE4, 0xC3BD}, //4780 #HANGUL SYLLABLE SSANGSIOS YE KIYEOK
  {0x9BE5, 0xC3BE}, //4781 #HANGUL SYLLABLE SSANGSIOS YE SSANGKIYEOK
  {0x9BE6, 0xC3BF}, //4782 #HANGUL SYLLABLE SSANGSIOS YE KIYEOKSIOS
  {0x9BE7, 0xC3C1}, //4783 #HANGUL SYLLABLE SSANGSIOS YE NIEUNCIEUC
  {0x9BE8, 0xC3C2}, //4784 #HANGUL SYLLABLE SSANGSIOS YE NIEUNHIEUH
  {0x9BE9, 0xC3C3}, //4785 #HANGUL SYLLABLE SSANGSIOS YE TIKEUT
  {0x9BEA, 0xC3C4}, //4786 #HANGUL SYLLABLE SSANGSIOS YE RIEUL
  {0x9BEB, 0xC3C5}, //4787 #HANGUL SYLLABLE SSANGSIOS YE RIEULKIYEOK
  {0x9BEC, 0xC3C6}, //4788 #HANGUL SYLLABLE SSANGSIOS YE RIEULMIEUM
  {0x9BED, 0xC3C7}, //4789 #HANGUL SYLLABLE SSANGSIOS YE RIEULPIEUP
  {0x9BEE, 0xC3C8}, //4790 #HANGUL SYLLABLE SSANGSIOS YE RIEULSIOS
  {0x9BEF, 0xC3C9}, //4791 #HANGUL SYLLABLE SSANGSIOS YE RIEULTHIEUTH
  {0x9BF0, 0xC3CA}, //4792 #HANGUL SYLLABLE SSANGSIOS YE RIEULPHIEUPH
  {0x9BF1, 0xC3CB}, //4793 #HANGUL SYLLABLE SSANGSIOS YE RIEULHIEUH
  {0x9BF2, 0xC3CC}, //4794 #HANGUL SYLLABLE SSANGSIOS YE MIEUM
  {0x9BF3, 0xC3CD}, //4795 #HANGUL SYLLABLE SSANGSIOS YE PIEUP
  {0x9BF4, 0xC3CE}, //4796 #HANGUL SYLLABLE SSANGSIOS YE PIEUPSIOS
  {0x9BF5, 0xC3CF}, //4797 #HANGUL SYLLABLE SSANGSIOS YE SIOS
  {0x9BF6, 0xC3D0}, //4798 #HANGUL SYLLABLE SSANGSIOS YE SSANGSIOS
  {0x9BF7, 0xC3D1}, //4799 #HANGUL SYLLABLE SSANGSIOS YE IEUNG
  {0x9BF8, 0xC3D2}, //4800 #HANGUL SYLLABLE SSANGSIOS YE CIEUC
  {0x9BF9, 0xC3D3}, //4801 #HANGUL SYLLABLE SSANGSIOS YE CHIEUCH
  {0x9BFA, 0xC3D4}, //4802 #HANGUL SYLLABLE SSANGSIOS YE KHIEUKH
  {0x9BFB, 0xC3D5}, //4803 #HANGUL SYLLABLE SSANGSIOS YE THIEUTH
  {0x9BFC, 0xC3D6}, //4804 #HANGUL SYLLABLE SSANGSIOS YE PHIEUPH
  {0x9BFD, 0xC3D7}, //4805 #HANGUL SYLLABLE SSANGSIOS YE HIEUH
  {0x9BFE, 0xC3DA}, //4806 #HANGUL SYLLABLE SSANGSIOS O SSANGKIYEOK
  {0x9C41, 0xC3DB}, //4807 #HANGUL SYLLABLE SSANGSIOS O KIYEOKSIOS
  {0x9C42, 0xC3DD}, //4808 #HANGUL SYLLABLE SSANGSIOS O NIEUNCIEUC
  {0x9C43, 0xC3DE}, //4809 #HANGUL SYLLABLE SSANGSIOS O NIEUNHIEUH
  {0x9C44, 0xC3E1}, //4810 #HANGUL SYLLABLE SSANGSIOS O RIEULKIYEOK
  {0x9C45, 0xC3E3}, //4811 #HANGUL SYLLABLE SSANGSIOS O RIEULPIEUP
  {0x9C46, 0xC3E4}, //4812 #HANGUL SYLLABLE SSANGSIOS O RIEULSIOS
  {0x9C47, 0xC3E5}, //4813 #HANGUL SYLLABLE SSANGSIOS O RIEULTHIEUTH
  {0x9C48, 0xC3E6}, //4814 #HANGUL SYLLABLE SSANGSIOS O RIEULPHIEUPH
  {0x9C49, 0xC3E7}, //4815 #HANGUL SYLLABLE SSANGSIOS O RIEULHIEUH
  {0x9C4A, 0xC3EA}, //4816 #HANGUL SYLLABLE SSANGSIOS O PIEUPSIOS
  {0x9C4B, 0xC3EB}, //4817 #HANGUL SYLLABLE SSANGSIOS O SIOS
  {0x9C4C, 0xC3EC}, //4818 #HANGUL SYLLABLE SSANGSIOS O SSANGSIOS
  {0x9C4D, 0xC3EE}, //4819 #HANGUL SYLLABLE SSANGSIOS O CIEUC
  {0x9C4E, 0xC3EF}, //4820 #HANGUL SYLLABLE SSANGSIOS O CHIEUCH
  {0x9C4F, 0xC3F0}, //4821 #HANGUL SYLLABLE SSANGSIOS O KHIEUKH
  {0x9C50, 0xC3F1}, //4822 #HANGUL SYLLABLE SSANGSIOS O THIEUTH
  {0x9C51, 0xC3F2}, //4823 #HANGUL SYLLABLE SSANGSIOS O PHIEUPH
  {0x9C52, 0xC3F3}, //4824 #HANGUL SYLLABLE SSANGSIOS O HIEUH
  {0x9C53, 0xC3F6}, //4825 #HANGUL SYLLABLE SSANGSIOS WA SSANGKIYEOK
  {0x9C54, 0xC3F7}, //4826 #HANGUL SYLLABLE SSANGSIOS WA KIYEOKSIOS
  {0x9C55, 0xC3F9}, //4827 #HANGUL SYLLABLE SSANGSIOS WA NIEUNCIEUC
  {0x9C56, 0xC3FA}, //4828 #HANGUL SYLLABLE SSANGSIOS WA NIEUNHIEUH
  {0x9C57, 0xC3FB}, //4829 #HANGUL SYLLABLE SSANGSIOS WA TIKEUT
  {0x9C58, 0xC3FC}, //4830 #HANGUL SYLLABLE SSANGSIOS WA RIEUL
  {0x9C59, 0xC3FD}, //4831 #HANGUL SYLLABLE SSANGSIOS WA RIEULKIYEOK
  {0x9C5A, 0xC3FE}, //4832 #HANGUL SYLLABLE SSANGSIOS WA RIEULMIEUM
  {0x9C61, 0xC3FF}, //4833 #HANGUL SYLLABLE SSANGSIOS WA RIEULPIEUP
  {0x9C62, 0xC400}, //4834 #HANGUL SYLLABLE SSANGSIOS WA RIEULSIOS
  {0x9C63, 0xC401}, //4835 #HANGUL SYLLABLE SSANGSIOS WA RIEULTHIEUTH
  {0x9C64, 0xC402}, //4836 #HANGUL SYLLABLE SSANGSIOS WA RIEULPHIEUPH
  {0x9C65, 0xC403}, //4837 #HANGUL SYLLABLE SSANGSIOS WA RIEULHIEUH
  {0x9C66, 0xC404}, //4838 #HANGUL SYLLABLE SSANGSIOS WA MIEUM
  {0x9C67, 0xC405}, //4839 #HANGUL SYLLABLE SSANGSIOS WA PIEUP
  {0x9C68, 0xC406}, //4840 #HANGUL SYLLABLE SSANGSIOS WA PIEUPSIOS
  {0x9C69, 0xC407}, //4841 #HANGUL SYLLABLE SSANGSIOS WA SIOS
  {0x9C6A, 0xC409}, //4842 #HANGUL SYLLABLE SSANGSIOS WA IEUNG
  {0x9C6B, 0xC40A}, //4843 #HANGUL SYLLABLE SSANGSIOS WA CIEUC
  {0x9C6C, 0xC40B}, //4844 #HANGUL SYLLABLE SSANGSIOS WA CHIEUCH
  {0x9C6D, 0xC40C}, //4845 #HANGUL SYLLABLE SSANGSIOS WA KHIEUKH
  {0x9C6E, 0xC40D}, //4846 #HANGUL SYLLABLE SSANGSIOS WA THIEUTH
  {0x9C6F, 0xC40E}, //4847 #HANGUL SYLLABLE SSANGSIOS WA PHIEUPH
  {0x9C70, 0xC40F}, //4848 #HANGUL SYLLABLE SSANGSIOS WA HIEUH
  {0x9C71, 0xC411}, //4849 #HANGUL SYLLABLE SSANGSIOS WAE KIYEOK
  {0x9C72, 0xC412}, //4850 #HANGUL SYLLABLE SSANGSIOS WAE SSANGKIYEOK
  {0x9C73, 0xC413}, //4851 #HANGUL SYLLABLE SSANGSIOS WAE KIYEOKSIOS
  {0x9C74, 0xC414}, //4852 #HANGUL SYLLABLE SSANGSIOS WAE NIEUN
  {0x9C75, 0xC415}, //4853 #HANGUL SYLLABLE SSANGSIOS WAE NIEUNCIEUC
  {0x9C76, 0xC416}, //4854 #HANGUL SYLLABLE SSANGSIOS WAE NIEUNHIEUH
  {0x9C77, 0xC417}, //4855 #HANGUL SYLLABLE SSANGSIOS WAE TIKEUT
  {0x9C78, 0xC418}, //4856 #HANGUL SYLLABLE SSANGSIOS WAE RIEUL
  {0x9C79, 0xC419}, //4857 #HANGUL SYLLABLE SSANGSIOS WAE RIEULKIYEOK
  {0x9C7A, 0xC41A}, //4858 #HANGUL SYLLABLE SSANGSIOS WAE RIEULMIEUM
  {0x9C81, 0xC41B}, //4859 #HANGUL SYLLABLE SSANGSIOS WAE RIEULPIEUP
  {0x9C82, 0xC41C}, //4860 #HANGUL SYLLABLE SSANGSIOS WAE RIEULSIOS
  {0x9C83, 0xC41D}, //4861 #HANGUL SYLLABLE SSANGSIOS WAE RIEULTHIEUTH
  {0x9C84, 0xC41E}, //4862 #HANGUL SYLLABLE SSANGSIOS WAE RIEULPHIEUPH
  {0x9C85, 0xC41F}, //4863 #HANGUL SYLLABLE SSANGSIOS WAE RIEULHIEUH
  {0x9C86, 0xC420}, //4864 #HANGUL SYLLABLE SSANGSIOS WAE MIEUM
  {0x9C87, 0xC421}, //4865 #HANGUL SYLLABLE SSANGSIOS WAE PIEUP
  {0x9C88, 0xC422}, //4866 #HANGUL SYLLABLE SSANGSIOS WAE PIEUPSIOS
  {0x9C89, 0xC423}, //4867 #HANGUL SYLLABLE SSANGSIOS WAE SIOS
  {0x9C8A, 0xC425}, //4868 #HANGUL SYLLABLE SSANGSIOS WAE IEUNG
  {0x9C8B, 0xC426}, //4869 #HANGUL SYLLABLE SSANGSIOS WAE CIEUC
  {0x9C8C, 0xC427}, //4870 #HANGUL SYLLABLE SSANGSIOS WAE CHIEUCH
  {0x9C8D, 0xC428}, //4871 #HANGUL SYLLABLE SSANGSIOS WAE KHIEUKH
  {0x9C8E, 0xC429}, //4872 #HANGUL SYLLABLE SSANGSIOS WAE THIEUTH
  {0x9C8F, 0xC42A}, //4873 #HANGUL SYLLABLE SSANGSIOS WAE PHIEUPH
  {0x9C90, 0xC42B}, //4874 #HANGUL SYLLABLE SSANGSIOS WAE HIEUH
  {0x9C91, 0xC42D}, //4875 #HANGUL SYLLABLE SSANGSIOS OE KIYEOK
  {0x9C92, 0xC42E}, //4876 #HANGUL SYLLABLE SSANGSIOS OE SSANGKIYEOK
  {0x9C93, 0xC42F}, //4877 #HANGUL SYLLABLE SSANGSIOS OE KIYEOKSIOS
  {0x9C94, 0xC431}, //4878 #HANGUL SYLLABLE SSANGSIOS OE NIEUNCIEUC
  {0x9C95, 0xC432}, //4879 #HANGUL SYLLABLE SSANGSIOS OE NIEUNHIEUH
  {0x9C96, 0xC433}, //4880 #HANGUL SYLLABLE SSANGSIOS OE TIKEUT
  {0x9C97, 0xC435}, //4881 #HANGUL SYLLABLE SSANGSIOS OE RIEULKIYEOK
  {0x9C98, 0xC436}, //4882 #HANGUL SYLLABLE SSANGSIOS OE RIEULMIEUM
  {0x9C99, 0xC437}, //4883 #HANGUL SYLLABLE SSANGSIOS OE RIEULPIEUP
  {0x9C9A, 0xC438}, //4884 #HANGUL SYLLABLE SSANGSIOS OE RIEULSIOS
  {0x9C9B, 0xC439}, //4885 #HANGUL SYLLABLE SSANGSIOS OE RIEULTHIEUTH
  {0x9C9C, 0xC43A}, //4886 #HANGUL SYLLABLE SSANGSIOS OE RIEULPHIEUPH
  {0x9C9D, 0xC43B}, //4887 #HANGUL SYLLABLE SSANGSIOS OE RIEULHIEUH
  {0x9C9E, 0xC43E}, //4888 #HANGUL SYLLABLE SSANGSIOS OE PIEUPSIOS
  {0x9C9F, 0xC43F}, //4889 #HANGUL SYLLABLE SSANGSIOS OE SIOS
  {0x9CA0, 0xC440}, //4890 #HANGUL SYLLABLE SSANGSIOS OE SSANGSIOS
  {0x9CA1, 0xC441}, //4891 #HANGUL SYLLABLE SSANGSIOS OE IEUNG
  {0x9CA2, 0xC442}, //4892 #HANGUL SYLLABLE SSANGSIOS OE CIEUC
  {0x9CA3, 0xC443}, //4893 #HANGUL SYLLABLE SSANGSIOS OE CHIEUCH
  {0x9CA4, 0xC444}, //4894 #HANGUL SYLLABLE SSANGSIOS OE KHIEUKH
  {0x9CA5, 0xC445}, //4895 #HANGUL SYLLABLE SSANGSIOS OE THIEUTH
  {0x9CA6, 0xC446}, //4896 #HANGUL SYLLABLE SSANGSIOS OE PHIEUPH
  {0x9CA7, 0xC447}, //4897 #HANGUL SYLLABLE SSANGSIOS OE HIEUH
  {0x9CA8, 0xC449}, //4898 #HANGUL SYLLABLE SSANGSIOS YO KIYEOK
  {0x9CA9, 0xC44A}, //4899 #HANGUL SYLLABLE SSANGSIOS YO SSANGKIYEOK
  {0x9CAA, 0xC44B}, //4900 #HANGUL SYLLABLE SSANGSIOS YO KIYEOKSIOS
  {0x9CAB, 0xC44C}, //4901 #HANGUL SYLLABLE SSANGSIOS YO NIEUN
  {0x9CAC, 0xC44D}, //4902 #HANGUL SYLLABLE SSANGSIOS YO NIEUNCIEUC
  {0x9CAD, 0xC44E}, //4903 #HANGUL SYLLABLE SSANGSIOS YO NIEUNHIEUH
  {0x9CAE, 0xC44F}, //4904 #HANGUL SYLLABLE SSANGSIOS YO TIKEUT
  {0x9CAF, 0xC450}, //4905 #HANGUL SYLLABLE SSANGSIOS YO RIEUL
  {0x9CB0, 0xC451}, //4906 #HANGUL SYLLABLE SSANGSIOS YO RIEULKIYEOK
  {0x9CB1, 0xC452}, //4907 #HANGUL SYLLABLE SSANGSIOS YO RIEULMIEUM
  {0x9CB2, 0xC453}, //4908 #HANGUL SYLLABLE SSANGSIOS YO RIEULPIEUP
  {0x9CB3, 0xC454}, //4909 #HANGUL SYLLABLE SSANGSIOS YO RIEULSIOS
  {0x9CB4, 0xC455}, //4910 #HANGUL SYLLABLE SSANGSIOS YO RIEULTHIEUTH
  {0x9CB5, 0xC456}, //4911 #HANGUL SYLLABLE SSANGSIOS YO RIEULPHIEUPH
  {0x9CB6, 0xC457}, //4912 #HANGUL SYLLABLE SSANGSIOS YO RIEULHIEUH
  {0x9CB7, 0xC458}, //4913 #HANGUL SYLLABLE SSANGSIOS YO MIEUM
  {0x9CB8, 0xC459}, //4914 #HANGUL SYLLABLE SSANGSIOS YO PIEUP
  {0x9CB9, 0xC45A}, //4915 #HANGUL SYLLABLE SSANGSIOS YO PIEUPSIOS
  {0x9CBA, 0xC45B}, //4916 #HANGUL SYLLABLE SSANGSIOS YO SIOS
  {0x9CBB, 0xC45C}, //4917 #HANGUL SYLLABLE SSANGSIOS YO SSANGSIOS
  {0x9CBC, 0xC45D}, //4918 #HANGUL SYLLABLE SSANGSIOS YO IEUNG
  {0x9CBD, 0xC45E}, //4919 #HANGUL SYLLABLE SSANGSIOS YO CIEUC
  {0x9CBE, 0xC45F}, //4920 #HANGUL SYLLABLE SSANGSIOS YO CHIEUCH
  {0x9CBF, 0xC460}, //4921 #HANGUL SYLLABLE SSANGSIOS YO KHIEUKH
  {0x9CC0, 0xC461}, //4922 #HANGUL SYLLABLE SSANGSIOS YO THIEUTH
  {0x9CC1, 0xC462}, //4923 #HANGUL SYLLABLE SSANGSIOS YO PHIEUPH
  {0x9CC2, 0xC463}, //4924 #HANGUL SYLLABLE SSANGSIOS YO HIEUH
  {0x9CC3, 0xC466}, //4925 #HANGUL SYLLABLE SSANGSIOS U SSANGKIYEOK
  {0x9CC4, 0xC467}, //4926 #HANGUL SYLLABLE SSANGSIOS U KIYEOKSIOS
  {0x9CC5, 0xC469}, //4927 #HANGUL SYLLABLE SSANGSIOS U NIEUNCIEUC
  {0x9CC6, 0xC46A}, //4928 #HANGUL SYLLABLE SSANGSIOS U NIEUNHIEUH
  {0x9CC7, 0xC46B}, //4929 #HANGUL SYLLABLE SSANGSIOS U TIKEUT
  {0x9CC8, 0xC46D}, //4930 #HANGUL SYLLABLE SSANGSIOS U RIEULKIYEOK
  {0x9CC9, 0xC46E}, //4931 #HANGUL SYLLABLE SSANGSIOS U RIEULMIEUM
  {0x9CCA, 0xC46F}, //4932 #HANGUL SYLLABLE SSANGSIOS U RIEULPIEUP
  {0x9CCB, 0xC470}, //4933 #HANGUL SYLLABLE SSANGSIOS U RIEULSIOS
  {0x9CCC, 0xC471}, //4934 #HANGUL SYLLABLE SSANGSIOS U RIEULTHIEUTH
  {0x9CCD, 0xC472}, //4935 #HANGUL SYLLABLE SSANGSIOS U RIEULPHIEUPH
  {0x9CCE, 0xC473}, //4936 #HANGUL SYLLABLE SSANGSIOS U RIEULHIEUH
  {0x9CCF, 0xC476}, //4937 #HANGUL SYLLABLE SSANGSIOS U PIEUPSIOS
  {0x9CD0, 0xC477}, //4938 #HANGUL SYLLABLE SSANGSIOS U SIOS
  {0x9CD1, 0xC478}, //4939 #HANGUL SYLLABLE SSANGSIOS U SSANGSIOS
  {0x9CD2, 0xC47A}, //4940 #HANGUL SYLLABLE SSANGSIOS U CIEUC
  {0x9CD3, 0xC47B}, //4941 #HANGUL SYLLABLE SSANGSIOS U CHIEUCH
  {0x9CD4, 0xC47C}, //4942 #HANGUL SYLLABLE SSANGSIOS U KHIEUKH
  {0x9CD5, 0xC47D}, //4943 #HANGUL SYLLABLE SSANGSIOS U THIEUTH
  {0x9CD6, 0xC47E}, //4944 #HANGUL SYLLABLE SSANGSIOS U PHIEUPH
  {0x9CD7, 0xC47F}, //4945 #HANGUL SYLLABLE SSANGSIOS U HIEUH
  {0x9CD8, 0xC481}, //4946 #HANGUL SYLLABLE SSANGSIOS WEO KIYEOK
  {0x9CD9, 0xC482}, //4947 #HANGUL SYLLABLE SSANGSIOS WEO SSANGKIYEOK
  {0x9CDA, 0xC483}, //4948 #HANGUL SYLLABLE SSANGSIOS WEO KIYEOKSIOS
  {0x9CDB, 0xC484}, //4949 #HANGUL SYLLABLE SSANGSIOS WEO NIEUN
  {0x9CDC, 0xC485}, //4950 #HANGUL SYLLABLE SSANGSIOS WEO NIEUNCIEUC
  {0x9CDD, 0xC486}, //4951 #HANGUL SYLLABLE SSANGSIOS WEO NIEUNHIEUH
  {0x9CDE, 0xC487}, //4952 #HANGUL SYLLABLE SSANGSIOS WEO TIKEUT
  {0x9CDF, 0xC488}, //4953 #HANGUL SYLLABLE SSANGSIOS WEO RIEUL
  {0x9CE0, 0xC489}, //4954 #HANGUL SYLLABLE SSANGSIOS WEO RIEULKIYEOK
  {0x9CE1, 0xC48A}, //4955 #HANGUL SYLLABLE SSANGSIOS WEO RIEULMIEUM
  {0x9CE2, 0xC48B}, //4956 #HANGUL SYLLABLE SSANGSIOS WEO RIEULPIEUP
  {0x9CE3, 0xC48C}, //4957 #HANGUL SYLLABLE SSANGSIOS WEO RIEULSIOS
  {0x9CE4, 0xC48D}, //4958 #HANGUL SYLLABLE SSANGSIOS WEO RIEULTHIEUTH
  {0x9CE5, 0xC48E}, //4959 #HANGUL SYLLABLE SSANGSIOS WEO RIEULPHIEUPH
  {0x9CE6, 0xC48F}, //4960 #HANGUL SYLLABLE SSANGSIOS WEO RIEULHIEUH
  {0x9CE7, 0xC490}, //4961 #HANGUL SYLLABLE SSANGSIOS WEO MIEUM
  {0x9CE8, 0xC491}, //4962 #HANGUL SYLLABLE SSANGSIOS WEO PIEUP
  {0x9CE9, 0xC492}, //4963 #HANGUL SYLLABLE SSANGSIOS WEO PIEUPSIOS
  {0x9CEA, 0xC493}, //4964 #HANGUL SYLLABLE SSANGSIOS WEO SIOS
  {0x9CEB, 0xC495}, //4965 #HANGUL SYLLABLE SSANGSIOS WEO IEUNG
  {0x9CEC, 0xC496}, //4966 #HANGUL SYLLABLE SSANGSIOS WEO CIEUC
  {0x9CED, 0xC497}, //4967 #HANGUL SYLLABLE SSANGSIOS WEO CHIEUCH
  {0x9CEE, 0xC498}, //4968 #HANGUL SYLLABLE SSANGSIOS WEO KHIEUKH
  {0x9CEF, 0xC499}, //4969 #HANGUL SYLLABLE SSANGSIOS WEO THIEUTH
  {0x9CF0, 0xC49A}, //4970 #HANGUL SYLLABLE SSANGSIOS WEO PHIEUPH
  {0x9CF1, 0xC49B}, //4971 #HANGUL SYLLABLE SSANGSIOS WEO HIEUH
  {0x9CF2, 0xC49D}, //4972 #HANGUL SYLLABLE SSANGSIOS WE KIYEOK
  {0x9CF3, 0xC49E}, //4973 #HANGUL SYLLABLE SSANGSIOS WE SSANGKIYEOK
  {0x9CF4, 0xC49F}, //4974 #HANGUL SYLLABLE SSANGSIOS WE KIYEOKSIOS
  {0x9CF5, 0xC4A0}, //4975 #HANGUL SYLLABLE SSANGSIOS WE NIEUN
  {0x9CF6, 0xC4A1}, //4976 #HANGUL SYLLABLE SSANGSIOS WE NIEUNCIEUC
  {0x9CF7, 0xC4A2}, //4977 #HANGUL SYLLABLE SSANGSIOS WE NIEUNHIEUH
  {0x9CF8, 0xC4A3}, //4978 #HANGUL SYLLABLE SSANGSIOS WE TIKEUT
  {0x9CF9, 0xC4A4}, //4979 #HANGUL SYLLABLE SSANGSIOS WE RIEUL
  {0x9CFA, 0xC4A5}, //4980 #HANGUL SYLLABLE SSANGSIOS WE RIEULKIYEOK
  {0x9CFB, 0xC4A6}, //4981 #HANGUL SYLLABLE SSANGSIOS WE RIEULMIEUM
  {0x9CFC, 0xC4A7}, //4982 #HANGUL SYLLABLE SSANGSIOS WE RIEULPIEUP
  {0x9CFD, 0xC4A8}, //4983 #HANGUL SYLLABLE SSANGSIOS WE RIEULSIOS
  {0x9CFE, 0xC4A9}, //4984 #HANGUL SYLLABLE SSANGSIOS WE RIEULTHIEUTH
  {0x9D41, 0xC4AA}, //4985 #HANGUL SYLLABLE SSANGSIOS WE RIEULPHIEUPH
  {0x9D42, 0xC4AB}, //4986 #HANGUL SYLLABLE SSANGSIOS WE RIEULHIEUH
  {0x9D43, 0xC4AC}, //4987 #HANGUL SYLLABLE SSANGSIOS WE MIEUM
  {0x9D44, 0xC4AD}, //4988 #HANGUL SYLLABLE SSANGSIOS WE PIEUP
  {0x9D45, 0xC4AE}, //4989 #HANGUL SYLLABLE SSANGSIOS WE PIEUPSIOS
  {0x9D46, 0xC4AF}, //4990 #HANGUL SYLLABLE SSANGSIOS WE SIOS
  {0x9D47, 0xC4B0}, //4991 #HANGUL SYLLABLE SSANGSIOS WE SSANGSIOS
  {0x9D48, 0xC4B1}, //4992 #HANGUL SYLLABLE SSANGSIOS WE IEUNG
  {0x9D49, 0xC4B2}, //4993 #HANGUL SYLLABLE SSANGSIOS WE CIEUC
  {0x9D4A, 0xC4B3}, //4994 #HANGUL SYLLABLE SSANGSIOS WE CHIEUCH
  {0x9D4B, 0xC4B4}, //4995 #HANGUL SYLLABLE SSANGSIOS WE KHIEUKH
  {0x9D4C, 0xC4B5}, //4996 #HANGUL SYLLABLE SSANGSIOS WE THIEUTH
  {0x9D4D, 0xC4B6}, //4997 #HANGUL SYLLABLE SSANGSIOS WE PHIEUPH
  {0x9D4E, 0xC4B7}, //4998 #HANGUL SYLLABLE SSANGSIOS WE HIEUH
  {0x9D4F, 0xC4B9}, //4999 #HANGUL SYLLABLE SSANGSIOS WI KIYEOK
  {0x9D50, 0xC4BA}, //5000 #HANGUL SYLLABLE SSANGSIOS WI SSANGKIYEOK
  {0x9D51, 0xC4BB}, //5001 #HANGUL SYLLABLE SSANGSIOS WI KIYEOKSIOS
  {0x9D52, 0xC4BD}, //5002 #HANGUL SYLLABLE SSANGSIOS WI NIEUNCIEUC
  {0x9D53, 0xC4BE}, //5003 #HANGUL SYLLABLE SSANGSIOS WI NIEUNHIEUH
  {0x9D54, 0xC4BF}, //5004 #HANGUL SYLLABLE SSANGSIOS WI TIKEUT
  {0x9D55, 0xC4C0}, //5005 #HANGUL SYLLABLE SSANGSIOS WI RIEUL
  {0x9D56, 0xC4C1}, //5006 #HANGUL SYLLABLE SSANGSIOS WI RIEULKIYEOK
  {0x9D57, 0xC4C2}, //5007 #HANGUL SYLLABLE SSANGSIOS WI RIEULMIEUM
  {0x9D58, 0xC4C3}, //5008 #HANGUL SYLLABLE SSANGSIOS WI RIEULPIEUP
  {0x9D59, 0xC4C4}, //5009 #HANGUL SYLLABLE SSANGSIOS WI RIEULSIOS
  {0x9D5A, 0xC4C5}, //5010 #HANGUL SYLLABLE SSANGSIOS WI RIEULTHIEUTH
  {0x9D61, 0xC4C6}, //5011 #HANGUL SYLLABLE SSANGSIOS WI RIEULPHIEUPH
  {0x9D62, 0xC4C7}, //5012 #HANGUL SYLLABLE SSANGSIOS WI RIEULHIEUH
  {0x9D63, 0xC4C8}, //5013 #HANGUL SYLLABLE SSANGSIOS WI MIEUM
  {0x9D64, 0xC4C9}, //5014 #HANGUL SYLLABLE SSANGSIOS WI PIEUP
  {0x9D65, 0xC4CA}, //5015 #HANGUL SYLLABLE SSANGSIOS WI PIEUPSIOS
  {0x9D66, 0xC4CB}, //5016 #HANGUL SYLLABLE SSANGSIOS WI SIOS
  {0x9D67, 0xC4CC}, //5017 #HANGUL SYLLABLE SSANGSIOS WI SSANGSIOS
  {0x9D68, 0xC4CD}, //5018 #HANGUL SYLLABLE SSANGSIOS WI IEUNG
  {0x9D69, 0xC4CE}, //5019 #HANGUL SYLLABLE SSANGSIOS WI CIEUC
  {0x9D6A, 0xC4CF}, //5020 #HANGUL SYLLABLE SSANGSIOS WI CHIEUCH
  {0x9D6B, 0xC4D0}, //5021 #HANGUL SYLLABLE SSANGSIOS WI KHIEUKH
  {0x9D6C, 0xC4D1}, //5022 #HANGUL SYLLABLE SSANGSIOS WI THIEUTH
  {0x9D6D, 0xC4D2}, //5023 #HANGUL SYLLABLE SSANGSIOS WI PHIEUPH
  {0x9D6E, 0xC4D3}, //5024 #HANGUL SYLLABLE SSANGSIOS WI HIEUH
  {0x9D6F, 0xC4D4}, //5025 #HANGUL SYLLABLE SSANGSIOS YU
  {0x9D70, 0xC4D5}, //5026 #HANGUL SYLLABLE SSANGSIOS YU KIYEOK
  {0x9D71, 0xC4D6}, //5027 #HANGUL SYLLABLE SSANGSIOS YU SSANGKIYEOK
  {0x9D72, 0xC4D7}, //5028 #HANGUL SYLLABLE SSANGSIOS YU KIYEOKSIOS
  {0x9D73, 0xC4D8}, //5029 #HANGUL SYLLABLE SSANGSIOS YU NIEUN
  {0x9D74, 0xC4D9}, //5030 #HANGUL SYLLABLE SSANGSIOS YU NIEUNCIEUC
  {0x9D75, 0xC4DA}, //5031 #HANGUL SYLLABLE SSANGSIOS YU NIEUNHIEUH
  {0x9D76, 0xC4DB}, //5032 #HANGUL SYLLABLE SSANGSIOS YU TIKEUT
  {0x9D77, 0xC4DC}, //5033 #HANGUL SYLLABLE SSANGSIOS YU RIEUL
  {0x9D78, 0xC4DD}, //5034 #HANGUL SYLLABLE SSANGSIOS YU RIEULKIYEOK
  {0x9D79, 0xC4DE}, //5035 #HANGUL SYLLABLE SSANGSIOS YU RIEULMIEUM
  {0x9D7A, 0xC4DF}, //5036 #HANGUL SYLLABLE SSANGSIOS YU RIEULPIEUP
  {0x9D81, 0xC4E0}, //5037 #HANGUL SYLLABLE SSANGSIOS YU RIEULSIOS
  {0x9D82, 0xC4E1}, //5038 #HANGUL SYLLABLE SSANGSIOS YU RIEULTHIEUTH
  {0x9D83, 0xC4E2}, //5039 #HANGUL SYLLABLE SSANGSIOS YU RIEULPHIEUPH
  {0x9D84, 0xC4E3}, //5040 #HANGUL SYLLABLE SSANGSIOS YU RIEULHIEUH
  {0x9D85, 0xC4E4}, //5041 #HANGUL SYLLABLE SSANGSIOS YU MIEUM
  {0x9D86, 0xC4E5}, //5042 #HANGUL SYLLABLE SSANGSIOS YU PIEUP
  {0x9D87, 0xC4E6}, //5043 #HANGUL SYLLABLE SSANGSIOS YU PIEUPSIOS
  {0x9D88, 0xC4E7}, //5044 #HANGUL SYLLABLE SSANGSIOS YU SIOS
  {0x9D89, 0xC4E8}, //5045 #HANGUL SYLLABLE SSANGSIOS YU SSANGSIOS
  {0x9D8A, 0xC4EA}, //5046 #HANGUL SYLLABLE SSANGSIOS YU CIEUC
  {0x9D8B, 0xC4EB}, //5047 #HANGUL SYLLABLE SSANGSIOS YU CHIEUCH
  {0x9D8C, 0xC4EC}, //5048 #HANGUL SYLLABLE SSANGSIOS YU KHIEUKH
  {0x9D8D, 0xC4ED}, //5049 #HANGUL SYLLABLE SSANGSIOS YU THIEUTH
  {0x9D8E, 0xC4EE}, //5050 #HANGUL SYLLABLE SSANGSIOS YU PHIEUPH
  {0x9D8F, 0xC4EF}, //5051 #HANGUL SYLLABLE SSANGSIOS YU HIEUH
  {0x9D90, 0xC4F2}, //5052 #HANGUL SYLLABLE SSANGSIOS EU SSANGKIYEOK
  {0x9D91, 0xC4F3}, //5053 #HANGUL SYLLABLE SSANGSIOS EU KIYEOKSIOS
  {0x9D92, 0xC4F5}, //5054 #HANGUL SYLLABLE SSANGSIOS EU NIEUNCIEUC
  {0x9D93, 0xC4F6}, //5055 #HANGUL SYLLABLE SSANGSIOS EU NIEUNHIEUH
  {0x9D94, 0xC4F7}, //5056 #HANGUL SYLLABLE SSANGSIOS EU TIKEUT
  {0x9D95, 0xC4F9}, //5057 #HANGUL SYLLABLE SSANGSIOS EU RIEULKIYEOK
  {0x9D96, 0xC4FB}, //5058 #HANGUL SYLLABLE SSANGSIOS EU RIEULPIEUP
  {0x9D97, 0xC4FC}, //5059 #HANGUL SYLLABLE SSANGSIOS EU RIEULSIOS
  {0x9D98, 0xC4FD}, //5060 #HANGUL SYLLABLE SSANGSIOS EU RIEULTHIEUTH
  {0x9D99, 0xC4FE}, //5061 #HANGUL SYLLABLE SSANGSIOS EU RIEULPHIEUPH
  {0x9D9A, 0xC502}, //5062 #HANGUL SYLLABLE SSANGSIOS EU PIEUPSIOS
  {0x9D9B, 0xC503}, //5063 #HANGUL SYLLABLE SSANGSIOS EU SIOS
  {0x9D9C, 0xC504}, //5064 #HANGUL SYLLABLE SSANGSIOS EU SSANGSIOS
  {0x9D9D, 0xC505}, //5065 #HANGUL SYLLABLE SSANGSIOS EU IEUNG
  {0x9D9E, 0xC506}, //5066 #HANGUL SYLLABLE SSANGSIOS EU CIEUC
  {0x9D9F, 0xC507}, //5067 #HANGUL SYLLABLE SSANGSIOS EU CHIEUCH
  {0x9DA0, 0xC508}, //5068 #HANGUL SYLLABLE SSANGSIOS EU KHIEUKH
  {0x9DA1, 0xC509}, //5069 #HANGUL SYLLABLE SSANGSIOS EU THIEUTH
  {0x9DA2, 0xC50A}, //5070 #HANGUL SYLLABLE SSANGSIOS EU PHIEUPH
  {0x9DA3, 0xC50B}, //5071 #HANGUL SYLLABLE SSANGSIOS EU HIEUH
  {0x9DA4, 0xC50D}, //5072 #HANGUL SYLLABLE SSANGSIOS YI KIYEOK
  {0x9DA5, 0xC50E}, //5073 #HANGUL SYLLABLE SSANGSIOS YI SSANGKIYEOK
  {0x9DA6, 0xC50F}, //5074 #HANGUL SYLLABLE SSANGSIOS YI KIYEOKSIOS
  {0x9DA7, 0xC511}, //5075 #HANGUL SYLLABLE SSANGSIOS YI NIEUNCIEUC
  {0x9DA8, 0xC512}, //5076 #HANGUL SYLLABLE SSANGSIOS YI NIEUNHIEUH
  {0x9DA9, 0xC513}, //5077 #HANGUL SYLLABLE SSANGSIOS YI TIKEUT
  {0x9DAA, 0xC515}, //5078 #HANGUL SYLLABLE SSANGSIOS YI RIEULKIYEOK
  {0x9DAB, 0xC516}, //5079 #HANGUL SYLLABLE SSANGSIOS YI RIEULMIEUM
  {0x9DAC, 0xC517}, //5080 #HANGUL SYLLABLE SSANGSIOS YI RIEULPIEUP
  {0x9DAD, 0xC518}, //5081 #HANGUL SYLLABLE SSANGSIOS YI RIEULSIOS
  {0x9DAE, 0xC519}, //5082 #HANGUL SYLLABLE SSANGSIOS YI RIEULTHIEUTH
  {0x9DAF, 0xC51A}, //5083 #HANGUL SYLLABLE SSANGSIOS YI RIEULPHIEUPH
  {0x9DB0, 0xC51B}, //5084 #HANGUL SYLLABLE SSANGSIOS YI RIEULHIEUH
  {0x9DB1, 0xC51D}, //5085 #HANGUL SYLLABLE SSANGSIOS YI PIEUP
  {0x9DB2, 0xC51E}, //5086 #HANGUL SYLLABLE SSANGSIOS YI PIEUPSIOS
  {0x9DB3, 0xC51F}, //5087 #HANGUL SYLLABLE SSANGSIOS YI SIOS
  {0x9DB4, 0xC520}, //5088 #HANGUL SYLLABLE SSANGSIOS YI SSANGSIOS
  {0x9DB5, 0xC521}, //5089 #HANGUL SYLLABLE SSANGSIOS YI IEUNG
  {0x9DB6, 0xC522}, //5090 #HANGUL SYLLABLE SSANGSIOS YI CIEUC
  {0x9DB7, 0xC523}, //5091 #HANGUL SYLLABLE SSANGSIOS YI CHIEUCH
  {0x9DB8, 0xC524}, //5092 #HANGUL SYLLABLE SSANGSIOS YI KHIEUKH
  {0x9DB9, 0xC525}, //5093 #HANGUL SYLLABLE SSANGSIOS YI THIEUTH
  {0x9DBA, 0xC526}, //5094 #HANGUL SYLLABLE SSANGSIOS YI PHIEUPH
  {0x9DBB, 0xC527}, //5095 #HANGUL SYLLABLE SSANGSIOS YI HIEUH
  {0x9DBC, 0xC52A}, //5096 #HANGUL SYLLABLE SSANGSIOS I SSANGKIYEOK
  {0x9DBD, 0xC52B}, //5097 #HANGUL SYLLABLE SSANGSIOS I KIYEOKSIOS
  {0x9DBE, 0xC52D}, //5098 #HANGUL SYLLABLE SSANGSIOS I NIEUNCIEUC
  {0x9DBF, 0xC52E}, //5099 #HANGUL SYLLABLE SSANGSIOS I NIEUNHIEUH
  {0x9DC0, 0xC52F}, //5100 #HANGUL SYLLABLE SSANGSIOS I TIKEUT
  {0x9DC1, 0xC531}, //5101 #HANGUL SYLLABLE SSANGSIOS I RIEULKIYEOK
  {0x9DC2, 0xC532}, //5102 #HANGUL SYLLABLE SSANGSIOS I RIEULMIEUM
  {0x9DC3, 0xC533}, //5103 #HANGUL SYLLABLE SSANGSIOS I RIEULPIEUP
  {0x9DC4, 0xC534}, //5104 #HANGUL SYLLABLE SSANGSIOS I RIEULSIOS
  {0x9DC5, 0xC535}, //5105 #HANGUL SYLLABLE SSANGSIOS I RIEULTHIEUTH
  {0x9DC6, 0xC536}, //5106 #HANGUL SYLLABLE SSANGSIOS I RIEULPHIEUPH
  {0x9DC7, 0xC537}, //5107 #HANGUL SYLLABLE SSANGSIOS I RIEULHIEUH
  {0x9DC8, 0xC53A}, //5108 #HANGUL SYLLABLE SSANGSIOS I PIEUPSIOS
  {0x9DC9, 0xC53C}, //5109 #HANGUL SYLLABLE SSANGSIOS I SSANGSIOS
  {0x9DCA, 0xC53E}, //5110 #HANGUL SYLLABLE SSANGSIOS I CIEUC
  {0x9DCB, 0xC53F}, //5111 #HANGUL SYLLABLE SSANGSIOS I CHIEUCH
  {0x9DCC, 0xC540}, //5112 #HANGUL SYLLABLE SSANGSIOS I KHIEUKH
  {0x9DCD, 0xC541}, //5113 #HANGUL SYLLABLE SSANGSIOS I THIEUTH
  {0x9DCE, 0xC542}, //5114 #HANGUL SYLLABLE SSANGSIOS I PHIEUPH
  {0x9DCF, 0xC543}, //5115 #HANGUL SYLLABLE SSANGSIOS I HIEUH
  {0x9DD0, 0xC546}, //5116 #HANGUL SYLLABLE IEUNG A SSANGKIYEOK
  {0x9DD1, 0xC547}, //5117 #HANGUL SYLLABLE IEUNG A KIYEOKSIOS
  {0x9DD2, 0xC54B}, //5118 #HANGUL SYLLABLE IEUNG A TIKEUT
  {0x9DD3, 0xC54F}, //5119 #HANGUL SYLLABLE IEUNG A RIEULPIEUP
  {0x9DD4, 0xC550}, //5120 #HANGUL SYLLABLE IEUNG A RIEULSIOS
  {0x9DD5, 0xC551}, //5121 #HANGUL SYLLABLE IEUNG A RIEULTHIEUTH
  {0x9DD6, 0xC552}, //5122 #HANGUL SYLLABLE IEUNG A RIEULPHIEUPH
  {0x9DD7, 0xC556}, //5123 #HANGUL SYLLABLE IEUNG A PIEUPSIOS
  {0x9DD8, 0xC55A}, //5124 #HANGUL SYLLABLE IEUNG A CIEUC
  {0x9DD9, 0xC55B}, //5125 #HANGUL SYLLABLE IEUNG A CHIEUCH
  {0x9DDA, 0xC55C}, //5126 #HANGUL SYLLABLE IEUNG A KHIEUKH
  {0x9DDB, 0xC55F}, //5127 #HANGUL SYLLABLE IEUNG A HIEUH
  {0x9DDC, 0xC562}, //5128 #HANGUL SYLLABLE IEUNG AE SSANGKIYEOK
  {0x9DDD, 0xC563}, //5129 #HANGUL SYLLABLE IEUNG AE KIYEOKSIOS
  {0x9DDE, 0xC565}, //5130 #HANGUL SYLLABLE IEUNG AE NIEUNCIEUC
  {0x9DDF, 0xC566}, //5131 #HANGUL SYLLABLE IEUNG AE NIEUNHIEUH
  {0x9DE0, 0xC567}, //5132 #HANGUL SYLLABLE IEUNG AE TIKEUT
  {0x9DE1, 0xC569}, //5133 #HANGUL SYLLABLE IEUNG AE RIEULKIYEOK
  {0x9DE2, 0xC56A}, //5134 #HANGUL SYLLABLE IEUNG AE RIEULMIEUM
  {0x9DE3, 0xC56B}, //5135 #HANGUL SYLLABLE IEUNG AE RIEULPIEUP
  {0x9DE4, 0xC56C}, //5136 #HANGUL SYLLABLE IEUNG AE RIEULSIOS
  {0x9DE5, 0xC56D}, //5137 #HANGUL SYLLABLE IEUNG AE RIEULTHIEUTH
  {0x9DE6, 0xC56E}, //5138 #HANGUL SYLLABLE IEUNG AE RIEULPHIEUPH
  {0x9DE7, 0xC56F}, //5139 #HANGUL SYLLABLE IEUNG AE RIEULHIEUH
  {0x9DE8, 0xC572}, //5140 #HANGUL SYLLABLE IEUNG AE PIEUPSIOS
  {0x9DE9, 0xC576}, //5141 #HANGUL SYLLABLE IEUNG AE CIEUC
  {0x9DEA, 0xC577}, //5142 #HANGUL SYLLABLE IEUNG AE CHIEUCH
  {0x9DEB, 0xC578}, //5143 #HANGUL SYLLABLE IEUNG AE KHIEUKH
  {0x9DEC, 0xC579}, //5144 #HANGUL SYLLABLE IEUNG AE THIEUTH
  {0x9DED, 0xC57A}, //5145 #HANGUL SYLLABLE IEUNG AE PHIEUPH
  {0x9DEE, 0xC57B}, //5146 #HANGUL SYLLABLE IEUNG AE HIEUH
  {0x9DEF, 0xC57E}, //5147 #HANGUL SYLLABLE IEUNG YA SSANGKIYEOK
  {0x9DF0, 0xC57F}, //5148 #HANGUL SYLLABLE IEUNG YA KIYEOKSIOS
  {0x9DF1, 0xC581}, //5149 #HANGUL SYLLABLE IEUNG YA NIEUNCIEUC
  {0x9DF2, 0xC582}, //5150 #HANGUL SYLLABLE IEUNG YA NIEUNHIEUH
  {0x9DF3, 0xC583}, //5151 #HANGUL SYLLABLE IEUNG YA TIKEUT
  {0x9DF4, 0xC585}, //5152 #HANGUL SYLLABLE IEUNG YA RIEULKIYEOK
  {0x9DF5, 0xC586}, //5153 #HANGUL SYLLABLE IEUNG YA RIEULMIEUM
  {0x9DF6, 0xC588}, //5154 #HANGUL SYLLABLE IEUNG YA RIEULSIOS
  {0x9DF7, 0xC589}, //5155 #HANGUL SYLLABLE IEUNG YA RIEULTHIEUTH
  {0x9DF8, 0xC58A}, //5156 #HANGUL SYLLABLE IEUNG YA RIEULPHIEUPH
  {0x9DF9, 0xC58B}, //5157 #HANGUL SYLLABLE IEUNG YA RIEULHIEUH
  {0x9DFA, 0xC58E}, //5158 #HANGUL SYLLABLE IEUNG YA PIEUPSIOS
  {0x9DFB, 0xC590}, //5159 #HANGUL SYLLABLE IEUNG YA SSANGSIOS
  {0x9DFC, 0xC592}, //5160 #HANGUL SYLLABLE IEUNG YA CIEUC
  {0x9DFD, 0xC593}, //5161 #HANGUL SYLLABLE IEUNG YA CHIEUCH
  {0x9DFE, 0xC594}, //5162 #HANGUL SYLLABLE IEUNG YA KHIEUKH
  {0x9E41, 0xC596}, //5163 #HANGUL SYLLABLE IEUNG YA PHIEUPH
  {0x9E42, 0xC599}, //5164 #HANGUL SYLLABLE IEUNG YAE KIYEOK
  {0x9E43, 0xC59A}, //5165 #HANGUL SYLLABLE IEUNG YAE SSANGKIYEOK
  {0x9E44, 0xC59B}, //5166 #HANGUL SYLLABLE IEUNG YAE KIYEOKSIOS
  {0x9E45, 0xC59D}, //5167 #HANGUL SYLLABLE IEUNG YAE NIEUNCIEUC
  {0x9E46, 0xC59E}, //5168 #HANGUL SYLLABLE IEUNG YAE NIEUNHIEUH
  {0x9E47, 0xC59F}, //5169 #HANGUL SYLLABLE IEUNG YAE TIKEUT
  {0x9E48, 0xC5A1}, //5170 #HANGUL SYLLABLE IEUNG YAE RIEULKIYEOK
  {0x9E49, 0xC5A2}, //5171 #HANGUL SYLLABLE IEUNG YAE RIEULMIEUM
  {0x9E4A, 0xC5A3}, //5172 #HANGUL SYLLABLE IEUNG YAE RIEULPIEUP
  {0x9E4B, 0xC5A4}, //5173 #HANGUL SYLLABLE IEUNG YAE RIEULSIOS
  {0x9E4C, 0xC5A5}, //5174 #HANGUL SYLLABLE IEUNG YAE RIEULTHIEUTH
  {0x9E4D, 0xC5A6}, //5175 #HANGUL SYLLABLE IEUNG YAE RIEULPHIEUPH
  {0x9E4E, 0xC5A7}, //5176 #HANGUL SYLLABLE IEUNG YAE RIEULHIEUH
  {0x9E4F, 0xC5A8}, //5177 #HANGUL SYLLABLE IEUNG YAE MIEUM
  {0x9E50, 0xC5AA}, //5178 #HANGUL SYLLABLE IEUNG YAE PIEUPSIOS
  {0x9E51, 0xC5AB}, //5179 #HANGUL SYLLABLE IEUNG YAE SIOS
  {0x9E52, 0xC5AC}, //5180 #HANGUL SYLLABLE IEUNG YAE SSANGSIOS
  {0x9E53, 0xC5AD}, //5181 #HANGUL SYLLABLE IEUNG YAE IEUNG
  {0x9E54, 0xC5AE}, //5182 #HANGUL SYLLABLE IEUNG YAE CIEUC
  {0x9E55, 0xC5AF}, //5183 #HANGUL SYLLABLE IEUNG YAE CHIEUCH
  {0x9E56, 0xC5B0}, //5184 #HANGUL SYLLABLE IEUNG YAE KHIEUKH
  {0x9E57, 0xC5B1}, //5185 #HANGUL SYLLABLE IEUNG YAE THIEUTH
  {0x9E58, 0xC5B2}, //5186 #HANGUL SYLLABLE IEUNG YAE PHIEUPH
  {0x9E59, 0xC5B3}, //5187 #HANGUL SYLLABLE IEUNG YAE HIEUH
  {0x9E5A, 0xC5B6}, //5188 #HANGUL SYLLABLE IEUNG EO SSANGKIYEOK
  {0x9E61, 0xC5B7}, //5189 #HANGUL SYLLABLE IEUNG EO KIYEOKSIOS
  {0x9E62, 0xC5BA}, //5190 #HANGUL SYLLABLE IEUNG EO NIEUNHIEUH
  {0x9E63, 0xC5BF}, //5191 #HANGUL SYLLABLE IEUNG EO RIEULPIEUP
  {0x9E64, 0xC5C0}, //5192 #HANGUL SYLLABLE IEUNG EO RIEULSIOS
  {0x9E65, 0xC5C1}, //5193 #HANGUL SYLLABLE IEUNG EO RIEULTHIEUTH
  {0x9E66, 0xC5C2}, //5194 #HANGUL SYLLABLE IEUNG EO RIEULPHIEUPH
  {0x9E67, 0xC5C3}, //5195 #HANGUL SYLLABLE IEUNG EO RIEULHIEUH
  {0x9E68, 0xC5CB}, //5196 #HANGUL SYLLABLE IEUNG EO CHIEUCH
  {0x9E69, 0xC5CD}, //5197 #HANGUL SYLLABLE IEUNG EO THIEUTH
  {0x9E6A, 0xC5CF}, //5198 #HANGUL SYLLABLE IEUNG EO HIEUH
  {0x9E6B, 0xC5D2}, //5199 #HANGUL SYLLABLE IEUNG E SSANGKIYEOK
  {0x9E6C, 0xC5D3}, //5200 #HANGUL SYLLABLE IEUNG E KIYEOKSIOS
  {0x9E6D, 0xC5D5}, //5201 #HANGUL SYLLABLE IEUNG E NIEUNCIEUC
  {0x9E6E, 0xC5D6}, //5202 #HANGUL SYLLABLE IEUNG E NIEUNHIEUH
  {0x9E6F, 0xC5D7}, //5203 #HANGUL SYLLABLE IEUNG E TIKEUT
  {0x9E70, 0xC5D9}, //5204 #HANGUL SYLLABLE IEUNG E RIEULKIYEOK
  {0x9E71, 0xC5DA}, //5205 #HANGUL SYLLABLE IEUNG E RIEULMIEUM
  {0x9E72, 0xC5DB}, //5206 #HANGUL SYLLABLE IEUNG E RIEULPIEUP
  {0x9E73, 0xC5DC}, //5207 #HANGUL SYLLABLE IEUNG E RIEULSIOS
  {0x9E74, 0xC5DD}, //5208 #HANGUL SYLLABLE IEUNG E RIEULTHIEUTH
  {0x9E75, 0xC5DE}, //5209 #HANGUL SYLLABLE IEUNG E RIEULPHIEUPH
  {0x9E76, 0xC5DF}, //5210 #HANGUL SYLLABLE IEUNG E RIEULHIEUH
  {0x9E77, 0xC5E2}, //5211 #HANGUL SYLLABLE IEUNG E PIEUPSIOS
  {0x9E78, 0xC5E4}, //5212 #HANGUL SYLLABLE IEUNG E SSANGSIOS
  {0x9E79, 0xC5E6}, //5213 #HANGUL SYLLABLE IEUNG E CIEUC
  {0x9E7A, 0xC5E7}, //5214 #HANGUL SYLLABLE IEUNG E CHIEUCH
  {0x9E81, 0xC5E8}, //5215 #HANGUL SYLLABLE IEUNG E KHIEUKH
  {0x9E82, 0xC5E9}, //5216 #HANGUL SYLLABLE IEUNG E THIEUTH
  {0x9E83, 0xC5EA}, //5217 #HANGUL SYLLABLE IEUNG E PHIEUPH
  {0x9E84, 0xC5EB}, //5218 #HANGUL SYLLABLE IEUNG E HIEUH
  {0x9E85, 0xC5EF}, //5219 #HANGUL SYLLABLE IEUNG YEO KIYEOKSIOS
  {0x9E86, 0xC5F1}, //5220 #HANGUL SYLLABLE IEUNG YEO NIEUNCIEUC
  {0x9E87, 0xC5F2}, //5221 #HANGUL SYLLABLE IEUNG YEO NIEUNHIEUH
  {0x9E88, 0xC5F3}, //5222 #HANGUL SYLLABLE IEUNG YEO TIKEUT
  {0x9E89, 0xC5F5}, //5223 #HANGUL SYLLABLE IEUNG YEO RIEULKIYEOK
  {0x9E8A, 0xC5F8}, //5224 #HANGUL SYLLABLE IEUNG YEO RIEULSIOS
  {0x9E8B, 0xC5F9}, //5225 #HANGUL SYLLABLE IEUNG YEO RIEULTHIEUTH
  {0x9E8C, 0xC5FA}, //5226 #HANGUL SYLLABLE IEUNG YEO RIEULPHIEUPH
  {0x9E8D, 0xC5FB}, //5227 #HANGUL SYLLABLE IEUNG YEO RIEULHIEUH
  {0x9E8E, 0xC602}, //5228 #HANGUL SYLLABLE IEUNG YEO CIEUC
  {0x9E8F, 0xC603}, //5229 #HANGUL SYLLABLE IEUNG YEO CHIEUCH
  {0x9E90, 0xC604}, //5230 #HANGUL SYLLABLE IEUNG YEO KHIEUKH
  {0x9E91, 0xC609}, //5231 #HANGUL SYLLABLE IEUNG YE KIYEOK
  {0x9E92, 0xC60A}, //5232 #HANGUL SYLLABLE IEUNG YE SSANGKIYEOK
  {0x9E93, 0xC60B}, //5233 #HANGUL SYLLABLE IEUNG YE KIYEOKSIOS
  {0x9E94, 0xC60D}, //5234 #HANGUL SYLLABLE IEUNG YE NIEUNCIEUC
  {0x9E95, 0xC60E}, //5235 #HANGUL SYLLABLE IEUNG YE NIEUNHIEUH
  {0x9E96, 0xC60F}, //5236 #HANGUL SYLLABLE IEUNG YE TIKEUT
  {0x9E97, 0xC611}, //5237 #HANGUL SYLLABLE IEUNG YE RIEULKIYEOK
  {0x9E98, 0xC612}, //5238 #HANGUL SYLLABLE IEUNG YE RIEULMIEUM
  {0x9E99, 0xC613}, //5239 #HANGUL SYLLABLE IEUNG YE RIEULPIEUP
  {0x9E9A, 0xC614}, //5240 #HANGUL SYLLABLE IEUNG YE RIEULSIOS
  {0x9E9B, 0xC615}, //5241 #HANGUL SYLLABLE IEUNG YE RIEULTHIEUTH
  {0x9E9C, 0xC616}, //5242 #HANGUL SYLLABLE IEUNG YE RIEULPHIEUPH
  {0x9E9D, 0xC617}, //5243 #HANGUL SYLLABLE IEUNG YE RIEULHIEUH
  {0x9E9E, 0xC61A}, //5244 #HANGUL SYLLABLE IEUNG YE PIEUPSIOS
  {0x9E9F, 0xC61D}, //5245 #HANGUL SYLLABLE IEUNG YE IEUNG
  {0x9EA0, 0xC61E}, //5246 #HANGUL SYLLABLE IEUNG YE CIEUC
  {0x9EA1, 0xC61F}, //5247 #HANGUL SYLLABLE IEUNG YE CHIEUCH
  {0x9EA2, 0xC620}, //5248 #HANGUL SYLLABLE IEUNG YE KHIEUKH
  {0x9EA3, 0xC621}, //5249 #HANGUL SYLLABLE IEUNG YE THIEUTH
  {0x9EA4, 0xC622}, //5250 #HANGUL SYLLABLE IEUNG YE PHIEUPH
  {0x9EA5, 0xC623}, //5251 #HANGUL SYLLABLE IEUNG YE HIEUH
  {0x9EA6, 0xC626}, //5252 #HANGUL SYLLABLE IEUNG O SSANGKIYEOK
  {0x9EA7, 0xC627}, //5253 #HANGUL SYLLABLE IEUNG O KIYEOKSIOS
  {0x9EA8, 0xC629}, //5254 #HANGUL SYLLABLE IEUNG O NIEUNCIEUC
  {0x9EA9, 0xC62A}, //5255 #HANGUL SYLLABLE IEUNG O NIEUNHIEUH
  {0x9EAA, 0xC62B}, //5256 #HANGUL SYLLABLE IEUNG O TIKEUT
  {0x9EAB, 0xC62F}, //5257 #HANGUL SYLLABLE IEUNG O RIEULPIEUP
  {0x9EAC, 0xC631}, //5258 #HANGUL SYLLABLE IEUNG O RIEULTHIEUTH
  {0x9EAD, 0xC632}, //5259 #HANGUL SYLLABLE IEUNG O RIEULPHIEUPH
  {0x9EAE, 0xC636}, //5260 #HANGUL SYLLABLE IEUNG O PIEUPSIOS
  {0x9EAF, 0xC638}, //5261 #HANGUL SYLLABLE IEUNG O SSANGSIOS
  {0x9EB0, 0xC63A}, //5262 #HANGUL SYLLABLE IEUNG O CIEUC
  {0x9EB1, 0xC63C}, //5263 #HANGUL SYLLABLE IEUNG O KHIEUKH
  {0x9EB2, 0xC63D}, //5264 #HANGUL SYLLABLE IEUNG O THIEUTH
  {0x9EB3, 0xC63E}, //5265 #HANGUL SYLLABLE IEUNG O PHIEUPH
  {0x9EB4, 0xC63F}, //5266 #HANGUL SYLLABLE IEUNG O HIEUH
  {0x9EB5, 0xC642}, //5267 #HANGUL SYLLABLE IEUNG WA SSANGKIYEOK
  {0x9EB6, 0xC643}, //5268 #HANGUL SYLLABLE IEUNG WA KIYEOKSIOS
  {0x9EB7, 0xC645}, //5269 #HANGUL SYLLABLE IEUNG WA NIEUNCIEUC
  {0x9EB8, 0xC646}, //5270 #HANGUL SYLLABLE IEUNG WA NIEUNHIEUH
  {0x9EB9, 0xC647}, //5271 #HANGUL SYLLABLE IEUNG WA TIKEUT
  {0x9EBA, 0xC649}, //5272 #HANGUL SYLLABLE IEUNG WA RIEULKIYEOK
  {0x9EBB, 0xC64A}, //5273 #HANGUL SYLLABLE IEUNG WA RIEULMIEUM
  {0x9EBC, 0xC64B}, //5274 #HANGUL SYLLABLE IEUNG WA RIEULPIEUP
  {0x9EBD, 0xC64C}, //5275 #HANGUL SYLLABLE IEUNG WA RIEULSIOS
  {0x9EBE, 0xC64D}, //5276 #HANGUL SYLLABLE IEUNG WA RIEULTHIEUTH
  {0x9EBF, 0xC64E}, //5277 #HANGUL SYLLABLE IEUNG WA RIEULPHIEUPH
  {0x9EC0, 0xC64F}, //5278 #HANGUL SYLLABLE IEUNG WA RIEULHIEUH
  {0x9EC1, 0xC652}, //5279 #HANGUL SYLLABLE IEUNG WA PIEUPSIOS
  {0x9EC2, 0xC656}, //5280 #HANGUL SYLLABLE IEUNG WA CIEUC
  {0x9EC3, 0xC657}, //5281 #HANGUL SYLLABLE IEUNG WA CHIEUCH
  {0x9EC4, 0xC658}, //5282 #HANGUL SYLLABLE IEUNG WA KHIEUKH
  {0x9EC5, 0xC659}, //5283 #HANGUL SYLLABLE IEUNG WA THIEUTH
  {0x9EC6, 0xC65A}, //5284 #HANGUL SYLLABLE IEUNG WA PHIEUPH
  {0x9EC7, 0xC65B}, //5285 #HANGUL SYLLABLE IEUNG WA HIEUH
  {0x9EC8, 0xC65E}, //5286 #HANGUL SYLLABLE IEUNG WAE SSANGKIYEOK
  {0x9EC9, 0xC65F}, //5287 #HANGUL SYLLABLE IEUNG WAE KIYEOKSIOS
  {0x9ECA, 0xC661}, //5288 #HANGUL SYLLABLE IEUNG WAE NIEUNCIEUC
  {0x9ECB, 0xC662}, //5289 #HANGUL SYLLABLE IEUNG WAE NIEUNHIEUH
  {0x9ECC, 0xC663}, //5290 #HANGUL SYLLABLE IEUNG WAE TIKEUT
  {0x9ECD, 0xC664}, //5291 #HANGUL SYLLABLE IEUNG WAE RIEUL
  {0x9ECE, 0xC665}, //5292 #HANGUL SYLLABLE IEUNG WAE RIEULKIYEOK
  {0x9ECF, 0xC666}, //5293 #HANGUL SYLLABLE IEUNG WAE RIEULMIEUM
  {0x9ED0, 0xC667}, //5294 #HANGUL SYLLABLE IEUNG WAE RIEULPIEUP
  {0x9ED1, 0xC668}, //5295 #HANGUL SYLLABLE IEUNG WAE RIEULSIOS
  {0x9ED2, 0xC669}, //5296 #HANGUL SYLLABLE IEUNG WAE RIEULTHIEUTH
  {0x9ED3, 0xC66A}, //5297 #HANGUL SYLLABLE IEUNG WAE RIEULPHIEUPH
  {0x9ED4, 0xC66B}, //5298 #HANGUL SYLLABLE IEUNG WAE RIEULHIEUH
  {0x9ED5, 0xC66D}, //5299 #HANGUL SYLLABLE IEUNG WAE PIEUP
  {0x9ED6, 0xC66E}, //5300 #HANGUL SYLLABLE IEUNG WAE PIEUPSIOS
  {0x9ED7, 0xC670}, //5301 #HANGUL SYLLABLE IEUNG WAE SSANGSIOS
  {0x9ED8, 0xC672}, //5302 #HANGUL SYLLABLE IEUNG WAE CIEUC
  {0x9ED9, 0xC673}, //5303 #HANGUL SYLLABLE IEUNG WAE CHIEUCH
  {0x9EDA, 0xC674}, //5304 #HANGUL SYLLABLE IEUNG WAE KHIEUKH
  {0x9EDB, 0xC675}, //5305 #HANGUL SYLLABLE IEUNG WAE THIEUTH
  {0x9EDC, 0xC676}, //5306 #HANGUL SYLLABLE IEUNG WAE PHIEUPH
  {0x9EDD, 0xC677}, //5307 #HANGUL SYLLABLE IEUNG WAE HIEUH
  {0x9EDE, 0xC67A}, //5308 #HANGUL SYLLABLE IEUNG OE SSANGKIYEOK
  {0x9EDF, 0xC67B}, //5309 #HANGUL SYLLABLE IEUNG OE KIYEOKSIOS
  {0x9EE0, 0xC67D}, //5310 #HANGUL SYLLABLE IEUNG OE NIEUNCIEUC
  {0x9EE1, 0xC67E}, //5311 #HANGUL SYLLABLE IEUNG OE NIEUNHIEUH
  {0x9EE2, 0xC67F}, //5312 #HANGUL SYLLABLE IEUNG OE TIKEUT
  {0x9EE3, 0xC681}, //5313 #HANGUL SYLLABLE IEUNG OE RIEULKIYEOK
  {0x9EE4, 0xC682}, //5314 #HANGUL SYLLABLE IEUNG OE RIEULMIEUM
  {0x9EE5, 0xC683}, //5315 #HANGUL SYLLABLE IEUNG OE RIEULPIEUP
  {0x9EE6, 0xC684}, //5316 #HANGUL SYLLABLE IEUNG OE RIEULSIOS
  {0x9EE7, 0xC685}, //5317 #HANGUL SYLLABLE IEUNG OE RIEULTHIEUTH
  {0x9EE8, 0xC686}, //5318 #HANGUL SYLLABLE IEUNG OE RIEULPHIEUPH
  {0x9EE9, 0xC687}, //5319 #HANGUL SYLLABLE IEUNG OE RIEULHIEUH
  {0x9EEA, 0xC68A}, //5320 #HANGUL SYLLABLE IEUNG OE PIEUPSIOS
  {0x9EEB, 0xC68C}, //5321 #HANGUL SYLLABLE IEUNG OE SSANGSIOS
  {0x9EEC, 0xC68E}, //5322 #HANGUL SYLLABLE IEUNG OE CIEUC
  {0x9EED, 0xC68F}, //5323 #HANGUL SYLLABLE IEUNG OE CHIEUCH
  {0x9EEE, 0xC690}, //5324 #HANGUL SYLLABLE IEUNG OE KHIEUKH
  {0x9EEF, 0xC691}, //5325 #HANGUL SYLLABLE IEUNG OE THIEUTH
  {0x9EF0, 0xC692}, //5326 #HANGUL SYLLABLE IEUNG OE PHIEUPH
  {0x9EF1, 0xC693}, //5327 #HANGUL SYLLABLE IEUNG OE HIEUH
  {0x9EF2, 0xC696}, //5328 #HANGUL SYLLABLE IEUNG YO SSANGKIYEOK
  {0x9EF3, 0xC697}, //5329 #HANGUL SYLLABLE IEUNG YO KIYEOKSIOS
  {0x9EF4, 0xC699}, //5330 #HANGUL SYLLABLE IEUNG YO NIEUNCIEUC
  {0x9EF5, 0xC69A}, //5331 #HANGUL SYLLABLE IEUNG YO NIEUNHIEUH
  {0x9EF6, 0xC69B}, //5332 #HANGUL SYLLABLE IEUNG YO TIKEUT
  {0x9EF7, 0xC69D}, //5333 #HANGUL SYLLABLE IEUNG YO RIEULKIYEOK
  {0x9EF8, 0xC69E}, //5334 #HANGUL SYLLABLE IEUNG YO RIEULMIEUM
  {0x9EF9, 0xC69F}, //5335 #HANGUL SYLLABLE IEUNG YO RIEULPIEUP
  {0x9EFA, 0xC6A0}, //5336 #HANGUL SYLLABLE IEUNG YO RIEULSIOS
  {0x9EFB, 0xC6A1}, //5337 #HANGUL SYLLABLE IEUNG YO RIEULTHIEUTH
  {0x9EFC, 0xC6A2}, //5338 #HANGUL SYLLABLE IEUNG YO RIEULPHIEUPH
  {0x9EFD, 0xC6A3}, //5339 #HANGUL SYLLABLE IEUNG YO RIEULHIEUH
  {0x9EFE, 0xC6A6}, //5340 #HANGUL SYLLABLE IEUNG YO PIEUPSIOS
  {0x9F41, 0xC6A8}, //5341 #HANGUL SYLLABLE IEUNG YO SSANGSIOS
  {0x9F42, 0xC6AA}, //5342 #HANGUL SYLLABLE IEUNG YO CIEUC
  {0x9F43, 0xC6AB}, //5343 #HANGUL SYLLABLE IEUNG YO CHIEUCH
  {0x9F44, 0xC6AC}, //5344 #HANGUL SYLLABLE IEUNG YO KHIEUKH
  {0x9F45, 0xC6AD}, //5345 #HANGUL SYLLABLE IEUNG YO THIEUTH
  {0x9F46, 0xC6AE}, //5346 #HANGUL SYLLABLE IEUNG YO PHIEUPH
  {0x9F47, 0xC6AF}, //5347 #HANGUL SYLLABLE IEUNG YO HIEUH
  {0x9F48, 0xC6B2}, //5348 #HANGUL SYLLABLE IEUNG U SSANGKIYEOK
  {0x9F49, 0xC6B3}, //5349 #HANGUL SYLLABLE IEUNG U KIYEOKSIOS
  {0x9F4A, 0xC6B5}, //5350 #HANGUL SYLLABLE IEUNG U NIEUNCIEUC
  {0x9F4B, 0xC6B6}, //5351 #HANGUL SYLLABLE IEUNG U NIEUNHIEUH
  {0x9F4C, 0xC6B7}, //5352 #HANGUL SYLLABLE IEUNG U TIKEUT
  {0x9F4D, 0xC6BB}, //5353 #HANGUL SYLLABLE IEUNG U RIEULPIEUP
  {0x9F4E, 0xC6BC}, //5354 #HANGUL SYLLABLE IEUNG U RIEULSIOS
  {0x9F4F, 0xC6BD}, //5355 #HANGUL SYLLABLE IEUNG U RIEULTHIEUTH
  {0x9F50, 0xC6BE}, //5356 #HANGUL SYLLABLE IEUNG U RIEULPHIEUPH
  {0x9F51, 0xC6BF}, //5357 #HANGUL SYLLABLE IEUNG U RIEULHIEUH
  {0x9F52, 0xC6C2}, //5358 #HANGUL SYLLABLE IEUNG U PIEUPSIOS
  {0x9F53, 0xC6C4}, //5359 #HANGUL SYLLABLE IEUNG U SSANGSIOS
  {0x9F54, 0xC6C6}, //5360 #HANGUL SYLLABLE IEUNG U CIEUC
  {0x9F55, 0xC6C7}, //5361 #HANGUL SYLLABLE IEUNG U CHIEUCH
  {0x9F56, 0xC6C8}, //5362 #HANGUL SYLLABLE IEUNG U KHIEUKH
  {0x9F57, 0xC6C9}, //5363 #HANGUL SYLLABLE IEUNG U THIEUTH
  {0x9F58, 0xC6CA}, //5364 #HANGUL SYLLABLE IEUNG U PHIEUPH
  {0x9F59, 0xC6CB}, //5365 #HANGUL SYLLABLE IEUNG U HIEUH
  {0x9F5A, 0xC6CE}, //5366 #HANGUL SYLLABLE IEUNG WEO SSANGKIYEOK
  {0x9F61, 0xC6CF}, //5367 #HANGUL SYLLABLE IEUNG WEO KIYEOKSIOS
  {0x9F62, 0xC6D1}, //5368 #HANGUL SYLLABLE IEUNG WEO NIEUNCIEUC
  {0x9F63, 0xC6D2}, //5369 #HANGUL SYLLABLE IEUNG WEO NIEUNHIEUH
  {0x9F64, 0xC6D3}, //5370 #HANGUL SYLLABLE IEUNG WEO TIKEUT
  {0x9F65, 0xC6D5}, //5371 #HANGUL SYLLABLE IEUNG WEO RIEULKIYEOK
  {0x9F66, 0xC6D6}, //5372 #HANGUL SYLLABLE IEUNG WEO RIEULMIEUM
  {0x9F67, 0xC6D7}, //5373 #HANGUL SYLLABLE IEUNG WEO RIEULPIEUP
  {0x9F68, 0xC6D8}, //5374 #HANGUL SYLLABLE IEUNG WEO RIEULSIOS
  {0x9F69, 0xC6D9}, //5375 #HANGUL SYLLABLE IEUNG WEO RIEULTHIEUTH
  {0x9F6A, 0xC6DA}, //5376 #HANGUL SYLLABLE IEUNG WEO RIEULPHIEUPH
  {0x9F6B, 0xC6DB}, //5377 #HANGUL SYLLABLE IEUNG WEO RIEULHIEUH
  {0x9F6C, 0xC6DE}, //5378 #HANGUL SYLLABLE IEUNG WEO PIEUPSIOS
  {0x9F6D, 0xC6DF}, //5379 #HANGUL SYLLABLE IEUNG WEO SIOS
  {0x9F6E, 0xC6E2}, //5380 #HANGUL SYLLABLE IEUNG WEO CIEUC
  {0x9F6F, 0xC6E3}, //5381 #HANGUL SYLLABLE IEUNG WEO CHIEUCH
  {0x9F70, 0xC6E4}, //5382 #HANGUL SYLLABLE IEUNG WEO KHIEUKH
  {0x9F71, 0xC6E5}, //5383 #HANGUL SYLLABLE IEUNG WEO THIEUTH
  {0x9F72, 0xC6E6}, //5384 #HANGUL SYLLABLE IEUNG WEO PHIEUPH
  {0x9F73, 0xC6E7}, //5385 #HANGUL SYLLABLE IEUNG WEO HIEUH
  {0x9F74, 0xC6EA}, //5386 #HANGUL SYLLABLE IEUNG WE SSANGKIYEOK
  {0x9F75, 0xC6EB}, //5387 #HANGUL SYLLABLE IEUNG WE KIYEOKSIOS
  {0x9F76, 0xC6ED}, //5388 #HANGUL SYLLABLE IEUNG WE NIEUNCIEUC
  {0x9F77, 0xC6EE}, //5389 #HANGUL SYLLABLE IEUNG WE NIEUNHIEUH
  {0x9F78, 0xC6EF}, //5390 #HANGUL SYLLABLE IEUNG WE TIKEUT
  {0x9F79, 0xC6F1}, //5391 #HANGUL SYLLABLE IEUNG WE RIEULKIYEOK
  {0x9F7A, 0xC6F2}, //5392 #HANGUL SYLLABLE IEUNG WE RIEULMIEUM
  {0x9F81, 0xC6F3}, //5393 #HANGUL SYLLABLE IEUNG WE RIEULPIEUP
  {0x9F82, 0xC6F4}, //5394 #HANGUL SYLLABLE IEUNG WE RIEULSIOS
  {0x9F83, 0xC6F5}, //5395 #HANGUL SYLLABLE IEUNG WE RIEULTHIEUTH
  {0x9F84, 0xC6F6}, //5396 #HANGUL SYLLABLE IEUNG WE RIEULPHIEUPH
  {0x9F85, 0xC6F7}, //5397 #HANGUL SYLLABLE IEUNG WE RIEULHIEUH
  {0x9F86, 0xC6FA}, //5398 #HANGUL SYLLABLE IEUNG WE PIEUPSIOS
  {0x9F87, 0xC6FB}, //5399 #HANGUL SYLLABLE IEUNG WE SIOS
  {0x9F88, 0xC6FC}, //5400 #HANGUL SYLLABLE IEUNG WE SSANGSIOS
  {0x9F89, 0xC6FE}, //5401 #HANGUL SYLLABLE IEUNG WE CIEUC
  {0x9F8A, 0xC6FF}, //5402 #HANGUL SYLLABLE IEUNG WE CHIEUCH
  {0x9F8B, 0xC700}, //5403 #HANGUL SYLLABLE IEUNG WE KHIEUKH
  {0x9F8C, 0xC701}, //5404 #HANGUL SYLLABLE IEUNG WE THIEUTH
  {0x9F8D, 0xC702}, //5405 #HANGUL SYLLABLE IEUNG WE PHIEUPH
  {0x9F8E, 0xC703}, //5406 #HANGUL SYLLABLE IEUNG WE HIEUH
  {0x9F8F, 0xC706}, //5407 #HANGUL SYLLABLE IEUNG WI SSANGKIYEOK
  {0x9F90, 0xC707}, //5408 #HANGUL SYLLABLE IEUNG WI KIYEOKSIOS
  {0x9F91, 0xC709}, //5409 #HANGUL SYLLABLE IEUNG WI NIEUNCIEUC
  {0x9F92, 0xC70A}, //5410 #HANGUL SYLLABLE IEUNG WI NIEUNHIEUH
  {0x9F93, 0xC70B}, //5411 #HANGUL SYLLABLE IEUNG WI TIKEUT
  {0x9F94, 0xC70D}, //5412 #HANGUL SYLLABLE IEUNG WI RIEULKIYEOK
  {0x9F95, 0xC70E}, //5413 #HANGUL SYLLABLE IEUNG WI RIEULMIEUM
  {0x9F96, 0xC70F}, //5414 #HANGUL SYLLABLE IEUNG WI RIEULPIEUP
  {0x9F97, 0xC710}, //5415 #HANGUL SYLLABLE IEUNG WI RIEULSIOS
  {0x9F98, 0xC711}, //5416 #HANGUL SYLLABLE IEUNG WI RIEULTHIEUTH
  {0x9F99, 0xC712}, //5417 #HANGUL SYLLABLE IEUNG WI RIEULPHIEUPH
  {0x9F9A, 0xC713}, //5418 #HANGUL SYLLABLE IEUNG WI RIEULHIEUH
  {0x9F9B, 0xC716}, //5419 #HANGUL SYLLABLE IEUNG WI PIEUPSIOS
  {0x9F9C, 0xC718}, //5420 #HANGUL SYLLABLE IEUNG WI SSANGSIOS
  {0x9F9D, 0xC71A}, //5421 #HANGUL SYLLABLE IEUNG WI CIEUC
  {0x9F9E, 0xC71B}, //5422 #HANGUL SYLLABLE IEUNG WI CHIEUCH
  {0x9F9F, 0xC71C}, //5423 #HANGUL SYLLABLE IEUNG WI KHIEUKH
  {0x9FA0, 0xC71D}, //5424 #HANGUL SYLLABLE IEUNG WI THIEUTH
  {0x9FA1, 0xC71E}, //5425 #HANGUL SYLLABLE IEUNG WI PHIEUPH
  {0x9FA2, 0xC71F}, //5426 #HANGUL SYLLABLE IEUNG WI HIEUH
  {0x9FA3, 0xC722}, //5427 #HANGUL SYLLABLE IEUNG YU SSANGKIYEOK
  {0x9FA4, 0xC723}, //5428 #HANGUL SYLLABLE IEUNG YU KIYEOKSIOS
  {0x9FA5, 0xC725}, //5429 #HANGUL SYLLABLE IEUNG YU NIEUNCIEUC
  {0x9FA6, 0xC726}, //5430 #HANGUL SYLLABLE IEUNG YU NIEUNHIEUH
  {0x9FA7, 0xC727}, //5431 #HANGUL SYLLABLE IEUNG YU TIKEUT
  {0x9FA8, 0xC729}, //5432 #HANGUL SYLLABLE IEUNG YU RIEULKIYEOK
  {0x9FA9, 0xC72A}, //5433 #HANGUL SYLLABLE IEUNG YU RIEULMIEUM
  {0x9FAA, 0xC72B}, //5434 #HANGUL SYLLABLE IEUNG YU RIEULPIEUP
  {0x9FAB, 0xC72C}, //5435 #HANGUL SYLLABLE IEUNG YU RIEULSIOS
  {0x9FAC, 0xC72D}, //5436 #HANGUL SYLLABLE IEUNG YU RIEULTHIEUTH
  {0x9FAD, 0xC72E}, //5437 #HANGUL SYLLABLE IEUNG YU RIEULPHIEUPH
  {0x9FAE, 0xC72F}, //5438 #HANGUL SYLLABLE IEUNG YU RIEULHIEUH
  {0x9FAF, 0xC732}, //5439 #HANGUL SYLLABLE IEUNG YU PIEUPSIOS
  {0x9FB0, 0xC734}, //5440 #HANGUL SYLLABLE IEUNG YU SSANGSIOS
  {0x9FB1, 0xC736}, //5441 #HANGUL SYLLABLE IEUNG YU CIEUC
  {0x9FB2, 0xC738}, //5442 #HANGUL SYLLABLE IEUNG YU KHIEUKH
  {0x9FB3, 0xC739}, //5443 #HANGUL SYLLABLE IEUNG YU THIEUTH
  {0x9FB4, 0xC73A}, //5444 #HANGUL SYLLABLE IEUNG YU PHIEUPH
  {0x9FB5, 0xC73B}, //5445 #HANGUL SYLLABLE IEUNG YU HIEUH
  {0x9FB6, 0xC73E}, //5446 #HANGUL SYLLABLE IEUNG EU SSANGKIYEOK
  {0x9FB7, 0xC73F}, //5447 #HANGUL SYLLABLE IEUNG EU KIYEOKSIOS
  {0x9FB8, 0xC741}, //5448 #HANGUL SYLLABLE IEUNG EU NIEUNCIEUC
  {0x9FB9, 0xC742}, //5449 #HANGUL SYLLABLE IEUNG EU NIEUNHIEUH
  {0x9FBA, 0xC743}, //5450 #HANGUL SYLLABLE IEUNG EU TIKEUT
  {0x9FBB, 0xC745}, //5451 #HANGUL SYLLABLE IEUNG EU RIEULKIYEOK
  {0x9FBC, 0xC746}, //5452 #HANGUL SYLLABLE IEUNG EU RIEULMIEUM
  {0x9FBD, 0xC747}, //5453 #HANGUL SYLLABLE IEUNG EU RIEULPIEUP
  {0x9FBE, 0xC748}, //5454 #HANGUL SYLLABLE IEUNG EU RIEULSIOS
  {0x9FBF, 0xC749}, //5455 #HANGUL SYLLABLE IEUNG EU RIEULTHIEUTH
  {0x9FC0, 0xC74B}, //5456 #HANGUL SYLLABLE IEUNG EU RIEULHIEUH
  {0x9FC1, 0xC74E}, //5457 #HANGUL SYLLABLE IEUNG EU PIEUPSIOS
  {0x9FC2, 0xC750}, //5458 #HANGUL SYLLABLE IEUNG EU SSANGSIOS
  {0x9FC3, 0xC759}, //5459 #HANGUL SYLLABLE IEUNG YI KIYEOK
  {0x9FC4, 0xC75A}, //5460 #HANGUL SYLLABLE IEUNG YI SSANGKIYEOK
  {0x9FC5, 0xC75B}, //5461 #HANGUL SYLLABLE IEUNG YI KIYEOKSIOS
  {0x9FC6, 0xC75D}, //5462 #HANGUL SYLLABLE IEUNG YI NIEUNCIEUC
  {0x9FC7, 0xC75E}, //5463 #HANGUL SYLLABLE IEUNG YI NIEUNHIEUH
  {0x9FC8, 0xC75F}, //5464 #HANGUL SYLLABLE IEUNG YI TIKEUT
  {0x9FC9, 0xC761}, //5465 #HANGUL SYLLABLE IEUNG YI RIEULKIYEOK
  {0x9FCA, 0xC762}, //5466 #HANGUL SYLLABLE IEUNG YI RIEULMIEUM
  {0x9FCB, 0xC763}, //5467 #HANGUL SYLLABLE IEUNG YI RIEULPIEUP
  {0x9FCC, 0xC764}, //5468 #HANGUL SYLLABLE IEUNG YI RIEULSIOS
  {0x9FCD, 0xC765}, //5469 #HANGUL SYLLABLE IEUNG YI RIEULTHIEUTH
  {0x9FCE, 0xC766}, //5470 #HANGUL SYLLABLE IEUNG YI RIEULPHIEUPH
  {0x9FCF, 0xC767}, //5471 #HANGUL SYLLABLE IEUNG YI RIEULHIEUH
  {0x9FD0, 0xC769}, //5472 #HANGUL SYLLABLE IEUNG YI PIEUP
  {0x9FD1, 0xC76A}, //5473 #HANGUL SYLLABLE IEUNG YI PIEUPSIOS
  {0x9FD2, 0xC76C}, //5474 #HANGUL SYLLABLE IEUNG YI SSANGSIOS
  {0x9FD3, 0xC76D}, //5475 #HANGUL SYLLABLE IEUNG YI IEUNG
  {0x9FD4, 0xC76E}, //5476 #HANGUL SYLLABLE IEUNG YI CIEUC
  {0x9FD5, 0xC76F}, //5477 #HANGUL SYLLABLE IEUNG YI CHIEUCH
  {0x9FD6, 0xC770}, //5478 #HANGUL SYLLABLE IEUNG YI KHIEUKH
  {0x9FD7, 0xC771}, //5479 #HANGUL SYLLABLE IEUNG YI THIEUTH
  {0x9FD8, 0xC772}, //5480 #HANGUL SYLLABLE IEUNG YI PHIEUPH
  {0x9FD9, 0xC773}, //5481 #HANGUL SYLLABLE IEUNG YI HIEUH
  {0x9FDA, 0xC776}, //5482 #HANGUL SYLLABLE IEUNG I SSANGKIYEOK
  {0x9FDB, 0xC777}, //5483 #HANGUL SYLLABLE IEUNG I KIYEOKSIOS
  {0x9FDC, 0xC779}, //5484 #HANGUL SYLLABLE IEUNG I NIEUNCIEUC
  {0x9FDD, 0xC77A}, //5485 #HANGUL SYLLABLE IEUNG I NIEUNHIEUH
  {0x9FDE, 0xC77B}, //5486 #HANGUL SYLLABLE IEUNG I TIKEUT
  {0x9FDF, 0xC77F}, //5487 #HANGUL SYLLABLE IEUNG I RIEULPIEUP
  {0x9FE0, 0xC780}, //5488 #HANGUL SYLLABLE IEUNG I RIEULSIOS
  {0x9FE1, 0xC781}, //5489 #HANGUL SYLLABLE IEUNG I RIEULTHIEUTH
  {0x9FE2, 0xC782}, //5490 #HANGUL SYLLABLE IEUNG I RIEULPHIEUPH
  {0x9FE3, 0xC786}, //5491 #HANGUL SYLLABLE IEUNG I PIEUPSIOS
  {0x9FE4, 0xC78B}, //5492 #HANGUL SYLLABLE IEUNG I CHIEUCH
  {0x9FE5, 0xC78C}, //5493 #HANGUL SYLLABLE IEUNG I KHIEUKH
  {0x9FE6, 0xC78D}, //5494 #HANGUL SYLLABLE IEUNG I THIEUTH
  {0x9FE7, 0xC78F}, //5495 #HANGUL SYLLABLE IEUNG I HIEUH
  {0x9FE8, 0xC792}, //5496 #HANGUL SYLLABLE CIEUC A SSANGKIYEOK
  {0x9FE9, 0xC793}, //5497 #HANGUL SYLLABLE CIEUC A KIYEOKSIOS
  {0x9FEA, 0xC795}, //5498 #HANGUL SYLLABLE CIEUC A NIEUNCIEUC
  {0x9FEB, 0xC799}, //5499 #HANGUL SYLLABLE CIEUC A RIEULKIYEOK
  {0x9FEC, 0xC79B}, //5500 #HANGUL SYLLABLE CIEUC A RIEULPIEUP
  {0x9FED, 0xC79C}, //5501 #HANGUL SYLLABLE CIEUC A RIEULSIOS
  {0x9FEE, 0xC79D}, //5502 #HANGUL SYLLABLE CIEUC A RIEULTHIEUTH
  {0x9FEF, 0xC79E}, //5503 #HANGUL SYLLABLE CIEUC A RIEULPHIEUPH
  {0x9FF0, 0xC79F}, //5504 #HANGUL SYLLABLE CIEUC A RIEULHIEUH
  {0x9FF1, 0xC7A2}, //5505 #HANGUL SYLLABLE CIEUC A PIEUPSIOS
  {0x9FF2, 0xC7A7}, //5506 #HANGUL SYLLABLE CIEUC A CHIEUCH
  {0x9FF3, 0xC7A8}, //5507 #HANGUL SYLLABLE CIEUC A KHIEUKH
  {0x9FF4, 0xC7A9}, //5508 #HANGUL SYLLABLE CIEUC A THIEUTH
  {0x9FF5, 0xC7AA}, //5509 #HANGUL SYLLABLE CIEUC A PHIEUPH
  {0x9FF6, 0xC7AB}, //5510 #HANGUL SYLLABLE CIEUC A HIEUH
  {0x9FF7, 0xC7AE}, //5511 #HANGUL SYLLABLE CIEUC AE SSANGKIYEOK
  {0x9FF8, 0xC7AF}, //5512 #HANGUL SYLLABLE CIEUC AE KIYEOKSIOS
  {0x9FF9, 0xC7B1}, //5513 #HANGUL SYLLABLE CIEUC AE NIEUNCIEUC
  {0x9FFA, 0xC7B2}, //5514 #HANGUL SYLLABLE CIEUC AE NIEUNHIEUH
  {0x9FFB, 0xC7B3}, //5515 #HANGUL SYLLABLE CIEUC AE TIKEUT
  {0x9FFC, 0xC7B5}, //5516 #HANGUL SYLLABLE CIEUC AE RIEULKIYEOK
  {0x9FFD, 0xC7B6}, //5517 #HANGUL SYLLABLE CIEUC AE RIEULMIEUM
  {0x9FFE, 0xC7B7}, //5518 #HANGUL SYLLABLE CIEUC AE RIEULPIEUP
  {0xA041, 0xC7B8}, //5519 #HANGUL SYLLABLE CIEUC AE RIEULSIOS
  {0xA042, 0xC7B9}, //5520 #HANGUL SYLLABLE CIEUC AE RIEULTHIEUTH
  {0xA043, 0xC7BA}, //5521 #HANGUL SYLLABLE CIEUC AE RIEULPHIEUPH
  {0xA044, 0xC7BB}, //5522 #HANGUL SYLLABLE CIEUC AE RIEULHIEUH
  {0xA045, 0xC7BE}, //5523 #HANGUL SYLLABLE CIEUC AE PIEUPSIOS
  {0xA046, 0xC7C2}, //5524 #HANGUL SYLLABLE CIEUC AE CIEUC
  {0xA047, 0xC7C3}, //5525 #HANGUL SYLLABLE CIEUC AE CHIEUCH
  {0xA048, 0xC7C4}, //5526 #HANGUL SYLLABLE CIEUC AE KHIEUKH
  {0xA049, 0xC7C5}, //5527 #HANGUL SYLLABLE CIEUC AE THIEUTH
  {0xA04A, 0xC7C6}, //5528 #HANGUL SYLLABLE CIEUC AE PHIEUPH
  {0xA04B, 0xC7C7}, //5529 #HANGUL SYLLABLE CIEUC AE HIEUH
  {0xA04C, 0xC7CA}, //5530 #HANGUL SYLLABLE CIEUC YA SSANGKIYEOK
  {0xA04D, 0xC7CB}, //5531 #HANGUL SYLLABLE CIEUC YA KIYEOKSIOS
  {0xA04E, 0xC7CD}, //5532 #HANGUL SYLLABLE CIEUC YA NIEUNCIEUC
  {0xA04F, 0xC7CF}, //5533 #HANGUL SYLLABLE CIEUC YA TIKEUT
  {0xA050, 0xC7D1}, //5534 #HANGUL SYLLABLE CIEUC YA RIEULKIYEOK
  {0xA051, 0xC7D2}, //5535 #HANGUL SYLLABLE CIEUC YA RIEULMIEUM
  {0xA052, 0xC7D3}, //5536 #HANGUL SYLLABLE CIEUC YA RIEULPIEUP
  {0xA053, 0xC7D4}, //5537 #HANGUL SYLLABLE CIEUC YA RIEULSIOS
  {0xA054, 0xC7D5}, //5538 #HANGUL SYLLABLE CIEUC YA RIEULTHIEUTH
  {0xA055, 0xC7D6}, //5539 #HANGUL SYLLABLE CIEUC YA RIEULPHIEUPH
  {0xA056, 0xC7D7}, //5540 #HANGUL SYLLABLE CIEUC YA RIEULHIEUH
  {0xA057, 0xC7D9}, //5541 #HANGUL SYLLABLE CIEUC YA PIEUP
  {0xA058, 0xC7DA}, //5542 #HANGUL SYLLABLE CIEUC YA PIEUPSIOS
  {0xA059, 0xC7DB}, //5543 #HANGUL SYLLABLE CIEUC YA SIOS
  {0xA05A, 0xC7DC}, //5544 #HANGUL SYLLABLE CIEUC YA SSANGSIOS
  {0xA061, 0xC7DE}, //5545 #HANGUL SYLLABLE CIEUC YA CIEUC
  {0xA062, 0xC7DF}, //5546 #HANGUL SYLLABLE CIEUC YA CHIEUCH
  {0xA063, 0xC7E0}, //5547 #HANGUL SYLLABLE CIEUC YA KHIEUKH
  {0xA064, 0xC7E1}, //5548 #HANGUL SYLLABLE CIEUC YA THIEUTH
  {0xA065, 0xC7E2}, //5549 #HANGUL SYLLABLE CIEUC YA PHIEUPH
  {0xA066, 0xC7E3}, //5550 #HANGUL SYLLABLE CIEUC YA HIEUH
  {0xA067, 0xC7E5}, //5551 #HANGUL SYLLABLE CIEUC YAE KIYEOK
  {0xA068, 0xC7E6}, //5552 #HANGUL SYLLABLE CIEUC YAE SSANGKIYEOK
  {0xA069, 0xC7E7}, //5553 #HANGUL SYLLABLE CIEUC YAE KIYEOKSIOS
  {0xA06A, 0xC7E9}, //5554 #HANGUL SYLLABLE CIEUC YAE NIEUNCIEUC
  {0xA06B, 0xC7EA}, //5555 #HANGUL SYLLABLE CIEUC YAE NIEUNHIEUH
  {0xA06C, 0xC7EB}, //5556 #HANGUL SYLLABLE CIEUC YAE TIKEUT
  {0xA06D, 0xC7ED}, //5557 #HANGUL SYLLABLE CIEUC YAE RIEULKIYEOK
  {0xA06E, 0xC7EE}, //5558 #HANGUL SYLLABLE CIEUC YAE RIEULMIEUM
  {0xA06F, 0xC7EF}, //5559 #HANGUL SYLLABLE CIEUC YAE RIEULPIEUP
  {0xA070, 0xC7F0}, //5560 #HANGUL SYLLABLE CIEUC YAE RIEULSIOS
  {0xA071, 0xC7F1}, //5561 #HANGUL SYLLABLE CIEUC YAE RIEULTHIEUTH
  {0xA072, 0xC7F2}, //5562 #HANGUL SYLLABLE CIEUC YAE RIEULPHIEUPH
  {0xA073, 0xC7F3}, //5563 #HANGUL SYLLABLE CIEUC YAE RIEULHIEUH
  {0xA074, 0xC7F4}, //5564 #HANGUL SYLLABLE CIEUC YAE MIEUM
  {0xA075, 0xC7F5}, //5565 #HANGUL SYLLABLE CIEUC YAE PIEUP
  {0xA076, 0xC7F6}, //5566 #HANGUL SYLLABLE CIEUC YAE PIEUPSIOS
  {0xA077, 0xC7F7}, //5567 #HANGUL SYLLABLE CIEUC YAE SIOS
  {0xA078, 0xC7F8}, //5568 #HANGUL SYLLABLE CIEUC YAE SSANGSIOS
  {0xA079, 0xC7F9}, //5569 #HANGUL SYLLABLE CIEUC YAE IEUNG
  {0xA07A, 0xC7FA}, //5570 #HANGUL SYLLABLE CIEUC YAE CIEUC
  {0xA081, 0xC7FB}, //5571 #HANGUL SYLLABLE CIEUC YAE CHIEUCH
  {0xA082, 0xC7FC}, //5572 #HANGUL SYLLABLE CIEUC YAE KHIEUKH
  {0xA083, 0xC7FD}, //5573 #HANGUL SYLLABLE CIEUC YAE THIEUTH
  {0xA084, 0xC7FE}, //5574 #HANGUL SYLLABLE CIEUC YAE PHIEUPH
  {0xA085, 0xC7FF}, //5575 #HANGUL SYLLABLE CIEUC YAE HIEUH
  {0xA086, 0xC802}, //5576 #HANGUL SYLLABLE CIEUC EO SSANGKIYEOK
  {0xA087, 0xC803}, //5577 #HANGUL SYLLABLE CIEUC EO KIYEOKSIOS
  {0xA088, 0xC805}, //5578 #HANGUL SYLLABLE CIEUC EO NIEUNCIEUC
  {0xA089, 0xC806}, //5579 #HANGUL SYLLABLE CIEUC EO NIEUNHIEUH
  {0xA08A, 0xC807}, //5580 #HANGUL SYLLABLE CIEUC EO TIKEUT
  {0xA08B, 0xC809}, //5581 #HANGUL SYLLABLE CIEUC EO RIEULKIYEOK
  {0xA08C, 0xC80B}, //5582 #HANGUL SYLLABLE CIEUC EO RIEULPIEUP
  {0xA08D, 0xC80C}, //5583 #HANGUL SYLLABLE CIEUC EO RIEULSIOS
  {0xA08E, 0xC80D}, //5584 #HANGUL SYLLABLE CIEUC EO RIEULTHIEUTH
  {0xA08F, 0xC80E}, //5585 #HANGUL SYLLABLE CIEUC EO RIEULPHIEUPH
  {0xA090, 0xC80F}, //5586 #HANGUL SYLLABLE CIEUC EO RIEULHIEUH
  {0xA091, 0xC812}, //5587 #HANGUL SYLLABLE CIEUC EO PIEUPSIOS
  {0xA092, 0xC814}, //5588 #HANGUL SYLLABLE CIEUC EO SSANGSIOS
  {0xA093, 0xC817}, //5589 #HANGUL SYLLABLE CIEUC EO CHIEUCH
  {0xA094, 0xC818}, //5590 #HANGUL SYLLABLE CIEUC EO KHIEUKH
  {0xA095, 0xC819}, //5591 #HANGUL SYLLABLE CIEUC EO THIEUTH
  {0xA096, 0xC81A}, //5592 #HANGUL SYLLABLE CIEUC EO PHIEUPH
  {0xA097, 0xC81B}, //5593 #HANGUL SYLLABLE CIEUC EO HIEUH
  {0xA098, 0xC81E}, //5594 #HANGUL SYLLABLE CIEUC E SSANGKIYEOK
  {0xA099, 0xC81F}, //5595 #HANGUL SYLLABLE CIEUC E KIYEOKSIOS
  {0xA09A, 0xC821}, //5596 #HANGUL SYLLABLE CIEUC E NIEUNCIEUC
  {0xA09B, 0xC822}, //5597 #HANGUL SYLLABLE CIEUC E NIEUNHIEUH
  {0xA09C, 0xC823}, //5598 #HANGUL SYLLABLE CIEUC E TIKEUT
  {0xA09D, 0xC825}, //5599 #HANGUL SYLLABLE CIEUC E RIEULKIYEOK
  {0xA09E, 0xC826}, //5600 #HANGUL SYLLABLE CIEUC E RIEULMIEUM
  {0xA09F, 0xC827}, //5601 #HANGUL SYLLABLE CIEUC E RIEULPIEUP
  {0xA0A0, 0xC828}, //5602 #HANGUL SYLLABLE CIEUC E RIEULSIOS
  {0xA0A1, 0xC829}, //5603 #HANGUL SYLLABLE CIEUC E RIEULTHIEUTH
  {0xA0A2, 0xC82A}, //5604 #HANGUL SYLLABLE CIEUC E RIEULPHIEUPH
  {0xA0A3, 0xC82B}, //5605 #HANGUL SYLLABLE CIEUC E RIEULHIEUH
  {0xA0A4, 0xC82E}, //5606 #HANGUL SYLLABLE CIEUC E PIEUPSIOS
  {0xA0A5, 0xC830}, //5607 #HANGUL SYLLABLE CIEUC E SSANGSIOS
  {0xA0A6, 0xC832}, //5608 #HANGUL SYLLABLE CIEUC E CIEUC
  {0xA0A7, 0xC833}, //5609 #HANGUL SYLLABLE CIEUC E CHIEUCH
  {0xA0A8, 0xC834}, //5610 #HANGUL SYLLABLE CIEUC E KHIEUKH
  {0xA0A9, 0xC835}, //5611 #HANGUL SYLLABLE CIEUC E THIEUTH
  {0xA0AA, 0xC836}, //5612 #HANGUL SYLLABLE CIEUC E PHIEUPH
  {0xA0AB, 0xC837}, //5613 #HANGUL SYLLABLE CIEUC E HIEUH
  {0xA0AC, 0xC839}, //5614 #HANGUL SYLLABLE CIEUC YEO KIYEOK
  {0xA0AD, 0xC83A}, //5615 #HANGUL SYLLABLE CIEUC YEO SSANGKIYEOK
  {0xA0AE, 0xC83B}, //5616 #HANGUL SYLLABLE CIEUC YEO KIYEOKSIOS
  {0xA0AF, 0xC83D}, //5617 #HANGUL SYLLABLE CIEUC YEO NIEUNCIEUC
  {0xA0B0, 0xC83E}, //5618 #HANGUL SYLLABLE CIEUC YEO NIEUNHIEUH
  {0xA0B1, 0xC83F}, //5619 #HANGUL SYLLABLE CIEUC YEO TIKEUT
  {0xA0B2, 0xC841}, //5620 #HANGUL SYLLABLE CIEUC YEO RIEULKIYEOK
  {0xA0B3, 0xC842}, //5621 #HANGUL SYLLABLE CIEUC YEO RIEULMIEUM
  {0xA0B4, 0xC843}, //5622 #HANGUL SYLLABLE CIEUC YEO RIEULPIEUP
  {0xA0B5, 0xC844}, //5623 #HANGUL SYLLABLE CIEUC YEO RIEULSIOS
  {0xA0B6, 0xC845}, //5624 #HANGUL SYLLABLE CIEUC YEO RIEULTHIEUTH
  {0xA0B7, 0xC846}, //5625 #HANGUL SYLLABLE CIEUC YEO RIEULPHIEUPH
  {0xA0B8, 0xC847}, //5626 #HANGUL SYLLABLE CIEUC YEO RIEULHIEUH
  {0xA0B9, 0xC84A}, //5627 #HANGUL SYLLABLE CIEUC YEO PIEUPSIOS
  {0xA0BA, 0xC84B}, //5628 #HANGUL SYLLABLE CIEUC YEO SIOS
  {0xA0BB, 0xC84E}, //5629 #HANGUL SYLLABLE CIEUC YEO CIEUC
  {0xA0BC, 0xC84F}, //5630 #HANGUL SYLLABLE CIEUC YEO CHIEUCH
  {0xA0BD, 0xC850}, //5631 #HANGUL SYLLABLE CIEUC YEO KHIEUKH
  {0xA0BE, 0xC851}, //5632 #HANGUL SYLLABLE CIEUC YEO THIEUTH
  {0xA0BF, 0xC852}, //5633 #HANGUL SYLLABLE CIEUC YEO PHIEUPH
  {0xA0C0, 0xC853}, //5634 #HANGUL SYLLABLE CIEUC YEO HIEUH
  {0xA0C1, 0xC855}, //5635 #HANGUL SYLLABLE CIEUC YE KIYEOK
  {0xA0C2, 0xC856}, //5636 #HANGUL SYLLABLE CIEUC YE SSANGKIYEOK
  {0xA0C3, 0xC857}, //5637 #HANGUL SYLLABLE CIEUC YE KIYEOKSIOS
  {0xA0C4, 0xC858}, //5638 #HANGUL SYLLABLE CIEUC YE NIEUN
  {0xA0C5, 0xC859}, //5639 #HANGUL SYLLABLE CIEUC YE NIEUNCIEUC
  {0xA0C6, 0xC85A}, //5640 #HANGUL SYLLABLE CIEUC YE NIEUNHIEUH
  {0xA0C7, 0xC85B}, //5641 #HANGUL SYLLABLE CIEUC YE TIKEUT
  {0xA0C8, 0xC85C}, //5642 #HANGUL SYLLABLE CIEUC YE RIEUL
  {0xA0C9, 0xC85D}, //5643 #HANGUL SYLLABLE CIEUC YE RIEULKIYEOK
  {0xA0CA, 0xC85E}, //5644 #HANGUL SYLLABLE CIEUC YE RIEULMIEUM
  {0xA0CB, 0xC85F}, //5645 #HANGUL SYLLABLE CIEUC YE RIEULPIEUP
  {0xA0CC, 0xC860}, //5646 #HANGUL SYLLABLE CIEUC YE RIEULSIOS
  {0xA0CD, 0xC861}, //5647 #HANGUL SYLLABLE CIEUC YE RIEULTHIEUTH
  {0xA0CE, 0xC862}, //5648 #HANGUL SYLLABLE CIEUC YE RIEULPHIEUPH
  {0xA0CF, 0xC863}, //5649 #HANGUL SYLLABLE CIEUC YE RIEULHIEUH
  {0xA0D0, 0xC864}, //5650 #HANGUL SYLLABLE CIEUC YE MIEUM
  {0xA0D1, 0xC865}, //5651 #HANGUL SYLLABLE CIEUC YE PIEUP
  {0xA0D2, 0xC866}, //5652 #HANGUL SYLLABLE CIEUC YE PIEUPSIOS
  {0xA0D3, 0xC867}, //5653 #HANGUL SYLLABLE CIEUC YE SIOS
  {0xA0D4, 0xC868}, //5654 #HANGUL SYLLABLE CIEUC YE SSANGSIOS
  {0xA0D5, 0xC869}, //5655 #HANGUL SYLLABLE CIEUC YE IEUNG
  {0xA0D6, 0xC86A}, //5656 #HANGUL SYLLABLE CIEUC YE CIEUC
  {0xA0D7, 0xC86B}, //5657 #HANGUL SYLLABLE CIEUC YE CHIEUCH
  {0xA0D8, 0xC86C}, //5658 #HANGUL SYLLABLE CIEUC YE KHIEUKH
  {0xA0D9, 0xC86D}, //5659 #HANGUL SYLLABLE CIEUC YE THIEUTH
  {0xA0DA, 0xC86E}, //5660 #HANGUL SYLLABLE CIEUC YE PHIEUPH
  {0xA0DB, 0xC86F}, //5661 #HANGUL SYLLABLE CIEUC YE HIEUH
  {0xA0DC, 0xC872}, //5662 #HANGUL SYLLABLE CIEUC O SSANGKIYEOK
  {0xA0DD, 0xC873}, //5663 #HANGUL SYLLABLE CIEUC O KIYEOKSIOS
  {0xA0DE, 0xC875}, //5664 #HANGUL SYLLABLE CIEUC O NIEUNCIEUC
  {0xA0DF, 0xC876}, //5665 #HANGUL SYLLABLE CIEUC O NIEUNHIEUH
  {0xA0E0, 0xC877}, //5666 #HANGUL SYLLABLE CIEUC O TIKEUT
  {0xA0E1, 0xC879}, //5667 #HANGUL SYLLABLE CIEUC O RIEULKIYEOK
  {0xA0E2, 0xC87B}, //5668 #HANGUL SYLLABLE CIEUC O RIEULPIEUP
  {0xA0E3, 0xC87C}, //5669 #HANGUL SYLLABLE CIEUC O RIEULSIOS
  {0xA0E4, 0xC87D}, //5670 #HANGUL SYLLABLE CIEUC O RIEULTHIEUTH
  {0xA0E5, 0xC87E}, //5671 #HANGUL SYLLABLE CIEUC O RIEULPHIEUPH
  {0xA0E6, 0xC87F}, //5672 #HANGUL SYLLABLE CIEUC O RIEULHIEUH
  {0xA0E7, 0xC882}, //5673 #HANGUL SYLLABLE CIEUC O PIEUPSIOS
  {0xA0E8, 0xC884}, //5674 #HANGUL SYLLABLE CIEUC O SSANGSIOS
  {0xA0E9, 0xC888}, //5675 #HANGUL SYLLABLE CIEUC O KHIEUKH
  {0xA0EA, 0xC889}, //5676 #HANGUL SYLLABLE CIEUC O THIEUTH
  {0xA0EB, 0xC88A}, //5677 #HANGUL SYLLABLE CIEUC O PHIEUPH
  {0xA0EC, 0xC88E}, //5678 #HANGUL SYLLABLE CIEUC WA SSANGKIYEOK
  {0xA0ED, 0xC88F}, //5679 #HANGUL SYLLABLE CIEUC WA KIYEOKSIOS
  {0xA0EE, 0xC890}, //5680 #HANGUL SYLLABLE CIEUC WA NIEUN
  {0xA0EF, 0xC891}, //5681 #HANGUL SYLLABLE CIEUC WA NIEUNCIEUC
  {0xA0F0, 0xC892}, //5682 #HANGUL SYLLABLE CIEUC WA NIEUNHIEUH
  {0xA0F1, 0xC893}, //5683 #HANGUL SYLLABLE CIEUC WA TIKEUT
  {0xA0F2, 0xC895}, //5684 #HANGUL SYLLABLE CIEUC WA RIEULKIYEOK
  {0xA0F3, 0xC896}, //5685 #HANGUL SYLLABLE CIEUC WA RIEULMIEUM
  {0xA0F4, 0xC897}, //5686 #HANGUL SYLLABLE CIEUC WA RIEULPIEUP
  {0xA0F5, 0xC898}, //5687 #HANGUL SYLLABLE CIEUC WA RIEULSIOS
  {0xA0F6, 0xC899}, //5688 #HANGUL SYLLABLE CIEUC WA RIEULTHIEUTH
  {0xA0F7, 0xC89A}, //5689 #HANGUL SYLLABLE CIEUC WA RIEULPHIEUPH
  {0xA0F8, 0xC89B}, //5690 #HANGUL SYLLABLE CIEUC WA RIEULHIEUH
  {0xA0F9, 0xC89C}, //5691 #HANGUL SYLLABLE CIEUC WA MIEUM
  {0xA0FA, 0xC89E}, //5692 #HANGUL SYLLABLE CIEUC WA PIEUPSIOS
  {0xA0FB, 0xC8A0}, //5693 #HANGUL SYLLABLE CIEUC WA SSANGSIOS
  {0xA0FC, 0xC8A2}, //5694 #HANGUL SYLLABLE CIEUC WA CIEUC
  {0xA0FD, 0xC8A3}, //5695 #HANGUL SYLLABLE CIEUC WA CHIEUCH
  {0xA0FE, 0xC8A4}, //5696 #HANGUL SYLLABLE CIEUC WA KHIEUKH
  {0xA141, 0xC8A5}, //5697 #HANGUL SYLLABLE CIEUC WA THIEUTH
  {0xA142, 0xC8A6}, //5698 #HANGUL SYLLABLE CIEUC WA PHIEUPH
  {0xA143, 0xC8A7}, //5699 #HANGUL SYLLABLE CIEUC WA HIEUH
  {0xA144, 0xC8A9}, //5700 #HANGUL SYLLABLE CIEUC WAE KIYEOK
  {0xA145, 0xC8AA}, //5701 #HANGUL SYLLABLE CIEUC WAE SSANGKIYEOK
  {0xA146, 0xC8AB}, //5702 #HANGUL SYLLABLE CIEUC WAE KIYEOKSIOS
  {0xA147, 0xC8AC}, //5703 #HANGUL SYLLABLE CIEUC WAE NIEUN
  {0xA148, 0xC8AD}, //5704 #HANGUL SYLLABLE CIEUC WAE NIEUNCIEUC
  {0xA149, 0xC8AE}, //5705 #HANGUL SYLLABLE CIEUC WAE NIEUNHIEUH
  {0xA14A, 0xC8AF}, //5706 #HANGUL SYLLABLE CIEUC WAE TIKEUT
  {0xA14B, 0xC8B0}, //5707 #HANGUL SYLLABLE CIEUC WAE RIEUL
  {0xA14C, 0xC8B1}, //5708 #HANGUL SYLLABLE CIEUC WAE RIEULKIYEOK
  {0xA14D, 0xC8B2}, //5709 #HANGUL SYLLABLE CIEUC WAE RIEULMIEUM
  {0xA14E, 0xC8B3}, //5710 #HANGUL SYLLABLE CIEUC WAE RIEULPIEUP
  {0xA14F, 0xC8B4}, //5711 #HANGUL SYLLABLE CIEUC WAE RIEULSIOS
  {0xA150, 0xC8B5}, //5712 #HANGUL SYLLABLE CIEUC WAE RIEULTHIEUTH
  {0xA151, 0xC8B6}, //5713 #HANGUL SYLLABLE CIEUC WAE RIEULPHIEUPH
  {0xA152, 0xC8B7}, //5714 #HANGUL SYLLABLE CIEUC WAE RIEULHIEUH
  {0xA153, 0xC8B8}, //5715 #HANGUL SYLLABLE CIEUC WAE MIEUM
  {0xA154, 0xC8B9}, //5716 #HANGUL SYLLABLE CIEUC WAE PIEUP
  {0xA155, 0xC8BA}, //5717 #HANGUL SYLLABLE CIEUC WAE PIEUPSIOS
  {0xA156, 0xC8BB}, //5718 #HANGUL SYLLABLE CIEUC WAE SIOS
  {0xA157, 0xC8BE}, //5719 #HANGUL SYLLABLE CIEUC WAE CIEUC
  {0xA158, 0xC8BF}, //5720 #HANGUL SYLLABLE CIEUC WAE CHIEUCH
  {0xA159, 0xC8C0}, //5721 #HANGUL SYLLABLE CIEUC WAE KHIEUKH
  {0xA15A, 0xC8C1}, //5722 #HANGUL SYLLABLE CIEUC WAE THIEUTH
  {0xA161, 0xC8C2}, //5723 #HANGUL SYLLABLE CIEUC WAE PHIEUPH
  {0xA162, 0xC8C3}, //5724 #HANGUL SYLLABLE CIEUC WAE HIEUH
  {0xA163, 0xC8C5}, //5725 #HANGUL SYLLABLE CIEUC OE KIYEOK
  {0xA164, 0xC8C6}, //5726 #HANGUL SYLLABLE CIEUC OE SSANGKIYEOK
  {0xA165, 0xC8C7}, //5727 #HANGUL SYLLABLE CIEUC OE KIYEOKSIOS
  {0xA166, 0xC8C9}, //5728 #HANGUL SYLLABLE CIEUC OE NIEUNCIEUC
  {0xA167, 0xC8CA}, //5729 #HANGUL SYLLABLE CIEUC OE NIEUNHIEUH
  {0xA168, 0xC8CB}, //5730 #HANGUL SYLLABLE CIEUC OE TIKEUT
  {0xA169, 0xC8CD}, //5731 #HANGUL SYLLABLE CIEUC OE RIEULKIYEOK
  {0xA16A, 0xC8CE}, //5732 #HANGUL SYLLABLE CIEUC OE RIEULMIEUM
  {0xA16B, 0xC8CF}, //5733 #HANGUL SYLLABLE CIEUC OE RIEULPIEUP
  {0xA16C, 0xC8D0}, //5734 #HANGUL SYLLABLE CIEUC OE RIEULSIOS
  {0xA16D, 0xC8D1}, //5735 #HANGUL SYLLABLE CIEUC OE RIEULTHIEUTH
  {0xA16E, 0xC8D2}, //5736 #HANGUL SYLLABLE CIEUC OE RIEULPHIEUPH
  {0xA16F, 0xC8D3}, //5737 #HANGUL SYLLABLE CIEUC OE RIEULHIEUH
  {0xA170, 0xC8D6}, //5738 #HANGUL SYLLABLE CIEUC OE PIEUPSIOS
  {0xA171, 0xC8D8}, //5739 #HANGUL SYLLABLE CIEUC OE SSANGSIOS
  {0xA172, 0xC8DA}, //5740 #HANGUL SYLLABLE CIEUC OE CIEUC
  {0xA173, 0xC8DB}, //5741 #HANGUL SYLLABLE CIEUC OE CHIEUCH
  {0xA174, 0xC8DC}, //5742 #HANGUL SYLLABLE CIEUC OE KHIEUKH
  {0xA175, 0xC8DD}, //5743 #HANGUL SYLLABLE CIEUC OE THIEUTH
  {0xA176, 0xC8DE}, //5744 #HANGUL SYLLABLE CIEUC OE PHIEUPH
  {0xA177, 0xC8DF}, //5745 #HANGUL SYLLABLE CIEUC OE HIEUH
  {0xA178, 0xC8E2}, //5746 #HANGUL SYLLABLE CIEUC YO SSANGKIYEOK
  {0xA179, 0xC8E3}, //5747 #HANGUL SYLLABLE CIEUC YO KIYEOKSIOS
  {0xA17A, 0xC8E5}, //5748 #HANGUL SYLLABLE CIEUC YO NIEUNCIEUC
  {0xA181, 0xC8E6}, //5749 #HANGUL SYLLABLE CIEUC YO NIEUNHIEUH
  {0xA182, 0xC8E7}, //5750 #HANGUL SYLLABLE CIEUC YO TIKEUT
  {0xA183, 0xC8E8}, //5751 #HANGUL SYLLABLE CIEUC YO RIEUL
  {0xA184, 0xC8E9}, //5752 #HANGUL SYLLABLE CIEUC YO RIEULKIYEOK
  {0xA185, 0xC8EA}, //5753 #HANGUL SYLLABLE CIEUC YO RIEULMIEUM
  {0xA186, 0xC8EB}, //5754 #HANGUL SYLLABLE CIEUC YO RIEULPIEUP
  {0xA187, 0xC8EC}, //5755 #HANGUL SYLLABLE CIEUC YO RIEULSIOS
  {0xA188, 0xC8ED}, //5756 #HANGUL SYLLABLE CIEUC YO RIEULTHIEUTH
  {0xA189, 0xC8EE}, //5757 #HANGUL SYLLABLE CIEUC YO RIEULPHIEUPH
  {0xA18A, 0xC8EF}, //5758 #HANGUL SYLLABLE CIEUC YO RIEULHIEUH
  {0xA18B, 0xC8F0}, //5759 #HANGUL SYLLABLE CIEUC YO MIEUM
  {0xA18C, 0xC8F1}, //5760 #HANGUL SYLLABLE CIEUC YO PIEUP
  {0xA18D, 0xC8F2}, //5761 #HANGUL SYLLABLE CIEUC YO PIEUPSIOS
  {0xA18E, 0xC8F3}, //5762 #HANGUL SYLLABLE CIEUC YO SIOS
  {0xA18F, 0xC8F4}, //5763 #HANGUL SYLLABLE CIEUC YO SSANGSIOS
  {0xA190, 0xC8F6}, //5764 #HANGUL SYLLABLE CIEUC YO CIEUC
  {0xA191, 0xC8F7}, //5765 #HANGUL SYLLABLE CIEUC YO CHIEUCH
  {0xA192, 0xC8F8}, //5766 #HANGUL SYLLABLE CIEUC YO KHIEUKH
  {0xA193, 0xC8F9}, //5767 #HANGUL SYLLABLE CIEUC YO THIEUTH
  {0xA194, 0xC8FA}, //5768 #HANGUL SYLLABLE CIEUC YO PHIEUPH
  {0xA195, 0xC8FB}, //5769 #HANGUL SYLLABLE CIEUC YO HIEUH
  {0xA196, 0xC8FE}, //5770 #HANGUL SYLLABLE CIEUC U SSANGKIYEOK
  {0xA197, 0xC8FF}, //5771 #HANGUL SYLLABLE CIEUC U KIYEOKSIOS
  {0xA198, 0xC901}, //5772 #HANGUL SYLLABLE CIEUC U NIEUNCIEUC
  {0xA199, 0xC902}, //5773 #HANGUL SYLLABLE CIEUC U NIEUNHIEUH
  {0xA19A, 0xC903}, //5774 #HANGUL SYLLABLE CIEUC U TIKEUT
  {0xA19B, 0xC907}, //5775 #HANGUL SYLLABLE CIEUC U RIEULPIEUP
  {0xA19C, 0xC908}, //5776 #HANGUL SYLLABLE CIEUC U RIEULSIOS
  {0xA19D, 0xC909}, //5777 #HANGUL SYLLABLE CIEUC U RIEULTHIEUTH
  {0xA19E, 0xC90A}, //5778 #HANGUL SYLLABLE CIEUC U RIEULPHIEUPH
  {0xA19F, 0xC90B}, //5779 #HANGUL SYLLABLE CIEUC U RIEULHIEUH
  {0xA1A0, 0xC90E}, //5780 #HANGUL SYLLABLE CIEUC U PIEUPSIOS
  {0xA1A1, 0x3000}, //5781 #IDEOGRAPHIC SPACE
  {0xA1A2, 0x3001}, //5782 #IDEOGRAPHIC COMMA
  {0xA1A3, 0x3002}, //5783 #IDEOGRAPHIC FULL STOP
  {0xA1A4, 0x00B7}, //5784 #MIDDLE DOT
  {0xA1A5, 0x2025}, //5785 #TWO DOT LEADER
  {0xA1A6, 0x2026}, //5786 #HORIZONTAL ELLIPSIS
  {0xA1A7, 0x00A8}, //5787 #DIAERESIS
  {0xA1A8, 0x3003}, //5788 #DITTO MARK
  {0xA1A9, 0x00AD}, //5789 #SOFT HYPHEN
  {0xA1AA, 0x2015}, //5790 #HORIZONTAL BAR
  {0xA1AB, 0x2225}, //5791 #PARALLEL TO
  {0xA1AC, 0xFF3C}, //5792 #FULLWIDTH REVERSE SOLIDUS
  {0xA1AD, 0x223C}, //5793 #TILDE OPERATOR
  {0xA1AE, 0x2018}, //5794 #LEFT SINGLE QUOTATION MARK
  {0xA1AF, 0x2019}, //5795 #RIGHT SINGLE QUOTATION MARK
  {0xA1B0, 0x201C}, //5796 #LEFT DOUBLE QUOTATION MARK
  {0xA1B1, 0x201D}, //5797 #RIGHT DOUBLE QUOTATION MARK
  {0xA1B2, 0x3014}, //5798 #LEFT TORTOISE SHELL BRACKET
  {0xA1B3, 0x3015}, //5799 #RIGHT TORTOISE SHELL BRACKET
  {0xA1B4, 0x3008}, //5800 #LEFT ANGLE BRACKET
  {0xA1B5, 0x3009}, //5801 #RIGHT ANGLE BRACKET
  {0xA1B6, 0x300A}, //5802 #LEFT DOUBLE ANGLE BRACKET
  {0xA1B7, 0x300B}, //5803 #RIGHT DOUBLE ANGLE BRACKET
  {0xA1B8, 0x300C}, //5804 #LEFT CORNER BRACKET
  {0xA1B9, 0x300D}, //5805 #RIGHT CORNER BRACKET
  {0xA1BA, 0x300E}, //5806 #LEFT WHITE CORNER BRACKET
  {0xA1BB, 0x300F}, //5807 #RIGHT WHITE CORNER BRACKET
  {0xA1BC, 0x3010}, //5808 #LEFT BLACK LENTICULAR BRACKET
  {0xA1BD, 0x3011}, //5809 #RIGHT BLACK LENTICULAR BRACKET
  {0xA1BE, 0x00B1}, //5810 #PLUS-MINUS SIGN
  {0xA1BF, 0x00D7}, //5811 #MULTIPLICATION SIGN
  {0xA1C0, 0x00F7}, //5812 #DIVISION SIGN
  {0xA1C1, 0x2260}, //5813 #NOT EQUAL TO
  {0xA1C2, 0x2264}, //5814 #LESS-THAN OR EQUAL TO
  {0xA1C3, 0x2265}, //5815 #GREATER-THAN OR EQUAL TO
  {0xA1C4, 0x221E}, //5816 #INFINITY
  {0xA1C5, 0x2234}, //5817 #THEREFORE
  {0xA1C6, 0x00B0}, //5818 #DEGREE SIGN
  {0xA1C7, 0x2032}, //5819 #PRIME
  {0xA1C8, 0x2033}, //5820 #DOUBLE PRIME
  {0xA1C9, 0x2103}, //5821 #DEGREE CELSIUS
  {0xA1CA, 0x212B}, //5822 #ANGSTROM SIGN
  {0xA1CB, 0xFFE0}, //5823 #FULLWIDTH CENT SIGN
  {0xA1CC, 0xFFE1}, //5824 #FULLWIDTH POUND SIGN
  {0xA1CD, 0xFFE5}, //5825 #FULLWIDTH YEN SIGN
  {0xA1CE, 0x2642}, //5826 #MALE SIGN
  {0xA1CF, 0x2640}, //5827 #FEMALE SIGN
  {0xA1D0, 0x2220}, //5828 #ANGLE
  {0xA1D1, 0x22A5}, //5829 #UP TACK
  {0xA1D2, 0x2312}, //5830 #ARC
  {0xA1D3, 0x2202}, //5831 #PARTIAL DIFFERENTIAL
  {0xA1D4, 0x2207}, //5832 #NABLA
  {0xA1D5, 0x2261}, //5833 #IDENTICAL TO
  {0xA1D6, 0x2252}, //5834 #APPROXIMATELY EQUAL TO OR THE IMAGE OF
  {0xA1D7, 0x00A7}, //5835 #SECTION SIGN
  {0xA1D8, 0x203B}, //5836 #REFERENCE MARK
  {0xA1D9, 0x2606}, //5837 #WHITE STAR
  {0xA1DA, 0x2605}, //5838 #BLACK STAR
  {0xA1DB, 0x25CB}, //5839 #WHITE CIRCLE
  {0xA1DC, 0x25CF}, //5840 #BLACK CIRCLE
  {0xA1DD, 0x25CE}, //5841 #BULLSEYE
  {0xA1DE, 0x25C7}, //5842 #WHITE DIAMOND
  {0xA1DF, 0x25C6}, //5843 #BLACK DIAMOND
  {0xA1E0, 0x25A1}, //5844 #WHITE SQUARE
  {0xA1E1, 0x25A0}, //5845 #BLACK SQUARE
  {0xA1E2, 0x25B3}, //5846 #WHITE UP-POINTING TRIANGLE
  {0xA1E3, 0x25B2}, //5847 #BLACK UP-POINTING TRIANGLE
  {0xA1E4, 0x25BD}, //5848 #WHITE DOWN-POINTING TRIANGLE
  {0xA1E5, 0x25BC}, //5849 #BLACK DOWN-POINTING TRIANGLE
  {0xA1E6, 0x2192}, //5850 #RIGHTWARDS ARROW
  {0xA1E7, 0x2190}, //5851 #LEFTWARDS ARROW
  {0xA1E8, 0x2191}, //5852 #UPWARDS ARROW
  {0xA1E9, 0x2193}, //5853 #DOWNWARDS ARROW
  {0xA1EA, 0x2194}, //5854 #LEFT RIGHT ARROW
  {0xA1EB, 0x3013}, //5855 #GETA MARK
  {0xA1EC, 0x226A}, //5856 #MUCH LESS-THAN
  {0xA1ED, 0x226B}, //5857 #MUCH GREATER-THAN
  {0xA1EE, 0x221A}, //5858 #SQUARE ROOT
  {0xA1EF, 0x223D}, //5859 #REVERSED TILDE
  {0xA1F0, 0x221D}, //5860 #PROPORTIONAL TO
  {0xA1F1, 0x2235}, //5861 #BECAUSE
  {0xA1F2, 0x222B}, //5862 #INTEGRAL
  {0xA1F3, 0x222C}, //5863 #DOUBLE INTEGRAL
  {0xA1F4, 0x2208}, //5864 #ELEMENT OF
  {0xA1F5, 0x220B}, //5865 #CONTAINS AS MEMBER
  {0xA1F6, 0x2286}, //5866 #SUBSET OF OR EQUAL TO
  {0xA1F7, 0x2287}, //5867 #SUPERSET OF OR EQUAL TO
  {0xA1F8, 0x2282}, //5868 #SUBSET OF
  {0xA1F9, 0x2283}, //5869 #SUPERSET OF
  {0xA1FA, 0x222A}, //5870 #UNION
  {0xA1FB, 0x2229}, //5871 #INTERSECTION
  {0xA1FC, 0x2227}, //5872 #LOGICAL AND
  {0xA1FD, 0x2228}, //5873 #LOGICAL OR
  {0xA1FE, 0xFFE2}, //5874 #FULLWIDTH NOT SIGN
  {0xA241, 0xC910}, //5875 #HANGUL SYLLABLE CIEUC U SSANGSIOS
  {0xA242, 0xC912}, //5876 #HANGUL SYLLABLE CIEUC U CIEUC
  {0xA243, 0xC913}, //5877 #HANGUL SYLLABLE CIEUC U CHIEUCH
  {0xA244, 0xC914}, //5878 #HANGUL SYLLABLE CIEUC U KHIEUKH
  {0xA245, 0xC915}, //5879 #HANGUL SYLLABLE CIEUC U THIEUTH
  {0xA246, 0xC916}, //5880 #HANGUL SYLLABLE CIEUC U PHIEUPH
  {0xA247, 0xC917}, //5881 #HANGUL SYLLABLE CIEUC U HIEUH
  {0xA248, 0xC919}, //5882 #HANGUL SYLLABLE CIEUC WEO KIYEOK
  {0xA249, 0xC91A}, //5883 #HANGUL SYLLABLE CIEUC WEO SSANGKIYEOK
  {0xA24A, 0xC91B}, //5884 #HANGUL SYLLABLE CIEUC WEO KIYEOKSIOS
  {0xA24B, 0xC91C}, //5885 #HANGUL SYLLABLE CIEUC WEO NIEUN
  {0xA24C, 0xC91D}, //5886 #HANGUL SYLLABLE CIEUC WEO NIEUNCIEUC
  {0xA24D, 0xC91E}, //5887 #HANGUL SYLLABLE CIEUC WEO NIEUNHIEUH
  {0xA24E, 0xC91F}, //5888 #HANGUL SYLLABLE CIEUC WEO TIKEUT
  {0xA24F, 0xC920}, //5889 #HANGUL SYLLABLE CIEUC WEO RIEUL
  {0xA250, 0xC921}, //5890 #HANGUL SYLLABLE CIEUC WEO RIEULKIYEOK
  {0xA251, 0xC922}, //5891 #HANGUL SYLLABLE CIEUC WEO RIEULMIEUM
  {0xA252, 0xC923}, //5892 #HANGUL SYLLABLE CIEUC WEO RIEULPIEUP
  {0xA253, 0xC924}, //5893 #HANGUL SYLLABLE CIEUC WEO RIEULSIOS
  {0xA254, 0xC925}, //5894 #HANGUL SYLLABLE CIEUC WEO RIEULTHIEUTH
  {0xA255, 0xC926}, //5895 #HANGUL SYLLABLE CIEUC WEO RIEULPHIEUPH
  {0xA256, 0xC927}, //5896 #HANGUL SYLLABLE CIEUC WEO RIEULHIEUH
  {0xA257, 0xC928}, //5897 #HANGUL SYLLABLE CIEUC WEO MIEUM
  {0xA258, 0xC929}, //5898 #HANGUL SYLLABLE CIEUC WEO PIEUP
  {0xA259, 0xC92A}, //5899 #HANGUL SYLLABLE CIEUC WEO PIEUPSIOS
  {0xA25A, 0xC92B}, //5900 #HANGUL SYLLABLE CIEUC WEO SIOS
  {0xA261, 0xC92D}, //5901 #HANGUL SYLLABLE CIEUC WEO IEUNG
  {0xA262, 0xC92E}, //5902 #HANGUL SYLLABLE CIEUC WEO CIEUC
  {0xA263, 0xC92F}, //5903 #HANGUL SYLLABLE CIEUC WEO CHIEUCH
  {0xA264, 0xC930}, //5904 #HANGUL SYLLABLE CIEUC WEO KHIEUKH
  {0xA265, 0xC931}, //5905 #HANGUL SYLLABLE CIEUC WEO THIEUTH
  {0xA266, 0xC932}, //5906 #HANGUL SYLLABLE CIEUC WEO PHIEUPH
  {0xA267, 0xC933}, //5907 #HANGUL SYLLABLE CIEUC WEO HIEUH
  {0xA268, 0xC935}, //5908 #HANGUL SYLLABLE CIEUC WE KIYEOK
  {0xA269, 0xC936}, //5909 #HANGUL SYLLABLE CIEUC WE SSANGKIYEOK
  {0xA26A, 0xC937}, //5910 #HANGUL SYLLABLE CIEUC WE KIYEOKSIOS
  {0xA26B, 0xC938}, //5911 #HANGUL SYLLABLE CIEUC WE NIEUN
  {0xA26C, 0xC939}, //5912 #HANGUL SYLLABLE CIEUC WE NIEUNCIEUC
  {0xA26D, 0xC93A}, //5913 #HANGUL SYLLABLE CIEUC WE NIEUNHIEUH
  {0xA26E, 0xC93B}, //5914 #HANGUL SYLLABLE CIEUC WE TIKEUT
  {0xA26F, 0xC93C}, //5915 #HANGUL SYLLABLE CIEUC WE RIEUL
  {0xA270, 0xC93D}, //5916 #HANGUL SYLLABLE CIEUC WE RIEULKIYEOK
  {0xA271, 0xC93E}, //5917 #HANGUL SYLLABLE CIEUC WE RIEULMIEUM
  {0xA272, 0xC93F}, //5918 #HANGUL SYLLABLE CIEUC WE RIEULPIEUP
  {0xA273, 0xC940}, //5919 #HANGUL SYLLABLE CIEUC WE RIEULSIOS
  {0xA274, 0xC941}, //5920 #HANGUL SYLLABLE CIEUC WE RIEULTHIEUTH
  {0xA275, 0xC942}, //5921 #HANGUL SYLLABLE CIEUC WE RIEULPHIEUPH
  {0xA276, 0xC943}, //5922 #HANGUL SYLLABLE CIEUC WE RIEULHIEUH
  {0xA277, 0xC944}, //5923 #HANGUL SYLLABLE CIEUC WE MIEUM
  {0xA278, 0xC945}, //5924 #HANGUL SYLLABLE CIEUC WE PIEUP
  {0xA279, 0xC946}, //5925 #HANGUL SYLLABLE CIEUC WE PIEUPSIOS
  {0xA27A, 0xC947}, //5926 #HANGUL SYLLABLE CIEUC WE SIOS
  {0xA281, 0xC948}, //5927 #HANGUL SYLLABLE CIEUC WE SSANGSIOS
  {0xA282, 0xC949}, //5928 #HANGUL SYLLABLE CIEUC WE IEUNG
  {0xA283, 0xC94A}, //5929 #HANGUL SYLLABLE CIEUC WE CIEUC
  {0xA284, 0xC94B}, //5930 #HANGUL SYLLABLE CIEUC WE CHIEUCH
  {0xA285, 0xC94C}, //5931 #HANGUL SYLLABLE CIEUC WE KHIEUKH
  {0xA286, 0xC94D}, //5932 #HANGUL SYLLABLE CIEUC WE THIEUTH
  {0xA287, 0xC94E}, //5933 #HANGUL SYLLABLE CIEUC WE PHIEUPH
  {0xA288, 0xC94F}, //5934 #HANGUL SYLLABLE CIEUC WE HIEUH
  {0xA289, 0xC952}, //5935 #HANGUL SYLLABLE CIEUC WI SSANGKIYEOK
  {0xA28A, 0xC953}, //5936 #HANGUL SYLLABLE CIEUC WI KIYEOKSIOS
  {0xA28B, 0xC955}, //5937 #HANGUL SYLLABLE CIEUC WI NIEUNCIEUC
  {0xA28C, 0xC956}, //5938 #HANGUL SYLLABLE CIEUC WI NIEUNHIEUH
  {0xA28D, 0xC957}, //5939 #HANGUL SYLLABLE CIEUC WI TIKEUT
  {0xA28E, 0xC959}, //5940 #HANGUL SYLLABLE CIEUC WI RIEULKIYEOK
  {0xA28F, 0xC95A}, //5941 #HANGUL SYLLABLE CIEUC WI RIEULMIEUM
  {0xA290, 0xC95B}, //5942 #HANGUL SYLLABLE CIEUC WI RIEULPIEUP
  {0xA291, 0xC95C}, //5943 #HANGUL SYLLABLE CIEUC WI RIEULSIOS
  {0xA292, 0xC95D}, //5944 #HANGUL SYLLABLE CIEUC WI RIEULTHIEUTH
  {0xA293, 0xC95E}, //5945 #HANGUL SYLLABLE CIEUC WI RIEULPHIEUPH
  {0xA294, 0xC95F}, //5946 #HANGUL SYLLABLE CIEUC WI RIEULHIEUH
  {0xA295, 0xC962}, //5947 #HANGUL SYLLABLE CIEUC WI PIEUPSIOS
  {0xA296, 0xC964}, //5948 #HANGUL SYLLABLE CIEUC WI SSANGSIOS
  {0xA297, 0xC965}, //5949 #HANGUL SYLLABLE CIEUC WI IEUNG
  {0xA298, 0xC966}, //5950 #HANGUL SYLLABLE CIEUC WI CIEUC
  {0xA299, 0xC967}, //5951 #HANGUL SYLLABLE CIEUC WI CHIEUCH
  {0xA29A, 0xC968}, //5952 #HANGUL SYLLABLE CIEUC WI KHIEUKH
  {0xA29B, 0xC969}, //5953 #HANGUL SYLLABLE CIEUC WI THIEUTH
  {0xA29C, 0xC96A}, //5954 #HANGUL SYLLABLE CIEUC WI PHIEUPH
  {0xA29D, 0xC96B}, //5955 #HANGUL SYLLABLE CIEUC WI HIEUH
  {0xA29E, 0xC96D}, //5956 #HANGUL SYLLABLE CIEUC YU KIYEOK
  {0xA29F, 0xC96E}, //5957 #HANGUL SYLLABLE CIEUC YU SSANGKIYEOK
  {0xA2A0, 0xC96F}, //5958 #HANGUL SYLLABLE CIEUC YU KIYEOKSIOS
  {0xA2A1, 0x21D2}, //5959 #RIGHTWARDS DOUBLE ARROW
  {0xA2A2, 0x21D4}, //5960 #LEFT RIGHT DOUBLE ARROW
  {0xA2A3, 0x2200}, //5961 #FOR ALL
  {0xA2A4, 0x2203}, //5962 #THERE EXISTS
  {0xA2A5, 0x00B4}, //5963 #ACUTE ACCENT
  {0xA2A6, 0xFF5E}, //5964 #FULLWIDTH TILDE
  {0xA2A7, 0x02C7}, //5965 #CARON
  {0xA2A8, 0x02D8}, //5966 #BREVE
  {0xA2A9, 0x02DD}, //5967 #DOUBLE ACUTE ACCENT
  {0xA2AA, 0x02DA}, //5968 #RING ABOVE
  {0xA2AB, 0x02D9}, //5969 #DOT ABOVE
  {0xA2AC, 0x00B8}, //5970 #CEDILLA
  {0xA2AD, 0x02DB}, //5971 #OGONEK
  {0xA2AE, 0x00A1}, //5972 #INVERTED EXCLAMATION MARK
  {0xA2AF, 0x00BF}, //5973 #INVERTED QUESTION MARK
  {0xA2B0, 0x02D0}, //5974 #MODIFIER LETTER TRIANGULAR COLON
  {0xA2B1, 0x222E}, //5975 #CONTOUR INTEGRAL
  {0xA2B2, 0x2211}, //5976 #N-ARY SUMMATION
  {0xA2B3, 0x220F}, //5977 #N-ARY PRODUCT
  {0xA2B4, 0x00A4}, //5978 #CURRENCY SIGN
  {0xA2B5, 0x2109}, //5979 #DEGREE FAHRENHEIT
  {0xA2B6, 0x2030}, //5980 #PER MILLE SIGN
  {0xA2B7, 0x25C1}, //5981 #WHITE LEFT-POINTING TRIANGLE
  {0xA2B8, 0x25C0}, //5982 #BLACK LEFT-POINTING TRIANGLE
  {0xA2B9, 0x25B7}, //5983 #WHITE RIGHT-POINTING TRIANGLE
  {0xA2BA, 0x25B6}, //5984 #BLACK RIGHT-POINTING TRIANGLE
  {0xA2BB, 0x2664}, //5985 #WHITE SPADE SUIT
  {0xA2BC, 0x2660}, //5986 #BLACK SPADE SUIT
  {0xA2BD, 0x2661}, //5987 #WHITE HEART SUIT
  {0xA2BE, 0x2665}, //5988 #BLACK HEART SUIT
  {0xA2BF, 0x2667}, //5989 #WHITE CLUB SUIT
  {0xA2C0, 0x2663}, //5990 #BLACK CLUB SUIT
  {0xA2C1, 0x2299}, //5991 #CIRCLED DOT OPERATOR
  {0xA2C2, 0x25C8}, //5992 #WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
  {0xA2C3, 0x25A3}, //5993 #WHITE SQUARE CONTAINING BLACK SMALL SQUARE
  {0xA2C4, 0x25D0}, //5994 #CIRCLE WITH LEFT HALF BLACK
  {0xA2C5, 0x25D1}, //5995 #CIRCLE WITH RIGHT HALF BLACK
  {0xA2C6, 0x2592}, //5996 #MEDIUM SHADE
  {0xA2C7, 0x25A4}, //5997 #SQUARE WITH HORIZONTAL FILL
  {0xA2C8, 0x25A5}, //5998 #SQUARE WITH VERTICAL FILL
  {0xA2C9, 0x25A8}, //5999 #SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
  {0xA2CA, 0x25A7}, //6000 #SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
  {0xA2CB, 0x25A6}, //6001 #SQUARE WITH ORTHOGONAL CROSSHATCH FILL
  {0xA2CC, 0x25A9}, //6002 #SQUARE WITH DIAGONAL CROSSHATCH FILL
  {0xA2CD, 0x2668}, //6003 #HOT SPRINGS
  {0xA2CE, 0x260F}, //6004 #WHITE TELEPHONE
  {0xA2CF, 0x260E}, //6005 #BLACK TELEPHONE
  {0xA2D0, 0x261C}, //6006 #WHITE LEFT POINTING INDEX
  {0xA2D1, 0x261E}, //6007 #WHITE RIGHT POINTING INDEX
  {0xA2D2, 0x00B6}, //6008 #PILCROW SIGN
  {0xA2D3, 0x2020}, //6009 #DAGGER
  {0xA2D4, 0x2021}, //6010 #DOUBLE DAGGER
  {0xA2D5, 0x2195}, //6011 #UP DOWN ARROW
  {0xA2D6, 0x2197}, //6012 #NORTH EAST ARROW
  {0xA2D7, 0x2199}, //6013 #SOUTH WEST ARROW
  {0xA2D8, 0x2196}, //6014 #NORTH WEST ARROW
  {0xA2D9, 0x2198}, //6015 #SOUTH EAST ARROW
  {0xA2DA, 0x266D}, //6016 #MUSIC FLAT SIGN
  {0xA2DB, 0x2669}, //6017 #QUARTER NOTE
  {0xA2DC, 0x266A}, //6018 #EIGHTH NOTE
  {0xA2DD, 0x266C}, //6019 #BEAMED SIXTEENTH NOTES
  {0xA2DE, 0x327F}, //6020 #KOREAN STANDARD SYMBOL
  {0xA2DF, 0x321C}, //6021 #PARENTHESIZED HANGUL CIEUC U
  {0xA2E0, 0x2116}, //6022 #NUMERO SIGN
  {0xA2E1, 0x33C7}, //6023 #SQUARE CO
  {0xA2E2, 0x2122}, //6024 #TRADE MARK SIGN
  {0xA2E3, 0x33C2}, //6025 #SQUARE AM
  {0xA2E4, 0x33D8}, //6026 #SQUARE PM
  {0xA2E5, 0x2121}, //6027 #TELEPHONE SIGN
  {0xA2E6, 0x20AC}, //6028 #EURO SIGN
  {0xA2E7, 0x00AE}, //6029 #REGISTERED SIGN
  {0xA341, 0xC971}, //6030 #HANGUL SYLLABLE CIEUC YU NIEUNCIEUC
  {0xA342, 0xC972}, //6031 #HANGUL SYLLABLE CIEUC YU NIEUNHIEUH
  {0xA343, 0xC973}, //6032 #HANGUL SYLLABLE CIEUC YU TIKEUT
  {0xA344, 0xC975}, //6033 #HANGUL SYLLABLE CIEUC YU RIEULKIYEOK
  {0xA345, 0xC976}, //6034 #HANGUL SYLLABLE CIEUC YU RIEULMIEUM
  {0xA346, 0xC977}, //6035 #HANGUL SYLLABLE CIEUC YU RIEULPIEUP
  {0xA347, 0xC978}, //6036 #HANGUL SYLLABLE CIEUC YU RIEULSIOS
  {0xA348, 0xC979}, //6037 #HANGUL SYLLABLE CIEUC YU RIEULTHIEUTH
  {0xA349, 0xC97A}, //6038 #HANGUL SYLLABLE CIEUC YU RIEULPHIEUPH
  {0xA34A, 0xC97B}, //6039 #HANGUL SYLLABLE CIEUC YU RIEULHIEUH
  {0xA34B, 0xC97D}, //6040 #HANGUL SYLLABLE CIEUC YU PIEUP
  {0xA34C, 0xC97E}, //6041 #HANGUL SYLLABLE CIEUC YU PIEUPSIOS
  {0xA34D, 0xC97F}, //6042 #HANGUL SYLLABLE CIEUC YU SIOS
  {0xA34E, 0xC980}, //6043 #HANGUL SYLLABLE CIEUC YU SSANGSIOS
  {0xA34F, 0xC981}, //6044 #HANGUL SYLLABLE CIEUC YU IEUNG
  {0xA350, 0xC982}, //6045 #HANGUL SYLLABLE CIEUC YU CIEUC
  {0xA351, 0xC983}, //6046 #HANGUL SYLLABLE CIEUC YU CHIEUCH
  {0xA352, 0xC984}, //6047 #HANGUL SYLLABLE CIEUC YU KHIEUKH
  {0xA353, 0xC985}, //6048 #HANGUL SYLLABLE CIEUC YU THIEUTH
  {0xA354, 0xC986}, //6049 #HANGUL SYLLABLE CIEUC YU PHIEUPH
  {0xA355, 0xC987}, //6050 #HANGUL SYLLABLE CIEUC YU HIEUH
  {0xA356, 0xC98A}, //6051 #HANGUL SYLLABLE CIEUC EU SSANGKIYEOK
  {0xA357, 0xC98B}, //6052 #HANGUL SYLLABLE CIEUC EU KIYEOKSIOS
  {0xA358, 0xC98D}, //6053 #HANGUL SYLLABLE CIEUC EU NIEUNCIEUC
  {0xA359, 0xC98E}, //6054 #HANGUL SYLLABLE CIEUC EU NIEUNHIEUH
  {0xA35A, 0xC98F}, //6055 #HANGUL SYLLABLE CIEUC EU TIKEUT
  {0xA361, 0xC991}, //6056 #HANGUL SYLLABLE CIEUC EU RIEULKIYEOK
  {0xA362, 0xC992}, //6057 #HANGUL SYLLABLE CIEUC EU RIEULMIEUM
  {0xA363, 0xC993}, //6058 #HANGUL SYLLABLE CIEUC EU RIEULPIEUP
  {0xA364, 0xC994}, //6059 #HANGUL SYLLABLE CIEUC EU RIEULSIOS
  {0xA365, 0xC995}, //6060 #HANGUL SYLLABLE CIEUC EU RIEULTHIEUTH
  {0xA366, 0xC996}, //6061 #HANGUL SYLLABLE CIEUC EU RIEULPHIEUPH
  {0xA367, 0xC997}, //6062 #HANGUL SYLLABLE CIEUC EU RIEULHIEUH
  {0xA368, 0xC99A}, //6063 #HANGUL SYLLABLE CIEUC EU PIEUPSIOS
  {0xA369, 0xC99C}, //6064 #HANGUL SYLLABLE CIEUC EU SSANGSIOS
  {0xA36A, 0xC99E}, //6065 #HANGUL SYLLABLE CIEUC EU CIEUC
  {0xA36B, 0xC99F}, //6066 #HANGUL SYLLABLE CIEUC EU CHIEUCH
  {0xA36C, 0xC9A0}, //6067 #HANGUL SYLLABLE CIEUC EU KHIEUKH
  {0xA36D, 0xC9A1}, //6068 #HANGUL SYLLABLE CIEUC EU THIEUTH
  {0xA36E, 0xC9A2}, //6069 #HANGUL SYLLABLE CIEUC EU PHIEUPH
  {0xA36F, 0xC9A3}, //6070 #HANGUL SYLLABLE CIEUC EU HIEUH
  {0xA370, 0xC9A4}, //6071 #HANGUL SYLLABLE CIEUC YI
  {0xA371, 0xC9A5}, //6072 #HANGUL SYLLABLE CIEUC YI KIYEOK
  {0xA372, 0xC9A6}, //6073 #HANGUL SYLLABLE CIEUC YI SSANGKIYEOK
  {0xA373, 0xC9A7}, //6074 #HANGUL SYLLABLE CIEUC YI KIYEOKSIOS
  {0xA374, 0xC9A8}, //6075 #HANGUL SYLLABLE CIEUC YI NIEUN
  {0xA375, 0xC9A9}, //6076 #HANGUL SYLLABLE CIEUC YI NIEUNCIEUC
  {0xA376, 0xC9AA}, //6077 #HANGUL SYLLABLE CIEUC YI NIEUNHIEUH
  {0xA377, 0xC9AB}, //6078 #HANGUL SYLLABLE CIEUC YI TIKEUT
  {0xA378, 0xC9AC}, //6079 #HANGUL SYLLABLE CIEUC YI RIEUL
  {0xA379, 0xC9AD}, //6080 #HANGUL SYLLABLE CIEUC YI RIEULKIYEOK
  {0xA37A, 0xC9AE}, //6081 #HANGUL SYLLABLE CIEUC YI RIEULMIEUM
  {0xA381, 0xC9AF}, //6082 #HANGUL SYLLABLE CIEUC YI RIEULPIEUP
  {0xA382, 0xC9B0}, //6083 #HANGUL SYLLABLE CIEUC YI RIEULSIOS
  {0xA383, 0xC9B1}, //6084 #HANGUL SYLLABLE CIEUC YI RIEULTHIEUTH
  {0xA384, 0xC9B2}, //6085 #HANGUL SYLLABLE CIEUC YI RIEULPHIEUPH
  {0xA385, 0xC9B3}, //6086 #HANGUL SYLLABLE CIEUC YI RIEULHIEUH
  {0xA386, 0xC9B4}, //6087 #HANGUL SYLLABLE CIEUC YI MIEUM
  {0xA387, 0xC9B5}, //6088 #HANGUL SYLLABLE CIEUC YI PIEUP
  {0xA388, 0xC9B6}, //6089 #HANGUL SYLLABLE CIEUC YI PIEUPSIOS
  {0xA389, 0xC9B7}, //6090 #HANGUL SYLLABLE CIEUC YI SIOS
  {0xA38A, 0xC9B8}, //6091 #HANGUL SYLLABLE CIEUC YI SSANGSIOS
  {0xA38B, 0xC9B9}, //6092 #HANGUL SYLLABLE CIEUC YI IEUNG
  {0xA38C, 0xC9BA}, //6093 #HANGUL SYLLABLE CIEUC YI CIEUC
  {0xA38D, 0xC9BB}, //6094 #HANGUL SYLLABLE CIEUC YI CHIEUCH
  {0xA38E, 0xC9BC}, //6095 #HANGUL SYLLABLE CIEUC YI KHIEUKH
  {0xA38F, 0xC9BD}, //6096 #HANGUL SYLLABLE CIEUC YI THIEUTH
  {0xA390, 0xC9BE}, //6097 #HANGUL SYLLABLE CIEUC YI PHIEUPH
  {0xA391, 0xC9BF}, //6098 #HANGUL SYLLABLE CIEUC YI HIEUH
  {0xA392, 0xC9C2}, //6099 #HANGUL SYLLABLE CIEUC I SSANGKIYEOK
  {0xA393, 0xC9C3}, //6100 #HANGUL SYLLABLE CIEUC I KIYEOKSIOS
  {0xA394, 0xC9C5}, //6101 #HANGUL SYLLABLE CIEUC I NIEUNCIEUC
  {0xA395, 0xC9C6}, //6102 #HANGUL SYLLABLE CIEUC I NIEUNHIEUH
  {0xA396, 0xC9C9}, //6103 #HANGUL SYLLABLE CIEUC I RIEULKIYEOK
  {0xA397, 0xC9CB}, //6104 #HANGUL SYLLABLE CIEUC I RIEULPIEUP
  {0xA398, 0xC9CC}, //6105 #HANGUL SYLLABLE CIEUC I RIEULSIOS
  {0xA399, 0xC9CD}, //6106 #HANGUL SYLLABLE CIEUC I RIEULTHIEUTH
  {0xA39A, 0xC9CE}, //6107 #HANGUL SYLLABLE CIEUC I RIEULPHIEUPH
  {0xA39B, 0xC9CF}, //6108 #HANGUL SYLLABLE CIEUC I RIEULHIEUH
  {0xA39C, 0xC9D2}, //6109 #HANGUL SYLLABLE CIEUC I PIEUPSIOS
  {0xA39D, 0xC9D4}, //6110 #HANGUL SYLLABLE CIEUC I SSANGSIOS
  {0xA39E, 0xC9D7}, //6111 #HANGUL SYLLABLE CIEUC I CHIEUCH
  {0xA39F, 0xC9D8}, //6112 #HANGUL SYLLABLE CIEUC I KHIEUKH
  {0xA3A0, 0xC9DB}, //6113 #HANGUL SYLLABLE CIEUC I HIEUH
  {0xA3A1, 0xFF01}, //6114 #FULLWIDTH EXCLAMATION MARK
  {0xA3A2, 0xFF02}, //6115 #FULLWIDTH QUOTATION MARK
  {0xA3A3, 0xFF03}, //6116 #FULLWIDTH NUMBER SIGN
  {0xA3A4, 0xFF04}, //6117 #FULLWIDTH DOLLAR SIGN
  {0xA3A5, 0xFF05}, //6118 #FULLWIDTH PERCENT SIGN
  {0xA3A6, 0xFF06}, //6119 #FULLWIDTH AMPERSAND
  {0xA3A7, 0xFF07}, //6120 #FULLWIDTH APOSTROPHE
  {0xA3A8, 0xFF08}, //6121 #FULLWIDTH LEFT PARENTHESIS
  {0xA3A9, 0xFF09}, //6122 #FULLWIDTH RIGHT PARENTHESIS
  {0xA3AA, 0xFF0A}, //6123 #FULLWIDTH ASTERISK
  {0xA3AB, 0xFF0B}, //6124 #FULLWIDTH PLUS SIGN
  {0xA3AC, 0xFF0C}, //6125 #FULLWIDTH COMMA
  {0xA3AD, 0xFF0D}, //6126 #FULLWIDTH HYPHEN-MINUS
  {0xA3AE, 0xFF0E}, //6127 #FULLWIDTH FULL STOP
  {0xA3AF, 0xFF0F}, //6128 #FULLWIDTH SOLIDUS
  {0xA3B0, 0xFF10}, //6129 #FULLWIDTH DIGIT ZERO
  {0xA3B1, 0xFF11}, //6130 #FULLWIDTH DIGIT ONE
  {0xA3B2, 0xFF12}, //6131 #FULLWIDTH DIGIT TWO
  {0xA3B3, 0xFF13}, //6132 #FULLWIDTH DIGIT THREE
  {0xA3B4, 0xFF14}, //6133 #FULLWIDTH DIGIT FOUR
  {0xA3B5, 0xFF15}, //6134 #FULLWIDTH DIGIT FIVE
  {0xA3B6, 0xFF16}, //6135 #FULLWIDTH DIGIT SIX
  {0xA3B7, 0xFF17}, //6136 #FULLWIDTH DIGIT SEVEN
  {0xA3B8, 0xFF18}, //6137 #FULLWIDTH DIGIT EIGHT
  {0xA3B9, 0xFF19}, //6138 #FULLWIDTH DIGIT NINE
  {0xA3BA, 0xFF1A}, //6139 #FULLWIDTH COLON
  {0xA3BB, 0xFF1B}, //6140 #FULLWIDTH SEMICOLON
  {0xA3BC, 0xFF1C}, //6141 #FULLWIDTH LESS-THAN SIGN
  {0xA3BD, 0xFF1D}, //6142 #FULLWIDTH EQUALS SIGN
  {0xA3BE, 0xFF1E}, //6143 #FULLWIDTH GREATER-THAN SIGN
  {0xA3BF, 0xFF1F}, //6144 #FULLWIDTH QUESTION MARK
  {0xA3C0, 0xFF20}, //6145 #FULLWIDTH COMMERCIAL AT
  {0xA3C1, 0xFF21}, //6146 #FULLWIDTH LATIN CAPITAL LETTER A
  {0xA3C2, 0xFF22}, //6147 #FULLWIDTH LATIN CAPITAL LETTER B
  {0xA3C3, 0xFF23}, //6148 #FULLWIDTH LATIN CAPITAL LETTER C
  {0xA3C4, 0xFF24}, //6149 #FULLWIDTH LATIN CAPITAL LETTER D
  {0xA3C5, 0xFF25}, //6150 #FULLWIDTH LATIN CAPITAL LETTER E
  {0xA3C6, 0xFF26}, //6151 #FULLWIDTH LATIN CAPITAL LETTER F
  {0xA3C7, 0xFF27}, //6152 #FULLWIDTH LATIN CAPITAL LETTER G
  {0xA3C8, 0xFF28}, //6153 #FULLWIDTH LATIN CAPITAL LETTER H
  {0xA3C9, 0xFF29}, //6154 #FULLWIDTH LATIN CAPITAL LETTER I
  {0xA3CA, 0xFF2A}, //6155 #FULLWIDTH LATIN CAPITAL LETTER J
  {0xA3CB, 0xFF2B}, //6156 #FULLWIDTH LATIN CAPITAL LETTER K
  {0xA3CC, 0xFF2C}, //6157 #FULLWIDTH LATIN CAPITAL LETTER L
  {0xA3CD, 0xFF2D}, //6158 #FULLWIDTH LATIN CAPITAL LETTER M
  {0xA3CE, 0xFF2E}, //6159 #FULLWIDTH LATIN CAPITAL LETTER N
  {0xA3CF, 0xFF2F}, //6160 #FULLWIDTH LATIN CAPITAL LETTER O
  {0xA3D0, 0xFF30}, //6161 #FULLWIDTH LATIN CAPITAL LETTER P
  {0xA3D1, 0xFF31}, //6162 #FULLWIDTH LATIN CAPITAL LETTER Q
  {0xA3D2, 0xFF32}, //6163 #FULLWIDTH LATIN CAPITAL LETTER R
  {0xA3D3, 0xFF33}, //6164 #FULLWIDTH LATIN CAPITAL LETTER S
  {0xA3D4, 0xFF34}, //6165 #FULLWIDTH LATIN CAPITAL LETTER T
  {0xA3D5, 0xFF35}, //6166 #FULLWIDTH LATIN CAPITAL LETTER U
  {0xA3D6, 0xFF36}, //6167 #FULLWIDTH LATIN CAPITAL LETTER V
  {0xA3D7, 0xFF37}, //6168 #FULLWIDTH LATIN CAPITAL LETTER W
  {0xA3D8, 0xFF38}, //6169 #FULLWIDTH LATIN CAPITAL LETTER X
  {0xA3D9, 0xFF39}, //6170 #FULLWIDTH LATIN CAPITAL LETTER Y
  {0xA3DA, 0xFF3A}, //6171 #FULLWIDTH LATIN CAPITAL LETTER Z
  {0xA3DB, 0xFF3B}, //6172 #FULLWIDTH LEFT SQUARE BRACKET
  {0xA3DC, 0xFFE6}, //6173 #FULLWIDTH WON SIGN
  {0xA3DD, 0xFF3D}, //6174 #FULLWIDTH RIGHT SQUARE BRACKET
  {0xA3DE, 0xFF3E}, //6175 #FULLWIDTH CIRCUMFLEX ACCENT
  {0xA3DF, 0xFF3F}, //6176 #FULLWIDTH LOW LINE
  {0xA3E0, 0xFF40}, //6177 #FULLWIDTH GRAVE ACCENT
  {0xA3E1, 0xFF41}, //6178 #FULLWIDTH LATIN SMALL LETTER A
  {0xA3E2, 0xFF42}, //6179 #FULLWIDTH LATIN SMALL LETTER B
  {0xA3E3, 0xFF43}, //6180 #FULLWIDTH LATIN SMALL LETTER C
  {0xA3E4, 0xFF44}, //6181 #FULLWIDTH LATIN SMALL LETTER D
  {0xA3E5, 0xFF45}, //6182 #FULLWIDTH LATIN SMALL LETTER E
  {0xA3E6, 0xFF46}, //6183 #FULLWIDTH LATIN SMALL LETTER F
  {0xA3E7, 0xFF47}, //6184 #FULLWIDTH LATIN SMALL LETTER G
  {0xA3E8, 0xFF48}, //6185 #FULLWIDTH LATIN SMALL LETTER H
  {0xA3E9, 0xFF49}, //6186 #FULLWIDTH LATIN SMALL LETTER I
  {0xA3EA, 0xFF4A}, //6187 #FULLWIDTH LATIN SMALL LETTER J
  {0xA3EB, 0xFF4B}, //6188 #FULLWIDTH LATIN SMALL LETTER K
  {0xA3EC, 0xFF4C}, //6189 #FULLWIDTH LATIN SMALL LETTER L
  {0xA3ED, 0xFF4D}, //6190 #FULLWIDTH LATIN SMALL LETTER M
  {0xA3EE, 0xFF4E}, //6191 #FULLWIDTH LATIN SMALL LETTER N
  {0xA3EF, 0xFF4F}, //6192 #FULLWIDTH LATIN SMALL LETTER O
  {0xA3F0, 0xFF50}, //6193 #FULLWIDTH LATIN SMALL LETTER P
  {0xA3F1, 0xFF51}, //6194 #FULLWIDTH LATIN SMALL LETTER Q
  {0xA3F2, 0xFF52}, //6195 #FULLWIDTH LATIN SMALL LETTER R
  {0xA3F3, 0xFF53}, //6196 #FULLWIDTH LATIN SMALL LETTER S
  {0xA3F4, 0xFF54}, //6197 #FULLWIDTH LATIN SMALL LETTER T
  {0xA3F5, 0xFF55}, //6198 #FULLWIDTH LATIN SMALL LETTER U
  {0xA3F6, 0xFF56}, //6199 #FULLWIDTH LATIN SMALL LETTER V
  {0xA3F7, 0xFF57}, //6200 #FULLWIDTH LATIN SMALL LETTER W
  {0xA3F8, 0xFF58}, //6201 #FULLWIDTH LATIN SMALL LETTER X
  {0xA3F9, 0xFF59}, //6202 #FULLWIDTH LATIN SMALL LETTER Y
  {0xA3FA, 0xFF5A}, //6203 #FULLWIDTH LATIN SMALL LETTER Z
  {0xA3FB, 0xFF5B}, //6204 #FULLWIDTH LEFT CURLY BRACKET
  {0xA3FC, 0xFF5C}, //6205 #FULLWIDTH VERTICAL LINE
  {0xA3FD, 0xFF5D}, //6206 #FULLWIDTH RIGHT CURLY BRACKET
  {0xA3FE, 0xFFE3}, //6207 #FULLWIDTH MACRON
  {0xA441, 0xC9DE}, //6208 #HANGUL SYLLABLE SSANGCIEUC A SSANGKIYEOK
  {0xA442, 0xC9DF}, //6209 #HANGUL SYLLABLE SSANGCIEUC A KIYEOKSIOS
  {0xA443, 0xC9E1}, //6210 #HANGUL SYLLABLE SSANGCIEUC A NIEUNCIEUC
  {0xA444, 0xC9E3}, //6211 #HANGUL SYLLABLE SSANGCIEUC A TIKEUT
  {0xA445, 0xC9E5}, //6212 #HANGUL SYLLABLE SSANGCIEUC A RIEULKIYEOK
  {0xA446, 0xC9E6}, //6213 #HANGUL SYLLABLE SSANGCIEUC A RIEULMIEUM
  {0xA447, 0xC9E8}, //6214 #HANGUL SYLLABLE SSANGCIEUC A RIEULSIOS
  {0xA448, 0xC9E9}, //6215 #HANGUL SYLLABLE SSANGCIEUC A RIEULTHIEUTH
  {0xA449, 0xC9EA}, //6216 #HANGUL SYLLABLE SSANGCIEUC A RIEULPHIEUPH
  {0xA44A, 0xC9EB}, //6217 #HANGUL SYLLABLE SSANGCIEUC A RIEULHIEUH
  {0xA44B, 0xC9EE}, //6218 #HANGUL SYLLABLE SSANGCIEUC A PIEUPSIOS
  {0xA44C, 0xC9F2}, //6219 #HANGUL SYLLABLE SSANGCIEUC A CIEUC
  {0xA44D, 0xC9F3}, //6220 #HANGUL SYLLABLE SSANGCIEUC A CHIEUCH
  {0xA44E, 0xC9F4}, //6221 #HANGUL SYLLABLE SSANGCIEUC A KHIEUKH
  {0xA44F, 0xC9F5}, //6222 #HANGUL SYLLABLE SSANGCIEUC A THIEUTH
  {0xA450, 0xC9F6}, //6223 #HANGUL SYLLABLE SSANGCIEUC A PHIEUPH
  {0xA451, 0xC9F7}, //6224 #HANGUL SYLLABLE SSANGCIEUC A HIEUH
  {0xA452, 0xC9FA}, //6225 #HANGUL SYLLABLE SSANGCIEUC AE SSANGKIYEOK
  {0xA453, 0xC9FB}, //6226 #HANGUL SYLLABLE SSANGCIEUC AE KIYEOKSIOS
  {0xA454, 0xC9FD}, //6227 #HANGUL SYLLABLE SSANGCIEUC AE NIEUNCIEUC
  {0xA455, 0xC9FE}, //6228 #HANGUL SYLLABLE SSANGCIEUC AE NIEUNHIEUH
  {0xA456, 0xC9FF}, //6229 #HANGUL SYLLABLE SSANGCIEUC AE TIKEUT
  {0xA457, 0xCA01}, //6230 #HANGUL SYLLABLE SSANGCIEUC AE RIEULKIYEOK
  {0xA458, 0xCA02}, //6231 #HANGUL SYLLABLE SSANGCIEUC AE RIEULMIEUM
  {0xA459, 0xCA03}, //6232 #HANGUL SYLLABLE SSANGCIEUC AE RIEULPIEUP
  {0xA45A, 0xCA04}, //6233 #HANGUL SYLLABLE SSANGCIEUC AE RIEULSIOS
  {0xA461, 0xCA05}, //6234 #HANGUL SYLLABLE SSANGCIEUC AE RIEULTHIEUTH
  {0xA462, 0xCA06}, //6235 #HANGUL SYLLABLE SSANGCIEUC AE RIEULPHIEUPH
  {0xA463, 0xCA07}, //6236 #HANGUL SYLLABLE SSANGCIEUC AE RIEULHIEUH
  {0xA464, 0xCA0A}, //6237 #HANGUL SYLLABLE SSANGCIEUC AE PIEUPSIOS
  {0xA465, 0xCA0E}, //6238 #HANGUL SYLLABLE SSANGCIEUC AE CIEUC
  {0xA466, 0xCA0F}, //6239 #HANGUL SYLLABLE SSANGCIEUC AE CHIEUCH
  {0xA467, 0xCA10}, //6240 #HANGUL SYLLABLE SSANGCIEUC AE KHIEUKH
  {0xA468, 0xCA11}, //6241 #HANGUL SYLLABLE SSANGCIEUC AE THIEUTH
  {0xA469, 0xCA12}, //6242 #HANGUL SYLLABLE SSANGCIEUC AE PHIEUPH
  {0xA46A, 0xCA13}, //6243 #HANGUL SYLLABLE SSANGCIEUC AE HIEUH
  {0xA46B, 0xCA15}, //6244 #HANGUL SYLLABLE SSANGCIEUC YA KIYEOK
  {0xA46C, 0xCA16}, //6245 #HANGUL SYLLABLE SSANGCIEUC YA SSANGKIYEOK
  {0xA46D, 0xCA17}, //6246 #HANGUL SYLLABLE SSANGCIEUC YA KIYEOKSIOS
  {0xA46E, 0xCA19}, //6247 #HANGUL SYLLABLE SSANGCIEUC YA NIEUNCIEUC
  {0xA46F, 0xCA1A}, //6248 #HANGUL SYLLABLE SSANGCIEUC YA NIEUNHIEUH
  {0xA470, 0xCA1B}, //6249 #HANGUL SYLLABLE SSANGCIEUC YA TIKEUT
  {0xA471, 0xCA1C}, //6250 #HANGUL SYLLABLE SSANGCIEUC YA RIEUL
  {0xA472, 0xCA1D}, //6251 #HANGUL SYLLABLE SSANGCIEUC YA RIEULKIYEOK
  {0xA473, 0xCA1E}, //6252 #HANGUL SYLLABLE SSANGCIEUC YA RIEULMIEUM
  {0xA474, 0xCA1F}, //6253 #HANGUL SYLLABLE SSANGCIEUC YA RIEULPIEUP
  {0xA475, 0xCA20}, //6254 #HANGUL SYLLABLE SSANGCIEUC YA RIEULSIOS
  {0xA476, 0xCA21}, //6255 #HANGUL SYLLABLE SSANGCIEUC YA RIEULTHIEUTH
  {0xA477, 0xCA22}, //6256 #HANGUL SYLLABLE SSANGCIEUC YA RIEULPHIEUPH
  {0xA478, 0xCA23}, //6257 #HANGUL SYLLABLE SSANGCIEUC YA RIEULHIEUH
  {0xA479, 0xCA24}, //6258 #HANGUL SYLLABLE SSANGCIEUC YA MIEUM
  {0xA47A, 0xCA25}, //6259 #HANGUL SYLLABLE SSANGCIEUC YA PIEUP
  {0xA481, 0xCA26}, //6260 #HANGUL SYLLABLE SSANGCIEUC YA PIEUPSIOS
  {0xA482, 0xCA27}, //6261 #HANGUL SYLLABLE SSANGCIEUC YA SIOS
  {0xA483, 0xCA28}, //6262 #HANGUL SYLLABLE SSANGCIEUC YA SSANGSIOS
  {0xA484, 0xCA2A}, //6263 #HANGUL SYLLABLE SSANGCIEUC YA CIEUC
  {0xA485, 0xCA2B}, //6264 #HANGUL SYLLABLE SSANGCIEUC YA CHIEUCH
  {0xA486, 0xCA2C}, //6265 #HANGUL SYLLABLE SSANGCIEUC YA KHIEUKH
  {0xA487, 0xCA2D}, //6266 #HANGUL SYLLABLE SSANGCIEUC YA THIEUTH
  {0xA488, 0xCA2E}, //6267 #HANGUL SYLLABLE SSANGCIEUC YA PHIEUPH
  {0xA489, 0xCA2F}, //6268 #HANGUL SYLLABLE SSANGCIEUC YA HIEUH
  {0xA48A, 0xCA30}, //6269 #HANGUL SYLLABLE SSANGCIEUC YAE
  {0xA48B, 0xCA31}, //6270 #HANGUL SYLLABLE SSANGCIEUC YAE KIYEOK
  {0xA48C, 0xCA32}, //6271 #HANGUL SYLLABLE SSANGCIEUC YAE SSANGKIYEOK
  {0xA48D, 0xCA33}, //6272 #HANGUL SYLLABLE SSANGCIEUC YAE KIYEOKSIOS
  {0xA48E, 0xCA34}, //6273 #HANGUL SYLLABLE SSANGCIEUC YAE NIEUN
  {0xA48F, 0xCA35}, //6274 #HANGUL SYLLABLE SSANGCIEUC YAE NIEUNCIEUC
  {0xA490, 0xCA36}, //6275 #HANGUL SYLLABLE SSANGCIEUC YAE NIEUNHIEUH
  {0xA491, 0xCA37}, //6276 #HANGUL SYLLABLE SSANGCIEUC YAE TIKEUT
  {0xA492, 0xCA38}, //6277 #HANGUL SYLLABLE SSANGCIEUC YAE RIEUL
  {0xA493, 0xCA39}, //6278 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULKIYEOK
  {0xA494, 0xCA3A}, //6279 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULMIEUM
  {0xA495, 0xCA3B}, //6280 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULPIEUP
  {0xA496, 0xCA3C}, //6281 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULSIOS
  {0xA497, 0xCA3D}, //6282 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULTHIEUTH
  {0xA498, 0xCA3E}, //6283 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULPHIEUPH
  {0xA499, 0xCA3F}, //6284 #HANGUL SYLLABLE SSANGCIEUC YAE RIEULHIEUH
  {0xA49A, 0xCA40}, //6285 #HANGUL SYLLABLE SSANGCIEUC YAE MIEUM
  {0xA49B, 0xCA41}, //6286 #HANGUL SYLLABLE SSANGCIEUC YAE PIEUP
  {0xA49C, 0xCA42}, //6287 #HANGUL SYLLABLE SSANGCIEUC YAE PIEUPSIOS
  {0xA49D, 0xCA43}, //6288 #HANGUL SYLLABLE SSANGCIEUC YAE SIOS
  {0xA49E, 0xCA44}, //6289 #HANGUL SYLLABLE SSANGCIEUC YAE SSANGSIOS
  {0xA49F, 0xCA45}, //6290 #HANGUL SYLLABLE SSANGCIEUC YAE IEUNG
  {0xA4A0, 0xCA46}, //6291 #HANGUL SYLLABLE SSANGCIEUC YAE CIEUC
  {0xA4A1, 0x3131}, //6292 #HANGUL LETTER KIYEOK
  {0xA4A2, 0x3132}, //6293 #HANGUL LETTER SSANGKIYEOK
  {0xA4A3, 0x3133}, //6294 #HANGUL LETTER KIYEOK-SIOS
  {0xA4A4, 0x3134}, //6295 #HANGUL LETTER NIEUN
  {0xA4A5, 0x3135}, //6296 #HANGUL LETTER NIEUN-CIEUC
  {0xA4A6, 0x3136}, //6297 #HANGUL LETTER NIEUN-HIEUH
  {0xA4A7, 0x3137}, //6298 #HANGUL LETTER TIKEUT
  {0xA4A8, 0x3138}, //6299 #HANGUL LETTER SSANGTIKEUT
  {0xA4A9, 0x3139}, //6300 #HANGUL LETTER RIEUL
  {0xA4AA, 0x313A}, //6301 #HANGUL LETTER RIEUL-KIYEOK
  {0xA4AB, 0x313B}, //6302 #HANGUL LETTER RIEUL-MIEUM
  {0xA4AC, 0x313C}, //6303 #HANGUL LETTER RIEUL-PIEUP
  {0xA4AD, 0x313D}, //6304 #HANGUL LETTER RIEUL-SIOS
  {0xA4AE, 0x313E}, //6305 #HANGUL LETTER RIEUL-THIEUTH
  {0xA4AF, 0x313F}, //6306 #HANGUL LETTER RIEUL-PHIEUPH
  {0xA4B0, 0x3140}, //6307 #HANGUL LETTER RIEUL-HIEUH
  {0xA4B1, 0x3141}, //6308 #HANGUL LETTER MIEUM
  {0xA4B2, 0x3142}, //6309 #HANGUL LETTER PIEUP
  {0xA4B3, 0x3143}, //6310 #HANGUL LETTER SSANGPIEUP
  {0xA4B4, 0x3144}, //6311 #HANGUL LETTER PIEUP-SIOS
  {0xA4B5, 0x3145}, //6312 #HANGUL LETTER SIOS
  {0xA4B6, 0x3146}, //6313 #HANGUL LETTER SSANGSIOS
  {0xA4B7, 0x3147}, //6314 #HANGUL LETTER IEUNG
  {0xA4B8, 0x3148}, //6315 #HANGUL LETTER CIEUC
  {0xA4B9, 0x3149}, //6316 #HANGUL LETTER SSANGCIEUC
  {0xA4BA, 0x314A}, //6317 #HANGUL LETTER CHIEUCH
  {0xA4BB, 0x314B}, //6318 #HANGUL LETTER KHIEUKH
  {0xA4BC, 0x314C}, //6319 #HANGUL LETTER THIEUTH
  {0xA4BD, 0x314D}, //6320 #HANGUL LETTER PHIEUPH
  {0xA4BE, 0x314E}, //6321 #HANGUL LETTER HIEUH
  {0xA4BF, 0x314F}, //6322 #HANGUL LETTER A
  {0xA4C0, 0x3150}, //6323 #HANGUL LETTER AE
  {0xA4C1, 0x3151}, //6324 #HANGUL LETTER YA
  {0xA4C2, 0x3152}, //6325 #HANGUL LETTER YAE
  {0xA4C3, 0x3153}, //6326 #HANGUL LETTER EO
  {0xA4C4, 0x3154}, //6327 #HANGUL LETTER E
  {0xA4C5, 0x3155}, //6328 #HANGUL LETTER YEO
  {0xA4C6, 0x3156}, //6329 #HANGUL LETTER YE
  {0xA4C7, 0x3157}, //6330 #HANGUL LETTER O
  {0xA4C8, 0x3158}, //6331 #HANGUL LETTER WA
  {0xA4C9, 0x3159}, //6332 #HANGUL LETTER WAE
  {0xA4CA, 0x315A}, //6333 #HANGUL LETTER OE
  {0xA4CB, 0x315B}, //6334 #HANGUL LETTER YO
  {0xA4CC, 0x315C}, //6335 #HANGUL LETTER U
  {0xA4CD, 0x315D}, //6336 #HANGUL LETTER WEO
  {0xA4CE, 0x315E}, //6337 #HANGUL LETTER WE
  {0xA4CF, 0x315F}, //6338 #HANGUL LETTER WI
  {0xA4D0, 0x3160}, //6339 #HANGUL LETTER YU
  {0xA4D1, 0x3161}, //6340 #HANGUL LETTER EU
  {0xA4D2, 0x3162}, //6341 #HANGUL LETTER YI
  {0xA4D3, 0x3163}, //6342 #HANGUL LETTER I
  {0xA4D4, 0x3164}, //6343 #HANGUL FILLER
  {0xA4D5, 0x3165}, //6344 #HANGUL LETTER SSANGNIEUN
  {0xA4D6, 0x3166}, //6345 #HANGUL LETTER NIEUN-TIKEUT
  {0xA4D7, 0x3167}, //6346 #HANGUL LETTER NIEUN-SIOS
  {0xA4D8, 0x3168}, //6347 #HANGUL LETTER NIEUN-PANSIOS
  {0xA4D9, 0x3169}, //6348 #HANGUL LETTER RIEUL-KIYEOK-SIOS
  {0xA4DA, 0x316A}, //6349 #HANGUL LETTER RIEUL-TIKEUT
  {0xA4DB, 0x316B}, //6350 #HANGUL LETTER RIEUL-PIEUP-SIOS
  {0xA4DC, 0x316C}, //6351 #HANGUL LETTER RIEUL-PANSIOS
  {0xA4DD, 0x316D}, //6352 #HANGUL LETTER RIEUL-YEORINHIEUH
  {0xA4DE, 0x316E}, //6353 #HANGUL LETTER MIEUM-PIEUP
  {0xA4DF, 0x316F}, //6354 #HANGUL LETTER MIEUM-SIOS
  {0xA4E0, 0x3170}, //6355 #HANGUL LETTER MIEUM-PANSIOS
  {0xA4E1, 0x3171}, //6356 #HANGUL LETTER KAPYEOUNMIEUM
  {0xA4E2, 0x3172}, //6357 #HANGUL LETTER PIEUP-KIYEOK
  {0xA4E3, 0x3173}, //6358 #HANGUL LETTER PIEUP-TIKEUT
  {0xA4E4, 0x3174}, //6359 #HANGUL LETTER PIEUP-SIOS-KIYEOK
  {0xA4E5, 0x3175}, //6360 #HANGUL LETTER PIEUP-SIOS-TIKEUT
  {0xA4E6, 0x3176}, //6361 #HANGUL LETTER PIEUP-CIEUC
  {0xA4E7, 0x3177}, //6362 #HANGUL LETTER PIEUP-THIEUTH
  {0xA4E8, 0x3178}, //6363 #HANGUL LETTER KAPYEOUNPIEUP
  {0xA4E9, 0x3179}, //6364 #HANGUL LETTER KAPYEOUNSSANGPIEUP
  {0xA4EA, 0x317A}, //6365 #HANGUL LETTER SIOS-KIYEOK
  {0xA4EB, 0x317B}, //6366 #HANGUL LETTER SIOS-NIEUN
  {0xA4EC, 0x317C}, //6367 #HANGUL LETTER SIOS-TIKEUT
  {0xA4ED, 0x317D}, //6368 #HANGUL LETTER SIOS-PIEUP
  {0xA4EE, 0x317E}, //6369 #HANGUL LETTER SIOS-CIEUC
  {0xA4EF, 0x317F}, //6370 #HANGUL LETTER PANSIOS
  {0xA4F0, 0x3180}, //6371 #HANGUL LETTER SSANGIEUNG
  {0xA4F1, 0x3181}, //6372 #HANGUL LETTER YESIEUNG
  {0xA4F2, 0x3182}, //6373 #HANGUL LETTER YESIEUNG-SIOS
  {0xA4F3, 0x3183}, //6374 #HANGUL LETTER YESIEUNG-PANSIOS
  {0xA4F4, 0x3184}, //6375 #HANGUL LETTER KAPYEOUNPHIEUPH
  {0xA4F5, 0x3185}, //6376 #HANGUL LETTER SSANGHIEUH
  {0xA4F6, 0x3186}, //6377 #HANGUL LETTER YEORINHIEUH
  {0xA4F7, 0x3187}, //6378 #HANGUL LETTER YO-YA
  {0xA4F8, 0x3188}, //6379 #HANGUL LETTER YO-YAE
  {0xA4F9, 0x3189}, //6380 #HANGUL LETTER YO-I
  {0xA4FA, 0x318A}, //6381 #HANGUL LETTER YU-YEO
  {0xA4FB, 0x318B}, //6382 #HANGUL LETTER YU-YE
  {0xA4FC, 0x318C}, //6383 #HANGUL LETTER YU-I
  {0xA4FD, 0x318D}, //6384 #HANGUL LETTER ARAEA
  {0xA4FE, 0x318E}, //6385 #HANGUL LETTER ARAEAE
  {0xA541, 0xCA47}, //6386 #HANGUL SYLLABLE SSANGCIEUC YAE CHIEUCH
  {0xA542, 0xCA48}, //6387 #HANGUL SYLLABLE SSANGCIEUC YAE KHIEUKH
  {0xA543, 0xCA49}, //6388 #HANGUL SYLLABLE SSANGCIEUC YAE THIEUTH
  {0xA544, 0xCA4A}, //6389 #HANGUL SYLLABLE SSANGCIEUC YAE PHIEUPH
  {0xA545, 0xCA4B}, //6390 #HANGUL SYLLABLE SSANGCIEUC YAE HIEUH
  {0xA546, 0xCA4E}, //6391 #HANGUL SYLLABLE SSANGCIEUC EO SSANGKIYEOK
  {0xA547, 0xCA4F}, //6392 #HANGUL SYLLABLE SSANGCIEUC EO KIYEOKSIOS
  {0xA548, 0xCA51}, //6393 #HANGUL SYLLABLE SSANGCIEUC EO NIEUNCIEUC
  {0xA549, 0xCA52}, //6394 #HANGUL SYLLABLE SSANGCIEUC EO NIEUNHIEUH
  {0xA54A, 0xCA53}, //6395 #HANGUL SYLLABLE SSANGCIEUC EO TIKEUT
  {0xA54B, 0xCA55}, //6396 #HANGUL SYLLABLE SSANGCIEUC EO RIEULKIYEOK
  {0xA54C, 0xCA56}, //6397 #HANGUL SYLLABLE SSANGCIEUC EO RIEULMIEUM
  {0xA54D, 0xCA57}, //6398 #HANGUL SYLLABLE SSANGCIEUC EO RIEULPIEUP
  {0xA54E, 0xCA58}, //6399 #HANGUL SYLLABLE SSANGCIEUC EO RIEULSIOS
  {0xA54F, 0xCA59}, //6400 #HANGUL SYLLABLE SSANGCIEUC EO RIEULTHIEUTH
  {0xA550, 0xCA5A}, //6401 #HANGUL SYLLABLE SSANGCIEUC EO RIEULPHIEUPH
  {0xA551, 0xCA5B}, //6402 #HANGUL SYLLABLE SSANGCIEUC EO RIEULHIEUH
  {0xA552, 0xCA5E}, //6403 #HANGUL SYLLABLE SSANGCIEUC EO PIEUPSIOS
  {0xA553, 0xCA62}, //6404 #HANGUL SYLLABLE SSANGCIEUC EO CIEUC
  {0xA554, 0xCA63}, //6405 #HANGUL SYLLABLE SSANGCIEUC EO CHIEUCH
  {0xA555, 0xCA64}, //6406 #HANGUL SYLLABLE SSANGCIEUC EO KHIEUKH
  {0xA556, 0xCA65}, //6407 #HANGUL SYLLABLE SSANGCIEUC EO THIEUTH
  {0xA557, 0xCA66}, //6408 #HANGUL SYLLABLE SSANGCIEUC EO PHIEUPH
  {0xA558, 0xCA67}, //6409 #HANGUL SYLLABLE SSANGCIEUC EO HIEUH
  {0xA559, 0xCA69}, //6410 #HANGUL SYLLABLE SSANGCIEUC E KIYEOK
  {0xA55A, 0xCA6A}, //6411 #HANGUL SYLLABLE SSANGCIEUC E SSANGKIYEOK
  {0xA561, 0xCA6B}, //6412 #HANGUL SYLLABLE SSANGCIEUC E KIYEOKSIOS
  {0xA562, 0xCA6C}, //6413 #HANGUL SYLLABLE SSANGCIEUC E NIEUN
  {0xA563, 0xCA6D}, //6414 #HANGUL SYLLABLE SSANGCIEUC E NIEUNCIEUC
  {0xA564, 0xCA6E}, //6415 #HANGUL SYLLABLE SSANGCIEUC E NIEUNHIEUH
  {0xA565, 0xCA6F}, //6416 #HANGUL SYLLABLE SSANGCIEUC E TIKEUT
  {0xA566, 0xCA70}, //6417 #HANGUL SYLLABLE SSANGCIEUC E RIEUL
  {0xA567, 0xCA71}, //6418 #HANGUL SYLLABLE SSANGCIEUC E RIEULKIYEOK
  {0xA568, 0xCA72}, //6419 #HANGUL SYLLABLE SSANGCIEUC E RIEULMIEUM
  {0xA569, 0xCA73}, //6420 #HANGUL SYLLABLE SSANGCIEUC E RIEULPIEUP
  {0xA56A, 0xCA74}, //6421 #HANGUL SYLLABLE SSANGCIEUC E RIEULSIOS
  {0xA56B, 0xCA75}, //6422 #HANGUL SYLLABLE SSANGCIEUC E RIEULTHIEUTH
  {0xA56C, 0xCA76}, //6423 #HANGUL SYLLABLE SSANGCIEUC E RIEULPHIEUPH
  {0xA56D, 0xCA77}, //6424 #HANGUL SYLLABLE SSANGCIEUC E RIEULHIEUH
  {0xA56E, 0xCA78}, //6425 #HANGUL SYLLABLE SSANGCIEUC E MIEUM
  {0xA56F, 0xCA79}, //6426 #HANGUL SYLLABLE SSANGCIEUC E PIEUP
  {0xA570, 0xCA7A}, //6427 #HANGUL SYLLABLE SSANGCIEUC E PIEUPSIOS
  {0xA571, 0xCA7B}, //6428 #HANGUL SYLLABLE SSANGCIEUC E SIOS
  {0xA572, 0xCA7C}, //6429 #HANGUL SYLLABLE SSANGCIEUC E SSANGSIOS
  {0xA573, 0xCA7E}, //6430 #HANGUL SYLLABLE SSANGCIEUC E CIEUC
  {0xA574, 0xCA7F}, //6431 #HANGUL SYLLABLE SSANGCIEUC E CHIEUCH
  {0xA575, 0xCA80}, //6432 #HANGUL SYLLABLE SSANGCIEUC E KHIEUKH
  {0xA576, 0xCA81}, //6433 #HANGUL SYLLABLE SSANGCIEUC E THIEUTH
  {0xA577, 0xCA82}, //6434 #HANGUL SYLLABLE SSANGCIEUC E PHIEUPH
  {0xA578, 0xCA83}, //6435 #HANGUL SYLLABLE SSANGCIEUC E HIEUH
  {0xA579, 0xCA85}, //6436 #HANGUL SYLLABLE SSANGCIEUC YEO KIYEOK
  {0xA57A, 0xCA86}, //6437 #HANGUL SYLLABLE SSANGCIEUC YEO SSANGKIYEOK
  {0xA581, 0xCA87}, //6438 #HANGUL SYLLABLE SSANGCIEUC YEO KIYEOKSIOS
  {0xA582, 0xCA88}, //6439 #HANGUL SYLLABLE SSANGCIEUC YEO NIEUN
  {0xA583, 0xCA89}, //6440 #HANGUL SYLLABLE SSANGCIEUC YEO NIEUNCIEUC
  {0xA584, 0xCA8A}, //6441 #HANGUL SYLLABLE SSANGCIEUC YEO NIEUNHIEUH
  {0xA585, 0xCA8B}, //6442 #HANGUL SYLLABLE SSANGCIEUC YEO TIKEUT
  {0xA586, 0xCA8C}, //6443 #HANGUL SYLLABLE SSANGCIEUC YEO RIEUL
  {0xA587, 0xCA8D}, //6444 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULKIYEOK
  {0xA588, 0xCA8E}, //6445 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULMIEUM
  {0xA589, 0xCA8F}, //6446 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULPIEUP
  {0xA58A, 0xCA90}, //6447 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULSIOS
  {0xA58B, 0xCA91}, //6448 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULTHIEUTH
  {0xA58C, 0xCA92}, //6449 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULPHIEUPH
  {0xA58D, 0xCA93}, //6450 #HANGUL SYLLABLE SSANGCIEUC YEO RIEULHIEUH
  {0xA58E, 0xCA94}, //6451 #HANGUL SYLLABLE SSANGCIEUC YEO MIEUM
  {0xA58F, 0xCA95}, //6452 #HANGUL SYLLABLE SSANGCIEUC YEO PIEUP
  {0xA590, 0xCA96}, //6453 #HANGUL SYLLABLE SSANGCIEUC YEO PIEUPSIOS
  {0xA591, 0xCA97}, //6454 #HANGUL SYLLABLE SSANGCIEUC YEO SIOS
  {0xA592, 0xCA99}, //6455 #HANGUL SYLLABLE SSANGCIEUC YEO IEUNG
  {0xA593, 0xCA9A}, //6456 #HANGUL SYLLABLE SSANGCIEUC YEO CIEUC
  {0xA594, 0xCA9B}, //6457 #HANGUL SYLLABLE SSANGCIEUC YEO CHIEUCH
  {0xA595, 0xCA9C}, //6458 #HANGUL SYLLABLE SSANGCIEUC YEO KHIEUKH
  {0xA596, 0xCA9D}, //6459 #HANGUL SYLLABLE SSANGCIEUC YEO THIEUTH
  {0xA597, 0xCA9E}, //6460 #HANGUL SYLLABLE SSANGCIEUC YEO PHIEUPH
  {0xA598, 0xCA9F}, //6461 #HANGUL SYLLABLE SSANGCIEUC YEO HIEUH
  {0xA599, 0xCAA0}, //6462 #HANGUL SYLLABLE SSANGCIEUC YE
  {0xA59A, 0xCAA1}, //6463 #HANGUL SYLLABLE SSANGCIEUC YE KIYEOK
  {0xA59B, 0xCAA2}, //6464 #HANGUL SYLLABLE SSANGCIEUC YE SSANGKIYEOK
  {0xA59C, 0xCAA3}, //6465 #HANGUL SYLLABLE SSANGCIEUC YE KIYEOKSIOS
  {0xA59D, 0xCAA4}, //6466 #HANGUL SYLLABLE SSANGCIEUC YE NIEUN
  {0xA59E, 0xCAA5}, //6467 #HANGUL SYLLABLE SSANGCIEUC YE NIEUNCIEUC
  {0xA59F, 0xCAA6}, //6468 #HANGUL SYLLABLE SSANGCIEUC YE NIEUNHIEUH
  {0xA5A0, 0xCAA7}, //6469 #HANGUL SYLLABLE SSANGCIEUC YE TIKEUT
  {0xA5A1, 0x2170}, //6470 #SMALL ROMAN NUMERAL ONE
  {0xA5A2, 0x2171}, //6471 #SMALL ROMAN NUMERAL TWO
  {0xA5A3, 0x2172}, //6472 #SMALL ROMAN NUMERAL THREE
  {0xA5A4, 0x2173}, //6473 #SMALL ROMAN NUMERAL FOUR
  {0xA5A5, 0x2174}, //6474 #SMALL ROMAN NUMERAL FIVE
  {0xA5A6, 0x2175}, //6475 #SMALL ROMAN NUMERAL SIX
  {0xA5A7, 0x2176}, //6476 #SMALL ROMAN NUMERAL SEVEN
  {0xA5A8, 0x2177}, //6477 #SMALL ROMAN NUMERAL EIGHT
  {0xA5A9, 0x2178}, //6478 #SMALL ROMAN NUMERAL NINE
  {0xA5AA, 0x2179}, //6479 #SMALL ROMAN NUMERAL TEN
  {0xA5B0, 0x2160}, //6480 #ROMAN NUMERAL ONE
  {0xA5B1, 0x2161}, //6481 #ROMAN NUMERAL TWO
  {0xA5B2, 0x2162}, //6482 #ROMAN NUMERAL THREE
  {0xA5B3, 0x2163}, //6483 #ROMAN NUMERAL FOUR
  {0xA5B4, 0x2164}, //6484 #ROMAN NUMERAL FIVE
  {0xA5B5, 0x2165}, //6485 #ROMAN NUMERAL SIX
  {0xA5B6, 0x2166}, //6486 #ROMAN NUMERAL SEVEN
  {0xA5B7, 0x2167}, //6487 #ROMAN NUMERAL EIGHT
  {0xA5B8, 0x2168}, //6488 #ROMAN NUMERAL NINE
  {0xA5B9, 0x2169}, //6489 #ROMAN NUMERAL TEN
  {0xA5C1, 0x0391}, //6490 #GREEK CAPITAL LETTER ALPHA
  {0xA5C2, 0x0392}, //6491 #GREEK CAPITAL LETTER BETA
  {0xA5C3, 0x0393}, //6492 #GREEK CAPITAL LETTER GAMMA
  {0xA5C4, 0x0394}, //6493 #GREEK CAPITAL LETTER DELTA
  {0xA5C5, 0x0395}, //6494 #GREEK CAPITAL LETTER EPSILON
  {0xA5C6, 0x0396}, //6495 #GREEK CAPITAL LETTER ZETA
  {0xA5C7, 0x0397}, //6496 #GREEK CAPITAL LETTER ETA
  {0xA5C8, 0x0398}, //6497 #GREEK CAPITAL LETTER THETA
  {0xA5C9, 0x0399}, //6498 #GREEK CAPITAL LETTER IOTA
  {0xA5CA, 0x039A}, //6499 #GREEK CAPITAL LETTER KAPPA
  {0xA5CB, 0x039B}, //6500 #GREEK CAPITAL LETTER LAMDA
  {0xA5CC, 0x039C}, //6501 #GREEK CAPITAL LETTER MU
  {0xA5CD, 0x039D}, //6502 #GREEK CAPITAL LETTER NU
  {0xA5CE, 0x039E}, //6503 #GREEK CAPITAL LETTER XI
  {0xA5CF, 0x039F}, //6504 #GREEK CAPITAL LETTER OMICRON
  {0xA5D0, 0x03A0}, //6505 #GREEK CAPITAL LETTER PI
  {0xA5D1, 0x03A1}, //6506 #GREEK CAPITAL LETTER RHO
  {0xA5D2, 0x03A3}, //6507 #GREEK CAPITAL LETTER SIGMA
  {0xA5D3, 0x03A4}, //6508 #GREEK CAPITAL LETTER TAU
  {0xA5D4, 0x03A5}, //6509 #GREEK CAPITAL LETTER UPSILON
  {0xA5D5, 0x03A6}, //6510 #GREEK CAPITAL LETTER PHI
  {0xA5D6, 0x03A7}, //6511 #GREEK CAPITAL LETTER CHI
  {0xA5D7, 0x03A8}, //6512 #GREEK CAPITAL LETTER PSI
  {0xA5D8, 0x03A9}, //6513 #GREEK CAPITAL LETTER OMEGA
  {0xA5E1, 0x03B1}, //6514 #GREEK SMALL LETTER ALPHA
  {0xA5E2, 0x03B2}, //6515 #GREEK SMALL LETTER BETA
  {0xA5E3, 0x03B3}, //6516 #GREEK SMALL LETTER GAMMA
  {0xA5E4, 0x03B4}, //6517 #GREEK SMALL LETTER DELTA
  {0xA5E5, 0x03B5}, //6518 #GREEK SMALL LETTER EPSILON
  {0xA5E6, 0x03B6}, //6519 #GREEK SMALL LETTER ZETA
  {0xA5E7, 0x03B7}, //6520 #GREEK SMALL LETTER ETA
  {0xA5E8, 0x03B8}, //6521 #GREEK SMALL LETTER THETA
  {0xA5E9, 0x03B9}, //6522 #GREEK SMALL LETTER IOTA
  {0xA5EA, 0x03BA}, //6523 #GREEK SMALL LETTER KAPPA
  {0xA5EB, 0x03BB}, //6524 #GREEK SMALL LETTER LAMDA
  {0xA5EC, 0x03BC}, //6525 #GREEK SMALL LETTER MU
  {0xA5ED, 0x03BD}, //6526 #GREEK SMALL LETTER NU
  {0xA5EE, 0x03BE}, //6527 #GREEK SMALL LETTER XI
  {0xA5EF, 0x03BF}, //6528 #GREEK SMALL LETTER OMICRON
  {0xA5F0, 0x03C0}, //6529 #GREEK SMALL LETTER PI
  {0xA5F1, 0x03C1}, //6530 #GREEK SMALL LETTER RHO
  {0xA5F2, 0x03C3}, //6531 #GREEK SMALL LETTER SIGMA
  {0xA5F3, 0x03C4}, //6532 #GREEK SMALL LETTER TAU
  {0xA5F4, 0x03C5}, //6533 #GREEK SMALL LETTER UPSILON
  {0xA5F5, 0x03C6}, //6534 #GREEK SMALL LETTER PHI
  {0xA5F6, 0x03C7}, //6535 #GREEK SMALL LETTER CHI
  {0xA5F7, 0x03C8}, //6536 #GREEK SMALL LETTER PSI
  {0xA5F8, 0x03C9}, //6537 #GREEK SMALL LETTER OMEGA
  {0xA641, 0xCAA8}, //6538 #HANGUL SYLLABLE SSANGCIEUC YE RIEUL
  {0xA642, 0xCAA9}, //6539 #HANGUL SYLLABLE SSANGCIEUC YE RIEULKIYEOK
  {0xA643, 0xCAAA}, //6540 #HANGUL SYLLABLE SSANGCIEUC YE RIEULMIEUM
  {0xA644, 0xCAAB}, //6541 #HANGUL SYLLABLE SSANGCIEUC YE RIEULPIEUP
  {0xA645, 0xCAAC}, //6542 #HANGUL SYLLABLE SSANGCIEUC YE RIEULSIOS
  {0xA646, 0xCAAD}, //6543 #HANGUL SYLLABLE SSANGCIEUC YE RIEULTHIEUTH
  {0xA647, 0xCAAE}, //6544 #HANGUL SYLLABLE SSANGCIEUC YE RIEULPHIEUPH
  {0xA648, 0xCAAF}, //6545 #HANGUL SYLLABLE SSANGCIEUC YE RIEULHIEUH
  {0xA649, 0xCAB0}, //6546 #HANGUL SYLLABLE SSANGCIEUC YE MIEUM
  {0xA64A, 0xCAB1}, //6547 #HANGUL SYLLABLE SSANGCIEUC YE PIEUP
  {0xA64B, 0xCAB2}, //6548 #HANGUL SYLLABLE SSANGCIEUC YE PIEUPSIOS
  {0xA64C, 0xCAB3}, //6549 #HANGUL SYLLABLE SSANGCIEUC YE SIOS
  {0xA64D, 0xCAB4}, //6550 #HANGUL SYLLABLE SSANGCIEUC YE SSANGSIOS
  {0xA64E, 0xCAB5}, //6551 #HANGUL SYLLABLE SSANGCIEUC YE IEUNG
  {0xA64F, 0xCAB6}, //6552 #HANGUL SYLLABLE SSANGCIEUC YE CIEUC
  {0xA650, 0xCAB7}, //6553 #HANGUL SYLLABLE SSANGCIEUC YE CHIEUCH
  {0xA651, 0xCAB8}, //6554 #HANGUL SYLLABLE SSANGCIEUC YE KHIEUKH
  {0xA652, 0xCAB9}, //6555 #HANGUL SYLLABLE SSANGCIEUC YE THIEUTH
  {0xA653, 0xCABA}, //6556 #HANGUL SYLLABLE SSANGCIEUC YE PHIEUPH
  {0xA654, 0xCABB}, //6557 #HANGUL SYLLABLE SSANGCIEUC YE HIEUH
  {0xA655, 0xCABE}, //6558 #HANGUL SYLLABLE SSANGCIEUC O SSANGKIYEOK
  {0xA656, 0xCABF}, //6559 #HANGUL SYLLABLE SSANGCIEUC O KIYEOKSIOS
  {0xA657, 0xCAC1}, //6560 #HANGUL SYLLABLE SSANGCIEUC O NIEUNCIEUC
  {0xA658, 0xCAC2}, //6561 #HANGUL SYLLABLE SSANGCIEUC O NIEUNHIEUH
  {0xA659, 0xCAC3}, //6562 #HANGUL SYLLABLE SSANGCIEUC O TIKEUT
  {0xA65A, 0xCAC5}, //6563 #HANGUL SYLLABLE SSANGCIEUC O RIEULKIYEOK
  {0xA661, 0xCAC6}, //6564 #HANGUL SYLLABLE SSANGCIEUC O RIEULMIEUM
  {0xA662, 0xCAC7}, //6565 #HANGUL SYLLABLE SSANGCIEUC O RIEULPIEUP
  {0xA663, 0xCAC8}, //6566 #HANGUL SYLLABLE SSANGCIEUC O RIEULSIOS
  {0xA664, 0xCAC9}, //6567 #HANGUL SYLLABLE SSANGCIEUC O RIEULTHIEUTH
  {0xA665, 0xCACA}, //6568 #HANGUL SYLLABLE SSANGCIEUC O RIEULPHIEUPH
  {0xA666, 0xCACB}, //6569 #HANGUL SYLLABLE SSANGCIEUC O RIEULHIEUH
  {0xA667, 0xCACE}, //6570 #HANGUL SYLLABLE SSANGCIEUC O PIEUPSIOS
  {0xA668, 0xCAD0}, //6571 #HANGUL SYLLABLE SSANGCIEUC O SSANGSIOS
  {0xA669, 0xCAD2}, //6572 #HANGUL SYLLABLE SSANGCIEUC O CIEUC
  {0xA66A, 0xCAD4}, //6573 #HANGUL SYLLABLE SSANGCIEUC O KHIEUKH
  {0xA66B, 0xCAD5}, //6574 #HANGUL SYLLABLE SSANGCIEUC O THIEUTH
  {0xA66C, 0xCAD6}, //6575 #HANGUL SYLLABLE SSANGCIEUC O PHIEUPH
  {0xA66D, 0xCAD7}, //6576 #HANGUL SYLLABLE SSANGCIEUC O HIEUH
  {0xA66E, 0xCADA}, //6577 #HANGUL SYLLABLE SSANGCIEUC WA SSANGKIYEOK
  {0xA66F, 0xCADB}, //6578 #HANGUL SYLLABLE SSANGCIEUC WA KIYEOKSIOS
  {0xA670, 0xCADC}, //6579 #HANGUL SYLLABLE SSANGCIEUC WA NIEUN
  {0xA671, 0xCADD}, //6580 #HANGUL SYLLABLE SSANGCIEUC WA NIEUNCIEUC
  {0xA672, 0xCADE}, //6581 #HANGUL SYLLABLE SSANGCIEUC WA NIEUNHIEUH
  {0xA673, 0xCADF}, //6582 #HANGUL SYLLABLE SSANGCIEUC WA TIKEUT
  {0xA674, 0xCAE1}, //6583 #HANGUL SYLLABLE SSANGCIEUC WA RIEULKIYEOK
  {0xA675, 0xCAE2}, //6584 #HANGUL SYLLABLE SSANGCIEUC WA RIEULMIEUM
  {0xA676, 0xCAE3}, //6585 #HANGUL SYLLABLE SSANGCIEUC WA RIEULPIEUP
  {0xA677, 0xCAE4}, //6586 #HANGUL SYLLABLE SSANGCIEUC WA RIEULSIOS
  {0xA678, 0xCAE5}, //6587 #HANGUL SYLLABLE SSANGCIEUC WA RIEULTHIEUTH
  {0xA679, 0xCAE6}, //6588 #HANGUL SYLLABLE SSANGCIEUC WA RIEULPHIEUPH
  {0xA67A, 0xCAE7}, //6589 #HANGUL SYLLABLE SSANGCIEUC WA RIEULHIEUH
  {0xA681, 0xCAE8}, //6590 #HANGUL SYLLABLE SSANGCIEUC WA MIEUM
  {0xA682, 0xCAE9}, //6591 #HANGUL SYLLABLE SSANGCIEUC WA PIEUP
  {0xA683, 0xCAEA}, //6592 #HANGUL SYLLABLE SSANGCIEUC WA PIEUPSIOS
  {0xA684, 0xCAEB}, //6593 #HANGUL SYLLABLE SSANGCIEUC WA SIOS
  {0xA685, 0xCAED}, //6594 #HANGUL SYLLABLE SSANGCIEUC WA IEUNG
  {0xA686, 0xCAEE}, //6595 #HANGUL SYLLABLE SSANGCIEUC WA CIEUC
  {0xA687, 0xCAEF}, //6596 #HANGUL SYLLABLE SSANGCIEUC WA CHIEUCH
  {0xA688, 0xCAF0}, //6597 #HANGUL SYLLABLE SSANGCIEUC WA KHIEUKH
  {0xA689, 0xCAF1}, //6598 #HANGUL SYLLABLE SSANGCIEUC WA THIEUTH
  {0xA68A, 0xCAF2}, //6599 #HANGUL SYLLABLE SSANGCIEUC WA PHIEUPH
  {0xA68B, 0xCAF3}, //6600 #HANGUL SYLLABLE SSANGCIEUC WA HIEUH
  {0xA68C, 0xCAF5}, //6601 #HANGUL SYLLABLE SSANGCIEUC WAE KIYEOK
  {0xA68D, 0xCAF6}, //6602 #HANGUL SYLLABLE SSANGCIEUC WAE SSANGKIYEOK
  {0xA68E, 0xCAF7}, //6603 #HANGUL SYLLABLE SSANGCIEUC WAE KIYEOKSIOS
  {0xA68F, 0xCAF8}, //6604 #HANGUL SYLLABLE SSANGCIEUC WAE NIEUN
  {0xA690, 0xCAF9}, //6605 #HANGUL SYLLABLE SSANGCIEUC WAE NIEUNCIEUC
  {0xA691, 0xCAFA}, //6606 #HANGUL SYLLABLE SSANGCIEUC WAE NIEUNHIEUH
  {0xA692, 0xCAFB}, //6607 #HANGUL SYLLABLE SSANGCIEUC WAE TIKEUT
  {0xA693, 0xCAFC}, //6608 #HANGUL SYLLABLE SSANGCIEUC WAE RIEUL
  {0xA694, 0xCAFD}, //6609 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULKIYEOK
  {0xA695, 0xCAFE}, //6610 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULMIEUM
  {0xA696, 0xCAFF}, //6611 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULPIEUP
  {0xA697, 0xCB00}, //6612 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULSIOS
  {0xA698, 0xCB01}, //6613 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULTHIEUTH
  {0xA699, 0xCB02}, //6614 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULPHIEUPH
  {0xA69A, 0xCB03}, //6615 #HANGUL SYLLABLE SSANGCIEUC WAE RIEULHIEUH
  {0xA69B, 0xCB04}, //6616 #HANGUL SYLLABLE SSANGCIEUC WAE MIEUM
  {0xA69C, 0xCB05}, //6617 #HANGUL SYLLABLE SSANGCIEUC WAE PIEUP
  {0xA69D, 0xCB06}, //6618 #HANGUL SYLLABLE SSANGCIEUC WAE PIEUPSIOS
  {0xA69E, 0xCB07}, //6619 #HANGUL SYLLABLE SSANGCIEUC WAE SIOS
  {0xA69F, 0xCB09}, //6620 #HANGUL SYLLABLE SSANGCIEUC WAE IEUNG
  {0xA6A0, 0xCB0A}, //6621 #HANGUL SYLLABLE SSANGCIEUC WAE CIEUC
  {0xA6A1, 0x2500}, //6622 #BOX DRAWINGS LIGHT HORIZONTAL
  {0xA6A2, 0x2502}, //6623 #BOX DRAWINGS LIGHT VERTICAL
  {0xA6A3, 0x250C}, //6624 #BOX DRAWINGS LIGHT DOWN AND RIGHT
  {0xA6A4, 0x2510}, //6625 #BOX DRAWINGS LIGHT DOWN AND LEFT
  {0xA6A5, 0x2518}, //6626 #BOX DRAWINGS LIGHT UP AND LEFT
  {0xA6A6, 0x2514}, //6627 #BOX DRAWINGS LIGHT UP AND RIGHT
  {0xA6A7, 0x251C}, //6628 #BOX DRAWINGS LIGHT VERTICAL AND RIGHT
  {0xA6A8, 0x252C}, //6629 #BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
  {0xA6A9, 0x2524}, //6630 #BOX DRAWINGS LIGHT VERTICAL AND LEFT
  {0xA6AA, 0x2534}, //6631 #BOX DRAWINGS LIGHT UP AND HORIZONTAL
  {0xA6AB, 0x253C}, //6632 #BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
  {0xA6AC, 0x2501}, //6633 #BOX DRAWINGS HEAVY HORIZONTAL
  {0xA6AD, 0x2503}, //6634 #BOX DRAWINGS HEAVY VERTICAL
  {0xA6AE, 0x250F}, //6635 #BOX DRAWINGS HEAVY DOWN AND RIGHT
  {0xA6AF, 0x2513}, //6636 #BOX DRAWINGS HEAVY DOWN AND LEFT
  {0xA6B0, 0x251B}, //6637 #BOX DRAWINGS HEAVY UP AND LEFT
  {0xA6B1, 0x2517}, //6638 #BOX DRAWINGS HEAVY UP AND RIGHT
  {0xA6B2, 0x2523}, //6639 #BOX DRAWINGS HEAVY VERTICAL AND RIGHT
  {0xA6B3, 0x2533}, //6640 #BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
  {0xA6B4, 0x252B}, //6641 #BOX DRAWINGS HEAVY VERTICAL AND LEFT
  {0xA6B5, 0x253B}, //6642 #BOX DRAWINGS HEAVY UP AND HORIZONTAL
  {0xA6B6, 0x254B}, //6643 #BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
  {0xA6B7, 0x2520}, //6644 #BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
  {0xA6B8, 0x252F}, //6645 #BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
  {0xA6B9, 0x2528}, //6646 #BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
  {0xA6BA, 0x2537}, //6647 #BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
  {0xA6BB, 0x253F}, //6648 #BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
  {0xA6BC, 0x251D}, //6649 #BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
  {0xA6BD, 0x2530}, //6650 #BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
  {0xA6BE, 0x2525}, //6651 #BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
  {0xA6BF, 0x2538}, //6652 #BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
  {0xA6C0, 0x2542}, //6653 #BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
  {0xA6C1, 0x2512}, //6654 #BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
  {0xA6C2, 0x2511}, //6655 #BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
  {0xA6C3, 0x251A}, //6656 #BOX DRAWINGS UP HEAVY AND LEFT LIGHT
  {0xA6C4, 0x2519}, //6657 #BOX DRAWINGS UP LIGHT AND LEFT HEAVY
  {0xA6C5, 0x2516}, //6658 #BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
  {0xA6C6, 0x2515}, //6659 #BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
  {0xA6C7, 0x250E}, //6660 #BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
  {0xA6C8, 0x250D}, //6661 #BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
  {0xA6C9, 0x251E}, //6662 #BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
  {0xA6CA, 0x251F}, //6663 #BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
  {0xA6CB, 0x2521}, //6664 #BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
  {0xA6CC, 0x2522}, //6665 #BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
  {0xA6CD, 0x2526}, //6666 #BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
  {0xA6CE, 0x2527}, //6667 #BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
  {0xA6CF, 0x2529}, //6668 #BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
  {0xA6D0, 0x252A}, //6669 #BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
  {0xA6D1, 0x252D}, //6670 #BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
  {0xA6D2, 0x252E}, //6671 #BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
  {0xA6D3, 0x2531}, //6672 #BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
  {0xA6D4, 0x2532}, //6673 #BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
  {0xA6D5, 0x2535}, //6674 #BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
  {0xA6D6, 0x2536}, //6675 #BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
  {0xA6D7, 0x2539}, //6676 #BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
  {0xA6D8, 0x253A}, //6677 #BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
  {0xA6D9, 0x253D}, //6678 #BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
  {0xA6DA, 0x253E}, //6679 #BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
  {0xA6DB, 0x2540}, //6680 #BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
  {0xA6DC, 0x2541}, //6681 #BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
  {0xA6DD, 0x2543}, //6682 #BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
  {0xA6DE, 0x2544}, //6683 #BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
  {0xA6DF, 0x2545}, //6684 #BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
  {0xA6E0, 0x2546}, //6685 #BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
  {0xA6E1, 0x2547}, //6686 #BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
  {0xA6E2, 0x2548}, //6687 #BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
  {0xA6E3, 0x2549}, //6688 #BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
  {0xA6E4, 0x254A}, //6689 #BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
  {0xA741, 0xCB0B}, //6690 #HANGUL SYLLABLE SSANGCIEUC WAE CHIEUCH
  {0xA742, 0xCB0C}, //6691 #HANGUL SYLLABLE SSANGCIEUC WAE KHIEUKH
  {0xA743, 0xCB0D}, //6692 #HANGUL SYLLABLE SSANGCIEUC WAE THIEUTH
  {0xA744, 0xCB0E}, //6693 #HANGUL SYLLABLE SSANGCIEUC WAE PHIEUPH
  {0xA745, 0xCB0F}, //6694 #HANGUL SYLLABLE SSANGCIEUC WAE HIEUH
  {0xA746, 0xCB11}, //6695 #HANGUL SYLLABLE SSANGCIEUC OE KIYEOK
  {0xA747, 0xCB12}, //6696 #HANGUL SYLLABLE SSANGCIEUC OE SSANGKIYEOK
  {0xA748, 0xCB13}, //6697 #HANGUL SYLLABLE SSANGCIEUC OE KIYEOKSIOS
  {0xA749, 0xCB15}, //6698 #HANGUL SYLLABLE SSANGCIEUC OE NIEUNCIEUC
  {0xA74A, 0xCB16}, //6699 #HANGUL SYLLABLE SSANGCIEUC OE NIEUNHIEUH
  {0xA74B, 0xCB17}, //6700 #HANGUL SYLLABLE SSANGCIEUC OE TIKEUT
  {0xA74C, 0xCB19}, //6701 #HANGUL SYLLABLE SSANGCIEUC OE RIEULKIYEOK
  {0xA74D, 0xCB1A}, //6702 #HANGUL SYLLABLE SSANGCIEUC OE RIEULMIEUM
  {0xA74E, 0xCB1B}, //6703 #HANGUL SYLLABLE SSANGCIEUC OE RIEULPIEUP
  {0xA74F, 0xCB1C}, //6704 #HANGUL SYLLABLE SSANGCIEUC OE RIEULSIOS
  {0xA750, 0xCB1D}, //6705 #HANGUL SYLLABLE SSANGCIEUC OE RIEULTHIEUTH
  {0xA751, 0xCB1E}, //6706 #HANGUL SYLLABLE SSANGCIEUC OE RIEULPHIEUPH
  {0xA752, 0xCB1F}, //6707 #HANGUL SYLLABLE SSANGCIEUC OE RIEULHIEUH
  {0xA753, 0xCB22}, //6708 #HANGUL SYLLABLE SSANGCIEUC OE PIEUPSIOS
  {0xA754, 0xCB23}, //6709 #HANGUL SYLLABLE SSANGCIEUC OE SIOS
  {0xA755, 0xCB24}, //6710 #HANGUL SYLLABLE SSANGCIEUC OE SSANGSIOS
  {0xA756, 0xCB25}, //6711 #HANGUL SYLLABLE SSANGCIEUC OE IEUNG
  {0xA757, 0xCB26}, //6712 #HANGUL SYLLABLE SSANGCIEUC OE CIEUC
  {0xA758, 0xCB27}, //6713 #HANGUL SYLLABLE SSANGCIEUC OE CHIEUCH
  {0xA759, 0xCB28}, //6714 #HANGUL SYLLABLE SSANGCIEUC OE KHIEUKH
  {0xA75A, 0xCB29}, //6715 #HANGUL SYLLABLE SSANGCIEUC OE THIEUTH
  {0xA761, 0xCB2A}, //6716 #HANGUL SYLLABLE SSANGCIEUC OE PHIEUPH
  {0xA762, 0xCB2B}, //6717 #HANGUL SYLLABLE SSANGCIEUC OE HIEUH
  {0xA763, 0xCB2C}, //6718 #HANGUL SYLLABLE SSANGCIEUC YO
  {0xA764, 0xCB2D}, //6719 #HANGUL SYLLABLE SSANGCIEUC YO KIYEOK
  {0xA765, 0xCB2E}, //6720 #HANGUL SYLLABLE SSANGCIEUC YO SSANGKIYEOK
  {0xA766, 0xCB2F}, //6721 #HANGUL SYLLABLE SSANGCIEUC YO KIYEOKSIOS
  {0xA767, 0xCB30}, //6722 #HANGUL SYLLABLE SSANGCIEUC YO NIEUN
  {0xA768, 0xCB31}, //6723 #HANGUL SYLLABLE SSANGCIEUC YO NIEUNCIEUC
  {0xA769, 0xCB32}, //6724 #HANGUL SYLLABLE SSANGCIEUC YO NIEUNHIEUH
  {0xA76A, 0xCB33}, //6725 #HANGUL SYLLABLE SSANGCIEUC YO TIKEUT
  {0xA76B, 0xCB34}, //6726 #HANGUL SYLLABLE SSANGCIEUC YO RIEUL
  {0xA76C, 0xCB35}, //6727 #HANGUL SYLLABLE SSANGCIEUC YO RIEULKIYEOK
  {0xA76D, 0xCB36}, //6728 #HANGUL SYLLABLE SSANGCIEUC YO RIEULMIEUM
  {0xA76E, 0xCB37}, //6729 #HANGUL SYLLABLE SSANGCIEUC YO RIEULPIEUP
  {0xA76F, 0xCB38}, //6730 #HANGUL SYLLABLE SSANGCIEUC YO RIEULSIOS
  {0xA770, 0xCB39}, //6731 #HANGUL SYLLABLE SSANGCIEUC YO RIEULTHIEUTH
  {0xA771, 0xCB3A}, //6732 #HANGUL SYLLABLE SSANGCIEUC YO RIEULPHIEUPH
  {0xA772, 0xCB3B}, //6733 #HANGUL SYLLABLE SSANGCIEUC YO RIEULHIEUH
  {0xA773, 0xCB3C}, //6734 #HANGUL SYLLABLE SSANGCIEUC YO MIEUM
  {0xA774, 0xCB3D}, //6735 #HANGUL SYLLABLE SSANGCIEUC YO PIEUP
  {0xA775, 0xCB3E}, //6736 #HANGUL SYLLABLE SSANGCIEUC YO PIEUPSIOS
  {0xA776, 0xCB3F}, //6737 #HANGUL SYLLABLE SSANGCIEUC YO SIOS
  {0xA777, 0xCB40}, //6738 #HANGUL SYLLABLE SSANGCIEUC YO SSANGSIOS
  {0xA778, 0xCB42}, //6739 #HANGUL SYLLABLE SSANGCIEUC YO CIEUC
  {0xA779, 0xCB43}, //6740 #HANGUL SYLLABLE SSANGCIEUC YO CHIEUCH
  {0xA77A, 0xCB44}, //6741 #HANGUL SYLLABLE SSANGCIEUC YO KHIEUKH
  {0xA781, 0xCB45}, //6742 #HANGUL SYLLABLE SSANGCIEUC YO THIEUTH
  {0xA782, 0xCB46}, //6743 #HANGUL SYLLABLE SSANGCIEUC YO PHIEUPH
  {0xA783, 0xCB47}, //6744 #HANGUL SYLLABLE SSANGCIEUC YO HIEUH
  {0xA784, 0xCB4A}, //6745 #HANGUL SYLLABLE SSANGCIEUC U SSANGKIYEOK
  {0xA785, 0xCB4B}, //6746 #HANGUL SYLLABLE SSANGCIEUC U KIYEOKSIOS
  {0xA786, 0xCB4D}, //6747 #HANGUL SYLLABLE SSANGCIEUC U NIEUNCIEUC
  {0xA787, 0xCB4E}, //6748 #HANGUL SYLLABLE SSANGCIEUC U NIEUNHIEUH
  {0xA788, 0xCB4F}, //6749 #HANGUL SYLLABLE SSANGCIEUC U TIKEUT
  {0xA789, 0xCB51}, //6750 #HANGUL SYLLABLE SSANGCIEUC U RIEULKIYEOK
  {0xA78A, 0xCB52}, //6751 #HANGUL SYLLABLE SSANGCIEUC U RIEULMIEUM
  {0xA78B, 0xCB53}, //6752 #HANGUL SYLLABLE SSANGCIEUC U RIEULPIEUP
  {0xA78C, 0xCB54}, //6753 #HANGUL SYLLABLE SSANGCIEUC U RIEULSIOS
  {0xA78D, 0xCB55}, //6754 #HANGUL SYLLABLE SSANGCIEUC U RIEULTHIEUTH
  {0xA78E, 0xCB56}, //6755 #HANGUL SYLLABLE SSANGCIEUC U RIEULPHIEUPH
  {0xA78F, 0xCB57}, //6756 #HANGUL SYLLABLE SSANGCIEUC U RIEULHIEUH
  {0xA790, 0xCB5A}, //6757 #HANGUL SYLLABLE SSANGCIEUC U PIEUPSIOS
  {0xA791, 0xCB5B}, //6758 #HANGUL SYLLABLE SSANGCIEUC U SIOS
  {0xA792, 0xCB5C}, //6759 #HANGUL SYLLABLE SSANGCIEUC U SSANGSIOS
  {0xA793, 0xCB5E}, //6760 #HANGUL SYLLABLE SSANGCIEUC U CIEUC
  {0xA794, 0xCB5F}, //6761 #HANGUL SYLLABLE SSANGCIEUC U CHIEUCH
  {0xA795, 0xCB60}, //6762 #HANGUL SYLLABLE SSANGCIEUC U KHIEUKH
  {0xA796, 0xCB61}, //6763 #HANGUL SYLLABLE SSANGCIEUC U THIEUTH
  {0xA797, 0xCB62}, //6764 #HANGUL SYLLABLE SSANGCIEUC U PHIEUPH
  {0xA798, 0xCB63}, //6765 #HANGUL SYLLABLE SSANGCIEUC U HIEUH
  {0xA799, 0xCB65}, //6766 #HANGUL SYLLABLE SSANGCIEUC WEO KIYEOK
  {0xA79A, 0xCB66}, //6767 #HANGUL SYLLABLE SSANGCIEUC WEO SSANGKIYEOK
  {0xA79B, 0xCB67}, //6768 #HANGUL SYLLABLE SSANGCIEUC WEO KIYEOKSIOS
  {0xA79C, 0xCB68}, //6769 #HANGUL SYLLABLE SSANGCIEUC WEO NIEUN
  {0xA79D, 0xCB69}, //6770 #HANGUL SYLLABLE SSANGCIEUC WEO NIEUNCIEUC
  {0xA79E, 0xCB6A}, //6771 #HANGUL SYLLABLE SSANGCIEUC WEO NIEUNHIEUH
  {0xA79F, 0xCB6B}, //6772 #HANGUL SYLLABLE SSANGCIEUC WEO TIKEUT
  {0xA7A0, 0xCB6C}, //6773 #HANGUL SYLLABLE SSANGCIEUC WEO RIEUL
  {0xA7A1, 0x3395}, //6774 #SQUARE MU L
  {0xA7A2, 0x3396}, //6775 #SQUARE ML
  {0xA7A3, 0x3397}, //6776 #SQUARE DL
  {0xA7A4, 0x2113}, //6777 #SCRIPT SMALL L
  {0xA7A5, 0x3398}, //6778 #SQUARE KL
  {0xA7A6, 0x33C4}, //6779 #SQUARE CC
  {0xA7A7, 0x33A3}, //6780 #SQUARE MM CUBED
  {0xA7A8, 0x33A4}, //6781 #SQUARE CM CUBED
  {0xA7A9, 0x33A5}, //6782 #SQUARE M CUBED
  {0xA7AA, 0x33A6}, //6783 #SQUARE KM CUBED
  {0xA7AB, 0x3399}, //6784 #SQUARE FM
  {0xA7AC, 0x339A}, //6785 #SQUARE NM
  {0xA7AD, 0x339B}, //6786 #SQUARE MU M
  {0xA7AE, 0x339C}, //6787 #SQUARE MM
  {0xA7AF, 0x339D}, //6788 #SQUARE CM
  {0xA7B0, 0x339E}, //6789 #SQUARE KM
  {0xA7B1, 0x339F}, //6790 #SQUARE MM SQUARED
  {0xA7B2, 0x33A0}, //6791 #SQUARE CM SQUARED
  {0xA7B3, 0x33A1}, //6792 #SQUARE M SQUARED
  {0xA7B4, 0x33A2}, //6793 #SQUARE KM SQUARED
  {0xA7B5, 0x33CA}, //6794 #SQUARE HA
  {0xA7B6, 0x338D}, //6795 #SQUARE MU G
  {0xA7B7, 0x338E}, //6796 #SQUARE MG
  {0xA7B8, 0x338F}, //6797 #SQUARE KG
  {0xA7B9, 0x33CF}, //6798 #SQUARE KT
  {0xA7BA, 0x3388}, //6799 #SQUARE CAL
  {0xA7BB, 0x3389}, //6800 #SQUARE KCAL
  {0xA7BC, 0x33C8}, //6801 #SQUARE DB
  {0xA7BD, 0x33A7}, //6802 #SQUARE M OVER S
  {0xA7BE, 0x33A8}, //6803 #SQUARE M OVER S SQUARED
  {0xA7BF, 0x33B0}, //6804 #SQUARE PS
  {0xA7C0, 0x33B1}, //6805 #SQUARE NS
  {0xA7C1, 0x33B2}, //6806 #SQUARE MU S
  {0xA7C2, 0x33B3}, //6807 #SQUARE MS
  {0xA7C3, 0x33B4}, //6808 #SQUARE PV
  {0xA7C4, 0x33B5}, //6809 #SQUARE NV
  {0xA7C5, 0x33B6}, //6810 #SQUARE MU V
  {0xA7C6, 0x33B7}, //6811 #SQUARE MV
  {0xA7C7, 0x33B8}, //6812 #SQUARE KV
  {0xA7C8, 0x33B9}, //6813 #SQUARE MV MEGA
  {0xA7C9, 0x3380}, //6814 #SQUARE PA AMPS
  {0xA7CA, 0x3381}, //6815 #SQUARE NA
  {0xA7CB, 0x3382}, //6816 #SQUARE MU A
  {0xA7CC, 0x3383}, //6817 #SQUARE MA
  {0xA7CD, 0x3384}, //6818 #SQUARE KA
  {0xA7CE, 0x33BA}, //6819 #SQUARE PW
  {0xA7CF, 0x33BB}, //6820 #SQUARE NW
  {0xA7D0, 0x33BC}, //6821 #SQUARE MU W
  {0xA7D1, 0x33BD}, //6822 #SQUARE MW
  {0xA7D2, 0x33BE}, //6823 #SQUARE KW
  {0xA7D3, 0x33BF}, //6824 #SQUARE MW MEGA
  {0xA7D4, 0x3390}, //6825 #SQUARE HZ
  {0xA7D5, 0x3391}, //6826 #SQUARE KHZ
  {0xA7D6, 0x3392}, //6827 #SQUARE MHZ
  {0xA7D7, 0x3393}, //6828 #SQUARE GHZ
  {0xA7D8, 0x3394}, //6829 #SQUARE THZ
  {0xA7D9, 0x2126}, //6830 #OHM SIGN
  {0xA7DA, 0x33C0}, //6831 #SQUARE K OHM
  {0xA7DB, 0x33C1}, //6832 #SQUARE M OHM
  {0xA7DC, 0x338A}, //6833 #SQUARE PF
  {0xA7DD, 0x338B}, //6834 #SQUARE NF
  {0xA7DE, 0x338C}, //6835 #SQUARE MU F
  {0xA7DF, 0x33D6}, //6836 #SQUARE MOL
  {0xA7E0, 0x33C5}, //6837 #SQUARE CD
  {0xA7E1, 0x33AD}, //6838 #SQUARE RAD
  {0xA7E2, 0x33AE}, //6839 #SQUARE RAD OVER S
  {0xA7E3, 0x33AF}, //6840 #SQUARE RAD OVER S SQUARED
  {0xA7E4, 0x33DB}, //6841 #SQUARE SR
  {0xA7E5, 0x33A9}, //6842 #SQUARE PA
  {0xA7E6, 0x33AA}, //6843 #SQUARE KPA
  {0xA7E7, 0x33AB}, //6844 #SQUARE MPA
  {0xA7E8, 0x33AC}, //6845 #SQUARE GPA
  {0xA7E9, 0x33DD}, //6846 #SQUARE WB
  {0xA7EA, 0x33D0}, //6847 #SQUARE LM
  {0xA7EB, 0x33D3}, //6848 #SQUARE LX
  {0xA7EC, 0x33C3}, //6849 #SQUARE BQ
  {0xA7ED, 0x33C9}, //6850 #SQUARE GY
  {0xA7EE, 0x33DC}, //6851 #SQUARE SV
  {0xA7EF, 0x33C6}, //6852 #SQUARE C OVER KG
  {0xA841, 0xCB6D}, //6853 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULKIYEOK
  {0xA842, 0xCB6E}, //6854 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULMIEUM
  {0xA843, 0xCB6F}, //6855 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULPIEUP
  {0xA844, 0xCB70}, //6856 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULSIOS
  {0xA845, 0xCB71}, //6857 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULTHIEUTH
  {0xA846, 0xCB72}, //6858 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULPHIEUPH
  {0xA847, 0xCB73}, //6859 #HANGUL SYLLABLE SSANGCIEUC WEO RIEULHIEUH
  {0xA848, 0xCB74}, //6860 #HANGUL SYLLABLE SSANGCIEUC WEO MIEUM
  {0xA849, 0xCB75}, //6861 #HANGUL SYLLABLE SSANGCIEUC WEO PIEUP
  {0xA84A, 0xCB76}, //6862 #HANGUL SYLLABLE SSANGCIEUC WEO PIEUPSIOS
  {0xA84B, 0xCB77}, //6863 #HANGUL SYLLABLE SSANGCIEUC WEO SIOS
  {0xA84C, 0xCB7A}, //6864 #HANGUL SYLLABLE SSANGCIEUC WEO CIEUC
  {0xA84D, 0xCB7B}, //6865 #HANGUL SYLLABLE SSANGCIEUC WEO CHIEUCH
  {0xA84E, 0xCB7C}, //6866 #HANGUL SYLLABLE SSANGCIEUC WEO KHIEUKH
  {0xA84F, 0xCB7D}, //6867 #HANGUL SYLLABLE SSANGCIEUC WEO THIEUTH
  {0xA850, 0xCB7E}, //6868 #HANGUL SYLLABLE SSANGCIEUC WEO PHIEUPH
  {0xA851, 0xCB7F}, //6869 #HANGUL SYLLABLE SSANGCIEUC WEO HIEUH
  {0xA852, 0xCB80}, //6870 #HANGUL SYLLABLE SSANGCIEUC WE
  {0xA853, 0xCB81}, //6871 #HANGUL SYLLABLE SSANGCIEUC WE KIYEOK
  {0xA854, 0xCB82}, //6872 #HANGUL SYLLABLE SSANGCIEUC WE SSANGKIYEOK
  {0xA855, 0xCB83}, //6873 #HANGUL SYLLABLE SSANGCIEUC WE KIYEOKSIOS
  {0xA856, 0xCB84}, //6874 #HANGUL SYLLABLE SSANGCIEUC WE NIEUN
  {0xA857, 0xCB85}, //6875 #HANGUL SYLLABLE SSANGCIEUC WE NIEUNCIEUC
  {0xA858, 0xCB86}, //6876 #HANGUL SYLLABLE SSANGCIEUC WE NIEUNHIEUH
  {0xA859, 0xCB87}, //6877 #HANGUL SYLLABLE SSANGCIEUC WE TIKEUT
  {0xA85A, 0xCB88}, //6878 #HANGUL SYLLABLE SSANGCIEUC WE RIEUL
  {0xA861, 0xCB89}, //6879 #HANGUL SYLLABLE SSANGCIEUC WE RIEULKIYEOK
  {0xA862, 0xCB8A}, //6880 #HANGUL SYLLABLE SSANGCIEUC WE RIEULMIEUM
  {0xA863, 0xCB8B}, //6881 #HANGUL SYLLABLE SSANGCIEUC WE RIEULPIEUP
  {0xA864, 0xCB8C}, //6882 #HANGUL SYLLABLE SSANGCIEUC WE RIEULSIOS
  {0xA865, 0xCB8D}, //6883 #HANGUL SYLLABLE SSANGCIEUC WE RIEULTHIEUTH
  {0xA866, 0xCB8E}, //6884 #HANGUL SYLLABLE SSANGCIEUC WE RIEULPHIEUPH
  {0xA867, 0xCB8F}, //6885 #HANGUL SYLLABLE SSANGCIEUC WE RIEULHIEUH
  {0xA868, 0xCB90}, //6886 #HANGUL SYLLABLE SSANGCIEUC WE MIEUM
  {0xA869, 0xCB91}, //6887 #HANGUL SYLLABLE SSANGCIEUC WE PIEUP
  {0xA86A, 0xCB92}, //6888 #HANGUL SYLLABLE SSANGCIEUC WE PIEUPSIOS
  {0xA86B, 0xCB93}, //6889 #HANGUL SYLLABLE SSANGCIEUC WE SIOS
  {0xA86C, 0xCB94}, //6890 #HANGUL SYLLABLE SSANGCIEUC WE SSANGSIOS
  {0xA86D, 0xCB95}, //6891 #HANGUL SYLLABLE SSANGCIEUC WE IEUNG
  {0xA86E, 0xCB96}, //6892 #HANGUL SYLLABLE SSANGCIEUC WE CIEUC
  {0xA86F, 0xCB97}, //6893 #HANGUL SYLLABLE SSANGCIEUC WE CHIEUCH
  {0xA870, 0xCB98}, //6894 #HANGUL SYLLABLE SSANGCIEUC WE KHIEUKH
  {0xA871, 0xCB99}, //6895 #HANGUL SYLLABLE SSANGCIEUC WE THIEUTH
  {0xA872, 0xCB9A}, //6896 #HANGUL SYLLABLE SSANGCIEUC WE PHIEUPH
  {0xA873, 0xCB9B}, //6897 #HANGUL SYLLABLE SSANGCIEUC WE HIEUH
  {0xA874, 0xCB9D}, //6898 #HANGUL SYLLABLE SSANGCIEUC WI KIYEOK
  {0xA875, 0xCB9E}, //6899 #HANGUL SYLLABLE SSANGCIEUC WI SSANGKIYEOK
  {0xA876, 0xCB9F}, //6900 #HANGUL SYLLABLE SSANGCIEUC WI KIYEOKSIOS
  {0xA877, 0xCBA0}, //6901 #HANGUL SYLLABLE SSANGCIEUC WI NIEUN
  {0xA878, 0xCBA1}, //6902 #HANGUL SYLLABLE SSANGCIEUC WI NIEUNCIEUC
  {0xA879, 0xCBA2}, //6903 #HANGUL SYLLABLE SSANGCIEUC WI NIEUNHIEUH
  {0xA87A, 0xCBA3}, //6904 #HANGUL SYLLABLE SSANGCIEUC WI TIKEUT
  {0xA881, 0xCBA4}, //6905 #HANGUL SYLLABLE SSANGCIEUC WI RIEUL
  {0xA882, 0xCBA5}, //6906 #HANGUL SYLLABLE SSANGCIEUC WI RIEULKIYEOK
  {0xA883, 0xCBA6}, //6907 #HANGUL SYLLABLE SSANGCIEUC WI RIEULMIEUM
  {0xA884, 0xCBA7}, //6908 #HANGUL SYLLABLE SSANGCIEUC WI RIEULPIEUP
  {0xA885, 0xCBA8}, //6909 #HANGUL SYLLABLE SSANGCIEUC WI RIEULSIOS
  {0xA886, 0xCBA9}, //6910 #HANGUL SYLLABLE SSANGCIEUC WI RIEULTHIEUTH
  {0xA887, 0xCBAA}, //6911 #HANGUL SYLLABLE SSANGCIEUC WI RIEULPHIEUPH
  {0xA888, 0xCBAB}, //6912 #HANGUL SYLLABLE SSANGCIEUC WI RIEULHIEUH
  {0xA889, 0xCBAC}, //6913 #HANGUL SYLLABLE SSANGCIEUC WI MIEUM
  {0xA88A, 0xCBAD}, //6914 #HANGUL SYLLABLE SSANGCIEUC WI PIEUP
  {0xA88B, 0xCBAE}, //6915 #HANGUL SYLLABLE SSANGCIEUC WI PIEUPSIOS
  {0xA88C, 0xCBAF}, //6916 #HANGUL SYLLABLE SSANGCIEUC WI SIOS
  {0xA88D, 0xCBB0}, //6917 #HANGUL SYLLABLE SSANGCIEUC WI SSANGSIOS
  {0xA88E, 0xCBB1}, //6918 #HANGUL SYLLABLE SSANGCIEUC WI IEUNG
  {0xA88F, 0xCBB2}, //6919 #HANGUL SYLLABLE SSANGCIEUC WI CIEUC
  {0xA890, 0xCBB3}, //6920 #HANGUL SYLLABLE SSANGCIEUC WI CHIEUCH
  {0xA891, 0xCBB4}, //6921 #HANGUL SYLLABLE SSANGCIEUC WI KHIEUKH
  {0xA892, 0xCBB5}, //6922 #HANGUL SYLLABLE SSANGCIEUC WI THIEUTH
  {0xA893, 0xCBB6}, //6923 #HANGUL SYLLABLE SSANGCIEUC WI PHIEUPH
  {0xA894, 0xCBB7}, //6924 #HANGUL SYLLABLE SSANGCIEUC WI HIEUH
  {0xA895, 0xCBB9}, //6925 #HANGUL SYLLABLE SSANGCIEUC YU KIYEOK
  {0xA896, 0xCBBA}, //6926 #HANGUL SYLLABLE SSANGCIEUC YU SSANGKIYEOK
  {0xA897, 0xCBBB}, //6927 #HANGUL SYLLABLE SSANGCIEUC YU KIYEOKSIOS
  {0xA898, 0xCBBC}, //6928 #HANGUL SYLLABLE SSANGCIEUC YU NIEUN
  {0xA899, 0xCBBD}, //6929 #HANGUL SYLLABLE SSANGCIEUC YU NIEUNCIEUC
  {0xA89A, 0xCBBE}, //6930 #HANGUL SYLLABLE SSANGCIEUC YU NIEUNHIEUH
  {0xA89B, 0xCBBF}, //6931 #HANGUL SYLLABLE SSANGCIEUC YU TIKEUT
  {0xA89C, 0xCBC0}, //6932 #HANGUL SYLLABLE SSANGCIEUC YU RIEUL
  {0xA89D, 0xCBC1}, //6933 #HANGUL SYLLABLE SSANGCIEUC YU RIEULKIYEOK
  {0xA89E, 0xCBC2}, //6934 #HANGUL SYLLABLE SSANGCIEUC YU RIEULMIEUM
  {0xA89F, 0xCBC3}, //6935 #HANGUL SYLLABLE SSANGCIEUC YU RIEULPIEUP
  {0xA8A0, 0xCBC4}, //6936 #HANGUL SYLLABLE SSANGCIEUC YU RIEULSIOS
  {0xA8A1, 0x00C6}, //6937 #LATIN CAPITAL LETTER AE
  {0xA8A2, 0x00D0}, //6938 #LATIN CAPITAL LETTER ETH
  {0xA8A3, 0x00AA}, //6939 #FEMININE ORDINAL INDICATOR
  {0xA8A4, 0x0126}, //6940 #LATIN CAPITAL LETTER H WITH STROKE
  {0xA8A6, 0x0132}, //6941 #LATIN CAPITAL LIGATURE IJ
  {0xA8A8, 0x013F}, //6942 #LATIN CAPITAL LETTER L WITH MIDDLE DOT
  {0xA8A9, 0x0141}, //6943 #LATIN CAPITAL LETTER L WITH STROKE
  {0xA8AA, 0x00D8}, //6944 #LATIN CAPITAL LETTER O WITH STROKE
  {0xA8AB, 0x0152}, //6945 #LATIN CAPITAL LIGATURE OE
  {0xA8AC, 0x00BA}, //6946 #MASCULINE ORDINAL INDICATOR
  {0xA8AD, 0x00DE}, //6947 #LATIN CAPITAL LETTER THORN
  {0xA8AE, 0x0166}, //6948 #LATIN CAPITAL LETTER T WITH STROKE
  {0xA8AF, 0x014A}, //6949 #LATIN CAPITAL LETTER ENG
  {0xA8B1, 0x3260}, //6950 #CIRCLED HANGUL KIYEOK
  {0xA8B2, 0x3261}, //6951 #CIRCLED HANGUL NIEUN
  {0xA8B3, 0x3262}, //6952 #CIRCLED HANGUL TIKEUT
  {0xA8B4, 0x3263}, //6953 #CIRCLED HANGUL RIEUL
  {0xA8B5, 0x3264}, //6954 #CIRCLED HANGUL MIEUM
  {0xA8B6, 0x3265}, //6955 #CIRCLED HANGUL PIEUP
  {0xA8B7, 0x3266}, //6956 #CIRCLED HANGUL SIOS
  {0xA8B8, 0x3267}, //6957 #CIRCLED HANGUL IEUNG
  {0xA8B9, 0x3268}, //6958 #CIRCLED HANGUL CIEUC
  {0xA8BA, 0x3269}, //6959 #CIRCLED HANGUL CHIEUCH
  {0xA8BB, 0x326A}, //6960 #CIRCLED HANGUL KHIEUKH
  {0xA8BC, 0x326B}, //6961 #CIRCLED HANGUL THIEUTH
  {0xA8BD, 0x326C}, //6962 #CIRCLED HANGUL PHIEUPH
  {0xA8BE, 0x326D}, //6963 #CIRCLED HANGUL HIEUH
  {0xA8BF, 0x326E}, //6964 #CIRCLED HANGUL KIYEOK A
  {0xA8C0, 0x326F}, //6965 #CIRCLED HANGUL NIEUN A
  {0xA8C1, 0x3270}, //6966 #CIRCLED HANGUL TIKEUT A
  {0xA8C2, 0x3271}, //6967 #CIRCLED HANGUL RIEUL A
  {0xA8C3, 0x3272}, //6968 #CIRCLED HANGUL MIEUM A
  {0xA8C4, 0x3273}, //6969 #CIRCLED HANGUL PIEUP A
  {0xA8C5, 0x3274}, //6970 #CIRCLED HANGUL SIOS A
  {0xA8C6, 0x3275}, //6971 #CIRCLED HANGUL IEUNG A
  {0xA8C7, 0x3276}, //6972 #CIRCLED HANGUL CIEUC A
  {0xA8C8, 0x3277}, //6973 #CIRCLED HANGUL CHIEUCH A
  {0xA8C9, 0x3278}, //6974 #CIRCLED HANGUL KHIEUKH A
  {0xA8CA, 0x3279}, //6975 #CIRCLED HANGUL THIEUTH A
  {0xA8CB, 0x327A}, //6976 #CIRCLED HANGUL PHIEUPH A
  {0xA8CC, 0x327B}, //6977 #CIRCLED HANGUL HIEUH A
  {0xA8CD, 0x24D0}, //6978 #CIRCLED LATIN SMALL LETTER A
  {0xA8CE, 0x24D1}, //6979 #CIRCLED LATIN SMALL LETTER B
  {0xA8CF, 0x24D2}, //6980 #CIRCLED LATIN SMALL LETTER C
  {0xA8D0, 0x24D3}, //6981 #CIRCLED LATIN SMALL LETTER D
  {0xA8D1, 0x24D4}, //6982 #CIRCLED LATIN SMALL LETTER E
  {0xA8D2, 0x24D5}, //6983 #CIRCLED LATIN SMALL LETTER F
  {0xA8D3, 0x24D6}, //6984 #CIRCLED LATIN SMALL LETTER G
  {0xA8D4, 0x24D7}, //6985 #CIRCLED LATIN SMALL LETTER H
  {0xA8D5, 0x24D8}, //6986 #CIRCLED LATIN SMALL LETTER I
  {0xA8D6, 0x24D9}, //6987 #CIRCLED LATIN SMALL LETTER J
  {0xA8D7, 0x24DA}, //6988 #CIRCLED LATIN SMALL LETTER K
  {0xA8D8, 0x24DB}, //6989 #CIRCLED LATIN SMALL LETTER L
  {0xA8D9, 0x24DC}, //6990 #CIRCLED LATIN SMALL LETTER M
  {0xA8DA, 0x24DD}, //6991 #CIRCLED LATIN SMALL LETTER N
  {0xA8DB, 0x24DE}, //6992 #CIRCLED LATIN SMALL LETTER O
  {0xA8DC, 0x24DF}, //6993 #CIRCLED LATIN SMALL LETTER P
  {0xA8DD, 0x24E0}, //6994 #CIRCLED LATIN SMALL LETTER Q
  {0xA8DE, 0x24E1}, //6995 #CIRCLED LATIN SMALL LETTER R
  {0xA8DF, 0x24E2}, //6996 #CIRCLED LATIN SMALL LETTER S
  {0xA8E0, 0x24E3}, //6997 #CIRCLED LATIN SMALL LETTER T
  {0xA8E1, 0x24E4}, //6998 #CIRCLED LATIN SMALL LETTER U
  {0xA8E2, 0x24E5}, //6999 #CIRCLED LATIN SMALL LETTER V
  {0xA8E3, 0x24E6}, //7000 #CIRCLED LATIN SMALL LETTER W
  {0xA8E4, 0x24E7}, //7001 #CIRCLED LATIN SMALL LETTER X
  {0xA8E5, 0x24E8}, //7002 #CIRCLED LATIN SMALL LETTER Y
  {0xA8E6, 0x24E9}, //7003 #CIRCLED LATIN SMALL LETTER Z
  {0xA8E7, 0x2460}, //7004 #CIRCLED DIGIT ONE
  {0xA8E8, 0x2461}, //7005 #CIRCLED DIGIT TWO
  {0xA8E9, 0x2462}, //7006 #CIRCLED DIGIT THREE
  {0xA8EA, 0x2463}, //7007 #CIRCLED DIGIT FOUR
  {0xA8EB, 0x2464}, //7008 #CIRCLED DIGIT FIVE
  {0xA8EC, 0x2465}, //7009 #CIRCLED DIGIT SIX
  {0xA8ED, 0x2466}, //7010 #CIRCLED DIGIT SEVEN
  {0xA8EE, 0x2467}, //7011 #CIRCLED DIGIT EIGHT
  {0xA8EF, 0x2468}, //7012 #CIRCLED DIGIT NINE
  {0xA8F0, 0x2469}, //7013 #CIRCLED NUMBER TEN
  {0xA8F1, 0x246A}, //7014 #CIRCLED NUMBER ELEVEN
  {0xA8F2, 0x246B}, //7015 #CIRCLED NUMBER TWELVE
  {0xA8F3, 0x246C}, //7016 #CIRCLED NUMBER THIRTEEN
  {0xA8F4, 0x246D}, //7017 #CIRCLED NUMBER FOURTEEN
  {0xA8F5, 0x246E}, //7018 #CIRCLED NUMBER FIFTEEN
  {0xA8F6, 0x00BD}, //7019 #VULGAR FRACTION ONE HALF
  {0xA8F7, 0x2153}, //7020 #VULGAR FRACTION ONE THIRD
  {0xA8F8, 0x2154}, //7021 #VULGAR FRACTION TWO THIRDS
  {0xA8F9, 0x00BC}, //7022 #VULGAR FRACTION ONE QUARTER
  {0xA8FA, 0x00BE}, //7023 #VULGAR FRACTION THREE QUARTERS
  {0xA8FB, 0x215B}, //7024 #VULGAR FRACTION ONE EIGHTH
  {0xA8FC, 0x215C}, //7025 #VULGAR FRACTION THREE EIGHTHS
  {0xA8FD, 0x215D}, //7026 #VULGAR FRACTION FIVE EIGHTHS
  {0xA8FE, 0x215E}, //7027 #VULGAR FRACTION SEVEN EIGHTHS
  {0xA941, 0xCBC5}, //7028 #HANGUL SYLLABLE SSANGCIEUC YU RIEULTHIEUTH
  {0xA942, 0xCBC6}, //7029 #HANGUL SYLLABLE SSANGCIEUC YU RIEULPHIEUPH
  {0xA943, 0xCBC7}, //7030 #HANGUL SYLLABLE SSANGCIEUC YU RIEULHIEUH
  {0xA944, 0xCBC8}, //7031 #HANGUL SYLLABLE SSANGCIEUC YU MIEUM
  {0xA945, 0xCBC9}, //7032 #HANGUL SYLLABLE SSANGCIEUC YU PIEUP
  {0xA946, 0xCBCA}, //7033 #HANGUL SYLLABLE SSANGCIEUC YU PIEUPSIOS
  {0xA947, 0xCBCB}, //7034 #HANGUL SYLLABLE SSANGCIEUC YU SIOS
  {0xA948, 0xCBCC}, //7035 #HANGUL SYLLABLE SSANGCIEUC YU SSANGSIOS
  {0xA949, 0xCBCD}, //7036 #HANGUL SYLLABLE SSANGCIEUC YU IEUNG
  {0xA94A, 0xCBCE}, //7037 #HANGUL SYLLABLE SSANGCIEUC YU CIEUC
  {0xA94B, 0xCBCF}, //7038 #HANGUL SYLLABLE SSANGCIEUC YU CHIEUCH
  {0xA94C, 0xCBD0}, //7039 #HANGUL SYLLABLE SSANGCIEUC YU KHIEUKH
  {0xA94D, 0xCBD1}, //7040 #HANGUL SYLLABLE SSANGCIEUC YU THIEUTH
  {0xA94E, 0xCBD2}, //7041 #HANGUL SYLLABLE SSANGCIEUC YU PHIEUPH
  {0xA94F, 0xCBD3}, //7042 #HANGUL SYLLABLE SSANGCIEUC YU HIEUH
  {0xA950, 0xCBD5}, //7043 #HANGUL SYLLABLE SSANGCIEUC EU KIYEOK
  {0xA951, 0xCBD6}, //7044 #HANGUL SYLLABLE SSANGCIEUC EU SSANGKIYEOK
  {0xA952, 0xCBD7}, //7045 #HANGUL SYLLABLE SSANGCIEUC EU KIYEOKSIOS
  {0xA953, 0xCBD8}, //7046 #HANGUL SYLLABLE SSANGCIEUC EU NIEUN
  {0xA954, 0xCBD9}, //7047 #HANGUL SYLLABLE SSANGCIEUC EU NIEUNCIEUC
  {0xA955, 0xCBDA}, //7048 #HANGUL SYLLABLE SSANGCIEUC EU NIEUNHIEUH
  {0xA956, 0xCBDB}, //7049 #HANGUL SYLLABLE SSANGCIEUC EU TIKEUT
  {0xA957, 0xCBDC}, //7050 #HANGUL SYLLABLE SSANGCIEUC EU RIEUL
  {0xA958, 0xCBDD}, //7051 #HANGUL SYLLABLE SSANGCIEUC EU RIEULKIYEOK
  {0xA959, 0xCBDE}, //7052 #HANGUL SYLLABLE SSANGCIEUC EU RIEULMIEUM
  {0xA95A, 0xCBDF}, //7053 #HANGUL SYLLABLE SSANGCIEUC EU RIEULPIEUP
  {0xA961, 0xCBE0}, //7054 #HANGUL SYLLABLE SSANGCIEUC EU RIEULSIOS
  {0xA962, 0xCBE1}, //7055 #HANGUL SYLLABLE SSANGCIEUC EU RIEULTHIEUTH
  {0xA963, 0xCBE2}, //7056 #HANGUL SYLLABLE SSANGCIEUC EU RIEULPHIEUPH
  {0xA964, 0xCBE3}, //7057 #HANGUL SYLLABLE SSANGCIEUC EU RIEULHIEUH
  {0xA965, 0xCBE5}, //7058 #HANGUL SYLLABLE SSANGCIEUC EU PIEUP
  {0xA966, 0xCBE6}, //7059 #HANGUL SYLLABLE SSANGCIEUC EU PIEUPSIOS
  {0xA967, 0xCBE8}, //7060 #HANGUL SYLLABLE SSANGCIEUC EU SSANGSIOS
  {0xA968, 0xCBEA}, //7061 #HANGUL SYLLABLE SSANGCIEUC EU CIEUC
  {0xA969, 0xCBEB}, //7062 #HANGUL SYLLABLE SSANGCIEUC EU CHIEUCH
  {0xA96A, 0xCBEC}, //7063 #HANGUL SYLLABLE SSANGCIEUC EU KHIEUKH
  {0xA96B, 0xCBED}, //7064 #HANGUL SYLLABLE SSANGCIEUC EU THIEUTH
  {0xA96C, 0xCBEE}, //7065 #HANGUL SYLLABLE SSANGCIEUC EU PHIEUPH
  {0xA96D, 0xCBEF}, //7066 #HANGUL SYLLABLE SSANGCIEUC EU HIEUH
  {0xA96E, 0xCBF0}, //7067 #HANGUL SYLLABLE SSANGCIEUC YI
  {0xA96F, 0xCBF1}, //7068 #HANGUL SYLLABLE SSANGCIEUC YI KIYEOK
  {0xA970, 0xCBF2}, //7069 #HANGUL SYLLABLE SSANGCIEUC YI SSANGKIYEOK
  {0xA971, 0xCBF3}, //7070 #HANGUL SYLLABLE SSANGCIEUC YI KIYEOKSIOS
  {0xA972, 0xCBF4}, //7071 #HANGUL SYLLABLE SSANGCIEUC YI NIEUN
  {0xA973, 0xCBF5}, //7072 #HANGUL SYLLABLE SSANGCIEUC YI NIEUNCIEUC
  {0xA974, 0xCBF6}, //7073 #HANGUL SYLLABLE SSANGCIEUC YI NIEUNHIEUH
  {0xA975, 0xCBF7}, //7074 #HANGUL SYLLABLE SSANGCIEUC YI TIKEUT
  {0xA976, 0xCBF8}, //7075 #HANGUL SYLLABLE SSANGCIEUC YI RIEUL
  {0xA977, 0xCBF9}, //7076 #HANGUL SYLLABLE SSANGCIEUC YI RIEULKIYEOK
  {0xA978, 0xCBFA}, //7077 #HANGUL SYLLABLE SSANGCIEUC YI RIEULMIEUM
  {0xA979, 0xCBFB}, //7078 #HANGUL SYLLABLE SSANGCIEUC YI RIEULPIEUP
  {0xA97A, 0xCBFC}, //7079 #HANGUL SYLLABLE SSANGCIEUC YI RIEULSIOS
  {0xA981, 0xCBFD}, //7080 #HANGUL SYLLABLE SSANGCIEUC YI RIEULTHIEUTH
  {0xA982, 0xCBFE}, //7081 #HANGUL SYLLABLE SSANGCIEUC YI RIEULPHIEUPH
  {0xA983, 0xCBFF}, //7082 #HANGUL SYLLABLE SSANGCIEUC YI RIEULHIEUH
  {0xA984, 0xCC00}, //7083 #HANGUL SYLLABLE SSANGCIEUC YI MIEUM
  {0xA985, 0xCC01}, //7084 #HANGUL SYLLABLE SSANGCIEUC YI PIEUP
  {0xA986, 0xCC02}, //7085 #HANGUL SYLLABLE SSANGCIEUC YI PIEUPSIOS
  {0xA987, 0xCC03}, //7086 #HANGUL SYLLABLE SSANGCIEUC YI SIOS
  {0xA988, 0xCC04}, //7087 #HANGUL SYLLABLE SSANGCIEUC YI SSANGSIOS
  {0xA989, 0xCC05}, //7088 #HANGUL SYLLABLE SSANGCIEUC YI IEUNG
  {0xA98A, 0xCC06}, //7089 #HANGUL SYLLABLE SSANGCIEUC YI CIEUC
  {0xA98B, 0xCC07}, //7090 #HANGUL SYLLABLE SSANGCIEUC YI CHIEUCH
  {0xA98C, 0xCC08}, //7091 #HANGUL SYLLABLE SSANGCIEUC YI KHIEUKH
  {0xA98D, 0xCC09}, //7092 #HANGUL SYLLABLE SSANGCIEUC YI THIEUTH
  {0xA98E, 0xCC0A}, //7093 #HANGUL SYLLABLE SSANGCIEUC YI PHIEUPH
  {0xA98F, 0xCC0B}, //7094 #HANGUL SYLLABLE SSANGCIEUC YI HIEUH
  {0xA990, 0xCC0E}, //7095 #HANGUL SYLLABLE SSANGCIEUC I SSANGKIYEOK
  {0xA991, 0xCC0F}, //7096 #HANGUL SYLLABLE SSANGCIEUC I KIYEOKSIOS
  {0xA992, 0xCC11}, //7097 #HANGUL SYLLABLE SSANGCIEUC I NIEUNCIEUC
  {0xA993, 0xCC12}, //7098 #HANGUL SYLLABLE SSANGCIEUC I NIEUNHIEUH
  {0xA994, 0xCC13}, //7099 #HANGUL SYLLABLE SSANGCIEUC I TIKEUT
  {0xA995, 0xCC15}, //7100 #HANGUL SYLLABLE SSANGCIEUC I RIEULKIYEOK
  {0xA996, 0xCC16}, //7101 #HANGUL SYLLABLE SSANGCIEUC I RIEULMIEUM
  {0xA997, 0xCC17}, //7102 #HANGUL SYLLABLE SSANGCIEUC I RIEULPIEUP
  {0xA998, 0xCC18}, //7103 #HANGUL SYLLABLE SSANGCIEUC I RIEULSIOS
  {0xA999, 0xCC19}, //7104 #HANGUL SYLLABLE SSANGCIEUC I RIEULTHIEUTH
  {0xA99A, 0xCC1A}, //7105 #HANGUL SYLLABLE SSANGCIEUC I RIEULPHIEUPH
  {0xA99B, 0xCC1B}, //7106 #HANGUL SYLLABLE SSANGCIEUC I RIEULHIEUH
  {0xA99C, 0xCC1E}, //7107 #HANGUL SYLLABLE SSANGCIEUC I PIEUPSIOS
  {0xA99D, 0xCC1F}, //7108 #HANGUL SYLLABLE SSANGCIEUC I SIOS
  {0xA99E, 0xCC20}, //7109 #HANGUL SYLLABLE SSANGCIEUC I SSANGSIOS
  {0xA99F, 0xCC23}, //7110 #HANGUL SYLLABLE SSANGCIEUC I CHIEUCH
  {0xA9A0, 0xCC24}, //7111 #HANGUL SYLLABLE SSANGCIEUC I KHIEUKH
  {0xA9A1, 0x00E6}, //7112 #LATIN SMALL LETTER AE
  {0xA9A2, 0x0111}, //7113 #LATIN SMALL LETTER D WITH STROKE
  {0xA9A3, 0x00F0}, //7114 #LATIN SMALL LETTER ETH
  {0xA9A4, 0x0127}, //7115 #LATIN SMALL LETTER H WITH STROKE
  {0xA9A5, 0x0131}, //7116 #LATIN SMALL LETTER DOTLESS I
  {0xA9A6, 0x0133}, //7117 #LATIN SMALL LIGATURE IJ
  {0xA9A7, 0x0138}, //7118 #LATIN SMALL LETTER KRA
  {0xA9A8, 0x0140}, //7119 #LATIN SMALL LETTER L WITH MIDDLE DOT
  {0xA9A9, 0x0142}, //7120 #LATIN SMALL LETTER L WITH STROKE
  {0xA9AA, 0x00F8}, //7121 #LATIN SMALL LETTER O WITH STROKE
  {0xA9AB, 0x0153}, //7122 #LATIN SMALL LIGATURE OE
  {0xA9AC, 0x00DF}, //7123 #LATIN SMALL LETTER SHARP S
  {0xA9AD, 0x00FE}, //7124 #LATIN SMALL LETTER THORN
  {0xA9AE, 0x0167}, //7125 #LATIN SMALL LETTER T WITH STROKE
  {0xA9AF, 0x014B}, //7126 #LATIN SMALL LETTER ENG
  {0xA9B0, 0x0149}, //7127 #LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
  {0xA9B1, 0x3200}, //7128 #PARENTHESIZED HANGUL KIYEOK
  {0xA9B2, 0x3201}, //7129 #PARENTHESIZED HANGUL NIEUN
  {0xA9B3, 0x3202}, //7130 #PARENTHESIZED HANGUL TIKEUT
  {0xA9B4, 0x3203}, //7131 #PARENTHESIZED HANGUL RIEUL
  {0xA9B5, 0x3204}, //7132 #PARENTHESIZED HANGUL MIEUM
  {0xA9B6, 0x3205}, //7133 #PARENTHESIZED HANGUL PIEUP
  {0xA9B7, 0x3206}, //7134 #PARENTHESIZED HANGUL SIOS
  {0xA9B8, 0x3207}, //7135 #PARENTHESIZED HANGUL IEUNG
  {0xA9B9, 0x3208}, //7136 #PARENTHESIZED HANGUL CIEUC
  {0xA9BA, 0x3209}, //7137 #PARENTHESIZED HANGUL CHIEUCH
  {0xA9BB, 0x320A}, //7138 #PARENTHESIZED HANGUL KHIEUKH
  {0xA9BC, 0x320B}, //7139 #PARENTHESIZED HANGUL THIEUTH
  {0xA9BD, 0x320C}, //7140 #PARENTHESIZED HANGUL PHIEUPH
  {0xA9BE, 0x320D}, //7141 #PARENTHESIZED HANGUL HIEUH
  {0xA9BF, 0x320E}, //7142 #PARENTHESIZED HANGUL KIYEOK A
  {0xA9C0, 0x320F}, //7143 #PARENTHESIZED HANGUL NIEUN A
  {0xA9C1, 0x3210}, //7144 #PARENTHESIZED HANGUL TIKEUT A
  {0xA9C2, 0x3211}, //7145 #PARENTHESIZED HANGUL RIEUL A
  {0xA9C3, 0x3212}, //7146 #PARENTHESIZED HANGUL MIEUM A
  {0xA9C4, 0x3213}, //7147 #PARENTHESIZED HANGUL PIEUP A
  {0xA9C5, 0x3214}, //7148 #PARENTHESIZED HANGUL SIOS A
  {0xA9C6, 0x3215}, //7149 #PARENTHESIZED HANGUL IEUNG A
  {0xA9C7, 0x3216}, //7150 #PARENTHESIZED HANGUL CIEUC A
  {0xA9C8, 0x3217}, //7151 #PARENTHESIZED HANGUL CHIEUCH A
  {0xA9C9, 0x3218}, //7152 #PARENTHESIZED HANGUL KHIEUKH A
  {0xA9CA, 0x3219}, //7153 #PARENTHESIZED HANGUL THIEUTH A
  {0xA9CB, 0x321A}, //7154 #PARENTHESIZED HANGUL PHIEUPH A
  {0xA9CC, 0x321B}, //7155 #PARENTHESIZED HANGUL HIEUH A
  {0xA9CD, 0x249C}, //7156 #PARENTHESIZED LATIN SMALL LETTER A
  {0xA9CE, 0x249D}, //7157 #PARENTHESIZED LATIN SMALL LETTER B
  {0xA9CF, 0x249E}, //7158 #PARENTHESIZED LATIN SMALL LETTER C
  {0xA9D0, 0x249F}, //7159 #PARENTHESIZED LATIN SMALL LETTER D
  {0xA9D1, 0x24A0}, //7160 #PARENTHESIZED LATIN SMALL LETTER E
  {0xA9D2, 0x24A1}, //7161 #PARENTHESIZED LATIN SMALL LETTER F
  {0xA9D3, 0x24A2}, //7162 #PARENTHESIZED LATIN SMALL LETTER G
  {0xA9D4, 0x24A3}, //7163 #PARENTHESIZED LATIN SMALL LETTER H
  {0xA9D5, 0x24A4}, //7164 #PARENTHESIZED LATIN SMALL LETTER I
  {0xA9D6, 0x24A5}, //7165 #PARENTHESIZED LATIN SMALL LETTER J
  {0xA9D7, 0x24A6}, //7166 #PARENTHESIZED LATIN SMALL LETTER K
  {0xA9D8, 0x24A7}, //7167 #PARENTHESIZED LATIN SMALL LETTER L
  {0xA9D9, 0x24A8}, //7168 #PARENTHESIZED LATIN SMALL LETTER M
  {0xA9DA, 0x24A9}, //7169 #PARENTHESIZED LATIN SMALL LETTER N
  {0xA9DB, 0x24AA}, //7170 #PARENTHESIZED LATIN SMALL LETTER O
  {0xA9DC, 0x24AB}, //7171 #PARENTHESIZED LATIN SMALL LETTER P
  {0xA9DD, 0x24AC}, //7172 #PARENTHESIZED LATIN SMALL LETTER Q
  {0xA9DE, 0x24AD}, //7173 #PARENTHESIZED LATIN SMALL LETTER R
  {0xA9DF, 0x24AE}, //7174 #PARENTHESIZED LATIN SMALL LETTER S
  {0xA9E0, 0x24AF}, //7175 #PARENTHESIZED LATIN SMALL LETTER T
  {0xA9E1, 0x24B0}, //7176 #PARENTHESIZED LATIN SMALL LETTER U
  {0xA9E2, 0x24B1}, //7177 #PARENTHESIZED LATIN SMALL LETTER V
  {0xA9E3, 0x24B2}, //7178 #PARENTHESIZED LATIN SMALL LETTER W
  {0xA9E4, 0x24B3}, //7179 #PARENTHESIZED LATIN SMALL LETTER X
  {0xA9E5, 0x24B4}, //7180 #PARENTHESIZED LATIN SMALL LETTER Y
  {0xA9E6, 0x24B5}, //7181 #PARENTHESIZED LATIN SMALL LETTER Z
  {0xA9E7, 0x2474}, //7182 #PARENTHESIZED DIGIT ONE
  {0xA9E8, 0x2475}, //7183 #PARENTHESIZED DIGIT TWO
  {0xA9E9, 0x2476}, //7184 #PARENTHESIZED DIGIT THREE
  {0xA9EA, 0x2477}, //7185 #PARENTHESIZED DIGIT FOUR
  {0xA9EB, 0x2478}, //7186 #PARENTHESIZED DIGIT FIVE
  {0xA9EC, 0x2479}, //7187 #PARENTHESIZED DIGIT SIX
  {0xA9ED, 0x247A}, //7188 #PARENTHESIZED DIGIT SEVEN
  {0xA9EE, 0x247B}, //7189 #PARENTHESIZED DIGIT EIGHT
  {0xA9EF, 0x247C}, //7190 #PARENTHESIZED DIGIT NINE
  {0xA9F0, 0x247D}, //7191 #PARENTHESIZED NUMBER TEN
  {0xA9F1, 0x247E}, //7192 #PARENTHESIZED NUMBER ELEVEN
  {0xA9F2, 0x247F}, //7193 #PARENTHESIZED NUMBER TWELVE
  {0xA9F3, 0x2480}, //7194 #PARENTHESIZED NUMBER THIRTEEN
  {0xA9F4, 0x2481}, //7195 #PARENTHESIZED NUMBER FOURTEEN
  {0xA9F5, 0x2482}, //7196 #PARENTHESIZED NUMBER FIFTEEN
  {0xA9F6, 0x00B9}, //7197 #SUPERSCRIPT ONE
  {0xA9F7, 0x00B2}, //7198 #SUPERSCRIPT TWO
  {0xA9F8, 0x00B3}, //7199 #SUPERSCRIPT THREE
  {0xA9F9, 0x2074}, //7200 #SUPERSCRIPT FOUR
  {0xA9FA, 0x207F}, //7201 #SUPERSCRIPT LATIN SMALL LETTER N
  {0xA9FB, 0x2081}, //7202 #SUBSCRIPT ONE
  {0xA9FC, 0x2082}, //7203 #SUBSCRIPT TWO
  {0xA9FD, 0x2083}, //7204 #SUBSCRIPT THREE
  {0xA9FE, 0x2084}, //7205 #SUBSCRIPT FOUR
  {0xAA41, 0xCC25}, //7206 #HANGUL SYLLABLE SSANGCIEUC I THIEUTH
  {0xAA42, 0xCC26}, //7207 #HANGUL SYLLABLE SSANGCIEUC I PHIEUPH
  {0xAA43, 0xCC2A}, //7208 #HANGUL SYLLABLE CHIEUCH A SSANGKIYEOK
  {0xAA44, 0xCC2B}, //7209 #HANGUL SYLLABLE CHIEUCH A KIYEOKSIOS
  {0xAA45, 0xCC2D}, //7210 #HANGUL SYLLABLE CHIEUCH A NIEUNCIEUC
  {0xAA46, 0xCC2F}, //7211 #HANGUL SYLLABLE CHIEUCH A TIKEUT
  {0xAA47, 0xCC31}, //7212 #HANGUL SYLLABLE CHIEUCH A RIEULKIYEOK
  {0xAA48, 0xCC32}, //7213 #HANGUL SYLLABLE CHIEUCH A RIEULMIEUM
  {0xAA49, 0xCC33}, //7214 #HANGUL SYLLABLE CHIEUCH A RIEULPIEUP
  {0xAA4A, 0xCC34}, //7215 #HANGUL SYLLABLE CHIEUCH A RIEULSIOS
  {0xAA4B, 0xCC35}, //7216 #HANGUL SYLLABLE CHIEUCH A RIEULTHIEUTH
  {0xAA4C, 0xCC36}, //7217 #HANGUL SYLLABLE CHIEUCH A RIEULPHIEUPH
  {0xAA4D, 0xCC37}, //7218 #HANGUL SYLLABLE CHIEUCH A RIEULHIEUH
  {0xAA4E, 0xCC3A}, //7219 #HANGUL SYLLABLE CHIEUCH A PIEUPSIOS
  {0xAA4F, 0xCC3F}, //7220 #HANGUL SYLLABLE CHIEUCH A CHIEUCH
  {0xAA50, 0xCC40}, //7221 #HANGUL SYLLABLE CHIEUCH A KHIEUKH
  {0xAA51, 0xCC41}, //7222 #HANGUL SYLLABLE CHIEUCH A THIEUTH
  {0xAA52, 0xCC42}, //7223 #HANGUL SYLLABLE CHIEUCH A PHIEUPH
  {0xAA53, 0xCC43}, //7224 #HANGUL SYLLABLE CHIEUCH A HIEUH
  {0xAA54, 0xCC46}, //7225 #HANGUL SYLLABLE CHIEUCH AE SSANGKIYEOK
  {0xAA55, 0xCC47}, //7226 #HANGUL SYLLABLE CHIEUCH AE KIYEOKSIOS
  {0xAA56, 0xCC49}, //7227 #HANGUL SYLLABLE CHIEUCH AE NIEUNCIEUC
  {0xAA57, 0xCC4A}, //7228 #HANGUL SYLLABLE CHIEUCH AE NIEUNHIEUH
  {0xAA58, 0xCC4B}, //7229 #HANGUL SYLLABLE CHIEUCH AE TIKEUT
  {0xAA59, 0xCC4D}, //7230 #HANGUL SYLLABLE CHIEUCH AE RIEULKIYEOK
  {0xAA5A, 0xCC4E}, //7231 #HANGUL SYLLABLE CHIEUCH AE RIEULMIEUM
  {0xAA61, 0xCC4F}, //7232 #HANGUL SYLLABLE CHIEUCH AE RIEULPIEUP
  {0xAA62, 0xCC50}, //7233 #HANGUL SYLLABLE CHIEUCH AE RIEULSIOS
  {0xAA63, 0xCC51}, //7234 #HANGUL SYLLABLE CHIEUCH AE RIEULTHIEUTH
  {0xAA64, 0xCC52}, //7235 #HANGUL SYLLABLE CHIEUCH AE RIEULPHIEUPH
  {0xAA65, 0xCC53}, //7236 #HANGUL SYLLABLE CHIEUCH AE RIEULHIEUH
  {0xAA66, 0xCC56}, //7237 #HANGUL SYLLABLE CHIEUCH AE PIEUPSIOS
  {0xAA67, 0xCC5A}, //7238 #HANGUL SYLLABLE CHIEUCH AE CIEUC
  {0xAA68, 0xCC5B}, //7239 #HANGUL SYLLABLE CHIEUCH AE CHIEUCH
  {0xAA69, 0xCC5C}, //7240 #HANGUL SYLLABLE CHIEUCH AE KHIEUKH
  {0xAA6A, 0xCC5D}, //7241 #HANGUL SYLLABLE CHIEUCH AE THIEUTH
  {0xAA6B, 0xCC5E}, //7242 #HANGUL SYLLABLE CHIEUCH AE PHIEUPH
  {0xAA6C, 0xCC5F}, //7243 #HANGUL SYLLABLE CHIEUCH AE HIEUH
  {0xAA6D, 0xCC61}, //7244 #HANGUL SYLLABLE CHIEUCH YA KIYEOK
  {0xAA6E, 0xCC62}, //7245 #HANGUL SYLLABLE CHIEUCH YA SSANGKIYEOK
  {0xAA6F, 0xCC63}, //7246 #HANGUL SYLLABLE CHIEUCH YA KIYEOKSIOS
  {0xAA70, 0xCC65}, //7247 #HANGUL SYLLABLE CHIEUCH YA NIEUNCIEUC
  {0xAA71, 0xCC67}, //7248 #HANGUL SYLLABLE CHIEUCH YA TIKEUT
  {0xAA72, 0xCC69}, //7249 #HANGUL SYLLABLE CHIEUCH YA RIEULKIYEOK
  {0xAA73, 0xCC6A}, //7250 #HANGUL SYLLABLE CHIEUCH YA RIEULMIEUM
  {0xAA74, 0xCC6B}, //7251 #HANGUL SYLLABLE CHIEUCH YA RIEULPIEUP
  {0xAA75, 0xCC6C}, //7252 #HANGUL SYLLABLE CHIEUCH YA RIEULSIOS
  {0xAA76, 0xCC6D}, //7253 #HANGUL SYLLABLE CHIEUCH YA RIEULTHIEUTH
  {0xAA77, 0xCC6E}, //7254 #HANGUL SYLLABLE CHIEUCH YA RIEULPHIEUPH
  {0xAA78, 0xCC6F}, //7255 #HANGUL SYLLABLE CHIEUCH YA RIEULHIEUH
  {0xAA79, 0xCC71}, //7256 #HANGUL SYLLABLE CHIEUCH YA PIEUP
  {0xAA7A, 0xCC72}, //7257 #HANGUL SYLLABLE CHIEUCH YA PIEUPSIOS
  {0xAA81, 0xCC73}, //7258 #HANGUL SYLLABLE CHIEUCH YA SIOS
  {0xAA82, 0xCC74}, //7259 #HANGUL SYLLABLE CHIEUCH YA SSANGSIOS
  {0xAA83, 0xCC76}, //7260 #HANGUL SYLLABLE CHIEUCH YA CIEUC
  {0xAA84, 0xCC77}, //7261 #HANGUL SYLLABLE CHIEUCH YA CHIEUCH
  {0xAA85, 0xCC78}, //7262 #HANGUL SYLLABLE CHIEUCH YA KHIEUKH
  {0xAA86, 0xCC79}, //7263 #HANGUL SYLLABLE CHIEUCH YA THIEUTH
  {0xAA87, 0xCC7A}, //7264 #HANGUL SYLLABLE CHIEUCH YA PHIEUPH
  {0xAA88, 0xCC7B}, //7265 #HANGUL SYLLABLE CHIEUCH YA HIEUH
  {0xAA89, 0xCC7C}, //7266 #HANGUL SYLLABLE CHIEUCH YAE
  {0xAA8A, 0xCC7D}, //7267 #HANGUL SYLLABLE CHIEUCH YAE KIYEOK
  {0xAA8B, 0xCC7E}, //7268 #HANGUL SYLLABLE CHIEUCH YAE SSANGKIYEOK
  {0xAA8C, 0xCC7F}, //7269 #HANGUL SYLLABLE CHIEUCH YAE KIYEOKSIOS
  {0xAA8D, 0xCC80}, //7270 #HANGUL SYLLABLE CHIEUCH YAE NIEUN
  {0xAA8E, 0xCC81}, //7271 #HANGUL SYLLABLE CHIEUCH YAE NIEUNCIEUC
  {0xAA8F, 0xCC82}, //7272 #HANGUL SYLLABLE CHIEUCH YAE NIEUNHIEUH
  {0xAA90, 0xCC83}, //7273 #HANGUL SYLLABLE CHIEUCH YAE TIKEUT
  {0xAA91, 0xCC84}, //7274 #HANGUL SYLLABLE CHIEUCH YAE RIEUL
  {0xAA92, 0xCC85}, //7275 #HANGUL SYLLABLE CHIEUCH YAE RIEULKIYEOK
  {0xAA93, 0xCC86}, //7276 #HANGUL SYLLABLE CHIEUCH YAE RIEULMIEUM
  {0xAA94, 0xCC87}, //7277 #HANGUL SYLLABLE CHIEUCH YAE RIEULPIEUP
  {0xAA95, 0xCC88}, //7278 #HANGUL SYLLABLE CHIEUCH YAE RIEULSIOS
  {0xAA96, 0xCC89}, //7279 #HANGUL SYLLABLE CHIEUCH YAE RIEULTHIEUTH
  {0xAA97, 0xCC8A}, //7280 #HANGUL SYLLABLE CHIEUCH YAE RIEULPHIEUPH
  {0xAA98, 0xCC8B}, //7281 #HANGUL SYLLABLE CHIEUCH YAE RIEULHIEUH
  {0xAA99, 0xCC8C}, //7282 #HANGUL SYLLABLE CHIEUCH YAE MIEUM
  {0xAA9A, 0xCC8D}, //7283 #HANGUL SYLLABLE CHIEUCH YAE PIEUP
  {0xAA9B, 0xCC8E}, //7284 #HANGUL SYLLABLE CHIEUCH YAE PIEUPSIOS
  {0xAA9C, 0xCC8F}, //7285 #HANGUL SYLLABLE CHIEUCH YAE SIOS
  {0xAA9D, 0xCC90}, //7286 #HANGUL SYLLABLE CHIEUCH YAE SSANGSIOS
  {0xAA9E, 0xCC91}, //7287 #HANGUL SYLLABLE CHIEUCH YAE IEUNG
  {0xAA9F, 0xCC92}, //7288 #HANGUL SYLLABLE CHIEUCH YAE CIEUC
  {0xAAA0, 0xCC93}, //7289 #HANGUL SYLLABLE CHIEUCH YAE CHIEUCH
  {0xAAA1, 0x3041}, //7290 #HIRAGANA LETTER SMALL A
  {0xAAA2, 0x3042}, //7291 #HIRAGANA LETTER A
  {0xAAA3, 0x3043}, //7292 #HIRAGANA LETTER SMALL I
  {0xAAA4, 0x3044}, //7293 #HIRAGANA LETTER I
  {0xAAA5, 0x3045}, //7294 #HIRAGANA LETTER SMALL U
  {0xAAA6, 0x3046}, //7295 #HIRAGANA LETTER U
  {0xAAA7, 0x3047}, //7296 #HIRAGANA LETTER SMALL E
  {0xAAA8, 0x3048}, //7297 #HIRAGANA LETTER E
  {0xAAA9, 0x3049}, //7298 #HIRAGANA LETTER SMALL O
  {0xAAAA, 0x304A}, //7299 #HIRAGANA LETTER O
  {0xAAAB, 0x304B}, //7300 #HIRAGANA LETTER KA
  {0xAAAC, 0x304C}, //7301 #HIRAGANA LETTER GA
  {0xAAAD, 0x304D}, //7302 #HIRAGANA LETTER KI
  {0xAAAE, 0x304E}, //7303 #HIRAGANA LETTER GI
  {0xAAAF, 0x304F}, //7304 #HIRAGANA LETTER KU
  {0xAAB0, 0x3050}, //7305 #HIRAGANA LETTER GU
  {0xAAB1, 0x3051}, //7306 #HIRAGANA LETTER KE
  {0xAAB2, 0x3052}, //7307 #HIRAGANA LETTER GE
  {0xAAB3, 0x3053}, //7308 #HIRAGANA LETTER KO
  {0xAAB4, 0x3054}, //7309 #HIRAGANA LETTER GO
  {0xAAB5, 0x3055}, //7310 #HIRAGANA LETTER SA
  {0xAAB6, 0x3056}, //7311 #HIRAGANA LETTER ZA
  {0xAAB7, 0x3057}, //7312 #HIRAGANA LETTER SI
  {0xAAB8, 0x3058}, //7313 #HIRAGANA LETTER ZI
  {0xAAB9, 0x3059}, //7314 #HIRAGANA LETTER SU
  {0xAABA, 0x305A}, //7315 #HIRAGANA LETTER ZU
  {0xAABB, 0x305B}, //7316 #HIRAGANA LETTER SE
  {0xAABC, 0x305C}, //7317 #HIRAGANA LETTER ZE
  {0xAABD, 0x305D}, //7318 #HIRAGANA LETTER SO
  {0xAABE, 0x305E}, //7319 #HIRAGANA LETTER ZO
  {0xAABF, 0x305F}, //7320 #HIRAGANA LETTER TA
  {0xAAC0, 0x3060}, //7321 #HIRAGANA LETTER DA
  {0xAAC1, 0x3061}, //7322 #HIRAGANA LETTER TI
  {0xAAC2, 0x3062}, //7323 #HIRAGANA LETTER DI
  {0xAAC3, 0x3063}, //7324 #HIRAGANA LETTER SMALL TU
  {0xAAC4, 0x3064}, //7325 #HIRAGANA LETTER TU
  {0xAAC5, 0x3065}, //7326 #HIRAGANA LETTER DU
  {0xAAC6, 0x3066}, //7327 #HIRAGANA LETTER TE
  {0xAAC7, 0x3067}, //7328 #HIRAGANA LETTER DE
  {0xAAC8, 0x3068}, //7329 #HIRAGANA LETTER TO
  {0xAAC9, 0x3069}, //7330 #HIRAGANA LETTER DO
  {0xAACA, 0x306A}, //7331 #HIRAGANA LETTER NA
  {0xAACB, 0x306B}, //7332 #HIRAGANA LETTER NI
  {0xAACC, 0x306C}, //7333 #HIRAGANA LETTER NU
  {0xAACD, 0x306D}, //7334 #HIRAGANA LETTER NE
  {0xAACE, 0x306E}, //7335 #HIRAGANA LETTER NO
  {0xAACF, 0x306F}, //7336 #HIRAGANA LETTER HA
  {0xAAD0, 0x3070}, //7337 #HIRAGANA LETTER BA
  {0xAAD1, 0x3071}, //7338 #HIRAGANA LETTER PA
  {0xAAD2, 0x3072}, //7339 #HIRAGANA LETTER HI
  {0xAAD3, 0x3073}, //7340 #HIRAGANA LETTER BI
  {0xAAD4, 0x3074}, //7341 #HIRAGANA LETTER PI
  {0xAAD5, 0x3075}, //7342 #HIRAGANA LETTER HU
  {0xAAD6, 0x3076}, //7343 #HIRAGANA LETTER BU
  {0xAAD7, 0x3077}, //7344 #HIRAGANA LETTER PU
  {0xAAD8, 0x3078}, //7345 #HIRAGANA LETTER HE
  {0xAAD9, 0x3079}, //7346 #HIRAGANA LETTER BE
  {0xAADA, 0x307A}, //7347 #HIRAGANA LETTER PE
  {0xAADB, 0x307B}, //7348 #HIRAGANA LETTER HO
  {0xAADC, 0x307C}, //7349 #HIRAGANA LETTER BO
  {0xAADD, 0x307D}, //7350 #HIRAGANA LETTER PO
  {0xAADE, 0x307E}, //7351 #HIRAGANA LETTER MA
  {0xAADF, 0x307F}, //7352 #HIRAGANA LETTER MI
  {0xAAE0, 0x3080}, //7353 #HIRAGANA LETTER MU
  {0xAAE1, 0x3081}, //7354 #HIRAGANA LETTER ME
  {0xAAE2, 0x3082}, //7355 #HIRAGANA LETTER MO
  {0xAAE3, 0x3083}, //7356 #HIRAGANA LETTER SMALL YA
  {0xAAE4, 0x3084}, //7357 #HIRAGANA LETTER YA
  {0xAAE5, 0x3085}, //7358 #HIRAGANA LETTER SMALL YU
  {0xAAE6, 0x3086}, //7359 #HIRAGANA LETTER YU
  {0xAAE7, 0x3087}, //7360 #HIRAGANA LETTER SMALL YO
  {0xAAE8, 0x3088}, //7361 #HIRAGANA LETTER YO
  {0xAAE9, 0x3089}, //7362 #HIRAGANA LETTER RA
  {0xAAEA, 0x308A}, //7363 #HIRAGANA LETTER RI
  {0xAAEB, 0x308B}, //7364 #HIRAGANA LETTER RU
  {0xAAEC, 0x308C}, //7365 #HIRAGANA LETTER RE
  {0xAAED, 0x308D}, //7366 #HIRAGANA LETTER RO
  {0xAAEE, 0x308E}, //7367 #HIRAGANA LETTER SMALL WA
  {0xAAEF, 0x308F}, //7368 #HIRAGANA LETTER WA
  {0xAAF0, 0x3090}, //7369 #HIRAGANA LETTER WI
  {0xAAF1, 0x3091}, //7370 #HIRAGANA LETTER WE
  {0xAAF2, 0x3092}, //7371 #HIRAGANA LETTER WO
  {0xAAF3, 0x3093}, //7372 #HIRAGANA LETTER N
  {0xAB41, 0xCC94}, //7373 #HANGUL SYLLABLE CHIEUCH YAE KHIEUKH
  {0xAB42, 0xCC95}, //7374 #HANGUL SYLLABLE CHIEUCH YAE THIEUTH
  {0xAB43, 0xCC96}, //7375 #HANGUL SYLLABLE CHIEUCH YAE PHIEUPH
  {0xAB44, 0xCC97}, //7376 #HANGUL SYLLABLE CHIEUCH YAE HIEUH
  {0xAB45, 0xCC9A}, //7377 #HANGUL SYLLABLE CHIEUCH EO SSANGKIYEOK
  {0xAB46, 0xCC9B}, //7378 #HANGUL SYLLABLE CHIEUCH EO KIYEOKSIOS
  {0xAB47, 0xCC9D}, //7379 #HANGUL SYLLABLE CHIEUCH EO NIEUNCIEUC
  {0xAB48, 0xCC9E}, //7380 #HANGUL SYLLABLE CHIEUCH EO NIEUNHIEUH
  {0xAB49, 0xCC9F}, //7381 #HANGUL SYLLABLE CHIEUCH EO TIKEUT
  {0xAB4A, 0xCCA1}, //7382 #HANGUL SYLLABLE CHIEUCH EO RIEULKIYEOK
  {0xAB4B, 0xCCA2}, //7383 #HANGUL SYLLABLE CHIEUCH EO RIEULMIEUM
  {0xAB4C, 0xCCA3}, //7384 #HANGUL SYLLABLE CHIEUCH EO RIEULPIEUP
  {0xAB4D, 0xCCA4}, //7385 #HANGUL SYLLABLE CHIEUCH EO RIEULSIOS
  {0xAB4E, 0xCCA5}, //7386 #HANGUL SYLLABLE CHIEUCH EO RIEULTHIEUTH
  {0xAB4F, 0xCCA6}, //7387 #HANGUL SYLLABLE CHIEUCH EO RIEULPHIEUPH
  {0xAB50, 0xCCA7}, //7388 #HANGUL SYLLABLE CHIEUCH EO RIEULHIEUH
  {0xAB51, 0xCCAA}, //7389 #HANGUL SYLLABLE CHIEUCH EO PIEUPSIOS
  {0xAB52, 0xCCAE}, //7390 #HANGUL SYLLABLE CHIEUCH EO CIEUC
  {0xAB53, 0xCCAF}, //7391 #HANGUL SYLLABLE CHIEUCH EO CHIEUCH
  {0xAB54, 0xCCB0}, //7392 #HANGUL SYLLABLE CHIEUCH EO KHIEUKH
  {0xAB55, 0xCCB1}, //7393 #HANGUL SYLLABLE CHIEUCH EO THIEUTH
  {0xAB56, 0xCCB2}, //7394 #HANGUL SYLLABLE CHIEUCH EO PHIEUPH
  {0xAB57, 0xCCB3}, //7395 #HANGUL SYLLABLE CHIEUCH EO HIEUH
  {0xAB58, 0xCCB6}, //7396 #HANGUL SYLLABLE CHIEUCH E SSANGKIYEOK
  {0xAB59, 0xCCB7}, //7397 #HANGUL SYLLABLE CHIEUCH E KIYEOKSIOS
  {0xAB5A, 0xCCB9}, //7398 #HANGUL SYLLABLE CHIEUCH E NIEUNCIEUC
  {0xAB61, 0xCCBA}, //7399 #HANGUL SYLLABLE CHIEUCH E NIEUNHIEUH
  {0xAB62, 0xCCBB}, //7400 #HANGUL SYLLABLE CHIEUCH E TIKEUT
  {0xAB63, 0xCCBD}, //7401 #HANGUL SYLLABLE CHIEUCH E RIEULKIYEOK
  {0xAB64, 0xCCBE}, //7402 #HANGUL SYLLABLE CHIEUCH E RIEULMIEUM
  {0xAB65, 0xCCBF}, //7403 #HANGUL SYLLABLE CHIEUCH E RIEULPIEUP
  {0xAB66, 0xCCC0}, //7404 #HANGUL SYLLABLE CHIEUCH E RIEULSIOS
  {0xAB67, 0xCCC1}, //7405 #HANGUL SYLLABLE CHIEUCH E RIEULTHIEUTH
  {0xAB68, 0xCCC2}, //7406 #HANGUL SYLLABLE CHIEUCH E RIEULPHIEUPH
  {0xAB69, 0xCCC3}, //7407 #HANGUL SYLLABLE CHIEUCH E RIEULHIEUH
  {0xAB6A, 0xCCC6}, //7408 #HANGUL SYLLABLE CHIEUCH E PIEUPSIOS
  {0xAB6B, 0xCCC8}, //7409 #HANGUL SYLLABLE CHIEUCH E SSANGSIOS
  {0xAB6C, 0xCCCA}, //7410 #HANGUL SYLLABLE CHIEUCH E CIEUC
  {0xAB6D, 0xCCCB}, //7411 #HANGUL SYLLABLE CHIEUCH E CHIEUCH
  {0xAB6E, 0xCCCC}, //7412 #HANGUL SYLLABLE CHIEUCH E KHIEUKH
  {0xAB6F, 0xCCCD}, //7413 #HANGUL SYLLABLE CHIEUCH E THIEUTH
  {0xAB70, 0xCCCE}, //7414 #HANGUL SYLLABLE CHIEUCH E PHIEUPH
  {0xAB71, 0xCCCF}, //7415 #HANGUL SYLLABLE CHIEUCH E HIEUH
  {0xAB72, 0xCCD1}, //7416 #HANGUL SYLLABLE CHIEUCH YEO KIYEOK
  {0xAB73, 0xCCD2}, //7417 #HANGUL SYLLABLE CHIEUCH YEO SSANGKIYEOK
  {0xAB74, 0xCCD3}, //7418 #HANGUL SYLLABLE CHIEUCH YEO KIYEOKSIOS
  {0xAB75, 0xCCD5}, //7419 #HANGUL SYLLABLE CHIEUCH YEO NIEUNCIEUC
  {0xAB76, 0xCCD6}, //7420 #HANGUL SYLLABLE CHIEUCH YEO NIEUNHIEUH
  {0xAB77, 0xCCD7}, //7421 #HANGUL SYLLABLE CHIEUCH YEO TIKEUT
  {0xAB78, 0xCCD8}, //7422 #HANGUL SYLLABLE CHIEUCH YEO RIEUL
  {0xAB79, 0xCCD9}, //7423 #HANGUL SYLLABLE CHIEUCH YEO RIEULKIYEOK
  {0xAB7A, 0xCCDA}, //7424 #HANGUL SYLLABLE CHIEUCH YEO RIEULMIEUM
  {0xAB81, 0xCCDB}, //7425 #HANGUL SYLLABLE CHIEUCH YEO RIEULPIEUP
  {0xAB82, 0xCCDC}, //7426 #HANGUL SYLLABLE CHIEUCH YEO RIEULSIOS
  {0xAB83, 0xCCDD}, //7427 #HANGUL SYLLABLE CHIEUCH YEO RIEULTHIEUTH
  {0xAB84, 0xCCDE}, //7428 #HANGUL SYLLABLE CHIEUCH YEO RIEULPHIEUPH
  {0xAB85, 0xCCDF}, //7429 #HANGUL SYLLABLE CHIEUCH YEO RIEULHIEUH
  {0xAB86, 0xCCE0}, //7430 #HANGUL SYLLABLE CHIEUCH YEO MIEUM
  {0xAB87, 0xCCE1}, //7431 #HANGUL SYLLABLE CHIEUCH YEO PIEUP
  {0xAB88, 0xCCE2}, //7432 #HANGUL SYLLABLE CHIEUCH YEO PIEUPSIOS
  {0xAB89, 0xCCE3}, //7433 #HANGUL SYLLABLE CHIEUCH YEO SIOS
  {0xAB8A, 0xCCE5}, //7434 #HANGUL SYLLABLE CHIEUCH YEO IEUNG
  {0xAB8B, 0xCCE6}, //7435 #HANGUL SYLLABLE CHIEUCH YEO CIEUC
  {0xAB8C, 0xCCE7}, //7436 #HANGUL SYLLABLE CHIEUCH YEO CHIEUCH
  {0xAB8D, 0xCCE8}, //7437 #HANGUL SYLLABLE CHIEUCH YEO KHIEUKH
  {0xAB8E, 0xCCE9}, //7438 #HANGUL SYLLABLE CHIEUCH YEO THIEUTH
  {0xAB8F, 0xCCEA}, //7439 #HANGUL SYLLABLE CHIEUCH YEO PHIEUPH
  {0xAB90, 0xCCEB}, //7440 #HANGUL SYLLABLE CHIEUCH YEO HIEUH
  {0xAB91, 0xCCED}, //7441 #HANGUL SYLLABLE CHIEUCH YE KIYEOK
  {0xAB92, 0xCCEE}, //7442 #HANGUL SYLLABLE CHIEUCH YE SSANGKIYEOK
  {0xAB93, 0xCCEF}, //7443 #HANGUL SYLLABLE CHIEUCH YE KIYEOKSIOS
  {0xAB94, 0xCCF1}, //7444 #HANGUL SYLLABLE CHIEUCH YE NIEUNCIEUC
  {0xAB95, 0xCCF2}, //7445 #HANGUL SYLLABLE CHIEUCH YE NIEUNHIEUH
  {0xAB96, 0xCCF3}, //7446 #HANGUL SYLLABLE CHIEUCH YE TIKEUT
  {0xAB97, 0xCCF4}, //7447 #HANGUL SYLLABLE CHIEUCH YE RIEUL
  {0xAB98, 0xCCF5}, //7448 #HANGUL SYLLABLE CHIEUCH YE RIEULKIYEOK
  {0xAB99, 0xCCF6}, //7449 #HANGUL SYLLABLE CHIEUCH YE RIEULMIEUM
  {0xAB9A, 0xCCF7}, //7450 #HANGUL SYLLABLE CHIEUCH YE RIEULPIEUP
  {0xAB9B, 0xCCF8}, //7451 #HANGUL SYLLABLE CHIEUCH YE RIEULSIOS
  {0xAB9C, 0xCCF9}, //7452 #HANGUL SYLLABLE CHIEUCH YE RIEULTHIEUTH
  {0xAB9D, 0xCCFA}, //7453 #HANGUL SYLLABLE CHIEUCH YE RIEULPHIEUPH
  {0xAB9E, 0xCCFB}, //7454 #HANGUL SYLLABLE CHIEUCH YE RIEULHIEUH
  {0xAB9F, 0xCCFC}, //7455 #HANGUL SYLLABLE CHIEUCH YE MIEUM
  {0xABA0, 0xCCFD}, //7456 #HANGUL SYLLABLE CHIEUCH YE PIEUP
  {0xABA1, 0x30A1}, //7457 #KATAKANA LETTER SMALL A
  {0xABA2, 0x30A2}, //7458 #KATAKANA LETTER A
  {0xABA3, 0x30A3}, //7459 #KATAKANA LETTER SMALL I
  {0xABA4, 0x30A4}, //7460 #KATAKANA LETTER I
  {0xABA5, 0x30A5}, //7461 #KATAKANA LETTER SMALL U
  {0xABA6, 0x30A6}, //7462 #KATAKANA LETTER U
  {0xABA7, 0x30A7}, //7463 #KATAKANA LETTER SMALL E
  {0xABA8, 0x30A8}, //7464 #KATAKANA LETTER E
  {0xABA9, 0x30A9}, //7465 #KATAKANA LETTER SMALL O
  {0xABAA, 0x30AA}, //7466 #KATAKANA LETTER O
  {0xABAB, 0x30AB}, //7467 #KATAKANA LETTER KA
  {0xABAC, 0x30AC}, //7468 #KATAKANA LETTER GA
  {0xABAD, 0x30AD}, //7469 #KATAKANA LETTER KI
  {0xABAE, 0x30AE}, //7470 #KATAKANA LETTER GI
  {0xABAF, 0x30AF}, //7471 #KATAKANA LETTER KU
  {0xABB0, 0x30B0}, //7472 #KATAKANA LETTER GU
  {0xABB1, 0x30B1}, //7473 #KATAKANA LETTER KE
  {0xABB2, 0x30B2}, //7474 #KATAKANA LETTER GE
  {0xABB3, 0x30B3}, //7475 #KATAKANA LETTER KO
  {0xABB4, 0x30B4}, //7476 #KATAKANA LETTER GO
  {0xABB5, 0x30B5}, //7477 #KATAKANA LETTER SA
  {0xABB6, 0x30B6}, //7478 #KATAKANA LETTER ZA
  {0xABB7, 0x30B7}, //7479 #KATAKANA LETTER SI
  {0xABB8, 0x30B8}, //7480 #KATAKANA LETTER ZI
  {0xABB9, 0x30B9}, //7481 #KATAKANA LETTER SU
  {0xABBA, 0x30BA}, //7482 #KATAKANA LETTER ZU
  {0xABBB, 0x30BB}, //7483 #KATAKANA LETTER SE
  {0xABBC, 0x30BC}, //7484 #KATAKANA LETTER ZE
  {0xABBD, 0x30BD}, //7485 #KATAKANA LETTER SO
  {0xABBE, 0x30BE}, //7486 #KATAKANA LETTER ZO
  {0xABBF, 0x30BF}, //7487 #KATAKANA LETTER TA
  {0xABC0, 0x30C0}, //7488 #KATAKANA LETTER DA
  {0xABC1, 0x30C1}, //7489 #KATAKANA LETTER TI
  {0xABC2, 0x30C2}, //7490 #KATAKANA LETTER DI
  {0xABC3, 0x30C3}, //7491 #KATAKANA LETTER SMALL TU
  {0xABC4, 0x30C4}, //7492 #KATAKANA LETTER TU
  {0xABC5, 0x30C5}, //7493 #KATAKANA LETTER DU
  {0xABC6, 0x30C6}, //7494 #KATAKANA LETTER TE
  {0xABC7, 0x30C7}, //7495 #KATAKANA LETTER DE
  {0xABC8, 0x30C8}, //7496 #KATAKANA LETTER TO
  {0xABC9, 0x30C9}, //7497 #KATAKANA LETTER DO
  {0xABCA, 0x30CA}, //7498 #KATAKANA LETTER NA
  {0xABCB, 0x30CB}, //7499 #KATAKANA LETTER NI
  {0xABCC, 0x30CC}, //7500 #KATAKANA LETTER NU
  {0xABCD, 0x30CD}, //7501 #KATAKANA LETTER NE
  {0xABCE, 0x30CE}, //7502 #KATAKANA LETTER NO
  {0xABCF, 0x30CF}, //7503 #KATAKANA LETTER HA
  {0xABD0, 0x30D0}, //7504 #KATAKANA LETTER BA
  {0xABD1, 0x30D1}, //7505 #KATAKANA LETTER PA
  {0xABD2, 0x30D2}, //7506 #KATAKANA LETTER HI
  {0xABD3, 0x30D3}, //7507 #KATAKANA LETTER BI
  {0xABD4, 0x30D4}, //7508 #KATAKANA LETTER PI
  {0xABD5, 0x30D5}, //7509 #KATAKANA LETTER HU
  {0xABD6, 0x30D6}, //7510 #KATAKANA LETTER BU
  {0xABD7, 0x30D7}, //7511 #KATAKANA LETTER PU
  {0xABD8, 0x30D8}, //7512 #KATAKANA LETTER HE
  {0xABD9, 0x30D9}, //7513 #KATAKANA LETTER BE
  {0xABDA, 0x30DA}, //7514 #KATAKANA LETTER PE
  {0xABDB, 0x30DB}, //7515 #KATAKANA LETTER HO
  {0xABDC, 0x30DC}, //7516 #KATAKANA LETTER BO
  {0xABDD, 0x30DD}, //7517 #KATAKANA LETTER PO
  {0xABDE, 0x30DE}, //7518 #KATAKANA LETTER MA
  {0xABDF, 0x30DF}, //7519 #KATAKANA LETTER MI
  {0xABE0, 0x30E0}, //7520 #KATAKANA LETTER MU
  {0xABE1, 0x30E1}, //7521 #KATAKANA LETTER ME
  {0xABE2, 0x30E2}, //7522 #KATAKANA LETTER MO
  {0xABE3, 0x30E3}, //7523 #KATAKANA LETTER SMALL YA
  {0xABE4, 0x30E4}, //7524 #KATAKANA LETTER YA
  {0xABE5, 0x30E5}, //7525 #KATAKANA LETTER SMALL YU
  {0xABE6, 0x30E6}, //7526 #KATAKANA LETTER YU
  {0xABE7, 0x30E7}, //7527 #KATAKANA LETTER SMALL YO
  {0xABE8, 0x30E8}, //7528 #KATAKANA LETTER YO
  {0xABE9, 0x30E9}, //7529 #KATAKANA LETTER RA
  {0xABEA, 0x30EA}, //7530 #KATAKANA LETTER RI
  {0xABEB, 0x30EB}, //7531 #KATAKANA LETTER RU
  {0xABEC, 0x30EC}, //7532 #KATAKANA LETTER RE
  {0xABED, 0x30ED}, //7533 #KATAKANA LETTER RO
  {0xABEE, 0x30EE}, //7534 #KATAKANA LETTER SMALL WA
  {0xABEF, 0x30EF}, //7535 #KATAKANA LETTER WA
  {0xABF0, 0x30F0}, //7536 #KATAKANA LETTER WI
  {0xABF1, 0x30F1}, //7537 #KATAKANA LETTER WE
  {0xABF2, 0x30F2}, //7538 #KATAKANA LETTER WO
  {0xABF3, 0x30F3}, //7539 #KATAKANA LETTER N
  {0xABF4, 0x30F4}, //7540 #KATAKANA LETTER VU
  {0xABF5, 0x30F5}, //7541 #KATAKANA LETTER SMALL KA
  {0xABF6, 0x30F6}, //7542 #KATAKANA LETTER SMALL KE
  {0xAC41, 0xCCFE}, //7543 #HANGUL SYLLABLE CHIEUCH YE PIEUPSIOS
  {0xAC42, 0xCCFF}, //7544 #HANGUL SYLLABLE CHIEUCH YE SIOS
  {0xAC43, 0xCD00}, //7545 #HANGUL SYLLABLE CHIEUCH YE SSANGSIOS
  {0xAC44, 0xCD02}, //7546 #HANGUL SYLLABLE CHIEUCH YE CIEUC
  {0xAC45, 0xCD03}, //7547 #HANGUL SYLLABLE CHIEUCH YE CHIEUCH
  {0xAC46, 0xCD04}, //7548 #HANGUL SYLLABLE CHIEUCH YE KHIEUKH
  {0xAC47, 0xCD05}, //7549 #HANGUL SYLLABLE CHIEUCH YE THIEUTH
  {0xAC48, 0xCD06}, //7550 #HANGUL SYLLABLE CHIEUCH YE PHIEUPH
  {0xAC49, 0xCD07}, //7551 #HANGUL SYLLABLE CHIEUCH YE HIEUH
  {0xAC4A, 0xCD0A}, //7552 #HANGUL SYLLABLE CHIEUCH O SSANGKIYEOK
  {0xAC4B, 0xCD0B}, //7553 #HANGUL SYLLABLE CHIEUCH O KIYEOKSIOS
  {0xAC4C, 0xCD0D}, //7554 #HANGUL SYLLABLE CHIEUCH O NIEUNCIEUC
  {0xAC4D, 0xCD0E}, //7555 #HANGUL SYLLABLE CHIEUCH O NIEUNHIEUH
  {0xAC4E, 0xCD0F}, //7556 #HANGUL SYLLABLE CHIEUCH O TIKEUT
  {0xAC4F, 0xCD11}, //7557 #HANGUL SYLLABLE CHIEUCH O RIEULKIYEOK
  {0xAC50, 0xCD12}, //7558 #HANGUL SYLLABLE CHIEUCH O RIEULMIEUM
  {0xAC51, 0xCD13}, //7559 #HANGUL SYLLABLE CHIEUCH O RIEULPIEUP
  {0xAC52, 0xCD14}, //7560 #HANGUL SYLLABLE CHIEUCH O RIEULSIOS
  {0xAC53, 0xCD15}, //7561 #HANGUL SYLLABLE CHIEUCH O RIEULTHIEUTH
  {0xAC54, 0xCD16}, //7562 #HANGUL SYLLABLE CHIEUCH O RIEULPHIEUPH
  {0xAC55, 0xCD17}, //7563 #HANGUL SYLLABLE CHIEUCH O RIEULHIEUH
  {0xAC56, 0xCD1A}, //7564 #HANGUL SYLLABLE CHIEUCH O PIEUPSIOS
  {0xAC57, 0xCD1C}, //7565 #HANGUL SYLLABLE CHIEUCH O SSANGSIOS
  {0xAC58, 0xCD1E}, //7566 #HANGUL SYLLABLE CHIEUCH O CIEUC
  {0xAC59, 0xCD1F}, //7567 #HANGUL SYLLABLE CHIEUCH O CHIEUCH
  {0xAC5A, 0xCD20}, //7568 #HANGUL SYLLABLE CHIEUCH O KHIEUKH
  {0xAC61, 0xCD21}, //7569 #HANGUL SYLLABLE CHIEUCH O THIEUTH
  {0xAC62, 0xCD22}, //7570 #HANGUL SYLLABLE CHIEUCH O PHIEUPH
  {0xAC63, 0xCD23}, //7571 #HANGUL SYLLABLE CHIEUCH O HIEUH
  {0xAC64, 0xCD25}, //7572 #HANGUL SYLLABLE CHIEUCH WA KIYEOK
  {0xAC65, 0xCD26}, //7573 #HANGUL SYLLABLE CHIEUCH WA SSANGKIYEOK
  {0xAC66, 0xCD27}, //7574 #HANGUL SYLLABLE CHIEUCH WA KIYEOKSIOS
  {0xAC67, 0xCD29}, //7575 #HANGUL SYLLABLE CHIEUCH WA NIEUNCIEUC
  {0xAC68, 0xCD2A}, //7576 #HANGUL SYLLABLE CHIEUCH WA NIEUNHIEUH
  {0xAC69, 0xCD2B}, //7577 #HANGUL SYLLABLE CHIEUCH WA TIKEUT
  {0xAC6A, 0xCD2D}, //7578 #HANGUL SYLLABLE CHIEUCH WA RIEULKIYEOK
  {0xAC6B, 0xCD2E}, //7579 #HANGUL SYLLABLE CHIEUCH WA RIEULMIEUM
  {0xAC6C, 0xCD2F}, //7580 #HANGUL SYLLABLE CHIEUCH WA RIEULPIEUP
  {0xAC6D, 0xCD30}, //7581 #HANGUL SYLLABLE CHIEUCH WA RIEULSIOS
  {0xAC6E, 0xCD31}, //7582 #HANGUL SYLLABLE CHIEUCH WA RIEULTHIEUTH
  {0xAC6F, 0xCD32}, //7583 #HANGUL SYLLABLE CHIEUCH WA RIEULPHIEUPH
  {0xAC70, 0xCD33}, //7584 #HANGUL SYLLABLE CHIEUCH WA RIEULHIEUH
  {0xAC71, 0xCD34}, //7585 #HANGUL SYLLABLE CHIEUCH WA MIEUM
  {0xAC72, 0xCD35}, //7586 #HANGUL SYLLABLE CHIEUCH WA PIEUP
  {0xAC73, 0xCD36}, //7587 #HANGUL SYLLABLE CHIEUCH WA PIEUPSIOS
  {0xAC74, 0xCD37}, //7588 #HANGUL SYLLABLE CHIEUCH WA SIOS
  {0xAC75, 0xCD38}, //7589 #HANGUL SYLLABLE CHIEUCH WA SSANGSIOS
  {0xAC76, 0xCD3A}, //7590 #HANGUL SYLLABLE CHIEUCH WA CIEUC
  {0xAC77, 0xCD3B}, //7591 #HANGUL SYLLABLE CHIEUCH WA CHIEUCH
  {0xAC78, 0xCD3C}, //7592 #HANGUL SYLLABLE CHIEUCH WA KHIEUKH
  {0xAC79, 0xCD3D}, //7593 #HANGUL SYLLABLE CHIEUCH WA THIEUTH
  {0xAC7A, 0xCD3E}, //7594 #HANGUL SYLLABLE CHIEUCH WA PHIEUPH
  {0xAC81, 0xCD3F}, //7595 #HANGUL SYLLABLE CHIEUCH WA HIEUH
  {0xAC82, 0xCD40}, //7596 #HANGUL SYLLABLE CHIEUCH WAE
  {0xAC83, 0xCD41}, //7597 #HANGUL SYLLABLE CHIEUCH WAE KIYEOK
  {0xAC84, 0xCD42}, //7598 #HANGUL SYLLABLE CHIEUCH WAE SSANGKIYEOK
  {0xAC85, 0xCD43}, //7599 #HANGUL SYLLABLE CHIEUCH WAE KIYEOKSIOS
  {0xAC86, 0xCD44}, //7600 #HANGUL SYLLABLE CHIEUCH WAE NIEUN
  {0xAC87, 0xCD45}, //7601 #HANGUL SYLLABLE CHIEUCH WAE NIEUNCIEUC
  {0xAC88, 0xCD46}, //7602 #HANGUL SYLLABLE CHIEUCH WAE NIEUNHIEUH
  {0xAC89, 0xCD47}, //7603 #HANGUL SYLLABLE CHIEUCH WAE TIKEUT
  {0xAC8A, 0xCD48}, //7604 #HANGUL SYLLABLE CHIEUCH WAE RIEUL
  {0xAC8B, 0xCD49}, //7605 #HANGUL SYLLABLE CHIEUCH WAE RIEULKIYEOK
  {0xAC8C, 0xCD4A}, //7606 #HANGUL SYLLABLE CHIEUCH WAE RIEULMIEUM
  {0xAC8D, 0xCD4B}, //7607 #HANGUL SYLLABLE CHIEUCH WAE RIEULPIEUP
  {0xAC8E, 0xCD4C}, //7608 #HANGUL SYLLABLE CHIEUCH WAE RIEULSIOS
  {0xAC8F, 0xCD4D}, //7609 #HANGUL SYLLABLE CHIEUCH WAE RIEULTHIEUTH
  {0xAC90, 0xCD4E}, //7610 #HANGUL SYLLABLE CHIEUCH WAE RIEULPHIEUPH
  {0xAC91, 0xCD4F}, //7611 #HANGUL SYLLABLE CHIEUCH WAE RIEULHIEUH
  {0xAC92, 0xCD50}, //7612 #HANGUL SYLLABLE CHIEUCH WAE MIEUM
  {0xAC93, 0xCD51}, //7613 #HANGUL SYLLABLE CHIEUCH WAE PIEUP
  {0xAC94, 0xCD52}, //7614 #HANGUL SYLLABLE CHIEUCH WAE PIEUPSIOS
  {0xAC95, 0xCD53}, //7615 #HANGUL SYLLABLE CHIEUCH WAE SIOS
  {0xAC96, 0xCD54}, //7616 #HANGUL SYLLABLE CHIEUCH WAE SSANGSIOS
  {0xAC97, 0xCD55}, //7617 #HANGUL SYLLABLE CHIEUCH WAE IEUNG
  {0xAC98, 0xCD56}, //7618 #HANGUL SYLLABLE CHIEUCH WAE CIEUC
  {0xAC99, 0xCD57}, //7619 #HANGUL SYLLABLE CHIEUCH WAE CHIEUCH
  {0xAC9A, 0xCD58}, //7620 #HANGUL SYLLABLE CHIEUCH WAE KHIEUKH
  {0xAC9B, 0xCD59}, //7621 #HANGUL SYLLABLE CHIEUCH WAE THIEUTH
  {0xAC9C, 0xCD5A}, //7622 #HANGUL SYLLABLE CHIEUCH WAE PHIEUPH
  {0xAC9D, 0xCD5B}, //7623 #HANGUL SYLLABLE CHIEUCH WAE HIEUH
  {0xAC9E, 0xCD5D}, //7624 #HANGUL SYLLABLE CHIEUCH OE KIYEOK
  {0xAC9F, 0xCD5E}, //7625 #HANGUL SYLLABLE CHIEUCH OE SSANGKIYEOK
  {0xACA0, 0xCD5F}, //7626 #HANGUL SYLLABLE CHIEUCH OE KIYEOKSIOS
  {0xACA1, 0x0410}, //7627 #CYRILLIC CAPITAL LETTER A
  {0xACA2, 0x0411}, //7628 #CYRILLIC CAPITAL LETTER BE
  {0xACA3, 0x0412}, //7629 #CYRILLIC CAPITAL LETTER VE
  {0xACA4, 0x0413}, //7630 #CYRILLIC CAPITAL LETTER GHE
  {0xACA5, 0x0414}, //7631 #CYRILLIC CAPITAL LETTER DE
  {0xACA6, 0x0415}, //7632 #CYRILLIC CAPITAL LETTER IE
  {0xACA7, 0x0401}, //7633 #CYRILLIC CAPITAL LETTER IO
  {0xACA8, 0x0416}, //7634 #CYRILLIC CAPITAL LETTER ZHE
  {0xACA9, 0x0417}, //7635 #CYRILLIC CAPITAL LETTER ZE
  {0xACAA, 0x0418}, //7636 #CYRILLIC CAPITAL LETTER I
  {0xACAB, 0x0419}, //7637 #CYRILLIC CAPITAL LETTER SHORT I
  {0xACAC, 0x041A}, //7638 #CYRILLIC CAPITAL LETTER KA
  {0xACAD, 0x041B}, //7639 #CYRILLIC CAPITAL LETTER EL
  {0xACAE, 0x041C}, //7640 #CYRILLIC CAPITAL LETTER EM
  {0xACAF, 0x041D}, //7641 #CYRILLIC CAPITAL LETTER EN
  {0xACB0, 0x041E}, //7642 #CYRILLIC CAPITAL LETTER O
  {0xACB1, 0x041F}, //7643 #CYRILLIC CAPITAL LETTER PE
  {0xACB2, 0x0420}, //7644 #CYRILLIC CAPITAL LETTER ER
  {0xACB3, 0x0421}, //7645 #CYRILLIC CAPITAL LETTER ES
  {0xACB4, 0x0422}, //7646 #CYRILLIC CAPITAL LETTER TE
  {0xACB5, 0x0423}, //7647 #CYRILLIC CAPITAL LETTER U
  {0xACB6, 0x0424}, //7648 #CYRILLIC CAPITAL LETTER EF
  {0xACB7, 0x0425}, //7649 #CYRILLIC CAPITAL LETTER HA
  {0xACB8, 0x0426}, //7650 #CYRILLIC CAPITAL LETTER TSE
  {0xACB9, 0x0427}, //7651 #CYRILLIC CAPITAL LETTER CHE
  {0xACBA, 0x0428}, //7652 #CYRILLIC CAPITAL LETTER SHA
  {0xACBB, 0x0429}, //7653 #CYRILLIC CAPITAL LETTER SHCHA
  {0xACBC, 0x042A}, //7654 #CYRILLIC CAPITAL LETTER HARD SIGN
  {0xACBD, 0x042B}, //7655 #CYRILLIC CAPITAL LETTER YERU
  {0xACBE, 0x042C}, //7656 #CYRILLIC CAPITAL LETTER SOFT SIGN
  {0xACBF, 0x042D}, //7657 #CYRILLIC CAPITAL LETTER E
  {0xACC0, 0x042E}, //7658 #CYRILLIC CAPITAL LETTER YU
  {0xACC1, 0x042F}, //7659 #CYRILLIC CAPITAL LETTER YA
  {0xACD1, 0x0430}, //7660 #CYRILLIC SMALL LETTER A
  {0xACD2, 0x0431}, //7661 #CYRILLIC SMALL LETTER BE
  {0xACD3, 0x0432}, //7662 #CYRILLIC SMALL LETTER VE
  {0xACD4, 0x0433}, //7663 #CYRILLIC SMALL LETTER GHE
  {0xACD5, 0x0434}, //7664 #CYRILLIC SMALL LETTER DE
  {0xACD6, 0x0435}, //7665 #CYRILLIC SMALL LETTER IE
  {0xACD7, 0x0451}, //7666 #CYRILLIC SMALL LETTER IO
  {0xACD8, 0x0436}, //7667 #CYRILLIC SMALL LETTER ZHE
  {0xACD9, 0x0437}, //7668 #CYRILLIC SMALL LETTER ZE
  {0xACDA, 0x0438}, //7669 #CYRILLIC SMALL LETTER I
  {0xACDB, 0x0439}, //7670 #CYRILLIC SMALL LETTER SHORT I
  {0xACDC, 0x043A}, //7671 #CYRILLIC SMALL LETTER KA
  {0xACDD, 0x043B}, //7672 #CYRILLIC SMALL LETTER EL
  {0xACDE, 0x043C}, //7673 #CYRILLIC SMALL LETTER EM
  {0xACDF, 0x043D}, //7674 #CYRILLIC SMALL LETTER EN
  {0xACE0, 0x043E}, //7675 #CYRILLIC SMALL LETTER O
  {0xACE1, 0x043F}, //7676 #CYRILLIC SMALL LETTER PE
  {0xACE2, 0x0440}, //7677 #CYRILLIC SMALL LETTER ER
  {0xACE3, 0x0441}, //7678 #CYRILLIC SMALL LETTER ES
  {0xACE4, 0x0442}, //7679 #CYRILLIC SMALL LETTER TE
  {0xACE5, 0x0443}, //7680 #CYRILLIC SMALL LETTER U
  {0xACE6, 0x0444}, //7681 #CYRILLIC SMALL LETTER EF
  {0xACE7, 0x0445}, //7682 #CYRILLIC SMALL LETTER HA
  {0xACE8, 0x0446}, //7683 #CYRILLIC SMALL LETTER TSE
  {0xACE9, 0x0447}, //7684 #CYRILLIC SMALL LETTER CHE
  {0xACEA, 0x0448}, //7685 #CYRILLIC SMALL LETTER SHA
  {0xACEB, 0x0449}, //7686 #CYRILLIC SMALL LETTER SHCHA
  {0xACEC, 0x044A}, //7687 #CYRILLIC SMALL LETTER HARD SIGN
  {0xACED, 0x044B}, //7688 #CYRILLIC SMALL LETTER YERU
  {0xACEE, 0x044C}, //7689 #CYRILLIC SMALL LETTER SOFT SIGN
  {0xACEF, 0x044D}, //7690 #CYRILLIC SMALL LETTER E
  {0xACF0, 0x044E}, //7691 #CYRILLIC SMALL LETTER YU
  {0xACF1, 0x044F}, //7692 #CYRILLIC SMALL LETTER YA
  {0xAD41, 0xCD61}, //7693 #HANGUL SYLLABLE CHIEUCH OE NIEUNCIEUC
  {0xAD42, 0xCD62}, //7694 #HANGUL SYLLABLE CHIEUCH OE NIEUNHIEUH
  {0xAD43, 0xCD63}, //7695 #HANGUL SYLLABLE CHIEUCH OE TIKEUT
  {0xAD44, 0xCD65}, //7696 #HANGUL SYLLABLE CHIEUCH OE RIEULKIYEOK
  {0xAD45, 0xCD66}, //7697 #HANGUL SYLLABLE CHIEUCH OE RIEULMIEUM
  {0xAD46, 0xCD67}, //7698 #HANGUL SYLLABLE CHIEUCH OE RIEULPIEUP
  {0xAD47, 0xCD68}, //7699 #HANGUL SYLLABLE CHIEUCH OE RIEULSIOS
  {0xAD48, 0xCD69}, //7700 #HANGUL SYLLABLE CHIEUCH OE RIEULTHIEUTH
  {0xAD49, 0xCD6A}, //7701 #HANGUL SYLLABLE CHIEUCH OE RIEULPHIEUPH
  {0xAD4A, 0xCD6B}, //7702 #HANGUL SYLLABLE CHIEUCH OE RIEULHIEUH
  {0xAD4B, 0xCD6E}, //7703 #HANGUL SYLLABLE CHIEUCH OE PIEUPSIOS
  {0xAD4C, 0xCD70}, //7704 #HANGUL SYLLABLE CHIEUCH OE SSANGSIOS
  {0xAD4D, 0xCD72}, //7705 #HANGUL SYLLABLE CHIEUCH OE CIEUC
  {0xAD4E, 0xCD73}, //7706 #HANGUL SYLLABLE CHIEUCH OE CHIEUCH
  {0xAD4F, 0xCD74}, //7707 #HANGUL SYLLABLE CHIEUCH OE KHIEUKH
  {0xAD50, 0xCD75}, //7708 #HANGUL SYLLABLE CHIEUCH OE THIEUTH
  {0xAD51, 0xCD76}, //7709 #HANGUL SYLLABLE CHIEUCH OE PHIEUPH
  {0xAD52, 0xCD77}, //7710 #HANGUL SYLLABLE CHIEUCH OE HIEUH
  {0xAD53, 0xCD79}, //7711 #HANGUL SYLLABLE CHIEUCH YO KIYEOK
  {0xAD54, 0xCD7A}, //7712 #HANGUL SYLLABLE CHIEUCH YO SSANGKIYEOK
  {0xAD55, 0xCD7B}, //7713 #HANGUL SYLLABLE CHIEUCH YO KIYEOKSIOS
  {0xAD56, 0xCD7C}, //7714 #HANGUL SYLLABLE CHIEUCH YO NIEUN
  {0xAD57, 0xCD7D}, //7715 #HANGUL SYLLABLE CHIEUCH YO NIEUNCIEUC
  {0xAD58, 0xCD7E}, //7716 #HANGUL SYLLABLE CHIEUCH YO NIEUNHIEUH
  {0xAD59, 0xCD7F}, //7717 #HANGUL SYLLABLE CHIEUCH YO TIKEUT
  {0xAD5A, 0xCD80}, //7718 #HANGUL SYLLABLE CHIEUCH YO RIEUL
  {0xAD61, 0xCD81}, //7719 #HANGUL SYLLABLE CHIEUCH YO RIEULKIYEOK
  {0xAD62, 0xCD82}, //7720 #HANGUL SYLLABLE CHIEUCH YO RIEULMIEUM
  {0xAD63, 0xCD83}, //7721 #HANGUL SYLLABLE CHIEUCH YO RIEULPIEUP
  {0xAD64, 0xCD84}, //7722 #HANGUL SYLLABLE CHIEUCH YO RIEULSIOS
  {0xAD65, 0xCD85}, //7723 #HANGUL SYLLABLE CHIEUCH YO RIEULTHIEUTH
  {0xAD66, 0xCD86}, //7724 #HANGUL SYLLABLE CHIEUCH YO RIEULPHIEUPH
  {0xAD67, 0xCD87}, //7725 #HANGUL SYLLABLE CHIEUCH YO RIEULHIEUH
  {0xAD68, 0xCD89}, //7726 #HANGUL SYLLABLE CHIEUCH YO PIEUP
  {0xAD69, 0xCD8A}, //7727 #HANGUL SYLLABLE CHIEUCH YO PIEUPSIOS
  {0xAD6A, 0xCD8B}, //7728 #HANGUL SYLLABLE CHIEUCH YO SIOS
  {0xAD6B, 0xCD8C}, //7729 #HANGUL SYLLABLE CHIEUCH YO SSANGSIOS
  {0xAD6C, 0xCD8D}, //7730 #HANGUL SYLLABLE CHIEUCH YO IEUNG
  {0xAD6D, 0xCD8E}, //7731 #HANGUL SYLLABLE CHIEUCH YO CIEUC
  {0xAD6E, 0xCD8F}, //7732 #HANGUL SYLLABLE CHIEUCH YO CHIEUCH
  {0xAD6F, 0xCD90}, //7733 #HANGUL SYLLABLE CHIEUCH YO KHIEUKH
  {0xAD70, 0xCD91}, //7734 #HANGUL SYLLABLE CHIEUCH YO THIEUTH
  {0xAD71, 0xCD92}, //7735 #HANGUL SYLLABLE CHIEUCH YO PHIEUPH
  {0xAD72, 0xCD93}, //7736 #HANGUL SYLLABLE CHIEUCH YO HIEUH
  {0xAD73, 0xCD96}, //7737 #HANGUL SYLLABLE CHIEUCH U SSANGKIYEOK
  {0xAD74, 0xCD97}, //7738 #HANGUL SYLLABLE CHIEUCH U KIYEOKSIOS
  {0xAD75, 0xCD99}, //7739 #HANGUL SYLLABLE CHIEUCH U NIEUNCIEUC
  {0xAD76, 0xCD9A}, //7740 #HANGUL SYLLABLE CHIEUCH U NIEUNHIEUH
  {0xAD77, 0xCD9B}, //7741 #HANGUL SYLLABLE CHIEUCH U TIKEUT
  {0xAD78, 0xCD9D}, //7742 #HANGUL SYLLABLE CHIEUCH U RIEULKIYEOK
  {0xAD79, 0xCD9E}, //7743 #HANGUL SYLLABLE CHIEUCH U RIEULMIEUM
  {0xAD7A, 0xCD9F}, //7744 #HANGUL SYLLABLE CHIEUCH U RIEULPIEUP
  {0xAD81, 0xCDA0}, //7745 #HANGUL SYLLABLE CHIEUCH U RIEULSIOS
  {0xAD82, 0xCDA1}, //7746 #HANGUL SYLLABLE CHIEUCH U RIEULTHIEUTH
  {0xAD83, 0xCDA2}, //7747 #HANGUL SYLLABLE CHIEUCH U RIEULPHIEUPH
  {0xAD84, 0xCDA3}, //7748 #HANGUL SYLLABLE CHIEUCH U RIEULHIEUH
  {0xAD85, 0xCDA6}, //7749 #HANGUL SYLLABLE CHIEUCH U PIEUPSIOS
  {0xAD86, 0xCDA8}, //7750 #HANGUL SYLLABLE CHIEUCH U SSANGSIOS
  {0xAD87, 0xCDAA}, //7751 #HANGUL SYLLABLE CHIEUCH U CIEUC
  {0xAD88, 0xCDAB}, //7752 #HANGUL SYLLABLE CHIEUCH U CHIEUCH
  {0xAD89, 0xCDAC}, //7753 #HANGUL SYLLABLE CHIEUCH U KHIEUKH
  {0xAD8A, 0xCDAD}, //7754 #HANGUL SYLLABLE CHIEUCH U THIEUTH
  {0xAD8B, 0xCDAE}, //7755 #HANGUL SYLLABLE CHIEUCH U PHIEUPH
  {0xAD8C, 0xCDAF}, //7756 #HANGUL SYLLABLE CHIEUCH U HIEUH
  {0xAD8D, 0xCDB1}, //7757 #HANGUL SYLLABLE CHIEUCH WEO KIYEOK
  {0xAD8E, 0xCDB2}, //7758 #HANGUL SYLLABLE CHIEUCH WEO SSANGKIYEOK
  {0xAD8F, 0xCDB3}, //7759 #HANGUL SYLLABLE CHIEUCH WEO KIYEOKSIOS
  {0xAD90, 0xCDB4}, //7760 #HANGUL SYLLABLE CHIEUCH WEO NIEUN
  {0xAD91, 0xCDB5}, //7761 #HANGUL SYLLABLE CHIEUCH WEO NIEUNCIEUC
  {0xAD92, 0xCDB6}, //7762 #HANGUL SYLLABLE CHIEUCH WEO NIEUNHIEUH
  {0xAD93, 0xCDB7}, //7763 #HANGUL SYLLABLE CHIEUCH WEO TIKEUT
  {0xAD94, 0xCDB8}, //7764 #HANGUL SYLLABLE CHIEUCH WEO RIEUL
  {0xAD95, 0xCDB9}, //7765 #HANGUL SYLLABLE CHIEUCH WEO RIEULKIYEOK
  {0xAD96, 0xCDBA}, //7766 #HANGUL SYLLABLE CHIEUCH WEO RIEULMIEUM
  {0xAD97, 0xCDBB}, //7767 #HANGUL SYLLABLE CHIEUCH WEO RIEULPIEUP
  {0xAD98, 0xCDBC}, //7768 #HANGUL SYLLABLE CHIEUCH WEO RIEULSIOS
  {0xAD99, 0xCDBD}, //7769 #HANGUL SYLLABLE CHIEUCH WEO RIEULTHIEUTH
  {0xAD9A, 0xCDBE}, //7770 #HANGUL SYLLABLE CHIEUCH WEO RIEULPHIEUPH
  {0xAD9B, 0xCDBF}, //7771 #HANGUL SYLLABLE CHIEUCH WEO RIEULHIEUH
  {0xAD9C, 0xCDC0}, //7772 #HANGUL SYLLABLE CHIEUCH WEO MIEUM
  {0xAD9D, 0xCDC1}, //7773 #HANGUL SYLLABLE CHIEUCH WEO PIEUP
  {0xAD9E, 0xCDC2}, //7774 #HANGUL SYLLABLE CHIEUCH WEO PIEUPSIOS
  {0xAD9F, 0xCDC3}, //7775 #HANGUL SYLLABLE CHIEUCH WEO SIOS
  {0xADA0, 0xCDC5}, //7776 #HANGUL SYLLABLE CHIEUCH WEO IEUNG
  {0xAE41, 0xCDC6}, //7777 #HANGUL SYLLABLE CHIEUCH WEO CIEUC
  {0xAE42, 0xCDC7}, //7778 #HANGUL SYLLABLE CHIEUCH WEO CHIEUCH
  {0xAE43, 0xCDC8}, //7779 #HANGUL SYLLABLE CHIEUCH WEO KHIEUKH
  {0xAE44, 0xCDC9}, //7780 #HANGUL SYLLABLE CHIEUCH WEO THIEUTH
  {0xAE45, 0xCDCA}, //7781 #HANGUL SYLLABLE CHIEUCH WEO PHIEUPH
  {0xAE46, 0xCDCB}, //7782 #HANGUL SYLLABLE CHIEUCH WEO HIEUH
  {0xAE47, 0xCDCD}, //7783 #HANGUL SYLLABLE CHIEUCH WE KIYEOK
  {0xAE48, 0xCDCE}, //7784 #HANGUL SYLLABLE CHIEUCH WE SSANGKIYEOK
  {0xAE49, 0xCDCF}, //7785 #HANGUL SYLLABLE CHIEUCH WE KIYEOKSIOS
  {0xAE4A, 0xCDD1}, //7786 #HANGUL SYLLABLE CHIEUCH WE NIEUNCIEUC
  {0xAE4B, 0xCDD2}, //7787 #HANGUL SYLLABLE CHIEUCH WE NIEUNHIEUH
  {0xAE4C, 0xCDD3}, //7788 #HANGUL SYLLABLE CHIEUCH WE TIKEUT
  {0xAE4D, 0xCDD4}, //7789 #HANGUL SYLLABLE CHIEUCH WE RIEUL
  {0xAE4E, 0xCDD5}, //7790 #HANGUL SYLLABLE CHIEUCH WE RIEULKIYEOK
  {0xAE4F, 0xCDD6}, //7791 #HANGUL SYLLABLE CHIEUCH WE RIEULMIEUM
  {0xAE50, 0xCDD7}, //7792 #HANGUL SYLLABLE CHIEUCH WE RIEULPIEUP
  {0xAE51, 0xCDD8}, //7793 #HANGUL SYLLABLE CHIEUCH WE RIEULSIOS
  {0xAE52, 0xCDD9}, //7794 #HANGUL SYLLABLE CHIEUCH WE RIEULTHIEUTH
  {0xAE53, 0xCDDA}, //7795 #HANGUL SYLLABLE CHIEUCH WE RIEULPHIEUPH
  {0xAE54, 0xCDDB}, //7796 #HANGUL SYLLABLE CHIEUCH WE RIEULHIEUH
  {0xAE55, 0xCDDC}, //7797 #HANGUL SYLLABLE CHIEUCH WE MIEUM
  {0xAE56, 0xCDDD}, //7798 #HANGUL SYLLABLE CHIEUCH WE PIEUP
  {0xAE57, 0xCDDE}, //7799 #HANGUL SYLLABLE CHIEUCH WE PIEUPSIOS
  {0xAE58, 0xCDDF}, //7800 #HANGUL SYLLABLE CHIEUCH WE SIOS
  {0xAE59, 0xCDE0}, //7801 #HANGUL SYLLABLE CHIEUCH WE SSANGSIOS
  {0xAE5A, 0xCDE1}, //7802 #HANGUL SYLLABLE CHIEUCH WE IEUNG
  {0xAE61, 0xCDE2}, //7803 #HANGUL SYLLABLE CHIEUCH WE CIEUC
  {0xAE62, 0xCDE3}, //7804 #HANGUL SYLLABLE CHIEUCH WE CHIEUCH
  {0xAE63, 0xCDE4}, //7805 #HANGUL SYLLABLE CHIEUCH WE KHIEUKH
  {0xAE64, 0xCDE5}, //7806 #HANGUL SYLLABLE CHIEUCH WE THIEUTH
  {0xAE65, 0xCDE6}, //7807 #HANGUL SYLLABLE CHIEUCH WE PHIEUPH
  {0xAE66, 0xCDE7}, //7808 #HANGUL SYLLABLE CHIEUCH WE HIEUH
  {0xAE67, 0xCDE9}, //7809 #HANGUL SYLLABLE CHIEUCH WI KIYEOK
  {0xAE68, 0xCDEA}, //7810 #HANGUL SYLLABLE CHIEUCH WI SSANGKIYEOK
  {0xAE69, 0xCDEB}, //7811 #HANGUL SYLLABLE CHIEUCH WI KIYEOKSIOS
  {0xAE6A, 0xCDED}, //7812 #HANGUL SYLLABLE CHIEUCH WI NIEUNCIEUC
  {0xAE6B, 0xCDEE}, //7813 #HANGUL SYLLABLE CHIEUCH WI NIEUNHIEUH
  {0xAE6C, 0xCDEF}, //7814 #HANGUL SYLLABLE CHIEUCH WI TIKEUT
  {0xAE6D, 0xCDF1}, //7815 #HANGUL SYLLABLE CHIEUCH WI RIEULKIYEOK
  {0xAE6E, 0xCDF2}, //7816 #HANGUL SYLLABLE CHIEUCH WI RIEULMIEUM
  {0xAE6F, 0xCDF3}, //7817 #HANGUL SYLLABLE CHIEUCH WI RIEULPIEUP
  {0xAE70, 0xCDF4}, //7818 #HANGUL SYLLABLE CHIEUCH WI RIEULSIOS
  {0xAE71, 0xCDF5}, //7819 #HANGUL SYLLABLE CHIEUCH WI RIEULTHIEUTH
  {0xAE72, 0xCDF6}, //7820 #HANGUL SYLLABLE CHIEUCH WI RIEULPHIEUPH
  {0xAE73, 0xCDF7}, //7821 #HANGUL SYLLABLE CHIEUCH WI RIEULHIEUH
  {0xAE74, 0xCDFA}, //7822 #HANGUL SYLLABLE CHIEUCH WI PIEUPSIOS
  {0xAE75, 0xCDFC}, //7823 #HANGUL SYLLABLE CHIEUCH WI SSANGSIOS
  {0xAE76, 0xCDFE}, //7824 #HANGUL SYLLABLE CHIEUCH WI CIEUC
  {0xAE77, 0xCDFF}, //7825 #HANGUL SYLLABLE CHIEUCH WI CHIEUCH
  {0xAE78, 0xCE00}, //7826 #HANGUL SYLLABLE CHIEUCH WI KHIEUKH
  {0xAE79, 0xCE01}, //7827 #HANGUL SYLLABLE CHIEUCH WI THIEUTH
  {0xAE7A, 0xCE02}, //7828 #HANGUL SYLLABLE CHIEUCH WI PHIEUPH
  {0xAE81, 0xCE03}, //7829 #HANGUL SYLLABLE CHIEUCH WI HIEUH
  {0xAE82, 0xCE05}, //7830 #HANGUL SYLLABLE CHIEUCH YU KIYEOK
  {0xAE83, 0xCE06}, //7831 #HANGUL SYLLABLE CHIEUCH YU SSANGKIYEOK
  {0xAE84, 0xCE07}, //7832 #HANGUL SYLLABLE CHIEUCH YU KIYEOKSIOS
  {0xAE85, 0xCE09}, //7833 #HANGUL SYLLABLE CHIEUCH YU NIEUNCIEUC
  {0xAE86, 0xCE0A}, //7834 #HANGUL SYLLABLE CHIEUCH YU NIEUNHIEUH
  {0xAE87, 0xCE0B}, //7835 #HANGUL SYLLABLE CHIEUCH YU TIKEUT
  {0xAE88, 0xCE0D}, //7836 #HANGUL SYLLABLE CHIEUCH YU RIEULKIYEOK
  {0xAE89, 0xCE0E}, //7837 #HANGUL SYLLABLE CHIEUCH YU RIEULMIEUM
  {0xAE8A, 0xCE0F}, //7838 #HANGUL SYLLABLE CHIEUCH YU RIEULPIEUP
  {0xAE8B, 0xCE10}, //7839 #HANGUL SYLLABLE CHIEUCH YU RIEULSIOS
  {0xAE8C, 0xCE11}, //7840 #HANGUL SYLLABLE CHIEUCH YU RIEULTHIEUTH
  {0xAE8D, 0xCE12}, //7841 #HANGUL SYLLABLE CHIEUCH YU RIEULPHIEUPH
  {0xAE8E, 0xCE13}, //7842 #HANGUL SYLLABLE CHIEUCH YU RIEULHIEUH
  {0xAE8F, 0xCE15}, //7843 #HANGUL SYLLABLE CHIEUCH YU PIEUP
  {0xAE90, 0xCE16}, //7844 #HANGUL SYLLABLE CHIEUCH YU PIEUPSIOS
  {0xAE91, 0xCE17}, //7845 #HANGUL SYLLABLE CHIEUCH YU SIOS
  {0xAE92, 0xCE18}, //7846 #HANGUL SYLLABLE CHIEUCH YU SSANGSIOS
  {0xAE93, 0xCE1A}, //7847 #HANGUL SYLLABLE CHIEUCH YU CIEUC
  {0xAE94, 0xCE1B}, //7848 #HANGUL SYLLABLE CHIEUCH YU CHIEUCH
  {0xAE95, 0xCE1C}, //7849 #HANGUL SYLLABLE CHIEUCH YU KHIEUKH
  {0xAE96, 0xCE1D}, //7850 #HANGUL SYLLABLE CHIEUCH YU THIEUTH
  {0xAE97, 0xCE1E}, //7851 #HANGUL SYLLABLE CHIEUCH YU PHIEUPH
  {0xAE98, 0xCE1F}, //7852 #HANGUL SYLLABLE CHIEUCH YU HIEUH
  {0xAE99, 0xCE22}, //7853 #HANGUL SYLLABLE CHIEUCH EU SSANGKIYEOK
  {0xAE9A, 0xCE23}, //7854 #HANGUL SYLLABLE CHIEUCH EU KIYEOKSIOS
  {0xAE9B, 0xCE25}, //7855 #HANGUL SYLLABLE CHIEUCH EU NIEUNCIEUC
  {0xAE9C, 0xCE26}, //7856 #HANGUL SYLLABLE CHIEUCH EU NIEUNHIEUH
  {0xAE9D, 0xCE27}, //7857 #HANGUL SYLLABLE CHIEUCH EU TIKEUT
  {0xAE9E, 0xCE29}, //7858 #HANGUL SYLLABLE CHIEUCH EU RIEULKIYEOK
  {0xAE9F, 0xCE2A}, //7859 #HANGUL SYLLABLE CHIEUCH EU RIEULMIEUM
  {0xAEA0, 0xCE2B}, //7860 #HANGUL SYLLABLE CHIEUCH EU RIEULPIEUP
  {0xAF41, 0xCE2C}, //7861 #HANGUL SYLLABLE CHIEUCH EU RIEULSIOS
  {0xAF42, 0xCE2D}, //7862 #HANGUL SYLLABLE CHIEUCH EU RIEULTHIEUTH
  {0xAF43, 0xCE2E}, //7863 #HANGUL SYLLABLE CHIEUCH EU RIEULPHIEUPH
  {0xAF44, 0xCE2F}, //7864 #HANGUL SYLLABLE CHIEUCH EU RIEULHIEUH
  {0xAF45, 0xCE32}, //7865 #HANGUL SYLLABLE CHIEUCH EU PIEUPSIOS
  {0xAF46, 0xCE34}, //7866 #HANGUL SYLLABLE CHIEUCH EU SSANGSIOS
  {0xAF47, 0xCE36}, //7867 #HANGUL SYLLABLE CHIEUCH EU CIEUC
  {0xAF48, 0xCE37}, //7868 #HANGUL SYLLABLE CHIEUCH EU CHIEUCH
  {0xAF49, 0xCE38}, //7869 #HANGUL SYLLABLE CHIEUCH EU KHIEUKH
  {0xAF4A, 0xCE39}, //7870 #HANGUL SYLLABLE CHIEUCH EU THIEUTH
  {0xAF4B, 0xCE3A}, //7871 #HANGUL SYLLABLE CHIEUCH EU PHIEUPH
  {0xAF4C, 0xCE3B}, //7872 #HANGUL SYLLABLE CHIEUCH EU HIEUH
  {0xAF4D, 0xCE3C}, //7873 #HANGUL SYLLABLE CHIEUCH YI
  {0xAF4E, 0xCE3D}, //7874 #HANGUL SYLLABLE CHIEUCH YI KIYEOK
  {0xAF4F, 0xCE3E}, //7875 #HANGUL SYLLABLE CHIEUCH YI SSANGKIYEOK
  {0xAF50, 0xCE3F}, //7876 #HANGUL SYLLABLE CHIEUCH YI KIYEOKSIOS
  {0xAF51, 0xCE40}, //7877 #HANGUL SYLLABLE CHIEUCH YI NIEUN
  {0xAF52, 0xCE41}, //7878 #HANGUL SYLLABLE CHIEUCH YI NIEUNCIEUC
  {0xAF53, 0xCE42}, //7879 #HANGUL SYLLABLE CHIEUCH YI NIEUNHIEUH
  {0xAF54, 0xCE43}, //7880 #HANGUL SYLLABLE CHIEUCH YI TIKEUT
  {0xAF55, 0xCE44}, //7881 #HANGUL SYLLABLE CHIEUCH YI RIEUL
  {0xAF56, 0xCE45}, //7882 #HANGUL SYLLABLE CHIEUCH YI RIEULKIYEOK
  {0xAF57, 0xCE46}, //7883 #HANGUL SYLLABLE CHIEUCH YI RIEULMIEUM
  {0xAF58, 0xCE47}, //7884 #HANGUL SYLLABLE CHIEUCH YI RIEULPIEUP
  {0xAF59, 0xCE48}, //7885 #HANGUL SYLLABLE CHIEUCH YI RIEULSIOS
  {0xAF5A, 0xCE49}, //7886 #HANGUL SYLLABLE CHIEUCH YI RIEULTHIEUTH
  {0xAF61, 0xCE4A}, //7887 #HANGUL SYLLABLE CHIEUCH YI RIEULPHIEUPH
  {0xAF62, 0xCE4B}, //7888 #HANGUL SYLLABLE CHIEUCH YI RIEULHIEUH
  {0xAF63, 0xCE4C}, //7889 #HANGUL SYLLABLE CHIEUCH YI MIEUM
  {0xAF64, 0xCE4D}, //7890 #HANGUL SYLLABLE CHIEUCH YI PIEUP
  {0xAF65, 0xCE4E}, //7891 #HANGUL SYLLABLE CHIEUCH YI PIEUPSIOS
  {0xAF66, 0xCE4F}, //7892 #HANGUL SYLLABLE CHIEUCH YI SIOS
  {0xAF67, 0xCE50}, //7893 #HANGUL SYLLABLE CHIEUCH YI SSANGSIOS
  {0xAF68, 0xCE51}, //7894 #HANGUL SYLLABLE CHIEUCH YI IEUNG
  {0xAF69, 0xCE52}, //7895 #HANGUL SYLLABLE CHIEUCH YI CIEUC
  {0xAF6A, 0xCE53}, //7896 #HANGUL SYLLABLE CHIEUCH YI CHIEUCH
  {0xAF6B, 0xCE54}, //7897 #HANGUL SYLLABLE CHIEUCH YI KHIEUKH
  {0xAF6C, 0xCE55}, //7898 #HANGUL SYLLABLE CHIEUCH YI THIEUTH
  {0xAF6D, 0xCE56}, //7899 #HANGUL SYLLABLE CHIEUCH YI PHIEUPH
  {0xAF6E, 0xCE57}, //7900 #HANGUL SYLLABLE CHIEUCH YI HIEUH
  {0xAF6F, 0xCE5A}, //7901 #HANGUL SYLLABLE CHIEUCH I SSANGKIYEOK
  {0xAF70, 0xCE5B}, //7902 #HANGUL SYLLABLE CHIEUCH I KIYEOKSIOS
  {0xAF71, 0xCE5D}, //7903 #HANGUL SYLLABLE CHIEUCH I NIEUNCIEUC
  {0xAF72, 0xCE5E}, //7904 #HANGUL SYLLABLE CHIEUCH I NIEUNHIEUH
  {0xAF73, 0xCE62}, //7905 #HANGUL SYLLABLE CHIEUCH I RIEULMIEUM
  {0xAF74, 0xCE63}, //7906 #HANGUL SYLLABLE CHIEUCH I RIEULPIEUP
  {0xAF75, 0xCE64}, //7907 #HANGUL SYLLABLE CHIEUCH I RIEULSIOS
  {0xAF76, 0xCE65}, //7908 #HANGUL SYLLABLE CHIEUCH I RIEULTHIEUTH
  {0xAF77, 0xCE66}, //7909 #HANGUL SYLLABLE CHIEUCH I RIEULPHIEUPH
  {0xAF78, 0xCE67}, //7910 #HANGUL SYLLABLE CHIEUCH I RIEULHIEUH
  {0xAF79, 0xCE6A}, //7911 #HANGUL SYLLABLE CHIEUCH I PIEUPSIOS
  {0xAF7A, 0xCE6C}, //7912 #HANGUL SYLLABLE CHIEUCH I SSANGSIOS
  {0xAF81, 0xCE6E}, //7913 #HANGUL SYLLABLE CHIEUCH I CIEUC
  {0xAF82, 0xCE6F}, //7914 #HANGUL SYLLABLE CHIEUCH I CHIEUCH
  {0xAF83, 0xCE70}, //7915 #HANGUL SYLLABLE CHIEUCH I KHIEUKH
  {0xAF84, 0xCE71}, //7916 #HANGUL SYLLABLE CHIEUCH I THIEUTH
  {0xAF85, 0xCE72}, //7917 #HANGUL SYLLABLE CHIEUCH I PHIEUPH
  {0xAF86, 0xCE73}, //7918 #HANGUL SYLLABLE CHIEUCH I HIEUH
  {0xAF87, 0xCE76}, //7919 #HANGUL SYLLABLE KHIEUKH A SSANGKIYEOK
  {0xAF88, 0xCE77}, //7920 #HANGUL SYLLABLE KHIEUKH A KIYEOKSIOS
  {0xAF89, 0xCE79}, //7921 #HANGUL SYLLABLE KHIEUKH A NIEUNCIEUC
  {0xAF8A, 0xCE7A}, //7922 #HANGUL SYLLABLE KHIEUKH A NIEUNHIEUH
  {0xAF8B, 0xCE7B}, //7923 #HANGUL SYLLABLE KHIEUKH A TIKEUT
  {0xAF8C, 0xCE7D}, //7924 #HANGUL SYLLABLE KHIEUKH A RIEULKIYEOK
  {0xAF8D, 0xCE7E}, //7925 #HANGUL SYLLABLE KHIEUKH A RIEULMIEUM
  {0xAF8E, 0xCE7F}, //7926 #HANGUL SYLLABLE KHIEUKH A RIEULPIEUP
  {0xAF8F, 0xCE80}, //7927 #HANGUL SYLLABLE KHIEUKH A RIEULSIOS
  {0xAF90, 0xCE81}, //7928 #HANGUL SYLLABLE KHIEUKH A RIEULTHIEUTH
  {0xAF91, 0xCE82}, //7929 #HANGUL SYLLABLE KHIEUKH A RIEULPHIEUPH
  {0xAF92, 0xCE83}, //7930 #HANGUL SYLLABLE KHIEUKH A RIEULHIEUH
  {0xAF93, 0xCE86}, //7931 #HANGUL SYLLABLE KHIEUKH A PIEUPSIOS
  {0xAF94, 0xCE88}, //7932 #HANGUL SYLLABLE KHIEUKH A SSANGSIOS
  {0xAF95, 0xCE8A}, //7933 #HANGUL SYLLABLE KHIEUKH A CIEUC
  {0xAF96, 0xCE8B}, //7934 #HANGUL SYLLABLE KHIEUKH A CHIEUCH
  {0xAF97, 0xCE8C}, //7935 #HANGUL SYLLABLE KHIEUKH A KHIEUKH
  {0xAF98, 0xCE8D}, //7936 #HANGUL SYLLABLE KHIEUKH A THIEUTH
  {0xAF99, 0xCE8E}, //7937 #HANGUL SYLLABLE KHIEUKH A PHIEUPH
  {0xAF9A, 0xCE8F}, //7938 #HANGUL SYLLABLE KHIEUKH A HIEUH
  {0xAF9B, 0xCE92}, //7939 #HANGUL SYLLABLE KHIEUKH AE SSANGKIYEOK
  {0xAF9C, 0xCE93}, //7940 #HANGUL SYLLABLE KHIEUKH AE KIYEOKSIOS
  {0xAF9D, 0xCE95}, //7941 #HANGUL SYLLABLE KHIEUKH AE NIEUNCIEUC
  {0xAF9E, 0xCE96}, //7942 #HANGUL SYLLABLE KHIEUKH AE NIEUNHIEUH
  {0xAF9F, 0xCE97}, //7943 #HANGUL SYLLABLE KHIEUKH AE TIKEUT
  {0xAFA0, 0xCE99}, //7944 #HANGUL SYLLABLE KHIEUKH AE RIEULKIYEOK
  {0xB041, 0xCE9A}, //7945 #HANGUL SYLLABLE KHIEUKH AE RIEULMIEUM
  {0xB042, 0xCE9B}, //7946 #HANGUL SYLLABLE KHIEUKH AE RIEULPIEUP
  {0xB043, 0xCE9C}, //7947 #HANGUL SYLLABLE KHIEUKH AE RIEULSIOS
  {0xB044, 0xCE9D}, //7948 #HANGUL SYLLABLE KHIEUKH AE RIEULTHIEUTH
  {0xB045, 0xCE9E}, //7949 #HANGUL SYLLABLE KHIEUKH AE RIEULPHIEUPH
  {0xB046, 0xCE9F}, //7950 #HANGUL SYLLABLE KHIEUKH AE RIEULHIEUH
  {0xB047, 0xCEA2}, //7951 #HANGUL SYLLABLE KHIEUKH AE PIEUPSIOS
  {0xB048, 0xCEA6}, //7952 #HANGUL SYLLABLE KHIEUKH AE CIEUC
  {0xB049, 0xCEA7}, //7953 #HANGUL SYLLABLE KHIEUKH AE CHIEUCH
  {0xB04A, 0xCEA8}, //7954 #HANGUL SYLLABLE KHIEUKH AE KHIEUKH
  {0xB04B, 0xCEA9}, //7955 #HANGUL SYLLABLE KHIEUKH AE THIEUTH
  {0xB04C, 0xCEAA}, //7956 #HANGUL SYLLABLE KHIEUKH AE PHIEUPH
  {0xB04D, 0xCEAB}, //7957 #HANGUL SYLLABLE KHIEUKH AE HIEUH
  {0xB04E, 0xCEAE}, //7958 #HANGUL SYLLABLE KHIEUKH YA SSANGKIYEOK
  {0xB04F, 0xCEAF}, //7959 #HANGUL SYLLABLE KHIEUKH YA KIYEOKSIOS
  {0xB050, 0xCEB0}, //7960 #HANGUL SYLLABLE KHIEUKH YA NIEUN
  {0xB051, 0xCEB1}, //7961 #HANGUL SYLLABLE KHIEUKH YA NIEUNCIEUC
  {0xB052, 0xCEB2}, //7962 #HANGUL SYLLABLE KHIEUKH YA NIEUNHIEUH
  {0xB053, 0xCEB3}, //7963 #HANGUL SYLLABLE KHIEUKH YA TIKEUT
  {0xB054, 0xCEB4}, //7964 #HANGUL SYLLABLE KHIEUKH YA RIEUL
  {0xB055, 0xCEB5}, //7965 #HANGUL SYLLABLE KHIEUKH YA RIEULKIYEOK
  {0xB056, 0xCEB6}, //7966 #HANGUL SYLLABLE KHIEUKH YA RIEULMIEUM
  {0xB057, 0xCEB7}, //7967 #HANGUL SYLLABLE KHIEUKH YA RIEULPIEUP
  {0xB058, 0xCEB8}, //7968 #HANGUL SYLLABLE KHIEUKH YA RIEULSIOS
  {0xB059, 0xCEB9}, //7969 #HANGUL SYLLABLE KHIEUKH YA RIEULTHIEUTH
  {0xB05A, 0xCEBA}, //7970 #HANGUL SYLLABLE KHIEUKH YA RIEULPHIEUPH
  {0xB061, 0xCEBB}, //7971 #HANGUL SYLLABLE KHIEUKH YA RIEULHIEUH
  {0xB062, 0xCEBC}, //7972 #HANGUL SYLLABLE KHIEUKH YA MIEUM
  {0xB063, 0xCEBD}, //7973 #HANGUL SYLLABLE KHIEUKH YA PIEUP
  {0xB064, 0xCEBE}, //7974 #HANGUL SYLLABLE KHIEUKH YA PIEUPSIOS
  {0xB065, 0xCEBF}, //7975 #HANGUL SYLLABLE KHIEUKH YA SIOS
  {0xB066, 0xCEC0}, //7976 #HANGUL SYLLABLE KHIEUKH YA SSANGSIOS
  {0xB067, 0xCEC2}, //7977 #HANGUL SYLLABLE KHIEUKH YA CIEUC
  {0xB068, 0xCEC3}, //7978 #HANGUL SYLLABLE KHIEUKH YA CHIEUCH
  {0xB069, 0xCEC4}, //7979 #HANGUL SYLLABLE KHIEUKH YA KHIEUKH
  {0xB06A, 0xCEC5}, //7980 #HANGUL SYLLABLE KHIEUKH YA THIEUTH
  {0xB06B, 0xCEC6}, //7981 #HANGUL SYLLABLE KHIEUKH YA PHIEUPH
  {0xB06C, 0xCEC7}, //7982 #HANGUL SYLLABLE KHIEUKH YA HIEUH
  {0xB06D, 0xCEC8}, //7983 #HANGUL SYLLABLE KHIEUKH YAE
  {0xB06E, 0xCEC9}, //7984 #HANGUL SYLLABLE KHIEUKH YAE KIYEOK
  {0xB06F, 0xCECA}, //7985 #HANGUL SYLLABLE KHIEUKH YAE SSANGKIYEOK
  {0xB070, 0xCECB}, //7986 #HANGUL SYLLABLE KHIEUKH YAE KIYEOKSIOS
  {0xB071, 0xCECC}, //7987 #HANGUL SYLLABLE KHIEUKH YAE NIEUN
  {0xB072, 0xCECD}, //7988 #HANGUL SYLLABLE KHIEUKH YAE NIEUNCIEUC
  {0xB073, 0xCECE}, //7989 #HANGUL SYLLABLE KHIEUKH YAE NIEUNHIEUH
  {0xB074, 0xCECF}, //7990 #HANGUL SYLLABLE KHIEUKH YAE TIKEUT
  {0xB075, 0xCED0}, //7991 #HANGUL SYLLABLE KHIEUKH YAE RIEUL
  {0xB076, 0xCED1}, //7992 #HANGUL SYLLABLE KHIEUKH YAE RIEULKIYEOK
  {0xB077, 0xCED2}, //7993 #HANGUL SYLLABLE KHIEUKH YAE RIEULMIEUM
  {0xB078, 0xCED3}, //7994 #HANGUL SYLLABLE KHIEUKH YAE RIEULPIEUP
  {0xB079, 0xCED4}, //7995 #HANGUL SYLLABLE KHIEUKH YAE RIEULSIOS
  {0xB07A, 0xCED5}, //7996 #HANGUL SYLLABLE KHIEUKH YAE RIEULTHIEUTH
  {0xB081, 0xCED6}, //7997 #HANGUL SYLLABLE KHIEUKH YAE RIEULPHIEUPH
  {0xB082, 0xCED7}, //7998 #HANGUL SYLLABLE KHIEUKH YAE RIEULHIEUH
  {0xB083, 0xCED8}, //7999 #HANGUL SYLLABLE KHIEUKH YAE MIEUM
  {0xB084, 0xCED9}, //8000 #HANGUL SYLLABLE KHIEUKH YAE PIEUP
  {0xB085, 0xCEDA}, //8001 #HANGUL SYLLABLE KHIEUKH YAE PIEUPSIOS
  {0xB086, 0xCEDB}, //8002 #HANGUL SYLLABLE KHIEUKH YAE SIOS
  {0xB087, 0xCEDC}, //8003 #HANGUL SYLLABLE KHIEUKH YAE SSANGSIOS
  {0xB088, 0xCEDD}, //8004 #HANGUL SYLLABLE KHIEUKH YAE IEUNG
  {0xB089, 0xCEDE}, //8005 #HANGUL SYLLABLE KHIEUKH YAE CIEUC
  {0xB08A, 0xCEDF}, //8006 #HANGUL SYLLABLE KHIEUKH YAE CHIEUCH
  {0xB08B, 0xCEE0}, //8007 #HANGUL SYLLABLE KHIEUKH YAE KHIEUKH
  {0xB08C, 0xCEE1}, //8008 #HANGUL SYLLABLE KHIEUKH YAE THIEUTH
  {0xB08D, 0xCEE2}, //8009 #HANGUL SYLLABLE KHIEUKH YAE PHIEUPH
  {0xB08E, 0xCEE3}, //8010 #HANGUL SYLLABLE KHIEUKH YAE HIEUH
  {0xB08F, 0xCEE6}, //8011 #HANGUL SYLLABLE KHIEUKH EO SSANGKIYEOK
  {0xB090, 0xCEE7}, //8012 #HANGUL SYLLABLE KHIEUKH EO KIYEOKSIOS
  {0xB091, 0xCEE9}, //8013 #HANGUL SYLLABLE KHIEUKH EO NIEUNCIEUC
  {0xB092, 0xCEEA}, //8014 #HANGUL SYLLABLE KHIEUKH EO NIEUNHIEUH
  {0xB093, 0xCEED}, //8015 #HANGUL SYLLABLE KHIEUKH EO RIEULKIYEOK
  {0xB094, 0xCEEE}, //8016 #HANGUL SYLLABLE KHIEUKH EO RIEULMIEUM
  {0xB095, 0xCEEF}, //8017 #HANGUL SYLLABLE KHIEUKH EO RIEULPIEUP
  {0xB096, 0xCEF0}, //8018 #HANGUL SYLLABLE KHIEUKH EO RIEULSIOS
  {0xB097, 0xCEF1}, //8019 #HANGUL SYLLABLE KHIEUKH EO RIEULTHIEUTH
  {0xB098, 0xCEF2}, //8020 #HANGUL SYLLABLE KHIEUKH EO RIEULPHIEUPH
  {0xB099, 0xCEF3}, //8021 #HANGUL SYLLABLE KHIEUKH EO RIEULHIEUH
  {0xB09A, 0xCEF6}, //8022 #HANGUL SYLLABLE KHIEUKH EO PIEUPSIOS
  {0xB09B, 0xCEFA}, //8023 #HANGUL SYLLABLE KHIEUKH EO CIEUC
  {0xB09C, 0xCEFB}, //8024 #HANGUL SYLLABLE KHIEUKH EO CHIEUCH
  {0xB09D, 0xCEFC}, //8025 #HANGUL SYLLABLE KHIEUKH EO KHIEUKH
  {0xB09E, 0xCEFD}, //8026 #HANGUL SYLLABLE KHIEUKH EO THIEUTH
  {0xB09F, 0xCEFE}, //8027 #HANGUL SYLLABLE KHIEUKH EO PHIEUPH
  {0xB0A0, 0xCEFF}, //8028 #HANGUL SYLLABLE KHIEUKH EO HIEUH
  {0xB0A1, 0xAC00}, //8029 #HANGUL SYLLABLE KIYEOK A
  {0xB0A2, 0xAC01}, //8030 #HANGUL SYLLABLE KIYEOK A KIYEOK
  {0xB0A3, 0xAC04}, //8031 #HANGUL SYLLABLE KIYEOK A NIEUN
  {0xB0A4, 0xAC07}, //8032 #HANGUL SYLLABLE KIYEOK A TIKEUT
  {0xB0A5, 0xAC08}, //8033 #HANGUL SYLLABLE KIYEOK A RIEUL
  {0xB0A6, 0xAC09}, //8034 #HANGUL SYLLABLE KIYEOK A RIEULKIYEOK
  {0xB0A7, 0xAC0A}, //8035 #HANGUL SYLLABLE KIYEOK A RIEULMIEUM
  {0xB0A8, 0xAC10}, //8036 #HANGUL SYLLABLE KIYEOK A MIEUM
  {0xB0A9, 0xAC11}, //8037 #HANGUL SYLLABLE KIYEOK A PIEUP
  {0xB0AA, 0xAC12}, //8038 #HANGUL SYLLABLE KIYEOK A PIEUPSIOS
  {0xB0AB, 0xAC13}, //8039 #HANGUL SYLLABLE KIYEOK A SIOS
  {0xB0AC, 0xAC14}, //8040 #HANGUL SYLLABLE KIYEOK A SSANGSIOS
  {0xB0AD, 0xAC15}, //8041 #HANGUL SYLLABLE KIYEOK A IEUNG
  {0xB0AE, 0xAC16}, //8042 #HANGUL SYLLABLE KIYEOK A CIEUC
  {0xB0AF, 0xAC17}, //8043 #HANGUL SYLLABLE KIYEOK A CHIEUCH
  {0xB0B0, 0xAC19}, //8044 #HANGUL SYLLABLE KIYEOK A THIEUTH
  {0xB0B1, 0xAC1A}, //8045 #HANGUL SYLLABLE KIYEOK A PHIEUPH
  {0xB0B2, 0xAC1B}, //8046 #HANGUL SYLLABLE KIYEOK A HIEUH
  {0xB0B3, 0xAC1C}, //8047 #HANGUL SYLLABLE KIYEOK AE
  {0xB0B4, 0xAC1D}, //8048 #HANGUL SYLLABLE KIYEOK AE KIYEOK
  {0xB0B5, 0xAC20}, //8049 #HANGUL SYLLABLE KIYEOK AE NIEUN
  {0xB0B6, 0xAC24}, //8050 #HANGUL SYLLABLE KIYEOK AE RIEUL
  {0xB0B7, 0xAC2C}, //8051 #HANGUL SYLLABLE KIYEOK AE MIEUM
  {0xB0B8, 0xAC2D}, //8052 #HANGUL SYLLABLE KIYEOK AE PIEUP
  {0xB0B9, 0xAC2F}, //8053 #HANGUL SYLLABLE KIYEOK AE SIOS
  {0xB0BA, 0xAC30}, //8054 #HANGUL SYLLABLE KIYEOK AE SSANGSIOS
  {0xB0BB, 0xAC31}, //8055 #HANGUL SYLLABLE KIYEOK AE IEUNG
  {0xB0BC, 0xAC38}, //8056 #HANGUL SYLLABLE KIYEOK YA
  {0xB0BD, 0xAC39}, //8057 #HANGUL SYLLABLE KIYEOK YA KIYEOK
  {0xB0BE, 0xAC3C}, //8058 #HANGUL SYLLABLE KIYEOK YA NIEUN
  {0xB0BF, 0xAC40}, //8059 #HANGUL SYLLABLE KIYEOK YA RIEUL
  {0xB0C0, 0xAC4B}, //8060 #HANGUL SYLLABLE KIYEOK YA SIOS
  {0xB0C1, 0xAC4D}, //8061 #HANGUL SYLLABLE KIYEOK YA IEUNG
  {0xB0C2, 0xAC54}, //8062 #HANGUL SYLLABLE KIYEOK YAE
  {0xB0C3, 0xAC58}, //8063 #HANGUL SYLLABLE KIYEOK YAE NIEUN
  {0xB0C4, 0xAC5C}, //8064 #HANGUL SYLLABLE KIYEOK YAE RIEUL
  {0xB0C5, 0xAC70}, //8065 #HANGUL SYLLABLE KIYEOK EO
  {0xB0C6, 0xAC71}, //8066 #HANGUL SYLLABLE KIYEOK EO KIYEOK
  {0xB0C7, 0xAC74}, //8067 #HANGUL SYLLABLE KIYEOK EO NIEUN
  {0xB0C8, 0xAC77}, //8068 #HANGUL SYLLABLE KIYEOK EO TIKEUT
  {0xB0C9, 0xAC78}, //8069 #HANGUL SYLLABLE KIYEOK EO RIEUL
  {0xB0CA, 0xAC7A}, //8070 #HANGUL SYLLABLE KIYEOK EO RIEULMIEUM
  {0xB0CB, 0xAC80}, //8071 #HANGUL SYLLABLE KIYEOK EO MIEUM
  {0xB0CC, 0xAC81}, //8072 #HANGUL SYLLABLE KIYEOK EO PIEUP
  {0xB0CD, 0xAC83}, //8073 #HANGUL SYLLABLE KIYEOK EO SIOS
  {0xB0CE, 0xAC84}, //8074 #HANGUL SYLLABLE KIYEOK EO SSANGSIOS
  {0xB0CF, 0xAC85}, //8075 #HANGUL SYLLABLE KIYEOK EO IEUNG
  {0xB0D0, 0xAC86}, //8076 #HANGUL SYLLABLE KIYEOK EO CIEUC
  {0xB0D1, 0xAC89}, //8077 #HANGUL SYLLABLE KIYEOK EO THIEUTH
  {0xB0D2, 0xAC8A}, //8078 #HANGUL SYLLABLE KIYEOK EO PHIEUPH
  {0xB0D3, 0xAC8B}, //8079 #HANGUL SYLLABLE KIYEOK EO HIEUH
  {0xB0D4, 0xAC8C}, //8080 #HANGUL SYLLABLE KIYEOK E
  {0xB0D5, 0xAC90}, //8081 #HANGUL SYLLABLE KIYEOK E NIEUN
  {0xB0D6, 0xAC94}, //8082 #HANGUL SYLLABLE KIYEOK E RIEUL
  {0xB0D7, 0xAC9C}, //8083 #HANGUL SYLLABLE KIYEOK E MIEUM
  {0xB0D8, 0xAC9D}, //8084 #HANGUL SYLLABLE KIYEOK E PIEUP
  {0xB0D9, 0xAC9F}, //8085 #HANGUL SYLLABLE KIYEOK E SIOS
  {0xB0DA, 0xACA0}, //8086 #HANGUL SYLLABLE KIYEOK E SSANGSIOS
  {0xB0DB, 0xACA1}, //8087 #HANGUL SYLLABLE KIYEOK E IEUNG
  {0xB0DC, 0xACA8}, //8088 #HANGUL SYLLABLE KIYEOK YEO
  {0xB0DD, 0xACA9}, //8089 #HANGUL SYLLABLE KIYEOK YEO KIYEOK
  {0xB0DE, 0xACAA}, //8090 #HANGUL SYLLABLE KIYEOK YEO SSANGKIYEOK
  {0xB0DF, 0xACAC}, //8091 #HANGUL SYLLABLE KIYEOK YEO NIEUN
  {0xB0E0, 0xACAF}, //8092 #HANGUL SYLLABLE KIYEOK YEO TIKEUT
  {0xB0E1, 0xACB0}, //8093 #HANGUL SYLLABLE KIYEOK YEO RIEUL
  {0xB0E2, 0xACB8}, //8094 #HANGUL SYLLABLE KIYEOK YEO MIEUM
  {0xB0E3, 0xACB9}, //8095 #HANGUL SYLLABLE KIYEOK YEO PIEUP
  {0xB0E4, 0xACBB}, //8096 #HANGUL SYLLABLE KIYEOK YEO SIOS
  {0xB0E5, 0xACBC}, //8097 #HANGUL SYLLABLE KIYEOK YEO SSANGSIOS
  {0xB0E6, 0xACBD}, //8098 #HANGUL SYLLABLE KIYEOK YEO IEUNG
  {0xB0E7, 0xACC1}, //8099 #HANGUL SYLLABLE KIYEOK YEO THIEUTH
  {0xB0E8, 0xACC4}, //8100 #HANGUL SYLLABLE KIYEOK YE
  {0xB0E9, 0xACC8}, //8101 #HANGUL SYLLABLE KIYEOK YE NIEUN
  {0xB0EA, 0xACCC}, //8102 #HANGUL SYLLABLE KIYEOK YE RIEUL
  {0xB0EB, 0xACD5}, //8103 #HANGUL SYLLABLE KIYEOK YE PIEUP
  {0xB0EC, 0xACD7}, //8104 #HANGUL SYLLABLE KIYEOK YE SIOS
  {0xB0ED, 0xACE0}, //8105 #HANGUL SYLLABLE KIYEOK O
  {0xB0EE, 0xACE1}, //8106 #HANGUL SYLLABLE KIYEOK O KIYEOK
  {0xB0EF, 0xACE4}, //8107 #HANGUL SYLLABLE KIYEOK O NIEUN
  {0xB0F0, 0xACE7}, //8108 #HANGUL SYLLABLE KIYEOK O TIKEUT
  {0xB0F1, 0xACE8}, //8109 #HANGUL SYLLABLE KIYEOK O RIEUL
  {0xB0F2, 0xACEA}, //8110 #HANGUL SYLLABLE KIYEOK O RIEULMIEUM
  {0xB0F3, 0xACEC}, //8111 #HANGUL SYLLABLE KIYEOK O RIEULSIOS
  {0xB0F4, 0xACEF}, //8112 #HANGUL SYLLABLE KIYEOK O RIEULHIEUH
  {0xB0F5, 0xACF0}, //8113 #HANGUL SYLLABLE KIYEOK O MIEUM
  {0xB0F6, 0xACF1}, //8114 #HANGUL SYLLABLE KIYEOK O PIEUP
  {0xB0F7, 0xACF3}, //8115 #HANGUL SYLLABLE KIYEOK O SIOS
  {0xB0F8, 0xACF5}, //8116 #HANGUL SYLLABLE KIYEOK O IEUNG
  {0xB0F9, 0xACF6}, //8117 #HANGUL SYLLABLE KIYEOK O CIEUC
  {0xB0FA, 0xACFC}, //8118 #HANGUL SYLLABLE KIYEOK WA
  {0xB0FB, 0xACFD}, //8119 #HANGUL SYLLABLE KIYEOK WA KIYEOK
  {0xB0FC, 0xAD00}, //8120 #HANGUL SYLLABLE KIYEOK WA NIEUN
  {0xB0FD, 0xAD04}, //8121 #HANGUL SYLLABLE KIYEOK WA RIEUL
  {0xB0FE, 0xAD06}, //8122 #HANGUL SYLLABLE KIYEOK WA RIEULMIEUM
  {0xB141, 0xCF02}, //8123 #HANGUL SYLLABLE KHIEUKH E SSANGKIYEOK
  {0xB142, 0xCF03}, //8124 #HANGUL SYLLABLE KHIEUKH E KIYEOKSIOS
  {0xB143, 0xCF05}, //8125 #HANGUL SYLLABLE KHIEUKH E NIEUNCIEUC
  {0xB144, 0xCF06}, //8126 #HANGUL SYLLABLE KHIEUKH E NIEUNHIEUH
  {0xB145, 0xCF07}, //8127 #HANGUL SYLLABLE KHIEUKH E TIKEUT
  {0xB146, 0xCF09}, //8128 #HANGUL SYLLABLE KHIEUKH E RIEULKIYEOK
  {0xB147, 0xCF0A}, //8129 #HANGUL SYLLABLE KHIEUKH E RIEULMIEUM
  {0xB148, 0xCF0B}, //8130 #HANGUL SYLLABLE KHIEUKH E RIEULPIEUP
  {0xB149, 0xCF0C}, //8131 #HANGUL SYLLABLE KHIEUKH E RIEULSIOS
  {0xB14A, 0xCF0D}, //8132 #HANGUL SYLLABLE KHIEUKH E RIEULTHIEUTH
  {0xB14B, 0xCF0E}, //8133 #HANGUL SYLLABLE KHIEUKH E RIEULPHIEUPH
  {0xB14C, 0xCF0F}, //8134 #HANGUL SYLLABLE KHIEUKH E RIEULHIEUH
  {0xB14D, 0xCF12}, //8135 #HANGUL SYLLABLE KHIEUKH E PIEUPSIOS
  {0xB14E, 0xCF14}, //8136 #HANGUL SYLLABLE KHIEUKH E SSANGSIOS
  {0xB14F, 0xCF16}, //8137 #HANGUL SYLLABLE KHIEUKH E CIEUC
  {0xB150, 0xCF17}, //8138 #HANGUL SYLLABLE KHIEUKH E CHIEUCH
  {0xB151, 0xCF18}, //8139 #HANGUL SYLLABLE KHIEUKH E KHIEUKH
  {0xB152, 0xCF19}, //8140 #HANGUL SYLLABLE KHIEUKH E THIEUTH
  {0xB153, 0xCF1A}, //8141 #HANGUL SYLLABLE KHIEUKH E PHIEUPH
  {0xB154, 0xCF1B}, //8142 #HANGUL SYLLABLE KHIEUKH E HIEUH
  {0xB155, 0xCF1D}, //8143 #HANGUL SYLLABLE KHIEUKH YEO KIYEOK
  {0xB156, 0xCF1E}, //8144 #HANGUL SYLLABLE KHIEUKH YEO SSANGKIYEOK
  {0xB157, 0xCF1F}, //8145 #HANGUL SYLLABLE KHIEUKH YEO KIYEOKSIOS
  {0xB158, 0xCF21}, //8146 #HANGUL SYLLABLE KHIEUKH YEO NIEUNCIEUC
  {0xB159, 0xCF22}, //8147 #HANGUL SYLLABLE KHIEUKH YEO NIEUNHIEUH
  {0xB15A, 0xCF23}, //8148 #HANGUL SYLLABLE KHIEUKH YEO TIKEUT
  {0xB161, 0xCF25}, //8149 #HANGUL SYLLABLE KHIEUKH YEO RIEULKIYEOK
  {0xB162, 0xCF26}, //8150 #HANGUL SYLLABLE KHIEUKH YEO RIEULMIEUM
  {0xB163, 0xCF27}, //8151 #HANGUL SYLLABLE KHIEUKH YEO RIEULPIEUP
  {0xB164, 0xCF28}, //8152 #HANGUL SYLLABLE KHIEUKH YEO RIEULSIOS
  {0xB165, 0xCF29}, //8153 #HANGUL SYLLABLE KHIEUKH YEO RIEULTHIEUTH
  {0xB166, 0xCF2A}, //8154 #HANGUL SYLLABLE KHIEUKH YEO RIEULPHIEUPH
  {0xB167, 0xCF2B}, //8155 #HANGUL SYLLABLE KHIEUKH YEO RIEULHIEUH
  {0xB168, 0xCF2E}, //8156 #HANGUL SYLLABLE KHIEUKH YEO PIEUPSIOS
  {0xB169, 0xCF32}, //8157 #HANGUL SYLLABLE KHIEUKH YEO CIEUC
  {0xB16A, 0xCF33}, //8158 #HANGUL SYLLABLE KHIEUKH YEO CHIEUCH
  {0xB16B, 0xCF34}, //8159 #HANGUL SYLLABLE KHIEUKH YEO KHIEUKH
  {0xB16C, 0xCF35}, //8160 #HANGUL SYLLABLE KHIEUKH YEO THIEUTH
  {0xB16D, 0xCF36}, //8161 #HANGUL SYLLABLE KHIEUKH YEO PHIEUPH
  {0xB16E, 0xCF37}, //8162 #HANGUL SYLLABLE KHIEUKH YEO HIEUH
  {0xB16F, 0xCF39}, //8163 #HANGUL SYLLABLE KHIEUKH YE KIYEOK
  {0xB170, 0xCF3A}, //8164 #HANGUL SYLLABLE KHIEUKH YE SSANGKIYEOK
  {0xB171, 0xCF3B}, //8165 #HANGUL SYLLABLE KHIEUKH YE KIYEOKSIOS
  {0xB172, 0xCF3C}, //8166 #HANGUL SYLLABLE KHIEUKH YE NIEUN
  {0xB173, 0xCF3D}, //8167 #HANGUL SYLLABLE KHIEUKH YE NIEUNCIEUC
  {0xB174, 0xCF3E}, //8168 #HANGUL SYLLABLE KHIEUKH YE NIEUNHIEUH
  {0xB175, 0xCF3F}, //8169 #HANGUL SYLLABLE KHIEUKH YE TIKEUT
  {0xB176, 0xCF40}, //8170 #HANGUL SYLLABLE KHIEUKH YE RIEUL
  {0xB177, 0xCF41}, //8171 #HANGUL SYLLABLE KHIEUKH YE RIEULKIYEOK
  {0xB178, 0xCF42}, //8172 #HANGUL SYLLABLE KHIEUKH YE RIEULMIEUM
  {0xB179, 0xCF43}, //8173 #HANGUL SYLLABLE KHIEUKH YE RIEULPIEUP
  {0xB17A, 0xCF44}, //8174 #HANGUL SYLLABLE KHIEUKH YE RIEULSIOS
  {0xB181, 0xCF45}, //8175 #HANGUL SYLLABLE KHIEUKH YE RIEULTHIEUTH
  {0xB182, 0xCF46}, //8176 #HANGUL SYLLABLE KHIEUKH YE RIEULPHIEUPH
  {0xB183, 0xCF47}, //8177 #HANGUL SYLLABLE KHIEUKH YE RIEULHIEUH
  {0xB184, 0xCF48}, //8178 #HANGUL SYLLABLE KHIEUKH YE MIEUM
  {0xB185, 0xCF49}, //8179 #HANGUL SYLLABLE KHIEUKH YE PIEUP
  {0xB186, 0xCF4A}, //8180 #HANGUL SYLLABLE KHIEUKH YE PIEUPSIOS
  {0xB187, 0xCF4B}, //8181 #HANGUL SYLLABLE KHIEUKH YE SIOS
  {0xB188, 0xCF4C}, //8182 #HANGUL SYLLABLE KHIEUKH YE SSANGSIOS
  {0xB189, 0xCF4D}, //8183 #HANGUL SYLLABLE KHIEUKH YE IEUNG
  {0xB18A, 0xCF4E}, //8184 #HANGUL SYLLABLE KHIEUKH YE CIEUC
  {0xB18B, 0xCF4F}, //8185 #HANGUL SYLLABLE KHIEUKH YE CHIEUCH
  {0xB18C, 0xCF50}, //8186 #HANGUL SYLLABLE KHIEUKH YE KHIEUKH
  {0xB18D, 0xCF51}, //8187 #HANGUL SYLLABLE KHIEUKH YE THIEUTH
  {0xB18E, 0xCF52}, //8188 #HANGUL SYLLABLE KHIEUKH YE PHIEUPH
  {0xB18F, 0xCF53}, //8189 #HANGUL SYLLABLE KHIEUKH YE HIEUH
  {0xB190, 0xCF56}, //8190 #HANGUL SYLLABLE KHIEUKH O SSANGKIYEOK
  {0xB191, 0xCF57}, //8191 #HANGUL SYLLABLE KHIEUKH O KIYEOKSIOS
  {0xB192, 0xCF59}, //8192 #HANGUL SYLLABLE KHIEUKH O NIEUNCIEUC
  {0xB193, 0xCF5A}, //8193 #HANGUL SYLLABLE KHIEUKH O NIEUNHIEUH
  {0xB194, 0xCF5B}, //8194 #HANGUL SYLLABLE KHIEUKH O TIKEUT
  {0xB195, 0xCF5D}, //8195 #HANGUL SYLLABLE KHIEUKH O RIEULKIYEOK
  {0xB196, 0xCF5E}, //8196 #HANGUL SYLLABLE KHIEUKH O RIEULMIEUM
  {0xB197, 0xCF5F}, //8197 #HANGUL SYLLABLE KHIEUKH O RIEULPIEUP
  {0xB198, 0xCF60}, //8198 #HANGUL SYLLABLE KHIEUKH O RIEULSIOS
  {0xB199, 0xCF61}, //8199 #HANGUL SYLLABLE KHIEUKH O RIEULTHIEUTH
  {0xB19A, 0xCF62}, //8200 #HANGUL SYLLABLE KHIEUKH O RIEULPHIEUPH
  {0xB19B, 0xCF63}, //8201 #HANGUL SYLLABLE KHIEUKH O RIEULHIEUH
  {0xB19C, 0xCF66}, //8202 #HANGUL SYLLABLE KHIEUKH O PIEUPSIOS
  {0xB19D, 0xCF68}, //8203 #HANGUL SYLLABLE KHIEUKH O SSANGSIOS
  {0xB19E, 0xCF6A}, //8204 #HANGUL SYLLABLE KHIEUKH O CIEUC
  {0xB19F, 0xCF6B}, //8205 #HANGUL SYLLABLE KHIEUKH O CHIEUCH
  {0xB1A0, 0xCF6C}, //8206 #HANGUL SYLLABLE KHIEUKH O KHIEUKH
  {0xB1A1, 0xAD0C}, //8207 #HANGUL SYLLABLE KIYEOK WA MIEUM
  {0xB1A2, 0xAD0D}, //8208 #HANGUL SYLLABLE KIYEOK WA PIEUP
  {0xB1A3, 0xAD0F}, //8209 #HANGUL SYLLABLE KIYEOK WA SIOS
  {0xB1A4, 0xAD11}, //8210 #HANGUL SYLLABLE KIYEOK WA IEUNG
  {0xB1A5, 0xAD18}, //8211 #HANGUL SYLLABLE KIYEOK WAE
  {0xB1A6, 0xAD1C}, //8212 #HANGUL SYLLABLE KIYEOK WAE NIEUN
  {0xB1A7, 0xAD20}, //8213 #HANGUL SYLLABLE KIYEOK WAE RIEUL
  {0xB1A8, 0xAD29}, //8214 #HANGUL SYLLABLE KIYEOK WAE PIEUP
  {0xB1A9, 0xAD2C}, //8215 #HANGUL SYLLABLE KIYEOK WAE SSANGSIOS
  {0xB1AA, 0xAD2D}, //8216 #HANGUL SYLLABLE KIYEOK WAE IEUNG
  {0xB1AB, 0xAD34}, //8217 #HANGUL SYLLABLE KIYEOK OE
  {0xB1AC, 0xAD35}, //8218 #HANGUL SYLLABLE KIYEOK OE KIYEOK
  {0xB1AD, 0xAD38}, //8219 #HANGUL SYLLABLE KIYEOK OE NIEUN
  {0xB1AE, 0xAD3C}, //8220 #HANGUL SYLLABLE KIYEOK OE RIEUL
  {0xB1AF, 0xAD44}, //8221 #HANGUL SYLLABLE KIYEOK OE MIEUM
  {0xB1B0, 0xAD45}, //8222 #HANGUL SYLLABLE KIYEOK OE PIEUP
  {0xB1B1, 0xAD47}, //8223 #HANGUL SYLLABLE KIYEOK OE SIOS
  {0xB1B2, 0xAD49}, //8224 #HANGUL SYLLABLE KIYEOK OE IEUNG
  {0xB1B3, 0xAD50}, //8225 #HANGUL SYLLABLE KIYEOK YO
  {0xB1B4, 0xAD54}, //8226 #HANGUL SYLLABLE KIYEOK YO NIEUN
  {0xB1B5, 0xAD58}, //8227 #HANGUL SYLLABLE KIYEOK YO RIEUL
  {0xB1B6, 0xAD61}, //8228 #HANGUL SYLLABLE KIYEOK YO PIEUP
  {0xB1B7, 0xAD63}, //8229 #HANGUL SYLLABLE KIYEOK YO SIOS
  {0xB1B8, 0xAD6C}, //8230 #HANGUL SYLLABLE KIYEOK U
  {0xB1B9, 0xAD6D}, //8231 #HANGUL SYLLABLE KIYEOK U KIYEOK
  {0xB1BA, 0xAD70}, //8232 #HANGUL SYLLABLE KIYEOK U NIEUN
  {0xB1BB, 0xAD73}, //8233 #HANGUL SYLLABLE KIYEOK U TIKEUT
  {0xB1BC, 0xAD74}, //8234 #HANGUL SYLLABLE KIYEOK U RIEUL
  {0xB1BD, 0xAD75}, //8235 #HANGUL SYLLABLE KIYEOK U RIEULKIYEOK
  {0xB1BE, 0xAD76}, //8236 #HANGUL SYLLABLE KIYEOK U RIEULMIEUM
  {0xB1BF, 0xAD7B}, //8237 #HANGUL SYLLABLE KIYEOK U RIEULHIEUH
  {0xB1C0, 0xAD7C}, //8238 #HANGUL SYLLABLE KIYEOK U MIEUM
  {0xB1C1, 0xAD7D}, //8239 #HANGUL SYLLABLE KIYEOK U PIEUP
  {0xB1C2, 0xAD7F}, //8240 #HANGUL SYLLABLE KIYEOK U SIOS
  {0xB1C3, 0xAD81}, //8241 #HANGUL SYLLABLE KIYEOK U IEUNG
  {0xB1C4, 0xAD82}, //8242 #HANGUL SYLLABLE KIYEOK U CIEUC
  {0xB1C5, 0xAD88}, //8243 #HANGUL SYLLABLE KIYEOK WEO
  {0xB1C6, 0xAD89}, //8244 #HANGUL SYLLABLE KIYEOK WEO KIYEOK
  {0xB1C7, 0xAD8C}, //8245 #HANGUL SYLLABLE KIYEOK WEO NIEUN
  {0xB1C8, 0xAD90}, //8246 #HANGUL SYLLABLE KIYEOK WEO RIEUL
  {0xB1C9, 0xAD9C}, //8247 #HANGUL SYLLABLE KIYEOK WEO SSANGSIOS
  {0xB1CA, 0xAD9D}, //8248 #HANGUL SYLLABLE KIYEOK WEO IEUNG
  {0xB1CB, 0xADA4}, //8249 #HANGUL SYLLABLE KIYEOK WE
  {0xB1CC, 0xADB7}, //8250 #HANGUL SYLLABLE KIYEOK WE SIOS
  {0xB1CD, 0xADC0}, //8251 #HANGUL SYLLABLE KIYEOK WI
  {0xB1CE, 0xADC1}, //8252 #HANGUL SYLLABLE KIYEOK WI KIYEOK
  {0xB1CF, 0xADC4}, //8253 #HANGUL SYLLABLE KIYEOK WI NIEUN
  {0xB1D0, 0xADC8}, //8254 #HANGUL SYLLABLE KIYEOK WI RIEUL
  {0xB1D1, 0xADD0}, //8255 #HANGUL SYLLABLE KIYEOK WI MIEUM
  {0xB1D2, 0xADD1}, //8256 #HANGUL SYLLABLE KIYEOK WI PIEUP
  {0xB1D3, 0xADD3}, //8257 #HANGUL SYLLABLE KIYEOK WI SIOS
  {0xB1D4, 0xADDC}, //8258 #HANGUL SYLLABLE KIYEOK YU
  {0xB1D5, 0xADE0}, //8259 #HANGUL SYLLABLE KIYEOK YU NIEUN
  {0xB1D6, 0xADE4}, //8260 #HANGUL SYLLABLE KIYEOK YU RIEUL
  {0xB1D7, 0xADF8}, //8261 #HANGUL SYLLABLE KIYEOK EU
  {0xB1D8, 0xADF9}, //8262 #HANGUL SYLLABLE KIYEOK EU KIYEOK
  {0xB1D9, 0xADFC}, //8263 #HANGUL SYLLABLE KIYEOK EU NIEUN
  {0xB1DA, 0xADFF}, //8264 #HANGUL SYLLABLE KIYEOK EU TIKEUT
  {0xB1DB, 0xAE00}, //8265 #HANGUL SYLLABLE KIYEOK EU RIEUL
  {0xB1DC, 0xAE01}, //8266 #HANGUL SYLLABLE KIYEOK EU RIEULKIYEOK
  {0xB1DD, 0xAE08}, //8267 #HANGUL SYLLABLE KIYEOK EU MIEUM
  {0xB1DE, 0xAE09}, //8268 #HANGUL SYLLABLE KIYEOK EU PIEUP
  {0xB1DF, 0xAE0B}, //8269 #HANGUL SYLLABLE KIYEOK EU SIOS
  {0xB1E0, 0xAE0D}, //8270 #HANGUL SYLLABLE KIYEOK EU IEUNG
  {0xB1E1, 0xAE14}, //8271 #HANGUL SYLLABLE KIYEOK YI
  {0xB1E2, 0xAE30}, //8272 #HANGUL SYLLABLE KIYEOK I
  {0xB1E3, 0xAE31}, //8273 #HANGUL SYLLABLE KIYEOK I KIYEOK
  {0xB1E4, 0xAE34}, //8274 #HANGUL SYLLABLE KIYEOK I NIEUN
  {0xB1E5, 0xAE37}, //8275 #HANGUL SYLLABLE KIYEOK I TIKEUT
  {0xB1E6, 0xAE38}, //8276 #HANGUL SYLLABLE KIYEOK I RIEUL
  {0xB1E7, 0xAE3A}, //8277 #HANGUL SYLLABLE KIYEOK I RIEULMIEUM
  {0xB1E8, 0xAE40}, //8278 #HANGUL SYLLABLE KIYEOK I MIEUM
  {0xB1E9, 0xAE41}, //8279 #HANGUL SYLLABLE KIYEOK I PIEUP
  {0xB1EA, 0xAE43}, //8280 #HANGUL SYLLABLE KIYEOK I SIOS
  {0xB1EB, 0xAE45}, //8281 #HANGUL SYLLABLE KIYEOK I IEUNG
  {0xB1EC, 0xAE46}, //8282 #HANGUL SYLLABLE KIYEOK I CIEUC
  {0xB1ED, 0xAE4A}, //8283 #HANGUL SYLLABLE KIYEOK I PHIEUPH
  {0xB1EE, 0xAE4C}, //8284 #HANGUL SYLLABLE SSANGKIYEOK A
  {0xB1EF, 0xAE4D}, //8285 #HANGUL SYLLABLE SSANGKIYEOK A KIYEOK
  {0xB1F0, 0xAE4E}, //8286 #HANGUL SYLLABLE SSANGKIYEOK A SSANGKIYEOK
  {0xB1F1, 0xAE50}, //8287 #HANGUL SYLLABLE SSANGKIYEOK A NIEUN
  {0xB1F2, 0xAE54}, //8288 #HANGUL SYLLABLE SSANGKIYEOK A RIEUL
  {0xB1F3, 0xAE56}, //8289 #HANGUL SYLLABLE SSANGKIYEOK A RIEULMIEUM
  {0xB1F4, 0xAE5C}, //8290 #HANGUL SYLLABLE SSANGKIYEOK A MIEUM
  {0xB1F5, 0xAE5D}, //8291 #HANGUL SYLLABLE SSANGKIYEOK A PIEUP
  {0xB1F6, 0xAE5F}, //8292 #HANGUL SYLLABLE SSANGKIYEOK A SIOS
  {0xB1F7, 0xAE60}, //8293 #HANGUL SYLLABLE SSANGKIYEOK A SSANGSIOS
  {0xB1F8, 0xAE61}, //8294 #HANGUL SYLLABLE SSANGKIYEOK A IEUNG
  {0xB1F9, 0xAE65}, //8295 #HANGUL SYLLABLE SSANGKIYEOK A THIEUTH
  {0xB1FA, 0xAE68}, //8296 #HANGUL SYLLABLE SSANGKIYEOK AE
  {0xB1FB, 0xAE69}, //8297 #HANGUL SYLLABLE SSANGKIYEOK AE KIYEOK
  {0xB1FC, 0xAE6C}, //8298 #HANGUL SYLLABLE SSANGKIYEOK AE NIEUN
  {0xB1FD, 0xAE70}, //8299 #HANGUL SYLLABLE SSANGKIYEOK AE RIEUL
  {0xB1FE, 0xAE78}, //8300 #HANGUL SYLLABLE SSANGKIYEOK AE MIEUM
  {0xB241, 0xCF6D}, //8301 #HANGUL SYLLABLE KHIEUKH O THIEUTH
  {0xB242, 0xCF6E}, //8302 #HANGUL SYLLABLE KHIEUKH O PHIEUPH
  {0xB243, 0xCF6F}, //8303 #HANGUL SYLLABLE KHIEUKH O HIEUH
  {0xB244, 0xCF72}, //8304 #HANGUL SYLLABLE KHIEUKH WA SSANGKIYEOK
  {0xB245, 0xCF73}, //8305 #HANGUL SYLLABLE KHIEUKH WA KIYEOKSIOS
  {0xB246, 0xCF75}, //8306 #HANGUL SYLLABLE KHIEUKH WA NIEUNCIEUC
  {0xB247, 0xCF76}, //8307 #HANGUL SYLLABLE KHIEUKH WA NIEUNHIEUH
  {0xB248, 0xCF77}, //8308 #HANGUL SYLLABLE KHIEUKH WA TIKEUT
  {0xB249, 0xCF79}, //8309 #HANGUL SYLLABLE KHIEUKH WA RIEULKIYEOK
  {0xB24A, 0xCF7A}, //8310 #HANGUL SYLLABLE KHIEUKH WA RIEULMIEUM
  {0xB24B, 0xCF7B}, //8311 #HANGUL SYLLABLE KHIEUKH WA RIEULPIEUP
  {0xB24C, 0xCF7C}, //8312 #HANGUL SYLLABLE KHIEUKH WA RIEULSIOS
  {0xB24D, 0xCF7D}, //8313 #HANGUL SYLLABLE KHIEUKH WA RIEULTHIEUTH
  {0xB24E, 0xCF7E}, //8314 #HANGUL SYLLABLE KHIEUKH WA RIEULPHIEUPH
  {0xB24F, 0xCF7F}, //8315 #HANGUL SYLLABLE KHIEUKH WA RIEULHIEUH
  {0xB250, 0xCF81}, //8316 #HANGUL SYLLABLE KHIEUKH WA PIEUP
  {0xB251, 0xCF82}, //8317 #HANGUL SYLLABLE KHIEUKH WA PIEUPSIOS
  {0xB252, 0xCF83}, //8318 #HANGUL SYLLABLE KHIEUKH WA SIOS
  {0xB253, 0xCF84}, //8319 #HANGUL SYLLABLE KHIEUKH WA SSANGSIOS
  {0xB254, 0xCF86}, //8320 #HANGUL SYLLABLE KHIEUKH WA CIEUC
  {0xB255, 0xCF87}, //8321 #HANGUL SYLLABLE KHIEUKH WA CHIEUCH
  {0xB256, 0xCF88}, //8322 #HANGUL SYLLABLE KHIEUKH WA KHIEUKH
  {0xB257, 0xCF89}, //8323 #HANGUL SYLLABLE KHIEUKH WA THIEUTH
  {0xB258, 0xCF8A}, //8324 #HANGUL SYLLABLE KHIEUKH WA PHIEUPH
  {0xB259, 0xCF8B}, //8325 #HANGUL SYLLABLE KHIEUKH WA HIEUH
  {0xB25A, 0xCF8D}, //8326 #HANGUL SYLLABLE KHIEUKH WAE KIYEOK
  {0xB261, 0xCF8E}, //8327 #HANGUL SYLLABLE KHIEUKH WAE SSANGKIYEOK
  {0xB262, 0xCF8F}, //8328 #HANGUL SYLLABLE KHIEUKH WAE KIYEOKSIOS
  {0xB263, 0xCF90}, //8329 #HANGUL SYLLABLE KHIEUKH WAE NIEUN
  {0xB264, 0xCF91}, //8330 #HANGUL SYLLABLE KHIEUKH WAE NIEUNCIEUC
  {0xB265, 0xCF92}, //8331 #HANGUL SYLLABLE KHIEUKH WAE NIEUNHIEUH
  {0xB266, 0xCF93}, //8332 #HANGUL SYLLABLE KHIEUKH WAE TIKEUT
  {0xB267, 0xCF94}, //8333 #HANGUL SYLLABLE KHIEUKH WAE RIEUL
  {0xB268, 0xCF95}, //8334 #HANGUL SYLLABLE KHIEUKH WAE RIEULKIYEOK
  {0xB269, 0xCF96}, //8335 #HANGUL SYLLABLE KHIEUKH WAE RIEULMIEUM
  {0xB26A, 0xCF97}, //8336 #HANGUL SYLLABLE KHIEUKH WAE RIEULPIEUP
  {0xB26B, 0xCF98}, //8337 #HANGUL SYLLABLE KHIEUKH WAE RIEULSIOS
  {0xB26C, 0xCF99}, //8338 #HANGUL SYLLABLE KHIEUKH WAE RIEULTHIEUTH
  {0xB26D, 0xCF9A}, //8339 #HANGUL SYLLABLE KHIEUKH WAE RIEULPHIEUPH
  {0xB26E, 0xCF9B}, //8340 #HANGUL SYLLABLE KHIEUKH WAE RIEULHIEUH
  {0xB26F, 0xCF9C}, //8341 #HANGUL SYLLABLE KHIEUKH WAE MIEUM
  {0xB270, 0xCF9D}, //8342 #HANGUL SYLLABLE KHIEUKH WAE PIEUP
  {0xB271, 0xCF9E}, //8343 #HANGUL SYLLABLE KHIEUKH WAE PIEUPSIOS
  {0xB272, 0xCF9F}, //8344 #HANGUL SYLLABLE KHIEUKH WAE SIOS
  {0xB273, 0xCFA0}, //8345 #HANGUL SYLLABLE KHIEUKH WAE SSANGSIOS
  {0xB274, 0xCFA2}, //8346 #HANGUL SYLLABLE KHIEUKH WAE CIEUC
  {0xB275, 0xCFA3}, //8347 #HANGUL SYLLABLE KHIEUKH WAE CHIEUCH
  {0xB276, 0xCFA4}, //8348 #HANGUL SYLLABLE KHIEUKH WAE KHIEUKH
  {0xB277, 0xCFA5}, //8349 #HANGUL SYLLABLE KHIEUKH WAE THIEUTH
  {0xB278, 0xCFA6}, //8350 #HANGUL SYLLABLE KHIEUKH WAE PHIEUPH
  {0xB279, 0xCFA7}, //8351 #HANGUL SYLLABLE KHIEUKH WAE HIEUH
  {0xB27A, 0xCFA9}, //8352 #HANGUL SYLLABLE KHIEUKH OE KIYEOK
  {0xB281, 0xCFAA}, //8353 #HANGUL SYLLABLE KHIEUKH OE SSANGKIYEOK
  {0xB282, 0xCFAB}, //8354 #HANGUL SYLLABLE KHIEUKH OE KIYEOKSIOS
  {0xB283, 0xCFAC}, //8355 #HANGUL SYLLABLE KHIEUKH OE NIEUN
  {0xB284, 0xCFAD}, //8356 #HANGUL SYLLABLE KHIEUKH OE NIEUNCIEUC
  {0xB285, 0xCFAE}, //8357 #HANGUL SYLLABLE KHIEUKH OE NIEUNHIEUH
  {0xB286, 0xCFAF}, //8358 #HANGUL SYLLABLE KHIEUKH OE TIKEUT
  {0xB287, 0xCFB1}, //8359 #HANGUL SYLLABLE KHIEUKH OE RIEULKIYEOK
  {0xB288, 0xCFB2}, //8360 #HANGUL SYLLABLE KHIEUKH OE RIEULMIEUM
  {0xB289, 0xCFB3}, //8361 #HANGUL SYLLABLE KHIEUKH OE RIEULPIEUP
  {0xB28A, 0xCFB4}, //8362 #HANGUL SYLLABLE KHIEUKH OE RIEULSIOS
  {0xB28B, 0xCFB5}, //8363 #HANGUL SYLLABLE KHIEUKH OE RIEULTHIEUTH
  {0xB28C, 0xCFB6}, //8364 #HANGUL SYLLABLE KHIEUKH OE RIEULPHIEUPH
  {0xB28D, 0xCFB7}, //8365 #HANGUL SYLLABLE KHIEUKH OE RIEULHIEUH
  {0xB28E, 0xCFB8}, //8366 #HANGUL SYLLABLE KHIEUKH OE MIEUM
  {0xB28F, 0xCFB9}, //8367 #HANGUL SYLLABLE KHIEUKH OE PIEUP
  {0xB290, 0xCFBA}, //8368 #HANGUL SYLLABLE KHIEUKH OE PIEUPSIOS
  {0xB291, 0xCFBB}, //8369 #HANGUL SYLLABLE KHIEUKH OE SIOS
  {0xB292, 0xCFBC}, //8370 #HANGUL SYLLABLE KHIEUKH OE SSANGSIOS
  {0xB293, 0xCFBD}, //8371 #HANGUL SYLLABLE KHIEUKH OE IEUNG
  {0xB294, 0xCFBE}, //8372 #HANGUL SYLLABLE KHIEUKH OE CIEUC
  {0xB295, 0xCFBF}, //8373 #HANGUL SYLLABLE KHIEUKH OE CHIEUCH
  {0xB296, 0xCFC0}, //8374 #HANGUL SYLLABLE KHIEUKH OE KHIEUKH
  {0xB297, 0xCFC1}, //8375 #HANGUL SYLLABLE KHIEUKH OE THIEUTH
  {0xB298, 0xCFC2}, //8376 #HANGUL SYLLABLE KHIEUKH OE PHIEUPH
  {0xB299, 0xCFC3}, //8377 #HANGUL SYLLABLE KHIEUKH OE HIEUH
  {0xB29A, 0xCFC5}, //8378 #HANGUL SYLLABLE KHIEUKH YO KIYEOK
  {0xB29B, 0xCFC6}, //8379 #HANGUL SYLLABLE KHIEUKH YO SSANGKIYEOK
  {0xB29C, 0xCFC7}, //8380 #HANGUL SYLLABLE KHIEUKH YO KIYEOKSIOS
  {0xB29D, 0xCFC8}, //8381 #HANGUL SYLLABLE KHIEUKH YO NIEUN
  {0xB29E, 0xCFC9}, //8382 #HANGUL SYLLABLE KHIEUKH YO NIEUNCIEUC
  {0xB29F, 0xCFCA}, //8383 #HANGUL SYLLABLE KHIEUKH YO NIEUNHIEUH
  {0xB2A0, 0xCFCB}, //8384 #HANGUL SYLLABLE KHIEUKH YO TIKEUT
  {0xB2A1, 0xAE79}, //8385 #HANGUL SYLLABLE SSANGKIYEOK AE PIEUP
  {0xB2A2, 0xAE7B}, //8386 #HANGUL SYLLABLE SSANGKIYEOK AE SIOS
  {0xB2A3, 0xAE7C}, //8387 #HANGUL SYLLABLE SSANGKIYEOK AE SSANGSIOS
  {0xB2A4, 0xAE7D}, //8388 #HANGUL SYLLABLE SSANGKIYEOK AE IEUNG
  {0xB2A5, 0xAE84}, //8389 #HANGUL SYLLABLE SSANGKIYEOK YA
  {0xB2A6, 0xAE85}, //8390 #HANGUL SYLLABLE SSANGKIYEOK YA KIYEOK
  {0xB2A7, 0xAE8C}, //8391 #HANGUL SYLLABLE SSANGKIYEOK YA RIEUL
  {0xB2A8, 0xAEBC}, //8392 #HANGUL SYLLABLE SSANGKIYEOK EO
  {0xB2A9, 0xAEBD}, //8393 #HANGUL SYLLABLE SSANGKIYEOK EO KIYEOK
  {0xB2AA, 0xAEBE}, //8394 #HANGUL SYLLABLE SSANGKIYEOK EO SSANGKIYEOK
  {0xB2AB, 0xAEC0}, //8395 #HANGUL SYLLABLE SSANGKIYEOK EO NIEUN
  {0xB2AC, 0xAEC4}, //8396 #HANGUL SYLLABLE SSANGKIYEOK EO RIEUL
  {0xB2AD, 0xAECC}, //8397 #HANGUL SYLLABLE SSANGKIYEOK EO MIEUM
  {0xB2AE, 0xAECD}, //8398 #HANGUL SYLLABLE SSANGKIYEOK EO PIEUP
  {0xB2AF, 0xAECF}, //8399 #HANGUL SYLLABLE SSANGKIYEOK EO SIOS
  {0xB2B0, 0xAED0}, //8400 #HANGUL SYLLABLE SSANGKIYEOK EO SSANGSIOS
  {0xB2B1, 0xAED1}, //8401 #HANGUL SYLLABLE SSANGKIYEOK EO IEUNG
  {0xB2B2, 0xAED8}, //8402 #HANGUL SYLLABLE SSANGKIYEOK E
  {0xB2B3, 0xAED9}, //8403 #HANGUL SYLLABLE SSANGKIYEOK E KIYEOK
  {0xB2B4, 0xAEDC}, //8404 #HANGUL SYLLABLE SSANGKIYEOK E NIEUN
  {0xB2B5, 0xAEE8}, //8405 #HANGUL SYLLABLE SSANGKIYEOK E MIEUM
  {0xB2B6, 0xAEEB}, //8406 #HANGUL SYLLABLE SSANGKIYEOK E SIOS
  {0xB2B7, 0xAEED}, //8407 #HANGUL SYLLABLE SSANGKIYEOK E IEUNG
  {0xB2B8, 0xAEF4}, //8408 #HANGUL SYLLABLE SSANGKIYEOK YEO
  {0xB2B9, 0xAEF8}, //8409 #HANGUL SYLLABLE SSANGKIYEOK YEO NIEUN
  {0xB2BA, 0xAEFC}, //8410 #HANGUL SYLLABLE SSANGKIYEOK YEO RIEUL
  {0xB2BB, 0xAF07}, //8411 #HANGUL SYLLABLE SSANGKIYEOK YEO SIOS
  {0xB2BC, 0xAF08}, //8412 #HANGUL SYLLABLE SSANGKIYEOK YEO SSANGSIOS
  {0xB2BD, 0xAF0D}, //8413 #HANGUL SYLLABLE SSANGKIYEOK YEO THIEUTH
  {0xB2BE, 0xAF10}, //8414 #HANGUL SYLLABLE SSANGKIYEOK YE
  {0xB2BF, 0xAF2C}, //8415 #HANGUL SYLLABLE SSANGKIYEOK O
  {0xB2C0, 0xAF2D}, //8416 #HANGUL SYLLABLE SSANGKIYEOK O KIYEOK
  {0xB2C1, 0xAF30}, //8417 #HANGUL SYLLABLE SSANGKIYEOK O NIEUN
  {0xB2C2, 0xAF32}, //8418 #HANGUL SYLLABLE SSANGKIYEOK O NIEUNHIEUH
  {0xB2C3, 0xAF34}, //8419 #HANGUL SYLLABLE SSANGKIYEOK O RIEUL
  {0xB2C4, 0xAF3C}, //8420 #HANGUL SYLLABLE SSANGKIYEOK O MIEUM
  {0xB2C5, 0xAF3D}, //8421 #HANGUL SYLLABLE SSANGKIYEOK O PIEUP
  {0xB2C6, 0xAF3F}, //8422 #HANGUL SYLLABLE SSANGKIYEOK O SIOS
  {0xB2C7, 0xAF41}, //8423 #HANGUL SYLLABLE SSANGKIYEOK O IEUNG
  {0xB2C8, 0xAF42}, //8424 #HANGUL SYLLABLE SSANGKIYEOK O CIEUC
  {0xB2C9, 0xAF43}, //8425 #HANGUL SYLLABLE SSANGKIYEOK O CHIEUCH
  {0xB2CA, 0xAF48}, //8426 #HANGUL SYLLABLE SSANGKIYEOK WA
  {0xB2CB, 0xAF49}, //8427 #HANGUL SYLLABLE SSANGKIYEOK WA KIYEOK
  {0xB2CC, 0xAF50}, //8428 #HANGUL SYLLABLE SSANGKIYEOK WA RIEUL
  {0xB2CD, 0xAF5C}, //8429 #HANGUL SYLLABLE SSANGKIYEOK WA SSANGSIOS
  {0xB2CE, 0xAF5D}, //8430 #HANGUL SYLLABLE SSANGKIYEOK WA IEUNG
  {0xB2CF, 0xAF64}, //8431 #HANGUL SYLLABLE SSANGKIYEOK WAE
  {0xB2D0, 0xAF65}, //8432 #HANGUL SYLLABLE SSANGKIYEOK WAE KIYEOK
  {0xB2D1, 0xAF79}, //8433 #HANGUL SYLLABLE SSANGKIYEOK WAE IEUNG
  {0xB2D2, 0xAF80}, //8434 #HANGUL SYLLABLE SSANGKIYEOK OE
  {0xB2D3, 0xAF84}, //8435 #HANGUL SYLLABLE SSANGKIYEOK OE NIEUN
  {0xB2D4, 0xAF88}, //8436 #HANGUL SYLLABLE SSANGKIYEOK OE RIEUL
  {0xB2D5, 0xAF90}, //8437 #HANGUL SYLLABLE SSANGKIYEOK OE MIEUM
  {0xB2D6, 0xAF91}, //8438 #HANGUL SYLLABLE SSANGKIYEOK OE PIEUP
  {0xB2D7, 0xAF95}, //8439 #HANGUL SYLLABLE SSANGKIYEOK OE IEUNG
  {0xB2D8, 0xAF9C}, //8440 #HANGUL SYLLABLE SSANGKIYEOK YO
  {0xB2D9, 0xAFB8}, //8441 #HANGUL SYLLABLE SSANGKIYEOK U
  {0xB2DA, 0xAFB9}, //8442 #HANGUL SYLLABLE SSANGKIYEOK U KIYEOK
  {0xB2DB, 0xAFBC}, //8443 #HANGUL SYLLABLE SSANGKIYEOK U NIEUN
  {0xB2DC, 0xAFC0}, //8444 #HANGUL SYLLABLE SSANGKIYEOK U RIEUL
  {0xB2DD, 0xAFC7}, //8445 #HANGUL SYLLABLE SSANGKIYEOK U RIEULHIEUH
  {0xB2DE, 0xAFC8}, //8446 #HANGUL SYLLABLE SSANGKIYEOK U MIEUM
  {0xB2DF, 0xAFC9}, //8447 #HANGUL SYLLABLE SSANGKIYEOK U PIEUP
  {0xB2E0, 0xAFCB}, //8448 #HANGUL SYLLABLE SSANGKIYEOK U SIOS
  {0xB2E1, 0xAFCD}, //8449 #HANGUL SYLLABLE SSANGKIYEOK U IEUNG
  {0xB2E2, 0xAFCE}, //8450 #HANGUL SYLLABLE SSANGKIYEOK U CIEUC
  {0xB2E3, 0xAFD4}, //8451 #HANGUL SYLLABLE SSANGKIYEOK WEO
  {0xB2E4, 0xAFDC}, //8452 #HANGUL SYLLABLE SSANGKIYEOK WEO RIEUL
  {0xB2E5, 0xAFE8}, //8453 #HANGUL SYLLABLE SSANGKIYEOK WEO SSANGSIOS
  {0xB2E6, 0xAFE9}, //8454 #HANGUL SYLLABLE SSANGKIYEOK WEO IEUNG
  {0xB2E7, 0xAFF0}, //8455 #HANGUL SYLLABLE SSANGKIYEOK WE
  {0xB2E8, 0xAFF1}, //8456 #HANGUL SYLLABLE SSANGKIYEOK WE KIYEOK
  {0xB2E9, 0xAFF4}, //8457 #HANGUL SYLLABLE SSANGKIYEOK WE NIEUN
  {0xB2EA, 0xAFF8}, //8458 #HANGUL SYLLABLE SSANGKIYEOK WE RIEUL
  {0xB2EB, 0xB000}, //8459 #HANGUL SYLLABLE SSANGKIYEOK WE MIEUM
  {0xB2EC, 0xB001}, //8460 #HANGUL SYLLABLE SSANGKIYEOK WE PIEUP
  {0xB2ED, 0xB004}, //8461 #HANGUL SYLLABLE SSANGKIYEOK WE SSANGSIOS
  {0xB2EE, 0xB00C}, //8462 #HANGUL SYLLABLE SSANGKIYEOK WI
  {0xB2EF, 0xB010}, //8463 #HANGUL SYLLABLE SSANGKIYEOK WI NIEUN
  {0xB2F0, 0xB014}, //8464 #HANGUL SYLLABLE SSANGKIYEOK WI RIEUL
  {0xB2F1, 0xB01C}, //8465 #HANGUL SYLLABLE SSANGKIYEOK WI MIEUM
  {0xB2F2, 0xB01D}, //8466 #HANGUL SYLLABLE SSANGKIYEOK WI PIEUP
  {0xB2F3, 0xB028}, //8467 #HANGUL SYLLABLE SSANGKIYEOK YU
  {0xB2F4, 0xB044}, //8468 #HANGUL SYLLABLE SSANGKIYEOK EU
  {0xB2F5, 0xB045}, //8469 #HANGUL SYLLABLE SSANGKIYEOK EU KIYEOK
  {0xB2F6, 0xB048}, //8470 #HANGUL SYLLABLE SSANGKIYEOK EU NIEUN
  {0xB2F7, 0xB04A}, //8471 #HANGUL SYLLABLE SSANGKIYEOK EU NIEUNHIEUH
  {0xB2F8, 0xB04C}, //8472 #HANGUL SYLLABLE SSANGKIYEOK EU RIEUL
  {0xB2F9, 0xB04E}, //8473 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULMIEUM
  {0xB2FA, 0xB053}, //8474 #HANGUL SYLLABLE SSANGKIYEOK EU RIEULHIEUH
  {0xB2FB, 0xB054}, //8475 #HANGUL SYLLABLE SSANGKIYEOK EU MIEUM
  {0xB2FC, 0xB055}, //8476 #HANGUL SYLLABLE SSANGKIYEOK EU PIEUP
  {0xB2FD, 0xB057}, //8477 #HANGUL SYLLABLE SSANGKIYEOK EU SIOS
  {0xB2FE, 0xB059}, //8478 #HANGUL SYLLABLE SSANGKIYEOK EU IEUNG
  {0xB341, 0xCFCC}, //8479 #HANGUL SYLLABLE KHIEUKH YO RIEUL
  {0xB342, 0xCFCD}, //8480 #HANGUL SYLLABLE KHIEUKH YO RIEULKIYEOK
  {0xB343, 0xCFCE}, //8481 #HANGUL SYLLABLE KHIEUKH YO RIEULMIEUM
  {0xB344, 0xCFCF}, //8482 #HANGUL SYLLABLE KHIEUKH YO RIEULPIEUP
  {0xB345, 0xCFD0}, //8483 #HANGUL SYLLABLE KHIEUKH YO RIEULSIOS
  {0xB346, 0xCFD1}, //8484 #HANGUL SYLLABLE KHIEUKH YO RIEULTHIEUTH
  {0xB347, 0xCFD2}, //8485 #HANGUL SYLLABLE KHIEUKH YO RIEULPHIEUPH
  {0xB348, 0xCFD3}, //8486 #HANGUL SYLLABLE KHIEUKH YO RIEULHIEUH
  {0xB349, 0xCFD4}, //8487 #HANGUL SYLLABLE KHIEUKH YO MIEUM
  {0xB34A, 0xCFD5}, //8488 #HANGUL SYLLABLE KHIEUKH YO PIEUP
  {0xB34B, 0xCFD6}, //8489 #HANGUL SYLLABLE KHIEUKH YO PIEUPSIOS
  {0xB34C, 0xCFD7}, //8490 #HANGUL SYLLABLE KHIEUKH YO SIOS
  {0xB34D, 0xCFD8}, //8491 #HANGUL SYLLABLE KHIEUKH YO SSANGSIOS
  {0xB34E, 0xCFD9}, //8492 #HANGUL SYLLABLE KHIEUKH YO IEUNG
  {0xB34F, 0xCFDA}, //8493 #HANGUL SYLLABLE KHIEUKH YO CIEUC
  {0xB350, 0xCFDB}, //8494 #HANGUL SYLLABLE KHIEUKH YO CHIEUCH
  {0xB351, 0xCFDC}, //8495 #HANGUL SYLLABLE KHIEUKH YO KHIEUKH
  {0xB352, 0xCFDD}, //8496 #HANGUL SYLLABLE KHIEUKH YO THIEUTH
  {0xB353, 0xCFDE}, //8497 #HANGUL SYLLABLE KHIEUKH YO PHIEUPH
  {0xB354, 0xCFDF}, //8498 #HANGUL SYLLABLE KHIEUKH YO HIEUH
  {0xB355, 0xCFE2}, //8499 #HANGUL SYLLABLE KHIEUKH U SSANGKIYEOK
  {0xB356, 0xCFE3}, //8500 #HANGUL SYLLABLE KHIEUKH U KIYEOKSIOS
  {0xB357, 0xCFE5}, //8501 #HANGUL SYLLABLE KHIEUKH U NIEUNCIEUC
  {0xB358, 0xCFE6}, //8502 #HANGUL SYLLABLE KHIEUKH U NIEUNHIEUH
  {0xB359, 0xCFE7}, //8503 #HANGUL SYLLABLE KHIEUKH U TIKEUT
  {0xB35A, 0xCFE9}, //8504 #HANGUL SYLLABLE KHIEUKH U RIEULKIYEOK
  {0xB361, 0xCFEA}, //8505 #HANGUL SYLLABLE KHIEUKH U RIEULMIEUM
  {0xB362, 0xCFEB}, //8506 #HANGUL SYLLABLE KHIEUKH U RIEULPIEUP
  {0xB363, 0xCFEC}, //8507 #HANGUL SYLLABLE KHIEUKH U RIEULSIOS
  {0xB364, 0xCFED}, //8508 #HANGUL SYLLABLE KHIEUKH U RIEULTHIEUTH
  {0xB365, 0xCFEE}, //8509 #HANGUL SYLLABLE KHIEUKH U RIEULPHIEUPH
  {0xB366, 0xCFEF}, //8510 #HANGUL SYLLABLE KHIEUKH U RIEULHIEUH
  {0xB367, 0xCFF2}, //8511 #HANGUL SYLLABLE KHIEUKH U PIEUPSIOS
  {0xB368, 0xCFF4}, //8512 #HANGUL SYLLABLE KHIEUKH U SSANGSIOS
  {0xB369, 0xCFF6}, //8513 #HANGUL SYLLABLE KHIEUKH U CIEUC
  {0xB36A, 0xCFF7}, //8514 #HANGUL SYLLABLE KHIEUKH U CHIEUCH
  {0xB36B, 0xCFF8}, //8515 #HANGUL SYLLABLE KHIEUKH U KHIEUKH
  {0xB36C, 0xCFF9}, //8516 #HANGUL SYLLABLE KHIEUKH U THIEUTH
  {0xB36D, 0xCFFA}, //8517 #HANGUL SYLLABLE KHIEUKH U PHIEUPH
  {0xB36E, 0xCFFB}, //8518 #HANGUL SYLLABLE KHIEUKH U HIEUH
  {0xB36F, 0xCFFD}, //8519 #HANGUL SYLLABLE KHIEUKH WEO KIYEOK
  {0xB370, 0xCFFE}, //8520 #HANGUL SYLLABLE KHIEUKH WEO SSANGKIYEOK
  {0xB371, 0xCFFF}, //8521 #HANGUL SYLLABLE KHIEUKH WEO KIYEOKSIOS
  {0xB372, 0xD001}, //8522 #HANGUL SYLLABLE KHIEUKH WEO NIEUNCIEUC
  {0xB373, 0xD002}, //8523 #HANGUL SYLLABLE KHIEUKH WEO NIEUNHIEUH
  {0xB374, 0xD003}, //8524 #HANGUL SYLLABLE KHIEUKH WEO TIKEUT
  {0xB375, 0xD005}, //8525 #HANGUL SYLLABLE KHIEUKH WEO RIEULKIYEOK
  {0xB376, 0xD006}, //8526 #HANGUL SYLLABLE KHIEUKH WEO RIEULMIEUM
  {0xB377, 0xD007}, //8527 #HANGUL SYLLABLE KHIEUKH WEO RIEULPIEUP
  {0xB378, 0xD008}, //8528 #HANGUL SYLLABLE KHIEUKH WEO RIEULSIOS
  {0xB379, 0xD009}, //8529 #HANGUL SYLLABLE KHIEUKH WEO RIEULTHIEUTH
  {0xB37A, 0xD00A}, //8530 #HANGUL SYLLABLE KHIEUKH WEO RIEULPHIEUPH
  {0xB381, 0xD00B}, //8531 #HANGUL SYLLABLE KHIEUKH WEO RIEULHIEUH
  {0xB382, 0xD00C}, //8532 #HANGUL SYLLABLE KHIEUKH WEO MIEUM
  {0xB383, 0xD00D}, //8533 #HANGUL SYLLABLE KHIEUKH WEO PIEUP
  {0xB384, 0xD00E}, //8534 #HANGUL SYLLABLE KHIEUKH WEO PIEUPSIOS
  {0xB385, 0xD00F}, //8535 #HANGUL SYLLABLE KHIEUKH WEO SIOS
  {0xB386, 0xD010}, //8536 #HANGUL SYLLABLE KHIEUKH WEO SSANGSIOS
  {0xB387, 0xD012}, //8537 #HANGUL SYLLABLE KHIEUKH WEO CIEUC
  {0xB388, 0xD013}, //8538 #HANGUL SYLLABLE KHIEUKH WEO CHIEUCH
  {0xB389, 0xD014}, //8539 #HANGUL SYLLABLE KHIEUKH WEO KHIEUKH
  {0xB38A, 0xD015}, //8540 #HANGUL SYLLABLE KHIEUKH WEO THIEUTH
  {0xB38B, 0xD016}, //8541 #HANGUL SYLLABLE KHIEUKH WEO PHIEUPH
  {0xB38C, 0xD017}, //8542 #HANGUL SYLLABLE KHIEUKH WEO HIEUH
  {0xB38D, 0xD019}, //8543 #HANGUL SYLLABLE KHIEUKH WE KIYEOK
  {0xB38E, 0xD01A}, //8544 #HANGUL SYLLABLE KHIEUKH WE SSANGKIYEOK
  {0xB38F, 0xD01B}, //8545 #HANGUL SYLLABLE KHIEUKH WE KIYEOKSIOS
  {0xB390, 0xD01C}, //8546 #HANGUL SYLLABLE KHIEUKH WE NIEUN
  {0xB391, 0xD01D}, //8547 #HANGUL SYLLABLE KHIEUKH WE NIEUNCIEUC
  {0xB392, 0xD01E}, //8548 #HANGUL SYLLABLE KHIEUKH WE NIEUNHIEUH
  {0xB393, 0xD01F}, //8549 #HANGUL SYLLABLE KHIEUKH WE TIKEUT
  {0xB394, 0xD020}, //8550 #HANGUL SYLLABLE KHIEUKH WE RIEUL
  {0xB395, 0xD021}, //8551 #HANGUL SYLLABLE KHIEUKH WE RIEULKIYEOK
  {0xB396, 0xD022}, //8552 #HANGUL SYLLABLE KHIEUKH WE RIEULMIEUM
  {0xB397, 0xD023}, //8553 #HANGUL SYLLABLE KHIEUKH WE RIEULPIEUP
  {0xB398, 0xD024}, //8554 #HANGUL SYLLABLE KHIEUKH WE RIEULSIOS
  {0xB399, 0xD025}, //8555 #HANGUL SYLLABLE KHIEUKH WE RIEULTHIEUTH
  {0xB39A, 0xD026}, //8556 #HANGUL SYLLABLE KHIEUKH WE RIEULPHIEUPH
  {0xB39B, 0xD027}, //8557 #HANGUL SYLLABLE KHIEUKH WE RIEULHIEUH
  {0xB39C, 0xD028}, //8558 #HANGUL SYLLABLE KHIEUKH WE MIEUM
  {0xB39D, 0xD029}, //8559 #HANGUL SYLLABLE KHIEUKH WE PIEUP
  {0xB39E, 0xD02A}, //8560 #HANGUL SYLLABLE KHIEUKH WE PIEUPSIOS
  {0xB39F, 0xD02B}, //8561 #HANGUL SYLLABLE KHIEUKH WE SIOS
  {0xB3A0, 0xD02C}, //8562 #HANGUL SYLLABLE KHIEUKH WE SSANGSIOS
  {0xB3A1, 0xB05D}, //8563 #HANGUL SYLLABLE SSANGKIYEOK EU THIEUTH
  {0xB3A2, 0xB07C}, //8564 #HANGUL SYLLABLE SSANGKIYEOK I
  {0xB3A3, 0xB07D}, //8565 #HANGUL SYLLABLE SSANGKIYEOK I KIYEOK
  {0xB3A4, 0xB080}, //8566 #HANGUL SYLLABLE SSANGKIYEOK I NIEUN
  {0xB3A5, 0xB084}, //8567 #HANGUL SYLLABLE SSANGKIYEOK I RIEUL
  {0xB3A6, 0xB08C}, //8568 #HANGUL SYLLABLE SSANGKIYEOK I MIEUM
  {0xB3A7, 0xB08D}, //8569 #HANGUL SYLLABLE SSANGKIYEOK I PIEUP
  {0xB3A8, 0xB08F}, //8570 #HANGUL SYLLABLE SSANGKIYEOK I SIOS
  {0xB3A9, 0xB091}, //8571 #HANGUL SYLLABLE SSANGKIYEOK I IEUNG
  {0xB3AA, 0xB098}, //8572 #HANGUL SYLLABLE NIEUN A
  {0xB3AB, 0xB099}, //8573 #HANGUL SYLLABLE NIEUN A KIYEOK
  {0xB3AC, 0xB09A}, //8574 #HANGUL SYLLABLE NIEUN A SSANGKIYEOK
  {0xB3AD, 0xB09C}, //8575 #HANGUL SYLLABLE NIEUN A NIEUN
  {0xB3AE, 0xB09F}, //8576 #HANGUL SYLLABLE NIEUN A TIKEUT
  {0xB3AF, 0xB0A0}, //8577 #HANGUL SYLLABLE NIEUN A RIEUL
  {0xB3B0, 0xB0A1}, //8578 #HANGUL SYLLABLE NIEUN A RIEULKIYEOK
  {0xB3B1, 0xB0A2}, //8579 #HANGUL SYLLABLE NIEUN A RIEULMIEUM
  {0xB3B2, 0xB0A8}, //8580 #HANGUL SYLLABLE NIEUN A MIEUM
  {0xB3B3, 0xB0A9}, //8581 #HANGUL SYLLABLE NIEUN A PIEUP
  {0xB3B4, 0xB0AB}, //8582 #HANGUL SYLLABLE NIEUN A SIOS
  {0xB3B5, 0xB0AC}, //8583 #HANGUL SYLLABLE NIEUN A SSANGSIOS
  {0xB3B6, 0xB0AD}, //8584 #HANGUL SYLLABLE NIEUN A IEUNG
  {0xB3B7, 0xB0AE}, //8585 #HANGUL SYLLABLE NIEUN A CIEUC
  {0xB3B8, 0xB0AF}, //8586 #HANGUL SYLLABLE NIEUN A CHIEUCH
  {0xB3B9, 0xB0B1}, //8587 #HANGUL SYLLABLE NIEUN A THIEUTH
  {0xB3BA, 0xB0B3}, //8588 #HANGUL SYLLABLE NIEUN A HIEUH
  {0xB3BB, 0xB0B4}, //8589 #HANGUL SYLLABLE NIEUN AE
  {0xB3BC, 0xB0B5}, //8590 #HANGUL SYLLABLE NIEUN AE KIYEOK
  {0xB3BD, 0xB0B8}, //8591 #HANGUL SYLLABLE NIEUN AE NIEUN
  {0xB3BE, 0xB0BC}, //8592 #HANGUL SYLLABLE NIEUN AE RIEUL
  {0xB3BF, 0xB0C4}, //8593 #HANGUL SYLLABLE NIEUN AE MIEUM
  {0xB3C0, 0xB0C5}, //8594 #HANGUL SYLLABLE NIEUN AE PIEUP
  {0xB3C1, 0xB0C7}, //8595 #HANGUL SYLLABLE NIEUN AE SIOS
  {0xB3C2, 0xB0C8}, //8596 #HANGUL SYLLABLE NIEUN AE SSANGSIOS
  {0xB3C3, 0xB0C9}, //8597 #HANGUL SYLLABLE NIEUN AE IEUNG
  {0xB3C4, 0xB0D0}, //8598 #HANGUL SYLLABLE NIEUN YA
  {0xB3C5, 0xB0D1}, //8599 #HANGUL SYLLABLE NIEUN YA KIYEOK
  {0xB3C6, 0xB0D4}, //8600 #HANGUL SYLLABLE NIEUN YA NIEUN
  {0xB3C7, 0xB0D8}, //8601 #HANGUL SYLLABLE NIEUN YA RIEUL
  {0xB3C8, 0xB0E0}, //8602 #HANGUL SYLLABLE NIEUN YA MIEUM
  {0xB3C9, 0xB0E5}, //8603 #HANGUL SYLLABLE NIEUN YA IEUNG
  {0xB3CA, 0xB108}, //8604 #HANGUL SYLLABLE NIEUN EO
  {0xB3CB, 0xB109}, //8605 #HANGUL SYLLABLE NIEUN EO KIYEOK
  {0xB3CC, 0xB10B}, //8606 #HANGUL SYLLABLE NIEUN EO KIYEOKSIOS
  {0xB3CD, 0xB10C}, //8607 #HANGUL SYLLABLE NIEUN EO NIEUN
  {0xB3CE, 0xB110}, //8608 #HANGUL SYLLABLE NIEUN EO RIEUL
  {0xB3CF, 0xB112}, //8609 #HANGUL SYLLABLE NIEUN EO RIEULMIEUM
  {0xB3D0, 0xB113}, //8610 #HANGUL SYLLABLE NIEUN EO RIEULPIEUP
  {0xB3D1, 0xB118}, //8611 #HANGUL SYLLABLE NIEUN EO MIEUM
  {0xB3D2, 0xB119}, //8612 #HANGUL SYLLABLE NIEUN EO PIEUP
  {0xB3D3, 0xB11B}, //8613 #HANGUL SYLLABLE NIEUN EO SIOS
  {0xB3D4, 0xB11C}, //8614 #HANGUL SYLLABLE NIEUN EO SSANGSIOS
  {0xB3D5, 0xB11D}, //8615 #HANGUL SYLLABLE NIEUN EO IEUNG
  {0xB3D6, 0xB123}, //8616 #HANGUL SYLLABLE NIEUN EO HIEUH
  {0xB3D7, 0xB124}, //8617 #HANGUL SYLLABLE NIEUN E
  {0xB3D8, 0xB125}, //8618 #HANGUL SYLLABLE NIEUN E KIYEOK
  {0xB3D9, 0xB128}, //8619 #HANGUL SYLLABLE NIEUN E NIEUN
  {0xB3DA, 0xB12C}, //8620 #HANGUL SYLLABLE NIEUN E RIEUL
  {0xB3DB, 0xB134}, //8621 #HANGUL SYLLABLE NIEUN E MIEUM
  {0xB3DC, 0xB135}, //8622 #HANGUL SYLLABLE NIEUN E PIEUP
  {0xB3DD, 0xB137}, //8623 #HANGUL SYLLABLE NIEUN E SIOS
  {0xB3DE, 0xB138}, //8624 #HANGUL SYLLABLE NIEUN E SSANGSIOS
  {0xB3DF, 0xB139}, //8625 #HANGUL SYLLABLE NIEUN E IEUNG
  {0xB3E0, 0xB140}, //8626 #HANGUL SYLLABLE NIEUN YEO
  {0xB3E1, 0xB141}, //8627 #HANGUL SYLLABLE NIEUN YEO KIYEOK
  {0xB3E2, 0xB144}, //8628 #HANGUL SYLLABLE NIEUN YEO NIEUN
  {0xB3E3, 0xB148}, //8629 #HANGUL SYLLABLE NIEUN YEO RIEUL
  {0xB3E4, 0xB150}, //8630 #HANGUL SYLLABLE NIEUN YEO MIEUM
  {0xB3E5, 0xB151}, //8631 #HANGUL SYLLABLE NIEUN YEO PIEUP
  {0xB3E6, 0xB154}, //8632 #HANGUL SYLLABLE NIEUN YEO SSANGSIOS
  {0xB3E7, 0xB155}, //8633 #HANGUL SYLLABLE NIEUN YEO IEUNG
  {0xB3E8, 0xB158}, //8634 #HANGUL SYLLABLE NIEUN YEO KHIEUKH
  {0xB3E9, 0xB15C}, //8635 #HANGUL SYLLABLE NIEUN YE
  {0xB3EA, 0xB160}, //8636 #HANGUL SYLLABLE NIEUN YE NIEUN
  {0xB3EB, 0xB178}, //8637 #HANGUL SYLLABLE NIEUN O
  {0xB3EC, 0xB179}, //8638 #HANGUL SYLLABLE NIEUN O KIYEOK
  {0xB3ED, 0xB17C}, //8639 #HANGUL SYLLABLE NIEUN O NIEUN
  {0xB3EE, 0xB180}, //8640 #HANGUL SYLLABLE NIEUN O RIEUL
  {0xB3EF, 0xB182}, //8641 #HANGUL SYLLABLE NIEUN O RIEULMIEUM
  {0xB3F0, 0xB188}, //8642 #HANGUL SYLLABLE NIEUN O MIEUM
  {0xB3F1, 0xB189}, //8643 #HANGUL SYLLABLE NIEUN O PIEUP
  {0xB3F2, 0xB18B}, //8644 #HANGUL SYLLABLE NIEUN O SIOS
  {0xB3F3, 0xB18D}, //8645 #HANGUL SYLLABLE NIEUN O IEUNG
  {0xB3F4, 0xB192}, //8646 #HANGUL SYLLABLE NIEUN O PHIEUPH
  {0xB3F5, 0xB193}, //8647 #HANGUL SYLLABLE NIEUN O HIEUH
  {0xB3F6, 0xB194}, //8648 #HANGUL SYLLABLE NIEUN WA
  {0xB3F7, 0xB198}, //8649 #HANGUL SYLLABLE NIEUN WA NIEUN
  {0xB3F8, 0xB19C}, //8650 #HANGUL SYLLABLE NIEUN WA RIEUL
  {0xB3F9, 0xB1A8}, //8651 #HANGUL SYLLABLE NIEUN WA SSANGSIOS
  {0xB3FA, 0xB1CC}, //8652 #HANGUL SYLLABLE NIEUN OE
  {0xB3FB, 0xB1D0}, //8653 #HANGUL SYLLABLE NIEUN OE NIEUN
  {0xB3FC, 0xB1D4}, //8654 #HANGUL SYLLABLE NIEUN OE RIEUL
  {0xB3FD, 0xB1DC}, //8655 #HANGUL SYLLABLE NIEUN OE MIEUM
  {0xB3FE, 0xB1DD}, //8656 #HANGUL SYLLABLE NIEUN OE PIEUP
  {0xB441, 0xD02E}, //8657 #HANGUL SYLLABLE KHIEUKH WE CIEUC
  {0xB442, 0xD02F}, //8658 #HANGUL SYLLABLE KHIEUKH WE CHIEUCH
  {0xB443, 0xD030}, //8659 #HANGUL SYLLABLE KHIEUKH WE KHIEUKH
  {0xB444, 0xD031}, //8660 #HANGUL SYLLABLE KHIEUKH WE THIEUTH
  {0xB445, 0xD032}, //8661 #HANGUL SYLLABLE KHIEUKH WE PHIEUPH
  {0xB446, 0xD033}, //8662 #HANGUL SYLLABLE KHIEUKH WE HIEUH
  {0xB447, 0xD036}, //8663 #HANGUL SYLLABLE KHIEUKH WI SSANGKIYEOK
  {0xB448, 0xD037}, //8664 #HANGUL SYLLABLE KHIEUKH WI KIYEOKSIOS
  {0xB449, 0xD039}, //8665 #HANGUL SYLLABLE KHIEUKH WI NIEUNCIEUC
  {0xB44A, 0xD03A}, //8666 #HANGUL SYLLABLE KHIEUKH WI NIEUNHIEUH
  {0xB44B, 0xD03B}, //8667 #HANGUL SYLLABLE KHIEUKH WI TIKEUT
  {0xB44C, 0xD03D}, //8668 #HANGUL SYLLABLE KHIEUKH WI RIEULKIYEOK
  {0xB44D, 0xD03E}, //8669 #HANGUL SYLLABLE KHIEUKH WI RIEULMIEUM
  {0xB44E, 0xD03F}, //8670 #HANGUL SYLLABLE KHIEUKH WI RIEULPIEUP
  {0xB44F, 0xD040}, //8671 #HANGUL SYLLABLE KHIEUKH WI RIEULSIOS
  {0xB450, 0xD041}, //8672 #HANGUL SYLLABLE KHIEUKH WI RIEULTHIEUTH
  {0xB451, 0xD042}, //8673 #HANGUL SYLLABLE KHIEUKH WI RIEULPHIEUPH
  {0xB452, 0xD043}, //8674 #HANGUL SYLLABLE KHIEUKH WI RIEULHIEUH
  {0xB453, 0xD046}, //8675 #HANGUL SYLLABLE KHIEUKH WI PIEUPSIOS
  {0xB454, 0xD048}, //8676 #HANGUL SYLLABLE KHIEUKH WI SSANGSIOS
  {0xB455, 0xD04A}, //8677 #HANGUL SYLLABLE KHIEUKH WI CIEUC
  {0xB456, 0xD04B}, //8678 #HANGUL SYLLABLE KHIEUKH WI CHIEUCH
  {0xB457, 0xD04C}, //8679 #HANGUL SYLLABLE KHIEUKH WI KHIEUKH
  {0xB458, 0xD04D}, //8680 #HANGUL SYLLABLE KHIEUKH WI THIEUTH
  {0xB459, 0xD04E}, //8681 #HANGUL SYLLABLE KHIEUKH WI PHIEUPH
  {0xB45A, 0xD04F}, //8682 #HANGUL SYLLABLE KHIEUKH WI HIEUH
  {0xB461, 0xD051}, //8683 #HANGUL SYLLABLE KHIEUKH YU KIYEOK
  {0xB462, 0xD052}, //8684 #HANGUL SYLLABLE KHIEUKH YU SSANGKIYEOK
  {0xB463, 0xD053}, //8685 #HANGUL SYLLABLE KHIEUKH YU KIYEOKSIOS
  {0xB464, 0xD055}, //8686 #HANGUL SYLLABLE KHIEUKH YU NIEUNCIEUC
  {0xB465, 0xD056}, //8687 #HANGUL SYLLABLE KHIEUKH YU NIEUNHIEUH
  {0xB466, 0xD057}, //8688 #HANGUL SYLLABLE KHIEUKH YU TIKEUT
  {0xB467, 0xD059}, //8689 #HANGUL SYLLABLE KHIEUKH YU RIEULKIYEOK
  {0xB468, 0xD05A}, //8690 #HANGUL SYLLABLE KHIEUKH YU RIEULMIEUM
  {0xB469, 0xD05B}, //8691 #HANGUL SYLLABLE KHIEUKH YU RIEULPIEUP
  {0xB46A, 0xD05C}, //8692 #HANGUL SYLLABLE KHIEUKH YU RIEULSIOS
  {0xB46B, 0xD05D}, //8693 #HANGUL SYLLABLE KHIEUKH YU RIEULTHIEUTH
  {0xB46C, 0xD05E}, //8694 #HANGUL SYLLABLE KHIEUKH YU RIEULPHIEUPH
  {0xB46D, 0xD05F}, //8695 #HANGUL SYLLABLE KHIEUKH YU RIEULHIEUH
  {0xB46E, 0xD061}, //8696 #HANGUL SYLLABLE KHIEUKH YU PIEUP
  {0xB46F, 0xD062}, //8697 #HANGUL SYLLABLE KHIEUKH YU PIEUPSIOS
  {0xB470, 0xD063}, //8698 #HANGUL SYLLABLE KHIEUKH YU SIOS
  {0xB471, 0xD064}, //8699 #HANGUL SYLLABLE KHIEUKH YU SSANGSIOS
  {0xB472, 0xD065}, //8700 #HANGUL SYLLABLE KHIEUKH YU IEUNG
  {0xB473, 0xD066}, //8701 #HANGUL SYLLABLE KHIEUKH YU CIEUC
  {0xB474, 0xD067}, //8702 #HANGUL SYLLABLE KHIEUKH YU CHIEUCH
  {0xB475, 0xD068}, //8703 #HANGUL SYLLABLE KHIEUKH YU KHIEUKH
  {0xB476, 0xD069}, //8704 #HANGUL SYLLABLE KHIEUKH YU THIEUTH
  {0xB477, 0xD06A}, //8705 #HANGUL SYLLABLE KHIEUKH YU PHIEUPH
  {0xB478, 0xD06B}, //8706 #HANGUL SYLLABLE KHIEUKH YU HIEUH
  {0xB479, 0xD06E}, //8707 #HANGUL SYLLABLE KHIEUKH EU SSANGKIYEOK
  {0xB47A, 0xD06F}, //8708 #HANGUL SYLLABLE KHIEUKH EU KIYEOKSIOS
  {0xB481, 0xD071}, //8709 #HANGUL SYLLABLE KHIEUKH EU NIEUNCIEUC
  {0xB482, 0xD072}, //8710 #HANGUL SYLLABLE KHIEUKH EU NIEUNHIEUH
  {0xB483, 0xD073}, //8711 #HANGUL SYLLABLE KHIEUKH EU TIKEUT
  {0xB484, 0xD075}, //8712 #HANGUL SYLLABLE KHIEUKH EU RIEULKIYEOK
  {0xB485, 0xD076}, //8713 #HANGUL SYLLABLE KHIEUKH EU RIEULMIEUM
  {0xB486, 0xD077}, //8714 #HANGUL SYLLABLE KHIEUKH EU RIEULPIEUP
  {0xB487, 0xD078}, //8715 #HANGUL SYLLABLE KHIEUKH EU RIEULSIOS
  {0xB488, 0xD079}, //8716 #HANGUL SYLLABLE KHIEUKH EU RIEULTHIEUTH
  {0xB489, 0xD07A}, //8717 #HANGUL SYLLABLE KHIEUKH EU RIEULPHIEUPH
  {0xB48A, 0xD07B}, //8718 #HANGUL SYLLABLE KHIEUKH EU RIEULHIEUH
  {0xB48B, 0xD07E}, //8719 #HANGUL SYLLABLE KHIEUKH EU PIEUPSIOS
  {0xB48C, 0xD07F}, //8720 #HANGUL SYLLABLE KHIEUKH EU SIOS
  {0xB48D, 0xD080}, //8721 #HANGUL SYLLABLE KHIEUKH EU SSANGSIOS
  {0xB48E, 0xD082}, //8722 #HANGUL SYLLABLE KHIEUKH EU CIEUC
  {0xB48F, 0xD083}, //8723 #HANGUL SYLLABLE KHIEUKH EU CHIEUCH
  {0xB490, 0xD084}, //8724 #HANGUL SYLLABLE KHIEUKH EU KHIEUKH
  {0xB491, 0xD085}, //8725 #HANGUL SYLLABLE KHIEUKH EU THIEUTH
  {0xB492, 0xD086}, //8726 #HANGUL SYLLABLE KHIEUKH EU PHIEUPH
  {0xB493, 0xD087}, //8727 #HANGUL SYLLABLE KHIEUKH EU HIEUH
  {0xB494, 0xD088}, //8728 #HANGUL SYLLABLE KHIEUKH YI
  {0xB495, 0xD089}, //8729 #HANGUL SYLLABLE KHIEUKH YI KIYEOK
  {0xB496, 0xD08A}, //8730 #HANGUL SYLLABLE KHIEUKH YI SSANGKIYEOK
  {0xB497, 0xD08B}, //8731 #HANGUL SYLLABLE KHIEUKH YI KIYEOKSIOS
  {0xB498, 0xD08C}, //8732 #HANGUL SYLLABLE KHIEUKH YI NIEUN
  {0xB499, 0xD08D}, //8733 #HANGUL SYLLABLE KHIEUKH YI NIEUNCIEUC
  {0xB49A, 0xD08E}, //8734 #HANGUL SYLLABLE KHIEUKH YI NIEUNHIEUH
  {0xB49B, 0xD08F}, //8735 #HANGUL SYLLABLE KHIEUKH YI TIKEUT
  {0xB49C, 0xD090}, //8736 #HANGUL SYLLABLE KHIEUKH YI RIEUL
  {0xB49D, 0xD091}, //8737 #HANGUL SYLLABLE KHIEUKH YI RIEULKIYEOK
  {0xB49E, 0xD092}, //8738 #HANGUL SYLLABLE KHIEUKH YI RIEULMIEUM
  {0xB49F, 0xD093}, //8739 #HANGUL SYLLABLE KHIEUKH YI RIEULPIEUP
  {0xB4A0, 0xD094}, //8740 #HANGUL SYLLABLE KHIEUKH YI RIEULSIOS
  {0xB4A1, 0xB1DF}, //8741 #HANGUL SYLLABLE NIEUN OE SIOS
  {0xB4A2, 0xB1E8}, //8742 #HANGUL SYLLABLE NIEUN YO
  {0xB4A3, 0xB1E9}, //8743 #HANGUL SYLLABLE NIEUN YO KIYEOK
  {0xB4A4, 0xB1EC}, //8744 #HANGUL SYLLABLE NIEUN YO NIEUN
  {0xB4A5, 0xB1F0}, //8745 #HANGUL SYLLABLE NIEUN YO RIEUL
  {0xB4A6, 0xB1F9}, //8746 #HANGUL SYLLABLE NIEUN YO PIEUP
  {0xB4A7, 0xB1FB}, //8747 #HANGUL SYLLABLE NIEUN YO SIOS
  {0xB4A8, 0xB1FD}, //8748 #HANGUL SYLLABLE NIEUN YO IEUNG
  {0xB4A9, 0xB204}, //8749 #HANGUL SYLLABLE NIEUN U
  {0xB4AA, 0xB205}, //8750 #HANGUL SYLLABLE NIEUN U KIYEOK
  {0xB4AB, 0xB208}, //8751 #HANGUL SYLLABLE NIEUN U NIEUN
  {0xB4AC, 0xB20B}, //8752 #HANGUL SYLLABLE NIEUN U TIKEUT
  {0xB4AD, 0xB20C}, //8753 #HANGUL SYLLABLE NIEUN U RIEUL
  {0xB4AE, 0xB214}, //8754 #HANGUL SYLLABLE NIEUN U MIEUM
  {0xB4AF, 0xB215}, //8755 #HANGUL SYLLABLE NIEUN U PIEUP
  {0xB4B0, 0xB217}, //8756 #HANGUL SYLLABLE NIEUN U SIOS
  {0xB4B1, 0xB219}, //8757 #HANGUL SYLLABLE NIEUN U IEUNG
  {0xB4B2, 0xB220}, //8758 #HANGUL SYLLABLE NIEUN WEO
  {0xB4B3, 0xB234}, //8759 #HANGUL SYLLABLE NIEUN WEO SSANGSIOS
  {0xB4B4, 0xB23C}, //8760 #HANGUL SYLLABLE NIEUN WE
  {0xB4B5, 0xB258}, //8761 #HANGUL SYLLABLE NIEUN WI
  {0xB4B6, 0xB25C}, //8762 #HANGUL SYLLABLE NIEUN WI NIEUN
  {0xB4B7, 0xB260}, //8763 #HANGUL SYLLABLE NIEUN WI RIEUL
  {0xB4B8, 0xB268}, //8764 #HANGUL SYLLABLE NIEUN WI MIEUM
  {0xB4B9, 0xB269}, //8765 #HANGUL SYLLABLE NIEUN WI PIEUP
  {0xB4BA, 0xB274}, //8766 #HANGUL SYLLABLE NIEUN YU
  {0xB4BB, 0xB275}, //8767 #HANGUL SYLLABLE NIEUN YU KIYEOK
  {0xB4BC, 0xB27C}, //8768 #HANGUL SYLLABLE NIEUN YU RIEUL
  {0xB4BD, 0xB284}, //8769 #HANGUL SYLLABLE NIEUN YU MIEUM
  {0xB4BE, 0xB285}, //8770 #HANGUL SYLLABLE NIEUN YU PIEUP
  {0xB4BF, 0xB289}, //8771 #HANGUL SYLLABLE NIEUN YU IEUNG
  {0xB4C0, 0xB290}, //8772 #HANGUL SYLLABLE NIEUN EU
  {0xB4C1, 0xB291}, //8773 #HANGUL SYLLABLE NIEUN EU KIYEOK
  {0xB4C2, 0xB294}, //8774 #HANGUL SYLLABLE NIEUN EU NIEUN
  {0xB4C3, 0xB298}, //8775 #HANGUL SYLLABLE NIEUN EU RIEUL
  {0xB4C4, 0xB299}, //8776 #HANGUL SYLLABLE NIEUN EU RIEULKIYEOK
  {0xB4C5, 0xB29A}, //8777 #HANGUL SYLLABLE NIEUN EU RIEULMIEUM
  {0xB4C6, 0xB2A0}, //8778 #HANGUL SYLLABLE NIEUN EU MIEUM
  {0xB4C7, 0xB2A1}, //8779 #HANGUL SYLLABLE NIEUN EU PIEUP
  {0xB4C8, 0xB2A3}, //8780 #HANGUL SYLLABLE NIEUN EU SIOS
  {0xB4C9, 0xB2A5}, //8781 #HANGUL SYLLABLE NIEUN EU IEUNG
  {0xB4CA, 0xB2A6}, //8782 #HANGUL SYLLABLE NIEUN EU CIEUC
  {0xB4CB, 0xB2AA}, //8783 #HANGUL SYLLABLE NIEUN EU PHIEUPH
  {0xB4CC, 0xB2AC}, //8784 #HANGUL SYLLABLE NIEUN YI
  {0xB4CD, 0xB2B0}, //8785 #HANGUL SYLLABLE NIEUN YI NIEUN
  {0xB4CE, 0xB2B4}, //8786 #HANGUL SYLLABLE NIEUN YI RIEUL
  {0xB4CF, 0xB2C8}, //8787 #HANGUL SYLLABLE NIEUN I
  {0xB4D0, 0xB2C9}, //8788 #HANGUL SYLLABLE NIEUN I KIYEOK
  {0xB4D1, 0xB2CC}, //8789 #HANGUL SYLLABLE NIEUN I NIEUN
  {0xB4D2, 0xB2D0}, //8790 #HANGUL SYLLABLE NIEUN I RIEUL
  {0xB4D3, 0xB2D2}, //8791 #HANGUL SYLLABLE NIEUN I RIEULMIEUM
  {0xB4D4, 0xB2D8}, //8792 #HANGUL SYLLABLE NIEUN I MIEUM
  {0xB4D5, 0xB2D9}, //8793 #HANGUL SYLLABLE NIEUN I PIEUP
  {0xB4D6, 0xB2DB}, //8794 #HANGUL SYLLABLE NIEUN I SIOS
  {0xB4D7, 0xB2DD}, //8795 #HANGUL SYLLABLE NIEUN I IEUNG
  {0xB4D8, 0xB2E2}, //8796 #HANGUL SYLLABLE NIEUN I PHIEUPH
  {0xB4D9, 0xB2E4}, //8797 #HANGUL SYLLABLE TIKEUT A
  {0xB4DA, 0xB2E5}, //8798 #HANGUL SYLLABLE TIKEUT A KIYEOK
  {0xB4DB, 0xB2E6}, //8799 #HANGUL SYLLABLE TIKEUT A SSANGKIYEOK
  {0xB4DC, 0xB2E8}, //8800 #HANGUL SYLLABLE TIKEUT A NIEUN
  {0xB4DD, 0xB2EB}, //8801 #HANGUL SYLLABLE TIKEUT A TIKEUT
  {0xB4DE, 0xB2EC}, //8802 #HANGUL SYLLABLE TIKEUT A RIEUL
  {0xB4DF, 0xB2ED}, //8803 #HANGUL SYLLABLE TIKEUT A RIEULKIYEOK
  {0xB4E0, 0xB2EE}, //8804 #HANGUL SYLLABLE TIKEUT A RIEULMIEUM
  {0xB4E1, 0xB2EF}, //8805 #HANGUL SYLLABLE TIKEUT A RIEULPIEUP
  {0xB4E2, 0xB2F3}, //8806 #HANGUL SYLLABLE TIKEUT A RIEULHIEUH
  {0xB4E3, 0xB2F4}, //8807 #HANGUL SYLLABLE TIKEUT A MIEUM
  {0xB4E4, 0xB2F5}, //8808 #HANGUL SYLLABLE TIKEUT A PIEUP
  {0xB4E5, 0xB2F7}, //8809 #HANGUL SYLLABLE TIKEUT A SIOS
  {0xB4E6, 0xB2F8}, //8810 #HANGUL SYLLABLE TIKEUT A SSANGSIOS
  {0xB4E7, 0xB2F9}, //8811 #HANGUL SYLLABLE TIKEUT A IEUNG
  {0xB4E8, 0xB2FA}, //8812 #HANGUL SYLLABLE TIKEUT A CIEUC
  {0xB4E9, 0xB2FB}, //8813 #HANGUL SYLLABLE TIKEUT A CHIEUCH
  {0xB4EA, 0xB2FF}, //8814 #HANGUL SYLLABLE TIKEUT A HIEUH
  {0xB4EB, 0xB300}, //8815 #HANGUL SYLLABLE TIKEUT AE
  {0xB4EC, 0xB301}, //8816 #HANGUL SYLLABLE TIKEUT AE KIYEOK
  {0xB4ED, 0xB304}, //8817 #HANGUL SYLLABLE TIKEUT AE NIEUN
  {0xB4EE, 0xB308}, //8818 #HANGUL SYLLABLE TIKEUT AE RIEUL
  {0xB4EF, 0xB310}, //8819 #HANGUL SYLLABLE TIKEUT AE MIEUM
  {0xB4F0, 0xB311}, //8820 #HANGUL SYLLABLE TIKEUT AE PIEUP
  {0xB4F1, 0xB313}, //8821 #HANGUL SYLLABLE TIKEUT AE SIOS
  {0xB4F2, 0xB314}, //8822 #HANGUL SYLLABLE TIKEUT AE SSANGSIOS
  {0xB4F3, 0xB315}, //8823 #HANGUL SYLLABLE TIKEUT AE IEUNG
  {0xB4F4, 0xB31C}, //8824 #HANGUL SYLLABLE TIKEUT YA
  {0xB4F5, 0xB354}, //8825 #HANGUL SYLLABLE TIKEUT EO
  {0xB4F6, 0xB355}, //8826 #HANGUL SYLLABLE TIKEUT EO KIYEOK
  {0xB4F7, 0xB356}, //8827 #HANGUL SYLLABLE TIKEUT EO SSANGKIYEOK
  {0xB4F8, 0xB358}, //8828 #HANGUL SYLLABLE TIKEUT EO NIEUN
  {0xB4F9, 0xB35B}, //8829 #HANGUL SYLLABLE TIKEUT EO TIKEUT
  {0xB4FA, 0xB35C}, //8830 #HANGUL SYLLABLE TIKEUT EO RIEUL
  {0xB4FB, 0xB35E}, //8831 #HANGUL SYLLABLE TIKEUT EO RIEULMIEUM
  {0xB4FC, 0xB35F}, //8832 #HANGUL SYLLABLE TIKEUT EO RIEULPIEUP
  {0xB4FD, 0xB364}, //8833 #HANGUL SYLLABLE TIKEUT EO MIEUM
  {0xB4FE, 0xB365}, //8834 #HANGUL SYLLABLE TIKEUT EO PIEUP
  {0xB541, 0xD095}, //8835 #HANGUL SYLLABLE KHIEUKH YI RIEULTHIEUTH
  {0xB542, 0xD096}, //8836 #HANGUL SYLLABLE KHIEUKH YI RIEULPHIEUPH
  {0xB543, 0xD097}, //8837 #HANGUL SYLLABLE KHIEUKH YI RIEULHIEUH
  {0xB544, 0xD098}, //8838 #HANGUL SYLLABLE KHIEUKH YI MIEUM
  {0xB545, 0xD099}, //8839 #HANGUL SYLLABLE KHIEUKH YI PIEUP
  {0xB546, 0xD09A}, //8840 #HANGUL SYLLABLE KHIEUKH YI PIEUPSIOS
  {0xB547, 0xD09B}, //8841 #HANGUL SYLLABLE KHIEUKH YI SIOS
  {0xB548, 0xD09C}, //8842 #HANGUL SYLLABLE KHIEUKH YI SSANGSIOS
  {0xB549, 0xD09D}, //8843 #HANGUL SYLLABLE KHIEUKH YI IEUNG
  {0xB54A, 0xD09E}, //8844 #HANGUL SYLLABLE KHIEUKH YI CIEUC
  {0xB54B, 0xD09F}, //8845 #HANGUL SYLLABLE KHIEUKH YI CHIEUCH
  {0xB54C, 0xD0A0}, //8846 #HANGUL SYLLABLE KHIEUKH YI KHIEUKH
  {0xB54D, 0xD0A1}, //8847 #HANGUL SYLLABLE KHIEUKH YI THIEUTH
  {0xB54E, 0xD0A2}, //8848 #HANGUL SYLLABLE KHIEUKH YI PHIEUPH
  {0xB54F, 0xD0A3}, //8849 #HANGUL SYLLABLE KHIEUKH YI HIEUH
  {0xB550, 0xD0A6}, //8850 #HANGUL SYLLABLE KHIEUKH I SSANGKIYEOK
  {0xB551, 0xD0A7}, //8851 #HANGUL SYLLABLE KHIEUKH I KIYEOKSIOS
  {0xB552, 0xD0A9}, //8852 #HANGUL SYLLABLE KHIEUKH I NIEUNCIEUC
  {0xB553, 0xD0AA}, //8853 #HANGUL SYLLABLE KHIEUKH I NIEUNHIEUH
  {0xB554, 0xD0AB}, //8854 #HANGUL SYLLABLE KHIEUKH I TIKEUT
  {0xB555, 0xD0AD}, //8855 #HANGUL SYLLABLE KHIEUKH I RIEULKIYEOK
  {0xB556, 0xD0AE}, //8856 #HANGUL SYLLABLE KHIEUKH I RIEULMIEUM
  {0xB557, 0xD0AF}, //8857 #HANGUL SYLLABLE KHIEUKH I RIEULPIEUP
  {0xB558, 0xD0B0}, //8858 #HANGUL SYLLABLE KHIEUKH I RIEULSIOS
  {0xB559, 0xD0B1}, //8859 #HANGUL SYLLABLE KHIEUKH I RIEULTHIEUTH
  {0xB55A, 0xD0B2}, //8860 #HANGUL SYLLABLE KHIEUKH I RIEULPHIEUPH
  {0xB561, 0xD0B3}, //8861 #HANGUL SYLLABLE KHIEUKH I RIEULHIEUH
  {0xB562, 0xD0B6}, //8862 #HANGUL SYLLABLE KHIEUKH I PIEUPSIOS
  {0xB563, 0xD0B8}, //8863 #HANGUL SYLLABLE KHIEUKH I SSANGSIOS
  {0xB564, 0xD0BA}, //8864 #HANGUL SYLLABLE KHIEUKH I CIEUC
  {0xB565, 0xD0BB}, //8865 #HANGUL SYLLABLE KHIEUKH I CHIEUCH
  {0xB566, 0xD0BC}, //8866 #HANGUL SYLLABLE KHIEUKH I KHIEUKH
  {0xB567, 0xD0BD}, //8867 #HANGUL SYLLABLE KHIEUKH I THIEUTH
  {0xB568, 0xD0BE}, //8868 #HANGUL SYLLABLE KHIEUKH I PHIEUPH
  {0xB569, 0xD0BF}, //8869 #HANGUL SYLLABLE KHIEUKH I HIEUH
  {0xB56A, 0xD0C2}, //8870 #HANGUL SYLLABLE THIEUTH A SSANGKIYEOK
  {0xB56B, 0xD0C3}, //8871 #HANGUL SYLLABLE THIEUTH A KIYEOKSIOS
  {0xB56C, 0xD0C5}, //8872 #HANGUL SYLLABLE THIEUTH A NIEUNCIEUC
  {0xB56D, 0xD0C6}, //8873 #HANGUL SYLLABLE THIEUTH A NIEUNHIEUH
  {0xB56E, 0xD0C7}, //8874 #HANGUL SYLLABLE THIEUTH A TIKEUT
  {0xB56F, 0xD0CA}, //8875 #HANGUL SYLLABLE THIEUTH A RIEULMIEUM
  {0xB570, 0xD0CB}, //8876 #HANGUL SYLLABLE THIEUTH A RIEULPIEUP
  {0xB571, 0xD0CC}, //8877 #HANGUL SYLLABLE THIEUTH A RIEULSIOS
  {0xB572, 0xD0CD}, //8878 #HANGUL SYLLABLE THIEUTH A RIEULTHIEUTH
  {0xB573, 0xD0CE}, //8879 #HANGUL SYLLABLE THIEUTH A RIEULPHIEUPH
  {0xB574, 0xD0CF}, //8880 #HANGUL SYLLABLE THIEUTH A RIEULHIEUH
  {0xB575, 0xD0D2}, //8881 #HANGUL SYLLABLE THIEUTH A PIEUPSIOS
  {0xB576, 0xD0D6}, //8882 #HANGUL SYLLABLE THIEUTH A CIEUC
  {0xB577, 0xD0D7}, //8883 #HANGUL SYLLABLE THIEUTH A CHIEUCH
  {0xB578, 0xD0D8}, //8884 #HANGUL SYLLABLE THIEUTH A KHIEUKH
  {0xB579, 0xD0D9}, //8885 #HANGUL SYLLABLE THIEUTH A THIEUTH
  {0xB57A, 0xD0DA}, //8886 #HANGUL SYLLABLE THIEUTH A PHIEUPH
  {0xB581, 0xD0DB}, //8887 #HANGUL SYLLABLE THIEUTH A HIEUH
  {0xB582, 0xD0DE}, //8888 #HANGUL SYLLABLE THIEUTH AE SSANGKIYEOK
  {0xB583, 0xD0DF}, //8889 #HANGUL SYLLABLE THIEUTH AE KIYEOKSIOS
  {0xB584, 0xD0E1}, //8890 #HANGUL SYLLABLE THIEUTH AE NIEUNCIEUC
  {0xB585, 0xD0E2}, //8891 #HANGUL SYLLABLE THIEUTH AE NIEUNHIEUH
  {0xB586, 0xD0E3}, //8892 #HANGUL SYLLABLE THIEUTH AE TIKEUT
  {0xB587, 0xD0E5}, //8893 #HANGUL SYLLABLE THIEUTH AE RIEULKIYEOK
  {0xB588, 0xD0E6}, //8894 #HANGUL SYLLABLE THIEUTH AE RIEULMIEUM
  {0xB589, 0xD0E7}, //8895 #HANGUL SYLLABLE THIEUTH AE RIEULPIEUP
  {0xB58A, 0xD0E8}, //8896 #HANGUL SYLLABLE THIEUTH AE RIEULSIOS
  {0xB58B, 0xD0E9}, //8897 #HANGUL SYLLABLE THIEUTH AE RIEULTHIEUTH
  {0xB58C, 0xD0EA}, //8898 #HANGUL SYLLABLE THIEUTH AE RIEULPHIEUPH
  {0xB58D, 0xD0EB}, //8899 #HANGUL SYLLABLE THIEUTH AE RIEULHIEUH
  {0xB58E, 0xD0EE}, //8900 #HANGUL SYLLABLE THIEUTH AE PIEUPSIOS
  {0xB58F, 0xD0F2}, //8901 #HANGUL SYLLABLE THIEUTH AE CIEUC
  {0xB590, 0xD0F3}, //8902 #HANGUL SYLLABLE THIEUTH AE CHIEUCH
  {0xB591, 0xD0F4}, //8903 #HANGUL SYLLABLE THIEUTH AE KHIEUKH
  {0xB592, 0xD0F5}, //8904 #HANGUL SYLLABLE THIEUTH AE THIEUTH
  {0xB593, 0xD0F6}, //8905 #HANGUL SYLLABLE THIEUTH AE PHIEUPH
  {0xB594, 0xD0F7}, //8906 #HANGUL SYLLABLE THIEUTH AE HIEUH
  {0xB595, 0xD0F9}, //8907 #HANGUL SYLLABLE THIEUTH YA KIYEOK
  {0xB596, 0xD0FA}, //8908 #HANGUL SYLLABLE THIEUTH YA SSANGKIYEOK
  {0xB597, 0xD0FB}, //8909 #HANGUL SYLLABLE THIEUTH YA KIYEOKSIOS
  {0xB598, 0xD0FC}, //8910 #HANGUL SYLLABLE THIEUTH YA NIEUN
  {0xB599, 0xD0FD}, //8911 #HANGUL SYLLABLE THIEUTH YA NIEUNCIEUC
  {0xB59A, 0xD0FE}, //8912 #HANGUL SYLLABLE THIEUTH YA NIEUNHIEUH
  {0xB59B, 0xD0FF}, //8913 #HANGUL SYLLABLE THIEUTH YA TIKEUT
  {0xB59C, 0xD100}, //8914 #HANGUL SYLLABLE THIEUTH YA RIEUL
  {0xB59D, 0xD101}, //8915 #HANGUL SYLLABLE THIEUTH YA RIEULKIYEOK
  {0xB59E, 0xD102}, //8916 #HANGUL SYLLABLE THIEUTH YA RIEULMIEUM
  {0xB59F, 0xD103}, //8917 #HANGUL SYLLABLE THIEUTH YA RIEULPIEUP
  {0xB5A0, 0xD104}, //8918 #HANGUL SYLLABLE THIEUTH YA RIEULSIOS
  {0xB5A1, 0xB367}, //8919 #HANGUL SYLLABLE TIKEUT EO SIOS
  {0xB5A2, 0xB369}, //8920 #HANGUL SYLLABLE TIKEUT EO IEUNG
  {0xB5A3, 0xB36B}, //8921 #HANGUL SYLLABLE TIKEUT EO CHIEUCH
  {0xB5A4, 0xB36E}, //8922 #HANGUL SYLLABLE TIKEUT EO PHIEUPH
  {0xB5A5, 0xB370}, //8923 #HANGUL SYLLABLE TIKEUT E
  {0xB5A6, 0xB371}, //8924 #HANGUL SYLLABLE TIKEUT E KIYEOK
  {0xB5A7, 0xB374}, //8925 #HANGUL SYLLABLE TIKEUT E NIEUN
  {0xB5A8, 0xB378}, //8926 #HANGUL SYLLABLE TIKEUT E RIEUL
  {0xB5A9, 0xB380}, //8927 #HANGUL SYLLABLE TIKEUT E MIEUM
  {0xB5AA, 0xB381}, //8928 #HANGUL SYLLABLE TIKEUT E PIEUP
  {0xB5AB, 0xB383}, //8929 #HANGUL SYLLABLE TIKEUT E SIOS
  {0xB5AC, 0xB384}, //8930 #HANGUL SYLLABLE TIKEUT E SSANGSIOS
  {0xB5AD, 0xB385}, //8931 #HANGUL SYLLABLE TIKEUT E IEUNG
  {0xB5AE, 0xB38C}, //8932 #HANGUL SYLLABLE TIKEUT YEO
  {0xB5AF, 0xB390}, //8933 #HANGUL SYLLABLE TIKEUT YEO NIEUN
  {0xB5B0, 0xB394}, //8934 #HANGUL SYLLABLE TIKEUT YEO RIEUL
  {0xB5B1, 0xB3A0}, //8935 #HANGUL SYLLABLE TIKEUT YEO SSANGSIOS
  {0xB5B2, 0xB3A1}, //8936 #HANGUL SYLLABLE TIKEUT YEO IEUNG
  {0xB5B3, 0xB3A8}, //8937 #HANGUL SYLLABLE TIKEUT YE
  {0xB5B4, 0xB3AC}, //8938 #HANGUL SYLLABLE TIKEUT YE NIEUN
  {0xB5B5, 0xB3C4}, //8939 #HANGUL SYLLABLE TIKEUT O
  {0xB5B6, 0xB3C5}, //8940 #HANGUL SYLLABLE TIKEUT O KIYEOK
  {0xB5B7, 0xB3C8}, //8941 #HANGUL SYLLABLE TIKEUT O NIEUN
  {0xB5B8, 0xB3CB}, //8942 #HANGUL SYLLABLE TIKEUT O TIKEUT
  {0xB5B9, 0xB3CC}, //8943 #HANGUL SYLLABLE TIKEUT O RIEUL
  {0xB5BA, 0xB3CE}, //8944 #HANGUL SYLLABLE TIKEUT O RIEULMIEUM
  {0xB5BB, 0xB3D0}, //8945 #HANGUL SYLLABLE TIKEUT O RIEULSIOS
  {0xB5BC, 0xB3D4}, //8946 #HANGUL SYLLABLE TIKEUT O MIEUM
  {0xB5BD, 0xB3D5}, //8947 #HANGUL SYLLABLE TIKEUT O PIEUP
  {0xB5BE, 0xB3D7}, //8948 #HANGUL SYLLABLE TIKEUT O SIOS
  {0xB5BF, 0xB3D9}, //8949 #HANGUL SYLLABLE TIKEUT O IEUNG
  {0xB5C0, 0xB3DB}, //8950 #HANGUL SYLLABLE TIKEUT O CHIEUCH
  {0xB5C1, 0xB3DD}, //8951 #HANGUL SYLLABLE TIKEUT O THIEUTH
  {0xB5C2, 0xB3E0}, //8952 #HANGUL SYLLABLE TIKEUT WA
  {0xB5C3, 0xB3E4}, //8953 #HANGUL SYLLABLE TIKEUT WA NIEUN
  {0xB5C4, 0xB3E8}, //8954 #HANGUL SYLLABLE TIKEUT WA RIEUL
  {0xB5C5, 0xB3FC}, //8955 #HANGUL SYLLABLE TIKEUT WAE
  {0xB5C6, 0xB410}, //8956 #HANGUL SYLLABLE TIKEUT WAE SSANGSIOS
  {0xB5C7, 0xB418}, //8957 #HANGUL SYLLABLE TIKEUT OE
  {0xB5C8, 0xB41C}, //8958 #HANGUL SYLLABLE TIKEUT OE NIEUN
  {0xB5C9, 0xB420}, //8959 #HANGUL SYLLABLE TIKEUT OE RIEUL
  {0xB5CA, 0xB428}, //8960 #HANGUL SYLLABLE TIKEUT OE MIEUM
  {0xB5CB, 0xB429}, //8961 #HANGUL SYLLABLE TIKEUT OE PIEUP
  {0xB5CC, 0xB42B}, //8962 #HANGUL SYLLABLE TIKEUT OE SIOS
  {0xB5CD, 0xB434}, //8963 #HANGUL SYLLABLE TIKEUT YO
  {0xB5CE, 0xB450}, //8964 #HANGUL SYLLABLE TIKEUT U
  {0xB5CF, 0xB451}, //8965 #HANGUL SYLLABLE TIKEUT U KIYEOK
  {0xB5D0, 0xB454}, //8966 #HANGUL SYLLABLE TIKEUT U NIEUN
  {0xB5D1, 0xB458}, //8967 #HANGUL SYLLABLE TIKEUT U RIEUL
  {0xB5D2, 0xB460}, //8968 #HANGUL SYLLABLE TIKEUT U MIEUM
  {0xB5D3, 0xB461}, //8969 #HANGUL SYLLABLE TIKEUT U PIEUP
  {0xB5D4, 0xB463}, //8970 #HANGUL SYLLABLE TIKEUT U SIOS
  {0xB5D5, 0xB465}, //8971 #HANGUL SYLLABLE TIKEUT U IEUNG
  {0xB5D6, 0xB46C}, //8972 #HANGUL SYLLABLE TIKEUT WEO
  {0xB5D7, 0xB480}, //8973 #HANGUL SYLLABLE TIKEUT WEO SSANGSIOS
  {0xB5D8, 0xB488}, //8974 #HANGUL SYLLABLE TIKEUT WE
  {0xB5D9, 0xB49D}, //8975 #HANGUL SYLLABLE TIKEUT WE IEUNG
  {0xB5DA, 0xB4A4}, //8976 #HANGUL SYLLABLE TIKEUT WI
  {0xB5DB, 0xB4A8}, //8977 #HANGUL SYLLABLE TIKEUT WI NIEUN
  {0xB5DC, 0xB4AC}, //8978 #HANGUL SYLLABLE TIKEUT WI RIEUL
  {0xB5DD, 0xB4B5}, //8979 #HANGUL SYLLABLE TIKEUT WI PIEUP
  {0xB5DE, 0xB4B7}, //8980 #HANGUL SYLLABLE TIKEUT WI SIOS
  {0xB5DF, 0xB4B9}, //8981 #HANGUL SYLLABLE TIKEUT WI IEUNG
  {0xB5E0, 0xB4C0}, //8982 #HANGUL SYLLABLE TIKEUT YU
  {0xB5E1, 0xB4C4}, //8983 #HANGUL SYLLABLE TIKEUT YU NIEUN
  {0xB5E2, 0xB4C8}, //8984 #HANGUL SYLLABLE TIKEUT YU RIEUL
  {0xB5E3, 0xB4D0}, //8985 #HANGUL SYLLABLE TIKEUT YU MIEUM
  {0xB5E4, 0xB4D5}, //8986 #HANGUL SYLLABLE TIKEUT YU IEUNG
  {0xB5E5, 0xB4DC}, //8987 #HANGUL SYLLABLE TIKEUT EU
  {0xB5E6, 0xB4DD}, //8988 #HANGUL SYLLABLE TIKEUT EU KIYEOK
  {0xB5E7, 0xB4E0}, //8989 #HANGUL SYLLABLE TIKEUT EU NIEUN
  {0xB5E8, 0xB4E3}, //8990 #HANGUL SYLLABLE TIKEUT EU TIKEUT
  {0xB5E9, 0xB4E4}, //8991 #HANGUL SYLLABLE TIKEUT EU RIEUL
  {0xB5EA, 0xB4E6}, //8992 #HANGUL SYLLABLE TIKEUT EU RIEULMIEUM
  {0xB5EB, 0xB4EC}, //8993 #HANGUL SYLLABLE TIKEUT EU MIEUM
  {0xB5EC, 0xB4ED}, //8994 #HANGUL SYLLABLE TIKEUT EU PIEUP
  {0xB5ED, 0xB4EF}, //8995 #HANGUL SYLLABLE TIKEUT EU SIOS
  {0xB5EE, 0xB4F1}, //8996 #HANGUL SYLLABLE TIKEUT EU IEUNG
  {0xB5EF, 0xB4F8}, //8997 #HANGUL SYLLABLE TIKEUT YI
  {0xB5F0, 0xB514}, //8998 #HANGUL SYLLABLE TIKEUT I
  {0xB5F1, 0xB515}, //8999 #HANGUL SYLLABLE TIKEUT I KIYEOK
  {0xB5F2, 0xB518}, //9000 #HANGUL SYLLABLE TIKEUT I NIEUN
  {0xB5F3, 0xB51B}, //9001 #HANGUL SYLLABLE TIKEUT I TIKEUT
  {0xB5F4, 0xB51C}, //9002 #HANGUL SYLLABLE TIKEUT I RIEUL
  {0xB5F5, 0xB524}, //9003 #HANGUL SYLLABLE TIKEUT I MIEUM
  {0xB5F6, 0xB525}, //9004 #HANGUL SYLLABLE TIKEUT I PIEUP
  {0xB5F7, 0xB527}, //9005 #HANGUL SYLLABLE TIKEUT I SIOS
  {0xB5F8, 0xB528}, //9006 #HANGUL SYLLABLE TIKEUT I SSANGSIOS
  {0xB5F9, 0xB529}, //9007 #HANGUL SYLLABLE TIKEUT I IEUNG
  {0xB5FA, 0xB52A}, //9008 #HANGUL SYLLABLE TIKEUT I CIEUC
  {0xB5FB, 0xB530}, //9009 #HANGUL SYLLABLE SSANGTIKEUT A
  {0xB5FC, 0xB531}, //9010 #HANGUL SYLLABLE SSANGTIKEUT A KIYEOK
  {0xB5FD, 0xB534}, //9011 #HANGUL SYLLABLE SSANGTIKEUT A NIEUN
  {0xB5FE, 0xB538}, //9012 #HANGUL SYLLABLE SSANGTIKEUT A RIEUL
  {0xB641, 0xD105}, //9013 #HANGUL SYLLABLE THIEUTH YA RIEULTHIEUTH
  {0xB642, 0xD106}, //9014 #HANGUL SYLLABLE THIEUTH YA RIEULPHIEUPH
  {0xB643, 0xD107}, //9015 #HANGUL SYLLABLE THIEUTH YA RIEULHIEUH
  {0xB644, 0xD108}, //9016 #HANGUL SYLLABLE THIEUTH YA MIEUM
  {0xB645, 0xD109}, //9017 #HANGUL SYLLABLE THIEUTH YA PIEUP
  {0xB646, 0xD10A}, //9018 #HANGUL SYLLABLE THIEUTH YA PIEUPSIOS
  {0xB647, 0xD10B}, //9019 #HANGUL SYLLABLE THIEUTH YA SIOS
  {0xB648, 0xD10C}, //9020 #HANGUL SYLLABLE THIEUTH YA SSANGSIOS
  {0xB649, 0xD10E}, //9021 #HANGUL SYLLABLE THIEUTH YA CIEUC
  {0xB64A, 0xD10F}, //9022 #HANGUL SYLLABLE THIEUTH YA CHIEUCH
  {0xB64B, 0xD110}, //9023 #HANGUL SYLLABLE THIEUTH YA KHIEUKH
  {0xB64C, 0xD111}, //9024 #HANGUL SYLLABLE THIEUTH YA THIEUTH
  {0xB64D, 0xD112}, //9025 #HANGUL SYLLABLE THIEUTH YA PHIEUPH
  {0xB64E, 0xD113}, //9026 #HANGUL SYLLABLE THIEUTH YA HIEUH
  {0xB64F, 0xD114}, //9027 #HANGUL SYLLABLE THIEUTH YAE
  {0xB650, 0xD115}, //9028 #HANGUL SYLLABLE THIEUTH YAE KIYEOK
  {0xB651, 0xD116}, //9029 #HANGUL SYLLABLE THIEUTH YAE SSANGKIYEOK
  {0xB652, 0xD117}, //9030 #HANGUL SYLLABLE THIEUTH YAE KIYEOKSIOS
  {0xB653, 0xD118}, //9031 #HANGUL SYLLABLE THIEUTH YAE NIEUN
  {0xB654, 0xD119}, //9032 #HANGUL SYLLABLE THIEUTH YAE NIEUNCIEUC
  {0xB655, 0xD11A}, //9033 #HANGUL SYLLABLE THIEUTH YAE NIEUNHIEUH
  {0xB656, 0xD11B}, //9034 #HANGUL SYLLABLE THIEUTH YAE TIKEUT
  {0xB657, 0xD11C}, //9035 #HANGUL SYLLABLE THIEUTH YAE RIEUL
  {0xB658, 0xD11D}, //9036 #HANGUL SYLLABLE THIEUTH YAE RIEULKIYEOK
  {0xB659, 0xD11E}, //9037 #HANGUL SYLLABLE THIEUTH YAE RIEULMIEUM
  {0xB65A, 0xD11F}, //9038 #HANGUL SYLLABLE THIEUTH YAE RIEULPIEUP
  {0xB661, 0xD120}, //9039 #HANGUL SYLLABLE THIEUTH YAE RIEULSIOS
  {0xB662, 0xD121}, //9040 #HANGUL SYLLABLE THIEUTH YAE RIEULTHIEUTH
  {0xB663, 0xD122}, //9041 #HANGUL SYLLABLE THIEUTH YAE RIEULPHIEUPH
  {0xB664, 0xD123}, //9042 #HANGUL SYLLABLE THIEUTH YAE RIEULHIEUH
  {0xB665, 0xD124}, //9043 #HANGUL SYLLABLE THIEUTH YAE MIEUM
  {0xB666, 0xD125}, //9044 #HANGUL SYLLABLE THIEUTH YAE PIEUP
  {0xB667, 0xD126}, //9045 #HANGUL SYLLABLE THIEUTH YAE PIEUPSIOS
  {0xB668, 0xD127}, //9046 #HANGUL SYLLABLE THIEUTH YAE SIOS
  {0xB669, 0xD128}, //9047 #HANGUL SYLLABLE THIEUTH YAE SSANGSIOS
  {0xB66A, 0xD129}, //9048 #HANGUL SYLLABLE THIEUTH YAE IEUNG
  {0xB66B, 0xD12A}, //9049 #HANGUL SYLLABLE THIEUTH YAE CIEUC
  {0xB66C, 0xD12B}, //9050 #HANGUL SYLLABLE THIEUTH YAE CHIEUCH
  {0xB66D, 0xD12C}, //9051 #HANGUL SYLLABLE THIEUTH YAE KHIEUKH
  {0xB66E, 0xD12D}, //9052 #HANGUL SYLLABLE THIEUTH YAE THIEUTH
  {0xB66F, 0xD12E}, //9053 #HANGUL SYLLABLE THIEUTH YAE PHIEUPH
  {0xB670, 0xD12F}, //9054 #HANGUL SYLLABLE THIEUTH YAE HIEUH
  {0xB671, 0xD132}, //9055 #HANGUL SYLLABLE THIEUTH EO SSANGKIYEOK
  {0xB672, 0xD133}, //9056 #HANGUL SYLLABLE THIEUTH EO KIYEOKSIOS
  {0xB673, 0xD135}, //9057 #HANGUL SYLLABLE THIEUTH EO NIEUNCIEUC
  {0xB674, 0xD136}, //9058 #HANGUL SYLLABLE THIEUTH EO NIEUNHIEUH
  {0xB675, 0xD137}, //9059 #HANGUL SYLLABLE THIEUTH EO TIKEUT
  {0xB676, 0xD139}, //9060 #HANGUL SYLLABLE THIEUTH EO RIEULKIYEOK
  {0xB677, 0xD13B}, //9061 #HANGUL SYLLABLE THIEUTH EO RIEULPIEUP
  {0xB678, 0xD13C}, //9062 #HANGUL SYLLABLE THIEUTH EO RIEULSIOS
  {0xB679, 0xD13D}, //9063 #HANGUL SYLLABLE THIEUTH EO RIEULTHIEUTH
  {0xB67A, 0xD13E}, //9064 #HANGUL SYLLABLE THIEUTH EO RIEULPHIEUPH
  {0xB681, 0xD13F}, //9065 #HANGUL SYLLABLE THIEUTH EO RIEULHIEUH
  {0xB682, 0xD142}, //9066 #HANGUL SYLLABLE THIEUTH EO PIEUPSIOS
  {0xB683, 0xD146}, //9067 #HANGUL SYLLABLE THIEUTH EO CIEUC
  {0xB684, 0xD147}, //9068 #HANGUL SYLLABLE THIEUTH EO CHIEUCH
  {0xB685, 0xD148}, //9069 #HANGUL SYLLABLE THIEUTH EO KHIEUKH
  {0xB686, 0xD149}, //9070 #HANGUL SYLLABLE THIEUTH EO THIEUTH
  {0xB687, 0xD14A}, //9071 #HANGUL SYLLABLE THIEUTH EO PHIEUPH
  {0xB688, 0xD14B}, //9072 #HANGUL SYLLABLE THIEUTH EO HIEUH
  {0xB689, 0xD14E}, //9073 #HANGUL SYLLABLE THIEUTH E SSANGKIYEOK
  {0xB68A, 0xD14F}, //9074 #HANGUL SYLLABLE THIEUTH E KIYEOKSIOS
  {0xB68B, 0xD151}, //9075 #HANGUL SYLLABLE THIEUTH E NIEUNCIEUC
  {0xB68C, 0xD152}, //9076 #HANGUL SYLLABLE THIEUTH E NIEUNHIEUH
  {0xB68D, 0xD153}, //9077 #HANGUL SYLLABLE THIEUTH E TIKEUT
  {0xB68E, 0xD155}, //9078 #HANGUL SYLLABLE THIEUTH E RIEULKIYEOK
  {0xB68F, 0xD156}, //9079 #HANGUL SYLLABLE THIEUTH E RIEULMIEUM
  {0xB690, 0xD157}, //9080 #HANGUL SYLLABLE THIEUTH E RIEULPIEUP
  {0xB691, 0xD158}, //9081 #HANGUL SYLLABLE THIEUTH E RIEULSIOS
  {0xB692, 0xD159}, //9082 #HANGUL SYLLABLE THIEUTH E RIEULTHIEUTH
  {0xB693, 0xD15A}, //9083 #HANGUL SYLLABLE THIEUTH E RIEULPHIEUPH
  {0xB694, 0xD15B}, //9084 #HANGUL SYLLABLE THIEUTH E RIEULHIEUH
  {0xB695, 0xD15E}, //9085 #HANGUL SYLLABLE THIEUTH E PIEUPSIOS
  {0xB696, 0xD160}, //9086 #HANGUL SYLLABLE THIEUTH E SSANGSIOS
  {0xB697, 0xD162}, //9087 #HANGUL SYLLABLE THIEUTH E CIEUC
  {0xB698, 0xD163}, //9088 #HANGUL SYLLABLE THIEUTH E CHIEUCH
  {0xB699, 0xD164}, //9089 #HANGUL SYLLABLE THIEUTH E KHIEUKH
  {0xB69A, 0xD165}, //9090 #HANGUL SYLLABLE THIEUTH E THIEUTH
  {0xB69B, 0xD166}, //9091 #HANGUL SYLLABLE THIEUTH E PHIEUPH
  {0xB69C, 0xD167}, //9092 #HANGUL SYLLABLE THIEUTH E HIEUH
  {0xB69D, 0xD169}, //9093 #HANGUL SYLLABLE THIEUTH YEO KIYEOK
  {0xB69E, 0xD16A}, //9094 #HANGUL SYLLABLE THIEUTH YEO SSANGKIYEOK
  {0xB69F, 0xD16B}, //9095 #HANGUL SYLLABLE THIEUTH YEO KIYEOKSIOS
  {0xB6A0, 0xD16D}, //9096 #HANGUL SYLLABLE THIEUTH YEO NIEUNCIEUC
  {0xB6A1, 0xB540}, //9097 #HANGUL SYLLABLE SSANGTIKEUT A MIEUM
  {0xB6A2, 0xB541}, //9098 #HANGUL SYLLABLE SSANGTIKEUT A PIEUP
  {0xB6A3, 0xB543}, //9099 #HANGUL SYLLABLE SSANGTIKEUT A SIOS
  {0xB6A4, 0xB544}, //9100 #HANGUL SYLLABLE SSANGTIKEUT A SSANGSIOS
  {0xB6A5, 0xB545}, //9101 #HANGUL SYLLABLE SSANGTIKEUT A IEUNG
  {0xB6A6, 0xB54B}, //9102 #HANGUL SYLLABLE SSANGTIKEUT A HIEUH
  {0xB6A7, 0xB54C}, //9103 #HANGUL SYLLABLE SSANGTIKEUT AE
  {0xB6A8, 0xB54D}, //9104 #HANGUL SYLLABLE SSANGTIKEUT AE KIYEOK
  {0xB6A9, 0xB550}, //9105 #HANGUL SYLLABLE SSANGTIKEUT AE NIEUN
  {0xB6AA, 0xB554}, //9106 #HANGUL SYLLABLE SSANGTIKEUT AE RIEUL
  {0xB6AB, 0xB55C}, //9107 #HANGUL SYLLABLE SSANGTIKEUT AE MIEUM
  {0xB6AC, 0xB55D}, //9108 #HANGUL SYLLABLE SSANGTIKEUT AE PIEUP
  {0xB6AD, 0xB55F}, //9109 #HANGUL SYLLABLE SSANGTIKEUT AE SIOS
  {0xB6AE, 0xB560}, //9110 #HANGUL SYLLABLE SSANGTIKEUT AE SSANGSIOS
  {0xB6AF, 0xB561}, //9111 #HANGUL SYLLABLE SSANGTIKEUT AE IEUNG
  {0xB6B0, 0xB5A0}, //9112 #HANGUL SYLLABLE SSANGTIKEUT EO
  {0xB6B1, 0xB5A1}, //9113 #HANGUL SYLLABLE SSANGTIKEUT EO KIYEOK
  {0xB6B2, 0xB5A4}, //9114 #HANGUL SYLLABLE SSANGTIKEUT EO NIEUN
  {0xB6B3, 0xB5A8}, //9115 #HANGUL SYLLABLE SSANGTIKEUT EO RIEUL
  {0xB6B4, 0xB5AA}, //9116 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULMIEUM
  {0xB6B5, 0xB5AB}, //9117 #HANGUL SYLLABLE SSANGTIKEUT EO RIEULPIEUP
  {0xB6B6, 0xB5B0}, //9118 #HANGUL SYLLABLE SSANGTIKEUT EO MIEUM
  {0xB6B7, 0xB5B1}, //9119 #HANGUL SYLLABLE SSANGTIKEUT EO PIEUP
  {0xB6B8, 0xB5B3}, //9120 #HANGUL SYLLABLE SSANGTIKEUT EO SIOS
  {0xB6B9, 0xB5B4}, //9121 #HANGUL SYLLABLE SSANGTIKEUT EO SSANGSIOS
  {0xB6BA, 0xB5B5}, //9122 #HANGUL SYLLABLE SSANGTIKEUT EO IEUNG
  {0xB6BB, 0xB5BB}, //9123 #HANGUL SYLLABLE SSANGTIKEUT EO HIEUH
  {0xB6BC, 0xB5BC}, //9124 #HANGUL SYLLABLE SSANGTIKEUT E
  {0xB6BD, 0xB5BD}, //9125 #HANGUL SYLLABLE SSANGTIKEUT E KIYEOK
  {0xB6BE, 0xB5C0}, //9126 #HANGUL SYLLABLE SSANGTIKEUT E NIEUN
  {0xB6BF, 0xB5C4}, //9127 #HANGUL SYLLABLE SSANGTIKEUT E RIEUL
  {0xB6C0, 0xB5CC}, //9128 #HANGUL SYLLABLE SSANGTIKEUT E MIEUM
  {0xB6C1, 0xB5CD}, //9129 #HANGUL SYLLABLE SSANGTIKEUT E PIEUP
  {0xB6C2, 0xB5CF}, //9130 #HANGUL SYLLABLE SSANGTIKEUT E SIOS
  {0xB6C3, 0xB5D0}, //9131 #HANGUL SYLLABLE SSANGTIKEUT E SSANGSIOS
  {0xB6C4, 0xB5D1}, //9132 #HANGUL SYLLABLE SSANGTIKEUT E IEUNG
  {0xB6C5, 0xB5D8}, //9133 #HANGUL SYLLABLE SSANGTIKEUT YEO
  {0xB6C6, 0xB5EC}, //9134 #HANGUL SYLLABLE SSANGTIKEUT YEO SSANGSIOS
  {0xB6C7, 0xB610}, //9135 #HANGUL SYLLABLE SSANGTIKEUT O
  {0xB6C8, 0xB611}, //9136 #HANGUL SYLLABLE SSANGTIKEUT O KIYEOK
  {0xB6C9, 0xB614}, //9137 #HANGUL SYLLABLE SSANGTIKEUT O NIEUN
  {0xB6CA, 0xB618}, //9138 #HANGUL SYLLABLE SSANGTIKEUT O RIEUL
  {0xB6CB, 0xB625}, //9139 #HANGUL SYLLABLE SSANGTIKEUT O IEUNG
  {0xB6CC, 0xB62C}, //9140 #HANGUL SYLLABLE SSANGTIKEUT WA
  {0xB6CD, 0xB634}, //9141 #HANGUL SYLLABLE SSANGTIKEUT WA RIEUL
  {0xB6CE, 0xB648}, //9142 #HANGUL SYLLABLE SSANGTIKEUT WAE
  {0xB6CF, 0xB664}, //9143 #HANGUL SYLLABLE SSANGTIKEUT OE
  {0xB6D0, 0xB668}, //9144 #HANGUL SYLLABLE SSANGTIKEUT OE NIEUN
  {0xB6D1, 0xB69C}, //9145 #HANGUL SYLLABLE SSANGTIKEUT U
  {0xB6D2, 0xB69D}, //9146 #HANGUL SYLLABLE SSANGTIKEUT U KIYEOK
  {0xB6D3, 0xB6A0}, //9147 #HANGUL SYLLABLE SSANGTIKEUT U NIEUN
  {0xB6D4, 0xB6A4}, //9148 #HANGUL SYLLABLE SSANGTIKEUT U RIEUL
  {0xB6D5, 0xB6AB}, //9149 #HANGUL SYLLABLE SSANGTIKEUT U RIEULHIEUH
  {0xB6D6, 0xB6AC}, //9150 #HANGUL SYLLABLE SSANGTIKEUT U MIEUM
  {0xB6D7, 0xB6B1}, //9151 #HANGUL SYLLABLE SSANGTIKEUT U IEUNG
  {0xB6D8, 0xB6D4}, //9152 #HANGUL SYLLABLE SSANGTIKEUT WE
  {0xB6D9, 0xB6F0}, //9153 #HANGUL SYLLABLE SSANGTIKEUT WI
  {0xB6DA, 0xB6F4}, //9154 #HANGUL SYLLABLE SSANGTIKEUT WI NIEUN
  {0xB6DB, 0xB6F8}, //9155 #HANGUL SYLLABLE SSANGTIKEUT WI RIEUL
  {0xB6DC, 0xB700}, //9156 #HANGUL SYLLABLE SSANGTIKEUT WI MIEUM
  {0xB6DD, 0xB701}, //9157 #HANGUL SYLLABLE SSANGTIKEUT WI PIEUP
  {0xB6DE, 0xB705}, //9158 #HANGUL SYLLABLE SSANGTIKEUT WI IEUNG
  {0xB6DF, 0xB728}, //9159 #HANGUL SYLLABLE SSANGTIKEUT EU
  {0xB6E0, 0xB729}, //9160 #HANGUL SYLLABLE SSANGTIKEUT EU KIYEOK
  {0xB6E1, 0xB72C}, //9161 #HANGUL SYLLABLE SSANGTIKEUT EU NIEUN
  {0xB6E2, 0xB72F}, //9162 #HANGUL SYLLABLE SSANGTIKEUT EU TIKEUT
  {0xB6E3, 0xB730}, //9163 #HANGUL SYLLABLE SSANGTIKEUT EU RIEUL
  {0xB6E4, 0xB738}, //9164 #HANGUL SYLLABLE SSANGTIKEUT EU MIEUM
  {0xB6E5, 0xB739}, //9165 #HANGUL SYLLABLE SSANGTIKEUT EU PIEUP
  {0xB6E6, 0xB73B}, //9166 #HANGUL SYLLABLE SSANGTIKEUT EU SIOS
  {0xB6E7, 0xB744}, //9167 #HANGUL SYLLABLE SSANGTIKEUT YI
  {0xB6E8, 0xB748}, //9168 #HANGUL SYLLABLE SSANGTIKEUT YI NIEUN
  {0xB6E9, 0xB74C}, //9169 #HANGUL SYLLABLE SSANGTIKEUT YI RIEUL
  {0xB6EA, 0xB754}, //9170 #HANGUL SYLLABLE SSANGTIKEUT YI MIEUM
  {0xB6EB, 0xB755}, //9171 #HANGUL SYLLABLE SSANGTIKEUT YI PIEUP
  {0xB6EC, 0xB760}, //9172 #HANGUL SYLLABLE SSANGTIKEUT I
  {0xB6ED, 0xB764}, //9173 #HANGUL SYLLABLE SSANGTIKEUT I NIEUN
  {0xB6EE, 0xB768}, //9174 #HANGUL SYLLABLE SSANGTIKEUT I RIEUL
  {0xB6EF, 0xB770}, //9175 #HANGUL SYLLABLE SSANGTIKEUT I MIEUM
  {0xB6F0, 0xB771}, //9176 #HANGUL SYLLABLE SSANGTIKEUT I PIEUP
  {0xB6F1, 0xB773}, //9177 #HANGUL SYLLABLE SSANGTIKEUT I SIOS
  {0xB6F2, 0xB775}, //9178 #HANGUL SYLLABLE SSANGTIKEUT I IEUNG
  {0xB6F3, 0xB77C}, //9179 #HANGUL SYLLABLE RIEUL A
  {0xB6F4, 0xB77D}, //9180 #HANGUL SYLLABLE RIEUL A KIYEOK
  {0xB6F5, 0xB780}, //9181 #HANGUL SYLLABLE RIEUL A NIEUN
  {0xB6F6, 0xB784}, //9182 #HANGUL SYLLABLE RIEUL A RIEUL
  {0xB6F7, 0xB78C}, //9183 #HANGUL SYLLABLE RIEUL A MIEUM
  {0xB6F8, 0xB78D}, //9184 #HANGUL SYLLABLE RIEUL A PIEUP
  {0xB6F9, 0xB78F}, //9185 #HANGUL SYLLABLE RIEUL A SIOS
  {0xB6FA, 0xB790}, //9186 #HANGUL SYLLABLE RIEUL A SSANGSIOS
  {0xB6FB, 0xB791}, //9187 #HANGUL SYLLABLE RIEUL A IEUNG
  {0xB6FC, 0xB792}, //9188 #HANGUL SYLLABLE RIEUL A CIEUC
  {0xB6FD, 0xB796}, //9189 #HANGUL SYLLABLE RIEUL A PHIEUPH
  {0xB6FE, 0xB797}, //9190 #HANGUL SYLLABLE RIEUL A HIEUH
  {0xB741, 0xD16E}, //9191 #HANGUL SYLLABLE THIEUTH YEO NIEUNHIEUH
  {0xB742, 0xD16F}, //9192 #HANGUL SYLLABLE THIEUTH YEO TIKEUT
  {0xB743, 0xD170}, //9193 #HANGUL SYLLABLE THIEUTH YEO RIEUL
  {0xB744, 0xD171}, //9194 #HANGUL SYLLABLE THIEUTH YEO RIEULKIYEOK
  {0xB745, 0xD172}, //9195 #HANGUL SYLLABLE THIEUTH YEO RIEULMIEUM
  {0xB746, 0xD173}, //9196 #HANGUL SYLLABLE THIEUTH YEO RIEULPIEUP
  {0xB747, 0xD174}, //9197 #HANGUL SYLLABLE THIEUTH YEO RIEULSIOS
  {0xB748, 0xD175}, //9198 #HANGUL SYLLABLE THIEUTH YEO RIEULTHIEUTH
  {0xB749, 0xD176}, //9199 #HANGUL SYLLABLE THIEUTH YEO RIEULPHIEUPH
  {0xB74A, 0xD177}, //9200 #HANGUL SYLLABLE THIEUTH YEO RIEULHIEUH
  {0xB74B, 0xD178}, //9201 #HANGUL SYLLABLE THIEUTH YEO MIEUM
  {0xB74C, 0xD179}, //9202 #HANGUL SYLLABLE THIEUTH YEO PIEUP
  {0xB74D, 0xD17A}, //9203 #HANGUL SYLLABLE THIEUTH YEO PIEUPSIOS
  {0xB74E, 0xD17B}, //9204 #HANGUL SYLLABLE THIEUTH YEO SIOS
  {0xB74F, 0xD17D}, //9205 #HANGUL SYLLABLE THIEUTH YEO IEUNG
  {0xB750, 0xD17E}, //9206 #HANGUL SYLLABLE THIEUTH YEO CIEUC
  {0xB751, 0xD17F}, //9207 #HANGUL SYLLABLE THIEUTH YEO CHIEUCH
  {0xB752, 0xD180}, //9208 #HANGUL SYLLABLE THIEUTH YEO KHIEUKH
  {0xB753, 0xD181}, //9209 #HANGUL SYLLABLE THIEUTH YEO THIEUTH
  {0xB754, 0xD182}, //9210 #HANGUL SYLLABLE THIEUTH YEO PHIEUPH
  {0xB755, 0xD183}, //9211 #HANGUL SYLLABLE THIEUTH YEO HIEUH
  {0xB756, 0xD185}, //9212 #HANGUL SYLLABLE THIEUTH YE KIYEOK
  {0xB757, 0xD186}, //9213 #HANGUL SYLLABLE THIEUTH YE SSANGKIYEOK
  {0xB758, 0xD187}, //9214 #HANGUL SYLLABLE THIEUTH YE KIYEOKSIOS
  {0xB759, 0xD189}, //9215 #HANGUL SYLLABLE THIEUTH YE NIEUNCIEUC
  {0xB75A, 0xD18A}, //9216 #HANGUL SYLLABLE THIEUTH YE NIEUNHIEUH
  {0xB761, 0xD18B}, //9217 #HANGUL SYLLABLE THIEUTH YE TIKEUT
  {0xB762, 0xD18C}, //9218 #HANGUL SYLLABLE THIEUTH YE RIEUL
  {0xB763, 0xD18D}, //9219 #HANGUL SYLLABLE THIEUTH YE RIEULKIYEOK
  {0xB764, 0xD18E}, //9220 #HANGUL SYLLABLE THIEUTH YE RIEULMIEUM
  {0xB765, 0xD18F}, //9221 #HANGUL SYLLABLE THIEUTH YE RIEULPIEUP
  {0xB766, 0xD190}, //9222 #HANGUL SYLLABLE THIEUTH YE RIEULSIOS
  {0xB767, 0xD191}, //9223 #HANGUL SYLLABLE THIEUTH YE RIEULTHIEUTH
  {0xB768, 0xD192}, //9224 #HANGUL SYLLABLE THIEUTH YE RIEULPHIEUPH
  {0xB769, 0xD193}, //9225 #HANGUL SYLLABLE THIEUTH YE RIEULHIEUH
  {0xB76A, 0xD194}, //9226 #HANGUL SYLLABLE THIEUTH YE MIEUM
  {0xB76B, 0xD195}, //9227 #HANGUL SYLLABLE THIEUTH YE PIEUP
  {0xB76C, 0xD196}, //9228 #HANGUL SYLLABLE THIEUTH YE PIEUPSIOS
  {0xB76D, 0xD197}, //9229 #HANGUL SYLLABLE THIEUTH YE SIOS
  {0xB76E, 0xD198}, //9230 #HANGUL SYLLABLE THIEUTH YE SSANGSIOS
  {0xB76F, 0xD199}, //9231 #HANGUL SYLLABLE THIEUTH YE IEUNG
  {0xB770, 0xD19A}, //9232 #HANGUL SYLLABLE THIEUTH YE CIEUC
  {0xB771, 0xD19B}, //9233 #HANGUL SYLLABLE THIEUTH YE CHIEUCH
  {0xB772, 0xD19C}, //9234 #HANGUL SYLLABLE THIEUTH YE KHIEUKH
  {0xB773, 0xD19D}, //9235 #HANGUL SYLLABLE THIEUTH YE THIEUTH
  {0xB774, 0xD19E}, //9236 #HANGUL SYLLABLE THIEUTH YE PHIEUPH
  {0xB775, 0xD19F}, //9237 #HANGUL SYLLABLE THIEUTH YE HIEUH
  {0xB776, 0xD1A2}, //9238 #HANGUL SYLLABLE THIEUTH O SSANGKIYEOK
  {0xB777, 0xD1A3}, //9239 #HANGUL SYLLABLE THIEUTH O KIYEOKSIOS
  {0xB778, 0xD1A5}, //9240 #HANGUL SYLLABLE THIEUTH O NIEUNCIEUC
  {0xB779, 0xD1A6}, //9241 #HANGUL SYLLABLE THIEUTH O NIEUNHIEUH
  {0xB77A, 0xD1A7}, //9242 #HANGUL SYLLABLE THIEUTH O TIKEUT
  {0xB781, 0xD1A9}, //9243 #HANGUL SYLLABLE THIEUTH O RIEULKIYEOK
  {0xB782, 0xD1AA}, //9244 #HANGUL SYLLABLE THIEUTH O RIEULMIEUM
  {0xB783, 0xD1AB}, //9245 #HANGUL SYLLABLE THIEUTH O RIEULPIEUP
  {0xB784, 0xD1AC}, //9246 #HANGUL SYLLABLE THIEUTH O RIEULSIOS
  {0xB785, 0xD1AD}, //9247 #HANGUL SYLLABLE THIEUTH O RIEULTHIEUTH
  {0xB786, 0xD1AE}, //9248 #HANGUL SYLLABLE THIEUTH O RIEULPHIEUPH
  {0xB787, 0xD1AF}, //9249 #HANGUL SYLLABLE THIEUTH O RIEULHIEUH
  {0xB788, 0xD1B2}, //9250 #HANGUL SYLLABLE THIEUTH O PIEUPSIOS
  {0xB789, 0xD1B4}, //9251 #HANGUL SYLLABLE THIEUTH O SSANGSIOS
  {0xB78A, 0xD1B6}, //9252 #HANGUL SYLLABLE THIEUTH O CIEUC
  {0xB78B, 0xD1B7}, //9253 #HANGUL SYLLABLE THIEUTH O CHIEUCH
  {0xB78C, 0xD1B8}, //9254 #HANGUL SYLLABLE THIEUTH O KHIEUKH
  {0xB78D, 0xD1B9}, //9255 #HANGUL SYLLABLE THIEUTH O THIEUTH
  {0xB78E, 0xD1BB}, //9256 #HANGUL SYLLABLE THIEUTH O HIEUH
  {0xB78F, 0xD1BD}, //9257 #HANGUL SYLLABLE THIEUTH WA KIYEOK
  {0xB790, 0xD1BE}, //9258 #HANGUL SYLLABLE THIEUTH WA SSANGKIYEOK
  {0xB791, 0xD1BF}, //9259 #HANGUL SYLLABLE THIEUTH WA KIYEOKSIOS
  {0xB792, 0xD1C1}, //9260 #HANGUL SYLLABLE THIEUTH WA NIEUNCIEUC
  {0xB793, 0xD1C2}, //9261 #HANGUL SYLLABLE THIEUTH WA NIEUNHIEUH
  {0xB794, 0xD1C3}, //9262 #HANGUL SYLLABLE THIEUTH WA TIKEUT
  {0xB795, 0xD1C4}, //9263 #HANGUL SYLLABLE THIEUTH WA RIEUL
  {0xB796, 0xD1C5}, //9264 #HANGUL SYLLABLE THIEUTH WA RIEULKIYEOK
  {0xB797, 0xD1C6}, //9265 #HANGUL SYLLABLE THIEUTH WA RIEULMIEUM
  {0xB798, 0xD1C7}, //9266 #HANGUL SYLLABLE THIEUTH WA RIEULPIEUP
  {0xB799, 0xD1C8}, //9267 #HANGUL SYLLABLE THIEUTH WA RIEULSIOS
  {0xB79A, 0xD1C9}, //9268 #HANGUL SYLLABLE THIEUTH WA RIEULTHIEUTH
  {0xB79B, 0xD1CA}, //9269 #HANGUL SYLLABLE THIEUTH WA RIEULPHIEUPH
  {0xB79C, 0xD1CB}, //9270 #HANGUL SYLLABLE THIEUTH WA RIEULHIEUH
  {0xB79D, 0xD1CC}, //9271 #HANGUL SYLLABLE THIEUTH WA MIEUM
  {0xB79E, 0xD1CD}, //9272 #HANGUL SYLLABLE THIEUTH WA PIEUP
  {0xB79F, 0xD1CE}, //9273 #HANGUL SYLLABLE THIEUTH WA PIEUPSIOS
  {0xB7A0, 0xD1CF}, //9274 #HANGUL SYLLABLE THIEUTH WA SIOS
  {0xB7A1, 0xB798}, //9275 #HANGUL SYLLABLE RIEUL AE
  {0xB7A2, 0xB799}, //9276 #HANGUL SYLLABLE RIEUL AE KIYEOK
  {0xB7A3, 0xB79C}, //9277 #HANGUL SYLLABLE RIEUL AE NIEUN
  {0xB7A4, 0xB7A0}, //9278 #HANGUL SYLLABLE RIEUL AE RIEUL
  {0xB7A5, 0xB7A8}, //9279 #HANGUL SYLLABLE RIEUL AE MIEUM
  {0xB7A6, 0xB7A9}, //9280 #HANGUL SYLLABLE RIEUL AE PIEUP
  {0xB7A7, 0xB7AB}, //9281 #HANGUL SYLLABLE RIEUL AE SIOS
  {0xB7A8, 0xB7AC}, //9282 #HANGUL SYLLABLE RIEUL AE SSANGSIOS
  {0xB7A9, 0xB7AD}, //9283 #HANGUL SYLLABLE RIEUL AE IEUNG
  {0xB7AA, 0xB7B4}, //9284 #HANGUL SYLLABLE RIEUL YA
  {0xB7AB, 0xB7B5}, //9285 #HANGUL SYLLABLE RIEUL YA KIYEOK
  {0xB7AC, 0xB7B8}, //9286 #HANGUL SYLLABLE RIEUL YA NIEUN
  {0xB7AD, 0xB7C7}, //9287 #HANGUL SYLLABLE RIEUL YA SIOS
  {0xB7AE, 0xB7C9}, //9288 #HANGUL SYLLABLE RIEUL YA IEUNG
  {0xB7AF, 0xB7EC}, //9289 #HANGUL SYLLABLE RIEUL EO
  {0xB7B0, 0xB7ED}, //9290 #HANGUL SYLLABLE RIEUL EO KIYEOK
  {0xB7B1, 0xB7F0}, //9291 #HANGUL SYLLABLE RIEUL EO NIEUN
  {0xB7B2, 0xB7F4}, //9292 #HANGUL SYLLABLE RIEUL EO RIEUL
  {0xB7B3, 0xB7FC}, //9293 #HANGUL SYLLABLE RIEUL EO MIEUM
  {0xB7B4, 0xB7FD}, //9294 #HANGUL SYLLABLE RIEUL EO PIEUP
  {0xB7B5, 0xB7FF}, //9295 #HANGUL SYLLABLE RIEUL EO SIOS
  {0xB7B6, 0xB800}, //9296 #HANGUL SYLLABLE RIEUL EO SSANGSIOS
  {0xB7B7, 0xB801}, //9297 #HANGUL SYLLABLE RIEUL EO IEUNG
  {0xB7B8, 0xB807}, //9298 #HANGUL SYLLABLE RIEUL EO HIEUH
  {0xB7B9, 0xB808}, //9299 #HANGUL SYLLABLE RIEUL E
  {0xB7BA, 0xB809}, //9300 #HANGUL SYLLABLE RIEUL E KIYEOK
  {0xB7BB, 0xB80C}, //9301 #HANGUL SYLLABLE RIEUL E NIEUN
  {0xB7BC, 0xB810}, //9302 #HANGUL SYLLABLE RIEUL E RIEUL
  {0xB7BD, 0xB818}, //9303 #HANGUL SYLLABLE RIEUL E MIEUM
  {0xB7BE, 0xB819}, //9304 #HANGUL SYLLABLE RIEUL E PIEUP
  {0xB7BF, 0xB81B}, //9305 #HANGUL SYLLABLE RIEUL E SIOS
  {0xB7C0, 0xB81D}, //9306 #HANGUL SYLLABLE RIEUL E IEUNG
  {0xB7C1, 0xB824}, //9307 #HANGUL SYLLABLE RIEUL YEO
  {0xB7C2, 0xB825}, //9308 #HANGUL SYLLABLE RIEUL YEO KIYEOK
  {0xB7C3, 0xB828}, //9309 #HANGUL SYLLABLE RIEUL YEO NIEUN
  {0xB7C4, 0xB82C}, //9310 #HANGUL SYLLABLE RIEUL YEO RIEUL
  {0xB7C5, 0xB834}, //9311 #HANGUL SYLLABLE RIEUL YEO MIEUM
  {0xB7C6, 0xB835}, //9312 #HANGUL SYLLABLE RIEUL YEO PIEUP
  {0xB7C7, 0xB837}, //9313 #HANGUL SYLLABLE RIEUL YEO SIOS
  {0xB7C8, 0xB838}, //9314 #HANGUL SYLLABLE RIEUL YEO SSANGSIOS
  {0xB7C9, 0xB839}, //9315 #HANGUL SYLLABLE RIEUL YEO IEUNG
  {0xB7CA, 0xB840}, //9316 #HANGUL SYLLABLE RIEUL YE
  {0xB7CB, 0xB844}, //9317 #HANGUL SYLLABLE RIEUL YE NIEUN
  {0xB7CC, 0xB851}, //9318 #HANGUL SYLLABLE RIEUL YE PIEUP
  {0xB7CD, 0xB853}, //9319 #HANGUL SYLLABLE RIEUL YE SIOS
  {0xB7CE, 0xB85C}, //9320 #HANGUL SYLLABLE RIEUL O
  {0xB7CF, 0xB85D}, //9321 #HANGUL SYLLABLE RIEUL O KIYEOK
  {0xB7D0, 0xB860}, //9322 #HANGUL SYLLABLE RIEUL O NIEUN
  {0xB7D1, 0xB864}, //9323 #HANGUL SYLLABLE RIEUL O RIEUL
  {0xB7D2, 0xB86C}, //9324 #HANGUL SYLLABLE RIEUL O MIEUM
  {0xB7D3, 0xB86D}, //9325 #HANGUL SYLLABLE RIEUL O PIEUP
  {0xB7D4, 0xB86F}, //9326 #HANGUL SYLLABLE RIEUL O SIOS
  {0xB7D5, 0xB871}, //9327 #HANGUL SYLLABLE RIEUL O IEUNG
  {0xB7D6, 0xB878}, //9328 #HANGUL SYLLABLE RIEUL WA
  {0xB7D7, 0xB87C}, //9329 #HANGUL SYLLABLE RIEUL WA NIEUN
  {0xB7D8, 0xB88D}, //9330 #HANGUL SYLLABLE RIEUL WA IEUNG
  {0xB7D9, 0xB8A8}, //9331 #HANGUL SYLLABLE RIEUL WAE SSANGSIOS
  {0xB7DA, 0xB8B0}, //9332 #HANGUL SYLLABLE RIEUL OE
  {0xB7DB, 0xB8B4}, //9333 #HANGUL SYLLABLE RIEUL OE NIEUN
  {0xB7DC, 0xB8B8}, //9334 #HANGUL SYLLABLE RIEUL OE RIEUL
  {0xB7DD, 0xB8C0}, //9335 #HANGUL SYLLABLE RIEUL OE MIEUM
  {0xB7DE, 0xB8C1}, //9336 #HANGUL SYLLABLE RIEUL OE PIEUP
  {0xB7DF, 0xB8C3}, //9337 #HANGUL SYLLABLE RIEUL OE SIOS
  {0xB7E0, 0xB8C5}, //9338 #HANGUL SYLLABLE RIEUL OE IEUNG
  {0xB7E1, 0xB8CC}, //9339 #HANGUL SYLLABLE RIEUL YO
  {0xB7E2, 0xB8D0}, //9340 #HANGUL SYLLABLE RIEUL YO NIEUN
  {0xB7E3, 0xB8D4}, //9341 #HANGUL SYLLABLE RIEUL YO RIEUL
  {0xB7E4, 0xB8DD}, //9342 #HANGUL SYLLABLE RIEUL YO PIEUP
  {0xB7E5, 0xB8DF}, //9343 #HANGUL SYLLABLE RIEUL YO SIOS
  {0xB7E6, 0xB8E1}, //9344 #HANGUL SYLLABLE RIEUL YO IEUNG
  {0xB7E7, 0xB8E8}, //9345 #HANGUL SYLLABLE RIEUL U
  {0xB7E8, 0xB8E9}, //9346 #HANGUL SYLLABLE RIEUL U KIYEOK
  {0xB7E9, 0xB8EC}, //9347 #HANGUL SYLLABLE RIEUL U NIEUN
  {0xB7EA, 0xB8F0}, //9348 #HANGUL SYLLABLE RIEUL U RIEUL
  {0xB7EB, 0xB8F8}, //9349 #HANGUL SYLLABLE RIEUL U MIEUM
  {0xB7EC, 0xB8F9}, //9350 #HANGUL SYLLABLE RIEUL U PIEUP
  {0xB7ED, 0xB8FB}, //9351 #HANGUL SYLLABLE RIEUL U SIOS
  {0xB7EE, 0xB8FD}, //9352 #HANGUL SYLLABLE RIEUL U IEUNG
  {0xB7EF, 0xB904}, //9353 #HANGUL SYLLABLE RIEUL WEO
  {0xB7F0, 0xB918}, //9354 #HANGUL SYLLABLE RIEUL WEO SSANGSIOS
  {0xB7F1, 0xB920}, //9355 #HANGUL SYLLABLE RIEUL WE
  {0xB7F2, 0xB93C}, //9356 #HANGUL SYLLABLE RIEUL WI
  {0xB7F3, 0xB93D}, //9357 #HANGUL SYLLABLE RIEUL WI KIYEOK
  {0xB7F4, 0xB940}, //9358 #HANGUL SYLLABLE RIEUL WI NIEUN
  {0xB7F5, 0xB944}, //9359 #HANGUL SYLLABLE RIEUL WI RIEUL
  {0xB7F6, 0xB94C}, //9360 #HANGUL SYLLABLE RIEUL WI MIEUM
  {0xB7F7, 0xB94F}, //9361 #HANGUL SYLLABLE RIEUL WI SIOS
  {0xB7F8, 0xB951}, //9362 #HANGUL SYLLABLE RIEUL WI IEUNG
  {0xB7F9, 0xB958}, //9363 #HANGUL SYLLABLE RIEUL YU
  {0xB7FA, 0xB959}, //9364 #HANGUL SYLLABLE RIEUL YU KIYEOK
  {0xB7FB, 0xB95C}, //9365 #HANGUL SYLLABLE RIEUL YU NIEUN
  {0xB7FC, 0xB960}, //9366 #HANGUL SYLLABLE RIEUL YU RIEUL
  {0xB7FD, 0xB968}, //9367 #HANGUL SYLLABLE RIEUL YU MIEUM
  {0xB7FE, 0xB969}, //9368 #HANGUL SYLLABLE RIEUL YU PIEUP
  {0xB841, 0xD1D0}, //9369 #HANGUL SYLLABLE THIEUTH WA SSANGSIOS
  {0xB842, 0xD1D1}, //9370 #HANGUL SYLLABLE THIEUTH WA IEUNG
  {0xB843, 0xD1D2}, //9371 #HANGUL SYLLABLE THIEUTH WA CIEUC
  {0xB844, 0xD1D3}, //9372 #HANGUL SYLLABLE THIEUTH WA CHIEUCH
  {0xB845, 0xD1D4}, //9373 #HANGUL SYLLABLE THIEUTH WA KHIEUKH
  {0xB846, 0xD1D5}, //9374 #HANGUL SYLLABLE THIEUTH WA THIEUTH
  {0xB847, 0xD1D6}, //9375 #HANGUL SYLLABLE THIEUTH WA PHIEUPH
  {0xB848, 0xD1D7}, //9376 #HANGUL SYLLABLE THIEUTH WA HIEUH
  {0xB849, 0xD1D9}, //9377 #HANGUL SYLLABLE THIEUTH WAE KIYEOK
  {0xB84A, 0xD1DA}, //9378 #HANGUL SYLLABLE THIEUTH WAE SSANGKIYEOK
  {0xB84B, 0xD1DB}, //9379 #HANGUL SYLLABLE THIEUTH WAE KIYEOKSIOS
  {0xB84C, 0xD1DC}, //9380 #HANGUL SYLLABLE THIEUTH WAE NIEUN
  {0xB84D, 0xD1DD}, //9381 #HANGUL SYLLABLE THIEUTH WAE NIEUNCIEUC
  {0xB84E, 0xD1DE}, //9382 #HANGUL SYLLABLE THIEUTH WAE NIEUNHIEUH
  {0xB84F, 0xD1DF}, //9383 #HANGUL SYLLABLE THIEUTH WAE TIKEUT
  {0xB850, 0xD1E0}, //9384 #HANGUL SYLLABLE THIEUTH WAE RIEUL
  {0xB851, 0xD1E1}, //9385 #HANGUL SYLLABLE THIEUTH WAE RIEULKIYEOK
  {0xB852, 0xD1E2}, //9386 #HANGUL SYLLABLE THIEUTH WAE RIEULMIEUM
  {0xB853, 0xD1E3}, //9387 #HANGUL SYLLABLE THIEUTH WAE RIEULPIEUP
  {0xB854, 0xD1E4}, //9388 #HANGUL SYLLABLE THIEUTH WAE RIEULSIOS
  {0xB855, 0xD1E5}, //9389 #HANGUL SYLLABLE THIEUTH WAE RIEULTHIEUTH
  {0xB856, 0xD1E6}, //9390 #HANGUL SYLLABLE THIEUTH WAE RIEULPHIEUPH
  {0xB857, 0xD1E7}, //9391 #HANGUL SYLLABLE THIEUTH WAE RIEULHIEUH
  {0xB858, 0xD1E8}, //9392 #HANGUL SYLLABLE THIEUTH WAE MIEUM
  {0xB859, 0xD1E9}, //9393 #HANGUL SYLLABLE THIEUTH WAE PIEUP
  {0xB85A, 0xD1EA}, //9394 #HANGUL SYLLABLE THIEUTH WAE PIEUPSIOS
  {0xB861, 0xD1EB}, //9395 #HANGUL SYLLABLE THIEUTH WAE SIOS
  {0xB862, 0xD1EC}, //9396 #HANGUL SYLLABLE THIEUTH WAE SSANGSIOS
  {0xB863, 0xD1ED}, //9397 #HANGUL SYLLABLE THIEUTH WAE IEUNG
  {0xB864, 0xD1EE}, //9398 #HANGUL SYLLABLE THIEUTH WAE CIEUC
  {0xB865, 0xD1EF}, //9399 #HANGUL SYLLABLE THIEUTH WAE CHIEUCH
  {0xB866, 0xD1F0}, //9400 #HANGUL SYLLABLE THIEUTH WAE KHIEUKH
  {0xB867, 0xD1F1}, //9401 #HANGUL SYLLABLE THIEUTH WAE THIEUTH
  {0xB868, 0xD1F2}, //9402 #HANGUL SYLLABLE THIEUTH WAE PHIEUPH
  {0xB869, 0xD1F3}, //9403 #HANGUL SYLLABLE THIEUTH WAE HIEUH
  {0xB86A, 0xD1F5}, //9404 #HANGUL SYLLABLE THIEUTH OE KIYEOK
  {0xB86B, 0xD1F6}, //9405 #HANGUL SYLLABLE THIEUTH OE SSANGKIYEOK
  {0xB86C, 0xD1F7}, //9406 #HANGUL SYLLABLE THIEUTH OE KIYEOKSIOS
  {0xB86D, 0xD1F9}, //9407 #HANGUL SYLLABLE THIEUTH OE NIEUNCIEUC
  {0xB86E, 0xD1FA}, //9408 #HANGUL SYLLABLE THIEUTH OE NIEUNHIEUH
  {0xB86F, 0xD1FB}, //9409 #HANGUL SYLLABLE THIEUTH OE TIKEUT
  {0xB870, 0xD1FC}, //9410 #HANGUL SYLLABLE THIEUTH OE RIEUL
  {0xB871, 0xD1FD}, //9411 #HANGUL SYLLABLE THIEUTH OE RIEULKIYEOK
  {0xB872, 0xD1FE}, //9412 #HANGUL SYLLABLE THIEUTH OE RIEULMIEUM
  {0xB873, 0xD1FF}, //9413 #HANGUL SYLLABLE THIEUTH OE RIEULPIEUP
  {0xB874, 0xD200}, //9414 #HANGUL SYLLABLE THIEUTH OE RIEULSIOS
  {0xB875, 0xD201}, //9415 #HANGUL SYLLABLE THIEUTH OE RIEULTHIEUTH
  {0xB876, 0xD202}, //9416 #HANGUL SYLLABLE THIEUTH OE RIEULPHIEUPH
  {0xB877, 0xD203}, //9417 #HANGUL SYLLABLE THIEUTH OE RIEULHIEUH
  {0xB878, 0xD204}, //9418 #HANGUL SYLLABLE THIEUTH OE MIEUM
  {0xB879, 0xD205}, //9419 #HANGUL SYLLABLE THIEUTH OE PIEUP
  {0xB87A, 0xD206}, //9420 #HANGUL SYLLABLE THIEUTH OE PIEUPSIOS
  {0xB881, 0xD208}, //9421 #HANGUL SYLLABLE THIEUTH OE SSANGSIOS
  {0xB882, 0xD20A}, //9422 #HANGUL SYLLABLE THIEUTH OE CIEUC
  {0xB883, 0xD20B}, //9423 #HANGUL SYLLABLE THIEUTH OE CHIEUCH
  {0xB884, 0xD20C}, //9424 #HANGUL SYLLABLE THIEUTH OE KHIEUKH
  {0xB885, 0xD20D}, //9425 #HANGUL SYLLABLE THIEUTH OE THIEUTH
  {0xB886, 0xD20E}, //9426 #HANGUL SYLLABLE THIEUTH OE PHIEUPH
  {0xB887, 0xD20F}, //9427 #HANGUL SYLLABLE THIEUTH OE HIEUH
  {0xB888, 0xD211}, //9428 #HANGUL SYLLABLE THIEUTH YO KIYEOK
  {0xB889, 0xD212}, //9429 #HANGUL SYLLABLE THIEUTH YO SSANGKIYEOK
  {0xB88A, 0xD213}, //9430 #HANGUL SYLLABLE THIEUTH YO KIYEOKSIOS
  {0xB88B, 0xD214}, //9431 #HANGUL SYLLABLE THIEUTH YO NIEUN
  {0xB88C, 0xD215}, //9432 #HANGUL SYLLABLE THIEUTH YO NIEUNCIEUC
  {0xB88D, 0xD216}, //9433 #HANGUL SYLLABLE THIEUTH YO NIEUNHIEUH
  {0xB88E, 0xD217}, //9434 #HANGUL SYLLABLE THIEUTH YO TIKEUT
  {0xB88F, 0xD218}, //9435 #HANGUL SYLLABLE THIEUTH YO RIEUL
  {0xB890, 0xD219}, //9436 #HANGUL SYLLABLE THIEUTH YO RIEULKIYEOK
  {0xB891, 0xD21A}, //9437 #HANGUL SYLLABLE THIEUTH YO RIEULMIEUM
  {0xB892, 0xD21B}, //9438 #HANGUL SYLLABLE THIEUTH YO RIEULPIEUP
  {0xB893, 0xD21C}, //9439 #HANGUL SYLLABLE THIEUTH YO RIEULSIOS
  {0xB894, 0xD21D}, //9440 #HANGUL SYLLABLE THIEUTH YO RIEULTHIEUTH
  {0xB895, 0xD21E}, //9441 #HANGUL SYLLABLE THIEUTH YO RIEULPHIEUPH
  {0xB896, 0xD21F}, //9442 #HANGUL SYLLABLE THIEUTH YO RIEULHIEUH
  {0xB897, 0xD220}, //9443 #HANGUL SYLLABLE THIEUTH YO MIEUM
  {0xB898, 0xD221}, //9444 #HANGUL SYLLABLE THIEUTH YO PIEUP
  {0xB899, 0xD222}, //9445 #HANGUL SYLLABLE THIEUTH YO PIEUPSIOS
  {0xB89A, 0xD223}, //9446 #HANGUL SYLLABLE THIEUTH YO SIOS
  {0xB89B, 0xD224}, //9447 #HANGUL SYLLABLE THIEUTH YO SSANGSIOS
  {0xB89C, 0xD225}, //9448 #HANGUL SYLLABLE THIEUTH YO IEUNG
  {0xB89D, 0xD226}, //9449 #HANGUL SYLLABLE THIEUTH YO CIEUC
  {0xB89E, 0xD227}, //9450 #HANGUL SYLLABLE THIEUTH YO CHIEUCH
  {0xB89F, 0xD228}, //9451 #HANGUL SYLLABLE THIEUTH YO KHIEUKH
  {0xB8A0, 0xD229}, //9452 #HANGUL SYLLABLE THIEUTH YO THIEUTH
  {0xB8A1, 0xB96B}, //9453 #HANGUL SYLLABLE RIEUL YU SIOS
  {0xB8A2, 0xB96D}, //9454 #HANGUL SYLLABLE RIEUL YU IEUNG
  {0xB8A3, 0xB974}, //9455 #HANGUL SYLLABLE RIEUL EU
  {0xB8A4, 0xB975}, //9456 #HANGUL SYLLABLE RIEUL EU KIYEOK
  {0xB8A5, 0xB978}, //9457 #HANGUL SYLLABLE RIEUL EU NIEUN
  {0xB8A6, 0xB97C}, //9458 #HANGUL SYLLABLE RIEUL EU RIEUL
  {0xB8A7, 0xB984}, //9459 #HANGUL SYLLABLE RIEUL EU MIEUM
  {0xB8A8, 0xB985}, //9460 #HANGUL SYLLABLE RIEUL EU PIEUP
  {0xB8A9, 0xB987}, //9461 #HANGUL SYLLABLE RIEUL EU SIOS
  {0xB8AA, 0xB989}, //9462 #HANGUL SYLLABLE RIEUL EU IEUNG
  {0xB8AB, 0xB98A}, //9463 #HANGUL SYLLABLE RIEUL EU CIEUC
  {0xB8AC, 0xB98D}, //9464 #HANGUL SYLLABLE RIEUL EU THIEUTH
  {0xB8AD, 0xB98E}, //9465 #HANGUL SYLLABLE RIEUL EU PHIEUPH
  {0xB8AE, 0xB9AC}, //9466 #HANGUL SYLLABLE RIEUL I
  {0xB8AF, 0xB9AD}, //9467 #HANGUL SYLLABLE RIEUL I KIYEOK
  {0xB8B0, 0xB9B0}, //9468 #HANGUL SYLLABLE RIEUL I NIEUN
  {0xB8B1, 0xB9B4}, //9469 #HANGUL SYLLABLE RIEUL I RIEUL
  {0xB8B2, 0xB9BC}, //9470 #HANGUL SYLLABLE RIEUL I MIEUM
  {0xB8B3, 0xB9BD}, //9471 #HANGUL SYLLABLE RIEUL I PIEUP
  {0xB8B4, 0xB9BF}, //9472 #HANGUL SYLLABLE RIEUL I SIOS
  {0xB8B5, 0xB9C1}, //9473 #HANGUL SYLLABLE RIEUL I IEUNG
  {0xB8B6, 0xB9C8}, //9474 #HANGUL SYLLABLE MIEUM A
  {0xB8B7, 0xB9C9}, //9475 #HANGUL SYLLABLE MIEUM A KIYEOK
  {0xB8B8, 0xB9CC}, //9476 #HANGUL SYLLABLE MIEUM A NIEUN
  {0xB8B9, 0xB9CE}, //9477 #HANGUL SYLLABLE MIEUM A NIEUNHIEUH
  {0xB8BA, 0xB9CF}, //9478 #HANGUL SYLLABLE MIEUM A TIKEUT
  {0xB8BB, 0xB9D0}, //9479 #HANGUL SYLLABLE MIEUM A RIEUL
  {0xB8BC, 0xB9D1}, //9480 #HANGUL SYLLABLE MIEUM A RIEULKIYEOK
  {0xB8BD, 0xB9D2}, //9481 #HANGUL SYLLABLE MIEUM A RIEULMIEUM
  {0xB8BE, 0xB9D8}, //9482 #HANGUL SYLLABLE MIEUM A MIEUM
  {0xB8BF, 0xB9D9}, //9483 #HANGUL SYLLABLE MIEUM A PIEUP
  {0xB8C0, 0xB9DB}, //9484 #HANGUL SYLLABLE MIEUM A SIOS
  {0xB8C1, 0xB9DD}, //9485 #HANGUL SYLLABLE MIEUM A IEUNG
  {0xB8C2, 0xB9DE}, //9486 #HANGUL SYLLABLE MIEUM A CIEUC
  {0xB8C3, 0xB9E1}, //9487 #HANGUL SYLLABLE MIEUM A THIEUTH
  {0xB8C4, 0xB9E3}, //9488 #HANGUL SYLLABLE MIEUM A HIEUH
  {0xB8C5, 0xB9E4}, //9489 #HANGUL SYLLABLE MIEUM AE
  {0xB8C6, 0xB9E5}, //9490 #HANGUL SYLLABLE MIEUM AE KIYEOK
  {0xB8C7, 0xB9E8}, //9491 #HANGUL SYLLABLE MIEUM AE NIEUN
  {0xB8C8, 0xB9EC}, //9492 #HANGUL SYLLABLE MIEUM AE RIEUL
  {0xB8C9, 0xB9F4}, //9493 #HANGUL SYLLABLE MIEUM AE MIEUM
  {0xB8CA, 0xB9F5}, //9494 #HANGUL SYLLABLE MIEUM AE PIEUP
  {0xB8CB, 0xB9F7}, //9495 #HANGUL SYLLABLE MIEUM AE SIOS
  {0xB8CC, 0xB9F8}, //9496 #HANGUL SYLLABLE MIEUM AE SSANGSIOS
  {0xB8CD, 0xB9F9}, //9497 #HANGUL SYLLABLE MIEUM AE IEUNG
  {0xB8CE, 0xB9FA}, //9498 #HANGUL SYLLABLE MIEUM AE CIEUC
  {0xB8CF, 0xBA00}, //9499 #HANGUL SYLLABLE MIEUM YA
  {0xB8D0, 0xBA01}, //9500 #HANGUL SYLLABLE MIEUM YA KIYEOK
  {0xB8D1, 0xBA08}, //9501 #HANGUL SYLLABLE MIEUM YA RIEUL
  {0xB8D2, 0xBA15}, //9502 #HANGUL SYLLABLE MIEUM YA IEUNG
  {0xB8D3, 0xBA38}, //9503 #HANGUL SYLLABLE MIEUM EO
  {0xB8D4, 0xBA39}, //9504 #HANGUL SYLLABLE MIEUM EO KIYEOK
  {0xB8D5, 0xBA3C}, //9505 #HANGUL SYLLABLE MIEUM EO NIEUN
  {0xB8D6, 0xBA40}, //9506 #HANGUL SYLLABLE MIEUM EO RIEUL
  {0xB8D7, 0xBA42}, //9507 #HANGUL SYLLABLE MIEUM EO RIEULMIEUM
  {0xB8D8, 0xBA48}, //9508 #HANGUL SYLLABLE MIEUM EO MIEUM
  {0xB8D9, 0xBA49}, //9509 #HANGUL SYLLABLE MIEUM EO PIEUP
  {0xB8DA, 0xBA4B}, //9510 #HANGUL SYLLABLE MIEUM EO SIOS
  {0xB8DB, 0xBA4D}, //9511 #HANGUL SYLLABLE MIEUM EO IEUNG
  {0xB8DC, 0xBA4E}, //9512 #HANGUL SYLLABLE MIEUM EO CIEUC
  {0xB8DD, 0xBA53}, //9513 #HANGUL SYLLABLE MIEUM EO HIEUH
  {0xB8DE, 0xBA54}, //9514 #HANGUL SYLLABLE MIEUM E
  {0xB8DF, 0xBA55}, //9515 #HANGUL SYLLABLE MIEUM E KIYEOK
  {0xB8E0, 0xBA58}, //9516 #HANGUL SYLLABLE MIEUM E NIEUN
  {0xB8E1, 0xBA5C}, //9517 #HANGUL SYLLABLE MIEUM E RIEUL
  {0xB8E2, 0xBA64}, //9518 #HANGUL SYLLABLE MIEUM E MIEUM
  {0xB8E3, 0xBA65}, //9519 #HANGUL SYLLABLE MIEUM E PIEUP
  {0xB8E4, 0xBA67}, //9520 #HANGUL SYLLABLE MIEUM E SIOS
  {0xB8E5, 0xBA68}, //9521 #HANGUL SYLLABLE MIEUM E SSANGSIOS
  {0xB8E6, 0xBA69}, //9522 #HANGUL SYLLABLE MIEUM E IEUNG
  {0xB8E7, 0xBA70}, //9523 #HANGUL SYLLABLE MIEUM YEO
  {0xB8E8, 0xBA71}, //9524 #HANGUL SYLLABLE MIEUM YEO KIYEOK
  {0xB8E9, 0xBA74}, //9525 #HANGUL SYLLABLE MIEUM YEO NIEUN
  {0xB8EA, 0xBA78}, //9526 #HANGUL SYLLABLE MIEUM YEO RIEUL
  {0xB8EB, 0xBA83}, //9527 #HANGUL SYLLABLE MIEUM YEO SIOS
  {0xB8EC, 0xBA84}, //9528 #HANGUL SYLLABLE MIEUM YEO SSANGSIOS
  {0xB8ED, 0xBA85}, //9529 #HANGUL SYLLABLE MIEUM YEO IEUNG
  {0xB8EE, 0xBA87}, //9530 #HANGUL SYLLABLE MIEUM YEO CHIEUCH
  {0xB8EF, 0xBA8C}, //9531 #HANGUL SYLLABLE MIEUM YE
  {0xB8F0, 0xBAA8}, //9532 #HANGUL SYLLABLE MIEUM O
  {0xB8F1, 0xBAA9}, //9533 #HANGUL SYLLABLE MIEUM O KIYEOK
  {0xB8F2, 0xBAAB}, //9534 #HANGUL SYLLABLE MIEUM O KIYEOKSIOS
  {0xB8F3, 0xBAAC}, //9535 #HANGUL SYLLABLE MIEUM O NIEUN
  {0xB8F4, 0xBAB0}, //9536 #HANGUL SYLLABLE MIEUM O RIEUL
  {0xB8F5, 0xBAB2}, //9537 #HANGUL SYLLABLE MIEUM O RIEULMIEUM
  {0xB8F6, 0xBAB8}, //9538 #HANGUL SYLLABLE MIEUM O MIEUM
  {0xB8F7, 0xBAB9}, //9539 #HANGUL SYLLABLE MIEUM O PIEUP
  {0xB8F8, 0xBABB}, //9540 #HANGUL SYLLABLE MIEUM O SIOS
  {0xB8F9, 0xBABD}, //9541 #HANGUL SYLLABLE MIEUM O IEUNG
  {0xB8FA, 0xBAC4}, //9542 #HANGUL SYLLABLE MIEUM WA
  {0xB8FB, 0xBAC8}, //9543 #HANGUL SYLLABLE MIEUM WA NIEUN
  {0xB8FC, 0xBAD8}, //9544 #HANGUL SYLLABLE MIEUM WA SSANGSIOS
  {0xB8FD, 0xBAD9}, //9545 #HANGUL SYLLABLE MIEUM WA IEUNG
  {0xB8FE, 0xBAFC}, //9546 #HANGUL SYLLABLE MIEUM OE
  {0xB941, 0xD22A}, //9547 #HANGUL SYLLABLE THIEUTH YO PHIEUPH
  {0xB942, 0xD22B}, //9548 #HANGUL SYLLABLE THIEUTH YO HIEUH
  {0xB943, 0xD22E}, //9549 #HANGUL SYLLABLE THIEUTH U SSANGKIYEOK
  {0xB944, 0xD22F}, //9550 #HANGUL SYLLABLE THIEUTH U KIYEOKSIOS
  {0xB945, 0xD231}, //9551 #HANGUL SYLLABLE THIEUTH U NIEUNCIEUC
  {0xB946, 0xD232}, //9552 #HANGUL SYLLABLE THIEUTH U NIEUNHIEUH
  {0xB947, 0xD233}, //9553 #HANGUL SYLLABLE THIEUTH U TIKEUT
  {0xB948, 0xD235}, //9554 #HANGUL SYLLABLE THIEUTH U RIEULKIYEOK
  {0xB949, 0xD236}, //9555 #HANGUL SYLLABLE THIEUTH U RIEULMIEUM
  {0xB94A, 0xD237}, //9556 #HANGUL SYLLABLE THIEUTH U RIEULPIEUP
  {0xB94B, 0xD238}, //9557 #HANGUL SYLLABLE THIEUTH U RIEULSIOS
  {0xB94C, 0xD239}, //9558 #HANGUL SYLLABLE THIEUTH U RIEULTHIEUTH
  {0xB94D, 0xD23A}, //9559 #HANGUL SYLLABLE THIEUTH U RIEULPHIEUPH
  {0xB94E, 0xD23B}, //9560 #HANGUL SYLLABLE THIEUTH U RIEULHIEUH
  {0xB94F, 0xD23E}, //9561 #HANGUL SYLLABLE THIEUTH U PIEUPSIOS
  {0xB950, 0xD240}, //9562 #HANGUL SYLLABLE THIEUTH U SSANGSIOS
  {0xB951, 0xD242}, //9563 #HANGUL SYLLABLE THIEUTH U CIEUC
  {0xB952, 0xD243}, //9564 #HANGUL SYLLABLE THIEUTH U CHIEUCH
  {0xB953, 0xD244}, //9565 #HANGUL SYLLABLE THIEUTH U KHIEUKH
  {0xB954, 0xD245}, //9566 #HANGUL SYLLABLE THIEUTH U THIEUTH
  {0xB955, 0xD246}, //9567 #HANGUL SYLLABLE THIEUTH U PHIEUPH
  {0xB956, 0xD247}, //9568 #HANGUL SYLLABLE THIEUTH U HIEUH
  {0xB957, 0xD249}, //9569 #HANGUL SYLLABLE THIEUTH WEO KIYEOK
  {0xB958, 0xD24A}, //9570 #HANGUL SYLLABLE THIEUTH WEO SSANGKIYEOK
  {0xB959, 0xD24B}, //9571 #HANGUL SYLLABLE THIEUTH WEO KIYEOKSIOS
  {0xB95A, 0xD24C}, //9572 #HANGUL SYLLABLE THIEUTH WEO NIEUN
  {0xB961, 0xD24D}, //9573 #HANGUL SYLLABLE THIEUTH WEO NIEUNCIEUC
  {0xB962, 0xD24E}, //9574 #HANGUL SYLLABLE THIEUTH WEO NIEUNHIEUH
  {0xB963, 0xD24F}, //9575 #HANGUL SYLLABLE THIEUTH WEO TIKEUT
  {0xB964, 0xD250}, //9576 #HANGUL SYLLABLE THIEUTH WEO RIEUL
  {0xB965, 0xD251}, //9577 #HANGUL SYLLABLE THIEUTH WEO RIEULKIYEOK
  {0xB966, 0xD252}, //9578 #HANGUL SYLLABLE THIEUTH WEO RIEULMIEUM
  {0xB967, 0xD253}, //9579 #HANGUL SYLLABLE THIEUTH WEO RIEULPIEUP
  {0xB968, 0xD254}, //9580 #HANGUL SYLLABLE THIEUTH WEO RIEULSIOS
  {0xB969, 0xD255}, //9581 #HANGUL SYLLABLE THIEUTH WEO RIEULTHIEUTH
  {0xB96A, 0xD256}, //9582 #HANGUL SYLLABLE THIEUTH WEO RIEULPHIEUPH
  {0xB96B, 0xD257}, //9583 #HANGUL SYLLABLE THIEUTH WEO RIEULHIEUH
  {0xB96C, 0xD258}, //9584 #HANGUL SYLLABLE THIEUTH WEO MIEUM
  {0xB96D, 0xD259}, //9585 #HANGUL SYLLABLE THIEUTH WEO PIEUP
  {0xB96E, 0xD25A}, //9586 #HANGUL SYLLABLE THIEUTH WEO PIEUPSIOS
  {0xB96F, 0xD25B}, //9587 #HANGUL SYLLABLE THIEUTH WEO SIOS
  {0xB970, 0xD25D}, //9588 #HANGUL SYLLABLE THIEUTH WEO IEUNG
  {0xB971, 0xD25E}, //9589 #HANGUL SYLLABLE THIEUTH WEO CIEUC
  {0xB972, 0xD25F}, //9590 #HANGUL SYLLABLE THIEUTH WEO CHIEUCH
  {0xB973, 0xD260}, //9591 #HANGUL SYLLABLE THIEUTH WEO KHIEUKH
  {0xB974, 0xD261}, //9592 #HANGUL SYLLABLE THIEUTH WEO THIEUTH
  {0xB975, 0xD262}, //9593 #HANGUL SYLLABLE THIEUTH WEO PHIEUPH
  {0xB976, 0xD263}, //9594 #HANGUL SYLLABLE THIEUTH WEO HIEUH
  {0xB977, 0xD265}, //9595 #HANGUL SYLLABLE THIEUTH WE KIYEOK
  {0xB978, 0xD266}, //9596 #HANGUL SYLLABLE THIEUTH WE SSANGKIYEOK
  {0xB979, 0xD267}, //9597 #HANGUL SYLLABLE THIEUTH WE KIYEOKSIOS
  {0xB97A, 0xD268}, //9598 #HANGUL SYLLABLE THIEUTH WE NIEUN
  {0xB981, 0xD269}, //9599 #HANGUL SYLLABLE THIEUTH WE NIEUNCIEUC
  {0xB982, 0xD26A}, //9600 #HANGUL SYLLABLE THIEUTH WE NIEUNHIEUH
  {0xB983, 0xD26B}, //9601 #HANGUL SYLLABLE THIEUTH WE TIKEUT
  {0xB984, 0xD26C}, //9602 #HANGUL SYLLABLE THIEUTH WE RIEUL
  {0xB985, 0xD26D}, //9603 #HANGUL SYLLABLE THIEUTH WE RIEULKIYEOK
  {0xB986, 0xD26E}, //9604 #HANGUL SYLLABLE THIEUTH WE RIEULMIEUM
  {0xB987, 0xD26F}, //9605 #HANGUL SYLLABLE THIEUTH WE RIEULPIEUP
  {0xB988, 0xD270}, //9606 #HANGUL SYLLABLE THIEUTH WE RIEULSIOS
  {0xB989, 0xD271}, //9607 #HANGUL SYLLABLE THIEUTH WE RIEULTHIEUTH
  {0xB98A, 0xD272}, //9608 #HANGUL SYLLABLE THIEUTH WE RIEULPHIEUPH
  {0xB98B, 0xD273}, //9609 #HANGUL SYLLABLE THIEUTH WE RIEULHIEUH
  {0xB98C, 0xD274}, //9610 #HANGUL SYLLABLE THIEUTH WE MIEUM
  {0xB98D, 0xD275}, //9611 #HANGUL SYLLABLE THIEUTH WE PIEUP
  {0xB98E, 0xD276}, //9612 #HANGUL SYLLABLE THIEUTH WE PIEUPSIOS
  {0xB98F, 0xD277}, //9613 #HANGUL SYLLABLE THIEUTH WE SIOS
  {0xB990, 0xD278}, //9614 #HANGUL SYLLABLE THIEUTH WE SSANGSIOS
  {0xB991, 0xD279}, //9615 #HANGUL SYLLABLE THIEUTH WE IEUNG
  {0xB992, 0xD27A}, //9616 #HANGUL SYLLABLE THIEUTH WE CIEUC
  {0xB993, 0xD27B}, //9617 #HANGUL SYLLABLE THIEUTH WE CHIEUCH
  {0xB994, 0xD27C}, //9618 #HANGUL SYLLABLE THIEUTH WE KHIEUKH
  {0xB995, 0xD27D}, //9619 #HANGUL SYLLABLE THIEUTH WE THIEUTH
  {0xB996, 0xD27E}, //9620 #HANGUL SYLLABLE THIEUTH WE PHIEUPH
  {0xB997, 0xD27F}, //9621 #HANGUL SYLLABLE THIEUTH WE HIEUH
  {0xB998, 0xD282}, //9622 #HANGUL SYLLABLE THIEUTH WI SSANGKIYEOK
  {0xB999, 0xD283}, //9623 #HANGUL SYLLABLE THIEUTH WI KIYEOKSIOS
  {0xB99A, 0xD285}, //9624 #HANGUL SYLLABLE THIEUTH WI NIEUNCIEUC
  {0xB99B, 0xD286}, //9625 #HANGUL SYLLABLE THIEUTH WI NIEUNHIEUH
  {0xB99C, 0xD287}, //9626 #HANGUL SYLLABLE THIEUTH WI TIKEUT
  {0xB99D, 0xD289}, //9627 #HANGUL SYLLABLE THIEUTH WI RIEULKIYEOK
  {0xB99E, 0xD28A}, //9628 #HANGUL SYLLABLE THIEUTH WI RIEULMIEUM
  {0xB99F, 0xD28B}, //9629 #HANGUL SYLLABLE THIEUTH WI RIEULPIEUP
  {0xB9A0, 0xD28C}, //9630 #HANGUL SYLLABLE THIEUTH WI RIEULSIOS
  {0xB9A1, 0xBB00}, //9631 #HANGUL SYLLABLE MIEUM OE NIEUN
  {0xB9A2, 0xBB04}, //9632 #HANGUL SYLLABLE MIEUM OE RIEUL
  {0xB9A3, 0xBB0D}, //9633 #HANGUL SYLLABLE MIEUM OE PIEUP
  {0xB9A4, 0xBB0F}, //9634 #HANGUL SYLLABLE MIEUM OE SIOS
  {0xB9A5, 0xBB11}, //9635 #HANGUL SYLLABLE MIEUM OE IEUNG
  {0xB9A6, 0xBB18}, //9636 #HANGUL SYLLABLE MIEUM YO
  {0xB9A7, 0xBB1C}, //9637 #HANGUL SYLLABLE MIEUM YO NIEUN
  {0xB9A8, 0xBB20}, //9638 #HANGUL SYLLABLE MIEUM YO RIEUL
  {0xB9A9, 0xBB29}, //9639 #HANGUL SYLLABLE MIEUM YO PIEUP
  {0xB9AA, 0xBB2B}, //9640 #HANGUL SYLLABLE MIEUM YO SIOS
  {0xB9AB, 0xBB34}, //9641 #HANGUL SYLLABLE MIEUM U
  {0xB9AC, 0xBB35}, //9642 #HANGUL SYLLABLE MIEUM U KIYEOK
  {0xB9AD, 0xBB36}, //9643 #HANGUL SYLLABLE MIEUM U SSANGKIYEOK
  {0xB9AE, 0xBB38}, //9644 #HANGUL SYLLABLE MIEUM U NIEUN
  {0xB9AF, 0xBB3B}, //9645 #HANGUL SYLLABLE MIEUM U TIKEUT
  {0xB9B0, 0xBB3C}, //9646 #HANGUL SYLLABLE MIEUM U RIEUL
  {0xB9B1, 0xBB3D}, //9647 #HANGUL SYLLABLE MIEUM U RIEULKIYEOK
  {0xB9B2, 0xBB3E}, //9648 #HANGUL SYLLABLE MIEUM U RIEULMIEUM
  {0xB9B3, 0xBB44}, //9649 #HANGUL SYLLABLE MIEUM U MIEUM
  {0xB9B4, 0xBB45}, //9650 #HANGUL SYLLABLE MIEUM U PIEUP
  {0xB9B5, 0xBB47}, //9651 #HANGUL SYLLABLE MIEUM U SIOS
  {0xB9B6, 0xBB49}, //9652 #HANGUL SYLLABLE MIEUM U IEUNG
  {0xB9B7, 0xBB4D}, //9653 #HANGUL SYLLABLE MIEUM U THIEUTH
  {0xB9B8, 0xBB4F}, //9654 #HANGUL SYLLABLE MIEUM U HIEUH
  {0xB9B9, 0xBB50}, //9655 #HANGUL SYLLABLE MIEUM WEO
  {0xB9BA, 0xBB54}, //9656 #HANGUL SYLLABLE MIEUM WEO NIEUN
  {0xB9BB, 0xBB58}, //9657 #HANGUL SYLLABLE MIEUM WEO RIEUL
  {0xB9BC, 0xBB61}, //9658 #HANGUL SYLLABLE MIEUM WEO PIEUP
  {0xB9BD, 0xBB63}, //9659 #HANGUL SYLLABLE MIEUM WEO SIOS
  {0xB9BE, 0xBB6C}, //9660 #HANGUL SYLLABLE MIEUM WE
  {0xB9BF, 0xBB88}, //9661 #HANGUL SYLLABLE MIEUM WI
  {0xB9C0, 0xBB8C}, //9662 #HANGUL SYLLABLE MIEUM WI NIEUN
  {0xB9C1, 0xBB90}, //9663 #HANGUL SYLLABLE MIEUM WI RIEUL
  {0xB9C2, 0xBBA4}, //9664 #HANGUL SYLLABLE MIEUM YU
  {0xB9C3, 0xBBA8}, //9665 #HANGUL SYLLABLE MIEUM YU NIEUN
  {0xB9C4, 0xBBAC}, //9666 #HANGUL SYLLABLE MIEUM YU RIEUL
  {0xB9C5, 0xBBB4}, //9667 #HANGUL SYLLABLE MIEUM YU MIEUM
  {0xB9C6, 0xBBB7}, //9668 #HANGUL SYLLABLE MIEUM YU SIOS
  {0xB9C7, 0xBBC0}, //9669 #HANGUL SYLLABLE MIEUM EU
  {0xB9C8, 0xBBC4}, //9670 #HANGUL SYLLABLE MIEUM EU NIEUN
  {0xB9C9, 0xBBC8}, //9671 #HANGUL SYLLABLE MIEUM EU RIEUL
  {0xB9CA, 0xBBD0}, //9672 #HANGUL SYLLABLE MIEUM EU MIEUM
  {0xB9CB, 0xBBD3}, //9673 #HANGUL SYLLABLE MIEUM EU SIOS
  {0xB9CC, 0xBBF8}, //9674 #HANGUL SYLLABLE MIEUM I
  {0xB9CD, 0xBBF9}, //9675 #HANGUL SYLLABLE MIEUM I KIYEOK
  {0xB9CE, 0xBBFC}, //9676 #HANGUL SYLLABLE MIEUM I NIEUN
  {0xB9CF, 0xBBFF}, //9677 #HANGUL SYLLABLE MIEUM I TIKEUT
  {0xB9D0, 0xBC00}, //9678 #HANGUL SYLLABLE MIEUM I RIEUL
  {0xB9D1, 0xBC02}, //9679 #HANGUL SYLLABLE MIEUM I RIEULMIEUM
  {0xB9D2, 0xBC08}, //9680 #HANGUL SYLLABLE MIEUM I MIEUM
  {0xB9D3, 0xBC09}, //9681 #HANGUL SYLLABLE MIEUM I PIEUP
  {0xB9D4, 0xBC0B}, //9682 #HANGUL SYLLABLE MIEUM I SIOS
  {0xB9D5, 0xBC0C}, //9683 #HANGUL SYLLABLE MIEUM I SSANGSIOS
  {0xB9D6, 0xBC0D}, //9684 #HANGUL SYLLABLE MIEUM I IEUNG
  {0xB9D7, 0xBC0F}, //9685 #HANGUL SYLLABLE MIEUM I CHIEUCH
  {0xB9D8, 0xBC11}, //9686 #HANGUL SYLLABLE MIEUM I THIEUTH
  {0xB9D9, 0xBC14}, //9687 #HANGUL SYLLABLE PIEUP A
  {0xB9DA, 0xBC15}, //9688 #HANGUL SYLLABLE PIEUP A KIYEOK
  {0xB9DB, 0xBC16}, //9689 #HANGUL SYLLABLE PIEUP A SSANGKIYEOK
  {0xB9DC, 0xBC17}, //9690 #HANGUL SYLLABLE PIEUP A KIYEOKSIOS
  {0xB9DD, 0xBC18}, //9691 #HANGUL SYLLABLE PIEUP A NIEUN
  {0xB9DE, 0xBC1B}, //9692 #HANGUL SYLLABLE PIEUP A TIKEUT
  {0xB9DF, 0xBC1C}, //9693 #HANGUL SYLLABLE PIEUP A RIEUL
  {0xB9E0, 0xBC1D}, //9694 #HANGUL SYLLABLE PIEUP A RIEULKIYEOK
  {0xB9E1, 0xBC1E}, //9695 #HANGUL SYLLABLE PIEUP A RIEULMIEUM
  {0xB9E2, 0xBC1F}, //9696 #HANGUL SYLLABLE PIEUP A RIEULPIEUP
  {0xB9E3, 0xBC24}, //9697 #HANGUL SYLLABLE PIEUP A MIEUM
  {0xB9E4, 0xBC25}, //9698 #HANGUL SYLLABLE PIEUP A PIEUP
  {0xB9E5, 0xBC27}, //9699 #HANGUL SYLLABLE PIEUP A SIOS
  {0xB9E6, 0xBC29}, //9700 #HANGUL SYLLABLE PIEUP A IEUNG
  {0xB9E7, 0xBC2D}, //9701 #HANGUL SYLLABLE PIEUP A THIEUTH
  {0xB9E8, 0xBC30}, //9702 #HANGUL SYLLABLE PIEUP AE
  {0xB9E9, 0xBC31}, //9703 #HANGUL SYLLABLE PIEUP AE KIYEOK
  {0xB9EA, 0xBC34}, //9704 #HANGUL SYLLABLE PIEUP AE NIEUN
  {0xB9EB, 0xBC38}, //9705 #HANGUL SYLLABLE PIEUP AE RIEUL
  {0xB9EC, 0xBC40}, //9706 #HANGUL SYLLABLE PIEUP AE MIEUM
  {0xB9ED, 0xBC41}, //9707 #HANGUL SYLLABLE PIEUP AE PIEUP
  {0xB9EE, 0xBC43}, //9708 #HANGUL SYLLABLE PIEUP AE SIOS
  {0xB9EF, 0xBC44}, //9709 #HANGUL SYLLABLE PIEUP AE SSANGSIOS
  {0xB9F0, 0xBC45}, //9710 #HANGUL SYLLABLE PIEUP AE IEUNG
  {0xB9F1, 0xBC49}, //9711 #HANGUL SYLLABLE PIEUP AE THIEUTH
  {0xB9F2, 0xBC4C}, //9712 #HANGUL SYLLABLE PIEUP YA
  {0xB9F3, 0xBC4D}, //9713 #HANGUL SYLLABLE PIEUP YA KIYEOK
  {0xB9F4, 0xBC50}, //9714 #HANGUL SYLLABLE PIEUP YA NIEUN
  {0xB9F5, 0xBC5D}, //9715 #HANGUL SYLLABLE PIEUP YA PIEUP
  {0xB9F6, 0xBC84}, //9716 #HANGUL SYLLABLE PIEUP EO
  {0xB9F7, 0xBC85}, //9717 #HANGUL SYLLABLE PIEUP EO KIYEOK
  {0xB9F8, 0xBC88}, //9718 #HANGUL SYLLABLE PIEUP EO NIEUN
  {0xB9F9, 0xBC8B}, //9719 #HANGUL SYLLABLE PIEUP EO TIKEUT
  {0xB9FA, 0xBC8C}, //9720 #HANGUL SYLLABLE PIEUP EO RIEUL
  {0xB9FB, 0xBC8E}, //9721 #HANGUL SYLLABLE PIEUP EO RIEULMIEUM
  {0xB9FC, 0xBC94}, //9722 #HANGUL SYLLABLE PIEUP EO MIEUM
  {0xB9FD, 0xBC95}, //9723 #HANGUL SYLLABLE PIEUP EO PIEUP
  {0xB9FE, 0xBC97}, //9724 #HANGUL SYLLABLE PIEUP EO SIOS
  {0xBA41, 0xD28D}, //9725 #HANGUL SYLLABLE THIEUTH WI RIEULTHIEUTH
  {0xBA42, 0xD28E}, //9726 #HANGUL SYLLABLE THIEUTH WI RIEULPHIEUPH
  {0xBA43, 0xD28F}, //9727 #HANGUL SYLLABLE THIEUTH WI RIEULHIEUH
  {0xBA44, 0xD292}, //9728 #HANGUL SYLLABLE THIEUTH WI PIEUPSIOS
  {0xBA45, 0xD293}, //9729 #HANGUL SYLLABLE THIEUTH WI SIOS
  {0xBA46, 0xD294}, //9730 #HANGUL SYLLABLE THIEUTH WI SSANGSIOS
  {0xBA47, 0xD296}, //9731 #HANGUL SYLLABLE THIEUTH WI CIEUC
  {0xBA48, 0xD297}, //9732 #HANGUL SYLLABLE THIEUTH WI CHIEUCH
  {0xBA49, 0xD298}, //9733 #HANGUL SYLLABLE THIEUTH WI KHIEUKH
  {0xBA4A, 0xD299}, //9734 #HANGUL SYLLABLE THIEUTH WI THIEUTH
  {0xBA4B, 0xD29A}, //9735 #HANGUL SYLLABLE THIEUTH WI PHIEUPH
  {0xBA4C, 0xD29B}, //9736 #HANGUL SYLLABLE THIEUTH WI HIEUH
  {0xBA4D, 0xD29D}, //9737 #HANGUL SYLLABLE THIEUTH YU KIYEOK
  {0xBA4E, 0xD29E}, //9738 #HANGUL SYLLABLE THIEUTH YU SSANGKIYEOK
  {0xBA4F, 0xD29F}, //9739 #HANGUL SYLLABLE THIEUTH YU KIYEOKSIOS
  {0xBA50, 0xD2A1}, //9740 #HANGUL SYLLABLE THIEUTH YU NIEUNCIEUC
  {0xBA51, 0xD2A2}, //9741 #HANGUL SYLLABLE THIEUTH YU NIEUNHIEUH
  {0xBA52, 0xD2A3}, //9742 #HANGUL SYLLABLE THIEUTH YU TIKEUT
  {0xBA53, 0xD2A5}, //9743 #HANGUL SYLLABLE THIEUTH YU RIEULKIYEOK
  {0xBA54, 0xD2A6}, //9744 #HANGUL SYLLABLE THIEUTH YU RIEULMIEUM
  {0xBA55, 0xD2A7}, //9745 #HANGUL SYLLABLE THIEUTH YU RIEULPIEUP
  {0xBA56, 0xD2A8}, //9746 #HANGUL SYLLABLE THIEUTH YU RIEULSIOS
  {0xBA57, 0xD2A9}, //9747 #HANGUL SYLLABLE THIEUTH YU RIEULTHIEUTH
  {0xBA58, 0xD2AA}, //9748 #HANGUL SYLLABLE THIEUTH YU RIEULPHIEUPH
  {0xBA59, 0xD2AB}, //9749 #HANGUL SYLLABLE THIEUTH YU RIEULHIEUH
  {0xBA5A, 0xD2AD}, //9750 #HANGUL SYLLABLE THIEUTH YU PIEUP
  {0xBA61, 0xD2AE}, //9751 #HANGUL SYLLABLE THIEUTH YU PIEUPSIOS
  {0xBA62, 0xD2AF}, //9752 #HANGUL SYLLABLE THIEUTH YU SIOS
  {0xBA63, 0xD2B0}, //9753 #HANGUL SYLLABLE THIEUTH YU SSANGSIOS
  {0xBA64, 0xD2B2}, //9754 #HANGUL SYLLABLE THIEUTH YU CIEUC
  {0xBA65, 0xD2B3}, //9755 #HANGUL SYLLABLE THIEUTH YU CHIEUCH
  {0xBA66, 0xD2B4}, //9756 #HANGUL SYLLABLE THIEUTH YU KHIEUKH
  {0xBA67, 0xD2B5}, //9757 #HANGUL SYLLABLE THIEUTH YU THIEUTH
  {0xBA68, 0xD2B6}, //9758 #HANGUL SYLLABLE THIEUTH YU PHIEUPH
  {0xBA69, 0xD2B7}, //9759 #HANGUL SYLLABLE THIEUTH YU HIEUH
  {0xBA6A, 0xD2BA}, //9760 #HANGUL SYLLABLE THIEUTH EU SSANGKIYEOK
  {0xBA6B, 0xD2BB}, //9761 #HANGUL SYLLABLE THIEUTH EU KIYEOKSIOS
  {0xBA6C, 0xD2BD}, //9762 #HANGUL SYLLABLE THIEUTH EU NIEUNCIEUC
  {0xBA6D, 0xD2BE}, //9763 #HANGUL SYLLABLE THIEUTH EU NIEUNHIEUH
  {0xBA6E, 0xD2C1}, //9764 #HANGUL SYLLABLE THIEUTH EU RIEULKIYEOK
  {0xBA6F, 0xD2C3}, //9765 #HANGUL SYLLABLE THIEUTH EU RIEULPIEUP
  {0xBA70, 0xD2C4}, //9766 #HANGUL SYLLABLE THIEUTH EU RIEULSIOS
  {0xBA71, 0xD2C5}, //9767 #HANGUL SYLLABLE THIEUTH EU RIEULTHIEUTH
  {0xBA72, 0xD2C6}, //9768 #HANGUL SYLLABLE THIEUTH EU RIEULPHIEUPH
  {0xBA73, 0xD2C7}, //9769 #HANGUL SYLLABLE THIEUTH EU RIEULHIEUH
  {0xBA74, 0xD2CA}, //9770 #HANGUL SYLLABLE THIEUTH EU PIEUPSIOS
  {0xBA75, 0xD2CC}, //9771 #HANGUL SYLLABLE THIEUTH EU SSANGSIOS
  {0xBA76, 0xD2CD}, //9772 #HANGUL SYLLABLE THIEUTH EU IEUNG
  {0xBA77, 0xD2CE}, //9773 #HANGUL SYLLABLE THIEUTH EU CIEUC
  {0xBA78, 0xD2CF}, //9774 #HANGUL SYLLABLE THIEUTH EU CHIEUCH
  {0xBA79, 0xD2D0}, //9775 #HANGUL SYLLABLE THIEUTH EU KHIEUKH
  {0xBA7A, 0xD2D1}, //9776 #HANGUL SYLLABLE THIEUTH EU THIEUTH
  {0xBA81, 0xD2D2}, //9777 #HANGUL SYLLABLE THIEUTH EU PHIEUPH
  {0xBA82, 0xD2D3}, //9778 #HANGUL SYLLABLE THIEUTH EU HIEUH
  {0xBA83, 0xD2D5}, //9779 #HANGUL SYLLABLE THIEUTH YI KIYEOK
  {0xBA84, 0xD2D6}, //9780 #HANGUL SYLLABLE THIEUTH YI SSANGKIYEOK
  {0xBA85, 0xD2D7}, //9781 #HANGUL SYLLABLE THIEUTH YI KIYEOKSIOS
  {0xBA86, 0xD2D9}, //9782 #HANGUL SYLLABLE THIEUTH YI NIEUNCIEUC
  {0xBA87, 0xD2DA}, //9783 #HANGUL SYLLABLE THIEUTH YI NIEUNHIEUH
  {0xBA88, 0xD2DB}, //9784 #HANGUL SYLLABLE THIEUTH YI TIKEUT
  {0xBA89, 0xD2DD}, //9785 #HANGUL SYLLABLE THIEUTH YI RIEULKIYEOK
  {0xBA8A, 0xD2DE}, //9786 #HANGUL SYLLABLE THIEUTH YI RIEULMIEUM
  {0xBA8B, 0xD2DF}, //9787 #HANGUL SYLLABLE THIEUTH YI RIEULPIEUP
  {0xBA8C, 0xD2E0}, //9788 #HANGUL SYLLABLE THIEUTH YI RIEULSIOS
  {0xBA8D, 0xD2E1}, //9789 #HANGUL SYLLABLE THIEUTH YI RIEULTHIEUTH
  {0xBA8E, 0xD2E2}, //9790 #HANGUL SYLLABLE THIEUTH YI RIEULPHIEUPH
  {0xBA8F, 0xD2E3}, //9791 #HANGUL SYLLABLE THIEUTH YI RIEULHIEUH
  {0xBA90, 0xD2E6}, //9792 #HANGUL SYLLABLE THIEUTH YI PIEUPSIOS
  {0xBA91, 0xD2E7}, //9793 #HANGUL SYLLABLE THIEUTH YI SIOS
  {0xBA92, 0xD2E8}, //9794 #HANGUL SYLLABLE THIEUTH YI SSANGSIOS
  {0xBA93, 0xD2E9}, //9795 #HANGUL SYLLABLE THIEUTH YI IEUNG
  {0xBA94, 0xD2EA}, //9796 #HANGUL SYLLABLE THIEUTH YI CIEUC
  {0xBA95, 0xD2EB}, //9797 #HANGUL SYLLABLE THIEUTH YI CHIEUCH
  {0xBA96, 0xD2EC}, //9798 #HANGUL SYLLABLE THIEUTH YI KHIEUKH
  {0xBA97, 0xD2ED}, //9799 #HANGUL SYLLABLE THIEUTH YI THIEUTH
  {0xBA98, 0xD2EE}, //9800 #HANGUL SYLLABLE THIEUTH YI PHIEUPH
  {0xBA99, 0xD2EF}, //9801 #HANGUL SYLLABLE THIEUTH YI HIEUH
  {0xBA9A, 0xD2F2}, //9802 #HANGUL SYLLABLE THIEUTH I SSANGKIYEOK
  {0xBA9B, 0xD2F3}, //9803 #HANGUL SYLLABLE THIEUTH I KIYEOKSIOS
  {0xBA9C, 0xD2F5}, //9804 #HANGUL SYLLABLE THIEUTH I NIEUNCIEUC
  {0xBA9D, 0xD2F6}, //9805 #HANGUL SYLLABLE THIEUTH I NIEUNHIEUH
  {0xBA9E, 0xD2F7}, //9806 #HANGUL SYLLABLE THIEUTH I TIKEUT
  {0xBA9F, 0xD2F9}, //9807 #HANGUL SYLLABLE THIEUTH I RIEULKIYEOK
  {0xBAA0, 0xD2FA}, //9808 #HANGUL SYLLABLE THIEUTH I RIEULMIEUM
  {0xBAA1, 0xBC99}, //9809 #HANGUL SYLLABLE PIEUP EO IEUNG
  {0xBAA2, 0xBC9A}, //9810 #HANGUL SYLLABLE PIEUP EO CIEUC
  {0xBAA3, 0xBCA0}, //9811 #HANGUL SYLLABLE PIEUP E
  {0xBAA4, 0xBCA1}, //9812 #HANGUL SYLLABLE PIEUP E KIYEOK
  {0xBAA5, 0xBCA4}, //9813 #HANGUL SYLLABLE PIEUP E NIEUN
  {0xBAA6, 0xBCA7}, //9814 #HANGUL SYLLABLE PIEUP E TIKEUT
  {0xBAA7, 0xBCA8}, //9815 #HANGUL SYLLABLE PIEUP E RIEUL
  {0xBAA8, 0xBCB0}, //9816 #HANGUL SYLLABLE PIEUP E MIEUM
  {0xBAA9, 0xBCB1}, //9817 #HANGUL SYLLABLE PIEUP E PIEUP
  {0xBAAA, 0xBCB3}, //9818 #HANGUL SYLLABLE PIEUP E SIOS
  {0xBAAB, 0xBCB4}, //9819 #HANGUL SYLLABLE PIEUP E SSANGSIOS
  {0xBAAC, 0xBCB5}, //9820 #HANGUL SYLLABLE PIEUP E IEUNG
  {0xBAAD, 0xBCBC}, //9821 #HANGUL SYLLABLE PIEUP YEO
  {0xBAAE, 0xBCBD}, //9822 #HANGUL SYLLABLE PIEUP YEO KIYEOK
  {0xBAAF, 0xBCC0}, //9823 #HANGUL SYLLABLE PIEUP YEO NIEUN
  {0xBAB0, 0xBCC4}, //9824 #HANGUL SYLLABLE PIEUP YEO RIEUL
  {0xBAB1, 0xBCCD}, //9825 #HANGUL SYLLABLE PIEUP YEO PIEUP
  {0xBAB2, 0xBCCF}, //9826 #HANGUL SYLLABLE PIEUP YEO SIOS
  {0xBAB3, 0xBCD0}, //9827 #HANGUL SYLLABLE PIEUP YEO SSANGSIOS
  {0xBAB4, 0xBCD1}, //9828 #HANGUL SYLLABLE PIEUP YEO IEUNG
  {0xBAB5, 0xBCD5}, //9829 #HANGUL SYLLABLE PIEUP YEO THIEUTH
  {0xBAB6, 0xBCD8}, //9830 #HANGUL SYLLABLE PIEUP YE
  {0xBAB7, 0xBCDC}, //9831 #HANGUL SYLLABLE PIEUP YE NIEUN
  {0xBAB8, 0xBCF4}, //9832 #HANGUL SYLLABLE PIEUP O
  {0xBAB9, 0xBCF5}, //9833 #HANGUL SYLLABLE PIEUP O KIYEOK
  {0xBABA, 0xBCF6}, //9834 #HANGUL SYLLABLE PIEUP O SSANGKIYEOK
  {0xBABB, 0xBCF8}, //9835 #HANGUL SYLLABLE PIEUP O NIEUN
  {0xBABC, 0xBCFC}, //9836 #HANGUL SYLLABLE PIEUP O RIEUL
  {0xBABD, 0xBD04}, //9837 #HANGUL SYLLABLE PIEUP O MIEUM
  {0xBABE, 0xBD05}, //9838 #HANGUL SYLLABLE PIEUP O PIEUP
  {0xBABF, 0xBD07}, //9839 #HANGUL SYLLABLE PIEUP O SIOS
  {0xBAC0, 0xBD09}, //9840 #HANGUL SYLLABLE PIEUP O IEUNG
  {0xBAC1, 0xBD10}, //9841 #HANGUL SYLLABLE PIEUP WA
  {0xBAC2, 0xBD14}, //9842 #HANGUL SYLLABLE PIEUP WA NIEUN
  {0xBAC3, 0xBD24}, //9843 #HANGUL SYLLABLE PIEUP WA SSANGSIOS
  {0xBAC4, 0xBD2C}, //9844 #HANGUL SYLLABLE PIEUP WAE
  {0xBAC5, 0xBD40}, //9845 #HANGUL SYLLABLE PIEUP WAE SSANGSIOS
  {0xBAC6, 0xBD48}, //9846 #HANGUL SYLLABLE PIEUP OE
  {0xBAC7, 0xBD49}, //9847 #HANGUL SYLLABLE PIEUP OE KIYEOK
  {0xBAC8, 0xBD4C}, //9848 #HANGUL SYLLABLE PIEUP OE NIEUN
  {0xBAC9, 0xBD50}, //9849 #HANGUL SYLLABLE PIEUP OE RIEUL
  {0xBACA, 0xBD58}, //9850 #HANGUL SYLLABLE PIEUP OE MIEUM
  {0xBACB, 0xBD59}, //9851 #HANGUL SYLLABLE PIEUP OE PIEUP
  {0xBACC, 0xBD64}, //9852 #HANGUL SYLLABLE PIEUP YO
  {0xBACD, 0xBD68}, //9853 #HANGUL SYLLABLE PIEUP YO NIEUN
  {0xBACE, 0xBD80}, //9854 #HANGUL SYLLABLE PIEUP U
  {0xBACF, 0xBD81}, //9855 #HANGUL SYLLABLE PIEUP U KIYEOK
  {0xBAD0, 0xBD84}, //9856 #HANGUL SYLLABLE PIEUP U NIEUN
  {0xBAD1, 0xBD87}, //9857 #HANGUL SYLLABLE PIEUP U TIKEUT
  {0xBAD2, 0xBD88}, //9858 #HANGUL SYLLABLE PIEUP U RIEUL
  {0xBAD3, 0xBD89}, //9859 #HANGUL SYLLABLE PIEUP U RIEULKIYEOK
  {0xBAD4, 0xBD8A}, //9860 #HANGUL SYLLABLE PIEUP U RIEULMIEUM
  {0xBAD5, 0xBD90}, //9861 #HANGUL SYLLABLE PIEUP U MIEUM
  {0xBAD6, 0xBD91}, //9862 #HANGUL SYLLABLE PIEUP U PIEUP
  {0xBAD7, 0xBD93}, //9863 #HANGUL SYLLABLE PIEUP U SIOS
  {0xBAD8, 0xBD95}, //9864 #HANGUL SYLLABLE PIEUP U IEUNG
  {0xBAD9, 0xBD99}, //9865 #HANGUL SYLLABLE PIEUP U THIEUTH
  {0xBADA, 0xBD9A}, //9866 #HANGUL SYLLABLE PIEUP U PHIEUPH
  {0xBADB, 0xBD9C}, //9867 #HANGUL SYLLABLE PIEUP WEO
  {0xBADC, 0xBDA4}, //9868 #HANGUL SYLLABLE PIEUP WEO RIEUL
  {0xBADD, 0xBDB0}, //9869 #HANGUL SYLLABLE PIEUP WEO SSANGSIOS
  {0xBADE, 0xBDB8}, //9870 #HANGUL SYLLABLE PIEUP WE
  {0xBADF, 0xBDD4}, //9871 #HANGUL SYLLABLE PIEUP WI
  {0xBAE0, 0xBDD5}, //9872 #HANGUL SYLLABLE PIEUP WI KIYEOK
  {0xBAE1, 0xBDD8}, //9873 #HANGUL SYLLABLE PIEUP WI NIEUN
  {0xBAE2, 0xBDDC}, //9874 #HANGUL SYLLABLE PIEUP WI RIEUL
  {0xBAE3, 0xBDE9}, //9875 #HANGUL SYLLABLE PIEUP WI IEUNG
  {0xBAE4, 0xBDF0}, //9876 #HANGUL SYLLABLE PIEUP YU
  {0xBAE5, 0xBDF4}, //9877 #HANGUL SYLLABLE PIEUP YU NIEUN
  {0xBAE6, 0xBDF8}, //9878 #HANGUL SYLLABLE PIEUP YU RIEUL
  {0xBAE7, 0xBE00}, //9879 #HANGUL SYLLABLE PIEUP YU MIEUM
  {0xBAE8, 0xBE03}, //9880 #HANGUL SYLLABLE PIEUP YU SIOS
  {0xBAE9, 0xBE05}, //9881 #HANGUL SYLLABLE PIEUP YU IEUNG
  {0xBAEA, 0xBE0C}, //9882 #HANGUL SYLLABLE PIEUP EU
  {0xBAEB, 0xBE0D}, //9883 #HANGUL SYLLABLE PIEUP EU KIYEOK
  {0xBAEC, 0xBE10}, //9884 #HANGUL SYLLABLE PIEUP EU NIEUN
  {0xBAED, 0xBE14}, //9885 #HANGUL SYLLABLE PIEUP EU RIEUL
  {0xBAEE, 0xBE1C}, //9886 #HANGUL SYLLABLE PIEUP EU MIEUM
  {0xBAEF, 0xBE1D}, //9887 #HANGUL SYLLABLE PIEUP EU PIEUP
  {0xBAF0, 0xBE1F}, //9888 #HANGUL SYLLABLE PIEUP EU SIOS
  {0xBAF1, 0xBE44}, //9889 #HANGUL SYLLABLE PIEUP I
  {0xBAF2, 0xBE45}, //9890 #HANGUL SYLLABLE PIEUP I KIYEOK
  {0xBAF3, 0xBE48}, //9891 #HANGUL SYLLABLE PIEUP I NIEUN
  {0xBAF4, 0xBE4C}, //9892 #HANGUL SYLLABLE PIEUP I RIEUL
  {0xBAF5, 0xBE4E}, //9893 #HANGUL SYLLABLE PIEUP I RIEULMIEUM
  {0xBAF6, 0xBE54}, //9894 #HANGUL SYLLABLE PIEUP I MIEUM
  {0xBAF7, 0xBE55}, //9895 #HANGUL SYLLABLE PIEUP I PIEUP
  {0xBAF8, 0xBE57}, //9896 #HANGUL SYLLABLE PIEUP I SIOS
  {0xBAF9, 0xBE59}, //9897 #HANGUL SYLLABLE PIEUP I IEUNG
  {0xBAFA, 0xBE5A}, //9898 #HANGUL SYLLABLE PIEUP I CIEUC
  {0xBAFB, 0xBE5B}, //9899 #HANGUL SYLLABLE PIEUP I CHIEUCH
  {0xBAFC, 0xBE60}, //9900 #HANGUL SYLLABLE SSANGPIEUP A
  {0xBAFD, 0xBE61}, //9901 #HANGUL SYLLABLE SSANGPIEUP A KIYEOK
  {0xBAFE, 0xBE64}, //9902 #HANGUL SYLLABLE SSANGPIEUP A NIEUN
  {0xBB41, 0xD2FB}, //9903 #HANGUL SYLLABLE THIEUTH I RIEULPIEUP
  {0xBB42, 0xD2FC}, //9904 #HANGUL SYLLABLE THIEUTH I RIEULSIOS
  {0xBB43, 0xD2FD}, //9905 #HANGUL SYLLABLE THIEUTH I RIEULTHIEUTH
  {0xBB44, 0xD2FE}, //9906 #HANGUL SYLLABLE THIEUTH I RIEULPHIEUPH
  {0xBB45, 0xD2FF}, //9907 #HANGUL SYLLABLE THIEUTH I RIEULHIEUH
  {0xBB46, 0xD302}, //9908 #HANGUL SYLLABLE THIEUTH I PIEUPSIOS
  {0xBB47, 0xD304}, //9909 #HANGUL SYLLABLE THIEUTH I SSANGSIOS
  {0xBB48, 0xD306}, //9910 #HANGUL SYLLABLE THIEUTH I CIEUC
  {0xBB49, 0xD307}, //9911 #HANGUL SYLLABLE THIEUTH I CHIEUCH
  {0xBB4A, 0xD308}, //9912 #HANGUL SYLLABLE THIEUTH I KHIEUKH
  {0xBB4B, 0xD309}, //9913 #HANGUL SYLLABLE THIEUTH I THIEUTH
  {0xBB4C, 0xD30A}, //9914 #HANGUL SYLLABLE THIEUTH I PHIEUPH
  {0xBB4D, 0xD30B}, //9915 #HANGUL SYLLABLE THIEUTH I HIEUH
  {0xBB4E, 0xD30F}, //9916 #HANGUL SYLLABLE PHIEUPH A KIYEOKSIOS
  {0xBB4F, 0xD311}, //9917 #HANGUL SYLLABLE PHIEUPH A NIEUNCIEUC
  {0xBB50, 0xD312}, //9918 #HANGUL SYLLABLE PHIEUPH A NIEUNHIEUH
  {0xBB51, 0xD313}, //9919 #HANGUL SYLLABLE PHIEUPH A TIKEUT
  {0xBB52, 0xD315}, //9920 #HANGUL SYLLABLE PHIEUPH A RIEULKIYEOK
  {0xBB53, 0xD317}, //9921 #HANGUL SYLLABLE PHIEUPH A RIEULPIEUP
  {0xBB54, 0xD318}, //9922 #HANGUL SYLLABLE PHIEUPH A RIEULSIOS
  {0xBB55, 0xD319}, //9923 #HANGUL SYLLABLE PHIEUPH A RIEULTHIEUTH
  {0xBB56, 0xD31A}, //9924 #HANGUL SYLLABLE PHIEUPH A RIEULPHIEUPH
  {0xBB57, 0xD31B}, //9925 #HANGUL SYLLABLE PHIEUPH A RIEULHIEUH
  {0xBB58, 0xD31E}, //9926 #HANGUL SYLLABLE PHIEUPH A PIEUPSIOS
  {0xBB59, 0xD322}, //9927 #HANGUL SYLLABLE PHIEUPH A CIEUC
  {0xBB5A, 0xD323}, //9928 #HANGUL SYLLABLE PHIEUPH A CHIEUCH
  {0xBB61, 0xD324}, //9929 #HANGUL SYLLABLE PHIEUPH A KHIEUKH
  {0xBB62, 0xD326}, //9930 #HANGUL SYLLABLE PHIEUPH A PHIEUPH
  {0xBB63, 0xD327}, //9931 #HANGUL SYLLABLE PHIEUPH A HIEUH
  {0xBB64, 0xD32A}, //9932 #HANGUL SYLLABLE PHIEUPH AE SSANGKIYEOK
  {0xBB65, 0xD32B}, //9933 #HANGUL SYLLABLE PHIEUPH AE KIYEOKSIOS
  {0xBB66, 0xD32D}, //9934 #HANGUL SYLLABLE PHIEUPH AE NIEUNCIEUC
  {0xBB67, 0xD32E}, //9935 #HANGUL SYLLABLE PHIEUPH AE NIEUNHIEUH
  {0xBB68, 0xD32F}, //9936 #HANGUL SYLLABLE PHIEUPH AE TIKEUT
  {0xBB69, 0xD331}, //9937 #HANGUL SYLLABLE PHIEUPH AE RIEULKIYEOK
  {0xBB6A, 0xD332}, //9938 #HANGUL SYLLABLE PHIEUPH AE RIEULMIEUM
  {0xBB6B, 0xD333}, //9939 #HANGUL SYLLABLE PHIEUPH AE RIEULPIEUP
  {0xBB6C, 0xD334}, //9940 #HANGUL SYLLABLE PHIEUPH AE RIEULSIOS
  {0xBB6D, 0xD335}, //9941 #HANGUL SYLLABLE PHIEUPH AE RIEULTHIEUTH
  {0xBB6E, 0xD336}, //9942 #HANGUL SYLLABLE PHIEUPH AE RIEULPHIEUPH
  {0xBB6F, 0xD337}, //9943 #HANGUL SYLLABLE PHIEUPH AE RIEULHIEUH
  {0xBB70, 0xD33A}, //9944 #HANGUL SYLLABLE PHIEUPH AE PIEUPSIOS
  {0xBB71, 0xD33E}, //9945 #HANGUL SYLLABLE PHIEUPH AE CIEUC
  {0xBB72, 0xD33F}, //9946 #HANGUL SYLLABLE PHIEUPH AE CHIEUCH
  {0xBB73, 0xD340}, //9947 #HANGUL SYLLABLE PHIEUPH AE KHIEUKH
  {0xBB74, 0xD341}, //9948 #HANGUL SYLLABLE PHIEUPH AE THIEUTH
  {0xBB75, 0xD342}, //9949 #HANGUL SYLLABLE PHIEUPH AE PHIEUPH
  {0xBB76, 0xD343}, //9950 #HANGUL SYLLABLE PHIEUPH AE HIEUH
  {0xBB77, 0xD346}, //9951 #HANGUL SYLLABLE PHIEUPH YA SSANGKIYEOK
  {0xBB78, 0xD347}, //9952 #HANGUL SYLLABLE PHIEUPH YA KIYEOKSIOS
  {0xBB79, 0xD348}, //9953 #HANGUL SYLLABLE PHIEUPH YA NIEUN
  {0xBB7A, 0xD349}, //9954 #HANGUL SYLLABLE PHIEUPH YA NIEUNCIEUC
  {0xBB81, 0xD34A}, //9955 #HANGUL SYLLABLE PHIEUPH YA NIEUNHIEUH
  {0xBB82, 0xD34B}, //9956 #HANGUL SYLLABLE PHIEUPH YA TIKEUT
  {0xBB83, 0xD34C}, //9957 #HANGUL SYLLABLE PHIEUPH YA RIEUL
  {0xBB84, 0xD34D}, //9958 #HANGUL SYLLABLE PHIEUPH YA RIEULKIYEOK
  {0xBB85, 0xD34E}, //9959 #HANGUL SYLLABLE PHIEUPH YA RIEULMIEUM
  {0xBB86, 0xD34F}, //9960 #HANGUL SYLLABLE PHIEUPH YA RIEULPIEUP
  {0xBB87, 0xD350}, //9961 #HANGUL SYLLABLE PHIEUPH YA RIEULSIOS
  {0xBB88, 0xD351}, //9962 #HANGUL SYLLABLE PHIEUPH YA RIEULTHIEUTH
  {0xBB89, 0xD352}, //9963 #HANGUL SYLLABLE PHIEUPH YA RIEULPHIEUPH
  {0xBB8A, 0xD353}, //9964 #HANGUL SYLLABLE PHIEUPH YA RIEULHIEUH
  {0xBB8B, 0xD354}, //9965 #HANGUL SYLLABLE PHIEUPH YA MIEUM
  {0xBB8C, 0xD355}, //9966 #HANGUL SYLLABLE PHIEUPH YA PIEUP
  {0xBB8D, 0xD356}, //9967 #HANGUL SYLLABLE PHIEUPH YA PIEUPSIOS
  {0xBB8E, 0xD357}, //9968 #HANGUL SYLLABLE PHIEUPH YA SIOS
  {0xBB8F, 0xD358}, //9969 #HANGUL SYLLABLE PHIEUPH YA SSANGSIOS
  {0xBB90, 0xD359}, //9970 #HANGUL SYLLABLE PHIEUPH YA IEUNG
  {0xBB91, 0xD35A}, //9971 #HANGUL SYLLABLE PHIEUPH YA CIEUC
  {0xBB92, 0xD35B}, //9972 #HANGUL SYLLABLE PHIEUPH YA CHIEUCH
  {0xBB93, 0xD35C}, //9973 #HANGUL SYLLABLE PHIEUPH YA KHIEUKH
  {0xBB94, 0xD35D}, //9974 #HANGUL SYLLABLE PHIEUPH YA THIEUTH
  {0xBB95, 0xD35E}, //9975 #HANGUL SYLLABLE PHIEUPH YA PHIEUPH
  {0xBB96, 0xD35F}, //9976 #HANGUL SYLLABLE PHIEUPH YA HIEUH
  {0xBB97, 0xD360}, //9977 #HANGUL SYLLABLE PHIEUPH YAE
  {0xBB98, 0xD361}, //9978 #HANGUL SYLLABLE PHIEUPH YAE KIYEOK
  {0xBB99, 0xD362}, //9979 #HANGUL SYLLABLE PHIEUPH YAE SSANGKIYEOK
  {0xBB9A, 0xD363}, //9980 #HANGUL SYLLABLE PHIEUPH YAE KIYEOKSIOS
  {0xBB9B, 0xD364}, //9981 #HANGUL SYLLABLE PHIEUPH YAE NIEUN
  {0xBB9C, 0xD365}, //9982 #HANGUL SYLLABLE PHIEUPH YAE NIEUNCIEUC
  {0xBB9D, 0xD366}, //9983 #HANGUL SYLLABLE PHIEUPH YAE NIEUNHIEUH
  {0xBB9E, 0xD367}, //9984 #HANGUL SYLLABLE PHIEUPH YAE TIKEUT
  {0xBB9F, 0xD368}, //9985 #HANGUL SYLLABLE PHIEUPH YAE RIEUL
  {0xBBA0, 0xD369}, //9986 #HANGUL SYLLABLE PHIEUPH YAE RIEULKIYEOK
  {0xBBA1, 0xBE68}, //9987 #HANGUL SYLLABLE SSANGPIEUP A RIEUL
  {0xBBA2, 0xBE6A}, //9988 #HANGUL SYLLABLE SSANGPIEUP A RIEULMIEUM
  {0xBBA3, 0xBE70}, //9989 #HANGUL SYLLABLE SSANGPIEUP A MIEUM
  {0xBBA4, 0xBE71}, //9990 #HANGUL SYLLABLE SSANGPIEUP A PIEUP
  {0xBBA5, 0xBE73}, //9991 #HANGUL SYLLABLE SSANGPIEUP A SIOS
  {0xBBA6, 0xBE74}, //9992 #HANGUL SYLLABLE SSANGPIEUP A SSANGSIOS
  {0xBBA7, 0xBE75}, //9993 #HANGUL SYLLABLE SSANGPIEUP A IEUNG
  {0xBBA8, 0xBE7B}, //9994 #HANGUL SYLLABLE SSANGPIEUP A HIEUH
  {0xBBA9, 0xBE7C}, //9995 #HANGUL SYLLABLE SSANGPIEUP AE
  {0xBBAA, 0xBE7D}, //9996 #HANGUL SYLLABLE SSANGPIEUP AE KIYEOK
  {0xBBAB, 0xBE80}, //9997 #HANGUL SYLLABLE SSANGPIEUP AE NIEUN
  {0xBBAC, 0xBE84}, //9998 #HANGUL SYLLABLE SSANGPIEUP AE RIEUL
  {0xBBAD, 0xBE8C}, //9999 #HANGUL SYLLABLE SSANGPIEUP AE MIEUM
  {0xBBAE, 0xBE8D}, //10000 #HANGUL SYLLABLE SSANGPIEUP AE PIEUP
  {0xBBAF, 0xBE8F}, //10001 #HANGUL SYLLABLE SSANGPIEUP AE SIOS
  {0xBBB0, 0xBE90}, //10002 #HANGUL SYLLABLE SSANGPIEUP AE SSANGSIOS
  {0xBBB1, 0xBE91}, //10003 #HANGUL SYLLABLE SSANGPIEUP AE IEUNG
  {0xBBB2, 0xBE98}, //10004 #HANGUL SYLLABLE SSANGPIEUP YA
  {0xBBB3, 0xBE99}, //10005 #HANGUL SYLLABLE SSANGPIEUP YA KIYEOK
  {0xBBB4, 0xBEA8}, //10006 #HANGUL SYLLABLE SSANGPIEUP YA MIEUM
  {0xBBB5, 0xBED0}, //10007 #HANGUL SYLLABLE SSANGPIEUP EO
  {0xBBB6, 0xBED1}, //10008 #HANGUL SYLLABLE SSANGPIEUP EO KIYEOK
  {0xBBB7, 0xBED4}, //10009 #HANGUL SYLLABLE SSANGPIEUP EO NIEUN
  {0xBBB8, 0xBED7}, //10010 #HANGUL SYLLABLE SSANGPIEUP EO TIKEUT
  {0xBBB9, 0xBED8}, //10011 #HANGUL SYLLABLE SSANGPIEUP EO RIEUL
  {0xBBBA, 0xBEE0}, //10012 #HANGUL SYLLABLE SSANGPIEUP EO MIEUM
  {0xBBBB, 0xBEE3}, //10013 #HANGUL SYLLABLE SSANGPIEUP EO SIOS
  {0xBBBC, 0xBEE4}, //10014 #HANGUL SYLLABLE SSANGPIEUP EO SSANGSIOS
  {0xBBBD, 0xBEE5}, //10015 #HANGUL SYLLABLE SSANGPIEUP EO IEUNG
  {0xBBBE, 0xBEEC}, //10016 #HANGUL SYLLABLE SSANGPIEUP E
  {0xBBBF, 0xBF01}, //10017 #HANGUL SYLLABLE SSANGPIEUP E IEUNG
  {0xBBC0, 0xBF08}, //10018 #HANGUL SYLLABLE SSANGPIEUP YEO
  {0xBBC1, 0xBF09}, //10019 #HANGUL SYLLABLE SSANGPIEUP YEO KIYEOK
  {0xBBC2, 0xBF18}, //10020 #HANGUL SYLLABLE SSANGPIEUP YEO MIEUM
  {0xBBC3, 0xBF19}, //10021 #HANGUL SYLLABLE SSANGPIEUP YEO PIEUP
  {0xBBC4, 0xBF1B}, //10022 #HANGUL SYLLABLE SSANGPIEUP YEO SIOS
  {0xBBC5, 0xBF1C}, //10023 #HANGUL SYLLABLE SSANGPIEUP YEO SSANGSIOS
  {0xBBC6, 0xBF1D}, //10024 #HANGUL SYLLABLE SSANGPIEUP YEO IEUNG
  {0xBBC7, 0xBF40}, //10025 #HANGUL SYLLABLE SSANGPIEUP O
  {0xBBC8, 0xBF41}, //10026 #HANGUL SYLLABLE SSANGPIEUP O KIYEOK
  {0xBBC9, 0xBF44}, //10027 #HANGUL SYLLABLE SSANGPIEUP O NIEUN
  {0xBBCA, 0xBF48}, //10028 #HANGUL SYLLABLE SSANGPIEUP O RIEUL
  {0xBBCB, 0xBF50}, //10029 #HANGUL SYLLABLE SSANGPIEUP O MIEUM
  {0xBBCC, 0xBF51}, //10030 #HANGUL SYLLABLE SSANGPIEUP O PIEUP
  {0xBBCD, 0xBF55}, //10031 #HANGUL SYLLABLE SSANGPIEUP O IEUNG
  {0xBBCE, 0xBF94}, //10032 #HANGUL SYLLABLE SSANGPIEUP OE
  {0xBBCF, 0xBFB0}, //10033 #HANGUL SYLLABLE SSANGPIEUP YO
  {0xBBD0, 0xBFC5}, //10034 #HANGUL SYLLABLE SSANGPIEUP YO IEUNG
  {0xBBD1, 0xBFCC}, //10035 #HANGUL SYLLABLE SSANGPIEUP U
  {0xBBD2, 0xBFCD}, //10036 #HANGUL SYLLABLE SSANGPIEUP U KIYEOK
  {0xBBD3, 0xBFD0}, //10037 #HANGUL SYLLABLE SSANGPIEUP U NIEUN
  {0xBBD4, 0xBFD4}, //10038 #HANGUL SYLLABLE SSANGPIEUP U RIEUL
  {0xBBD5, 0xBFDC}, //10039 #HANGUL SYLLABLE SSANGPIEUP U MIEUM
  {0xBBD6, 0xBFDF}, //10040 #HANGUL SYLLABLE SSANGPIEUP U SIOS
  {0xBBD7, 0xBFE1}, //10041 #HANGUL SYLLABLE SSANGPIEUP U IEUNG
  {0xBBD8, 0xC03C}, //10042 #HANGUL SYLLABLE SSANGPIEUP YU
  {0xBBD9, 0xC051}, //10043 #HANGUL SYLLABLE SSANGPIEUP YU IEUNG
  {0xBBDA, 0xC058}, //10044 #HANGUL SYLLABLE SSANGPIEUP EU
  {0xBBDB, 0xC05C}, //10045 #HANGUL SYLLABLE SSANGPIEUP EU NIEUN
  {0xBBDC, 0xC060}, //10046 #HANGUL SYLLABLE SSANGPIEUP EU RIEUL
  {0xBBDD, 0xC068}, //10047 #HANGUL SYLLABLE SSANGPIEUP EU MIEUM
  {0xBBDE, 0xC069}, //10048 #HANGUL SYLLABLE SSANGPIEUP EU PIEUP
  {0xBBDF, 0xC090}, //10049 #HANGUL SYLLABLE SSANGPIEUP I
  {0xBBE0, 0xC091}, //10050 #HANGUL SYLLABLE SSANGPIEUP I KIYEOK
  {0xBBE1, 0xC094}, //10051 #HANGUL SYLLABLE SSANGPIEUP I NIEUN
  {0xBBE2, 0xC098}, //10052 #HANGUL SYLLABLE SSANGPIEUP I RIEUL
  {0xBBE3, 0xC0A0}, //10053 #HANGUL SYLLABLE SSANGPIEUP I MIEUM
  {0xBBE4, 0xC0A1}, //10054 #HANGUL SYLLABLE SSANGPIEUP I PIEUP
  {0xBBE5, 0xC0A3}, //10055 #HANGUL SYLLABLE SSANGPIEUP I SIOS
  {0xBBE6, 0xC0A5}, //10056 #HANGUL SYLLABLE SSANGPIEUP I IEUNG
  {0xBBE7, 0xC0AC}, //10057 #HANGUL SYLLABLE SIOS A
  {0xBBE8, 0xC0AD}, //10058 #HANGUL SYLLABLE SIOS A KIYEOK
  {0xBBE9, 0xC0AF}, //10059 #HANGUL SYLLABLE SIOS A KIYEOKSIOS
  {0xBBEA, 0xC0B0}, //10060 #HANGUL SYLLABLE SIOS A NIEUN
  {0xBBEB, 0xC0B3}, //10061 #HANGUL SYLLABLE SIOS A TIKEUT
  {0xBBEC, 0xC0B4}, //10062 #HANGUL SYLLABLE SIOS A RIEUL
  {0xBBED, 0xC0B5}, //10063 #HANGUL SYLLABLE SIOS A RIEULKIYEOK
  {0xBBEE, 0xC0B6}, //10064 #HANGUL SYLLABLE SIOS A RIEULMIEUM
  {0xBBEF, 0xC0BC}, //10065 #HANGUL SYLLABLE SIOS A MIEUM
  {0xBBF0, 0xC0BD}, //10066 #HANGUL SYLLABLE SIOS A PIEUP
  {0xBBF1, 0xC0BF}, //10067 #HANGUL SYLLABLE SIOS A SIOS
  {0xBBF2, 0xC0C0}, //10068 #HANGUL SYLLABLE SIOS A SSANGSIOS
  {0xBBF3, 0xC0C1}, //10069 #HANGUL SYLLABLE SIOS A IEUNG
  {0xBBF4, 0xC0C5}, //10070 #HANGUL SYLLABLE SIOS A THIEUTH
  {0xBBF5, 0xC0C8}, //10071 #HANGUL SYLLABLE SIOS AE
  {0xBBF6, 0xC0C9}, //10072 #HANGUL SYLLABLE SIOS AE KIYEOK
  {0xBBF7, 0xC0CC}, //10073 #HANGUL SYLLABLE SIOS AE NIEUN
  {0xBBF8, 0xC0D0}, //10074 #HANGUL SYLLABLE SIOS AE RIEUL
  {0xBBF9, 0xC0D8}, //10075 #HANGUL SYLLABLE SIOS AE MIEUM
  {0xBBFA, 0xC0D9}, //10076 #HANGUL SYLLABLE SIOS AE PIEUP
  {0xBBFB, 0xC0DB}, //10077 #HANGUL SYLLABLE SIOS AE SIOS
  {0xBBFC, 0xC0DC}, //10078 #HANGUL SYLLABLE SIOS AE SSANGSIOS
  {0xBBFD, 0xC0DD}, //10079 #HANGUL SYLLABLE SIOS AE IEUNG
  {0xBBFE, 0xC0E4}, //10080 #HANGUL SYLLABLE SIOS YA
  {0xBC41, 0xD36A}, //10081 #HANGUL SYLLABLE PHIEUPH YAE RIEULMIEUM
  {0xBC42, 0xD36B}, //10082 #HANGUL SYLLABLE PHIEUPH YAE RIEULPIEUP
  {0xBC43, 0xD36C}, //10083 #HANGUL SYLLABLE PHIEUPH YAE RIEULSIOS
  {0xBC44, 0xD36D}, //10084 #HANGUL SYLLABLE PHIEUPH YAE RIEULTHIEUTH
  {0xBC45, 0xD36E}, //10085 #HANGUL SYLLABLE PHIEUPH YAE RIEULPHIEUPH
  {0xBC46, 0xD36F}, //10086 #HANGUL SYLLABLE PHIEUPH YAE RIEULHIEUH
  {0xBC47, 0xD370}, //10087 #HANGUL SYLLABLE PHIEUPH YAE MIEUM
  {0xBC48, 0xD371}, //10088 #HANGUL SYLLABLE PHIEUPH YAE PIEUP
  {0xBC49, 0xD372}, //10089 #HANGUL SYLLABLE PHIEUPH YAE PIEUPSIOS
  {0xBC4A, 0xD373}, //10090 #HANGUL SYLLABLE PHIEUPH YAE SIOS
  {0xBC4B, 0xD374}, //10091 #HANGUL SYLLABLE PHIEUPH YAE SSANGSIOS
  {0xBC4C, 0xD375}, //10092 #HANGUL SYLLABLE PHIEUPH YAE IEUNG
  {0xBC4D, 0xD376}, //10093 #HANGUL SYLLABLE PHIEUPH YAE CIEUC
  {0xBC4E, 0xD377}, //10094 #HANGUL SYLLABLE PHIEUPH YAE CHIEUCH
  {0xBC4F, 0xD378}, //10095 #HANGUL SYLLABLE PHIEUPH YAE KHIEUKH
  {0xBC50, 0xD379}, //10096 #HANGUL SYLLABLE PHIEUPH YAE THIEUTH
  {0xBC51, 0xD37A}, //10097 #HANGUL SYLLABLE PHIEUPH YAE PHIEUPH
  {0xBC52, 0xD37B}, //10098 #HANGUL SYLLABLE PHIEUPH YAE HIEUH
  {0xBC53, 0xD37E}, //10099 #HANGUL SYLLABLE PHIEUPH EO SSANGKIYEOK
  {0xBC54, 0xD37F}, //10100 #HANGUL SYLLABLE PHIEUPH EO KIYEOKSIOS
  {0xBC55, 0xD381}, //10101 #HANGUL SYLLABLE PHIEUPH EO NIEUNCIEUC
  {0xBC56, 0xD382}, //10102 #HANGUL SYLLABLE PHIEUPH EO NIEUNHIEUH
  {0xBC57, 0xD383}, //10103 #HANGUL SYLLABLE PHIEUPH EO TIKEUT
  {0xBC58, 0xD385}, //10104 #HANGUL SYLLABLE PHIEUPH EO RIEULKIYEOK
  {0xBC59, 0xD386}, //10105 #HANGUL SYLLABLE PHIEUPH EO RIEULMIEUM
  {0xBC5A, 0xD387}, //10106 #HANGUL SYLLABLE PHIEUPH EO RIEULPIEUP
  {0xBC61, 0xD388}, //10107 #HANGUL SYLLABLE PHIEUPH EO RIEULSIOS
  {0xBC62, 0xD389}, //10108 #HANGUL SYLLABLE PHIEUPH EO RIEULTHIEUTH
  {0xBC63, 0xD38A}, //10109 #HANGUL SYLLABLE PHIEUPH EO RIEULPHIEUPH
  {0xBC64, 0xD38B}, //10110 #HANGUL SYLLABLE PHIEUPH EO RIEULHIEUH
  {0xBC65, 0xD38E}, //10111 #HANGUL SYLLABLE PHIEUPH EO PIEUPSIOS
  {0xBC66, 0xD392}, //10112 #HANGUL SYLLABLE PHIEUPH EO CIEUC
  {0xBC67, 0xD393}, //10113 #HANGUL SYLLABLE PHIEUPH EO CHIEUCH
  {0xBC68, 0xD394}, //10114 #HANGUL SYLLABLE PHIEUPH EO KHIEUKH
  {0xBC69, 0xD395}, //10115 #HANGUL SYLLABLE PHIEUPH EO THIEUTH
  {0xBC6A, 0xD396}, //10116 #HANGUL SYLLABLE PHIEUPH EO PHIEUPH
  {0xBC6B, 0xD397}, //10117 #HANGUL SYLLABLE PHIEUPH EO HIEUH
  {0xBC6C, 0xD39A}, //10118 #HANGUL SYLLABLE PHIEUPH E SSANGKIYEOK
  {0xBC6D, 0xD39B}, //10119 #HANGUL SYLLABLE PHIEUPH E KIYEOKSIOS
  {0xBC6E, 0xD39D}, //10120 #HANGUL SYLLABLE PHIEUPH E NIEUNCIEUC
  {0xBC6F, 0xD39E}, //10121 #HANGUL SYLLABLE PHIEUPH E NIEUNHIEUH
  {0xBC70, 0xD39F}, //10122 #HANGUL SYLLABLE PHIEUPH E TIKEUT
  {0xBC71, 0xD3A1}, //10123 #HANGUL SYLLABLE PHIEUPH E RIEULKIYEOK
  {0xBC72, 0xD3A2}, //10124 #HANGUL SYLLABLE PHIEUPH E RIEULMIEUM
  {0xBC73, 0xD3A3}, //10125 #HANGUL SYLLABLE PHIEUPH E RIEULPIEUP
  {0xBC74, 0xD3A4}, //10126 #HANGUL SYLLABLE PHIEUPH E RIEULSIOS
  {0xBC75, 0xD3A5}, //10127 #HANGUL SYLLABLE PHIEUPH E RIEULTHIEUTH
  {0xBC76, 0xD3A6}, //10128 #HANGUL SYLLABLE PHIEUPH E RIEULPHIEUPH
  {0xBC77, 0xD3A7}, //10129 #HANGUL SYLLABLE PHIEUPH E RIEULHIEUH
  {0xBC78, 0xD3AA}, //10130 #HANGUL SYLLABLE PHIEUPH E PIEUPSIOS
  {0xBC79, 0xD3AC}, //10131 #HANGUL SYLLABLE PHIEUPH E SSANGSIOS
  {0xBC7A, 0xD3AE}, //10132 #HANGUL SYLLABLE PHIEUPH E CIEUC
  {0xBC81, 0xD3AF}, //10133 #HANGUL SYLLABLE PHIEUPH E CHIEUCH
  {0xBC82, 0xD3B0}, //10134 #HANGUL SYLLABLE PHIEUPH E KHIEUKH
  {0xBC83, 0xD3B1}, //10135 #HANGUL SYLLABLE PHIEUPH E THIEUTH
  {0xBC84, 0xD3B2}, //10136 #HANGUL SYLLABLE PHIEUPH E PHIEUPH
  {0xBC85, 0xD3B3}, //10137 #HANGUL SYLLABLE PHIEUPH E HIEUH
  {0xBC86, 0xD3B5}, //10138 #HANGUL SYLLABLE PHIEUPH YEO KIYEOK
  {0xBC87, 0xD3B6}, //10139 #HANGUL SYLLABLE PHIEUPH YEO SSANGKIYEOK
  {0xBC88, 0xD3B7}, //10140 #HANGUL SYLLABLE PHIEUPH YEO KIYEOKSIOS
  {0xBC89, 0xD3B9}, //10141 #HANGUL SYLLABLE PHIEUPH YEO NIEUNCIEUC
  {0xBC8A, 0xD3BA}, //10142 #HANGUL SYLLABLE PHIEUPH YEO NIEUNHIEUH
  {0xBC8B, 0xD3BB}, //10143 #HANGUL SYLLABLE PHIEUPH YEO TIKEUT
  {0xBC8C, 0xD3BD}, //10144 #HANGUL SYLLABLE PHIEUPH YEO RIEULKIYEOK
  {0xBC8D, 0xD3BE}, //10145 #HANGUL SYLLABLE PHIEUPH YEO RIEULMIEUM
  {0xBC8E, 0xD3BF}, //10146 #HANGUL SYLLABLE PHIEUPH YEO RIEULPIEUP
  {0xBC8F, 0xD3C0}, //10147 #HANGUL SYLLABLE PHIEUPH YEO RIEULSIOS
  {0xBC90, 0xD3C1}, //10148 #HANGUL SYLLABLE PHIEUPH YEO RIEULTHIEUTH
  {0xBC91, 0xD3C2}, //10149 #HANGUL SYLLABLE PHIEUPH YEO RIEULPHIEUPH
  {0xBC92, 0xD3C3}, //10150 #HANGUL SYLLABLE PHIEUPH YEO RIEULHIEUH
  {0xBC93, 0xD3C6}, //10151 #HANGUL SYLLABLE PHIEUPH YEO PIEUPSIOS
  {0xBC94, 0xD3C7}, //10152 #HANGUL SYLLABLE PHIEUPH YEO SIOS
  {0xBC95, 0xD3CA}, //10153 #HANGUL SYLLABLE PHIEUPH YEO CIEUC
  {0xBC96, 0xD3CB}, //10154 #HANGUL SYLLABLE PHIEUPH YEO CHIEUCH
  {0xBC97, 0xD3CC}, //10155 #HANGUL SYLLABLE PHIEUPH YEO KHIEUKH
  {0xBC98, 0xD3CD}, //10156 #HANGUL SYLLABLE PHIEUPH YEO THIEUTH
  {0xBC99, 0xD3CE}, //10157 #HANGUL SYLLABLE PHIEUPH YEO PHIEUPH
  {0xBC9A, 0xD3CF}, //10158 #HANGUL SYLLABLE PHIEUPH YEO HIEUH
  {0xBC9B, 0xD3D1}, //10159 #HANGUL SYLLABLE PHIEUPH YE KIYEOK
  {0xBC9C, 0xD3D2}, //10160 #HANGUL SYLLABLE PHIEUPH YE SSANGKIYEOK
  {0xBC9D, 0xD3D3}, //10161 #HANGUL SYLLABLE PHIEUPH YE KIYEOKSIOS
  {0xBC9E, 0xD3D4}, //10162 #HANGUL SYLLABLE PHIEUPH YE NIEUN
  {0xBC9F, 0xD3D5}, //10163 #HANGUL SYLLABLE PHIEUPH YE NIEUNCIEUC
  {0xBCA0, 0xD3D6}, //10164 #HANGUL SYLLABLE PHIEUPH YE NIEUNHIEUH
  {0xBCA1, 0xC0E5}, //10165 #HANGUL SYLLABLE SIOS YA KIYEOK
  {0xBCA2, 0xC0E8}, //10166 #HANGUL SYLLABLE SIOS YA NIEUN
  {0xBCA3, 0xC0EC}, //10167 #HANGUL SYLLABLE SIOS YA RIEUL
  {0xBCA4, 0xC0F4}, //10168 #HANGUL SYLLABLE SIOS YA MIEUM
  {0xBCA5, 0xC0F5}, //10169 #HANGUL SYLLABLE SIOS YA PIEUP
  {0xBCA6, 0xC0F7}, //10170 #HANGUL SYLLABLE SIOS YA SIOS
  {0xBCA7, 0xC0F9}, //10171 #HANGUL SYLLABLE SIOS YA IEUNG
  {0xBCA8, 0xC100}, //10172 #HANGUL SYLLABLE SIOS YAE
  {0xBCA9, 0xC104}, //10173 #HANGUL SYLLABLE SIOS YAE NIEUN
  {0xBCAA, 0xC108}, //10174 #HANGUL SYLLABLE SIOS YAE RIEUL
  {0xBCAB, 0xC110}, //10175 #HANGUL SYLLABLE SIOS YAE MIEUM
  {0xBCAC, 0xC115}, //10176 #HANGUL SYLLABLE SIOS YAE IEUNG
  {0xBCAD, 0xC11C}, //10177 #HANGUL SYLLABLE SIOS EO
  {0xBCAE, 0xC11D}, //10178 #HANGUL SYLLABLE SIOS EO KIYEOK
  {0xBCAF, 0xC11E}, //10179 #HANGUL SYLLABLE SIOS EO SSANGKIYEOK
  {0xBCB0, 0xC11F}, //10180 #HANGUL SYLLABLE SIOS EO KIYEOKSIOS
  {0xBCB1, 0xC120}, //10181 #HANGUL SYLLABLE SIOS EO NIEUN
  {0xBCB2, 0xC123}, //10182 #HANGUL SYLLABLE SIOS EO TIKEUT
  {0xBCB3, 0xC124}, //10183 #HANGUL SYLLABLE SIOS EO RIEUL
  {0xBCB4, 0xC126}, //10184 #HANGUL SYLLABLE SIOS EO RIEULMIEUM
  {0xBCB5, 0xC127}, //10185 #HANGUL SYLLABLE SIOS EO RIEULPIEUP
  {0xBCB6, 0xC12C}, //10186 #HANGUL SYLLABLE SIOS EO MIEUM
  {0xBCB7, 0xC12D}, //10187 #HANGUL SYLLABLE SIOS EO PIEUP
  {0xBCB8, 0xC12F}, //10188 #HANGUL SYLLABLE SIOS EO SIOS
  {0xBCB9, 0xC130}, //10189 #HANGUL SYLLABLE SIOS EO SSANGSIOS
  {0xBCBA, 0xC131}, //10190 #HANGUL SYLLABLE SIOS EO IEUNG
  {0xBCBB, 0xC136}, //10191 #HANGUL SYLLABLE SIOS EO PHIEUPH
  {0xBCBC, 0xC138}, //10192 #HANGUL SYLLABLE SIOS E
  {0xBCBD, 0xC139}, //10193 #HANGUL SYLLABLE SIOS E KIYEOK
  {0xBCBE, 0xC13C}, //10194 #HANGUL SYLLABLE SIOS E NIEUN
  {0xBCBF, 0xC140}, //10195 #HANGUL SYLLABLE SIOS E RIEUL
  {0xBCC0, 0xC148}, //10196 #HANGUL SYLLABLE SIOS E MIEUM
  {0xBCC1, 0xC149}, //10197 #HANGUL SYLLABLE SIOS E PIEUP
  {0xBCC2, 0xC14B}, //10198 #HANGUL SYLLABLE SIOS E SIOS
  {0xBCC3, 0xC14C}, //10199 #HANGUL SYLLABLE SIOS E SSANGSIOS
  {0xBCC4, 0xC14D}, //10200 #HANGUL SYLLABLE SIOS E IEUNG
  {0xBCC5, 0xC154}, //10201 #HANGUL SYLLABLE SIOS YEO
  {0xBCC6, 0xC155}, //10202 #HANGUL SYLLABLE SIOS YEO KIYEOK
  {0xBCC7, 0xC158}, //10203 #HANGUL SYLLABLE SIOS YEO NIEUN
  {0xBCC8, 0xC15C}, //10204 #HANGUL SYLLABLE SIOS YEO RIEUL
  {0xBCC9, 0xC164}, //10205 #HANGUL SYLLABLE SIOS YEO MIEUM
  {0xBCCA, 0xC165}, //10206 #HANGUL SYLLABLE SIOS YEO PIEUP
  {0xBCCB, 0xC167}, //10207 #HANGUL SYLLABLE SIOS YEO SIOS
  {0xBCCC, 0xC168}, //10208 #HANGUL SYLLABLE SIOS YEO SSANGSIOS
  {0xBCCD, 0xC169}, //10209 #HANGUL SYLLABLE SIOS YEO IEUNG
  {0xBCCE, 0xC170}, //10210 #HANGUL SYLLABLE SIOS YE
  {0xBCCF, 0xC174}, //10211 #HANGUL SYLLABLE SIOS YE NIEUN
  {0xBCD0, 0xC178}, //10212 #HANGUL SYLLABLE SIOS YE RIEUL
  {0xBCD1, 0xC185}, //10213 #HANGUL SYLLABLE SIOS YE IEUNG
  {0xBCD2, 0xC18C}, //10214 #HANGUL SYLLABLE SIOS O
  {0xBCD3, 0xC18D}, //10215 #HANGUL SYLLABLE SIOS O KIYEOK
  {0xBCD4, 0xC18E}, //10216 #HANGUL SYLLABLE SIOS O SSANGKIYEOK
  {0xBCD5, 0xC190}, //10217 #HANGUL SYLLABLE SIOS O NIEUN
  {0xBCD6, 0xC194}, //10218 #HANGUL SYLLABLE SIOS O RIEUL
  {0xBCD7, 0xC196}, //10219 #HANGUL SYLLABLE SIOS O RIEULMIEUM
  {0xBCD8, 0xC19C}, //10220 #HANGUL SYLLABLE SIOS O MIEUM
  {0xBCD9, 0xC19D}, //10221 #HANGUL SYLLABLE SIOS O PIEUP
  {0xBCDA, 0xC19F}, //10222 #HANGUL SYLLABLE SIOS O SIOS
  {0xBCDB, 0xC1A1}, //10223 #HANGUL SYLLABLE SIOS O IEUNG
  {0xBCDC, 0xC1A5}, //10224 #HANGUL SYLLABLE SIOS O THIEUTH
  {0xBCDD, 0xC1A8}, //10225 #HANGUL SYLLABLE SIOS WA
  {0xBCDE, 0xC1A9}, //10226 #HANGUL SYLLABLE SIOS WA KIYEOK
  {0xBCDF, 0xC1AC}, //10227 #HANGUL SYLLABLE SIOS WA NIEUN
  {0xBCE0, 0xC1B0}, //10228 #HANGUL SYLLABLE SIOS WA RIEUL
  {0xBCE1, 0xC1BD}, //10229 #HANGUL SYLLABLE SIOS WA IEUNG
  {0xBCE2, 0xC1C4}, //10230 #HANGUL SYLLABLE SIOS WAE
  {0xBCE3, 0xC1C8}, //10231 #HANGUL SYLLABLE SIOS WAE NIEUN
  {0xBCE4, 0xC1CC}, //10232 #HANGUL SYLLABLE SIOS WAE RIEUL
  {0xBCE5, 0xC1D4}, //10233 #HANGUL SYLLABLE SIOS WAE MIEUM
  {0xBCE6, 0xC1D7}, //10234 #HANGUL SYLLABLE SIOS WAE SIOS
  {0xBCE7, 0xC1D8}, //10235 #HANGUL SYLLABLE SIOS WAE SSANGSIOS
  {0xBCE8, 0xC1E0}, //10236 #HANGUL SYLLABLE SIOS OE
  {0xBCE9, 0xC1E4}, //10237 #HANGUL SYLLABLE SIOS OE NIEUN
  {0xBCEA, 0xC1E8}, //10238 #HANGUL SYLLABLE SIOS OE RIEUL
  {0xBCEB, 0xC1F0}, //10239 #HANGUL SYLLABLE SIOS OE MIEUM
  {0xBCEC, 0xC1F1}, //10240 #HANGUL SYLLABLE SIOS OE PIEUP
  {0xBCED, 0xC1F3}, //10241 #HANGUL SYLLABLE SIOS OE SIOS
  {0xBCEE, 0xC1FC}, //10242 #HANGUL SYLLABLE SIOS YO
  {0xBCEF, 0xC1FD}, //10243 #HANGUL SYLLABLE SIOS YO KIYEOK
  {0xBCF0, 0xC200}, //10244 #HANGUL SYLLABLE SIOS YO NIEUN
  {0xBCF1, 0xC204}, //10245 #HANGUL SYLLABLE SIOS YO RIEUL
  {0xBCF2, 0xC20C}, //10246 #HANGUL SYLLABLE SIOS YO MIEUM
  {0xBCF3, 0xC20D}, //10247 #HANGUL SYLLABLE SIOS YO PIEUP
  {0xBCF4, 0xC20F}, //10248 #HANGUL SYLLABLE SIOS YO SIOS
  {0xBCF5, 0xC211}, //10249 #HANGUL SYLLABLE SIOS YO IEUNG
  {0xBCF6, 0xC218}, //10250 #HANGUL SYLLABLE SIOS U
  {0xBCF7, 0xC219}, //10251 #HANGUL SYLLABLE SIOS U KIYEOK
  {0xBCF8, 0xC21C}, //10252 #HANGUL SYLLABLE SIOS U NIEUN
  {0xBCF9, 0xC21F}, //10253 #HANGUL SYLLABLE SIOS U TIKEUT
  {0xBCFA, 0xC220}, //10254 #HANGUL SYLLABLE SIOS U RIEUL
  {0xBCFB, 0xC228}, //10255 #HANGUL SYLLABLE SIOS U MIEUM
  {0xBCFC, 0xC229}, //10256 #HANGUL SYLLABLE SIOS U PIEUP
  {0xBCFD, 0xC22B}, //10257 #HANGUL SYLLABLE SIOS U SIOS
  {0xBCFE, 0xC22D}, //10258 #HANGUL SYLLABLE SIOS U IEUNG
  {0xBD41, 0xD3D7}, //10259 #HANGUL SYLLABLE PHIEUPH YE TIKEUT
  {0xBD42, 0xD3D9}, //10260 #HANGUL SYLLABLE PHIEUPH YE RIEULKIYEOK
  {0xBD43, 0xD3DA}, //10261 #HANGUL SYLLABLE PHIEUPH YE RIEULMIEUM
  {0xBD44, 0xD3DB}, //10262 #HANGUL SYLLABLE PHIEUPH YE RIEULPIEUP
  {0xBD45, 0xD3DC}, //10263 #HANGUL SYLLABLE PHIEUPH YE RIEULSIOS
  {0xBD46, 0xD3DD}, //10264 #HANGUL SYLLABLE PHIEUPH YE RIEULTHIEUTH
  {0xBD47, 0xD3DE}, //10265 #HANGUL SYLLABLE PHIEUPH YE RIEULPHIEUPH
  {0xBD48, 0xD3DF}, //10266 #HANGUL SYLLABLE PHIEUPH YE RIEULHIEUH
  {0xBD49, 0xD3E0}, //10267 #HANGUL SYLLABLE PHIEUPH YE MIEUM
  {0xBD4A, 0xD3E2}, //10268 #HANGUL SYLLABLE PHIEUPH YE PIEUPSIOS
  {0xBD4B, 0xD3E4}, //10269 #HANGUL SYLLABLE PHIEUPH YE SSANGSIOS
  {0xBD4C, 0xD3E5}, //10270 #HANGUL SYLLABLE PHIEUPH YE IEUNG
  {0xBD4D, 0xD3E6}, //10271 #HANGUL SYLLABLE PHIEUPH YE CIEUC
  {0xBD4E, 0xD3E7}, //10272 #HANGUL SYLLABLE PHIEUPH YE CHIEUCH
  {0xBD4F, 0xD3E8}, //10273 #HANGUL SYLLABLE PHIEUPH YE KHIEUKH
  {0xBD50, 0xD3E9}, //10274 #HANGUL SYLLABLE PHIEUPH YE THIEUTH
  {0xBD51, 0xD3EA}, //10275 #HANGUL SYLLABLE PHIEUPH YE PHIEUPH
  {0xBD52, 0xD3EB}, //10276 #HANGUL SYLLABLE PHIEUPH YE HIEUH
  {0xBD53, 0xD3EE}, //10277 #HANGUL SYLLABLE PHIEUPH O SSANGKIYEOK
  {0xBD54, 0xD3EF}, //10278 #HANGUL SYLLABLE PHIEUPH O KIYEOKSIOS
  {0xBD55, 0xD3F1}, //10279 #HANGUL SYLLABLE PHIEUPH O NIEUNCIEUC
  {0xBD56, 0xD3F2}, //10280 #HANGUL SYLLABLE PHIEUPH O NIEUNHIEUH
  {0xBD57, 0xD3F3}, //10281 #HANGUL SYLLABLE PHIEUPH O TIKEUT
  {0xBD58, 0xD3F5}, //10282 #HANGUL SYLLABLE PHIEUPH O RIEULKIYEOK
  {0xBD59, 0xD3F6}, //10283 #HANGUL SYLLABLE PHIEUPH O RIEULMIEUM
  {0xBD5A, 0xD3F7}, //10284 #HANGUL SYLLABLE PHIEUPH O RIEULPIEUP
  {0xBD61, 0xD3F8}, //10285 #HANGUL SYLLABLE PHIEUPH O RIEULSIOS
  {0xBD62, 0xD3F9}, //10286 #HANGUL SYLLABLE PHIEUPH O RIEULTHIEUTH
  {0xBD63, 0xD3FA}, //10287 #HANGUL SYLLABLE PHIEUPH O RIEULPHIEUPH
  {0xBD64, 0xD3FB}, //10288 #HANGUL SYLLABLE PHIEUPH O RIEULHIEUH
  {0xBD65, 0xD3FE}, //10289 #HANGUL SYLLABLE PHIEUPH O PIEUPSIOS
  {0xBD66, 0xD400}, //10290 #HANGUL SYLLABLE PHIEUPH O SSANGSIOS
  {0xBD67, 0xD402}, //10291 #HANGUL SYLLABLE PHIEUPH O CIEUC
  {0xBD68, 0xD403}, //10292 #HANGUL SYLLABLE PHIEUPH O CHIEUCH
  {0xBD69, 0xD404}, //10293 #HANGUL SYLLABLE PHIEUPH O KHIEUKH
  {0xBD6A, 0xD405}, //10294 #HANGUL SYLLABLE PHIEUPH O THIEUTH
  {0xBD6B, 0xD406}, //10295 #HANGUL SYLLABLE PHIEUPH O PHIEUPH
  {0xBD6C, 0xD407}, //10296 #HANGUL SYLLABLE PHIEUPH O HIEUH
  {0xBD6D, 0xD409}, //10297 #HANGUL SYLLABLE PHIEUPH WA KIYEOK
  {0xBD6E, 0xD40A}, //10298 #HANGUL SYLLABLE PHIEUPH WA SSANGKIYEOK
  {0xBD6F, 0xD40B}, //10299 #HANGUL SYLLABLE PHIEUPH WA KIYEOKSIOS
  {0xBD70, 0xD40C}, //10300 #HANGUL SYLLABLE PHIEUPH WA NIEUN
  {0xBD71, 0xD40D}, //10301 #HANGUL SYLLABLE PHIEUPH WA NIEUNCIEUC
  {0xBD72, 0xD40E}, //10302 #HANGUL SYLLABLE PHIEUPH WA NIEUNHIEUH
  {0xBD73, 0xD40F}, //10303 #HANGUL SYLLABLE PHIEUPH WA TIKEUT
  {0xBD74, 0xD410}, //10304 #HANGUL SYLLABLE PHIEUPH WA RIEUL
  {0xBD75, 0xD411}, //10305 #HANGUL SYLLABLE PHIEUPH WA RIEULKIYEOK
  {0xBD76, 0xD412}, //10306 #HANGUL SYLLABLE PHIEUPH WA RIEULMIEUM
  {0xBD77, 0xD413}, //10307 #HANGUL SYLLABLE PHIEUPH WA RIEULPIEUP
  {0xBD78, 0xD414}, //10308 #HANGUL SYLLABLE PHIEUPH WA RIEULSIOS
  {0xBD79, 0xD415}, //10309 #HANGUL SYLLABLE PHIEUPH WA RIEULTHIEUTH
  {0xBD7A, 0xD416}, //10310 #HANGUL SYLLABLE PHIEUPH WA RIEULPHIEUPH
  {0xBD81, 0xD417}, //10311 #HANGUL SYLLABLE PHIEUPH WA RIEULHIEUH
  {0xBD82, 0xD418}, //10312 #HANGUL SYLLABLE PHIEUPH WA MIEUM
  {0xBD83, 0xD419}, //10313 #HANGUL SYLLABLE PHIEUPH WA PIEUP
  {0xBD84, 0xD41A}, //10314 #HANGUL SYLLABLE PHIEUPH WA PIEUPSIOS
  {0xBD85, 0xD41B}, //10315 #HANGUL SYLLABLE PHIEUPH WA SIOS
  {0xBD86, 0xD41C}, //10316 #HANGUL SYLLABLE PHIEUPH WA SSANGSIOS
  {0xBD87, 0xD41E}, //10317 #HANGUL SYLLABLE PHIEUPH WA CIEUC
  {0xBD88, 0xD41F}, //10318 #HANGUL SYLLABLE PHIEUPH WA CHIEUCH
  {0xBD89, 0xD420}, //10319 #HANGUL SYLLABLE PHIEUPH WA KHIEUKH
  {0xBD8A, 0xD421}, //10320 #HANGUL SYLLABLE PHIEUPH WA THIEUTH
  {0xBD8B, 0xD422}, //10321 #HANGUL SYLLABLE PHIEUPH WA PHIEUPH
  {0xBD8C, 0xD423}, //10322 #HANGUL SYLLABLE PHIEUPH WA HIEUH
  {0xBD8D, 0xD424}, //10323 #HANGUL SYLLABLE PHIEUPH WAE
  {0xBD8E, 0xD425}, //10324 #HANGUL SYLLABLE PHIEUPH WAE KIYEOK
  {0xBD8F, 0xD426}, //10325 #HANGUL SYLLABLE PHIEUPH WAE SSANGKIYEOK
  {0xBD90, 0xD427}, //10326 #HANGUL SYLLABLE PHIEUPH WAE KIYEOKSIOS
  {0xBD91, 0xD428}, //10327 #HANGUL SYLLABLE PHIEUPH WAE NIEUN
  {0xBD92, 0xD429}, //10328 #HANGUL SYLLABLE PHIEUPH WAE NIEUNCIEUC
  {0xBD93, 0xD42A}, //10329 #HANGUL SYLLABLE PHIEUPH WAE NIEUNHIEUH
  {0xBD94, 0xD42B}, //10330 #HANGUL SYLLABLE PHIEUPH WAE TIKEUT
  {0xBD95, 0xD42C}, //10331 #HANGUL SYLLABLE PHIEUPH WAE RIEUL
  {0xBD96, 0xD42D}, //10332 #HANGUL SYLLABLE PHIEUPH WAE RIEULKIYEOK
  {0xBD97, 0xD42E}, //10333 #HANGUL SYLLABLE PHIEUPH WAE RIEULMIEUM
  {0xBD98, 0xD42F}, //10334 #HANGUL SYLLABLE PHIEUPH WAE RIEULPIEUP
  {0xBD99, 0xD430}, //10335 #HANGUL SYLLABLE PHIEUPH WAE RIEULSIOS
  {0xBD9A, 0xD431}, //10336 #HANGUL SYLLABLE PHIEUPH WAE RIEULTHIEUTH
  {0xBD9B, 0xD432}, //10337 #HANGUL SYLLABLE PHIEUPH WAE RIEULPHIEUPH
  {0xBD9C, 0xD433}, //10338 #HANGUL SYLLABLE PHIEUPH WAE RIEULHIEUH
  {0xBD9D, 0xD434}, //10339 #HANGUL SYLLABLE PHIEUPH WAE MIEUM
  {0xBD9E, 0xD435}, //10340 #HANGUL SYLLABLE PHIEUPH WAE PIEUP
  {0xBD9F, 0xD436}, //10341 #HANGUL SYLLABLE PHIEUPH WAE PIEUPSIOS
  {0xBDA0, 0xD437}, //10342 #HANGUL SYLLABLE PHIEUPH WAE SIOS
  {0xBDA1, 0xC22F}, //10343 #HANGUL SYLLABLE SIOS U CHIEUCH
  {0xBDA2, 0xC231}, //10344 #HANGUL SYLLABLE SIOS U THIEUTH
  {0xBDA3, 0xC232}, //10345 #HANGUL SYLLABLE SIOS U PHIEUPH
  {0xBDA4, 0xC234}, //10346 #HANGUL SYLLABLE SIOS WEO
  {0xBDA5, 0xC248}, //10347 #HANGUL SYLLABLE SIOS WEO SSANGSIOS
  {0xBDA6, 0xC250}, //10348 #HANGUL SYLLABLE SIOS WE
  {0xBDA7, 0xC251}, //10349 #HANGUL SYLLABLE SIOS WE KIYEOK
  {0xBDA8, 0xC254}, //10350 #HANGUL SYLLABLE SIOS WE NIEUN
  {0xBDA9, 0xC258}, //10351 #HANGUL SYLLABLE SIOS WE RIEUL
  {0xBDAA, 0xC260}, //10352 #HANGUL SYLLABLE SIOS WE MIEUM
  {0xBDAB, 0xC265}, //10353 #HANGUL SYLLABLE SIOS WE IEUNG
  {0xBDAC, 0xC26C}, //10354 #HANGUL SYLLABLE SIOS WI
  {0xBDAD, 0xC26D}, //10355 #HANGUL SYLLABLE SIOS WI KIYEOK
  {0xBDAE, 0xC270}, //10356 #HANGUL SYLLABLE SIOS WI NIEUN
  {0xBDAF, 0xC274}, //10357 #HANGUL SYLLABLE SIOS WI RIEUL
  {0xBDB0, 0xC27C}, //10358 #HANGUL SYLLABLE SIOS WI MIEUM
  {0xBDB1, 0xC27D}, //10359 #HANGUL SYLLABLE SIOS WI PIEUP
  {0xBDB2, 0xC27F}, //10360 #HANGUL SYLLABLE SIOS WI SIOS
  {0xBDB3, 0xC281}, //10361 #HANGUL SYLLABLE SIOS WI IEUNG
  {0xBDB4, 0xC288}, //10362 #HANGUL SYLLABLE SIOS YU
  {0xBDB5, 0xC289}, //10363 #HANGUL SYLLABLE SIOS YU KIYEOK
  {0xBDB6, 0xC290}, //10364 #HANGUL SYLLABLE SIOS YU RIEUL
  {0xBDB7, 0xC298}, //10365 #HANGUL SYLLABLE SIOS YU MIEUM
  {0xBDB8, 0xC29B}, //10366 #HANGUL SYLLABLE SIOS YU SIOS
  {0xBDB9, 0xC29D}, //10367 #HANGUL SYLLABLE SIOS YU IEUNG
  {0xBDBA, 0xC2A4}, //10368 #HANGUL SYLLABLE SIOS EU
  {0xBDBB, 0xC2A5}, //10369 #HANGUL SYLLABLE SIOS EU KIYEOK
  {0xBDBC, 0xC2A8}, //10370 #HANGUL SYLLABLE SIOS EU NIEUN
  {0xBDBD, 0xC2AC}, //10371 #HANGUL SYLLABLE SIOS EU RIEUL
  {0xBDBE, 0xC2AD}, //10372 #HANGUL SYLLABLE SIOS EU RIEULKIYEOK
  {0xBDBF, 0xC2B4}, //10373 #HANGUL SYLLABLE SIOS EU MIEUM
  {0xBDC0, 0xC2B5}, //10374 #HANGUL SYLLABLE SIOS EU PIEUP
  {0xBDC1, 0xC2B7}, //10375 #HANGUL SYLLABLE SIOS EU SIOS
  {0xBDC2, 0xC2B9}, //10376 #HANGUL SYLLABLE SIOS EU IEUNG
  {0xBDC3, 0xC2DC}, //10377 #HANGUL SYLLABLE SIOS I
  {0xBDC4, 0xC2DD}, //10378 #HANGUL SYLLABLE SIOS I KIYEOK
  {0xBDC5, 0xC2E0}, //10379 #HANGUL SYLLABLE SIOS I NIEUN
  {0xBDC6, 0xC2E3}, //10380 #HANGUL SYLLABLE SIOS I TIKEUT
  {0xBDC7, 0xC2E4}, //10381 #HANGUL SYLLABLE SIOS I RIEUL
  {0xBDC8, 0xC2EB}, //10382 #HANGUL SYLLABLE SIOS I RIEULHIEUH
  {0xBDC9, 0xC2EC}, //10383 #HANGUL SYLLABLE SIOS I MIEUM
  {0xBDCA, 0xC2ED}, //10384 #HANGUL SYLLABLE SIOS I PIEUP
  {0xBDCB, 0xC2EF}, //10385 #HANGUL SYLLABLE SIOS I SIOS
  {0xBDCC, 0xC2F1}, //10386 #HANGUL SYLLABLE SIOS I IEUNG
  {0xBDCD, 0xC2F6}, //10387 #HANGUL SYLLABLE SIOS I PHIEUPH
  {0xBDCE, 0xC2F8}, //10388 #HANGUL SYLLABLE SSANGSIOS A
  {0xBDCF, 0xC2F9}, //10389 #HANGUL SYLLABLE SSANGSIOS A KIYEOK
  {0xBDD0, 0xC2FB}, //10390 #HANGUL SYLLABLE SSANGSIOS A KIYEOKSIOS
  {0xBDD1, 0xC2FC}, //10391 #HANGUL SYLLABLE SSANGSIOS A NIEUN
  {0xBDD2, 0xC300}, //10392 #HANGUL SYLLABLE SSANGSIOS A RIEUL
  {0xBDD3, 0xC308}, //10393 #HANGUL SYLLABLE SSANGSIOS A MIEUM
  {0xBDD4, 0xC309}, //10394 #HANGUL SYLLABLE SSANGSIOS A PIEUP
  {0xBDD5, 0xC30C}, //10395 #HANGUL SYLLABLE SSANGSIOS A SSANGSIOS
  {0xBDD6, 0xC30D}, //10396 #HANGUL SYLLABLE SSANGSIOS A IEUNG
  {0xBDD7, 0xC313}, //10397 #HANGUL SYLLABLE SSANGSIOS A HIEUH
  {0xBDD8, 0xC314}, //10398 #HANGUL SYLLABLE SSANGSIOS AE
  {0xBDD9, 0xC315}, //10399 #HANGUL SYLLABLE SSANGSIOS AE KIYEOK
  {0xBDDA, 0xC318}, //10400 #HANGUL SYLLABLE SSANGSIOS AE NIEUN
  {0xBDDB, 0xC31C}, //10401 #HANGUL SYLLABLE SSANGSIOS AE RIEUL
  {0xBDDC, 0xC324}, //10402 #HANGUL SYLLABLE SSANGSIOS AE MIEUM
  {0xBDDD, 0xC325}, //10403 #HANGUL SYLLABLE SSANGSIOS AE PIEUP
  {0xBDDE, 0xC328}, //10404 #HANGUL SYLLABLE SSANGSIOS AE SSANGSIOS
  {0xBDDF, 0xC329}, //10405 #HANGUL SYLLABLE SSANGSIOS AE IEUNG
  {0xBDE0, 0xC345}, //10406 #HANGUL SYLLABLE SSANGSIOS YA IEUNG
  {0xBDE1, 0xC368}, //10407 #HANGUL SYLLABLE SSANGSIOS EO
  {0xBDE2, 0xC369}, //10408 #HANGUL SYLLABLE SSANGSIOS EO KIYEOK
  {0xBDE3, 0xC36C}, //10409 #HANGUL SYLLABLE SSANGSIOS EO NIEUN
  {0xBDE4, 0xC370}, //10410 #HANGUL SYLLABLE SSANGSIOS EO RIEUL
  {0xBDE5, 0xC372}, //10411 #HANGUL SYLLABLE SSANGSIOS EO RIEULMIEUM
  {0xBDE6, 0xC378}, //10412 #HANGUL SYLLABLE SSANGSIOS EO MIEUM
  {0xBDE7, 0xC379}, //10413 #HANGUL SYLLABLE SSANGSIOS EO PIEUP
  {0xBDE8, 0xC37C}, //10414 #HANGUL SYLLABLE SSANGSIOS EO SSANGSIOS
  {0xBDE9, 0xC37D}, //10415 #HANGUL SYLLABLE SSANGSIOS EO IEUNG
  {0xBDEA, 0xC384}, //10416 #HANGUL SYLLABLE SSANGSIOS E
  {0xBDEB, 0xC388}, //10417 #HANGUL SYLLABLE SSANGSIOS E NIEUN
  {0xBDEC, 0xC38C}, //10418 #HANGUL SYLLABLE SSANGSIOS E RIEUL
  {0xBDED, 0xC3C0}, //10419 #HANGUL SYLLABLE SSANGSIOS YE NIEUN
  {0xBDEE, 0xC3D8}, //10420 #HANGUL SYLLABLE SSANGSIOS O
  {0xBDEF, 0xC3D9}, //10421 #HANGUL SYLLABLE SSANGSIOS O KIYEOK
  {0xBDF0, 0xC3DC}, //10422 #HANGUL SYLLABLE SSANGSIOS O NIEUN
  {0xBDF1, 0xC3DF}, //10423 #HANGUL SYLLABLE SSANGSIOS O TIKEUT
  {0xBDF2, 0xC3E0}, //10424 #HANGUL SYLLABLE SSANGSIOS O RIEUL
  {0xBDF3, 0xC3E2}, //10425 #HANGUL SYLLABLE SSANGSIOS O RIEULMIEUM
  {0xBDF4, 0xC3E8}, //10426 #HANGUL SYLLABLE SSANGSIOS O MIEUM
  {0xBDF5, 0xC3E9}, //10427 #HANGUL SYLLABLE SSANGSIOS O PIEUP
  {0xBDF6, 0xC3ED}, //10428 #HANGUL SYLLABLE SSANGSIOS O IEUNG
  {0xBDF7, 0xC3F4}, //10429 #HANGUL SYLLABLE SSANGSIOS WA
  {0xBDF8, 0xC3F5}, //10430 #HANGUL SYLLABLE SSANGSIOS WA KIYEOK
  {0xBDF9, 0xC3F8}, //10431 #HANGUL SYLLABLE SSANGSIOS WA NIEUN
  {0xBDFA, 0xC408}, //10432 #HANGUL SYLLABLE SSANGSIOS WA SSANGSIOS
  {0xBDFB, 0xC410}, //10433 #HANGUL SYLLABLE SSANGSIOS WAE
  {0xBDFC, 0xC424}, //10434 #HANGUL SYLLABLE SSANGSIOS WAE SSANGSIOS
  {0xBDFD, 0xC42C}, //10435 #HANGUL SYLLABLE SSANGSIOS OE
  {0xBDFE, 0xC430}, //10436 #HANGUL SYLLABLE SSANGSIOS OE NIEUN
  {0xBE41, 0xD438}, //10437 #HANGUL SYLLABLE PHIEUPH WAE SSANGSIOS
  {0xBE42, 0xD439}, //10438 #HANGUL SYLLABLE PHIEUPH WAE IEUNG
  {0xBE43, 0xD43A}, //10439 #HANGUL SYLLABLE PHIEUPH WAE CIEUC
  {0xBE44, 0xD43B}, //10440 #HANGUL SYLLABLE PHIEUPH WAE CHIEUCH
  {0xBE45, 0xD43C}, //10441 #HANGUL SYLLABLE PHIEUPH WAE KHIEUKH
  {0xBE46, 0xD43D}, //10442 #HANGUL SYLLABLE PHIEUPH WAE THIEUTH
  {0xBE47, 0xD43E}, //10443 #HANGUL SYLLABLE PHIEUPH WAE PHIEUPH
  {0xBE48, 0xD43F}, //10444 #HANGUL SYLLABLE PHIEUPH WAE HIEUH
  {0xBE49, 0xD441}, //10445 #HANGUL SYLLABLE PHIEUPH OE KIYEOK
  {0xBE4A, 0xD442}, //10446 #HANGUL SYLLABLE PHIEUPH OE SSANGKIYEOK
  {0xBE4B, 0xD443}, //10447 #HANGUL SYLLABLE PHIEUPH OE KIYEOKSIOS
  {0xBE4C, 0xD445}, //10448 #HANGUL SYLLABLE PHIEUPH OE NIEUNCIEUC
  {0xBE4D, 0xD446}, //10449 #HANGUL SYLLABLE PHIEUPH OE NIEUNHIEUH
  {0xBE4E, 0xD447}, //10450 #HANGUL SYLLABLE PHIEUPH OE TIKEUT
  {0xBE4F, 0xD448}, //10451 #HANGUL SYLLABLE PHIEUPH OE RIEUL
  {0xBE50, 0xD449}, //10452 #HANGUL SYLLABLE PHIEUPH OE RIEULKIYEOK
  {0xBE51, 0xD44A}, //10453 #HANGUL SYLLABLE PHIEUPH OE RIEULMIEUM
  {0xBE52, 0xD44B}, //10454 #HANGUL SYLLABLE PHIEUPH OE RIEULPIEUP
  {0xBE53, 0xD44C}, //10455 #HANGUL SYLLABLE PHIEUPH OE RIEULSIOS
  {0xBE54, 0xD44D}, //10456 #HANGUL SYLLABLE PHIEUPH OE RIEULTHIEUTH
  {0xBE55, 0xD44E}, //10457 #HANGUL SYLLABLE PHIEUPH OE RIEULPHIEUPH
  {0xBE56, 0xD44F}, //10458 #HANGUL SYLLABLE PHIEUPH OE RIEULHIEUH
  {0xBE57, 0xD450}, //10459 #HANGUL SYLLABLE PHIEUPH OE MIEUM
  {0xBE58, 0xD451}, //10460 #HANGUL SYLLABLE PHIEUPH OE PIEUP
  {0xBE59, 0xD452}, //10461 #HANGUL SYLLABLE PHIEUPH OE PIEUPSIOS
  {0xBE5A, 0xD453}, //10462 #HANGUL SYLLABLE PHIEUPH OE SIOS
  {0xBE61, 0xD454}, //10463 #HANGUL SYLLABLE PHIEUPH OE SSANGSIOS
  {0xBE62, 0xD455}, //10464 #HANGUL SYLLABLE PHIEUPH OE IEUNG
  {0xBE63, 0xD456}, //10465 #HANGUL SYLLABLE PHIEUPH OE CIEUC
  {0xBE64, 0xD457}, //10466 #HANGUL SYLLABLE PHIEUPH OE CHIEUCH
  {0xBE65, 0xD458}, //10467 #HANGUL SYLLABLE PHIEUPH OE KHIEUKH
  {0xBE66, 0xD459}, //10468 #HANGUL SYLLABLE PHIEUPH OE THIEUTH
  {0xBE67, 0xD45A}, //10469 #HANGUL SYLLABLE PHIEUPH OE PHIEUPH
  {0xBE68, 0xD45B}, //10470 #HANGUL SYLLABLE PHIEUPH OE HIEUH
  {0xBE69, 0xD45D}, //10471 #HANGUL SYLLABLE PHIEUPH YO KIYEOK
  {0xBE6A, 0xD45E}, //10472 #HANGUL SYLLABLE PHIEUPH YO SSANGKIYEOK
  {0xBE6B, 0xD45F}, //10473 #HANGUL SYLLABLE PHIEUPH YO KIYEOKSIOS
  {0xBE6C, 0xD461}, //10474 #HANGUL SYLLABLE PHIEUPH YO NIEUNCIEUC
  {0xBE6D, 0xD462}, //10475 #HANGUL SYLLABLE PHIEUPH YO NIEUNHIEUH
  {0xBE6E, 0xD463}, //10476 #HANGUL SYLLABLE PHIEUPH YO TIKEUT
  {0xBE6F, 0xD465}, //10477 #HANGUL SYLLABLE PHIEUPH YO RIEULKIYEOK
  {0xBE70, 0xD466}, //10478 #HANGUL SYLLABLE PHIEUPH YO RIEULMIEUM
  {0xBE71, 0xD467}, //10479 #HANGUL SYLLABLE PHIEUPH YO RIEULPIEUP
  {0xBE72, 0xD468}, //10480 #HANGUL SYLLABLE PHIEUPH YO RIEULSIOS
  {0xBE73, 0xD469}, //10481 #HANGUL SYLLABLE PHIEUPH YO RIEULTHIEUTH
  {0xBE74, 0xD46A}, //10482 #HANGUL SYLLABLE PHIEUPH YO RIEULPHIEUPH
  {0xBE75, 0xD46B}, //10483 #HANGUL SYLLABLE PHIEUPH YO RIEULHIEUH
  {0xBE76, 0xD46C}, //10484 #HANGUL SYLLABLE PHIEUPH YO MIEUM
  {0xBE77, 0xD46E}, //10485 #HANGUL SYLLABLE PHIEUPH YO PIEUPSIOS
  {0xBE78, 0xD470}, //10486 #HANGUL SYLLABLE PHIEUPH YO SSANGSIOS
  {0xBE79, 0xD471}, //10487 #HANGUL SYLLABLE PHIEUPH YO IEUNG
  {0xBE7A, 0xD472}, //10488 #HANGUL SYLLABLE PHIEUPH YO CIEUC
  {0xBE81, 0xD473}, //10489 #HANGUL SYLLABLE PHIEUPH YO CHIEUCH
  {0xBE82, 0xD474}, //10490 #HANGUL SYLLABLE PHIEUPH YO KHIEUKH
  {0xBE83, 0xD475}, //10491 #HANGUL SYLLABLE PHIEUPH YO THIEUTH
  {0xBE84, 0xD476}, //10492 #HANGUL SYLLABLE PHIEUPH YO PHIEUPH
  {0xBE85, 0xD477}, //10493 #HANGUL SYLLABLE PHIEUPH YO HIEUH
  {0xBE86, 0xD47A}, //10494 #HANGUL SYLLABLE PHIEUPH U SSANGKIYEOK
  {0xBE87, 0xD47B}, //10495 #HANGUL SYLLABLE PHIEUPH U KIYEOKSIOS
  {0xBE88, 0xD47D}, //10496 #HANGUL SYLLABLE PHIEUPH U NIEUNCIEUC
  {0xBE89, 0xD47E}, //10497 #HANGUL SYLLABLE PHIEUPH U NIEUNHIEUH
  {0xBE8A, 0xD481}, //10498 #HANGUL SYLLABLE PHIEUPH U RIEULKIYEOK
  {0xBE8B, 0xD483}, //10499 #HANGUL SYLLABLE PHIEUPH U RIEULPIEUP
  {0xBE8C, 0xD484}, //10500 #HANGUL SYLLABLE PHIEUPH U RIEULSIOS
  {0xBE8D, 0xD485}, //10501 #HANGUL SYLLABLE PHIEUPH U RIEULTHIEUTH
  {0xBE8E, 0xD486}, //10502 #HANGUL SYLLABLE PHIEUPH U RIEULPHIEUPH
  {0xBE8F, 0xD487}, //10503 #HANGUL SYLLABLE PHIEUPH U RIEULHIEUH
  {0xBE90, 0xD48A}, //10504 #HANGUL SYLLABLE PHIEUPH U PIEUPSIOS
  {0xBE91, 0xD48C}, //10505 #HANGUL SYLLABLE PHIEUPH U SSANGSIOS
  {0xBE92, 0xD48E}, //10506 #HANGUL SYLLABLE PHIEUPH U CIEUC
  {0xBE93, 0xD48F}, //10507 #HANGUL SYLLABLE PHIEUPH U CHIEUCH
  {0xBE94, 0xD490}, //10508 #HANGUL SYLLABLE PHIEUPH U KHIEUKH
  {0xBE95, 0xD491}, //10509 #HANGUL SYLLABLE PHIEUPH U THIEUTH
  {0xBE96, 0xD492}, //10510 #HANGUL SYLLABLE PHIEUPH U PHIEUPH
  {0xBE97, 0xD493}, //10511 #HANGUL SYLLABLE PHIEUPH U HIEUH
  {0xBE98, 0xD495}, //10512 #HANGUL SYLLABLE PHIEUPH WEO KIYEOK
  {0xBE99, 0xD496}, //10513 #HANGUL SYLLABLE PHIEUPH WEO SSANGKIYEOK
  {0xBE9A, 0xD497}, //10514 #HANGUL SYLLABLE PHIEUPH WEO KIYEOKSIOS
  {0xBE9B, 0xD498}, //10515 #HANGUL SYLLABLE PHIEUPH WEO NIEUN
  {0xBE9C, 0xD499}, //10516 #HANGUL SYLLABLE PHIEUPH WEO NIEUNCIEUC
  {0xBE9D, 0xD49A}, //10517 #HANGUL SYLLABLE PHIEUPH WEO NIEUNHIEUH
  {0xBE9E, 0xD49B}, //10518 #HANGUL SYLLABLE PHIEUPH WEO TIKEUT
  {0xBE9F, 0xD49C}, //10519 #HANGUL SYLLABLE PHIEUPH WEO RIEUL
  {0xBEA0, 0xD49D}, //10520 #HANGUL SYLLABLE PHIEUPH WEO RIEULKIYEOK
  {0xBEA1, 0xC434}, //10521 #HANGUL SYLLABLE SSANGSIOS OE RIEUL
  {0xBEA2, 0xC43C}, //10522 #HANGUL SYLLABLE SSANGSIOS OE MIEUM
  {0xBEA3, 0xC43D}, //10523 #HANGUL SYLLABLE SSANGSIOS OE PIEUP
  {0xBEA4, 0xC448}, //10524 #HANGUL SYLLABLE SSANGSIOS YO
  {0xBEA5, 0xC464}, //10525 #HANGUL SYLLABLE SSANGSIOS U
  {0xBEA6, 0xC465}, //10526 #HANGUL SYLLABLE SSANGSIOS U KIYEOK
  {0xBEA7, 0xC468}, //10527 #HANGUL SYLLABLE SSANGSIOS U NIEUN
  {0xBEA8, 0xC46C}, //10528 #HANGUL SYLLABLE SSANGSIOS U RIEUL
  {0xBEA9, 0xC474}, //10529 #HANGUL SYLLABLE SSANGSIOS U MIEUM
  {0xBEAA, 0xC475}, //10530 #HANGUL SYLLABLE SSANGSIOS U PIEUP
  {0xBEAB, 0xC479}, //10531 #HANGUL SYLLABLE SSANGSIOS U IEUNG
  {0xBEAC, 0xC480}, //10532 #HANGUL SYLLABLE SSANGSIOS WEO
  {0xBEAD, 0xC494}, //10533 #HANGUL SYLLABLE SSANGSIOS WEO SSANGSIOS
  {0xBEAE, 0xC49C}, //10534 #HANGUL SYLLABLE SSANGSIOS WE
  {0xBEAF, 0xC4B8}, //10535 #HANGUL SYLLABLE SSANGSIOS WI
  {0xBEB0, 0xC4BC}, //10536 #HANGUL SYLLABLE SSANGSIOS WI NIEUN
  {0xBEB1, 0xC4E9}, //10537 #HANGUL SYLLABLE SSANGSIOS YU IEUNG
  {0xBEB2, 0xC4F0}, //10538 #HANGUL SYLLABLE SSANGSIOS EU
  {0xBEB3, 0xC4F1}, //10539 #HANGUL SYLLABLE SSANGSIOS EU KIYEOK
  {0xBEB4, 0xC4F4}, //10540 #HANGUL SYLLABLE SSANGSIOS EU NIEUN
  {0xBEB5, 0xC4F8}, //10541 #HANGUL SYLLABLE SSANGSIOS EU RIEUL
  {0xBEB6, 0xC4FA}, //10542 #HANGUL SYLLABLE SSANGSIOS EU RIEULMIEUM
  {0xBEB7, 0xC4FF}, //10543 #HANGUL SYLLABLE SSANGSIOS EU RIEULHIEUH
  {0xBEB8, 0xC500}, //10544 #HANGUL SYLLABLE SSANGSIOS EU MIEUM
  {0xBEB9, 0xC501}, //10545 #HANGUL SYLLABLE SSANGSIOS EU PIEUP
  {0xBEBA, 0xC50C}, //10546 #HANGUL SYLLABLE SSANGSIOS YI
  {0xBEBB, 0xC510}, //10547 #HANGUL SYLLABLE SSANGSIOS YI NIEUN
  {0xBEBC, 0xC514}, //10548 #HANGUL SYLLABLE SSANGSIOS YI RIEUL
  {0xBEBD, 0xC51C}, //10549 #HANGUL SYLLABLE SSANGSIOS YI MIEUM
  {0xBEBE, 0xC528}, //10550 #HANGUL SYLLABLE SSANGSIOS I
  {0xBEBF, 0xC529}, //10551 #HANGUL SYLLABLE SSANGSIOS I KIYEOK
  {0xBEC0, 0xC52C}, //10552 #HANGUL SYLLABLE SSANGSIOS I NIEUN
  {0xBEC1, 0xC530}, //10553 #HANGUL SYLLABLE SSANGSIOS I RIEUL
  {0xBEC2, 0xC538}, //10554 #HANGUL SYLLABLE SSANGSIOS I MIEUM
  {0xBEC3, 0xC539}, //10555 #HANGUL SYLLABLE SSANGSIOS I PIEUP
  {0xBEC4, 0xC53B}, //10556 #HANGUL SYLLABLE SSANGSIOS I SIOS
  {0xBEC5, 0xC53D}, //10557 #HANGUL SYLLABLE SSANGSIOS I IEUNG
  {0xBEC6, 0xC544}, //10558 #HANGUL SYLLABLE IEUNG A
  {0xBEC7, 0xC545}, //10559 #HANGUL SYLLABLE IEUNG A KIYEOK
  {0xBEC8, 0xC548}, //10560 #HANGUL SYLLABLE IEUNG A NIEUN
  {0xBEC9, 0xC549}, //10561 #HANGUL SYLLABLE IEUNG A NIEUNCIEUC
  {0xBECA, 0xC54A}, //10562 #HANGUL SYLLABLE IEUNG A NIEUNHIEUH
  {0xBECB, 0xC54C}, //10563 #HANGUL SYLLABLE IEUNG A RIEUL
  {0xBECC, 0xC54D}, //10564 #HANGUL SYLLABLE IEUNG A RIEULKIYEOK
  {0xBECD, 0xC54E}, //10565 #HANGUL SYLLABLE IEUNG A RIEULMIEUM
  {0xBECE, 0xC553}, //10566 #HANGUL SYLLABLE IEUNG A RIEULHIEUH
  {0xBECF, 0xC554}, //10567 #HANGUL SYLLABLE IEUNG A MIEUM
  {0xBED0, 0xC555}, //10568 #HANGUL SYLLABLE IEUNG A PIEUP
  {0xBED1, 0xC557}, //10569 #HANGUL SYLLABLE IEUNG A SIOS
  {0xBED2, 0xC558}, //10570 #HANGUL SYLLABLE IEUNG A SSANGSIOS
  {0xBED3, 0xC559}, //10571 #HANGUL SYLLABLE IEUNG A IEUNG
  {0xBED4, 0xC55D}, //10572 #HANGUL SYLLABLE IEUNG A THIEUTH
  {0xBED5, 0xC55E}, //10573 #HANGUL SYLLABLE IEUNG A PHIEUPH
  {0xBED6, 0xC560}, //10574 #HANGUL SYLLABLE IEUNG AE
  {0xBED7, 0xC561}, //10575 #HANGUL SYLLABLE IEUNG AE KIYEOK
  {0xBED8, 0xC564}, //10576 #HANGUL SYLLABLE IEUNG AE NIEUN
  {0xBED9, 0xC568}, //10577 #HANGUL SYLLABLE IEUNG AE RIEUL
  {0xBEDA, 0xC570}, //10578 #HANGUL SYLLABLE IEUNG AE MIEUM
  {0xBEDB, 0xC571}, //10579 #HANGUL SYLLABLE IEUNG AE PIEUP
  {0xBEDC, 0xC573}, //10580 #HANGUL SYLLABLE IEUNG AE SIOS
  {0xBEDD, 0xC574}, //10581 #HANGUL SYLLABLE IEUNG AE SSANGSIOS
  {0xBEDE, 0xC575}, //10582 #HANGUL SYLLABLE IEUNG AE IEUNG
  {0xBEDF, 0xC57C}, //10583 #HANGUL SYLLABLE IEUNG YA
  {0xBEE0, 0xC57D}, //10584 #HANGUL SYLLABLE IEUNG YA KIYEOK
  {0xBEE1, 0xC580}, //10585 #HANGUL SYLLABLE IEUNG YA NIEUN
  {0xBEE2, 0xC584}, //10586 #HANGUL SYLLABLE IEUNG YA RIEUL
  {0xBEE3, 0xC587}, //10587 #HANGUL SYLLABLE IEUNG YA RIEULPIEUP
  {0xBEE4, 0xC58C}, //10588 #HANGUL SYLLABLE IEUNG YA MIEUM
  {0xBEE5, 0xC58D}, //10589 #HANGUL SYLLABLE IEUNG YA PIEUP
  {0xBEE6, 0xC58F}, //10590 #HANGUL SYLLABLE IEUNG YA SIOS
  {0xBEE7, 0xC591}, //10591 #HANGUL SYLLABLE IEUNG YA IEUNG
  {0xBEE8, 0xC595}, //10592 #HANGUL SYLLABLE IEUNG YA THIEUTH
  {0xBEE9, 0xC597}, //10593 #HANGUL SYLLABLE IEUNG YA HIEUH
  {0xBEEA, 0xC598}, //10594 #HANGUL SYLLABLE IEUNG YAE
  {0xBEEB, 0xC59C}, //10595 #HANGUL SYLLABLE IEUNG YAE NIEUN
  {0xBEEC, 0xC5A0}, //10596 #HANGUL SYLLABLE IEUNG YAE RIEUL
  {0xBEED, 0xC5A9}, //10597 #HANGUL SYLLABLE IEUNG YAE PIEUP
  {0xBEEE, 0xC5B4}, //10598 #HANGUL SYLLABLE IEUNG EO
  {0xBEEF, 0xC5B5}, //10599 #HANGUL SYLLABLE IEUNG EO KIYEOK
  {0xBEF0, 0xC5B8}, //10600 #HANGUL SYLLABLE IEUNG EO NIEUN
  {0xBEF1, 0xC5B9}, //10601 #HANGUL SYLLABLE IEUNG EO NIEUNCIEUC
  {0xBEF2, 0xC5BB}, //10602 #HANGUL SYLLABLE IEUNG EO TIKEUT
  {0xBEF3, 0xC5BC}, //10603 #HANGUL SYLLABLE IEUNG EO RIEUL
  {0xBEF4, 0xC5BD}, //10604 #HANGUL SYLLABLE IEUNG EO RIEULKIYEOK
  {0xBEF5, 0xC5BE}, //10605 #HANGUL SYLLABLE IEUNG EO RIEULMIEUM
  {0xBEF6, 0xC5C4}, //10606 #HANGUL SYLLABLE IEUNG EO MIEUM
  {0xBEF7, 0xC5C5}, //10607 #HANGUL SYLLABLE IEUNG EO PIEUP
  {0xBEF8, 0xC5C6}, //10608 #HANGUL SYLLABLE IEUNG EO PIEUPSIOS
  {0xBEF9, 0xC5C7}, //10609 #HANGUL SYLLABLE IEUNG EO SIOS
  {0xBEFA, 0xC5C8}, //10610 #HANGUL SYLLABLE IEUNG EO SSANGSIOS
  {0xBEFB, 0xC5C9}, //10611 #HANGUL SYLLABLE IEUNG EO IEUNG
  {0xBEFC, 0xC5CA}, //10612 #HANGUL SYLLABLE IEUNG EO CIEUC
  {0xBEFD, 0xC5CC}, //10613 #HANGUL SYLLABLE IEUNG EO KHIEUKH
  {0xBEFE, 0xC5CE}, //10614 #HANGUL SYLLABLE IEUNG EO PHIEUPH
  {0xBF41, 0xD49E}, //10615 #HANGUL SYLLABLE PHIEUPH WEO RIEULMIEUM
  {0xBF42, 0xD49F}, //10616 #HANGUL SYLLABLE PHIEUPH WEO RIEULPIEUP
  {0xBF43, 0xD4A0}, //10617 #HANGUL SYLLABLE PHIEUPH WEO RIEULSIOS
  {0xBF44, 0xD4A1}, //10618 #HANGUL SYLLABLE PHIEUPH WEO RIEULTHIEUTH
  {0xBF45, 0xD4A2}, //10619 #HANGUL SYLLABLE PHIEUPH WEO RIEULPHIEUPH
  {0xBF46, 0xD4A3}, //10620 #HANGUL SYLLABLE PHIEUPH WEO RIEULHIEUH
  {0xBF47, 0xD4A4}, //10621 #HANGUL SYLLABLE PHIEUPH WEO MIEUM
  {0xBF48, 0xD4A5}, //10622 #HANGUL SYLLABLE PHIEUPH WEO PIEUP
  {0xBF49, 0xD4A6}, //10623 #HANGUL SYLLABLE PHIEUPH WEO PIEUPSIOS
  {0xBF4A, 0xD4A7}, //10624 #HANGUL SYLLABLE PHIEUPH WEO SIOS
  {0xBF4B, 0xD4A8}, //10625 #HANGUL SYLLABLE PHIEUPH WEO SSANGSIOS
  {0xBF4C, 0xD4AA}, //10626 #HANGUL SYLLABLE PHIEUPH WEO CIEUC
  {0xBF4D, 0xD4AB}, //10627 #HANGUL SYLLABLE PHIEUPH WEO CHIEUCH
  {0xBF4E, 0xD4AC}, //10628 #HANGUL SYLLABLE PHIEUPH WEO KHIEUKH
  {0xBF4F, 0xD4AD}, //10629 #HANGUL SYLLABLE PHIEUPH WEO THIEUTH
  {0xBF50, 0xD4AE}, //10630 #HANGUL SYLLABLE PHIEUPH WEO PHIEUPH
  {0xBF51, 0xD4AF}, //10631 #HANGUL SYLLABLE PHIEUPH WEO HIEUH
  {0xBF52, 0xD4B0}, //10632 #HANGUL SYLLABLE PHIEUPH WE
  {0xBF53, 0xD4B1}, //10633 #HANGUL SYLLABLE PHIEUPH WE KIYEOK
  {0xBF54, 0xD4B2}, //10634 #HANGUL SYLLABLE PHIEUPH WE SSANGKIYEOK
  {0xBF55, 0xD4B3}, //10635 #HANGUL SYLLABLE PHIEUPH WE KIYEOKSIOS
  {0xBF56, 0xD4B4}, //10636 #HANGUL SYLLABLE PHIEUPH WE NIEUN
  {0xBF57, 0xD4B5}, //10637 #HANGUL SYLLABLE PHIEUPH WE NIEUNCIEUC
  {0xBF58, 0xD4B6}, //10638 #HANGUL SYLLABLE PHIEUPH WE NIEUNHIEUH
  {0xBF59, 0xD4B7}, //10639 #HANGUL SYLLABLE PHIEUPH WE TIKEUT
  {0xBF5A, 0xD4B8}, //10640 #HANGUL SYLLABLE PHIEUPH WE RIEUL
  {0xBF61, 0xD4B9}, //10641 #HANGUL SYLLABLE PHIEUPH WE RIEULKIYEOK
  {0xBF62, 0xD4BA}, //10642 #HANGUL SYLLABLE PHIEUPH WE RIEULMIEUM
  {0xBF63, 0xD4BB}, //10643 #HANGUL SYLLABLE PHIEUPH WE RIEULPIEUP
  {0xBF64, 0xD4BC}, //10644 #HANGUL SYLLABLE PHIEUPH WE RIEULSIOS
  {0xBF65, 0xD4BD}, //10645 #HANGUL SYLLABLE PHIEUPH WE RIEULTHIEUTH
  {0xBF66, 0xD4BE}, //10646 #HANGUL SYLLABLE PHIEUPH WE RIEULPHIEUPH
  {0xBF67, 0xD4BF}, //10647 #HANGUL SYLLABLE PHIEUPH WE RIEULHIEUH
  {0xBF68, 0xD4C0}, //10648 #HANGUL SYLLABLE PHIEUPH WE MIEUM
  {0xBF69, 0xD4C1}, //10649 #HANGUL SYLLABLE PHIEUPH WE PIEUP
  {0xBF6A, 0xD4C2}, //10650 #HANGUL SYLLABLE PHIEUPH WE PIEUPSIOS
  {0xBF6B, 0xD4C3}, //10651 #HANGUL SYLLABLE PHIEUPH WE SIOS
  {0xBF6C, 0xD4C4}, //10652 #HANGUL SYLLABLE PHIEUPH WE SSANGSIOS
  {0xBF6D, 0xD4C5}, //10653 #HANGUL SYLLABLE PHIEUPH WE IEUNG
  {0xBF6E, 0xD4C6}, //10654 #HANGUL SYLLABLE PHIEUPH WE CIEUC
  {0xBF6F, 0xD4C7}, //10655 #HANGUL SYLLABLE PHIEUPH WE CHIEUCH
  {0xBF70, 0xD4C8}, //10656 #HANGUL SYLLABLE PHIEUPH WE KHIEUKH
  {0xBF71, 0xD4C9}, //10657 #HANGUL SYLLABLE PHIEUPH WE THIEUTH
  {0xBF72, 0xD4CA}, //10658 #HANGUL SYLLABLE PHIEUPH WE PHIEUPH
  {0xBF73, 0xD4CB}, //10659 #HANGUL SYLLABLE PHIEUPH WE HIEUH
  {0xBF74, 0xD4CD}, //10660 #HANGUL SYLLABLE PHIEUPH WI KIYEOK
  {0xBF75, 0xD4CE}, //10661 #HANGUL SYLLABLE PHIEUPH WI SSANGKIYEOK
  {0xBF76, 0xD4CF}, //10662 #HANGUL SYLLABLE PHIEUPH WI KIYEOKSIOS
  {0xBF77, 0xD4D1}, //10663 #HANGUL SYLLABLE PHIEUPH WI NIEUNCIEUC
  {0xBF78, 0xD4D2}, //10664 #HANGUL SYLLABLE PHIEUPH WI NIEUNHIEUH
  {0xBF79, 0xD4D3}, //10665 #HANGUL SYLLABLE PHIEUPH WI TIKEUT
  {0xBF7A, 0xD4D5}, //10666 #HANGUL SYLLABLE PHIEUPH WI RIEULKIYEOK
  {0xBF81, 0xD4D6}, //10667 #HANGUL SYLLABLE PHIEUPH WI RIEULMIEUM
  {0xBF82, 0xD4D7}, //10668 #HANGUL SYLLABLE PHIEUPH WI RIEULPIEUP
  {0xBF83, 0xD4D8}, //10669 #HANGUL SYLLABLE PHIEUPH WI RIEULSIOS
  {0xBF84, 0xD4D9}, //10670 #HANGUL SYLLABLE PHIEUPH WI RIEULTHIEUTH
  {0xBF85, 0xD4DA}, //10671 #HANGUL SYLLABLE PHIEUPH WI RIEULPHIEUPH
  {0xBF86, 0xD4DB}, //10672 #HANGUL SYLLABLE PHIEUPH WI RIEULHIEUH
  {0xBF87, 0xD4DD}, //10673 #HANGUL SYLLABLE PHIEUPH WI PIEUP
  {0xBF88, 0xD4DE}, //10674 #HANGUL SYLLABLE PHIEUPH WI PIEUPSIOS
  {0xBF89, 0xD4E0}, //10675 #HANGUL SYLLABLE PHIEUPH WI SSANGSIOS
  {0xBF8A, 0xD4E1}, //10676 #HANGUL SYLLABLE PHIEUPH WI IEUNG
  {0xBF8B, 0xD4E2}, //10677 #HANGUL SYLLABLE PHIEUPH WI CIEUC
  {0xBF8C, 0xD4E3}, //10678 #HANGUL SYLLABLE PHIEUPH WI CHIEUCH
  {0xBF8D, 0xD4E4}, //10679 #HANGUL SYLLABLE PHIEUPH WI KHIEUKH
  {0xBF8E, 0xD4E5}, //10680 #HANGUL SYLLABLE PHIEUPH WI THIEUTH
  {0xBF8F, 0xD4E6}, //10681 #HANGUL SYLLABLE PHIEUPH WI PHIEUPH
  {0xBF90, 0xD4E7}, //10682 #HANGUL SYLLABLE PHIEUPH WI HIEUH
  {0xBF91, 0xD4E9}, //10683 #HANGUL SYLLABLE PHIEUPH YU KIYEOK
  {0xBF92, 0xD4EA}, //10684 #HANGUL SYLLABLE PHIEUPH YU SSANGKIYEOK
  {0xBF93, 0xD4EB}, //10685 #HANGUL SYLLABLE PHIEUPH YU KIYEOKSIOS
  {0xBF94, 0xD4ED}, //10686 #HANGUL SYLLABLE PHIEUPH YU NIEUNCIEUC
  {0xBF95, 0xD4EE}, //10687 #HANGUL SYLLABLE PHIEUPH YU NIEUNHIEUH
  {0xBF96, 0xD4EF}, //10688 #HANGUL SYLLABLE PHIEUPH YU TIKEUT
  {0xBF97, 0xD4F1}, //10689 #HANGUL SYLLABLE PHIEUPH YU RIEULKIYEOK
  {0xBF98, 0xD4F2}, //10690 #HANGUL SYLLABLE PHIEUPH YU RIEULMIEUM
  {0xBF99, 0xD4F3}, //10691 #HANGUL SYLLABLE PHIEUPH YU RIEULPIEUP
  {0xBF9A, 0xD4F4}, //10692 #HANGUL SYLLABLE PHIEUPH YU RIEULSIOS
  {0xBF9B, 0xD4F5}, //10693 #HANGUL SYLLABLE PHIEUPH YU RIEULTHIEUTH
  {0xBF9C, 0xD4F6}, //10694 #HANGUL SYLLABLE PHIEUPH YU RIEULPHIEUPH
  {0xBF9D, 0xD4F7}, //10695 #HANGUL SYLLABLE PHIEUPH YU RIEULHIEUH
  {0xBF9E, 0xD4F9}, //10696 #HANGUL SYLLABLE PHIEUPH YU PIEUP
  {0xBF9F, 0xD4FA}, //10697 #HANGUL SYLLABLE PHIEUPH YU PIEUPSIOS
  {0xBFA0, 0xD4FC}, //10698 #HANGUL SYLLABLE PHIEUPH YU SSANGSIOS
  {0xBFA1, 0xC5D0}, //10699 #HANGUL SYLLABLE IEUNG E
  {0xBFA2, 0xC5D1}, //10700 #HANGUL SYLLABLE IEUNG E KIYEOK
  {0xBFA3, 0xC5D4}, //10701 #HANGUL SYLLABLE IEUNG E NIEUN
  {0xBFA4, 0xC5D8}, //10702 #HANGUL SYLLABLE IEUNG E RIEUL
  {0xBFA5, 0xC5E0}, //10703 #HANGUL SYLLABLE IEUNG E MIEUM
  {0xBFA6, 0xC5E1}, //10704 #HANGUL SYLLABLE IEUNG E PIEUP
  {0xBFA7, 0xC5E3}, //10705 #HANGUL SYLLABLE IEUNG E SIOS
  {0xBFA8, 0xC5E5}, //10706 #HANGUL SYLLABLE IEUNG E IEUNG
  {0xBFA9, 0xC5EC}, //10707 #HANGUL SYLLABLE IEUNG YEO
  {0xBFAA, 0xC5ED}, //10708 #HANGUL SYLLABLE IEUNG YEO KIYEOK
  {0xBFAB, 0xC5EE}, //10709 #HANGUL SYLLABLE IEUNG YEO SSANGKIYEOK
  {0xBFAC, 0xC5F0}, //10710 #HANGUL SYLLABLE IEUNG YEO NIEUN
  {0xBFAD, 0xC5F4}, //10711 #HANGUL SYLLABLE IEUNG YEO RIEUL
  {0xBFAE, 0xC5F6}, //10712 #HANGUL SYLLABLE IEUNG YEO RIEULMIEUM
  {0xBFAF, 0xC5F7}, //10713 #HANGUL SYLLABLE IEUNG YEO RIEULPIEUP
  {0xBFB0, 0xC5FC}, //10714 #HANGUL SYLLABLE IEUNG YEO MIEUM
  {0xBFB1, 0xC5FD}, //10715 #HANGUL SYLLABLE IEUNG YEO PIEUP
  {0xBFB2, 0xC5FE}, //10716 #HANGUL SYLLABLE IEUNG YEO PIEUPSIOS
  {0xBFB3, 0xC5FF}, //10717 #HANGUL SYLLABLE IEUNG YEO SIOS
  {0xBFB4, 0xC600}, //10718 #HANGUL SYLLABLE IEUNG YEO SSANGSIOS
  {0xBFB5, 0xC601}, //10719 #HANGUL SYLLABLE IEUNG YEO IEUNG
  {0xBFB6, 0xC605}, //10720 #HANGUL SYLLABLE IEUNG YEO THIEUTH
  {0xBFB7, 0xC606}, //10721 #HANGUL SYLLABLE IEUNG YEO PHIEUPH
  {0xBFB8, 0xC607}, //10722 #HANGUL SYLLABLE IEUNG YEO HIEUH
  {0xBFB9, 0xC608}, //10723 #HANGUL SYLLABLE IEUNG YE
  {0xBFBA, 0xC60C}, //10724 #HANGUL SYLLABLE IEUNG YE NIEUN
  {0xBFBB, 0xC610}, //10725 #HANGUL SYLLABLE IEUNG YE RIEUL
  {0xBFBC, 0xC618}, //10726 #HANGUL SYLLABLE IEUNG YE MIEUM
  {0xBFBD, 0xC619}, //10727 #HANGUL SYLLABLE IEUNG YE PIEUP
  {0xBFBE, 0xC61B}, //10728 #HANGUL SYLLABLE IEUNG YE SIOS
  {0xBFBF, 0xC61C}, //10729 #HANGUL SYLLABLE IEUNG YE SSANGSIOS
  {0xBFC0, 0xC624}, //10730 #HANGUL SYLLABLE IEUNG O
  {0xBFC1, 0xC625}, //10731 #HANGUL SYLLABLE IEUNG O KIYEOK
  {0xBFC2, 0xC628}, //10732 #HANGUL SYLLABLE IEUNG O NIEUN
  {0xBFC3, 0xC62C}, //10733 #HANGUL SYLLABLE IEUNG O RIEUL
  {0xBFC4, 0xC62D}, //10734 #HANGUL SYLLABLE IEUNG O RIEULKIYEOK
  {0xBFC5, 0xC62E}, //10735 #HANGUL SYLLABLE IEUNG O RIEULMIEUM
  {0xBFC6, 0xC630}, //10736 #HANGUL SYLLABLE IEUNG O RIEULSIOS
  {0xBFC7, 0xC633}, //10737 #HANGUL SYLLABLE IEUNG O RIEULHIEUH
  {0xBFC8, 0xC634}, //10738 #HANGUL SYLLABLE IEUNG O MIEUM
  {0xBFC9, 0xC635}, //10739 #HANGUL SYLLABLE IEUNG O PIEUP
  {0xBFCA, 0xC637}, //10740 #HANGUL SYLLABLE IEUNG O SIOS
  {0xBFCB, 0xC639}, //10741 #HANGUL SYLLABLE IEUNG O IEUNG
  {0xBFCC, 0xC63B}, //10742 #HANGUL SYLLABLE IEUNG O CHIEUCH
  {0xBFCD, 0xC640}, //10743 #HANGUL SYLLABLE IEUNG WA
  {0xBFCE, 0xC641}, //10744 #HANGUL SYLLABLE IEUNG WA KIYEOK
  {0xBFCF, 0xC644}, //10745 #HANGUL SYLLABLE IEUNG WA NIEUN
  {0xBFD0, 0xC648}, //10746 #HANGUL SYLLABLE IEUNG WA RIEUL
  {0xBFD1, 0xC650}, //10747 #HANGUL SYLLABLE IEUNG WA MIEUM
  {0xBFD2, 0xC651}, //10748 #HANGUL SYLLABLE IEUNG WA PIEUP
  {0xBFD3, 0xC653}, //10749 #HANGUL SYLLABLE IEUNG WA SIOS
  {0xBFD4, 0xC654}, //10750 #HANGUL SYLLABLE IEUNG WA SSANGSIOS
  {0xBFD5, 0xC655}, //10751 #HANGUL SYLLABLE IEUNG WA IEUNG
  {0xBFD6, 0xC65C}, //10752 #HANGUL SYLLABLE IEUNG WAE
  {0xBFD7, 0xC65D}, //10753 #HANGUL SYLLABLE IEUNG WAE KIYEOK
  {0xBFD8, 0xC660}, //10754 #HANGUL SYLLABLE IEUNG WAE NIEUN
  {0xBFD9, 0xC66C}, //10755 #HANGUL SYLLABLE IEUNG WAE MIEUM
  {0xBFDA, 0xC66F}, //10756 #HANGUL SYLLABLE IEUNG WAE SIOS
  {0xBFDB, 0xC671}, //10757 #HANGUL SYLLABLE IEUNG WAE IEUNG
  {0xBFDC, 0xC678}, //10758 #HANGUL SYLLABLE IEUNG OE
  {0xBFDD, 0xC679}, //10759 #HANGUL SYLLABLE IEUNG OE KIYEOK
  {0xBFDE, 0xC67C}, //10760 #HANGUL SYLLABLE IEUNG OE NIEUN
  {0xBFDF, 0xC680}, //10761 #HANGUL SYLLABLE IEUNG OE RIEUL
  {0xBFE0, 0xC688}, //10762 #HANGUL SYLLABLE IEUNG OE MIEUM
  {0xBFE1, 0xC689}, //10763 #HANGUL SYLLABLE IEUNG OE PIEUP
  {0xBFE2, 0xC68B}, //10764 #HANGUL SYLLABLE IEUNG OE SIOS
  {0xBFE3, 0xC68D}, //10765 #HANGUL SYLLABLE IEUNG OE IEUNG
  {0xBFE4, 0xC694}, //10766 #HANGUL SYLLABLE IEUNG YO
  {0xBFE5, 0xC695}, //10767 #HANGUL SYLLABLE IEUNG YO KIYEOK
  {0xBFE6, 0xC698}, //10768 #HANGUL SYLLABLE IEUNG YO NIEUN
  {0xBFE7, 0xC69C}, //10769 #HANGUL SYLLABLE IEUNG YO RIEUL
  {0xBFE8, 0xC6A4}, //10770 #HANGUL SYLLABLE IEUNG YO MIEUM
  {0xBFE9, 0xC6A5}, //10771 #HANGUL SYLLABLE IEUNG YO PIEUP
  {0xBFEA, 0xC6A7}, //10772 #HANGUL SYLLABLE IEUNG YO SIOS
  {0xBFEB, 0xC6A9}, //10773 #HANGUL SYLLABLE IEUNG YO IEUNG
  {0xBFEC, 0xC6B0}, //10774 #HANGUL SYLLABLE IEUNG U
  {0xBFED, 0xC6B1}, //10775 #HANGUL SYLLABLE IEUNG U KIYEOK
  {0xBFEE, 0xC6B4}, //10776 #HANGUL SYLLABLE IEUNG U NIEUN
  {0xBFEF, 0xC6B8}, //10777 #HANGUL SYLLABLE IEUNG U RIEUL
  {0xBFF0, 0xC6B9}, //10778 #HANGUL SYLLABLE IEUNG U RIEULKIYEOK
  {0xBFF1, 0xC6BA}, //10779 #HANGUL SYLLABLE IEUNG U RIEULMIEUM
  {0xBFF2, 0xC6C0}, //10780 #HANGUL SYLLABLE IEUNG U MIEUM
  {0xBFF3, 0xC6C1}, //10781 #HANGUL SYLLABLE IEUNG U PIEUP
  {0xBFF4, 0xC6C3}, //10782 #HANGUL SYLLABLE IEUNG U SIOS
  {0xBFF5, 0xC6C5}, //10783 #HANGUL SYLLABLE IEUNG U IEUNG
  {0xBFF6, 0xC6CC}, //10784 #HANGUL SYLLABLE IEUNG WEO
  {0xBFF7, 0xC6CD}, //10785 #HANGUL SYLLABLE IEUNG WEO KIYEOK
  {0xBFF8, 0xC6D0}, //10786 #HANGUL SYLLABLE IEUNG WEO NIEUN
  {0xBFF9, 0xC6D4}, //10787 #HANGUL SYLLABLE IEUNG WEO RIEUL
  {0xBFFA, 0xC6DC}, //10788 #HANGUL SYLLABLE IEUNG WEO MIEUM
  {0xBFFB, 0xC6DD}, //10789 #HANGUL SYLLABLE IEUNG WEO PIEUP
  {0xBFFC, 0xC6E0}, //10790 #HANGUL SYLLABLE IEUNG WEO SSANGSIOS
  {0xBFFD, 0xC6E1}, //10791 #HANGUL SYLLABLE IEUNG WEO IEUNG
  {0xBFFE, 0xC6E8}, //10792 #HANGUL SYLLABLE IEUNG WE
  {0xC041, 0xD4FE}, //10793 #HANGUL SYLLABLE PHIEUPH YU CIEUC
  {0xC042, 0xD4FF}, //10794 #HANGUL SYLLABLE PHIEUPH YU CHIEUCH
  {0xC043, 0xD500}, //10795 #HANGUL SYLLABLE PHIEUPH YU KHIEUKH
  {0xC044, 0xD501}, //10796 #HANGUL SYLLABLE PHIEUPH YU THIEUTH
  {0xC045, 0xD502}, //10797 #HANGUL SYLLABLE PHIEUPH YU PHIEUPH
  {0xC046, 0xD503}, //10798 #HANGUL SYLLABLE PHIEUPH YU HIEUH
  {0xC047, 0xD505}, //10799 #HANGUL SYLLABLE PHIEUPH EU KIYEOK
  {0xC048, 0xD506}, //10800 #HANGUL SYLLABLE PHIEUPH EU SSANGKIYEOK
  {0xC049, 0xD507}, //10801 #HANGUL SYLLABLE PHIEUPH EU KIYEOKSIOS
  {0xC04A, 0xD509}, //10802 #HANGUL SYLLABLE PHIEUPH EU NIEUNCIEUC
  {0xC04B, 0xD50A}, //10803 #HANGUL SYLLABLE PHIEUPH EU NIEUNHIEUH
  {0xC04C, 0xD50B}, //10804 #HANGUL SYLLABLE PHIEUPH EU TIKEUT
  {0xC04D, 0xD50D}, //10805 #HANGUL SYLLABLE PHIEUPH EU RIEULKIYEOK
  {0xC04E, 0xD50E}, //10806 #HANGUL SYLLABLE PHIEUPH EU RIEULMIEUM
  {0xC04F, 0xD50F}, //10807 #HANGUL SYLLABLE PHIEUPH EU RIEULPIEUP
  {0xC050, 0xD510}, //10808 #HANGUL SYLLABLE PHIEUPH EU RIEULSIOS
  {0xC051, 0xD511}, //10809 #HANGUL SYLLABLE PHIEUPH EU RIEULTHIEUTH
  {0xC052, 0xD512}, //10810 #HANGUL SYLLABLE PHIEUPH EU RIEULPHIEUPH
  {0xC053, 0xD513}, //10811 #HANGUL SYLLABLE PHIEUPH EU RIEULHIEUH
  {0xC054, 0xD516}, //10812 #HANGUL SYLLABLE PHIEUPH EU PIEUPSIOS
  {0xC055, 0xD518}, //10813 #HANGUL SYLLABLE PHIEUPH EU SSANGSIOS
  {0xC056, 0xD519}, //10814 #HANGUL SYLLABLE PHIEUPH EU IEUNG
  {0xC057, 0xD51A}, //10815 #HANGUL SYLLABLE PHIEUPH EU CIEUC
  {0xC058, 0xD51B}, //10816 #HANGUL SYLLABLE PHIEUPH EU CHIEUCH
  {0xC059, 0xD51C}, //10817 #HANGUL SYLLABLE PHIEUPH EU KHIEUKH
  {0xC05A, 0xD51D}, //10818 #HANGUL SYLLABLE PHIEUPH EU THIEUTH
  {0xC061, 0xD51E}, //10819 #HANGUL SYLLABLE PHIEUPH EU PHIEUPH
  {0xC062, 0xD51F}, //10820 #HANGUL SYLLABLE PHIEUPH EU HIEUH
  {0xC063, 0xD520}, //10821 #HANGUL SYLLABLE PHIEUPH YI
  {0xC064, 0xD521}, //10822 #HANGUL SYLLABLE PHIEUPH YI KIYEOK
  {0xC065, 0xD522}, //10823 #HANGUL SYLLABLE PHIEUPH YI SSANGKIYEOK
  {0xC066, 0xD523}, //10824 #HANGUL SYLLABLE PHIEUPH YI KIYEOKSIOS
  {0xC067, 0xD524}, //10825 #HANGUL SYLLABLE PHIEUPH YI NIEUN
  {0xC068, 0xD525}, //10826 #HANGUL SYLLABLE PHIEUPH YI NIEUNCIEUC
  {0xC069, 0xD526}, //10827 #HANGUL SYLLABLE PHIEUPH YI NIEUNHIEUH
  {0xC06A, 0xD527}, //10828 #HANGUL SYLLABLE PHIEUPH YI TIKEUT
  {0xC06B, 0xD528}, //10829 #HANGUL SYLLABLE PHIEUPH YI RIEUL
  {0xC06C, 0xD529}, //10830 #HANGUL SYLLABLE PHIEUPH YI RIEULKIYEOK
  {0xC06D, 0xD52A}, //10831 #HANGUL SYLLABLE PHIEUPH YI RIEULMIEUM
  {0xC06E, 0xD52B}, //10832 #HANGUL SYLLABLE PHIEUPH YI RIEULPIEUP
  {0xC06F, 0xD52C}, //10833 #HANGUL SYLLABLE PHIEUPH YI RIEULSIOS
  {0xC070, 0xD52D}, //10834 #HANGUL SYLLABLE PHIEUPH YI RIEULTHIEUTH
  {0xC071, 0xD52E}, //10835 #HANGUL SYLLABLE PHIEUPH YI RIEULPHIEUPH
  {0xC072, 0xD52F}, //10836 #HANGUL SYLLABLE PHIEUPH YI RIEULHIEUH
  {0xC073, 0xD530}, //10837 #HANGUL SYLLABLE PHIEUPH YI MIEUM
  {0xC074, 0xD531}, //10838 #HANGUL SYLLABLE PHIEUPH YI PIEUP
  {0xC075, 0xD532}, //10839 #HANGUL SYLLABLE PHIEUPH YI PIEUPSIOS
  {0xC076, 0xD533}, //10840 #HANGUL SYLLABLE PHIEUPH YI SIOS
  {0xC077, 0xD534}, //10841 #HANGUL SYLLABLE PHIEUPH YI SSANGSIOS
  {0xC078, 0xD535}, //10842 #HANGUL SYLLABLE PHIEUPH YI IEUNG
  {0xC079, 0xD536}, //10843 #HANGUL SYLLABLE PHIEUPH YI CIEUC
  {0xC07A, 0xD537}, //10844 #HANGUL SYLLABLE PHIEUPH YI CHIEUCH
  {0xC081, 0xD538}, //10845 #HANGUL SYLLABLE PHIEUPH YI KHIEUKH
  {0xC082, 0xD539}, //10846 #HANGUL SYLLABLE PHIEUPH YI THIEUTH
  {0xC083, 0xD53A}, //10847 #HANGUL SYLLABLE PHIEUPH YI PHIEUPH
  {0xC084, 0xD53B}, //10848 #HANGUL SYLLABLE PHIEUPH YI HIEUH
  {0xC085, 0xD53E}, //10849 #HANGUL SYLLABLE PHIEUPH I SSANGKIYEOK
  {0xC086, 0xD53F}, //10850 #HANGUL SYLLABLE PHIEUPH I KIYEOKSIOS
  {0xC087, 0xD541}, //10851 #HANGUL SYLLABLE PHIEUPH I NIEUNCIEUC
  {0xC088, 0xD542}, //10852 #HANGUL SYLLABLE PHIEUPH I NIEUNHIEUH
  {0xC089, 0xD543}, //10853 #HANGUL SYLLABLE PHIEUPH I TIKEUT
  {0xC08A, 0xD545}, //10854 #HANGUL SYLLABLE PHIEUPH I RIEULKIYEOK
  {0xC08B, 0xD546}, //10855 #HANGUL SYLLABLE PHIEUPH I RIEULMIEUM
  {0xC08C, 0xD547}, //10856 #HANGUL SYLLABLE PHIEUPH I RIEULPIEUP
  {0xC08D, 0xD548}, //10857 #HANGUL SYLLABLE PHIEUPH I RIEULSIOS
  {0xC08E, 0xD549}, //10858 #HANGUL SYLLABLE PHIEUPH I RIEULTHIEUTH
  {0xC08F, 0xD54A}, //10859 #HANGUL SYLLABLE PHIEUPH I RIEULPHIEUPH
  {0xC090, 0xD54B}, //10860 #HANGUL SYLLABLE PHIEUPH I RIEULHIEUH
  {0xC091, 0xD54E}, //10861 #HANGUL SYLLABLE PHIEUPH I PIEUPSIOS
  {0xC092, 0xD550}, //10862 #HANGUL SYLLABLE PHIEUPH I SSANGSIOS
  {0xC093, 0xD552}, //10863 #HANGUL SYLLABLE PHIEUPH I CIEUC
  {0xC094, 0xD553}, //10864 #HANGUL SYLLABLE PHIEUPH I CHIEUCH
  {0xC095, 0xD554}, //10865 #HANGUL SYLLABLE PHIEUPH I KHIEUKH
  {0xC096, 0xD555}, //10866 #HANGUL SYLLABLE PHIEUPH I THIEUTH
  {0xC097, 0xD556}, //10867 #HANGUL SYLLABLE PHIEUPH I PHIEUPH
  {0xC098, 0xD557}, //10868 #HANGUL SYLLABLE PHIEUPH I HIEUH
  {0xC099, 0xD55A}, //10869 #HANGUL SYLLABLE HIEUH A SSANGKIYEOK
  {0xC09A, 0xD55B}, //10870 #HANGUL SYLLABLE HIEUH A KIYEOKSIOS
  {0xC09B, 0xD55D}, //10871 #HANGUL SYLLABLE HIEUH A NIEUNCIEUC
  {0xC09C, 0xD55E}, //10872 #HANGUL SYLLABLE HIEUH A NIEUNHIEUH
  {0xC09D, 0xD55F}, //10873 #HANGUL SYLLABLE HIEUH A TIKEUT
  {0xC09E, 0xD561}, //10874 #HANGUL SYLLABLE HIEUH A RIEULKIYEOK
  {0xC09F, 0xD562}, //10875 #HANGUL SYLLABLE HIEUH A RIEULMIEUM
  {0xC0A0, 0xD563}, //10876 #HANGUL SYLLABLE HIEUH A RIEULPIEUP
  {0xC0A1, 0xC6E9}, //10877 #HANGUL SYLLABLE IEUNG WE KIYEOK
  {0xC0A2, 0xC6EC}, //10878 #HANGUL SYLLABLE IEUNG WE NIEUN
  {0xC0A3, 0xC6F0}, //10879 #HANGUL SYLLABLE IEUNG WE RIEUL
  {0xC0A4, 0xC6F8}, //10880 #HANGUL SYLLABLE IEUNG WE MIEUM
  {0xC0A5, 0xC6F9}, //10881 #HANGUL SYLLABLE IEUNG WE PIEUP
  {0xC0A6, 0xC6FD}, //10882 #HANGUL SYLLABLE IEUNG WE IEUNG
  {0xC0A7, 0xC704}, //10883 #HANGUL SYLLABLE IEUNG WI
  {0xC0A8, 0xC705}, //10884 #HANGUL SYLLABLE IEUNG WI KIYEOK
  {0xC0A9, 0xC708}, //10885 #HANGUL SYLLABLE IEUNG WI NIEUN
  {0xC0AA, 0xC70C}, //10886 #HANGUL SYLLABLE IEUNG WI RIEUL
  {0xC0AB, 0xC714}, //10887 #HANGUL SYLLABLE IEUNG WI MIEUM
  {0xC0AC, 0xC715}, //10888 #HANGUL SYLLABLE IEUNG WI PIEUP
  {0xC0AD, 0xC717}, //10889 #HANGUL SYLLABLE IEUNG WI SIOS
  {0xC0AE, 0xC719}, //10890 #HANGUL SYLLABLE IEUNG WI IEUNG
  {0xC0AF, 0xC720}, //10891 #HANGUL SYLLABLE IEUNG YU
  {0xC0B0, 0xC721}, //10892 #HANGUL SYLLABLE IEUNG YU KIYEOK
  {0xC0B1, 0xC724}, //10893 #HANGUL SYLLABLE IEUNG YU NIEUN
  {0xC0B2, 0xC728}, //10894 #HANGUL SYLLABLE IEUNG YU RIEUL
  {0xC0B3, 0xC730}, //10895 #HANGUL SYLLABLE IEUNG YU MIEUM
  {0xC0B4, 0xC731}, //10896 #HANGUL SYLLABLE IEUNG YU PIEUP
  {0xC0B5, 0xC733}, //10897 #HANGUL SYLLABLE IEUNG YU SIOS
  {0xC0B6, 0xC735}, //10898 #HANGUL SYLLABLE IEUNG YU IEUNG
  {0xC0B7, 0xC737}, //10899 #HANGUL SYLLABLE IEUNG YU CHIEUCH
  {0xC0B8, 0xC73C}, //10900 #HANGUL SYLLABLE IEUNG EU
  {0xC0B9, 0xC73D}, //10901 #HANGUL SYLLABLE IEUNG EU KIYEOK
  {0xC0BA, 0xC740}, //10902 #HANGUL SYLLABLE IEUNG EU NIEUN
  {0xC0BB, 0xC744}, //10903 #HANGUL SYLLABLE IEUNG EU RIEUL
  {0xC0BC, 0xC74A}, //10904 #HANGUL SYLLABLE IEUNG EU RIEULPHIEUPH
  {0xC0BD, 0xC74C}, //10905 #HANGUL SYLLABLE IEUNG EU MIEUM
  {0xC0BE, 0xC74D}, //10906 #HANGUL SYLLABLE IEUNG EU PIEUP
  {0xC0BF, 0xC74F}, //10907 #HANGUL SYLLABLE IEUNG EU SIOS
  {0xC0C0, 0xC751}, //10908 #HANGUL SYLLABLE IEUNG EU IEUNG
  {0xC0C1, 0xC752}, //10909 #HANGUL SYLLABLE IEUNG EU CIEUC
  {0xC0C2, 0xC753}, //10910 #HANGUL SYLLABLE IEUNG EU CHIEUCH
  {0xC0C3, 0xC754}, //10911 #HANGUL SYLLABLE IEUNG EU KHIEUKH
  {0xC0C4, 0xC755}, //10912 #HANGUL SYLLABLE IEUNG EU THIEUTH
  {0xC0C5, 0xC756}, //10913 #HANGUL SYLLABLE IEUNG EU PHIEUPH
  {0xC0C6, 0xC757}, //10914 #HANGUL SYLLABLE IEUNG EU HIEUH
  {0xC0C7, 0xC758}, //10915 #HANGUL SYLLABLE IEUNG YI
  {0xC0C8, 0xC75C}, //10916 #HANGUL SYLLABLE IEUNG YI NIEUN
  {0xC0C9, 0xC760}, //10917 #HANGUL SYLLABLE IEUNG YI RIEUL
  {0xC0CA, 0xC768}, //10918 #HANGUL SYLLABLE IEUNG YI MIEUM
  {0xC0CB, 0xC76B}, //10919 #HANGUL SYLLABLE IEUNG YI SIOS
  {0xC0CC, 0xC774}, //10920 #HANGUL SYLLABLE IEUNG I
  {0xC0CD, 0xC775}, //10921 #HANGUL SYLLABLE IEUNG I KIYEOK
  {0xC0CE, 0xC778}, //10922 #HANGUL SYLLABLE IEUNG I NIEUN
  {0xC0CF, 0xC77C}, //10923 #HANGUL SYLLABLE IEUNG I RIEUL
  {0xC0D0, 0xC77D}, //10924 #HANGUL SYLLABLE IEUNG I RIEULKIYEOK
  {0xC0D1, 0xC77E}, //10925 #HANGUL SYLLABLE IEUNG I RIEULMIEUM
  {0xC0D2, 0xC783}, //10926 #HANGUL SYLLABLE IEUNG I RIEULHIEUH
  {0xC0D3, 0xC784}, //10927 #HANGUL SYLLABLE IEUNG I MIEUM
  {0xC0D4, 0xC785}, //10928 #HANGUL SYLLABLE IEUNG I PIEUP
  {0xC0D5, 0xC787}, //10929 #HANGUL SYLLABLE IEUNG I SIOS
  {0xC0D6, 0xC788}, //10930 #HANGUL SYLLABLE IEUNG I SSANGSIOS
  {0xC0D7, 0xC789}, //10931 #HANGUL SYLLABLE IEUNG I IEUNG
  {0xC0D8, 0xC78A}, //10932 #HANGUL SYLLABLE IEUNG I CIEUC
  {0xC0D9, 0xC78E}, //10933 #HANGUL SYLLABLE IEUNG I PHIEUPH
  {0xC0DA, 0xC790}, //10934 #HANGUL SYLLABLE CIEUC A
  {0xC0DB, 0xC791}, //10935 #HANGUL SYLLABLE CIEUC A KIYEOK
  {0xC0DC, 0xC794}, //10936 #HANGUL SYLLABLE CIEUC A NIEUN
  {0xC0DD, 0xC796}, //10937 #HANGUL SYLLABLE CIEUC A NIEUNHIEUH
  {0xC0DE, 0xC797}, //10938 #HANGUL SYLLABLE CIEUC A TIKEUT
  {0xC0DF, 0xC798}, //10939 #HANGUL SYLLABLE CIEUC A RIEUL
  {0xC0E0, 0xC79A}, //10940 #HANGUL SYLLABLE CIEUC A RIEULMIEUM
  {0xC0E1, 0xC7A0}, //10941 #HANGUL SYLLABLE CIEUC A MIEUM
  {0xC0E2, 0xC7A1}, //10942 #HANGUL SYLLABLE CIEUC A PIEUP
  {0xC0E3, 0xC7A3}, //10943 #HANGUL SYLLABLE CIEUC A SIOS
  {0xC0E4, 0xC7A4}, //10944 #HANGUL SYLLABLE CIEUC A SSANGSIOS
  {0xC0E5, 0xC7A5}, //10945 #HANGUL SYLLABLE CIEUC A IEUNG
  {0xC0E6, 0xC7A6}, //10946 #HANGUL SYLLABLE CIEUC A CIEUC
  {0xC0E7, 0xC7AC}, //10947 #HANGUL SYLLABLE CIEUC AE
  {0xC0E8, 0xC7AD}, //10948 #HANGUL SYLLABLE CIEUC AE KIYEOK
  {0xC0E9, 0xC7B0}, //10949 #HANGUL SYLLABLE CIEUC AE NIEUN
  {0xC0EA, 0xC7B4}, //10950 #HANGUL SYLLABLE CIEUC AE RIEUL
  {0xC0EB, 0xC7BC}, //10951 #HANGUL SYLLABLE CIEUC AE MIEUM
  {0xC0EC, 0xC7BD}, //10952 #HANGUL SYLLABLE CIEUC AE PIEUP
  {0xC0ED, 0xC7BF}, //10953 #HANGUL SYLLABLE CIEUC AE SIOS
  {0xC0EE, 0xC7C0}, //10954 #HANGUL SYLLABLE CIEUC AE SSANGSIOS
  {0xC0EF, 0xC7C1}, //10955 #HANGUL SYLLABLE CIEUC AE IEUNG
  {0xC0F0, 0xC7C8}, //10956 #HANGUL SYLLABLE CIEUC YA
  {0xC0F1, 0xC7C9}, //10957 #HANGUL SYLLABLE CIEUC YA KIYEOK
  {0xC0F2, 0xC7CC}, //10958 #HANGUL SYLLABLE CIEUC YA NIEUN
  {0xC0F3, 0xC7CE}, //10959 #HANGUL SYLLABLE CIEUC YA NIEUNHIEUH
  {0xC0F4, 0xC7D0}, //10960 #HANGUL SYLLABLE CIEUC YA RIEUL
  {0xC0F5, 0xC7D8}, //10961 #HANGUL SYLLABLE CIEUC YA MIEUM
  {0xC0F6, 0xC7DD}, //10962 #HANGUL SYLLABLE CIEUC YA IEUNG
  {0xC0F7, 0xC7E4}, //10963 #HANGUL SYLLABLE CIEUC YAE
  {0xC0F8, 0xC7E8}, //10964 #HANGUL SYLLABLE CIEUC YAE NIEUN
  {0xC0F9, 0xC7EC}, //10965 #HANGUL SYLLABLE CIEUC YAE RIEUL
  {0xC0FA, 0xC800}, //10966 #HANGUL SYLLABLE CIEUC EO
  {0xC0FB, 0xC801}, //10967 #HANGUL SYLLABLE CIEUC EO KIYEOK
  {0xC0FC, 0xC804}, //10968 #HANGUL SYLLABLE CIEUC EO NIEUN
  {0xC0FD, 0xC808}, //10969 #HANGUL SYLLABLE CIEUC EO RIEUL
  {0xC0FE, 0xC80A}, //10970 #HANGUL SYLLABLE CIEUC EO RIEULMIEUM
  {0xC141, 0xD564}, //10971 #HANGUL SYLLABLE HIEUH A RIEULSIOS
  {0xC142, 0xD566}, //10972 #HANGUL SYLLABLE HIEUH A RIEULPHIEUPH
  {0xC143, 0xD567}, //10973 #HANGUL SYLLABLE HIEUH A RIEULHIEUH
  {0xC144, 0xD56A}, //10974 #HANGUL SYLLABLE HIEUH A PIEUPSIOS
  {0xC145, 0xD56C}, //10975 #HANGUL SYLLABLE HIEUH A SSANGSIOS
  {0xC146, 0xD56E}, //10976 #HANGUL SYLLABLE HIEUH A CIEUC
  {0xC147, 0xD56F}, //10977 #HANGUL SYLLABLE HIEUH A CHIEUCH
  {0xC148, 0xD570}, //10978 #HANGUL SYLLABLE HIEUH A KHIEUKH
  {0xC149, 0xD571}, //10979 #HANGUL SYLLABLE HIEUH A THIEUTH
  {0xC14A, 0xD572}, //10980 #HANGUL SYLLABLE HIEUH A PHIEUPH
  {0xC14B, 0xD573}, //10981 #HANGUL SYLLABLE HIEUH A HIEUH
  {0xC14C, 0xD576}, //10982 #HANGUL SYLLABLE HIEUH AE SSANGKIYEOK
  {0xC14D, 0xD577}, //10983 #HANGUL SYLLABLE HIEUH AE KIYEOKSIOS
  {0xC14E, 0xD579}, //10984 #HANGUL SYLLABLE HIEUH AE NIEUNCIEUC
  {0xC14F, 0xD57A}, //10985 #HANGUL SYLLABLE HIEUH AE NIEUNHIEUH
  {0xC150, 0xD57B}, //10986 #HANGUL SYLLABLE HIEUH AE TIKEUT
  {0xC151, 0xD57D}, //10987 #HANGUL SYLLABLE HIEUH AE RIEULKIYEOK
  {0xC152, 0xD57E}, //10988 #HANGUL SYLLABLE HIEUH AE RIEULMIEUM
  {0xC153, 0xD57F}, //10989 #HANGUL SYLLABLE HIEUH AE RIEULPIEUP
  {0xC154, 0xD580}, //10990 #HANGUL SYLLABLE HIEUH AE RIEULSIOS
  {0xC155, 0xD581}, //10991 #HANGUL SYLLABLE HIEUH AE RIEULTHIEUTH
  {0xC156, 0xD582}, //10992 #HANGUL SYLLABLE HIEUH AE RIEULPHIEUPH
  {0xC157, 0xD583}, //10993 #HANGUL SYLLABLE HIEUH AE RIEULHIEUH
  {0xC158, 0xD586}, //10994 #HANGUL SYLLABLE HIEUH AE PIEUPSIOS
  {0xC159, 0xD58A}, //10995 #HANGUL SYLLABLE HIEUH AE CIEUC
  {0xC15A, 0xD58B}, //10996 #HANGUL SYLLABLE HIEUH AE CHIEUCH
  {0xC161, 0xD58C}, //10997 #HANGUL SYLLABLE HIEUH AE KHIEUKH
  {0xC162, 0xD58D}, //10998 #HANGUL SYLLABLE HIEUH AE THIEUTH
  {0xC163, 0xD58E}, //10999 #HANGUL SYLLABLE HIEUH AE PHIEUPH
  {0xC164, 0xD58F}, //11000 #HANGUL SYLLABLE HIEUH AE HIEUH
  {0xC165, 0xD591}, //11001 #HANGUL SYLLABLE HIEUH YA KIYEOK
  {0xC166, 0xD592}, //11002 #HANGUL SYLLABLE HIEUH YA SSANGKIYEOK
  {0xC167, 0xD593}, //11003 #HANGUL SYLLABLE HIEUH YA KIYEOKSIOS
  {0xC168, 0xD594}, //11004 #HANGUL SYLLABLE HIEUH YA NIEUN
  {0xC169, 0xD595}, //11005 #HANGUL SYLLABLE HIEUH YA NIEUNCIEUC
  {0xC16A, 0xD596}, //11006 #HANGUL SYLLABLE HIEUH YA NIEUNHIEUH
  {0xC16B, 0xD597}, //11007 #HANGUL SYLLABLE HIEUH YA TIKEUT
  {0xC16C, 0xD598}, //11008 #HANGUL SYLLABLE HIEUH YA RIEUL
  {0xC16D, 0xD599}, //11009 #HANGUL SYLLABLE HIEUH YA RIEULKIYEOK
  {0xC16E, 0xD59A}, //11010 #HANGUL SYLLABLE HIEUH YA RIEULMIEUM
  {0xC16F, 0xD59B}, //11011 #HANGUL SYLLABLE HIEUH YA RIEULPIEUP
  {0xC170, 0xD59C}, //11012 #HANGUL SYLLABLE HIEUH YA RIEULSIOS
  {0xC171, 0xD59D}, //11013 #HANGUL SYLLABLE HIEUH YA RIEULTHIEUTH
  {0xC172, 0xD59E}, //11014 #HANGUL SYLLABLE HIEUH YA RIEULPHIEUPH
  {0xC173, 0xD59F}, //11015 #HANGUL SYLLABLE HIEUH YA RIEULHIEUH
  {0xC174, 0xD5A0}, //11016 #HANGUL SYLLABLE HIEUH YA MIEUM
  {0xC175, 0xD5A1}, //11017 #HANGUL SYLLABLE HIEUH YA PIEUP
  {0xC176, 0xD5A2}, //11018 #HANGUL SYLLABLE HIEUH YA PIEUPSIOS
  {0xC177, 0xD5A3}, //11019 #HANGUL SYLLABLE HIEUH YA SIOS
  {0xC178, 0xD5A4}, //11020 #HANGUL SYLLABLE HIEUH YA SSANGSIOS
  {0xC179, 0xD5A6}, //11021 #HANGUL SYLLABLE HIEUH YA CIEUC
  {0xC17A, 0xD5A7}, //11022 #HANGUL SYLLABLE HIEUH YA CHIEUCH
  {0xC181, 0xD5A8}, //11023 #HANGUL SYLLABLE HIEUH YA KHIEUKH
  {0xC182, 0xD5A9}, //11024 #HANGUL SYLLABLE HIEUH YA THIEUTH
  {0xC183, 0xD5AA}, //11025 #HANGUL SYLLABLE HIEUH YA PHIEUPH
  {0xC184, 0xD5AB}, //11026 #HANGUL SYLLABLE HIEUH YA HIEUH
  {0xC185, 0xD5AC}, //11027 #HANGUL SYLLABLE HIEUH YAE
  {0xC186, 0xD5AD}, //11028 #HANGUL SYLLABLE HIEUH YAE KIYEOK
  {0xC187, 0xD5AE}, //11029 #HANGUL SYLLABLE HIEUH YAE SSANGKIYEOK
  {0xC188, 0xD5AF}, //11030 #HANGUL SYLLABLE HIEUH YAE KIYEOKSIOS
  {0xC189, 0xD5B0}, //11031 #HANGUL SYLLABLE HIEUH YAE NIEUN
  {0xC18A, 0xD5B1}, //11032 #HANGUL SYLLABLE HIEUH YAE NIEUNCIEUC
  {0xC18B, 0xD5B2}, //11033 #HANGUL SYLLABLE HIEUH YAE NIEUNHIEUH
  {0xC18C, 0xD5B3}, //11034 #HANGUL SYLLABLE HIEUH YAE TIKEUT
  {0xC18D, 0xD5B4}, //11035 #HANGUL SYLLABLE HIEUH YAE RIEUL
  {0xC18E, 0xD5B5}, //11036 #HANGUL SYLLABLE HIEUH YAE RIEULKIYEOK
  {0xC18F, 0xD5B6}, //11037 #HANGUL SYLLABLE HIEUH YAE RIEULMIEUM
  {0xC190, 0xD5B7}, //11038 #HANGUL SYLLABLE HIEUH YAE RIEULPIEUP
  {0xC191, 0xD5B8}, //11039 #HANGUL SYLLABLE HIEUH YAE RIEULSIOS
  {0xC192, 0xD5B9}, //11040 #HANGUL SYLLABLE HIEUH YAE RIEULTHIEUTH
  {0xC193, 0xD5BA}, //11041 #HANGUL SYLLABLE HIEUH YAE RIEULPHIEUPH
  {0xC194, 0xD5BB}, //11042 #HANGUL SYLLABLE HIEUH YAE RIEULHIEUH
  {0xC195, 0xD5BC}, //11043 #HANGUL SYLLABLE HIEUH YAE MIEUM
  {0xC196, 0xD5BD}, //11044 #HANGUL SYLLABLE HIEUH YAE PIEUP
  {0xC197, 0xD5BE}, //11045 #HANGUL SYLLABLE HIEUH YAE PIEUPSIOS
  {0xC198, 0xD5BF}, //11046 #HANGUL SYLLABLE HIEUH YAE SIOS
  {0xC199, 0xD5C0}, //11047 #HANGUL SYLLABLE HIEUH YAE SSANGSIOS
  {0xC19A, 0xD5C1}, //11048 #HANGUL SYLLABLE HIEUH YAE IEUNG
  {0xC19B, 0xD5C2}, //11049 #HANGUL SYLLABLE HIEUH YAE CIEUC
  {0xC19C, 0xD5C3}, //11050 #HANGUL SYLLABLE HIEUH YAE CHIEUCH
  {0xC19D, 0xD5C4}, //11051 #HANGUL SYLLABLE HIEUH YAE KHIEUKH
  {0xC19E, 0xD5C5}, //11052 #HANGUL SYLLABLE HIEUH YAE THIEUTH
  {0xC19F, 0xD5C6}, //11053 #HANGUL SYLLABLE HIEUH YAE PHIEUPH
  {0xC1A0, 0xD5C7}, //11054 #HANGUL SYLLABLE HIEUH YAE HIEUH
  {0xC1A1, 0xC810}, //11055 #HANGUL SYLLABLE CIEUC EO MIEUM
  {0xC1A2, 0xC811}, //11056 #HANGUL SYLLABLE CIEUC EO PIEUP
  {0xC1A3, 0xC813}, //11057 #HANGUL SYLLABLE CIEUC EO SIOS
  {0xC1A4, 0xC815}, //11058 #HANGUL SYLLABLE CIEUC EO IEUNG
  {0xC1A5, 0xC816}, //11059 #HANGUL SYLLABLE CIEUC EO CIEUC
  {0xC1A6, 0xC81C}, //11060 #HANGUL SYLLABLE CIEUC E
  {0xC1A7, 0xC81D}, //11061 #HANGUL SYLLABLE CIEUC E KIYEOK
  {0xC1A8, 0xC820}, //11062 #HANGUL SYLLABLE CIEUC E NIEUN
  {0xC1A9, 0xC824}, //11063 #HANGUL SYLLABLE CIEUC E RIEUL
  {0xC1AA, 0xC82C}, //11064 #HANGUL SYLLABLE CIEUC E MIEUM
  {0xC1AB, 0xC82D}, //11065 #HANGUL SYLLABLE CIEUC E PIEUP
  {0xC1AC, 0xC82F}, //11066 #HANGUL SYLLABLE CIEUC E SIOS
  {0xC1AD, 0xC831}, //11067 #HANGUL SYLLABLE CIEUC E IEUNG
  {0xC1AE, 0xC838}, //11068 #HANGUL SYLLABLE CIEUC YEO
  {0xC1AF, 0xC83C}, //11069 #HANGUL SYLLABLE CIEUC YEO NIEUN
  {0xC1B0, 0xC840}, //11070 #HANGUL SYLLABLE CIEUC YEO RIEUL
  {0xC1B1, 0xC848}, //11071 #HANGUL SYLLABLE CIEUC YEO MIEUM
  {0xC1B2, 0xC849}, //11072 #HANGUL SYLLABLE CIEUC YEO PIEUP
  {0xC1B3, 0xC84C}, //11073 #HANGUL SYLLABLE CIEUC YEO SSANGSIOS
  {0xC1B4, 0xC84D}, //11074 #HANGUL SYLLABLE CIEUC YEO IEUNG
  {0xC1B5, 0xC854}, //11075 #HANGUL SYLLABLE CIEUC YE
  {0xC1B6, 0xC870}, //11076 #HANGUL SYLLABLE CIEUC O
  {0xC1B7, 0xC871}, //11077 #HANGUL SYLLABLE CIEUC O KIYEOK
  {0xC1B8, 0xC874}, //11078 #HANGUL SYLLABLE CIEUC O NIEUN
  {0xC1B9, 0xC878}, //11079 #HANGUL SYLLABLE CIEUC O RIEUL
  {0xC1BA, 0xC87A}, //11080 #HANGUL SYLLABLE CIEUC O RIEULMIEUM
  {0xC1BB, 0xC880}, //11081 #HANGUL SYLLABLE CIEUC O MIEUM
  {0xC1BC, 0xC881}, //11082 #HANGUL SYLLABLE CIEUC O PIEUP
  {0xC1BD, 0xC883}, //11083 #HANGUL SYLLABLE CIEUC O SIOS
  {0xC1BE, 0xC885}, //11084 #HANGUL SYLLABLE CIEUC O IEUNG
  {0xC1BF, 0xC886}, //11085 #HANGUL SYLLABLE CIEUC O CIEUC
  {0xC1C0, 0xC887}, //11086 #HANGUL SYLLABLE CIEUC O CHIEUCH
  {0xC1C1, 0xC88B}, //11087 #HANGUL SYLLABLE CIEUC O HIEUH
  {0xC1C2, 0xC88C}, //11088 #HANGUL SYLLABLE CIEUC WA
  {0xC1C3, 0xC88D}, //11089 #HANGUL SYLLABLE CIEUC WA KIYEOK
  {0xC1C4, 0xC894}, //11090 #HANGUL SYLLABLE CIEUC WA RIEUL
  {0xC1C5, 0xC89D}, //11091 #HANGUL SYLLABLE CIEUC WA PIEUP
  {0xC1C6, 0xC89F}, //11092 #HANGUL SYLLABLE CIEUC WA SIOS
  {0xC1C7, 0xC8A1}, //11093 #HANGUL SYLLABLE CIEUC WA IEUNG
  {0xC1C8, 0xC8A8}, //11094 #HANGUL SYLLABLE CIEUC WAE
  {0xC1C9, 0xC8BC}, //11095 #HANGUL SYLLABLE CIEUC WAE SSANGSIOS
  {0xC1CA, 0xC8BD}, //11096 #HANGUL SYLLABLE CIEUC WAE IEUNG
  {0xC1CB, 0xC8C4}, //11097 #HANGUL SYLLABLE CIEUC OE
  {0xC1CC, 0xC8C8}, //11098 #HANGUL SYLLABLE CIEUC OE NIEUN
  {0xC1CD, 0xC8CC}, //11099 #HANGUL SYLLABLE CIEUC OE RIEUL
  {0xC1CE, 0xC8D4}, //11100 #HANGUL SYLLABLE CIEUC OE MIEUM
  {0xC1CF, 0xC8D5}, //11101 #HANGUL SYLLABLE CIEUC OE PIEUP
  {0xC1D0, 0xC8D7}, //11102 #HANGUL SYLLABLE CIEUC OE SIOS
  {0xC1D1, 0xC8D9}, //11103 #HANGUL SYLLABLE CIEUC OE IEUNG
  {0xC1D2, 0xC8E0}, //11104 #HANGUL SYLLABLE CIEUC YO
  {0xC1D3, 0xC8E1}, //11105 #HANGUL SYLLABLE CIEUC YO KIYEOK
  {0xC1D4, 0xC8E4}, //11106 #HANGUL SYLLABLE CIEUC YO NIEUN
  {0xC1D5, 0xC8F5}, //11107 #HANGUL SYLLABLE CIEUC YO IEUNG
  {0xC1D6, 0xC8FC}, //11108 #HANGUL SYLLABLE CIEUC U
  {0xC1D7, 0xC8FD}, //11109 #HANGUL SYLLABLE CIEUC U KIYEOK
  {0xC1D8, 0xC900}, //11110 #HANGUL SYLLABLE CIEUC U NIEUN
  {0xC1D9, 0xC904}, //11111 #HANGUL SYLLABLE CIEUC U RIEUL
  {0xC1DA, 0xC905}, //11112 #HANGUL SYLLABLE CIEUC U RIEULKIYEOK
  {0xC1DB, 0xC906}, //11113 #HANGUL SYLLABLE CIEUC U RIEULMIEUM
  {0xC1DC, 0xC90C}, //11114 #HANGUL SYLLABLE CIEUC U MIEUM
  {0xC1DD, 0xC90D}, //11115 #HANGUL SYLLABLE CIEUC U PIEUP
  {0xC1DE, 0xC90F}, //11116 #HANGUL SYLLABLE CIEUC U SIOS
  {0xC1DF, 0xC911}, //11117 #HANGUL SYLLABLE CIEUC U IEUNG
  {0xC1E0, 0xC918}, //11118 #HANGUL SYLLABLE CIEUC WEO
  {0xC1E1, 0xC92C}, //11119 #HANGUL SYLLABLE CIEUC WEO SSANGSIOS
  {0xC1E2, 0xC934}, //11120 #HANGUL SYLLABLE CIEUC WE
  {0xC1E3, 0xC950}, //11121 #HANGUL SYLLABLE CIEUC WI
  {0xC1E4, 0xC951}, //11122 #HANGUL SYLLABLE CIEUC WI KIYEOK
  {0xC1E5, 0xC954}, //11123 #HANGUL SYLLABLE CIEUC WI NIEUN
  {0xC1E6, 0xC958}, //11124 #HANGUL SYLLABLE CIEUC WI RIEUL
  {0xC1E7, 0xC960}, //11125 #HANGUL SYLLABLE CIEUC WI MIEUM
  {0xC1E8, 0xC961}, //11126 #HANGUL SYLLABLE CIEUC WI PIEUP
  {0xC1E9, 0xC963}, //11127 #HANGUL SYLLABLE CIEUC WI SIOS
  {0xC1EA, 0xC96C}, //11128 #HANGUL SYLLABLE CIEUC YU
  {0xC1EB, 0xC970}, //11129 #HANGUL SYLLABLE CIEUC YU NIEUN
  {0xC1EC, 0xC974}, //11130 #HANGUL SYLLABLE CIEUC YU RIEUL
  {0xC1ED, 0xC97C}, //11131 #HANGUL SYLLABLE CIEUC YU MIEUM
  {0xC1EE, 0xC988}, //11132 #HANGUL SYLLABLE CIEUC EU
  {0xC1EF, 0xC989}, //11133 #HANGUL SYLLABLE CIEUC EU KIYEOK
  {0xC1F0, 0xC98C}, //11134 #HANGUL SYLLABLE CIEUC EU NIEUN
  {0xC1F1, 0xC990}, //11135 #HANGUL SYLLABLE CIEUC EU RIEUL
  {0xC1F2, 0xC998}, //11136 #HANGUL SYLLABLE CIEUC EU MIEUM
  {0xC1F3, 0xC999}, //11137 #HANGUL SYLLABLE CIEUC EU PIEUP
  {0xC1F4, 0xC99B}, //11138 #HANGUL SYLLABLE CIEUC EU SIOS
  {0xC1F5, 0xC99D}, //11139 #HANGUL SYLLABLE CIEUC EU IEUNG
  {0xC1F6, 0xC9C0}, //11140 #HANGUL SYLLABLE CIEUC I
  {0xC1F7, 0xC9C1}, //11141 #HANGUL SYLLABLE CIEUC I KIYEOK
  {0xC1F8, 0xC9C4}, //11142 #HANGUL SYLLABLE CIEUC I NIEUN
  {0xC1F9, 0xC9C7}, //11143 #HANGUL SYLLABLE CIEUC I TIKEUT
  {0xC1FA, 0xC9C8}, //11144 #HANGUL SYLLABLE CIEUC I RIEUL
  {0xC1FB, 0xC9CA}, //11145 #HANGUL SYLLABLE CIEUC I RIEULMIEUM
  {0xC1FC, 0xC9D0}, //11146 #HANGUL SYLLABLE CIEUC I MIEUM
  {0xC1FD, 0xC9D1}, //11147 #HANGUL SYLLABLE CIEUC I PIEUP
  {0xC1FE, 0xC9D3}, //11148 #HANGUL SYLLABLE CIEUC I SIOS
  {0xC241, 0xD5CA}, //11149 #HANGUL SYLLABLE HIEUH EO SSANGKIYEOK
  {0xC242, 0xD5CB}, //11150 #HANGUL SYLLABLE HIEUH EO KIYEOKSIOS
  {0xC243, 0xD5CD}, //11151 #HANGUL SYLLABLE HIEUH EO NIEUNCIEUC
  {0xC244, 0xD5CE}, //11152 #HANGUL SYLLABLE HIEUH EO NIEUNHIEUH
  {0xC245, 0xD5CF}, //11153 #HANGUL SYLLABLE HIEUH EO TIKEUT
  {0xC246, 0xD5D1}, //11154 #HANGUL SYLLABLE HIEUH EO RIEULKIYEOK
  {0xC247, 0xD5D3}, //11155 #HANGUL SYLLABLE HIEUH EO RIEULPIEUP
  {0xC248, 0xD5D4}, //11156 #HANGUL SYLLABLE HIEUH EO RIEULSIOS
  {0xC249, 0xD5D5}, //11157 #HANGUL SYLLABLE HIEUH EO RIEULTHIEUTH
  {0xC24A, 0xD5D6}, //11158 #HANGUL SYLLABLE HIEUH EO RIEULPHIEUPH
  {0xC24B, 0xD5D7}, //11159 #HANGUL SYLLABLE HIEUH EO RIEULHIEUH
  {0xC24C, 0xD5DA}, //11160 #HANGUL SYLLABLE HIEUH EO PIEUPSIOS
  {0xC24D, 0xD5DC}, //11161 #HANGUL SYLLABLE HIEUH EO SSANGSIOS
  {0xC24E, 0xD5DE}, //11162 #HANGUL SYLLABLE HIEUH EO CIEUC
  {0xC24F, 0xD5DF}, //11163 #HANGUL SYLLABLE HIEUH EO CHIEUCH
  {0xC250, 0xD5E0}, //11164 #HANGUL SYLLABLE HIEUH EO KHIEUKH
  {0xC251, 0xD5E1}, //11165 #HANGUL SYLLABLE HIEUH EO THIEUTH
  {0xC252, 0xD5E2}, //11166 #HANGUL SYLLABLE HIEUH EO PHIEUPH
  {0xC253, 0xD5E3}, //11167 #HANGUL SYLLABLE HIEUH EO HIEUH
  {0xC254, 0xD5E6}, //11168 #HANGUL SYLLABLE HIEUH E SSANGKIYEOK
  {0xC255, 0xD5E7}, //11169 #HANGUL SYLLABLE HIEUH E KIYEOKSIOS
  {0xC256, 0xD5E9}, //11170 #HANGUL SYLLABLE HIEUH E NIEUNCIEUC
  {0xC257, 0xD5EA}, //11171 #HANGUL SYLLABLE HIEUH E NIEUNHIEUH
  {0xC258, 0xD5EB}, //11172 #HANGUL SYLLABLE HIEUH E TIKEUT
  {0xC259, 0xD5ED}, //11173 #HANGUL SYLLABLE HIEUH E RIEULKIYEOK
  {0xC25A, 0xD5EE}, //11174 #HANGUL SYLLABLE HIEUH E RIEULMIEUM
  {0xC261, 0xD5EF}, //11175 #HANGUL SYLLABLE HIEUH E RIEULPIEUP
  {0xC262, 0xD5F0}, //11176 #HANGUL SYLLABLE HIEUH E RIEULSIOS
  {0xC263, 0xD5F1}, //11177 #HANGUL SYLLABLE HIEUH E RIEULTHIEUTH
  {0xC264, 0xD5F2}, //11178 #HANGUL SYLLABLE HIEUH E RIEULPHIEUPH
  {0xC265, 0xD5F3}, //11179 #HANGUL SYLLABLE HIEUH E RIEULHIEUH
  {0xC266, 0xD5F6}, //11180 #HANGUL SYLLABLE HIEUH E PIEUPSIOS
  {0xC267, 0xD5F8}, //11181 #HANGUL SYLLABLE HIEUH E SSANGSIOS
  {0xC268, 0xD5FA}, //11182 #HANGUL SYLLABLE HIEUH E CIEUC
  {0xC269, 0xD5FB}, //11183 #HANGUL SYLLABLE HIEUH E CHIEUCH
  {0xC26A, 0xD5FC}, //11184 #HANGUL SYLLABLE HIEUH E KHIEUKH
  {0xC26B, 0xD5FD}, //11185 #HANGUL SYLLABLE HIEUH E THIEUTH
  {0xC26C, 0xD5FE}, //11186 #HANGUL SYLLABLE HIEUH E PHIEUPH
  {0xC26D, 0xD5FF}, //11187 #HANGUL SYLLABLE HIEUH E HIEUH
  {0xC26E, 0xD602}, //11188 #HANGUL SYLLABLE HIEUH YEO SSANGKIYEOK
  {0xC26F, 0xD603}, //11189 #HANGUL SYLLABLE HIEUH YEO KIYEOKSIOS
  {0xC270, 0xD605}, //11190 #HANGUL SYLLABLE HIEUH YEO NIEUNCIEUC
  {0xC271, 0xD606}, //11191 #HANGUL SYLLABLE HIEUH YEO NIEUNHIEUH
  {0xC272, 0xD607}, //11192 #HANGUL SYLLABLE HIEUH YEO TIKEUT
  {0xC273, 0xD609}, //11193 #HANGUL SYLLABLE HIEUH YEO RIEULKIYEOK
  {0xC274, 0xD60A}, //11194 #HANGUL SYLLABLE HIEUH YEO RIEULMIEUM
  {0xC275, 0xD60B}, //11195 #HANGUL SYLLABLE HIEUH YEO RIEULPIEUP
  {0xC276, 0xD60C}, //11196 #HANGUL SYLLABLE HIEUH YEO RIEULSIOS
  {0xC277, 0xD60D}, //11197 #HANGUL SYLLABLE HIEUH YEO RIEULTHIEUTH
  {0xC278, 0xD60E}, //11198 #HANGUL SYLLABLE HIEUH YEO RIEULPHIEUPH
  {0xC279, 0xD60F}, //11199 #HANGUL SYLLABLE HIEUH YEO RIEULHIEUH
  {0xC27A, 0xD612}, //11200 #HANGUL SYLLABLE HIEUH YEO PIEUPSIOS
  {0xC281, 0xD616}, //11201 #HANGUL SYLLABLE HIEUH YEO CIEUC
  {0xC282, 0xD617}, //11202 #HANGUL SYLLABLE HIEUH YEO CHIEUCH
  {0xC283, 0xD618}, //11203 #HANGUL SYLLABLE HIEUH YEO KHIEUKH
  {0xC284, 0xD619}, //11204 #HANGUL SYLLABLE HIEUH YEO THIEUTH
  {0xC285, 0xD61A}, //11205 #HANGUL SYLLABLE HIEUH YEO PHIEUPH
  {0xC286, 0xD61B}, //11206 #HANGUL SYLLABLE HIEUH YEO HIEUH
  {0xC287, 0xD61D}, //11207 #HANGUL SYLLABLE HIEUH YE KIYEOK
  {0xC288, 0xD61E}, //11208 #HANGUL SYLLABLE HIEUH YE SSANGKIYEOK
  {0xC289, 0xD61F}, //11209 #HANGUL SYLLABLE HIEUH YE KIYEOKSIOS
  {0xC28A, 0xD621}, //11210 #HANGUL SYLLABLE HIEUH YE NIEUNCIEUC
  {0xC28B, 0xD622}, //11211 #HANGUL SYLLABLE HIEUH YE NIEUNHIEUH
  {0xC28C, 0xD623}, //11212 #HANGUL SYLLABLE HIEUH YE TIKEUT
  {0xC28D, 0xD625}, //11213 #HANGUL SYLLABLE HIEUH YE RIEULKIYEOK
  {0xC28E, 0xD626}, //11214 #HANGUL SYLLABLE HIEUH YE RIEULMIEUM
  {0xC28F, 0xD627}, //11215 #HANGUL SYLLABLE HIEUH YE RIEULPIEUP
  {0xC290, 0xD628}, //11216 #HANGUL SYLLABLE HIEUH YE RIEULSIOS
  {0xC291, 0xD629}, //11217 #HANGUL SYLLABLE HIEUH YE RIEULTHIEUTH
  {0xC292, 0xD62A}, //11218 #HANGUL SYLLABLE HIEUH YE RIEULPHIEUPH
  {0xC293, 0xD62B}, //11219 #HANGUL SYLLABLE HIEUH YE RIEULHIEUH
  {0xC294, 0xD62C}, //11220 #HANGUL SYLLABLE HIEUH YE MIEUM
  {0xC295, 0xD62E}, //11221 #HANGUL SYLLABLE HIEUH YE PIEUPSIOS
  {0xC296, 0xD62F}, //11222 #HANGUL SYLLABLE HIEUH YE SIOS
  {0xC297, 0xD630}, //11223 #HANGUL SYLLABLE HIEUH YE SSANGSIOS
  {0xC298, 0xD631}, //11224 #HANGUL SYLLABLE HIEUH YE IEUNG
  {0xC299, 0xD632}, //11225 #HANGUL SYLLABLE HIEUH YE CIEUC
  {0xC29A, 0xD633}, //11226 #HANGUL SYLLABLE HIEUH YE CHIEUCH
  {0xC29B, 0xD634}, //11227 #HANGUL SYLLABLE HIEUH YE KHIEUKH
  {0xC29C, 0xD635}, //11228 #HANGUL SYLLABLE HIEUH YE THIEUTH
  {0xC29D, 0xD636}, //11229 #HANGUL SYLLABLE HIEUH YE PHIEUPH
  {0xC29E, 0xD637}, //11230 #HANGUL SYLLABLE HIEUH YE HIEUH
  {0xC29F, 0xD63A}, //11231 #HANGUL SYLLABLE HIEUH O SSANGKIYEOK
  {0xC2A0, 0xD63B}, //11232 #HANGUL SYLLABLE HIEUH O KIYEOKSIOS
  {0xC2A1, 0xC9D5}, //11233 #HANGUL SYLLABLE CIEUC I IEUNG
  {0xC2A2, 0xC9D6}, //11234 #HANGUL SYLLABLE CIEUC I CIEUC
  {0xC2A3, 0xC9D9}, //11235 #HANGUL SYLLABLE CIEUC I THIEUTH
  {0xC2A4, 0xC9DA}, //11236 #HANGUL SYLLABLE CIEUC I PHIEUPH
  {0xC2A5, 0xC9DC}, //11237 #HANGUL SYLLABLE SSANGCIEUC A
  {0xC2A6, 0xC9DD}, //11238 #HANGUL SYLLABLE SSANGCIEUC A KIYEOK
  {0xC2A7, 0xC9E0}, //11239 #HANGUL SYLLABLE SSANGCIEUC A NIEUN
  {0xC2A8, 0xC9E2}, //11240 #HANGUL SYLLABLE SSANGCIEUC A NIEUNHIEUH
  {0xC2A9, 0xC9E4}, //11241 #HANGUL SYLLABLE SSANGCIEUC A RIEUL
  {0xC2AA, 0xC9E7}, //11242 #HANGUL SYLLABLE SSANGCIEUC A RIEULPIEUP
  {0xC2AB, 0xC9EC}, //11243 #HANGUL SYLLABLE SSANGCIEUC A MIEUM
  {0xC2AC, 0xC9ED}, //11244 #HANGUL SYLLABLE SSANGCIEUC A PIEUP
  {0xC2AD, 0xC9EF}, //11245 #HANGUL SYLLABLE SSANGCIEUC A SIOS
  {0xC2AE, 0xC9F0}, //11246 #HANGUL SYLLABLE SSANGCIEUC A SSANGSIOS
  {0xC2AF, 0xC9F1}, //11247 #HANGUL SYLLABLE SSANGCIEUC A IEUNG
  {0xC2B0, 0xC9F8}, //11248 #HANGUL SYLLABLE SSANGCIEUC AE
  {0xC2B1, 0xC9F9}, //11249 #HANGUL SYLLABLE SSANGCIEUC AE KIYEOK
  {0xC2B2, 0xC9FC}, //11250 #HANGUL SYLLABLE SSANGCIEUC AE NIEUN
  {0xC2B3, 0xCA00}, //11251 #HANGUL SYLLABLE SSANGCIEUC AE RIEUL
  {0xC2B4, 0xCA08}, //11252 #HANGUL SYLLABLE SSANGCIEUC AE MIEUM
  {0xC2B5, 0xCA09}, //11253 #HANGUL SYLLABLE SSANGCIEUC AE PIEUP
  {0xC2B6, 0xCA0B}, //11254 #HANGUL SYLLABLE SSANGCIEUC AE SIOS
  {0xC2B7, 0xCA0C}, //11255 #HANGUL SYLLABLE SSANGCIEUC AE SSANGSIOS
  {0xC2B8, 0xCA0D}, //11256 #HANGUL SYLLABLE SSANGCIEUC AE IEUNG
  {0xC2B9, 0xCA14}, //11257 #HANGUL SYLLABLE SSANGCIEUC YA
  {0xC2BA, 0xCA18}, //11258 #HANGUL SYLLABLE SSANGCIEUC YA NIEUN
  {0xC2BB, 0xCA29}, //11259 #HANGUL SYLLABLE SSANGCIEUC YA IEUNG
  {0xC2BC, 0xCA4C}, //11260 #HANGUL SYLLABLE SSANGCIEUC EO
  {0xC2BD, 0xCA4D}, //11261 #HANGUL SYLLABLE SSANGCIEUC EO KIYEOK
  {0xC2BE, 0xCA50}, //11262 #HANGUL SYLLABLE SSANGCIEUC EO NIEUN
  {0xC2BF, 0xCA54}, //11263 #HANGUL SYLLABLE SSANGCIEUC EO RIEUL
  {0xC2C0, 0xCA5C}, //11264 #HANGUL SYLLABLE SSANGCIEUC EO MIEUM
  {0xC2C1, 0xCA5D}, //11265 #HANGUL SYLLABLE SSANGCIEUC EO PIEUP
  {0xC2C2, 0xCA5F}, //11266 #HANGUL SYLLABLE SSANGCIEUC EO SIOS
  {0xC2C3, 0xCA60}, //11267 #HANGUL SYLLABLE SSANGCIEUC EO SSANGSIOS
  {0xC2C4, 0xCA61}, //11268 #HANGUL SYLLABLE SSANGCIEUC EO IEUNG
  {0xC2C5, 0xCA68}, //11269 #HANGUL SYLLABLE SSANGCIEUC E
  {0xC2C6, 0xCA7D}, //11270 #HANGUL SYLLABLE SSANGCIEUC E IEUNG
  {0xC2C7, 0xCA84}, //11271 #HANGUL SYLLABLE SSANGCIEUC YEO
  {0xC2C8, 0xCA98}, //11272 #HANGUL SYLLABLE SSANGCIEUC YEO SSANGSIOS
  {0xC2C9, 0xCABC}, //11273 #HANGUL SYLLABLE SSANGCIEUC O
  {0xC2CA, 0xCABD}, //11274 #HANGUL SYLLABLE SSANGCIEUC O KIYEOK
  {0xC2CB, 0xCAC0}, //11275 #HANGUL SYLLABLE SSANGCIEUC O NIEUN
  {0xC2CC, 0xCAC4}, //11276 #HANGUL SYLLABLE SSANGCIEUC O RIEUL
  {0xC2CD, 0xCACC}, //11277 #HANGUL SYLLABLE SSANGCIEUC O MIEUM
  {0xC2CE, 0xCACD}, //11278 #HANGUL SYLLABLE SSANGCIEUC O PIEUP
  {0xC2CF, 0xCACF}, //11279 #HANGUL SYLLABLE SSANGCIEUC O SIOS
  {0xC2D0, 0xCAD1}, //11280 #HANGUL SYLLABLE SSANGCIEUC O IEUNG
  {0xC2D1, 0xCAD3}, //11281 #HANGUL SYLLABLE SSANGCIEUC O CHIEUCH
  {0xC2D2, 0xCAD8}, //11282 #HANGUL SYLLABLE SSANGCIEUC WA
  {0xC2D3, 0xCAD9}, //11283 #HANGUL SYLLABLE SSANGCIEUC WA KIYEOK
  {0xC2D4, 0xCAE0}, //11284 #HANGUL SYLLABLE SSANGCIEUC WA RIEUL
  {0xC2D5, 0xCAEC}, //11285 #HANGUL SYLLABLE SSANGCIEUC WA SSANGSIOS
  {0xC2D6, 0xCAF4}, //11286 #HANGUL SYLLABLE SSANGCIEUC WAE
  {0xC2D7, 0xCB08}, //11287 #HANGUL SYLLABLE SSANGCIEUC WAE SSANGSIOS
  {0xC2D8, 0xCB10}, //11288 #HANGUL SYLLABLE SSANGCIEUC OE
  {0xC2D9, 0xCB14}, //11289 #HANGUL SYLLABLE SSANGCIEUC OE NIEUN
  {0xC2DA, 0xCB18}, //11290 #HANGUL SYLLABLE SSANGCIEUC OE RIEUL
  {0xC2DB, 0xCB20}, //11291 #HANGUL SYLLABLE SSANGCIEUC OE MIEUM
  {0xC2DC, 0xCB21}, //11292 #HANGUL SYLLABLE SSANGCIEUC OE PIEUP
  {0xC2DD, 0xCB41}, //11293 #HANGUL SYLLABLE SSANGCIEUC YO IEUNG
  {0xC2DE, 0xCB48}, //11294 #HANGUL SYLLABLE SSANGCIEUC U
  {0xC2DF, 0xCB49}, //11295 #HANGUL SYLLABLE SSANGCIEUC U KIYEOK
  {0xC2E0, 0xCB4C}, //11296 #HANGUL SYLLABLE SSANGCIEUC U NIEUN
  {0xC2E1, 0xCB50}, //11297 #HANGUL SYLLABLE SSANGCIEUC U RIEUL
  {0xC2E2, 0xCB58}, //11298 #HANGUL SYLLABLE SSANGCIEUC U MIEUM
  {0xC2E3, 0xCB59}, //11299 #HANGUL SYLLABLE SSANGCIEUC U PIEUP
  {0xC2E4, 0xCB5D}, //11300 #HANGUL SYLLABLE SSANGCIEUC U IEUNG
  {0xC2E5, 0xCB64}, //11301 #HANGUL SYLLABLE SSANGCIEUC WEO
  {0xC2E6, 0xCB78}, //11302 #HANGUL SYLLABLE SSANGCIEUC WEO SSANGSIOS
  {0xC2E7, 0xCB79}, //11303 #HANGUL SYLLABLE SSANGCIEUC WEO IEUNG
  {0xC2E8, 0xCB9C}, //11304 #HANGUL SYLLABLE SSANGCIEUC WI
  {0xC2E9, 0xCBB8}, //11305 #HANGUL SYLLABLE SSANGCIEUC YU
  {0xC2EA, 0xCBD4}, //11306 #HANGUL SYLLABLE SSANGCIEUC EU
  {0xC2EB, 0xCBE4}, //11307 #HANGUL SYLLABLE SSANGCIEUC EU MIEUM
  {0xC2EC, 0xCBE7}, //11308 #HANGUL SYLLABLE SSANGCIEUC EU SIOS
  {0xC2ED, 0xCBE9}, //11309 #HANGUL SYLLABLE SSANGCIEUC EU IEUNG
  {0xC2EE, 0xCC0C}, //11310 #HANGUL SYLLABLE SSANGCIEUC I
  {0xC2EF, 0xCC0D}, //11311 #HANGUL SYLLABLE SSANGCIEUC I KIYEOK
  {0xC2F0, 0xCC10}, //11312 #HANGUL SYLLABLE SSANGCIEUC I NIEUN
  {0xC2F1, 0xCC14}, //11313 #HANGUL SYLLABLE SSANGCIEUC I RIEUL
  {0xC2F2, 0xCC1C}, //11314 #HANGUL SYLLABLE SSANGCIEUC I MIEUM
  {0xC2F3, 0xCC1D}, //11315 #HANGUL SYLLABLE SSANGCIEUC I PIEUP
  {0xC2F4, 0xCC21}, //11316 #HANGUL SYLLABLE SSANGCIEUC I IEUNG
  {0xC2F5, 0xCC22}, //11317 #HANGUL SYLLABLE SSANGCIEUC I CIEUC
  {0xC2F6, 0xCC27}, //11318 #HANGUL SYLLABLE SSANGCIEUC I HIEUH
  {0xC2F7, 0xCC28}, //11319 #HANGUL SYLLABLE CHIEUCH A
  {0xC2F8, 0xCC29}, //11320 #HANGUL SYLLABLE CHIEUCH A KIYEOK
  {0xC2F9, 0xCC2C}, //11321 #HANGUL SYLLABLE CHIEUCH A NIEUN
  {0xC2FA, 0xCC2E}, //11322 #HANGUL SYLLABLE CHIEUCH A NIEUNHIEUH
  {0xC2FB, 0xCC30}, //11323 #HANGUL SYLLABLE CHIEUCH A RIEUL
  {0xC2FC, 0xCC38}, //11324 #HANGUL SYLLABLE CHIEUCH A MIEUM
  {0xC2FD, 0xCC39}, //11325 #HANGUL SYLLABLE CHIEUCH A PIEUP
  {0xC2FE, 0xCC3B}, //11326 #HANGUL SYLLABLE CHIEUCH A SIOS
  {0xC341, 0xD63D}, //11327 #HANGUL SYLLABLE HIEUH O NIEUNCIEUC
  {0xC342, 0xD63E}, //11328 #HANGUL SYLLABLE HIEUH O NIEUNHIEUH
  {0xC343, 0xD63F}, //11329 #HANGUL SYLLABLE HIEUH O TIKEUT
  {0xC344, 0xD641}, //11330 #HANGUL SYLLABLE HIEUH O RIEULKIYEOK
  {0xC345, 0xD642}, //11331 #HANGUL SYLLABLE HIEUH O RIEULMIEUM
  {0xC346, 0xD643}, //11332 #HANGUL SYLLABLE HIEUH O RIEULPIEUP
  {0xC347, 0xD644}, //11333 #HANGUL SYLLABLE HIEUH O RIEULSIOS
  {0xC348, 0xD646}, //11334 #HANGUL SYLLABLE HIEUH O RIEULPHIEUPH
  {0xC349, 0xD647}, //11335 #HANGUL SYLLABLE HIEUH O RIEULHIEUH
  {0xC34A, 0xD64A}, //11336 #HANGUL SYLLABLE HIEUH O PIEUPSIOS
  {0xC34B, 0xD64C}, //11337 #HANGUL SYLLABLE HIEUH O SSANGSIOS
  {0xC34C, 0xD64E}, //11338 #HANGUL SYLLABLE HIEUH O CIEUC
  {0xC34D, 0xD64F}, //11339 #HANGUL SYLLABLE HIEUH O CHIEUCH
  {0xC34E, 0xD650}, //11340 #HANGUL SYLLABLE HIEUH O KHIEUKH
  {0xC34F, 0xD652}, //11341 #HANGUL SYLLABLE HIEUH O PHIEUPH
  {0xC350, 0xD653}, //11342 #HANGUL SYLLABLE HIEUH O HIEUH
  {0xC351, 0xD656}, //11343 #HANGUL SYLLABLE HIEUH WA SSANGKIYEOK
  {0xC352, 0xD657}, //11344 #HANGUL SYLLABLE HIEUH WA KIYEOKSIOS
  {0xC353, 0xD659}, //11345 #HANGUL SYLLABLE HIEUH WA NIEUNCIEUC
  {0xC354, 0xD65A}, //11346 #HANGUL SYLLABLE HIEUH WA NIEUNHIEUH
  {0xC355, 0xD65B}, //11347 #HANGUL SYLLABLE HIEUH WA TIKEUT
  {0xC356, 0xD65D}, //11348 #HANGUL SYLLABLE HIEUH WA RIEULKIYEOK
  {0xC357, 0xD65E}, //11349 #HANGUL SYLLABLE HIEUH WA RIEULMIEUM
  {0xC358, 0xD65F}, //11350 #HANGUL SYLLABLE HIEUH WA RIEULPIEUP
  {0xC359, 0xD660}, //11351 #HANGUL SYLLABLE HIEUH WA RIEULSIOS
  {0xC35A, 0xD661}, //11352 #HANGUL SYLLABLE HIEUH WA RIEULTHIEUTH
  {0xC361, 0xD662}, //11353 #HANGUL SYLLABLE HIEUH WA RIEULPHIEUPH
  {0xC362, 0xD663}, //11354 #HANGUL SYLLABLE HIEUH WA RIEULHIEUH
  {0xC363, 0xD664}, //11355 #HANGUL SYLLABLE HIEUH WA MIEUM
  {0xC364, 0xD665}, //11356 #HANGUL SYLLABLE HIEUH WA PIEUP
  {0xC365, 0xD666}, //11357 #HANGUL SYLLABLE HIEUH WA PIEUPSIOS
  {0xC366, 0xD668}, //11358 #HANGUL SYLLABLE HIEUH WA SSANGSIOS
  {0xC367, 0xD66A}, //11359 #HANGUL SYLLABLE HIEUH WA CIEUC
  {0xC368, 0xD66B}, //11360 #HANGUL SYLLABLE HIEUH WA CHIEUCH
  {0xC369, 0xD66C}, //11361 #HANGUL SYLLABLE HIEUH WA KHIEUKH
  {0xC36A, 0xD66D}, //11362 #HANGUL SYLLABLE HIEUH WA THIEUTH
  {0xC36B, 0xD66E}, //11363 #HANGUL SYLLABLE HIEUH WA PHIEUPH
  {0xC36C, 0xD66F}, //11364 #HANGUL SYLLABLE HIEUH WA HIEUH
  {0xC36D, 0xD672}, //11365 #HANGUL SYLLABLE HIEUH WAE SSANGKIYEOK
  {0xC36E, 0xD673}, //11366 #HANGUL SYLLABLE HIEUH WAE KIYEOKSIOS
  {0xC36F, 0xD675}, //11367 #HANGUL SYLLABLE HIEUH WAE NIEUNCIEUC
  {0xC370, 0xD676}, //11368 #HANGUL SYLLABLE HIEUH WAE NIEUNHIEUH
  {0xC371, 0xD677}, //11369 #HANGUL SYLLABLE HIEUH WAE TIKEUT
  {0xC372, 0xD678}, //11370 #HANGUL SYLLABLE HIEUH WAE RIEUL
  {0xC373, 0xD679}, //11371 #HANGUL SYLLABLE HIEUH WAE RIEULKIYEOK
  {0xC374, 0xD67A}, //11372 #HANGUL SYLLABLE HIEUH WAE RIEULMIEUM
  {0xC375, 0xD67B}, //11373 #HANGUL SYLLABLE HIEUH WAE RIEULPIEUP
  {0xC376, 0xD67C}, //11374 #HANGUL SYLLABLE HIEUH WAE RIEULSIOS
  {0xC377, 0xD67D}, //11375 #HANGUL SYLLABLE HIEUH WAE RIEULTHIEUTH
  {0xC378, 0xD67E}, //11376 #HANGUL SYLLABLE HIEUH WAE RIEULPHIEUPH
  {0xC379, 0xD67F}, //11377 #HANGUL SYLLABLE HIEUH WAE RIEULHIEUH
  {0xC37A, 0xD680}, //11378 #HANGUL SYLLABLE HIEUH WAE MIEUM
  {0xC381, 0xD681}, //11379 #HANGUL SYLLABLE HIEUH WAE PIEUP
  {0xC382, 0xD682}, //11380 #HANGUL SYLLABLE HIEUH WAE PIEUPSIOS
  {0xC383, 0xD684}, //11381 #HANGUL SYLLABLE HIEUH WAE SSANGSIOS
  {0xC384, 0xD686}, //11382 #HANGUL SYLLABLE HIEUH WAE CIEUC
  {0xC385, 0xD687}, //11383 #HANGUL SYLLABLE HIEUH WAE CHIEUCH
  {0xC386, 0xD688}, //11384 #HANGUL SYLLABLE HIEUH WAE KHIEUKH
  {0xC387, 0xD689}, //11385 #HANGUL SYLLABLE HIEUH WAE THIEUTH
  {0xC388, 0xD68A}, //11386 #HANGUL SYLLABLE HIEUH WAE PHIEUPH
  {0xC389, 0xD68B}, //11387 #HANGUL SYLLABLE HIEUH WAE HIEUH
  {0xC38A, 0xD68E}, //11388 #HANGUL SYLLABLE HIEUH OE SSANGKIYEOK
  {0xC38B, 0xD68F}, //11389 #HANGUL SYLLABLE HIEUH OE KIYEOKSIOS
  {0xC38C, 0xD691}, //11390 #HANGUL SYLLABLE HIEUH OE NIEUNCIEUC
  {0xC38D, 0xD692}, //11391 #HANGUL SYLLABLE HIEUH OE NIEUNHIEUH
  {0xC38E, 0xD693}, //11392 #HANGUL SYLLABLE HIEUH OE TIKEUT
  {0xC38F, 0xD695}, //11393 #HANGUL SYLLABLE HIEUH OE RIEULKIYEOK
  {0xC390, 0xD696}, //11394 #HANGUL SYLLABLE HIEUH OE RIEULMIEUM
  {0xC391, 0xD697}, //11395 #HANGUL SYLLABLE HIEUH OE RIEULPIEUP
  {0xC392, 0xD698}, //11396 #HANGUL SYLLABLE HIEUH OE RIEULSIOS
  {0xC393, 0xD699}, //11397 #HANGUL SYLLABLE HIEUH OE RIEULTHIEUTH
  {0xC394, 0xD69A}, //11398 #HANGUL SYLLABLE HIEUH OE RIEULPHIEUPH
  {0xC395, 0xD69B}, //11399 #HANGUL SYLLABLE HIEUH OE RIEULHIEUH
  {0xC396, 0xD69C}, //11400 #HANGUL SYLLABLE HIEUH OE MIEUM
  {0xC397, 0xD69E}, //11401 #HANGUL SYLLABLE HIEUH OE PIEUPSIOS
  {0xC398, 0xD6A0}, //11402 #HANGUL SYLLABLE HIEUH OE SSANGSIOS
  {0xC399, 0xD6A2}, //11403 #HANGUL SYLLABLE HIEUH OE CIEUC
  {0xC39A, 0xD6A3}, //11404 #HANGUL SYLLABLE HIEUH OE CHIEUCH
  {0xC39B, 0xD6A4}, //11405 #HANGUL SYLLABLE HIEUH OE KHIEUKH
  {0xC39C, 0xD6A5}, //11406 #HANGUL SYLLABLE HIEUH OE THIEUTH
  {0xC39D, 0xD6A6}, //11407 #HANGUL SYLLABLE HIEUH OE PHIEUPH
  {0xC39E, 0xD6A7}, //11408 #HANGUL SYLLABLE HIEUH OE HIEUH
  {0xC39F, 0xD6A9}, //11409 #HANGUL SYLLABLE HIEUH YO KIYEOK
  {0xC3A0, 0xD6AA}, //11410 #HANGUL SYLLABLE HIEUH YO SSANGKIYEOK
  {0xC3A1, 0xCC3C}, //11411 #HANGUL SYLLABLE CHIEUCH A SSANGSIOS
  {0xC3A2, 0xCC3D}, //11412 #HANGUL SYLLABLE CHIEUCH A IEUNG
  {0xC3A3, 0xCC3E}, //11413 #HANGUL SYLLABLE CHIEUCH A CIEUC
  {0xC3A4, 0xCC44}, //11414 #HANGUL SYLLABLE CHIEUCH AE
  {0xC3A5, 0xCC45}, //11415 #HANGUL SYLLABLE CHIEUCH AE KIYEOK
  {0xC3A6, 0xCC48}, //11416 #HANGUL SYLLABLE CHIEUCH AE NIEUN
  {0xC3A7, 0xCC4C}, //11417 #HANGUL SYLLABLE CHIEUCH AE RIEUL
  {0xC3A8, 0xCC54}, //11418 #HANGUL SYLLABLE CHIEUCH AE MIEUM
  {0xC3A9, 0xCC55}, //11419 #HANGUL SYLLABLE CHIEUCH AE PIEUP
  {0xC3AA, 0xCC57}, //11420 #HANGUL SYLLABLE CHIEUCH AE SIOS
  {0xC3AB, 0xCC58}, //11421 #HANGUL SYLLABLE CHIEUCH AE SSANGSIOS
  {0xC3AC, 0xCC59}, //11422 #HANGUL SYLLABLE CHIEUCH AE IEUNG
  {0xC3AD, 0xCC60}, //11423 #HANGUL SYLLABLE CHIEUCH YA
  {0xC3AE, 0xCC64}, //11424 #HANGUL SYLLABLE CHIEUCH YA NIEUN
  {0xC3AF, 0xCC66}, //11425 #HANGUL SYLLABLE CHIEUCH YA NIEUNHIEUH
  {0xC3B0, 0xCC68}, //11426 #HANGUL SYLLABLE CHIEUCH YA RIEUL
  {0xC3B1, 0xCC70}, //11427 #HANGUL SYLLABLE CHIEUCH YA MIEUM
  {0xC3B2, 0xCC75}, //11428 #HANGUL SYLLABLE CHIEUCH YA IEUNG
  {0xC3B3, 0xCC98}, //11429 #HANGUL SYLLABLE CHIEUCH EO
  {0xC3B4, 0xCC99}, //11430 #HANGUL SYLLABLE CHIEUCH EO KIYEOK
  {0xC3B5, 0xCC9C}, //11431 #HANGUL SYLLABLE CHIEUCH EO NIEUN
  {0xC3B6, 0xCCA0}, //11432 #HANGUL SYLLABLE CHIEUCH EO RIEUL
  {0xC3B7, 0xCCA8}, //11433 #HANGUL SYLLABLE CHIEUCH EO MIEUM
  {0xC3B8, 0xCCA9}, //11434 #HANGUL SYLLABLE CHIEUCH EO PIEUP
  {0xC3B9, 0xCCAB}, //11435 #HANGUL SYLLABLE CHIEUCH EO SIOS
  {0xC3BA, 0xCCAC}, //11436 #HANGUL SYLLABLE CHIEUCH EO SSANGSIOS
  {0xC3BB, 0xCCAD}, //11437 #HANGUL SYLLABLE CHIEUCH EO IEUNG
  {0xC3BC, 0xCCB4}, //11438 #HANGUL SYLLABLE CHIEUCH E
  {0xC3BD, 0xCCB5}, //11439 #HANGUL SYLLABLE CHIEUCH E KIYEOK
  {0xC3BE, 0xCCB8}, //11440 #HANGUL SYLLABLE CHIEUCH E NIEUN
  {0xC3BF, 0xCCBC}, //11441 #HANGUL SYLLABLE CHIEUCH E RIEUL
  {0xC3C0, 0xCCC4}, //11442 #HANGUL SYLLABLE CHIEUCH E MIEUM
  {0xC3C1, 0xCCC5}, //11443 #HANGUL SYLLABLE CHIEUCH E PIEUP
  {0xC3C2, 0xCCC7}, //11444 #HANGUL SYLLABLE CHIEUCH E SIOS
  {0xC3C3, 0xCCC9}, //11445 #HANGUL SYLLABLE CHIEUCH E IEUNG
  {0xC3C4, 0xCCD0}, //11446 #HANGUL SYLLABLE CHIEUCH YEO
  {0xC3C5, 0xCCD4}, //11447 #HANGUL SYLLABLE CHIEUCH YEO NIEUN
  {0xC3C6, 0xCCE4}, //11448 #HANGUL SYLLABLE CHIEUCH YEO SSANGSIOS
  {0xC3C7, 0xCCEC}, //11449 #HANGUL SYLLABLE CHIEUCH YE
  {0xC3C8, 0xCCF0}, //11450 #HANGUL SYLLABLE CHIEUCH YE NIEUN
  {0xC3C9, 0xCD01}, //11451 #HANGUL SYLLABLE CHIEUCH YE IEUNG
  {0xC3CA, 0xCD08}, //11452 #HANGUL SYLLABLE CHIEUCH O
  {0xC3CB, 0xCD09}, //11453 #HANGUL SYLLABLE CHIEUCH O KIYEOK
  {0xC3CC, 0xCD0C}, //11454 #HANGUL SYLLABLE CHIEUCH O NIEUN
  {0xC3CD, 0xCD10}, //11455 #HANGUL SYLLABLE CHIEUCH O RIEUL
  {0xC3CE, 0xCD18}, //11456 #HANGUL SYLLABLE CHIEUCH O MIEUM
  {0xC3CF, 0xCD19}, //11457 #HANGUL SYLLABLE CHIEUCH O PIEUP
  {0xC3D0, 0xCD1B}, //11458 #HANGUL SYLLABLE CHIEUCH O SIOS
  {0xC3D1, 0xCD1D}, //11459 #HANGUL SYLLABLE CHIEUCH O IEUNG
  {0xC3D2, 0xCD24}, //11460 #HANGUL SYLLABLE CHIEUCH WA
  {0xC3D3, 0xCD28}, //11461 #HANGUL SYLLABLE CHIEUCH WA NIEUN
  {0xC3D4, 0xCD2C}, //11462 #HANGUL SYLLABLE CHIEUCH WA RIEUL
  {0xC3D5, 0xCD39}, //11463 #HANGUL SYLLABLE CHIEUCH WA IEUNG
  {0xC3D6, 0xCD5C}, //11464 #HANGUL SYLLABLE CHIEUCH OE
  {0xC3D7, 0xCD60}, //11465 #HANGUL SYLLABLE CHIEUCH OE NIEUN
  {0xC3D8, 0xCD64}, //11466 #HANGUL SYLLABLE CHIEUCH OE RIEUL
  {0xC3D9, 0xCD6C}, //11467 #HANGUL SYLLABLE CHIEUCH OE MIEUM
  {0xC3DA, 0xCD6D}, //11468 #HANGUL SYLLABLE CHIEUCH OE PIEUP
  {0xC3DB, 0xCD6F}, //11469 #HANGUL SYLLABLE CHIEUCH OE SIOS
  {0xC3DC, 0xCD71}, //11470 #HANGUL SYLLABLE CHIEUCH OE IEUNG
  {0xC3DD, 0xCD78}, //11471 #HANGUL SYLLABLE CHIEUCH YO
  {0xC3DE, 0xCD88}, //11472 #HANGUL SYLLABLE CHIEUCH YO MIEUM
  {0xC3DF, 0xCD94}, //11473 #HANGUL SYLLABLE CHIEUCH U
  {0xC3E0, 0xCD95}, //11474 #HANGUL SYLLABLE CHIEUCH U KIYEOK
  {0xC3E1, 0xCD98}, //11475 #HANGUL SYLLABLE CHIEUCH U NIEUN
  {0xC3E2, 0xCD9C}, //11476 #HANGUL SYLLABLE CHIEUCH U RIEUL
  {0xC3E3, 0xCDA4}, //11477 #HANGUL SYLLABLE CHIEUCH U MIEUM
  {0xC3E4, 0xCDA5}, //11478 #HANGUL SYLLABLE CHIEUCH U PIEUP
  {0xC3E5, 0xCDA7}, //11479 #HANGUL SYLLABLE CHIEUCH U SIOS
  {0xC3E6, 0xCDA9}, //11480 #HANGUL SYLLABLE CHIEUCH U IEUNG
  {0xC3E7, 0xCDB0}, //11481 #HANGUL SYLLABLE CHIEUCH WEO
  {0xC3E8, 0xCDC4}, //11482 #HANGUL SYLLABLE CHIEUCH WEO SSANGSIOS
  {0xC3E9, 0xCDCC}, //11483 #HANGUL SYLLABLE CHIEUCH WE
  {0xC3EA, 0xCDD0}, //11484 #HANGUL SYLLABLE CHIEUCH WE NIEUN
  {0xC3EB, 0xCDE8}, //11485 #HANGUL SYLLABLE CHIEUCH WI
  {0xC3EC, 0xCDEC}, //11486 #HANGUL SYLLABLE CHIEUCH WI NIEUN
  {0xC3ED, 0xCDF0}, //11487 #HANGUL SYLLABLE CHIEUCH WI RIEUL
  {0xC3EE, 0xCDF8}, //11488 #HANGUL SYLLABLE CHIEUCH WI MIEUM
  {0xC3EF, 0xCDF9}, //11489 #HANGUL SYLLABLE CHIEUCH WI PIEUP
  {0xC3F0, 0xCDFB}, //11490 #HANGUL SYLLABLE CHIEUCH WI SIOS
  {0xC3F1, 0xCDFD}, //11491 #HANGUL SYLLABLE CHIEUCH WI IEUNG
  {0xC3F2, 0xCE04}, //11492 #HANGUL SYLLABLE CHIEUCH YU
  {0xC3F3, 0xCE08}, //11493 #HANGUL SYLLABLE CHIEUCH YU NIEUN
  {0xC3F4, 0xCE0C}, //11494 #HANGUL SYLLABLE CHIEUCH YU RIEUL
  {0xC3F5, 0xCE14}, //11495 #HANGUL SYLLABLE CHIEUCH YU MIEUM
  {0xC3F6, 0xCE19}, //11496 #HANGUL SYLLABLE CHIEUCH YU IEUNG
  {0xC3F7, 0xCE20}, //11497 #HANGUL SYLLABLE CHIEUCH EU
  {0xC3F8, 0xCE21}, //11498 #HANGUL SYLLABLE CHIEUCH EU KIYEOK
  {0xC3F9, 0xCE24}, //11499 #HANGUL SYLLABLE CHIEUCH EU NIEUN
  {0xC3FA, 0xCE28}, //11500 #HANGUL SYLLABLE CHIEUCH EU RIEUL
  {0xC3FB, 0xCE30}, //11501 #HANGUL SYLLABLE CHIEUCH EU MIEUM
  {0xC3FC, 0xCE31}, //11502 #HANGUL SYLLABLE CHIEUCH EU PIEUP
  {0xC3FD, 0xCE33}, //11503 #HANGUL SYLLABLE CHIEUCH EU SIOS
  {0xC3FE, 0xCE35}, //11504 #HANGUL SYLLABLE CHIEUCH EU IEUNG
  {0xC441, 0xD6AB}, //11505 #HANGUL SYLLABLE HIEUH YO KIYEOKSIOS
  {0xC442, 0xD6AD}, //11506 #HANGUL SYLLABLE HIEUH YO NIEUNCIEUC
  {0xC443, 0xD6AE}, //11507 #HANGUL SYLLABLE HIEUH YO NIEUNHIEUH
  {0xC444, 0xD6AF}, //11508 #HANGUL SYLLABLE HIEUH YO TIKEUT
  {0xC445, 0xD6B1}, //11509 #HANGUL SYLLABLE HIEUH YO RIEULKIYEOK
  {0xC446, 0xD6B2}, //11510 #HANGUL SYLLABLE HIEUH YO RIEULMIEUM
  {0xC447, 0xD6B3}, //11511 #HANGUL SYLLABLE HIEUH YO RIEULPIEUP
  {0xC448, 0xD6B4}, //11512 #HANGUL SYLLABLE HIEUH YO RIEULSIOS
  {0xC449, 0xD6B5}, //11513 #HANGUL SYLLABLE HIEUH YO RIEULTHIEUTH
  {0xC44A, 0xD6B6}, //11514 #HANGUL SYLLABLE HIEUH YO RIEULPHIEUPH
  {0xC44B, 0xD6B7}, //11515 #HANGUL SYLLABLE HIEUH YO RIEULHIEUH
  {0xC44C, 0xD6B8}, //11516 #HANGUL SYLLABLE HIEUH YO MIEUM
  {0xC44D, 0xD6BA}, //11517 #HANGUL SYLLABLE HIEUH YO PIEUPSIOS
  {0xC44E, 0xD6BC}, //11518 #HANGUL SYLLABLE HIEUH YO SSANGSIOS
  {0xC44F, 0xD6BD}, //11519 #HANGUL SYLLABLE HIEUH YO IEUNG
  {0xC450, 0xD6BE}, //11520 #HANGUL SYLLABLE HIEUH YO CIEUC
  {0xC451, 0xD6BF}, //11521 #HANGUL SYLLABLE HIEUH YO CHIEUCH
  {0xC452, 0xD6C0}, //11522 #HANGUL SYLLABLE HIEUH YO KHIEUKH
  {0xC453, 0xD6C1}, //11523 #HANGUL SYLLABLE HIEUH YO THIEUTH
  {0xC454, 0xD6C2}, //11524 #HANGUL SYLLABLE HIEUH YO PHIEUPH
  {0xC455, 0xD6C3}, //11525 #HANGUL SYLLABLE HIEUH YO HIEUH
  {0xC456, 0xD6C6}, //11526 #HANGUL SYLLABLE HIEUH U SSANGKIYEOK
  {0xC457, 0xD6C7}, //11527 #HANGUL SYLLABLE HIEUH U KIYEOKSIOS
  {0xC458, 0xD6C9}, //11528 #HANGUL SYLLABLE HIEUH U NIEUNCIEUC
  {0xC459, 0xD6CA}, //11529 #HANGUL SYLLABLE HIEUH U NIEUNHIEUH
  {0xC45A, 0xD6CB}, //11530 #HANGUL SYLLABLE HIEUH U TIKEUT
  {0xC461, 0xD6CD}, //11531 #HANGUL SYLLABLE HIEUH U RIEULKIYEOK
  {0xC462, 0xD6CE}, //11532 #HANGUL SYLLABLE HIEUH U RIEULMIEUM
  {0xC463, 0xD6CF}, //11533 #HANGUL SYLLABLE HIEUH U RIEULPIEUP
  {0xC464, 0xD6D0}, //11534 #HANGUL SYLLABLE HIEUH U RIEULSIOS
  {0xC465, 0xD6D2}, //11535 #HANGUL SYLLABLE HIEUH U RIEULPHIEUPH
  {0xC466, 0xD6D3}, //11536 #HANGUL SYLLABLE HIEUH U RIEULHIEUH
  {0xC467, 0xD6D5}, //11537 #HANGUL SYLLABLE HIEUH U PIEUP
  {0xC468, 0xD6D6}, //11538 #HANGUL SYLLABLE HIEUH U PIEUPSIOS
  {0xC469, 0xD6D8}, //11539 #HANGUL SYLLABLE HIEUH U SSANGSIOS
  {0xC46A, 0xD6DA}, //11540 #HANGUL SYLLABLE HIEUH U CIEUC
  {0xC46B, 0xD6DB}, //11541 #HANGUL SYLLABLE HIEUH U CHIEUCH
  {0xC46C, 0xD6DC}, //11542 #HANGUL SYLLABLE HIEUH U KHIEUKH
  {0xC46D, 0xD6DD}, //11543 #HANGUL SYLLABLE HIEUH U THIEUTH
  {0xC46E, 0xD6DE}, //11544 #HANGUL SYLLABLE HIEUH U PHIEUPH
  {0xC46F, 0xD6DF}, //11545 #HANGUL SYLLABLE HIEUH U HIEUH
  {0xC470, 0xD6E1}, //11546 #HANGUL SYLLABLE HIEUH WEO KIYEOK
  {0xC471, 0xD6E2}, //11547 #HANGUL SYLLABLE HIEUH WEO SSANGKIYEOK
  {0xC472, 0xD6E3}, //11548 #HANGUL SYLLABLE HIEUH WEO KIYEOKSIOS
  {0xC473, 0xD6E5}, //11549 #HANGUL SYLLABLE HIEUH WEO NIEUNCIEUC
  {0xC474, 0xD6E6}, //11550 #HANGUL SYLLABLE HIEUH WEO NIEUNHIEUH
  {0xC475, 0xD6E7}, //11551 #HANGUL SYLLABLE HIEUH WEO TIKEUT
  {0xC476, 0xD6E9}, //11552 #HANGUL SYLLABLE HIEUH WEO RIEULKIYEOK
  {0xC477, 0xD6EA}, //11553 #HANGUL SYLLABLE HIEUH WEO RIEULMIEUM
  {0xC478, 0xD6EB}, //11554 #HANGUL SYLLABLE HIEUH WEO RIEULPIEUP
  {0xC479, 0xD6EC}, //11555 #HANGUL SYLLABLE HIEUH WEO RIEULSIOS
  {0xC47A, 0xD6ED}, //11556 #HANGUL SYLLABLE HIEUH WEO RIEULTHIEUTH
  {0xC481, 0xD6EE}, //11557 #HANGUL SYLLABLE HIEUH WEO RIEULPHIEUPH
  {0xC482, 0xD6EF}, //11558 #HANGUL SYLLABLE HIEUH WEO RIEULHIEUH
  {0xC483, 0xD6F1}, //11559 #HANGUL SYLLABLE HIEUH WEO PIEUP
  {0xC484, 0xD6F2}, //11560 #HANGUL SYLLABLE HIEUH WEO PIEUPSIOS
  {0xC485, 0xD6F3}, //11561 #HANGUL SYLLABLE HIEUH WEO SIOS
  {0xC486, 0xD6F4}, //11562 #HANGUL SYLLABLE HIEUH WEO SSANGSIOS
  {0xC487, 0xD6F6}, //11563 #HANGUL SYLLABLE HIEUH WEO CIEUC
  {0xC488, 0xD6F7}, //11564 #HANGUL SYLLABLE HIEUH WEO CHIEUCH
  {0xC489, 0xD6F8}, //11565 #HANGUL SYLLABLE HIEUH WEO KHIEUKH
  {0xC48A, 0xD6F9}, //11566 #HANGUL SYLLABLE HIEUH WEO THIEUTH
  {0xC48B, 0xD6FA}, //11567 #HANGUL SYLLABLE HIEUH WEO PHIEUPH
  {0xC48C, 0xD6FB}, //11568 #HANGUL SYLLABLE HIEUH WEO HIEUH
  {0xC48D, 0xD6FE}, //11569 #HANGUL SYLLABLE HIEUH WE SSANGKIYEOK
  {0xC48E, 0xD6FF}, //11570 #HANGUL SYLLABLE HIEUH WE KIYEOKSIOS
  {0xC48F, 0xD701}, //11571 #HANGUL SYLLABLE HIEUH WE NIEUNCIEUC
  {0xC490, 0xD702}, //11572 #HANGUL SYLLABLE HIEUH WE NIEUNHIEUH
  {0xC491, 0xD703}, //11573 #HANGUL SYLLABLE HIEUH WE TIKEUT
  {0xC492, 0xD705}, //11574 #HANGUL SYLLABLE HIEUH WE RIEULKIYEOK
  {0xC493, 0xD706}, //11575 #HANGUL SYLLABLE HIEUH WE RIEULMIEUM
  {0xC494, 0xD707}, //11576 #HANGUL SYLLABLE HIEUH WE RIEULPIEUP
  {0xC495, 0xD708}, //11577 #HANGUL SYLLABLE HIEUH WE RIEULSIOS
  {0xC496, 0xD709}, //11578 #HANGUL SYLLABLE HIEUH WE RIEULTHIEUTH
  {0xC497, 0xD70A}, //11579 #HANGUL SYLLABLE HIEUH WE RIEULPHIEUPH
  {0xC498, 0xD70B}, //11580 #HANGUL SYLLABLE HIEUH WE RIEULHIEUH
  {0xC499, 0xD70C}, //11581 #HANGUL SYLLABLE HIEUH WE MIEUM
  {0xC49A, 0xD70D}, //11582 #HANGUL SYLLABLE HIEUH WE PIEUP
  {0xC49B, 0xD70E}, //11583 #HANGUL SYLLABLE HIEUH WE PIEUPSIOS
  {0xC49C, 0xD70F}, //11584 #HANGUL SYLLABLE HIEUH WE SIOS
  {0xC49D, 0xD710}, //11585 #HANGUL SYLLABLE HIEUH WE SSANGSIOS
  {0xC49E, 0xD712}, //11586 #HANGUL SYLLABLE HIEUH WE CIEUC
  {0xC49F, 0xD713}, //11587 #HANGUL SYLLABLE HIEUH WE CHIEUCH
  {0xC4A0, 0xD714}, //11588 #HANGUL SYLLABLE HIEUH WE KHIEUKH
  {0xC4A1, 0xCE58}, //11589 #HANGUL SYLLABLE CHIEUCH I
  {0xC4A2, 0xCE59}, //11590 #HANGUL SYLLABLE CHIEUCH I KIYEOK
  {0xC4A3, 0xCE5C}, //11591 #HANGUL SYLLABLE CHIEUCH I NIEUN
  {0xC4A4, 0xCE5F}, //11592 #HANGUL SYLLABLE CHIEUCH I TIKEUT
  {0xC4A5, 0xCE60}, //11593 #HANGUL SYLLABLE CHIEUCH I RIEUL
  {0xC4A6, 0xCE61}, //11594 #HANGUL SYLLABLE CHIEUCH I RIEULKIYEOK
  {0xC4A7, 0xCE68}, //11595 #HANGUL SYLLABLE CHIEUCH I MIEUM
  {0xC4A8, 0xCE69}, //11596 #HANGUL SYLLABLE CHIEUCH I PIEUP
  {0xC4A9, 0xCE6B}, //11597 #HANGUL SYLLABLE CHIEUCH I SIOS
  {0xC4AA, 0xCE6D}, //11598 #HANGUL SYLLABLE CHIEUCH I IEUNG
  {0xC4AB, 0xCE74}, //11599 #HANGUL SYLLABLE KHIEUKH A
  {0xC4AC, 0xCE75}, //11600 #HANGUL SYLLABLE KHIEUKH A KIYEOK
  {0xC4AD, 0xCE78}, //11601 #HANGUL SYLLABLE KHIEUKH A NIEUN
  {0xC4AE, 0xCE7C}, //11602 #HANGUL SYLLABLE KHIEUKH A RIEUL
  {0xC4AF, 0xCE84}, //11603 #HANGUL SYLLABLE KHIEUKH A MIEUM
  {0xC4B0, 0xCE85}, //11604 #HANGUL SYLLABLE KHIEUKH A PIEUP
  {0xC4B1, 0xCE87}, //11605 #HANGUL SYLLABLE KHIEUKH A SIOS
  {0xC4B2, 0xCE89}, //11606 #HANGUL SYLLABLE KHIEUKH A IEUNG
  {0xC4B3, 0xCE90}, //11607 #HANGUL SYLLABLE KHIEUKH AE
  {0xC4B4, 0xCE91}, //11608 #HANGUL SYLLABLE KHIEUKH AE KIYEOK
  {0xC4B5, 0xCE94}, //11609 #HANGUL SYLLABLE KHIEUKH AE NIEUN
  {0xC4B6, 0xCE98}, //11610 #HANGUL SYLLABLE KHIEUKH AE RIEUL
  {0xC4B7, 0xCEA0}, //11611 #HANGUL SYLLABLE KHIEUKH AE MIEUM
  {0xC4B8, 0xCEA1}, //11612 #HANGUL SYLLABLE KHIEUKH AE PIEUP
  {0xC4B9, 0xCEA3}, //11613 #HANGUL SYLLABLE KHIEUKH AE SIOS
  {0xC4BA, 0xCEA4}, //11614 #HANGUL SYLLABLE KHIEUKH AE SSANGSIOS
  {0xC4BB, 0xCEA5}, //11615 #HANGUL SYLLABLE KHIEUKH AE IEUNG
  {0xC4BC, 0xCEAC}, //11616 #HANGUL SYLLABLE KHIEUKH YA
  {0xC4BD, 0xCEAD}, //11617 #HANGUL SYLLABLE KHIEUKH YA KIYEOK
  {0xC4BE, 0xCEC1}, //11618 #HANGUL SYLLABLE KHIEUKH YA IEUNG
  {0xC4BF, 0xCEE4}, //11619 #HANGUL SYLLABLE KHIEUKH EO
  {0xC4C0, 0xCEE5}, //11620 #HANGUL SYLLABLE KHIEUKH EO KIYEOK
  {0xC4C1, 0xCEE8}, //11621 #HANGUL SYLLABLE KHIEUKH EO NIEUN
  {0xC4C2, 0xCEEB}, //11622 #HANGUL SYLLABLE KHIEUKH EO TIKEUT
  {0xC4C3, 0xCEEC}, //11623 #HANGUL SYLLABLE KHIEUKH EO RIEUL
  {0xC4C4, 0xCEF4}, //11624 #HANGUL SYLLABLE KHIEUKH EO MIEUM
  {0xC4C5, 0xCEF5}, //11625 #HANGUL SYLLABLE KHIEUKH EO PIEUP
  {0xC4C6, 0xCEF7}, //11626 #HANGUL SYLLABLE KHIEUKH EO SIOS
  {0xC4C7, 0xCEF8}, //11627 #HANGUL SYLLABLE KHIEUKH EO SSANGSIOS
  {0xC4C8, 0xCEF9}, //11628 #HANGUL SYLLABLE KHIEUKH EO IEUNG
  {0xC4C9, 0xCF00}, //11629 #HANGUL SYLLABLE KHIEUKH E
  {0xC4CA, 0xCF01}, //11630 #HANGUL SYLLABLE KHIEUKH E KIYEOK
  {0xC4CB, 0xCF04}, //11631 #HANGUL SYLLABLE KHIEUKH E NIEUN
  {0xC4CC, 0xCF08}, //11632 #HANGUL SYLLABLE KHIEUKH E RIEUL
  {0xC4CD, 0xCF10}, //11633 #HANGUL SYLLABLE KHIEUKH E MIEUM
  {0xC4CE, 0xCF11}, //11634 #HANGUL SYLLABLE KHIEUKH E PIEUP
  {0xC4CF, 0xCF13}, //11635 #HANGUL SYLLABLE KHIEUKH E SIOS
  {0xC4D0, 0xCF15}, //11636 #HANGUL SYLLABLE KHIEUKH E IEUNG
  {0xC4D1, 0xCF1C}, //11637 #HANGUL SYLLABLE KHIEUKH YEO
  {0xC4D2, 0xCF20}, //11638 #HANGUL SYLLABLE KHIEUKH YEO NIEUN
  {0xC4D3, 0xCF24}, //11639 #HANGUL SYLLABLE KHIEUKH YEO RIEUL
  {0xC4D4, 0xCF2C}, //11640 #HANGUL SYLLABLE KHIEUKH YEO MIEUM
  {0xC4D5, 0xCF2D}, //11641 #HANGUL SYLLABLE KHIEUKH YEO PIEUP
  {0xC4D6, 0xCF2F}, //11642 #HANGUL SYLLABLE KHIEUKH YEO SIOS
  {0xC4D7, 0xCF30}, //11643 #HANGUL SYLLABLE KHIEUKH YEO SSANGSIOS
  {0xC4D8, 0xCF31}, //11644 #HANGUL SYLLABLE KHIEUKH YEO IEUNG
  {0xC4D9, 0xCF38}, //11645 #HANGUL SYLLABLE KHIEUKH YE
  {0xC4DA, 0xCF54}, //11646 #HANGUL SYLLABLE KHIEUKH O
  {0xC4DB, 0xCF55}, //11647 #HANGUL SYLLABLE KHIEUKH O KIYEOK
  {0xC4DC, 0xCF58}, //11648 #HANGUL SYLLABLE KHIEUKH O NIEUN
  {0xC4DD, 0xCF5C}, //11649 #HANGUL SYLLABLE KHIEUKH O RIEUL
  {0xC4DE, 0xCF64}, //11650 #HANGUL SYLLABLE KHIEUKH O MIEUM
  {0xC4DF, 0xCF65}, //11651 #HANGUL SYLLABLE KHIEUKH O PIEUP
  {0xC4E0, 0xCF67}, //11652 #HANGUL SYLLABLE KHIEUKH O SIOS
  {0xC4E1, 0xCF69}, //11653 #HANGUL SYLLABLE KHIEUKH O IEUNG
  {0xC4E2, 0xCF70}, //11654 #HANGUL SYLLABLE KHIEUKH WA
  {0xC4E3, 0xCF71}, //11655 #HANGUL SYLLABLE KHIEUKH WA KIYEOK
  {0xC4E4, 0xCF74}, //11656 #HANGUL SYLLABLE KHIEUKH WA NIEUN
  {0xC4E5, 0xCF78}, //11657 #HANGUL SYLLABLE KHIEUKH WA RIEUL
  {0xC4E6, 0xCF80}, //11658 #HANGUL SYLLABLE KHIEUKH WA MIEUM
  {0xC4E7, 0xCF85}, //11659 #HANGUL SYLLABLE KHIEUKH WA IEUNG
  {0xC4E8, 0xCF8C}, //11660 #HANGUL SYLLABLE KHIEUKH WAE
  {0xC4E9, 0xCFA1}, //11661 #HANGUL SYLLABLE KHIEUKH WAE IEUNG
  {0xC4EA, 0xCFA8}, //11662 #HANGUL SYLLABLE KHIEUKH OE
  {0xC4EB, 0xCFB0}, //11663 #HANGUL SYLLABLE KHIEUKH OE RIEUL
  {0xC4EC, 0xCFC4}, //11664 #HANGUL SYLLABLE KHIEUKH YO
  {0xC4ED, 0xCFE0}, //11665 #HANGUL SYLLABLE KHIEUKH U
  {0xC4EE, 0xCFE1}, //11666 #HANGUL SYLLABLE KHIEUKH U KIYEOK
  {0xC4EF, 0xCFE4}, //11667 #HANGUL SYLLABLE KHIEUKH U NIEUN
  {0xC4F0, 0xCFE8}, //11668 #HANGUL SYLLABLE KHIEUKH U RIEUL
  {0xC4F1, 0xCFF0}, //11669 #HANGUL SYLLABLE KHIEUKH U MIEUM
  {0xC4F2, 0xCFF1}, //11670 #HANGUL SYLLABLE KHIEUKH U PIEUP
  {0xC4F3, 0xCFF3}, //11671 #HANGUL SYLLABLE KHIEUKH U SIOS
  {0xC4F4, 0xCFF5}, //11672 #HANGUL SYLLABLE KHIEUKH U IEUNG
  {0xC4F5, 0xCFFC}, //11673 #HANGUL SYLLABLE KHIEUKH WEO
  {0xC4F6, 0xD000}, //11674 #HANGUL SYLLABLE KHIEUKH WEO NIEUN
  {0xC4F7, 0xD004}, //11675 #HANGUL SYLLABLE KHIEUKH WEO RIEUL
  {0xC4F8, 0xD011}, //11676 #HANGUL SYLLABLE KHIEUKH WEO IEUNG
  {0xC4F9, 0xD018}, //11677 #HANGUL SYLLABLE KHIEUKH WE
  {0xC4FA, 0xD02D}, //11678 #HANGUL SYLLABLE KHIEUKH WE IEUNG
  {0xC4FB, 0xD034}, //11679 #HANGUL SYLLABLE KHIEUKH WI
  {0xC4FC, 0xD035}, //11680 #HANGUL SYLLABLE KHIEUKH WI KIYEOK
  {0xC4FD, 0xD038}, //11681 #HANGUL SYLLABLE KHIEUKH WI NIEUN
  {0xC4FE, 0xD03C}, //11682 #HANGUL SYLLABLE KHIEUKH WI RIEUL
  {0xC541, 0xD715}, //11683 #HANGUL SYLLABLE HIEUH WE THIEUTH
  {0xC542, 0xD716}, //11684 #HANGUL SYLLABLE HIEUH WE PHIEUPH
  {0xC543, 0xD717}, //11685 #HANGUL SYLLABLE HIEUH WE HIEUH
  {0xC544, 0xD71A}, //11686 #HANGUL SYLLABLE HIEUH WI SSANGKIYEOK
  {0xC545, 0xD71B}, //11687 #HANGUL SYLLABLE HIEUH WI KIYEOKSIOS
  {0xC546, 0xD71D}, //11688 #HANGUL SYLLABLE HIEUH WI NIEUNCIEUC
  {0xC547, 0xD71E}, //11689 #HANGUL SYLLABLE HIEUH WI NIEUNHIEUH
  {0xC548, 0xD71F}, //11690 #HANGUL SYLLABLE HIEUH WI TIKEUT
  {0xC549, 0xD721}, //11691 #HANGUL SYLLABLE HIEUH WI RIEULKIYEOK
  {0xC54A, 0xD722}, //11692 #HANGUL SYLLABLE HIEUH WI RIEULMIEUM
  {0xC54B, 0xD723}, //11693 #HANGUL SYLLABLE HIEUH WI RIEULPIEUP
  {0xC54C, 0xD724}, //11694 #HANGUL SYLLABLE HIEUH WI RIEULSIOS
  {0xC54D, 0xD725}, //11695 #HANGUL SYLLABLE HIEUH WI RIEULTHIEUTH
  {0xC54E, 0xD726}, //11696 #HANGUL SYLLABLE HIEUH WI RIEULPHIEUPH
  {0xC54F, 0xD727}, //11697 #HANGUL SYLLABLE HIEUH WI RIEULHIEUH
  {0xC550, 0xD72A}, //11698 #HANGUL SYLLABLE HIEUH WI PIEUPSIOS
  {0xC551, 0xD72C}, //11699 #HANGUL SYLLABLE HIEUH WI SSANGSIOS
  {0xC552, 0xD72E}, //11700 #HANGUL SYLLABLE HIEUH WI CIEUC
  {0xC553, 0xD72F}, //11701 #HANGUL SYLLABLE HIEUH WI CHIEUCH
  {0xC554, 0xD730}, //11702 #HANGUL SYLLABLE HIEUH WI KHIEUKH
  {0xC555, 0xD731}, //11703 #HANGUL SYLLABLE HIEUH WI THIEUTH
  {0xC556, 0xD732}, //11704 #HANGUL SYLLABLE HIEUH WI PHIEUPH
  {0xC557, 0xD733}, //11705 #HANGUL SYLLABLE HIEUH WI HIEUH
  {0xC558, 0xD736}, //11706 #HANGUL SYLLABLE HIEUH YU SSANGKIYEOK
  {0xC559, 0xD737}, //11707 #HANGUL SYLLABLE HIEUH YU KIYEOKSIOS
  {0xC55A, 0xD739}, //11708 #HANGUL SYLLABLE HIEUH YU NIEUNCIEUC
  {0xC561, 0xD73A}, //11709 #HANGUL SYLLABLE HIEUH YU NIEUNHIEUH
  {0xC562, 0xD73B}, //11710 #HANGUL SYLLABLE HIEUH YU TIKEUT
  {0xC563, 0xD73D}, //11711 #HANGUL SYLLABLE HIEUH YU RIEULKIYEOK
  {0xC564, 0xD73E}, //11712 #HANGUL SYLLABLE HIEUH YU RIEULMIEUM
  {0xC565, 0xD73F}, //11713 #HANGUL SYLLABLE HIEUH YU RIEULPIEUP
  {0xC566, 0xD740}, //11714 #HANGUL SYLLABLE HIEUH YU RIEULSIOS
  {0xC567, 0xD741}, //11715 #HANGUL SYLLABLE HIEUH YU RIEULTHIEUTH
  {0xC568, 0xD742}, //11716 #HANGUL SYLLABLE HIEUH YU RIEULPHIEUPH
  {0xC569, 0xD743}, //11717 #HANGUL SYLLABLE HIEUH YU RIEULHIEUH
  {0xC56A, 0xD745}, //11718 #HANGUL SYLLABLE HIEUH YU PIEUP
  {0xC56B, 0xD746}, //11719 #HANGUL SYLLABLE HIEUH YU PIEUPSIOS
  {0xC56C, 0xD748}, //11720 #HANGUL SYLLABLE HIEUH YU SSANGSIOS
  {0xC56D, 0xD74A}, //11721 #HANGUL SYLLABLE HIEUH YU CIEUC
  {0xC56E, 0xD74B}, //11722 #HANGUL SYLLABLE HIEUH YU CHIEUCH
  {0xC56F, 0xD74C}, //11723 #HANGUL SYLLABLE HIEUH YU KHIEUKH
  {0xC570, 0xD74D}, //11724 #HANGUL SYLLABLE HIEUH YU THIEUTH
  {0xC571, 0xD74E}, //11725 #HANGUL SYLLABLE HIEUH YU PHIEUPH
  {0xC572, 0xD74F}, //11726 #HANGUL SYLLABLE HIEUH YU HIEUH
  {0xC573, 0xD752}, //11727 #HANGUL SYLLABLE HIEUH EU SSANGKIYEOK
  {0xC574, 0xD753}, //11728 #HANGUL SYLLABLE HIEUH EU KIYEOKSIOS
  {0xC575, 0xD755}, //11729 #HANGUL SYLLABLE HIEUH EU NIEUNCIEUC
  {0xC576, 0xD75A}, //11730 #HANGUL SYLLABLE HIEUH EU RIEULMIEUM
  {0xC577, 0xD75B}, //11731 #HANGUL SYLLABLE HIEUH EU RIEULPIEUP
  {0xC578, 0xD75C}, //11732 #HANGUL SYLLABLE HIEUH EU RIEULSIOS
  {0xC579, 0xD75D}, //11733 #HANGUL SYLLABLE HIEUH EU RIEULTHIEUTH
  {0xC57A, 0xD75E}, //11734 #HANGUL SYLLABLE HIEUH EU RIEULPHIEUPH
  {0xC581, 0xD75F}, //11735 #HANGUL SYLLABLE HIEUH EU RIEULHIEUH
  {0xC582, 0xD762}, //11736 #HANGUL SYLLABLE HIEUH EU PIEUPSIOS
  {0xC583, 0xD764}, //11737 #HANGUL SYLLABLE HIEUH EU SSANGSIOS
  {0xC584, 0xD766}, //11738 #HANGUL SYLLABLE HIEUH EU CIEUC
  {0xC585, 0xD767}, //11739 #HANGUL SYLLABLE HIEUH EU CHIEUCH
  {0xC586, 0xD768}, //11740 #HANGUL SYLLABLE HIEUH EU KHIEUKH
  {0xC587, 0xD76A}, //11741 #HANGUL SYLLABLE HIEUH EU PHIEUPH
  {0xC588, 0xD76B}, //11742 #HANGUL SYLLABLE HIEUH EU HIEUH
  {0xC589, 0xD76D}, //11743 #HANGUL SYLLABLE HIEUH YI KIYEOK
  {0xC58A, 0xD76E}, //11744 #HANGUL SYLLABLE HIEUH YI SSANGKIYEOK
  {0xC58B, 0xD76F}, //11745 #HANGUL SYLLABLE HIEUH YI KIYEOKSIOS
  {0xC58C, 0xD771}, //11746 #HANGUL SYLLABLE HIEUH YI NIEUNCIEUC
  {0xC58D, 0xD772}, //11747 #HANGUL SYLLABLE HIEUH YI NIEUNHIEUH
  {0xC58E, 0xD773}, //11748 #HANGUL SYLLABLE HIEUH YI TIKEUT
  {0xC58F, 0xD775}, //11749 #HANGUL SYLLABLE HIEUH YI RIEULKIYEOK
  {0xC590, 0xD776}, //11750 #HANGUL SYLLABLE HIEUH YI RIEULMIEUM
  {0xC591, 0xD777}, //11751 #HANGUL SYLLABLE HIEUH YI RIEULPIEUP
  {0xC592, 0xD778}, //11752 #HANGUL SYLLABLE HIEUH YI RIEULSIOS
  {0xC593, 0xD779}, //11753 #HANGUL SYLLABLE HIEUH YI RIEULTHIEUTH
  {0xC594, 0xD77A}, //11754 #HANGUL SYLLABLE HIEUH YI RIEULPHIEUPH
  {0xC595, 0xD77B}, //11755 #HANGUL SYLLABLE HIEUH YI RIEULHIEUH
  {0xC596, 0xD77E}, //11756 #HANGUL SYLLABLE HIEUH YI PIEUPSIOS
  {0xC597, 0xD77F}, //11757 #HANGUL SYLLABLE HIEUH YI SIOS
  {0xC598, 0xD780}, //11758 #HANGUL SYLLABLE HIEUH YI SSANGSIOS
  {0xC599, 0xD782}, //11759 #HANGUL SYLLABLE HIEUH YI CIEUC
  {0xC59A, 0xD783}, //11760 #HANGUL SYLLABLE HIEUH YI CHIEUCH
  {0xC59B, 0xD784}, //11761 #HANGUL SYLLABLE HIEUH YI KHIEUKH
  {0xC59C, 0xD785}, //11762 #HANGUL SYLLABLE HIEUH YI THIEUTH
  {0xC59D, 0xD786}, //11763 #HANGUL SYLLABLE HIEUH YI PHIEUPH
  {0xC59E, 0xD787}, //11764 #HANGUL SYLLABLE HIEUH YI HIEUH
  {0xC59F, 0xD78A}, //11765 #HANGUL SYLLABLE HIEUH I SSANGKIYEOK
  {0xC5A0, 0xD78B}, //11766 #HANGUL SYLLABLE HIEUH I KIYEOKSIOS
  {0xC5A1, 0xD044}, //11767 #HANGUL SYLLABLE KHIEUKH WI MIEUM
  {0xC5A2, 0xD045}, //11768 #HANGUL SYLLABLE KHIEUKH WI PIEUP
  {0xC5A3, 0xD047}, //11769 #HANGUL SYLLABLE KHIEUKH WI SIOS
  {0xC5A4, 0xD049}, //11770 #HANGUL SYLLABLE KHIEUKH WI IEUNG
  {0xC5A5, 0xD050}, //11771 #HANGUL SYLLABLE KHIEUKH YU
  {0xC5A6, 0xD054}, //11772 #HANGUL SYLLABLE KHIEUKH YU NIEUN
  {0xC5A7, 0xD058}, //11773 #HANGUL SYLLABLE KHIEUKH YU RIEUL
  {0xC5A8, 0xD060}, //11774 #HANGUL SYLLABLE KHIEUKH YU MIEUM
  {0xC5A9, 0xD06C}, //11775 #HANGUL SYLLABLE KHIEUKH EU
  {0xC5AA, 0xD06D}, //11776 #HANGUL SYLLABLE KHIEUKH EU KIYEOK
  {0xC5AB, 0xD070}, //11777 #HANGUL SYLLABLE KHIEUKH EU NIEUN
  {0xC5AC, 0xD074}, //11778 #HANGUL SYLLABLE KHIEUKH EU RIEUL
  {0xC5AD, 0xD07C}, //11779 #HANGUL SYLLABLE KHIEUKH EU MIEUM
  {0xC5AE, 0xD07D}, //11780 #HANGUL SYLLABLE KHIEUKH EU PIEUP
  {0xC5AF, 0xD081}, //11781 #HANGUL SYLLABLE KHIEUKH EU IEUNG
  {0xC5B0, 0xD0A4}, //11782 #HANGUL SYLLABLE KHIEUKH I
  {0xC5B1, 0xD0A5}, //11783 #HANGUL SYLLABLE KHIEUKH I KIYEOK
  {0xC5B2, 0xD0A8}, //11784 #HANGUL SYLLABLE KHIEUKH I NIEUN
  {0xC5B3, 0xD0AC}, //11785 #HANGUL SYLLABLE KHIEUKH I RIEUL
  {0xC5B4, 0xD0B4}, //11786 #HANGUL SYLLABLE KHIEUKH I MIEUM
  {0xC5B5, 0xD0B5}, //11787 #HANGUL SYLLABLE KHIEUKH I PIEUP
  {0xC5B6, 0xD0B7}, //11788 #HANGUL SYLLABLE KHIEUKH I SIOS
  {0xC5B7, 0xD0B9}, //11789 #HANGUL SYLLABLE KHIEUKH I IEUNG
  {0xC5B8, 0xD0C0}, //11790 #HANGUL SYLLABLE THIEUTH A
  {0xC5B9, 0xD0C1}, //11791 #HANGUL SYLLABLE THIEUTH A KIYEOK
  {0xC5BA, 0xD0C4}, //11792 #HANGUL SYLLABLE THIEUTH A NIEUN
  {0xC5BB, 0xD0C8}, //11793 #HANGUL SYLLABLE THIEUTH A RIEUL
  {0xC5BC, 0xD0C9}, //11794 #HANGUL SYLLABLE THIEUTH A RIEULKIYEOK
  {0xC5BD, 0xD0D0}, //11795 #HANGUL SYLLABLE THIEUTH A MIEUM
  {0xC5BE, 0xD0D1}, //11796 #HANGUL SYLLABLE THIEUTH A PIEUP
  {0xC5BF, 0xD0D3}, //11797 #HANGUL SYLLABLE THIEUTH A SIOS
  {0xC5C0, 0xD0D4}, //11798 #HANGUL SYLLABLE THIEUTH A SSANGSIOS
  {0xC5C1, 0xD0D5}, //11799 #HANGUL SYLLABLE THIEUTH A IEUNG
  {0xC5C2, 0xD0DC}, //11800 #HANGUL SYLLABLE THIEUTH AE
  {0xC5C3, 0xD0DD}, //11801 #HANGUL SYLLABLE THIEUTH AE KIYEOK
  {0xC5C4, 0xD0E0}, //11802 #HANGUL SYLLABLE THIEUTH AE NIEUN
  {0xC5C5, 0xD0E4}, //11803 #HANGUL SYLLABLE THIEUTH AE RIEUL
  {0xC5C6, 0xD0EC}, //11804 #HANGUL SYLLABLE THIEUTH AE MIEUM
  {0xC5C7, 0xD0ED}, //11805 #HANGUL SYLLABLE THIEUTH AE PIEUP
  {0xC5C8, 0xD0EF}, //11806 #HANGUL SYLLABLE THIEUTH AE SIOS
  {0xC5C9, 0xD0F0}, //11807 #HANGUL SYLLABLE THIEUTH AE SSANGSIOS
  {0xC5CA, 0xD0F1}, //11808 #HANGUL SYLLABLE THIEUTH AE IEUNG
  {0xC5CB, 0xD0F8}, //11809 #HANGUL SYLLABLE THIEUTH YA
  {0xC5CC, 0xD10D}, //11810 #HANGUL SYLLABLE THIEUTH YA IEUNG
  {0xC5CD, 0xD130}, //11811 #HANGUL SYLLABLE THIEUTH EO
  {0xC5CE, 0xD131}, //11812 #HANGUL SYLLABLE THIEUTH EO KIYEOK
  {0xC5CF, 0xD134}, //11813 #HANGUL SYLLABLE THIEUTH EO NIEUN
  {0xC5D0, 0xD138}, //11814 #HANGUL SYLLABLE THIEUTH EO RIEUL
  {0xC5D1, 0xD13A}, //11815 #HANGUL SYLLABLE THIEUTH EO RIEULMIEUM
  {0xC5D2, 0xD140}, //11816 #HANGUL SYLLABLE THIEUTH EO MIEUM
  {0xC5D3, 0xD141}, //11817 #HANGUL SYLLABLE THIEUTH EO PIEUP
  {0xC5D4, 0xD143}, //11818 #HANGUL SYLLABLE THIEUTH EO SIOS
  {0xC5D5, 0xD144}, //11819 #HANGUL SYLLABLE THIEUTH EO SSANGSIOS
  {0xC5D6, 0xD145}, //11820 #HANGUL SYLLABLE THIEUTH EO IEUNG
  {0xC5D7, 0xD14C}, //11821 #HANGUL SYLLABLE THIEUTH E
  {0xC5D8, 0xD14D}, //11822 #HANGUL SYLLABLE THIEUTH E KIYEOK
  {0xC5D9, 0xD150}, //11823 #HANGUL SYLLABLE THIEUTH E NIEUN
  {0xC5DA, 0xD154}, //11824 #HANGUL SYLLABLE THIEUTH E RIEUL
  {0xC5DB, 0xD15C}, //11825 #HANGUL SYLLABLE THIEUTH E MIEUM
  {0xC5DC, 0xD15D}, //11826 #HANGUL SYLLABLE THIEUTH E PIEUP
  {0xC5DD, 0xD15F}, //11827 #HANGUL SYLLABLE THIEUTH E SIOS
  {0xC5DE, 0xD161}, //11828 #HANGUL SYLLABLE THIEUTH E IEUNG
  {0xC5DF, 0xD168}, //11829 #HANGUL SYLLABLE THIEUTH YEO
  {0xC5E0, 0xD16C}, //11830 #HANGUL SYLLABLE THIEUTH YEO NIEUN
  {0xC5E1, 0xD17C}, //11831 #HANGUL SYLLABLE THIEUTH YEO SSANGSIOS
  {0xC5E2, 0xD184}, //11832 #HANGUL SYLLABLE THIEUTH YE
  {0xC5E3, 0xD188}, //11833 #HANGUL SYLLABLE THIEUTH YE NIEUN
  {0xC5E4, 0xD1A0}, //11834 #HANGUL SYLLABLE THIEUTH O
  {0xC5E5, 0xD1A1}, //11835 #HANGUL SYLLABLE THIEUTH O KIYEOK
  {0xC5E6, 0xD1A4}, //11836 #HANGUL SYLLABLE THIEUTH O NIEUN
  {0xC5E7, 0xD1A8}, //11837 #HANGUL SYLLABLE THIEUTH O RIEUL
  {0xC5E8, 0xD1B0}, //11838 #HANGUL SYLLABLE THIEUTH O MIEUM
  {0xC5E9, 0xD1B1}, //11839 #HANGUL SYLLABLE THIEUTH O PIEUP
  {0xC5EA, 0xD1B3}, //11840 #HANGUL SYLLABLE THIEUTH O SIOS
  {0xC5EB, 0xD1B5}, //11841 #HANGUL SYLLABLE THIEUTH O IEUNG
  {0xC5EC, 0xD1BA}, //11842 #HANGUL SYLLABLE THIEUTH O PHIEUPH
  {0xC5ED, 0xD1BC}, //11843 #HANGUL SYLLABLE THIEUTH WA
  {0xC5EE, 0xD1C0}, //11844 #HANGUL SYLLABLE THIEUTH WA NIEUN
  {0xC5EF, 0xD1D8}, //11845 #HANGUL SYLLABLE THIEUTH WAE
  {0xC5F0, 0xD1F4}, //11846 #HANGUL SYLLABLE THIEUTH OE
  {0xC5F1, 0xD1F8}, //11847 #HANGUL SYLLABLE THIEUTH OE NIEUN
  {0xC5F2, 0xD207}, //11848 #HANGUL SYLLABLE THIEUTH OE SIOS
  {0xC5F3, 0xD209}, //11849 #HANGUL SYLLABLE THIEUTH OE IEUNG
  {0xC5F4, 0xD210}, //11850 #HANGUL SYLLABLE THIEUTH YO
  {0xC5F5, 0xD22C}, //11851 #HANGUL SYLLABLE THIEUTH U
  {0xC5F6, 0xD22D}, //11852 #HANGUL SYLLABLE THIEUTH U KIYEOK
  {0xC5F7, 0xD230}, //11853 #HANGUL SYLLABLE THIEUTH U NIEUN
  {0xC5F8, 0xD234}, //11854 #HANGUL SYLLABLE THIEUTH U RIEUL
  {0xC5F9, 0xD23C}, //11855 #HANGUL SYLLABLE THIEUTH U MIEUM
  {0xC5FA, 0xD23D}, //11856 #HANGUL SYLLABLE THIEUTH U PIEUP
  {0xC5FB, 0xD23F}, //11857 #HANGUL SYLLABLE THIEUTH U SIOS
  {0xC5FC, 0xD241}, //11858 #HANGUL SYLLABLE THIEUTH U IEUNG
  {0xC5FD, 0xD248}, //11859 #HANGUL SYLLABLE THIEUTH WEO
  {0xC5FE, 0xD25C}, //11860 #HANGUL SYLLABLE THIEUTH WEO SSANGSIOS
  {0xC641, 0xD78D}, //11861 #HANGUL SYLLABLE HIEUH I NIEUNCIEUC
  {0xC642, 0xD78E}, //11862 #HANGUL SYLLABLE HIEUH I NIEUNHIEUH
  {0xC643, 0xD78F}, //11863 #HANGUL SYLLABLE HIEUH I TIKEUT
  {0xC644, 0xD791}, //11864 #HANGUL SYLLABLE HIEUH I RIEULKIYEOK
  {0xC645, 0xD792}, //11865 #HANGUL SYLLABLE HIEUH I RIEULMIEUM
  {0xC646, 0xD793}, //11866 #HANGUL SYLLABLE HIEUH I RIEULPIEUP
  {0xC647, 0xD794}, //11867 #HANGUL SYLLABLE HIEUH I RIEULSIOS
  {0xC648, 0xD795}, //11868 #HANGUL SYLLABLE HIEUH I RIEULTHIEUTH
  {0xC649, 0xD796}, //11869 #HANGUL SYLLABLE HIEUH I RIEULPHIEUPH
  {0xC64A, 0xD797}, //11870 #HANGUL SYLLABLE HIEUH I RIEULHIEUH
  {0xC64B, 0xD79A}, //11871 #HANGUL SYLLABLE HIEUH I PIEUPSIOS
  {0xC64C, 0xD79C}, //11872 #HANGUL SYLLABLE HIEUH I SSANGSIOS
  {0xC64D, 0xD79E}, //11873 #HANGUL SYLLABLE HIEUH I CIEUC
  {0xC64E, 0xD79F}, //11874 #HANGUL SYLLABLE HIEUH I CHIEUCH
  {0xC64F, 0xD7A0}, //11875 #HANGUL SYLLABLE HIEUH I KHIEUKH
  {0xC650, 0xD7A1}, //11876 #HANGUL SYLLABLE HIEUH I THIEUTH
  {0xC651, 0xD7A2}, //11877 #HANGUL SYLLABLE HIEUH I PHIEUPH
  {0xC652, 0xD7A3}, //11878 #HANGUL SYLLABLE HIEUH I HIEUH
  {0xC6A1, 0xD264}, //11879 #HANGUL SYLLABLE THIEUTH WE
  {0xC6A2, 0xD280}, //11880 #HANGUL SYLLABLE THIEUTH WI
  {0xC6A3, 0xD281}, //11881 #HANGUL SYLLABLE THIEUTH WI KIYEOK
  {0xC6A4, 0xD284}, //11882 #HANGUL SYLLABLE THIEUTH WI NIEUN
  {0xC6A5, 0xD288}, //11883 #HANGUL SYLLABLE THIEUTH WI RIEUL
  {0xC6A6, 0xD290}, //11884 #HANGUL SYLLABLE THIEUTH WI MIEUM
  {0xC6A7, 0xD291}, //11885 #HANGUL SYLLABLE THIEUTH WI PIEUP
  {0xC6A8, 0xD295}, //11886 #HANGUL SYLLABLE THIEUTH WI IEUNG
  {0xC6A9, 0xD29C}, //11887 #HANGUL SYLLABLE THIEUTH YU
  {0xC6AA, 0xD2A0}, //11888 #HANGUL SYLLABLE THIEUTH YU NIEUN
  {0xC6AB, 0xD2A4}, //11889 #HANGUL SYLLABLE THIEUTH YU RIEUL
  {0xC6AC, 0xD2AC}, //11890 #HANGUL SYLLABLE THIEUTH YU MIEUM
  {0xC6AD, 0xD2B1}, //11891 #HANGUL SYLLABLE THIEUTH YU IEUNG
  {0xC6AE, 0xD2B8}, //11892 #HANGUL SYLLABLE THIEUTH EU
  {0xC6AF, 0xD2B9}, //11893 #HANGUL SYLLABLE THIEUTH EU KIYEOK
  {0xC6B0, 0xD2BC}, //11894 #HANGUL SYLLABLE THIEUTH EU NIEUN
  {0xC6B1, 0xD2BF}, //11895 #HANGUL SYLLABLE THIEUTH EU TIKEUT
  {0xC6B2, 0xD2C0}, //11896 #HANGUL SYLLABLE THIEUTH EU RIEUL
  {0xC6B3, 0xD2C2}, //11897 #HANGUL SYLLABLE THIEUTH EU RIEULMIEUM
  {0xC6B4, 0xD2C8}, //11898 #HANGUL SYLLABLE THIEUTH EU MIEUM
  {0xC6B5, 0xD2C9}, //11899 #HANGUL SYLLABLE THIEUTH EU PIEUP
  {0xC6B6, 0xD2CB}, //11900 #HANGUL SYLLABLE THIEUTH EU SIOS
  {0xC6B7, 0xD2D4}, //11901 #HANGUL SYLLABLE THIEUTH YI
  {0xC6B8, 0xD2D8}, //11902 #HANGUL SYLLABLE THIEUTH YI NIEUN
  {0xC6B9, 0xD2DC}, //11903 #HANGUL SYLLABLE THIEUTH YI RIEUL
  {0xC6BA, 0xD2E4}, //11904 #HANGUL SYLLABLE THIEUTH YI MIEUM
  {0xC6BB, 0xD2E5}, //11905 #HANGUL SYLLABLE THIEUTH YI PIEUP
  {0xC6BC, 0xD2F0}, //11906 #HANGUL SYLLABLE THIEUTH I
  {0xC6BD, 0xD2F1}, //11907 #HANGUL SYLLABLE THIEUTH I KIYEOK
  {0xC6BE, 0xD2F4}, //11908 #HANGUL SYLLABLE THIEUTH I NIEUN
  {0xC6BF, 0xD2F8}, //11909 #HANGUL SYLLABLE THIEUTH I RIEUL
  {0xC6C0, 0xD300}, //11910 #HANGUL SYLLABLE THIEUTH I MIEUM
  {0xC6C1, 0xD301}, //11911 #HANGUL SYLLABLE THIEUTH I PIEUP
  {0xC6C2, 0xD303}, //11912 #HANGUL SYLLABLE THIEUTH I SIOS
  {0xC6C3, 0xD305}, //11913 #HANGUL SYLLABLE THIEUTH I IEUNG
  {0xC6C4, 0xD30C}, //11914 #HANGUL SYLLABLE PHIEUPH A
  {0xC6C5, 0xD30D}, //11915 #HANGUL SYLLABLE PHIEUPH A KIYEOK
  {0xC6C6, 0xD30E}, //11916 #HANGUL SYLLABLE PHIEUPH A SSANGKIYEOK
  {0xC6C7, 0xD310}, //11917 #HANGUL SYLLABLE PHIEUPH A NIEUN
  {0xC6C8, 0xD314}, //11918 #HANGUL SYLLABLE PHIEUPH A RIEUL
  {0xC6C9, 0xD316}, //11919 #HANGUL SYLLABLE PHIEUPH A RIEULMIEUM
  {0xC6CA, 0xD31C}, //11920 #HANGUL SYLLABLE PHIEUPH A MIEUM
  {0xC6CB, 0xD31D}, //11921 #HANGUL SYLLABLE PHIEUPH A PIEUP
  {0xC6CC, 0xD31F}, //11922 #HANGUL SYLLABLE PHIEUPH A SIOS
  {0xC6CD, 0xD320}, //11923 #HANGUL SYLLABLE PHIEUPH A SSANGSIOS
  {0xC6CE, 0xD321}, //11924 #HANGUL SYLLABLE PHIEUPH A IEUNG
  {0xC6CF, 0xD325}, //11925 #HANGUL SYLLABLE PHIEUPH A THIEUTH
  {0xC6D0, 0xD328}, //11926 #HANGUL SYLLABLE PHIEUPH AE
  {0xC6D1, 0xD329}, //11927 #HANGUL SYLLABLE PHIEUPH AE KIYEOK
  {0xC6D2, 0xD32C}, //11928 #HANGUL SYLLABLE PHIEUPH AE NIEUN
  {0xC6D3, 0xD330}, //11929 #HANGUL SYLLABLE PHIEUPH AE RIEUL
  {0xC6D4, 0xD338}, //11930 #HANGUL SYLLABLE PHIEUPH AE MIEUM
  {0xC6D5, 0xD339}, //11931 #HANGUL SYLLABLE PHIEUPH AE PIEUP
  {0xC6D6, 0xD33B}, //11932 #HANGUL SYLLABLE PHIEUPH AE SIOS
  {0xC6D7, 0xD33C}, //11933 #HANGUL SYLLABLE PHIEUPH AE SSANGSIOS
  {0xC6D8, 0xD33D}, //11934 #HANGUL SYLLABLE PHIEUPH AE IEUNG
  {0xC6D9, 0xD344}, //11935 #HANGUL SYLLABLE PHIEUPH YA
  {0xC6DA, 0xD345}, //11936 #HANGUL SYLLABLE PHIEUPH YA KIYEOK
  {0xC6DB, 0xD37C}, //11937 #HANGUL SYLLABLE PHIEUPH EO
  {0xC6DC, 0xD37D}, //11938 #HANGUL SYLLABLE PHIEUPH EO KIYEOK
  {0xC6DD, 0xD380}, //11939 #HANGUL SYLLABLE PHIEUPH EO NIEUN
  {0xC6DE, 0xD384}, //11940 #HANGUL SYLLABLE PHIEUPH EO RIEUL
  {0xC6DF, 0xD38C}, //11941 #HANGUL SYLLABLE PHIEUPH EO MIEUM
  {0xC6E0, 0xD38D}, //11942 #HANGUL SYLLABLE PHIEUPH EO PIEUP
  {0xC6E1, 0xD38F}, //11943 #HANGUL SYLLABLE PHIEUPH EO SIOS
  {0xC6E2, 0xD390}, //11944 #HANGUL SYLLABLE PHIEUPH EO SSANGSIOS
  {0xC6E3, 0xD391}, //11945 #HANGUL SYLLABLE PHIEUPH EO IEUNG
  {0xC6E4, 0xD398}, //11946 #HANGUL SYLLABLE PHIEUPH E
  {0xC6E5, 0xD399}, //11947 #HANGUL SYLLABLE PHIEUPH E KIYEOK
  {0xC6E6, 0xD39C}, //11948 #HANGUL SYLLABLE PHIEUPH E NIEUN
  {0xC6E7, 0xD3A0}, //11949 #HANGUL SYLLABLE PHIEUPH E RIEUL
  {0xC6E8, 0xD3A8}, //11950 #HANGUL SYLLABLE PHIEUPH E MIEUM
  {0xC6E9, 0xD3A9}, //11951 #HANGUL SYLLABLE PHIEUPH E PIEUP
  {0xC6EA, 0xD3AB}, //11952 #HANGUL SYLLABLE PHIEUPH E SIOS
  {0xC6EB, 0xD3AD}, //11953 #HANGUL SYLLABLE PHIEUPH E IEUNG
  {0xC6EC, 0xD3B4}, //11954 #HANGUL SYLLABLE PHIEUPH YEO
  {0xC6ED, 0xD3B8}, //11955 #HANGUL SYLLABLE PHIEUPH YEO NIEUN
  {0xC6EE, 0xD3BC}, //11956 #HANGUL SYLLABLE PHIEUPH YEO RIEUL
  {0xC6EF, 0xD3C4}, //11957 #HANGUL SYLLABLE PHIEUPH YEO MIEUM
  {0xC6F0, 0xD3C5}, //11958 #HANGUL SYLLABLE PHIEUPH YEO PIEUP
  {0xC6F1, 0xD3C8}, //11959 #HANGUL SYLLABLE PHIEUPH YEO SSANGSIOS
  {0xC6F2, 0xD3C9}, //11960 #HANGUL SYLLABLE PHIEUPH YEO IEUNG
  {0xC6F3, 0xD3D0}, //11961 #HANGUL SYLLABLE PHIEUPH YE
  {0xC6F4, 0xD3D8}, //11962 #HANGUL SYLLABLE PHIEUPH YE RIEUL
  {0xC6F5, 0xD3E1}, //11963 #HANGUL SYLLABLE PHIEUPH YE PIEUP
  {0xC6F6, 0xD3E3}, //11964 #HANGUL SYLLABLE PHIEUPH YE SIOS
  {0xC6F7, 0xD3EC}, //11965 #HANGUL SYLLABLE PHIEUPH O
  {0xC6F8, 0xD3ED}, //11966 #HANGUL SYLLABLE PHIEUPH O KIYEOK
  {0xC6F9, 0xD3F0}, //11967 #HANGUL SYLLABLE PHIEUPH O NIEUN
  {0xC6FA, 0xD3F4}, //11968 #HANGUL SYLLABLE PHIEUPH O RIEUL
  {0xC6FB, 0xD3FC}, //11969 #HANGUL SYLLABLE PHIEUPH O MIEUM
  {0xC6FC, 0xD3FD}, //11970 #HANGUL SYLLABLE PHIEUPH O PIEUP
  {0xC6FD, 0xD3FF}, //11971 #HANGUL SYLLABLE PHIEUPH O SIOS
  {0xC6FE, 0xD401}, //11972 #HANGUL SYLLABLE PHIEUPH O IEUNG
  {0xC7A1, 0xD408}, //11973 #HANGUL SYLLABLE PHIEUPH WA
  {0xC7A2, 0xD41D}, //11974 #HANGUL SYLLABLE PHIEUPH WA IEUNG
  {0xC7A3, 0xD440}, //11975 #HANGUL SYLLABLE PHIEUPH OE
  {0xC7A4, 0xD444}, //11976 #HANGUL SYLLABLE PHIEUPH OE NIEUN
  {0xC7A5, 0xD45C}, //11977 #HANGUL SYLLABLE PHIEUPH YO
  {0xC7A6, 0xD460}, //11978 #HANGUL SYLLABLE PHIEUPH YO NIEUN
  {0xC7A7, 0xD464}, //11979 #HANGUL SYLLABLE PHIEUPH YO RIEUL
  {0xC7A8, 0xD46D}, //11980 #HANGUL SYLLABLE PHIEUPH YO PIEUP
  {0xC7A9, 0xD46F}, //11981 #HANGUL SYLLABLE PHIEUPH YO SIOS
  {0xC7AA, 0xD478}, //11982 #HANGUL SYLLABLE PHIEUPH U
  {0xC7AB, 0xD479}, //11983 #HANGUL SYLLABLE PHIEUPH U KIYEOK
  {0xC7AC, 0xD47C}, //11984 #HANGUL SYLLABLE PHIEUPH U NIEUN
  {0xC7AD, 0xD47F}, //11985 #HANGUL SYLLABLE PHIEUPH U TIKEUT
  {0xC7AE, 0xD480}, //11986 #HANGUL SYLLABLE PHIEUPH U RIEUL
  {0xC7AF, 0xD482}, //11987 #HANGUL SYLLABLE PHIEUPH U RIEULMIEUM
  {0xC7B0, 0xD488}, //11988 #HANGUL SYLLABLE PHIEUPH U MIEUM
  {0xC7B1, 0xD489}, //11989 #HANGUL SYLLABLE PHIEUPH U PIEUP
  {0xC7B2, 0xD48B}, //11990 #HANGUL SYLLABLE PHIEUPH U SIOS
  {0xC7B3, 0xD48D}, //11991 #HANGUL SYLLABLE PHIEUPH U IEUNG
  {0xC7B4, 0xD494}, //11992 #HANGUL SYLLABLE PHIEUPH WEO
  {0xC7B5, 0xD4A9}, //11993 #HANGUL SYLLABLE PHIEUPH WEO IEUNG
  {0xC7B6, 0xD4CC}, //11994 #HANGUL SYLLABLE PHIEUPH WI
  {0xC7B7, 0xD4D0}, //11995 #HANGUL SYLLABLE PHIEUPH WI NIEUN
  {0xC7B8, 0xD4D4}, //11996 #HANGUL SYLLABLE PHIEUPH WI RIEUL
  {0xC7B9, 0xD4DC}, //11997 #HANGUL SYLLABLE PHIEUPH WI MIEUM
  {0xC7BA, 0xD4DF}, //11998 #HANGUL SYLLABLE PHIEUPH WI SIOS
  {0xC7BB, 0xD4E8}, //11999 #HANGUL SYLLABLE PHIEUPH YU
  {0xC7BC, 0xD4EC}, //12000 #HANGUL SYLLABLE PHIEUPH YU NIEUN
  {0xC7BD, 0xD4F0}, //12001 #HANGUL SYLLABLE PHIEUPH YU RIEUL
  {0xC7BE, 0xD4F8}, //12002 #HANGUL SYLLABLE PHIEUPH YU MIEUM
  {0xC7BF, 0xD4FB}, //12003 #HANGUL SYLLABLE PHIEUPH YU SIOS
  {0xC7C0, 0xD4FD}, //12004 #HANGUL SYLLABLE PHIEUPH YU IEUNG
  {0xC7C1, 0xD504}, //12005 #HANGUL SYLLABLE PHIEUPH EU
  {0xC7C2, 0xD508}, //12006 #HANGUL SYLLABLE PHIEUPH EU NIEUN
  {0xC7C3, 0xD50C}, //12007 #HANGUL SYLLABLE PHIEUPH EU RIEUL
  {0xC7C4, 0xD514}, //12008 #HANGUL SYLLABLE PHIEUPH EU MIEUM
  {0xC7C5, 0xD515}, //12009 #HANGUL SYLLABLE PHIEUPH EU PIEUP
  {0xC7C6, 0xD517}, //12010 #HANGUL SYLLABLE PHIEUPH EU SIOS
  {0xC7C7, 0xD53C}, //12011 #HANGUL SYLLABLE PHIEUPH I
  {0xC7C8, 0xD53D}, //12012 #HANGUL SYLLABLE PHIEUPH I KIYEOK
  {0xC7C9, 0xD540}, //12013 #HANGUL SYLLABLE PHIEUPH I NIEUN
  {0xC7CA, 0xD544}, //12014 #HANGUL SYLLABLE PHIEUPH I RIEUL
  {0xC7CB, 0xD54C}, //12015 #HANGUL SYLLABLE PHIEUPH I MIEUM
  {0xC7CC, 0xD54D}, //12016 #HANGUL SYLLABLE PHIEUPH I PIEUP
  {0xC7CD, 0xD54F}, //12017 #HANGUL SYLLABLE PHIEUPH I SIOS
  {0xC7CE, 0xD551}, //12018 #HANGUL SYLLABLE PHIEUPH I IEUNG
  {0xC7CF, 0xD558}, //12019 #HANGUL SYLLABLE HIEUH A
  {0xC7D0, 0xD559}, //12020 #HANGUL SYLLABLE HIEUH A KIYEOK
  {0xC7D1, 0xD55C}, //12021 #HANGUL SYLLABLE HIEUH A NIEUN
  {0xC7D2, 0xD560}, //12022 #HANGUL SYLLABLE HIEUH A RIEUL
  {0xC7D3, 0xD565}, //12023 #HANGUL SYLLABLE HIEUH A RIEULTHIEUTH
  {0xC7D4, 0xD568}, //12024 #HANGUL SYLLABLE HIEUH A MIEUM
  {0xC7D5, 0xD569}, //12025 #HANGUL SYLLABLE HIEUH A PIEUP
  {0xC7D6, 0xD56B}, //12026 #HANGUL SYLLABLE HIEUH A SIOS
  {0xC7D7, 0xD56D}, //12027 #HANGUL SYLLABLE HIEUH A IEUNG
  {0xC7D8, 0xD574}, //12028 #HANGUL SYLLABLE HIEUH AE
  {0xC7D9, 0xD575}, //12029 #HANGUL SYLLABLE HIEUH AE KIYEOK
  {0xC7DA, 0xD578}, //12030 #HANGUL SYLLABLE HIEUH AE NIEUN
  {0xC7DB, 0xD57C}, //12031 #HANGUL SYLLABLE HIEUH AE RIEUL
  {0xC7DC, 0xD584}, //12032 #HANGUL SYLLABLE HIEUH AE MIEUM
  {0xC7DD, 0xD585}, //12033 #HANGUL SYLLABLE HIEUH AE PIEUP
  {0xC7DE, 0xD587}, //12034 #HANGUL SYLLABLE HIEUH AE SIOS
  {0xC7DF, 0xD588}, //12035 #HANGUL SYLLABLE HIEUH AE SSANGSIOS
  {0xC7E0, 0xD589}, //12036 #HANGUL SYLLABLE HIEUH AE IEUNG
  {0xC7E1, 0xD590}, //12037 #HANGUL SYLLABLE HIEUH YA
  {0xC7E2, 0xD5A5}, //12038 #HANGUL SYLLABLE HIEUH YA IEUNG
  {0xC7E3, 0xD5C8}, //12039 #HANGUL SYLLABLE HIEUH EO
  {0xC7E4, 0xD5C9}, //12040 #HANGUL SYLLABLE HIEUH EO KIYEOK
  {0xC7E5, 0xD5CC}, //12041 #HANGUL SYLLABLE HIEUH EO NIEUN
  {0xC7E6, 0xD5D0}, //12042 #HANGUL SYLLABLE HIEUH EO RIEUL
  {0xC7E7, 0xD5D2}, //12043 #HANGUL SYLLABLE HIEUH EO RIEULMIEUM
  {0xC7E8, 0xD5D8}, //12044 #HANGUL SYLLABLE HIEUH EO MIEUM
  {0xC7E9, 0xD5D9}, //12045 #HANGUL SYLLABLE HIEUH EO PIEUP
  {0xC7EA, 0xD5DB}, //12046 #HANGUL SYLLABLE HIEUH EO SIOS
  {0xC7EB, 0xD5DD}, //12047 #HANGUL SYLLABLE HIEUH EO IEUNG
  {0xC7EC, 0xD5E4}, //12048 #HANGUL SYLLABLE HIEUH E
  {0xC7ED, 0xD5E5}, //12049 #HANGUL SYLLABLE HIEUH E KIYEOK
  {0xC7EE, 0xD5E8}, //12050 #HANGUL SYLLABLE HIEUH E NIEUN
  {0xC7EF, 0xD5EC}, //12051 #HANGUL SYLLABLE HIEUH E RIEUL
  {0xC7F0, 0xD5F4}, //12052 #HANGUL SYLLABLE HIEUH E MIEUM
  {0xC7F1, 0xD5F5}, //12053 #HANGUL SYLLABLE HIEUH E PIEUP
  {0xC7F2, 0xD5F7}, //12054 #HANGUL SYLLABLE HIEUH E SIOS
  {0xC7F3, 0xD5F9}, //12055 #HANGUL SYLLABLE HIEUH E IEUNG
  {0xC7F4, 0xD600}, //12056 #HANGUL SYLLABLE HIEUH YEO
  {0xC7F5, 0xD601}, //12057 #HANGUL SYLLABLE HIEUH YEO KIYEOK
  {0xC7F6, 0xD604}, //12058 #HANGUL SYLLABLE HIEUH YEO NIEUN
  {0xC7F7, 0xD608}, //12059 #HANGUL SYLLABLE HIEUH YEO RIEUL
  {0xC7F8, 0xD610}, //12060 #HANGUL SYLLABLE HIEUH YEO MIEUM
  {0xC7F9, 0xD611}, //12061 #HANGUL SYLLABLE HIEUH YEO PIEUP
  {0xC7FA, 0xD613}, //12062 #HANGUL SYLLABLE HIEUH YEO SIOS
  {0xC7FB, 0xD614}, //12063 #HANGUL SYLLABLE HIEUH YEO SSANGSIOS
  {0xC7FC, 0xD615}, //12064 #HANGUL SYLLABLE HIEUH YEO IEUNG
  {0xC7FD, 0xD61C}, //12065 #HANGUL SYLLABLE HIEUH YE
  {0xC7FE, 0xD620}, //12066 #HANGUL SYLLABLE HIEUH YE NIEUN
  {0xC8A1, 0xD624}, //12067 #HANGUL SYLLABLE HIEUH YE RIEUL
  {0xC8A2, 0xD62D}, //12068 #HANGUL SYLLABLE HIEUH YE PIEUP
  {0xC8A3, 0xD638}, //12069 #HANGUL SYLLABLE HIEUH O
  {0xC8A4, 0xD639}, //12070 #HANGUL SYLLABLE HIEUH O KIYEOK
  {0xC8A5, 0xD63C}, //12071 #HANGUL SYLLABLE HIEUH O NIEUN
  {0xC8A6, 0xD640}, //12072 #HANGUL SYLLABLE HIEUH O RIEUL
  {0xC8A7, 0xD645}, //12073 #HANGUL SYLLABLE HIEUH O RIEULTHIEUTH
  {0xC8A8, 0xD648}, //12074 #HANGUL SYLLABLE HIEUH O MIEUM
  {0xC8A9, 0xD649}, //12075 #HANGUL SYLLABLE HIEUH O PIEUP
  {0xC8AA, 0xD64B}, //12076 #HANGUL SYLLABLE HIEUH O SIOS
  {0xC8AB, 0xD64D}, //12077 #HANGUL SYLLABLE HIEUH O IEUNG
  {0xC8AC, 0xD651}, //12078 #HANGUL SYLLABLE HIEUH O THIEUTH
  {0xC8AD, 0xD654}, //12079 #HANGUL SYLLABLE HIEUH WA
  {0xC8AE, 0xD655}, //12080 #HANGUL SYLLABLE HIEUH WA KIYEOK
  {0xC8AF, 0xD658}, //12081 #HANGUL SYLLABLE HIEUH WA NIEUN
  {0xC8B0, 0xD65C}, //12082 #HANGUL SYLLABLE HIEUH WA RIEUL
  {0xC8B1, 0xD667}, //12083 #HANGUL SYLLABLE HIEUH WA SIOS
  {0xC8B2, 0xD669}, //12084 #HANGUL SYLLABLE HIEUH WA IEUNG
  {0xC8B3, 0xD670}, //12085 #HANGUL SYLLABLE HIEUH WAE
  {0xC8B4, 0xD671}, //12086 #HANGUL SYLLABLE HIEUH WAE KIYEOK
  {0xC8B5, 0xD674}, //12087 #HANGUL SYLLABLE HIEUH WAE NIEUN
  {0xC8B6, 0xD683}, //12088 #HANGUL SYLLABLE HIEUH WAE SIOS
  {0xC8B7, 0xD685}, //12089 #HANGUL SYLLABLE HIEUH WAE IEUNG
  {0xC8B8, 0xD68C}, //12090 #HANGUL SYLLABLE HIEUH OE
  {0xC8B9, 0xD68D}, //12091 #HANGUL SYLLABLE HIEUH OE KIYEOK
  {0xC8BA, 0xD690}, //12092 #HANGUL SYLLABLE HIEUH OE NIEUN
  {0xC8BB, 0xD694}, //12093 #HANGUL SYLLABLE HIEUH OE RIEUL
  {0xC8BC, 0xD69D}, //12094 #HANGUL SYLLABLE HIEUH OE PIEUP
  {0xC8BD, 0xD69F}, //12095 #HANGUL SYLLABLE HIEUH OE SIOS
  {0xC8BE, 0xD6A1}, //12096 #HANGUL SYLLABLE HIEUH OE IEUNG
  {0xC8BF, 0xD6A8}, //12097 #HANGUL SYLLABLE HIEUH YO
  {0xC8C0, 0xD6AC}, //12098 #HANGUL SYLLABLE HIEUH YO NIEUN
  {0xC8C1, 0xD6B0}, //12099 #HANGUL SYLLABLE HIEUH YO RIEUL
  {0xC8C2, 0xD6B9}, //12100 #HANGUL SYLLABLE HIEUH YO PIEUP
  {0xC8C3, 0xD6BB}, //12101 #HANGUL SYLLABLE HIEUH YO SIOS
  {0xC8C4, 0xD6C4}, //12102 #HANGUL SYLLABLE HIEUH U
  {0xC8C5, 0xD6C5}, //12103 #HANGUL SYLLABLE HIEUH U KIYEOK
  {0xC8C6, 0xD6C8}, //12104 #HANGUL SYLLABLE HIEUH U NIEUN
  {0xC8C7, 0xD6CC}, //12105 #HANGUL SYLLABLE HIEUH U RIEUL
  {0xC8C8, 0xD6D1}, //12106 #HANGUL SYLLABLE HIEUH U RIEULTHIEUTH
  {0xC8C9, 0xD6D4}, //12107 #HANGUL SYLLABLE HIEUH U MIEUM
  {0xC8CA, 0xD6D7}, //12108 #HANGUL SYLLABLE HIEUH U SIOS
  {0xC8CB, 0xD6D9}, //12109 #HANGUL SYLLABLE HIEUH U IEUNG
  {0xC8CC, 0xD6E0}, //12110 #HANGUL SYLLABLE HIEUH WEO
  {0xC8CD, 0xD6E4}, //12111 #HANGUL SYLLABLE HIEUH WEO NIEUN
  {0xC8CE, 0xD6E8}, //12112 #HANGUL SYLLABLE HIEUH WEO RIEUL
  {0xC8CF, 0xD6F0}, //12113 #HANGUL SYLLABLE HIEUH WEO MIEUM
  {0xC8D0, 0xD6F5}, //12114 #HANGUL SYLLABLE HIEUH WEO IEUNG
  {0xC8D1, 0xD6FC}, //12115 #HANGUL SYLLABLE HIEUH WE
  {0xC8D2, 0xD6FD}, //12116 #HANGUL SYLLABLE HIEUH WE KIYEOK
  {0xC8D3, 0xD700}, //12117 #HANGUL SYLLABLE HIEUH WE NIEUN
  {0xC8D4, 0xD704}, //12118 #HANGUL SYLLABLE HIEUH WE RIEUL
  {0xC8D5, 0xD711}, //12119 #HANGUL SYLLABLE HIEUH WE IEUNG
  {0xC8D6, 0xD718}, //12120 #HANGUL SYLLABLE HIEUH WI
  {0xC8D7, 0xD719}, //12121 #HANGUL SYLLABLE HIEUH WI KIYEOK
  {0xC8D8, 0xD71C}, //12122 #HANGUL SYLLABLE HIEUH WI NIEUN
  {0xC8D9, 0xD720}, //12123 #HANGUL SYLLABLE HIEUH WI RIEUL
  {0xC8DA, 0xD728}, //12124 #HANGUL SYLLABLE HIEUH WI MIEUM
  {0xC8DB, 0xD729}, //12125 #HANGUL SYLLABLE HIEUH WI PIEUP
  {0xC8DC, 0xD72B}, //12126 #HANGUL SYLLABLE HIEUH WI SIOS
  {0xC8DD, 0xD72D}, //12127 #HANGUL SYLLABLE HIEUH WI IEUNG
  {0xC8DE, 0xD734}, //12128 #HANGUL SYLLABLE HIEUH YU
  {0xC8DF, 0xD735}, //12129 #HANGUL SYLLABLE HIEUH YU KIYEOK
  {0xC8E0, 0xD738}, //12130 #HANGUL SYLLABLE HIEUH YU NIEUN
  {0xC8E1, 0xD73C}, //12131 #HANGUL SYLLABLE HIEUH YU RIEUL
  {0xC8E2, 0xD744}, //12132 #HANGUL SYLLABLE HIEUH YU MIEUM
  {0xC8E3, 0xD747}, //12133 #HANGUL SYLLABLE HIEUH YU SIOS
  {0xC8E4, 0xD749}, //12134 #HANGUL SYLLABLE HIEUH YU IEUNG
  {0xC8E5, 0xD750}, //12135 #HANGUL SYLLABLE HIEUH EU
  {0xC8E6, 0xD751}, //12136 #HANGUL SYLLABLE HIEUH EU KIYEOK
  {0xC8E7, 0xD754}, //12137 #HANGUL SYLLABLE HIEUH EU NIEUN
  {0xC8E8, 0xD756}, //12138 #HANGUL SYLLABLE HIEUH EU NIEUNHIEUH
  {0xC8E9, 0xD757}, //12139 #HANGUL SYLLABLE HIEUH EU TIKEUT
  {0xC8EA, 0xD758}, //12140 #HANGUL SYLLABLE HIEUH EU RIEUL
  {0xC8EB, 0xD759}, //12141 #HANGUL SYLLABLE HIEUH EU RIEULKIYEOK
  {0xC8EC, 0xD760}, //12142 #HANGUL SYLLABLE HIEUH EU MIEUM
  {0xC8ED, 0xD761}, //12143 #HANGUL SYLLABLE HIEUH EU PIEUP
  {0xC8EE, 0xD763}, //12144 #HANGUL SYLLABLE HIEUH EU SIOS
  {0xC8EF, 0xD765}, //12145 #HANGUL SYLLABLE HIEUH EU IEUNG
  {0xC8F0, 0xD769}, //12146 #HANGUL SYLLABLE HIEUH EU THIEUTH
  {0xC8F1, 0xD76C}, //12147 #HANGUL SYLLABLE HIEUH YI
  {0xC8F2, 0xD770}, //12148 #HANGUL SYLLABLE HIEUH YI NIEUN
  {0xC8F3, 0xD774}, //12149 #HANGUL SYLLABLE HIEUH YI RIEUL
  {0xC8F4, 0xD77C}, //12150 #HANGUL SYLLABLE HIEUH YI MIEUM
  {0xC8F5, 0xD77D}, //12151 #HANGUL SYLLABLE HIEUH YI PIEUP
  {0xC8F6, 0xD781}, //12152 #HANGUL SYLLABLE HIEUH YI IEUNG
  {0xC8F7, 0xD788}, //12153 #HANGUL SYLLABLE HIEUH I
  {0xC8F8, 0xD789}, //12154 #HANGUL SYLLABLE HIEUH I KIYEOK
  {0xC8F9, 0xD78C}, //12155 #HANGUL SYLLABLE HIEUH I NIEUN
  {0xC8FA, 0xD790}, //12156 #HANGUL SYLLABLE HIEUH I RIEUL
  {0xC8FB, 0xD798}, //12157 #HANGUL SYLLABLE HIEUH I MIEUM
  {0xC8FC, 0xD799}, //12158 #HANGUL SYLLABLE HIEUH I PIEUP
  {0xC8FD, 0xD79B}, //12159 #HANGUL SYLLABLE HIEUH I SIOS
  {0xC8FE, 0xD79D}, //12160 #HANGUL SYLLABLE HIEUH I IEUNG
  {0xCAA1, 0x4F3D}, //12161 #CJK UNIFIED IDEOGRAPH
  {0xCAA2, 0x4F73}, //12162 #CJK UNIFIED IDEOGRAPH
  {0xCAA3, 0x5047}, //12163 #CJK UNIFIED IDEOGRAPH
  {0xCAA4, 0x50F9}, //12164 #CJK UNIFIED IDEOGRAPH
  {0xCAA5, 0x52A0}, //12165 #CJK UNIFIED IDEOGRAPH
  {0xCAA6, 0x53EF}, //12166 #CJK UNIFIED IDEOGRAPH
  {0xCAA7, 0x5475}, //12167 #CJK UNIFIED IDEOGRAPH
  {0xCAA8, 0x54E5}, //12168 #CJK UNIFIED IDEOGRAPH
  {0xCAA9, 0x5609}, //12169 #CJK UNIFIED IDEOGRAPH
  {0xCAAA, 0x5AC1}, //12170 #CJK UNIFIED IDEOGRAPH
  {0xCAAB, 0x5BB6}, //12171 #CJK UNIFIED IDEOGRAPH
  {0xCAAC, 0x6687}, //12172 #CJK UNIFIED IDEOGRAPH
  {0xCAAD, 0x67B6}, //12173 #CJK UNIFIED IDEOGRAPH
  {0xCAAE, 0x67B7}, //12174 #CJK UNIFIED IDEOGRAPH
  {0xCAAF, 0x67EF}, //12175 #CJK UNIFIED IDEOGRAPH
  {0xCAB0, 0x6B4C}, //12176 #CJK UNIFIED IDEOGRAPH
  {0xCAB1, 0x73C2}, //12177 #CJK UNIFIED IDEOGRAPH
  {0xCAB2, 0x75C2}, //12178 #CJK UNIFIED IDEOGRAPH
  {0xCAB3, 0x7A3C}, //12179 #CJK UNIFIED IDEOGRAPH
  {0xCAB4, 0x82DB}, //12180 #CJK UNIFIED IDEOGRAPH
  {0xCAB5, 0x8304}, //12181 #CJK UNIFIED IDEOGRAPH
  {0xCAB6, 0x8857}, //12182 #CJK UNIFIED IDEOGRAPH
  {0xCAB7, 0x8888}, //12183 #CJK UNIFIED IDEOGRAPH
  {0xCAB8, 0x8A36}, //12184 #CJK UNIFIED IDEOGRAPH
  {0xCAB9, 0x8CC8}, //12185 #CJK UNIFIED IDEOGRAPH
  {0xCABA, 0x8DCF}, //12186 #CJK UNIFIED IDEOGRAPH
  {0xCABB, 0x8EFB}, //12187 #CJK UNIFIED IDEOGRAPH
  {0xCABC, 0x8FE6}, //12188 #CJK UNIFIED IDEOGRAPH
  {0xCABD, 0x99D5}, //12189 #CJK UNIFIED IDEOGRAPH
  {0xCABE, 0x523B}, //12190 #CJK UNIFIED IDEOGRAPH
  {0xCABF, 0x5374}, //12191 #CJK UNIFIED IDEOGRAPH
  {0xCAC0, 0x5404}, //12192 #CJK UNIFIED IDEOGRAPH
  {0xCAC1, 0x606A}, //12193 #CJK UNIFIED IDEOGRAPH
  {0xCAC2, 0x6164}, //12194 #CJK UNIFIED IDEOGRAPH
  {0xCAC3, 0x6BBC}, //12195 #CJK UNIFIED IDEOGRAPH
  {0xCAC4, 0x73CF}, //12196 #CJK UNIFIED IDEOGRAPH
  {0xCAC5, 0x811A}, //12197 #CJK UNIFIED IDEOGRAPH
  {0xCAC6, 0x89BA}, //12198 #CJK UNIFIED IDEOGRAPH
  {0xCAC7, 0x89D2}, //12199 #CJK UNIFIED IDEOGRAPH
  {0xCAC8, 0x95A3}, //12200 #CJK UNIFIED IDEOGRAPH
  {0xCAC9, 0x4F83}, //12201 #CJK UNIFIED IDEOGRAPH
  {0xCACA, 0x520A}, //12202 #CJK UNIFIED IDEOGRAPH
  {0xCACB, 0x58BE}, //12203 #CJK UNIFIED IDEOGRAPH
  {0xCACC, 0x5978}, //12204 #CJK UNIFIED IDEOGRAPH
  {0xCACD, 0x59E6}, //12205 #CJK UNIFIED IDEOGRAPH
  {0xCACE, 0x5E72}, //12206 #CJK UNIFIED IDEOGRAPH
  {0xCACF, 0x5E79}, //12207 #CJK UNIFIED IDEOGRAPH
  {0xCAD0, 0x61C7}, //12208 #CJK UNIFIED IDEOGRAPH
  {0xCAD1, 0x63C0}, //12209 #CJK UNIFIED IDEOGRAPH
  {0xCAD2, 0x6746}, //12210 #CJK UNIFIED IDEOGRAPH
  {0xCAD3, 0x67EC}, //12211 #CJK UNIFIED IDEOGRAPH
  {0xCAD4, 0x687F}, //12212 #CJK UNIFIED IDEOGRAPH
  {0xCAD5, 0x6F97}, //12213 #CJK UNIFIED IDEOGRAPH
  {0xCAD6, 0x764E}, //12214 #CJK UNIFIED IDEOGRAPH
  {0xCAD7, 0x770B}, //12215 #CJK UNIFIED IDEOGRAPH
  {0xCAD8, 0x78F5}, //12216 #CJK UNIFIED IDEOGRAPH
  {0xCAD9, 0x7A08}, //12217 #CJK UNIFIED IDEOGRAPH
  {0xCADA, 0x7AFF}, //12218 #CJK UNIFIED IDEOGRAPH
  {0xCADB, 0x7C21}, //12219 #CJK UNIFIED IDEOGRAPH
  {0xCADC, 0x809D}, //12220 #CJK UNIFIED IDEOGRAPH
  {0xCADD, 0x826E}, //12221 #CJK UNIFIED IDEOGRAPH
  {0xCADE, 0x8271}, //12222 #CJK UNIFIED IDEOGRAPH
  {0xCADF, 0x8AEB}, //12223 #CJK UNIFIED IDEOGRAPH
  {0xCAE0, 0x9593}, //12224 #CJK UNIFIED IDEOGRAPH
  {0xCAE1, 0x4E6B}, //12225 #CJK UNIFIED IDEOGRAPH
  {0xCAE2, 0x559D}, //12226 #CJK UNIFIED IDEOGRAPH
  {0xCAE3, 0x66F7}, //12227 #CJK UNIFIED IDEOGRAPH
  {0xCAE4, 0x6E34}, //12228 #CJK UNIFIED IDEOGRAPH
  {0xCAE5, 0x78A3}, //12229 #CJK UNIFIED IDEOGRAPH
  {0xCAE6, 0x7AED}, //12230 #CJK UNIFIED IDEOGRAPH
  {0xCAE7, 0x845B}, //12231 #CJK UNIFIED IDEOGRAPH
  {0xCAE8, 0x8910}, //12232 #CJK UNIFIED IDEOGRAPH
  {0xCAE9, 0x874E}, //12233 #CJK UNIFIED IDEOGRAPH
  {0xCAEA, 0x97A8}, //12234 #CJK UNIFIED IDEOGRAPH
  {0xCAEB, 0x52D8}, //12235 #CJK UNIFIED IDEOGRAPH
  {0xCAEC, 0x574E}, //12236 #CJK UNIFIED IDEOGRAPH
  {0xCAED, 0x582A}, //12237 #CJK UNIFIED IDEOGRAPH
  {0xCAEE, 0x5D4C}, //12238 #CJK UNIFIED IDEOGRAPH
  {0xCAEF, 0x611F}, //12239 #CJK UNIFIED IDEOGRAPH
  {0xCAF0, 0x61BE}, //12240 #CJK UNIFIED IDEOGRAPH
  {0xCAF1, 0x6221}, //12241 #CJK UNIFIED IDEOGRAPH
  {0xCAF2, 0x6562}, //12242 #CJK UNIFIED IDEOGRAPH
  {0xCAF3, 0x67D1}, //12243 #CJK UNIFIED IDEOGRAPH
  {0xCAF4, 0x6A44}, //12244 #CJK UNIFIED IDEOGRAPH
  {0xCAF5, 0x6E1B}, //12245 #CJK UNIFIED IDEOGRAPH
  {0xCAF6, 0x7518}, //12246 #CJK UNIFIED IDEOGRAPH
  {0xCAF7, 0x75B3}, //12247 #CJK UNIFIED IDEOGRAPH
  {0xCAF8, 0x76E3}, //12248 #CJK UNIFIED IDEOGRAPH
  {0xCAF9, 0x77B0}, //12249 #CJK UNIFIED IDEOGRAPH
  {0xCAFA, 0x7D3A}, //12250 #CJK UNIFIED IDEOGRAPH
  {0xCAFB, 0x90AF}, //12251 #CJK UNIFIED IDEOGRAPH
  {0xCAFC, 0x9451}, //12252 #CJK UNIFIED IDEOGRAPH
  {0xCAFD, 0x9452}, //12253 #CJK UNIFIED IDEOGRAPH
  {0xCAFE, 0x9F95}, //12254 #CJK UNIFIED IDEOGRAPH
  {0xCBA1, 0x5323}, //12255 #CJK UNIFIED IDEOGRAPH
  {0xCBA2, 0x5CAC}, //12256 #CJK UNIFIED IDEOGRAPH
  {0xCBA3, 0x7532}, //12257 #CJK UNIFIED IDEOGRAPH
  {0xCBA4, 0x80DB}, //12258 #CJK UNIFIED IDEOGRAPH
  {0xCBA5, 0x9240}, //12259 #CJK UNIFIED IDEOGRAPH
  {0xCBA6, 0x9598}, //12260 #CJK UNIFIED IDEOGRAPH
  {0xCBA7, 0x525B}, //12261 #CJK UNIFIED IDEOGRAPH
  {0xCBA8, 0x5808}, //12262 #CJK UNIFIED IDEOGRAPH
  {0xCBA9, 0x59DC}, //12263 #CJK UNIFIED IDEOGRAPH
  {0xCBAA, 0x5CA1}, //12264 #CJK UNIFIED IDEOGRAPH
  {0xCBAB, 0x5D17}, //12265 #CJK UNIFIED IDEOGRAPH
  {0xCBAC, 0x5EB7}, //12266 #CJK UNIFIED IDEOGRAPH
  {0xCBAD, 0x5F3A}, //12267 #CJK UNIFIED IDEOGRAPH
  {0xCBAE, 0x5F4A}, //12268 #CJK UNIFIED IDEOGRAPH
  {0xCBAF, 0x6177}, //12269 #CJK UNIFIED IDEOGRAPH
  {0xCBB0, 0x6C5F}, //12270 #CJK UNIFIED IDEOGRAPH
  {0xCBB1, 0x757A}, //12271 #CJK UNIFIED IDEOGRAPH
  {0xCBB2, 0x7586}, //12272 #CJK UNIFIED IDEOGRAPH
  {0xCBB3, 0x7CE0}, //12273 #CJK UNIFIED IDEOGRAPH
  {0xCBB4, 0x7D73}, //12274 #CJK UNIFIED IDEOGRAPH
  {0xCBB5, 0x7DB1}, //12275 #CJK UNIFIED IDEOGRAPH
  {0xCBB6, 0x7F8C}, //12276 #CJK UNIFIED IDEOGRAPH
  {0xCBB7, 0x8154}, //12277 #CJK UNIFIED IDEOGRAPH
  {0xCBB8, 0x8221}, //12278 #CJK UNIFIED IDEOGRAPH
  {0xCBB9, 0x8591}, //12279 #CJK UNIFIED IDEOGRAPH
  {0xCBBA, 0x8941}, //12280 #CJK UNIFIED IDEOGRAPH
  {0xCBBB, 0x8B1B}, //12281 #CJK UNIFIED IDEOGRAPH
  {0xCBBC, 0x92FC}, //12282 #CJK UNIFIED IDEOGRAPH
  {0xCBBD, 0x964D}, //12283 #CJK UNIFIED IDEOGRAPH
  {0xCBBE, 0x9C47}, //12284 #CJK UNIFIED IDEOGRAPH
  {0xCBBF, 0x4ECB}, //12285 #CJK UNIFIED IDEOGRAPH
  {0xCBC0, 0x4EF7}, //12286 #CJK UNIFIED IDEOGRAPH
  {0xCBC1, 0x500B}, //12287 #CJK UNIFIED IDEOGRAPH
  {0xCBC2, 0x51F1}, //12288 #CJK UNIFIED IDEOGRAPH
  {0xCBC3, 0x584F}, //12289 #CJK UNIFIED IDEOGRAPH
  {0xCBC4, 0x6137}, //12290 #CJK UNIFIED IDEOGRAPH
  {0xCBC5, 0x613E}, //12291 #CJK UNIFIED IDEOGRAPH
  {0xCBC6, 0x6168}, //12292 #CJK UNIFIED IDEOGRAPH
  {0xCBC7, 0x6539}, //12293 #CJK UNIFIED IDEOGRAPH
  {0xCBC8, 0x69EA}, //12294 #CJK UNIFIED IDEOGRAPH
  {0xCBC9, 0x6F11}, //12295 #CJK UNIFIED IDEOGRAPH
  {0xCBCA, 0x75A5}, //12296 #CJK UNIFIED IDEOGRAPH
  {0xCBCB, 0x7686}, //12297 #CJK UNIFIED IDEOGRAPH
  {0xCBCC, 0x76D6}, //12298 #CJK UNIFIED IDEOGRAPH
  {0xCBCD, 0x7B87}, //12299 #CJK UNIFIED IDEOGRAPH
  {0xCBCE, 0x82A5}, //12300 #CJK UNIFIED IDEOGRAPH
  {0xCBCF, 0x84CB}, //12301 #CJK UNIFIED IDEOGRAPH
  {0xCBD0, 0xF900}, //12302 #CJK COMPATIBILITY IDEOGRAPH
  {0xCBD1, 0x93A7}, //12303 #CJK UNIFIED IDEOGRAPH
  {0xCBD2, 0x958B}, //12304 #CJK UNIFIED IDEOGRAPH
  {0xCBD3, 0x5580}, //12305 #CJK UNIFIED IDEOGRAPH
  {0xCBD4, 0x5BA2}, //12306 #CJK UNIFIED IDEOGRAPH
  {0xCBD5, 0x5751}, //12307 #CJK UNIFIED IDEOGRAPH
  {0xCBD6, 0xF901}, //12308 #CJK COMPATIBILITY IDEOGRAPH
  {0xCBD7, 0x7CB3}, //12309 #CJK UNIFIED IDEOGRAPH
  {0xCBD8, 0x7FB9}, //12310 #CJK UNIFIED IDEOGRAPH
  {0xCBD9, 0x91B5}, //12311 #CJK UNIFIED IDEOGRAPH
  {0xCBDA, 0x5028}, //12312 #CJK UNIFIED IDEOGRAPH
  {0xCBDB, 0x53BB}, //12313 #CJK UNIFIED IDEOGRAPH
  {0xCBDC, 0x5C45}, //12314 #CJK UNIFIED IDEOGRAPH
  {0xCBDD, 0x5DE8}, //12315 #CJK UNIFIED IDEOGRAPH
  {0xCBDE, 0x62D2}, //12316 #CJK UNIFIED IDEOGRAPH
  {0xCBDF, 0x636E}, //12317 #CJK UNIFIED IDEOGRAPH
  {0xCBE0, 0x64DA}, //12318 #CJK UNIFIED IDEOGRAPH
  {0xCBE1, 0x64E7}, //12319 #CJK UNIFIED IDEOGRAPH
  {0xCBE2, 0x6E20}, //12320 #CJK UNIFIED IDEOGRAPH
  {0xCBE3, 0x70AC}, //12321 #CJK UNIFIED IDEOGRAPH
  {0xCBE4, 0x795B}, //12322 #CJK UNIFIED IDEOGRAPH
  {0xCBE5, 0x8DDD}, //12323 #CJK UNIFIED IDEOGRAPH
  {0xCBE6, 0x8E1E}, //12324 #CJK UNIFIED IDEOGRAPH
  {0xCBE7, 0xF902}, //12325 #CJK COMPATIBILITY IDEOGRAPH
  {0xCBE8, 0x907D}, //12326 #CJK UNIFIED IDEOGRAPH
  {0xCBE9, 0x9245}, //12327 #CJK UNIFIED IDEOGRAPH
  {0xCBEA, 0x92F8}, //12328 #CJK UNIFIED IDEOGRAPH
  {0xCBEB, 0x4E7E}, //12329 #CJK UNIFIED IDEOGRAPH
  {0xCBEC, 0x4EF6}, //12330 #CJK UNIFIED IDEOGRAPH
  {0xCBED, 0x5065}, //12331 #CJK UNIFIED IDEOGRAPH
  {0xCBEE, 0x5DFE}, //12332 #CJK UNIFIED IDEOGRAPH
  {0xCBEF, 0x5EFA}, //12333 #CJK UNIFIED IDEOGRAPH
  {0xCBF0, 0x6106}, //12334 #CJK UNIFIED IDEOGRAPH
  {0xCBF1, 0x6957}, //12335 #CJK UNIFIED IDEOGRAPH
  {0xCBF2, 0x8171}, //12336 #CJK UNIFIED IDEOGRAPH
  {0xCBF3, 0x8654}, //12337 #CJK UNIFIED IDEOGRAPH
  {0xCBF4, 0x8E47}, //12338 #CJK UNIFIED IDEOGRAPH
  {0xCBF5, 0x9375}, //12339 #CJK UNIFIED IDEOGRAPH
  {0xCBF6, 0x9A2B}, //12340 #CJK UNIFIED IDEOGRAPH
  {0xCBF7, 0x4E5E}, //12341 #CJK UNIFIED IDEOGRAPH
  {0xCBF8, 0x5091}, //12342 #CJK UNIFIED IDEOGRAPH
  {0xCBF9, 0x6770}, //12343 #CJK UNIFIED IDEOGRAPH
  {0xCBFA, 0x6840}, //12344 #CJK UNIFIED IDEOGRAPH
  {0xCBFB, 0x5109}, //12345 #CJK UNIFIED IDEOGRAPH
  {0xCBFC, 0x528D}, //12346 #CJK UNIFIED IDEOGRAPH
  {0xCBFD, 0x5292}, //12347 #CJK UNIFIED IDEOGRAPH
  {0xCBFE, 0x6AA2}, //12348 #CJK UNIFIED IDEOGRAPH
  {0xCCA1, 0x77BC}, //12349 #CJK UNIFIED IDEOGRAPH
  {0xCCA2, 0x9210}, //12350 #CJK UNIFIED IDEOGRAPH
  {0xCCA3, 0x9ED4}, //12351 #CJK UNIFIED IDEOGRAPH
  {0xCCA4, 0x52AB}, //12352 #CJK UNIFIED IDEOGRAPH
  {0xCCA5, 0x602F}, //12353 #CJK UNIFIED IDEOGRAPH
  {0xCCA6, 0x8FF2}, //12354 #CJK UNIFIED IDEOGRAPH
  {0xCCA7, 0x5048}, //12355 #CJK UNIFIED IDEOGRAPH
  {0xCCA8, 0x61A9}, //12356 #CJK UNIFIED IDEOGRAPH
  {0xCCA9, 0x63ED}, //12357 #CJK UNIFIED IDEOGRAPH
  {0xCCAA, 0x64CA}, //12358 #CJK UNIFIED IDEOGRAPH
  {0xCCAB, 0x683C}, //12359 #CJK UNIFIED IDEOGRAPH
  {0xCCAC, 0x6A84}, //12360 #CJK UNIFIED IDEOGRAPH
  {0xCCAD, 0x6FC0}, //12361 #CJK UNIFIED IDEOGRAPH
  {0xCCAE, 0x8188}, //12362 #CJK UNIFIED IDEOGRAPH
  {0xCCAF, 0x89A1}, //12363 #CJK UNIFIED IDEOGRAPH
  {0xCCB0, 0x9694}, //12364 #CJK UNIFIED IDEOGRAPH
  {0xCCB1, 0x5805}, //12365 #CJK UNIFIED IDEOGRAPH
  {0xCCB2, 0x727D}, //12366 #CJK UNIFIED IDEOGRAPH
  {0xCCB3, 0x72AC}, //12367 #CJK UNIFIED IDEOGRAPH
  {0xCCB4, 0x7504}, //12368 #CJK UNIFIED IDEOGRAPH
  {0xCCB5, 0x7D79}, //12369 #CJK UNIFIED IDEOGRAPH
  {0xCCB6, 0x7E6D}, //12370 #CJK UNIFIED IDEOGRAPH
  {0xCCB7, 0x80A9}, //12371 #CJK UNIFIED IDEOGRAPH
  {0xCCB8, 0x898B}, //12372 #CJK UNIFIED IDEOGRAPH
  {0xCCB9, 0x8B74}, //12373 #CJK UNIFIED IDEOGRAPH
  {0xCCBA, 0x9063}, //12374 #CJK UNIFIED IDEOGRAPH
  {0xCCBB, 0x9D51}, //12375 #CJK UNIFIED IDEOGRAPH
  {0xCCBC, 0x6289}, //12376 #CJK UNIFIED IDEOGRAPH
  {0xCCBD, 0x6C7A}, //12377 #CJK UNIFIED IDEOGRAPH
  {0xCCBE, 0x6F54}, //12378 #CJK UNIFIED IDEOGRAPH
  {0xCCBF, 0x7D50}, //12379 #CJK UNIFIED IDEOGRAPH
  {0xCCC0, 0x7F3A}, //12380 #CJK UNIFIED IDEOGRAPH
  {0xCCC1, 0x8A23}, //12381 #CJK UNIFIED IDEOGRAPH
  {0xCCC2, 0x517C}, //12382 #CJK UNIFIED IDEOGRAPH
  {0xCCC3, 0x614A}, //12383 #CJK UNIFIED IDEOGRAPH
  {0xCCC4, 0x7B9D}, //12384 #CJK UNIFIED IDEOGRAPH
  {0xCCC5, 0x8B19}, //12385 #CJK UNIFIED IDEOGRAPH
  {0xCCC6, 0x9257}, //12386 #CJK UNIFIED IDEOGRAPH
  {0xCCC7, 0x938C}, //12387 #CJK UNIFIED IDEOGRAPH
  {0xCCC8, 0x4EAC}, //12388 #CJK UNIFIED IDEOGRAPH
  {0xCCC9, 0x4FD3}, //12389 #CJK UNIFIED IDEOGRAPH
  {0xCCCA, 0x501E}, //12390 #CJK UNIFIED IDEOGRAPH
  {0xCCCB, 0x50BE}, //12391 #CJK UNIFIED IDEOGRAPH
  {0xCCCC, 0x5106}, //12392 #CJK UNIFIED IDEOGRAPH
  {0xCCCD, 0x52C1}, //12393 #CJK UNIFIED IDEOGRAPH
  {0xCCCE, 0x52CD}, //12394 #CJK UNIFIED IDEOGRAPH
  {0xCCCF, 0x537F}, //12395 #CJK UNIFIED IDEOGRAPH
  {0xCCD0, 0x5770}, //12396 #CJK UNIFIED IDEOGRAPH
  {0xCCD1, 0x5883}, //12397 #CJK UNIFIED IDEOGRAPH
  {0xCCD2, 0x5E9A}, //12398 #CJK UNIFIED IDEOGRAPH
  {0xCCD3, 0x5F91}, //12399 #CJK UNIFIED IDEOGRAPH
  {0xCCD4, 0x6176}, //12400 #CJK UNIFIED IDEOGRAPH
  {0xCCD5, 0x61AC}, //12401 #CJK UNIFIED IDEOGRAPH
  {0xCCD6, 0x64CE}, //12402 #CJK UNIFIED IDEOGRAPH
  {0xCCD7, 0x656C}, //12403 #CJK UNIFIED IDEOGRAPH
  {0xCCD8, 0x666F}, //12404 #CJK UNIFIED IDEOGRAPH
  {0xCCD9, 0x66BB}, //12405 #CJK UNIFIED IDEOGRAPH
  {0xCCDA, 0x66F4}, //12406 #CJK UNIFIED IDEOGRAPH
  {0xCCDB, 0x6897}, //12407 #CJK UNIFIED IDEOGRAPH
  {0xCCDC, 0x6D87}, //12408 #CJK UNIFIED IDEOGRAPH
  {0xCCDD, 0x7085}, //12409 #CJK UNIFIED IDEOGRAPH
  {0xCCDE, 0x70F1}, //12410 #CJK UNIFIED IDEOGRAPH
  {0xCCDF, 0x749F}, //12411 #CJK UNIFIED IDEOGRAPH
  {0xCCE0, 0x74A5}, //12412 #CJK UNIFIED IDEOGRAPH
  {0xCCE1, 0x74CA}, //12413 #CJK UNIFIED IDEOGRAPH
  {0xCCE2, 0x75D9}, //12414 #CJK UNIFIED IDEOGRAPH
  {0xCCE3, 0x786C}, //12415 #CJK UNIFIED IDEOGRAPH
  {0xCCE4, 0x78EC}, //12416 #CJK UNIFIED IDEOGRAPH
  {0xCCE5, 0x7ADF}, //12417 #CJK UNIFIED IDEOGRAPH
  {0xCCE6, 0x7AF6}, //12418 #CJK UNIFIED IDEOGRAPH
  {0xCCE7, 0x7D45}, //12419 #CJK UNIFIED IDEOGRAPH
  {0xCCE8, 0x7D93}, //12420 #CJK UNIFIED IDEOGRAPH
  {0xCCE9, 0x8015}, //12421 #CJK UNIFIED IDEOGRAPH
  {0xCCEA, 0x803F}, //12422 #CJK UNIFIED IDEOGRAPH
  {0xCCEB, 0x811B}, //12423 #CJK UNIFIED IDEOGRAPH
  {0xCCEC, 0x8396}, //12424 #CJK UNIFIED IDEOGRAPH
  {0xCCED, 0x8B66}, //12425 #CJK UNIFIED IDEOGRAPH
  {0xCCEE, 0x8F15}, //12426 #CJK UNIFIED IDEOGRAPH
  {0xCCEF, 0x9015}, //12427 #CJK UNIFIED IDEOGRAPH
  {0xCCF0, 0x93E1}, //12428 #CJK UNIFIED IDEOGRAPH
  {0xCCF1, 0x9803}, //12429 #CJK UNIFIED IDEOGRAPH
  {0xCCF2, 0x9838}, //12430 #CJK UNIFIED IDEOGRAPH
  {0xCCF3, 0x9A5A}, //12431 #CJK UNIFIED IDEOGRAPH
  {0xCCF4, 0x9BE8}, //12432 #CJK UNIFIED IDEOGRAPH
  {0xCCF5, 0x4FC2}, //12433 #CJK UNIFIED IDEOGRAPH
  {0xCCF6, 0x5553}, //12434 #CJK UNIFIED IDEOGRAPH
  {0xCCF7, 0x583A}, //12435 #CJK UNIFIED IDEOGRAPH
  {0xCCF8, 0x5951}, //12436 #CJK UNIFIED IDEOGRAPH
  {0xCCF9, 0x5B63}, //12437 #CJK UNIFIED IDEOGRAPH
  {0xCCFA, 0x5C46}, //12438 #CJK UNIFIED IDEOGRAPH
  {0xCCFB, 0x60B8}, //12439 #CJK UNIFIED IDEOGRAPH
  {0xCCFC, 0x6212}, //12440 #CJK UNIFIED IDEOGRAPH
  {0xCCFD, 0x6842}, //12441 #CJK UNIFIED IDEOGRAPH
  {0xCCFE, 0x68B0}, //12442 #CJK UNIFIED IDEOGRAPH
  {0xCDA1, 0x68E8}, //12443 #CJK UNIFIED IDEOGRAPH
  {0xCDA2, 0x6EAA}, //12444 #CJK UNIFIED IDEOGRAPH
  {0xCDA3, 0x754C}, //12445 #CJK UNIFIED IDEOGRAPH
  {0xCDA4, 0x7678}, //12446 #CJK UNIFIED IDEOGRAPH
  {0xCDA5, 0x78CE}, //12447 #CJK UNIFIED IDEOGRAPH
  {0xCDA6, 0x7A3D}, //12448 #CJK UNIFIED IDEOGRAPH
  {0xCDA7, 0x7CFB}, //12449 #CJK UNIFIED IDEOGRAPH
  {0xCDA8, 0x7E6B}, //12450 #CJK UNIFIED IDEOGRAPH
  {0xCDA9, 0x7E7C}, //12451 #CJK UNIFIED IDEOGRAPH
  {0xCDAA, 0x8A08}, //12452 #CJK UNIFIED IDEOGRAPH
  {0xCDAB, 0x8AA1}, //12453 #CJK UNIFIED IDEOGRAPH
  {0xCDAC, 0x8C3F}, //12454 #CJK UNIFIED IDEOGRAPH
  {0xCDAD, 0x968E}, //12455 #CJK UNIFIED IDEOGRAPH
  {0xCDAE, 0x9DC4}, //12456 #CJK UNIFIED IDEOGRAPH
  {0xCDAF, 0x53E4}, //12457 #CJK UNIFIED IDEOGRAPH
  {0xCDB0, 0x53E9}, //12458 #CJK UNIFIED IDEOGRAPH
  {0xCDB1, 0x544A}, //12459 #CJK UNIFIED IDEOGRAPH
  {0xCDB2, 0x5471}, //12460 #CJK UNIFIED IDEOGRAPH
  {0xCDB3, 0x56FA}, //12461 #CJK UNIFIED IDEOGRAPH
  {0xCDB4, 0x59D1}, //12462 #CJK UNIFIED IDEOGRAPH
  {0xCDB5, 0x5B64}, //12463 #CJK UNIFIED IDEOGRAPH
  {0xCDB6, 0x5C3B}, //12464 #CJK UNIFIED IDEOGRAPH
  {0xCDB7, 0x5EAB}, //12465 #CJK UNIFIED IDEOGRAPH
  {0xCDB8, 0x62F7}, //12466 #CJK UNIFIED IDEOGRAPH
  {0xCDB9, 0x6537}, //12467 #CJK UNIFIED IDEOGRAPH
  {0xCDBA, 0x6545}, //12468 #CJK UNIFIED IDEOGRAPH
  {0xCDBB, 0x6572}, //12469 #CJK UNIFIED IDEOGRAPH
  {0xCDBC, 0x66A0}, //12470 #CJK UNIFIED IDEOGRAPH
  {0xCDBD, 0x67AF}, //12471 #CJK UNIFIED IDEOGRAPH
  {0xCDBE, 0x69C1}, //12472 #CJK UNIFIED IDEOGRAPH
  {0xCDBF, 0x6CBD}, //12473 #CJK UNIFIED IDEOGRAPH
  {0xCDC0, 0x75FC}, //12474 #CJK UNIFIED IDEOGRAPH
  {0xCDC1, 0x7690}, //12475 #CJK UNIFIED IDEOGRAPH
  {0xCDC2, 0x777E}, //12476 #CJK UNIFIED IDEOGRAPH
  {0xCDC3, 0x7A3F}, //12477 #CJK UNIFIED IDEOGRAPH
  {0xCDC4, 0x7F94}, //12478 #CJK UNIFIED IDEOGRAPH
  {0xCDC5, 0x8003}, //12479 #CJK UNIFIED IDEOGRAPH
  {0xCDC6, 0x80A1}, //12480 #CJK UNIFIED IDEOGRAPH
  {0xCDC7, 0x818F}, //12481 #CJK UNIFIED IDEOGRAPH
  {0xCDC8, 0x82E6}, //12482 #CJK UNIFIED IDEOGRAPH
  {0xCDC9, 0x82FD}, //12483 #CJK UNIFIED IDEOGRAPH
  {0xCDCA, 0x83F0}, //12484 #CJK UNIFIED IDEOGRAPH
  {0xCDCB, 0x85C1}, //12485 #CJK UNIFIED IDEOGRAPH
  {0xCDCC, 0x8831}, //12486 #CJK UNIFIED IDEOGRAPH
  {0xCDCD, 0x88B4}, //12487 #CJK UNIFIED IDEOGRAPH
  {0xCDCE, 0x8AA5}, //12488 #CJK UNIFIED IDEOGRAPH
  {0xCDCF, 0xF903}, //12489 #CJK COMPATIBILITY IDEOGRAPH
  {0xCDD0, 0x8F9C}, //12490 #CJK UNIFIED IDEOGRAPH
  {0xCDD1, 0x932E}, //12491 #CJK UNIFIED IDEOGRAPH
  {0xCDD2, 0x96C7}, //12492 #CJK UNIFIED IDEOGRAPH
  {0xCDD3, 0x9867}, //12493 #CJK UNIFIED IDEOGRAPH
  {0xCDD4, 0x9AD8}, //12494 #CJK UNIFIED IDEOGRAPH
  {0xCDD5, 0x9F13}, //12495 #CJK UNIFIED IDEOGRAPH
  {0xCDD6, 0x54ED}, //12496 #CJK UNIFIED IDEOGRAPH
  {0xCDD7, 0x659B}, //12497 #CJK UNIFIED IDEOGRAPH
  {0xCDD8, 0x66F2}, //12498 #CJK UNIFIED IDEOGRAPH
  {0xCDD9, 0x688F}, //12499 #CJK UNIFIED IDEOGRAPH
  {0xCDDA, 0x7A40}, //12500 #CJK UNIFIED IDEOGRAPH
  {0xCDDB, 0x8C37}, //12501 #CJK UNIFIED IDEOGRAPH
  {0xCDDC, 0x9D60}, //12502 #CJK UNIFIED IDEOGRAPH
  {0xCDDD, 0x56F0}, //12503 #CJK UNIFIED IDEOGRAPH
  {0xCDDE, 0x5764}, //12504 #CJK UNIFIED IDEOGRAPH
  {0xCDDF, 0x5D11}, //12505 #CJK UNIFIED IDEOGRAPH
  {0xCDE0, 0x6606}, //12506 #CJK UNIFIED IDEOGRAPH
  {0xCDE1, 0x68B1}, //12507 #CJK UNIFIED IDEOGRAPH
  {0xCDE2, 0x68CD}, //12508 #CJK UNIFIED IDEOGRAPH
  {0xCDE3, 0x6EFE}, //12509 #CJK UNIFIED IDEOGRAPH
  {0xCDE4, 0x7428}, //12510 #CJK UNIFIED IDEOGRAPH
  {0xCDE5, 0x889E}, //12511 #CJK UNIFIED IDEOGRAPH
  {0xCDE6, 0x9BE4}, //12512 #CJK UNIFIED IDEOGRAPH
  {0xCDE7, 0x6C68}, //12513 #CJK UNIFIED IDEOGRAPH
  {0xCDE8, 0xF904}, //12514 #CJK COMPATIBILITY IDEOGRAPH
  {0xCDE9, 0x9AA8}, //12515 #CJK UNIFIED IDEOGRAPH
  {0xCDEA, 0x4F9B}, //12516 #CJK UNIFIED IDEOGRAPH
  {0xCDEB, 0x516C}, //12517 #CJK UNIFIED IDEOGRAPH
  {0xCDEC, 0x5171}, //12518 #CJK UNIFIED IDEOGRAPH
  {0xCDED, 0x529F}, //12519 #CJK UNIFIED IDEOGRAPH
  {0xCDEE, 0x5B54}, //12520 #CJK UNIFIED IDEOGRAPH
  {0xCDEF, 0x5DE5}, //12521 #CJK UNIFIED IDEOGRAPH
  {0xCDF0, 0x6050}, //12522 #CJK UNIFIED IDEOGRAPH
  {0xCDF1, 0x606D}, //12523 #CJK UNIFIED IDEOGRAPH
  {0xCDF2, 0x62F1}, //12524 #CJK UNIFIED IDEOGRAPH
  {0xCDF3, 0x63A7}, //12525 #CJK UNIFIED IDEOGRAPH
  {0xCDF4, 0x653B}, //12526 #CJK UNIFIED IDEOGRAPH
  {0xCDF5, 0x73D9}, //12527 #CJK UNIFIED IDEOGRAPH
  {0xCDF6, 0x7A7A}, //12528 #CJK UNIFIED IDEOGRAPH
  {0xCDF7, 0x86A3}, //12529 #CJK UNIFIED IDEOGRAPH
  {0xCDF8, 0x8CA2}, //12530 #CJK UNIFIED IDEOGRAPH
  {0xCDF9, 0x978F}, //12531 #CJK UNIFIED IDEOGRAPH
  {0xCDFA, 0x4E32}, //12532 #CJK UNIFIED IDEOGRAPH
  {0xCDFB, 0x5BE1}, //12533 #CJK UNIFIED IDEOGRAPH
  {0xCDFC, 0x6208}, //12534 #CJK UNIFIED IDEOGRAPH
  {0xCDFD, 0x679C}, //12535 #CJK UNIFIED IDEOGRAPH
  {0xCDFE, 0x74DC}, //12536 #CJK UNIFIED IDEOGRAPH
  {0xCEA1, 0x79D1}, //12537 #CJK UNIFIED IDEOGRAPH
  {0xCEA2, 0x83D3}, //12538 #CJK UNIFIED IDEOGRAPH
  {0xCEA3, 0x8A87}, //12539 #CJK UNIFIED IDEOGRAPH
  {0xCEA4, 0x8AB2}, //12540 #CJK UNIFIED IDEOGRAPH
  {0xCEA5, 0x8DE8}, //12541 #CJK UNIFIED IDEOGRAPH
  {0xCEA6, 0x904E}, //12542 #CJK UNIFIED IDEOGRAPH
  {0xCEA7, 0x934B}, //12543 #CJK UNIFIED IDEOGRAPH
  {0xCEA8, 0x9846}, //12544 #CJK UNIFIED IDEOGRAPH
  {0xCEA9, 0x5ED3}, //12545 #CJK UNIFIED IDEOGRAPH
  {0xCEAA, 0x69E8}, //12546 #CJK UNIFIED IDEOGRAPH
  {0xCEAB, 0x85FF}, //12547 #CJK UNIFIED IDEOGRAPH
  {0xCEAC, 0x90ED}, //12548 #CJK UNIFIED IDEOGRAPH
  {0xCEAD, 0xF905}, //12549 #CJK COMPATIBILITY IDEOGRAPH
  {0xCEAE, 0x51A0}, //12550 #CJK UNIFIED IDEOGRAPH
  {0xCEAF, 0x5B98}, //12551 #CJK UNIFIED IDEOGRAPH
  {0xCEB0, 0x5BEC}, //12552 #CJK UNIFIED IDEOGRAPH
  {0xCEB1, 0x6163}, //12553 #CJK UNIFIED IDEOGRAPH
  {0xCEB2, 0x68FA}, //12554 #CJK UNIFIED IDEOGRAPH
  {0xCEB3, 0x6B3E}, //12555 #CJK UNIFIED IDEOGRAPH
  {0xCEB4, 0x704C}, //12556 #CJK UNIFIED IDEOGRAPH
  {0xCEB5, 0x742F}, //12557 #CJK UNIFIED IDEOGRAPH
  {0xCEB6, 0x74D8}, //12558 #CJK UNIFIED IDEOGRAPH
  {0xCEB7, 0x7BA1}, //12559 #CJK UNIFIED IDEOGRAPH
  {0xCEB8, 0x7F50}, //12560 #CJK UNIFIED IDEOGRAPH
  {0xCEB9, 0x83C5}, //12561 #CJK UNIFIED IDEOGRAPH
  {0xCEBA, 0x89C0}, //12562 #CJK UNIFIED IDEOGRAPH
  {0xCEBB, 0x8CAB}, //12563 #CJK UNIFIED IDEOGRAPH
  {0xCEBC, 0x95DC}, //12564 #CJK UNIFIED IDEOGRAPH
  {0xCEBD, 0x9928}, //12565 #CJK UNIFIED IDEOGRAPH
  {0xCEBE, 0x522E}, //12566 #CJK UNIFIED IDEOGRAPH
  {0xCEBF, 0x605D}, //12567 #CJK UNIFIED IDEOGRAPH
  {0xCEC0, 0x62EC}, //12568 #CJK UNIFIED IDEOGRAPH
  {0xCEC1, 0x9002}, //12569 #CJK UNIFIED IDEOGRAPH
  {0xCEC2, 0x4F8A}, //12570 #CJK UNIFIED IDEOGRAPH
  {0xCEC3, 0x5149}, //12571 #CJK UNIFIED IDEOGRAPH
  {0xCEC4, 0x5321}, //12572 #CJK UNIFIED IDEOGRAPH
  {0xCEC5, 0x58D9}, //12573 #CJK UNIFIED IDEOGRAPH
  {0xCEC6, 0x5EE3}, //12574 #CJK UNIFIED IDEOGRAPH
  {0xCEC7, 0x66E0}, //12575 #CJK UNIFIED IDEOGRAPH
  {0xCEC8, 0x6D38}, //12576 #CJK UNIFIED IDEOGRAPH
  {0xCEC9, 0x709A}, //12577 #CJK UNIFIED IDEOGRAPH
  {0xCECA, 0x72C2}, //12578 #CJK UNIFIED IDEOGRAPH
  {0xCECB, 0x73D6}, //12579 #CJK UNIFIED IDEOGRAPH
  {0xCECC, 0x7B50}, //12580 #CJK UNIFIED IDEOGRAPH
  {0xCECD, 0x80F1}, //12581 #CJK UNIFIED IDEOGRAPH
  {0xCECE, 0x945B}, //12582 #CJK UNIFIED IDEOGRAPH
  {0xCECF, 0x5366}, //12583 #CJK UNIFIED IDEOGRAPH
  {0xCED0, 0x639B}, //12584 #CJK UNIFIED IDEOGRAPH
  {0xCED1, 0x7F6B}, //12585 #CJK UNIFIED IDEOGRAPH
  {0xCED2, 0x4E56}, //12586 #CJK UNIFIED IDEOGRAPH
  {0xCED3, 0x5080}, //12587 #CJK UNIFIED IDEOGRAPH
  {0xCED4, 0x584A}, //12588 #CJK UNIFIED IDEOGRAPH
  {0xCED5, 0x58DE}, //12589 #CJK UNIFIED IDEOGRAPH
  {0xCED6, 0x602A}, //12590 #CJK UNIFIED IDEOGRAPH
  {0xCED7, 0x6127}, //12591 #CJK UNIFIED IDEOGRAPH
  {0xCED8, 0x62D0}, //12592 #CJK UNIFIED IDEOGRAPH
  {0xCED9, 0x69D0}, //12593 #CJK UNIFIED IDEOGRAPH
  {0xCEDA, 0x9B41}, //12594 #CJK UNIFIED IDEOGRAPH
  {0xCEDB, 0x5B8F}, //12595 #CJK UNIFIED IDEOGRAPH
  {0xCEDC, 0x7D18}, //12596 #CJK UNIFIED IDEOGRAPH
  {0xCEDD, 0x80B1}, //12597 #CJK UNIFIED IDEOGRAPH
  {0xCEDE, 0x8F5F}, //12598 #CJK UNIFIED IDEOGRAPH
  {0xCEDF, 0x4EA4}, //12599 #CJK UNIFIED IDEOGRAPH
  {0xCEE0, 0x50D1}, //12600 #CJK UNIFIED IDEOGRAPH
  {0xCEE1, 0x54AC}, //12601 #CJK UNIFIED IDEOGRAPH
  {0xCEE2, 0x55AC}, //12602 #CJK UNIFIED IDEOGRAPH
  {0xCEE3, 0x5B0C}, //12603 #CJK UNIFIED IDEOGRAPH
  {0xCEE4, 0x5DA0}, //12604 #CJK UNIFIED IDEOGRAPH
  {0xCEE5, 0x5DE7}, //12605 #CJK UNIFIED IDEOGRAPH
  {0xCEE6, 0x652A}, //12606 #CJK UNIFIED IDEOGRAPH
  {0xCEE7, 0x654E}, //12607 #CJK UNIFIED IDEOGRAPH
  {0xCEE8, 0x6821}, //12608 #CJK UNIFIED IDEOGRAPH
  {0xCEE9, 0x6A4B}, //12609 #CJK UNIFIED IDEOGRAPH
  {0xCEEA, 0x72E1}, //12610 #CJK UNIFIED IDEOGRAPH
  {0xCEEB, 0x768E}, //12611 #CJK UNIFIED IDEOGRAPH
  {0xCEEC, 0x77EF}, //12612 #CJK UNIFIED IDEOGRAPH
  {0xCEED, 0x7D5E}, //12613 #CJK UNIFIED IDEOGRAPH
  {0xCEEE, 0x7FF9}, //12614 #CJK UNIFIED IDEOGRAPH
  {0xCEEF, 0x81A0}, //12615 #CJK UNIFIED IDEOGRAPH
  {0xCEF0, 0x854E}, //12616 #CJK UNIFIED IDEOGRAPH
  {0xCEF1, 0x86DF}, //12617 #CJK UNIFIED IDEOGRAPH
  {0xCEF2, 0x8F03}, //12618 #CJK UNIFIED IDEOGRAPH
  {0xCEF3, 0x8F4E}, //12619 #CJK UNIFIED IDEOGRAPH
  {0xCEF4, 0x90CA}, //12620 #CJK UNIFIED IDEOGRAPH
  {0xCEF5, 0x9903}, //12621 #CJK UNIFIED IDEOGRAPH
  {0xCEF6, 0x9A55}, //12622 #CJK UNIFIED IDEOGRAPH
  {0xCEF7, 0x9BAB}, //12623 #CJK UNIFIED IDEOGRAPH
  {0xCEF8, 0x4E18}, //12624 #CJK UNIFIED IDEOGRAPH
  {0xCEF9, 0x4E45}, //12625 #CJK UNIFIED IDEOGRAPH
  {0xCEFA, 0x4E5D}, //12626 #CJK UNIFIED IDEOGRAPH
  {0xCEFB, 0x4EC7}, //12627 #CJK UNIFIED IDEOGRAPH
  {0xCEFC, 0x4FF1}, //12628 #CJK UNIFIED IDEOGRAPH
  {0xCEFD, 0x5177}, //12629 #CJK UNIFIED IDEOGRAPH
  {0xCEFE, 0x52FE}, //12630 #CJK UNIFIED IDEOGRAPH
  {0xCFA1, 0x5340}, //12631 #CJK UNIFIED IDEOGRAPH
  {0xCFA2, 0x53E3}, //12632 #CJK UNIFIED IDEOGRAPH
  {0xCFA3, 0x53E5}, //12633 #CJK UNIFIED IDEOGRAPH
  {0xCFA4, 0x548E}, //12634 #CJK UNIFIED IDEOGRAPH
  {0xCFA5, 0x5614}, //12635 #CJK UNIFIED IDEOGRAPH
  {0xCFA6, 0x5775}, //12636 #CJK UNIFIED IDEOGRAPH
  {0xCFA7, 0x57A2}, //12637 #CJK UNIFIED IDEOGRAPH
  {0xCFA8, 0x5BC7}, //12638 #CJK UNIFIED IDEOGRAPH
  {0xCFA9, 0x5D87}, //12639 #CJK UNIFIED IDEOGRAPH
  {0xCFAA, 0x5ED0}, //12640 #CJK UNIFIED IDEOGRAPH
  {0xCFAB, 0x61FC}, //12641 #CJK UNIFIED IDEOGRAPH
  {0xCFAC, 0x62D8}, //12642 #CJK UNIFIED IDEOGRAPH
  {0xCFAD, 0x6551}, //12643 #CJK UNIFIED IDEOGRAPH
  {0xCFAE, 0x67B8}, //12644 #CJK UNIFIED IDEOGRAPH
  {0xCFAF, 0x67E9}, //12645 #CJK UNIFIED IDEOGRAPH
  {0xCFB0, 0x69CB}, //12646 #CJK UNIFIED IDEOGRAPH
  {0xCFB1, 0x6B50}, //12647 #CJK UNIFIED IDEOGRAPH
  {0xCFB2, 0x6BC6}, //12648 #CJK UNIFIED IDEOGRAPH
  {0xCFB3, 0x6BEC}, //12649 #CJK UNIFIED IDEOGRAPH
  {0xCFB4, 0x6C42}, //12650 #CJK UNIFIED IDEOGRAPH
  {0xCFB5, 0x6E9D}, //12651 #CJK UNIFIED IDEOGRAPH
  {0xCFB6, 0x7078}, //12652 #CJK UNIFIED IDEOGRAPH
  {0xCFB7, 0x72D7}, //12653 #CJK UNIFIED IDEOGRAPH
  {0xCFB8, 0x7396}, //12654 #CJK UNIFIED IDEOGRAPH
  {0xCFB9, 0x7403}, //12655 #CJK UNIFIED IDEOGRAPH
  {0xCFBA, 0x77BF}, //12656 #CJK UNIFIED IDEOGRAPH
  {0xCFBB, 0x77E9}, //12657 #CJK UNIFIED IDEOGRAPH
  {0xCFBC, 0x7A76}, //12658 #CJK UNIFIED IDEOGRAPH
  {0xCFBD, 0x7D7F}, //12659 #CJK UNIFIED IDEOGRAPH
  {0xCFBE, 0x8009}, //12660 #CJK UNIFIED IDEOGRAPH
  {0xCFBF, 0x81FC}, //12661 #CJK UNIFIED IDEOGRAPH
  {0xCFC0, 0x8205}, //12662 #CJK UNIFIED IDEOGRAPH
  {0xCFC1, 0x820A}, //12663 #CJK UNIFIED IDEOGRAPH
  {0xCFC2, 0x82DF}, //12664 #CJK UNIFIED IDEOGRAPH
  {0xCFC3, 0x8862}, //12665 #CJK UNIFIED IDEOGRAPH
  {0xCFC4, 0x8B33}, //12666 #CJK UNIFIED IDEOGRAPH
  {0xCFC5, 0x8CFC}, //12667 #CJK UNIFIED IDEOGRAPH
  {0xCFC6, 0x8EC0}, //12668 #CJK UNIFIED IDEOGRAPH
  {0xCFC7, 0x9011}, //12669 #CJK UNIFIED IDEOGRAPH
  {0xCFC8, 0x90B1}, //12670 #CJK UNIFIED IDEOGRAPH
  {0xCFC9, 0x9264}, //12671 #CJK UNIFIED IDEOGRAPH
  {0xCFCA, 0x92B6}, //12672 #CJK UNIFIED IDEOGRAPH
  {0xCFCB, 0x99D2}, //12673 #CJK UNIFIED IDEOGRAPH
  {0xCFCC, 0x9A45}, //12674 #CJK UNIFIED IDEOGRAPH
  {0xCFCD, 0x9CE9}, //12675 #CJK UNIFIED IDEOGRAPH
  {0xCFCE, 0x9DD7}, //12676 #CJK UNIFIED IDEOGRAPH
  {0xCFCF, 0x9F9C}, //12677 #CJK UNIFIED IDEOGRAPH
  {0xCFD0, 0x570B}, //12678 #CJK UNIFIED IDEOGRAPH
  {0xCFD1, 0x5C40}, //12679 #CJK UNIFIED IDEOGRAPH
  {0xCFD2, 0x83CA}, //12680 #CJK UNIFIED IDEOGRAPH
  {0xCFD3, 0x97A0}, //12681 #CJK UNIFIED IDEOGRAPH
  {0xCFD4, 0x97AB}, //12682 #CJK UNIFIED IDEOGRAPH
  {0xCFD5, 0x9EB4}, //12683 #CJK UNIFIED IDEOGRAPH
  {0xCFD6, 0x541B}, //12684 #CJK UNIFIED IDEOGRAPH
  {0xCFD7, 0x7A98}, //12685 #CJK UNIFIED IDEOGRAPH
  {0xCFD8, 0x7FA4}, //12686 #CJK UNIFIED IDEOGRAPH
  {0xCFD9, 0x88D9}, //12687 #CJK UNIFIED IDEOGRAPH
  {0xCFDA, 0x8ECD}, //12688 #CJK UNIFIED IDEOGRAPH
  {0xCFDB, 0x90E1}, //12689 #CJK UNIFIED IDEOGRAPH
  {0xCFDC, 0x5800}, //12690 #CJK UNIFIED IDEOGRAPH
  {0xCFDD, 0x5C48}, //12691 #CJK UNIFIED IDEOGRAPH
  {0xCFDE, 0x6398}, //12692 #CJK UNIFIED IDEOGRAPH
  {0xCFDF, 0x7A9F}, //12693 #CJK UNIFIED IDEOGRAPH
  {0xCFE0, 0x5BAE}, //12694 #CJK UNIFIED IDEOGRAPH
  {0xCFE1, 0x5F13}, //12695 #CJK UNIFIED IDEOGRAPH
  {0xCFE2, 0x7A79}, //12696 #CJK UNIFIED IDEOGRAPH
  {0xCFE3, 0x7AAE}, //12697 #CJK UNIFIED IDEOGRAPH
  {0xCFE4, 0x828E}, //12698 #CJK UNIFIED IDEOGRAPH
  {0xCFE5, 0x8EAC}, //12699 #CJK UNIFIED IDEOGRAPH
  {0xCFE6, 0x5026}, //12700 #CJK UNIFIED IDEOGRAPH
  {0xCFE7, 0x5238}, //12701 #CJK UNIFIED IDEOGRAPH
  {0xCFE8, 0x52F8}, //12702 #CJK UNIFIED IDEOGRAPH
  {0xCFE9, 0x5377}, //12703 #CJK UNIFIED IDEOGRAPH
  {0xCFEA, 0x5708}, //12704 #CJK UNIFIED IDEOGRAPH
  {0xCFEB, 0x62F3}, //12705 #CJK UNIFIED IDEOGRAPH
  {0xCFEC, 0x6372}, //12706 #CJK UNIFIED IDEOGRAPH
  {0xCFED, 0x6B0A}, //12707 #CJK UNIFIED IDEOGRAPH
  {0xCFEE, 0x6DC3}, //12708 #CJK UNIFIED IDEOGRAPH
  {0xCFEF, 0x7737}, //12709 #CJK UNIFIED IDEOGRAPH
  {0xCFF0, 0x53A5}, //12710 #CJK UNIFIED IDEOGRAPH
  {0xCFF1, 0x7357}, //12711 #CJK UNIFIED IDEOGRAPH
  {0xCFF2, 0x8568}, //12712 #CJK UNIFIED IDEOGRAPH
  {0xCFF3, 0x8E76}, //12713 #CJK UNIFIED IDEOGRAPH
  {0xCFF4, 0x95D5}, //12714 #CJK UNIFIED IDEOGRAPH
  {0xCFF5, 0x673A}, //12715 #CJK UNIFIED IDEOGRAPH
  {0xCFF6, 0x6AC3}, //12716 #CJK UNIFIED IDEOGRAPH
  {0xCFF7, 0x6F70}, //12717 #CJK UNIFIED IDEOGRAPH
  {0xCFF8, 0x8A6D}, //12718 #CJK UNIFIED IDEOGRAPH
  {0xCFF9, 0x8ECC}, //12719 #CJK UNIFIED IDEOGRAPH
  {0xCFFA, 0x994B}, //12720 #CJK UNIFIED IDEOGRAPH
  {0xCFFB, 0xF906}, //12721 #CJK COMPATIBILITY IDEOGRAPH
  {0xCFFC, 0x6677}, //12722 #CJK UNIFIED IDEOGRAPH
  {0xCFFD, 0x6B78}, //12723 #CJK UNIFIED IDEOGRAPH
  {0xCFFE, 0x8CB4}, //12724 #CJK UNIFIED IDEOGRAPH
  {0xD0A1, 0x9B3C}, //12725 #CJK UNIFIED IDEOGRAPH
  {0xD0A2, 0xF907}, //12726 #CJK COMPATIBILITY IDEOGRAPH
  {0xD0A3, 0x53EB}, //12727 #CJK UNIFIED IDEOGRAPH
  {0xD0A4, 0x572D}, //12728 #CJK UNIFIED IDEOGRAPH
  {0xD0A5, 0x594E}, //12729 #CJK UNIFIED IDEOGRAPH
  {0xD0A6, 0x63C6}, //12730 #CJK UNIFIED IDEOGRAPH
  {0xD0A7, 0x69FB}, //12731 #CJK UNIFIED IDEOGRAPH
  {0xD0A8, 0x73EA}, //12732 #CJK UNIFIED IDEOGRAPH
  {0xD0A9, 0x7845}, //12733 #CJK UNIFIED IDEOGRAPH
  {0xD0AA, 0x7ABA}, //12734 #CJK UNIFIED IDEOGRAPH
  {0xD0AB, 0x7AC5}, //12735 #CJK UNIFIED IDEOGRAPH
  {0xD0AC, 0x7CFE}, //12736 #CJK UNIFIED IDEOGRAPH
  {0xD0AD, 0x8475}, //12737 #CJK UNIFIED IDEOGRAPH
  {0xD0AE, 0x898F}, //12738 #CJK UNIFIED IDEOGRAPH
  {0xD0AF, 0x8D73}, //12739 #CJK UNIFIED IDEOGRAPH
  {0xD0B0, 0x9035}, //12740 #CJK UNIFIED IDEOGRAPH
  {0xD0B1, 0x95A8}, //12741 #CJK UNIFIED IDEOGRAPH
  {0xD0B2, 0x52FB}, //12742 #CJK UNIFIED IDEOGRAPH
  {0xD0B3, 0x5747}, //12743 #CJK UNIFIED IDEOGRAPH
  {0xD0B4, 0x7547}, //12744 #CJK UNIFIED IDEOGRAPH
  {0xD0B5, 0x7B60}, //12745 #CJK UNIFIED IDEOGRAPH
  {0xD0B6, 0x83CC}, //12746 #CJK UNIFIED IDEOGRAPH
  {0xD0B7, 0x921E}, //12747 #CJK UNIFIED IDEOGRAPH
  {0xD0B8, 0xF908}, //12748 #CJK COMPATIBILITY IDEOGRAPH
  {0xD0B9, 0x6A58}, //12749 #CJK UNIFIED IDEOGRAPH
  {0xD0BA, 0x514B}, //12750 #CJK UNIFIED IDEOGRAPH
  {0xD0BB, 0x524B}, //12751 #CJK UNIFIED IDEOGRAPH
  {0xD0BC, 0x5287}, //12752 #CJK UNIFIED IDEOGRAPH
  {0xD0BD, 0x621F}, //12753 #CJK UNIFIED IDEOGRAPH
  {0xD0BE, 0x68D8}, //12754 #CJK UNIFIED IDEOGRAPH
  {0xD0BF, 0x6975}, //12755 #CJK UNIFIED IDEOGRAPH
  {0xD0C0, 0x9699}, //12756 #CJK UNIFIED IDEOGRAPH
  {0xD0C1, 0x50C5}, //12757 #CJK UNIFIED IDEOGRAPH
  {0xD0C2, 0x52A4}, //12758 #CJK UNIFIED IDEOGRAPH
  {0xD0C3, 0x52E4}, //12759 #CJK UNIFIED IDEOGRAPH
  {0xD0C4, 0x61C3}, //12760 #CJK UNIFIED IDEOGRAPH
  {0xD0C5, 0x65A4}, //12761 #CJK UNIFIED IDEOGRAPH
  {0xD0C6, 0x6839}, //12762 #CJK UNIFIED IDEOGRAPH
  {0xD0C7, 0x69FF}, //12763 #CJK UNIFIED IDEOGRAPH
  {0xD0C8, 0x747E}, //12764 #CJK UNIFIED IDEOGRAPH
  {0xD0C9, 0x7B4B}, //12765 #CJK UNIFIED IDEOGRAPH
  {0xD0CA, 0x82B9}, //12766 #CJK UNIFIED IDEOGRAPH
  {0xD0CB, 0x83EB}, //12767 #CJK UNIFIED IDEOGRAPH
  {0xD0CC, 0x89B2}, //12768 #CJK UNIFIED IDEOGRAPH
  {0xD0CD, 0x8B39}, //12769 #CJK UNIFIED IDEOGRAPH
  {0xD0CE, 0x8FD1}, //12770 #CJK UNIFIED IDEOGRAPH
  {0xD0CF, 0x9949}, //12771 #CJK UNIFIED IDEOGRAPH
  {0xD0D0, 0xF909}, //12772 #CJK COMPATIBILITY IDEOGRAPH
  {0xD0D1, 0x4ECA}, //12773 #CJK UNIFIED IDEOGRAPH
  {0xD0D2, 0x5997}, //12774 #CJK UNIFIED IDEOGRAPH
  {0xD0D3, 0x64D2}, //12775 #CJK UNIFIED IDEOGRAPH
  {0xD0D4, 0x6611}, //12776 #CJK UNIFIED IDEOGRAPH
  {0xD0D5, 0x6A8E}, //12777 #CJK UNIFIED IDEOGRAPH
  {0xD0D6, 0x7434}, //12778 #CJK UNIFIED IDEOGRAPH
  {0xD0D7, 0x7981}, //12779 #CJK UNIFIED IDEOGRAPH
  {0xD0D8, 0x79BD}, //12780 #CJK UNIFIED IDEOGRAPH
  {0xD0D9, 0x82A9}, //12781 #CJK UNIFIED IDEOGRAPH
  {0xD0DA, 0x887E}, //12782 #CJK UNIFIED IDEOGRAPH
  {0xD0DB, 0x887F}, //12783 #CJK UNIFIED IDEOGRAPH
  {0xD0DC, 0x895F}, //12784 #CJK UNIFIED IDEOGRAPH
  {0xD0DD, 0xF90A}, //12785 #CJK COMPATIBILITY IDEOGRAPH
  {0xD0DE, 0x9326}, //12786 #CJK UNIFIED IDEOGRAPH
  {0xD0DF, 0x4F0B}, //12787 #CJK UNIFIED IDEOGRAPH
  {0xD0E0, 0x53CA}, //12788 #CJK UNIFIED IDEOGRAPH
  {0xD0E1, 0x6025}, //12789 #CJK UNIFIED IDEOGRAPH
  {0xD0E2, 0x6271}, //12790 #CJK UNIFIED IDEOGRAPH
  {0xD0E3, 0x6C72}, //12791 #CJK UNIFIED IDEOGRAPH
  {0xD0E4, 0x7D1A}, //12792 #CJK UNIFIED IDEOGRAPH
  {0xD0E5, 0x7D66}, //12793 #CJK UNIFIED IDEOGRAPH
  {0xD0E6, 0x4E98}, //12794 #CJK UNIFIED IDEOGRAPH
  {0xD0E7, 0x5162}, //12795 #CJK UNIFIED IDEOGRAPH
  {0xD0E8, 0x77DC}, //12796 #CJK UNIFIED IDEOGRAPH
  {0xD0E9, 0x80AF}, //12797 #CJK UNIFIED IDEOGRAPH
  {0xD0EA, 0x4F01}, //12798 #CJK UNIFIED IDEOGRAPH
  {0xD0EB, 0x4F0E}, //12799 #CJK UNIFIED IDEOGRAPH
  {0xD0EC, 0x5176}, //12800 #CJK UNIFIED IDEOGRAPH
  {0xD0ED, 0x5180}, //12801 #CJK UNIFIED IDEOGRAPH
  {0xD0EE, 0x55DC}, //12802 #CJK UNIFIED IDEOGRAPH
  {0xD0EF, 0x5668}, //12803 #CJK UNIFIED IDEOGRAPH
  {0xD0F0, 0x573B}, //12804 #CJK UNIFIED IDEOGRAPH
  {0xD0F1, 0x57FA}, //12805 #CJK UNIFIED IDEOGRAPH
  {0xD0F2, 0x57FC}, //12806 #CJK UNIFIED IDEOGRAPH
  {0xD0F3, 0x5914}, //12807 #CJK UNIFIED IDEOGRAPH
  {0xD0F4, 0x5947}, //12808 #CJK UNIFIED IDEOGRAPH
  {0xD0F5, 0x5993}, //12809 #CJK UNIFIED IDEOGRAPH
  {0xD0F6, 0x5BC4}, //12810 #CJK UNIFIED IDEOGRAPH
  {0xD0F7, 0x5C90}, //12811 #CJK UNIFIED IDEOGRAPH
  {0xD0F8, 0x5D0E}, //12812 #CJK UNIFIED IDEOGRAPH
  {0xD0F9, 0x5DF1}, //12813 #CJK UNIFIED IDEOGRAPH
  {0xD0FA, 0x5E7E}, //12814 #CJK UNIFIED IDEOGRAPH
  {0xD0FB, 0x5FCC}, //12815 #CJK UNIFIED IDEOGRAPH
  {0xD0FC, 0x6280}, //12816 #CJK UNIFIED IDEOGRAPH
  {0xD0FD, 0x65D7}, //12817 #CJK UNIFIED IDEOGRAPH
  {0xD0FE, 0x65E3}, //12818 #CJK UNIFIED IDEOGRAPH
  {0xD1A1, 0x671E}, //12819 #CJK UNIFIED IDEOGRAPH
  {0xD1A2, 0x671F}, //12820 #CJK UNIFIED IDEOGRAPH
  {0xD1A3, 0x675E}, //12821 #CJK UNIFIED IDEOGRAPH
  {0xD1A4, 0x68CB}, //12822 #CJK UNIFIED IDEOGRAPH
  {0xD1A5, 0x68C4}, //12823 #CJK UNIFIED IDEOGRAPH
  {0xD1A6, 0x6A5F}, //12824 #CJK UNIFIED IDEOGRAPH
  {0xD1A7, 0x6B3A}, //12825 #CJK UNIFIED IDEOGRAPH
  {0xD1A8, 0x6C23}, //12826 #CJK UNIFIED IDEOGRAPH
  {0xD1A9, 0x6C7D}, //12827 #CJK UNIFIED IDEOGRAPH
  {0xD1AA, 0x6C82}, //12828 #CJK UNIFIED IDEOGRAPH
  {0xD1AB, 0x6DC7}, //12829 #CJK UNIFIED IDEOGRAPH
  {0xD1AC, 0x7398}, //12830 #CJK UNIFIED IDEOGRAPH
  {0xD1AD, 0x7426}, //12831 #CJK UNIFIED IDEOGRAPH
  {0xD1AE, 0x742A}, //12832 #CJK UNIFIED IDEOGRAPH
  {0xD1AF, 0x7482}, //12833 #CJK UNIFIED IDEOGRAPH
  {0xD1B0, 0x74A3}, //12834 #CJK UNIFIED IDEOGRAPH
  {0xD1B1, 0x7578}, //12835 #CJK UNIFIED IDEOGRAPH
  {0xD1B2, 0x757F}, //12836 #CJK UNIFIED IDEOGRAPH
  {0xD1B3, 0x7881}, //12837 #CJK UNIFIED IDEOGRAPH
  {0xD1B4, 0x78EF}, //12838 #CJK UNIFIED IDEOGRAPH
  {0xD1B5, 0x7941}, //12839 #CJK UNIFIED IDEOGRAPH
  {0xD1B6, 0x7947}, //12840 #CJK UNIFIED IDEOGRAPH
  {0xD1B7, 0x7948}, //12841 #CJK UNIFIED IDEOGRAPH
  {0xD1B8, 0x797A}, //12842 #CJK UNIFIED IDEOGRAPH
  {0xD1B9, 0x7B95}, //12843 #CJK UNIFIED IDEOGRAPH
  {0xD1BA, 0x7D00}, //12844 #CJK UNIFIED IDEOGRAPH
  {0xD1BB, 0x7DBA}, //12845 #CJK UNIFIED IDEOGRAPH
  {0xD1BC, 0x7F88}, //12846 #CJK UNIFIED IDEOGRAPH
  {0xD1BD, 0x8006}, //12847 #CJK UNIFIED IDEOGRAPH
  {0xD1BE, 0x802D}, //12848 #CJK UNIFIED IDEOGRAPH
  {0xD1BF, 0x808C}, //12849 #CJK UNIFIED IDEOGRAPH
  {0xD1C0, 0x8A18}, //12850 #CJK UNIFIED IDEOGRAPH
  {0xD1C1, 0x8B4F}, //12851 #CJK UNIFIED IDEOGRAPH
  {0xD1C2, 0x8C48}, //12852 #CJK UNIFIED IDEOGRAPH
  {0xD1C3, 0x8D77}, //12853 #CJK UNIFIED IDEOGRAPH
  {0xD1C4, 0x9321}, //12854 #CJK UNIFIED IDEOGRAPH
  {0xD1C5, 0x9324}, //12855 #CJK UNIFIED IDEOGRAPH
  {0xD1C6, 0x98E2}, //12856 #CJK UNIFIED IDEOGRAPH
  {0xD1C7, 0x9951}, //12857 #CJK UNIFIED IDEOGRAPH
  {0xD1C8, 0x9A0E}, //12858 #CJK UNIFIED IDEOGRAPH
  {0xD1C9, 0x9A0F}, //12859 #CJK UNIFIED IDEOGRAPH
  {0xD1CA, 0x9A65}, //12860 #CJK UNIFIED IDEOGRAPH
  {0xD1CB, 0x9E92}, //12861 #CJK UNIFIED IDEOGRAPH
  {0xD1CC, 0x7DCA}, //12862 #CJK UNIFIED IDEOGRAPH
  {0xD1CD, 0x4F76}, //12863 #CJK UNIFIED IDEOGRAPH
  {0xD1CE, 0x5409}, //12864 #CJK UNIFIED IDEOGRAPH
  {0xD1CF, 0x62EE}, //12865 #CJK UNIFIED IDEOGRAPH
  {0xD1D0, 0x6854}, //12866 #CJK UNIFIED IDEOGRAPH
  {0xD1D1, 0x91D1}, //12867 #CJK UNIFIED IDEOGRAPH
  {0xD1D2, 0x55AB}, //12868 #CJK UNIFIED IDEOGRAPH
  {0xD1D3, 0x513A}, //12869 #CJK UNIFIED IDEOGRAPH
  {0xD1D4, 0xF90B}, //12870 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1D5, 0xF90C}, //12871 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1D6, 0x5A1C}, //12872 #CJK UNIFIED IDEOGRAPH
  {0xD1D7, 0x61E6}, //12873 #CJK UNIFIED IDEOGRAPH
  {0xD1D8, 0xF90D}, //12874 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1D9, 0x62CF}, //12875 #CJK UNIFIED IDEOGRAPH
  {0xD1DA, 0x62FF}, //12876 #CJK UNIFIED IDEOGRAPH
  {0xD1DB, 0xF90E}, //12877 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1DC, 0xF90F}, //12878 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1DD, 0xF910}, //12879 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1DE, 0xF911}, //12880 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1DF, 0xF912}, //12881 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E0, 0xF913}, //12882 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E1, 0x90A3}, //12883 #CJK UNIFIED IDEOGRAPH
  {0xD1E2, 0xF914}, //12884 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E3, 0xF915}, //12885 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E4, 0xF916}, //12886 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E5, 0xF917}, //12887 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E6, 0xF918}, //12888 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E7, 0x8AFE}, //12889 #CJK UNIFIED IDEOGRAPH
  {0xD1E8, 0xF919}, //12890 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1E9, 0xF91A}, //12891 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1EA, 0xF91B}, //12892 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1EB, 0xF91C}, //12893 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1EC, 0x6696}, //12894 #CJK UNIFIED IDEOGRAPH
  {0xD1ED, 0xF91D}, //12895 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1EE, 0x7156}, //12896 #CJK UNIFIED IDEOGRAPH
  {0xD1EF, 0xF91E}, //12897 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1F0, 0xF91F}, //12898 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1F1, 0x96E3}, //12899 #CJK UNIFIED IDEOGRAPH
  {0xD1F2, 0xF920}, //12900 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1F3, 0x634F}, //12901 #CJK UNIFIED IDEOGRAPH
  {0xD1F4, 0x637A}, //12902 #CJK UNIFIED IDEOGRAPH
  {0xD1F5, 0x5357}, //12903 #CJK UNIFIED IDEOGRAPH
  {0xD1F6, 0xF921}, //12904 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1F7, 0x678F}, //12905 #CJK UNIFIED IDEOGRAPH
  {0xD1F8, 0x6960}, //12906 #CJK UNIFIED IDEOGRAPH
  {0xD1F9, 0x6E73}, //12907 #CJK UNIFIED IDEOGRAPH
  {0xD1FA, 0xF922}, //12908 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1FB, 0x7537}, //12909 #CJK UNIFIED IDEOGRAPH
  {0xD1FC, 0xF923}, //12910 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1FD, 0xF924}, //12911 #CJK COMPATIBILITY IDEOGRAPH
  {0xD1FE, 0xF925}, //12912 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2A1, 0x7D0D}, //12913 #CJK UNIFIED IDEOGRAPH
  {0xD2A2, 0xF926}, //12914 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2A3, 0xF927}, //12915 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2A4, 0x8872}, //12916 #CJK UNIFIED IDEOGRAPH
  {0xD2A5, 0x56CA}, //12917 #CJK UNIFIED IDEOGRAPH
  {0xD2A6, 0x5A18}, //12918 #CJK UNIFIED IDEOGRAPH
  {0xD2A7, 0xF928}, //12919 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2A8, 0xF929}, //12920 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2A9, 0xF92A}, //12921 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2AA, 0xF92B}, //12922 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2AB, 0xF92C}, //12923 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2AC, 0x4E43}, //12924 #CJK UNIFIED IDEOGRAPH
  {0xD2AD, 0xF92D}, //12925 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2AE, 0x5167}, //12926 #CJK UNIFIED IDEOGRAPH
  {0xD2AF, 0x5948}, //12927 #CJK UNIFIED IDEOGRAPH
  {0xD2B0, 0x67F0}, //12928 #CJK UNIFIED IDEOGRAPH
  {0xD2B1, 0x8010}, //12929 #CJK UNIFIED IDEOGRAPH
  {0xD2B2, 0xF92E}, //12930 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2B3, 0x5973}, //12931 #CJK UNIFIED IDEOGRAPH
  {0xD2B4, 0x5E74}, //12932 #CJK UNIFIED IDEOGRAPH
  {0xD2B5, 0x649A}, //12933 #CJK UNIFIED IDEOGRAPH
  {0xD2B6, 0x79CA}, //12934 #CJK UNIFIED IDEOGRAPH
  {0xD2B7, 0x5FF5}, //12935 #CJK UNIFIED IDEOGRAPH
  {0xD2B8, 0x606C}, //12936 #CJK UNIFIED IDEOGRAPH
  {0xD2B9, 0x62C8}, //12937 #CJK UNIFIED IDEOGRAPH
  {0xD2BA, 0x637B}, //12938 #CJK UNIFIED IDEOGRAPH
  {0xD2BB, 0x5BE7}, //12939 #CJK UNIFIED IDEOGRAPH
  {0xD2BC, 0x5BD7}, //12940 #CJK UNIFIED IDEOGRAPH
  {0xD2BD, 0x52AA}, //12941 #CJK UNIFIED IDEOGRAPH
  {0xD2BE, 0xF92F}, //12942 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2BF, 0x5974}, //12943 #CJK UNIFIED IDEOGRAPH
  {0xD2C0, 0x5F29}, //12944 #CJK UNIFIED IDEOGRAPH
  {0xD2C1, 0x6012}, //12945 #CJK UNIFIED IDEOGRAPH
  {0xD2C2, 0xF930}, //12946 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C3, 0xF931}, //12947 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C4, 0xF932}, //12948 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C5, 0x7459}, //12949 #CJK UNIFIED IDEOGRAPH
  {0xD2C6, 0xF933}, //12950 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C7, 0xF934}, //12951 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C8, 0xF935}, //12952 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2C9, 0xF936}, //12953 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2CA, 0xF937}, //12954 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2CB, 0xF938}, //12955 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2CC, 0x99D1}, //12956 #CJK UNIFIED IDEOGRAPH
  {0xD2CD, 0xF939}, //12957 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2CE, 0xF93A}, //12958 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2CF, 0xF93B}, //12959 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D0, 0xF93C}, //12960 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D1, 0xF93D}, //12961 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D2, 0xF93E}, //12962 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D3, 0xF93F}, //12963 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D4, 0xF940}, //12964 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D5, 0xF941}, //12965 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D6, 0xF942}, //12966 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D7, 0xF943}, //12967 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2D8, 0x6FC3}, //12968 #CJK UNIFIED IDEOGRAPH
  {0xD2D9, 0xF944}, //12969 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2DA, 0xF945}, //12970 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2DB, 0x81BF}, //12971 #CJK UNIFIED IDEOGRAPH
  {0xD2DC, 0x8FB2}, //12972 #CJK UNIFIED IDEOGRAPH
  {0xD2DD, 0x60F1}, //12973 #CJK UNIFIED IDEOGRAPH
  {0xD2DE, 0xF946}, //12974 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2DF, 0xF947}, //12975 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E0, 0x8166}, //12976 #CJK UNIFIED IDEOGRAPH
  {0xD2E1, 0xF948}, //12977 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E2, 0xF949}, //12978 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E3, 0x5C3F}, //12979 #CJK UNIFIED IDEOGRAPH
  {0xD2E4, 0xF94A}, //12980 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E5, 0xF94B}, //12981 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E6, 0xF94C}, //12982 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E7, 0xF94D}, //12983 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E8, 0xF94E}, //12984 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2E9, 0xF94F}, //12985 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2EA, 0xF950}, //12986 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2EB, 0xF951}, //12987 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2EC, 0x5AE9}, //12988 #CJK UNIFIED IDEOGRAPH
  {0xD2ED, 0x8A25}, //12989 #CJK UNIFIED IDEOGRAPH
  {0xD2EE, 0x677B}, //12990 #CJK UNIFIED IDEOGRAPH
  {0xD2EF, 0x7D10}, //12991 #CJK UNIFIED IDEOGRAPH
  {0xD2F0, 0xF952}, //12992 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F1, 0xF953}, //12993 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F2, 0xF954}, //12994 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F3, 0xF955}, //12995 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F4, 0xF956}, //12996 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F5, 0xF957}, //12997 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F6, 0x80FD}, //12998 #CJK UNIFIED IDEOGRAPH
  {0xD2F7, 0xF958}, //12999 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F8, 0xF959}, //13000 #CJK COMPATIBILITY IDEOGRAPH
  {0xD2F9, 0x5C3C}, //13001 #CJK UNIFIED IDEOGRAPH
  {0xD2FA, 0x6CE5}, //13002 #CJK UNIFIED IDEOGRAPH
  {0xD2FB, 0x533F}, //13003 #CJK UNIFIED IDEOGRAPH
  {0xD2FC, 0x6EBA}, //13004 #CJK UNIFIED IDEOGRAPH
  {0xD2FD, 0x591A}, //13005 #CJK UNIFIED IDEOGRAPH
  {0xD2FE, 0x8336}, //13006 #CJK UNIFIED IDEOGRAPH
  {0xD3A1, 0x4E39}, //13007 #CJK UNIFIED IDEOGRAPH
  {0xD3A2, 0x4EB6}, //13008 #CJK UNIFIED IDEOGRAPH
  {0xD3A3, 0x4F46}, //13009 #CJK UNIFIED IDEOGRAPH
  {0xD3A4, 0x55AE}, //13010 #CJK UNIFIED IDEOGRAPH
  {0xD3A5, 0x5718}, //13011 #CJK UNIFIED IDEOGRAPH
  {0xD3A6, 0x58C7}, //13012 #CJK UNIFIED IDEOGRAPH
  {0xD3A7, 0x5F56}, //13013 #CJK UNIFIED IDEOGRAPH
  {0xD3A8, 0x65B7}, //13014 #CJK UNIFIED IDEOGRAPH
  {0xD3A9, 0x65E6}, //13015 #CJK UNIFIED IDEOGRAPH
  {0xD3AA, 0x6A80}, //13016 #CJK UNIFIED IDEOGRAPH
  {0xD3AB, 0x6BB5}, //13017 #CJK UNIFIED IDEOGRAPH
  {0xD3AC, 0x6E4D}, //13018 #CJK UNIFIED IDEOGRAPH
  {0xD3AD, 0x77ED}, //13019 #CJK UNIFIED IDEOGRAPH
  {0xD3AE, 0x7AEF}, //13020 #CJK UNIFIED IDEOGRAPH
  {0xD3AF, 0x7C1E}, //13021 #CJK UNIFIED IDEOGRAPH
  {0xD3B0, 0x7DDE}, //13022 #CJK UNIFIED IDEOGRAPH
  {0xD3B1, 0x86CB}, //13023 #CJK UNIFIED IDEOGRAPH
  {0xD3B2, 0x8892}, //13024 #CJK UNIFIED IDEOGRAPH
  {0xD3B3, 0x9132}, //13025 #CJK UNIFIED IDEOGRAPH
  {0xD3B4, 0x935B}, //13026 #CJK UNIFIED IDEOGRAPH
  {0xD3B5, 0x64BB}, //13027 #CJK UNIFIED IDEOGRAPH
  {0xD3B6, 0x6FBE}, //13028 #CJK UNIFIED IDEOGRAPH
  {0xD3B7, 0x737A}, //13029 #CJK UNIFIED IDEOGRAPH
  {0xD3B8, 0x75B8}, //13030 #CJK UNIFIED IDEOGRAPH
  {0xD3B9, 0x9054}, //13031 #CJK UNIFIED IDEOGRAPH
  {0xD3BA, 0x5556}, //13032 #CJK UNIFIED IDEOGRAPH
  {0xD3BB, 0x574D}, //13033 #CJK UNIFIED IDEOGRAPH
  {0xD3BC, 0x61BA}, //13034 #CJK UNIFIED IDEOGRAPH
  {0xD3BD, 0x64D4}, //13035 #CJK UNIFIED IDEOGRAPH
  {0xD3BE, 0x66C7}, //13036 #CJK UNIFIED IDEOGRAPH
  {0xD3BF, 0x6DE1}, //13037 #CJK UNIFIED IDEOGRAPH
  {0xD3C0, 0x6E5B}, //13038 #CJK UNIFIED IDEOGRAPH
  {0xD3C1, 0x6F6D}, //13039 #CJK UNIFIED IDEOGRAPH
  {0xD3C2, 0x6FB9}, //13040 #CJK UNIFIED IDEOGRAPH
  {0xD3C3, 0x75F0}, //13041 #CJK UNIFIED IDEOGRAPH
  {0xD3C4, 0x8043}, //13042 #CJK UNIFIED IDEOGRAPH
  {0xD3C5, 0x81BD}, //13043 #CJK UNIFIED IDEOGRAPH
  {0xD3C6, 0x8541}, //13044 #CJK UNIFIED IDEOGRAPH
  {0xD3C7, 0x8983}, //13045 #CJK UNIFIED IDEOGRAPH
  {0xD3C8, 0x8AC7}, //13046 #CJK UNIFIED IDEOGRAPH
  {0xD3C9, 0x8B5A}, //13047 #CJK UNIFIED IDEOGRAPH
  {0xD3CA, 0x931F}, //13048 #CJK UNIFIED IDEOGRAPH
  {0xD3CB, 0x6C93}, //13049 #CJK UNIFIED IDEOGRAPH
  {0xD3CC, 0x7553}, //13050 #CJK UNIFIED IDEOGRAPH
  {0xD3CD, 0x7B54}, //13051 #CJK UNIFIED IDEOGRAPH
  {0xD3CE, 0x8E0F}, //13052 #CJK UNIFIED IDEOGRAPH
  {0xD3CF, 0x905D}, //13053 #CJK UNIFIED IDEOGRAPH
  {0xD3D0, 0x5510}, //13054 #CJK UNIFIED IDEOGRAPH
  {0xD3D1, 0x5802}, //13055 #CJK UNIFIED IDEOGRAPH
  {0xD3D2, 0x5858}, //13056 #CJK UNIFIED IDEOGRAPH
  {0xD3D3, 0x5E62}, //13057 #CJK UNIFIED IDEOGRAPH
  {0xD3D4, 0x6207}, //13058 #CJK UNIFIED IDEOGRAPH
  {0xD3D5, 0x649E}, //13059 #CJK UNIFIED IDEOGRAPH
  {0xD3D6, 0x68E0}, //13060 #CJK UNIFIED IDEOGRAPH
  {0xD3D7, 0x7576}, //13061 #CJK UNIFIED IDEOGRAPH
  {0xD3D8, 0x7CD6}, //13062 #CJK UNIFIED IDEOGRAPH
  {0xD3D9, 0x87B3}, //13063 #CJK UNIFIED IDEOGRAPH
  {0xD3DA, 0x9EE8}, //13064 #CJK UNIFIED IDEOGRAPH
  {0xD3DB, 0x4EE3}, //13065 #CJK UNIFIED IDEOGRAPH
  {0xD3DC, 0x5788}, //13066 #CJK UNIFIED IDEOGRAPH
  {0xD3DD, 0x576E}, //13067 #CJK UNIFIED IDEOGRAPH
  {0xD3DE, 0x5927}, //13068 #CJK UNIFIED IDEOGRAPH
  {0xD3DF, 0x5C0D}, //13069 #CJK UNIFIED IDEOGRAPH
  {0xD3E0, 0x5CB1}, //13070 #CJK UNIFIED IDEOGRAPH
  {0xD3E1, 0x5E36}, //13071 #CJK UNIFIED IDEOGRAPH
  {0xD3E2, 0x5F85}, //13072 #CJK UNIFIED IDEOGRAPH
  {0xD3E3, 0x6234}, //13073 #CJK UNIFIED IDEOGRAPH
  {0xD3E4, 0x64E1}, //13074 #CJK UNIFIED IDEOGRAPH
  {0xD3E5, 0x73B3}, //13075 #CJK UNIFIED IDEOGRAPH
  {0xD3E6, 0x81FA}, //13076 #CJK UNIFIED IDEOGRAPH
  {0xD3E7, 0x888B}, //13077 #CJK UNIFIED IDEOGRAPH
  {0xD3E8, 0x8CB8}, //13078 #CJK UNIFIED IDEOGRAPH
  {0xD3E9, 0x968A}, //13079 #CJK UNIFIED IDEOGRAPH
  {0xD3EA, 0x9EDB}, //13080 #CJK UNIFIED IDEOGRAPH
  {0xD3EB, 0x5B85}, //13081 #CJK UNIFIED IDEOGRAPH
  {0xD3EC, 0x5FB7}, //13082 #CJK UNIFIED IDEOGRAPH
  {0xD3ED, 0x60B3}, //13083 #CJK UNIFIED IDEOGRAPH
  {0xD3EE, 0x5012}, //13084 #CJK UNIFIED IDEOGRAPH
  {0xD3EF, 0x5200}, //13085 #CJK UNIFIED IDEOGRAPH
  {0xD3F0, 0x5230}, //13086 #CJK UNIFIED IDEOGRAPH
  {0xD3F1, 0x5716}, //13087 #CJK UNIFIED IDEOGRAPH
  {0xD3F2, 0x5835}, //13088 #CJK UNIFIED IDEOGRAPH
  {0xD3F3, 0x5857}, //13089 #CJK UNIFIED IDEOGRAPH
  {0xD3F4, 0x5C0E}, //13090 #CJK UNIFIED IDEOGRAPH
  {0xD3F5, 0x5C60}, //13091 #CJK UNIFIED IDEOGRAPH
  {0xD3F6, 0x5CF6}, //13092 #CJK UNIFIED IDEOGRAPH
  {0xD3F7, 0x5D8B}, //13093 #CJK UNIFIED IDEOGRAPH
  {0xD3F8, 0x5EA6}, //13094 #CJK UNIFIED IDEOGRAPH
  {0xD3F9, 0x5F92}, //13095 #CJK UNIFIED IDEOGRAPH
  {0xD3FA, 0x60BC}, //13096 #CJK UNIFIED IDEOGRAPH
  {0xD3FB, 0x6311}, //13097 #CJK UNIFIED IDEOGRAPH
  {0xD3FC, 0x6389}, //13098 #CJK UNIFIED IDEOGRAPH
  {0xD3FD, 0x6417}, //13099 #CJK UNIFIED IDEOGRAPH
  {0xD3FE, 0x6843}, //13100 #CJK UNIFIED IDEOGRAPH
  {0xD4A1, 0x68F9}, //13101 #CJK UNIFIED IDEOGRAPH
  {0xD4A2, 0x6AC2}, //13102 #CJK UNIFIED IDEOGRAPH
  {0xD4A3, 0x6DD8}, //13103 #CJK UNIFIED IDEOGRAPH
  {0xD4A4, 0x6E21}, //13104 #CJK UNIFIED IDEOGRAPH
  {0xD4A5, 0x6ED4}, //13105 #CJK UNIFIED IDEOGRAPH
  {0xD4A6, 0x6FE4}, //13106 #CJK UNIFIED IDEOGRAPH
  {0xD4A7, 0x71FE}, //13107 #CJK UNIFIED IDEOGRAPH
  {0xD4A8, 0x76DC}, //13108 #CJK UNIFIED IDEOGRAPH
  {0xD4A9, 0x7779}, //13109 #CJK UNIFIED IDEOGRAPH
  {0xD4AA, 0x79B1}, //13110 #CJK UNIFIED IDEOGRAPH
  {0xD4AB, 0x7A3B}, //13111 #CJK UNIFIED IDEOGRAPH
  {0xD4AC, 0x8404}, //13112 #CJK UNIFIED IDEOGRAPH
  {0xD4AD, 0x89A9}, //13113 #CJK UNIFIED IDEOGRAPH
  {0xD4AE, 0x8CED}, //13114 #CJK UNIFIED IDEOGRAPH
  {0xD4AF, 0x8DF3}, //13115 #CJK UNIFIED IDEOGRAPH
  {0xD4B0, 0x8E48}, //13116 #CJK UNIFIED IDEOGRAPH
  {0xD4B1, 0x9003}, //13117 #CJK UNIFIED IDEOGRAPH
  {0xD4B2, 0x9014}, //13118 #CJK UNIFIED IDEOGRAPH
  {0xD4B3, 0x9053}, //13119 #CJK UNIFIED IDEOGRAPH
  {0xD4B4, 0x90FD}, //13120 #CJK UNIFIED IDEOGRAPH
  {0xD4B5, 0x934D}, //13121 #CJK UNIFIED IDEOGRAPH
  {0xD4B6, 0x9676}, //13122 #CJK UNIFIED IDEOGRAPH
  {0xD4B7, 0x97DC}, //13123 #CJK UNIFIED IDEOGRAPH
  {0xD4B8, 0x6BD2}, //13124 #CJK UNIFIED IDEOGRAPH
  {0xD4B9, 0x7006}, //13125 #CJK UNIFIED IDEOGRAPH
  {0xD4BA, 0x7258}, //13126 #CJK UNIFIED IDEOGRAPH
  {0xD4BB, 0x72A2}, //13127 #CJK UNIFIED IDEOGRAPH
  {0xD4BC, 0x7368}, //13128 #CJK UNIFIED IDEOGRAPH
  {0xD4BD, 0x7763}, //13129 #CJK UNIFIED IDEOGRAPH
  {0xD4BE, 0x79BF}, //13130 #CJK UNIFIED IDEOGRAPH
  {0xD4BF, 0x7BE4}, //13131 #CJK UNIFIED IDEOGRAPH
  {0xD4C0, 0x7E9B}, //13132 #CJK UNIFIED IDEOGRAPH
  {0xD4C1, 0x8B80}, //13133 #CJK UNIFIED IDEOGRAPH
  {0xD4C2, 0x58A9}, //13134 #CJK UNIFIED IDEOGRAPH
  {0xD4C3, 0x60C7}, //13135 #CJK UNIFIED IDEOGRAPH
  {0xD4C4, 0x6566}, //13136 #CJK UNIFIED IDEOGRAPH
  {0xD4C5, 0x65FD}, //13137 #CJK UNIFIED IDEOGRAPH
  {0xD4C6, 0x66BE}, //13138 #CJK UNIFIED IDEOGRAPH
  {0xD4C7, 0x6C8C}, //13139 #CJK UNIFIED IDEOGRAPH
  {0xD4C8, 0x711E}, //13140 #CJK UNIFIED IDEOGRAPH
  {0xD4C9, 0x71C9}, //13141 #CJK UNIFIED IDEOGRAPH
  {0xD4CA, 0x8C5A}, //13142 #CJK UNIFIED IDEOGRAPH
  {0xD4CB, 0x9813}, //13143 #CJK UNIFIED IDEOGRAPH
  {0xD4CC, 0x4E6D}, //13144 #CJK UNIFIED IDEOGRAPH
  {0xD4CD, 0x7A81}, //13145 #CJK UNIFIED IDEOGRAPH
  {0xD4CE, 0x4EDD}, //13146 #CJK UNIFIED IDEOGRAPH
  {0xD4CF, 0x51AC}, //13147 #CJK UNIFIED IDEOGRAPH
  {0xD4D0, 0x51CD}, //13148 #CJK UNIFIED IDEOGRAPH
  {0xD4D1, 0x52D5}, //13149 #CJK UNIFIED IDEOGRAPH
  {0xD4D2, 0x540C}, //13150 #CJK UNIFIED IDEOGRAPH
  {0xD4D3, 0x61A7}, //13151 #CJK UNIFIED IDEOGRAPH
  {0xD4D4, 0x6771}, //13152 #CJK UNIFIED IDEOGRAPH
  {0xD4D5, 0x6850}, //13153 #CJK UNIFIED IDEOGRAPH
  {0xD4D6, 0x68DF}, //13154 #CJK UNIFIED IDEOGRAPH
  {0xD4D7, 0x6D1E}, //13155 #CJK UNIFIED IDEOGRAPH
  {0xD4D8, 0x6F7C}, //13156 #CJK UNIFIED IDEOGRAPH
  {0xD4D9, 0x75BC}, //13157 #CJK UNIFIED IDEOGRAPH
  {0xD4DA, 0x77B3}, //13158 #CJK UNIFIED IDEOGRAPH
  {0xD4DB, 0x7AE5}, //13159 #CJK UNIFIED IDEOGRAPH
  {0xD4DC, 0x80F4}, //13160 #CJK UNIFIED IDEOGRAPH
  {0xD4DD, 0x8463}, //13161 #CJK UNIFIED IDEOGRAPH
  {0xD4DE, 0x9285}, //13162 #CJK UNIFIED IDEOGRAPH
  {0xD4DF, 0x515C}, //13163 #CJK UNIFIED IDEOGRAPH
  {0xD4E0, 0x6597}, //13164 #CJK UNIFIED IDEOGRAPH
  {0xD4E1, 0x675C}, //13165 #CJK UNIFIED IDEOGRAPH
  {0xD4E2, 0x6793}, //13166 #CJK UNIFIED IDEOGRAPH
  {0xD4E3, 0x75D8}, //13167 #CJK UNIFIED IDEOGRAPH
  {0xD4E4, 0x7AC7}, //13168 #CJK UNIFIED IDEOGRAPH
  {0xD4E5, 0x8373}, //13169 #CJK UNIFIED IDEOGRAPH
  {0xD4E6, 0xF95A}, //13170 #CJK COMPATIBILITY IDEOGRAPH
  {0xD4E7, 0x8C46}, //13171 #CJK UNIFIED IDEOGRAPH
  {0xD4E8, 0x9017}, //13172 #CJK UNIFIED IDEOGRAPH
  {0xD4E9, 0x982D}, //13173 #CJK UNIFIED IDEOGRAPH
  {0xD4EA, 0x5C6F}, //13174 #CJK UNIFIED IDEOGRAPH
  {0xD4EB, 0x81C0}, //13175 #CJK UNIFIED IDEOGRAPH
  {0xD4EC, 0x829A}, //13176 #CJK UNIFIED IDEOGRAPH
  {0xD4ED, 0x9041}, //13177 #CJK UNIFIED IDEOGRAPH
  {0xD4EE, 0x906F}, //13178 #CJK UNIFIED IDEOGRAPH
  {0xD4EF, 0x920D}, //13179 #CJK UNIFIED IDEOGRAPH
  {0xD4F0, 0x5F97}, //13180 #CJK UNIFIED IDEOGRAPH
  {0xD4F1, 0x5D9D}, //13181 #CJK UNIFIED IDEOGRAPH
  {0xD4F2, 0x6A59}, //13182 #CJK UNIFIED IDEOGRAPH
  {0xD4F3, 0x71C8}, //13183 #CJK UNIFIED IDEOGRAPH
  {0xD4F4, 0x767B}, //13184 #CJK UNIFIED IDEOGRAPH
  {0xD4F5, 0x7B49}, //13185 #CJK UNIFIED IDEOGRAPH
  {0xD4F6, 0x85E4}, //13186 #CJK UNIFIED IDEOGRAPH
  {0xD4F7, 0x8B04}, //13187 #CJK UNIFIED IDEOGRAPH
  {0xD4F8, 0x9127}, //13188 #CJK UNIFIED IDEOGRAPH
  {0xD4F9, 0x9A30}, //13189 #CJK UNIFIED IDEOGRAPH
  {0xD4FA, 0x5587}, //13190 #CJK UNIFIED IDEOGRAPH
  {0xD4FB, 0x61F6}, //13191 #CJK UNIFIED IDEOGRAPH
  {0xD4FC, 0xF95B}, //13192 #CJK COMPATIBILITY IDEOGRAPH
  {0xD4FD, 0x7669}, //13193 #CJK UNIFIED IDEOGRAPH
  {0xD4FE, 0x7F85}, //13194 #CJK UNIFIED IDEOGRAPH
  {0xD5A1, 0x863F}, //13195 #CJK UNIFIED IDEOGRAPH
  {0xD5A2, 0x87BA}, //13196 #CJK UNIFIED IDEOGRAPH
  {0xD5A3, 0x88F8}, //13197 #CJK UNIFIED IDEOGRAPH
  {0xD5A4, 0x908F}, //13198 #CJK UNIFIED IDEOGRAPH
  {0xD5A5, 0xF95C}, //13199 #CJK COMPATIBILITY IDEOGRAPH
  {0xD5A6, 0x6D1B}, //13200 #CJK UNIFIED IDEOGRAPH
  {0xD5A7, 0x70D9}, //13201 #CJK UNIFIED IDEOGRAPH
  {0xD5A8, 0x73DE}, //13202 #CJK UNIFIED IDEOGRAPH
  {0xD5A9, 0x7D61}, //13203 #CJK UNIFIED IDEOGRAPH
  {0xD5AA, 0x843D}, //13204 #CJK UNIFIED IDEOGRAPH
  {0xD5AB, 0xF95D}, //13205 #CJK COMPATIBILITY IDEOGRAPH
  {0xD5AC, 0x916A}, //13206 #CJK UNIFIED IDEOGRAPH
  {0xD5AD, 0x99F1}, //13207 #CJK UNIFIED IDEOGRAPH
  {0xD5AE, 0xF95E}, //13208 #CJK COMPATIBILITY IDEOGRAPH
  {0xD5AF, 0x4E82}, //13209 #CJK UNIFIED IDEOGRAPH
  {0xD5B0, 0x5375}, //13210 #CJK UNIFIED IDEOGRAPH
  {0xD5B1, 0x6B04}, //13211 #CJK UNIFIED IDEOGRAPH
  {0xD5B2, 0x6B12}, //13212 #CJK UNIFIED IDEOGRAPH
  {0xD5B3, 0x703E}, //13213 #CJK UNIFIED IDEOGRAPH
  {0xD5B4, 0x721B}, //13214 #CJK UNIFIED IDEOGRAPH
  {0xD5B5, 0x862D}, //13215 #CJK UNIFIED IDEOGRAPH
  {0xD5B6, 0x9E1E}, //13216 #CJK UNIFIED IDEOGRAPH
  {0xD5B7, 0x524C}, //13217 #CJK UNIFIED IDEOGRAPH
  {0xD5B8, 0x8FA3}, //13218 #CJK UNIFIED IDEOGRAPH
  {0xD5B9, 0x5D50}, //13219 #CJK UNIFIED IDEOGRAPH
  {0xD5BA, 0x64E5}, //13220 #CJK UNIFIED IDEOGRAPH
  {0xD5BB, 0x652C}, //13221 #CJK UNIFIED IDEOGRAPH
  {0xD5BC, 0x6B16}, //13222 #CJK UNIFIED IDEOGRAPH
  {0xD5BD, 0x6FEB}, //13223 #CJK UNIFIED IDEOGRAPH
  {0xD5BE, 0x7C43}, //13224 #CJK UNIFIED IDEOGRAPH
  {0xD5BF, 0x7E9C}, //13225 #CJK UNIFIED IDEOGRAPH
  {0xD5C0, 0x85CD}, //13226 #CJK UNIFIED IDEOGRAPH
  {0xD5C1, 0x8964}, //13227 #CJK UNIFIED IDEOGRAPH
  {0xD5C2, 0x89BD}, //13228 #CJK UNIFIED IDEOGRAPH
  {0xD5C3, 0x62C9}, //13229 #CJK UNIFIED IDEOGRAPH
  {0xD5C4, 0x81D8}, //13230 #CJK UNIFIED IDEOGRAPH
  {0xD5C5, 0x881F}, //13231 #CJK UNIFIED IDEOGRAPH
  {0xD5C6, 0x5ECA}, //13232 #CJK UNIFIED IDEOGRAPH
  {0xD5C7, 0x6717}, //13233 #CJK UNIFIED IDEOGRAPH
  {0xD5C8, 0x6D6A}, //13234 #CJK UNIFIED IDEOGRAPH
  {0xD5C9, 0x72FC}, //13235 #CJK UNIFIED IDEOGRAPH
  {0xD5CA, 0x7405}, //13236 #CJK UNIFIED IDEOGRAPH
  {0xD5CB, 0x746F}, //13237 #CJK UNIFIED IDEOGRAPH
  {0xD5CC, 0x8782}, //13238 #CJK UNIFIED IDEOGRAPH
  {0xD5CD, 0x90DE}, //13239 #CJK UNIFIED IDEOGRAPH
  {0xD5CE, 0x4F86}, //13240 #CJK UNIFIED IDEOGRAPH
  {0xD5CF, 0x5D0D}, //13241 #CJK UNIFIED IDEOGRAPH
  {0xD5D0, 0x5FA0}, //13242 #CJK UNIFIED IDEOGRAPH
  {0xD5D1, 0x840A}, //13243 #CJK UNIFIED IDEOGRAPH
  {0xD5D2, 0x51B7}, //13244 #CJK UNIFIED IDEOGRAPH
  {0xD5D3, 0x63A0}, //13245 #CJK UNIFIED IDEOGRAPH
  {0xD5D4, 0x7565}, //13246 #CJK UNIFIED IDEOGRAPH
  {0xD5D5, 0x4EAE}, //13247 #CJK UNIFIED IDEOGRAPH
  {0xD5D6, 0x5006}, //13248 #CJK UNIFIED IDEOGRAPH
  {0xD5D7, 0x5169}, //13249 #CJK UNIFIED IDEOGRAPH
  {0xD5D8, 0x51C9}, //13250 #CJK UNIFIED IDEOGRAPH
  {0xD5D9, 0x6881}, //13251 #CJK UNIFIED IDEOGRAPH
  {0xD5DA, 0x6A11}, //13252 #CJK UNIFIED IDEOGRAPH
  {0xD5DB, 0x7CAE}, //13253 #CJK UNIFIED IDEOGRAPH
  {0xD5DC, 0x7CB1}, //13254 #CJK UNIFIED IDEOGRAPH
  {0xD5DD, 0x7CE7}, //13255 #CJK UNIFIED IDEOGRAPH
  {0xD5DE, 0x826F}, //13256 #CJK UNIFIED IDEOGRAPH
  {0xD5DF, 0x8AD2}, //13257 #CJK UNIFIED IDEOGRAPH
  {0xD5E0, 0x8F1B}, //13258 #CJK UNIFIED IDEOGRAPH
  {0xD5E1, 0x91CF}, //13259 #CJK UNIFIED IDEOGRAPH
  {0xD5E2, 0x4FB6}, //13260 #CJK UNIFIED IDEOGRAPH
  {0xD5E3, 0x5137}, //13261 #CJK UNIFIED IDEOGRAPH
  {0xD5E4, 0x52F5}, //13262 #CJK UNIFIED IDEOGRAPH
  {0xD5E5, 0x5442}, //13263 #CJK UNIFIED IDEOGRAPH
  {0xD5E6, 0x5EEC}, //13264 #CJK UNIFIED IDEOGRAPH
  {0xD5E7, 0x616E}, //13265 #CJK UNIFIED IDEOGRAPH
  {0xD5E8, 0x623E}, //13266 #CJK UNIFIED IDEOGRAPH
  {0xD5E9, 0x65C5}, //13267 #CJK UNIFIED IDEOGRAPH
  {0xD5EA, 0x6ADA}, //13268 #CJK UNIFIED IDEOGRAPH
  {0xD5EB, 0x6FFE}, //13269 #CJK UNIFIED IDEOGRAPH
  {0xD5EC, 0x792A}, //13270 #CJK UNIFIED IDEOGRAPH
  {0xD5ED, 0x85DC}, //13271 #CJK UNIFIED IDEOGRAPH
  {0xD5EE, 0x8823}, //13272 #CJK UNIFIED IDEOGRAPH
  {0xD5EF, 0x95AD}, //13273 #CJK UNIFIED IDEOGRAPH
  {0xD5F0, 0x9A62}, //13274 #CJK UNIFIED IDEOGRAPH
  {0xD5F1, 0x9A6A}, //13275 #CJK UNIFIED IDEOGRAPH
  {0xD5F2, 0x9E97}, //13276 #CJK UNIFIED IDEOGRAPH
  {0xD5F3, 0x9ECE}, //13277 #CJK UNIFIED IDEOGRAPH
  {0xD5F4, 0x529B}, //13278 #CJK UNIFIED IDEOGRAPH
  {0xD5F5, 0x66C6}, //13279 #CJK UNIFIED IDEOGRAPH
  {0xD5F6, 0x6B77}, //13280 #CJK UNIFIED IDEOGRAPH
  {0xD5F7, 0x701D}, //13281 #CJK UNIFIED IDEOGRAPH
  {0xD5F8, 0x792B}, //13282 #CJK UNIFIED IDEOGRAPH
  {0xD5F9, 0x8F62}, //13283 #CJK UNIFIED IDEOGRAPH
  {0xD5FA, 0x9742}, //13284 #CJK UNIFIED IDEOGRAPH
  {0xD5FB, 0x6190}, //13285 #CJK UNIFIED IDEOGRAPH
  {0xD5FC, 0x6200}, //13286 #CJK UNIFIED IDEOGRAPH
  {0xD5FD, 0x6523}, //13287 #CJK UNIFIED IDEOGRAPH
  {0xD5FE, 0x6F23}, //13288 #CJK UNIFIED IDEOGRAPH
  {0xD6A1, 0x7149}, //13289 #CJK UNIFIED IDEOGRAPH
  {0xD6A2, 0x7489}, //13290 #CJK UNIFIED IDEOGRAPH
  {0xD6A3, 0x7DF4}, //13291 #CJK UNIFIED IDEOGRAPH
  {0xD6A4, 0x806F}, //13292 #CJK UNIFIED IDEOGRAPH
  {0xD6A5, 0x84EE}, //13293 #CJK UNIFIED IDEOGRAPH
  {0xD6A6, 0x8F26}, //13294 #CJK UNIFIED IDEOGRAPH
  {0xD6A7, 0x9023}, //13295 #CJK UNIFIED IDEOGRAPH
  {0xD6A8, 0x934A}, //13296 #CJK UNIFIED IDEOGRAPH
  {0xD6A9, 0x51BD}, //13297 #CJK UNIFIED IDEOGRAPH
  {0xD6AA, 0x5217}, //13298 #CJK UNIFIED IDEOGRAPH
  {0xD6AB, 0x52A3}, //13299 #CJK UNIFIED IDEOGRAPH
  {0xD6AC, 0x6D0C}, //13300 #CJK UNIFIED IDEOGRAPH
  {0xD6AD, 0x70C8}, //13301 #CJK UNIFIED IDEOGRAPH
  {0xD6AE, 0x88C2}, //13302 #CJK UNIFIED IDEOGRAPH
  {0xD6AF, 0x5EC9}, //13303 #CJK UNIFIED IDEOGRAPH
  {0xD6B0, 0x6582}, //13304 #CJK UNIFIED IDEOGRAPH
  {0xD6B1, 0x6BAE}, //13305 #CJK UNIFIED IDEOGRAPH
  {0xD6B2, 0x6FC2}, //13306 #CJK UNIFIED IDEOGRAPH
  {0xD6B3, 0x7C3E}, //13307 #CJK UNIFIED IDEOGRAPH
  {0xD6B4, 0x7375}, //13308 #CJK UNIFIED IDEOGRAPH
  {0xD6B5, 0x4EE4}, //13309 #CJK UNIFIED IDEOGRAPH
  {0xD6B6, 0x4F36}, //13310 #CJK UNIFIED IDEOGRAPH
  {0xD6B7, 0x56F9}, //13311 #CJK UNIFIED IDEOGRAPH
  {0xD6B8, 0xF95F}, //13312 #CJK COMPATIBILITY IDEOGRAPH
  {0xD6B9, 0x5CBA}, //13313 #CJK UNIFIED IDEOGRAPH
  {0xD6BA, 0x5DBA}, //13314 #CJK UNIFIED IDEOGRAPH
  {0xD6BB, 0x601C}, //13315 #CJK UNIFIED IDEOGRAPH
  {0xD6BC, 0x73B2}, //13316 #CJK UNIFIED IDEOGRAPH
  {0xD6BD, 0x7B2D}, //13317 #CJK UNIFIED IDEOGRAPH
  {0xD6BE, 0x7F9A}, //13318 #CJK UNIFIED IDEOGRAPH
  {0xD6BF, 0x7FCE}, //13319 #CJK UNIFIED IDEOGRAPH
  {0xD6C0, 0x8046}, //13320 #CJK UNIFIED IDEOGRAPH
  {0xD6C1, 0x901E}, //13321 #CJK UNIFIED IDEOGRAPH
  {0xD6C2, 0x9234}, //13322 #CJK UNIFIED IDEOGRAPH
  {0xD6C3, 0x96F6}, //13323 #CJK UNIFIED IDEOGRAPH
  {0xD6C4, 0x9748}, //13324 #CJK UNIFIED IDEOGRAPH
  {0xD6C5, 0x9818}, //13325 #CJK UNIFIED IDEOGRAPH
  {0xD6C6, 0x9F61}, //13326 #CJK UNIFIED IDEOGRAPH
  {0xD6C7, 0x4F8B}, //13327 #CJK UNIFIED IDEOGRAPH
  {0xD6C8, 0x6FA7}, //13328 #CJK UNIFIED IDEOGRAPH
  {0xD6C9, 0x79AE}, //13329 #CJK UNIFIED IDEOGRAPH
  {0xD6CA, 0x91B4}, //13330 #CJK UNIFIED IDEOGRAPH
  {0xD6CB, 0x96B7}, //13331 #CJK UNIFIED IDEOGRAPH
  {0xD6CC, 0x52DE}, //13332 #CJK UNIFIED IDEOGRAPH
  {0xD6CD, 0xF960}, //13333 #CJK COMPATIBILITY IDEOGRAPH
  {0xD6CE, 0x6488}, //13334 #CJK UNIFIED IDEOGRAPH
  {0xD6CF, 0x64C4}, //13335 #CJK UNIFIED IDEOGRAPH
  {0xD6D0, 0x6AD3}, //13336 #CJK UNIFIED IDEOGRAPH
  {0xD6D1, 0x6F5E}, //13337 #CJK UNIFIED IDEOGRAPH
  {0xD6D2, 0x7018}, //13338 #CJK UNIFIED IDEOGRAPH
  {0xD6D3, 0x7210}, //13339 #CJK UNIFIED IDEOGRAPH
  {0xD6D4, 0x76E7}, //13340 #CJK UNIFIED IDEOGRAPH
  {0xD6D5, 0x8001}, //13341 #CJK UNIFIED IDEOGRAPH
  {0xD6D6, 0x8606}, //13342 #CJK UNIFIED IDEOGRAPH
  {0xD6D7, 0x865C}, //13343 #CJK UNIFIED IDEOGRAPH
  {0xD6D8, 0x8DEF}, //13344 #CJK UNIFIED IDEOGRAPH
  {0xD6D9, 0x8F05}, //13345 #CJK UNIFIED IDEOGRAPH
  {0xD6DA, 0x9732}, //13346 #CJK UNIFIED IDEOGRAPH
  {0xD6DB, 0x9B6F}, //13347 #CJK UNIFIED IDEOGRAPH
  {0xD6DC, 0x9DFA}, //13348 #CJK UNIFIED IDEOGRAPH
  {0xD6DD, 0x9E75}, //13349 #CJK UNIFIED IDEOGRAPH
  {0xD6DE, 0x788C}, //13350 #CJK UNIFIED IDEOGRAPH
  {0xD6DF, 0x797F}, //13351 #CJK UNIFIED IDEOGRAPH
  {0xD6E0, 0x7DA0}, //13352 #CJK UNIFIED IDEOGRAPH
  {0xD6E1, 0x83C9}, //13353 #CJK UNIFIED IDEOGRAPH
  {0xD6E2, 0x9304}, //13354 #CJK UNIFIED IDEOGRAPH
  {0xD6E3, 0x9E7F}, //13355 #CJK UNIFIED IDEOGRAPH
  {0xD6E4, 0x9E93}, //13356 #CJK UNIFIED IDEOGRAPH
  {0xD6E5, 0x8AD6}, //13357 #CJK UNIFIED IDEOGRAPH
  {0xD6E6, 0x58DF}, //13358 #CJK UNIFIED IDEOGRAPH
  {0xD6E7, 0x5F04}, //13359 #CJK UNIFIED IDEOGRAPH
  {0xD6E8, 0x6727}, //13360 #CJK UNIFIED IDEOGRAPH
  {0xD6E9, 0x7027}, //13361 #CJK UNIFIED IDEOGRAPH
  {0xD6EA, 0x74CF}, //13362 #CJK UNIFIED IDEOGRAPH
  {0xD6EB, 0x7C60}, //13363 #CJK UNIFIED IDEOGRAPH
  {0xD6EC, 0x807E}, //13364 #CJK UNIFIED IDEOGRAPH
  {0xD6ED, 0x5121}, //13365 #CJK UNIFIED IDEOGRAPH
  {0xD6EE, 0x7028}, //13366 #CJK UNIFIED IDEOGRAPH
  {0xD6EF, 0x7262}, //13367 #CJK UNIFIED IDEOGRAPH
  {0xD6F0, 0x78CA}, //13368 #CJK UNIFIED IDEOGRAPH
  {0xD6F1, 0x8CC2}, //13369 #CJK UNIFIED IDEOGRAPH
  {0xD6F2, 0x8CDA}, //13370 #CJK UNIFIED IDEOGRAPH
  {0xD6F3, 0x8CF4}, //13371 #CJK UNIFIED IDEOGRAPH
  {0xD6F4, 0x96F7}, //13372 #CJK UNIFIED IDEOGRAPH
  {0xD6F5, 0x4E86}, //13373 #CJK UNIFIED IDEOGRAPH
  {0xD6F6, 0x50DA}, //13374 #CJK UNIFIED IDEOGRAPH
  {0xD6F7, 0x5BEE}, //13375 #CJK UNIFIED IDEOGRAPH
  {0xD6F8, 0x5ED6}, //13376 #CJK UNIFIED IDEOGRAPH
  {0xD6F9, 0x6599}, //13377 #CJK UNIFIED IDEOGRAPH
  {0xD6FA, 0x71CE}, //13378 #CJK UNIFIED IDEOGRAPH
  {0xD6FB, 0x7642}, //13379 #CJK UNIFIED IDEOGRAPH
  {0xD6FC, 0x77AD}, //13380 #CJK UNIFIED IDEOGRAPH
  {0xD6FD, 0x804A}, //13381 #CJK UNIFIED IDEOGRAPH
  {0xD6FE, 0x84FC}, //13382 #CJK UNIFIED IDEOGRAPH
  {0xD7A1, 0x907C}, //13383 #CJK UNIFIED IDEOGRAPH
  {0xD7A2, 0x9B27}, //13384 #CJK UNIFIED IDEOGRAPH
  {0xD7A3, 0x9F8D}, //13385 #CJK UNIFIED IDEOGRAPH
  {0xD7A4, 0x58D8}, //13386 #CJK UNIFIED IDEOGRAPH
  {0xD7A5, 0x5A41}, //13387 #CJK UNIFIED IDEOGRAPH
  {0xD7A6, 0x5C62}, //13388 #CJK UNIFIED IDEOGRAPH
  {0xD7A7, 0x6A13}, //13389 #CJK UNIFIED IDEOGRAPH
  {0xD7A8, 0x6DDA}, //13390 #CJK UNIFIED IDEOGRAPH
  {0xD7A9, 0x6F0F}, //13391 #CJK UNIFIED IDEOGRAPH
  {0xD7AA, 0x763B}, //13392 #CJK UNIFIED IDEOGRAPH
  {0xD7AB, 0x7D2F}, //13393 #CJK UNIFIED IDEOGRAPH
  {0xD7AC, 0x7E37}, //13394 #CJK UNIFIED IDEOGRAPH
  {0xD7AD, 0x851E}, //13395 #CJK UNIFIED IDEOGRAPH
  {0xD7AE, 0x8938}, //13396 #CJK UNIFIED IDEOGRAPH
  {0xD7AF, 0x93E4}, //13397 #CJK UNIFIED IDEOGRAPH
  {0xD7B0, 0x964B}, //13398 #CJK UNIFIED IDEOGRAPH
  {0xD7B1, 0x5289}, //13399 #CJK UNIFIED IDEOGRAPH
  {0xD7B2, 0x65D2}, //13400 #CJK UNIFIED IDEOGRAPH
  {0xD7B3, 0x67F3}, //13401 #CJK UNIFIED IDEOGRAPH
  {0xD7B4, 0x69B4}, //13402 #CJK UNIFIED IDEOGRAPH
  {0xD7B5, 0x6D41}, //13403 #CJK UNIFIED IDEOGRAPH
  {0xD7B6, 0x6E9C}, //13404 #CJK UNIFIED IDEOGRAPH
  {0xD7B7, 0x700F}, //13405 #CJK UNIFIED IDEOGRAPH
  {0xD7B8, 0x7409}, //13406 #CJK UNIFIED IDEOGRAPH
  {0xD7B9, 0x7460}, //13407 #CJK UNIFIED IDEOGRAPH
  {0xD7BA, 0x7559}, //13408 #CJK UNIFIED IDEOGRAPH
  {0xD7BB, 0x7624}, //13409 #CJK UNIFIED IDEOGRAPH
  {0xD7BC, 0x786B}, //13410 #CJK UNIFIED IDEOGRAPH
  {0xD7BD, 0x8B2C}, //13411 #CJK UNIFIED IDEOGRAPH
  {0xD7BE, 0x985E}, //13412 #CJK UNIFIED IDEOGRAPH
  {0xD7BF, 0x516D}, //13413 #CJK UNIFIED IDEOGRAPH
  {0xD7C0, 0x622E}, //13414 #CJK UNIFIED IDEOGRAPH
  {0xD7C1, 0x9678}, //13415 #CJK UNIFIED IDEOGRAPH
  {0xD7C2, 0x4F96}, //13416 #CJK UNIFIED IDEOGRAPH
  {0xD7C3, 0x502B}, //13417 #CJK UNIFIED IDEOGRAPH
  {0xD7C4, 0x5D19}, //13418 #CJK UNIFIED IDEOGRAPH
  {0xD7C5, 0x6DEA}, //13419 #CJK UNIFIED IDEOGRAPH
  {0xD7C6, 0x7DB8}, //13420 #CJK UNIFIED IDEOGRAPH
  {0xD7C7, 0x8F2A}, //13421 #CJK UNIFIED IDEOGRAPH
  {0xD7C8, 0x5F8B}, //13422 #CJK UNIFIED IDEOGRAPH
  {0xD7C9, 0x6144}, //13423 #CJK UNIFIED IDEOGRAPH
  {0xD7CA, 0x6817}, //13424 #CJK UNIFIED IDEOGRAPH
  {0xD7CB, 0xF961}, //13425 #CJK COMPATIBILITY IDEOGRAPH
  {0xD7CC, 0x9686}, //13426 #CJK UNIFIED IDEOGRAPH
  {0xD7CD, 0x52D2}, //13427 #CJK UNIFIED IDEOGRAPH
  {0xD7CE, 0x808B}, //13428 #CJK UNIFIED IDEOGRAPH
  {0xD7CF, 0x51DC}, //13429 #CJK UNIFIED IDEOGRAPH
  {0xD7D0, 0x51CC}, //13430 #CJK UNIFIED IDEOGRAPH
  {0xD7D1, 0x695E}, //13431 #CJK UNIFIED IDEOGRAPH
  {0xD7D2, 0x7A1C}, //13432 #CJK UNIFIED IDEOGRAPH
  {0xD7D3, 0x7DBE}, //13433 #CJK UNIFIED IDEOGRAPH
  {0xD7D4, 0x83F1}, //13434 #CJK UNIFIED IDEOGRAPH
  {0xD7D5, 0x9675}, //13435 #CJK UNIFIED IDEOGRAPH
  {0xD7D6, 0x4FDA}, //13436 #CJK UNIFIED IDEOGRAPH
  {0xD7D7, 0x5229}, //13437 #CJK UNIFIED IDEOGRAPH
  {0xD7D8, 0x5398}, //13438 #CJK UNIFIED IDEOGRAPH
  {0xD7D9, 0x540F}, //13439 #CJK UNIFIED IDEOGRAPH
  {0xD7DA, 0x550E}, //13440 #CJK UNIFIED IDEOGRAPH
  {0xD7DB, 0x5C65}, //13441 #CJK UNIFIED IDEOGRAPH
  {0xD7DC, 0x60A7}, //13442 #CJK UNIFIED IDEOGRAPH
  {0xD7DD, 0x674E}, //13443 #CJK UNIFIED IDEOGRAPH
  {0xD7DE, 0x68A8}, //13444 #CJK UNIFIED IDEOGRAPH
  {0xD7DF, 0x6D6C}, //13445 #CJK UNIFIED IDEOGRAPH
  {0xD7E0, 0x7281}, //13446 #CJK UNIFIED IDEOGRAPH
  {0xD7E1, 0x72F8}, //13447 #CJK UNIFIED IDEOGRAPH
  {0xD7E2, 0x7406}, //13448 #CJK UNIFIED IDEOGRAPH
  {0xD7E3, 0x7483}, //13449 #CJK UNIFIED IDEOGRAPH
  {0xD7E4, 0xF962}, //13450 #CJK COMPATIBILITY IDEOGRAPH
  {0xD7E5, 0x75E2}, //13451 #CJK UNIFIED IDEOGRAPH
  {0xD7E6, 0x7C6C}, //13452 #CJK UNIFIED IDEOGRAPH
  {0xD7E7, 0x7F79}, //13453 #CJK UNIFIED IDEOGRAPH
  {0xD7E8, 0x7FB8}, //13454 #CJK UNIFIED IDEOGRAPH
  {0xD7E9, 0x8389}, //13455 #CJK UNIFIED IDEOGRAPH
  {0xD7EA, 0x88CF}, //13456 #CJK UNIFIED IDEOGRAPH
  {0xD7EB, 0x88E1}, //13457 #CJK UNIFIED IDEOGRAPH
  {0xD7EC, 0x91CC}, //13458 #CJK UNIFIED IDEOGRAPH
  {0xD7ED, 0x91D0}, //13459 #CJK UNIFIED IDEOGRAPH
  {0xD7EE, 0x96E2}, //13460 #CJK UNIFIED IDEOGRAPH
  {0xD7EF, 0x9BC9}, //13461 #CJK UNIFIED IDEOGRAPH
  {0xD7F0, 0x541D}, //13462 #CJK UNIFIED IDEOGRAPH
  {0xD7F1, 0x6F7E}, //13463 #CJK UNIFIED IDEOGRAPH
  {0xD7F2, 0x71D0}, //13464 #CJK UNIFIED IDEOGRAPH
  {0xD7F3, 0x7498}, //13465 #CJK UNIFIED IDEOGRAPH
  {0xD7F4, 0x85FA}, //13466 #CJK UNIFIED IDEOGRAPH
  {0xD7F5, 0x8EAA}, //13467 #CJK UNIFIED IDEOGRAPH
  {0xD7F6, 0x96A3}, //13468 #CJK UNIFIED IDEOGRAPH
  {0xD7F7, 0x9C57}, //13469 #CJK UNIFIED IDEOGRAPH
  {0xD7F8, 0x9E9F}, //13470 #CJK UNIFIED IDEOGRAPH
  {0xD7F9, 0x6797}, //13471 #CJK UNIFIED IDEOGRAPH
  {0xD7FA, 0x6DCB}, //13472 #CJK UNIFIED IDEOGRAPH
  {0xD7FB, 0x7433}, //13473 #CJK UNIFIED IDEOGRAPH
  {0xD7FC, 0x81E8}, //13474 #CJK UNIFIED IDEOGRAPH
  {0xD7FD, 0x9716}, //13475 #CJK UNIFIED IDEOGRAPH
  {0xD7FE, 0x782C}, //13476 #CJK UNIFIED IDEOGRAPH
  {0xD8A1, 0x7ACB}, //13477 #CJK UNIFIED IDEOGRAPH
  {0xD8A2, 0x7B20}, //13478 #CJK UNIFIED IDEOGRAPH
  {0xD8A3, 0x7C92}, //13479 #CJK UNIFIED IDEOGRAPH
  {0xD8A4, 0x6469}, //13480 #CJK UNIFIED IDEOGRAPH
  {0xD8A5, 0x746A}, //13481 #CJK UNIFIED IDEOGRAPH
  {0xD8A6, 0x75F2}, //13482 #CJK UNIFIED IDEOGRAPH
  {0xD8A7, 0x78BC}, //13483 #CJK UNIFIED IDEOGRAPH
  {0xD8A8, 0x78E8}, //13484 #CJK UNIFIED IDEOGRAPH
  {0xD8A9, 0x99AC}, //13485 #CJK UNIFIED IDEOGRAPH
  {0xD8AA, 0x9B54}, //13486 #CJK UNIFIED IDEOGRAPH
  {0xD8AB, 0x9EBB}, //13487 #CJK UNIFIED IDEOGRAPH
  {0xD8AC, 0x5BDE}, //13488 #CJK UNIFIED IDEOGRAPH
  {0xD8AD, 0x5E55}, //13489 #CJK UNIFIED IDEOGRAPH
  {0xD8AE, 0x6F20}, //13490 #CJK UNIFIED IDEOGRAPH
  {0xD8AF, 0x819C}, //13491 #CJK UNIFIED IDEOGRAPH
  {0xD8B0, 0x83AB}, //13492 #CJK UNIFIED IDEOGRAPH
  {0xD8B1, 0x9088}, //13493 #CJK UNIFIED IDEOGRAPH
  {0xD8B2, 0x4E07}, //13494 #CJK UNIFIED IDEOGRAPH
  {0xD8B3, 0x534D}, //13495 #CJK UNIFIED IDEOGRAPH
  {0xD8B4, 0x5A29}, //13496 #CJK UNIFIED IDEOGRAPH
  {0xD8B5, 0x5DD2}, //13497 #CJK UNIFIED IDEOGRAPH
  {0xD8B6, 0x5F4E}, //13498 #CJK UNIFIED IDEOGRAPH
  {0xD8B7, 0x6162}, //13499 #CJK UNIFIED IDEOGRAPH
  {0xD8B8, 0x633D}, //13500 #CJK UNIFIED IDEOGRAPH
  {0xD8B9, 0x6669}, //13501 #CJK UNIFIED IDEOGRAPH
  {0xD8BA, 0x66FC}, //13502 #CJK UNIFIED IDEOGRAPH
  {0xD8BB, 0x6EFF}, //13503 #CJK UNIFIED IDEOGRAPH
  {0xD8BC, 0x6F2B}, //13504 #CJK UNIFIED IDEOGRAPH
  {0xD8BD, 0x7063}, //13505 #CJK UNIFIED IDEOGRAPH
  {0xD8BE, 0x779E}, //13506 #CJK UNIFIED IDEOGRAPH
  {0xD8BF, 0x842C}, //13507 #CJK UNIFIED IDEOGRAPH
  {0xD8C0, 0x8513}, //13508 #CJK UNIFIED IDEOGRAPH
  {0xD8C1, 0x883B}, //13509 #CJK UNIFIED IDEOGRAPH
  {0xD8C2, 0x8F13}, //13510 #CJK UNIFIED IDEOGRAPH
  {0xD8C3, 0x9945}, //13511 #CJK UNIFIED IDEOGRAPH
  {0xD8C4, 0x9C3B}, //13512 #CJK UNIFIED IDEOGRAPH
  {0xD8C5, 0x551C}, //13513 #CJK UNIFIED IDEOGRAPH
  {0xD8C6, 0x62B9}, //13514 #CJK UNIFIED IDEOGRAPH
  {0xD8C7, 0x672B}, //13515 #CJK UNIFIED IDEOGRAPH
  {0xD8C8, 0x6CAB}, //13516 #CJK UNIFIED IDEOGRAPH
  {0xD8C9, 0x8309}, //13517 #CJK UNIFIED IDEOGRAPH
  {0xD8CA, 0x896A}, //13518 #CJK UNIFIED IDEOGRAPH
  {0xD8CB, 0x977A}, //13519 #CJK UNIFIED IDEOGRAPH
  {0xD8CC, 0x4EA1}, //13520 #CJK UNIFIED IDEOGRAPH
  {0xD8CD, 0x5984}, //13521 #CJK UNIFIED IDEOGRAPH
  {0xD8CE, 0x5FD8}, //13522 #CJK UNIFIED IDEOGRAPH
  {0xD8CF, 0x5FD9}, //13523 #CJK UNIFIED IDEOGRAPH
  {0xD8D0, 0x671B}, //13524 #CJK UNIFIED IDEOGRAPH
  {0xD8D1, 0x7DB2}, //13525 #CJK UNIFIED IDEOGRAPH
  {0xD8D2, 0x7F54}, //13526 #CJK UNIFIED IDEOGRAPH
  {0xD8D3, 0x8292}, //13527 #CJK UNIFIED IDEOGRAPH
  {0xD8D4, 0x832B}, //13528 #CJK UNIFIED IDEOGRAPH
  {0xD8D5, 0x83BD}, //13529 #CJK UNIFIED IDEOGRAPH
  {0xD8D6, 0x8F1E}, //13530 #CJK UNIFIED IDEOGRAPH
  {0xD8D7, 0x9099}, //13531 #CJK UNIFIED IDEOGRAPH
  {0xD8D8, 0x57CB}, //13532 #CJK UNIFIED IDEOGRAPH
  {0xD8D9, 0x59B9}, //13533 #CJK UNIFIED IDEOGRAPH
  {0xD8DA, 0x5A92}, //13534 #CJK UNIFIED IDEOGRAPH
  {0xD8DB, 0x5BD0}, //13535 #CJK UNIFIED IDEOGRAPH
  {0xD8DC, 0x6627}, //13536 #CJK UNIFIED IDEOGRAPH
  {0xD8DD, 0x679A}, //13537 #CJK UNIFIED IDEOGRAPH
  {0xD8DE, 0x6885}, //13538 #CJK UNIFIED IDEOGRAPH
  {0xD8DF, 0x6BCF}, //13539 #CJK UNIFIED IDEOGRAPH
  {0xD8E0, 0x7164}, //13540 #CJK UNIFIED IDEOGRAPH
  {0xD8E1, 0x7F75}, //13541 #CJK UNIFIED IDEOGRAPH
  {0xD8E2, 0x8CB7}, //13542 #CJK UNIFIED IDEOGRAPH
  {0xD8E3, 0x8CE3}, //13543 #CJK UNIFIED IDEOGRAPH
  {0xD8E4, 0x9081}, //13544 #CJK UNIFIED IDEOGRAPH
  {0xD8E5, 0x9B45}, //13545 #CJK UNIFIED IDEOGRAPH
  {0xD8E6, 0x8108}, //13546 #CJK UNIFIED IDEOGRAPH
  {0xD8E7, 0x8C8A}, //13547 #CJK UNIFIED IDEOGRAPH
  {0xD8E8, 0x964C}, //13548 #CJK UNIFIED IDEOGRAPH
  {0xD8E9, 0x9A40}, //13549 #CJK UNIFIED IDEOGRAPH
  {0xD8EA, 0x9EA5}, //13550 #CJK UNIFIED IDEOGRAPH
  {0xD8EB, 0x5B5F}, //13551 #CJK UNIFIED IDEOGRAPH
  {0xD8EC, 0x6C13}, //13552 #CJK UNIFIED IDEOGRAPH
  {0xD8ED, 0x731B}, //13553 #CJK UNIFIED IDEOGRAPH
  {0xD8EE, 0x76F2}, //13554 #CJK UNIFIED IDEOGRAPH
  {0xD8EF, 0x76DF}, //13555 #CJK UNIFIED IDEOGRAPH
  {0xD8F0, 0x840C}, //13556 #CJK UNIFIED IDEOGRAPH
  {0xD8F1, 0x51AA}, //13557 #CJK UNIFIED IDEOGRAPH
  {0xD8F2, 0x8993}, //13558 #CJK UNIFIED IDEOGRAPH
  {0xD8F3, 0x514D}, //13559 #CJK UNIFIED IDEOGRAPH
  {0xD8F4, 0x5195}, //13560 #CJK UNIFIED IDEOGRAPH
  {0xD8F5, 0x52C9}, //13561 #CJK UNIFIED IDEOGRAPH
  {0xD8F6, 0x68C9}, //13562 #CJK UNIFIED IDEOGRAPH
  {0xD8F7, 0x6C94}, //13563 #CJK UNIFIED IDEOGRAPH
  {0xD8F8, 0x7704}, //13564 #CJK UNIFIED IDEOGRAPH
  {0xD8F9, 0x7720}, //13565 #CJK UNIFIED IDEOGRAPH
  {0xD8FA, 0x7DBF}, //13566 #CJK UNIFIED IDEOGRAPH
  {0xD8FB, 0x7DEC}, //13567 #CJK UNIFIED IDEOGRAPH
  {0xD8FC, 0x9762}, //13568 #CJK UNIFIED IDEOGRAPH
  {0xD8FD, 0x9EB5}, //13569 #CJK UNIFIED IDEOGRAPH
  {0xD8FE, 0x6EC5}, //13570 #CJK UNIFIED IDEOGRAPH
  {0xD9A1, 0x8511}, //13571 #CJK UNIFIED IDEOGRAPH
  {0xD9A2, 0x51A5}, //13572 #CJK UNIFIED IDEOGRAPH
  {0xD9A3, 0x540D}, //13573 #CJK UNIFIED IDEOGRAPH
  {0xD9A4, 0x547D}, //13574 #CJK UNIFIED IDEOGRAPH
  {0xD9A5, 0x660E}, //13575 #CJK UNIFIED IDEOGRAPH
  {0xD9A6, 0x669D}, //13576 #CJK UNIFIED IDEOGRAPH
  {0xD9A7, 0x6927}, //13577 #CJK UNIFIED IDEOGRAPH
  {0xD9A8, 0x6E9F}, //13578 #CJK UNIFIED IDEOGRAPH
  {0xD9A9, 0x76BF}, //13579 #CJK UNIFIED IDEOGRAPH
  {0xD9AA, 0x7791}, //13580 #CJK UNIFIED IDEOGRAPH
  {0xD9AB, 0x8317}, //13581 #CJK UNIFIED IDEOGRAPH
  {0xD9AC, 0x84C2}, //13582 #CJK UNIFIED IDEOGRAPH
  {0xD9AD, 0x879F}, //13583 #CJK UNIFIED IDEOGRAPH
  {0xD9AE, 0x9169}, //13584 #CJK UNIFIED IDEOGRAPH
  {0xD9AF, 0x9298}, //13585 #CJK UNIFIED IDEOGRAPH
  {0xD9B0, 0x9CF4}, //13586 #CJK UNIFIED IDEOGRAPH
  {0xD9B1, 0x8882}, //13587 #CJK UNIFIED IDEOGRAPH
  {0xD9B2, 0x4FAE}, //13588 #CJK UNIFIED IDEOGRAPH
  {0xD9B3, 0x5192}, //13589 #CJK UNIFIED IDEOGRAPH
  {0xD9B4, 0x52DF}, //13590 #CJK UNIFIED IDEOGRAPH
  {0xD9B5, 0x59C6}, //13591 #CJK UNIFIED IDEOGRAPH
  {0xD9B6, 0x5E3D}, //13592 #CJK UNIFIED IDEOGRAPH
  {0xD9B7, 0x6155}, //13593 #CJK UNIFIED IDEOGRAPH
  {0xD9B8, 0x6478}, //13594 #CJK UNIFIED IDEOGRAPH
  {0xD9B9, 0x6479}, //13595 #CJK UNIFIED IDEOGRAPH
  {0xD9BA, 0x66AE}, //13596 #CJK UNIFIED IDEOGRAPH
  {0xD9BB, 0x67D0}, //13597 #CJK UNIFIED IDEOGRAPH
  {0xD9BC, 0x6A21}, //13598 #CJK UNIFIED IDEOGRAPH
  {0xD9BD, 0x6BCD}, //13599 #CJK UNIFIED IDEOGRAPH
  {0xD9BE, 0x6BDB}, //13600 #CJK UNIFIED IDEOGRAPH
  {0xD9BF, 0x725F}, //13601 #CJK UNIFIED IDEOGRAPH
  {0xD9C0, 0x7261}, //13602 #CJK UNIFIED IDEOGRAPH
  {0xD9C1, 0x7441}, //13603 #CJK UNIFIED IDEOGRAPH
  {0xD9C2, 0x7738}, //13604 #CJK UNIFIED IDEOGRAPH
  {0xD9C3, 0x77DB}, //13605 #CJK UNIFIED IDEOGRAPH
  {0xD9C4, 0x8017}, //13606 #CJK UNIFIED IDEOGRAPH
  {0xD9C5, 0x82BC}, //13607 #CJK UNIFIED IDEOGRAPH
  {0xD9C6, 0x8305}, //13608 #CJK UNIFIED IDEOGRAPH
  {0xD9C7, 0x8B00}, //13609 #CJK UNIFIED IDEOGRAPH
  {0xD9C8, 0x8B28}, //13610 #CJK UNIFIED IDEOGRAPH
  {0xD9C9, 0x8C8C}, //13611 #CJK UNIFIED IDEOGRAPH
  {0xD9CA, 0x6728}, //13612 #CJK UNIFIED IDEOGRAPH
  {0xD9CB, 0x6C90}, //13613 #CJK UNIFIED IDEOGRAPH
  {0xD9CC, 0x7267}, //13614 #CJK UNIFIED IDEOGRAPH
  {0xD9CD, 0x76EE}, //13615 #CJK UNIFIED IDEOGRAPH
  {0xD9CE, 0x7766}, //13616 #CJK UNIFIED IDEOGRAPH
  {0xD9CF, 0x7A46}, //13617 #CJK UNIFIED IDEOGRAPH
  {0xD9D0, 0x9DA9}, //13618 #CJK UNIFIED IDEOGRAPH
  {0xD9D1, 0x6B7F}, //13619 #CJK UNIFIED IDEOGRAPH
  {0xD9D2, 0x6C92}, //13620 #CJK UNIFIED IDEOGRAPH
  {0xD9D3, 0x5922}, //13621 #CJK UNIFIED IDEOGRAPH
  {0xD9D4, 0x6726}, //13622 #CJK UNIFIED IDEOGRAPH
  {0xD9D5, 0x8499}, //13623 #CJK UNIFIED IDEOGRAPH
  {0xD9D6, 0x536F}, //13624 #CJK UNIFIED IDEOGRAPH
  {0xD9D7, 0x5893}, //13625 #CJK UNIFIED IDEOGRAPH
  {0xD9D8, 0x5999}, //13626 #CJK UNIFIED IDEOGRAPH
  {0xD9D9, 0x5EDF}, //13627 #CJK UNIFIED IDEOGRAPH
  {0xD9DA, 0x63CF}, //13628 #CJK UNIFIED IDEOGRAPH
  {0xD9DB, 0x6634}, //13629 #CJK UNIFIED IDEOGRAPH
  {0xD9DC, 0x6773}, //13630 #CJK UNIFIED IDEOGRAPH
  {0xD9DD, 0x6E3A}, //13631 #CJK UNIFIED IDEOGRAPH
  {0xD9DE, 0x732B}, //13632 #CJK UNIFIED IDEOGRAPH
  {0xD9DF, 0x7AD7}, //13633 #CJK UNIFIED IDEOGRAPH
  {0xD9E0, 0x82D7}, //13634 #CJK UNIFIED IDEOGRAPH
  {0xD9E1, 0x9328}, //13635 #CJK UNIFIED IDEOGRAPH
  {0xD9E2, 0x52D9}, //13636 #CJK UNIFIED IDEOGRAPH
  {0xD9E3, 0x5DEB}, //13637 #CJK UNIFIED IDEOGRAPH
  {0xD9E4, 0x61AE}, //13638 #CJK UNIFIED IDEOGRAPH
  {0xD9E5, 0x61CB}, //13639 #CJK UNIFIED IDEOGRAPH
  {0xD9E6, 0x620A}, //13640 #CJK UNIFIED IDEOGRAPH
  {0xD9E7, 0x62C7}, //13641 #CJK UNIFIED IDEOGRAPH
  {0xD9E8, 0x64AB}, //13642 #CJK UNIFIED IDEOGRAPH
  {0xD9E9, 0x65E0}, //13643 #CJK UNIFIED IDEOGRAPH
  {0xD9EA, 0x6959}, //13644 #CJK UNIFIED IDEOGRAPH
  {0xD9EB, 0x6B66}, //13645 #CJK UNIFIED IDEOGRAPH
  {0xD9EC, 0x6BCB}, //13646 #CJK UNIFIED IDEOGRAPH
  {0xD9ED, 0x7121}, //13647 #CJK UNIFIED IDEOGRAPH
  {0xD9EE, 0x73F7}, //13648 #CJK UNIFIED IDEOGRAPH
  {0xD9EF, 0x755D}, //13649 #CJK UNIFIED IDEOGRAPH
  {0xD9F0, 0x7E46}, //13650 #CJK UNIFIED IDEOGRAPH
  {0xD9F1, 0x821E}, //13651 #CJK UNIFIED IDEOGRAPH
  {0xD9F2, 0x8302}, //13652 #CJK UNIFIED IDEOGRAPH
  {0xD9F3, 0x856A}, //13653 #CJK UNIFIED IDEOGRAPH
  {0xD9F4, 0x8AA3}, //13654 #CJK UNIFIED IDEOGRAPH
  {0xD9F5, 0x8CBF}, //13655 #CJK UNIFIED IDEOGRAPH
  {0xD9F6, 0x9727}, //13656 #CJK UNIFIED IDEOGRAPH
  {0xD9F7, 0x9D61}, //13657 #CJK UNIFIED IDEOGRAPH
  {0xD9F8, 0x58A8}, //13658 #CJK UNIFIED IDEOGRAPH
  {0xD9F9, 0x9ED8}, //13659 #CJK UNIFIED IDEOGRAPH
  {0xD9FA, 0x5011}, //13660 #CJK UNIFIED IDEOGRAPH
  {0xD9FB, 0x520E}, //13661 #CJK UNIFIED IDEOGRAPH
  {0xD9FC, 0x543B}, //13662 #CJK UNIFIED IDEOGRAPH
  {0xD9FD, 0x554F}, //13663 #CJK UNIFIED IDEOGRAPH
  {0xD9FE, 0x6587}, //13664 #CJK UNIFIED IDEOGRAPH
  {0xDAA1, 0x6C76}, //13665 #CJK UNIFIED IDEOGRAPH
  {0xDAA2, 0x7D0A}, //13666 #CJK UNIFIED IDEOGRAPH
  {0xDAA3, 0x7D0B}, //13667 #CJK UNIFIED IDEOGRAPH
  {0xDAA4, 0x805E}, //13668 #CJK UNIFIED IDEOGRAPH
  {0xDAA5, 0x868A}, //13669 #CJK UNIFIED IDEOGRAPH
  {0xDAA6, 0x9580}, //13670 #CJK UNIFIED IDEOGRAPH
  {0xDAA7, 0x96EF}, //13671 #CJK UNIFIED IDEOGRAPH
  {0xDAA8, 0x52FF}, //13672 #CJK UNIFIED IDEOGRAPH
  {0xDAA9, 0x6C95}, //13673 #CJK UNIFIED IDEOGRAPH
  {0xDAAA, 0x7269}, //13674 #CJK UNIFIED IDEOGRAPH
  {0xDAAB, 0x5473}, //13675 #CJK UNIFIED IDEOGRAPH
  {0xDAAC, 0x5A9A}, //13676 #CJK UNIFIED IDEOGRAPH
  {0xDAAD, 0x5C3E}, //13677 #CJK UNIFIED IDEOGRAPH
  {0xDAAE, 0x5D4B}, //13678 #CJK UNIFIED IDEOGRAPH
  {0xDAAF, 0x5F4C}, //13679 #CJK UNIFIED IDEOGRAPH
  {0xDAB0, 0x5FAE}, //13680 #CJK UNIFIED IDEOGRAPH
  {0xDAB1, 0x672A}, //13681 #CJK UNIFIED IDEOGRAPH
  {0xDAB2, 0x68B6}, //13682 #CJK UNIFIED IDEOGRAPH
  {0xDAB3, 0x6963}, //13683 #CJK UNIFIED IDEOGRAPH
  {0xDAB4, 0x6E3C}, //13684 #CJK UNIFIED IDEOGRAPH
  {0xDAB5, 0x6E44}, //13685 #CJK UNIFIED IDEOGRAPH
  {0xDAB6, 0x7709}, //13686 #CJK UNIFIED IDEOGRAPH
  {0xDAB7, 0x7C73}, //13687 #CJK UNIFIED IDEOGRAPH
  {0xDAB8, 0x7F8E}, //13688 #CJK UNIFIED IDEOGRAPH
  {0xDAB9, 0x8587}, //13689 #CJK UNIFIED IDEOGRAPH
  {0xDABA, 0x8B0E}, //13690 #CJK UNIFIED IDEOGRAPH
  {0xDABB, 0x8FF7}, //13691 #CJK UNIFIED IDEOGRAPH
  {0xDABC, 0x9761}, //13692 #CJK UNIFIED IDEOGRAPH
  {0xDABD, 0x9EF4}, //13693 #CJK UNIFIED IDEOGRAPH
  {0xDABE, 0x5CB7}, //13694 #CJK UNIFIED IDEOGRAPH
  {0xDABF, 0x60B6}, //13695 #CJK UNIFIED IDEOGRAPH
  {0xDAC0, 0x610D}, //13696 #CJK UNIFIED IDEOGRAPH
  {0xDAC1, 0x61AB}, //13697 #CJK UNIFIED IDEOGRAPH
  {0xDAC2, 0x654F}, //13698 #CJK UNIFIED IDEOGRAPH
  {0xDAC3, 0x65FB}, //13699 #CJK UNIFIED IDEOGRAPH
  {0xDAC4, 0x65FC}, //13700 #CJK UNIFIED IDEOGRAPH
  {0xDAC5, 0x6C11}, //13701 #CJK UNIFIED IDEOGRAPH
  {0xDAC6, 0x6CEF}, //13702 #CJK UNIFIED IDEOGRAPH
  {0xDAC7, 0x739F}, //13703 #CJK UNIFIED IDEOGRAPH
  {0xDAC8, 0x73C9}, //13704 #CJK UNIFIED IDEOGRAPH
  {0xDAC9, 0x7DE1}, //13705 #CJK UNIFIED IDEOGRAPH
  {0xDACA, 0x9594}, //13706 #CJK UNIFIED IDEOGRAPH
  {0xDACB, 0x5BC6}, //13707 #CJK UNIFIED IDEOGRAPH
  {0xDACC, 0x871C}, //13708 #CJK UNIFIED IDEOGRAPH
  {0xDACD, 0x8B10}, //13709 #CJK UNIFIED IDEOGRAPH
  {0xDACE, 0x525D}, //13710 #CJK UNIFIED IDEOGRAPH
  {0xDACF, 0x535A}, //13711 #CJK UNIFIED IDEOGRAPH
  {0xDAD0, 0x62CD}, //13712 #CJK UNIFIED IDEOGRAPH
  {0xDAD1, 0x640F}, //13713 #CJK UNIFIED IDEOGRAPH
  {0xDAD2, 0x64B2}, //13714 #CJK UNIFIED IDEOGRAPH
  {0xDAD3, 0x6734}, //13715 #CJK UNIFIED IDEOGRAPH
  {0xDAD4, 0x6A38}, //13716 #CJK UNIFIED IDEOGRAPH
  {0xDAD5, 0x6CCA}, //13717 #CJK UNIFIED IDEOGRAPH
  {0xDAD6, 0x73C0}, //13718 #CJK UNIFIED IDEOGRAPH
  {0xDAD7, 0x749E}, //13719 #CJK UNIFIED IDEOGRAPH
  {0xDAD8, 0x7B94}, //13720 #CJK UNIFIED IDEOGRAPH
  {0xDAD9, 0x7C95}, //13721 #CJK UNIFIED IDEOGRAPH
  {0xDADA, 0x7E1B}, //13722 #CJK UNIFIED IDEOGRAPH
  {0xDADB, 0x818A}, //13723 #CJK UNIFIED IDEOGRAPH
  {0xDADC, 0x8236}, //13724 #CJK UNIFIED IDEOGRAPH
  {0xDADD, 0x8584}, //13725 #CJK UNIFIED IDEOGRAPH
  {0xDADE, 0x8FEB}, //13726 #CJK UNIFIED IDEOGRAPH
  {0xDADF, 0x96F9}, //13727 #CJK UNIFIED IDEOGRAPH
  {0xDAE0, 0x99C1}, //13728 #CJK UNIFIED IDEOGRAPH
  {0xDAE1, 0x4F34}, //13729 #CJK UNIFIED IDEOGRAPH
  {0xDAE2, 0x534A}, //13730 #CJK UNIFIED IDEOGRAPH
  {0xDAE3, 0x53CD}, //13731 #CJK UNIFIED IDEOGRAPH
  {0xDAE4, 0x53DB}, //13732 #CJK UNIFIED IDEOGRAPH
  {0xDAE5, 0x62CC}, //13733 #CJK UNIFIED IDEOGRAPH
  {0xDAE6, 0x642C}, //13734 #CJK UNIFIED IDEOGRAPH
  {0xDAE7, 0x6500}, //13735 #CJK UNIFIED IDEOGRAPH
  {0xDAE8, 0x6591}, //13736 #CJK UNIFIED IDEOGRAPH
  {0xDAE9, 0x69C3}, //13737 #CJK UNIFIED IDEOGRAPH
  {0xDAEA, 0x6CEE}, //13738 #CJK UNIFIED IDEOGRAPH
  {0xDAEB, 0x6F58}, //13739 #CJK UNIFIED IDEOGRAPH
  {0xDAEC, 0x73ED}, //13740 #CJK UNIFIED IDEOGRAPH
  {0xDAED, 0x7554}, //13741 #CJK UNIFIED IDEOGRAPH
  {0xDAEE, 0x7622}, //13742 #CJK UNIFIED IDEOGRAPH
  {0xDAEF, 0x76E4}, //13743 #CJK UNIFIED IDEOGRAPH
  {0xDAF0, 0x76FC}, //13744 #CJK UNIFIED IDEOGRAPH
  {0xDAF1, 0x78D0}, //13745 #CJK UNIFIED IDEOGRAPH
  {0xDAF2, 0x78FB}, //13746 #CJK UNIFIED IDEOGRAPH
  {0xDAF3, 0x792C}, //13747 #CJK UNIFIED IDEOGRAPH
  {0xDAF4, 0x7D46}, //13748 #CJK UNIFIED IDEOGRAPH
  {0xDAF5, 0x822C}, //13749 #CJK UNIFIED IDEOGRAPH
  {0xDAF6, 0x87E0}, //13750 #CJK UNIFIED IDEOGRAPH
  {0xDAF7, 0x8FD4}, //13751 #CJK UNIFIED IDEOGRAPH
  {0xDAF8, 0x9812}, //13752 #CJK UNIFIED IDEOGRAPH
  {0xDAF9, 0x98EF}, //13753 #CJK UNIFIED IDEOGRAPH
  {0xDAFA, 0x52C3}, //13754 #CJK UNIFIED IDEOGRAPH
  {0xDAFB, 0x62D4}, //13755 #CJK UNIFIED IDEOGRAPH
  {0xDAFC, 0x64A5}, //13756 #CJK UNIFIED IDEOGRAPH
  {0xDAFD, 0x6E24}, //13757 #CJK UNIFIED IDEOGRAPH
  {0xDAFE, 0x6F51}, //13758 #CJK UNIFIED IDEOGRAPH
  {0xDBA1, 0x767C}, //13759 #CJK UNIFIED IDEOGRAPH
  {0xDBA2, 0x8DCB}, //13760 #CJK UNIFIED IDEOGRAPH
  {0xDBA3, 0x91B1}, //13761 #CJK UNIFIED IDEOGRAPH
  {0xDBA4, 0x9262}, //13762 #CJK UNIFIED IDEOGRAPH
  {0xDBA5, 0x9AEE}, //13763 #CJK UNIFIED IDEOGRAPH
  {0xDBA6, 0x9B43}, //13764 #CJK UNIFIED IDEOGRAPH
  {0xDBA7, 0x5023}, //13765 #CJK UNIFIED IDEOGRAPH
  {0xDBA8, 0x508D}, //13766 #CJK UNIFIED IDEOGRAPH
  {0xDBA9, 0x574A}, //13767 #CJK UNIFIED IDEOGRAPH
  {0xDBAA, 0x59A8}, //13768 #CJK UNIFIED IDEOGRAPH
  {0xDBAB, 0x5C28}, //13769 #CJK UNIFIED IDEOGRAPH
  {0xDBAC, 0x5E47}, //13770 #CJK UNIFIED IDEOGRAPH
  {0xDBAD, 0x5F77}, //13771 #CJK UNIFIED IDEOGRAPH
  {0xDBAE, 0x623F}, //13772 #CJK UNIFIED IDEOGRAPH
  {0xDBAF, 0x653E}, //13773 #CJK UNIFIED IDEOGRAPH
  {0xDBB0, 0x65B9}, //13774 #CJK UNIFIED IDEOGRAPH
  {0xDBB1, 0x65C1}, //13775 #CJK UNIFIED IDEOGRAPH
  {0xDBB2, 0x6609}, //13776 #CJK UNIFIED IDEOGRAPH
  {0xDBB3, 0x678B}, //13777 #CJK UNIFIED IDEOGRAPH
  {0xDBB4, 0x699C}, //13778 #CJK UNIFIED IDEOGRAPH
  {0xDBB5, 0x6EC2}, //13779 #CJK UNIFIED IDEOGRAPH
  {0xDBB6, 0x78C5}, //13780 #CJK UNIFIED IDEOGRAPH
  {0xDBB7, 0x7D21}, //13781 #CJK UNIFIED IDEOGRAPH
  {0xDBB8, 0x80AA}, //13782 #CJK UNIFIED IDEOGRAPH
  {0xDBB9, 0x8180}, //13783 #CJK UNIFIED IDEOGRAPH
  {0xDBBA, 0x822B}, //13784 #CJK UNIFIED IDEOGRAPH
  {0xDBBB, 0x82B3}, //13785 #CJK UNIFIED IDEOGRAPH
  {0xDBBC, 0x84A1}, //13786 #CJK UNIFIED IDEOGRAPH
  {0xDBBD, 0x868C}, //13787 #CJK UNIFIED IDEOGRAPH
  {0xDBBE, 0x8A2A}, //13788 #CJK UNIFIED IDEOGRAPH
  {0xDBBF, 0x8B17}, //13789 #CJK UNIFIED IDEOGRAPH
  {0xDBC0, 0x90A6}, //13790 #CJK UNIFIED IDEOGRAPH
  {0xDBC1, 0x9632}, //13791 #CJK UNIFIED IDEOGRAPH
  {0xDBC2, 0x9F90}, //13792 #CJK UNIFIED IDEOGRAPH
  {0xDBC3, 0x500D}, //13793 #CJK UNIFIED IDEOGRAPH
  {0xDBC4, 0x4FF3}, //13794 #CJK UNIFIED IDEOGRAPH
  {0xDBC5, 0xF963}, //13795 #CJK COMPATIBILITY IDEOGRAPH
  {0xDBC6, 0x57F9}, //13796 #CJK UNIFIED IDEOGRAPH
  {0xDBC7, 0x5F98}, //13797 #CJK UNIFIED IDEOGRAPH
  {0xDBC8, 0x62DC}, //13798 #CJK UNIFIED IDEOGRAPH
  {0xDBC9, 0x6392}, //13799 #CJK UNIFIED IDEOGRAPH
  {0xDBCA, 0x676F}, //13800 #CJK UNIFIED IDEOGRAPH
  {0xDBCB, 0x6E43}, //13801 #CJK UNIFIED IDEOGRAPH
  {0xDBCC, 0x7119}, //13802 #CJK UNIFIED IDEOGRAPH
  {0xDBCD, 0x76C3}, //13803 #CJK UNIFIED IDEOGRAPH
  {0xDBCE, 0x80CC}, //13804 #CJK UNIFIED IDEOGRAPH
  {0xDBCF, 0x80DA}, //13805 #CJK UNIFIED IDEOGRAPH
  {0xDBD0, 0x88F4}, //13806 #CJK UNIFIED IDEOGRAPH
  {0xDBD1, 0x88F5}, //13807 #CJK UNIFIED IDEOGRAPH
  {0xDBD2, 0x8919}, //13808 #CJK UNIFIED IDEOGRAPH
  {0xDBD3, 0x8CE0}, //13809 #CJK UNIFIED IDEOGRAPH
  {0xDBD4, 0x8F29}, //13810 #CJK UNIFIED IDEOGRAPH
  {0xDBD5, 0x914D}, //13811 #CJK UNIFIED IDEOGRAPH
  {0xDBD6, 0x966A}, //13812 #CJK UNIFIED IDEOGRAPH
  {0xDBD7, 0x4F2F}, //13813 #CJK UNIFIED IDEOGRAPH
  {0xDBD8, 0x4F70}, //13814 #CJK UNIFIED IDEOGRAPH
  {0xDBD9, 0x5E1B}, //13815 #CJK UNIFIED IDEOGRAPH
  {0xDBDA, 0x67CF}, //13816 #CJK UNIFIED IDEOGRAPH
  {0xDBDB, 0x6822}, //13817 #CJK UNIFIED IDEOGRAPH
  {0xDBDC, 0x767D}, //13818 #CJK UNIFIED IDEOGRAPH
  {0xDBDD, 0x767E}, //13819 #CJK UNIFIED IDEOGRAPH
  {0xDBDE, 0x9B44}, //13820 #CJK UNIFIED IDEOGRAPH
  {0xDBDF, 0x5E61}, //13821 #CJK UNIFIED IDEOGRAPH
  {0xDBE0, 0x6A0A}, //13822 #CJK UNIFIED IDEOGRAPH
  {0xDBE1, 0x7169}, //13823 #CJK UNIFIED IDEOGRAPH
  {0xDBE2, 0x71D4}, //13824 #CJK UNIFIED IDEOGRAPH
  {0xDBE3, 0x756A}, //13825 #CJK UNIFIED IDEOGRAPH
  {0xDBE4, 0xF964}, //13826 #CJK COMPATIBILITY IDEOGRAPH
  {0xDBE5, 0x7E41}, //13827 #CJK UNIFIED IDEOGRAPH
  {0xDBE6, 0x8543}, //13828 #CJK UNIFIED IDEOGRAPH
  {0xDBE7, 0x85E9}, //13829 #CJK UNIFIED IDEOGRAPH
  {0xDBE8, 0x98DC}, //13830 #CJK UNIFIED IDEOGRAPH
  {0xDBE9, 0x4F10}, //13831 #CJK UNIFIED IDEOGRAPH
  {0xDBEA, 0x7B4F}, //13832 #CJK UNIFIED IDEOGRAPH
  {0xDBEB, 0x7F70}, //13833 #CJK UNIFIED IDEOGRAPH
  {0xDBEC, 0x95A5}, //13834 #CJK UNIFIED IDEOGRAPH
  {0xDBED, 0x51E1}, //13835 #CJK UNIFIED IDEOGRAPH
  {0xDBEE, 0x5E06}, //13836 #CJK UNIFIED IDEOGRAPH
  {0xDBEF, 0x68B5}, //13837 #CJK UNIFIED IDEOGRAPH
  {0xDBF0, 0x6C3E}, //13838 #CJK UNIFIED IDEOGRAPH
  {0xDBF1, 0x6C4E}, //13839 #CJK UNIFIED IDEOGRAPH
  {0xDBF2, 0x6CDB}, //13840 #CJK UNIFIED IDEOGRAPH
  {0xDBF3, 0x72AF}, //13841 #CJK UNIFIED IDEOGRAPH
  {0xDBF4, 0x7BC4}, //13842 #CJK UNIFIED IDEOGRAPH
  {0xDBF5, 0x8303}, //13843 #CJK UNIFIED IDEOGRAPH
  {0xDBF6, 0x6CD5}, //13844 #CJK UNIFIED IDEOGRAPH
  {0xDBF7, 0x743A}, //13845 #CJK UNIFIED IDEOGRAPH
  {0xDBF8, 0x50FB}, //13846 #CJK UNIFIED IDEOGRAPH
  {0xDBF9, 0x5288}, //13847 #CJK UNIFIED IDEOGRAPH
  {0xDBFA, 0x58C1}, //13848 #CJK UNIFIED IDEOGRAPH
  {0xDBFB, 0x64D8}, //13849 #CJK UNIFIED IDEOGRAPH
  {0xDBFC, 0x6A97}, //13850 #CJK UNIFIED IDEOGRAPH
  {0xDBFD, 0x74A7}, //13851 #CJK UNIFIED IDEOGRAPH
  {0xDBFE, 0x7656}, //13852 #CJK UNIFIED IDEOGRAPH
  {0xDCA1, 0x78A7}, //13853 #CJK UNIFIED IDEOGRAPH
  {0xDCA2, 0x8617}, //13854 #CJK UNIFIED IDEOGRAPH
  {0xDCA3, 0x95E2}, //13855 #CJK UNIFIED IDEOGRAPH
  {0xDCA4, 0x9739}, //13856 #CJK UNIFIED IDEOGRAPH
  {0xDCA5, 0xF965}, //13857 #CJK COMPATIBILITY IDEOGRAPH
  {0xDCA6, 0x535E}, //13858 #CJK UNIFIED IDEOGRAPH
  {0xDCA7, 0x5F01}, //13859 #CJK UNIFIED IDEOGRAPH
  {0xDCA8, 0x8B8A}, //13860 #CJK UNIFIED IDEOGRAPH
  {0xDCA9, 0x8FA8}, //13861 #CJK UNIFIED IDEOGRAPH
  {0xDCAA, 0x8FAF}, //13862 #CJK UNIFIED IDEOGRAPH
  {0xDCAB, 0x908A}, //13863 #CJK UNIFIED IDEOGRAPH
  {0xDCAC, 0x5225}, //13864 #CJK UNIFIED IDEOGRAPH
  {0xDCAD, 0x77A5}, //13865 #CJK UNIFIED IDEOGRAPH
  {0xDCAE, 0x9C49}, //13866 #CJK UNIFIED IDEOGRAPH
  {0xDCAF, 0x9F08}, //13867 #CJK UNIFIED IDEOGRAPH
  {0xDCB0, 0x4E19}, //13868 #CJK UNIFIED IDEOGRAPH
  {0xDCB1, 0x5002}, //13869 #CJK UNIFIED IDEOGRAPH
  {0xDCB2, 0x5175}, //13870 #CJK UNIFIED IDEOGRAPH
  {0xDCB3, 0x5C5B}, //13871 #CJK UNIFIED IDEOGRAPH
  {0xDCB4, 0x5E77}, //13872 #CJK UNIFIED IDEOGRAPH
  {0xDCB5, 0x661E}, //13873 #CJK UNIFIED IDEOGRAPH
  {0xDCB6, 0x663A}, //13874 #CJK UNIFIED IDEOGRAPH
  {0xDCB7, 0x67C4}, //13875 #CJK UNIFIED IDEOGRAPH
  {0xDCB8, 0x68C5}, //13876 #CJK UNIFIED IDEOGRAPH
  {0xDCB9, 0x70B3}, //13877 #CJK UNIFIED IDEOGRAPH
  {0xDCBA, 0x7501}, //13878 #CJK UNIFIED IDEOGRAPH
  {0xDCBB, 0x75C5}, //13879 #CJK UNIFIED IDEOGRAPH
  {0xDCBC, 0x79C9}, //13880 #CJK UNIFIED IDEOGRAPH
  {0xDCBD, 0x7ADD}, //13881 #CJK UNIFIED IDEOGRAPH
  {0xDCBE, 0x8F27}, //13882 #CJK UNIFIED IDEOGRAPH
  {0xDCBF, 0x9920}, //13883 #CJK UNIFIED IDEOGRAPH
  {0xDCC0, 0x9A08}, //13884 #CJK UNIFIED IDEOGRAPH
  {0xDCC1, 0x4FDD}, //13885 #CJK UNIFIED IDEOGRAPH
  {0xDCC2, 0x5821}, //13886 #CJK UNIFIED IDEOGRAPH
  {0xDCC3, 0x5831}, //13887 #CJK UNIFIED IDEOGRAPH
  {0xDCC4, 0x5BF6}, //13888 #CJK UNIFIED IDEOGRAPH
  {0xDCC5, 0x666E}, //13889 #CJK UNIFIED IDEOGRAPH
  {0xDCC6, 0x6B65}, //13890 #CJK UNIFIED IDEOGRAPH
  {0xDCC7, 0x6D11}, //13891 #CJK UNIFIED IDEOGRAPH
  {0xDCC8, 0x6E7A}, //13892 #CJK UNIFIED IDEOGRAPH
  {0xDCC9, 0x6F7D}, //13893 #CJK UNIFIED IDEOGRAPH
  {0xDCCA, 0x73E4}, //13894 #CJK UNIFIED IDEOGRAPH
  {0xDCCB, 0x752B}, //13895 #CJK UNIFIED IDEOGRAPH
  {0xDCCC, 0x83E9}, //13896 #CJK UNIFIED IDEOGRAPH
  {0xDCCD, 0x88DC}, //13897 #CJK UNIFIED IDEOGRAPH
  {0xDCCE, 0x8913}, //13898 #CJK UNIFIED IDEOGRAPH
  {0xDCCF, 0x8B5C}, //13899 #CJK UNIFIED IDEOGRAPH
  {0xDCD0, 0x8F14}, //13900 #CJK UNIFIED IDEOGRAPH
  {0xDCD1, 0x4F0F}, //13901 #CJK UNIFIED IDEOGRAPH
  {0xDCD2, 0x50D5}, //13902 #CJK UNIFIED IDEOGRAPH
  {0xDCD3, 0x5310}, //13903 #CJK UNIFIED IDEOGRAPH
  {0xDCD4, 0x535C}, //13904 #CJK UNIFIED IDEOGRAPH
  {0xDCD5, 0x5B93}, //13905 #CJK UNIFIED IDEOGRAPH
  {0xDCD6, 0x5FA9}, //13906 #CJK UNIFIED IDEOGRAPH
  {0xDCD7, 0x670D}, //13907 #CJK UNIFIED IDEOGRAPH
  {0xDCD8, 0x798F}, //13908 #CJK UNIFIED IDEOGRAPH
  {0xDCD9, 0x8179}, //13909 #CJK UNIFIED IDEOGRAPH
  {0xDCDA, 0x832F}, //13910 #CJK UNIFIED IDEOGRAPH
  {0xDCDB, 0x8514}, //13911 #CJK UNIFIED IDEOGRAPH
  {0xDCDC, 0x8907}, //13912 #CJK UNIFIED IDEOGRAPH
  {0xDCDD, 0x8986}, //13913 #CJK UNIFIED IDEOGRAPH
  {0xDCDE, 0x8F39}, //13914 #CJK UNIFIED IDEOGRAPH
  {0xDCDF, 0x8F3B}, //13915 #CJK UNIFIED IDEOGRAPH
  {0xDCE0, 0x99A5}, //13916 #CJK UNIFIED IDEOGRAPH
  {0xDCE1, 0x9C12}, //13917 #CJK UNIFIED IDEOGRAPH
  {0xDCE2, 0x672C}, //13918 #CJK UNIFIED IDEOGRAPH
  {0xDCE3, 0x4E76}, //13919 #CJK UNIFIED IDEOGRAPH
  {0xDCE4, 0x4FF8}, //13920 #CJK UNIFIED IDEOGRAPH
  {0xDCE5, 0x5949}, //13921 #CJK UNIFIED IDEOGRAPH
  {0xDCE6, 0x5C01}, //13922 #CJK UNIFIED IDEOGRAPH
  {0xDCE7, 0x5CEF}, //13923 #CJK UNIFIED IDEOGRAPH
  {0xDCE8, 0x5CF0}, //13924 #CJK UNIFIED IDEOGRAPH
  {0xDCE9, 0x6367}, //13925 #CJK UNIFIED IDEOGRAPH
  {0xDCEA, 0x68D2}, //13926 #CJK UNIFIED IDEOGRAPH
  {0xDCEB, 0x70FD}, //13927 #CJK UNIFIED IDEOGRAPH
  {0xDCEC, 0x71A2}, //13928 #CJK UNIFIED IDEOGRAPH
  {0xDCED, 0x742B}, //13929 #CJK UNIFIED IDEOGRAPH
  {0xDCEE, 0x7E2B}, //13930 #CJK UNIFIED IDEOGRAPH
  {0xDCEF, 0x84EC}, //13931 #CJK UNIFIED IDEOGRAPH
  {0xDCF0, 0x8702}, //13932 #CJK UNIFIED IDEOGRAPH
  {0xDCF1, 0x9022}, //13933 #CJK UNIFIED IDEOGRAPH
  {0xDCF2, 0x92D2}, //13934 #CJK UNIFIED IDEOGRAPH
  {0xDCF3, 0x9CF3}, //13935 #CJK UNIFIED IDEOGRAPH
  {0xDCF4, 0x4E0D}, //13936 #CJK UNIFIED IDEOGRAPH
  {0xDCF5, 0x4ED8}, //13937 #CJK UNIFIED IDEOGRAPH
  {0xDCF6, 0x4FEF}, //13938 #CJK UNIFIED IDEOGRAPH
  {0xDCF7, 0x5085}, //13939 #CJK UNIFIED IDEOGRAPH
  {0xDCF8, 0x5256}, //13940 #CJK UNIFIED IDEOGRAPH
  {0xDCF9, 0x526F}, //13941 #CJK UNIFIED IDEOGRAPH
  {0xDCFA, 0x5426}, //13942 #CJK UNIFIED IDEOGRAPH
  {0xDCFB, 0x5490}, //13943 #CJK UNIFIED IDEOGRAPH
  {0xDCFC, 0x57E0}, //13944 #CJK UNIFIED IDEOGRAPH
  {0xDCFD, 0x592B}, //13945 #CJK UNIFIED IDEOGRAPH
  {0xDCFE, 0x5A66}, //13946 #CJK UNIFIED IDEOGRAPH
  {0xDDA1, 0x5B5A}, //13947 #CJK UNIFIED IDEOGRAPH
  {0xDDA2, 0x5B75}, //13948 #CJK UNIFIED IDEOGRAPH
  {0xDDA3, 0x5BCC}, //13949 #CJK UNIFIED IDEOGRAPH
  {0xDDA4, 0x5E9C}, //13950 #CJK UNIFIED IDEOGRAPH
  {0xDDA5, 0xF966}, //13951 #CJK COMPATIBILITY IDEOGRAPH
  {0xDDA6, 0x6276}, //13952 #CJK UNIFIED IDEOGRAPH
  {0xDDA7, 0x6577}, //13953 #CJK UNIFIED IDEOGRAPH
  {0xDDA8, 0x65A7}, //13954 #CJK UNIFIED IDEOGRAPH
  {0xDDA9, 0x6D6E}, //13955 #CJK UNIFIED IDEOGRAPH
  {0xDDAA, 0x6EA5}, //13956 #CJK UNIFIED IDEOGRAPH
  {0xDDAB, 0x7236}, //13957 #CJK UNIFIED IDEOGRAPH
  {0xDDAC, 0x7B26}, //13958 #CJK UNIFIED IDEOGRAPH
  {0xDDAD, 0x7C3F}, //13959 #CJK UNIFIED IDEOGRAPH
  {0xDDAE, 0x7F36}, //13960 #CJK UNIFIED IDEOGRAPH
  {0xDDAF, 0x8150}, //13961 #CJK UNIFIED IDEOGRAPH
  {0xDDB0, 0x8151}, //13962 #CJK UNIFIED IDEOGRAPH
  {0xDDB1, 0x819A}, //13963 #CJK UNIFIED IDEOGRAPH
  {0xDDB2, 0x8240}, //13964 #CJK UNIFIED IDEOGRAPH
  {0xDDB3, 0x8299}, //13965 #CJK UNIFIED IDEOGRAPH
  {0xDDB4, 0x83A9}, //13966 #CJK UNIFIED IDEOGRAPH
  {0xDDB5, 0x8A03}, //13967 #CJK UNIFIED IDEOGRAPH
  {0xDDB6, 0x8CA0}, //13968 #CJK UNIFIED IDEOGRAPH
  {0xDDB7, 0x8CE6}, //13969 #CJK UNIFIED IDEOGRAPH
  {0xDDB8, 0x8CFB}, //13970 #CJK UNIFIED IDEOGRAPH
  {0xDDB9, 0x8D74}, //13971 #CJK UNIFIED IDEOGRAPH
  {0xDDBA, 0x8DBA}, //13972 #CJK UNIFIED IDEOGRAPH
  {0xDDBB, 0x90E8}, //13973 #CJK UNIFIED IDEOGRAPH
  {0xDDBC, 0x91DC}, //13974 #CJK UNIFIED IDEOGRAPH
  {0xDDBD, 0x961C}, //13975 #CJK UNIFIED IDEOGRAPH
  {0xDDBE, 0x9644}, //13976 #CJK UNIFIED IDEOGRAPH
  {0xDDBF, 0x99D9}, //13977 #CJK UNIFIED IDEOGRAPH
  {0xDDC0, 0x9CE7}, //13978 #CJK UNIFIED IDEOGRAPH
  {0xDDC1, 0x5317}, //13979 #CJK UNIFIED IDEOGRAPH
  {0xDDC2, 0x5206}, //13980 #CJK UNIFIED IDEOGRAPH
  {0xDDC3, 0x5429}, //13981 #CJK UNIFIED IDEOGRAPH
  {0xDDC4, 0x5674}, //13982 #CJK UNIFIED IDEOGRAPH
  {0xDDC5, 0x58B3}, //13983 #CJK UNIFIED IDEOGRAPH
  {0xDDC6, 0x5954}, //13984 #CJK UNIFIED IDEOGRAPH
  {0xDDC7, 0x596E}, //13985 #CJK UNIFIED IDEOGRAPH
  {0xDDC8, 0x5FFF}, //13986 #CJK UNIFIED IDEOGRAPH
  {0xDDC9, 0x61A4}, //13987 #CJK UNIFIED IDEOGRAPH
  {0xDDCA, 0x626E}, //13988 #CJK UNIFIED IDEOGRAPH
  {0xDDCB, 0x6610}, //13989 #CJK UNIFIED IDEOGRAPH
  {0xDDCC, 0x6C7E}, //13990 #CJK UNIFIED IDEOGRAPH
  {0xDDCD, 0x711A}, //13991 #CJK UNIFIED IDEOGRAPH
  {0xDDCE, 0x76C6}, //13992 #CJK UNIFIED IDEOGRAPH
  {0xDDCF, 0x7C89}, //13993 #CJK UNIFIED IDEOGRAPH
  {0xDDD0, 0x7CDE}, //13994 #CJK UNIFIED IDEOGRAPH
  {0xDDD1, 0x7D1B}, //13995 #CJK UNIFIED IDEOGRAPH
  {0xDDD2, 0x82AC}, //13996 #CJK UNIFIED IDEOGRAPH
  {0xDDD3, 0x8CC1}, //13997 #CJK UNIFIED IDEOGRAPH
  {0xDDD4, 0x96F0}, //13998 #CJK UNIFIED IDEOGRAPH
  {0xDDD5, 0xF967}, //13999 #CJK COMPATIBILITY IDEOGRAPH
  {0xDDD6, 0x4F5B}, //14000 #CJK UNIFIED IDEOGRAPH
  {0xDDD7, 0x5F17}, //14001 #CJK UNIFIED IDEOGRAPH
  {0xDDD8, 0x5F7F}, //14002 #CJK UNIFIED IDEOGRAPH
  {0xDDD9, 0x62C2}, //14003 #CJK UNIFIED IDEOGRAPH
  {0xDDDA, 0x5D29}, //14004 #CJK UNIFIED IDEOGRAPH
  {0xDDDB, 0x670B}, //14005 #CJK UNIFIED IDEOGRAPH
  {0xDDDC, 0x68DA}, //14006 #CJK UNIFIED IDEOGRAPH
  {0xDDDD, 0x787C}, //14007 #CJK UNIFIED IDEOGRAPH
  {0xDDDE, 0x7E43}, //14008 #CJK UNIFIED IDEOGRAPH
  {0xDDDF, 0x9D6C}, //14009 #CJK UNIFIED IDEOGRAPH
  {0xDDE0, 0x4E15}, //14010 #CJK UNIFIED IDEOGRAPH
  {0xDDE1, 0x5099}, //14011 #CJK UNIFIED IDEOGRAPH
  {0xDDE2, 0x5315}, //14012 #CJK UNIFIED IDEOGRAPH
  {0xDDE3, 0x532A}, //14013 #CJK UNIFIED IDEOGRAPH
  {0xDDE4, 0x5351}, //14014 #CJK UNIFIED IDEOGRAPH
  {0xDDE5, 0x5983}, //14015 #CJK UNIFIED IDEOGRAPH
  {0xDDE6, 0x5A62}, //14016 #CJK UNIFIED IDEOGRAPH
  {0xDDE7, 0x5E87}, //14017 #CJK UNIFIED IDEOGRAPH
  {0xDDE8, 0x60B2}, //14018 #CJK UNIFIED IDEOGRAPH
  {0xDDE9, 0x618A}, //14019 #CJK UNIFIED IDEOGRAPH
  {0xDDEA, 0x6249}, //14020 #CJK UNIFIED IDEOGRAPH
  {0xDDEB, 0x6279}, //14021 #CJK UNIFIED IDEOGRAPH
  {0xDDEC, 0x6590}, //14022 #CJK UNIFIED IDEOGRAPH
  {0xDDED, 0x6787}, //14023 #CJK UNIFIED IDEOGRAPH
  {0xDDEE, 0x69A7}, //14024 #CJK UNIFIED IDEOGRAPH
  {0xDDEF, 0x6BD4}, //14025 #CJK UNIFIED IDEOGRAPH
  {0xDDF0, 0x6BD6}, //14026 #CJK UNIFIED IDEOGRAPH
  {0xDDF1, 0x6BD7}, //14027 #CJK UNIFIED IDEOGRAPH
  {0xDDF2, 0x6BD8}, //14028 #CJK UNIFIED IDEOGRAPH
  {0xDDF3, 0x6CB8}, //14029 #CJK UNIFIED IDEOGRAPH
  {0xDDF4, 0xF968}, //14030 #CJK COMPATIBILITY IDEOGRAPH
  {0xDDF5, 0x7435}, //14031 #CJK UNIFIED IDEOGRAPH
  {0xDDF6, 0x75FA}, //14032 #CJK UNIFIED IDEOGRAPH
  {0xDDF7, 0x7812}, //14033 #CJK UNIFIED IDEOGRAPH
  {0xDDF8, 0x7891}, //14034 #CJK UNIFIED IDEOGRAPH
  {0xDDF9, 0x79D5}, //14035 #CJK UNIFIED IDEOGRAPH
  {0xDDFA, 0x79D8}, //14036 #CJK UNIFIED IDEOGRAPH
  {0xDDFB, 0x7C83}, //14037 #CJK UNIFIED IDEOGRAPH
  {0xDDFC, 0x7DCB}, //14038 #CJK UNIFIED IDEOGRAPH
  {0xDDFD, 0x7FE1}, //14039 #CJK UNIFIED IDEOGRAPH
  {0xDDFE, 0x80A5}, //14040 #CJK UNIFIED IDEOGRAPH
  {0xDEA1, 0x813E}, //14041 #CJK UNIFIED IDEOGRAPH
  {0xDEA2, 0x81C2}, //14042 #CJK UNIFIED IDEOGRAPH
  {0xDEA3, 0x83F2}, //14043 #CJK UNIFIED IDEOGRAPH
  {0xDEA4, 0x871A}, //14044 #CJK UNIFIED IDEOGRAPH
  {0xDEA5, 0x88E8}, //14045 #CJK UNIFIED IDEOGRAPH
  {0xDEA6, 0x8AB9}, //14046 #CJK UNIFIED IDEOGRAPH
  {0xDEA7, 0x8B6C}, //14047 #CJK UNIFIED IDEOGRAPH
  {0xDEA8, 0x8CBB}, //14048 #CJK UNIFIED IDEOGRAPH
  {0xDEA9, 0x9119}, //14049 #CJK UNIFIED IDEOGRAPH
  {0xDEAA, 0x975E}, //14050 #CJK UNIFIED IDEOGRAPH
  {0xDEAB, 0x98DB}, //14051 #CJK UNIFIED IDEOGRAPH
  {0xDEAC, 0x9F3B}, //14052 #CJK UNIFIED IDEOGRAPH
  {0xDEAD, 0x56AC}, //14053 #CJK UNIFIED IDEOGRAPH
  {0xDEAE, 0x5B2A}, //14054 #CJK UNIFIED IDEOGRAPH
  {0xDEAF, 0x5F6C}, //14055 #CJK UNIFIED IDEOGRAPH
  {0xDEB0, 0x658C}, //14056 #CJK UNIFIED IDEOGRAPH
  {0xDEB1, 0x6AB3}, //14057 #CJK UNIFIED IDEOGRAPH
  {0xDEB2, 0x6BAF}, //14058 #CJK UNIFIED IDEOGRAPH
  {0xDEB3, 0x6D5C}, //14059 #CJK UNIFIED IDEOGRAPH
  {0xDEB4, 0x6FF1}, //14060 #CJK UNIFIED IDEOGRAPH
  {0xDEB5, 0x7015}, //14061 #CJK UNIFIED IDEOGRAPH
  {0xDEB6, 0x725D}, //14062 #CJK UNIFIED IDEOGRAPH
  {0xDEB7, 0x73AD}, //14063 #CJK UNIFIED IDEOGRAPH
  {0xDEB8, 0x8CA7}, //14064 #CJK UNIFIED IDEOGRAPH
  {0xDEB9, 0x8CD3}, //14065 #CJK UNIFIED IDEOGRAPH
  {0xDEBA, 0x983B}, //14066 #CJK UNIFIED IDEOGRAPH
  {0xDEBB, 0x6191}, //14067 #CJK UNIFIED IDEOGRAPH
  {0xDEBC, 0x6C37}, //14068 #CJK UNIFIED IDEOGRAPH
  {0xDEBD, 0x8058}, //14069 #CJK UNIFIED IDEOGRAPH
  {0xDEBE, 0x9A01}, //14070 #CJK UNIFIED IDEOGRAPH
  {0xDEBF, 0x4E4D}, //14071 #CJK UNIFIED IDEOGRAPH
  {0xDEC0, 0x4E8B}, //14072 #CJK UNIFIED IDEOGRAPH
  {0xDEC1, 0x4E9B}, //14073 #CJK UNIFIED IDEOGRAPH
  {0xDEC2, 0x4ED5}, //14074 #CJK UNIFIED IDEOGRAPH
  {0xDEC3, 0x4F3A}, //14075 #CJK UNIFIED IDEOGRAPH
  {0xDEC4, 0x4F3C}, //14076 #CJK UNIFIED IDEOGRAPH
  {0xDEC5, 0x4F7F}, //14077 #CJK UNIFIED IDEOGRAPH
  {0xDEC6, 0x4FDF}, //14078 #CJK UNIFIED IDEOGRAPH
  {0xDEC7, 0x50FF}, //14079 #CJK UNIFIED IDEOGRAPH
  {0xDEC8, 0x53F2}, //14080 #CJK UNIFIED IDEOGRAPH
  {0xDEC9, 0x53F8}, //14081 #CJK UNIFIED IDEOGRAPH
  {0xDECA, 0x5506}, //14082 #CJK UNIFIED IDEOGRAPH
  {0xDECB, 0x55E3}, //14083 #CJK UNIFIED IDEOGRAPH
  {0xDECC, 0x56DB}, //14084 #CJK UNIFIED IDEOGRAPH
  {0xDECD, 0x58EB}, //14085 #CJK UNIFIED IDEOGRAPH
  {0xDECE, 0x5962}, //14086 #CJK UNIFIED IDEOGRAPH
  {0xDECF, 0x5A11}, //14087 #CJK UNIFIED IDEOGRAPH
  {0xDED0, 0x5BEB}, //14088 #CJK UNIFIED IDEOGRAPH
  {0xDED1, 0x5BFA}, //14089 #CJK UNIFIED IDEOGRAPH
  {0xDED2, 0x5C04}, //14090 #CJK UNIFIED IDEOGRAPH
  {0xDED3, 0x5DF3}, //14091 #CJK UNIFIED IDEOGRAPH
  {0xDED4, 0x5E2B}, //14092 #CJK UNIFIED IDEOGRAPH
  {0xDED5, 0x5F99}, //14093 #CJK UNIFIED IDEOGRAPH
  {0xDED6, 0x601D}, //14094 #CJK UNIFIED IDEOGRAPH
  {0xDED7, 0x6368}, //14095 #CJK UNIFIED IDEOGRAPH
  {0xDED8, 0x659C}, //14096 #CJK UNIFIED IDEOGRAPH
  {0xDED9, 0x65AF}, //14097 #CJK UNIFIED IDEOGRAPH
  {0xDEDA, 0x67F6}, //14098 #CJK UNIFIED IDEOGRAPH
  {0xDEDB, 0x67FB}, //14099 #CJK UNIFIED IDEOGRAPH
  {0xDEDC, 0x68AD}, //14100 #CJK UNIFIED IDEOGRAPH
  {0xDEDD, 0x6B7B}, //14101 #CJK UNIFIED IDEOGRAPH
  {0xDEDE, 0x6C99}, //14102 #CJK UNIFIED IDEOGRAPH
  {0xDEDF, 0x6CD7}, //14103 #CJK UNIFIED IDEOGRAPH
  {0xDEE0, 0x6E23}, //14104 #CJK UNIFIED IDEOGRAPH
  {0xDEE1, 0x7009}, //14105 #CJK UNIFIED IDEOGRAPH
  {0xDEE2, 0x7345}, //14106 #CJK UNIFIED IDEOGRAPH
  {0xDEE3, 0x7802}, //14107 #CJK UNIFIED IDEOGRAPH
  {0xDEE4, 0x793E}, //14108 #CJK UNIFIED IDEOGRAPH
  {0xDEE5, 0x7940}, //14109 #CJK UNIFIED IDEOGRAPH
  {0xDEE6, 0x7960}, //14110 #CJK UNIFIED IDEOGRAPH
  {0xDEE7, 0x79C1}, //14111 #CJK UNIFIED IDEOGRAPH
  {0xDEE8, 0x7BE9}, //14112 #CJK UNIFIED IDEOGRAPH
  {0xDEE9, 0x7D17}, //14113 #CJK UNIFIED IDEOGRAPH
  {0xDEEA, 0x7D72}, //14114 #CJK UNIFIED IDEOGRAPH
  {0xDEEB, 0x8086}, //14115 #CJK UNIFIED IDEOGRAPH
  {0xDEEC, 0x820D}, //14116 #CJK UNIFIED IDEOGRAPH
  {0xDEED, 0x838E}, //14117 #CJK UNIFIED IDEOGRAPH
  {0xDEEE, 0x84D1}, //14118 #CJK UNIFIED IDEOGRAPH
  {0xDEEF, 0x86C7}, //14119 #CJK UNIFIED IDEOGRAPH
  {0xDEF0, 0x88DF}, //14120 #CJK UNIFIED IDEOGRAPH
  {0xDEF1, 0x8A50}, //14121 #CJK UNIFIED IDEOGRAPH
  {0xDEF2, 0x8A5E}, //14122 #CJK UNIFIED IDEOGRAPH
  {0xDEF3, 0x8B1D}, //14123 #CJK UNIFIED IDEOGRAPH
  {0xDEF4, 0x8CDC}, //14124 #CJK UNIFIED IDEOGRAPH
  {0xDEF5, 0x8D66}, //14125 #CJK UNIFIED IDEOGRAPH
  {0xDEF6, 0x8FAD}, //14126 #CJK UNIFIED IDEOGRAPH
  {0xDEF7, 0x90AA}, //14127 #CJK UNIFIED IDEOGRAPH
  {0xDEF8, 0x98FC}, //14128 #CJK UNIFIED IDEOGRAPH
  {0xDEF9, 0x99DF}, //14129 #CJK UNIFIED IDEOGRAPH
  {0xDEFA, 0x9E9D}, //14130 #CJK UNIFIED IDEOGRAPH
  {0xDEFB, 0x524A}, //14131 #CJK UNIFIED IDEOGRAPH
  {0xDEFC, 0xF969}, //14132 #CJK COMPATIBILITY IDEOGRAPH
  {0xDEFD, 0x6714}, //14133 #CJK UNIFIED IDEOGRAPH
  {0xDEFE, 0xF96A}, //14134 #CJK COMPATIBILITY IDEOGRAPH
  {0xDFA1, 0x5098}, //14135 #CJK UNIFIED IDEOGRAPH
  {0xDFA2, 0x522A}, //14136 #CJK UNIFIED IDEOGRAPH
  {0xDFA3, 0x5C71}, //14137 #CJK UNIFIED IDEOGRAPH
  {0xDFA4, 0x6563}, //14138 #CJK UNIFIED IDEOGRAPH
  {0xDFA5, 0x6C55}, //14139 #CJK UNIFIED IDEOGRAPH
  {0xDFA6, 0x73CA}, //14140 #CJK UNIFIED IDEOGRAPH
  {0xDFA7, 0x7523}, //14141 #CJK UNIFIED IDEOGRAPH
  {0xDFA8, 0x759D}, //14142 #CJK UNIFIED IDEOGRAPH
  {0xDFA9, 0x7B97}, //14143 #CJK UNIFIED IDEOGRAPH
  {0xDFAA, 0x849C}, //14144 #CJK UNIFIED IDEOGRAPH
  {0xDFAB, 0x9178}, //14145 #CJK UNIFIED IDEOGRAPH
  {0xDFAC, 0x9730}, //14146 #CJK UNIFIED IDEOGRAPH
  {0xDFAD, 0x4E77}, //14147 #CJK UNIFIED IDEOGRAPH
  {0xDFAE, 0x6492}, //14148 #CJK UNIFIED IDEOGRAPH
  {0xDFAF, 0x6BBA}, //14149 #CJK UNIFIED IDEOGRAPH
  {0xDFB0, 0x715E}, //14150 #CJK UNIFIED IDEOGRAPH
  {0xDFB1, 0x85A9}, //14151 #CJK UNIFIED IDEOGRAPH
  {0xDFB2, 0x4E09}, //14152 #CJK UNIFIED IDEOGRAPH
  {0xDFB3, 0xF96B}, //14153 #CJK COMPATIBILITY IDEOGRAPH
  {0xDFB4, 0x6749}, //14154 #CJK UNIFIED IDEOGRAPH
  {0xDFB5, 0x68EE}, //14155 #CJK UNIFIED IDEOGRAPH
  {0xDFB6, 0x6E17}, //14156 #CJK UNIFIED IDEOGRAPH
  {0xDFB7, 0x829F}, //14157 #CJK UNIFIED IDEOGRAPH
  {0xDFB8, 0x8518}, //14158 #CJK UNIFIED IDEOGRAPH
  {0xDFB9, 0x886B}, //14159 #CJK UNIFIED IDEOGRAPH
  {0xDFBA, 0x63F7}, //14160 #CJK UNIFIED IDEOGRAPH
  {0xDFBB, 0x6F81}, //14161 #CJK UNIFIED IDEOGRAPH
  {0xDFBC, 0x9212}, //14162 #CJK UNIFIED IDEOGRAPH
  {0xDFBD, 0x98AF}, //14163 #CJK UNIFIED IDEOGRAPH
  {0xDFBE, 0x4E0A}, //14164 #CJK UNIFIED IDEOGRAPH
  {0xDFBF, 0x50B7}, //14165 #CJK UNIFIED IDEOGRAPH
  {0xDFC0, 0x50CF}, //14166 #CJK UNIFIED IDEOGRAPH
  {0xDFC1, 0x511F}, //14167 #CJK UNIFIED IDEOGRAPH
  {0xDFC2, 0x5546}, //14168 #CJK UNIFIED IDEOGRAPH
  {0xDFC3, 0x55AA}, //14169 #CJK UNIFIED IDEOGRAPH
  {0xDFC4, 0x5617}, //14170 #CJK UNIFIED IDEOGRAPH
  {0xDFC5, 0x5B40}, //14171 #CJK UNIFIED IDEOGRAPH
  {0xDFC6, 0x5C19}, //14172 #CJK UNIFIED IDEOGRAPH
  {0xDFC7, 0x5CE0}, //14173 #CJK UNIFIED IDEOGRAPH
  {0xDFC8, 0x5E38}, //14174 #CJK UNIFIED IDEOGRAPH
  {0xDFC9, 0x5E8A}, //14175 #CJK UNIFIED IDEOGRAPH
  {0xDFCA, 0x5EA0}, //14176 #CJK UNIFIED IDEOGRAPH
  {0xDFCB, 0x5EC2}, //14177 #CJK UNIFIED IDEOGRAPH
  {0xDFCC, 0x60F3}, //14178 #CJK UNIFIED IDEOGRAPH
  {0xDFCD, 0x6851}, //14179 #CJK UNIFIED IDEOGRAPH
  {0xDFCE, 0x6A61}, //14180 #CJK UNIFIED IDEOGRAPH
  {0xDFCF, 0x6E58}, //14181 #CJK UNIFIED IDEOGRAPH
  {0xDFD0, 0x723D}, //14182 #CJK UNIFIED IDEOGRAPH
  {0xDFD1, 0x7240}, //14183 #CJK UNIFIED IDEOGRAPH
  {0xDFD2, 0x72C0}, //14184 #CJK UNIFIED IDEOGRAPH
  {0xDFD3, 0x76F8}, //14185 #CJK UNIFIED IDEOGRAPH
  {0xDFD4, 0x7965}, //14186 #CJK UNIFIED IDEOGRAPH
  {0xDFD5, 0x7BB1}, //14187 #CJK UNIFIED IDEOGRAPH
  {0xDFD6, 0x7FD4}, //14188 #CJK UNIFIED IDEOGRAPH
  {0xDFD7, 0x88F3}, //14189 #CJK UNIFIED IDEOGRAPH
  {0xDFD8, 0x89F4}, //14190 #CJK UNIFIED IDEOGRAPH
  {0xDFD9, 0x8A73}, //14191 #CJK UNIFIED IDEOGRAPH
  {0xDFDA, 0x8C61}, //14192 #CJK UNIFIED IDEOGRAPH
  {0xDFDB, 0x8CDE}, //14193 #CJK UNIFIED IDEOGRAPH
  {0xDFDC, 0x971C}, //14194 #CJK UNIFIED IDEOGRAPH
  {0xDFDD, 0x585E}, //14195 #CJK UNIFIED IDEOGRAPH
  {0xDFDE, 0x74BD}, //14196 #CJK UNIFIED IDEOGRAPH
  {0xDFDF, 0x8CFD}, //14197 #CJK UNIFIED IDEOGRAPH
  {0xDFE0, 0x55C7}, //14198 #CJK UNIFIED IDEOGRAPH
  {0xDFE1, 0xF96C}, //14199 #CJK COMPATIBILITY IDEOGRAPH
  {0xDFE2, 0x7A61}, //14200 #CJK UNIFIED IDEOGRAPH
  {0xDFE3, 0x7D22}, //14201 #CJK UNIFIED IDEOGRAPH
  {0xDFE4, 0x8272}, //14202 #CJK UNIFIED IDEOGRAPH
  {0xDFE5, 0x7272}, //14203 #CJK UNIFIED IDEOGRAPH
  {0xDFE6, 0x751F}, //14204 #CJK UNIFIED IDEOGRAPH
  {0xDFE7, 0x7525}, //14205 #CJK UNIFIED IDEOGRAPH
  {0xDFE8, 0xF96D}, //14206 #CJK COMPATIBILITY IDEOGRAPH
  {0xDFE9, 0x7B19}, //14207 #CJK UNIFIED IDEOGRAPH
  {0xDFEA, 0x5885}, //14208 #CJK UNIFIED IDEOGRAPH
  {0xDFEB, 0x58FB}, //14209 #CJK UNIFIED IDEOGRAPH
  {0xDFEC, 0x5DBC}, //14210 #CJK UNIFIED IDEOGRAPH
  {0xDFED, 0x5E8F}, //14211 #CJK UNIFIED IDEOGRAPH
  {0xDFEE, 0x5EB6}, //14212 #CJK UNIFIED IDEOGRAPH
  {0xDFEF, 0x5F90}, //14213 #CJK UNIFIED IDEOGRAPH
  {0xDFF0, 0x6055}, //14214 #CJK UNIFIED IDEOGRAPH
  {0xDFF1, 0x6292}, //14215 #CJK UNIFIED IDEOGRAPH
  {0xDFF2, 0x637F}, //14216 #CJK UNIFIED IDEOGRAPH
  {0xDFF3, 0x654D}, //14217 #CJK UNIFIED IDEOGRAPH
  {0xDFF4, 0x6691}, //14218 #CJK UNIFIED IDEOGRAPH
  {0xDFF5, 0x66D9}, //14219 #CJK UNIFIED IDEOGRAPH
  {0xDFF6, 0x66F8}, //14220 #CJK UNIFIED IDEOGRAPH
  {0xDFF7, 0x6816}, //14221 #CJK UNIFIED IDEOGRAPH
  {0xDFF8, 0x68F2}, //14222 #CJK UNIFIED IDEOGRAPH
  {0xDFF9, 0x7280}, //14223 #CJK UNIFIED IDEOGRAPH
  {0xDFFA, 0x745E}, //14224 #CJK UNIFIED IDEOGRAPH
  {0xDFFB, 0x7B6E}, //14225 #CJK UNIFIED IDEOGRAPH
  {0xDFFC, 0x7D6E}, //14226 #CJK UNIFIED IDEOGRAPH
  {0xDFFD, 0x7DD6}, //14227 #CJK UNIFIED IDEOGRAPH
  {0xDFFE, 0x7F72}, //14228 #CJK UNIFIED IDEOGRAPH
  {0xE0A1, 0x80E5}, //14229 #CJK UNIFIED IDEOGRAPH
  {0xE0A2, 0x8212}, //14230 #CJK UNIFIED IDEOGRAPH
  {0xE0A3, 0x85AF}, //14231 #CJK UNIFIED IDEOGRAPH
  {0xE0A4, 0x897F}, //14232 #CJK UNIFIED IDEOGRAPH
  {0xE0A5, 0x8A93}, //14233 #CJK UNIFIED IDEOGRAPH
  {0xE0A6, 0x901D}, //14234 #CJK UNIFIED IDEOGRAPH
  {0xE0A7, 0x92E4}, //14235 #CJK UNIFIED IDEOGRAPH
  {0xE0A8, 0x9ECD}, //14236 #CJK UNIFIED IDEOGRAPH
  {0xE0A9, 0x9F20}, //14237 #CJK UNIFIED IDEOGRAPH
  {0xE0AA, 0x5915}, //14238 #CJK UNIFIED IDEOGRAPH
  {0xE0AB, 0x596D}, //14239 #CJK UNIFIED IDEOGRAPH
  {0xE0AC, 0x5E2D}, //14240 #CJK UNIFIED IDEOGRAPH
  {0xE0AD, 0x60DC}, //14241 #CJK UNIFIED IDEOGRAPH
  {0xE0AE, 0x6614}, //14242 #CJK UNIFIED IDEOGRAPH
  {0xE0AF, 0x6673}, //14243 #CJK UNIFIED IDEOGRAPH
  {0xE0B0, 0x6790}, //14244 #CJK UNIFIED IDEOGRAPH
  {0xE0B1, 0x6C50}, //14245 #CJK UNIFIED IDEOGRAPH
  {0xE0B2, 0x6DC5}, //14246 #CJK UNIFIED IDEOGRAPH
  {0xE0B3, 0x6F5F}, //14247 #CJK UNIFIED IDEOGRAPH
  {0xE0B4, 0x77F3}, //14248 #CJK UNIFIED IDEOGRAPH
  {0xE0B5, 0x78A9}, //14249 #CJK UNIFIED IDEOGRAPH
  {0xE0B6, 0x84C6}, //14250 #CJK UNIFIED IDEOGRAPH
  {0xE0B7, 0x91CB}, //14251 #CJK UNIFIED IDEOGRAPH
  {0xE0B8, 0x932B}, //14252 #CJK UNIFIED IDEOGRAPH
  {0xE0B9, 0x4ED9}, //14253 #CJK UNIFIED IDEOGRAPH
  {0xE0BA, 0x50CA}, //14254 #CJK UNIFIED IDEOGRAPH
  {0xE0BB, 0x5148}, //14255 #CJK UNIFIED IDEOGRAPH
  {0xE0BC, 0x5584}, //14256 #CJK UNIFIED IDEOGRAPH
  {0xE0BD, 0x5B0B}, //14257 #CJK UNIFIED IDEOGRAPH
  {0xE0BE, 0x5BA3}, //14258 #CJK UNIFIED IDEOGRAPH
  {0xE0BF, 0x6247}, //14259 #CJK UNIFIED IDEOGRAPH
  {0xE0C0, 0x657E}, //14260 #CJK UNIFIED IDEOGRAPH
  {0xE0C1, 0x65CB}, //14261 #CJK UNIFIED IDEOGRAPH
  {0xE0C2, 0x6E32}, //14262 #CJK UNIFIED IDEOGRAPH
  {0xE0C3, 0x717D}, //14263 #CJK UNIFIED IDEOGRAPH
  {0xE0C4, 0x7401}, //14264 #CJK UNIFIED IDEOGRAPH
  {0xE0C5, 0x7444}, //14265 #CJK UNIFIED IDEOGRAPH
  {0xE0C6, 0x7487}, //14266 #CJK UNIFIED IDEOGRAPH
  {0xE0C7, 0x74BF}, //14267 #CJK UNIFIED IDEOGRAPH
  {0xE0C8, 0x766C}, //14268 #CJK UNIFIED IDEOGRAPH
  {0xE0C9, 0x79AA}, //14269 #CJK UNIFIED IDEOGRAPH
  {0xE0CA, 0x7DDA}, //14270 #CJK UNIFIED IDEOGRAPH
  {0xE0CB, 0x7E55}, //14271 #CJK UNIFIED IDEOGRAPH
  {0xE0CC, 0x7FA8}, //14272 #CJK UNIFIED IDEOGRAPH
  {0xE0CD, 0x817A}, //14273 #CJK UNIFIED IDEOGRAPH
  {0xE0CE, 0x81B3}, //14274 #CJK UNIFIED IDEOGRAPH
  {0xE0CF, 0x8239}, //14275 #CJK UNIFIED IDEOGRAPH
  {0xE0D0, 0x861A}, //14276 #CJK UNIFIED IDEOGRAPH
  {0xE0D1, 0x87EC}, //14277 #CJK UNIFIED IDEOGRAPH
  {0xE0D2, 0x8A75}, //14278 #CJK UNIFIED IDEOGRAPH
  {0xE0D3, 0x8DE3}, //14279 #CJK UNIFIED IDEOGRAPH
  {0xE0D4, 0x9078}, //14280 #CJK UNIFIED IDEOGRAPH
  {0xE0D5, 0x9291}, //14281 #CJK UNIFIED IDEOGRAPH
  {0xE0D6, 0x9425}, //14282 #CJK UNIFIED IDEOGRAPH
  {0xE0D7, 0x994D}, //14283 #CJK UNIFIED IDEOGRAPH
  {0xE0D8, 0x9BAE}, //14284 #CJK UNIFIED IDEOGRAPH
  {0xE0D9, 0x5368}, //14285 #CJK UNIFIED IDEOGRAPH
  {0xE0DA, 0x5C51}, //14286 #CJK UNIFIED IDEOGRAPH
  {0xE0DB, 0x6954}, //14287 #CJK UNIFIED IDEOGRAPH
  {0xE0DC, 0x6CC4}, //14288 #CJK UNIFIED IDEOGRAPH
  {0xE0DD, 0x6D29}, //14289 #CJK UNIFIED IDEOGRAPH
  {0xE0DE, 0x6E2B}, //14290 #CJK UNIFIED IDEOGRAPH
  {0xE0DF, 0x820C}, //14291 #CJK UNIFIED IDEOGRAPH
  {0xE0E0, 0x859B}, //14292 #CJK UNIFIED IDEOGRAPH
  {0xE0E1, 0x893B}, //14293 #CJK UNIFIED IDEOGRAPH
  {0xE0E2, 0x8A2D}, //14294 #CJK UNIFIED IDEOGRAPH
  {0xE0E3, 0x8AAA}, //14295 #CJK UNIFIED IDEOGRAPH
  {0xE0E4, 0x96EA}, //14296 #CJK UNIFIED IDEOGRAPH
  {0xE0E5, 0x9F67}, //14297 #CJK UNIFIED IDEOGRAPH
  {0xE0E6, 0x5261}, //14298 #CJK UNIFIED IDEOGRAPH
  {0xE0E7, 0x66B9}, //14299 #CJK UNIFIED IDEOGRAPH
  {0xE0E8, 0x6BB2}, //14300 #CJK UNIFIED IDEOGRAPH
  {0xE0E9, 0x7E96}, //14301 #CJK UNIFIED IDEOGRAPH
  {0xE0EA, 0x87FE}, //14302 #CJK UNIFIED IDEOGRAPH
  {0xE0EB, 0x8D0D}, //14303 #CJK UNIFIED IDEOGRAPH
  {0xE0EC, 0x9583}, //14304 #CJK UNIFIED IDEOGRAPH
  {0xE0ED, 0x965D}, //14305 #CJK UNIFIED IDEOGRAPH
  {0xE0EE, 0x651D}, //14306 #CJK UNIFIED IDEOGRAPH
  {0xE0EF, 0x6D89}, //14307 #CJK UNIFIED IDEOGRAPH
  {0xE0F0, 0x71EE}, //14308 #CJK UNIFIED IDEOGRAPH
  {0xE0F1, 0xF96E}, //14309 #CJK COMPATIBILITY IDEOGRAPH
  {0xE0F2, 0x57CE}, //14310 #CJK UNIFIED IDEOGRAPH
  {0xE0F3, 0x59D3}, //14311 #CJK UNIFIED IDEOGRAPH
  {0xE0F4, 0x5BAC}, //14312 #CJK UNIFIED IDEOGRAPH
  {0xE0F5, 0x6027}, //14313 #CJK UNIFIED IDEOGRAPH
  {0xE0F6, 0x60FA}, //14314 #CJK UNIFIED IDEOGRAPH
  {0xE0F7, 0x6210}, //14315 #CJK UNIFIED IDEOGRAPH
  {0xE0F8, 0x661F}, //14316 #CJK UNIFIED IDEOGRAPH
  {0xE0F9, 0x665F}, //14317 #CJK UNIFIED IDEOGRAPH
  {0xE0FA, 0x7329}, //14318 #CJK UNIFIED IDEOGRAPH
  {0xE0FB, 0x73F9}, //14319 #CJK UNIFIED IDEOGRAPH
  {0xE0FC, 0x76DB}, //14320 #CJK UNIFIED IDEOGRAPH
  {0xE0FD, 0x7701}, //14321 #CJK UNIFIED IDEOGRAPH
  {0xE0FE, 0x7B6C}, //14322 #CJK UNIFIED IDEOGRAPH
  {0xE1A1, 0x8056}, //14323 #CJK UNIFIED IDEOGRAPH
  {0xE1A2, 0x8072}, //14324 #CJK UNIFIED IDEOGRAPH
  {0xE1A3, 0x8165}, //14325 #CJK UNIFIED IDEOGRAPH
  {0xE1A4, 0x8AA0}, //14326 #CJK UNIFIED IDEOGRAPH
  {0xE1A5, 0x9192}, //14327 #CJK UNIFIED IDEOGRAPH
  {0xE1A6, 0x4E16}, //14328 #CJK UNIFIED IDEOGRAPH
  {0xE1A7, 0x52E2}, //14329 #CJK UNIFIED IDEOGRAPH
  {0xE1A8, 0x6B72}, //14330 #CJK UNIFIED IDEOGRAPH
  {0xE1A9, 0x6D17}, //14331 #CJK UNIFIED IDEOGRAPH
  {0xE1AA, 0x7A05}, //14332 #CJK UNIFIED IDEOGRAPH
  {0xE1AB, 0x7B39}, //14333 #CJK UNIFIED IDEOGRAPH
  {0xE1AC, 0x7D30}, //14334 #CJK UNIFIED IDEOGRAPH
  {0xE1AD, 0xF96F}, //14335 #CJK COMPATIBILITY IDEOGRAPH
  {0xE1AE, 0x8CB0}, //14336 #CJK UNIFIED IDEOGRAPH
  {0xE1AF, 0x53EC}, //14337 #CJK UNIFIED IDEOGRAPH
  {0xE1B0, 0x562F}, //14338 #CJK UNIFIED IDEOGRAPH
  {0xE1B1, 0x5851}, //14339 #CJK UNIFIED IDEOGRAPH
  {0xE1B2, 0x5BB5}, //14340 #CJK UNIFIED IDEOGRAPH
  {0xE1B3, 0x5C0F}, //14341 #CJK UNIFIED IDEOGRAPH
  {0xE1B4, 0x5C11}, //14342 #CJK UNIFIED IDEOGRAPH
  {0xE1B5, 0x5DE2}, //14343 #CJK UNIFIED IDEOGRAPH
  {0xE1B6, 0x6240}, //14344 #CJK UNIFIED IDEOGRAPH
  {0xE1B7, 0x6383}, //14345 #CJK UNIFIED IDEOGRAPH
  {0xE1B8, 0x6414}, //14346 #CJK UNIFIED IDEOGRAPH
  {0xE1B9, 0x662D}, //14347 #CJK UNIFIED IDEOGRAPH
  {0xE1BA, 0x68B3}, //14348 #CJK UNIFIED IDEOGRAPH
  {0xE1BB, 0x6CBC}, //14349 #CJK UNIFIED IDEOGRAPH
  {0xE1BC, 0x6D88}, //14350 #CJK UNIFIED IDEOGRAPH
  {0xE1BD, 0x6EAF}, //14351 #CJK UNIFIED IDEOGRAPH
  {0xE1BE, 0x701F}, //14352 #CJK UNIFIED IDEOGRAPH
  {0xE1BF, 0x70A4}, //14353 #CJK UNIFIED IDEOGRAPH
  {0xE1C0, 0x71D2}, //14354 #CJK UNIFIED IDEOGRAPH
  {0xE1C1, 0x7526}, //14355 #CJK UNIFIED IDEOGRAPH
  {0xE1C2, 0x758F}, //14356 #CJK UNIFIED IDEOGRAPH
  {0xE1C3, 0x758E}, //14357 #CJK UNIFIED IDEOGRAPH
  {0xE1C4, 0x7619}, //14358 #CJK UNIFIED IDEOGRAPH
  {0xE1C5, 0x7B11}, //14359 #CJK UNIFIED IDEOGRAPH
  {0xE1C6, 0x7BE0}, //14360 #CJK UNIFIED IDEOGRAPH
  {0xE1C7, 0x7C2B}, //14361 #CJK UNIFIED IDEOGRAPH
  {0xE1C8, 0x7D20}, //14362 #CJK UNIFIED IDEOGRAPH
  {0xE1C9, 0x7D39}, //14363 #CJK UNIFIED IDEOGRAPH
  {0xE1CA, 0x852C}, //14364 #CJK UNIFIED IDEOGRAPH
  {0xE1CB, 0x856D}, //14365 #CJK UNIFIED IDEOGRAPH
  {0xE1CC, 0x8607}, //14366 #CJK UNIFIED IDEOGRAPH
  {0xE1CD, 0x8A34}, //14367 #CJK UNIFIED IDEOGRAPH
  {0xE1CE, 0x900D}, //14368 #CJK UNIFIED IDEOGRAPH
  {0xE1CF, 0x9061}, //14369 #CJK UNIFIED IDEOGRAPH
  {0xE1D0, 0x90B5}, //14370 #CJK UNIFIED IDEOGRAPH
  {0xE1D1, 0x92B7}, //14371 #CJK UNIFIED IDEOGRAPH
  {0xE1D2, 0x97F6}, //14372 #CJK UNIFIED IDEOGRAPH
  {0xE1D3, 0x9A37}, //14373 #CJK UNIFIED IDEOGRAPH
  {0xE1D4, 0x4FD7}, //14374 #CJK UNIFIED IDEOGRAPH
  {0xE1D5, 0x5C6C}, //14375 #CJK UNIFIED IDEOGRAPH
  {0xE1D6, 0x675F}, //14376 #CJK UNIFIED IDEOGRAPH
  {0xE1D7, 0x6D91}, //14377 #CJK UNIFIED IDEOGRAPH
  {0xE1D8, 0x7C9F}, //14378 #CJK UNIFIED IDEOGRAPH
  {0xE1D9, 0x7E8C}, //14379 #CJK UNIFIED IDEOGRAPH
  {0xE1DA, 0x8B16}, //14380 #CJK UNIFIED IDEOGRAPH
  {0xE1DB, 0x8D16}, //14381 #CJK UNIFIED IDEOGRAPH
  {0xE1DC, 0x901F}, //14382 #CJK UNIFIED IDEOGRAPH
  {0xE1DD, 0x5B6B}, //14383 #CJK UNIFIED IDEOGRAPH
  {0xE1DE, 0x5DFD}, //14384 #CJK UNIFIED IDEOGRAPH
  {0xE1DF, 0x640D}, //14385 #CJK UNIFIED IDEOGRAPH
  {0xE1E0, 0x84C0}, //14386 #CJK UNIFIED IDEOGRAPH
  {0xE1E1, 0x905C}, //14387 #CJK UNIFIED IDEOGRAPH
  {0xE1E2, 0x98E1}, //14388 #CJK UNIFIED IDEOGRAPH
  {0xE1E3, 0x7387}, //14389 #CJK UNIFIED IDEOGRAPH
  {0xE1E4, 0x5B8B}, //14390 #CJK UNIFIED IDEOGRAPH
  {0xE1E5, 0x609A}, //14391 #CJK UNIFIED IDEOGRAPH
  {0xE1E6, 0x677E}, //14392 #CJK UNIFIED IDEOGRAPH
  {0xE1E7, 0x6DDE}, //14393 #CJK UNIFIED IDEOGRAPH
  {0xE1E8, 0x8A1F}, //14394 #CJK UNIFIED IDEOGRAPH
  {0xE1E9, 0x8AA6}, //14395 #CJK UNIFIED IDEOGRAPH
  {0xE1EA, 0x9001}, //14396 #CJK UNIFIED IDEOGRAPH
  {0xE1EB, 0x980C}, //14397 #CJK UNIFIED IDEOGRAPH
  {0xE1EC, 0x5237}, //14398 #CJK UNIFIED IDEOGRAPH
  {0xE1ED, 0xF970}, //14399 #CJK COMPATIBILITY IDEOGRAPH
  {0xE1EE, 0x7051}, //14400 #CJK UNIFIED IDEOGRAPH
  {0xE1EF, 0x788E}, //14401 #CJK UNIFIED IDEOGRAPH
  {0xE1F0, 0x9396}, //14402 #CJK UNIFIED IDEOGRAPH
  {0xE1F1, 0x8870}, //14403 #CJK UNIFIED IDEOGRAPH
  {0xE1F2, 0x91D7}, //14404 #CJK UNIFIED IDEOGRAPH
  {0xE1F3, 0x4FEE}, //14405 #CJK UNIFIED IDEOGRAPH
  {0xE1F4, 0x53D7}, //14406 #CJK UNIFIED IDEOGRAPH
  {0xE1F5, 0x55FD}, //14407 #CJK UNIFIED IDEOGRAPH
  {0xE1F6, 0x56DA}, //14408 #CJK UNIFIED IDEOGRAPH
  {0xE1F7, 0x5782}, //14409 #CJK UNIFIED IDEOGRAPH
  {0xE1F8, 0x58FD}, //14410 #CJK UNIFIED IDEOGRAPH
  {0xE1F9, 0x5AC2}, //14411 #CJK UNIFIED IDEOGRAPH
  {0xE1FA, 0x5B88}, //14412 #CJK UNIFIED IDEOGRAPH
  {0xE1FB, 0x5CAB}, //14413 #CJK UNIFIED IDEOGRAPH
  {0xE1FC, 0x5CC0}, //14414 #CJK UNIFIED IDEOGRAPH
  {0xE1FD, 0x5E25}, //14415 #CJK UNIFIED IDEOGRAPH
  {0xE1FE, 0x6101}, //14416 #CJK UNIFIED IDEOGRAPH
  {0xE2A1, 0x620D}, //14417 #CJK UNIFIED IDEOGRAPH
  {0xE2A2, 0x624B}, //14418 #CJK UNIFIED IDEOGRAPH
  {0xE2A3, 0x6388}, //14419 #CJK UNIFIED IDEOGRAPH
  {0xE2A4, 0x641C}, //14420 #CJK UNIFIED IDEOGRAPH
  {0xE2A5, 0x6536}, //14421 #CJK UNIFIED IDEOGRAPH
  {0xE2A6, 0x6578}, //14422 #CJK UNIFIED IDEOGRAPH
  {0xE2A7, 0x6A39}, //14423 #CJK UNIFIED IDEOGRAPH
  {0xE2A8, 0x6B8A}, //14424 #CJK UNIFIED IDEOGRAPH
  {0xE2A9, 0x6C34}, //14425 #CJK UNIFIED IDEOGRAPH
  {0xE2AA, 0x6D19}, //14426 #CJK UNIFIED IDEOGRAPH
  {0xE2AB, 0x6F31}, //14427 #CJK UNIFIED IDEOGRAPH
  {0xE2AC, 0x71E7}, //14428 #CJK UNIFIED IDEOGRAPH
  {0xE2AD, 0x72E9}, //14429 #CJK UNIFIED IDEOGRAPH
  {0xE2AE, 0x7378}, //14430 #CJK UNIFIED IDEOGRAPH
  {0xE2AF, 0x7407}, //14431 #CJK UNIFIED IDEOGRAPH
  {0xE2B0, 0x74B2}, //14432 #CJK UNIFIED IDEOGRAPH
  {0xE2B1, 0x7626}, //14433 #CJK UNIFIED IDEOGRAPH
  {0xE2B2, 0x7761}, //14434 #CJK UNIFIED IDEOGRAPH
  {0xE2B3, 0x79C0}, //14435 #CJK UNIFIED IDEOGRAPH
  {0xE2B4, 0x7A57}, //14436 #CJK UNIFIED IDEOGRAPH
  {0xE2B5, 0x7AEA}, //14437 #CJK UNIFIED IDEOGRAPH
  {0xE2B6, 0x7CB9}, //14438 #CJK UNIFIED IDEOGRAPH
  {0xE2B7, 0x7D8F}, //14439 #CJK UNIFIED IDEOGRAPH
  {0xE2B8, 0x7DAC}, //14440 #CJK UNIFIED IDEOGRAPH
  {0xE2B9, 0x7E61}, //14441 #CJK UNIFIED IDEOGRAPH
  {0xE2BA, 0x7F9E}, //14442 #CJK UNIFIED IDEOGRAPH
  {0xE2BB, 0x8129}, //14443 #CJK UNIFIED IDEOGRAPH
  {0xE2BC, 0x8331}, //14444 #CJK UNIFIED IDEOGRAPH
  {0xE2BD, 0x8490}, //14445 #CJK UNIFIED IDEOGRAPH
  {0xE2BE, 0x84DA}, //14446 #CJK UNIFIED IDEOGRAPH
  {0xE2BF, 0x85EA}, //14447 #CJK UNIFIED IDEOGRAPH
  {0xE2C0, 0x8896}, //14448 #CJK UNIFIED IDEOGRAPH
  {0xE2C1, 0x8AB0}, //14449 #CJK UNIFIED IDEOGRAPH
  {0xE2C2, 0x8B90}, //14450 #CJK UNIFIED IDEOGRAPH
  {0xE2C3, 0x8F38}, //14451 #CJK UNIFIED IDEOGRAPH
  {0xE2C4, 0x9042}, //14452 #CJK UNIFIED IDEOGRAPH
  {0xE2C5, 0x9083}, //14453 #CJK UNIFIED IDEOGRAPH
  {0xE2C6, 0x916C}, //14454 #CJK UNIFIED IDEOGRAPH
  {0xE2C7, 0x9296}, //14455 #CJK UNIFIED IDEOGRAPH
  {0xE2C8, 0x92B9}, //14456 #CJK UNIFIED IDEOGRAPH
  {0xE2C9, 0x968B}, //14457 #CJK UNIFIED IDEOGRAPH
  {0xE2CA, 0x96A7}, //14458 #CJK UNIFIED IDEOGRAPH
  {0xE2CB, 0x96A8}, //14459 #CJK UNIFIED IDEOGRAPH
  {0xE2CC, 0x96D6}, //14460 #CJK UNIFIED IDEOGRAPH
  {0xE2CD, 0x9700}, //14461 #CJK UNIFIED IDEOGRAPH
  {0xE2CE, 0x9808}, //14462 #CJK UNIFIED IDEOGRAPH
  {0xE2CF, 0x9996}, //14463 #CJK UNIFIED IDEOGRAPH
  {0xE2D0, 0x9AD3}, //14464 #CJK UNIFIED IDEOGRAPH
  {0xE2D1, 0x9B1A}, //14465 #CJK UNIFIED IDEOGRAPH
  {0xE2D2, 0x53D4}, //14466 #CJK UNIFIED IDEOGRAPH
  {0xE2D3, 0x587E}, //14467 #CJK UNIFIED IDEOGRAPH
  {0xE2D4, 0x5919}, //14468 #CJK UNIFIED IDEOGRAPH
  {0xE2D5, 0x5B70}, //14469 #CJK UNIFIED IDEOGRAPH
  {0xE2D6, 0x5BBF}, //14470 #CJK UNIFIED IDEOGRAPH
  {0xE2D7, 0x6DD1}, //14471 #CJK UNIFIED IDEOGRAPH
  {0xE2D8, 0x6F5A}, //14472 #CJK UNIFIED IDEOGRAPH
  {0xE2D9, 0x719F}, //14473 #CJK UNIFIED IDEOGRAPH
  {0xE2DA, 0x7421}, //14474 #CJK UNIFIED IDEOGRAPH
  {0xE2DB, 0x74B9}, //14475 #CJK UNIFIED IDEOGRAPH
  {0xE2DC, 0x8085}, //14476 #CJK UNIFIED IDEOGRAPH
  {0xE2DD, 0x83FD}, //14477 #CJK UNIFIED IDEOGRAPH
  {0xE2DE, 0x5DE1}, //14478 #CJK UNIFIED IDEOGRAPH
  {0xE2DF, 0x5F87}, //14479 #CJK UNIFIED IDEOGRAPH
  {0xE2E0, 0x5FAA}, //14480 #CJK UNIFIED IDEOGRAPH
  {0xE2E1, 0x6042}, //14481 #CJK UNIFIED IDEOGRAPH
  {0xE2E2, 0x65EC}, //14482 #CJK UNIFIED IDEOGRAPH
  {0xE2E3, 0x6812}, //14483 #CJK UNIFIED IDEOGRAPH
  {0xE2E4, 0x696F}, //14484 #CJK UNIFIED IDEOGRAPH
  {0xE2E5, 0x6A53}, //14485 #CJK UNIFIED IDEOGRAPH
  {0xE2E6, 0x6B89}, //14486 #CJK UNIFIED IDEOGRAPH
  {0xE2E7, 0x6D35}, //14487 #CJK UNIFIED IDEOGRAPH
  {0xE2E8, 0x6DF3}, //14488 #CJK UNIFIED IDEOGRAPH
  {0xE2E9, 0x73E3}, //14489 #CJK UNIFIED IDEOGRAPH
  {0xE2EA, 0x76FE}, //14490 #CJK UNIFIED IDEOGRAPH
  {0xE2EB, 0x77AC}, //14491 #CJK UNIFIED IDEOGRAPH
  {0xE2EC, 0x7B4D}, //14492 #CJK UNIFIED IDEOGRAPH
  {0xE2ED, 0x7D14}, //14493 #CJK UNIFIED IDEOGRAPH
  {0xE2EE, 0x8123}, //14494 #CJK UNIFIED IDEOGRAPH
  {0xE2EF, 0x821C}, //14495 #CJK UNIFIED IDEOGRAPH
  {0xE2F0, 0x8340}, //14496 #CJK UNIFIED IDEOGRAPH
  {0xE2F1, 0x84F4}, //14497 #CJK UNIFIED IDEOGRAPH
  {0xE2F2, 0x8563}, //14498 #CJK UNIFIED IDEOGRAPH
  {0xE2F3, 0x8A62}, //14499 #CJK UNIFIED IDEOGRAPH
  {0xE2F4, 0x8AC4}, //14500 #CJK UNIFIED IDEOGRAPH
  {0xE2F5, 0x9187}, //14501 #CJK UNIFIED IDEOGRAPH
  {0xE2F6, 0x931E}, //14502 #CJK UNIFIED IDEOGRAPH
  {0xE2F7, 0x9806}, //14503 #CJK UNIFIED IDEOGRAPH
  {0xE2F8, 0x99B4}, //14504 #CJK UNIFIED IDEOGRAPH
  {0xE2F9, 0x620C}, //14505 #CJK UNIFIED IDEOGRAPH
  {0xE2FA, 0x8853}, //14506 #CJK UNIFIED IDEOGRAPH
  {0xE2FB, 0x8FF0}, //14507 #CJK UNIFIED IDEOGRAPH
  {0xE2FC, 0x9265}, //14508 #CJK UNIFIED IDEOGRAPH
  {0xE2FD, 0x5D07}, //14509 #CJK UNIFIED IDEOGRAPH
  {0xE2FE, 0x5D27}, //14510 #CJK UNIFIED IDEOGRAPH
  {0xE3A1, 0x5D69}, //14511 #CJK UNIFIED IDEOGRAPH
  {0xE3A2, 0x745F}, //14512 #CJK UNIFIED IDEOGRAPH
  {0xE3A3, 0x819D}, //14513 #CJK UNIFIED IDEOGRAPH
  {0xE3A4, 0x8768}, //14514 #CJK UNIFIED IDEOGRAPH
  {0xE3A5, 0x6FD5}, //14515 #CJK UNIFIED IDEOGRAPH
  {0xE3A6, 0x62FE}, //14516 #CJK UNIFIED IDEOGRAPH
  {0xE3A7, 0x7FD2}, //14517 #CJK UNIFIED IDEOGRAPH
  {0xE3A8, 0x8936}, //14518 #CJK UNIFIED IDEOGRAPH
  {0xE3A9, 0x8972}, //14519 #CJK UNIFIED IDEOGRAPH
  {0xE3AA, 0x4E1E}, //14520 #CJK UNIFIED IDEOGRAPH
  {0xE3AB, 0x4E58}, //14521 #CJK UNIFIED IDEOGRAPH
  {0xE3AC, 0x50E7}, //14522 #CJK UNIFIED IDEOGRAPH
  {0xE3AD, 0x52DD}, //14523 #CJK UNIFIED IDEOGRAPH
  {0xE3AE, 0x5347}, //14524 #CJK UNIFIED IDEOGRAPH
  {0xE3AF, 0x627F}, //14525 #CJK UNIFIED IDEOGRAPH
  {0xE3B0, 0x6607}, //14526 #CJK UNIFIED IDEOGRAPH
  {0xE3B1, 0x7E69}, //14527 #CJK UNIFIED IDEOGRAPH
  {0xE3B2, 0x8805}, //14528 #CJK UNIFIED IDEOGRAPH
  {0xE3B3, 0x965E}, //14529 #CJK UNIFIED IDEOGRAPH
  {0xE3B4, 0x4F8D}, //14530 #CJK UNIFIED IDEOGRAPH
  {0xE3B5, 0x5319}, //14531 #CJK UNIFIED IDEOGRAPH
  {0xE3B6, 0x5636}, //14532 #CJK UNIFIED IDEOGRAPH
  {0xE3B7, 0x59CB}, //14533 #CJK UNIFIED IDEOGRAPH
  {0xE3B8, 0x5AA4}, //14534 #CJK UNIFIED IDEOGRAPH
  {0xE3B9, 0x5C38}, //14535 #CJK UNIFIED IDEOGRAPH
  {0xE3BA, 0x5C4E}, //14536 #CJK UNIFIED IDEOGRAPH
  {0xE3BB, 0x5C4D}, //14537 #CJK UNIFIED IDEOGRAPH
  {0xE3BC, 0x5E02}, //14538 #CJK UNIFIED IDEOGRAPH
  {0xE3BD, 0x5F11}, //14539 #CJK UNIFIED IDEOGRAPH
  {0xE3BE, 0x6043}, //14540 #CJK UNIFIED IDEOGRAPH
  {0xE3BF, 0x65BD}, //14541 #CJK UNIFIED IDEOGRAPH
  {0xE3C0, 0x662F}, //14542 #CJK UNIFIED IDEOGRAPH
  {0xE3C1, 0x6642}, //14543 #CJK UNIFIED IDEOGRAPH
  {0xE3C2, 0x67BE}, //14544 #CJK UNIFIED IDEOGRAPH
  {0xE3C3, 0x67F4}, //14545 #CJK UNIFIED IDEOGRAPH
  {0xE3C4, 0x731C}, //14546 #CJK UNIFIED IDEOGRAPH
  {0xE3C5, 0x77E2}, //14547 #CJK UNIFIED IDEOGRAPH
  {0xE3C6, 0x793A}, //14548 #CJK UNIFIED IDEOGRAPH
  {0xE3C7, 0x7FC5}, //14549 #CJK UNIFIED IDEOGRAPH
  {0xE3C8, 0x8494}, //14550 #CJK UNIFIED IDEOGRAPH
  {0xE3C9, 0x84CD}, //14551 #CJK UNIFIED IDEOGRAPH
  {0xE3CA, 0x8996}, //14552 #CJK UNIFIED IDEOGRAPH
  {0xE3CB, 0x8A66}, //14553 #CJK UNIFIED IDEOGRAPH
  {0xE3CC, 0x8A69}, //14554 #CJK UNIFIED IDEOGRAPH
  {0xE3CD, 0x8AE1}, //14555 #CJK UNIFIED IDEOGRAPH
  {0xE3CE, 0x8C55}, //14556 #CJK UNIFIED IDEOGRAPH
  {0xE3CF, 0x8C7A}, //14557 #CJK UNIFIED IDEOGRAPH
  {0xE3D0, 0x57F4}, //14558 #CJK UNIFIED IDEOGRAPH
  {0xE3D1, 0x5BD4}, //14559 #CJK UNIFIED IDEOGRAPH
  {0xE3D2, 0x5F0F}, //14560 #CJK UNIFIED IDEOGRAPH
  {0xE3D3, 0x606F}, //14561 #CJK UNIFIED IDEOGRAPH
  {0xE3D4, 0x62ED}, //14562 #CJK UNIFIED IDEOGRAPH
  {0xE3D5, 0x690D}, //14563 #CJK UNIFIED IDEOGRAPH
  {0xE3D6, 0x6B96}, //14564 #CJK UNIFIED IDEOGRAPH
  {0xE3D7, 0x6E5C}, //14565 #CJK UNIFIED IDEOGRAPH
  {0xE3D8, 0x7184}, //14566 #CJK UNIFIED IDEOGRAPH
  {0xE3D9, 0x7BD2}, //14567 #CJK UNIFIED IDEOGRAPH
  {0xE3DA, 0x8755}, //14568 #CJK UNIFIED IDEOGRAPH
  {0xE3DB, 0x8B58}, //14569 #CJK UNIFIED IDEOGRAPH
  {0xE3DC, 0x8EFE}, //14570 #CJK UNIFIED IDEOGRAPH
  {0xE3DD, 0x98DF}, //14571 #CJK UNIFIED IDEOGRAPH
  {0xE3DE, 0x98FE}, //14572 #CJK UNIFIED IDEOGRAPH
  {0xE3DF, 0x4F38}, //14573 #CJK UNIFIED IDEOGRAPH
  {0xE3E0, 0x4F81}, //14574 #CJK UNIFIED IDEOGRAPH
  {0xE3E1, 0x4FE1}, //14575 #CJK UNIFIED IDEOGRAPH
  {0xE3E2, 0x547B}, //14576 #CJK UNIFIED IDEOGRAPH
  {0xE3E3, 0x5A20}, //14577 #CJK UNIFIED IDEOGRAPH
  {0xE3E4, 0x5BB8}, //14578 #CJK UNIFIED IDEOGRAPH
  {0xE3E5, 0x613C}, //14579 #CJK UNIFIED IDEOGRAPH
  {0xE3E6, 0x65B0}, //14580 #CJK UNIFIED IDEOGRAPH
  {0xE3E7, 0x6668}, //14581 #CJK UNIFIED IDEOGRAPH
  {0xE3E8, 0x71FC}, //14582 #CJK UNIFIED IDEOGRAPH
  {0xE3E9, 0x7533}, //14583 #CJK UNIFIED IDEOGRAPH
  {0xE3EA, 0x795E}, //14584 #CJK UNIFIED IDEOGRAPH
  {0xE3EB, 0x7D33}, //14585 #CJK UNIFIED IDEOGRAPH
  {0xE3EC, 0x814E}, //14586 #CJK UNIFIED IDEOGRAPH
  {0xE3ED, 0x81E3}, //14587 #CJK UNIFIED IDEOGRAPH
  {0xE3EE, 0x8398}, //14588 #CJK UNIFIED IDEOGRAPH
  {0xE3EF, 0x85AA}, //14589 #CJK UNIFIED IDEOGRAPH
  {0xE3F0, 0x85CE}, //14590 #CJK UNIFIED IDEOGRAPH
  {0xE3F1, 0x8703}, //14591 #CJK UNIFIED IDEOGRAPH
  {0xE3F2, 0x8A0A}, //14592 #CJK UNIFIED IDEOGRAPH
  {0xE3F3, 0x8EAB}, //14593 #CJK UNIFIED IDEOGRAPH
  {0xE3F4, 0x8F9B}, //14594 #CJK UNIFIED IDEOGRAPH
  {0xE3F5, 0xF971}, //14595 #CJK COMPATIBILITY IDEOGRAPH
  {0xE3F6, 0x8FC5}, //14596 #CJK UNIFIED IDEOGRAPH
  {0xE3F7, 0x5931}, //14597 #CJK UNIFIED IDEOGRAPH
  {0xE3F8, 0x5BA4}, //14598 #CJK UNIFIED IDEOGRAPH
  {0xE3F9, 0x5BE6}, //14599 #CJK UNIFIED IDEOGRAPH
  {0xE3FA, 0x6089}, //14600 #CJK UNIFIED IDEOGRAPH
  {0xE3FB, 0x5BE9}, //14601 #CJK UNIFIED IDEOGRAPH
  {0xE3FC, 0x5C0B}, //14602 #CJK UNIFIED IDEOGRAPH
  {0xE3FD, 0x5FC3}, //14603 #CJK UNIFIED IDEOGRAPH
  {0xE3FE, 0x6C81}, //14604 #CJK UNIFIED IDEOGRAPH
  {0xE4A1, 0xF972}, //14605 #CJK COMPATIBILITY IDEOGRAPH
  {0xE4A2, 0x6DF1}, //14606 #CJK UNIFIED IDEOGRAPH
  {0xE4A3, 0x700B}, //14607 #CJK UNIFIED IDEOGRAPH
  {0xE4A4, 0x751A}, //14608 #CJK UNIFIED IDEOGRAPH
  {0xE4A5, 0x82AF}, //14609 #CJK UNIFIED IDEOGRAPH
  {0xE4A6, 0x8AF6}, //14610 #CJK UNIFIED IDEOGRAPH
  {0xE4A7, 0x4EC0}, //14611 #CJK UNIFIED IDEOGRAPH
  {0xE4A8, 0x5341}, //14612 #CJK UNIFIED IDEOGRAPH
  {0xE4A9, 0xF973}, //14613 #CJK COMPATIBILITY IDEOGRAPH
  {0xE4AA, 0x96D9}, //14614 #CJK UNIFIED IDEOGRAPH
  {0xE4AB, 0x6C0F}, //14615 #CJK UNIFIED IDEOGRAPH
  {0xE4AC, 0x4E9E}, //14616 #CJK UNIFIED IDEOGRAPH
  {0xE4AD, 0x4FC4}, //14617 #CJK UNIFIED IDEOGRAPH
  {0xE4AE, 0x5152}, //14618 #CJK UNIFIED IDEOGRAPH
  {0xE4AF, 0x555E}, //14619 #CJK UNIFIED IDEOGRAPH
  {0xE4B0, 0x5A25}, //14620 #CJK UNIFIED IDEOGRAPH
  {0xE4B1, 0x5CE8}, //14621 #CJK UNIFIED IDEOGRAPH
  {0xE4B2, 0x6211}, //14622 #CJK UNIFIED IDEOGRAPH
  {0xE4B3, 0x7259}, //14623 #CJK UNIFIED IDEOGRAPH
  {0xE4B4, 0x82BD}, //14624 #CJK UNIFIED IDEOGRAPH
  {0xE4B5, 0x83AA}, //14625 #CJK UNIFIED IDEOGRAPH
  {0xE4B6, 0x86FE}, //14626 #CJK UNIFIED IDEOGRAPH
  {0xE4B7, 0x8859}, //14627 #CJK UNIFIED IDEOGRAPH
  {0xE4B8, 0x8A1D}, //14628 #CJK UNIFIED IDEOGRAPH
  {0xE4B9, 0x963F}, //14629 #CJK UNIFIED IDEOGRAPH
  {0xE4BA, 0x96C5}, //14630 #CJK UNIFIED IDEOGRAPH
  {0xE4BB, 0x9913}, //14631 #CJK UNIFIED IDEOGRAPH
  {0xE4BC, 0x9D09}, //14632 #CJK UNIFIED IDEOGRAPH
  {0xE4BD, 0x9D5D}, //14633 #CJK UNIFIED IDEOGRAPH
  {0xE4BE, 0x580A}, //14634 #CJK UNIFIED IDEOGRAPH
  {0xE4BF, 0x5CB3}, //14635 #CJK UNIFIED IDEOGRAPH
  {0xE4C0, 0x5DBD}, //14636 #CJK UNIFIED IDEOGRAPH
  {0xE4C1, 0x5E44}, //14637 #CJK UNIFIED IDEOGRAPH
  {0xE4C2, 0x60E1}, //14638 #CJK UNIFIED IDEOGRAPH
  {0xE4C3, 0x6115}, //14639 #CJK UNIFIED IDEOGRAPH
  {0xE4C4, 0x63E1}, //14640 #CJK UNIFIED IDEOGRAPH
  {0xE4C5, 0x6A02}, //14641 #CJK UNIFIED IDEOGRAPH
  {0xE4C6, 0x6E25}, //14642 #CJK UNIFIED IDEOGRAPH
  {0xE4C7, 0x9102}, //14643 #CJK UNIFIED IDEOGRAPH
  {0xE4C8, 0x9354}, //14644 #CJK UNIFIED IDEOGRAPH
  {0xE4C9, 0x984E}, //14645 #CJK UNIFIED IDEOGRAPH
  {0xE4CA, 0x9C10}, //14646 #CJK UNIFIED IDEOGRAPH
  {0xE4CB, 0x9F77}, //14647 #CJK UNIFIED IDEOGRAPH
  {0xE4CC, 0x5B89}, //14648 #CJK UNIFIED IDEOGRAPH
  {0xE4CD, 0x5CB8}, //14649 #CJK UNIFIED IDEOGRAPH
  {0xE4CE, 0x6309}, //14650 #CJK UNIFIED IDEOGRAPH
  {0xE4CF, 0x664F}, //14651 #CJK UNIFIED IDEOGRAPH
  {0xE4D0, 0x6848}, //14652 #CJK UNIFIED IDEOGRAPH
  {0xE4D1, 0x773C}, //14653 #CJK UNIFIED IDEOGRAPH
  {0xE4D2, 0x96C1}, //14654 #CJK UNIFIED IDEOGRAPH
  {0xE4D3, 0x978D}, //14655 #CJK UNIFIED IDEOGRAPH
  {0xE4D4, 0x9854}, //14656 #CJK UNIFIED IDEOGRAPH
  {0xE4D5, 0x9B9F}, //14657 #CJK UNIFIED IDEOGRAPH
  {0xE4D6, 0x65A1}, //14658 #CJK UNIFIED IDEOGRAPH
  {0xE4D7, 0x8B01}, //14659 #CJK UNIFIED IDEOGRAPH
  {0xE4D8, 0x8ECB}, //14660 #CJK UNIFIED IDEOGRAPH
  {0xE4D9, 0x95BC}, //14661 #CJK UNIFIED IDEOGRAPH
  {0xE4DA, 0x5535}, //14662 #CJK UNIFIED IDEOGRAPH
  {0xE4DB, 0x5CA9}, //14663 #CJK UNIFIED IDEOGRAPH
  {0xE4DC, 0x5DD6}, //14664 #CJK UNIFIED IDEOGRAPH
  {0xE4DD, 0x5EB5}, //14665 #CJK UNIFIED IDEOGRAPH
  {0xE4DE, 0x6697}, //14666 #CJK UNIFIED IDEOGRAPH
  {0xE4DF, 0x764C}, //14667 #CJK UNIFIED IDEOGRAPH
  {0xE4E0, 0x83F4}, //14668 #CJK UNIFIED IDEOGRAPH
  {0xE4E1, 0x95C7}, //14669 #CJK UNIFIED IDEOGRAPH
  {0xE4E2, 0x58D3}, //14670 #CJK UNIFIED IDEOGRAPH
  {0xE4E3, 0x62BC}, //14671 #CJK UNIFIED IDEOGRAPH
  {0xE4E4, 0x72CE}, //14672 #CJK UNIFIED IDEOGRAPH
  {0xE4E5, 0x9D28}, //14673 #CJK UNIFIED IDEOGRAPH
  {0xE4E6, 0x4EF0}, //14674 #CJK UNIFIED IDEOGRAPH
  {0xE4E7, 0x592E}, //14675 #CJK UNIFIED IDEOGRAPH
  {0xE4E8, 0x600F}, //14676 #CJK UNIFIED IDEOGRAPH
  {0xE4E9, 0x663B}, //14677 #CJK UNIFIED IDEOGRAPH
  {0xE4EA, 0x6B83}, //14678 #CJK UNIFIED IDEOGRAPH
  {0xE4EB, 0x79E7}, //14679 #CJK UNIFIED IDEOGRAPH
  {0xE4EC, 0x9D26}, //14680 #CJK UNIFIED IDEOGRAPH
  {0xE4ED, 0x5393}, //14681 #CJK UNIFIED IDEOGRAPH
  {0xE4EE, 0x54C0}, //14682 #CJK UNIFIED IDEOGRAPH
  {0xE4EF, 0x57C3}, //14683 #CJK UNIFIED IDEOGRAPH
  {0xE4F0, 0x5D16}, //14684 #CJK UNIFIED IDEOGRAPH
  {0xE4F1, 0x611B}, //14685 #CJK UNIFIED IDEOGRAPH
  {0xE4F2, 0x66D6}, //14686 #CJK UNIFIED IDEOGRAPH
  {0xE4F3, 0x6DAF}, //14687 #CJK UNIFIED IDEOGRAPH
  {0xE4F4, 0x788D}, //14688 #CJK UNIFIED IDEOGRAPH
  {0xE4F5, 0x827E}, //14689 #CJK UNIFIED IDEOGRAPH
  {0xE4F6, 0x9698}, //14690 #CJK UNIFIED IDEOGRAPH
  {0xE4F7, 0x9744}, //14691 #CJK UNIFIED IDEOGRAPH
  {0xE4F8, 0x5384}, //14692 #CJK UNIFIED IDEOGRAPH
  {0xE4F9, 0x627C}, //14693 #CJK UNIFIED IDEOGRAPH
  {0xE4FA, 0x6396}, //14694 #CJK UNIFIED IDEOGRAPH
  {0xE4FB, 0x6DB2}, //14695 #CJK UNIFIED IDEOGRAPH
  {0xE4FC, 0x7E0A}, //14696 #CJK UNIFIED IDEOGRAPH
  {0xE4FD, 0x814B}, //14697 #CJK UNIFIED IDEOGRAPH
  {0xE4FE, 0x984D}, //14698 #CJK UNIFIED IDEOGRAPH
  {0xE5A1, 0x6AFB}, //14699 #CJK UNIFIED IDEOGRAPH
  {0xE5A2, 0x7F4C}, //14700 #CJK UNIFIED IDEOGRAPH
  {0xE5A3, 0x9DAF}, //14701 #CJK UNIFIED IDEOGRAPH
  {0xE5A4, 0x9E1A}, //14702 #CJK UNIFIED IDEOGRAPH
  {0xE5A5, 0x4E5F}, //14703 #CJK UNIFIED IDEOGRAPH
  {0xE5A6, 0x503B}, //14704 #CJK UNIFIED IDEOGRAPH
  {0xE5A7, 0x51B6}, //14705 #CJK UNIFIED IDEOGRAPH
  {0xE5A8, 0x591C}, //14706 #CJK UNIFIED IDEOGRAPH
  {0xE5A9, 0x60F9}, //14707 #CJK UNIFIED IDEOGRAPH
  {0xE5AA, 0x63F6}, //14708 #CJK UNIFIED IDEOGRAPH
  {0xE5AB, 0x6930}, //14709 #CJK UNIFIED IDEOGRAPH
  {0xE5AC, 0x723A}, //14710 #CJK UNIFIED IDEOGRAPH
  {0xE5AD, 0x8036}, //14711 #CJK UNIFIED IDEOGRAPH
  {0xE5AE, 0xF974}, //14712 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5AF, 0x91CE}, //14713 #CJK UNIFIED IDEOGRAPH
  {0xE5B0, 0x5F31}, //14714 #CJK UNIFIED IDEOGRAPH
  {0xE5B1, 0xF975}, //14715 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5B2, 0xF976}, //14716 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5B3, 0x7D04}, //14717 #CJK UNIFIED IDEOGRAPH
  {0xE5B4, 0x82E5}, //14718 #CJK UNIFIED IDEOGRAPH
  {0xE5B5, 0x846F}, //14719 #CJK UNIFIED IDEOGRAPH
  {0xE5B6, 0x84BB}, //14720 #CJK UNIFIED IDEOGRAPH
  {0xE5B7, 0x85E5}, //14721 #CJK UNIFIED IDEOGRAPH
  {0xE5B8, 0x8E8D}, //14722 #CJK UNIFIED IDEOGRAPH
  {0xE5B9, 0xF977}, //14723 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5BA, 0x4F6F}, //14724 #CJK UNIFIED IDEOGRAPH
  {0xE5BB, 0xF978}, //14725 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5BC, 0xF979}, //14726 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5BD, 0x58E4}, //14727 #CJK UNIFIED IDEOGRAPH
  {0xE5BE, 0x5B43}, //14728 #CJK UNIFIED IDEOGRAPH
  {0xE5BF, 0x6059}, //14729 #CJK UNIFIED IDEOGRAPH
  {0xE5C0, 0x63DA}, //14730 #CJK UNIFIED IDEOGRAPH
  {0xE5C1, 0x6518}, //14731 #CJK UNIFIED IDEOGRAPH
  {0xE5C2, 0x656D}, //14732 #CJK UNIFIED IDEOGRAPH
  {0xE5C3, 0x6698}, //14733 #CJK UNIFIED IDEOGRAPH
  {0xE5C4, 0xF97A}, //14734 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5C5, 0x694A}, //14735 #CJK UNIFIED IDEOGRAPH
  {0xE5C6, 0x6A23}, //14736 #CJK UNIFIED IDEOGRAPH
  {0xE5C7, 0x6D0B}, //14737 #CJK UNIFIED IDEOGRAPH
  {0xE5C8, 0x7001}, //14738 #CJK UNIFIED IDEOGRAPH
  {0xE5C9, 0x716C}, //14739 #CJK UNIFIED IDEOGRAPH
  {0xE5CA, 0x75D2}, //14740 #CJK UNIFIED IDEOGRAPH
  {0xE5CB, 0x760D}, //14741 #CJK UNIFIED IDEOGRAPH
  {0xE5CC, 0x79B3}, //14742 #CJK UNIFIED IDEOGRAPH
  {0xE5CD, 0x7A70}, //14743 #CJK UNIFIED IDEOGRAPH
  {0xE5CE, 0xF97B}, //14744 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5CF, 0x7F8A}, //14745 #CJK UNIFIED IDEOGRAPH
  {0xE5D0, 0xF97C}, //14746 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5D1, 0x8944}, //14747 #CJK UNIFIED IDEOGRAPH
  {0xE5D2, 0xF97D}, //14748 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5D3, 0x8B93}, //14749 #CJK UNIFIED IDEOGRAPH
  {0xE5D4, 0x91C0}, //14750 #CJK UNIFIED IDEOGRAPH
  {0xE5D5, 0x967D}, //14751 #CJK UNIFIED IDEOGRAPH
  {0xE5D6, 0xF97E}, //14752 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5D7, 0x990A}, //14753 #CJK UNIFIED IDEOGRAPH
  {0xE5D8, 0x5704}, //14754 #CJK UNIFIED IDEOGRAPH
  {0xE5D9, 0x5FA1}, //14755 #CJK UNIFIED IDEOGRAPH
  {0xE5DA, 0x65BC}, //14756 #CJK UNIFIED IDEOGRAPH
  {0xE5DB, 0x6F01}, //14757 #CJK UNIFIED IDEOGRAPH
  {0xE5DC, 0x7600}, //14758 #CJK UNIFIED IDEOGRAPH
  {0xE5DD, 0x79A6}, //14759 #CJK UNIFIED IDEOGRAPH
  {0xE5DE, 0x8A9E}, //14760 #CJK UNIFIED IDEOGRAPH
  {0xE5DF, 0x99AD}, //14761 #CJK UNIFIED IDEOGRAPH
  {0xE5E0, 0x9B5A}, //14762 #CJK UNIFIED IDEOGRAPH
  {0xE5E1, 0x9F6C}, //14763 #CJK UNIFIED IDEOGRAPH
  {0xE5E2, 0x5104}, //14764 #CJK UNIFIED IDEOGRAPH
  {0xE5E3, 0x61B6}, //14765 #CJK UNIFIED IDEOGRAPH
  {0xE5E4, 0x6291}, //14766 #CJK UNIFIED IDEOGRAPH
  {0xE5E5, 0x6A8D}, //14767 #CJK UNIFIED IDEOGRAPH
  {0xE5E6, 0x81C6}, //14768 #CJK UNIFIED IDEOGRAPH
  {0xE5E7, 0x5043}, //14769 #CJK UNIFIED IDEOGRAPH
  {0xE5E8, 0x5830}, //14770 #CJK UNIFIED IDEOGRAPH
  {0xE5E9, 0x5F66}, //14771 #CJK UNIFIED IDEOGRAPH
  {0xE5EA, 0x7109}, //14772 #CJK UNIFIED IDEOGRAPH
  {0xE5EB, 0x8A00}, //14773 #CJK UNIFIED IDEOGRAPH
  {0xE5EC, 0x8AFA}, //14774 #CJK UNIFIED IDEOGRAPH
  {0xE5ED, 0x5B7C}, //14775 #CJK UNIFIED IDEOGRAPH
  {0xE5EE, 0x8616}, //14776 #CJK UNIFIED IDEOGRAPH
  {0xE5EF, 0x4FFA}, //14777 #CJK UNIFIED IDEOGRAPH
  {0xE5F0, 0x513C}, //14778 #CJK UNIFIED IDEOGRAPH
  {0xE5F1, 0x56B4}, //14779 #CJK UNIFIED IDEOGRAPH
  {0xE5F2, 0x5944}, //14780 #CJK UNIFIED IDEOGRAPH
  {0xE5F3, 0x63A9}, //14781 #CJK UNIFIED IDEOGRAPH
  {0xE5F4, 0x6DF9}, //14782 #CJK UNIFIED IDEOGRAPH
  {0xE5F5, 0x5DAA}, //14783 #CJK UNIFIED IDEOGRAPH
  {0xE5F6, 0x696D}, //14784 #CJK UNIFIED IDEOGRAPH
  {0xE5F7, 0x5186}, //14785 #CJK UNIFIED IDEOGRAPH
  {0xE5F8, 0x4E88}, //14786 #CJK UNIFIED IDEOGRAPH
  {0xE5F9, 0x4F59}, //14787 #CJK UNIFIED IDEOGRAPH
  {0xE5FA, 0xF97F}, //14788 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5FB, 0xF980}, //14789 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5FC, 0xF981}, //14790 #CJK COMPATIBILITY IDEOGRAPH
  {0xE5FD, 0x5982}, //14791 #CJK UNIFIED IDEOGRAPH
  {0xE5FE, 0xF982}, //14792 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6A1, 0xF983}, //14793 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6A2, 0x6B5F}, //14794 #CJK UNIFIED IDEOGRAPH
  {0xE6A3, 0x6C5D}, //14795 #CJK UNIFIED IDEOGRAPH
  {0xE6A4, 0xF984}, //14796 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6A5, 0x74B5}, //14797 #CJK UNIFIED IDEOGRAPH
  {0xE6A6, 0x7916}, //14798 #CJK UNIFIED IDEOGRAPH
  {0xE6A7, 0xF985}, //14799 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6A8, 0x8207}, //14800 #CJK UNIFIED IDEOGRAPH
  {0xE6A9, 0x8245}, //14801 #CJK UNIFIED IDEOGRAPH
  {0xE6AA, 0x8339}, //14802 #CJK UNIFIED IDEOGRAPH
  {0xE6AB, 0x8F3F}, //14803 #CJK UNIFIED IDEOGRAPH
  {0xE6AC, 0x8F5D}, //14804 #CJK UNIFIED IDEOGRAPH
  {0xE6AD, 0xF986}, //14805 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6AE, 0x9918}, //14806 #CJK UNIFIED IDEOGRAPH
  {0xE6AF, 0xF987}, //14807 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B0, 0xF988}, //14808 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B1, 0xF989}, //14809 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B2, 0x4EA6}, //14810 #CJK UNIFIED IDEOGRAPH
  {0xE6B3, 0xF98A}, //14811 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B4, 0x57DF}, //14812 #CJK UNIFIED IDEOGRAPH
  {0xE6B5, 0x5F79}, //14813 #CJK UNIFIED IDEOGRAPH
  {0xE6B6, 0x6613}, //14814 #CJK UNIFIED IDEOGRAPH
  {0xE6B7, 0xF98B}, //14815 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B8, 0xF98C}, //14816 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6B9, 0x75AB}, //14817 #CJK UNIFIED IDEOGRAPH
  {0xE6BA, 0x7E79}, //14818 #CJK UNIFIED IDEOGRAPH
  {0xE6BB, 0x8B6F}, //14819 #CJK UNIFIED IDEOGRAPH
  {0xE6BC, 0xF98D}, //14820 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6BD, 0x9006}, //14821 #CJK UNIFIED IDEOGRAPH
  {0xE6BE, 0x9A5B}, //14822 #CJK UNIFIED IDEOGRAPH
  {0xE6BF, 0x56A5}, //14823 #CJK UNIFIED IDEOGRAPH
  {0xE6C0, 0x5827}, //14824 #CJK UNIFIED IDEOGRAPH
  {0xE6C1, 0x59F8}, //14825 #CJK UNIFIED IDEOGRAPH
  {0xE6C2, 0x5A1F}, //14826 #CJK UNIFIED IDEOGRAPH
  {0xE6C3, 0x5BB4}, //14827 #CJK UNIFIED IDEOGRAPH
  {0xE6C4, 0xF98E}, //14828 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6C5, 0x5EF6}, //14829 #CJK UNIFIED IDEOGRAPH
  {0xE6C6, 0xF98F}, //14830 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6C7, 0xF990}, //14831 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6C8, 0x6350}, //14832 #CJK UNIFIED IDEOGRAPH
  {0xE6C9, 0x633B}, //14833 #CJK UNIFIED IDEOGRAPH
  {0xE6CA, 0xF991}, //14834 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6CB, 0x693D}, //14835 #CJK UNIFIED IDEOGRAPH
  {0xE6CC, 0x6C87}, //14836 #CJK UNIFIED IDEOGRAPH
  {0xE6CD, 0x6CBF}, //14837 #CJK UNIFIED IDEOGRAPH
  {0xE6CE, 0x6D8E}, //14838 #CJK UNIFIED IDEOGRAPH
  {0xE6CF, 0x6D93}, //14839 #CJK UNIFIED IDEOGRAPH
  {0xE6D0, 0x6DF5}, //14840 #CJK UNIFIED IDEOGRAPH
  {0xE6D1, 0x6F14}, //14841 #CJK UNIFIED IDEOGRAPH
  {0xE6D2, 0xF992}, //14842 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6D3, 0x70DF}, //14843 #CJK UNIFIED IDEOGRAPH
  {0xE6D4, 0x7136}, //14844 #CJK UNIFIED IDEOGRAPH
  {0xE6D5, 0x7159}, //14845 #CJK UNIFIED IDEOGRAPH
  {0xE6D6, 0xF993}, //14846 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6D7, 0x71C3}, //14847 #CJK UNIFIED IDEOGRAPH
  {0xE6D8, 0x71D5}, //14848 #CJK UNIFIED IDEOGRAPH
  {0xE6D9, 0xF994}, //14849 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6DA, 0x784F}, //14850 #CJK UNIFIED IDEOGRAPH
  {0xE6DB, 0x786F}, //14851 #CJK UNIFIED IDEOGRAPH
  {0xE6DC, 0xF995}, //14852 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6DD, 0x7B75}, //14853 #CJK UNIFIED IDEOGRAPH
  {0xE6DE, 0x7DE3}, //14854 #CJK UNIFIED IDEOGRAPH
  {0xE6DF, 0xF996}, //14855 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E0, 0x7E2F}, //14856 #CJK UNIFIED IDEOGRAPH
  {0xE6E1, 0xF997}, //14857 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E2, 0x884D}, //14858 #CJK UNIFIED IDEOGRAPH
  {0xE6E3, 0x8EDF}, //14859 #CJK UNIFIED IDEOGRAPH
  {0xE6E4, 0xF998}, //14860 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E5, 0xF999}, //14861 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E6, 0xF99A}, //14862 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E7, 0x925B}, //14863 #CJK UNIFIED IDEOGRAPH
  {0xE6E8, 0xF99B}, //14864 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6E9, 0x9CF6}, //14865 #CJK UNIFIED IDEOGRAPH
  {0xE6EA, 0xF99C}, //14866 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6EB, 0xF99D}, //14867 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6EC, 0xF99E}, //14868 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6ED, 0x6085}, //14869 #CJK UNIFIED IDEOGRAPH
  {0xE6EE, 0x6D85}, //14870 #CJK UNIFIED IDEOGRAPH
  {0xE6EF, 0xF99F}, //14871 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F0, 0x71B1}, //14872 #CJK UNIFIED IDEOGRAPH
  {0xE6F1, 0xF9A0}, //14873 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F2, 0xF9A1}, //14874 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F3, 0x95B1}, //14875 #CJK UNIFIED IDEOGRAPH
  {0xE6F4, 0x53AD}, //14876 #CJK UNIFIED IDEOGRAPH
  {0xE6F5, 0xF9A2}, //14877 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F6, 0xF9A3}, //14878 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F7, 0xF9A4}, //14879 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6F8, 0x67D3}, //14880 #CJK UNIFIED IDEOGRAPH
  {0xE6F9, 0xF9A5}, //14881 #CJK COMPATIBILITY IDEOGRAPH
  {0xE6FA, 0x708E}, //14882 #CJK UNIFIED IDEOGRAPH
  {0xE6FB, 0x7130}, //14883 #CJK UNIFIED IDEOGRAPH
  {0xE6FC, 0x7430}, //14884 #CJK UNIFIED IDEOGRAPH
  {0xE6FD, 0x8276}, //14885 #CJK UNIFIED IDEOGRAPH
  {0xE6FE, 0x82D2}, //14886 #CJK UNIFIED IDEOGRAPH
  {0xE7A1, 0xF9A6}, //14887 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7A2, 0x95BB}, //14888 #CJK UNIFIED IDEOGRAPH
  {0xE7A3, 0x9AE5}, //14889 #CJK UNIFIED IDEOGRAPH
  {0xE7A4, 0x9E7D}, //14890 #CJK UNIFIED IDEOGRAPH
  {0xE7A5, 0x66C4}, //14891 #CJK UNIFIED IDEOGRAPH
  {0xE7A6, 0xF9A7}, //14892 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7A7, 0x71C1}, //14893 #CJK UNIFIED IDEOGRAPH
  {0xE7A8, 0x8449}, //14894 #CJK UNIFIED IDEOGRAPH
  {0xE7A9, 0xF9A8}, //14895 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7AA, 0xF9A9}, //14896 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7AB, 0x584B}, //14897 #CJK UNIFIED IDEOGRAPH
  {0xE7AC, 0xF9AA}, //14898 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7AD, 0xF9AB}, //14899 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7AE, 0x5DB8}, //14900 #CJK UNIFIED IDEOGRAPH
  {0xE7AF, 0x5F71}, //14901 #CJK UNIFIED IDEOGRAPH
  {0xE7B0, 0xF9AC}, //14902 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7B1, 0x6620}, //14903 #CJK UNIFIED IDEOGRAPH
  {0xE7B2, 0x668E}, //14904 #CJK UNIFIED IDEOGRAPH
  {0xE7B3, 0x6979}, //14905 #CJK UNIFIED IDEOGRAPH
  {0xE7B4, 0x69AE}, //14906 #CJK UNIFIED IDEOGRAPH
  {0xE7B5, 0x6C38}, //14907 #CJK UNIFIED IDEOGRAPH
  {0xE7B6, 0x6CF3}, //14908 #CJK UNIFIED IDEOGRAPH
  {0xE7B7, 0x6E36}, //14909 #CJK UNIFIED IDEOGRAPH
  {0xE7B8, 0x6F41}, //14910 #CJK UNIFIED IDEOGRAPH
  {0xE7B9, 0x6FDA}, //14911 #CJK UNIFIED IDEOGRAPH
  {0xE7BA, 0x701B}, //14912 #CJK UNIFIED IDEOGRAPH
  {0xE7BB, 0x702F}, //14913 #CJK UNIFIED IDEOGRAPH
  {0xE7BC, 0x7150}, //14914 #CJK UNIFIED IDEOGRAPH
  {0xE7BD, 0x71DF}, //14915 #CJK UNIFIED IDEOGRAPH
  {0xE7BE, 0x7370}, //14916 #CJK UNIFIED IDEOGRAPH
  {0xE7BF, 0xF9AD}, //14917 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7C0, 0x745B}, //14918 #CJK UNIFIED IDEOGRAPH
  {0xE7C1, 0xF9AE}, //14919 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7C2, 0x74D4}, //14920 #CJK UNIFIED IDEOGRAPH
  {0xE7C3, 0x76C8}, //14921 #CJK UNIFIED IDEOGRAPH
  {0xE7C4, 0x7A4E}, //14922 #CJK UNIFIED IDEOGRAPH
  {0xE7C5, 0x7E93}, //14923 #CJK UNIFIED IDEOGRAPH
  {0xE7C6, 0xF9AF}, //14924 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7C7, 0xF9B0}, //14925 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7C8, 0x82F1}, //14926 #CJK UNIFIED IDEOGRAPH
  {0xE7C9, 0x8A60}, //14927 #CJK UNIFIED IDEOGRAPH
  {0xE7CA, 0x8FCE}, //14928 #CJK UNIFIED IDEOGRAPH
  {0xE7CB, 0xF9B1}, //14929 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7CC, 0x9348}, //14930 #CJK UNIFIED IDEOGRAPH
  {0xE7CD, 0xF9B2}, //14931 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7CE, 0x9719}, //14932 #CJK UNIFIED IDEOGRAPH
  {0xE7CF, 0xF9B3}, //14933 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7D0, 0xF9B4}, //14934 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7D1, 0x4E42}, //14935 #CJK UNIFIED IDEOGRAPH
  {0xE7D2, 0x502A}, //14936 #CJK UNIFIED IDEOGRAPH
  {0xE7D3, 0xF9B5}, //14937 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7D4, 0x5208}, //14938 #CJK UNIFIED IDEOGRAPH
  {0xE7D5, 0x53E1}, //14939 #CJK UNIFIED IDEOGRAPH
  {0xE7D6, 0x66F3}, //14940 #CJK UNIFIED IDEOGRAPH
  {0xE7D7, 0x6C6D}, //14941 #CJK UNIFIED IDEOGRAPH
  {0xE7D8, 0x6FCA}, //14942 #CJK UNIFIED IDEOGRAPH
  {0xE7D9, 0x730A}, //14943 #CJK UNIFIED IDEOGRAPH
  {0xE7DA, 0x777F}, //14944 #CJK UNIFIED IDEOGRAPH
  {0xE7DB, 0x7A62}, //14945 #CJK UNIFIED IDEOGRAPH
  {0xE7DC, 0x82AE}, //14946 #CJK UNIFIED IDEOGRAPH
  {0xE7DD, 0x85DD}, //14947 #CJK UNIFIED IDEOGRAPH
  {0xE7DE, 0x8602}, //14948 #CJK UNIFIED IDEOGRAPH
  {0xE7DF, 0xF9B6}, //14949 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7E0, 0x88D4}, //14950 #CJK UNIFIED IDEOGRAPH
  {0xE7E1, 0x8A63}, //14951 #CJK UNIFIED IDEOGRAPH
  {0xE7E2, 0x8B7D}, //14952 #CJK UNIFIED IDEOGRAPH
  {0xE7E3, 0x8C6B}, //14953 #CJK UNIFIED IDEOGRAPH
  {0xE7E4, 0xF9B7}, //14954 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7E5, 0x92B3}, //14955 #CJK UNIFIED IDEOGRAPH
  {0xE7E6, 0xF9B8}, //14956 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7E7, 0x9713}, //14957 #CJK UNIFIED IDEOGRAPH
  {0xE7E8, 0x9810}, //14958 #CJK UNIFIED IDEOGRAPH
  {0xE7E9, 0x4E94}, //14959 #CJK UNIFIED IDEOGRAPH
  {0xE7EA, 0x4F0D}, //14960 #CJK UNIFIED IDEOGRAPH
  {0xE7EB, 0x4FC9}, //14961 #CJK UNIFIED IDEOGRAPH
  {0xE7EC, 0x50B2}, //14962 #CJK UNIFIED IDEOGRAPH
  {0xE7ED, 0x5348}, //14963 #CJK UNIFIED IDEOGRAPH
  {0xE7EE, 0x543E}, //14964 #CJK UNIFIED IDEOGRAPH
  {0xE7EF, 0x5433}, //14965 #CJK UNIFIED IDEOGRAPH
  {0xE7F0, 0x55DA}, //14966 #CJK UNIFIED IDEOGRAPH
  {0xE7F1, 0x5862}, //14967 #CJK UNIFIED IDEOGRAPH
  {0xE7F2, 0x58BA}, //14968 #CJK UNIFIED IDEOGRAPH
  {0xE7F3, 0x5967}, //14969 #CJK UNIFIED IDEOGRAPH
  {0xE7F4, 0x5A1B}, //14970 #CJK UNIFIED IDEOGRAPH
  {0xE7F5, 0x5BE4}, //14971 #CJK UNIFIED IDEOGRAPH
  {0xE7F6, 0x609F}, //14972 #CJK UNIFIED IDEOGRAPH
  {0xE7F7, 0xF9B9}, //14973 #CJK COMPATIBILITY IDEOGRAPH
  {0xE7F8, 0x61CA}, //14974 #CJK UNIFIED IDEOGRAPH
  {0xE7F9, 0x6556}, //14975 #CJK UNIFIED IDEOGRAPH
  {0xE7FA, 0x65FF}, //14976 #CJK UNIFIED IDEOGRAPH
  {0xE7FB, 0x6664}, //14977 #CJK UNIFIED IDEOGRAPH
  {0xE7FC, 0x68A7}, //14978 #CJK UNIFIED IDEOGRAPH
  {0xE7FD, 0x6C5A}, //14979 #CJK UNIFIED IDEOGRAPH
  {0xE7FE, 0x6FB3}, //14980 #CJK UNIFIED IDEOGRAPH
  {0xE8A1, 0x70CF}, //14981 #CJK UNIFIED IDEOGRAPH
  {0xE8A2, 0x71AC}, //14982 #CJK UNIFIED IDEOGRAPH
  {0xE8A3, 0x7352}, //14983 #CJK UNIFIED IDEOGRAPH
  {0xE8A4, 0x7B7D}, //14984 #CJK UNIFIED IDEOGRAPH
  {0xE8A5, 0x8708}, //14985 #CJK UNIFIED IDEOGRAPH
  {0xE8A6, 0x8AA4}, //14986 #CJK UNIFIED IDEOGRAPH
  {0xE8A7, 0x9C32}, //14987 #CJK UNIFIED IDEOGRAPH
  {0xE8A8, 0x9F07}, //14988 #CJK UNIFIED IDEOGRAPH
  {0xE8A9, 0x5C4B}, //14989 #CJK UNIFIED IDEOGRAPH
  {0xE8AA, 0x6C83}, //14990 #CJK UNIFIED IDEOGRAPH
  {0xE8AB, 0x7344}, //14991 #CJK UNIFIED IDEOGRAPH
  {0xE8AC, 0x7389}, //14992 #CJK UNIFIED IDEOGRAPH
  {0xE8AD, 0x923A}, //14993 #CJK UNIFIED IDEOGRAPH
  {0xE8AE, 0x6EAB}, //14994 #CJK UNIFIED IDEOGRAPH
  {0xE8AF, 0x7465}, //14995 #CJK UNIFIED IDEOGRAPH
  {0xE8B0, 0x761F}, //14996 #CJK UNIFIED IDEOGRAPH
  {0xE8B1, 0x7A69}, //14997 #CJK UNIFIED IDEOGRAPH
  {0xE8B2, 0x7E15}, //14998 #CJK UNIFIED IDEOGRAPH
  {0xE8B3, 0x860A}, //14999 #CJK UNIFIED IDEOGRAPH
  {0xE8B4, 0x5140}, //15000 #CJK UNIFIED IDEOGRAPH
  {0xE8B5, 0x58C5}, //15001 #CJK UNIFIED IDEOGRAPH
  {0xE8B6, 0x64C1}, //15002 #CJK UNIFIED IDEOGRAPH
  {0xE8B7, 0x74EE}, //15003 #CJK UNIFIED IDEOGRAPH
  {0xE8B8, 0x7515}, //15004 #CJK UNIFIED IDEOGRAPH
  {0xE8B9, 0x7670}, //15005 #CJK UNIFIED IDEOGRAPH
  {0xE8BA, 0x7FC1}, //15006 #CJK UNIFIED IDEOGRAPH
  {0xE8BB, 0x9095}, //15007 #CJK UNIFIED IDEOGRAPH
  {0xE8BC, 0x96CD}, //15008 #CJK UNIFIED IDEOGRAPH
  {0xE8BD, 0x9954}, //15009 #CJK UNIFIED IDEOGRAPH
  {0xE8BE, 0x6E26}, //15010 #CJK UNIFIED IDEOGRAPH
  {0xE8BF, 0x74E6}, //15011 #CJK UNIFIED IDEOGRAPH
  {0xE8C0, 0x7AA9}, //15012 #CJK UNIFIED IDEOGRAPH
  {0xE8C1, 0x7AAA}, //15013 #CJK UNIFIED IDEOGRAPH
  {0xE8C2, 0x81E5}, //15014 #CJK UNIFIED IDEOGRAPH
  {0xE8C3, 0x86D9}, //15015 #CJK UNIFIED IDEOGRAPH
  {0xE8C4, 0x8778}, //15016 #CJK UNIFIED IDEOGRAPH
  {0xE8C5, 0x8A1B}, //15017 #CJK UNIFIED IDEOGRAPH
  {0xE8C6, 0x5A49}, //15018 #CJK UNIFIED IDEOGRAPH
  {0xE8C7, 0x5B8C}, //15019 #CJK UNIFIED IDEOGRAPH
  {0xE8C8, 0x5B9B}, //15020 #CJK UNIFIED IDEOGRAPH
  {0xE8C9, 0x68A1}, //15021 #CJK UNIFIED IDEOGRAPH
  {0xE8CA, 0x6900}, //15022 #CJK UNIFIED IDEOGRAPH
  {0xE8CB, 0x6D63}, //15023 #CJK UNIFIED IDEOGRAPH
  {0xE8CC, 0x73A9}, //15024 #CJK UNIFIED IDEOGRAPH
  {0xE8CD, 0x7413}, //15025 #CJK UNIFIED IDEOGRAPH
  {0xE8CE, 0x742C}, //15026 #CJK UNIFIED IDEOGRAPH
  {0xE8CF, 0x7897}, //15027 #CJK UNIFIED IDEOGRAPH
  {0xE8D0, 0x7DE9}, //15028 #CJK UNIFIED IDEOGRAPH
  {0xE8D1, 0x7FEB}, //15029 #CJK UNIFIED IDEOGRAPH
  {0xE8D2, 0x8118}, //15030 #CJK UNIFIED IDEOGRAPH
  {0xE8D3, 0x8155}, //15031 #CJK UNIFIED IDEOGRAPH
  {0xE8D4, 0x839E}, //15032 #CJK UNIFIED IDEOGRAPH
  {0xE8D5, 0x8C4C}, //15033 #CJK UNIFIED IDEOGRAPH
  {0xE8D6, 0x962E}, //15034 #CJK UNIFIED IDEOGRAPH
  {0xE8D7, 0x9811}, //15035 #CJK UNIFIED IDEOGRAPH
  {0xE8D8, 0x66F0}, //15036 #CJK UNIFIED IDEOGRAPH
  {0xE8D9, 0x5F80}, //15037 #CJK UNIFIED IDEOGRAPH
  {0xE8DA, 0x65FA}, //15038 #CJK UNIFIED IDEOGRAPH
  {0xE8DB, 0x6789}, //15039 #CJK UNIFIED IDEOGRAPH
  {0xE8DC, 0x6C6A}, //15040 #CJK UNIFIED IDEOGRAPH
  {0xE8DD, 0x738B}, //15041 #CJK UNIFIED IDEOGRAPH
  {0xE8DE, 0x502D}, //15042 #CJK UNIFIED IDEOGRAPH
  {0xE8DF, 0x5A03}, //15043 #CJK UNIFIED IDEOGRAPH
  {0xE8E0, 0x6B6A}, //15044 #CJK UNIFIED IDEOGRAPH
  {0xE8E1, 0x77EE}, //15045 #CJK UNIFIED IDEOGRAPH
  {0xE8E2, 0x5916}, //15046 #CJK UNIFIED IDEOGRAPH
  {0xE8E3, 0x5D6C}, //15047 #CJK UNIFIED IDEOGRAPH
  {0xE8E4, 0x5DCD}, //15048 #CJK UNIFIED IDEOGRAPH
  {0xE8E5, 0x7325}, //15049 #CJK UNIFIED IDEOGRAPH
  {0xE8E6, 0x754F}, //15050 #CJK UNIFIED IDEOGRAPH
  {0xE8E7, 0xF9BA}, //15051 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8E8, 0xF9BB}, //15052 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8E9, 0x50E5}, //15053 #CJK UNIFIED IDEOGRAPH
  {0xE8EA, 0x51F9}, //15054 #CJK UNIFIED IDEOGRAPH
  {0xE8EB, 0x582F}, //15055 #CJK UNIFIED IDEOGRAPH
  {0xE8EC, 0x592D}, //15056 #CJK UNIFIED IDEOGRAPH
  {0xE8ED, 0x5996}, //15057 #CJK UNIFIED IDEOGRAPH
  {0xE8EE, 0x59DA}, //15058 #CJK UNIFIED IDEOGRAPH
  {0xE8EF, 0x5BE5}, //15059 #CJK UNIFIED IDEOGRAPH
  {0xE8F0, 0xF9BC}, //15060 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8F1, 0xF9BD}, //15061 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8F2, 0x5DA2}, //15062 #CJK UNIFIED IDEOGRAPH
  {0xE8F3, 0x62D7}, //15063 #CJK UNIFIED IDEOGRAPH
  {0xE8F4, 0x6416}, //15064 #CJK UNIFIED IDEOGRAPH
  {0xE8F5, 0x6493}, //15065 #CJK UNIFIED IDEOGRAPH
  {0xE8F6, 0x64FE}, //15066 #CJK UNIFIED IDEOGRAPH
  {0xE8F7, 0xF9BE}, //15067 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8F8, 0x66DC}, //15068 #CJK UNIFIED IDEOGRAPH
  {0xE8F9, 0xF9BF}, //15069 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8FA, 0x6A48}, //15070 #CJK UNIFIED IDEOGRAPH
  {0xE8FB, 0xF9C0}, //15071 #CJK COMPATIBILITY IDEOGRAPH
  {0xE8FC, 0x71FF}, //15072 #CJK UNIFIED IDEOGRAPH
  {0xE8FD, 0x7464}, //15073 #CJK UNIFIED IDEOGRAPH
  {0xE8FE, 0xF9C1}, //15074 #CJK COMPATIBILITY IDEOGRAPH
  {0xE9A1, 0x7A88}, //15075 #CJK UNIFIED IDEOGRAPH
  {0xE9A2, 0x7AAF}, //15076 #CJK UNIFIED IDEOGRAPH
  {0xE9A3, 0x7E47}, //15077 #CJK UNIFIED IDEOGRAPH
  {0xE9A4, 0x7E5E}, //15078 #CJK UNIFIED IDEOGRAPH
  {0xE9A5, 0x8000}, //15079 #CJK UNIFIED IDEOGRAPH
  {0xE9A6, 0x8170}, //15080 #CJK UNIFIED IDEOGRAPH
  {0xE9A7, 0xF9C2}, //15081 #CJK COMPATIBILITY IDEOGRAPH
  {0xE9A8, 0x87EF}, //15082 #CJK UNIFIED IDEOGRAPH
  {0xE9A9, 0x8981}, //15083 #CJK UNIFIED IDEOGRAPH
  {0xE9AA, 0x8B20}, //15084 #CJK UNIFIED IDEOGRAPH
  {0xE9AB, 0x9059}, //15085 #CJK UNIFIED IDEOGRAPH
  {0xE9AC, 0xF9C3}, //15086 #CJK COMPATIBILITY IDEOGRAPH
  {0xE9AD, 0x9080}, //15087 #CJK UNIFIED IDEOGRAPH
  {0xE9AE, 0x9952}, //15088 #CJK UNIFIED IDEOGRAPH
  {0xE9AF, 0x617E}, //15089 #CJK UNIFIED IDEOGRAPH
  {0xE9B0, 0x6B32}, //15090 #CJK UNIFIED IDEOGRAPH
  {0xE9B1, 0x6D74}, //15091 #CJK UNIFIED IDEOGRAPH
  {0xE9B2, 0x7E1F}, //15092 #CJK UNIFIED IDEOGRAPH
  {0xE9B3, 0x8925}, //15093 #CJK UNIFIED IDEOGRAPH
  {0xE9B4, 0x8FB1}, //15094 #CJK UNIFIED IDEOGRAPH
  {0xE9B5, 0x4FD1}, //15095 #CJK UNIFIED IDEOGRAPH
  {0xE9B6, 0x50AD}, //15096 #CJK UNIFIED IDEOGRAPH
  {0xE9B7, 0x5197}, //15097 #CJK UNIFIED IDEOGRAPH
  {0xE9B8, 0x52C7}, //15098 #CJK UNIFIED IDEOGRAPH
  {0xE9B9, 0x57C7}, //15099 #CJK UNIFIED IDEOGRAPH
  {0xE9BA, 0x5889}, //15100 #CJK UNIFIED IDEOGRAPH
  {0xE9BB, 0x5BB9}, //15101 #CJK UNIFIED IDEOGRAPH
  {0xE9BC, 0x5EB8}, //15102 #CJK UNIFIED IDEOGRAPH
  {0xE9BD, 0x6142}, //15103 #CJK UNIFIED IDEOGRAPH
  {0xE9BE, 0x6995}, //15104 #CJK UNIFIED IDEOGRAPH
  {0xE9BF, 0x6D8C}, //15105 #CJK UNIFIED IDEOGRAPH
  {0xE9C0, 0x6E67}, //15106 #CJK UNIFIED IDEOGRAPH
  {0xE9C1, 0x6EB6}, //15107 #CJK UNIFIED IDEOGRAPH
  {0xE9C2, 0x7194}, //15108 #CJK UNIFIED IDEOGRAPH
  {0xE9C3, 0x7462}, //15109 #CJK UNIFIED IDEOGRAPH
  {0xE9C4, 0x7528}, //15110 #CJK UNIFIED IDEOGRAPH
  {0xE9C5, 0x752C}, //15111 #CJK UNIFIED IDEOGRAPH
  {0xE9C6, 0x8073}, //15112 #CJK UNIFIED IDEOGRAPH
  {0xE9C7, 0x8338}, //15113 #CJK UNIFIED IDEOGRAPH
  {0xE9C8, 0x84C9}, //15114 #CJK UNIFIED IDEOGRAPH
  {0xE9C9, 0x8E0A}, //15115 #CJK UNIFIED IDEOGRAPH
  {0xE9CA, 0x9394}, //15116 #CJK UNIFIED IDEOGRAPH
  {0xE9CB, 0x93DE}, //15117 #CJK UNIFIED IDEOGRAPH
  {0xE9CC, 0xF9C4}, //15118 #CJK COMPATIBILITY IDEOGRAPH
  {0xE9CD, 0x4E8E}, //15119 #CJK UNIFIED IDEOGRAPH
  {0xE9CE, 0x4F51}, //15120 #CJK UNIFIED IDEOGRAPH
  {0xE9CF, 0x5076}, //15121 #CJK UNIFIED IDEOGRAPH
  {0xE9D0, 0x512A}, //15122 #CJK UNIFIED IDEOGRAPH
  {0xE9D1, 0x53C8}, //15123 #CJK UNIFIED IDEOGRAPH
  {0xE9D2, 0x53CB}, //15124 #CJK UNIFIED IDEOGRAPH
  {0xE9D3, 0x53F3}, //15125 #CJK UNIFIED IDEOGRAPH
  {0xE9D4, 0x5B87}, //15126 #CJK UNIFIED IDEOGRAPH
  {0xE9D5, 0x5BD3}, //15127 #CJK UNIFIED IDEOGRAPH
  {0xE9D6, 0x5C24}, //15128 #CJK UNIFIED IDEOGRAPH
  {0xE9D7, 0x611A}, //15129 #CJK UNIFIED IDEOGRAPH
  {0xE9D8, 0x6182}, //15130 #CJK UNIFIED IDEOGRAPH
  {0xE9D9, 0x65F4}, //15131 #CJK UNIFIED IDEOGRAPH
  {0xE9DA, 0x725B}, //15132 #CJK UNIFIED IDEOGRAPH
  {0xE9DB, 0x7397}, //15133 #CJK UNIFIED IDEOGRAPH
  {0xE9DC, 0x7440}, //15134 #CJK UNIFIED IDEOGRAPH
  {0xE9DD, 0x76C2}, //15135 #CJK UNIFIED IDEOGRAPH
  {0xE9DE, 0x7950}, //15136 #CJK UNIFIED IDEOGRAPH
  {0xE9DF, 0x7991}, //15137 #CJK UNIFIED IDEOGRAPH
  {0xE9E0, 0x79B9}, //15138 #CJK UNIFIED IDEOGRAPH
  {0xE9E1, 0x7D06}, //15139 #CJK UNIFIED IDEOGRAPH
  {0xE9E2, 0x7FBD}, //15140 #CJK UNIFIED IDEOGRAPH
  {0xE9E3, 0x828B}, //15141 #CJK UNIFIED IDEOGRAPH
  {0xE9E4, 0x85D5}, //15142 #CJK UNIFIED IDEOGRAPH
  {0xE9E5, 0x865E}, //15143 #CJK UNIFIED IDEOGRAPH
  {0xE9E6, 0x8FC2}, //15144 #CJK UNIFIED IDEOGRAPH
  {0xE9E7, 0x9047}, //15145 #CJK UNIFIED IDEOGRAPH
  {0xE9E8, 0x90F5}, //15146 #CJK UNIFIED IDEOGRAPH
  {0xE9E9, 0x91EA}, //15147 #CJK UNIFIED IDEOGRAPH
  {0xE9EA, 0x9685}, //15148 #CJK UNIFIED IDEOGRAPH
  {0xE9EB, 0x96E8}, //15149 #CJK UNIFIED IDEOGRAPH
  {0xE9EC, 0x96E9}, //15150 #CJK UNIFIED IDEOGRAPH
  {0xE9ED, 0x52D6}, //15151 #CJK UNIFIED IDEOGRAPH
  {0xE9EE, 0x5F67}, //15152 #CJK UNIFIED IDEOGRAPH
  {0xE9EF, 0x65ED}, //15153 #CJK UNIFIED IDEOGRAPH
  {0xE9F0, 0x6631}, //15154 #CJK UNIFIED IDEOGRAPH
  {0xE9F1, 0x682F}, //15155 #CJK UNIFIED IDEOGRAPH
  {0xE9F2, 0x715C}, //15156 #CJK UNIFIED IDEOGRAPH
  {0xE9F3, 0x7A36}, //15157 #CJK UNIFIED IDEOGRAPH
  {0xE9F4, 0x90C1}, //15158 #CJK UNIFIED IDEOGRAPH
  {0xE9F5, 0x980A}, //15159 #CJK UNIFIED IDEOGRAPH
  {0xE9F6, 0x4E91}, //15160 #CJK UNIFIED IDEOGRAPH
  {0xE9F7, 0xF9C5}, //15161 #CJK COMPATIBILITY IDEOGRAPH
  {0xE9F8, 0x6A52}, //15162 #CJK UNIFIED IDEOGRAPH
  {0xE9F9, 0x6B9E}, //15163 #CJK UNIFIED IDEOGRAPH
  {0xE9FA, 0x6F90}, //15164 #CJK UNIFIED IDEOGRAPH
  {0xE9FB, 0x7189}, //15165 #CJK UNIFIED IDEOGRAPH
  {0xE9FC, 0x8018}, //15166 #CJK UNIFIED IDEOGRAPH
  {0xE9FD, 0x82B8}, //15167 #CJK UNIFIED IDEOGRAPH
  {0xE9FE, 0x8553}, //15168 #CJK UNIFIED IDEOGRAPH
  {0xEAA1, 0x904B}, //15169 #CJK UNIFIED IDEOGRAPH
  {0xEAA2, 0x9695}, //15170 #CJK UNIFIED IDEOGRAPH
  {0xEAA3, 0x96F2}, //15171 #CJK UNIFIED IDEOGRAPH
  {0xEAA4, 0x97FB}, //15172 #CJK UNIFIED IDEOGRAPH
  {0xEAA5, 0x851A}, //15173 #CJK UNIFIED IDEOGRAPH
  {0xEAA6, 0x9B31}, //15174 #CJK UNIFIED IDEOGRAPH
  {0xEAA7, 0x4E90}, //15175 #CJK UNIFIED IDEOGRAPH
  {0xEAA8, 0x718A}, //15176 #CJK UNIFIED IDEOGRAPH
  {0xEAA9, 0x96C4}, //15177 #CJK UNIFIED IDEOGRAPH
  {0xEAAA, 0x5143}, //15178 #CJK UNIFIED IDEOGRAPH
  {0xEAAB, 0x539F}, //15179 #CJK UNIFIED IDEOGRAPH
  {0xEAAC, 0x54E1}, //15180 #CJK UNIFIED IDEOGRAPH
  {0xEAAD, 0x5713}, //15181 #CJK UNIFIED IDEOGRAPH
  {0xEAAE, 0x5712}, //15182 #CJK UNIFIED IDEOGRAPH
  {0xEAAF, 0x57A3}, //15183 #CJK UNIFIED IDEOGRAPH
  {0xEAB0, 0x5A9B}, //15184 #CJK UNIFIED IDEOGRAPH
  {0xEAB1, 0x5AC4}, //15185 #CJK UNIFIED IDEOGRAPH
  {0xEAB2, 0x5BC3}, //15186 #CJK UNIFIED IDEOGRAPH
  {0xEAB3, 0x6028}, //15187 #CJK UNIFIED IDEOGRAPH
  {0xEAB4, 0x613F}, //15188 #CJK UNIFIED IDEOGRAPH
  {0xEAB5, 0x63F4}, //15189 #CJK UNIFIED IDEOGRAPH
  {0xEAB6, 0x6C85}, //15190 #CJK UNIFIED IDEOGRAPH
  {0xEAB7, 0x6D39}, //15191 #CJK UNIFIED IDEOGRAPH
  {0xEAB8, 0x6E72}, //15192 #CJK UNIFIED IDEOGRAPH
  {0xEAB9, 0x6E90}, //15193 #CJK UNIFIED IDEOGRAPH
  {0xEABA, 0x7230}, //15194 #CJK UNIFIED IDEOGRAPH
  {0xEABB, 0x733F}, //15195 #CJK UNIFIED IDEOGRAPH
  {0xEABC, 0x7457}, //15196 #CJK UNIFIED IDEOGRAPH
  {0xEABD, 0x82D1}, //15197 #CJK UNIFIED IDEOGRAPH
  {0xEABE, 0x8881}, //15198 #CJK UNIFIED IDEOGRAPH
  {0xEABF, 0x8F45}, //15199 #CJK UNIFIED IDEOGRAPH
  {0xEAC0, 0x9060}, //15200 #CJK UNIFIED IDEOGRAPH
  {0xEAC1, 0xF9C6}, //15201 #CJK COMPATIBILITY IDEOGRAPH
  {0xEAC2, 0x9662}, //15202 #CJK UNIFIED IDEOGRAPH
  {0xEAC3, 0x9858}, //15203 #CJK UNIFIED IDEOGRAPH
  {0xEAC4, 0x9D1B}, //15204 #CJK UNIFIED IDEOGRAPH
  {0xEAC5, 0x6708}, //15205 #CJK UNIFIED IDEOGRAPH
  {0xEAC6, 0x8D8A}, //15206 #CJK UNIFIED IDEOGRAPH
  {0xEAC7, 0x925E}, //15207 #CJK UNIFIED IDEOGRAPH
  {0xEAC8, 0x4F4D}, //15208 #CJK UNIFIED IDEOGRAPH
  {0xEAC9, 0x5049}, //15209 #CJK UNIFIED IDEOGRAPH
  {0xEACA, 0x50DE}, //15210 #CJK UNIFIED IDEOGRAPH
  {0xEACB, 0x5371}, //15211 #CJK UNIFIED IDEOGRAPH
  {0xEACC, 0x570D}, //15212 #CJK UNIFIED IDEOGRAPH
  {0xEACD, 0x59D4}, //15213 #CJK UNIFIED IDEOGRAPH
  {0xEACE, 0x5A01}, //15214 #CJK UNIFIED IDEOGRAPH
  {0xEACF, 0x5C09}, //15215 #CJK UNIFIED IDEOGRAPH
  {0xEAD0, 0x6170}, //15216 #CJK UNIFIED IDEOGRAPH
  {0xEAD1, 0x6690}, //15217 #CJK UNIFIED IDEOGRAPH
  {0xEAD2, 0x6E2D}, //15218 #CJK UNIFIED IDEOGRAPH
  {0xEAD3, 0x7232}, //15219 #CJK UNIFIED IDEOGRAPH
  {0xEAD4, 0x744B}, //15220 #CJK UNIFIED IDEOGRAPH
  {0xEAD5, 0x7DEF}, //15221 #CJK UNIFIED IDEOGRAPH
  {0xEAD6, 0x80C3}, //15222 #CJK UNIFIED IDEOGRAPH
  {0xEAD7, 0x840E}, //15223 #CJK UNIFIED IDEOGRAPH
  {0xEAD8, 0x8466}, //15224 #CJK UNIFIED IDEOGRAPH
  {0xEAD9, 0x853F}, //15225 #CJK UNIFIED IDEOGRAPH
  {0xEADA, 0x875F}, //15226 #CJK UNIFIED IDEOGRAPH
  {0xEADB, 0x885B}, //15227 #CJK UNIFIED IDEOGRAPH
  {0xEADC, 0x8918}, //15228 #CJK UNIFIED IDEOGRAPH
  {0xEADD, 0x8B02}, //15229 #CJK UNIFIED IDEOGRAPH
  {0xEADE, 0x9055}, //15230 #CJK UNIFIED IDEOGRAPH
  {0xEADF, 0x97CB}, //15231 #CJK UNIFIED IDEOGRAPH
  {0xEAE0, 0x9B4F}, //15232 #CJK UNIFIED IDEOGRAPH
  {0xEAE1, 0x4E73}, //15233 #CJK UNIFIED IDEOGRAPH
  {0xEAE2, 0x4F91}, //15234 #CJK UNIFIED IDEOGRAPH
  {0xEAE3, 0x5112}, //15235 #CJK UNIFIED IDEOGRAPH
  {0xEAE4, 0x516A}, //15236 #CJK UNIFIED IDEOGRAPH
  {0xEAE5, 0xF9C7}, //15237 #CJK COMPATIBILITY IDEOGRAPH
  {0xEAE6, 0x552F}, //15238 #CJK UNIFIED IDEOGRAPH
  {0xEAE7, 0x55A9}, //15239 #CJK UNIFIED IDEOGRAPH
  {0xEAE8, 0x5B7A}, //15240 #CJK UNIFIED IDEOGRAPH
  {0xEAE9, 0x5BA5}, //15241 #CJK UNIFIED IDEOGRAPH
  {0xEAEA, 0x5E7C}, //15242 #CJK UNIFIED IDEOGRAPH
  {0xEAEB, 0x5E7D}, //15243 #CJK UNIFIED IDEOGRAPH
  {0xEAEC, 0x5EBE}, //15244 #CJK UNIFIED IDEOGRAPH
  {0xEAED, 0x60A0}, //15245 #CJK UNIFIED IDEOGRAPH
  {0xEAEE, 0x60DF}, //15246 #CJK UNIFIED IDEOGRAPH
  {0xEAEF, 0x6108}, //15247 #CJK UNIFIED IDEOGRAPH
  {0xEAF0, 0x6109}, //15248 #CJK UNIFIED IDEOGRAPH
  {0xEAF1, 0x63C4}, //15249 #CJK UNIFIED IDEOGRAPH
  {0xEAF2, 0x6538}, //15250 #CJK UNIFIED IDEOGRAPH
  {0xEAF3, 0x6709}, //15251 #CJK UNIFIED IDEOGRAPH
  {0xEAF4, 0xF9C8}, //15252 #CJK COMPATIBILITY IDEOGRAPH
  {0xEAF5, 0x67D4}, //15253 #CJK UNIFIED IDEOGRAPH
  {0xEAF6, 0x67DA}, //15254 #CJK UNIFIED IDEOGRAPH
  {0xEAF7, 0xF9C9}, //15255 #CJK COMPATIBILITY IDEOGRAPH
  {0xEAF8, 0x6961}, //15256 #CJK UNIFIED IDEOGRAPH
  {0xEAF9, 0x6962}, //15257 #CJK UNIFIED IDEOGRAPH
  {0xEAFA, 0x6CB9}, //15258 #CJK UNIFIED IDEOGRAPH
  {0xEAFB, 0x6D27}, //15259 #CJK UNIFIED IDEOGRAPH
  {0xEAFC, 0xF9CA}, //15260 #CJK COMPATIBILITY IDEOGRAPH
  {0xEAFD, 0x6E38}, //15261 #CJK UNIFIED IDEOGRAPH
  {0xEAFE, 0xF9CB}, //15262 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBA1, 0x6FE1}, //15263 #CJK UNIFIED IDEOGRAPH
  {0xEBA2, 0x7336}, //15264 #CJK UNIFIED IDEOGRAPH
  {0xEBA3, 0x7337}, //15265 #CJK UNIFIED IDEOGRAPH
  {0xEBA4, 0xF9CC}, //15266 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBA5, 0x745C}, //15267 #CJK UNIFIED IDEOGRAPH
  {0xEBA6, 0x7531}, //15268 #CJK UNIFIED IDEOGRAPH
  {0xEBA7, 0xF9CD}, //15269 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBA8, 0x7652}, //15270 #CJK UNIFIED IDEOGRAPH
  {0xEBA9, 0xF9CE}, //15271 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBAA, 0xF9CF}, //15272 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBAB, 0x7DAD}, //15273 #CJK UNIFIED IDEOGRAPH
  {0xEBAC, 0x81FE}, //15274 #CJK UNIFIED IDEOGRAPH
  {0xEBAD, 0x8438}, //15275 #CJK UNIFIED IDEOGRAPH
  {0xEBAE, 0x88D5}, //15276 #CJK UNIFIED IDEOGRAPH
  {0xEBAF, 0x8A98}, //15277 #CJK UNIFIED IDEOGRAPH
  {0xEBB0, 0x8ADB}, //15278 #CJK UNIFIED IDEOGRAPH
  {0xEBB1, 0x8AED}, //15279 #CJK UNIFIED IDEOGRAPH
  {0xEBB2, 0x8E30}, //15280 #CJK UNIFIED IDEOGRAPH
  {0xEBB3, 0x8E42}, //15281 #CJK UNIFIED IDEOGRAPH
  {0xEBB4, 0x904A}, //15282 #CJK UNIFIED IDEOGRAPH
  {0xEBB5, 0x903E}, //15283 #CJK UNIFIED IDEOGRAPH
  {0xEBB6, 0x907A}, //15284 #CJK UNIFIED IDEOGRAPH
  {0xEBB7, 0x9149}, //15285 #CJK UNIFIED IDEOGRAPH
  {0xEBB8, 0x91C9}, //15286 #CJK UNIFIED IDEOGRAPH
  {0xEBB9, 0x936E}, //15287 #CJK UNIFIED IDEOGRAPH
  {0xEBBA, 0xF9D0}, //15288 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBBB, 0xF9D1}, //15289 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBBC, 0x5809}, //15290 #CJK UNIFIED IDEOGRAPH
  {0xEBBD, 0xF9D2}, //15291 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBBE, 0x6BD3}, //15292 #CJK UNIFIED IDEOGRAPH
  {0xEBBF, 0x8089}, //15293 #CJK UNIFIED IDEOGRAPH
  {0xEBC0, 0x80B2}, //15294 #CJK UNIFIED IDEOGRAPH
  {0xEBC1, 0xF9D3}, //15295 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBC2, 0xF9D4}, //15296 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBC3, 0x5141}, //15297 #CJK UNIFIED IDEOGRAPH
  {0xEBC4, 0x596B}, //15298 #CJK UNIFIED IDEOGRAPH
  {0xEBC5, 0x5C39}, //15299 #CJK UNIFIED IDEOGRAPH
  {0xEBC6, 0xF9D5}, //15300 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBC7, 0xF9D6}, //15301 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBC8, 0x6F64}, //15302 #CJK UNIFIED IDEOGRAPH
  {0xEBC9, 0x73A7}, //15303 #CJK UNIFIED IDEOGRAPH
  {0xEBCA, 0x80E4}, //15304 #CJK UNIFIED IDEOGRAPH
  {0xEBCB, 0x8D07}, //15305 #CJK UNIFIED IDEOGRAPH
  {0xEBCC, 0xF9D7}, //15306 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBCD, 0x9217}, //15307 #CJK UNIFIED IDEOGRAPH
  {0xEBCE, 0x958F}, //15308 #CJK UNIFIED IDEOGRAPH
  {0xEBCF, 0xF9D8}, //15309 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBD0, 0xF9D9}, //15310 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBD1, 0xF9DA}, //15311 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBD2, 0xF9DB}, //15312 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBD3, 0x807F}, //15313 #CJK UNIFIED IDEOGRAPH
  {0xEBD4, 0x620E}, //15314 #CJK UNIFIED IDEOGRAPH
  {0xEBD5, 0x701C}, //15315 #CJK UNIFIED IDEOGRAPH
  {0xEBD6, 0x7D68}, //15316 #CJK UNIFIED IDEOGRAPH
  {0xEBD7, 0x878D}, //15317 #CJK UNIFIED IDEOGRAPH
  {0xEBD8, 0xF9DC}, //15318 #CJK COMPATIBILITY IDEOGRAPH
  {0xEBD9, 0x57A0}, //15319 #CJK UNIFIED IDEOGRAPH
  {0xEBDA, 0x6069}, //15320 #CJK UNIFIED IDEOGRAPH
  {0xEBDB, 0x6147}, //15321 #CJK UNIFIED IDEOGRAPH
  {0xEBDC, 0x6BB7}, //15322 #CJK UNIFIED IDEOGRAPH
  {0xEBDD, 0x8ABE}, //15323 #CJK UNIFIED IDEOGRAPH
  {0xEBDE, 0x9280}, //15324 #CJK UNIFIED IDEOGRAPH
  {0xEBDF, 0x96B1}, //15325 #CJK UNIFIED IDEOGRAPH
  {0xEBE0, 0x4E59}, //15326 #CJK UNIFIED IDEOGRAPH
  {0xEBE1, 0x541F}, //15327 #CJK UNIFIED IDEOGRAPH
  {0xEBE2, 0x6DEB}, //15328 #CJK UNIFIED IDEOGRAPH
  {0xEBE3, 0x852D}, //15329 #CJK UNIFIED IDEOGRAPH
  {0xEBE4, 0x9670}, //15330 #CJK UNIFIED IDEOGRAPH
  {0xEBE5, 0x97F3}, //15331 #CJK UNIFIED IDEOGRAPH
  {0xEBE6, 0x98EE}, //15332 #CJK UNIFIED IDEOGRAPH
  {0xEBE7, 0x63D6}, //15333 #CJK UNIFIED IDEOGRAPH
  {0xEBE8, 0x6CE3}, //15334 #CJK UNIFIED IDEOGRAPH
  {0xEBE9, 0x9091}, //15335 #CJK UNIFIED IDEOGRAPH
  {0xEBEA, 0x51DD}, //15336 #CJK UNIFIED IDEOGRAPH
  {0xEBEB, 0x61C9}, //15337 #CJK UNIFIED IDEOGRAPH
  {0xEBEC, 0x81BA}, //15338 #CJK UNIFIED IDEOGRAPH
  {0xEBED, 0x9DF9}, //15339 #CJK UNIFIED IDEOGRAPH
  {0xEBEE, 0x4F9D}, //15340 #CJK UNIFIED IDEOGRAPH
  {0xEBEF, 0x501A}, //15341 #CJK UNIFIED IDEOGRAPH
  {0xEBF0, 0x5100}, //15342 #CJK UNIFIED IDEOGRAPH
  {0xEBF1, 0x5B9C}, //15343 #CJK UNIFIED IDEOGRAPH
  {0xEBF2, 0x610F}, //15344 #CJK UNIFIED IDEOGRAPH
  {0xEBF3, 0x61FF}, //15345 #CJK UNIFIED IDEOGRAPH
  {0xEBF4, 0x64EC}, //15346 #CJK UNIFIED IDEOGRAPH
  {0xEBF5, 0x6905}, //15347 #CJK UNIFIED IDEOGRAPH
  {0xEBF6, 0x6BC5}, //15348 #CJK UNIFIED IDEOGRAPH
  {0xEBF7, 0x7591}, //15349 #CJK UNIFIED IDEOGRAPH
  {0xEBF8, 0x77E3}, //15350 #CJK UNIFIED IDEOGRAPH
  {0xEBF9, 0x7FA9}, //15351 #CJK UNIFIED IDEOGRAPH
  {0xEBFA, 0x8264}, //15352 #CJK UNIFIED IDEOGRAPH
  {0xEBFB, 0x858F}, //15353 #CJK UNIFIED IDEOGRAPH
  {0xEBFC, 0x87FB}, //15354 #CJK UNIFIED IDEOGRAPH
  {0xEBFD, 0x8863}, //15355 #CJK UNIFIED IDEOGRAPH
  {0xEBFE, 0x8ABC}, //15356 #CJK UNIFIED IDEOGRAPH
  {0xECA1, 0x8B70}, //15357 #CJK UNIFIED IDEOGRAPH
  {0xECA2, 0x91AB}, //15358 #CJK UNIFIED IDEOGRAPH
  {0xECA3, 0x4E8C}, //15359 #CJK UNIFIED IDEOGRAPH
  {0xECA4, 0x4EE5}, //15360 #CJK UNIFIED IDEOGRAPH
  {0xECA5, 0x4F0A}, //15361 #CJK UNIFIED IDEOGRAPH
  {0xECA6, 0xF9DD}, //15362 #CJK COMPATIBILITY IDEOGRAPH
  {0xECA7, 0xF9DE}, //15363 #CJK COMPATIBILITY IDEOGRAPH
  {0xECA8, 0x5937}, //15364 #CJK UNIFIED IDEOGRAPH
  {0xECA9, 0x59E8}, //15365 #CJK UNIFIED IDEOGRAPH
  {0xECAA, 0xF9DF}, //15366 #CJK COMPATIBILITY IDEOGRAPH
  {0xECAB, 0x5DF2}, //15367 #CJK UNIFIED IDEOGRAPH
  {0xECAC, 0x5F1B}, //15368 #CJK UNIFIED IDEOGRAPH
  {0xECAD, 0x5F5B}, //15369 #CJK UNIFIED IDEOGRAPH
  {0xECAE, 0x6021}, //15370 #CJK UNIFIED IDEOGRAPH
  {0xECAF, 0xF9E0}, //15371 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB0, 0xF9E1}, //15372 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB1, 0xF9E2}, //15373 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB2, 0xF9E3}, //15374 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB3, 0x723E}, //15375 #CJK UNIFIED IDEOGRAPH
  {0xECB4, 0x73E5}, //15376 #CJK UNIFIED IDEOGRAPH
  {0xECB5, 0xF9E4}, //15377 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB6, 0x7570}, //15378 #CJK UNIFIED IDEOGRAPH
  {0xECB7, 0x75CD}, //15379 #CJK UNIFIED IDEOGRAPH
  {0xECB8, 0xF9E5}, //15380 #CJK COMPATIBILITY IDEOGRAPH
  {0xECB9, 0x79FB}, //15381 #CJK UNIFIED IDEOGRAPH
  {0xECBA, 0xF9E6}, //15382 #CJK COMPATIBILITY IDEOGRAPH
  {0xECBB, 0x800C}, //15383 #CJK UNIFIED IDEOGRAPH
  {0xECBC, 0x8033}, //15384 #CJK UNIFIED IDEOGRAPH
  {0xECBD, 0x8084}, //15385 #CJK UNIFIED IDEOGRAPH
  {0xECBE, 0x82E1}, //15386 #CJK UNIFIED IDEOGRAPH
  {0xECBF, 0x8351}, //15387 #CJK UNIFIED IDEOGRAPH
  {0xECC0, 0xF9E7}, //15388 #CJK COMPATIBILITY IDEOGRAPH
  {0xECC1, 0xF9E8}, //15389 #CJK COMPATIBILITY IDEOGRAPH
  {0xECC2, 0x8CBD}, //15390 #CJK UNIFIED IDEOGRAPH
  {0xECC3, 0x8CB3}, //15391 #CJK UNIFIED IDEOGRAPH
  {0xECC4, 0x9087}, //15392 #CJK UNIFIED IDEOGRAPH
  {0xECC5, 0xF9E9}, //15393 #CJK COMPATIBILITY IDEOGRAPH
  {0xECC6, 0xF9EA}, //15394 #CJK COMPATIBILITY IDEOGRAPH
  {0xECC7, 0x98F4}, //15395 #CJK UNIFIED IDEOGRAPH
  {0xECC8, 0x990C}, //15396 #CJK UNIFIED IDEOGRAPH
  {0xECC9, 0xF9EB}, //15397 #CJK COMPATIBILITY IDEOGRAPH
  {0xECCA, 0xF9EC}, //15398 #CJK COMPATIBILITY IDEOGRAPH
  {0xECCB, 0x7037}, //15399 #CJK UNIFIED IDEOGRAPH
  {0xECCC, 0x76CA}, //15400 #CJK UNIFIED IDEOGRAPH
  {0xECCD, 0x7FCA}, //15401 #CJK UNIFIED IDEOGRAPH
  {0xECCE, 0x7FCC}, //15402 #CJK UNIFIED IDEOGRAPH
  {0xECCF, 0x7FFC}, //15403 #CJK UNIFIED IDEOGRAPH
  {0xECD0, 0x8B1A}, //15404 #CJK UNIFIED IDEOGRAPH
  {0xECD1, 0x4EBA}, //15405 #CJK UNIFIED IDEOGRAPH
  {0xECD2, 0x4EC1}, //15406 #CJK UNIFIED IDEOGRAPH
  {0xECD3, 0x5203}, //15407 #CJK UNIFIED IDEOGRAPH
  {0xECD4, 0x5370}, //15408 #CJK UNIFIED IDEOGRAPH
  {0xECD5, 0xF9ED}, //15409 #CJK COMPATIBILITY IDEOGRAPH
  {0xECD6, 0x54BD}, //15410 #CJK UNIFIED IDEOGRAPH
  {0xECD7, 0x56E0}, //15411 #CJK UNIFIED IDEOGRAPH
  {0xECD8, 0x59FB}, //15412 #CJK UNIFIED IDEOGRAPH
  {0xECD9, 0x5BC5}, //15413 #CJK UNIFIED IDEOGRAPH
  {0xECDA, 0x5F15}, //15414 #CJK UNIFIED IDEOGRAPH
  {0xECDB, 0x5FCD}, //15415 #CJK UNIFIED IDEOGRAPH
  {0xECDC, 0x6E6E}, //15416 #CJK UNIFIED IDEOGRAPH
  {0xECDD, 0xF9EE}, //15417 #CJK COMPATIBILITY IDEOGRAPH
  {0xECDE, 0xF9EF}, //15418 #CJK COMPATIBILITY IDEOGRAPH
  {0xECDF, 0x7D6A}, //15419 #CJK UNIFIED IDEOGRAPH
  {0xECE0, 0x8335}, //15420 #CJK UNIFIED IDEOGRAPH
  {0xECE1, 0xF9F0}, //15421 #CJK COMPATIBILITY IDEOGRAPH
  {0xECE2, 0x8693}, //15422 #CJK UNIFIED IDEOGRAPH
  {0xECE3, 0x8A8D}, //15423 #CJK UNIFIED IDEOGRAPH
  {0xECE4, 0xF9F1}, //15424 #CJK COMPATIBILITY IDEOGRAPH
  {0xECE5, 0x976D}, //15425 #CJK UNIFIED IDEOGRAPH
  {0xECE6, 0x9777}, //15426 #CJK UNIFIED IDEOGRAPH
  {0xECE7, 0xF9F2}, //15427 #CJK COMPATIBILITY IDEOGRAPH
  {0xECE8, 0xF9F3}, //15428 #CJK COMPATIBILITY IDEOGRAPH
  {0xECE9, 0x4E00}, //15429 #CJK UNIFIED IDEOGRAPH
  {0xECEA, 0x4F5A}, //15430 #CJK UNIFIED IDEOGRAPH
  {0xECEB, 0x4F7E}, //15431 #CJK UNIFIED IDEOGRAPH
  {0xECEC, 0x58F9}, //15432 #CJK UNIFIED IDEOGRAPH
  {0xECED, 0x65E5}, //15433 #CJK UNIFIED IDEOGRAPH
  {0xECEE, 0x6EA2}, //15434 #CJK UNIFIED IDEOGRAPH
  {0xECEF, 0x9038}, //15435 #CJK UNIFIED IDEOGRAPH
  {0xECF0, 0x93B0}, //15436 #CJK UNIFIED IDEOGRAPH
  {0xECF1, 0x99B9}, //15437 #CJK UNIFIED IDEOGRAPH
  {0xECF2, 0x4EFB}, //15438 #CJK UNIFIED IDEOGRAPH
  {0xECF3, 0x58EC}, //15439 #CJK UNIFIED IDEOGRAPH
  {0xECF4, 0x598A}, //15440 #CJK UNIFIED IDEOGRAPH
  {0xECF5, 0x59D9}, //15441 #CJK UNIFIED IDEOGRAPH
  {0xECF6, 0x6041}, //15442 #CJK UNIFIED IDEOGRAPH
  {0xECF7, 0xF9F4}, //15443 #CJK COMPATIBILITY IDEOGRAPH
  {0xECF8, 0xF9F5}, //15444 #CJK COMPATIBILITY IDEOGRAPH
  {0xECF9, 0x7A14}, //15445 #CJK UNIFIED IDEOGRAPH
  {0xECFA, 0xF9F6}, //15446 #CJK COMPATIBILITY IDEOGRAPH
  {0xECFB, 0x834F}, //15447 #CJK UNIFIED IDEOGRAPH
  {0xECFC, 0x8CC3}, //15448 #CJK UNIFIED IDEOGRAPH
  {0xECFD, 0x5165}, //15449 #CJK UNIFIED IDEOGRAPH
  {0xECFE, 0x5344}, //15450 #CJK UNIFIED IDEOGRAPH
  {0xEDA1, 0xF9F7}, //15451 #CJK COMPATIBILITY IDEOGRAPH
  {0xEDA2, 0xF9F8}, //15452 #CJK COMPATIBILITY IDEOGRAPH
  {0xEDA3, 0xF9F9}, //15453 #CJK COMPATIBILITY IDEOGRAPH
  {0xEDA4, 0x4ECD}, //15454 #CJK UNIFIED IDEOGRAPH
  {0xEDA5, 0x5269}, //15455 #CJK UNIFIED IDEOGRAPH
  {0xEDA6, 0x5B55}, //15456 #CJK UNIFIED IDEOGRAPH
  {0xEDA7, 0x82BF}, //15457 #CJK UNIFIED IDEOGRAPH
  {0xEDA8, 0x4ED4}, //15458 #CJK UNIFIED IDEOGRAPH
  {0xEDA9, 0x523A}, //15459 #CJK UNIFIED IDEOGRAPH
  {0xEDAA, 0x54A8}, //15460 #CJK UNIFIED IDEOGRAPH
  {0xEDAB, 0x59C9}, //15461 #CJK UNIFIED IDEOGRAPH
  {0xEDAC, 0x59FF}, //15462 #CJK UNIFIED IDEOGRAPH
  {0xEDAD, 0x5B50}, //15463 #CJK UNIFIED IDEOGRAPH
  {0xEDAE, 0x5B57}, //15464 #CJK UNIFIED IDEOGRAPH
  {0xEDAF, 0x5B5C}, //15465 #CJK UNIFIED IDEOGRAPH
  {0xEDB0, 0x6063}, //15466 #CJK UNIFIED IDEOGRAPH
  {0xEDB1, 0x6148}, //15467 #CJK UNIFIED IDEOGRAPH
  {0xEDB2, 0x6ECB}, //15468 #CJK UNIFIED IDEOGRAPH
  {0xEDB3, 0x7099}, //15469 #CJK UNIFIED IDEOGRAPH
  {0xEDB4, 0x716E}, //15470 #CJK UNIFIED IDEOGRAPH
  {0xEDB5, 0x7386}, //15471 #CJK UNIFIED IDEOGRAPH
  {0xEDB6, 0x74F7}, //15472 #CJK UNIFIED IDEOGRAPH
  {0xEDB7, 0x75B5}, //15473 #CJK UNIFIED IDEOGRAPH
  {0xEDB8, 0x78C1}, //15474 #CJK UNIFIED IDEOGRAPH
  {0xEDB9, 0x7D2B}, //15475 #CJK UNIFIED IDEOGRAPH
  {0xEDBA, 0x8005}, //15476 #CJK UNIFIED IDEOGRAPH
  {0xEDBB, 0x81EA}, //15477 #CJK UNIFIED IDEOGRAPH
  {0xEDBC, 0x8328}, //15478 #CJK UNIFIED IDEOGRAPH
  {0xEDBD, 0x8517}, //15479 #CJK UNIFIED IDEOGRAPH
  {0xEDBE, 0x85C9}, //15480 #CJK UNIFIED IDEOGRAPH
  {0xEDBF, 0x8AEE}, //15481 #CJK UNIFIED IDEOGRAPH
  {0xEDC0, 0x8CC7}, //15482 #CJK UNIFIED IDEOGRAPH
  {0xEDC1, 0x96CC}, //15483 #CJK UNIFIED IDEOGRAPH
  {0xEDC2, 0x4F5C}, //15484 #CJK UNIFIED IDEOGRAPH
  {0xEDC3, 0x52FA}, //15485 #CJK UNIFIED IDEOGRAPH
  {0xEDC4, 0x56BC}, //15486 #CJK UNIFIED IDEOGRAPH
  {0xEDC5, 0x65AB}, //15487 #CJK UNIFIED IDEOGRAPH
  {0xEDC6, 0x6628}, //15488 #CJK UNIFIED IDEOGRAPH
  {0xEDC7, 0x707C}, //15489 #CJK UNIFIED IDEOGRAPH
  {0xEDC8, 0x70B8}, //15490 #CJK UNIFIED IDEOGRAPH
  {0xEDC9, 0x7235}, //15491 #CJK UNIFIED IDEOGRAPH
  {0xEDCA, 0x7DBD}, //15492 #CJK UNIFIED IDEOGRAPH
  {0xEDCB, 0x828D}, //15493 #CJK UNIFIED IDEOGRAPH
  {0xEDCC, 0x914C}, //15494 #CJK UNIFIED IDEOGRAPH
  {0xEDCD, 0x96C0}, //15495 #CJK UNIFIED IDEOGRAPH
  {0xEDCE, 0x9D72}, //15496 #CJK UNIFIED IDEOGRAPH
  {0xEDCF, 0x5B71}, //15497 #CJK UNIFIED IDEOGRAPH
  {0xEDD0, 0x68E7}, //15498 #CJK UNIFIED IDEOGRAPH
  {0xEDD1, 0x6B98}, //15499 #CJK UNIFIED IDEOGRAPH
  {0xEDD2, 0x6F7A}, //15500 #CJK UNIFIED IDEOGRAPH
  {0xEDD3, 0x76DE}, //15501 #CJK UNIFIED IDEOGRAPH
  {0xEDD4, 0x5C91}, //15502 #CJK UNIFIED IDEOGRAPH
  {0xEDD5, 0x66AB}, //15503 #CJK UNIFIED IDEOGRAPH
  {0xEDD6, 0x6F5B}, //15504 #CJK UNIFIED IDEOGRAPH
  {0xEDD7, 0x7BB4}, //15505 #CJK UNIFIED IDEOGRAPH
  {0xEDD8, 0x7C2A}, //15506 #CJK UNIFIED IDEOGRAPH
  {0xEDD9, 0x8836}, //15507 #CJK UNIFIED IDEOGRAPH
  {0xEDDA, 0x96DC}, //15508 #CJK UNIFIED IDEOGRAPH
  {0xEDDB, 0x4E08}, //15509 #CJK UNIFIED IDEOGRAPH
  {0xEDDC, 0x4ED7}, //15510 #CJK UNIFIED IDEOGRAPH
  {0xEDDD, 0x5320}, //15511 #CJK UNIFIED IDEOGRAPH
  {0xEDDE, 0x5834}, //15512 #CJK UNIFIED IDEOGRAPH
  {0xEDDF, 0x58BB}, //15513 #CJK UNIFIED IDEOGRAPH
  {0xEDE0, 0x58EF}, //15514 #CJK UNIFIED IDEOGRAPH
  {0xEDE1, 0x596C}, //15515 #CJK UNIFIED IDEOGRAPH
  {0xEDE2, 0x5C07}, //15516 #CJK UNIFIED IDEOGRAPH
  {0xEDE3, 0x5E33}, //15517 #CJK UNIFIED IDEOGRAPH
  {0xEDE4, 0x5E84}, //15518 #CJK UNIFIED IDEOGRAPH
  {0xEDE5, 0x5F35}, //15519 #CJK UNIFIED IDEOGRAPH
  {0xEDE6, 0x638C}, //15520 #CJK UNIFIED IDEOGRAPH
  {0xEDE7, 0x66B2}, //15521 #CJK UNIFIED IDEOGRAPH
  {0xEDE8, 0x6756}, //15522 #CJK UNIFIED IDEOGRAPH
  {0xEDE9, 0x6A1F}, //15523 #CJK UNIFIED IDEOGRAPH
  {0xEDEA, 0x6AA3}, //15524 #CJK UNIFIED IDEOGRAPH
  {0xEDEB, 0x6B0C}, //15525 #CJK UNIFIED IDEOGRAPH
  {0xEDEC, 0x6F3F}, //15526 #CJK UNIFIED IDEOGRAPH
  {0xEDED, 0x7246}, //15527 #CJK UNIFIED IDEOGRAPH
  {0xEDEE, 0xF9FA}, //15528 #CJK COMPATIBILITY IDEOGRAPH
  {0xEDEF, 0x7350}, //15529 #CJK UNIFIED IDEOGRAPH
  {0xEDF0, 0x748B}, //15530 #CJK UNIFIED IDEOGRAPH
  {0xEDF1, 0x7AE0}, //15531 #CJK UNIFIED IDEOGRAPH
  {0xEDF2, 0x7CA7}, //15532 #CJK UNIFIED IDEOGRAPH
  {0xEDF3, 0x8178}, //15533 #CJK UNIFIED IDEOGRAPH
  {0xEDF4, 0x81DF}, //15534 #CJK UNIFIED IDEOGRAPH
  {0xEDF5, 0x81E7}, //15535 #CJK UNIFIED IDEOGRAPH
  {0xEDF6, 0x838A}, //15536 #CJK UNIFIED IDEOGRAPH
  {0xEDF7, 0x846C}, //15537 #CJK UNIFIED IDEOGRAPH
  {0xEDF8, 0x8523}, //15538 #CJK UNIFIED IDEOGRAPH
  {0xEDF9, 0x8594}, //15539 #CJK UNIFIED IDEOGRAPH
  {0xEDFA, 0x85CF}, //15540 #CJK UNIFIED IDEOGRAPH
  {0xEDFB, 0x88DD}, //15541 #CJK UNIFIED IDEOGRAPH
  {0xEDFC, 0x8D13}, //15542 #CJK UNIFIED IDEOGRAPH
  {0xEDFD, 0x91AC}, //15543 #CJK UNIFIED IDEOGRAPH
  {0xEDFE, 0x9577}, //15544 #CJK UNIFIED IDEOGRAPH
  {0xEEA1, 0x969C}, //15545 #CJK UNIFIED IDEOGRAPH
  {0xEEA2, 0x518D}, //15546 #CJK UNIFIED IDEOGRAPH
  {0xEEA3, 0x54C9}, //15547 #CJK UNIFIED IDEOGRAPH
  {0xEEA4, 0x5728}, //15548 #CJK UNIFIED IDEOGRAPH
  {0xEEA5, 0x5BB0}, //15549 #CJK UNIFIED IDEOGRAPH
  {0xEEA6, 0x624D}, //15550 #CJK UNIFIED IDEOGRAPH
  {0xEEA7, 0x6750}, //15551 #CJK UNIFIED IDEOGRAPH
  {0xEEA8, 0x683D}, //15552 #CJK UNIFIED IDEOGRAPH
  {0xEEA9, 0x6893}, //15553 #CJK UNIFIED IDEOGRAPH
  {0xEEAA, 0x6E3D}, //15554 #CJK UNIFIED IDEOGRAPH
  {0xEEAB, 0x6ED3}, //15555 #CJK UNIFIED IDEOGRAPH
  {0xEEAC, 0x707D}, //15556 #CJK UNIFIED IDEOGRAPH
  {0xEEAD, 0x7E21}, //15557 #CJK UNIFIED IDEOGRAPH
  {0xEEAE, 0x88C1}, //15558 #CJK UNIFIED IDEOGRAPH
  {0xEEAF, 0x8CA1}, //15559 #CJK UNIFIED IDEOGRAPH
  {0xEEB0, 0x8F09}, //15560 #CJK UNIFIED IDEOGRAPH
  {0xEEB1, 0x9F4B}, //15561 #CJK UNIFIED IDEOGRAPH
  {0xEEB2, 0x9F4E}, //15562 #CJK UNIFIED IDEOGRAPH
  {0xEEB3, 0x722D}, //15563 #CJK UNIFIED IDEOGRAPH
  {0xEEB4, 0x7B8F}, //15564 #CJK UNIFIED IDEOGRAPH
  {0xEEB5, 0x8ACD}, //15565 #CJK UNIFIED IDEOGRAPH
  {0xEEB6, 0x931A}, //15566 #CJK UNIFIED IDEOGRAPH
  {0xEEB7, 0x4F47}, //15567 #CJK UNIFIED IDEOGRAPH
  {0xEEB8, 0x4F4E}, //15568 #CJK UNIFIED IDEOGRAPH
  {0xEEB9, 0x5132}, //15569 #CJK UNIFIED IDEOGRAPH
  {0xEEBA, 0x5480}, //15570 #CJK UNIFIED IDEOGRAPH
  {0xEEBB, 0x59D0}, //15571 #CJK UNIFIED IDEOGRAPH
  {0xEEBC, 0x5E95}, //15572 #CJK UNIFIED IDEOGRAPH
  {0xEEBD, 0x62B5}, //15573 #CJK UNIFIED IDEOGRAPH
  {0xEEBE, 0x6775}, //15574 #CJK UNIFIED IDEOGRAPH
  {0xEEBF, 0x696E}, //15575 #CJK UNIFIED IDEOGRAPH
  {0xEEC0, 0x6A17}, //15576 #CJK UNIFIED IDEOGRAPH
  {0xEEC1, 0x6CAE}, //15577 #CJK UNIFIED IDEOGRAPH
  {0xEEC2, 0x6E1A}, //15578 #CJK UNIFIED IDEOGRAPH
  {0xEEC3, 0x72D9}, //15579 #CJK UNIFIED IDEOGRAPH
  {0xEEC4, 0x732A}, //15580 #CJK UNIFIED IDEOGRAPH
  {0xEEC5, 0x75BD}, //15581 #CJK UNIFIED IDEOGRAPH
  {0xEEC6, 0x7BB8}, //15582 #CJK UNIFIED IDEOGRAPH
  {0xEEC7, 0x7D35}, //15583 #CJK UNIFIED IDEOGRAPH
  {0xEEC8, 0x82E7}, //15584 #CJK UNIFIED IDEOGRAPH
  {0xEEC9, 0x83F9}, //15585 #CJK UNIFIED IDEOGRAPH
  {0xEECA, 0x8457}, //15586 #CJK UNIFIED IDEOGRAPH
  {0xEECB, 0x85F7}, //15587 #CJK UNIFIED IDEOGRAPH
  {0xEECC, 0x8A5B}, //15588 #CJK UNIFIED IDEOGRAPH
  {0xEECD, 0x8CAF}, //15589 #CJK UNIFIED IDEOGRAPH
  {0xEECE, 0x8E87}, //15590 #CJK UNIFIED IDEOGRAPH
  {0xEECF, 0x9019}, //15591 #CJK UNIFIED IDEOGRAPH
  {0xEED0, 0x90B8}, //15592 #CJK UNIFIED IDEOGRAPH
  {0xEED1, 0x96CE}, //15593 #CJK UNIFIED IDEOGRAPH
  {0xEED2, 0x9F5F}, //15594 #CJK UNIFIED IDEOGRAPH
  {0xEED3, 0x52E3}, //15595 #CJK UNIFIED IDEOGRAPH
  {0xEED4, 0x540A}, //15596 #CJK UNIFIED IDEOGRAPH
  {0xEED5, 0x5AE1}, //15597 #CJK UNIFIED IDEOGRAPH
  {0xEED6, 0x5BC2}, //15598 #CJK UNIFIED IDEOGRAPH
  {0xEED7, 0x6458}, //15599 #CJK UNIFIED IDEOGRAPH
  {0xEED8, 0x6575}, //15600 #CJK UNIFIED IDEOGRAPH
  {0xEED9, 0x6EF4}, //15601 #CJK UNIFIED IDEOGRAPH
  {0xEEDA, 0x72C4}, //15602 #CJK UNIFIED IDEOGRAPH
  {0xEEDB, 0xF9FB}, //15603 #CJK COMPATIBILITY IDEOGRAPH
  {0xEEDC, 0x7684}, //15604 #CJK UNIFIED IDEOGRAPH
  {0xEEDD, 0x7A4D}, //15605 #CJK UNIFIED IDEOGRAPH
  {0xEEDE, 0x7B1B}, //15606 #CJK UNIFIED IDEOGRAPH
  {0xEEDF, 0x7C4D}, //15607 #CJK UNIFIED IDEOGRAPH
  {0xEEE0, 0x7E3E}, //15608 #CJK UNIFIED IDEOGRAPH
  {0xEEE1, 0x7FDF}, //15609 #CJK UNIFIED IDEOGRAPH
  {0xEEE2, 0x837B}, //15610 #CJK UNIFIED IDEOGRAPH
  {0xEEE3, 0x8B2B}, //15611 #CJK UNIFIED IDEOGRAPH
  {0xEEE4, 0x8CCA}, //15612 #CJK UNIFIED IDEOGRAPH
  {0xEEE5, 0x8D64}, //15613 #CJK UNIFIED IDEOGRAPH
  {0xEEE6, 0x8DE1}, //15614 #CJK UNIFIED IDEOGRAPH
  {0xEEE7, 0x8E5F}, //15615 #CJK UNIFIED IDEOGRAPH
  {0xEEE8, 0x8FEA}, //15616 #CJK UNIFIED IDEOGRAPH
  {0xEEE9, 0x8FF9}, //15617 #CJK UNIFIED IDEOGRAPH
  {0xEEEA, 0x9069}, //15618 #CJK UNIFIED IDEOGRAPH
  {0xEEEB, 0x93D1}, //15619 #CJK UNIFIED IDEOGRAPH
  {0xEEEC, 0x4F43}, //15620 #CJK UNIFIED IDEOGRAPH
  {0xEEED, 0x4F7A}, //15621 #CJK UNIFIED IDEOGRAPH
  {0xEEEE, 0x50B3}, //15622 #CJK UNIFIED IDEOGRAPH
  {0xEEEF, 0x5168}, //15623 #CJK UNIFIED IDEOGRAPH
  {0xEEF0, 0x5178}, //15624 #CJK UNIFIED IDEOGRAPH
  {0xEEF1, 0x524D}, //15625 #CJK UNIFIED IDEOGRAPH
  {0xEEF2, 0x526A}, //15626 #CJK UNIFIED IDEOGRAPH
  {0xEEF3, 0x5861}, //15627 #CJK UNIFIED IDEOGRAPH
  {0xEEF4, 0x587C}, //15628 #CJK UNIFIED IDEOGRAPH
  {0xEEF5, 0x5960}, //15629 #CJK UNIFIED IDEOGRAPH
  {0xEEF6, 0x5C08}, //15630 #CJK UNIFIED IDEOGRAPH
  {0xEEF7, 0x5C55}, //15631 #CJK UNIFIED IDEOGRAPH
  {0xEEF8, 0x5EDB}, //15632 #CJK UNIFIED IDEOGRAPH
  {0xEEF9, 0x609B}, //15633 #CJK UNIFIED IDEOGRAPH
  {0xEEFA, 0x6230}, //15634 #CJK UNIFIED IDEOGRAPH
  {0xEEFB, 0x6813}, //15635 #CJK UNIFIED IDEOGRAPH
  {0xEEFC, 0x6BBF}, //15636 #CJK UNIFIED IDEOGRAPH
  {0xEEFD, 0x6C08}, //15637 #CJK UNIFIED IDEOGRAPH
  {0xEEFE, 0x6FB1}, //15638 #CJK UNIFIED IDEOGRAPH
  {0xEFA1, 0x714E}, //15639 #CJK UNIFIED IDEOGRAPH
  {0xEFA2, 0x7420}, //15640 #CJK UNIFIED IDEOGRAPH
  {0xEFA3, 0x7530}, //15641 #CJK UNIFIED IDEOGRAPH
  {0xEFA4, 0x7538}, //15642 #CJK UNIFIED IDEOGRAPH
  {0xEFA5, 0x7551}, //15643 #CJK UNIFIED IDEOGRAPH
  {0xEFA6, 0x7672}, //15644 #CJK UNIFIED IDEOGRAPH
  {0xEFA7, 0x7B4C}, //15645 #CJK UNIFIED IDEOGRAPH
  {0xEFA8, 0x7B8B}, //15646 #CJK UNIFIED IDEOGRAPH
  {0xEFA9, 0x7BAD}, //15647 #CJK UNIFIED IDEOGRAPH
  {0xEFAA, 0x7BC6}, //15648 #CJK UNIFIED IDEOGRAPH
  {0xEFAB, 0x7E8F}, //15649 #CJK UNIFIED IDEOGRAPH
  {0xEFAC, 0x8A6E}, //15650 #CJK UNIFIED IDEOGRAPH
  {0xEFAD, 0x8F3E}, //15651 #CJK UNIFIED IDEOGRAPH
  {0xEFAE, 0x8F49}, //15652 #CJK UNIFIED IDEOGRAPH
  {0xEFAF, 0x923F}, //15653 #CJK UNIFIED IDEOGRAPH
  {0xEFB0, 0x9293}, //15654 #CJK UNIFIED IDEOGRAPH
  {0xEFB1, 0x9322}, //15655 #CJK UNIFIED IDEOGRAPH
  {0xEFB2, 0x942B}, //15656 #CJK UNIFIED IDEOGRAPH
  {0xEFB3, 0x96FB}, //15657 #CJK UNIFIED IDEOGRAPH
  {0xEFB4, 0x985A}, //15658 #CJK UNIFIED IDEOGRAPH
  {0xEFB5, 0x986B}, //15659 #CJK UNIFIED IDEOGRAPH
  {0xEFB6, 0x991E}, //15660 #CJK UNIFIED IDEOGRAPH
  {0xEFB7, 0x5207}, //15661 #CJK UNIFIED IDEOGRAPH
  {0xEFB8, 0x622A}, //15662 #CJK UNIFIED IDEOGRAPH
  {0xEFB9, 0x6298}, //15663 #CJK UNIFIED IDEOGRAPH
  {0xEFBA, 0x6D59}, //15664 #CJK UNIFIED IDEOGRAPH
  {0xEFBB, 0x7664}, //15665 #CJK UNIFIED IDEOGRAPH
  {0xEFBC, 0x7ACA}, //15666 #CJK UNIFIED IDEOGRAPH
  {0xEFBD, 0x7BC0}, //15667 #CJK UNIFIED IDEOGRAPH
  {0xEFBE, 0x7D76}, //15668 #CJK UNIFIED IDEOGRAPH
  {0xEFBF, 0x5360}, //15669 #CJK UNIFIED IDEOGRAPH
  {0xEFC0, 0x5CBE}, //15670 #CJK UNIFIED IDEOGRAPH
  {0xEFC1, 0x5E97}, //15671 #CJK UNIFIED IDEOGRAPH
  {0xEFC2, 0x6F38}, //15672 #CJK UNIFIED IDEOGRAPH
  {0xEFC3, 0x70B9}, //15673 #CJK UNIFIED IDEOGRAPH
  {0xEFC4, 0x7C98}, //15674 #CJK UNIFIED IDEOGRAPH
  {0xEFC5, 0x9711}, //15675 #CJK UNIFIED IDEOGRAPH
  {0xEFC6, 0x9B8E}, //15676 #CJK UNIFIED IDEOGRAPH
  {0xEFC7, 0x9EDE}, //15677 #CJK UNIFIED IDEOGRAPH
  {0xEFC8, 0x63A5}, //15678 #CJK UNIFIED IDEOGRAPH
  {0xEFC9, 0x647A}, //15679 #CJK UNIFIED IDEOGRAPH
  {0xEFCA, 0x8776}, //15680 #CJK UNIFIED IDEOGRAPH
  {0xEFCB, 0x4E01}, //15681 #CJK UNIFIED IDEOGRAPH
  {0xEFCC, 0x4E95}, //15682 #CJK UNIFIED IDEOGRAPH
  {0xEFCD, 0x4EAD}, //15683 #CJK UNIFIED IDEOGRAPH
  {0xEFCE, 0x505C}, //15684 #CJK UNIFIED IDEOGRAPH
  {0xEFCF, 0x5075}, //15685 #CJK UNIFIED IDEOGRAPH
  {0xEFD0, 0x5448}, //15686 #CJK UNIFIED IDEOGRAPH
  {0xEFD1, 0x59C3}, //15687 #CJK UNIFIED IDEOGRAPH
  {0xEFD2, 0x5B9A}, //15688 #CJK UNIFIED IDEOGRAPH
  {0xEFD3, 0x5E40}, //15689 #CJK UNIFIED IDEOGRAPH
  {0xEFD4, 0x5EAD}, //15690 #CJK UNIFIED IDEOGRAPH
  {0xEFD5, 0x5EF7}, //15691 #CJK UNIFIED IDEOGRAPH
  {0xEFD6, 0x5F81}, //15692 #CJK UNIFIED IDEOGRAPH
  {0xEFD7, 0x60C5}, //15693 #CJK UNIFIED IDEOGRAPH
  {0xEFD8, 0x633A}, //15694 #CJK UNIFIED IDEOGRAPH
  {0xEFD9, 0x653F}, //15695 #CJK UNIFIED IDEOGRAPH
  {0xEFDA, 0x6574}, //15696 #CJK UNIFIED IDEOGRAPH
  {0xEFDB, 0x65CC}, //15697 #CJK UNIFIED IDEOGRAPH
  {0xEFDC, 0x6676}, //15698 #CJK UNIFIED IDEOGRAPH
  {0xEFDD, 0x6678}, //15699 #CJK UNIFIED IDEOGRAPH
  {0xEFDE, 0x67FE}, //15700 #CJK UNIFIED IDEOGRAPH
  {0xEFDF, 0x6968}, //15701 #CJK UNIFIED IDEOGRAPH
  {0xEFE0, 0x6A89}, //15702 #CJK UNIFIED IDEOGRAPH
  {0xEFE1, 0x6B63}, //15703 #CJK UNIFIED IDEOGRAPH
  {0xEFE2, 0x6C40}, //15704 #CJK UNIFIED IDEOGRAPH
  {0xEFE3, 0x6DC0}, //15705 #CJK UNIFIED IDEOGRAPH
  {0xEFE4, 0x6DE8}, //15706 #CJK UNIFIED IDEOGRAPH
  {0xEFE5, 0x6E1F}, //15707 #CJK UNIFIED IDEOGRAPH
  {0xEFE6, 0x6E5E}, //15708 #CJK UNIFIED IDEOGRAPH
  {0xEFE7, 0x701E}, //15709 #CJK UNIFIED IDEOGRAPH
  {0xEFE8, 0x70A1}, //15710 #CJK UNIFIED IDEOGRAPH
  {0xEFE9, 0x738E}, //15711 #CJK UNIFIED IDEOGRAPH
  {0xEFEA, 0x73FD}, //15712 #CJK UNIFIED IDEOGRAPH
  {0xEFEB, 0x753A}, //15713 #CJK UNIFIED IDEOGRAPH
  {0xEFEC, 0x775B}, //15714 #CJK UNIFIED IDEOGRAPH
  {0xEFED, 0x7887}, //15715 #CJK UNIFIED IDEOGRAPH
  {0xEFEE, 0x798E}, //15716 #CJK UNIFIED IDEOGRAPH
  {0xEFEF, 0x7A0B}, //15717 #CJK UNIFIED IDEOGRAPH
  {0xEFF0, 0x7A7D}, //15718 #CJK UNIFIED IDEOGRAPH
  {0xEFF1, 0x7CBE}, //15719 #CJK UNIFIED IDEOGRAPH
  {0xEFF2, 0x7D8E}, //15720 #CJK UNIFIED IDEOGRAPH
  {0xEFF3, 0x8247}, //15721 #CJK UNIFIED IDEOGRAPH
  {0xEFF4, 0x8A02}, //15722 #CJK UNIFIED IDEOGRAPH
  {0xEFF5, 0x8AEA}, //15723 #CJK UNIFIED IDEOGRAPH
  {0xEFF6, 0x8C9E}, //15724 #CJK UNIFIED IDEOGRAPH
  {0xEFF7, 0x912D}, //15725 #CJK UNIFIED IDEOGRAPH
  {0xEFF8, 0x914A}, //15726 #CJK UNIFIED IDEOGRAPH
  {0xEFF9, 0x91D8}, //15727 #CJK UNIFIED IDEOGRAPH
  {0xEFFA, 0x9266}, //15728 #CJK UNIFIED IDEOGRAPH
  {0xEFFB, 0x92CC}, //15729 #CJK UNIFIED IDEOGRAPH
  {0xEFFC, 0x9320}, //15730 #CJK UNIFIED IDEOGRAPH
  {0xEFFD, 0x9706}, //15731 #CJK UNIFIED IDEOGRAPH
  {0xEFFE, 0x9756}, //15732 #CJK UNIFIED IDEOGRAPH
  {0xF0A1, 0x975C}, //15733 #CJK UNIFIED IDEOGRAPH
  {0xF0A2, 0x9802}, //15734 #CJK UNIFIED IDEOGRAPH
  {0xF0A3, 0x9F0E}, //15735 #CJK UNIFIED IDEOGRAPH
  {0xF0A4, 0x5236}, //15736 #CJK UNIFIED IDEOGRAPH
  {0xF0A5, 0x5291}, //15737 #CJK UNIFIED IDEOGRAPH
  {0xF0A6, 0x557C}, //15738 #CJK UNIFIED IDEOGRAPH
  {0xF0A7, 0x5824}, //15739 #CJK UNIFIED IDEOGRAPH
  {0xF0A8, 0x5E1D}, //15740 #CJK UNIFIED IDEOGRAPH
  {0xF0A9, 0x5F1F}, //15741 #CJK UNIFIED IDEOGRAPH
  {0xF0AA, 0x608C}, //15742 #CJK UNIFIED IDEOGRAPH
  {0xF0AB, 0x63D0}, //15743 #CJK UNIFIED IDEOGRAPH
  {0xF0AC, 0x68AF}, //15744 #CJK UNIFIED IDEOGRAPH
  {0xF0AD, 0x6FDF}, //15745 #CJK UNIFIED IDEOGRAPH
  {0xF0AE, 0x796D}, //15746 #CJK UNIFIED IDEOGRAPH
  {0xF0AF, 0x7B2C}, //15747 #CJK UNIFIED IDEOGRAPH
  {0xF0B0, 0x81CD}, //15748 #CJK UNIFIED IDEOGRAPH
  {0xF0B1, 0x85BA}, //15749 #CJK UNIFIED IDEOGRAPH
  {0xF0B2, 0x88FD}, //15750 #CJK UNIFIED IDEOGRAPH
  {0xF0B3, 0x8AF8}, //15751 #CJK UNIFIED IDEOGRAPH
  {0xF0B4, 0x8E44}, //15752 #CJK UNIFIED IDEOGRAPH
  {0xF0B5, 0x918D}, //15753 #CJK UNIFIED IDEOGRAPH
  {0xF0B6, 0x9664}, //15754 #CJK UNIFIED IDEOGRAPH
  {0xF0B7, 0x969B}, //15755 #CJK UNIFIED IDEOGRAPH
  {0xF0B8, 0x973D}, //15756 #CJK UNIFIED IDEOGRAPH
  {0xF0B9, 0x984C}, //15757 #CJK UNIFIED IDEOGRAPH
  {0xF0BA, 0x9F4A}, //15758 #CJK UNIFIED IDEOGRAPH
  {0xF0BB, 0x4FCE}, //15759 #CJK UNIFIED IDEOGRAPH
  {0xF0BC, 0x5146}, //15760 #CJK UNIFIED IDEOGRAPH
  {0xF0BD, 0x51CB}, //15761 #CJK UNIFIED IDEOGRAPH
  {0xF0BE, 0x52A9}, //15762 #CJK UNIFIED IDEOGRAPH
  {0xF0BF, 0x5632}, //15763 #CJK UNIFIED IDEOGRAPH
  {0xF0C0, 0x5F14}, //15764 #CJK UNIFIED IDEOGRAPH
  {0xF0C1, 0x5F6B}, //15765 #CJK UNIFIED IDEOGRAPH
  {0xF0C2, 0x63AA}, //15766 #CJK UNIFIED IDEOGRAPH
  {0xF0C3, 0x64CD}, //15767 #CJK UNIFIED IDEOGRAPH
  {0xF0C4, 0x65E9}, //15768 #CJK UNIFIED IDEOGRAPH
  {0xF0C5, 0x6641}, //15769 #CJK UNIFIED IDEOGRAPH
  {0xF0C6, 0x66FA}, //15770 #CJK UNIFIED IDEOGRAPH
  {0xF0C7, 0x66F9}, //15771 #CJK UNIFIED IDEOGRAPH
  {0xF0C8, 0x671D}, //15772 #CJK UNIFIED IDEOGRAPH
  {0xF0C9, 0x689D}, //15773 #CJK UNIFIED IDEOGRAPH
  {0xF0CA, 0x68D7}, //15774 #CJK UNIFIED IDEOGRAPH
  {0xF0CB, 0x69FD}, //15775 #CJK UNIFIED IDEOGRAPH
  {0xF0CC, 0x6F15}, //15776 #CJK UNIFIED IDEOGRAPH
  {0xF0CD, 0x6F6E}, //15777 #CJK UNIFIED IDEOGRAPH
  {0xF0CE, 0x7167}, //15778 #CJK UNIFIED IDEOGRAPH
  {0xF0CF, 0x71E5}, //15779 #CJK UNIFIED IDEOGRAPH
  {0xF0D0, 0x722A}, //15780 #CJK UNIFIED IDEOGRAPH
  {0xF0D1, 0x74AA}, //15781 #CJK UNIFIED IDEOGRAPH
  {0xF0D2, 0x773A}, //15782 #CJK UNIFIED IDEOGRAPH
  {0xF0D3, 0x7956}, //15783 #CJK UNIFIED IDEOGRAPH
  {0xF0D4, 0x795A}, //15784 #CJK UNIFIED IDEOGRAPH
  {0xF0D5, 0x79DF}, //15785 #CJK UNIFIED IDEOGRAPH
  {0xF0D6, 0x7A20}, //15786 #CJK UNIFIED IDEOGRAPH
  {0xF0D7, 0x7A95}, //15787 #CJK UNIFIED IDEOGRAPH
  {0xF0D8, 0x7C97}, //15788 #CJK UNIFIED IDEOGRAPH
  {0xF0D9, 0x7CDF}, //15789 #CJK UNIFIED IDEOGRAPH
  {0xF0DA, 0x7D44}, //15790 #CJK UNIFIED IDEOGRAPH
  {0xF0DB, 0x7E70}, //15791 #CJK UNIFIED IDEOGRAPH
  {0xF0DC, 0x8087}, //15792 #CJK UNIFIED IDEOGRAPH
  {0xF0DD, 0x85FB}, //15793 #CJK UNIFIED IDEOGRAPH
  {0xF0DE, 0x86A4}, //15794 #CJK UNIFIED IDEOGRAPH
  {0xF0DF, 0x8A54}, //15795 #CJK UNIFIED IDEOGRAPH
  {0xF0E0, 0x8ABF}, //15796 #CJK UNIFIED IDEOGRAPH
  {0xF0E1, 0x8D99}, //15797 #CJK UNIFIED IDEOGRAPH
  {0xF0E2, 0x8E81}, //15798 #CJK UNIFIED IDEOGRAPH
  {0xF0E3, 0x9020}, //15799 #CJK UNIFIED IDEOGRAPH
  {0xF0E4, 0x906D}, //15800 #CJK UNIFIED IDEOGRAPH
  {0xF0E5, 0x91E3}, //15801 #CJK UNIFIED IDEOGRAPH
  {0xF0E6, 0x963B}, //15802 #CJK UNIFIED IDEOGRAPH
  {0xF0E7, 0x96D5}, //15803 #CJK UNIFIED IDEOGRAPH
  {0xF0E8, 0x9CE5}, //15804 #CJK UNIFIED IDEOGRAPH
  {0xF0E9, 0x65CF}, //15805 #CJK UNIFIED IDEOGRAPH
  {0xF0EA, 0x7C07}, //15806 #CJK UNIFIED IDEOGRAPH
  {0xF0EB, 0x8DB3}, //15807 #CJK UNIFIED IDEOGRAPH
  {0xF0EC, 0x93C3}, //15808 #CJK UNIFIED IDEOGRAPH
  {0xF0ED, 0x5B58}, //15809 #CJK UNIFIED IDEOGRAPH
  {0xF0EE, 0x5C0A}, //15810 #CJK UNIFIED IDEOGRAPH
  {0xF0EF, 0x5352}, //15811 #CJK UNIFIED IDEOGRAPH
  {0xF0F0, 0x62D9}, //15812 #CJK UNIFIED IDEOGRAPH
  {0xF0F1, 0x731D}, //15813 #CJK UNIFIED IDEOGRAPH
  {0xF0F2, 0x5027}, //15814 #CJK UNIFIED IDEOGRAPH
  {0xF0F3, 0x5B97}, //15815 #CJK UNIFIED IDEOGRAPH
  {0xF0F4, 0x5F9E}, //15816 #CJK UNIFIED IDEOGRAPH
  {0xF0F5, 0x60B0}, //15817 #CJK UNIFIED IDEOGRAPH
  {0xF0F6, 0x616B}, //15818 #CJK UNIFIED IDEOGRAPH
  {0xF0F7, 0x68D5}, //15819 #CJK UNIFIED IDEOGRAPH
  {0xF0F8, 0x6DD9}, //15820 #CJK UNIFIED IDEOGRAPH
  {0xF0F9, 0x742E}, //15821 #CJK UNIFIED IDEOGRAPH
  {0xF0FA, 0x7A2E}, //15822 #CJK UNIFIED IDEOGRAPH
  {0xF0FB, 0x7D42}, //15823 #CJK UNIFIED IDEOGRAPH
  {0xF0FC, 0x7D9C}, //15824 #CJK UNIFIED IDEOGRAPH
  {0xF0FD, 0x7E31}, //15825 #CJK UNIFIED IDEOGRAPH
  {0xF0FE, 0x816B}, //15826 #CJK UNIFIED IDEOGRAPH
  {0xF1A1, 0x8E2A}, //15827 #CJK UNIFIED IDEOGRAPH
  {0xF1A2, 0x8E35}, //15828 #CJK UNIFIED IDEOGRAPH
  {0xF1A3, 0x937E}, //15829 #CJK UNIFIED IDEOGRAPH
  {0xF1A4, 0x9418}, //15830 #CJK UNIFIED IDEOGRAPH
  {0xF1A5, 0x4F50}, //15831 #CJK UNIFIED IDEOGRAPH
  {0xF1A6, 0x5750}, //15832 #CJK UNIFIED IDEOGRAPH
  {0xF1A7, 0x5DE6}, //15833 #CJK UNIFIED IDEOGRAPH
  {0xF1A8, 0x5EA7}, //15834 #CJK UNIFIED IDEOGRAPH
  {0xF1A9, 0x632B}, //15835 #CJK UNIFIED IDEOGRAPH
  {0xF1AA, 0x7F6A}, //15836 #CJK UNIFIED IDEOGRAPH
  {0xF1AB, 0x4E3B}, //15837 #CJK UNIFIED IDEOGRAPH
  {0xF1AC, 0x4F4F}, //15838 #CJK UNIFIED IDEOGRAPH
  {0xF1AD, 0x4F8F}, //15839 #CJK UNIFIED IDEOGRAPH
  {0xF1AE, 0x505A}, //15840 #CJK UNIFIED IDEOGRAPH
  {0xF1AF, 0x59DD}, //15841 #CJK UNIFIED IDEOGRAPH
  {0xF1B0, 0x80C4}, //15842 #CJK UNIFIED IDEOGRAPH
  {0xF1B1, 0x546A}, //15843 #CJK UNIFIED IDEOGRAPH
  {0xF1B2, 0x5468}, //15844 #CJK UNIFIED IDEOGRAPH
  {0xF1B3, 0x55FE}, //15845 #CJK UNIFIED IDEOGRAPH
  {0xF1B4, 0x594F}, //15846 #CJK UNIFIED IDEOGRAPH
  {0xF1B5, 0x5B99}, //15847 #CJK UNIFIED IDEOGRAPH
  {0xF1B6, 0x5DDE}, //15848 #CJK UNIFIED IDEOGRAPH
  {0xF1B7, 0x5EDA}, //15849 #CJK UNIFIED IDEOGRAPH
  {0xF1B8, 0x665D}, //15850 #CJK UNIFIED IDEOGRAPH
  {0xF1B9, 0x6731}, //15851 #CJK UNIFIED IDEOGRAPH
  {0xF1BA, 0x67F1}, //15852 #CJK UNIFIED IDEOGRAPH
  {0xF1BB, 0x682A}, //15853 #CJK UNIFIED IDEOGRAPH
  {0xF1BC, 0x6CE8}, //15854 #CJK UNIFIED IDEOGRAPH
  {0xF1BD, 0x6D32}, //15855 #CJK UNIFIED IDEOGRAPH
  {0xF1BE, 0x6E4A}, //15856 #CJK UNIFIED IDEOGRAPH
  {0xF1BF, 0x6F8D}, //15857 #CJK UNIFIED IDEOGRAPH
  {0xF1C0, 0x70B7}, //15858 #CJK UNIFIED IDEOGRAPH
  {0xF1C1, 0x73E0}, //15859 #CJK UNIFIED IDEOGRAPH
  {0xF1C2, 0x7587}, //15860 #CJK UNIFIED IDEOGRAPH
  {0xF1C3, 0x7C4C}, //15861 #CJK UNIFIED IDEOGRAPH
  {0xF1C4, 0x7D02}, //15862 #CJK UNIFIED IDEOGRAPH
  {0xF1C5, 0x7D2C}, //15863 #CJK UNIFIED IDEOGRAPH
  {0xF1C6, 0x7DA2}, //15864 #CJK UNIFIED IDEOGRAPH
  {0xF1C7, 0x821F}, //15865 #CJK UNIFIED IDEOGRAPH
  {0xF1C8, 0x86DB}, //15866 #CJK UNIFIED IDEOGRAPH
  {0xF1C9, 0x8A3B}, //15867 #CJK UNIFIED IDEOGRAPH
  {0xF1CA, 0x8A85}, //15868 #CJK UNIFIED IDEOGRAPH
  {0xF1CB, 0x8D70}, //15869 #CJK UNIFIED IDEOGRAPH
  {0xF1CC, 0x8E8A}, //15870 #CJK UNIFIED IDEOGRAPH
  {0xF1CD, 0x8F33}, //15871 #CJK UNIFIED IDEOGRAPH
  {0xF1CE, 0x9031}, //15872 #CJK UNIFIED IDEOGRAPH
  {0xF1CF, 0x914E}, //15873 #CJK UNIFIED IDEOGRAPH
  {0xF1D0, 0x9152}, //15874 #CJK UNIFIED IDEOGRAPH
  {0xF1D1, 0x9444}, //15875 #CJK UNIFIED IDEOGRAPH
  {0xF1D2, 0x99D0}, //15876 #CJK UNIFIED IDEOGRAPH
  {0xF1D3, 0x7AF9}, //15877 #CJK UNIFIED IDEOGRAPH
  {0xF1D4, 0x7CA5}, //15878 #CJK UNIFIED IDEOGRAPH
  {0xF1D5, 0x4FCA}, //15879 #CJK UNIFIED IDEOGRAPH
  {0xF1D6, 0x5101}, //15880 #CJK UNIFIED IDEOGRAPH
  {0xF1D7, 0x51C6}, //15881 #CJK UNIFIED IDEOGRAPH
  {0xF1D8, 0x57C8}, //15882 #CJK UNIFIED IDEOGRAPH
  {0xF1D9, 0x5BEF}, //15883 #CJK UNIFIED IDEOGRAPH
  {0xF1DA, 0x5CFB}, //15884 #CJK UNIFIED IDEOGRAPH
  {0xF1DB, 0x6659}, //15885 #CJK UNIFIED IDEOGRAPH
  {0xF1DC, 0x6A3D}, //15886 #CJK UNIFIED IDEOGRAPH
  {0xF1DD, 0x6D5A}, //15887 #CJK UNIFIED IDEOGRAPH
  {0xF1DE, 0x6E96}, //15888 #CJK UNIFIED IDEOGRAPH
  {0xF1DF, 0x6FEC}, //15889 #CJK UNIFIED IDEOGRAPH
  {0xF1E0, 0x710C}, //15890 #CJK UNIFIED IDEOGRAPH
  {0xF1E1, 0x756F}, //15891 #CJK UNIFIED IDEOGRAPH
  {0xF1E2, 0x7AE3}, //15892 #CJK UNIFIED IDEOGRAPH
  {0xF1E3, 0x8822}, //15893 #CJK UNIFIED IDEOGRAPH
  {0xF1E4, 0x9021}, //15894 #CJK UNIFIED IDEOGRAPH
  {0xF1E5, 0x9075}, //15895 #CJK UNIFIED IDEOGRAPH
  {0xF1E6, 0x96CB}, //15896 #CJK UNIFIED IDEOGRAPH
  {0xF1E7, 0x99FF}, //15897 #CJK UNIFIED IDEOGRAPH
  {0xF1E8, 0x8301}, //15898 #CJK UNIFIED IDEOGRAPH
  {0xF1E9, 0x4E2D}, //15899 #CJK UNIFIED IDEOGRAPH
  {0xF1EA, 0x4EF2}, //15900 #CJK UNIFIED IDEOGRAPH
  {0xF1EB, 0x8846}, //15901 #CJK UNIFIED IDEOGRAPH
  {0xF1EC, 0x91CD}, //15902 #CJK UNIFIED IDEOGRAPH
  {0xF1ED, 0x537D}, //15903 #CJK UNIFIED IDEOGRAPH
  {0xF1EE, 0x6ADB}, //15904 #CJK UNIFIED IDEOGRAPH
  {0xF1EF, 0x696B}, //15905 #CJK UNIFIED IDEOGRAPH
  {0xF1F0, 0x6C41}, //15906 #CJK UNIFIED IDEOGRAPH
  {0xF1F1, 0x847A}, //15907 #CJK UNIFIED IDEOGRAPH
  {0xF1F2, 0x589E}, //15908 #CJK UNIFIED IDEOGRAPH
  {0xF1F3, 0x618E}, //15909 #CJK UNIFIED IDEOGRAPH
  {0xF1F4, 0x66FE}, //15910 #CJK UNIFIED IDEOGRAPH
  {0xF1F5, 0x62EF}, //15911 #CJK UNIFIED IDEOGRAPH
  {0xF1F6, 0x70DD}, //15912 #CJK UNIFIED IDEOGRAPH
  {0xF1F7, 0x7511}, //15913 #CJK UNIFIED IDEOGRAPH
  {0xF1F8, 0x75C7}, //15914 #CJK UNIFIED IDEOGRAPH
  {0xF1F9, 0x7E52}, //15915 #CJK UNIFIED IDEOGRAPH
  {0xF1FA, 0x84B8}, //15916 #CJK UNIFIED IDEOGRAPH
  {0xF1FB, 0x8B49}, //15917 #CJK UNIFIED IDEOGRAPH
  {0xF1FC, 0x8D08}, //15918 #CJK UNIFIED IDEOGRAPH
  {0xF1FD, 0x4E4B}, //15919 #CJK UNIFIED IDEOGRAPH
  {0xF1FE, 0x53EA}, //15920 #CJK UNIFIED IDEOGRAPH
  {0xF2A1, 0x54AB}, //15921 #CJK UNIFIED IDEOGRAPH
  {0xF2A2, 0x5730}, //15922 #CJK UNIFIED IDEOGRAPH
  {0xF2A3, 0x5740}, //15923 #CJK UNIFIED IDEOGRAPH
  {0xF2A4, 0x5FD7}, //15924 #CJK UNIFIED IDEOGRAPH
  {0xF2A5, 0x6301}, //15925 #CJK UNIFIED IDEOGRAPH
  {0xF2A6, 0x6307}, //15926 #CJK UNIFIED IDEOGRAPH
  {0xF2A7, 0x646F}, //15927 #CJK UNIFIED IDEOGRAPH
  {0xF2A8, 0x652F}, //15928 #CJK UNIFIED IDEOGRAPH
  {0xF2A9, 0x65E8}, //15929 #CJK UNIFIED IDEOGRAPH
  {0xF2AA, 0x667A}, //15930 #CJK UNIFIED IDEOGRAPH
  {0xF2AB, 0x679D}, //15931 #CJK UNIFIED IDEOGRAPH
  {0xF2AC, 0x67B3}, //15932 #CJK UNIFIED IDEOGRAPH
  {0xF2AD, 0x6B62}, //15933 #CJK UNIFIED IDEOGRAPH
  {0xF2AE, 0x6C60}, //15934 #CJK UNIFIED IDEOGRAPH
  {0xF2AF, 0x6C9A}, //15935 #CJK UNIFIED IDEOGRAPH
  {0xF2B0, 0x6F2C}, //15936 #CJK UNIFIED IDEOGRAPH
  {0xF2B1, 0x77E5}, //15937 #CJK UNIFIED IDEOGRAPH
  {0xF2B2, 0x7825}, //15938 #CJK UNIFIED IDEOGRAPH
  {0xF2B3, 0x7949}, //15939 #CJK UNIFIED IDEOGRAPH
  {0xF2B4, 0x7957}, //15940 #CJK UNIFIED IDEOGRAPH
  {0xF2B5, 0x7D19}, //15941 #CJK UNIFIED IDEOGRAPH
  {0xF2B6, 0x80A2}, //15942 #CJK UNIFIED IDEOGRAPH
  {0xF2B7, 0x8102}, //15943 #CJK UNIFIED IDEOGRAPH
  {0xF2B8, 0x81F3}, //15944 #CJK UNIFIED IDEOGRAPH
  {0xF2B9, 0x829D}, //15945 #CJK UNIFIED IDEOGRAPH
  {0xF2BA, 0x82B7}, //15946 #CJK UNIFIED IDEOGRAPH
  {0xF2BB, 0x8718}, //15947 #CJK UNIFIED IDEOGRAPH
  {0xF2BC, 0x8A8C}, //15948 #CJK UNIFIED IDEOGRAPH
  {0xF2BD, 0xF9FC}, //15949 #CJK COMPATIBILITY IDEOGRAPH
  {0xF2BE, 0x8D04}, //15950 #CJK UNIFIED IDEOGRAPH
  {0xF2BF, 0x8DBE}, //15951 #CJK UNIFIED IDEOGRAPH
  {0xF2C0, 0x9072}, //15952 #CJK UNIFIED IDEOGRAPH
  {0xF2C1, 0x76F4}, //15953 #CJK UNIFIED IDEOGRAPH
  {0xF2C2, 0x7A19}, //15954 #CJK UNIFIED IDEOGRAPH
  {0xF2C3, 0x7A37}, //15955 #CJK UNIFIED IDEOGRAPH
  {0xF2C4, 0x7E54}, //15956 #CJK UNIFIED IDEOGRAPH
  {0xF2C5, 0x8077}, //15957 #CJK UNIFIED IDEOGRAPH
  {0xF2C6, 0x5507}, //15958 #CJK UNIFIED IDEOGRAPH
  {0xF2C7, 0x55D4}, //15959 #CJK UNIFIED IDEOGRAPH
  {0xF2C8, 0x5875}, //15960 #CJK UNIFIED IDEOGRAPH
  {0xF2C9, 0x632F}, //15961 #CJK UNIFIED IDEOGRAPH
  {0xF2CA, 0x6422}, //15962 #CJK UNIFIED IDEOGRAPH
  {0xF2CB, 0x6649}, //15963 #CJK UNIFIED IDEOGRAPH
  {0xF2CC, 0x664B}, //15964 #CJK UNIFIED IDEOGRAPH
  {0xF2CD, 0x686D}, //15965 #CJK UNIFIED IDEOGRAPH
  {0xF2CE, 0x699B}, //15966 #CJK UNIFIED IDEOGRAPH
  {0xF2CF, 0x6B84}, //15967 #CJK UNIFIED IDEOGRAPH
  {0xF2D0, 0x6D25}, //15968 #CJK UNIFIED IDEOGRAPH
  {0xF2D1, 0x6EB1}, //15969 #CJK UNIFIED IDEOGRAPH
  {0xF2D2, 0x73CD}, //15970 #CJK UNIFIED IDEOGRAPH
  {0xF2D3, 0x7468}, //15971 #CJK UNIFIED IDEOGRAPH
  {0xF2D4, 0x74A1}, //15972 #CJK UNIFIED IDEOGRAPH
  {0xF2D5, 0x755B}, //15973 #CJK UNIFIED IDEOGRAPH
  {0xF2D6, 0x75B9}, //15974 #CJK UNIFIED IDEOGRAPH
  {0xF2D7, 0x76E1}, //15975 #CJK UNIFIED IDEOGRAPH
  {0xF2D8, 0x771E}, //15976 #CJK UNIFIED IDEOGRAPH
  {0xF2D9, 0x778B}, //15977 #CJK UNIFIED IDEOGRAPH
  {0xF2DA, 0x79E6}, //15978 #CJK UNIFIED IDEOGRAPH
  {0xF2DB, 0x7E09}, //15979 #CJK UNIFIED IDEOGRAPH
  {0xF2DC, 0x7E1D}, //15980 #CJK UNIFIED IDEOGRAPH
  {0xF2DD, 0x81FB}, //15981 #CJK UNIFIED IDEOGRAPH
  {0xF2DE, 0x852F}, //15982 #CJK UNIFIED IDEOGRAPH
  {0xF2DF, 0x8897}, //15983 #CJK UNIFIED IDEOGRAPH
  {0xF2E0, 0x8A3A}, //15984 #CJK UNIFIED IDEOGRAPH
  {0xF2E1, 0x8CD1}, //15985 #CJK UNIFIED IDEOGRAPH
  {0xF2E2, 0x8EEB}, //15986 #CJK UNIFIED IDEOGRAPH
  {0xF2E3, 0x8FB0}, //15987 #CJK UNIFIED IDEOGRAPH
  {0xF2E4, 0x9032}, //15988 #CJK UNIFIED IDEOGRAPH
  {0xF2E5, 0x93AD}, //15989 #CJK UNIFIED IDEOGRAPH
  {0xF2E6, 0x9663}, //15990 #CJK UNIFIED IDEOGRAPH
  {0xF2E7, 0x9673}, //15991 #CJK UNIFIED IDEOGRAPH
  {0xF2E8, 0x9707}, //15992 #CJK UNIFIED IDEOGRAPH
  {0xF2E9, 0x4F84}, //15993 #CJK UNIFIED IDEOGRAPH
  {0xF2EA, 0x53F1}, //15994 #CJK UNIFIED IDEOGRAPH
  {0xF2EB, 0x59EA}, //15995 #CJK UNIFIED IDEOGRAPH
  {0xF2EC, 0x5AC9}, //15996 #CJK UNIFIED IDEOGRAPH
  {0xF2ED, 0x5E19}, //15997 #CJK UNIFIED IDEOGRAPH
  {0xF2EE, 0x684E}, //15998 #CJK UNIFIED IDEOGRAPH
  {0xF2EF, 0x74C6}, //15999 #CJK UNIFIED IDEOGRAPH
  {0xF2F0, 0x75BE}, //16000 #CJK UNIFIED IDEOGRAPH
  {0xF2F1, 0x79E9}, //16001 #CJK UNIFIED IDEOGRAPH
  {0xF2F2, 0x7A92}, //16002 #CJK UNIFIED IDEOGRAPH
  {0xF2F3, 0x81A3}, //16003 #CJK UNIFIED IDEOGRAPH
  {0xF2F4, 0x86ED}, //16004 #CJK UNIFIED IDEOGRAPH
  {0xF2F5, 0x8CEA}, //16005 #CJK UNIFIED IDEOGRAPH
  {0xF2F6, 0x8DCC}, //16006 #CJK UNIFIED IDEOGRAPH
  {0xF2F7, 0x8FED}, //16007 #CJK UNIFIED IDEOGRAPH
  {0xF2F8, 0x659F}, //16008 #CJK UNIFIED IDEOGRAPH
  {0xF2F9, 0x6715}, //16009 #CJK UNIFIED IDEOGRAPH
  {0xF2FA, 0xF9FD}, //16010 #CJK COMPATIBILITY IDEOGRAPH
  {0xF2FB, 0x57F7}, //16011 #CJK UNIFIED IDEOGRAPH
  {0xF2FC, 0x6F57}, //16012 #CJK UNIFIED IDEOGRAPH
  {0xF2FD, 0x7DDD}, //16013 #CJK UNIFIED IDEOGRAPH
  {0xF2FE, 0x8F2F}, //16014 #CJK UNIFIED IDEOGRAPH
  {0xF3A1, 0x93F6}, //16015 #CJK UNIFIED IDEOGRAPH
  {0xF3A2, 0x96C6}, //16016 #CJK UNIFIED IDEOGRAPH
  {0xF3A3, 0x5FB5}, //16017 #CJK UNIFIED IDEOGRAPH
  {0xF3A4, 0x61F2}, //16018 #CJK UNIFIED IDEOGRAPH
  {0xF3A5, 0x6F84}, //16019 #CJK UNIFIED IDEOGRAPH
  {0xF3A6, 0x4E14}, //16020 #CJK UNIFIED IDEOGRAPH
  {0xF3A7, 0x4F98}, //16021 #CJK UNIFIED IDEOGRAPH
  {0xF3A8, 0x501F}, //16022 #CJK UNIFIED IDEOGRAPH
  {0xF3A9, 0x53C9}, //16023 #CJK UNIFIED IDEOGRAPH
  {0xF3AA, 0x55DF}, //16024 #CJK UNIFIED IDEOGRAPH
  {0xF3AB, 0x5D6F}, //16025 #CJK UNIFIED IDEOGRAPH
  {0xF3AC, 0x5DEE}, //16026 #CJK UNIFIED IDEOGRAPH
  {0xF3AD, 0x6B21}, //16027 #CJK UNIFIED IDEOGRAPH
  {0xF3AE, 0x6B64}, //16028 #CJK UNIFIED IDEOGRAPH
  {0xF3AF, 0x78CB}, //16029 #CJK UNIFIED IDEOGRAPH
  {0xF3B0, 0x7B9A}, //16030 #CJK UNIFIED IDEOGRAPH
  {0xF3B1, 0xF9FE}, //16031 #CJK COMPATIBILITY IDEOGRAPH
  {0xF3B2, 0x8E49}, //16032 #CJK UNIFIED IDEOGRAPH
  {0xF3B3, 0x8ECA}, //16033 #CJK UNIFIED IDEOGRAPH
  {0xF3B4, 0x906E}, //16034 #CJK UNIFIED IDEOGRAPH
  {0xF3B5, 0x6349}, //16035 #CJK UNIFIED IDEOGRAPH
  {0xF3B6, 0x643E}, //16036 #CJK UNIFIED IDEOGRAPH
  {0xF3B7, 0x7740}, //16037 #CJK UNIFIED IDEOGRAPH
  {0xF3B8, 0x7A84}, //16038 #CJK UNIFIED IDEOGRAPH
  {0xF3B9, 0x932F}, //16039 #CJK UNIFIED IDEOGRAPH
  {0xF3BA, 0x947F}, //16040 #CJK UNIFIED IDEOGRAPH
  {0xF3BB, 0x9F6A}, //16041 #CJK UNIFIED IDEOGRAPH
  {0xF3BC, 0x64B0}, //16042 #CJK UNIFIED IDEOGRAPH
  {0xF3BD, 0x6FAF}, //16043 #CJK UNIFIED IDEOGRAPH
  {0xF3BE, 0x71E6}, //16044 #CJK UNIFIED IDEOGRAPH
  {0xF3BF, 0x74A8}, //16045 #CJK UNIFIED IDEOGRAPH
  {0xF3C0, 0x74DA}, //16046 #CJK UNIFIED IDEOGRAPH
  {0xF3C1, 0x7AC4}, //16047 #CJK UNIFIED IDEOGRAPH
  {0xF3C2, 0x7C12}, //16048 #CJK UNIFIED IDEOGRAPH
  {0xF3C3, 0x7E82}, //16049 #CJK UNIFIED IDEOGRAPH
  {0xF3C4, 0x7CB2}, //16050 #CJK UNIFIED IDEOGRAPH
  {0xF3C5, 0x7E98}, //16051 #CJK UNIFIED IDEOGRAPH
  {0xF3C6, 0x8B9A}, //16052 #CJK UNIFIED IDEOGRAPH
  {0xF3C7, 0x8D0A}, //16053 #CJK UNIFIED IDEOGRAPH
  {0xF3C8, 0x947D}, //16054 #CJK UNIFIED IDEOGRAPH
  {0xF3C9, 0x9910}, //16055 #CJK UNIFIED IDEOGRAPH
  {0xF3CA, 0x994C}, //16056 #CJK UNIFIED IDEOGRAPH
  {0xF3CB, 0x5239}, //16057 #CJK UNIFIED IDEOGRAPH
  {0xF3CC, 0x5BDF}, //16058 #CJK UNIFIED IDEOGRAPH
  {0xF3CD, 0x64E6}, //16059 #CJK UNIFIED IDEOGRAPH
  {0xF3CE, 0x672D}, //16060 #CJK UNIFIED IDEOGRAPH
  {0xF3CF, 0x7D2E}, //16061 #CJK UNIFIED IDEOGRAPH
  {0xF3D0, 0x50ED}, //16062 #CJK UNIFIED IDEOGRAPH
  {0xF3D1, 0x53C3}, //16063 #CJK UNIFIED IDEOGRAPH
  {0xF3D2, 0x5879}, //16064 #CJK UNIFIED IDEOGRAPH
  {0xF3D3, 0x6158}, //16065 #CJK UNIFIED IDEOGRAPH
  {0xF3D4, 0x6159}, //16066 #CJK UNIFIED IDEOGRAPH
  {0xF3D5, 0x61FA}, //16067 #CJK UNIFIED IDEOGRAPH
  {0xF3D6, 0x65AC}, //16068 #CJK UNIFIED IDEOGRAPH
  {0xF3D7, 0x7AD9}, //16069 #CJK UNIFIED IDEOGRAPH
  {0xF3D8, 0x8B92}, //16070 #CJK UNIFIED IDEOGRAPH
  {0xF3D9, 0x8B96}, //16071 #CJK UNIFIED IDEOGRAPH
  {0xF3DA, 0x5009}, //16072 #CJK UNIFIED IDEOGRAPH
  {0xF3DB, 0x5021}, //16073 #CJK UNIFIED IDEOGRAPH
  {0xF3DC, 0x5275}, //16074 #CJK UNIFIED IDEOGRAPH
  {0xF3DD, 0x5531}, //16075 #CJK UNIFIED IDEOGRAPH
  {0xF3DE, 0x5A3C}, //16076 #CJK UNIFIED IDEOGRAPH
  {0xF3DF, 0x5EE0}, //16077 #CJK UNIFIED IDEOGRAPH
  {0xF3E0, 0x5F70}, //16078 #CJK UNIFIED IDEOGRAPH
  {0xF3E1, 0x6134}, //16079 #CJK UNIFIED IDEOGRAPH
  {0xF3E2, 0x655E}, //16080 #CJK UNIFIED IDEOGRAPH
  {0xF3E3, 0x660C}, //16081 #CJK UNIFIED IDEOGRAPH
  {0xF3E4, 0x6636}, //16082 #CJK UNIFIED IDEOGRAPH
  {0xF3E5, 0x66A2}, //16083 #CJK UNIFIED IDEOGRAPH
  {0xF3E6, 0x69CD}, //16084 #CJK UNIFIED IDEOGRAPH
  {0xF3E7, 0x6EC4}, //16085 #CJK UNIFIED IDEOGRAPH
  {0xF3E8, 0x6F32}, //16086 #CJK UNIFIED IDEOGRAPH
  {0xF3E9, 0x7316}, //16087 #CJK UNIFIED IDEOGRAPH
  {0xF3EA, 0x7621}, //16088 #CJK UNIFIED IDEOGRAPH
  {0xF3EB, 0x7A93}, //16089 #CJK UNIFIED IDEOGRAPH
  {0xF3EC, 0x8139}, //16090 #CJK UNIFIED IDEOGRAPH
  {0xF3ED, 0x8259}, //16091 #CJK UNIFIED IDEOGRAPH
  {0xF3EE, 0x83D6}, //16092 #CJK UNIFIED IDEOGRAPH
  {0xF3EF, 0x84BC}, //16093 #CJK UNIFIED IDEOGRAPH
  {0xF3F0, 0x50B5}, //16094 #CJK UNIFIED IDEOGRAPH
  {0xF3F1, 0x57F0}, //16095 #CJK UNIFIED IDEOGRAPH
  {0xF3F2, 0x5BC0}, //16096 #CJK UNIFIED IDEOGRAPH
  {0xF3F3, 0x5BE8}, //16097 #CJK UNIFIED IDEOGRAPH
  {0xF3F4, 0x5F69}, //16098 #CJK UNIFIED IDEOGRAPH
  {0xF3F5, 0x63A1}, //16099 #CJK UNIFIED IDEOGRAPH
  {0xF3F6, 0x7826}, //16100 #CJK UNIFIED IDEOGRAPH
  {0xF3F7, 0x7DB5}, //16101 #CJK UNIFIED IDEOGRAPH
  {0xF3F8, 0x83DC}, //16102 #CJK UNIFIED IDEOGRAPH
  {0xF3F9, 0x8521}, //16103 #CJK UNIFIED IDEOGRAPH
  {0xF3FA, 0x91C7}, //16104 #CJK UNIFIED IDEOGRAPH
  {0xF3FB, 0x91F5}, //16105 #CJK UNIFIED IDEOGRAPH
  {0xF3FC, 0x518A}, //16106 #CJK UNIFIED IDEOGRAPH
  {0xF3FD, 0x67F5}, //16107 #CJK UNIFIED IDEOGRAPH
  {0xF3FE, 0x7B56}, //16108 #CJK UNIFIED IDEOGRAPH
  {0xF4A1, 0x8CAC}, //16109 #CJK UNIFIED IDEOGRAPH
  {0xF4A2, 0x51C4}, //16110 #CJK UNIFIED IDEOGRAPH
  {0xF4A3, 0x59BB}, //16111 #CJK UNIFIED IDEOGRAPH
  {0xF4A4, 0x60BD}, //16112 #CJK UNIFIED IDEOGRAPH
  {0xF4A5, 0x8655}, //16113 #CJK UNIFIED IDEOGRAPH
  {0xF4A6, 0x501C}, //16114 #CJK UNIFIED IDEOGRAPH
  {0xF4A7, 0xF9FF}, //16115 #CJK COMPATIBILITY IDEOGRAPH
  {0xF4A8, 0x5254}, //16116 #CJK UNIFIED IDEOGRAPH
  {0xF4A9, 0x5C3A}, //16117 #CJK UNIFIED IDEOGRAPH
  {0xF4AA, 0x617D}, //16118 #CJK UNIFIED IDEOGRAPH
  {0xF4AB, 0x621A}, //16119 #CJK UNIFIED IDEOGRAPH
  {0xF4AC, 0x62D3}, //16120 #CJK UNIFIED IDEOGRAPH
  {0xF4AD, 0x64F2}, //16121 #CJK UNIFIED IDEOGRAPH
  {0xF4AE, 0x65A5}, //16122 #CJK UNIFIED IDEOGRAPH
  {0xF4AF, 0x6ECC}, //16123 #CJK UNIFIED IDEOGRAPH
  {0xF4B0, 0x7620}, //16124 #CJK UNIFIED IDEOGRAPH
  {0xF4B1, 0x810A}, //16125 #CJK UNIFIED IDEOGRAPH
  {0xF4B2, 0x8E60}, //16126 #CJK UNIFIED IDEOGRAPH
  {0xF4B3, 0x965F}, //16127 #CJK UNIFIED IDEOGRAPH
  {0xF4B4, 0x96BB}, //16128 #CJK UNIFIED IDEOGRAPH
  {0xF4B5, 0x4EDF}, //16129 #CJK UNIFIED IDEOGRAPH
  {0xF4B6, 0x5343}, //16130 #CJK UNIFIED IDEOGRAPH
  {0xF4B7, 0x5598}, //16131 #CJK UNIFIED IDEOGRAPH
  {0xF4B8, 0x5929}, //16132 #CJK UNIFIED IDEOGRAPH
  {0xF4B9, 0x5DDD}, //16133 #CJK UNIFIED IDEOGRAPH
  {0xF4BA, 0x64C5}, //16134 #CJK UNIFIED IDEOGRAPH
  {0xF4BB, 0x6CC9}, //16135 #CJK UNIFIED IDEOGRAPH
  {0xF4BC, 0x6DFA}, //16136 #CJK UNIFIED IDEOGRAPH
  {0xF4BD, 0x7394}, //16137 #CJK UNIFIED IDEOGRAPH
  {0xF4BE, 0x7A7F}, //16138 #CJK UNIFIED IDEOGRAPH
  {0xF4BF, 0x821B}, //16139 #CJK UNIFIED IDEOGRAPH
  {0xF4C0, 0x85A6}, //16140 #CJK UNIFIED IDEOGRAPH
  {0xF4C1, 0x8CE4}, //16141 #CJK UNIFIED IDEOGRAPH
  {0xF4C2, 0x8E10}, //16142 #CJK UNIFIED IDEOGRAPH
  {0xF4C3, 0x9077}, //16143 #CJK UNIFIED IDEOGRAPH
  {0xF4C4, 0x91E7}, //16144 #CJK UNIFIED IDEOGRAPH
  {0xF4C5, 0x95E1}, //16145 #CJK UNIFIED IDEOGRAPH
  {0xF4C6, 0x9621}, //16146 #CJK UNIFIED IDEOGRAPH
  {0xF4C7, 0x97C6}, //16147 #CJK UNIFIED IDEOGRAPH
  {0xF4C8, 0x51F8}, //16148 #CJK UNIFIED IDEOGRAPH
  {0xF4C9, 0x54F2}, //16149 #CJK UNIFIED IDEOGRAPH
  {0xF4CA, 0x5586}, //16150 #CJK UNIFIED IDEOGRAPH
  {0xF4CB, 0x5FB9}, //16151 #CJK UNIFIED IDEOGRAPH
  {0xF4CC, 0x64A4}, //16152 #CJK UNIFIED IDEOGRAPH
  {0xF4CD, 0x6F88}, //16153 #CJK UNIFIED IDEOGRAPH
  {0xF4CE, 0x7DB4}, //16154 #CJK UNIFIED IDEOGRAPH
  {0xF4CF, 0x8F1F}, //16155 #CJK UNIFIED IDEOGRAPH
  {0xF4D0, 0x8F4D}, //16156 #CJK UNIFIED IDEOGRAPH
  {0xF4D1, 0x9435}, //16157 #CJK UNIFIED IDEOGRAPH
  {0xF4D2, 0x50C9}, //16158 #CJK UNIFIED IDEOGRAPH
  {0xF4D3, 0x5C16}, //16159 #CJK UNIFIED IDEOGRAPH
  {0xF4D4, 0x6CBE}, //16160 #CJK UNIFIED IDEOGRAPH
  {0xF4D5, 0x6DFB}, //16161 #CJK UNIFIED IDEOGRAPH
  {0xF4D6, 0x751B}, //16162 #CJK UNIFIED IDEOGRAPH
  {0xF4D7, 0x77BB}, //16163 #CJK UNIFIED IDEOGRAPH
  {0xF4D8, 0x7C3D}, //16164 #CJK UNIFIED IDEOGRAPH
  {0xF4D9, 0x7C64}, //16165 #CJK UNIFIED IDEOGRAPH
  {0xF4DA, 0x8A79}, //16166 #CJK UNIFIED IDEOGRAPH
  {0xF4DB, 0x8AC2}, //16167 #CJK UNIFIED IDEOGRAPH
  {0xF4DC, 0x581E}, //16168 #CJK UNIFIED IDEOGRAPH
  {0xF4DD, 0x59BE}, //16169 #CJK UNIFIED IDEOGRAPH
  {0xF4DE, 0x5E16}, //16170 #CJK UNIFIED IDEOGRAPH
  {0xF4DF, 0x6377}, //16171 #CJK UNIFIED IDEOGRAPH
  {0xF4E0, 0x7252}, //16172 #CJK UNIFIED IDEOGRAPH
  {0xF4E1, 0x758A}, //16173 #CJK UNIFIED IDEOGRAPH
  {0xF4E2, 0x776B}, //16174 #CJK UNIFIED IDEOGRAPH
  {0xF4E3, 0x8ADC}, //16175 #CJK UNIFIED IDEOGRAPH
  {0xF4E4, 0x8CBC}, //16176 #CJK UNIFIED IDEOGRAPH
  {0xF4E5, 0x8F12}, //16177 #CJK UNIFIED IDEOGRAPH
  {0xF4E6, 0x5EF3}, //16178 #CJK UNIFIED IDEOGRAPH
  {0xF4E7, 0x6674}, //16179 #CJK UNIFIED IDEOGRAPH
  {0xF4E8, 0x6DF8}, //16180 #CJK UNIFIED IDEOGRAPH
  {0xF4E9, 0x807D}, //16181 #CJK UNIFIED IDEOGRAPH
  {0xF4EA, 0x83C1}, //16182 #CJK UNIFIED IDEOGRAPH
  {0xF4EB, 0x8ACB}, //16183 #CJK UNIFIED IDEOGRAPH
  {0xF4EC, 0x9751}, //16184 #CJK UNIFIED IDEOGRAPH
  {0xF4ED, 0x9BD6}, //16185 #CJK UNIFIED IDEOGRAPH
  {0xF4EE, 0xFA00}, //16186 #CJK COMPATIBILITY IDEOGRAPH
  {0xF4EF, 0x5243}, //16187 #CJK UNIFIED IDEOGRAPH
  {0xF4F0, 0x66FF}, //16188 #CJK UNIFIED IDEOGRAPH
  {0xF4F1, 0x6D95}, //16189 #CJK UNIFIED IDEOGRAPH
  {0xF4F2, 0x6EEF}, //16190 #CJK UNIFIED IDEOGRAPH
  {0xF4F3, 0x7DE0}, //16191 #CJK UNIFIED IDEOGRAPH
  {0xF4F4, 0x8AE6}, //16192 #CJK UNIFIED IDEOGRAPH
  {0xF4F5, 0x902E}, //16193 #CJK UNIFIED IDEOGRAPH
  {0xF4F6, 0x905E}, //16194 #CJK UNIFIED IDEOGRAPH
  {0xF4F7, 0x9AD4}, //16195 #CJK UNIFIED IDEOGRAPH
  {0xF4F8, 0x521D}, //16196 #CJK UNIFIED IDEOGRAPH
  {0xF4F9, 0x527F}, //16197 #CJK UNIFIED IDEOGRAPH
  {0xF4FA, 0x54E8}, //16198 #CJK UNIFIED IDEOGRAPH
  {0xF4FB, 0x6194}, //16199 #CJK UNIFIED IDEOGRAPH
  {0xF4FC, 0x6284}, //16200 #CJK UNIFIED IDEOGRAPH
  {0xF4FD, 0x62DB}, //16201 #CJK UNIFIED IDEOGRAPH
  {0xF4FE, 0x68A2}, //16202 #CJK UNIFIED IDEOGRAPH
  {0xF5A1, 0x6912}, //16203 #CJK UNIFIED IDEOGRAPH
  {0xF5A2, 0x695A}, //16204 #CJK UNIFIED IDEOGRAPH
  {0xF5A3, 0x6A35}, //16205 #CJK UNIFIED IDEOGRAPH
  {0xF5A4, 0x7092}, //16206 #CJK UNIFIED IDEOGRAPH
  {0xF5A5, 0x7126}, //16207 #CJK UNIFIED IDEOGRAPH
  {0xF5A6, 0x785D}, //16208 #CJK UNIFIED IDEOGRAPH
  {0xF5A7, 0x7901}, //16209 #CJK UNIFIED IDEOGRAPH
  {0xF5A8, 0x790E}, //16210 #CJK UNIFIED IDEOGRAPH
  {0xF5A9, 0x79D2}, //16211 #CJK UNIFIED IDEOGRAPH
  {0xF5AA, 0x7A0D}, //16212 #CJK UNIFIED IDEOGRAPH
  {0xF5AB, 0x8096}, //16213 #CJK UNIFIED IDEOGRAPH
  {0xF5AC, 0x8278}, //16214 #CJK UNIFIED IDEOGRAPH
  {0xF5AD, 0x82D5}, //16215 #CJK UNIFIED IDEOGRAPH
  {0xF5AE, 0x8349}, //16216 #CJK UNIFIED IDEOGRAPH
  {0xF5AF, 0x8549}, //16217 #CJK UNIFIED IDEOGRAPH
  {0xF5B0, 0x8C82}, //16218 #CJK UNIFIED IDEOGRAPH
  {0xF5B1, 0x8D85}, //16219 #CJK UNIFIED IDEOGRAPH
  {0xF5B2, 0x9162}, //16220 #CJK UNIFIED IDEOGRAPH
  {0xF5B3, 0x918B}, //16221 #CJK UNIFIED IDEOGRAPH
  {0xF5B4, 0x91AE}, //16222 #CJK UNIFIED IDEOGRAPH
  {0xF5B5, 0x4FC3}, //16223 #CJK UNIFIED IDEOGRAPH
  {0xF5B6, 0x56D1}, //16224 #CJK UNIFIED IDEOGRAPH
  {0xF5B7, 0x71ED}, //16225 #CJK UNIFIED IDEOGRAPH
  {0xF5B8, 0x77D7}, //16226 #CJK UNIFIED IDEOGRAPH
  {0xF5B9, 0x8700}, //16227 #CJK UNIFIED IDEOGRAPH
  {0xF5BA, 0x89F8}, //16228 #CJK UNIFIED IDEOGRAPH
  {0xF5BB, 0x5BF8}, //16229 #CJK UNIFIED IDEOGRAPH
  {0xF5BC, 0x5FD6}, //16230 #CJK UNIFIED IDEOGRAPH
  {0xF5BD, 0x6751}, //16231 #CJK UNIFIED IDEOGRAPH
  {0xF5BE, 0x90A8}, //16232 #CJK UNIFIED IDEOGRAPH
  {0xF5BF, 0x53E2}, //16233 #CJK UNIFIED IDEOGRAPH
  {0xF5C0, 0x585A}, //16234 #CJK UNIFIED IDEOGRAPH
  {0xF5C1, 0x5BF5}, //16235 #CJK UNIFIED IDEOGRAPH
  {0xF5C2, 0x60A4}, //16236 #CJK UNIFIED IDEOGRAPH
  {0xF5C3, 0x6181}, //16237 #CJK UNIFIED IDEOGRAPH
  {0xF5C4, 0x6460}, //16238 #CJK UNIFIED IDEOGRAPH
  {0xF5C5, 0x7E3D}, //16239 #CJK UNIFIED IDEOGRAPH
  {0xF5C6, 0x8070}, //16240 #CJK UNIFIED IDEOGRAPH
  {0xF5C7, 0x8525}, //16241 #CJK UNIFIED IDEOGRAPH
  {0xF5C8, 0x9283}, //16242 #CJK UNIFIED IDEOGRAPH
  {0xF5C9, 0x64AE}, //16243 #CJK UNIFIED IDEOGRAPH
  {0xF5CA, 0x50AC}, //16244 #CJK UNIFIED IDEOGRAPH
  {0xF5CB, 0x5D14}, //16245 #CJK UNIFIED IDEOGRAPH
  {0xF5CC, 0x6700}, //16246 #CJK UNIFIED IDEOGRAPH
  {0xF5CD, 0x589C}, //16247 #CJK UNIFIED IDEOGRAPH
  {0xF5CE, 0x62BD}, //16248 #CJK UNIFIED IDEOGRAPH
  {0xF5CF, 0x63A8}, //16249 #CJK UNIFIED IDEOGRAPH
  {0xF5D0, 0x690E}, //16250 #CJK UNIFIED IDEOGRAPH
  {0xF5D1, 0x6978}, //16251 #CJK UNIFIED IDEOGRAPH
  {0xF5D2, 0x6A1E}, //16252 #CJK UNIFIED IDEOGRAPH
  {0xF5D3, 0x6E6B}, //16253 #CJK UNIFIED IDEOGRAPH
  {0xF5D4, 0x76BA}, //16254 #CJK UNIFIED IDEOGRAPH
  {0xF5D5, 0x79CB}, //16255 #CJK UNIFIED IDEOGRAPH
  {0xF5D6, 0x82BB}, //16256 #CJK UNIFIED IDEOGRAPH
  {0xF5D7, 0x8429}, //16257 #CJK UNIFIED IDEOGRAPH
  {0xF5D8, 0x8ACF}, //16258 #CJK UNIFIED IDEOGRAPH
  {0xF5D9, 0x8DA8}, //16259 #CJK UNIFIED IDEOGRAPH
  {0xF5DA, 0x8FFD}, //16260 #CJK UNIFIED IDEOGRAPH
  {0xF5DB, 0x9112}, //16261 #CJK UNIFIED IDEOGRAPH
  {0xF5DC, 0x914B}, //16262 #CJK UNIFIED IDEOGRAPH
  {0xF5DD, 0x919C}, //16263 #CJK UNIFIED IDEOGRAPH
  {0xF5DE, 0x9310}, //16264 #CJK UNIFIED IDEOGRAPH
  {0xF5DF, 0x9318}, //16265 #CJK UNIFIED IDEOGRAPH
  {0xF5E0, 0x939A}, //16266 #CJK UNIFIED IDEOGRAPH
  {0xF5E1, 0x96DB}, //16267 #CJK UNIFIED IDEOGRAPH
  {0xF5E2, 0x9A36}, //16268 #CJK UNIFIED IDEOGRAPH
  {0xF5E3, 0x9C0D}, //16269 #CJK UNIFIED IDEOGRAPH
  {0xF5E4, 0x4E11}, //16270 #CJK UNIFIED IDEOGRAPH
  {0xF5E5, 0x755C}, //16271 #CJK UNIFIED IDEOGRAPH
  {0xF5E6, 0x795D}, //16272 #CJK UNIFIED IDEOGRAPH
  {0xF5E7, 0x7AFA}, //16273 #CJK UNIFIED IDEOGRAPH
  {0xF5E8, 0x7B51}, //16274 #CJK UNIFIED IDEOGRAPH
  {0xF5E9, 0x7BC9}, //16275 #CJK UNIFIED IDEOGRAPH
  {0xF5EA, 0x7E2E}, //16276 #CJK UNIFIED IDEOGRAPH
  {0xF5EB, 0x84C4}, //16277 #CJK UNIFIED IDEOGRAPH
  {0xF5EC, 0x8E59}, //16278 #CJK UNIFIED IDEOGRAPH
  {0xF5ED, 0x8E74}, //16279 #CJK UNIFIED IDEOGRAPH
  {0xF5EE, 0x8EF8}, //16280 #CJK UNIFIED IDEOGRAPH
  {0xF5EF, 0x9010}, //16281 #CJK UNIFIED IDEOGRAPH
  {0xF5F0, 0x6625}, //16282 #CJK UNIFIED IDEOGRAPH
  {0xF5F1, 0x693F}, //16283 #CJK UNIFIED IDEOGRAPH
  {0xF5F2, 0x7443}, //16284 #CJK UNIFIED IDEOGRAPH
  {0xF5F3, 0x51FA}, //16285 #CJK UNIFIED IDEOGRAPH
  {0xF5F4, 0x672E}, //16286 #CJK UNIFIED IDEOGRAPH
  {0xF5F5, 0x9EDC}, //16287 #CJK UNIFIED IDEOGRAPH
  {0xF5F6, 0x5145}, //16288 #CJK UNIFIED IDEOGRAPH
  {0xF5F7, 0x5FE0}, //16289 #CJK UNIFIED IDEOGRAPH
  {0xF5F8, 0x6C96}, //16290 #CJK UNIFIED IDEOGRAPH
  {0xF5F9, 0x87F2}, //16291 #CJK UNIFIED IDEOGRAPH
  {0xF5FA, 0x885D}, //16292 #CJK UNIFIED IDEOGRAPH
  {0xF5FB, 0x8877}, //16293 #CJK UNIFIED IDEOGRAPH
  {0xF5FC, 0x60B4}, //16294 #CJK UNIFIED IDEOGRAPH
  {0xF5FD, 0x81B5}, //16295 #CJK UNIFIED IDEOGRAPH
  {0xF5FE, 0x8403}, //16296 #CJK UNIFIED IDEOGRAPH
  {0xF6A1, 0x8D05}, //16297 #CJK UNIFIED IDEOGRAPH
  {0xF6A2, 0x53D6}, //16298 #CJK UNIFIED IDEOGRAPH
  {0xF6A3, 0x5439}, //16299 #CJK UNIFIED IDEOGRAPH
  {0xF6A4, 0x5634}, //16300 #CJK UNIFIED IDEOGRAPH
  {0xF6A5, 0x5A36}, //16301 #CJK UNIFIED IDEOGRAPH
  {0xF6A6, 0x5C31}, //16302 #CJK UNIFIED IDEOGRAPH
  {0xF6A7, 0x708A}, //16303 #CJK UNIFIED IDEOGRAPH
  {0xF6A8, 0x7FE0}, //16304 #CJK UNIFIED IDEOGRAPH
  {0xF6A9, 0x805A}, //16305 #CJK UNIFIED IDEOGRAPH
  {0xF6AA, 0x8106}, //16306 #CJK UNIFIED IDEOGRAPH
  {0xF6AB, 0x81ED}, //16307 #CJK UNIFIED IDEOGRAPH
  {0xF6AC, 0x8DA3}, //16308 #CJK UNIFIED IDEOGRAPH
  {0xF6AD, 0x9189}, //16309 #CJK UNIFIED IDEOGRAPH
  {0xF6AE, 0x9A5F}, //16310 #CJK UNIFIED IDEOGRAPH
  {0xF6AF, 0x9DF2}, //16311 #CJK UNIFIED IDEOGRAPH
  {0xF6B0, 0x5074}, //16312 #CJK UNIFIED IDEOGRAPH
  {0xF6B1, 0x4EC4}, //16313 #CJK UNIFIED IDEOGRAPH
  {0xF6B2, 0x53A0}, //16314 #CJK UNIFIED IDEOGRAPH
  {0xF6B3, 0x60FB}, //16315 #CJK UNIFIED IDEOGRAPH
  {0xF6B4, 0x6E2C}, //16316 #CJK UNIFIED IDEOGRAPH
  {0xF6B5, 0x5C64}, //16317 #CJK UNIFIED IDEOGRAPH
  {0xF6B6, 0x4F88}, //16318 #CJK UNIFIED IDEOGRAPH
  {0xF6B7, 0x5024}, //16319 #CJK UNIFIED IDEOGRAPH
  {0xF6B8, 0x55E4}, //16320 #CJK UNIFIED IDEOGRAPH
  {0xF6B9, 0x5CD9}, //16321 #CJK UNIFIED IDEOGRAPH
  {0xF6BA, 0x5E5F}, //16322 #CJK UNIFIED IDEOGRAPH
  {0xF6BB, 0x6065}, //16323 #CJK UNIFIED IDEOGRAPH
  {0xF6BC, 0x6894}, //16324 #CJK UNIFIED IDEOGRAPH
  {0xF6BD, 0x6CBB}, //16325 #CJK UNIFIED IDEOGRAPH
  {0xF6BE, 0x6DC4}, //16326 #CJK UNIFIED IDEOGRAPH
  {0xF6BF, 0x71BE}, //16327 #CJK UNIFIED IDEOGRAPH
  {0xF6C0, 0x75D4}, //16328 #CJK UNIFIED IDEOGRAPH
  {0xF6C1, 0x75F4}, //16329 #CJK UNIFIED IDEOGRAPH
  {0xF6C2, 0x7661}, //16330 #CJK UNIFIED IDEOGRAPH
  {0xF6C3, 0x7A1A}, //16331 #CJK UNIFIED IDEOGRAPH
  {0xF6C4, 0x7A49}, //16332 #CJK UNIFIED IDEOGRAPH
  {0xF6C5, 0x7DC7}, //16333 #CJK UNIFIED IDEOGRAPH
  {0xF6C6, 0x7DFB}, //16334 #CJK UNIFIED IDEOGRAPH
  {0xF6C7, 0x7F6E}, //16335 #CJK UNIFIED IDEOGRAPH
  {0xF6C8, 0x81F4}, //16336 #CJK UNIFIED IDEOGRAPH
  {0xF6C9, 0x86A9}, //16337 #CJK UNIFIED IDEOGRAPH
  {0xF6CA, 0x8F1C}, //16338 #CJK UNIFIED IDEOGRAPH
  {0xF6CB, 0x96C9}, //16339 #CJK UNIFIED IDEOGRAPH
  {0xF6CC, 0x99B3}, //16340 #CJK UNIFIED IDEOGRAPH
  {0xF6CD, 0x9F52}, //16341 #CJK UNIFIED IDEOGRAPH
  {0xF6CE, 0x5247}, //16342 #CJK UNIFIED IDEOGRAPH
  {0xF6CF, 0x52C5}, //16343 #CJK UNIFIED IDEOGRAPH
  {0xF6D0, 0x98ED}, //16344 #CJK UNIFIED IDEOGRAPH
  {0xF6D1, 0x89AA}, //16345 #CJK UNIFIED IDEOGRAPH
  {0xF6D2, 0x4E03}, //16346 #CJK UNIFIED IDEOGRAPH
  {0xF6D3, 0x67D2}, //16347 #CJK UNIFIED IDEOGRAPH
  {0xF6D4, 0x6F06}, //16348 #CJK UNIFIED IDEOGRAPH
  {0xF6D5, 0x4FB5}, //16349 #CJK UNIFIED IDEOGRAPH
  {0xF6D6, 0x5BE2}, //16350 #CJK UNIFIED IDEOGRAPH
  {0xF6D7, 0x6795}, //16351 #CJK UNIFIED IDEOGRAPH
  {0xF6D8, 0x6C88}, //16352 #CJK UNIFIED IDEOGRAPH
  {0xF6D9, 0x6D78}, //16353 #CJK UNIFIED IDEOGRAPH
  {0xF6DA, 0x741B}, //16354 #CJK UNIFIED IDEOGRAPH
  {0xF6DB, 0x7827}, //16355 #CJK UNIFIED IDEOGRAPH
  {0xF6DC, 0x91DD}, //16356 #CJK UNIFIED IDEOGRAPH
  {0xF6DD, 0x937C}, //16357 #CJK UNIFIED IDEOGRAPH
  {0xF6DE, 0x87C4}, //16358 #CJK UNIFIED IDEOGRAPH
  {0xF6DF, 0x79E4}, //16359 #CJK UNIFIED IDEOGRAPH
  {0xF6E0, 0x7A31}, //16360 #CJK UNIFIED IDEOGRAPH
  {0xF6E1, 0x5FEB}, //16361 #CJK UNIFIED IDEOGRAPH
  {0xF6E2, 0x4ED6}, //16362 #CJK UNIFIED IDEOGRAPH
  {0xF6E3, 0x54A4}, //16363 #CJK UNIFIED IDEOGRAPH
  {0xF6E4, 0x553E}, //16364 #CJK UNIFIED IDEOGRAPH
  {0xF6E5, 0x58AE}, //16365 #CJK UNIFIED IDEOGRAPH
  {0xF6E6, 0x59A5}, //16366 #CJK UNIFIED IDEOGRAPH
  {0xF6E7, 0x60F0}, //16367 #CJK UNIFIED IDEOGRAPH
  {0xF6E8, 0x6253}, //16368 #CJK UNIFIED IDEOGRAPH
  {0xF6E9, 0x62D6}, //16369 #CJK UNIFIED IDEOGRAPH
  {0xF6EA, 0x6736}, //16370 #CJK UNIFIED IDEOGRAPH
  {0xF6EB, 0x6955}, //16371 #CJK UNIFIED IDEOGRAPH
  {0xF6EC, 0x8235}, //16372 #CJK UNIFIED IDEOGRAPH
  {0xF6ED, 0x9640}, //16373 #CJK UNIFIED IDEOGRAPH
  {0xF6EE, 0x99B1}, //16374 #CJK UNIFIED IDEOGRAPH
  {0xF6EF, 0x99DD}, //16375 #CJK UNIFIED IDEOGRAPH
  {0xF6F0, 0x502C}, //16376 #CJK UNIFIED IDEOGRAPH
  {0xF6F1, 0x5353}, //16377 #CJK UNIFIED IDEOGRAPH
  {0xF6F2, 0x5544}, //16378 #CJK UNIFIED IDEOGRAPH
  {0xF6F3, 0x577C}, //16379 #CJK UNIFIED IDEOGRAPH
  {0xF6F4, 0xFA01}, //16380 #CJK COMPATIBILITY IDEOGRAPH
  {0xF6F5, 0x6258}, //16381 #CJK UNIFIED IDEOGRAPH
  {0xF6F6, 0xFA02}, //16382 #CJK COMPATIBILITY IDEOGRAPH
  {0xF6F7, 0x64E2}, //16383 #CJK UNIFIED IDEOGRAPH
  {0xF6F8, 0x666B}, //16384 #CJK UNIFIED IDEOGRAPH
  {0xF6F9, 0x67DD}, //16385 #CJK UNIFIED IDEOGRAPH
  {0xF6FA, 0x6FC1}, //16386 #CJK UNIFIED IDEOGRAPH
  {0xF6FB, 0x6FEF}, //16387 #CJK UNIFIED IDEOGRAPH
  {0xF6FC, 0x7422}, //16388 #CJK UNIFIED IDEOGRAPH
  {0xF6FD, 0x7438}, //16389 #CJK UNIFIED IDEOGRAPH
  {0xF6FE, 0x8A17}, //16390 #CJK UNIFIED IDEOGRAPH
  {0xF7A1, 0x9438}, //16391 #CJK UNIFIED IDEOGRAPH
  {0xF7A2, 0x5451}, //16392 #CJK UNIFIED IDEOGRAPH
  {0xF7A3, 0x5606}, //16393 #CJK UNIFIED IDEOGRAPH
  {0xF7A4, 0x5766}, //16394 #CJK UNIFIED IDEOGRAPH
  {0xF7A5, 0x5F48}, //16395 #CJK UNIFIED IDEOGRAPH
  {0xF7A6, 0x619A}, //16396 #CJK UNIFIED IDEOGRAPH
  {0xF7A7, 0x6B4E}, //16397 #CJK UNIFIED IDEOGRAPH
  {0xF7A8, 0x7058}, //16398 #CJK UNIFIED IDEOGRAPH
  {0xF7A9, 0x70AD}, //16399 #CJK UNIFIED IDEOGRAPH
  {0xF7AA, 0x7DBB}, //16400 #CJK UNIFIED IDEOGRAPH
  {0xF7AB, 0x8A95}, //16401 #CJK UNIFIED IDEOGRAPH
  {0xF7AC, 0x596A}, //16402 #CJK UNIFIED IDEOGRAPH
  {0xF7AD, 0x812B}, //16403 #CJK UNIFIED IDEOGRAPH
  {0xF7AE, 0x63A2}, //16404 #CJK UNIFIED IDEOGRAPH
  {0xF7AF, 0x7708}, //16405 #CJK UNIFIED IDEOGRAPH
  {0xF7B0, 0x803D}, //16406 #CJK UNIFIED IDEOGRAPH
  {0xF7B1, 0x8CAA}, //16407 #CJK UNIFIED IDEOGRAPH
  {0xF7B2, 0x5854}, //16408 #CJK UNIFIED IDEOGRAPH
  {0xF7B3, 0x642D}, //16409 #CJK UNIFIED IDEOGRAPH
  {0xF7B4, 0x69BB}, //16410 #CJK UNIFIED IDEOGRAPH
  {0xF7B5, 0x5B95}, //16411 #CJK UNIFIED IDEOGRAPH
  {0xF7B6, 0x5E11}, //16412 #CJK UNIFIED IDEOGRAPH
  {0xF7B7, 0x6E6F}, //16413 #CJK UNIFIED IDEOGRAPH
  {0xF7B8, 0xFA03}, //16414 #CJK COMPATIBILITY IDEOGRAPH
  {0xF7B9, 0x8569}, //16415 #CJK UNIFIED IDEOGRAPH
  {0xF7BA, 0x514C}, //16416 #CJK UNIFIED IDEOGRAPH
  {0xF7BB, 0x53F0}, //16417 #CJK UNIFIED IDEOGRAPH
  {0xF7BC, 0x592A}, //16418 #CJK UNIFIED IDEOGRAPH
  {0xF7BD, 0x6020}, //16419 #CJK UNIFIED IDEOGRAPH
  {0xF7BE, 0x614B}, //16420 #CJK UNIFIED IDEOGRAPH
  {0xF7BF, 0x6B86}, //16421 #CJK UNIFIED IDEOGRAPH
  {0xF7C0, 0x6C70}, //16422 #CJK UNIFIED IDEOGRAPH
  {0xF7C1, 0x6CF0}, //16423 #CJK UNIFIED IDEOGRAPH
  {0xF7C2, 0x7B1E}, //16424 #CJK UNIFIED IDEOGRAPH
  {0xF7C3, 0x80CE}, //16425 #CJK UNIFIED IDEOGRAPH
  {0xF7C4, 0x82D4}, //16426 #CJK UNIFIED IDEOGRAPH
  {0xF7C5, 0x8DC6}, //16427 #CJK UNIFIED IDEOGRAPH
  {0xF7C6, 0x90B0}, //16428 #CJK UNIFIED IDEOGRAPH
  {0xF7C7, 0x98B1}, //16429 #CJK UNIFIED IDEOGRAPH
  {0xF7C8, 0xFA04}, //16430 #CJK COMPATIBILITY IDEOGRAPH
  {0xF7C9, 0x64C7}, //16431 #CJK UNIFIED IDEOGRAPH
  {0xF7CA, 0x6FA4}, //16432 #CJK UNIFIED IDEOGRAPH
  {0xF7CB, 0x6491}, //16433 #CJK UNIFIED IDEOGRAPH
  {0xF7CC, 0x6504}, //16434 #CJK UNIFIED IDEOGRAPH
  {0xF7CD, 0x514E}, //16435 #CJK UNIFIED IDEOGRAPH
  {0xF7CE, 0x5410}, //16436 #CJK UNIFIED IDEOGRAPH
  {0xF7CF, 0x571F}, //16437 #CJK UNIFIED IDEOGRAPH
  {0xF7D0, 0x8A0E}, //16438 #CJK UNIFIED IDEOGRAPH
  {0xF7D1, 0x615F}, //16439 #CJK UNIFIED IDEOGRAPH
  {0xF7D2, 0x6876}, //16440 #CJK UNIFIED IDEOGRAPH
  {0xF7D3, 0xFA05}, //16441 #CJK COMPATIBILITY IDEOGRAPH
  {0xF7D4, 0x75DB}, //16442 #CJK UNIFIED IDEOGRAPH
  {0xF7D5, 0x7B52}, //16443 #CJK UNIFIED IDEOGRAPH
  {0xF7D6, 0x7D71}, //16444 #CJK UNIFIED IDEOGRAPH
  {0xF7D7, 0x901A}, //16445 #CJK UNIFIED IDEOGRAPH
  {0xF7D8, 0x5806}, //16446 #CJK UNIFIED IDEOGRAPH
  {0xF7D9, 0x69CC}, //16447 #CJK UNIFIED IDEOGRAPH
  {0xF7DA, 0x817F}, //16448 #CJK UNIFIED IDEOGRAPH
  {0xF7DB, 0x892A}, //16449 #CJK UNIFIED IDEOGRAPH
  {0xF7DC, 0x9000}, //16450 #CJK UNIFIED IDEOGRAPH
  {0xF7DD, 0x9839}, //16451 #CJK UNIFIED IDEOGRAPH
  {0xF7DE, 0x5078}, //16452 #CJK UNIFIED IDEOGRAPH
  {0xF7DF, 0x5957}, //16453 #CJK UNIFIED IDEOGRAPH
  {0xF7E0, 0x59AC}, //16454 #CJK UNIFIED IDEOGRAPH
  {0xF7E1, 0x6295}, //16455 #CJK UNIFIED IDEOGRAPH
  {0xF7E2, 0x900F}, //16456 #CJK UNIFIED IDEOGRAPH
  {0xF7E3, 0x9B2A}, //16457 #CJK UNIFIED IDEOGRAPH
  {0xF7E4, 0x615D}, //16458 #CJK UNIFIED IDEOGRAPH
  {0xF7E5, 0x7279}, //16459 #CJK UNIFIED IDEOGRAPH
  {0xF7E6, 0x95D6}, //16460 #CJK UNIFIED IDEOGRAPH
  {0xF7E7, 0x5761}, //16461 #CJK UNIFIED IDEOGRAPH
  {0xF7E8, 0x5A46}, //16462 #CJK UNIFIED IDEOGRAPH
  {0xF7E9, 0x5DF4}, //16463 #CJK UNIFIED IDEOGRAPH
  {0xF7EA, 0x628A}, //16464 #CJK UNIFIED IDEOGRAPH
  {0xF7EB, 0x64AD}, //16465 #CJK UNIFIED IDEOGRAPH
  {0xF7EC, 0x64FA}, //16466 #CJK UNIFIED IDEOGRAPH
  {0xF7ED, 0x6777}, //16467 #CJK UNIFIED IDEOGRAPH
  {0xF7EE, 0x6CE2}, //16468 #CJK UNIFIED IDEOGRAPH
  {0xF7EF, 0x6D3E}, //16469 #CJK UNIFIED IDEOGRAPH
  {0xF7F0, 0x722C}, //16470 #CJK UNIFIED IDEOGRAPH
  {0xF7F1, 0x7436}, //16471 #CJK UNIFIED IDEOGRAPH
  {0xF7F2, 0x7834}, //16472 #CJK UNIFIED IDEOGRAPH
  {0xF7F3, 0x7F77}, //16473 #CJK UNIFIED IDEOGRAPH
  {0xF7F4, 0x82AD}, //16474 #CJK UNIFIED IDEOGRAPH
  {0xF7F5, 0x8DDB}, //16475 #CJK UNIFIED IDEOGRAPH
  {0xF7F6, 0x9817}, //16476 #CJK UNIFIED IDEOGRAPH
  {0xF7F7, 0x5224}, //16477 #CJK UNIFIED IDEOGRAPH
  {0xF7F8, 0x5742}, //16478 #CJK UNIFIED IDEOGRAPH
  {0xF7F9, 0x677F}, //16479 #CJK UNIFIED IDEOGRAPH
  {0xF7FA, 0x7248}, //16480 #CJK UNIFIED IDEOGRAPH
  {0xF7FB, 0x74E3}, //16481 #CJK UNIFIED IDEOGRAPH
  {0xF7FC, 0x8CA9}, //16482 #CJK UNIFIED IDEOGRAPH
  {0xF7FD, 0x8FA6}, //16483 #CJK UNIFIED IDEOGRAPH
  {0xF7FE, 0x9211}, //16484 #CJK UNIFIED IDEOGRAPH
  {0xF8A1, 0x962A}, //16485 #CJK UNIFIED IDEOGRAPH
  {0xF8A2, 0x516B}, //16486 #CJK UNIFIED IDEOGRAPH
  {0xF8A3, 0x53ED}, //16487 #CJK UNIFIED IDEOGRAPH
  {0xF8A4, 0x634C}, //16488 #CJK UNIFIED IDEOGRAPH
  {0xF8A5, 0x4F69}, //16489 #CJK UNIFIED IDEOGRAPH
  {0xF8A6, 0x5504}, //16490 #CJK UNIFIED IDEOGRAPH
  {0xF8A7, 0x6096}, //16491 #CJK UNIFIED IDEOGRAPH
  {0xF8A8, 0x6557}, //16492 #CJK UNIFIED IDEOGRAPH
  {0xF8A9, 0x6C9B}, //16493 #CJK UNIFIED IDEOGRAPH
  {0xF8AA, 0x6D7F}, //16494 #CJK UNIFIED IDEOGRAPH
  {0xF8AB, 0x724C}, //16495 #CJK UNIFIED IDEOGRAPH
  {0xF8AC, 0x72FD}, //16496 #CJK UNIFIED IDEOGRAPH
  {0xF8AD, 0x7A17}, //16497 #CJK UNIFIED IDEOGRAPH
  {0xF8AE, 0x8987}, //16498 #CJK UNIFIED IDEOGRAPH
  {0xF8AF, 0x8C9D}, //16499 #CJK UNIFIED IDEOGRAPH
  {0xF8B0, 0x5F6D}, //16500 #CJK UNIFIED IDEOGRAPH
  {0xF8B1, 0x6F8E}, //16501 #CJK UNIFIED IDEOGRAPH
  {0xF8B2, 0x70F9}, //16502 #CJK UNIFIED IDEOGRAPH
  {0xF8B3, 0x81A8}, //16503 #CJK UNIFIED IDEOGRAPH
  {0xF8B4, 0x610E}, //16504 #CJK UNIFIED IDEOGRAPH
  {0xF8B5, 0x4FBF}, //16505 #CJK UNIFIED IDEOGRAPH
  {0xF8B6, 0x504F}, //16506 #CJK UNIFIED IDEOGRAPH
  {0xF8B7, 0x6241}, //16507 #CJK UNIFIED IDEOGRAPH
  {0xF8B8, 0x7247}, //16508 #CJK UNIFIED IDEOGRAPH
  {0xF8B9, 0x7BC7}, //16509 #CJK UNIFIED IDEOGRAPH
  {0xF8BA, 0x7DE8}, //16510 #CJK UNIFIED IDEOGRAPH
  {0xF8BB, 0x7FE9}, //16511 #CJK UNIFIED IDEOGRAPH
  {0xF8BC, 0x904D}, //16512 #CJK UNIFIED IDEOGRAPH
  {0xF8BD, 0x97AD}, //16513 #CJK UNIFIED IDEOGRAPH
  {0xF8BE, 0x9A19}, //16514 #CJK UNIFIED IDEOGRAPH
  {0xF8BF, 0x8CB6}, //16515 #CJK UNIFIED IDEOGRAPH
  {0xF8C0, 0x576A}, //16516 #CJK UNIFIED IDEOGRAPH
  {0xF8C1, 0x5E73}, //16517 #CJK UNIFIED IDEOGRAPH
  {0xF8C2, 0x67B0}, //16518 #CJK UNIFIED IDEOGRAPH
  {0xF8C3, 0x840D}, //16519 #CJK UNIFIED IDEOGRAPH
  {0xF8C4, 0x8A55}, //16520 #CJK UNIFIED IDEOGRAPH
  {0xF8C5, 0x5420}, //16521 #CJK UNIFIED IDEOGRAPH
  {0xF8C6, 0x5B16}, //16522 #CJK UNIFIED IDEOGRAPH
  {0xF8C7, 0x5E63}, //16523 #CJK UNIFIED IDEOGRAPH
  {0xF8C8, 0x5EE2}, //16524 #CJK UNIFIED IDEOGRAPH
  {0xF8C9, 0x5F0A}, //16525 #CJK UNIFIED IDEOGRAPH
  {0xF8CA, 0x6583}, //16526 #CJK UNIFIED IDEOGRAPH
  {0xF8CB, 0x80BA}, //16527 #CJK UNIFIED IDEOGRAPH
  {0xF8CC, 0x853D}, //16528 #CJK UNIFIED IDEOGRAPH
  {0xF8CD, 0x9589}, //16529 #CJK UNIFIED IDEOGRAPH
  {0xF8CE, 0x965B}, //16530 #CJK UNIFIED IDEOGRAPH
  {0xF8CF, 0x4F48}, //16531 #CJK UNIFIED IDEOGRAPH
  {0xF8D0, 0x5305}, //16532 #CJK UNIFIED IDEOGRAPH
  {0xF8D1, 0x530D}, //16533 #CJK UNIFIED IDEOGRAPH
  {0xF8D2, 0x530F}, //16534 #CJK UNIFIED IDEOGRAPH
  {0xF8D3, 0x5486}, //16535 #CJK UNIFIED IDEOGRAPH
  {0xF8D4, 0x54FA}, //16536 #CJK UNIFIED IDEOGRAPH
  {0xF8D5, 0x5703}, //16537 #CJK UNIFIED IDEOGRAPH
  {0xF8D6, 0x5E03}, //16538 #CJK UNIFIED IDEOGRAPH
  {0xF8D7, 0x6016}, //16539 #CJK UNIFIED IDEOGRAPH
  {0xF8D8, 0x629B}, //16540 #CJK UNIFIED IDEOGRAPH
  {0xF8D9, 0x62B1}, //16541 #CJK UNIFIED IDEOGRAPH
  {0xF8DA, 0x6355}, //16542 #CJK UNIFIED IDEOGRAPH
  {0xF8DB, 0xFA06}, //16543 #CJK COMPATIBILITY IDEOGRAPH
  {0xF8DC, 0x6CE1}, //16544 #CJK UNIFIED IDEOGRAPH
  {0xF8DD, 0x6D66}, //16545 #CJK UNIFIED IDEOGRAPH
  {0xF8DE, 0x75B1}, //16546 #CJK UNIFIED IDEOGRAPH
  {0xF8DF, 0x7832}, //16547 #CJK UNIFIED IDEOGRAPH
  {0xF8E0, 0x80DE}, //16548 #CJK UNIFIED IDEOGRAPH
  {0xF8E1, 0x812F}, //16549 #CJK UNIFIED IDEOGRAPH
  {0xF8E2, 0x82DE}, //16550 #CJK UNIFIED IDEOGRAPH
  {0xF8E3, 0x8461}, //16551 #CJK UNIFIED IDEOGRAPH
  {0xF8E4, 0x84B2}, //16552 #CJK UNIFIED IDEOGRAPH
  {0xF8E5, 0x888D}, //16553 #CJK UNIFIED IDEOGRAPH
  {0xF8E6, 0x8912}, //16554 #CJK UNIFIED IDEOGRAPH
  {0xF8E7, 0x900B}, //16555 #CJK UNIFIED IDEOGRAPH
  {0xF8E8, 0x92EA}, //16556 #CJK UNIFIED IDEOGRAPH
  {0xF8E9, 0x98FD}, //16557 #CJK UNIFIED IDEOGRAPH
  {0xF8EA, 0x9B91}, //16558 #CJK UNIFIED IDEOGRAPH
  {0xF8EB, 0x5E45}, //16559 #CJK UNIFIED IDEOGRAPH
  {0xF8EC, 0x66B4}, //16560 #CJK UNIFIED IDEOGRAPH
  {0xF8ED, 0x66DD}, //16561 #CJK UNIFIED IDEOGRAPH
  {0xF8EE, 0x7011}, //16562 #CJK UNIFIED IDEOGRAPH
  {0xF8EF, 0x7206}, //16563 #CJK UNIFIED IDEOGRAPH
  {0xF8F0, 0xFA07}, //16564 #CJK COMPATIBILITY IDEOGRAPH
  {0xF8F1, 0x4FF5}, //16565 #CJK UNIFIED IDEOGRAPH
  {0xF8F2, 0x527D}, //16566 #CJK UNIFIED IDEOGRAPH
  {0xF8F3, 0x5F6A}, //16567 #CJK UNIFIED IDEOGRAPH
  {0xF8F4, 0x6153}, //16568 #CJK UNIFIED IDEOGRAPH
  {0xF8F5, 0x6753}, //16569 #CJK UNIFIED IDEOGRAPH
  {0xF8F6, 0x6A19}, //16570 #CJK UNIFIED IDEOGRAPH
  {0xF8F7, 0x6F02}, //16571 #CJK UNIFIED IDEOGRAPH
  {0xF8F8, 0x74E2}, //16572 #CJK UNIFIED IDEOGRAPH
  {0xF8F9, 0x7968}, //16573 #CJK UNIFIED IDEOGRAPH
  {0xF8FA, 0x8868}, //16574 #CJK UNIFIED IDEOGRAPH
  {0xF8FB, 0x8C79}, //16575 #CJK UNIFIED IDEOGRAPH
  {0xF8FC, 0x98C7}, //16576 #CJK UNIFIED IDEOGRAPH
  {0xF8FD, 0x98C4}, //16577 #CJK UNIFIED IDEOGRAPH
  {0xF8FE, 0x9A43}, //16578 #CJK UNIFIED IDEOGRAPH
  {0xF9A1, 0x54C1}, //16579 #CJK UNIFIED IDEOGRAPH
  {0xF9A2, 0x7A1F}, //16580 #CJK UNIFIED IDEOGRAPH
  {0xF9A3, 0x6953}, //16581 #CJK UNIFIED IDEOGRAPH
  {0xF9A4, 0x8AF7}, //16582 #CJK UNIFIED IDEOGRAPH
  {0xF9A5, 0x8C4A}, //16583 #CJK UNIFIED IDEOGRAPH
  {0xF9A6, 0x98A8}, //16584 #CJK UNIFIED IDEOGRAPH
  {0xF9A7, 0x99AE}, //16585 #CJK UNIFIED IDEOGRAPH
  {0xF9A8, 0x5F7C}, //16586 #CJK UNIFIED IDEOGRAPH
  {0xF9A9, 0x62AB}, //16587 #CJK UNIFIED IDEOGRAPH
  {0xF9AA, 0x75B2}, //16588 #CJK UNIFIED IDEOGRAPH
  {0xF9AB, 0x76AE}, //16589 #CJK UNIFIED IDEOGRAPH
  {0xF9AC, 0x88AB}, //16590 #CJK UNIFIED IDEOGRAPH
  {0xF9AD, 0x907F}, //16591 #CJK UNIFIED IDEOGRAPH
  {0xF9AE, 0x9642}, //16592 #CJK UNIFIED IDEOGRAPH
  {0xF9AF, 0x5339}, //16593 #CJK UNIFIED IDEOGRAPH
  {0xF9B0, 0x5F3C}, //16594 #CJK UNIFIED IDEOGRAPH
  {0xF9B1, 0x5FC5}, //16595 #CJK UNIFIED IDEOGRAPH
  {0xF9B2, 0x6CCC}, //16596 #CJK UNIFIED IDEOGRAPH
  {0xF9B3, 0x73CC}, //16597 #CJK UNIFIED IDEOGRAPH
  {0xF9B4, 0x7562}, //16598 #CJK UNIFIED IDEOGRAPH
  {0xF9B5, 0x758B}, //16599 #CJK UNIFIED IDEOGRAPH
  {0xF9B6, 0x7B46}, //16600 #CJK UNIFIED IDEOGRAPH
  {0xF9B7, 0x82FE}, //16601 #CJK UNIFIED IDEOGRAPH
  {0xF9B8, 0x999D}, //16602 #CJK UNIFIED IDEOGRAPH
  {0xF9B9, 0x4E4F}, //16603 #CJK UNIFIED IDEOGRAPH
  {0xF9BA, 0x903C}, //16604 #CJK UNIFIED IDEOGRAPH
  {0xF9BB, 0x4E0B}, //16605 #CJK UNIFIED IDEOGRAPH
  {0xF9BC, 0x4F55}, //16606 #CJK UNIFIED IDEOGRAPH
  {0xF9BD, 0x53A6}, //16607 #CJK UNIFIED IDEOGRAPH
  {0xF9BE, 0x590F}, //16608 #CJK UNIFIED IDEOGRAPH
  {0xF9BF, 0x5EC8}, //16609 #CJK UNIFIED IDEOGRAPH
  {0xF9C0, 0x6630}, //16610 #CJK UNIFIED IDEOGRAPH
  {0xF9C1, 0x6CB3}, //16611 #CJK UNIFIED IDEOGRAPH
  {0xF9C2, 0x7455}, //16612 #CJK UNIFIED IDEOGRAPH
  {0xF9C3, 0x8377}, //16613 #CJK UNIFIED IDEOGRAPH
  {0xF9C4, 0x8766}, //16614 #CJK UNIFIED IDEOGRAPH
  {0xF9C5, 0x8CC0}, //16615 #CJK UNIFIED IDEOGRAPH
  {0xF9C6, 0x9050}, //16616 #CJK UNIFIED IDEOGRAPH
  {0xF9C7, 0x971E}, //16617 #CJK UNIFIED IDEOGRAPH
  {0xF9C8, 0x9C15}, //16618 #CJK UNIFIED IDEOGRAPH
  {0xF9C9, 0x58D1}, //16619 #CJK UNIFIED IDEOGRAPH
  {0xF9CA, 0x5B78}, //16620 #CJK UNIFIED IDEOGRAPH
  {0xF9CB, 0x8650}, //16621 #CJK UNIFIED IDEOGRAPH
  {0xF9CC, 0x8B14}, //16622 #CJK UNIFIED IDEOGRAPH
  {0xF9CD, 0x9DB4}, //16623 #CJK UNIFIED IDEOGRAPH
  {0xF9CE, 0x5BD2}, //16624 #CJK UNIFIED IDEOGRAPH
  {0xF9CF, 0x6068}, //16625 #CJK UNIFIED IDEOGRAPH
  {0xF9D0, 0x608D}, //16626 #CJK UNIFIED IDEOGRAPH
  {0xF9D1, 0x65F1}, //16627 #CJK UNIFIED IDEOGRAPH
  {0xF9D2, 0x6C57}, //16628 #CJK UNIFIED IDEOGRAPH
  {0xF9D3, 0x6F22}, //16629 #CJK UNIFIED IDEOGRAPH
  {0xF9D4, 0x6FA3}, //16630 #CJK UNIFIED IDEOGRAPH
  {0xF9D5, 0x701A}, //16631 #CJK UNIFIED IDEOGRAPH
  {0xF9D6, 0x7F55}, //16632 #CJK UNIFIED IDEOGRAPH
  {0xF9D7, 0x7FF0}, //16633 #CJK UNIFIED IDEOGRAPH
  {0xF9D8, 0x9591}, //16634 #CJK UNIFIED IDEOGRAPH
  {0xF9D9, 0x9592}, //16635 #CJK UNIFIED IDEOGRAPH
  {0xF9DA, 0x9650}, //16636 #CJK UNIFIED IDEOGRAPH
  {0xF9DB, 0x97D3}, //16637 #CJK UNIFIED IDEOGRAPH
  {0xF9DC, 0x5272}, //16638 #CJK UNIFIED IDEOGRAPH
  {0xF9DD, 0x8F44}, //16639 #CJK UNIFIED IDEOGRAPH
  {0xF9DE, 0x51FD}, //16640 #CJK UNIFIED IDEOGRAPH
  {0xF9DF, 0x542B}, //16641 #CJK UNIFIED IDEOGRAPH
  {0xF9E0, 0x54B8}, //16642 #CJK UNIFIED IDEOGRAPH
  {0xF9E1, 0x5563}, //16643 #CJK UNIFIED IDEOGRAPH
  {0xF9E2, 0x558A}, //16644 #CJK UNIFIED IDEOGRAPH
  {0xF9E3, 0x6ABB}, //16645 #CJK UNIFIED IDEOGRAPH
  {0xF9E4, 0x6DB5}, //16646 #CJK UNIFIED IDEOGRAPH
  {0xF9E5, 0x7DD8}, //16647 #CJK UNIFIED IDEOGRAPH
  {0xF9E6, 0x8266}, //16648 #CJK UNIFIED IDEOGRAPH
  {0xF9E7, 0x929C}, //16649 #CJK UNIFIED IDEOGRAPH
  {0xF9E8, 0x9677}, //16650 #CJK UNIFIED IDEOGRAPH
  {0xF9E9, 0x9E79}, //16651 #CJK UNIFIED IDEOGRAPH
  {0xF9EA, 0x5408}, //16652 #CJK UNIFIED IDEOGRAPH
  {0xF9EB, 0x54C8}, //16653 #CJK UNIFIED IDEOGRAPH
  {0xF9EC, 0x76D2}, //16654 #CJK UNIFIED IDEOGRAPH
  {0xF9ED, 0x86E4}, //16655 #CJK UNIFIED IDEOGRAPH
  {0xF9EE, 0x95A4}, //16656 #CJK UNIFIED IDEOGRAPH
  {0xF9EF, 0x95D4}, //16657 #CJK UNIFIED IDEOGRAPH
  {0xF9F0, 0x965C}, //16658 #CJK UNIFIED IDEOGRAPH
  {0xF9F1, 0x4EA2}, //16659 #CJK UNIFIED IDEOGRAPH
  {0xF9F2, 0x4F09}, //16660 #CJK UNIFIED IDEOGRAPH
  {0xF9F3, 0x59EE}, //16661 #CJK UNIFIED IDEOGRAPH
  {0xF9F4, 0x5AE6}, //16662 #CJK UNIFIED IDEOGRAPH
  {0xF9F5, 0x5DF7}, //16663 #CJK UNIFIED IDEOGRAPH
  {0xF9F6, 0x6052}, //16664 #CJK UNIFIED IDEOGRAPH
  {0xF9F7, 0x6297}, //16665 #CJK UNIFIED IDEOGRAPH
  {0xF9F8, 0x676D}, //16666 #CJK UNIFIED IDEOGRAPH
  {0xF9F9, 0x6841}, //16667 #CJK UNIFIED IDEOGRAPH
  {0xF9FA, 0x6C86}, //16668 #CJK UNIFIED IDEOGRAPH
  {0xF9FB, 0x6E2F}, //16669 #CJK UNIFIED IDEOGRAPH
  {0xF9FC, 0x7F38}, //16670 #CJK UNIFIED IDEOGRAPH
  {0xF9FD, 0x809B}, //16671 #CJK UNIFIED IDEOGRAPH
  {0xF9FE, 0x822A}, //16672 #CJK UNIFIED IDEOGRAPH
  {0xFAA1, 0xFA08}, //16673 #CJK COMPATIBILITY IDEOGRAPH
  {0xFAA2, 0xFA09}, //16674 #CJK COMPATIBILITY IDEOGRAPH
  {0xFAA3, 0x9805}, //16675 #CJK UNIFIED IDEOGRAPH
  {0xFAA4, 0x4EA5}, //16676 #CJK UNIFIED IDEOGRAPH
  {0xFAA5, 0x5055}, //16677 #CJK UNIFIED IDEOGRAPH
  {0xFAA6, 0x54B3}, //16678 #CJK UNIFIED IDEOGRAPH
  {0xFAA7, 0x5793}, //16679 #CJK UNIFIED IDEOGRAPH
  {0xFAA8, 0x595A}, //16680 #CJK UNIFIED IDEOGRAPH
  {0xFAA9, 0x5B69}, //16681 #CJK UNIFIED IDEOGRAPH
  {0xFAAA, 0x5BB3}, //16682 #CJK UNIFIED IDEOGRAPH
  {0xFAAB, 0x61C8}, //16683 #CJK UNIFIED IDEOGRAPH
  {0xFAAC, 0x6977}, //16684 #CJK UNIFIED IDEOGRAPH
  {0xFAAD, 0x6D77}, //16685 #CJK UNIFIED IDEOGRAPH
  {0xFAAE, 0x7023}, //16686 #CJK UNIFIED IDEOGRAPH
  {0xFAAF, 0x87F9}, //16687 #CJK UNIFIED IDEOGRAPH
  {0xFAB0, 0x89E3}, //16688 #CJK UNIFIED IDEOGRAPH
  {0xFAB1, 0x8A72}, //16689 #CJK UNIFIED IDEOGRAPH
  {0xFAB2, 0x8AE7}, //16690 #CJK UNIFIED IDEOGRAPH
  {0xFAB3, 0x9082}, //16691 #CJK UNIFIED IDEOGRAPH
  {0xFAB4, 0x99ED}, //16692 #CJK UNIFIED IDEOGRAPH
  {0xFAB5, 0x9AB8}, //16693 #CJK UNIFIED IDEOGRAPH
  {0xFAB6, 0x52BE}, //16694 #CJK UNIFIED IDEOGRAPH
  {0xFAB7, 0x6838}, //16695 #CJK UNIFIED IDEOGRAPH
  {0xFAB8, 0x5016}, //16696 #CJK UNIFIED IDEOGRAPH
  {0xFAB9, 0x5E78}, //16697 #CJK UNIFIED IDEOGRAPH
  {0xFABA, 0x674F}, //16698 #CJK UNIFIED IDEOGRAPH
  {0xFABB, 0x8347}, //16699 #CJK UNIFIED IDEOGRAPH
  {0xFABC, 0x884C}, //16700 #CJK UNIFIED IDEOGRAPH
  {0xFABD, 0x4EAB}, //16701 #CJK UNIFIED IDEOGRAPH
  {0xFABE, 0x5411}, //16702 #CJK UNIFIED IDEOGRAPH
  {0xFABF, 0x56AE}, //16703 #CJK UNIFIED IDEOGRAPH
  {0xFAC0, 0x73E6}, //16704 #CJK UNIFIED IDEOGRAPH
  {0xFAC1, 0x9115}, //16705 #CJK UNIFIED IDEOGRAPH
  {0xFAC2, 0x97FF}, //16706 #CJK UNIFIED IDEOGRAPH
  {0xFAC3, 0x9909}, //16707 #CJK UNIFIED IDEOGRAPH
  {0xFAC4, 0x9957}, //16708 #CJK UNIFIED IDEOGRAPH
  {0xFAC5, 0x9999}, //16709 #CJK UNIFIED IDEOGRAPH
  {0xFAC6, 0x5653}, //16710 #CJK UNIFIED IDEOGRAPH
  {0xFAC7, 0x589F}, //16711 #CJK UNIFIED IDEOGRAPH
  {0xFAC8, 0x865B}, //16712 #CJK UNIFIED IDEOGRAPH
  {0xFAC9, 0x8A31}, //16713 #CJK UNIFIED IDEOGRAPH
  {0xFACA, 0x61B2}, //16714 #CJK UNIFIED IDEOGRAPH
  {0xFACB, 0x6AF6}, //16715 #CJK UNIFIED IDEOGRAPH
  {0xFACC, 0x737B}, //16716 #CJK UNIFIED IDEOGRAPH
  {0xFACD, 0x8ED2}, //16717 #CJK UNIFIED IDEOGRAPH
  {0xFACE, 0x6B47}, //16718 #CJK UNIFIED IDEOGRAPH
  {0xFACF, 0x96AA}, //16719 #CJK UNIFIED IDEOGRAPH
  {0xFAD0, 0x9A57}, //16720 #CJK UNIFIED IDEOGRAPH
  {0xFAD1, 0x5955}, //16721 #CJK UNIFIED IDEOGRAPH
  {0xFAD2, 0x7200}, //16722 #CJK UNIFIED IDEOGRAPH
  {0xFAD3, 0x8D6B}, //16723 #CJK UNIFIED IDEOGRAPH
  {0xFAD4, 0x9769}, //16724 #CJK UNIFIED IDEOGRAPH
  {0xFAD5, 0x4FD4}, //16725 #CJK UNIFIED IDEOGRAPH
  {0xFAD6, 0x5CF4}, //16726 #CJK UNIFIED IDEOGRAPH
  {0xFAD7, 0x5F26}, //16727 #CJK UNIFIED IDEOGRAPH
  {0xFAD8, 0x61F8}, //16728 #CJK UNIFIED IDEOGRAPH
  {0xFAD9, 0x665B}, //16729 #CJK UNIFIED IDEOGRAPH
  {0xFADA, 0x6CEB}, //16730 #CJK UNIFIED IDEOGRAPH
  {0xFADB, 0x70AB}, //16731 #CJK UNIFIED IDEOGRAPH
  {0xFADC, 0x7384}, //16732 #CJK UNIFIED IDEOGRAPH
  {0xFADD, 0x73B9}, //16733 #CJK UNIFIED IDEOGRAPH
  {0xFADE, 0x73FE}, //16734 #CJK UNIFIED IDEOGRAPH
  {0xFADF, 0x7729}, //16735 #CJK UNIFIED IDEOGRAPH
  {0xFAE0, 0x774D}, //16736 #CJK UNIFIED IDEOGRAPH
  {0xFAE1, 0x7D43}, //16737 #CJK UNIFIED IDEOGRAPH
  {0xFAE2, 0x7D62}, //16738 #CJK UNIFIED IDEOGRAPH
  {0xFAE3, 0x7E23}, //16739 #CJK UNIFIED IDEOGRAPH
  {0xFAE4, 0x8237}, //16740 #CJK UNIFIED IDEOGRAPH
  {0xFAE5, 0x8852}, //16741 #CJK UNIFIED IDEOGRAPH
  {0xFAE6, 0xFA0A}, //16742 #CJK COMPATIBILITY IDEOGRAPH
  {0xFAE7, 0x8CE2}, //16743 #CJK UNIFIED IDEOGRAPH
  {0xFAE8, 0x9249}, //16744 #CJK UNIFIED IDEOGRAPH
  {0xFAE9, 0x986F}, //16745 #CJK UNIFIED IDEOGRAPH
  {0xFAEA, 0x5B51}, //16746 #CJK UNIFIED IDEOGRAPH
  {0xFAEB, 0x7A74}, //16747 #CJK UNIFIED IDEOGRAPH
  {0xFAEC, 0x8840}, //16748 #CJK UNIFIED IDEOGRAPH
  {0xFAED, 0x9801}, //16749 #CJK UNIFIED IDEOGRAPH
  {0xFAEE, 0x5ACC}, //16750 #CJK UNIFIED IDEOGRAPH
  {0xFAEF, 0x4FE0}, //16751 #CJK UNIFIED IDEOG