/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef QCHATTRAYICON_H
#define QCHATTRAYICON_H

#include <QSystemTrayIcon>
#include <QIcon>
#include <QMovie>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class QChatTrayIcon : public QSystemTrayIcon
{
  Q_OBJECT
  private:
    QMovie* m_movie;

  public:
    QChatTrayIcon(QIcon, QObject *parent = 0);
    ~QChatTrayIcon(){};

    void setStaticIcon(const QString & fname)  {m_movie->stop(); setIcon(QIcon(fname));}
    void setAnimatedIcon(const QString & fname){m_movie->setFileName(fname); m_movie->start();}

  private slots:
    void nextFrame(){setIcon(QIcon(m_movie->currentPixmap()));}
};

#endif
