/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITUSERINFODLG_H
#define EDITUSERINFODLG_H

#include <QWidget>
#include <QDialog>
#include <QLineEdit>
#include <QTextEdit>
#include <QLabel>
#include <QPixmap>
#include <QPainter>
#include <QLayout>
#include <QPicture>
#include <QFrame>
#include <QSpacerItem>
#include <QMatrix>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QDateEdit>
#include <QDate>
#include <QCloseEvent>
#include <QComboBox>

class PixLabel;
class UserInfo;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/

class EditUserInfoDlg : public QDialog
{
  Q_OBJECT
  private:
    QString      m_profileName;
    quint64      m_userUid;
    QGridLayout* m_grid;
    QLineEdit*   m_lastNameEdit;
    QLineEdit*   m_firstNameEdit;
    QLineEdit*   m_secondNameEdit;
    QLineEdit*   m_nickNameEdit;
    QLineEdit*   m_homePhoneEdit;
    QLineEdit*   m_workPhoneEdit;
    QLineEdit*   m_mobilePhoneEdit;
    QLineEdit*   m_e_mailEdit;
    QLineEdit*   m_homepageEdit;
    QLineEdit*   m_icqEdit;
    QDateEdit*   m_dateOfBornEdit;
    QLineEdit*   m_addressEdit;
    QTextEdit*   m_aboutInfoEdit;
    QPushButton* m_applyBtn;
    QPushButton* m_okBtn;
    QPushButton* m_cancelBtn;
    PixLabel*    m_setPhoto;
    PixLabel*    m_setPic;
    QComboBox*   m_genderCmbx;

    QLabel*      m_statusLab;
    QLineEdit*   mw_statusDescription;

    QString      m_photoFilename;
    QString      m_pictureFilename;
    bool         m_edited;
    bool         m_readOnly;

    QLabel*        m_applyLab;
    QLabel*        m_okLab;
    QLabel*        m_cancelLab;
    QLabel*        m_photoLab;
    QLabel*        m_pictureLab;
    QLabel*        m_nickLab;
    QLabel*        m_lastNameLab;
    QLabel*        m_firstNameLab;
    QLabel*        m_secondNameLab;
    QLabel*        m_bornLab;
    QLabel*        m_addressLab;
    QLabel*        m_homePhoneLab;
    QLabel*        m_workPhoneLab;
    QLabel*        m_mobilePhoneLab;
    QLabel*        m_emailLab;
    QLabel*        m_icqLab;
    QLabel*        m_homepageLab;
    QLabel*        m_aboutLab;
    QLabel*        m_genderLab;

  public:
    EditUserInfoDlg(QWidget *parent = 0);
    ~EditUserInfoDlg();

    void retranslate();

    void    setReadOnly(bool);
    bool    readOnly   () const {return m_readOnly;};
    quint64 userUid    () const {return m_userUid;}

    void toggleVisible(){if(isHidden()) show(); else hide();}

  public slots:
    void slot_sendInfo ();
    void slot_edited   () {m_applyBtn->setEnabled(m_edited = true);}
    void slot_notEdited() {m_applyBtn->setEnabled(m_edited = false);}
    void slot_cancel   ();
    void slot_loadInfo (const UserInfo*);
    void slot_accept   ();

  protected:
    void closeEvent(QCloseEvent * ev) { slot_cancel(); ev->accept(); }
    void changeEvent(QEvent *ev)
    {
      if(ev->type() == QEvent::LanguageChange)
        retranslate();
      else
        QDialog::changeEvent(ev);
    }

  signals:
    void infoChanged ();
    void nickNameChanged(const QString &);
    void wantChangeNickname(const QString &);

};

#endif
