#!/usr/bin/python

from utils                       import (typecheck_Entry, o2str)

class SourcePackagePublication(object):
    def __init__(self, lp_publication):
        self.lp_publication = typecheck_Entry(lp_publication)
        self.__pocket = None
        self.__upload_status = None
        self.__sponsor = None
        self.__signer = None

    @property
    def pocket(self):
        if self.__pocket is None:
            self.__pocket = o2str(self.lp_publication.pocket)
        return self.__pocket

    @property
    def upload_status(self):
        if self.__upload_status is None:
            upl = self.lp_publication.packageupload
            if upl is None:
                self.__upload_status = ''
            else:
                self.__upload_status = o2str(upl.status)
        return self.__upload_status

    def to_dict(self):
        def _get_name(obj):
            if obj is None:
                return ''
            return o2str(obj.name)

        return {
            'pocket':        self.pocket,
            'status':        o2str(self.lp_publication.status),
            'upload_status': self.upload_status,
            'section':       o2str(self.lp_publication.section_name),
            'component':     o2str(self.lp_publication.component_name),
            'version':       o2str(self.lp_publication.source_package_version),
            'published':     o2str(self.lp_publication.date_published),
            'series':        _get_name(self.lp_publication.distro_series),
            'publisher':     _get_name(self.lp_publication.creator),
            'creator':       _get_name(self.lp_publication.package_creator),
            'signer':        _get_name(self.lp_publication.package_signer),
            'sponsor':       _get_name(self.lp_publication.sponsor),
            }

# vi:set ts=4 sw=4 expandtab:
