# coding: utf-8

"""
    Kubernetes

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

    OpenAPI spec version: v1.6.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ExtensionsV1beta1Api(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_namespaced_daemon_set(self, namespace, body, **kwargs):
        """
        create a DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_daemon_set(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_daemon_set_with_http_info(namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_daemon_set_with_http_info(namespace, body, **kwargs)
            return data

    def create_namespaced_daemon_set_with_http_info(self, namespace, body, **kwargs):
        """
        create a DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_daemon_set_with_http_info(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_daemon_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_deployment(self, namespace, body, **kwargs):
        """
        create a Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_deployment_with_http_info(namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_deployment_with_http_info(namespace, body, **kwargs)
            return data

    def create_namespaced_deployment_with_http_info(self, namespace, body, **kwargs):
        """
        create a Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment_with_http_info(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_deployment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_deployment_rollback_rollback(self, name, namespace, body, **kwargs):
        """
        create rollback of a DeploymentRollback
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment_rollback_rollback(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DeploymentRollback (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1DeploymentRollback body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1DeploymentRollback
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_deployment_rollback_rollback_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_deployment_rollback_rollback_with_http_info(name, namespace, body, **kwargs)
            return data

    def create_namespaced_deployment_rollback_rollback_with_http_info(self, name, namespace, body, **kwargs):
        """
        create rollback of a DeploymentRollback
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_deployment_rollback_rollback_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DeploymentRollback (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1DeploymentRollback body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1DeploymentRollback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_deployment_rollback_rollback" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `create_namespaced_deployment_rollback_rollback`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_deployment_rollback_rollback`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_deployment_rollback_rollback`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/rollback'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1DeploymentRollback',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_ingress(self, namespace, body, **kwargs):
        """
        create an Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_ingress(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_ingress_with_http_info(namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_ingress_with_http_info(namespace, body, **kwargs)
            return data

    def create_namespaced_ingress_with_http_info(self, namespace, body, **kwargs):
        """
        create an Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_ingress_with_http_info(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_ingress`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_network_policy(self, namespace, body, **kwargs):
        """
        create a NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_network_policy(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1NetworkPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_network_policy_with_http_info(namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_network_policy_with_http_info(namespace, body, **kwargs)
            return data

    def create_namespaced_network_policy_with_http_info(self, namespace, body, **kwargs):
        """
        create a NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_network_policy_with_http_info(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1NetworkPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_network_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_namespaced_replica_set(self, namespace, body, **kwargs):
        """
        create a ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_replica_set(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_namespaced_replica_set_with_http_info(namespace, body, **kwargs)
        else:
            (data) = self.create_namespaced_replica_set_with_http_info(namespace, body, **kwargs)
            return data

    def create_namespaced_replica_set_with_http_info(self, namespace, body, **kwargs):
        """
        create a ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_replica_set_with_http_info(namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_replica_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_pod_security_policy(self, body, **kwargs):
        """
        create a PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_pod_security_policy(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1PodSecurityPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_pod_security_policy_with_http_info(body, **kwargs)
        else:
            (data) = self.create_pod_security_policy_with_http_info(body, **kwargs)
            return data

    def create_pod_security_policy_with_http_info(self, body, **kwargs):
        """
        create a PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_pod_security_policy_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1PodSecurityPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_pod_security_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1PodSecurityPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_third_party_resource(self, body, **kwargs):
        """
        create a ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_third_party_resource(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1ThirdPartyResource body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_third_party_resource_with_http_info(body, **kwargs)
        else:
            (data) = self.create_third_party_resource_with_http_info(body, **kwargs)
            return data

    def create_third_party_resource_with_http_info(self, body, **kwargs):
        """
        create a ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_third_party_resource_with_http_info(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1beta1ThirdPartyResource body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_third_party_resource`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ThirdPartyResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_namespaced_daemon_set(self, namespace, **kwargs):
        """
        delete collection of DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_daemon_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_namespaced_daemon_set_with_http_info(namespace, **kwargs)
        else:
            (data) = self.delete_collection_namespaced_daemon_set_with_http_info(namespace, **kwargs)
            return data

    def delete_collection_namespaced_daemon_set_with_http_info(self, namespace, **kwargs):
        """
        delete collection of DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_daemon_set_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_collection_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_namespaced_deployment(self, namespace, **kwargs):
        """
        delete collection of Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_deployment(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_namespaced_deployment_with_http_info(namespace, **kwargs)
        else:
            (data) = self.delete_collection_namespaced_deployment_with_http_info(namespace, **kwargs)
            return data

    def delete_collection_namespaced_deployment_with_http_info(self, namespace, **kwargs):
        """
        delete collection of Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_deployment_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_collection_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_namespaced_ingress(self, namespace, **kwargs):
        """
        delete collection of Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_ingress(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_namespaced_ingress_with_http_info(namespace, **kwargs)
        else:
            (data) = self.delete_collection_namespaced_ingress_with_http_info(namespace, **kwargs)
            return data

    def delete_collection_namespaced_ingress_with_http_info(self, namespace, **kwargs):
        """
        delete collection of Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_ingress_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_collection_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_namespaced_network_policy(self, namespace, **kwargs):
        """
        delete collection of NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_network_policy(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_namespaced_network_policy_with_http_info(namespace, **kwargs)
        else:
            (data) = self.delete_collection_namespaced_network_policy_with_http_info(namespace, **kwargs)
            return data

    def delete_collection_namespaced_network_policy_with_http_info(self, namespace, **kwargs):
        """
        delete collection of NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_network_policy_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_collection_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_namespaced_replica_set(self, namespace, **kwargs):
        """
        delete collection of ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_replica_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_namespaced_replica_set_with_http_info(namespace, **kwargs)
        else:
            (data) = self.delete_collection_namespaced_replica_set_with_http_info(namespace, **kwargs)
            return data

    def delete_collection_namespaced_replica_set_with_http_info(self, namespace, **kwargs):
        """
        delete collection of ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_namespaced_replica_set_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_collection_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_pod_security_policy(self, **kwargs):
        """
        delete collection of PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_pod_security_policy(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_pod_security_policy_with_http_info(**kwargs)
        else:
            (data) = self.delete_collection_pod_security_policy_with_http_info(**kwargs)
            return data

    def delete_collection_pod_security_policy_with_http_info(self, **kwargs):
        """
        delete collection of PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_pod_security_policy_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_collection_third_party_resource(self, **kwargs):
        """
        delete collection of ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_third_party_resource(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_collection_third_party_resource_with_http_info(**kwargs)
        else:
            (data) = self.delete_collection_third_party_resource_with_http_info(**kwargs)
            return data

    def delete_collection_third_party_resource_with_http_info(self, **kwargs):
        """
        delete collection of ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_collection_third_party_resource_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_collection_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_daemon_set(self, name, namespace, body, **kwargs):
        """
        delete a DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_daemon_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.delete_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def delete_namespaced_daemon_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        delete a DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_daemon_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_daemon_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_deployment(self, name, namespace, body, **kwargs):
        """
        delete a Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_deployment(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.delete_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
            return data

    def delete_namespaced_deployment_with_http_info(self, name, namespace, body, **kwargs):
        """
        delete a Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_deployment_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_deployment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_ingress(self, name, namespace, body, **kwargs):
        """
        delete an Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_ingress(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.delete_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
            return data

    def delete_namespaced_ingress_with_http_info(self, name, namespace, body, **kwargs):
        """
        delete an Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_ingress_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_ingress`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_network_policy(self, name, namespace, body, **kwargs):
        """
        delete a NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_network_policy(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.delete_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
            return data

    def delete_namespaced_network_policy_with_http_info(self, name, namespace, body, **kwargs):
        """
        delete a NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_network_policy_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_network_policy`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_network_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_namespaced_replica_set(self, name, namespace, body, **kwargs):
        """
        delete a ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_replica_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.delete_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def delete_namespaced_replica_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        delete a ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_replica_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_replica_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_pod_security_policy(self, name, body, **kwargs):
        """
        delete a PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_pod_security_policy(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_pod_security_policy_with_http_info(name, body, **kwargs)
        else:
            (data) = self.delete_pod_security_policy_with_http_info(name, body, **kwargs)
            return data

    def delete_pod_security_policy_with_http_info(self, name, body, **kwargs):
        """
        delete a PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_pod_security_policy_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_pod_security_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_pod_security_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_third_party_resource(self, name, body, **kwargs):
        """
        delete a ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_third_party_resource(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_third_party_resource_with_http_info(name, body, **kwargs)
        else:
            (data) = self.delete_third_party_resource_with_http_info(name, body, **kwargs)
            return data

    def delete_third_party_resource_with_http_info(self, name, body, **kwargs):
        """
        delete a ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_third_party_resource_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param V1DeleteOptions body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param int grace_period_seconds: The duration in seconds before the object should be deleted. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period for the specified type will be used. Defaults to a per object value if not specified. zero means delete immediately.
        :param bool orphan_dependents: Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7. Should the dependent objects be orphaned. If true/false, the \"orphan\" finalizer will be added to/removed from the object's finalizers list. Either this field or PropagationPolicy may be set, but not both.
        :param str propagation_policy: Whether and how garbage collection will be performed. Either this field or OrphanDependents may be set, but not both. The default policy is decided by the existing finalizer set in the metadata.finalizers and the resource-specific default policy.
        :return: V1Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty', 'grace_period_seconds', 'orphan_dependents', 'propagation_policy']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `delete_third_party_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `delete_third_party_resource`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'grace_period_seconds' in params:
            query_params['gracePeriodSeconds'] = params['grace_period_seconds']
        if 'orphan_dependents' in params:
            query_params['orphanDependents'] = params['orphan_dependents']
        if 'propagation_policy' in params:
            query_params['propagationPolicy'] = params['propagation_policy']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1Status',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_api_resources(self, **kwargs):
        """
        get available resources
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_resources(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: V1APIResourceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_api_resources_with_http_info(**kwargs)
        else:
            (data) = self.get_api_resources_with_http_info(**kwargs)
            return data

    def get_api_resources_with_http_info(self, **kwargs):
        """
        get available resources
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_resources_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: V1APIResourceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_resources" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1APIResourceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_daemon_set_for_all_namespaces(self, **kwargs):
        """
        list or watch objects of kind DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_daemon_set_for_all_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_daemon_set_for_all_namespaces_with_http_info(**kwargs)
        else:
            (data) = self.list_daemon_set_for_all_namespaces_with_http_info(**kwargs)
            return data

    def list_daemon_set_for_all_namespaces_with_http_info(self, **kwargs):
        """
        list or watch objects of kind DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_daemon_set_for_all_namespaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_selector', 'label_selector', 'pretty', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_daemon_set_for_all_namespaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/daemonsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSetList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_deployment_for_all_namespaces(self, **kwargs):
        """
        list or watch objects of kind Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_deployment_for_all_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: ExtensionsV1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_deployment_for_all_namespaces_with_http_info(**kwargs)
        else:
            (data) = self.list_deployment_for_all_namespaces_with_http_info(**kwargs)
            return data

    def list_deployment_for_all_namespaces_with_http_info(self, **kwargs):
        """
        list or watch objects of kind Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_deployment_for_all_namespaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: ExtensionsV1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_selector', 'label_selector', 'pretty', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_deployment_for_all_namespaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/deployments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1DeploymentList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_ingress_for_all_namespaces(self, **kwargs):
        """
        list or watch objects of kind Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_ingress_for_all_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_ingress_for_all_namespaces_with_http_info(**kwargs)
        else:
            (data) = self.list_ingress_for_all_namespaces_with_http_info(**kwargs)
            return data

    def list_ingress_for_all_namespaces_with_http_info(self, **kwargs):
        """
        list or watch objects of kind Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_ingress_for_all_namespaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_selector', 'label_selector', 'pretty', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_ingress_for_all_namespaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/ingresses'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1IngressList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_daemon_set(self, namespace, **kwargs):
        """
        list or watch objects of kind DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_daemon_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_namespaced_daemon_set_with_http_info(namespace, **kwargs)
        else:
            (data) = self.list_namespaced_daemon_set_with_http_info(namespace, **kwargs)
            return data

    def list_namespaced_daemon_set_with_http_info(self, namespace, **kwargs):
        """
        list or watch objects of kind DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_daemon_set_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1DaemonSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSetList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_deployment(self, namespace, **kwargs):
        """
        list or watch objects of kind Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_deployment(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: ExtensionsV1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_namespaced_deployment_with_http_info(namespace, **kwargs)
        else:
            (data) = self.list_namespaced_deployment_with_http_info(namespace, **kwargs)
            return data

    def list_namespaced_deployment_with_http_info(self, namespace, **kwargs):
        """
        list or watch objects of kind Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_deployment_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: ExtensionsV1beta1DeploymentList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1DeploymentList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_ingress(self, namespace, **kwargs):
        """
        list or watch objects of kind Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_ingress(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_namespaced_ingress_with_http_info(namespace, **kwargs)
        else:
            (data) = self.list_namespaced_ingress_with_http_info(namespace, **kwargs)
            return data

    def list_namespaced_ingress_with_http_info(self, namespace, **kwargs):
        """
        list or watch objects of kind Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_ingress_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1IngressList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1IngressList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_network_policy(self, namespace, **kwargs):
        """
        list or watch objects of kind NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_network_policy(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1NetworkPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_namespaced_network_policy_with_http_info(namespace, **kwargs)
        else:
            (data) = self.list_namespaced_network_policy_with_http_info(namespace, **kwargs)
            return data

    def list_namespaced_network_policy_with_http_info(self, namespace, **kwargs):
        """
        list or watch objects of kind NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_network_policy_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1NetworkPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicyList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_namespaced_replica_set(self, namespace, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_replica_set(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_namespaced_replica_set_with_http_info(namespace, **kwargs)
        else:
            (data) = self.list_namespaced_replica_set_with_http_info(namespace, **kwargs)
            return data

    def list_namespaced_replica_set_with_http_info(self, namespace, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_replica_set_with_http_info(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace', 'pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets'.replace('{format}', 'json')
        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSetList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_network_policy_for_all_namespaces(self, **kwargs):
        """
        list or watch objects of kind NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_network_policy_for_all_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1NetworkPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_network_policy_for_all_namespaces_with_http_info(**kwargs)
        else:
            (data) = self.list_network_policy_for_all_namespaces_with_http_info(**kwargs)
            return data

    def list_network_policy_for_all_namespaces_with_http_info(self, **kwargs):
        """
        list or watch objects of kind NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_network_policy_for_all_namespaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1NetworkPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_selector', 'label_selector', 'pretty', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_network_policy_for_all_namespaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/networkpolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicyList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_pod_security_policy(self, **kwargs):
        """
        list or watch objects of kind PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pod_security_policy(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1PodSecurityPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_pod_security_policy_with_http_info(**kwargs)
        else:
            (data) = self.list_pod_security_policy_with_http_info(**kwargs)
            return data

    def list_pod_security_policy_with_http_info(self, **kwargs):
        """
        list or watch objects of kind PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pod_security_policy_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1PodSecurityPolicyList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1PodSecurityPolicyList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_replica_set_for_all_namespaces(self, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_replica_set_for_all_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_replica_set_for_all_namespaces_with_http_info(**kwargs)
        else:
            (data) = self.list_replica_set_for_all_namespaces_with_http_info(**kwargs)
            return data

    def list_replica_set_for_all_namespaces_with_http_info(self, **kwargs):
        """
        list or watch objects of kind ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_replica_set_for_all_namespaces_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str pretty: If 'true', then the output is pretty printed.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ReplicaSetList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['field_selector', 'label_selector', 'pretty', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_replica_set_for_all_namespaces" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/replicasets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSetList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_third_party_resource(self, **kwargs):
        """
        list or watch objects of kind ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_third_party_resource(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ThirdPartyResourceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_third_party_resource_with_http_info(**kwargs)
        else:
            (data) = self.list_third_party_resource_with_http_info(**kwargs)
            return data

    def list_third_party_resource_with_http_info(self, **kwargs):
        """
        list or watch objects of kind ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_third_party_resource_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history. When specified for list: - if unset, then the result is returned from remote storage based on quorum-read flag; - if it's 0, then we simply return what we currently have in cache, no guarantee; - if set to non zero, then the result is at least as fresh as given rv.
        :param int timeout_seconds: Timeout for the list/watch call.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :return: V1beta1ThirdPartyResourceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'field_selector', 'label_selector', 'resource_version', 'timeout_seconds', 'watch']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']
        if 'watch' in params:
            query_params['watch'] = params['watch']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf', 'application/json;stream=watch', 'application/vnd.kubernetes.protobuf;stream=watch'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ThirdPartyResourceList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_daemon_set(self, name, namespace, body, **kwargs):
        """
        partially update the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_daemon_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_daemon_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_daemon_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_daemon_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_daemon_set_status(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_daemon_set_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_daemon_set_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_daemon_set_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_daemon_set_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_daemon_set_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_daemon_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_daemon_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_daemon_set_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_daemon_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_deployment(self, name, namespace, body, **kwargs):
        """
        partially update the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployment(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_deployment_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployment_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_deployment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_deployment_status(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployment_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_deployment_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_deployment_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_deployment_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployment_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_deployment_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_deployment_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_deployment_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_deployment_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_deployments_scale(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployments_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_deployments_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_deployments_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_deployments_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_deployments_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_deployments_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_deployments_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_deployments_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_deployments_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_ingress(self, name, namespace, body, **kwargs):
        """
        partially update the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_ingress(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_ingress_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_ingress_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_ingress`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_ingress_status(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_ingress_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_ingress_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_ingress_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_ingress_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_ingress_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_ingress_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_ingress_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_ingress_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_ingress_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_network_policy(self, name, namespace, body, **kwargs):
        """
        partially update the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_network_policy(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_network_policy_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_network_policy_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_network_policy`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_network_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_replica_set(self, name, namespace, body, **kwargs):
        """
        partially update the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replica_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_replica_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replica_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replica_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_replica_set_status(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replica_set_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_replica_set_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_replica_set_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_replica_set_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replica_set_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replica_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replica_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replica_set_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replica_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_replicasets_scale(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replicasets_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_replicasets_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_replicasets_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_replicasets_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replicasets_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replicasets_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replicasets_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replicasets_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replicasets_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_namespaced_replicationcontrollers_scale(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replicationcontrollers_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.patch_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def patch_namespaced_replicationcontrollers_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        partially update scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replicationcontrollers_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replicationcontrollers_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replicationcontrollers_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replicationcontrollers_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_pod_security_policy(self, name, body, **kwargs):
        """
        partially update the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_pod_security_policy(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_pod_security_policy_with_http_info(name, body, **kwargs)
        else:
            (data) = self.patch_pod_security_policy_with_http_info(name, body, **kwargs)
            return data

    def patch_pod_security_policy_with_http_info(self, name, body, **kwargs):
        """
        partially update the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_pod_security_policy_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_pod_security_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_pod_security_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1PodSecurityPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def patch_third_party_resource(self, name, body, **kwargs):
        """
        partially update the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_third_party_resource(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.patch_third_party_resource_with_http_info(name, body, **kwargs)
        else:
            (data) = self.patch_third_party_resource_with_http_info(name, body, **kwargs)
            return data

    def patch_third_party_resource_with_http_info(self, name, body, **kwargs):
        """
        partially update the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_third_party_resource_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param object body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `patch_third_party_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_third_party_resource`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ThirdPartyResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_daemon_set(self, name, namespace, **kwargs):
        """
        read the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_daemon_set(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_daemon_set_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_daemon_set_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_daemon_set_with_http_info(self, name, namespace, **kwargs):
        """
        read the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_daemon_set_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_daemon_set_status(self, name, namespace, **kwargs):
        """
        read status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_daemon_set_status(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_daemon_set_status_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_daemon_set_status_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_daemon_set_status_with_http_info(self, name, namespace, **kwargs):
        """
        read status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_daemon_set_status_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_daemon_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_daemon_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_daemon_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_deployment(self, name, namespace, **kwargs):
        """
        read the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployment(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_deployment_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_deployment_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_deployment_with_http_info(self, name, namespace, **kwargs):
        """
        read the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployment_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_deployment_status(self, name, namespace, **kwargs):
        """
        read status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployment_status(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_deployment_status_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_deployment_status_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_deployment_status_with_http_info(self, name, namespace, **kwargs):
        """
        read status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployment_status_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_deployment_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_deployment_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_deployment_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_deployments_scale(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployments_scale(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_deployments_scale_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_deployments_scale_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_deployments_scale_with_http_info(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_deployments_scale_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_deployments_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_deployments_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_deployments_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_ingress(self, name, namespace, **kwargs):
        """
        read the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_ingress(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_ingress_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_ingress_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_ingress_with_http_info(self, name, namespace, **kwargs):
        """
        read the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_ingress_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_ingress_status(self, name, namespace, **kwargs):
        """
        read status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_ingress_status(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_ingress_status_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_ingress_status_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_ingress_status_with_http_info(self, name, namespace, **kwargs):
        """
        read status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_ingress_status_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_ingress_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_ingress_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_ingress_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_network_policy(self, name, namespace, **kwargs):
        """
        read the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_network_policy(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_network_policy_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_network_policy_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_network_policy_with_http_info(self, name, namespace, **kwargs):
        """
        read the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_network_policy_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_network_policy`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_replica_set(self, name, namespace, **kwargs):
        """
        read the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replica_set(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_replica_set_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_replica_set_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_replica_set_with_http_info(self, name, namespace, **kwargs):
        """
        read the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replica_set_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_replica_set_status(self, name, namespace, **kwargs):
        """
        read status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replica_set_status(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_replica_set_status_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_replica_set_status_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_replica_set_status_with_http_info(self, name, namespace, **kwargs):
        """
        read status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replica_set_status_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replica_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replica_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replica_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_replicasets_scale(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replicasets_scale(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_replicasets_scale_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_replicasets_scale_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_replicasets_scale_with_http_info(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replicasets_scale_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replicasets_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replicasets_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replicasets_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_namespaced_replicationcontrollers_scale(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replicationcontrollers_scale(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, **kwargs)
        else:
            (data) = self.read_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, **kwargs)
            return data

    def read_namespaced_replicationcontrollers_scale_with_http_info(self, name, namespace, **kwargs):
        """
        read scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replicationcontrollers_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replicationcontrollers_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replicationcontrollers_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_pod_security_policy(self, name, **kwargs):
        """
        read the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_pod_security_policy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_pod_security_policy_with_http_info(name, **kwargs)
        else:
            (data) = self.read_pod_security_policy_with_http_info(name, **kwargs)
            return data

    def read_pod_security_policy_with_http_info(self, name, **kwargs):
        """
        read the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_pod_security_policy_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_pod_security_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1PodSecurityPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def read_third_party_resource(self, name, **kwargs):
        """
        read the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_third_party_resource(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.read_third_party_resource_with_http_info(name, **kwargs)
        else:
            (data) = self.read_third_party_resource_with_http_info(name, **kwargs)
            return data

    def read_third_party_resource_with_http_info(self, name, **kwargs):
        """
        read the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_third_party_resource_with_http_info(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'pretty', 'exact', 'export']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `read_third_party_resource`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'exact' in params:
            query_params['exact'] = params['exact']
        if 'export' in params:
            query_params['export'] = params['export']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ThirdPartyResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_daemon_set(self, name, namespace, body, **kwargs):
        """
        replace the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_daemon_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_daemon_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_daemon_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_daemon_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_daemon_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_daemon_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_daemon_set_status(self, name, namespace, body, **kwargs):
        """
        replace status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_daemon_set_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_daemon_set_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_daemon_set_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace status of the specified DaemonSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_daemon_set_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the DaemonSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1DaemonSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1DaemonSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_daemon_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_daemon_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_daemon_set_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_daemon_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/daemonsets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1DaemonSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_deployment(self, name, namespace, body, **kwargs):
        """
        replace the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_deployment_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_deployment_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_deployment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_deployment`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_deployment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_deployment`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_deployment_status(self, name, namespace, body, **kwargs):
        """
        replace status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_deployment_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_deployment_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_deployment_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace status of the specified Deployment
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployment_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Deployment (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Deployment body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Deployment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_deployment_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_deployment_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_deployment_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_deployment_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Deployment',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_deployments_scale(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployments_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_deployments_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_deployments_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_deployments_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_deployments_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_deployments_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_deployments_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_deployments_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_deployments_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/deployments/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_ingress(self, name, namespace, body, **kwargs):
        """
        replace the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_ingress_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_ingress_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_ingress" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_ingress`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_ingress`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_ingress`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_ingress_status(self, name, namespace, body, **kwargs):
        """
        replace status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_ingress_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_ingress_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_ingress_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace status of the specified Ingress
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_ingress_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Ingress (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1Ingress body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1Ingress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_ingress_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_ingress_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_ingress_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_ingress_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/ingresses/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1Ingress',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_network_policy(self, name, namespace, body, **kwargs):
        """
        replace the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_network_policy(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1NetworkPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_network_policy_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_network_policy_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace the specified NetworkPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_network_policy_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the NetworkPolicy (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1NetworkPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1NetworkPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_network_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_network_policy`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_network_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_network_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/networkpolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1NetworkPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_replica_set(self, name, namespace, body, **kwargs):
        """
        replace the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_replica_set_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_replica_set_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replica_set" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replica_set`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replica_set`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replica_set`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_replica_set_status(self, name, namespace, body, **kwargs):
        """
        replace status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set_status(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_replica_set_status_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_replica_set_status_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_replica_set_status_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace status of the specified ReplicaSet
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replica_set_status_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ReplicaSet (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param V1beta1ReplicaSet body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ReplicaSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replica_set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replica_set_status`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replica_set_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replica_set_status`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/status'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ReplicaSet',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_replicasets_scale(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replicasets_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_replicasets_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_replicasets_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_replicasets_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replicasets_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replicasets_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replicasets_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replicasets_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replicasets_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicasets/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_namespaced_replicationcontrollers_scale(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replicationcontrollers_scale(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, **kwargs)
        else:
            (data) = self.replace_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, **kwargs)
            return data

    def replace_namespaced_replicationcontrollers_scale_with_http_info(self, name, namespace, body, **kwargs):
        """
        replace scale of the specified Scale
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replicationcontrollers_scale_with_http_info(name, namespace, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Scale (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param ExtensionsV1beta1Scale body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: ExtensionsV1beta1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'namespace', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replicationcontrollers_scale" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replicationcontrollers_scale`")
        # verify the required parameter 'namespace' is set
        if ('namespace' not in params) or (params['namespace'] is None):
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replicationcontrollers_scale`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replicationcontrollers_scale`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExtensionsV1beta1Scale',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_pod_security_policy(self, name, body, **kwargs):
        """
        replace the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_pod_security_policy(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param V1beta1PodSecurityPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_pod_security_policy_with_http_info(name, body, **kwargs)
        else:
            (data) = self.replace_pod_security_policy_with_http_info(name, body, **kwargs)
            return data

    def replace_pod_security_policy_with_http_info(self, name, body, **kwargs):
        """
        replace the specified PodSecurityPolicy
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_pod_security_policy_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PodSecurityPolicy (required)
        :param V1beta1PodSecurityPolicy body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1PodSecurityPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_pod_security_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_pod_security_policy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_pod_security_policy`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/podsecuritypolicies/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1PodSecurityPolicy',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def replace_third_party_resource(self, name, body, **kwargs):
        """
        replace the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_third_party_resource(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param V1beta1ThirdPartyResource body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.replace_third_party_resource_with_http_info(name, body, **kwargs)
        else:
            (data) = self.replace_third_party_resource_with_http_info(name, body, **kwargs)
            return data

    def replace_third_party_resource_with_http_info(self, name, body, **kwargs):
        """
        replace the specified ThirdPartyResource
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_third_party_resource_with_http_info(name, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ThirdPartyResource (required)
        :param V1beta1ThirdPartyResource body: (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1beta1ThirdPartyResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'body', 'pretty']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_third_party_resource" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `replace_third_party_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `replace_third_party_resource`")


        collection_formats = {}

        resource_path = '/apis/extensions/v1beta1/thirdpartyresources/{name}'.replace('{format}', 'json')
        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml', 'application/vnd.kubernetes.protobuf'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = ['BearerToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='V1beta1ThirdPartyResource',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
