# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementArchiveVersionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_archive_versions_list(self, resource_group):
        response = self.client.archive_versions.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            package_type="str",
            archive_name="str",
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_archive_versions_get(self, resource_group):
        response = self.client.archive_versions.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            package_type="str",
            archive_name="str",
            archive_version_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_archive_versions_begin_create(self, resource_group):
        response = self.client.archive_versions.begin_create(
            resource_group_name=resource_group.name,
            registry_name="str",
            package_type="str",
            archive_name="str",
            archive_version_name="str",
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_archive_versions_begin_delete(self, resource_group):
        response = self.client.archive_versions.begin_delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            package_type="str",
            archive_name="str",
            archive_version_name="str",
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
