# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AuthorizationProfile(_serialization.Model):
    """Authorization Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar requested_time: The requested time.
    :vartype requested_time: ~datetime.datetime
    :ivar requester: The requester.
    :vartype requester: str
    :ivar requester_object_id: The requester object id.
    :vartype requester_object_id: str
    :ivar approved_time: The approved time.
    :vartype approved_time: ~datetime.datetime
    :ivar approver: The approver.
    :vartype approver: str
    """

    _validation = {
        "requested_time": {"readonly": True},
        "requester": {"readonly": True},
        "requester_object_id": {"readonly": True},
        "approved_time": {"readonly": True},
        "approver": {"readonly": True},
    }

    _attribute_map = {
        "requested_time": {"key": "requestedTime", "type": "iso-8601"},
        "requester": {"key": "requester", "type": "str"},
        "requester_object_id": {"key": "requesterObjectId", "type": "str"},
        "approved_time": {"key": "approvedTime", "type": "iso-8601"},
        "approver": {"key": "approver", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.requested_time = None
        self.requester = None
        self.requester_object_id = None
        self.approved_time = None
        self.approver = None


class ErrorDefinition(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.resource.features.v2021_07_01.models.ErrorDefinition]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDefinition]"},
    }

    def __init__(self, *, details: Optional[List["_models.ErrorDefinition"]] = None, **kwargs: Any) -> None:
        """
        :keyword details: Internal error details.
        :paramtype details: list[~azure.mgmt.resource.features.v2021_07_01.models.ErrorDefinition]
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = details


class ErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request.

    :ivar error: The error details.
    :vartype error: ~azure.mgmt.resource.features.v2021_07_01.models.ErrorDefinition
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDefinition"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDefinition"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error details.
        :paramtype error: ~azure.mgmt.resource.features.v2021_07_01.models.ErrorDefinition
        """
        super().__init__(**kwargs)
        self.error = error


class FeatureOperationsListResult(_serialization.Model):
    """List of previewed features.

    :ivar value: The array of features.
    :vartype value: list[~azure.mgmt.resource.features.v2021_07_01.models.FeatureResult]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[FeatureResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.FeatureResult"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The array of features.
        :paramtype value: list[~azure.mgmt.resource.features.v2021_07_01.models.FeatureResult]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FeatureProperties(_serialization.Model):
    """Information about feature.

    :ivar state: The registration state of the feature for the subscription.
    :vartype state: str
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword state: The registration state of the feature for the subscription.
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.state = state


class FeatureResult(_serialization.Model):
    """Previewed feature information.

    :ivar name: The name of the feature.
    :vartype name: str
    :ivar properties: Properties of the previewed feature.
    :vartype properties: ~azure.mgmt.resource.features.v2021_07_01.models.FeatureProperties
    :ivar id: The resource ID of the feature.
    :vartype id: str
    :ivar type: The resource type of the feature.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "FeatureProperties"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.FeatureProperties"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the feature.
        :paramtype name: str
        :keyword properties: Properties of the previewed feature.
        :paramtype properties: ~azure.mgmt.resource.features.v2021_07_01.models.FeatureProperties
        :keyword id: The resource ID of the feature.
        :paramtype id: str
        :keyword type: The resource type of the feature.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.id = id
        self.type = type


class Operation(_serialization.Model):
    """Microsoft.Features operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.features.v2021_07_01.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.resource.features.v2021_07_01.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Features.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Features.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Features operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Features operations.
    :vartype value: list[~azure.mgmt.resource.features.v2021_07_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Microsoft.Features operations.
        :paramtype value: list[~azure.mgmt.resource.features.v2021_07_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProxyResource(_serialization.Model):
    """An Azure proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class SubscriptionFeatureRegistration(ProxyResource):
    """Subscription feature registration details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar properties:
    :vartype properties:
     ~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistrationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "SubscriptionFeatureRegistrationProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.SubscriptionFeatureRegistrationProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties:
        :paramtype properties:
         ~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistrationProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class SubscriptionFeatureRegistrationList(_serialization.Model):
    """The list of subscription feature registrations.

    :ivar next_link: The link used to get the next page of subscription feature registrations list.
    :vartype next_link: str
    :ivar value: The list of subscription feature registrations.
    :vartype value:
     list[~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistration]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SubscriptionFeatureRegistration]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.SubscriptionFeatureRegistration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The link used to get the next page of subscription feature registrations
         list.
        :paramtype next_link: str
        :keyword value: The list of subscription feature registrations.
        :paramtype value:
         list[~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistration]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SubscriptionFeatureRegistrationProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """SubscriptionFeatureRegistrationProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: The tenantId.
    :vartype tenant_id: str
    :ivar subscription_id: The subscriptionId.
    :vartype subscription_id: str
    :ivar feature_name: The featureName.
    :vartype feature_name: str
    :ivar display_name: The featureDisplayName.
    :vartype display_name: str
    :ivar provider_namespace: The providerNamespace.
    :vartype provider_namespace: str
    :ivar state: The state. Known values are: "NotSpecified", "NotRegistered", "Pending",
     "Registering", "Registered", "Unregistering", and "Unregistered".
    :vartype state: str or
     ~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistrationState
    :ivar authorization_profile: Authorization Profile.
    :vartype authorization_profile:
     ~azure.mgmt.resource.features.v2021_07_01.models.AuthorizationProfile
    :ivar metadata: Key-value pairs for meta data.
    :vartype metadata: dict[str, str]
    :ivar release_date: The feature release date.
    :vartype release_date: ~datetime.datetime
    :ivar registration_date: The feature registration date.
    :vartype registration_date: ~datetime.datetime
    :ivar documentation_link: The feature documentation link.
    :vartype documentation_link: str
    :ivar approval_type: The feature approval type. Known values are: "NotSpecified",
     "ApprovalRequired", and "AutoApproval".
    :vartype approval_type: str or
     ~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistrationApprovalType
    :ivar should_feature_display_in_portal: Indicates whether feature should be displayed in
     Portal.
    :vartype should_feature_display_in_portal: bool
    :ivar description: The feature description.
    :vartype description: str
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "subscription_id": {"readonly": True},
        "feature_name": {"readonly": True},
        "display_name": {"readonly": True},
        "provider_namespace": {"readonly": True},
        "release_date": {"readonly": True},
        "registration_date": {"readonly": True},
        "documentation_link": {"readonly": True, "max_length": 1000},
        "approval_type": {"readonly": True},
        "description": {"max_length": 1000},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "feature_name": {"key": "featureName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "provider_namespace": {"key": "providerNamespace", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "authorization_profile": {"key": "authorizationProfile", "type": "AuthorizationProfile"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "release_date": {"key": "releaseDate", "type": "iso-8601"},
        "registration_date": {"key": "registrationDate", "type": "iso-8601"},
        "documentation_link": {"key": "documentationLink", "type": "str"},
        "approval_type": {"key": "approvalType", "type": "str"},
        "should_feature_display_in_portal": {"key": "shouldFeatureDisplayInPortal", "type": "bool"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SubscriptionFeatureRegistrationState"]] = None,
        authorization_profile: Optional["_models.AuthorizationProfile"] = None,
        metadata: Optional[Dict[str, str]] = None,
        should_feature_display_in_portal: bool = False,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: The state. Known values are: "NotSpecified", "NotRegistered", "Pending",
         "Registering", "Registered", "Unregistering", and "Unregistered".
        :paramtype state: str or
         ~azure.mgmt.resource.features.v2021_07_01.models.SubscriptionFeatureRegistrationState
        :keyword authorization_profile: Authorization Profile.
        :paramtype authorization_profile:
         ~azure.mgmt.resource.features.v2021_07_01.models.AuthorizationProfile
        :keyword metadata: Key-value pairs for meta data.
        :paramtype metadata: dict[str, str]
        :keyword should_feature_display_in_portal: Indicates whether feature should be displayed in
         Portal.
        :paramtype should_feature_display_in_portal: bool
        :keyword description: The feature description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.tenant_id = None
        self.subscription_id = None
        self.feature_name = None
        self.display_name = None
        self.provider_namespace = None
        self.state = state
        self.authorization_profile = authorization_profile
        self.metadata = metadata
        self.release_date = None
        self.registration_date = None
        self.documentation_link = None
        self.approval_type = None
        self.should_feature_display_in_portal = should_feature_display_in_portal
        self.description = description
