# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     ./generate_unicodedb.py --unidata_version=9.0.0 --output=unicodedb_9_0_0 --base=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '9.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError, name

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x0c ALTERNATING'
'\x05 AND '
'\n AND ARROW'
'\x0f AND COLD SWEAT'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\x0b AND WRENCH'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x12 BRIGHTNESS SYMBOL'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\n CHARACTER'
'\x06 CHART'
'\x05 CHWV'
'\x07 CIRCLE'
'\n CONJOINED'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\x07 ENGINE'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x06 FINAL'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x05 GUNU'
'\t HITTING '
'\x05 HOOK'
'\x08 HUNDRED'
'\x05 ICON'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x04 KEY'
'\x02 L'
'\x06 LARGE'
'\t LEERAEWA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x08 MAKSURA'
'\x05 MARK'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\x0b OF HYGIEIA'
'\r OF THE HORNS'
'\x05 OPEN'
'\x07 OPEN-O'
'\x04 ORE'
'\x04 OUT'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x11 OVER MUSH TIMES '
'\x16 OVER STAMPED ENVELOPE'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x06 PLUS '
'\x0c PLUS KASKAL'
'\x12 PLUS PAP PLUS LU3'
'\x07 PLUS U'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x0f REVERSED-SCHWA'
'\x0c RING LITTLE'
'\x02 S'
'\x08 SATCHEL'
'\x07 SECANT'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x05 TABS'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES KUR'
'\x0b TIMES TAK4'
'\x07 TO BAR'
'\x05 TONE'
'\x0f TOUCHING INDEX'
'\x05 TREE'
'\x02 U'
'\x04 U U'
'\x04 WEB'
'\x06 WITH '
'\t WITH BAR'
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x12 WITH CROSSED-TAIL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x0b WITH FLASH'
'\x0e WITH FLOURISH'
'\x17 WITH HALF-CIRCLE BELOW'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\n WITH RING'
'\x12 WITH SMILING EYES'
'\x11 WITH SOUND WAVES'
'\x0c WITH STROKE'
'\x12 WITH VERTICAL BAR'
'\x0b WITHIN DOT'
'\x0b WRIST FLEX'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\x02-A'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x08-HEADED '
'\t-LOW TONE'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x0f-NO-EVIL MONKEY'
'\x0b-OFF SYMBOL'
'\n-POINTING '
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x06-SHIRT'
'\x07-THIRTY'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x050 DOO'
'\x030 E'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\t0 LONG LE'
'\x060 NGGI'
'\x060 NGGO'
'\x060 NYON'
'\x060 NYUN'
'\x040 PU'
'\x040 SA'
'\x030 W'
'\x040 YE'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0208'
'\x011'
'\x031 A'
'\x041 BA'
'\x041 DO'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x041 HA'
'\x041 IN'
'\x041 KI'
'\n1 LONG MBE'
'\x061 NDEE'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 RA'
'\x041 SU'
'\x051 TEE'
'\x041 VU'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-2'
'\x051-VAS'
'\x0217'
'\x0218'
'\x012'
'\x022 '
'\x032 B'
'\x042 BU'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x052 POO'
'\x052 SEE'
'\x042 TI'
'\x082 TIMES '
'\t2 TIMES A'
'\x102 TIMES IGI GUNU'
'\n2 TIMES UD'
'\x042 VI'
'\x032 Y'
'\x042 YA'
'\x052-VAS'
'\x0320B'
'\x0222'
'\x0224'
'\x0726 EYYY'
'\x03272'
'\x013'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 TA'
'\n3 TIMES ZA'
'\x053 VEE'
'\x053 WEI'
'\x043 YU'
'\x053-VAS'
'\x0230'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0236'
'\x0238'
'\x014'
'\x034 A'
'\x054 ABB'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x054-VAS'
'\x03408'
'\x0242'
'\x0248'
'\x0249'
'\x015'
'\x045 AN'
'\x045 BB'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x055 NDU'
'\x075 NGGEE'
'\x045 OO'
'\x045 TE'
'\x175 TIMES THREE DISH TENU'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WO'
'\x055-VAS'
'\x03533'
'\x03550'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 WEE'
'\x046 WU'
'\x056-VAS'
'\x0262'
'\x0264'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x057 JEE'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 VO'
'\x057-VAS'
'\x0270'
'\x0271'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x048 BO'
'\x048 DU'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x048 JI'
'\x038 K'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x019'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 SI'
'\x049 SO'
'\x049 TO'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x04914D'
'\x0292'
'\x03981'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A MFON'
'\x0bA TENU GUNU'
'\x05A YUE'
'\x02A4'
'\x07A6 TENU'
'\x02A7'
'\x03A7A'
'\x02AA'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\x03ABA'
'\nABATA TREE'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x05ABOVE'
'\x1eAC SUBLINEAR COLON SKEWED LEFT'
'\rACCOMMODATION'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x04ADA '
'\x02AE'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\x15AF FLUTTERING IN WIND'
'\x0eAFETY SCISSORS'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x03AG '
'\x04AGE '
'\x05AGGER'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\x02AH'
'\x16AH WITH TWO DOTS ABOVE'
'\x05AHMI '
'\x02AI'
'\x03AIN'
'\x04AIN '
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x02AJ'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x0cAK4 PLUS SAG'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x08AKHA YAT'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x05ALEPH'
'\x05ALETH'
'\x04ALF '
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x04ALL '
'\x05ALLOT'
'\x03ALO'
'\x05ALPHA'
'\x08ALTERNAT'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x06ALTIRE'
'\x02AM'
'\x12AM WITH DOUBLE BAR'
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x03AMI'
'\x04AMMA'
'\rAMMA WITH DOT'
'\x06AMOND '
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\x04AN X'
'\x03ANA'
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x12AND LOW RIGHT RING'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\nANDHI MARK'
'\nANDRABINDU'
'\x03ANG'
'\tANGE BOOK'
'\x05ANGEL'
'\x0cANGER BUBBLE'
'\tANGGEUAET'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x04ANJI'
'\x0fANS-SERIF ARROW'
'\x19ANTED NORTH ARROW WITH HO'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APH'
'\x14APITAL H WITH STROKE'
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x0bAR A SIGN A'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDSMAN'
'\x03ARE'
'\nARFUL FACE'
'\x03ARK'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\rARRED TRIDENT'
'\x08ARRIVING'
'\x05ARROW'
'\x12ARROW SHAFT WIDTH '
'\x0bARROW WITH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x05ARTAR'
'\x04ARUM'
'\x04ARY '
'\x02AS'
'\x05ASAL '
'\x17ASCENDING MUSICAL NOTES'
'\x03ASH'
'\x16ASH AMPERSAND ORNAMENT'
'\x05ASKAL'
'\nASPIRATION'
'\x0bASS OF MILK'
'\x12ASTED SWEET POTATO'
'\x02AT'
'\nAT ON BONE'
'\x07AT SIGN'
'\x03ATA'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\x03ATI'
'\x05ATIN '
'\nATIN CROSS'
'\x12ATIN SMALL LETTER '
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x03AUJ'
'\x03AUM'
'\x03AUS'
'\nAUTOMOBILE'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x05AWAY '
'\x02AY'
'\x08AY-NIGHT'
'\x03AYD'
'\nAYER BEADS'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\x0bB TIMES SHE'
'\x02BA'
'\x19BA ROTATED NINETY DEGREES'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x06BAHAR2'
'\x03BAL'
'\x04BALL'
'\rBALLPOINT PEN'
'\x03BAR'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\rBASAN LETTER '
'\x08BATAEAN '
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x03BEL'
'\x05BELOW'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x08BER POLE'
'\x07BERGINE'
'\x03BET'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x07BINING '
'\x0bBIRGA WITH '
'\x06BISCUS'
'\tBITE LIPS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x06BLACK '
'\x0cBLACK CIRCLE'
'\x19BLACK CIRCLED WHITE ARROW'
'\nBLACK FLAG'
'\rBLACK OCTAGON'
'\x0eBLACK PENTAGON'
'\nBLACK STAR'
'\x04BLE '
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\nBLOND HAIR'
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x11BOLD WHITE CIRCLE'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x15BOTTOM U-SHAPED ARROW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x0cBRATION MODE'
'\x19BREVE WITH INVERTED BREVE'
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x03BSP'
'\x02BU'
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C CLEF'
'\x06C SIGN'
'\x02CA'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x0cCANDRA ABOVE'
'\x0bCANDRABINDU'
'\x04CANO'
'\x07CAP TEN'
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x12CAPITAL LETTER YOT'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x0eCERTAINTY SIGN'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x14CHARACTER INTRODUCER'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHILLU '
'\x05CHIME'
'\x0bCHING CHICK'
'\x03CHO'
'\x05CHOOI'
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\x03CHU'
'\x04CIM '
'\x05CING '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\x1dCIRCLED LATIN CAPITAL LETTER '
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\rCITATION MARK'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x0cCKTAIL GLASS'
'\x05CKTIE'
'\x07CLEAVER'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLD SWEAT'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x16CONSONANT SIGN MEDIAL '
'\x18CONSONANT SIGN PASANGAN '
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\x05CROSS'
'\nCROSS MARK'
'\x0cCROSS POMMEE'
'\x07CROSSED'
'\tCROSSED O'
'\x0cCROSSED-TAIL'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x08CURLICUE'
'\x06CURLY '
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\nCY MESSAGE'
'\x04CYCL'
'\x01D'
'\x02D '
'\x07D APPLE'
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x0bD MIDDLE UP'
'\x16D PLUS GISH TIMES TAK4'
'\x06D SIGN'
'\x11D TIMES DISH TENU'
'\x0cD TIMES ESH2'
'\x0eD-UP NEWSPAPER'
'\x02DA'
'\x07DA FACE'
'\nDA SATANGA'
'\nDA2 TIMES '
'\x03DAA'
'\x03DAD'
'\x03DAH'
'\x05DAIC '
'\x19DAL WITH THREE DOTS BELOW'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x05DARA3'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDHI'
'\x05DDING'
'\x02DE'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\nDECORATION'
'\x03DEN'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\nDEOGRAPH A'
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\tDIAERESIS'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\rDIC MARK SIGN'
'\x06DIGIT '
'\x08DIM GUNU'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x04DIUM'
'\x05DIUM '
'\x05DLING'
'\x1fDMINTON RACQUET AND SHUTTLECOCK'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DOT'
'\tDOT ABOVE'
'\x08DOT REPH'
'\x10DOTTED CRESCENTS'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\x13DOUBLE MIDDLE TILDE'
'\x0fDOUBLE ORNAMENT'
'\x08DOUBLE R'
'\x0bDOUBLE RING'
'\x11DOUBLE RING ABOVE'
'\x0fDOUBLE TRIANGLE'
'\x04DOWN'
'\x05DOWN '
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x02DR'
'\x04DRAM'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x0cDUG TIMES NI'
'\x0eDUN3 GUNU GUNU'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x0eE BUTTON MOUSE'
'\x14E CONSONANT MODIFIER'
'\x07E GLASS'
'\x06E HOOK'
'\x05E OF '
'\x08E OF POO'
'\x07E WITH '
'\x0cE WITH GRAVE'
'\x0bE WITH VEIL'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x03EAD'
'\x07EAD ORE'
'\x04EANS'
'\x0bEARS OF JOY'
'\x04EART'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x05EATH '
'\x0fEAVY CHECK MARK'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x08ED BRICK'
'\x07ED FACE'
'\x08ED FLAGS'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x07ED RICE'
'\nEDESTRIANS'
'\x05EDIC '
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x03EEM'
'\x04EEM '
'\x19EEM WITH THREE DOTS ABOVE'
'\x03EEN'
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x02EF'
'\x06EFCASE'
'\x15EFT HORIZONTAL SECANT'
'\x1bEFT POINTING BACKHAND INDEX'
'\x14EFTWARDS ARROW WITH '
'\x02EH'
'\x08EH WITH '
'\x17EH WITH SMALL TEH ABOVE'
'\x02EI'
'\x05EIGHT'
'\x06EIGHT '
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x03EIN'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x0cELETION MARK'
'\x0bELLOW HEART'
'\x0bELTIC CROSS'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x05EMLJA'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x0bEN STRAIGHT'
'\x0bEN TWELFTHS'
'\nENCH FRIES'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\nENGER SHIP'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x06ENNANT'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\nENTRY SIGN'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x05EOPLE'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x1cEPIGRAPHIC LETTER SIDEWAYS I'
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04EREN'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x03ERT'
'\x03ERU'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\rESH2 ASTERISK'
'\rESH2 PLUS LAL'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\x04EVEN'
'\x08EVEN OF '
'\rEVEN TWELFTHS'
'\x13EVEN U VARIANT FORM'
'\x06EVENTY'
'\x0cEVERING FACE'
'\x0eEVERSED OPEN E'
'\x0bEVERSED TSE'
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0bEXED BICEPS'
'\x06EXHALE'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EYK'
'\x01F'
'\x02F '
'\x10F WITH DOT BELOW'
'\rF WITH STROKE'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x04FAST'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FEUQ'
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\x02FI'
'\x05FIER '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\tFINAL NUN'
'\x08FINGER C'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x06FLOWER'
'\nFLUTTERING'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x08FOR STOP'
'\nFORMATION '
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\tFOUR BENT'
'\nFOUR DOTS '
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\tFRACTION '
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x13FT-POINTING FLEURON'
'\x03FTY'
'\x03FUE'
'\tFULL STOP'
'\x01G'
'\x06G FACE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x02GA'
'\x03GAA'
'\nGAB TIMES '
'\x18GAF WITH INVERTED STROKE'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x05GALI '
'\x04GAME'
'\tGAN2 TENU'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x07GATIVE '
'\x05GAZE-'
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GEMINAT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x03GER'
'\x02GG'
'\x05GGER '
'\nGGING FACE'
'\x12GGLY VERTICAL LINE'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x02GI'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x07GRADUAL'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0bGREEK CROSS'
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x05GULUS'
'\x0eGUNU TIMES ASH'
'\rGUNU TIMES HA'
'\x05GVANG'
'\x02GY'
'\x04GYAN'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\tHA PLUS A'
'\x03HAA'
'\x03HAB'
'\x05HADDA'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x07HAJANI '
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x05HALA '
'\x04HALF'
'\x05HALF '
'\x08HALF GUR'
'\tHALF NOTE'
'\x05HALQA'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x04HAND'
'\x0cHAND FORMAT '
'\tHAND SIGN'
'\x17HAND TELEPHONE RECEIVER'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x04HAPH'
'\x03HAQ'
'\x0bHAR2 TIMES '
'\tHARD SIGN'
'\x03HAT'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x02HD'
'\x02HE'
'\x03HEA'
'\tHEAD MARK'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x04HENG'
'\rHER CHRISTMAS'
'\nHERMOMETER'
'\x04HERU'
'\x04HETH'
'\x05HEUAE'
'\x06HEUAEP'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHI TIMES ASH2'
'\rHIEROGLYPHIC '
'\x04HIGH'
'\x05HIGH '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x03HII'
'\x12HILOSOPHERS SULFUR'
'\x05HIMEL'
'\x03HIN'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x05HIRTY'
'\x08HITTING '
'\x07HIUCHUS'
'\x06HIVETE'
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x03HOM'
'\x04HOM '
'\x04HOOK'
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x06HORT I'
'\x04HOST'
'\x05HOTEL'
'\x08HOULDER '
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x06HREE D'
'\nHREE DOTS '
'\x0cHREE FINGERS'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x04HUB2'
'\x04HUET'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\tHWA WITH '
'\x04HWAH'
'\x02HY'
'\x06HYPHEN'
'\x01I'
'\x0eI AND SKI BOOT'
'\x06I GUNU'
'\x06I HOOK'
'\x07I NTEUM'
'\nI PLUS ZA7'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x1dI TIMES ASH OVER HI TIMES ASH'
'\x0cI TIMES TAK4'
'\x05I-RES'
'\x02I2'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\tIAL LINE '
'\x0eIAMOND CENTRED'
'\x18IAMOND CONTAINING BLACK '
'\x0eIAN RUPEE SIGN'
'\x06IB YAM'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x12ICKET BAT AND BALL'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x03IDE'
'\x0bIDUOUS TREE'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\x04IFTH'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\nIGATING RA'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x04IGHT'
'\nIGHT RULER'
'\rIGHT TWELFTHS'
'\x13IGHT U VARIANT FORM'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\x02IM'
'\x07IM GUNU'
'\nIMALUNGUN '
'\x04IMEL'
'\x05IMGBA'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\x18IN WITH THREE DOTS BELOW'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x0eINDICTION SIGN'
'\x03INE'
'\x08INFINITY'
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\nING LITTLE'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x06INHALE'
'\x08INITIAL '
'\x07INNABAR'
'\tINNYIIYHE'
'\x0eINOLOGICAL DOT'
'\x0eINSERTION SIGN'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x04INY '
'\x03ION'
'\x08ION MARK'
'\x02IP'
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x02IR'
'\x03IR2'
'\x05IRACY'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x05IRCUT'
'\x03IRL'
'\x04IRON'
'\x08IRPLANE '
'\x04IRTY'
'\x02IS'
'\x03ISA'
'\x03ISH'
'\rISH LIRA SIGN'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x11ITALIC LETTER ESS'
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x0eITERATION MARK'
'\x07ITTING '
'\x03IVE'
'\x04IVE '
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x12IVE U VARIANT FORM'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x11IX U VARIANT FORM'
'\x04IXTY'
'\x06IXTY P'
'\rIYA FRACTION '
'\x04IYAQ'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x13J WITH CROSSED-TAIL'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x05JERVI'
'\x03JHA'
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x06JOINER'
'\x05JUDUL'
'\x01K'
'\x02K '
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x15K WITH OBLIQUE STROKE'
'\x02K-'
'\x05K-020'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x03KAK'
'\x04KAKO'
'\x04KALI'
'\x03KAM'
'\x04KAPH'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x03KAU'
'\x05KBALL'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\x05KESH2'
'\x10KETBALL AND HOOP'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x05KHMU '
'\x06KILLER'
'\nKINDI MVOP'
'\tKING FACE'
'\x04KINI'
'\x19KISIM5 TIMES U2 PLUS MASH'
'\x04KISS'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x04KRI '
'\x05KTOP '
'\x03KU3'
'\x03KUE'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x12KUSHU2 PLUS KASKAL'
'\x05KWAEN'
'\x06KY WAY'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL WITH BELT'
'\x10L WITH DESCENDER'
'\x1aL WITH DOUBLE MIDDLE TILDE'
'\x02LA'
'\x03LAA'
'\x04LAAM'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x18LACK CIRCLED WHITE ARROW'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x0bLACKLETTER '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x07LAK-050'
'\x03LAM'
'\x04LAM '
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\x1aLANTED SOUTH ARROW WITH HO'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x08LATION X'
'\x03LAU'
'\x03LAW'
'\x08LAYALAM '
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDER'
'\x0eLDREN CROSSING'
'\x02LE'
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x16LEFT-POINTING TRIANGLE'
'\x17LEFT-SHADED WHITE ARROW'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x03LEI'
'\x07LENGTH-'
'\x04LEPH'
'\x06LETTER'
'\x07LETTER '
'\rLETTER KHINYA'
'\x0bLETTER LLLA'
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x08LETTER S'
'\x1aLETTER SMALL CAPITAL OMEGA'
'\x08LETTER Y'
'\nLETTER ZHA'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x03LF '
'\x07LF FACE'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x08LICOPTER'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\x04LINE'
'\x05LINE '
'\x0bLINE FILLER'
'\x05LING '
'\x03LIP'
'\x04LIPS'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x03LLA'
'\tLLAR SIGN'
'\tLLEN LEAF'
'\x07LLEYBUS'
'\x06LLHORN'
'\x07LLIARDS'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x03LLL'
'\x04LLLA'
'\x03LLO'
'\x10LLOW PAN OF FOOD'
'\x02LM'
'\x02LO'
'\x05LOAN '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x04LONG'
'\nLONG FINAL'
'\tLONG TIP '
'\x0eLONG-LEGGED DE'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x04LOVO'
'\x03LOW'
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\x13LOW NOON WITH KASRA'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x05LOWER'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x04LPHA'
'\x05LPHIN'
'\x02LT'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x05LTIRE'
'\x08LTRY LEG'
'\x03LU3'
'\x03LUB'
'\x07LUGGAGE'
'\x03LUM'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x07LY LOOP'
'\x01M'
'\x02M '
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x08M SYMBOL'
'\nM TIMES ME'
'\x13M WITH CROSSED-TAIL'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x07MACRON '
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\rMALL CAPITAL '
'\x0eMALL CAPITAL I'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x08MALL YUS'
'\x03MAN'
'\x03MAQ'
'\rMAR TIMES KUG'
'\x04MARK'
'\x05MARK '
'\tMARK CIM '
'\tMARK SHAD'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0bMBLER GLASS'
'\x16MBOL FOR MARKS CHAPTER'
'\x0bMBU LETTER '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x04MED '
'\x0cMEDARY CAMEL'
'\x0cMEDICAL MASK'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x10MENIAN DRAM SIGN'
'\x05MENOE'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x0bMIC LETTER '
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x04MIIM'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\x08MILLIONS'
'\x04MILY'
'\rMINDER RIBBON'
'\nMINUS SIGN'
'\nMISMA SIGN'
'\x0fMISSION TICKETS'
'\x04MIZE'
'\x03MMA'
'\x02MO'
'\rMOBILE PHONES'
'"MODIFIER LETTER SHAN REDUPLICATION'
'\rMODIFIER MARK'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x04MUAS'
'\x04MUCH'
'\x08MULTIPLE'
'\x11MUM LETTER PHASE-'
'\x04MUSH'
'\x08MY HOUSE'
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x11N PLUS KAK PLUS A'
'\x12N VIEWING CEREMONY'
'\x07N WITH '
'\x10N WITH LEFT HOOK'
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x08NA METEK'
'\x03NAA'
'\x04NAKE'
'\x04NAM2'
'\x08NARROW O'
'\x0cNARROW SHAFT'
'\x05NASHI'
'\x03NAU'
'\x04NBOW'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\x02ND'
'\x0bND OF PIECE'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x04NED '
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x03NEY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x0bNG LEFT LEG'
'\x14NG WITH CROSSED-TAIL'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\tNIGHT OF '
'\x0bNIKOLSBURG '
'\x04NINE'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x13NINE U VARIANT FORM'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\x0bNITIAL IZHE'
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x03NNA'
'\x06NNADA '
'\x03NNI'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x04NOSE'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x04NOWC'
'\x08NOWLEDGE'
'\x08NRES TOS'
'\x04NRUA'
'\tNS-SERIF '
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\tNTESSENCE'
'\x05NTHA '
'\x0bNTIMONY ORE'
'\x05NTXIV'
'\x03NUB'
'\x05NUKTA'
'\x07NUMBER '
'\x11NUMBER MARK ABOVE'
'\x08NUMBER T'
'\x07NUMBERS'
'\rNUMERIC SIGN '
'\x03NUN'
'\x07NUSVARA'
'\x04NUTS'
'\x08NVERTED '
'\x03NYA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x04OALA'
'\x03OAP'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x04OBRO'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\x08OCK SALT'
'\x05OCKET'
'\x0bOCOLATE BAR'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x08OGOGRAM '
'\x04OGRE'
'\x02OH'
'\rOHIBITED SIGN'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x1eOJI MODIFIER FITZPATRICK TYPE-'
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\nOKEN HEART'
'\x0cOKING SYMBOL'
'\x02OL'
'\x03OLD'
'\x04OLD '
'\x05OLDER'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\rOLVING HEARTS'
'\x02OM'
'\x14OM HALF BLACK CIRCLE'
'\x08OM NTEUM'
'\x08OMANIAN '
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x0eOMING ENVELOPE'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x07ON FACE'
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0bONE HUNDRED'
'\x10ONE QUARTER SIGN'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x04ONG '
'\tONG GRAVE'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x16ONJOINING MACRON BELOW'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x02OO'
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x02OP'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\tOPERATOR '
'\x03OPH'
'\x06OPPER '
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x04ORD '
'\rORD SEPARATOR'
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x07OTATED '
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x08OTPRINTS'
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x07OUBLE O'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x05OUR K'
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\x12OUR U VARIANT FORM'
'\x0bOUSEL HORSE'
'\x03OUT'
'\nOUT HANDLE'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\nOUTHERN TA'
'\x04OVAL'
'\x05OVER '
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\x16OVER NU11 BUR OVER BUR'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SHE'
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\nOWEL SIGN '
'\x03OWN'
'\rOWN POINTING '
'\x03OX '
'\x02OY'
'\x07OYSTICK'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x17P WITH EXCLAMATION MARK'
'\x02PA'
'\rPA NJI PIPAEM'
'\x04PACE'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x04PALM'
'\x03PAN'
'\x07PANESE '
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\x06PBOARD'
'\x02PE'
'\x0cPE CARTRIDGE'
'\x06PEAKS '
'\x04PEEI'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\x07PENNANT'
'\x0fPENSION RAILWAY'
'\x06PEPPER'
'\x03PER'
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x04PHAB'
'\x05PHANT'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x06PICKET'
'\x07PICTURE'
'\x04PING'
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\tPLE HEART'
'\x08PLE LEAF'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x07PLOYAN '
'\x04PLUG'
'\x05PLUS '
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\x08PRESSION'
'\x11PRESSIONLESS FACE'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x05PTIC '
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'#PUNCTUATION SIGN DIAGONAL QUADCOLON'
'\x03PUQ'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x06PWATCH'
'\x01Q'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x13QUADRUPLE CRESCENTS'
'\x06QUARE '
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\x0bQUARTER GUR'
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x08QUARTERS'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x01R'
'\tR COASTER'
'\x06R FACE'
'\x07R PLUS '
'\x03R S'
'\x06R WITH'
'\x10R WITH RIGHT LEG'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x07R2 GUNU'
'\x02RA'
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x0bRAISED FLAG'
' RAISED HAND WITH FINGERS SPLAYED'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x04RAMA'
'\x04RAN '
'\nRANG CITI '
'\x0bRANSMISSION'
'\x07RANTHA '
'\x03RAT'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x06RAVEL-'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\nRDHACANDRA'
'\x02RE'
'\tREAK HERE'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x11REATIONAL VEHICLE'
'\x08RECEIVER'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\nRED CIRCLE'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x10REPETITION MARK-'
'\x04RESH'
'\x17RETROFLEX HOOK AND BELT'
'\x03REU'
'\x0fREVERSE SOLIDUS'
'\x0cREVERSED TSE'
'\x04RFER'
'\x18RGLASS WITH FLOWING SAND'
'\x03RHO'
'\x02RI'
'\x07RIANGLE'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x17RIGHT HORIZONTAL SECANT'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x14RIGHT POINTING INDEX'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x06RIN2 X'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\nRING THUMB'
'\x07RINKLES'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x07RIPPLE '
'\x05RIPT '
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x17RK SIDEWAYS NOON GHUNNA'
'\rRK SUNGLASSES'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x02RO'
'\x03RO '
'\x06ROCKET'
'\x07ROITIC '
'\x0cROLLING EYES'
'\x03ROM'
'\x1bRONOMICAL SYMBOL FOR URANUS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x06ROPLET'
'\x04ROSS'
'\x14ROTATED ARDHAVISARGA'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\nROUNDED ER'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\nRRIS WHEEL'
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x04RSO-'
'\x02RT'
'\x06RT OF '
'\rRTABLE STEREO'
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x05RUMP-'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\x07S-SAJDA'
'\x02SA'
'\x07SA VAH '
'\x03SAA'
'\x03SAD'
'\x03SAH'
'\x05SAKTA'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x06SANDAL'
'\x07SANDHI '
'\x10SANS-SERIF ARROW'
'\x0bSAPPOINTED '
'\x03SAR'
'\x05SARGA'
'\x03SAU'
'\nSCENT MOON'
'\x05SCHWA'
'\x07SCOOTER'
'\x05SCOPE'
'\x08SCRIPT X'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
':SENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\x03SH '
'\x0bSH PLUS SHU'
'\x1bSH TIMES GISH CROSSING GISH'
'\x03SH2'
'\x11SH2 CROSSING ESH2'
'\x03SH3'
'\x03SHA'
'\tSHAB CEEB'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x08SHAN SAW'
'\x17SHAPE WITH A DOT INSIDE'
'\x0bSHE AT LEFT'
'\tSHED FACE'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x0eSHESHIG TIMES '
'\x11SHESHIG TIMES BAD'
'\x13SHHA WITH DESCENDER'
'\x03SHI'
'\x07SHIFT T'
'\x04SHIM'
'\x04SHIN'
'\nSHMIRI YEH'
'\x06SHORT '
'\x08SHORT ER'
'\x0fSHORT RIGHT LEG'
'\x05SHPIN'
'\rSHTIN TIMES U'
'\x03SHU'
'\x04SHU2'
'\x04SHUL'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\x04SIGN'
'\x05SIGN '
' SIGN COMBINING CANDRABINDU ABOVE'
'\x11SIGN O WITH CROSS'
'\x0cSIGN SIDDHAM'
'\x07SIGN UD'
'\x0bSIGN VIRAMA'
'\x03SII'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x13SLANTED NORTH ARROW'
'\x05SMALL'
'\x06SMALL '
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x05SOLVE'
'\x0eSONAL COMPUTER'
'\x06SOUTH '
'\x07SOV ROG'
'\x02SP'
'\x13SPACING CANDRABINDU'
'\x06SPADES'
'\x06SPAPER'
'\x03SPE'
'\rSPEECH BUBBLE'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x05SPINE'
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x06SQUARE'
'\x08SQUARED '
'\x04SQUE'
'\x08SQUEEZED'
'\x02SS'
'\rSSAGE WAITING'
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\tSTAL BALL'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\tSTEBASKET'
'\tSTER FACE'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\x06STRING'
'\x06STROKE'
'"STRONG CENTRALIZATION STROKE BELOW'
'\x0eSTRONG ISOLATE'
'\x06STROOM'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x04SUAB'
'\x04SUCK'
'\x06SUCKED'
'\x05SURYA'
'\x0fSUSPENSION MARK'
'\x03SUU'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x0bT SEPARATOR'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x10TAI LAING DIGIT '
'\x0fTAI LAING TONE-'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\x03TAN'
'\x06TARGET'
'\x06TATED '
'\x03TAW'
'\x04TAXI'
'\x02TE'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\x03TEN'
'\x05TENSE'
'\x04TENU'
'\x03TER'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\x0bTH-THALATHA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x05THIRD'
'\x0cTHLETIC SHOE'
'\x0eTHOUGHT BUBBLE'
'\x08THOUSAND'
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0eTHREE POINTED '
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x06TICAL '
'\nTICAL DISC'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES KUR'
'\x08TIMES UD'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\x06TITLO '
'\x03TLE'
'\x06TLESS '
'\x02TO'
'\x06TO BAR'
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x04TONE'
'\x05TONE '
'\x06TONGUE'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x13TOUCHTONE TELEPHONE'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x03TRA'
'\x05TRACK'
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x03TRE'
'\nTREFACTION'
'\tTRETCHED '
'\x03TRI'
'\x0bTRIAN CAMEL'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x03TRO'
'\x05TROL '
'\x07TROLLEY'
'\x05TSEEB'
'\x02TT'
'\x03TTE'
'\x05TTER '
'\x07TTERFLY'
'\x03TTH'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x03TUJ'
'\x06TURBAN'
'\x05TURN '
'\x07TURNED '
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED SECTION MARK'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x03TWO'
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x13U OVER BU TIMES NA2'
'\x08U TIMES '
'\x05U U U'
'\x07U WITH '
'\x10U WITH LEFT HOOK'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x04U11 '
'\x03U2 '
'\x08U2 PLUS '
'\nU2 PLUS BA'
'\x02U3'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\x02UB'
'\x03UB '
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x04UBLE'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\tUG TIMES '
'\x07UGGLING'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x05ULAR '
'\x07ULATION'
'\x03ULL'
'\tULL MOON '
'\x08ULL STOP'
'\x02UM'
'\tUM TIMES '
'\x12UM WITH DRUMSTICKS'
'\x08UMBRELLA'
'\x05UMBS '
'\x05UMPET'
'\x02UN'
'\x07UN MEUT'
'\x0cUNBLENDED UK'
'\x04UND '
'\x05UNDER'
'\x06UNDER '
'\x03UNG'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x0cUP SEPARATOR'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\rUP TACK ABOVE'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x03UR '
'\nUR HUNDRED'
'\x06UR OF '
'\x19URASHTRA SIGN CANDRABINDU'
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x03URL'
'\x06URNAMA'
'\x11URNED DAMMA BELOW'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\x06USHPIN'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\x04UTH '
'\nUTH OR SPY'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\x07V BELOW'
'\x07V WITH '
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x07VARIANT'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\tVE THUMB '
'\x07VED ICE'
'\x04VEDE'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\rVERGREEN TREE'
'\x06VERLAP'
'\x10VERTED PENTAGRAM'
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x0bVERY SMALL '
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x02VI'
'\x0cVICTORY HAND'
'\nVIE CAMERA'
'\tVINE LEAF'
'\x05VING '
'\x06VIRAMA'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x06VOCADO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x08VOLAPUK '
'\x03VOP'
'\x04VOS '
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0bVOWEL SIGN '
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x05WAQFA'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x0bWE PALAUNG '
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x03WER'
'\x04WER '
'\x11WER PLAYING CARDS'
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x05WFISH'
'\x06WHITE '
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\x0bWHITE JOKER'
'\x0cWHITE SQUARE'
'\nWHOLE NOTE'
'\x02WI'
'\x04WIDE'
'\x07WIDE ES'
'\x05WIDTH'
'\x07WIFRUIT'
'\x11WIGGLY LINE BELOW'
'\x06WINDOW'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x07WN FACE'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x08WO DOTS '
'\nWO FINGERS'
'\x06WO OF '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WUAET'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\tX WITH LO'
'\tX-X BELOW'
'\x02XA'
'\x03XAU'
'\tXCITEMENT'
'\x02XE'
'\x04XEYN'
'\nXHEEJ CEEV'
'\x02XI'
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x07XT LINE'
'\x15XTRA SHORT VOWEL MARK'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x08Y POPPER'
'\nY THOUSAND'
'\x16Y WITH SHORT RIGHT LEG'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x03YAN'
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x08YEN SIGN'
'\x04YEUX'
'\x02YI'
'\x03YI '
'\x03YIN'
'\nYING CARD '
'\rYING ENVELOPE'
'\tYING FACE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x05YMBOL'
'\x06YMBOL '
'\x0cYMBOL BINDU '
'\rYMBOL KIEVAN '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x04YODH'
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x01Z'
'\x02ZA'
'\x03ZAH'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x04ZEN '
'\x04ZERO'
'\x03ZHE'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x04ZIZ2'
'\x02ZO'
'\nZU OVER ZU'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZHE'
'\x04ZZY '
)
_charnodes =[67073,
 -35317,
 -1,
 132354,
 3732,
 -1,
 197456,
 86902,
 -1,
 262991,
 144145,
 -1,
 328526,
 229728,
 -1,
 394061,
 270254,
 -1,
 458869,
 330828,
 -1,
 524306,
 396809,
 -1,
 -65527,
 462345,
 101050,
 -65526,
 527754,
 101049,
 -65525,
 593124,
 101048,
 -65524,
 658508,
 101047,
 -65523,
 723874,
 101046,
 -65522,
 789254,
 101045,
 -65521,
 854605,
 101044,
 -65520,
 919925,
 101043,
 -65519,
 985305,
 101042,
 -1,
 1050697,
 101041,
 1245213,
 462218,
 -1,
 -65516,
 1183241,
 101040,
 -65515,
 1248650,
 101039,
 -65514,
 1314020,
 101038,
 -65513,
 1379404,
 101037,
 -65512,
 1444770,
 101036,
 -65511,
 1510150,
 101035,
 -65510,
 1575501,
 101034,
 -65509,
 1640821,
 101033,
 -65508,
 1706201,
 101032,
 -1,
 1771593,
 101031,
 1966120,
 1182948,
 -1,
 -65505,
 1904137,
 101030,
 -65504,
 1969546,
 101029,
 -65503,
 2034916,
 101028,
 -65502,
 2100300,
 101027,
 -65501,
 2165666,
 101026,
 -65500,
 2231046,
 101025,
 -65499,
 2296397,
 101024,
 -65498,
 2361717,
 101023,
 -65497,
 2427097,
 101022,
 -1,
 2492489,
 101021,
 2687027,
 1903692,
 -1,
 -65494,
 2625033,
 101020,
 -65493,
 2690442,
 101019,
 -65492,
 2755812,
 101018,
 -65491,
 2821196,
 101017,
 -65490,
 2886562,
 101016,
 -65489,
 2951942,
 101015,
 -65488,
 3017293,
 101014,
 -65487,
 3082613,
 101013,
 -65486,
 3147993,
 101012,
 -1,
 3213385,
 101011,
 3407934,
 2624418,
 -1,
 -65483,
 3345929,
 101010,
 -65482,
 3411338,
 101009,
 -65481,
 3476708,
 101008,
 -65480,
 3542092,
 101007,
 -65479,
 3607458,
 101006,
 -65478,
 3672838,
 101005,
 -65477,
 3738189,
 101004,
 -65476,
 3803509,
 101003,
 -65475,
 3868889,
 101002,
 -1,
 3934281,
 101001,
 4128841,
 3345158,
 -1,
 -65472,
 4066825,
 101000,
 -65471,
 4132234,
 100999,
 -65470,
 4197604,
 100998,
 -65469,
 4262988,
 100997,
 -65468,
 4328354,
 100996,
 -65467,
 4393734,
 100995,
 -65466,
 4459085,
 100994,
 -65465,
 4524405,
 100993,
 -65464,
 4589785,
 100992,
 -1,
 4655177,
 100991,
 4849748,
 4065869,
 -1,
 -65461,
 4787721,
 100990,
 -65460,
 4853130,
 100989,
 -65459,
 4918500,
 100988,
 -65458,
 4983884,
 100987,
 -65457,
 5049250,
 100986,
 -65456,
 5114630,
 100985,
 -65455,
 5179981,
 100984,
 -65454,
 5245301,
 100983,
 -65453,
 5310681,
 100982,
 -1,
 5376073,
 100981,
 5570655,
 4786549,
 -1,
 -65450,
 5508617,
 100980,
 -65449,
 5574026,
 100979,
 -65448,
 5639396,
 100978,
 -65447,
 5704780,
 100977,
 -65446,
 5770146,
 100976,
 -65445,
 5835526,
 100975,
 -65444,
 5900877,
 100974,
 -65443,
 5966197,
 100973,
 -65442,
 6031577,
 100972,
 -1,
 6096969,
 100971,
 6291562,
 5507289,
 -1,
 -65439,
 6229513,
 100970,
 -65438,
 6294922,
 100969,
 -65437,
 6360292,
 100968,
 -65436,
 6425676,
 100967,
 -65435,
 6491042,
 100966,
 -65434,
 6556422,
 100965,
 -65433,
 6621773,
 100964,
 -65432,
 6687093,
 100963,
 -65431,
 6752473,
 100962,
 -1,
 6817865,
 100961,
 7077887,
 6228041,
 -1,
 -65428,
 6950409,
 100960,
 -65427,
 7015818,
 100959,
 -65426,
 7081188,
 100958,
 -65425,
 7146572,
 100957,
 -65424,
 7211938,
 100956,
 -65423,
 7277318,
 100955,
 -65422,
 7342669,
 100954,
 -65421,
 7407989,
 100953,
 -65420,
 7473369,
 100952,
 -1,
 7538761,
 100951,
 7733476,
 396194,
 -1,
 7798913,
 7671305,
 -1,
 -65416,
 7736841,
 100950,
 -65415,
 7802250,
 100949,
 -65414,
 7867620,
 100948,
 -65413,
 7933004,
 100947,
 -65412,
 7998370,
 100946,
 -65411,
 8063750,
 100945,
 -65410,
 8129101,
 100944,
 -65409,
 8194421,
 100943,
 -65408,
 8259801,
 100942,
 -1,
 8325193,
 100941,
 8519820,
 7736714,
 -1,
 -65405,
 8457737,
 100940,
 -65404,
 8523146,
 100939,
 -65403,
 8588516,
 100938,
 -65402,
 8653900,
 100937,
 -65401,
 8719266,
 100936,
 -65400,
 8784646,
 100935,
 -65399,
 8849997,
 100934,
 -65398,
 8915317,
 100933,
 -65397,
 8980697,
 100932,
 -1,
 9046089,
 100931,
 9240727,
 8457444,
 -1,
 -65394,
 9178633,
 100930,
 -65393,
 9244042,
 100929,
 -65392,
 9309412,
 100928,
 -65391,
 9374796,
 100927,
 -65390,
 9440162,
 100926,
 -65389,
 9505542,
 100925,
 -65388,
 9570893,
 100924,
 -65387,
 9636213,
 100923,
 -65386,
 9701593,
 100922,
 -1,
 9766985,
 100921,
 9961634,
 9178188,
 -1,
 -65383,
 9899529,
 100920,
 -65382,
 9964938,
 100919,
 -65381,
 10030308,
 100918,
 -65380,
 10095692,
 100917,
 -65379,
 10161058,
 100916,
 -65378,
 10226438,
 100915,
 -65377,
 10291789,
 100914,
 -65376,
 10357109,
 100913,
 -65375,
 10422489,
 100912,
 -1,
 10487881,
 100911,
 10682541,
 9898914,
 -1,
 -65372,
 10620425,
 100910,
 -65371,
 10685834,
 100909,
 -65370,
 10751204,
 100908,
 -65369,
 10816588,
 100907,
 -65368,
 10881954,
 100906,
 -65367,
 10947334,
 100905,
 -65366,
 11012685,
 100904,
 -65365,
 11078005,
 100903,
 -65364,
 11143385,
 100902,
 -1,
 11208777,
 100901,
 11403448,
 10619654,
 -1,
 -65361,
 11341321,
 100900,
 -65360,
 11406730,
 100899,
 -65359,
 11472100,
 100898,
 -65358,
 11537484,
 100897,
 -65357,
 11602850,
 100896,
 -65356,
 11668230,
 100895,
 -65355,
 11733581,
 100894,
 -65354,
 11798901,
 100893,
 -65353,
 11864281,
 100892,
 -1,
 11929673,
 100891,
 12124355,
 11340365,
 -1,
 -65350,
 12062217,
 100890,
 -65349,
 12127626,
 100889,
 -65348,
 12192996,
 100888,
 -65347,
 12258380,
 100887,
 -65346,
 12323746,
 100886,
 -65345,
 12389126,
 100885,
 -65344,
 12454477,
 100884,
 -65343,
 12519797,
 100883,
 -65342,
 12585177,
 100882,
 -1,
 12650569,
 100881,
 12845262,
 12061045,
 -1,
 -65339,
 12783113,
 100880,
 -65338,
 12848522,
 100879,
 -65337,
 12913892,
 100878,
 -65336,
 12979276,
 100877,
 -65335,
 13044642,
 100876,
 -65334,
 13110022,
 100875,
 -65333,
 13175373,
 100874,
 -65332,
 13240693,
 100873,
 -65331,
 13306073,
 100872,
 -1,
 13371465,
 100871,
 13566169,
 12781785,
 -1,
 -65328,
 13504009,
 100870,
 -65327,
 13569418,
 100869,
 -65326,
 13634788,
 100868,
 -65325,
 13700172,
 100867,
 -65324,
 13765538,
 100866,
 -65323,
 13830918,
 100865,
 -65322,
 13896269,
 100864,
 -65321,
 13961589,
 100863,
 -65320,
 14026969,
 100862,
 -1,
 14092361,
 100861,
 14352383,
 13502537,
 -1,
 -65317,
 14224905,
 100860,
 -65316,
 14290314,
 100859,
 -65315,
 14355684,
 100858,
 -65314,
 14421068,
 100857,
 -65313,
 14486434,
 100856,
 -65312,
 14551814,
 100855,
 -65311,
 14617165,
 100854,
 -65310,
 14682485,
 100853,
 -65309,
 14747865,
 100852,
 -1,
 14813257,
 100851,
 15008083,
 7670534,
 -1,
 15073520,
 14945801,
 -1,
 -65305,
 15011337,
 100850,
 -65304,
 15076746,
 100849,
 -65303,
 15142116,
 100848,
 -65302,
 15207500,
 100847,
 -65301,
 15272866,
 100846,
 -65300,
 15338246,
 100845,
 -65299,
 15403597,
 100844,
 -65298,
 15468917,
 100843,
 -65297,
 15534297,
 100842,
 -1,
 15599689,
 100841,
 15794427,
 15011210,
 -1,
 -65294,
 15732233,
 100840,
 -65293,
 15797642,
 100839,
 -65292,
 15863012,
 100838,
 -65291,
 15928396,
 100837,
 -65290,
 15993762,
 100836,
 -65289,
 16059142,
 100835,
 -65288,
 16124493,
 100834,
 -65287,
 16189813,
 100833,
 -65286,
 16255193,
 100832,
 -1,
 16320585,
 100831,
 16515334,
 15731940,
 -1,
 -65283,
 16453129,
 100830,
 -65282,
 16518538,
 100829,
 -65281,
 16583908,
 100828,
 -65280,
 16649292,
 100827,
 -65279,
 16714658,
 100826,
 -65278,
 16780038,
 100825,
 -65277,
 16845389,
 100824,
 -65276,
 16910709,
 100823,
 -65275,
 16976089,
 100822,
 -1,
 17041481,
 100821,
 17236241,
 16452684,
 -1,
 -65272,
 17174025,
 100820,
 -65271,
 17239434,
 100819,
 -65270,
 17304804,
 100818,
 -65269,
 17370188,
 100817,
 -65268,
 17435554,
 100816,
 -65267,
 17500934,
 100815,
 -65266,
 17566285,
 100814,
 -65265,
 17631605,
 100813,
 -65264,
 17696985,
 100812,
 -1,
 17762377,
 100811,
 17957148,
 17173410,
 -1,
 -65261,
 17894921,
 100810,
 -65260,
 17960330,
 100809,
 -65259,
 18025700,
 100808,
 -65258,
 18091084,
 100807,
 -65257,
 18156450,
 100806,
 -65256,
 18221830,
 100805,
 -65255,
 18287181,
 100804,
 -65254,
 18352501,
 100803,
 -65253,
 18417881,
 100802,
 -1,
 18483273,
 100801,
 18678055,
 17894150,
 -1,
 -65250,
 18615817,
 100800,
 -65249,
 18681226,
 100799,
 -65248,
 18746596,
 100798,
 -65247,
 18811980,
 100797,
 -65246,
 18877346,
 100796,
 -65245,
 18942726,
 100795,
 -65244,
 19008077,
 100794,
 -65243,
 19073397,
 100793,
 -65242,
 19138777,
 100792,
 -1,
 19204169,
 100791,
 19398962,
 18614861,
 -1,
 -65239,
 19336713,
 100790,
 -65238,
 19402122,
 100789,
 -65237,
 19467492,
 100788,
 -65236,
 19532876,
 100787,
 -65235,
 19598242,
 100786,
 -65234,
 19663622,
 100785,
 -65233,
 19728973,
 100784,
 -65232,
 19794293,
 100783,
 -65231,
 19859673,
 100782,
 -1,
 19925065,
 100781,
 20119869,
 19335541,
 -1,
 -65228,
 20057609,
 100780,
 -65227,
 20123018,
 100779,
 -65226,
 20188388,
 100778,
 -65225,
 20253772,
 100777,
 -65224,
 20319138,
 100776,
 -65223,
 20384518,
 100775,
 -65222,
 20449869,
 100774,
 -65221,
 20515189,
 100773,
 -65220,
 20580569,
 100772,
 -1,
 20645961,
 100771,
 20840776,
 20056281,
 -1,
 -65217,
 20778505,
 100770,
 -65216,
 20843914,
 100769,
 -65215,
 20909284,
 100768,
 -65214,
 20974668,
 100767,
 -65213,
 21040034,
 100766,
 -65212,
 21105414,
 100765,
 -65211,
 21170765,
 100764,
 -65210,
 21236085,
 100763,
 -65209,
 21301465,
 100762,
 -1,
 21366857,
 100761,
 21626879,
 20777033,
 -1,
 -65206,
 21499401,
 100760,
 -65205,
 21564810,
 100759,
 -65204,
 21630180,
 100758,
 -65203,
 21695564,
 100757,
 -65202,
 21760930,
 100756,
 -65201,
 21826310,
 100755,
 -65200,
 21891661,
 100754,
 -65199,
 21956981,
 100753,
 -65198,
 22022361,
 100752,
 -1,
 22087753,
 100751,
 22282690,
 14944845,
 -1,
 22348127,
 22220297,
 -1,
 -65194,
 22285833,
 100750,
 -65193,
 22351242,
 100749,
 -65192,
 22416612,
 100748,
 -65191,
 22481996,
 100747,
 -65190,
 22547362,
 100746,
 -65189,
 22612742,
 100745,
 -65188,
 22678093,
 100744,
 -65187,
 22743413,
 100743,
 -65186,
 22808793,
 100742,
 -1,
 22874185,
 100741,
 23069034,
 22285706,
 -1,
 -65183,
 23006729,
 100740,
 -65182,
 23072138,
 100739,
 -65181,
 23137508,
 100738,
 -65180,
 23202892,
 100737,
 -65179,
 23268258,
 100736,
 -65178,
 23333638,
 100735,
 -65177,
 23398989,
 100734,
 -65176,
 23464309,
 100733,
 -65175,
 23529689,
 100732,
 -1,
 23595081,
 100731,
 23789941,
 23006436,
 -1,
 -65172,
 23727625,
 100730,
 -65171,
 23793034,
 100729,
 -65170,
 23858404,
 100728,
 -65169,
 23923788,
 100727,
 -65168,
 23989154,
 100726,
 -65167,
 24054534,
 100725,
 -65166,
 24119885,
 100724,
 -65165,
 24185205,
 100723,
 -65164,
 24250585,
 100722,
 -1,
 24315977,
 100721,
 24510848,
 23727180,
 -1,
 -65161,
 24448521,
 100720,
 -65160,
 24513930,
 100719,
 -65159,
 24579300,
 100718,
 -65158,
 24644684,
 100717,
 -65157,
 24710050,
 100716,
 -65156,
 24775430,
 100715,
 -65155,
 24840781,
 100714,
 -65154,
 24906101,
 100713,
 -65153,
 24971481,
 100712,
 -1,
 25036873,
 100711,
 25231755,
 24447906,
 -1,
 -65150,
 25169417,
 100710,
 -65149,
 25234826,
 100709,
 -65148,
 25300196,
 100708,
 -65147,
 25365580,
 100707,
 -65146,
 25430946,
 100706,
 -65145,
 25496326,
 100705,
 -65144,
 25561677,
 100704,
 -65143,
 25626997,
 100703,
 -65142,
 25692377,
 100702,
 -1,
 25757769,
 100701,
 25952662,
 25168646,
 -1,
 -65139,
 25890313,
 100700,
 -65138,
 25955722,
 100699,
 -65137,
 26021092,
 100698,
 -65136,
 26086476,
 100697,
 -65135,
 26151842,
 100696,
 -65134,
 26217222,
 100695,
 -65133,
 26282573,
 100694,
 -65132,
 26347893,
 100693,
 -65131,
 26413273,
 100692,
 -1,
 26478665,
 100691,
 26673569,
 25889357,
 -1,
 -65128,
 26611209,
 100690,
 -65127,
 26676618,
 100689,
 -65126,
 26741988,
 100688,
 -65125,
 26807372,
 100687,
 -65124,
 26872738,
 100686,
 -65123,
 26938118,
 100685,
 -65122,
 27003469,
 100684,
 -65121,
 27068789,
 100683,
 -65120,
 27134169,
 100682,
 -1,
 27199561,
 100681,
 27394476,
 26610037,
 -1,
 -65117,
 27332105,
 100680,
 -65116,
 27397514,
 100679,
 -65115,
 27462884,
 100678,
 -65114,
 27528268,
 100677,
 -65113,
 27593634,
 100676,
 -65112,
 27659014,
 100675,
 -65111,
 27724365,
 100674,
 -65110,
 27789685,
 100673,
 -65109,
 27855065,
 100672,
 -1,
 27920457,
 100671,
 28115383,
 27330777,
 -1,
 -65106,
 28053001,
 100670,
 -65105,
 28118410,
 100669,
 -65104,
 28183780,
 100668,
 -65103,
 28249164,
 100667,
 -65102,
 28314530,
 100666,
 -65101,
 28379910,
 100665,
 -65100,
 28445261,
 100664,
 -65099,
 28510581,
 100663,
 -65098,
 28575961,
 100662,
 -1,
 28641353,
 100661,
 28901375,
 28051529,
 -1,
 -65095,
 28773897,
 100660,
 -65094,
 28839306,
 100659,
 -65093,
 28904676,
 100658,
 -65092,
 28970060,
 100657,
 -65091,
 29035426,
 100656,
 -65090,
 29100806,
 100655,
 -65089,
 29166157,
 100654,
 -65088,
 29231477,
 100653,
 -65087,
 29296857,
 100652,
 -1,
 29362249,
 100651,
 29557297,
 22219125,
 -1,
 29622734,
 29494793,
 -1,
 -65083,
 29560329,
 100650,
 -65082,
 29625738,
 100649,
 -65081,
 29691108,
 100648,
 -65080,
 29756492,
 100647,
 -65079,
 29821858,
 100646,
 -65078,
 29887238,
 100645,
 -65077,
 29952589,
 100644,
 -65076,
 30017909,
 100643,
 -65075,
 30083289,
 100642,
 -1,
 30148681,
 100641,
 30343641,
 29560202,
 -1,
 -65072,
 30281225,
 100640,
 -65071,
 30346634,
 100639,
 -65070,
 30412004,
 100638,
 -65069,
 30477388,
 100637,
 -65068,
 30542754,
 100636,
 -65067,
 30608134,
 100635,
 -65066,
 30673485,
 100634,
 -65065,
 30738805,
 100633,
 -65064,
 30804185,
 100632,
 -1,
 30869577,
 100631,
 31064548,
 30280932,
 -1,
 -65061,
 31002121,
 100630,
 -65060,
 31067530,
 100629,
 -65059,
 31132900,
 100628,
 -65058,
 31198284,
 100627,
 -65057,
 31263650,
 100626,
 -65056,
 31329030,
 100625,
 -65055,
 31394381,
 100624,
 -65054,
 31459701,
 100623,
 -65053,
 31525081,
 100622,
 -1,
 31590473,
 100621,
 31785455,
 31001676,
 -1,
 -65050,
 31723017,
 100620,
 -65049,
 31788426,
 100619,
 -65048,
 31853796,
 100618,
 -65047,
 31919180,
 100617,
 -65046,
 31984546,
 100616,
 -65045,
 32049926,
 100615,
 -65044,
 32115277,
 100614,
 -65043,
 32180597,
 100613,
 -65042,
 32245977,
 100612,
 -1,
 32311369,
 100611,
 32506362,
 31722402,
 -1,
 -65039,
 32443913,
 100610,
 -65038,
 32509322,
 100609,
 -65037,
 32574692,
 100608,
 -65036,
 32640076,
 100607,
 -65035,
 32705442,
 100606,
 -65034,
 32770822,
 100605,
 -65033,
 32836173,
 100604,
 -65032,
 32901493,
 100603,
 -65031,
 32966873,
 100602,
 -1,
 33032265,
 100601,
 33227269,
 32443142,
 -1,
 -65028,
 33164809,
 100600,
 -65027,
 33230218,
 100599,
 -65026,
 33295588,
 100598,
 -65025,
 33360972,
 100597,
 -65024,
 33426338,
 100596,
 -65023,
 33491718,
 100595,
 -65022,
 33557069,
 100594,
 -65021,
 33622389,
 100593,
 -65020,
 33687769,
 100592,
 -1,
 33753161,
 100591,
 33948176,
 33163853,
 -1,
 -65017,
 33885705,
 100590,
 -65016,
 33951114,
 100589,
 -65015,
 34016484,
 100588,
 -65014,
 34081868,
 100587,
 -65013,
 34147234,
 100586,
 -65012,
 34212614,
 100585,
 -65011,
 34277965,
 100584,
 -65010,
 34343285,
 100583,
 -65009,
 34408665,
 100582,
 -1,
 34474057,
 100581,
 34669083,
 33884533,
 -1,
 -65006,
 34606601,
 100580,
 -65005,
 34672010,
 100579,
 -65004,
 34737380,
 100578,
 -65003,
 34802764,
 100577,
 -65002,
 34868130,
 100576,
 -65001,
 34933510,
 100575,
 -65000,
 34998861,
 100574,
 -64999,
 35064181,
 100573,
 -64998,
 35129561,
 100572,
 -1,
 35194953,
 100571,
 35389990,
 34605273,
 -1,
 -64995,
 35327497,
 100570,
 -64994,
 35392906,
 100569,
 -64993,
 35458276,
 100568,
 -64992,
 35523660,
 100567,
 -64991,
 35589026,
 100566,
 -64990,
 35654406,
 100565,
 -64989,
 35719757,
 100564,
 -64988,
 35785077,
 100563,
 -64987,
 35850457,
 100562,
 -1,
 35915849,
 100561,
 36175871,
 35326025,
 -1,
 -64984,
 36048393,
 100560,
 -64983,
 36113802,
 100559,
 -64982,
 36179172,
 100558,
 -64981,
 36244556,
 100557,
 -64980,
 36309922,
 100556,
 -64979,
 36375302,
 100555,
 -64978,
 36440653,
 100554,
 -64977,
 36505973,
 100553,
 -64976,
 36571353,
 100552,
 -1,
 36636745,
 100551,
 36831904,
 29493465,
 -1,
 36897341,
 36769289,
 -1,
 -64972,
 36834825,
 100550,
 -64971,
 36900234,
 100549,
 -64970,
 36965604,
 100548,
 -64969,
 37030988,
 100547,
 -64968,
 37096354,
 100546,
 -64967,
 37161734,
 100545,
 -64966,
 37227085,
 100544,
 -64965,
 37292405,
 100543,
 -64964,
 37357785,
 100542,
 -1,
 37423177,
 100541,
 37618248,
 36834698,
 -1,
 -64961,
 37555721,
 100540,
 -64960,
 37621130,
 100539,
 -64959,
 37686500,
 100538,
 -64958,
 37751884,
 100537,
 -64957,
 37817250,
 100536,
 -64956,
 37882630,
 100535,
 -64955,
 37947981,
 100534,
 -64954,
 38013301,
 100533,
 -64953,
 38078681,
 100532,
 -1,
 38144073,
 100531,
 38339155,
 37555428,
 -1,
 -64950,
 38276617,
 100530,
 -64949,
 38342026,
 100529,
 -64948,
 38407396,
 100528,
 -64947,
 38472780,
 100527,
 -64946,
 38538146,
 100526,
 -64945,
 38603526,
 100525,
 -64944,
 38668877,
 100524,
 -64943,
 38734197,
 100523,
 -64942,
 38799577,
 100522,
 -1,
 38864969,
 100521,
 39060062,
 38276172,
 -1,
 -64939,
 38997513,
 100520,
 -64938,
 39062922,
 100519,
 -64937,
 39128292,
 100518,
 -64936,
 39193676,
 100517,
 -64935,
 39259042,
 100516,
 -64934,
 39324422,
 100515,
 -64933,
 39389773,
 100514,
 -64932,
 39455093,
 100513,
 -64931,
 39520473,
 100512,
 -1,
 39585865,
 100511,
 39780969,
 38996898,
 -1,
 -64928,
 39718409,
 100510,
 -64927,
 39783818,
 100509,
 -64926,
 39849188,
 100508,
 -64925,
 39914572,
 100507,
 -64924,
 39979938,
 100506,
 -64923,
 40045318,
 100505,
 -64922,
 40110669,
 100504,
 -64921,
 40175989,
 100503,
 -64920,
 40241369,
 100502,
 -1,
 40306761,
 100501,
 40501876,
 39717638,
 -1,
 -64917,
 40439305,
 100500,
 -64916,
 40504714,
 100499,
 -64915,
 40570084,
 100498,
 -64914,
 40635468,
 100497,
 -64913,
 40700834,
 100496,
 -64912,
 40766214,
 100495,
 -64911,
 40831565,
 100494,
 -64910,
 40896885,
 100493,
 -64909,
 40962265,
 100492,
 -1,
 41027657,
 100491,
 41222783,
 40438349,
 -1,
 -64906,
 41160201,
 100490,
 -64905,
 41225610,
 100489,
 -64904,
 41290980,
 100488,
 -64903,
 41356364,
 100487,
 -64902,
 41421730,
 100486,
 -64901,
 41487110,
 100485,
 -64900,
 41552461,
 100484,
 -64899,
 41617781,
 100483,
 -64898,
 41683161,
 100482,
 -1,
 41748553,
 100481,
 41943690,
 41159029,
 -1,
 -64895,
 41881097,
 100480,
 -64894,
 41946506,
 100479,
 -64893,
 42011876,
 100478,
 -64892,
 42077260,
 100477,
 -64891,
 42142626,
 100476,
 -64890,
 42208006,
 100475,
 -64889,
 42273357,
 100474,
 -64888,
 42338677,
 100473,
 -64887,
 42404057,
 100472,
 -1,
 42469449,
 100471,
 42664597,
 41879769,
 -1,
 -64884,
 42601993,
 100470,
 -64883,
 42667402,
 100469,
 -64882,
 42732772,
 100468,
 -64881,
 42798156,
 100467,
 -64880,
 42863522,
 100466,
 -64879,
 42928902,
 100465,
 -64878,
 42994253,
 100464,
 -64877,
 43059573,
 100463,
 -64876,
 43124953,
 100462,
 -1,
 43190345,
 100461,
 43450367,
 42600521,
 -1,
 -64873,
 43322889,
 100460,
 -64872,
 43388298,
 100459,
 -64871,
 43453668,
 100458,
 -64870,
 43519052,
 100457,
 -64869,
 43584418,
 100456,
 -64868,
 43649798,
 100455,
 -64867,
 43715149,
 100454,
 -64866,
 43780469,
 100453,
 -64865,
 43845849,
 100452,
 -1,
 43911241,
 100451,
 44106510,
 36767817,
 -1,
 44171948,
 44043785,
 -1,
 -64861,
 44109321,
 100450,
 -64860,
 44174730,
 100449,
 -64859,
 44240100,
 100448,
 -64858,
 44305484,
 100447,
 -64857,
 44370850,
 100446,
 -64856,
 44436230,
 100445,
 -64855,
 44501581,
 100444,
 -64854,
 44566901,
 100443,
 -64853,
 44632281,
 100442,
 -1,
 44697673,
 100441,
 44892855,
 44109194,
 -1,
 -64850,
 44830217,
 100440,
 -64849,
 44895626,
 100439,
 -64848,
 44960996,
 100438,
 -64847,
 45026380,
 100437,
 -64846,
 45091746,
 100436,
 -64845,
 45157126,
 100435,
 -64844,
 45222477,
 100434,
 -64843,
 45287797,
 100433,
 -64842,
 45353177,
 100432,
 -1,
 45418569,
 100431,
 45613762,
 44829924,
 -1,
 -64839,
 45551113,
 100430,
 -64838,
 45616522,
 100429,
 -64837,
 45681892,
 100428,
 -64836,
 45747276,
 100427,
 -64835,
 45812642,
 100426,
 -64834,
 45878022,
 100425,
 -64833,
 45943373,
 100424,
 -64832,
 46008693,
 100423,
 -64831,
 46074073,
 100422,
 -1,
 46139465,
 100421,
 46334669,
 45550668,
 -1,
 -64828,
 46272009,
 100420,
 -64827,
 46337418,
 100419,
 -64826,
 46402788,
 100418,
 -64825,
 46468172,
 100417,
 -64824,
 46533538,
 100416,
 -64823,
 46598918,
 100415,
 -64822,
 46664269,
 100414,
 -64821,
 46729589,
 100413,
 -64820,
 46794969,
 100412,
 -1,
 46860361,
 100411,
 47055576,
 46271394,
 -1,
 -64817,
 46992905,
 100410,
 -64816,
 47058314,
 100409,
 -64815,
 47123684,
 100408,
 -64814,
 47189068,
 100407,
 -64813,
 47254434,
 100406,
 -64812,
 47319814,
 100405,
 -64811,
 47385165,
 100404,
 -64810,
 47450485,
 100403,
 -64809,
 47515865,
 100402,
 -1,
 47581257,
 100401,
 47776483,
 46992134,
 -1,
 -64806,
 47713801,
 100400,
 -64805,
 47779210,
 100399,
 -64804,
 47844580,
 100398,
 -64803,
 47909964,
 100397,
 -64802,
 47975330,
 100396,
 -64801,
 48040710,
 100395,
 -64800,
 48106061,
 100394,
 -64799,
 48171381,
 100393,
 -64798,
 48236761,
 100392,
 -1,
 48302153,
 100391,
 48497390,
 47712845,
 -1,
 -64795,
 48434697,
 100390,
 -64794,
 48500106,
 100389,
 -64793,
 48565476,
 100388,
 -64792,
 48630860,
 100387,
 -64791,
 48696226,
 100386,
 -64790,
 48761606,
 100385,
 -64789,
 48826957,
 100384,
 -64788,
 48892277,
 100383,
 -64787,
 48957657,
 100382,
 -1,
 49023049,
 100381,
 49218297,
 48433525,
 -1,
 -64784,
 49155593,
 100380,
 -64783,
 49221002,
 100379,
 -64782,
 49286372,
 100378,
 -64781,
 49351756,
 100377,
 -64780,
 49417122,
 100376,
 -64779,
 49482502,
 100375,
 -64778,
 49547853,
 100374,
 -64777,
 49613173,
 100373,
 -64776,
 49678553,
 100372,
 -1,
 49743945,
 100371,
 49939204,
 49154265,
 -1,
 -64773,
 49876489,
 100370,
 -64772,
 49941898,
 100369,
 -64771,
 50007268,
 100368,
 -64770,
 50072652,
 100367,
 -64769,
 50138018,
 100366,
 -64768,
 50203398,
 100365,
 -64767,
 50268749,
 100364,
 -64766,
 50334069,
 100363,
 -64765,
 50399449,
 100362,
 -1,
 50464841,
 100361,
 50724863,
 49875017,
 -1,
 -64762,
 50597385,
 100360,
 -64761,
 50662794,
 100359,
 -64760,
 50728164,
 100358,
 -64759,
 50793548,
 100357,
 -64758,
 50858914,
 100356,
 -64757,
 50924294,
 100355,
 -64756,
 50989645,
 100354,
 -64755,
 51054965,
 100353,
 -1,
 51120345,
 100352,
 51380223,
 44043492,
 -1,
 51381018,
 51251974,
 -1,
 -64751,
 51318281,
 101100,
 -64750,
 51383690,
 101099,
 -64749,
 51449060,
 101098,
 -64748,
 51514444,
 101097,
 -64747,
 51579810,
 101096,
 -64746,
 51645190,
 101095,
 -64745,
 51710541,
 101094,
 -64744,
 51775861,
 101093,
 -64743,
 51841241,
 101092,
 -1,
 51906633,
 101091,
 52101925,
 51317325,
 -1,
 -64740,
 52039177,
 101090,
 -64739,
 52104586,
 101089,
 -64738,
 52169956,
 101088,
 -64737,
 52235340,
 101087,
 -64736,
 52300706,
 101086,
 -64735,
 52366086,
 101085,
 -64734,
 52431437,
 101084,
 -64733,
 52496757,
 101083,
 -64732,
 52562137,
 101082,
 -1,
 52627529,
 101081,
 52822832,
 52038005,
 -1,
 -64729,
 52760073,
 101080,
 -64728,
 52825482,
 101079,
 -64727,
 52890852,
 101078,
 -64726,
 52956236,
 101077,
 -64725,
 53021602,
 101076,
 -64724,
 53086982,
 101075,
 -64723,
 53152333,
 101074,
 -64722,
 53217653,
 101073,
 -64721,
 53283033,
 101072,
 -1,
 53348425,
 101071,
 53543739,
 52758745,
 -1,
 -64718,
 53480969,
 101070,
 -64717,
 53546378,
 101069,
 -64716,
 53611748,
 101068,
 -64715,
 53677132,
 101067,
 -64714,
 53742498,
 101066,
 -64713,
 53807878,
 101065,
 -64712,
 53873229,
 101064,
 -64711,
 53938549,
 101063,
 -64710,
 54003929,
 101062,
 -1,
 54069321,
 101061,
 54264646,
 53479497,
 -1,
 -64707,
 54201865,
 101060,
 -64706,
 54267274,
 101059,
 -64705,
 54332644,
 101058,
 -64704,
 54398028,
 101057,
 -64703,
 54463394,
 101056,
 -64702,
 54528774,
 101055,
 -64701,
 54594125,
 101054,
 -64700,
 54659445,
 101053,
 -64699,
 54724825,
 101052,
 -1,
 54790217,
 101051,
 55050239,
 54201250,
 -1,
 -64696,
 54922146,
 101106,
 -64695,
 54987526,
 101105,
 -64694,
 55052877,
 101104,
 -64693,
 55118197,
 101103,
 -64692,
 55183577,
 101102,
 -1,
 55248969,
 101101,
 -1,
 344655,
 94176,
 -1,
 273686,
 127818,
 -1,
 200450,
 127883,
 55641252,
 152083,
 -1,
 55706763,
 55604654,
 -1,
 55772051,
 55661430,
 -1,
 55837549,
 55726966,
 -1,
 55903073,
 55792502,
 -1,
 55968601,
 55840404,
 -1,
 -64681,
 55934031,
 983852,
 -64680,
 55982748,
 983849,
 -1,
 56037012,
 983842,
 56230747,
 55934031,
 983845,
 -1,
 56196175,
 983846,
 56361821,
 56186814,
 983850,
 -1,
 56317886,
 983851,
 56492895,
 56310428,
 983843,
 -1,
 56441500,
 983844,
 56688639,
 56436759,
 983847,
 -1,
 56567831,
 983848,
 56755045,
 55840404,
 -1,
 -64669,
 56720463,
 983720,
 -64668,
 56769180,
 983717,
 -1,
 56823444,
 983710,
 57017191,
 56720463,
 983713,
 -1,
 56982607,
 983714,
 57148265,
 56973246,
 983718,
 -1,
 57104318,
 983719,
 57279339,
 57096860,
 983711,
 -1,
 57227932,
 983712,
 57475071,
 57223191,
 983715,
 -1,
 57354263,
 983716,
 57541498,
 55806324,
 -1,
 57607026,
 57478804,
 -1,
 -64656,
 57572431,
 983698,
 -64655,
 57621148,
 983695,
 -1,
 57675412,
 983688,
 57869172,
 57572431,
 983691,
 -1,
 57834575,
 983692,
 58000246,
 57825214,
 983696,
 -1,
 57956286,
 983697,
 58131320,
 57948828,
 983689,
 -1,
 58079900,
 983690,
 58327039,
 58075159,
 983693,
 -1,
 58206231,
 983694,
 58393479,
 57488145,
 -1,
 58459007,
 58330772,
 -1,
 -64643,
 58424399,
 983676,
 -64642,
 58473116,
 983673,
 -1,
 58527380,
 983666,
 58721153,
 58424399,
 983669,
 -1,
 58686543,
 983670,
 58852227,
 58677182,
 983674,
 -1,
 58808254,
 983675,
 58983301,
 58800796,
 983667,
 -1,
 58931868,
 983668,
 59179007,
 58927127,
 983671,
 -1,
 59058199,
 983672,
 59245451,
 58330772,
 -1,
 -64631,
 59210831,
 983742,
 -64630,
 59259548,
 983739,
 -1,
 59313812,
 983732,
 59507597,
 59210831,
 983735,
 -1,
 59472975,
 983736,
 59638671,
 59463614,
 983740,
 -1,
 59594686,
 983741,
 59769745,
 59587228,
 983733,
 -1,
 59718300,
 983734,
 59965439,
 59713559,
 983737,
 -1,
 59844631,
 983738,
 60031931,
 55733699,
 -1,
 60097442,
 59979220,
 -1,
 60162969,
 60034708,
 -1,
 -64617,
 60128335,
 983874,
 -64616,
 60177052,
 983871,
 -1,
 60231316,
 983864,
 60425115,
 60128335,
 983867,
 -1,
 60390479,
 983868,
 60556189,
 60381118,
 983872,
 -1,
 60512190,
 983873,
 60687263,
 60504732,
 983865,
 -1,
 60635804,
 983866,
 60818337,
 60631063,
 983869,
 -1,
 60762135,
 983870,
 -1,
 60779242,
 983920,
 61014959,
 60059075,
 -1,
 61080487,
 60952212,
 -1,
 -64603,
 61045839,
 983885,
 -64602,
 61094556,
 983882,
 -1,
 61148820,
 983875,
 61342633,
 61045839,
 983878,
 -1,
 61307983,
 983879,
 61473707,
 61298622,
 983883,
 -1,
 61429694,
 983884,
 61604781,
 61422236,
 983876,
 -1,
 61553308,
 983877,
 61800447,
 61548567,
 983880,
 -1,
 61679639,
 983881,
 61866931,
 60952212,
 -1,
 -64591,
 61832271,
 983896,
 -64590,
 61880988,
 983893,
 -1,
 61935252,
 983886,
 62129077,
 61832271,
 983889,
 -1,
 62094415,
 983890,
 62260151,
 62085054,
 983894,
 -1,
 62216126,
 983895,
 62391225,
 62208668,
 983887,
 -1,
 62339740,
 983888,
 62586879,
 62334999,
 983891,
 -1,
 62466071,
 983892,
 62653410,
 59983396,
 -1,
 62718934,
 62604836,
 -1,
 62784458,
 62670372,
 -1,
 62849986,
 62721684,
 -1,
 -64576,
 62815311,
 983819,
 -64575,
 62864028,
 983816,
 -1,
 62918292,
 983809,
 63112132,
 62815311,
 983812,
 -1,
 63077455,
 983813,
 63243206,
 63068094,
 983817,
 -1,
 63199166,
 983818,
 63374280,
 63191708,
 983810,
 -1,
 63322780,
 983811,
 63569919,
 63318039,
 983814,
 -1,
 63449111,
 983815,
 63636430,
 62721684,
 -1,
 -64564,
 63601743,
 983830,
 -64563,
 63650460,
 983827,
 -1,
 63704724,
 983820,
 63898576,
 63601743,
 983823,
 -1,
 63863887,
 983824,
 64029650,
 63854526,
 983828,
 -1,
 63985598,
 983829,
 64160724,
 63978140,
 983821,
 -1,
 64109212,
 983822,
 64356351,
 64104471,
 983825,
 -1,
 64235543,
 983826,
 64422874,
 62656148,
 -1,
 -64552,
 64388175,
 983797,
 -64551,
 64436892,
 983794,
 -1,
 64491156,
 983787,
 64685020,
 64388175,
 983790,
 -1,
 64650319,
 983791,
 64816094,
 64640958,
 983795,
 -1,
 64772030,
 983796,
 64947168,
 64764572,
 983788,
 -1,
 64895644,
 983789,
 65142783,
 64890903,
 983792,
 -1,
 65021975,
 983793,
 65209340,
 62604334,
 -1,
 65274864,
 65172474,
 -1,
 65340392,
 65212052,
 983908,
 -64538,
 65305679,
 983919,
 -64537,
 65354396,
 983916,
 -1,
 65408660,
 983909,
 65602538,
 65305679,
 983912,
 -1,
 65567823,
 983913,
 65733612,
 65558462,
 983917,
 -1,
 65689534,
 983918,
 65864686,
 65682076,
 983910,
 -1,
 65813148,
 983911,
 66060287,
 65808407,
 983914,
 -1,
 65939479,
 983915,
 66126836,
 65212052,
 -1,
 -64526,
 66092111,
 983665,
 -64525,
 66140828,
 983662,
 -1,
 66195092,
 983655,
 66388982,
 66092111,
 983658,
 -1,
 66354255,
 983659,
 66520056,
 66344894,
 983663,
 -1,
 66475966,
 983664,
 66651130,
 66468508,
 983656,
 -1,
 66599580,
 983657,
 66846719,
 66594839,
 983660,
 -1,
 66725911,
 983661,
 66913302,
 65173003,
 -1,
 66978826,
 66876939,
 -1,
 67044354,
 66915988,
 -1,
 -64512,
 67009615,
 983709,
 -64511,
 67058332,
 983706,
 -1,
 67112596,
 983699,
 67306500,
 67009615,
 983702,
 -1,
 67271759,
 983703,
 67437574,
 67262398,
 983707,
 -1,
 67393470,
 983708,
 67568648,
 67386012,
 983700,
 -1,
 67517084,
 983701,
 67764223,
 67512343,
 983704,
 -1,
 67643415,
 983705,
 67830798,
 66915988,
 -1,
 -64500,
 67796047,
 983731,
 -64499,
 67844764,
 983728,
 -1,
 67899028,
 983721,
 68092944,
 67796047,
 983724,
 -1,
 68058191,
 983725,
 68224018,
 68048830,
 983729,
 -1,
 68179902,
 983730,
 68355092,
 68172444,
 983722,
 -1,
 68303516,
 983723,
 68550655,
 68298775,
 983726,
 -1,
 68429847,
 983727,
 68617264,
 66872697,
 -1,
 68682788,
 68576633,
 -1,
 68748316,
 68619924,
 -1,
 -64486,
 68713551,
 983841,
 -64485,
 68762268,
 983838,
 -1,
 68816532,
 983831,
 69010462,
 68713551,
 983834,
 -1,
 68975695,
 983835,
 69141536,
 68966334,
 983839,
 -1,
 69097406,
 983840,
 69272610,
 69089948,
 983832,
 -1,
 69221020,
 983833,
 69468159,
 69216279,
 983836,
 -1,
 69347351,
 983837,
 69534760,
 68619924,
 -1,
 -64474,
 69499983,
 983786,
 -64473,
 69548700,
 983783,
 -1,
 69602964,
 983776,
 69796906,
 69499983,
 983779,
 -1,
 69762127,
 983780,
 69927980,
 69752766,
 983784,
 -1,
 69883838,
 983785,
 70059054,
 69876380,
 983777,
 -1,
 70007452,
 983778,
 70254591,
 70002711,
 983781,
 -1,
 70133783,
 983782,
 70321213,
 68585844,
 -1,
 70386741,
 70258324,
 -1,
 -64461,
 70351951,
 983775,
 -64460,
 70400668,
 983772,
 -1,
 70454932,
 983765,
 70648887,
 70351951,
 983768,
 -1,
 70614095,
 983769,
 70779961,
 70604734,
 983773,
 -1,
 70735806,
 983774,
 70911035,
 70728348,
 983766,
 -1,
 70859420,
 983767,
 71106559,
 70854679,
 983770,
 -1,
 70985751,
 983771,
 71173194,
 70287798,
 -1,
 71238722,
 71110292,
 -1,
 -64448,
 71203919,
 983808,
 -64447,
 71252636,
 983805,
 -1,
 71306900,
 983798,
 71500868,
 71203919,
 983801,
 -1,
 71466063,
 983802,
 71631942,
 71456702,
 983806,
 -1,
 71587774,
 983807,
 71763016,
 71580316,
 983799,
 -1,
 71711388,
 983800,
 71958527,
 71706647,
 983803,
 -1,
 71837719,
 983804,
 72025175,
 71131034,
 -1,
 72090703,
 71962260,
 -1,
 -64435,
 72055887,
 983753,
 -64434,
 72104604,
 983750,
 -1,
 72158868,
 983743,
 72352849,
 72055887,
 983746,
 -1,
 72318031,
 983747,
 72483923,
 72308670,
 983751,
 -1,
 72439742,
 983752,
 72614997,
 72432284,
 983744,
 -1,
 72563356,
 983745,
 72810495,
 72558615,
 983748,
 -1,
 72689687,
 983749,
 72877156,
 71978669,
 -1,
 72942684,
 72814228,
 -1,
 -64422,
 72907855,
 983764,
 -64421,
 72956572,
 983761,
 -1,
 73010836,
 983754,
 73204830,
 72907855,
 983757,
 -1,
 73169999,
 983758,
 73335904,
 73160638,
 983762,
 -1,
 73291710,
 983763,
 73466978,
 73284252,
 983755,
 -1,
 73415324,
 983756,
 73662463,
 73410583,
 983759,
 -1,
 73541655,
 983760,
 73729137,
 72827759,
 -1,
 73794665,
 73666196,
 -1,
 -64409,
 73759823,
 983863,
 -64408,
 73808540,
 983860,
 -1,
 73862804,
 983853,
 74056811,
 73759823,
 983856,
 -1,
 74021967,
 983857,
 74187885,
 74012606,
 983861,
 -1,
 74143678,
 983862,
 74318959,
 74136220,
 983854,
 -1,
 74267292,
 983855,
 74514431,
 74262551,
 983858,
 -1,
 74393623,
 983859,
 74581118,
 73676244,
 -1,
 74646646,
 74518164,
 -1,
 -64396,
 74611791,
 983907,
 -64395,
 74660508,
 983904,
 -1,
 74714772,
 983897,
 74908792,
 74611791,
 983900,
 -1,
 74873935,
 983901,
 75039866,
 74864574,
 983905,
 -1,
 74995646,
 983906,
 75170940,
 74988188,
 983898,
 -1,
 75119260,
 983899,
 75366399,
 75114519,
 983902,
 -1,
 75245591,
 983903,
 75497471,
 74521411,
 -1,
 75498627,
 75370132,
 -1,
 -64383,
 75463759,
 983687,
 -64382,
 75512476,
 983684,
 -1,
 75566740,
 983677,
 75760773,
 75463759,
 983680,
 -1,
 75725903,
 983681,
 75891847,
 75716542,
 983685,
 -1,
 75847614,
 983686,
 76022921,
 75840156,
 983678,
 -1,
 75971228,
 983679,
 76218367,
 75966487,
 983682,
 -1,
 76097559,
 983683,
 76349439,
 55648250,
 -1,
 76350609,
 76239734,
 983638,
 76416143,
 76305270,
 983636,
 -1,
 76370806,
 983648,
 -64368,
 76384628,
 983634,
 -1,
 76493585,
 983632,
 76678292,
 76312003,
 983652,
 -64365,
 76639683,
 983651,
 -1,
 76690900,
 983650,
 76874903,
 76629540,
 983643,
 77004799,
 76826148,
 983646,
 -1,
 76891684,
 983645,
 77071513,
 76838411,
 983637,
 -1,
 77035019,
 983635,
 77202587,
 77030777,
 983642,
 -1,
 77161849,
 983647,
 77333661,
 77153326,
 983631,
 -1,
 77296634,
 983654,
 -64354,
 77302132,
 983641,
 -64353,
 77431222,
 983644,
 -64352,
 77488026,
 983639,
 -64351,
 77549229,
 983640,
 -64350,
 77611887,
 983649,
 -64349,
 77673940,
 983653,
 -1,
 77732675,
 983633,
 77923581,
 55592399,
 -1,
 77989086,
 77875867,
 -1,
 78054572,
 77952523,
 -1,
 78120106,
 78018059,
 -1,
 -64343,
 78067170,
 71317,
 -1,
 78122644,
 71316,
 -64341,
 78067170,
 71322,
 -1,
 78253716,
 71321,
 78447793,
 78009206,
 -1,
 -64338,
 78416320,
 71315,
 -64337,
 78468066,
 71320,
 -64336,
 78525239,
 71310,
 -1,
 78581396,
 71325,
 78775479,
 78389904,
 -1,
 78841013,
 78717584,
 -1,
 -64332,
 78788066,
 71319,
 -1,
 78843540,
 71318,
 -64330,
 78788066,
 71324,
 -1,
 78974612,
 71323,
 79168699,
 78712468,
 71296,
 -64327,
 79133775,
 71305,
 -64326,
 79182492,
 71303,
 -1,
 79236756,
 71297,
 79430845,
 79133775,
 71300,
 -1,
 79395919,
 71301,
 79561920,
 79392195,
 -1,
 -64321,
 79508962,
 71335,
 -1,
 79564436,
 71336,
 79758531,
 79521145,
 -1,
 -64318,
 79717837,
 71338,
 -1,
 79761044,
 71332,
 79955142,
 79716250,
 -1,
 -64315,
 79902178,
 71327,
 -1,
 79957652,
 71326,
 80151753,
 79905838,
 -1,
 -64312,
 80098786,
 71307,
 -1,
 80154260,
 71306,
 80348364,
 80102255,
 -1,
 -64309,
 80295394,
 71314,
 -1,
 80350868,
 71313,
 80544974,
 80296604,
 71298,
 -1,
 80493212,
 71299,
 80676049,
 80491281,
 -1,
 -64304,
 80623074,
 71309,
 -1,
 80678548,
 71308,
 80872660,
 80616259,
 -1,
 -64301,
 80819682,
 71312,
 -1,
 80875156,
 71311,
 81069271,
 80811698,
 -1,
 -64298,
 81016290,
 71329,
 -1,
 81071764,
 71328,
 -64296,
 81037760,
 71331,
 -64295,
 81232328,
 71334,
 -64294,
 81287102,
 71304,
 -64293,
 81350390,
 71330,
 -64292,
 81413742,
 71333,
 -64291,
 81475042,
 71337,
 -1,
 81537047,
 71302,
 81724652,
 77931738,
 -1,
 81790178,
 81688075,
 -1,
 -64287,
 81758164,
 71362,
 -1,
 81803696,
 71363,
 81986789,
 81751491,
 -1,
 -64284,
 81937156,
 71366,
 -1,
 81997407,
 71367,
 82183400,
 81932076,
 -1,
 -64281,
 82140635,
 71364,
 -1,
 82199142,
 71365,
 -64279,
 82152305,
 71360,
 -64278,
 82336294,
 71361,
 -64277,
 82400617,
 71369,
 -1,
 82455143,
 71368,
 82642167,
 81691656,
 -1,
 82707697,
 82579092,
 -1,
 -64273,
 82672719,
 71349,
 -64272,
 82721436,
 71347,
 -1,
 82775700,
 71341,
 82969843,
 82672719,
 71344,
 -1,
 82934863,
 71345,
 83100917,
 82918044,
 71342,
 -1,
 83049116,
 71343,
 -64266,
 83056574,
 71348,
 -1,
 83175447,
 71346,
 83427327,
 82604423,
 -1,
 83428603,
 83329857,
 -1,
 -64262,
 83390119,
 71340,
 -1,
 83453584,
 71350,
 -64260,
 83384147,
 71351,
 -1,
 83563382,
 71339,
 83756287,
 77862578,
 983061,
 -1,
 83707970,
 127955,
 -64256,
 83724585,
 128661,
 -64255,
 83845355,
 128429,
 -1,
 83894066,
 127790,
 84084104,
 80540,
 -1,
 84149619,
 84043129,
 -1,
 84215154,
 84097653,
 -1,
 84280643,
 84167323,
 -1,
 84346125,
 84246966,
 -1,
 84411660,
 84301840,
 -1,
 84477194,
 84370809,
 70791,
 -1,
 84436345,
 70792,
 84672511,
 84428324,
 70793,
 -1,
 84559396,
 70794,
 -1,
 84348564,
 70827,
 84804883,
 84309515,
 -1,
 84870417,
 84768267,
 -1,
 -64240,
 84817378,
 70810,
 -1,
 84872852,
 70809,
 -64238,
 84817378,
 70815,
 -1,
 85003924,
 70814,
 85198104,
 84759414,
 -1,
 -64235,
 85166528,
 70808,
 -64234,
 85218274,
 70813,
 -64233,
 85275447,
 70803,
 -1,
 85331604,
 70818,
 85525790,
 85140112,
 -1,
 85591324,
 85467792,
 -1,
 -64229,
 85538274,
 70812,
 -1,
 85593748,
 70811,
 -64227,
 85538274,
 70817,
 -1,
 85724820,
 70816,
 85919010,
 85462676,
 70785,
 -64224,
 85883983,
 70798,
 -64223,
 85932700,
 70796,
 -1,
 85986964,
 70786,
 86181158,
 85880259,
 -1,
 -64220,
 86142504,
 70829,
 -64219,
 86193634,
 70828,
 -1,
 86249108,
 70830,
 86443304,
 86146127,
 70789,
 -1,
 86408271,
 70790,
 86574379,
 86400922,
 -1,
 -64214,
 86521314,
 70820,
 -1,
 86576788,
 70819,
 86770990,
 86524974,
 -1,
 -64211,
 86717922,
 70800,
 -1,
 86773396,
 70799,
 86967601,
 86721391,
 -1,
 -64208,
 86914530,
 70807,
 -1,
 86970004,
 70806,
 87164211,
 86915740,
 70787,
 -1,
 87112348,
 70788,
 87295286,
 87110417,
 -1,
 -64203,
 87242210,
 70802,
 -1,
 87297684,
 70801,
 87491897,
 87235395,
 -1,
 -64200,
 87438818,
 70805,
 -1,
 87494292,
 70804,
 87688508,
 87430834,
 -1,
 -64197,
 87635426,
 70822,
 -1,
 87690900,
 70821,
 -64195,
 87656896,
 70824,
 -64194,
 87844301,
 70825,
 -64193,
 87906238,
 70797,
 -64192,
 87969526,
 70823,
 -64191,
 88032878,
 70826,
 -64190,
 88094178,
 70831,
 -1,
 88156183,
 70795,
 88343894,
 84247560,
 -1,
 88409417,
 88310679,
 -1,
 88474951,
 88368505,
 70837,
 -1,
 88434041,
 70838,
 88670207,
 88426020,
 70839,
 -1,
 88557092,
 70840,
 88737101,
 88346260,
 -1,
 -64181,
 88702031,
 70846,
 -64180,
 88750748,
 70843,
 -1,
 88805012,
 70832,
 88999247,
 88702031,
 70835,
 -1,
 88964175,
 70836,
 89130322,
 88961271,
 -1,
 -64175,
 89085886,
 70845,
 -1,
 89139223,
 70842,
 89326932,
 89078428,
 70833,
 -1,
 89275036,
 70834,
 -64171,
 89282494,
 70844,
 -1,
 89401367,
 70841,
 89589092,
 88286426,
 -1,
 89654618,
 89552395,
 -1,
 -64167,
 89622484,
 70866,
 -1,
 89668016,
 70867,
 89851229,
 89615811,
 -1,
 -64164,
 89801476,
 70870,
 -1,
 89861727,
 70871,
 90047840,
 89796396,
 -1,
 -64161,
 90004955,
 70868,
 -1,
 90063462,
 70869,
 -64159,
 90016625,
 70864,
 -64158,
 90200614,
 70865,
 -64157,
 90264937,
 70873,
 -1,
 90319463,
 70872,
 90506605,
 89551239,
 -1,
 90572136,
 90473281,
 -1,
 -64153,
 90533543,
 70849,
 -1,
 90597008,
 70850,
 90768747,
 90508948,
 -1,
 -64150,
 90735051,
 70852,
 -1,
 90789782,
 70848,
 -64148,
 90724179,
 70851,
 -1,
 90905542,
 70847,
 91096432,
 90443412,
 -1,
 -64145,
 91051471,
 70784,
 -1,
 91101072,
 70854,
 -64143,
 91052395,
 70855,
 -1,
 91239878,
 70853,
 -1,
 84158806,
 128555,
 91489662,
 84088851,
 -1,
 91555194,
 91450819,
 -1,
 91620729,
 91520291,
 -1,
 -64137,
 91574315,
 3982,
 -64136,
 91637728,
 3981,
 -1,
 91701412,
 3983,
 -1,
 91569413,
 3980,
 92012543,
 91508652,
 -1,
 -64132,
 91912778,
 4058,
 -64131,
 91965577,
 4057,
 -1,
 92018912,
 983208,
 92210564,
 91435049,
 -1,
 92276098,
 92162810,
 -1,
 -64127,
 92231614,
 11623,
 -1,
 92284951,
 11622,
 -64125,
 92237693,
 11632,
 -1,
 92413957,
 11647,
 92603782,
 92156965,
 128005,
 -1,
 92537305,
 128047,
 -64121,
 92557630,
 9202,
 -1,
 92675788,
 127915,
 92865960,
 84030932,
 -1,
 92931484,
 92825605,
 -1,
 92997012,
 92864512,
 -1,
 93062544,
 92956407,
 -1,
 -64115,
 93022513,
 128487,
 -64114,
 93079753,
 128486,
 -64113,
 93132771,
 128485,
 -1,
 93196088,
 128484,
 -64111,
 93025181,
 128491,
 -64110,
 93348492,
 128962,
 -64109,
 93410512,
 128423,
 -1,
 93461299,
 128433,
 93716479,
 92932001,
 -1,
 93717915,
 93594258,
 -1,
 93783449,
 93682123,
 -1,
 -64104,
 93743817,
 11162,
 -1,
 93800971,
 11160,
 -64102,
 93743647,
 11161,
 -1,
 93931878,
 11163,
 -1,
 93661981,
 11835,
 94176675,
 92879516,
 -1,
 94242210,
 94131062,
 -1,
 94307745,
 94175232,
 -1,
 -64096,
 94269039,
 128936,
 -1,
 94319987,
 128929,
 -1,
 94258534,
 129300,
 -1,
 94201663,
 129353,
 94635430,
 94142120,
 -1,
 -64091,
 94601068,
 128077,
 -1,
 94643960,
 128078,
 -64089,
 94592433,
 128173,
 -1,
 94776604,
 127777,
 94963137,
 92830799,
 -1,
 95028671,
 94922105,
 -1,
 95094203,
 94983306,
 -1,
 95159728,
 95055299,
 -1,
 95225263,
 95116950,
 -1,
 -64082,
 95192478,
 128597,
 -1,
 95234280,
 128599,
 -1,
 95169336,
 11829,
 95487413,
 95101584,
 -1,
 95552948,
 95436025,
 -1,
 -64077,
 95520724,
 8586,
 -1,
 95566256,
 8587,
 -1,
 95490241,
 11832,
 95815096,
 95442535,
 -1,
 -64073,
 95782302,
 128596,
 -1,
 95824104,
 128598,
 -64071,
 95770865,
 128399,
 -64070,
 95952778,
 11826,
 -1,
 96016702,
 11202,
 96208318,
 95044654,
 -1,
 -64067,
 96158115,
 8378,
 -1,
 96218917,
 129411,
 -1,
 96172386,
 128034,
 -64064,
 94982140,
 129347,
 -1,
 96423007,
 127799,
 96601560,
 94922105,
 -1,
 96667081,
 96538260,
 -1,
 96732613,
 96620205,
 128650,
 -1,
 96665920,
 128651,
 96863688,
 96672579,
 -1,
 -64057,
 96827864,
 128668,
 -1,
 96879869,
 128434,
 -1,
 96812500,
 128646,
 97125840,
 96622526,
 -1,
 97191375,
 97083290,
 -1,
 97256910,
 97139604,
 -1,
 -64051,
 97202328,
 128032,
 -1,
 97265589,
 127865,
 -1,
 97204882,
 127942,
 -1,
 97143997,
 128654,
 97584599,
 97073820,
 -1,
 97650134,
 97522384,
 -1,
 97715669,
 97615450,
 -1,
 -64044,
 97676716,
 128208,
 -1,
 97726678,
 128681,
 -1,
 97667185,
 128710,
 -1,
 97592330,
 128305,
 -1,
 97549998,
 127930,
 98108906,
 96544791,
 -1,
 98174438,
 98059812,
 -1,
 98239969,
 98117655,
 -1,
 98305503,
 98197925,
 -1,
 98371038,
 98264991,
 128222,
 -1,
 98305776,
 128380,
 -1,
 98327018,
 128384,
 -64032,
 98272123,
 128250,
 -1,
 98528970,
 128301,
 98762751,
 98205208,
 -1,
 98764261,
 98650779,
 -1,
 -64028,
 98725203,
 3162,
 -1,
 98782446,
 3124,
 -1,
 98726285,
 3072,
 99026409,
 98111124,
 -1,
 -64024,
 98985392,
 128198,
 -1,
 99033624,
 127861,
 -1,
 98981370,
 127934,
 99288566,
 98064318,
 -1,
 99354098,
 99245980,
 -1,
 99419633,
 99300834,
 -1,
 99485168,
 99371843,
 -1,
 -64017,
 99446525,
 11833,
 -1,
 99490046,
 11210,
 -1,
 99448331,
 127913,
 -1,
 99387205,
 128285,
 -64013,
 99308869,
 128069,
 -64012,
 99766244,
 127813,
 -64011,
 99829274,
 128508,
 -1,
 99892622,
 128701,
 100075008,
 99255337,
 -1,
 100140543,
 100030398,
 -1,
 100206078,
 100073472,
 -1,
 -64006,
 100173891,
 128109,
 -64005,
 100234141,
 128490,
 -64004,
 100290828,
 128108,
 -64003,
 100349867,
 128149,
 -1,
 100408115,
 128432,
 -1,
 100140991,
 11834,
 -1,
 100090356,
 128256,
 -1,
 100010042,
 128085,
 100797621,
 28099,
 -1,
 100862631,
 100743836,
 983080,
 100927966,
 100807958,
 -1,
 100993501,
 100894889,
 -1,
 101058427,
 100939220,
 -1,
 101123950,
 100994708,
 -1,
 101189485,
 101078078,
 -1,
 101254870,
 101134124,
 -1,
 101320370,
 101204464,
 121091,
 101449727,
 101253120,
 -1,
 101451369,
 101334585,
 120832,
 101580799,
 101384192,
 -1,
 101582395,
 101470602,
 120846,
 101711871,
 101515264,
 -1,
 101713442,
 101587779,
 -1,
 101778974,
 101669582,
 120853,
 101908479,
 101711872,
 -1,
 101910040,
 101808222,
 -1,
 101975575,
 101871954,
 120877,
 102105087,
 101908480,
 -1,
 -63978,
 101982192,
 120878,
 -1,
 102045673,
 120879,
 -1,
 101921190,
 120884,
 102303258,
 101857482,
 120857,
 -1,
 102237415,
 120882,
 102434332,
 102244907,
 120856,
 -1,
 102368453,
 120885,
 -63971,
 102388121,
 120855,
 -1,
 102514246,
 120854,
 102760447,
 101739707,
 -1,
 102762017,
 102639946,
 120858,
 -1,
 102696167,
 120883,
 -1,
 102695532,
 121001,
 102958638,
 101677144,
 120862,
 103088127,
 102891520,
 -1,
 103089704,
 102964035,
 -1,
 -63962,
 103055299,
 120872,
 -63961,
 103111383,
 120893,
 -1,
 103170357,
 120873,
 103351851,
 103036372,
 -1,
 -63958,
 103308093,
 120874,
 -1,
 103366585,
 120875,
 103548461,
 103289609,
 120895,
 -1,
 103482178,
 120894,
 -1,
 103487465,
 120866,
 103745076,
 102917497,
 -1,
 103810611,
 103694048,
 120966,
 103940095,
 103743488,
 -1,
 -63950,
 103817200,
 120972,
 -1,
 103880681,
 120971,
 -1,
 103747889,
 120849,
 104138294,
 103692490,
 120850,
 -1,
 104072298,
 120867,
 104269368,
 104077289,
 120848,
 -1,
 104203507,
 120865,
 -63943,
 104234868,
 120871,
 -63942,
 104363248,
 120864,
 -1,
 104418420,
 120996,
 104597082,
 101546078,
 -1,
 104662598,
 104558930,
 121052,
 104792063,
 104595456,
 -1,
 104793666,
 104691806,
 -1,
 -63936,
 104735892,
 121054,
 -63935,
 104800240,
 121055,
 -1,
 104863721,
 121056,
 105055813,
 104742463,
 -1,
 -63932,
 105003197,
 121059,
 -1,
 105060329,
 121057,
 -1,
 104995383,
 121058,
 105317968,
 104602435,
 -1,
 105383502,
 105282639,
 -1,
 105449037,
 105342329,
 -1,
 105514572,
 105415180,
 -1,
 -63925,
 105479889,
 121066,
 -1,
 105529367,
 121064,
 -1,
 105466770,
 121063,
 -1,
 105407321,
 120887,
 105906175,
 105333022,
 121067,
 -1,
 105784003,
 120892,
 105973332,
 105265468,
 121062,
 106102783,
 105916775,
 -1,
 -63917,
 106004228,
 120881,
 -1,
 106051786,
 120899,
 106235479,
 105918894,
 -1,
 -63914,
 106198202,
 121060,
 -1,
 106239977,
 121061,
 106495999,
 106173200,
 -1,
 -63911,
 106389118,
 120890,
 -1,
 106446299,
 120891,
 106628703,
 104544458,
 120843,
 106758143,
 106561536,
 -1,
 106759774,
 106648068,
 120852,
 -1,
 106693863,
 120870,
 -1,
 106712447,
 120844,
 106956387,
 106594059,
 120851,
 107085823,
 106890429,
 -1,
 -63902,
 106983762,
 120868,
 -1,
 107028464,
 120869,
 107218534,
 106915193,
 -1,
 -63899,
 107167551,
 121018,
 -1,
 107221283,
 120841,
 107415144,
 107157481,
 120838,
 -1,
 107348807,
 120861,
 -1,
 107356715,
 120842,
 107611776,
 101415000,
 121077,
 107741183,
 107544576,
 -1,
 107742834,
 107642583,
 -1,
 107808367,
 107705867,
 -1,
 -63890,
 107775968,
 121086,
 -1,
 107821511,
 121088,
 -63888,
 107760771,
 120979,
 -63887,
 107953734,
 120840,
 -1,
 108016148,
 121089,
 108201591,
 107681831,
 -1,
 108267125,
 108150353,
 121083,
 -1,
 108201091,
 120876,
 -63882,
 108227366,
 121085,
 -1,
 108351909,
 121084,
 108529275,
 108163415,
 -1,
 -63879,
 108471444,
 121079,
 -63878,
 108535792,
 121080,
 -1,
 108599273,
 121081,
 108791422,
 108486316,
 -1,
 -63875,
 108756001,
 121087,
 -1,
 108802644,
 121090,
 -63873,
 108738541,
 121078,
 -1,
 108933542,
 121082,
 109119126,
 107565457,
 -1,
 109184654,
 109082718,
 -1,
 109250183,
 109124419,
 -1,
 109315718,
 109199676,
 -1,
 -63867,
 109281028,
 120888,
 -1,
 109328586,
 120889,
 -1,
 109281225,
 120886,
 109577868,
 109187856,
 -1,
 109643403,
 109534835,
 -1,
 -63862,
 109608708,
 120896,
 -1,
 109650330,
 120897,
 -1,
 109592246,
 120898,
 -63859,
 109530228,
 121035,
 -1,
 109852993,
 120880,
 110036624,
 109149956,
 121030,
 -1,
 109970663,
 121033,
 110167699,
 109995385,
 -1,
 -63854,
 110116671,
 121037,
 -1,
 110170403,
 121032,
 -63852,
 110120052,
 121036,
 -63851,
 110306974,
 121028,
 -1,
 110368750,
 120860,
 110560933,
 109071483,
 -1,
 110626461,
 110503582,
 120974,
 110755839,
 110559232,
 -1,
 110757532,
 110652302,
 -1,
 -63845,
 110720186,
 120975,
 -1,
 110764643,
 120976,
 -1,
 110714091,
 120977,
 111019680,
 110589451,
 -1,
 -63841,
 110976401,
 120985,
 -1,
 111032900,
 120986,
 111216290,
 110968377,
 120992,
 -1,
 111150262,
 120988,
 -63837,
 111181572,
 120978,
 -63836,
 111306314,
 120983,
 -1,
 111351785,
 120984,
 111543984,
 110521109,
 -1,
 111609514,
 111497610,
 121012,
 111738879,
 111542272,
 -1,
 -63831,
 111634009,
 121014,
 -1,
 111681520,
 121013,
 -63829,
 111574788,
 121006,
 -63828,
 111835224,
 121016,
 -63827,
 111896138,
 121007,
 -63826,
 111955060,
 121008,
 -63825,
 112016953,
 121015,
 -1,
 112076446,
 121003,
 -63823,
 111491053,
 121092,
 -1,
 112210488,
 120906,
 112459775,
 101271452,
 120922,
 112525311,
 112328704,
 -1,
 112527044,
 112406316,
 -1,
 112592574,
 112476783,
 120908,
 112721919,
 112525312,
 -1,
 112723643,
 112605386,
 120919,
 112852991,
 112656384,
 -1,
 -63814,
 112752755,
 120920,
 -1,
 112809509,
 120921,
 -63812,
 112687205,
 120914,
 -63811,
 112931295,
 120910,
 -1,
 112990185,
 120912,
 113246207,
 112549343,
 120900,
 113311743,
 113115136,
 -1,
 113313474,
 113188848,
 120903,
 -1,
 113247331,
 120904,
 -63805,
 113260746,
 120902,
 -1,
 113383401,
 120901,
 113575626,
 112489413,
 -1,
 113641160,
 113515729,
 120930,
 113770495,
 113575143,
 120931,
 -1,
 113639655,
 120932,
 -63799,
 113593460,
 120933,
 -1,
 113786533,
 120929,
 113968849,
 113522669,
 120924,
 114098175,
 113901568,
 -1,
 114099920,
 113979565,
 120909,
 114229247,
 114032640,
 -1,
 -63793,
 114110943,
 120911,
 -1,
 114169833,
 120913,
 -1,
 114063475,
 120926,
 114427605,
 113932382,
 -1,
 -63789,
 114389330,
 120925,
 -63788,
 114438566,
 120928,
 -1,
 114497513,
 120927,
 -1,
 114366545,
 120923,
 114755346,
 101194563,
 -1,
 114820849,
 114719823,
 -1,
 114886380,
 114778010,
 120941,
 115015679,
 114819072,
 -1,
 115017440,
 114908069,
 120940,
 115146751,
 114950144,
 -1,
 115148511,
 115046494,
 -1,
 -63778,
 115110226,
 120942,
 -1,
 115159462,
 120946,
 -1,
 115103269,
 120944,
 115410661,
 114966073,
 120834,
 115539967,
 115343360,
 -1,
 115541732,
 115439704,
 121068,
 -1,
 115475247,
 121069,
 -1,
 115501862,
 121024,
 115738344,
 115374174,
 -1,
 -63769,
 115700050,
 120943,
 -1,
 115749286,
 120947,
 115934954,
 115683501,
 120915,
 -1,
 115868463,
 120916,
 -63765,
 115889701,
 120945,
 -1,
 116019633,
 121040,
 116260863,
 114846789,
 120949,
 116326399,
 116129792,
 -1,
 -63761,
 116218789,
 120948,
 -63760,
 116281825,
 121039,
 -1,
 116342385,
 121020,
 116524808,
 114770206,
 120950,
 116654079,
 116457472,
 -1,
 116655872,
 116538937,
 120833,
 116785151,
 116588544,
 -1,
 116786941,
 116674954,
 120847,
 116916223,
 116719616,
 -1,
 116918010,
 116793724,
 -1,
 -63751,
 116861258,
 120859,
 -1,
 116916844,
 121002,
 -63749,
 116881496,
 120863,
 -63748,
 117074704,
 120967,
 -1,
 117132404,
 120997,
 -63746,
 116747046,
 121019,
 -63745,
 117258429,
 120845,
 -1,
 117315561,
 120839,
 117507844,
 116609425,
 -1,
 117573379,
 117467942,
 121038,
 -1,
 117506279,
 121045,
 -1,
 117538564,
 121031,
 117769991,
 117460091,
 -1,
 -63738,
 117735172,
 120980,
 -1,
 117784121,
 120993,
 -1,
 117730086,
 121009,
 118095871,
 116475859,
 120934,
 118161407,
 117964800,
 -1,
 118163213,
 118061150,
 -1,
 -63732,
 118124882,
 120935,
 -1,
 118174118,
 120937,
 118359823,
 118116804,
 121046,
 -1,
 118293570,
 121047,
 -63728,
 118314533,
 120936,
 -63727,
 118439558,
 121065,
 -1,
 118501921,
 120905,
 118687562,
 114701780,
 -1,
 118753084,
 118636468,
 120957,
 118882303,
 118685696,
 -1,
 118884132,
 118767161,
 120836,
 119013375,
 118816768,
 -1,
 119015198,
 118913112,
 121072,
 119144447,
 118947840,
 -1,
 119146268,
 119041475,
 -1,
 -63717,
 119099206,
 121073,
 -1,
 119159794,
 121053,
 -63715,
 119102373,
 121070,
 -1,
 119293731,
 121071,
 119473954,
 118968721,
 -1,
 119539489,
 119434000,
 120968,
 -1,
 119472494,
 120973,
 -1,
 119491700,
 120998,
 -63709,
 119434022,
 121025,
 -1,
 119683274,
 121051,
 119867178,
 118840229,
 120955,
 119996415,
 119799808,
 -1,
 119998249,
 119896158,
 -1,
 -63704,
 119959890,
 120959,
 -1,
 120009126,
 120956,
 -1,
 119952933,
 120961,
 120260399,
 119819380,
 120970,
 120389631,
 120193024,
 -1,
 120391470,
 120274489,
 120994,
 -1,
 120325302,
 120989,
 -1,
 120354904,
 120987,
 120588083,
 120223838,
 -1,
 120653618,
 120549714,
 120960,
 -1,
 120587577,
 120963,
 -1,
 120592445,
 120964,
 120850229,
 120548112,
 120999,
 -1,
 120783276,
 121004,
 120981303,
 120803722,
 121029,
 -1,
 120914965,
 121041,
 121112378,
 120925996,
 -1,
 -63687,
 121069035,
 120907,
 -1,
 121127554,
 120917,
 -63685,
 121074261,
 120958,
 -1,
 121263653,
 120962,
 121503743,
 118709049,
 120939,
 121569279,
 121372672,
 -1,
 121571140,
 121459089,
 -1,
 121636675,
 121531186,
 121050,
 121765887,
 121569280,
 -1,
 -63678,
 121658980,
 121048,
 -1,
 121716180,
 121049,
 -1,
 121600088,
 121034,
 121964360,
 121519710,
 -1,
 -63674,
 121929425,
 121023,
 -63673,
 121986660,
 121021,
 -1,
 122043860,
 121022,
 -63671,
 121924439,
 121017,
 -1,
 122167858,
 120938,
 122357603,
 118625027,
 120965,
 122486783,
 122290176,
 -1,
 122488663,
 122371641,
 120837,
 122617855,
 122421248,
 -1,
 122619730,
 122517592,
 121076,
 122748927,
 122552320,
 -1,
 -63663,
 122642020,
 121074,
 -1,
 122699220,
 121075,
 122881876,
 122579750,
 121027,
 -1,
 122815298,
 121026,
 123076607,
 122835345,
 -1,
 -63658,
 122972944,
 120969,
 -1,
 123030644,
 121000,
 123209564,
 122440827,
 -1,
 123275099,
 123158073,
 120995,
 123404287,
 123208916,
 120991,
 -1,
 123274050,
 120990,
 -1,
 123240196,
 120982,
 123537248,
 123163057,
 121044,
 123666431,
 123469824,
 -1,
 -63649,
 123559524,
 121042,
 -1,
 123616724,
 121043,
 123863039,
 123497237,
 -1,
 -63646,
 123751540,
 121011,
 -1,
 123807401,
 121005,
 124059647,
 122314407,
 120951,
 124125183,
 123928576,
 -1,
 124127080,
 124024926,
 -1,
 -63641,
 124088658,
 120952,
 -1,
 124137894,
 120954,
 -63639,
 124087078,
 121010,
 -63638,
 124278309,
 120953,
 -63637,
 124341379,
 120981,
 -63636,
 124403257,
 120835,
 -1,
 124465325,
 120918,
 -1,
 101138699,
 121451,
 124780543,
 101066906,
 121343,
 124846079,
 124649472,
 -1,
 124847994,
 124736221,
 -1,
 124913529,
 124782497,
 -1,
 124979062,
 124879954,
 -1,
 -63628,
 124942569,
 121346,
 -63627,
 125007034,
 121345,
 -1,
 125051478,
 121348,
 125304831,
 124924174,
 -1,
 -63624,
 125203642,
 121347,
 -1,
 125248086,
 121349,
 -1,
 124846438,
 121350,
 -1,
 124807941,
 121344,
 125569205,
 101012097,
 -1,
 125634703,
 125534783,
 -1,
 125700086,
 125600850,
 -1,
 125765537,
 125639491,
 -1,
 125831063,
 125731072,
 -1,
 125896596,
 125763584,
 -1,
 125962122,
 125842900,
 -1,
 126027655,
 125899180,
 -1,
 126093189,
 125978403,
 121230,
 -1,
 126055463,
 121231,
 -63610,
 126054997,
 121228,
 -1,
 126177375,
 121229,
 126418943,
 125977182,
 -1,
 -63607,
 126300846,
 121254,
 -1,
 126360998,
 121261,
 126551951,
 125920499,
 -1,
 126617485,
 126502691,
 121226,
 -1,
 126579751,
 121227,
 -63602,
 126579285,
 121224,
 -1,
 126701663,
 121225,
 126943231,
 126515068,
 -1,
 126945171,
 126838828,
 -1,
 -63598,
 126906965,
 121232,
 -1,
 126963807,
 121233,
 -1,
 126888798,
 121247,
 127270911,
 125838010,
 -1,
 -63594,
 127169109,
 121248,
 -1,
 127225951,
 121249,
 127403932,
 125787255,
 -1,
 -63591,
 127365717,
 121147,
 -63590,
 127429882,
 121150,
 -63589,
 127488095,
 121148,
 -1,
 127551267,
 121149,
 127731616,
 127350747,
 -1,
 -63586,
 127693397,
 121151,
 -63585,
 127750239,
 121152,
 -1,
 127813411,
 121153,
 -1,
 127691963,
 121139,
 128059318,
 125731881,
 -1,
 128124851,
 127997540,
 -1,
 128190380,
 128066140,
 -1,
 128255912,
 128154400,
 -1,
 -63578,
 128217685,
 121244,
 -63577,
 128274527,
 121245,
 -1,
 128337699,
 121246,
 128581631,
 128198069,
 -1,
 -63574,
 128479829,
 121241,
 -63573,
 128536671,
 121242,
 -1,
 128599843,
 121243,
 128780208,
 128132263,
 -1,
 -63570,
 128741973,
 121268,
 -63569,
 128798815,
 121269,
 -1,
 128861987,
 121270,
 129105919,
 128727293,
 -1,
 -63566,
 128987822,
 121257,
 -1,
 129047974,
 121264,
 129302527,
 128084925,
 -1,
 -63563,
 129200613,
 121325,
 -1,
 129246638,
 121326,
 129435583,
 128019907,
 -1,
 129501118,
 129384400,
 -1,
 129566653,
 129463491,
 -1,
 129632187,
 129517347,
 121132,
 -1,
 129594407,
 121133,
 -63556,
 129593941,
 121130,
 -1,
 129716319,
 121131,
 -1,
 129534110,
 121134,
 -1,
 129447484,
 121253,
 130025415,
 129387881,
 -1,
 130090946,
 129987157,
 121237,
 -1,
 130023844,
 121240,
 130222021,
 130038013,
 -1,
 -63548,
 130167470,
 121256,
 -1,
 130227622,
 121263,
 -63546,
 130175071,
 121238,
 -1,
 130369315,
 121239,
 130549712,
 129963698,
 -1,
 130615244,
 130506597,
 -1,
 -63542,
 130576981,
 121154,
 -63541,
 130633823,
 121155,
 -1,
 130696995,
 121156,
 130940927,
 130558873,
 -1,
 -63538,
 130839125,
 121144,
 -63537,
 130895967,
 121145,
 -1,
 130959139,
 121146,
 131139543,
 130497097,
 -1,
 131205076,
 131086589,
 -1,
 -63533,
 131150510,
 121255,
 -1,
 131210662,
 121262,
 -63531,
 131166805,
 121234,
 -63530,
 131354719,
 121235,
 -1,
 131417891,
 121236,
 131598300,
 131103520,
 -1,
 131663834,
 131535345,
 121142,
 -1,
 131598220,
 121143,
 -63525,
 131631262,
 121141,
 -1,
 131757261,
 121140,
 131925985,
 131540405,
 -1,
 131991519,
 131863025,
 121137,
 -1,
 131925900,
 121138,
 -63520,
 131958942,
 121136,
 -1,
 132084922,
 121135,
 132253672,
 131863619,
 -1,
 132319205,
 132215387,
 -1,
 -63516,
 132280805,
 121315,
 -1,
 132326830,
 121317,
 132579327,
 132272230,
 -1,
 -63513,
 132477413,
 121316,
 -1,
 132523438,
 121318,
 132712428,
 132221818,
 -1,
 -63510,
 132674133,
 121157,
 -63509,
 132730975,
 121158,
 -1,
 132794147,
 121159,
 132974576,
 132669688,
 -1,
 -63506,
 132936277,
 121160,
 -63505,
 132993119,
 121161,
 -1,
 133056291,
 121162,
 133236725,
 132919383,
 -1,
 133302260,
 133185878,
 -1,
 -63501,
 133263845,
 121329,
 -1,
 133309870,
 121330,
 -1,
 133258010,
 121128,
 -1,
 133186473,
 121448,
 133630062,
 125645070,
 -1,
 133695499,
 133569347,
 -1,
 133761029,
 133660933,
 -1,
 133826560,
 133708029,
 -1,
 133892093,
 133771527,
 -1,
 -63492,
 133853781,
 121286,
 -1,
 133908259,
 121287,
 134152191,
 133831876,
 -1,
 -63489,
 134050389,
 121271,
 -1,
 134104867,
 121272,
 134285314,
 133777187,
 121303,
 -1,
 134247463,
 121304,
 -63485,
 134246997,
 121301,
 -63484,
 134369375,
 121302,
 -1,
 134422364,
 121305,
 134613001,
 133717111,
 -1,
 -63481,
 134574677,
 121204,
 -63480,
 134631519,
 121205,
 -1,
 134694691,
 121206,
 -63478,
 134573243,
 121198,
 -1,
 134821846,
 121207,
 135006235,
 133661737,
 -1,
 135071768,
 134944356,
 -1,
 135137300,
 135018749,
 -1,
 135202833,
 135082247,
 -1,
 -63472,
 135164501,
 121296,
 -1,
 135218979,
 121297,
 135462911,
 135142596,
 -1,
 -63469,
 135361109,
 121281,
 -1,
 135415587,
 121282,
 135596055,
 135097795,
 -1,
 -63466,
 135549938,
 121308,
 -1,
 135614278,
 121309,
 -1,
 135546659,
 121310,
 135921663,
 135031760,
 -1,
 -63462,
 135819749,
 121327,
 -1,
 135865774,
 121328,
 136054828,
 134958441,
 -1,
 136120363,
 136001789,
 -1,
 136185892,
 136065287,
 -1,
 136251425,
 136147547,
 -1,
 -63456,
 136212965,
 121292,
 -1,
 136258990,
 121294,
 136511487,
 136202025,
 -1,
 -63453,
 136409573,
 121293,
 -1,
 136455598,
 121295,
 136708095,
 136125636,
 -1,
 136710184,
 136606299,
 -1,
 -63449,
 136671717,
 121277,
 -1,
 136717742,
 121279,
 136970239,
 136660777,
 -1,
 -63446,
 136868325,
 121278,
 -1,
 136914350,
 121280,
 -1,
 136082005,
 121307,
 137168956,
 136002121,
 -1,
 137234491,
 137115901,
 -1,
 137300020,
 137179399,
 -1,
 137365554,
 137263904,
 -1,
 -63439,
 137327332,
 121290,
 -1,
 137381746,
 121291,
 -63437,
 137327202,
 121288,
 -1,
 137512752,
 121289,
 137756671,
 137239748,
 -1,
 137758776,
 137654875,
 -1,
 -63433,
 137722649,
 121275,
 -1,
 137766318,
 121273,
 138018815,
 137709353,
 -1,
 -63430,
 137919257,
 121276,
 -1,
 137962926,
 121274,
 -1,
 137196117,
 121306,
 138217541,
 137129411,
 -1,
 138283076,
 138166224,
 -1,
 138348611,
 138245315,
 -1,
 138414145,
 138299171,
 121191,
 -1,
 138376231,
 121192,
 -63422,
 138375765,
 121189,
 -1,
 138498143,
 121190,
 -1,
 138315934,
 121193,
 -1,
 138229315,
 121314,
 138807375,
 138155087,
 -1,
 138872905,
 138768987,
 -1,
 -63416,
 138834405,
 121319,
 -1,
 138880430,
 121322,
 139069516,
 138825830,
 -1,
 -63413,
 139031013,
 121320,
 -1,
 139077038,
 121323,
 139329535,
 139020073,
 -1,
 -63410,
 139227621,
 121321,
 -1,
 139273646,
 121324,
 139462741,
 138771232,
 -1,
 139528275,
 139399677,
 -1,
 -63406,
 139495582,
 121202,
 -1,
 139547357,
 121201,
 -63404,
 139495582,
 121200,
 -1,
 139687117,
 121199,
 139855962,
 139404725,
 -1,
 139921496,
 139792881,
 121196,
 -1,
 139855756,
 121197,
 -63399,
 139888798,
 121195,
 -1,
 140014778,
 121194,
 140183648,
 139794098,
 -1,
 140249183,
 140140389,
 -1,
 -63395,
 140210773,
 121208,
 -63394,
 140267615,
 121209,
 -1,
 140330787,
 121210,
 -1,
 140192661,
 121203,
 140576868,
 140151674,
 -1,
 -63390,
 140538453,
 121211,
 -63389,
 140595295,
 121212,
 -1,
 140658467,
 121213,
 140839016,
 140534008,
 -1,
 -63386,
 140800597,
 121214,
 -63385,
 140857439,
 121215,
 -1,
 140920611,
 121216,
 141101165,
 140783703,
 -1,
 141166700,
 141050206,
 -1,
 -63381,
 141128165,
 121331,
 -1,
 141174190,
 121332,
 -1,
 141122330,
 121129,
 -1,
 141050793,
 121449,
 141494404,
 133571741,
 -1,
 141559930,
 141432871,
 -1,
 141625461,
 141523496,
 -1,
 141690995,
 141575971,
 121187,
 -1,
 141653031,
 121188,
 -63372,
 141652565,
 121185,
 -1,
 141774943,
 121186,
 142016511,
 141563524,
 -1,
 142018680,
 141903651,
 121183,
 -1,
 141980711,
 121184,
 -63367,
 141980245,
 121181,
 -1,
 142102623,
 121182,
 142280831,
 141523496,
 -1,
 142346365,
 142231331,
 121179,
 -1,
 142308391,
 121180,
 -63362,
 142307925,
 121177,
 -1,
 142430303,
 121178,
 142671871,
 142218884,
 -1,
 142674050,
 142559011,
 121175,
 -1,
 142636071,
 121176,
 -63357,
 142635605,
 121173,
 -1,
 142757983,
 121174,
 142999551,
 141441219,
 -1,
 143001741,
 142900999,
 -1,
 143067276,
 142943907,
 -1,
 143132810,
 143004157,
 -1,
 -63351,
 143094357,
 121126,
 -1,
 143148835,
 121125,
 -63349,
 143094357,
 121122,
 -1,
 143279907,
 121121,
 -1,
 143028147,
 121123,
 -63346,
 142963037,
 121127,
 -1,
 143468264,
 121124,
 143720447,
 125600122,
 -1,
 143722652,
 143612842,
 -1,
 143788181,
 143681484,
 121418,
 143917055,
 143720448,
 -1,
 -63340,
 143821291,
 121420,
 -1,
 143886475,
 121419,
 144050329,
 143744679,
 121415,
 144179199,
 143982592,
 -1,
 -63336,
 144083435,
 121417,
 -1,
 144148619,
 121416,
 -63334,
 144017547,
 121414,
 -63333,
 144257446,
 121413,
 -1,
 144317950,
 121412,
 144509090,
 143661891,
 -1,
 144574625,
 144461171,
 -1,
 -63329,
 144528612,
 121403,
 -63328,
 144585126,
 121404,
 -1,
 144646252,
 121405,
 -1,
 144530558,
 121430,
 144902310,
 144471895,
 121424,
 145031167,
 144834560,
 -1,
 -63323,
 144930168,
 121426,
 -1,
 144978342,
 121425,
 145164458,
 144863995,
 121406,
 145293311,
 145096704,
 -1,
 -63319,
 145197195,
 121407,
 -1,
 145251237,
 121408,
 145426606,
 145114511,
 121421,
 145555455,
 145358848,
 -1,
 -63315,
 145459339,
 121423,
 -1,
 145502630,
 121422,
 145688754,
 145371833,
 121409,
 145817599,
 145620992,
 -1,
 -63311,
 145721483,
 121410,
 -1,
 145775525,
 121411,
 146014207,
 145655956,
 -1,
 -63308,
 145912293,
 121431,
 -1,
 145958318,
 121432,
 146147572,
 125531659,
 -1,
 146213073,
 146106091,
 -1,
 146278598,
 146179154,
 -1,
 146344129,
 146238723,
 -1,
 146409661,
 146310226,
 -1,
 -63301,
 146371045,
 121163,
 -63300,
 146417070,
 121164,
 -1,
 146477553,
 121165,
 146735103,
 146354446,
 -1,
 -63297,
 146633189,
 121166,
 -63296,
 146679214,
 121167,
 -1,
 146739697,
 121168,
 146933957,
 146281586,
 -1,
 -63293,
 146897689,
 121172,
 -63292,
 146960869,
 121170,
 -1,
 147006894,
 121171,
 -1,
 146894903,
 121169,
 147324927,
 146223374,
 -1,
 147327184,
 147221763,
 -1,
 147392716,
 147293266,
 -1,
 -63286,
 147354085,
 121220,
 -63285,
 147400110,
 121221,
 -1,
 147460593,
 121222,
 147718143,
 147337486,
 -1,
 -63282,
 147616229,
 121217,
 -63281,
 147662254,
 121218,
 -1,
 147722737,
 121219,
 -1,
 147288119,
 121223,
 147982566,
 146167742,
 -1,
 148048093,
 147936586,
 -1,
 148113622,
 148011325,
 -1,
 -63275,
 148077050,
 121436,
 -1,
 148117552,
 121435,
 148310233,
 148053208,
 -1,
 -63272,
 148272258,
 121439,
 -1,
 148324382,
 121440,
 -63270,
 148272271,
 121433,
 -63269,
 148460262,
 121438,
 -63268,
 148523900,
 121434,
 -1,
 148586539,
 121437,
 148768993,
 148012450,
 -1,
 -63265,
 148730341,
 121093,
 -63264,
 148788037,
 121094,
 -1,
 148838431,
 121095,
 149094399,
 148729192,
 -1,
 149096677,
 148997202,
 -1,
 -63260,
 149058783,
 121458,
 -1,
 149103210,
 121459,
 -1,
 149041451,
 121460,
 149422079,
 147925015,
 -1,
 149424368,
 149302728,
 121441,
 149553151,
 149356544,
 -1,
 149555438,
 149445076,
 -1,
 149620972,
 149518759,
 121443,
 -1,
 149553850,
 121444,
 149815295,
 149572707,
 121445,
 -1,
 149684922,
 121446,
 -63249,
 149508829,
 121442,
 -1,
 149821654,
 121447,
 150077439,
 149378803,
 -1,
 -63246,
 149967242,
 121390,
 -63245,
 150031743,
 121391,
 -1,
 150091889,
 121389,
 150276391,
 146105721,
 -1,
 150341923,
 150232286,
 -1,
 150407442,
 150276001,
 -1,
 150472965,
 150373458,
 -1,
 150538492,
 150434277,
 121250,
 150667263,
 150471180,
 -1,
 -63237,
 150549166,
 121258,
 -1,
 150609318,
 121265,
 150800640,
 150480302,
 121251,
 150929407,
 150733324,
 -1,
 -63233,
 150811310,
 121259,
 -1,
 150871462,
 121266,
 151126015,
 150737384,
 -1,
 151128324,
 151011115,
 -1,
 -63229,
 151073454,
 121260,
 -1,
 151133606,
 121267,
 -1,
 151070743,
 121252,
 151453695,
 150417678,
 -1,
 151456010,
 151351781,
 121311,
 151584767,
 151388684,
 -1,
 -63223,
 151466241,
 121298,
 -1,
 151526588,
 121283,
 151718158,
 151397806,
 121312,
 151846911,
 151650828,
 -1,
 -63219,
 151728385,
 121299,
 -1,
 151788732,
 121284,
 152043519,
 151654897,
 121313,
 152109055,
 151912972,
 -1,
 -63215,
 151990529,
 121300,
 -1,
 152050876,
 121285,
 152305663,
 150340271,
 -1,
 152307995,
 152176857,
 -1,
 -63211,
 152243276,
 121519,
 -63210,
 152308642,
 121518,
 -63209,
 152374022,
 121517,
 -63208,
 152439373,
 121516,
 -63207,
 152504693,
 121515,
 -63206,
 152570073,
 121514,
 -1,
 152635465,
 121513,
 -63204,
 152243721,
 121512,
 -63203,
 152767882,
 121511,
 -63202,
 152833252,
 121510,
 -63201,
 152898636,
 121509,
 -63200,
 152964002,
 121508,
 -63199,
 153029382,
 121507,
 -63198,
 153094733,
 121506,
 -1,
 153160053,
 121505,
 153419775,
 150306062,
 -1,
 -63195,
 153317861,
 121105,
 -63194,
 153375557,
 121106,
 -1,
 153425951,
 121107,
 153618769,
 150218775,
 -1,
 153684303,
 153586164,
 -1,
 153749816,
 153629609,
 -1,
 153815346,
 153715794,
 -1,
 153880879,
 153777338,
 121377,
 154009599,
 153812992,
 -1,
 -63186,
 153888174,
 121378,
 -1,
 153948657,
 121379,
 154206207,
 153819971,
 -1,
 -63183,
 154108171,
 121383,
 -1,
 154157427,
 121385,
 154402815,
 153760014,
 -1,
 154405175,
 154301626,
 121380,
 154533887,
 154337280,
 -1,
 -63178,
 154412462,
 121381,
 -1,
 154472945,
 121382,
 -1,
 154346083,
 121384,
 154732866,
 153710021,
 -1,
 154798396,
 154699323,
 -1,
 -63173,
 154752432,
 121372,
 -1,
 154796847,
 121370,
 154995007,
 154744418,
 -1,
 -63170,
 154950565,
 121369,
 -1,
 155000586,
 121371,
 -63168,
 154956785,
 121365,
 -63167,
 155147173,
 121364,
 -1,
 155197194,
 121366,
 155388230,
 154683263,
 -1,
 -63164,
 155352836,
 121374,
 -63163,
 155398470,
 121376,
 -1,
 155461278,
 121375,
 155650378,
 155327161,
 -1,
 -63160,
 155614980,
 121354,
 -63159,
 155669732,
 121355,
 -1,
 155723422,
 121356,
 155975679,
 155582464,
 -1,
 155978062,
 155851159,
 -1,
 -63155,
 155939301,
 121367,
 -1,
 155996997,
 121368,
 -1,
 155944580,
 121373,
 -63152,
 153651468,
 121452,
 -1,
 156177657,
 121392,
 156371310,
 153568804,
 -1,
 156436834,
 156318364,
 -1,
 156502365,
 156389360,
 -1,
 156567900,
 156453511,
 -1,
 -63146,
 156503268,
 121469,
 -63145,
 156568652,
 121468,
 -63144,
 156634018,
 121467,
 -63143,
 156699398,
 121466,
 -63142,
 156764749,
 121465,
 -63141,
 156830069,
 121464,
 -1,
 156895449,
 121463,
 -1,
 156507984,
 121462,
 157220863,
 156458906,
 -1,
 157223265,
 157089792,
 -1,
 -63136,
 157188091,
 121429,
 -1,
 157240862,
 121428,
 -1,
 157183467,
 121427,
 157548543,
 156391457,
 -1,
 157550955,
 157417472,
 -1,
 157616487,
 157497186,
 -1,
 -63130,
 157564027,
 121473,
 -1,
 157618166,
 121476,
 -63128,
 157582920,
 121474,
 -63127,
 157776362,
 121477,
 -63126,
 157830197,
 121478,
 -1,
 157885487,
 121475,
 158138367,
 157484961,
 -1,
 -63123,
 158041209,
 121471,
 -1,
 158085402,
 121472,
 158271883,
 156315436,
 -1,
 158337402,
 158221860,
 -1,
 158402937,
 158284730,
 -1,
 158468470,
 158363075,
 -1,
 158534005,
 158420811,
 -1,
 -63116,
 158495205,
 121116,
 -1,
 158552901,
 121118,
 -1,
 158477454,
 121119,
 158859263,
 158418729,
 -1,
 -63112,
 158757349,
 121115,
 -1,
 158815045,
 121117,
 -1,
 158358368,
 121456,
 159058306,
 158284444,
 -1,
 159123841,
 159009944,
 -1,
 -63107,
 159059020,
 121503,
 -63106,
 159124386,
 121502,
 -63105,
 159189766,
 121501,
 -63104,
 159255117,
 121500,
 -1,
 159320437,
 121499,
 -1,
 159077696,
 121470,
 159582598,
 159013981,
 -1,
 -63100,
 159549579,
 121363,
 -63099,
 159601892,
 121361,
 -1,
 159653996,
 121362,
 159844746,
 159518571,
 -1,
 159910281,
 159809319,
 121352,
 -1,
 159843587,
 121353,
 -1,
 159855037,
 121351,
 -1,
 159809142,
 121480,
 160172451,
 158232003,
 -1,
 160237974,
 160130364,
 -1,
 160303506,
 160198083,
 -1,
 160369041,
 160255819,
 -1,
 -63088,
 160330213,
 121111,
 -1,
 160387909,
 121113,
 -1,
 160312462,
 121114,
 160631189,
 160253737,
 -1,
 -63084,
 160592357,
 121110,
 -1,
 160650053,
 121112,
 -1,
 160575727,
 121120,
 160893338,
 160201478,
 -1,
 -63080,
 160854501,
 121099,
 -63079,
 160912197,
 121100,
 -1,
 160962591,
 121101,
 161155487,
 160840090,
 -1,
 161221022,
 161102051,
 -1,
 -63075,
 161182648,
 121453,
 -1,
 161243944,
 121454,
 -1,
 161183982,
 121457,
 161483170,
 161120410,
 -1,
 -63071,
 161445379,
 121108,
 -1,
 161486879,
 121109,
 -1,
 161426232,
 121481,
 161745335,
 160113296,
 -1,
 161810865,
 161712842,
 -1,
 161876393,
 161770947,
 -1,
 161941928,
 161824200,
 121339,
 -1,
 161873922,
 121340,
 -1,
 161893759,
 121336,
 162138540,
 161813713,
 -1,
 -63061,
 162099797,
 121333,
 -1,
 162154275,
 121334,
 -63059,
 162101079,
 121337,
 -63058,
 162293859,
 121338,
 -63057,
 162346305,
 121342,
 -63056,
 162410387,
 121335,
 -1,
 162475710,
 121341,
 162725887,
 161769318,
 -1,
 162728373,
 162616556,
 -1,
 -63052,
 162692868,
 121360,
 -1,
 162735774,
 121357,
 -63050,
 162692892,
 121359,
 -1,
 162866887,
 121358,
 163056063,
 161698678,
 -1,
 163121598,
 163011749,
 -1,
 163187132,
 163087401,
 -1,
 -63045,
 163146594,
 121395,
 -1,
 163200116,
 121396,
 -63043,
 163140836,
 121393,
 -1,
 163324012,
 121394,
 -1,
 163064115,
 121450,
 163580359,
 162995011,
 -1,
 163645892,
 163526630,
 -1,
 -63038,
 163607928,
 121388,
 -63037,
 163668962,
 121386,
 -1,
 163730660,
 121387,
 163971071,
 163600318,
 -1,
 -63034,
 163861117,
 121479,
 -1,
 163925287,
 121482,
 164104655,
 163519097,
 -1,
 164170188,
 164069694,
 -1,
 -63030,
 164131301,
 121102,
 -63029,
 164188997,
 121103,
 -1,
 164239391,
 121104,
 164495359,
 164112658,
 -1,
 -63026,
 164380631,
 121401,
 -1,
 164441875,
 121402,
 164628950,
 164040981,
 -1,
 164694483,
 164590963,
 -1,
 -63022,
 164642616,
 121398,
 -1,
 164693064,
 121400,
 164954111,
 164633001,
 -1,
 -63019,
 164839276,
 121397,
 -1,
 164889672,
 121399,
 165087706,
 164574566,
 -1,
 -63016,
 165048805,
 121096,
 -63015,
 165106501,
 121097,
 -1,
 165156895,
 121098,
 -63013,
 165053533,
 121455,
 -63012,
 165314520,
 121461,
 -1,
 165372065,
 121483,
 -1,
 100926241,
 129304,
 165612134,
 100868752,
 -1,
 165677659,
 165553277,
 -1,
 165743139,
 165628571,
 -1,
 165808619,
 165705227,
 -1,
 165874148,
 165775358,
 71129,
 -1,
 165821084,
 71130,
 166005223,
 165836299,
 -1,
 -63002,
 165950946,
 71065,
 -1,
 166006420,
 71064,
 166201834,
 165950932,
 -1,
 -62999,
 166160405,
 71128,
 -1,
 166203028,
 71070,
 -1,
 166137492,
 71069,
 166463986,
 165773750,
 -1,
 166529521,
 166418448,
 -1,
 166595055,
 166487417,
 71046,
 -1,
 166552953,
 71047,
 166789119,
 166544932,
 71048,
 -1,
 166676004,
 71049,
 -1,
 166465172,
 71082,
 166922743,
 166399636,
 71040,
 -62988,
 166886479,
 71053,
 -62987,
 166940264,
 71131,
 -62986,
 167000732,
 71051,
 -1,
 167054996,
 71041,
 167250428,
 166876022,
 -1,
 -62983,
 167217600,
 71063,
 -62982,
 167269346,
 71068,
 -62981,
 167326519,
 71058,
 -1,
 167382676,
 71073,
 167578114,
 167191184,
 -1,
 167643648,
 167518864,
 -1,
 -62977,
 167589346,
 71067,
 -1,
 167644820,
 71066,
 -62975,
 167589346,
 71072,
 -1,
 167775892,
 71071,
 167971334,
 167538115,
 -1,
 -62972,
 167931432,
 71084,
 -62971,
 167982562,
 71083,
 -1,
 168038036,
 71085,
 168233480,
 167935055,
 71044,
 -1,
 168197199,
 71045,
 168364555,
 168189850,
 -1,
 -62966,
 168310242,
 71075,
 -1,
 168365716,
 71074,
 168561166,
 168313902,
 -1,
 -62963,
 168506850,
 71055,
 -1,
 168562324,
 71054,
 168757777,
 168510319,
 -1,
 -62960,
 168703458,
 71062,
 -1,
 168758932,
 71061,
 168954387,
 168704668,
 71042,
 -1,
 168901276,
 71043,
 169085462,
 168899345,
 -1,
 -62955,
 169031138,
 71057,
 -1,
 169086612,
 71056,
 169282073,
 169024323,
 -1,
 -62952,
 169227746,
 71060,
 -1,
 169283220,
 71059,
 169478684,
 169219762,
 -1,
 -62949,
 169424354,
 71077,
 -1,
 169479828,
 71076,
 -62947,
 169445824,
 71079,
 -62946,
 169633229,
 71080,
 -62945,
 169695166,
 71052,
 -62944,
 169758454,
 71078,
 -62943,
 169821806,
 71081,
 -62942,
 169883106,
 71086,
 -1,
 169945111,
 71050,
 170134084,
 165703107,
 -1,
 170199612,
 170076183,
 -1,
 170265145,
 170140114,
 -1,
 170330679,
 170231456,
 -1,
 170396204,
 170293880,
 -1,
 170461739,
 170337280,
 -1,
 -62934,
 170425514,
 71114,
 -1,
 170468765,
 71115,
 -1,
 170418690,
 71122,
 170723888,
 170354429,
 -1,
 -62930,
 170687272,
 71118,
 -62929,
 170731021,
 71117,
 -1,
 170795343,
 71116,
 170986036,
 170663546,
 -1,
 -62926,
 170949650,
 71126,
 -62925,
 171009778,
 71125,
 -1,
 171061764,
 71127,
 -62923,
 170946444,
 71124,
 -62922,
 171205827,
 71123,
 -1,
 171255309,
 71121,
 171507711,
 170272368,
 71119,
 -1,
 171378469,
 71120,
 171638783,
 170221689,
 -1,
 -62917,
 171517318,
 71108,
 -1,
 171579199,
 71109,
 171835391,
 170147072,
 -1,
 171838016,
 171737921,
 -1,
 -62913,
 171798183,
 71102,
 -1,
 171861648,
 71103,
 -62911,
 171798858,
 71105,
 -62910,
 171988819,
 71104,
 -62909,
 172039110,
 71100,
 -1,
 172102518,
 71101,
 172296787,
 170099720,
 -1,
 172362315,
 172232340,
 -1,
 172427848,
 172314216,
 71132,
 -1,
 172391503,
 71133,
 -62903,
 172391503,
 71099,
 -62902,
 172505756,
 71097,
 -1,
 172560020,
 71087,
 172755533,
 172327840,
 71092,
 -1,
 172713337,
 71093,
 172886607,
 172719183,
 71090,
 -1,
 172850255,
 71091,
 173017681,
 172833436,
 71088,
 -1,
 172964508,
 71089,
 -62894,
 172971966,
 71098,
 -1,
 173090839,
 71096,
 173279831,
 172255368,
 -1,
 -62891,
 173214285,
 71112,
 -62890,
 173279605,
 71111,
 -1,
 173344985,
 71110,
 173541978,
 173220496,
 -1,
 -62887,
 173497697,
 71107,
 -1,
 173544117,
 71106,
 -1,
 173484958,
 71113,
 173867007,
 165621458,
 -1,
 173869665,
 173770167,
 -1,
 -62882,
 173834061,
 128414,
 -62881,
 173894061,
 128409,
 -62880,
 173951251,
 128408,
 -1,
 174008020,
 128415,
 174260223,
 173807863,
 -1,
 -62877,
 174161741,
 128416,
 -62876,
 174221741,
 128411,
 -62875,
 174278931,
 128410,
 -1,
 174335700,
 128417,
 174525091,
 165565302,
 -1,
 174590617,
 174470743,
 -1,
 174656134,
 174527467,
 -1,
 174721657,
 174610265,
 -1,
 174787182,
 174683659,
 -1,
 -62868,
 174753128,
 70123,
 -62867,
 174799095,
 70124,
 -1,
 174861127,
 70122,
 175049329,
 174747075,
 -1,
 -62864,
 174998339,
 70127,
 -1,
 175058575,
 70128,
 175245940,
 175004202,
 -1,
 -62861,
 175208435,
 70132,
 -1,
 175258191,
 70131,
 175442551,
 175189804,
 -1,
 -62858,
 175398045,
 70125,
 -1,
 175455273,
 70126,
 -62856,
 175396249,
 70130,
 -1,
 175581870,
 70129,
 175833087,
 174662874,
 -1,
 175835773,
 175732235,
 -1,
 -62852,
 175802324,
 70114,
 -1,
 175847856,
 70115,
 176032384,
 175795651,
 -1,
 -62849,
 175981316,
 70118,
 -1,
 176041567,
 70119,
 176228995,
 175976236,
 -1,
 -62846,
 176184795,
 70116,
 -1,
 176243302,
 70117,
 -62844,
 176183846,
 70113,
 -62843,
 176379241,
 70121,
 -1,
 176433767,
 70120,
 176622228,
 174607464,
 -1,
 176687754,
 176584203,
 -1,
 -62839,
 176654292,
 3560,
 -1,
 176699824,
 3561,
 176884365,
 176647619,
 -1,
 -62836,
 176833284,
 3564,
 -1,
 176893535,
 3565,
 177080976,
 176828204,
 -1,
 -62833,
 177036763,
 3562,
 -1,
 177095270,
 3563,
 -62831,
 177048433,
 3558,
 -62830,
 177232422,
 3559,
 -62829,
 177296745,
 3567,
 -1,
 177351271,
 3566,
 177602559,
 176562198,
 -1,
 177605272,
 177497465,
 -1,
 -62825,
 177548383,
 983923,
 -1,
 177607006,
 983922,
 -1,
 177572315,
 983921,
 177930239,
 174535941,
 -1,
 177932960,
 177799168,
 -1,
 177998494,
 177893594,
 -1,
 -62819,
 177965012,
 983154,
 -1,
 178010544,
 983157,
 -62817,
 177943881,
 983182,
 -1,
 178134329,
 983184,
 178388991,
 177866802,
 -1,
 -62814,
 178260557,
 983158,
 -1,
 178325877,
 983155,
 178522790,
 174491870,
 -1,
 -62811,
 178484313,
 128303,
 -1,
 178545097,
 128973,
 -1,
 178473825,
 128510,
 178785097,
 100808148,
 -1,
 178850604,
 178720404,
 -1,
 178916138,
 178808185,
 -1,
 178981673,
 178851863,
 -1,
 179047147,
 178932379,
 -1,
 179112627,
 179012022,
 -1,
 179178162,
 179066896,
 -1,
 179243696,
 179135865,
 70025,
 -1,
 179201401,
 70026,
 179437567,
 179193380,
 70027,
 -1,
 179324452,
 70028,
 -1,
 179113620,
 70062,
 179571385,
 179074571,
 -1,
 179636919,
 179533323,
 -1,
 -62794,
 179582434,
 70044,
 -1,
 179637908,
 70043,
 -62792,
 179582434,
 70049,
 -1,
 179768980,
 70048,
 179964606,
 179524470,
 -1,
 -62789,
 179931584,
 70042,
 -62788,
 179983330,
 70047,
 -62787,
 180040503,
 70037,
 -1,
 180096660,
 70052,
 180292292,
 179905168,
 -1,
 180357826,
 180232848,
 -1,
 -62783,
 180303330,
 70046,
 -1,
 180358804,
 70045,
 -62781,
 180303330,
 70051,
 -1,
 180489876,
 70050,
 180685512,
 180227732,
 70019,
 -62778,
 180649039,
 70032,
 -62777,
 180697756,
 70030,
 -1,
 180752020,
 70020,
 180947660,
 180645315,
 -1,
 -62774,
 180907560,
 70064,
 -62773,
 180958690,
 70063,
 -1,
 181014164,
 70065,
 181209806,
 180911183,
 70023,
 -1,
 181173327,
 70024,
 181340881,
 181165978,
 -1,
 -62768,
 181286370,
 70054,
 -1,
 181341844,
 70053,
 181537492,
 181290532,
 -1,
 -62765,
 181487214,
 70061,
 -1,
 181538452,
 70060,
 181734103,
 181486638,
 -1,
 -62762,
 181679586,
 70034,
 -1,
 181735060,
 70033,
 181930714,
 181683055,
 -1,
 -62759,
 181876194,
 70041,
 -1,
 181931668,
 70040,
 182127324,
 181877404,
 70021,
 -1,
 182074012,
 70022,
 182258399,
 182072081,
 -1,
 -62754,
 182203874,
 70036,
 -1,
 182259348,
 70035,
 182455010,
 182197059,
 -1,
 -62751,
 182400482,
 70039,
 -1,
 182455956,
 70038,
 182651621,
 182392498,
 -1,
 -62748,
 182597090,
 70056,
 -1,
 182652564,
 70055,
 -62746,
 182618560,
 70058,
 -62745,
 182805965,
 70059,
 -62744,
 182867902,
 70031,
 -62743,
 182931190,
 70057,
 -62742,
 182990306,
 70066,
 -1,
 183052311,
 70029,
 183241469,
 179012566,
 -1,
 183307004,
 183202183,
 -1,
 183372530,
 183272343,
 -1,
 183438064,
 183330169,
 70072,
 -1,
 183395705,
 70073,
 183631871,
 183387684,
 70074,
 -1,
 183518756,
 70075,
 183700214,
 183307924,
 -1,
 -62732,
 183663695,
 70079,
 -62731,
 183712412,
 70077,
 -1,
 183766676,
 70067,
 183962360,
 183663695,
 70070,
 -1,
 183925839,
 70071,
 184093434,
 183909020,
 70068,
 -1,
 184040092,
 70069,
 -62725,
 184047550,
 70078,
 -1,
 184166423,
 70076,
 -1,
 183259829,
 70091,
 184421137,
 183201219,
 -1,
 184486666,
 184368384,
 -1,
 184552194,
 184451905,
 -1,
 -62719,
 184512167,
 70018,
 -1,
 184575632,
 70080,
 184748805,
 184487572,
 -1,
 -62716,
 184713675,
 70081,
 -1,
 184768406,
 70017,
 -62714,
 184713143,
 70083,
 -62713,
 184906058,
 70107,
 -62712,
 184964947,
 70090,
 -62711,
 185025496,
 70082,
 -1,
 185080774,
 70016,
 185273103,
 184428567,
 -1,
 185338638,
 185213406,
 -1,
 -62707,
 185272693,
 70111,
 -1,
 185338073,
 70110,
 -1,
 185294961,
 70088,
 -62704,
 185237910,
 70093,
 -1,
 185537210,
 70089,
 185731874,
 184361616,
 -1,
 185797408,
 185679091,
 -1,
 185862934,
 185759243,
 -1,
 -62699,
 185829332,
 70098,
 -1,
 185874864,
 70099,
 186059545,
 185822659,
 -1,
 -62696,
 186008324,
 70102,
 -1,
 186068575,
 70103,
 186256156,
 186003244,
 -1,
 -62693,
 186211803,
 70100,
 -1,
 186270310,
 70101,
 -62691,
 186223473,
 70096,
 -62690,
 186407462,
 70097,
 -62689,
 186471785,
 70105,
 -1,
 186526311,
 70104,
 -62687,
 185752929,
 70086,
 -1,
 186651317,
 70085,
 186845989,
 185673751,
 -1,
 -62684,
 186812756,
 70092,
 -1,
 186860713,
 70106,
 -62682,
 186800491,
 70084,
 -62681,
 186988424,
 70108,
 -62680,
 187048070,
 70109,
 -1,
 187109152,
 70087,
 -1,
 178930734,
 129416,
 -62677,
 178881046,
 127847,
 -1,
 187321591,
 129368,
 187501374,
 178804670,
 -1,
 187566905,
 187460973,
 -1,
 187632435,
 187512479,
 -1,
 -62672,
 187596684,
 113827,
 -62671,
 187648711,
 113824,
 -62670,
 187705090,
 113826,
 -1,
 187768984,
 113825,
 187960120,
 187564032,
 -1,
 188025655,
 187897522,
 -1,
 -62666,
 187968506,
 11103,
 -1,
 188026821,
 11087,
 -1,
 187986497,
 11086,
 -1,
 187898747,
 127856,
 188353340,
 187523944,
 -1,
 -62661,
 188316483,
 128722,
 -1,
 188356376,
 128717,
 -62659,
 188319086,
 128703,
 -1,
 188505348,
 127776,
 188681028,
 187447964,
 -1,
 188746562,
 188625625,
 -1,
 -62655,
 188702308,
 983075,
 -1,
 188759508,
 983078,
 -62653,
 188702618,
 128674,
 -1,
 188885701,
 128737,
 189074247,
 188638585,
 -1,
 -62650,
 189038083,
 129335,
 -1,
 189087172,
 129424,
 -62648,
 189041012,
 983197,
 -1,
 189213141,
 128017,
 189402022,
 178742460,
 -1,
 189467557,
 189338668,
 -1,
 189533090,
 189407890,
 -1,
 189598570,
 189482532,
 -1,
 189664101,
 189535686,
 -1,
 189729636,
 189602783,
 -1,
 -62640,
 189696749,
 127305,
 -62639,
 189761908,
 127304,
 -62638,
 189827282,
 127303,
 -62637,
 189890998,
 127301,
 -62636,
 189955151,
 127300,
 -62635,
 190019083,
 127299,
 -62634,
 190080377,
 127297,
 -62633,
 190145670,
 127296,
 -62632,
 190207934,
 127294,
 -62631,
 190271149,
 127292,
 -62630,
 190334500,
 127291,
 -62629,
 190399534,
 127290,
 -62628,
 190464879,
 127289,
 -62627,
 190528156,
 127288,
 -62626,
 190592468,
 127287,
 -62625,
 190657297,
 127286,
 -62624,
 190721836,
 127285,
 -62623,
 190785559,
 127284,
 -62622,
 190849680,
 127283,
 -62621,
 190913347,
 127282,
 -1,
 190975636,
 127280,
 -1,
 189690520,
 127397,
 191299583,
 189618110,
 -1,
 191302505,
 191182021,
 -1,
 -62616,
 191257617,
 10191,
 -1,
 191304326,
 10190,
 -1,
 191263771,
 127401,
 191564668,
 189537091,
 -1,
 191630202,
 191513608,
 -1,
 191695728,
 191565028,
 -1,
 -62610,
 191631060,
 127539,
 -62609,
 191696528,
 127538,
 -1,
 191761472,
 127544,
 191957877,
 191630412,
 -1,
 192023412,
 191892847,
 -1,
 -62605,
 191958537,
 127542,
 -1,
 192023946,
 127543,
 -1,
 191965326,
 127541,
 192285561,
 191892386,
 -1,
 -62601,
 192220232,
 127546,
 -62600,
 192285589,
 127540,
 -1,
 192350793,
 127545,
 -1,
 192220808,
 127547,
 -62597,
 191585109,
 127378,
 -1,
 192562724,
 127377,
 192744323,
 191524291,
 -1,
 192809856,
 192686103,
 -1,
 -62593,
 192774727,
 127393,
 -1,
 192815076,
 127388,
 -62591,
 192765090,
 127384,
 -62590,
 192955208,
 127395,
 -1,
 193018496,
 127402,
 193203080,
 192706059,
 -1,
 193268615,
 193168425,
 -1,
 -62586,
 193222608,
 127389,
 -1,
 193276988,
 127394,
 -1,
 193214901,
 127387,
 193530764,
 193148372,
 -1,
 -62582,
 193477402,
 127400,
 -62581,
 193537965,
 127399,
 -1,
 193600323,
 127398,
 193792912,
 193474348,
 -1,
 -62578,
 193751045,
 127379,
 -62577,
 193814017,
 127390,
 -1,
 193872546,
 127392,
 194055059,
 193757622,
 -1,
 -62574,
 194014659,
 127386,
 -1,
 194074722,
 127404,
 194251670,
 194018383,
 -1,
 -62571,
 194207676,
 127385,
 -1,
 194262879,
 127403,
 194448281,
 194205630,
 -1,
 -62568,
 194401398,
 127396,
 -1,
 194462766,
 127383,
 194644892,
 194401142,
 -1,
 -62565,
 194589457,
 127382,
 -1,
 194653903,
 127381,
 194841503,
 194594031,
 -1,
 -62562,
 194801192,
 127490,
 -1,
 194856365,
 127489,
 -62560,
 194807090,
 127311,
 -62559,
 194984939,
 127380,
 -1,
 195046004,
 127391,
 195297279,
 189464576,
 -1,
 -62556,
 195196654,
 128918,
 -1,
 195257109,
 11216,
 -1,
 189414379,
 129425,
 195496940,
 189355966,
 983077,
 195562451,
 195454416,
 -1,
 195627973,
 195512987,
 -1,
 195693485,
 195580790,
 -1,
 -62549,
 195660231,
 69857,
 -62548,
 195703661,
 69847,
 -1,
 195760351,
 69849,
 195955632,
 195645174,
 -1,
 -62545,
 195900884,
 69846,
 -1,
 195962903,
 69864,
 196152243,
 195897367,
 -1,
 -62542,
 196097492,
 69863,
 -1,
 196160064,
 69859,
 -62540,
 196118983,
 69852,
 -62539,
 196313555,
 69850,
 -62538,
 196378141,
 69861,
 -62537,
 196441766,
 69841,
 -62536,
 196505147,
 69840,
 -62535,
 196568583,
 69853,
 -62534,
 196632559,
 69851,
 -62533,
 196696229,
 69862,
 -62532,
 196757210,
 69848,
 -62531,
 196822167,
 69855,
 -62530,
 196887441,
 69856,
 -62529,
 196951364,
 69860,
 -62528,
 197015037,
 69854,
 -62527,
 197079917,
 69845,
 -62526,
 197141316,
 69844,
 -62525,
 197204855,
 69843,
 -62524,
 197269277,
 69842,
 -1,
 197333215,
 69858,
 197591039,
 195568858,
 -1,
 197594057,
 197490187,
 -1,
 -62520,
 197560276,
 69874,
 -1,
 197605808,
 69875,
 197790668,
 197553603,
 -1,
 -62517,
 197739268,
 69878,
 -1,
 197799519,
 69879,
 197987279,
 197734188,
 -1,
 -62514,
 197942747,
 69876,
 -1,
 198001254,
 69877,
 -62512,
 197954417,
 69872,
 -62511,
 198138406,
 69873,
 -62510,
 198202729,
 69881,
 -1,
 198257255,
 69880,
 198446052,
 195527034,
 -1,
 198511580,
 198411657,
 -1,
 198577113,
 198468255,
 -1,
 -62505,
 198542172,
 128601,
 -62504,
 198592669,
 128593,
 -1,
 198646480,
 128609,
 198839259,
 198539982,
 11113,
 -1,
 198772011,
 11129,
 -1,
 198798982,
 129111,
 199098367,
 198453459,
 -1,
 199101409,
 198992543,
 -1,
 -62497,
 199066460,
 128603,
 -62496,
 199116957,
 128595,
 -1,
 199170768,
 128611,
 199363555,
 199064270,
 11112,
 -1,
 199296299,
 11128,
 -1,
 199323270,
 129110,
 199560166,
 198396824,
 128618,
 -1,
 199492139,
 128619,
 199691241,
 199504601,
 -1,
 -62488,
 199651452,
 128428,
 -1,
 199703463,
 127846,
 -62486,
 199650755,
 983181,
 -62485,
 199842311,
 128284,
 -1,
 199898580,
 983043,
 200084496,
 195460175,
 -1,
 200150026,
 200037238,
 -1,
 200215557,
 200090520,
 -1,
 200281081,
 200172546,
 -1,
 200346611,
 200236954,
 -1,
 -62478,
 200310967,
 7362,
 -1,
 200348440,
 7361,
 -62476,
 200308095,
 7360,
 -62475,
 200493850,
 7364,
 -62474,
 200557704,
 7365,
 -62473,
 200614694,
 7366,
 -62472,
 200678278,
 7363,
 -1,
 200742624,
 7367,
 200936448,
 200231579,
 -1,
 201001981,
 200880183,
 -1,
 -62468,
 200953517,
 7103,
 -1,
 201016366,
 7102,
 -62466,
 200960182,
 7099,
 -62465,
 201149206,
 7100,
 -1,
 201201773,
 7101,
 201395203,
 200876115,
 -1,
 -62462,
 201360449,
 7085,
 -1,
 201412342,
 7084,
 -62460,
 201355733,
 7083,
 -1,
 201528923,
 7098,
 201722887,
 200174492,
 127749,
 -1,
 201655124,
 127748,
 -62456,
 201682882,
 127751,
 -62455,
 201797951,
 127803,
 -1,
 201852497,
 127774,
 202050573,
 200109507,
 -1,
 -62452,
 202006853,
 128671,
 -1,
 202061906,
 127843,
 202247183,
 201987762,
 983102,
 -1,
 202208416,
 983101,
 -1,
 202205399,
 127940,
 202443825,
 200046091,
 983189,
 202509343,
 202378900,
 -1,
 202574874,
 202468720,
 -1,
 202640406,
 202534339,
 -1,
 -62443,
 202603277,
 983180,
 -1,
 202648291,
 983132,
 -62441,
 202602354,
 983044,
 -62440,
 202793913,
 983175,
 -62439,
 202848128,
 983042,
 -1,
 202913165,
 983174,
 203099165,
 202536459,
 -1,
 -62436,
 203062757,
 128509,
 -1,
 203112635,
 128649,
 -62434,
 203051773,
 128387,
 -1,
 203236639,
 127967,
 203426852,
 202466681,
 -1,
 203492387,
 203361940,
 -1,
 -62430,
 203457820,
 127827,
 -1,
 203504768,
 128207,
 -1,
 203440026,
 983188,
 203754537,
 203368471,
 -1,
 203820072,
 203690513,
 -1,
 -62425,
 203767538,
 127836,
 -1,
 203817588,
 128642,
 -1,
 203773486,
 11836,
 204082220,
 203717711,
 -1,
 -62421,
 204025849,
 129369,
 -1,
 204088573,
 127897,
 204278831,
 204036030,
 -1,
 -62418,
 204235903,
 9201,
 -1,
 204283544,
 128480,
 -62416,
 204245202,
 983045,
 -1,
 204434883,
 983169,
 204606543,
 202399642,
 983117,
 204672062,
 204548119,
 -1,
 204737595,
 204607811,
 -1,
 204803129,
 204680366,
 128264,
 204931071,
 204735836,
 -1,
 -62409,
 204830774,
 128266,
 -62408,
 204888661,
 128265,
 -1,
 204938149,
 128263,
 -62406,
 204750602,
 128483,
 -1,
 205064190,
 128586,
 205324287,
 204679191,
 -1,
 -62403,
 205202367,
 128676,
 -1,
 205266201,
 128172,
 205458501,
 204618396,
 -1,
 205524035,
 205416075,
 -1,
 -62399,
 205484150,
 128026,
 -62398,
 205543060,
 128466,
 -1,
 205593484,
 128467,
 205848575,
 205464629,
 128375,
 -1,
 205718871,
 128376,
 205917258,
 205393556,
 983176,
 205982793,
 205876289,
 -1,
 -62392,
 205930273,
 128150,
 -1,
 205991269,
 10024,
 -1,
 205927517,
 127837,
 206244942,
 205871038,
 -1,
 -62388,
 206209418,
 128051,
 -62387,
 206269829,
 127941,
 -1,
 206330321,
 129348,
 -1,
 206194567,
 128166,
 206572648,
 204557997,
 -1,
 206638179,
 206518940,
 -1,
 206703714,
 206589017,
 -1,
 206769247,
 206647128,
 -1,
 206834776,
 206724050,
 128515,
 206962687,
 206766095,
 -1,
 -62378,
 206862538,
 128518,
 -62377,
 206926593,
 128516,
 -1,
 206970693,
 128517,
 207162460,
 206779860,
 -1,
 -62374,
 207117445,
 128520,
 -62373,
 207169724,
 128525,
 -1,
 207229406,
 128519,
 207486975,
 207121859,
 -1,
 -62370,
 207388399,
 128526,
 -1,
 207442456,
 128522,
 207683583,
 206707788,
 -1,
 -62367,
 207576018,
 128570,
 -1,
 207632281,
 128571,
 -1,
 206662710,
 128527,
 207883367,
 206574035,
 -1,
 -62363,
 207838258,
 128312,
 -62362,
 207886785,
 128313,
 -1,
 207950106,
 128745,
 -1,
 207837475,
 128684,
 208211066,
 206521892,
 -1,
 208276593,
 208152599,
 -1,
 208342128,
 208219221,
 -1,
 208407663,
 208289508,
 -1,
 -62355,
 208369116,
 128164,
 -62354,
 208416595,
 128564,
 -1,
 208473949,
 128716,
 -1,
 208374158,
 128554,
 -1,
 208306559,
 128373,
 208800886,
 208222876,
 -1,
 208866421,
 208745639,
 -1,
 -62348,
 208827150,
 128578,
 -1,
 208876232,
 128577,
 -1,
 208805026,
 127829,
 209128569,
 208737095,
 -1,
 -62344,
 209087490,
 11100,
 -1,
 209148158,
 11098,
 -1,
 209083578,
 127920,
 209390727,
 208146068,
 -1,
 209456258,
 209344196,
 -1,
 209521793,
 209401778,
 -1,
 209587328,
 209462709,
 -1,
 -62337,
 209550223,
 128630,
 -1,
 209592208,
 128631,
 -1,
 209538435,
 128632,
 -1,
 209469504,
 128634,
 209915012,
 209418044,
 128752,
 -1,
 209846387,
 128225,
 -62331,
 209881412,
 127927,
 -62330,
 210010240,
 43205,
 -1,
 210060550,
 127862,
 210242706,
 209328963,
 -1,
 210308236,
 210199929,
 -1,
 -62326,
 210262361,
 128220,
 -62325,
 210321647,
 128624,
 -1,
 210381265,
 128437,
 210570383,
 210261950,
 -1,
 -62322,
 210529560,
 129410,
 -1,
 210590950,
 128756,
 210766993,
 210516305,
 127979,
 -1,
 210699301,
 127890,
 -1,
 210713244,
 983185,
 210963610,
 210209140,
 -1,
 211029142,
 210916214,
 983094,
 -62315,
 210968033,
 983093,
 -1,
 211030215,
 128333,
 211225753,
 210987257,
 -1,
 -62312,
 211178806,
 128137,
 -1,
 211226430,
 983202,
 -1,
 211177480,
 128325,
 211487906,
 210905111,
 -1,
 211553438,
 211429399,
 -1,
 -62307,
 211494186,
 127793,
 -1,
 211552254,
 128584,
 -62305,
 211514985,
 983168,
 -62304,
 211700564,
 129331,
 -62303,
 211754963,
 129352,
 -1,
 211817849,
 128186,
 212012202,
 211440502,
 -1,
 212077734,
 211967781,
 -1,
 -62299,
 212015585,
 127938,
 -1,
 212074799,
 127956,
 212274345,
 212012692,
 -1,
 -62296,
 212223235,
 128013,
 -1,
 212286798,
 128012,
 -1,
 212216291,
 129319,
 212536494,
 211971523,
 -1,
 -62292,
 212471444,
 983133,
 -62291,
 212535885,
 983159,
 -1,
 212601205,
 983156,
 212798641,
 212501545,
 -1,
 -62288,
 212745658,
 127946,
 -1,
 212800818,
 128629,
 212995252,
 212747310,
 -1,
 -62285,
 212958824,
 128128,
 -1,
 213007006,
 127935,
 -1,
 212939730,
 983183,
 213258784,
 100732564,
 -1,
 213323595,
 213209974,
 -1,
 213389117,
 213259754,
 -1,
 213454135,
 213321945,
 -1,
 213519567,
 213387337,
 -1,
 213585086,
 213454052,
 83070,
 -62276,
 213523267,
 83073,
 -62275,
 213587634,
 83072,
 -1,
 213651092,
 83071,
 213847234,
 213519110,
 83062,
 -62272,
 213785411,
 83065,
 -62271,
 213849778,
 83064,
 -1,
 213913236,
 83063,
 214109381,
 213781410,
 83066,
 -62268,
 214046386,
 83068,
 -1,
 214109844,
 83067,
 214305991,
 214042997,
 83059,
 -1,
 214240916,
 83060,
 214437065,
 214239449,
 83057,
 -1,
 214371988,
 83058,
 214568139,
 214370377,
 83055,
 -1,
 214503060,
 83056,
 -62260,
 214502921,
 83075,
 -62259,
 214633866,
 83074,
 -62258,
 214699084,
 83069,
 -1,
 214764109,
 83061,
 214961373,
 213453017,
 -1,
 215026899,
 214894665,
 83076,
 -62254,
 214963890,
 83078,
 -1,
 215027348,
 83077,
 215223509,
 214961058,
 83083,
 -1,
 215158420,
 83084,
 -62250,
 215158281,
 83088,
 -62249,
 215289226,
 83087,
 -62248,
 215354596,
 83086,
 -62247,
 215419980,
 83085,
 -62246,
 215485190,
 83082,
 -62245,
 215550541,
 83081,
 -62244,
 215615861,
 83080,
 -1,
 215681241,
 83079,
 215878889,
 214895181,
 -1,
 215944416,
 215813026,
 83105,
 -1,
 215879316,
 83106,
 -62239,
 215879177,
 83110,
 -62238,
 216010122,
 83109,
 -62237,
 216075492,
 83108,
 -62236,
 216140876,
 83107,
 -62235,
 216206086,
 83104,
 -62234,
 216271437,
 83103,
 -62233,
 216336757,
 83102,
 -62232,
 216402137,
 83101,
 -1,
 216467529,
 83100,
 216665333,
 215812469,
 -1,
 216730860,
 216599458,
 83094,
 -1,
 216665748,
 83095,
 -62227,
 216665609,
 83099,
 -62226,
 216796554,
 83098,
 -62225,
 216861924,
 83097,
 -62224,
 216927308,
 83096,
 -62223,
 216992518,
 83093,
 -62222,
 217057869,
 83092,
 -62221,
 217123189,
 83091,
 -62220,
 217188569,
 83090,
 -1,
 217253961,
 83089,
 217451776,
 216600073,
 -1,
 -62217,
 217386505,
 83170,
 -62216,
 217451914,
 83169,
 -62215,
 217517284,
 83168,
 -62214,
 217582668,
 83167,
 -62213,
 217648034,
 83166,
 -62212,
 217713414,
 83165,
 -62211,
 217778765,
 83164,
 -62210,
 217844085,
 83163,
 -62209,
 217909465,
 83162,
 -1,
 217974857,
 83161,
 218172683,
 217386378,
 -1,
 -62206,
 218107401,
 83160,
 -62205,
 218172810,
 83159,
 -62204,
 218238180,
 83158,
 -62203,
 218303564,
 83157,
 -62202,
 218368930,
 83156,
 -62201,
 218434310,
 83155,
 -62200,
 218499661,
 83154,
 -62199,
 218564981,
 83153,
 -62198,
 218630361,
 83152,
 -1,
 218695753,
 83151,
 218893590,
 218107108,
 -1,
 -62195,
 218828297,
 83150,
 -62194,
 218893706,
 83149,
 -62193,
 218959076,
 83148,
 -62192,
 219024460,
 83147,
 -62191,
 219089826,
 83146,
 -62190,
 219155206,
 83145,
 -62189,
 219220557,
 83144,
 -62188,
 219285877,
 83143,
 -62187,
 219351257,
 83142,
 -1,
 219416649,
 83141,
 219614497,
 218827852,
 -1,
 -62184,
 219549193,
 83140,
 -62183,
 219614602,
 83139,
 -62182,
 219679972,
 83138,
 -62181,
 219745356,
 83137,
 -62180,
 219810722,
 83136,
 -62179,
 219876102,
 83135,
 -62178,
 219941453,
 83134,
 -62177,
 220006773,
 83133,
 -62176,
 220072153,
 83132,
 -1,
 220137545,
 83131,
 220335404,
 219548578,
 -1,
 -62173,
 220270089,
 83130,
 -62172,
 220335498,
 83129,
 -62171,
 220400868,
 83128,
 -62170,
 220466252,
 83127,
 -62169,
 220531618,
 83126,
 -62168,
 220596998,
 83125,
 -62167,
 220662349,
 83124,
 -62166,
 220727669,
 83123,
 -62165,
 220793049,
 83122,
 -1,
 220858441,
 83121,
 221118463,
 220269318,
 -1,
 -62162,
 220990985,
 83120,
 -62161,
 221056394,
 83119,
 -62160,
 221121764,
 83118,
 -62159,
 221187148,
 83117,
 -62158,
 221252514,
 83116,
 -62157,
 221317894,
 83115,
 -62156,
 221383245,
 83114,
 -62155,
 221448565,
 83113,
 -62154,
 221513945,
 83112,
 -1,
 221579337,
 83111,
 221777334,
 213387853,
 -1,
 221842761,
 221710925,
 -1,
 221908285,
 221776972,
 83322,
 -62149,
 221846339,
 83325,
 -62148,
 221910706,
 83324,
 -1,
 221974164,
 83323,
 222170433,
 221841781,
 -1,
 -62145,
 222108483,
 83318,
 -62144,
 222172850,
 83317,
 -1,
 222236308,
 83316,
 -62142,
 222105097,
 83328,
 -62141,
 222367114,
 83327,
 -62140,
 222432484,
 83326,
 -62139,
 222497698,
 83321,
 -62138,
 222563078,
 83320,
 -62137,
 222628429,
 83319,
 -62136,
 222693593,
 83315,
 -1,
 222758985,
 83314,
 222956888,
 221777290,
 -1,
 223022412,
 222891084,
 83381,
 -1,
 222957204,
 83382,
 223153487,
 222956109,
 -1,
 -62130,
 223088276,
 83378,
 -1,
 223151099,
 83377,
 223350097,
 223086809,
 83374,
 -1,
 223284884,
 83375,
 -62126,
 223284745,
 83385,
 -62125,
 223415690,
 83384,
 -62124,
 223481060,
 83383,
 -62123,
 223546274,
 83380,
 -62122,
 223611654,
 83379,
 -62121,
 223676789,
 83376,
 -1,
 223742025,
 83373,
 223939941,
 222891084,
 -1,
 224005467,
 223874442,
 83359,
 -1,
 223940244,
 83360,
 224136541,
 223939334,
 83354,
 -1,
 224071316,
 83355,
 -62114,
 224071177,
 83361,
 -62113,
 224201956,
 83358,
 -62112,
 224267340,
 83357,
 -62111,
 224332706,
 83356,
 -62110,
 224397901,
 83353,
 -62109,
 224463221,
 83352,
 -62108,
 224528601,
 83351,
 -1,
 224593993,
 83350,
 224791921,
 223874276,
 -1,
 224857448,
 224725209,
 83363,
 -1,
 224792212,
 83364,
 -62103,
 224792073,
 83372,
 -62102,
 224923018,
 83371,
 -62101,
 224988388,
 83370,
 -62100,
 225053772,
 83369,
 -62099,
 225119138,
 83368,
 -62098,
 225184518,
 83367,
 -62097,
 225249869,
 83366,
 -62096,
 225315189,
 83365,
 -1,
 225380425,
 83362,
 225578365,
 224725922,
 -1,
 225643892,
 225512969,
 83348,
 -1,
 225578644,
 83349,
 -62091,
 225578378,
 83347,
 -62090,
 225709284,
 83346,
 -62089,
 225774668,
 83345,
 -62088,
 225840034,
 83344,
 -62087,
 225905414,
 83343,
 -62086,
 225970765,
 83342,
 -62085,
 226036085,
 83341,
 -62084,
 226101465,
 83340,
 -1,
 226166857,
 83339,
 226364809,
 225511797,
 -1,
 226430336,
 226299401,
 83312,
 -1,
 226365076,
 83313,
 -62079,
 226364810,
 83311,
 -62078,
 226495716,
 83310,
 -62077,
 226561100,
 83309,
 -62076,
 226626466,
 83308,
 -62075,
 226691846,
 83307,
 -62074,
 226757197,
 83306,
 -62073,
 226822517,
 83305,
 -62072,
 226887897,
 83304,
 -1,
 226953289,
 83303,
 227151253,
 226297929,
 -1,
 227216780,
 227085833,
 83291,
 -1,
 227151508,
 83292,
 -62067,
 227151242,
 83290,
 -62066,
 227282148,
 83289,
 -62065,
 227347532,
 83288,
 -62064,
 227412898,
 83287,
 -62063,
 227478278,
 83286,
 -62062,
 227543629,
 83285,
 -62061,
 227608949,
 83284,
 -62060,
 227674329,
 83283,
 -1,
 227739721,
 83282,
 227937696,
 227085833,
 -1,
 -62057,
 227872265,
 83395,
 -62056,
 227937674,
 83394,
 -62055,
 228003044,
 83393,
 -62054,
 228068428,
 83392,
 -62053,
 228133794,
 83391,
 -62052,
 228199174,
 83390,
 -62051,
 228264542,
 83389,
 -62050,
 228329845,
 83388,
 -62049,
 228395225,
 83387,
 -1,
 228460617,
 83386,
 228658603,
 227871494,
 -1,
 -62046,
 228593161,
 83338,
 -62045,
 228658570,
 83337,
 -62044,
 228723940,
 83336,
 -62043,
 228789324,
 83335,
 -62042,
 228854690,
 83334,
 -62041,
 228920070,
 83333,
 -62040,
 228985421,
 83332,
 -62039,
 229050741,
 83331,
 -62038,
 229116121,
 83330,
 -1,
 229181513,
 83329,
 229441535,
 228591833,
 -1,
 -62035,
 229314057,
 83302,
 -62034,
 229379466,
 83301,
 -62033,
 229444836,
 83300,
 -62032,
 229510220,
 83299,
 -62031,
 229575586,
 83298,
 -62030,
 229640966,
 83297,
 -62029,
 229706317,
 83296,
 -62028,
 229771637,
 83295,
 -62027,
 229837017,
 83294,
 -1,
 229902409,
 83293,
 230100528,
 221710709,
 -1,
 230165958,
 230033481,
 -1,
 230231483,
 230099317,
 83173,
 -62022,
 230168242,
 83175,
 -1,
 230231700,
 83174,
 230428093,
 230166025,
 83183,
 -1,
 230362772,
 83184,
 230559167,
 230362340,
 83180,
 -1,
 230493844,
 83181,
 -62016,
 230493578,
 83182,
 -62015,
 230624332,
 83179,
 -62014,
 230689698,
 83178,
 -62013,
 230755078,
 83177,
 -62012,
 230820429,
 83176,
 -62011,
 230885593,
 83172,
 -1,
 230950985,
 83171,
 231149011,
 230100489,
 -1,
 231214537,
 231083529,
 83280,
 -1,
 231149204,
 83281,
 231345611,
 231148294,
 83274,
 -1,
 231280276,
 83275,
 -62004,
 231280010,
 83279,
 -62003,
 231410916,
 83278,
 -62002,
 231476300,
 83277,
 -62001,
 231541666,
 83276,
 -62000,
 231606861,
 83273,
 -61999,
 231672181,
 83272,
 -61998,
 231737561,
 83271,
 -1,
 231802953,
 83270,
 232000992,
 231082201,
 -1,
 232066518,
 231935052,
 83192,
 -1,
 232001172,
 83193,
 232197592,
 232000418,
 83190,
 -1,
 232132244,
 83191,
 -61991,
 232132105,
 83196,
 -61990,
 232263050,
 83195,
 -61989,
 232328420,
 83194,
 -61988,
 232393478,
 83189,
 -61987,
 232458829,
 83188,
 -61986,
 232524149,
 83187,
 -61985,
 232589529,
 83186,
 -1,
 232654921,
 83185,
 232852972,
 231935370,
 -1,
 232918499,
 232787465,
 83268,
 -1,
 232853140,
 83269,
 -61980,
 232852874,
 83267,
 -61979,
 232983780,
 83266,
 -61978,
 233049164,
 83265,
 -61977,
 233114530,
 83264,
 -61976,
 233179910,
 83263,
 -61975,
 233245261,
 83262,
 -61974,
 233310581,
 83261,
 -61973,
 233375961,
 83260,
 -1,
 233441353,
 83259,
 233639416,
 232787020,
 -1,
 233704943,
 233573604,
 83245,
 -1,
 233639572,
 83246,
 -61968,
 233639433,
 83248,
 -61967,
 233770378,
 83247,
 -61966,
 233835596,
 83244,
 -61965,
 233900962,
 83243,
 -61964,
 233966342,
 83242,
 -61963,
 234031693,
 83241,
 -61962,
 234097013,
 83240,
 -61961,
 234162393,
 83239,
 -1,
 234227785,
 83238,
 234425860,
 233572725,
 -1,
 234491387,
 234360036,
 83204,
 -1,
 234426004,
 83205,
 -61956,
 234425865,
 83207,
 -61955,
 234556810,
 83206,
 -61954,
 234622028,
 83203,
 -61953,
 234687394,
 83202,
 -61952,
 234752774,
 83201,
 -61951,
 234818125,
 83200,
 -61950,
 234883445,
 83199,
 -61949,
 234948825,
 83198,
 -1,
 235014217,
 83197,
 235212303,
 234360036,
 -1,
 -61946,
 235146761,
 83258,
 -61945,
 235212170,
 83257,
 -61944,
 235277540,
 83256,
 -61943,
 235342924,
 83255,
 -61942,
 235408290,
 83254,
 -61941,
 235473670,
 83253,
 -61940,
 235539021,
 83252,
 -61939,
 235604341,
 83251,
 -61938,
 235669721,
 83250,
 -1,
 235735113,
 83249,
 235933210,
 235146146,
 -1,
 -61935,
 235867657,
 83237,
 -61934,
 235933066,
 83236,
 -61933,
 235998436,
 83235,
 -61932,
 236063820,
 83234,
 -61931,
 236129186,
 83233,
 -61930,
 236194566,
 83232,
 -61929,
 236259917,
 83231,
 -61928,
 236325237,
 83230,
 -61927,
 236390617,
 83229,
 -1,
 236456009,
 83228,
 236654117,
 235866886,
 -1,
 -61924,
 236588553,
 83227,
 -61923,
 236653962,
 83226,
 -61922,
 236719332,
 83225,
 -61921,
 236784716,
 83224,
 -61920,
 236850082,
 83223,
 -61919,
 236915462,
 83222,
 -61918,
 236980813,
 83221,
 -61917,
 237046133,
 83220,
 -61916,
 237111513,
 83219,
 -1,
 237176905,
 83218,
 237436927,
 236587597,
 -1,
 -61913,
 237309449,
 83217,
 -61912,
 237374858,
 83216,
 -61911,
 237440228,
 83215,
 -61910,
 237505612,
 83214,
 -61909,
 237570978,
 83213,
 -61908,
 237636358,
 83212,
 -61907,
 237701709,
 83211,
 -61906,
 237767029,
 83210,
 -61905,
 237832409,
 83209,
 -1,
 237897801,
 83208,
 238096042,
 230033481,
 -1,
 238161472,
 238029574,
 -1,
 238226997,
 238095436,
 82994,
 -61900,
 238163634,
 82996,
 -1,
 238227092,
 82995,
 238423607,
 238160802,
 82992,
 -1,
 238358164,
 82993,
 238554681,
 238356697,
 82987,
 -1,
 238489236,
 82988,
 -61894,
 238489097,
 82999,
 -61893,
 238620042,
 82998,
 -61892,
 238685412,
 82997,
 -61891,
 238750470,
 82991,
 -61890,
 238815821,
 82990,
 -61889,
 238881141,
 82989,
 -1,
 238946377,
 82986,
 239144526,
 238095436,
 -1,
 239210053,
 239078476,
 83016,
 -61885,
 239147843,
 83019,
 -61884,
 239212210,
 83018,
 -1,
 239275668,
 83017,
 -61882,
 239144457,
 83022,
 -61881,
 239406474,
 83021,
 -61880,
 239471844,
 83020,
 -61879,
 239537058,
 83015,
 -61878,
 239602438,
 83014,
 -61877,
 239667789,
 83013,
 -61876,
 239733109,
 83012,
 -61875,
 239798489,
 83011,
 -1,
 239863881,
 83010,
 240062043,
 239078921,
 -1,
 240127569,
 239996298,
 83052,
 -1,
 240062100,
 83053,
 240258643,
 240061668,
 83050,
 -1,
 240193172,
 83051,
 -61868,
 240193033,
 83054,
 -61867,
 240323660,
 83049,
 -61866,
 240389026,
 83048,
 -61865,
 240454406,
 83047,
 -61864,
 240519757,
 83046,
 -61863,
 240585077,
 83045,
 -61862,
 240650457,
 83044,
 -1,
 240715849,
 83043,
 240914023,
 239995469,
 -1,
 240979550,
 240848393,
 82984,
 -1,
 240914068,
 82985,
 -61857,
 240913802,
 82983,
 -61856,
 241044708,
 82982,
 -61855,
 241110092,
 82981,
 -61854,
 241175458,
 82980,
 -61853,
 241240838,
 82979,
 -61852,
 241306189,
 82978,
 -61851,
 241371509,
 82977,
 -61850,
 241436889,
 82976,
 -1,
 241502281,
 82975,
 241700467,
 240847221,
 -1,
 241765994,
 241634380,
 82970,
 -1,
 241700500,
 82971,
 -61845,
 241700361,
 82974,
 -61844,
 241831306,
 82973,
 -61843,
 241896676,
 82972,
 -61842,
 241961890,
 82969,
 -61841,
 242027270,
 82968,
 -61840,
 242092621,
 82967,
 -61839,
 242157941,
 82966,
 -61838,
 242223321,
 82965,
 -1,
 242288713,
 82964,
 242486911,
 241633497,
 -1,
 242552438,
 242419785,
 82953,
 -1,
 242486932,
 82954,
 -61833,
 242486793,
 82963,
 -61832,
 242617738,
 82962,
 -61831,
 242683108,
 82961,
 -61830,
 242748492,
 82960,
 -61829,
 242813858,
 82959,
 -61828,
 242879238,
 82958,
 -61827,
 242944589,
 82957,
 -61826,
 243009909,
 82956,
 -1,
 243075289,
 82955,
 243273354,
 242421130,
 -1,
 -61823,
 243207689,
 83042,
 -61822,
 243273098,
 83041,
 -61821,
 243338468,
 83040,
 -61820,
 243403852,
 83039,
 -61819,
 243469218,
 83038,
 -61818,
 243534598,
 83037,
 -61817,
 243599949,
 83036,
 -61816,
 243665269,
 83035,
 -61815,
 243730649,
 83034,
 -1,
 243796041,
 83033,
 243994261,
 243207396,
 -1,
 -61812,
 243928585,
 83032,
 -61811,
 243993994,
 83031,
 -61810,
 244059364,
 83030,
 -61809,
 244124748,
 83029,
 -61808,
 244190114,
 83028,
 -61807,
 244255494,
 83027,
 -61806,
 244320845,
 83026,
 -61805,
 244386165,
 83025,
 -61804,
 244451545,
 83024,
 -1,
 244516937,
 83023,
 244715168,
 243927970,
 -1,
 -61801,
 244649481,
 83009,
 -61800,
 244714890,
 83008,
 -61799,
 244780260,
 83007,
 -61798,
 244845644,
 83006,
 -61797,
 244911010,
 83005,
 -61796,
 244976390,
 83004,
 -61795,
 245041741,
 83003,
 -61794,
 245107061,
 83002,
 -61793,
 245172441,
 83001,
 -1,
 245237833,
 83000,
 245497855,
 244648009,
 -1,
 -61790,
 245370377,
 82952,
 -61789,
 245435786,
 82951,
 -61788,
 245501156,
 82950,
 -61787,
 245566540,
 82949,
 -61786,
 245631906,
 82948,
 -61785,
 245697286,
 82947,
 -61784,
 245762637,
 82946,
 -61783,
 245827957,
 82945,
 -1,
 245893337,
 82944,
 246091547,
 238029574,
 -1,
 246156984,
 246025122,
 -1,
 246222510,
 246090980,
 83455,
 -1,
 246156948,
 83456,
 246353584,
 246155337,
 83447,
 -1,
 246288020,
 83448,
 -61775,
 246287881,
 83458,
 -61774,
 246418826,
 83457,
 -61773,
 246484044,
 83454,
 -61772,
 246549410,
 83453,
 -61771,
 246614790,
 83452,
 -61770,
 246680141,
 83451,
 -61769,
 246745461,
 83450,
 -1,
 246810841,
 83449,
 247008965,
 246089945,
 -1,
 247074492,
 246941769,
 -1,
 -61765,
 247008921,
 83407,
 -1,
 247070923,
 83406,
 -61763,
 247008777,
 83416,
 -61762,
 247205258,
 83415,
 -61761,
 247270628,
 83414,
 -61760,
 247336012,
 83413,
 -61759,
 247401378,
 83412,
 -61758,
 247466758,
 83411,
 -61757,
 247532109,
 83410,
 -61756,
 247597429,
 83409,
 -1,
 247662809,
 83408,
 247860944,
 246943114,
 -1,
 -61753,
 247795209,
 83488,
 -61752,
 247860618,
 83487,
 -61751,
 247925988,
 83486,
 -61750,
 247991372,
 83485,
 -61749,
 248056738,
 83484,
 -61748,
 248122118,
 83483,
 -61747,
 248187469,
 83482,
 -61746,
 248252789,
 83481,
 -61745,
 248318169,
 83480,
 -1,
 248383561,
 83479,
 248581851,
 247794916,
 -1,
 -61742,
 248516105,
 83478,
 -61741,
 248581514,
 83477,
 -61740,
 248646884,
 83476,
 -61739,
 248712268,
 83475,
 -61738,
 248777634,
 83474,
 -61737,
 248843014,
 83473,
 -61736,
 248908365,
 83472,
 -61735,
 248973685,
 83471,
 -61734,
 249039065,
 83470,
 -1,
 249104457,
 83469,
 249302758,
 248515660,
 -1,
 -61731,
 249237001,
 83468,
 -61730,
 249302410,
 83467,
 -61729,
 249367780,
 83466,
 -61728,
 249433164,
 83465,
 -61727,
 249498530,
 83464,
 -61726,
 249563910,
 83463,
 -61725,
 249629261,
 83462,
 -61724,
 249694581,
 83461,
 -61723,
 249759961,
 83460,
 -1,
 249825353,
 83459,
 250023665,
 249236230,
 -1,
 -61720,
 249957897,
 83446,
 -61719,
 250023306,
 83445,
 -61718,
 250088676,
 83444,
 -61717,
 250154060,
 83443,
 -61716,
 250219426,
 83442,
 -61715,
 250284806,
 83441,
 -61714,
 250350157,
 83440,
 -61713,
 250415477,
 83439,
 -61712,
 250480857,
 83438,
 -1,
 250546249,
 83437,
 250744572,
 249956941,
 -1,
 -61709,
 250678793,
 83436,
 -61708,
 250744202,
 83435,
 -61707,
 250809572,
 83434,
 -61706,
 250874956,
 83433,
 -61705,
 250940322,
 83432,
 -61704,
 251005702,
 83431,
 -61703,
 251071053,
 83430,
 -61702,
 251136373,
 83429,
 -61701,
 251201753,
 83428,
 -1,
 251267145,
 83427,
 251465479,
 250677621,
 -1,
 -61698,
 251399689,
 83426,
 -61697,
 251465098,
 83425,
 -61696,
 251530468,
 83424,
 -61695,
 251595852,
 83423,
 -61694,
 251661218,
 83422,
 -61693,
 251726598,
 83421,
 -61692,
 251791949,
 83420,
 -61691,
 251857269,
 83419,
 -61690,
 251922649,
 83418,
 -1,
 251988041,
 83417,
 252186386,
 251398217,
 -1,
 -61687,
 252120585,
 83405,
 -61686,
 252185994,
 83404,
 -61685,
 252251364,
 83403,
 -61684,
 252316748,
 83402,
 -61683,
 252382114,
 83401,
 -61682,
 252447494,
 83400,
 -61681,
 252512845,
 83399,
 -61680,
 252578165,
 83398,
 -61679,
 252643545,
 83397,
 -1,
 252708937,
 83396,
 252968959,
 252120585,
 -1,
 -61676,
 252841188,
 83496,
 -61675,
 252906572,
 83495,
 -61674,
 252971938,
 83494,
 -61673,
 253037318,
 83493,
 -61672,
 253102669,
 83492,
 -61671,
 253167989,
 83491,
 -61670,
 253233369,
 83490,
 -1,
 253298761,
 83489,
 253558783,
 246025122,
 -1,
 253562663,
 253430133,
 -1,
 -61666,
 253496841,
 83525,
 -61665,
 253562250,
 83524,
 -61664,
 253627620,
 83523,
 -61663,
 253693004,
 83522,
 -61662,
 253758370,
 83521,
 -61661,
 253823750,
 83520,
 -61660,
 253889101,
 83519,
 -61659,
 253954421,
 83518,
 -61658,
 254019801,
 83517,
 -1,
 254085193,
 83516,
 254283570,
 253495513,
 -1,
 -61655,
 254217737,
 83515,
 -61654,
 254283146,
 83514,
 -61653,
 254348516,
 83513,
 -61652,
 254413900,
 83512,
 -61651,
 254479266,
 83511,
 -61650,
 254544646,
 83510,
 -61649,
 254609997,
 83509,
 -61648,
 254675317,
 83508,
 -61647,
 254740697,
 83507,
 -1,
 254806089,
 83506,
 255004476,
 254216265,
 -1,
 -61644,
 254938633,
 83505,
 -61643,
 255004042,
 83504,
 -61642,
 255069412,
 83503,
 -61641,
 255134796,
 83502,
 -61640,
 255200162,
 83501,
 -61639,
 255265542,
 83500,
 -61638,
 255330893,
 83499,
 -61637,
 255396213,
 83498,
 -1,
 255461593,
 83497,
 -1,
 254937840,
 83526,
 255725383,
 213349899,
 128028,
 255790918,
 255671250,
 -1,
 255856453,
 255752893,
 -1,
 -61631,
 255818168,
 11151,
 -61630,
 255879690,
 11148,
 -61629,
 255941552,
 11119,
 -61628,
 256002386,
 11150,
 -1,
 256055880,
 11149,
 -1,
 255797063,
 128260,
 -1,
 255732685,
 128246,
 256442367,
 255669009,
 -1,
 -61623,
 256343605,
 128551,
 -61622,
 256404923,
 128544,
 -1,
 256453829,
 128162,
 256643233,
 213280121,
 -1,
 256708765,
 256577330,
 -1,
 256774154,
 256659190,
 -1,
 256839689,
 256735136,
 -1,
 256905080,
 256778896,
 -1,
 256970613,
 256858046,
 -1,
 257036144,
 256933228,
 -1,
 257101656,
 256996875,
 -1,
 257167190,
 257045972,
 -1,
 -61611,
 257108544,
 126646,
 -1,
 257167744,
 126648,
 -61609,
 257108544,
 126645,
 -1,
 257298655,
 126632,
 257494876,
 257060291,
 -1,
 -61606,
 257439747,
 126644,
 -61605,
 257501649,
 126638,
 -1,
 257560563,
 126641,
 257757023,
 257460975,
 -1,
 -61602,
 257703380,
 126630,
 -1,
 257766868,
 126650,
 257953634,
 257696539,
 -1,
 -61599,
 257902116,
 126627,
 -1,
 257958544,
 126649,
 -61597,
 257919483,
 126633,
 -61596,
 258114799,
 126629,
 -61595,
 258173019,
 126643,
 -61594,
 258237584,
 126642,
 -61593,
 258299458,
 126637,
 -61592,
 258363588,
 126636,
 -61591,
 258426598,
 126635,
 -61590,
 258491721,
 126647,
 -61589,
 258556848,
 126626,
 -61588,
 258618877,
 126631,
 -61587,
 258683991,
 126651,
 -61586,
 258748360,
 126640,
 -61585,
 258807748,
 126625,
 -1,
 258871554,
 126639,
 259129343,
 256997734,
 -1,
 -61582,
 259024016,
 126495,
 -61581,
 259085890,
 126493,
 -61580,
 259141576,
 126494,
 -1,
 259200964,
 126492,
 259457023,
 256904852,
 -1,
 -61577,
 259343908,
 126467,
 -1,
 259400336,
 126489,
 259592093,
 256853540,
 -1,
 259657628,
 259545945,
 -1,
 259723136,
 259618315,
 -1,
 259788670,
 259667412,
 -1,
 -61571,
 259729984,
 126614,
 -1,
 259789184,
 126616,
 -61569,
 259729984,
 126613,
 -1,
 259920095,
 126600,
 260116356,
 259681731,
 -1,
 -61566,
 260061187,
 126612,
 -61565,
 260123089,
 126606,
 -1,
 260182003,
 126609,
 260378503,
 260082415,
 -1,
 -61562,
 260324820,
 126598,
 -1,
 260388308,
 126618,
 260575114,
 260322772,
 -1,
 -61559,
 260516416,
 126596,
 -1,
 260575455,
 126599,
 260771725,
 260514587,
 -1,
 -61556,
 260720164,
 126595,
 -1,
 260776592,
 126617,
 260968336,
 260705940,
 -1,
 -61553,
 260917445,
 126592,
 -1,
 260980180,
 126607,
 -61551,
 260934139,
 126601,
 -61550,
 261129455,
 126597,
 -61549,
 261187675,
 126611,
 -61548,
 261252240,
 126610,
 -61547,
 261314114,
 126605,
 -61546,
 261378244,
 126604,
 -61545,
 261441254,
 126603,
 -61544,
 261506377,
 126615,
 -61543,
 261571504,
 126594,
 -61542,
 261633111,
 126619,
 -61541,
 261697480,
 126608,
 -1,
 261756868,
 126593,
 -1,
 259592721,
 126475,
 262016959,
 259550659,
 -1,
 262082492,
 261978734,
 -1,
 262148003,
 262043147,
 -1,
 -61535,
 262092808,
 126582,
 -61534,
 262154816,
 126581,
 -1,
 262213855,
 126568,
 262410151,
 262106563,
 -1,
 -61531,
 262354947,
 126580,
 -61530,
 262416849,
 126574,
 -1,
 262475763,
 126577,
 262672300,
 262349456,
 -1,
 262737835,
 262626575,
 -1,
 -61526,
 262680520,
 126590,
 -1,
 262739908,
 126588,
 -1,
 262672371,
 126585,
 262999983,
 262620206,
 -1,
 -61522,
 262944253,
 126583,
 -1,
 263000171,
 126570,
 263196594,
 262944212,
 -1,
 -61519,
 263137856,
 126564,
 -1,
 263196895,
 126567,
 -61517,
 263162610,
 126586,
 -61516,
 263358971,
 126569,
 -61515,
 263414928,
 126578,
 -61514,
 263476802,
 126573,
 -61513,
 263540932,
 126572,
 -61512,
 263603120,
 126562,
 -61511,
 263664727,
 126587,
 -61510,
 263729096,
 126576,
 -61509,
 263788484,
 126561,
 -1,
 263852290,
 126575,
 -61507,
 262027267,
 126484,
 -61506,
 263989713,
 126478,
 -1,
 264048627,
 126481,
 264245208,
 261963742,
 -1,
 264310724,
 264203715,
 -1,
 -61502,
 264255491,
 126516,
 -61501,
 264317393,
 126510,
 -1,
 264376307,
 126513,
 264572871,
 264271371,
 -1,
 -61498,
 264517640,
 126518,
 -1,
 264579648,
 126517,
 264769482,
 264520750,
 -1,
 -61495,
 264713725,
 126519,
 -1,
 264769643,
 126506,
 264966093,
 264713684,
 -1,
 -61492,
 264907328,
 126500,
 -1,
 264966367,
 126503,
 -61490,
 264931835,
 126505,
 -61489,
 265118864,
 126514,
 -61488,
 265180738,
 126509,
 -61487,
 265244868,
 126508,
 -61486,
 265307878,
 126507,
 -61485,
 265372592,
 126498,
 -61484,
 265434199,
 126523,
 -61483,
 265498568,
 126512,
 -61482,
 265560896,
 126521,
 -61481,
 265623492,
 126497,
 -1,
 265687298,
 126511,
 265883634,
 264205835,
 -1,
 265949166,
 265817748,
 -1,
 266014701,
 265895304,
 -1,
 266080223,
 265973187,
 -1,
 -61475,
 266024963,
 126548,
 -61474,
 266086865,
 126542,
 -1,
 266145779,
 126545,
 266342372,
 266019472,
 -1,
 266407907,
 266296591,
 -1,
 -61470,
 266364048,
 126559,
 -1,
 266425922,
 126557,
 -1,
 266342387,
 126553,
 -61467,
 266308091,
 126537,
 -61466,
 266626192,
 126546,
 -61465,
 266688066,
 126541,
 -61464,
 266749670,
 126539,
 -61463,
 266814793,
 126551,
 -61462,
 266879920,
 126530,
 -61461,
 266941949,
 126535,
 -61460,
 267007063,
 126555,
 -1,
 267063554,
 126543,
 -1,
 265958868,
 126472,
 267325425,
 265893332,
 -1,
 -61456,
 267266624,
 126486,
 -1,
 267325824,
 126488,
 -1,
 267266624,
 126485,
 267587573,
 265849583,
 -1,
 -61452,
 267533780,
 126470,
 -1,
 267597268,
 126490,
 267784184,
 267541469,
 -1,
 -61449,
 267735252,
 126704,
 -1,
 267793921,
 126705,
 267980795,
 267732014,
 -1,
 -61446,
 267924989,
 126487,
 -1,
 267980907,
 126474,
 268177406,
 267914900,
 -1,
 -61443,
 268126405,
 126464,
 -1,
 268189140,
 126479,
 -61441,
 268143099,
 126473,
 -61440,
 268338415,
 126469,
 -61439,
 268396635,
 126483,
 -61438,
 268461200,
 126482,
 -61437,
 268523074,
 126477,
 -61436,
 268587204,
 126476,
 -61435,
 268649392,
 126466,
 -61434,
 268711421,
 126471,
 -61433,
 268776535,
 126491,
 -61432,
 268840904,
 126480,
 -1,
 268900292,
 126465,
 -1,
 256797712,
 2303,
 269160519,
 256732611,
 -1,
 269226021,
 269126286,
 -1,
 269291545,
 269186571,
 -1,
 269357075,
 269256663,
 -1,
 269422609,
 269320896,
 -1,
 -61424,
 269359075,
 64446,
 -1,
 269422392,
 64445,
 -61422,
 269359075,
 64437,
 -1,
 269553464,
 64436,
 269811711,
 269302204,
 -1,
 269815831,
 269705897,
 -1,
 -61418,
 269752291,
 64441,
 -1,
 269815608,
 64440,
 -61416,
 269752291,
 64439,
 -1,
 269946680,
 64438,
 270143518,
 269231440,
 -1,
 270209053,
 270104077,
 -1,
 -61412,
 270145507,
 64435,
 -1,
 270208824,
 64434,
 -1,
 270171476,
 64444,
 270471201,
 270103257,
 -1,
 -61408,
 270407651,
 64449,
 -1,
 270470968,
 64448,
 270667812,
 270414313,
 -1,
 -61405,
 270604259,
 64443,
 -1,
 270667576,
 64442,
 -1,
 270625552,
 64447,
 270929978,
 269176651,
 -1,
 270995513,
 270874742,
 -1,
 271061042,
 270959657,
 -1,
 271126577,
 271014982,
 -1,
 271192110,
 271060628,
 -1,
 -61397,
 271153033,
 2266,
 -61396,
 271216160,
 2267,
 -61395,
 271279551,
 2260,
 -1,
 271340484,
 2268,
 -61393,
 271156361,
 2271,
 -61392,
 271478335,
 2269,
 -1,
 271541423,
 2270,
 -1,
 271062657,
 2291,
 271781941,
 271019459,
 -1,
 -61388,
 271727909,
 2273,
 -1,
 271781875,
 2261,
 -61386,
 271738000,
 2263,
 -61385,
 271930951,
 2264,
 -61384,
 271987054,
 2272,
 -1,
 272044290,
 2262,
 -1,
 270945740,
 2265,
 272306246,
 270871685,
 -1,
 272371781,
 272271871,
 -1,
 272437312,
 272305812,
 -1,
 272502847,
 272386245,
 983621,
 -1,
 272433808,
 983623,
 -1,
 272443415,
 983628,
 -61375,
 272403178,
 983626,
 -61374,
 272663791,
 983622,
 -61373,
 272727119,
 983625,
 -61372,
 272783475,
 983624,
 -1,
 272836631,
 983627,
 -1,
 272324183,
 983629,
 -1,
 272252207,
 1540,
 273158263,
 269109311,
 -1,
 273223796,
 273120088,
 -1,
 273289295,
 273157780,
 -1,
 273354830,
 273232521,
 -1,
 -61364,
 273310864,
 2236,
 -61363,
 273372738,
 2237,
 -1,
 273428424,
 2235,
 -1,
 273300968,
 2227,
 273682515,
 273254938,
 -1,
 -61359,
 273642165,
 2234,
 -61358,
 273692302,
 2216,
 -1,
 273753482,
 2217,
 273944664,
 273638777,
 -1,
 274010199,
 273885763,
 -1,
 -61354,
 273969845,
 2233,
 -1,
 274025828,
 2218,
 -1,
 273963190,
 2220,
 274272349,
 273881032,
 -1,
 274337884,
 274231899,
 -1,
 -61349,
 274301368,
 2208,
 -1,
 274354377,
 2230,
 -1,
 274282126,
 2209,
 274600032,
 274232843,
 -1,
 -61345,
 274541132,
 2232,
 -1,
 274600162,
 2211,
 274796643,
 274558403,
 -1,
 -61342,
 274758206,
 2225,
 -1,
 274796542,
 2223,
 274993254,
 274747053,
 -1,
 -61339,
 274934199,
 2215,
 -1,
 274994235,
 1564,
 275189865,
 274941476,
 -1,
 -61336,
 275144492,
 2221,
 -1,
 275190292,
 2214,
 275386476,
 275137669,
 -1,
 -61333,
 275345644,
 1568,
 -1,
 275394353,
 2228,
 -61331,
 275352310,
 2226,
 -61330,
 275547379,
 2219,
 -61329,
 275604628,
 2213,
 -61328,
 275669252,
 2231,
 -61327,
 275727285,
 2210,
 -61326,
 275788617,
 2224,
 -61325,
 275853260,
 2212,
 -1,
 275915598,
 2222,
 276168703,
 273167069,
 -1,
 -61322,
 276043747,
 2297,
 -1,
 276107064,
 2295,
 276304003,
 273118731,
 -1,
 276369538,
 276257322,
 -1,
 276435068,
 276331528,
 -1,
 -61317,
 276371427,
 2286,
 -1,
 276434744,
 2283,
 276631679,
 276388399,
 -1,
 -61314,
 276568035,
 2285,
 -1,
 276631352,
 2282,
 276889599,
 276581737,
 -1,
 -61311,
 276764643,
 2287,
 -1,
 276827960,
 2284,
 -1,
 276332734,
 2275,
 277090442,
 276243003,
 -1,
 277155974,
 277038283,
 2278,
 -1,
 277116650,
 2281,
 277287048,
 277098392,
 2276,
 -1,
 277247722,
 2279,
 277479423,
 277226363,
 2277,
 -1,
 277378794,
 2280,
 277549199,
 277029520,
 -1,
 277614733,
 277503349,
 2299,
 -1,
 277546494,
 2300,
 -61298,
 277561813,
 2274,
 -1,
 277680711,
 2302,
 277876883,
 277506366,
 -1,
 277942418,
 277811000,
 2296,
 -1,
 277874174,
 2301,
 -1,
 277878755,
 2298,
 278139031,
 277830570,
 -1,
 -61291,
 278086886,
 2290,
 -61290,
 278146986,
 2288,
 -1,
 278209409,
 2289,
 278401178,
 278081438,
 -1,
 -61287,
 278358800,
 2292,
 -1,
 278406538,
 2293,
 -61285,
 278365406,
 1631,
 -61284,
 278550369,
 1541,
 -1,
 278611153,
 2294,
 278794400,
 256669830,
 -1,
 -61281,
 278754350,
 127912,
 -1,
 278798844,
 128667,
 -1,
 278745374,
 1423,
 279056713,
 256591396,
 -1,
 279122245,
 278994309,
 -1,
 279187644,
 279080387,
 -1,
 279253166,
 279149647,
 -1,
 279318701,
 279189904,
 -1,
 279384236,
 279259215,
 -1,
 279449770,
 279342678,
 -1,
 -61271,
 279388331,
 128807,
 -1,
 279450477,
 128814,
 -61269,
 279388331,
 128802,
 -1,
 279581549,
 128812,
 -1,
 279331003,
 128862,
 -1,
 279268185,
 128781,
 279908532,
 279187840,
 -1,
 279974067,
 279868939,
 128788,
 280100863,
 279905006,
 -1,
 -61262,
 279978162,
 128806,
 -1,
 280040301,
 128813,
 -1,
 279906217,
 128825,
 280301752,
 279868939,
 -1,
 280367287,
 280258259,
 128860,
 -1,
 280299427,
 128861,
 -1,
 280302741,
 128850,
 -61255,
 280256983,
 128839,
 -61254,
 280516594,
 128852,
 -61253,
 280575379,
 128795,
 -1,
 280632552,
 128847,
 280826063,
 279121556,
 -1,
 280891588,
 280782015,
 -1,
 280957123,
 280821760,
 -1,
 281022657,
 280920962,
 128776,
 -1,
 280954787,
 128777,
 281214975,
 280979541,
 128774,
 -1,
 281085859,
 128775,
 -1,
 280899999,
 128773,
 281350345,
 280839716,
 -1,
 281415879,
 281298084,
 128822,
 -1,
 281348003,
 128823,
 -61240,
 281378431,
 128837,
 -1,
 281488165,
 128874,
 -61238,
 281313448,
 128829,
 -61237,
 281637006,
 128855,
 -61236,
 281701729,
 128826,
 -61235,
 281761597,
 128811,
 -61234,
 281825087,
 128859,
 -1,
 281886987,
 128769,
 282071267,
 280763203,
 -1,
 282136795,
 282027385,
 -1,
 282202327,
 282099111,
 128869,
 282329087,
 282134433,
 -1,
 -61228,
 282200994,
 128873,
 -61227,
 282266374,
 128872,
 -61226,
 282331725,
 128871,
 -1,
 282397045,
 128870,
 282656767,
 282155097,
 -1,
 282661082,
 282534059,
 128803,
 -1,
 282593187,
 128804,
 -1,
 282608005,
 128798,
 282857695,
 282070676,
 -1,
 -61219,
 282813539,
 128846,
 -61218,
 282873506,
 128844,
 -1,
 282929107,
 128848,
 283119842,
 282811371,
 -1,
 -61215,
 283073625,
 128800,
 -1,
 283120481,
 128805,
 -1,
 283066343,
 128787,
 283382003,
 282027385,
 -1,
 283447537,
 283322391,
 -1,
 283513070,
 283391395,
 128818,
 283578602,
 283445153,
 -1,
 -61208,
 283511558,
 128821,
 -61207,
 283576909,
 128820,
 -1,
 283642229,
 128819,
 283901951,
 283509486,
 -1,
 283906285,
 283775853,
 128816,
 -1,
 283838371,
 128817,
 -1,
 283853189,
 128799,
 284102896,
 283447736,
 128827,
 -1,
 284034979,
 128828,
 -1,
 284064240,
 128877,
 284360703,
 283400233,
 128792,
 -1,
 284231587,
 128793,
 284430590,
 283317938,
 -1,
 284496120,
 284384321,
 128834,
 284622847,
 284428193,
 -1,
 -61193,
 284494413,
 128836,
 -1,
 284559733,
 128835,
 284758267,
 284431802,
 -1,
 -61190,
 284721623,
 128876,
 -1,
 284774354,
 128875,
 -61188,
 284715280,
 128857,
 -61187,
 284903088,
 128783,
 -1,
 284967345,
 128830,
 285151496,
 284393910,
 -1,
 285217031,
 285096604,
 -1,
 285282565,
 285168783,
 128778,
 285348100,
 285214625,
 -1,
 -61181,
 285280845,
 128780,
 -1,
 285346165,
 128779,
 -1,
 285278963,
 128815,
 285671423,
 285244179,
 128790,
 -1,
 285542307,
 128791,
 -1,
 285158628,
 128808,
 285806866,
 285106074,
 -1,
 285872397,
 285759422,
 -1,
 285937932,
 285836597,
 128843,
 -1,
 285878605,
 128858,
 -1,
 285898267,
 128856,
 286134544,
 285834319,
 -1,
 -61169,
 286095971,
 128868,
 -1,
 286157100,
 128867,
 -61167,
 286091176,
 128863,
 -1,
 286275744,
 128782,
 286462234,
 285767179,
 -1,
 286527766,
 286408148,
 -1,
 -61163,
 286466545,
 128840,
 -1,
 286524221,
 128809,
 286724376,
 286463229,
 128831,
 -1,
 286656419,
 128832,
 -61159,
 286687659,
 128845,
 -1,
 286812437,
 128849,
 286986529,
 286412461,
 -1,
 287052063,
 286928083,
 128784,
 287178751,
 286984097,
 -1,
 -61154,
 287050317,
 128786,
 -1,
 287115637,
 128785,
 -61152,
 287005473,
 128881,
 -1,
 287249378,
 128824,
 287445288,
 286930388,
 -1,
 287510821,
 287397822,
 -1,
 -61148,
 287473767,
 128878,
 -1,
 287534424,
 128854,
 287768575,
 287445415,
 -1,
 -61145,
 287661503,
 128883,
 -1,
 287713200,
 128882,
 287904046,
 287384208,
 -1,
 287969581,
 287850904,
 -1,
 288035116,
 287929154,
 128865,
 -1,
 287967139,
 128866,
 -1,
 287996132,
 128864,
 -1,
 287905421,
 128880,
 288297266,
 287850885,
 -1,
 288362801,
 288228157,
 128796,
 -1,
 288294819,
 128797,
 -1,
 288294835,
 128801,
 288559413,
 288261185,
 -1,
 -61132,
 288524498,
 128842,
 -1,
 288585570,
 128772,
 288756024,
 288515445,
 -1,
 -61129,
 288708397,
 128768,
 -1,
 288759457,
 128833,
 288952635,
 288707920,
 -1,
 -61126,
 288914015,
 128789,
 -1,
 288961657,
 128879,
 289149246,
 288900644,
 -1,
 -61123,
 289101925,
 128851,
 -1,
 289155230,
 128810,
 289345857,
 289092369,
 -1,
 -61120,
 289308287,
 128841,
 -1,
 289364275,
 128794,
 -61118,
 289308834,
 128853,
 -61117,
 289495237,
 128838,
 -61116,
 289550466,
 128770,
 -1,
 289614029,
 128771,
 -61114,
 279072429,
 983201,
 -61113,
 289750036,
 128126,
 -61112,
 289811805,
 983054,
 -1,
 289870952,
 9200,
 290066874,
 278995600,
 -1,
 290132409,
 290014954,
 -1,
 290197879,
 290069315,
 -1,
 290263414,
 290132904,
 -1,
 290328913,
 290214774,
 -1,
 -61105,
 290294208,
 125209,
 -61104,
 290356916,
 125200,
 -1,
 290403810,
 125211,
 290591061,
 290276398,
 -1,
 -61101,
 290546304,
 125216,
 -61100,
 290600418,
 125213,
 -1,
 290656363,
 125201,
 290853208,
 290556276,
 -1,
 -61097,
 290797410,
 125198,
 -1,
 290852500,
 125202,
 291049819,
 290811331,
 -1,
 -61094,
 290996207,
 125189,
 -1,
 291059170,
 125217,
 291246430,
 290992913,
 -1,
 -61091,
 291182497,
 125214,
 -1,
 291245716,
 125208,
 291443041,
 291185296,
 -1,
 -61088,
 291386850,
 125197,
 -1,
 291442395,
 125185,
 291639652,
 291378866,
 -1,
 -61085,
 291583842,
 125191,
 -1,
 291638932,
 125188,
 -61083,
 291605280,
 125215,
 -61082,
 291800303,
 125199,
 -61081,
 291865032,
 125212,
 -61080,
 291929167,
 125203,
 -61079,
 291994479,
 125210,
 -61078,
 292054477,
 125192,
 -61077,
 292119691,
 125207,
 -61076,
 292184296,
 125190,
 -61075,
 292247486,
 125196,
 -61074,
 292311566,
 125187,
 -61073,
 292374133,
 125186,
 -61072,
 292439012,
 125204,
 -61071,
 292502172,
 125195,
 -61070,
 292566498,
 125206,
 -61069,
 292630352,
 125194,
 -61068,
 292694039,
 125193,
 -61067,
 292756908,
 125205,
 -1,
 292819390,
 125184,
 -1,
 290216712,
 125256,
 293081505,
 290157167,
 -1,
 293147004,
 293032822,
 -1,
 -61062,
 293112256,
 125243,
 -61061,
 293174964,
 125234,
 -1,
 293221858,
 125245,
 293409152,
 293094446,
 -1,
 -61058,
 293364352,
 125250,
 -61057,
 293418466,
 125247,
 -1,
 293474411,
 125235,
 293671299,
 293374324,
 -1,
 -61054,
 293615458,
 125232,
 -1,
 293670548,
 125236,
 293867910,
 293629379,
 -1,
 -61051,
 293814255,
 125223,
 -1,
 293877218,
 125251,
 294064521,
 293810961,
 -1,
 -61048,
 294000545,
 125248,
 -1,
 294063764,
 125242,
 294261132,
 294003344,
 -1,
 -61045,
 294204898,
 125231,
 -1,
 294260443,
 125219,
 294457743,
 294196914,
 -1,
 -61042,
 294401890,
 125225,
 -1,
 294456980,
 125222,
 -61040,
 294423328,
 125249,
 -61039,
 294618351,
 125233,
 -61038,
 294683080,
 125246,
 -61037,
 294747215,
 125237,
 -61036,
 294812527,
 125244,
 -61035,
 294872525,
 125226,
 -61034,
 294937739,
 125241,
 -61033,
 295002344,
 125224,
 -61032,
 295065534,
 125230,
 -61031,
 295129614,
 125221,
 -61030,
 295192181,
 125220,
 -61029,
 295257060,
 125238,
 -61028,
 295320220,
 125229,
 -61027,
 295384546,
 125240,
 -61026,
 295448400,
 125228,
 -61025,
 295512087,
 125227,
 -61024,
 295574956,
 125239,
 -1,
 295637438,
 125218,
 295834031,
 293020890,
 -1,
 295899557,
 295794187,
 -1,
 -61020,
 295864276,
 125266,
 -1,
 295909808,
 125267,
 296096168,
 295857603,
 -1,
 -61017,
 296043268,
 125270,
 -1,
 296103519,
 125271,
 296292779,
 296038188,
 -1,
 -61014,
 296246747,
 125268,
 -1,
 296305254,
 125269,
 -61012,
 296258417,
 125264,
 -61011,
 296442406,
 125265,
 -61010,
 296506729,
 125273,
 -1,
 296561255,
 125272,
 296751538,
 295780318,
 -1,
 -61007,
 296707408,
 125279,
 -1,
 296759004,
 125278,
 296948149,
 296694760,
 -1,
 -61004,
 296894655,
 125254,
 -1,
 296953899,
 125257,
 -61002,
 296911863,
 125253,
 -61001,
 297097043,
 125258,
 -61000,
 297154184,
 125255,
 -1,
 297210307,
 125252,
 -1,
 290083432,
 127903,
 297472521,
 290011447,
 -1,
 297538015,
 297421467,
 -1,
 297603520,
 297489270,
 -1,
 -60994,
 297568704,
 71440,
 -60993,
 297612087,
 71426,
 -1,
 297668244,
 71427,
 297865668,
 297537172,
 71442,
 297992191,
 297815646,
 -1,
 -60989,
 297891458,
 71429,
 -1,
 297939767,
 71446,
 298127815,
 297825803,
 -1,
 -60986,
 298071522,
 71436,
 -1,
 298126996,
 71428,
 298324426,
 298082202,
 -1,
 -60983,
 298268130,
 71431,
 -1,
 298323604,
 71430,
 298521037,
 298271790,
 -1,
 -60980,
 298464738,
 71425,
 -1,
 298520212,
 71424,
 298717648,
 298468207,
 -1,
 -60977,
 298661346,
 71449,
 -1,
 298716820,
 71434,
 298914259,
 298660625,
 -1,
 -60974,
 298857954,
 71447,
 -1,
 298913428,
 71445,
 299110870,
 298853008,
 -1,
 -60971,
 299054562,
 71444,
 -1,
 299110036,
 71443,
 299307481,
 299046578,
 -1,
 -60968,
 299251170,
 71448,
 -1,
 299306644,
 71432,
 -60966,
 299265576,
 71439,
 -60965,
 299460045,
 71437,
 -60964,
 299519734,
 71433,
 -60963,
 299583086,
 71438,
 -60962,
 299644386,
 71441,
 -1,
 299703605,
 71435,
 299897323,
 297501704,
 -1,
 299962853,
 299830932,
 71456,
 -60958,
 299926569,
 71463,
 -60957,
 299978413,
 71466,
 -60956,
 300038812,
 71465,
 -1,
 300093076,
 71457,
 300290535,
 299924559,
 71460,
 -1,
 300252239,
 71461,
 300421609,
 300235420,
 71458,
 -1,
 300366492,
 71459,
 -60950,
 300373950,
 71464,
 -1,
 300492823,
 71462,
 300683769,
 299836634,
 -1,
 300749295,
 300643851,
 -1,
 -60946,
 300713940,
 71474,
 -1,
 300759472,
 71475,
 300945906,
 300707267,
 -1,
 -60943,
 300892932,
 71478,
 -1,
 300953183,
 71479,
 301142517,
 300887852,
 -1,
 -60940,
 301096411,
 71476,
 -1,
 301154918,
 71477,
 -60938,
 301108081,
 71472,
 -60937,
 301292070,
 71473,
 -60936,
 301356393,
 71481,
 -1,
 301410919,
 71480,
 301601281,
 300641731,
 -1,
 301666816,
 301546752,
 -1,
 301732350,
 301624771,
 -1,
 -60931,
 301682555,
 71484,
 -1,
 301738295,
 71485,
 -60929,
 301690278,
 71486,
 -1,
 301876564,
 71467,
 -1,
 301632190,
 71487,
 302125574,
 301539388,
 -1,
 302191109,
 302073380,
 -1,
 -60924,
 302136376,
 71455,
 -1,
 302190228,
 71453,
 -1,
 302147021,
 71454,
 302514175,
 302077811,
 -1,
 -60920,
 302417256,
 71483,
 -1,
 302459719,
 71482,
 302649870,
 297434191,
 -1,
 302715405,
 302610840,
 -1,
 -60916,
 302667766,
 128663,
 -1,
 302716307,
 127975,
 -1,
 302651399,
 127814,
 302977554,
 302599853,
 -1,
 -60912,
 302932396,
 127994,
 -60911,
 302984448,
 127944,
 -1,
 303045349,
 128657,
 303239701,
 302937127,
 -1,
 -60908,
 303197303,
 9954,
 -1,
 303258305,
 128562,
 303436312,
 303194010,
 -1,
 -60905,
 303391293,
 983194,
 -1,
 303438659,
 983195,
 303632923,
 303382922,
 -1,
 -60902,
 303572005,
 128747,
 -1,
 303633571,
 128748,
 303829533,
 303570581,
 983053,
 -1,
 303781549,
 983052,
 -60898,
 303793040,
 129361,
 -60897,
 303921111,
 128095,
 -1,
 303967474,
 128673,
 304158673,
 213194418,
 -1,
 304223740,
 304090772,
 -1,
 304289108,
 304173902,
 -1,
 304354050,
 304228377,
 -1,
 304419424,
 304305014,
 -1,
 304484927,
 304362257,
 -1,
 304550447,
 304432174,
 -1,
 304615978,
 304512079,
 -1,
 -60887,
 304570266,
 92598,
 -1,
 304631469,
 92619,
 304812589,
 304557533,
 -1,
 -60884,
 304777426,
 92543,
 -1,
 304812063,
 92553,
 305070079,
 304746132,
 92531,
 -1,
 304943678,
 92601,
 305140280,
 304493329,
 -1,
 305205812,
 305101903,
 -1,
 -60878,
 305161703,
 92550,
 -60877,
 305225626,
 92624,
 -1,
 305270871,
 92563,
 305528831,
 305145879,
 -1,
 305533495,
 305429725,
 92607,
 -1,
 305493515,
 92535,
 -1,
 305473948,
 92557,
 305730106,
 305102045,
 92640,
 -1,
 305690123,
 92657,
 305861181,
 305682366,
 -1,
 -60868,
 305816710,
 92544,
 -1,
 305880986,
 92541,
 -60866,
 305802803,
 92579,
 -1,
 305991316,
 92658,
 306188873,
 304423568,
 -1,
 306254405,
 306122388,
 -1,
 306319940,
 306187926,
 -1,
 -60861,
 306279225,
 92562,
 -1,
 306336613,
 92637,
 -1,
 306274202,
 92518,
 306582088,
 306199196,
 -1,
 -60857,
 306537606,
 92558,
 -1,
 306582475,
 92592,
 -1,
 306544308,
 92528,
 306844239,
 306135919,
 -1,
 306909774,
 306784279,
 -1,
 306975309,
 306849815,
 92628,
 -1,
 306905554,
 92648,
 -1,
 306938291,
 92547,
 -1,
 306843689,
 92554,
 307237460,
 306802645,
 -1,
 307302995,
 307199055,
 -1,
 -60846,
 307256187,
 92527,
 -1,
 307308567,
 92545,
 -1,
 307248144,
 92540,
 307565143,
 307202797,
 -1,
 -60842,
 307527770,
 92609,
 -1,
 307565515,
 92583,
 307761754,
 307530312,
 -1,
 -60839,
 307699444,
 92589,
 -1,
 307763231,
 92608,
 307958365,
 307721739,
 -1,
 -60836,
 307920511,
 92604,
 -1,
 307958659,
 92622,
 308154975,
 307891860,
 92662,
 -1,
 308094999,
 92613,
 -1,
 308102578,
 92584,
 308351608,
 304373658,
 -1,
 308417127,
 308313167,
 92576,
 308482661,
 308350612,
 -1,
 -60828,
 308438150,
 92618,
 -1,
 308488215,
 92529,
 -60826,
 308432557,
 92561,
 -1,
 308619287,
 92649,
 308810349,
 308350612,
 -1,
 308875882,
 308743828,
 92524,
 -1,
 308825773,
 92536,
 309067775,
 308806559,
 -1,
 -60820,
 308956822,
 92634,
 -1,
 309013583,
 92625,
 309203569,
 308755100,
 92663,
 309329919,
 309143575,
 -1,
 -60816,
 309229067,
 92621,
 -1,
 309275778,
 92593,
 309465718,
 309143575,
 -1,
 309531253,
 309427279,
 -1,
 -60812,
 309496018,
 92647,
 -1,
 309556747,
 92605,
 -1,
 309472026,
 92548,
 309854207,
 309417918,
 92568,
 -1,
 309746129,
 92610,
 309924491,
 308301485,
 -1,
 309990014,
 309857940,
 92667,
 310055548,
 309930007,
 92600,
 -1,
 310005421,
 92542,
 -60803,
 310011014,
 92668,
 -1,
 310140826,
 92555,
 310317696,
 309934748,
 92654,
 -1,
 310258073,
 92611,
 310448771,
 310260655,
 -1,
 -60798,
 310389575,
 92581,
 -1,
 310447764,
 92551,
 310645382,
 310384545,
 -1,
 -60795,
 310607487,
 92520,
 -1,
 310650903,
 92582,
 -60793,
 310608705,
 92617,
 -60792,
 310803677,
 92614,
 -60791,
 310860241,
 92671,
 -60790,
 310915060,
 92591,
 -1,
 310979399,
 92666,
 311169694,
 309884427,
 -1,
 311235218,
 311103124,
 -1,
 311300751,
 311168660,
 92635,
 -1,
 311256198,
 92577,
 -60784,
 311256198,
 92636,
 -60783,
 311381677,
 92530,
 -1,
 311438158,
 92559,
 311628438,
 311196751,
 -1,
 311693973,
 311578285,
 92586,
 -1,
 311627804,
 92569,
 -1,
 311627804,
 92566,
 311890586,
 311580606,
 -1,
 311956121,
 311842750,
 92537,
 -1,
 311907190,
 92519,
 -1,
 311911558,
 92630,
 312213503,
 311830551,
 -1,
 312218269,
 312114255,
 92669,
 -1,
 312152141,
 92572,
 -1,
 312169334,
 92672,
 312414896,
 311134580,
 -1,
 312480420,
 312376399,
 -1,
 -60767,
 312435846,
 92644,
 -60766,
 312497014,
 92645,
 -60765,
 312552578,
 92594,
 -1,
 312610870,
 92641,
 312808105,
 312421853,
 -1,
 312873639,
 312741916,
 92567,
 -1,
 312833547,
 92623,
 -60760,
 312838354,
 92639,
 -1,
 312954541,
 92606,
 313135788,
 312761338,
 -1,
 -60757,
 313095577,
 92642,
 -1,
 313139454,
 92643,
 313332399,
 313080476,
 -1,
 -60754,
 313292299,
 92590,
 -1,
 313338265,
 92564,
 -1,
 313267075,
 92588,
 313594556,
 312372675,
 -1,
 313660086,
 313538004,
 -1,
 313725620,
 313612222,
 92659,
 -1,
 313681030,
 92660,
 -60747,
 313671944,
 92638,
 -1,
 313798143,
 92580,
 313987769,
 313600023,
 -1,
 -60744,
 313947659,
 92560,
 -1,
 313993239,
 92534,
 -60742,
 313949414,
 92571,
 -60741,
 314136939,
 92525,
 -1,
 314183384,
 92549,
 314381001,
 313542180,
 -1,
 314446531,
 314333118,
 -1,
 314512065,
 314398654,
 -1,
 -60736,
 314471947,
 92556,
 -1,
 314528630,
 92523,
 -60734,
 314467462,
 92664,
 -1,
 314658477,
 92539,
 314839751,
 314379924,
 -1,
 -60731,
 314795142,
 92633,
 -60730,
 314859418,
 92521,
 -1,
 314905105,
 92575,
 -60728,
 314801231,
 92653,
 -1,
 315043308,
 92595,
 315232982,
 314328110,
 -1,
 315298510,
 315194447,
 -1,
 -60724,
 315258379,
 92620,
 -60723,
 315317115,
 92538,
 -1,
 315370916,
 92587,
 315560659,
 315238423,
 -1,
 315626194,
 315522127,
 -1,
 -60719,
 315590866,
 92646,
 -1,
 315625500,
 92570,
 -1,
 315586059,
 92599,
 -60716,
 315515276,
 92532,
 -60715,
 315840446,
 92665,
 -1,
 315898524,
 92670,
 316084962,
 315174700,
 -1,
 316150494,
 316046415,
 -1,
 316216028,
 316080128,
 -1,
 -60710,
 316172417,
 92661,
 -60709,
 316226204,
 92616,
 -1,
 316283801,
 92626,
 316538879,
 316155927,
 92596,
 -1,
 316438027,
 92612,
 316609248,
 316083860,
 92603,
 -1,
 316564614,
 92673,
 -60703,
 316561771,
 92627,
 -1,
 316680601,
 92651,
 316871407,
 316027665,
 -1,
 316936940,
 316814804,
 -1,
 317002474,
 316876823,
 -1,
 317068009,
 316963919,
 -1,
 -60697,
 317032658,
 92552,
 -60696,
 317084534,
 92565,
 -1,
 317132828,
 92615,
 -1,
 317027851,
 92602,
 -60693,
 316954987,
 92674,
 -1,
 317329124,
 92578,
 317587455,
 316872609,
 -1,
 -60690,
 317489587,
 92597,
 -1,
 317552139,
 92585,
 317723381,
 316827001,
 -1,
 317788915,
 317656724,
 -1,
 -60686,
 317744262,
 92526,
 -1,
 317794327,
 92656,
 -60684,
 317734324,
 92546,
 -1,
 317927003,
 92655,
 318116602,
 317686825,
 -1,
 318182137,
 318078031,
 -1,
 -60680,
 318134206,
 92533,
 -1,
 318187543,
 92650,
 -1,
 318123611,
 92574,
 318444287,
 318079414,
 -1,
 318509822,
 318384151,
 -1,
 -60675,
 318471389,
 92573,
 -1,
 318515223,
 92652,
 -1,
 318462315,
 92522,
 -60672,
 318396350,
 92631,
 -60671,
 318716572,
 92632,
 -1,
 318770836,
 92629,
 318968745,
 304292498,
 -1,
 319034167,
 318919542,
 -1,
 319099669,
 318976785,
 -1,
 319165197,
 319046702,
 -1,
 319230729,
 319106525,
 -1,
 -60664,
 319187193,
 92432,
 -1,
 319230029,
 92457,
 -60662,
 319195639,
 92435,
 -60661,
 319389364,
 92412,
 -60660,
 319437840,
 92476,
 -1,
 319492995,
 92414,
 319750143,
 319107857,
 -1,
 319755026,
 319622804,
 -1,
 319820561,
 319689233,
 92465,
 -1,
 319754268,
 92409,
 -1,
 319774618,
 92483,
 -60653,
 319718472,
 92467,
 -60652,
 319979260,
 92485,
 -1,
 320024155,
 92475,
 320213789,
 319046511,
 -1,
 320279320,
 320158364,
 92403,
 -1,
 320219545,
 92405,
 320410395,
 320220637,
 -1,
 -60646,
 320370187,
 92407,
 -1,
 320409631,
 92430,
 -60644,
 320372211,
 92487,
 -1,
 320541571,
 92418,
 320738085,
 320171459,
 -1,
 320803617,
 320683024,
 -1,
 -60640,
 320763403,
 92459,
 -1,
 320823194,
 92447,
 321000228,
 320746964,
 -1,
 -60637,
 320962909,
 92486,
 -1,
 321005977,
 92408,
 -1,
 320962175,
 92480,
 321262378,
 320702836,
 -1,
 -60633,
 321224148,
 92463,
 -60632,
 321272476,
 92493,
 -60631,
 321334692,
 92450,
 -1,
 321393169,
 92410,
 321590064,
 321200784,
 -1,
 321655598,
 321529879,
 -1,
 -60627,
 321618355,
 92425,
 -1,
 321660951,
 92437,
 -60625,
 321608145,
 92440,
 -1,
 321786385,
 92471,
 321983285,
 321549835,
 -1,
 322048820,
 321923095,
 -1,
 -60621,
 322010751,
 92472,
 -1,
 322054167,
 92505,
 -1,
 322011568,
 92514,
 -60618,
 321944655,
 92503,
 -1,
 322255516,
 92507,
 322442066,
 318983853,
 92497,
 322507583,
 322383660,
 -1,
 322573115,
 322459582,
 92445,
 -1,
 322524022,
 92404,
 322704190,
 322514397,
 -1,
 -60611,
 322663947,
 92424,
 -1,
 322703388,
 92458,
 -1,
 322649104,
 92466,
 322966339,
 322450351,
 -1,
 -60607,
 322918546,
 92438,
 -60606,
 322976784,
 92444,
 -1,
 323038738,
 92442,
 323228488,
 322906135,
 -1,
 323294023,
 323189839,
 -1,
 -60602,
 323253771,
 92427,
 -1,
 323310454,
 92478,
 -1,
 323234204,
 92496,
 323556172,
 323163826,
 -1,
 323621707,
 323489496,
 92448,
 -1,
 323552315,
 92515,
 -1,
 323583737,
 92401,
 323818319,
 323489428,
 -1,
 -60594,
 323766463,
 92426,
 -1,
 323824583,
 92482,
 -60592,
 323781581,
 92510,
 -60591,
 323976271,
 92499,
 -1,
 324033213,
 92441,
 324211557,
 322399683,
 -1,
 324277084,
 324154836,
 -1,
 324342617,
 324216855,
 -1,
 324408152,
 324303951,
 -1,
 -60585,
 324372690,
 92501,
 -1,
 324407324,
 92417,
 -1,
 324347927,
 92413,
 -60582,
 324303951,
 92504,
 -60581,
 324623351,
 92508,
 -1,
 324681031,
 92500,
 324866912,
 324238415,
 -1,
 -60578,
 324828239,
 92498,
 -60577,
 324872215,
 92419,
 -1,
 324931612,
 92473,
 325129059,
 324800148,
 -1,
 -60574,
 325084294,
 92516,
 -1,
 325148570,
 92423,
 -60572,
 325082295,
 92452,
 -1,
 325266943,
 92428,
 325456755,
 324158510,
 -1,
 325522285,
 325396503,
 -1,
 325587820,
 325483599,
 -1,
 -60567,
 325541786,
 92460,
 -60566,
 325606597,
 92431,
 -60565,
 325668525,
 92454,
 -1,
 325718115,
 92415,
 -1,
 325547531,
 92420,
 325981041,
 325483599,
 92489,
 -60561,
 325936262,
 92479,
 -60560,
 325998955,
 92422,
 -1,
 326062966,
 92474,
 -60558,
 325945847,
 92502,
 -1,
 326206541,
 92449,
 326374271,
 325416459,
 -1,
 326439802,
 326314007,
 -1,
 326505337,
 326401103,
 -1,
 -60553,
 326465035,
 92416,
 -60552,
 326521718,
 92481,
 -1,
 326570038,
 92451,
 -1,
 326445468,
 92456,
 326833020,
 326401103,
 92433,
 -1,
 326786231,
 92477,
 -60547,
 326786039,
 92492,
 -60546,
 326908572,
 92513,
 -1,
 326963228,
 92491,
 327160713,
 326321700,
 -1,
 327226246,
 327100439,
 -1,
 327291780,
 327187535,
 -1,
 -60541,
 327241389,
 92484,
 -1,
 327290947,
 92439,
 -60539,
 327251467,
 92464,
 -1,
 327428508,
 92495,
 -60537,
 327188095,
 92446,
 -60536,
 327572471,
 92511,
 -1,
 327629840,
 92406,
 327816082,
 327114650,
 -1,
 327881613,
 327777359,
 -1,
 -60532,
 327844189,
 92443,
 -1,
 327902342,
 92509,
 328078224,
 327821335,
 -1,
 -60529,
 328040804,
 92462,
 -1,
 328083479,
 92506,
 -60527,
 328024264,
 92461,
 -1,
 328209283,
 92469,
 328405914,
 327780724,
 -1,
 328471448,
 328367183,
 -1,
 328536983,
 328423358,
 -1,
 -60522,
 328490906,
 92470,
 -1,
 328552109,
 92468,
 -1,
 328501335,
 92453,
 -60519,
 328411975,
 92429,
 -1,
 328732719,
 92421,
 328930208,
 328361337,
 -1,
 328995742,
 328870730,
 -1,
 -60515,
 328948019,
 92490,
 -1,
 329012032,
 92512,
 -60513,
 328940871,
 92494,
 -1,
 329125919,
 92455,
 329323427,
 328893481,
 -1,
 -60510,
 329284838,
 92411,
 -1,
 329323395,
 92402,
 329520038,
 329266256,
 -1,
 -60507,
 329461223,
 92488,
 -1,
 329518808,
 92434,
 329777151,
 329461548,
 -1,
 -60504,
 329657861,
 92436,
 -1,
 329715416,
 92517,
 329913404,
 318905157,
 -1,
 329978846,
 329864054,
 -1,
 330044344,
 329921297,
 -1,
 330109875,
 329986833,
 -1,
 330175410,
 330071119,
 92362,
 -60497,
 330127825,
 92341,
 -60496,
 330190509,
 92347,
 -60495,
 330246623,
 92370,
 -1,
 330305594,
 92336,
 -1,
 330115911,
 92307,
 330568630,
 330056750,
 -1,
 -60491,
 330530267,
 92303,
 -1,
 330568651,
 92309,
 -60489,
 330520939,
 92368,
 -1,
 330699723,
 92395,
 330896320,
 330001859,
 -1,
 330961852,
 330857551,
 -1,
 -60485,
 330915022,
 92359,
 -1,
 330978166,
 92374,
 -60483,
 330914155,
 92371,
 -60482,
 331101991,
 92351,
 -60481,
 331165170,
 92325,
 -1,
 331222676,
 92350,
 331420617,
 330834576,
 -1,
 331486148,
 331361757,
 -1,
 -60477,
 331445771,
 92349,
 -1,
 331485265,
 92308,
 331682759,
 331419284,
 -1,
 -60474,
 331636634,
 92378,
 -1,
 331697837,
 92375,
 -60472,
 331635117,
 92317,
 -1,
 331824110,
 92331,
 332010449,
 331367279,
 -1,
 332075981,
 331950103,
 -1,
 -60468,
 332038579,
 92389,
 -1,
 332081564,
 92360,
 332272592,
 332009108,
 -1,
 -60465,
 332222125,
 92367,
 -1,
 332278554,
 92356,
 -1,
 332234227,
 92333,
 332534743,
 331970059,
 -1,
 332600277,
 332474391,
 -1,
 -60460,
 332562153,
 92345,
 -1,
 332616566,
 92372,
 -60458,
 332561503,
 92314,
 -1,
 332730072,
 92340,
 332927962,
 332499693,
 -1,
 -60455,
 332869134,
 92323,
 -1,
 332926612,
 92304,
 333124573,
 332861076,
 -1,
 -60452,
 333079686,
 92396,
 -1,
 333141740,
 92338,
 -1,
 333089395,
 92313,
 333386747,
 329928365,
 -1,
 333452273,
 333321906,
 -1,
 333517798,
 333391895,
 -1,
 333583332,
 333478991,
 -1,
 -60445,
 333547730,
 92385,
 -1,
 333598381,
 92315,
 -60443,
 333538791,
 92354,
 -1,
 333720252,
 92311,
 333911017,
 333462172,
 92381,
 -60440,
 333870603,
 92326,
 -1,
 333932838,
 92343,
 334107630,
 333844116,
 -1,
 334173165,
 334040726,
 -1,
 -60436,
 334127541,
 92387,
 -1,
 334175065,
 92318,
 -1,
 334124976,
 92383,
 334495743,
 334068815,
 -1,
 -60432,
 334374935,
 92324,
 -1,
 334434335,
 92364,
 334631928,
 333385364,
 -1,
 334697461,
 334571543,
 -1,
 -60428,
 334655801,
 92363,
 -1,
 334712820,
 92382,
 334954495,
 334626816,
 -1,
 -60425,
 334845700,
 92376,
 -1,
 334906671,
 92339,
 -60423,
 334593245,
 92391,
 -60422,
 335035408,
 92390,
 -1,
 335098808,
 92344,
 335287308,
 333333550,
 -1,
 335352839,
 335226903,
 -1,
 335418371,
 335313999,
 -1,
 335483905,
 335375811,
 -1,
 -60416,
 335427642,
 92319,
 -1,
 335490651,
 92384,
 -60414,
 335433389,
 92386,
 -1,
 335627442,
 92321,
 335811590,
 335369080,
 -1,
 -60411,
 335759315,
 92393,
 -1,
 335818675,
 92394,
 -1,
 335771147,
 92361,
 336073738,
 335313999,
 -1,
 -60407,
 336033291,
 92366,
 -1,
 336092030,
 92373,
 -60405,
 336027755,
 92328,
 -1,
 336203480,
 92329,
 336401427,
 335251828,
 -1,
 336466961,
 336362575,
 -1,
 -60401,
 336431191,
 92388,
 -60400,
 336481965,
 92305,
 -1,
 336528068,
 92322,
 -60398,
 336408105,
 92327,
 -1,
 336662232,
 92377,
 336860187,
 336360971,
 -1,
 336925719,
 336806412,
 -1,
 -60394,
 336887019,
 92358,
 -1,
 336924352,
 92334,
 337122330,
 336865303,
 -1,
 -60391,
 337084788,
 92346,
 -1,
 337147403,
 92400,
 -1,
 337055472,
 92332,
 337384483,
 336817603,
 -1,
 337450015,
 337327572,
 -1,
 -60386,
 337411571,
 92379,
 -1,
 337461512,
 92392,
 337646626,
 337389591,
 -1,
 -60383,
 337609139,
 92330,
 -1,
 337672055,
 92380,
 -1,
 337607927,
 92335,
 337908777,
 337331748,
 -1,
 337974311,
 337841812,
 -1,
 -60378,
 337928090,
 92342,
 -1,
 337989293,
 92357,
 -60376,
 337935439,
 92365,
 -1,
 338116872,
 92397,
 338301998,
 337862554,
 -1,
 338367533,
 338246300,
 -1,
 -60372,
 338323750,
 92316,
 -1,
 338383734,
 92398,
 -1,
 338307911,
 92399,
 338629683,
 338244369,
 -1,
 338695218,
 338572770,
 -1,
 -60367,
 338650599,
 92310,
 -1,
 338714522,
 92320,
 -1,
 338630526,
 92312,
 338957366,
 338592809,
 -1,
 -60363,
 338919172,
 92369,
 -1,
 338957051,
 92306,
 339153977,
 338920228,
 -1,
 -60360,
 339118290,
 92337,
 -1,
 339152967,
 92353,
 -60358,
 339111315,
 92355,
 -60357,
 339292931,
 92348,
 -1,
 339352301,
 92352,
 339547322,
 329846422,
 -1,
 339612768,
 339497846,
 -1,
 339678276,
 339572235,
 -1,
 339743811,
 339612547,
 92223,
 339869695,
 339673088,
 -1,
 -60350,
 339760936,
 92194,
 -1,
 339824976,
 92185,
 -1,
 339696651,
 92178,
 340071498,
 339620625,
 -1,
 340137032,
 340018654,
 -1,
 -60345,
 340088760,
 92182,
 -1,
 340132511,
 92160,
 -60343,
 340079649,
 92229,
 -1,
 340267816,
 92173,
 340464718,
 340035956,
 -1,
 340530253,
 340408988,
 92239,
 -1,
 340489792,
 92225,
 -1,
 340471204,
 92233,
 340726865,
 340429549,
 -1,
 -60336,
 340688567,
 92191,
 -1,
 340725421,
 92167,
 340923476,
 340684757,
 -1,
 -60333,
 340868112,
 92237,
 -1,
 340922004,
 92241,
 341120087,
 340870190,
 -1,
 -60330,
 341065407,
 92180,
 -1,
 341118698,
 92227,
 341316698,
 341058331,
 -1,
 -60327,
 341250801,
 92212,
 -1,
 341312098,
 92201,
 341513309,
 341249684,
 -1,
 -60324,
 341468294,
 92245,
 -1,
 341511853,
 92164,
 -60322,
 341459869,
 92231,
 -60321,
 341654858,
 92204,
 -1,
 341715783,
 92244,
 341906551,
 339562157,
 -1,
 341972076,
 341839508,
 -1,
 342037610,
 341911575,
 -1,
 342103143,
 341986989,
 92238,
 -60315,
 342065975,
 92174,
 -60314,
 342115774,
 92203,
 -1,
 342169702,
 92171,
 -60312,
 342061369,
 92230,
 -60311,
 342316976,
 92210,
 -1,
 342377783,
 92186,
 -60309,
 341991337,
 92221,
 -1,
 342513418,
 92175,
 342692977,
 341923774,
 -1,
 342758512,
 342645099,
 -1,
 -60305,
 342713431,
 92198,
 -1,
 342765143,
 92214,
 -1,
 342709115,
 92190,
 343020660,
 342628035,
 -1,
 -60301,
 342975622,
 92246,
 -1,
 343037872,
 92232,
 -60299,
 342983464,
 92176,
 -60298,
 343159730,
 92196,
 -1,
 343223830,
 92197,
 343413895,
 341863875,
 -1,
 343479424,
 343356884,
 -1,
 343544956,
 343440463,
 -1,
 -60293,
 343494317,
 92215,
 -1,
 343550962,
 92165,
 343741567,
 343489180,
 -1,
 -60290,
 343696871,
 92222,
 -1,
 343757890,
 92168,
 -1,
 343694334,
 92224,
 344003716,
 343431102,
 -1,
 -60286,
 343963147,
 92235,
 -60285,
 344024198,
 92220,
 -1,
 344085962,
 92208,
 -60283,
 343966128,
 92181,
 -60282,
 344211867,
 92195,
 -1,
 344272418,
 92177,
 344462488,
 343367578,
 -1,
 344528015,
 344395412,
 -1,
 344593548,
 344460948,
 -1,
 -60277,
 344548839,
 92226,
 -1,
 344608429,
 92236,
 -60275,
 344551468,
 92187,
 -60274,
 344740637,
 92189,
 -1,
 344785506,
 92200,
 344986774,
 344480212,
 -1,
 345052307,
 344940503,
 -1,
 -60270,
 344994751,
 92169,
 -1,
 345052867,
 92170,
 345309183,
 345002325,
 -1,
 -60267,
 345191359,
 92162,
 -1,
 345249475,
 92163,
 -60265,
 344948484,
 92205,
 -1,
 345386404,
 92202,
 345576609,
 344409134,
 -1,
 345642140,
 345516055,
 -1,
 -60261,
 345603649,
 92179,
 -1,
 345667083,
 92211,
 345838751,
 345575060,
 -1,
 -60258,
 345793670,
 92240,
 -1,
 345845584,
 92199,
 -60256,
 345800448,
 92213,
 -1,
 345989892,
 92219,
 346166441,
 345536011,
 -1,
 346231973,
 346127439,
 -1,
 -60252,
 346165315,
 92206,
 -1,
 346227336,
 92172,
 346428584,
 346172893,
 -1,
 -60249,
 346388331,
 92209,
 -1,
 346427446,
 92234,
 -1,
 346374686,
 92166,
 346690735,
 346113572,
 -1,
 346756268,
 346651727,
 92243,
 -1,
 346689603,
 92207,
 -60243,
 346708423,
 92216,
 -60242,
 346828199,
 92184,
 -1,
 346887046,
 92183,
 347083956,
 346632977,
 -1,
 347149491,
 347027508,
 -1,
 -60238,
 347104743,
 92188,
 -1,
 347157604,
 92193,
 -1,
 347084950,
 92161,
 347411639,
 347044943,
 -1,
 -60234,
 347362781,
 92228,
 -1,
 347408280,
 92192,
 -60232,
 347374115,
 92242,
 -60231,
 347565171,
 92218,
 -1,
 347615379,
 92217,
 347804939,
 339482292,
 -1,
 347870414,
 347754157,
 -1,
 347935939,
 347805362,
 -1,
 348001472,
 347868820,
 -1,
 -60225,
 347935709,
 92255,
 -1,
 347996800,
 92252,
 -60223,
 347963136,
 92292,
 -60222,
 348144143,
 92268,
 -1,
 348204602,
 92286,
 348394695,
 347868820,
 92300,
 348520447,
 348324559,
 -1,
 -60218,
 348422237,
 92296,
 -1,
 348466680,
 92295,
 348656842,
 348335916,
 -1,
 -60215,
 348608992,
 92267,
 -1,
 348668765,
 92284,
 348853453,
 348597725,
 -1,
 -60212,
 348812877,
 92290,
 -1,
 348873862,
 92281,
 -1,
 348805926,
 92287,
 349115615,
 347820918,
 -1,
 349181143,
 349057809,
 -1,
 349246677,
 349123345,
 -1,
 349312211,
 349208320,
 92282,
 -1,
 349241947,
 92283,
 -60204,
 349253088,
 92277,
 -1,
 349376224,
 92298,
 -60202,
 349198699,
 92302,
 -1,
 349521243,
 92276,
 349705434,
 349145460,
 -1,
 -60199,
 349649595,
 92269,
 -1,
 349704227,
 92288,
 349902045,
 349662659,
 -1,
 -60196,
 349846079,
 92247,
 -1,
 349907783,
 92299,
 -60194,
 349862066,
 92260,
 -1,
 350037947,
 92261,
 350229735,
 349072835,
 -1,
 350295267,
 350173026,
 -1,
 -60190,
 350256368,
 92266,
 -1,
 350320214,
 92265,
 -60188,
 350256596,
 92285,
 -60187,
 350436368,
 92249,
 -60186,
 350498222,
 92250,
 -1,
 350556528,
 92279,
 350754032,
 350176302,
 -1,
 350819564,
 350694877,
 -1,
 -60182,
 350784064,
 92272,
 -60181,
 350839895,
 92270,
 -1,
 350883871,
 92294,
 351081711,
 350763676,
 -1,
 -60178,
 351036550,
 92301,
 -1,
 351087022,
 92253,
 -1,
 351015441,
 92256,
 351343861,
 350707610,
 -1,
 -60174,
 351305442,
 92289,
 -60173,
 351355404,
 92263,
 -60172,
 351414745,
 92257,
 -1,
 351474947,
 92274,
 351671547,
 351290916,
 -1,
 351737081,
 351604372,
 -1,
 -60168,
 351686329,
 92259,
 -1,
 351736440,
 92273,
 -60166,
 351689091,
 92251,
 -1,
 351874468,
 92297,
 352064768,
 351630859,
 -1,
 352130303,
 352025681,
 -1,
 -60162,
 352081668,
 92264,
 -1,
 352145185,
 92248,
 -1,
 352063200,
 92280,
 352392451,
 352029044,
 -1,
 -60158,
 352333357,
 92254,
 -1,
 352391339,
 92258,
 352589062,
 352334955,
 -1,
 -60155,
 352550113,
 92262,
 -1,
 352605046,
 92271,
 352785673,
 352530363,
 -1,
 -60152,
 352747955,
 92291,
 -1,
 352790551,
 92293,
 -60150,
 352749772,
 92278,
 -1,
 352944946,
 92275,
 353173503,
 347746094,
 -1,
 353178906,
 353063798,
 -1,
 353244431,
 353139791,
 92697,
 -1,
 353177628,
 92696,
 353375506,
 353190767,
 -1,
 -60143,
 353336541,
 92698,
 -1,
 353374239,
 92688,
 353572117,
 353317649,
 -1,
 -60140,
 353519117,
 92711,
 -1,
 353579831,
 92712,
 -60138,
 353536581,
 92681,
 -60137,
 353728312,
 92704,
 -60136,
 353792030,
 92702,
 -60135,
 353843868,
 92708,
 -1,
 353903420,
 92687,
 354096419,
 353136067,
 -1,
 354161951,
 354039252,
 -1,
 -60131,
 354122831,
 92700,
 -60130,
 354179006,
 92713,
 -1,
 354237767,
 92691,
 -60128,
 354124208,
 92690,
 -60127,
 354368156,
 92692,
 -60126,
 354430555,
 92693,
 -1,
 354488871,
 92727,
 354686252,
 354042926,
 -1,
 354751783,
 354625559,
 -1,
 -60122,
 354711051,
 92695,
 -1,
 354767734,
 92710,
 -60120,
 354716151,
 92694,
 -60119,
 354909263,
 92677,
 -60118,
 354967508,
 92726,
 -60117,
 355030974,
 92719,
 -1,
 355077780,
 92675,
 355276085,
 354641273,
 -1,
 355341617,
 355215383,
 -1,
 -60113,
 355303859,
 92709,
 -60112,
 355357558,
 92721,
 -1,
 355411991,
 92679,
 355603764,
 355285660,
 -1,
 -60109,
 355547804,
 92683,
 -1,
 355608985,
 92684,
 -1,
 355564623,
 92707,
 355865916,
 355225261,
 92689,
 355931449,
 355800754,
 -1,
 -60104,
 355871559,
 92720,
 -1,
 355929816,
 92724,
 -60102,
 355882942,
 92723,
 -60101,
 356067744,
 92685,
 -1,
 356126356,
 92722,
 356324673,
 355825163,
 -1,
 356390208,
 356257428,
 -1,
 -60097,
 356329495,
 92680,
 -1,
 356388500,
 92686,
 -1,
 356330916,
 92725,
 356652358,
 356278170,
 -1,
 356717893,
 356591639,
 -1,
 -60092,
 356680115,
 92703,
 -1,
 356722711,
 92706,
 -1,
 356678877,
 92714,
 356980042,
 356599332,
 -1,
 -60088,
 356932599,
 92718,
 -60087,
 356989596,
 92717,
 -1,
 357043860,
 92682,
 357242189,
 356944244,
 -1,
 -60084,
 357194743,
 92699,
 -1,
 357240468,
 92701,
 357438800,
 357205033,
 -1,
 -60081,
 357400020,
 92705,
 -1,
 357437076,
 92716,
 -60079,
 357401632,
 92728,
 -60078,
 357596239,
 92676,
 -60077,
 357642602,
 92715,
 -1,
 357706137,
 92678,
 357897630,
 304248331,
 129415,
 357963163,
 357830982,
 -1,
 358028674,
 357911195,
 -1,
 358094181,
 357985731,
 -1,
 358159715,
 358038948,
 -1,
 -60070,
 358123968,
 7132,
 -60069,
 358188097,
 7116,
 -60068,
 358247976,
 7129,
 -60067,
 358311373,
 7123,
 -60066,
 358375380,
 7112,
 -60065,
 358436598,
 7125,
 -60064,
 358499950,
 7135,
 -60063,
 358561250,
 7107,
 -60062,
 358626103,
 7119,
 -1,
 358682260,
 7105,
 -60060,
 358112924,
 7126,
 -1,
 358813332,
 7128,
 359011691,
 358044534,
 -1,
 -60057,
 358975936,
 7136,
 -60056,
 359029898,
 7127,
 -60055,
 359084855,
 7133,
 -60054,
 359146267,
 7138,
 -1,
 359206548,
 7113,
 359404914,
 358960813,
 -1,
 359470449,
 359337620,
 7124,
 359596031,
 359421005,
 -1,
 -60049,
 359493160,
 7130,
 -60048,
 359551970,
 7114,
 -1,
 359609826,
 7108,
 -1,
 359405251,
 7139,
 359863668,
 359358420,
 7111,
 -1,
 359810486,
 7117,
 -60043,
 359827904,
 7131,
 -60042,
 359957569,
 7115,
 -60041,
 360021071,
 7141,
 -60040,
 360080845,
 7122,
 -60039,
 360138350,
 7134,
 -60038,
 360203452,
 7110,
 -60037,
 360268677,
 7120,
 -60036,
 360331932,
 7140,
 -60035,
 360396258,
 7106,
 -60034,
 360461111,
 7118,
 -60033,
 360522523,
 7121,
 -60032,
 360586070,
 7137,
 -60031,
 360650435,
 7109,
 -1,
 360713876,
 7104,
 360912269,
 357991432,
 -1,
 360977797,
 360873039,
 7150,
 -1,
 360907245,
 7151,
 361108872,
 360924342,
 -1,
 -60025,
 361060286,
 7149,
 -1,
 361118364,
 7147,
 361305482,
 361048087,
 7143,
 -1,
 361244695,
 7145,
 -60021,
 361259009,
 7144,
 -60020,
 361387966,
 7148,
 -1,
 361446044,
 7146,
 361633173,
 360869315,
 -1,
 361698708,
 361597589,
 -1,
 361764242,
 361652122,
 -1,
 -60015,
 361709073,
 7165,
 -1,
 361763616,
 7167,
 -60013,
 361714661,
 7164,
 -1,
 361907240,
 7166,
 -1,
 361643322,
 7142,
 362157464,
 361586716,
 -1,
 -60009,
 362109621,
 7155,
 -1,
 362165555,
 7154,
 362414079,
 362094614,
 -1,
 -60006,
 362304779,
 7152,
 -1,
 362362324,
 7153,
 362550685,
 357905876,
 128704,
 -1,
 362511218,
 128705,
 -1,
 362510182,
 128267,
 362747341,
 357854659,
 -1,
 362812876,
 362704427,
 -1,
 362878403,
 362760859,
 -1,
 362943908,
 362817559,
 92908,
 -59997,
 362894831,
 92880,
 -1,
 362948631,
 92907,
 363140519,
 362908020,
 -1,
 -59994,
 363084802,
 92885,
 -1,
 363145909,
 92900,
 363337129,
 363103297,
 92891,
 -1,
 363275208,
 92902,
 363468203,
 363297871,
 92906,
 -1,
 363432137,
 92896,
 363599277,
 363419582,
 92904,
 -1,
 363550654,
 92905,
 363730352,
 363545646,
 -1,
 -59985,
 363683823,
 92888,
 -1,
 363728532,
 92881,
 363926963,
 363672337,
 -1,
 -59982,
 363862733,
 92893,
 -1,
 363925727,
 92886,
 364123574,
 363864720,
 -1,
 -59979,
 364074942,
 92894,
 -1,
 364132508,
 92887,
 -59977,
 364088212,
 92892,
 -59976,
 364282909,
 92899,
 -59975,
 364345709,
 92897,
 -59974,
 364408537,
 92882,
 -59973,
 364470228,
 92901,
 -59972,
 364531704,
 92884,
 -59971,
 364594206,
 92889,
 -59970,
 364657308,
 92909,
 -59969,
 364722829,
 92890,
 -59968,
 364785488,
 92883,
 -59967,
 364846235,
 92895,
 -59966,
 364910275,
 92898,
 -1,
 364973716,
 92903,
 365172171,
 362815333,
 -1,
 365237703,
 365120895,
 -1,
 -59962,
 365168616,
 92915,
 -1,
 365233459,
 92913,
 365434314,
 365181041,
 -1,
 -59959,
 365365201,
 92916,
 -1,
 365430067,
 92912,
 -1,
 365384050,
 92914,
 -1,
 365114119,
 92917,
 -1,
 362759454,
 127936,
 365827547,
 362695923,
 -1,
 365893082,
 365786637,
 -1,
 365958617,
 365828558,
 -1,
 366024152,
 365922537,
 -1,
 366089686,
 365958834,
 -1,
 366155221,
 366041399,
 -1,
 -59948,
 366112464,
 128503,
 -1,
 366157143,
 128505,
 -1,
 366088664,
 128499,
 -59945,
 366046928,
 128501,
 -1,
 366365716,
 11197,
 -1,
 365971468,
 128502,
 -1,
 365915856,
 128500,
 -1,
 365844945,
 127880,
 366745063,
 365763395,
 -1,
 366810597,
 366691374,
 -1,
 366876130,
 366767555,
 -1,
 366941665,
 366823176,
 -1,
 -59936,
 366898178,
 11101,
 -1,
 366958856,
 11099,
 -1,
 366895077,
 983056,
 367263743,
 366804992,
 -1,
 -59932,
 367167216,
 128281,
 -1,
 367220858,
 128386,
 -59930,
 366770812,
 128043,
 -1,
 367352273,
 129363,
 367531503,
 366695286,
 -1,
 367597038,
 367477806,
 127974,
 367722495,
 367548061,
 -1,
 -59925,
 367626807,
 128180,
 -59924,
 367682366,
 128183,
 -59923,
 367734335,
 128182,
 -1,
 367797620,
 128181,
 -1,
 367530612,
 127820,
 368055797,
 367467328,
 128118,
 368181247,
 367984640,
 -1,
 -59918,
 368080348,
 128700,
 -59917,
 368123312,
 128036,
 -59916,
 368187969,
 127868,
 -1,
 368251614,
 128124,
 368449016,
 368010617,
 -1,
 -59913,
 368383998,
 128136,
 -1,
 368443737,
 128202,
 368645627,
 368390929,
 -1,
 -59910,
 368606711,
 129366,
 -1,
 368653154,
 128708,
 -1,
 368583984,
 127992,
 368907931,
 304178553,
 -1,
 368973458,
 368840953,
 -1,
 369038914,
 368921243,
 -1,
 369104390,
 369000886,
 -1,
 369169925,
 369055760,
 -1,
 369235459,
 369124729,
 69643,
 -1,
 369190265,
 69644,
 369426431,
 369182244,
 69645,
 -1,
 369313316,
 69646,
 -1,
 369102484,
 69679,
 369563148,
 369063435,
 -1,
 369628682,
 369522187,
 -1,
 -59895,
 369571298,
 69662,
 -1,
 369626772,
 69661,
 -59893,
 369571298,
 69667,
 -1,
 369757844,
 69666,
 369956369,
 369514430,
 69649,
 370081791,
 369903649,
 -1,
 -59889,
 369978657,
 69686,
 -59888,
 370038288,
 69687,
 -1,
 370101486,
 69685,
 370284054,
 369906550,
 -1,
 -59885,
 370248128,
 69660,
 -59884,
 370299874,
 69665,
 -59883,
 370357047,
 69655,
 -1,
 370413204,
 69670,
 370611740,
 370221712,
 -1,
 370677274,
 370549392,
 -1,
 -59879,
 370619874,
 69664,
 -1,
 370675348,
 69663,
 -59877,
 370619874,
 69669,
 -1,
 370806420,
 69668,
 371004960,
 370544276,
 69637,
 -59874,
 370965583,
 69650,
 -59873,
 371014300,
 69648,
 -1,
 371068564,
 69638,
 371267108,
 370961859,
 -1,
 -59870,
 371224104,
 69681,
 -59869,
 371275234,
 69680,
 -1,
 371330708,
 69682,
 371529254,
 371227727,
 69641,
 -1,
 371489871,
 69642,
 371660329,
 371482522,
 -1,
 -59864,
 371602914,
 69672,
 -1,
 371658388,
 69671,
 371856940,
 371607076,
 -1,
 -59861,
 371803758,
 69684,
 -1,
 371854996,
 69678,
 372053551,
 371803182,
 -1,
 -59858,
 371996130,
 69652,
 -1,
 372051604,
 69651,
 372250162,
 371999599,
 -1,
 -59855,
 372192738,
 69659,
 -1,
 372248212,
 69658,
 372446772,
 372193948,
 69639,
 -1,
 372390556,
 69640,
 372577847,
 372388625,
 -1,
 -59850,
 372520418,
 69654,
 -1,
 372575892,
 69653,
 372774458,
 372513603,
 -1,
 -59847,
 372717026,
 69657,
 -1,
 372772500,
 69656,
 372971069,
 372709042,
 -1,
 -59844,
 372913634,
 69674,
 -1,
 372969108,
 69673,
 -59842,
 372935104,
 69676,
 -59841,
 373122509,
 69677,
 -59840,
 373182198,
 69675,
 -59839,
 373241314,
 69683,
 -1,
 373303319,
 69647,
 373495392,
 368990041,
 -1,
 373560907,
 373454347,
 -1,
 373626439,
 373523497,
 -1,
 -59834,
 373577662,
 69715,
 -1,
 373632055,
 69724,
 373823050,
 373568980,
 -1,
 -59831,
 373778437,
 69716,
 -1,
 373834131,
 69725,
 -1,
 373762887,
 69723,
 374085200,
 373517763,
 -1,
 374150734,
 374031108,
 69719,
 -1,
 374111288,
 69728,
 374341631,
 374091359,
 69720,
 -1,
 374242360,
 69729,
 374412887,
 374026028,
 -1,
 374478420,
 374364094,
 -1,
 -59821,
 374440039,
 69717,
 -1,
 374500751,
 69726,
 374734847,
 374422172,
 -1,
 -59818,
 374637038,
 69718,
 -1,
 374682367,
 69727,
 374871643,
 374364710,
 69714,
 374996991,
 374800384,
 -1,
 -59814,
 374896627,
 69733,
 -1,
 374946383,
 69732,
 375133789,
 374822249,
 69722,
 -1,
 375094328,
 69731,
 375264863,
 375073383,
 69721,
 -1,
 375228788,
 69730,
 -1,
 375211041,
 69759,
 375461491,
 373457334,
 -1,
 375527026,
 375414600,
 -1,
 375592551,
 375489431,
 -1,
 375658085,
 375547257,
 69694,
 -1,
 375612793,
 69695,
 375848959,
 375604772,
 69696,
 -1,
 375735844,
 69697,
 375920235,
 375525012,
 -1,
 -59799,
 375880783,
 69701,
 -59798,
 375929500,
 69699,
 -1,
 375983764,
 69688,
 376182381,
 375880783,
 69692,
 -1,
 376142927,
 69693,
 376313455,
 376126108,
 69690,
 -1,
 376257180,
 69691,
 -59792,
 376264638,
 69700,
 -59791,
 376383511,
 69698,
 -1,
 376445041,
 69689,
 -1,
 375472408,
 69702,
 376706692,
 375399056,
 -1,
 376772226,
 376650995,
 -1,
 376837752,
 376731147,
 -1,
 -59785,
 376801236,
 69736,
 -1,
 376846768,
 69737,
 377034363,
 376794563,
 -1,
 -59782,
 376980228,
 69740,
 -1,
 377040479,
 69741,
 377230974,
 376975148,
 -1,
 -59779,
 377183707,
 69738,
 -1,
 377242214,
 69739,
 -59777,
 377195377,
 69734,
 -59776,
 377379366,
 69735,
 -59775,
 377443689,
 69743,
 -1,
 377498215,
 69742,
 -59773,
 376724833,
 69704,
 -1,
 377623221,
 69703,
 377820810,
 376664455,
 -1,
 -59770,
 377783155,
 69634,
 -59769,
 377847735,
 69636,
 -59768,
 377897944,
 69635,
 -59767,
 377953222,
 69632,
 -1,
 378016630,
 69633,
 378273791,
 377775093,
 -1,
 378279566,
 378160676,
 -1,
 -59763,
 378232146,
 69709,
 -1,
 378289875,
 69707,
 378476177,
 378217808,
 -1,
 -59760,
 378436919,
 69706,
 -1,
 378500619,
 69705,
 -1,
 378413357,
 69708,
 378738327,
 368917148,
 -1,
 378803862,
 378675856,
 -1,
 -59755,
 378745820,
 127753,
 -1,
 378808435,
 128112,
 -1,
 378743282,
 128188,
 379066010,
 378677394,
 -1,
 -59751,
 379012181,
 983124,
 -1,
 379069072,
 127838,
 -1,
 379017496,
 128148,
 379328288,
 368850450,
 -1,
 379393753,
 379275931,
 -1,
 379459235,
 379355574,
 -1,
 379524770,
 379410448,
 -1,
 379590305,
 379479417,
 72710,
 -1,
 379544953,
 72711,
 -1,
 379536932,
 72712,
 -1,
 379457172,
 72746,
 379852457,
 379418123,
 -1,
 379917991,
 379811339,
 -1,
 -59738,
 379860450,
 72729,
 -1,
 379915924,
 72728,
 -59736,
 379860450,
 72734,
 -1,
 380046996,
 72733,
 380245678,
 379802486,
 -1,
 -59733,
 380209600,
 72727,
 -59732,
 380261346,
 72732,
 -59731,
 380318519,
 72722,
 -1,
 380374676,
 72737,
 380573364,
 380183184,
 -1,
 380638898,
 380510864,
 -1,
 -59727,
 380581346,
 72731,
 -1,
 380636820,
 72730,
 -59725,
 380581346,
 72736,
 -1,
 380767892,
 72735,
 380966584,
 380505748,
 72704,
 -59722,
 380927055,
 72717,
 -59721,
 380975772,
 72715,
 -1,
 381030036,
 72705,
 381228732,
 380923331,
 -1,
 -59718,
 381185576,
 72748,
 -59717,
 381236706,
 72747,
 -1,
 381292180,
 72749,
 381490878,
 381189199,
 72708,
 -1,
 381451343,
 72709,
 381621953,
 381443994,
 -1,
 -59712,
 381564386,
 72739,
 -1,
 381619860,
 72738,
 381818564,
 381568046,
 -1,
 -59709,
 381760994,
 72719,
 -1,
 381816468,
 72718,
 382015175,
 381764463,
 -1,
 -59706,
 381957602,
 72726,
 -1,
 382013076,
 72725,
 382211785,
 381958812,
 72706,
 -1,
 382155420,
 72707,
 382342860,
 382153489,
 -1,
 -59701,
 382285282,
 72721,
 -1,
 382340756,
 72720,
 382539471,
 382278467,
 -1,
 -59698,
 382481890,
 72724,
 -1,
 382537364,
 72723,
 382736082,
 382473906,
 -1,
 -59695,
 382678498,
 72741,
 -1,
 382733972,
 72740,
 -59693,
 382699968,
 72743,
 -59692,
 382887373,
 72744,
 -59691,
 382949310,
 72716,
 -59690,
 383012598,
 72742,
 -59689,
 383075950,
 72745,
 -59688,
 383137250,
 72750,
 -1,
 383199255,
 72714,
 383391475,
 379344729,
 -1,
 383456994,
 383350283,
 -1,
 383522526,
 383419433,
 -1,
 -59683,
 383473598,
 72795,
 -1,
 383527991,
 72804,
 383719137,
 383464916,
 -1,
 -59680,
 383674373,
 72796,
 -1,
 383730067,
 72805,
 -1,
 383658823,
 72803,
 383981287,
 383413699,
 -1,
 384046821,
 383927044,
 72799,
 -1,
 384007224,
 72808,
 384237567,
 383987295,
 72800,
 -1,
 384138296,
 72809,
 384308974,
 383921964,
 -1,
 384374507,
 384260030,
 -1,
 -59670,
 384335975,
 72797,
 -1,
 384396687,
 72806,
 384630783,
 384318108,
 -1,
 -59667,
 384532974,
 72798,
 -1,
 384578303,
 72807,
 384767728,
 384259433,
 72802,
 -1,
 384728120,
 72811,
 384898802,
 384707175,
 72801,
 -1,
 384862580,
 72810,
 -1,
 384850470,
 72794,
 385095426,
 383353864,
 -1,
 385160952,
 385057687,
 -1,
 385226487,
 385115513,
 72756,
 -1,
 385181049,
 72757,
 -1,
 385173028,
 72758,
 385423100,
 385093268,
 -1,
 -59654,
 385383503,
 72763,
 -59653,
 385432220,
 72761,
 -1,
 385486484,
 72751,
 385685246,
 385383503,
 72754,
 -1,
 385645647,
 72755,
 385816320,
 385628828,
 72752,
 -1,
 385759900,
 72753,
 -59647,
 385767358,
 72762,
 -1,
 385886231,
 72760,
 386078483,
 385032848,
 -1,
 386144017,
 386022643,
 -1,
 386209543,
 386102795,
 -1,
 -59642,
 386172884,
 72786,
 -1,
 386218416,
 72787,
 386406154,
 386166211,
 -1,
 -59639,
 386351876,
 72790,
 -1,
 386412127,
 72791,
 386602765,
 386346796,
 -1,
 -59636,
 386555355,
 72788,
 -1,
 386613862,
 72789,
 -59634,
 386567025,
 72784,
 -59633,
 386751014,
 72785,
 -59632,
 386815337,
 72793,
 -1,
 386869863,
 72792,
 -59630,
 386096481,
 72770,
 -1,
 386994869,
 72769,
 387192603,
 386036103,
 -1,
 387258135,
 387154753,
 -1,
 -59626,
 387215015,
 72766,
 -1,
 387278480,
 72767,
 387454746,
 387190420,
 -1,
 -59623,
 387416523,
 72768,
 -1,
 387471254,
 72765,
 -1,
 387390406,
 72764,
 387716894,
 387134357,
 -1,
 -59619,
 387647861,
 72773,
 -1,
 387713241,
 72772,
 -59617,
 387680368,
 72771,
 -1,
 387856983,
 72812,
 388044671,
 379274788,
 -1,
 388110201,
 387977108,
 -1,
 388175662,
 388059238,
 -1,
 388241189,
 388136866,
 9206,
 -1,
 388170053,
 11205,
 388372264,
 388199003,
 -1,
 -59609,
 388320828,
 128927,
 -1,
 388375734,
 128921,
 388568874,
 388328034,
 9205,
 -1,
 388497733,
 11208,
 388699948,
 388516243,
 9204,
 -1,
 388628805,
 11207,
 388890623,
 388638476,
 9207,
 -1,
 388759877,
 11206,
 388962109,
 388111171,
 -1,
 389027644,
 388923665,
 -1,
 389093171,
 388988957,
 -1,
 -59598,
 389048993,
 11179,
 -1,
 389106171,
 11178,
 389289782,
 389048977,
 -1,
 -59595,
 389251114,
 11181,
 -1,
 389293936,
 11183,
 389486393,
 389237228,
 -1,
 -59592,
 389447722,
 11180,
 -1,
 389490544,
 11182,
 389742591,
 389424952,
 -1,
 -59589,
 389638817,
 11177,
 -1,
 389695995,
 11176,
 -1,
 388972836,
 9210,
 389945159,
 388918723,
 -1,
 390010690,
 389899479,
 -1,
 -59584,
 389951870,
 9209,
 -59583,
 390012128,
 11200,
 -1,
 390077228,
 128306,
 390272837,
 389958684,
 -1,
 -59580,
 390231004,
 128909,
 -1,
 390274558,
 128900,
 -59578,
 390219234,
 128369,
 -1,
 390402180,
 9984,
 390600529,
 389899641,
 -1,
 390666064,
 390544507,
 -1,
 390731598,
 390596634,
 -1,
 390797132,
 390669966,
 9193,
 -1,
 390727533,
 9197,
 -59571,
 390757019,
 9199,
 -1,
 390873532,
 128898,
 -59569,
 390694077,
 11166,
 -1,
 390988757,
 128413,
 -1,
 390618282,
 127990,
 391255898,
 390537872,
 -1,
 391321432,
 391208787,
 -1,
 391386966,
 391251994,
 -1,
 -59563,
 391332284,
 128899,
 -1,
 391390862,
 9196,
 -59561,
 391349437,
 11167,
 -1,
 391513045,
 128419,
 -59559,
 391277748,
 127778,
 -1,
 391658315,
 11201,
 391845729,
 391203017,
 -1,
 391911263,
 391776282,
 -1,
 391976798,
 391849614,
 9194,
 -1,
 391907181,
 9198,
 -1,
 391922108,
 128896,
 -59552,
 391873725,
 11164,
 -1,
 392102869,
 128412,
 392304487,
 391806724,
 -1,
 392370021,
 392235034,
 -1,
 -59548,
 392315324,
 128897,
 -1,
 392373902,
 9195,
 -59546,
 392332477,
 11165,
 -1,
 392496085,
 128418,
 392697709,
 392263179,
 -1,
 392763244,
 392642742,
 -1,
 -59542,
 392721372,
 128908,
 -59541,
 392777276,
 128925,
 -1,
 392832182,
 128919,
 -1,
 392715678,
 128383,
 393090928,
 392659699,
 -1,
 -59537,
 393039420,
 128926,
 -1,
 393094326,
 128920,
 393287539,
 393043866,
 -1,
 -59534,
 393249110,
 128392,
 -1,
 393292764,
 127986,
 393484150,
 393229780,
 -1,
 -59531,
 393423031,
 128420,
 -1,
 393483278,
 128426,
 -59529,
 393438558,
 10067,
 -59528,
 393631812,
 11204,
 -1,
 393687395,
 128447,
 393877372,
 388070871,
 -1,
 -59525,
 393820051,
 128153,
 -1,
 393878051,
 128216,
 394133503,
 393828286,
 -1,
 -59522,
 394036657,
 128033,
 -1,
 394097698,
 127804,
 394270626,
 387995582,
 -1,
 394336138,
 394217455,
 -1,
 394401668,
 394298807,
 -1,
 -59517,
 394359772,
 128912,
 -1,
 394403326,
 128902,
 394598279,
 394358211,
 -1,
 -59514,
 394543890,
 128951,
 -1,
 394596874,
 128939,
 -59512,
 394540403,
 128932,
 -59511,
 394735809,
 128945,
 -1,
 394799750,
 128957,
 394991502,
 394287342,
 128366,
 395057037,
 394940327,
 128278,
 -1,
 394986645,
 128209,
 -1,
 395013571,
 128218,
 395253651,
 394953769,
 -1,
 395319186,
 395200036,
 -1,
 -59503,
 395263712,
 127923,
 -1,
 395313941,
 128335,
 -1,
 395247637,
 127993,
 395581335,
 395207413,
 -1,
 -59499,
 395545515,
 12730,
 -59498,
 395594590,
 12729,
 -1,
 395654224,
 12728,
 395843481,
 395544948,
 128102,
 -1,
 395800087,
 128713,
 395974555,
 395804769,
 128144,
 -1,
 395903744,
 127893,
 396105630,
 395934545,
 -1,
 -59491,
 396056942,
 11211,
 -1,
 396118108,
 127870,
 396302240,
 396054189,
 983254,
 -1,
 396236466,
 128163,
 -59487,
 396265785,
 129354,
 -1,
 396366798,
 128023,
 396564407,
 394209303,
 -1,
 396629930,
 396496532,
 -1,
 396695463,
 396578880,
 -1,
 -59482,
 396633155,
 127901,
 -1,
 396694806,
 127900,
 -59480,
 396654886,
 128147,
 -59479,
 396846469,
 128059,
 -1,
 396893476,
 127958,
 397088689,
 396579702,
 -1,
 397154222,
 397047307,
 -1,
 -59475,
 397105088,
 127857,
 -1,
 397148292,
 11102,
 397410303,
 397095797,
 -1,
 -59472,
 397298339,
 983630,
 -1,
 397349682,
 2432,
 397547445,
 397035044,
 983055,
 397672447,
 397493796,
 128276,
 -59468,
 397556054,
 128718,
 -1,
 397608336,
 128277,
 -59466,
 397487294,
 127866,
 -1,
 397746832,
 128719,
 397940675,
 396524623,
 -1,
 398006205,
 397897155,
 128652,
 398071740,
 397964811,
 -1,
 -59461,
 398028232,
 128101,
 -1,
 398066236,
 128100,
 -1,
 398001277,
 128655,
 398333887,
 397954245,
 128363,
 -1,
 398264142,
 128364,
 -59456,
 398293854,
 129419,
 -59455,
 398421302,
 127791,
 -59454,
 398474601,
 127959,
 -1,
 398537489,
 128027,
 398727116,
 397884060,
 -1,
 398792647,
 398681465,
 -1,
 -59450,
 398751637,
 127874,
 -1,
 398795408,
 128038,
 398989258,
 398729867,
 -1,
 -59447,
 398934512,
 128692,
 -1,
 398993431,
 128690,
 -59445,
 398937292,
 127921,
 -1,
 399132016,
 128089,
 399316943,
 398690676,
 -1,
 -59442,
 399280932,
 983258,
 -1,
 399341320,
 983253,
 -59440,
 399273411,
 983057,
 -1,
 399466897,
 983125,
 399645957,
 304107181,
 -1,
 399710631,
 399583255,
 -1,
 399775948,
 399659894,
 -1,
 399841482,
 399713242,
 -1,
 399906993,
 399799736,
 -1,
 399972420,
 399837257,
 -1,
 400037858,
 399904265,
 -1,
 -59431,
 399969878,
 125069,
 -59430,
 400035308,
 125123,
 -59429,
 400100582,
 124959,
 -59428,
 400165993,
 125036,
 -59427,
 400231366,
 124932,
 -59426,
 400296773,
 124952,
 -59425,
 400362092,
 125097,
 -59424,
 400427412,
 125088,
 -59423,
 400492864,
 124999,
 -1,
 400558226,
 125047,
 400758765,
 399969674,
 -1,
 -59420,
 400690699,
 124993,
 -59419,
 400756129,
 125024,
 -59418,
 400821517,
 125043,
 -59417,
 400886927,
 125056,
 -59416,
 400952363,
 125117,
 -59415,
 401017651,
 124985,
 -59414,
 401082995,
 125039,
 -59413,
 401148368,
 125049,
 -59412,
 401213744,
 125071,
 -1,
 401279164,
 125015,
 401479672,
 400690404,
 -1,
 -59409,
 401411680,
 124980,
 -59408,
 401477019,
 125021,
 -59407,
 401542500,
 125119,
 -59406,
 401607807,
 124933,
 -59405,
 401673143,
 125022,
 -59404,
 401738536,
 125089,
 -59403,
 401803934,
 124986,
 -59402,
 401869245,
 125080,
 -59401,
 401934580,
 125099,
 -1,
 401999968,
 125100,
 402200579,
 401411148,
 -1,
 -59398,
 402132581,
 125002,
 -59397,
 402198003,
 125068,
 -59396,
 402263350,
 125107,
 -59395,
 402328759,
 125074,
 -59394,
 402394059,
 124931,
 -59393,
 402459474,
 125108,
 -59392,
 402524815,
 125009,
 -59391,
 402590135,
 125076,
 -59390,
 402655563,
 124945,
 -1,
 402720928,
 125124,
 402921486,
 402131874,
 -1,
 -59387,
 402853404,
 124951,
 -59386,
 402918885,
 125121,
 -59385,
 402984267,
 125066,
 -59384,
 403049560,
 125095,
 -59383,
 403115013,
 125000,
 -59382,
 403180345,
 124987,
 -59381,
 403245690,
 125041,
 -59380,
 403310979,
 125044,
 -59379,
 403376427,
 125072,
 -1,
 403441838,
 125070,
 403642393,
 402852614,
 -1,
 -59376,
 403574378,
 124946,
 -59375,
 403639745,
 124934,
 -59374,
 403705122,
 125078,
 -59373,
 403770488,
 125046,
 -59372,
 403835957,
 124942,
 -59371,
 403901217,
 125090,
 -59370,
 403966650,
 125048,
 -59369,
 404031881,
 125037,
 -59368,
 404097275,
 125033,
 -1,
 404162674,
 125035,
 404363300,
 403573325,
 -1,
 -59365,
 404295248,
 125029,
 -59364,
 404360671,
 125028,
 -59363,
 404426074,
 125027,
 -59362,
 404491347,
 125020,
 -59361,
 404556722,
 125019,
 -59360,
 404622102,
 125018,
 -59359,
 404687589,
 125013,
 -59358,
 404752940,
 125012,
 -59357,
 404818261,
 125011,
 -1,
 404883587,
 125005,
 405084207,
 404294005,
 -1,
 -59354,
 405016081,
 125004,
 -59353,
 405081528,
 125003,
 -59352,
 405146909,
 124984,
 -59351,
 405212298,
 124983,
 -59350,
 405277649,
 124982,
 -59349,
 405343091,
 124998,
 -59348,
 405408457,
 124997,
 -59347,
 405473775,
 124996,
 -59346,
 405539131,
 124976,
 -1,
 405604531,
 124975,
 405805114,
 405014745,
 -1,
 -59343,
 405737051,
 124974,
 -59342,
 405802385,
 124992,
 -59341,
 405867755,
 124991,
 -59340,
 405933134,
 124990,
 -59339,
 405998626,
 124964,
 -59338,
 406063880,
 124963,
 -59337,
 406129286,
 124962,
 -59336,
 406194558,
 124957,
 -59335,
 406259935,
 124956,
 -1,
 406325329,
 124955,
 406585343,
 405735497,
 -1,
 -59332,
 406457897,
 124950,
 -59331,
 406523346,
 124949,
 -59330,
 406588720,
 124948,
 -59329,
 406654163,
 124938,
 -59328,
 406719536,
 124937,
 -59327,
 406784894,
 124936,
 -59326,
 406850196,
 124930,
 -59325,
 406915471,
 124929,
 -1,
 406980869,
 124928,
 407240703,
 399902937,
 -1,
 407246928,
 407113098,
 -1,
 -59321,
 407178786,
 124954,
 -59320,
 407244248,
 125079,
 -59319,
 407309609,
 125083,
 -59318,
 407374963,
 125034,
 -59317,
 407440422,
 125114,
 -59316,
 407505752,
 125065,
 -59315,
 407571112,
 125058,
 -59314,
 407636515,
 125113,
 -59313,
 407701732,
 124995,
 -1,
 407767126,
 124994,
 407967835,
 407178468,
 -1,
 -59310,
 407899670,
 124935,
 -59309,
 407965078,
 124973,
 -59308,
 408030546,
 125067,
 -59307,
 408095854,
 125032,
 -59306,
 408161238,
 125010,
 -59305,
 408226623,
 125082,
 -59304,
 408292057,
 125116,
 -59303,
 408357315,
 125081,
 -59302,
 408422710,
 125101,
 -1,
 408488103,
 125122,
 408688742,
 407899212,
 -1,
 -59299,
 408620618,
 125031,
 -59298,
 408685996,
 125061,
 -59297,
 408751366,
 125064,
 -59296,
 408816734,
 125063,
 -59295,
 408882176,
 124967,
 -59294,
 408947558,
 125120,
 -59293,
 409012825,
 124965,
 -59292,
 409078249,
 124977,
 -59291,
 409143562,
 125084,
 -1,
 409208957,
 125008,
 409409649,
 408619938,
 -1,
 -59288,
 409341499,
 125054,
 -59287,
 409406924,
 125093,
 -59286,
 409472279,
 125006,
 -59285,
 409537711,
 125052,
 -59284,
 409603004,
 125059,
 -59283,
 409668427,
 124953,
 -59282,
 409733795,
 124988,
 -59281,
 409799127,
 125109,
 -59280,
 409864518,
 125115,
 -1,
 409929803,
 124958,
 410130556,
 409340678,
 -1,
 -59277,
 410062403,
 125111,
 -59276,
 410127782,
 125096,
 -59275,
 410193248,
 124968,
 -59274,
 410258600,
 125051,
 -59273,
 410323948,
 125075,
 -59272,
 410389368,
 125118,
 -59271,
 410454751,
 124944,
 -59270,
 410519980,
 125086,
 -59269,
 410585439,
 125016,
 -1,
 410650744,
 125038,
 410851463,
 410061389,
 -1,
 -59266,
 410783344,
 124947,
 -59265,
 410848652,
 124961,
 -59264,
 410914037,
 124969,
 -59263,
 410979527,
 124979,
 -59262,
 411044801,
 124971,
 -59261,
 411110239,
 125112,
 -59260,
 411175526,
 125023,
 -59259,
 411240858,
 125087,
 -59258,
 411306240,
 124970,
 -1,
 411371628,
 125042,
 411572370,
 410782069,
 -1,
 -59255,
 411504175,
 125103,
 -59254,
 411569585,
 125040,
 -59253,
 411635011,
 125055,
 -59252,
 411700429,
 124939,
 -59251,
 411765746,
 125104,
 -59250,
 411831067,
 125094,
 -59249,
 411896500,
 125102,
 -59248,
 411961802,
 125077,
 -59247,
 412027226,
 125017,
 -1,
 412092569,
 125053,
 412293277,
 411502809,
 -1,
 -59244,
 412225077,
 125106,
 -59243,
 412290552,
 124940,
 -59242,
 412355901,
 125030,
 -59241,
 412421308,
 124978,
 -59240,
 412486648,
 125050,
 -59239,
 412552067,
 124941,
 -59238,
 412617354,
 125007,
 -59237,
 412682656,
 125092,
 -59236,
 412748015,
 125060,
 -1,
 412813448,
 124989,
 413014184,
 412223561,
 -1,
 -59233,
 412946038,
 125014,
 -59232,
 413011398,
 125091,
 -59231,
 413076736,
 125098,
 -59230,
 413142171,
 125057,
 -59229,
 413207520,
 125085,
 -59228,
 413272941,
 125001,
 -59227,
 413338191,
 124960,
 -59226,
 413403619,
 125073,
 -59225,
 413468905,
 125026,
 -1,
 413534300,
 124966,
 413794303,
 412945929,
 -1,
 -59222,
 413666554,
 125025,
 -59221,
 413732033,
 124981,
 -59220,
 413797284,
 124972,
 -59219,
 413862793,
 124943,
 -59218,
 413928064,
 125045,
 -59217,
 413993437,
 125110,
 -59216,
 414058773,
 125105,
 -1,
 414124134,
 125062,
 414324926,
 399844570,
 -1,
 414390453,
 414283275,
 -1,
 -59212,
 414353364,
 125128,
 -1,
 414398896,
 125129,
 414587064,
 414346691,
 -1,
 -59209,
 414532356,
 125132,
 -1,
 414592607,
 125133,
 414783675,
 414527276,
 -1,
 -59206,
 414735835,
 125130,
 -1,
 414794342,
 125131,
 -59204,
 414734886,
 125127,
 -59203,
 414930281,
 125135,
 -1,
 414984807,
 125134,
 415236095,
 414261104,
 -1,
 415242438,
 415135243,
 -1,
 415307973,
 415180823,
 -1,
 415373508,
 415257462,
 -1,
 -59197,
 415329731,
 125137,
 -1,
 415368363,
 125140,
 -1,
 415312867,
 125136,
 -1,
 415250851,
 125139,
 415701193,
 415185487,
 -1,
 -59192,
 415657411,
 125138,
 -1,
 415696043,
 125141,
 -1,
 415650358,
 125142,
 -59189,
 399797783,
 128697,
 -1,
 415915028,
 128334,
 416094572,
 399731806,
 -1,
 416160070,
 416031309,
 -1,
 416225555,
 416110425,
 -1,
 416291042,
 416183819,
 -1,
 416356568,
 416252969,
 -1,
 416422102,
 416307134,
 68033,
 416546815,
 416350208,
 -1,
 416553173,
 416430671,
 68051,
 -1,
 416482465,
 68078,
 -1,
 416511987,
 68060,
 416808959,
 416361527,
 68042,
 -1,
 416679073,
 68069,
 416880864,
 416298452,
 -1,
 416946398,
 416835589,
 68034,
 417071103,
 416874496,
 -1,
 417077469,
 416954959,
 68052,
 -1,
 417006753,
 68079,
 -1,
 417036275,
 68061,
 417333247,
 416891283,
 68043,
 -1,
 417203361,
 68070,
 417464319,
 416820039,
 68041,
 -1,
 417334433,
 68068,
 417536241,
 416247235,
 -1,
 417601770,
 417481476,
 68037,
 417667304,
 417529856,
 -1,
 417732839,
 417610319,
 68055,
 -1,
 417662113,
 68082,
 -1,
 417691635,
 68064,
 417988607,
 417627192,
 68046,
 -1,
 417858721,
 68073,
 418119679,
 417541727,
 68038,
 418126063,
 417988608,
 -1,
 418191598,
 418069071,
 68056,
 -1,
 418120865,
 68083,
 -1,
 418150387,
 68065,
 418447359,
 418085944,
 68047,
 -1,
 418317473,
 68074,
 418519298,
 417476396,
 -1,
 418584826,
 418469822,
 -1,
 418650360,
 418545767,
 68035,
 418775039,
 418578432,
 -1,
 418781431,
 418658895,
 68053,
 -1,
 418710689,
 68080,
 -1,
 418740211,
 68062,
 419037183,
 418606479,
 68044,
 -1,
 418907297,
 68071,
 419168255,
 418527900,
 -1,
 419174656,
 419070446,
 68036,
 419299327,
 419102720,
 -1,
 419305727,
 419183183,
 68054,
 -1,
 419234977,
 68081,
 -1,
 419264499,
 68063,
 419561471,
 419115775,
 68045,
 -1,
 419431585,
 68072,
 419633416,
 418469225,
 68040,
 419698951,
 419561472,
 -1,
 419764486,
 419641935,
 68058,
 -1,
 419693729,
 68085,
 -1,
 419723251,
 68067,
 -1,
 419658811,
 68076,
 420026638,
 419572327,
 68039,
 420092173,
 419954688,
 -1,
 420157708,
 420035151,
 68057,
 -1,
 420086945,
 68084,
 -1,
 420116467,
 68066,
 -1,
 420055454,
 68075,
 420478975,
 419977766,
 68032,
 420544511,
 420347904,
 -1,
 420550930,
 420428367,
 68050,
 -1,
 420480161,
 68077,
 -1,
 420509683,
 68059,
 420747572,
 416171556,
 -1,
 420813105,
 420687308,
 -1,
 420878617,
 420771339,
 -1,
 -59113,
 420829118,
 68022,
 -59112,
 420882455,
 68021,
 -1,
 420941460,
 68020,
 421140764,
 420834755,
 -1,
 -59109,
 421079063,
 68017,
 -1,
 421138068,
 68015,
 421337375,
 421090166,
 -1,
 -59106,
 421275671,
 68010,
 -1,
 421334676,
 68009,
 421533986,
 421282862,
 -1,
 -59103,
 421475810,
 68013,
 -1,
 421531284,
 68018,
 421730596,
 421465748,
 68000,
 -1,
 421685029,
 68016,
 -59099,
 421693888,
 68004,
 -59098,
 421823553,
 68005,
 -59097,
 421881293,
 68011,
 -59096,
 421946504,
 68019,
 -59095,
 422010836,
 68007,
 -59094,
 422074302,
 68003,
 -59093,
 422137590,
 68008,
 -59092,
 422200942,
 68012,
 -59091,
 422263452,
 68002,
 -59090,
 422328398,
 68014,
 -59089,
 422389783,
 68001,
 -59088,
 422454043,
 68023,
 -1,
 422516419,
 68006,
 422772735,
 420763799,
 -1,
 -59085,
 422669388,
 68030,
 -1,
 422723008,
 68031,
 422969343,
 420688489,
 -1,
 422975801,
 422868491,
 -1,
 -59081,
 422938610,
 68087,
 -59080,
 422984181,
 68088,
 -1,
 423045994,
 68095,
 423237948,
 422931907,
 -1,
 -59077,
 423183141,
 68091,
 -1,
 423243373,
 68092,
 423434559,
 423189034,
 -1,
 -59074,
 423394264,
 68086,
 -1,
 423442013,
 68029,
 423631170,
 423374636,
 -1,
 -59071,
 423583288,
 68089,
 -1,
 423641796,
 68090,
 423827781,
 423569431,
 -1,
 -59068,
 423775020,
 68028,
 -1,
 423836811,
 68093,
 -1,
 423777655,
 68094,
 424148991,
 416102499,
 -1,
 424155498,
 424037019,
 -1,
 424221006,
 424113675,
 -1,
 424286539,
 424159255,
 67994,
 -1,
 424216483,
 67995,
 424417613,
 424218260,
 67992,
 -1,
 424347555,
 67993,
 -1,
 424368062,
 67996,
 424614227,
 424170358,
 -1,
 424679761,
 424552471,
 67980,
 -1,
 424609699,
 67981,
 424869887,
 424611476,
 67978,
 -1,
 424740771,
 67979,
 424941911,
 424570307,
 -1,
 425007446,
 424873620,
 67987,
 -1,
 424937379,
 67988,
 -1,
 424945687,
 67989,
 425204057,
 424895949,
 67982,
 -1,
 425133987,
 67983,
 425335132,
 425149486,
 -1,
 -59045,
 425276898,
 67985,
 -1,
 425332372,
 67990,
 425531742,
 425268931,
 67974,
 -1,
 425461667,
 67975,
 -59041,
 425494976,
 67972,
 -59040,
 425624641,
 67973,
 -59039,
 425682056,
 67991,
 -59038,
 425746388,
 67976,
 -59037,
 425809854,
 67971,
 -59036,
 425873142,
 67977,
 -59035,
 425936494,
 67984,
 -59034,
 425999004,
 67970,
 -59033,
 426063950,
 67986,
 -59032,
 426125335,
 67969,
 -59031,
 426189595,
 67997,
 -1,
 426249876,
 67968,
 426508287,
 424113655,
 67998,
 -1,
 426379171,
 67999,
 426580366,
 416034236,
 -1,
 426645885,
 426527387,
 -1,
 426711409,
 426605393,
 -1,
 -59024,
 426653154,
 43749,
 -1,
 426708628,
 43748,
 426908020,
 426667459,
 -1,
 -59021,
 426864168,
 43754,
 -1,
 426915298,
 43753,
 427104631,
 426857334,
 -1,
 -59018,
 427067840,
 43747,
 -1,
 427119586,
 43752,
 427301242,
 427041733,
 -1,
 -59015,
 427242978,
 43751,
 -1,
 427298452,
 43750,
 -59013,
 427251646,
 43745,
 -59012,
 427436055,
 43744,
 -1,
 427498805,
 43746,
 427694472,
 426607030,
 -1,
 427760007,
 427646792,
 -1,
 427825540,
 427691668,
 -1,
 427891075,
 427757204,
 -1,
 -59006,
 427850831,
 43759,
 -1,
 427899548,
 43757,
 -1,
 427850831,
 43758,
 -59003,
 427787123,
 43765,
 -59002,
 428114352,
 43756,
 -1,
 428162375,
 43755,
 -1,
 427704600,
 43766,
 428415371,
 427626132,
 -1,
 -58998,
 428365263,
 43762,
 -1,
 428422934,
 43761,
 -58996,
 428378203,
 43764,
 -58995,
 428570051,
 43763,
 -1,
 428612988,
 43760,
 428808610,
 426517796,
 -1,
 428874132,
 428764611,
 -1,
 428939667,
 428819207,
 -1,
 -58990,
 428897228,
 128950,
 -1,
 428958348,
 128971,
 -1,
 428872202,
 128938,
 429201817,
 428814124,
 -1,
 429267352,
 429153799,
 -1,
 -58985,
 429220297,
 128967,
 -1,
 429267277,
 128965,
 -1,
 429212336,
 128944,
 429529500,
 429160487,
 -1,
 -58981,
 429482441,
 128963,
 -1,
 429529421,
 128961,
 429726111,
 429468269,
 -1,
 -58978,
 429683660,
 128956,
 -1,
 429744780,
 128974,
 -58976,
 429688352,
 128911,
 -58975,
 429864307,
 128931,
 -1,
 429922826,
 128901,
 -58973,
 428768057,
 128647,
 -58972,
 430076925,
 983172,
 -58971,
 430133889,
 128221,
 -58970,
 430198055,
 127816,
 -1,
 430249340,
 127830,
 430447314,
 399642260,
 -1,
 430512668,
 430396278,
 128104,
 430578159,
 430455729,
 -1,
 430643675,
 430525083,
 -1,
 430709169,
 430599619,
 -1,
 430774703,
 430640788,
 -1,
 -58962,
 430723316,
 68312,
 -1,
 430777475,
 68317,
 -58960,
 430731495,
 68323,
 -1,
 430913721,
 68322,
 431102389,
 430667275,
 -1,
 -58957,
 431044225,
 68309,
 -58956,
 431107528,
 68302,
 -1,
 431167105,
 68324,
 431364537,
 431034004,
 -1,
 -58953,
 431327820,
 68313,
 -58952,
 431377039,
 68288,
 -1,
 431429285,
 68314,
 431626684,
 431327981,
 -1,
 -58949,
 431568729,
 68298,
 -1,
 431625893,
 68297,
 431823295,
 431589586,
 -1,
 -58946,
 431774695,
 68319,
 -1,
 431821711,
 68305,
 432019906,
 431776902,
 -1,
 -58943,
 431971303,
 68318,
 -1,
 432027999,
 68320,
 432216517,
 431965230,
 -1,
 -58940,
 432158498,
 68306,
 -1,
 432214927,
 68304,
 432413128,
 432161647,
 -1,
 -58937,
 432355161,
 68300,
 -1,
 432412325,
 68299,
 432609738,
 432355170,
 68294,
 -1,
 432568188,
 68301,
 432740813,
 432550673,
 -1,
 -58932,
 432684463,
 68291,
 -1,
 432748723,
 68292,
 432937424,
 432677520,
 -1,
 -58929,
 432879233,
 68308,
 -1,
 432935329,
 68293,
 433134035,
 432871090,
 -1,
 -58926,
 433076271,
 68290,
 -1,
 433139144,
 68289,
 -58924,
 433097429,
 68303,
 -58923,
 433292527,
 68295,
 -58922,
 433350809,
 68321,
 -58921,
 433414376,
 68315,
 -58920,
 433477522,
 68311,
 -58919,
 433541375,
 68310,
 -58918,
 433604335,
 68307,
 -1,
 433663931,
 68316,
 433854948,
 430597109,
 -1,
 433920480,
 433792336,
 -1,
 433986015,
 433878539,
 68340,
 -1,
 433915776,
 68339,
 -1,
 433945920,
 68338,
 -58911,
 433880063,
 68341,
 -58910,
 434140244,
 68336,
 -58909,
 434195533,
 68342,
 -1,
 434254055,
 68337,
 434444779,
 433805145,
 -1,
 434510312,
 434402827,
 -1,
 -58905,
 434472296,
 68334,
 -1,
 434514759,
 68333,
 434706922,
 434461222,
 68331,
 -1,
 434635292,
 68335,
 -1,
 434647202,
 68332,
 434903534,
 434376461,
 -1,
 -58899,
 434837475,
 68326,
 -1,
 434900792,
 68325,
 -1,
 434860493,
 68296,
 435165712,
 430515016,
 -1,
 435231244,
 435112603,
 -1,
 435296773,
 435162772,
 -1,
 435362293,
 435252675,
 2126,
 -58892,
 435325677,
 2129,
 -1,
 435369428,
 2132,
 435558903,
 435320331,
 2133,
 -1,
 435516939,
 2120,
 435689977,
 435504174,
 2122,
 -1,
 435645992,
 2121,
 -58886,
 435653357,
 2118,
 -58885,
 435774841,
 2131,
 -58884,
 435840134,
 2130,
 -58883,
 435904410,
 2128,
 -58882,
 435966838,
 2125,
 -58881,
 436031149,
 2124,
 -58880,
 436094500,
 2123,
 -58879,
 436157908,
 2136,
 -58878,
 436221396,
 2116,
 -58877,
 436286225,
 2114,
 -58876,
 436347536,
 2115,
 -1,
 436410034,
 2113,
 436607496,
 435239580,
 -1,
 -58873,
 436565515,
 2119,
 -1,
 436622198,
 2127,
 -58871,
 436568398,
 2117,
 -58870,
 436749459,
 2135,
 -58869,
 436811387,
 2112,
 -1,
 436873206,
 2134,
 -58867,
 435192746,
 2138,
 -58866,
 437019625,
 2142,
 -58865,
 437072913,
 2139,
 -1,
 437129370,
 2137,
 437328409,
 435093504,
 -1,
 437393940,
 437290656,
 -1,
 -58861,
 437353338,
 128115,
 -1,
 437400962,
 128114,
 437590551,
 437337559,
 -1,
 -58858,
 437550033,
 129333,
 -1,
 437590785,
 128372,
 -58856,
 437527434,
 128378,
 -1,
 437719709,
 128107,
 -58854,
 437286724,
 128368,
 -58853,
 437874192,
 128094,
 -1,
 437917063,
 8380,
 438114938,
 430466425,
 -1,
 438180473,
 438050202,
 -1,
 438245961,
 438136259,
 -1,
 438311494,
 438205714,
 -1,
 438376998,
 438269451,
 -1,
 438442532,
 438332867,
 -1,
 -58845,
 438384098,
 72867,
 -1,
 438439572,
 72866,
 -58843,
 438384098,
 72859,
 -1,
 438570644,
 72858,
 438770218,
 438326134,
 -1,
 -58840,
 438733248,
 72857,
 -58839,
 438776631,
 72853,
 -1,
 438832788,
 72861,
 439032365,
 438733549,
 -1,
 -58836,
 438973922,
 72870,
 -1,
 439029396,
 72871,
 439228976,
 438988227,
 -1,
 -58833,
 439170530,
 72876,
 -1,
 439226004,
 72877,
 439425587,
 439181210,
 -1,
 -58830,
 439367138,
 72863,
 -1,
 439422612,
 72862,
 439622198,
 439370798,
 -1,
 -58827,
 439563746,
 72851,
 -1,
 439619220,
 72850,
 439818809,
 439558800,
 -1,
 -58824,
 439782127,
 72868,
 -1,
 439815828,
 72860,
 440015420,
 439753539,
 -1,
 -58821,
 439956962,
 72855,
 -1,
 440012436,
 72854,
 -58819,
 439978432,
 72873,
 -58818,
 440173633,
 72869,
 -58817,
 440231373,
 72874,
 -58816,
 440291062,
 72865,
 -58815,
 440354414,
 72875,
 -58814,
 440419205,
 72856,
 -58813,
 440481250,
 72878,
 -58812,
 440546103,
 72852,
 -58811,
 440604355,
 72864,
 -1,
 440667796,
 72879,
 440926207,
 438254848,
 -1,
 -58808,
 440802246,
 72886,
 -1,
 440865654,
 72885,
 441064049,
 438192795,
 -1,
 441129552,
 441021963,
 -1,
 441195086,
 441085379,
 -1,
 -58803,
 441136610,
 72835,
 -1,
 441192084,
 72834,
 -58801,
 441136610,
 72827,
 -1,
 441323156,
 72826,
 441522772,
 441078646,
 -1,
 -58798,
 441485760,
 72825,
 -58797,
 441529143,
 72821,
 -1,
 441585300,
 72829,
 441784919,
 441486061,
 -1,
 -58794,
 441726434,
 72838,
 -1,
 441781908,
 72839,
 441981530,
 441740739,
 -1,
 -58791,
 441923042,
 72844,
 -1,
 441978516,
 72845,
 442178141,
 441933722,
 -1,
 -58788,
 442119650,
 72831,
 -1,
 442175124,
 72830,
 442374752,
 442123310,
 -1,
 -58785,
 442316258,
 72819,
 -1,
 442371732,
 72818,
 442571363,
 442311312,
 -1,
 -58782,
 442534639,
 72836,
 -1,
 442568340,
 72828,
 442767974,
 442506051,
 -1,
 -58779,
 442709474,
 72823,
 -1,
 442764948,
 72822,
 -58777,
 442730944,
 72841,
 -58776,
 442926145,
 72837,
 -58775,
 442983885,
 72842,
 -58774,
 443043574,
 72833,
 -58773,
 443106926,
 72843,
 -58772,
 443171717,
 72824,
 -58771,
 443233762,
 72846,
 -58770,
 443298615,
 72820,
 -58769,
 443356867,
 72832,
 -58768,
 443420308,
 72847,
 -1,
 443484070,
 72840,
 443685495,
 441025544,
 -1,
 -58765,
 443645007,
 72882,
 -58764,
 443701182,
 72884,
 -58763,
 443759260,
 72881,
 -58762,
 443820055,
 72883,
 -1,
 443879128,
 72880,
 -58760,
 443633596,
 72817,
 -1,
 444020585,
 72816,
 -1,
 438139017,
 129355,
 444275377,
 438056500,
 -1,
 444340909,
 444220964,
 -1,
 444406444,
 444280268,
 -1,
 444471939,
 444364299,
 -1,
 444537473,
 444429835,
 -1,
 -58752,
 444478946,
 69983,
 -1,
 444534420,
 69982,
 -58750,
 444478946,
 69988,
 -1,
 444665492,
 69987,
 444865161,
 444408464,
 -1,
 444930695,
 444801680,
 -1,
 -58746,
 444872162,
 69985,
 -1,
 444927636,
 69984,
 -58744,
 444872162,
 69990,
 -1,
 445058708,
 69989,
 445258381,
 444814198,
 -1,
 -58741,
 445221312,
 69981,
 -58740,
 445273058,
 69986,
 -1,
 445320852,
 69991,
 445520528,
 445212025,
 -1,
 -58737,
 445474253,
 70002,
 -1,
 445517460,
 69997,
 445717139,
 445472666,
 -1,
 -58734,
 445658594,
 69993,
 -1,
 445714068,
 69992,
 445913750,
 445662254,
 -1,
 -58731,
 445855202,
 69974,
 -1,
 445910676,
 69973,
 446110361,
 445858671,
 -1,
 -58728,
 446051810,
 69980,
 -1,
 446107284,
 69979,
 446306972,
 446051089,
 -1,
 -58725,
 446248418,
 69976,
 -1,
 446303892,
 69975,
 446503583,
 446241603,
 -1,
 -58722,
 446445026,
 69978,
 -1,
 446500500,
 69977,
 446700194,
 446437042,
 -1,
 -58719,
 446641634,
 69995,
 -1,
 446697108,
 69994,
 -58717,
 446661064,
 69999,
 -58716,
 446856271,
 69970,
 -58715,
 446918184,
 70000,
 -58714,
 446977982,
 69972,
 -58713,
 447041270,
 69996,
 -58712,
 447104622,
 69998,
 -58711,
 447167132,
 69969,
 -58710,
 447231458,
 70001,
 -58709,
 447293463,
 69971,
 -1,
 447352468,
 69968,
 -1,
 444349543,
 70006,
 447617712,
 444296643,
 -1,
 -58705,
 447560987,
 70003,
 -1,
 447621438,
 70005,
 -1,
 447549216,
 70004,
 447879885,
 444221399,
 -1,
 447945409,
 447820393,
 -1,
 448010941,
 447896106,
 -1,
 448076471,
 447968779,
 -1,
 -58698,
 448038239,
 3419,
 -1,
 448080935,
 3420,
 448273082,
 448016172,
 -1,
 -58695,
 448224405,
 3417,
 -1,
 448281636,
 3422,
 -58693,
 448229932,
 3446,
 -58692,
 448420493,
 3416,
 -1,
 448473756,
 3447,
 448724991,
 447969301,
 -1,
 -58689,
 448625648,
 3421,
 -58688,
 448688694,
 3448,
 -1,
 448735907,
 3418,
 448928458,
 447892123,
 -1,
 448993990,
 448863670,
 -1,
 -58684,
 448956788,
 3413,
 -58683,
 449007277,
 3412,
 -1,
 449072362,
 3414,
 -58681,
 448953194,
 3386,
 -58680,
 449205776,
 3369,
 -58679,
 449258900,
 3406,
 -1,
 449319924,
 3423,
 449576959,
 448885127,
 -1,
 -58676,
 449470566,
 3407,
 -1,
 449518534,
 3329,
 449714896,
 447838112,
 -1,
 -58673,
 449670049,
 10187,
 -1,
 449720190,
 10189,
 -58671,
 449677612,
 128470,
 -1,
 449864218,
 127809,
 450042765,
 430389916,
 -1,
 450108287,
 449975167,
 -1,
 450173769,
 450054811,
 -1,
 450239207,
 450131467,
 -1,
 450304734,
 450189960,
 -1,
 -58664,
 450235786,
 94105,
 -58663,
 450301156,
 94104,
 -58662,
 450366540,
 94103,
 -58661,
 450431906,
 94102,
 -58660,
 450497286,
 94101,
 -58659,
 450562637,
 94100,
 -1,
 450627957,
 94099,
 450829026,
 450260419,
 -1,
 -58656,
 450784808,
 93994,
 -58655,
 450835938,
 93998,
 -1,
 450891412,
 94007,
 451091173,
 450775902,
 -1,
 -58652,
 451054016,
 93980,
 -1,
 451088020,
 93978,
 -58650,
 451049090,
 93966,
 -1,
 451219092,
 93962,
 451418868,
 450188150,
 -1,
 451484395,
 451381620,
 -1,
 -58646,
 451425762,
 93997,
 -1,
 451481236,
 93996,
 451681006,
 451433334,
 -1,
 -58643,
 451622370,
 93973,
 -1,
 451677844,
 93972,
 451877617,
 451621649,
 -1,
 -58640,
 451818978,
 93988,
 -1,
 451874452,
 93987,
 452074227,
 451808916,
 93968,
 -1,
 452030027,
 94032,
 -1,
 452015586,
 93969,
 452270848,
 451381997,
 -1,
 452336379,
 452233965,
 -1,
 452401913,
 452292035,
 -1,
 -58632,
 452364736,
 94017,
 -1,
 452398740,
 94014,
 -58630,
 452364736,
 94016,
 -1,
 452529812,
 94013,
 452729598,
 452292035,
 -1,
 -58627,
 452670946,
 94006,
 -1,
 452726420,
 94012,
 -58625,
 452670946,
 94005,
 -1,
 452857492,
 94011,
 453057291,
 452233800,
 -1,
 453122823,
 453015051,
 -1,
 453188357,
 453078467,
 -1,
 -58620,
 453129698,
 94000,
 -1,
 453185172,
 94009,
 -58618,
 453146242,
 93964,
 -1,
 453316244,
 93965,
 -58616,
 453074900,
 93954,
 -58615,
 453465572,
 93970,
 -58614,
 453526661,
 93984,
 -1,
 453584914,
 94001,
 453778196,
 453011530,
 -1,
 453843731,
 453728904,
 -1,
 -58610,
 453774730,
 94111,
 -58609,
 453839948,
 94110,
 -58608,
 453905314,
 94109,
 -58607,
 453970694,
 94108,
 -58606,
 454035829,
 94107,
 -1,
 454101209,
 94106,
 -1,
 453799966,
 94002,
 454368030,
 453714576,
 -1,
 454433561,
 454331117,
 -1,
 -58601,
 454396655,
 93995,
 -58600,
 454440418,
 93999,
 -1,
 454495892,
 94008,
 454695708,
 454380382,
 -1,
 -58597,
 454658496,
 93981,
 -1,
 454692500,
 93979,
 -58595,
 454632219,
 93967,
 -1,
 454823572,
 93963,
 455023398,
 454299284,
 -1,
 455088933,
 454977300,
 -1,
 455154467,
 455037814,
 -1,
 -58590,
 455095095,
 93989,
 -1,
 455151252,
 93971,
 -58588,
 455117742,
 94015,
 -1,
 455298806,
 93958,
 -1,
 455030228,
 94019,
 455547692,
 454968868,
 -1,
 455613226,
 455488980,
 -1,
 -58583,
 455576000,
 93977,
 -1,
 455610004,
 93976,
 -58581,
 455576000,
 93975,
 -1,
 455741076,
 93974,
 455940912,
 455503299,
 -1,
 -58578,
 455896616,
 94004,
 -58577,
 455947746,
 94003,
 -1,
 456003220,
 94010,
 456203061,
 455881489,
 -1,
 456268596,
 456144340,
 -1,
 -58573,
 456209890,
 93993,
 -1,
 456265364,
 93992,
 -1,
 456199828,
 93983,
 456530744,
 456163766,
 -1,
 -58569,
 456470352,
 93961,
 -1,
 456527508,
 93960,
 456727355,
 456483974,
 -1,
 -58566,
 456667959,
 93986,
 -1,
 456724116,
 93985,
 456923966,
 456679322,
 -1,
 -58563,
 456869486,
 93955,
 -1,
 456920724,
 93952,
 457120577,
 456871597,
 -1,
 -58560,
 457061858,
 93957,
 -1,
 457117332,
 93956,
 457317188,
 457061844,
 -1,
 -58557,
 457258466,
 94020,
 -1,
 457313940,
 93990,
 -58555,
 457279749,
 93991,
 -58554,
 457475137,
 94018,
 -58553,
 457524357,
 93982,
 -58552,
 457584464,
 93959,
 -1,
 457643715,
 93953,
 457841525,
 450135048,
 -1,
 457907027,
 457783964,
 94049,
 457972558,
 457838228,
 94050,
 458096639,
 457921398,
 94051,
 -1,
 457978641,
 94052,
 -58545,
 457931855,
 94056,
 -58544,
 458119102,
 94053,
 -58543,
 458183947,
 94057,
 -58542,
 458242716,
 94055,
 -1,
 458303511,
 94054,
 458496860,
 457838228,
 94036,
 458562390,
 458445686,
 94039,
 -1,
 458502929,
 94040,
 458693464,
 458500119,
 94067,
 -1,
 458631191,
 94068,
 -58535,
 458652751,
 94075,
 -58534,
 458767004,
 94073,
 -58533,
 458831947,
 94038,
 -1,
 458886804,
 94037,
 459086691,
 458456143,
 94058,
 459152224,
 459017876,
 94059,
 459276287,
 459101046,
 94060,
 -1,
 459158289,
 94061,
 -58527,
 459111503,
 94062,
 -58526,
 459298059,
 94064,
 -1,
 459352676,
 94063,
 459545449,
 459024407,
 94045,
 459610982,
 459498873,
 94071,
 -1,
 459564409,
 94069,
 459742056,
 459559798,
 94046,
 -1,
 459682577,
 94047,
 -1,
 459684508,
 94074,
 459938669,
 459495358,
 94041,
 -58517,
 459897935,
 94076,
 -58516,
 459954110,
 94042,
 -1,
 460009253,
 94048,
 460200815,
 459901300,
 94065,
 -1,
 460143260,
 94066,
 460331889,
 460162089,
 94044,
 -1,
 460281790,
 94043,
 460462963,
 460287245,
 94072,
 -1,
 460416377,
 94070,
 460652543,
 460411766,
 94077,
 -1,
 460534545,
 94078,
 460725114,
 457800097,
 -1,
 -58505,
 460683694,
 94096,
 -58504,
 460745009,
 94095,
 -58503,
 460789731,
 94098,
 -1,
 460853048,
 94097,
 461111295,
 460681607,
 -1,
 461118334,
 461006912,
 -1,
 -58499,
 461079484,
 94034,
 -1,
 461116751,
 94035,
 -1,
 461051215,
 94033,
 461380486,
 450044164,
 -1,
 461446019,
 461330366,
 -1,
 -58494,
 461401802,
 128300,
 -1,
 461463967,
 127908,
 461701119,
 461373440,
 -1,
 -58491,
 461593082,
 983231,
 -1,
 461644710,
 983232,
 461839242,
 461329744,
 -1,
 -58488,
 461787768,
 128469,
 -58487,
 461841676,
 128189,
 -1,
 461904637,
 128656,
 462159871,
 461784612,
 -1,
 -58484,
 462046739,
 127756,
 -1,
 462111294,
 127894,
 462298181,
 449992638,
 -1,
 462363663,
 462234256,
 -1,
 462429198,
 462305948,
 -1,
 462494715,
 462356480,
 -1,
 462560209,
 462441115,
 -1,
 462625689,
 462520758,
 -1,
 462691224,
 462575632,
 -1,
 462756758,
 462644601,
 71174,
 -1,
 462710137,
 71175,
 462946303,
 462702116,
 71176,
 -1,
 462833188,
 71177,
 -1,
 462622356,
 71210,
 463084447,
 462583307,
 -1,
 463149981,
 463042059,
 -1,
 -58468,
 463091170,
 71193,
 -1,
 463146644,
 71192,
 -58466,
 463091170,
 71198,
 -1,
 463277716,
 71197,
 463477668,
 463033206,
 -1,
 -58463,
 463440320,
 71191,
 -58462,
 463492066,
 71196,
 -58461,
 463549239,
 71186,
 -1,
 463605396,
 71201,
 463805354,
 463413904,
 -1,
 463870888,
 463741584,
 -1,
 -58457,
 463812066,
 71195,
 -1,
 463867540,
 71194,
 -58455,
 463812066,
 71200,
 -1,
 463998612,
 71199,
 464198574,
 463736468,
 71168,
 -58452,
 464157775,
 71181,
 -58451,
 464206492,
 71179,
 -1,
 464260756,
 71169,
 464460722,
 464154051,
 -1,
 -58448,
 464416296,
 71212,
 -58447,
 464467426,
 71211,
 -1,
 464522900,
 71213,
 464722868,
 464419919,
 71172,
 -1,
 464682063,
 71173,
 464853943,
 464674714,
 -1,
 -58442,
 464795106,
 71203,
 -1,
 464850580,
 71202,
 465050554,
 464799268,
 -1,
 -58439,
 464995950,
 71215,
 -1,
 465047188,
 71209,
 465247165,
 464995374,
 -1,
 -58436,
 465188322,
 71183,
 -1,
 465243796,
 71182,
 465443776,
 465191791,
 -1,
 -58433,
 465384930,
 71190,
 -1,
 465440404,
 71189,
 465640386,
 465386140,
 71170,
 -1,
 465582748,
 71171,
 465771461,
 465580817,
 -1,
 -58428,
 465712610,
 71185,
 -1,
 465768084,
 71184,
 465968072,
 465705795,
 -1,
 -58425,
 465909218,
 71188,
 -1,
 465964692,
 71187,
 466164683,
 465901234,
 -1,
 -58422,
 466105826,
 71205,
 -1,
 466161300,
 71204,
 -58420,
 466127296,
 71207,
 -58419,
 466314701,
 71208,
 -58418,
 466376638,
 71180,
 -58417,
 466439926,
 71206,
 -58416,
 466499042,
 71214,
 -1,
 466561047,
 71178,
 466754529,
 462521352,
 -1,
 466820055,
 466715543,
 -1,
 466885589,
 466773369,
 71221,
 -1,
 466838905,
 71222,
 467075071,
 466830884,
 71223,
 -1,
 466961956,
 71224,
 467147739,
 466751124,
 -1,
 -58407,
 467106895,
 71228,
 -58406,
 467155612,
 71226,
 -1,
 467209876,
 71216,
 467409885,
 467106895,
 71219,
 -1,
 467369039,
 71220,
 467540959,
 467352220,
 71217,
 -1,
 467483292,
 71218,
 -58400,
 467490750,
 71227,
 -1,
 467609623,
 71225,
 467803122,
 466690704,
 -1,
 467868656,
 467746035,
 -1,
 467934182,
 467826187,
 -1,
 -58395,
 467896276,
 71250,
 -1,
 467941808,
 71251,
 468130793,
 467889603,
 -1,
 -58392,
 468075268,
 71254,
 -1,
 468135519,
 71255,
 468327404,
 468070188,
 -1,
 -58389,
 468278747,
 71252,
 -1,
 468337254,
 71253,
 -58387,
 468290417,
 71248,
 -58386,
 468474406,
 71249,
 -58385,
 468538729,
 71257,
 -1,
 468593255,
 71256,
 -58383,
 467819873,
 71234,
 -1,
 468718261,
 71233,
 468917242,
 467759495,
 -1,
 468982774,
 468878145,
 -1,
 -58379,
 468938407,
 71230,
 -1,
 469001872,
 71231,
 469179385,
 468913812,
 -1,
 -58376,
 469133134,
 71232,
 -1,
 469194646,
 71229,
 -1,
 469121659,
 71236,
 -1,
 468848416,
 71235,
 469565439,
 462434330,
 -1,
 469572621,
 469453467,
 -1,
 469638149,
 469529179,
 -1,
 469703683,
 469583396,
 -1,
 469769218,
 469632348,
 -1,
 -58367,
 469717495,
 43870,
 -1,
 469778580,
 43869,
 -1,
 469711939,
 43001,
 -58364,
 469662865,
 43871,
 -1,
 469973004,
 43868,
 470162442,
 469572419,
 -1,
 470227977,
 470125281,
 -1,
 -58360,
 470184751,
 42653,
 -1,
 470234935,
 42652,
 -1,
 470160275,
 43000,
 470548479,
 470101790,
 -1,
 -58356,
 470437292,
 983981,
 -1,
 470497404,
 983980,
 -1,
 469506701,
 43867,
 -1,
 462368038,
 129339,
 470817834,
 462312310,
 -1,
 470883362,
 470758713,
 -1,
 470948885,
 470840738,
 71273,
 471072767,
 470877532,
 -1,
 -58348,
 470965358,
 71274,
 -1,
 471017047,
 71275,
 471211033,
 470904021,
 71265,
 471334911,
 471139676,
 -1,
 -58344,
 471227502,
 71269,
 -1,
 471279191,
 71270,
 471473180,
 471168523,
 -1,
 -58341,
 471433424,
 71276,
 -1,
 471493482,
 71267,
 471669790,
 471416944,
 71271,
 -1,
 471598600,
 71272,
 471800865,
 471603395,
 -1,
 -58336,
 471751790,
 71264,
 -1,
 471803479,
 71268,
 -1,
 471737805,
 71266,
 472063015,
 470822693,
 -1,
 472128550,
 471990272,
 -1,
 -58331,
 472090462,
 128184,
 -1,
 472127252,
 128176,
 -1,
 472057842,
 129297,
 472390697,
 472007996,
 128018,
 -1,
 472318425,
 128053,
 -1,
 472341548,
 128669,
 472587316,
 470776911,
 -1,
 472652849,
 472536848,
 -1,
 472718384,
 472584454,
 -1,
 -58322,
 472671760,
 128670,
 -58321,
 472718190,
 128672,
 -1,
 472782976,
 128693,
 -1,
 472646144,
 128507,
 473046067,
 472608473,
 128001,
 -1,
 472973785,
 128045,
 -1,
 473003900,
 128068,
 473242683,
 472544779,
 -1,
 473308218,
 473193489,
 -1,
 473373753,
 473235456,
 -1,
 -58312,
 473329346,
 128757,
 -1,
 473373161,
 128741,
 -1,
 473335061,
 128739,
 -1,
 473249809,
 129334,
 473701439,
 473176231,
 128241,
 473825279,
 473628672,
 -1,
 -58306,
 473728779,
 128242,
 -1,
 473782406,
 128244,
 473963586,
 473651134,
 -1,
 -58303,
 473912216,
 127889,
 -1,
 473965213,
 128496,
 -58301,
 473926091,
 128511,
 -58300,
 474121041,
 127909,
 -1,
 474182636,
 128332,
 474356884,
 462257231,
 -1,
 474422396,
 474304079,
 -1,
 474487931,
 474354477,
 -1,
 474553466,
 474434203,
 -1,
 474618960,
 474489488,
 -1,
 474684494,
 474555024,
 -1,
 -58292,
 474625506,
 70292,
 -58291,
 474686235,
 70291,
 -1,
 474746516,
 70290,
 -58289,
 474625506,
 70297,
 -1,
 474877588,
 70296,
 475077718,
 474576395,
 -1,
 475143252,
 475035147,
 -1,
 -58285,
 475084258,
 70289,
 -1,
 475139732,
 70288,
 -58283,
 475084258,
 70295,
 -1,
 475270804,
 70294,
 475470938,
 475030905,
 -1,
 -58280,
 475424205,
 70311,
 -58279,
 475477474,
 70312,
 -1,
 475532948,
 70306,
 475733086,
 475419510,
 -1,
 -58276,
 475695552,
 70287,
 -58275,
 475747298,
 70293,
 -1,
 475795092,
 70298,
 475995233,
 475684762,
 -1,
 -58272,
 475936226,
 70300,
 -1,
 475991700,
 70299,
 476191844,
 475939886,
 -1,
 -58269,
 476132834,
 70277,
 -1,
 476188308,
 70276,
 476388455,
 476136303,
 -1,
 -58266,
 476332933,
 70285,
 -1,
 476384916,
 70284,
 476585066,
 476328721,
 -1,
 -58263,
 476526050,
 70280,
 -1,
 476581524,
 70278,
 476781677,
 476519235,
 -1,
 -58260,
 476722658,
 70283,
 -1,
 476778132,
 70282,
 476978288,
 476714674,
 -1,
 -58257,
 476919266,
 70303,
 -1,
 476974740,
 70301,
 -58255,
 476940736,
 70305,
 -58254,
 477135304,
 70308,
 -58253,
 477199439,
 70274,
 -58252,
 477261352,
 70309,
 -58251,
 477318902,
 70304,
 -58250,
 477382254,
 70307,
 -58249,
 477444764,
 70273,
 -58248,
 477509090,
 70310,
 -58247,
 477571095,
 70275,
 -1,
 477630100,
 70272,
 -1,
 474509040,
 70313,
 -1,
 474431691,
 127926,
 478019583,
 474377667,
 -1,
 478026899,
 477903764,
 -1,
 478092432,
 477982147,
 -1,
 478157967,
 478055074,
 -1,
 478223493,
 478095383,
 -1,
 478289028,
 478166229,
 -1,
 -58237,
 478248708,
 119271,
 -1,
 478291614,
 119270,
 -1,
 478237746,
 119263,
 478551176,
 478176534,
 -1,
 -58233,
 478510852,
 119269,
 -1,
 478553758,
 119268,
 478747787,
 478490412,
 -1,
 -58230,
 478693280,
 119272,
 -1,
 478756359,
 119264,
 -58228,
 478709293,
 119266,
 -58227,
 478898099,
 119265,
 -58226,
 478951025,
 119267,
 -1,
 479009608,
 119262,
 -1,
 478093509,
 127932,
 479272082,
 478037312,
 127929,
 -1,
 479200964,
 127896,
 -1,
 479221391,
 127925,
 -1,
 477968914,
 127812,
 479534285,
 474311763,
 -1,
 479599804,
 479480475,
 -1,
 479665306,
 479557131,
 -1,
 -58216,
 479606629,
 92757,
 -58215,
 479668921,
 92766,
 -1,
 479727252,
 92736,
 479927453,
 479614910,
 92754,
 -58212,
 479877054,
 92753,
 -1,
 479938084,
 92749,
 480124065,
 479872046,
 -1,
 -58209,
 480073662,
 92761,
 -58208,
 480130574,
 92744,
 -1,
 480192661,
 92748,
 480386212,
 480077177,
 -1,
 -58205,
 480335806,
 92755,
 -1,
 480393884,
 92765,
 480582823,
 480337818,
 -1,
 -58202,
 480524370,
 92743,
 -1,
 480579220,
 92752,
 480779434,
 480531318,
 -1,
 -58199,
 480722388,
 92751,
 -1,
 480785582,
 92737,
 480976045,
 480726701,
 -1,
 -58196,
 480918937,
 92739,
 -1,
 480972831,
 92750,
 481172655,
 480921198,
 92763,
 -1,
 481121142,
 92762,
 481303730,
 481113570,
 -1,
 -58191,
 481253310,
 92745,
 -1,
 481311388,
 92764,
 481500340,
 481241111,
 92760,
 -1,
 481431188,
 92758,
 481631414,
 481436443,
 92741,
 -1,
 481573532,
 92746,
 -58185,
 481594066,
 92738,
 -58184,
 481723457,
 92759,
 -58183,
 481784022,
 92756,
 -58182,
 481828335,
 92747,
 -58181,
 481892035,
 92740,
 -1,
 481955476,
 92742,
 482213887,
 479535760,
 -1,
 482221259,
 482098419,
 -1,
 482286785,
 482178571,
 -1,
 -58176,
 482248660,
 92770,
 -1,
 482294192,
 92771,
 482483396,
 482241987,
 -1,
 -58173,
 482427652,
 92774,
 -1,
 482487903,
 92775,
 482680007,
 482422572,
 -1,
 -58170,
 482631131,
 92772,
 -1,
 482689638,
 92773,
 -58168,
 482642801,
 92768,
 -58167,
 482826790,
 92769,
 -58166,
 482891113,
 92777,
 -1,
 482945639,
 92776,
 -58164,
 482172257,
 92783,
 -1,
 483070645,
 92782,
 483269890,
 479496659,
 -1,
 483335406,
 483216027,
 -1,
 483400932,
 483292842,
 -1,
 483466454,
 483336848,
 -1,
 483531988,
 483402384,
 -1,
 -58157,
 483472866,
 43502,
 -1,
 483528340,
 43501,
 -58155,
 483472866,
 43516,
 -1,
 483659412,
 43515,
 483859673,
 483414902,
 -1,
 -58152,
 483822016,
 43495,
 -1,
 483873762,
 43503,
 484056284,
 483804015,
 -1,
 -58149,
 483997154,
 43500,
 -1,
 484052628,
 43499,
 484252895,
 483996433,
 -1,
 -58146,
 484193762,
 43498,
 -1,
 484249236,
 43497,
 484449506,
 484185778,
 -1,
 -58143,
 484390370,
 43518,
 -1,
 484445844,
 43517,
 -58141,
 484396197,
 43514,
 -1,
 484585296,
 43496,
 484835327,
 483356629,
 -1,
 484842731,
 484708971,
 -1,
 -58137,
 484791780,
 43491,
 -58136,
 484852692,
 43490,
 -58135,
 484914259,
 43488,
 -58134,
 484973877,
 43489,
 -1,
 485038189,
 43492,
 485294079,
 484803898,
 -1,
 -58131,
 485191710,
 43647,
 -1,
 485236021,
 43646,
 485432572,
 483292853,
 -1,
 485498098,
 485389835,
 -1,
 -58127,
 485459924,
 43506,
 -1,
 485505456,
 43507,
 485694709,
 485453251,
 -1,
 -58124,
 485638916,
 43510,
 -1,
 485699167,
 43511,
 485891320,
 485633836,
 -1,
 -58121,
 485842395,
 43508,
 -1,
 485900902,
 43509,
 -58119,
 485854065,
 43504,
 -58118,
 486038054,
 43505,
 -58117,
 486102377,
 43513,
 -1,
 486156903,
 43512,
 486350081,
 485388679,
 -1,
 486415616,
 486307526,
 -1,
 -58113,
 486345634,
 43645,
 -1,
 486410613,
 43644,
 -1,
 486371391,
 43493,
 -1,
 486298258,
 43494,
 -58109,
 483230761,
 983173,
 -58108,
 486704154,
 983212,
 -1,
 486757175,
 983224,
 486940993,
 399579971,
 -1,
 487005823,
 486898767,
 -1,
 487071350,
 486954172,
 -1,
 487136866,
 487027079,
 -1,
 487202167,
 487081508,
 -1,
 487267692,
 487132820,
 -1,
 487333225,
 487212156,
 -1,
 487398697,
 487263308,
 -1,
 487464219,
 487328111,
 75009,
 487587839,
 487392524,
 -1,
 487595283,
 487488591,
 -1,
 -58095,
 487550358,
 75019,
 -58094,
 487596688,
 75018,
 -1,
 487655797,
 75017,
 487857430,
 487552523,
 -1,
 -58091,
 487794711,
 75016,
 -1,
 487855054,
 75015,
 -58089,
 487802478,
 75014,
 -58088,
 487998938,
 75013,
 -58087,
 488056807,
 75012,
 -58086,
 488118032,
 75011,
 -1,
 488183086,
 75010,
 488381735,
 487394204,
 75021,
 488505343,
 488310028,
 -1,
 488512800,
 488406095,
 -1,
 -58081,
 488467862,
 75030,
 -1,
 488514192,
 75029,
 488709410,
 488455398,
 75024,
 -1,
 488636934,
 75025,
 -58077,
 488665235,
 75028,
 -58076,
 488792144,
 75027,
 -58075,
 488854864,
 75026,
 -58074,
 488911671,
 75023,
 -1,
 488974287,
 75022,
 -58072,
 488311552,
 75020,
 -1,
 489097430,
 75008,
 489299262,
 487328518,
 -1,
 489364788,
 489229062,
 -1,
 489430323,
 489295369,
 74993,
 489553919,
 489358604,
 -1,
 489561392,
 489447468,
 -1,
 -58065,
 489513014,
 74997,
 -1,
 489574018,
 74996,
 -58063,
 489520335,
 74998,
 -58062,
 489700582,
 74995,
 -1,
 489764223,
 74994,
 -1,
 489359577,
 74992,
 490020153,
 489295369,
 -1,
 -58058,
 489950114,
 75006,
 -58057,
 490015309,
 75005,
 -58056,
 490080629,
 75004,
 -1,
 490145865,
 75003,
 490347836,
 489950114,
 -1,
 -58053,
 490278116,
 75000,
 -1,
 490342473,
 74999,
 -58051,
 490278406,
 75002,
 -1,
 490474863,
 75001,
 490675533,
 489228361,
 -1,
 490741058,
 490605962,
 -1,
 -58047,
 490670364,
 74974,
 -1,
 490735689,
 74973,
 490937669,
 490671010,
 -1,
 -58044,
 490866905,
 74970,
 -1,
 490932297,
 74969,
 491134280,
 490867061,
 -1,
 -58041,
 491064226,
 74967,
 -1,
 491129049,
 74966,
 -58039,
 491064973,
 74975,
 -58038,
 491261301,
 74972,
 -58037,
 491326686,
 74971,
 -58036,
 491391728,
 74968,
 -1,
 491456723,
 74965,
 491658585,
 490604917,
 -1,
 491724114,
 491587957,
 -1,
 -58032,
 491654538,
 74982,
 -58031,
 491719586,
 74981,
 -1,
 491784265,
 74980,
 491986261,
 491654220,
 -1,
 -58028,
 491916364,
 74985,
 -1,
 491981730,
 74984,
 492182872,
 491915481,
 -1,
 -58025,
 492113417,
 74979,
 -1,
 492177481,
 74978,
 -1,
 492112643,
 74983,
 492445026,
 491588173,
 -1,
 492510558,
 492374790,
 -1,
 -58020,
 492440970,
 74988,
 -58019,
 492506340,
 74987,
 -1,
 492571213,
 74986,
 492772705,
 492440970,
 -1,
 -58016,
 492702470,
 74990,
 -1,
 492767821,
 74989,
 -1,
 492703362,
 74991,
 493034853,
 492375268,
 -1,
 -58012,
 492964767,
 75032,
 -1,
 493029950,
 75031,
 493231464,
 492964057,
 -1,
 -58009,
 493161369,
 74977,
 -1,
 493226736,
 74976,
 -1,
 493161540,
 75007,
 493551615,
 487273278,
 -1,
 -58005,
 493456279,
 74964,
 -1,
 493499566,
 74632,
 493748223,
 487226562,
 -1,
 493755765,
 493648129,
 -1,
 493821296,
 493707304,
 75036,
 -1,
 493749178,
 75037,
 -57999,
 493778646,
 75038,
 -57998,
 493908267,
 74635,
 -57997,
 493958739,
 75035,
 -57996,
 494022034,
 74634,
 -1,
 494085393,
 75034,
 -57994,
 493711536,
 74633,
 -1,
 494220713,
 75033,
 494411183,
 487137936,
 -1,
 494476705,
 494369871,
 -1,
 494542240,
 494416666,
 -1,
 494607744,
 494487076,
 -1,
 494673279,
 494538388,
 -1,
 494738814,
 494620333,
 74911,
 -1,
 494667028,
 74912,
 -1,
 494683263,
 74910,
 -1,
 494632480,
 74913,
 495000966,
 494552110,
 -1,
 495066501,
 494959695,
 -1,
 495132036,
 495022383,
 74908,
 -1,
 495059885,
 74909,
 -1,
 495084921,
 74907,
 -1,
 494998857,
 74906,
 495394187,
 494940945,
 -1,
 495459722,
 495336092,
 74900,
 -57975,
 495415253,
 74902,
 -1,
 495478213,
 74901,
 -1,
 495390356,
 74899,
 495721871,
 495341229,
 -1,
 -57971,
 495663772,
 74916,
 -57970,
 495725925,
 74915,
 -1,
 495785262,
 74914,
 495984019,
 495652500,
 -1,
 496049554,
 495939541,
 74894,
 -1,
 495976642,
 74895,
 -1,
 495998719,
 74893,
 496246166,
 495939011,
 -1,
 -57963,
 496188077,
 74920,
 -1,
 496252770,
 74919,
 496442777,
 496186836,
 -1,
 -57960,
 496384668,
 74904,
 -1,
 496438932,
 74903,
 496639388,
 496378512,
 -1,
 -57957,
 496598708,
 74897,
 -1,
 496647636,
 74896,
 -57955,
 496591282,
 74918,
 -57954,
 496784720,
 74917,
 -57953,
 496844010,
 74905,
 -1,
 496905488,
 74898,
 -1,
 494474935,
 74614,
 497163688,
 494418588,
 -1,
 497229223,
 497110701,
 -1,
 497294758,
 497157388,
 -1,
 -57947,
 497253507,
 74891,
 -1,
 497302758,
 74890,
 -1,
 497224216,
 74892,
 -1,
 497184732,
 74613,
 497680383,
 497094292,
 -1,
 497687982,
 497562385,
 -1,
 497753517,
 497614848,
 -1,
 -57940,
 497711368,
 74889,
 -1,
 497763701,
 74611,
 -1,
 497683021,
 74612,
 -1,
 497616159,
 74888,
 498081239,
 494351121,
 -1,
 498146766,
 498011796,
 -1,
 498212301,
 498076148,
 -1,
 498277814,
 498160747,
 74948,
 498401279,
 498205606,
 -1,
 -57931,
 498283694,
 74950,
 -1,
 498346111,
 74949,
 498539962,
 498222628,
 -1,
 498605497,
 498471441,
 74944,
 -1,
 498533652,
 74945,
 -1,
 498564637,
 74946,
 498802110,
 498479927,
 74939,
 498925567,
 498754956,
 -1,
 -57923,
 498816107,
 74941,
 -1,
 498869383,
 74940,
 499064259,
 498737808,
 -1,
 499129794,
 499023366,
 -1,
 -57919,
 499074244,
 74937,
 -1,
 499137770,
 74936,
 -1,
 499072412,
 74935,
 499391942,
 498994836,
 -1,
 -57915,
 499347460,
 74618,
 -1,
 499405702,
 74617,
 -57913,
 499354511,
 74952,
 -57912,
 499544290,
 74951,
 -57911,
 499602272,
 74947,
 -57910,
 499664378,
 74943,
 -57909,
 499725797,
 74942,
 -57908,
 499789037,
 74938,
 -1,
 499848993,
 74934,
 -1,
 498144966,
 74953,
 500112849,
 498105423,
 -1,
 -57904,
 500048591,
 74957,
 -1,
 500107783,
 74956,
 500309460,
 500054684,
 -1,
 -57901,
 500264936,
 74955,
 -1,
 500314897,
 74620,
 500563967,
 500246551,
 -1,
 -57898,
 500461853,
 74954,
 -1,
 500501051,
 74619,
 500702702,
 498029430,
 -1,
 500768233,
 500645332,
 74639,
 500833768,
 500704049,
 -1,
 500899293,
 500792399,
 75050,
 -57892,
 500854166,
 75052,
 -1,
 500892621,
 75051,
 501095905,
 500839185,
 -1,
 501161440,
 501037724,
 74642,
 -1,
 501116885,
 75043,
 -1,
 501120599,
 75044,
 -57886,
 501047363,
 75049,
 -57885,
 501305303,
 75048,
 -57884,
 501368542,
 75047,
 -57883,
 501433624,
 75046,
 -57882,
 501495890,
 75045,
 -57881,
 501556449,
 75042,
 -1,
 501618472,
 74641,
 -1,
 500764169,
 74640,
 501882349,
 500726973,
 -1,
 -57877,
 501839709,
 983256,
 -57876,
 501902563,
 74643,
 -1,
 501964503,
 983257,
 -1,
 501812934,
 74638,
 502210050,
 500647045,
 -1,
 502275585,
 502138124,
 -1,
 502341108,
 502234191,
 -1,
 502406643,
 502293881,
 74963,
 -1,
 502335861,
 74631,
 -1,
 502334802,
 74962,
 502603255,
 502280977,
 -1,
 -57866,
 502562222,
 74625,
 -1,
 502612383,
 74624,
 502799866,
 502533780,
 -1,
 -57863,
 502755354,
 74623,
 -1,
 502814463,
 74622,
 -57861,
 502758255,
 74630,
 -57860,
 502952244,
 74629,
 -57859,
 503013332,
 74628,
 -57858,
 503074450,
 74627,
 -57857,
 503137413,
 74961,
 -57856,
 503199829,
 74626,
 -1,
 503257805,
 74960,
 -1,
 502226847,
 74607,
 503520791,
 502147095,
 -1,
 503586322,
 503483244,
 -1,
 503651853,
 503541921,
 -1,
 503717383,
 503599156,
 74930,
 -1,
 503672259,
 74931,
 503848457,
 503662190,
 74928,
 -1,
 503793188,
 74929,
 -57846,
 503805291,
 74932,
 -57845,
 503921898,
 74927,
 -57844,
 503986258,
 74926,
 -1,
 504042798,
 74925,
 504299519,
 503609601,
 -1,
 504307217,
 504196547,
 -1,
 -57840,
 504265807,
 74933,
 -1,
 504313698,
 74616,
 -1,
 504247706,
 74615,
 504569365,
 503515636,
 -1,
 -57836,
 504520744,
 74922,
 -1,
 504579574,
 74921,
 -57834,
 504524808,
 74924,
 -1,
 504720137,
 74923,
 504897067,
 503475651,
 -1,
 504962595,
 504837588,
 -1,
 505028127,
 504899609,
 -1,
 505093662,
 504980068,
 -1,
 -57828,
 505048739,
 75061,
 -57827,
 505107447,
 75060,
 -1,
 505166394,
 75059,
 -1,
 505044756,
 75058,
 505421346,
 504986822,
 -1,
 -57823,
 505358466,
 75063,
 -1,
 505423834,
 75062,
 -1,
 505351881,
 75057,
 505683498,
 504893624,
 -1,
 505749033,
 505641217,
 -1,
 -57818,
 505706198,
 75056,
 -57817,
 505770080,
 75055,
 -57816,
 505822442,
 74646,
 -1,
 505883463,
 75054,
 -1,
 505689528,
 75053,
 -1,
 505625357,
 75064,
 506207799,
 504855631,
 -1,
 506273333,
 506160505,
 -1,
 506338866,
 506231930,
 -1,
 506404401,
 506283556,
 -1,
 -57808,
 506363098,
 75072,
 -1,
 506401098,
 75071,
 -1,
 506340256,
 75070,
 506724351,
 506268023,
 -1,
 -57804,
 506624274,
 75069,
 -1,
 506675303,
 75068,
 -57802,
 506220247,
 74648,
 -1,
 506791247,
 74649,
 506994240,
 506138260,
 -1,
 507059774,
 506926770,
 -1,
 507125309,
 506987788,
 -1,
 507190844,
 507074450,
 74608,
 -1,
 507118747,
 74880,
 -1,
 507146543,
 74881,
 -1,
 507054589,
 74609,
 -57793,
 507006873,
 74610,
 -1,
 507388671,
 74882,
 507584072,
 506941101,
 -1,
 507649606,
 507543866,
 -1,
 507715141,
 507577188,
 -1,
 -57788,
 507659419,
 75041,
 -1,
 507720503,
 75040,
 -1,
 507644622,
 74637,
 -57785,
 507591363,
 75039,
 -1,
 507915648,
 74636,
 508108368,
 507516594,
 -1,
 508173903,
 508038804,
 -1,
 508239438,
 508114731,
 -1,
 -57780,
 508201711,
 74886,
 -57779,
 508253520,
 74885,
 -1,
 508301050,
 74884,
 -1,
 508175085,
 74883,
 -1,
 508132454,
 74887,
 508632662,
 508065291,
 -1,
 508698196,
 508591746,
 -1,
 -57773,
 508655644,
 75067,
 -1,
 508703616,
 75066,
 -57771,
 508640032,
 74647,
 -1,
 508825937,
 75065,
 509025883,
 508594925,
 -1,
 509091418,
 508984399,
 -1,
 -57767,
 509021194,
 75075,
 -1,
 509084557,
 75074,
 -1,
 509021905,
 75073,
 509353567,
 508966356,
 -1,
 -57763,
 509313338,
 74621,
 -57762,
 509360879,
 74959,
 -1,
 509415092,
 74958,
 509673471,
 509304730,
 -1,
 -57759,
 509559054,
 74645,
 -1,
 509619588,
 74644,
 509812341,
 487085956,
 -1,
 509877867,
 509749271,
 -1,
 509943402,
 509822710,
 -1,
 510008936,
 509882156,
 -1,
 -57753,
 509959325,
 74855,
 -1,
 510016553,
 74856,
 -57751,
 509967405,
 74854,
 -1,
 510155364,
 74853,
 -1,
 509885593,
 74861,
 510402158,
 509832643,
 -1,
 -57747,
 510346033,
 74859,
 -1,
 510406267,
 74860,
 510598769,
 510351914,
 -1,
 -57744,
 510551292,
 74851,
 -1,
 510604904,
 74852,
 510795380,
 510537516,
 -1,
 -57741,
 510746181,
 74857,
 -1,
 510804689,
 74858,
 -1,
 510743941,
 74862,
 -1,
 509764659,
 74868,
 511123067,
 487023993,
 -1,
 511188602,
 511075705,
 -1,
 -57735,
 511150457,
 127835,
 -1,
 511191943,
 128177,
 -1,
 511135397,
 10160,
 511450750,
 511079463,
 -1,
 -57731,
 511400397,
 128707,
 -1,
 511448074,
 127854,
 -1,
 511386122,
 129362,
 511713114,
 486946260,
 -1,
 511778544,
 511649815,
 -1,
 511844074,
 511731065,
 -1,
 511909607,
 511793426,
 -1,
 511975142,
 511865455,
 -1,
 512040598,
 511931915,
 -1,
 512106124,
 511995331,
 -1,
 -57721,
 512065974,
 43960,
 -57720,
 512130127,
 43959,
 -57719,
 512186302,
 43958,
 -57718,
 512244380,
 43957,
 -57717,
 512305175,
 43956,
 -1,
 512364180,
 43955,
 512564883,
 512050724,
 -1,
 -57714,
 512524726,
 43954,
 -57713,
 512588879,
 43953,
 -57712,
 512645054,
 43952,
 -57711,
 512703132,
 43951,
 -57710,
 512763927,
 43950,
 -1,
 512822932,
 43949,
 -57708,
 512506524,
 43944,
 -57707,
 512960535,
 43942,
 -1,
 513019540,
 43940,
 513220253,
 511995331,
 43933,
 -57704,
 513180086,
 43938,
 -57703,
 513244239,
 43937,
 -57702,
 513300414,
 43936,
 -57701,
 513358492,
 43935,
 -57700,
 513419287,
 43934,
 -1,
 513478292,
 43932,
 513679013,
 513168246,
 -1,
 513744544,
 513609364,
 43918,
 -1,
 513684948,
 43920,
 -57695,
 513704374,
 43925,
 -57694,
 513834063,
 43924,
 -57693,
 513890238,
 43923,
 -57692,
 513948316,
 43922,
 -1,
 514009111,
 43921,
 514203309,
 513619412,
 -1,
 -57689,
 514163126,
 43906,
 -57688,
 514227279,
 43905,
 -57687,
 514283454,
 43904,
 -57686,
 514348002,
 43919,
 -57685,
 514407068,
 43903,
 -57684,
 514467863,
 43902,
 -1,
 514526868,
 43901,
 514727605,
 514138768,
 -1,
 -57681,
 514687414,
 43947,
 -57680,
 514751567,
 43946,
 -57679,
 514807742,
 43945,
 -57678,
 514868846,
 43948,
 -57677,
 514931356,
 43943,
 -57676,
 514992151,
 43941,
 -1,
 515051156,
 43939,
 515251900,
 514689396,
 -1,
 -57673,
 515211702,
 5116,
 -57672,
 515275855,
 5115,
 -57671,
 515332030,
 5114,
 -57670,
 515390108,
 5113,
 -57669,
 515450903,
 5112,
 -1,
 515509908,
 43967,
 515710659,
 515212329,
 -1,
 -57666,
 515670454,
 43966,
 -57665,
 515734607,
 43965,
 -57664,
 515790782,
 43964,
 -57663,
 515848860,
 43963,
 -57662,
 515909655,
 43962,
 -1,
 515968660,
 43961,
 516169418,
 515663036,
 -1,
 -57659,
 516129206,
 43931,
 -57658,
 516193359,
 43930,
 -57657,
 516249534,
 43929,
 -57656,
 516307612,
 43928,
 -57655,
 516368407,
 43927,
 -1,
 516427412,
 43926,
 516628177,
 516116141,
 -1,
 -57652,
 516587958,
 5117,
 -57651,
 516652111,
 43917,
 -57650,
 516708286,
 43916,
 -57649,
 516766364,
 43915,
 -57648,
 516827159,
 43914,
 -1,
 516886164,
 43913,
 517086936,
 516572708,
 -1,
 -57645,
 517046710,
 43912,
 -57644,
 517110863,
 43911,
 -57643,
 517167038,
 43910,
 -57642,
 517225116,
 43909,
 -57641,
 517285911,
 43908,
 -1,
 517344916,
 43907,
 517545695,
 517026577,
 -1,
 -57638,
 517505462,
 43900,
 -57637,
 517569615,
 43899,
 -57636,
 517625790,
 43898,
 -57635,
 517683868,
 43897,
 -57634,
 517744663,
 43896,
 -1,
 517803668,
 43894,
 -57632,
 517505462,
 43893,
 -57631,
 517962831,
 43892,
 -57630,
 518019006,
 43891,
 -57629,
 518079621,
 43895,
 -57628,
 518142620,
 43890,
 -57627,
 518203415,
 43889,
 -1,
 518262420,
 43888,
 -1,
 511920829,
 5109,
 518586367,
 511862137,
 -1,
 -57623,
 518490500,
 127800,
 -1,
 518536224,
 127826,
 518725357,
 511780887,
 -1,
 -57620,
 518680288,
 129472,
 -1,
 518744904,
 128227,
 -57618,
 518681775,
 127792,
 -57617,
 518874436,
 127937,
 -1,
 518921921,
 128638,
 519118676,
 511708820,
 -1,
 519184203,
 519062932,
 -1,
 519249699,
 519129755,
 -1,
 519315193,
 519206411,
 -1,
 519380727,
 519271947,
 -1,
 -57610,
 519321071,
 69906,
 -1,
 519376600,
 69905,
 -57608,
 519321071,
 69911,
 -1,
 519507672,
 69910,
 519708414,
 519263094,
 -1,
 -57605,
 519670211,
 69904,
 -57604,
 519721966,
 69909,
 -57603,
 519779130,
 69899,
 -1,
 519835352,
 69914,
 520036100,
 519643792,
 -1,
 520101634,
 519971472,
 -1,
 -57599,
 520041967,
 69908,
 -1,
 520097496,
 69907,
 -57597,
 520041967,
 69913,
 -1,
 520228568,
 69912,
 520429319,
 519997812,
 -1,
 -57594,
 520391107,
 69920,
 -1,
 520425176,
 69921,
 520625930,
 520380314,
 -1,
 -57591,
 520566255,
 69916,
 -1,
 520621784,
 69915,
 520822541,
 520569902,
 -1,
 -57588,
 520762863,
 69896,
 -1,
 520818392,
 69895,
 521019152,
 520766319,
 -1,
 -57585,
 520959471,
 69903,
 -1,
 521015000,
 69902,
 521215763,
 520958737,
 -1,
 -57582,
 521156079,
 69898,
 -1,
 521211608,
 69897,
 521412374,
 521149251,
 -1,
 -57579,
 521352687,
 69901,
 -1,
 521408216,
 69900,
 521608985,
 521344690,
 -1,
 -57576,
 521549295,
 69918,
 -1,
 521604824,
 69917,
 -57574,
 521569348,
 69924,
 -57573,
 521763919,
 69893,
 -57572,
 521825843,
 69925,
 -57571,
 521889244,
 69922,
 -57570,
 521948921,
 69919,
 -57569,
 522012273,
 69923,
 -57568,
 522074780,
 69892,
 -57567,
 522139119,
 69926,
 -57566,
 522201111,
 69894,
 -1,
 522260184,
 69891,
 522460980,
 519185040,
 -1,
 522526514,
 522403059,
 -1,
 522592040,
 522483211,
 -1,
 -57561,
 522553300,
 69944,
 -1,
 522598832,
 69945,
 522788651,
 522546627,
 -1,
 -57558,
 522732292,
 69948,
 -1,
 522792543,
 69949,
 522985262,
 522727212,
 -1,
 -57555,
 522935771,
 69946,
 -1,
 522994278,
 69947,
 -57553,
 522947441,
 69942,
 -57552,
 523131430,
 69943,
 -57551,
 523195753,
 69951,
 -1,
 523250279,
 69950,
 -57549,
 522476897,
 69954,
 -1,
 523375285,
 69953,
 523575105,
 522420662,
 -1,
 523640640,
 523525960,
 -1,
 523706169,
 523570836,
 69927,
 -57544,
 523664463,
 69935,
 -1,
 523713180,
 69933,
 523902779,
 523664463,
 69930,
 -1,
 523861071,
 69931,
 524033853,
 523851710,
 69934,
 -1,
 523975324,
 69936,
 524164927,
 523975324,
 69928,
 -1,
 524106396,
 69929,
 -1,
 524101655,
 69932,
 -1,
 523583768,
 69939,
 524427079,
 523529667,
 -1,
 524492614,
 524369152,
 -1,
 -57532,
 524452723,
 69890,
 -57531,
 524491718,
 69888,
 -1,
 524555126,
 69889,
 -1,
 524429630,
 69952,
 -57528,
 524379472,
 69955,
 -57527,
 524769246,
 69937,
 -57526,
 524832509,
 69940,
 -1,
 524883513,
 69938,
 525139967,
 519136633,
 -1,
 525147984,
 525039226,
 -1,
 525213519,
 525107276,
 128200,
 -1,
 525140069,
 128185,
 -1,
 525150102,
 128201,
 525467647,
 525078492,
 983058,
 525533183,
 525336576,
 -1,
 -57517,
 525436620,
 983139,
 -1,
 525496254,
 983136,
 525672280,
 519060124,
 -1,
 -57514,
 525623930,
 128063,
 -57513,
 525682736,
 128696,
 -1,
 525737660,
 128020,
 -57511,
 525626346,
 127876,
 -1,
 525883448,
 127851,
 526065720,
 511662014,
 -1,
 526131184,
 526012077,
 -1,
 526196719,
 526063803,
 -1,
 526262177,
 526136081,
 -1,
 526327696,
 526206664,
 -1,
 526393192,
 526289268,
 -1,
 526458725,
 526329879,
 -1,
 526524260,
 526411129,
 -1,
 -57501,
 526482511,
 122911,
 -1,
 526531228,
 122912,
 -1,
 526480726,
 122885,
 -57498,
 526416975,
 122915,
 -57497,
 526735294,
 122918,
 -1,
 526783938,
 122913,
 526983022,
 526334620,
 122891,
 527048556,
 526933206,
 -1,
 -57493,
 527004401,
 122919,
 -1,
 527046815,
 122921,
 -57491,
 527010678,
 122889,
 -1,
 527193534,
 122890,
 527376244,
 526937539,
 -1,
 527441778,
 527316436,
 -1,
 -57487,
 527398530,
 122907,
 -1,
 527437460,
 122910,
 -57485,
 527388552,
 122916,
 -1,
 527584634,
 122900,
 527769463,
 527338221,
 -1,
 -57482,
 527710478,
 122886,
 -1,
 527772481,
 122888,
 527966074,
 527726091,
 -1,
 -57479,
 527926292,
 122901,
 -1,
 527987001,
 122908,
 528162685,
 527904556,
 -1,
 -57476,
 528116733,
 122903,
 -1,
 528171546,
 122922,
 528359296,
 528097936,
 -1,
 -57473,
 528308235,
 122884,
 -1,
 528368590,
 122892,
 528555907,
 528291506,
 -1,
 -57470,
 528514643,
 122881,
 -1,
 528563249,
 122920,
 -57468,
 528515614,
 122882,
 -57467,
 528711242,
 122902,
 -57466,
 528772087,
 122899,
 -57465,
 528835287,
 122898,
 -57464,
 528898862,
 122897,
 -57463,
 528962578,
 122896,
 -57462,
 529027950,
 122895,
 -57461,
 529091725,
 122894,
 -57460,
 529155231,
 122893,
 -57459,
 529217578,
 122904,
 -57458,
 529282293,
 122883,
 -57457,
 529341914,
 122909,
 -1,
 529405614,
 122880,
 529661951,
 526280369,
 -1,
 529670043,
 529540314,
 -1,
 529735573,
 529626635,
 -1,
 -57452,
 529696724,
 70504,
 -1,
 529742256,
 70505,
 529932184,
 529674028,
 -1,
 -57449,
 529882587,
 70506,
 -1,
 529941094,
 70507,
 -57447,
 529894257,
 70502,
 -57446,
 530084383,
 70508,
 -1,
 530143782,
 70503,
 530382847,
 529615515,
 -1,
 -57443,
 530285377,
 70515,
 -57442,
 530341844,
 70516,
 -57441,
 530404322,
 70514,
 -57440,
 530465925,
 70513,
 -1,
 530517652,
 70512,
 530718649,
 526206500,
 -1,
 530784180,
 530650583,
 -1,
 530849702,
 530742409,
 -1,
 -57435,
 530795482,
 7664,
 -1,
 530850954,
 7668,
 531046313,
 530798565,
 -1,
 -57432,
 530992090,
 7661,
 -1,
 531047562,
 7667,
 531242923,
 530978482,
 7656,
 -1,
 531180980,
 7657,
 531373998,
 531173012,
 -1,
 -57427,
 531320388,
 7655,
 -1,
 531367406,
 7666,
 -57425,
 531334185,
 7665,
 -57424,
 531525308,
 7658,
 -57423,
 531586970,
 7662,
 -57422,
 531646035,
 7660,
 -57421,
 531705644,
 7659,
 -1,
 531770752,
 7663,
 532021247,
 530725934,
 -1,
 532029368,
 531895817,
 -1,
 -57417,
 531982694,
 65064,
 -1,
 532039913,
 65063,
 -1,
 531970587,
 6841,
 532291531,
 530651971,
 -1,
 532357066,
 532253409,
 -1,
 532422599,
 532302491,
 -1,
 532488127,
 532384116,
 -1,
 -57410,
 532429468,
 42614,
 -1,
 532491617,
 42617,
 532684737,
 532446287,
 42615,
 -1,
 532628931,
 42612,
 532815811,
 532626076,
 42613,
 -1,
 532765946,
 42655,
 -57404,
 532771631,
 42618,
 -57403,
 532896178,
 42619,
 -57402,
 532952887,
 42616,
 -1,
 533015023,
 42654,
 533266431,
 532379995,
 -1,
 -57399,
 533162331,
 65071,
 -1,
 533219551,
 65070,
 -1,
 532306663,
 65069,
 533471190,
 532226704,
 -1,
 533536724,
 533419966,
 -1,
 533602259,
 533495090,
 -1,
 533667794,
 533528576,
 -1,
 -57392,
 533618831,
 6844,
 -57391,
 533683138,
 6840,
 -1,
 533741695,
 7676,
 -1,
 533602982,
 6832,
 -1,
 533563314,
 6835,
 -57387,
 533478183,
 6833,
 -1,
 533998320,
 7675,
 534192094,
 533419966,
 -1,
 534257629,
 534136826,
 -1,
 -57383,
 534219612,
 66424,
 -57382,
 534278625,
 66426,
 -57381,
 534336714,
 66425,
 -57380,
 534390112,
 66423,
 -1,
 534450792,
 66422,
 -1,
 534208798,
 6839,
 534716387,
 534148619,
 -1,
 534781922,
 534658403,
 -1,
 -57375,
 534735206,
 65066,
 -1,
 534792425,
 65065,
 -1,
 534735748,
 6836,
 535044071,
 534667394,
 -1,
 -57371,
 534994717,
 6846,
 -57370,
 535042019,
 6845,
 -1,
 535105336,
 6843,
 535306218,
 534990617,
 -1,
 -57367,
 535259494,
 65068,
 -1,
 535316713,
 65067,
 -57365,
 535267579,
 6837,
 -57364,
 535463510,
 6838,
 -57363,
 535527316,
 7669,
 -57362,
 535590162,
 6842,
 -1,
 535641815,
 6834,
 -1,
 526148500,
 128476,
 535896096,
 526083019,
 -1,
 535961630,
 535833688,
 -1,
 536027152,
 535910233,
 -1,
 536092667,
 535983627,
 -1,
 536158199,
 536052777,
 -1,
 -57354,
 536106950,
 66292,
 -1,
 536161335,
 66283,
 536354810,
 536098260,
 -1,
 -57351,
 536307721,
 66293,
 -1,
 536363411,
 66284,
 -1,
 536292167,
 66282,
 536616962,
 536047043,
 -1,
 536682495,
 536560388,
 -1,
 -57346,
 536640568,
 66287,
 -1,
 536674844,
 66296,
 536936447,
 536620639,
 -1,
 -57343,
 536837176,
 66288,
 -1,
 536871452,
 66297,
 537075721,
 536555308,
 -1,
 537141254,
 537024446,
 -1,
 -57339,
 537100398,
 66294,
 -1,
 537161103,
 66285,
 537395199,
 537082524,
 -1,
 -57336,
 537297397,
 66295,
 -1,
 537342719,
 66286,
 537534476,
 537023849,
 -1,
 -57333,
 537492536,
 66290,
 -1,
 537526812,
 66299,
 537731087,
 537471591,
 -1,
 -57330,
 537692532,
 66289,
 -1,
 537723420,
 66298,
 -1,
 537680440,
 66291,
 537993245,
 535962842,
 -1,
 538058772,
 537949707,
 -1,
 -57325,
 538019796,
 66274,
 -1,
 538065328,
 66275,
 538255383,
 538013123,
 -1,
 -57322,
 538198788,
 66278,
 -1,
 538259039,
 66279,
 538451994,
 538193708,
 -1,
 -57319,
 538402267,
 66276,
 -1,
 538460774,
 66277,
 -57317,
 538401318,
 66273,
 -57316,
 538596713,
 66281,
 -1,
 538651239,
 66280,
 -1,
 537950214,
 66272,
 -57313,
 535917181,
 11507,
 -1,
 538844143,
 11506,
 539041836,
 535843702,
 -1,
 539107365,
 538980140,
 -1,
 -57309,
 539066672,
 128533,
 -57308,
 539123141,
 128534,
 -1,
 539176403,
 127882,
 539369512,
 539065149,
 -1,
 -57305,
 539324319,
 983186,
 -1,
 539379103,
 127899,
 539566123,
 539325771,
 -1,
 -57302,
 539527300,
 128119,
 -1,
 539586946,
 128679,
 -1,
 539525717,
 127978,
 539828273,
 538990830,
 -1,
 539893808,
 539769500,
 -1,
 -57297,
 539841803,
 127859,
 -1,
 539895831,
 127850,
 -1,
 539830656,
 127834,
 540155955,
 539788329,
 128004,
 -1,
 540082649,
 128046,
 540287030,
 540113999,
 -1,
 -57291,
 540238371,
 128145,
 -1,
 540286221,
 128715,
 -57289,
 540232923,
 128165,
 -1,
 540417761,
 127864,
 540614821,
 525995668,
 -1,
 540680325,
 540573072,
 -1,
 540745860,
 540625563,
 -1,
 540811335,
 540678979,
 -1,
 540876865,
 540751316,
 -1,
 540942399,
 540806804,
 66873,
 -1,
 540898827,
 66902,
 -57280,
 540893033,
 66889,
 -1,
 541014684,
 66890,
 541204548,
 540838336,
 -1,
 -57277,
 541165940,
 66891,
 -1,
 541230121,
 66911,
 541458431,
 541134484,
 -1,
 -57274,
 541362887,
 66912,
 -1,
 541418873,
 66882,
 541597773,
 540765635,
 -1,
 541663308,
 541537748,
 -1,
 541728843,
 541593236,
 66877,
 -1,
 541672494,
 66896,
 -1,
 541679465,
 66909,
 -1,
 541601576,
 66906,
 541990995,
 541532816,
 -1,
 542056529,
 541952749,
 -1,
 -57264,
 542018032,
 66895,
 -1,
 542054026,
 66901,
 -57262,
 542017999,
 66881,
 -1,
 542184825,
 66867,
 542384216,
 541952749,
 -1,
 542449751,
 542324180,
 -1,
 -57258,
 542391630,
 66871,
 -1,
 542445204,
 66875,
 -1,
 542381119,
 66869,
 542711900,
 542340619,
 -1,
 -57254,
 542673392,
 66899,
 -57253,
 542720768,
 66908,
 -1,
 542774541,
 66872,
 542974048,
 542653084,
 -1,
 -57250,
 542934924,
 66910,
 -57249,
 542992142,
 66876,
 -1,
 543053740,
 66879,
 543236195,
 542935412,
 -1,
 -57246,
 543186756,
 66874,
 -1,
 543233686,
 66913,
 543432806,
 543188104,
 -1,
 -57243,
 543394164,
 66887,
 -1,
 543450489,
 66893,
 543629417,
 543383450,
 -1,
 -57240,
 543572736,
 66914,
 -1,
 543632199,
 66903,
 543826028,
 543573540,
 -1,
 -57237,
 543787652,
 66885,
 -1,
 543822440,
 66878,
 544022639,
 543769646,
 -1,
 -57234,
 543965949,
 66915,
 -1,
 544019406,
 66884,
 544219250,
 543966063,
 -1,
 -57231,
 544160172,
 66883,
 -1,
 544216746,
 66897,
 544415861,
 544158481,
 -1,
 -57228,
 544357785,
 66866,
 -1,
 544421953,
 66904,
 544612472,
 544352279,
 -1,
 -57225,
 544574151,
 66870,
 -1,
 544609970,
 66868,
 544809083,
 544542356,
 -1,
 -57222,
 544758801,
 66888,
 -1,
 544820815,
 66864,
 -57220,
 544770329,
 66880,
 -57219,
 544965436,
 66907,
 -57218,
 545023673,
 66905,
 -57217,
 545085905,
 66898,
 -57216,
 545150632,
 66894,
 -57215,
 545214357,
 66892,
 -57214,
 545273926,
 66886,
 -57213,
 545337231,
 66900,
 -1,
 545396751,
 66865,
 -1,
 540679815,
 66927,
 545661071,
 540632441,
 -1,
 545726602,
 545596050,
 -1,
 545792137,
 545668665,
 128199,
 -1,
 545718682,
 128450,
 -1,
 545730592,
 128451,
 545988749,
 545678713,
 -1,
 -57204,
 545938615,
 129365,
 -1,
 545995573,
 983073,
 -57202,
 545939377,
 127887,
 -1,
 546135640,
 127904,
 546316439,
 545608566,
 983098,
 546381971,
 546249933,
 983097,
 -57198,
 546326470,
 128473,
 -1,
 546373966,
 983170,
 546578582,
 546316944,
 -1,
 -57195,
 546539892,
 127852,
 -1,
 546588735,
 128367,
 -1,
 546527347,
 128758,
 546840732,
 546272779,
 128008,
 546963455,
 546767321,
 128049,
 547028991,
 546833756,
 -1,
 -57189,
 546932927,
 128572,
 -1,
 546993949,
 128569,
 547168416,
 546786989,
 -1,
 547233951,
 547105999,
 128247,
 -1,
 547161692,
 128248,
 -1,
 547185092,
 127957,
 547430563,
 547112484,
 -1,
 -57182,
 547374630,
 129305,
 -1,
 547433391,
 128197,
 -57180,
 547381725,
 11839,
 -1,
 547561975,
 127797,
 547758321,
 540558884,
 -1,
 547823846,
 547706814,
 -1,
 547889369,
 547757717,
 -1,
 547954898,
 547815903,
 -1,
 548020407,
 547911179,
 -1,
 548085937,
 547980329,
 -1,
 548151470,
 548034494,
 -1,
 -57171,
 548079681,
 128349,
 -1,
 548143846,
 128337,
 548405247,
 548088597,
 -1,
 -57168,
 548276289,
 128359,
 -1,
 548340454,
 128347,
 548544692,
 548026800,
 -1,
 -57165,
 548472897,
 128350,
 -1,
 548537062,
 128338,
 548798463,
 548481863,
 -1,
 -57162,
 548669505,
 128357,
 -1,
 548733670,
 128345,
 548937918,
 547974595,
 -1,
 549003451,
 548881156,
 -1,
 -57158,
 548931649,
 128353,
 -1,
 548995814,
 128341,
 549257215,
 548941407,
 -1,
 -57155,
 549128257,
 128354,
 -1,
 549192422,
 128342,
 549396677,
 548876076,
 -1,
 549462210,
 549346779,
 -1,
 -57151,
 549390401,
 128351,
 -1,
 549454566,
 128339,
 549715967,
 549405286,
 -1,
 -57148,
 549587009,
 128352,
 -1,
 549651174,
 128340,
 549855436,
 549333015,
 -1,
 549920969,
 549800742,
 -1,
 -57144,
 549849153,
 128358,
 -1,
 549913318,
 128346,
 550174719,
 549862523,
 -1,
 -57141,
 550045761,
 128355,
 -1,
 550109926,
 128343,
 550314191,
 549804582,
 -1,
 -57138,
 550242369,
 128348,
 -1,
 550306534,
 128336,
 550567935,
 550262121,
 -1,
 -57135,
 550438977,
 128356,
 -1,
 550503142,
 128344,
 550764543,
 547915413,
 -1,
 550772951,
 550660401,
 -1,
 550838486,
 550732950,
 128257,
 -1,
 550765994,
 128258,
 -1,
 550764592,
 128472,
 -57128,
 550730468,
 11118,
 -1,
 550971207,
 128259,
 551166176,
 547843850,
 -1,
 551231709,
 551112491,
 -1,
 -57124,
 551183901,
 128235,
 -1,
 551243311,
 128234,
 -57122,
 551190175,
 127746,
 -57121,
 551374105,
 128272,
 -1,
 551426595,
 128213,
 551624933,
 551124401,
 -1,
 -57118,
 551582178,
 127786,
 -57117,
 551645994,
 127784,
 -57116,
 551708184,
 127783,
 -1,
 551767083,
 127785,
 -1,
 551585679,
 129313,
 552018156,
 547753620,
 -1,
 552083690,
 551969622,
 -1,
 -57111,
 552025851,
 128079,
 -1,
 552086709,
 127916,
 -57109,
 552039435,
 127963,
 -1,
 552227619,
 128385,
 552468479,
 551959196,
 -1,
 552476912,
 552359382,
 -1,
 -57105,
 552416509,
 129346,
 -1,
 552474554,
 127867,
 -1,
 552427745,
 128203,
 552739094,
 547719540,
 -1,
 552804629,
 552692468,
 -1,
 552870154,
 552759919,
 -1,
 552935674,
 552826379,
 -1,
 553001209,
 552866259,
 -1,
 -57097,
 552962531,
 7303,
 -57096,
 553023237,
 7300,
 -1,
 553072439,
 7302,
 -1,
 552942083,
 7301,
 553328894,
 552870544,
 -1,
 -57092,
 553290674,
 1323,
 -57091,
 553344365,
 42649,
 -1,
 553393491,
 1325,
 553591041,
 553280889,
 -1,
 -57088,
 553541073,
 7296,
 -1,
 553594546,
 42593,
 553787652,
 553527319,
 -1,
 -57085,
 553735091,
 1321,
 -1,
 553797186,
 1327,
 -57083,
 553748032,
 7299,
 -57082,
 553942719,
 7304,
 -57081,
 554004674,
 1319,
 -57080,
 554062844,
 7298,
 -57079,
 554126661,
 7297,
 -1,
 554181026,
 42651,
 554434559,
 552803295,
 -1,
 554443023,
 554312336,
 -1,
 -57075,
 554404786,
 1322,
 -57074,
 554458477,
 42648,
 -1,
 554507603,
 1324,
 554705170,
 554379287,
 -1,
 -57071,
 554652595,
 1320,
 -1,
 554714690,
 1326,
 -57069,
 554660034,
 1318,
 -57068,
 554854602,
 42592,
 -1,
 554901922,
 42650,
 -1,
 552738556,
 127744,
 555163947,
 552691065,
 983074,
 555229473,
 555112382,
 -1,
 555295006,
 555185146,
 -1,
 555360541,
 555220992,
 -1,
 555426076,
 555311854,
 128322,
 -1,
 555353719,
 128321,
 -1,
 555372455,
 10060,
 -1,
 555297118,
 127884,
 -57057,
 555255692,
 128081,
 -57056,
 555631081,
 129360,
 -1,
 555687733,
 128010,
 555884838,
 555190644,
 -1,
 555950373,
 555826916,
 -1,
 -57052,
 555888467,
 128546,
 -1,
 555949123,
 128575,
 -1,
 555906122,
 128302,
 556212521,
 555821079,
 -1,
 -57048,
 556166833,
 127769,
 -1,
 556213526,
 128179,
 -57046,
 556153791,
 127951,
 -1,
 556338935,
 129408,
 556540218,
 555104924,
 -1,
 556605751,
 556492561,
 -1,
 556671286,
 556550318,
 -1,
 556736819,
 556612252,
 -1,
 556802354,
 556672026,
 -1,
 -57039,
 556738559,
 127568,
 -1,
 556801168,
 127569,
 -1,
 556750073,
 128712,
 -57036,
 556697810,
 11198,
 -57035,
 556999053,
 128320,
 -1,
 557062684,
 11199,
 -1,
 556630299,
 127914,
 557326649,
 556563527,
 127961,
 -1,
 557252793,
 127750,
 -1,
 557274309,
 127910,
 557523261,
 556483561,
 -1,
 -57028,
 557461292,
 64047,
 -1,
 557525015,
 64046,
 -57026,
 557478201,
 983187,
 -57025,
 557659378,
 983200,
 -57024,
 557722377,
 128328,
 -1,
 557784330,
 983171,
 557982746,
 486884900,
 -1,
 558047992,
 557922972,
 -1,
 558113497,
 557994870,
 -1,
 558179030,
 558049303,
 -1,
 558244562,
 558109649,
 -1,
 558309798,
 558175922,
 -1,
 558375319,
 558237769,
 -1,
 558440791,
 558303605,
 -1,
 558506316,
 558369141,
 67090,
 -57013,
 558452397,
 67092,
 -1,
 558509868,
 67091,
 558702927,
 558434521,
 67087,
 -57010,
 558649005,
 67089,
 -1,
 558706476,
 67088,
 558899537,
 558631501,
 67093,
 -1,
 558845613,
 67094,
 -57006,
 558829065,
 67100,
 -57005,
 558960010,
 67098,
 -57004,
 559025380,
 67097,
 -57003,
 559090764,
 67096,
 -57002,
 559155974,
 67095,
 -1,
 559220809,
 67086,
 559423841,
 558369698,
 -1,
 -56999,
 559353353,
 67123,
 -56998,
 559418762,
 67122,
 -56997,
 559484132,
 67121,
 -56996,
 559549516,
 67120,
 -56995,
 559614882,
 67119,
 -56994,
 559680262,
 67118,
 -56993,
 559745613,
 67117,
 -56992,
 559810777,
 67116,
 -1,
 559876169,
 67115,
 560079211,
 559351881,
 -1,
 -56989,
 560008713,
 67080,
 -56988,
 560074122,
 67079,
 -56987,
 560139492,
 67078,
 -56986,
 560204876,
 67077,
 -56985,
 560270242,
 67076,
 -56984,
 560335622,
 67075,
 -56983,
 560400973,
 67074,
 -56982,
 560466293,
 67073,
 -1,
 560531673,
 67072,
 560734580,
 560007942,
 -1,
 -56979,
 560664073,
 67114,
 -56978,
 560729482,
 67113,
 -56977,
 560794852,
 67112,
 -56976,
 560860236,
 67111,
 -56975,
 560925602,
 67110,
 -56974,
 560990982,
 67109,
 -56973,
 561055961,
 67108,
 -1,
 561121353,
 67107,
 561324412,
 560663780,
 -1,
 -56970,
 561253897,
 67136,
 -56969,
 561319306,
 67135,
 -56968,
 561384676,
 67134,
 -56967,
 561450060,
 67133,
 -56966,
 561515270,
 67132,
 -56965,
 561580621,
 67131,
 -1,
 561645641,
 67130,
 561848707,
 561253770,
 -1,
 -56962,
 561777892,
 67142,
 -56961,
 561843276,
 67141,
 -56960,
 561908642,
 67140,
 -56959,
 561973621,
 67139,
 -56958,
 562039001,
 67138,
 -1,
 562104393,
 67137,
 562307466,
 561777740,
 -1,
 -56955,
 562236937,
 67129,
 -56954,
 562302180,
 67128,
 -56953,
 562367564,
 67127,
 -56952,
 562432930,
 67126,
 -56951,
 562497753,
 67125,
 -1,
 562563145,
 67124,
 562766225,
 562235981,
 -1,
 -56948,
 562695689,
 67106,
 -56947,
 562761098,
 67105,
 -56946,
 562826468,
 67104,
 -56945,
 562891526,
 67103,
 -56944,
 562956505,
 67102,
 -1,
 563021897,
 67101,
 563281919,
 562694361,
 -1,
 -56941,
 563154148,
 67085,
 -56940,
 563219532,
 67084,
 -56939,
 563284557,
 67083,
 -56938,
 563349721,
 67082,
 -1,
 563415113,
 67081,
 563675135,
 558303449,
 -1,
 563683740,
 563546485,
 -1,
 -56934,
 563612237,
 67148,
 -56933,
 563677557,
 67147,
 -1,
 563742793,
 67145,
 563945887,
 563613066,
 -1,
 -56930,
 563875210,
 67155,
 -1,
 563939401,
 67154,
 564142498,
 563874547,
 -1,
 -56927,
 564074162,
 67150,
 -1,
 564137620,
 67149,
 -56925,
 564072069,
 67156,
 -56924,
 564268402,
 67153,
 -56923,
 564333793,
 67152,
 -1,
 564398450,
 67144,
 564601345,
 558238626,
 -1,
 564666802,
 564530570,
 -1,
 -56919,
 564596233,
 67324,
 -56918,
 564661642,
 67323,
 -56917,
 564727012,
 67322,
 -56916,
 564792396,
 67321,
 -56915,
 564857762,
 67320,
 -56914,
 564923142,
 67319,
 -56913,
 564988493,
 67318,
 -56912,
 565053813,
 67317,
 -56911,
 565119193,
 67316,
 -1,
 565184585,
 67315,
 565387709,
 564595940,
 -1,
 -56908,
 565317129,
 67314,
 -56907,
 565382538,
 67313,
 -56906,
 565447908,
 67312,
 -56905,
 565513292,
 67311,
 -56904,
 565578658,
 67310,
 -56903,
 565644038,
 67309,
 -56902,
 565709389,
 67308,
 -56901,
 565774709,
 67307,
 -56900,
 565840089,
 67306,
 -1,
 565905481,
 67305,
 566108615,
 565316514,
 -1,
 -56897,
 566038025,
 67298,
 -56896,
 566103268,
 67297,
 -56895,
 566168652,
 67296,
 -56894,
 566234018,
 67295,
 -56893,
 566299398,
 67294,
 -56892,
 566364749,
 67293,
 -56891,
 566430069,
 67292,
 -56890,
 566495449,
 67291,
 -1,
 566560841,
 67290,
 566763985,
 566037069,
 -1,
 -56887,
 566693385,
 67282,
 -56886,
 566758794,
 67281,
 -56885,
 566824164,
 67280,
 -56884,
 566889548,
 67279,
 -56883,
 566954914,
 67278,
 -56882,
 567020294,
 67277,
 -56881,
 567085429,
 67276,
 -56880,
 567150809,
 67275,
 -1,
 567216201,
 67274,
 567419355,
 566692213,
 -1,
 -56877,
 567348745,
 67273,
 -56876,
 567414154,
 67272,
 -56875,
 567479524,
 67271,
 -56874,
 567544908,
 67270,
 -56873,
 567610274,
 67269,
 -56872,
 567675654,
 67268,
 -56871,
 567741005,
 67267,
 -56870,
 567806169,
 67266,
 -1,
 567871561,
 67265,
 568074724,
 567347273,
 -1,
 -56867,
 568004105,
 67258,
 -56866,
 568069514,
 67257,
 -56865,
 568134732,
 67256,
 -56864,
 568200098,
 67255,
 -56863,
 568265478,
 67254,
 -56862,
 568330829,
 67253,
 -56861,
 568396149,
 67252,
 -1,
 568461529,
 67251,
 568664556,
 568003334,
 -1,
 -56858,
 568593929,
 67289,
 -56857,
 568659338,
 67288,
 -56856,
 568724708,
 67287,
 -56855,
 568789922,
 67286,
 -56854,
 568854901,
 67285,
 -56853,
 568920281,
 67284,
 -1,
 568985673,
 67283,
 569188851,
 568593929,
 -1,
 -56850,
 569118090,
 67330,
 -56849,
 569183308,
 67329,
 -56848,
 569248674,
 67328,
 -56847,
 569314054,
 67327,
 -56846,
 569379189,
 67326,
 -1,
 569444569,
 67325,
 569647610,
 569117772,
 -1,
 -56843,
 569576969,
 67304,
 -56842,
 569642378,
 67303,
 -56841,
 569707596,
 67302,
 -56840,
 569772962,
 67301,
 -56839,
 569838342,
 67300,
 -1,
 569903693,
 67299,
 570163199,
 569575641,
 -1,
 -56836,
 570035276,
 67264,
 -56835,
 570100642,
 67263,
 -56834,
 570165837,
 67262,
 -56833,
 570231157,
 67261,
 -56832,
 570296537,
 67260,
 -1,
 570361929,
 67259,
 570565207,
 564529741,
 -1,
 570630672,
 570493145,
 -1,
 570696199,
 570559053,
 -1,
 -56827,
 570628931,
 67173,
 -56826,
 570693298,
 67172,
 -1,
 570756756,
 67171,
 -56824,
 570625545,
 67179,
 -56823,
 570887562,
 67178,
 -56822,
 570952932,
 67177,
 -56821,
 571018316,
 67176,
 -56820,
 571083682,
 67175,
 -56819,
 571149062,
 67174,
 -56818,
 571214197,
 67170,
 -56817,
 571279577,
 67169,
 -1,
 571344969,
 67168,
 571548189,
 570558537,
 -1,
 571613717,
 571477513,
 -1,
 -56813,
 571546435,
 67167,
 -56812,
 571610802,
 67166,
 -1,
 571674260,
 67165,
 -56810,
 571542922,
 67164,
 -56809,
 571804900,
 67163,
 -56808,
 571870284,
 67162,
 -56807,
 571935650,
 67161,
 -56806,
 572001030,
 67160,
 -56805,
 572066381,
 67159,
 -56804,
 572131701,
 67158,
 -1,
 572197081,
 67157,
 572400168,
 571477068,
 -1,
 -56801,
 572329481,
 67229,
 -56800,
 572394890,
 67228,
 -56799,
 572460260,
 67227,
 -56798,
 572525644,
 67226,
 -56797,
 572591010,
 67225,
 -56796,
 572656390,
 67224,
 -56795,
 572721741,
 67223,
 -56794,
 572787061,
 67222,
 -56793,
 572852441,
 67221,
 -1,
 572917833,
 67220,
 573121075,
 572328866,
 -1,
 -56790,
 573050377,
 67219,
 -56789,
 573115786,
 67218,
 -56788,
 573181156,
 67217,
 -56787,
 573246540,
 67216,
 -56786,
 573311906,
 67215,
 -56785,
 573377286,
 67214,
 -56784,
 573442637,
 67213,
 -56783,
 573507957,
 67212,
 -56782,
 573573337,
 67211,
 -1,
 573638729,
 67210,
 573841982,
 573049606,
 -1,
 -56779,
 573771273,
 67209,
 -56778,
 573836682,
 67208,
 -56777,
 573902052,
 67207,
 -56776,
 573967436,
 67206,
 -56775,
 574032802,
 67205,
 -56774,
 574098182,
 67204,
 -56773,
 574163533,
 67203,
 -56772,
 574228853,
 67202,
 -56771,
 574294233,
 67201,
 -1,
 574359625,
 67200,
 574562889,
 573770317,
 -1,
 -56768,
 574492169,
 67199,
 -56767,
 574557578,
 67198,
 -56766,
 574622948,
 67197,
 -56765,
 574688332,
 67196,
 -56764,
 574753698,
 67195,
 -56763,
 574819078,
 67194,
 -56762,
 574884429,
 67193,
 -56761,
 574949749,
 67192,
 -56760,
 575015129,
 67191,
 -1,
 575080521,
 67190,
 575283796,
 574490997,
 -1,
 -56757,
 575213065,
 67189,
 -56756,
 575278474,
 67188,
 -56755,
 575343844,
 67187,
 -56754,
 575409228,
 67186,
 -56753,
 575474594,
 67185,
 -56752,
 575539974,
 67184,
 -56751,
 575605325,
 67183,
 -56750,
 575670645,
 67182,
 -56749,
 575736025,
 67181,
 -1,
 575801417,
 67180,
 576061439,
 575212772,
 -1,
 -56746,
 575932633,
 67231,
 -1,
 575998025,
 67230,
 576201363,
 570494028,
 -1,
 576266851,
 576129241,
 -1,
 -56742,
 576196105,
 67348,
 -56741,
 576261514,
 67347,
 -56740,
 576326884,
 67346,
 -56739,
 576392268,
 67345,
 -56738,
 576457634,
 67344,
 -56737,
 576523014,
 67343,
 -56736,
 576588365,
 67342,
 -56735,
 576653685,
 67341,
 -56734,
 576719065,
 67340,
 -1,
 576784457,
 67339,
 576987757,
 576195490,
 -1,
 -56731,
 576917001,
 67377,
 -56730,
 576982410,
 67376,
 -56729,
 577047780,
 67375,
 -56728,
 577113164,
 67374,
 -56727,
 577178530,
 67373,
 -56726,
 577243910,
 67372,
 -56725,
 577309261,
 67371,
 -56724,
 577374581,
 67370,
 -1,
 577439961,
 67369,
 577643127,
 576915829,
 -1,
 -56721,
 577572361,
 67357,
 -56720,
 577637770,
 67356,
 -56719,
 577703140,
 67355,
 -56718,
 577768524,
 67354,
 -56717,
 577833734,
 67353,
 -56716,
 577899085,
 67352,
 -56715,
 577964405,
 67351,
 -56714,
 578029785,
 67350,
 -1,
 578095177,
 67349,
 578298496,
 577571590,
 -1,
 -56711,
 578227721,
 67368,
 -56710,
 578293130,
 67367,
 -56709,
 578358348,
 67366,
 -56708,
 578423714,
 67365,
 -56707,
 578489094,
 67364,
 -56706,
 578554445,
 67363,
 -56705,
 578619765,
 67362,
 -1,
 578685001,
 67361,
 578888329,
 578226249,
 -1,
 -56702,
 578817545,
 67338,
 -56701,
 578882954,
 67337,
 -56700,
 578948172,
 67336,
 -56699,
 579013382,
 67335,
 -56698,
 579078733,
 67334,
 -56697,
 579144053,
 67333,
 -56696,
 579209433,
 67332,
 -1,
 579274825,
 67331,
 579478159,
 578817100,
 -1,
 -56693,
 579406598,
 67382,
 -56692,
 579471949,
 67381,
 -56691,
 579537269,
 67380,
 -56690,
 579602649,
 67379,
 -1,
 579668041,
 67378,
 579928063,
 579406413,
 -1,
 -56687,
 579800458,
 67360,
 -56686,
 579865828,
 67359,
 -1,
 579930886,
 67358,
 580133550,
 576130276,
 -1,
 580199076,
 580061257,
 -1,
 580264604,
 580128265,
 -1,
 580330139,
 580192161,
 -1,
 -56680,
 580258949,
 67404,
 -56679,
 580324142,
 67403,
 -56678,
 580389529,
 67402,
 -1,
 580454823,
 67401,
 -1,
 580256344,
 67400,
 -56675,
 580193725,
 67399,
 -56674,
 580652307,
 67398,
 -56673,
 580717669,
 67397,
 -56672,
 580783022,
 67396,
 -56671,
 580848402,
 67395,
 -56670,
 580913749,
 67394,
 -56669,
 580979066,
 67393,
 -1,
 581044443,
 67392,
 581247660,
 580126937,
 -1,
 -56666,
 581176560,
 67411,
 -56665,
 581241769,
 67410,
 -56664,
 581307148,
 67409,
 -56663,
 581372609,
 67408,
 -56662,
 581437992,
 67407,
 -56661,
 581503313,
 67406,
 -1,
 581568696,
 67405,
 -56659,
 581176058,
 67413,
 -1,
 581700161,
 67412,
 581903044,
 580061958,
 -1,
 581968570,
 581830729,
 -1,
 -56655,
 581897852,
 67241,
 -56654,
 581963261,
 67240,
 -56653,
 582028649,
 67239,
 -56652,
 582094040,
 67238,
 -56651,
 582159418,
 67237,
 -56650,
 582224783,
 67236,
 -56649,
 582290154,
 67235,
 -56648,
 582355505,
 67234,
 -56647,
 582420841,
 67233,
 -1,
 582486209,
 67232,
 582746111,
 581896409,
 -1,
 -56644,
 582618621,
 67250,
 -56643,
 582684009,
 67249,
 -56642,
 582749400,
 67248,
 -56641,
 582814778,
 67247,
 -56640,
 582880143,
 67246,
 -56639,
 582945514,
 67245,
 -56638,
 583010865,
 67244,
 -56637,
 583076201,
 67243,
 -1,
 583141569,
 67242,
 583344845,
 581832195,
 -1,
 -56634,
 583273700,
 67431,
 -56633,
 583339084,
 67430,
 -56632,
 583404450,
 67429,
 -56631,
 583469830,
 67428,
 -56630,
 583535181,
 67427,
 -56629,
 583600501,
 67426,
 -56628,
 583665881,
 67425,
 -1,
 583731273,
 67424,
 583934673,
 583272665,
 -1,
 -56625,
 583863030,
 67151,
 -56624,
 583928375,
 67146,
 -1,
 583993543,
 67143,
 -1,
 583862478,
 67099,
 584318975,
 558170112,
 -1,
 584327893,
 584218260,
 983068,
 -1,
 584254518,
 983142,
 -1,
 584265662,
 983062,
 584581119,
 558122030,
 -1,
 -56616,
 584460658,
 128391,
 -1,
 584516749,
 128279,
 584721137,
 558052113,
 -1,
 584786672,
 584661528,
 -1,
 584852206,
 584712192,
 -1,
 584917731,
 584789804,
 -1,
 584983264,
 584867348,
 -1,
 -56609,
 584938580,
 128964,
 -1,
 584983158,
 11212,
 585236479,
 584925802,
 -1,
 -56606,
 585135052,
 128943,
 -1,
 585196172,
 128969,
 585376486,
 584873483,
 -1,
 -56603,
 585336134,
 128978,
 -1,
 585382365,
 128960,
 585573097,
 585330115,
 -1,
 -56600,
 585515794,
 128949,
 -1,
 585568778,
 128937,
 -56598,
 585532960,
 128910,
 -56597,
 585721355,
 128648,
 -56596,
 585774451,
 128930,
 -56595,
 585837190,
 128955,
 -1,
 585899357,
 128504,
 586153983,
 584799654,
 128498,
 -1,
 586023175,
 128497,
 -1,
 584717840,
 128626,
 586294003,
 584672200,
 128482,
 -1,
 586250413,
 128132,
 586425078,
 586240031,
 -1,
 -56587,
 586381876,
 6430,
 -1,
 586429903,
 6429,
 -56585,
 586386263,
 129422,
 -1,
 586570200,
 129409,
 586752945,
 557977236,
 -1,
 586818459,
 586709275,
 -1,
 586883955,
 586771907,
 -1,
 586949482,
 586829678,
 -1,
 587014920,
 586902979,
 -1,
 587080453,
 586947395,
 -1,
 587145986,
 587033494,
 -1,
 587211521,
 587097465,
 43851,
 -1,
 587138864,
 43852,
 -1,
 587150115,
 43830,
 587464703,
 587086467,
 -1,
 -56572,
 587347309,
 983617,
 -1,
 587403245,
 983618,
 -56570,
 587037010,
 43845,
 -56569,
 587534711,
 43872,
 -1,
 587597531,
 42921,
 587801364,
 586946226,
 -1,
 587866893,
 587744956,
 -1,
 587932428,
 587814846,
 43837,
 -1,
 587859808,
 43838,
 -1,
 587868183,
 43826,
 588129042,
 587796116,
 -1,
 588194577,
 588082469,
 -1,
 -56560,
 588130327,
 43827,
 -1,
 588190178,
 43824,
 -1,
 588148514,
 43853,
 -56557,
 588066228,
 42933,
 -1,
 588383848,
 42903,
 588587807,
 587758471,
 -1,
 588653339,
 588535742,
 -1,
 588718873,
 588589150,
 -1,
 -56552,
 588674315,
 43841,
 -1,
 588724598,
 43842,
 588972031,
 588645173,
 43843,
 -1,
 588842848,
 43844,
 589046558,
 588612032,
 -1,
 -56547,
 588985709,
 983615,
 -1,
 589041645,
 983616,
 -1,
 589004333,
 43857,
 589308711,
 588545103,
 -1,
 589374245,
 589234176,
 -1,
 589439780,
 589334176,
 -1,
 -56541,
 589394183,
 43854,
 -1,
 589449481,
 43858,
 -1,
 589371203,
 43855,
 -56538,
 589322174,
 43875,
 -1,
 589642396,
 43856,
 589833007,
 589256638,
 -1,
 589898542,
 589783351,
 -1,
 589964077,
 589825372,
 -1,
 -56533,
 589919499,
 43839,
 -56532,
 589968749,
 983613,
 -1,
 590024685,
 983614,
 -1,
 589899799,
 43874,
 -1,
 589844719,
 42935,
 590357302,
 589776420,
 -1,
 590422837,
 590284124,
 -1,
 -56526,
 590375070,
 42894,
 -56525,
 590434725,
 43833,
 -56524,
 590495892,
 43831,
 -1,
 590554691,
 43832,
 -1,
 590359488,
 43829,
 590816062,
 590289731,
 -1,
 590881595,
 590755922,
 43859,
 591003647,
 590808784,
 -1,
 -56518,
 590899650,
 43860,
 -1,
 590956871,
 43861,
 591200255,
 590808412,
 -1,
 -56515,
 591093770,
 42900,
 -1,
 591140671,
 42899,
 591340356,
 590776561,
 -1,
 591405891,
 591287566,
 43863,
 591527935,
 591331328,
 -1,
 -56510,
 591431465,
 43865,
 -1,
 591467146,
 43864,
 -1,
 591365172,
 43862,
 591733576,
 591299524,
 -1,
 -56506,
 591691220,
 42911,
 -56505,
 591747187,
 42909,
 -1,
 591794204,
 42907,
 591995725,
 591685016,
 -1,
 592061260,
 591921152,
 -1,
 -56501,
 592009212,
 42919,
 -1,
 592060844,
 43849,
 -1,
 592010856,
 43847,
 592323409,
 591942571,
 -1,
 -56497,
 592271356,
 42917,
 -56496,
 592323641,
 42897,
 -1,
 592388524,
 43835,
 592585558,
 592263836,
 -1,
 592651093,
 592533411,
 -1,
 -56492,
 592599155,
 43840,
 -1,
 592646626,
 43876,
 -1,
 592600314,
 43873,
 592913243,
 592524756,
 -1,
 592978778,
 592862019,
 -1,
 -56487,
 592917869,
 983619,
 -1,
 592973805,
 983620,
 -1,
 592905979,
 42901,
 593240926,
 592851729,
 -1,
 -56483,
 593180130,
 983199,
 -1,
 593233627,
 42913,
 593437537,
 593176599,
 -1,
 -56480,
 593384730,
 43836,
 -1,
 593430120,
 43828,
 593634147,
 593372775,
 43848,
 -1,
 593561028,
 43850,
 593765222,
 593563284,
 -1,
 -56475,
 593700966,
 983612,
 -1,
 593757189,
 43825,
 -56473,
 593725865,
 43866,
 -56472,
 593907426,
 43834,
 -56471,
 593970278,
 42915,
 -1,
 594030402,
 42905,
 594280447,
 586907001,
 -1,
 -56468,
 594179595,
 8348,
 -56467,
 594243011,
 8347,
 -56466,
 594304922,
 8346,
 -56465,
 594367350,
 8345,
 -56464,
 594431661,
 8344,
 -56463,
 594495012,
 8343,
 -56462,
 594560046,
 8342,
 -1,
 594621908,
 8341,
 594813845,
 586816479,
 -1,
 594879352,
 594772932,
 -1,
 -56458,
 594836948,
 42910,
 -56457,
 594892915,
 42908,
 -1,
 594939932,
 42906,
 595141500,
 594836359,
 -1,
 -56454,
 595097099,
 42929,
 -56453,
 595149870,
 42928,
 -1,
 595211732,
 42893,
 595403648,
 595094979,
 -1,
 -56450,
 595349343,
 42926,
 -56449,
 595403097,
 42924,
 -1,
 595461851,
 42920,
 595665795,
 595355001,
 -1,
 -56446,
 595603107,
 42923,
 -1,
 595658459,
 42918,
 595862406,
 595612587,
 -1,
 -56443,
 595810300,
 42916,
 -1,
 595862585,
 42896,
 596059017,
 595800849,
 -1,
 -56440,
 595998178,
 983198,
 -1,
 596051675,
 42912,
 596255628,
 595991363,
 -1,
 -56437,
 596195410,
 42931,
 -1,
 596247907,
 42898,
 596452239,
 596186802,
 -1,
 -56434,
 596389300,
 42932,
 -1,
 596444776,
 42902,
 -56432,
 596400562,
 42934,
 -56431,
 596592182,
 42925,
 -56430,
 596657254,
 42914,
 -56429,
 596722545,
 42930,
 -56428,
 596784598,
 42922,
 -1,
 596848450,
 42904,
 597042074,
 594758358,
 -1,
 597107609,
 596987729,
 -1,
 -56424,
 597064628,
 43002,
 -1,
 597124511,
 43846,
 -1,
 597049337,
 42895,
 -1,
 596978789,
 42999,
 597435300,
 586766292,
 -1,
 597500831,
 597378382,
 -1,
 -56418,
 597448628,
 3807,
 -1,
 597505321,
 3806,
 597697442,
 597438801,
 -1,
 -56415,
 597645777,
 983204,
 -1,
 597694090,
 983205,
 -56413,
 597650512,
 983206,
 -1,
 597839115,
 983207,
 598025132,
 597386617,
 -1,
 598090667,
 597963736,
 -1,
 598156201,
 598022587,
 -1,
 -56408,
 598090934,
 128311,
 -1,
 598154750,
 128309,
 -56406,
 598108118,
 128308,
 -1,
 598301746,
 128310,
 -1,
 598031054,
 8382,
 598549423,
 597980217,
 -1,
 -56402,
 598509238,
 127772,
 -1,
 598570460,
 127767,
 -56400,
 598485000,
 128030,
 -1,
 598677471,
 127991,
 598877181,
 586688535,
 -1,
 598942712,
 598815446,
 -1,
 599008231,
 598901903,
 -1,
 599073740,
 598963723,
 -1,
 599139274,
 599025916,
 -1,
 599204809,
 599066568,
 -1,
 599270343,
 599135404,
 11104,
 599392255,
 599195648,
 -1,
 599401413,
 599295648,
 -1,
 599466941,
 599346491,
 -1,
 -56388,
 599425036,
 11172,
 -1,
 599467811,
 11174,
 599663552,
 599401909,
 -1,
 -56385,
 599622320,
 983233,
 -1,
 599669110,
 11130,
 -56383,
 599622370,
 129072,
 -56382,
 599806981,
 129056,
 -56381,
 599871631,
 129060,
 -56380,
 599930826,
 129068,
 -1,
 599988735,
 129064,
 -56378,
 599357808,
 11120,
 -1,
 600137454,
 11136,
 -56376,
 599220211,
 11140,
 -1,
 600253362,
 11114,
 -1,
 599130286,
 129168,
 -56373,
 599099412,
 11244,
 -1,
 600464265,
 129186,
 600646612,
 599004357,
 -1,
 600712144,
 600601179,
 -1,
 -56369,
 600668808,
 129024,
 -1,
 600714392,
 129040,
 -56367,
 600659586,
 129176,
 -56366,
 600854698,
 129028,
 -56365,
 600917849,
 129032,
 -1,
 600976536,
 129044,
 601170904,
 600577714,
 -1,
 -56362,
 601120057,
 129184,
 -56361,
 601179788,
 11144,
 -1,
 601231257,
 129192,
 601433051,
 601124291,
 -1,
 -56358,
 601384158,
 129080,
 -1,
 601428791,
 129104,
 601629662,
 601384313,
 -1,
 -56355,
 601577522,
 128620,
 -1,
 601636029,
 129190,
 601826273,
 601569202,
 -1,
 -56352,
 601759673,
 129088,
 -1,
 601822380,
 129092,
 602022884,
 601763628,
 -1,
 -56349,
 601975955,
 129194,
 -1,
 602030015,
 129076,
 -56347,
 601982411,
 129172,
 -56346,
 602163626,
 129188,
 -1,
 602218425,
 129084,
 602416113,
 598933504,
 -1,
 602481643,
 602368311,
 -1,
 -56342,
 602438350,
 11108,
 -1,
 602500742,
 129112,
 -56340,
 602441906,
 128398,
 -56339,
 602634212,
 128492,
 -56338,
 602698639,
 128488,
 -56337,
 602754698,
 128709,
 -56336,
 602814134,
 128379,
 -1,
 602870500,
 128494,
 603127807,
 602343329,
 -1,
 603137013,
 603008867,
 -1,
 -56332,
 603074717,
 129307,
 -1,
 603133054,
 1422,
 -56330,
 603093383,
 8294,
 -56329,
 603284157,
 128269,
 -1,
 603338479,
 9958,
 -56327,
 598901287,
 127898,
 -56326,
 603478943,
 128006,
 -56325,
 603542211,
 127819,
 -56324,
 603595889,
 128210,
 -1,
 603656302,
 127811,
 603857939,
 598824894,
 -1,
 603923465,
 603817001,
 -1,
 603989000,
 603860145,
 -1,
 604054535,
 603932878,
 -1,
 604120068,
 604004250,
 -1,
 -56317,
 604056449,
 128393,
 -1,
 604115211,
 128396,
 -56315,
 604058061,
 128395,
 -56314,
 604250383,
 128397,
 -1,
 604313393,
 128394,
 -1,
 604006894,
 128318,
 -1,
 603914484,
 128261,
 604644366,
 603856533,
 128274,
 604709901,
 604585897,
 -1,
 -56308,
 604670833,
 983079,
 -1,
 604723750,
 983076,
 -1,
 604636854,
 128271,
 604972049,
 604602865,
 -1,
 -56304,
 604916372,
 128140,
 -1,
 604977556,
 127977,
 -56302,
 604929475,
 128557,
 -1,
 605113556,
 127853,
 605299736,
 603809145,
 -1,
 -56299,
 605247422,
 983221,
 -56298,
 605310637,
 983216,
 -56297,
 605371036,
 983226,
 -1,
 605431831,
 983218,
 -56295,
 605260393,
 129317,
 -1,
 605564716,
 983065,
 605759071,
 557932442,
 -1,
 605824357,
 605687444,
 -1,
 605889749,
 605763405,
 -1,
 605955154,
 605821763,
 -1,
 606020663,
 605903614,
 -1,
 606086183,
 605967222,
 -1,
 606151715,
 606041611,
 -1,
 -56286,
 606105261,
 92957,
 -1,
 606156613,
 92971,
 -56284,
 606095311,
 92960,
 -56283,
 606291193,
 92962,
 -56282,
 606346574,
 92968,
 -1,
 606410279,
 92972,
 606610475,
 606025172,
 -1,
 -56279,
 606557208,
 92969,
 -56278,
 606619599,
 92965,
 -1,
 606672423,
 92959,
 606872622,
 606542659,
 -1,
 -56275,
 606811973,
 92967,
 -1,
 606869031,
 92975,
 -56273,
 606833127,
 92964,
 -56272,
 607029512,
 92974,
 -56271,
 607093223,
 92956,
 -56270,
 607151847,
 92961,
 -56269,
 607216810,
 92963,
 -56268,
 607281719,
 92970,
 -56267,
 607342569,
 92966,
 -56266,
 607406031,
 92958,
 -1,
 607458855,
 92973,
 607715327,
 605964030,
 -1,
 607724606,
 607614475,
 -1,
 607790141,
 607677891,
 -1,
 -56261,
 607749401,
 93069,
 -56260,
 607795169,
 93053,
 -1,
 607850231,
 93062,
 -1,
 607729967,
 93061,
 608117826,
 607667246,
 -1,
 -56256,
 608077705,
 93070,
 -56255,
 608131890,
 93058,
 -1,
 608187891,
 93064,
 608379973,
 608078196,
 -1,
 -56252,
 608315813,
 93054,
 -1,
 608375104,
 93068,
 608576584,
 608338358,
 -1,
 -56249,
 608536451,
 93071,
 -1,
 608571712,
 93066,
 608773195,
 608519716,
 -1,
 -56246,
 608715160,
 93055,
 -1,
 608769601,
 93056,
 608969806,
 608712162,
 -1,
 -56243,
 608929667,
 93059,
 -1,
 608980653,
 93065,
 -56241,
 608930158,
 93057,
 -56240,
 609116564,
 93063,
 -56239,
 609178427,
 93060,
 -1,
 609234810,
 93067,
 609428613,
 605909383,
 -1,
 609494110,
 609361395,
 -1,
 609559640,
 609449483,
 -1,
 609625175,
 609519978,
 93044,
 -1,
 609550688,
 93045,
 -1,
 609579870,
 92997,
 609821787,
 609491779,
 -1,
 -56230,
 609778944,
 93043,
 -1,
 609826814,
 92985,
 -56228,
 609772505,
 93046,
 -56227,
 609965750,
 93047,
 -1,
 610022945,
 93042,
 610215016,
 609454290,
 -1,
 610280550,
 610175348,
 -1,
 610346085,
 610216370,
 -1,
 -56222,
 610302500,
 92990,
 -56221,
 610363637,
 92989,
 -56220,
 610424649,
 92988,
 -1,
 610479989,
 92991,
 -1,
 610294578,
 93028,
 -56217,
 610220835,
 93034,
 -1,
 610670153,
 92996,
 610870386,
 610173905,
 -1,
 610935918,
 610825739,
 -1,
 611001453,
 610874836,
 -1,
 -56212,
 610949483,
 92983,
 -1,
 611007267,
 92986,
 -1,
 610955298,
 92984,
 -56209,
 610889487,
 92992,
 -56208,
 611210943,
 92994,
 -56207,
 611274374,
 93027,
 -1,
 611332035,
 92987,
 611525750,
 610825739,
 -1,
 -56204,
 611485982,
 93037,
 -56203,
 611530984,
 93030,
 -1,
 611587623,
 93039,
 611787899,
 611471021,
 -1,
 611853434,
 611723689,
 -1,
 -56199,
 611810123,
 93038,
 -1,
 611874158,
 92993,
 -1,
 611811608,
 93041,
 612115582,
 611734390,
 -1,
 -56195,
 612072310,
 93035,
 -1,
 612132019,
 93033,
 612312193,
 612054484,
 -1,
 -56192,
 612259663,
 93032,
 -1,
 612322163,
 93029,
 -56190,
 612273058,
 93031,
 -56189,
 612453743,
 93040,
 -56188,
 612514690,
 92995,
 -1,
 612570712,
 93036,
 612770992,
 609387485,
 -1,
 612836501,
 612699796,
 -1,
 612902026,
 612795433,
 -1,
 -56183,
 612860342,
 92943,
 -1,
 612898482,
 92942,
 613098637,
 612858959,
 -1,
 -56180,
 613056950,
 92933,
 -1,
 613095090,
 92932,
 613295248,
 613038748,
 -1,
 -56177,
 613253558,
 92939,
 -1,
 613291698,
 92938,
 613491859,
 613224084,
 -1,
 -56174,
 613450166,
 92955,
 -1,
 613488306,
 92954,
 -56172,
 613450166,
 92951,
 -1,
 613619378,
 92950,
 613819547,
 612793423,
 -1,
 613885081,
 613748372,
 -1,
 -56168,
 613843382,
 92945,
 -1,
 613881522,
 92944,
 -56166,
 613843382,
 92935,
 -1,
 614012594,
 92934,
 614212769,
 613767102,
 -1,
 614278303,
 614160318,
 -1,
 -56162,
 614236598,
 92941,
 -1,
 614274738,
 92940,
 -56160,
 614236598,
 92947,
 -1,
 614405810,
 92946,
 614605991,
 614152860,
 -1,
 614671525,
 614534804,
 -1,
 -56156,
 614629814,
 92949,
 -1,
 614667954,
 92948,
 -56154,
 614629814,
 92931,
 -1,
 614799026,
 92930,
 614999213,
 614541335,
 -1,
 615064747,
 614934551,
 -1,
 -56150,
 615023030,
 92929,
 -1,
 615061170,
 92928,
 -56148,
 615023030,
 92937,
 -1,
 615192242,
 92936,
 615448575,
 614958121,
 -1,
 -56145,
 615350710,
 92953,
 -1,
 615388850,
 92952,
 615589054,
 612705498,
 -1,
 615654580,
 615544331,
 -1,
 -56141,
 615614420,
 93010,
 -1,
 615659952,
 93011,
 615851191,
 615607747,
 -1,
 -56138,
 615793412,
 93014,
 -1,
 615853663,
 93015,
 616047802,
 615788332,
 -1,
 -56135,
 615996891,
 93012,
 -1,
 616055398,
 93013,
 -56133,
 616008561,
 93008,
 -56132,
 616192550,
 93009,
 -56131,
 616256873,
 93017,
 -1,
 616311399,
 93016,
 616506570,
 615536473,
 -1,
 616572102,
 616461835,
 -1,
 616637637,
 616508231,
 -1,
 616703172,
 616562688,
 -1,
 -56125,
 616658940,
 93021,
 -1,
 616700082,
 93024,
 -1,
 616656323,
 93019,
 -1,
 616590076,
 93025,
 617030857,
 616512079,
 -1,
 -56120,
 616984003,
 93020,
 -1,
 617022117,
 93023,
 -1,
 616976950,
 93022,
 617349119,
 616452018,
 -1,
 617358542,
 617248267,
 -1,
 -56115,
 617315595,
 92976,
 -1,
 617354821,
 92982,
 617555153,
 617311683,
 -1,
 -56112,
 617512188,
 92980,
 -1,
 617568190,
 92977,
 617751764,
 617497646,
 -1,
 -56109,
 617690953,
 92979,
 -1,
 617753957,
 92978,
 -1,
 617691443,
 92981,
 618013982,
 605846612,
 -1,
 618079497,
 617956900,
 -1,
 618145028,
 618016204,
 -1,
 618210532,
 618082092,
 -1,
 618276067,
 618151425,
 -1,
 618341596,
 618222454,
 72416,
 -1,
 618279697,
 72419,
 -56099,
 618301812,
 72420,
 -56098,
 618431529,
 72418,
 -56097,
 618493451,
 72414,
 -56096,
 618553242,
 72412,
 -56095,
 618614445,
 72415,
 -56094,
 618677796,
 72417,
 -1,
 618742830,
 72413,
 -1,
 618204820,
 72403,
 618996966,
 618167375,
 72409,
 -1,
 618925716,
 72410,
 619128041,
 618952203,
 -1,
 -56088,
 619066850,
 72399,
 -1,
 619122324,
 72398,
 619324652,
 619077530,
 -1,
 -56085,
 619263458,
 72401,
 -1,
 619318932,
 72384,
 619521263,
 619271030,
 -1,
 -56082,
 619459383,
 72391,
 -1,
 619515540,
 72400,
 619717874,
 619463726,
 -1,
 -56079,
 619656674,
 72394,
 -1,
 619712148,
 72385,
 619914484,
 619657884,
 72407,
 -1,
 619843220,
 72411,
 620045559,
 619846467,
 -1,
 -56074,
 619984354,
 72404,
 -1,
 620039828,
 72397,
 -56072,
 620006127,
 72389,
 -56071,
 620200392,
 72390,
 -56070,
 620260904,
 72395,
 -56069,
 620324301,
 72402,
 -56068,
 620386238,
 72408,
 -56067,
 620449526,
 72387,
 -56066,
 620512878,
 72386,
 -56065,
 620574178,
 72392,
 -56064,
 620639031,
 72393,
 -56063,
 620701719,
 72406,
 -56062,
 620765979,
 72388,
 -56061,
 620828355,
 72396,
 -1,
 620891796,
 72405,
 621150207,
 618094388,
 72436,
 621215743,
 621019136,
 -1,
 621225224,
 621104427,
 72435,
 -1,
 621150694,
 72438,
 -1,
 621162545,
 72439,
 621421841,
 618032766,
 -1,
 621487375,
 621377948,
 72428,
 621608959,
 621412352,
 -1,
 621618446,
 621497643,
 72427,
 -1,
 621543910,
 72429,
 -1,
 621555761,
 72430,
 621871103,
 621425929,
 72423,
 -1,
 621740518,
 72426,
 621946134,
 621374385,
 72422,
 622067711,
 621871104,
 -1,
 622077205,
 621956395,
 72421,
 -1,
 622002662,
 72424,
 -1,
 622014513,
 72425,
 622273818,
 621891963,
 72431,
 622395391,
 622198784,
 -1,
 -56039,
 622284080,
 72433,
 -1,
 622342193,
 72434,
 622591999,
 622212361,
 72437,
 622657535,
 622460928,
 -1,
 -56035,
 622559711,
 72432,
 -1,
 622604337,
 72440,
 622798155,
 617958664,
 -1,
 622863690,
 622758618,
 -1,
 622929214,
 622807103,
 -1,
 622994749,
 622885720,
 -1,
 623060263,
 622947779,
 -1,
 623125798,
 622988948,
 -1,
 -56027,
 623071476,
 67695,
 -1,
 623125635,
 67698,
 -1,
 623065273,
 67701,
 623387946,
 623015435,
 -1,
 -56023,
 623324616,
 67688,
 -1,
 623384193,
 67702,
 623584556,
 623327074,
 67684,
 -1,
 623540092,
 67687,
 623715631,
 623513236,
 -1,
 -56018,
 623675980,
 67696,
 -1,
 623725199,
 67680,
 -56016,
 623676257,
 67686,
 -56015,
 623872725,
 67689,
 -56014,
 623936751,
 67685,
 -56013,
 623995033,
 67700,
 -56012,
 624059575,
 67699,
 -56011,
 624124136,
 67697,
 -56010,
 624187282,
 67694,
 -56009,
 624251135,
 67692,
 -56008,
 624314095,
 67691,
 -56007,
 624379053,
 67690,
 -56006,
 624440524,
 67682,
 -56005,
 624504909,
 67693,
 -56004,
 624567144,
 67683,
 -1,
 624629786,
 67681,
 -1,
 622932715,
 67703,
 624895305,
 622876505,
 -1,
 624960837,
 624850443,
 -1,
 625026371,
 624919593,
 -1,
 -55998,
 624973758,
 67706,
 -1,
 625028151,
 67711,
 -55996,
 624966064,
 67707,
 -1,
 625158983,
 67710,
 625354056,
 624897836,
 -1,
 -55993,
 625303003,
 67708,
 -1,
 625361510,
 67709,
 -1,
 625302054,
 67705,
 -1,
 624847435,
 67704,
 -1,
 622789961,
 127796,
 625747283,
 622736341,
 128463,
 625812817,
 625672192,
 -1,
 625878352,
 625772198,
 -1,
 -55985,
 625836211,
 128195,
 -1,
 625885514,
 128479,
 -1,
 625815403,
 128196,
 -55982,
 625765827,
 128464,
 -1,
 626091385,
 128223,
 626271578,
 625700205,
 -1,
 626337113,
 626211649,
 -1,
 -55978,
 626294532,
 983149,
 -55977,
 626340262,
 983145,
 -55976,
 626402974,
 983146,
 -1,
 626464519,
 983148,
 -1,
 626297237,
 127881,
 626730333,
 626226170,
 -1,
 -55972,
 626680584,
 128706,
 -1,
 626731957,
 128755,
 626926944,
 626676598,
 -1,
 -55969,
 626860830,
 128060,
 -1,
 626924416,
 129374,
 627123554,
 626860688,
 983121,
 -1,
 627057898,
 983120,
 -55965,
 627082283,
 128062,
 -55964,
 627204480,
 128206,
 -1,
 627252918,
 128230,
 627451346,
 605767204,
 -1,
 627516880,
 627379860,
 -1,
 627582415,
 627477072,
 -1,
 627647886,
 627537419,
 -1,
 627713407,
 627600818,
 -1,
 627778933,
 627640537,
 127201,
 -55956,
 627707401,
 127219,
 -55955,
 627772810,
 127218,
 -55954,
 627838180,
 127217,
 -55953,
 627903564,
 127216,
 -55952,
 627968930,
 127215,
 -55951,
 628034310,
 127214,
 -55950,
 628099661,
 127213,
 -55949,
 628164981,
 127212,
 -55948,
 628230361,
 127211,
 -1,
 628295753,
 127210,
 628499832,
 627706229,
 127202,
 -55945,
 628426969,
 127221,
 -1,
 628492361,
 127220,
 -55943,
 628428297,
 127209,
 -55942,
 628624778,
 127208,
 -55941,
 628690148,
 127207,
 -55940,
 628755532,
 127206,
 -55939,
 628820898,
 127205,
 -55938,
 628886278,
 127204,
 -1,
 628951629,
 127203,
 629155204,
 627673067,
 -1,
 -55935,
 629109629,
 127138,
 -55934,
 629159851,
 127154,
 -55933,
 629220542,
 127170,
 -1,
 629284652,
 127186,
 629482889,
 629094868,
 -1,
 -55930,
 629437309,
 127139,
 -55929,
 629487531,
 127155,
 -55928,
 629548222,
 127171,
 -1,
 629612332,
 127187,
 629866495,
 629418839,
 -1,
 -55925,
 629764989,
 127146,
 -55924,
 629815211,
 127162,
 -55923,
 629875902,
 127178,
 -1,
 629940012,
 127194,
 630138267,
 627584812,
 -1,
 630203798,
 630085566,
 -1,
 630269333,
 630161529,
 -1,
 -55918,
 630223741,
 127140,
 -55917,
 630273963,
 127156,
 -55916,
 630334654,
 127172,
 -1,
 630398764,
 127188,
 -1,
 630217008,
 127200,
 630718463,
 630145690,
 -1,
 -55912,
 630616957,
 127141,
 -55911,
 630667179,
 127157,
 -55910,
 630727870,
 127173,
 -1,
 630791980,
 127189,
 630990246,
 630091203,
 -1,
 631055777,
 630932235,
 -1,
 -55906,
 631010173,
 127142,
 -55905,
 631060395,
 127158,
 -55904,
 631121086,
 127174,
 -1,
 631185196,
 127190,
 631439359,
 630992484,
 -1,
 -55901,
 631337853,
 127143,
 -55900,
 631388075,
 127159,
 -55899,
 631448766,
 127175,
 -1,
 631512876,
 127191,
 631711153,
 630932526,
 -1,
 631776684,
 631657811,
 -1,
 -55895,
 631731069,
 127148,
 -55894,
 631781291,
 127164,
 -55893,
 631841982,
 127180,
 -1,
 631906092,
 127196,
 632160255,
 631717706,
 -1,
 -55890,
 632058749,
 127150,
 -55889,
 632108971,
 127166,
 -55888,
 632169662,
 127182,
 -1,
 632233772,
 127198,
 632432054,
 631661874,
 -1,
 -55885,
 632386429,
 127149,
 -55884,
 632436651,
 127165,
 -55883,
 632497342,
 127181,
 -1,
 632561452,
 127197,
 632759739,
 632378734,
 -1,
 -55880,
 632714109,
 127145,
 -55879,
 632764331,
 127161,
 -55878,
 632825022,
 127177,
 -1,
 632889132,
 127193,
 633087424,
 632701832,
 -1,
 -55875,
 633041789,
 127147,
 -55874,
 633092011,
 127163,
 -55873,
 633152702,
 127179,
 -1,
 633216812,
 127195,
 633415109,
 633023100,
 -1,
 -55870,
 633369469,
 127144,
 -55869,
 633419691,
 127160,
 -55868,
 633480382,
 127176,
 -1,
 633544492,
 127192,
 633742794,
 633343880,
 -1,
 -55865,
 633697149,
 127137,
 -55864,
 633747371,
 127153,
 -55863,
 633808062,
 127169,
 -1,
 633872172,
 127185,
 634070477,
 633673394,
 -1,
 -55860,
 634013349,
 127183,
 -1,
 634064784,
 127136,
 -55858,
 634029588,
 127199,
 -1,
 634218465,
 127167,
 -1,
 627514542,
 128720,
 -55855,
 627473487,
 983150,
 -1,
 634397328,
 983147,
 634594807,
 627404383,
 -1,
 634660328,
 634538651,
 -1,
 634725849,
 634613187,
 -1,
 634791384,
 634654356,
 -1,
 -55849,
 634736884,
 68493,
 -1,
 634791043,
 68495,
 -1,
 634730681,
 68496,
 635053531,
 634664802,
 68484,
 -1,
 635008892,
 68487,
 -55844,
 635013985,
 68486,
 -55843,
 635144917,
 68488,
 -55842,
 635208967,
 68485,
 -55841,
 635270908,
 68497,
 -55840,
 635330792,
 68494,
 -55839,
 635393938,
 68492,
 -55838,
 635457795,
 68491,
 -55837,
 635520751,
 68490,
 -55836,
 635585709,
 68489,
 -55835,
 635647180,
 68482,
 -55834,
 635708264,
 68483,
 -55833,
 635770906,
 68481,
 -1,
 635834779,
 68480,
 636036594,
 634607449,
 -1,
 636102127,
 635991563,
 -1,
 636167661,
 636060713,
 -1,
 -55828,
 636114878,
 68522,
 -1,
 636169271,
 68526,
 -55826,
 636107184,
 68523,
 -1,
 636300103,
 68525,
 636495345,
 636049958,
 68521,
 -1,
 636420636,
 68527,
 -1,
 636432858,
 68524,
 636691957,
 635974132,
 -1,
 -55820,
 636626310,
 68508,
 -1,
 636690812,
 68507,
 -55818,
 636648381,
 68506,
 -1,
 636841712,
 68505,
 637019671,
 634542014,
 -1,
 637085183,
 636978546,
 -1,
 637150716,
 637038019,
 -1,
 -55813,
 637110920,
 9211,
 -1,
 637159603,
 9214,
 637403135,
 637098449,
 -1,
 -55810,
 637274126,
 9212,
 -1,
 637338765,
 9213,
 637543941,
 637041743,
 -1,
 637609475,
 637499680,
 -1,
 -55806,
 637546323,
 128545,
 -1,
 637606979,
 128574,
 -55804,
 637554297,
 127831,
 -1,
 637738250,
 128093,
 637937162,
 637498891,
 -1,
 638002697,
 637865620,
 -1,
 -55800,
 637958509,
 129364,
 -1,
 637999462,
 128688,
 -1,
 637928204,
 127858,
 638264846,
 637881206,
 -1,
 638330381,
 638196783,
 128659,
 -1,
 638283262,
 128680,
 -1,
 638277770,
 128110,
 638526993,
 638219303,
 -1,
 -55792,
 638458476,
 128238,
 -1,
 638521743,
 128239,
 638723604,
 638476186,
 -1,
 -55789,
 638656714,
 127871,
 -1,
 638714245,
 8297,
 -55787,
 638676343,
 128254,
 -55786,
 638867566,
 128041,
 -1,
 638918353,
 128425,
 639116849,
 636954647,
 -1,
 639182375,
 639067513,
 -1,
 639247910,
 639135171,
 -1,
 639313445,
 639195601,
 -1,
 639378980,
 639238144,
 -1,
 639444512,
 639338144,
 -1,
 -55778,
 639394633,
 128590,
 -55777,
 639447382,
 128591,
 -1,
 639506846,
 128113,
 -55775,
 639395433,
 128588,
 -55774,
 639644351,
 128589,
 -55773,
 639706468,
 129336,
 -1,
 639769182,
 128583,
 -1,
 639308163,
 128187,
 -1,
 639250070,
 128547,
 -1,
 639185298,
 127917,
 640165420,
 639128438,
 -1,
 -55767,
 640120479,
 9956,
 -55766,
 640184853,
 128532,
 -55765,
 640234910,
 128039,
 -1,
 640287606,
 128390,
 640493104,
 640093844,
 -1,
 -55762,
 640443769,
 127824,
 -55761,
 640505758,
 129372,
 -1,
 640556298,
 127825,
 -1,
 640427112,
 128694,
 640820806,
 639067513,
 -1,
 640886337,
 640760476,
 -1,
 640951868,
 640844232,
 -1,
 641017403,
 640907030,
 -1,
 641082936,
 640944033,
 -1,
 -55753,
 641010037,
 983166,
 -1,
 641075417,
 983163,
 641335295,
 641007616,
 -1,
 -55750,
 641235963,
 983165,
 -1,
 641292838,
 983162,
 -1,
 640950912,
 983192,
 641597439,
 640897910,
 -1,
 641607231,
 641496930,
 128424,
 -1,
 641532453,
 128438,
 641794047,
 641539227,
 129332,
 -1,
 641692666,
 128120,
 641869380,
 640821271,
 -1,
 -55741,
 641822509,
 983236,
 -1,
 641873181,
 129328,
 -55739,
 641816744,
 128711,
 -1,
 641996442,
 128255,
 642197074,
 640760476,
 -1,
 642262603,
 642134801,
 128022,
 642383871,
 642187264,
 -1,
 -55734,
 642274941,
 128061,
 -1,
 642330451,
 128055,
 642524750,
 642208875,
 -1,
 -55731,
 642454469,
 127821,
 -1,
 642515321,
 127885,
 642721361,
 642467364,
 -1,
 -55728,
 642663972,
 128138,
 -1,
 642721877,
 128169,
 -1,
 642675893,
 128299,
 642983515,
 642153551,
 -1,
 643049046,
 642934137,
 -1,
 -55723,
 643002073,
 128091,
 -1,
 643064336,
 128156,
 -55721,
 643003939,
 128686,
 -55720,
 643199255,
 128204,
 -55719,
 643242359,
 128226,
 -55718,
 643303797,
 983167,
 -1,
 643369177,
 983164,
 643573342,
 642917008,
 -1,
 -55715,
 643512988,
 983229,
 -1,
 643575596,
 983220,
 -1,
 643518125,
 983193,
 643835848,
 605706174,
 -1,
 643901243,
 643778540,
 -1,
 643966776,
 643825664,
 -1,
 644032216,
 643906154,
 -1,
 644097689,
 643986031,
 -1,
 644163203,
 644032535,
 68809,
 644228714,
 644109174,
 68825,
 644294248,
 644183563,
 68839,
 -1,
 644220965,
 68849,
 -55703,
 644254068,
 68826,
 -1,
 644356931,
 68805,
 644556397,
 644160323,
 68804,
 -55700,
 644509123,
 68806,
 -1,
 644560340,
 68841,
 644753007,
 644516589,
 68847,
 -1,
 644705731,
 68848,
 644884081,
 644707851,
 68838,
 -1,
 644843892,
 68840,
 645015155,
 644836803,
 68836,
 -1,
 644975341,
 68837,
 645146229,
 644959917,
 68824,
 -1,
 645095322,
 68833,
 645277303,
 645088804,
 68822,
 -1,
 645237108,
 68823,
 645408377,
 645214993,
 68813,
 -1,
 645368180,
 68814,
 -55686,
 645366198,
 68846,
 -55685,
 645490041,
 68834,
 -55684,
 645554074,
 68832,
 -55683,
 645612590,
 68819,
 -55682,
 645677935,
 68818,
 -55681,
 645739988,
 68815,
 -55680,
 645803820,
 68812,
 -55679,
 645867543,
 68811,
 -55678,
 645931664,
 68807,
 -1,
 645994162,
 68802,
 646194824,
 644091540,
 68800,
 -55675,
 646140975,
 68808,
 -55674,
 646205421,
 68803,
 -55673,
 646267950,
 68820,
 -1,
 646319764,
 68801,
 646522508,
 646151247,
 68842,
 -55670,
 646478927,
 68843,
 -55669,
 646540739,
 68850,
 -1,
 646600147,
 68821,
 646784655,
 646469566,
 68827,
 -55666,
 646731710,
 68828,
 -1,
 646785433,
 68831,
 646981266,
 646737307,
 -1,
 -55663,
 646938068,
 68845,
 -1,
 646994035,
 68830,
 647177877,
 646927709,
 -1,
 -55660,
 647134676,
 68844,
 -1,
 647190643,
 68829,
 647374487,
 647117468,
 68816,
 -1,
 647314076,
 68817,
 -55656,
 647327998,
 68835,
 -1,
 647438082,
 68810,
 647636687,
 644029407,
 -1,
 647702201,
 647571479,
 68745,
 647767712,
 647648118,
 68761,
 647833246,
 647722507,
 68775,
 -1,
 647759909,
 68785,
 -55649,
 647793012,
 68762,
 -1,
 647895875,
 68741,
 648095395,
 647699267,
 68740,
 -55646,
 648048067,
 68742,
 -1,
 648099284,
 68777,
 648292005,
 648055533,
 68783,
 -1,
 648244675,
 68784,
 648423079,
 648246795,
 68774,
 -1,
 648382836,
 68776,
 648554153,
 648375747,
 68772,
 -1,
 648514285,
 68773,
 648685227,
 648498861,
 68760,
 -1,
 648634266,
 68769,
 648816301,
 648627748,
 68758,
 -1,
 648776052,
 68759,
 648947375,
 648753937,
 68749,
 -1,
 648907124,
 68750,
 -55632,
 648905142,
 68782,
 -55631,
 649028985,
 68770,
 -55630,
 649093018,
 68768,
 -55629,
 649151534,
 68755,
 -55628,
 649216879,
 68754,
 -55627,
 649278932,
 68751,
 -55626,
 649342764,
 68748,
 -55625,
 649406487,
 68747,
 -55624,
 649470608,
 68743,
 -1,
 649533106,
 68738,
 649733822,
 647630484,
 68736,
 -55621,
 649679919,
 68744,
 -55620,
 649744365,
 68739,
 -55619,
 649806894,
 68756,
 -1,
 649858708,
 68737,
 650061506,
 649690191,
 68778,
 -55616,
 650017871,
 68779,
 -55615,
 650079683,
 68786,
 -1,
 650139091,
 68757,
 650323653,
 650008510,
 68763,
 -55612,
 650270654,
 68764,
 -1,
 650324377,
 68767,
 650520264,
 650276251,
 -1,
 -55609,
 650477012,
 68781,
 -1,
 650532979,
 68766,
 650716875,
 650466653,
 -1,
 -55606,
 650673620,
 68780,
 -1,
 650729587,
 68765,
 650913485,
 650656412,
 68752,
 -1,
 650853020,
 68753,
 -55602,
 650866942,
 68771,
 -1,
 650977026,
 68746,
 651231231,
 647583577,
 -1,
 651241172,
 651123238,
 68858,
 651362303,
 651165696,
 -1,
 -55597,
 651261939,
 68863,
 -1,
 651311695,
 68862,
 651503319,
 651178007,
 -1,
 -55594,
 651461102,
 68859,
 -1,
 651506431,
 68861,
 -1,
 651458387,
 68860,
 651765513,
 643981660,
 -1,
 651831048,
 651710817,
 -1,
 651896546,
 651790708,
 -1,
 651962078,
 651832494,
 66415,
 -55587,
 651918415,
 66408,
 -1,
 651967132,
 66416,
 652158688,
 651890324,
 66420,
 -1,
 652113419,
 66417,
 -55583,
 652115023,
 66419,
 -1,
 652242360,
 66407,
 652420839,
 651849155,
 -1,
 652486374,
 652359124,
 -1,
 -55579,
 652434229,
 66405,
 -1,
 652484052,
 66406,
 -1,
 652426567,
 66401,
 652748522,
 652360348,
 66393,
 -55575,
 652683287,
 66418,
 -1,
 652742292,
 66421,
 652945135,
 652681872,
 -1,
 653010670,
 652905197,
 -1,
 -55571,
 652952090,
 66392,
 -1,
 653015339,
 66390,
 -1,
 652957890,
 66387,
 653272818,
 652905197,
 -1,
 -55567,
 653211947,
 66389,
 -1,
 653268367,
 66391,
 653469429,
 653230518,
 -1,
 -55564,
 653417269,
 66398,
 -1,
 653470894,
 66414,
 653666040,
 653424139,
 -1,
 -55561,
 653619729,
 66413,
 -1,
 653660415,
 66402,
 653862650,
 653612990,
 66409,
 -1,
 653809598,
 66410,
 653993724,
 653797399,
 66388,
 -1,
 653930284,
 66411,
 -55555,
 653950031,
 66403,
 -55554,
 654075999,
 66400,
 -55553,
 654139647,
 66399,
 -55552,
 654202058,
 66397,
 -55551,
 654266671,
 66396,
 -55550,
 654330499,
 66395,
 -55549,
 654394792,
 66394,
 -55548,
 654456290,
 66412,
 -55547,
 654521201,
 66386,
 -55546,
 654581152,
 66404,
 -55545,
 654646002,
 66385,
 -1,
 654709352,
 66384,
 -1,
 651785032,
 128435,
 654976822,
 651712110,
 -1,
 655042353,
 654920347,
 -1,
 655107857,
 654997003,
 -1,
 655173391,
 655046100,
 -1,
 -55538,
 655108672,
 68251,
 -1,
 655167872,
 68249,
 -55536,
 655108672,
 68233,
 -1,
 655298783,
 68247,
 655501077,
 655043944,
 -1,
 -55533,
 655428173,
 68239,
 -55532,
 655493493,
 68230,
 -1,
 655558873,
 68234,
 655763224,
 655461103,
 -1,
 -55529,
 655703508,
 68248,
 -1,
 655766996,
 68252,
 655959835,
 655705134,
 -1,
 -55526,
 655898109,
 68237,
 -1,
 655954027,
 68235,
 656156446,
 655898068,
 -1,
 -55523,
 656091712,
 68224,
 -1,
 656150751,
 68226,
 656353057,
 656093969,
 -1,
 -55520,
 656291356,
 68246,
 -1,
 656353710,
 68244,
 656549668,
 656286491,
 -1,
 -55517,
 656492068,
 68245,
 -1,
 656548496,
 68243,
 656746279,
 656477844,
 -1,
 -55514,
 656689349,
 68241,
 -1,
 656752084,
 68242,
 -55512,
 656706043,
 68250,
 -55511,
 656901359,
 68229,
 -55510,
 656961079,
 68238,
 -55509,
 657025115,
 68231,
 -55508,
 657089680,
 68228,
 -55507,
 657151554,
 68236,
 -55506,
 657215684,
 68227,
 -55505,
 657278694,
 68225,
 -55504,
 657338312,
 68240,
 -1,
 657397700,
 68232,
 657653759,
 654989145,
 -1,
 657663797,
 657552907,
 -1,
 -55500,
 657622376,
 68255,
 -1,
 657664839,
 68254,
 -1,
 657611302,
 68253,
 -55497,
 654918972,
 128477,
 -1,
 657867303,
 66335,
 658112511,
 643902641,
 -1,
 -55494,
 658016317,
 128117,
 -1,
 658067345,
 128116,
 658253720,
 643853763,
 -1,
 658319255,
 658182332,
 -1,
 658384746,
 658272879,
 -1,
 658450247,
 658319383,
 66783,
 658515782,
 658388436,
 -1,
 658581315,
 658470411,
 -1,
 -55486,
 658533928,
 66803,
 -1,
 658574996,
 66801,
 -55484,
 658530260,
 66797,
 -55483,
 658719877,
 66789,
 -1,
 658775349,
 66782,
 -1,
 658456020,
 66784,
 659040075,
 658378388,
 66776,
 659105610,
 658979484,
 66777,
 -1,
 659051382,
 66778,
 -1,
 659043796,
 66779,
 659302224,
 658994699,
 -1,
 659367759,
 659254723,
 -1,
 -55474,
 659305954,
 66804,
 -1,
 659361428,
 66802,
 -1,
 659295892,
 66800,
 659629908,
 659244078,
 -1,
 -55470,
 659589568,
 66790,
 -55469,
 659633634,
 66808,
 -1,
 659689108,
 66788,
 659892055,
 659589869,
 -1,
 -55466,
 659830242,
 66811,
 -1,
 659885716,
 66810,
 660088666,
 659844547,
 -1,
 -55463,
 660026850,
 66799,
 -1,
 660082324,
 66798,
 660285276,
 660035518,
 66794,
 -1,
 660225492,
 66795,
 660416351,
 660223444,
 -1,
 -55458,
 660376000,
 66786,
 -1,
 660410004,
 66785,
 -55456,
 660374593,
 66807,
 -55455,
 660569167,
 66806,
 -55454,
 660627412,
 66796,
 -55453,
 660689890,
 66793,
 -55452,
 660754166,
 66792,
 -55451,
 660817518,
 66791,
 -55450,
 660880028,
 66787,
 -55449,
 660943955,
 66809,
 -55448,
 661005433,
 66805,
 -55447,
 661069109,
 66781,
 -1,
 661133948,
 66780,
 661389311,
 658316255,
 -1,
 661399412,
 661268503,
 66743,
 661464947,
 661337556,
 -1,
 661530480,
 661419531,
 -1,
 -55441,
 661483048,
 66763,
 -1,
 661524116,
 66761,
 -55439,
 661479380,
 66757,
 -55438,
 661668997,
 66749,
 -1,
 661724469,
 66742,
 -1,
 661405140,
 66744,
 661989240,
 661327508,
 66736,
 662054775,
 661928604,
 66737,
 -1,
 662000502,
 66738,
 -1,
 661992916,
 66739,
 662251389,
 661943819,
 -1,
 662316924,
 662203843,
 -1,
 -55429,
 662255074,
 66764,
 -1,
 662310548,
 66762,
 -1,
 662245012,
 66760,
 662579073,
 662193198,
 -1,
 -55425,
 662538688,
 66750,
 -55424,
 662582754,
 66768,
 -1,
 662638228,
 66748,
 662841220,
 662538989,
 -1,
 -55421,
 662779362,
 66771,
 -1,
 662834836,
 66770,
 663037831,
 662793667,
 -1,
 -55418,
 662975970,
 66759,
 -1,
 663031444,
 66758,
 663234441,
 662984638,
 66754,
 -1,
 663174612,
 66755,
 663365516,
 663172564,
 -1,
 -55413,
 663325120,
 66746,
 -1,
 663359124,
 66745,
 -55411,
 663323713,
 66767,
 -55410,
 663518287,
 66766,
 -55409,
 663576532,
 66756,
 -55408,
 663639010,
 66753,
 -55407,
 663703286,
 66752,
 -55406,
 663766638,
 66751,
 -55405,
 663829148,
 66747,
 -55404,
 663893075,
 66769,
 -55403,
 663954553,
 66765,
 -55402,
 664018229,
 66741,
 -1,
 664083068,
 66740,
 -1,
 658250563,
 983191,
 664348584,
 658202522,
 -1,
 664414117,
 664283159,
 -1,
 664479652,
 664359800,
 -1,
 664545182,
 664424235,
 -1,
 -55395,
 664495645,
 128236,
 -1,
 664555055,
 128237,
 664741793,
 664481580,
 -1,
 -55392,
 664688956,
 128449,
 -1,
 664747389,
 128194,
 -55390,
 664685844,
 128275,
 -55389,
 664876811,
 128080,
 -1,
 664934947,
 128214,
 -1,
 664430269,
 983190,
 665200551,
 664369314,
 128191,
 -1,
 665125413,
 128440,
 -1,
 665139462,
 9934,
 665397171,
 664298873,
 -1,
 665462706,
 665338703,
 -1,
 665528239,
 665410090,
 -1,
 -55380,
 665481772,
 2933,
 -55379,
 665543915,
 2930,
 -55378,
 665597533,
 2931,
 -1,
 665660060,
 2934,
 665911295,
 665483285,
 -1,
 -55375,
 665809462,
 2935,
 -1,
 665871657,
 2932,
 -1,
 665391828,
 128217,
 666118076,
 665342838,
 -1,
 666183610,
 666050434,
 -1,
 -55370,
 666138368,
 128662,
 -55369,
 666198750,
 128660,
 -55368,
 666251399,
 128753,
 -55367,
 666311421,
 128653,
 -1,
 666375757,
 128664,
 -55365,
 666118172,
 128431,
 -1,
 666502686,
 128283,
 666707903,
 666051023,
 -1,
 -55362,
 666655730,
 128025,
 -1,
 666702035,
 128721,
 -55360,
 666667218,
 128002,
 -55359,
 666863494,
 129417,
 -55358,
 666927730,
 128471,
 -55357,
 666993001,
 128228,
 -55356,
 667045582,
 128329,
 -55355,
 667108425,
 128076,
 -55354,
 667172177,
 128738,
 -55353,
 667234312,
 127970,
 -1,
 667296764,
 127842,
 667494650,
 643793334,
 -1,
 667560138,
 667446723,
 -1,
 667625529,
 667486425,
 983237,
 667690966,
 667553289,
 983261,
 -55347,
 667618825,
 983441,
 -55346,
 667684234,
 983440,
 -55345,
 667749604,
 983439,
 -55344,
 667814988,
 983438,
 -55343,
 667880354,
 983437,
 -55342,
 667945734,
 983436,
 -55341,
 668011085,
 983435,
 -55340,
 668076405,
 983434,
 -55339,
 668141785,
 983433,
 -1,
 668207177,
 983432,
 668411873,
 667618698,
 983260,
 -55336,
 668339721,
 983431,
 -55335,
 668405130,
 983430,
 -55334,
 668470500,
 983429,
 -55333,
 668535884,
 983428,
 -55332,
 668601250,
 983427,
 -55331,
 668666630,
 983426,
 -55330,
 668731981,
 983425,
 -55329,
 668797301,
 983424,
 -55328,
 668862681,
 983423,
 -1,
 668928073,
 983422,
 669132780,
 668339428,
 983259,
 -55325,
 669060617,
 983421,
 -55324,
 669126026,
 983420,
 -55323,
 669191396,
 983419,
 -55322,
 669256780,
 983418,
 -55321,
 669322146,
 983417,
 -55320,
 669387526,
 983416,
 -55319,
 669452877,
 983415,
 -55318,
 669518197,
 983414,
 -55317,
 669583577,
 983413,
 -1,
 669648969,
 983412,
 669853687,
 669060172,
 983252,
 -55314,
 669781513,
 983411,
 -55313,
 669846922,
 983410,
 -55312,
 669912292,
 983409,
 -55311,
 669977676,
 983408,
 -55310,
 670043042,
 983407,
 -55309,
 670108422,
 983406,
 -55308,
 670173773,
 983405,
 -55307,
 670239093,
 983404,
 -55306,
 670304473,
 983403,
 -1,
 670369865,
 983402,
 670574594,
 669780898,
 983251,
 -55303,
 670502409,
 983401,
 -55302,
 670567818,
 983400,
 -55301,
 670633188,
 983399,
 -55300,
 670698572,
 983398,
 -55299,
 670763938,
 983397,
 -55298,
 670829318,
 983396,
 -55297,
 670894669,
 983395,
 -55296,
 670959989,
 983394,
 -55295,
 671025369,
 983393,
 -1,
 671090761,
 983392,
 671295501,
 670501638,
 983250,
 -55292,
 671223305,
 983391,
 -55291,
 671288714,
 983390,
 -55290,
 671354084,
 983389,
 -55289,
 671419468,
 983388,
 -55288,
 671484834,
 983387,
 -55287,
 671550214,
 983386,
 -55286,
 671615565,
 983385,
 -55285,
 671680885,
 983384,
 -55284,
 671746265,
 983383,
 -1,
 671811657,
 983382,
 672016408,
 671222349,
 983249,
 -55281,
 671944201,
 983381,
 -55280,
 672009610,
 983380,
 -55279,
 672074980,
 983379,
 -55278,
 672140364,
 983378,
 -55277,
 672205730,
 983377,
 -55276,
 672271110,
 983376,
 -55275,
 672336461,
 983375,
 -55274,
 672401781,
 983374,
 -55273,
 672467161,
 983373,
 -1,
 672532553,
 983372,
 672737315,
 671943029,
 983248,
 -55270,
 672665097,
 983371,
 -55269,
 672730506,
 983370,
 -55268,
 672795876,
 983369,
 -55267,
 672861260,
 983368,
 -55266,
 672926626,
 983367,
 -55265,
 672992006,
 983366,
 -55264,
 673057357,
 983365,
 -55263,
 673122677,
 983364,
 -55262,
 673188057,
 983363,
 -1,
 673253449,
 983362,
 673458222,
 672663769,
 983247,
 -55259,
 673385993,
 983361,
 -55258,
 673451402,
 983360,
 -55257,
 673516772,
 983359,
 -55256,
 673582156,
 983358,
 -55255,
 673647522,
 983357,
 -55254,
 673712902,
 983356,
 -55253,
 673778253,
 983355,
 -55252,
 673843573,
 983354,
 -55251,
 673908953,
 983353,
 -1,
 673974345,
 983352,
 674234367,
 673384521,
 983246,
 -55248,
 674106889,
 983351,
 -55247,
 674172298,
 983350,
 -55246,
 674237668,
 983349,
 -55245,
 674303052,
 983348,
 -55244,
 674368418,
 983347,
 -55243,
 674433798,
 983346,
 -55242,
 674499149,
 983345,
 -55241,
 674564469,
 983344,
 -55240,
 674629849,
 983343,
 -1,
 674695241,
 983342,
 674900093,
 667552117,
 983238,
 674965573,
 674827014,
 983266,
 -55236,
 674893321,
 983491,
 -55235,
 674958730,
 983490,
 -55234,
 675024100,
 983489,
 -55233,
 675089484,
 983488,
 -55232,
 675154850,
 983487,
 -55231,
 675220230,
 983486,
 -55230,
 675285581,
 983485,
 -55229,
 675350901,
 983484,
 -55228,
 675416281,
 983483,
 -1,
 675481673,
 983482,
 675686480,
 674892365,
 983265,
 -55225,
 675614217,
 983481,
 -55224,
 675679626,
 983480,
 -55223,
 675744996,
 983479,
 -55222,
 675810380,
 983478,
 -55221,
 675875746,
 983477,
 -55220,
 675941126,
 983476,
 -55219,
 676006477,
 983475,
 -55218,
 676071797,
 983474,
 -55217,
 676137177,
 983473,
 -1,
 676202569,
 983472,
 676407387,
 675613045,
 983264,
 -55214,
 676335113,
 983471,
 -55213,
 676400522,
 983470,
 -55212,
 676465892,
 983469,
 -55211,
 676531276,
 983468,
 -55210,
 676596642,
 983467,
 -55209,
 676662022,
 983466,
 -55208,
 676727373,
 983465,
 -55207,
 676792693,
 983464,
 -55206,
 676858073,
 983463,
 -1,
 676923465,
 983462,
 677128294,
 676333785,
 983263,
 -55203,
 677056009,
 983461,
 -55202,
 677121418,
 983460,
 -55201,
 677186788,
 983459,
 -55200,
 677252172,
 983458,
 -55199,
 677317538,
 983457,
 -55198,
 677382918,
 983456,
 -55197,
 677448269,
 983455,
 -55196,
 677513589,
 983454,
 -55195,
 677578969,
 983453,
 -1,
 677644361,
 983452,
 677849201,
 677054537,
 983262,
 -55192,
 677776905,
 983451,
 -55191,
 677842314,
 983450,
 -55190,
 677907684,
 983449,
 -55189,
 677973068,
 983448,
 -55188,
 678038434,
 983447,
 -55187,
 678103814,
 983446,
 -55186,
 678169165,
 983445,
 -55185,
 678234485,
 983444,
 -55184,
 678299865,
 983443,
 -1,
 678365257,
 983442,
 678570105,
 677776290,
 983267,
 -55181,
 678497356,
 983498,
 -55180,
 678562722,
 983497,
 -55179,
 678628102,
 983496,
 -55178,
 678693453,
 983495,
 -55177,
 678758773,
 983494,
 -55176,
 678824153,
 983493,
 -1,
 678889545,
 983492,
 -55174,
 678497801,
 983271,
 -55173,
 679021962,
 983270,
 -55172,
 679087332,
 983269,
 -1,
 679152716,
 983268,
 679356552,
 674827785,
 983245,
 -55169,
 679284233,
 983341,
 -55168,
 679349642,
 983340,
 -55167,
 679415012,
 983339,
 -55166,
 679480396,
 983338,
 -55165,
 679545762,
 983337,
 -55164,
 679611142,
 983336,
 -55163,
 679676493,
 983335,
 -55162,
 679741813,
 983334,
 -55161,
 679807193,
 983333,
 -1,
 679872585,
 983332,
 680077459,
 679284106,
 983244,
 -55158,
 680005129,
 983331,
 -55157,
 680070538,
 983330,
 -55156,
 680135908,
 983329,
 -55155,
 680201292,
 983328,
 -55154,
 680266658,
 983327,
 -55153,
 680332038,
 983326,
 -55152,
 680397389,
 983325,
 -55151,
 680462709,
 983324,
 -55150,
 680528089,
 983323,
 -1,
 680593481,
 983322,
 680798366,
 680004836,
 983243,
 -55147,
 680726025,
 983321,
 -55146,
 680791434,
 983320,
 -55145,
 680856804,
 983319,
 -55144,
 680922188,
 983318,
 -55143,
 680987554,
 983317,
 -55142,
 681052934,
 983316,
 -55141,
 681118285,
 983315,
 -55140,
 681183605,
 983314,
 -55139,
 681248985,
 983313,
 -1,
 681314377,
 983312,
 681519273,
 680725580,
 983242,
 -55136,
 681446921,
 983311,
 -55135,
 681512330,
 983310,
 -55134,
 681577700,
 983309,
 -55133,
 681643084,
 983308,
 -55132,
 681708450,
 983307,
 -55131,
 681773830,
 983306,
 -55130,
 681839181,
 983305,
 -55129,
 681904501,
 983304,
 -55128,
 681969881,
 983303,
 -1,
 682035273,
 983302,
 682240180,
 681446306,
 983241,
 -55125,
 682167817,
 983301,
 -55124,
 682233226,
 983300,
 -55123,
 682298596,
 983299,
 -55122,
 682363980,
 983298,
 -55121,
 682429346,
 983297,
 -55120,
 682494726,
 983296,
 -55119,
 682560077,
 983295,
 -55118,
 682625397,
 983294,
 -55117,
 682690777,
 983293,
 -1,
 682756169,
 983292,
 682961087,
 682167046,
 983240,
 -55114,
 682888713,
 983291,
 -55113,
 682954122,
 983290,
 -55112,
 683019492,
 983289,
 -55111,
 683084876,
 983288,
 -55110,
 683150242,
 983287,
 -55109,
 683215622,
 983286,
 -55108,
 683280973,
 983285,
 -55107,
 683346293,
 983284,
 -55106,
 683411673,
 983283,
 -1,
 683477065,
 983282,
 683737087,
 682887757,
 983239,
 -55103,
 683609609,
 983281,
 -55102,
 683675018,
 983280,
 -55101,
 683740388,
 983279,
 -55100,
 683805772,
 983278,
 -55099,
 683871138,
 983277,
 -55098,
 683936518,
 983276,
 -55097,
 684001869,
 983275,
 -55096,
 684067189,
 983274,
 -55095,
 684132569,
 983273,
 -1,
 684197961,
 983272,
 684402925,
 667494423,
 -1,
 684468452,
 684352889,
 -1,
 684533980,
 684427638,
 -1,
 684599515,
 684472242,
 -1,
 684665042,
 684551619,
 -1,
 -55088,
 684611906,
 128636,
 -55087,
 684671762,
 128953,
 -1,
 684724746,
 128941,
 684927189,
 684623287,
 -1,
 -55084,
 684880860,
 128914,
 -1,
 684924414,
 128904,
 685123800,
 684862061,
 -1,
 -55081,
 685077452,
 128959,
 -1,
 685138572,
 128976,
 -55079,
 685074618,
 128637,
 -55078,
 685258099,
 128934,
 -1,
 685322433,
 128947,
 -1,
 684530158,
 128933,
 685637631,
 684488859,
 -1,
 685648099,
 685536779,
 -1,
 685713634,
 685575927,
 -1,
 685779169,
 685669984,
 983069,
 -1,
 685704246,
 983143,
 -1,
 685703763,
 11135,
 -1,
 685663723,
 128678,
 -1,
 685601315,
 11837,
 686161919,
 684401863,
 -1,
 686172393,
 686061985,
 -1,
 -55065,
 686123803,
 7416,
 -55064,
 686171772,
 7417,
 -1,
 686234553,
 7412,
 686489599,
 686125447,
 -1,
 -55061,
 686391223,
 7414,
 -55060,
 686451904,
 7411,
 -1,
 686506968,
 7413,
 686696693,
 684341916,
 -1,
 686762227,
 686629910,
 -1,
 686827762,
 686686208,
 -1,
 -55055,
 686764923,
 127918,
 -1,
 686824350,
 128249,
 -1,
 686758963,
 128252,
 -55052,
 686709065,
 127931,
 -1,
 687020672,
 128243,
 687220983,
 686650891,
 983070,
 -1,
 687173059,
 983144,
 687407103,
 687167792,
 -1,
 -55047,
 687295291,
 127952,
 -1,
 687348690,
 127755,
 687548993,
 667427472,
 -1,
 687614373,
 687504463,
 -1,
 687679908,
 687563351,
 -1,
 687745398,
 687622811,
 -1,
 687810842,
 687697347,
 113692,
 687876365,
 687734784,
 -1,
 687941890,
 687834797,
 113701,
 -1,
 687866080,
 113702,
 688072964,
 687896075,
 113714,
 -1,
 687997939,
 113715,
 688204038,
 688021402,
 113716,
 -1,
 688129011,
 113717,
 688335112,
 688145454,
 113727,
 -1,
 688260083,
 113728,
 688466186,
 688276335,
 113696,
 -1,
 688391202,
 113710,
 -55029,
 688418243,
 113706,
 -55028,
 688542582,
 113723,
 -1,
 688606893,
 113724,
 688793881,
 687820046,
 -1,
 688859410,
 688728087,
 -1,
 -55024,
 688804726,
 113767,
 -55023,
 688862676,
 113740,
 -1,
 688924695,
 113742,
 689121557,
 688805822,
 -1,
 -55020,
 689079337,
 113730,
 -1,
 689132406,
 113769,
 -55018,
 689077327,
 113752,
 -55017,
 689259375,
 113685,
 -55016,
 689316982,
 113682,
 -1,
 689377896,
 113768,
 -1,
 688732552,
 113737,
 689645861,
 687756150,
 113690,
 689711392,
 689575184,
 -1,
 -55011,
 689667151,
 113761,
 -55010,
 689723326,
 113762,
 -55009,
 689781404,
 113763,
 -1,
 689835668,
 113764,
 690094079,
 689635328,
 -1,
 690104611,
 689983149,
 113694,
 -1,
 690029602,
 113708,
 -55004,
 690063021,
 113698,
 -1,
 690187715,
 113704,
 690366767,
 689587055,
 113691,
 690487295,
 690290688,
 -1,
 690497833,
 690390701,
 113699,
 -1,
 690449880,
 113700,
 690628907,
 690449859,
 113705,
 -1,
 690554366,
 113711,
 690759981,
 690574198,
 113712,
 -1,
 690684962,
 113713,
 690946047,
 690704045,
 113695,
 -1,
 690816034,
 113709,
 691022135,
 690324521,
 113720,
 691087666,
 690968510,
 113757,
 -1,
 691045417,
 113760,
 -54989,
 691026588,
 113758,
 -54988,
 691156436,
 113721,
 -54987,
 691219044,
 113759,
 -54986,
 691277460,
 113756,
 -1,
 691340275,
 113722,
 691546429,
 690972025,
 113675,
 691611963,
 691493260,
 -1,
 -54982,
 691567695,
 113750,
 -1,
 691616412,
 113741,
 -54980,
 691549652,
 113688,
 -1,
 691733538,
 113680,
 691939650,
 691492798,
 113732,
 -54977,
 691897385,
 113754,
 -54976,
 691960911,
 113755,
 -54975,
 692017317,
 113753,
 -1,
 692063892,
 113731,
 692267336,
 691883693,
 113689,
 692387839,
 692191232,
 -1,
 692398406,
 692278134,
 113693,
 -1,
 692323362,
 113707,
 -54969,
 692356781,
 113697,
 -1,
 692481475,
 113703,
 692660556,
 692223055,
 113745,
 -54966,
 692599452,
 113738,
 -54965,
 692663764,
 113751,
 -1,
 692716236,
 113748,
 692922705,
 692614667,
 113667,
 692988240,
 692846592,
 -1,
 -54961,
 692940227,
 113718,
 -1,
 693003668,
 113719,
 -1,
 692925908,
 113681,
 693250390,
 692871066,
 113666,
 693315925,
 693185845,
 -1,
 -54956,
 693261174,
 113765,
 -1,
 693325485,
 113766,
 -1,
 693240524,
 113676,
 693578075,
 693192228,
 113670,
 693643610,
 693525158,
 -1,
 -54951,
 693599311,
 113749,
 -1,
 693648028,
 113743,
 -1,
 693581268,
 113687,
 693905760,
 693519406,
 113669,
 693971295,
 693829632,
 -1,
 -54946,
 693921172,
 113725,
 -1,
 693980845,
 113679,
 -1,
 693912622,
 113684,
 694233443,
 693839895,
 113735,
 -54942,
 694189135,
 113746,
 -1,
 694233111,
 113739,
 694430054,
 694166160,
 113672,
 -54939,
 694367700,
 113683,
 -1,
 694420514,
 113677,
 694626664,
 694388946,
 113665,
 -1,
 694584361,
 113747,
 694757738,
 694583734,
 113673,
 -1,
 694704152,
 113770,
 694888812,
 694696604,
 113734,
 -1,
 694822935,
 113736,
 695019886,
 694826452,
 113664,
 -1,
 694961700,
 113686,
 695150960,
 694956817,
 113674,
 -1,
 695075830,
 113726,
 695282034,
 695086892,
 113668,
 -1,
 695206604,
 113678,
 695413108,
 695209620,
 113729,
 -1,
 695360855,
 113733,
 -54923,
 695372276,
 113744,
 -1,
 695473842,
 113671,
 695675296,
 687673491,
 -1,
 695740807,
 695617060,
 -1,
 695806342,
 695689000,
 -1,
 695871867,
 695763594,
 113816,
 -1,
 695796782,
 113779,
 696002942,
 695813668,
 -1,
 -54915,
 695949995,
 113811,
 -1,
 696008403,
 113814,
 696199553,
 695930516,
 -1,
 -54912,
 696151356,
 113817,
 -1,
 696197755,
 113808,
 -54910,
 696157401,
 113815,
 -54909,
 696350910,
 113809,
 -54908,
 696399213,
 113810,
 -54907,
 696460678,
 113812,
 -1,
 696524286,
 113813,
 -1,
 695740921,
 113776,
 696789395,
 695679094,
 -1,
 696854922,
 696746634,
 113800,
 -1,
 696779822,
 113781,
 696985997,
 696796708,
 -1,
 -54900,
 696933035,
 113795,
 -1,
 696991443,
 113798,
 -54898,
 696943833,
 113799,
 -54897,
 697137342,
 113793,
 -54896,
 697185645,
 113794,
 -54895,
 697247110,
 113796,
 -54894,
 697310718,
 113797,
 -1,
 697372653,
 113792,
 697575836,
 696718847,
 -1,
 697641368,
 697529986,
 -1,
 697706903,
 697587002,
 113784,
 -1,
 697631254,
 113788,
 -1,
 697646414,
 113785,
 -54887,
 697593577,
 113782,
 -54886,
 697846210,
 113783,
 -54885,
 697907892,
 113787,
 -1,
 697968712,
 113786,
 698165663,
 697520493,
 -1,
 -54882,
 698122912,
 113780,
 -1,
 698169700,
 113777,
 -1,
 698116471,
 113778,
 -54879,
 695629755,
 113821,
 -54878,
 698380718,
 113820,
 -54877,
 698442773,
 113823,
 -1,
 698492471,
 113822,
 -1,
 687611541,
 129414,
 698755559,
 687560638,
 -1,
 698821076,
 698713996,
 -1,
 698886609,
 698778767,
 -1,
 698952126,
 698840587,
 -1,
 699017661,
 698902780,
 -1,
 699083196,
 698943432,
 -1,
 699148729,
 699012268,
 11107,
 699269119,
 699072512,
 -1,
 699279799,
 699172512,
 -1,
 699345329,
 699223355,
 -1,
 -54864,
 699296378,
 11169,
 -1,
 699353559,
 11168,
 -54862,
 699302626,
 129075,
 -54861,
 699487237,
 129059,
 -54860,
 699551887,
 129063,
 -54859,
 699611082,
 129071,
 -54858,
 699672094,
 11133,
 -1,
 699734527,
 129067,
 -54856,
 699234672,
 11123,
 -1,
 699877976,
 11139,
 -54854,
 699108226,
 11085,
 -54853,
 700014579,
 11143,
 -1,
 700064690,
 11117,
 -1,
 699007150,
 129171,
 -1,
 698976276,
 11247,
 700393926,
 698881221,
 -1,
 700459458,
 700346971,
 -1,
 -54847,
 700414600,
 129027,
 -1,
 700460184,
 129043,
 -54845,
 700405378,
 129179,
 -54844,
 700600490,
 129031,
 -54843,
 700663641,
 129035,
 -1,
 700722328,
 129047,
 700918217,
 700345795,
 -1,
 -54840,
 700867806,
 129083,
 -1,
 700912439,
 129107,
 701114828,
 700856242,
 -1,
 -54837,
 701046713,
 129091,
 -1,
 701109420,
 129095,
 -54835,
 701072843,
 129175,
 -54834,
 701262935,
 128623,
 -54833,
 701313120,
 129079,
 -54832,
 701374393,
 129087,
 -1,
 701438219,
 11147,
 701693951,
 698812442,
 -1,
 -54829,
 701592262,
 128317,
 -1,
 701655032,
 128315,
 701835740,
 698776655,
 -1,
 701901275,
 701765976,
 -1,
 -54825,
 701858451,
 9208,
 -54824,
 701920645,
 11844,
 -54823,
 701976058,
 11842,
 -54822,
 702036629,
 11840,
 -1,
 702095938,
 10175,
 -1,
 701838451,
 127849,
 702360033,
 701768209,
 128462,
 702480383,
 702285148,
 -1,
 702491104,
 702379890,
 128441,
 -1,
 702414924,
 128442,
 -1,
 702439868,
 128443,
 702687715,
 702296849,
 128021,
 -1,
 702611929,
 128054,
 -54812,
 702644736,
 128330,
 -54811,
 702766097,
 128682,
 -54810,
 702828105,
 128044,
 -1,
 702874323,
 128687,
 703080979,
 698689559,
 -1,
 703146500,
 703037878,
 -1,
 703212029,
 703074941,
 -1,
 703277555,
 703154843,
 -1,
 703343086,
 703233103,
 -1,
 -54803,
 703299028,
 2423,
 -1,
 703342615,
 2422,
 703539697,
 703289278,
 -1,
 -54800,
 703486067,
 2420,
 -1,
 703539223,
 2419,
 -54798,
 703483846,
 2424,
 -1,
 703665793,
 2421,
 703867387,
 703235080,
 -1,
 703932919,
 703822927,
 -1,
 -54794,
 703888852,
 2391,
 -1,
 703932439,
 2390,
 704129530,
 703879102,
 -1,
 -54791,
 704075891,
 2363,
 -1,
 704129047,
 2362,
 -1,
 704059009,
 2383,
 -54788,
 703820224,
 43260,
 -1,
 704332693,
 43261,
 704577535,
 703151002,
 -1,
 704588289,
 704476683,
 -1,
 -54784,
 704546772,
 983085,
 -1,
 704592304,
 983087,
 -54782,
 704541956,
 983160,
 -54781,
 704731686,
 983083,
 -1,
 704786906,
 983089,
 704981514,
 703098307,
 -1,
 705047048,
 704923092,
 -1,
 -54777,
 705005160,
 128468,
 -1,
 705044426,
 128421,
 705298431,
 704982365,
 127964,
 -1,
 705167947,
 127965,
 705374733,
 704923172,
 983119,
 -54772,
 705315556,
 128666,
 -1,
 705375672,
 983118,
 705571344,
 705305411,
 -1,
 -54769,
 705521526,
 128475,
 -1,
 705575926,
 127795,
 -54767,
 705521771,
 127962,
 -54766,
 705716434,
 127980,
 -1,
 705768622,
 129420,
 705964578,
 703019676,
 -1,
 706030103,
 705924023,
 -1,
 -54762,
 705983964,
 128171,
 -1,
 706031443,
 128565,
 706226714,
 705982103,
 -1,
 -54759,
 706162515,
 128542,
 -1,
 706222874,
 128549,
 706423325,
 706172207,
 -1,
 -54756,
 706368661,
 127244,
 -1,
 706420296,
 127243,
 706619936,
 706351701,
 -1,
 -54753,
 706574062,
 128924,
 -1,
 706637896,
 128160,
 -54751,
 706570179,
 127919,
 -1,
 706751856,
 128754,
 706947632,
 705891988,
 -1,
 707013160,
 706884652,
 -1,
 707078695,
 706971296,
 -1,
 -54746,
 707029327,
 11831,
 -1,
 707086548,
 11830,
 -1,
 707020185,
 128481,
 707340843,
 706965464,
 -1,
 -54742,
 707299039,
 11843,
 -1,
 707360220,
 128168,
 707537454,
 707285878,
 -1,
 -54739,
 707474729,
 127841,
 -1,
 707534071,
 128131,
 -54737,
 707491461,
 983081,
 -1,
 707685416,
 128374,
 707865145,
 706897273,
 -1,
 707930677,
 707811262,
 -1,
 -54733,
 707879474,
 128167,
 -54732,
 707942734,
 129316,
 -1,
 708005957,
 128042,
 708192823,
 707858638,
 128009,
 -1,
 708116953,
 128050,
 -54728,
 708148876,
 129345,
 -1,
 708259232,
 128087,
 708454975,
 707795779,
 -1,
 -54725,
 708406723,
 983161,
 -54724,
 708446982,
 983090,
 -54723,
 708512333,
 983088,
 -54722,
 708577653,
 983086,
 -1,
 708643033,
 983084,
 -54720,
 708411883,
 128192,
 -1,
 708790335,
 983082,
 708979573,
 687494006,
 -1,
 709044996,
 708913175,
 -1,
 709110473,
 709002281,
 -1,
 709176000,
 709037718,
 -1,
 709241485,
 709118619,
 -1,
 709306960,
 709186422,
 -1,
 709372490,
 709265780,
 -1,
 -54711,
 709309922,
 70681,
 -1,
 709365396,
 70680,
 709569101,
 709309201,
 -1,
 -54708,
 709506530,
 70675,
 -1,
 709562004,
 70674,
 -54706,
 709514210,
 70686,
 -54705,
 709703138,
 70692,
 -1,
 709758612,
 70691,
 709962325,
 709264279,
 -1,
 710027859,
 709911929,
 70662,
 -1,
 709977465,
 70663,
 710213631,
 709969444,
 70664,
 -1,
 710100516,
 70665,
 710290011,
 709916171,
 -1,
 710355545,
 710243851,
 -1,
 -54696,
 710292962,
 70683,
 -1,
 710348436,
 70682,
 -54694,
 710292962,
 70688,
 -1,
 710479508,
 70687,
 710683233,
 710222480,
 -1,
 710748767,
 710615696,
 -1,
 -54690,
 710686178,
 70685,
 -1,
 710741652,
 70684,
 -54688,
 710686178,
 70690,
 -1,
 710872724,
 70689,
 711076453,
 710610580,
 70656,
 -54685,
 711031887,
 70669,
 -54684,
 711080604,
 70667,
 -1,
 711134868,
 70657,
 711338601,
 711028163,
 -1,
 -54681,
 711290408,
 70706,
 -54680,
 711341538,
 70705,
 -1,
 711397012,
 70707,
 711600747,
 711294031,
 70660,
 -1,
 711556175,
 70661,
 711731822,
 711550329,
 -1,
 -54675,
 711669218,
 70701,
 -1,
 711724692,
 70700,
 711928433,
 711679898,
 -1,
 -54672,
 711865826,
 70694,
 -1,
 711921300,
 70693,
 712125044,
 711872173,
 -1,
 -54669,
 712062434,
 70698,
 -1,
 712117908,
 70697,
 712321655,
 712066596,
 -1,
 -54666,
 712259042,
 70703,
 -1,
 712314516,
 70702,
 712518266,
 712262702,
 -1,
 -54663,
 712455650,
 70671,
 -1,
 712511124,
 70670,
 712714877,
 712459119,
 -1,
 -54660,
 712652258,
 70679,
 -1,
 712707732,
 70678,
 712911487,
 712653468,
 70658,
 -1,
 712850076,
 70659,
 713042562,
 712848145,
 -1,
 -54655,
 712979938,
 70673,
 -1,
 713035412,
 70672,
 713239173,
 712973123,
 -1,
 -54652,
 713176546,
 70677,
 -1,
 713232020,
 70676,
 713435784,
 713168562,
 -1,
 -54649,
 713373154,
 70696,
 -1,
 713428628,
 70695,
 -54647,
 713394624,
 70699,
 -54646,
 713589825,
 70704,
 -54645,
 713643966,
 70668,
 -54644,
 713700834,
 70708,
 -1,
 713762839,
 70666,
 713960093,
 709198856,
 -1,
 714025619,
 713917335,
 -1,
 714091153,
 713975161,
 70714,
 -1,
 714040697,
 70715,
 714276863,
 714032676,
 70716,
 -1,
 714163748,
 70717,
 714353303,
 713952916,
 -1,
 -54635,
 714308687,
 70721,
 -54634,
 714357404,
 70719,
 -1,
 714411668,
 70709,
 714615449,
 714308687,
 70712,
 -1,
 714570831,
 70713,
 714746523,
 714554012,
 70710,
 -1,
 714685084,
 70711,
 -54628,
 714692542,
 70720,
 -1,
 714811415,
 70718,
 715008686,
 713892496,
 -1,
 715074220,
 714947827,
 -1,
 715139746,
 715027979,
 -1,
 -54623,
 715098068,
 70738,
 -1,
 715143600,
 70739,
 715336357,
 715091395,
 -1,
 -54620,
 715277060,
 70742,
 -1,
 715337311,
 70743,
 715532968,
 715271980,
 -1,
 -54617,
 715480539,
 70740,
 -1,
 715539046,
 70741,
 -54615,
 715492209,
 70736,
 -54614,
 715676198,
 70737,
 -54613,
 715740521,
 70745,
 -1,
 715795047,
 70744,
 -54611,
 715021665,
 70732,
 -1,
 715920053,
 70731,
 716122810,
 714961209,
 -1,
 716188345,
 716059929,
 -1,
 716253875,
 716145473,
 -1,
 -54606,
 716205735,
 70725,
 -1,
 716269200,
 70722,
 716450486,
 716181140,
 -1,
 -54603,
 716407243,
 70727,
 -1,
 716461974,
 70724,
 -54601,
 716396371,
 70726,
 -54600,
 716582974,
 70728,
 -1,
 716643270,
 70723,
 -1,
 716121036,
 70730,
 -54597,
 716071409,
 70747,
 -54596,
 716855659,
 70729,
 -54595,
 716914696,
 70749,
 -54594,
 716977034,
 70734,
 -54593,
 717037450,
 70733,
 -1,
 717098784,
 70735,
 717302469,
 709099520,
 -1,
 717368004,
 717247180,
 -1,
 -54589,
 717326006,
 127770,
 -1,
 717387228,
 127761,
 -1,
 717311042,
 983063,
 717630152,
 717245511,
 -1,
 -54585,
 717580593,
 11155,
 -1,
 717637833,
 11154,
 -1,
 717583236,
 128240,
 717892351,
 709047201,
 -1,
 717957861,
 717845475,
 -1,
 718023394,
 717899696,
 -1,
 -54579,
 717982445,
 127369,
 -54578,
 718047604,
 127368,
 -54577,
 718112978,
 127367,
 -54576,
 718177321,
 127366,
 -54575,
 718242230,
 127365,
 -54574,
 718306383,
 127364,
 -54573,
 718370315,
 127363,
 -54572,
 718433731,
 127362,
 -54571,
 718497145,
 127361,
 -54570,
 718562438,
 127360,
 -54569,
 718624702,
 127358,
 -54568,
 718689142,
 127357,
 -54567,
 718750766,
 127354,
 -54566,
 718813852,
 127352,
 -54565,
 718878164,
 127351,
 -54564,
 718942993,
 127350,
 -54563,
 719007532,
 127349,
 -54562,
 719071255,
 127348,
 -54561,
 719135376,
 127347,
 -54560,
 719199043,
 127346,
 -54559,
 719263410,
 127345,
 -1,
 719326868,
 127344,
 -54557,
 717980978,
 127375,
 -54556,
 719462786,
 10062,
 -1,
 719523575,
 127374,
 719727358,
 717889066,
 -1,
 -54553,
 719686381,
 127337,
 -54552,
 719751540,
 127336,
 -54551,
 719816914,
 127335,
 -54550,
 719881257,
 127334,
 -54549,
 719946166,
 127333,
 -54548,
 720010319,
 127332,
 -54547,
 720074251,
 127331,
 -54546,
 720137667,
 127330,
 -54545,
 720201081,
 127329,
 -54544,
 720266374,
 127328,
 -54543,
 720328638,
 127326,
 -54542,
 720393078,
 127325,
 -54541,
 720457389,
 127324,
 -54540,
 720520740,
 127323,
 -54539,
 720585774,
 127322,
 -54538,
 720651119,
 127321,
 -54537,
 720714396,
 127320,
 -54536,
 720778001,
 127318,
 -54535,
 720842540,
 127317,
 -54534,
 720906263,
 127316,
 -54533,
 720970384,
 127315,
 -54532,
 721034051,
 127314,
 -54531,
 721098418,
 127313,
 -1,
 721161876,
 127312,
 -1,
 719654841,
 983091,
 -54528,
 717850956,
 983130,
 -54527,
 721387936,
 128528,
 -54526,
 721446711,
 129299,
 -54525,
 721503780,
 983131,
 -1,
 721559278,
 128084,
 721759037,
 708972180,
 -1,
 721824568,
 721688437,
 -1,
 721890091,
 721767067,
 -1,
 721955601,
 721825847,
 -1,
 -54519,
 721914581,
 67724,
 -54518,
 721973479,
 67740,
 -54517,
 722032530,
 67732,
 -54516,
 722096383,
 67730,
 -54515,
 722159343,
 67728,
 -54514,
 722224301,
 67726,
 -54513,
 722286434,
 67718,
 -54512,
 722343962,
 67714,
 -1,
 722407835,
 67712,
 722610966,
 721907139,
 -1,
 722676501,
 722538132,
 -1,
 -54508,
 722620660,
 67734,
 -1,
 722674819,
 67737,
 -1,
 722614457,
 67741,
 722938649,
 722564619,
 -1,
 -54504,
 722873800,
 67723,
 -1,
 722933377,
 67742,
 723135259,
 722876258,
 67719,
 -1,
 723089276,
 67722,
 723266334,
 723062420,
 -1,
 -54499,
 723225164,
 67735,
 -1,
 723274383,
 67713,
 -54497,
 723225441,
 67721,
 -54496,
 723421909,
 67725,
 -54495,
 723485935,
 67720,
 -54494,
 723544217,
 67739,
 -54493,
 723608759,
 67738,
 -54492,
 723673320,
 67736,
 -54491,
 723736466,
 67733,
 -54490,
 723800319,
 67731,
 -54489,
 723863279,
 67729,
 -54488,
 723928237,
 67727,
 -54487,
 723989708,
 67716,
 -54486,
 724050792,
 67717,
 -1,
 724113434,
 67715,
 724314935,
 721835865,
 -1,
 724380466,
 724268555,
 -1,
 724446000,
 724337705,
 -1,
 -54481,
 724391870,
 67752,
 -1,
 724446263,
 67758,
 -54479,
 724384176,
 67753,
 -1,
 724577095,
 67757,
 724773684,
 724326950,
 67751,
 -1,
 724697628,
 67759,
 724959231,
 724709164,
 -1,
 -54474,
 724852187,
 67754,
 -1,
 724910694,
 67756,
 -1,
 724246969,
 67755,
 -54471,
 721781027,
 129314,
 -54470,
 725121329,
 127966,
 -54469,
 725176375,
 128219,
 -54468,
 725238830,
 983092,
 -1,
 725302617,
 128133,
 725494635,
 721704894,
 -1,
 725560147,
 725443961,
 -1,
 725625682,
 725514108,
 -1,
 725691217,
 725549056,
 -1,
 725756745,
 725648777,
 -1,
 725822278,
 725705375,
 -1,
 -54460,
 725779292,
 128600,
 -54459,
 725829789,
 128592,
 -1,
 725883600,
 128608,
 726084424,
 725777102,
 11110,
 -1,
 726009131,
 11126,
 -1,
 726036102,
 129108,
 726335487,
 725690579,
 -1,
 726346574,
 726229663,
 -1,
 -54452,
 726303580,
 128602,
 -54451,
 726354077,
 128594,
 -1,
 726407888,
 128610,
 726608720,
 726301390,
 11111,
 -1,
 726533419,
 11127,
 -1,
 726560390,
 129109,
 -1,
 725625083,
 128746,
 -1,
 725558476,
 8379,
 726936414,
 725483520,
 -1,
 727001943,
 726884250,
 -1,
 -54442,
 726941970,
 128370,
 -1,
 727001480,
 128695,
 727198554,
 726931122,
 -1,
 -54439,
 727148380,
 983126,
 -1,
 727202787,
 128691,
 -54437,
 727151387,
 128685,
 -54436,
 727341678,
 128286,
 -54435,
 727405188,
 128245,
 -1,
 727460908,
 128683,
 727657320,
 726889995,
 -1,
 727722853,
 727590935,
 128456,
 727788386,
 727652899,
 128211,
 -1,
 727713239,
 128212,
 727973887,
 727712674,
 -1,
 -54428,
 727856085,
 128457,
 -1,
 727917200,
 128458,
 728170495,
 727653750,
 -1,
 -54425,
 728066509,
 128324,
 -1,
 728123687,
 128323,
 -54423,
 727609049,
 128067,
 -54422,
 728257483,
 128689,
 -1,
 728322653,
 65934,
 728509295,
 725449807,
 -1,
 728574830,
 728450596,
 983041,
 -1,
 728516132,
 983040,
 -1,
 728528400,
 128297,
 728771442,
 728438450,
 -1,
 -54415,
 728724326,
 983196,
 -1,
 728774100,
 983127,
 -54413,
 728716321,
 983223,
 -54412,
 728909348,
 983066,
 -1,
 728972461,
 127747,
 729164933,
 708920366,
 -1,
 729230432,
 729101780,
 -1,
 729295826,
 729185722,
 -1,
 729361333,
 729238171,
 -1,
 729426816,
 729293456,
 -1,
 729492350,
 729358992,
 -1,
 -54404,
 729429474,
 70347,
 -54403,
 729490203,
 70345,
 -1,
 729550484,
 70344,
 -54401,
 729429474,
 70352,
 -1,
 729681556,
 70351,
 729885574,
 729380363,
 -1,
 729951108,
 729839115,
 -1,
 -54397,
 729888226,
 70343,
 -1,
 729943700,
 70342,
 -54395,
 729888226,
 70350,
 -1,
 730074772,
 70349,
 730278795,
 729830262,
 -1,
 -54392,
 730237376,
 70341,
 -54391,
 730289122,
 70348,
 -54390,
 730346295,
 70335,
 -1,
 730402452,
 70353,
 730606479,
 730205844,
 70320,
 -54387,
 730561615,
 70329,
 -54386,
 730610332,
 70327,
 -1,
 730664596,
 70321,
 730868627,
 730547055,
 -1,
 -54383,
 730809221,
 70339,
 -54382,
 730871266,
 70340,
 -1,
 730926740,
 70338,
 731130775,
 730805009,
 -1,
 -54379,
 731067874,
 70334,
 -54378,
 731132727,
 70333,
 -1,
 731188884,
 70332,
 731392923,
 731059890,
 -1,
 -54375,
 731330018,
 70358,
 -54374,
 731387587,
 70357,
 -1,
 731451028,
 70356,
 731655069,
 731348047,
 70324,
 -1,
 731610191,
 70325,
 731786144,
 731606467,
 -1,
 -54369,
 731723234,
 70364,
 -1,
 731778708,
 70365,
 731982755,
 731735417,
 -1,
 -54366,
 731932109,
 70346,
 -1,
 731975316,
 70361,
 732179366,
 731930522,
 -1,
 -54363,
 732116450,
 70355,
 -1,
 732171924,
 70354,
 732375977,
 732120110,
 -1,
 -54360,
 732313058,
 70331,
 -1,
 732368532,
 70330,
 732572587,
 732314268,
 70322,
 -1,
 732510876,
 70323,
 732703662,
 732502851,
 -1,
 -54355,
 732640738,
 70337,
 -1,
 732696212,
 70336,
 -54353,
 732662208,
 70360,
 -54352,
 732856776,
 70363,
 -54351,
 732911550,
 70328,
 -54350,
 732974838,
 70359,
 -54349,
 733038190,
 70362,
 -54348,
 733099490,
 70366,
 -1,
 733161495,
 70326,
 733359043,
 729294042,
 -1,
 733424569,
 733312523,
 -1,
 -54344,
 733382612,
 70386,
 -1,
 733428144,
 70387,
 733621180,
 733375939,
 -1,
 -54341,
 733561604,
 70390,
 -1,
 733621855,
 70391,
 733817791,
 733556524,
 -1,
 -54338,
 733765083,
 70388,
 -1,
 733823590,
 70389,
 -54336,
 733776753,
 70384,
 -54335,
 733960742,
 70385,
 -54334,
 734025065,
 70393,
 -1,
 734079591,
 70392,
 734276558,
 733316104,
 -1,
 734342088,
 734203540,
 -1,
 -54330,
 734297167,
 70376,
 -54329,
 734345884,
 70374,
 -1,
 734400148,
 70368,
 734604234,
 734297167,
 70371,
 -1,
 734559311,
 70372,
 734735308,
 734542492,
 70369,
 -1,
 734673564,
 70370,
 -54323,
 734681022,
 70375,
 -1,
 734799895,
 70373,
 735051775,
 734228871,
 -1,
 -54320,
 734954348,
 70378,
 -54319,
 735008595,
 70377,
 -1,
 735056758,
 70367,
 735259685,
 729241832,
 -1,
 735325195,
 735201947,
 -1,
 735390683,
 735257232,
 -1,
 735456217,
 735322768,
 -1,
 -54313,
 735393250,
 70167,
 -54312,
 735453979,
 70172,
 -1,
 735514260,
 70166,
 -54310,
 735393250,
 70173,
 -1,
 735645332,
 70171,
 735849441,
 735344139,
 -1,
 735914975,
 735802891,
 -1,
 -54306,
 735852002,
 70165,
 -1,
 735907476,
 70164,
 -54304,
 735852002,
 70170,
 -1,
 736038548,
 70169,
 736242662,
 735794038,
 -1,
 -54301,
 736201152,
 70163,
 -54300,
 736252898,
 70168,
 -54299,
 736310071,
 70157,
 -1,
 736366228,
 70174,
 736570346,
 736169620,
 70144,
 -54296,
 736525391,
 70151,
 -54295,
 736574108,
 70149,
 -1,
 736628372,
 70145,
 736832494,
 736506641,
 -1,
 -54292,
 736769506,
 70156,
 -54291,
 736834359,
 70155,
 -1,
 736890516,
 70154,
 737094642,
 736761522,
 -1,
 -54288,
 737031650,
 70179,
 -54287,
 737089219,
 70178,
 -1,
 737152660,
 70177,
 737356789,
 737042330,
 -1,
 -54284,
 737293794,
 70176,
 -1,
 737349268,
 70175,
 737553400,
 737297956,
 -1,
 -54281,
 737494638,
 70187,
 -1,
 737545876,
 70183,
 737750011,
 737494062,
 -1,
 -54278,
 737687010,
 70153,
 -1,
 737742484,
 70152,
 737946622,
 737690479,
 -1,
 -54275,
 737887109,
 70161,
 -1,
 737939092,
 70160,
 738143233,
 737876803,
 -1,
 -54272,
 738080226,
 70159,
 -1,
 738135700,
 70158,
 -54270,
 738101696,
 70181,
 -54269,
 738296264,
 70184,
 -54268,
 738360399,
 70147,
 -54267,
 738422312,
 70185,
 -54266,
 738485709,
 70182,
 -54265,
 738547646,
 70150,
 -54264,
 738610934,
 70180,
 -54263,
 738671260,
 70146,
 -54262,
 738735586,
 70186,
 -1,
 738797591,
 70148,
 738995221,
 735282184,
 -1,
 739060752,
 738922132,
 -1,
 -54258,
 739015759,
 70195,
 -54257,
 739064476,
 70193,
 -1,
 739118740,
 70188,
 739322898,
 738998940,
 70189,
 -1,
 739261084,
 70190,
 -54253,
 739277903,
 70191,
 -54252,
 739399614,
 70194,
 -1,
 739452951,
 70192,
 739650590,
 738946499,
 -1,
 739716125,
 739589376,
 -1,
 739781658,
 739667395,
 -1,
 -54247,
 739737166,
 70206,
 -1,
 739784183,
 70199,
 -54245,
 739738476,
 70197,
 -54244,
 739923795,
 70198,
 -1,
 739971958,
 70196,
 -1,
 739649854,
 70203,
 740240419,
 739582608,
 -1,
 740305954,
 740187482,
 -1,
 -54239,
 740257520,
 70204,
 -1,
 740303762,
 70201,
 -1,
 740233909,
 70200,
 -54236,
 740198512,
 70202,
 -1,
 740495136,
 70205,
 740753407,
 735203641,
 -1,
 740764758,
 740630566,
 -1,
 740830256,
 740718091,
 -1,
 740895787,
 740783996,
 -1,
 -54230,
 740841406,
 983938,
 -1,
 740888212,
 983936,
 741092398,
 740832724,
 -1,
 -54227,
 741038014,
 983943,
 -1,
 741084820,
 983941,
 -54225,
 741038014,
 983942,
 -1,
 741215892,
 983940,
 741420085,
 740774774,
 -1,
 -54222,
 741378770,
 983934,
 -54221,
 741431230,
 983944,
 -54220,
 741487913,
 983929,
 -1,
 741543572,
 983939,
 741747771,
 741360686,
 -1,
 741813305,
 741684692,
 -1,
 -54216,
 741758910,
 983928,
 -1,
 741805716,
 983926,
 -54214,
 741758910,
 983927,
 -1,
 741936788,
 983925,
 742140993,
 741677891,
 -1,
 742206527,
 742077908,
 -1,
 -54210,
 742152126,
 983933,
 -1,
 742198932,
 983931,
 -54208,
 742152126,
 983932,
 -1,
 742330004,
 983930,
 742534213,
 742092227,
 -1,
 -54205,
 742485544,
 983955,
 -54204,
 742536674,
 983954,
 -1,
 742592148,
 983956,
 742796362,
 742481818,
 -1,
 742861897,
 742733268,
 -1,
 -54200,
 742807486,
 983948,
 -1,
 742854292,
 983946,
 -1,
 742807486,
 983947,
 743124045,
 742737444,
 -1,
 -54196,
 743069630,
 983952,
 -1,
 743116436,
 983958,
 743320656,
 743056016,
 -1,
 -54193,
 743266238,
 983937,
 -1,
 743313044,
 983935,
 -54191,
 743279314,
 983950,
 -54190,
 743474061,
 983953,
 -54189,
 743533648,
 983951,
 -54188,
 743592577,
 983949,
 -54187,
 743650786,
 983957,
 -1,
 743708355,
 983945,
 743910492,
 740703771,
 -1,
 743976025,
 743861688,
 983961,
 -1,
 743934324,
 983962,
 744161279,
 743924870,
 -1,
 -54181,
 744062031,
 983960,
 -1,
 744106007,
 983963,
 744357887,
 743867400,
 -1,
 -54178,
 744249707,
 983964,
 -54177,
 744300348,
 983959,
 -1,
 744361696,
 983965,
 744565878,
 729157268,
 -1,
 744631408,
 744519387,
 -1,
 744696936,
 744560778,
 -1,
 -54172,
 744651855,
 983973,
 -54171,
 744708030,
 983975,
 -54170,
 744766108,
 983972,
 -54169,
 744826903,
 983974,
 -1,
 744885908,
 983971,
 745144319,
 744623764,
 -1,
 745155695,
 745029717,
 -1,
 745221229,
 745109003,
 -1,
 -54164,
 745176143,
 983977,
 -1,
 745232318,
 983978,
 -54162,
 745168794,
 983979,
 -1,
 745348251,
 983976,
 -1,
 745105180,
 110592,
 745614453,
 744576488,
 -1,
 745679988,
 745566599,
 -1,
 -54157,
 745632617,
 3200,
 -1,
 745675718,
 3201,
 -1,
 745622193,
 983203,
 -1,
 745541374,
 128331,
 746007681,
 744503964,
 -1,
 746073215,
 745960442,
 128143,
 746138750,
 746012388,
 -1,
 746204285,
 746073939,
 128535,
 746323967,
 746128732,
 -1,
 -54148,
 746222337,
 128537,
 -1,
 746266385,
 128538,
 -1,
 746134619,
 128573,
 -1,
 746062489,
 128139,
 -54144,
 746030670,
 129373,
 -1,
 746541767,
 128088,
 746728580,
 745942821,
 128273,
 -54141,
 746658775,
 128287,
 -1,
 746723793,
 128422,
 -1,
 746674157,
 128040,
 746990984,
 729121833,
 -1,
 747056390,
 746917524,
 -1,
 747121908,
 747005594,
 -1,
 747187376,
 747074159,
 -1,
 747252878,
 747145588,
 -1,
 747318412,
 747207759,
 71875,
 -1,
 747258735,
 71886,
 -54131,
 747263934,
 71877,
 -1,
 747376276,
 71876,
 747580564,
 747189716,
 -1,
 747646098,
 747526078,
 -1,
 -54127,
 747597086,
 71899,
 -1,
 747654411,
 71898,
 -54125,
 747586402,
 71897,
 -1,
 747770830,
 71900,
 747973784,
 747507348,
 71873,
 -54122,
 747927051,
 71893,
 -54121,
 747984139,
 71882,
 -1,
 748048045,
 71894,
 748235932,
 747907095,
 71880,
 748355583,
 748180342,
 -1,
 -54117,
 748259700,
 71885,
 -1,
 748311414,
 71888,
 748498079,
 748190799,
 -1,
 -54114,
 748452943,
 71879,
 -1,
 748493635,
 71887,
 748694690,
 748449219,
 -1,
 -54111,
 748647829,
 71901,
 -1,
 748698951,
 71902,
 748891300,
 748640190,
 71881,
 -1,
 748823493,
 71889,
 749022375,
 748835702,
 -1,
 -54106,
 748977886,
 71891,
 -1,
 749024058,
 71872,
 -54104,
 748979768,
 71874,
 -54103,
 749175688,
 71903,
 -54102,
 749239124,
 71890,
 -54101,
 749298646,
 71896,
 -54100,
 749356453,
 71884,
 -54099,
 749419847,
 71878,
 -54098,
 749482807,
 71883,
 -54097,
 749544219,
 71892,
 -1,
 749607629,
 71895,
 749808856,
 747117535,
 -1,
 749874358,
 749767028,
 -1,
 749939892,
 749829199,
 71843,
 -1,
 749880175,
 71854,
 -54091,
 749885374,
 71845,
 -1,
 749997716,
 71844,
 750202044,
 749811156,
 -1,
 750267578,
 750147518,
 -1,
 -54087,
 750218526,
 71867,
 -1,
 750275851,
 71866,
 -54085,
 750207842,
 71865,
 -1,
 750392270,
 71868,
 750595264,
 750128788,
 71841,
 -54082,
 750548491,
 71861,
 -54081,
 750605579,
 71850,
 -1,
 750669485,
 71862,
 750857412,
 750528535,
 71848,
 750977023,
 750801782,
 -1,
 -54077,
 750881140,
 71853,
 -1,
 750932854,
 71856,
 751119559,
 750812239,
 -1,
 -54074,
 751074383,
 71847,
 -1,
 751115075,
 71855,
 751316170,
 751070659,
 -1,
 -54071,
 751269269,
 71869,
 -1,
 751320391,
 71870,
 751512780,
 751261630,
 71849,
 -1,
 751444933,
 71857,
 751643855,
 751457142,
 -1,
 -54066,
 751599326,
 71859,
 -1,
 751645498,
 71840,
 -54064,
 751601208,
 71842,
 -54063,
 751797128,
 71871,
 -54062,
 751860564,
 71858,
 -54061,
 751920086,
 71864,
 -54060,
 751977893,
 71852,
 -54059,
 752041287,
 71846,
 -54058,
 752104247,
 71851,
 -54057,
 752165659,
 71860,
 -1,
 752229069,
 71863,
 752430310,
 749741274,
 -1,
 752495836,
 752383499,
 -1,
 -54053,
 752453588,
 71906,
 -1,
 752499120,
 71907,
 752692447,
 752446915,
 -1,
 -54050,
 752632580,
 71910,
 -1,
 752692831,
 71911,
 752889058,
 752627500,
 -1,
 -54047,
 752836059,
 71908,
 -1,
 752894566,
 71909,
 -54045,
 752847729,
 71904,
 -54044,
 753031718,
 71905,
 -54043,
 753096041,
 71913,
 -1,
 753150567,
 71912,
 753347827,
 752375641,
 -1,
 753413355,
 753301003,
 -1,
 -54039,
 753370472,
 71915,
 -54038,
 753416439,
 71916,
 -1,
 753478471,
 71914,
 753675502,
 753364419,
 -1,
 -54035,
 753615683,
 71919,
 -1,
 753675919,
 71920,
 753872113,
 753610540,
 -1,
 -54032,
 753818781,
 71917,
 -1,
 753876009,
 71918,
 -54030,
 753816985,
 71922,
 -1,
 754002606,
 71921,
 -1,
 753293675,
 71935,
 754265339,
 747075426,
 -1,
 754330874,
 754188288,
 -1,
 -54025,
 754287833,
 127754,
 -54024,
 754344681,
 129341,
 -54023,
 754392861,
 128702,
 -1,
 754457300,
 128003,
 -1,
 754274553,
 127817,
 754724095,
 754221926,
 -1,
 -54019,
 754681329,
 127987,
 -54018,
 754726572,
 128075,
 -1,
 754784549,
 127988,
 754986242,
 754682163,
 -1,
 -54015,
 754922673,
 127764,
 -1,
 754983226,
 127762,
 755182853,
 754931104,
 -1,
 -54012,
 755119281,
 127766,
 -1,
 755179834,
 127768,
 -1,
 755135598,
 128465,
 755445059,
 746994332,
 -1,
 755510586,
 755377126,
 -1,
 755576085,
 755462999,
 -1,
 755641615,
 755533193,
 -1,
 -54005,
 755598028,
 129159,
 -54004,
 755650670,
 129143,
 -54003,
 755715006,
 129127,
 -54002,
 755775417,
 129151,
 -1,
 755832668,
 129135,
 756088831,
 755574995,
 -1,
 -53999,
 755991244,
 129158,
 -53998,
 756043886,
 129142,
 -53997,
 756108222,
 129126,
 -53996,
 756168633,
 129150,
 -1,
 756225884,
 129134,
 756428066,
 755521127,
 -1,
 756493596,
 756385161,
 -1,
 -53992,
 756449996,
 129156,
 -53991,
 756502638,
 129140,
 -53990,
 756566974,
 129124,
 -53989,
 756627385,
 129148,
 -1,
 756684636,
 129132,
 756940799,
 756426963,
 -1,
 -53986,
 756843212,
 129157,
 -53985,
 756895854,
 129141,
 -53984,
 756960190,
 129125,
 -53983,
 757020601,
 129149,
 -1,
 757077852,
 129133,
 757280040,
 756383764,
 -1,
 -53980,
 757236428,
 129153,
 -53979,
 757289070,
 129137,
 -53978,
 757353406,
 129121,
 -53977,
 757413817,
 129145,
 -1,
 757471068,
 129129,
 757673262,
 757230213,
 -1,
 -53974,
 757629644,
 129154,
 -53973,
 757682286,
 129138,
 -53972,
 757746622,
 129122,
 -53971,
 757807033,
 129146,
 -1,
 757864284,
 129130,
 758066484,
 757615073,
 -1,
 -53968,
 758022860,
 129152,
 -53967,
 758075502,
 129136,
 -53966,
 758139838,
 129120,
 -53965,
 758200249,
 129144,
 -1,
 758257500,
 129128,
 758513663,
 757999405,
 -1,
 -53962,
 758416076,
 129155,
 -53961,
 758468718,
 129139,
 -53960,
 758533054,
 129123,
 -53959,
 758593465,
 129147,
 -1,
 758650716,
 129131,
 758852928,
 755454838,
 -1,
 758918462,
 758784658,
 -1,
 -53955,
 758848958,
 127888,
 -1,
 758913454,
 127788,
 -53953,
 758859110,
 128521,
 -1,
 759048256,
 127863,
 -53951,
 758802411,
 128430,
 -53950,
 759189074,
 129344,
 -1,
 759247933,
 11838,
 759442796,
 755381716,
 -1,
 759508331,
 759382602,
 -1,
 759573840,
 759459267,
 -1,
 759639371,
 759529140,
 127779,
 759758847,
 759562240,
 -1,
 759770442,
 759633874,
 127781,
 -1,
 759695130,
 127782,
 -1,
 759727924,
 127780,
 760020991,
 759588055,
 -1,
 760032591,
 759898228,
 -1,
 -53938,
 759989010,
 128916,
 -1,
 760041628,
 128917,
 -1,
 759962412,
 128307,
 760294743,
 759505552,
 -1,
 760360276,
 760242007,
 -1,
 -53933,
 760301817,
 128407,
 -1,
 760354552,
 128071,
 760610815,
 760298330,
 -1,
 -53930,
 760513279,
 128922,
 -1,
 760565888,
 128923,
 760753499,
 760235556,
 -1,
 -53927,
 760700788,
 128928,
 -53926,
 760752655,
 128072,
 -1,
 760813004,
 128326,
 761015646,
 760690132,
 -1,
 -53923,
 760949016,
 9989,
 -1,
 761009166,
 128427,
 761212257,
 760950572,
 -1,
 -53920,
 761159207,
 11214,
 -1,
 761220632,
 128174,
 761408868,
 761140402,
 -1,
 -53917,
 761363501,
 129197,
 -1,
 761420326,
 129196,
 -53915,
 761364274,
 128070,
 -53914,
 761559568,
 128382,
 -53913,
 761620879,
 128073,
 -53912,
 761685342,
 10068,
 -53911,
 761749821,
 127985,
 -53910,
 761802477,
 10069,
 -1,
 761863685,
 128906,
 -1,
 759435671,
 128011,
 762129786,
 759388094,
 -1,
 762195318,
 762072749,
 -1,
 762260853,
 762122856,
 128105,
 762326388,
 762211781,
 -1,
 -53903,
 762277495,
 128097,
 -53902,
 762328897,
 128082,
 -53901,
 762388260,
 128090,
 -1,
 762452520,
 128098,
 -1,
 762250623,
 128111,
 -1,
 762194919,
 128698,
 762785145,
 762144121,
 -1,
 -53896,
 762734876,
 128543,
 -1,
 762791923,
 128506,
 -1,
 762727239,
 128058,
 763047298,
 762062871,
 -1,
 763112830,
 762985116,
 -1,
 -53891,
 763049116,
 127947,
 -1,
 763112770,
 983230,
 763309441,
 763041032,
 -1,
 -53888,
 763244371,
 128553,
 -1,
 763305027,
 128576,
 -1,
 763241425,
 128146,
 763571591,
 762996089,
 -1,
 763637126,
 763504663,
 -1,
 -53883,
 763589800,
 129340,
 -1,
 763647019,
 128295,
 -1,
 763564983,
 127873,
 -1,
 763511663,
 983225,
 763965028,
 746939769,
 -1,
 764030438,
 763902620,
 983153,
 764095954,
 763966585,
 -1,
 764161473,
 764052623,
 -1,
 764226980,
 764114443,
 -1,
 764292514,
 764176636,
 -1,
 764358049,
 764217288,
 -1,
 764423583,
 764286124,
 11106,
 764542975,
 764346368,
 -1,
 764554653,
 764446368,
 -1,
 764620181,
 764497211,
 -1,
 -53868,
 764575756,
 11173,
 -1,
 764618531,
 11175,
 764816792,
 764552629,
 -1,
 -53865,
 764773040,
 983234,
 -1,
 764819830,
 11132,
 -53863,
 764773090,
 129074,
 -53862,
 764957701,
 129058,
 -53861,
 765022351,
 129062,
 -53860,
 765081546,
 129070,
 -1,
 765139455,
 129066,
 -53858,
 764508528,
 11122,
 -1,
 765288114,
 11138,
 -53856,
 764370931,
 11142,
 -1,
 765404082,
 11116,
 -1,
 764281006,
 129170,
 -53853,
 764250132,
 11246,
 -1,
 765614985,
 129187,
 765799852,
 764155077,
 -1,
 765865384,
 765751899,
 -1,
 -53849,
 765819528,
 129026,
 -1,
 765865112,
 129042,
 -53847,
 765810306,
 129178,
 -53846,
 766005418,
 129030,
 -53845,
 766068569,
 129034,
 -1,
 766127256,
 129046,
 766324146,
 765728434,
 -1,
 766389680,
 766264966,
 -1,
 -53841,
 766320230,
 11146,
 -1,
 766383276,
 11157,
 -53839,
 766336288,
 129185,
 -1,
 766513049,
 129193,
 766717365,
 766275011,
 -1,
 -53836,
 766665950,
 129082,
 -1,
 766710583,
 129106,
 766913976,
 766666105,
 -1,
 -53833,
 766859314,
 128622,
 -1,
 766917821,
 129189,
 767110587,
 766850994,
 -1,
 -53830,
 767041465,
 129090,
 -1,
 767104172,
 129094,
 767307198,
 767045420,
 -1,
 -53827,
 767257747,
 129195,
 -1,
 767311807,
 129078,
 -53825,
 767264203,
 129174,
 -53824,
 767445418,
 129191,
 -1,
 767500217,
 129086,
 767700427,
 764084224,
 -1,
 767765960,
 767652747,
 -1,
 767831495,
 767693163,
 128360,
 767950847,
 767755612,
 -1,
 -53818,
 767850550,
 128362,
 -1,
 767908437,
 128361,
 -1,
 767764776,
 128489,
 -53815,
 767719396,
 128493,
 -53814,
 768095926,
 128381,
 -1,
 768152292,
 128495,
 768409599,
 767625121,
 -1,
 768421327,
 768290659,
 -1,
 -53810,
 768356509,
 129308,
 -1,
 768414846,
 1421,
 -53808,
 768375159,
 8295,
 -53807,
 768565949,
 128270,
 -1,
 768620271,
 9957,
 768814560,
 764024715,
 127872,
 768933887,
 768737404,
 -1,
 768945623,
 768835335,
 -1,
 -53802,
 768895281,
 11187,
 -1,
 768952521,
 11186,
 769142234,
 768895287,
 -1,
 -53799,
 769097476,
 11189,
 -1,
 769140382,
 11191,
 769338845,
 769083598,
 -1,
 -53796,
 769294084,
 11188,
 -1,
 769336990,
 11190,
 769589247,
 769271459,
 -1,
 -53793,
 769485105,
 11185,
 -1,
 769542345,
 11184,
 769732066,
 768759051,
 128141,
 -1,
 769670889,
 128365,
 769863141,
 769662110,
 -1,
 -53788,
 769794311,
 127832,
 -1,
 769857324,
 127833,
 -1,
 769798371,
 129350,
 770125341,
 763963415,
 -1,
 770190850,
 770061522,
 -1,
 -53783,
 770149101,
 127487,
 -53782,
 770214260,
 127486,
 -53781,
 770279634,
 127485,
 -53780,
 770343977,
 127484,
 -53779,
 770408886,
 127483,
 -53778,
 770473039,
 127482,
 -53777,
 770536971,
 127481,
 -53776,
 770600387,
 127480,
 -53775,
 770663801,
 127479,
 -53774,
 770729094,
 127478,
 -53773,
 770793370,
 127477,
 -53772,
 770856894,
 127476,
 -53771,
 770921334,
 127475,
 -53770,
 770985645,
 127474,
 -53769,
 771048996,
 127473,
 -53768,
 771114030,
 127472,
 -53767,
 771179375,
 127471,
 -53766,
 771242652,
 127470,
 -53765,
 771306964,
 127469,
 -53764,
 771371793,
 127468,
 -53763,
 771436332,
 127467,
 -53762,
 771500055,
 127466,
 -53761,
 771564176,
 127465,
 -53760,
 771627843,
 127464,
 -53759,
 771692210,
 127463,
 -1,
 771755668,
 127462,
 771960339,
 770146742,
 -1,
 772025874,
 771894589,
 -1,
 772091404,
 771957394,
 -1,
 772156936,
 772044926,
 -1,
 -53753,
 772112236,
 128402,
 -1,
 772155128,
 128403,
 -53751,
 772113220,
 128404,
 -53750,
 772302377,
 128401,
 -53749,
 772355790,
 128405,
 -1,
 772415370,
 11841,
 772669439,
 772014080,
 -1,
 772681232,
 772557683,
 -1,
 -53745,
 772625518,
 983151,
 -1,
 772682877,
 128968,
 -53743,
 772619833,
 983152,
 -1,
 772808040,
 128639,
 -1,
 771971421,
 128158,
 773074454,
 771914625,
 -1,
 -53739,
 773024049,
 11153,
 -1,
 773081289,
 11152,
 773271065,
 773004099,
 -1,
 -53736,
 773220237,
 128665,
 -1,
 773282891,
 983112,
 -53734,
 773223748,
 128699,
 -53733,
 773411396,
 127895,
 -53732,
 773475250,
 128524,
 -1,
 773530261,
 127822,
 773729848,
 770051732,
 -1,
 773795375,
 773667484,
 -1,
 773860907,
 773746442,
 -1,
 773926436,
 773797530,
 9995,
 774045695,
 773850460,
 -1,
 -53725,
 773939373,
 128406,
 -1,
 773992562,
 128400,
 774188583,
 773869229,
 -1,
 -53722,
 774120166,
 127339,
 -1,
 774183759,
 127338,
 -53720,
 774123677,
 9994,
 -53719,
 774317446,
 11827,
 -53718,
 774381450,
 11828,
 -1,
 774444779,
 129306,
 774647342,
 773803676,
 -1,
 -53715,
 774601272,
 128740,
 -1,
 774642735,
 128643,
 -1,
 774591516,
 127752,
 774909489,
 773727481,
 128251,
 -1,
 774832399,
 128280,
 775040564,
 774839800,
 -1,
 -53709,
 774984402,
 127949,
 -1,
 775035951,
 127950,
 775237174,
 774969222,
 128007,
 -1,
 775160281,
 128048,
 -53705,
 775190027,
 128000,
 -1,
 775311021,
 128015,
 775499339,
 773674942,
 -1,
 775564862,
 775441557,
 -1,
 775630397,
 775497751,
 -1,
 -53700,
 775579003,
 127906,
 -1,
 775627532,
 128478,
 -1,
 775569234,
 129315,
 775892545,
 775519948,
 -1,
 -53696,
 775845614,
 128907,
 -1,
 775906395,
 128205,
 776089156,
 775845621,
 -1,
 -53693,
 776046076,
 11215,
 -1,
 776096758,
 11213,
 776285766,
 776040153,
 127801,
 -1,
 776239956,
 127989,
 -53689,
 776242467,
 128675,
 -53688,
 776363185,
 128019,
 -53687,
 776412876,
 128640,
 -53686,
 776477230,
 129302,
 -1,
 776541542,
 127840,
 776744541,
 775453775,
 -1,
 776810075,
 776688502,
 -1,
 776875608,
 776747913,
 -1,
 776941141,
 776811130,
 -1,
 777006674,
 776867476,
 -1,
 -53679,
 776940908,
 5880,
 -1,
 777001795,
 5879,
 -53677,
 776952994,
 5876,
 -53676,
 777142680,
 5877,
 -1,
 777202240,
 5878,
 -53674,
 776892373,
 5874,
 -53673,
 777345842,
 5875,
 -1,
 777405486,
 5873,
 777650175,
 776819574,
 -1,
 -53670,
 777535366,
 127933,
 -1,
 777596078,
 127939,
 -53668,
 776745925,
 127945,
 -1,
 777722205,
 8381,
 777924194,
 776685092,
 -1,
 -53665,
 777869246,
 983222,
 -53664,
 777932461,
 983217,
 -53663,
 777992860,
 983227,
 -1,
 778053655,
 983219,
 -53661,
 777874883,
 983113,
 -1,
 778189009,
 129423,
 778383129,
 763897879,
 -1,
 778448544,
 778323492,
 -1,
 778514074,
 778377063,
 -1,
 778579564,
 778457974,
 -1,
 -53655,
 778519469,
 66837,
 -53654,
 778577943,
 66835,
 -53653,
 778642391,
 66821,
 -1,
 778702484,
 66836,
 778907250,
 778515217,
 -1,
 778972784,
 778843604,
 -1,
 -53649,
 778905623,
 66853,
 -1,
 778965570,
 66854,
 -53647,
 778912685,
 66827,
 -1,
 779102231,
 66826,
 779300469,
 778865389,
 -1,
 -53644,
 779237218,
 66852,
 -1,
 779298839,
 66851,
 779497080,
 779253259,
 -1,
 -53641,
 779433826,
 66846,
 -1,
 779495447,
 66845,
 779693691,
 779447747,
 -1,
 -53638,
 779630434,
 66844,
 -1,
 779692055,
 66843,
 779890302,
 779642233,
 -1,
 -53635,
 779839321,
 66842,
 -1,
 779888663,
 66841,
 780086913,
 779830820,
 -1,
 -53632,
 780027967,
 66833,
 -1,
 780085271,
 66832,
 780283524,
 780026926,
 -1,
 -53629,
 780220258,
 66855,
 -1,
 780281879,
 66831,
 780480134,
 780216343,
 66824,
 -1,
 780417692,
 66823,
 780611209,
 780411536,
 -1,
 -53624,
 780547938,
 66822,
 -1,
 780609559,
 66820,
 780807820,
 780540739,
 -1,
 -53621,
 780744546,
 66819,
 -1,
 780806167,
 66818,
 -53619,
 780765556,
 66850,
 -53618,
 780962070,
 66849,
 -53617,
 781025774,
 66848,
 -53616,
 781089871,
 66847,
 -53615,
 781149351,
 66840,
 -53614,
 781213928,
 66839,
 -53613,
 781277118,
 66838,
 -53612,
 781340724,
 66834,
 -53611,
 781403053,
 66830,
 -53610,
 781466268,
 66829,
 -53609,
 781530978,
 66828,
 -53608,
 781594555,
 66825,
 -53607,
 781653921,
 66817,
 -1,
 781717140,
 66816,
 781975551,
 778446871,
 -1,
 781987487,
 781853162,
 -1,
 -53603,
 781941212,
 128294,
 -53602,
 782000735,
 128268,
 -1,
 782060495,
 128161,
 -1,
 781935001,
 128024,
 782315214,
 778401291,
 -1,
 782380748,
 782252251,
 -1,
 782446281,
 782333358,
 -1,
 782511794,
 782377616,
 -1,
 782577323,
 782469869,
 -1,
 782642855,
 782510103,
 43797,
 -1,
 782575639,
 43796,
 -53592,
 782597199,
 43793,
 -53591,
 782718910,
 43798,
 -53590,
 782776988,
 43794,
 -1,
 782831320,
 43795,
 783089663,
 782509174,
 -1,
 783101614,
 782968855,
 43789,
 -1,
 783034391,
 43788,
 -53585,
 783055951,
 43785,
 -53584,
 783177662,
 43790,
 -53583,
 783235740,
 43786,
 -1,
 783290072,
 43787,
 783494842,
 782441622,
 -1,
 783560373,
 783427607,
 43813,
 -1,
 783493143,
 43812,
 783691447,
 783486612,
 43808,
 -1,
 783617684,
 43811,
 -53576,
 783645775,
 43809,
 -53575,
 783767486,
 43814,
 -1,
 783825564,
 43810,
 784019138,
 783423363,
 -1,
 784084669,
 783951895,
 43821,
 -1,
 784017431,
 43820,
 784215743,
 784010900,
 43816,
 -1,
 784141972,
 43819,
 -53568,
 784170063,
 43817,
 -53567,
 784291774,
 43822,
 -1,
 784349852,
 43818,
 784596991,
 783973222,
 -1,
 784608965,
 784476183,
 43781,
 -1,
 784541719,
 43780,
 -53562,
 784563279,
 43777,
 -53561,
 784684990,
 43782,
 -53560,
 784743068,
 43778,
 -1,
 784797400,
 43779,
 785055743,
 782376805,
 -1,
 -53557,
 784958437,
 4958,
 -1,
 785003504,
 4957,
 -53555,
 782338258,
 983047,
 -1,
 785127090,
 983096,
 785329888,
 782259062,
 -1,
 785395419,
 785261202,
 -1,
 785460954,
 785340534,
 -1,
 785526485,
 785413643,
 -1,
 785592020,
 785475237,
 983048,
 -1,
 785514733,
 983095,
 -1,
 785526554,
 983046,
 -53546,
 785477396,
 983134,
 -53545,
 785736633,
 983178,
 -53544,
 785797215,
 983099,
 -53543,
 785861698,
 983064,
 -1,
 785921421,
 983177,
 -1,
 785417968,
 128282,
 786181854,
 785351218,
 -1,
 -53539,
 786123819,
 128388,
 -1,
 786179968,
 128233,
 786431999,
 786130054,
 983051,
 -1,
 786333232,
 983050,
 786509551,
 785272493,
 -1,
 786575081,
 786457553,
 -1,
 786640614,
 786519695,
 128453,
 786759679,
 786564002,
 -1,
 -53531,
 786641877,
 128454,
 -1,
 786702992,
 128455,
 786902760,
 786587626,
 128460,
 -1,
 786853315,
 128461,
 -1,
 786834771,
 128459,
 787152895,
 786520265,
 -1,
 -53525,
 787024972,
 127999,
 -53524,
 787090338,
 127998,
 -53523,
 787155718,
 127997,
 -53522,
 787221069,
 127996,
 -1,
 787286373,
 127995,
 787492604,
 786467026,
 -1,
 787558139,
 787446321,
 -1,
 787623674,
 787491627,
 -1,
 787689205,
 787580343,
 -1,
 -53516,
 787641308,
 128915,
 -1,
 787684862,
 128905,
 787885816,
 787639747,
 -1,
 -53513,
 787825426,
 128954,
 -1,
 787878410,
 128942,
 -53511,
 787821939,
 128935,
 -1,
 788017345,
 128948,
 -1,
 787551655,
 128125,
 -1,
 787506077,
 128529,
 788344583,
 787418772,
 -1,
 788410118,
 788292985,
 128066,
 788475651,
 788363135,
 -1,
 788541186,
 788401812,
 -1,
 -53503,
 788492604,
 127759,
 -1,
 788549960,
 127758,
 -1,
 788475465,
 127757,
 788856831,
 788398830,
 -1,
 -53499,
 788752651,
 127806,
 -1,
 788811577,
 127805,
 -1,
 788346117,
 129413,
 789065482,
 788302324,
 128065,
 -53495,
 789016003,
 128064,
 -1,
 789067005,
 128083,
 789262094,
 789016003,
 -1,
 789327629,
 789191491,
 983104,
 -1,
 789255051,
 983103,
 -1,
 789253780,
 983135,
 789524242,
 789206974,
 -1,
 -53488,
 789476875,
 983049,
 -53487,
 789532333,
 983100,
 -1,
 789595684,
 983067,
 789786389,
 789479671,
 -1,
 -53484,
 789734194,
 127972,
 -1,
 789781564,
 127984,
 -53482,
 789742180,
 127794,
 -53481,
 789929940,
 983179,
 -53480,
 789984297,
 129370,
 -1,
 790038491,
 128231,
 790245342,
 778319316,
 -1,
 790310765,
 790177815,
 -1,
 790376299,
 790236820,
 -1,
 790441826,
 790332453,
 -1,
 790507308,
 790392259,
 -1,
 790572837,
 790453910,
 -1,
 790638370,
 790529423,
 -1,
 -53471,
 790594396,
 128605,
 -1,
 790633168,
 128613,
 790888447,
 790571225,
 -1,
 -53468,
 790791004,
 128607,
 -1,
 790829776,
 128615,
 791031592,
 790512391,
 -1,
 -53465,
 790983628,
 128952,
 -1,
 791044748,
 128972,
 791228203,
 790957716,
 -1,
 -53462,
 791172814,
 128635,
 -1,
 791236211,
 128940,
 -1,
 791159137,
 128625,
 791490357,
 790447652,
 -1,
 791555888,
 791437096,
 -1,
 -53457,
 791507436,
 10079,
 -1,
 791553512,
 10080,
 791752499,
 791489067,
 -1,
 -53454,
 791693117,
 129052,
 -1,
 791751832,
 129048,
 -53452,
 791690318,
 128627,
 -1,
 791877068,
 128327,
 792080189,
 791416468,
 -1,
 792145724,
 792030529,
 -1,
 792211259,
 792091174,
 129180,
 792330239,
 792133632,
 -1,
 -53446,
 792229841,
 129183,
 -1,
 792278621,
 129182,
 -1,
 792165421,
 129181,
 -1,
 792089355,
 128628,
 792604484,
 792024679,
 -1,
 792670017,
 792561039,
 -1,
 -53440,
 792626012,
 128604,
 -1,
 792664784,
 128612,
 792920063,
 792602841,
 -1,
 -53437,
 792822620,
 128606,
 -1,
 792861392,
 128614,
 793063243,
 792535696,
 -1,
 793128778,
 793008062,
 -1,
 793194313,
 793085888,
 -1,
 -53432,
 793134909,
 129055,
 -1,
 793193624,
 129051,
 -1,
 793136297,
 128178,
 -1,
 793068272,
 10135,
 793522000,
 792996461,
 -1,
 793587535,
 793469571,
 -1,
 -53426,
 793534921,
 128977,
 -1,
 793581901,
 128975,
 -1,
 793539532,
 128958,
 793849683,
 793478583,
 -1,
 -53422,
 793801692,
 128913,
 -1,
 793845246,
 128903,
 794046294,
 793804856,
 -1,
 -53419,
 793986877,
 129053,
 -1,
 794045592,
 129049,
 794242905,
 794000352,
 -1,
 -53416,
 794190281,
 128980,
 -1,
 794237261,
 128979,
 794439516,
 794192562,
 -1,
 -53413,
 794380093,
 129054,
 -1,
 794438808,
 129050,
 794636127,
 794374311,
 -1,
 -53410,
 794588108,
 128946,
 -1,
 794649228,
 128970,
 -53408,
 794583658,
 10133,
 -53407,
 794776146,
 10134,
 -1,
 794837056,
 128633,
 795029354,
 790390137,
 -1,
 795094889,
 794981901,
 -1,
 795160424,
 795051680,
 -1,
 -53402,
 795113794,
 127892,
 -53401,
 795175172,
 128157,
 -1,
 795219116,
 128152,
 -1,
 795091953,
 128159,
 -1,
 795019262,
 128585,
 -1,
 794961830,
 127911,
 -53396,
 790325006,
 127807,
 -1,
 795560841,
 128641,
 795750304,
 790236820,
 -1,
 795815826,
 795702795,
 -1,
 795881361,
 795764373,
 -1,
 795946890,
 795822747,
 -1,
 796012406,
 795897283,
 -1,
 796077941,
 795938452,
 -1,
 -53388,
 796020980,
 67822,
 -1,
 796075139,
 67825,
 -1,
 796014777,
 67828,
 796340089,
 795964939,
 -1,
 -53384,
 796274120,
 67816,
 -1,
 796333697,
 67829,
 796536699,
 796276578,
 67812,
 -1,
 796489596,
 67815,
 796667774,
 796462740,
 -1,
 -53379,
 796625607,
 67823,
 -1,
 796674703,
 67808,
 -53377,
 796625767,
 67814,
 -53376,
 796822229,
 67817,
 -53375,
 796886255,
 67813,
 -53374,
 796943543,
 67826,
 -53373,
 797008104,
 67824,
 -53372,
 797071250,
 67821,
 -53371,
 797135103,
 67820,
 -53370,
 797198063,
 67819,
 -53369,
 797263021,
 67818,
 -53368,
 797324492,
 67810,
 -53367,
 797385583,
 67811,
 -1,
 797448218,
 67809,
 797704191,
 795891545,
 -1,
 797716366,
 797603339,
 -1,
 -53363,
 797672808,
 67838,
 -1,
 797715271,
 67837,
 797912976,
 797661734,
 67835,
 -1,
 797835804,
 67839,
 -1,
 797847714,
 67836,
 -1,
 795811268,
 128035,
 798175128,
 795759663,
 -1,
 798240662,
 798103235,
 -1,
 -53355,
 798182549,
 129342,
 -1,
 798241553,
 128092,
 -53353,
 798191665,
 129309,
 -1,
 798361231,
 129310,
 798568349,
 798117549,
 -1,
 798633883,
 798511413,
 128296,
 -1,
 798556249,
 128736,
 -53348,
 798585976,
 128057,
 -1,
 798694134,
 127828,
 -53346,
 798517039,
 128436,
 -53345,
 798843768,
 128587,
 -1,
 798900603,
 128135,
 799092677,
 795695038,
 -1,
 799158192,
 799040889,
 -1,
 799223724,
 799097702,
 -1,
 799289259,
 799176203,
 -1,
 799354794,
 799215351,
 -1,
 799420329,
 799309408,
 983059,
 799539199,
 799342592,
 -1,
 -53336,
 799442636,
 983140,
 -1,
 799502270,
 983137,
 -1,
 799343187,
 11134,
 -1,
 799303147,
 128677,
 -1,
 799217968,
 11203,
 799932415,
 799174361,
 128014,
 799997951,
 799801344,
 -1,
 -53329,
 799892960,
 127943,
 -1,
 799944531,
 128052,
 800141238,
 799112271,
 -1,
 800206773,
 800091868,
 -1,
 800272308,
 800135900,
 127968,
 -1,
 800222659,
 127960,
 -1,
 800229056,
 127969,
 -1,
 800155868,
 9203,
 800534459,
 800093707,
 -1,
 800599994,
 800456704,
 -1,
 -53319,
 800547157,
 127798,
 -1,
 800597340,
 127789,
 -1,
 800533186,
 127976,
 800862143,
 800474660,
 -1,
 800927678,
 800804320,
 128616,
 -1,
 800850475,
 128617,
 -1,
 800860183,
 128371,
 801124290,
 800806133,
 -1,
 -53311,
 801052598,
 128029,
 -1,
 801113070,
 127855,
 -53309,
 801076158,
 127973,
 -53308,
 801267610,
 983123,
 -1,
 801316304,
 128298,
 801517527,
 799029916,
 -1,
 801583054,
 801465848,
 -1,
 801648589,
 801511562,
 -1,
 -53303,
 801602639,
 983968,
 -53302,
 801658814,
 983970,
 -53301,
 801716892,
 983967,
 -53300,
 801777687,
 983969,
 -1,
 801836692,
 983966,
 -1,
 801575935,
 110593,
 802107350,
 801518672,
 -1,
 802172883,
 802031521,
 -1,
 802238418,
 802124716,
 128644,
 -1,
 802162029,
 128645,
 -1,
 802174962,
 128096,
 802488319,
 802095104,
 -1,
 -53291,
 802379852,
 983122,
 -1,
 802429607,
 128262,
 -1,
 802035919,
 127802,
 802697179,
 801471567,
 -1,
 -53287,
 802648172,
 128559,
 -53286,
 802706519,
 128175,
 -1,
 802763826,
 129303,
 803012607,
 802649611,
 983060,
 -53283,
 802909635,
 983138,
 -1,
 802964335,
 983141,
 803156096,
 790180625,
 -1,
 803221596,
 803104121,
 -1,
 803287109,
 803147412,
 -1,
 803352643,
 803231543,
 -1,
 803418149,
 803293851,
 -1,
 803483629,
 803373494,
 -1,
 803549161,
 803428368,
 -1,
 803614695,
 803497337,
 70411,
 -1,
 803562873,
 70496,
 803799039,
 803554852,
 70412,
 -1,
 803685924,
 70497,
 803876844,
 803482003,
 -1,
 -53269,
 803808701,
 70495,
 -1,
 803869558,
 70494,
 -1,
 803802772,
 70453,
 804138995,
 803436043,
 -1,
 804204529,
 804091403,
 -1,
 -53264,
 804140514,
 70432,
 -1,
 804195988,
 70431,
 -53262,
 804140514,
 70437,
 -1,
 804327060,
 70436,
 804532216,
 804082550,
 -1,
 -53259,
 804489664,
 70430,
 -53258,
 804541410,
 70435,
 -53257,
 804598583,
 70425,
 -1,
 804654740,
 70440,
 804859902,
 804463248,
 -1,
 804925436,
 804790928,
 -1,
 -53253,
 804861410,
 70434,
 -1,
 804916884,
 70433,
 -53251,
 804861410,
 70439,
 -1,
 805047956,
 70438,
 805253122,
 804785812,
 70405,
 -53248,
 805207119,
 70420,
 -53247,
 805255836,
 70416,
 -1,
 805310100,
 70406,
 805515270,
 805203395,
 -1,
 -53244,
 805465640,
 70455,
 -53243,
 805516770,
 70454,
 -1,
 805572244,
 70456,
 805777416,
 805469263,
 70409,
 -1,
 805731407,
 70410,
 805908491,
 805724058,
 -1,
 -53238,
 805844450,
 70443,
 -1,
 805899924,
 70442,
 806105102,
 805848612,
 -1,
 -53235,
 806045294,
 70451,
 -1,
 806096532,
 70450,
 806301713,
 806044718,
 -1,
 -53232,
 806237666,
 70422,
 -1,
 806293140,
 70421,
 806498324,
 806241135,
 -1,
 -53229,
 806434274,
 70429,
 -1,
 806489748,
 70428,
 806694934,
 806435484,
 70407,
 -1,
 806632092,
 70408,
 806826009,
 806630161,
 -1,
 -53224,
 806761954,
 70424,
 -1,
 806817428,
 70423,
 807022620,
 806755139,
 -1,
 -53221,
 806958562,
 70427,
 -1,
 807014036,
 70426,
 807219231,
 806950578,
 -1,
 -53218,
 807155170,
 70445,
 -1,
 807210644,
 70444,
 -53216,
 807176640,
 70447,
 -53215,
 807364045,
 70448,
 -53214,
 807426866,
 70419,
 -53213,
 807489270,
 70446,
 -53212,
 807548386,
 70457,
 -1,
 807610777,
 70415,
 807809077,
 803374088,
 -1,
 807874603,
 807764887,
 -1,
 807940137,
 807822713,
 70467,
 -1,
 807888249,
 70468,
 808124415,
 807880228,
 70498,
 -1,
 808011300,
 70499,
 808202287,
 807800468,
 -1,
 -53203,
 808156239,
 70476,
 -53202,
 808204956,
 70472,
 -1,
 808259220,
 70462,
 808464433,
 808156239,
 70465,
 -1,
 808418383,
 70466,
 808595507,
 808401564,
 70463,
 -1,
 808532636,
 70464,
 -53196,
 808540978,
 70475,
 -1,
 808659353,
 70471,
 808857665,
 807760263,
 -1,
 808923193,
 808813377,
 -1,
 -53192,
 808873639,
 70403,
 -1,
 808937104,
 70477,
 809119804,
 808852291,
 -1,
 -53189,
 809064853,
 70400,
 -1,
 809112261,
 70401,
 809316415,
 809045652,
 -1,
 -53186,
 809271755,
 70461,
 -1,
 809326486,
 70402,
 -53184,
 809263732,
 70493,
 -1,
 809457491,
 70460,
 -53182,
 808802667,
 70480,
 -1,
 809571882,
 70487,
 -53180,
 803299720,
 127815,
 -1,
 809707459,
 127891,
 809906259,
 803219865,
 -1,
 809971790,
 809845808,
 -1,
 810037322,
 809921987,
 -1,
 -53175,
 809994928,
 65952,
 -1,
 810041434,
 65932,
 -53173,
 809982532,
 65931,
 -53172,
 810175199,
 43877,
 -53171,
 810237636,
 65933,
 -1,
 810294284,
 895,
 810549247,
 809915256,
 -1,
 -53168,
 810446405,
 129367,
 -53167,
 810497939,
 128154,
 -53166,
 810555939,
 128215,
 -1,
 810619845,
 127823,
 810823769,
 809843356,
 -1,
 810889304,
 810767859,
 -1,
 810954839,
 810823507,
 128512,
 -1,
 810878779,
 128513,
 -1,
 810884213,
 128568,
 -1,
 810831629,
 128556,
 811270143,
 810768318,
 -1,
 -53157,
 811173487,
 128151,
 -1,
 811237215,
 983109,
 811413610,
 803153943,
 -1,
 811479145,
 811359334,
 -1,
 811544675,
 811420315,
 -1,
 -53152,
 811498658,
 983924,
 -53151,
 811550330,
 4351,
 -53150,
 811611959,
 4350,
 -1,
 811667510,
 4349,
 811872358,
 811496047,
 -1,
 -53147,
 811829959,
 11559,
 -1,
 811864118,
 11565,
 812122111,
 811801567,
 -1,
 -53144,
 812026567,
 4295,
 -1,
 812060726,
 4301,
 -1,
 811421382,
 128142,
 812331120,
 811367503,
 -1,
 812396654,
 812270497,
 -1,
 -53139,
 812337923,
 2809,
 -1,
 812388128,
 2800,
 -53137,
 812335673,
 127928,
 -1,
 812520484,
 128130,
 812724342,
 812275646,
 -1,
 812789876,
 812650132,
 -1,
 -53133,
 812742155,
 128016,
 -1,
 812795440,
 129349,
 -53131,
 812739310,
 129421,
 -1,
 812927823,
 127948,
 813117563,
 812664356,
 -1,
 813183098,
 813062078,
 -1,
 -53127,
 813139578,
 127775,
 -1,
 813176740,
 127760,
 -1,
 813110618,
 129371,
 813445245,
 813056385,
 128103,
 -1,
 813395479,
 128714,
 -53122,
 813395395,
 983110,
 -53121,
 813513103,
 128123,
 -1,
 813568556,
 127922,
 813773040,
 803090220,
 -1,
 813838503,
 813698708,
 -1,
 813904033,
 813767491,
 -1,
 813969568,
 813836313,
 -1,
 814035098,
 813926043,
 -1,
 814100633,
 813957120,
 -1,
 814166154,
 814052698,
 128539,
 814284799,
 814088207,
 -1,
 -53111,
 814188169,
 128540,
 -1,
 814250186,
 128541,
 814428302,
 814110654,
 -1,
 814493837,
 814375213,
 128558,
 -1,
 814415904,
 128560,
 -1,
 814433343,
 128582,
 814690449,
 814380555,
 -1,
 -53104,
 814626847,
 129298,
 -1,
 814688427,
 128514,
 814887060,
 814620466,
 -1,
 -53101,
 814843177,
 129312,
 -1,
 814893080,
 128531,
 -53099,
 814836838,
 128580,
 -53098,
 815027733,
 128581,
 -53097,
 815091794,
 128567,
 -53096,
 815156564,
 128548,
 -1,
 815216499,
 129301,
 -1,
 814046860,
 128566,
 815476893,
 813985219,
 -1,
 -53092,
 815407388,
 128561,
 -1,
 815470185,
 128523,
 -53090,
 815429704,
 128536,
 -53089,
 815620119,
 129318,
 -1,
 815681500,
 128134,
 -1,
 813922805,
 127981,
 815935652,
 813861076,
 -1,
 -53085,
 815877893,
 128224,
 -1,
 815938526,
 128439,
 -53083,
 815888300,
 127877,
 -53082,
 816075327,
 128106,
 -1,
 816139443,
 127810,
 816328898,
 813775516,
 -1,
 816394420,
 816276857,
 -1,
 816459951,
 816346154,
 -1,
 816525485,
 816407816,
 -1,
 -53076,
 816481974,
 127771,
 -1,
 816543196,
 127763,
 -53074,
 816477493,
 8296,
 -1,
 816669157,
 129351,
 816906239,
 816392215,
 128293,
 816918707,
 816810111,
 -1,
 -53070,
 816868803,
 127878,
 -1,
 816907353,
 127879,
 -1,
 816841162,
 128658,
 817180860,
 816334372,
 -1,
 817246393,
 817113113,
 -1,
 -53065,
 817196904,
 983106,
 -53064,
 817246563,
 128193,
 -1,
 817306470,
 128452,
 817561599,
 817188527,
 -1,
 -53061,
 817456047,
 128253,
 -1,
 817508979,
 127902,
 817705153,
 817130947,
 -1,
 817770688,
 817640916,
 128031,
 -53057,
 817708916,
 127907,
 -1,
 817758487,
 127845,
 -1,
 817723178,
 128074,
 -1,
 817638089,
 127953,
 818098384,
 816273342,
 -1,
 818163911,
 818053226,
 -1,
 -53051,
 818111116,
 128966,
 -53050,
 818170018,
 127808,
 -1,
 818225369,
 11156,
 818426059,
 818111865,
 -1,
 818491594,
 818365491,
 127860,
 -1,
 818415374,
 127869,
 -1,
 818433714,
 983071,
 818688205,
 818361105,
 127787,
 -1,
 818623948,
 127745,
 -53042,
 818645207,
 129418,
 -53041,
 818765079,
 128099,
 -1,
 818825259,
 128448,
 819015899,
 818046329,
 -1,
 819081429,
 818960318,
 -1,
 -53037,
 819038103,
 128550,
 -53036,
 819091219,
 128037,
 -1,
 819147539,
 128056,
 819343577,
 819008052,
 -1,
 -53033,
 819296478,
 128445,
 -53032,
 819356092,
 128444,
 -1,
 819401327,
 128446,
 -53030,
 819280901,
 127844,
 -1,
 819538806,
 127839,
 819736802,
 818955812,
 -1,
 819802335,
 819681214,
 -1,
 -53026,
 819758455,
 127924,
 -1,
 819815279,
 128190,
 -53024,
 819759707,
 128389,
 -53023,
 819953987,
 128563,
 -1,
 819998471,
 128170,
 820195558,
 819692570,
 -1,
 -53020,
 820120141,
 983211,
 -53019,
 820185461,
 983210,
 -1,
 820250841,
 983209,
 820457706,
 820127767,
 -1,
 -53016,
 820407595,
 127905,
 -53015,
 820466726,
 129338,
 -1,
 820515888,
 128552,
 820719853,
 820412012,
 -1,
 -53012,
 820676278,
 127773,
 -1,
 820737500,
 127765,
 820916463,
 820669891,
 983107,
 -1,
 820853404,
 983228,
 -1,
 820850476,
 983072,
 821113138,
 813726799,
 -1,
 821178667,
 821059482,
 -1,
 821244189,
 821134479,
 -1,
 821309704,
 821196299,
 -1,
 821375239,
 821258492,
 -1,
 821440774,
 821299144,
 -1,
 821506308,
 821367980,
 11105,
 821624831,
 821428224,
 -1,
 821637378,
 821528224,
 -1,
 821702908,
 821579067,
 -1,
 -52997,
 821652090,
 11171,
 -1,
 821709271,
 11170,
 -52995,
 821658338,
 129073,
 -52994,
 821842949,
 129057,
 -52993,
 821907599,
 129061,
 -52992,
 821966794,
 129069,
 -52991,
 822027806,
 11131,
 -1,
 822090239,
 129065,
 -52989,
 821590384,
 11121,
 -1,
 822233643,
 11137,
 -52987,
 821452787,
 11141,
 -1,
 822354866,
 11115,
 -1,
 821362862,
 129169,
 -1,
 821331988,
 11245,
 822685968,
 821236933,
 -1,
 822751500,
 822637147,
 -1,
 -52981,
 822704776,
 129025,
 -1,
 822750360,
 129041,
 -52979,
 822695554,
 129177,
 -52978,
 822890666,
 129029,
 -52977,
 822953817,
 129033,
 -1,
 823012504,
 129045,
 823210259,
 822642110,
 -1,
 -52974,
 823166825,
 129173,
 -1,
 823210641,
 11192,
 823406870,
 823160259,
 -1,
 -52971,
 823354590,
 129081,
 -1,
 823399223,
 129105,
 823603481,
 823343026,
 -1,
 -52968,
 823533497,
 129089,
 -1,
 823596204,
 129093,
 -52966,
 823553111,
 128621,
 -52965,
 823734368,
 129077,
 -52964,
 823795641,
 129085,
 -1,
 823859467,
 11145,
 824062244,
 821168154,
 -1,
 824127777,
 824013403,
 -1,
 -52960,
 824076280,
 128316,
 -1,
 824119578,
 128744,
 -52958,
 824076280,
 128314,
 -52957,
 824267300,
 128742,
 -1,
 824316186,
 128743,
 824521001,
 823984128,
 -1,
 824586536,
 824452771,
 -1,
 -52953,
 824539854,
 11109,
 -1,
 824602246,
 129113,
 -1,
 824513756,
 11193,
 -52950,
 824471923,
 128579,
 -1,
 824795488,
 128319,
 824979761,
 821121910,
 -1,
 825045295,
 824916636,
 -1,
 -52946,
 824997469,
 983115,
 -1,
 825041103,
 129412,
 -52944,
 824974587,
 11217,
 -1,
 825168476,
 128530,
 -1,
 824929731,
 983116,
 825438544,
 821050012,
 -1,
 825504075,
 825381750,
 -1,
 825569595,
 825451631,
 -1,
 825635129,
 825509801,
 -1,
 -52937,
 825586343,
 128289,
 -52936,
 825641742,
 128292,
 -1,
 825695263,
 128288,
 -52934,
 825587203,
 128291,
 -1,
 825841532,
 128290,
 826028355,
 825504135,
 -1,
 826093890,
 825978738,
 -1,
 826159424,
 826045963,
 -1,
 -52929,
 826116052,
 983111,
 -1,
 826161584,
 983108,
 -52927,
 826104358,
 983114,
 -1,
 826290650,
 983105,
 -1,
 826025052,
 128129,
 826552646,
 825959056,
 983129,
 -52923,
 826489715,
 8377,
 -1,
 826552025,
 983128,
 826749257,
 826481475,
 -1,
 -52920,
 826697590,
 128474,
 -1,
 826759608,
 128232,
 -52918,
 826704505,
 9959,
 -1,
 826874480,
 128229,
 827076942,
 825433246,
 -1,
 -52915,
 827013397,
 127954,
 -1,
 827072790,
 127848,
 -52913,
 827034385,
 127982,
 -1,
 827216634,
 128127,
 827404637,
 825377647,
 -1,
 827470170,
 827330196,
 -1,
 827535705,
 827416608,
 -1,
 -52908,
 827487715,
 128304,
 -52907,
 827548466,
 127971,
 -52906,
 827611296,
 128121,
 -52905,
 827667756,
 128122,
 -52904,
 827729280,
 127886,
 -1,
 827792444,
 127983,
 -1,
 827465385,
 127875,
 -52901,
 827424272,
 129337,
 -52900,
 828006252,
 128377,
 -1,
 828057766,
 128086,
 828256613,
 827362029,
 -1,
 828322148,
 828212265,
 -1,
 828387682,
 828265334,
 -1,
 -52895,
 828326767,
 983214,
 -1,
 828381897,
 983255,
 -52893,
 828339046,
 983213,
 -1,
 828523375,
 983215,
 -1,
 828260574,
 129296,
 828833791,
 828213620,
 -1,
 -52889,
 828717781,
 983235,
 -1,
 828779261,
 128155]
_charnames_1318 = [
8466,
8454,
8464,
8450,
8460,
8443,
8462,
8445,
8465,
8451,
]

_charnames_2112 = [
6666,
6660,
6658,
6659,
6657,
6664,
6649,
6662,
6646,
6648,
6647,
6655,
6654,
6653,
6642,
6663,
6652,
6643,
6651,
6650,
6644,
6645,
6667,
6665,
6656,
6671,
6668,
6670,
-1,
-1,
6669,
]

_charnames_2208 = [
4186,
4188,
4208,
4191,
4210,
4206,
4200,
4196,
4177,
4178,
4182,
4205,
4183,
4199,
4211,
4194,
4209,
4193,
4204,
4174,
4203,
-1,
4187,
4207,
4190,
4181,
4176,
4173,
4171,
4172,
]

_charnames_2260 = [
4140,
4148,
4152,
4149,
4150,
4153,
4138,
4139,
4141,
4143,
4144,
4142,
4151,
4147,
4237,
4226,
4230,
4232,
4228,
4231,
4233,
4229,
4222,
4219,
4225,
4221,
4218,
4224,
4245,
4246,
4244,
4145,
4248,
4249,
4252,
4214,
4240,
4213,
4242,
4235,
4236,
4241,
4238,
4105,
]

_charnames_2383 = [
10746,
-1,
-1,
-1,
-1,
-1,
-1,
10742,
10741,
]

_charnames_3406 = [
6856,
6859,
-1,
-1,
-1,
-1,
6852,
6851,
6853,
-1,
6843,
6840,
6848,
6837,
6838,
6846,
6841,
6857,
]

_charnames_3558 = [
2704,
2705,
2696,
2697,
2702,
2703,
2699,
2700,
2707,
2706,
]

_charnames_4295 = [
12391,
-1,
-1,
-1,
-1,
-1,
12392,
]

_charnames_5109 = [
7910,
-1,
-1,
7866,
7865,
7864,
7863,
7862,
7883,
]

_charnames_5873 = [
11863,
11861,
11862,
11858,
11859,
11860,
11857,
11856,
]

_charnames_6832 = [
8146,
8148,
8174,
8147,
8162,
8170,
8171,
8157,
8144,
8120,
8173,
8166,
8143,
8165,
8164,
]

_charnames_7098 = [
3076,
3069,
3070,
3071,
3068,
3067,
5505,
5474,
5500,
5472,
5488,
5504,
5497,
5490,
5469,
5482,
5487,
5493,
5466,
5491,
5501,
5473,
5498,
5502,
5495,
5468,
5484,
5470,
5475,
5479,
5476,
5467,
5486,
5492,
5465,
5480,
5496,
5471,
5478,
5503,
5481,
5489,
5499,
5494,
5524,
5512,
5514,
5513,
5516,
5511,
5515,
5510,
5507,
5508,
5529,
5530,
5527,
5526,
]

_charnames_7296 = [
8447,
8456,
8455,
8452,
8439,
8441,
8440,
8438,
8453,
]

_charnames_7360 = [
3059,
3058,
3057,
3063,
3060,
3061,
3062,
3064,
]

_charnames_7411 = [
10475,
10472,
10476,
10474,
-1,
10470,
10471,
]

_charnames_7655 = [
8108,
8105,
8106,
8111,
8114,
8113,
8103,
8112,
8115,
8100,
8110,
8109,
8104,
8101,
8172,
-1,
-1,
-1,
-1,
-1,
8149,
8145,
]

_charnames_8341 = [
9074,
9073,
9072,
9071,
9070,
9069,
9068,
9067,
]

_charnames_9193 = [
5962,
5980,
5988,
5973,
5963,
5981,
5964,
4424,
3117,
1414,
12213,
5930,
5928,
5923,
5932,
10710,
5951,
5948,
9722,
9725,
9726,
9723,
]

_charnames_9984 = [
5958,
-1,
-1,
-1,
-1,
11612,
-1,
-1,
-1,
-1,
11815,
11808,
]

_charnames_10060 = [
8476,
-1,
10979,
-1,
-1,
-1,
-1,
6006,
11623,
11625,
]

_charnames_11098 = [
3192,
5600,
3191,
5599,
6061,
2869,
9143,
12534,
11663,
10667,
9193,
12582,
11078,
11086,
3041,
3033,
9160,
12549,
11680,
10683,
8407,
3906,
9157,
12546,
11677,
10679,
-1,
-1,
11079,
11087,
3042,
3034,
9151,
12544,
11671,
10677,
12201,
10465,
9158,
12547,
11678,
10680,
9159,
12548,
11679,
10682,
9174,
12572,
11694,
10704,
3905,
3908,
3907,
3904,
11797,
11796,
10951,
10950,
12486,
11695,
-1,
-1,
1432,
1433,
1431,
1434,
5983,
5989,
5966,
5974,
10672,
10671,
12539,
12538,
9147,
11667,
9148,
11668,
5947,
5946,
5938,
5937,
5943,
5940,
5944,
5941,
11743,
11742,
11734,
11733,
11739,
11736,
11740,
11737,
12562,
12584,
-1,
-1,
-1,
5591,
8499,
8501,
5952,
5977,
1466,
12203,
6007,
5924,
5933,
5931,
5929,
-1,
1519,
6044,
8927,
11843,
11615,
11842,
2980,
12591,
]

_charnames_11559 = [
12388,
-1,
-1,
-1,
-1,
-1,
12389,
]

_charnames_11826 = [
1465,
11816,
11817,
1455,
10790,
10789,
1460,
1518,
1534,
1435,
3112,
10467,
11586,
8355,
10713,
11787,
10712,
10793,
10711,
]

_charnames_42612 = [
8128,
8129,
8125,
8127,
8133,
8126,
8131,
8132,
]

_charnames_42648 = [
8461,
8444,
8468,
8457,
7176,
7175,
8134,
8130,
]

_charnames_42893 = [
9083,
9009,
9113,
9093,
9039,
9099,
9021,
9020,
9050,
9102,
8979,
9108,
9065,
9079,
9031,
9078,
9030,
9077,
9029,
9096,
9053,
9105,
9064,
9092,
9038,
9090,
9034,
9087,
8967,
9107,
9089,
9086,
9104,
9085,
-1,
9082,
9081,
9106,
9098,
9101,
8978,
9103,
9006,
]

_charnames_43488 = [
7400,
7401,
7399,
7398,
7402,
7424,
7425,
7383,
7395,
7390,
7389,
7387,
7386,
7379,
7378,
7384,
7416,
7417,
7408,
7409,
7414,
7415,
7411,
7412,
7419,
7418,
7394,
7381,
7380,
7393,
7392,
]

_charnames_43744 = [
6523,
6522,
6524,
6517,
6512,
6511,
6521,
6520,
6518,
6515,
6514,
6534,
6533,
6530,
6531,
6529,
6541,
6538,
6537,
6540,
6539,
6532,
6535,
]

_charnames_43777 = [
11973,
11975,
11976,
11972,
11971,
11974,
-1,
-1,
11950,
11952,
11953,
11949,
11948,
11951,
-1,
-1,
11943,
11945,
11946,
11942,
11941,
11944,
]

_charnames_43808 = [
11957,
11959,
11961,
11958,
11956,
11955,
11960,
-1,
11965,
11967,
11969,
11966,
11964,
11963,
11968,
-1,
8976,
9061,
8972,
8975,
9056,
9013,
8961,
9011,
9012,
9010,
9063,
9040,
9055,
8970,
8971,
9002,
9043,
8983,
8984,
8985,
8986,
8965,
9112,
9036,
9057,
9035,
9058,
8959,
8960,
8977,
8994,
8996,
8998,
8990,
8995,
9015,
9017,
9018,
9027,
9023,
9026,
9025,
9062,
7181,
7172,
7169,
7168,
7171,
8966,
9045,
9005,
8997,
9044,
12363,
]

_charnames_43888 = [
7909,
7908,
7907,
7905,
7904,
7903,
7902,
7906,
7901,
7900,
7899,
7898,
7897,
7852,
7851,
7850,
7848,
7847,
7846,
7895,
7894,
7893,
7892,
7891,
7890,
7888,
7887,
7886,
7885,
7884,
7838,
7849,
7839,
7844,
7843,
7842,
7841,
7840,
7881,
7880,
7879,
7878,
7877,
7876,
7836,
7830,
7835,
7834,
7833,
7832,
7831,
7860,
7829,
7859,
7828,
7858,
7827,
7856,
7855,
7854,
7857,
7826,
7825,
7824,
7823,
7822,
7821,
7819,
7818,
7817,
7816,
7815,
7814,
7874,
7873,
7872,
7871,
7870,
7869,
7867,
]

_charnames_64434 = [
4124,
4123,
4114,
4113,
4120,
4119,
4118,
4117,
4131,
4130,
4125,
4112,
4111,
4132,
4128,
4127,
]

_charnames_65063 = [
8119,
8118,
8161,
8160,
8169,
8168,
8138,
8137,
8136,
]

_charnames_66272 = [
8221,
8218,
8210,
8211,
8216,
8217,
8213,
8214,
8220,
8219,
8186,
8182,
8185,
8197,
8200,
8189,
8192,
8205,
8202,
8207,
8181,
8184,
8196,
8199,
8190,
8193,
8206,
8203,
]

_charnames_66384 = [
9991,
9990,
9988,
9966,
9978,
9968,
9965,
9969,
9964,
9959,
9986,
9985,
9984,
9983,
9971,
9982,
9981,
9958,
9975,
9980,
9989,
9956,
9957,
9953,
9948,
9976,
9977,
9979,
9987,
9974,
9972,
9947,
9949,
9951,
9960,
9952,
9950,
9961,
8156,
8155,
8152,
8154,
8153,
]

_charnames_66736 = [
10100,
10101,
10102,
10103,
10134,
10133,
10098,
10091,
10099,
10123,
10122,
10130,
10112,
10097,
10110,
10129,
10128,
10127,
10119,
10120,
10126,
10096,
10118,
10117,
10108,
10095,
10107,
10094,
10106,
10132,
10125,
10124,
10111,
10131,
10115,
10114,
-1,
-1,
-1,
-1,
10055,
10056,
10057,
10058,
10089,
10088,
10053,
10046,
10054,
10078,
10077,
10085,
10067,
10052,
10065,
10084,
10083,
10082,
10074,
10075,
10081,
10051,
10073,
10072,
10063,
10050,
10062,
10049,
10061,
10087,
10080,
10079,
10066,
10086,
10070,
10069,
-1,
-1,
-1,
-1,
11929,
11928,
11915,
11914,
11912,
11882,
11911,
11909,
11908,
11927,
11889,
11888,
11926,
11925,
11924,
11907,
11904,
11903,
11923,
11881,
11883,
11880,
11922,
11921,
11920,
11901,
11900,
11898,
11897,
11895,
11894,
11919,
11918,
11917,
11916,
11892,
11891,
11886,
11887,
11906,
]

_charnames_66864 = [
8314,
8323,
8307,
8274,
8311,
8279,
8310,
8277,
8283,
8253,
8289,
8278,
8286,
8265,
8299,
8287,
8315,
8273,
8262,
8304,
8302,
8298,
8321,
8292,
8313,
8255,
8256,
8258,
8320,
8293,
8319,
8271,
8266,
8305,
8318,
8281,
8322,
8272,
8254,
8296,
8308,
8317,
8268,
8316,
8282,
8267,
8285,
8259,
8261,
8290,
8295,
8301,
]

_charnames_67072 = [
8554,
8553,
8552,
8551,
8550,
8549,
8548,
8547,
8546,
8598,
8597,
8596,
8595,
8594,
8534,
8524,
8526,
8525,
8521,
8523,
8522,
8527,
8528,
8533,
8532,
8531,
8530,
8913,
8529,
8592,
8591,
8590,
8589,
8588,
8587,
8563,
8562,
8561,
8560,
8559,
8558,
8557,
8556,
8544,
8543,
8542,
8541,
8540,
8539,
8538,
8537,
8536,
8585,
8584,
8583,
8582,
8581,
8580,
8571,
8570,
8569,
8568,
8567,
8566,
8565,
8578,
8577,
8576,
8575,
8574,
8573,
8912,
8613,
8603,
8911,
8602,
8601,
8609,
8608,
8910,
8612,
8611,
8606,
8605,
8610,
8732,
8731,
8730,
8729,
8728,
8727,
8726,
8725,
8724,
8723,
8722,
8719,
8718,
8717,
8710,
8709,
8708,
8716,
8715,
8714,
8713,
8712,
8711,
8787,
8786,
8785,
8784,
8783,
8782,
8781,
8780,
8779,
8778,
8776,
8775,
8774,
8773,
8772,
8771,
8770,
8769,
8768,
8767,
8765,
8764,
8763,
8762,
8761,
8760,
8759,
8758,
8757,
8756,
8754,
8753,
8752,
8751,
8750,
8749,
8748,
8747,
8746,
8745,
8743,
8742,
8741,
8740,
8739,
8738,
8737,
8736,
8735,
8734,
8790,
8789,
8889,
8888,
8887,
8886,
8885,
8884,
8883,
8882,
8881,
8880,
8899,
8898,
8897,
8896,
8895,
8894,
8893,
8892,
8891,
8675,
8674,
8673,
8672,
8671,
8670,
8669,
8668,
8704,
8703,
8702,
8701,
8700,
8699,
8666,
8665,
8664,
8663,
8662,
8661,
8660,
8659,
8658,
8656,
8655,
8654,
8653,
8652,
8651,
8650,
8649,
8648,
8683,
8682,
8681,
8680,
8679,
8678,
8677,
8646,
8645,
8644,
8643,
8642,
8641,
8640,
8639,
8638,
8697,
8696,
8695,
8694,
8693,
8692,
8636,
8635,
8634,
8633,
8632,
8631,
8630,
8629,
8628,
8627,
8625,
8624,
8623,
8622,
8621,
8620,
8619,
8618,
8617,
8616,
8690,
8689,
8688,
8687,
8686,
8685,
8840,
8839,
8838,
8837,
8836,
8835,
8834,
8833,
8802,
8801,
8800,
8799,
8798,
8797,
8796,
8795,
8794,
8793,
8822,
8821,
8820,
8819,
8818,
8817,
8816,
8815,
8814,
8850,
8849,
8848,
8831,
8830,
8829,
8828,
8827,
8826,
8825,
8824,
8812,
8811,
8810,
8809,
8808,
8807,
8806,
8805,
8804,
8846,
8845,
8844,
8843,
8842,
]

_charnames_67392 = [
8867,
8866,
8865,
8864,
8863,
8862,
8861,
8860,
8859,
8858,
8857,
8856,
8855,
8875,
8874,
8873,
8872,
8871,
8870,
8869,
8877,
8876,
]

_charnames_67424 = [
8908,
8907,
8906,
8905,
8904,
8903,
8902,
8901,
]

_charnames_67680 = [
9518,
9532,
9529,
9531,
9514,
9521,
9519,
9515,
9512,
9520,
9528,
9527,
9526,
9530,
9525,
9508,
9517,
9524,
9509,
9523,
9522,
9510,
9513,
9533,
9545,
9544,
9537,
9539,
9542,
9543,
9540,
9538,
11024,
11037,
11023,
11050,
11048,
11049,
11022,
11033,
11040,
11038,
11034,
11031,
11016,
11039,
11021,
11047,
11020,
11046,
11019,
11045,
11018,
11044,
11027,
11036,
11043,
11028,
11042,
11041,
11017,
11029,
11032,
]

_charnames_67751 = [
11058,
11054,
11056,
11061,
11063,
11062,
11057,
11055,
11059,
]

_charnames_67808 = [
12157,
12169,
12167,
12168,
12153,
12160,
12158,
12154,
12151,
12159,
12166,
12165,
12164,
12163,
12147,
12156,
12162,
12148,
12161,
-1,
12149,
12152,
-1,
-1,
-1,
-1,
-1,
12174,
12176,
12173,
12172,
12175,
]

_charnames_67968 = [
6505,
6503,
6501,
6498,
6494,
6495,
6492,
6493,
6497,
6499,
6481,
6482,
6479,
6480,
6487,
6488,
6500,
6490,
6502,
6484,
6485,
6486,
6491,
6496,
6475,
6476,
6473,
6474,
6477,
6504,
6506,
6507,
6434,
6446,
6444,
6441,
6436,
6437,
6448,
6440,
6442,
6430,
6429,
6438,
6443,
6432,
6445,
6427,
6435,
6426,
6433,
6439,
6424,
6423,
6422,
6447,
-1,
-1,
-1,
-1,
6467,
6462,
6450,
6451,
6414,
6353,
6361,
6387,
6395,
6371,
6378,
6408,
6402,
6368,
6358,
6366,
6392,
6400,
6376,
6383,
-1,
-1,
6416,
6355,
6363,
6389,
6397,
6373,
6380,
6410,
6404,
6418,
6357,
6365,
6391,
6399,
6375,
6382,
6412,
6406,
6369,
6359,
6367,
6393,
6401,
6377,
6384,
6413,
6407,
6417,
6356,
6364,
6390,
6398,
6374,
6381,
6411,
6405,
6461,
6454,
6455,
6464,
6465,
6458,
6459,
6468,
6469,
6456,
]

_charnames_68224 = [
10012,
10030,
10013,
10029,
10027,
10024,
10003,
10026,
10032,
9999,
10004,
10010,
10028,
10009,
10025,
10002,
10031,
10021,
10022,
10019,
10016,
10018,
10015,
10000,
10006,
9998,
10023,
9997,
10007,
10037,
10036,
10035,
]

_charnames_68288 = [
6583,
6610,
6609,
6603,
6604,
6607,
6600,
6612,
6638,
6587,
6586,
6599,
6598,
6601,
6579,
6611,
6596,
6590,
6595,
6617,
6606,
6578,
6616,
6615,
6573,
6582,
6584,
6614,
6618,
6574,
6592,
6589,
6593,
6613,
6576,
6575,
6580,
6637,
6636,
-1,
-1,
-1,
-1,
6632,
6634,
6631,
6630,
6633,
6625,
6627,
6623,
6622,
6621,
6624,
6626,
]

_charnames_68480 = [
9703,
9702,
9700,
9701,
9689,
9693,
9691,
9690,
9692,
9699,
9698,
9697,
9696,
9686,
9695,
9687,
9688,
9694,
]

_charnames_68521 = [
9711,
9707,
9709,
9713,
9710,
9708,
9712,
]

_charnames_68736 = [
9913,
9917,
9912,
9915,
9888,
9887,
9889,
9911,
9914,
9882,
9934,
9910,
9909,
9901,
9902,
9908,
9931,
9932,
9907,
9906,
9916,
9921,
9899,
9900,
9897,
9883,
9886,
9922,
9923,
9930,
9927,
9924,
9905,
9898,
9904,
9933,
9895,
9896,
9893,
9884,
9894,
9890,
9918,
9919,
9929,
9926,
9903,
9891,
9892,
9885,
9920,
]

_charnames_68800 = [
9859,
9863,
9858,
9861,
9834,
9833,
9835,
9857,
9860,
9828,
9880,
9856,
9855,
9847,
9848,
9854,
9877,
9878,
9853,
9852,
9862,
9867,
9845,
9846,
9843,
9829,
9832,
9868,
9869,
9876,
9873,
9870,
9851,
9844,
9850,
9879,
9841,
9842,
9839,
9830,
9840,
9836,
9864,
9865,
9875,
9872,
9849,
9837,
9838,
9831,
9866,
]

_charnames_69632 = [
5768,
5769,
5765,
5767,
5766,
5660,
5663,
5682,
5683,
5668,
5669,
5633,
5634,
5635,
5636,
5697,
5662,
5644,
5661,
5678,
5677,
5686,
5685,
5652,
5689,
5688,
5681,
5680,
5650,
5641,
5640,
5657,
5656,
5651,
5643,
5642,
5659,
5658,
5653,
5672,
5671,
5692,
5691,
5695,
5693,
5694,
5675,
5637,
5666,
5665,
5667,
5696,
5674,
5648,
5646,
5647,
5738,
5745,
5741,
5742,
5739,
5740,
5731,
5732,
5733,
5734,
5744,
5737,
5743,
5736,
5746,
5763,
5762,
5776,
5775,
5773,
5777,
5772,
-1,
-1,
-1,
-1,
5719,
5701,
5704,
5714,
5717,
5708,
5710,
5725,
5723,
5706,
5702,
5705,
5715,
5718,
5709,
5711,
5726,
5724,
5722,
5721,
5758,
5759,
5750,
5751,
5756,
5757,
5753,
5754,
5761,
5760,
]

_charnames_69840 = [
2999,
2998,
3011,
3010,
3009,
3008,
2990,
2987,
3003,
2988,
2996,
3001,
2995,
3000,
3007,
3004,
3005,
2986,
3012,
2994,
3006,
2997,
3002,
2993,
2991,
]

_charnames_69872 = [
3023,
3024,
3015,
3016,
3021,
3022,
3018,
3019,
3026,
3025,
-1,
-1,
-1,
-1,
-1,
-1,
8004,
8005,
8003,
7970,
7967,
7962,
7969,
7948,
7947,
7954,
7953,
7932,
7957,
7956,
7951,
7950,
7930,
7926,
7925,
7937,
7936,
7931,
7928,
7927,
7939,
7938,
7933,
7945,
7944,
7960,
7959,
7965,
7941,
7942,
7964,
7966,
7961,
7963,
7968,
7990,
7997,
7998,
7993,
7994,
7999,
7992,
7995,
7991,
7996,
8008,
8010,
8000,
8009,
-1,
7982,
7983,
7974,
7975,
7980,
7981,
7977,
7978,
7985,
7984,
8006,
7987,
7986,
8007,
]

_charnames_69968 = [
6827,
6824,
6819,
6826,
6821,
6805,
6804,
6811,
6810,
6814,
6813,
6808,
6807,
6794,
6784,
6783,
6790,
6789,
6795,
6786,
6785,
6792,
6791,
6796,
6802,
6801,
6817,
6816,
6822,
6799,
6823,
6818,
6820,
6825,
6798,
6830,
6832,
6831,
6828,
]

_charnames_70016 = [
2825,
2820,
2816,
2756,
2759,
2778,
2779,
2764,
2765,
2734,
2735,
2736,
2737,
2794,
2758,
2791,
2757,
2774,
2773,
2782,
2781,
2748,
2785,
2784,
2777,
2776,
2746,
2742,
2741,
2753,
2752,
2747,
2744,
2743,
2755,
2754,
2749,
2768,
2767,
2788,
2787,
2792,
2789,
2790,
2771,
2770,
2738,
2762,
2761,
2763,
2793,
2805,
2808,
2809,
2806,
2807,
2798,
2799,
2800,
2801,
2811,
2804,
2810,
2803,
2817,
2819,
2824,
2821,
2853,
2849,
2848,
2856,
2830,
2832,
2823,
2812,
2851,
2831,
-1,
-1,
2844,
2845,
2836,
2837,
2842,
2843,
2839,
2840,
2847,
2846,
2852,
2822,
2854,
2855,
2829,
2828,
-1,
2691,
2683,
2684,
2689,
2690,
2686,
2687,
2693,
2692,
2669,
2667,
2668,
2677,
2678,
2671,
2672,
2680,
2679,
2675,
2674,
]

_charnames_70144 = [
11238,
11241,
11272,
11267,
11274,
11240,
11270,
11239,
11258,
11257,
11245,
11244,
11243,
11236,
11264,
11263,
11261,
11260,
-1,
11234,
11230,
11229,
11224,
11222,
11235,
11232,
11231,
11226,
11223,
11225,
11237,
11252,
11251,
11249,
11248,
11247,
11271,
11265,
11269,
11255,
11266,
11268,
11273,
11254,
11279,
11280,
11281,
11282,
11284,
11278,
11283,
11277,
11292,
11290,
11291,
11289,
11298,
11297,
11299,
11293,
11296,
11300,
11288,
]

_charnames_70272 = [
7289,
7286,
7282,
7288,
7267,
7266,
7273,
-1,
7272,
-1,
7276,
7275,
7270,
7269,
-1,
7259,
7251,
7250,
7245,
7244,
7243,
7260,
7253,
7252,
7247,
7246,
7261,
7264,
7263,
7279,
-1,
7278,
7284,
7280,
7257,
7285,
7281,
7283,
7287,
7255,
7256,
7290,
-1,
-1,
-1,
-1,
-1,
-1,
11147,
11150,
11177,
11178,
11163,
11164,
11188,
11149,
11184,
11148,
11176,
11175,
11158,
11157,
11156,
11145,
11181,
11180,
11154,
11152,
11153,
11143,
11139,
11138,
11133,
11132,
11169,
11131,
11144,
11141,
11140,
11135,
11134,
11146,
11173,
11172,
11162,
11161,
11160,
11185,
11182,
11170,
11186,
11183,
11166,
11167,
11187,
11217,
11207,
11210,
11211,
11208,
11209,
11213,
11206,
11212,
11205,
11216,
11215,
-1,
-1,
-1,
-1,
-1,
11199,
11200,
11191,
11192,
11197,
11198,
11194,
11195,
11202,
11201,
-1,
-1,
-1,
-1,
-1,
-1,
12346,
12347,
12350,
12343,
-1,
12286,
12289,
12308,
12309,
12294,
12295,
12261,
12263,
-1,
-1,
12324,
12288,
-1,
-1,
12321,
12287,
12304,
12303,
12312,
12311,
12278,
12315,
12314,
12307,
12306,
12276,
12272,
12271,
12283,
12282,
12277,
12274,
12273,
12285,
12284,
12279,
-1,
12298,
12297,
12318,
12317,
12322,
12319,
12320,
-1,
12301,
12300,
-1,
12268,
12292,
12291,
12293,
12323,
-1,
-1,
12352,
12349,
12334,
12337,
12338,
12335,
12336,
12327,
12328,
-1,
-1,
12340,
12333,
-1,
-1,
12339,
12332,
12344,
-1,
-1,
12353,
-1,
-1,
-1,
-1,
-1,
-1,
12354,
-1,
-1,
-1,
-1,
-1,
12351,
12267,
12266,
12262,
12264,
12329,
12330,
-1,
-1,
8088,
8090,
8083,
8084,
8086,
8087,
8089,
-1,
-1,
-1,
8096,
8095,
8094,
8092,
8093,
]

_charnames_70656 = [
10849,
10852,
10877,
10878,
10857,
10858,
10833,
10834,
10835,
10836,
10892,
10851,
10890,
10850,
10873,
10872,
10881,
10880,
10828,
10827,
10884,
10883,
10876,
10875,
10825,
10824,
10840,
10839,
10846,
10845,
10829,
10842,
10841,
10848,
10847,
10831,
10830,
10864,
10863,
10887,
10886,
10867,
10866,
10888,
10861,
10860,
10870,
10869,
10889,
10855,
10854,
10856,
10891,
10902,
10905,
10906,
10903,
10904,
10895,
10896,
10897,
10898,
10908,
10901,
10907,
10900,
10930,
10936,
10933,
10929,
10934,
10932,
10935,
10939,
10937,
10925,
10924,
10942,
10941,
10943,
10920,
10921,
10912,
10913,
10918,
10919,
10915,
10916,
10923,
10922,
-1,
10938,
-1,
10940,
]

_charnames_70784 = [
1390,
1310,
1313,
1329,
1330,
1318,
1319,
1288,
1289,
1290,
1291,
1346,
1312,
1342,
1311,
1325,
1324,
1333,
1332,
1302,
1336,
1335,
1328,
1327,
1300,
1296,
1295,
1307,
1306,
1301,
1298,
1297,
1309,
1308,
1303,
1322,
1321,
1339,
1338,
1343,
1340,
1341,
1344,
1292,
1316,
1315,
1317,
1345,
1356,
1362,
1363,
1357,
1358,
1349,
1350,
1351,
1352,
1365,
1361,
1355,
1364,
1360,
1354,
1388,
1386,
1382,
1383,
1387,
1385,
1393,
1391,
1392,
]

_charnames_70864 = [
1376,
1377,
1368,
1369,
1374,
1375,
1371,
1372,
1379,
1378,
]

_charnames_71040 = [
2546,
2550,
2577,
2578,
2566,
2567,
2541,
2542,
2543,
2544,
2594,
2549,
2590,
2547,
2573,
2572,
2581,
2580,
2554,
2584,
2583,
2576,
2575,
2552,
2534,
2533,
2559,
2558,
2553,
2538,
2537,
2561,
2560,
2555,
2570,
2569,
2587,
2586,
2591,
2588,
2589,
2592,
2545,
2564,
2563,
2565,
2593,
2634,
2639,
2640,
2637,
2638,
2635,
2636,
-1,
-1,
2642,
2633,
2641,
2632,
2626,
2627,
2622,
2623,
2625,
2624,
2649,
2648,
2618,
2619,
2646,
2645,
2644,
2650,
2601,
2602,
2607,
2606,
2605,
2615,
2616,
2614,
2603,
2613,
2612,
2610,
2609,
2611,
2536,
2530,
2531,
2548,
2630,
2631,
]

_charnames_71168 = [
7082,
7085,
7104,
7105,
7090,
7091,
7060,
7061,
7062,
7063,
7120,
7084,
7117,
7083,
7100,
7099,
7108,
7107,
7074,
7111,
7110,
7103,
7102,
7072,
7068,
7067,
7079,
7078,
7073,
7070,
7069,
7081,
7080,
7075,
7094,
7093,
7114,
7113,
7118,
7115,
7116,
7097,
7064,
7088,
7087,
7089,
7119,
7096,
7130,
7133,
7134,
7131,
7132,
7123,
7124,
7125,
7126,
7136,
7129,
7135,
7128,
7160,
7156,
7157,
7159,
7153,
7152,
7162,
7161,
]

_charnames_71248 = [
7148,
7149,
7140,
7141,
7146,
7147,
7143,
7144,
7151,
7150,
-1,
-1,
-1,
-1,
-1,
-1,
7199,
7189,
7201,
7195,
7200,
7191,
7192,
7196,
7197,
7185,
7187,
7188,
7194,
]

_charnames_71296 = [
1207,
1210,
1228,
1229,
1211,
1212,
1245,
1209,
1241,
1208,
1224,
1223,
1232,
1231,
1199,
1235,
1234,
1227,
1226,
1197,
1193,
1192,
1204,
1203,
1198,
1195,
1194,
1206,
1205,
1200,
1221,
1220,
1238,
1237,
1242,
1239,
1218,
1243,
1240,
1214,
1215,
1244,
1217,
1276,
1273,
1264,
1267,
1268,
1265,
1266,
1270,
1263,
1269,
1262,
1274,
1275,
]

_charnames_71360 = [
1256,
1257,
1248,
1249,
1254,
1255,
1251,
1252,
1259,
1258,
]

_charnames_71424 = [
4556,
4555,
4542,
4543,
4550,
4546,
4553,
4552,
4568,
4571,
4559,
4574,
4549,
4570,
4572,
4569,
4541,
4573,
4544,
4565,
4564,
4562,
4547,
4561,
4567,
4558,
-1,
-1,
-1,
4612,
4613,
4611,
4576,
4580,
4583,
4584,
4581,
4582,
4586,
4577,
4585,
4579,
4578,
4607,
-1,
-1,
-1,
-1,
4597,
4598,
4589,
4590,
4595,
4596,
4592,
4593,
4600,
4599,
4616,
4615,
4604,
4605,
4606,
4608,
]

_charnames_71840 = [
11470,
11452,
11471,
11442,
11445,
11444,
11476,
11461,
11456,
11466,
11454,
11477,
11475,
11458,
11443,
11462,
11459,
11467,
11473,
11469,
11478,
11453,
11455,
11479,
11474,
11450,
11449,
11448,
11451,
11464,
11465,
11472,
11430,
11412,
11431,
11402,
11405,
11404,
11436,
11421,
11416,
11426,
11414,
11437,
11435,
11418,
11403,
11422,
11419,
11427,
11433,
11429,
11438,
11413,
11415,
11439,
11434,
11410,
11409,
11408,
11411,
11424,
11425,
11432,
11490,
11491,
11482,
11483,
11488,
11489,
11485,
11486,
11493,
11492,
11498,
11496,
11497,
11503,
11504,
11500,
11501,
11506,
11505,
]

_charnames_72384 = [
9451,
9457,
9469,
9468,
9473,
9463,
9464,
9453,
9470,
9471,
9456,
9465,
9474,
9462,
9448,
9447,
9454,
9450,
9466,
9443,
9461,
9475,
9472,
9458,
9467,
9444,
9445,
9459,
9439,
9442,
9438,
9440,
9434,
9441,
9437,
9435,
9436,
9491,
9489,
9487,
9492,
9493,
9488,
9484,
9482,
9485,
9486,
9494,
9500,
9496,
9497,
9478,
9476,
9498,
9479,
9480,
9501,
]

_charnames_72704 = [
5812,
5815,
5831,
5832,
5820,
5821,
5791,
5792,
5793,
-1,
5848,
5814,
5844,
5813,
5827,
5826,
5835,
5834,
5804,
5838,
5837,
5830,
5829,
5802,
5798,
5797,
5809,
5808,
5803,
5800,
5799,
5811,
5810,
5805,
5824,
5823,
5841,
5840,
5845,
5842,
5843,
5846,
5794,
5818,
5817,
5819,
5847,
5883,
5886,
5887,
5884,
5885,
5877,
5878,
5879,
-1,
5889,
5882,
5888,
5881,
5914,
5913,
5909,
5910,
5912,
5906,
5905,
5918,
5917,
5916,
]

_charnames_72784 = [
5901,
5902,
5893,
5894,
5899,
5900,
5896,
5897,
5904,
5903,
5874,
5852,
5855,
5865,
5868,
5859,
5861,
5872,
5870,
5857,
5853,
5856,
5866,
5869,
5860,
5862,
5873,
5871,
5919,
-1,
-1,
-1,
6776,
6775,
6751,
6750,
6765,
6738,
6757,
6756,
6763,
6737,
6735,
6734,
6754,
6739,
6748,
6747,
6766,
6761,
6733,
6732,
6753,
6759,
6741,
6742,
6768,
6758,
6760,
6762,
6744,
6745,
6764,
6767,
-1,
-1,
6709,
6708,
6723,
6696,
6715,
6714,
6721,
6695,
6693,
6692,
6712,
6697,
6706,
6705,
6724,
6719,
6691,
6690,
6711,
6717,
6699,
6700,
-1,
6716,
6718,
6720,
6702,
6703,
6722,
6725,
6774,
6772,
6770,
6773,
6771,
6728,
6727,
]

_charnames_74607 = [
7681,
7738,
7741,
7742,
7596,
7597,
7591,
7584,
7697,
7696,
7621,
7620,
7638,
7635,
7772,
7673,
7672,
7670,
7669,
7679,
7677,
7676,
7675,
7674,
7666,
7531,
7541,
7539,
7537,
7751,
7749,
7661,
7640,
7656,
7655,
7646,
7659,
7777,
7776,
7719,
7764,
7733,
7734,
]

_charnames_74851 = [
7791,
7792,
7785,
7784,
7782,
7783,
7794,
7795,
7788,
7789,
7786,
7796,
-1,
-1,
-1,
-1,
-1,
7797,
]

_charnames_74880 = [
7739,
7740,
7743,
7758,
7757,
7756,
7755,
7759,
7598,
7595,
7589,
7588,
7590,
7570,
7568,
7569,
7579,
7578,
7583,
7562,
7559,
7561,
7560,
7576,
7575,
7582,
7557,
7556,
7554,
7555,
7550,
7548,
7549,
7551,
7566,
7565,
7564,
7581,
7580,
7573,
7572,
7700,
7699,
7702,
7701,
7692,
7691,
7690,
7687,
7688,
7685,
7686,
7689,
7695,
7628,
7618,
7617,
7616,
7627,
7610,
7613,
7612,
7626,
7625,
7607,
7608,
7609,
7624,
7602,
7605,
7604,
7623,
7622,
7629,
7637,
7634,
7632,
7631,
7774,
7773,
7680,
7678,
7667,
7665,
7530,
7500,
7495,
7494,
7499,
7492,
7491,
7498,
7497,
7489,
7488,
7496,
7527,
7526,
7511,
7510,
7505,
7504,
7503,
7512,
7508,
7507,
7517,
7516,
7515,
7520,
7519,
7521,
7475,
7467,
7474,
7473,
7471,
7470,
7472,
7483,
7482,
7485,
7484,
7480,
7479,
7478,
7477,
7528,
7464,
7437,
7450,
7449,
7448,
7447,
7446,
7445,
7444,
7442,
7441,
7440,
7463,
7451,
7462,
7461,
7456,
7457,
7460,
7459,
7458,
7455,
7454,
7524,
7523,
7542,
7540,
7538,
7534,
7535,
7536,
7750,
7748,
7747,
7654,
7647,
7648,
7653,
7652,
7651,
7650,
7649,
7642,
7644,
7643,
7721,
7720,
7718,
7717,
7714,
7710,
7709,
7708,
7707,
7713,
7712,
7722,
7765,
7763,
7762,
7732,
7731,
7729,
7728,
7727,
7770,
7769,
7768,
]

_charnames_82944 = [
3753,
3752,
3751,
3750,
3749,
3748,
3747,
3746,
3745,
3700,
3701,
3710,
3709,
3708,
3707,
3706,
3705,
3704,
3703,
3702,
3698,
3697,
3696,
3695,
3694,
3693,
3688,
3689,
3692,
3691,
3690,
3686,
3685,
3684,
3683,
3682,
3681,
3680,
3679,
3678,
3676,
3677,
3647,
3639,
3640,
3646,
3645,
3644,
3637,
3638,
3634,
3636,
3635,
3643,
3642,
3641,
3743,
3742,
3741,
3740,
3739,
3738,
3737,
3736,
3735,
3734,
3661,
3660,
3659,
3658,
3657,
3656,
3649,
3652,
3651,
3650,
3655,
3654,
3653,
3732,
3731,
3730,
3729,
3728,
3727,
3726,
3725,
3724,
3723,
3721,
3720,
3719,
3718,
3717,
3716,
3715,
3714,
3713,
3712,
3674,
3673,
3672,
3671,
3670,
3669,
3668,
3665,
3666,
3663,
3664,
3667,
3273,
3274,
3271,
3272,
3269,
3270,
3278,
3262,
3265,
3264,
3263,
3266,
3268,
3267,
3277,
3258,
3261,
3260,
3259,
3276,
3275,
3280,
3282,
3281,
3292,
3291,
3290,
3289,
3283,
3284,
3288,
3287,
3286,
3285,
3316,
3315,
3314,
3313,
3312,
3306,
3307,
3311,
3310,
3309,
3308,
3304,
3303,
3302,
3301,
3300,
3294,
3295,
3299,
3298,
3297,
3296,
3382,
3381,
3380,
3379,
3378,
3377,
3376,
3375,
3374,
3373,
3371,
3370,
3369,
3368,
3367,
3366,
3365,
3364,
3363,
3362,
3360,
3359,
3358,
3357,
3356,
3355,
3354,
3353,
3352,
3351,
3349,
3348,
3347,
3346,
3345,
3344,
3343,
3342,
3341,
3340,
3338,
3337,
3336,
3335,
3334,
3333,
3332,
3331,
3330,
3329,
3327,
3326,
3325,
3324,
3323,
3322,
3321,
3320,
3319,
3318,
3525,
3524,
3512,
3514,
3513,
3523,
3522,
3521,
3520,
3517,
3518,
3519,
3515,
3516,
3551,
3550,
3549,
3548,
3547,
3542,
3543,
3540,
3541,
3546,
3545,
3544,
3587,
3586,
3585,
3584,
3583,
3582,
3581,
3577,
3578,
3580,
3579,
3631,
3630,
3629,
3628,
3627,
3626,
3625,
3624,
3623,
3622,
3620,
3619,
3618,
3617,
3616,
3615,
3614,
3613,
3612,
3611,
3609,
3608,
3607,
3606,
3605,
3604,
3603,
3602,
3601,
3600,
3575,
3574,
3573,
3572,
3571,
3570,
3569,
3565,
3566,
3568,
3567,
3598,
3597,
3596,
3595,
3594,
3593,
3592,
3591,
3590,
3589,
3563,
3562,
3561,
3560,
3559,
3558,
3557,
3556,
3555,
3553,
3554,
3538,
3537,
3536,
3535,
3529,
3530,
3534,
3533,
3532,
3531,
3527,
3528,
3476,
3475,
3474,
3473,
3472,
3471,
3470,
3469,
3468,
3466,
3467,
3509,
3508,
3507,
3506,
3505,
3504,
3503,
3502,
3501,
3500,
3464,
3463,
3462,
3461,
3460,
3459,
3458,
3457,
3456,
3454,
3455,
3400,
3399,
3392,
3391,
3390,
3398,
3397,
3396,
3385,
3388,
3387,
3386,
3395,
3394,
3393,
3498,
3497,
3496,
3495,
3494,
3493,
3492,
3491,
3490,
3489,
3452,
3451,
3450,
3449,
3448,
3447,
3446,
3445,
3444,
3442,
3443,
3428,
3427,
3426,
3425,
3419,
3420,
3424,
3423,
3422,
3417,
3418,
3421,
3440,
3430,
3431,
3439,
3438,
3437,
3436,
3435,
3434,
3433,
3432,
3415,
3407,
3408,
3414,
3406,
3405,
3413,
3412,
3402,
3403,
3411,
3410,
3409,
3487,
3486,
3485,
3484,
3483,
3482,
3481,
3480,
3479,
3478,
3857,
3856,
3855,
3854,
3853,
3852,
3851,
3850,
3849,
3848,
3771,
3770,
3780,
3779,
3778,
3777,
3776,
3775,
3774,
3773,
3772,
3846,
3845,
3844,
3843,
3842,
3841,
3840,
3839,
3838,
3837,
3835,
3834,
3833,
3832,
3831,
3830,
3829,
3828,
3827,
3826,
3824,
3823,
3822,
3821,
3820,
3819,
3818,
3817,
3816,
3815,
3758,
3759,
3767,
3766,
3765,
3764,
3763,
3762,
3756,
3757,
3761,
3760,
3813,
3812,
3811,
3810,
3809,
3808,
3807,
3806,
3805,
3804,
3802,
3801,
3800,
3799,
3798,
3797,
3796,
3795,
3794,
3793,
3791,
3790,
3789,
3788,
3787,
3786,
3785,
3784,
3783,
3782,
3866,
3865,
3864,
3863,
3862,
3861,
3860,
3859,
3899,
3898,
3897,
3896,
3895,
3894,
3893,
3892,
3891,
3889,
3888,
3887,
3886,
3885,
3884,
3883,
3882,
3881,
3880,
3878,
3877,
3876,
3875,
3874,
3873,
3872,
3871,
3870,
3869,
3900,
]

_charnames_92160 = [
5191,
5299,
5268,
5269,
5212,
5243,
5288,
5200,
5246,
5265,
5266,
5222,
5284,
5193,
5220,
5227,
5236,
5254,
5187,
5274,
5205,
5252,
5190,
5294,
5293,
5186,
5225,
5260,
5297,
5261,
5232,
5199,
5302,
5298,
5185,
5253,
5237,
5238,
5230,
5278,
5262,
5209,
5271,
5221,
5214,
5270,
5283,
5291,
5251,
5286,
5224,
5275,
5208,
5279,
5231,
5242,
5292,
5305,
5304,
5280,
5250,
5226,
5245,
5183,
5247,
5196,
5258,
5206,
5301,
5192,
5223,
5213,
5235,
5197,
5287,
5249,
5259,
5202,
5219,
5195,
5277,
5203,
5303,
5290,
5215,
5211,
5234,
5339,
5374,
5348,
5349,
5369,
5311,
5358,
5377,
5310,
5359,
5363,
5378,
5367,
5341,
5342,
5380,
5362,
5373,
5346,
5345,
5320,
5313,
5336,
5354,
5381,
5353,
5368,
5364,
5386,
5334,
5331,
5385,
5350,
5375,
5324,
5329,
5330,
5321,
5347,
5314,
5325,
5337,
5361,
5323,
5383,
5312,
5384,
5355,
5318,
5317,
5370,
5332,
5340,
5315,
5357,
5333,
5044,
5081,
5135,
5173,
5042,
5059,
5045,
5168,
5093,
5170,
5085,
5077,
5091,
5163,
5063,
5100,
5119,
5169,
5122,
5136,
5080,
5103,
5054,
5095,
5137,
5130,
5131,
5152,
5064,
5146,
5072,
5142,
5154,
5041,
5175,
5084,
5111,
5078,
5038,
5157,
5096,
5114,
5075,
5144,
5039,
5178,
5058,
5055,
5053,
5179,
5176,
5092,
5177,
5071,
5158,
5141,
5050,
5068,
5126,
5037,
5107,
5104,
5159,
5128,
5070,
5046,
5172,
5040,
5052,
5076,
5129,
5051,
5062,
5110,
5138,
5061,
5149,
5153,
5094,
5108,
5101,
5120,
5090,
5121,
5099,
5134,
5067,
5113,
5112,
5150,
5124,
5125,
5047,
5083,
5160,
5164,
5165,
5145,
4939,
5026,
4886,
4922,
4887,
5000,
4889,
4899,
4880,
4905,
5025,
4874,
4952,
4876,
4971,
4982,
4951,
4892,
4958,
4972,
5017,
4975,
4962,
4924,
4908,
4941,
4933,
4964,
5016,
4890,
4969,
4871,
4986,
5029,
4873,
5031,
4909,
4928,
4995,
4910,
4945,
4930,
5003,
4929,
4921,
4998,
4896,
4937,
4978,
4904,
4984,
4963,
5015,
4970,
5023,
4985,
4872,
4925,
4895,
4968,
5008,
5006,
4902,
4996,
4879,
4926,
4882,
5014,
5009,
5013,
4911,
4914,
4959,
4976,
4884,
4875,
4987,
4934,
4974,
4900,
4983,
4942,
4881,
4994,
4883,
4898,
4891,
5028,
4973,
5020,
4990,
4988,
4903,
5022,
4997,
4935,
4919,
4957,
4944,
4955,
4950,
4977,
4917,
4953,
4915,
5007,
4918,
4954,
5004,
4943,
4999,
5021,
4989,
4916,
4938,
4961,
5032,
4676,
4760,
4740,
4805,
4862,
4800,
4712,
4794,
4849,
4689,
4680,
4708,
4752,
4653,
4819,
4855,
4792,
4662,
4713,
4759,
4812,
4802,
4691,
4668,
4731,
4651,
4667,
4690,
4851,
4685,
4725,
4795,
4657,
4738,
4838,
4652,
4686,
4733,
4799,
4663,
4678,
4753,
4791,
4709,
4674,
4659,
4782,
4839,
4757,
4773,
4726,
4756,
4817,
4793,
4764,
4860,
4857,
4806,
4705,
4750,
4843,
4669,
4789,
4737,
4741,
4694,
4703,
4846,
4755,
4813,
4783,
4696,
4781,
4745,
4679,
4720,
4770,
4808,
4828,
4845,
4648,
4818,
4730,
4654,
4841,
4830,
4699,
4724,
4776,
4661,
4697,
4693,
4727,
4735,
4829,
4702,
4743,
4840,
4826,
4742,
4707,
4649,
4811,
4719,
4700,
4774,
4658,
4716,
4827,
4832,
4683,
4865,
4761,
4863,
4864,
4804,
4715,
4749,
4751,
4675,
4788,
4775,
4664,
4771,
4778,
4779,
4768,
4769,
4816,
4723,
4684,
4710,
4856,
4833,
4861,
4807,
4734,
4852,
4850,
4665,
4670,
4786,
4787,
4825,
4701,
4717,
4801,
4820,
4746,
4729,
4732,
4763,
4821,
4744,
4765,
4831,
4842,
5419,
5457,
5416,
5459,
5424,
5438,
5397,
5449,
5426,
5427,
5434,
5439,
5401,
5393,
5429,
5407,
5406,
5408,
5409,
5415,
5413,
5390,
5389,
5392,
5451,
5404,
5452,
5399,
5443,
5398,
5454,
5444,
5428,
5400,
5422,
5414,
5395,
5396,
5405,
5445,
5458,
5455,
5448,
5447,
5418,
5431,
5423,
5435,
5433,
5432,
5440,
5417,
5410,
5456,
]

_charnames_92736 = [
7321,
7337,
7350,
7339,
7354,
7348,
7355,
7333,
7327,
7344,
7349,
7353,
7328,
7324,
7340,
7336,
7334,
7323,
7322,
7330,
7352,
7319,
7347,
7351,
7346,
7326,
7342,
7341,
7345,
7331,
7320,
-1,
7367,
7368,
7359,
7360,
7365,
7366,
7362,
7363,
7370,
7369,
-1,
-1,
-1,
-1,
7372,
7371,
]

_charnames_92880 = [
5538,
5551,
5561,
5567,
5563,
5541,
5554,
5557,
5550,
5564,
5566,
5543,
5558,
5553,
5556,
5568,
5546,
5560,
5569,
5559,
5542,
5562,
5544,
5570,
5547,
5548,
5545,
5539,
5537,
5565,
-1,
-1,
5577,
5574,
5578,
5573,
5576,
5579,
]

_charnames_92928 = [
9386,
9385,
9382,
9381,
9356,
9355,
9370,
9369,
9388,
9387,
9359,
9358,
9374,
9373,
9353,
9352,
9368,
9367,
9376,
9375,
9380,
9379,
9364,
9363,
9391,
9390,
9362,
9361,
9264,
9249,
9269,
9258,
9251,
9265,
9252,
9266,
9262,
9257,
9268,
9260,
9253,
9256,
9267,
9250,
9254,
9270,
9263,
9261,
9420,
9424,
9427,
9426,
9423,
9428,
9421,
9323,
9325,
9306,
9324,
9329,
9315,
9314,
9313,
9316,
9326,
9337,
9327,
9347,
9319,
9303,
]

_charnames_93008 = [
9402,
9403,
9394,
9395,
9400,
9401,
9397,
9398,
9405,
9404,
-1,
9412,
9415,
9410,
9417,
9416,
9411,
9413,
-1,
9328,
9317,
9344,
9332,
9345,
9343,
9341,
9318,
9340,
9348,
9331,
9336,
9333,
9346,
9338,
9309,
9305,
9301,
9302,
9307,
9308,
-1,
-1,
-1,
-1,
-1,
9275,
9283,
9289,
9290,
9294,
9280,
9292,
9296,
9277,
9276,
9295,
9281,
9293,
9287,
9297,
9284,
9274,
9279,
9286,
]

_charnames_93952 = [
6973,
6984,
6919,
6972,
6976,
6975,
6948,
6983,
6967,
6966,
6886,
6941,
6917,
6918,
6885,
6940,
6897,
6899,
6920,
6946,
6893,
6892,
6955,
6954,
6953,
6952,
6884,
6939,
6883,
6938,
6982,
6964,
6921,
6970,
6969,
6896,
6895,
6945,
6979,
6980,
6963,
6962,
6879,
6934,
6890,
6889,
6880,
6935,
6915,
6922,
6931,
6958,
6957,
6910,
6908,
6881,
6936,
6916,
6959,
6911,
6909,
6906,
6904,
6947,
6905,
6903,
6981,
6949,
6978,
]

_charnames_94032 = [
6898,
7038,
7036,
7037,
6995,
7003,
7002,
6996,
6997,
7017,
7019,
7024,
7023,
7011,
7014,
7015,
7020,
6986,
6987,
6988,
6989,
6991,
6994,
6993,
6990,
6992,
7004,
7005,
7006,
7007,
7008,
7010,
7009,
7021,
7022,
6998,
6999,
7013,
7026,
7012,
7025,
7001,
7016,
7000,
7018,
7027,
7028,
]

_charnames_94095 = [
7031,
7030,
7033,
7032,
6877,
6876,
6875,
6874,
6873,
6872,
6871,
6930,
6929,
6928,
6927,
6926,
6925,
]

_charnames_100352 = [
781,
780,
779,
778,
777,
776,
775,
774,
773,
771,
770,
769,
768,
767,
766,
765,
764,
763,
762,
760,
759,
758,
757,
756,
755,
754,
753,
752,
751,
749,
748,
747,
746,
745,
744,
743,
742,
741,
740,
738,
737,
736,
735,
734,
733,
732,
731,
730,
729,
727,
726,
725,
724,
723,
722,
721,
720,
719,
718,
716,
715,
714,
713,
712,
711,
710,
709,
708,
707,
705,
704,
703,
702,
701,
700,
699,
698,
697,
696,
694,
693,
692,
691,
690,
689,
688,
687,
686,
685,
683,
682,
681,
680,
679,
678,
677,
676,
675,
674,
671,
670,
669,
668,
667,
666,
665,
664,
663,
662,
660,
659,
658,
657,
656,
655,
654,
653,
652,
651,
649,
648,
647,
646,
645,
644,
643,
642,
641,
640,
638,
637,
636,
635,
634,
633,
632,
631,
630,
629,
627,
626,
625,
624,
623,
622,
621,
620,
619,
618,
616,
615,
614,
613,
612,
611,
610,
609,
608,
607,
605,
604,
603,
602,
601,
600,
599,
598,
597,
596,
594,
593,
592,
591,
590,
589,
588,
587,
586,
585,
583,
582,
581,
580,
579,
578,
577,
576,
575,
574,
572,
571,
570,
569,
568,
567,
566,
565,
564,
563,
560,
559,
558,
557,
556,
555,
554,
553,
552,
551,
549,
548,
547,
546,
545,
544,
543,
542,
541,
540,
538,
537,
536,
535,
534,
533,
532,
531,
530,
529,
527,
526,
525,
524,
523,
522,
521,
520,
519,
518,
516,
515,
514,
513,
512,
511,
510,
509,
508,
507,
505,
504,
503,
502,
501,
500,
499,
498,
497,
496,
494,
493,
492,
491,
490,
489,
488,
487,
486,
485,
483,
482,
481,
480,
479,
478,
477,
476,
475,
474,
472,
471,
470,
469,
468,
467,
466,
465,
464,
463,
461,
460,
459,
458,
457,
456,
455,
454,
453,
452,
449,
448,
447,
446,
445,
444,
443,
442,
441,
440,
438,
437,
436,
435,
434,
433,
432,
431,
430,
429,
427,
426,
425,
424,
423,
422,
421,
420,
419,
418,
416,
415,
414,
413,
412,
411,
410,
409,
408,
407,
405,
404,
403,
402,
401,
400,
399,
398,
397,
396,
394,
393,
392,
391,
390,
389,
388,
387,
386,
385,
383,
382,
381,
380,
379,
378,
377,
376,
375,
374,
372,
371,
370,
369,
368,
367,
366,
365,
364,
363,
361,
360,
359,
358,
357,
356,
355,
354,
353,
352,
350,
349,
348,
347,
346,
345,
344,
343,
342,
341,
338,
337,
336,
335,
334,
333,
332,
331,
330,
329,
327,
326,
325,
324,
323,
322,
321,
320,
319,
318,
316,
315,
314,
313,
312,
311,
310,
309,
308,
307,
305,
304,
303,
302,
301,
300,
299,
298,
297,
296,
294,
293,
292,
291,
290,
289,
288,
287,
286,
285,
283,
282,
281,
280,
279,
278,
277,
276,
275,
274,
272,
271,
270,
269,
268,
267,
266,
265,
264,
263,
261,
260,
259,
258,
257,
256,
255,
254,
253,
252,
250,
249,
248,
247,
246,
245,
244,
243,
242,
241,
239,
238,
237,
236,
235,
234,
233,
232,
231,
230,
227,
226,
225,
224,
223,
222,
221,
220,
219,
218,
216,
215,
214,
213,
212,
211,
210,
209,
208,
207,
205,
204,
203,
202,
201,
200,
199,
198,
197,
196,
194,
193,
192,
191,
190,
189,
188,
187,
186,
185,
183,
182,
181,
180,
179,
178,
177,
176,
175,
174,
172,
171,
170,
169,
168,
167,
166,
165,
164,
163,
161,
160,
159,
158,
157,
156,
155,
154,
153,
152,
150,
149,
148,
147,
146,
145,
144,
143,
142,
141,
139,
138,
137,
136,
135,
134,
133,
132,
131,
130,
128,
127,
126,
125,
124,
123,
122,
121,
120,
119,
116,
115,
114,
113,
112,
111,
110,
109,
108,
107,
105,
104,
103,
102,
101,
100,
99,
98,
97,
96,
94,
93,
92,
91,
90,
89,
88,
87,
86,
85,
83,
82,
81,
80,
79,
78,
77,
76,
75,
74,
72,
71,
70,
69,
68,
67,
66,
65,
64,
63,
61,
60,
59,
58,
57,
56,
55,
54,
53,
52,
50,
49,
48,
47,
46,
45,
44,
43,
42,
41,
39,
38,
37,
36,
35,
34,
33,
32,
31,
30,
28,
27,
26,
25,
24,
23,
22,
21,
20,
19,
17,
16,
15,
14,
13,
12,
11,
10,
9,
8,
837,
836,
835,
834,
833,
832,
831,
830,
829,
828,
826,
825,
824,
823,
822,
821,
820,
819,
818,
817,
815,
814,
813,
812,
811,
810,
809,
808,
807,
806,
804,
803,
802,
801,
800,
799,
798,
797,
796,
795,
793,
792,
791,
790,
789,
788,
787,
786,
785,
784,
844,
843,
842,
841,
840,
839,
]

_charnames_113664 = [
10604,
10598,
10577,
10572,
10608,
10587,
10582,
10613,
10595,
10600,
10606,
10551,
10581,
10597,
10609,
10590,
10556,
10576,
10519,
10596,
10591,
10518,
10605,
10586,
10555,
10562,
10522,
10533,
10494,
10564,
10529,
10541,
10504,
10566,
10531,
10535,
10536,
10496,
10497,
10567,
10532,
10537,
10506,
10565,
10530,
10542,
10505,
10538,
10539,
10540,
10498,
10499,
10500,
10501,
10574,
10575,
10543,
10547,
10550,
10507,
10508,
10589,
10607,
10502,
10503,
10610,
10515,
10561,
10557,
10611,
10602,
10592,
10603,
10521,
10569,
10594,
10512,
10554,
10513,
10585,
10612,
10568,
10593,
10599,
10571,
10584,
10553,
10570,
10517,
10560,
10558,
10559,
10549,
10544,
10546,
10548,
10545,
10524,
10525,
10526,
10527,
10579,
10580,
10511,
10520,
10516,
10601,
-1,
-1,
-1,
-1,
-1,
10630,
10654,
10655,
10618,
10653,
10633,
10648,
10649,
10645,
10647,
10651,
10650,
10646,
-1,
-1,
-1,
10642,
10638,
10639,
10635,
10640,
10641,
10636,
10637,
10632,
]

_charnames_113808 = [
10624,
10626,
10627,
10620,
10628,
10629,
10621,
10625,
10617,
10623,
-1,
-1,
10657,
10656,
10659,
10658,
2864,
2866,
2865,
2863,
]

_charnames_119262 = [
7310,
7300,
7306,
7308,
7307,
7309,
7303,
7302,
7299,
7298,
7305,
]

_charnames_120832 = [
1547,
1779,
1760,
1899,
1813,
1868,
1638,
1791,
1648,
1637,
1640,
1626,
1630,
1790,
1549,
1781,
1590,
1587,
1588,
1631,
1628,
1552,
1565,
1564,
1562,
1560,
1567,
1784,
1685,
1639,
1570,
1786,
1593,
1591,
1581,
1589,
1633,
1634,
1629,
1592,
1573,
1575,
1577,
1578,
1652,
1555,
1557,
1558,
1677,
1618,
1561,
1568,
1559,
1563,
1670,
1613,
1668,
1669,
1624,
1625,
1615,
1574,
1580,
1579,
1673,
1674,
1675,
1619,
1726,
1731,
1730,
1728,
1729,
1809,
1713,
1848,
1717,
1740,
1724,
1742,
1725,
1743,
1723,
1768,
1769,
1849,
1900,
1719,
1721,
1722,
1714,
1749,
1738,
1746,
1744,
1748,
1747,
1737,
1733,
1734,
1735,
1736,
1800,
1803,
1807,
1804,
1865,
1852,
1754,
1752,
1757,
1766,
1759,
1770,
1758,
1767,
1774,
1772,
1777,
1891,
1894,
1897,
1895,
1828,
1832,
1811,
1850,
1831,
1840,
1833,
1851,
1841,
1842,
1866,
1583,
1787,
1823,
1877,
1834,
1586,
1585,
1824,
1687,
1690,
1691,
1692,
1698,
1647,
1797,
1898,
1883,
1699,
1700,
1694,
1695,
1838,
1697,
1837,
1882,
1881,
1696,
1798,
1836,
1880,
1594,
1788,
1825,
1843,
1878,
1569,
1785,
1711,
1844,
1890,
1706,
1708,
1709,
1799,
1896,
1889,
1702,
1705,
1704,
1710,
1707,
1864,
1636,
1789,
1776,
1862,
1863,
1861,
1764,
1826,
1875,
1874,
1684,
1845,
1678,
1795,
1682,
1679,
1859,
1676,
1683,
1681,
1793,
1775,
1771,
1846,
1886,
1887,
1884,
1794,
1805,
1806,
1857,
1858,
1855,
1827,
1596,
1819,
1599,
1600,
1601,
1604,
1605,
1603,
1621,
1622,
1616,
1612,
1611,
1808,
1610,
1614,
1762,
1763,
1820,
1821,
1815,
1818,
1872,
1873,
1870,
1641,
1662,
1656,
1657,
1658,
1663,
1651,
1654,
1653,
1645,
1660,
1646,
1649,
1661,
1545,
1712,
2270,
2271,
2272,
2519,
2520,
2521,
2455,
2456,
2457,
2505,
2506,
2507,
2340,
2341,
2342,
2464,
2465,
2451,
2447,
2452,
2448,
2449,
2423,
2419,
2424,
2420,
2421,
2453,
2187,
2186,
2188,
2190,
2185,
2184,
2189,
2036,
2156,
1979,
1980,
1977,
1978,
1981,
2016,
2015,
2013,
2014,
1952,
2011,
2010,
2008,
2009,
1997,
1998,
1999,
1944,
1946,
1947,
1945,
1949,
1950,
1951,
1993,
1994,
1995,
2025,
2026,
2027,
2029,
2030,
2031,
2234,
2235,
2236,
2238,
2239,
2240,
2245,
2243,
2244,
2242,
2178,
2179,
2176,
2177,
2173,
2174,
2171,
2172,
2168,
2169,
2166,
2167,
2163,
2164,
2161,
2162,
2113,
2114,
2111,
2112,
2115,
2137,
2136,
2134,
2135,
2057,
2132,
2131,
2130,
2129,
2143,
2054,
2055,
2056,
2058,
2140,
2141,
2142,
2145,
2146,
2147,
2149,
2150,
2151,
2253,
2254,
2255,
2249,
2250,
2251,
2256,
1933,
1934,
1931,
1932,
1925,
1926,
1923,
1924,
1937,
1938,
2004,
2005,
2006,
1984,
1989,
1990,
1985,
1961,
1962,
1963,
1957,
1958,
1959,
1939,
1941,
1942,
2296,
2300,
2308,
1982,
1928,
2002,
1987,
1969,
2298,
2302,
2306,
1929,
2003,
1988,
1970,
2299,
2303,
2307,
1965,
1966,
1967,
2046,
2047,
2103,
2106,
2102,
2105,
2086,
2089,
2087,
2090,
2066,
2067,
2313,
2317,
2321,
2043,
2044,
2098,
2099,
2096,
2097,
2079,
2082,
2080,
2083,
2063,
2064,
2312,
2316,
2320,
2050,
2051,
2048,
2049,
2052,
2107,
2091,
2069,
2070,
2071,
2310,
2314,
2318,
2116,
2019,
2022,
2020,
2023,
2119,
2122,
2125,
2120,
2123,
2126,
1972,
1973,
2073,
2074,
2034,
2035,
2154,
2155,
2474,
2475,
2479,
2472,
2476,
2477,
2470,
2471,
2480,
2478,
1902,
1914,
1908,
1907,
1911,
1909,
1912,
1913,
2441,
2439,
2440,
2375,
2376,
2377,
2484,
2486,
2485,
2483,
2436,
2437,
2435,
2368,
2367,
2369,
2380,
2381,
2365,
2363,
2366,
2362,
2382,
2371,
2373,
2372,
2347,
2349,
2350,
2355,
2357,
2358,
2352,
2359,
2353,
2498,
2499,
2497,
2291,
2289,
2290,
2384,
2492,
2493,
2490,
2491,
2516,
2513,
2517,
2514,
2509,
2510,
2206,
2207,
2208,
2214,
2216,
2217,
2222,
2224,
2225,
2203,
2202,
2201,
2197,
2200,
2199,
2193,
2196,
2195,
2218,
2221,
2220,
2210,
2213,
2212,
2401,
2400,
2399,
2209,
2227,
2228,
2265,
2267,
2261,
2260,
2268,
2266,
2263,
2264,
2279,
2286,
2282,
2283,
2284,
2285,
2287,
2037,
2157,
2494,
1901,
2383,
2460,
2461,
2522,
2425,
2462,
2275,
2276,
2277,
2523,
2396,
2395,
2394,
2393,
2392,
2391,
2390,
2389,
2433,
2412,
2413,
2405,
2407,
2410,
2406,
2408,
2409,
2501,
2442,
2466,
2502,
2524,
]

_charnames_121499 = [
2432,
2431,
2430,
2429,
2428,
-1,
2338,
2337,
2336,
2335,
2334,
2333,
2332,
2331,
2330,
2329,
2328,
2327,
2326,
2325,
2324,
]

_charnames_122880 = [
8079,
8065,
8067,
8077,
8062,
8036,
8053,
-1,
8054,
8044,
8045,
8040,
8063,
8075,
8074,
8073,
8072,
8071,
8070,
8069,
8051,
8056,
8068,
8059,
8076,
-1,
-1,
8048,
8057,
8078,
8049,
8034,
8035,
8039,
-1,
8037,
8050,
-1,
8038,
8042,
8066,
8043,
8060,
]

_charnames_124928 = [
6211,
6210,
6209,
6141,
6108,
6129,
6160,
6225,
6208,
6207,
6206,
6283,
6292,
6296,
6163,
6316,
6264,
6145,
6159,
6269,
6205,
6204,
6203,
6148,
6109,
6252,
6214,
6201,
6200,
6199,
6256,
6106,
6308,
6270,
6198,
6197,
6196,
6242,
6311,
6240,
6260,
6271,
6277,
6273,
6315,
6226,
6192,
6190,
6189,
6243,
6294,
6272,
6126,
6314,
6185,
6184,
6183,
6120,
6132,
6153,
6253,
6300,
6195,
6194,
6193,
6115,
6223,
6222,
6188,
6187,
6186,
6112,
6152,
6307,
6137,
6182,
6181,
6179,
6249,
6297,
6245,
6143,
6229,
6178,
6177,
6176,
6302,
6124,
6266,
6288,
6175,
6174,
6173,
6127,
6130,
6275,
6116,
6313,
6310,
6172,
6171,
6170,
6293,
6236,
6228,
6167,
6217,
6168,
6107,
6166,
6267,
6121,
6281,
6154,
6278,
6117,
6155,
6317,
6162,
6113,
6165,
6122,
6295,
6261,
6250,
6289,
6247,
6282,
6118,
6305,
6220,
6251,
6299,
6237,
6320,
6239,
6238,
6219,
6150,
6227,
6138,
6104,
6157,
6123,
6156,
6309,
6140,
6262,
6144,
6287,
6161,
6215,
6133,
6232,
6230,
6216,
6244,
6306,
6265,
6276,
6111,
6131,
6164,
6303,
6298,
6248,
6285,
6151,
6259,
6110,
6304,
6134,
6135,
6233,
6286,
6280,
6284,
6319,
6291,
6139,
6142,
6254,
6318,
6258,
6274,
6221,
6218,
6255,
6231,
6119,
6263,
6128,
6241,
6149,
6234,
6105,
6146,
-1,
-1,
6331,
6323,
6324,
6329,
6330,
6326,
6327,
6333,
6332,
6340,
6338,
6343,
6341,
6339,
6344,
6345,
]

_charnames_125184 = [
4469,
4448,
4462,
4461,
4451,
4441,
4459,
4450,
4457,
4467,
4466,
4464,
4460,
4447,
4438,
4453,
4431,
4436,
4439,
4455,
4463,
4468,
4465,
4458,
4445,
4430,
4456,
4432,
4454,
4435,
4444,
4452,
4434,
4442,
4512,
4491,
4505,
4504,
4494,
4484,
4502,
4493,
4500,
4510,
4509,
4507,
4503,
4490,
4481,
4496,
4474,
4479,
4482,
4498,
4506,
4511,
4508,
4501,
4488,
4473,
4499,
4475,
4497,
4478,
4487,
4495,
4477,
4485,
4536,
4533,
4531,
4535,
4470,
4532,
4534,
-1,
-1,
-1,
-1,
-1,
4523,
4524,
4515,
4516,
4521,
4522,
4518,
4519,
4526,
4525,
-1,
-1,
-1,
-1,
4529,
4528,
]

_charnames_126464 = [
4092,
4104,
4100,
3958,
-1,
4095,
4083,
4101,
4077,
4094,
4090,
3996,
4099,
4098,
4029,
4093,
4103,
4030,
4097,
4096,
4028,
4081,
4079,
4089,
4080,
3959,
4084,
4102,
3956,
3954,
3955,
3953,
-1,
4054,
4050,
-1,
4043,
-1,
-1,
4044,
-1,
4045,
4041,
4049,
4048,
4047,
4034,
4055,
4052,
4035,
4046,
-1,
4033,
4038,
4037,
4040,
-1,
4053,
-1,
4051,
-1,
-1,
-1,
-1,
-1,
-1,
4073,
-1,
-1,
-1,
-1,
4074,
-1,
4068,
-1,
4071,
-1,
4070,
4061,
4076,
-1,
4062,
4069,
-1,
4060,
-1,
-1,
4072,
-1,
4067,
-1,
4075,
-1,
4066,
-1,
4065,
-1,
4026,
4023,
-1,
4016,
-1,
-1,
4017,
4002,
4019,
4014,
-1,
4022,
4021,
4005,
4027,
4025,
4006,
4020,
-1,
4004,
4001,
4000,
4013,
-1,
4011,
4018,
4024,
4010,
-1,
4009,
-1,
3982,
3995,
3992,
3979,
3976,
3985,
3973,
3977,
3967,
3984,
-1,
3990,
3989,
3988,
3970,
3983,
3994,
3971,
3987,
3986,
3969,
3966,
3964,
3991,
3965,
3980,
3974,
3993,
-1,
-1,
-1,
-1,
-1,
3950,
3946,
3936,
-1,
3939,
3933,
3947,
3927,
3938,
-1,
3944,
3943,
3942,
3930,
3951,
3949,
3931,
3941,
3940,
3929,
3926,
3924,
3945,
3925,
3937,
3934,
3948,
]

_charnames_127136 = [
9676,
9670,
9600,
9605,
9617,
9623,
9629,
9634,
9665,
9655,
9610,
9660,
9640,
9650,
9645,
-1,
-1,
9671,
9601,
9606,
9618,
9624,
9630,
9635,
9666,
9656,
9611,
9661,
9641,
9651,
9646,
9678,
-1,
9672,
9602,
9607,
9619,
9625,
9631,
9636,
9667,
9657,
9612,
9662,
9642,
9652,
9647,
9675,
-1,
9673,
9603,
9608,
9620,
9626,
9632,
9637,
9668,
9658,
9613,
9663,
9643,
9653,
9648,
9677,
9621,
9578,
9589,
9598,
9597,
9596,
9595,
9594,
9593,
9592,
9588,
9587,
9586,
9585,
9584,
9583,
9582,
9581,
9580,
9579,
9591,
9590,
]

_charnames_127280 = [
2915,
-1,
2914,
2913,
2912,
2911,
2910,
2909,
2908,
2907,
2906,
2905,
2904,
-1,
2903,
-1,
2902,
2901,
-1,
2900,
2899,
2898,
-1,
2897,
2896,
2895,
-1,
-1,
-1,
-1,
-1,
2975,
11005,
11004,
11003,
11002,
11001,
11000,
10999,
-1,
10998,
10997,
10996,
10995,
10994,
10993,
10992,
-1,
10991,
10990,
10989,
10988,
10987,
10986,
10985,
10984,
10983,
10982,
11814,
11813,
-1,
-1,
-1,
-1,
10977,
10976,
10975,
10974,
10973,
10972,
10971,
10970,
10969,
-1,
10968,
-1,
-1,
10967,
10966,
-1,
10965,
10964,
10963,
10962,
10961,
10960,
10959,
10958,
10957,
10956,
-1,
-1,
-1,
-1,
10980,
10978,
-1,
2939,
2938,
2957,
2976,
2971,
2970,
2968,
2944,
2964,
2961,
2951,
2943,
2949,
2958,
2977,
2959,
2942,
2950,
2945,
2967,
2916,
2955,
2954,
2953,
2921,
2946,
2965,
2962,
]

_charnames_127462 = [
11777,
11776,
11775,
11774,
11773,
11772,
11771,
11770,
11769,
11768,
11767,
11766,
11765,
11764,
11763,
11762,
11761,
11760,
11759,
11758,
11757,
11756,
11755,
11754,
11753,
11752,
-1,
2974,
2973,
]

_charnames_127538 = [
2926,
2925,
2935,
2932,
2930,
2931,
2927,
2936,
2934,
2937,
]

_charnames_127744 = [
8469,
12492,
8413,
11124,
3078,
3077,
8504,
3079,
11822,
5780,
11510,
10489,
7051,
12034,
12033,
12032,
12409,
10947,
11521,
12460,
11520,
12524,
11523,
9134,
11524,
8487,
10946,
12459,
9133,
12523,
3081,
12408,
2877,
1447,
5976,
11590,
11594,
11592,
11593,
8419,
8418,
8420,
8417,
12491,
11581,
12217,
1281,
6080,
7917,
3228,
12053,
10767,
9546,
8356,
12216,
1472,
7912,
11844,
12246,
3080,
6014,
12037,
12036,
12139,
12485,
6865,
12454,
9212,
7315,
1523,
4621,
12355,
6565,
11514,
846,
9210,
5614,
9804,
11804,
12370,
9773,
9775,
7913,
3105,
12188,
3189,
6566,
9731,
11747,
11748,
8240,
7800,
3110,
3145,
5785,
12506,
11850,
10796,
10183,
3084,
12505,
12479,
3048,
2858,
12621,
10715,
8239,
8025,
8340,
9234,
7805,
12225,
2872,
6060,
9737,
8238,
12488,
1512,
3206,
11583,
8247,
1485,
6069,
8431,
5619,
12489,
6045,
9746,
11730,
11654,
6085,
12633,
8024,
12452,
12465,
12466,
5594,
9561,
8228,
847,
8477,
9805,
12631,
8333,
11580,
7232,
3216,
12356,
12133,
6042,
7052,
11802,
7313,
3115,
9208,
8231,
6054,
6053,
12475,
4537,
8334,
12519,
11835,
12478,
7042,
7235,
8505,
12138,
4254,
1520,
8502,
1415,
8425,
9766,
10480,
10784,
3193,
6090,
12415,
6032,
12509,
7314,
7291,
3204,
12398,
7312,
1495,
10483,
7311,
11865,
1513,
3251,
5580,
7918,
3236,
11866,
3087,
3148,
1486,
12206,
4624,
11867,
3247,
11644,
12405,
11826,
11827,
8489,
10488,
12481,
12620,
1278,
3237,
8351,
6057,
6081,
12211,
8503,
10768,
8426,
10760,
10761,
11065,
3102,
12210,
12212,
10182,
12628,
12051,
12226,
5608,
4620,
12218,
9232,
8235,
3215,
10769,
12448,
12622,
12632,
12052,
11624,
6002,
11516,
11518,
11845,
5968,
9136,
5627,
6034,
4623,
12014,
12013,
12012,
12011,
12010,
11830,
7217,
10175,
11513,
8241,
1412,
9209,
11828,
8343,
10805,
8480,
11627,
3240,
3239,
12204,
11831,
12402,
2888,
7207,
11847,
8023,
10721,
9799,
6049,
11935,
10173,
3136,
6082,
3901,
12224,
9135,
12477,
1484,
6013,
1470,
12177,
5618,
12499,
6086,
9770,
11396,
9749,
10804,
5605,
10725,
7218,
8242,
1413,
11829,
8344,
10806,
3147,
12207,
7208,
10722,
9802,
12500,
12187,
11641,
6056,
9566,
9801,
9570,
8021,
12040,
12039,
12029,
11112,
7219,
1522,
11620,
11603,
11609,
11622,
12480,
11517,
10180,
1444,
1445,
8424,
10146,
8478,
11633,
12041,
11011,
1536,
12636,
10808,
11392,
6091,
11634,
9812,
12181,
9732,
6682,
4638,
12242,
11632,
11635,
12494,
6075,
6074,
6039,
12411,
6568,
11630,
12453,
6680,
1531,
1529,
9741,
11636,
5781,
9759,
6675,
6674,
10042,
10041,
5615,
8233,
9792,
12629,
12630,
12414,
5620,
12026,
4422,
12623,
3250,
12610,
12399,
10797,
8946,
11068,
12447,
12191,
5622,
3223,
9807,
11390,
9231,
11744,
12393,
11383,
6041,
8244,
11649,
6055,
5786,
1532,
3143,
12378,
12135,
6010,
12368,
12647,
9813,
12134,
11794,
12136,
10783,
11934,
3914,
6047,
3180,
8246,
3150,
10802,
10794,
9808,
12513,
10773,
3133,
1446,
11616,
12249,
7205,
7801,
12105,
8488,
5610,
5613,
5612,
5611,
7204,
8014,
3233,
9764,
5782,
7048,
12510,
10149,
10815,
12471,
10144,
9550,
9552,
8354,
1511,
8327,
8013,
8015,
5623,
8432,
9815,
11840,
9571,
3106,
1491,
6028,
9211,
11104,
11105,
8415,
10147,
12369,
6011,
10162,
6029,
11066,
3209,
6564,
1500,
9554,
12450,
3203,
9816,
7916,
10178,
12618,
9572,
12056,
12616,
11997,
8412,
8411,
10140,
10141,
9743,
9744,
10952,
7227,
7229,
10484,
7230,
11100,
3910,
8349,
8350,
10481,
1503,
11823,
10482,
12474,
9748,
9797,
1535,
8404,
8405,
8408,
3909,
9224,
12245,
3128,
3124,
3127,
3126,
5533,
11933,
9206,
11728,
9229,
8414,
11393,
9225,
10145,
6066,
6068,
6027,
8920,
11824,
5603,
11994,
10171,
3050,
1521,
11099,
11394,
12600,
12598,
12602,
12601,
12599,
12463,
11932,
11653,
12185,
11118,
12228,
9809,
7041,
1504,
8485,
2724,
12627,
1494,
5953,
11599,
9129,
9128,
9130,
9127,
3172,
3173,
12577,
10707,
12575,
10706,
9223,
12586,
8500,
8475,
8474,
11111,
11110,
3225,
11610,
12084,
8511,
10179,
10723,
11381,
7236,
3221,
6347,
6033,
8398,
8365,
8371,
8385,
8388,
8378,
8381,
8395,
8401,
8374,
8392,
8368,
8397,
8364,
8370,
8384,
8387,
8377,
8380,
8394,
8400,
8373,
8391,
8367,
11715,
11718,
11717,
6077,
6078,
11745,
6026,
8341,
6681,
5957,
11093,
12222,
6678,
3184,
10799,
3139,
3140,
12635,
6679,
9199,
1501,
11721,
11621,
5996,
1502,
8427,
5604,
3101,
11996,
12511,
9771,
8919,
6001,
9218,
9222,
9220,
9219,
9221,
9195,
1464,
11811,
11785,
11782,
11783,
11784,
11786,
11810,
11602,
2655,
2654,
2660,
2659,
5984,
5967,
2653,
2656,
2658,
2661,
5990,
5975,
6004,
10759,
11395,
1426,
9789,
9750,
6005,
11613,
3047,
1280,
11584,
10170,
1533,
1427,
1479,
9992,
12189,
3211,
9790,
12451,
10150,
10718,
10719,
10720,
12503,
12502,
12504,
6008,
12495,
10143,
8328,
8329,
12472,
12002,
12004,
12005,
11103,
11107,
11108,
12008,
12006,
12007,
10716,
9547,
9553,
11525,
3137,
3138,
10758,
7047,
6864,
10177,
8406,
8337,
12615,
10766,
8175,
10038,
11836,
9551,
3118,
10791,
8945,
3129,
1423,
1422,
1421,
1420,
9197,
11719,
1530,
1424,
9196,
11720,
9200,
11722,
7233,
8943,
8942,
5589,
5593,
5590,
5592,
5587,
8941,
5588,
11640,
7216,
1524,
3099,
2726,
7234,
12373,
12374,
12432,
3155,
3158,
3159,
3157,
3163,
3161,
11582,
3166,
12444,
11803,
3162,
3165,
3170,
11008,
12027,
12592,
12435,
9769,
8226,
8227,
11385,
12445,
11387,
11388,
12422,
12424,
12425,
10776,
11639,
3913,
9729,
8483,
9765,
12439,
10777,
12498,
3912,
12521,
11647,
3183,
1394,
12376,
9233,
12427,
12248,
12428,
12443,
4628,
12512,
3181,
10774,
12441,
12438,
12375,
8347,
3168,
3169,
8346,
11389,
9730,
8484,
11648,
3188,
3187,
12585,
12436,
12437,
12429,
9763,
3229,
12137,
3130,
12190,
9760,
9761,
9757,
9758,
11076,
3031,
11084,
3039,
1462,
1453,
1463,
1454,
11075,
3030,
11083,
3038,
12095,
12064,
12098,
12067,
11077,
3032,
11085,
3040,
12096,
12065,
12099,
12068,
12220,
12221,
3044,
3045,
9180,
12569,
11702,
10701,
3210,
12075,
8944,
12083,
12092,
3248,
3198,
3199,
3200,
12129,
3201,
12073,
10447,
10456,
7919,
11793,
11848,
12140,
3111,
11821,
12240,
12241,
1480,
6562,
8938,
3100,
1475,
1476,
6072,
10168,
1487,
6076,
7049,
4625,
12467,
9739,
10166,
1279,
10165,
4619,
10169,
11799,
10763,
4255,
1478,
7209,
7213,
3083,
7214,
4639,
2882,
11846,
3132,
12202,
10466,
8234,
9740,
1492,
10724,
11101,
3175,
11098,
9814,
10726,
9736,
11113,
6089,
11097,
6088,
7215,
9776,
11094,
8022,
6346,
11637,
11801,
5617,
1525,
11512,
2876,
5531,
5532,
9563,
7804,
5626,
9198,
1493,
9796,
8498,
6040,
12412,
8245,
3182,
2875,
6067,
6070,
9679,
10174,
2874,
]

_charnames_128736 = [
12186,
2883,
10181,
7225,
11820,
7224,
12578,
12579,
12576,
3174,
11089,
4633,
4634,
-1,
-1,
-1,
3202,
10167,
10785,
9564,
3214,
7223,
8342,
]

_charnames_128768 = [
4406,
4302,
4419,
4420,
4404,
4291,
4289,
4290,
4287,
4288,
4352,
4355,
4354,
4269,
4369,
4348,
4379,
4382,
4381,
4322,
4271,
4409,
4357,
4358,
4337,
4338,
4416,
4282,
4399,
4400,
4314,
4333,
4320,
4401,
4266,
4312,
4313,
4321,
4273,
4264,
4359,
4373,
4413,
4300,
4267,
4274,
4265,
4356,
4331,
4332,
4325,
4329,
4328,
4327,
4293,
4294,
4384,
4275,
4299,
4334,
4335,
4297,
4349,
4374,
4375,
4407,
4340,
4343,
4342,
4295,
4418,
4280,
4372,
4415,
4403,
4362,
4317,
4376,
4316,
4283,
4318,
4377,
4279,
4412,
4281,
4417,
4388,
4298,
4364,
4347,
4363,
4301,
4277,
4278,
4268,
4368,
4396,
4394,
4395,
4367,
4366,
4305,
4310,
4309,
4308,
4307,
4296,
4346,
4345,
4336,
4387,
4410,
4397,
4383,
4391,
4390,
]

_charnames_128896 = [
5982,
5987,
5965,
5972,
5956,
6561,
6019,
12114,
10452,
12020,
11626,
11839,
5993,
5955,
8937,
6559,
6018,
12113,
10451,
12019,
11597,
11598,
2979,
5995,
5999,
5927,
11605,
11606,
10782,
5994,
5998,
5926,
11608,
1440,
8939,
6560,
6023,
10459,
10457,
12024,
1439,
8936,
6547,
6022,
12074,
10449,
12023,
8929,
6552,
6024,
12125,
10458,
12025,
8935,
6545,
6021,
12070,
10448,
12022,
8940,
6557,
6025,
12111,
10454,
8933,
6555,
1425,
6554,
8926,
6551,
12484,
6550,
11791,
8930,
12126,
6546,
12071,
2725,
6558,
12110,
10455,
12109,
8932,
12120,
12119,
]

_charnames_129024 = [
9166,
12554,
11686,
10688,
9169,
12557,
11689,
10691,
9170,
12558,
11690,
10692,
-1,
-1,
-1,
-1,
9167,
12555,
11687,
10689,
9171,
12559,
11691,
10693,
12082,
12117,
12123,
12104,
12081,
12116,
12122,
12103,
9153,
12541,
11673,
10674,
9154,
12542,
11674,
10675,
9156,
12545,
11676,
10678,
9155,
12543,
11675,
10676,
9152,
12540,
11672,
10673,
9187,
12570,
11709,
10702,
9177,
12564,
11699,
10695,
9190,
12571,
11712,
10703,
9183,
12567,
11705,
10698,
9184,
12568,
11706,
10699,
]

_charnames_129104 = [
9178,
12565,
11700,
10696,
11080,
11088,
3043,
3035,
9194,
12583,
-1,
-1,
-1,
-1,
-1,
-1,
11569,
11557,
11563,
11575,
11545,
11551,
11538,
11532,
11571,
11559,
11565,
11577,
11547,
11553,
11540,
11534,
11568,
11556,
11562,
11574,
11544,
11550,
11537,
11531,
11570,
11558,
11564,
11576,
11546,
11552,
11539,
11533,
11567,
11555,
11561,
11573,
11543,
11549,
11536,
11530,
]

_charnames_129168 = [
9161,
12550,
11681,
10684,
9188,
12561,
11710,
10700,
9168,
12556,
11688,
10690,
12087,
12091,
12090,
12089,
9173,
11696,
9163,
11683,
9189,
11703,
9181,
11711,
9175,
11697,
9186,
11708,
11619,
11618,
]

_charnames_129296 = [
12644,
7206,
12431,
11009,
1441,
12440,
11849,
12250,
2525,
8353,
11818,
9203,
11725,
12182,
12183,
-1,
12434,
8421,
11064,
11837,
10803,
9240,
12446,
3241,
]

_charnames_129328 = [
9795,
-1,
-1,
3231,
9791,
6677,
7226,
2885,
9762,
12634,
12520,
7182,
11652,
11511,
12180,
-1,
11585,
10807,
8430,
1471,
3149,
12403,
11749,
12462,
3232,
1442,
6048,
6777,
-1,
-1,
-1,
-1,
8479,
4637,
7806,
5606,
9735,
8331,
5625,
12367,
2859,
3114,
12055,
12410,
9774,
11391,
9567,
]

_charnames_129408 = [
8490,
8951,
3213,
1469,
12590,
12038,
10660,
5460,
2857,
10176,
12493,
6079,
10770,
12404,
8950,
11875,
2886,
2981,
]

_charnames_983040 = [
11117,
11116,
3096,
3051,
3094,
3119,
11988,
11980,
11986,
12047,
11999,
11998,
4636,
4635,
4423,
6065,
5601,
6095,
8016,
12197,
12251,
1277,
8917,
10948,
11992,
9241,
11123,
12049,
8915,
10463,
10485,
12490,
12527,
8332,
8470,
2880,
9228,
2982,
2881,
9227,
1538,
10798,
10816,
10754,
10814,
10751,
10813,
10752,
10812,
10755,
10811,
11006,
11067,
3220,
3219,
11987,
11981,
8336,
8335,
11991,
12048,
3086,
3085,
12044,
12043,
12609,
12470,
12525,
12607,
12379,
12413,
12606,
11800,
11874,
12608,
12589,
12593,
3121,
10764,
10762,
9569,
9568,
12244,
12227,
5784,
6096,
11096,
11121,
12613,
12611,
11007,
11010,
3093,
3243,
11989,
12045,
8019,
12200,
12252,
8018,
12199,
12253,
8916,
10464,
10486,
9558,
9559,
9681,
9560,
9557,
9680,
11790,
11792,
11657,
2716,
2722,
3245,
2717,
2721,
3244,
10753,
10810,
9786,
9783,
9818,
9785,
9782,
9817,
3230,
3120,
8338,
8512,
6563,
7426,
3097,
3095,
3141,
11993,
11990,
12054,
3092,
3049,
2718,
3252,
2719,
3217,
8230,
8509,
3107,
3088,
10148,
10135,
9787,
9822,
4630,
4631,
11120,
2887,
9095,
9052,
8510,
4421,
3224,
11380,
9120,
9121,
9122,
9123,
1405,
12517,
12516,
12515,
7427,
12642,
12640,
12643,
9237,
11871,
9239,
11873,
9821,
9236,
11870,
11122,
7428,
11655,
9238,
11872,
12526,
9820,
11645,
7044,
7045,
9150,
11670,
12646,
9794,
10186,
10297,
10431,
10420,
10409,
10398,
10387,
10376,
10365,
10286,
10275,
10264,
10253,
10242,
10231,
10220,
6094,
6046,
12641,
7658,
7660,
6093,
10209,
10198,
10187,
10342,
10331,
10320,
10309,
10298,
10353,
10364,
10363,
10362,
10361,
10441,
10440,
10439,
10438,
10437,
10436,
10435,
10434,
10433,
10432,
10430,
10429,
10428,
10427,
10426,
10425,
10424,
10423,
10422,
10421,
10419,
10418,
10417,
10416,
10415,
10414,
10413,
10412,
10411,
10410,
10408,
10407,
10406,
10405,
10404,
10403,
10402,
10401,
10400,
10399,
10397,
10396,
10395,
10394,
10393,
10392,
10391,
10390,
10389,
10388,
10386,
10385,
10384,
10383,
10382,
10381,
10380,
10379,
10378,
10377,
10375,
10374,
10373,
10372,
10371,
10370,
10369,
10368,
10367,
10366,
10296,
10295,
10294,
10293,
10292,
10291,
10290,
10289,
10288,
10287,
10285,
10284,
10283,
10282,
10281,
10280,
10279,
10278,
10277,
10276,
10274,
10273,
10272,
10271,
10270,
10269,
10268,
10267,
10266,
10265,
10263,
10262,
10261,
10260,
10259,
10258,
10257,
10256,
10255,
10254,
10252,
10251,
10250,
10249,
10248,
10247,
10246,
10245,
10244,
10243,
10241,
10240,
10239,
10238,
10237,
10236,
10235,
10234,
10233,
10232,
10230,
10229,
10228,
10227,
10226,
10225,
10224,
10223,
10222,
10221,
10219,
10218,
10217,
10216,
10215,
10214,
10213,
10212,
10211,
10210,
10208,
10207,
10206,
10205,
10204,
10203,
10202,
10201,
10200,
10199,
10197,
10196,
10195,
10194,
10193,
10192,
10191,
10190,
10189,
10188,
10352,
10351,
10350,
10349,
10348,
10347,
10346,
10345,
10344,
10343,
10341,
10340,
10339,
10338,
10337,
10336,
10335,
10334,
10333,
10332,
10330,
10329,
10328,
10327,
10326,
10325,
10324,
10323,
10322,
10321,
10319,
10318,
10317,
10316,
10315,
10314,
10313,
10312,
10311,
10310,
10308,
10307,
10306,
10305,
10304,
10303,
10302,
10301,
10300,
10299,
10360,
10359,
10358,
10357,
10356,
10355,
10354,
]

_charnames_983612 = [
9060,
9003,
9004,
8988,
8989,
8963,
8964,
9048,
9049,
4157,
4161,
4158,
4163,
4162,
4160,
4164,
4159,
4165,
6063,
1179,
1168,
1187,
1167,
1176,
1165,
1175,
1164,
1183,
1184,
1181,
1177,
1172,
1182,
1174,
1173,
1178,
1166,
1185,
1171,
1170,
1169,
1186,
1180,
1011,
1016,
1017,
1012,
1013,
1018,
1019,
1010,
1014,
1015,
1009,
894,
899,
900,
895,
896,
901,
902,
893,
897,
898,
892,
1154,
1159,
1160,
1155,
1156,
1161,
1162,
1153,
1157,
1158,
1152,
881,
886,
887,
882,
883,
888,
889,
880,
884,
885,
879,
1025,
1030,
1031,
1026,
1027,
1032,
1033,
1024,
1028,
1029,
1023,
868,
873,
874,
869,
870,
875,
876,
867,
871,
872,
866,
1037,
1042,
1043,
1038,
1039,
1044,
1045,
1036,
1040,
1041,
1035,
906,
911,
912,
907,
908,
913,
914,
905,
909,
910,
904,
1102,
1107,
1108,
1103,
1104,
1109,
1110,
1101,
1105,
1106,
1100,
1115,
1120,
1121,
1116,
1117,
1122,
1123,
1114,
1118,
1119,
1113,
1076,
1081,
1082,
1077,
1078,
1083,
1084,
1075,
1079,
1080,
1074,
1063,
1068,
1069,
1064,
1065,
1070,
1071,
1062,
1066,
1067,
1061,
985,
990,
991,
986,
987,
992,
993,
984,
988,
989,
983,
1089,
1094,
1095,
1090,
1091,
1096,
1097,
1088,
1092,
1093,
1087,
961,
966,
967,
962,
963,
968,
969,
960,
964,
965,
959,
973,
978,
979,
974,
975,
980,
981,
972,
976,
977,
971,
1051,
1056,
1057,
1052,
1053,
1058,
1059,
1050,
1054,
1055,
1049,
856,
861,
862,
857,
858,
863,
864,
855,
859,
860,
854,
1128,
1133,
1134,
1129,
1130,
1135,
1136,
1127,
1131,
1132,
1126,
920,
925,
926,
921,
922,
927,
928,
919,
923,
924,
918,
934,
939,
940,
935,
936,
941,
942,
933,
937,
938,
932,
946,
951,
952,
947,
948,
953,
954,
945,
949,
950,
944,
1141,
1146,
1147,
1142,
1143,
1148,
1149,
1140,
1144,
1145,
1139,
996,
999,
1004,
1005,
1000,
1001,
1006,
1007,
998,
1002,
1003,
997,
929,
2712,
2711,
2710,
12383,
11322,
11320,
11321,
11319,
11315,
11328,
11326,
11327,
11325,
11313,
11343,
11306,
11342,
11305,
11316,
11311,
11309,
11310,
11308,
11314,
11349,
11336,
11337,
11335,
11347,
11344,
11346,
11339,
11345,
11331,
11330,
11332,
11348,
11340,
11358,
11354,
11351,
11352,
11355,
11357,
11359,
12236,
12234,
12232,
12235,
12233,
11367,
11365,
11363,
11366,
11364,
11374,
11371,
11372,
11373,
7180,
7179,
]

def lookup_charcode(code):
    res = -1
    if code == 895: res = 12365
    elif 1318 <= code <= 1327: res = _charnames_1318[code-1318]
    elif code == 1421: res = 11726
    elif code == 1422: res = 9204
    elif code == 1423: res = 4256
    elif code == 1540: res = 4166
    elif code == 1541: res = 4251
    elif code == 1564: res = 4197
    elif code == 1568: res = 4202
    elif code == 1631: res = 4250
    elif 2112 <= code <= 2142: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2260 <= code <= 2303: res = _charnames_2260[code-2260]
    elif code == 2362: res = 10745
    elif code == 2363: res = 10744
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 10736
    elif code == 2420: res = 10735
    elif code == 2421: res = 10738
    elif code == 2422: res = 10733
    elif code == 2423: res = 10732
    elif code == 2424: res = 10737
    elif code == 2432: res = 6064
    elif code == 2800: res = 12397
    elif code == 2809: res = 12396
    elif code == 2930: res = 10156
    elif code == 2931: res = 10157
    elif code == 2932: res = 10161
    elif code == 2933: res = 10155
    elif code == 2934: res = 10158
    elif code == 2935: res = 10160
    elif code == 3072: res = 1509
    elif code == 3124: res = 1508
    elif code == 3162: res = 1507
    elif code == 3200: res = 11378
    elif code == 3201: res = 11379
    elif code == 3329: res = 6860
    elif code == 3369: res = 6855
    elif code == 3386: res = 6854
    elif 3406 <= code <= 3423: res = _charnames_3406[code-3406]
    elif code == 3446: res = 6842
    elif code == 3447: res = 6844
    elif code == 3448: res = 6847
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 9118
    elif code == 3807: res = 9117
    elif code == 3980: res = 1401
    elif code == 3981: res = 1399
    elif code == 3982: res = 1398
    elif code == 3983: res = 1400
    elif code == 4057: res = 1404
    elif code == 4058: res = 1403
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 12386
    elif code == 4350: res = 12385
    elif code == 4351: res = 12384
    elif code == 4957: res = 11979
    elif code == 4958: res = 11978
    elif 5109 <= code <= 5117: res = _charnames_5109[code-5109]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6429: res = 8949
    elif code == 6430: res = 8948
    elif 6832 <= code <= 6846: res = _charnames_6832[code-6832]
    elif code == 7083: res = 3075
    elif code == 7084: res = 3074
    elif code == 7085: res = 3073
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 5522
    elif code == 7165: res = 5520
    elif code == 7166: res = 5523
    elif code == 7167: res = 5521
    elif 7296 <= code <= 7304: res = _charnames_7296[code-7296]
    elif 7360 <= code <= 7367: res = _charnames_7360[code-7360]
    elif 7411 <= code <= 7417: res = _charnames_7411[code-7411]
    elif 7655 <= code <= 7676: res = _charnames_7655[code-7655]
    elif code == 8294: res = 9205
    elif code == 8295: res = 11727
    elif code == 8296: res = 12461
    elif code == 8297: res = 9747
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif code == 8377: res = 12612
    elif code == 8378: res = 1468
    elif code == 8379: res = 11090
    elif code == 8380: res = 6683
    elif code == 8381: res = 11868
    elif code == 8382: res = 9131
    elif code == 8586: res = 1458
    elif code == 8587: res = 1459
    elif 9193 <= code <= 9214: res = _charnames_9193[code-9193]
    elif code == 9934: res = 10151
    elif code == 9954: res = 4627
    elif code == 9956: res = 9768
    elif code == 9957: res = 11729
    elif code == 9958: res = 9207
    elif code == 9959: res = 12617
    elif 9984 <= code <= 9995: res = _charnames_9984[code-9984]
    elif code == 10024: res = 3144
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 12078
    elif code == 10080: res = 12079
    elif code == 10133: res = 12127
    elif code == 10134: res = 12128
    elif code == 10135: res = 12106
    elif code == 10160: res = 7802
    elif code == 10175: res = 10714
    elif code == 10187: res = 6862
    elif code == 10189: res = 6863
    elif code == 10190: res = 2920
    elif code == 10191: res = 2919
    elif code == 11085: res = 10681
    elif code == 11086: res = 2871
    elif code == 11087: res = 2870
    elif 11098 <= code <= 11217: res = _charnames_11098[code-11098]
    elif code == 11244: res = 9162
    elif code == 11245: res = 12551
    elif code == 11246: res = 11682
    elif code == 11247: res = 10685
    elif code == 11506: res = 8223
    elif code == 11507: res = 8222
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 1409
    elif code == 11623: res = 1408
    elif code == 11632: res = 1410
    elif code == 11647: res = 1411
    elif 11826 <= code <= 11844: res = _charnames_11826[code-11826]
    elif code == 12728: res = 6038
    elif code == 12729: res = 6037
    elif code == 12730: res = 6036
    elif code == 42592: res = 8467
    elif code == 42593: res = 8448
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif 42648 <= code <= 42655: res = _charnames_42648[code-42648]
    elif 42893 <= code <= 42935: res = _charnames_42893[code-42893]
    elif code == 42999: res = 9114
    elif code == 43000: res = 7177
    elif code == 43001: res = 7170
    elif code == 43002: res = 9111
    elif code == 43205: res = 3205
    elif code == 43260: res = 10747
    elif code == 43261: res = 10748
    elif 43488 <= code <= 43518: res = _charnames_43488[code-43488]
    elif code == 43644: res = 7423
    elif code == 43645: res = 7422
    elif code == 43646: res = 7405
    elif code == 43647: res = 7404
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 43967: res = _charnames_43888[code-43888]
    elif code == 64046: res = 8508
    elif code == 64047: res = 8507
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 65063 <= code <= 65071: res = _charnames_65063[code-65063]
    elif code == 65931: res = 12362
    elif code == 65932: res = 12361
    elif code == 65933: res = 12364
    elif code == 65934: res = 11114
    elif code == 65952: res = 12360
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 10039
    elif 66384 <= code <= 66426: res = _charnames_66384[code-66384]
    elif 66736 <= code <= 66855: res = _charnames_66736[code-66736]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 8324
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67680 <= code <= 67742: res = _charnames_67680[code-67680]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67839: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68095: res = _charnames_67968[code-67968]
    elif 68224 <= code <= 68255: res = _charnames_68224[code-68224]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68480 <= code <= 68497: res = _charnames_68480[code-68480]
    elif code == 68505: res = 9718
    elif code == 68506: res = 9717
    elif code == 68507: res = 9716
    elif code == 68508: res = 9715
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif code == 68858: res = 9936
    elif code == 68859: res = 9941
    elif code == 68860: res = 9943
    elif code == 68861: res = 9942
    elif code == 68862: res = 9939
    elif code == 68863: res = 9938
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif code == 69759: res = 5727
    elif 69840 <= code <= 69864: res = _charnames_69840[code-69840]
    elif 69872 <= code <= 69955: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70749: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 11507
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 74607 <= code <= 74649: res = _charnames_74607[code-74607]
    elif 74851 <= code <= 74868: res = _charnames_74851[code-74851]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 845
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif code == 110592: res = 11375
    elif code == 110593: res = 12237
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 4086
    elif code == 126705: res = 4087
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif code == 127243: res = 10780
    elif code == 127244: res = 10779
    elif 127280 <= code <= 127404: res = _charnames_127280[code-127280]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127547: res = _charnames_127538[code-127538]
    elif code == 127568: res = 8496
    elif code == 127569: res = 8497
    elif 127744 <= code <= 128722: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128758: res = _charnames_128736[code-128736]
    elif 128768 <= code <= 128883: res = _charnames_128768[code-128768]
    elif 128896 <= code <= 128980: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129296 <= code <= 129319: res = _charnames_129296[code-129296]
    elif 129328 <= code <= 129374: res = _charnames_129328[code-129328]
    elif 129408 <= code <= 129425: res = _charnames_129408[code-129408]
    elif code == 129472: res = 7915
    elif 983040 <= code <= 983498: res = _charnames_983040[code-983040]
    elif 983612 <= code <= 983981: res = _charnames_983612[code-983612]
    if res == -1: raise KeyError, code
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FD5 or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'N', 15360),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklkmnopqrstukvkwkkk\x15\x15\x15xyzkkkkkkkkkk\x15\x15\x15\x15{kkkkkkkkkkk'
'kkkk\x15\x15|kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x15\x15}~kkk\x7f5555555555555555'
'5555555\x8055\x81kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\x82kkkkkkkkkkk\x83kkk'
'kkkkkkkkkkkkkkkk\x84\x85\x86\x87\x88\x89\x8a\x8b((\x8ckkkkk\x8dkkkkkkk\x8e\x8fkkkk\x90k\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9akkkkkk'
'\x9b\x9c5555555\x9d\x9e\x9f55555555555555555555555\xa055555\xa155555555555555555\xa25555'
'5555555555555555555555555555555555\xa355555555555555555555555555555'
'55555555555555555555555555555555555555\xa45555555555555555\xa5\xa65555555'
'55555555555555\xa7\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa05\xa9\xa8\xa8\xa8\xa8\xaa'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8'
'\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xa8\xaa'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'\xab\xackkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xad'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xad'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd6\x91\x91\x86\xa3\x86\x91\x92\x9bp\x91\xb0\x7ff\x80\x7fFFFFFFFFFF\x80\x91\xbe\xbd\xbe\x91'
'\x9188888888888888888888888888\x9b\x91p\xaac\xaa\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9b\xbdp\xbd\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd3\x89\xa3\xa3\x9f\xa3\xce\x89\xa7\xcd-y\xbd\x07\xca\xaa\xc2\xb2SS\xa7\x1b\x89\x8b\xa7S-uZZZ\x89'
'77777757777777775777777\xb55777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb5\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xa9\xa9\xa7\xa9)')''')'))\x1f$\xa9\xa9\xa9\xa9\xa9\xa9\xa7\xa7\xa7\xa7\xa9\xa7\xa9\xa7%%%%%\xa9\xa9\xa9\xa9\xa9\xa9\xa9)\xa9$\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xa97\x1b\x15\x15#\x1b\x1b\x1b\x8f7'
'\x15\x15\x15\x15\xa9\xa97\x90777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xba7\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xc8@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x88\x88\x88\x88\x88\x88\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x88i\x15\x15\xcd\xcd\xa2\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@k@'
'\x95@@\x95@@\x95@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x15\x15333\x95\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xba\xba\xac\x85\x85\x9e~z\xcd\xcd@@@@@@@@@@@z\x05\x15zz,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@CCCCCCCCCC\x85{{z,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,z,@@@@@@@\x06\xcd@@@@@@\x1e\x1e@@\xcd@@@@,,EEEEEEEEEE,,,\xc1\xc1,'
'zzzzzzzzzzzzzz\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'HHHHHHHHHH333333333333333333333333333333333@@@@@@@@@**\xcd\x8f\x8f\x8f*\x15\x15\x15\x15\x15'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x95\x15'
'3333333333333333333333333@@@\x15\x15\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15,,,,,,,,\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@\x06@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x88\x88GGGGGGGGGG\x88$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG00\xa2\xa2WWWWWW\xc8\xa2\x15\x15\x15\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG@@000@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x88\xa2\x15\x15\x15\x15\x15\x15\x150\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG\xc80WWWWWW\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGWWW\xcd\xcd\xcd\xcd\xcd\xcd\xa2\xcd\x15\x15\x15\x15\x15'
'@:::\x1500000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\xc8'
'0@::\x1500000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15GGGGGGGGGG\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@::\x1500000000\x15000\x1500000000000000000000000000000000000000000\x15\x150::'
':@@@@\x15:::\x15:::@0\xc8\x15\x15\x15\x15000:WWWWWWW000@@\x15\x15GGGGGGGGGGWWWWWWWWW\xc8000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15::\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa2'
'000000$@@@@@@@@\x88GGGGGGGGGG\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15GGGGGGGGGG\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xc8\xc8\xc8\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\xc8\x88\xc8\xc8\xc8@@\xc8\xc8\xc8\xc8\xc8\xc8GGGGGGGGGGWWWWWWWWWW\xc8@\xc8@\xc8@\x9ao\x9ao::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x88@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8@\xc8\xc8\xc8\xc8\xc8\xc8\x15\xc8\xc8\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'GGGGGGGGGG\x88\x88\x88\x88\x88\x88000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:GGGGGGGGGG:::@\xc8\xc877777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x150000000000000000000000000000000000000000000\x88$000'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x88\x88\x88\x88\x88\x88\x88\x88\x88XXXXXXXXXWWWWWWWWWWW\x15\x15\x15'
'0000000000000000\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'i000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x88\x8800000000000000000'
'\xd500000000000000000000000000\x9ao\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x88\x88\x88KKK00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x88\x88\x88$\x88\x88\x88\xa20@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\\\\x15\x15\x15\x15\x15\x15'
'\x8f\x8f\x8f\x8f\x8f\x8fi\x8f\x8f\x8f\x8f@@@\x08\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$0000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15'
'00000AA0000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcd\x15\x15\x15\x8f\x8fGGGGGGGGGG000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15GGGGGGGGGGX\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'00000000000000000000000@@::@\x15\x15\x88\x8800000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x88\x88\x88\x88\x88\x88\x88$\x88\x88\x88\x88\x88\x88\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15GGGGGGGGGG\x88\x88\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@@@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00GGGGGGGGGG000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x88\x88\x88\x88'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x88\x88\x88\x88\x88'
'GGGGGGGGGG\x15\x15\x15000GGGGGGGGGG000000000000000000000000000000$$$$$$\x88\x88'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x88\x88\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15@@@\x88@@@@@@@@@@@@@:@@@@@@@0000@0000::@00\x15@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15@@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\x1b\xa9'
'\xa9\xa9\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\xa9\xa9\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xa9\xa9\xa9\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xa9\xa9\xa9\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xa9\xa9\x15'
'\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\xd5\x08\x08\x08\n\x11hiihhh\x89\x8fwt\x99xvs\x99x\x89\x89\x89\x8f\x8a\x89\x89\x8a\xd1\xd2\x0b\x12\x0f\r\x14\xd3\x83\x85\x83\x83\x85\x89\x8f\x8f\x8fyu\x89\x8f\x8f\x89b'
'b\x8f\x8f\x8f\xad\x9ao\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\xba\x8fb\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\xd5\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08U%\x15\x15SUUUUU\xaf\xaf\xba\x9ao '
'USSSSUUUUU\xaf\xaf\xba\x9ao\x15%%%%%%%%%%%%%\x15\x15\x15\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa1\xa2\xa2\x9f\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\xa2\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd7\xca\xcd\xca\xcd7\xcd\xca\x1b777\x1b\x1b777\x19\xcd7\xca\xcd\xbc77777\xcd\xcd\xcd\xca\xca\xcd7\xcd5\xcd7\xcd7577\xc4\x1b7777\x1b0000\x1b\xcd\xcd\x1b\x1b77'
'\xbb\xba\xba\xba\xba7\x1b\x1b\x1b\x1b\xcd\xba\xcd\xcd\x1b\xc8\\\\\\ZZ\\\\\\\\\\\\ZZZZ\\IIIIIIIIIIIILLLLJJJJJJJJJJMMMMMM'
'KKK7\x1bKKKKZ\xcd\xcd\x15\x15\x15\x15\xb5\xb5\xb5\xb5\xb5\xca\xca\xca\xca\xca\xba\xba\xcd\xcd\xcd\xcd\xba\xcd\xcd\xba\xcd\xcd\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xcd\xcd\xb5\xcd\xb5\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xb5\xbb\xb6\xb6\xbb\xba\xba\xb5\xb6\xbb\xbb\xb6\xbb\xbb\xba\xb5\xba\xb6\xaf\xb3\xba\xb6\xbb\xba\xba\xba\xb6\xbb\xbb\xb6\xb5\xb6\xb6\xbb\xbb\xb5\xbb\xb5\xbb\xb5\xb5\xb5\xb5\xb6\xb6\xbb\xb6\xbb\xbb\xbb\xbb\xbb\xb5\xb5\xb5\xb5\xba\xbb\xba\xbb\xb6\xb6\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xb6\xbb\xbb\xbb\xb6\xba\xba\xba\xba\xba\xb6\xbb\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xb6\xb5\xbb\xba\xb6\xb6\xb6\xb6\xbb\xbb\xb6\xb6\xba\xba\xb6\xb6\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xb6\xb6\xbb\xbb\xb6\xb6\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xba\xba\xb5\xba\xba\xbb\xb5\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xb5\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xb6'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9ao\x9ao\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xbb\xbb\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9dr\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xcd\xba\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xc8\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcf\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15[[[[[[[[[ZZZZZZZZZZZ[[[[[[[[[ZZZ'
'ZZZZZZZZSSSSSSSSSRRRRRRRRRRR\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7]ZZZZZZZZZZ[[[[[[[[[Z['
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xca\xca\xca\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xca\xb5\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd'
'\xca\xb5\xcd\xcd\xcd\xcd\xca\xca\xca\xcd\xcd\xca\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xbf\xbf\xba'
'\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xca\xcd\xcd\xcd\xcd\xca\xca\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xca\xcd\xca\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xca\xca\xca\xcd\xca\xca\xca\xca\xcd\xca\xca\xcd\xb5\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xca\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xc8\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xca'
'\xcd\xcd\xcd\xcd\xcf\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xcf\xca\xca\xca\xca\xca\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcd\xca\xcd\xcd\xcd\xcd\xca\xca\xcf\xca\xca\xca\xca\xca\xca\xca\xcf\xcf\xca\xcf\xca\xca\xca\xca\xcf\xca\xca\xcf\xca\xca'
'\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xca\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao[[[[[[[[[Z'
']]]]]]]]]\\]]]]]]]]]\\\xcd\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf'
'\xbb\xba\xba\xbb\xbb\x9ao\xba\xbb\xbb\xba\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\x9bp\x9bp\x9bp\x9bp\x9ao\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\x9ao\x9bp\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\x9ao\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xba\xba\xba\xba\xba\xba\xba'
'\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xba\xba\x9ao\x9ao\xbb\xba\xba\xba\xba\xbb\xba\xbb\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\x9ao\xba\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xbb\xbb\xba\xba\xbb\xba\xbb\xba\xba\xbb\xba\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba'
'\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xba\xbb\xbb\xba\xba\xbb\xbb\xba\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb'
'\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xba\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xba\xba\xba\xba\xbb\xbb\xbb\xba\xba\xba\xba\xbb\xba\xba\xba\xbb\xbb\xbb\xbb\xbb\xba\xbb\xba\xba'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba\xba'
'\xba\xba\xba\xba\xba\xcd\xcd\xba\xba\xba\xba\xba\xba\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcf\xca\xca\xca\xca\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcd\xcd\xcd\xcd\xcd\xcd7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x8f\x8f\x8f\x8f\\\x8f\x8f'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x8f\x8fyuyu\x8f\x8f\x8fyu\x8fyu\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8fi\x8f\x8fi\x8fyu\x8f\x8fyu\x9ao\x9ao\x9ao\x9ao\x8f\x8f\x8f\x8f\x8f(\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8fii\x8f\x8f\x8f\x8f'
'i\x8f\x99\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15'
'\xd4\x93\x93\x93\xcf&1N\x9dr\x9dr\x9dr\x9dr\x9dr\xcf\xcf\x9dr\x9dr\x9dr\x9drj\x9cqq\xcfNNNNNNNNNBBBB;;j&&&&&\xcf\xcfNNN&1\x93\xcf\xcd'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15BB\xab\xab&&1j1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x93&&&1'
'\x15\x15\x15\x15\x1511111111111111111111111111111111111111111\x15\x15\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xc9\xc9YYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9111111111111111111111111111\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\x15YYYYYYYYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9VVVVVVVV\xcf^^^^^^^^^^^^^^^\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xc9'
'YYYYYYYYYY\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9^^^^^^^^^^^^^^^'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xcf\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xcf\xcf\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf\xcf\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xcf'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x88\x88'
'000000000000$\x8f\x8f\x8f0000000000000000GGGGGGGGGG00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x8f@@@@@@@@@@\x8f)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000KKKKKKKKKK@@\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15'
'\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9\xa9)))))))))\xa9\xa97\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa6\xa67\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77777\x1577777\x1b7\x1b\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcd\xcd\xcd\xcd\x15\x15\x15\x15WWWWWW\xc8\xc8\xa2\xc3\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x8f\x8f\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@@\x15\x15\x15\x15\x15\x15\x15\x15\x88\x88GGGGGGGGGG\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x88\x88\x880\x880\x15\x15'
'GGGGGGGGGG0000000000000000000000000000@@@@@@@@\x88\x880000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8811111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@:::'
':\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x15$GGGGGGGGGG\x15\x15\x15\x15\x88\x8800000@$000000000GGGGGGGGGG00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15GGGGGGGGGG\x15\x15\x88\x88\x88\x880000000000000000$000000\xc8\xc8\xc80:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x88\x8800000000000:@@::\x88\x880$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa6%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x88:@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xaf3333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5\xa5'
'\xa5\xa5\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,n\x99'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9e\xcd\x15\x15'
'>>>>>>>>>>>>>>>>\x93\x93\x93\x94\x93\x93\x93\x9cq\x93\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x93jjdd\x9cq\x9cq\x9cq\x9cq\x9cq\x9c'
'q\x9cq\x9cq\x93\x93\x9cq\x93\x93\x93\x93ddd\x81\x93\x82\x15\x93\x82\x93\x93j\x9dr\x9dr\x9dr\x87\x93\x93\xb1g\xc0\xc0\xbf\x15\x93\xa4\x87\x93\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8c\x8c\x84\xa0\x84\x8c\x8d\x97l\x8c\xae|e}|DDDDDDDDDD}\x8c\xb8\xb7\xb8\x8c\x8c66666666666666666666666666\x97\x8cl\xa8a'
'\xa8\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x97\xb7l\xb7\x97l\x8e\x98m\x8e\x8e.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\xa0\xa0\xb7\xa8\xcb\xa0\xa0\x15\xcc\xb9\xb9\xb9\xb9\xcc\xcc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcd\xca\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x88\x8f\x88\x15\x15\x15\x15WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\\\\\\\\\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\\\\\xcd\xc8\xc8\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@TTTTTTTTTTTTTTTTTTTTTTTTTTT\x15\x15\x15\x15'
'00000000000000000000000000000000WWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0K00000000K\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8800000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x88KKKKK\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x157777777777777777'
'77777777777777777777\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x95________33333333333333333333333\xd0\xd0_______'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15_________\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15_____'
'3333333333333333333333______\x15\x15\x15\x8f33333333333333333333333333\x15\x15\x15\x15\x15\x95'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15__33'
'________________\x15\x15______________________________________________'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x15333333333333333333333333333\x15\x15\x15\x15@@@\x15\x15\x15\x15@'
'````____\x15\x15\x15\x15\x15\x15\x15\x15\x95\x95\x95\x95\x95\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333__\x95'
'33333333333333333333333333333___\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xd03333333333333333333333333333@@\x15\x15\x15\x15_____\x95\x95\x95\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x8f\x8f\x8f\x8f\x8f\x8f\x8f'
'3333333333333333333333\x15\x15________3333333333333333333\x15\x15\x15\x15\x15________'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x95\x95\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15_______\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15______'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15QQQQQQQQQPPPPPPPPPPPPPPPPPPPPPP\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x88\x88\x88\x88\x88\x88\x88\x15\x15\x15\x15]]]]]]]]]\\\\\\\\\\\\\\\\\\\\\\GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x88\x88\n\x88\x88'
'\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15GGGGGGGGGG'
'\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x88\x880\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x88\x88\x88\x88\x88@@@\x88\x15\x15GGGGGGGGGG0\x880\x88\x88\x88\x15WWWWWWWWWWWWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x88\x88\x88\x88\x88\x88@\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x88\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000000000:::@@@@@@@@'
'::@@@:@0000\x88\x88\x88\x88\x88GGGGGGGGGG\x15\x88\x15\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x880\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x88\x880000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x88\x88\x880\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x8f\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@\x15\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000\x15\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15GGGGGGGGGGWW\x88\x88\x88\xc8'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bGGGGGGGGGGWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'000000000\x150000000000000000000000000000000000000:@@@@@@@\x15@@@@@@:='
'0\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGWWWWWWWWWWWWWWWWWWW\x15\x15\x15\x88\x8800000000000000'
'0000000000000000\x15\x15@@@@@@@@@@@@@@@@@@@@@@\x15:@@@@@@@:@@:@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x15\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15GGGGGGGGGG\x15\x15\x15\x15\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x88\x88\x88\x88\x88\xc8\xc8\xc8\xc8'
'$$$$\x88\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15WWWWWWW\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150::::::::::::::::::::::::::::::::::::::::::::::\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15&\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'11\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xc8@@\x88\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8::@@@\xc8\xc8\xc8::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xc8\xc8@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd@@@\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15WWWWWWWWWWWWWWWWWW\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb4\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xbb\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc8\xc8\xc8\xc8@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8@\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8@\xc8\xc8\x88\x88\x88\x88\x88\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@@@@\x15@@@@@@@@@@@@@@@@@\x15\x15@@@@@@@\x15@@\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15_________@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'9999999999999999999999999999999999\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'\x1d\x1d\x1d\x1d@@@@@@@\x15\x15\x15\x15\x15HHHHHHHHHH\x15\x15\x15\x15\x95\x95\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xba\xba\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'SSSSSSSSSSS\\\\\x15\x15\x15\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc8\x15\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc5\xc5\xc5\xc5\xc5\xc5\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xcd\xcd\x15\x15\x15\x15\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6'
'\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc5\xc5\xc5\xc5\xc9\xc5\xc5\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\xc5\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc9\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15\x15\x15\x15'
'\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\xc9\xc9\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcf\xcf\xcf\xab\xab\xab\xab\xab'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd'
'\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcd\xcd\xcd\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcf\xcf\x15\x15\x15\xcd\xcd\xcd\xcd\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd'
'\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\xcd\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x15\x15'
'\x15\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x15'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3416: 1.0 / 160.0,
3417: 1.0 / 40.0,
3418: 3.0 / 80.0,
3419: 1.0 / 20.0,
3420: 1.0 / 10.0,
3421: 3.0 / 20.0,
3422: 1.0 / 5.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3446: 1.0 / 16.0,
3447: 1.0 / 8.0,
3448: 3.0 / 16.0,
3558: 0.0,
3559: 1.0,
3560: 2.0,
3561: 3.0,
3562: 4.0,
3563: 5.0,
3564: 6.0,
3565: 7.0,
3566: 8.0,
3567: 9.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43504: 0.0,
43505: 1.0,
43506: 2.0,
43507: 3.0,
43508: 4.0,
43509: 5.0,
43510: 6.0,
43511: 7.0,
43512: 8.0,
43513: 9.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65931: 1.0 / 4.0,
66273: 1.0,
66274: 2.0,
66275: 3.0,
66276: 4.0,
66277: 5.0,
66278: 6.0,
66279: 7.0,
66280: 8.0,
66281: 9.0,
66282: 10.0,
66283: 20.0,
66284: 30.0,
66285: 40.0,
66286: 50.0,
66287: 60.0,
66288: 70.0,
66289: 80.0,
66290: 90.0,
66291: 100.0,
66292: 200.0,
66293: 300.0,
66294: 400.0,
66295: 500.0,
66296: 600.0,
66297: 700.0,
66298: 800.0,
66299: 900.0,
67705: 1.0,
67706: 2.0,
67707: 3.0,
67708: 4.0,
67709: 5.0,
67710: 10.0,
67711: 20.0,
67751: 1.0,
67752: 2.0,
67753: 3.0,
67754: 4.0,
67755: 4.0,
67756: 5.0,
67757: 10.0,
67758: 20.0,
67759: 100.0,
67835: 1.0,
67836: 5.0,
67837: 10.0,
67838: 20.0,
67839: 100.0,
68028: 11.0 / 12.0,
68029: 1.0 / 2.0,
68032: 1.0,
68033: 2.0,
68034: 3.0,
68035: 4.0,
68036: 5.0,
68037: 6.0,
68038: 7.0,
68039: 8.0,
68040: 9.0,
68041: 10.0,
68042: 20.0,
68043: 30.0,
68044: 40.0,
68045: 50.0,
68046: 60.0,
68047: 70.0,
68050: 100.0,
68051: 200.0,
68052: 300.0,
68053: 400.0,
68054: 500.0,
68055: 600.0,
68056: 700.0,
68057: 800.0,
68058: 900.0,
68059: 1000.0,
68060: 2000.0,
68061: 3000.0,
68062: 4000.0,
68063: 5000.0,
68064: 6000.0,
68065: 7000.0,
68066: 8000.0,
68067: 9000.0,
68068: 10000.0,
68069: 20000.0,
68070: 30000.0,
68071: 40000.0,
68072: 50000.0,
68073: 60000.0,
68074: 70000.0,
68075: 80000.0,
68076: 90000.0,
68077: 100000.0,
68078: 200000.0,
68079: 300000.0,
68080: 400000.0,
68081: 500000.0,
68082: 600000.0,
68083: 700000.0,
68084: 800000.0,
68085: 900000.0,
68086: 1.0 / 12.0,
68087: 2.0 / 12.0,
68088: 3.0 / 12.0,
68089: 4.0 / 12.0,
68090: 5.0 / 12.0,
68091: 6.0 / 12.0,
68092: 7.0 / 12.0,
68093: 8.0 / 12.0,
68094: 9.0 / 12.0,
68095: 10.0 / 12.0,
68253: 1.0,
68254: 10.0,
68255: 20.0,
68331: 1.0,
68332: 5.0,
68333: 10.0,
68334: 20.0,
68335: 100.0,
68521: 1.0,
68522: 2.0,
68523: 3.0,
68524: 4.0,
68525: 10.0,
68526: 20.0,
68527: 100.0,
68858: 1.0,
68859: 5.0,
68860: 10.0,
68861: 50.0,
68862: 100.0,
68863: 1000.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
70113: 1.0,
70114: 2.0,
70115: 3.0,
70116: 4.0,
70117: 5.0,
70118: 6.0,
70119: 7.0,
70120: 8.0,
70121: 9.0,
70122: 10.0,
70123: 20.0,
70124: 30.0,
70125: 40.0,
70126: 50.0,
70127: 60.0,
70128: 70.0,
70129: 80.0,
70130: 90.0,
70131: 100.0,
70132: 1000.0,
70384: 0.0,
70385: 1.0,
70386: 2.0,
70387: 3.0,
70388: 4.0,
70389: 5.0,
70390: 6.0,
70391: 7.0,
70392: 8.0,
70393: 9.0,
70736: 0.0,
70737: 1.0,
70738: 2.0,
70739: 3.0,
70740: 4.0,
70741: 5.0,
70742: 6.0,
70743: 7.0,
70744: 8.0,
70745: 9.0,
70864: 0.0,
70865: 1.0,
70866: 2.0,
70867: 3.0,
70868: 4.0,
70869: 5.0,
70870: 6.0,
70871: 7.0,
70872: 8.0,
70873: 9.0,
71248: 0.0,
71249: 1.0,
71250: 2.0,
71251: 3.0,
71252: 4.0,
71253: 5.0,
71254: 6.0,
71255: 7.0,
71256: 8.0,
71257: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
71472: 0.0,
71473: 1.0,
71474: 2.0,
71475: 3.0,
71476: 4.0,
71477: 5.0,
71478: 6.0,
71479: 7.0,
71480: 8.0,
71481: 9.0,
71482: 10.0,
71483: 20.0,
71904: 0.0,
71905: 1.0,
71906: 2.0,
71907: 3.0,
71908: 4.0,
71909: 5.0,
71910: 6.0,
71911: 7.0,
71912: 8.0,
71913: 9.0,
71914: 10.0,
71915: 20.0,
71916: 30.0,
71917: 40.0,
71918: 50.0,
71919: 60.0,
71920: 70.0,
71921: 80.0,
71922: 90.0,
72784: 0.0,
72785: 1.0,
72786: 2.0,
72787: 3.0,
72788: 4.0,
72789: 5.0,
72790: 6.0,
72791: 7.0,
72792: 8.0,
72793: 9.0,
72794: 1.0,
72795: 2.0,
72796: 3.0,
72797: 4.0,
72798: 5.0,
72799: 6.0,
72800: 7.0,
72801: 8.0,
72802: 9.0,
72803: 10.0,
72804: 20.0,
72805: 30.0,
72806: 40.0,
72807: 50.0,
72808: 60.0,
72809: 70.0,
72810: 80.0,
72811: 90.0,
72812: 100.0,
74802: 216000.0,
74803: 432000.0,
74838: 2.0,
74839: 3.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
74851: 1.0 / 4.0,
74852: 1.0 / 2.0,
74853: 1.0 / 3.0,
74854: 2.0 / 3.0,
74855: 40.0,
74856: 50.0,
74857: 4.0,
74858: 5.0,
74859: 6.0,
74860: 7.0,
74861: 8.0,
74862: 9.0,
92768: 0.0,
92769: 1.0,
92770: 2.0,
92771: 3.0,
92772: 4.0,
92773: 5.0,
92774: 6.0,
92775: 7.0,
92776: 8.0,
92777: 9.0,
93008: 0.0,
93009: 1.0,
93010: 2.0,
93011: 3.0,
93012: 4.0,
93013: 5.0,
93014: 6.0,
93015: 7.0,
93016: 8.0,
93017: 9.0,
93019: 10.0,
93020: 100.0,
93021: 10000.0,
93022: 1000000.0,
93023: 100000000.0,
93024: 10000000000.0,
93025: 1000000000000.0,
125127: 1.0,
125128: 2.0,
125129: 3.0,
125130: 4.0,
125131: 5.0,
125132: 6.0,
125133: 7.0,
125134: 8.0,
125135: 9.0,
125264: 0.0,
125265: 1.0,
125266: 2.0,
125267: 3.0,
125268: 4.0,
125269: 5.0,
125270: 6.0,
125271: 7.0,
125272: 8.0,
125273: 9.0,
127243: 0.0,
127244: 0.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_toupper_corrected = {
}
_tolower = {
895: 1011,
1318: 1319,
1320: 1321,
1322: 1323,
1324: 1325,
1326: 1327,
4295: 11559,
4301: 11565,
5024: 43888,
5025: 43889,
5026: 43890,
5027: 43891,
5028: 43892,
5029: 43893,
5030: 43894,
5031: 43895,
5032: 43896,
5033: 43897,
5034: 43898,
5035: 43899,
5036: 43900,
5037: 43901,
5038: 43902,
5039: 43903,
5040: 43904,
5041: 43905,
5042: 43906,
5043: 43907,
5044: 43908,
5045: 43909,
5046: 43910,
5047: 43911,
5048: 43912,
5049: 43913,
5050: 43914,
5051: 43915,
5052: 43916,
5053: 43917,
5054: 43918,
5055: 43919,
5056: 43920,
5057: 43921,
5058: 43922,
5059: 43923,
5060: 43924,
5061: 43925,
5062: 43926,
5063: 43927,
5064: 43928,
5065: 43929,
5066: 43930,
5067: 43931,
5068: 43932,
5069: 43933,
5070: 43934,
5071: 43935,
5072: 43936,
5073: 43937,
5074: 43938,
5075: 43939,
5076: 43940,
5077: 43941,
5078: 43942,
5079: 43943,
5080: 43944,
5081: 43945,
5082: 43946,
5083: 43947,
5084: 43948,
5085: 43949,
5086: 43950,
5087: 43951,
5088: 43952,
5089: 43953,
5090: 43954,
5091: 43955,
5092: 43956,
5093: 43957,
5094: 43958,
5095: 43959,
5096: 43960,
5097: 43961,
5098: 43962,
5099: 43963,
5100: 43964,
5101: 43965,
5102: 43966,
5103: 43967,
5104: 5112,
5105: 5113,
5106: 5114,
5107: 5115,
5108: 5116,
5109: 5117,
11506: 11507,
42592: 42593,
42648: 42649,
42650: 42651,
42893: 613,
42896: 42897,
42898: 42899,
42902: 42903,
42904: 42905,
42906: 42907,
42908: 42909,
42910: 42911,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
42923: 604,
42924: 609,
42925: 620,
42926: 618,
42928: 670,
42929: 647,
42930: 669,
42931: 43859,
42932: 42933,
42934: 42935,
66736: 66776,
66737: 66777,
66738: 66778,
66739: 66779,
66740: 66780,
66741: 66781,
66742: 66782,
66743: 66783,
66744: 66784,
66745: 66785,
66746: 66786,
66747: 66787,
66748: 66788,
66749: 66789,
66750: 66790,
66751: 66791,
66752: 66792,
66753: 66793,
66754: 66794,
66755: 66795,
66756: 66796,
66757: 66797,
66758: 66798,
66759: 66799,
66760: 66800,
66761: 66801,
66762: 66802,
66763: 66803,
66764: 66804,
66765: 66805,
66766: 66806,
66767: 66807,
66768: 66808,
66769: 66809,
66770: 66810,
66771: 66811,
68736: 68800,
68737: 68801,
68738: 68802,
68739: 68803,
68740: 68804,
68741: 68805,
68742: 68806,
68743: 68807,
68744: 68808,
68745: 68809,
68746: 68810,
68747: 68811,
68748: 68812,
68749: 68813,
68750: 68814,
68751: 68815,
68752: 68816,
68753: 68817,
68754: 68818,
68755: 68819,
68756: 68820,
68757: 68821,
68758: 68822,
68759: 68823,
68760: 68824,
68761: 68825,
68762: 68826,
68763: 68827,
68764: 68828,
68765: 68829,
68766: 68830,
68767: 68831,
68768: 68832,
68769: 68833,
68770: 68834,
68771: 68835,
68772: 68836,
68773: 68837,
68774: 68838,
68775: 68839,
68776: 68840,
68777: 68841,
68778: 68842,
68779: 68843,
68780: 68844,
68781: 68845,
68782: 68846,
68783: 68847,
68784: 68848,
68785: 68849,
68786: 68850,
71840: 71872,
71841: 71873,
71842: 71874,
71843: 71875,
71844: 71876,
71845: 71877,
71846: 71878,
71847: 71879,
71848: 71880,
71849: 71881,
71850: 71882,
71851: 71883,
71852: 71884,
71853: 71885,
71854: 71886,
71855: 71887,
71856: 71888,
71857: 71889,
71858: 71890,
71859: 71891,
71860: 71892,
71861: 71893,
71862: 71894,
71863: 71895,
71864: 71896,
71865: 71897,
71866: 71898,
71867: 71899,
71868: 71900,
71869: 71901,
71870: 71902,
71871: 71903,
125184: 125218,
125185: 125219,
125186: 125220,
125187: 125221,
125188: 125222,
125189: 125223,
125190: 125224,
125191: 125225,
125192: 125226,
125193: 125227,
125194: 125228,
125195: 125229,
125196: 125230,
125197: 125231,
125198: 125232,
125199: 125233,
125200: 125234,
125201: 125235,
125202: 125236,
125203: 125237,
125204: 125238,
125205: 125239,
125206: 125240,
125207: 125241,
125208: 125242,
125209: 125243,
125210: 125244,
125211: 125245,
125212: 125246,
125213: 125247,
125214: 125248,
125215: 125249,
125216: 125250,
125217: 125251,
}

_tolower_corrected = {
}
_totitle = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
42652: '<super> 044A',
42653: '<super> 044C',
43000: '<super> 0126',
43001: '<super> 0153',
43868: '<super> A727',
43869: '<super> AB37',
43870: '<super> 026B',
43871: '<super> AB52',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
70475: '11347 1133E',
70476: '11347 11357',
70843: '114B9 114BA',
70844: '114B9 114B0',
70846: '114B9 114BD',
71098: '115B8 115AF',
71099: '115B9 115AF',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127547: '<square> 914D',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
r_longlong(70471 << 32 | 70462): 70475,
r_longlong(70471 << 32 | 70487): 70476,
r_longlong(70841 << 32 | 70842): 70843,
r_longlong(70841 << 32 | 70832): 70844,
r_longlong(70841 << 32 | 70845): 70846,
r_longlong(71096 << 32 | 71087): 71098,
r_longlong(71097 << 32 | 71087): 71099,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
42652: [1098],
42653: [1100],
43000: [294],
43001: [339],
43868: [42791],
43869: [43831],
43870: [619],
43871: [43858],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127547: [37197],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0626\u0627',
u'\u0626\u0648',
u'\u0626\u0649',
u'\u0626\u06c6',
u'\u0626\u06c7',
u'\u0626\u06c8',
u'\u0626\u06d0',
u'\u0626\u06d5',
u'\u0646\u06a9',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1564,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8294,
8295,
8296,
8297,
8472,
9288,
9289,
11130,
11132,
40981,
65048,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65279,
65279,
65279,
74452,
74453,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
5024: [5024],
5025: [5025],
5026: [5026],
5027: [5027],
5028: [5028],
5029: [5029],
5030: [5030],
5031: [5031],
5032: [5032],
5033: [5033],
5034: [5034],
5035: [5035],
5036: [5036],
5037: [5037],
5038: [5038],
5039: [5039],
5040: [5040],
5041: [5041],
5042: [5042],
5043: [5043],
5044: [5044],
5045: [5045],
5046: [5046],
5047: [5047],
5048: [5048],
5049: [5049],
5050: [5050],
5051: [5051],
5052: [5052],
5053: [5053],
5054: [5054],
5055: [5055],
5056: [5056],
5057: [5057],
5058: [5058],
5059: [5059],
5060: [5060],
5061: [5061],
5062: [5062],
5063: [5063],
5064: [5064],
5065: [5065],
5066: [5066],
5067: [5067],
5068: [5068],
5069: [5069],
5070: [5070],
5071: [5071],
5072: [5072],
5073: [5073],
5074: [5074],
5075: [5075],
5076: [5076],
5077: [5077],
5078: [5078],
5079: [5079],
5080: [5080],
5081: [5081],
5082: [5082],
5083: [5083],
5084: [5084],
5085: [5085],
5086: [5086],
5087: [5087],
5088: [5088],
5089: [5089],
5090: [5090],
5091: [5091],
5092: [5092],
5093: [5093],
5094: [5094],
5095: [5095],
5096: [5096],
5097: [5097],
5098: [5098],
5099: [5099],
5100: [5100],
5101: [5101],
5102: [5102],
5103: [5103],
5104: [5104],
5105: [5105],
5106: [5106],
5107: [5107],
5108: [5108],
5109: [5109],
5112: [5104],
5113: [5105],
5114: [5106],
5115: [5107],
5116: [5108],
5117: [5109],
7296: [1074],
7297: [1076],
7298: [1086],
7299: [1089],
7300: [1090],
7301: [1090],
7302: [1098],
7303: [1123],
7304: [42571],
43888: [5024],
43889: [5025],
43890: [5026],
43891: [5027],
43892: [5028],
43893: [5029],
43894: [5030],
43895: [5031],
43896: [5032],
43897: [5033],
43898: [5034],
43899: [5035],
43900: [5036],
43901: [5037],
43902: [5038],
43903: [5039],
43904: [5040],
43905: [5041],
43906: [5042],
43907: [5043],
43908: [5044],
43909: [5045],
43910: [5046],
43911: [5047],
43912: [5048],
43913: [5049],
43914: [5050],
43915: [5051],
43916: [5052],
43917: [5053],
43918: [5054],
43919: [5055],
43920: [5056],
43921: [5057],
43922: [5058],
43923: [5059],
43924: [5060],
43925: [5061],
43926: [5062],
43927: [5063],
43928: [5064],
43929: [5065],
43930: [5066],
43931: [5067],
43932: [5068],
43933: [5069],
43934: [5070],
43935: [5071],
43936: [5072],
43937: [5073],
43938: [5074],
43939: [5075],
43940: [5076],
43941: [5077],
43942: [5078],
43943: [5079],
43944: [5080],
43945: [5081],
43946: [5082],
43947: [5083],
43948: [5084],
43949: [5085],
43950: [5086],
43951: [5087],
43952: [5088],
43953: [5089],
43954: [5090],
43955: [5091],
43956: [5092],
43957: [5093],
43958: [5094],
43959: [5095],
43960: [5096],
43961: [5097],
43962: [5098],
43963: [5099],
43964: [5100],
43965: [5101],
43966: [5102],
43967: [5103],
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2137: 220,
2138: 220,
2139: 220,
2260: 230,
2261: 230,
2262: 230,
2263: 230,
2264: 230,
2265: 230,
2266: 230,
2267: 230,
2268: 230,
2269: 230,
2270: 230,
2271: 230,
2272: 230,
2273: 230,
2275: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
2303: 230,
4957: 230,
4958: 230,
6832: 230,
6833: 230,
6834: 230,
6835: 230,
6836: 230,
6837: 220,
6838: 220,
6839: 220,
6840: 220,
6841: 220,
6842: 220,
6843: 230,
6844: 230,
6845: 220,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7416: 230,
7417: 230,
7655: 230,
7656: 230,
7657: 230,
7658: 230,
7659: 230,
7660: 230,
7661: 230,
7662: 230,
7663: 230,
7664: 230,
7665: 230,
7666: 230,
7667: 230,
7668: 230,
7669: 230,
7675: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42654: 230,
42655: 230,
43766: 9,
65063: 220,
65064: 220,
65065: 220,
65066: 220,
65067: 220,
65068: 220,
65069: 220,
65070: 230,
65071: 230,
66272: 220,
66422: 230,
66423: 230,
66424: 230,
66425: 230,
66426: 230,
68325: 230,
68326: 220,
69702: 9,
69759: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70003: 7,
70080: 9,
70090: 7,
70197: 9,
70198: 7,
70377: 7,
70378: 9,
70460: 7,
70477: 9,
70502: 230,
70503: 230,
70504: 230,
70505: 230,
70506: 230,
70507: 230,
70508: 230,
70512: 230,
70513: 230,
70514: 230,
70515: 230,
70516: 230,
70722: 9,
70726: 7,
70850: 9,
70851: 7,
71103: 9,
71104: 7,
71231: 9,
71350: 9,
71351: 7,
71467: 9,
72767: 9,
92912: 1,
92913: 1,
92914: 1,
92915: 1,
92916: 1,
92976: 230,
92977: 230,
92978: 230,
92979: 230,
92980: 230,
92981: 230,
92982: 230,
113822: 1,
122880: 230,
122881: 230,
122882: 230,
122883: 230,
122884: 230,
122885: 230,
122886: 230,
122888: 230,
122889: 230,
122890: 230,
122891: 230,
122892: 230,
122893: 230,
122894: 230,
122895: 230,
122896: 230,
122897: 230,
122898: 230,
122899: 230,
122900: 230,
122901: 230,
122902: 230,
122903: 230,
122904: 230,
122907: 230,
122908: 230,
122909: 230,
122910: 230,
122911: 230,
122912: 230,
122913: 230,
122915: 230,
122916: 230,
122918: 230,
122919: 230,
122920: 230,
122921: 230,
122922: 230,
125136: 220,
125137: 220,
125138: 220,
125139: 220,
125140: 220,
125141: 220,
125142: 220,
125252: 230,
125253: 230,
125254: 230,
125255: 230,
125256: 230,
125257: 230,
125258: 7,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

