'''OpenGL extension ARB.gpu_shader_fp64

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.gpu_shader_fp64 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows GLSL shaders to use double-precision floating-point
	data types, including vectors and matrices of doubles.  Doubles may be
	used as inputs, outputs, and uniforms.  
	
	The shading language supports various arithmetic and comparison operators
	on double-precision scalar, vector, and matrix types, and provides a set
	of built-in functions including:
	
	  * square roots and inverse square roots;
	
	  * fused floating-point multiply-add operations;
	
	  * splitting a floating-point number into a significand and exponent
	    (frexp), or building a floating-point number from a significand and
	    exponent (ldexp);
	
	  * absolute value, sign tests, various functions to round to an integer
	    value, modulus, minimum, maximum, clamping, blending two values, step
	    functions, and testing for infinity and NaN values;
	
	  * packing and unpacking doubles into a pair of 32-bit unsigned integers;
	
	  * matrix component-wise multiplication, and computation of outer
	    products, transposes, determinants, and inverses; and
	
	  * vector relational functions.
	
	Double-precision versions of angle, trigonometry, and exponential
	functions are not supported.
	
	Implicit conversions are supported from integer and single-precision
	floating-point values to doubles, and this extension uses the relaxed
	function overloading rules specified by the ARB_gpu_shader5 extension to
	resolve ambiguities.
	
	This extension provides API functions for specifying double-precision
	uniforms in the default uniform block, including functions similar to the
	uniform functions added by EXT_direct_state_access (if supported).
	
	This extension provides an "LF" suffix for specifying double-precision
	constants.  Floating-point constants without a suffix in GLSL are treated
	as single-precision values for backward compatibility with versions not
	supporting doubles; similar constants are treated as double-precision
	values in the "C" programming language.
	
	This extension does not support interpolation of double-precision values;
	doubles used as fragment shader inputs must be qualified as "flat".
	Additionally, this extension does not allow vertex attributes with 64-bit
	components.  That support is added separately by EXT_vertex_attrib_64bit.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/gpu_shader_fp64.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.ARB.gpu_shader_fp64 import *
### END AUTOGENERATED SECTION