# _dicom_dict.py
"""DICOM data dictionary auto-generated by csv2dict2011.py"""

DicomDictionary = {
0x00020000: ('UL', '1', "File Meta Information Group Length", '', 'FileMetaInformationGroupLength'),
0x00020001: ('OB', '1', "File Meta Information Version", '', 'FileMetaInformationVersion'),
0x00020002: ('UI', '1', "Media Storage SOP Class UID", '', 'MediaStorageSOPClassUID'),
0x00020003: ('UI', '1', "Media Storage SOP Instance UID", '', 'MediaStorageSOPInstanceUID'),
0x00020010: ('UI', '1', "Transfer Syntax UID", '', 'TransferSyntaxUID'),
0x00020012: ('UI', '1', "Implementation Class UID", '', 'ImplementationClassUID'),
0x00020013: ('SH', '1', "Implementation Version Name", '', 'ImplementationVersionName'),
0x00020016: ('AE', '1', "Source Application Entity Title", '', 'SourceApplicationEntityTitle'),
0x00020100: ('UI', '1', "Private Information Creator UID", '', 'PrivateInformationCreatorUID'),
0x00020102: ('OB', '1', "Private Information", '', 'PrivateInformation'),
0x00041130: ('CS', '1', "File-set ID", '', 'FileSetID'),
0x00041141: ('CS', '1-8', "File-set Descriptor File ID", '', 'FileSetDescriptorFileID'),
0x00041142: ('CS', '1', "Specific Character Set of File-set Descriptor File", '', 'SpecificCharacterSetOfFileSetDescriptorFile'),
0x00041200: ('UL', '1', "Offset of the First Directory Record of the Root Directory Entity", '', 'OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity'),
0x00041202: ('UL', '1', "Offset of the Last Directory Record of the Root Directory Entity", '', 'OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity'),
0x00041212: ('US', '1', "File-set Consistency Flag", '', 'FileSetConsistencyFlag'),
0x00041220: ('SQ', '1', "Directory Record Sequence", '', 'DirectoryRecordSequence'),
0x00041400: ('UL', '1', "Offset of the Next Directory Record", '', 'OffsetOfTheNextDirectoryRecord'),
0x00041410: ('US', '1', "Record In-use Flag", '', 'RecordInUseFlag'),
0x00041420: ('UL', '1', "Offset of Referenced Lower-Level Directory Entity", '', 'OffsetOfReferencedLowerLevelDirectoryEntity'),
0x00041430: ('CS', '1', "Directory Record Type", '', 'DirectoryRecordType'),
0x00041432: ('UI', '1', "Private Record UID", '', 'PrivateRecordUID'),
0x00041500: ('CS', '1-8', "Referenced File ID", '', 'ReferencedFileID'),
0x00041504: ('UL', '1', "MRDR Directory Record Offset", 'Retired', 'MRDRDirectoryRecordOffset'),
0x00041510: ('UI', '1', "Referenced SOP Class UID in File", '', 'ReferencedSOPClassUIDInFile'),
0x00041511: ('UI', '1', "Referenced SOP Instance UID in File", '', 'ReferencedSOPInstanceUIDInFile'),
0x00041512: ('UI', '1', "Referenced Transfer Syntax UID in File", '', 'ReferencedTransferSyntaxUIDInFile'),
0x0004151A: ('UI', '1-n', "Referenced Related General SOP Class UID in File", '', 'ReferencedRelatedGeneralSOPClassUIDInFile'),
0x00041600: ('UL', '1', "Number of References", 'Retired', 'NumberOfReferences'),
0x00080001: ('UL', '1', "Length to End", 'Retired', 'LengthToEnd'),
0x00080005: ('CS', '1-n', "Specific Character Set", '', 'SpecificCharacterSet'),
0x00080006: ('SQ', '1', "Language Code Sequence", '', 'LanguageCodeSequence'),
0x00080008: ('CS', '2-n', "Image Type", '', 'ImageType'),
0x00080010: ('SH', '1', "Recognition Code", 'Retired', 'RecognitionCode'),
0x00080012: ('DA', '1', "Instance Creation Date", '', 'InstanceCreationDate'),
0x00080013: ('TM', '1', "Instance Creation Time", '', 'InstanceCreationTime'),
0x00080014: ('UI', '1', "Instance Creator UID", '', 'InstanceCreatorUID'),
0x00080016: ('UI', '1', "SOP Class UID", '', 'SOPClassUID'),
0x00080018: ('UI', '1', "SOP Instance UID", '', 'SOPInstanceUID'),
0x0008001A: ('UI', '1-n', "Related General SOP Class UID", '', 'RelatedGeneralSOPClassUID'),
0x0008001B: ('UI', '1', "Original Specialized SOP Class UID", '', 'OriginalSpecializedSOPClassUID'),
0x00080020: ('DA', '1', "Study Date", '', 'StudyDate'),
0x00080021: ('DA', '1', "Series Date", '', 'SeriesDate'),
0x00080022: ('DA', '1', "Acquisition Date", '', 'AcquisitionDate'),
0x00080023: ('DA', '1', "Content Date", '', 'ContentDate'),
0x00080024: ('DA', '1', "Overlay Date", 'Retired', 'OverlayDate'),
0x00080025: ('DA', '1', "Curve Date", 'Retired', 'CurveDate'),
0x0008002A: ('DT', '1', "Acquisition DateTime", '', 'AcquisitionDateTime'),
0x00080030: ('TM', '1', "Study Time", '', 'StudyTime'),
0x00080031: ('TM', '1', "Series Time", '', 'SeriesTime'),
0x00080032: ('TM', '1', "Acquisition Time", '', 'AcquisitionTime'),
0x00080033: ('TM', '1', "Content Time", '', 'ContentTime'),
0x00080034: ('TM', '1', "Overlay Time", 'Retired', 'OverlayTime'),
0x00080035: ('TM', '1', "Curve Time", 'Retired', 'CurveTime'),
0x00080040: ('US', '1', "Data Set Type", 'Retired', 'DataSetType'),
0x00080041: ('LO', '1', "Data Set Subtype", 'Retired', 'DataSetSubtype'),
0x00080042: ('CS', '1', "Nuclear Medicine Series Type", 'Retired', 'NuclearMedicineSeriesType'),
0x00080050: ('SH', '1', "Accession Number", '', 'AccessionNumber'),
0x00080051: ('SQ', '1', "Issuer of Accession Number Sequence", '', 'IssuerOfAccessionNumberSequence'),
0x00080052: ('CS', '1', "Query/Retrieve Level", '', 'QueryRetrieveLevel'),
0x00080054: ('AE', '1-n', "Retrieve AE Title", '', 'RetrieveAETitle'),
0x00080056: ('CS', '1', "Instance Availability", '', 'InstanceAvailability'),
0x00080058: ('UI', '1-n', "Failed SOP Instance UID List", '', 'FailedSOPInstanceUIDList'),
0x00080060: ('CS', '1', "Modality", '', 'Modality'),
0x00080061: ('CS', '1-n', "Modalities in Study", '', 'ModalitiesInStudy'),
0x00080062: ('UI', '1-n', "SOP Classes in Study", '', 'SOPClassesInStudy'),
0x00080064: ('CS', '1', "Conversion Type", '', 'ConversionType'),
0x00080068: ('CS', '1', "Presentation Intent Type", '', 'PresentationIntentType'),
0x00080070: ('LO', '1', "Manufacturer", '', 'Manufacturer'),
0x00080080: ('LO', '1', "Institution Name", '', 'InstitutionName'),
0x00080081: ('ST', '1', "Institution Address", '', 'InstitutionAddress'),
0x00080082: ('SQ', '1', "Institution Code Sequence", '', 'InstitutionCodeSequence'),
0x00080090: ('PN', '1', "Referring Physician's Name", '', 'ReferringPhysicianName'),
0x00080092: ('ST', '1', "Referring Physician's Address", '', 'ReferringPhysicianAddress'),
0x00080094: ('SH', '1-n', "Referring Physician's Telephone Numbers", '', 'ReferringPhysicianTelephoneNumbers'),
0x00080096: ('SQ', '1', "Referring Physician Identification Sequence", '', 'ReferringPhysicianIdentificationSequence'),
0x00080100: ('SH', '1', "Code Value", '', 'CodeValue'),
0x00080102: ('SH', '1', "Coding Scheme Designator", '', 'CodingSchemeDesignator'),
0x00080103: ('SH', '1', "Coding Scheme Version", '', 'CodingSchemeVersion'),
0x00080104: ('LO', '1', "Code Meaning", '', 'CodeMeaning'),
0x00080105: ('CS', '1', "Mapping Resource", '', 'MappingResource'),
0x00080106: ('DT', '1', "Context Group Version", '', 'ContextGroupVersion'),
0x00080107: ('DT', '1', "Context Group Local Version", '', 'ContextGroupLocalVersion'),
0x0008010B: ('CS', '1', "Context Group Extension Flag", '', 'ContextGroupExtensionFlag'),
0x0008010C: ('UI', '1', "Coding Scheme UID", '', 'CodingSchemeUID'),
0x0008010D: ('UI', '1', "Context Group Extension Creator UID", '', 'ContextGroupExtensionCreatorUID'),
0x0008010F: ('CS', '1', "Context Identifier", '', 'ContextIdentifier'),
0x00080110: ('SQ', '1', "Coding Scheme Identification Sequence", '', 'CodingSchemeIdentificationSequence'),
0x00080112: ('LO', '1', "Coding Scheme Registry", '', 'CodingSchemeRegistry'),
0x00080114: ('ST', '1', "Coding Scheme External ID", '', 'CodingSchemeExternalID'),
0x00080115: ('ST', '1', "Coding Scheme Name", '', 'CodingSchemeName'),
0x00080116: ('ST', '1', "Coding Scheme Responsible Organization", '', 'CodingSchemeResponsibleOrganization'),
0x00080117: ('UI', '1', "Context UID", '', 'ContextUID'),
0x00080201: ('SH', '1', "Timezone Offset From UTC", '', 'TimezoneOffsetFromUTC'),
0x00081000: ('AE', '1', "Network ID", 'Retired', 'NetworkID'),
0x00081010: ('SH', '1', "Station Name", '', 'StationName'),
0x00081030: ('LO', '1', "Study Description", '', 'StudyDescription'),
0x00081032: ('SQ', '1', "Procedure Code Sequence", '', 'ProcedureCodeSequence'),
0x0008103E: ('LO', '1', "Series Description", '', 'SeriesDescription'),
0x0008103F: ('SQ', '1', "Series Description Code Sequence", '', 'SeriesDescriptionCodeSequence'),
0x00081040: ('LO', '1', "Institutional Department Name", '', 'InstitutionalDepartmentName'),
0x00081048: ('PN', '1-n', "Physician(s) of Record", '', 'PhysiciansOfRecord'),
0x00081049: ('SQ', '1', "Physician(s) of Record Identification Sequence", '', 'PhysiciansOfRecordIdentificationSequence'),
0x00081050: ('PN', '1-n', "Performing Physician's Name", '', 'PerformingPhysicianName'),
0x00081052: ('SQ', '1', "Performing Physician Identification Sequence", '', 'PerformingPhysicianIdentificationSequence'),
0x00081060: ('PN', '1-n', "Name of Physician(s) Reading Study", '', 'NameOfPhysiciansReadingStudy'),
0x00081062: ('SQ', '1', "Physician(s) Reading Study Identification Sequence", '', 'PhysiciansReadingStudyIdentificationSequence'),
0x00081070: ('PN', '1-n', "Operators' Name", '', 'OperatorsName'),
0x00081072: ('SQ', '1', "Operator Identification Sequence", '', 'OperatorIdentificationSequence'),
0x00081080: ('LO', '1-n', "Admitting Diagnoses Description", '', 'AdmittingDiagnosesDescription'),
0x00081084: ('SQ', '1', "Admitting Diagnoses Code Sequence", '', 'AdmittingDiagnosesCodeSequence'),
0x00081090: ('LO', '1', "Manufacturer's Model Name", '', 'ManufacturerModelName'),
0x00081100: ('SQ', '1', "Referenced Results Sequence", 'Retired', 'ReferencedResultsSequence'),
0x00081110: ('SQ', '1', "Referenced Study Sequence", '', 'ReferencedStudySequence'),
0x00081111: ('SQ', '1', "Referenced Performed Procedure Step Sequence", '', 'ReferencedPerformedProcedureStepSequence'),
0x00081115: ('SQ', '1', "Referenced Series Sequence", '', 'ReferencedSeriesSequence'),
0x00081120: ('SQ', '1', "Referenced Patient Sequence", '', 'ReferencedPatientSequence'),
0x00081125: ('SQ', '1', "Referenced Visit Sequence", '', 'ReferencedVisitSequence'),
0x00081130: ('SQ', '1', "Referenced Overlay Sequence", 'Retired', 'ReferencedOverlaySequence'),
0x00081134: ('SQ', '1', "Referenced Stereometric Instance Sequence", '', 'ReferencedStereometricInstanceSequence'),
0x0008113A: ('SQ', '1', "Referenced Waveform Sequence", '', 'ReferencedWaveformSequence'),
0x00081140: ('SQ', '1', "Referenced Image Sequence", '', 'ReferencedImageSequence'),
0x00081145: ('SQ', '1', "Referenced Curve Sequence", 'Retired', 'ReferencedCurveSequence'),
0x0008114A: ('SQ', '1', "Referenced Instance Sequence", '', 'ReferencedInstanceSequence'),
0x0008114B: ('SQ', '1', "Referenced Real World Value Mapping Instance Sequence", '', 'ReferencedRealWorldValueMappingInstanceSequence'),
0x00081150: ('UI', '1', "Referenced SOP Class UID", '', 'ReferencedSOPClassUID'),
0x00081155: ('UI', '1', "Referenced SOP Instance UID", '', 'ReferencedSOPInstanceUID'),
0x0008115A: ('UI', '1-n', "SOP Classes Supported", '', 'SOPClassesSupported'),
0x00081160: ('IS', '1-n', "Referenced Frame Number", '', 'ReferencedFrameNumber'),
0x00081161: ('UL', '1-n', "Simple Frame List", '', 'SimpleFrameList'),
0x00081162: ('UL', '3-3n', "Calculated Frame List", '', 'CalculatedFrameList'),
0x00081163: ('FD', '2', "Time Range", '', 'TimeRange'),
0x00081164: ('SQ', '1', "Frame Extraction Sequence", '', 'FrameExtractionSequence'),
0x00081167: ('UI', '1', "Multi-Frame Source SOP Instance UID", '', 'MultiFrameSourceSOPInstanceUID'),
0x00081195: ('UI', '1', "Transaction UID", '', 'TransactionUID'),
0x00081197: ('US', '1', "Failure Reason", '', 'FailureReason'),
0x00081198: ('SQ', '1', "Failed SOP Sequence", '', 'FailedSOPSequence'),
0x00081199: ('SQ', '1', "Referenced SOP Sequence", '', 'ReferencedSOPSequence'),
0x00081200: ('SQ', '1', "Studies Containing Other Referenced Instances Sequence", '', 'StudiesContainingOtherReferencedInstancesSequence'),
0x00081250: ('SQ', '1', "Related Series Sequence", '', 'RelatedSeriesSequence'),
0x00082110: ('CS', '1', "Lossy Image Compression (Retired)", 'Retired', 'LossyImageCompressionRetired'),
0x00082111: ('ST', '1', "Derivation Description", '', 'DerivationDescription'),
0x00082112: ('SQ', '1', "Source Image Sequence", '', 'SourceImageSequence'),
0x00082120: ('SH', '1', "Stage Name", '', 'StageName'),
0x00082122: ('IS', '1', "Stage Number", '', 'StageNumber'),
0x00082124: ('IS', '1', "Number of Stages", '', 'NumberOfStages'),
0x00082127: ('SH', '1', "View Name", '', 'ViewName'),
0x00082128: ('IS', '1', "View Number", '', 'ViewNumber'),
0x00082129: ('IS', '1', "Number of Event Timers", '', 'NumberOfEventTimers'),
0x0008212A: ('IS', '1', "Number of Views in Stage", '', 'NumberOfViewsInStage'),
0x00082130: ('DS', '1-n', "Event Elapsed Time(s)", '', 'EventElapsedTimes'),
0x00082132: ('LO', '1-n', "Event Timer Name(s)", '', 'EventTimerNames'),
0x00082133: ('SQ', '1', "Event Timer Sequence", '', 'EventTimerSequence'),
0x00082134: ('FD', '1', "Event Time Offset", '', 'EventTimeOffset'),
0x00082135: ('SQ', '1', "Event Code Sequence", '', 'EventCodeSequence'),
0x00082142: ('IS', '1', "Start Trim", '', 'StartTrim'),
0x00082143: ('IS', '1', "Stop Trim", '', 'StopTrim'),
0x00082144: ('IS', '1', "Recommended Display Frame Rate", '', 'RecommendedDisplayFrameRate'),
0x00082200: ('CS', '1', "Transducer Position", 'Retired', 'TransducerPosition'),
0x00082204: ('CS', '1', "Transducer Orientation", 'Retired', 'TransducerOrientation'),
0x00082208: ('CS', '1', "Anatomic Structure", 'Retired', 'AnatomicStructure'),
0x00082218: ('SQ', '1', "Anatomic Region Sequence", '', 'AnatomicRegionSequence'),
0x00082220: ('SQ', '1', "Anatomic Region Modifier Sequence", '', 'AnatomicRegionModifierSequence'),
0x00082228: ('SQ', '1', "Primary Anatomic Structure Sequence", '', 'PrimaryAnatomicStructureSequence'),
0x00082229: ('SQ', '1', "Anatomic Structure, Space or Region Sequence", '', 'AnatomicStructureSpaceOrRegionSequence'),
0x00082230: ('SQ', '1', "Primary Anatomic Structure Modifier Sequence", '', 'PrimaryAnatomicStructureModifierSequence'),
0x00082240: ('SQ', '1', "Transducer Position Sequence", 'Retired', 'TransducerPositionSequence'),
0x00082242: ('SQ', '1', "Transducer Position Modifier Sequence", 'Retired', 'TransducerPositionModifierSequence'),
0x00082244: ('SQ', '1', "Transducer Orientation Sequence", 'Retired', 'TransducerOrientationSequence'),
0x00082246: ('SQ', '1', "Transducer Orientation Modifier Sequence", 'Retired', 'TransducerOrientationModifierSequence'),
0x00082251: ('SQ', '1', "Anatomic Structure Space Or Region Code Sequence (Trial)", 'Retired', 'AnatomicStructureSpaceOrRegionCodeSequenceTrial'),
0x00082253: ('SQ', '1', "Anatomic Portal Of Entrance Code Sequence (Trial)", 'Retired', 'AnatomicPortalOfEntranceCodeSequenceTrial'),
0x00082255: ('SQ', '1', "Anatomic Approach Direction Code Sequence (Trial)", 'Retired', 'AnatomicApproachDirectionCodeSequenceTrial'),
0x00082256: ('ST', '1', "Anatomic Perspective Description (Trial)", 'Retired', 'AnatomicPerspectiveDescriptionTrial'),
0x00082257: ('SQ', '1', "Anatomic Perspective Code Sequence (Trial)", 'Retired', 'AnatomicPerspectiveCodeSequenceTrial'),
0x00082258: ('ST', '1', "Anatomic Location Of Examining Instrument Description (Trial)", 'Retired', 'AnatomicLocationOfExaminingInstrumentDescriptionTrial'),
0x00082259: ('SQ', '1', "Anatomic Location Of Examining Instrument Code Sequence (Trial)", 'Retired', 'AnatomicLocationOfExaminingInstrumentCodeSequenceTrial'),
0x0008225A: ('SQ', '1', "Anatomic Structure Space Or Region Modifier Code Sequence (Trial)", 'Retired', 'AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial'),
0x0008225C: ('SQ', '1', "OnAxis Background Anatomic Structure Code Sequence (Trial)", 'Retired', 'OnAxisBackgroundAnatomicStructureCodeSequenceTrial'),
0x00083001: ('SQ', '1', "Alternate Representation Sequence", '', 'AlternateRepresentationSequence'),
0x00083010: ('UI', '1', "Irradiation Event UID", '', 'IrradiationEventUID'),
0x00084000: ('LT', '1', "Identifying Comments", 'Retired', 'IdentifyingComments'),
0x00089007: ('CS', '4', "Frame Type", '', 'FrameType'),
0x00089092: ('SQ', '1', "Referenced Image Evidence Sequence", '', 'ReferencedImageEvidenceSequence'),
0x00089121: ('SQ', '1', "Referenced Raw Data Sequence", '', 'ReferencedRawDataSequence'),
0x00089123: ('UI', '1', "Creator-Version UID", '', 'CreatorVersionUID'),
0x00089124: ('SQ', '1', "Derivation Image Sequence", '', 'DerivationImageSequence'),
0x00089154: ('SQ', '1', "Source Image Evidence Sequence", '', 'SourceImageEvidenceSequence'),
0x00089205: ('CS', '1', "Pixel Presentation", '', 'PixelPresentation'),
0x00089206: ('CS', '1', "Volumetric Properties", '', 'VolumetricProperties'),
0x00089207: ('CS', '1', "Volume Based Calculation Technique", '', 'VolumeBasedCalculationTechnique'),
0x00089208: ('CS', '1', "Complex Image Component", '', 'ComplexImageComponent'),
0x00089209: ('CS', '1', "Acquisition Contrast", '', 'AcquisitionContrast'),
0x00089215: ('SQ', '1', "Derivation Code Sequence", '', 'DerivationCodeSequence'),
0x00089237: ('SQ', '1', "Referenced Presentation State Sequence", '', 'ReferencedPresentationStateSequence'),
0x00089410: ('SQ', '1', "Referenced Other Plane Sequence", '', 'ReferencedOtherPlaneSequence'),
0x00089458: ('SQ', '1', "Frame Display Sequence", '', 'FrameDisplaySequence'),
0x00089459: ('FL', '1', "Recommended Display Frame Rate in Float", '', 'RecommendedDisplayFrameRateInFloat'),
0x00089460: ('CS', '1', "Skip Frame Range Flag", '', 'SkipFrameRangeFlag'),
0x00100010: ('PN', '1', "Patient's Name", '', 'PatientName'),
0x00100020: ('LO', '1', "Patient ID", '', 'PatientID'),
0x00100021: ('LO', '1', "Issuer of Patient ID", '', 'IssuerOfPatientID'),
0x00100022: ('CS', '1', "Type of Patient ID", '', 'TypeOfPatientID'),
0x00100024: ('SQ', '1', "Issuer of Patient ID Qualifiers Sequence", '', 'IssuerOfPatientIDQualifiersSequence'),
0x00100030: ('DA', '1', "Patient's Birth Date", '', 'PatientBirthDate'),
0x00100032: ('TM', '1', "Patient's Birth Time", '', 'PatientBirthTime'),
0x00100040: ('CS', '1', "Patient's Sex", '', 'PatientSex'),
0x00100050: ('SQ', '1', "Patient's Insurance Plan Code Sequence", '', 'PatientInsurancePlanCodeSequence'),
0x00100101: ('SQ', '1', "Patient's Primary Language Code Sequence", '', 'PatientPrimaryLanguageCodeSequence'),
0x00100102: ('SQ', '1', "Patient's Primary Language Modifier Code Sequence", '', 'PatientPrimaryLanguageModifierCodeSequence'),
0x00101000: ('LO', '1-n', "Other Patient IDs", '', 'OtherPatientIDs'),
0x00101001: ('PN', '1-n', "Other Patient Names", '', 'OtherPatientNames'),
0x00101002: ('SQ', '1', "Other Patient IDs Sequence", '', 'OtherPatientIDsSequence'),
0x00101005: ('PN', '1', "Patient's Birth Name", '', 'PatientBirthName'),
0x00101010: ('AS', '1', "Patient's Age", '', 'PatientAge'),
0x00101020: ('DS', '1', "Patient's Size", '', 'PatientSize'),
0x00101021: ('SQ', '1', "Patient'Size Code Sequence", '', 'PatientSizeCodeSequence'),
0x00101030: ('DS', '1', "Patient's Weight", '', 'PatientWeight'),
0x00101040: ('LO', '1', "Patient's Address", '', 'PatientAddress'),
0x00101050: ('LO', '1-n', "Insurance Plan Identification", 'Retired', 'InsurancePlanIdentification'),
0x00101060: ('PN', '1', "Patient's Mother's Birth Name", '', 'PatientMotherBirthName'),
0x00101080: ('LO', '1', "Military Rank", '', 'MilitaryRank'),
0x00101081: ('LO', '1', "Branch of Service", '', 'BranchOfService'),
0x00101090: ('LO', '1', "Medical Record Locator", '', 'MedicalRecordLocator'),
0x00102000: ('LO', '1-n', "Medical Alerts", '', 'MedicalAlerts'),
0x00102110: ('LO', '1-n', "Allergies", '', 'Allergies'),
0x00102150: ('LO', '1', "Country of Residence", '', 'CountryOfResidence'),
0x00102152: ('LO', '1', "Region of Residence", '', 'RegionOfResidence'),
0x00102154: ('SH', '1-n', "Patient's Telephone Numbers", '', 'PatientTelephoneNumbers'),
0x00102160: ('SH', '1', "Ethnic Group", '', 'EthnicGroup'),
0x00102180: ('SH', '1', "Occupation", '', 'Occupation'),
0x001021A0: ('CS', '1', "Smoking Status", '', 'SmokingStatus'),
0x001021B0: ('LT', '1', "Additional Patient History", '', 'AdditionalPatientHistory'),
0x001021C0: ('US', '1', "Pregnancy Status", '', 'PregnancyStatus'),
0x001021D0: ('DA', '1', "Last Menstrual Date", '', 'LastMenstrualDate'),
0x001021F0: ('LO', '1', "Patient's Religious Preference", '', 'PatientReligiousPreference'),
0x00102201: ('LO', '1', "Patient Species Description", '', 'PatientSpeciesDescription'),
0x00102202: ('SQ', '1', "Patient Species Code Sequence", '', 'PatientSpeciesCodeSequence'),
0x00102203: ('CS', '1', "Patient's Sex Neutered", '', 'PatientSexNeutered'),
0x00102210: ('CS', '1', "Anatomical Orientation Type", '', 'AnatomicalOrientationType'),
0x00102292: ('LO', '1', "Patient Breed Description", '', 'PatientBreedDescription'),
0x00102293: ('SQ', '1', "Patient Breed Code Sequence", '', 'PatientBreedCodeSequence'),
0x00102294: ('SQ', '1', "Breed Registration Sequence", '', 'BreedRegistrationSequence'),
0x00102295: ('LO', '1', "Breed Registration Number", '', 'BreedRegistrationNumber'),
0x00102296: ('SQ', '1', "Breed Registry Code Sequence", '', 'BreedRegistryCodeSequence'),
0x00102297: ('PN', '1', "Responsible Person", '', 'ResponsiblePerson'),
0x00102298: ('CS', '1', "Responsible Person Role", '', 'ResponsiblePersonRole'),
0x00102299: ('LO', '1', "Responsible Organization", '', 'ResponsibleOrganization'),
0x00104000: ('LT', '1', "Patient Comments", '', 'PatientComments'),
0x00109431: ('FL', '1', "Examined Body Thickness", '', 'ExaminedBodyThickness'),
0x00120010: ('LO', '1', "Clinical Trial Sponsor Name", '', 'ClinicalTrialSponsorName'),
0x00120020: ('LO', '1', "Clinical Trial Protocol ID", '', 'ClinicalTrialProtocolID'),
0x00120021: ('LO', '1', "Clinical Trial Protocol Name", '', 'ClinicalTrialProtocolName'),
0x00120030: ('LO', '1', "Clinical Trial Site ID", '', 'ClinicalTrialSiteID'),
0x00120031: ('LO', '1', "Clinical Trial Site Name", '', 'ClinicalTrialSiteName'),
0x00120040: ('LO', '1', "Clinical Trial Subject ID", '', 'ClinicalTrialSubjectID'),
0x00120042: ('LO', '1', "Clinical Trial Subject Reading ID", '', 'ClinicalTrialSubjectReadingID'),
0x00120050: ('LO', '1', "Clinical Trial Time Point ID", '', 'ClinicalTrialTimePointID'),
0x00120051: ('ST', '1', "Clinical Trial Time Point Description", '', 'ClinicalTrialTimePointDescription'),
0x00120060: ('LO', '1', "Clinical Trial Coordinating Center Name", '', 'ClinicalTrialCoordinatingCenterName'),
0x00120062: ('CS', '1', "Patient Identity Removed", '', 'PatientIdentityRemoved'),
0x00120063: ('LO', '1-n', "De-identification Method", '', 'DeidentificationMethod'),
0x00120064: ('SQ', '1', "De-identification Method Code Sequence", '', 'DeidentificationMethodCodeSequence'),
0x00120071: ('LO', '1', "Clinical Trial Series ID", '', 'ClinicalTrialSeriesID'),
0x00120072: ('LO', '1', "Clinical Trial Series Description", '', 'ClinicalTrialSeriesDescription'),
0x00120081: ('LO', '1', "Clinical Trial Protocol Ethics Committee Name", '', 'ClinicalTrialProtocolEthicsCommitteeName'),
0x00120082: ('LO', '1', "Clinical Trial Protocol Ethics Committee Approval Number", '', 'ClinicalTrialProtocolEthicsCommitteeApprovalNumber'),
0x00120083: ('SQ', '1', "Consent for Clinical Trial Use Sequence", '', 'ConsentForClinicalTrialUseSequence'),
0x00120084: ('CS', '1', "Distribution Type", '', 'DistributionType'),
0x00120085: ('CS', '1', "Consent for Distribution Flag", '', 'ConsentForDistributionFlag'),
0x00140023: ('ST', '1-n', "CAD File Format", '', 'CADFileFormat'),
0x00140024: ('ST', '1-n', "Component Reference System", '', 'ComponentReferenceSystem'),
0x00140025: ('ST', '1-n', "Component Manufacturing Procedure", '', 'ComponentManufacturingProcedure'),
0x00140028: ('ST', '1-n', "Component Manufacturer", '', 'ComponentManufacturer'),
0x00140030: ('DS', '1-n', "Material Thickness", '', 'MaterialThickness'),
0x00140032: ('DS', '1-n', "Material Pipe Diameter", '', 'MaterialPipeDiameter'),
0x00140034: ('DS', '1-n', "Material Isolation Diameter", '', 'MaterialIsolationDiameter'),
0x00140042: ('ST', '1-n', "Material Grade", '', 'MaterialGrade'),
0x00140044: ('ST', '1-n', "Material Properties File ID", '', 'MaterialPropertiesFileID'),
0x00140045: ('ST', '1-n', "Material Properties File Format", '', 'MaterialPropertiesFileFormat'),
0x00140046: ('LT', '1', "Material Notes", '', 'MaterialNotes'),
0x00140050: ('CS', '1', "Component Shape", '', 'ComponentShape'),
0x00140052: ('CS', '1', "Curvature Type", '', 'CurvatureType'),
0x00140054: ('DS', '1', "Outer Diameter", '', 'OuterDiameter'),
0x00140056: ('DS', '1', "Inner Diameter", '', 'InnerDiameter'),
0x00141010: ('ST', '1', "Actual Environmental Conditions", '', 'ActualEnvironmentalConditions'),
0x00141020: ('DA', '1', "Expiry Date", '', 'ExpiryDate'),
0x00141040: ('ST', '1', "Environmental Conditions", '', 'EnvironmentalConditions'),
0x00142002: ('SQ', '1', "Evaluator Sequence", '', 'EvaluatorSequence'),
0x00142004: ('IS', '1', "Evaluator Number", '', 'EvaluatorNumber'),
0x00142006: ('PN', '1', "Evaluator Name", '', 'EvaluatorName'),
0x00142008: ('IS', '1', "Evaluation Attempt", '', 'EvaluationAttempt'),
0x00142012: ('SQ', '1', "Indication Sequence", '', 'IndicationSequence'),
0x00142014: ('IS', '1', "Indication Number", '', 'IndicationNumber'),
0x00142016: ('SH', '1', "Indication Label", '', 'IndicationLabel'),
0x00142018: ('ST', '1', "Indication Description", '', 'IndicationDescription'),
0x0014201A: ('CS', '1-n', "Indication Type", '', 'IndicationType'),
0x0014201C: ('CS', '1', "Indication Disposition", '', 'IndicationDisposition'),
0x0014201E: ('SQ', '1', "Indication ROI Sequence", '', 'IndicationROISequence'),
0x00142030: ('SQ', '1', "Indication Physical Property Sequence", '', 'IndicationPhysicalPropertySequence'),
0x00142032: ('SH', '1', "Property Label", '', 'PropertyLabel'),
0x00142202: ('IS', '1', "Coordinate System Number of Axes", '', 'CoordinateSystemNumberOfAxes'),
0x00142204: ('SQ', '1', "Coordinate System Axes Sequence", '', 'CoordinateSystemAxesSequence'),
0x00142206: ('ST', '1', "Coordinate System Axis Description", '', 'CoordinateSystemAxisDescription'),
0x00142208: ('CS', '1', "Coordinate System Data Set Mapping", '', 'CoordinateSystemDataSetMapping'),
0x0014220A: ('IS', '1', "Coordinate System Axis Number", '', 'CoordinateSystemAxisNumber'),
0x0014220C: ('CS', '1', "Coordinate System Axis Type", '', 'CoordinateSystemAxisType'),
0x0014220E: ('CS', '1', "Coordinate System Axis Units", '', 'CoordinateSystemAxisUnits'),
0x00142210: ('OB', '1', "Coordinate System Axis Values", '', 'CoordinateSystemAxisValues'),
0x00142220: ('SQ', '1', "Coordinate System Transform Sequence", '', 'CoordinateSystemTransformSequence'),
0x00142222: ('ST', '1', "Transform Description", '', 'TransformDescription'),
0x00142224: ('IS', '1', "Transform Number of Axes", '', 'TransformNumberOfAxes'),
0x00142226: ('IS', '1-n', "Transform Order of Axes", '', 'TransformOrderOfAxes'),
0x00142228: ('CS', '1', "Transformed Axis Units", '', 'TransformedAxisUnits'),
0x0014222A: ('DS', '1-n', "Coordinate System Transform Rotation and Scale Matrix", '', 'CoordinateSystemTransformRotationAndScaleMatrix'),
0x0014222C: ('DS', '1-n', "Coordinate System Transform Translation Matrix", '', 'CoordinateSystemTransformTranslationMatrix'),
0x00143011: ('DS', '1', "Internal Detector Frame Time", '', 'InternalDetectorFrameTime'),
0x00143012: ('DS', '1', "Number of Frames Integrated", '', 'NumberOfFramesIntegrated'),
0x00143020: ('SQ', '1', "Detector Temperature Sequence", '', 'DetectorTemperatureSequence'),
0x00143022: ('DS', '1', "Sensor Name", '', 'SensorName'),
0x00143024: ('DS', '1', "Horizontal Offset of Sensor", '', 'HorizontalOffsetOfSensor'),
0x00143026: ('DS', '1', "Vertical Offset of Sensor", '', 'VerticalOffsetOfSensor'),
0x00143028: ('DS', '1', "Sensor Temperature", '', 'SensorTemperature'),
0x00143040: ('SQ', '1', "Dark Current Sequence", '', 'DarkCurrentSequence'),
0x00143050: ('OB or OW', '1', "Dark Current Counts", '', 'DarkCurrentCounts'),
0x00143060: ('SQ', '1', "Gain Correction Reference Sequence", '', 'GainCorrectionReferenceSequence'),
0x00143070: ('OB or OW', '1', "Air Counts", '', 'AirCounts'),
0x00143071: ('DS', '1', "KV Used in Gain Calibration", '', 'KVUsedInGainCalibration'),
0x00143072: ('DS', '1', "MA Used in Gain Calibration", '', 'MAUsedInGainCalibration'),
0x00143073: ('DS', '1', "Number of Frames Used for Integration", '', 'NumberOfFramesUsedForIntegration'),
0x00143074: ('LO', '1', "Filter Material Used in Gain Calibration", '', 'FilterMaterialUsedInGainCalibration'),
0x00143075: ('DS', '1', "Filter Thickness Used in Gain Calibration", '', 'FilterThicknessUsedInGainCalibration'),
0x00143076: ('DA', '1', "Date of Gain Calibration", '', 'DateOfGainCalibration'),
0x00143077: ('TM', '1', "Time of Gain Calibration", '', 'TimeOfGainCalibration'),
0x00143080: ('OB', '1', "Bad Pixel Image", '', 'BadPixelImage'),
0x00143099: ('LT', '1', "Calibration Notes", '', 'CalibrationNotes'),
0x00144002: ('SQ', '1', "Pulser Equipment Sequence", '', 'PulserEquipmentSequence'),
0x00144004: ('CS', '1', "Pulser Type", '', 'PulserType'),
0x00144006: ('LT', '1', "Pulser Notes", '', 'PulserNotes'),
0x00144008: ('SQ', '1', "Receiver Equipment Sequence", '', 'ReceiverEquipmentSequence'),
0x0014400A: ('CS', '1', "Amplifier Type", '', 'AmplifierType'),
0x0014400C: ('LT', '1', "Receiver Notes", '', 'ReceiverNotes'),
0x0014400E: ('SQ', '1', "Pre-Amplifier Equipment Sequence", '', 'PreAmplifierEquipmentSequence'),
0x0014400F: ('LT', '1', "Pre-Amplifier Notes", '', 'PreAmplifierNotes'),
0x00144010: ('SQ', '1', "Transmit Transducer Sequence", '', 'TransmitTransducerSequence'),
0x00144011: ('SQ', '1', "Receive Transducer Sequence", '', 'ReceiveTransducerSequence'),
0x00144012: ('US', '1', "Number of Elements", '', 'NumberOfElements'),
0x00144013: ('CS', '1', "Element Shape", '', 'ElementShape'),
0x00144014: ('DS', '1', "Element Dimension A", '', 'ElementDimensionA'),
0x00144015: ('DS', '1', "Element Dimension B", '', 'ElementDimensionB'),
0x00144016: ('DS', '1', "Element Pitch", '', 'ElementPitch'),
0x00144017: ('DS', '1', "Measured Beam Dimension A", '', 'MeasuredBeamDimensionA'),
0x00144018: ('DS', '1', "Measured Beam Dimension B", '', 'MeasuredBeamDimensionB'),
0x00144019: ('DS', '1', "Location of Measured Beam Diameter", '', 'LocationOfMeasuredBeamDiameter'),
0x0014401A: ('DS', '1', "Nominal Frequency", '', 'NominalFrequency'),
0x0014401B: ('DS', '1', "Measured Center Frequency", '', 'MeasuredCenterFrequency'),
0x0014401C: ('DS', '1', "Measured Bandwidth", '', 'MeasuredBandwidth'),
0x00144020: ('SQ', '1', "Pulser Settings Sequence", '', 'PulserSettingsSequence'),
0x00144022: ('DS', '1', "Pulse Width", '', 'PulseWidth'),
0x00144024: ('DS', '1', "Excitation Frequency", '', 'ExcitationFrequency'),
0x00144026: ('CS', '1', "Modulation Type", '', 'ModulationType'),
0x00144028: ('DS', '1', "Damping", '', 'Damping'),
0x00144030: ('SQ', '1', "Receiver Settings Sequence", '', 'ReceiverSettingsSequence'),
0x00144031: ('DS', '1', "Acquired Soundpath Length", '', 'AcquiredSoundpathLength'),
0x00144032: ('CS', '1', "Acquisition Compression Type", '', 'AcquisitionCompressionType'),
0x00144033: ('IS', '1', "Acquisition Sample Size", '', 'AcquisitionSampleSize'),
0x00144034: ('DS', '1', "Rectifier Smoothing", '', 'RectifierSmoothing'),
0x00144035: ('SQ', '1', "DAC Sequence", '', 'DACSequence'),
0x00144036: ('CS', '1', "DAC Type", '', 'DACType'),
0x00144038: ('DS', '1-n', "DAC Gain Points", '', 'DACGainPoints'),
0x0014403A: ('DS', '1-n', "DAC Time Points", '', 'DACTimePoints'),
0x0014403C: ('DS', '1-n', "DAC Amplitude", '', 'DACAmplitude'),
0x00144040: ('SQ', '1', "Pre-Amplifier Settings Sequence", '', 'PreAmplifierSettingsSequence'),
0x00144050: ('SQ', '1', "Transmit Transducer Settings Sequence", '', 'TransmitTransducerSettingsSequence'),
0x00144051: ('SQ', '1', "Receive Transducer Settings Sequence", '', 'ReceiveTransducerSettingsSequence'),
0x00144052: ('DS', '1', "Incident Angle", '', 'IncidentAngle'),
0x00144054: ('ST', '1', "Coupling Technique", '', 'CouplingTechnique'),
0x00144056: ('ST', '1', "Coupling Medium", '', 'CouplingMedium'),
0x00144057: ('DS', '1', "Coupling Velocity", '', 'CouplingVelocity'),
0x00144058: ('DS', '1', "Crystal Center Location X", '', 'CrystalCenterLocationX'),
0x00144059: ('DS', '1', "Crystal Center Location Z", '', 'CrystalCenterLocationZ'),
0x0014405A: ('DS', '1', "Sound Path Length", '', 'SoundPathLength'),
0x0014405C: ('ST', '1', "Delay Law Identifier", '', 'DelayLawIdentifier'),
0x00144060: ('SQ', '1', "Gate Settings Sequence", '', 'GateSettingsSequence'),
0x00144062: ('DS', '1', "Gate Threshold", '', 'GateThreshold'),
0x00144064: ('DS', '1', "Velocity of Sound", '', 'VelocityOfSound'),
0x00144070: ('SQ', '1', "Calibration Settings Sequence", '', 'CalibrationSettingsSequence'),
0x00144072: ('ST', '1', "Calibration Procedure", '', 'CalibrationProcedure'),
0x00144074: ('SH', '1', "Procedure Version", '', 'ProcedureVersion'),
0x00144076: ('DA', '1', "Procedure Creation Date", '', 'ProcedureCreationDate'),
0x00144078: ('DA', '1', "Procedure Expiration Date", '', 'ProcedureExpirationDate'),
0x0014407A: ('DA', '1', "Procedure Last Modified Date", '', 'ProcedureLastModifiedDate'),
0x0014407C: ('TM', '1-n', "Calibration Time", '', 'CalibrationTime'),
0x0014407E: ('DA', '1-n', "Calibration Date", '', 'CalibrationDate'),
0x00145002: ('IS', '1', "LINAC Energy", '', 'LINACEnergy'),
0x00145004: ('IS', '1', "LINAC Output", '', 'LINACOutput'),
0x00180010: ('LO', '1', "Contrast/Bolus Agent", '', 'ContrastBolusAgent'),
0x00180012: ('SQ', '1', "Contrast/Bolus Agent Sequence", '', 'ContrastBolusAgentSequence'),
0x00180014: ('SQ', '1', "Contrast/Bolus Administration Route Sequence", '', 'ContrastBolusAdministrationRouteSequence'),
0x00180015: ('CS', '1', "Body Part Examined", '', 'BodyPartExamined'),
0x00180020: ('CS', '1-n', "Scanning Sequence", '', 'ScanningSequence'),
0x00180021: ('CS', '1-n', "Sequence Variant", '', 'SequenceVariant'),
0x00180022: ('CS', '1-n', "Scan Options", '', 'ScanOptions'),
0x00180023: ('CS', '1', "MR Acquisition Type", '', 'MRAcquisitionType'),
0x00180024: ('SH', '1', "Sequence Name", '', 'SequenceName'),
0x00180025: ('CS', '1', "Angio Flag", '', 'AngioFlag'),
0x00180026: ('SQ', '1', "Intervention Drug Information Sequence", '', 'InterventionDrugInformationSequence'),
0x00180027: ('TM', '1', "Intervention Drug Stop Time", '', 'InterventionDrugStopTime'),
0x00180028: ('DS', '1', "Intervention Drug Dose", '', 'InterventionDrugDose'),
0x00180029: ('SQ', '1', "Intervention Drug Code Sequence", '', 'InterventionDrugCodeSequence'),
0x0018002A: ('SQ', '1', "Additional Drug Sequence", '', 'AdditionalDrugSequence'),
0x00180030: ('LO', '1-n', "Radionuclide", 'Retired', 'Radionuclide'),
0x00180031: ('LO', '1', "Radiopharmaceutical", '', 'Radiopharmaceutical'),
0x00180032: ('DS', '1', "Energy Window Centerline", 'Retired', 'EnergyWindowCenterline'),
0x00180033: ('DS', '1-n', "Energy Window Total Width", 'Retired', 'EnergyWindowTotalWidth'),
0x00180034: ('LO', '1', "Intervention Drug Name", '', 'InterventionDrugName'),
0x00180035: ('TM', '1', "Intervention Drug Start Time", '', 'InterventionDrugStartTime'),
0x00180036: ('SQ', '1', "Intervention Sequence", '', 'InterventionSequence'),
0x00180037: ('CS', '1', "Therapy Type", 'Retired', 'TherapyType'),
0x00180038: ('CS', '1', "Intervention Status", '', 'InterventionStatus'),
0x00180039: ('CS', '1', "Therapy Description", 'Retired', 'TherapyDescription'),
0x0018003A: ('ST', '1', "Intervention Description", '', 'InterventionDescription'),
0x00180040: ('IS', '1', "Cine Rate", '', 'CineRate'),
0x00180042: ('CS', '1', "Initial Cine Run State", '', 'InitialCineRunState'),
0x00180050: ('DS', '1', "Slice Thickness", '', 'SliceThickness'),
0x00180060: ('DS', '1', "KVP", '', 'KVP'),
0x00180070: ('IS', '1', "Counts Accumulated", '', 'CountsAccumulated'),
0x00180071: ('CS', '1', "Acquisition Termination Condition", '', 'AcquisitionTerminationCondition'),
0x00180072: ('DS', '1', "Effective Duration", '', 'EffectiveDuration'),
0x00180073: ('CS', '1', "Acquisition Start Condition", '', 'AcquisitionStartCondition'),
0x00180074: ('IS', '1', "Acquisition Start Condition Data", '', 'AcquisitionStartConditionData'),
0x00180075: ('IS', '1', "Acquisition Termination Condition Data", '', 'AcquisitionTerminationConditionData'),
0x00180080: ('DS', '1', "Repetition Time", '', 'RepetitionTime'),
0x00180081: ('DS', '1', "Echo Time", '', 'EchoTime'),
0x00180082: ('DS', '1', "Inversion Time", '', 'InversionTime'),
0x00180083: ('DS', '1', "Number of Averages", '', 'NumberOfAverages'),
0x00180084: ('DS', '1', "Imaging Frequency", '', 'ImagingFrequency'),
0x00180085: ('SH', '1', "Imaged Nucleus", '', 'ImagedNucleus'),
0x00180086: ('IS', '1-n', "Echo Number(s)", '', 'EchoNumbers'),
0x00180087: ('DS', '1', "Magnetic Field Strength", '', 'MagneticFieldStrength'),
0x00180088: ('DS', '1', "Spacing Between Slices", '', 'SpacingBetweenSlices'),
0x00180089: ('IS', '1', "Number of Phase Encoding Steps", '', 'NumberOfPhaseEncodingSteps'),
0x00180090: ('DS', '1', "Data Collection Diameter", '', 'DataCollectionDiameter'),
0x00180091: ('IS', '1', "Echo Train Length", '', 'EchoTrainLength'),
0x00180093: ('DS', '1', "Percent Sampling", '', 'PercentSampling'),
0x00180094: ('DS', '1', "Percent Phase Field of View", '', 'PercentPhaseFieldOfView'),
0x00180095: ('DS', '1', "Pixel Bandwidth", '', 'PixelBandwidth'),
0x00181000: ('LO', '1', "Device Serial Number", '', 'DeviceSerialNumber'),
0x00181002: ('UI', '1', "Device UID", '', 'DeviceUID'),
0x00181003: ('LO', '1', "Device ID", '', 'DeviceID'),
0x00181004: ('LO', '1', "Plate ID", '', 'PlateID'),
0x00181005: ('LO', '1', "Generator ID", '', 'GeneratorID'),
0x00181006: ('LO', '1', "Grid ID", '', 'GridID'),
0x00181007: ('LO', '1', "Cassette ID", '', 'CassetteID'),
0x00181008: ('LO', '1', "Gantry ID", '', 'GantryID'),
0x00181010: ('LO', '1', "Secondary Capture Device ID", '', 'SecondaryCaptureDeviceID'),
0x00181011: ('LO', '1', "Hardcopy Creation Device ID", 'Retired', 'HardcopyCreationDeviceID'),
0x00181012: ('DA', '1', "Date of Secondary Capture", '', 'DateOfSecondaryCapture'),
0x00181014: ('TM', '1', "Time of Secondary Capture", '', 'TimeOfSecondaryCapture'),
0x00181016: ('LO', '1', "Secondary Capture Device Manufacturer", '', 'SecondaryCaptureDeviceManufacturer'),
0x00181017: ('LO', '1', "Hardcopy Device Manufacturer", 'Retired', 'HardcopyDeviceManufacturer'),
0x00181018: ('LO', '1', "Secondary Capture Device Manufacturer's Model Name", '', 'SecondaryCaptureDeviceManufacturerModelName'),
0x00181019: ('LO', '1-n', "Secondary Capture Device Software Versions", '', 'SecondaryCaptureDeviceSoftwareVersions'),
0x0018101A: ('LO', '1-n', "Hardcopy Device Software Version", 'Retired', 'HardcopyDeviceSoftwareVersion'),
0x0018101B: ('LO', '1', "Hardcopy Device Manufacturer's Model Name", 'Retired', 'HardcopyDeviceManufacturerModelName'),
0x00181020: ('LO', '1-n', "Software Version(s)", '', 'SoftwareVersions'),
0x00181022: ('SH', '1', "Video Image Format Acquired", '', 'VideoImageFormatAcquired'),
0x00181023: ('LO', '1', "Digital Image Format Acquired", '', 'DigitalImageFormatAcquired'),
0x00181030: ('LO', '1', "Protocol Name", '', 'ProtocolName'),
0x00181040: ('LO', '1', "Contrast/Bolus Route", '', 'ContrastBolusRoute'),
0x00181041: ('DS', '1', "Contrast/Bolus Volume", '', 'ContrastBolusVolume'),
0x00181042: ('TM', '1', "Contrast/Bolus Start Time", '', 'ContrastBolusStartTime'),
0x00181043: ('TM', '1', "Contrast/Bolus Stop Time", '', 'ContrastBolusStopTime'),
0x00181044: ('DS', '1', "Contrast/Bolus Total Dose", '', 'ContrastBolusTotalDose'),
0x00181045: ('IS', '1', "Syringe Counts", '', 'SyringeCounts'),
0x00181046: ('DS', '1-n', "Contrast Flow Rate", '', 'ContrastFlowRate'),
0x00181047: ('DS', '1-n', "Contrast Flow Duration", '', 'ContrastFlowDuration'),
0x00181048: ('CS', '1', "Contrast/Bolus Ingredient", '', 'ContrastBolusIngredient'),
0x00181049: ('DS', '1', "Contrast/Bolus Ingredient Concentration", '', 'ContrastBolusIngredientConcentration'),
0x00181050: ('DS', '1', "Spatial Resolution", '', 'SpatialResolution'),
0x00181060: ('DS', '1', "Trigger Time", '', 'TriggerTime'),
0x00181061: ('LO', '1', "Trigger Source or Type", '', 'TriggerSourceOrType'),
0x00181062: ('IS', '1', "Nominal Interval", '', 'NominalInterval'),
0x00181063: ('DS', '1', "Frame Time", '', 'FrameTime'),
0x00181064: ('LO', '1', "Cardiac Framing Type", '', 'CardiacFramingType'),
0x00181065: ('DS', '1-n', "Frame Time Vector", '', 'FrameTimeVector'),
0x00181066: ('DS', '1', "Frame Delay", '', 'FrameDelay'),
0x00181067: ('DS', '1', "Image Trigger Delay", '', 'ImageTriggerDelay'),
0x00181068: ('DS', '1', "Multiplex Group Time Offset", '', 'MultiplexGroupTimeOffset'),
0x00181069: ('DS', '1', "Trigger Time Offset", '', 'TriggerTimeOffset'),
0x0018106A: ('CS', '1', "Synchronization Trigger", '', 'SynchronizationTrigger'),
0x0018106C: ('US', '2', "Synchronization Channel", '', 'SynchronizationChannel'),
0x0018106E: ('UL', '1', "Trigger Sample Position", '', 'TriggerSamplePosition'),
0x00181070: ('LO', '1', "Radiopharmaceutical Route", '', 'RadiopharmaceuticalRoute'),
0x00181071: ('DS', '1', "Radiopharmaceutical Volume", '', 'RadiopharmaceuticalVolume'),
0x00181072: ('TM', '1', "Radiopharmaceutical Start Time", '', 'RadiopharmaceuticalStartTime'),
0x00181073: ('TM', '1', "Radiopharmaceutical Stop Time", '', 'RadiopharmaceuticalStopTime'),
0x00181074: ('DS', '1', "Radionuclide Total Dose", '', 'RadionuclideTotalDose'),
0x00181075: ('DS', '1', "Radionuclide Half Life", '', 'RadionuclideHalfLife'),
0x00181076: ('DS', '1', "Radionuclide Positron Fraction", '', 'RadionuclidePositronFraction'),
0x00181077: ('DS', '1', "Radiopharmaceutical Specific Activity", '', 'RadiopharmaceuticalSpecificActivity'),
0x00181078: ('DT', '1', "Radiopharmaceutical Start DateTime", '', 'RadiopharmaceuticalStartDateTime'),
0x00181079: ('DT', '1', "Radiopharmaceutical Stop DateTime", '', 'RadiopharmaceuticalStopDateTime'),
0x00181080: ('CS', '1', "Beat Rejection Flag", '', 'BeatRejectionFlag'),
0x00181081: ('IS', '1', "Low R-R Value", '', 'LowRRValue'),
0x00181082: ('IS', '1', "High R-R Value", '', 'HighRRValue'),
0x00181083: ('IS', '1', "Intervals Acquired", '', 'IntervalsAcquired'),
0x00181084: ('IS', '1', "Intervals Rejected", '', 'IntervalsRejected'),
0x00181085: ('LO', '1', "PVC Rejection", '', 'PVCRejection'),
0x00181086: ('IS', '1', "Skip Beats", '', 'SkipBeats'),
0x00181088: ('IS', '1', "Heart Rate", '', 'HeartRate'),
0x00181090: ('IS', '1', "Cardiac Number of Images", '', 'CardiacNumberOfImages'),
0x00181094: ('IS', '1', "Trigger Window", '', 'TriggerWindow'),
0x00181100: ('DS', '1', "Reconstruction Diameter", '', 'ReconstructionDiameter'),
0x00181110: ('DS', '1', "Distance Source to Detector", '', 'DistanceSourceToDetector'),
0x00181111: ('DS', '1', "Distance Source to Patient", '', 'DistanceSourceToPatient'),
0x00181114: ('DS', '1', "Estimated Radiographic Magnification Factor", '', 'EstimatedRadiographicMagnificationFactor'),
0x00181120: ('DS', '1', "Gantry/Detector Tilt", '', 'GantryDetectorTilt'),
0x00181121: ('DS', '1', "Gantry/Detector Slew", '', 'GantryDetectorSlew'),
0x00181130: ('DS', '1', "Table Height", '', 'TableHeight'),
0x00181131: ('DS', '1', "Table Traverse", '', 'TableTraverse'),
0x00181134: ('CS', '1', "Table Motion", '', 'TableMotion'),
0x00181135: ('DS', '1-n', "Table Vertical Increment", '', 'TableVerticalIncrement'),
0x00181136: ('DS', '1-n', "Table Lateral Increment", '', 'TableLateralIncrement'),
0x00181137: ('DS', '1-n', "Table Longitudinal Increment", '', 'TableLongitudinalIncrement'),
0x00181138: ('DS', '1', "Table Angle", '', 'TableAngle'),
0x0018113A: ('CS', '1', "Table Type", '', 'TableType'),
0x00181140: ('CS', '1', "Rotation Direction", '', 'RotationDirection'),
0x00181141: ('DS', '1', "Angular Position", 'Retired', 'AngularPosition'),
0x00181142: ('DS', '1-n', "Radial Position", '', 'RadialPosition'),
0x00181143: ('DS', '1', "Scan Arc", '', 'ScanArc'),
0x00181144: ('DS', '1', "Angular Step", '', 'AngularStep'),
0x00181145: ('DS', '1', "Center of Rotation Offset", '', 'CenterOfRotationOffset'),
0x00181146: ('DS', '1-n', "Rotation Offset", 'Retired', 'RotationOffset'),
0x00181147: ('CS', '1', "Field of View Shape", '', 'FieldOfViewShape'),
0x00181149: ('IS', '1-2', "Field of View Dimension(s)", '', 'FieldOfViewDimensions'),
0x00181150: ('IS', '1', "Exposure Time", '', 'ExposureTime'),
0x00181151: ('IS', '1', "X-Ray Tube Current", '', 'XRayTubeCurrent'),
0x00181152: ('IS', '1', "Exposure", '', 'Exposure'),
0x00181153: ('IS', '1', "Exposure in uAs", '', 'ExposureInuAs'),
0x00181154: ('DS', '1', "Average Pulse Width", '', 'AveragePulseWidth'),
0x00181155: ('CS', '1', "Radiation Setting", '', 'RadiationSetting'),
0x00181156: ('CS', '1', "Rectification Type", '', 'RectificationType'),
0x0018115A: ('CS', '1', "Radiation Mode", '', 'RadiationMode'),
0x0018115E: ('DS', '1', "Image and Fluoroscopy Area Dose Product", '', 'ImageAndFluoroscopyAreaDoseProduct'),
0x00181160: ('SH', '1', "Filter Type", '', 'FilterType'),
0x00181161: ('LO', '1-n', "Type of Filters", '', 'TypeOfFilters'),
0x00181162: ('DS', '1', "Intensifier Size", '', 'IntensifierSize'),
0x00181164: ('DS', '2', "Imager Pixel Spacing", '', 'ImagerPixelSpacing'),
0x00181166: ('CS', '1-n', "Grid", '', 'Grid'),
0x00181170: ('IS', '1', "Generator Power", '', 'GeneratorPower'),
0x00181180: ('SH', '1', "Collimator/grid Name", '', 'CollimatorGridName'),
0x00181181: ('CS', '1', "Collimator Type", '', 'CollimatorType'),
0x00181182: ('IS', '1-2', "Focal Distance", '', 'FocalDistance'),
0x00181183: ('DS', '1-2', "X Focus Center", '', 'XFocusCenter'),
0x00181184: ('DS', '1-2', "Y Focus Center", '', 'YFocusCenter'),
0x00181190: ('DS', '1-n', "Focal Spot(s)", '', 'FocalSpots'),
0x00181191: ('CS', '1', "Anode Target Material", '', 'AnodeTargetMaterial'),
0x001811A0: ('DS', '1', "Body Part Thickness", '', 'BodyPartThickness'),
0x001811A2: ('DS', '1', "Compression Force", '', 'CompressionForce'),
0x00181200: ('DA', '1-n', "Date of Last Calibration", '', 'DateOfLastCalibration'),
0x00181201: ('TM', '1-n', "Time of Last Calibration", '', 'TimeOfLastCalibration'),
0x00181210: ('SH', '1-n', "Convolution Kernel", '', 'ConvolutionKernel'),
0x00181240: ('IS', '1-n', "Upper/Lower Pixel Values", 'Retired', 'UpperLowerPixelValues'),
0x00181242: ('IS', '1', "Actual Frame Duration", '', 'ActualFrameDuration'),
0x00181243: ('IS', '1', "Count Rate", '', 'CountRate'),
0x00181244: ('US', '1', "Preferred Playback Sequencing", '', 'PreferredPlaybackSequencing'),
0x00181250: ('SH', '1', "Receive Coil Name", '', 'ReceiveCoilName'),
0x00181251: ('SH', '1', "Transmit Coil Name", '', 'TransmitCoilName'),
0x00181260: ('SH', '1', "Plate Type", '', 'PlateType'),
0x00181261: ('LO', '1', "Phosphor Type", '', 'PhosphorType'),
0x00181300: ('DS', '1', "Scan Velocity", '', 'ScanVelocity'),
0x00181301: ('CS', '1-n', "Whole Body Technique", '', 'WholeBodyTechnique'),
0x00181302: ('IS', '1', "Scan Length", '', 'ScanLength'),
0x00181310: ('US', '4', "Acquisition Matrix", '', 'AcquisitionMatrix'),
0x00181312: ('CS', '1', "In-plane Phase Encoding Direction", '', 'InPlanePhaseEncodingDirection'),
0x00181314: ('DS', '1', "Flip Angle", '', 'FlipAngle'),
0x00181315: ('CS', '1', "Variable Flip Angle Flag", '', 'VariableFlipAngleFlag'),
0x00181316: ('DS', '1', "SAR", '', 'SAR'),
0x00181318: ('DS', '1', "dB/dt", '', 'dBdt'),
0x00181400: ('LO', '1', "Acquisition Device Processing Description", '', 'AcquisitionDeviceProcessingDescription'),
0x00181401: ('LO', '1', "Acquisition Device Processing Code", '', 'AcquisitionDeviceProcessingCode'),
0x00181402: ('CS', '1', "Cassette Orientation", '', 'CassetteOrientation'),
0x00181403: ('CS', '1', "Cassette Size", '', 'CassetteSize'),
0x00181404: ('US', '1', "Exposures on Plate", '', 'ExposuresOnPlate'),
0x00181405: ('IS', '1', "Relative X-Ray Exposure", '', 'RelativeXRayExposure'),
0x00181411: ('DS', '1', "Exposure Index", '', 'ExposureIndex'),
0x00181412: ('DS', '1', "Target Exposure Index", '', 'TargetExposureIndex'),
0x00181413: ('DS', '1', "Deviation Index", '', 'DeviationIndex'),
0x00181450: ('DS', '1', "Column Angulation", '', 'ColumnAngulation'),
0x00181460: ('DS', '1', "Tomo Layer Height", '', 'TomoLayerHeight'),
0x00181470: ('DS', '1', "Tomo Angle", '', 'TomoAngle'),
0x00181480: ('DS', '1', "Tomo Time", '', 'TomoTime'),
0x00181490: ('CS', '1', "Tomo Type", '', 'TomoType'),
0x00181491: ('CS', '1', "Tomo Class", '', 'TomoClass'),
0x00181495: ('IS', '1', "Number of Tomosynthesis Source Images", '', 'NumberOfTomosynthesisSourceImages'),
0x00181500: ('CS', '1', "Positioner Motion", '', 'PositionerMotion'),
0x00181508: ('CS', '1', "Positioner Type", '', 'PositionerType'),
0x00181510: ('DS', '1', "Positioner Primary Angle", '', 'PositionerPrimaryAngle'),
0x00181511: ('DS', '1', "Positioner Secondary Angle", '', 'PositionerSecondaryAngle'),
0x00181520: ('DS', '1-n', "Positioner Primary Angle Increment", '', 'PositionerPrimaryAngleIncrement'),
0x00181521: ('DS', '1-n', "Positioner Secondary Angle Increment", '', 'PositionerSecondaryAngleIncrement'),
0x00181530: ('DS', '1', "Detector Primary Angle", '', 'DetectorPrimaryAngle'),
0x00181531: ('DS', '1', "Detector Secondary Angle", '', 'DetectorSecondaryAngle'),
0x00181600: ('CS', '1-3', "Shutter Shape", '', 'ShutterShape'),
0x00181602: ('IS', '1', "Shutter Left Vertical Edge", '', 'ShutterLeftVerticalEdge'),
0x00181604: ('IS', '1', "Shutter Right Vertical Edge", '', 'ShutterRightVerticalEdge'),
0x00181606: ('IS', '1', "Shutter Upper Horizontal Edge", '', 'ShutterUpperHorizontalEdge'),
0x00181608: ('IS', '1', "Shutter Lower Horizontal Edge", '', 'ShutterLowerHorizontalEdge'),
0x00181610: ('IS', '2', "Center of Circular Shutter", '', 'CenterOfCircularShutter'),
0x00181612: ('IS', '1', "Radius of Circular Shutter", '', 'RadiusOfCircularShutter'),
0x00181620: ('IS', '2-2n', "Vertices of the Polygonal Shutter", '', 'VerticesOfThePolygonalShutter'),
0x00181622: ('US', '1', "Shutter Presentation Value", '', 'ShutterPresentationValue'),
0x00181623: ('US', '1', "Shutter Overlay Group", '', 'ShutterOverlayGroup'),
0x00181624: ('US', '3', "Shutter Presentation Color CIELab Value", '', 'ShutterPresentationColorCIELabValue'),
0x00181700: ('CS', '1-3', "Collimator Shape", '', 'CollimatorShape'),
0x00181702: ('IS', '1', "Collimator Left Vertical Edge", '', 'CollimatorLeftVerticalEdge'),
0x00181704: ('IS', '1', "Collimator Right Vertical Edge", '', 'CollimatorRightVerticalEdge'),
0x00181706: ('IS', '1', "Collimator Upper Horizontal Edge", '', 'CollimatorUpperHorizontalEdge'),
0x00181708: ('IS', '1', "Collimator Lower Horizontal Edge", '', 'CollimatorLowerHorizontalEdge'),
0x00181710: ('IS', '2', "Center of Circular Collimator", '', 'CenterOfCircularCollimator'),
0x00181712: ('IS', '1', "Radius of Circular Collimator", '', 'RadiusOfCircularCollimator'),
0x00181720: ('IS', '2-2n', "Vertices of the Polygonal Collimator", '', 'VerticesOfThePolygonalCollimator'),
0x00181800: ('CS', '1', "Acquisition Time Synchronized", '', 'AcquisitionTimeSynchronized'),
0x00181801: ('SH', '1', "Time Source", '', 'TimeSource'),
0x00181802: ('CS', '1', "Time Distribution Protocol", '', 'TimeDistributionProtocol'),
0x00181803: ('LO', '1', "NTP Source Address", '', 'NTPSourceAddress'),
0x00182001: ('IS', '1-n', "Page Number Vector", '', 'PageNumberVector'),
0x00182002: ('SH', '1-n', "Frame Label Vector", '', 'FrameLabelVector'),
0x00182003: ('DS', '1-n', "Frame Primary Angle Vector", '', 'FramePrimaryAngleVector'),
0x00182004: ('DS', '1-n', "Frame Secondary Angle Vector", '', 'FrameSecondaryAngleVector'),
0x00182005: ('DS', '1-n', "Slice Location Vector", '', 'SliceLocationVector'),
0x00182006: ('SH', '1-n', "Display Window Label Vector", '', 'DisplayWindowLabelVector'),
0x00182010: ('DS', '2', "Nominal Scanned Pixel Spacing", '', 'NominalScannedPixelSpacing'),
0x00182020: ('CS', '1', "Digitizing Device Transport Direction", '', 'DigitizingDeviceTransportDirection'),
0x00182030: ('DS', '1', "Rotation of Scanned Film", '', 'RotationOfScannedFilm'),
0x00183100: ('CS', '1', "IVUS Acquisition", '', 'IVUSAcquisition'),
0x00183101: ('DS', '1', "IVUS Pullback Rate", '', 'IVUSPullbackRate'),
0x00183102: ('DS', '1', "IVUS Gated Rate", '', 'IVUSGatedRate'),
0x00183103: ('IS', '1', "IVUS Pullback Start Frame Number", '', 'IVUSPullbackStartFrameNumber'),
0x00183104: ('IS', '1', "IVUS Pullback Stop Frame Number", '', 'IVUSPullbackStopFrameNumber'),
0x00183105: ('IS', '1-n', "Lesion Number", '', 'LesionNumber'),
0x00184000: ('LT', '1', "Acquisition Comments", 'Retired', 'AcquisitionComments'),
0x00185000: ('SH', '1-n', "Output Power", '', 'OutputPower'),
0x00185010: ('LO', '1-n', "Transducer Data", '', 'TransducerData'),
0x00185012: ('DS', '1', "Focus Depth", '', 'FocusDepth'),
0x00185020: ('LO', '1', "Processing Function", '', 'ProcessingFunction'),
0x00185021: ('LO', '1', "Postprocessing Function", 'Retired', 'PostprocessingFunction'),
0x00185022: ('DS', '1', "Mechanical Index", '', 'MechanicalIndex'),
0x00185024: ('DS', '1', "Bone Thermal Index", '', 'BoneThermalIndex'),
0x00185026: ('DS', '1', "Cranial Thermal Index", '', 'CranialThermalIndex'),
0x00185027: ('DS', '1', "Soft Tissue Thermal Index", '', 'SoftTissueThermalIndex'),
0x00185028: ('DS', '1', "Soft Tissue-focus Thermal Index", '', 'SoftTissueFocusThermalIndex'),
0x00185029: ('DS', '1', "Soft Tissue-surface Thermal Index", '', 'SoftTissueSurfaceThermalIndex'),
0x00185030: ('DS', '1', "Dynamic Range", 'Retired', 'DynamicRange'),
0x00185040: ('DS', '1', "Total Gain", 'Retired', 'TotalGain'),
0x00185050: ('IS', '1', "Depth of Scan Field", '', 'DepthOfScanField'),
0x00185100: ('CS', '1', "Patient Position", '', 'PatientPosition'),
0x00185101: ('CS', '1', "View Position", '', 'ViewPosition'),
0x00185104: ('SQ', '1', "Projection Eponymous Name Code Sequence", '', 'ProjectionEponymousNameCodeSequence'),
0x00185210: ('DS', '6', "Image Transformation Matrix", 'Retired', 'ImageTransformationMatrix'),
0x00185212: ('DS', '3', "Image Translation Vector", 'Retired', 'ImageTranslationVector'),
0x00186000: ('DS', '1', "Sensitivity", '', 'Sensitivity'),
0x00186011: ('SQ', '1', "Sequence of Ultrasound Regions", '', 'SequenceOfUltrasoundRegions'),
0x00186012: ('US', '1', "Region Spatial Format", '', 'RegionSpatialFormat'),
0x00186014: ('US', '1', "Region Data Type", '', 'RegionDataType'),
0x00186016: ('UL', '1', "Region Flags", '', 'RegionFlags'),
0x00186018: ('UL', '1', "Region Location Min X0", '', 'RegionLocationMinX0'),
0x0018601A: ('UL', '1', "Region Location Min Y0", '', 'RegionLocationMinY0'),
0x0018601C: ('UL', '1', "Region Location Max X1", '', 'RegionLocationMaxX1'),
0x0018601E: ('UL', '1', "Region Location Max Y1", '', 'RegionLocationMaxY1'),
0x00186020: ('SL', '1', "Reference Pixel X0", '', 'ReferencePixelX0'),
0x00186022: ('SL', '1', "Reference Pixel Y0", '', 'ReferencePixelY0'),
0x00186024: ('US', '1', "Physical Units X Direction", '', 'PhysicalUnitsXDirection'),
0x00186026: ('US', '1', "Physical Units Y Direction", '', 'PhysicalUnitsYDirection'),
0x00186028: ('FD', '1', "Reference Pixel Physical Value X", '', 'ReferencePixelPhysicalValueX'),
0x0018602A: ('FD', '1', "Reference Pixel Physical Value Y", '', 'ReferencePixelPhysicalValueY'),
0x0018602C: ('FD', '1', "Physical Delta X", '', 'PhysicalDeltaX'),
0x0018602E: ('FD', '1', "Physical Delta Y", '', 'PhysicalDeltaY'),
0x00186030: ('UL', '1', "Transducer Frequency", '', 'TransducerFrequency'),
0x00186031: ('CS', '1', "Transducer Type", '', 'TransducerType'),
0x00186032: ('UL', '1', "Pulse Repetition Frequency", '', 'PulseRepetitionFrequency'),
0x00186034: ('FD', '1', "Doppler Correction Angle", '', 'DopplerCorrectionAngle'),
0x00186036: ('FD', '1', "Steering Angle", '', 'SteeringAngle'),
0x00186038: ('UL', '1', "Doppler Sample Volume X Position (Retired)", 'Retired', 'DopplerSampleVolumeXPositionRetired'),
0x00186039: ('SL', '1', "Doppler Sample Volume X Position", '', 'DopplerSampleVolumeXPosition'),
0x0018603A: ('UL', '1', "Doppler Sample Volume Y Position (Retired)", 'Retired', 'DopplerSampleVolumeYPositionRetired'),
0x0018603B: ('SL', '1', "Doppler Sample Volume Y Position", '', 'DopplerSampleVolumeYPosition'),
0x0018603C: ('UL', '1', "TM-Line Position X0 (Retired)", 'Retired', 'TMLinePositionX0Retired'),
0x0018603D: ('SL', '1', "TM-Line Position X0", '', 'TMLinePositionX0'),
0x0018603E: ('UL', '1', "TM-Line Position Y0 (Retired)", 'Retired', 'TMLinePositionY0Retired'),
0x0018603F: ('SL', '1', "TM-Line Position Y0", '', 'TMLinePositionY0'),
0x00186040: ('UL', '1', "TM-Line Position X1 (Retired)", 'Retired', 'TMLinePositionX1Retired'),
0x00186041: ('SL', '1', "TM-Line Position X1", '', 'TMLinePositionX1'),
0x00186042: ('UL', '1', "TM-Line Position Y1 (Retired)", 'Retired', 'TMLinePositionY1Retired'),
0x00186043: ('SL', '1', "TM-Line Position Y1", '', 'TMLinePositionY1'),
0x00186044: ('US', '1', "Pixel Component Organization", '', 'PixelComponentOrganization'),
0x00186046: ('UL', '1', "Pixel Component Mask", '', 'PixelComponentMask'),
0x00186048: ('UL', '1', "Pixel Component Range Start", '', 'PixelComponentRangeStart'),
0x0018604A: ('UL', '1', "Pixel Component Range Stop", '', 'PixelComponentRangeStop'),
0x0018604C: ('US', '1', "Pixel Component Physical Units", '', 'PixelComponentPhysicalUnits'),
0x0018604E: ('US', '1', "Pixel Component Data Type", '', 'PixelComponentDataType'),
0x00186050: ('UL', '1', "Number of Table Break Points", '', 'NumberOfTableBreakPoints'),
0x00186052: ('UL', '1-n', "Table of X Break Points", '', 'TableOfXBreakPoints'),
0x00186054: ('FD', '1-n', "Table of Y Break Points", '', 'TableOfYBreakPoints'),
0x00186056: ('UL', '1', "Number of Table Entries", '', 'NumberOfTableEntries'),
0x00186058: ('UL', '1-n', "Table of Pixel Values", '', 'TableOfPixelValues'),
0x0018605A: ('FL', '1-n', "Table of Parameter Values", '', 'TableOfParameterValues'),
0x00186060: ('FL', '1-n', "R Wave Time Vector", '', 'RWaveTimeVector'),
0x00187000: ('CS', '1', "Detector Conditions Nominal Flag", '', 'DetectorConditionsNominalFlag'),
0x00187001: ('DS', '1', "Detector Temperature", '', 'DetectorTemperature'),
0x00187004: ('CS', '1', "Detector Type", '', 'DetectorType'),
0x00187005: ('CS', '1', "Detector Configuration", '', 'DetectorConfiguration'),
0x00187006: ('LT', '1', "Detector Description", '', 'DetectorDescription'),
0x00187008: ('LT', '1', "Detector Mode", '', 'DetectorMode'),
0x0018700A: ('SH', '1', "Detector ID", '', 'DetectorID'),
0x0018700C: ('DA', '1', "Date of Last Detector Calibration", '', 'DateOfLastDetectorCalibration'),
0x0018700E: ('TM', '1', "Time of Last Detector Calibration", '', 'TimeOfLastDetectorCalibration'),
0x00187010: ('IS', '1', "Exposures on Detector Since Last Calibration", '', 'ExposuresOnDetectorSinceLastCalibration'),
0x00187011: ('IS', '1', "Exposures on Detector Since Manufactured", '', 'ExposuresOnDetectorSinceManufactured'),
0x00187012: ('DS', '1', "Detector Time Since Last Exposure", '', 'DetectorTimeSinceLastExposure'),
0x00187014: ('DS', '1', "Detector Active Time", '', 'DetectorActiveTime'),
0x00187016: ('DS', '1', "Detector Activation Offset From Exposure", '', 'DetectorActivationOffsetFromExposure'),
0x0018701A: ('DS', '2', "Detector Binning", '', 'DetectorBinning'),
0x00187020: ('DS', '2', "Detector Element Physical Size", '', 'DetectorElementPhysicalSize'),
0x00187022: ('DS', '2', "Detector Element Spacing", '', 'DetectorElementSpacing'),
0x00187024: ('CS', '1', "Detector Active Shape", '', 'DetectorActiveShape'),
0x00187026: ('DS', '1-2', "Detector Active Dimension(s)", '', 'DetectorActiveDimensions'),
0x00187028: ('DS', '2', "Detector Active Origin", '', 'DetectorActiveOrigin'),
0x0018702A: ('LO', '1', "Detector Manufacturer Name", '', 'DetectorManufacturerName'),
0x0018702B: ('LO', '1', "Detector Manufacturer's Model Name", '', 'DetectorManufacturerModelName'),
0x00187030: ('DS', '2', "Field of View Origin", '', 'FieldOfViewOrigin'),
0x00187032: ('DS', '1', "Field of View Rotation", '', 'FieldOfViewRotation'),
0x00187034: ('CS', '1', "Field of View Horizontal Flip", '', 'FieldOfViewHorizontalFlip'),
0x00187036: ('FL', '2', "Pixel Data Area Origin Relative To FOV", '', 'PixelDataAreaOriginRelativeToFOV'),
0x00187038: ('FL', '1', "Pixel Data Area Rotation Angle Relative To FOV", '', 'PixelDataAreaRotationAngleRelativeToFOV'),
0x00187040: ('LT', '1', "Grid Absorbing Material", '', 'GridAbsorbingMaterial'),
0x00187041: ('LT', '1', "Grid Spacing Material", '', 'GridSpacingMaterial'),
0x00187042: ('DS', '1', "Grid Thickness", '', 'GridThickness'),
0x00187044: ('DS', '1', "Grid Pitch", '', 'GridPitch'),
0x00187046: ('IS', '2', "Grid Aspect Ratio", '', 'GridAspectRatio'),
0x00187048: ('DS', '1', "Grid Period", '', 'GridPeriod'),
0x0018704C: ('DS', '1', "Grid Focal Distance", '', 'GridFocalDistance'),
0x00187050: ('CS', '1-n', "Filter Material", '', 'FilterMaterial'),
0x00187052: ('DS', '1-n', "Filter Thickness Minimum", '', 'FilterThicknessMinimum'),
0x00187054: ('DS', '1-n', "Filter Thickness Maximum", '', 'FilterThicknessMaximum'),
0x00187056: ('FL', '1-n', "Filter Beam Path Length Minimum", '', 'FilterBeamPathLengthMinimum'),
0x00187058: ('FL', '1-n', "Filter Beam Path Length Maximum", '', 'FilterBeamPathLengthMaximum'),
0x00187060: ('CS', '1', "Exposure Control Mode", '', 'ExposureControlMode'),
0x00187062: ('LT', '1', "Exposure Control Mode Description", '', 'ExposureControlModeDescription'),
0x00187064: ('CS', '1', "Exposure Status", '', 'ExposureStatus'),
0x00187065: ('DS', '1', "Phototimer Setting", '', 'PhototimerSetting'),
0x00188150: ('DS', '1', "Exposure Time in uS", '', 'ExposureTimeInuS'),
0x00188151: ('DS', '1', "X-Ray Tube Current in uA", '', 'XRayTubeCurrentInuA'),
0x00189004: ('CS', '1', "Content Qualification", '', 'ContentQualification'),
0x00189005: ('SH', '1', "Pulse Sequence Name", '', 'PulseSequenceName'),
0x00189006: ('SQ', '1', "MR Imaging Modifier Sequence", '', 'MRImagingModifierSequence'),
0x00189008: ('CS', '1', "Echo Pulse Sequence", '', 'EchoPulseSequence'),
0x00189009: ('CS', '1', "Inversion Recovery", '', 'InversionRecovery'),
0x00189010: ('CS', '1', "Flow Compensation", '', 'FlowCompensation'),
0x00189011: ('CS', '1', "Multiple Spin Echo", '', 'MultipleSpinEcho'),
0x00189012: ('CS', '1', "Multi-planar Excitation", '', 'MultiPlanarExcitation'),
0x00189014: ('CS', '1', "Phase Contrast", '', 'PhaseContrast'),
0x00189015: ('CS', '1', "Time of Flight Contrast", '', 'TimeOfFlightContrast'),
0x00189016: ('CS', '1', "Spoiling", '', 'Spoiling'),
0x00189017: ('CS', '1', "Steady State Pulse Sequence", '', 'SteadyStatePulseSequence'),
0x00189018: ('CS', '1', "Echo Planar Pulse Sequence", '', 'EchoPlanarPulseSequence'),
0x00189019: ('FD', '1', "Tag Angle First Axis", '', 'TagAngleFirstAxis'),
0x00189020: ('CS', '1', "Magnetization Transfer", '', 'MagnetizationTransfer'),
0x00189021: ('CS', '1', "T2 Preparation", '', 'T2Preparation'),
0x00189022: ('CS', '1', "Blood Signal Nulling", '', 'BloodSignalNulling'),
0x00189024: ('CS', '1', "Saturation Recovery", '', 'SaturationRecovery'),
0x00189025: ('CS', '1', "Spectrally Selected Suppression", '', 'SpectrallySelectedSuppression'),
0x00189026: ('CS', '1', "Spectrally Selected Excitation", '', 'SpectrallySelectedExcitation'),
0x00189027: ('CS', '1', "Spatial Pre-saturation", '', 'SpatialPresaturation'),
0x00189028: ('CS', '1', "Tagging", '', 'Tagging'),
0x00189029: ('CS', '1', "Oversampling Phase", '', 'OversamplingPhase'),
0x00189030: ('FD', '1', "Tag Spacing First Dimension", '', 'TagSpacingFirstDimension'),
0x00189032: ('CS', '1', "Geometry of k-Space Traversal", '', 'GeometryOfKSpaceTraversal'),
0x00189033: ('CS', '1', "Segmented k-Space Traversal", '', 'SegmentedKSpaceTraversal'),
0x00189034: ('CS', '1', "Rectilinear Phase Encode Reordering", '', 'RectilinearPhaseEncodeReordering'),
0x00189035: ('FD', '1', "Tag Thickness", '', 'TagThickness'),
0x00189036: ('CS', '1', "Partial Fourier Direction", '', 'PartialFourierDirection'),
0x00189037: ('CS', '1', "Cardiac Synchronization Technique", '', 'CardiacSynchronizationTechnique'),
0x00189041: ('LO', '1', "Receive Coil Manufacturer Name", '', 'ReceiveCoilManufacturerName'),
0x00189042: ('SQ', '1', "MR Receive Coil Sequence", '', 'MRReceiveCoilSequence'),
0x00189043: ('CS', '1', "Receive Coil Type", '', 'ReceiveCoilType'),
0x00189044: ('CS', '1', "Quadrature Receive Coil", '', 'QuadratureReceiveCoil'),
0x00189045: ('SQ', '1', "Multi-Coil Definition Sequence", '', 'MultiCoilDefinitionSequence'),
0x00189046: ('LO', '1', "Multi-Coil Configuration", '', 'MultiCoilConfiguration'),
0x00189047: ('SH', '1', "Multi-Coil Element Name", '', 'MultiCoilElementName'),
0x00189048: ('CS', '1', "Multi-Coil Element Used", '', 'MultiCoilElementUsed'),
0x00189049: ('SQ', '1', "MR Transmit Coil Sequence", '', 'MRTransmitCoilSequence'),
0x00189050: ('LO', '1', "Transmit Coil Manufacturer Name", '', 'TransmitCoilManufacturerName'),
0x00189051: ('CS', '1', "Transmit Coil Type", '', 'TransmitCoilType'),
0x00189052: ('FD', '1-2', "Spectral Width", '', 'SpectralWidth'),
0x00189053: ('FD', '1-2', "Chemical Shift Reference", '', 'ChemicalShiftReference'),
0x00189054: ('CS', '1', "Volume Localization Technique", '', 'VolumeLocalizationTechnique'),
0x00189058: ('US', '1', "MR Acquisition Frequency Encoding Steps", '', 'MRAcquisitionFrequencyEncodingSteps'),
0x00189059: ('CS', '1', "De-coupling", '', 'Decoupling'),
0x00189060: ('CS', '1-2', "De-coupled Nucleus", '', 'DecoupledNucleus'),
0x00189061: ('FD', '1-2', "De-coupling Frequency", '', 'DecouplingFrequency'),
0x00189062: ('CS', '1', "De-coupling Method", '', 'DecouplingMethod'),
0x00189063: ('FD', '1-2', "De-coupling Chemical Shift Reference", '', 'DecouplingChemicalShiftReference'),
0x00189064: ('CS', '1', "k-space Filtering", '', 'KSpaceFiltering'),
0x00189065: ('CS', '1-2', "Time Domain Filtering", '', 'TimeDomainFiltering'),
0x00189066: ('US', '1-2', "Number of Zero Fills", '', 'NumberOfZeroFills'),
0x00189067: ('CS', '1', "Baseline Correction", '', 'BaselineCorrection'),
0x00189069: ('FD', '1', "Parallel Reduction Factor In-plane", '', 'ParallelReductionFactorInPlane'),
0x00189070: ('FD', '1', "Cardiac R-R Interval Specified", '', 'CardiacRRIntervalSpecified'),
0x00189073: ('FD', '1', "Acquisition Duration", '', 'AcquisitionDuration'),
0x00189074: ('DT', '1', "Frame Acquisition DateTime", '', 'FrameAcquisitionDateTime'),
0x00189075: ('CS', '1', "Diffusion Directionality", '', 'DiffusionDirectionality'),
0x00189076: ('SQ', '1', "Diffusion Gradient Direction Sequence", '', 'DiffusionGradientDirectionSequence'),
0x00189077: ('CS', '1', "Parallel Acquisition", '', 'ParallelAcquisition'),
0x00189078: ('CS', '1', "Parallel Acquisition Technique", '', 'ParallelAcquisitionTechnique'),
0x00189079: ('FD', '1-n', "Inversion Times", '', 'InversionTimes'),
0x00189080: ('ST', '1', "Metabolite Map Description", '', 'MetaboliteMapDescription'),
0x00189081: ('CS', '1', "Partial Fourier", '', 'PartialFourier'),
0x00189082: ('FD', '1', "Effective Echo Time", '', 'EffectiveEchoTime'),
0x00189083: ('SQ', '1', "Metabolite Map Code Sequence", '', 'MetaboliteMapCodeSequence'),
0x00189084: ('SQ', '1', "Chemical Shift Sequence", '', 'ChemicalShiftSequence'),
0x00189085: ('CS', '1', "Cardiac Signal Source", '', 'CardiacSignalSource'),
0x00189087: ('FD', '1', "Diffusion b-value", '', 'DiffusionBValue'),
0x00189089: ('FD', '3', "Diffusion Gradient Orientation", '', 'DiffusionGradientOrientation'),
0x00189090: ('FD', '3', "Velocity Encoding Direction", '', 'VelocityEncodingDirection'),
0x00189091: ('FD', '1', "Velocity Encoding Minimum Value", '', 'VelocityEncodingMinimumValue'),
0x00189092: ('SQ', '1', "Velocity Encoding Acquisition Sequence", '', 'VelocityEncodingAcquisitionSequence'),
0x00189093: ('US', '1', "Number of k-Space Trajectories", '', 'NumberOfKSpaceTrajectories'),
0x00189094: ('CS', '1', "Coverage of k-Space", '', 'CoverageOfKSpace'),
0x00189095: ('UL', '1', "Spectroscopy Acquisition Phase Rows", '', 'SpectroscopyAcquisitionPhaseRows'),
0x00189096: ('FD', '1', "Parallel Reduction Factor In-plane (Retired)", 'Retired', 'ParallelReductionFactorInPlaneRetired'),
0x00189098: ('FD', '1-2', "Transmitter Frequency", '', 'TransmitterFrequency'),
0x00189100: ('CS', '1-2', "Resonant Nucleus", '', 'ResonantNucleus'),
0x00189101: ('CS', '1', "Frequency Correction", '', 'FrequencyCorrection'),
0x00189103: ('SQ', '1', "MR Spectroscopy FOV/Geometry Sequence", '', 'MRSpectroscopyFOVGeometrySequence'),
0x00189104: ('FD', '1', "Slab Thickness", '', 'SlabThickness'),
0x00189105: ('FD', '3', "Slab Orientation", '', 'SlabOrientation'),
0x00189106: ('FD', '3', "Mid Slab Position", '', 'MidSlabPosition'),
0x00189107: ('SQ', '1', "MR Spatial Saturation Sequence", '', 'MRSpatialSaturationSequence'),
0x00189112: ('SQ', '1', "MR Timing and Related Parameters Sequence", '', 'MRTimingAndRelatedParametersSequence'),
0x00189114: ('SQ', '1', "MR Echo Sequence", '', 'MREchoSequence'),
0x00189115: ('SQ', '1', "MR Modifier Sequence", '', 'MRModifierSequence'),
0x00189117: ('SQ', '1', "MR Diffusion Sequence", '', 'MRDiffusionSequence'),
0x00189118: ('SQ', '1', "Cardiac Synchronization", '', 'CardiacSynchronization'),
0x00189119: ('SQ', '1', "MR Averages Sequence", '', 'MRAveragesSequence'),
0x00189125: ('SQ', '1', "MR FOV/Geometry Sequence", '', 'MRFOVGeometrySequence'),
0x00189126: ('SQ', '1', "Volume Localization Sequence", '', 'VolumeLocalizationSequence'),
0x00189127: ('UL', '1', "Spectroscopy Acquisition Data Columns", '', 'SpectroscopyAcquisitionDataColumns'),
0x00189147: ('CS', '1', "Diffusion Anisotropy Type", '', 'DiffusionAnisotropyType'),
0x00189151: ('DT', '1', "Frame Reference DateTime", '', 'FrameReferenceDateTime'),
0x00189152: ('SQ', '1', "MR Metabolite Map Sequence", '', 'MRMetaboliteMapSequence'),
0x00189155: ('FD', '1', "Parallel Reduction Factor out-of-plane", '', 'ParallelReductionFactorOutOfPlane'),
0x00189159: ('UL', '1', "Spectroscopy Acquisition Out-of-plane Phase Steps", '', 'SpectroscopyAcquisitionOutOfPlanePhaseSteps'),
0x00189166: ('CS', '1', "Bulk Motion Status", 'Retired', 'BulkMotionStatus'),
0x00189168: ('FD', '1', "Parallel Reduction Factor Second In-plane", '', 'ParallelReductionFactorSecondInPlane'),
0x00189169: ('CS', '1', "Cardiac Beat Rejection Technique", '', 'CardiacBeatRejectionTechnique'),
0x00189170: ('CS', '1', "Respiratory Motion Compensation Technique", '', 'RespiratoryMotionCompensationTechnique'),
0x00189171: ('CS', '1', "Respiratory Signal Source", '', 'RespiratorySignalSource'),
0x00189172: ('CS', '1', "Bulk Motion Compensation Technique", '', 'BulkMotionCompensationTechnique'),
0x00189173: ('CS', '1', "Bulk Motion Signal Source", '', 'BulkMotionSignalSource'),
0x00189174: ('CS', '1', "Applicable Safety Standard Agency", '', 'ApplicableSafetyStandardAgency'),
0x00189175: ('LO', '1', "Applicable Safety Standard Description", '', 'ApplicableSafetyStandardDescription'),
0x00189176: ('SQ', '1', "Operating Mode Sequence", '', 'OperatingModeSequence'),
0x00189177: ('CS', '1', "Operating Mode Type", '', 'OperatingModeType'),
0x00189178: ('CS', '1', "Operating Mode", '', 'OperatingMode'),
0x00189179: ('CS', '1', "Specific Absorption Rate Definition", '', 'SpecificAbsorptionRateDefinition'),
0x00189180: ('CS', '1', "Gradient Output Type", '', 'GradientOutputType'),
0x00189181: ('FD', '1', "Specific Absorption Rate Value", '', 'SpecificAbsorptionRateValue'),
0x00189182: ('FD', '1', "Gradient Output", '', 'GradientOutput'),
0x00189183: ('CS', '1', "Flow Compensation Direction", '', 'FlowCompensationDirection'),
0x00189184: ('FD', '1', "Tagging Delay", '', 'TaggingDelay'),
0x00189185: ('ST', '1', "Respiratory Motion Compensation Technique Description", '', 'RespiratoryMotionCompensationTechniqueDescription'),
0x00189186: ('SH', '1', "Respiratory Signal Source ID", '', 'RespiratorySignalSourceID'),
0x00189195: ('FD', '1', "Chemical Shift Minimum Integration Limit in Hz", 'Retired', 'ChemicalShiftMinimumIntegrationLimitInHz'),
0x00189196: ('FD', '1', "Chemical Shift Maximum Integration Limit in Hz", 'Retired', 'ChemicalShiftMaximumIntegrationLimitInHz'),
0x00189197: ('SQ', '1', "MR Velocity Encoding Sequence", '', 'MRVelocityEncodingSequence'),
0x00189198: ('CS', '1', "First Order Phase Correction", '', 'FirstOrderPhaseCorrection'),
0x00189199: ('CS', '1', "Water Referenced Phase Correction", '', 'WaterReferencedPhaseCorrection'),
0x00189200: ('CS', '1', "MR Spectroscopy Acquisition Type", '', 'MRSpectroscopyAcquisitionType'),
0x00189214: ('CS', '1', "Respiratory Cycle Position", '', 'RespiratoryCyclePosition'),
0x00189217: ('FD', '1', "Velocity Encoding Maximum Value", '', 'VelocityEncodingMaximumValue'),
0x00189218: ('FD', '1', "Tag Spacing Second Dimension", '', 'TagSpacingSecondDimension'),
0x00189219: ('SS', '1', "Tag Angle Second Axis", '', 'TagAngleSecondAxis'),
0x00189220: ('FD', '1', "Frame Acquisition Duration", '', 'FrameAcquisitionDuration'),
0x00189226: ('SQ', '1', "MR Image Frame Type Sequence", '', 'MRImageFrameTypeSequence'),
0x00189227: ('SQ', '1', "MR Spectroscopy Frame Type Sequence", '', 'MRSpectroscopyFrameTypeSequence'),
0x00189231: ('US', '1', "MR Acquisition Phase Encoding Steps in-plane", '', 'MRAcquisitionPhaseEncodingStepsInPlane'),
0x00189232: ('US', '1', "MR Acquisition Phase Encoding Steps out-of-plane", '', 'MRAcquisitionPhaseEncodingStepsOutOfPlane'),
0x00189234: ('UL', '1', "Spectroscopy Acquisition Phase Columns", '', 'SpectroscopyAcquisitionPhaseColumns'),
0x00189236: ('CS', '1', "Cardiac Cycle Position", '', 'CardiacCyclePosition'),
0x00189239: ('SQ', '1', "Specific Absorption Rate Sequence", '', 'SpecificAbsorptionRateSequence'),
0x00189240: ('US', '1', "RF Echo Train Length", '', 'RFEchoTrainLength'),
0x00189241: ('US', '1', "Gradient Echo Train Length", '', 'GradientEchoTrainLength'),
0x00189250: ('CS', '1', "Arterial Spin Labeling Contrast", '', 'ArterialSpinLabelingContrast'),
0x00189251: ('SQ', '1', "MR Arterial Spin Labeling Sequence", '', 'MRArterialSpinLabeling'),
0x00189252: ('LO', '1', "ASL Technique Description", '', 'ASLTechniqueDescription'),
0x00189253: ('US', '1', "ASL Slab Number", '', 'ASLSlabNumber'),
0x00189254: ('FD', '1', "ASL Slab Thickness", '', 'ASLSlabThickness'),
0x00189255: ('FD', '3', "ASL Slab Orientation", '', 'ASLSlabOrientation'),
0x00189256: ('FD', '3', "ASL Mid Slab Position", '', 'ASLMidSlabPosition'),
0x00189257: ('CS', '1', "ASL Context", '', 'ASLContext'),
0x00189258: ('UL', '1', "ASL Pulse Train Duration", '', 'ASLPulseTrainDuration'),
0x00189259: ('CS', '1', "ASL Crusher Flag", '', 'ASLCrusherFlag'),
0x0018925A: ('FD', '1', "ASL Crusher Flow", '', 'ASLCrusherFlow'),
0x0018925B: ('LO', '1', "ASL Crusher Description", '', 'ASLCrusherDescription'),
0x0018925C: ('CS', '1', "ASL Bolus Cut-off Flag", '', 'ASLBolusCutoffFlag'),
0x0018925D: ('SQ', '1', "ASL Bolus Cut-off Timing Sequence", '', 'ASLBolusCutoffTimingSequence'),
0x0018925E: ('LO', '1', "ASL Bolus Cut-off Technique", '', 'ASLBolusCutoffTechnique'),
0x0018925F: ('UL', '1', "ASL Bolus Cut-off Delay Time", '', 'ASLBolusCutoffDelayTime'),
0x00189260: ('SQ', '1', "ASL Slab Sequence", '', 'ASLSlabSequence'),
0x00189295: ('FD', '1', "Chemical Shift Minimum Integration Limit in ppm", '', 'ChemicalShiftMinimumIntegrationLimitInppm'),
0x00189296: ('FD', '1', "Chemical Shift Maximum Integration Limit in ppm", '', 'ChemicalShiftMaximumIntegrationLimitInppm'),
0x00189301: ('SQ', '1', "CT Acquisition Type Sequence", '', 'CTAcquisitionTypeSequence'),
0x00189302: ('CS', '1', "Acquisition Type", '', 'AcquisitionType'),
0x00189303: ('FD', '1', "Tube Angle", '', 'TubeAngle'),
0x00189304: ('SQ', '1', "CT Acquisition Details Sequence", '', 'CTAcquisitionDetailsSequence'),
0x00189305: ('FD', '1', "Revolution Time", '', 'RevolutionTime'),
0x00189306: ('FD', '1', "Single Collimation Width", '', 'SingleCollimationWidth'),
0x00189307: ('FD', '1', "Total Collimation Width", '', 'TotalCollimationWidth'),
0x00189308: ('SQ', '1', "CT Table Dynamics Sequence", '', 'CTTableDynamicsSequence'),
0x00189309: ('FD', '1', "Table Speed", '', 'TableSpeed'),
0x00189310: ('FD', '1', "Table Feed per Rotation", '', 'TableFeedPerRotation'),
0x00189311: ('FD', '1', "Spiral Pitch Factor", '', 'SpiralPitchFactor'),
0x00189312: ('SQ', '1', "CT Geometry Sequence", '', 'CTGeometrySequence'),
0x00189313: ('FD', '3', "Data Collection Center (Patient)", '', 'DataCollectionCenterPatient'),
0x00189314: ('SQ', '1', "CT Reconstruction Sequence", '', 'CTReconstructionSequence'),
0x00189315: ('CS', '1', "Reconstruction Algorithm", '', 'ReconstructionAlgorithm'),
0x00189316: ('CS', '1', "Convolution Kernel Group", '', 'ConvolutionKernelGroup'),
0x00189317: ('FD', '2', "Reconstruction Field of View", '', 'ReconstructionFieldOfView'),
0x00189318: ('FD', '3', "Reconstruction Target Center (Patient)", '', 'ReconstructionTargetCenterPatient'),
0x00189319: ('FD', '1', "Reconstruction Angle", '', 'ReconstructionAngle'),
0x00189320: ('SH', '1', "Image Filter", '', 'ImageFilter'),
0x00189321: ('SQ', '1', "CT Exposure Sequence", '', 'CTExposureSequence'),
0x00189322: ('FD', '2', "Reconstruction Pixel Spacing", '', 'ReconstructionPixelSpacing'),
0x00189323: ('CS', '1', "Exposure Modulation Type", '', 'ExposureModulationType'),
0x00189324: ('FD', '1', "Estimated Dose Saving", '', 'EstimatedDoseSaving'),
0x00189325: ('SQ', '1', "CT X-Ray Details Sequence", '', 'CTXRayDetailsSequence'),
0x00189326: ('SQ', '1', "CT Position Sequence", '', 'CTPositionSequence'),
0x00189327: ('FD', '1', "Table Position", '', 'TablePosition'),
0x00189328: ('FD', '1', "Exposure Time in ms", '', 'ExposureTimeInms'),
0x00189329: ('SQ', '1', "CT Image Frame Type Sequence", '', 'CTImageFrameTypeSequence'),
0x00189330: ('FD', '1', "X-Ray Tube Current in mA", '', 'XRayTubeCurrentInmA'),
0x00189332: ('FD', '1', "Exposure in mAs", '', 'ExposureInmAs'),
0x00189333: ('CS', '1', "Constant Volume Flag", '', 'ConstantVolumeFlag'),
0x00189334: ('CS', '1', "Fluoroscopy Flag", '', 'FluoroscopyFlag'),
0x00189335: ('FD', '1', "Distance Source to Data Collection Center", '', 'DistanceSourceToDataCollectionCenter'),
0x00189337: ('US', '1', "Contrast/Bolus Agent Number", '', 'ContrastBolusAgentNumber'),
0x00189338: ('SQ', '1', "Contrast/Bolus Ingredient Code Sequence", '', 'ContrastBolusIngredientCodeSequence'),
0x00189340: ('SQ', '1', "Contrast Administration Profile Sequence", '', 'ContrastAdministrationProfileSequence'),
0x00189341: ('SQ', '1', "Contrast/Bolus Usage Sequence", '', 'ContrastBolusUsageSequence'),
0x00189342: ('CS', '1', "Contrast/Bolus Agent Administered", '', 'ContrastBolusAgentAdministered'),
0x00189343: ('CS', '1', "Contrast/Bolus Agent Detected", '', 'ContrastBolusAgentDetected'),
0x00189344: ('CS', '1', "Contrast/Bolus Agent Phase", '', 'ContrastBolusAgentPhase'),
0x00189345: ('FD', '1', "CTDIvol", '', 'CTDIvol'),
0x00189346: ('SQ', '1', "CTDI Phantom Type Code Sequence", '', 'CTDIPhantomTypeCodeSequence'),
0x00189351: ('FL', '1', "Calcium Scoring Mass Factor Patient", '', 'CalciumScoringMassFactorPatient'),
0x00189352: ('FL', '3', "Calcium Scoring Mass Factor Device", '', 'CalciumScoringMassFactorDevice'),
0x00189353: ('FL', '1', "Energy Weighting Factor", '', 'EnergyWeightingFactor'),
0x00189360: ('SQ', '1', "CT Additional X-Ray Source Sequence", '', 'CTAdditionalXRaySourceSequence'),
0x00189401: ('SQ', '1', "Projection Pixel Calibration Sequence", '', 'ProjectionPixelCalibrationSequence'),
0x00189402: ('FL', '1', "Distance Source to Isocenter", '', 'DistanceSourceToIsocenter'),
0x00189403: ('FL', '1', "Distance Object to Table Top", '', 'DistanceObjectToTableTop'),
0x00189404: ('FL', '2', "Object Pixel Spacing in Center of Beam", '', 'ObjectPixelSpacingInCenterOfBeam'),
0x00189405: ('SQ', '1', "Positioner Position Sequence", '', 'PositionerPositionSequence'),
0x00189406: ('SQ', '1', "Table Position Sequence", '', 'TablePositionSequence'),
0x00189407: ('SQ', '1', "Collimator Shape Sequence", '', 'CollimatorShapeSequence'),
0x00189410: ('CS', '1', "Planes in Acquisition", '', 'PlanesInAcquisition'),
0x00189412: ('SQ', '1', "XA/XRF Frame Characteristics Sequence", '', 'XAXRFFrameCharacteristicsSequence'),
0x00189417: ('SQ', '1', "Frame Acquisition Sequence", '', 'FrameAcquisitionSequence'),
0x00189420: ('CS', '1', "X-Ray Receptor Type", '', 'XRayReceptorType'),
0x00189423: ('LO', '1', "Acquisition Protocol Name", '', 'AcquisitionProtocolName'),
0x00189424: ('LT', '1', "Acquisition Protocol Description", '', 'AcquisitionProtocolDescription'),
0x00189425: ('CS', '1', "Contrast/Bolus Ingredient Opaque", '', 'ContrastBolusIngredientOpaque'),
0x00189426: ('FL', '1', "Distance Receptor Plane to Detector Housing", '', 'DistanceReceptorPlaneToDetectorHousing'),
0x00189427: ('CS', '1', "Intensifier Active Shape", '', 'IntensifierActiveShape'),
0x00189428: ('FL', '1-2', "Intensifier Active Dimension(s)", '', 'IntensifierActiveDimensions'),
0x00189429: ('FL', '2', "Physical Detector Size", '', 'PhysicalDetectorSize'),
0x00189430: ('FL', '2', "Position of Isocenter Projection", '', 'PositionOfIsocenterProjection'),
0x00189432: ('SQ', '1', "Field of View Sequence", '', 'FieldOfViewSequence'),
0x00189433: ('LO', '1', "Field of View Description", '', 'FieldOfViewDescription'),
0x00189434: ('SQ', '1', "Exposure Control Sensing Regions Sequence", '', 'ExposureControlSensingRegionsSequence'),
0x00189435: ('CS', '1', "Exposure Control Sensing Region Shape", '', 'ExposureControlSensingRegionShape'),
0x00189436: ('SS', '1', "Exposure Control Sensing Region Left Vertical Edge", '', 'ExposureControlSensingRegionLeftVerticalEdge'),
0x00189437: ('SS', '1', "Exposure Control Sensing Region Right Vertical Edge", '', 'ExposureControlSensingRegionRightVerticalEdge'),
0x00189438: ('SS', '1', "Exposure Control Sensing Region Upper Horizontal Edge", '', 'ExposureControlSensingRegionUpperHorizontalEdge'),
0x00189439: ('SS', '1', "Exposure Control Sensing Region Lower Horizontal Edge", '', 'ExposureControlSensingRegionLowerHorizontalEdge'),
0x00189440: ('SS', '2', "Center of Circular Exposure Control Sensing Region", '', 'CenterOfCircularExposureControlSensingRegion'),
0x00189441: ('US', '1', "Radius of Circular Exposure Control Sensing Region", '', 'RadiusOfCircularExposureControlSensingRegion'),
0x00189442: ('SS', '2-n', "Vertices of the Polygonal Exposure Control Sensing Region", '', 'VerticesOfThePolygonalExposureControlSensingRegion'),
0x00189445: ('OB', '1', "Retired-blank", 'Retired', ''),
0x00189447: ('FL', '1', "Column Angulation (Patient)", '', 'ColumnAngulationPatient'),
0x00189449: ('FL', '1', "Beam Angle", '', 'BeamAngle'),
0x00189451: ('SQ', '1', "Frame Detector Parameters Sequence", '', 'FrameDetectorParametersSequence'),
0x00189452: ('FL', '1', "Calculated Anatomy Thickness", '', 'CalculatedAnatomyThickness'),
0x00189455: ('SQ', '1', "Calibration Sequence", '', 'CalibrationSequence'),
0x00189456: ('SQ', '1', "Object Thickness Sequence", '', 'ObjectThicknessSequence'),
0x00189457: ('CS', '1', "Plane Identification", '', 'PlaneIdentification'),
0x00189461: ('FL', '1-2', "Field of View Dimension(s) in Float", '', 'FieldOfViewDimensionsInFloat'),
0x00189462: ('SQ', '1', "Isocenter Reference System Sequence", '', 'IsocenterReferenceSystemSequence'),
0x00189463: ('FL', '1', "Positioner Isocenter Primary Angle", '', 'PositionerIsocenterPrimaryAngle'),
0x00189464: ('FL', '1', "Positioner Isocenter Secondary Angle", '', 'PositionerIsocenterSecondaryAngle'),
0x00189465: ('FL', '1', "Positioner Isocenter Detector Rotation Angle", '', 'PositionerIsocenterDetectorRotationAngle'),
0x00189466: ('FL', '1', "Table X Position to Isocenter", '', 'TableXPositionToIsocenter'),
0x00189467: ('FL', '1', "Table Y Position to Isocenter", '', 'TableYPositionToIsocenter'),
0x00189468: ('FL', '1', "Table Z Position to Isocenter", '', 'TableZPositionToIsocenter'),
0x00189469: ('FL', '1', "Table Horizontal Rotation Angle", '', 'TableHorizontalRotationAngle'),
0x00189470: ('FL', '1', "Table Head Tilt Angle", '', 'TableHeadTiltAngle'),
0x00189471: ('FL', '1', "Table Cradle Tilt Angle", '', 'TableCradleTiltAngle'),
0x00189472: ('SQ', '1', "Frame Display Shutter Sequence", '', 'FrameDisplayShutterSequence'),
0x00189473: ('FL', '1', "Acquired Image Area Dose Product", '', 'AcquiredImageAreaDoseProduct'),
0x00189474: ('CS', '1', "C-arm Positioner Tabletop Relationship", '', 'CArmPositionerTabletopRelationship'),
0x00189476: ('SQ', '1', "X-Ray Geometry Sequence", '', 'XRayGeometrySequence'),
0x00189477: ('SQ', '1', "Irradiation Event Identification Sequence", '', 'IrradiationEventIdentificationSequence'),
0x00189504: ('SQ', '1', "X-Ray 3D Frame Type Sequence", '', 'XRay3DFrameTypeSequence'),
0x00189506: ('SQ', '1', "Contributing Sources Sequence", '', 'ContributingSourcesSequence'),
0x00189507: ('SQ', '1', "X-Ray 3D Acquisition Sequence", '', 'XRay3DAcquisitionSequence'),
0x00189508: ('FL', '1', "Primary Positioner Scan Arc", '', 'PrimaryPositionerScanArc'),
0x00189509: ('FL', '1', "Secondary Positioner Scan Arc", '', 'SecondaryPositionerScanArc'),
0x00189510: ('FL', '1', "Primary Positioner Scan Start Angle", '', 'PrimaryPositionerScanStartAngle'),
0x00189511: ('FL', '1', "Secondary Positioner Scan Start Angle", '', 'SecondaryPositionerScanStartAngle'),
0x00189514: ('FL', '1', "Primary Positioner Increment", '', 'PrimaryPositionerIncrement'),
0x00189515: ('FL', '1', "Secondary Positioner Increment", '', 'SecondaryPositionerIncrement'),
0x00189516: ('DT', '1', "Start Acquisition DateTime", '', 'StartAcquisitionDateTime'),
0x00189517: ('DT', '1', "End Acquisition DateTime", '', 'EndAcquisitionDateTime'),
0x00189524: ('LO', '1', "Application Name", '', 'ApplicationName'),
0x00189525: ('LO', '1', "Application Version", '', 'ApplicationVersion'),
0x00189526: ('LO', '1', "Application Manufacturer", '', 'ApplicationManufacturer'),
0x00189527: ('CS', '1', "Algorithm Type", '', 'AlgorithmType'),
0x00189528: ('LO', '1', "Algorithm Description", '', 'AlgorithmDescription'),
0x00189530: ('SQ', '1', "X-Ray 3D Reconstruction Sequence", '', 'XRay3DReconstructionSequence'),
0x00189531: ('LO', '1', "Reconstruction Description", '', 'ReconstructionDescription'),
0x00189538: ('SQ', '1', "Per Projection Acquisition Sequence", '', 'PerProjectionAcquisitionSequence'),
0x00189601: ('SQ', '1', "Diffusion b-matrix Sequence", '', 'DiffusionBMatrixSequence'),
0x00189602: ('FD', '1', "Diffusion b-value XX", '', 'DiffusionBValueXX'),
0x00189603: ('FD', '1', "Diffusion b-value XY", '', 'DiffusionBValueXY'),
0x00189604: ('FD', '1', "Diffusion b-value XZ", '', 'DiffusionBValueXZ'),
0x00189605: ('FD', '1', "Diffusion b-value YY", '', 'DiffusionBValueYY'),
0x00189606: ('FD', '1', "Diffusion b-value YZ", '', 'DiffusionBValueYZ'),
0x00189607: ('FD', '1', "Diffusion b-value ZZ", '', 'DiffusionBValueZZ'),
0x00189701: ('DT', '1', "Decay Correction DateTime", '', 'DecayCorrectionDateTime'),
0x00189715: ('FD', '1', "Start Density Threshold", '', 'StartDensityThreshold'),
0x00189716: ('FD', '1', "Start Relative Density Difference Threshold", '', 'StartRelativeDensityDifferenceThreshold'),
0x00189717: ('FD', '1', "Start Cardiac Trigger Count Threshold", '', 'StartCardiacTriggerCountThreshold'),
0x00189718: ('FD', '1', "Start Respiratory Trigger Count Threshold", '', 'StartRespiratoryTriggerCountThreshold'),
0x00189719: ('FD', '1', "Termination Counts Threshold", '', 'TerminationCountsThreshold'),
0x00189720: ('FD', '1', "Termination Density Threshold", '', 'TerminationDensityThreshold'),
0x00189721: ('FD', '1', "Termination Relative Density Threshold", '', 'TerminationRelativeDensityThreshold'),
0x00189722: ('FD', '1', "Termination Time Threshold", '', 'TerminationTimeThreshold'),
0x00189723: ('FD', '1', "Termination Cardiac Trigger Count Threshold", '', 'TerminationCardiacTriggerCountThreshold'),
0x00189724: ('FD', '1', "Termination Respiratory Trigger Count Threshold", '', 'TerminationRespiratoryTriggerCountThreshold'),
0x00189725: ('CS', '1', "Detector Geometry", '', 'DetectorGeometry'),
0x00189726: ('FD', '1', "Transverse Detector Separation", '', 'TransverseDetectorSeparation'),
0x00189727: ('FD', '1', "Axial Detector Dimension", '', 'AxialDetectorDimension'),
0x00189729: ('US', '1', "Radiopharmaceutical Agent Number", '', 'RadiopharmaceuticalAgentNumber'),
0x00189732: ('SQ', '1', "PET Frame Acquisition Sequence", '', 'PETFrameAcquisitionSequence'),
0x00189733: ('SQ', '1', "PET Detector Motion Details Sequence", '', 'PETDetectorMotionDetailsSequence'),
0x00189734: ('SQ', '1', "PET Table Dynamics Sequence", '', 'PETTableDynamicsSequence'),
0x00189735: ('SQ', '1', "PET Position Sequence", '', 'PETPositionSequence'),
0x00189736: ('SQ', '1', "PET Frame Correction Factors Sequence", '', 'PETFrameCorrectionFactorsSequence'),
0x00189737: ('SQ', '1', "Radiopharmaceutical Usage Sequence", '', 'RadiopharmaceuticalUsageSequence'),
0x00189738: ('CS', '1', "Attenuation Correction Source", '', 'AttenuationCorrectionSource'),
0x00189739: ('US', '1', "Number of Iterations", '', 'NumberOfIterations'),
0x00189740: ('US', '1', "Number of Subsets", '', 'NumberOfSubsets'),
0x00189749: ('SQ', '1', "PET Reconstruction Sequence", '', 'PETReconstructionSequence'),
0x00189751: ('SQ', '1', "PET Frame Type Sequence", '', 'PETFrameTypeSequence'),
0x00189755: ('CS', '1', "Time of Flight Information Used", '', 'TimeOfFlightInformationUsed'),
0x00189756: ('CS', '1', "Reconstruction Type", '', 'ReconstructionType'),
0x00189758: ('CS', '1', "Decay Corrected", '', 'DecayCorrected'),
0x00189759: ('CS', '1', "Attenuation Corrected", '', 'AttenuationCorrected'),
0x00189760: ('CS', '1', "Scatter Corrected", '', 'ScatterCorrected'),
0x00189761: ('CS', '1', "Dead Time Corrected", '', 'DeadTimeCorrected'),
0x00189762: ('CS', '1', "Gantry Motion Corrected", '', 'GantryMotionCorrected'),
0x00189763: ('CS', '1', "Patient Motion Corrected", '', 'PatientMotionCorrected'),
0x00189764: ('CS', '1', "Count Loss Normalization Corrected", '', 'CountLossNormalizationCorrected'),
0x00189765: ('CS', '1', "Randoms Corrected", '', 'RandomsCorrected'),
0x00189766: ('CS', '1', "Non-uniform Radial Sampling Corrected", '', 'NonUniformRadialSamplingCorrected'),
0x00189767: ('CS', '1', "Sensitivity Calibrated", '', 'SensitivityCalibrated'),
0x00189768: ('CS', '1', "Detector Normalization Correction", '', 'DetectorNormalizationCorrection'),
0x00189769: ('CS', '1', "Iterative Reconstruction Method", '', 'IterativeReconstructionMethod'),
0x00189770: ('CS', '1', "Attenuation Correction Temporal Relationship", '', 'AttenuationCorrectionTemporalRelationship'),
0x00189771: ('SQ', '1', "Patient Physiological State Sequence", '', 'PatientPhysiologicalStateSequence'),
0x00189772: ('SQ', '1', "Patient Physiological State Code Sequence", '', 'PatientPhysiologicalStateCodeSequence'),
0x00189801: ('FD', '1-n', "Depth(s) of Focus", '', 'DepthsOfFocus'),
0x00189803: ('SQ', '1', "Excluded Intervals Sequence", '', 'ExcludedIntervalsSequence'),
0x00189804: ('DT', '1', "Exclusion Start Datetime", '', 'ExclusionStartDatetime'),
0x00189805: ('FD', '1', "Exclusion Duration", '', 'ExclusionDuration'),
0x00189806: ('SQ', '1', "US Image Description Sequence", '', 'USImageDescriptionSequence'),
0x00189807: ('SQ', '1', "Image Data Type Sequence", '', 'ImageDataTypeSequence'),
0x00189808: ('CS', '1', "Data Type", '', 'DataType'),
0x00189809: ('SQ', '1', "Transducer Scan Pattern Code Sequence", '', 'TransducerScanPatternCodeSequence'),
0x0018980B: ('CS', '1', "Aliased Data Type", '', 'AliasedDataType'),
0x0018980C: ('CS', '1', "Position Measuring Device Used", '', 'PositionMeasuringDeviceUsed'),
0x0018980D: ('SQ', '1', "Transducer Geometry Code Sequence", '', 'TransducerGeometryCodeSequence'),
0x0018980E: ('SQ', '1', "Transducer Beam Steering Code Sequence", '', 'TransducerBeamSteeringCodeSequence'),
0x0018980F: ('SQ', '1', "Transducer Application Code Sequence", '', 'TransducerApplicationCodeSequence'),
0x0018A001: ('SQ', '1', "Contributing Equipment Sequence", '', 'ContributingEquipmentSequence'),
0x0018A002: ('DT', '1', "Contribution Date Time", '', 'ContributionDateTime'),
0x0018A003: ('ST', '1', "Contribution Description", '', 'ContributionDescription'),
0x0020000D: ('UI', '1', "Study Instance UID", '', 'StudyInstanceUID'),
0x0020000E: ('UI', '1', "Series Instance UID", '', 'SeriesInstanceUID'),
0x00200010: ('SH', '1', "Study ID", '', 'StudyID'),
0x00200011: ('IS', '1', "Series Number", '', 'SeriesNumber'),
0x00200012: ('IS', '1', "Acquisition Number", '', 'AcquisitionNumber'),
0x00200013: ('IS', '1', "Instance Number", '', 'InstanceNumber'),
0x00200014: ('IS', '1', "Isotope Number", 'Retired', 'IsotopeNumber'),
0x00200015: ('IS', '1', "Phase Number", 'Retired', 'PhaseNumber'),
0x00200016: ('IS', '1', "Interval Number", 'Retired', 'IntervalNumber'),
0x00200017: ('IS', '1', "Time Slot Number", 'Retired', 'TimeSlotNumber'),
0x00200018: ('IS', '1', "Angle Number", 'Retired', 'AngleNumber'),
0x00200019: ('IS', '1', "Item Number", '', 'ItemNumber'),
0x00200020: ('CS', '2', "Patient Orientation", '', 'PatientOrientation'),
0x00200022: ('IS', '1', "Overlay Number", 'Retired', 'OverlayNumber'),
0x00200024: ('IS', '1', "Curve Number", 'Retired', 'CurveNumber'),
0x00200026: ('IS', '1', "LUT Number", 'Retired', 'LUTNumber'),
0x00200030: ('DS', '3', "Image Position", 'Retired', 'ImagePosition'),
0x00200032: ('DS', '3', "Image Position (Patient)", '', 'ImagePositionPatient'),
0x00200035: ('DS', '6', "Image Orientation", 'Retired', 'ImageOrientation'),
0x00200037: ('DS', '6', "Image Orientation (Patient)", '', 'ImageOrientationPatient'),
0x00200050: ('DS', '1', "Location", 'Retired', 'Location'),
0x00200052: ('UI', '1', "Frame of Reference UID", '', 'FrameOfReferenceUID'),
0x00200060: ('CS', '1', "Laterality", '', 'Laterality'),
0x00200062: ('CS', '1', "Image Laterality", '', 'ImageLaterality'),
0x00200070: ('LO', '1', "Image Geometry Type", 'Retired', 'ImageGeometryType'),
0x00200080: ('CS', '1-n', "Masking Image", 'Retired', 'MaskingImage'),
0x002000AA: ('IS', '1', "Report Number", 'Retired', 'ReportNumber'),
0x00200100: ('IS', '1', "Temporal Position Identifier", '', 'TemporalPositionIdentifier'),
0x00200105: ('IS', '1', "Number of Temporal Positions", '', 'NumberOfTemporalPositions'),
0x00200110: ('DS', '1', "Temporal Resolution", '', 'TemporalResolution'),
0x00200200: ('UI', '1', "Synchronization Frame of Reference UID", '', 'SynchronizationFrameOfReferenceUID'),
0x00200242: ('UI', '1', "SOP Instance UID of Concatenation Source", '', 'SOPInstanceUIDOfConcatenationSource'),
0x00201000: ('IS', '1', "Series in Study", 'Retired', 'SeriesInStudy'),
0x00201001: ('IS', '1', "Acquisitions in Series", 'Retired', 'AcquisitionsInSeries'),
0x00201002: ('IS', '1', "Images in Acquisition", '', 'ImagesInAcquisition'),
0x00201003: ('IS', '1', "Images in Series", 'Retired', 'ImagesInSeries'),
0x00201004: ('IS', '1', "Acquisitions in Study", 'Retired', 'AcquisitionsInStudy'),
0x00201005: ('IS', '1', "Images in Study", 'Retired', 'ImagesInStudy'),
0x00201020: ('LO', '1-n', "Reference", 'Retired', 'Reference'),
0x00201040: ('LO', '1', "Position Reference Indicator", '', 'PositionReferenceIndicator'),
0x00201041: ('DS', '1', "Slice Location", '', 'SliceLocation'),
0x00201070: ('IS', '1-n', "Other Study Numbers", 'Retired', 'OtherStudyNumbers'),
0x00201200: ('IS', '1', "Number of Patient Related Studies", '', 'NumberOfPatientRelatedStudies'),
0x00201202: ('IS', '1', "Number of Patient Related Series", '', 'NumberOfPatientRelatedSeries'),
0x00201204: ('IS', '1', "Number of Patient Related Instances", '', 'NumberOfPatientRelatedInstances'),
0x00201206: ('IS', '1', "Number of Study Related Series", '', 'NumberOfStudyRelatedSeries'),
0x00201208: ('IS', '1', "Number of Study Related Instances", '', 'NumberOfStudyRelatedInstances'),
0x00201209: ('IS', '1', "Number of Series Related Instances", '', 'NumberOfSeriesRelatedInstances'),
0x00203401: ('CS', '1', "Modifying Device ID", 'Retired', 'ModifyingDeviceID'),
0x00203402: ('CS', '1', "Modified Image ID", 'Retired', 'ModifiedImageID'),
0x00203403: ('DA', '1', "Modified Image Date", 'Retired', 'ModifiedImageDate'),
0x00203404: ('LO', '1', "Modifying Device Manufacturer", 'Retired', 'ModifyingDeviceManufacturer'),
0x00203405: ('TM', '1', "Modified Image Time", 'Retired', 'ModifiedImageTime'),
0x00203406: ('LO', '1', "Modified Image Description", 'Retired', 'ModifiedImageDescription'),
0x00204000: ('LT', '1', "Image Comments", '', 'ImageComments'),
0x00205000: ('AT', '1-n', "Original Image Identification", 'Retired', 'OriginalImageIdentification'),
0x00205002: ('LO', '1-n', "Original Image Identification Nomenclature", 'Retired', 'OriginalImageIdentificationNomenclature'),
0x00209056: ('SH', '1', "Stack ID", '', 'StackID'),
0x00209057: ('UL', '1', "In-Stack Position Number", '', 'InStackPositionNumber'),
0x00209071: ('SQ', '1', "Frame Anatomy Sequence", '', 'FrameAnatomySequence'),
0x00209072: ('CS', '1', "Frame Laterality", '', 'FrameLaterality'),
0x00209111: ('SQ', '1', "Frame Content Sequence", '', 'FrameContentSequence'),
0x00209113: ('SQ', '1', "Plane Position Sequence", '', 'PlanePositionSequence'),
0x00209116: ('SQ', '1', "Plane Orientation Sequence", '', 'PlaneOrientationSequence'),
0x00209128: ('UL', '1', "Temporal Position Index", '', 'TemporalPositionIndex'),
0x00209153: ('FD', '1', "Nominal Cardiac Trigger Delay Time", '', 'NominalCardiacTriggerDelayTime'),
0x00209154: ('FL', '1', "Nominal Cardiac Trigger Time Prior To R-Peak", '', 'NominalCardiacTriggerTimePriorToRPeak'),
0x00209155: ('FL', '1', "Actual Cardiac Trigger Time Prior To R-Peak", '', 'ActualCardiacTriggerTimePriorToRPeak'),
0x00209156: ('US', '1', "Frame Acquisition Number", '', 'FrameAcquisitionNumber'),
0x00209157: ('UL', '1-n', "Dimension Index Values", '', 'DimensionIndexValues'),
0x00209158: ('LT', '1', "Frame Comments", '', 'FrameComments'),
0x00209161: ('UI', '1', "Concatenation UID", '', 'ConcatenationUID'),
0x00209162: ('US', '1', "In-concatenation Number", '', 'InConcatenationNumber'),
0x00209163: ('US', '1', "In-concatenation Total Number", '', 'InConcatenationTotalNumber'),
0x00209164: ('UI', '1', "Dimension Organization UID", '', 'DimensionOrganizationUID'),
0x00209165: ('AT', '1', "Dimension Index Pointer", '', 'DimensionIndexPointer'),
0x00209167: ('AT', '1', "Functional Group Pointer", '', 'FunctionalGroupPointer'),
0x00209213: ('LO', '1', "Dimension Index Private Creator", '', 'DimensionIndexPrivateCreator'),
0x00209221: ('SQ', '1', "Dimension Organization Sequence", '', 'DimensionOrganizationSequence'),
0x00209222: ('SQ', '1', "Dimension Index Sequence", '', 'DimensionIndexSequence'),
0x00209228: ('UL', '1', "Concatenation Frame Offset Number", '', 'ConcatenationFrameOffsetNumber'),
0x00209238: ('LO', '1', "Functional Group Private Creator", '', 'FunctionalGroupPrivateCreator'),
0x00209241: ('FL', '1', "Nominal Percentage of Cardiac Phase", '', 'NominalPercentageOfCardiacPhase'),
0x00209245: ('FL', '1', "Nominal Percentage of Respiratory Phase", '', 'NominalPercentageOfRespiratoryPhase'),
0x00209246: ('FL', '1', "Starting Respiratory Amplitude", '', 'StartingRespiratoryAmplitude'),
0x00209247: ('CS', '1', "Starting Respiratory Phase", '', 'StartingRespiratoryPhase'),
0x00209248: ('FL', '1', "Ending Respiratory Amplitude", '', 'EndingRespiratoryAmplitude'),
0x00209249: ('CS', '1', "Ending Respiratory Phase", '', 'EndingRespiratoryPhase'),
0x00209250: ('CS', '1', "Respiratory Trigger Type", '', 'RespiratoryTriggerType'),
0x00209251: ('FD', '1', "R-R Interval Time Nominal", '', 'RRIntervalTimeNominal'),
0x00209252: ('FD', '1', "Actual Cardiac Trigger Delay Time", '', 'ActualCardiacTriggerDelayTime'),
0x00209253: ('SQ', '1', "Respiratory Synchronization Sequence", '', 'RespiratorySynchronizationSequence'),
0x00209254: ('FD', '1', "Respiratory Interval Time", '', 'RespiratoryIntervalTime'),
0x00209255: ('FD', '1', "Nominal Respiratory Trigger Delay Time", '', 'NominalRespiratoryTriggerDelayTime'),
0x00209256: ('FD', '1', "Respiratory Trigger Delay Threshold", '', 'RespiratoryTriggerDelayThreshold'),
0x00209257: ('FD', '1', "Actual Respiratory Trigger Delay Time", '', 'ActualRespiratoryTriggerDelayTime'),
0x00209301: ('FD', '3', "Image Position (Volume)", '', 'ImagePositionVolume'),
0x00209302: ('FD', '6', "Image Orientation (Volume)", '', 'ImageOrientationVolume'),
0x00209307: ('CS', '1', "Ultrasound Acquisition Geometry", '', 'UltrasoundAcquisitionGeometry'),
0x00209308: ('FD', '3', "Apex Position", '', 'ApexPosition'),
0x00209309: ('FD', '16', "Volume to Transducer Mapping Matrix", '', 'VolumeToTransducerMappingMatrix'),
0x0020930A: ('FD', '16', "Volume to Table Mapping Matrix", '', 'VolumeToTableMappingMatrix'),
0x0020930C: ('CS', '1', "Patient Frame of Reference Source", '', 'PatientFrameOfReferenceSource'),
0x0020930D: ('FD', '1', "Temporal Position Time Offset", '', 'TemporalPositionTimeOffset'),
0x0020930E: ('SQ', '1', "Plane Position (Volume) Sequence", '', 'PlanePositionVolumeSequence'),
0x0020930F: ('SQ', '1', "Plane Orientation (Volume) Sequence", '', 'PlaneOrientationVolumeSequence'),
0x00209310: ('SQ', '1', "Temporal Position Sequence", '', 'TemporalPositionSequence'),
0x00209311: ('CS', '1', "Dimension Organization Type", '', 'DimensionOrganizationType'),
0x00209312: ('UI', '1', "Volume Frame of Reference UID", '', 'VolumeFrameOfReferenceUID'),
0x00209313: ('UI', '1', "Table Frame of Reference UID", '', 'TableFrameOfReferenceUID'),
0x00209421: ('LO', '1', "Dimension Description Label", '', 'DimensionDescriptionLabel'),
0x00209450: ('SQ', '1', "Patient Orientation in Frame Sequence", '', 'PatientOrientationInFrameSequence'),
0x00209453: ('LO', '1', "Frame Label", '', 'FrameLabel'),
0x00209518: ('US', '1-n', "Acquisition Index", '', 'AcquisitionIndex'),
0x00209529: ('SQ', '1', "Contributing SOP Instances Reference Sequence", '', 'ContributingSOPInstancesReferenceSequence'),
0x00209536: ('US', '1', "Reconstruction Index", '', 'ReconstructionIndex'),
0x00220001: ('US', '1', "Light Path Filter Pass-Through Wavelength", '', 'LightPathFilterPassThroughWavelength'),
0x00220002: ('US', '2', "Light Path Filter Pass Band", '', 'LightPathFilterPassBand'),
0x00220003: ('US', '1', "Image Path Filter Pass-Through Wavelength", '', 'ImagePathFilterPassThroughWavelength'),
0x00220004: ('US', '2', "Image Path Filter Pass Band", '', 'ImagePathFilterPassBand'),
0x00220005: ('CS', '1', "Patient Eye Movement Commanded", '', 'PatientEyeMovementCommanded'),
0x00220006: ('SQ', '1', "Patient Eye Movement Command Code Sequence", '', 'PatientEyeMovementCommandCodeSequence'),
0x00220007: ('FL', '1', "Spherical Lens Power", '', 'SphericalLensPower'),
0x00220008: ('FL', '1', "Cylinder Lens Power", '', 'CylinderLensPower'),
0x00220009: ('FL', '1', "Cylinder Axis", '', 'CylinderAxis'),
0x0022000A: ('FL', '1', "Emmetropic Magnification", '', 'EmmetropicMagnification'),
0x0022000B: ('FL', '1', "Intra Ocular Pressure", '', 'IntraOcularPressure'),
0x0022000C: ('FL', '1', "Horizontal Field of View", '', 'HorizontalFieldOfView'),
0x0022000D: ('CS', '1', "Pupil Dilated", '', 'PupilDilated'),
0x0022000E: ('FL', '1', "Degree of Dilation", '', 'DegreeOfDilation'),
0x00220010: ('FL', '1', "Stereo Baseline Angle", '', 'StereoBaselineAngle'),
0x00220011: ('FL', '1', "Stereo Baseline Displacement", '', 'StereoBaselineDisplacement'),
0x00220012: ('FL', '1', "Stereo Horizontal Pixel Offset", '', 'StereoHorizontalPixelOffset'),
0x00220013: ('FL', '1', "Stereo Vertical Pixel Offset", '', 'StereoVerticalPixelOffset'),
0x00220014: ('FL', '1', "Stereo Rotation", '', 'StereoRotation'),
0x00220015: ('SQ', '1', "Acquisition Device Type Code Sequence", '', 'AcquisitionDeviceTypeCodeSequence'),
0x00220016: ('SQ', '1', "Illumination Type Code Sequence", '', 'IlluminationTypeCodeSequence'),
0x00220017: ('SQ', '1', "Light Path Filter Type Stack Code Sequence", '', 'LightPathFilterTypeStackCodeSequence'),
0x00220018: ('SQ', '1', "Image Path Filter Type Stack Code Sequence", '', 'ImagePathFilterTypeStackCodeSequence'),
0x00220019: ('SQ', '1', "Lenses Code Sequence", '', 'LensesCodeSequence'),
0x0022001A: ('SQ', '1', "Channel Description Code Sequence", '', 'ChannelDescriptionCodeSequence'),
0x0022001B: ('SQ', '1', "Refractive State Sequence", '', 'RefractiveStateSequence'),
0x0022001C: ('SQ', '1', "Mydriatic Agent Code Sequence", '', 'MydriaticAgentCodeSequence'),
0x0022001D: ('SQ', '1', "Relative Image Position Code Sequence", '', 'RelativeImagePositionCodeSequence'),
0x0022001E: ('FL', '1', "Camera Angle of View", '', 'CameraAngleOfView'),
0x00220020: ('SQ', '1', "Stereo Pairs Sequence", '', 'StereoPairsSequence'),
0x00220021: ('SQ', '1', "Left Image Sequence", '', 'LeftImageSequence'),
0x00220022: ('SQ', '1', "Right Image Sequence", '', 'RightImageSequence'),
0x00220030: ('FL', '1', "Axial Length of the Eye", '', 'AxialLengthOfTheEye'),
0x00220031: ('SQ', '1', "Ophthalmic Frame Location Sequence", '', 'OphthalmicFrameLocationSequence'),
0x00220032: ('FL', '2-2n', "Reference Coordinates", '', 'ReferenceCoordinates'),
0x00220035: ('FL', '1', "Depth Spatial Resolution", '', 'DepthSpatialResolution'),
0x00220036: ('FL', '1', "Maximum Depth Distortion", '', 'MaximumDepthDistortion'),
0x00220037: ('FL', '1', "Along-scan Spatial Resolution", '', 'AlongScanSpatialResolution'),
0x00220038: ('FL', '1', "Maximum Along-scan Distortion", '', 'MaximumAlongScanDistortion'),
0x00220039: ('CS', '1', "Ophthalmic Image Orientation", '', 'OphthalmicImageOrientation'),
0x00220041: ('FL', '1', "Depth of Transverse Image", '', 'DepthOfTransverseImage'),
0x00220042: ('SQ', '1', "Mydriatic Agent Concentration Units Sequence", '', 'MydriaticAgentConcentrationUnitsSequence'),
0x00220048: ('FL', '1', "Across-scan Spatial Resolution", '', 'AcrossScanSpatialResolution'),
0x00220049: ('FL', '1', "Maximum Across-scan Distortion", '', 'MaximumAcrossScanDistortion'),
0x0022004E: ('DS', '1', "Mydriatic Agent Concentration", '', 'MydriaticAgentConcentration'),
0x00220055: ('FL', '1', "Illumination Wave Length", '', 'IlluminationWaveLength'),
0x00220056: ('FL', '1', "Illumination Power", '', 'IlluminationPower'),
0x00220057: ('FL', '1', "Illumination Bandwidth", '', 'IlluminationBandwidth'),
0x00220058: ('SQ', '1', "Mydriatic Agent Sequence", '', 'MydriaticAgentSequence'),
0x00221007: ('SQ', '1', "Ophthalmic Axial Measurements Right Eye Sequence", '', 'OphthalmicAxialMeasurementsRightEyeSequence'),
0x00221008: ('SQ', '1', "Ophthalmic Axial Measurements Left Eye Sequence", '', 'OphthalmicAxialMeasurementsLeftEyeSequence'),
0x00221010: ('CS', '1', "Ophthalmic Axial Length Measurements Type", '', 'OphthalmicAxialLengthMeasurementsType'),
0x00221019: ('FL', '1', "Ophthalmic Axial Length", '', 'OphthalmicAxialLength'),
0x00221024: ('SQ', '1', "Lens Status Code Sequence", '', 'LensStatusCodeSequence'),
0x00221025: ('SQ', '1', "Vitreous Status Code Sequence", '', 'VitreousStatusCodeSequence'),
0x00221028: ('SQ', '1', "IOL Formula Code Sequence", '', 'IOLFormulaCodeSequence'),
0x00221029: ('LO', '1', "IOL Formula Detail", '', 'IOLFormulaDetail'),
0x00221033: ('FL', '1', "Keratometer Index", '', 'KeratometerIndex'),
0x00221035: ('SQ', '1', "Source of Ophthalmic Axial Length Code Sequence", '', 'SourceOfOphthalmicAxialLengthCodeSequence'),
0x00221037: ('FL', '1', "Target Refraction", '', 'TargetRefraction'),
0x00221039: ('CS', '1', "Refractive Procedure Occurred", '', 'RefractiveProcedureOccurred'),
0x00221040: ('SQ', '1', "Refractive Surgery Type Code Sequence", '', 'RefractiveSurgeryTypeCodeSequence'),
0x00221044: ('SQ', '1', "Ophthalmic Ultrasound Axial Measurements Type Code Sequence", '', 'OphthalmicUltrasoundAxialMeasurementsTypeCodeSequence'),
0x00221050: ('SQ', '1', "Ophthalmic Axial Length Measurements Sequence", '', 'OphthalmicAxialLengthMeasurementsSequence'),
0x00221053: ('FL', '1', "IOL Power", '', 'IOLPower'),
0x00221054: ('FL', '1', "Predicted Refractive Error", '', 'PredictedRefractiveError'),
0x00221059: ('FL', '1', "Ophthalmic Axial Length Velocity", '', 'OphthalmicAxialLengthVelocity'),
0x00221065: ('LO', '1', "Lens Status Description", '', 'LensStatusDescription'),
0x00221066: ('LO', '1', "Vitreous Status Description", '', 'VitreousStatusDescription'),
0x00221090: ('SQ', '1', "IOL Power Sequence", '', 'IOLPowerSequence'),
0x00221092: ('SQ', '1', "Lens Constant Sequence", '', 'LensConstantSequence'),
0x00221093: ('LO', '1', "IOL Manufacturer", '', 'IOLManufacturer'),
0x00221094: ('LO', '1', "Lens Constant Description", '', 'LensConstantDescription'),
0x00221096: ('SQ', '1', "Keratometry Measurement Type Code Sequence", '', 'KeratometryMeasurementTypeCodeSequence'),
0x00221100: ('SQ', '1', "Referenced Ophthalmic Axial Measurements Sequence", '', 'ReferencedOphthalmicAxialMeasurementsSequence'),
0x00221101: ('SQ', '1', "Ophthalmic Axial Length Measurements Segment Name Code Sequence", '', 'OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence'),
0x00221103: ('SQ', '1', "Refractive Error Before Refractive Surgery Code Sequence", '', 'RefractiveErrorBeforeRefractiveSurgeryCodeSequence'),
0x00221121: ('FL', '1', "IOL Power For Exact Emmetropia", '', 'IOLPowerForExactEmmetropia'),
0x00221122: ('FL', '1', "IOL Power For Exact Target Refraction", '', 'IOLPowerForExactTargetRefraction'),
0x00221125: ('SQ', '1', "Anterior Chamber Depth Definition Code Sequence", '', 'AnteriorChamberDepthDefinitionCodeSequence'),
0x00221130: ('FL', '1', "Lens Thickness", '', 'LensThickness'),
0x00221131: ('FL', '1', "Anterior Chamber Depth", '', 'AnteriorChamberDepth'),
0x00221132: ('SQ', '1', "Source of Lens Thickness Data Code Sequence", '', 'SourceOfLensThicknessDataCodeSequence'),
0x00221133: ('SQ', '1', "Source of Anterior Chamber Depth Data Code Sequence", '', 'SourceOfAnteriorChamberDepthDataCodeSequence'),
0x00221135: ('SQ', '1', "Source of Refractive Error Data Code Sequence", '', 'SourceOfRefractiveErrorDataCodeSequence'),
0x00221140: ('CS', '1', "Ophthalmic Axial Length Measurement Modified", '', 'OphthalmicAxialLengthMeasurementModified'),
0x00221150: ('SQ', '1', "Ophthalmic Axial Length Data Source Code Sequence", '', 'OphthalmicAxialLengthDataSourceCodeSequence'),
0x00221153: ('SQ', '1', "Ophthalmic Axial Length Acquisition Method Code Sequence", '', 'OphthalmicAxialLengthAcquisitionMethodCodeSequence'),
0x00221155: ('FL', '1', "Signal to Noise Ratio", '', 'SignalToNoiseRatio'),
0x00221159: ('LO', '1', "Ophthalmic Axial Length Data Source Description", '', 'OphthalmicAxialLengthDataSourceDescription'),
0x00221210: ('SQ', '1', "Ophthalmic Axial Length Measurements Total Length Sequence", '', 'OphthalmicAxialLengthMeasurementsTotalLengthSequence'),
0x00221211: ('SQ', '1', "Ophthalmic Axial Length Measurements Segmental Length Sequence", '', 'OphthalmicAxialLengthMeasurementsSegmentalLengthSequence'),
0x00221212: ('SQ', '1', "Ophthalmic Axial Length Measurements Length Summation Sequence", '', 'OphthalmicAxialLengthMeasurementsLengthSummationSequence'),
0x00221220: ('SQ', '1', "Ultrasound Ophthalmic Axial Length Measurements Sequence", '', 'UltrasoundOphthalmicAxialLengthMeasurementsSequence'),
0x00221225: ('SQ', '1', "Optical Ophthalmic Axial Length Measurements Sequence", '', 'OpticalOphthalmicAxialLengthMeasurementsSequence'),
0x00221230: ('SQ', '1', "Ultrasound Selected Ophthalmic Axial Length Sequence", '', 'UltrasoundSelectedOphthalmicAxialLengthSequence'),
0x00221250: ('SQ', '1', "Ophthalmic Axial Length Selection Method Code Sequence", '', 'OphthalmicAxialLengthSelectionMethodCodeSequence'),
0x00221255: ('SQ', '1', "Optical Selected Ophthalmic Axial Length Sequence", '', 'OpticalSelectedOphthalmicAxialLengthSequence'),
0x00221257: ('SQ', '1', "Selected Segmental Ophthalmic Axial Length Sequence", '', 'SelectedSegmentalOphthalmicAxialLengthSequence'),
0x00221260: ('SQ', '1', "Selected Total Ophthalmic Axial Length Sequence", '', 'SelectedTotalOphthalmicAxialLengthSequence'),
0x00221262: ('SQ', '1', "Ophthalmic Axial Length Quality Metric Sequence", '', 'OphthalmicAxialLengthQualityMetricSequence'),
0x00221273: ('LO', '1', "Ophthalmic Axial  Length Quality Metric Type Description", '', 'OphthalmicAxialLengthQualityMetricTypeDescription'),
0x00221300: ('SQ', '1', "Intraocular Lens Calculations Right Eye Sequence", '', 'IntraocularLensCalculationsRightEyeSequence'),
0x00221310: ('SQ', '1', "Intraocular Lens Calculations Left Eye Sequence", '', 'IntraocularLensCalculationsLeftEyeSequence'),
0x00221330: ('SQ', '1', "Referenced Ophthalmic Axial Length Measurement QC ImageSequence", '', 'ReferencedOphthalmicAxialLengthMeasurementQCImage'),
0x00240010: ('FL', '1', "Visual Field Horizontal Extent", '', 'VisualFieldHorizontalExtent'),
0x00240011: ('FL', '1', "Visual Field Vertical Extent", '', 'VisualFieldVerticalExtent'),
0x00240012: ('CS', '1', "Visual Field Shape", '', 'VisualFieldShape'),
0x00240016: ('SQ', '1', "Screening Test Mode Code Sequence", '', 'ScreeningTestModeCodeSequence'),
0x00240018: ('FL', '1', "Maximum Stimulus Luminance", '', 'MaximumStimulusLuminance'),
0x00240020: ('FL', '1', "Background Luminance", '', 'BackgroundLuminance'),
0x00240021: ('SQ', '1', "Stimulus Color Code Sequence", '', 'StimulusColorCodeSequence'),
0x00240024: ('SQ', '1', "Background Illumination Color Code Sequence", '', 'BackgroundIlluminationColorCodeSequence'),
0x00240025: ('FL', '1', "Stimulus Area", '', 'StimulusArea'),
0x00240028: ('FL', '1', "Stimulus Presentation Time", '', 'StimulusPresentationTime'),
0x00240032: ('SQ', '1', "Fixation Sequence", '', 'FixationSequence'),
0x00240033: ('SQ', '1', "Fixation Monitoring Code Sequence", '', 'FixationMonitoringCodeSequence'),
0x00240034: ('SQ', '1', "Visual Field Catch Trial Sequence", '', 'VisualFieldCatchTrialSequence'),
0x00240035: ('US', '1', "Fixation Checked Quantity", '', 'FixationCheckedQuantity'),
0x00240036: ('US', '1', "Patient Not Properly Fixated Quantity", '', 'PatientNotProperlyFixatedQuantity'),
0x00240037: ('CS', '1', "Presented Stimuli Data Flag", '', 'PresentedDataFlag'),
0x00240038: ('US', '1', "Number of Visual Stimuli", '', 'NumberOfVisualStimuli'),
0x00240039: ('CS', '1', "Excessive Fixation Losses Data Flag", '', 'ExcessiveFixationLossesDataFlag'),
0x00240040: ('CS', '1', "Excessive Fixation Losses", '', 'ExcessiveFixationLosses'),
0x00240042: ('US', '1', "Stimuli Retesting", '', 'StimuliRetesting'),
0x00240044: ('LT', '1', "Comments on Patient's Performance of Visual Field", '', 'CommentsOnPatientPerformanceOfVisualField'),
0x00240045: ('CS', '1', "False Negatives Estimate Flag", '', 'FalseNegativesEstimateFlag'),
0x00240046: ('FL', '1', "False Negatives Estimate", '', 'FalseNegativesEstimate'),
0x00240048: ('US', '1', "Negative Catch Trials", '', 'NegativeCatchTrials'),
0x00240050: ('US', '1', "False Negatives", '', 'FalseNegatives'),
0x00240051: ('CS', '1', "Excessive False Negatives Data Flag", '', 'ExcessiveFalseNegativesDataFlag'),
0x00240052: ('CS', '1', "Excessive False Negatives", '', 'ExcessiveFalseNegatives'),
0x00240053: ('CS', '1', "False Positives Estimate Flag", '', 'FalsePositivesEstimateFlag'),
0x00240054: ('FL', '1', "False Positives Estimate", '', 'FalsePositivesEstimate'),
0x00240055: ('CS', '1', "Catch Trials Data Flag", '', 'CatchTrialsDataFlag'),
0x00240056: ('US', '1', "Positive Catch Trials", '', 'PositiveCatchTrials'),
0x00240057: ('CS', '1', "Test Point Normals Data Flag", '', 'TestPointNormalsDataFlag'),
0x00240058: ('SQ', '1', "Test Point Normals Sequence", '', 'TestPointNormalsSequence'),
0x00240059: ('CS', '1', "Global Deviation Probability Normals Flag", '', 'GlobalDeviationProbabilityNormalsFlag'),
0x00240060: ('US', '1', "False Positives", '', 'FalsePositives'),
0x00240061: ('CS', '1', "Excessive False Positives Data Flag", '', 'ExcessiveFalsePositivesDataFlag'),
0x00240062: ('CS', '1', "Excessive False Positives", '', 'ExcessiveFalsePositives'),
0x00240063: ('CS', '1', "Visual Field Test Normals Flag", '', 'VisualFieldTestNormalsFlag'),
0x00240064: ('SQ', '1', "Results Normals Sequence", '', 'ResultsNormalsSequence'),
0x00240065: ('SQ', '1', "Age Corrected Sensitivity Deviation Algorithm Sequence", '', 'AgeCorrectedSensitivityDeviationAlgorithmSequence'),
0x00240066: ('FL', '1', "Global Deviation From Normal", '', 'GlobalDeviationFromNormal'),
0x00240067: ('SQ', '1', "Generalized Defect Sensitivity Deviation Algorithm Sequence", '', 'GeneralizedDefectSensitivityDeviationAlgorithmSequence'),
0x00240068: ('FL', '1', "Localized Deviation from Normal", '', 'LocalizedDeviationfromNormal'),
0x00240069: ('LO', '1', "Patient Reliability Indicator", '', 'PatientReliabilityIndicator'),
0x00240070: ('FL', '1', "Visual Field Mean Sensitivity", '', 'VisualFieldMeanSensitivity'),
0x00240071: ('FL', '1', "Global Deviation Probability", '', 'GlobalDeviationProbability'),
0x00240072: ('CS', '1', "Local Deviation Probability Normals Flag", '', 'LocalDeviationProbabilityNormalsFlag'),
0x00240073: ('FL', '1', "Localized Deviation Probability", '', 'LocalizedDeviationProbability'),
0x00240074: ('CS', '1', "Short Term Fluctuation Calculated", '', 'ShortTermFluctuationCalculated'),
0x00240075: ('FL', '1', "Short Term Fluctuation", '', 'ShortTermFluctuation'),
0x00240076: ('CS', '1', "Short Term Fluctuation Probability Calculated", '', 'ShortTermFluctuationProbabilityCalculated'),
0x00240077: ('FL', '1', "Short Term Fluctuation Probability", '', 'ShortTermFluctuationProbability'),
0x00240078: ('CS', '1', "Corrected Localized Deviation From Normal Calculated", '', 'CorrectedLocalizedDeviationFromNormalCalculated'),
0x00240079: ('FL', '1', "Corrected Localized Deviation From Normal", '', 'CorrectedLocalizedDeviationFromNormal'),
0x00240080: ('CS', '1', "Corrected Localized Deviation From Normal Probability Calculated", '', 'CorrectedLocalizedDeviationFromNormalProbabilityCalculated'),
0x00240081: ('FL', '1', "Corrected Localized Deviation From Normal Probability", '', 'CorrectedLocalizedDeviationFromNormalProbability'),
0x00240083: ('SQ', '1', "Global Deviation Sequence", '', 'GlobalDeviation'),
0x00240085: ('SQ', '1', "Localized Deviation Sequence", '', 'LocalizedDeviation'),
0x00240086: ('CS', '1', "Foveal Sensitivity Measured", '', 'FovealSensitivityMeasured'),
0x00240087: ('FL', '1', "Foveal Sensitivity", '', 'FovealSensitivity'),
0x00240088: ('FL', '1', "Visual Field Test Duration", '', 'VisualFieldTestDuration'),
0x00240089: ('SQ', '1', "Visual Field Test Point Sequence", '', 'VisualFieldTestPointSequence'),
0x00240090: ('FL', '1', "Visual Field Test Point X-Coordinate", '', 'VisualFieldTestPointXCoordinate'),
0x00240091: ('FL', '1', "Visual Field Test Point Y-Coordinate", '', 'VisualFieldTestPointYCoordinate'),
0x00240092: ('FL', '1', "Age Corrected Sensitivity Deviation Value", '', 'AgeCorrectedSensitivityDeviationValue'),
0x00240093: ('CS', '1', "Stimulus Results", '', 'StimulusResults'),
0x00240094: ('FL', '1', "Sensitivity Value", '', 'SensitivityValue'),
0x00240095: ('CS', '1', "Retest Stimulus Seen", '', 'RetestStimulusSeen'),
0x00240096: ('FL', '1', "Retest Sensitivity Value", '', 'RetestSensitivityValue'),
0x00240097: ('SQ', '1', "Visual Field Test Point Normals Sequence", '', 'VisualFieldTestPointNormalsSequence'),
0x00240098: ('FL', '1', "Quantified Defect", '', 'QuantifiedDefect'),
0x00240100: ('FL', '1', "Age Corrected Sensitivity Deviation Probability Value", '', 'AgeCorrectedSensitivityDeviationProbabilityValue'),
0x00240102: ('CS', '1', "Generalized Defect Corrected Sensitivity Deviation Flag", '', 'GeneralizedDefectCorrectedSensitivityDeviationFlag'),
0x00240103: ('FL', '1', "Generalized Defect Corrected Sensitivity Deviation Value", '', 'GeneralizedDefectCorrectedSensitivityDeviationValue'),
0x00240104: ('FL', '1', "Generalized Defect Corrected Sensitivity Deviation Probability Value", '', 'GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue'),
0x00240105: ('FL', '1', "Minimum Sensitivity Value", '', 'MinimumSensitivityValue'),
0x00240106: ('CS', '1', "Blind Spot Localized", '', 'BlindSpotLocalized'),
0x00240107: ('FL', '1', "Blind Spot X-Coordinate", '', 'BlindSpotXCoordinate'),
0x00240108: ('FL', '1', "Blind Spot Y-Coordinate", '', 'BlindSpotYCoordinate'),
0x00240110: ('SQ', '1', "Visual Acuity Measurement Sequence", '', 'VisualAcuityMeasurementSequence'),
0x00240112: ('SQ', '1', "Refractive Parameters Used on Patient Sequence", '', 'RefractiveParametersUsedOnPatientSequence'),
0x00240113: ('CS', '1', "Measurement Laterality", '', 'MeasurementLaterality'),
0x00240114: ('SQ', '1', "Ophthalmic Patient Clinical Information Left Eye Sequence", '', 'OphthalmicPatientClinicalInformationLeftEyeSequence'),
0x00240115: ('SQ', '1', "Ophthalmic Patient Clinical Information Right Eye Sequence", '', 'OphthalmicPatientClinicalInformationRightEyeSequence'),
0x00240117: ('CS', '1', "Foveal Point Normative Data Flag", '', 'FovealPointNormativeDataFlag'),
0x00240118: ('FL', '1', "Foveal Point Probability Value", '', 'FovealPointProbabilityValue'),
0x00240120: ('CS', '1', "Screening Baseline Measured", '', 'ScreeningBaselineMeasured'),
0x00240122: ('SQ', '1', "Screening Baseline Measured Sequence", '', 'ScreeningBaselineMeasuredSequence'),
0x00240124: ('CS', '1', "Screening Baseline Type", '', 'ScreeningBaselineType'),
0x00240126: ('FL', '1', "Screening Baseline Value", '', 'ScreeningBaselineValue'),
0x00240202: ('LO', '1', "Algorithm Source", '', 'AlgorithmSource'),
0x00240306: ('LO', '1', "Data Set Name", '', 'DataSetName'),
0x00240307: ('LO', '1', "Data Set Version", '', 'DataSetVersion'),
0x00240308: ('LO', '1', "Data Set Source", '', 'DataSetSource'),
0x00240309: ('LO', '1', "Data Set Description", '', 'DataSetDescription'),
0x00240317: ('SQ', '1', "Visual Field Test Reliability Global Index Sequence", '', 'VisualFieldTestReliabilityGlobalIndexSequence'),
0x00240320: ('SQ', '1', "Visual Field Global Results Index Sequence", '', 'VisualFieldGlobalResultsIndexSequence'),
0x00240325: ('SQ', '1', "Data Observation Sequence", '', 'DataObservationSequence'),
0x00240338: ('CS', '1', "Index Normals Flag", '', 'IndexNormalsFlag'),
0x00240341: ('FL', '1', "Index Probability", '', 'IndexProbability'),
0x00240344: ('SQ', '1', "Index Probability Sequence", '', 'IndexProbabilitySequence'),
0x00280002: ('US', '1', "Samples per Pixel", '', 'SamplesPerPixel'),
0x00280003: ('US', '1', "Samples per Pixel Used", '', 'SamplesPerPixelUsed'),
0x00280004: ('CS', '1', "Photometric Interpretation", '', 'PhotometricInterpretation'),
0x00280005: ('US', '1', "Image Dimensions", 'Retired', 'ImageDimensions'),
0x00280006: ('US', '1', "Planar Configuration", '', 'PlanarConfiguration'),
0x00280008: ('IS', '1', "Number of Frames", '', 'NumberOfFrames'),
0x00280009: ('AT', '1-n', "Frame Increment Pointer", '', 'FrameIncrementPointer'),
0x0028000A: ('AT', '1-n', "Frame Dimension Pointer", '', 'FrameDimensionPointer'),
0x00280010: ('US', '1', "Rows", '', 'Rows'),
0x00280011: ('US', '1', "Columns", '', 'Columns'),
0x00280012: ('US', '1', "Planes", 'Retired', 'Planes'),
0x00280014: ('US', '1', "Ultrasound Color Data Present", '', 'UltrasoundColorDataPresent'),
0x00280020: ('OB', '1', "Retired-blank", 'Retired', ''),
0x00280030: ('DS', '2', "Pixel Spacing", '', 'PixelSpacing'),
0x00280031: ('DS', '2', "Zoom Factor", '', 'ZoomFactor'),
0x00280032: ('DS', '2', "Zoom Center", '', 'ZoomCenter'),
0x00280034: ('IS', '2', "Pixel Aspect Ratio", '', 'PixelAspectRatio'),
0x00280040: ('CS', '1', "Image Format", 'Retired', 'ImageFormat'),
0x00280050: ('LO', '1-n', "Manipulated Image", 'Retired', 'ManipulatedImage'),
0x00280051: ('CS', '1-n', "Corrected Image", '', 'CorrectedImage'),
0x0028005F: ('LO', '1', "Compression Recognition Code", 'Retired', 'CompressionRecognitionCode'),
0x00280060: ('CS', '1', "Compression Code", 'Retired', 'CompressionCode'),
0x00280061: ('SH', '1', "Compression Originator", 'Retired', 'CompressionOriginator'),
0x00280062: ('LO', '1', "Compression Label", 'Retired', 'CompressionLabel'),
0x00280063: ('SH', '1', "Compression Description", 'Retired', 'CompressionDescription'),
0x00280065: ('CS', '1-n', "Compression Sequence", 'Retired', 'CompressionSequence'),
0x00280066: ('AT', '1-n', "Compression Step Pointers", 'Retired', 'CompressionStepPointers'),
0x00280068: ('US', '1', "Repeat Interval", 'Retired', 'RepeatInterval'),
0x00280069: ('US', '1', "Bits Grouped", 'Retired', 'BitsGrouped'),
0x00280070: ('US', '1-n', "Perimeter Table", 'Retired', 'PerimeterTable'),
0x00280071: ('US or SS', '1', "Perimeter Value", 'Retired', 'PerimeterValue'),
0x00280080: ('US', '1', "Predictor Rows", 'Retired', 'PredictorRows'),
0x00280081: ('US', '1', "Predictor Columns", 'Retired', 'PredictorColumns'),
0x00280082: ('US', '1-n', "Predictor Constants", 'Retired', 'PredictorConstants'),
0x00280090: ('CS', '1', "Blocked Pixels", 'Retired', 'BlockedPixels'),
0x00280091: ('US', '1', "Block Rows", 'Retired', 'BlockRows'),
0x00280092: ('US', '1', "Block Columns", 'Retired', 'BlockColumns'),
0x00280093: ('US', '1', "Row Overlap", 'Retired', 'RowOverlap'),
0x00280094: ('US', '1', "Column Overlap", 'Retired', 'ColumnOverlap'),
0x00280100: ('US', '1', "Bits Allocated", '', 'BitsAllocated'),
0x00280101: ('US', '1', "Bits Stored", '', 'BitsStored'),
0x00280102: ('US', '1', "High Bit", '', 'HighBit'),
0x00280103: ('US', '1', "Pixel Representation", '', 'PixelRepresentation'),
0x00280104: ('US or SS', '1', "Smallest Valid Pixel Value", 'Retired', 'SmallestValidPixelValue'),
0x00280105: ('US or SS', '1', "Largest Valid Pixel Value", 'Retired', 'LargestValidPixelValue'),
0x00280106: ('US or SS', '1', "Smallest Image Pixel Value", '', 'SmallestImagePixelValue'),
0x00280107: ('US or SS', '1', "Largest Image Pixel Value", '', 'LargestImagePixelValue'),
0x00280108: ('US or SS', '1', "Smallest Pixel Value in Series", '', 'SmallestPixelValueInSeries'),
0x00280109: ('US or SS', '1', "Largest Pixel Value in Series", '', 'LargestPixelValueInSeries'),
0x00280110: ('US or SS', '1', "Smallest Image Pixel Value in Plane", 'Retired', 'SmallestImagePixelValueInPlane'),
0x00280111: ('US or SS', '1', "Largest Image Pixel Value in Plane", 'Retired', 'LargestImagePixelValueInPlane'),
0x00280120: ('US or SS', '1', "Pixel Padding Value", '', 'PixelPaddingValue'),
0x00280121: ('US or SS', '1', "Pixel Padding Range Limit", '', 'PixelPaddingRangeLimit'),
0x00280200: ('US', '1', "Image Location", 'Retired', 'ImageLocation'),
0x00280300: ('CS', '1', "Quality Control Image", '', 'QualityControlImage'),
0x00280301: ('CS', '1', "Burned In Annotation", '', 'BurnedInAnnotation'),
0x00280302: ('CS', '1', "Recognizable Visual Features", '', 'RecognizableVisualFeatures'),
0x00280303: ('CS', '1', "Longitudinal Temporal Information Modified", '', 'LongitudinalTemporalInformationModified'),
0x00280400: ('LO', '1', "Transform Label", 'Retired', 'TransformLabel'),
0x00280401: ('LO', '1', "Transform Version Number", 'Retired', 'TransformVersionNumber'),
0x00280402: ('US', '1', "Number of Transform Steps", 'Retired', 'NumberOfTransformSteps'),
0x00280403: ('LO', '1-n', "Sequence of Compressed Data", 'Retired', 'SequenceOfCompressedData'),
0x00280404: ('AT', '1-n', "Details of Coefficients", 'Retired', 'DetailsOfCoefficients'),
0x00280700: ('LO', '1', "DCT Label", 'Retired', 'DCTLabel'),
0x00280701: ('CS', '1-n', "Data Block Description", 'Retired', 'DataBlockDescription'),
0x00280702: ('AT', '1-n', "Data Block", 'Retired', 'DataBlock'),
0x00280710: ('US', '1', "Normalization Factor Format", 'Retired', 'NormalizationFactorFormat'),
0x00280720: ('US', '1', "Zonal Map Number Format", 'Retired', 'ZonalMapNumberFormat'),
0x00280721: ('AT', '1-n', "Zonal Map Location", 'Retired', 'ZonalMapLocation'),
0x00280722: ('US', '1', "Zonal Map Format", 'Retired', 'ZonalMapFormat'),
0x00280730: ('US', '1', "Adaptive Map Format", 'Retired', 'AdaptiveMapFormat'),
0x00280740: ('US', '1', "Code Number Format", 'Retired', 'CodeNumberFormat'),
0x00280A02: ('CS', '1', "Pixel Spacing Calibration Type", '', 'PixelSpacingCalibrationType'),
0x00280A04: ('LO', '1', "Pixel Spacing Calibration Description", '', 'PixelSpacingCalibrationDescription'),
0x00281040: ('CS', '1', "Pixel Intensity Relationship", '', 'PixelIntensityRelationship'),
0x00281041: ('SS', '1', "Pixel Intensity Relationship Sign", '', 'PixelIntensityRelationshipSign'),
0x00281050: ('DS', '1-n', "Window Center", '', 'WindowCenter'),
0x00281051: ('DS', '1-n', "Window Width", '', 'WindowWidth'),
0x00281052: ('DS', '1', "Rescale Intercept", '', 'RescaleIntercept'),
0x00281053: ('DS', '1', "Rescale Slope", '', 'RescaleSlope'),
0x00281054: ('LO', '1', "Rescale Type", '', 'RescaleType'),
0x00281055: ('LO', '1-n', "Window Center & Width Explanation", '', 'WindowCenterWidthExplanation'),
0x00281056: ('CS', '1', "VOI LUT Function", '', 'VOILUTFunction'),
0x00281080: ('CS', '1', "Gray Scale", 'Retired', 'GrayScale'),
0x00281090: ('CS', '1', "Recommended Viewing Mode", '', 'RecommendedViewingMode'),
0x00281100: ('US or SS', '3', "Gray Lookup Table Descriptor", 'Retired', 'GrayLookupTableDescriptor'),
0x00281101: ('US or SS', '3', "Red Palette Color Lookup Table Descriptor", '', 'RedPaletteColorLookupTableDescriptor'),
0x00281102: ('US or SS', '3', "Green Palette Color Lookup Table Descriptor", '', 'GreenPaletteColorLookupTableDescriptor'),
0x00281103: ('US or SS', '3', "Blue Palette Color Lookup Table Descriptor", '', 'BluePaletteColorLookupTableDescriptor'),
0x00281104: ('US', '3', "Alpha Palette Color Lookup Table Descriptor", '', 'AlphaPaletteColorLookupTableDescriptor'),
0x00281111: ('US or SS', '4', "Large Red Palette Color Lookup Table Descriptor", 'Retired', 'LargeRedPaletteColorLookupTableDescriptor'),
0x00281112: ('US or SS', '4', "Large Green Palette Color Lookup Table Descriptor", 'Retired', 'LargeGreenPaletteColorLookupTableDescriptor'),
0x00281113: ('US or SS', '4', "Large Blue Palette Color Lookup Table Descriptor", 'Retired', 'LargeBluePaletteColorLookupTableDescriptor'),
0x00281199: ('UI', '1', "Palette Color Lookup Table UID", '', 'PaletteColorLookupTableUID'),
0x00281200: ('US or SS or OW', '1-n 1', "Gray Lookup Table Data", 'Retired', 'GrayLookupTableData'),
0x00281201: ('OW', '1', "Red Palette Color Lookup Table Data", '', 'RedPaletteColorLookupTableData'),
0x00281202: ('OW', '1', "Green Palette Color Lookup Table Data", '', 'GreenPaletteColorLookupTableData'),
0x00281203: ('OW', '1', "Blue Palette Color Lookup Table Data", '', 'BluePaletteColorLookupTableData'),
0x00281204: ('OW', '1', "Alpha Palette Color Lookup Table Data", '', 'AlphaPaletteColorLookupTableData'),
0x00281211: ('OW', '1', "Large Red Palette Color Lookup Table Data", 'Retired', 'LargeRedPaletteColorLookupTableData'),
0x00281212: ('OW', '1', "Large Green Palette Color Lookup Table Data", 'Retired', 'LargeGreenPaletteColorLookupTableData'),
0x00281213: ('OW', '1', "Large Blue Palette Color Lookup Table Data", 'Retired', 'LargeBluePaletteColorLookupTableData'),
0x00281214: ('UI', '1', "Large Palette Color Lookup Table UID", 'Retired', 'LargePaletteColorLookupTableUID'),
0x00281221: ('OW', '1', "Segmented Red Palette Color Lookup Table Data", '', 'SegmentedRedPaletteColorLookupTableData'),
0x00281222: ('OW', '1', "Segmented Green Palette Color Lookup Table Data", '', 'SegmentedGreenPaletteColorLookupTableData'),
0x00281223: ('OW', '1', "Segmented Blue Palette Color Lookup Table Data", '', 'SegmentedBluePaletteColorLookupTableData'),
0x00281300: ('CS', '1', "Breast Implant Present", '', 'BreastImplantPresent'),
0x00281350: ('CS', '1', "Partial View", '', 'PartialView'),
0x00281351: ('ST', '1', "Partial View Description", '', 'PartialViewDescription'),
0x00281352: ('SQ', '1', "Partial View Code Sequence", '', 'PartialViewCodeSequence'),
0x0028135A: ('CS', '1', "Spatial Locations Preserved", '', 'SpatialLocationsPreserved'),
0x00281401: ('SQ', '1', "Data Frame Assignment Sequence", '', 'DataFrameAssignmentSequence'),
0x00281402: ('CS', '1', "Data Path Assignment", '', 'DataPathAssignment'),
0x00281403: ('US', '1', "Bits Mapped to Color Lookup Table", '', 'BitsMappedToColorLookupTable'),
0x00281404: ('SQ', '1', "Blending LUT 1 Sequence", '', 'BlendingLUT1Sequence'),
0x00281405: ('CS', '1', "Blending LUT 1 Transfer Function", '', 'BlendingLUT1TransferFunction'),
0x00281406: ('FD', '1', "Blending Weight Constant", '', 'BlendingWeightConstant'),
0x00281407: ('US', '3', "Blending Lookup Table Descriptor", '', 'BlendingLookupTableDescriptor'),
0x00281408: ('OW', '1', "Blending Lookup Table Data", '', 'BlendingLookupTableData'),
0x0028140B: ('SQ', '1', "Enhanced Palette Color Lookup Table Sequence", '', 'EnhancedPaletteColorLookupTableSequence'),
0x0028140C: ('SQ', '1', "Blending LUT 2 Sequence", '', 'BlendingLUT2Sequence'),
0x0028140D: ('CS', '1', "Blending LUT 2 Transfer Function", '', 'BlendingLUT2TransferFunction'),
0x0028140E: ('CS', '1', "Data Path ID", '', 'DataPathID'),
0x0028140F: ('CS', '1', "RGB LUT Transfer Function", '', 'RGBLUTTransferFunction'),
0x00281410: ('CS', '1', "Alpha LUT Transfer Function", '', 'AlphaLUTTransferFunction'),
0x00282000: ('OB', '1', "ICC Profile", '', 'ICCProfile'),
0x00282110: ('CS', '1', "Lossy Image Compression", '', 'LossyImageCompression'),
0x00282112: ('DS', '1-n', "Lossy Image Compression Ratio", '', 'LossyImageCompressionRatio'),
0x00282114: ('CS', '1-n', "Lossy Image Compression Method", '', 'LossyImageCompressionMethod'),
0x00283000: ('SQ', '1', "Modality LUT Sequence", '', 'ModalityLUTSequence'),
0x00283002: ('US or SS', '3', "LUT Descriptor", '', 'LUTDescriptor'),
0x00283003: ('LO', '1', "LUT Explanation", '', 'LUTExplanation'),
0x00283004: ('LO', '1', "Modality LUT Type", '', 'ModalityLUTType'),
0x00283006: ('US or OW', '1-n 1', "LUT Data", '', 'LUTData'),
0x00283010: ('SQ', '1', "VOI LUT Sequence", '', 'VOILUTSequence'),
0x00283110: ('SQ', '1', "Softcopy VOI LUT Sequence", '', 'SoftcopyVOILUTSequence'),
0x00284000: ('LT', '1', "Image Presentation Comments", 'Retired', 'ImagePresentationComments'),
0x00285000: ('SQ', '1', "Bi-Plane Acquisition Sequence", 'Retired', 'BiPlaneAcquisitionSequence'),
0x00286010: ('US', '1', "Representative Frame Number", '', 'RepresentativeFrameNumber'),
0x00286020: ('US', '1-n', "Frame Numbers of Interest (FOI)", '', 'FrameNumbersOfInterest'),
0x00286022: ('LO', '1-n', "Frame of Interest Description", '', 'FrameOfInterestDescription'),
0x00286023: ('CS', '1-n', "Frame of Interest Type", '', 'FrameOfInterestType'),
0x00286030: ('US', '1-n', "Mask Pointer(s)", 'Retired', 'MaskPointers'),
0x00286040: ('US', '1-n', "R Wave Pointer", '', 'RWavePointer'),
0x00286100: ('SQ', '1', "Mask Subtraction Sequence", '', 'MaskSubtractionSequence'),
0x00286101: ('CS', '1', "Mask Operation", '', 'MaskOperation'),
0x00286102: ('US', '2-2n', "Applicable Frame Range", '', 'ApplicableFrameRange'),
0x00286110: ('US', '1-n', "Mask Frame Numbers", '', 'MaskFrameNumbers'),
0x00286112: ('US', '1', "Contrast Frame Averaging", '', 'ContrastFrameAveraging'),
0x00286114: ('FL', '2', "Mask Sub-pixel Shift", '', 'MaskSubPixelShift'),
0x00286120: ('SS', '1', "TID Offset", '', 'TIDOffset'),
0x00286190: ('ST', '1', "Mask Operation Explanation", '', 'MaskOperationExplanation'),
0x00287FE0: ('UT', '1', "Pixel Data Provider URL", '', 'PixelDataProviderURL'),
0x00289001: ('UL', '1', "Data Point Rows", '', 'DataPointRows'),
0x00289002: ('UL', '1', "Data Point Columns", '', 'DataPointColumns'),
0x00289003: ('CS', '1', "Signal Domain Columns", '', 'SignalDomainColumns'),
0x00289099: ('US', '1', "Largest Monochrome Pixel Value", 'Retired', 'LargestMonochromePixelValue'),
0x00289108: ('CS', '1', "Data Representation", '', 'DataRepresentation'),
0x00289110: ('SQ', '1', "Pixel Measures Sequence", '', 'PixelMeasuresSequence'),
0x00289132: ('SQ', '1', "Frame VOI LUT Sequence", '', 'FrameVOILUTSequence'),
0x00289145: ('SQ', '1', "Pixel Value Transformation Sequence", '', 'PixelValueTransformationSequence'),
0x00289235: ('CS', '1', "Signal Domain Rows", '', 'SignalDomainRows'),
0x00289411: ('FL', '1', "Display Filter Percentage", '', 'DisplayFilterPercentage'),
0x00289415: ('SQ', '1', "Frame Pixel Shift Sequence", '', 'FramePixelShiftSequence'),
0x00289416: ('US', '1', "Subtraction Item ID", '', 'SubtractionItemID'),
0x00289422: ('SQ', '1', "Pixel Intensity Relationship LUT Sequence", '', 'PixelIntensityRelationshipLUTSequence'),
0x00289443: ('SQ', '1', "Frame Pixel Data Properties Sequence", '', 'FramePixelDataPropertiesSequence'),
0x00289444: ('CS', '1', "Geometrical Properties", '', 'GeometricalProperties'),
0x00289445: ('FL', '1', "Geometric Maximum Distortion", '', 'GeometricMaximumDistortion'),
0x00289446: ('CS', '1-n', "Image Processing Applied", '', 'ImageProcessingApplied'),
0x00289454: ('CS', '1', "Mask Selection Mode", '', 'MaskSelectionMode'),
0x00289474: ('CS', '1', "LUT Function", '', 'LUTFunction'),
0x00289478: ('FL', '1', "Mask Visibility Percentage", '', 'MaskVisibilityPercentage'),
0x00289501: ('SQ', '1', "Pixel Shift Sequence", '', 'PixelShiftSequence'),
0x00289502: ('SQ', '1', "Region Pixel Shift Sequence", '', 'RegionPixelShiftSequence'),
0x00289503: ('SS', '2-2n', "Vertices of the Region", '', 'VerticesOfTheRegion'),
0x00289505: ('SQ', '1', "Multi-frame Presentation Sequence", '', 'MultiFramePresentationSequence'),
0x00289506: ('US', '2-2n', "Pixel Shift Frame Range", '', 'PixelShiftFrameRange'),
0x00289507: ('US', '2-2n', "LUT Frame Range", '', 'LUTFrameRange'),
0x00289520: ('DS', '16', "Image to Equipment Mapping Matrix", '', 'ImageToEquipmentMappingMatrix'),
0x00289537: ('CS', '1', "Equipment Coordinate System Identification", '', 'EquipmentCoordinateSystemIdentification'),
0x0032000A: ('CS', '1', "Study Status ID", 'Retired', 'StudyStatusID'),
0x0032000C: ('CS', '1', "Study Priority ID", 'Retired', 'StudyPriorityID'),
0x00320012: ('LO', '1', "Study ID Issuer", 'Retired', 'StudyIDIssuer'),
0x00320032: ('DA', '1', "Study Verified Date", 'Retired', 'StudyVerifiedDate'),
0x00320033: ('TM', '1', "Study Verified Time", 'Retired', 'StudyVerifiedTime'),
0x00320034: ('DA', '1', "Study Read Date", 'Retired', 'StudyReadDate'),
0x00320035: ('TM', '1', "Study Read Time", 'Retired', 'StudyReadTime'),
0x00321000: ('DA', '1', "Scheduled Study Start Date", 'Retired', 'ScheduledStudyStartDate'),
0x00321001: ('TM', '1', "Scheduled Study Start Time", 'Retired', 'ScheduledStudyStartTime'),
0x00321010: ('DA', '1', "Scheduled Study Stop Date", 'Retired', 'ScheduledStudyStopDate'),
0x00321011: ('TM', '1', "Scheduled Study Stop Time", 'Retired', 'ScheduledStudyStopTime'),
0x00321020: ('LO', '1', "Scheduled Study Location", 'Retired', 'ScheduledStudyLocation'),
0x00321021: ('AE', '1-n', "Scheduled Study Location AE Title", 'Retired', 'ScheduledStudyLocationAETitle'),
0x00321030: ('LO', '1', "Reason for Study", 'Retired', 'ReasonForStudy'),
0x00321031: ('SQ', '1', "Requesting Physician Identification Sequence", '', 'RequestingPhysicianIdentificationSequence'),
0x00321032: ('PN', '1', "Requesting Physician", '', 'RequestingPhysician'),
0x00321033: ('LO', '1', "Requesting Service", '', 'RequestingService'),
0x00321034: ('SQ', '1', "Requesting Service Code Sequence", '', 'RequestingServiceCodeSequence'),
0x00321040: ('DA', '1', "Study Arrival Date", 'Retired', 'StudyArrivalDate'),
0x00321041: ('TM', '1', "Study Arrival Time", 'Retired', 'StudyArrivalTime'),
0x00321050: ('DA', '1', "Study Completion Date", 'Retired', 'StudyCompletionDate'),
0x00321051: ('TM', '1', "Study Completion Time", 'Retired', 'StudyCompletionTime'),
0x00321055: ('CS', '1', "Study Component Status ID", 'Retired', 'StudyComponentStatusID'),
0x00321060: ('LO', '1', "Requested Procedure Description", '', 'RequestedProcedureDescription'),
0x00321064: ('SQ', '1', "Requested Procedure Code Sequence", '', 'RequestedProcedureCodeSequence'),
0x00321070: ('LO', '1', "Requested Contrast Agent", '', 'RequestedContrastAgent'),
0x00324000: ('LT', '1', "Study Comments", 'Retired', 'StudyComments'),
0x00380004: ('SQ', '1', "Referenced Patient Alias Sequence", '', 'ReferencedPatientAliasSequence'),
0x00380008: ('CS', '1', "Visit Status ID", '', 'VisitStatusID'),
0x00380010: ('LO', '1', "Admission ID", '', 'AdmissionID'),
0x00380011: ('LO', '1', "Issuer of Admission ID", 'Retired', 'IssuerOfAdmissionID'),
0x00380014: ('SQ', '1', "Issuer of Admission ID Sequence", '', 'IssuerOfAdmissionIDSequence'),
0x00380016: ('LO', '1', "Route of Admissions", '', 'RouteOfAdmissions'),
0x0038001A: ('DA', '1', "Scheduled Admission Date", 'Retired', 'ScheduledAdmissionDate'),
0x0038001B: ('TM', '1', "Scheduled Admission Time", 'Retired', 'ScheduledAdmissionTime'),
0x0038001C: ('DA', '1', "Scheduled Discharge Date", 'Retired', 'ScheduledDischargeDate'),
0x0038001D: ('TM', '1', "Scheduled Discharge Time", 'Retired', 'ScheduledDischargeTime'),
0x0038001E: ('LO', '1', "Scheduled Patient Institution Residence", 'Retired', 'ScheduledPatientInstitutionResidence'),
0x00380020: ('DA', '1', "Admitting Date", '', 'AdmittingDate'),
0x00380021: ('TM', '1', "Admitting Time", '', 'AdmittingTime'),
0x00380030: ('DA', '1', "Discharge Date", 'Retired', 'DischargeDate'),
0x00380032: ('TM', '1', "Discharge Time", 'Retired', 'DischargeTime'),
0x00380040: ('LO', '1', "Discharge Diagnosis Description", 'Retired', 'DischargeDiagnosisDescription'),
0x00380044: ('SQ', '1', "Discharge Diagnosis Code Sequence", 'Retired', 'DischargeDiagnosisCodeSequence'),
0x00380050: ('LO', '1', "Special Needs", '', 'SpecialNeeds'),
0x00380060: ('LO', '1', "Service Episode ID", '', 'ServiceEpisodeID'),
0x00380061: ('LO', '1', "Issuer of Service Episode ID", 'Retired', 'IssuerOfServiceEpisodeID'),
0x00380062: ('LO', '1', "Service Episode Description", '', 'ServiceEpisodeDescription'),
0x00380064: ('SQ', '1', "Issuer of Service Episode ID Sequence", '', 'IssuerOfServiceEpisodeIDSequence'),
0x00380100: ('SQ', '1', "Pertinent Documents Sequence", '', 'PertinentDocumentsSequence'),
0x00380300: ('LO', '1', "Current Patient Location", '', 'CurrentPatientLocation'),
0x00380400: ('LO', '1', "Patient's Institution Residence", '', 'PatientInstitutionResidence'),
0x00380500: ('LO', '1', "Patient State", '', 'PatientState'),
0x00380502: ('SQ', '1', "Patient Clinical Trial Participation Sequence", '', 'PatientClinicalTrialParticipationSequence'),
0x00384000: ('LT', '1', "Visit Comments", '', 'VisitComments'),
0x003A0004: ('CS', '1', "Waveform Originality", '', 'WaveformOriginality'),
0x003A0005: ('US', '1', "Number of Waveform Channels", '', 'NumberOfWaveformChannels'),
0x003A0010: ('UL', '1', "Number of Waveform Samples", '', 'NumberOfWaveformSamples'),
0x003A001A: ('DS', '1', "Sampling Frequency", '', 'SamplingFrequency'),
0x003A0020: ('SH', '1', "Multiplex Group Label", '', 'MultiplexGroupLabel'),
0x003A0200: ('SQ', '1', "Channel Definition Sequence", '', 'ChannelDefinitionSequence'),
0x003A0202: ('IS', '1', "Waveform Channel Number", '', 'WaveformChannelNumber'),
0x003A0203: ('SH', '1', "Channel Label", '', 'ChannelLabel'),
0x003A0205: ('CS', '1-n', "Channel Status", '', 'ChannelStatus'),
0x003A0208: ('SQ', '1', "Channel Source Sequence", '', 'ChannelSourceSequence'),
0x003A0209: ('SQ', '1', "Channel Source Modifiers Sequence", '', 'ChannelSourceModifiersSequence'),
0x003A020A: ('SQ', '1', "Source Waveform Sequence", '', 'SourceWaveformSequence'),
0x003A020C: ('LO', '1', "Channel Derivation Description", '', 'ChannelDerivationDescription'),
0x003A0210: ('DS', '1', "Channel Sensitivity", '', 'ChannelSensitivity'),
0x003A0211: ('SQ', '1', "Channel Sensitivity Units Sequence", '', 'ChannelSensitivityUnitsSequence'),
0x003A0212: ('DS', '1', "Channel Sensitivity Correction Factor", '', 'ChannelSensitivityCorrectionFactor'),
0x003A0213: ('DS', '1', "Channel Baseline", '', 'ChannelBaseline'),
0x003A0214: ('DS', '1', "Channel Time Skew", '', 'ChannelTimeSkew'),
0x003A0215: ('DS', '1', "Channel Sample Skew", '', 'ChannelSampleSkew'),
0x003A0218: ('DS', '1', "Channel Offset", '', 'ChannelOffset'),
0x003A021A: ('US', '1', "Waveform Bits Stored", '', 'WaveformBitsStored'),
0x003A0220: ('DS', '1', "Filter Low Frequency", '', 'FilterLowFrequency'),
0x003A0221: ('DS', '1', "Filter High Frequency", '', 'FilterHighFrequency'),
0x003A0222: ('DS', '1', "Notch Filter Frequency", '', 'NotchFilterFrequency'),
0x003A0223: ('DS', '1', "Notch Filter Bandwidth", '', 'NotchFilterBandwidth'),
0x003A0230: ('FL', '1', "Waveform Data Display Scale", '', 'WaveformDataDisplayScale'),
0x003A0231: ('US', '3', "Waveform Display Background CIELab Value", '', 'WaveformDisplayBackgroundCIELabValue'),
0x003A0240: ('SQ', '1', "Waveform Presentation Group Sequence", '', 'WaveformPresentationGroupSequence'),
0x003A0241: ('US', '1', "Presentation Group Number", '', 'PresentationGroupNumber'),
0x003A0242: ('SQ', '1', "Channel Display Sequence", '', 'ChannelDisplaySequence'),
0x003A0244: ('US', '3', "Channel Recommended Display CIELab Value", '', 'ChannelRecommendedDisplayCIELabValue'),
0x003A0245: ('FL', '1', "Channel Position", '', 'ChannelPosition'),
0x003A0246: ('CS', '1', "Display Shading Flag", '', 'DisplayShadingFlag'),
0x003A0247: ('FL', '1', "Fractional Channel Display Scale", '', 'FractionalChannelDisplayScale'),
0x003A0248: ('FL', '1', "Absolute Channel Display Scale", '', 'AbsoluteChannelDisplayScale'),
0x003A0300: ('SQ', '1', "Multiplexed Audio Channels Description Code Sequence", '', 'MultiplexedAudioChannelsDescriptionCodeSequence'),
0x003A0301: ('IS', '1', "Channel Identification Code", '', 'ChannelIdentificationCode'),
0x003A0302: ('CS', '1', "Channel Mode", '', 'ChannelMode'),
0x00400001: ('AE', '1-n', "Scheduled Station AE Title", '', 'ScheduledStationAETitle'),
0x00400002: ('DA', '1', "Scheduled Procedure Step Start Date", '', 'ScheduledProcedureStepStartDate'),
0x00400003: ('TM', '1', "Scheduled Procedure Step Start Time", '', 'ScheduledProcedureStepStartTime'),
0x00400004: ('DA', '1', "Scheduled Procedure Step End Date", '', 'ScheduledProcedureStepEndDate'),
0x00400005: ('TM', '1', "Scheduled Procedure Step End Time", '', 'ScheduledProcedureStepEndTime'),
0x00400006: ('PN', '1', "Scheduled Performing Physician's Name", '', 'ScheduledPerformingPhysicianName'),
0x00400007: ('LO', '1', "Scheduled Procedure Step Description", '', 'ScheduledProcedureStepDescription'),
0x00400008: ('SQ', '1', "Scheduled Protocol Code Sequence", '', 'ScheduledProtocolCodeSequence'),
0x00400009: ('SH', '1', "Scheduled Procedure Step ID", '', 'ScheduledProcedureStepID'),
0x0040000A: ('SQ', '1', "Stage Code Sequence", '', 'StageCodeSequence'),
0x0040000B: ('SQ', '1', "Scheduled Performing Physician Identification Sequence", '', 'ScheduledPerformingPhysicianIdentificationSequence'),
0x00400010: ('SH', '1-n', "Scheduled Station Name", '', 'ScheduledStationName'),
0x00400011: ('SH', '1', "Scheduled Procedure Step Location", '', 'ScheduledProcedureStepLocation'),
0x00400012: ('LO', '1', "Pre-Medication", '', 'PreMedication'),
0x00400020: ('CS', '1', "Scheduled Procedure Step Status", '', 'ScheduledProcedureStepStatus'),
0x00400026: ('SQ', '1', "Order Placer Identifier Sequence", '', 'OrderPlacerIdentifierSequence'),
0x00400027: ('SQ', '1', "Order Filler Identifier Sequence", '', 'OrderFillerIdentifierSequence'),
0x00400031: ('UT', '1', "Local Namespace Entity ID", '', 'LocalNamespaceEntityID'),
0x00400032: ('UT', '1', "Universal Entity ID", '', 'UniversalEntityID'),
0x00400033: ('CS', '1', "Universal Entity ID Type", '', 'UniversalEntityIDType'),
0x00400035: ('CS', '1', "Identifier Type Code", '', 'IdentifierTypeCode'),
0x00400036: ('SQ', '1', "Assigning Facility Sequence", '', 'AssigningFacilitySequence'),
0x00400039: ('SQ', '1', "Assigning Jurisdiction Code Sequence", '', 'AssigningJurisdictionCodeSequence'),
0x0040003A: ('SQ', '1', "Assigning Agency or Department Code Sequence", '', 'AssigningAgencyOrDepartmentCodeSequence'),
0x00400100: ('SQ', '1', "Scheduled Procedure Step Sequence", '', 'ScheduledProcedureStepSequence'),
0x00400220: ('SQ', '1', "Referenced Non-Image Composite SOP Instance Sequence", '', 'ReferencedNonImageCompositeSOPInstanceSequence'),
0x00400241: ('AE', '1', "Performed Station AE Title", '', 'PerformedStationAETitle'),
0x00400242: ('SH', '1', "Performed Station Name", '', 'PerformedStationName'),
0x00400243: ('SH', '1', "Performed Location", '', 'PerformedLocation'),
0x00400244: ('DA', '1', "Performed Procedure Step Start Date", '', 'PerformedProcedureStepStartDate'),
0x00400245: ('TM', '1', "Performed Procedure Step Start Time", '', 'PerformedProcedureStepStartTime'),
0x00400250: ('DA', '1', "Performed Procedure Step End Date", '', 'PerformedProcedureStepEndDate'),
0x00400251: ('TM', '1', "Performed Procedure Step End Time", '', 'PerformedProcedureStepEndTime'),
0x00400252: ('CS', '1', "Performed Procedure Step Status", '', 'PerformedProcedureStepStatus'),
0x00400253: ('SH', '1', "Performed Procedure Step ID", '', 'PerformedProcedureStepID'),
0x00400254: ('LO', '1', "Performed Procedure Step Description", '', 'PerformedProcedureStepDescription'),
0x00400255: ('LO', '1', "Performed Procedure Type Description", '', 'PerformedProcedureTypeDescription'),
0x00400260: ('SQ', '1', "Performed Protocol Code Sequence", '', 'PerformedProtocolCodeSequence'),
0x00400261: ('CS', '1', "Performed Protocol Type", '', 'PerformedProtocolType'),
0x00400270: ('SQ', '1', "Scheduled Step Attributes Sequence", '', 'ScheduledStepAttributesSequence'),
0x00400275: ('SQ', '1', "Request Attributes Sequence", '', 'RequestAttributesSequence'),
0x00400280: ('ST', '1', "Comments on the Performed Procedure Step", '', 'CommentsOnThePerformedProcedureStep'),
0x00400281: ('SQ', '1', "Performed Procedure Step Discontinuation Reason Code Sequence", '', 'PerformedProcedureStepDiscontinuationReasonCodeSequence'),
0x00400293: ('SQ', '1', "Quantity Sequence", '', 'QuantitySequence'),
0x00400294: ('DS', '1', "Quantity", '', 'Quantity'),
0x00400295: ('SQ', '1', "Measuring Units Sequence", '', 'MeasuringUnitsSequence'),
0x00400296: ('SQ', '1', "Billing Item Sequence", '', 'BillingItemSequence'),
0x00400300: ('US', '1', "Total Time of Fluoroscopy", '', 'TotalTimeOfFluoroscopy'),
0x00400301: ('US', '1', "Total Number of Exposures", '', 'TotalNumberOfExposures'),
0x00400302: ('US', '1', "Entrance Dose", '', 'EntranceDose'),
0x00400303: ('US', '1-2', "Exposed Area", '', 'ExposedArea'),
0x00400306: ('DS', '1', "Distance Source to Entrance", '', 'DistanceSourceToEntrance'),
0x00400307: ('DS', '1', "Distance Source to Support", 'Retired', 'DistanceSourceToSupport'),
0x0040030E: ('SQ', '1', "Exposure Dose Sequence", '', 'ExposureDoseSequence'),
0x00400310: ('ST', '1', "Comments on Radiation Dose", '', 'CommentsOnRadiationDose'),
0x00400312: ('DS', '1', "X-Ray Output", '', 'XRayOutput'),
0x00400314: ('DS', '1', "Half Value Layer", '', 'HalfValueLayer'),
0x00400316: ('DS', '1', "Organ Dose", '', 'OrganDose'),
0x00400318: ('CS', '1', "Organ Exposed", '', 'OrganExposed'),
0x00400320: ('SQ', '1', "Billing Procedure Step Sequence", '', 'BillingProcedureStepSequence'),
0x00400321: ('SQ', '1', "Film Consumption Sequence", '', 'FilmConsumptionSequence'),
0x00400324: ('SQ', '1', "Billing Supplies and Devices Sequence", '', 'BillingSuppliesAndDevicesSequence'),
0x00400330: ('SQ', '1', "Referenced Procedure Step Sequence", 'Retired', 'ReferencedProcedureStepSequence'),
0x00400340: ('SQ', '1', "Performed Series Sequence", '', 'PerformedSeriesSequence'),
0x00400400: ('LT', '1', "Comments on the Scheduled Procedure Step", '', 'CommentsOnTheScheduledProcedureStep'),
0x00400440: ('SQ', '1', "Protocol Context Sequence", '', 'ProtocolContextSequence'),
0x00400441: ('SQ', '1', "Content Item Modifier Sequence", '', 'ContentItemModifierSequence'),
0x00400500: ('SQ', '1', "Scheduled Specimen Sequence", '', 'ScheduledSpecimenSequence'),
0x0040050A: ('LO', '1', "Specimen Accession Number", 'Retired', 'SpecimenAccessionNumber'),
0x00400512: ('LO', '1', "Container Identifier", '', 'ContainerIdentifier'),
0x00400513: ('SQ', '1', "Issuer of the Container Identifier Sequence", '', 'IssuerOfTheContainerIdentifierSequence'),
0x00400515: ('SQ', '1', "Alternate Container Identifier Sequence", '', 'AlternateContainerIdentifierSequence'),
0x00400518: ('SQ', '1', "Container Type Sequence", '', 'ContainerTypeCodeSequence'),
0x0040051A: ('LO', '1', "Container Description", '', 'ContainerDescription'),
0x00400520: ('SQ', '1', "Container Component Sequence", '', 'ContainerComponentSequence'),
0x00400550: ('SQ', '1', "Specimen Sequence", 'Retired', 'SpecimenSequence'),
0x00400551: ('LO', '1', "Specimen Identifier", '', 'SpecimenIdentifier'),
0x00400552: ('SQ', '1', "Specimen Description Sequence (Trial)", 'Retired', 'SpecimenDescriptionSequenceTrial'),
0x00400553: ('ST', '1', "Specimen Description (Trial)", 'Retired', 'SpecimenDescriptionTrial'),
0x00400554: ('UI', '1', "Specimen UID", '', 'SpecimenUID'),
0x00400555: ('SQ', '1', "Acquisition Context Sequence", '', 'AcquisitionContextSequence'),
0x00400556: ('ST', '1', "Acquisition Context Description", '', 'AcquisitionContextDescription'),
0x0040059A: ('SQ', '1', "Specimen Type Code Sequence", '', 'SpecimenTypeCodeSequence'),
0x00400560: ('SQ', '1', "Specimen Description Sequence", '', 'SpecimenDescriptionSequence'),
0x00400562: ('SQ', '1', "Issuer of the Specimen Identifier Sequence", '', 'IssuerOfTheSpecimenIdentifierSequence'),
0x00400600: ('LO', '1', "Specimen Short Description", '', 'SpecimenShortDescription'),
0x00400602: ('UT', '1', "Specimen Detailed Description", '', 'SpecimenDetailedDescription'),
0x00400610: ('SQ', '1', "Specimen Preparation Sequence", '', 'SpecimenPreparationSequence'),
0x00400612: ('SQ', '1', "Specimen Preparation Step Content Item Sequence", '', 'SpecimenPreparationStepContentItemSequence'),
0x00400620: ('SQ', '1', "Specimen Localization Content Item Sequence", '', 'SpecimenLocalizationContentItemSequence'),
0x004006FA: ('LO', '1', "Slide Identifier", 'Retired', 'SlideIdentifier'),
0x0040071A: ('SQ', '1', "Image Center Point Coordinates Sequence", '', 'ImageCenterPointCoordinatesSequence'),
0x0040072A: ('DS', '1', "X Offset in Slide Coordinate System", '', 'XOffsetInSlideCoordinateSystem'),
0x0040073A: ('DS', '1', "Y Offset in Slide Coordinate System", '', 'YOffsetInSlideCoordinateSystem'),
0x0040074A: ('DS', '1', "Z Offset in Slide Coordinate System", '', 'ZOffsetInSlideCoordinateSystem'),
0x004008D8: ('SQ', '1', "Pixel Spacing Sequence", 'Retired', 'PixelSpacingSequence'),
0x004008DA: ('SQ', '1', "Coordinate System Axis Code Sequence", 'Retired', 'CoordinateSystemAxisCodeSequence'),
0x004008EA: ('SQ', '1', "Measurement Units Code Sequence", '', 'MeasurementUnitsCodeSequence'),
0x004009F8: ('SQ', '1', "Vital Stain Code Sequence (Trial)", 'Retired', 'VitalStainCodeSequenceTrial'),
0x00401001: ('SH', '1', "Requested Procedure ID", '', 'RequestedProcedureID'),
0x00401002: ('LO', '1', "Reason for the Requested Procedure", '', 'ReasonForTheRequestedProcedure'),
0x00401003: ('SH', '1', "Requested Procedure Priority", '', 'RequestedProcedurePriority'),
0x00401004: ('LO', '1', "Patient Transport Arrangements", '', 'PatientTransportArrangements'),
0x00401005: ('LO', '1', "Requested Procedure Location", '', 'RequestedProcedureLocation'),
0x00401006: ('SH', '1', "Placer Order Number / Procedure", 'Retired', 'PlacerOrderNumberProcedure'),
0x00401007: ('SH', '1', "Filler Order Number / Procedure", 'Retired', 'FillerOrderNumberProcedure'),
0x00401008: ('LO', '1', "Confidentiality Code", '', 'ConfidentialityCode'),
0x00401009: ('SH', '1', "Reporting Priority", '', 'ReportingPriority'),
0x0040100A: ('SQ', '1', "Reason for Requested Procedure Code Sequence", '', 'ReasonForRequestedProcedureCodeSequence'),
0x00401010: ('PN', '1-n', "Names of Intended Recipients of Results", '', 'NamesOfIntendedRecipientsOfResults'),
0x00401011: ('SQ', '1', "Intended Recipients of Results Identification Sequence", '', 'IntendedRecipientsOfResultsIdentificationSequence'),
0x00401012: ('SQ', '1', "Reason For Performed Procedure Code Sequence", '', 'ReasonForPerformedProcedureCodeSequence'),
0x00401060: ('LO', '1', "Requested Procedure Description (Trial)", 'Retired', 'RequestedProcedureDescriptionTrial'),
0x00401101: ('SQ', '1', "Person Identification Code Sequence", '', 'PersonIdentificationCodeSequence'),
0x00401102: ('ST', '1', "Person's Address", '', 'PersonAddress'),
0x00401103: ('LO', '1-n', "Person's Telephone Numbers", '', 'PersonTelephoneNumbers'),
0x00401400: ('LT', '1', "Requested Procedure Comments", '', 'RequestedProcedureComments'),
0x00402001: ('LO', '1', "Reason for the Imaging Service Request", 'Retired', 'ReasonForTheImagingServiceRequest'),
0x00402004: ('DA', '1', "Issue Date of Imaging Service Request", '', 'IssueDateOfImagingServiceRequest'),
0x00402005: ('TM', '1', "Issue Time of Imaging Service Request", '', 'IssueTimeOfImagingServiceRequest'),
0x00402006: ('SH', '1', "Placer Order Number / Imaging Service Request (Retired)", 'Retired', 'PlacerOrderNumberImagingServiceRequestRetired'),
0x00402007: ('SH', '1', "Filler Order Number / Imaging Service Request (Retired)", 'Retired', 'FillerOrderNumberImagingServiceRequestRetired'),
0x00402008: ('PN', '1', "Order Entered By", '', 'OrderEnteredBy'),
0x00402009: ('SH', '1', "Order Enterer's Location", '', 'OrderEntererLocation'),
0x00402010: ('SH', '1', "Order Callback Phone Number", '', 'OrderCallbackPhoneNumber'),
0x00402016: ('LO', '1', "Placer Order Number / Imaging Service Request", '', 'PlacerOrderNumberImagingServiceRequest'),
0x00402017: ('LO', '1', "Filler Order Number / Imaging Service Request", '', 'FillerOrderNumberImagingServiceRequest'),
0x00402400: ('LT', '1', "Imaging Service Request Comments", '', 'ImagingServiceRequestComments'),
0x00403001: ('LO', '1', "Confidentiality Constraint on Patient Data Description", '', 'ConfidentialityConstraintOnPatientDataDescription'),
0x00404001: ('CS', '1', "General Purpose Scheduled Procedure Step Status", '', 'GeneralPurposeScheduledProcedureStepStatus'),
0x00404002: ('CS', '1', "General Purpose Performed Procedure Step Status", '', 'GeneralPurposePerformedProcedureStepStatus'),
0x00404003: ('CS', '1', "General Purpose Scheduled Procedure Step Priority", '', 'GeneralPurposeScheduledProcedureStepPriority'),
0x00404004: ('SQ', '1', "Scheduled Processing Applications Code Sequence", '', 'ScheduledProcessingApplicationsCodeSequence'),
0x00404005: ('DT', '1', "Scheduled Procedure Step Start DateTime", '', 'ScheduledProcedureStepStartDateTime'),
0x00404006: ('CS', '1', "Multiple Copies Flag", '', 'MultipleCopiesFlag'),
0x00404007: ('SQ', '1', "Performed Processing Applications Code Sequence", '', 'PerformedProcessingApplicationsCodeSequence'),
0x00404009: ('SQ', '1', "Human Performer Code Sequence", '', 'HumanPerformerCodeSequence'),
0x00404010: ('DT', '1', "Scheduled Procedure Step Modification Date Time", '', 'ScheduledProcedureStepModificationDateTime'),
0x00404011: ('DT', '1', "Expected Completion Date Time", '', 'ExpectedCompletionDateTime'),
0x00404015: ('SQ', '1', "Resulting General Purpose Performed Procedure Steps Sequence", '', 'ResultingGeneralPurposePerformedProcedureStepsSequence'),
0x00404016: ('SQ', '1', "Referenced General Purpose Scheduled Procedure Step Sequence", '', 'ReferencedGeneralPurposeScheduledProcedureStepSequence'),
0x00404018: ('SQ', '1', "Scheduled Workitem Code Sequence", '', 'ScheduledWorkitemCodeSequence'),
0x00404019: ('SQ', '1', "Performed Workitem Code Sequence", '', 'PerformedWorkitemCodeSequence'),
0x00404020: ('CS', '1', "Input Availability Flag", '', 'InputAvailabilityFlag'),
0x00404021: ('SQ', '1', "Input Information Sequence", '', 'InputInformationSequence'),
0x00404022: ('SQ', '1', "Relevant Information Sequence", '', 'RelevantInformationSequence'),
0x00404023: ('UI', '1', "Referenced General Purpose Scheduled Procedure Step Transaction UID", '', 'ReferencedGeneralPurposeScheduledProcedureStepTransactionUID'),
0x00404025: ('SQ', '1', "Scheduled Station Name Code Sequence", '', 'ScheduledStationNameCodeSequence'),
0x00404026: ('SQ', '1', "Scheduled Station Class Code Sequence", '', 'ScheduledStationClassCodeSequence'),
0x00404027: ('SQ', '1', "Scheduled Station Geographic Location Code Sequence", '', 'ScheduledStationGeographicLocationCodeSequence'),
0x00404028: ('SQ', '1', "Performed Station Name Code Sequence", '', 'PerformedStationNameCodeSequence'),
0x00404029: ('SQ', '1', "Performed Station Class Code Sequence", '', 'PerformedStationClassCodeSequence'),
0x00404030: ('SQ', '1', "Performed Station Geographic Location Code Sequence", '', 'PerformedStationGeographicLocationCodeSequence'),
0x00404031: ('SQ', '1', "Requested Subsequent Workitem Code Sequence", '', 'RequestedSubsequentWorkitemCodeSequence'),
0x00404032: ('SQ', '1', "Non-DICOM Output Code Sequence", '', 'NonDICOMOutputCodeSequence'),
0x00404033: ('SQ', '1', "Output Information Sequence", '', 'OutputInformationSequence'),
0x00404034: ('SQ', '1', "Scheduled Human Performers Sequence", '', 'ScheduledHumanPerformersSequence'),
0x00404035: ('SQ', '1', "Actual Human Performers Sequence", '', 'ActualHumanPerformersSequence'),
0x00404036: ('LO', '1', "Human Performer's Organization", '', 'HumanPerformerOrganization'),
0x00404037: ('PN', '1', "Human Performer's Name", '', 'HumanPerformerName'),
0x00404040: ('CS', '1', "Raw Data Handling", '', 'RawDataHandling'),
0x00404041: ('CS', '1', "Input Readiness State", '', 'InputReadinessState'),
0x00404050: ('DT', '1', "Performed Procedure Step Start DateTime", '', 'PerformedProcedureStepStartDateTime'),
0x00404051: ('DT', '1', "Performed Procedure Step End DateTime", '', 'PerformedProcedureStepEndDateTime'),
0x00404052: ('DT', '1', "Procedure Step Cancellation DateTime", '', 'ProcedureStepCancellationDateTime'),
0x00408302: ('DS', '1', "Entrance Dose in mGy", '', 'EntranceDoseInmGy'),
0x00409094: ('SQ', '1', "Referenced Image Real World Value Mapping Sequence", '', 'ReferencedImageRealWorldValueMappingSequence'),
0x00409096: ('SQ', '1', "Real World Value Mapping Sequence", '', 'RealWorldValueMappingSequence'),
0x00409098: ('SQ', '1', "Pixel Value Mapping Code Sequence", '', 'PixelValueMappingCodeSequence'),
0x00409210: ('SH', '1', "LUT Label", '', 'LUTLabel'),
0x00409211: ('US or SS', '1', "Real World Value Last Value Mapped", '', 'RealWorldValueLastValueMapped'),
0x00409212: ('FD', '1-n', "Real World Value LUT Data", '', 'RealWorldValueLUTData'),
0x00409216: ('US or SS', '1', "Real World Value First Value Mapped", '', 'RealWorldValueFirstValueMapped'),
0x00409224: ('FD', '1', "Real World Value Intercept", '', 'RealWorldValueIntercept'),
0x00409225: ('FD', '1', "Real World Value Slope", '', 'RealWorldValueSlope'),
0x0040A007: ('CS', '1', "Findings Flag (Trial)", 'Retired', 'FindingsFlagTrial'),
0x0040A010: ('CS', '1', "Relationship Type", '', 'RelationshipType'),
0x0040A020: ('SQ', '1', "Findings Sequence (Trial)", 'Retired', 'FindingsSequenceTrial'),
0x0040A021: ('UI', '1', "Findings Group UID (Trial)", 'Retired', 'FindingsGroupUIDTrial'),
0x0040A022: ('UI', '1', "Referenced Findings Group UID (Trial)", 'Retired', 'ReferencedFindingsGroupUIDTrial'),
0x0040A023: ('DA', '1', "Findings Group Recording Date (Trial)", 'Retired', 'FindingsGroupRecordingDateTrial'),
0x0040A024: ('TM', '1', "Findings Group Recording Time (Trial)", 'Retired', 'FindingsGroupRecordingTimeTrial'),
0x0040A026: ('SQ', '1', "Findings Source Category Code Sequence (Trial)", 'Retired', 'FindingsSourceCategoryCodeSequenceTrial'),
0x0040A027: ('LO', '1', "Verifying Organization", '', 'VerifyingOrganization'),
0x0040A028: ('SQ', '1', "Documenting Organization Identifier Code Sequence (Trial)", 'Retired', 'DocumentingOrganizationIdentifierCodeSequenceTrial'),
0x0040A030: ('DT', '1', "Verification Date Time", '', 'VerificationDateTime'),
0x0040A032: ('DT', '1', "Observation Date Time", '', 'ObservationDateTime'),
0x0040A040: ('CS', '1', "Value Type", '', 'ValueType'),
0x0040A043: ('SQ', '1', "Concept Name Code Sequence", '', 'ConceptNameCodeSequence'),
0x0040A047: ('LO', '1', "Measurement Precision Description (Trial)", 'Retired', 'MeasurementPrecisionDescriptionTrial'),
0x0040A050: ('CS', '1', "Continuity Of Content", '', 'ContinuityOfContent'),
0x0040A057: ('CS', '1-n', "Urgency or Priority Alerts (Trial)", 'Retired', 'UrgencyOrPriorityAlertsTrial'),
0x0040A060: ('LO', '1', "Sequencing Indicator (Trial)", 'Retired', 'SequencingIndicatorTrial'),
0x0040A066: ('SQ', '1', "Document Identifier Code Sequence (Trial)", 'Retired', 'DocumentIdentifierCodeSequenceTrial'),
0x0040A067: ('PN', '1', "Document Author (Trial)", 'Retired', 'DocumentAuthorTrial'),
0x0040A068: ('SQ', '1', "Document Author Identifier Code Sequence (Trial)", 'Retired', 'DocumentAuthorIdentifierCodeSequenceTrial'),
0x0040A070: ('SQ', '1', "Identifier Code Sequence (Trial)", 'Retired', 'IdentifierCodeSequenceTrial'),
0x0040A073: ('SQ', '1', "Verifying Observer Sequence", '', 'VerifyingObserverSequence'),
0x0040A074: ('OB', '1', "Object Binary Identifier (Trial)", 'Retired', 'ObjectBinaryIdentifierTrial'),
0x0040A075: ('PN', '1', "Verifying Observer Name", '', 'VerifyingObserverName'),
0x0040A076: ('SQ', '1', "Documenting Observer Identifier Code Sequence (Trial)", 'Retired', 'DocumentingObserverIdentifierCodeSequenceTrial'),
0x0040A078: ('SQ', '1', "Author Observer Sequence", '', 'AuthorObserverSequence'),
0x0040A07A: ('SQ', '1', "Participant Sequence", '', 'ParticipantSequence'),
0x0040A07C: ('SQ', '1', "Custodial Organization Sequence", '', 'CustodialOrganizationSequence'),
0x0040A080: ('CS', '1', "Participation Type", '', 'ParticipationType'),
0x0040A082: ('DT', '1', "Participation DateTime", '', 'ParticipationDateTime'),
0x0040A084: ('CS', '1', "Observer Type", '', 'ObserverType'),
0x0040A085: ('SQ', '1', "Procedure Identifier Code Sequence (Trial)", 'Retired', 'ProcedureIdentifierCodeSequenceTrial'),
0x0040A088: ('SQ', '1', "Verifying Observer Identification Code Sequence", '', 'VerifyingObserverIdentificationCodeSequence'),
0x0040A089: ('OB', '1', "Object Directory Binary Identifier (Trial)", 'Retired', 'ObjectDirectoryBinaryIdentifierTrial'),
0x0040A090: ('SQ', '1', "Equivalent CDA Document Sequence", 'Retired', 'EquivalentCDADocumentSequence'),
0x0040A0B0: ('US', '2-2n', "Referenced Waveform Channels", '', 'ReferencedWaveformChannels'),
0x0040A110: ('DA', '1', "Date of Document or Verbal Transaction (Trial)", 'Retired', 'DateOfDocumentOrVerbalTransactionTrial'),
0x0040A112: ('TM', '1', "Time of Document Creation or Verbal Transaction (Trial)", 'Retired', 'TimeOfDocumentCreationOrVerbalTransactionTrial'),
0x0040A120: ('DT', '1', "DateTime", '', 'DateTime'),
0x0040A121: ('DA', '1', "Date", '', 'Date'),
0x0040A122: ('TM', '1', "Time", '', 'Time'),
0x0040A123: ('PN', '1', "Person Name", '', 'PersonName'),
0x0040A124: ('UI', '1', "UID", '', 'UID'),
0x0040A125: ('CS', '2', "Report Status ID (Trial)", 'Retired', 'ReportStatusIDTrial'),
0x0040A130: ('CS', '1', "Temporal Range Type", '', 'TemporalRangeType'),
0x0040A132: ('UL', '1-n', "Referenced Sample Positions", '', 'ReferencedSamplePositions'),
0x0040A136: ('US', '1-n', "Referenced Frame Numbers", '', 'ReferencedFrameNumbers'),
0x0040A138: ('DS', '1-n', "Referenced Time Offsets", '', 'ReferencedTimeOffsets'),
0x0040A13A: ('DT', '1-n', "Referenced DateTime", '', 'ReferencedDateTime'),
0x0040A160: ('UT', '1', "Text Value", '', 'TextValue'),
0x0040A167: ('SQ', '1', "Observation Category Code Sequence (Trial)", 'Retired', 'ObservationCategoryCodeSequenceTrial'),
0x0040A168: ('SQ', '1', "Concept Code Sequence", '', 'ConceptCodeSequence'),
0x0040A16A: ('ST', '1', "Bibliographic Citation (Trial)", 'Retired', 'BibliographicCitationTrial'),
0x0040A170: ('SQ', '1', "Purpose of Reference Code Sequence", '', 'PurposeOfReferenceCodeSequence'),
0x0040A171: ('UI', '1', "Observation UID (Trial)", 'Retired', 'ObservationUIDTrial'),
0x0040A172: ('UI', '1', "Referenced Observation UID (Trial)", 'Retired', 'ReferencedObservationUIDTrial'),
0x0040A173: ('CS', '1', "Referenced Observation Class (Trial)", 'Retired', 'ReferencedObservationClassTrial'),
0x0040A174: ('CS', '1', "Referenced Object Observation Class (Trial)", 'Retired', 'ReferencedObjectObservationClassTrial'),
0x0040A180: ('US', '1', "Annotation Group Number", '', 'AnnotationGroupNumber'),
0x0040A192: ('DA', '1', "Observation Date (Trial)", 'Retired', 'ObservationDateTrial'),
0x0040A193: ('TM', '1', "Observation Time (Trial)", 'Retired', 'ObservationTimeTrial'),
0x0040A194: ('CS', '1', "Measurement Automation (Trial)", 'Retired', 'MeasurementAutomationTrial'),
0x0040A195: ('SQ', '1', "Modifier Code Sequence", '', 'ModifierCodeSequence'),
0x0040A224: ('ST', '1', "Identification Description (Trial)", 'Retired', 'IdentificationDescriptionTrial'),
0x0040A290: ('CS', '1', "Coordinates Set Geometric Type (Trial)", 'Retired', 'CoordinatesSetGeometricTypeTrial'),
0x0040A296: ('SQ', '1', "Algorithm Code Sequence (Trial)", 'Retired', 'AlgorithmCodeSequenceTrial'),
0x0040A297: ('ST', '1', "Algorithm Description (Trial)", 'Retired', 'AlgorithmDescriptionTrial'),
0x0040A29A: ('SL', '2-2n', "Pixel Coordinates Set (Trial)", 'Retired', 'PixelCoordinatesSetTrial'),
0x0040A300: ('SQ', '1', "Measured Value Sequence", '', 'MeasuredValueSequence'),
0x0040A301: ('SQ', '1', "Numeric Value Qualifier Code Sequence", '', 'NumericValueQualifierCodeSequence'),
0x0040A307: ('PN', '1', "Current Observer (Trial)", 'Retired', 'CurrentObserverTrial'),
0x0040A30A: ('DS', '1-n', "Numeric Value", '', 'NumericValue'),
0x0040A313: ('SQ', '1', "Referenced Accession Sequence (Trial)", 'Retired', 'ReferencedAccessionSequenceTrial'),
0x0040A33A: ('ST', '1', "Report Status Comment (Trial)", 'Retired', 'ReportStatusCommentTrial'),
0x0040A340: ('SQ', '1', "Procedure Context Sequence (Trial)", 'Retired', 'ProcedureContextSequenceTrial'),
0x0040A352: ('PN', '1', "Verbal Source (Trial)", 'Retired', 'VerbalSourceTrial'),
0x0040A353: ('ST', '1', "Address (Trial)", 'Retired', 'AddressTrial'),
0x0040A354: ('LO', '1', "Telephone Number (Trial)", 'Retired', 'TelephoneNumberTrial'),
0x0040A358: ('SQ', '1', "Verbal Source Identifier Code Sequence (Trial)", 'Retired', 'VerbalSourceIdentifierCodeSequenceTrial'),
0x0040A360: ('SQ', '1', "Predecessor Documents Sequence", '', 'PredecessorDocumentsSequence'),
0x0040A370: ('SQ', '1', "Referenced Request Sequence", '', 'ReferencedRequestSequence'),
0x0040A372: ('SQ', '1', "Performed Procedure Code Sequence", '', 'PerformedProcedureCodeSequence'),
0x0040A375: ('SQ', '1', "Current Requested Procedure Evidence Sequence", '', 'CurrentRequestedProcedureEvidenceSequence'),
0x0040A380: ('SQ', '1', "Report Detail Sequence (Trial)", 'Retired', 'ReportDetailSequenceTrial'),
0x0040A385: ('SQ', '1', "Pertinent Other Evidence Sequence", '', 'PertinentOtherEvidenceSequence'),
0x0040A390: ('SQ', '1', "HL7 Structured Document Reference Sequence", '', 'HL7StructuredDocumentReferenceSequence'),
0x0040A402: ('UI', '1', "Observation Subject UID (Trial)", 'Retired', 'ObservationSubjectUIDTrial'),
0x0040A403: ('CS', '1', "Observation Subject Class (Trial)", 'Retired', 'ObservationSubjectClassTrial'),
0x0040A404: ('SQ', '1', "Observation Subject Type Code Sequence (Trial)", 'Retired', 'ObservationSubjectTypeCodeSequenceTrial'),
0x0040A491: ('CS', '1', "Completion Flag", '', 'CompletionFlag'),
0x0040A492: ('LO', '1', "Completion Flag Description", '', 'CompletionFlagDescription'),
0x0040A493: ('CS', '1', "Verification Flag", '', 'VerificationFlag'),
0x0040A494: ('CS', '1', "Archive Requested", '', 'ArchiveRequested'),
0x0040A496: ('CS', '1', "Preliminary Flag", '', 'PreliminaryFlag'),
0x0040A504: ('SQ', '1', "Content Template Sequence", '', 'ContentTemplateSequence'),
0x0040A525: ('SQ', '1', "Identical Documents Sequence", '', 'IdenticalDocumentsSequence'),
0x0040A600: ('CS', '1', "Observation Subject Context Flag (Trial)", 'Retired', 'ObservationSubjectContextFlagTrial'),
0x0040A601: ('CS', '1', "Observer Context Flag (Trial)", 'Retired', 'ObserverContextFlagTrial'),
0x0040A603: ('CS', '1', "Procedure Context Flag (Trial)", 'Retired', 'ProcedureContextFlagTrial'),
0x0040A730: ('SQ', '1', "Content Sequence", '', 'ContentSequence'),
0x0040A731: ('SQ', '1', "Relationship Sequence (Trial)", 'Retired', 'RelationshipSequenceTrial'),
0x0040A732: ('SQ', '1', "Relationship Type Code Sequence (Trial)", 'Retired', 'RelationshipTypeCodeSequenceTrial'),
0x0040A744: ('SQ', '1', "Language Code Sequence (Trial)", 'Retired', 'LanguageCodeSequenceTrial'),
0x0040A992: ('ST', '1', "Uniform Resource Locator (Trial)", 'Retired', 'UniformResourceLocatorTrial'),
0x0040B020: ('SQ', '1', "Waveform Annotation Sequence", '', 'WaveformAnnotationSequence'),
0x0040DB00: ('CS', '1', "Template Identifier", '', 'TemplateIdentifier'),
0x0040DB06: ('DT', '1', "Template Version", 'Retired', 'TemplateVersion'),
0x0040DB07: ('DT', '1', "Template Local Version", 'Retired', 'TemplateLocalVersion'),
0x0040DB0B: ('CS', '1', "Template Extension Flag", 'Retired', 'TemplateExtensionFlag'),
0x0040DB0C: ('UI', '1', "Template Extension Organization UID", 'Retired', 'TemplateExtensionOrganizationUID'),
0x0040DB0D: ('UI', '1', "Template Extension Creator UID", 'Retired', 'TemplateExtensionCreatorUID'),
0x0040DB73: ('UL', '1-n', "Referenced Content Item Identifier", '', 'ReferencedContentItemIdentifier'),
0x0040E001: ('ST', '1', "HL7 Instance Identifier", '', 'HL7InstanceIdentifier'),
0x0040E004: ('DT', '1', "HL7 Document Effective Time", '', 'HL7DocumentEffectiveTime'),
0x0040E006: ('SQ', '1', "HL7 Document Type Code Sequence", '', 'HL7DocumentTypeCodeSequence'),
0x0040E008: ('SQ', '1', "Document Class Code Sequence", '', 'DocumentClassCodeSequence'),
0x0040E010: ('UT', '1', "Retrieve URI", '', 'RetrieveURI'),
0x0040E011: ('UI', '1', "Retrieve Location UID", '', 'RetrieveLocationUID'),
0xE020: ('CS', '1', "Type of Instances", '', 'TypeOfInstances'),
0xE021: ('SQ', '1', "DICOM Retrieval Sequence", '', 'DICOMRetrievalSequence'),
0xE022: ('SQ', '1', "DICOM Media Retrieval Sequence", '', 'DICOMMediaRetrievalSequence'),
0xE023: ('SQ', '1', "WADO Retrieval Sequence", '', 'WADORetrievalSequence'),
0xE024: ('SQ', '1', "XDS Retrieval Sequence", '', 'XDSRetrievalSequence'),
0xE030: ('UI', '1', "Repository Unique ID", '', 'RepositoryUniqueID'),
0xE031: ('UI', '1', "Home Community ID", '', 'HomeCommunityID'),
0x00420010: ('ST', '1', "Document Title", '', 'DocumentTitle'),
0x00420011: ('OB', '1', "Encapsulated Document", '', 'EncapsulatedDocument'),
0x00420012: ('LO', '1', "MIME Type of Encapsulated Document", '', 'MIMETypeOfEncapsulatedDocument'),
0x00420013: ('SQ', '1', "Source Instance Sequence", '', 'SourceInstanceSequence'),
0x00420014: ('LO', '1-n', "List of MIME Types", '', 'ListOfMIMETypes'),
0x00440001: ('ST', '1', "Product Package Identifier", '', 'ProductPackageIdentifier'),
0x00440002: ('CS', '1', "Substance Administration Approval", '', 'SubstanceAdministrationApproval'),
0x00440003: ('LT', '1', "Approval Status Further Description", '', 'ApprovalStatusFurtherDescription'),
0x00440004: ('DT', '1', "Approval Status DateTime", '', 'ApprovalStatusDateTime'),
0x00440007: ('SQ', '1', "Product Type Code Sequence", '', 'ProductTypeCodeSequence'),
0x00440008: ('LO', '1-n', "Product Name", '', 'ProductName'),
0x00440009: ('LT', '1', "Product Description", '', 'ProductDescription'),
0x0044000A: ('LO', '1', "Product Lot Identifier", '', 'ProductLotIdentifier'),
0x0044000B: ('DT', '1', "Product Expiration DateTime", '', 'ProductExpirationDateTime'),
0x00440010: ('DT', '1', "Substance Administration DateTime", '', 'SubstanceAdministrationDateTime'),
0x00440011: ('LO', '1', "Substance Administration Notes", '', 'SubstanceAdministrationNotes'),
0x00440012: ('LO', '1', "Substance Administration Device ID", '', 'SubstanceAdministrationDeviceID'),
0x00440013: ('SQ', '1', "Product Parameter Sequence", '', 'ProductParameterSequence'),
0x00440019: ('SQ', '1', "Substance Administration Parameter Sequence", '', 'SubstanceAdministrationParameterSequence'),
0x00460012: ('LO', '1', "Lens Description", '', 'LensDescription'),
0x00460014: ('SQ', '1', "Right Lens Sequence", '', 'RightLensSequence'),
0x00460015: ('SQ', '1', "Left Lens Sequence", '', 'LeftLensSequence'),
0x00460016: ('SQ', '1', "Unspecified Laterality Lens Sequence", '', 'UnspecifiedLateralityLensSequence'),
0x00460018: ('SQ', '1', "Cylinder Sequence", '', 'CylinderSequence'),
0x00460028: ('SQ', '1', "Prism Sequence", '', 'PrismSequence'),
0x00460030: ('FD', '1', "Horizontal Prism Power", '', 'HorizontalPrismPower'),
0x00460032: ('CS', '1', "Horizontal Prism Base", '', 'HorizontalPrismBase'),
0x00460034: ('FD', '1', "Vertical Prism Power", '', 'VerticalPrismPower'),
0x00460036: ('CS', '1', "Vertical Prism Base", '', 'VerticalPrismBase'),
0x00460038: ('CS', '1', "Lens Segment Type", '', 'LensSegmentType'),
0x00460040: ('FD', '1', "Optical Transmittance", '', 'OpticalTransmittance'),
0x00460042: ('FD', '1', "Channel Width", '', 'ChannelWidth'),
0x00460044: ('FD', '1', "Pupil Size", '', 'PupilSize'),
0x00460046: ('FD', '1', "Corneal Size", '', 'CornealSize'),
0x00460050: ('SQ', '1', "Autorefraction Right Eye Sequence", '', 'AutorefractionRightEyeSequence'),
0x00460052: ('SQ', '1', "Autorefraction Left Eye Sequence", '', 'AutorefractionLeftEyeSequence'),
0x00460060: ('FD', '1', "Distance Pupillary Distance", '', 'DistancePupillaryDistance'),
0x00460062: ('FD', '1', "Near Pupillary Distance", '', 'NearPupillaryDistance'),
0x00460063: ('FD', '1', "Intermediate Pupillary Distance", '', 'IntermediatePupillaryDistance'),
0x00460064: ('FD', '1', "Other Pupillary Distance", '', 'OtherPupillaryDistance'),
0x00460070: ('SQ', '1', "Keratometry Right Eye Sequence", '', 'KeratometryRightEyeSequence'),
0x00460071: ('SQ', '1', "Keratometry Left Eye Sequence", '', 'KeratometryLeftEyeSequence'),
0x00460074: ('SQ', '1', "Steep Keratometric Axis Sequence", '', 'SteepKeratometricAxisSequence'),
0x00460075: ('FD', '1', "Radius of Curvature", '', 'RadiusOfCurvature'),
0x00460076: ('FD', '1', "Keratometric Power", '', 'KeratometricPower'),
0x00460077: ('FD', '1', "Keratometric Axis", '', 'KeratometricAxis'),
0x00460080: ('SQ', '1', "Flat Keratometric Axis Sequence", '', 'FlatKeratometricAxisSequence'),
0x00460092: ('CS', '1', "Background Color", '', 'BackgroundColor'),
0x00460094: ('CS', '1', "Optotype", '', 'Optotype'),
0x00460095: ('CS', '1', "Optotype Presentation", '', 'OptotypePresentation'),
0x00460097: ('SQ', '1', "Subjective Refraction Right Eye Sequence", '', 'SubjectiveRefractionRightEyeSequence'),
0x00460098: ('SQ', '1', "Subjective Refraction Left Eye Sequence", '', 'SubjectiveRefractionLeftEyeSequence'),
0x00460100: ('SQ', '1', "Add Near Sequence", '', 'AddNearSequence'),
0x00460101: ('SQ', '1', "Add Intermediate Sequence", '', 'AddIntermediateSequence'),
0x00460102: ('SQ', '1', "Add Other Sequence", '', 'AddOtherSequence'),
0x00460104: ('FD', '1', "Add Power", '', 'AddPower'),
0x00460106: ('FD', '1', "Viewing Distance", '', 'ViewingDistance'),
0x00460121: ('SQ', '1', "Visual Acuity Type Code Sequence", '', 'VisualAcuityTypeCodeSequence'),
0x00460122: ('SQ', '1', "Visual Acuity Right Eye Sequence", '', 'VisualAcuityRightEyeSequence'),
0x00460123: ('SQ', '1', "Visual Acuity Left Eye Sequence", '', 'VisualAcuityLeftEyeSequence'),
0x00460124: ('SQ', '1', "Visual Acuity Both Eyes Open Sequence", '', 'VisualAcuityBothEyesOpenSequence'),
0x00460125: ('CS', '1', "Viewing Distance Type", '', 'ViewingDistanceType'),
0x00460135: ('SS', '2', "Visual Acuity Modifiers", '', 'VisualAcuityModifiers'),
0x00460137: ('FD', '1', "Decimal Visual Acuity", '', 'DecimalVisualAcuity'),
0x00460139: ('LO', '1', "Optotype Detailed Definition", '', 'OptotypeDetailedDefinition'),
0x00460145: ('SQ', '1', "Referenced Refractive Measurements Sequence", '', 'ReferencedRefractiveMeasurementsSequence'),
0x00460146: ('FD', '1', "Sphere Power", '', 'SpherePower'),
0x00460147: ('FD', '1', "Cylinder Power", '', 'CylinderPower'),
0x00480001: ('FL', '1', "Imaged Volume Width", '', 'ImagedVolumeWidth'),
0x00480002: ('FL', '1', "Imaged Volume Height", '', 'ImagedVolumeHeight'),
0x00480003: ('FL', '1', "Imaged Volume Depth", '', 'ImagedVolumeDepth'),
0x00480006: ('UL', '1', "Total Pixel Matrix Columns", '', 'TotalPixelMatrixColumns'),
0x00480007: ('UL', '1', "Total Pixel Matrix Rows", '', 'TotalPixelMatrixRows'),
0x00480008: ('SQ', '1', "Total Pixel Matrix Origin Sequence", '', 'TotalPixelMatrixOriginSequence'),
0x00480010: ('CS', '1', "Specimen Label in Image", '', 'SpecimenLabelInImage'),
0x00480011: ('CS', '1', "Focus Method", '', 'FocusMethod'),
0x00480012: ('CS', '1', "Extended Depth of Field", '', 'ExtendedDepthOfField'),
0x00480013: ('US', '1', "Number of Focal Planes", '', 'NumberOfFocalPlanes'),
0x00480014: ('FL', '1', "Distance Between Focal Planes", '', 'DistanceBetweenFocalPlanes'),
0x00480015: ('US', '3', "Recommended Absent Pixel CIELab Value", '', 'RecommendedAbsentPixelCIELabValue'),
0x00480100: ('SQ', '1', "Illuminator Type Code Sequence", '', 'IlluminatorTypeCodeSequence'),
0x00480102: ('DS', '6', "Image Orientation (Slide)", '', 'ImageOrientationSlide'),
0x00480105: ('SQ', '1', "Optical Path Sequence", '', 'OpticalPathSequence'),
0x00480106: ('SH', '1', "Optical Path Identifier", '', 'OpticalPathIdentifier'),
0x00480107: ('ST', '1', "Optical Path Description", '', 'OpticalPathDescription'),
0x00480108: ('SQ', '1', "Illumination Color Code Sequence", '', 'IlluminationColorCodeSequence'),
0x00480110: ('SQ', '1', "Specimen Reference Sequence", '', 'SpecimenReferenceSequence'),
0x00480111: ('DS', '1', "Condenser Lens Power", '', 'CondenserLensPower'),
0x00480112: ('DS', '1', "Objective Lens Power", '', 'ObjectiveLensPower'),
0x00480113: ('DS', '1', "Objective Lens Numerical Aperture", '', 'ObjectiveLensNumericalAperture'),
0x00480120: ('SQ', '1', "Palette Color Lookup Table Sequence", '', 'PaletteColorLookupTableSequence'),
0x00480200: ('SQ', '1', "Referenced Image Navigation Sequence", '', 'ReferencedImageNavigationSequence'),
0x00480201: ('US', '2', "Top Left Hand Corner of Localizer Area", '', 'TopLeftHandCornerOfLocalizerArea'),
0x00480202: ('US', '2', "Bottom Right Hand Corner of Localizer Area", '', 'BottomRightHandCornerOfLocalizerArea'),
0x00480207: ('SQ', '1', "Optical Path Identification Sequence", '', 'OpticalPathIdentificationSequence'),
0x0048021A: ('SQ', '1', "Plane Position (Slide) Sequence", '', 'PlanePositionSlideSequence'),
0x0048021E: ('SL', '1', "Row Position In Total Image Pixel Matrix", '', 'RowPositionInTotalImagePixelMatrix'),
0x0048021F: ('SL', '1', "Column Position In Total Image Pixel Matrix", '', 'ColumnPositionInTotalImagePixelMatrix'),
0x00480301: ('CS', '1', "Pixel Origin Interpretation", '', 'PixelOriginInterpretation'),
0x00500004: ('CS', '1', "Calibration Image", '', 'CalibrationImage'),
0x00500010: ('SQ', '1', "Device Sequence", '', 'DeviceSequence'),
0x00500012: ('SQ', '1', "Container Component Type Code Sequence", '', 'ContainerComponentTypeCodeSequence'),
0x00500013: ('FD', '1', "Container Component Thickness", '', 'ContainerComponentThickness'),
0x00500014: ('DS', '1', "Device Length", '', 'DeviceLength'),
0x00500015: ('FD', '1', "Container Component Width", '', 'ContainerComponentWidth'),
0x00500016: ('DS', '1', "Device Diameter", '', 'DeviceDiameter'),
0x00500017: ('CS', '1', "Device Diameter Units", '', 'DeviceDiameterUnits'),
0x00500018: ('DS', '1', "Device Volume", '', 'DeviceVolume'),
0x00500019: ('DS', '1', "Inter-Marker Distance", '', 'InterMarkerDistance'),
0x0050001A: ('CS', '1', "Container Component Material", '', 'ContainerComponentMaterial'),
0x0050001B: ('LO', '1', "Container Component ID", '', 'ContainerComponentID'),
0x0050001C: ('FD', '1', "Container Component Length", '', 'ContainerComponentLength'),
0x0050001D: ('FD', '1', "Container Component Diameter", '', 'ContainerComponentDiameter'),
0x0050001E: ('LO', '1', "Container Component Description", '', 'ContainerComponentDescription'),
0x00500020: ('LO', '1', "Device Description", '', 'DeviceDescription'),
0x00520001: ('FL', '1', "Contrast/Bolus Ingredient Percent by Volume", '', 'ContrastBolusIngredientPercentByVolume'),
0x00520002: ('FD', '1', "OCT Focal Distance", '', 'OCTFocalDistance'),
0x00520003: ('FD', '1', "Beam Spot Size", '', 'BeamSpotSize'),
0x00520004: ('FD', '1', "Effective Refractive Index", '', 'EffectiveRefractiveIndex'),
0x00520006: ('CS', '1', "OCT Acquisition Domain", '', 'OCTAcquisitionDomain'),
0x00520007: ('FD', '1', "OCT Optical Center Wavelength", '', 'OCTOpticalCenterWavelength'),
0x00520008: ('FD', '1', "Axial Resolution", '', 'AxialResolution'),
0x00520009: ('FD', '1', "Ranging Depth", '', 'RangingDepth'),
0x00520011: ('FD', '1', "A-line Rate", '', 'ALineRate'),
0x00520012: ('US', '1', "A-lines Per Frame", '', 'ALinesPerFrame'),
0x00520013: ('FD', '1', "Catheter Rotational Rate", '', 'CatheterRotationalRate'),
0x00520014: ('FD', '1', "A-line Pixel Spacing", '', 'ALinePixelSpacing'),
0x00520016: ('SQ', '1', "Mode of Percutaneous Access Sequence", '', 'ModeOfPercutaneousAccessSequence'),
0x00520025: ('SQ', '1', "Intravascular OCT Frame Type Sequence", '', 'IntravascularOCTFrameTypeSequence'),
0x00520026: ('CS', '1', "OCT Z Offset Applied", '', 'OCTZOffsetApplied'),
0x00520027: ('SQ', '1', "Intravascular Frame Content Sequence", '', 'IntravascularFrameContentSequence'),
0x00520028: ('FD', '1', "Intravascular Longitudinal Distance", '', 'IntravascularLongitudinalDistance'),
0x00520029: ('SQ', '1', "Intravascular OCT Frame Content Sequence", '', 'IntravascularOCTFrameContentSequence'),
0x00520030: ('SS', '1', "OCT Z Offset Correction", '', 'OCTZOffsetCorrection'),
0x00520031: ('CS', '1', "Catheter Direction of Rotation", '', 'CatheterDirectionOfRotation'),
0x00520033: ('FD', '1', "Seam Line Location", '', 'SeamLineLocation'),
0x00520034: ('FD', '1', "First A-line Location", '', 'FirstALineLocation'),
0x00520036: ('US', '1', "Seam Line Index", '', 'SeamLineIndex'),
0x00520038: ('US', '1', "Number of Padded A-lines", '', 'NumberOfPaddedAlines'),
0x00520039: ('CS', '1', "Interpolation Type", '', 'InterpolationType'),
0x0052003A: ('CS', '1', "Refractive Index Applied", '', 'RefractiveIndexApplied'),
0x00540010: ('US', '1-n', "Energy Window Vector", '', 'EnergyWindowVector'),
0x00540011: ('US', '1', "Number of Energy Windows", '', 'NumberOfEnergyWindows'),
0x00540012: ('SQ', '1', "Energy Window Information Sequence", '', 'EnergyWindowInformationSequence'),
0x00540013: ('SQ', '1', "Energy Window Range Sequence", '', 'EnergyWindowRangeSequence'),
0x00540014: ('DS', '1', "Energy Window Lower Limit", '', 'EnergyWindowLowerLimit'),
0x00540015: ('DS', '1', "Energy Window Upper Limit", '', 'EnergyWindowUpperLimit'),
0x00540016: ('SQ', '1', "Radiopharmaceutical Information Sequence", '', 'RadiopharmaceuticalInformationSequence'),
0x00540017: ('IS', '1', "Residual Syringe Counts", '', 'ResidualSyringeCounts'),
0x00540018: ('SH', '1', "Energy Window Name", '', 'EnergyWindowName'),
0x00540020: ('US', '1-n', "Detector Vector", '', 'DetectorVector'),
0x00540021: ('US', '1', "Number of Detectors", '', 'NumberOfDetectors'),
0x00540022: ('SQ', '1', "Detector Information Sequence", '', 'DetectorInformationSequence'),
0x00540030: ('US', '1-n', "Phase Vector", '', 'PhaseVector'),
0x00540031: ('US', '1', "Number of Phases", '', 'NumberOfPhases'),
0x00540032: ('SQ', '1', "Phase Information Sequence", '', 'PhaseInformationSequence'),
0x00540033: ('US', '1', "Number of Frames in Phase", '', 'NumberOfFramesInPhase'),
0x00540036: ('IS', '1', "Phase Delay", '', 'PhaseDelay'),
0x00540038: ('IS', '1', "Pause Between Frames", '', 'PauseBetweenFrames'),
0x00540039: ('CS', '1', "Phase Description", '', 'PhaseDescription'),
0x00540050: ('US', '1-n', "Rotation Vector", '', 'RotationVector'),
0x00540051: ('US', '1', "Number of Rotations", '', 'NumberOfRotations'),
0x00540052: ('SQ', '1', "Rotation Information Sequence", '', 'RotationInformationSequence'),
0x00540053: ('US', '1', "Number of Frames in Rotation", '', 'NumberOfFramesInRotation'),
0x00540060: ('US', '1-n', "R-R Interval Vector", '', 'RRIntervalVector'),
0x00540061: ('US', '1', "Number of R-R Intervals", '', 'NumberOfRRIntervals'),
0x00540062: ('SQ', '1', "Gated Information Sequence", '', 'GatedInformationSequence'),
0x00540063: ('SQ', '1', "Data Information Sequence", '', 'DataInformationSequence'),
0x00540070: ('US', '1-n', "Time Slot Vector", '', 'TimeSlotVector'),
0x00540071: ('US', '1', "Number of Time Slots", '', 'NumberOfTimeSlots'),
0x00540072: ('SQ', '1', "Time Slot Information Sequence", '', 'TimeSlotInformationSequence'),
0x00540073: ('DS', '1', "Time Slot Time", '', 'TimeSlotTime'),
0x00540080: ('US', '1-n', "Slice Vector", '', 'SliceVector'),
0x00540081: ('US', '1', "Number of Slices", '', 'NumberOfSlices'),
0x00540090: ('US', '1-n', "Angular View Vector", '', 'AngularViewVector'),
0x00540100: ('US', '1-n', "Time Slice Vector", '', 'TimeSliceVector'),
0x00540101: ('US', '1', "Number of Time Slices", '', 'NumberOfTimeSlices'),
0x00540200: ('DS', '1', "Start Angle", '', 'StartAngle'),
0x00540202: ('CS', '1', "Type of Detector Motion", '', 'TypeOfDetectorMotion'),
0x00540210: ('IS', '1-n', "Trigger Vector", '', 'TriggerVector'),
0x00540211: ('US', '1', "Number of Triggers in Phase", '', 'NumberOfTriggersInPhase'),
0x00540220: ('SQ', '1', "View Code Sequence", '', 'ViewCodeSequence'),
0x00540222: ('SQ', '1', "View Modifier Code Sequence", '', 'ViewModifierCodeSequence'),
0x00540300: ('SQ', '1', "Radionuclide Code Sequence", '', 'RadionuclideCodeSequence'),
0x00540302: ('SQ', '1', "Administration Route Code Sequence", '', 'AdministrationRouteCodeSequence'),
0x00540304: ('SQ', '1', "Radiopharmaceutical Code Sequence", '', 'RadiopharmaceuticalCodeSequence'),
0x00540306: ('SQ', '1', "Calibration Data Sequence", '', 'CalibrationDataSequence'),
0x00540308: ('US', '1', "Energy Window Number", '', 'EnergyWindowNumber'),
0x00540400: ('SH', '1', "Image ID", '', 'ImageID'),
0x00540410: ('SQ', '1', "Patient Orientation Code Sequence", '', 'PatientOrientationCodeSequence'),
0x00540412: ('SQ', '1', "Patient Orientation Modifier Code Sequence", '', 'PatientOrientationModifierCodeSequence'),
0x00540414: ('SQ', '1', "Patient Gantry Relationship Code Sequence", '', 'PatientGantryRelationshipCodeSequence'),
0x00540500: ('CS', '1', "Slice Progression Direction", '', 'SliceProgressionDirection'),
0x00541000: ('CS', '2', "Series Type", '', 'SeriesType'),
0x00541001: ('CS', '1', "Units", '', 'Units'),
0x00541002: ('CS', '1', "Counts Source", '', 'CountsSource'),
0x00541004: ('CS', '1', "Reprojection Method", '', 'ReprojectionMethod'),
0x00541006: ('CS', '1', "SUV Type", '', 'SUVType'),
0x00541100: ('CS', '1', "Randoms Correction Method", '', 'RandomsCorrectionMethod'),
0x00541101: ('LO', '1', "Attenuation Correction Method", '', 'AttenuationCorrectionMethod'),
0x00541102: ('CS', '1', "Decay Correction", '', 'DecayCorrection'),
0x00541103: ('LO', '1', "Reconstruction Method", '', 'ReconstructionMethod'),
0x00541104: ('LO', '1', "Detector Lines of Response Used", '', 'DetectorLinesOfResponseUsed'),
0x00541105: ('LO', '1', "Scatter Correction Method", '', 'ScatterCorrectionMethod'),
0x00541200: ('DS', '1', "Axial Acceptance", '', 'AxialAcceptance'),
0x00541201: ('IS', '2', "Axial Mash", '', 'AxialMash'),
0x00541202: ('IS', '1', "Transverse Mash", '', 'TransverseMash'),
0x00541203: ('DS', '2', "Detector Element Size", '', 'DetectorElementSize'),
0x00541210: ('DS', '1', "Coincidence Window Width", '', 'CoincidenceWindowWidth'),
0x00541220: ('CS', '1-n', "Secondary Counts Type", '', 'SecondaryCountsType'),
0x00541300: ('DS', '1', "Frame Reference Time", '', 'FrameReferenceTime'),
0x00541310: ('IS', '1', "Primary (Prompts) Counts Accumulated", '', 'PrimaryPromptsCountsAccumulated'),
0x00541311: ('IS', '1-n', "Secondary Counts Accumulated", '', 'SecondaryCountsAccumulated'),
0x00541320: ('DS', '1', "Slice Sensitivity Factor", '', 'SliceSensitivityFactor'),
0x00541321: ('DS', '1', "Decay Factor", '', 'DecayFactor'),
0x00541322: ('DS', '1', "Dose Calibration Factor", '', 'DoseCalibrationFactor'),
0x00541323: ('DS', '1', "Scatter Fraction Factor", '', 'ScatterFractionFactor'),
0x00541324: ('DS', '1', "Dead Time Factor", '', 'DeadTimeFactor'),
0x00541330: ('US', '1', "Image Index", '', 'ImageIndex'),
0x00541400: ('CS', '1-n', "Counts Included", 'Retired', 'CountsIncluded'),
0x00541401: ('CS', '1', "Dead Time Correction Flag", 'Retired', 'DeadTimeCorrectionFlag'),
0x00603000: ('SQ', '1', "Histogram Sequence", '', 'HistogramSequence'),
0x00603002: ('US', '1', "Histogram Number of Bins", '', 'HistogramNumberOfBins'),
0x00603004: ('US or SS', '1', "Histogram First Bin Value", '', 'HistogramFirstBinValue'),
0x00603006: ('US or SS', '1', "Histogram Last Bin Value", '', 'HistogramLastBinValue'),
0x00603008: ('US', '1', "Histogram Bin Width", '', 'HistogramBinWidth'),
0x00603010: ('LO', '1', "Histogram Explanation", '', 'HistogramExplanation'),
0x00603020: ('UL', '1-n', "Histogram Data", '', 'HistogramData'),
0x00620001: ('CS', '1', "Segmentation Type", '', 'SegmentationType'),
0x00620002: ('SQ', '1', "Segment Sequence", '', 'SegmentSequence'),
0x00620003: ('SQ', '1', "Segmented Property Category Code Sequence", '', 'SegmentedPropertyCategoryCodeSequence'),
0x00620004: ('US', '1', "Segment Number", '', 'SegmentNumber'),
0x00620005: ('LO', '1', "Segment Label", '', 'SegmentLabel'),
0x00620006: ('ST', '1', "Segment Description", '', 'SegmentDescription'),
0x00620008: ('CS', '1', "Segment Algorithm Type", '', 'SegmentAlgorithmType'),
0x00620009: ('LO', '1', "Segment Algorithm Name", '', 'SegmentAlgorithmName'),
0x0062000A: ('SQ', '1', "Segment Identification Sequence", '', 'SegmentIdentificationSequence'),
0x0062000B: ('US', '1-n', "Referenced Segment Number", '', 'ReferencedSegmentNumber'),
0x0062000C: ('US', '1', "Recommended Display Grayscale Value", '', 'RecommendedDisplayGrayscaleValue'),
0x0062000D: ('US', '3', "Recommended Display CIELab Value", '', 'RecommendedDisplayCIELabValue'),
0x0062000E: ('US', '1', "Maximum Fractional Value", '', 'MaximumFractionalValue'),
0x0062000F: ('SQ', '1', "Segmented Property Type Code Sequence", '', 'SegmentedPropertyTypeCodeSequence'),
0x00620010: ('CS', '1', "Segmentation Fractional Type", '', 'SegmentationFractionalType'),
0x00640002: ('SQ', '1', "Deformable Registration Sequence", '', 'DeformableRegistrationSequence'),
0x00640003: ('UI', '1', "Source Frame of Reference UID", '', 'SourceFrameOfReferenceUID'),
0x00640005: ('SQ', '1', "Deformable Registration Grid Sequence", '', 'DeformableRegistrationGridSequence'),
0x00640007: ('UL', '3', "Grid Dimensions", '', 'GridDimensions'),
0x00640008: ('FD', '3', "Grid Resolution", '', 'GridResolution'),
0x00640009: ('OF', '1', "Vector Grid Data", '', 'VectorGridData'),
0x0064000F: ('SQ', '1', "Pre Deformation Matrix Registration Sequence", '', 'PreDeformationMatrixRegistrationSequence'),
0x00640010: ('SQ', '1', "Post Deformation Matrix Registration Sequence", '', 'PostDeformationMatrixRegistrationSequence'),
0x00660001: ('UL', '1', "Number of Surfaces", '', 'NumberOfSurfaces'),
0x00660002: ('SQ', '1', "Surface Sequence", '', 'SurfaceSequence'),
0x00660003: ('UL', '1', "Surface Number", '', 'SurfaceNumber'),
0x00660004: ('LT', '1', "Surface Comments", '', 'SurfaceComments'),
0x00660009: ('CS', '1', "Surface Processing", '', 'SurfaceProcessing'),
0x0066000A: ('FL', '1', "Surface Processing Ratio", '', 'SurfaceProcessingRatio'),
0x0066000B: ('LO', '1', "Surface Processing Description", '', 'SurfaceProcessingDescription'),
0x0066000C: ('FL', '1', "Recommended Presentation Opacity", '', 'RecommendedPresentationOpacity'),
0x0066000D: ('CS', '1', "Recommended Presentation Type", '', 'RecommendedPresentationType'),
0x0066000E: ('CS', '1', "Finite Volume", '', 'FiniteVolume'),
0x00660010: ('CS', '1', "Manifold", '', 'Manifold'),
0x00660011: ('SQ', '1', "Surface Points Sequence", '', 'SurfacePointsSequence'),
0x00660012: ('SQ', '1', "Surface Points Normals Sequence", '', 'SurfacePointsNormalsSequence'),
0x00660013: ('SQ', '1', "Surface Mesh Primitives Sequence", '', 'SurfaceMeshPrimitivesSequence'),
0x00660015: ('UL', '1', "Number of Surface Points", '', 'NumberOfSurfacePoints'),
0x00660016: ('OF', '1', "Point Coordinates Data", '', 'PointCoordinatesData'),
0x00660017: ('FL', '3', "Point Position Accuracy", '', 'PointPositionAccuracy'),
0x00660018: ('FL', '1', "Mean Point Distance", '', 'MeanPointDistance'),
0x00660019: ('FL', '1', "Maximum Point Distance", '', 'MaximumPointDistance'),
0x0066001A: ('FL', '6', "Points Bounding Box Coordinates", '', 'PointsBoundingBoxCoordinates'),
0x0066001B: ('FL', '3', "Axis of Rotation", '', 'AxisOfRotation'),
0x0066001C: ('FL', '3', "Center of Rotation", '', 'CenterOfRotation'),
0x0066001E: ('UL', '1', "Number of Vectors", '', 'NumberOfVectors'),
0x0066001F: ('US', '1', "Vector Dimensionality", '', 'VectorDimensionality'),
0x00660020: ('FL', '1-n', "Vector Accuracy", '', 'VectorAccuracy'),
0x00660021: ('OF', '1', "Vector Coordinate Data", '', 'VectorCoordinateData'),
0x00660023: ('OW', '1', "Triangle Point Index List", '', 'TrianglePointIndexList'),
0x00660024: ('OW', '1', "Edge Point Index List", '', 'EdgePointIndexList'),
0x00660025: ('OW', '1', "Vertex Point Index List", '', 'VertexPointIndexList'),
0x00660026: ('SQ', '1', "Triangle Strip Sequence", '', 'TriangleStripSequence'),
0x00660027: ('SQ', '1', "Triangle Fan Sequence", '', 'TriangleFanSequence'),
0x00660028: ('SQ', '1', "Line Sequence", '', 'LineSequence'),
0x00660029: ('OW', '1', "Primitive Point Index List", '', 'PrimitivePointIndexList'),
0x0066002A: ('UL', '1', "Surface Count", '', 'SurfaceCount'),
0x0066002B: ('SQ', '1', "Referenced Surface Sequence", '', 'ReferencedSurfaceSequence'),
0x0066002C: ('UL', '1', "Referenced Surface Number", '', 'ReferencedSurfaceNumber'),
0x0066002D: ('SQ', '1', "Segment Surface Generation Algorithm Identification Sequence", '', 'SegmentSurfaceGenerationAlgorithmIdentificationSequence'),
0x0066002E: ('SQ', '1', "Segment Surface Source Instance Sequence", '', 'SegmentSurfaceSourceInstanceSequence'),
0x0066002F: ('SQ', '1', "Algorithm Family Code Sequence", '', 'AlgorithmFamilyCodeSequence'),
0x00660030: ('SQ', '1', "Algorithm Name Code Sequence", '', 'AlgorithmNameCodeSequence'),
0x00660031: ('LO', '1', "Algorithm Version", '', 'AlgorithmVersion'),
0x00660032: ('LT', '1', "Algorithm Parameters", '', 'AlgorithmParameters'),
0x00660034: ('SQ', '1', "Facet Sequence", '', 'FacetSequence'),
0x00660035: ('SQ', '1', "Surface Processing Algorithm Identification Sequence", '', 'SurfaceProcessingAlgorithmIdentificationSequence'),
0x00660036: ('LO', '1', "Algorithm Name", '', 'AlgorithmName'),
0x00686210: ('LO', '1', "Implant Size", '', 'ImplantSize'),
0x00686221: ('LO', '1', "Implant Template Version", '', 'ImplantTemplateVersion'),
0x00686222: ('SQ', '1', "Replaced Implant Template Sequence", '', 'ReplacedImplantTemplateSequence'),
0x00686223: ('CS', '1', "Implant Type", '', 'ImplantType'),
0x00686224: ('SQ', '1', "Derivation Implant Template Sequence", '', 'DerivationImplantTemplateSequence'),
0x00686225: ('SQ', '1', "Original Implant Template Sequence", '', 'OriginalImplantTemplateSequence'),
0x00686226: ('DT', '1', "Effective DateTime", '', 'EffectiveDateTime'),
0x00686230: ('SQ', '1', "Implant Target Anatomy Sequence", '', 'ImplantTargetAnatomySequence'),
0x00686260: ('SQ', '1', "Information From Manufacturer Sequence", '', 'InformationFromManufacturerSequence'),
0x00686265: ('SQ', '1', "Notification From Manufacturer Sequence", '', 'NotificationFromManufacturerSequence'),
0x00686270: ('DT', '1', "Information Issue DateTime", '', 'InformationIssueDateTime'),
0x00686280: ('ST', '1', "Information Summary", '', 'InformationSummary'),
0x006862A0: ('SQ', '1', "Implant Regulatory Disapproval Code Sequence", '', 'ImplantRegulatoryDisapprovalCodeSequence'),
0x006862A5: ('FD', '1', "Overall Template Spatial Tolerance", '', 'OverallTemplateSpatialTolerance'),
0x006862C0: ('SQ', '1', "HPGL Document Sequence", '', 'HPGLDocumentSequence'),
0x006862D0: ('US', '1', "HPGL Document ID", '', 'HPGLDocumentID'),
0x006862D5: ('LO', '1', "HPGL Document Label", '', 'HPGLDocumentLabel'),
0x006862E0: ('SQ', '1', "View Orientation Code Sequence", '', 'ViewOrientationCodeSequence'),
0x006862F0: ('FD', '9', "View Orientation Modifier", '', 'ViewOrientationModifier'),
0x006862F2: ('FD', '1', "HPGL Document Scaling", '', 'HPGLDocumentScaling'),
0x00686300: ('OB', '1', "HPGL Document", '', 'HPGLDocument'),
0x00686310: ('US', '1', "HPGL Contour Pen Number", '', 'HPGLContourPenNumber'),
0x00686320: ('SQ', '1', "HPGL Pen Sequence", '', 'HPGLPenSequence'),
0x00686330: ('US', '1', "HPGL Pen Number", '', 'HPGLPenNumber'),
0x00686340: ('LO', '1', "HPGL Pen Label", '', 'HPGLPenLabel'),
0x00686345: ('ST', '1', "HPGL Pen Description", '', 'HPGLPenDescription'),
0x00686346: ('FD', '2', "Recommended Rotation Point", '', 'RecommendedRotationPoint'),
0x00686347: ('FD', '4', "Bounding Rectangle", '', 'BoundingRectangle'),
0x00686350: ('US', '1-n', "Implant Template 3D Model Surface Number", '', 'ImplantTemplate3DModelSurfaceNumber'),
0x00686360: ('SQ', '1', "Surface Model Description Sequence", '', 'SurfaceModelDescriptionSequence'),
0x00686380: ('LO', '1', "Surface Model Label", '', 'SurfaceModelLabel'),
0x00686390: ('FD', '1', "Surface Model Scaling Factor", '', 'SurfaceModelScalingFactor'),
0x006863A0: ('SQ', '1', "Materials Code Sequence", '', 'MaterialsCodeSequence'),
0x006863A4: ('SQ', '1', "Coating Materials Code Sequence", '', 'CoatingMaterialsCodeSequence'),
0x006863A8: ('SQ', '1', "Implant Type Code Sequence", '', 'ImplantTypeCodeSequence'),
0x006863AC: ('SQ', '1', "Fixation Method Code Sequence", '', 'FixationMethodCodeSequence'),
0x006863B0: ('SQ', '1', "Mating Feature Sets Sequence", '', 'MatingFeatureSetsSequence'),
0x006863C0: ('US', '1', "Mating Feature Set ID", '', 'MatingFeatureSetID'),
0x006863D0: ('LO', '1', "Mating Feature Set Label", '', 'MatingFeatureSetLabel'),
0x006863E0: ('SQ', '1', "Mating Feature Sequence", '', 'MatingFeatureSequence'),
0x006863F0: ('US', '1', "Mating Feature ID", '', 'MatingFeatureID'),
0x00686400: ('SQ', '1', "Mating Feature Degree of Freedom Sequence", '', 'MatingFeatureDegreeOfFreedomSequence'),
0x00686410: ('US', '1', "Degree of Freedom ID", '', 'DegreeOfFreedomID'),
0x00686420: ('CS', '1', "Degree of Freedom Type", '', 'DegreeOfFreedomType'),
0x00686430: ('SQ', '1', "2D Mating Feature Coordinates Sequence", '', 'TwoDMatingFeatureCoordinatesSequence'),
0x00686440: ('US', '1', "Referenced HPGL Document ID", '', 'ReferencedHPGLDocumentID'),
0x00686450: ('FD', '2', "2D Mating Point", '', 'TwoDMatingPoint'),
0x00686460: ('FD', '4', "2D Mating Axes", '', 'TwoDMatingAxes'),
0x00686470: ('SQ', '1', "2D Degree of Freedom Sequence", '', 'TwoDDegreeOfFreedomSequence'),
0x00686490: ('FD', '3', "3D Degree of Freedom Axis", '', 'ThreeDDegreeOfFreedomAxis'),
0x006864A0: ('FD', '2', "Range of Freedom", '', 'RangeOfFreedom'),
0x006864C0: ('FD', '3', "3D Mating Point", '', 'ThreeDMatingPoint'),
0x006864D0: ('FD', '9', "3D Mating Axes", '', 'ThreeDMatingAxes'),
0x006864F0: ('FD', '3', "2D Degree of Freedom Axis", '', 'TwoDDegreeOfFreedomAxis'),
0x00686500: ('SQ', '1', "Planning Landmark Point Sequence", '', 'PlanningLandmarkPointSequence'),
0x00686510: ('SQ', '1', "Planning Landmark Line Sequence", '', 'PlanningLandmarkLineSequence'),
0x00686520: ('SQ', '1', "Planning Landmark Plane Sequence", '', 'PlanningLandmarkPlaneSequence'),
0x00686530: ('US', '1', "Planning Landmark ID", '', 'PlanningLandmarkID'),
0x00686540: ('LO', '1', "Planning Landmark Description", '', 'PlanningLandmarkDescription'),
0x00686545: ('SQ', '1', "Planning Landmark Identification Code Sequence", '', 'PlanningLandmarkIdentificationCodeSequence'),
0x00686550: ('SQ', '1', "2D Point Coordinates Sequence", '', 'TwoDPointCoordinatesSequence'),
0x00686560: ('FD', '2', "2D Point Coordinates", '', 'TwoDPointCoordinates'),
0x00686590: ('FD', '3', "3D Point Coordinates", '', 'ThreeDPointCoordinates'),
0x006865A0: ('SQ', '1', "2D Line Coordinates Sequence", '', 'TwoDLineCoordinatesSequence'),
0x006865B0: ('FD', '4', "2D Line Coordinates", '', 'TwoDLineCoordinates'),
0x006865D0: ('FD', '6', "3D Line Coordinates", '', 'ThreeDLineCoordinates'),
0x006865E0: ('SQ', '1', "2D Plane Coordinates Sequence", '', 'TwoDPlaneCoordinatesSequence'),
0x006865F0: ('FD', '4', "2D Plane Intersection", '', 'TwoDPlaneIntersection'),
0x00686610: ('FD', '3', "3D Plane Origin", '', 'ThreeDPlaneOrigin'),
0x00686620: ('FD', '3', "3D Plane Normal", '', 'ThreeDPlaneNormal'),
0x00700001: ('SQ', '1', "Graphic Annotation Sequence", '', 'GraphicAnnotationSequence'),
0x00700002: ('CS', '1', "Graphic Layer", '', 'GraphicLayer'),
0x00700003: ('CS', '1', "Bounding Box Annotation Units", '', 'BoundingBoxAnnotationUnits'),
0x00700004: ('CS', '1', "Anchor Point Annotation Units", '', 'AnchorPointAnnotationUnits'),
0x00700005: ('CS', '1', "Graphic Annotation Units", '', 'GraphicAnnotationUnits'),
0x00700006: ('ST', '1', "Unformatted Text Value", '', 'UnformattedTextValue'),
0x00700008: ('SQ', '1', "Text Object Sequence", '', 'TextObjectSequence'),
0x00700009: ('SQ', '1', "Graphic Object Sequence", '', 'GraphicObjectSequence'),
0x00700010: ('FL', '2', "Bounding Box Top Left Hand Corner", '', 'BoundingBoxTopLeftHandCorner'),
0x00700011: ('FL', '2', "Bounding Box Bottom Right Hand Corner", '', 'BoundingBoxBottomRightHandCorner'),
0x00700012: ('CS', '1', "Bounding Box Text Horizontal Justification", '', 'BoundingBoxTextHorizontalJustification'),
0x00700014: ('FL', '2', "Anchor Point", '', 'AnchorPoint'),
0x00700015: ('CS', '1', "Anchor Point Visibility", '', 'AnchorPointVisibility'),
0x00700020: ('US', '1', "Graphic Dimensions", '', 'GraphicDimensions'),
0x00700021: ('US', '1', "Number of Graphic Points", '', 'NumberOfGraphicPoints'),
0x00700022: ('FL', '2-n', "Graphic Data", '', 'GraphicData'),
0x00700023: ('CS', '1', "Graphic Type", '', 'GraphicType'),
0x00700024: ('CS', '1', "Graphic Filled", '', 'GraphicFilled'),
0x00700040: ('IS', '1', "Image Rotation (Retired)", 'Retired', 'ImageRotationRetired'),
0x00700041: ('CS', '1', "Image Horizontal Flip", '', 'ImageHorizontalFlip'),
0x00700042: ('US', '1', "Image Rotation", '', 'ImageRotation'),
0x00700050: ('US', '2', "Displayed Area Top Left Hand Corner (Trial)", 'Retired', 'DisplayedAreaTopLeftHandCornerTrial'),
0x00700051: ('US', '2', "Displayed Area Bottom Right Hand Corner (Trial)", 'Retired', 'DisplayedAreaBottomRightHandCornerTrial'),
0x00700052: ('SL', '2', "Displayed Area Top Left Hand Corner", '', 'DisplayedAreaTopLeftHandCorner'),
0x00700053: ('SL', '2', "Displayed Area Bottom Right Hand Corner", '', 'DisplayedAreaBottomRightHandCorner'),
0x0070005A: ('SQ', '1', "Displayed Area Selection Sequence", '', 'DisplayedAreaSelectionSequence'),
0x00700060: ('SQ', '1', "Graphic Layer Sequence", '', 'GraphicLayerSequence'),
0x00700062: ('IS', '1', "Graphic Layer Order", '', 'GraphicLayerOrder'),
0x00700066: ('US', '1', "Graphic Layer Recommended Display Grayscale Value", '', 'GraphicLayerRecommendedDisplayGrayscaleValue'),
0x00700067: ('US', '3', "Graphic Layer Recommended Display RGB Value", 'Retired', 'GraphicLayerRecommendedDisplayRGBValue'),
0x00700068: ('LO', '1', "Graphic Layer Description", '', 'GraphicLayerDescription'),
0x00700080: ('CS', '1', "Content Label", '', 'ContentLabel'),
0x00700081: ('LO', '1', "Content Description", '', 'ContentDescription'),
0x00700082: ('DA', '1', "Presentation Creation Date", '', 'PresentationCreationDate'),
0x00700083: ('TM', '1', "Presentation Creation Time", '', 'PresentationCreationTime'),
0x00700084: ('PN', '1', "Content Creator's Name", '', 'ContentCreatorName'),
0x00700086: ('SQ', '1', "Content Creator's Identification Code Sequence", '', 'ContentCreatorIdentificationCodeSequence'),
0x00700087: ('SQ', '1', "Alternate Content Description Sequence", '', 'AlternateContentDescriptionSequence'),
0x00700100: ('CS', '1', "Presentation Size Mode", '', 'PresentationSizeMode'),
0x00700101: ('DS', '2', "Presentation Pixel Spacing", '', 'PresentationPixelSpacing'),
0x00700102: ('IS', '2', "Presentation Pixel Aspect Ratio", '', 'PresentationPixelAspectRatio'),
0x00700103: ('FL', '1', "Presentation Pixel Magnification Ratio", '', 'PresentationPixelMagnificationRatio'),
0x00700207: ('LO', '1', "Graphic Group Label", '', 'GraphicGroupLabel'),
0x00700208: ('ST', '1', "Graphic Group Description", '', 'GraphicGroupDescription'),
0x00700209: ('SQ', '1', "Compound Graphic Sequence", '', 'CompoundGraphicSequence'),
0x00700226: ('UL', '1', "Compound Graphic Instance ID", '', 'CompoundGraphicInstanceID'),
0x00700227: ('LO', '1', "Font Name", '', 'FontName'),
0x00700228: ('CS', '1', "Font Name Type", '', 'FontNameType'),
0x00700229: ('LO', '1', "CSS Font Name", '', 'CSSFontName'),
0x00700230: ('FD', '1', "Rotation Angle", '', 'RotationAngle'),
0x00700231: ('SQ', '1', "Text Style Sequence", '', 'TextStyleSequence'),
0x00700232: ('SQ', '1', "Line Style Sequence", '', 'LineStyleSequence'),
0x00700233: ('SQ', '1', "Fill Style Sequence", '', 'FillStyleSequence'),
0x00700234: ('SQ', '1', "Graphic Group Sequence", '', 'GraphicGroupSequence'),
0x00700241: ('US', '3', "Text Color CIELab Value", '', 'TextColorCIELabValue'),
0x00700242: ('CS', '1', "Horizontal Alignment", '', 'HorizontalAlignment'),
0x00700243: ('CS', '1', "Vertical Alignment", '', 'VerticalAlignment'),
0x00700244: ('CS', '1', "Shadow Style", '', 'ShadowStyle'),
0x00700245: ('FL', '1', "Shadow Offset X", '', 'ShadowOffsetX'),
0x00700246: ('FL', '1', "Shadow Offset Y", '', 'ShadowOffsetY'),
0x00700247: ('US', '3', "Shadow Color CIELab Value", '', 'ShadowColorCIELabValue'),
0x00700248: ('CS', '1', "Underlined", '', 'Underlined'),
0x00700249: ('CS', '1', "Bold", '', 'Bold'),
0x00700250: ('CS', '1', "Italic", '', 'Italic'),
0x00700251: ('US', '3', "Pattern On Color CIELab Value", '', 'PatternOnColorCIELabValue'),
0x00700252: ('US', '3', "Pattern Off Color CIELab Value", '', 'PatternOffColorCIELabValue'),
0x00700253: ('FL', '1', "Line Thickness", '', 'LineThickness'),
0x00700254: ('CS', '1', "Line Dashing Style", '', 'LineDashingStyle'),
0x00700255: ('UL', '1', "Line Pattern", '', 'LinePattern'),
0x00700256: ('OB', '1', "Fill Pattern", '', 'FillPattern'),
0x00700257: ('CS', '1', "Fill Mode", '', 'FillMode'),
0x00700258: ('FL', '1', "Shadow Opacity", '', 'ShadowOpacity'),
0x00700261: ('FL', '1', "Gap Length", '', 'GapLength'),
0x00700262: ('FL', '1', "Diameter of Visibility", '', 'DiameterOfVisibility'),
0x00700273: ('FL', '2', "Rotation Point", '', 'RotationPoint'),
0x00700274: ('CS', '1', "Tick Alignment", '', 'TickAlignment'),
0x00700278: ('CS', '1', "Show Tick Label", '', 'ShowTickLabel'),
0x00700279: ('CS', '1', "Tick Label Alignment", '', 'TickLabelAlignment'),
0x00700282: ('CS', '1', "Compound Graphic Units", '', 'CompoundGraphicUnits'),
0x00700284: ('FL', '1', "Pattern On Opacity", '', 'PatternOnOpacity'),
0x00700285: ('FL', '1', "Pattern Off Opacity", '', 'PatternOffOpacity'),
0x00700287: ('SQ', '1', "Major Ticks Sequence", '', 'MajorTicksSequence'),
0x00700288: ('FL', '1', "Tick Position", '', 'TickPosition'),
0x00700289: ('SH', '1', "Tick Label", '', 'TickLabel'),
0x00700294: ('CS', '1', "Compound Graphic Type", '', 'CompoundGraphicType'),
0x00700295: ('UL', '1', "Graphic Group ID", '', 'GraphicGroupID'),
0x00700306: ('CS', '1', "Shape Type", '', 'ShapeType'),
0x00700308: ('SQ', '1', "Registration Sequence", '', 'RegistrationSequence'),
0x00700309: ('SQ', '1', "Matrix Registration Sequence", '', 'MatrixRegistrationSequence'),
0x0070030A: ('SQ', '1', "Matrix Sequence", '', 'MatrixSequence'),
0x0070030C: ('CS', '1', "Frame of Reference Transformation Matrix Type", '', 'FrameOfReferenceTransformationMatrixType'),
0x0070030D: ('SQ', '1', "Registration Type Code Sequence", '', 'RegistrationTypeCodeSequence'),
0x0070030F: ('ST', '1', "Fiducial Description", '', 'FiducialDescription'),
0x00700310: ('SH', '1', "Fiducial Identifier", '', 'FiducialIdentifier'),
0x00700311: ('SQ', '1', "Fiducial Identifier Code Sequence", '', 'FiducialIdentifierCodeSequence'),
0x00700312: ('FD', '1', "Contour Uncertainty Radius", '', 'ContourUncertaintyRadius'),
0x00700314: ('SQ', '1', "Used Fiducials Sequence", '', 'UsedFiducialsSequence'),
0x00700318: ('SQ', '1', "Graphic Coordinates Data Sequence", '', 'GraphicCoordinatesDataSequence'),
0x0070031A: ('UI', '1', "Fiducial UID", '', 'FiducialUID'),
0x0070031C: ('SQ', '1', "Fiducial Set Sequence", '', 'FiducialSetSequence'),
0x0070031E: ('SQ', '1', "Fiducial Sequence", '', 'FiducialSequence'),
0x00700401: ('US', '3', "Graphic Layer Recommended Display CIELab Value", '', 'GraphicLayerRecommendedDisplayCIELabValue'),
0x00700402: ('SQ', '1', "Blending Sequence", '', 'BlendingSequence'),
0x00700403: ('FL', '1', "Relative Opacity", '', 'RelativeOpacity'),
0x00700404: ('SQ', '1', "Referenced Spatial Registration Sequence", '', 'ReferencedSpatialRegistrationSequence'),
0x00700405: ('CS', '1', "Blending Position", '', 'BlendingPosition'),
0x00720002: ('SH', '1', "Hanging Protocol Name", '', 'HangingProtocolName'),
0x00720004: ('LO', '1', "Hanging Protocol Description", '', 'HangingProtocolDescription'),
0x00720006: ('CS', '1', "Hanging Protocol Level", '', 'HangingProtocolLevel'),
0x00720008: ('LO', '1', "Hanging Protocol Creator", '', 'HangingProtocolCreator'),
0x0072000A: ('DT', '1', "Hanging Protocol Creation DateTime", '', 'HangingProtocolCreationDateTime'),
0x0072000C: ('SQ', '1', "Hanging Protocol Definition Sequence", '', 'HangingProtocolDefinitionSequence'),
0x0072000E: ('SQ', '1', "Hanging Protocol User Identification Code Sequence", '', 'HangingProtocolUserIdentificationCodeSequence'),
0x00720010: ('LO', '1', "Hanging Protocol User Group Name", '', 'HangingProtocolUserGroupName'),
0x00720012: ('SQ', '1', "Source Hanging Protocol Sequence", '', 'SourceHangingProtocolSequence'),
0x00720014: ('US', '1', "Number of Priors Referenced", '', 'NumberOfPriorsReferenced'),
0x00720020: ('SQ', '1', "Image Sets Sequence", '', 'ImageSetsSequence'),
0x00720022: ('SQ', '1', "Image Set Selector Sequence", '', 'ImageSetSelectorSequence'),
0x00720024: ('CS', '1', "Image Set Selector Usage Flag", '', 'ImageSetSelectorUsageFlag'),
0x00720026: ('AT', '1', "Selector Attribute", '', 'SelectorAttribute'),
0x00720028: ('US', '1', "Selector Value Number", '', 'SelectorValueNumber'),
0x00720030: ('SQ', '1', "Time Based Image Sets Sequence", '', 'TimeBasedImageSetsSequence'),
0x00720032: ('US', '1', "Image Set Number", '', 'ImageSetNumber'),
0x00720034: ('CS', '1', "Image Set Selector Category", '', 'ImageSetSelectorCategory'),
0x00720038: ('US', '2', "Relative Time", '', 'RelativeTime'),
0x0072003A: ('CS', '1', "Relative Time Units", '', 'RelativeTimeUnits'),
0x0072003C: ('SS', '2', "Abstract Prior Value", '', 'AbstractPriorValue'),
0x0072003E: ('SQ', '1', "Abstract Prior Code Sequence", '', 'AbstractPriorCodeSequence'),
0x00720040: ('LO', '1', "Image Set Label", '', 'ImageSetLabel'),
0x00720050: ('CS', '1', "Selector Attribute VR", '', 'SelectorAttributeVR'),
0x00720052: ('AT', '1-n', "Selector Sequence Pointer", '', 'SelectorSequencePointer'),
0x00720054: ('LO', '1-n', "Selector Sequence Pointer Private Creator", '', 'SelectorSequencePointerPrivateCreator'),
0x00720056: ('LO', '1', "Selector Attribute Private Creator", '', 'SelectorAttributePrivateCreator'),
0x00720060: ('AT', '1-n', "Selector AT Value", '', 'SelectorATValue'),
0x00720062: ('CS', '1-n', "Selector CS Value", '', 'SelectorCSValue'),
0x00720064: ('IS', '1-n', "Selector IS Value", '', 'SelectorISValue'),
0x00720066: ('LO', '1-n', "Selector LO Value", '', 'SelectorLOValue'),
0x00720068: ('LT', '1', "Selector LT Value", '', 'SelectorLTValue'),
0x0072006A: ('PN', '1-n', "Selector PN Value", '', 'SelectorPNValue'),
0x0072006C: ('SH', '1-n', "Selector SH Value", '', 'SelectorSHValue'),
0x0072006E: ('ST', '1', "Selector ST Value", '', 'SelectorSTValue'),
0x00720070: ('UT', '1', "Selector UT Value", '', 'SelectorUTValue'),
0x00720072: ('DS', '1-n', "Selector DS Value", '', 'SelectorDSValue'),
0x00720074: ('FD', '1-n', "Selector FD Value", '', 'SelectorFDValue'),
0x00720076: ('FL', '1-n', "Selector FL Value", '', 'SelectorFLValue'),
0x00720078: ('UL', '1-n', "Selector UL Value", '', 'SelectorULValue'),
0x0072007A: ('US', '1-n', "Selector US Value", '', 'SelectorUSValue'),
0x0072007C: ('SL', '1-n', "Selector SL Value", '', 'SelectorSLValue'),
0x0072007E: ('SS', '1-n', "Selector SS Value", '', 'SelectorSSValue'),
0x00720080: ('SQ', '1', "Selector Code Sequence Value", '', 'SelectorCodeSequenceValue'),
0x00720100: ('US', '1', "Number of Screens", '', 'NumberOfScreens'),
0x00720102: ('SQ', '1', "Nominal Screen Definition Sequence", '', 'NominalScreenDefinitionSequence'),
0x00720104: ('US', '1', "Number of Vertical Pixels", '', 'NumberOfVerticalPixels'),
0x00720106: ('US', '1', "Number of Horizontal Pixels", '', 'NumberOfHorizontalPixels'),
0x00720108: ('FD', '4', "Display Environment Spatial Position", '', 'DisplayEnvironmentSpatialPosition'),
0x0072010A: ('US', '1', "Screen Minimum Grayscale Bit Depth", '', 'ScreenMinimumGrayscaleBitDepth'),
0x0072010C: ('US', '1', "Screen Minimum Color Bit Depth", '', 'ScreenMinimumColorBitDepth'),
0x0072010E: ('US', '1', "Application Maximum Repaint Time", '', 'ApplicationMaximumRepaintTime'),
0x00720200: ('SQ', '1', "Display Sets Sequence", '', 'DisplaySetsSequence'),
0x00720202: ('US', '1', "Display Set Number", '', 'DisplaySetNumber'),
0x00720203: ('LO', '1', "Display Set Label", '', 'DisplaySetLabel'),
0x00720204: ('US', '1', "Display Set Presentation Group", '', 'DisplaySetPresentationGroup'),
0x00720206: ('LO', '1', "Display Set Presentation Group Description", '', 'DisplaySetPresentationGroupDescription'),
0x00720208: ('CS', '1', "Partial Data Display Handling", '', 'PartialDataDisplayHandling'),
0x00720210: ('SQ', '1', "Synchronized Scrolling Sequence", '', 'SynchronizedScrollingSequence'),
0x00720212: ('US', '2-n', "Display Set Scrolling Group", '', 'DisplaySetScrollingGroup'),
0x00720214: ('SQ', '1', "Navigation Indicator Sequence", '', 'NavigationIndicatorSequence'),
0x00720216: ('US', '1', "Navigation Display Set", '', 'NavigationDisplaySet'),
0x00720218: ('US', '1-n', "Reference Display Sets", '', 'ReferenceDisplaySets'),
0x00720300: ('SQ', '1', "Image Boxes Sequence", '', 'ImageBoxesSequence'),
0x00720302: ('US', '1', "Image Box Number", '', 'ImageBoxNumber'),
0x00720304: ('CS', '1', "Image Box Layout Type", '', 'ImageBoxLayoutType'),
0x00720306: ('US', '1', "Image Box Tile Horizontal Dimension", '', 'ImageBoxTileHorizontalDimension'),
0x00720308: ('US', '1', "Image Box Tile Vertical Dimension", '', 'ImageBoxTileVerticalDimension'),
0x00720310: ('CS', '1', "Image Box Scroll Direction", '', 'ImageBoxScrollDirection'),
0x00720312: ('CS', '1', "Image Box Small Scroll Type", '', 'ImageBoxSmallScrollType'),
0x00720314: ('US', '1', "Image Box Small Scroll Amount", '', 'ImageBoxSmallScrollAmount'),
0x00720316: ('CS', '1', "Image Box Large Scroll Type", '', 'ImageBoxLargeScrollType'),
0x00720318: ('US', '1', "Image Box Large Scroll Amount", '', 'ImageBoxLargeScrollAmount'),
0x00720320: ('US', '1', "Image Box Overlap Priority", '', 'ImageBoxOverlapPriority'),
0x00720330: ('FD', '1', "Cine Relative to Real-Time", '', 'CineRelativeToRealTime'),
0x00720400: ('SQ', '1', "Filter Operations Sequence", '', 'FilterOperationsSequence'),
0x00720402: ('CS', '1', "Filter-by Category", '', 'FilterByCategory'),
0x00720404: ('CS', '1', "Filter-by Attribute Presence", '', 'FilterByAttributePresence'),
0x00720406: ('CS', '1', "Filter-by Operator", '', 'FilterByOperator'),
0x00720420: ('US', '3', "Structured Display Background CIELab Value", '', 'StructuredDisplayBackgroundCIELabValue'),
0x00720421: ('US', '3', "Empty Image Box CIELab Value", '', 'EmptyImageBoxCIELabValue'),
0x00720422: ('SQ', '1', "Structured Display Image Box Sequence", '', 'StructuredDisplayImageBoxSequence'),
0x00720424: ('SQ', '1', "Structured Display Text Box Sequence", '', 'StructuredDisplayTextBoxSequence'),
0x00720427: ('SQ', '1', "Referenced First Frame Sequence", '', 'ReferencedFirstFrameSequence'),
0x00720430: ('SQ', '1', "Image Box Synchronization Sequence", '', 'ImageBoxSynchronizationSequence'),
0x00720432: ('US', '2-n', "Synchronized Image Box List", '', 'SynchronizedImageBoxList'),
0x00720434: ('CS', '1', "Type of Synchronization", '', 'TypeOfSynchronization'),
0x00720500: ('CS', '1', "Blending Operation Type", '', 'BlendingOperationType'),
0x00720510: ('CS', '1', "Reformatting Operation Type", '', 'ReformattingOperationType'),
0x00720512: ('FD', '1', "Reformatting Thickness", '', 'ReformattingThickness'),
0x00720514: ('FD', '1', "Reformatting Interval", '', 'ReformattingInterval'),
0x00720516: ('CS', '1', "Reformatting Operation Initial View Direction", '', 'ReformattingOperationInitialViewDirection'),
0x00720520: ('CS', '1-n', "3D Rendering Type", '', 'ThreeDRenderingType'),
0x00720600: ('SQ', '1', "Sorting Operations Sequence", '', 'SortingOperationsSequence'),
0x00720602: ('CS', '1', "Sort-by Category", '', 'SortByCategory'),
0x00720604: ('CS', '1', "Sorting Direction", '', 'SortingDirection'),
0x00720700: ('CS', '2', "Display Set Patient Orientation", '', 'DisplaySetPatientOrientation'),
0x00720702: ('CS', '1', "VOI Type", '', 'VOIType'),
0x00720704: ('CS', '1', "Pseudo-Color Type", '', 'PseudoColorType'),
0x00720705: ('SQ', '1', "Pseudo-Color Palette Instance Reference Sequence", '', 'PseudoColorPaletteInstanceReferenceSequence'),
0x00720706: ('CS', '1', "Show Grayscale Inverted", '', 'ShowGrayscaleInverted'),
0x00720710: ('CS', '1', "Show Image True Size Flag", '', 'ShowImageTrueSizeFlag'),
0x00720712: ('CS', '1', "Show Graphic Annotation Flag", '', 'ShowGraphicAnnotationFlag'),
0x00720714: ('CS', '1', "Show Patient Demographics Flag", '', 'ShowPatientDemographicsFlag'),
0x00720716: ('CS', '1', "Show Acquisition Techniques Flag", '', 'ShowAcquisitionTechniquesFlag'),
0x00720717: ('CS', '1', "Display Set Horizontal Justification", '', 'DisplaySetHorizontalJustification'),
0x00720718: ('CS', '1', "Display Set Vertical Justification", '', 'DisplaySetVerticalJustification'),
0x00740120: ('FD', '1', "Continuation Start Meterset", '', 'ContinuationStartMeterset'),
0x00740121: ('FD', '1', "Continuation End Meterset", '', 'ContinuationEndMeterset'),
0x00741000: ('CS', '1', "Procedure Step State", '', 'ProcedureStepState'),
0x00741002: ('SQ', '1', "Procedure Step Progress Information Sequence", '', 'ProcedureStepProgressInformationSequence'),
0x00741004: ('DS', '1', "Procedure Step Progress", '', 'ProcedureStepProgress'),
0x00741006: ('ST', '1', "Procedure Step Progress Description", '', 'ProcedureStepProgressDescription'),
0x00741008: ('SQ', '1', "Procedure Step Communications URI Sequence", '', 'ProcedureStepCommunicationsURISequence'),
0x0074100a: ('ST', '1', "Contact URI", '', 'ContactURI'),
0x0074100c: ('LO', '1', "Contact Display Name", '', 'ContactDisplayName'),
0x0074100e: ('SQ', '1', "Procedure Step Discontinuation Reason Code Sequence", '', 'ProcedureStepDiscontinuationReasonCodeSequence'),
0x00741020: ('SQ', '1', "Beam Task Sequence", '', 'BeamTaskSequence'),
0x00741022: ('CS', '1', "Beam Task Type", '', 'BeamTaskType'),
0x00741024: ('IS', '1', "Beam Order Index (Trial)", 'Retired', 'BeamOrderIndexTrial'),
0x00741026: ('FD', '1', "Table Top Vertical Adjusted Position", '', 'TableTopVerticalAdjustedPosition'),
0x00741027: ('FD', '1', "Table Top Longitudinal Adjusted Position", '', 'TableTopLongitudinalAdjustedPosition'),
0x00741028: ('FD', '1', "Table Top Lateral Adjusted Position", '', 'TableTopLateralAdjustedPosition'),
0x0074102A: ('FD', '1', "Patient Support Adjusted Angle", '', 'PatientSupportAdjustedAngle'),
0x0074102B: ('FD', '1', "Table Top Eccentric Adjusted Angle", '', 'TableTopEccentricAdjustedAngle'),
0x0074102C: ('FD', '1', "Table Top Pitch Adjusted Angle", '', 'TableTopPitchAdjustedAngle'),
0x0074102D: ('FD', '1', "Table Top Roll Adjusted Angle", '', 'TableTopRollAdjustedAngle'),
0x00741030: ('SQ', '1', "Delivery Verification Image Sequence", '', 'DeliveryVerificationImageSequence'),
0x00741032: ('CS', '1', "Verification Image Timing", '', 'VerificationImageTiming'),
0x00741034: ('CS', '1', "Double Exposure Flag", '', 'DoubleExposureFlag'),
0x00741036: ('CS', '1', "Double Exposure Ordering", '', 'DoubleExposureOrdering'),
0x00741038: ('DS', '1', "Double Exposure Meterset (Trial)", 'Retired', 'DoubleExposureMetersetTrial'),
0x0074103A: ('DS', '4', "Double Exposure Field Delta (Trial)", 'Retired', 'DoubleExposureFieldDeltaTrial'),
0x00741040: ('SQ', '1', "Related Reference RT Image Sequence", '', 'RelatedReferenceRTImageSequence'),
0x00741042: ('SQ', '1', "General Machine Verification Sequence", '', 'GeneralMachineVerificationSequence'),
0x00741044: ('SQ', '1', "Conventional Machine Verification Sequence", '', 'ConventionalMachineVerificationSequence'),
0x00741046: ('SQ', '1', "Ion Machine Verification Sequence", '', 'IonMachineVerificationSequence'),
0x00741048: ('SQ', '1', "Failed Attributes Sequence", '', 'FailedAttributesSequence'),
0x0074104A: ('SQ', '1', "Overridden Attributes Sequence", '', 'OverriddenAttributesSequence'),
0x0074104C: ('SQ', '1', "Conventional Control Point Verification Sequence", '', 'ConventionalControlPointVerificationSequence'),
0x0074104E: ('SQ', '1', "Ion Control Point Verification Sequence", '', 'IonControlPointVerificationSequence'),
0x00741050: ('SQ', '1', "Attribute Occurrence Sequence", '', 'AttributeOccurrenceSequence'),
0x00741052: ('AT', '1', "Attribute Occurrence Pointer", '', 'AttributeOccurrencePointer'),
0x00741054: ('UL', '1', "Attribute Item Selector", '', 'AttributeItemSelector'),
0x00741056: ('LO', '1', "Attribute Occurrence Private Creator", '', 'AttributeOccurrencePrivateCreator'),
0x00741057: ('IS', '1-n', "Selector Sequence Pointer Items", '', 'SelectorSequencePointerItems'),
0x00741200: ('CS', '1', "Scheduled Procedure Step Priority", '', 'ScheduledProcedureStepPriority'),
0x00741202: ('LO', '1', "Worklist Label", '', 'WorklistLabel'),
0x00741204: ('LO', '1', "Procedure Step Label", '', 'ProcedureStepLabel'),
0x00741210: ('SQ', '1', "Scheduled Processing Parameters Sequence", '', 'ScheduledProcessingParametersSequence'),
0x00741212: ('SQ', '1', "Performed Processing Parameters Sequence", '', 'PerformedProcessingParametersSequence'),
0x00741216: ('SQ', '1', "Unified Procedure Step Performed Procedure Sequence", '', 'UnifiedProcedureStepPerformedProcedureSequence'),
0x00741220: ('SQ', '1', "Related Procedure Step Sequence", 'Retired', 'RelatedProcedureStepSequence'),
0x00741222: ('LO', '1', "Procedure Step Relationship Type", 'Retired', 'ProcedureStepRelationshipType'),
0x00741224: ('SQ', '1', "Replaced Procedure Step Sequence", '', 'ReplacedProcedureStepSequence'),
0x00741230: ('LO', '1', "Deletion Lock", '', 'DeletionLock'),
0x00741234: ('AE', '1', "Receiving AE", '', 'ReceivingAE'),
0x00741236: ('AE', '1', "Requesting AE", '', 'RequestingAE'),
0x00741238: ('LT', '1', "Reason for Cancellation", '', 'ReasonForCancellation'),
0x00741242: ('CS', '1', "SCP Status", '', 'SCPStatus'),
0x00741244: ('CS', '1', "Subscription List Status", '', 'SubscriptionListStatus'),
0x00741246: ('CS', '1', "Unified Procedure Step List Status", '', 'UnifiedProcedureStepListStatus'),
0x00741324: ('UL', '1', "Beam Order Index", '', 'BeamOrderIndex'),
0x00741338: ('FD', '1', "Double Exposure Meterset", '', 'DoubleExposureMeterset'),
0x0074133A: ('FD', '4', "Double Exposure Field Delta", '', 'DoubleExposureFieldDelta'),
0x00760001: ('LO', '1', "Implant Assembly Template Name", '', 'ImplantAssemblyTemplateName'),
0x00760003: ('LO', '1', "Implant Assembly Template Issuer", '', 'ImplantAssemblyTemplateIssuer'),
0x00760006: ('LO', '1', "Implant Assembly Template Version", '', 'ImplantAssemblyTemplateVersion'),
0x00760008: ('SQ', '1', "Replaced Implant Assembly Template Sequence", '', 'ReplacedImplantAssemblyTemplateSequence'),
0x0076000A: ('CS', '1', "Implant Assembly Template Type", '', 'ImplantAssemblyTemplateType'),
0x0076000C: ('SQ', '1', "Original Implant Assembly Template Sequence", '', 'OriginalImplantAssemblyTemplateSequence'),
0x0076000E: ('SQ', '1', "Derivation Implant Assembly Template Sequence", '', 'DerivationImplantAssemblyTemplateSequence'),
0x00760010: ('SQ', '1', "Implant Assembly Template Target Anatomy Sequence", '', 'ImplantAssemblyTemplateTargetAnatomySequence'),
0x00760020: ('SQ', '1', "Procedure Type Code Sequence", '', 'ProcedureTypeCodeSequence'),
0x00760030: ('LO', '1', "Surgical Technique", '', 'SurgicalTechnique'),
0x00760032: ('SQ', '1', "Component Types Sequence", '', 'ComponentTypesSequence'),
0x00760034: ('CS', '1', "Component Type Code Sequence", '', 'ComponentTypeCodeSequence'),
0x00760036: ('CS', '1', "Exclusive Component Type", '', 'ExclusiveComponentType'),
0x00760038: ('CS', '1', "Mandatory Component Type", '', 'MandatoryComponentType'),
0x00760040: ('SQ', '1', "Component Sequence", '', 'ComponentSequence'),
0x00760055: ('US', '1', "Component ID", '', 'ComponentID'),
0x00760060: ('SQ', '1', "Component Assembly Sequence", '', 'ComponentAssemblySequence'),
0x00760070: ('US', '1', "Component 1 Referenced ID", '', 'Component1ReferencedID'),
0x00760080: ('US', '1', "Component 1 Referenced Mating Feature Set ID", '', 'Component1ReferencedMatingFeatureSetID'),
0x00760090: ('US', '1', "Component 1 Referenced Mating Feature ID", '', 'Component1ReferencedMatingFeatureID'),
0x007600A0: ('US', '1', "Component 2 Referenced ID", '', 'Component2ReferencedID'),
0x007600B0: ('US', '1', "Component 2 Referenced Mating Feature Set ID", '', 'Component2ReferencedMatingFeatureSetID'),
0x007600C0: ('US', '1', "Component 2 Referenced Mating Feature ID", '', 'Component2ReferencedMatingFeatureID'),
0x00780001: ('LO', '1', "Implant Template Group Name", '', 'ImplantTemplateGroupName'),
0x00780010: ('ST', '1', "Implant Template Group Description", '', 'ImplantTemplateGroupDescription'),
0x00780020: ('LO', '1', "Implant Template Group Issuer", '', 'ImplantTemplateGroupIssuer'),
0x00780024: ('LO', '1', "Implant Template Group Version", '', 'ImplantTemplateGroupVersion'),
0x00780026: ('SQ', '1', "Replaced Implant Template Group Sequence", '', 'ReplacedImplantTemplateGroupSequence'),
0x00780028: ('SQ', '1', "Implant Template Group Target Anatomy Sequence", '', 'ImplantTemplateGroupTargetAnatomySequence'),
0x0078002A: ('SQ', '1', "Implant Template Group Members Sequence", '', 'ImplantTemplateGroupMembersSequence'),
0x0078002E: ('US', '1', "Implant Template Group Member ID", '', 'ImplantTemplateGroupMemberID'),
0x00780050: ('FD', '3', "3D Implant Template Group Member Matching Point", '', 'ThreeDImplantTemplateGroupMemberMatchingPoint'),
0x00780060: ('FD', '9', "3D Implant Template Group Member Matching Axes", '', 'ThreeDImplantTemplateGroupMemberMatchingAxes'),
0x00780070: ('SQ', '1', "Implant Template Group Member Matching 2D Coordinates Sequence", '', 'ImplantTemplateGroupMemberMatching2DCoordinatesSequence'),
0x00780090: ('FD', '2', "2D Implant Template Group Member Matching Point", '', 'TwoDImplantTemplateGroupMemberMatchingPoint'),
0x007800A0: ('FD', '4', "2D Implant Template Group Member Matching Axes", '', 'TwoDImplantTemplateGroupMemberMatchingAxes'),
0x007800B0: ('SQ', '1', "Implant Template Group Variation Dimension Sequence", '', 'ImplantTemplateGroupVariationDimensionSequence'),
0x007800B2: ('LO', '1', "Implant Template Group Variation Dimension Name", '', 'ImplantTemplateGroupVariationDimensionName'),
0x007800B4: ('SQ', '1', "Implant Template Group Variation Dimension Rank Sequence", '', 'ImplantTemplateGroupVariationDimensionRankSequence'),
0x007800B6: ('US', '1', "Referenced Implant Template Group Member ID", '', 'ReferencedImplantTemplateGroupMemberID'),
0x007800B8: ('US', '1', "Implant Template Group Variation Dimension Rank", '', 'ImplantTemplateGroupVariationDimensionRank'),
0x00880130: ('SH', '1', "Storage Media File-set ID", '', 'StorageMediaFileSetID'),
0x00880140: ('UI', '1', "Storage Media File-set UID", '', 'StorageMediaFileSetUID'),
0x00880200: ('SQ', '1', "Icon Image Sequence", '', 'IconImageSequence'),
0x00880904: ('LO', '1', "Topic Title", 'Retired', 'TopicTitle'),
0x00880906: ('ST', '1', "Topic Subject", 'Retired', 'TopicSubject'),
0x00880910: ('LO', '1', "Topic Author", 'Retired', 'TopicAuthor'),
0x00880912: ('LO', '1-32', "Topic Keywords", 'Retired', 'TopicKeywords'),
0x01000410: ('CS', '1', "SOP Instance Status", '', 'SOPInstanceStatus'),
0x01000420: ('DT', '1', "SOP Authorization DateTime", '', 'SOPAuthorizationDateTime'),
0x01000424: ('LT', '1', "SOP Authorization Comment", '', 'SOPAuthorizationComment'),
0x01000426: ('LO', '1', "Authorization Equipment Certification Number", '', 'AuthorizationEquipmentCertificationNumber'),
0x04000005: ('US', '1', "MAC ID Number", '', 'MACIDNumber'),
0x04000010: ('UI', '1', "MAC Calculation Transfer Syntax UID", '', 'MACCalculationTransferSyntaxUID'),
0x04000015: ('CS', '1', "MAC Algorithm", '', 'MACAlgorithm'),
0x04000020: ('AT', '1-n', "Data Elements Signed", '', 'DataElementsSigned'),
0x04000100: ('UI', '1', "Digital Signature UID", '', 'DigitalSignatureUID'),
0x04000105: ('DT', '1', "Digital Signature DateTime", '', 'DigitalSignatureDateTime'),
0x04000110: ('CS', '1', "Certificate Type", '', 'CertificateType'),
0x04000115: ('OB', '1', "Certificate of Signer", '', 'CertificateOfSigner'),
0x04000120: ('OB', '1', "Signature", '', 'Signature'),
0x04000305: ('CS', '1', "Certified Timestamp Type", '', 'CertifiedTimestampType'),
0x04000310: ('OB', '1', "Certified Timestamp", '', 'CertifiedTimestamp'),
0x04000401: ('SQ', '1', "Digital Signature Purpose Code Sequence", '', 'DigitalSignaturePurposeCodeSequence'),
0x04000402: ('SQ', '1', "Referenced Digital Signature Sequence", '', 'ReferencedDigitalSignatureSequence'),
0x04000403: ('SQ', '1', "Referenced SOP Instance MAC Sequence", '', 'ReferencedSOPInstanceMACSequence'),
0x04000404: ('OB', '1', "MAC", '', 'MAC'),
0x04000500: ('SQ', '1', "Encrypted Attributes Sequence", '', 'EncryptedAttributesSequence'),
0x04000510: ('UI', '1', "Encrypted Content Transfer Syntax UID", '', 'EncryptedContentTransferSyntaxUID'),
0x04000520: ('OB', '1', "Encrypted Content", '', 'EncryptedContent'),
0x04000550: ('SQ', '1', "Modified Attributes Sequence", '', 'ModifiedAttributesSequence'),
0x04000561: ('SQ', '1', "Original Attributes Sequence", '', 'OriginalAttributesSequence'),
0x04000562: ('DT', '1', "Attribute Modification DateTime", '', 'AttributeModificationDateTime'),
0x04000563: ('LO', '1', "Modifying System", '', 'ModifyingSystem'),
0x04000564: ('LO', '1', "Source of Previous Values", '', 'SourceOfPreviousValues'),
0x04000565: ('CS', '1', "Reason for the Attribute Modification", '', 'ReasonForTheAttributeModification'),
0x20000010: ('IS', '1', "Number of Copies", '', 'NumberOfCopies'),
0x2000001E: ('SQ', '1', "Printer Configuration Sequence", '', 'PrinterConfigurationSequence'),
0x20000020: ('CS', '1', "Print Priority", '', 'PrintPriority'),
0x20000030: ('CS', '1', "Medium Type", '', 'MediumType'),
0x20000040: ('CS', '1', "Film Destination", '', 'FilmDestination'),
0x20000050: ('LO', '1', "Film Session Label", '', 'FilmSessionLabel'),
0x20000060: ('IS', '1', "Memory Allocation", '', 'MemoryAllocation'),
0x20000061: ('IS', '1', "Maximum Memory Allocation", '', 'MaximumMemoryAllocation'),
0x20000062: ('CS', '1', "Color Image Printing Flag", 'Retired', 'ColorImagePrintingFlag'),
0x20000063: ('CS', '1', "Collation Flag", 'Retired', 'CollationFlag'),
0x20000065: ('CS', '1', "Annotation Flag", 'Retired', 'AnnotationFlag'),
0x20000067: ('CS', '1', "Image Overlay Flag", 'Retired', 'ImageOverlayFlag'),
0x20000069: ('CS', '1', "Presentation LUT Flag", 'Retired', 'PresentationLUTFlag'),
0x2000006A: ('CS', '1', "Image Box Presentation LUT Flag", 'Retired', 'ImageBoxPresentationLUTFlag'),
0x200000A0: ('US', '1', "Memory Bit Depth", '', 'MemoryBitDepth'),
0x200000A1: ('US', '1', "Printing Bit Depth", '', 'PrintingBitDepth'),
0x200000A2: ('SQ', '1', "Media Installed Sequence", '', 'MediaInstalledSequence'),
0x200000A4: ('SQ', '1', "Other Media Available Sequence", '', 'OtherMediaAvailableSequence'),
0x200000A8: ('SQ', '1', "Supported Image Display Formats Sequence", '', 'SupportedImageDisplayFormatsSequence'),
0x20000500: ('SQ', '1', "Referenced Film Box Sequence", '', 'ReferencedFilmBoxSequence'),
0x20000510: ('SQ', '1', "Referenced Stored Print  Sequence", 'Retired', 'ReferencedStoredPrintSequence'),
0x20100010: ('ST', '1', "Image Display Format", '', 'ImageDisplayFormat'),
0x20100030: ('CS', '1', "Annotation Display Format ID", '', 'AnnotationDisplayFormatID'),
0x20100040: ('CS', '1', "Film Orientation", '', 'FilmOrientation'),
0x20100050: ('CS', '1', "Film Size ID", '', 'FilmSizeID'),
0x20100052: ('CS', '1', "Printer Resolution ID", '', 'PrinterResolutionID'),
0x20100054: ('CS', '1', "Default Printer Resolution ID", '', 'DefaultPrinterResolutionID'),
0x20100060: ('CS', '1', "Magnification Type", '', 'MagnificationType'),
0x20100080: ('CS', '1', "Smoothing Type", '', 'SmoothingType'),
0x201000A6: ('CS', '1', "Default Magnification Type", '', 'DefaultMagnificationType'),
0x201000A7: ('CS', '1-n', "Other Magnification Types Available", '', 'OtherMagnificationTypesAvailable'),
0x201000A8: ('CS', '1', "Default Smoothing Type", '', 'DefaultSmoothingType'),
0x201000A9: ('CS', '1-n', "Other Smoothing Types Available", '', 'OtherSmoothingTypesAvailable'),
0x20100100: ('CS', '1', "Border Density", '', 'BorderDensity'),
0x20100110: ('CS', '1', "Empty Image Density", '', 'EmptyImageDensity'),
0x20100120: ('US', '1', "Min Density", '', 'MinDensity'),
0x20100130: ('US', '1', "Max Density", '', 'MaxDensity'),
0x20100140: ('CS', '1', "Trim", '', 'Trim'),
0x20100150: ('ST', '1', "Configuration Information", '', 'ConfigurationInformation'),
0x20100152: ('LT', '1', "Configuration Information Description", '', 'ConfigurationInformationDescription'),
0x20100154: ('IS', '1', "Maximum Collated Films", '', 'MaximumCollatedFilms'),
0x2010015E: ('US', '1', "Illumination", '', 'Illumination'),
0x20100160: ('US', '1', "Reflected Ambient Light", '', 'ReflectedAmbientLight'),
0x20100376: ('DS', '2', "Printer Pixel Spacing", '', 'PrinterPixelSpacing'),
0x20100500: ('SQ', '1', "Referenced Film Session Sequence", '', 'ReferencedFilmSessionSequence'),
0x20100510: ('SQ', '1', "Referenced Image Box Sequence", '', 'ReferencedImageBoxSequence'),
0x20100520: ('SQ', '1', "Referenced Basic Annotation Box Sequence", '', 'ReferencedBasicAnnotationBoxSequence'),
0x20200010: ('US', '1', "Image Box Position", '', 'ImageBoxPosition'),
0x20200020: ('CS', '1', "Polarity", '', 'Polarity'),
0x20200030: ('DS', '1', "Requested Image Size", '', 'RequestedImageSize'),
0x20200040: ('CS', '1', "Requested Decimate/Crop Behavior", '', 'RequestedDecimateCropBehavior'),
0x20200050: ('CS', '1', "Requested Resolution ID", '', 'RequestedResolutionID'),
0x202000A0: ('CS', '1', "Requested Image Size Flag", '', 'RequestedImageSizeFlag'),
0x202000A2: ('CS', '1', "Decimate/Crop Result", '', 'DecimateCropResult'),
0x20200110: ('SQ', '1', "Basic Grayscale Image Sequence", '', 'BasicGrayscaleImageSequence'),
0x20200111: ('SQ', '1', "Basic Color Image Sequence", '', 'BasicColorImageSequence'),
0x20200130: ('SQ', '1', "Referenced Image Overlay Box Sequence", 'Retired', 'ReferencedImageOverlayBoxSequence'),
0x20200140: ('SQ', '1', "Referenced VOI LUT Box Sequence", 'Retired', 'ReferencedVOILUTBoxSequence'),
0x20300010: ('US', '1', "Annotation Position", '', 'AnnotationPosition'),
0x20300020: ('LO', '1', "Text String", '', 'TextString'),
0x20400010: ('SQ', '1', "Referenced Overlay Plane Sequence", 'Retired', 'ReferencedOverlayPlaneSequence'),
0x20400011: ('US', '1-99', "Referenced Overlay Plane Groups", 'Retired', 'ReferencedOverlayPlaneGroups'),
0x20400020: ('SQ', '1', "Overlay Pixel Data Sequence", 'Retired', 'OverlayPixelDataSequence'),
0x20400060: ('CS', '1', "Overlay Magnification Type", 'Retired', 'OverlayMagnificationType'),
0x20400070: ('CS', '1', "Overlay Smoothing Type", 'Retired', 'OverlaySmoothingType'),
0x20400072: ('CS', '1', "Overlay or Image Magnification", 'Retired', 'OverlayOrImageMagnification'),
0x20400074: ('US', '1', "Magnify to Number of Columns", 'Retired', 'MagnifyToNumberOfColumns'),
0x20400080: ('CS', '1', "Overlay Foreground Density", 'Retired', 'OverlayForegroundDensity'),
0x20400082: ('CS', '1', "Overlay Background Density", 'Retired', 'OverlayBackgroundDensity'),
0x20400090: ('CS', '1', "Overlay Mode", 'Retired', 'OverlayMode'),
0x20400100: ('CS', '1', "Threshold Density", 'Retired', 'ThresholdDensity'),
0x20400500: ('SQ', '1', "Referenced Image Box Sequence (Retired)", 'Retired', 'ReferencedImageBoxSequenceRetired'),
0x20500010: ('SQ', '1', "Presentation LUT Sequence", '', 'PresentationLUTSequence'),
0x20500020: ('CS', '1', "Presentation LUT Shape", '', 'PresentationLUTShape'),
0x20500500: ('SQ', '1', "Referenced Presentation  LUT Sequence", '', 'ReferencedPresentationLUTSequence'),
0x21000010: ('SH', '1', "Print Job ID", 'Retired', 'PrintJobID'),
0x21000020: ('CS', '1', "Execution Status", '', 'ExecutionStatus'),
0x21000030: ('CS', '1', "Execution Status Info", '', 'ExecutionStatusInfo'),
0x21000040: ('DA', '1', "Creation Date", '', 'CreationDate'),
0x21000050: ('TM', '1', "Creation Time", '', 'CreationTime'),
0x21000070: ('AE', '1', "Originator", '', 'Originator'),
0x21000140: ('AE', '1', "Destination AE", 'Retired', 'DestinationAE'),
0x21000160: ('SH', '1', "Owner ID", '', 'OwnerID'),
0x21000170: ('IS', '1', "Number of Films", '', 'NumberOfFilms'),
0x21000500: ('SQ', '1', "Referenced Print Job Sequence (Pull Stored Print)", 'Retired', 'ReferencedPrintJobSequencePullStoredPrint'),
0x21100010: ('CS', '1', "Printer Status", '', 'PrinterStatus'),
0x21100020: ('CS', '1', "Printer Status Info", '', 'PrinterStatusInfo'),
0x21100030: ('LO', '1', "Printer Name", '', 'PrinterName'),
0x21100099: ('SH', '1', "Print Queue ID", 'Retired', 'PrintQueueID'),
0x21200010: ('CS', '1', "Queue Status", 'Retired', 'QueueStatus'),
0x21200050: ('SQ', '1', "Print Job Description Sequence", 'Retired', 'PrintJobDescriptionSequence'),
0x21200070: ('SQ', '1', "Referenced Print Job Sequence", 'Retired', 'ReferencedPrintJobSequence'),
0x21300010: ('SQ', '1', "Print Management Capabilities Sequence", 'Retired', 'PrintManagementCapabilitiesSequence'),
0x21300015: ('SQ', '1', "Printer Characteristics Sequence", 'Retired', 'PrinterCharacteristicsSequence'),
0x21300030: ('SQ', '1', "Film Box Content Sequence", 'Retired', 'FilmBoxContentSequence'),
0x21300040: ('SQ', '1', "Image Box Content Sequence", 'Retired', 'ImageBoxContentSequence'),
0x21300050: ('SQ', '1', "Annotation Content Sequence", 'Retired', 'AnnotationContentSequence'),
0x21300060: ('SQ', '1', "Image Overlay Box Content Sequence", 'Retired', 'ImageOverlayBoxContentSequence'),
0x21300080: ('SQ', '1', "Presentation LUT Content Sequence", 'Retired', 'PresentationLUTContentSequence'),
0x213000A0: ('SQ', '1', "Proposed Study Sequence", 'Retired', 'ProposedStudySequence'),
0x213000C0: ('SQ', '1', "Original Image Sequence", 'Retired', 'OriginalImageSequence'),
0x22000001: ('CS', '1', "Label Using Information Extracted From Instances", '', 'LabelUsingInformationExtractedFromInstances'),
0x22000002: ('UT', '1', "Label Text", '', 'LabelText'),
0x22000003: ('CS', '1', "Label Style Selection", '', 'LabelStyleSelection'),
0x22000004: ('LT', '1', "Media Disposition", '', 'MediaDisposition'),
0x22000005: ('LT', '1', "Barcode Value", '', 'BarcodeValue'),
0x22000006: ('CS', '1', "Barcode Symbology", '', 'BarcodeSymbology'),
0x22000007: ('CS', '1', "Allow Media Splitting", '', 'AllowMediaSplitting'),
0x22000008: ('CS', '1', "Include Non-DICOM Objects", '', 'IncludeNonDICOMObjects'),
0x22000009: ('CS', '1', "Include Display Application", '', 'IncludeDisplayApplication'),
0x2200000A: ('CS', '1', "Preserve Composite Instances After Media Creation", '', 'PreserveCompositeInstancesAfterMediaCreation'),
0x2200000B: ('US', '1', "Total Number of Pieces of Media Created", '', 'TotalNumberOfPiecesOfMediaCreated'),
0x2200000C: ('LO', '1', "Requested Media Application Profile", '', 'RequestedMediaApplicationProfile'),
0x2200000D: ('SQ', '1', "Referenced Storage Media Sequence", '', 'ReferencedStorageMediaSequence'),
0x2200000E: ('AT', '1-n', "Failure Attributes", '', 'FailureAttributes'),
0x2200000F: ('CS', '1', "Allow Lossy Compression", '', 'AllowLossyCompression'),
0x22000020: ('CS', '1', "Request Priority", '', 'RequestPriority'),
0x30020002: ('SH', '1', "RT Image Label", '', 'RTImageLabel'),
0x30020003: ('LO', '1', "RT Image Name", '', 'RTImageName'),
0x30020004: ('ST', '1', "RT Image Description", '', 'RTImageDescription'),
0x3002000A: ('CS', '1', "Reported Values Origin", '', 'ReportedValuesOrigin'),
0x3002000C: ('CS', '1', "RT Image Plane", '', 'RTImagePlane'),
0x3002000D: ('DS', '3', "X-Ray Image Receptor Translation", '', 'XRayImageReceptorTranslation'),
0x3002000E: ('DS', '1', "X-Ray Image Receptor Angle", '', 'XRayImageReceptorAngle'),
0x30020010: ('DS', '6', "RT Image Orientation", '', 'RTImageOrientation'),
0x30020011: ('DS', '2', "Image Plane Pixel Spacing", '', 'ImagePlanePixelSpacing'),
0x30020012: ('DS', '2', "RT Image Position", '', 'RTImagePosition'),
0x30020020: ('SH', '1', "Radiation Machine Name", '', 'RadiationMachineName'),
0x30020022: ('DS', '1', "Radiation Machine SAD", '', 'RadiationMachineSAD'),
0x30020024: ('DS', '1', "Radiation Machine SSD", '', 'RadiationMachineSSD'),
0x30020026: ('DS', '1', "RT Image SID", '', 'RTImageSID'),
0x30020028: ('DS', '1', "Source to Reference Object Distance", '', 'SourceToReferenceObjectDistance'),
0x30020029: ('IS', '1', "Fraction Number", '', 'FractionNumber'),
0x30020030: ('SQ', '1', "Exposure Sequence", '', 'ExposureSequence'),
0x30020032: ('DS', '1', "Meterset Exposure", '', 'MetersetExposure'),
0x30020034: ('DS', '4', "Diaphragm Position", '', 'DiaphragmPosition'),
0x30020040: ('SQ', '1', "Fluence Map Sequence", '', 'FluenceMapSequence'),
0x30020041: ('CS', '1', "Fluence Data Source", '', 'FluenceDataSource'),
0x30020042: ('DS', '1', "Fluence Data Scale", '', 'FluenceDataScale'),
0x30020050: ('SQ', '1', "Primary Fluence Mode Sequence", '', 'PrimaryFluenceModeSequence'),
0x30020051: ('CS', '1', "Fluence Mode", '', 'FluenceMode'),
0x30020052: ('SH', '1', "Fluence Mode ID", '', 'FluenceModeID'),
0x30040001: ('CS', '1', "DVH Type", '', 'DVHType'),
0x30040002: ('CS', '1', "Dose Units", '', 'DoseUnits'),
0x30040004: ('CS', '1', "Dose Type", '', 'DoseType'),
0x30040006: ('LO', '1', "Dose Comment", '', 'DoseComment'),
0x30040008: ('DS', '3', "Normalization Point", '', 'NormalizationPoint'),
0x3004000A: ('CS', '1', "Dose Summation Type", '', 'DoseSummationType'),
0x3004000C: ('DS', '2-n', "Grid Frame Offset Vector", '', 'GridFrameOffsetVector'),
0x3004000E: ('DS', '1', "Dose Grid Scaling", '', 'DoseGridScaling'),
0x30040010: ('SQ', '1', "RT Dose ROI Sequence", '', 'RTDoseROISequence'),
0x30040012: ('DS', '1', "Dose Value", '', 'DoseValue'),
0x30040014: ('CS', '1-3', "Tissue Heterogeneity Correction", '', 'TissueHeterogeneityCorrection'),
0x30040040: ('DS', '3', "DVH Normalization Point", '', 'DVHNormalizationPoint'),
0x30040042: ('DS', '1', "DVH Normalization Dose Value", '', 'DVHNormalizationDoseValue'),
0x30040050: ('SQ', '1', "DVH Sequence", '', 'DVHSequence'),
0x30040052: ('DS', '1', "DVH Dose Scaling", '', 'DVHDoseScaling'),
0x30040054: ('CS', '1', "DVH Volume Units", '', 'DVHVolumeUnits'),
0x30040056: ('IS', '1', "DVH Number of Bins", '', 'DVHNumberOfBins'),
0x30040058: ('DS', '2-2n', "DVH Data", '', 'DVHData'),
0x30040060: ('SQ', '1', "DVH Referenced ROI Sequence", '', 'DVHReferencedROISequence'),
0x30040062: ('CS', '1', "DVH ROI Contribution Type", '', 'DVHROIContributionType'),
0x30040070: ('DS', '1', "DVH Minimum Dose", '', 'DVHMinimumDose'),
0x30040072: ('DS', '1', "DVH Maximum Dose", '', 'DVHMaximumDose'),
0x30040074: ('DS', '1', "DVH Mean Dose", '', 'DVHMeanDose'),
0x30060002: ('SH', '1', "Structure Set Label", '', 'StructureSetLabel'),
0x30060004: ('LO', '1', "Structure Set Name", '', 'StructureSetName'),
0x30060006: ('ST', '1', "Structure Set Description", '', 'StructureSetDescription'),
0x30060008: ('DA', '1', "Structure Set Date", '', 'StructureSetDate'),
0x30060009: ('TM', '1', "Structure Set Time", '', 'StructureSetTime'),
0x30060010: ('SQ', '1', "Referenced Frame of Reference Sequence", '', 'ReferencedFrameOfReferenceSequence'),
0x30060012: ('SQ', '1', "RT Referenced Study Sequence", '', 'RTReferencedStudySequence'),
0x30060014: ('SQ', '1', "RT Referenced Series Sequence", '', 'RTReferencedSeriesSequence'),
0x30060016: ('SQ', '1', "Contour Image Sequence", '', 'ContourImageSequence'),
0x30060020: ('SQ', '1', "Structure Set ROI Sequence", '', 'StructureSetROISequence'),
0x30060022: ('IS', '1', "ROI Number", '', 'ROINumber'),
0x30060024: ('UI', '1', "Referenced Frame of Reference UID", '', 'ReferencedFrameOfReferenceUID'),
0x30060026: ('LO', '1', "ROI Name", '', 'ROIName'),
0x30060028: ('ST', '1', "ROI Description", '', 'ROIDescription'),
0x3006002A: ('IS', '3', "ROI Display Color", '', 'ROIDisplayColor'),
0x3006002C: ('DS', '1', "ROI Volume", '', 'ROIVolume'),
0x30060030: ('SQ', '1', "RT Related ROI Sequence", '', 'RTRelatedROISequence'),
0x30060033: ('CS', '1', "RT ROI Relationship", '', 'RTROIRelationship'),
0x30060036: ('CS', '1', "ROI Generation Algorithm", '', 'ROIGenerationAlgorithm'),
0x30060038: ('LO', '1', "ROI Generation Description", '', 'ROIGenerationDescription'),
0x30060039: ('SQ', '1', "ROI Contour Sequence", '', 'ROIContourSequence'),
0x30060040: ('SQ', '1', "Contour Sequence", '', 'ContourSequence'),
0x30060042: ('CS', '1', "Contour Geometric Type", '', 'ContourGeometricType'),
0x30060044: ('DS', '1', "Contour Slab Thickness", '', 'ContourSlabThickness'),
0x30060045: ('DS', '3', "Contour Offset Vector", '', 'ContourOffsetVector'),
0x30060046: ('IS', '1', "Number of Contour Points", '', 'NumberOfContourPoints'),
0x30060048: ('IS', '1', "Contour Number", '', 'ContourNumber'),
0x30060049: ('IS', '1-n', "Attached Contours", '', 'AttachedContours'),
0x30060050: ('DS', '3-3n', "Contour Data", '', 'ContourData'),
0x30060080: ('SQ', '1', "RT ROI Observations Sequence", '', 'RTROIObservationsSequence'),
0x30060082: ('IS', '1', "Observation Number", '', 'ObservationNumber'),
0x30060084: ('IS', '1', "Referenced ROI Number", '', 'ReferencedROINumber'),
0x30060085: ('SH', '1', "ROI Observation Label", '', 'ROIObservationLabel'),
0x30060086: ('SQ', '1', "RT ROI Identification Code Sequence", '', 'RTROIIdentificationCodeSequence'),
0x30060088: ('ST', '1', "ROI Observation Description", '', 'ROIObservationDescription'),
0x300600A0: ('SQ', '1', "Related RT ROI Observations Sequence", '', 'RelatedRTROIObservationsSequence'),
0x300600A4: ('CS', '1', "RT ROI Interpreted Type", '', 'RTROIInterpretedType'),
0x300600A6: ('PN', '1', "ROI Interpreter", '', 'ROIInterpreter'),
0x300600B0: ('SQ', '1', "ROI Physical Properties Sequence", '', 'ROIPhysicalPropertiesSequence'),
0x300600B2: ('CS', '1', "ROI Physical Property", '', 'ROIPhysicalProperty'),
0x300600B4: ('DS', '1', "ROI Physical Property Value", '', 'ROIPhysicalPropertyValue'),
0x300600B6: ('SQ', '1', "ROI Elemental Composition Sequence", '', 'ROIElementalCompositionSequence'),
0x300600B7: ('US', '1', "ROI Elemental Composition Atomic Number", '', 'ROIElementalCompositionAtomicNumber'),
0x300600B8: ('FL', '1', "ROI Elemental Composition Atomic Mass Fraction", '', 'ROIElementalCompositionAtomicMassFraction'),
0x300600C0: ('SQ', '1', "Frame of Reference Relationship Sequence", '', 'FrameOfReferenceRelationshipSequence'),
0x300600C2: ('UI', '1', "Related Frame of Reference UID", '', 'RelatedFrameOfReferenceUID'),
0x300600C4: ('CS', '1', "Frame of Reference Transformation Type", '', 'FrameOfReferenceTransformationType'),
0x300600C6: ('DS', '16', "Frame of Reference Transformation Matrix", '', 'FrameOfReferenceTransformationMatrix'),
0x300600C8: ('LO', '1', "Frame of Reference Transformation Comment", '', 'FrameOfReferenceTransformationComment'),
0x30080010: ('SQ', '1', "Measured Dose Reference Sequence", '', 'MeasuredDoseReferenceSequence'),
0x30080012: ('ST', '1', "Measured Dose Description", '', 'MeasuredDoseDescription'),
0x30080014: ('CS', '1', "Measured Dose Type", '', 'MeasuredDoseType'),
0x30080016: ('DS', '1', "Measured Dose Value", '', 'MeasuredDoseValue'),
0x30080020: ('SQ', '1', "Treatment Session Beam Sequence", '', 'TreatmentSessionBeamSequence'),
0x30080021: ('SQ', '1', "Treatment Session Ion Beam Sequence", '', 'TreatmentSessionIonBeamSequence'),
0x30080022: ('IS', '1', "Current Fraction Number", '', 'CurrentFractionNumber'),
0x30080024: ('DA', '1', "Treatment Control Point Date", '', 'TreatmentControlPointDate'),
0x30080025: ('TM', '1', "Treatment Control Point Time", '', 'TreatmentControlPointTime'),
0x3008002A: ('CS', '1', "Treatment Termination Status", '', 'TreatmentTerminationStatus'),
0x3008002B: ('SH', '1', "Treatment Termination Code", '', 'TreatmentTerminationCode'),
0x3008002C: ('CS', '1', "Treatment Verification Status", '', 'TreatmentVerificationStatus'),
0x30080030: ('SQ', '1', "Referenced Treatment Record Sequence", '', 'ReferencedTreatmentRecordSequence'),
0x30080032: ('DS', '1', "Specified Primary Meterset", '', 'SpecifiedPrimaryMeterset'),
0x30080033: ('DS', '1', "Specified Secondary Meterset", '', 'SpecifiedSecondaryMeterset'),
0x30080036: ('DS', '1', "Delivered Primary Meterset", '', 'DeliveredPrimaryMeterset'),
0x30080037: ('DS', '1', "Delivered Secondary Meterset", '', 'DeliveredSecondaryMeterset'),
0x3008003A: ('DS', '1', "Specified Treatment Time", '', 'SpecifiedTreatmentTime'),
0x3008003B: ('DS', '1', "Delivered Treatment Time", '', 'DeliveredTreatmentTime'),
0x30080040: ('SQ', '1', "Control Point Delivery Sequence", '', 'ControlPointDeliverySequence'),
0x30080041: ('SQ', '1', "Ion Control Point Delivery Sequence", '', 'IonControlPointDeliverySequence'),
0x30080042: ('DS', '1', "Specified Meterset", '', 'SpecifiedMeterset'),
0x30080044: ('DS', '1', "Delivered Meterset", '', 'DeliveredMeterset'),
0x30080045: ('FL', '1', "Meterset Rate Set", '', 'MetersetRateSet'),
0x30080046: ('FL', '1', "Meterset Rate Delivered", '', 'MetersetRateDelivered'),
0x30080047: ('FL', '1-n', "Scan Spot Metersets Delivered", '', 'ScanSpotMetersetsDelivered'),
0x30080048: ('DS', '1', "Dose Rate Delivered", '', 'DoseRateDelivered'),
0x30080050: ('SQ', '1', "Treatment Summary Calculated Dose Reference Sequence", '', 'TreatmentSummaryCalculatedDoseReferenceSequence'),
0x30080052: ('DS', '1', "Cumulative Dose to Dose Reference", '', 'CumulativeDoseToDoseReference'),
0x30080054: ('DA', '1', "First Treatment Date", '', 'FirstTreatmentDate'),
0x30080056: ('DA', '1', "Most Recent Treatment Date", '', 'MostRecentTreatmentDate'),
0x3008005A: ('IS', '1', "Number of Fractions Delivered", '', 'NumberOfFractionsDelivered'),
0x30080060: ('SQ', '1', "Override Sequence", '', 'OverrideSequence'),
0x30080061: ('AT', '1', "Parameter Sequence Pointer", '', 'ParameterSequencePointer'),
0x30080062: ('AT', '1', "Override Parameter Pointer", '', 'OverrideParameterPointer'),
0x30080063: ('IS', '1', "Parameter Item Index", '', 'ParameterItemIndex'),
0x30080064: ('IS', '1', "Measured Dose Reference Number", '', 'MeasuredDoseReferenceNumber'),
0x30080065: ('AT', '1', "Parameter Pointer", '', 'ParameterPointer'),
0x30080066: ('ST', '1', "Override Reason", '', 'OverrideReason'),
0x30080068: ('SQ', '1', "Corrected Parameter Sequence", '', 'CorrectedParameterSequence'),
0x3008006A: ('FL', '1', "Correction Value", '', 'CorrectionValue'),
0x30080070: ('SQ', '1', "Calculated Dose Reference Sequence", '', 'CalculatedDoseReferenceSequence'),
0x30080072: ('IS', '1', "Calculated Dose Reference Number", '', 'CalculatedDoseReferenceNumber'),
0x30080074: ('ST', '1', "Calculated Dose Reference Description", '', 'CalculatedDoseReferenceDescription'),
0x30080076: ('DS', '1', "Calculated Dose Reference Dose Value", '', 'CalculatedDoseReferenceDoseValue'),
0x30080078: ('DS', '1', "Start Meterset", '', 'StartMeterset'),
0x3008007A: ('DS', '1', "End Meterset", '', 'EndMeterset'),
0x30080080: ('SQ', '1', "Referenced Measured Dose Reference Sequence", '', 'ReferencedMeasuredDoseReferenceSequence'),
0x30080082: ('IS', '1', "Referenced Measured Dose Reference Number", '', 'ReferencedMeasuredDoseReferenceNumber'),
0x30080090: ('SQ', '1', "Referenced Calculated Dose Reference Sequence", '', 'ReferencedCalculatedDoseReferenceSequence'),
0x30080092: ('IS', '1', "Referenced Calculated Dose Reference Number", '', 'ReferencedCalculatedDoseReferenceNumber'),
0x300800A0: ('SQ', '1', "Beam Limiting Device Leaf Pairs Sequence", '', 'BeamLimitingDeviceLeafPairsSequence'),
0x300800B0: ('SQ', '1', "Recorded Wedge Sequence", '', 'RecordedWedgeSequence'),
0x300800C0: ('SQ', '1', "Recorded Compensator Sequence", '', 'RecordedCompensatorSequence'),
0x300800D0: ('SQ', '1', "Recorded Block Sequence", '', 'RecordedBlockSequence'),
0x300800E0: ('SQ', '1', "Treatment Summary Measured Dose Reference Sequence", '', 'TreatmentSummaryMeasuredDoseReferenceSequence'),
0x300800F0: ('SQ', '1', "Recorded Snout Sequence", '', 'RecordedSnoutSequence'),
0x300800F2: ('SQ', '1', "Recorded Range Shifter Sequence", '', 'RecordedRangeShifterSequence'),
0x300800F4: ('SQ', '1', "Recorded Lateral Spreading Device Sequence", '', 'RecordedLateralSpreadingDeviceSequence'),
0x300800F6: ('SQ', '1', "Recorded Range Modulator Sequence", '', 'RecordedRangeModulatorSequence'),
0x30080100: ('SQ', '1', "Recorded Source Sequence", '', 'RecordedSourceSequence'),
0x30080105: ('LO', '1', "Source Serial Number", '', 'SourceSerialNumber'),
0x30080110: ('SQ', '1', "Treatment Session Application Setup Sequence", '', 'TreatmentSessionApplicationSetupSequence'),
0x30080116: ('CS', '1', "Application Setup Check", '', 'ApplicationSetupCheck'),
0x30080120: ('SQ', '1', "Recorded Brachy Accessory Device Sequence", '', 'RecordedBrachyAccessoryDeviceSequence'),
0x30080122: ('IS', '1', "Referenced Brachy Accessory Device Number", '', 'ReferencedBrachyAccessoryDeviceNumber'),
0x30080130: ('SQ', '1', "Recorded Channel Sequence", '', 'RecordedChannelSequence'),
0x30080132: ('DS', '1', "Specified Channel Total Time", '', 'SpecifiedChannelTotalTime'),
0x30080134: ('DS', '1', "Delivered Channel Total Time", '', 'DeliveredChannelTotalTime'),
0x30080136: ('IS', '1', "Specified Number of Pulses", '', 'SpecifiedNumberOfPulses'),
0x30080138: ('IS', '1', "Delivered Number of Pulses", '', 'DeliveredNumberOfPulses'),
0x3008013A: ('DS', '1', "Specified Pulse Repetition Interval", '', 'SpecifiedPulseRepetitionInterval'),
0x3008013C: ('DS', '1', "Delivered Pulse Repetition Interval", '', 'DeliveredPulseRepetitionInterval'),
0x30080140: ('SQ', '1', "Recorded Source Applicator Sequence", '', 'RecordedSourceApplicatorSequence'),
0x30080142: ('IS', '1', "Referenced Source Applicator Number", '', 'ReferencedSourceApplicatorNumber'),
0x30080150: ('SQ', '1', "Recorded Channel Shield Sequence", '', 'RecordedChannelShieldSequence'),
0x30080152: ('IS', '1', "Referenced Channel Shield Number", '', 'ReferencedChannelShieldNumber'),
0x30080160: ('SQ', '1', "Brachy Control Point Delivered Sequence", '', 'BrachyControlPointDeliveredSequence'),
0x30080162: ('DA', '1', "Safe Position Exit Date", '', 'SafePositionExitDate'),
0x30080164: ('TM', '1', "Safe Position Exit Time", '', 'SafePositionExitTime'),
0x30080166: ('DA', '1', "Safe Position Return Date", '', 'SafePositionReturnDate'),
0x30080168: ('TM', '1', "Safe Position Return Time", '', 'SafePositionReturnTime'),
0x30080200: ('CS', '1', "Current Treatment Status", '', 'CurrentTreatmentStatus'),
0x30080202: ('ST', '1', "Treatment Status Comment", '', 'TreatmentStatusComment'),
0x30080220: ('SQ', '1', "Fraction Group Summary Sequence", '', 'FractionGroupSummarySequence'),
0x30080223: ('IS', '1', "Referenced Fraction Number", '', 'ReferencedFractionNumber'),
0x30080224: ('CS', '1', "Fraction Group Type", '', 'FractionGroupType'),
0x30080230: ('CS', '1', "Beam Stopper Position", '', 'BeamStopperPosition'),
0x30080240: ('SQ', '1', "Fraction Status Summary Sequence", '', 'FractionStatusSummarySequence'),
0x30080250: ('DA', '1', "Treatment Date", '', 'TreatmentDate'),
0x30080251: ('TM', '1', "Treatment Time", '', 'TreatmentTime'),
0x300A0002: ('SH', '1', "RT Plan Label", '', 'RTPlanLabel'),
0x300A0003: ('LO', '1', "RT Plan Name", '', 'RTPlanName'),
0x300A0004: ('ST', '1', "RT Plan Description", '', 'RTPlanDescription'),
0x300A0006: ('DA', '1', "RT Plan Date", '', 'RTPlanDate'),
0x300A0007: ('TM', '1', "RT Plan Time", '', 'RTPlanTime'),
0x300A0009: ('LO', '1-n', "Treatment Protocols", '', 'TreatmentProtocols'),
0x300A000A: ('CS', '1', "Plan Intent", '', 'PlanIntent'),
0x300A000B: ('LO', '1-n', "Treatment Sites", '', 'TreatmentSites'),
0x300A000C: ('CS', '1', "RT Plan Geometry", '', 'RTPlanGeometry'),
0x300A000E: ('ST', '1', "Prescription Description", '', 'PrescriptionDescription'),
0x300A0010: ('SQ', '1', "Dose Reference Sequence", '', 'DoseReferenceSequence'),
0x300A0012: ('IS', '1', "Dose Reference Number", '', 'DoseReferenceNumber'),
0x300A0013: ('UI', '1', "Dose Reference UID", '', 'DoseReferenceUID'),
0x300A0014: ('CS', '1', "Dose Reference Structure Type", '', 'DoseReferenceStructureType'),
0x300A0015: ('CS', '1', "Nominal Beam Energy Unit", '', 'NominalBeamEnergyUnit'),
0x300A0016: ('LO', '1', "Dose Reference Description", '', 'DoseReferenceDescription'),
0x300A0018: ('DS', '3', "Dose Reference Point Coordinates", '', 'DoseReferencePointCoordinates'),
0x300A001A: ('DS', '1', "Nominal Prior Dose", '', 'NominalPriorDose'),
0x300A0020: ('CS', '1', "Dose Reference Type", '', 'DoseReferenceType'),
0x300A0021: ('DS', '1', "Constraint Weight", '', 'ConstraintWeight'),
0x300A0022: ('DS', '1', "Delivery Warning Dose", '', 'DeliveryWarningDose'),
0x300A0023: ('DS', '1', "Delivery Maximum Dose", '', 'DeliveryMaximumDose'),
0x300A0025: ('DS', '1', "Target Minimum Dose", '', 'TargetMinimumDose'),
0x300A0026: ('DS', '1', "Target Prescription Dose", '', 'TargetPrescriptionDose'),
0x300A0027: ('DS', '1', "Target Maximum Dose", '', 'TargetMaximumDose'),
0x300A0028: ('DS', '1', "Target Underdose Volume Fraction", '', 'TargetUnderdoseVolumeFraction'),
0x300A002A: ('DS', '1', "Organ at Risk Full-volume Dose", '', 'OrganAtRiskFullVolumeDose'),
0x300A002B: ('DS', '1', "Organ at Risk Limit Dose", '', 'OrganAtRiskLimitDose'),
0x300A002C: ('DS', '1', "Organ at Risk Maximum Dose", '', 'OrganAtRiskMaximumDose'),
0x300A002D: ('DS', '1', "Organ at Risk Overdose Volume Fraction", '', 'OrganAtRiskOverdoseVolumeFraction'),
0x300A0040: ('SQ', '1', "Tolerance Table Sequence", '', 'ToleranceTableSequence'),
0x300A0042: ('IS', '1', "Tolerance Table Number", '', 'ToleranceTableNumber'),
0x300A0043: ('SH', '1', "Tolerance Table Label", '', 'ToleranceTableLabel'),
0x300A0044: ('DS', '1', "Gantry Angle Tolerance", '', 'GantryAngleTolerance'),
0x300A0046: ('DS', '1', "Beam Limiting Device Angle Tolerance", '', 'BeamLimitingDeviceAngleTolerance'),
0x300A0048: ('SQ', '1', "Beam Limiting Device Tolerance Sequence", '', 'BeamLimitingDeviceToleranceSequence'),
0x300A004A: ('DS', '1', "Beam Limiting Device Position Tolerance", '', 'BeamLimitingDevicePositionTolerance'),
0x300A004B: ('FL', '1', "Snout Position Tolerance", '', 'SnoutPositionTolerance'),
0x300A004C: ('DS', '1', "Patient Support Angle Tolerance", '', 'PatientSupportAngleTolerance'),
0x300A004E: ('DS', '1', "Table Top Eccentric Angle Tolerance", '', 'TableTopEccentricAngleTolerance'),
0x300A004F: ('FL', '1', "Table Top Pitch Angle Tolerance", '', 'TableTopPitchAngleTolerance'),
0x300A0050: ('FL', '1', "Table Top Roll Angle Tolerance", '', 'TableTopRollAngleTolerance'),
0x300A0051: ('DS', '1', "Table Top Vertical Position Tolerance", '', 'TableTopVerticalPositionTolerance'),
0x300A0052: ('DS', '1', "Table Top Longitudinal Position Tolerance", '', 'TableTopLongitudinalPositionTolerance'),
0x300A0053: ('DS', '1', "Table Top Lateral Position Tolerance", '', 'TableTopLateralPositionTolerance'),
0x300A0055: ('CS', '1', "RT Plan Relationship", '', 'RTPlanRelationship'),
0x300A0070: ('SQ', '1', "Fraction Group Sequence", '', 'FractionGroupSequence'),
0x300A0071: ('IS', '1', "Fraction Group Number", '', 'FractionGroupNumber'),
0x300A0072: ('LO', '1', "Fraction Group Description", '', 'FractionGroupDescription'),
0x300A0078: ('IS', '1', "Number of Fractions Planned", '', 'NumberOfFractionsPlanned'),
0x300A0079: ('IS', '1', "Number of Fraction Pattern Digits Per Day", '', 'NumberOfFractionPatternDigitsPerDay'),
0x300A007A: ('IS', '1', "Repeat Fraction Cycle Length", '', 'RepeatFractionCycleLength'),
0x300A007B: ('LT', '1', "Fraction Pattern", '', 'FractionPattern'),
0x300A0080: ('IS', '1', "Number of Beams", '', 'NumberOfBeams'),
0x300A0082: ('DS', '3', "Beam Dose Specification Point", '', 'BeamDoseSpecificationPoint'),
0x300A0084: ('DS', '1', "Beam Dose", '', 'BeamDose'),
0x300A0086: ('DS', '1', "Beam Meterset", '', 'BeamMeterset'),
0x300A0088: ('FL', '1', "Beam Dose Point Depth", '', 'BeamDosePointDepth'),
0x300A0089: ('FL', '1', "Beam Dose Point Equivalent Depth", '', 'BeamDosePointEquivalentDepth'),
0x300A008A: ('FL', '1', "Beam Dose Point SSD", '', 'BeamDosePointSSD'),
0x300A00A0: ('IS', '1', "Number of Brachy Application Setups", '', 'NumberOfBrachyApplicationSetups'),
0x300A00A2: ('DS', '3', "Brachy Application Setup Dose Specification Point", '', 'BrachyApplicationSetupDoseSpecificationPoint'),
0x300A00A4: ('DS', '1', "Brachy Application Setup Dose", '', 'BrachyApplicationSetupDose'),
0x300A00B0: ('SQ', '1', "Beam Sequence", '', 'BeamSequence'),
0x300A00B2: ('SH', '1', "Treatment Machine Name", '', 'TreatmentMachineName'),
0x300A00B3: ('CS', '1', "Primary Dosimeter Unit", '', 'PrimaryDosimeterUnit'),
0x300A00B4: ('DS', '1', "Source-Axis Distance", '', 'SourceAxisDistance'),
0x300A00B6: ('SQ', '1', "Beam Limiting Device Sequence", '', 'BeamLimitingDeviceSequence'),
0x300A00B8: ('CS', '1', "RT Beam Limiting Device Type", '', 'RTBeamLimitingDeviceType'),
0x300A00BA: ('DS', '1', "Source to Beam Limiting Device Distance", '', 'SourceToBeamLimitingDeviceDistance'),
0x300A00BB: ('FL', '1', "Isocenter to Beam Limiting Device Distance", '', 'IsocenterToBeamLimitingDeviceDistance'),
0x300A00BC: ('IS', '1', "Number of Leaf/Jaw Pairs", '', 'NumberOfLeafJawPairs'),
0x300A00BE: ('DS', '3-n', "Leaf Position Boundaries", '', 'LeafPositionBoundaries'),
0x300A00C0: ('IS', '1', "Beam Number", '', 'BeamNumber'),
0x300A00C2: ('LO', '1', "Beam Name", '', 'BeamName'),
0x300A00C3: ('ST', '1', "Beam Description", '', 'BeamDescription'),
0x300A00C4: ('CS', '1', "Beam Type", '', 'BeamType'),
0x300A00C6: ('CS', '1', "Radiation Type", '', 'RadiationType'),
0x300A00C7: ('CS', '1', "High-Dose Technique Type", '', 'HighDoseTechniqueType'),
0x300A00C8: ('IS', '1', "Reference Image Number", '', 'ReferenceImageNumber'),
0x300A00CA: ('SQ', '1', "Planned Verification Image Sequence", '', 'PlannedVerificationImageSequence'),
0x300A00CC: ('LO', '1-n', "Imaging Device-Specific Acquisition Parameters", '', 'ImagingDeviceSpecificAcquisitionParameters'),
0x300A00CE: ('CS', '1', "Treatment Delivery Type", '', 'TreatmentDeliveryType'),
0x300A00D0: ('IS', '1', "Number of Wedges", '', 'NumberOfWedges'),
0x300A00D1: ('SQ', '1', "Wedge Sequence", '', 'WedgeSequence'),
0x300A00D2: ('IS', '1', "Wedge Number", '', 'WedgeNumber'),
0x300A00D3: ('CS', '1', "Wedge Type", '', 'WedgeType'),
0x300A00D4: ('SH', '1', "Wedge ID", '', 'WedgeID'),
0x300A00D5: ('IS', '1', "Wedge Angle", '', 'WedgeAngle'),
0x300A00D6: ('DS', '1', "Wedge Factor", '', 'WedgeFactor'),
0x300A00D7: ('FL', '1', "Total Wedge Tray Water-Equivalent Thickness", '', 'TotalWedgeTrayWaterEquivalentThickness'),
0x300A00D8: ('DS', '1', "Wedge Orientation", '', 'WedgeOrientation'),
0x300A00D9: ('FL', '1', "Isocenter to Wedge Tray Distance", '', 'IsocenterToWedgeTrayDistance'),
0x300A00DA: ('DS', '1', "Source to Wedge Tray Distance", '', 'SourceToWedgeTrayDistance'),
0x300A00DB: ('FL', '1', "Wedge Thin Edge Position", '', 'WedgeThinEdgePosition'),
0x300A00DC: ('SH', '1', "Bolus ID", '', 'BolusID'),
0x300A00DD: ('ST', '1', "Bolus Description", '', 'BolusDescription'),
0x300A00E0: ('IS', '1', "Number of Compensators", '', 'NumberOfCompensators'),
0x300A00E1: ('SH', '1', "Material ID", '', 'MaterialID'),
0x300A00E2: ('DS', '1', "Total Compensator Tray Factor", '', 'TotalCompensatorTrayFactor'),
0x300A00E3: ('SQ', '1', "Compensator Sequence", '', 'CompensatorSequence'),
0x300A00E4: ('IS', '1', "Compensator Number", '', 'CompensatorNumber'),
0x300A00E5: ('SH', '1', "Compensator ID", '', 'CompensatorID'),
0x300A00E6: ('DS', '1', "Source to Compensator Tray Distance", '', 'SourceToCompensatorTrayDistance'),
0x300A00E7: ('IS', '1', "Compensator Rows", '', 'CompensatorRows'),
0x300A00E8: ('IS', '1', "Compensator Columns", '', 'CompensatorColumns'),
0x300A00E9: ('DS', '2', "Compensator Pixel Spacing", '', 'CompensatorPixelSpacing'),
0x300A00EA: ('DS', '2', "Compensator Position", '', 'CompensatorPosition'),
0x300A00EB: ('DS', '1-n', "Compensator Transmission Data", '', 'CompensatorTransmissionData'),
0x300A00EC: ('DS', '1-n', "Compensator Thickness Data", '', 'CompensatorThicknessData'),
0x300A00ED: ('IS', '1', "Number of Boli", '', 'NumberOfBoli'),
0x300A00EE: ('CS', '1', "Compensator Type", '', 'CompensatorType'),
0x300A00F0: ('IS', '1', "Number of Blocks", '', 'NumberOfBlocks'),
0x300A00F2: ('DS', '1', "Total Block Tray Factor", '', 'TotalBlockTrayFactor'),
0x300A00F3: ('FL', '1', "Total Block Tray Water-Equivalent Thickness", '', 'TotalBlockTrayWaterEquivalentThickness'),
0x300A00F4: ('SQ', '1', "Block Sequence", '', 'BlockSequence'),
0x300A00F5: ('SH', '1', "Block Tray ID", '', 'BlockTrayID'),
0x300A00F6: ('DS', '1', "Source to Block Tray Distance", '', 'SourceToBlockTrayDistance'),
0x300A00F7: ('FL', '1', "Isocenter to Block Tray Distance", '', 'IsocenterToBlockTrayDistance'),
0x300A00F8: ('CS', '1', "Block Type", '', 'BlockType'),
0x300A00F9: ('LO', '1', "Accessory Code", '', 'AccessoryCode'),
0x300A00FA: ('CS', '1', "Block Divergence", '', 'BlockDivergence'),
0x300A00FB: ('CS', '1', "Block Mounting Position", '', 'BlockMountingPosition'),
0x300A00FC: ('IS', '1', "Block Number", '', 'BlockNumber'),
0x300A00FE: ('LO', '1', "Block Name", '', 'BlockName'),
0x300A0100: ('DS', '1', "Block Thickness", '', 'BlockThickness'),
0x300A0102: ('DS', '1', "Block Transmission", '', 'BlockTransmission'),
0x300A0104: ('IS', '1', "Block Number of Points", '', 'BlockNumberOfPoints'),
0x300A0106: ('DS', '2-2n', "Block Data", '', 'BlockData'),
0x300A0107: ('SQ', '1', "Applicator Sequence", '', 'ApplicatorSequence'),
0x300A0108: ('SH', '1', "Applicator ID", '', 'ApplicatorID'),
0x300A0109: ('CS', '1', "Applicator Type", '', 'ApplicatorType'),
0x300A010A: ('LO', '1', "Applicator Description", '', 'ApplicatorDescription'),
0x300A010C: ('DS', '1', "Cumulative Dose Reference Coefficient", '', 'CumulativeDoseReferenceCoefficient'),
0x300A010E: ('DS', '1', "Final Cumulative Meterset Weight", '', 'FinalCumulativeMetersetWeight'),
0x300A0110: ('IS', '1', "Number of Control Points", '', 'NumberOfControlPoints'),
0x300A0111: ('SQ', '1', "Control Point Sequence", '', 'ControlPointSequence'),
0x300A0112: ('IS', '1', "Control Point Index", '', 'ControlPointIndex'),
0x300A0114: ('DS', '1', "Nominal Beam Energy", '', 'NominalBeamEnergy'),
0x300A0115: ('DS', '1', "Dose Rate Set", '', 'DoseRateSet'),
0x300A0116: ('SQ', '1', "Wedge Position Sequence", '', 'WedgePositionSequence'),
0x300A0118: ('CS', '1', "Wedge Position", '', 'WedgePosition'),
0x300A011A: ('SQ', '1', "Beam Limiting Device Position Sequence", '', 'BeamLimitingDevicePositionSequence'),
0x300A011C: ('DS', '2-2n', "Leaf/Jaw Positions", '', 'LeafJawPositions'),
0x300A011E: ('DS', '1', "Gantry Angle", '', 'GantryAngle'),
0x300A011F: ('CS', '1', "Gantry Rotation Direction", '', 'GantryRotationDirection'),
0x300A0120: ('DS', '1', "Beam Limiting Device Angle", '', 'BeamLimitingDeviceAngle'),
0x300A0121: ('CS', '1', "Beam Limiting Device Rotation Direction", '', 'BeamLimitingDeviceRotationDirection'),
0x300A0122: ('DS', '1', "Patient Support Angle", '', 'PatientSupportAngle'),
0x300A0123: ('CS', '1', "Patient Support Rotation Direction", '', 'PatientSupportRotationDirection'),
0x300A0124: ('DS', '1', "Table Top Eccentric Axis Distance", '', 'TableTopEccentricAxisDistance'),
0x300A0125: ('DS', '1', "Table Top Eccentric Angle", '', 'TableTopEccentricAngle'),
0x300A0126: ('CS', '1', "Table Top Eccentric Rotation Direction", '', 'TableTopEccentricRotationDirection'),
0x300A0128: ('DS', '1', "Table Top Vertical Position", '', 'TableTopVerticalPosition'),
0x300A0129: ('DS', '1', "Table Top Longitudinal Position", '', 'TableTopLongitudinalPosition'),
0x300A012A: ('DS', '1', "Table Top Lateral Position", '', 'TableTopLateralPosition'),
0x300A012C: ('DS', '3', "Isocenter Position", '', 'IsocenterPosition'),
0x300A012E: ('DS', '3', "Surface Entry Point", '', 'SurfaceEntryPoint'),
0x300A0130: ('DS', '1', "Source to Surface Distance", '', 'SourceToSurfaceDistance'),
0x300A0134: ('DS', '1', "Cumulative Meterset Weight", '', 'CumulativeMetersetWeight'),
0x300A0140: ('FL', '1', "Table Top Pitch Angle", '', 'TableTopPitchAngle'),
0x300A0142: ('CS', '1', "Table Top Pitch Rotation Direction", '', 'TableTopPitchRotationDirection'),
0x300A0144: ('FL', '1', "Table Top Roll Angle", '', 'TableTopRollAngle'),
0x300A0146: ('CS', '1', "Table Top Roll Rotation Direction", '', 'TableTopRollRotationDirection'),
0x300A0148: ('FL', '1', "Head Fixation Angle", '', 'HeadFixationAngle'),
0x300A014A: ('FL', '1', "Gantry Pitch Angle", '', 'GantryPitchAngle'),
0x300A014C: ('CS', '1', "Gantry Pitch Rotation Direction", '', 'GantryPitchRotationDirection'),
0x300A014E: ('FL', '1', "Gantry Pitch Angle Tolerance", '', 'GantryPitchAngleTolerance'),
0x300A0180: ('SQ', '1', "Patient Setup Sequence", '', 'PatientSetupSequence'),
0x300A0182: ('IS', '1', "Patient Setup Number", '', 'PatientSetupNumber'),
0x300A0183: ('LO', '1', "Patient Setup Label", '', 'PatientSetupLabel'),
0x300A0184: ('LO', '1', "Patient Additional Position", '', 'PatientAdditionalPosition'),
0x300A0190: ('SQ', '1', "Fixation Device Sequence", '', 'FixationDeviceSequence'),
0x300A0192: ('CS', '1', "Fixation Device Type", '', 'FixationDeviceType'),
0x300A0194: ('SH', '1', "Fixation Device Label", '', 'FixationDeviceLabel'),
0x300A0196: ('ST', '1', "Fixation Device Description", '', 'FixationDeviceDescription'),
0x300A0198: ('SH', '1', "Fixation Device Position", '', 'FixationDevicePosition'),
0x300A0199: ('FL', '1', "Fixation Device Pitch Angle", '', 'FixationDevicePitchAngle'),
0x300A019A: ('FL', '1', "Fixation Device Roll Angle", '', 'FixationDeviceRollAngle'),
0x300A01A0: ('SQ', '1', "Shielding Device Sequence", '', 'ShieldingDeviceSequence'),
0x300A01A2: ('CS', '1', "Shielding Device Type", '', 'ShieldingDeviceType'),
0x300A01A4: ('SH', '1', "Shielding Device Label", '', 'ShieldingDeviceLabel'),
0x300A01A6: ('ST', '1', "Shielding Device Description", '', 'ShieldingDeviceDescription'),
0x300A01A8: ('SH', '1', "Shielding Device Position", '', 'ShieldingDevicePosition'),
0x300A01B0: ('CS', '1', "Setup Technique", '', 'SetupTechnique'),
0x300A01B2: ('ST', '1', "Setup Technique Description", '', 'SetupTechniqueDescription'),
0x300A01B4: ('SQ', '1', "Setup Device Sequence", '', 'SetupDeviceSequence'),
0x300A01B6: ('CS', '1', "Setup Device Type", '', 'SetupDeviceType'),
0x300A01B8: ('SH', '1', "Setup Device Label", '', 'SetupDeviceLabel'),
0x300A01BA: ('ST', '1', "Setup Device Description", '', 'SetupDeviceDescription'),
0x300A01BC: ('DS', '1', "Setup Device Parameter", '', 'SetupDeviceParameter'),
0x300A01D0: ('ST', '1', "Setup Reference Description", '', 'SetupReferenceDescription'),
0x300A01D2: ('DS', '1', "Table Top Vertical Setup Displacement", '', 'TableTopVerticalSetupDisplacement'),
0x300A01D4: ('DS', '1', "Table Top Longitudinal Setup Displacement", '', 'TableTopLongitudinalSetupDisplacement'),
0x300A01D6: ('DS', '1', "Table Top Lateral Setup Displacement", '', 'TableTopLateralSetupDisplacement'),
0x300A0200: ('CS', '1', "Brachy Treatment Technique", '', 'BrachyTreatmentTechnique'),
0x300A0202: ('CS', '1', "Brachy Treatment Type", '', 'BrachyTreatmentType'),
0x300A0206: ('SQ', '1', "Treatment Machine Sequence", '', 'TreatmentMachineSequence'),
0x300A0210: ('SQ', '1', "Source Sequence", '', 'SourceSequence'),
0x300A0212: ('IS', '1', "Source Number", '', 'SourceNumber'),
0x300A0214: ('CS', '1', "Source Type", '', 'SourceType'),
0x300A0216: ('LO', '1', "Source Manufacturer", '', 'SourceManufacturer'),
0x300A0218: ('DS', '1', "Active Source Diameter", '', 'ActiveSourceDiameter'),
0x300A021A: ('DS', '1', "Active Source Length", '', 'ActiveSourceLength'),
0x300A0222: ('DS', '1', "Source Encapsulation Nominal Thickness", '', 'SourceEncapsulationNominalThickness'),
0x300A0224: ('DS', '1', "Source Encapsulation Nominal Transmission", '', 'SourceEncapsulationNominalTransmission'),
0x300A0226: ('LO', '1', "Source Isotope Name", '', 'SourceIsotopeName'),
0x300A0228: ('DS', '1', "Source Isotope Half Life", '', 'SourceIsotopeHalfLife'),
0x300A0229: ('CS', '1', "Source Strength Units", '', 'SourceStrengthUnits'),
0x300A022A: ('DS', '1', "Reference Air Kerma Rate", '', 'ReferenceAirKermaRate'),
0x300A022B: ('DS', '1', "Source Strength", '', 'SourceStrength'),
0x300A022C: ('DA', '1', "Source Strength Reference Date", '', 'SourceStrengthReferenceDate'),
0x300A022E: ('TM', '1', "Source Strength Reference Time", '', 'SourceStrengthReferenceTime'),
0x300A0230: ('SQ', '1', "Application Setup Sequence", '', 'ApplicationSetupSequence'),
0x300A0232: ('CS', '1', "Application Setup Type", '', 'ApplicationSetupType'),
0x300A0234: ('IS', '1', "Application Setup Number", '', 'ApplicationSetupNumber'),
0x300A0236: ('LO', '1', "Application Setup Name", '', 'ApplicationSetupName'),
0x300A0238: ('LO', '1', "Application Setup Manufacturer", '', 'ApplicationSetupManufacturer'),
0x300A0240: ('IS', '1', "Template Number", '', 'TemplateNumber'),
0x300A0242: ('SH', '1', "Template Type", '', 'TemplateType'),
0x300A0244: ('LO', '1', "Template Name", '', 'TemplateName'),
0x300A0250: ('DS', '1', "Total Reference Air Kerma", '', 'TotalReferenceAirKerma'),
0x300A0260: ('SQ', '1', "Brachy Accessory Device Sequence", '', 'BrachyAccessoryDeviceSequence'),
0x300A0262: ('IS', '1', "Brachy Accessory Device Number", '', 'BrachyAccessoryDeviceNumber'),
0x300A0263: ('SH', '1', "Brachy Accessory Device ID", '', 'BrachyAccessoryDeviceID'),
0x300A0264: ('CS', '1', "Brachy Accessory Device Type", '', 'BrachyAccessoryDeviceType'),
0x300A0266: ('LO', '1', "Brachy Accessory Device Name", '', 'BrachyAccessoryDeviceName'),
0x300A026A: ('DS', '1', "Brachy Accessory Device Nominal Thickness", '', 'BrachyAccessoryDeviceNominalThickness'),
0x300A026C: ('DS', '1', "Brachy Accessory Device Nominal Transmission", '', 'BrachyAccessoryDeviceNominalTransmission'),
0x300A0280: ('SQ', '1', "Channel Sequence", '', 'ChannelSequence'),
0x300A0282: ('IS', '1', "Channel Number", '', 'ChannelNumber'),
0x300A0284: ('DS', '1', "Channel Length", '', 'ChannelLength'),
0x300A0286: ('DS', '1', "Channel Total Time", '', 'ChannelTotalTime'),
0x300A0288: ('CS', '1', "Source Movement Type", '', 'SourceMovementType'),
0x300A028A: ('IS', '1', "Number of Pulses", '', 'NumberOfPulses'),
0x300A028C: ('DS', '1', "Pulse Repetition Interval", '', 'PulseRepetitionInterval'),
0x300A0290: ('IS', '1', "Source Applicator Number", '', 'SourceApplicatorNumber'),
0x300A0291: ('SH', '1', "Source Applicator ID", '', 'SourceApplicatorID'),
0x300A0292: ('CS', '1', "Source Applicator Type", '', 'SourceApplicatorType'),
0x300A0294: ('LO', '1', "Source Applicator Name", '', 'SourceApplicatorName'),
0x300A0296: ('DS', '1', "Source Applicator Length", '', 'SourceApplicatorLength'),
0x300A0298: ('LO', '1', "Source Applicator Manufacturer", '', 'SourceApplicatorManufacturer'),
0x300A029C: ('DS', '1', "Source Applicator Wall Nominal Thickness", '', 'SourceApplicatorWallNominalThickness'),
0x300A029E: ('DS', '1', "Source Applicator Wall Nominal Transmission", '', 'SourceApplicatorWallNominalTransmission'),
0x300A02A0: ('DS', '1', "Source Applicator Step Size", '', 'SourceApplicatorStepSize'),
0x300A02A2: ('IS', '1', "Transfer Tube Number", '', 'TransferTubeNumber'),
0x300A02A4: ('DS', '1', "Transfer Tube Length", '', 'TransferTubeLength'),
0x300A02B0: ('SQ', '1', "Channel Shield Sequence", '', 'ChannelShieldSequence'),
0x300A02B2: ('IS', '1', "Channel Shield Number", '', 'ChannelShieldNumber'),
0x300A02B3: ('SH', '1', "Channel Shield ID", '', 'ChannelShieldID'),
0x300A02B4: ('LO', '1', "Channel Shield Name", '', 'ChannelShieldName'),
0x300A02B8: ('DS', '1', "Channel Shield Nominal Thickness", '', 'ChannelShieldNominalThickness'),
0x300A02BA: ('DS', '1', "Channel Shield Nominal Transmission", '', 'ChannelShieldNominalTransmission'),
0x300A02C8: ('DS', '1', "Final Cumulative Time Weight", '', 'FinalCumulativeTimeWeight'),
0x300A02D0: ('SQ', '1', "Brachy Control Point Sequence", '', 'BrachyControlPointSequence'),
0x300A02D2: ('DS', '1', "Control Point Relative Position", '', 'ControlPointRelativePosition'),
0x300A02D4: ('DS', '3', "Control Point 3D Position", '', 'ControlPoint3DPosition'),
0x300A02D6: ('DS', '1', "Cumulative Time Weight", '', 'CumulativeTimeWeight'),
0x300A02E0: ('CS', '1', "Compensator Divergence", '', 'CompensatorDivergence'),
0x300A02E1: ('CS', '1', "Compensator Mounting Position", '', 'CompensatorMountingPosition'),
0x300A02E2: ('DS', '1-n', "Source to Compensator Distance", '', 'SourceToCompensatorDistance'),
0x300A02E3: ('FL', '1', "Total Compensator Tray Water-Equivalent Thickness", '', 'TotalCompensatorTrayWaterEquivalentThickness'),
0x300A02E4: ('FL', '1', "Isocenter to Compensator Tray Distance", '', 'IsocenterToCompensatorTrayDistance'),
0x300A02E5: ('FL', '1', "Compensator Column Offset", '', 'CompensatorColumnOffset'),
0x300A02E6: ('FL', '1-n', "Isocenter to Compensator Distances", '', 'IsocenterToCompensatorDistances'),
0x300A02E7: ('FL', '1', "Compensator Relative Stopping Power Ratio", '', 'CompensatorRelativeStoppingPowerRatio'),
0x300A02E8: ('FL', '1', "Compensator Milling Tool Diameter", '', 'CompensatorMillingToolDiameter'),
0x300A02EA: ('SQ', '1', "Ion Range Compensator Sequence", '', 'IonRangeCompensatorSequence'),
0x300A02EB: ('LT', '1', "Compensator Description", '', 'CompensatorDescription'),
0x300A0302: ('IS', '1', "Radiation Mass Number", '', 'RadiationMassNumber'),
0x300A0304: ('IS', '1', "Radiation Atomic Number", '', 'RadiationAtomicNumber'),
0x300A0306: ('SS', '1', "Radiation Charge State", '', 'RadiationChargeState'),
0x300A0308: ('CS', '1', "Scan Mode", '', 'ScanMode'),
0x300A030A: ('FL', '2', "Virtual Source-Axis Distances", '', 'VirtualSourceAxisDistances'),
0x300A030C: ('SQ', '1', "Snout Sequence", '', 'SnoutSequence'),
0x300A030D: ('FL', '1', "Snout Position", '', 'SnoutPosition'),
0x300A030F: ('SH', '1', "Snout ID", '', 'SnoutID'),
0x300A0312: ('IS', '1', "Number of Range Shifters", '', 'NumberOfRangeShifters'),
0x300A0314: ('SQ', '1', "Range Shifter Sequence", '', 'RangeShifterSequence'),
0x300A0316: ('IS', '1', "Range Shifter Number", '', 'RangeShifterNumber'),
0x300A0318: ('SH', '1', "Range Shifter ID", '', 'RangeShifterID'),
0x300A0320: ('CS', '1', "Range Shifter Type", '', 'RangeShifterType'),
0x300A0322: ('LO', '1', "Range Shifter Description", '', 'RangeShifterDescription'),
0x300A0330: ('IS', '1', "Number of Lateral Spreading Devices", '', 'NumberOfLateralSpreadingDevices'),
0x300A0332: ('SQ', '1', "Lateral Spreading Device Sequence", '', 'LateralSpreadingDeviceSequence'),
0x300A0334: ('IS', '1', "Lateral Spreading Device Number", '', 'LateralSpreadingDeviceNumber'),
0x300A0336: ('SH', '1', "Lateral Spreading Device ID", '', 'LateralSpreadingDeviceID'),
0x300A0338: ('CS', '1', "Lateral Spreading Device Type", '', 'LateralSpreadingDeviceType'),
0x300A033A: ('LO', '1', "Lateral Spreading Device Description", '', 'LateralSpreadingDeviceDescription'),
0x300A033C: ('FL', '1', "Lateral Spreading Device Water Equivalent Thickness", '', 'LateralSpreadingDeviceWaterEquivalentThickness'),
0x300A0340: ('IS', '1', "Number of Range Modulators", '', 'NumberOfRangeModulators'),
0x300A0342: ('SQ', '1', "Range Modulator Sequence", '', 'RangeModulatorSequence'),
0x300A0344: ('IS', '1', "Range Modulator Number", '', 'RangeModulatorNumber'),
0x300A0346: ('SH', '1', "Range Modulator ID", '', 'RangeModulatorID'),
0x300A0348: ('CS', '1', "Range Modulator Type", '', 'RangeModulatorType'),
0x300A034A: ('LO', '1', "Range Modulator Description", '', 'RangeModulatorDescription'),
0x300A034C: ('SH', '1', "Beam Current Modulation ID", '', 'BeamCurrentModulationID'),
0x300A0350: ('CS', '1', "Patient Support Type", '', 'PatientSupportType'),
0x300A0352: ('SH', '1', "Patient Support ID", '', 'PatientSupportID'),
0x300A0354: ('LO', '1', "Patient Support Accessory Code", '', 'PatientSupportAccessoryCode'),
0x300A0356: ('FL', '1', "Fixation Light Azimuthal Angle", '', 'FixationLightAzimuthalAngle'),
0x300A0358: ('FL', '1', "Fixation Light Polar Angle", '', 'FixationLightPolarAngle'),
0x300A035A: ('FL', '1', "Meterset Rate", '', 'MetersetRate'),
0x300A0360: ('SQ', '1', "Range Shifter Settings Sequence", '', 'RangeShifterSettingsSequence'),
0x300A0362: ('LO', '1', "Range Shifter Setting", '', 'RangeShifterSetting'),
0x300A0364: ('FL', '1', "Isocenter to Range Shifter Distance", '', 'IsocenterToRangeShifterDistance'),
0x300A0366: ('FL', '1', "Range Shifter Water Equivalent Thickness", '', 'RangeShifterWaterEquivalentThickness'),
0x300A0370: ('SQ', '1', "Lateral Spreading Device Settings Sequence", '', 'LateralSpreadingDeviceSettingsSequence'),
0x300A0372: ('LO', '1', "Lateral Spreading Device Setting", '', 'LateralSpreadingDeviceSetting'),
0x300A0374: ('FL', '1', "Isocenter to Lateral Spreading Device Distance", '', 'IsocenterToLateralSpreadingDeviceDistance'),
0x300A0380: ('SQ', '1', "Range Modulator Settings Sequence", '', 'RangeModulatorSettingsSequence'),
0x300A0382: ('FL', '1', "Range Modulator Gating Start Value", '', 'RangeModulatorGatingStartValue'),
0x300A0384: ('FL', '1', "Range Modulator Gating Stop Value", '', 'RangeModulatorGatingStopValue'),
0x300A0386: ('FL', '1', "Range Modulator Gating Start Water Equivalent Thickness", '', 'RangeModulatorGatingStartWaterEquivalentThickness'),
0x300A0388: ('FL', '1', "Range Modulator Gating Stop Water Equivalent Thickness", '', 'RangeModulatorGatingStopWaterEquivalentThickness'),
0x300A038A: ('FL', '1', "Isocenter to Range Modulator Distance", '', 'IsocenterToRangeModulatorDistance'),
0x300A0390: ('SH', '1', "Scan Spot Tune ID", '', 'ScanSpotTuneID'),
0x300A0392: ('IS', '1', "Number of Scan Spot Positions", '', 'NumberOfScanSpotPositions'),
0x300A0394: ('FL', '1-n', "Scan Spot Position Map", '', 'ScanSpotPositionMap'),
0x300A0396: ('FL', '1-n', "Scan Spot Meterset Weights", '', 'ScanSpotMetersetWeights'),
0x300A0398: ('FL', '2', "Scanning Spot Size", '', 'ScanningSpotSize'),
0x300A039A: ('IS', '1', "Number of Paintings", '', 'NumberOfPaintings'),
0x300A03A0: ('SQ', '1', "Ion Tolerance Table Sequence", '', 'IonToleranceTableSequence'),
0x300A03A2: ('SQ', '1', "Ion Beam Sequence", '', 'IonBeamSequence'),
0x300A03A4: ('SQ', '1', "Ion Beam Limiting Device Sequence", '', 'IonBeamLimitingDeviceSequence'),
0x300A03A6: ('SQ', '1', "Ion Block Sequence", '', 'IonBlockSequence'),
0x300A03A8: ('SQ', '1', "Ion Control Point Sequence", '', 'IonControlPointSequence'),
0x300A03AA: ('SQ', '1', "Ion Wedge Sequence", '', 'IonWedgeSequence'),
0x300A03AC: ('SQ', '1', "Ion Wedge Position Sequence", '', 'IonWedgePositionSequence'),
0x300A0401: ('SQ', '1', "Referenced Setup Image Sequence", '', 'ReferencedSetupImageSequence'),
0x300A0402: ('ST', '1', "Setup Image Comment", '', 'SetupImageComment'),
0x300A0410: ('SQ', '1', "Motion Synchronization Sequence", '', 'MotionSynchronizationSequence'),
0x300A0412: ('FL', '3', "Control Point Orientation", '', 'ControlPointOrientation'),
0x300A0420: ('SQ', '1', "General Accessory Sequence", '', 'GeneralAccessorySequence'),
0x300A0421: ('SH', '1', "General Accessory ID", '', 'GeneralAccessoryID'),
0x300A0422: ('ST', '1', "General Accessory Description", '', 'GeneralAccessoryDescription'),
0x300A0423: ('CS', '1', "General Accessory Type", '', 'GeneralAccessoryType'),
0x300A0424: ('IS', '1', "General Accessory Number", '', 'GeneralAccessoryNumber'),
0x300A0431: ('SQ', '1', "Applicator Geometry Sequence", '', 'ApplicatorGeometrySequence'),
0x300A0432: ('CS', '1', "Applicator Aperture Shape", '', 'ApplicatorApertureShape'),
0x300A0433: ('FL', '1', "Applicator Opening", '', 'ApplicatorOpening'),
0x300A0434: ('FL', '1', "Applicator Opening X", '', 'ApplicatorOpeningX'),
0x300A0435: ('FL', '1', "Applicator Opening Y", '', 'ApplicatorOpeningY'),
0x300A0436: ('FL', '1', "Source to Applicator Mounting Position Distance", '', 'SourceToApplicatorMountingPositionDistance'),
0x300C0002: ('SQ', '1', "Referenced RT Plan Sequence", '', 'ReferencedRTPlanSequence'),
0x300C0004: ('SQ', '1', "Referenced Beam Sequence", '', 'ReferencedBeamSequence'),
0x300C0006: ('IS', '1', "Referenced Beam Number", '', 'ReferencedBeamNumber'),
0x300C0007: ('IS', '1', "Referenced Reference Image Number", '', 'ReferencedReferenceImageNumber'),
0x300C0008: ('DS', '1', "Start Cumulative Meterset Weight", '', 'StartCumulativeMetersetWeight'),
0x300C0009: ('DS', '1', "End Cumulative Meterset Weight", '', 'EndCumulativeMetersetWeight'),
0x300C000A: ('SQ', '1', "Referenced Brachy Application Setup Sequence", '', 'ReferencedBrachyApplicationSetupSequence'),
0x300C000C: ('IS', '1', "Referenced Brachy Application Setup Number", '', 'ReferencedBrachyApplicationSetupNumber'),
0x300C000E: ('IS', '1', "Referenced Source Number", '', 'ReferencedSourceNumber'),
0x300C0020: ('SQ', '1', "Referenced Fraction Group Sequence", '', 'ReferencedFractionGroupSequence'),
0x300C0022: ('IS', '1', "Referenced Fraction Group Number", '', 'ReferencedFractionGroupNumber'),
0x300C0040: ('SQ', '1', "Referenced Verification Image Sequence", '', 'ReferencedVerificationImageSequence'),
0x300C0042: ('SQ', '1', "Referenced Reference Image Sequence", '', 'ReferencedReferenceImageSequence'),
0x300C0050: ('SQ', '1', "Referenced Dose Reference Sequence", '', 'ReferencedDoseReferenceSequence'),
0x300C0051: ('IS', '1', "Referenced Dose Reference Number", '', 'ReferencedDoseReferenceNumber'),
0x300C0055: ('SQ', '1', "Brachy Referenced Dose Reference Sequence", '', 'BrachyReferencedDoseReferenceSequence'),
0x300C0060: ('SQ', '1', "Referenced Structure Set Sequence", '', 'ReferencedStructureSetSequence'),
0x300C006A: ('IS', '1', "Referenced Patient Setup Number", '', 'ReferencedPatientSetupNumber'),
0x300C0080: ('SQ', '1', "Referenced Dose Sequence", '', 'ReferencedDoseSequence'),
0x300C00A0: ('IS', '1', "Referenced Tolerance Table Number", '', 'ReferencedToleranceTableNumber'),
0x300C00B0: ('SQ', '1', "Referenced Bolus Sequence", '', 'ReferencedBolusSequence'),
0x300C00C0: ('IS', '1', "Referenced Wedge Number", '', 'ReferencedWedgeNumber'),
0x300C00D0: ('IS', '1', "Referenced Compensator Number", '', 'ReferencedCompensatorNumber'),
0x300C00E0: ('IS', '1', "Referenced Block Number", '', 'ReferencedBlockNumber'),
0x300C00F0: ('IS', '1', "Referenced Control Point Index", '', 'ReferencedControlPointIndex'),
0x300C00F2: ('SQ', '1', "Referenced Control Point Sequence", '', 'ReferencedControlPointSequence'),
0x300C00F4: ('IS', '1', "Referenced Start Control Point Index", '', 'ReferencedStartControlPointIndex'),
0x300C00F6: ('IS', '1', "Referenced Stop Control Point Index", '', 'ReferencedStopControlPointIndex'),
0x300C0100: ('IS', '1', "Referenced Range Shifter Number", '', 'ReferencedRangeShifterNumber'),
0x300C0102: ('IS', '1', "Referenced Lateral Spreading Device Number", '', 'ReferencedLateralSpreadingDeviceNumber'),
0x300C0104: ('IS', '1', "Referenced Range Modulator Number", '', 'ReferencedRangeModulatorNumber'),
0x300E0002: ('CS', '1', "Approval Status", '', 'ApprovalStatus'),
0x300E0004: ('DA', '1', "Review Date", '', 'ReviewDate'),
0x300E0005: ('TM', '1', "Review Time", '', 'ReviewTime'),
0x300E0008: ('PN', '1', "Reviewer Name", '', 'ReviewerName'),
0x40000010: ('LT', '1', "Arbitrary", 'Retired', 'Arbitrary'),
0x40004000: ('LT', '1', "Text Comments", 'Retired', 'TextComments'),
0x40080040: ('SH', '1', "Results ID", 'Retired', 'ResultsID'),
0x40080042: ('LO', '1', "Results ID Issuer", 'Retired', 'ResultsIDIssuer'),
0x40080050: ('SQ', '1', "Referenced Interpretation Sequence", 'Retired', 'ReferencedInterpretationSequence'),
0x400800FF: ('CS', '1', "Report Production Status (Trial)", 'Retired', 'ReportProductionStatusTrial'),
0x40080100: ('DA', '1', "Interpretation Recorded Date", 'Retired', 'InterpretationRecordedDate'),
0x40080101: ('TM', '1', "Interpretation Recorded Time", 'Retired', 'InterpretationRecordedTime'),
0x40080102: ('PN', '1', "Interpretation Recorder", 'Retired', 'InterpretationRecorder'),
0x40080103: ('LO', '1', "Reference to Recorded Sound", 'Retired', 'ReferenceToRecordedSound'),
0x40080108: ('DA', '1', "Interpretation Transcription Date", 'Retired', 'InterpretationTranscriptionDate'),
0x40080109: ('TM', '1', "Interpretation Transcription Time", 'Retired', 'InterpretationTranscriptionTime'),
0x4008010A: ('PN', '1', "Interpretation Transcriber", 'Retired', 'InterpretationTranscriber'),
0x4008010B: ('ST', '1', "Interpretation Text", 'Retired', 'InterpretationText'),
0x4008010C: ('PN', '1', "Interpretation Author", 'Retired', 'InterpretationAuthor'),
0x40080111: ('SQ', '1', "Interpretation Approver Sequence", 'Retired', 'InterpretationApproverSequence'),
0x40080112: ('DA', '1', "Interpretation Approval Date", 'Retired', 'InterpretationApprovalDate'),
0x40080113: ('TM', '1', "Interpretation Approval Time", 'Retired', 'InterpretationApprovalTime'),
0x40080114: ('PN', '1', "Physician Approving Interpretation", 'Retired', 'PhysicianApprovingInterpretation'),
0x40080115: ('LT', '1', "Interpretation Diagnosis Description", 'Retired', 'InterpretationDiagnosisDescription'),
0x40080117: ('SQ', '1', "Interpretation Diagnosis Code Sequence", 'Retired', 'InterpretationDiagnosisCodeSequence'),
0x40080118: ('SQ', '1', "Results Distribution List Sequence", 'Retired', 'ResultsDistributionListSequence'),
0x40080119: ('PN', '1', "Distribution Name", 'Retired', 'DistributionName'),
0x4008011A: ('LO', '1', "Distribution Address", 'Retired', 'DistributionAddress'),
0x40080200: ('SH', '1', "Interpretation ID", 'Retired', 'InterpretationID'),
0x40080202: ('LO', '1', "Interpretation ID Issuer", 'Retired', 'InterpretationIDIssuer'),
0x40080210: ('CS', '1', "Interpretation Type ID", 'Retired', 'InterpretationTypeID'),
0x40080212: ('CS', '1', "Interpretation Status ID", 'Retired', 'InterpretationStatusID'),
0x40080300: ('ST', '1', "Impressions", 'Retired', 'Impressions'),
0x40084000: ('ST', '1', "Results Comments", 'Retired', 'ResultsComments'),
0x40100001: ('CS', '1', "Low Energy Detectors", '', 'LowEnergyDetectors'),
0x40100002: ('CS', '1', "High Energy Detectors", '', 'HighEnergyDetectors'),
0x40100004: ('SQ', '1', "Detector Geometry Sequence", '', 'DetectorGeometrySequence'),
0x40101001: ('SQ', '1', "Threat ROI Voxel Sequence", '', 'ThreatROIVoxelSequence'),
0x40101004: ('FL', '3', "Threat ROI Base", '', 'ThreatROIBase'),
0x40101005: ('FL', '3', "Threat ROI Extents", '', 'ThreatROIExtents'),
0x40101006: ('OB', '1', "Threat ROI Bitmap", '', 'ThreatROIBitmap'),
0x40101007: ('SH', '1', "Route Segment ID", '', 'RouteSegmentID'),
0x40101008: ('CS', '1', "Gantry Type", '', 'GantryType'),
0x40101009: ('CS', '1', "OOI Owner Type", '', 'OOIOwnerType'),
0x4010100A: ('SQ', '1', "Route Segment Sequence", '', 'RouteSegmentSequence'),
0x40101010: ('US', '1', "Potential Threat Object ID", '', 'PotentialThreatObjectID'),
0x40101011: ('SQ', '1', "Threat Sequence", '', 'ThreatSequence'),
0x40101012: ('CS', '1', "Threat Category", '', 'ThreatCategory'),
0x40101013: ('LT', '1', "Threat Category Description", '', 'ThreatCategoryDescription'),
0x40101014: ('CS', '1', "ATD Ability Assessment", '', 'ATDAbilityAssessment'),
0x40101015: ('CS', '1', "ATD Assessment Flag", '', 'ATDAssessmentFlag'),
0x40101016: ('FL', '1', "ATD Assessment Probability", '', 'ATDAssessmentProbability'),
0x40101017: ('FL', '1', "Mass", '', 'Mass'),
0x40101018: ('FL', '1', "Density", '', 'Density'),
0x40101019: ('FL', '1', "Z Effective", '', 'ZEffective'),
0x4010101A: ('SH', '1', "Boarding Pass ID", '', 'BoardingPassID'),
0x4010101B: ('FL', '3', "Center of Mass", '', 'CenterOfMass'),
0x4010101C: ('FL', '3', "Center of PTO", '', 'CenterOfPTO'),
0x4010101D: ('FL', '6-n', "Bounding Polygon", '', 'BoundingPolygon'),
0x4010101E: ('SH', '1', "Route Segment Start Location ID", '', 'RouteSegmentStartLocationID'),
0x4010101F: ('SH', '1', "Route Segment End Location ID", '', 'RouteSegmentEndLocationID'),
0x40101020: ('CS', '1', "Route Segment Location ID Type", '', 'RouteSegmentLocationIDType'),
0x40101021: ('CS', '1-n', "Abort Reason", '', 'AbortReason'),
0x40101023: ('FL', '1', "Volume of PTO", '', 'VolumeOfPTO'),
0x40101024: ('CS', '1', "Abort Flag", '', 'AbortFlag'),
0x40101025: ('DT', '1', "Route Segment Start Time", '', 'RouteSegmentStartTime'),
0x40101026: ('DT', '1', "Route Segment End Time", '', 'RouteSegmentEndTime'),
0x40101027: ('CS', '1', "TDR Type", '', 'TDRType'),
0x40101028: ('CS', '1', "International Route Segment", '', 'InternationalRouteSegment'),
0x40101029: ('LO', '1-n', "Threat Detection Algorithm and Version", '', 'ThreatDetectionAlgorithmandVersion'),
0x4010102A: ('SH', '1', "Assigned Location", '', 'AssignedLocation'),
0x4010102B: ('DT', '1', "Alarm Decision Time", '', 'AlarmDecisionTime'),
0x40101031: ('CS', '1', "Alarm Decision", '', 'AlarmDecision'),
0x40101033: ('US', '1', "Number of Total Objects", '', 'NumberOfTotalObjects'),
0x40101034: ('US', '1', "Number of Alarm Objects", '', 'NumberOfAlarmObjects'),
0x40101037: ('SQ', '1', "PTO Representation Sequence", '', 'PTORepresentationSequence'),
0x40101038: ('SQ', '1', "ATD Assessment Sequence", '', 'ATDAssessmentSequence'),
0x40101039: ('CS', '1', "TIP Type", '', 'TIPType'),
0x4010103A: ('CS', '1', "DICOS Version", '', 'DICOSVersion'),
0x40101041: ('DT', '1', "OOI Owner Creation Time", '', 'OOIOwnerCreationTime'),
0x40101042: ('CS', '1', "OOI Type", '', 'OOIType'),
0x40101043: ('FL', '3', "OOI Size", '', 'OOISize'),
0x40101044: ('CS', '1', "Acquisition Status", '', 'AcquisitionStatus'),
0x40101045: ('SQ', '1', "Basis Materials Code Sequence", '', 'BasisMaterialsCodeSequence'),
0x40101046: ('CS', '1', "Phantom Type", '', 'PhantomType'),
0x40101047: ('SQ', '1', "OOI Owner Sequence", '', 'OOIOwnerSequence'),
0x40101048: ('CS', '1', "Scan Type", '', 'ScanType'),
0x40101051: ('LO', '1', "Itinerary ID", '', 'ItineraryID'),
0x40101052: ('SH', '1', "Itinerary ID Type", '', 'ItineraryIDType'),
0x40101053: ('LO', '1', "Itinerary ID Assigning Authority", '', 'ItineraryIDAssigningAuthority'),
0x40101054: ('SH', '1', "Route ID", '', 'RouteID'),
0x40101055: ('SH', '1', "Route ID Assigning Authority", '', 'RouteIDAssigningAuthority'),
0x40101056: ('CS', '1', "Inbound  Arrival Type", '', 'InboundArrivalType'),
0x40101058: ('SH', '1', "Carrier ID", '', 'CarrierID'),
0x40101059: ('CS', '1', "Carrier ID Assigning Authority", '', 'CarrierIDAssigningAuthority'),
0x40101060: ('FL', '3', "Source Orientation", '', 'SourceOrientation'),
0x40101061: ('FL', '3', "Source Position", '', 'SourcePosition'),
0x40101062: ('FL', '1', "Belt Height", '', 'BeltHeight'),
0x40101064: ('SQ', '1', "Algorithm Routing Code Sequence", '', 'AlgorithmRoutingCodeSequence'),
0x40101067: ('CS', '1', "Transport Classification", '', 'TransportClassification'),
0x40101068: ('LT', '1', "OOI Type Descriptor", '', 'OOITypeDescriptor'),
0x40101069: ('FL', '1', "Total Processing Time", '', 'TotalProcessingTime'),
0x4010106C: ('OB', '1', "Detector Calibration Data", '', 'DetectorCalibrationData'),
0x4FFE0001: ('SQ', '1', "MAC Parameters Sequence", '', 'MACParametersSequence'),
0x52009229: ('SQ', '1', "Shared Functional Groups Sequence", '', 'SharedFunctionalGroupsSequence'),
0x52009230: ('SQ', '1', "Per-frame Functional Groups Sequence", '', 'PerFrameFunctionalGroupsSequence'),
0x54000100: ('SQ', '1', "Waveform Sequence", '', 'WaveformSequence'),
0x54000110: ('OB or OW', '1', "Channel Minimum Value", '', 'ChannelMinimumValue'),
0x54000112: ('OB or OW', '1', "Channel Maximum Value", '', 'ChannelMaximumValue'),
0x54001004: ('US', '1', "Waveform Bits Allocated", '', 'WaveformBitsAllocated'),
0x54001006: ('CS', '1', "Waveform Sample Interpretation", '', 'WaveformSampleInterpretation'),
0x5400100A: ('OB or OW', '1', "Waveform Padding Value", '', 'WaveformPaddingValue'),
0x54001010: ('OB or OW', '1', "Waveform Data", '', 'WaveformData'),
0x56000010: ('OF', '1', "First Order Phase Correction Angle", '', 'FirstOrderPhaseCorrectionAngle'),
0x56000020: ('OF', '1', "Spectroscopy Data", '', 'SpectroscopyData'),
0x7FE00010: ('OW or OB', '1', "Pixel Data", '', 'PixelData'),
0x7FE00020: ('OW', '1', "Coefficients SDVN", 'Retired', 'CoefficientsSDVN'),
0x7FE00030: ('OW', '1', "Coefficients SDHN", 'Retired', 'CoefficientsSDHN'),
0x7FE00040: ('OW', '1', "Coefficients SDDN", 'Retired', 'CoefficientsSDDN'),
0xFFFAFFFA: ('SQ', '1', "Digital Signatures Sequence", '', 'DigitalSignaturesSequence'),
0xFFFCFFFC: ('OB', '1', "Data Set Trailing Padding", '', 'DataSetTrailingPadding'),
0xFFFEE000: ('NONE', '1', "Item", '', 'Item'),
0xFFFEE00D: ('NONE', '1', "Item Delimitation Item", '', 'ItemDelimitationItem'),
0xFFFEE0DD: ('NONE', '1', "Sequence Delimitation Item", '', 'SequenceDelimitationItem')}

RepeatersDictionary = {
'002031xx': ('CS', '1-n', "Source Image IDs", 'Retired', 'SourceImageIDs'),
'002804x0': ('US', '1', "Rows For Nth Order Coefficients", 'Retired', 'RowsForNthOrderCoefficients'),
'002804x1': ('US', '1', "Columns For Nth Order Coefficients", 'Retired', 'ColumnsForNthOrderCoefficients'),
'002804x2': ('LO', '1-n', "Coefficient Coding", 'Retired', 'CoefficientCoding'),
'002804x3': ('AT', '1-n', "Coefficient Coding Pointers", 'Retired', 'CoefficientCodingPointers'),
'002808x0': ('CS', '1-n', "Code Label", 'Retired', 'CodeLabel'),
'002808x2': ('US', '1', "Number of Tables", 'Retired', 'NumberOfTables'),
'002808x3': ('AT', '1-n', "Code Table Location", 'Retired', 'CodeTableLocation'),
'002808x4': ('US', '1', "Bits For Code Word", 'Retired', 'BitsForCodeWord'),
'002808x8': ('AT', '1-n', "Image Data Location", 'Retired', 'ImageDataLocation'),
'1000xxx0': ('US', '3', "Escape Triplet", 'Retired', 'EscapeTriplet'),
'1000xxx1': ('US', '3', "Run Length Triplet", 'Retired', 'RunLengthTriplet'),
'1000xxx2': ('US', '1', "Huffman Table Size", 'Retired', 'HuffmanTableSize'),
'1000xxx3': ('US', '3', "Huffman Table Triplet", 'Retired', 'HuffmanTableTriplet'),
'1000xxx4': ('US', '1', "Shift Table Size", 'Retired', 'ShiftTableSize'),
'1000xxx5': ('US', '3', "Shift Table Triplet", 'Retired', 'ShiftTableTriplet'),
'1010xxxx': ('US', '1-n', "Zonal Map", 'Retired', 'ZonalMap'),
'50xx0005': ('US', '1', "Curve Dimensions", 'Retired', 'CurveDimensions'),
'50xx0010': ('US', '1', "Number of Points", 'Retired', 'NumberOfPoints'),
'50xx0020': ('CS', '1', "Type of Data", 'Retired', 'TypeOfData'),
'50xx0022': ('LO', '1', "Curve Description", 'Retired', 'CurveDescription'),
'50xx0030': ('SH', '1-n', "Axis Units", 'Retired', 'AxisUnits'),
'50xx0040': ('SH', '1-n', "Axis Labels", 'Retired', 'AxisLabels'),
'50xx0103': ('US', '1', "Data Value Representation", 'Retired', 'DataValueRepresentation'),
'50xx0104': ('US', '1-n', "Minimum Coordinate Value", 'Retired', 'MinimumCoordinateValue'),
'50xx0105': ('US', '1-n', "Maximum Coordinate Value", 'Retired', 'MaximumCoordinateValue'),
'50xx0106': ('SH', '1-n', "Curve Range", 'Retired', 'CurveRange'),
'50xx0110': ('US', '1-n', "Curve Data Descriptor", 'Retired', 'CurveDataDescriptor'),
'50xx0112': ('US', '1-n', "Coordinate Start Value", 'Retired', 'CoordinateStartValue'),
'50xx0114': ('US', '1-n', "Coordinate Step Value", 'Retired', 'CoordinateStepValue'),
'50xx1001': ('CS', '1', "Curve Activation Layer", 'Retired', 'CurveActivationLayer'),
'50xx2000': ('US', '1', "Audio Type", 'Retired', 'AudioType'),
'50xx2002': ('US', '1', "Audio Sample Format", 'Retired', 'AudioSampleFormat'),
'50xx2004': ('US', '1', "Number of Channels", 'Retired', 'NumberOfChannels'),
'50xx2006': ('UL', '1', "Number of Samples", 'Retired', 'NumberOfSamples'),
'50xx2008': ('UL', '1', "Sample Rate", 'Retired', 'SampleRate'),
'50xx200A': ('UL', '1', "Total Time", 'Retired', 'TotalTime'),
'50xx200C': ('OW or OB', '1', "Audio Sample Data", 'Retired', 'AudioSampleData'),
'50xx200E': ('LT', '1', "Audio Comments", 'Retired', 'AudioComments'),
'50xx2500': ('LO', '1', "Curve Label", 'Retired', 'CurveLabel'),
'50xx2600': ('SQ', '1', "Curve Referenced Overlay Sequence", 'Retired', 'CurveReferencedOverlaySequence'),
'50xx2610': ('US', '1', "Curve Referenced Overlay Group", 'Retired', 'CurveReferencedOverlayGroup'),
'50xx3000': ('OW or OB', '1', "Curve Data", 'Retired', 'CurveData'),
'60xx0010': ('US', '1', "Overlay Rows", '', 'OverlayRows'),
'60xx0011': ('US', '1', "Overlay Columns", '', 'OverlayColumns'),
'60xx0012': ('US', '1', "Overlay Planes", 'Retired', 'OverlayPlanes'),
'60xx0015': ('IS', '1', "Number of Frames in Overlay", '', 'NumberOfFramesInOverlay'),
'60xx0022': ('LO', '1', "Overlay Description", '', 'OverlayDescription'),
'60xx0040': ('CS', '1', "Overlay Type", '', 'OverlayType'),
'60xx0045': ('LO', '1', "Overlay Subtype", '', 'OverlaySubtype'),
'60xx0050': ('SS', '2', "Overlay Origin", '', 'OverlayOrigin'),
'60xx0051': ('US', '1', "Image Frame Origin", '', 'ImageFrameOrigin'),
'60xx0052': ('US', '1', "Overlay Plane Origin", 'Retired', 'OverlayPlaneOrigin'),
'60xx0060': ('CS', '1', "Overlay Compression Code", 'Retired', 'OverlayCompressionCode'),
'60xx0061': ('SH', '1', "Overlay Compression Originator", 'Retired', 'OverlayCompressionOriginator'),
'60xx0062': ('SH', '1', "Overlay Compression Label", 'Retired', 'OverlayCompressionLabel'),
'60xx0063': ('CS', '1', "Overlay Compression Description", 'Retired', 'OverlayCompressionDescription'),
'60xx0066': ('AT', '1-n', "Overlay Compression Step Pointers", 'Retired', 'OverlayCompressionStepPointers'),
'60xx0068': ('US', '1', "Overlay Repeat Interval", 'Retired', 'OverlayRepeatInterval'),
'60xx0069': ('US', '1', "Overlay Bits Grouped", 'Retired', 'OverlayBitsGrouped'),
'60xx0100': ('US', '1', "Overlay Bits Allocated", '', 'OverlayBitsAllocated'),
'60xx0102': ('US', '1', "Overlay Bit Position", '', 'OverlayBitPosition'),
'60xx0110': ('CS', '1', "Overlay Format", 'Retired', 'OverlayFormat'),
'60xx0200': ('US', '1', "Overlay Location", 'Retired', 'OverlayLocation'),
'60xx0800': ('CS', '1-n', "Overlay Code Label", 'Retired', 'OverlayCodeLabel'),
'60xx0802': ('US', '1', "Overlay Number of Tables", 'Retired', 'OverlayNumberOfTables'),
'60xx0803': ('AT', '1-n', "Overlay Code Table Location", 'Retired', 'OverlayCodeTableLocation'),
'60xx0804': ('US', '1', "Overlay Bits For Code Word", 'Retired', 'OverlayBitsForCodeWord'),
'60xx1001': ('CS', '1', "Overlay Activation Layer", '', 'OverlayActivationLayer'),
'60xx1100': ('US', '1', "Overlay Descriptor - Gray", 'Retired', 'OverlayDescriptorGray'),
'60xx1101': ('US', '1', "Overlay Descriptor - Red", 'Retired', 'OverlayDescriptorRed'),
'60xx1102': ('US', '1', "Overlay Descriptor - Green", 'Retired', 'OverlayDescriptorGreen'),
'60xx1103': ('US', '1', "Overlay Descriptor - Blue", 'Retired', 'OverlayDescriptorBlue'),
'60xx1200': ('US', '1-n', "Overlays - Gray", 'Retired', 'OverlaysGray'),
'60xx1201': ('US', '1-n', "Overlays - Red", 'Retired', 'OverlaysRed'),
'60xx1202': ('US', '1-n', "Overlays - Green", 'Retired', 'OverlaysGreen'),
'60xx1203': ('US', '1-n', "Overlays - Blue", 'Retired', 'OverlaysBlue'),
'60xx1301': ('IS', '1', "ROI Area", '', 'ROIArea'),
'60xx1302': ('DS', '1', "ROI Mean", '', 'ROIMean'),
'60xx1303': ('DS', '1', "ROI Standard Deviation", '', 'ROIStandardDeviation'),
'60xx1500': ('LO', '1', "Overlay Label", '', 'OverlayLabel'),
'60xx3000': ('OB or OW', '1', "Overlay Data", '', 'OverlayData'),
'60xx4000': ('LT', '1', "Overlay Comments", 'Retired', 'OverlayComments'),
'7Fxx0010': ('OW or OB', '1', "Variable Pixel Data", 'Retired', 'VariablePixelData'),
'7Fxx0011': ('US', '1', "Variable Next Data Group", 'Retired', 'VariableNextDataGroup'),
'7Fxx0020': ('OW', '1', "Variable Coefficients SDVN", 'Retired', 'VariableCoefficientsSDVN'),
'7Fxx0030': ('OW', '1', "Variable Coefficients SDHN", 'Retired', 'VariableCoefficientsSDHN'),
'7Fxx0040': ('OW', '1', "Variable Coefficients SDDN", 'Retired', 'VariableCoefficientsSDDN')}
