{% comment %}
# SPDX-License-Identifier: AGPL-3.0-or-later
{% endcomment %}

{% load i18n %}

<table class="table table-bordered table-condensed table-striped"
       id="archives-list">
  <thead class="collapsible-button" data-toggle="collapse" data-target="#{{ uuid }}">
    <tr>
      <th colspan="2">
        <span class="fa fa-chevron-right fa-fw" aria-hidden="true"></span>
        {% if repository.error %}
          <span class="fa fa-exclamation-triangle mount-error"
                aria-hidden="true" title="{{ repository.error }}">
          </span>
        {% elif repository.is_encrypted %}
          <span class="fa fa-lock encrypted"
                aria-hidden="true" title="{% trans "This repository is encrypted" %}">
          </span>
        {% endif %}

        {{ repository.name }}

        <span class="pull-right">
          {% if repository.flags.mountable %}

            {% if repository.mounted %}

              <form action="{% url 'backups:repository-umount' uuid %}" method="POST"
                    class="inline-block" >
                {% csrf_token %}
                <button type="submit" class="btn btn-sm btn-default"
                       title="{% trans 'Unmount Location' %}">
                  <span class="fa fa-eject" aria-hidden="true"></span>
                </button>
              </form>

            {% else %}

              <form action="{% url 'backups:repository-mount' uuid %}" method="POST"
                    class="inline-block" >
                {% csrf_token %}
                <button type="submit" class="btn btn-sm btn-default"
                        title="{% trans 'Mount Location' %}">
                  <span class="fa fa-eye" aria-hidden="true"></span>
                </button>
              </form>

            {% endif %}

          {% endif %}

          {% if repository.flags.removable %}

            <a title="{% trans 'Remove Backup Location. This will not delete the remote backup.' %}"
               role="button" class="repository-remove btn btn-sm btn-default"
               href="{% url 'backups:repository-remove' uuid %}">
              <span class="fa fa-trash-o" aria-hidden="true"></span>
            </a>

          {% endif %}
        </span>
      </th>
    </tr>
  </thead>

  <tbody class="collapse in" id="{{ uuid }}">
    {% if repository.mounted %}

      {% for archive in repository.archives %}
        <tr id="archive-{{ archive.name }}" class="archive">
          <td class="archive-name">{{ archive.name }}</td>
          <td class="archive-operations">
            <a class="archive-export btn btn-sm btn-default" target="_blank"
               href="{% url 'backups:download' uuid archive.name %}">
              {% trans "Download" %}
            </a>
            <a class="archive-export btn btn-sm btn-default"
               href="{% url 'backups:restore-archive' uuid archive.name %}">
              {% trans "Restore" %}
            </a>
            <a class="archive-delete btn btn-sm btn-default"
               href="{% url 'backups:delete' uuid archive.name %}">
              <span class="fa fa-trash-o" aria-hidden="true">
              </span>
            </a>
          </td>
        </tr>
      {% endfor %}

      {% if repository.error %}
        <tr>
          <td>
            <p>{{ repository.error }}</p>
          </td>
        </tr>
      {% endif %}

      {% if not repository.error and not repository.archives %}
        <tr>
          <td>
            <p>{% trans 'No archives currently exist.' %}</p>
          </td>
        </tr>
      {% endif %}

    {% endif %}
  </tbody>
</table>
