/***************************************************************************
 *   By Karthik Paithankar <biophysics@hotmail.com>     *
 *   A lot of code was used from weatherplasmoid. Thanks to                *
 *                         Vinnie Futia <rowancompsciguy@gmail.com>        *
 *
 *   Credits to Vinnie Futia <rowancompsciguy@gmail.com>        *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/

// Here we avoid loading the header multiple times
#ifndef Plasma_Weather_HEADER
#define Plasma_Weather_HEADER

// We need the Plasma Applet headers
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <QTimer>
#include <KConfigDialog>
//#include <QWidget>

#include "ui_config.h"
#include "config.h"

 
class QSizeF;
class QTimer;
 
class Plasma_Weather : public Plasma::Applet
{
    Q_OBJECT
    public:
        // Basic Create/Destroy
        Plasma_Weather(QObject *parent, const QVariantList &args);
        ~Plasma_Weather();

        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
        void init();
        QSizeF contentSizeHint() const;
        Qt::Orientations expandingDirections() const;

    public slots:
        void refresh();
        void configAccepted();
        void configRejected();

    protected:
        void createConfigurationInterface(KConfigDialog *parent);

    private:
//        void paintImage(QPainter *p, const QRect &contentsRect);
        void collectData();
        void readConfigData();
        void parseData();
        QString region;
        QString country;
        QString city;
        QString tempType;
        QString chill;
        QString temperature;
        QString tomorrow_day;
        QString tomorrow_code;
        QString d_a_t;
        QString d_a_t_low;
        QString d_a_t_high;
        QString d_a_t_condition;
        QString d_a_t_code;
        QString attribution_text;
        QString temperature_tomorrow_low;
        QString temperature_tomorrow_high;
        QString temperature_tomorrow_condition;
        QString condition;
        QString humidity;
        QString iconTheme;
        QString zip;
        QString today_code;
        QString updateFrequency;
        QTimer* timer;
	QFont font;
//        QFont titleFont;
//        QFont tempFont; 
        ConfigDialog* conf;
};
 
// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(simpleweatherforecast, Plasma_Weather)
#endif 
