/*	Fields_Map_test

CVS ID: Fields_Map_test.java,v 1.4 2012/04/16 06:08:57 castalia Exp


Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Database.Fields_Map;
import	PIRL.Database.Database_Exception;
import	PIRL.Utilities.Checker;

import	java.util.Vector;


public class Fields_Map_test
{
public static void main (String[] arguments) 
{
System.out.println ("*** Fields_Map_test: " + Fields_Map.ID);
Checker
	checker = new Checker ();
if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

Fields_Map
	map = null;
Vector
	user_fields = null,
	actual_fields = null,
	record;

try
{
//	Constructor

try
	{
	map = new Fields_Map (user_fields, actual_fields);
	System.out.println
		("FAIL: null argument exception for map = new Fields_Map (null, null)");
	if (checker.Verbose)
		System.out.println
			("===> expected: IllegalArgumentException\n"
			+"===> obtained: No exception");
	}
catch (IllegalArgumentException exception)
	{
	checker.Checks_Passed++;
	System.out.println
		("PASS: null argument exception for map = new Fields_Map (null, null)");
	if (checker.Verbose)
		System.out.println
			("===> expected: IllegalArgumentException\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;

user_fields = new Vector (4);
user_fields.add ("u0-a1");
user_fields.add ("u1-a0");
user_fields.add ("u2-nomap");
user_fields.add ((String)null);

actual_fields = new Vector (4);
actual_fields.add ("u1-a0");
actual_fields.add ("u0-a1");
actual_fields.add ("a2-nomap");
actual_fields.add ((String)null);

try
	{
	map = new Fields_Map (user_fields, actual_fields, false);
	checker.Checks_Passed++;
	System.out.println ("PASS: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", false)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: no exception");
	}
catch (IllegalArgumentException exception)
	{
	System.out.println ("FAIL: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", false)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;


//	index

checker.Check ("map.index (0)",
	1, map.index (0));
checker.Check ("map.index (1)",
	0, map.index (1));
checker.Check ("map.index (2)",
	-1, map.index (2));
checker.Check ("map.index (3)",
	3, map.index (3));
checker.Check ("map.index (4)",
	-1, map.index (4));

checker.Check ("map.index (\"" + (String)user_fields.get (0) + "\")",
	1, map.index ((String)user_fields.get (0)));
checker.Check ("map.index (\"" + (String)user_fields.get (1) + "\")",
	0, map.index ((String)user_fields.get (1)));
checker.Check ("map.index (\"" + (String)user_fields.get (2) + "\")",
	-1, map.index ((String)user_fields.get (2)));
checker.Check ("map.index ((String)null)",
	3, map.index ((String)null));
checker.Check ("map.index (\"foo\")",
	-1, map.index ("foo"));


//	entry

record = new Vector (4);
record.add ("First");
record.add ("Second");
record.add ("Third");
record.add ("Fourth");

checker.Check ("map.entry (" + record + ", 1)",
	(String)record.get (0), map.entry (record, 1));
checker.Check ("map.entry (" + record + ", 4)",
	(String)null, map.entry (record, 4));

checker.Check ("map.entry (" + record + ", \"" + (String)user_fields.get (0) + "\")",
	(String)record.get (1), map.entry (record, (String)user_fields.get (0)));
checker.Check ("map.entry (" + record + ", (String)null)",
	(String)record.get (3), map.entry (record, (String)null));


//	All/User_Fields

record = new Vector (user_fields);
checker.Check ("map.All_User_Fields ()",
	record, map.All_User_Fields ());
record.remove (2);
checker.Check ("map.User_Fields ()",
	record, map.User_Fields ());


//	All/Actual_Fields

record = new Vector (actual_fields);
checker.Check ("map.All_Actual_Fields ()",
	record, map.All_Actual_Fields ());
record.remove (2);
checker.Check ("map.Actual_Fields ()",
	record, map.Actual_Fields ());


//	Actual_to_User

try
	{
	map.Actual_to_User (record);
	System.out.println ("FAIL: short record exception for map.Actual_to_User ("
		+ record + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: IllegalArgumentException\n"
			+"===> obtained: No exception");
	}
catch (IllegalArgumentException exception)
	{
	checker.Checks_Passed++;
	System.out.println ("PASS: short record exception for map.Actual_to_User ("
		+ record + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: IllegalArgumentException\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;

user_fields.set (2, (String)null);
checker.Check ("map.Actual_to_User (" + actual_fields + ")",
	user_fields, map.Actual_to_User (actual_fields));

try
	{
	map.Confirm_Fields (user_fields);
	checker.Checks_Passed++;
	System.out.println ("PASS: map.Confirm_Fields (" + user_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: no exception");
	}
catch (Database_Exception exception)
	{
	System.out.println ("FAIL: map.Confirm_Fields (" + user_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;


//	Confirm_Fields

try
	{
	map.Confirm_Fields (actual_fields);
	System.out.println ("FAIL: map.Confirm_Fields (" + actual_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: Database_Exception\n"
			+"===> obtained: no exception");
	}
catch (Database_Exception exception)
	{
	checker.Checks_Passed++;
	System.out.println ("PASS: map.Confirm_Fields (" + actual_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: Database_Exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;

actual_fields.remove (2);
try
	{
	map.Confirm_Fields (actual_fields);
	checker.Checks_Passed++;
	System.out.println ("PASS: map.Confirm_Fields (" + actual_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: no exception");
	}
catch (Database_Exception exception)
	{
	System.out.println ("FAIL: map.Confirm_Fields (" + actual_fields + ")");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;


//	Case_Sensitive - false

user_fields = new Vector (2);
user_fields.add ("U0-A1");
user_fields.add ("u1-a0");

actual_fields = new Vector (2);
actual_fields.add ("u1-a0");
actual_fields.add ("u0-a1");

try
	{
	map = new Fields_Map (user_fields, actual_fields, false);
	checker.Checks_Passed++;
	System.out.println ("PASS: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", false)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: no exception");
	}
catch (IllegalArgumentException exception)
	{
	System.out.println ("FAIL: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", false)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;

checker.Check ("map.index (\"" + (String)user_fields.get (0) + "\")",
	1, map.index ((String)user_fields.get (0)));
checker.Check ("map.index (\"" + (String)user_fields.get (1) + "\")",
	0, map.index ((String)user_fields.get (1)));


//	Case_Sensitive - true

try
	{
	map = new Fields_Map (user_fields, actual_fields, true);
	checker.Checks_Passed++;
	System.out.println ("PASS: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", true)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: no exception");
	}
catch (IllegalArgumentException exception)
	{
	System.out.println ("FAIL: map = new Fields_Map ("
		+ user_fields +", " + actual_fields + ", true)");
	if (checker.Verbose)
		System.out.println
			("===> expected: no exception\n"
			+"===> obtained: " + exception);
	}
checker.Checks_Total++;

checker.Check ("map.index (\"" + (String)user_fields.get (0) + "\")",
	-1, map.index ((String)user_fields.get (0)));
checker.Check ("map.index (\"" + (String)user_fields.get (1) + "\")",
	0, map.index ((String)user_fields.get (1)));

}
catch (Exception exception)
{
System.out.println
	("!!!!: Unexpected exception: " + exception);
checker.Checks_Total++;
}

System.out.println
	("Checks: " + checker.Checks_Total + '\n'
	+"Passed: " + checker.Checks_Passed);

System.exit (checker.Checks_Total - checker.Checks_Passed);
}
}
